/************************************************************************
*FILE: MarginWidget2DBase.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(MarginWidget2DBase_h)
#define MarginWidget2DBase_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/Rtti/Rtti.h>
#include <Widgets/2D/BaseWidget2D.h>
// ------------------------------------------------------------------------
//! [MarginWidget2DBase_Declaration]
class MarginWidget2DBase : public ::BaseWidget2D
{
    public:
        typedef ::FeatStd::Float MarginLeftType;

        typedef ::FeatStd::Float MarginTopType;

        typedef ::FeatStd::Float MarginRightType;

        typedef ::FeatStd::Float MarginBottomType;

        //! [Property_IDs]
        static const FeatStd::UInt32 MarginLeftPropertyId = 0xC7C2E6CB;
        static const FeatStd::UInt32 MarginTopPropertyId = 0xBB4C72FA;
        static const FeatStd::UInt32 MarginRightPropertyId = 0xF5A13305;
        static const FeatStd::UInt32 MarginBottomPropertyId = 0x22BDF5D7;
        //! [Property_IDs]

        MarginWidget2DBase();
        virtual ~MarginWidget2DBase();

        CGI_WIDGET_RTTI_DECLARATION(MarginWidget2DBase, ::BaseWidget2D);

        void SetMarginLeft(const MarginLeftType& marginleft);
        const MarginLeftType& GetMarginLeft() const { return m_MarginLeft; }

        void SetMarginTop(const MarginTopType& margintop);
        const MarginTopType& GetMarginTop() const { return m_MarginTop; }

        void SetMarginRight(const MarginRightType& marginright);
        const MarginRightType& GetMarginRight() const { return m_MarginRight; }

        void SetMarginBottom(const MarginBottomType& marginbottom);
        const MarginBottomType& GetMarginBottom() const { return m_MarginBottom; }

        // @WidgetBaseClass
        CdaWidget2DDef(MarginWidget2DBase, ::BaseWidget2D)
            CdaDescription("Controls the margin properties of a node. To be able to animate different margins a property for each margin is provided")
            CdaReadableName("MarginWidget2DBase")
            CdaCategory("Layout")

            CdaProperties()
                CdaProperty(MarginLeft, MarginLeftType, GetMarginLeft, SetMarginLeft)
                    CdaDescription("Left margin of attached node.")
                CdaPropertyEnd()
                CdaProperty(MarginTop, MarginTopType, GetMarginTop, SetMarginTop)
                    CdaDescription("Top margin of attached node")
                CdaPropertyEnd()
                CdaProperty(MarginRight, MarginRightType, GetMarginRight, SetMarginRight)
                    CdaDescription("Right margin of attached node")
                CdaPropertyEnd()
                CdaProperty(MarginBottom, MarginBottomType, GetMarginBottom, SetMarginBottom)
                    CdaDescription("Button margin of attached node")
                CdaPropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:

    private:
        MarginLeftType m_MarginLeft;
        MarginTopType m_MarginTop;
        MarginRightType m_MarginRight;
        MarginBottomType m_MarginBottom;
};

#endif // MarginWidget2DBase_h
