/************************************************************************
*FILE: GizmoWidget2DBase.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(hmibase_widget_gizmo_GizmoWidget2DBase_h)
#define hmibase_widget_gizmo_GizmoWidget2DBase_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/Rtti/Rtti.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Widgets/2D/Gizmo/generated/GizmoWidget2DMessages.h>
#include <Widgets/2D/Touchable2D.h>

namespace hmibase {
} // namespace hmibase
namespace hmibase {
namespace widget {
namespace gizmo {
// ------------------------------------------------------------------------
//! [GizmoWidget2DBase_Declaration]
class GizmoWidget2DBase : public ::Touchable2D
{
    public:
          virtual bool isPositionPropertyVisible() const { return false; }
          virtual bool isSizePropertyVisible() const { return false; }
          virtual bool isRotationPropertyVisible() const { return false; }
        typedef Candera::Vector2 PositionType;

        typedef Candera::Rectangle LimitAreaType;

        typedef Candera::Vector2 SizeType;

        typedef Candera::Vector2 MinimumSizeType;

        typedef Candera::Vector2 MaximumSizeType;

        typedef Candera::Float RotationType;

        typedef Candera::UInt ColorIndexType;

        typedef Candera::ArrayProperty<Candera::Color> ColorsType;

        typedef Candera::ArrayProperty<Candera::Node2D*> NodesType;

        typedef Candera::ArrayProperty<Candera::UInt8> GizmoEditModesType;

        //! [Property_IDs]
        static const FeatStd::UInt32 PositionPropertyId = 0x0C928991;
        static const FeatStd::UInt32 LimitAreaPropertyId = 0xBE6CD831;
        static const FeatStd::UInt32 SizePropertyId = 0xD1E4788A;
        static const FeatStd::UInt32 MinimumSizePropertyId = 0xF865B355;
        static const FeatStd::UInt32 MaximumSizePropertyId = 0x0D3901B8;
        static const FeatStd::UInt32 RotationPropertyId = 0x8D559FAF;
        static const FeatStd::UInt32 ColorIndexPropertyId = 0x66B6244A;
        static const FeatStd::UInt32 ColorsPropertyId = 0x2B020DDD;
        static const FeatStd::UInt32 NodesPropertyId = 0x2FEEA5D2;
        static const FeatStd::UInt32 GizmoEditModesPropertyId = 0x9C1AFFC5;
        //! [Property_IDs]

        GizmoWidget2DBase();
        virtual ~GizmoWidget2DBase();

        CGI_WIDGET_RTTI_DECLARATION(GizmoWidget2DBase, ::Touchable2D);

        //! [DataBinding_PositionPropertyGetterSetter]
        void SetPosition(const PositionType& position);
        const PositionType& GetPosition() const { return m_Position; }
        //! [DataBinding_PositionPropertyGetterSetter]

        //! [DataBinding_LimitAreaPropertyGetterSetter]
        void SetLimitArea(const LimitAreaType& limitarea);
        const LimitAreaType& GetLimitArea() const { return m_LimitArea; }
        //! [DataBinding_LimitAreaPropertyGetterSetter]

        //! [DataBinding_SizePropertyGetterSetter]
        void SetSize(const SizeType& size);
        const SizeType& GetSize() const { return m_Size; }
        //! [DataBinding_SizePropertyGetterSetter]

        //! [DataBinding_MinimumSizePropertyGetterSetter]
        void SetMinimumSize(const MinimumSizeType& minimumsize);
        const MinimumSizeType& GetMinimumSize() const { return m_MinimumSize; }
        //! [DataBinding_MinimumSizePropertyGetterSetter]

        //! [DataBinding_MaximumSizePropertyGetterSetter]
        void SetMaximumSize(const MaximumSizeType& maximumsize);
        const MaximumSizeType& GetMaximumSize() const { return m_MaximumSize; }
        //! [DataBinding_MaximumSizePropertyGetterSetter]

        //! [DataBinding_RotationPropertyGetterSetter]
        void SetRotation(const RotationType& rotation);
        const RotationType& GetRotation() const { return m_Rotation; }
        //! [DataBinding_RotationPropertyGetterSetter]

        //! [DataBinding_ColorIndexPropertyGetterSetter]
        void SetColorIndex(const ColorIndexType& colorindex);
        const ColorIndexType& GetColorIndex() const { return m_ColorIndex; }
        //! [DataBinding_ColorIndexPropertyGetterSetter]

        //! [DataBinding_ColorsPropertyGetterSetter]
        void SetColors(const ColorsType& colors);
        const ColorsType& GetColors() const { return m_Colors; }
        //! [DataBinding_ColorsPropertyGetterSetter]

        //! [DataBinding_NodesPropertyGetterSetter]
        void SetNodes(const NodesType& nodes);
        const NodesType& GetNodes() const { return m_Nodes; }
        NodesType& GetNodes() { return m_Nodes; }
        //! [DataBinding_NodesPropertyGetterSetter]

        //! [DataBinding_GizmoEditModesPropertyGetterSetter]
        void SetGizmoEditModes(const GizmoEditModesType& gizmoeditmodes);
        const GizmoEditModesType& GetGizmoEditModes() const { return m_GizmoEditModes; }
        //! [DataBinding_GizmoEditModesPropertyGetterSetter]

        // @WidgetBaseClass
        CdaWidget2DDef(GizmoWidget2DBase, ::Touchable2D)
            CdaDescription("Provides support to move, resize and rotate nodes.\n This is a delegate widget and its behavior is controlled by a widget controller attached using the property ControllerId.\n The default gizmo controller uses the gizmo nodes from the property Nodes which are configured with the property GizmoEditModes (these 2 array properties need to have the same number of entries because there is a one to one mapping between gizmo nodes and gizmo edit modes).\n Two colors are used by the default gizmo controller: 1st color is set on gizmo nodes when no node is touched, 2nd color is used when at least one node is touched. \n Rotation is not supported together with move and resize by the default gizmo controller.")
            CdaReadableName("GizmoWidget2DBase")
            CdaCategory("Gesture")

            CdaProperties()
                CdaBindableProperty(Position, PositionType, GetPosition, SetPosition)
                    CdaDescription("Position of the node.")
                    CdaVisibilityTest(isPositionPropertyVisible)
                    CdaCategory("Gizmo")
                CdaBindablePropertyEnd()
                CdaBindableProperty(LimitArea, LimitAreaType, GetLimitArea, SetLimitArea)
                    CdaDescription("Limits the movement and the size of the node.")
                    CdaVisibilityTest(isPositionPropertyVisible)
                    CdaCategory("Gizmo")
                CdaBindablePropertyEnd()
                CdaBindableProperty(Size, SizeType, GetSize, SetSize)
                    CdaDescription("Size of the node. The node must have StretchBehaviour set to Fill.")
                    CdaVisibilityTest(isSizePropertyVisible)
                    CdaCategory("Gizmo")
                CdaBindablePropertyEnd()
                CdaBindableProperty(MinimumSize, MinimumSizeType, GetMinimumSize, SetMinimumSize)
                    CdaDescription("Minimum size of the node.")
                    CdaVisibilityTest(isSizePropertyVisible)
                    CdaCategory("Gizmo")
                CdaBindablePropertyEnd()
                CdaBindableProperty(MaximumSize, MaximumSizeType, GetMaximumSize, SetMaximumSize)
                    CdaDescription("Maximum size of the node.")
                    CdaVisibilityTest(isSizePropertyVisible)
                    CdaCategory("Gizmo")
                CdaBindablePropertyEnd()
                CdaBindableProperty(Rotation, RotationType, GetRotation, SetRotation)
                    CdaDescription("Rotation of the node. In order to have the rotation against the center of the node the PivotOffset must be set accordingly.")
                    CdaVisibilityTest(isRotationPropertyVisible)
                    CdaCategory("Gizmo")
                CdaBindablePropertyEnd()
                CdaBindableProperty(ColorIndex, ColorIndexType, GetColorIndex, SetColorIndex)
                    CdaDescription("Index of the color to be used if the gizmo is not pressed.")
                    CdaCategory("Gizmo")
                CdaBindablePropertyEnd()
                CdaBindableProperty(Colors, ColorsType, GetColors, SetColors)
                    CdaDescription("Colors used for different states (normal, pressed, warning, etc).")
                    CdaCategory("Gizmo")
                CdaBindablePropertyEnd()
                CdaBindableProperty(Nodes, NodesType, GetNodes, SetNodes)
                    CdaDescription("Each node should have an edit mode associated by property GizmoEditMode. See the widget tooltip.")
                    CdaCategory("Gizmo")
                CdaBindablePropertyEnd()
                CdaBindableProperty(GizmoEditModes, GizmoEditModesType, GetGizmoEditModes, SetGizmoEditModes)
                    CdaDescription("Edit modes used for the gizmo nodes. The enum array properties are not working due to a bug in SceneComposer so we have to use integers.\n 0 - None\n 1 - DragTranslateX\n 3 - DragTranslateY\n 5 - DragResizeRight\n 6 - DragResizeLeft\n 7 - DragResizeBottom\n 8 - DragResizeTop\n 9 - DragRotateClockwise\n10 - DragRotateAntiClockwise\n11 - PinchSpreadX\n12 - PinchSpreadY")
                    CdaCategory("Gizmo")
                CdaBindablePropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:

    private:
        PositionType m_Position;
        LimitAreaType m_LimitArea;
        SizeType m_Size;
        MinimumSizeType m_MinimumSize;
        MaximumSizeType m_MaximumSize;
        RotationType m_Rotation;
        ColorIndexType m_ColorIndex;
        ColorsType m_Colors;
        NodesType m_Nodes;
        GizmoEditModesType m_GizmoEditModes;
};
} // namespace gizmo
} // namespace widget
} // namespace hmibase

#endif // hmibase_widget_gizmo_GizmoWidget2DBase_h
