/************************************************************************
*FILE: DropDownListWidget2DBase.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(DropDownListWidget2DBase_h)
#define DropDownListWidget2DBase_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/Rtti/Rtti.h>
#include <Widgets/2D/List/generated/ListWidget2DBase.h>
#include <Widgets/2D/DropDownList/generated/DropDownListMessages.h>
#include <Widgets/2D/List/ListWidget2D.h>
// ------------------------------------------------------------------------
//! [DropDownListWidget2DBase_Declaration]
class DropDownListWidget2DBase : public ::ListWidget2D
{
    public:
        typedef Candera::Node2D* ButtonNodeType;

        typedef Candera::Node2D* ContentNodeType;

        typedef Candera::Node2D* ListNodeType;

        typedef bool UseListPositionType;

        typedef ::Candera::Vector2 ListPositionType;

        typedef ::Candera::Vector2 ListSizeType;

        //! [Property_IDs]
        static const FeatStd::UInt32 ButtonNodePropertyId = 0x4C75F1AE;
        static const FeatStd::UInt32 ContentNodePropertyId = 0x53B2E56E;
        static const FeatStd::UInt32 ListNodePropertyId = 0x01FC080D;
        static const FeatStd::UInt32 UseListPositionPropertyId = 0x43BF28B8;
        static const FeatStd::UInt32 ListPositionPropertyId = 0xFA6245BF;
        static const FeatStd::UInt32 ListSizePropertyId = 0x895F9684;
        //! [Property_IDs]

        DropDownListWidget2DBase();
        virtual ~DropDownListWidget2DBase();

        CGI_WIDGET_RTTI_DECLARATION(DropDownListWidget2DBase, ::ListWidget2D);

        void SetButtonNode(const ButtonNodeType& buttonnode);
        const ButtonNodeType& GetButtonNode() const { return m_ButtonNode; }

        void SetContentNode(const ContentNodeType& contentnode);
        const ContentNodeType& GetContentNode() const { return m_ContentNode; }

        void SetListNode(const ListNodeType& listnode);
        const ListNodeType& GetListNode() const { return m_ListNode; }

        void SetUseListPosition(const UseListPositionType& uselistposition);
        const UseListPositionType& GetUseListPosition() const { return m_UseListPosition; }

        void SetListPosition(const ListPositionType& listposition);
        const ListPositionType& GetListPosition() const { return m_ListPosition; }

        void SetListSize(const ListSizeType& listsize);
        const ListSizeType& GetListSize() const { return m_ListSize; }

        // @WidgetBaseClass
        CdaWidget2DDef(DropDownListWidget2DBase, ::ListWidget2D)
            CdaDescription("DropDownListWidget2D widget")
            CdaReadableName("DropDownListWidget2DBase")
            CdaCategory("List")

            CdaProperties()
                CdaProperty(ButtonNode, ButtonNodeType, GetButtonNode, SetButtonNode)
                    CdaDescription("The node acting as a button and when pressed will open the drop down list.")
                CdaPropertyEnd()
                CdaProperty(ContentNode, ContentNodeType, GetContentNode, SetContentNode)
                    CdaDescription("The node containing the selected item.")
                CdaPropertyEnd()
                CdaProperty(ListNode, ListNodeType, GetListNode, SetListNode)
                    CdaDescription("The node containing the dropdown list.")
                CdaPropertyEnd()
                CdaProperty(UseListPosition, UseListPositionType, GetUseListPosition, SetUseListPosition)
                    CdaDescription("If set to true, sets the position given by ListPosition property for the ListNode. If set to false, it uses the position set by the layouter.")
                CdaPropertyEnd()
                CdaProperty(ListPosition, ListPositionType, GetListPosition, SetListPosition)
                    CdaDescription("Value to be set for ListNode if UserListPosition is true.")
                CdaPropertyEnd()
                CdaProperty(ListSize, ListSizeType, GetListSize, SetListSize)
                    CdaDescription("The size to be set for the ListNode.")
                CdaPropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:

    private:
        ButtonNodeType m_ButtonNode;
        ContentNodeType m_ContentNode;
        ListNodeType m_ListNode;
        UseListPositionType m_UseListPosition;
        ListPositionType m_ListPosition;
        ListSizeType m_ListSize;
};

#endif // DropDownListWidget2DBase_h
