/************************************************************************
*FILE: ComboBoxWidget2DBase.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(hmibase_widget_combobox_ComboBoxWidget2DBase_h)
#define hmibase_widget_combobox_ComboBoxWidget2DBase_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/Rtti/Rtti.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Widgets/2D/ComboBox/generated/ComboBoxWidget2DMessages.h>
#include <Widgets/2D/Touchable2D.h>

namespace hmibase {
} // namespace hmibase
namespace hmibase {
namespace widget {
namespace combobox {
// ------------------------------------------------------------------------
//! [ComboBoxWidget2DBase_Declaration]
class ComboBoxWidget2DBase : public ::Touchable2D
{
    public:
        typedef ::Courier::UInt32 ComboBoxIdType;

        typedef Candera::Node2D* ButtonNodeType;

        typedef Candera::Node2D* ContentNodeType;

        typedef ::Candera::Vector2 ContentSizeType;

        typedef Candera::Node2D* ViewportNodeType;

        //! [Property_IDs]
        static const FeatStd::UInt32 ComboBoxIdPropertyId = 0xE31FAC9E;
        static const FeatStd::UInt32 ButtonNodePropertyId = 0x4C75F1AE;
        static const FeatStd::UInt32 ContentNodePropertyId = 0x53B2E56E;
        static const FeatStd::UInt32 ContentSizePropertyId = 0xEF241F69;
        static const FeatStd::UInt32 ViewportNodePropertyId = 0x204F7FA7;
        //! [Property_IDs]

        ComboBoxWidget2DBase();
        virtual ~ComboBoxWidget2DBase();

        CGI_WIDGET_RTTI_DECLARATION(ComboBoxWidget2DBase, ::Touchable2D);

        //! [DataBinding_ComboBoxIdPropertyGetterSetter]
        void SetComboBoxId(const ComboBoxIdType& comboboxid);
        const ComboBoxIdType& GetComboBoxId() const { return m_ComboBoxId; }
        //! [DataBinding_ComboBoxIdPropertyGetterSetter]

        void SetButtonNode(const ButtonNodeType& buttonnode);
        const ButtonNodeType& GetButtonNode() const { return m_ButtonNode; }

        void SetContentNode(const ContentNodeType& contentnode);
        const ContentNodeType& GetContentNode() const { return m_ContentNode; }

        //! [DataBinding_ContentSizePropertyGetterSetter]
        void SetContentSize(const ContentSizeType& contentsize);
        const ContentSizeType& GetContentSize() const { return m_ContentSize; }
        //! [DataBinding_ContentSizePropertyGetterSetter]

        void SetViewportNode(const ViewportNodeType& viewportnode);
        const ViewportNodeType& GetViewportNode() const { return m_ViewportNode; }

        // @WidgetBaseClass
        CdaWidget2DDef(ComboBoxWidget2DBase, ::Touchable2D)
            CdaDescription("Provides support to implement comboboxes which are combination between a button (or other touchable item) and a drop down panel")
            CdaReadableName("ComboBoxWidget2D")
            CdaCategory("Under construction")

            CdaProperties()
                CdaBindableProperty(ComboBoxId, ComboBoxIdType, GetComboBoxId, SetComboBoxId)
                    CdaDescription("A unique identifier of the combo box.")
                CdaBindablePropertyEnd()
                CdaProperty(ButtonNode, ButtonNodeType, GetButtonNode, SetButtonNode)
                    CdaDescription("The node acting as a selection button and when it is pressed, content of the combo box will be open/closed. ")
                CdaPropertyEnd()
                CdaProperty(ContentNode, ContentNodeType, GetContentNode, SetContentNode)
                    CdaDescription("The node containing the actual content of the combobox. This node should have additional group node (For layouting purpose), where contents like button, text, bg shall be added.Don't use any layouters on the content node as widget will overrite with its custom layouter. Also make sure ArabicLayouterPatchWidget should be added in the scene for layouting the content node correctly")
                CdaPropertyEnd()
                CdaBindableProperty(ContentSize, ContentSizeType, GetContentSize, SetContentSize)
                    CdaDescription("The size to be set for the content node [Total size of drondown panel]. For example, adding 3 button inside the drop down panel where each button size is (W*H) 200*50 then total size to be set on the property is  200*150")
                CdaBindablePropertyEnd()
                CdaProperty(ViewportNode, ViewportNodeType, GetViewportNode, SetViewportNode)
                    CdaDescription("The node is mapped to list node. In order to properly position the content of the combo box above or below the combox box button its requited to know the available space in the viewport hence the list node should be mapped to viewport node.")
                CdaPropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:

    private:
        ComboBoxIdType m_ComboBoxId;
        ButtonNodeType m_ButtonNode;
        ContentNodeType m_ContentNode;
        ContentSizeType m_ContentSize;
        ViewportNodeType m_ViewportNode;
};
} // namespace combobox
} // namespace widget
} // namespace hmibase

#endif // hmibase_widget_combobox_ComboBoxWidget2DBase_h
