/************************************************************************
*FILE: ColorSwitchWidget2DBase.cpp 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ***************************************************************************************
 * FILE:          Generated intermediate file from HMIContract.exe
 * SW-COMPONENT:  HMI-BASE
 *  DESCRIPTION:  This file is part of HMI-Base Widget Library 
 *    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
 *
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */
#include "widget2D_std_if.h"

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#include "ColorSwitchWidget2DBase.h"

namespace hmibase {
} // namespace hmibase

namespace hmibase {
namespace widget {
namespace color {
// ------------------------------------------------------------------------
CGI_WIDGET_RTTI_DEFINITION(ColorSwitchWidget2DBase)

ColorSwitchWidget2DBase::ColorSwitchWidget2DBase() :
    m_Target(TargetType()),
    m_IndexSource(IndexSourceType()),
    m_Index(IndexType()),
    m_StateFlags(enStateFlags::Enabled),
    m_Colors(ColorsType())
{
}

ColorSwitchWidget2DBase::~ColorSwitchWidget2DBase()
{
}

void ColorSwitchWidget2DBase::SetTarget(const TargetType& target)
{
    if (m_Target != target) {
        m_Target = target;
        OnChanged(static_cast< ::FeatStd::UInt32>(TargetPropertyId));
    }
}

void ColorSwitchWidget2DBase::SetIndexSource(const IndexSourceType& indexsource)
{
    if (m_IndexSource != indexsource) {
        m_IndexSource = indexsource;
        OnChanged(static_cast< ::FeatStd::UInt32>(IndexSourcePropertyId));
    }
}

void ColorSwitchWidget2DBase::SetIndex(const IndexType& index)
{
    if (m_Index != index) {
        m_Index = index;
        OnChanged(static_cast< ::FeatStd::UInt32>(IndexPropertyId));
    }
}

void ColorSwitchWidget2DBase::SetStateFlags(const StateFlagsType& stateflags)
{
    if (m_StateFlags != stateflags) {
        m_StateFlags = stateflags;
        OnChanged(static_cast< ::FeatStd::UInt32>(StateFlagsPropertyId));
    }
}

void ColorSwitchWidget2DBase::SetColors(const ColorsType& colors)
{
    m_Colors = colors;
    OnChanged(static_cast< ::FeatStd::UInt32>(ColorsPropertyId));
}
} // namespace color
} // namespace widget
} // namespace hmibase
