/************************************************************************
*FILE: ColorBarWidget2DBase.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(ColorBarWidget2DBase_h)
#define ColorBarWidget2DBase_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/Rtti/Rtti.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Widgets/2D/BaseWidget2D.h>
#include <Widgets/2D/ColorBar/generated/ColorBarMessages.h>
#define ENUM_DATA_TYPE \
   ENUM_DATA_TYPE_BEGIN(ColorBarOrientation)    \
   ENUM_DATA_TYPE_ITEM(HorizontalBar)  \
   ENUM_DATA_TYPE_ITEM(VerticalBar)   \
   ENUM_DATA_TYPE_END(ColorBarOrientation)
CANDERA_SUPPRESS_LINT_FOR_NEXT_EXPRESSION(451, "Defining enum with MetaInfo.")
#include <Candera/System/MetaInfo/EnumDataType.h>
// ------------------------------------------------------------------------
//! [ColorBarWidget2DBase_Declaration]
class ColorBarWidget2DBase : public ::BaseWidget2D
{
    public:
        typedef ::Candera::UInt32 IdType;

        typedef Candera::ArrayProperty<Candera::Color> ColorsType;

        typedef Candera::ArrayProperty<Candera::UInt32> LengthsType;

        typedef Candera::ColorBarOrientation OrientationType;

        //! [Property_IDs]
        static const FeatStd::UInt32 IdPropertyId = 0xE30A73B2;
        static const FeatStd::UInt32 ColorsPropertyId = 0x2B020DDD;
        static const FeatStd::UInt32 LengthsPropertyId = 0x20F773F2;
        static const FeatStd::UInt32 OrientationPropertyId = 0x21DFA0BA;
        //! [Property_IDs]

        ColorBarWidget2DBase();
        virtual ~ColorBarWidget2DBase();

        CGI_WIDGET_RTTI_DECLARATION(ColorBarWidget2DBase, ::BaseWidget2D);

        //! [DataBinding_IdPropertyGetterSetter]
        void SetId(const IdType& id);
        const IdType& GetId() const { return m_Id; }
        //! [DataBinding_IdPropertyGetterSetter]

        //! [DataBinding_ColorsPropertyGetterSetter]
        void SetColors(const ColorsType& colors);
        const ColorsType& GetColors() const { return m_Colors; }
        //! [DataBinding_ColorsPropertyGetterSetter]

        //! [DataBinding_LengthsPropertyGetterSetter]
        void SetLengths(const LengthsType& lengths);
        const LengthsType& GetLengths() const { return m_Lengths; }
        //! [DataBinding_LengthsPropertyGetterSetter]

        void SetOrientation(const OrientationType& orientation);
        const OrientationType& GetOrientation() const { return m_Orientation; }

        // @WidgetBaseClass
        CdaWidget2DDef(ColorBarWidget2DBase, ::BaseWidget2D)
            CdaDescription("Provides support for a horizontal or a vertical color bar. The color bar thickness is 1 pixel (use node scale or stretch to achieve a different thickness) and its length is the sum of all segments length. Each segment is defined by a length and a color.")
            CdaReadableName("ColorBarWidget2DBase")
            CdaCategory("Common")

            CdaProperties()
                CdaBindableProperty(Id, IdType, GetId, SetId)
                    CdaDescription("Setup the Id of this Color Bar, it is used to match the Widget and ColorBarDataUpdMsg")
                CdaBindablePropertyEnd()
                CdaBindableProperty(Colors, ColorsType, GetColors, SetColors)
                    CdaDescription("Colors used for segments")
                CdaBindablePropertyEnd()
                CdaBindableProperty(Lengths, LengthsType, GetLengths, SetLengths)
                    CdaDescription("Lengths used for segments")
                CdaBindablePropertyEnd()
                CdaProperty(Orientation, OrientationType, GetOrientation, SetOrientation)
                    CdaDescription("Setup the orientation of color bar, should be vertical or horizontal")
                CdaPropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:

    private:
        IdType m_Id;
        ColorsType m_Colors;
        LengthsType m_Lengths;
        OrientationType m_Orientation;
};

#endif // ColorBarWidget2DBase_h
