/************************************************************************
*FILE: ColorBarMessages.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(ColorBarMessages_h)
#define ColorBarMessages_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Courier/Messaging/Message.h>
#include <Widgets/generated/BaseWidgetMessages.h>
#include <Courier/Version.h>
#include <Candera/EngineBase/Common/Color.h>

struct tColorBarSegment
{
   Candera::Color color;
   Candera::UInt32 length;
   explicit tColorBarSegment(::Candera::Float redValue, ::Candera::Float greenValue, ::Candera::Float blueValue, ::Candera::Float alphaValue, Candera::UInt32 len)
   {
      color.Set(redValue, greenValue, blueValue, alphaValue);
      length = len;
   }
   explicit tColorBarSegment(::Candera::Float redValue, ::Candera::Float greenValue, ::Candera::Float blueValue, Candera::UInt32 len)
   {
      color.Set(redValue, greenValue, blueValue, 1.0f);
      length = len;
   }
};

class tColorBarData
{
public:
    tColorBarData() {}

    void Add(const tColorBarSegment& item)
    {
        vec.push_back(item);
    }

    ::Candera::UInt32 GetCount() const 
    {
        return vec.size();
    }    

    tColorBarSegment & Get(const ::Candera::UInt32 index) 
    {
        return vec[index];
    }

    static Candera::MemoryManagement::SharedPointer<tColorBarData> Create();

    CANDERA_SHARED_POINTER_DECLARATION();

    FEATSTD_TYPEDEF_SHARED_POINTER(tColorBarData);

private:
    std::vector < tColorBarSegment > vec;
};

typedef Candera::MemoryManagement::SharedPointer<tColorBarData>  tColorBarDataPtr;

inline /*static*/ tColorBarDataPtr tColorBarData::Create()
{
    return tColorBarDataPtr(new tColorBarData);
}

#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
namespace FeatStd {
    template<> ::FeatStd::UInt32 StringBufferAppender< ::tColorBarDataPtr >::Append(::FeatStd::StringBuffer& stringBuffer, tColorBarDataPtr const & object);
};
#endif 
// ------------------------------------------------------------------------
        /* Response from DataModel.
         *  
         * Properties:
         *   Id:           Define the id of bar item 
         *   Data:         The data array, define the color and length of each bar
         */
class ColorBarDataUpdMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ColorBarDataUpdMsg, ::Courier::Message, 0x7A4CAA43);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ColorBarDataUpdMsg(::Candera::UInt32 const & aId, tColorBarDataPtr const & aData);
        virtual ~ColorBarDataUpdMsg();

        ::Candera::UInt32 const & GetId() const { return mId; }
        void SetId(::Candera::UInt32 const & value) { mId = value; }
        tColorBarDataPtr const & GetData() const { return mData; }
        void SetData(tColorBarDataPtr const & value) { mData = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ColorBarDataUpdMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mColorBarDataUpdMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mColorBarDataUpdMsgModifiableMetadata;
        static const ::Courier::ComponentId mColorBarDataUpdMsgSubscriberList[];

        ::Candera::UInt32 mId;
        tColorBarDataPtr mData;
};

#endif // ColorBarMessages_h
