/************************************************************************
*FILE: CameraControlWidget2DBase.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(CameraControlWidget2DBase_h)
#define CameraControlWidget2DBase_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/Rtti/Rtti.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Widgets/2D/BaseWidget2D.h>
// ------------------------------------------------------------------------
//! [CameraControlWidget2DBase_Declaration]
class CameraControlWidget2DBase : public ::BaseWidget2D
{
    public:
        typedef bool ViewportEnabledType;

        typedef Candera::Rectangle ViewportType;

        typedef bool UseForTouchEnabledType;

        typedef bool UseForTouchType;

        //! [Property_IDs]
        static const FeatStd::UInt32 ViewportPropertyId = 0xC88B86C3;
        static const FeatStd::UInt32 UseForTouchPropertyId = 0x1DB0A0AE;
        //! [Property_IDs]

        CameraControlWidget2DBase();
        virtual ~CameraControlWidget2DBase();

        CGI_WIDGET_RTTI_DECLARATION(CameraControlWidget2DBase, ::BaseWidget2D);

        void SetViewportEnabled(const ViewportEnabledType& viewportenabled);
        const ViewportEnabledType& GetViewportEnabled() const { return m_ViewportEnabled; }

        //! [DataBinding_ViewportPropertyGetterSetter]
        void SetViewport(const ViewportType& viewport);
        const ViewportType& GetViewport() const { return m_Viewport; }
        //! [DataBinding_ViewportPropertyGetterSetter]

        void SetUseForTouchEnabled(const UseForTouchEnabledType& usefortouchenabled);
        const UseForTouchEnabledType& GetUseForTouchEnabled() const { return m_UseForTouchEnabled; }

        //! [DataBinding_UseForTouchPropertyGetterSetter]
        void SetUseForTouch(const UseForTouchType& usefortouch);
        const UseForTouchType& GetUseForTouch() const { return m_UseForTouch; }
        //! [DataBinding_UseForTouchPropertyGetterSetter]

        // @WidgetBaseClass
        CdaWidget2DDef(CameraControlWidget2DBase, ::BaseWidget2D)
            CdaDescription("Controls the properties of a camera allowing to expose them outside composites or to change them using data binding sources.")
            CdaReadableName("CameraControlWidget2DBase")
            CdaCategory("Common")

            CdaProperties()
                CdaProperty(ViewportEnabled, ViewportEnabledType, GetViewportEnabled, SetViewportEnabled)
                    CdaDescription("Enables the configuration of the camera property Viewport.")
                CdaPropertyEnd()
                CdaBindableProperty(Viewport, ViewportType, GetViewport, SetViewport)
                    CdaDescription("Sets the Viewport property of the associated camera.")
                    CdaVisibilityTest(GetViewportEnabled)
                CdaBindablePropertyEnd()
                CdaProperty(UseForTouchEnabled, UseForTouchEnabledType, GetUseForTouchEnabled, SetUseForTouchEnabled)
                    CdaDescription("Enables the configuration of the camera internal property UseForTouch.")
                CdaPropertyEnd()
                CdaBindableProperty(UseForTouch, UseForTouchType, GetUseForTouch, SetUseForTouch)
                    CdaDescription("Enables the associated camera to be used in the beginning of the touch session for checking if the touch coordinates are inside the bounding rectangle of a widget's node.\n Cameras which render into window surfaces usually need to have it enabled.\n Cameras which render into framebuffers need it sometimes disabled to prevent the buttons from being touchable outside their visual position.")
                    CdaVisibilityTest(GetUseForTouchEnabled)
                CdaBindablePropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:

    private:
        ViewportEnabledType m_ViewportEnabled;
        ViewportType m_Viewport;
        UseForTouchEnabledType m_UseForTouchEnabled;
        UseForTouchType m_UseForTouch;
};

#endif // CameraControlWidget2DBase_h
