/************************************************************************
*FILE: ButtonTextWidgets2DBase.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(ButtonTextWidgets2DBase_h)
#define ButtonTextWidgets2DBase_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/Rtti/Rtti.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Widgets/2D/Button/ButtonExtensionWidget2D.h>
// ------------------------------------------------------------------------
//! [ButtonTextColorWidget2DBase_Declaration]
class ButtonTextColorWidget2DBase : public ButtonTextExtensionWidget2D
{
    public:
        typedef bool OutlineColorConfigurationType;

        typedef Candera::Color NormalTextColorType;

        typedef Candera::Color PressedTextColorType;

        typedef Candera::Color DisabledTextColorType;

        typedef Candera::Color PressedDisabledTextColorType;

        typedef Candera::Color ActiveNormalTextColorType;

        typedef Candera::Color ActivePressedTextColorType;

        typedef Candera::Color ActiveDisabledTextColorType;

        typedef Candera::Color ActivePressedDisabledTextColorType;

        typedef Candera::Color FocusedNormalTextColorType;

        typedef Candera::Color FocusedPressedTextColorType;

        typedef Candera::Color FocusedDisabledTextColorType;

        typedef Candera::Color FocusedPressedDisabledTextColorType;

        typedef Candera::Color FocusedActiveNormalTextColorType;

        typedef Candera::Color FocusedActivePressedTextColorType;

        typedef Candera::Color FocusedActiveDisabledTextColorType;

        typedef Candera::Color FocusedActivePressedDisabledTextColorType;

        //! [Property_IDs]
        static const FeatStd::UInt32 OutlineColorConfigurationPropertyId = 0x94D7B74B;
        static const FeatStd::UInt32 NormalTextColorPropertyId = 0x80687832;
        static const FeatStd::UInt32 PressedTextColorPropertyId = 0x764A03C7;
        static const FeatStd::UInt32 DisabledTextColorPropertyId = 0xA2474CE1;
        static const FeatStd::UInt32 PressedDisabledTextColorPropertyId = 0x872F5A12;
        static const FeatStd::UInt32 ActiveNormalTextColorPropertyId = 0x47FA4180;
        static const FeatStd::UInt32 ActivePressedTextColorPropertyId = 0x6D5CB256;
        static const FeatStd::UInt32 ActiveDisabledTextColorPropertyId = 0x9325E449;
        static const FeatStd::UInt32 ActivePressedDisabledTextColorPropertyId = 0xD1DAAC81;
        static const FeatStd::UInt32 FocusedNormalTextColorPropertyId = 0x0AB05D4E;
        static const FeatStd::UInt32 FocusedPressedTextColorPropertyId = 0x4BA68765;
        static const FeatStd::UInt32 FocusedDisabledTextColorPropertyId = 0xA09975A0;
        static const FeatStd::UInt32 FocusedPressedDisabledTextColorPropertyId = 0xAF3787C4;
        static const FeatStd::UInt32 FocusedActiveNormalTextColorPropertyId = 0x109FC86E;
        static const FeatStd::UInt32 FocusedActivePressedTextColorPropertyId = 0x7F39F8E2;
        static const FeatStd::UInt32 FocusedActiveDisabledTextColorPropertyId = 0xB0449295;
        static const FeatStd::UInt32 FocusedActivePressedDisabledTextColorPropertyId = 0x36067B14;
        //! [Property_IDs]

        ButtonTextColorWidget2DBase();
        virtual ~ButtonTextColorWidget2DBase();

        CGI_WIDGET_RTTI_DECLARATION(ButtonTextColorWidget2DBase, ButtonTextExtensionWidget2D);

        //! [DataBinding_OutlineColorConfigurationPropertyGetterSetter]
        void SetOutlineColorConfiguration(const OutlineColorConfigurationType& outlinecolorconfiguration);
        const OutlineColorConfigurationType& GetOutlineColorConfiguration() const { return m_OutlineColorConfiguration; }
        //! [DataBinding_OutlineColorConfigurationPropertyGetterSetter]

        //! [DataBinding_NormalTextColorPropertyGetterSetter]
        void SetNormalTextColor(const NormalTextColorType& normaltextcolor);
        const NormalTextColorType& GetNormalTextColor() const { return m_NormalTextColor; }
        //! [DataBinding_NormalTextColorPropertyGetterSetter]

        //! [DataBinding_PressedTextColorPropertyGetterSetter]
        void SetPressedTextColor(const PressedTextColorType& pressedtextcolor);
        const PressedTextColorType& GetPressedTextColor() const { return m_PressedTextColor; }
        //! [DataBinding_PressedTextColorPropertyGetterSetter]

        //! [DataBinding_DisabledTextColorPropertyGetterSetter]
        void SetDisabledTextColor(const DisabledTextColorType& disabledtextcolor);
        const DisabledTextColorType& GetDisabledTextColor() const { return m_DisabledTextColor; }
        //! [DataBinding_DisabledTextColorPropertyGetterSetter]

        //! [DataBinding_PressedDisabledTextColorPropertyGetterSetter]
        void SetPressedDisabledTextColor(const PressedDisabledTextColorType& presseddisabledtextcolor);
        const PressedDisabledTextColorType& GetPressedDisabledTextColor() const { return m_PressedDisabledTextColor; }
        //! [DataBinding_PressedDisabledTextColorPropertyGetterSetter]

        //! [DataBinding_ActiveNormalTextColorPropertyGetterSetter]
        void SetActiveNormalTextColor(const ActiveNormalTextColorType& activenormaltextcolor);
        const ActiveNormalTextColorType& GetActiveNormalTextColor() const { return m_ActiveNormalTextColor; }
        //! [DataBinding_ActiveNormalTextColorPropertyGetterSetter]

        //! [DataBinding_ActivePressedTextColorPropertyGetterSetter]
        void SetActivePressedTextColor(const ActivePressedTextColorType& activepressedtextcolor);
        const ActivePressedTextColorType& GetActivePressedTextColor() const { return m_ActivePressedTextColor; }
        //! [DataBinding_ActivePressedTextColorPropertyGetterSetter]

        //! [DataBinding_ActiveDisabledTextColorPropertyGetterSetter]
        void SetActiveDisabledTextColor(const ActiveDisabledTextColorType& activedisabledtextcolor);
        const ActiveDisabledTextColorType& GetActiveDisabledTextColor() const { return m_ActiveDisabledTextColor; }
        //! [DataBinding_ActiveDisabledTextColorPropertyGetterSetter]

        //! [DataBinding_ActivePressedDisabledTextColorPropertyGetterSetter]
        void SetActivePressedDisabledTextColor(const ActivePressedDisabledTextColorType& activepresseddisabledtextcolor);
        const ActivePressedDisabledTextColorType& GetActivePressedDisabledTextColor() const { return m_ActivePressedDisabledTextColor; }
        //! [DataBinding_ActivePressedDisabledTextColorPropertyGetterSetter]

        //! [DataBinding_FocusedNormalTextColorPropertyGetterSetter]
        void SetFocusedNormalTextColor(const FocusedNormalTextColorType& focusednormaltextcolor);
        const FocusedNormalTextColorType& GetFocusedNormalTextColor() const { return m_FocusedNormalTextColor; }
        //! [DataBinding_FocusedNormalTextColorPropertyGetterSetter]

        //! [DataBinding_FocusedPressedTextColorPropertyGetterSetter]
        void SetFocusedPressedTextColor(const FocusedPressedTextColorType& focusedpressedtextcolor);
        const FocusedPressedTextColorType& GetFocusedPressedTextColor() const { return m_FocusedPressedTextColor; }
        //! [DataBinding_FocusedPressedTextColorPropertyGetterSetter]

        //! [DataBinding_FocusedDisabledTextColorPropertyGetterSetter]
        void SetFocusedDisabledTextColor(const FocusedDisabledTextColorType& focuseddisabledtextcolor);
        const FocusedDisabledTextColorType& GetFocusedDisabledTextColor() const { return m_FocusedDisabledTextColor; }
        //! [DataBinding_FocusedDisabledTextColorPropertyGetterSetter]

        //! [DataBinding_FocusedPressedDisabledTextColorPropertyGetterSetter]
        void SetFocusedPressedDisabledTextColor(const FocusedPressedDisabledTextColorType& focusedpresseddisabledtextcolor);
        const FocusedPressedDisabledTextColorType& GetFocusedPressedDisabledTextColor() const { return m_FocusedPressedDisabledTextColor; }
        //! [DataBinding_FocusedPressedDisabledTextColorPropertyGetterSetter]

        //! [DataBinding_FocusedActiveNormalTextColorPropertyGetterSetter]
        void SetFocusedActiveNormalTextColor(const FocusedActiveNormalTextColorType& focusedactivenormaltextcolor);
        const FocusedActiveNormalTextColorType& GetFocusedActiveNormalTextColor() const { return m_FocusedActiveNormalTextColor; }
        //! [DataBinding_FocusedActiveNormalTextColorPropertyGetterSetter]

        //! [DataBinding_FocusedActivePressedTextColorPropertyGetterSetter]
        void SetFocusedActivePressedTextColor(const FocusedActivePressedTextColorType& focusedactivepressedtextcolor);
        const FocusedActivePressedTextColorType& GetFocusedActivePressedTextColor() const { return m_FocusedActivePressedTextColor; }
        //! [DataBinding_FocusedActivePressedTextColorPropertyGetterSetter]

        //! [DataBinding_FocusedActiveDisabledTextColorPropertyGetterSetter]
        void SetFocusedActiveDisabledTextColor(const FocusedActiveDisabledTextColorType& focusedactivedisabledtextcolor);
        const FocusedActiveDisabledTextColorType& GetFocusedActiveDisabledTextColor() const { return m_FocusedActiveDisabledTextColor; }
        //! [DataBinding_FocusedActiveDisabledTextColorPropertyGetterSetter]

        //! [DataBinding_FocusedActivePressedDisabledTextColorPropertyGetterSetter]
        void SetFocusedActivePressedDisabledTextColor(const FocusedActivePressedDisabledTextColorType& focusedactivepresseddisabledtextcolor);
        const FocusedActivePressedDisabledTextColorType& GetFocusedActivePressedDisabledTextColor() const { return m_FocusedActivePressedDisabledTextColor; }
        //! [DataBinding_FocusedActivePressedDisabledTextColorPropertyGetterSetter]

        // @WidgetBaseClass
        CdaWidget2DDef(ButtonTextColorWidget2DBase, ButtonTextExtensionWidget2D)
            CdaDescription("Changes the color of a text depending on the button state. This extension widgets uses two more widgets in the same scene: one button widget from which it will get the state and one text widget on which it will set the text color depending on the button state. Those two widgets should be linked to nodes which are ancestors of this widget's node. A particular situation would be when the button widget, the text widget and the button text color widget are linked to the same node.")
            CdaReadableName("ButtonTextColorWidget2DBase")
            CdaCategory("Button")

            CdaProperties()
                CdaBindableProperty(OutlineColorConfiguration, OutlineColorConfigurationType, GetOutlineColorConfiguration, SetOutlineColorConfiguration)
                    CdaDescription("If set to true this widget will configure the outline color property of the text widget instead of the text color. Please refer to the outline effects documentation for information on how to render text with outline.")
                    CdaCategory("TextColor")
                CdaBindablePropertyEnd()
                CdaBindableProperty(NormalTextColor, NormalTextColorType, GetNormalTextColor, SetNormalTextColor)
                    CdaDescription("Text color used when the button is Enabled, not Pressed, not Active and not Focused.")
                    CdaCategory("TextColor")
                CdaBindablePropertyEnd()
                CdaBindableProperty(PressedTextColor, PressedTextColorType, GetPressedTextColor, SetPressedTextColor)
                    CdaDescription("Text color used when the button is Enabled, Pressed, not Active and not Focused.")
                    CdaCategory("TextColor")
                CdaBindablePropertyEnd()
                CdaBindableProperty(DisabledTextColor, DisabledTextColorType, GetDisabledTextColor, SetDisabledTextColor)
                    CdaDescription("Text color used when the button is Disabled, not Pressed, not Active and not Focused.")
                    CdaCategory("TextColor")
                CdaBindablePropertyEnd()
                CdaBindableProperty(PressedDisabledTextColor, PressedDisabledTextColorType, GetPressedDisabledTextColor, SetPressedDisabledTextColor)
                    CdaDescription("Text color used when the button is Disabled, Pressed, not Active and not Focused.")
                    CdaCategory("TextColor")
                CdaBindablePropertyEnd()
                CdaBindableProperty(ActiveNormalTextColor, ActiveNormalTextColorType, GetActiveNormalTextColor, SetActiveNormalTextColor)
                    CdaDescription("Text color used when the button is Enabled, not Pressed, Active and not Focused.")
                    CdaCategory("TextColor")
                CdaBindablePropertyEnd()
                CdaBindableProperty(ActivePressedTextColor, ActivePressedTextColorType, GetActivePressedTextColor, SetActivePressedTextColor)
                    CdaDescription("Text color used when the button is Enabled, Pressed, Active and not Focused.")
                    CdaCategory("TextColor")
                CdaBindablePropertyEnd()
                CdaBindableProperty(ActiveDisabledTextColor, ActiveDisabledTextColorType, GetActiveDisabledTextColor, SetActiveDisabledTextColor)
                    CdaDescription("Text color used when the button is Disabled, not Pressed, Active and not Focused.")
                    CdaCategory("TextColor")
                CdaBindablePropertyEnd()
                CdaBindableProperty(ActivePressedDisabledTextColor, ActivePressedDisabledTextColorType, GetActivePressedDisabledTextColor, SetActivePressedDisabledTextColor)
                    CdaDescription("Text color used when the button is Disabled, Pressed, Active and not Focused.")
                    CdaCategory("TextColor")
                CdaBindablePropertyEnd()
                CdaBindableProperty(FocusedNormalTextColor, FocusedNormalTextColorType, GetFocusedNormalTextColor, SetFocusedNormalTextColor)
                    CdaDescription("Text color used when the button is Enabled, not Pressed, not Active and Focused.")
                    CdaCategory("TextColor")
                CdaBindablePropertyEnd()
                CdaBindableProperty(FocusedPressedTextColor, FocusedPressedTextColorType, GetFocusedPressedTextColor, SetFocusedPressedTextColor)
                    CdaDescription("Text color used when the button is Enabled, Pressed, not Active and Focused.")
                    CdaCategory("TextColor")
                CdaBindablePropertyEnd()
                CdaBindableProperty(FocusedDisabledTextColor, FocusedDisabledTextColorType, GetFocusedDisabledTextColor, SetFocusedDisabledTextColor)
                    CdaDescription("Text color used when the button is Disabled, not Pressed, not Active and Focused.")
                    CdaCategory("TextColor")
                CdaBindablePropertyEnd()
                CdaBindableProperty(FocusedPressedDisabledTextColor, FocusedPressedDisabledTextColorType, GetFocusedPressedDisabledTextColor, SetFocusedPressedDisabledTextColor)
                    CdaDescription("Text color used when the button is Disabled, Pressed, not Active and Focused.")
                    CdaCategory("TextColor")
                CdaBindablePropertyEnd()
                CdaBindableProperty(FocusedActiveNormalTextColor, FocusedActiveNormalTextColorType, GetFocusedActiveNormalTextColor, SetFocusedActiveNormalTextColor)
                    CdaDescription("Text color used when the button is Enabled, not Pressed, Active and Focused.")
                    CdaCategory("TextColor")
                CdaBindablePropertyEnd()
                CdaBindableProperty(FocusedActivePressedTextColor, FocusedActivePressedTextColorType, GetFocusedActivePressedTextColor, SetFocusedActivePressedTextColor)
                    CdaDescription("Text color used when the button is Enabled, Pressed, Active and Focused.")
                    CdaCategory("TextColor")
                CdaBindablePropertyEnd()
                CdaBindableProperty(FocusedActiveDisabledTextColor, FocusedActiveDisabledTextColorType, GetFocusedActiveDisabledTextColor, SetFocusedActiveDisabledTextColor)
                    CdaDescription("Text color used when the button is Disabled, not Pressed,Active and Focused.")
                    CdaCategory("TextColor")
                CdaBindablePropertyEnd()
                CdaBindableProperty(FocusedActivePressedDisabledTextColor, FocusedActivePressedDisabledTextColorType, GetFocusedActivePressedDisabledTextColor, SetFocusedActivePressedDisabledTextColor)
                    CdaDescription("Text color used when the button is Disabled, Pressed, Active and Focused.")
                    CdaCategory("TextColor")
                CdaBindablePropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:

    private:
        OutlineColorConfigurationType m_OutlineColorConfiguration;
        NormalTextColorType m_NormalTextColor;
        PressedTextColorType m_PressedTextColor;
        DisabledTextColorType m_DisabledTextColor;
        PressedDisabledTextColorType m_PressedDisabledTextColor;
        ActiveNormalTextColorType m_ActiveNormalTextColor;
        ActivePressedTextColorType m_ActivePressedTextColor;
        ActiveDisabledTextColorType m_ActiveDisabledTextColor;
        ActivePressedDisabledTextColorType m_ActivePressedDisabledTextColor;
        FocusedNormalTextColorType m_FocusedNormalTextColor;
        FocusedPressedTextColorType m_FocusedPressedTextColor;
        FocusedDisabledTextColorType m_FocusedDisabledTextColor;
        FocusedPressedDisabledTextColorType m_FocusedPressedDisabledTextColor;
        FocusedActiveNormalTextColorType m_FocusedActiveNormalTextColor;
        FocusedActivePressedTextColorType m_FocusedActivePressedTextColor;
        FocusedActiveDisabledTextColorType m_FocusedActiveDisabledTextColor;
        FocusedActivePressedDisabledTextColorType m_FocusedActivePressedDisabledTextColor;
};

// ------------------------------------------------------------------------
//! [ButtonTextScrollWidget2DBase_Declaration]
class ButtonTextScrollWidget2DBase : public ButtonTextExtensionWidget2D
{
    public:
        typedef bool ScrollOnFocusGainType;

        //! [Property_IDs]
        static const FeatStd::UInt32 ScrollOnFocusGainPropertyId = 0x66B28991;
        //! [Property_IDs]

        ButtonTextScrollWidget2DBase();
        virtual ~ButtonTextScrollWidget2DBase();

        CGI_WIDGET_RTTI_DECLARATION(ButtonTextScrollWidget2DBase, ButtonTextExtensionWidget2D);

        //! [DataBinding_ScrollOnFocusGainPropertyGetterSetter]
        void SetScrollOnFocusGain(const ScrollOnFocusGainType& scrollonfocusgain);
        const ScrollOnFocusGainType& GetScrollOnFocusGain() const { return m_ScrollOnFocusGain; }
        //! [DataBinding_ScrollOnFocusGainPropertyGetterSetter]

        // @WidgetBaseClass
        CdaWidget2DDef(ButtonTextScrollWidget2DBase, ButtonTextExtensionWidget2D)
            CdaDescription("Scrolls the text associated with a button widget. This extension widgets uses two more widgets in the same scene: one button widget from which it will get the state and one text widget on which it will set the text scrolling depending on the button state. Those two widgets should be linked to nodes which are ancestors of this widget's node. A particular situation would be when the button widget, the text widget and the button text scroll widget are linked to the same node.")
            CdaReadableName("ButtonTextScrollWidget2DBase")
            CdaCategory("Button")

            CdaProperties()
                CdaBindableProperty(ScrollOnFocusGain, ScrollOnFocusGainType, GetScrollOnFocusGain, SetScrollOnFocusGain)
                    CdaDescription("Starts scrolling the text when the button gains the focus.")
                    CdaCategory("TextScroll")
                CdaBindablePropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:

    private:
        ScrollOnFocusGainType m_ScrollOnFocusGain;
};

#endif // ButtonTextWidgets2DBase_h
