/************************************************************************
*FILE: ButtonImageWidget2DBase.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(ButtonImageWidget2DBase_h)
#define ButtonImageWidget2DBase_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/Rtti/Rtti.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Widgets/2D/Button/ButtonExtensionWidget2D.h>
// ------------------------------------------------------------------------
//! [ButtonImageWidget2DBase_Declaration]
class ButtonImageWidget2DBase : public ButtonExtensionWidget2D
{
    public:
        typedef bool FallbackStrategyEnabledType;

        typedef Candera::MemoryManagement::SharedPointer<Candera::Image2D> NormalBitmapType;

        typedef Candera::MemoryManagement::SharedPointer<Candera::Image2D> PressedBitmapType;

        typedef Candera::MemoryManagement::SharedPointer<Candera::Image2D> DisabledBitmapType;

        typedef Candera::MemoryManagement::SharedPointer<Candera::Image2D> PressedDisabledBitmapType;

        typedef Candera::MemoryManagement::SharedPointer<Candera::Image2D> ActiveNormalBitmapType;

        typedef Candera::MemoryManagement::SharedPointer<Candera::Image2D> ActivePressedBitmapType;

        typedef Candera::MemoryManagement::SharedPointer<Candera::Image2D> ActiveDisabledBitmapType;

        typedef Candera::MemoryManagement::SharedPointer<Candera::Image2D> ActivePressedDisabledBitmapType;

        typedef Candera::MemoryManagement::SharedPointer<Candera::Image2D> FocusedNormalBitmapType;

        typedef Candera::MemoryManagement::SharedPointer<Candera::Image2D> FocusedPressedBitmapType;

        typedef Candera::MemoryManagement::SharedPointer<Candera::Image2D> FocusedDisabledBitmapType;

        typedef Candera::MemoryManagement::SharedPointer<Candera::Image2D> FocusedPressedDisabledBitmapType;

        typedef Candera::MemoryManagement::SharedPointer<Candera::Image2D> FocusedActiveNormalBitmapType;

        typedef Candera::MemoryManagement::SharedPointer<Candera::Image2D> FocusedActivePressedBitmapType;

        typedef Candera::MemoryManagement::SharedPointer<Candera::Image2D> FocusedActiveDisabledBitmapType;

        typedef Candera::MemoryManagement::SharedPointer<Candera::Image2D> FocusedActivePressedDisabledBitmapType;

        //! [Property_IDs]
        static const FeatStd::UInt32 FallbackStrategyEnabledPropertyId = 0x75F28154;
        static const FeatStd::UInt32 NormalBitmapPropertyId = 0x0465C2D8;
        static const FeatStd::UInt32 PressedBitmapPropertyId = 0x4E266A55;
        static const FeatStd::UInt32 DisabledBitmapPropertyId = 0xE382473B;
        static const FeatStd::UInt32 PressedDisabledBitmapPropertyId = 0x639BFBBA;
        static const FeatStd::UInt32 ActiveNormalBitmapPropertyId = 0x4D279890;
        static const FeatStd::UInt32 ActivePressedBitmapPropertyId = 0x45F1DBC3;
        static const FeatStd::UInt32 ActiveDisabledBitmapPropertyId = 0x30E46F94;
        static const FeatStd::UInt32 ActivePressedDisabledBitmapPropertyId = 0x954EA31A;
        static const FeatStd::UInt32 FocusedNormalBitmapPropertyId = 0x5CEB82DC;
        static const FeatStd::UInt32 FocusedPressedBitmapPropertyId = 0xC1E131CE;
        static const FeatStd::UInt32 FocusedDisabledBitmapPropertyId = 0x9F09E267;
        static const FeatStd::UInt32 FocusedPressedDisabledBitmapPropertyId = 0x6E357B7D;
        static const FeatStd::UInt32 FocusedActiveNormalBitmapPropertyId = 0xEED64525;
        static const FeatStd::UInt32 FocusedActivePressedBitmapPropertyId = 0x4EDE34AC;
        static const FeatStd::UInt32 FocusedActiveDisabledBitmapPropertyId = 0x29A2AAD5;
        static const FeatStd::UInt32 FocusedActivePressedDisabledBitmapPropertyId = 0x0DE9DD74;
        //! [Property_IDs]

        ButtonImageWidget2DBase();
        virtual ~ButtonImageWidget2DBase();

        CGI_WIDGET_RTTI_DECLARATION(ButtonImageWidget2DBase, ButtonExtensionWidget2D);

        //! [DataBinding_FallbackStrategyEnabledPropertyGetterSetter]
        void SetFallbackStrategyEnabled(const FallbackStrategyEnabledType& fallbackstrategyenabled);
        const FallbackStrategyEnabledType& GetFallbackStrategyEnabled() const { return m_FallbackStrategyEnabled; }
        //! [DataBinding_FallbackStrategyEnabledPropertyGetterSetter]

        //! [DataBinding_NormalBitmapPropertyGetterSetter]
        void SetNormalBitmap(const NormalBitmapType& normalbitmap);
        const NormalBitmapType& GetNormalBitmap() const { return m_NormalBitmap; }
        //! [DataBinding_NormalBitmapPropertyGetterSetter]

        //! [DataBinding_PressedBitmapPropertyGetterSetter]
        void SetPressedBitmap(const PressedBitmapType& pressedbitmap);
        const PressedBitmapType& GetPressedBitmap() const { return m_PressedBitmap; }
        //! [DataBinding_PressedBitmapPropertyGetterSetter]

        //! [DataBinding_DisabledBitmapPropertyGetterSetter]
        void SetDisabledBitmap(const DisabledBitmapType& disabledbitmap);
        const DisabledBitmapType& GetDisabledBitmap() const { return m_DisabledBitmap; }
        //! [DataBinding_DisabledBitmapPropertyGetterSetter]

        //! [DataBinding_PressedDisabledBitmapPropertyGetterSetter]
        void SetPressedDisabledBitmap(const PressedDisabledBitmapType& presseddisabledbitmap);
        const PressedDisabledBitmapType& GetPressedDisabledBitmap() const { return m_PressedDisabledBitmap; }
        //! [DataBinding_PressedDisabledBitmapPropertyGetterSetter]

        //! [DataBinding_ActiveNormalBitmapPropertyGetterSetter]
        void SetActiveNormalBitmap(const ActiveNormalBitmapType& activenormalbitmap);
        const ActiveNormalBitmapType& GetActiveNormalBitmap() const { return m_ActiveNormalBitmap; }
        //! [DataBinding_ActiveNormalBitmapPropertyGetterSetter]

        //! [DataBinding_ActivePressedBitmapPropertyGetterSetter]
        void SetActivePressedBitmap(const ActivePressedBitmapType& activepressedbitmap);
        const ActivePressedBitmapType& GetActivePressedBitmap() const { return m_ActivePressedBitmap; }
        //! [DataBinding_ActivePressedBitmapPropertyGetterSetter]

        //! [DataBinding_ActiveDisabledBitmapPropertyGetterSetter]
        void SetActiveDisabledBitmap(const ActiveDisabledBitmapType& activedisabledbitmap);
        const ActiveDisabledBitmapType& GetActiveDisabledBitmap() const { return m_ActiveDisabledBitmap; }
        //! [DataBinding_ActiveDisabledBitmapPropertyGetterSetter]

        //! [DataBinding_ActivePressedDisabledBitmapPropertyGetterSetter]
        void SetActivePressedDisabledBitmap(const ActivePressedDisabledBitmapType& activepresseddisabledbitmap);
        const ActivePressedDisabledBitmapType& GetActivePressedDisabledBitmap() const { return m_ActivePressedDisabledBitmap; }
        //! [DataBinding_ActivePressedDisabledBitmapPropertyGetterSetter]

        //! [DataBinding_FocusedNormalBitmapPropertyGetterSetter]
        void SetFocusedNormalBitmap(const FocusedNormalBitmapType& focusednormalbitmap);
        const FocusedNormalBitmapType& GetFocusedNormalBitmap() const { return m_FocusedNormalBitmap; }
        //! [DataBinding_FocusedNormalBitmapPropertyGetterSetter]

        //! [DataBinding_FocusedPressedBitmapPropertyGetterSetter]
        void SetFocusedPressedBitmap(const FocusedPressedBitmapType& focusedpressedbitmap);
        const FocusedPressedBitmapType& GetFocusedPressedBitmap() const { return m_FocusedPressedBitmap; }
        //! [DataBinding_FocusedPressedBitmapPropertyGetterSetter]

        //! [DataBinding_FocusedDisabledBitmapPropertyGetterSetter]
        void SetFocusedDisabledBitmap(const FocusedDisabledBitmapType& focuseddisabledbitmap);
        const FocusedDisabledBitmapType& GetFocusedDisabledBitmap() const { return m_FocusedDisabledBitmap; }
        //! [DataBinding_FocusedDisabledBitmapPropertyGetterSetter]

        //! [DataBinding_FocusedPressedDisabledBitmapPropertyGetterSetter]
        void SetFocusedPressedDisabledBitmap(const FocusedPressedDisabledBitmapType& focusedpresseddisabledbitmap);
        const FocusedPressedDisabledBitmapType& GetFocusedPressedDisabledBitmap() const { return m_FocusedPressedDisabledBitmap; }
        //! [DataBinding_FocusedPressedDisabledBitmapPropertyGetterSetter]

        //! [DataBinding_FocusedActiveNormalBitmapPropertyGetterSetter]
        void SetFocusedActiveNormalBitmap(const FocusedActiveNormalBitmapType& focusedactivenormalbitmap);
        const FocusedActiveNormalBitmapType& GetFocusedActiveNormalBitmap() const { return m_FocusedActiveNormalBitmap; }
        //! [DataBinding_FocusedActiveNormalBitmapPropertyGetterSetter]

        //! [DataBinding_FocusedActivePressedBitmapPropertyGetterSetter]
        void SetFocusedActivePressedBitmap(const FocusedActivePressedBitmapType& focusedactivepressedbitmap);
        const FocusedActivePressedBitmapType& GetFocusedActivePressedBitmap() const { return m_FocusedActivePressedBitmap; }
        //! [DataBinding_FocusedActivePressedBitmapPropertyGetterSetter]

        //! [DataBinding_FocusedActiveDisabledBitmapPropertyGetterSetter]
        void SetFocusedActiveDisabledBitmap(const FocusedActiveDisabledBitmapType& focusedactivedisabledbitmap);
        const FocusedActiveDisabledBitmapType& GetFocusedActiveDisabledBitmap() const { return m_FocusedActiveDisabledBitmap; }
        //! [DataBinding_FocusedActiveDisabledBitmapPropertyGetterSetter]

        //! [DataBinding_FocusedActivePressedDisabledBitmapPropertyGetterSetter]
        void SetFocusedActivePressedDisabledBitmap(const FocusedActivePressedDisabledBitmapType& focusedactivepresseddisabledbitmap);
        const FocusedActivePressedDisabledBitmapType& GetFocusedActivePressedDisabledBitmap() const { return m_FocusedActivePressedDisabledBitmap; }
        //! [DataBinding_FocusedActivePressedDisabledBitmapPropertyGetterSetter]

        // @WidgetBaseClass
        CdaWidget2DDef(ButtonImageWidget2DBase, ButtonExtensionWidget2D)
            CdaDescription("Provides support to create buttons for which the background or the icon reflects the state of that button. This widget should be attached to a bitmap render node and the button widget should be attached to the same node or an ancestor of it.")
            CdaReadableName("ButtonImageWidget2DBase")
            CdaCategory("Button")

            CdaProperties()
                CdaBindableProperty(FallbackStrategyEnabled, FallbackStrategyEnabledType, GetFallbackStrategyEnabled, SetFallbackStrategyEnabled)
                    CdaDescription("The button image checks the bitmap associated with the current state. If that bitmap is not set and the fallback strategy is enabled other bitmap will be used, otherwiase a null bitmap will be set on the bitmap brush. This fallback strategy works as follows: first the Focused flag is ignored, second the Active flag and third the Pressed flag.")
                    CdaCategory("Bitmap")
                CdaBindablePropertyEnd()
                CdaBindableProperty(NormalBitmap, NormalBitmapType, GetNormalBitmap, SetNormalBitmap)
                    CdaDescription("Bitmap used when the button is Enabled, not Pressed, not Active and not Focused.")
                    CdaCategory("Bitmap")
                CdaBindablePropertyEnd()
                CdaBindableProperty(PressedBitmap, PressedBitmapType, GetPressedBitmap, SetPressedBitmap)
                    CdaDescription("Bitmap used when the button is Enabled, Pressed, not Active and not Focused.")
                    CdaCategory("Bitmap")
                CdaBindablePropertyEnd()
                CdaBindableProperty(DisabledBitmap, DisabledBitmapType, GetDisabledBitmap, SetDisabledBitmap)
                    CdaDescription("Bitmap used when the button is Disabled, not Pressed, not Active and not Focused.")
                    CdaCategory("Bitmap")
                CdaBindablePropertyEnd()
                CdaBindableProperty(PressedDisabledBitmap, PressedDisabledBitmapType, GetPressedDisabledBitmap, SetPressedDisabledBitmap)
                    CdaDescription("Bitmap used when the button is Disabled, Pressed, not Active and not Focused.")
                    CdaCategory("Bitmap")
                CdaBindablePropertyEnd()
                CdaBindableProperty(ActiveNormalBitmap, ActiveNormalBitmapType, GetActiveNormalBitmap, SetActiveNormalBitmap)
                    CdaDescription("Bitmap used when the button is Enabled, not Pressed, Active and not Focused.")
                    CdaCategory("Bitmap")
                CdaBindablePropertyEnd()
                CdaBindableProperty(ActivePressedBitmap, ActivePressedBitmapType, GetActivePressedBitmap, SetActivePressedBitmap)
                    CdaDescription("Bitmap used when the button is Enabled, Pressed, Active and not Focused.")
                    CdaCategory("Bitmap")
                CdaBindablePropertyEnd()
                CdaBindableProperty(ActiveDisabledBitmap, ActiveDisabledBitmapType, GetActiveDisabledBitmap, SetActiveDisabledBitmap)
                    CdaDescription("Bitmap used when the button is Disabled, not Pressed, Active and not Focused.")
                    CdaCategory("Bitmap")
                CdaBindablePropertyEnd()
                CdaBindableProperty(ActivePressedDisabledBitmap, ActivePressedDisabledBitmapType, GetActivePressedDisabledBitmap, SetActivePressedDisabledBitmap)
                    CdaDescription("Bitmap used when the button is Disabled, Pressed, Active and not Focused.")
                    CdaCategory("Bitmap")
                CdaBindablePropertyEnd()
                CdaBindableProperty(FocusedNormalBitmap, FocusedNormalBitmapType, GetFocusedNormalBitmap, SetFocusedNormalBitmap)
                    CdaDescription("Bitmap used when the button is Enabled, not Pressed, not Active and Focused.")
                    CdaCategory("Bitmap")
                CdaBindablePropertyEnd()
                CdaBindableProperty(FocusedPressedBitmap, FocusedPressedBitmapType, GetFocusedPressedBitmap, SetFocusedPressedBitmap)
                    CdaDescription("Bitmap used when the button is Enabled, Pressed, not Active and Focused.")
                    CdaCategory("Bitmap")
                CdaBindablePropertyEnd()
                CdaBindableProperty(FocusedDisabledBitmap, FocusedDisabledBitmapType, GetFocusedDisabledBitmap, SetFocusedDisabledBitmap)
                    CdaDescription("Bitmap used when the button is Disabled, not Pressed, not Active and Focused.")
                    CdaCategory("Bitmap")
                CdaBindablePropertyEnd()
                CdaBindableProperty(FocusedPressedDisabledBitmap, FocusedPressedDisabledBitmapType, GetFocusedPressedDisabledBitmap, SetFocusedPressedDisabledBitmap)
                    CdaDescription("Bitmap used when the button is Disabled, Pressed, not Active and Focused.")
                    CdaCategory("Bitmap")
                CdaBindablePropertyEnd()
                CdaBindableProperty(FocusedActiveNormalBitmap, FocusedActiveNormalBitmapType, GetFocusedActiveNormalBitmap, SetFocusedActiveNormalBitmap)
                    CdaDescription("Bitmap used when the button is Enabled, not Pressed, Active and Focused.")
                    CdaCategory("Bitmap")
                CdaBindablePropertyEnd()
                CdaBindableProperty(FocusedActivePressedBitmap, FocusedActivePressedBitmapType, GetFocusedActivePressedBitmap, SetFocusedActivePressedBitmap)
                    CdaDescription("Bitmap used when the button is Enabled, Pressed, Active and Focused.")
                    CdaCategory("Bitmap")
                CdaBindablePropertyEnd()
                CdaBindableProperty(FocusedActiveDisabledBitmap, FocusedActiveDisabledBitmapType, GetFocusedActiveDisabledBitmap, SetFocusedActiveDisabledBitmap)
                    CdaDescription("Bitmap used when the button is Disabled, not Pressed, Active and Focused.")
                    CdaCategory("Bitmap")
                CdaBindablePropertyEnd()
                CdaBindableProperty(FocusedActivePressedDisabledBitmap, FocusedActivePressedDisabledBitmapType, GetFocusedActivePressedDisabledBitmap, SetFocusedActivePressedDisabledBitmap)
                    CdaDescription("Bitmap used when the button is Disabled, Pressed, Active and Focused.")
                    CdaCategory("Bitmap")
                CdaBindablePropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:

    private:
        FallbackStrategyEnabledType m_FallbackStrategyEnabled;
        NormalBitmapType m_NormalBitmap;
        PressedBitmapType m_PressedBitmap;
        DisabledBitmapType m_DisabledBitmap;
        PressedDisabledBitmapType m_PressedDisabledBitmap;
        ActiveNormalBitmapType m_ActiveNormalBitmap;
        ActivePressedBitmapType m_ActivePressedBitmap;
        ActiveDisabledBitmapType m_ActiveDisabledBitmap;
        ActivePressedDisabledBitmapType m_ActivePressedDisabledBitmap;
        FocusedNormalBitmapType m_FocusedNormalBitmap;
        FocusedPressedBitmapType m_FocusedPressedBitmap;
        FocusedDisabledBitmapType m_FocusedDisabledBitmap;
        FocusedPressedDisabledBitmapType m_FocusedPressedDisabledBitmap;
        FocusedActiveNormalBitmapType m_FocusedActiveNormalBitmap;
        FocusedActivePressedBitmapType m_FocusedActivePressedBitmap;
        FocusedActiveDisabledBitmapType m_FocusedActiveDisabledBitmap;
        FocusedActivePressedDisabledBitmapType m_FocusedActivePressedDisabledBitmap;
};

#endif // ButtonImageWidget2DBase_h
