/************************************************************************
*FILE: ButtonAnimationWidget2DBase.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(ButtonAnimationWidget2DBase_h)
#define ButtonAnimationWidget2DBase_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/Rtti/Rtti.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Widgets/2D/Animation/AnimationWidget2D.h>
// ------------------------------------------------------------------------
//! [ButtonAnimationWidget2DBase_Declaration]
class ButtonAnimationWidget2DBase : public ::AnimationWidget2D
{
    public:
        bool IsAnyTriggerEnabled() const { return GetOnDisable() || GetOnEnable() || GetOnRelease() || GetOnPress() || GetOnDeactivate() || GetOnActivate() || GetOnLoseFocus() || GetOnFocus(); }
        bool IsEnabledGuardVisible() const { return IsAnyTriggerEnabled() && !GetOnDisable() && !GetOnEnable(); }
        bool IsEnabledValueVisible() const { return IsEnabledGuardVisible() && GetCheckEnabled(); }
        bool IsPressedGuardVisible() const { return IsAnyTriggerEnabled() && !GetOnRelease() && !GetOnPress(); }
        bool IsPressedValueVisible() const { return IsPressedGuardVisible() && GetCheckPressed(); }
        bool IsActiveGuardVisible() const { return IsAnyTriggerEnabled() && !GetOnDeactivate() && !GetOnActivate(); }
        bool IsActiveValueVisible() const { return IsActiveGuardVisible() && GetCheckActive(); }
        bool IsFocusedGuardVisible() const { return IsAnyTriggerEnabled() && !GetOnLoseFocus() && !GetOnFocus(); }
        bool IsFocusedValueVisible() const { return IsFocusedGuardVisible() && GetCheckFocused(); }
        virtual bool IsToggleDirectionPropertyVisible() const { return false; }
        virtual bool IsDirectionPropertyVisible() const { return false; }
        virtual bool IsShouldRunPropertyVisible() const { return false; }
        virtual bool IsRepeatTimesPropertyVisible() const { return false; }
        typedef bool OnDisableType;

        typedef bool ReverseOnDisableType;

        typedef bool OnEnableType;

        typedef bool ReverseOnEnableType;

        typedef bool OnReleaseType;

        typedef bool ReverseOnReleaseType;

        typedef bool OnPressType;

        typedef bool ReverseOnPressType;

        typedef bool OnDeactivateType;

        typedef bool ReverseOnDeactivateType;

        typedef bool OnActivateType;

        typedef bool ReverseOnActivateType;

        typedef bool OnLoseFocusType;

        typedef bool ReverseOnLoseFocusType;

        typedef bool OnFocusType;

        typedef bool ReverseOnFocusType;

        typedef bool CheckEnabledType;

        typedef bool IsEnabledType;

        typedef bool CheckPressedType;

        typedef bool IsPressedType;

        typedef bool CheckActiveType;

        typedef bool IsActiveType;

        typedef bool CheckFocusedType;

        typedef bool IsFocusedType;

        ButtonAnimationWidget2DBase();
        virtual ~ButtonAnimationWidget2DBase();

        CGI_WIDGET_RTTI_DECLARATION(ButtonAnimationWidget2DBase, ::AnimationWidget2D);

        //! [DataBinding_OnDisablePropertyGetterSetter]
        void SetOnDisable(const OnDisableType& ondisable);
        const OnDisableType& GetOnDisable() const { return m_OnDisable; }
        //! [DataBinding_OnDisablePropertyGetterSetter]

        //! [DataBinding_ReverseOnDisablePropertyGetterSetter]
        void SetReverseOnDisable(const ReverseOnDisableType& reverseondisable);
        const ReverseOnDisableType& GetReverseOnDisable() const { return m_ReverseOnDisable; }
        //! [DataBinding_ReverseOnDisablePropertyGetterSetter]

        //! [DataBinding_OnEnablePropertyGetterSetter]
        void SetOnEnable(const OnEnableType& onenable);
        const OnEnableType& GetOnEnable() const { return m_OnEnable; }
        //! [DataBinding_OnEnablePropertyGetterSetter]

        //! [DataBinding_ReverseOnEnablePropertyGetterSetter]
        void SetReverseOnEnable(const ReverseOnEnableType& reverseonenable);
        const ReverseOnEnableType& GetReverseOnEnable() const { return m_ReverseOnEnable; }
        //! [DataBinding_ReverseOnEnablePropertyGetterSetter]

        //! [DataBinding_OnReleasePropertyGetterSetter]
        void SetOnRelease(const OnReleaseType& onrelease);
        const OnReleaseType& GetOnRelease() const { return m_OnRelease; }
        //! [DataBinding_OnReleasePropertyGetterSetter]

        //! [DataBinding_ReverseOnReleasePropertyGetterSetter]
        void SetReverseOnRelease(const ReverseOnReleaseType& reverseonrelease);
        const ReverseOnReleaseType& GetReverseOnRelease() const { return m_ReverseOnRelease; }
        //! [DataBinding_ReverseOnReleasePropertyGetterSetter]

        //! [DataBinding_OnPressPropertyGetterSetter]
        void SetOnPress(const OnPressType& onpress);
        const OnPressType& GetOnPress() const { return m_OnPress; }
        //! [DataBinding_OnPressPropertyGetterSetter]

        //! [DataBinding_ReverseOnPressPropertyGetterSetter]
        void SetReverseOnPress(const ReverseOnPressType& reverseonpress);
        const ReverseOnPressType& GetReverseOnPress() const { return m_ReverseOnPress; }
        //! [DataBinding_ReverseOnPressPropertyGetterSetter]

        //! [DataBinding_OnDeactivatePropertyGetterSetter]
        void SetOnDeactivate(const OnDeactivateType& ondeactivate);
        const OnDeactivateType& GetOnDeactivate() const { return m_OnDeactivate; }
        //! [DataBinding_OnDeactivatePropertyGetterSetter]

        //! [DataBinding_ReverseOnDeactivatePropertyGetterSetter]
        void SetReverseOnDeactivate(const ReverseOnDeactivateType& reverseondeactivate);
        const ReverseOnDeactivateType& GetReverseOnDeactivate() const { return m_ReverseOnDeactivate; }
        //! [DataBinding_ReverseOnDeactivatePropertyGetterSetter]

        //! [DataBinding_OnActivatePropertyGetterSetter]
        void SetOnActivate(const OnActivateType& onactivate);
        const OnActivateType& GetOnActivate() const { return m_OnActivate; }
        //! [DataBinding_OnActivatePropertyGetterSetter]

        //! [DataBinding_ReverseOnActivatePropertyGetterSetter]
        void SetReverseOnActivate(const ReverseOnActivateType& reverseonactivate);
        const ReverseOnActivateType& GetReverseOnActivate() const { return m_ReverseOnActivate; }
        //! [DataBinding_ReverseOnActivatePropertyGetterSetter]

        //! [DataBinding_OnLoseFocusPropertyGetterSetter]
        void SetOnLoseFocus(const OnLoseFocusType& onlosefocus);
        const OnLoseFocusType& GetOnLoseFocus() const { return m_OnLoseFocus; }
        //! [DataBinding_OnLoseFocusPropertyGetterSetter]

        //! [DataBinding_ReverseOnLoseFocusPropertyGetterSetter]
        void SetReverseOnLoseFocus(const ReverseOnLoseFocusType& reverseonlosefocus);
        const ReverseOnLoseFocusType& GetReverseOnLoseFocus() const { return m_ReverseOnLoseFocus; }
        //! [DataBinding_ReverseOnLoseFocusPropertyGetterSetter]

        //! [DataBinding_OnFocusPropertyGetterSetter]
        void SetOnFocus(const OnFocusType& onfocus);
        const OnFocusType& GetOnFocus() const { return m_OnFocus; }
        //! [DataBinding_OnFocusPropertyGetterSetter]

        //! [DataBinding_ReverseOnFocusPropertyGetterSetter]
        void SetReverseOnFocus(const ReverseOnFocusType& reverseonfocus);
        const ReverseOnFocusType& GetReverseOnFocus() const { return m_ReverseOnFocus; }
        //! [DataBinding_ReverseOnFocusPropertyGetterSetter]

        //! [DataBinding_CheckEnabledPropertyGetterSetter]
        void SetCheckEnabled(const CheckEnabledType& checkenabled);
        const CheckEnabledType& GetCheckEnabled() const { return m_CheckEnabled; }
        //! [DataBinding_CheckEnabledPropertyGetterSetter]

        //! [DataBinding_IsEnabledPropertyGetterSetter]
        void SetIsEnabled(const IsEnabledType& isenabled);
        const IsEnabledType& GetIsEnabled() const { return m_IsEnabled; }
        //! [DataBinding_IsEnabledPropertyGetterSetter]

        //! [DataBinding_CheckPressedPropertyGetterSetter]
        void SetCheckPressed(const CheckPressedType& checkpressed);
        const CheckPressedType& GetCheckPressed() const { return m_CheckPressed; }
        //! [DataBinding_CheckPressedPropertyGetterSetter]

        //! [DataBinding_IsPressedPropertyGetterSetter]
        void SetIsPressed(const IsPressedType& ispressed);
        const IsPressedType& GetIsPressed() const { return m_IsPressed; }
        //! [DataBinding_IsPressedPropertyGetterSetter]

        //! [DataBinding_CheckActivePropertyGetterSetter]
        void SetCheckActive(const CheckActiveType& checkactive);
        const CheckActiveType& GetCheckActive() const { return m_CheckActive; }
        //! [DataBinding_CheckActivePropertyGetterSetter]

        //! [DataBinding_IsActivePropertyGetterSetter]
        void SetIsActive(const IsActiveType& isactive);
        const IsActiveType& GetIsActive() const { return m_IsActive; }
        //! [DataBinding_IsActivePropertyGetterSetter]

        //! [DataBinding_CheckFocusedPropertyGetterSetter]
        void SetCheckFocused(const CheckFocusedType& checkfocused);
        const CheckFocusedType& GetCheckFocused() const { return m_CheckFocused; }
        //! [DataBinding_CheckFocusedPropertyGetterSetter]

        //! [DataBinding_IsFocusedPropertyGetterSetter]
        void SetIsFocused(const IsFocusedType& isfocused);
        const IsFocusedType& GetIsFocused() const { return m_IsFocused; }
        //! [DataBinding_IsFocusedPropertyGetterSetter]

        // @WidgetBaseClass
        CdaWidget2DDef(ButtonAnimationWidget2DBase, ::AnimationWidget2D)
            CdaDescription("Button extension widget which provides support to create simple animations started when the button state changes. \nThe button state contains 4 flags (Enabled, Pressed, Active and Focused) which can be set to true or false independently. Therefore we have 8 possible transitions which can be used as triggers for the animation. At least one trigger should be enabled otherwise the animation is never started.\nAdditionally for the flags which are not used as triggers it is possible to set up guards, conditions evaluated when the triggers are received. For example start an animation on button press but only if the button is also active.")
            CdaReadableName("ButtonAnimationWidget2DBase")
            CdaCategory("Button")

            CdaProperties()
                CdaBindableProperty(OnDisable, OnDisableType, GetOnDisable, SetOnDisable)
                    CdaDescription("If this property is enabled and the button becomes disabled then the animation will be started. Guards can be configured to provide additonal conditions.")
                    CdaCategory("Trigger")
                CdaBindablePropertyEnd()
                CdaBindableProperty(ReverseOnDisable, ReverseOnDisableType, GetReverseOnDisable, SetReverseOnDisable)
                    CdaDescription("If this property is enabled then the animation will run backwards when started by OnDisable trigger")
                    CdaVisibilityTest(GetOnDisable)
                    CdaCategory("Trigger")
                CdaBindablePropertyEnd()
                CdaBindableProperty(OnEnable, OnEnableType, GetOnEnable, SetOnEnable)
                    CdaDescription("If this property is enabled and the button becomes also enabled then the animation will be started. Guards can be configured to provide additonal conditions.")
                    CdaCategory("Trigger")
                CdaBindablePropertyEnd()
                CdaBindableProperty(ReverseOnEnable, ReverseOnEnableType, GetReverseOnEnable, SetReverseOnEnable)
                    CdaDescription("If this property is enabled then the animation will run backwards when started by OnEnable trigger")
                    CdaVisibilityTest(GetOnEnable)
                    CdaCategory("Trigger")
                CdaBindablePropertyEnd()
                CdaBindableProperty(OnRelease, OnReleaseType, GetOnRelease, SetOnRelease)
                    CdaDescription("If this property is enabled and the button is released then the animation will be started. Guards can be configured to provide additonal conditions.")
                    CdaCategory("Trigger")
                CdaBindablePropertyEnd()
                CdaBindableProperty(ReverseOnRelease, ReverseOnReleaseType, GetReverseOnRelease, SetReverseOnRelease)
                    CdaDescription("If this property is enabled then the animation will run backwards when started by OnRelease trigger")
                    CdaVisibilityTest(GetOnRelease)
                    CdaCategory("Trigger")
                CdaBindablePropertyEnd()
                CdaBindableProperty(OnPress, OnPressType, GetOnPress, SetOnPress)
                    CdaDescription("If this property is enabled and the button is pressed then the animation will be started. Guards can be configured to provide additonal conditions.")
                    CdaCategory("Trigger")
                CdaBindablePropertyEnd()
                CdaBindableProperty(ReverseOnPress, ReverseOnPressType, GetReverseOnPress, SetReverseOnPress)
                    CdaDescription("If this property is enabled then the animation will run backwards when started by OnPress trigger")
                    CdaVisibilityTest(GetOnPress)
                    CdaCategory("Trigger")
                CdaBindablePropertyEnd()
                CdaBindableProperty(OnDeactivate, OnDeactivateType, GetOnDeactivate, SetOnDeactivate)
                    CdaDescription("If this property is enabled and the button becomes inactive then the animation will be started. Guards can be configured to provide additonal conditions.")
                    CdaCategory("Trigger")
                CdaBindablePropertyEnd()
                CdaBindableProperty(ReverseOnDeactivate, ReverseOnDeactivateType, GetReverseOnDeactivate, SetReverseOnDeactivate)
                    CdaDescription("If this property is enabled then the animation will run backwards when started by OnDeactivate trigger")
                    CdaVisibilityTest(GetOnDeactivate)
                    CdaCategory("Trigger")
                CdaBindablePropertyEnd()
                CdaBindableProperty(OnActivate, OnActivateType, GetOnActivate, SetOnActivate)
                    CdaDescription("If this property is enabled and the button becomes active then the animation will be started. Guards can be configured to provide additonal conditions.")
                    CdaCategory("Trigger")
                CdaBindablePropertyEnd()
                CdaBindableProperty(ReverseOnActivate, ReverseOnActivateType, GetReverseOnActivate, SetReverseOnActivate)
                    CdaDescription("If this property is enabled then the animation will run backwards when started by OnActivate trigger")
                    CdaVisibilityTest(GetOnActivate)
                    CdaCategory("Trigger")
                CdaBindablePropertyEnd()
                CdaBindableProperty(OnLoseFocus, OnLoseFocusType, GetOnLoseFocus, SetOnLoseFocus)
                    CdaDescription("If this property is enabled and the button loses focus then the animation will be started. Guards can be configured to provide additonal conditions.")
                    CdaCategory("Trigger")
                CdaBindablePropertyEnd()
                CdaBindableProperty(ReverseOnLoseFocus, ReverseOnLoseFocusType, GetReverseOnLoseFocus, SetReverseOnLoseFocus)
                    CdaDescription("If this property is enabled then the animation will run backwards when started by OnLoseFocus trigger")
                    CdaVisibilityTest(GetOnLoseFocus)
                    CdaCategory("Trigger")
                CdaBindablePropertyEnd()
                CdaBindableProperty(OnFocus, OnFocusType, GetOnFocus, SetOnFocus)
                    CdaDescription("If this property is enabled and the button gains focus then the animation will be started. Guards can be configured to provide additonal conditions.")
                    CdaCategory("Trigger")
                CdaBindablePropertyEnd()
                CdaBindableProperty(ReverseOnFocus, ReverseOnFocusType, GetReverseOnFocus, SetReverseOnFocus)
                    CdaDescription("If this property is enabled then the animation will run backwards when started by OnFocus trigger")
                    CdaVisibilityTest(GetOnFocus)
                    CdaCategory("Trigger")
                CdaBindablePropertyEnd()
                CdaBindableProperty(CheckEnabled, CheckEnabledType, GetCheckEnabled, SetCheckEnabled)
                    CdaDescription("If this property is enabled then the button Enabled flag will be checked before starting the animation.")
                    CdaVisibilityTest(IsEnabledGuardVisible)
                    CdaCategory("Guard")
                CdaBindablePropertyEnd()
                CdaBindableProperty(IsEnabled, IsEnabledType, GetIsEnabled, SetIsEnabled)
                    CdaDescription("The animation is started only if the button Enabled flag matches this property.")
                    CdaVisibilityTest(IsEnabledValueVisible)
                    CdaCategory("Guard")
                CdaBindablePropertyEnd()
                CdaBindableProperty(CheckPressed, CheckPressedType, GetCheckPressed, SetCheckPressed)
                    CdaDescription("If this property is enabled then the button Pressed flag will be checked before starting the animation.")
                    CdaVisibilityTest(IsPressedGuardVisible)
                    CdaCategory("Guard")
                CdaBindablePropertyEnd()
                CdaBindableProperty(IsPressed, IsPressedType, GetIsPressed, SetIsPressed)
                    CdaDescription("The animation is started only if the button Pressed flag matches this property.")
                    CdaVisibilityTest(IsPressedValueVisible)
                    CdaCategory("Guard")
                CdaBindablePropertyEnd()
                CdaBindableProperty(CheckActive, CheckActiveType, GetCheckActive, SetCheckActive)
                    CdaDescription("If this property is enabled then the button Active flag will be checked before starting the animation.")
                    CdaVisibilityTest(IsActiveGuardVisible)
                    CdaCategory("Guard")
                CdaBindablePropertyEnd()
                CdaBindableProperty(IsActive, IsActiveType, GetIsActive, SetIsActive)
                    CdaDescription("The animation is started only if the button Active flag matches this property.")
                    CdaVisibilityTest(IsActiveValueVisible)
                    CdaCategory("Guard")
                CdaBindablePropertyEnd()
                CdaBindableProperty(CheckFocused, CheckFocusedType, GetCheckFocused, SetCheckFocused)
                    CdaDescription("If this property is enabled then the button Focused flag will be checked before starting the animation.")
                    CdaVisibilityTest(IsFocusedGuardVisible)
                    CdaCategory("Guard")
                CdaBindablePropertyEnd()
                CdaBindableProperty(IsFocused, IsFocusedType, GetIsFocused, SetIsFocused)
                    CdaDescription("The animation is started only if the button Focused flag matches this property.")
                    CdaVisibilityTest(IsFocusedValueVisible)
                    CdaCategory("Guard")
                CdaBindablePropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:

    private:
        OnDisableType m_OnDisable;
        ReverseOnDisableType m_ReverseOnDisable;
        OnEnableType m_OnEnable;
        ReverseOnEnableType m_ReverseOnEnable;
        OnReleaseType m_OnRelease;
        ReverseOnReleaseType m_ReverseOnRelease;
        OnPressType m_OnPress;
        ReverseOnPressType m_ReverseOnPress;
        OnDeactivateType m_OnDeactivate;
        ReverseOnDeactivateType m_ReverseOnDeactivate;
        OnActivateType m_OnActivate;
        ReverseOnActivateType m_ReverseOnActivate;
        OnLoseFocusType m_OnLoseFocus;
        ReverseOnLoseFocusType m_ReverseOnLoseFocus;
        OnFocusType m_OnFocus;
        ReverseOnFocusType m_ReverseOnFocus;
        CheckEnabledType m_CheckEnabled;
        IsEnabledType m_IsEnabled;
        CheckPressedType m_CheckPressed;
        IsPressedType m_IsPressed;
        CheckActiveType m_CheckActive;
        IsActiveType m_IsActive;
        CheckFocusedType m_CheckFocused;
        IsFocusedType m_IsFocused;
};

#endif // ButtonAnimationWidget2DBase_h
