/************************************************************************
*FILE: ButtonWidget2DBase.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(ButtonWidget2DBase_h)
#define ButtonWidget2DBase_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/Rtti/Rtti.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Widgets/2D/Button/generated/ButtonWidget2DMessages.h>
#include <Widgets/2D/Touchable2D.h>
// ------------------------------------------------------------------------
//! [ButtonWidget2DBase_Declaration]
class ButtonWidget2DBase : public ::Touchable2D
{
    public:
        typedef bool PostButtonReactionMsgType;

        typedef Candera::enTimerConfiguration TimerConfigurationType;

        typedef Candera::Rectangle TouchableAreaType;

        typedef Candera::Int32 TouchHandlerType;

        ButtonWidget2DBase();
        virtual ~ButtonWidget2DBase();

        CGI_WIDGET_RTTI_DECLARATION(ButtonWidget2DBase, ::Touchable2D);

        void SetPostButtonReactionMsg(const PostButtonReactionMsgType& postbuttonreactionmsg);
        const PostButtonReactionMsgType& GetPostButtonReactionMsg() const { return m_PostButtonReactionMsg; }

        void SetTimerConfiguration(const TimerConfigurationType& timerconfiguration);
        const TimerConfigurationType& GetTimerConfiguration() const { return m_TimerConfiguration; }

        void SetTouchableArea(const TouchableAreaType& touchablearea);
        const TouchableAreaType& GetTouchableArea() const { return m_TouchableArea; }

        //! [DataBinding_TouchHandlerPropertyGetterSetter]
        void SetTouchHandler(const TouchHandlerType& touchhandler);
        const TouchHandlerType& GetTouchHandler() const { return m_TouchHandler; }
        //! [DataBinding_TouchHandlerPropertyGetterSetter]

        // @WidgetBaseClass
        CdaWidget2DDef(ButtonWidget2DBase, ::Touchable2D)
            CdaDescription("Interactive widget which sends reaction messages when pressed or released. The button state contains several flags (enabled, pressed, active and focused) which are set in various ways. Additional widgets like ButtonImageWidget2D or ButtonTextColorWidget2D are required to model the appearance of a button which provides feedback about its state. See the widget documentation for more details.")
            CdaReadableName("ButtonWidget2DBase")
            CdaCategory("Button")

            CdaProperties()
                CdaProperty(PostButtonReactionMsg, PostButtonReactionMsgType, GetPostButtonReactionMsg, SetPostButtonReactionMsg)
                    CdaDescription("ButtonReactionMsg messages will be posted only if this property is true.")
                    CdaCategory("Button")
                CdaPropertyEnd()
                CdaProperty(TimerConfiguration, TimerConfigurationType, GetTimerConfiguration, SetTimerConfiguration)
                    CdaDescription("Configures the timer.")
                    CdaCategory("Button")
                CdaPropertyEnd()
                CdaProperty(TouchableArea, TouchableAreaType, GetTouchableArea, SetTouchableArea)
                    CdaDescription("Configures the touchable area of the button. X and Y are coordinates relative to the upper left corner of the node effective bounding rectangle. If width or height are zero or negative the effective bounding rectangle of the node will be used as touchable area (X and Y will also be ignored).")
                    CdaCategory("Button")
                CdaPropertyEnd()
                CdaBindableProperty(TouchHandler, TouchHandlerType, GetTouchHandler, SetTouchHandler)
                    CdaDescription("Specifies the id of the touch handler for this button. A touch handler can provide a custom sensitive area for buttons (for example circle, triangle, etc). Touch handlers are registered at application start-up.")
                    CdaCategory("Button")
                CdaBindablePropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:

    private:
        PostButtonReactionMsgType m_PostButtonReactionMsg;
        TimerConfigurationType m_TimerConfiguration;
        TouchableAreaType m_TouchableArea;
        TouchHandlerType m_TouchHandler;
};

#endif // ButtonWidget2DBase_h
