/************************************************************************
*FILE: BusyIndicatorWidget2DBase.cpp 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ***************************************************************************************
 * FILE:          Generated intermediate file from HMIContract.exe
 * SW-COMPONENT:  HMI-BASE
 *  DESCRIPTION:  This file is part of HMI-Base Widget Library 
 *    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
 *
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */
#include "widget2D_std_if.h"

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#include "BusyIndicatorWidget2DBase.h"

// ------------------------------------------------------------------------
CGI_WIDGET_RTTI_DEFINITION(BusyIndicatorWidget2DBase)

BusyIndicatorWidget2DBase::BusyIndicatorWidget2DBase() :
    m_BusyWaitIndicatorType(BusyWaitIndicatorTypeType()),
    m_EnableScaling(EnableScalingType()),
    m_SpeedFactor(SpeedFactorType()),
    m_PlayDirection(PlayDirectionType()),
    m_AnimationDuration(AnimationDurationType()),
    m_MinimumAnimationDuration(MinimumAnimationDurationType()),
    m_TextWidget(TextWidgetType()),
    m_Text(TextType()),
    m_WidgetName(WidgetNameType()),
    m_ChangeSetBusyIndicatorWidget2DBase()
{
    if (!m_ChangeSetBusyIndicatorWidget2DBase.Reserve(1)) {
        FEATSTD_DEBUG_FAIL();
    }
}

BusyIndicatorWidget2DBase::~BusyIndicatorWidget2DBase()
{
    m_TextWidget = 0;
}

void BusyIndicatorWidget2DBase::Update()
{
    Base::Update();
    while (!m_ChangeSetBusyIndicatorWidget2DBase.Empty()) {
        ::FeatStd::UInt32 propertyId = m_ChangeSetBusyIndicatorWidget2DBase[0];
        bool ok = m_ChangeSetBusyIndicatorWidget2DBase.Remove(0);
        FEATSTD_DEBUG_ASSERT(ok);
        OnChanged(propertyId);
        FEATSTD_UNUSED(ok);
    }
}

void BusyIndicatorWidget2DBase::SetBusyWaitIndicatorType(const BusyWaitIndicatorTypeType& busywaitindicatortype)
{
    m_BusyWaitIndicatorType = busywaitindicatortype;
}

void BusyIndicatorWidget2DBase::SetEnableScaling(const EnableScalingType& enablescaling)
{
    m_EnableScaling = enablescaling;
}

void BusyIndicatorWidget2DBase::SetSpeedFactor(const SpeedFactorType& speedfactor)
{
    m_SpeedFactor = speedfactor;
    if (!m_ChangeSetBusyIndicatorWidget2DBase.Contains(static_cast< ::FeatStd::UInt32>(SpeedFactorPropertyId))) {
        if (!m_ChangeSetBusyIndicatorWidget2DBase.Add(static_cast< ::FeatStd::UInt32>(SpeedFactorPropertyId))) {
            FEATSTD_DEBUG_FAIL();
        }
    }
}

void BusyIndicatorWidget2DBase::SetPlayDirection(const PlayDirectionType& playdirection)
{
    m_PlayDirection = playdirection;
    if (!m_ChangeSetBusyIndicatorWidget2DBase.Contains(static_cast< ::FeatStd::UInt32>(PlayDirectionPropertyId))) {
        if (!m_ChangeSetBusyIndicatorWidget2DBase.Add(static_cast< ::FeatStd::UInt32>(PlayDirectionPropertyId))) {
            FEATSTD_DEBUG_FAIL();
        }
    }
}

void BusyIndicatorWidget2DBase::SetAnimationDuration(const AnimationDurationType& animationduration)
{
    m_AnimationDuration = animationduration;
    if (!m_ChangeSetBusyIndicatorWidget2DBase.Contains(static_cast< ::FeatStd::UInt32>(AnimationDurationPropertyId))) {
        if (!m_ChangeSetBusyIndicatorWidget2DBase.Add(static_cast< ::FeatStd::UInt32>(AnimationDurationPropertyId))) {
            FEATSTD_DEBUG_FAIL();
        }
    }
}

void BusyIndicatorWidget2DBase::SetMinimumAnimationDuration(const MinimumAnimationDurationType& minimumanimationduration)
{
    m_MinimumAnimationDuration = minimumanimationduration;
}

void BusyIndicatorWidget2DBase::SetTextWidget(const TextWidgetType textwidget)
{
    m_TextWidget = textwidget;
}

void BusyIndicatorWidget2DBase::SetText(const TextType& text)
{
    m_Text = text;
    if (!m_ChangeSetBusyIndicatorWidget2DBase.Contains(static_cast< ::FeatStd::UInt32>(TextPropertyId))) {
        if (!m_ChangeSetBusyIndicatorWidget2DBase.Add(static_cast< ::FeatStd::UInt32>(TextPropertyId))) {
            FEATSTD_DEBUG_FAIL();
        }
    }
}

void BusyIndicatorWidget2DBase::SetWidgetName(const WidgetNameType& widgetname)
{
    m_WidgetName = widgetname;
    if (!m_ChangeSetBusyIndicatorWidget2DBase.Contains(static_cast< ::FeatStd::UInt32>(WidgetNamePropertyId))) {
        if (!m_ChangeSetBusyIndicatorWidget2DBase.Add(static_cast< ::FeatStd::UInt32>(WidgetNamePropertyId))) {
            FEATSTD_DEBUG_FAIL();
        }
    }
}
