/************************************************************************
*FILE: BaseLineLayouterWidget2DBase.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(BaseLineLayouterWidget2DBase_h)
#define BaseLineLayouterWidget2DBase_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/Rtti/Rtti.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Widgets/2D/BaseWidget2D.h>
// ------------------------------------------------------------------------
//! [BaseLineLayouterWidget2DBase_Declaration]
class BaseLineLayouterWidget2DBase : public ::BaseWidget2D
{
    public:
        typedef ::Candera::UInt32 NestedLevelType;

        typedef ::Candera::Float BaseLineOffsetType;

        //! [Property_IDs]
        static const FeatStd::UInt32 NestedLevelPropertyId = 0x731DBB6E;
        static const FeatStd::UInt32 BaseLineOffsetPropertyId = 0xFBCAFCEB;
        //! [Property_IDs]

        BaseLineLayouterWidget2DBase();
        virtual ~BaseLineLayouterWidget2DBase();

        CGI_WIDGET_RTTI_DECLARATION(BaseLineLayouterWidget2DBase, ::BaseWidget2D);

        //! [DataBinding_NestedLevelPropertyGetterSetter]
        void SetNestedLevel(const NestedLevelType& nestedlevel);
        const NestedLevelType& GetNestedLevel() const { return m_NestedLevel; }
        //! [DataBinding_NestedLevelPropertyGetterSetter]

        //! [DataBinding_BaseLineOffsetPropertyGetterSetter]
        void SetBaseLineOffset(const BaseLineOffsetType& baselineoffset);
        const BaseLineOffsetType& GetBaseLineOffset() const { return m_BaseLineOffset; }
        //! [DataBinding_BaseLineOffsetPropertyGetterSetter]

        // @WidgetBaseClass
        CdaWidget2DDef(BaseLineLayouterWidget2DBase, ::BaseWidget2D)
            CdaDescription("Sets a baseline layouter and the baseline offset on a composite node or a normal group. \nAssociate the widget directly to the targeted composite or group. Don't use the nested level because it can create confusion and lead to errors.")
            CdaReadableName("BaseLineLayouterWidget2DBase")
            CdaCategory("Layout")

            CdaProperties()
                CdaBindableProperty(NestedLevel, NestedLevelType, GetNestedLevel, SetNestedLevel)
                    CdaDescription("DEPRECATED: This property was required in the past when it was not possible to associate a widget directly to the composite. \nThe value of this property represents the ancestor's level, relative to the associated node, that will be targeted by this widget. \nThis property should not be used because it creates confusion and can lead to errors. Just associate the widget directly to the targeted composite or group.")
                CdaBindablePropertyEnd()
                CdaBindableProperty(BaseLineOffset, BaseLineOffsetType, GetBaseLineOffset, SetBaseLineOffset)
                    CdaDescription("Baseline offset used by the layouter.")
                CdaBindablePropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:

    private:
        NestedLevelType m_NestedLevel;
        BaseLineOffsetType m_BaseLineOffset;
};

#endif // BaseLineLayouterWidget2DBase_h
