/************************************************************************
*FILE: AnimationWidget2DBase.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(AnimationWidget2DBase_h)
#define AnimationWidget2DBase_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/Rtti/Rtti.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Widgets/2D/Animation/generated/AnimationWidget2DMessages.h>
#include <Widgets/2D/BaseWidget2D.h>
#include <Candera/EngineBase/Animation/BezierInterpolationStrategy.h>
#include <Candera/EngineBase/Animation/LinearInterpolationStrategy.h>
#include <Candera/EngineBase/Animation/SplineInterpolationStrategy.h>
#include <Candera/EngineBase/Animation/StepInterpolationStrategy.h>
#include <Candera/EngineBase/Animation/EaseInterpolationStrategy.h>

          #define ENUM_DATA_TYPE \
                      ENUM_DATA_TYPE_BEGIN(enAnimationPropertySetter)     \
        ENUM_DATA_TYPE_ITEM(AnimateScale)        \
        ENUM_DATA_TYPE_ITEM(AnimateAlphaValue)        \
    ENUM_DATA_TYPE_ITEM(AnimatePosition)        \
    ENUM_DATA_TYPE_ITEM(AnimateRotation)        \
    ENUM_DATA_TYPE_ITEM(AnimateRendering)        \
    ENUM_DATA_TYPE_ITEM(AnimateWidgetProperty)        \
                      ENUM_DATA_TYPE_END(enAnimationPropertySetter)
                        #include <Candera/System/MetaInfo/EnumDataType.h>

          #define ENUM_DATA_TYPE \
                      ENUM_DATA_TYPE_BEGIN(enAnimationPlayDirection)     \
        ENUM_DATA_TYPE_ITEM(PlayForward)        \
        ENUM_DATA_TYPE_ITEM(PlayReverse)        \
                      ENUM_DATA_TYPE_END(enAnimationPlayDirection)
                        #include <Candera/System/MetaInfo/EnumDataType.h>                       

                        #define ENUM_DATA_TYPE \
                      ENUM_DATA_TYPE_BEGIN(enEaseInterpolationDirection)     \
                        ENUM_DATA_TYPE_ITEM(EaseDirectionEaseIn)        \
                        ENUM_DATA_TYPE_ITEM(EaseDirectionEaseOut)        \
                        ENUM_DATA_TYPE_ITEM(EaseDirectionEaseInOut)        \
                        ENUM_DATA_TYPE_END(enEaseInterpolationDirection)
                        #include <Candera/System/MetaInfo/EnumDataType.h>

                        #define ENUM_DATA_TYPE \
                      ENUM_DATA_TYPE_BEGIN(enEaseInterpolationFunctionType)     \
                        ENUM_DATA_TYPE_ITEM(EaseBack)        \
                        ENUM_DATA_TYPE_ITEM(EaseBounce)        \
                        ENUM_DATA_TYPE_ITEM(EaseElastic)        \
                        ENUM_DATA_TYPE_ITEM(EaseExponential)        \
                        ENUM_DATA_TYPE_ITEM(EasePower)        \
                        ENUM_DATA_TYPE_END(enEaseInterpolationFunctionType)
                        #include <Candera/System/MetaInfo/EnumDataType.h>

                        #define ENUM_DATA_TYPE \
                      ENUM_DATA_TYPE_BEGIN(enInterpolationStrategy)     \
                      ENUM_DATA_TYPE_ITEM(InterpolationStrategyLinear)        \
                      ENUM_DATA_TYPE_ITEM(InterpolationStrategySpline)        \
                      ENUM_DATA_TYPE_ITEM(InterpolationStrategyStep)        \
                      ENUM_DATA_TYPE_ITEM(InterpolationStrategyEase)        \
                      ENUM_DATA_TYPE_END(enInterpolationStrategy)
                        #include <Candera/System/MetaInfo/EnumDataType.h>
// ------------------------------------------------------------------------
//! [AnimationWidget2DBase_Declaration]
class AnimationWidget2DBase : public ::BaseWidget2D
{
    public:
        bool IsChannel2Visible() const { return (GetPropertyAnimation() == Candera::AnimateScale || GetPropertyAnimation() == Candera::AnimatePosition ); }
        bool IsEaseInterpolationSelected() const { return (GetInterpolationStrategy() == Candera::InterpolationStrategyEase); }
        bool IsEaseInterpolationBackFunctionTypeSelected() const { return (IsEaseInterpolationSelected() && GetFunctionType() == Candera::EaseBack); }    
        bool IsEaseInterpolationBounceFunctionTypeSelected() const { return (IsEaseInterpolationSelected() && GetFunctionType() == Candera::EaseBounce); }
        bool IsEaseInterpolationElasticFunctionTypeSelected() const { return (IsEaseInterpolationSelected() && GetFunctionType() == Candera::EaseElastic); }    
        bool IsEaseInterpolationExponentialFunctionTypeSelected() const { return (IsEaseInterpolationSelected() && GetFunctionType() == Candera::EaseExponential); }
        bool IsEaseInterpolationPowerFunctionTypeSelected() const { return (IsEaseInterpolationSelected() && GetFunctionType() == Candera::EasePower); }
        bool IsAnimateWidgetPropertySelected() const { return (GetPropertyAnimation() == Candera::AnimateWidgetProperty); }
        virtual bool IsToggleDirectionPropertyVisible() const { return true; }
        virtual bool IsDirectionPropertyVisible() const { return true; }
        virtual bool IsShouldRunPropertyVisible() const { return true; }
        virtual bool IsRepeatTimesPropertyVisible() const { return true; }
        typedef Candera::enAnimationPropertySetter PropertyAnimationType;

        typedef Candera::Float SpeedFactorType;

        typedef bool ToggleDirectionType;

        typedef Candera::enAnimationPlayDirection DirectionType;

        typedef Candera::enInterpolationStrategy InterpolationStrategyType;

        typedef Candera::enEaseInterpolationDirection EaseDirectionType;

        typedef Candera::enEaseInterpolationFunctionType FunctionTypeType;

        typedef Candera::Float AmplitudeType;

        typedef Candera::Float RestitutionCoefficientType;

        typedef Candera::UInt8 BounceCountType;

        typedef Candera::Float ExponentElasticType;

        typedef Candera::UInt8 OscillationCountType;

        typedef Candera::Float ExponentType;

        typedef Candera::UInt8 PowerType;

        typedef bool ShouldRunType;

        typedef Candera::UInt32 RepeatTimesType;

        typedef Candera::UInt32 KeyFrameCountType;

        typedef Candera::String SequenceTimeType;

        typedef Candera::String Channel1Type;

        typedef Candera::String Channel2Type;

        typedef Candera::WidgetBase* WidgetToAnimateType;

        typedef Candera::String WidgetPropertyNameToAnimateType;

        //! [Property_IDs]
        static const FeatStd::UInt32 PropertyAnimationPropertyId = 0xA4D5501C;
        static const FeatStd::UInt32 SpeedFactorPropertyId = 0x99C20A3A;
        static const FeatStd::UInt32 ToggleDirectionPropertyId = 0xCAB9503F;
        static const FeatStd::UInt32 DirectionPropertyId = 0xA0567985;
        static const FeatStd::UInt32 InterpolationStrategyPropertyId = 0x0696E001;
        static const FeatStd::UInt32 EaseDirectionPropertyId = 0x62AFEF3F;
        static const FeatStd::UInt32 FunctionTypePropertyId = 0x03E7398E;
        static const FeatStd::UInt32 AmplitudePropertyId = 0x3870457B;
        static const FeatStd::UInt32 RestitutionCoefficientPropertyId = 0xC554E09D;
        static const FeatStd::UInt32 BounceCountPropertyId = 0x2A7FBDE8;
        static const FeatStd::UInt32 ExponentElasticPropertyId = 0x9B45C765;
        static const FeatStd::UInt32 OscillationCountPropertyId = 0x9A292810;
        static const FeatStd::UInt32 ExponentPropertyId = 0x3B0B1938;
        static const FeatStd::UInt32 PowerPropertyId = 0xC088F22F;
        static const FeatStd::UInt32 ShouldRunPropertyId = 0xC90F056A;
        static const FeatStd::UInt32 RepeatTimesPropertyId = 0x89B01034;
        static const FeatStd::UInt32 KeyFrameCountPropertyId = 0x0FF7CE1E;
        static const FeatStd::UInt32 SequenceTimePropertyId = 0x209FFE82;
        static const FeatStd::UInt32 Channel1PropertyId = 0x3661D264;
        static const FeatStd::UInt32 Channel2PropertyId = 0x2347AC30;
        //! [Property_IDs]

        AnimationWidget2DBase();
        virtual ~AnimationWidget2DBase();

        CGI_WIDGET_RTTI_DECLARATION(AnimationWidget2DBase, ::BaseWidget2D);

        virtual void Update();

        void SetPropertyAnimation(const PropertyAnimationType& propertyanimation);
        const PropertyAnimationType& GetPropertyAnimation() const { return m_PropertyAnimation; }

        void SetSpeedFactor(const SpeedFactorType& speedfactor);
        const SpeedFactorType& GetSpeedFactor() const { return m_SpeedFactor; }

        void SetToggleDirection(const ToggleDirectionType& toggledirection);
        const ToggleDirectionType& GetToggleDirection() const { return m_ToggleDirection; }

        //! [DataBinding_DirectionPropertyGetterSetter]
        void SetDirection(const DirectionType& direction);
        const DirectionType& GetDirection() const { return m_Direction; }
        //! [DataBinding_DirectionPropertyGetterSetter]

        void SetInterpolationStrategy(const InterpolationStrategyType& interpolationstrategy);
        const InterpolationStrategyType& GetInterpolationStrategy() const { return m_InterpolationStrategy; }

        void SetEaseDirection(const EaseDirectionType& easedirection);
        const EaseDirectionType& GetEaseDirection() const { return m_EaseDirection; }

        void SetFunctionType(const FunctionTypeType& functiontype);
        const FunctionTypeType& GetFunctionType() const { return m_FunctionType; }

        void SetAmplitude(const AmplitudeType& amplitude);
        const AmplitudeType& GetAmplitude() const { return m_Amplitude; }

        void SetRestitutionCoefficient(const RestitutionCoefficientType& restitutioncoefficient);
        const RestitutionCoefficientType& GetRestitutionCoefficient() const { return m_RestitutionCoefficient; }

        void SetBounceCount(const BounceCountType& bouncecount);
        const BounceCountType& GetBounceCount() const { return m_BounceCount; }

        void SetExponentElastic(const ExponentElasticType& exponentelastic);
        const ExponentElasticType& GetExponentElastic() const { return m_ExponentElastic; }

        void SetOscillationCount(const OscillationCountType& oscillationcount);
        const OscillationCountType& GetOscillationCount() const { return m_OscillationCount; }

        void SetExponent(const ExponentType& exponent);
        const ExponentType& GetExponent() const { return m_Exponent; }

        void SetPower(const PowerType& power);
        const PowerType& GetPower() const { return m_Power; }

        //! [DataBinding_ShouldRunPropertyGetterSetter]
        void SetShouldRun(const ShouldRunType& shouldrun);
        const ShouldRunType& GetShouldRun() const { return m_ShouldRun; }
        //! [DataBinding_ShouldRunPropertyGetterSetter]

        void SetRepeatTimes(const RepeatTimesType& repeattimes);
        const RepeatTimesType& GetRepeatTimes() const { return m_RepeatTimes; }

        void SetKeyFrameCount(const KeyFrameCountType& keyframecount);
        const KeyFrameCountType& GetKeyFrameCount() const { return m_KeyFrameCount; }

        //! [DataBinding_SequenceTimePropertyGetterSetter]
        void SetSequenceTime(const SequenceTimeType& sequencetime);
        const SequenceTimeType& GetSequenceTime() const { return m_SequenceTime; }
        SequenceTimeType& GetSequenceTime() { return m_SequenceTime; }
        //! [DataBinding_SequenceTimePropertyGetterSetter]

        //! [DataBinding_Channel1PropertyGetterSetter]
        void SetChannel1(const Channel1Type& channel1);
        const Channel1Type& GetChannel1() const { return m_Channel1; }
        Channel1Type& GetChannel1() { return m_Channel1; }
        //! [DataBinding_Channel1PropertyGetterSetter]

        //! [DataBinding_Channel2PropertyGetterSetter]
        void SetChannel2(const Channel2Type& channel2);
        const Channel2Type& GetChannel2() const { return m_Channel2; }
        Channel2Type& GetChannel2() { return m_Channel2; }
        //! [DataBinding_Channel2PropertyGetterSetter]

        void SetWidgetToAnimate(const WidgetToAnimateType& widgettoanimate);
        const WidgetToAnimateType& GetWidgetToAnimate() const { return m_WidgetToAnimate; }
        WidgetToAnimateType& GetWidgetToAnimate() { return m_WidgetToAnimate; }

        void SetWidgetPropertyNameToAnimate(const WidgetPropertyNameToAnimateType& widgetpropertynametoanimate);
        const WidgetPropertyNameToAnimateType& GetWidgetPropertyNameToAnimate() const { return m_WidgetPropertyNameToAnimate; }
        WidgetPropertyNameToAnimateType& GetWidgetPropertyNameToAnimate() { return m_WidgetPropertyNameToAnimate; }

        // @WidgetBaseClass
        CdaWidget2DDef(AnimationWidget2DBase, ::BaseWidget2D)
            CdaDescription("Provides support to create simple animations.")
            CdaReadableName("AnimationWidget2DBase")
            CdaCategory("Animation")

            CdaProperties()
                CdaProperty(PropertyAnimation, PropertyAnimationType, GetPropertyAnimation, SetPropertyAnimation)
                    CdaDescription("Animation Type")
                    CdaCategory("Animation")
                CdaPropertyEnd()
                CdaProperty(SpeedFactor, SpeedFactorType, GetSpeedFactor, SetSpeedFactor)
                    CdaDescription("Speed of Animation")
                    CdaCategory("Animation")
                CdaPropertyEnd()
                CdaProperty(ToggleDirection, ToggleDirectionType, GetToggleDirection, SetToggleDirection)
                    CdaDescription("Change the Animation Direction after completion of Animation")
                    CdaVisibilityTest(IsToggleDirectionPropertyVisible)
                    CdaCategory("Animation")
                CdaPropertyEnd()
                CdaBindableProperty(Direction, DirectionType, GetDirection, SetDirection)
                    CdaDescription("Direction of the Animation")
                    CdaVisibilityTest(IsDirectionPropertyVisible)
                    CdaCategory("Animation")
                CdaBindablePropertyEnd()
                CdaProperty(InterpolationStrategy, InterpolationStrategyType, GetInterpolationStrategy, SetInterpolationStrategy)
                    CdaDescription("Type of Interpolation used for Animation")
                    CdaCategory("Animation")
                CdaPropertyEnd()
                CdaProperty(EaseDirection, EaseDirectionType, GetEaseDirection, SetEaseDirection)
                    CdaDescription("Direction of Ease Interpolation")
                    CdaVisibilityTest(IsEaseInterpolationSelected)
                    CdaCategory("EasingFunction")
                CdaPropertyEnd()
                CdaProperty(FunctionType, FunctionTypeType, GetFunctionType, SetFunctionType)
                    CdaDescription("FunctionType of Ease Interpolation")
                    CdaVisibilityTest(IsEaseInterpolationSelected )
                    CdaCategory("EasingFunction")
                CdaPropertyEnd()
                CdaProperty(Amplitude, AmplitudeType, GetAmplitude, SetAmplitude)
                    CdaDescription("Amplitude : Candera::Float")
                    CdaVisibilityTest(IsEaseInterpolationBackFunctionTypeSelected )
                    CdaCategory("EasingFunction")
                CdaPropertyEnd()
                CdaProperty(RestitutionCoefficient, RestitutionCoefficientType, GetRestitutionCoefficient, SetRestitutionCoefficient)
                    CdaDescription("RestitutionCoefficient : Candera::Float")
                    CdaVisibilityTest(IsEaseInterpolationBounceFunctionTypeSelected )
                    CdaCategory("EasingFunction")
                CdaPropertyEnd()
                CdaProperty(BounceCount, BounceCountType, GetBounceCount, SetBounceCount)
                    CdaDescription("BounceCount : Candera::UInt8")
                    CdaVisibilityTest(IsEaseInterpolationBounceFunctionTypeSelected )
                    CdaCategory("EasingFunction")
                CdaPropertyEnd()
                CdaProperty(ExponentElastic, ExponentElasticType, GetExponentElastic, SetExponentElastic)
                    CdaDescription("ExponentElastic : Candera::Float")
                    CdaVisibilityTest(IsEaseInterpolationElasticFunctionTypeSelected )
                    CdaCategory("EasingFunction")
                CdaPropertyEnd()
                CdaProperty(OscillationCount, OscillationCountType, GetOscillationCount, SetOscillationCount)
                    CdaDescription("OscillationCount : Candera::UInt8")
                    CdaVisibilityTest(IsEaseInterpolationElasticFunctionTypeSelected )
                    CdaCategory("EasingFunction")
                CdaPropertyEnd()
                CdaProperty(Exponent, ExponentType, GetExponent, SetExponent)
                    CdaDescription("Exponent : Candera::Float")
                    CdaVisibilityTest(IsEaseInterpolationExponentialFunctionTypeSelected )
                    CdaCategory("EasingFunction")
                CdaPropertyEnd()
                CdaProperty(Power, PowerType, GetPower, SetPower)
                    CdaDescription("Power : Candera::UInt8")
                    CdaVisibilityTest(IsEaseInterpolationPowerFunctionTypeSelected )
                    CdaCategory("EasingFunction")
                CdaPropertyEnd()
                CdaBindableProperty(ShouldRun, ShouldRunType, GetShouldRun, SetShouldRun)
                    CdaDescription("Auto Start the Animation when the view is loaded")
                    CdaVisibilityTest(IsShouldRunPropertyVisible)
                    CdaCategory("Animation")
                CdaBindablePropertyEnd()
                CdaProperty(RepeatTimes, RepeatTimesType, GetRepeatTimes, SetRepeatTimes)
                    CdaDescription("Number of times the Animation has to repeat")
                    CdaVisibilityTest(IsRepeatTimesPropertyVisible)
                    CdaCategory("Animation")
                CdaPropertyEnd()
                CdaProperty(KeyFrameCount, KeyFrameCountType, GetKeyFrameCount, SetKeyFrameCount)
                    CdaDescription("Number of Key Frames")
                    CdaCategory("Animation")
                CdaPropertyEnd()
                CdaBindableProperty(SequenceTime, SequenceTimeType, GetSequenceTime, SetSequenceTime)
                    CdaDescription("SequenceTime")
                    CdaCategory("Animation")
                CdaBindablePropertyEnd()
                CdaBindableProperty(Channel1, Channel1Type, GetChannel1, SetChannel1)
                    CdaDescription("FirstChannel")
                    CdaCategory("Animation")
                CdaBindablePropertyEnd()
                CdaBindableProperty(Channel2, Channel2Type, GetChannel2, SetChannel2)
                    CdaDescription("SecondChannel")
                    CdaVisibilityTest(IsChannel2Visible)
                    CdaCategory("Animation")
                CdaBindablePropertyEnd()
                CdaProperty(WidgetToAnimate, WidgetToAnimateType, GetWidgetToAnimate, SetWidgetToAnimate)
                    CdaDescription("Associate a widget whose property is to be animated")
                    CdaVisibilityTest(IsAnimateWidgetPropertySelected)
                    CdaCategory("Animation")
                CdaPropertyEnd()
                CdaProperty(WidgetPropertyNameToAnimate, WidgetPropertyNameToAnimateType, GetWidgetPropertyNameToAnimate, SetWidgetPropertyNameToAnimate)
                    CdaDescription("Provide the name of the widget property which has to be animated")
                    CdaVisibilityTest(IsAnimateWidgetPropertySelected)
                    CdaCategory("Animation")
                CdaPropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:

    private:
        PropertyAnimationType m_PropertyAnimation;
        SpeedFactorType m_SpeedFactor;
        ToggleDirectionType m_ToggleDirection;
        DirectionType m_Direction;
        InterpolationStrategyType m_InterpolationStrategy;
        EaseDirectionType m_EaseDirection;
        FunctionTypeType m_FunctionType;
        AmplitudeType m_Amplitude;
        RestitutionCoefficientType m_RestitutionCoefficient;
        BounceCountType m_BounceCount;
        ExponentElasticType m_ExponentElastic;
        OscillationCountType m_OscillationCount;
        ExponentType m_Exponent;
        PowerType m_Power;
        ShouldRunType m_ShouldRun;
        RepeatTimesType m_RepeatTimes;
        KeyFrameCountType m_KeyFrameCount;
        SequenceTimeType m_SequenceTime;
        Channel1Type m_Channel1;
        Channel2Type m_Channel2;
        WidgetToAnimateType m_WidgetToAnimate;
        WidgetPropertyNameToAnimateType m_WidgetPropertyNameToAnimate;

        ::FeatStd::Internal::Vector< ::FeatStd::UInt32 > m_ChangeSetAnimationWidget2DBase;
};

#endif // AnimationWidget2DBase_h
