/************************************************************************
*FILE: AnimationWidget2DBase.cpp 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ***************************************************************************************
 * FILE:          Generated intermediate file from HMIContract.exe
 * SW-COMPONENT:  HMI-BASE
 *  DESCRIPTION:  This file is part of HMI-Base Widget Library 
 *    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
 *
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */
#include "widget2D_std_if.h"

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#include "AnimationWidget2DBase.h"

// ------------------------------------------------------------------------
CGI_WIDGET_RTTI_DEFINITION(AnimationWidget2DBase)

AnimationWidget2DBase::AnimationWidget2DBase() :
    m_PropertyAnimation(Candera::AnimateScale),
    m_SpeedFactor(1.0f),
    m_ToggleDirection(ToggleDirectionType()),
    m_Direction(DirectionType()),
    m_InterpolationStrategy(InterpolationStrategyType()),
    m_EaseDirection(EaseDirectionType()),
    m_FunctionType(FunctionTypeType()),
    m_Amplitude(AmplitudeType()),
    m_RestitutionCoefficient(RestitutionCoefficientType()),
    m_BounceCount(BounceCountType()),
    m_ExponentElastic(0.001f),
    m_OscillationCount(0),
    m_Exponent(0.001f),
    m_Power(1),
    m_ShouldRun(true),
    m_RepeatTimes(1),
    m_KeyFrameCount(2),
    m_SequenceTime("0;1000"),
    m_Channel1("0;1"),
    m_Channel2("0;1"),
    m_WidgetToAnimate(WidgetToAnimateType()),
    m_WidgetPropertyNameToAnimate(WidgetPropertyNameToAnimateType()),
    m_ChangeSetAnimationWidget2DBase()
{
    if (!m_ChangeSetAnimationWidget2DBase.Reserve(1)) {
        FEATSTD_DEBUG_FAIL();
    }
}

AnimationWidget2DBase::~AnimationWidget2DBase()
{
}

void AnimationWidget2DBase::Update()
{
    Base::Update();
    while (!m_ChangeSetAnimationWidget2DBase.Empty()) {
        ::FeatStd::UInt32 propertyId = m_ChangeSetAnimationWidget2DBase[0];
        bool ok = m_ChangeSetAnimationWidget2DBase.Remove(0);
        FEATSTD_DEBUG_ASSERT(ok);
        OnChanged(propertyId);
        FEATSTD_UNUSED(ok);
    }
}

void AnimationWidget2DBase::SetPropertyAnimation(const PropertyAnimationType& propertyanimation)
{
    if (m_PropertyAnimation != propertyanimation) {
        m_PropertyAnimation = propertyanimation;
        if (!m_ChangeSetAnimationWidget2DBase.Contains(static_cast< ::FeatStd::UInt32>(PropertyAnimationPropertyId))) {
            if (!m_ChangeSetAnimationWidget2DBase.Add(static_cast< ::FeatStd::UInt32>(PropertyAnimationPropertyId))) {
                FEATSTD_DEBUG_FAIL();
            }
        }
    }
}

void AnimationWidget2DBase::SetSpeedFactor(const SpeedFactorType& speedfactor)
{
    if (m_SpeedFactor != speedfactor) {
        m_SpeedFactor = speedfactor;
        if (!m_ChangeSetAnimationWidget2DBase.Contains(static_cast< ::FeatStd::UInt32>(SpeedFactorPropertyId))) {
            if (!m_ChangeSetAnimationWidget2DBase.Add(static_cast< ::FeatStd::UInt32>(SpeedFactorPropertyId))) {
                FEATSTD_DEBUG_FAIL();
            }
        }
    }
}

void AnimationWidget2DBase::SetToggleDirection(const ToggleDirectionType& toggledirection)
{
    if (m_ToggleDirection != toggledirection) {
        m_ToggleDirection = toggledirection;
        if (!m_ChangeSetAnimationWidget2DBase.Contains(static_cast< ::FeatStd::UInt32>(ToggleDirectionPropertyId))) {
            if (!m_ChangeSetAnimationWidget2DBase.Add(static_cast< ::FeatStd::UInt32>(ToggleDirectionPropertyId))) {
                FEATSTD_DEBUG_FAIL();
            }
        }
    }
}

void AnimationWidget2DBase::SetDirection(const DirectionType& direction)
{
    if (m_Direction != direction) {
        m_Direction = direction;
        if (!m_ChangeSetAnimationWidget2DBase.Contains(static_cast< ::FeatStd::UInt32>(DirectionPropertyId))) {
            if (!m_ChangeSetAnimationWidget2DBase.Add(static_cast< ::FeatStd::UInt32>(DirectionPropertyId))) {
                FEATSTD_DEBUG_FAIL();
            }
        }
    }
}

void AnimationWidget2DBase::SetInterpolationStrategy(const InterpolationStrategyType& interpolationstrategy)
{
    if (m_InterpolationStrategy != interpolationstrategy) {
        m_InterpolationStrategy = interpolationstrategy;
        if (!m_ChangeSetAnimationWidget2DBase.Contains(static_cast< ::FeatStd::UInt32>(InterpolationStrategyPropertyId))) {
            if (!m_ChangeSetAnimationWidget2DBase.Add(static_cast< ::FeatStd::UInt32>(InterpolationStrategyPropertyId))) {
                FEATSTD_DEBUG_FAIL();
            }
        }
    }
}

void AnimationWidget2DBase::SetEaseDirection(const EaseDirectionType& easedirection)
{
    if (m_EaseDirection != easedirection) {
        m_EaseDirection = easedirection;
        if (!m_ChangeSetAnimationWidget2DBase.Contains(static_cast< ::FeatStd::UInt32>(EaseDirectionPropertyId))) {
            if (!m_ChangeSetAnimationWidget2DBase.Add(static_cast< ::FeatStd::UInt32>(EaseDirectionPropertyId))) {
                FEATSTD_DEBUG_FAIL();
            }
        }
    }
}

void AnimationWidget2DBase::SetFunctionType(const FunctionTypeType& functiontype)
{
    if (m_FunctionType != functiontype) {
        m_FunctionType = functiontype;
        if (!m_ChangeSetAnimationWidget2DBase.Contains(static_cast< ::FeatStd::UInt32>(FunctionTypePropertyId))) {
            if (!m_ChangeSetAnimationWidget2DBase.Add(static_cast< ::FeatStd::UInt32>(FunctionTypePropertyId))) {
                FEATSTD_DEBUG_FAIL();
            }
        }
    }
}

void AnimationWidget2DBase::SetAmplitude(const AmplitudeType& amplitude)
{
    if (m_Amplitude != amplitude) {
        m_Amplitude = amplitude;
        if (!m_ChangeSetAnimationWidget2DBase.Contains(static_cast< ::FeatStd::UInt32>(AmplitudePropertyId))) {
            if (!m_ChangeSetAnimationWidget2DBase.Add(static_cast< ::FeatStd::UInt32>(AmplitudePropertyId))) {
                FEATSTD_DEBUG_FAIL();
            }
        }
    }
}

void AnimationWidget2DBase::SetRestitutionCoefficient(const RestitutionCoefficientType& restitutioncoefficient)
{
    if (m_RestitutionCoefficient != restitutioncoefficient) {
        m_RestitutionCoefficient = restitutioncoefficient;
        if (!m_ChangeSetAnimationWidget2DBase.Contains(static_cast< ::FeatStd::UInt32>(RestitutionCoefficientPropertyId))) {
            if (!m_ChangeSetAnimationWidget2DBase.Add(static_cast< ::FeatStd::UInt32>(RestitutionCoefficientPropertyId))) {
                FEATSTD_DEBUG_FAIL();
            }
        }
    }
}

void AnimationWidget2DBase::SetBounceCount(const BounceCountType& bouncecount)
{
    if (m_BounceCount != bouncecount) {
        m_BounceCount = bouncecount;
        if (!m_ChangeSetAnimationWidget2DBase.Contains(static_cast< ::FeatStd::UInt32>(BounceCountPropertyId))) {
            if (!m_ChangeSetAnimationWidget2DBase.Add(static_cast< ::FeatStd::UInt32>(BounceCountPropertyId))) {
                FEATSTD_DEBUG_FAIL();
            }
        }
    }
}

void AnimationWidget2DBase::SetExponentElastic(const ExponentElasticType& exponentelastic)
{
    if (m_ExponentElastic != exponentelastic) {
        m_ExponentElastic = exponentelastic;
        if (!m_ChangeSetAnimationWidget2DBase.Contains(static_cast< ::FeatStd::UInt32>(ExponentElasticPropertyId))) {
            if (!m_ChangeSetAnimationWidget2DBase.Add(static_cast< ::FeatStd::UInt32>(ExponentElasticPropertyId))) {
                FEATSTD_DEBUG_FAIL();
            }
        }
    }
}

void AnimationWidget2DBase::SetOscillationCount(const OscillationCountType& oscillationcount)
{
    if (m_OscillationCount != oscillationcount) {
        m_OscillationCount = oscillationcount;
        if (!m_ChangeSetAnimationWidget2DBase.Contains(static_cast< ::FeatStd::UInt32>(OscillationCountPropertyId))) {
            if (!m_ChangeSetAnimationWidget2DBase.Add(static_cast< ::FeatStd::UInt32>(OscillationCountPropertyId))) {
                FEATSTD_DEBUG_FAIL();
            }
        }
    }
}

void AnimationWidget2DBase::SetExponent(const ExponentType& exponent)
{
    if (m_Exponent != exponent) {
        m_Exponent = exponent;
        if (!m_ChangeSetAnimationWidget2DBase.Contains(static_cast< ::FeatStd::UInt32>(ExponentPropertyId))) {
            if (!m_ChangeSetAnimationWidget2DBase.Add(static_cast< ::FeatStd::UInt32>(ExponentPropertyId))) {
                FEATSTD_DEBUG_FAIL();
            }
        }
    }
}

void AnimationWidget2DBase::SetPower(const PowerType& power)
{
    if (m_Power != power) {
        m_Power = power;
        if (!m_ChangeSetAnimationWidget2DBase.Contains(static_cast< ::FeatStd::UInt32>(PowerPropertyId))) {
            if (!m_ChangeSetAnimationWidget2DBase.Add(static_cast< ::FeatStd::UInt32>(PowerPropertyId))) {
                FEATSTD_DEBUG_FAIL();
            }
        }
    }
}

void AnimationWidget2DBase::SetShouldRun(const ShouldRunType& shouldrun)
{
    m_ShouldRun = shouldrun;
    if (!m_ChangeSetAnimationWidget2DBase.Contains(static_cast< ::FeatStd::UInt32>(ShouldRunPropertyId))) {
        if (!m_ChangeSetAnimationWidget2DBase.Add(static_cast< ::FeatStd::UInt32>(ShouldRunPropertyId))) {
            FEATSTD_DEBUG_FAIL();
        }
    }
    WakeUpAllRenderComponents();
}

void AnimationWidget2DBase::SetRepeatTimes(const RepeatTimesType& repeattimes)
{
    if (m_RepeatTimes != repeattimes) {
        m_RepeatTimes = repeattimes;
        if (!m_ChangeSetAnimationWidget2DBase.Contains(static_cast< ::FeatStd::UInt32>(RepeatTimesPropertyId))) {
            if (!m_ChangeSetAnimationWidget2DBase.Add(static_cast< ::FeatStd::UInt32>(RepeatTimesPropertyId))) {
                FEATSTD_DEBUG_FAIL();
            }
        }
    }
}

void AnimationWidget2DBase::SetKeyFrameCount(const KeyFrameCountType& keyframecount)
{
    if (m_KeyFrameCount != keyframecount) {
        m_KeyFrameCount = keyframecount;
        if (!m_ChangeSetAnimationWidget2DBase.Contains(static_cast< ::FeatStd::UInt32>(KeyFrameCountPropertyId))) {
            if (!m_ChangeSetAnimationWidget2DBase.Add(static_cast< ::FeatStd::UInt32>(KeyFrameCountPropertyId))) {
                FEATSTD_DEBUG_FAIL();
            }
        }
    }
}

void AnimationWidget2DBase::SetSequenceTime(const SequenceTimeType& sequencetime)
{
    if (m_SequenceTime != sequencetime) {
        m_SequenceTime = sequencetime;
        if (!m_ChangeSetAnimationWidget2DBase.Contains(static_cast< ::FeatStd::UInt32>(SequenceTimePropertyId))) {
            if (!m_ChangeSetAnimationWidget2DBase.Add(static_cast< ::FeatStd::UInt32>(SequenceTimePropertyId))) {
                FEATSTD_DEBUG_FAIL();
            }
        }
    }
}

void AnimationWidget2DBase::SetChannel1(const Channel1Type& channel1)
{
    if (m_Channel1 != channel1) {
        m_Channel1 = channel1;
        if (!m_ChangeSetAnimationWidget2DBase.Contains(static_cast< ::FeatStd::UInt32>(Channel1PropertyId))) {
            if (!m_ChangeSetAnimationWidget2DBase.Add(static_cast< ::FeatStd::UInt32>(Channel1PropertyId))) {
                FEATSTD_DEBUG_FAIL();
            }
        }
    }
}

void AnimationWidget2DBase::SetChannel2(const Channel2Type& channel2)
{
    if (m_Channel2 != channel2) {
        m_Channel2 = channel2;
        if (!m_ChangeSetAnimationWidget2DBase.Contains(static_cast< ::FeatStd::UInt32>(Channel2PropertyId))) {
            if (!m_ChangeSetAnimationWidget2DBase.Add(static_cast< ::FeatStd::UInt32>(Channel2PropertyId))) {
                FEATSTD_DEBUG_FAIL();
            }
        }
    }
}

void AnimationWidget2DBase::SetWidgetToAnimate(const WidgetToAnimateType& widgettoanimate)
{
    if (m_WidgetToAnimate != widgettoanimate) {
        m_WidgetToAnimate = widgettoanimate;
    }
}

void AnimationWidget2DBase::SetWidgetPropertyNameToAnimate(const WidgetPropertyNameToAnimateType& widgetpropertynametoanimate)
{
    if (m_WidgetPropertyNameToAnimate != widgetpropertynametoanimate) {
        m_WidgetPropertyNameToAnimate = widgetpropertynametoanimate;
    }
}
