/************************************************************************
*FILE: AngularSliderWidget2DBase.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(AngularSliderWidget2DBase_h)
#define AngularSliderWidget2DBase_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/Rtti/Rtti.h>
#include <Widgets/2D/Slider/SliderWidget2D.h>
        // Enum data types
#define ENUM_DATA_TYPE \
    ENUM_DATA_TYPE_BEGIN(AngularSliderType)  \
    ENUM_DATA_TYPE_ITEM(AngularSliderSemiCircle)   \
    ENUM_DATA_TYPE_ITEM(AngularSliderFullCircle)  \
    ENUM_DATA_TYPE_END(AngularSliderType)
#include <Candera/System/MetaInfo/EnumDataType.h>
// ------------------------------------------------------------------------
//! [AngularSliderWidget2DBase_Declaration]
class AngularSliderWidget2DBase : public ::SliderWidget2D
{
    public:
            virtual bool ComposerPropFilterNotAngularSlider() const { return false; }
            virtual bool ComposerPropFilterIsNotTypeFullCircle() const {
            if(GetAngularSliderType() == Candera::AngularSliderFullCircle)
              return false;
              else
              return true;
            }
        typedef Candera::AngularSliderType AngularSliderTypeType;

        typedef Candera::enRotationDirection RotationTypeType;

        typedef Candera::Float MinimumAngleType;

        typedef Candera::Float MaximumAngleType;

        typedef Candera::Float PaddingMinimumAngleType;

        typedef Candera::Float PaddingMaximumAngleType;

        typedef Candera::Float TouchableRadiusType;

        typedef Candera::Float TouchableRadiusOffsetType;

        typedef bool EnableAnimationType;

        typedef FeatStd::UInt16 AnimationDurationType;

        AngularSliderWidget2DBase();
        virtual ~AngularSliderWidget2DBase();

        CGI_WIDGET_RTTI_DECLARATION(AngularSliderWidget2DBase, ::SliderWidget2D);

        void SetAngularSliderType(const AngularSliderTypeType& angularslidertype);
        const AngularSliderTypeType& GetAngularSliderType() const { return m_AngularSliderType; }

        void SetRotationType(const RotationTypeType& rotationtype);
        const RotationTypeType& GetRotationType() const { return m_RotationType; }

        void SetMinimumAngle(const MinimumAngleType& minimumangle);
        const MinimumAngleType& GetMinimumAngle() const { return m_MinimumAngle; }

        void SetMaximumAngle(const MaximumAngleType& maximumangle);
        const MaximumAngleType& GetMaximumAngle() const { return m_MaximumAngle; }

        void SetPaddingMinimumAngle(const PaddingMinimumAngleType& paddingminimumangle);
        const PaddingMinimumAngleType& GetPaddingMinimumAngle() const { return m_PaddingMinimumAngle; }

        void SetPaddingMaximumAngle(const PaddingMaximumAngleType& paddingmaximumangle);
        const PaddingMaximumAngleType& GetPaddingMaximumAngle() const { return m_PaddingMaximumAngle; }

        void SetTouchableRadius(const TouchableRadiusType& touchableradius);
        const TouchableRadiusType& GetTouchableRadius() const { return m_TouchableRadius; }

        void SetTouchableRadiusOffset(const TouchableRadiusOffsetType& touchableradiusoffset);
        const TouchableRadiusOffsetType& GetTouchableRadiusOffset() const { return m_TouchableRadiusOffset; }

        void SetEnableAnimation(const EnableAnimationType& enableanimation);
        const EnableAnimationType& GetEnableAnimation() const { return m_EnableAnimation; }

        void SetAnimationDuration(const AnimationDurationType& animationduration);
        const AnimationDurationType& GetAnimationDuration() const { return m_AnimationDuration; }

        // @WidgetBaseClass
        CdaWidget2DDef(AngularSliderWidget2DBase, ::SliderWidget2D)
            CdaDescription("The slider is the widget for controlling a value by positioning a knob / thumb in a legal range.")
            CdaReadableName("AngularSliderWidget2DBase")
            CdaCategory("Range")

            CdaProperties()
                CdaProperty(AngularSliderType, AngularSliderTypeType, GetAngularSliderType, SetAngularSliderType)
                    CdaDescription("Type of angular slider")
                CdaPropertyEnd()
                CdaProperty(RotationType, RotationTypeType, GetRotationType, SetRotationType)
                    CdaDescription("Type of angular slider rotation")
                CdaPropertyEnd()
                CdaProperty(MinimumAngle, MinimumAngleType, GetMinimumAngle, SetMinimumAngle)
                    CdaDescription("Angle of the Indicator to represent the minimum value")
                CdaPropertyEnd()
                CdaProperty(MaximumAngle, MaximumAngleType, GetMaximumAngle, SetMaximumAngle)
                    CdaDescription("Angle of the Indicator to represent the maximum value")
                    CdaVisibilityTest(ComposerPropFilterIsNotTypeFullCircle)
                CdaPropertyEnd()
                CdaProperty(PaddingMinimumAngle, PaddingMinimumAngleType, GetPaddingMinimumAngle, SetPaddingMinimumAngle)
                    CdaDescription("Minimum padding angle for which the marker will be positioned for the minimum value")
                CdaPropertyEnd()
                CdaProperty(PaddingMaximumAngle, PaddingMaximumAngleType, GetPaddingMaximumAngle, SetPaddingMaximumAngle)
                    CdaDescription("Maximum padding angle for which the marker will be positioned for the maximum value")
                CdaPropertyEnd()
                CdaProperty(TouchableRadius, TouchableRadiusType, GetTouchableRadius, SetTouchableRadius)
                    CdaDescription("Distance from the center of the angular slider to the required touchable region ")
                    CdaCategory("Touch Region")
                CdaPropertyEnd()
                CdaProperty(TouchableRadiusOffset, TouchableRadiusOffsetType, GetTouchableRadiusOffset, SetTouchableRadiusOffset)
                    CdaDescription("Offset from the Touchable radius to be considered as touchable region")
                    CdaCategory("Touch Region")
                CdaPropertyEnd()
                CdaProperty(EnableAnimation, EnableAnimationType, GetEnableAnimation, SetEnableAnimation)
                    CdaDescription("Enable animation for marker node ")
                    CdaCategory("Animation")
                CdaPropertyEnd()
                CdaProperty(AnimationDuration, AnimationDurationType, GetAnimationDuration, SetAnimationDuration)
                    CdaDescription("Animation duration for which the marker node rotation to be animated ")
                    CdaCategory("Animation")
                CdaPropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:

    private:
        AngularSliderTypeType m_AngularSliderType;
        RotationTypeType m_RotationType;
        MinimumAngleType m_MinimumAngle;
        MaximumAngleType m_MaximumAngle;
        PaddingMinimumAngleType m_PaddingMinimumAngle;
        PaddingMaximumAngleType m_PaddingMaximumAngle;
        TouchableRadiusType m_TouchableRadius;
        TouchableRadiusOffsetType m_TouchableRadiusOffset;
        EnableAnimationType m_EnableAnimation;
        AnimationDurationType m_AnimationDuration;
};

#endif // AngularSliderWidget2DBase_h
