/************************************************************************
*FILE: Touchable2DBase.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(Touchable2DBase_h)
#define Touchable2DBase_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/Rtti/Rtti.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Widgets/2D/BaseWidget2D.h>

#define ENUM_DATA_TYPE                                                        \
ENUM_DATA_TYPE_BEGIN(enGestureDirection)                        \
ENUM_DATA_TYPE_ITEM_VALUE(enVertical, 0)                \
ENUM_DATA_TYPE_ITEM_VALUE(enHorizontal, 1)                \
ENUM_DATA_TYPE_ITEM_VALUE(en2D, 2)   \
ENUM_DATA_TYPE_END(enGestureDirection)

#include <Candera/System/MetaInfo/EnumDataType.h>

#define ENUM_DATA_TYPE                                                        \
ENUM_DATA_TYPE_BEGIN(enRotationDirection)                        \
ENUM_DATA_TYPE_ITEM_VALUE(enClockWise, 0)                \
ENUM_DATA_TYPE_ITEM_VALUE(enAntiClockWise, 1)                \
ENUM_DATA_TYPE_END(enRotationDirection)

#include <Candera/System/MetaInfo/EnumDataType.h>
// ------------------------------------------------------------------------
//! [Touchable2DBase_Declaration]
class Touchable2DBase : public ::BaseWidget2D
{
    public:
        typedef bool TouchableType;

        typedef FeatStd::UInt32 TouchPriorityType;

        typedef FeatStd::UInt32 GestureConfigIdType;

        typedef bool TapType;

        typedef bool DoubleTapType;

        typedef bool PressHoldType;

        typedef bool PressRepeatType;

        typedef bool DragType;

        typedef Candera::enGestureDirection DragDirectionType;

        typedef bool SwipeType;

        typedef Candera::enGestureDirection SwipeDirectionType;

        typedef bool PinchSpreadType;

        typedef bool RotateType;

        typedef bool RawTouchType;

        typedef bool DragDropSourceEnabledType;

        typedef bool DragDropDestinationEnabledType;

        //! [Property_IDs]
        static const FeatStd::UInt32 TouchablePropertyId = 0xC75E5226;
        static const FeatStd::UInt32 TouchPriorityPropertyId = 0x250130AA;
        static const FeatStd::UInt32 DragDirectionPropertyId = 0x90E636EE;
        //! [Property_IDs]

        Touchable2DBase();
        virtual ~Touchable2DBase();

        CGI_WIDGET_RTTI_DECLARATION(Touchable2DBase, ::BaseWidget2D);

        //! [DataBinding_TouchablePropertyGetterSetter]
        void SetTouchable(const TouchableType& touchable);
        const TouchableType& GetTouchable() const { return m_Touchable; }
        //! [DataBinding_TouchablePropertyGetterSetter]

        //! [DataBinding_TouchPriorityPropertyGetterSetter]
        void SetTouchPriority(const TouchPriorityType& touchpriority);
        const TouchPriorityType& GetTouchPriority() const { return m_TouchPriority; }
        //! [DataBinding_TouchPriorityPropertyGetterSetter]

        //! [DataBinding_GestureConfigIdPropertyGetterSetter]
        void SetGestureConfigId(const GestureConfigIdType& gestureconfigid);
        const GestureConfigIdType& GetGestureConfigId() const { return m_GestureConfigId; }
        //! [DataBinding_GestureConfigIdPropertyGetterSetter]

        //! [DataBinding_TapPropertyGetterSetter]
        void SetTap(const TapType& tap);
        const TapType& GetTap() const { return m_Tap; }
        //! [DataBinding_TapPropertyGetterSetter]

        //! [DataBinding_DoubleTapPropertyGetterSetter]
        void SetDoubleTap(const DoubleTapType& doubletap);
        const DoubleTapType& GetDoubleTap() const { return m_DoubleTap; }
        //! [DataBinding_DoubleTapPropertyGetterSetter]

        //! [DataBinding_PressHoldPropertyGetterSetter]
        void SetPressHold(const PressHoldType& presshold);
        const PressHoldType& GetPressHold() const { return m_PressHold; }
        //! [DataBinding_PressHoldPropertyGetterSetter]

        //! [DataBinding_PressRepeatPropertyGetterSetter]
        void SetPressRepeat(const PressRepeatType& pressrepeat);
        const PressRepeatType& GetPressRepeat() const { return m_PressRepeat; }
        //! [DataBinding_PressRepeatPropertyGetterSetter]

        //! [DataBinding_DragPropertyGetterSetter]
        void SetDrag(const DragType& drag);
        const DragType& GetDrag() const { return m_Drag; }
        //! [DataBinding_DragPropertyGetterSetter]

        void SetDragDirection(const DragDirectionType& dragdirection);
        const DragDirectionType& GetDragDirection() const { return m_DragDirection; }

        //! [DataBinding_SwipePropertyGetterSetter]
        void SetSwipe(const SwipeType& swipe);
        const SwipeType& GetSwipe() const { return m_Swipe; }
        //! [DataBinding_SwipePropertyGetterSetter]

        void SetSwipeDirection(const SwipeDirectionType& swipedirection);
        const SwipeDirectionType& GetSwipeDirection() const { return m_SwipeDirection; }

        //! [DataBinding_PinchSpreadPropertyGetterSetter]
        void SetPinchSpread(const PinchSpreadType& pinchspread);
        const PinchSpreadType& GetPinchSpread() const { return m_PinchSpread; }
        //! [DataBinding_PinchSpreadPropertyGetterSetter]

        //! [DataBinding_RotatePropertyGetterSetter]
        void SetRotate(const RotateType& rotate);
        const RotateType& GetRotate() const { return m_Rotate; }
        //! [DataBinding_RotatePropertyGetterSetter]

        //! [DataBinding_RawTouchPropertyGetterSetter]
        void SetRawTouch(const RawTouchType& rawtouch);
        const RawTouchType& GetRawTouch() const { return m_RawTouch; }
        //! [DataBinding_RawTouchPropertyGetterSetter]

        //! [DataBinding_DragDropSourceEnabledPropertyGetterSetter]
        void SetDragDropSourceEnabled(const DragDropSourceEnabledType& dragdropsourceenabled);
        const DragDropSourceEnabledType& GetDragDropSourceEnabled() const { return m_DragDropSourceEnabled; }
        //! [DataBinding_DragDropSourceEnabledPropertyGetterSetter]

        //! [DataBinding_DragDropDestinationEnabledPropertyGetterSetter]
        void SetDragDropDestinationEnabled(const DragDropDestinationEnabledType& dragdropdestinationenabled);
        const DragDropDestinationEnabledType& GetDragDropDestinationEnabled() const { return m_DragDropDestinationEnabled; }
        //! [DataBinding_DragDropDestinationEnabledPropertyGetterSetter]

        // @WidgetBaseClass
        CdaWidget2DDef(Touchable2DBase, ::BaseWidget2D)
            CdaDescription("Widget provides generic properties which each widget will be needing to perform a set of actions based on the properties and the same is a 2D widget")
            CdaReadableName("Touchable2DBase")

            CdaProperties()
                CdaBindableProperty(Touchable, TouchableType, GetTouchable, SetTouchable)
                    CdaDescription("Widget is Touchable or not")
                CdaBindablePropertyEnd()
                CdaBindableProperty(TouchPriority, TouchPriorityType, GetTouchPriority, SetTouchPriority)
                    CdaDescription("Increase this priority to handle touch message for this widget before widgets with a lower priority")
                CdaBindablePropertyEnd()
                CdaBindableProperty(GestureConfigId, GestureConfigIdType, GetGestureConfigId, SetGestureConfigId)
                    CdaDescription("Identifies the gesture configuration used for this widget.\n   Gesture configurations are registered at start-up and attached to widgets using numerical ids (0 is used for the default configuration defined in the widget).\n   For more information please read the gesture configuration chapter in the widget user guide.")
                    CdaCategory("Gestures")
                CdaBindablePropertyEnd()
                CdaBindableProperty(Tap, TapType, GetTap, SetTap)
                    CdaDescription("Enable press and tap gesture detection")
                    CdaVisibilityTest(composerPropVisibleFilterTap)
                    CdaCategory("Gestures")
                CdaBindablePropertyEnd()
                CdaBindableProperty(DoubleTap, DoubleTapType, GetDoubleTap, SetDoubleTap)
                    CdaDescription("Enable double tap gesture detection")
                    CdaVisibilityTest(composerPropVisibleFilterDoubleTap)
                    CdaCategory("Gestures")
                CdaBindablePropertyEnd()
                CdaBindableProperty(PressHold, PressHoldType, GetPressHold, SetPressHold)
                    CdaDescription("Enable hold gesture detection")
                    CdaVisibilityTest(composerPropVisibleFilterPressHold)
                    CdaCategory("Gestures")
                CdaBindablePropertyEnd()
                CdaBindableProperty(PressRepeat, PressRepeatType, GetPressRepeat, SetPressRepeat)
                    CdaDescription("Enable repeat gesture detection")
                    CdaVisibilityTest(composerPropVisibleFilterPressRepeat)
                    CdaCategory("Gestures")
                CdaBindablePropertyEnd()
                CdaBindableProperty(Drag, DragType, GetDrag, SetDrag)
                    CdaDescription("Enable drag gesture detection")
                    CdaVisibilityTest(composerPropVisibleFilterDrag)
                    CdaCategory("Gestures")
                CdaBindablePropertyEnd()
                CdaProperty(DragDirection, DragDirectionType, GetDragDirection, SetDragDirection)
                    CdaDescription("Direction in which drag should be detected")
                    CdaVisibilityTest(composerPropVisibleFilterDragDirection)
                    CdaCategory("Gestures")
                CdaPropertyEnd()
                CdaBindableProperty(Swipe, SwipeType, GetSwipe, SetSwipe)
                    CdaDescription("Enable swipe gesture detection")
                    CdaVisibilityTest(composerPropVisibleFilterSwipe)
                    CdaCategory("Gestures")
                CdaBindablePropertyEnd()
                CdaProperty(SwipeDirection, SwipeDirectionType, GetSwipeDirection, SetSwipeDirection)
                    CdaDescription("Direction in which swipe should be detected")
                    CdaVisibilityTest(composerPropVisibleFilterSwipeDirection)
                    CdaCategory("Gestures")
                CdaPropertyEnd()
                CdaBindableProperty(PinchSpread, PinchSpreadType, GetPinchSpread, SetPinchSpread)
                    CdaDescription("Enable pinch and spread gesture detection")
                    CdaVisibilityTest(composerPropVisibleFilterPinchSpread)
                    CdaCategory("Gestures")
                CdaBindablePropertyEnd()
                CdaBindableProperty(Rotate, RotateType, GetRotate, SetRotate)
                    CdaDescription("Enable rotate gesture detection")
                    CdaVisibilityTest(composerPropVisibleFilterRotate)
                    CdaCategory("Gestures")
                CdaBindablePropertyEnd()
                CdaBindableProperty(RawTouch, RawTouchType, GetRawTouch, SetRawTouch)
                    CdaDescription("Enable raw touch coordinate routing (mainly for hand writing recognition)")
                    CdaVisibilityTest(composerPropVisibleFilterRawTouch)
                    CdaCategory("Gestures")
                CdaBindablePropertyEnd()
                CdaBindableProperty(DragDropSourceEnabled, DragDropSourceEnabledType, GetDragDropSourceEnabled, SetDragDropSourceEnabled)
                    CdaDescription("Enables the widget to be used as the source of a drag and drop operation.")
                    CdaVisibilityTest(composerPropVisibleFilterDragDrop)
                    CdaCategory("DragDrop")
                CdaBindablePropertyEnd()
                CdaBindableProperty(DragDropDestinationEnabled, DragDropDestinationEnabledType, GetDragDropDestinationEnabled, SetDragDropDestinationEnabled)
                    CdaDescription("Enables the widget to be used as the target of a drag and drop operation.")
                    CdaVisibilityTest(composerPropVisibleFilterDragDrop)
                    CdaCategory("DragDrop")
                CdaBindablePropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:
virtual bool composerPropVisibleFilterTap() const { return true; }
virtual bool composerPropVisibleFilterDoubleTap() const { return composerPropVisibleFilterTap() && GetTap(); }
virtual bool composerPropVisibleFilterPressHold() const { return composerPropVisibleFilterTap() && GetTap(); }
virtual bool composerPropVisibleFilterPressRepeat() const { return composerPropVisibleFilterTap() && GetTap(); }

virtual bool composerPropVisibleFilterDrag() const { return true; }
virtual bool composerPropVisibleFilterDragDirection() const { return composerPropVisibleFilterDrag() && GetDrag(); }

virtual bool composerPropVisibleFilterSwipe() const { return true; }
virtual bool composerPropVisibleFilterSwipeDirection() const { return composerPropVisibleFilterSwipe() && GetSwipe(); }

virtual bool composerPropVisibleFilterPinchSpread() const { return true; }
virtual bool composerPropVisibleFilterRotate() const { return true; }
virtual bool composerPropVisibleFilterRawTouch() const { return false; }

virtual bool composerPropVisibleFilterDragDrop() const { return true; }

    private:
        TouchableType m_Touchable;
        TouchPriorityType m_TouchPriority;
        GestureConfigIdType m_GestureConfigId;
        TapType m_Tap;
        DoubleTapType m_DoubleTap;
        PressHoldType m_PressHold;
        PressRepeatType m_PressRepeat;
        DragType m_Drag;
        DragDirectionType m_DragDirection;
        SwipeType m_Swipe;
        SwipeDirectionType m_SwipeDirection;
        PinchSpreadType m_PinchSpread;
        RotateType m_Rotate;
        RawTouchType m_RawTouch;
        DragDropSourceEnabledType m_DragDropSourceEnabled;
        DragDropDestinationEnabledType m_DragDropDestinationEnabled;
};

#endif // Touchable2DBase_h
