/************************************************************************
*FILE: AppHmi_TunerStateMachineData.cpp 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/*
 * Id:        AppHmi_TunerStateMachineData.cpp
 *
 * Function:  VS System Data Source File.
 *
 * Generated: Wed May 25 00:12:28 2022
 *
 * Coder 7, 3, 2, 2426
 * 
 * This is an automatically generated file. It will be overwritten by the Coder.
 * 
 * DO NOT EDIT THE FILE!
 */


#include "AppHmi_TunerStateMachineSEMLibB.h"


#include "AppHmi_TunerStateMachineData.h"


#include <stdarg.h>


/*
 * VS System External Variable Definitions.
 */
VS_INT DABSource = 0;

VS_UINT32 sm_gAudioSource = 255ul;

VS_UINT32 sm_gCurrentView = 255ul;

VS_BOOL sm_gIsDABComponentMode = 0;

VS_INT32 sm_gKDS_Src_sel = 0L;

VS_INT sm_gPreviousView = 255;

VS_INT sm_gSwitchState = 1;

VS_INT sm_gTargetView = 255;


/*
 * SEM Deduct Function.
 */
unsigned char AppHmi_TunerStateMachine::SEM_Deduct (SEM_EVENT_TYPE EventNo, ...)
{
  va_list ap;

  va_start(ap, EventNo);
  if (SEM.State == 0x00u /* STATE_SEM_NOT_INITIALIZED */)
  {
    return SES_NOT_INITIALIZED;
  }
  if (VS_NOF_EVENTS <= EventNo)
  {
    return (SES_RANGE_ERR);
  }
  switch (EventNo)
  {
  case 733:
    EventArgsVar.DB752.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 737:
    EventArgsVar.DB752.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 738:
    EventArgsVar.DB752.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 739:
    EventArgsVar.DB752.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 740:
    EventArgsVar.DB752.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 741:
    EventArgsVar.DB752.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 742:
    EventArgsVar.DB742.VS_INT8Var[0] = (VS_INT8) va_arg(ap, VS_INT);
    break;

  case 752:
    EventArgsVar.DB752.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 753:
    EventArgsVar.DB752.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 754:
    EventArgsVar.DB757.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 755:
    EventArgsVar.DB757.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 756:
    EventArgsVar.DB757.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 757:
    EventArgsVar.DB757.VS_INT32Var[0] = (VS_INT32) va_arg(ap, VS_INT32_VAARG);
    EventArgsVar.DB757.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 758:
    EventArgsVar.DB757.VS_INT32Var[0] = (VS_INT32) va_arg(ap, VS_INT32_VAARG);
    EventArgsVar.DB757.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 759:
    EventArgsVar.DB757.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 760:
    EventArgsVar.DB757.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 761:
    EventArgsVar.DB757.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 762:
    EventArgsVar.DB757.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  default:
    break;
  }
  SEM.EventNo = EventNo;
  SEM.DIt = 2;
  SEM.State = 0x02u; /* STATE_SEM_PREPARE */

  va_end(ap);
  return (SES_OKAY);
}


/*
 * Guard Expression Functions.
 */
VS_BOOL AppHmi_TunerStateMachine::VSGuard (SEM_GUARD_EXPRESSION_TYPE i)
{
  switch (i)
  {
  case 0:
    return (VS_BOOL)(EventArgsVar.DB752.VS_UINT32Var[0] == Enum_TUNER_GADGET);
  case 1:
    return (VS_BOOL)(DABSource == 1);
  case 2:
    return (VS_BOOL)(EventArgsVar.DB752.VS_UINT32Var[0] == TunerModule_SysPopupScene_Pfo_PTY31);
  case 3:
    return (VS_BOOL)(EventArgsVar.DB752.VS_UINT32Var[0] == TunerModule_SysPopupScene_Pfo_TA);
  case 4:
    return (VS_BOOL)(EventArgsVar.DB752.VS_UINT32Var[0] == TunerModule_SysPopupScene_Pfo_WB);
  case 5:
    return (VS_BOOL)(EventArgsVar.DB752.VS_UINT32Var[0] == Enum_TUNER_GADGET_SEEKMENU);
  case 6:
    return (VS_BOOL)(EventArgsVar.DB752.VS_UINT32Var[0] == Enum_TUNER_GADGET_MUTE);
  case 7:
    return (VS_BOOL)(EventArgsVar.DB752.VS_UINT32Var[0] == Enum_TUNER_GADGET_FREQUENCY);
  case 8:
    return (VS_BOOL)(EventArgsVar.DB757.VS_UINT32Var[0] == TunerModule_TunerPopupScene_Pfo_StorePreset);
  case 9:
    return (VS_BOOL)(EventArgsVar.DB757.VS_UINT32Var[0] == TunerModule_TunerPopupScene_Pfo_UpdateDAB_SL);
  case 10:
    return (VS_BOOL)(EventArgsVar.DB757.VS_UINT32Var[0] == TunerModule_TunerPopupScene_Pfo_AutoStore);
  case 11:
    return (VS_BOOL)(EventArgsVar.DB757.VS_UINT32Var[0] == TunerModule_TunerPopupScene_Pfo_UpdateFM_SL);
  case 12:
    return (VS_BOOL)(EventArgsVar.DB757.VS_UINT32Var[0] == TunerModule_TunerPopupScene_Pfo_CannotStore);
  case 13:
    return (VS_BOOL)(sm_gTargetView == VIEW_SOURCE_SELECTION);
  case 14:
    return (VS_BOOL)(sm_gTargetView == VIEW_FM2);
  case 15:
    return (VS_BOOL)(sm_gTargetView == VIEW_SOURCE_SELECTION_woNAV);
  case 16:
    return (VS_BOOL)(sm_gTargetView == VIEW_OPT_FMAM);
  case 17:
    return (VS_BOOL)(sm_gTargetView == VIEW_AM && sm_gAudioSource == 1);
  case 18:
    return (VS_BOOL)(sm_gTargetView == VIEW_FM_SL);
  case 19:
    return (VS_BOOL)(sm_gTargetView == VIEW_AM_AST);
  case 20:
    return (VS_BOOL)(sm_gTargetView == VIEW_DAB && sm_gAudioSource == 2);
  case 21:
    return (VS_BOOL)(sm_gTargetView == VIEW_DAB_AST);
  case 22:
    return (VS_BOOL)(sm_gTargetView == VIEW_FM_TESTMODE);
  case 23:
    return (VS_BOOL)(sm_gTargetView == VIEW_FM_MONITORTESTMODE);
  case 24:
    return (VS_BOOL)(sm_gTargetView == VIEW_AM_TESTMODE);
  case 25:
    return (VS_BOOL)(sm_gTargetView == VIEW_AM_MONITORTESTMODE);
  case 26:
    return (VS_BOOL)(sm_gTargetView == VIEW_DAB_SL);
  case 27:
    return (VS_BOOL)(sm_gTargetView == VIEW_OPT_DABPTY);
  case 28:
    return (VS_BOOL)(sm_gTargetView == VIEW_TT_MONITOR1);
  case 29:
    return (VS_BOOL)(sm_gTargetView == VIEW_TT_MONITOR2);
  case 30:
    return (VS_BOOL)(sm_gTargetView == VIEW_TT_MONITOR3);
  case 31:
    return (VS_BOOL)(sm_gTargetView == VIEW_DAB_SETUP_MONITOR);
  case 32:
    return (VS_BOOL)(sm_gTargetView == VIEW_AF_LIST);
  case 33:
    return (VS_BOOL)(sm_gTargetView == VIEW_TMC);
  case 34:
    return (VS_BOOL)(sm_gTargetView == VIEW_TMC_INFO);
  case 35:
    return (VS_BOOL)(sm_gTargetView == VIEW_DAB_QUALITY_TESTMODE);
  case 36:
    return (VS_BOOL)(sm_gTargetView == VIEW_DAB_EXPERT_API_TESTMODE);
  case 37:
    return (VS_BOOL)(sm_gTargetView == VIEW_DAB_SERVICE_INFO_TESTMODE);
  case 38:
    return (VS_BOOL)(sm_gTargetView == VIEW_TMC_LIST);
  case 39:
    return (VS_BOOL)(sm_gTargetView == VIEW_TESTMODESCREENS);
  case 40:
    return (VS_BOOL)(sm_gTargetView == VIEW_TMC_STN_INFO);
  case 41:
    return (VS_BOOL)(sm_gTargetView == VIEW_DRM);
  case 42:
    return (VS_BOOL)(sm_gTargetView == VIEW_DRM_AST);
  case 43:
    return (VS_BOOL)(sm_gTargetView == VIEW_DRM_SL);
  case 44:
    return (VS_BOOL)(sm_gTargetView == VIEW_DRM_TESTMODE);
  case 45:
    return (VS_BOOL)(sm_gTargetView == VIEW_DRM_TESTMODESCREEN);
  case 46:
    return (VS_BOOL)(sm_gTargetView == VIEW_DAB_MONITOR);
  case 47:
    return (VS_BOOL)(sm_gTargetView == VIEW_OPT_DRMPTY);
  case 48:
    return (VS_BOOL)(sm_gTargetView == VIEW_WEATHERBAND && sm_gAudioSource == 9);
  case 49:
    return (VS_BOOL)(sm_gTargetView == VIEW_FM1 && sm_gAudioSource == 0);
  case 50:
    return (VS_BOOL)(sm_gTargetView == VIEW_FM_INFO);
  case 51:
    return (VS_BOOL)(sm_gTargetView == VIEW_AM_INFO);
  case 52:
    return (VS_BOOL)(sm_gTargetView == VIEW_HDDTM_TESTMODE);
  case 53:
    return (VS_BOOL)(sm_gTargetView == VIEW_HDPARAMTUNING_TESTMODE);
  case 54:
    return (VS_BOOL)(sm_gTargetView == VIEW_SOURCE_SELECTION || sm_gTargetView == TUNER_VIEW_INVALID);
  case 55:
    return (VS_BOOL)(sm_gTargetView == VIEW_FM_AST);
  case 56:
    return (VS_BOOL)(sm_gTargetView == VIEW_WEATHERBAND_MONITOR);
  case 57:
    return (VS_BOOL)(sm_gIsDABComponentMode == 1);
  }
  return (VS_BOOL)(sm_gIsDABComponentMode == 0);
}


/*
 * Action Expressions Wrapper Function.
 */
VS_VOID AppHmi_TunerStateMachine::VSAction (SEM_ACTION_EXPRESSION_TYPE i)
{
  switch (i)
  {
  case 0:
    Activate_DAB_TestMode();
    break;
  case 1:
    DABStationBrowseList();
    break;
  case 3:
    Notify_Init_Finished();
    break;
  case 4:
    Perform_Abort_Next_Previous_Icon_fn();
    break;
  case 5:
    Perform_Activate_Home_Source();
    break;
  case 6:
    Perform_AutoStore_AM();
    break;
  case 7:
    Perform_AutoStore_DAB();
    break;
  case 8:
    Perform_AutoStore_FM();
    break;
  case 9:
    Perform_BTPhoneMsgChange();
    break;
  case 10:
    Perform_BandSelect_Tuner1();
    break;
  case 11:
    Perform_BandSelect_Tuner2();
    break;
  case 12:
    Perform_BandSelect_Tuner3();
    break;
  case 13:
    Perform_BandSelect_Tuner4();
    break;
  case 14:
    Perform_CLevel_Dec();
    break;
  case 15:
    Perform_CLevel_Inc();
    break;
  case 16:
    Perform_CannotStore_Popup();
    break;
  case 17:
    Perform_DAB_TM_Ensemble_Seek_Next();
    break;
  case 18:
    Perform_DAB_TM_Ensemble_Seek_Previous();
    break;
  case 19:
    Perform_DAB_TM_Freq_Seek_Next();
    break;
  case 20:
    Perform_DAB_TM_Freq_Seek_Previous();
    break;
  case 21:
    Perform_Freq_Scan_Start();
    break;
  case 23:
    Perform_Freq_Tuning_StepDown();
    break;
  case 24:
    Perform_Freq_Tuning_StepUp();
    break;
  case 26:
    Perform_Home_Src_Toggle();
    break;
  case 27:
    Perform_Main_Src_Select();
    break;
  case 28:
    Perform_MediaChange();
    break;
  case 29:
    Perform_MirrorLinkChange();
    break;
  case 30:
    Perform_NaviChange();
    break;
  case 31:
    Perform_Next_fn();
    break;
  case 32:
    Perform_Next_fn_AM();
    break;
  case 33:
    Perform_Next_fn_DAB();
    break;
  case 34:
    Perform_Next_fn_FM();
    break;
  case 35:
    Perform_Preset_Popup_1();
    break;
  case 36:
    Perform_Preset_Popup_10();
    break;
  case 37:
    Perform_Preset_Popup_11();
    break;
  case 38:
    Perform_Preset_Popup_12();
    break;
  case 39:
    Perform_Preset_Popup_2();
    break;
  case 40:
    Perform_Preset_Popup_3();
    break;
  case 41:
    Perform_Preset_Popup_4();
    break;
  case 42:
    Perform_Preset_Popup_5();
    break;
  case 43:
    Perform_Preset_Popup_6();
    break;
  case 44:
    Perform_Preset_Popup_7();
    break;
  case 45:
    Perform_Preset_Popup_8();
    break;
  case 46:
    Perform_Preset_Popup_9();
    break;
  case 47:
    Perform_Preset_Select_1();
    break;
  case 48:
    Perform_Preset_Select_10();
    break;
  case 49:
    Perform_Preset_Select_11();
    break;
  case 50:
    Perform_Preset_Select_12();
    break;
  case 51:
    Perform_Preset_Select_2();
    break;
  case 52:
    Perform_Preset_Select_3();
    break;
  case 53:
    Perform_Preset_Select_4();
    break;
  case 54:
    Perform_Preset_Select_5();
    break;
  case 55:
    Perform_Preset_Select_6();
    break;
  case 56:
    Perform_Preset_Select_7();
    break;
  case 57:
    Perform_Preset_Select_8();
    break;
  case 58:
    Perform_Preset_Select_9();
    break;
  case 59:
    Perform_Preset_Store_1();
    break;
  case 60:
    Perform_Preset_Store_10();
    break;
  case 61:
    Perform_Preset_Store_11();
    break;
  case 62:
    Perform_Preset_Store_12();
    break;
  case 63:
    Perform_Preset_Store_2();
    break;
  case 64:
    Perform_Preset_Store_3();
    break;
  case 65:
    Perform_Preset_Store_4();
    break;
  case 66:
    Perform_Preset_Store_5();
    break;
  case 67:
    Perform_Preset_Store_6();
    break;
  case 68:
    Perform_Preset_Store_7();
    break;
  case 69:
    Perform_Preset_Store_8();
    break;
  case 70:
    Perform_Preset_Store_9();
    break;
  case 71:
    Perform_Previous_fn();
    break;
  case 72:
    Perform_Previous_fn_AM();
    break;
  case 73:
    Perform_Previous_fn_DAB();
    break;
  case 74:
    Perform_Previous_fn_FM();
    break;
  case 77:
    Perform_SXMMonitor_Context();
    break;
  case 78:
    Perform_SXMSettings_Context();
    break;
  case 79:
    Perform_SXM_Context();
    break;
  case 80:
    Perform_Seek_Next();
    break;
  case 81:
    Perform_Seek_Next_Jump();
    break;
  case 82:
    Perform_Seek_Next_Repeat();
    break;
  case 83:
    Perform_Seek_Previous();
    break;
  case 84:
    Perform_Seek_Previous_Jump();
    break;
  case 85:
    Perform_Seek_Previous_Repeat();
    break;
  case 86:
    Perform_Seek_Stop();
    break;
  case 87:
    Perform_Service_Link_Dec();
    break;
  case 88:
    Perform_Service_Link_Inc();
    break;
  case 89:
    Perform_Service_Linking_Dec();
    break;
  case 90:
    Perform_Service_Linking_Inc();
    break;
  case 91:
    Perform_SettingsBackBtn_Context();
    break;
  case 92:
    Perform_Stop_Next_Previous();
    break;
  case 93:
    Perform_TestmodeBlock_Context();
    break;
  case 94:
    Perform_TunerSelect_1();
    break;
  case 95:
    Perform_TunerSelect_2();
    break;
  case 96:
    Perform_TunerSelect_3();
    break;
  case 97:
    Perform_TunerSelect_4();
    break;
  case 98:
    Perform_Tuner_Src_Select();
    break;
  case 100:
    Preform_AFListExit();
    break;
  case 101:
    StationBrowseList();
    break;
  case 103:
    TunerTestModeViewReqMsg_Stop();
    break;
  case 104:
    TunerViewReq_AF_L();
    break;
  case 105:
    TunerViewReq_AM();
    break;
  case 106:
    TunerViewReq_AM_AST();
    break;
  case 108:
    TunerViewReq_AM_MONITORTESTMODE();
    break;
  case 109:
    TunerViewReq_AM_TESTMODE();
    break;
  case 110:
    TunerViewReq_DAB();
    break;
  case 111:
    TunerViewReq_DAB_AST();
    break;
  case 112:
    TunerViewReq_DAB_Expert_API_TestMode();
    break;
  case 113:
    TunerViewReq_DAB_Monitor();
    break;
  case 114:
    TunerViewReq_DAB_Quality_TestMode();
    break;
  case 115:
    TunerViewReq_DAB_SETUP_MONITOR();
    break;
  case 116:
    TunerViewReq_DAB_SL();
    break;
  case 117:
    TunerViewReq_DAB_Service_Info_TestMod();
    break;
  case 118:
    TunerViewReq_DRM();
    break;
  case 119:
    TunerViewReq_DRMSetup_Monitor();
    break;
  case 120:
    TunerViewReq_DRM_AST();
    break;
  case 121:
    TunerViewReq_DRM_SL();
    break;
  case 122:
    TunerViewReq_FM1();
    break;
  case 123:
    TunerViewReq_FM2();
    break;
  case 124:
    TunerViewReq_FM_AST();
    break;
  case 125:
    TunerViewReq_FM_INFO();
    break;
  case 126:
    TunerViewReq_FM_MONITORTESTMODE();
    break;
  case 127:
    TunerViewReq_FM_SL();
    break;
  case 128:
    TunerViewReq_FM_TESTMODE();
    break;
  case 129:
    TunerViewReq_HDDTM_TESTMODE();
    break;
  case 130:
    TunerViewReq_HDPARAMTUNING_TESTMODE();
    break;
  case 134:
    TunerViewReq_OPT_FMAM();
    break;
  case 135:
    TunerViewReq_PlayView();
    break;
  case 136:
    TunerViewReq_Previous();
    break;
  case 137:
    TunerViewReq_SourceSelection();
    break;
  case 138:
    TunerViewReq_TMC();
    break;
  case 139:
    TunerViewReq_TMC_INFO();
    break;
  case 140:
    TunerViewReq_TMC_L();
    break;
  case 142:
    TunerViewReq_TT_MONITOR1();
    break;
  case 143:
    TunerViewReq_TT_MONITOR2();
    break;
  case 144:
    TunerViewReq_TT_MONITOR3();
    break;
  case 145:
    TunerViewReq_TestModeScreens();
    break;
  case 146:
    TunerViewReq_WEATHERBAND();
    break;
  case 147:
    TunerViewReq_WEATHERBAND_MONITOR();
    break;
  case 148:
    Update_AMPreset_Focused();
    break;
  case 149:
    Update_FMPreset_Focused();
    break;
  case 151:
    Update_Previous_View();
    break;
  case 152:
    acDtmResetTransitions();
    break;
  case 153:
    acDtmSplitAudio();
    break;
  case 170:
    sm_gTargetView = TUNER_VIEW_INVALID;
    break;
  case 171:
    sm_gCurrentView = TUNER_VIEW_INVALID;
    break;
  case 172:
    sm_gPreviousView = VIEW_AM_AST;
    break;
  case 173:
    sm_gPreviousView = VIEW_AM;
    break;
  case 174:
    sm_gPreviousView = VIEW_FM_AST;
    break;
  case 175:
    sm_gPreviousView = VIEW_FM2;
    break;
  case 176:
    sm_gPreviousView = VIEW_OPT_FMAM;
    break;
  case 177:
    sm_gPreviousView = VIEW_AM_TESTMODE;
    break;
  case 178:
    sm_gPreviousView = VIEW_FM_TESTMODE;
    break;
  case 179:
    sm_gPreviousView = VIEW_AM_MONITORTESTMODE;
    break;
  case 180:
    sm_gPreviousView = VIEW_FM_MONITORTESTMODE;
    break;
  case 181:
    sm_gPreviousView = VIEW_SOURCE_SELECTION;
    break;
  case 182:
    sm_gPreviousView = VIEW_SOURCE_SELECTION_woNAV;
    break;
  case 183:
    sm_gPreviousView = VIEW_DAB;
    break;
  case 184:
    sm_gPreviousView = VIEW_DAB_AST;
    break;
  case 185:
    sm_gPreviousView = VIEW_DAB_SL;
    break;
  case 186:
    sm_gPreviousView = VIEW_FM_SL;
    break;
  case 187:
    sm_gPreviousView = VIEW_OPT_DABPTY;
    break;
  case 188:
    sm_gPreviousView = VIEW_TT_MONITOR1;
    break;
  case 189:
    sm_gPreviousView = VIEW_TT_MONITOR2;
    break;
  case 190:
    sm_gPreviousView = VIEW_TT_MONITOR3;
    break;
  case 191:
    sm_gPreviousView = VIEW_DAB_SETUP_MONITOR;
    break;
  case 192:
    sm_gPreviousView = VIEW_DAB_QUALITY_TESTMODE;
    break;
  case 193:
    sm_gPreviousView = VIEW_AF_LIST;
    break;
  case 194:
    sm_gPreviousView = VIEW_TMC;
    break;
  case 195:
    sm_gPreviousView = VIEW_TMC_INFO;
    break;
  case 196:
    sm_gPreviousView = VIEW_DAB_EXPERT_API_TESTMODE;
    break;
  case 197:
    sm_gPreviousView = VIEW_DAB_SERVICE_INFO_TESTMODE;
    break;
  case 198:
    sm_gPreviousView = VIEW_TMC_LIST;
    break;
  case 199:
    sm_gPreviousView = VIEW_TESTMODESCREENS;
    break;
  case 200:
    sm_gPreviousView = VIEW_TMC_STN_INFO;
    break;
  case 201:
    sm_gPreviousView = VIEW_DRM;
    break;
  case 202:
    sm_gPreviousView = VIEW_DRM_AST;
    break;
  case 203:
    sm_gPreviousView = VIEW_DRM_SL;
    break;
  case 204:
    sm_gPreviousView = VIEW_DRM_TESTMODE;
    break;
  case 205:
    sm_gPreviousView = VIEW_DRM_TESTMODESCREEN;
    break;
  case 206:
    sm_gPreviousView = VIEW_DAB_MONITOR;
    break;
  case 207:
    sm_gPreviousView = VIEW_OPT_DRMPTY;
    break;
  case 208:
    sm_gPreviousView = VIEW_WEATHERBAND;
    break;
  case 209:
    sm_gPreviousView = VIEW_HDDTM_TESTMODE;
    break;
  case 210:
    sm_gPreviousView = VIEW_FM1;
    break;
  case 211:
    sm_gPreviousView = VIEW_WEATHERBAND_MONITOR;
    break;
  case 212:
    sm_gCurrentView = VIEW_SOURCE_SELECTION;
    break;
  case 213:
    sm_gCurrentView = VIEW_FM2;
    break;
  case 214:
    sm_gCurrentView = VIEW_SOURCE_SELECTION_woNAV;
    break;
  case 215:
    sm_gCurrentView = VIEW_OPT_FMAM;
    break;
  case 216:
    sm_gCurrentView = VIEW_AM;
    break;
  case 217:
    sm_gCurrentView = VIEW_FM_SL;
    break;
  case 218:
    sm_gCurrentView = VIEW_AM_AST;
    break;
  case 219:
    sm_gCurrentView = VIEW_DAB;
    break;
  case 220:
    sm_gCurrentView = VIEW_DAB_AST;
    break;
  case 221:
    sm_gCurrentView = VIEW_FM_TESTMODE;
    break;
  case 222:
    sm_gCurrentView = VIEW_FM_MONITORTESTMODE;
    break;
  case 223:
    sm_gCurrentView = VIEW_AM_TESTMODE;
    break;
  case 224:
    sm_gCurrentView = VIEW_AM_MONITORTESTMODE;
    break;
  case 225:
    sm_gCurrentView = VIEW_DAB_SL;
    break;
  case 226:
    sm_gCurrentView = VIEW_OPT_DABPTY;
    break;
  case 227:
    sm_gCurrentView = VIEW_TT_MONITOR1;
    break;
  case 228:
    sm_gCurrentView = VIEW_TT_MONITOR2;
    break;
  case 229:
    sm_gCurrentView = VIEW_TT_MONITOR3;
    break;
  case 230:
    sm_gCurrentView = VIEW_DAB_SETUP_MONITOR;
    break;
  case 231:
    sm_gCurrentView = VIEW_AF_LIST;
    break;
  case 232:
    sm_gCurrentView = VIEW_TMC;
    break;
  case 233:
    sm_gCurrentView = VIEW_TMC_INFO;
    break;
  case 234:
    sm_gCurrentView = VIEW_DAB_QUALITY_TESTMODE;
    break;
  case 235:
    sm_gCurrentView = VIEW_DAB_EXPERT_API_TESTMODE;
    break;
  case 236:
    sm_gCurrentView = VIEW_DAB_SERVICE_INFO_TESTMODE;
    break;
  case 237:
    sm_gCurrentView = VIEW_TMC_LIST;
    break;
  case 238:
    sm_gCurrentView = VIEW_TESTMODESCREENS;
    break;
  case 239:
    sm_gCurrentView = VIEW_TMC_STN_INFO;
    break;
  case 240:
    sm_gCurrentView = VIEW_DRM;
    break;
  case 241:
    sm_gCurrentView = VIEW_DRM_AST;
    break;
  case 242:
    sm_gCurrentView = VIEW_DRM_SL;
    break;
  case 243:
    sm_gCurrentView = VIEW_DRM_TESTMODE;
    break;
  case 244:
    sm_gCurrentView = VIEW_DRM_TESTMODESCREEN;
    break;
  case 245:
    sm_gCurrentView = VIEW_DAB_MONITOR;
    break;
  case 246:
    sm_gCurrentView = VIEW_OPT_DRMPTY;
    break;
  case 247:
    sm_gCurrentView = VIEW_WEATHERBAND;
    break;
  case 248:
    sm_gCurrentView = VIEW_FM1;
    break;
  case 249:
    sm_gCurrentView = VIEW_FM_INFO;
    break;
  case 250:
    sm_gCurrentView = VIEW_AM_INFO;
    break;
  case 251:
    sm_gCurrentView = VIEW_HDDTM_TESTMODE;
    break;
  case 252:
    sm_gCurrentView = VIEW_HDPARAMTUNING_TESTMODE;
    break;
  case 253:
    sm_gCurrentView = VIEW_FM_AST;
    break;
  case 254:
    sm_gCurrentView = VIEW_WEATHERBAND_MONITOR;
    break;
  case 255:
    gacViewHideReq(TunerModule_Gadget_Tuner_MASTER_GADGET_TUNER);
    break;
  case 256:
    gacViewDestroyReq(TunerModule_Gadget_Tuner_MASTER_GADGET_TUNER);
    break;
  case 257:
    gacViewHideAndDestroyReq(TunerModule_SysPopupScene_Pfo_PTY31);
    break;
  case 258:
    gacViewHideAndDestroyReq(TunerModule_SysPopupScene_Pfo_TA);
    break;
  case 259:
    gacViewHideAndDestroyReq(TunerModule_TunerPopupScene_Pfo_CannotStore);
    break;
  case 260:
    gacViewHideAndDestroyReq(TunerModule_TunerPopupScene_Pfo_StorePreset);
    break;
  case 261:
    gacViewHideAndDestroyReq(TunerModule_TunerPopupScene_Pfo_UpdateDAB_SL);
    break;
  case 262:
    gacViewHideAndDestroyReq(TunerModule_TunerPopupScene_Pfo_AutoStore);
    break;
  case 263:
    gacViewHideAndDestroyReq(TunerModule_TunerPopupScene_Pfo_UpdateFM_SL);
    break;
  case 264:
    gacPopupCreateAndSBShowReq(TunerModule_SysPopupScene_Pfo_TA);
    break;
  case 265:
    gacPopupCreateAndSBShowReq(TunerModule_SysPopupScene_Pfo_PTY31);
    break;
  case 266:
    gacPopupSBCloseReq(TunerModule_SysPopupScene_Pfo_TA);
    break;
  case 267:
    gacPopupSBCloseReq(TunerModule_SysPopupScene_Pfo_PTY31);
    break;
  case 268:
    gacPopupCreateAndSBShowReq(TunerModule_SysPopupScene_Pfo_WB);
    break;
  case 269:
    gacPopupSBCloseReq(TunerModule_SysPopupScene_Pfo_WB);
    break;
  case 270:
    gacViewHideReq(TunerModule_TunerScenes_R_AM_AST_S);
    break;
  case 271:
    gacViewDestroyReq(TunerModule_TunerScenes_R_AM_AST_S);
    break;
  case 272:
    gacViewHideReq(TunerModule_TunerScenes_R_AM_S);
    break;
  case 273:
    gacViewDestroyReq(TunerModule_TunerScenes_R_AM_S);
    break;
  case 274:
    gacViewHideReq(TunerModule_TunerScenes_R_FM_AST);
    break;
  case 275:
    gacViewDestroyReq(TunerModule_TunerScenes_R_FM_AST);
    break;
  case 276:
    gacViewHideReq(TunerModule_TunerScenes_R_FM2);
    break;
  case 277:
    gacViewDestroyReq(TunerModule_TunerScenes_R_FM2);
    break;
  case 278:
    gacViewHideAndDestroyReq(TunerModule_TunerScenes_R_OPT_FMAM);
    break;
  case 279:
    gacViewHideReq(TunerModule_TunerScenes_R_AM_TestMode);
    break;
  case 280:
    Perform_Tuner_fn(3, 0, 0);
    break;
  case 281:
    gacViewHideReq(TunerModule_TunerScenes_R_FM_TestMode);
    break;
  case 282:
    gacViewHideReq(TunerModule_TunerScenes_R_AM_MonitorTestMode);
    break;
  case 283:
    gacViewHideReq(TunerModule_TunerScenes_R_FM_MonitorTestMode);
    break;
  case 284:
    gacViewHideAndDestroyReq(TunerModule_TunerScenes_R_SourceSelection_Radio);
    break;
  case 285:
    gacViewHideReq(TunerModule_TunerScenes_R_SourceSelection_Radio_woNav);
    break;
  case 286:
    gacViewHideReq(TunerModule_TunerScenes_R_DAB);
    break;
  case 287:
    gacViewDestroyReq(TunerModule_TunerScenes_R_DAB);
    break;
  case 288:
    gacViewHideReq(TunerModule_TunerScenes_R_DAB_AST);
    break;
  case 289:
    gacViewDestroyReq(TunerModule_TunerScenes_R_DAB_AST);
    break;
  case 290:
    Perform_Tuner_fn(16, SM_DAB_LISTTYPE_SERVICELIST, 0);
    break;
  case 291:
    RequestBrowseListExit(SM_DAB_LISTTYPE_SERVICELIST);
    break;
  case 292:
    gacViewHideAndDestroyReq(TunerModule_TunerScenes_R_DAB_SL);
    break;
  case 293:
    RequestBrowseListExit(SM_TUNER_LISTTYPE_FM_STATIONLIST);
    break;
  case 294:
    gacViewHideAndDestroyReq(TunerModule_TunerScenes_R_FM_SL);
    break;
  case 295:
    gacViewHideReq(TunerModule_TunerScenes_R_OPT_DABPTY);
    break;
  case 296:
    gacViewDestroyReq(TunerModule_TunerScenes_R_OPT_DABPTY);
    break;
  case 297:
    gacViewHideReq(TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor);
    break;
  case 298:
    gacViewHideReq(TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor2);
    break;
  case 299:
    gacViewHideReq(TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor3);
    break;
  case 300:
    gacViewHideReq(TunerModule_TunerScenes_R_DAB_Setup_Monitor);
    break;
  case 301:
    gacViewHideReq(TunerModule_TunerScenes_R_DAB_Quality_TestMode);
    break;
  case 302:
    gacViewHideReq(TunerModule_TunerScenes_R_AF_L);
    break;
  case 303:
    gacViewDestroyReq(TunerModule_TunerScenes_R_AF_L);
    break;
  case 304:
    gacViewHideReq(TunerModule_TunerScenes_R_TMC);
    break;
  case 305:
    gacViewDestroyReq(TunerModule_TunerScenes_R_TMC);
    break;
  case 306:
    gacViewHideReq(TunerModule_TunerScenes_R_TMC_INFO);
    break;
  case 307:
    gacViewDestroyReq(TunerModule_TunerScenes_R_TMC_INFO);
    break;
  case 308:
    gacViewHideReq(TunerModule_TunerScenes_R_DAB_Expert_API_TestMode);
    break;
  case 309:
    gacViewHideReq(TunerModule_TunerScenes_R_DAB_Service_Info_TestMode);
    break;
  case 310:
    gacViewHideReq(TunerModule_TunerScenes_R_TMC_L);
    break;
  case 311:
    gacViewDestroyReq(TunerModule_TunerScenes_R_TMC_L);
    break;
  case 312:
    gacViewHideReq(TunerModule_TunerScenes_R_TestModeScreens);
    break;
  case 313:
    gacViewDestroyReq(TunerModule_TunerScenes_R_TestModeScreens);
    break;
  case 314:
    gacViewHideReq(TunerModule_TunerScenes_R_TMC_STN_INFO);
    break;
  case 315:
    gacViewDestroyReq(TunerModule_TunerScenes_R_TMC_STN_INFO);
    break;
  case 316:
    gacViewHideReq(TunerModule_TunerScenes_R_DRM);
    break;
  case 317:
    gacViewDestroyReq(TunerModule_TunerScenes_R_DRM);
    break;
  case 318:
    gacViewHideReq(TunerModule_TunerScenes_R_DRM_AST);
    break;
  case 319:
    gacViewDestroyReq(TunerModule_TunerScenes_R_DRM_AST);
    break;
  case 320:
    Perform_Tuner_fn(16, SM_DRM_LISTTYPE_STATIONLIST, 0);
    break;
  case 321:
    RequestBrowseListExit(SM_DRM_LISTTYPE_STATIONLIST);
    break;
  case 322:
    gacViewHideReq(TunerModule_TunerScenes_R_DRM_SL);
    break;
  case 323:
    gacViewHideReq(TunerModule_TunerScenes_R_DRM_TestMode);
    break;
  case 324:
    gacViewHideReq(TunerModule_TunerScenes_R_DRM_TestModeScreen);
    break;
  case 325:
    gacViewHideReq(TunerModule_TunerScenes_R_DAB_Monitor);
    break;
  case 326:
    gacViewHideReq(TunerModule_TunerScenes_R_OPT_DRMPTY);
    break;
  case 327:
    gacViewHideReq(TunerModule_TunerScenes_R_WeatherBand);
    break;
  case 328:
    gacViewDestroyReq(TunerModule_TunerScenes_R_WeatherBand);
    break;
  case 329:
    acHdListAccess(Enum_SCENE_EXIT);
    break;
  case 330:
    gacViewHideAndDestroyReq(TunerModule_TunerScenes_R_FM_INFO);
    break;
  case 331:
    gacViewHideAndDestroyReq(TunerModule_TunerScenes_R_AM_INFO);
    break;
  case 332:
    gacViewHideReq(TunerModule_TunerScenes_R_HDDTM_TESTMODE);
    break;
  case 333:
    Perform_Tuner_fn(87, 0, 0);
    break;
  case 334:
    acHdParameterUpdate(Enum_SCENE_EXIT);
    break;
  case 335:
    gacViewHideAndDestroyReq(TunerModule_TunerScenes_R_HDPARAMTUNING_TESTMODE);
    break;
  case 336:
    gacViewHideReq(TunerModule_TunerScenes_R_FM1_S);
    break;
  case 337:
    gacViewDestroyReq(TunerModule_TunerScenes_R_FM1_S);
    break;
  case 338:
    gacViewHideAndDestroyReq(TunerModule_TunerScenes_R_WeatherBand_Monitor);
    break;
  case 339:
    gacPopupCreateAndSBShowReq(TunerModule_TunerPopupScene_Pfo_AutoStore);
    break;
  case 340:
    gacPopupSBCloseReq(TunerModule_TunerPopupScene_Pfo_AutoStore);
    break;
  case 341:
    Perform_Tuner_fn(7, 0, 0);
    break;
  case 342:
    gacPopupSBCloseReq(TunerModule_TunerPopupScene_Pfo_UpdateDAB_SL);
    break;
  case 343:
    gacPopupSBCloseReq(TunerModule_TunerPopupScene_Pfo_UpdateFM_SL);
    break;
  case 344:
    gacViewHideReq(TunerModule_TunerPopupScene_Pfo_StorePreset);
    break;
  case 345:
    gacViewClearReq(TunerModule_TunerPopupScene_Pfo_StorePreset);
    break;
  case 346:
    gacViewHideReq(TunerModule_TunerPopupScene_Pfo_UpdateDAB_SL);
    break;
  case 347:
    gacViewClearReq(TunerModule_TunerPopupScene_Pfo_UpdateDAB_SL);
    break;
  case 348:
    gacViewHideReq(TunerModule_TunerPopupScene_Pfo_AutoStore);
    break;
  case 349:
    gacViewClearReq(TunerModule_TunerPopupScene_Pfo_AutoStore);
    break;
  case 350:
    gacViewHideReq(TunerModule_TunerPopupScene_Pfo_UpdateFM_SL);
    break;
  case 351:
    gacViewClearReq(TunerModule_TunerPopupScene_Pfo_UpdateFM_SL);
    break;
  case 352:
    gacViewHideReq(TunerModule_TunerPopupScene_Pfo_CannotStore);
    break;
  case 353:
    gacViewClearReq(TunerModule_TunerPopupScene_Pfo_CannotStore);
    break;
  case 354:
    gacViewCreateReq(TunerModule_Gadget_Tuner_MASTER_GADGET_TUNER);
    break;
  case 355:
    gacViewShowReq(TunerModule_Gadget_Tuner_MASTER_GADGET_TUNER);
    break;
  case 356:
    gacViewHideReq(TunerModule_SysPopupScene_Pfo_PTY31);
    break;
  case 357:
    gacViewClearReq(TunerModule_SysPopupScene_Pfo_PTY31);
    break;
  case 358:
    gacViewCreateReq(TunerModule_SysPopupScene_Pfo_PTY31);
    break;
  case 359:
    gacViewShowReq(TunerModule_SysPopupScene_Pfo_PTY31);
    break;
  case 360:
    gacViewCreateReq(TunerModule_SysPopupScene_Pfo_TA);
    break;
  case 361:
    gacViewShowReq(TunerModule_SysPopupScene_Pfo_TA);
    break;
  case 362:
    gacViewHideReq(TunerModule_SysPopupScene_Pfo_TA);
    break;
  case 363:
    gacViewClearReq(TunerModule_SysPopupScene_Pfo_TA);
    break;
  case 364:
    gacViewHideReq(TunerModule_SysPopupScene_Pfo_WB);
    break;
  case 365:
    gacViewClearReq(TunerModule_SysPopupScene_Pfo_WB);
    break;
  case 366:
    Perform_Tuner_fn(88, 0, 0);
    break;
  case 367:
    gacViewCreateReq(TunerModule_SysPopupScene_Pfo_WB);
    break;
  case 368:
    gacViewShowReq(TunerModule_SysPopupScene_Pfo_WB);
    break;
  case 369:
    gacViewCreateReq(TunerModule_Gadget_Tuner_SeekMenu_MASTER_GADGET_TUNER_SEEKMENU);
    break;
  case 370:
    gacViewShowReq(TunerModule_Gadget_Tuner_SeekMenu_MASTER_GADGET_TUNER_SEEKMENU);
    break;
  case 371:
    gacViewCreateReq(TunerModule_Gadget_Tuner_Mute_MASTER_GADGET_TUNER_MUTE);
    break;
  case 372:
    gacViewShowReq(TunerModule_Gadget_Tuner_Mute_MASTER_GADGET_TUNER_MUTE);
    break;
  case 373:
    gacViewCreateReq(TunerModule_Gadget_Tuner_Frequency_MASTER_GADGET_TUNER_FREQUENCY);
    break;
  case 374:
    gacViewShowReq(TunerModule_Gadget_Tuner_Frequency_MASTER_GADGET_TUNER_FREQUENCY);
    break;
  case 375:
    gacViewCreateReq(TunerModule_TunerPopupScene_Pfo_StorePreset);
    break;
  case 376:
    gacViewShowReq(TunerModule_TunerPopupScene_Pfo_StorePreset);
    break;
  case 377:
    gacViewCreateReq(TunerModule_TunerPopupScene_Pfo_UpdateDAB_SL);
    break;
  case 378:
    gacViewShowReq(TunerModule_TunerPopupScene_Pfo_UpdateDAB_SL);
    break;
  case 379:
    gacViewCreateReq(TunerModule_TunerPopupScene_Pfo_AutoStore);
    break;
  case 380:
    gacViewShowReq(TunerModule_TunerPopupScene_Pfo_AutoStore);
    break;
  case 381:
    gacViewCreateAndShowReq(TunerModule_TunerPopupScene_Pfo_UpdateFM_SL);
    break;
  case 382:
    gacViewCreateReq(TunerModule_TunerPopupScene_Pfo_CannotStore);
    break;
  case 383:
    gacViewShowReq(TunerModule_TunerPopupScene_Pfo_CannotStore);
    break;
  case 384:
    gacPopupCreateAndSBShowReq(TunerModule_TunerPopupScene_Pfo_StorePreset);
    break;
  case 385:
    gacPopupSBCloseReq(TunerModule_TunerPopupScene_Pfo_StorePreset);
    break;
  case 386:
    acHdOnOffUpdate(1);
    break;
  case 387:
    gacViewCreateReq(TunerModule_TunerScenes_R_SourceSelection_Radio);
    break;
  case 388:
    gacViewShowReq(TunerModule_TunerScenes_R_SourceSelection_Radio);
    break;
  case 389:
    Perform_Send_Context(VIEW_SOURCE_SELECTION);
    break;
  case 390:
    gacViewCreateReq(TunerModule_TunerScenes_R_FM2);
    break;
  case 391:
    gacViewShowReq(TunerModule_TunerScenes_R_FM2);
    break;
  case 392:
    Perform_Tuner_fn(12, 0, 0);
    break;
  case 393:
    gacViewCreateReq(TunerModule_TunerScenes_R_SourceSelection_Radio_woNav);
    break;
  case 394:
    gacViewShowReq(TunerModule_TunerScenes_R_SourceSelection_Radio_woNav);
    break;
  case 395:
    gacViewCreateReq(TunerModule_TunerScenes_R_OPT_FMAM);
    break;
  case 396:
    gacViewShowReq(TunerModule_TunerScenes_R_OPT_FMAM);
    break;
  case 397:
    Perform_Send_Context(VIEW_OPT_FMAM);
    break;
  case 398:
    gacViewCreateReq(TunerModule_TunerScenes_R_AM_S);
    break;
  case 399:
    gacViewShowReq(TunerModule_TunerScenes_R_AM_S);
    break;
  case 400:
    Perform_Send_Context(VIEW_FM_SL);
    break;
  case 401:
    gacViewCreateAndShowReq(TunerModule_TunerScenes_R_FM_SL);
    break;
  case 402:
    gacViewCreateReq(TunerModule_TunerScenes_R_AM_AST_S);
    break;
  case 403:
    gacViewShowReq(TunerModule_TunerScenes_R_AM_AST_S);
    break;
  case 404:
    gacViewCreateReq(TunerModule_TunerScenes_R_DAB);
    break;
  case 405:
    gacViewShowReq(TunerModule_TunerScenes_R_DAB);
    break;
  case 406:
    gacViewCreateReq(TunerModule_TunerScenes_R_DAB_AST);
    break;
  case 407:
    gacViewShowReq(TunerModule_TunerScenes_R_DAB_AST);
    break;
  case 408:
    gacViewCreateReq(TunerModule_TunerScenes_R_FM_TestMode);
    break;
  case 409:
    gacViewShowReq(TunerModule_TunerScenes_R_FM_TestMode);
    break;
  case 410:
    Perform_Tuner_fn(2, 0, 0);
    break;
  case 411:
    gacViewCreateReq(TunerModule_TunerScenes_R_FM_MonitorTestMode);
    break;
  case 412:
    gacViewShowReq(TunerModule_TunerScenes_R_FM_MonitorTestMode);
    break;
  case 413:
    gacViewCreateReq(TunerModule_TunerScenes_R_AM_TestMode);
    break;
  case 414:
    gacViewShowReq(TunerModule_TunerScenes_R_AM_TestMode);
    break;
  case 415:
    gacViewCreateReq(TunerModule_TunerScenes_R_AM_MonitorTestMode);
    break;
  case 416:
    gacViewShowReq(TunerModule_TunerScenes_R_AM_MonitorTestMode);
    break;
  case 417:
    Perform_Send_Context(VIEW_DAB_SL);
    break;
  case 418:
    gacViewCreateAndShowReq(TunerModule_TunerScenes_R_DAB_SL);
    break;
  case 419:
    gacViewCreateReq(TunerModule_TunerScenes_R_OPT_DABPTY);
    break;
  case 420:
    gacViewShowReq(TunerModule_TunerScenes_R_OPT_DABPTY);
    break;
  case 421:
    gacViewCreateReq(TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor);
    break;
  case 422:
    gacViewShowReq(TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor);
    break;
  case 423:
    gacViewCreateReq(TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor2);
    break;
  case 424:
    gacViewShowReq(TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor2);
    break;
  case 425:
    gacViewCreateReq(TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor3);
    break;
  case 426:
    gacViewShowReq(TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor3);
    break;
  case 427:
    gacViewCreateReq(TunerModule_TunerScenes_R_DAB_Setup_Monitor);
    break;
  case 428:
    gacViewShowReq(TunerModule_TunerScenes_R_DAB_Setup_Monitor);
    break;
  case 429:
    gacViewCreateReq(TunerModule_TunerScenes_R_AF_L);
    break;
  case 430:
    gacViewShowReq(TunerModule_TunerScenes_R_AF_L);
    break;
  case 431:
    gacViewCreateReq(TunerModule_TunerScenes_R_TMC);
    break;
  case 432:
    gacViewShowReq(TunerModule_TunerScenes_R_TMC);
    break;
  case 433:
    gacViewCreateReq(TunerModule_TunerScenes_R_TMC_INFO);
    break;
  case 434:
    gacViewShowReq(TunerModule_TunerScenes_R_TMC_INFO);
    break;
  case 435:
    gacViewCreateReq(TunerModule_TunerScenes_R_DAB_Quality_TestMode);
    break;
  case 436:
    gacViewShowReq(TunerModule_TunerScenes_R_DAB_Quality_TestMode);
    break;
  case 437:
    gacViewCreateReq(TunerModule_TunerScenes_R_DAB_Expert_API_TestMode);
    break;
  case 438:
    gacViewShowReq(TunerModule_TunerScenes_R_DAB_Expert_API_TestMode);
    break;
  case 439:
    gacViewCreateReq(TunerModule_TunerScenes_R_DAB_Service_Info_TestMode);
    break;
  case 440:
    gacViewShowReq(TunerModule_TunerScenes_R_DAB_Service_Info_TestMode);
    break;
  case 441:
    gacViewCreateReq(TunerModule_TunerScenes_R_TMC_L);
    break;
  case 442:
    gacViewShowReq(TunerModule_TunerScenes_R_TMC_L);
    break;
  case 443:
    Perform_Send_Context(VIEW_TESTMODESCREENS);
    break;
  case 444:
    gacViewCreateReq(TunerModule_TunerScenes_R_TestModeScreens);
    break;
  case 445:
    gacViewShowReq(TunerModule_TunerScenes_R_TestModeScreens);
    break;
  case 446:
    gacViewCreateReq(TunerModule_TunerScenes_R_TMC_STN_INFO);
    break;
  case 447:
    gacViewShowReq(TunerModule_TunerScenes_R_TMC_STN_INFO);
    break;
  case 448:
    gacViewCreateReq(TunerModule_TunerScenes_R_DRM);
    break;
  case 449:
    gacViewShowReq(TunerModule_TunerScenes_R_DRM);
    break;
  case 450:
    gacViewCreateReq(TunerModule_TunerScenes_R_DRM_AST);
    break;
  case 451:
    gacViewShowReq(TunerModule_TunerScenes_R_DRM_AST);
    break;
  case 452:
    gacViewCreateReq(TunerModule_TunerScenes_R_DRM_SL);
    break;
  case 453:
    gacViewShowReq(TunerModule_TunerScenes_R_DRM_SL);
    break;
  case 454:
    gacViewCreateReq(TunerModule_TunerScenes_R_DRM_TestMode);
    break;
  case 455:
    gacViewShowReq(TunerModule_TunerScenes_R_DRM_TestMode);
    break;
  case 456:
    gacViewCreateReq(TunerModule_TunerScenes_R_DRM_TestModeScreen);
    break;
  case 457:
    gacViewShowReq(TunerModule_TunerScenes_R_DRM_TestModeScreen);
    break;
  case 458:
    gacViewCreateReq(TunerModule_TunerScenes_R_DAB_Monitor);
    break;
  case 459:
    gacViewShowReq(TunerModule_TunerScenes_R_DAB_Monitor);
    break;
  case 460:
    gacViewCreateReq(TunerModule_TunerScenes_R_OPT_DRMPTY);
    break;
  case 461:
    gacViewShowReq(TunerModule_TunerScenes_R_OPT_DRMPTY);
    break;
  case 462:
    gacViewCreateReq(TunerModule_TunerScenes_R_WeatherBand);
    break;
  case 463:
    gacViewShowReq(TunerModule_TunerScenes_R_WeatherBand);
    break;
  case 464:
    gacViewCreateAndShowReq(TunerModule_TunerScenes_R_FM1_S);
    break;
  case 465:
    acHdListAccess(Enum_SCENE_ENTRY);
    break;
  case 466:
    gacViewCreateAndShowReq(TunerModule_TunerScenes_R_FM_INFO);
    break;
  case 467:
    gacViewCreateAndShowReq(TunerModule_TunerScenes_R_AM_INFO);
    break;
  case 468:
    gacViewCreateReq(TunerModule_TunerScenes_R_HDDTM_TESTMODE);
    break;
  case 469:
    gacViewShowReq(TunerModule_TunerScenes_R_HDDTM_TESTMODE);
    break;
  case 470:
    Perform_Tuner_fn(86, 0, 0);
    break;
  case 471:
    acHdParameterUpdate(Enum_SCENE_ENTRY);
    break;
  case 472:
    gacViewCreateReq(TunerModule_TunerScenes_R_HDPARAMTUNING_TESTMODE);
    break;
  case 473:
    gacViewShowReq(TunerModule_TunerScenes_R_HDPARAMTUNING_TESTMODE);
    break;
  case 474:
    gacViewCreateReq(TunerModule_TunerScenes_R_FM_AST);
    break;
  case 475:
    gacViewShowReq(TunerModule_TunerScenes_R_FM_AST);
    break;
  case 476:
    gacViewCreateAndShowReq(TunerModule_TunerScenes_R_WeatherBand_Monitor);
    break;
  case 477:
    Perform_Tuner_fn(44, 0, 0);
    break;
  case 478:
    FMMonitorMessageSharxHiCut(1, 0);
    break;
  case 479:
    FMMonitorMessageSharxHiCut(1, 1);
    break;
  case 480:
    FMMonitorMessageSharxHiCut(2, 0);
    break;
  case 481:
    FMMonitorMessageSharxHiCut(2, 1);
    break;
  case 482:
    Perform_Tuner_fn(5, 0, 0);
    break;
  case 483:
    Perform_Tuner_fn(28, 0, 0);
    break;
  case 484:
    Perform_Tuner_fn(10, 0, 0);
    break;
  case 485:
    Perform_Tuner_fn(15, 0, 0);
    break;
  case 486:
    Perform_Tuner_fn(1, 0, 0);
    break;
  case 487:
    gacPopupSBCloseReq(TunerModule_TunerPopupScene_Pfo_CannotStore);
    break;
  case 488:
    gacPopupCreateAndSBShowReq(TunerModule_TunerPopupScene_Pfo_CannotStore);
    break;
  case 489:
    gacViewHideReq(PID_APP_POPUP_DABSRVLIST);
    break;
  case 490:
    gacPopupCreateAndSBShowReq(TunerModule_TunerPopupScene_Pfo_UpdateDAB_SL);
    break;
  case 491:
    Perform_Tuner_fn(14, 0, 0);
    break;
  case 492:
    gacViewHideReq(TunerModule_TunerScenes_R_FM_SL);
    break;
  case 493:
    gacViewShowReq(TunerModule_TunerScenes_R_FM_SL);
    break;
  case 494:
    RequestBrowseList(SM_TUNER_LISTTYPE_FM_STATIONLIST);
    break;
  case 495:
    gacPopupCreateAndSBShowReq(TunerModule_TunerPopupScene_Pfo_UpdateFM_SL);
    break;
  case 496:
    gacPopupCreateAndSBShowReq(PID_APP_POPUP_TUNER);
    break;
  case 497:
    gacPopupSBCloseReq(PID_APP_POPUP_TUNER);
    break;
  case 498:
    Perform_Tuner_Wx_fn(1);
    break;
  case 499:
    Perform_Tuner_Wx_fn(2);
    break;
  case 500:
    Perform_Tuner_Wx_fn(3);
    break;
  case 501:
    Perform_Tuner_Wx_fn(4);
    break;
  case 502:
    Perform_Tuner_Wx_fn(5);
    break;
  case 503:
    Perform_Tuner_Wx_fn(6);
    break;
  case 504:
    Perform_Tuner_Wx_fn(7);
    break;
  case 505:
    Perform_Tuner_Wx_fn(8);
    break;
  case 506:
    Perform_Tuner_Wx_fn(9);
    break;
  case 507:
    Perform_Tuner_Wx_fn(10);
    break;
  case 508:
    acHdAudioProgSelect(Enum_ProgVal0);
    break;
  case 509:
    acHdAudioProgSelect(Enum_ProgVal1);
    break;
  case 510:
    acHdAudioProgSelect(Enum_ProgVal2);
    break;
  case 511:
    acHdAudioProgSelect(Enum_ProgVal3);
    break;
  case 512:
    acHdAudioProgSelect(Enum_ProgVal4);
    break;
  case 513:
    acHdAudioProgSelect(Enum_ProgVal5);
    break;
  case 514:
    acHdAudioProgSelect(Enum_ProgVal6);
    break;
  case 515:
    acHdAudioProgSelect(Enum_ProgVal7);
    break;
  case 516:
    acHdParameterTuningUpdate(Enum_HD_INCREMENT);
    break;
  case 517:
    acHdParameterTuningUpdate(Enum_HD_DECREMENT);
    break;
  case 518:
    acHdOnOffUpdate(0);
    break;

  default:
    break;
  }
}
