/************************************************************************
*FILE: AppHmi_TunerTypes.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(AppHmi_TunerTypes_h)
#define AppHmi_TunerTypes_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <ProjectBaseTypes.h>
enum enMode {
    SCAN_OFF = 0,
    SCAN_ON = 1,
    SCAN_PAUSE = 2
};
enum tenFunction {
    EN_SEEK = 1,
    EN_SCAN,
    EN_AST,
    EN_PRESET
};
enum enTunerType {
    TUN_TYPE_AMFM = 0,
    TUN_TYPE_SRC_DAB = 1,
    TUN_TYPE_SRC_UNDEF = 2
};
enum enScanType {
    SCAN_AIR_FREQUENCY_UP = 3,
    SCAN_ACTIVE_PRESETLIST_UP = 2,
    SCAN_AIR_FREQUENCY_DOWN = 9,
    SCAN_ACTIVE_PRESETLIST_DOWN = 8,
    SCAN_PI_UP = 27,
    SCAN_PI_DOWN = 28
};
enum enStationNameInfo {
    STN_INFO_NON_RDS_STATION = 0,
    STN_INFO_STN_NAMEFIRST_RX_FREEZED = 1,
    STN_INFO_STN_NAMELAST_RX_SCROLLING = 2,
    STN_INFO_NAME_ASSIGNED_BY_CUSTOMER = 3
};
enum enStationType {
    STN_TYPE_PRIMARY = 1,
    STN_TYPE_SECONDARY = 2,
    STN_TYPE_ENSEMBLE = 3
};
enum enSortingType {
    SORTING_PS_ASCENDING = 0,
    SORTING_PI_ASCENDING = 1,
    SORTING_FIELDSTRENGTH_ASCENDING = 2,
    SORTING_FREQ_ASCENDING = 3,
    SORTING_PS_DESCENDING = 4,
    SORTING_PI_DESCENDING = 5,
    SORTING_FIELDSTRENGTH_DESCENDING = 6,
    SORTING_FREQ_DESCENDING = 7
};
enum enStationInfoBits {
    STN_INFO_BIT0 = 0,
    STN_INFO_BIT1 = 1,
    STN_INFO_BIT2 = 2,
    STN_INFO_BIT3 = 3,
    STN_INFO_BIT4 = 4
};
enum enResult {
    RESULT_REQUESTACCEPTED = 0,
    RESULT_REQUESTNOTACCEPTED = 1
};
enum enError {
    ERR_PARAMETER_NO_ERROR = 0,
    ERR_PARAMETER_OUTOFRANGE = 1,
    ERR_PARAMETER_MISSING = 2,
    ERR_PARAMETER_TEMP_NOT_AVAILABLE = 3,
    ERR_PARAMETER_TEMP_UNDEF = 255
};
enum enSeekMode {
    SEEK_OFF = 0,
    SEEK_UPAUTO = 1,
    SEEK_UPSCANCURRENTPRESETLIST = 2,
    SEEK_UPSCANFREQUENCY = 3,
    SEEK_UPCONTINUOUSMANUALSTEP = 4,
    SEEK_UPPRESET = 5,
    SEEK_UPCURRENTSTATIONLIST = 6,
    SEEK_DOWNAUTO = 7,
    SEEK_DOWNSCANCURRENTPRESETLIST = 8,
    SEEK_DOWNSCANFREQUENCY = 9,
    SEEK_DOWNCONTINUOUSMANUALSTEP = 10,
    SEEK_DOWNPRESET = 11,
    SEEK_DOWNCURRENTSTATIONLIST = 12,
    SEEK_UPAUTORDSONLY = 13,
    SEEK_DOWNAUTORDSONLY = 14,
    SEEK_UPAUTORDSONLYPTYMASK = 15,
    SEEK_DOWNAUTORDSONLYPTYMASK = 16,
    SEEK_TP_UP_BOTH_EON_SELF_TP = 17,
    SEEK_TP_DOWN_BOTH_EON_SELF_TP = 18,
    SEEK_SELF_TP_UP = 19,
    SEEK_SELF_TP_DOWN = 20,
    SEEK_TPUP_BOTH_EON_SELF_TP_WITH_PTY_MASK = 21,
    SEEK_TPDOWN_BOTH_EON_SELFTP_WITH_PTYMASK = 22,
    SEEK_SELF_TP_UPWITHPTYMASK = 23,
    SEEK_SELF_TP_DOWNWITHPTYMASK = 24,
    SEEK_UP_CONTINUOUS_MANUAL_STEP_MUTED = 25,
    SEEK_DOWN_CONTINUOUS_MANUAL_STEP_MUTED = 26,
    SEEK_UP_SCAN_PI = 28,
    SEEK_DOWN_SCAN_PI = 29,
    SEEK_UP_DRM_JUMP = 33,
    SEEK_DOWN_DRM_JUMP = 34
};
enum enOnOff {
    DEACTIVATE = 0,
    ACTIVATE = 1
};
enum enSource {
    SRC_TYPE_FM = 1,
    SRC_TYPE_AM = 2,
    SRC_TYPE_DAB = 4
};
enum enDABTMSeekMode {
    SEEK_DAB_TM_SERVICE_NEXT,
    SEEK_DAB_TM_SERVICE_PREVIOUS,
    SEEK_DAB_TM_ENSEMBLE_NEXT,
    SEEK_DAB_TM_ENSEMBLE_PREVIOUS
};
enum enFeatureSwitch {
    FEATURESWITCH_AF = 1,
    FEATURESWITCH_REG = 2,
    FEATURESWITCH_TA = 4,
    FEATURESWITCH_DDA = 8,
    FEATURESWITCH_MONOSTEREO = 16
};
enum enSortingCriteria {
    FIELDSTRENGTH = 0,
    QUALITY = 1,
    FREQUENCY = 2,
    PICHAIN_FREQUENCY = 3
};
enum enBehaviourSwitches {
    ALLOW_AUTOSTORE_IN_TUNNEL = 0,
    AVOID_AUTOSTORE_IN_TUNNEL = 1
};
enum enAutoStoreDeactivate {
    AUTOSTORE_DEACTIVATED = 0,
    AUTOSTORE_DEACTIVATE = 1
};
enum enListType {
    ALLAUDIOSTATIONLIST = 1,
    TMCSTATIONLIST = 2,
    AFSTATIONLIST = 4,
    PRESETLIST = 8,
    PRIMARYSTATIONLIST = 10,
    SECONDARYSTATIONLIST = 20
};
enum enReceptionParameter {
    SHRAX = 1,
    HICUT = 2
};
enum enBand {
    EN_BAND_FM = 0,
    EN_BAND_LW = 1,
    EN_BAND_MW = 2,
    EN_BAND_DAB_BAND_III = 3,
    EN_BAND_DAB_BAND_L = 4
};
enum enBank {
    BANK = 1
};
enum enStationSortMode {
    SORT = 1
};
enum enPTY {
    PTY = 1
};
enum enSwitch {
    SWITCH = 1
};
enum eActivityID {
    TUNER_SOURCE_SELECTION = 0,
    TUNER_SETTINGS_VIEW = 1
};
enum enSeekDirection {
    TUN_DIRECTION_UP = 0,
    TUN_DIRECTION_DOWN,
    TUN_DIRECTION_INVALID
};
enum enHDParameterTuning {
    HD_SENDPARAMETER = 0,
    HD_INCREMENT,
    HD_DECREMENT
};
enum enSceneStatus {
    SCENE_EXIT = 0,
    SCENE_ENTRY
};
enum enHDProgVal {
    ProgVal0 = 0,
    ProgVal1,
    ProgVal2,
    ProgVal3,
    ProgVal4,
    ProgVal5,
    ProgVal6,
    ProgVal7
};
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
namespace FeatStd {
    template<> ::FeatStd::UInt32 StringBufferAppender< ::enMode >::Append(::FeatStd::StringBuffer& stringBuffer, ::enMode const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::tenFunction >::Append(::FeatStd::StringBuffer& stringBuffer, ::tenFunction const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::enTunerType >::Append(::FeatStd::StringBuffer& stringBuffer, ::enTunerType const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::enScanType >::Append(::FeatStd::StringBuffer& stringBuffer, ::enScanType const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::enStationNameInfo >::Append(::FeatStd::StringBuffer& stringBuffer, ::enStationNameInfo const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::enStationType >::Append(::FeatStd::StringBuffer& stringBuffer, ::enStationType const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::enSortingType >::Append(::FeatStd::StringBuffer& stringBuffer, ::enSortingType const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::enStationInfoBits >::Append(::FeatStd::StringBuffer& stringBuffer, ::enStationInfoBits const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::enResult >::Append(::FeatStd::StringBuffer& stringBuffer, ::enResult const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::enError >::Append(::FeatStd::StringBuffer& stringBuffer, ::enError const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::enSeekMode >::Append(::FeatStd::StringBuffer& stringBuffer, ::enSeekMode const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::enOnOff >::Append(::FeatStd::StringBuffer& stringBuffer, ::enOnOff const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::enSource >::Append(::FeatStd::StringBuffer& stringBuffer, ::enSource const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::enDABTMSeekMode >::Append(::FeatStd::StringBuffer& stringBuffer, ::enDABTMSeekMode const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::enFeatureSwitch >::Append(::FeatStd::StringBuffer& stringBuffer, ::enFeatureSwitch const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::enSortingCriteria >::Append(::FeatStd::StringBuffer& stringBuffer, ::enSortingCriteria const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::enBehaviourSwitches >::Append(::FeatStd::StringBuffer& stringBuffer, ::enBehaviourSwitches const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::enAutoStoreDeactivate >::Append(::FeatStd::StringBuffer& stringBuffer, ::enAutoStoreDeactivate const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::enListType >::Append(::FeatStd::StringBuffer& stringBuffer, ::enListType const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::enReceptionParameter >::Append(::FeatStd::StringBuffer& stringBuffer, ::enReceptionParameter const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::enBand >::Append(::FeatStd::StringBuffer& stringBuffer, ::enBand const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::enBank >::Append(::FeatStd::StringBuffer& stringBuffer, ::enBank const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::enStationSortMode >::Append(::FeatStd::StringBuffer& stringBuffer, ::enStationSortMode const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::enPTY >::Append(::FeatStd::StringBuffer& stringBuffer, ::enPTY const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::enSwitch >::Append(::FeatStd::StringBuffer& stringBuffer, ::enSwitch const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::eActivityID >::Append(::FeatStd::StringBuffer& stringBuffer, ::eActivityID const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::enSeekDirection >::Append(::FeatStd::StringBuffer& stringBuffer, ::enSeekDirection const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::enHDParameterTuning >::Append(::FeatStd::StringBuffer& stringBuffer, ::enHDParameterTuning const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::enSceneStatus >::Append(::FeatStd::StringBuffer& stringBuffer, ::enSceneStatus const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::enHDProgVal >::Append(::FeatStd::StringBuffer& stringBuffer, ::enHDProgVal const & object);
} // namespace FeatStd
#endif
#endif // AppHmi_TunerTypes_h
