/************************************************************************
*FILE: AppHmi_TunerStateMachine.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(AppHmi_TunerStateMachine_h)
#define AppHmi_TunerStateMachine_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Courier/Messaging/Message.h>
#include <AppHmi_TunerStateMachineSEMLibB.h>
#include <AppHmi_TunerStateMachineData.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Cit/VisualStateGlueLayer/DeductResult.h>
#ifdef CIT_SIMULATION
#include <json/value.h>
#endif
#include <AppHmi_TunerTypes.h>
#include <AppHmi_TunerConstants.h>
#include <AppHmi_TunerMessages.h>
#include <AppHmi_TunerDatabinding.h>
#include <AppHmi_TunerViews.h>
#include <AppHmi_TunerController.h>
// ------------------------------------------------------------------------
class AppHmi_TunerStateMachineImpl : public AppHmi_TunerStateMachine
{
public:
    typedef AppHmi_TunerStateMachine Base;

#ifdef VISUALSTATE_7_TRACE
    // Mapping of data types of API to get rid of include dependencies
    //typedef SEM_ACTION_EXPRESSION_TYPE VS_Type_ActionExpression;
	using Base::VS_Type_ActionExpression;
    //typedef SEM_EVENT_TYPE VS_Type_Event;
	//typedef SEM_STATE_TYPE VS_Type_State;
	//typedef SEM_EXPLANATION_TYPE VS_Type_Explanation;
	//typedef SEM_STATE_MACHINE_TYPE VS_Type_Statemachine;
	using Base::VS_Type_Event;
	using Base::VS_Type_State;
	using Base::VS_Type_Explanation;
	using Base::VS_Type_Statemachine;

    // Mapping of enums and defines of API to get rid of include dependencies
    //enum { VS_Ret_Ok = SES_OKAY };
    //enum { VS_Ret_Found = SES_FOUND };
	enum { VS_Ret_Ok = Base::VS_Ret_Ok };
	enum { VS_Ret_Found = Base::VS_Ret_Found };
    enum { VS_Evt_Reset = SE_RESET };
    enum { VS_Ret_Error = SES_RANGE_ERR };
#else
#ifndef VISUALSTATE_HCODER
    typedef SEM_ACTION_EXPRESSION_TYPE VS_Type_ActionExpression;
    typedef SEM_EVENT_TYPE VS_Type_Event;
    typedef SEM_STATE_TYPE VS_Type_State;
    typedef SEM_EXPLANATION_TYPE VS_Type_Explanation;
    typedef SEM_STATE_MACHINE_TYPE VS_Type_Statemachine;
    enum { VS_Ret_Ok = SES_OKAY };
    enum { VS_Ret_Found = SES_FOUND };
    enum { VS_Evt_Reset = SE_RESET };
    enum { VS_Ret_Error = SES_RANGE_ERR };
#else
    enum { VS_Ret_Ok = 0U };
    enum { VS_Ret_Found = 1U };
    enum { VS_Evt_Reset = 0U };
    enum { VS_Ret_Error = 4U };
#endif
#endif
// ------------------------------------------------------------------------

    // Mapping of args passed as hashId to corresponding identifier
    static const ::FeatStd::Char *GetNameFromId(::FeatStd::UInt32 id);

// ------------------------------------------------------------------------
    virtual void acHdOnOffUpdate(::FeatStd::Int8 aBand);
    virtual void acHdParameterUpdate(::FeatStd::Int8 aUpdate);
    virtual void acHdListAccess(::FeatStd::Int8 aScreenStatus);
    virtual void acDtmSplitAudio();
    virtual void acDtmResetTransitions();
    virtual void acHdParameterTuningUpdate(::FeatStd::Int8 aTuneType);
    virtual void acHdAudioProgSelect(::FeatStd::UInt32 aProgVal);
    virtual void Perform_TunerSelect_1();
    virtual void Perform_TunerSelect_2();
    virtual void Perform_TunerSelect_3();
    virtual void Perform_TunerSelect_4();
    virtual void Perform_BandSelect_Tuner1();
    virtual void Perform_BandSelect_Tuner2();
    virtual void Perform_BandSelect_Tuner3();
    virtual void Perform_BandSelect_Tuner4();
    virtual void Perform_SXM_Context();
    virtual void Perform_TestmodeBlock_Context();
    virtual void Perform_SXMMonitor_Context();
    virtual void Perform_SXMSettings_Context();
    virtual void Perform_SettingsBackBtn_Context();
    virtual void Perform_Service_Linking_Inc();
    virtual void Perform_Service_Linking_Dec();
    virtual void Perform_Service_Link_Inc();
    virtual void Perform_Service_Link_Dec();
    virtual void Perform_CLevel_Inc();
    virtual void Perform_CLevel_Dec();
    virtual void Activate_DAB_TestMode();
    virtual void Deactivate_DAB_TestMode();
    virtual void Perform_Preset_Select_1();
    virtual void Perform_Preset_Select_2();
    virtual void Perform_Preset_Select_3();
    virtual void Perform_Preset_Select_4();
    virtual void Perform_Preset_Select_5();
    virtual void Perform_Preset_Select_6();
    virtual void Perform_Preset_Select_7();
    virtual void Perform_Preset_Select_8();
    virtual void Perform_Preset_Select_9();
    virtual void Perform_Preset_Select_10();
    virtual void Perform_Preset_Select_11();
    virtual void Perform_Preset_Select_12();
    virtual void Perform_Preset_Popup_1();
    virtual void Perform_Preset_Popup_2();
    virtual void Perform_Preset_Popup_3();
    virtual void Perform_Preset_Popup_4();
    virtual void Perform_Preset_Popup_5();
    virtual void Perform_Preset_Popup_6();
    virtual void Perform_Preset_Popup_7();
    virtual void Perform_Preset_Popup_8();
    virtual void Perform_Preset_Popup_9();
    virtual void Perform_Preset_Popup_10();
    virtual void Perform_Preset_Popup_11();
    virtual void Perform_Preset_Popup_12();
    virtual void Perform_CannotStore_Popup();
    virtual void Perform_Preset_Store_1();
    virtual void Perform_Preset_Store_2();
    virtual void Perform_Preset_Store_3();
    virtual void Perform_Preset_Store_4();
    virtual void Perform_Preset_Store_5();
    virtual void Perform_Preset_Store_6();
    virtual void Perform_Preset_Store_7();
    virtual void Perform_Preset_Store_8();
    virtual void Perform_Preset_Store_9();
    virtual void Perform_Preset_Store_10();
    virtual void Perform_Preset_Store_11();
    virtual void Perform_Preset_Store_12();
    virtual void Perform_Seek_Stop();
    virtual void Perform_Seek_Next();
    virtual void Perform_Seek_Previous();
    virtual void Perform_Seek_Next_Repeat();
    virtual void Perform_Seek_Previous_Repeat();
    virtual void Perform_Seek_Previous_Jump();
    virtual void Perform_Seek_Next_Jump();
    virtual void Perform_RefTunerModule_Scene_Tuner_FM();
    virtual void Perform_RefTunerModule_Scene_Tuner_AM();
    virtual void Perform_Freq_Tuning_StepUp();
    virtual void Perform_Freq_Tuning_StepDown();
    virtual void Perform_Freq_Scan_Start();
    virtual void Perform_Freq_Scan_Stop();
    virtual void Perform_MediaChange();
    virtual void Perform_HomeScreenChange();
    virtual void Perform_BTPhoneMsgChange();
    virtual void Perform_NaviChange();
    virtual void Perform_MirrorLinkChange();
    virtual void PreformTunerAppActReqMsg();
    virtual void Preform_AFListExit();
    virtual void Perform_DAB_TM_Freq_Seek_Next();
    virtual void Perform_DAB_TM_Freq_Seek_Previous();
    virtual void Perform_DAB_TM_Ensemble_Seek_Next();
    virtual void Perform_DAB_TM_Ensemble_Seek_Previous();
    virtual void TunerViewReq_SourceSelection();
    virtual void TunerViewReq_FM1();
    virtual void TunerViewReq_FM2();
    virtual void TunerViewReq_FM_AST();
    virtual void TunerViewReq_AM();
    virtual void TunerViewReq_AM_AST();
    virtual void TunerViewReq_DAB();
    virtual void TunerViewReq_DAB_Monitor();
    virtual void TunerViewReq_DAB_AST();
    virtual void TunerViewReq_WEATHERBAND();
    virtual void TunerViewReq_WEATHERBAND_MONITOR();
    virtual void TunerViewReq_DRM();
    virtual void TunerViewReq_DRM_AST();
    virtual void TunerViewReq_DRM_SL();
    virtual void TunerViewReq_OPT_DRMPTY();
    virtual void TunerViewReq_OPT_FMAM();
    virtual void TunerViewReq_OPT_DABPTY();
    virtual void TunerViewReq_FM_TESTMODE();
    virtual void TunerViewReq_FM_MONITORTESTMODE();
    virtual void TunerViewReq_AM_TESTMODE();
    virtual void TunerViewReq_AM_MONITORTESTMODE();
    virtual void TunerViewReq_Previous();
    virtual void TunerViewReq_PlayView();
    virtual void TunerViewReq_FM_SL();
    virtual void TunerViewReq_DAB_SL();
    virtual void TunerViewReq_TT_MONITOR1();
    virtual void TunerViewReq_TT_MONITOR2();
    virtual void TunerViewReq_TT_MONITOR3();
    virtual void TunerViewReq_DAB_SETUP_MONITOR();
    virtual void TunerViewReq_DAB_Quality_TestMode();
    virtual void TunerViewReq_DAB_Service_Info_TestMod();
    virtual void TunerViewReq_DAB_Expert_API_TestMode();
    virtual void TunerViewReq_DRMSetup_Monitor();
    virtual void TunerViewReq_AF_L();
    virtual void TunerViewReq_TMC();
    virtual void TunerViewReq_TMC_L();
    virtual void TunerViewReq_TMC_INFO();
    virtual void TunerViewReq_TMC_STN_INFO();
    virtual void TunerViewReq_TestModeScreens();
    virtual void TunerTestModeViewReqMsg_Start();
    virtual void TunerTestModeViewReqMsg_Stop();
    virtual void TunerViewReq_MASTER_GADGET_TUNER();
    virtual void TunerViewReq_FM_INFO();
    virtual void TunerViewReq_AM_INFO();
    virtual void TunerViewReq_HDDTM_TESTMODE();
    virtual void TunerViewReq_HDPARAMTUNING_TESTMODE();
    virtual void Perform_Activate_Home_Source();
    virtual void Perform_AutoStore_AM();
    virtual void Perform_AutoStore_FM();
    virtual void Perform_AutoStore_DAB();
    virtual void RequestBrowseList(::FeatStd::UInt8 aG_SM_ListType);
    virtual void RequestBrowseListExit(::FeatStd::UInt8 aG_SM_ListType);
    virtual void StationBrowseList();
    virtual void DABStationBrowseList();
    virtual void FMMonitorMessageSharxHiCut(::FeatStd::UInt8 aFirstArg, ::FeatStd::UInt8 aSecondArg);
    virtual void Perform_Tuner_fn(::FeatStd::UInt8 aEventId, ::FeatStd::UInt32 aFirstArg, ::FeatStd::UInt32 aSecondArg);
    virtual void Perform_Next_fn_FM();
    virtual void Perform_Previous_fn_FM();
    virtual void Perform_Next_fn_AM();
    virtual void Perform_Previous_fn_AM();
    virtual void Perform_Next_fn_DAB();
    virtual void Perform_Previous_fn_DAB();
    virtual void Perform_Next_fn();
    virtual void Perform_Previous_fn();
    virtual void Perform_Abort_Next_Previous_Icon_fn();
    virtual void Notify_Init_Finished();
    virtual void Perform_Main_Src_Select();
    virtual void Perform_Tuner_Src_Select();
    virtual void Perform_Home_Src_Toggle();
    virtual void Perform_Send_Context(::FeatStd::UInt8 aContextScene);
    virtual void Perform_Tuner_Wx_fn(::FeatStd::UInt32 aEventId);
    virtual void Perform_Stop_Next_Previous();
    virtual void Update_Preset_Focused();
    virtual void Update_FMPreset_Focused();
    virtual void Update_AMPreset_Focused();
    virtual void Update_Previous_View();
    virtual void gacChangeLanguageReq(::FeatStd::Int32 aLanguageId);
    virtual void gacHideFocusInViewReq(::FeatStd::UInt32 aView);
    virtual void NextLevelTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void PreviousLevelTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void DualViewLeftTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void DualViewRightTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void PageFlipBackTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void PageFlipFrontTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void ZoomInTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView, ::FeatStd::Int8 aPos);
    virtual void ZoomOutTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView, ::FeatStd::Int8 aPos);
    virtual void FadeTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void gacWaitAnimationStartReq();
    virtual void acFocusOnRightEncoderReqUpd(bool aIsFocusUsed);
    virtual void acSetGadgetSceenActiveStatus(bool aIsGadgetAtive);
    virtual void acHKNotificationMsg(::FeatStd::Int8 aHKCode, ::FeatStd::Int8 aHKState);
    virtual void acPerform_CloseAllDropdowns();
    virtual void acPerform_CloseDropdown(::FeatStd::UInt32 aListId);
    virtual void acPerform_OpenDropdown(::FeatStd::UInt32 aListId);
    virtual void acPerform_ToggleDropdown(::FeatStd::UInt32 aListId);
    virtual void acStartAppPopupTimer(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aTimeout);
    virtual void acStopAppPopupTimer(::FeatStd::UInt32 aViewId);
    virtual void acPostBeep(::FeatStd::Int8 aBeepType);
    virtual void gacCheckToClosePopup(::FeatStd::UInt32 aPopupId);
    virtual void acRestartAppPopupTimer(::FeatStd::UInt32 aViewId);
    virtual void gacContextSwitchBackRes(::FeatStd::UInt32 aSwitchId);
    virtual void gacContextSwitchCompleteRes(::FeatStd::UInt32 aSwitchId);
    virtual void gacContextSwitchFailedRes(::FeatStd::UInt32 aSwitchId);
    virtual void gacContextSwitchDoneRes(::FeatStd::UInt32 aSwitchId);
    virtual void gacContextSwitchOutReq(::FeatStd::UInt32 aTargetContextId, ::FeatStd::UInt32 aSourceContextId, ::FeatStd::UInt32 aTargetAppId);
    virtual void gacCurrentScreenDisplayReq();
    virtual void gacLaunchBarDisplayReq(bool aVisibility);
    virtual void gacNavTBTSwipe();
    virtual void gacPerformListBtnRightEncoderChangeUpd(::FeatStd::Int8 aSteps, ::FeatStd::UInt32 aListId, ::FeatStd::UInt32 aRowId, ::FeatStd::UInt32 aColumnId);
    virtual void gacScrollListUp();
    virtual void gacScrollListDown();
    virtual void gacScrollPageUp();
    virtual void gacScrollPageDown();
    virtual void gacScrollListFocusUp(::FeatStd::UInt32 aListId);
    virtual void gacScrollListFocusDown(::FeatStd::UInt32 aListId);
    virtual void gacPerformListFocusLockDataResetUpd();
    virtual void gacSetApplicationMode(::FeatStd::UInt32 aModeId);
    virtual void gacSpellerBbehaviorReq(bool aEnable);
    virtual void gacStatusBarDisplayReq(bool aVisibility, ::FeatStd::Int32 aHeaderType);
    virtual void gacTBTRetriggerAcousticOutput();
    virtual void gacWaitAnimationStopReq();
    virtual void gacViewCreateReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewCreateAllReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewDestroyReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewClearReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewShowReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewHideReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewCreateWithoutLoadReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewAsyncLoadReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewActivateWithoutRenderingReq(::FeatStd::UInt32 aViewId);
    virtual void gacPopupCreateAndSBShowReq(::FeatStd::UInt32 aViewId);
    virtual void gacPopupCreateAndSBShowReqForMultiDisplay(::FeatStd::UInt32 aPopupDisplayID, ::FeatStd::UInt32 aViewId);
    virtual void gacPopupSBCloseReq(::FeatStd::UInt32 aViewId);
    virtual void gacPopupSBCloseReqForMultiDisplay(::FeatStd::UInt32 aPopupDisplayID, ::FeatStd::UInt32 aViewId);
    virtual void gacPopupRestartTimerReq(::FeatStd::UInt32 aViewId);
    virtual void gacPopupRestartTimerReqForMultiDisplay(::FeatStd::UInt32 aPopupDisplayID, ::FeatStd::UInt32 aViewId);
    virtual void gacViewCreateAndShowReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewHideAndDestroyReq(::FeatStd::UInt32 aViewId);
    virtual void gacSceneTransitionEnter(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aHint);
    virtual void gacSceneTransitionLeave(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aHint);
    virtual void gacDisplayStatusLineReq(::FeatStd::Int32 aDisplayRegionType);
    virtual void gacHideStatusLineReq(::FeatStd::Int32 aDisplayRegionType);
    virtual void gacDisplayFooterLineReq();
    virtual void gacHideFooterLineReq();
    virtual void gacDisplayStatusLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID);
    virtual void gacHideStatusLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID);
    virtual void gacDisplayFooterLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID);
    virtual void gacHideFooterLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID);
    virtual void gacRegisterForCloseOnTouchSession(::FeatStd::UInt32 aViewId);
    virtual void gacDeregisterForCloseOnTouchSessionReq(::FeatStd::UInt32 aViewId);
    virtual void gacPopupFilterPrioEnableReq(::FeatStd::UInt32 aPrio);
    virtual void gacPopupFilterAllEnableReq();
    virtual void gacPopupFilterDisableReq();
    virtual void gacProfileChange(::FeatStd::Int8 aProfile);
    virtual void gacPopupFilterPrioEnableReqForDisplay(::FeatStd::UInt32 aPrio, ::FeatStd::UInt32 aDisplayID);
    virtual void gacPopupFilterAllEnableReqForDisplay(::FeatStd::UInt32 aDisplayID);
    virtual void gacPopupFilterDisableReqForDisplay(::FeatStd::UInt32 aDisplayID);
    virtual void gacStartSceneTransitionAnimation(::FeatStd::UInt32 aSourceView, ::FeatStd::UInt32 aDestinationView, ::FeatStd::UInt32 aUserData1, ::FeatStd::Int8 aUserData2);
    virtual void gacDecrementActiveAnimationCount();

#ifdef CIT_SIMULATION
    bool CallAction(const ::FeatStd::Char* actionName, const ::Json::Value& parameters, ::Json::Value &response);
    const ::FeatStd::Char* GetEventName(::FeatStd::UInt32 eventId, ::Courier::Message const & message, Json::Value& eventArgument);
#endif
    // Added function for deduction of one event to simplify the event loop
    bool HandleDataBindingEventMapping(::Courier::AbstractDataItemMsg const & message, ::FeatStd::UInt32& eventId) const;
    bool HandleEventMapping(::Courier::Message const & message, ::FeatStd::UInt32& eventId) const;

    ::Cit::DeductResult::Enum DeductEvent(::Courier::Message const & message, ::FeatStd::UInt32 eventId);

    //====  member function with TTFis output - added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====

	virtual unsigned short GetTraceClass();
	int GetNumberOfStatemachines();
    //====  member function with TTFis output - end                        key: SM_TTFis_SBHFMSRF ====
};

// ------------------------------------------------------------------------
bool SendHdOnOffReqMsg(Courier::Int8 const & aBand);
bool SendHdParameterListUpdate(Courier::Int8 const & aUpdate);
bool SendHdListAccessUpdateMsg(Courier::Int8 const & aScreenStatus);
bool SendDtmSplitAudioReqMsg();
bool SendDtmResetTransitionsReqMsg();
bool SendHdParameterTuningMsg(Courier::Int8 const & aTuneType);
bool SendHdAudioProgSelectMsg(Courier::UInt32 const & aProgVal);
bool SendTunerReqMsg(Courier::Int8 const & aTunerData);
bool SendSXMContextMsg();
bool SendTestmodeBlockContextMsg();
bool SendSXMMonitorContextMsg();
bool SendSXMSettingsTestmodeContextMsg();
bool SendFMAMBackContextMsg();
bool SendDABServiceReqMsg(Courier::UInt8 const & aService_Value);
bool SendDABServiceLinkReqMsg(Courier::UInt8 const & aService_Value);
bool SendDABCLevelReqMsg(Courier::UInt8 const & aCLevel_Value);
bool SendTestModeDABQuality(Courier::UInt8 const & aDABTestModeActiveStatus);
bool SendPresetSelectMsg(Courier::Int8 const & aPresetNumber);
bool SendPresetPopupMsg(Courier::Int8 const & aPresetNumber);
bool SendCannotStorePopupMsg();
bool SendLPReleaseMsg(Courier::Int8 const & aPresetNumber);
bool SendSeekReqMsg(Courier::Int8 const & aSeekMode);
bool SendSetWaveBandMsg(Courier::Int32 const & aBand);
bool SendTuneFrequencyReqMsg(Courier::Int8 const & aDirection, Courier::Int8 const & aTicks);
bool SendScanReqMsg(Courier::Int8 const & aScanMode);
bool SendMediaChangeMsg();
bool SendHomeScreenMsg();
bool SendBTPhoneMsg();
bool SendNaviMsg();
bool SendMirrorLinkMsg();
bool SendTunerAppActReqMsg();
bool SendAFListExitMsg();
bool SendDABTMSeekReqMsg(Courier::Int8 const & aDABTMSeekMode);
bool SendTunerViewReqMsg(Courier::UInt8 const & aView);
bool SendTuner_TestmodeViewReqMsg(Courier::UInt8 const & aTestmode_Value);
bool SendSwitchApplicationReq(enApplicationId const & aApplicationID, enSurfaceId const & aSurfaceID);
bool SendAutoStoreReqMsg();
bool SendBrowseListReqMsg(Courier::UInt8 const & aG_SM_ListType);
bool SendBrowseListExitMsg(Courier::UInt8 const & aG_SM_ListType);
bool SendStationListReqMsg();
bool SendDABStationListReqMsg();
bool SendFMMonitorMessage(Candera::UInt8 const & aFirstArg, Candera::UInt8 const & aSecondArg);
bool SendTunerBLMsg(Courier::Int8 const & aEventId, Courier::Int32 const & aFirstArg, Courier::Int32 const & aSecondArg);
bool SendNextSelectMsg_FM();
bool SendPreviousSelectMsg_FM();
bool SendNextSelectMsg_AM();
bool SendPreviousSelectMsg_AM();
bool SendNextSelectMsg_DAB();
bool SendPreviousSelectMsg_DAB();
bool SendNextIconSelectMsg();
bool SendPreviousIconSelectMsg();
bool SendAbortNextPreviousIcon();
bool SendGuiStartupFinishedUpdMsg();
bool SendButtonMainSrcActivate(Courier::Int8 const & aSrcmode);
bool SendContextToMaster(Courier::UInt8 const & aContextScene);
bool SendTuner_WxBLMsg(Courier::Int32 const & aEventId);
bool SendCloseNextPrev();
bool SendUpdatePresetFocused();
bool SendUpdateFMPresetFocused();
bool SendUpdateAMPresetFocused();
bool SendViewPreviousMsg();
bool SendChangeLanguageReqMsg(enLanguageId const & aLanguageId);
bool SendFocusReqMsg(FocusActionEnum const & aAction, FocusTimerActionEnum const & aTimerAction, ::Courier::ViewId const & aView, Candera::String const & aWidget);
bool SendDummyMess(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos);
bool SendAnimationReqMsg(Courier::AnimationAction::Enum const & aAnimationAction, ::Courier::ViewId const & aViewId, Courier::CompositePath const & aCompositePath, ::Courier::ItemId const & aAnimationId, Courier::AnimationProperties const & aAnimationProperties);
bool SendFocusOnRightEncoderReqUpdMsg(bool const & aIsFocusUsed);
bool SendStoreActiveGadgetReqMsg(bool const & aIsGadgetAtive);
bool SendHardKeyPressNotificationMsg(Courier::UInt8 const & aDummy, Courier::UInt8 const & aHKCode, Courier::UInt8 const & aHKState);
bool SendDropdownChangeMsg(::Candera::DropdownChangeType const & aDropdownChangeType, ::Courier::UInt32 const & aListId);
bool SendStartPopupTimerReqMsg(Courier::UInt32 const & aViewId, Courier::UInt32 const & aTimeout);
bool SendStopPopupTimerReqMsg(Courier::UInt32 const & aViewId);
bool SendPlayBeepReqMsg(Courier::Int32 const & aBeepType);
bool SendCheckToClosePopupMsg(Courier::UInt32 const & aPopupId);
bool SendRestartPopupTimerReqMsg(Courier::UInt32 const & aViewId);
bool SendContextSwitchInResMsg(Courier::UInt32 const & aSwitchId, Courier::UInt32 const & aResponseType);
bool SendContextSwitchOutReqMsg(Courier::UInt32 const & aTargetContextId, Courier::UInt32 const & aSourceContextId, Courier::UInt32 const & aTargetAppId);
bool SendCurrentScreenDisplayReqMsg();
bool SendLaunchBarDisplayReqMsg(bool const & aVisibility);
bool SendNavTBTSwipeReqMsg();
bool SendListItemRightEncoderChangeUpdMsg(Courier::Int8 const & aSteps, Courier::UInt32 const & aListId, Courier::UInt32 const & aRowId, Courier::UInt32 const & aColumnId);
bool SendListChangeMsg(::Courier::UInt32 const & aListId, ListChangeType const & aListChangeType, ::Courier::Int32 const & aValue, ListChangeMsgSourceType const & aListChangeMsgSource, bool const & aImmediatePositioning);
bool SendListFocusScrollReqMsg(Courier::UInt32 const & aListId, Courier::Int32 const & aSteps);
bool SendListFocusLockDataResetReqMsg();
bool SendSetApplicationModeReqMsg(Courier::UInt32 const & aModeId);
bool SendSpellerBbehaviorReqMsg(bool const & aEnable);
bool SendStatusBarDisplayReqMsg(bool const & aVisibility, Courier::Int32 const & aHeaderType);
bool SendTBTRetriggerAcousticMsg();
bool SendViewReqMsg(Courier::ViewAction::Enum const & aViewAction, ::Courier::ViewId const & aViewId, bool const & aShallInitScene, bool const & aShallLoadScene);
bool SendActivationReqMsg(::Courier::ViewId const & aViewId, bool const & aActivation, bool const & aEnableRendering);
bool SendAsyncLoadReqMsg(::Courier::ViewId const & aViewId, bool const & aLoad);
bool SendPopupReqMsg(hmibase::popups::CommandEnum const & aCommand, ::Courier::ViewId const & aViewId, Courier::UInt32 const & aPopupDisplayID);
bool SendExtendedViewReqMsg(hmibase::views::CommandEnum const & aCommand, ::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint);
bool SendShowHMISubSurfaceReqMsg(hmibase::displayRegion const & aDisplayRegion, Courier::Int32 const & aDisplayRegionType, bool const & aShowSubSurface, Courier::UInt32 const & aDisplayID, bool const & aLockSubSurface);
bool SendRegisterForCloseOnTouchSessionReqMsg(bool const & aRegister, ::Courier::ViewId const & aViewId);
bool SendPopupFilterPrioEnableReqMsg(Courier::UInt32 const & aPrio);
bool SendPopupFilterAllEnableReqMsg();
bool SendPopupFilterDisableReqMsg();
bool SendProfileSwitchMsg(Courier::UInt32 const & aProfile);
bool SendMultiDisplayPopupFilterReqMsg(hmibase::PopupFilterType const & aPopupFilterType, Courier::UInt32 const & aPrio, Courier::UInt32 const & aDisplayID);
bool SendCreateNewDestroyOld(::Courier::ViewId const & aSourceView, ::Courier::ViewId const & aDestinationView, Courier::UInt32 const & aUserData1, Courier::Int8 const & aUserData2);
bool SendNotifierMessage();

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acHdOnOffUpdate(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acHdOnOffUpdate(Courier::Int8 const & aBand);
#ifdef CIT_SIMULATION
bool CallAction_acHdParameterUpdate(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acHdParameterUpdate(Courier::Int8 const & aUpdate);
#ifdef CIT_SIMULATION
bool CallAction_acHdListAccess(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acHdListAccess(Courier::Int8 const & aScreenStatus);
#ifdef CIT_SIMULATION
bool CallAction_acDtmSplitAudio(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acDtmSplitAudio();
#ifdef CIT_SIMULATION
bool CallAction_acDtmResetTransitions(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acDtmResetTransitions();
#ifdef CIT_SIMULATION
bool CallAction_acHdParameterTuningUpdate(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acHdParameterTuningUpdate(Courier::Int8 const & aTuneType);
#ifdef CIT_SIMULATION
bool CallAction_acHdAudioProgSelect(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acHdAudioProgSelect(Courier::UInt32 const & aProgVal);
#ifdef CIT_SIMULATION
bool CallAction_Perform_TunerSelect_1(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_TunerSelect_1();
#ifdef CIT_SIMULATION
bool CallAction_Perform_TunerSelect_2(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_TunerSelect_2();
#ifdef CIT_SIMULATION
bool CallAction_Perform_TunerSelect_3(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_TunerSelect_3();
#ifdef CIT_SIMULATION
bool CallAction_Perform_TunerSelect_4(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_TunerSelect_4();
#ifdef CIT_SIMULATION
bool CallAction_Perform_BandSelect_Tuner1(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_BandSelect_Tuner1();
#ifdef CIT_SIMULATION
bool CallAction_Perform_BandSelect_Tuner2(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_BandSelect_Tuner2();
#ifdef CIT_SIMULATION
bool CallAction_Perform_BandSelect_Tuner3(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_BandSelect_Tuner3();
#ifdef CIT_SIMULATION
bool CallAction_Perform_BandSelect_Tuner4(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_BandSelect_Tuner4();
#ifdef CIT_SIMULATION
bool CallAction_Perform_SXM_Context(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_SXM_Context();
#ifdef CIT_SIMULATION
bool CallAction_Perform_TestmodeBlock_Context(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_TestmodeBlock_Context();
#ifdef CIT_SIMULATION
bool CallAction_Perform_SXMMonitor_Context(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_SXMMonitor_Context();
#ifdef CIT_SIMULATION
bool CallAction_Perform_SXMSettings_Context(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_SXMSettings_Context();
#ifdef CIT_SIMULATION
bool CallAction_Perform_SettingsBackBtn_Context(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_SettingsBackBtn_Context();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Service_Linking_Inc(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Service_Linking_Inc();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Service_Linking_Dec(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Service_Linking_Dec();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Service_Link_Inc(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Service_Link_Inc();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Service_Link_Dec(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Service_Link_Dec();
#ifdef CIT_SIMULATION
bool CallAction_Perform_CLevel_Inc(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_CLevel_Inc();
#ifdef CIT_SIMULATION
bool CallAction_Perform_CLevel_Dec(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_CLevel_Dec();
#ifdef CIT_SIMULATION
bool CallAction_Activate_DAB_TestMode(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Activate_DAB_TestMode();
#ifdef CIT_SIMULATION
bool CallAction_Deactivate_DAB_TestMode(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Deactivate_DAB_TestMode();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Select_1(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Select_1();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Select_2(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Select_2();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Select_3(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Select_3();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Select_4(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Select_4();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Select_5(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Select_5();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Select_6(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Select_6();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Select_7(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Select_7();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Select_8(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Select_8();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Select_9(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Select_9();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Select_10(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Select_10();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Select_11(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Select_11();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Select_12(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Select_12();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Popup_1(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Popup_1();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Popup_2(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Popup_2();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Popup_3(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Popup_3();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Popup_4(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Popup_4();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Popup_5(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Popup_5();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Popup_6(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Popup_6();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Popup_7(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Popup_7();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Popup_8(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Popup_8();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Popup_9(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Popup_9();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Popup_10(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Popup_10();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Popup_11(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Popup_11();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Popup_12(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Popup_12();
#ifdef CIT_SIMULATION
bool CallAction_Perform_CannotStore_Popup(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_CannotStore_Popup();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Store_1(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Store_1();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Store_2(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Store_2();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Store_3(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Store_3();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Store_4(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Store_4();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Store_5(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Store_5();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Store_6(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Store_6();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Store_7(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Store_7();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Store_8(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Store_8();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Store_9(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Store_9();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Store_10(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Store_10();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Store_11(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Store_11();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Store_12(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Store_12();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Seek_Stop(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Seek_Stop();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Seek_Next(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Seek_Next();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Seek_Previous(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Seek_Previous();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Seek_Next_Repeat(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Seek_Next_Repeat();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Seek_Previous_Repeat(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Seek_Previous_Repeat();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Seek_Previous_Jump(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Seek_Previous_Jump();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Seek_Next_Jump(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Seek_Next_Jump();
#ifdef CIT_SIMULATION
bool CallAction_Perform_RefTunerModule_Scene_Tuner_FM(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_RefTunerModule_Scene_Tuner_FM();
#ifdef CIT_SIMULATION
bool CallAction_Perform_RefTunerModule_Scene_Tuner_AM(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_RefTunerModule_Scene_Tuner_AM();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Freq_Tuning_StepUp(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Freq_Tuning_StepUp();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Freq_Tuning_StepDown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Freq_Tuning_StepDown();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Freq_Scan_Start(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Freq_Scan_Start();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Freq_Scan_Stop(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Freq_Scan_Stop();
#ifdef CIT_SIMULATION
bool CallAction_Perform_MediaChange(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_MediaChange();
#ifdef CIT_SIMULATION
bool CallAction_Perform_HomeScreenChange(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_HomeScreenChange();
#ifdef CIT_SIMULATION
bool CallAction_Perform_BTPhoneMsgChange(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_BTPhoneMsgChange();
#ifdef CIT_SIMULATION
bool CallAction_Perform_NaviChange(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_NaviChange();
#ifdef CIT_SIMULATION
bool CallAction_Perform_MirrorLinkChange(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_MirrorLinkChange();
#ifdef CIT_SIMULATION
bool CallAction_PreformTunerAppActReqMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_PreformTunerAppActReqMsg();
#ifdef CIT_SIMULATION
bool CallAction_Preform_AFListExit(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Preform_AFListExit();
#ifdef CIT_SIMULATION
bool CallAction_Perform_DAB_TM_Freq_Seek_Next(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_DAB_TM_Freq_Seek_Next();
#ifdef CIT_SIMULATION
bool CallAction_Perform_DAB_TM_Freq_Seek_Previous(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_DAB_TM_Freq_Seek_Previous();
#ifdef CIT_SIMULATION
bool CallAction_Perform_DAB_TM_Ensemble_Seek_Next(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_DAB_TM_Ensemble_Seek_Next();
#ifdef CIT_SIMULATION
bool CallAction_Perform_DAB_TM_Ensemble_Seek_Previous(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_DAB_TM_Ensemble_Seek_Previous();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_SourceSelection(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_SourceSelection();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_FM1(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_FM1();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_FM2(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_FM2();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_FM_AST(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_FM_AST();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_AM(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_AM();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_AM_AST(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_AM_AST();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_DAB(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_DAB();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_DAB_Monitor(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_DAB_Monitor();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_DAB_AST(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_DAB_AST();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_WEATHERBAND(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_WEATHERBAND();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_WEATHERBAND_MONITOR(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_WEATHERBAND_MONITOR();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_DRM(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_DRM();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_DRM_AST(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_DRM_AST();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_DRM_SL(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_DRM_SL();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_OPT_DRMPTY(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_OPT_DRMPTY();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_OPT_FMAM(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_OPT_FMAM();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_OPT_DABPTY(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_OPT_DABPTY();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_FM_TESTMODE(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_FM_TESTMODE();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_FM_MONITORTESTMODE(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_FM_MONITORTESTMODE();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_AM_TESTMODE(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_AM_TESTMODE();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_AM_MONITORTESTMODE(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_AM_MONITORTESTMODE();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_Previous(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_Previous();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_PlayView(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_PlayView();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_FM_SL(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_FM_SL();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_DAB_SL(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_DAB_SL();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_TT_MONITOR1(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_TT_MONITOR1();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_TT_MONITOR2(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_TT_MONITOR2();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_TT_MONITOR3(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_TT_MONITOR3();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_DAB_SETUP_MONITOR(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_DAB_SETUP_MONITOR();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_DAB_Quality_TestMode(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_DAB_Quality_TestMode();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_DAB_Service_Info_TestMod(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_DAB_Service_Info_TestMod();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_DAB_Expert_API_TestMode(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_DAB_Expert_API_TestMode();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_DRMSetup_Monitor(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_DRMSetup_Monitor();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_AF_L(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_AF_L();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_TMC(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_TMC();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_TMC_L(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_TMC_L();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_TMC_INFO(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_TMC_INFO();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_TMC_STN_INFO(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_TMC_STN_INFO();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_TestModeScreens(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_TestModeScreens();
#ifdef CIT_SIMULATION
bool CallAction_TunerTestModeViewReqMsg_Start(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerTestModeViewReqMsg_Start();
#ifdef CIT_SIMULATION
bool CallAction_TunerTestModeViewReqMsg_Stop(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerTestModeViewReqMsg_Stop();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_MASTER_GADGET_TUNER(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_MASTER_GADGET_TUNER();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_FM_INFO(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_FM_INFO();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_AM_INFO(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_AM_INFO();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_HDDTM_TESTMODE(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_HDDTM_TESTMODE();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_HDPARAMTUNING_TESTMODE(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_HDPARAMTUNING_TESTMODE();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Activate_Home_Source(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Activate_Home_Source();
#ifdef CIT_SIMULATION
bool CallAction_Perform_AutoStore_AM(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_AutoStore_AM();
#ifdef CIT_SIMULATION
bool CallAction_Perform_AutoStore_FM(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_AutoStore_FM();
#ifdef CIT_SIMULATION
bool CallAction_Perform_AutoStore_DAB(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_AutoStore_DAB();
#ifdef CIT_SIMULATION
bool CallAction_RequestBrowseList(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_RequestBrowseList(Courier::UInt8 const & aG_SM_ListType);
#ifdef CIT_SIMULATION
bool CallAction_RequestBrowseListExit(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_RequestBrowseListExit(Courier::UInt8 const & aG_SM_ListType);
#ifdef CIT_SIMULATION
bool CallAction_StationBrowseList(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_StationBrowseList();
#ifdef CIT_SIMULATION
bool CallAction_DABStationBrowseList(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_DABStationBrowseList();
#ifdef CIT_SIMULATION
bool CallAction_FMMonitorMessageSharxHiCut(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_FMMonitorMessageSharxHiCut(Candera::UInt8 const & aFirstArg, Candera::UInt8 const & aSecondArg);
#ifdef CIT_SIMULATION
bool CallAction_Perform_Tuner_fn(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Tuner_fn(Courier::Int8 const & aEventId, Courier::Int32 const & aFirstArg, Courier::Int32 const & aSecondArg);
#ifdef CIT_SIMULATION
bool CallAction_Perform_Next_fn_FM(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Next_fn_FM();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Previous_fn_FM(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Previous_fn_FM();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Next_fn_AM(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Next_fn_AM();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Previous_fn_AM(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Previous_fn_AM();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Next_fn_DAB(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Next_fn_DAB();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Previous_fn_DAB(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Previous_fn_DAB();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Next_fn(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Next_fn();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Previous_fn(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Previous_fn();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Abort_Next_Previous_Icon_fn(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Abort_Next_Previous_Icon_fn();
#ifdef CIT_SIMULATION
bool CallAction_Notify_Init_Finished(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Notify_Init_Finished();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Main_Src_Select(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Main_Src_Select();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Tuner_Src_Select(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Tuner_Src_Select();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Home_Src_Toggle(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Home_Src_Toggle();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Send_Context(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Send_Context(Courier::UInt8 const & aContextScene);
#ifdef CIT_SIMULATION
bool CallAction_Perform_Tuner_Wx_fn(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Tuner_Wx_fn(Courier::Int32 const & aEventId);
#ifdef CIT_SIMULATION
bool CallAction_Perform_Stop_Next_Previous(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Stop_Next_Previous();
#ifdef CIT_SIMULATION
bool CallAction_Update_Preset_Focused(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Update_Preset_Focused();
#ifdef CIT_SIMULATION
bool CallAction_Update_FMPreset_Focused(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Update_FMPreset_Focused();
#ifdef CIT_SIMULATION
bool CallAction_Update_AMPreset_Focused(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Update_AMPreset_Focused();
#ifdef CIT_SIMULATION
bool CallAction_Update_Previous_View(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Update_Previous_View();
#ifdef CIT_SIMULATION
bool CallAction_gacChangeLanguageReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacChangeLanguageReq(enLanguageId const & aLanguageId);
#ifdef CIT_SIMULATION
bool CallAction_gacHideFocusInViewReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacHideFocusInViewReq(::Courier::ViewId const & aView);
#ifdef CIT_SIMULATION
bool CallAction_NextLevelTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_NextLevelTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_PreviousLevelTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_PreviousLevelTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_DualViewLeftTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_DualViewLeftTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_DualViewRightTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_DualViewRightTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_PageFlipBackTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_PageFlipBackTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_PageFlipFrontTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_PageFlipFrontTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_ZoomInTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_ZoomInTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos);
#ifdef CIT_SIMULATION
bool CallAction_ZoomOutTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_ZoomOutTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos);
#ifdef CIT_SIMULATION
bool CallAction_FadeTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_FadeTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_gacWaitAnimationStartReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacWaitAnimationStartReq();
#ifdef CIT_SIMULATION
bool CallAction_acFocusOnRightEncoderReqUpd(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acFocusOnRightEncoderReqUpd(bool const & aIsFocusUsed);
#ifdef CIT_SIMULATION
bool CallAction_acSetGadgetSceenActiveStatus(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSetGadgetSceenActiveStatus(bool const & aIsGadgetAtive);
#ifdef CIT_SIMULATION
bool CallAction_acHKNotificationMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acHKNotificationMsg(Courier::UInt8 const & aHKCode, Courier::UInt8 const & aHKState);
#ifdef CIT_SIMULATION
bool CallAction_acPerform_CloseAllDropdowns(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPerform_CloseAllDropdowns();
#ifdef CIT_SIMULATION
bool CallAction_acPerform_CloseDropdown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPerform_CloseDropdown(::Courier::UInt32 const & aListId);
#ifdef CIT_SIMULATION
bool CallAction_acPerform_OpenDropdown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPerform_OpenDropdown(::Courier::UInt32 const & aListId);
#ifdef CIT_SIMULATION
bool CallAction_acPerform_ToggleDropdown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPerform_ToggleDropdown(::Courier::UInt32 const & aListId);
#ifdef CIT_SIMULATION
bool CallAction_acStartAppPopupTimer(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acStartAppPopupTimer(Courier::UInt32 const & aViewId, Courier::UInt32 const & aTimeout);
#ifdef CIT_SIMULATION
bool CallAction_acStopAppPopupTimer(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acStopAppPopupTimer(Courier::UInt32 const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_acPostBeep(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPostBeep(Courier::Int32 const & aBeepType);
#ifdef CIT_SIMULATION
bool CallAction_gacCheckToClosePopup(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacCheckToClosePopup(Courier::UInt32 const & aPopupId);
#ifdef CIT_SIMULATION
bool CallAction_acRestartAppPopupTimer(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acRestartAppPopupTimer(Courier::UInt32 const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchBackRes(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacContextSwitchBackRes(Courier::UInt32 const & aSwitchId);
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchCompleteRes(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacContextSwitchCompleteRes(Courier::UInt32 const & aSwitchId);
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchFailedRes(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacContextSwitchFailedRes(Courier::UInt32 const & aSwitchId);
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchDoneRes(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacContextSwitchDoneRes(Courier::UInt32 const & aSwitchId);
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchOutReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacContextSwitchOutReq(Courier::UInt32 const & aTargetContextId, Courier::UInt32 const & aSourceContextId, Courier::UInt32 const & aTargetAppId);
#ifdef CIT_SIMULATION
bool CallAction_gacCurrentScreenDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacCurrentScreenDisplayReq();
#ifdef CIT_SIMULATION
bool CallAction_gacLaunchBarDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacLaunchBarDisplayReq(bool const & aVisibility);
#ifdef CIT_SIMULATION
bool CallAction_gacNavTBTSwipe(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacNavTBTSwipe();
#ifdef CIT_SIMULATION
bool CallAction_gacPerformListBtnRightEncoderChangeUpd(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPerformListBtnRightEncoderChangeUpd(Courier::Int8 const & aSteps, Courier::UInt32 const & aListId, Courier::UInt32 const & aRowId, Courier::UInt32 const & aColumnId);
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListUp(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollListUp();
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListDown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollListDown();
#ifdef CIT_SIMULATION
bool CallAction_gacScrollPageUp(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollPageUp();
#ifdef CIT_SIMULATION
bool CallAction_gacScrollPageDown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollPageDown();
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListFocusUp(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollListFocusUp(Courier::UInt32 const & aListId);
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListFocusDown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollListFocusDown(Courier::UInt32 const & aListId);
#ifdef CIT_SIMULATION
bool CallAction_gacPerformListFocusLockDataResetUpd(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPerformListFocusLockDataResetUpd();
#ifdef CIT_SIMULATION
bool CallAction_gacSetApplicationMode(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacSetApplicationMode(Courier::UInt32 const & aModeId);
#ifdef CIT_SIMULATION
bool CallAction_gacSpellerBbehaviorReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacSpellerBbehaviorReq(bool const & aEnable);
#ifdef CIT_SIMULATION
bool CallAction_gacStatusBarDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacStatusBarDisplayReq(bool const & aVisibility, Courier::Int32 const & aHeaderType);
#ifdef CIT_SIMULATION
bool CallAction_gacTBTRetriggerAcousticOutput(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacTBTRetriggerAcousticOutput();
#ifdef CIT_SIMULATION
bool CallAction_gacWaitAnimationStopReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacWaitAnimationStopReq();
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewCreateReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateAllReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewCreateAllReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewDestroyReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewDestroyReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewClearReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewClearReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewShowReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewShowReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewHideReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewHideReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateWithoutLoadReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewCreateWithoutLoadReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewAsyncLoadReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewAsyncLoadReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewActivateWithoutRenderingReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewActivateWithoutRenderingReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupCreateAndSBShowReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupCreateAndSBShowReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupCreateAndSBShowReqForMultiDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupCreateAndSBShowReqForMultiDisplay(Courier::UInt32 const & aPopupDisplayID, ::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupSBCloseReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupSBCloseReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupSBCloseReqForMultiDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupSBCloseReqForMultiDisplay(Courier::UInt32 const & aPopupDisplayID, ::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupRestartTimerReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupRestartTimerReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupRestartTimerReqForMultiDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupRestartTimerReqForMultiDisplay(Courier::UInt32 const & aPopupDisplayID, ::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateAndShowReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewCreateAndShowReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewHideAndDestroyReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewHideAndDestroyReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacSceneTransitionEnter(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacSceneTransitionEnter(::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint);
#ifdef CIT_SIMULATION
bool CallAction_gacSceneTransitionLeave(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacSceneTransitionLeave(::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint);
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayStatusLineReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDisplayStatusLineReq(Courier::Int32 const & aDisplayRegionType);
#ifdef CIT_SIMULATION
bool CallAction_gacHideStatusLineReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacHideStatusLineReq(Courier::Int32 const & aDisplayRegionType);
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayFooterLineReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDisplayFooterLineReq();
#ifdef CIT_SIMULATION
bool CallAction_gacHideFooterLineReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacHideFooterLineReq();
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayStatusLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDisplayStatusLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacHideStatusLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacHideStatusLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayFooterLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDisplayFooterLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacHideFooterLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacHideFooterLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacRegisterForCloseOnTouchSession(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacRegisterForCloseOnTouchSession(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacDeregisterForCloseOnTouchSessionReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDeregisterForCloseOnTouchSessionReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterPrioEnableReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterPrioEnableReq(Courier::UInt32 const & aPrio);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterAllEnableReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterAllEnableReq();
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterDisableReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterDisableReq();
#ifdef CIT_SIMULATION
bool CallAction_gacProfileChange(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacProfileChange(Courier::UInt32 const & aProfile);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterPrioEnableReqForDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterPrioEnableReqForDisplay(Courier::UInt32 const & aPrio, Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterAllEnableReqForDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterAllEnableReqForDisplay(Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterDisableReqForDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterDisableReqForDisplay(Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacStartSceneTransitionAnimation(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacStartSceneTransitionAnimation(::Courier::ViewId const & aSourceView, ::Courier::ViewId const & aDestinationView, Courier::UInt32 const & aUserData1, Courier::Int8 const & aUserData2);
#ifdef CIT_SIMULATION
bool CallAction_gacDecrementActiveAnimationCount(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDecrementActiveAnimationCount();

// overall number of HierarchyNodes
static const ::FeatStd::UInt32 cGlobalDataItemHierarchyNodeCount = 704;
// overall number of DataItemDescriptor nodes
static const ::FeatStd::UInt32 cDataItemDescriptorCount = 704;
// overall number of BindingSources
static const ::FeatStd::UInt32 cBindingSourceCount = 114;
// maximum number of HierarchyNodes in a BindingSource
static const ::FeatStd::UInt32 cBindingSourceItemCountMax = 27;

// =========================================================================

class CheckBoxListItemDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 1;
    static const ::Courier::DataItemKey cDataItemKey = 588;

    typedef ::CheckBoxListItemData Data;

    CheckBoxListItemDataBindingSource();
};

typedef ::Courier::DataItemMsg< CheckBoxListItemDataBindingSource > CheckBoxListItemDataItemMsg;

// =========================================================================

class StationInfoSourceDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 27;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 2;
    static const ::Courier::DataItemKey cDataItemKey = 486;

    typedef ::StationInfoSourceData Data;

    StationInfoSourceDataBindingSource();
};

typedef ::Courier::DataItemMsg< StationInfoSourceDataBindingSource > StationInfoSourceDataItemMsg;

// =========================================================================

class HomeScreenInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 14;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 3;
    static const ::Courier::DataItemKey cDataItemKey = 600;

    typedef ::HomeScreenInfoData Data;

    HomeScreenInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< HomeScreenInfoDataBindingSource > HomeScreenInfoDataItemMsg;

// =========================================================================

class RadioBandInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 8;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 4;
    static const ::Courier::DataItemKey cDataItemKey = 188;

    typedef ::RadioBandInfoData Data;

    RadioBandInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< RadioBandInfoDataBindingSource > RadioBandInfoDataItemMsg;

// =========================================================================

class FMStationListDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 5;
    static const ::Courier::DataItemKey cDataItemKey = 41;

    typedef ::FMStationListData Data;

    FMStationListDataBindingSource();
};

typedef ::Courier::DataItemMsg< FMStationListDataBindingSource > FMStationListDataItemMsg;

// =========================================================================

class RDSOptionsDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 8;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 6;
    static const ::Courier::DataItemKey cDataItemKey = 474;

    typedef ::RDSOptionsData Data;

    RDSOptionsDataBindingSource();
};

typedef ::Courier::DataItemMsg< RDSOptionsDataBindingSource > RDSOptionsDataItemMsg;

// =========================================================================

class PresetInfoWBDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 13;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 7;
    static const ::Courier::DataItemKey cDataItemKey = 60;

    typedef ::PresetInfoWBData Data;

    PresetInfoWBDataBindingSource();
};

typedef ::Courier::DataItemMsg< PresetInfoWBDataBindingSource > PresetInfoWBDataItemMsg;

// =========================================================================

class WBPresetInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 11;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 8;
    static const ::Courier::DataItemKey cDataItemKey = 360;

    typedef ::WBPresetInfoData Data;

    WBPresetInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< WBPresetInfoDataBindingSource > WBPresetInfoDataItemMsg;

// =========================================================================

class PresetInfoFM1DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 7;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 9;
    static const ::Courier::DataItemKey cDataItemKey = 565;

    typedef ::PresetInfoFM1Data Data;

    PresetInfoFM1DataBindingSource();
};

typedef ::Courier::DataItemMsg< PresetInfoFM1DataBindingSource > PresetInfoFM1DataItemMsg;

// =========================================================================

class PresetInfoFM2DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 7;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 10;
    static const ::Courier::DataItemKey cDataItemKey = 604;

    typedef ::PresetInfoFM2Data Data;

    PresetInfoFM2DataBindingSource();
};

typedef ::Courier::DataItemMsg< PresetInfoFM2DataBindingSource > PresetInfoFM2DataItemMsg;

// =========================================================================

class PresetInfoFMASTDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 7;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 11;
    static const ::Courier::DataItemKey cDataItemKey = 553;

    typedef ::PresetInfoFMASTData Data;

    PresetInfoFMASTDataBindingSource();
};

typedef ::Courier::DataItemMsg< PresetInfoFMASTDataBindingSource > PresetInfoFMASTDataItemMsg;

// =========================================================================

class PresetInfoAMDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 13;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 12;
    static const ::Courier::DataItemKey cDataItemKey = 449;

    typedef ::PresetInfoAMData Data;

    PresetInfoAMDataBindingSource();
};

typedef ::Courier::DataItemMsg< PresetInfoAMDataBindingSource > PresetInfoAMDataItemMsg;

// =========================================================================

class PresetInfoAMASTDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 7;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 13;
    static const ::Courier::DataItemKey cDataItemKey = 662;

    typedef ::PresetInfoAMASTData Data;

    PresetInfoAMASTDataBindingSource();
};

typedef ::Courier::DataItemMsg< PresetInfoAMASTDataBindingSource > PresetInfoAMASTDataItemMsg;

// =========================================================================

class PresetInfoDABDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 13;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 14;
    static const ::Courier::DataItemKey cDataItemKey = 456;

    typedef ::PresetInfoDABData Data;

    PresetInfoDABDataBindingSource();
};

typedef ::Courier::DataItemMsg< PresetInfoDABDataBindingSource > PresetInfoDABDataItemMsg;

// =========================================================================

class PresetInfoDABASTDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 7;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 15;
    static const ::Courier::DataItemKey cDataItemKey = 43;

    typedef ::PresetInfoDABASTData Data;

    PresetInfoDABASTDataBindingSource();
};

typedef ::Courier::DataItemMsg< PresetInfoDABASTDataBindingSource > PresetInfoDABASTDataItemMsg;

// =========================================================================

class PresetInfoDRMDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 7;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 16;
    static const ::Courier::DataItemKey cDataItemKey = 109;

    typedef ::PresetInfoDRMData Data;

    PresetInfoDRMDataBindingSource();
};

typedef ::Courier::DataItemMsg< PresetInfoDRMDataBindingSource > PresetInfoDRMDataItemMsg;

// =========================================================================

class PresetInfoDRMASTDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 7;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 17;
    static const ::Courier::DataItemKey cDataItemKey = 396;

    typedef ::PresetInfoDRMASTData Data;

    PresetInfoDRMASTDataBindingSource();
};

typedef ::Courier::DataItemMsg< PresetInfoDRMASTDataBindingSource > PresetInfoDRMASTDataItemMsg;

// =========================================================================

class EngineeringInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 10;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 18;
    static const ::Courier::DataItemKey cDataItemKey = 535;

    typedef ::EngineeringInfoData Data;

    EngineeringInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< EngineeringInfoDataBindingSource > EngineeringInfoDataItemMsg;

// =========================================================================

class LayerNextPresets_FMDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 19;
    static const ::Courier::DataItemKey cDataItemKey = 641;

    typedef ::LayerNextPresets_FMData Data;

    LayerNextPresets_FMDataBindingSource();
};

typedef ::Courier::DataItemMsg< LayerNextPresets_FMDataBindingSource > LayerNextPresets_FMDataItemMsg;

// =========================================================================

class LayerNextPresets_AMDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 20;
    static const ::Courier::DataItemKey cDataItemKey = 329;

    typedef ::LayerNextPresets_AMData Data;

    LayerNextPresets_AMDataBindingSource();
};

typedef ::Courier::DataItemMsg< LayerNextPresets_AMDataBindingSource > LayerNextPresets_AMDataItemMsg;

// =========================================================================

class LayerNextPresets_DABDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 21;
    static const ::Courier::DataItemKey cDataItemKey = 637;

    typedef ::LayerNextPresets_DABData Data;

    LayerNextPresets_DABDataBindingSource();
};

typedef ::Courier::DataItemMsg< LayerNextPresets_DABDataBindingSource > LayerNextPresets_DABDataItemMsg;

// =========================================================================

class EngineeringInfo1DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 9;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 22;
    static const ::Courier::DataItemKey cDataItemKey = 278;

    typedef ::EngineeringInfo1Data Data;

    EngineeringInfo1DataBindingSource();
};

typedef ::Courier::DataItemMsg< EngineeringInfo1DataBindingSource > EngineeringInfo1DataItemMsg;

// =========================================================================

class EngineeringInfo2DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 16;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 23;
    static const ::Courier::DataItemKey cDataItemKey = 426;

    typedef ::EngineeringInfo2Data Data;

    EngineeringInfo2DataBindingSource();
};

typedef ::Courier::DataItemMsg< EngineeringInfo2DataBindingSource > EngineeringInfo2DataItemMsg;

// =========================================================================

class EngineeringInfoDRMDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 25;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 24;
    static const ::Courier::DataItemKey cDataItemKey = 182;

    typedef ::EngineeringInfoDRMData Data;

    EngineeringInfoDRMDataBindingSource();
};

typedef ::Courier::DataItemMsg< EngineeringInfoDRMDataBindingSource > EngineeringInfoDRMDataItemMsg;

// =========================================================================

class Scan_ASTDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 6;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 25;
    static const ::Courier::DataItemKey cDataItemKey = 127;

    typedef ::Scan_ASTData Data;

    Scan_ASTDataBindingSource();
};

typedef ::Courier::DataItemMsg< Scan_ASTDataBindingSource > Scan_ASTDataItemMsg;

// =========================================================================

class Scan_StatusDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 26;
    static const ::Courier::DataItemKey cDataItemKey = 696;

    typedef ::Scan_StatusData Data;

    Scan_StatusDataBindingSource();
};

typedef ::Courier::DataItemMsg< Scan_StatusDataBindingSource > Scan_StatusDataItemMsg;

// =========================================================================

class Source_SlectionDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 10;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 27;
    static const ::Courier::DataItemKey cDataItemKey = 113;

    typedef ::Source_SlectionData Data;

    Source_SlectionDataBindingSource();
};

typedef ::Courier::DataItemMsg< Source_SlectionDataBindingSource > Source_SlectionDataItemMsg;

// =========================================================================

class Preset_PopupDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 8;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 28;
    static const ::Courier::DataItemKey cDataItemKey = 148;

    typedef ::Preset_PopupData Data;

    Preset_PopupDataBindingSource();
};

typedef ::Courier::DataItemMsg< Preset_PopupDataBindingSource > Preset_PopupDataItemMsg;

// =========================================================================

class PgBar_timerDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 29;
    static const ::Courier::DataItemKey cDataItemKey = 4;

    typedef ::PgBar_timerData Data;

    PgBar_timerDataBindingSource();
};

typedef ::Courier::DataItemMsg< PgBar_timerDataBindingSource > PgBar_timerDataItemMsg;

// =========================================================================

class tuningScale_SliderMarkerPositionDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 30;
    static const ::Courier::DataItemKey cDataItemKey = 503;

    typedef ::tuningScale_SliderMarkerPositionData Data;

    tuningScale_SliderMarkerPositionDataBindingSource();
};

typedef ::Courier::DataItemMsg< tuningScale_SliderMarkerPositionDataBindingSource > tuningScale_SliderMarkerPositionDataItemMsg;

// =========================================================================

class tuningSliderDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 12;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 31;
    static const ::Courier::DataItemKey cDataItemKey = 436;

    typedef ::tuningSliderData Data;

    tuningSliderDataBindingSource();
};

typedef ::Courier::DataItemMsg< tuningSliderDataBindingSource > tuningSliderDataItemMsg;

// =========================================================================

class TunerOptionsDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 11;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 32;
    static const ::Courier::DataItemKey cDataItemKey = 15;

    typedef ::TunerOptionsData Data;

    TunerOptionsDataBindingSource();
};

typedef ::Courier::DataItemMsg< TunerOptionsDataBindingSource > TunerOptionsDataItemMsg;

// =========================================================================

class DABOptionsDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 7;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 33;
    static const ::Courier::DataItemKey cDataItemKey = 334;

    typedef ::DABOptionsData Data;

    DABOptionsDataBindingSource();
};

typedef ::Courier::DataItemMsg< DABOptionsDataBindingSource > DABOptionsDataItemMsg;

// =========================================================================

class DRMOptionsDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 7;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 34;
    static const ::Courier::DataItemKey cDataItemKey = 373;

    typedef ::DRMOptionsData Data;

    DRMOptionsDataBindingSource();
};

typedef ::Courier::DataItemMsg< DRMOptionsDataBindingSource > DRMOptionsDataItemMsg;

// =========================================================================

class MenuSelectionDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 35;
    static const ::Courier::DataItemKey cDataItemKey = 53;

    typedef ::MenuSelectionData Data;

    MenuSelectionDataBindingSource();
};

typedef ::Courier::DataItemMsg< MenuSelectionDataBindingSource > MenuSelectionDataItemMsg;

// =========================================================================

class Menu_NumOptionsDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 36;
    static const ::Courier::DataItemKey cDataItemKey = 445;

    typedef ::Menu_NumOptionsData Data;

    Menu_NumOptionsDataBindingSource();
};

typedef ::Courier::DataItemMsg< Menu_NumOptionsDataBindingSource > Menu_NumOptionsDataItemMsg;

// =========================================================================

class AppFlyInDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 14;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 37;
    static const ::Courier::DataItemKey cDataItemKey = 259;

    typedef ::AppFlyInData Data;

    AppFlyInDataBindingSource();
};

typedef ::Courier::DataItemMsg< AppFlyInDataBindingSource > AppFlyInDataItemMsg;

// =========================================================================

class BrowseListPointerDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 1;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 38;
    static const ::Courier::DataItemKey cDataItemKey = 99;

    typedef ::BrowseListPointerData Data;

    BrowseListPointerDataBindingSource();
};

typedef ::Courier::DataItemMsg< BrowseListPointerDataBindingSource > BrowseListPointerDataItemMsg;

// =========================================================================

class BrowseListSizeDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 11;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 39;
    static const ::Courier::DataItemKey cDataItemKey = 390;

    typedef ::BrowseListSizeData Data;

    BrowseListSizeDataBindingSource();
};

typedef ::Courier::DataItemMsg< BrowseListSizeDataBindingSource > BrowseListSizeDataItemMsg;

// =========================================================================

class BrowseListSelectedLineDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 6;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 40;
    static const ::Courier::DataItemKey cDataItemKey = 202;

    typedef ::BrowseListSelectedLineData Data;

    BrowseListSelectedLineDataBindingSource();
};

typedef ::Courier::DataItemMsg< BrowseListSelectedLineDataBindingSource > BrowseListSelectedLineDataItemMsg;

// =========================================================================

class DABChannelInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 7;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 41;
    static const ::Courier::DataItemKey cDataItemKey = 299;

    typedef ::DABChannelInfoData Data;

    DABChannelInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< DABChannelInfoDataBindingSource > DABChannelInfoDataItemMsg;

// =========================================================================

class ActiveBankInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 10;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 42;
    static const ::Courier::DataItemKey cDataItemKey = 236;

    typedef ::ActiveBankInfoData Data;

    ActiveBankInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< ActiveBankInfoDataBindingSource > ActiveBankInfoDataItemMsg;

// =========================================================================

class ActiveSourceInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 43;
    static const ::Courier::DataItemKey cDataItemKey = 195;

    typedef ::ActiveSourceInfoData Data;

    ActiveSourceInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< ActiveSourceInfoDataBindingSource > ActiveSourceInfoDataItemMsg;

// =========================================================================

class VariantInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 9;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 44;
    static const ::Courier::DataItemKey cDataItemKey = 48;

    typedef ::VariantInfoData Data;

    VariantInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< VariantInfoDataBindingSource > VariantInfoDataItemMsg;

// =========================================================================

class TAInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 45;
    static const ::Courier::DataItemKey cDataItemKey = 322;

    typedef ::TAInfoData Data;

    TAInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< TAInfoDataBindingSource > TAInfoDataItemMsg;

// =========================================================================

class DABPresetInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 13;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 46;
    static const ::Courier::DataItemKey cDataItemKey = 485;

    typedef ::DABPresetInfoData Data;

    DABPresetInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< DABPresetInfoDataBindingSource > DABPresetInfoDataItemMsg;

// =========================================================================

class FMAMPresetInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 13;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 47;
    static const ::Courier::DataItemKey cDataItemKey = 690;

    typedef ::FMAMPresetInfoData Data;

    FMAMPresetInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< FMAMPresetInfoDataBindingSource > FMAMPresetInfoDataItemMsg;

// =========================================================================

class AMPresetInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 13;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 48;
    static const ::Courier::DataItemKey cDataItemKey = 372;

    typedef ::AMPresetInfoData Data;

    AMPresetInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< AMPresetInfoDataBindingSource > AMPresetInfoDataItemMsg;

// =========================================================================

class Tuner1DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 15;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 49;
    static const ::Courier::DataItemKey cDataItemKey = 395;

    typedef ::Tuner1Data Data;

    Tuner1DataBindingSource();
};

typedef ::Courier::DataItemMsg< Tuner1DataBindingSource > Tuner1DataItemMsg;

// =========================================================================

class Tuner2DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 15;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 50;
    static const ::Courier::DataItemKey cDataItemKey = 293;

    typedef ::Tuner2Data Data;

    Tuner2DataBindingSource();
};

typedef ::Courier::DataItemMsg< Tuner2DataBindingSource > Tuner2DataItemMsg;

// =========================================================================

class Tuner3DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 15;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 51;
    static const ::Courier::DataItemKey cDataItemKey = 342;

    typedef ::Tuner3Data Data;

    Tuner3DataBindingSource();
};

typedef ::Courier::DataItemMsg< Tuner3DataBindingSource > Tuner3DataItemMsg;

// =========================================================================

class Tuner4DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 15;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 52;
    static const ::Courier::DataItemKey cDataItemKey = 670;

    typedef ::Tuner4Data Data;

    Tuner4DataBindingSource();
};

typedef ::Courier::DataItemMsg< Tuner4DataBindingSource > Tuner4DataItemMsg;

// =========================================================================

class TunerSource_BandDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 13;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 53;
    static const ::Courier::DataItemKey cDataItemKey = 197;

    typedef ::TunerSource_BandData Data;

    TunerSource_BandDataBindingSource();
};

typedef ::Courier::DataItemMsg< TunerSource_BandDataBindingSource > TunerSource_BandDataItemMsg;

// =========================================================================

class DAB_Setup_ScreenDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 54;
    static const ::Courier::DataItemKey cDataItemKey = 477;

    typedef ::DAB_Setup_ScreenData Data;

    DAB_Setup_ScreenDataBindingSource();
};

typedef ::Courier::DataItemMsg< DAB_Setup_ScreenDataBindingSource > DAB_Setup_ScreenDataItemMsg;

// =========================================================================

class DAB_Test_ModeDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 25;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 55;
    static const ::Courier::DataItemKey cDataItemKey = 225;

    typedef ::DAB_Test_ModeData Data;

    DAB_Test_ModeDataBindingSource();
};

typedef ::Courier::DataItemMsg< DAB_Test_ModeDataBindingSource > DAB_Test_ModeDataItemMsg;

// =========================================================================

class DAB_Setup_Screen_ActiveTuner_InfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 6;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 56;
    static const ::Courier::DataItemKey cDataItemKey = 241;

    typedef ::DAB_Setup_Screen_ActiveTuner_InfoData Data;

    DAB_Setup_Screen_ActiveTuner_InfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< DAB_Setup_Screen_ActiveTuner_InfoDataBindingSource > DAB_Setup_Screen_ActiveTuner_InfoDataItemMsg;

// =========================================================================

class DABTestModeEnsembleInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 57;
    static const ::Courier::DataItemKey cDataItemKey = 539;

    typedef ::DABTestModeEnsembleInfoData Data;

    DABTestModeEnsembleInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< DABTestModeEnsembleInfoDataBindingSource > DABTestModeEnsembleInfoDataItemMsg;

// =========================================================================

class DABGTestModeInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 5;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 58;
    static const ::Courier::DataItemKey cDataItemKey = 556;

    typedef ::DABGTestModeInfoData Data;

    DABGTestModeInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< DABGTestModeInfoDataBindingSource > DABGTestModeInfoDataItemMsg;

// =========================================================================

class DABGTestModeAnnoStatusInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 59;
    static const ::Courier::DataItemKey cDataItemKey = 640;

    typedef ::DABGTestModeAnnoStatusInfoData Data;

    DABGTestModeAnnoStatusInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< DABGTestModeAnnoStatusInfoDataBindingSource > DABGTestModeAnnoStatusInfoDataItemMsg;

// =========================================================================

class DABGTestModeActiveCompDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 60;
    static const ::Courier::DataItemKey cDataItemKey = 560;

    typedef ::DABGTestModeActiveCompData Data;

    DABGTestModeActiveCompDataBindingSource();
};

typedef ::Courier::DataItemMsg< DABGTestModeActiveCompDataBindingSource > DABGTestModeActiveCompDataItemMsg;

// =========================================================================

class DABTestModeGAvailabiltyInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 61;
    static const ::Courier::DataItemKey cDataItemKey = 555;

    typedef ::DABTestModeGAvailabiltyInfoData Data;

    DABTestModeGAvailabiltyInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< DABTestModeGAvailabiltyInfoDataBindingSource > DABTestModeGAvailabiltyInfoDataItemMsg;

// =========================================================================

class DABTestModeServiceFollowingInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 62;
    static const ::Courier::DataItemKey cDataItemKey = 458;

    typedef ::DABTestModeServiceFollowingInfoData Data;

    DABTestModeServiceFollowingInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< DABTestModeServiceFollowingInfoDataBindingSource > DABTestModeServiceFollowingInfoDataItemMsg;

// =========================================================================

class TmcInformationDataDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 63;
    static const ::Courier::DataItemKey cDataItemKey = 379;

    typedef ::TmcInformationDataData Data;

    TmcInformationDataDataBindingSource();
};

typedef ::Courier::DataItemMsg< TmcInformationDataDataBindingSource > TmcInformationDataDataItemMsg;

// =========================================================================

class TmcStationInfoDataDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 7;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 64;
    static const ::Courier::DataItemKey cDataItemKey = 375;

    typedef ::TmcStationInfoDataData Data;

    TmcStationInfoDataDataBindingSource();
};

typedef ::Courier::DataItemMsg< TmcStationInfoDataDataBindingSource > TmcStationInfoDataDataItemMsg;

// =========================================================================

class TestModeAvailabilityInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 65;
    static const ::Courier::DataItemKey cDataItemKey = 561;

    typedef ::TestModeAvailabilityInfoData Data;

    TestModeAvailabilityInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< TestModeAvailabilityInfoDataBindingSource > TestModeAvailabilityInfoDataItemMsg;

// =========================================================================

class FMSetupMenuInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 6;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 66;
    static const ::Courier::DataItemKey cDataItemKey = 219;

    typedef ::FMSetupMenuInfoData Data;

    FMSetupMenuInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< FMSetupMenuInfoDataBindingSource > FMSetupMenuInfoDataItemMsg;

// =========================================================================

class NextPrevious_Status_FMDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 67;
    static const ::Courier::DataItemKey cDataItemKey = 409;

    typedef ::NextPrevious_Status_FMData Data;

    NextPrevious_Status_FMDataBindingSource();
};

typedef ::Courier::DataItemMsg< NextPrevious_Status_FMDataBindingSource > NextPrevious_Status_FMDataItemMsg;

// =========================================================================

class NextPrevious_Status_AMDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 68;
    static const ::Courier::DataItemKey cDataItemKey = 454;

    typedef ::NextPrevious_Status_AMData Data;

    NextPrevious_Status_AMDataBindingSource();
};

typedef ::Courier::DataItemMsg< NextPrevious_Status_AMDataBindingSource > NextPrevious_Status_AMDataItemMsg;

// =========================================================================

class NextPrevious_Status_DABDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 69;
    static const ::Courier::DataItemKey cDataItemKey = 111;

    typedef ::NextPrevious_Status_DABData Data;

    NextPrevious_Status_DABDataBindingSource();
};

typedef ::Courier::DataItemMsg< NextPrevious_Status_DABDataBindingSource > NextPrevious_Status_DABDataItemMsg;

// =========================================================================

class SearchNextPrevious_IconActiveDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 70;
    static const ::Courier::DataItemKey cDataItemKey = 412;

    typedef ::SearchNextPrevious_IconActiveData Data;

    SearchNextPrevious_IconActiveDataBindingSource();
};

typedef ::Courier::DataItemMsg< SearchNextPrevious_IconActiveDataBindingSource > SearchNextPrevious_IconActiveDataItemMsg;

// =========================================================================

class AMFMLogoImageDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 71;
    static const ::Courier::DataItemKey cDataItemKey = 542;

    typedef ::AMFMLogoImageData Data;

    AMFMLogoImageDataBindingSource();
};

typedef ::Courier::DataItemMsg< AMFMLogoImageDataBindingSource > AMFMLogoImageDataItemMsg;

// =========================================================================

class ChannelInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 8;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 72;
    static const ::Courier::DataItemKey cDataItemKey = 30;

    typedef ::ChannelInfoData Data;

    ChannelInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< ChannelInfoDataBindingSource > ChannelInfoDataItemMsg;

// =========================================================================

class FmHdLogoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 73;
    static const ::Courier::DataItemKey cDataItemKey = 692;

    typedef ::FmHdLogoData Data;

    FmHdLogoDataBindingSource();
};

typedef ::Courier::DataItemMsg< FmHdLogoDataBindingSource > FmHdLogoDataItemMsg;

// =========================================================================

class AmHdLogoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 74;
    static const ::Courier::DataItemKey cDataItemKey = 235;

    typedef ::AmHdLogoData Data;

    AmHdLogoDataBindingSource();
};

typedef ::Courier::DataItemMsg< AmHdLogoDataBindingSource > AmHdLogoDataItemMsg;

// =========================================================================

class HDButtonVisibilityDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 75;
    static const ::Courier::DataItemKey cDataItemKey = 343;

    typedef ::HDButtonVisibilityData Data;

    HDButtonVisibilityDataBindingSource();
};

typedef ::Courier::DataItemMsg< HDButtonVisibilityDataBindingSource > HDButtonVisibilityDataItemMsg;

// =========================================================================

class AmHdOnOffDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 76;
    static const ::Courier::DataItemKey cDataItemKey = 37;

    typedef ::AmHdOnOffData Data;

    AmHdOnOffDataBindingSource();
};

typedef ::Courier::DataItemMsg< AmHdOnOffDataBindingSource > AmHdOnOffDataItemMsg;

// =========================================================================

class FmHdOnOffDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 77;
    static const ::Courier::DataItemKey cDataItemKey = 425;

    typedef ::FmHdOnOffData Data;

    FmHdOnOffDataBindingSource();
};

typedef ::Courier::DataItemMsg< FmHdOnOffDataBindingSource > FmHdOnOffDataItemMsg;

// =========================================================================

class HDProgramListVisibilityDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 78;
    static const ::Courier::DataItemKey cDataItemKey = 585;

    typedef ::HDProgramListVisibilityData Data;

    HDProgramListVisibilityDataBindingSource();
};

typedef ::Courier::DataItemMsg< HDProgramListVisibilityDataBindingSource > HDProgramListVisibilityDataItemMsg;

// =========================================================================

class HDAudioMPSDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 79;
    static const ::Courier::DataItemKey cDataItemKey = 46;

    typedef ::HDAudioMPSData Data;

    HDAudioMPSDataBindingSource();
};

typedef ::Courier::DataItemMsg< HDAudioMPSDataBindingSource > HDAudioMPSDataItemMsg;

// =========================================================================

class HDAudioSPS1DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 80;
    static const ::Courier::DataItemKey cDataItemKey = 163;

    typedef ::HDAudioSPS1Data Data;

    HDAudioSPS1DataBindingSource();
};

typedef ::Courier::DataItemMsg< HDAudioSPS1DataBindingSource > HDAudioSPS1DataItemMsg;

// =========================================================================

class HDAudioSPS2DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 81;
    static const ::Courier::DataItemKey cDataItemKey = 199;

    typedef ::HDAudioSPS2Data Data;

    HDAudioSPS2DataBindingSource();
};

typedef ::Courier::DataItemMsg< HDAudioSPS2DataBindingSource > HDAudioSPS2DataItemMsg;

// =========================================================================

class HDAudioSPS3DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 82;
    static const ::Courier::DataItemKey cDataItemKey = 247;

    typedef ::HDAudioSPS3Data Data;

    HDAudioSPS3DataBindingSource();
};

typedef ::Courier::DataItemMsg< HDAudioSPS3DataBindingSource > HDAudioSPS3DataItemMsg;

// =========================================================================

class HDAudioSPS4DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 83;
    static const ::Courier::DataItemKey cDataItemKey = 304;

    typedef ::HDAudioSPS4Data Data;

    HDAudioSPS4DataBindingSource();
};

typedef ::Courier::DataItemMsg< HDAudioSPS4DataBindingSource > HDAudioSPS4DataItemMsg;

// =========================================================================

class HDAudioSPS5DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 84;
    static const ::Courier::DataItemKey cDataItemKey = 355;

    typedef ::HDAudioSPS5Data Data;

    HDAudioSPS5DataBindingSource();
};

typedef ::Courier::DataItemMsg< HDAudioSPS5DataBindingSource > HDAudioSPS5DataItemMsg;

// =========================================================================

class HDAudioSPS6DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 85;
    static const ::Courier::DataItemKey cDataItemKey = 376;

    typedef ::HDAudioSPS6Data Data;

    HDAudioSPS6DataBindingSource();
};

typedef ::Courier::DataItemMsg< HDAudioSPS6DataBindingSource > HDAudioSPS6DataItemMsg;

// =========================================================================

class HDAudioSPS7DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 86;
    static const ::Courier::DataItemKey cDataItemKey = 433;

    typedef ::HDAudioSPS7Data Data;

    HDAudioSPS7DataBindingSource();
};

typedef ::Courier::DataItemMsg< HDAudioSPS7DataBindingSource > HDAudioSPS7DataItemMsg;

// =========================================================================

class HDIconPreset1DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 87;
    static const ::Courier::DataItemKey cDataItemKey = 501;

    typedef ::HDIconPreset1Data Data;

    HDIconPreset1DataBindingSource();
};

typedef ::Courier::DataItemMsg< HDIconPreset1DataBindingSource > HDIconPreset1DataItemMsg;

// =========================================================================

class HDIconPreset2DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 88;
    static const ::Courier::DataItemKey cDataItemKey = 580;

    typedef ::HDIconPreset2Data Data;

    HDIconPreset2DataBindingSource();
};

typedef ::Courier::DataItemMsg< HDIconPreset2DataBindingSource > HDIconPreset2DataItemMsg;

// =========================================================================

class HDIconPreset3DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 89;
    static const ::Courier::DataItemKey cDataItemKey = 612;

    typedef ::HDIconPreset3Data Data;

    HDIconPreset3DataBindingSource();
};

typedef ::Courier::DataItemMsg< HDIconPreset3DataBindingSource > HDIconPreset3DataItemMsg;

// =========================================================================

class HDIconPreset4DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 90;
    static const ::Courier::DataItemKey cDataItemKey = 647;

    typedef ::HDIconPreset4Data Data;

    HDIconPreset4DataBindingSource();
};

typedef ::Courier::DataItemMsg< HDIconPreset4DataBindingSource > HDIconPreset4DataItemMsg;

// =========================================================================

class HDIconPreset5DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 91;
    static const ::Courier::DataItemKey cDataItemKey = 650;

    typedef ::HDIconPreset5Data Data;

    HDIconPreset5DataBindingSource();
};

typedef ::Courier::DataItemMsg< HDIconPreset5DataBindingSource > HDIconPreset5DataItemMsg;

// =========================================================================

class HDIconPreset6DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 92;
    static const ::Courier::DataItemKey cDataItemKey = 609;

    typedef ::HDIconPreset6Data Data;

    HDIconPreset6DataBindingSource();
};

typedef ::Courier::DataItemMsg< HDIconPreset6DataBindingSource > HDIconPreset6DataItemMsg;

// =========================================================================

class HDIconPreset7DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 93;
    static const ::Courier::DataItemKey cDataItemKey = 101;

    typedef ::HDIconPreset7Data Data;

    HDIconPreset7DataBindingSource();
};

typedef ::Courier::DataItemMsg< HDIconPreset7DataBindingSource > HDIconPreset7DataItemMsg;

// =========================================================================

class HDIconPreset8DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 94;
    static const ::Courier::DataItemKey cDataItemKey = 702;

    typedef ::HDIconPreset8Data Data;

    HDIconPreset8DataBindingSource();
};

typedef ::Courier::DataItemMsg< HDIconPreset8DataBindingSource > HDIconPreset8DataItemMsg;

// =========================================================================

class HDIconPreset9DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 95;
    static const ::Courier::DataItemKey cDataItemKey = 512;

    typedef ::HDIconPreset9Data Data;

    HDIconPreset9DataBindingSource();
};

typedef ::Courier::DataItemMsg< HDIconPreset9DataBindingSource > HDIconPreset9DataItemMsg;

// =========================================================================

class HDIconPreset10DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 96;
    static const ::Courier::DataItemKey cDataItemKey = 220;

    typedef ::HDIconPreset10Data Data;

    HDIconPreset10DataBindingSource();
};

typedef ::Courier::DataItemMsg< HDIconPreset10DataBindingSource > HDIconPreset10DataItemMsg;

// =========================================================================

class HDIconPreset11DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 97;
    static const ::Courier::DataItemKey cDataItemKey = 548;

    typedef ::HDIconPreset11Data Data;

    HDIconPreset11DataBindingSource();
};

typedef ::Courier::DataItemMsg< HDIconPreset11DataBindingSource > HDIconPreset11DataItemMsg;

// =========================================================================

class HDIconPreset12DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 98;
    static const ::Courier::DataItemKey cDataItemKey = 675;

    typedef ::HDIconPreset12Data Data;

    HDIconPreset12DataBindingSource();
};

typedef ::Courier::DataItemMsg< HDIconPreset12DataBindingSource > HDIconPreset12DataItemMsg;

// =========================================================================

class DtmHDDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 14;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 99;
    static const ::Courier::DataItemKey cDataItemKey = 660;

    typedef ::DtmHDData Data;

    DtmHDDataBindingSource();
};

typedef ::Courier::DataItemMsg< DtmHDDataBindingSource > DtmHDDataItemMsg;

// =========================================================================

class HDParamTuningIconDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 100;
    static const ::Courier::DataItemKey cDataItemKey = 296;

    typedef ::HDParamTuningIconData Data;

    HDParamTuningIconDataBindingSource();
};

typedef ::Courier::DataItemMsg< HDParamTuningIconDataBindingSource > HDParamTuningIconDataItemMsg;

// =========================================================================

class TMHDAudioMPSDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 101;
    static const ::Courier::DataItemKey cDataItemKey = 190;

    typedef ::TMHDAudioMPSData Data;

    TMHDAudioMPSDataBindingSource();
};

typedef ::Courier::DataItemMsg< TMHDAudioMPSDataBindingSource > TMHDAudioMPSDataItemMsg;

// =========================================================================

class TMHDAudioSPS1DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 102;
    static const ::Courier::DataItemKey cDataItemKey = 184;

    typedef ::TMHDAudioSPS1Data Data;

    TMHDAudioSPS1DataBindingSource();
};

typedef ::Courier::DataItemMsg< TMHDAudioSPS1DataBindingSource > TMHDAudioSPS1DataItemMsg;

// =========================================================================

class TMHDAudioSPS2DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 103;
    static const ::Courier::DataItemKey cDataItemKey = 619;

    typedef ::TMHDAudioSPS2Data Data;

    TMHDAudioSPS2DataBindingSource();
};

typedef ::Courier::DataItemMsg< TMHDAudioSPS2DataBindingSource > TMHDAudioSPS2DataItemMsg;

// =========================================================================

class TMHDAudioSPS3DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 104;
    static const ::Courier::DataItemKey cDataItemKey = 573;

    typedef ::TMHDAudioSPS3Data Data;

    TMHDAudioSPS3DataBindingSource();
};

typedef ::Courier::DataItemMsg< TMHDAudioSPS3DataBindingSource > TMHDAudioSPS3DataItemMsg;

// =========================================================================

class TMHDAudioSPS4DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 105;
    static const ::Courier::DataItemKey cDataItemKey = 680;

    typedef ::TMHDAudioSPS4Data Data;

    TMHDAudioSPS4DataBindingSource();
};

typedef ::Courier::DataItemMsg< TMHDAudioSPS4DataBindingSource > TMHDAudioSPS4DataItemMsg;

// =========================================================================

class TMHDAudioSPS5DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 106;
    static const ::Courier::DataItemKey cDataItemKey = 632;

    typedef ::TMHDAudioSPS5Data Data;

    TMHDAudioSPS5DataBindingSource();
};

typedef ::Courier::DataItemMsg< TMHDAudioSPS5DataBindingSource > TMHDAudioSPS5DataItemMsg;

// =========================================================================

class TMHDAudioSPS6DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 107;
    static const ::Courier::DataItemKey cDataItemKey = 438;

    typedef ::TMHDAudioSPS6Data Data;

    TMHDAudioSPS6DataBindingSource();
};

typedef ::Courier::DataItemMsg< TMHDAudioSPS6DataBindingSource > TMHDAudioSPS6DataItemMsg;

// =========================================================================

class TMHDAudioSPS7DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 108;
    static const ::Courier::DataItemKey cDataItemKey = 26;

    typedef ::TMHDAudioSPS7Data Data;

    TMHDAudioSPS7DataBindingSource();
};

typedef ::Courier::DataItemMsg< TMHDAudioSPS7DataBindingSource > TMHDAudioSPS7DataItemMsg;

// =========================================================================

class RdsRadioTextDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 109;
    static const ::Courier::DataItemKey cDataItemKey = 289;

    typedef ::RdsRadioTextData Data;

    RdsRadioTextDataBindingSource();
};

typedef ::Courier::DataItemMsg< RdsRadioTextDataBindingSource > RdsRadioTextDataItemMsg;

// =========================================================================

class HomeScreenFmHdLogoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 110;
    static const ::Courier::DataItemKey cDataItemKey = 605;

    typedef ::HomeScreenFmHdLogoData Data;

    HomeScreenFmHdLogoDataBindingSource();
};

typedef ::Courier::DataItemMsg< HomeScreenFmHdLogoDataBindingSource > HomeScreenFmHdLogoDataItemMsg;

// =========================================================================

class HomeScreenAmHdLogoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 111;
    static const ::Courier::DataItemKey cDataItemKey = 599;

    typedef ::HomeScreenAmHdLogoData Data;

    HomeScreenAmHdLogoDataBindingSource();
};

typedef ::Courier::DataItemMsg< HomeScreenAmHdLogoDataBindingSource > HomeScreenAmHdLogoDataItemMsg;

// =========================================================================

class SPIVisibilityTunerDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 112;
    static const ::Courier::DataItemKey cDataItemKey = 274;

    typedef ::SPIVisibilityTunerData Data;

    SPIVisibilityTunerDataBindingSource();
};

typedef ::Courier::DataItemMsg< SPIVisibilityTunerDataBindingSource > SPIVisibilityTunerDataItemMsg;

// =========================================================================

class ListScrollBarInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 113;
    static const ::Courier::DataItemKey cDataItemKey = 210;

    typedef ::ListScrollBarInfoData Data;

    ListScrollBarInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< ListScrollBarInfoDataBindingSource > ListScrollBarInfoDataItemMsg;

namespace ItemKey {
        static const ::Courier::DataItemKey InvalidItem = 0;
        static const ::Courier::DataItemKey PgBar_timerItem = 4;
        static const ::Courier::DataItemKey TunerOptionsItem = 15;
        static const ::Courier::DataItemKey TMHDAudioSPS7Item = 26;
        static const ::Courier::DataItemKey ChannelInfoItem = 30;
        static const ::Courier::DataItemKey AmHdOnOffItem = 37;
        static const ::Courier::DataItemKey FMStationListItem = 41;
        static const ::Courier::DataItemKey PresetInfoDABASTItem = 43;
        static const ::Courier::DataItemKey HDAudioMPSItem = 46;
        static const ::Courier::DataItemKey VariantInfoItem = 48;
        static const ::Courier::DataItemKey MenuSelectionItem = 53;
        static const ::Courier::DataItemKey PresetInfoWBItem = 60;
        static const ::Courier::DataItemKey BrowseListPointerItem = 99;
        static const ::Courier::DataItemKey HDIconPreset7Item = 101;
        static const ::Courier::DataItemKey PresetInfoDRMItem = 109;
        static const ::Courier::DataItemKey NextPrevious_Status_DABItem = 111;
        static const ::Courier::DataItemKey Source_SlectionItem = 113;
        static const ::Courier::DataItemKey Scan_ASTItem = 127;
        static const ::Courier::DataItemKey Preset_PopupItem = 148;
        static const ::Courier::DataItemKey HDAudioSPS1Item = 163;
        static const ::Courier::DataItemKey EngineeringInfoDRMItem = 182;
        static const ::Courier::DataItemKey TMHDAudioSPS1Item = 184;
        static const ::Courier::DataItemKey RadioBandInfoItem = 188;
        static const ::Courier::DataItemKey TMHDAudioMPSItem = 190;
        static const ::Courier::DataItemKey ActiveSourceInfoItem = 195;
        static const ::Courier::DataItemKey TunerSource_BandItem = 197;
        static const ::Courier::DataItemKey HDAudioSPS2Item = 199;
        static const ::Courier::DataItemKey BrowseListSelectedLineItem = 202;
        static const ::Courier::DataItemKey ListScrollBarInfoItem = 210;
        static const ::Courier::DataItemKey FMSetupMenuInfoItem = 219;
        static const ::Courier::DataItemKey HDIconPreset10Item = 220;
        static const ::Courier::DataItemKey DAB_Test_ModeItem = 225;
        static const ::Courier::DataItemKey AmHdLogoItem = 235;
        static const ::Courier::DataItemKey ActiveBankInfoItem = 236;
        static const ::Courier::DataItemKey DAB_Setup_Screen_ActiveTuner_InfoItem = 241;
        static const ::Courier::DataItemKey HDAudioSPS3Item = 247;
        static const ::Courier::DataItemKey AppFlyInItem = 259;
        static const ::Courier::DataItemKey SPIVisibilityTunerItem = 274;
        static const ::Courier::DataItemKey EngineeringInfo1Item = 278;
        static const ::Courier::DataItemKey RdsRadioTextItem = 289;
        static const ::Courier::DataItemKey Tuner2Item = 293;
        static const ::Courier::DataItemKey HDParamTuningIconItem = 296;
        static const ::Courier::DataItemKey DABChannelInfoItem = 299;
        static const ::Courier::DataItemKey HDAudioSPS4Item = 304;
        static const ::Courier::DataItemKey TAInfoItem = 322;
        static const ::Courier::DataItemKey LayerNextPresets_AMItem = 329;
        static const ::Courier::DataItemKey DABOptionsItem = 334;
        static const ::Courier::DataItemKey Tuner3Item = 342;
        static const ::Courier::DataItemKey HDButtonVisibilityItem = 343;
        static const ::Courier::DataItemKey HDAudioSPS5Item = 355;
        static const ::Courier::DataItemKey WBPresetInfoItem = 360;
        static const ::Courier::DataItemKey AMPresetInfoItem = 372;
        static const ::Courier::DataItemKey DRMOptionsItem = 373;
        static const ::Courier::DataItemKey TmcStationInfoDataItem = 375;
        static const ::Courier::DataItemKey HDAudioSPS6Item = 376;
        static const ::Courier::DataItemKey TmcInformationDataItem = 379;
        static const ::Courier::DataItemKey BrowseListSizeItem = 390;
        static const ::Courier::DataItemKey Tuner1Item = 395;
        static const ::Courier::DataItemKey PresetInfoDRMASTItem = 396;
        static const ::Courier::DataItemKey NextPrevious_Status_FMItem = 409;
        static const ::Courier::DataItemKey SearchNextPrevious_IconActiveItem = 412;
        static const ::Courier::DataItemKey FmHdOnOffItem = 425;
        static const ::Courier::DataItemKey EngineeringInfo2Item = 426;
        static const ::Courier::DataItemKey HDAudioSPS7Item = 433;
        static const ::Courier::DataItemKey tuningSliderItem = 436;
        static const ::Courier::DataItemKey TMHDAudioSPS6Item = 438;
        static const ::Courier::DataItemKey Menu_NumOptionsItem = 445;
        static const ::Courier::DataItemKey PresetInfoAMItem = 449;
        static const ::Courier::DataItemKey NextPrevious_Status_AMItem = 454;
        static const ::Courier::DataItemKey PresetInfoDABItem = 456;
        static const ::Courier::DataItemKey DABTestModeServiceFollowingInfoItem = 458;
        static const ::Courier::DataItemKey RDSOptionsItem = 474;
        static const ::Courier::DataItemKey DAB_Setup_ScreenItem = 477;
        static const ::Courier::DataItemKey DABPresetInfoItem = 485;
        static const ::Courier::DataItemKey StationInfoSourceItem = 486;
        static const ::Courier::DataItemKey HDIconPreset1Item = 501;
        static const ::Courier::DataItemKey tuningScale_SliderMarkerPositionItem = 503;
        static const ::Courier::DataItemKey HDIconPreset9Item = 512;
        static const ::Courier::DataItemKey EngineeringInfoItem = 535;
        static const ::Courier::DataItemKey DABTestModeEnsembleInfoItem = 539;
        static const ::Courier::DataItemKey AMFMLogoImageItem = 542;
        static const ::Courier::DataItemKey HDIconPreset11Item = 548;
        static const ::Courier::DataItemKey PresetInfoFMASTItem = 553;
        static const ::Courier::DataItemKey DABTestModeGAvailabiltyInfoItem = 555;
        static const ::Courier::DataItemKey DABGTestModeInfoItem = 556;
        static const ::Courier::DataItemKey DABGTestModeActiveCompItem = 560;
        static const ::Courier::DataItemKey TestModeAvailabilityInfoItem = 561;
        static const ::Courier::DataItemKey PresetInfoFM1Item = 565;
        static const ::Courier::DataItemKey TMHDAudioSPS3Item = 573;
        static const ::Courier::DataItemKey HDIconPreset2Item = 580;
        static const ::Courier::DataItemKey HDProgramListVisibilityItem = 585;
        static const ::Courier::DataItemKey CheckBoxListItemItem = 588;
        static const ::Courier::DataItemKey HomeScreenAmHdLogoItem = 599;
        static const ::Courier::DataItemKey HomeScreenInfoItem = 600;
        static const ::Courier::DataItemKey PresetInfoFM2Item = 604;
        static const ::Courier::DataItemKey HomeScreenFmHdLogoItem = 605;
        static const ::Courier::DataItemKey HDIconPreset6Item = 609;
        static const ::Courier::DataItemKey HDIconPreset3Item = 612;
        static const ::Courier::DataItemKey TMHDAudioSPS2Item = 619;
        static const ::Courier::DataItemKey TMHDAudioSPS5Item = 632;
        static const ::Courier::DataItemKey LayerNextPresets_DABItem = 637;
        static const ::Courier::DataItemKey DABGTestModeAnnoStatusInfoItem = 640;
        static const ::Courier::DataItemKey LayerNextPresets_FMItem = 641;
        static const ::Courier::DataItemKey HDIconPreset4Item = 647;
        static const ::Courier::DataItemKey HDIconPreset5Item = 650;
        static const ::Courier::DataItemKey DtmHDItem = 660;
        static const ::Courier::DataItemKey PresetInfoAMASTItem = 662;
        static const ::Courier::DataItemKey Tuner4Item = 670;
        static const ::Courier::DataItemKey HDIconPreset12Item = 675;
        static const ::Courier::DataItemKey TMHDAudioSPS4Item = 680;
        static const ::Courier::DataItemKey FMAMPresetInfoItem = 690;
        static const ::Courier::DataItemKey FmHdLogoItem = 692;
        static const ::Courier::DataItemKey Scan_StatusItem = 696;
        static const ::Courier::DataItemKey HDIconPreset8Item = 702;

    namespace PgBar_timer {
            static const ::Courier::DataItemKey TimerValueItem = 566;
            static const ::Courier::DataItemKey NoOfStepsItem = 367;
            static const ::Courier::DataItemKey TimerStartItem = 115;
    } // namespace PgBar_timer

    namespace TunerOptions {
            static const ::Courier::DataItemKey isChecked_TAItem = 144;
            static const ::Courier::DataItemKey isChecked_RadioTxtItem = 134;
            static const ::Courier::DataItemKey isChecked_RDSRegPgmItem = 657;
            static const ::Courier::DataItemKey isChecked_AltFreqItem = 671;
            static const ::Courier::DataItemKey isChecked_DAB_DynamicContentItem = 24;
            static const ::Courier::DataItemKey isChecked_DAB_FM_FollowingItem = 408;
            static const ::Courier::DataItemKey isChecked_DAB_DAB_LinkingItem = 526;
            static const ::Courier::DataItemKey isChecked_DRM_DynamicContentItem = 383;
            static const ::Courier::DataItemKey isChecked_DRMFrequencyItem = 166;
            static const ::Courier::DataItemKey isChecked_DRMAFSEARCHItem = 583;
    } // namespace TunerOptions

    namespace TMHDAudioSPS7 {
            static const ::Courier::DataItemKey TMHD_Prog_SPS7_switchItem = 359;
            static const ::Courier::DataItemKey TMHD_Prog_SPS7_availableItem = 253;
    } // namespace TMHDAudioSPS7

    namespace ChannelInfo {
            static const ::Courier::DataItemKey AdvisoryTextItem = 191;
            static const ::Courier::DataItemKey ArtistItem = 465;
            static const ::Courier::DataItemKey AlbumItem = 287;
            static const ::Courier::DataItemKey TrackItem = 597;
            static const ::Courier::DataItemKey ArtistAlbumSwitchItem = 173;
            static const ::Courier::DataItemKey IsBallGameModeVisibleItem = 86;
            static const ::Courier::DataItemKey CategoryItem = 428;
    } // namespace ChannelInfo

    namespace AmHdOnOff {
            static const ::Courier::DataItemKey IsActiveItem = 422;
    } // namespace AmHdOnOff

    namespace FMStationList {
            static const ::Courier::DataItemKey presetnumberItem = 362;
            static const ::Courier::DataItemKey station_nameItem = 186;
            static const ::Courier::DataItemKey Traffic_programItem = 68;
    } // namespace FMStationList

    namespace PresetInfoDABAST {
            static const ::Courier::DataItemKey PSName1Item = 346;
            static const ::Courier::DataItemKey PSName2Item = 306;
            static const ::Courier::DataItemKey PSName3Item = 272;
            static const ::Courier::DataItemKey PSName4Item = 616;
            static const ::Courier::DataItemKey PSName5Item = 569;
            static const ::Courier::DataItemKey PSName6Item = 510;
    } // namespace PresetInfoDABAST

    namespace HDAudioMPS {
            static const ::Courier::DataItemKey HD_Prog_MPS_switchItem = 245;
            static const ::Courier::DataItemKey HD_Prog_MPS_sizeItem = 262;
    } // namespace HDAudioMPS

    namespace VariantInfo {
            static const ::Courier::DataItemKey DAB_AvailableItem = 160;
            static const ::Courier::DataItemKey WX_AvailableItem = 286;
            static const ::Courier::DataItemKey Dest_Reg_DRMItem = 455;
            static const ::Courier::DataItemKey DAB_MountedItem = 504;
            static const ::Courier::DataItemKey HD_AvailableItem = 85;
            static const ::Courier::DataItemKey AM_ActivationItem = 480;
            static const ::Courier::DataItemKey FM_ActivationItem = 587;
            static const ::Courier::DataItemKey SXM_MountedItem = 12;
    } // namespace VariantInfo

    namespace MenuSelection {
            static const ::Courier::DataItemKey MainMenu_SelectionItem = 35;
            static const ::Courier::DataItemKey DABPTYOption_SelectionItem = 633;
            static const ::Courier::DataItemKey DRMPTYOption_SelectionItem = 217;
    } // namespace MenuSelection

    namespace PresetInfoWB {
            static const ::Courier::DataItemKey WBName1Item = 442;
            static const ::Courier::DataItemKey WBName2Item = 493;
            static const ::Courier::DataItemKey WBName3Item = 356;
            static const ::Courier::DataItemKey WBName4Item = 411;
            static const ::Courier::DataItemKey WBName5Item = 267;
            static const ::Courier::DataItemKey WBName6Item = 310;
            static const ::Courier::DataItemKey WBName7Item = 112;
            static const ::Courier::DataItemKey WBName8Item = 161;
            static const ::Courier::DataItemKey WBName9Item = 44;
            static const ::Courier::DataItemKey WBName10Item = 354;
            static const ::Courier::DataItemKey WBmodeItem = 643;
            static const ::Courier::DataItemKey WBFrequencyItem = 397;
    } // namespace PresetInfoWB

    namespace HDIconPreset7 {
            static const ::Courier::DataItemKey HD_Preset_7Item = 209;
            static const ::Courier::DataItemKey HD_Preset_7_valueItem = 421;
    } // namespace HDIconPreset7

    namespace PresetInfoDRM {
            static const ::Courier::DataItemKey PSName1Item = 76;
            static const ::Courier::DataItemKey PSName2Item = 577;
            static const ::Courier::DataItemKey PSName3Item = 530;
            static const ::Courier::DataItemKey PSName4Item = 579;
            static const ::Courier::DataItemKey PSName5Item = 620;
            static const ::Courier::DataItemKey PSName6Item = 330;
    } // namespace PresetInfoDRM

    namespace NextPrevious_Status_DAB {
            static const ::Courier::DataItemKey IsNextActive_DABItem = 294;
            static const ::Courier::DataItemKey IsPreviousActive_DABItem = 586;
    } // namespace NextPrevious_Status_DAB

    namespace Source_Slection {
            static const ::Courier::DataItemKey FM1ActiveItem = 683;
            static const ::Courier::DataItemKey FM2ActiveItem = 2;
            static const ::Courier::DataItemKey FMASTActiveItem = 636;
            static const ::Courier::DataItemKey AMActiveItem = 181;
            static const ::Courier::DataItemKey AMASTActiveItem = 639;
            static const ::Courier::DataItemKey WXActiveItem = 508;
            static const ::Courier::DataItemKey DABActiveItem = 544;
            static const ::Courier::DataItemKey DABASTActiveItem = 140;
            static const ::Courier::DataItemKey SXMActiveItem = 1;
    } // namespace Source_Slection

    namespace Scan_AST {
            static const ::Courier::DataItemKey IsActiveItem = 382;
            static const ::Courier::DataItemKey IsDAB_AST_ActiveItem = 301;
            static const ::Courier::DataItemKey IsAM_AST_ActiveItem = 403;
            static const ::Courier::DataItemKey IsFM_AST_ActiveItem = 543;
            static const ::Courier::DataItemKey IsDRM_AST_ActiveItem = 87;
    } // namespace Scan_AST

    namespace Preset_Popup {
            static const ::Courier::DataItemKey Popup_text_1Item = 361;
            static const ::Courier::DataItemKey Popup_text_2Item = 429;
            static const ::Courier::DataItemKey AST_CannotStoreItem = 500;
            static const ::Courier::DataItemKey CurrentValueItem = 308;
            static const ::Courier::DataItemKey TotalValueItem = 208;
            static const ::Courier::DataItemKey Visible_Txt_Wgt_1Item = 326;
            static const ::Courier::DataItemKey Visible_Txt_Wgt_2Item = 546;
    } // namespace Preset_Popup

    namespace HDAudioSPS1 {
            static const ::Courier::DataItemKey HD_Prog_SPS1_switchItem = 453;
            static const ::Courier::DataItemKey HD_Prog_SPS1_sizeItem = 150;
    } // namespace HDAudioSPS1

    namespace EngineeringInfoDRM {
            static const ::Courier::DataItemKey FrequencyItem = 91;
            static const ::Courier::DataItemKey FieldStrengthItem = 654;
            static const ::Courier::DataItemKey SyncStatusItem = 406;
            static const ::Courier::DataItemKey RobustnessModeItem = 303;
            static const ::Courier::DataItemKey BandwidthItem = 487;
            static const ::Courier::DataItemKey Inter_DepthItem = 398;
            static const ::Courier::DataItemKey Recnfg_idxItem = 284;
            static const ::Courier::DataItemKey Service_IDItem = 147;
            static const ::Courier::DataItemKey Service_LabelItem = 516;
            static const ::Courier::DataItemKey PTYItem = 298;
            static const ::Courier::DataItemKey LanguageItem = 290;
            static const ::Courier::DataItemKey FACItem = 239;
            static const ::Courier::DataItemKey SDCItem = 126;
            static const ::Courier::DataItemKey AudioCRCItem = 62;
            static const ::Courier::DataItemKey AudioMuteItem = 472;
            static const ::Courier::DataItemKey ServiceQualityItem = 214;
            static const ::Courier::DataItemKey AudioCodingItem = 312;
            static const ::Courier::DataItemKey SBRItem = 325;
            static const ::Courier::DataItemKey AudioModeItem = 443;
            static const ::Courier::DataItemKey SamplingRateItem = 336;
            static const ::Courier::DataItemKey TextFlagItem = 358;
            static const ::Courier::DataItemKey IBERItem = 39;
            static const ::Courier::DataItemKey PrLevel_PartAItem = 14;
            static const ::Courier::DataItemKey PrLevel_PartbItem = 328;
    } // namespace EngineeringInfoDRM

    namespace TMHDAudioSPS1 {
            static const ::Courier::DataItemKey TMHD_Prog_SPS1_switchItem = 22;
            static const ::Courier::DataItemKey TMHD_Prog_SPS1_availableItem = 491;
    } // namespace TMHDAudioSPS1

    namespace RadioBandInfo {
            static const ::Courier::DataItemKey Visible_Txt_Wgt_BandItem = 545;
            static const ::Courier::DataItemKey Visible_Txt_Wgt_MuteItem = 154;
            static const ::Courier::DataItemKey Visible_Txt_Wgt_TAItem = 608;
            static const ::Courier::DataItemKey Visible_Txt_Wgt_TA_In_AMItem = 121;
            static const ::Courier::DataItemKey Image_TAItem = 162;
            static const ::Courier::DataItemKey Visible_Txt_Wgt_TA_FMItem = 263;
            static const ::Courier::DataItemKey Visible_Txt_Wgt_TA_DABItem = 131;
    } // namespace RadioBandInfo

    namespace TMHDAudioMPS {
            static const ::Courier::DataItemKey TMHD_Prog_MPS_switchItem = 681;
            static const ::Courier::DataItemKey TMHD_Prog_MPS_availableItem = 399;
    } // namespace TMHDAudioMPS

    namespace ActiveSourceInfo {
            static const ::Courier::DataItemKey BitmapforSourceItem = 674;
            static const ::Courier::DataItemKey ActiveSourceItem = 552;
    } // namespace ActiveSourceInfo

    namespace TunerSource_Band {
            static const ::Courier::DataItemKey TunerSource1Item = 618;
            static const ::Courier::DataItemKey TunerSource2Item = 571;
            static const ::Courier::DataItemKey TunerSource3Item = 215;
            static const ::Courier::DataItemKey TunerSource4Item = 170;
            static const ::Courier::DataItemKey BandEnable1Item = 78;
            static const ::Courier::DataItemKey BandEnable2Item = 118;
            static const ::Courier::DataItemKey BandEnable3Item = 368;
            static const ::Courier::DataItemKey BandEnable4Item = 281;
            static const ::Courier::DataItemKey Band1Item = 349;
            static const ::Courier::DataItemKey Band2Item = 232;
            static const ::Courier::DataItemKey Band3Item = 248;
            static const ::Courier::DataItemKey Band4Item = 110;
    } // namespace TunerSource_Band

    namespace HDAudioSPS2 {
            static const ::Courier::DataItemKey HD_Prog_SPS2_switchItem = 72;
            static const ::Courier::DataItemKey HD_Prog_SPS2_sizeItem = 529;
    } // namespace HDAudioSPS2

    namespace BrowseListSelectedLine {
            static const ::Courier::DataItemKey Tun_StationSelectedItem = 21;
            static const ::Courier::DataItemKey DAB_ServiceSelectedItem = 102;
            static const ::Courier::DataItemKey AF_ServiceSelectedItem = 283;
            static const ::Courier::DataItemKey TMC_ServiceSelectedItem = 233;
            static const ::Courier::DataItemKey DRM_StationSelectedItem = 596;
    } // namespace BrowseListSelectedLine

    namespace ListScrollBarInfo {
            static const ::Courier::DataItemKey EnabledItem = 626;
    } // namespace ListScrollBarInfo

    namespace FMSetupMenuInfo {
            static const ::Courier::DataItemKey ToggleAFItem = 568;
            static const ::Courier::DataItemKey ToggleMMItem = 20;
            static const ::Courier::DataItemKey ToggleTA_statusItem = 36;
            static const ::Courier::DataItemKey ToggleRDSItem = 591;
            static const ::Courier::DataItemKey TogglePhaseDiversityItem = 74;
    } // namespace FMSetupMenuInfo

    namespace HDIconPreset10 {
            static const ::Courier::DataItemKey HD_Preset_10Item = 231;
            static const ::Courier::DataItemKey HD_Preset_10_valueItem = 563;
    } // namespace HDIconPreset10

    namespace DAB_Test_Mode {
            static const ::Courier::DataItemKey channel_NumItem = 669;
            static const ::Courier::DataItemKey Ensemble_LblItem = 323;
            static const ::Courier::DataItemKey Ensemble_IDItem = 340;
            static const ::Courier::DataItemKey Service_IDItem = 564;
            static const ::Courier::DataItemKey Ensemble_freqItem = 73;
            static const ::Courier::DataItemKey Service_LblItem = 13;
            static const ::Courier::DataItemKey Aud_Data_Bit_RateItem = 327;
            static const ::Courier::DataItemKey MSCItem = 302;
            static const ::Courier::DataItemKey FICItem = 83;
            static const ::Courier::DataItemKey NETItem = 627;
            static const ::Courier::DataItemKey RS_FECItem = 307;
            static const ::Courier::DataItemKey Sync_flagItem = 6;
            static const ::Courier::DataItemKey QAItem = 90;
            static const ::Courier::DataItemKey QSItem = 489;
            static const ::Courier::DataItemKey Field_StrengthItem = 335;
            static const ::Courier::DataItemKey Mute_flagItem = 559;
            static const ::Courier::DataItemKey Bg_tuner_ens_freqItem = 622;
            static const ::Courier::DataItemKey Bg_Ensemble_IDItem = 648;
            static const ::Courier::DataItemKey Bg_FICItem = 205;
            static const ::Courier::DataItemKey Audio_ModeItem = 300;
            static const ::Courier::DataItemKey Freq_TableItem = 423;
            static const ::Courier::DataItemKey BGModeItem = 656;
            static const ::Courier::DataItemKey BGSync_flagItem = 292;
            static const ::Courier::DataItemKey TASrcItem = 237;
    } // namespace DAB_Test_Mode

    namespace AmHdLogo {
            static const ::Courier::DataItemKey AmHdLogoIndexItem = 446;
    } // namespace AmHdLogo

    namespace ActiveBankInfo {
            static const ::Courier::DataItemKey FM1_ActiveItem = 509;
            static const ::Courier::DataItemKey FM2_ActiveItem = 242;
            static const ::Courier::DataItemKey FMAST_ActiveItem = 703;
            static const ::Courier::DataItemKey AM_ActiveItem = 521;
            static const ::Courier::DataItemKey AMAST_ActiveItem = 28;
            static const ::Courier::DataItemKey DAB_ActiveItem = 95;
            static const ::Courier::DataItemKey DAB_AST_ActiveItem = 694;
            static const ::Courier::DataItemKey DRM_ActiveItem = 315;
            static const ::Courier::DataItemKey DRM_AST_ActiveItem = 451;
    } // namespace ActiveBankInfo

    namespace DAB_Setup_Screen_ActiveTuner_Info {
            static const ::Courier::DataItemKey DRCItem = 523;
            static const ::Courier::DataItemKey PSItem = 314;
            static const ::Courier::DataItemKey SM_ACCItem = 420;
            static const ::Courier::DataItemKey SRItem = 88;
            static const ::Courier::DataItemKey TPItem = 93;
    } // namespace DAB_Setup_Screen_ActiveTuner_Info

    namespace HDAudioSPS3 {
            static const ::Courier::DataItemKey HD_Prog_SPS3_switchItem = 698;
            static const ::Courier::DataItemKey HD_Prog_SPS3_sizeItem = 279;
    } // namespace HDAudioSPS3

    namespace AppFlyIn {
            static const ::Courier::DataItemKey BTDeviceStateItem = 277;
            static const ::Courier::DataItemKey PhoneCallDurationItem = 432;
            static const ::Courier::DataItemKey TextPhoneCallDurationItem = 570;
            static const ::Courier::DataItemKey PhoneRoamingItem = 562;
            static const ::Courier::DataItemKey PhoneChargeItem = 490;
            static const ::Courier::DataItemKey PhoneSPILinkItem = 623;
            static const ::Courier::DataItemKey NaviRGStausItem = 665;
            static const ::Courier::DataItemKey NaviETADTDItem = 100;
            static const ::Courier::DataItemKey NaviDirectionItem = 64;
            static const ::Courier::DataItemKey NaviDurationItem = 653;
            static const ::Courier::DataItemKey NaviTimeToDestinationItem = 384;
            static const ::Courier::DataItemKey Visible_NaviItem = 69;
            static const ::Courier::DataItemKey Visible_MediaItem = 185;
    } // namespace AppFlyIn

    namespace SPIVisibilityTuner {
            static const ::Courier::DataItemKey SPIIsvisibleTunerItem = 114;
            static const ::Courier::DataItemKey SPIIsvisibleTunerFMTunerItem = 264;
    } // namespace SPIVisibilityTuner

    namespace EngineeringInfo1 {
            static const ::Courier::DataItemKey MultipathQualityItem = 98;
            static const ::Courier::DataItemKey nChannelItem = 413;
            static const ::Courier::DataItemKey RDSItem = 66;
            static const ::Courier::DataItemKey AntennaStatusItem = 364;
            static const ::Courier::DataItemKey ReceptionQualityItem = 254;
            static const ::Courier::DataItemKey SzSharxItem = 169;
            static const ::Courier::DataItemKey SzHicutItem = 149;
            static const ::Courier::DataItemKey TPFlagItem = 427;
    } // namespace EngineeringInfo1

    namespace RdsRadioText {
            static const ::Courier::DataItemKey TextItem = 61;
    } // namespace RdsRadioText

    namespace Tuner2 {
            static const ::Courier::DataItemKey FreqItem = 532;
            static const ::Courier::DataItemKey PIItem = 175;
            static const ::Courier::DataItemKey PSItem = 331;
            static const ::Courier::DataItemKey FSQItem = 324;
            static const ::Courier::DataItemKey HicutItem = 282;
            static const ::Courier::DataItemKey SharxItem = 666;
            static const ::Courier::DataItemKey TPItem = 137;
            static const ::Courier::DataItemKey TAItem = 136;
            static const ::Courier::DataItemKey RDSItem = 414;
            static const ::Courier::DataItemKey AFItem = 351;
            static const ::Courier::DataItemKey DevItem = 441;
            static const ::Courier::DataItemKey CSItem = 525;
            static const ::Courier::DataItemKey MPNCItem = 614;
            static const ::Courier::DataItemKey BandItem = 151;
    } // namespace Tuner2

    namespace HDParamTuningIcon {
            static const ::Courier::DataItemKey HD_IconItem = 366;
    } // namespace HDParamTuningIcon

    namespace DABChannelInfo {
            static const ::Courier::DataItemKey TpStatusItem = 638;
            static const ::Courier::DataItemKey DabStatusItem = 297;
            static const ::Courier::DataItemKey EnsembleLabelItem = 678;
            static const ::Courier::DataItemKey ServiceLabelItem = 251;
            static const ::Courier::DataItemKey RadioTextItem = 607;
            static const ::Courier::DataItemKey RadioTextVisibleItem = 419;
    } // namespace DABChannelInfo

    namespace HDAudioSPS4 {
            static const ::Courier::DataItemKey HD_Prog_SPS4_switchItem = 177;
            static const ::Courier::DataItemKey HD_Prog_SPS4_sizeItem = 295;
    } // namespace HDAudioSPS4

    namespace TAInfo {
            static const ::Courier::DataItemKey TAPSNameItem = 629;
            static const ::Courier::DataItemKey PTY31PSNameItem = 635;
    } // namespace TAInfo

    namespace LayerNextPresets_AM {
            static const ::Courier::DataItemKey NextPreviousIndex_AMItem = 9;
    } // namespace LayerNextPresets_AM

    namespace DABOptions {
            static const ::Courier::DataItemKey isChecked_EnablePTYFilterItem = 40;
            static const ::Courier::DataItemKey isChecked_NewsItem = 238;
            static const ::Courier::DataItemKey isChecked_CultureItem = 693;
            static const ::Courier::DataItemKey isChecked_SportsItem = 171;
            static const ::Courier::DataItemKey isChecked_MusicItem = 38;
            static const ::Courier::DataItemKey isChecked_SpecialItem = 522;
    } // namespace DABOptions

    namespace Tuner3 {
            static const ::Courier::DataItemKey FreqItem = 679;
            static const ::Courier::DataItemKey PIItem = 554;
            static const ::Courier::DataItemKey PSItem = 51;
            static const ::Courier::DataItemKey FSQItem = 470;
            static const ::Courier::DataItemKey HicutItem = 686;
            static const ::Courier::DataItemKey SharxItem = 479;
            static const ::Courier::DataItemKey TPItem = 452;
            static const ::Courier::DataItemKey TAItem = 590;
            static const ::Courier::DataItemKey RDSItem = 16;
            static const ::Courier::DataItemKey AFItem = 369;
            static const ::Courier::DataItemKey DevItem = 551;
            static const ::Courier::DataItemKey CSItem = 33;
            static const ::Courier::DataItemKey MPNCItem = 105;
            static const ::Courier::DataItemKey BandItem = 178;
    } // namespace Tuner3

    namespace HDButtonVisibility {
            static const ::Courier::DataItemKey isHdVisibleItem = 285;
    } // namespace HDButtonVisibility

    namespace HDAudioSPS5 {
            static const ::Courier::DataItemKey HD_Prog_SPS5_switchItem = 132;
            static const ::Courier::DataItemKey HD_Prog_SPS5_sizeItem = 206;
    } // namespace HDAudioSPS5

    namespace WBPresetInfo {
            static const ::Courier::DataItemKey Preset_1_ActiveItem = 56;
            static const ::Courier::DataItemKey Preset_2_ActiveItem = 3;
            static const ::Courier::DataItemKey Preset_3_ActiveItem = 467;
            static const ::Courier::DataItemKey Preset_4_ActiveItem = 655;
            static const ::Courier::DataItemKey Preset_5_ActiveItem = 575;
            static const ::Courier::DataItemKey Preset_6_ActiveItem = 462;
            static const ::Courier::DataItemKey Preset_7_ActiveItem = 243;
            static const ::Courier::DataItemKey Preset_8_ActiveItem = 652;
            static const ::Courier::DataItemKey Preset_9_ActiveItem = 402;
            static const ::Courier::DataItemKey Preset_10_ActiveItem = 499;
    } // namespace WBPresetInfo

    namespace AMPresetInfo {
            static const ::Courier::DataItemKey Preset_1_ActiveItem = 630;
            static const ::Courier::DataItemKey Preset_2_ActiveItem = 518;
            static const ::Courier::DataItemKey Preset_3_ActiveItem = 124;
            static const ::Courier::DataItemKey Preset_4_ActiveItem = 634;
            static const ::Courier::DataItemKey Preset_5_ActiveItem = 317;
            static const ::Courier::DataItemKey Preset_6_ActiveItem = 344;
            static const ::Courier::DataItemKey Preset_7_ActiveItem = 363;
            static const ::Courier::DataItemKey Preset_8_ActiveItem = 333;
            static const ::Courier::DataItemKey Preset_9_ActiveItem = 321;
            static const ::Courier::DataItemKey Preset_10_ActiveItem = 119;
            static const ::Courier::DataItemKey Preset_11_ActiveItem = 116;
            static const ::Courier::DataItemKey Preset_12_ActiveItem = 557;
    } // namespace AMPresetInfo

    namespace DRMOptions {
            static const ::Courier::DataItemKey isChecked_EnablePTYFilterItem = 393;
            static const ::Courier::DataItemKey isChecked_NewsItem = 663;
            static const ::Courier::DataItemKey isChecked_CultureItem = 157;
            static const ::Courier::DataItemKey isChecked_SportsItem = 613;
            static const ::Courier::DataItemKey isChecked_MusicItem = 249;
            static const ::Courier::DataItemKey isChecked_SpecialItem = 377;
    } // namespace DRMOptions

    namespace TmcStationInfoData {
            static const ::Courier::DataItemKey PSItem = 216;
            static const ::Courier::DataItemKey PIItem = 603;
            static const ::Courier::DataItemKey CCItem = 602;
            static const ::Courier::DataItemKey SIDItem = 58;
            static const ::Courier::DataItemKey LTNItem = 589;
            static const ::Courier::DataItemKey QualityItem = 273;
    } // namespace TmcStationInfoData

    namespace HDAudioSPS6 {
            static const ::Courier::DataItemKey HD_Prog_SPS6_switchItem = 400;
            static const ::Courier::DataItemKey HD_Prog_SPS6_sizeItem = 676;
    } // namespace HDAudioSPS6

    namespace TmcInformationData {
            static const ::Courier::DataItemKey NumberOfMsgItem = 228;
            static const ::Courier::DataItemKey SelectedMsgItem = 388;
            static const ::Courier::DataItemKey LastMsgRecdItem = 506;
    } // namespace TmcInformationData

    namespace BrowseListSize {
            static const ::Courier::DataItemKey Tun_StationListSizeItem = 7;
            static const ::Courier::DataItemKey DAB_ServiceListSizeItem = 32;
            static const ::Courier::DataItemKey AF_ServiceListSizeItem = 582;
            static const ::Courier::DataItemKey TMC_ServiceListSizeItem = 460;
            static const ::Courier::DataItemKey DRM_ServiceListSizeItem = 691;
            static const ::Courier::DataItemKey Tun_StationWindowListSizeItem = 644;
            static const ::Courier::DataItemKey DAB_ServiceWindowListSizeItem = 125;
            static const ::Courier::DataItemKey AF_ServiceWindowListSizeItem = 139;
            static const ::Courier::DataItemKey TMC_ServiceWindowListSizeItem = 156;
            static const ::Courier::DataItemKey DRM_ServiceWindowListSizeItem = 179;
    } // namespace BrowseListSize

    namespace Tuner1 {
            static const ::Courier::DataItemKey FreqItem = 135;
            static const ::Courier::DataItemKey PIItem = 261;
            static const ::Courier::DataItemKey PSItem = 79;
            static const ::Courier::DataItemKey FSQItem = 268;
            static const ::Courier::DataItemKey HicutItem = 183;
            static const ::Courier::DataItemKey SharxItem = 313;
            static const ::Courier::DataItemKey TPItem = 615;
            static const ::Courier::DataItemKey TAItem = 224;
            static const ::Courier::DataItemKey RDSItem = 25;
            static const ::Courier::DataItemKey AFItem = 365;
            static const ::Courier::DataItemKey DevItem = 448;
            static const ::Courier::DataItemKey CSItem = 357;
            static const ::Courier::DataItemKey MPNCItem = 658;
            static const ::Courier::DataItemKey BandItem = 685;
    } // namespace Tuner1

    namespace PresetInfoDRMAST {
            static const ::Courier::DataItemKey PSName1Item = 309;
            static const ::Courier::DataItemKey PSName2Item = 280;
            static const ::Courier::DataItemKey PSName3Item = 316;
            static const ::Courier::DataItemKey PSName4Item = 155;
            static const ::Courier::DataItemKey PSName5Item = 415;
            static const ::Courier::DataItemKey PSName6Item = 257;
    } // namespace PresetInfoDRMAST

    namespace NextPrevious_Status_FM {
            static const ::Courier::DataItemKey IsNextActive_FMItem = 275;
            static const ::Courier::DataItemKey IsPreviousActive_FMItem = 418;
    } // namespace NextPrevious_Status_FM

    namespace SearchNextPrevious_IconActive {
            static const ::Courier::DataItemKey IsNextIconActiveItem = 625;
            static const ::Courier::DataItemKey IsPreviousIconActiveItem = 667;
    } // namespace SearchNextPrevious_IconActive

    namespace FmHdOnOff {
            static const ::Courier::DataItemKey IsActiveItem = 574;
    } // namespace FmHdOnOff

    namespace EngineeringInfo2 {
            static const ::Courier::DataItemKey TAFlagItem = 288;
            static const ::Courier::DataItemKey AltFrequencyItem = 18;
            static const ::Courier::DataItemKey AFonOffItem = 606;
            static const ::Courier::DataItemKey BandscanOnOffItem = 416;
            static const ::Courier::DataItemKey MeasureOnOffItem = 547;
            static const ::Courier::DataItemKey FreqStepFMItem = 513;
            static const ::Courier::DataItemKey FreqStepAMItem = 153;
            static const ::Courier::DataItemKey RFLevelAMItem = 345;
            static const ::Courier::DataItemKey LinearAudioItem = 540;
            static const ::Courier::DataItemKey AMTunerItem = 410;
            static const ::Courier::DataItemKey FMTuner1Item = 332;
            static const ::Courier::DataItemKey FMTuner2Item = 34;
            static const ::Courier::DataItemKey FMTuner3Item = 84;
            static const ::Courier::DataItemKey FMTuner4Item = 97;
            static const ::Courier::DataItemKey DABTunerItem = 222;
    } // namespace EngineeringInfo2

    namespace HDAudioSPS7 {
            static const ::Courier::DataItemKey HD_Prog_SPS7_switchItem = 550;
            static const ::Courier::DataItemKey HD_Prog_SPS7_sizeItem = 29;
    } // namespace HDAudioSPS7

    namespace tuningSlider {
            static const ::Courier::DataItemKey StepSizeAMItem = 49;
            static const ::Courier::DataItemKey MaxValueAMItem = 464;
            static const ::Courier::DataItemKey MinValueAMItem = 594;
            static const ::Courier::DataItemKey NoOfStepsAMItem = 338;
            static const ::Courier::DataItemKey Image_SliderAMItem = 386;
            static const ::Courier::DataItemKey Image_Slider_BGItem = 628;
            static const ::Courier::DataItemKey StepSizeFMItem = 645;
            static const ::Courier::DataItemKey MaxValueFMItem = 558;
            static const ::Courier::DataItemKey TotalTimeFMItem = 424;
            static const ::Courier::DataItemKey NoOfStepsFMItem = 128;
            static const ::Courier::DataItemKey Image_SliderFMItem = 417;
    } // namespace tuningSlider

    namespace TMHDAudioSPS6 {
            static const ::Courier::DataItemKey TMHD_Prog_SPS6_switchItem = 459;
            static const ::Courier::DataItemKey TMHD_Prog_SPS6_availableItem = 450;
    } // namespace TMHDAudioSPS6

    namespace Menu_NumOptions {
            static const ::Courier::DataItemKey MainMenu_NumOptionsItem = 701;
    } // namespace Menu_NumOptions

    namespace PresetInfoAM {
            static const ::Courier::DataItemKey PSName1Item = 92;
            static const ::Courier::DataItemKey PSName2Item = 31;
            static const ::Courier::DataItemKey PSName3Item = 89;
            static const ::Courier::DataItemKey PSName4Item = 664;
            static const ::Courier::DataItemKey PSName5Item = 5;
            static const ::Courier::DataItemKey PSName6Item = 595;
            static const ::Courier::DataItemKey PSName7Item = 473;
            static const ::Courier::DataItemKey PSName8Item = 514;
            static const ::Courier::DataItemKey PSName9Item = 394;
            static const ::Courier::DataItemKey PSName10Item = 621;
            static const ::Courier::DataItemKey PSName11Item = 405;
            static const ::Courier::DataItemKey PSName12Item = 494;
    } // namespace PresetInfoAM

    namespace NextPrevious_Status_AM {
            static const ::Courier::DataItemKey IsNextActive_AMItem = 52;
            static const ::Courier::DataItemKey IsPreviousActive_AMItem = 684;
    } // namespace NextPrevious_Status_AM

    namespace PresetInfoDAB {
            static const ::Courier::DataItemKey PSName1Item = 123;
            static const ::Courier::DataItemKey PSName2Item = 431;
            static const ::Courier::DataItemKey PSName3Item = 374;
            static const ::Courier::DataItemKey PSName4Item = 661;
            static const ::Courier::DataItemKey PSName5Item = 271;
            static const ::Courier::DataItemKey PSName6Item = 226;
            static const ::Courier::DataItemKey PSName7Item = 130;
            static const ::Courier::DataItemKey PSName8Item = 466;
            static const ::Courier::DataItemKey PSName9Item = 59;
            static const ::Courier::DataItemKey PSName10Item = 700;
            static const ::Courier::DataItemKey PSName11Item = 240;
            static const ::Courier::DataItemKey PSName12Item = 531;
    } // namespace PresetInfoDAB

    namespace DABTestModeServiceFollowingInfo {
            static const ::Courier::DataItemKey TSUItem = 318;
    } // namespace DABTestModeServiceFollowingInfo

    namespace RDSOptions {
            static const ::Courier::DataItemKey Visible_TA_IconItem = 42;
            static const ::Courier::DataItemKey Visible_TA_Icon_CrossItem = 461;
            static const ::Courier::DataItemKey Visible_TAItem = 524;
            static const ::Courier::DataItemKey Visible_RadioTextItem = 537;
            static const ::Courier::DataItemKey Visible_AFItem = 488;
            static const ::Courier::DataItemKey Visible_RegItem = 81;
            static const ::Courier::DataItemKey Visible_DRMAFSItem = 45;
    } // namespace RDSOptions

    namespace DAB_Setup_Screen {
            static const ::Courier::DataItemKey ServiceLinkingItem = 699;
            static const ::Courier::DataItemKey ConcealmentLevelItem = 695;
    } // namespace DAB_Setup_Screen

    namespace DABPresetInfo {
            static const ::Courier::DataItemKey Preset_1_ActiveItem = 223;
            static const ::Courier::DataItemKey Preset_2_ActiveItem = 55;
            static const ::Courier::DataItemKey Preset_3_ActiveItem = 370;
            static const ::Courier::DataItemKey Preset_4_ActiveItem = 164;
            static const ::Courier::DataItemKey Preset_5_ActiveItem = 174;
            static const ::Courier::DataItemKey Preset_6_ActiveItem = 468;
            static const ::Courier::DataItemKey Preset_7_ActiveItem = 515;
            static const ::Courier::DataItemKey Preset_8_ActiveItem = 168;
            static const ::Courier::DataItemKey Preset_9_ActiveItem = 47;
            static const ::Courier::DataItemKey Preset_10_ActiveItem = 176;
            static const ::Courier::DataItemKey Preset_11_ActiveItem = 385;
            static const ::Courier::DataItemKey Preset_12_ActiveItem = 668;
    } // namespace DABPresetInfo

    namespace StationInfoSource {
            static const ::Courier::DataItemKey PSNameItem = 189;
            static const ::Courier::DataItemKey AMPSNameItem = 133;
            static const ::Courier::DataItemKey AMFrequencyItem = 478;
            static const ::Courier::DataItemKey FMFrequencyItem = 106;
            static const ::Courier::DataItemKey DRMFrequencyItem = 520;
            static const ::Courier::DataItemKey RadioTextItem = 276;
            static const ::Courier::DataItemKey UnitItem = 269;
            static const ::Courier::DataItemKey ViewNameItem = 688;
            static const ::Courier::DataItemKey TPInfoItem = 159;
            static const ::Courier::DataItemKey DabTPInfoItem = 258;
            static const ::Courier::DataItemKey CurrentStationTPInfoItem = 404;
            static const ::Courier::DataItemKey Visible_Txt_Wgt_RDSItem = 672;
            static const ::Courier::DataItemKey Visible_Txt_Wgt_NoRDSItem = 141;
            static const ::Courier::DataItemKey Visible_Txt_Wgt_NaviItem = 444;
            static const ::Courier::DataItemKey Visible_Txt_Wgt_EUItem = 533;
            static const ::Courier::DataItemKey Variant_TypeItem = 65;
            static const ::Courier::DataItemKey Variant_Type_NonEUItem = 256;
            static const ::Courier::DataItemKey TA_SourcePSNameItem = 407;
            static const ::Courier::DataItemKey DRM_ServiceLabelItem = 94;
            static const ::Courier::DataItemKey DRMStatusItem = 252;
            static const ::Courier::DataItemKey Visible_DRMServiceItem = 592;
            static const ::Courier::DataItemKey Visible_DRMRadioTextItem = 207;
            static const ::Courier::DataItemKey Visible_DRMFrequencyItem = 77;
            static const ::Courier::DataItemKey DRMPTYItem = 593;
            static const ::Courier::DataItemKey Icon_stationItem = 96;
            static const ::Courier::DataItemKey DAB_Icon_stationItem = 187;
    } // namespace StationInfoSource

    namespace HDIconPreset1 {
            static const ::Courier::DataItemKey HD_Preset_1Item = 371;
            static const ::Courier::DataItemKey HD_Preset_1_valueItem = 682;
    } // namespace HDIconPreset1

    namespace tuningScale_SliderMarkerPosition {
            static const ::Courier::DataItemKey CurrentValueItem = 677;
            static const ::Courier::DataItemKey DragCurrentValueItem = 387;
    } // namespace tuningScale_SliderMarkerPosition

    namespace HDIconPreset9 {
            static const ::Courier::DataItemKey HD_Preset_9Item = 447;
            static const ::Courier::DataItemKey HD_Preset_9_valueItem = 437;
    } // namespace HDIconPreset9

    namespace EngineeringInfo {
            static const ::Courier::DataItemKey _szFrequencyItem = 198;
            static const ::Courier::DataItemKey _szPSNameItem = 117;
            static const ::Courier::DataItemKey _szPIItem = 108;
            static const ::Courier::DataItemKey _szFieldstrengthItem = 103;
            static const ::Courier::DataItemKey _szQualityItem = 192;
            static const ::Courier::DataItemKey _szSharxItem = 440;
            static const ::Courier::DataItemKey _szHicutItem = 230;
            static const ::Courier::DataItemKey _szFMDeviationItem = 578;
            static const ::Courier::DataItemKey _szChannelSeparationItem = 255;
    } // namespace EngineeringInfo

    namespace DABTestModeEnsembleInfo {
            static const ::Courier::DataItemKey NoOfAud_DataServiceCompItem = 401;
            static const ::Courier::DataItemKey NoOfAud_DataServiceItem = 481;
            static const ::Courier::DataItemKey NoOfEnsemblesItem = 291;
    } // namespace DABTestModeEnsembleInfo

    namespace AMFMLogoImage {
            static const ::Courier::DataItemKey AMFMLogoItem = 250;
            static const ::Courier::DataItemKey AMFMDefalutLogoItem = 337;
            static const ::Courier::DataItemKey AMFMLogoVisibilityItem = 391;
    } // namespace AMFMLogoImage

    namespace HDIconPreset11 {
            static const ::Courier::DataItemKey HD_Preset_11Item = 212;
            static const ::Courier::DataItemKey HD_Preset_11_valueItem = 227;
    } // namespace HDIconPreset11

    namespace PresetInfoFMAST {
            static const ::Courier::DataItemKey PSName1Item = 581;
            static const ::Courier::DataItemKey PSName2Item = 439;
            static const ::Courier::DataItemKey PSName3Item = 631;
            static const ::Courier::DataItemKey PSName4Item = 536;
            static const ::Courier::DataItemKey PSName5Item = 17;
            static const ::Courier::DataItemKey PSName6Item = 601;
    } // namespace PresetInfoFMAST

    namespace DABTestModeGAvailabiltyInfo {
            static const ::Courier::DataItemKey TAItem = 507;
            static const ::Courier::DataItemKey IndicatorItem = 471;
            static const ::Courier::DataItemKey DABDABItem = 567;
    } // namespace DABTestModeGAvailabiltyInfo

    namespace DABGTestModeInfo {
            static const ::Courier::DataItemKey FMItem = 196;
            static const ::Courier::DataItemKey PIItem = 201;
            static const ::Courier::DataItemKey QFMItem = 104;
            static const ::Courier::DataItemKey PLItem = 492;
    } // namespace DABGTestModeInfo

    namespace DABGTestModeActiveComp {
            static const ::Courier::DataItemKey SCItem = 598;
            static const ::Courier::DataItemKey SCTypeItem = 381;
    } // namespace DABGTestModeActiveComp

    namespace TestModeAvailabilityInfo {
            static const ::Courier::DataItemKey FMTestModeAvailItem = 167;
            static const ::Courier::DataItemKey DABTestModeAvailItem = 475;
    } // namespace TestModeAvailabilityInfo

    namespace PresetInfoFM1 {
            static const ::Courier::DataItemKey PSName1Item = 353;
            static const ::Courier::DataItemKey PSName2Item = 319;
            static const ::Courier::DataItemKey PSName3Item = 435;
            static const ::Courier::DataItemKey PSName4Item = 392;
            static const ::Courier::DataItemKey PSName5Item = 352;
            static const ::Courier::DataItemKey PSName6Item = 320;
    } // namespace PresetInfoFM1

    namespace TMHDAudioSPS3 {
            static const ::Courier::DataItemKey TMHD_Prog_SPS3_switchItem = 8;
            static const ::Courier::DataItemKey TMHD_Prog_SPS3_availableItem = 172;
    } // namespace TMHDAudioSPS3

    namespace HDIconPreset2 {
            static const ::Courier::DataItemKey HD_Preset_2Item = 129;
            static const ::Courier::DataItemKey HD_Preset_2_valueItem = 70;
    } // namespace HDIconPreset2

    namespace HDProgramListVisibility {
            static const ::Courier::DataItemKey isHdProgramListVisibleItem = 246;
    } // namespace HDProgramListVisibility

    namespace CheckBoxListItem {
            static const ::Courier::DataItemKey ListItemNameItem = 624;
            static const ::Courier::DataItemKey ToggleIconSwitchIndexItem = 496;
    } // namespace CheckBoxListItem

    namespace HomeScreenAmHdLogo {
            static const ::Courier::DataItemKey HomeScreen_AmHdLogoItem = 380;
    } // namespace HomeScreenAmHdLogo

    namespace HomeScreenInfo {
            static const ::Courier::DataItemKey HomeScreen_ActiveIconIndexItem = 642;
            static const ::Courier::DataItemKey HomeScreen_ActiveSourceTextItem = 80;
            static const ::Courier::DataItemKey HomeScreen_DABServiceNameItem = 311;
            static const ::Courier::DataItemKey HomeScreen_ScanInvisibleItem = 378;
            static const ::Courier::DataItemKey HomeScreen_DABServicevisiblityItem = 389;
            static const ::Courier::DataItemKey HomeScreen_MuteIconStatusItem = 193;
            static const ::Courier::DataItemKey HomeFrequencyItem = 497;
            static const ::Courier::DataItemKey HomeScreen_PACStatusItem = 221;
            static const ::Courier::DataItemKey HomeWeatherbandTextItem = 610;
            static const ::Courier::DataItemKey FrequencyUnitItem = 71;
            static const ::Courier::DataItemKey HomeScreen_NextPreviousIconStatusItem = 538;
            static const ::Courier::DataItemKey HomeFrequencyStationNameItem = 434;
            static const ::Courier::DataItemKey HomeFrequencyStationNameVisibilityItem = 505;
    } // namespace HomeScreenInfo

    namespace PresetInfoFM2 {
            static const ::Courier::DataItemKey PSName1Item = 158;
            static const ::Courier::DataItemKey PSName2Item = 649;
            static const ::Courier::DataItemKey PSName3Item = 23;
            static const ::Courier::DataItemKey PSName4Item = 229;
            static const ::Courier::DataItemKey PSName5Item = 697;
            static const ::Courier::DataItemKey PSName6Item = 511;
    } // namespace PresetInfoFM2

    namespace HomeScreenFmHdLogo {
            static const ::Courier::DataItemKey HomeScreen_FmHdLogoItem = 146;
    } // namespace HomeScreenFmHdLogo

    namespace HDIconPreset6 {
            static const ::Courier::DataItemKey HD_Preset_6Item = 234;
            static const ::Courier::DataItemKey HD_Preset_6_valueItem = 348;
    } // namespace HDIconPreset6

    namespace HDIconPreset3 {
            static const ::Courier::DataItemKey HD_Preset_3Item = 484;
            static const ::Courier::DataItemKey HD_Preset_3_valueItem = 54;
    } // namespace HDIconPreset3

    namespace TMHDAudioSPS2 {
            static const ::Courier::DataItemKey TMHD_Prog_SPS2_switchItem = 483;
            static const ::Courier::DataItemKey TMHD_Prog_SPS2_availableItem = 204;
    } // namespace TMHDAudioSPS2

    namespace TMHDAudioSPS5 {
            static const ::Courier::DataItemKey TMHD_Prog_SPS5_switchItem = 10;
            static const ::Courier::DataItemKey TMHD_Prog_SPS5_availableItem = 528;
    } // namespace TMHDAudioSPS5

    namespace LayerNextPresets_DAB {
            static const ::Courier::DataItemKey NextPreviousIndex_DABItem = 659;
    } // namespace LayerNextPresets_DAB

    namespace DABGTestModeAnnoStatusInfo {
            static const ::Courier::DataItemKey ASWItem = 143;
            static const ::Courier::DataItemKey ASUItem = 213;
    } // namespace DABGTestModeAnnoStatusInfo

    namespace LayerNextPresets_FM {
            static const ::Courier::DataItemKey NextPreviousIndex_FMItem = 584;
    } // namespace LayerNextPresets_FM

    namespace HDIconPreset4 {
            static const ::Courier::DataItemKey HD_Preset_4Item = 67;
            static const ::Courier::DataItemKey HD_Preset_4_valueItem = 617;
    } // namespace HDIconPreset4

    namespace HDIconPreset5 {
            static const ::Courier::DataItemKey HD_Preset_5Item = 339;
            static const ::Courier::DataItemKey HD_Preset_5_valueItem = 341;
    } // namespace HDIconPreset5

    namespace DtmHD {
            static const ::Courier::DataItemKey HDStatusItem = 165;
            static const ::Courier::DataItemKey SISStatusItem = 611;
            static const ::Courier::DataItemKey AUDStatusItem = 138;
            static const ::Courier::DataItemKey BlendStatusItem = 11;
            static const ::Courier::DataItemKey HDCallSignItem = 305;
            static const ::Courier::DataItemKey HD10FreqItem = 541;
            static const ::Courier::DataItemKey HD10FSTItem = 576;
            static const ::Courier::DataItemKey HD10CdNoItem = 527;
            static const ::Courier::DataItemKey HD10AudQualItem = 687;
            static const ::Courier::DataItemKey HD05FreqItem = 476;
            static const ::Courier::DataItemKey HD05FSTItem = 270;
            static const ::Courier::DataItemKey HD05CdNoItem = 122;
            static const ::Courier::DataItemKey TransitionsItem = 495;
    } // namespace DtmHD

    namespace PresetInfoAMAST {
            static const ::Courier::DataItemKey PSName1Item = 82;
            static const ::Courier::DataItemKey PSName2Item = 120;
            static const ::Courier::DataItemKey PSName3Item = 519;
            static const ::Courier::DataItemKey PSName4Item = 463;
            static const ::Courier::DataItemKey PSName5Item = 152;
            static const ::Courier::DataItemKey PSName6Item = 200;
    } // namespace PresetInfoAMAST

    namespace Tuner4 {
            static const ::Courier::DataItemKey FreqItem = 350;
            static const ::Courier::DataItemKey PIItem = 430;
            static const ::Courier::DataItemKey PSItem = 203;
            static const ::Courier::DataItemKey FSQItem = 260;
            static const ::Courier::DataItemKey HicutItem = 218;
            static const ::Courier::DataItemKey SharxItem = 469;
            static const ::Courier::DataItemKey TPItem = 265;
            static const ::Courier::DataItemKey TAItem = 211;
            static const ::Courier::DataItemKey RDSItem = 57;
            static const ::Courier::DataItemKey AFItem = 673;
            static const ::Courier::DataItemKey DevItem = 244;
            static const ::Courier::DataItemKey CSItem = 689;
            static const ::Courier::DataItemKey MPNCItem = 180;
            static const ::Courier::DataItemKey BandItem = 347;
    } // namespace Tuner4

    namespace HDIconPreset12 {
            static const ::Courier::DataItemKey HD_Preset_12Item = 50;
            static const ::Courier::DataItemKey HD_Preset_12_valueItem = 482;
    } // namespace HDIconPreset12

    namespace TMHDAudioSPS4 {
            static const ::Courier::DataItemKey TMHD_Prog_SPS4_switchItem = 498;
            static const ::Courier::DataItemKey TMHD_Prog_SPS4_availableItem = 534;
    } // namespace TMHDAudioSPS4

    namespace FMAMPresetInfo {
            static const ::Courier::DataItemKey Preset_1_ActiveItem = 266;
            static const ::Courier::DataItemKey Preset_2_ActiveItem = 502;
            static const ::Courier::DataItemKey Preset_3_ActiveItem = 646;
            static const ::Courier::DataItemKey Preset_4_ActiveItem = 457;
            static const ::Courier::DataItemKey Preset_5_ActiveItem = 517;
            static const ::Courier::DataItemKey Preset_6_ActiveItem = 651;
            static const ::Courier::DataItemKey Preset_7_ActiveItem = 75;
            static const ::Courier::DataItemKey Preset_8_ActiveItem = 194;
            static const ::Courier::DataItemKey Preset_9_ActiveItem = 27;
            static const ::Courier::DataItemKey Preset_10_ActiveItem = 19;
            static const ::Courier::DataItemKey Preset_11_ActiveItem = 549;
            static const ::Courier::DataItemKey Preset_12_ActiveItem = 107;
    } // namespace FMAMPresetInfo

    namespace FmHdLogo {
            static const ::Courier::DataItemKey FmHdLogoIndexItem = 63;
    } // namespace FmHdLogo

    namespace Scan_Status {
            static const ::Courier::DataItemKey IsActiveScanItem = 572;
    } // namespace Scan_Status

    namespace HDIconPreset8 {
            static const ::Courier::DataItemKey HD_Preset_8Item = 145;
            static const ::Courier::DataItemKey HD_Preset_8_valueItem = 142;
    } // namespace HDIconPreset8
} // namespace ItemKey

bool InitDataBinding();

#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
namespace FeatStd {
// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::CheckBoxListItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::CheckBoxListItemDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::StationInfoSourceDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::StationInfoSourceDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HomeScreenInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HomeScreenInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::RadioBandInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::RadioBandInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::FMStationListDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::FMStationListDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::RDSOptionsDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::RDSOptionsDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PresetInfoWBDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PresetInfoWBDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::WBPresetInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::WBPresetInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PresetInfoFM1DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PresetInfoFM1DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PresetInfoFM2DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PresetInfoFM2DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PresetInfoFMASTDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PresetInfoFMASTDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PresetInfoAMDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PresetInfoAMDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PresetInfoAMASTDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PresetInfoAMASTDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PresetInfoDABDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PresetInfoDABDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PresetInfoDABASTDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PresetInfoDABASTDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PresetInfoDRMDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PresetInfoDRMDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PresetInfoDRMASTDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PresetInfoDRMASTDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::EngineeringInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::EngineeringInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::LayerNextPresets_FMDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::LayerNextPresets_FMDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::LayerNextPresets_AMDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::LayerNextPresets_AMDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::LayerNextPresets_DABDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::LayerNextPresets_DABDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::EngineeringInfo1DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::EngineeringInfo1DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::EngineeringInfo2DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::EngineeringInfo2DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::EngineeringInfoDRMDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::EngineeringInfoDRMDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Scan_ASTDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Scan_ASTDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Scan_StatusDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Scan_StatusDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Source_SlectionDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Source_SlectionDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Preset_PopupDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Preset_PopupDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PgBar_timerDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PgBar_timerDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::tuningScale_SliderMarkerPositionDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::tuningScale_SliderMarkerPositionDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::tuningSliderDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::tuningSliderDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::TunerOptionsDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::TunerOptionsDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DABOptionsDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DABOptionsDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DRMOptionsDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DRMOptionsDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::MenuSelectionDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::MenuSelectionDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Menu_NumOptionsDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Menu_NumOptionsDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::AppFlyInDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::AppFlyInDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::BrowseListPointerDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::BrowseListPointerDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::BrowseListSizeDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::BrowseListSizeDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::BrowseListSelectedLineDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::BrowseListSelectedLineDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DABChannelInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DABChannelInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ActiveBankInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ActiveBankInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ActiveSourceInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ActiveSourceInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::VariantInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::VariantInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::TAInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::TAInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DABPresetInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DABPresetInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::FMAMPresetInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::FMAMPresetInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::AMPresetInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::AMPresetInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Tuner1DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Tuner1DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Tuner2DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Tuner2DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Tuner3DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Tuner3DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Tuner4DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Tuner4DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::TunerSource_BandDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::TunerSource_BandDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DAB_Setup_ScreenDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DAB_Setup_ScreenDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DAB_Test_ModeDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DAB_Test_ModeDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DAB_Setup_Screen_ActiveTuner_InfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DAB_Setup_Screen_ActiveTuner_InfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DABTestModeEnsembleInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DABTestModeEnsembleInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DABGTestModeInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DABGTestModeInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DABGTestModeAnnoStatusInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DABGTestModeAnnoStatusInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DABGTestModeActiveCompDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DABGTestModeActiveCompDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DABTestModeGAvailabiltyInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DABTestModeGAvailabiltyInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DABTestModeServiceFollowingInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DABTestModeServiceFollowingInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::TmcInformationDataDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::TmcInformationDataDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::TmcStationInfoDataDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::TmcStationInfoDataDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::TestModeAvailabilityInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::TestModeAvailabilityInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::FMSetupMenuInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::FMSetupMenuInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::NextPrevious_Status_FMDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::NextPrevious_Status_FMDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::NextPrevious_Status_AMDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::NextPrevious_Status_AMDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::NextPrevious_Status_DABDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::NextPrevious_Status_DABDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SearchNextPrevious_IconActiveDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SearchNextPrevious_IconActiveDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::AMFMLogoImageDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::AMFMLogoImageDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ChannelInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ChannelInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::FmHdLogoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::FmHdLogoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::AmHdLogoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::AmHdLogoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HDButtonVisibilityDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HDButtonVisibilityDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::AmHdOnOffDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::AmHdOnOffDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::FmHdOnOffDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::FmHdOnOffDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HDProgramListVisibilityDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HDProgramListVisibilityDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HDAudioMPSDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HDAudioMPSDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HDAudioSPS1DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HDAudioSPS1DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HDAudioSPS2DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HDAudioSPS2DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HDAudioSPS3DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HDAudioSPS3DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HDAudioSPS4DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HDAudioSPS4DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HDAudioSPS5DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HDAudioSPS5DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HDAudioSPS6DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HDAudioSPS6DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HDAudioSPS7DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HDAudioSPS7DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HDIconPreset1DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HDIconPreset1DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HDIconPreset2DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HDIconPreset2DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HDIconPreset3DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HDIconPreset3DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HDIconPreset4DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HDIconPreset4DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HDIconPreset5DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HDIconPreset5DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HDIconPreset6DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HDIconPreset6DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HDIconPreset7DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HDIconPreset7DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HDIconPreset8DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HDIconPreset8DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HDIconPreset9DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HDIconPreset9DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HDIconPreset10DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HDIconPreset10DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HDIconPreset11DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HDIconPreset11DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HDIconPreset12DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HDIconPreset12DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DtmHDDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DtmHDDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HDParamTuningIconDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HDParamTuningIconDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::TMHDAudioMPSDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::TMHDAudioMPSDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::TMHDAudioSPS1DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::TMHDAudioSPS1DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::TMHDAudioSPS2DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::TMHDAudioSPS2DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::TMHDAudioSPS3DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::TMHDAudioSPS3DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::TMHDAudioSPS4DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::TMHDAudioSPS4DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::TMHDAudioSPS5DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::TMHDAudioSPS5DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::TMHDAudioSPS6DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::TMHDAudioSPS6DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::TMHDAudioSPS7DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::TMHDAudioSPS7DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::RdsRadioTextDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::RdsRadioTextDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HomeScreenFmHdLogoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HomeScreenFmHdLogoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HomeScreenAmHdLogoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HomeScreenAmHdLogoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SPIVisibilityTunerDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SPIVisibilityTunerDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ListScrollBarInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ListScrollBarInfoDataBindingSource > const& dataItemContainer);
} // namespace FeatStd
#endif // FEATSTD_STRINGBUFFER_APPENDER_ENABLED
#endif // AppHmi_TunerStateMachine_h
