/************************************************************************
*FILE: AppHmi_TunerStateMachine.cpp 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#include "AppHmi_TunerStateMachine.h"
#include <FeatStd/Util/StaticObject.h>
#include <Cit/VisualStateGlueLayer/VisualStateGlueLayer.h>
#include <Courier/Util/Util.h>
using namespace ::hmibase;
using namespace ::hmi;

//====  defines and includes TTFis output - added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
#include "hmi_trace_if.h"
#include "View/CGI/CourierMsgTracing/CourierMessageMapTrace.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_SM
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/AppHmi_TunerStateMachine.cpp.trc.h"
#endif                            
//====  defines and includes TTFis output - end                        key: SM_TTFis_SBHFMSRF ====

// ------------------------------------------------------------------------

// ------------------------------------------------------------------------
bool SendHdOnOffReqMsg(Courier::Int8 const & aBand)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::HdOnOffReqMsg)(aBand);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendHdParameterListUpdate(Courier::Int8 const & aUpdate)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::HdParameterListUpdate)(aUpdate);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendHdListAccessUpdateMsg(Courier::Int8 const & aScreenStatus)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::HdListAccessUpdateMsg)(aScreenStatus);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendDtmSplitAudioReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::DtmSplitAudioReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendDtmResetTransitionsReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::DtmResetTransitionsReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendHdParameterTuningMsg(Courier::Int8 const & aTuneType)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::HdParameterTuningMsg)(aTuneType);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendHdAudioProgSelectMsg(Courier::UInt32 const & aProgVal)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::HdAudioProgSelectMsg)(aProgVal);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendTunerReqMsg(Courier::Int8 const & aTunerData)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::TunerReqMsg)(aTunerData);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSXMContextMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SXMContextMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendTestmodeBlockContextMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::TestmodeBlockContextMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSXMMonitorContextMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SXMMonitorContextMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSXMSettingsTestmodeContextMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SXMSettingsTestmodeContextMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendFMAMBackContextMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::FMAMBackContextMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendDABServiceReqMsg(Courier::UInt8 const & aService_Value)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::DABServiceReqMsg)(aService_Value);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendDABServiceLinkReqMsg(Courier::UInt8 const & aService_Value)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::DABServiceLinkReqMsg)(aService_Value);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendDABCLevelReqMsg(Courier::UInt8 const & aCLevel_Value)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::DABCLevelReqMsg)(aCLevel_Value);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendTestModeDABQuality(Courier::UInt8 const & aDABTestModeActiveStatus)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::TestModeDABQuality)(aDABTestModeActiveStatus);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPresetSelectMsg(Courier::Int8 const & aPresetNumber)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::PresetSelectMsg)(aPresetNumber);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPresetPopupMsg(Courier::Int8 const & aPresetNumber)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::PresetPopupMsg)(aPresetNumber);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendCannotStorePopupMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::CannotStorePopupMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendLPReleaseMsg(Courier::Int8 const & aPresetNumber)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::LPReleaseMsg)(aPresetNumber);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSeekReqMsg(Courier::Int8 const & aSeekMode)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SeekReqMsg)(aSeekMode);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSetWaveBandMsg(Courier::Int32 const & aBand)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SetWaveBandMsg)(aBand);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendTuneFrequencyReqMsg(Courier::Int8 const & aDirection, Courier::Int8 const & aTicks)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::TuneFrequencyReqMsg)(aDirection, aTicks);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendScanReqMsg(Courier::Int8 const & aScanMode)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ScanReqMsg)(aScanMode);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendMediaChangeMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::MediaChangeMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendHomeScreenMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::HomeScreenMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendBTPhoneMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::BTPhoneMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendNaviMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::NaviMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendMirrorLinkMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::MirrorLinkMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendTunerAppActReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::TunerAppActReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendAFListExitMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::AFListExitMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendDABTMSeekReqMsg(Courier::Int8 const & aDABTMSeekMode)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::DABTMSeekReqMsg)(aDABTMSeekMode);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendTunerViewReqMsg(Courier::UInt8 const & aView)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::TunerViewReqMsg)(aView);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendTuner_TestmodeViewReqMsg(Courier::UInt8 const & aTestmode_Value)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::Tuner_TestmodeViewReqMsg)(aTestmode_Value);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSwitchApplicationReq(enApplicationId const & aApplicationID, enSurfaceId const & aSurfaceID)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SwitchApplicationReq)(aApplicationID, aSurfaceID);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendAutoStoreReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::AutoStoreReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendBrowseListReqMsg(Courier::UInt8 const & aG_SM_ListType)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::BrowseListReqMsg)(aG_SM_ListType);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendBrowseListExitMsg(Courier::UInt8 const & aG_SM_ListType)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::BrowseListExitMsg)(aG_SM_ListType);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendStationListReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::StationListReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendDABStationListReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::DABStationListReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendFMMonitorMessage(Candera::UInt8 const & aFirstArg, Candera::UInt8 const & aSecondArg)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::FMMonitorMessage)(aFirstArg, aSecondArg);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendTunerBLMsg(Courier::Int8 const & aEventId, Courier::Int32 const & aFirstArg, Courier::Int32 const & aSecondArg)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::TunerBLMsg)(aEventId, aFirstArg, aSecondArg);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendNextSelectMsg_FM()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::NextSelectMsg_FM)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPreviousSelectMsg_FM()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::PreviousSelectMsg_FM)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendNextSelectMsg_AM()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::NextSelectMsg_AM)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPreviousSelectMsg_AM()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::PreviousSelectMsg_AM)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendNextSelectMsg_DAB()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::NextSelectMsg_DAB)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPreviousSelectMsg_DAB()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::PreviousSelectMsg_DAB)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendNextIconSelectMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::NextIconSelectMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPreviousIconSelectMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::PreviousIconSelectMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendAbortNextPreviousIcon()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::AbortNextPreviousIcon)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendGuiStartupFinishedUpdMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::GuiStartupFinishedUpdMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendButtonMainSrcActivate(Courier::Int8 const & aSrcmode)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ButtonMainSrcActivate)(aSrcmode);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendContextToMaster(Courier::UInt8 const & aContextScene)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ContextToMaster)(aContextScene);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendTuner_WxBLMsg(Courier::Int32 const & aEventId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::Tuner_WxBLMsg)(aEventId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendCloseNextPrev()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::CloseNextPrev)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendUpdatePresetFocused()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::UpdatePresetFocused)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendUpdateFMPresetFocused()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::UpdateFMPresetFocused)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendUpdateAMPresetFocused()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::UpdateAMPresetFocused)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendViewPreviousMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ViewPreviousMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendChangeLanguageReqMsg(enLanguageId const & aLanguageId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ChangeLanguageReqMsg)(aLanguageId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendFocusReqMsg(FocusActionEnum const & aAction, FocusTimerActionEnum const & aTimerAction, ::Courier::ViewId const & aView, Candera::String const & aWidget)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::FocusReqMsg)(aAction, aTimerAction, aView, aWidget);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendDummyMess(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::DummyMess)(aFirstView, aSecondView, aPos);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendAnimationReqMsg(Courier::AnimationAction::Enum const & aAnimationAction, ::Courier::ViewId const & aViewId, Courier::CompositePath const & aCompositePath, ::Courier::ItemId const & aAnimationId, Courier::AnimationProperties const & aAnimationProperties)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::Courier::AnimationReqMsg)(aAnimationAction, aViewId, aCompositePath, aAnimationId, aAnimationProperties);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendFocusOnRightEncoderReqUpdMsg(bool const & aIsFocusUsed)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::FocusOnRightEncoderReqUpdMsg)(aIsFocusUsed);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendStoreActiveGadgetReqMsg(bool const & aIsGadgetAtive)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::StoreActiveGadgetReqMsg)(aIsGadgetAtive);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendHardKeyPressNotificationMsg(Courier::UInt8 const & aDummy, Courier::UInt8 const & aHKCode, Courier::UInt8 const & aHKState)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::HardKeyPressNotificationMsg)(aDummy, aHKCode, aHKState);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendDropdownChangeMsg(::Candera::DropdownChangeType const & aDropdownChangeType, ::Courier::UInt32 const & aListId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::DropdownChangeMsg)(aDropdownChangeType, aListId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendStartPopupTimerReqMsg(Courier::UInt32 const & aViewId, Courier::UInt32 const & aTimeout)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::StartPopupTimerReqMsg)(aViewId, aTimeout);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendStopPopupTimerReqMsg(Courier::UInt32 const & aViewId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::StopPopupTimerReqMsg)(aViewId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPlayBeepReqMsg(Courier::Int32 const & aBeepType)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::PlayBeepReqMsg)(aBeepType);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendCheckToClosePopupMsg(Courier::UInt32 const & aPopupId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::CheckToClosePopupMsg)(aPopupId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendRestartPopupTimerReqMsg(Courier::UInt32 const & aViewId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::RestartPopupTimerReqMsg)(aViewId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendContextSwitchInResMsg(Courier::UInt32 const & aSwitchId, Courier::UInt32 const & aResponseType)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ContextSwitchInResMsg)(aSwitchId, aResponseType);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendContextSwitchOutReqMsg(Courier::UInt32 const & aTargetContextId, Courier::UInt32 const & aSourceContextId, Courier::UInt32 const & aTargetAppId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ContextSwitchOutReqMsg)(aTargetContextId, aSourceContextId, aTargetAppId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendCurrentScreenDisplayReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::CurrentScreenDisplayReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendLaunchBarDisplayReqMsg(bool const & aVisibility)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::LaunchBarDisplayReqMsg)(aVisibility);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendNavTBTSwipeReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::NavTBTSwipeReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendListItemRightEncoderChangeUpdMsg(Courier::Int8 const & aSteps, Courier::UInt32 const & aListId, Courier::UInt32 const & aRowId, Courier::UInt32 const & aColumnId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ListItemRightEncoderChangeUpdMsg)(aSteps, aListId, aRowId, aColumnId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendListChangeMsg(::Courier::UInt32 const & aListId, ListChangeType const & aListChangeType, ::Courier::Int32 const & aValue, ListChangeMsgSourceType const & aListChangeMsgSource, bool const & aImmediatePositioning)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ListChangeMsg)(aListId, aListChangeType, aValue, aListChangeMsgSource, aImmediatePositioning);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendListFocusScrollReqMsg(Courier::UInt32 const & aListId, Courier::Int32 const & aSteps)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ListFocusScrollReqMsg)(aListId, aSteps);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendListFocusLockDataResetReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ListFocusLockDataResetReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSetApplicationModeReqMsg(Courier::UInt32 const & aModeId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SetApplicationModeReqMsg)(aModeId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSpellerBbehaviorReqMsg(bool const & aEnable)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SpellerBbehaviorReqMsg)(aEnable);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendStatusBarDisplayReqMsg(bool const & aVisibility, Courier::Int32 const & aHeaderType)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::StatusBarDisplayReqMsg)(aVisibility, aHeaderType);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendTBTRetriggerAcousticMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::TBTRetriggerAcousticMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendViewReqMsg(Courier::ViewAction::Enum const & aViewAction, ::Courier::ViewId const & aViewId, bool const & aShallInitScene, bool const & aShallLoadScene)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::Courier::ViewReqMsg)(aViewAction, aViewId, aShallInitScene, aShallLoadScene);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendActivationReqMsg(::Courier::ViewId const & aViewId, bool const & aActivation, bool const & aEnableRendering)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::Courier::ActivationReqMsg)(aViewId, aActivation, aEnableRendering);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendAsyncLoadReqMsg(::Courier::ViewId const & aViewId, bool const & aLoad)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::Courier::AsyncLoadReqMsg)(aViewId, aLoad);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPopupReqMsg(hmibase::popups::CommandEnum const & aCommand, ::Courier::ViewId const & aViewId, Courier::UInt32 const & aPopupDisplayID)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::PopupReqMsg)(aCommand, aViewId, aPopupDisplayID);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendExtendedViewReqMsg(hmibase::views::CommandEnum const & aCommand, ::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ExtendedViewReqMsg)(aCommand, aViewId, aHint);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendShowHMISubSurfaceReqMsg(hmibase::displayRegion const & aDisplayRegion, Courier::Int32 const & aDisplayRegionType, bool const & aShowSubSurface, Courier::UInt32 const & aDisplayID, bool const & aLockSubSurface)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ShowHMISubSurfaceReqMsg)(aDisplayRegion, aDisplayRegionType, aShowSubSurface, aDisplayID, aLockSubSurface);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendRegisterForCloseOnTouchSessionReqMsg(bool const & aRegister, ::Courier::ViewId const & aViewId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::RegisterForCloseOnTouchSessionReqMsg)(aRegister, aViewId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPopupFilterPrioEnableReqMsg(Courier::UInt32 const & aPrio)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::PopupFilterPrioEnableReqMsg)(aPrio);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPopupFilterAllEnableReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::PopupFilterAllEnableReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPopupFilterDisableReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::PopupFilterDisableReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendProfileSwitchMsg(Courier::UInt32 const & aProfile)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ProfileSwitchMsg)(aProfile);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendMultiDisplayPopupFilterReqMsg(hmibase::PopupFilterType const & aPopupFilterType, Courier::UInt32 const & aPrio, Courier::UInt32 const & aDisplayID)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::MultiDisplayPopupFilterReqMsg)(aPopupFilterType, aPrio, aDisplayID);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendCreateNewDestroyOld(::Courier::ViewId const & aSourceView, ::Courier::ViewId const & aDestinationView, Courier::UInt32 const & aUserData1, Courier::Int8 const & aUserData2)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::CreateNewDestroyOld)(aSourceView, aDestinationView, aUserData1, aUserData2);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendNotifierMessage()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::NotifierMessage)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acHdOnOffUpdate(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_acHdOnOffUpdate(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_acHdOnOffUpdate(Courier::Int8 const & aBand)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action acHdOnOffUpdate(aBand = %d)", aBand));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendHdOnOffReqMsg(aBand);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acHdParameterUpdate(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_acHdParameterUpdate(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_acHdParameterUpdate(Courier::Int8 const & aUpdate)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action acHdParameterUpdate(aUpdate = %d)", aUpdate));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendHdParameterListUpdate(aUpdate);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acHdListAccess(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_acHdListAccess(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_acHdListAccess(Courier::Int8 const & aScreenStatus)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action acHdListAccess(aScreenStatus = %d)", aScreenStatus));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendHdListAccessUpdateMsg(aScreenStatus);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acDtmSplitAudio(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acDtmSplitAudio();
    return true;
}
#endif
void Action_acDtmSplitAudio()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action acDtmSplitAudio()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDtmSplitAudioReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acDtmResetTransitions(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acDtmResetTransitions();
    return true;
}
#endif
void Action_acDtmResetTransitions()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action acDtmResetTransitions()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDtmResetTransitionsReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acHdParameterTuningUpdate(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_acHdParameterTuningUpdate(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_acHdParameterTuningUpdate(Courier::Int8 const & aTuneType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action acHdParameterTuningUpdate(aTuneType = %d)", aTuneType));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendHdParameterTuningMsg(aTuneType);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acHdAudioProgSelect(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acHdAudioProgSelect(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acHdAudioProgSelect(Courier::UInt32 const & aProgVal)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action acHdAudioProgSelect(aProgVal = %d)", aProgVal));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendHdAudioProgSelectMsg(aProgVal);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_TunerSelect_1(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_TunerSelect_1();
    return true;
}
#endif
void Action_Perform_TunerSelect_1()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_TunerSelect_1()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTunerReqMsg(0);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_TunerSelect_2(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_TunerSelect_2();
    return true;
}
#endif
void Action_Perform_TunerSelect_2()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_TunerSelect_2()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTunerReqMsg(1);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_TunerSelect_3(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_TunerSelect_3();
    return true;
}
#endif
void Action_Perform_TunerSelect_3()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_TunerSelect_3()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTunerReqMsg(2);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_TunerSelect_4(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_TunerSelect_4();
    return true;
}
#endif
void Action_Perform_TunerSelect_4()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_TunerSelect_4()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTunerReqMsg(3);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_BandSelect_Tuner1(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_BandSelect_Tuner1();
    return true;
}
#endif
void Action_Perform_BandSelect_Tuner1()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_BandSelect_Tuner1()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTunerReqMsg(5);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_BandSelect_Tuner2(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_BandSelect_Tuner2();
    return true;
}
#endif
void Action_Perform_BandSelect_Tuner2()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_BandSelect_Tuner2()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTunerReqMsg(6);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_BandSelect_Tuner3(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_BandSelect_Tuner3();
    return true;
}
#endif
void Action_Perform_BandSelect_Tuner3()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_BandSelect_Tuner3()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTunerReqMsg(7);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_BandSelect_Tuner4(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_BandSelect_Tuner4();
    return true;
}
#endif
void Action_Perform_BandSelect_Tuner4()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_BandSelect_Tuner4()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTunerReqMsg(8);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_SXM_Context(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_SXM_Context();
    return true;
}
#endif
void Action_Perform_SXM_Context()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_SXM_Context()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSXMContextMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_TestmodeBlock_Context(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_TestmodeBlock_Context();
    return true;
}
#endif
void Action_Perform_TestmodeBlock_Context()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_TestmodeBlock_Context()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTestmodeBlockContextMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_SXMMonitor_Context(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_SXMMonitor_Context();
    return true;
}
#endif
void Action_Perform_SXMMonitor_Context()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_SXMMonitor_Context()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSXMMonitorContextMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_SXMSettings_Context(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_SXMSettings_Context();
    return true;
}
#endif
void Action_Perform_SXMSettings_Context()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_SXMSettings_Context()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSXMSettingsTestmodeContextMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_SettingsBackBtn_Context(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_SettingsBackBtn_Context();
    return true;
}
#endif
void Action_Perform_SettingsBackBtn_Context()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_SettingsBackBtn_Context()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendFMAMBackContextMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Service_Linking_Inc(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Service_Linking_Inc();
    return true;
}
#endif
void Action_Perform_Service_Linking_Inc()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Service_Linking_Inc()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDABServiceReqMsg(0);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Service_Linking_Dec(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Service_Linking_Dec();
    return true;
}
#endif
void Action_Perform_Service_Linking_Dec()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Service_Linking_Dec()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDABServiceReqMsg(1);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Service_Link_Inc(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Service_Link_Inc();
    return true;
}
#endif
void Action_Perform_Service_Link_Inc()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Service_Link_Inc()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDABServiceLinkReqMsg(1);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Service_Link_Dec(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Service_Link_Dec();
    return true;
}
#endif
void Action_Perform_Service_Link_Dec()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Service_Link_Dec()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDABServiceLinkReqMsg(2);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_CLevel_Inc(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_CLevel_Inc();
    return true;
}
#endif
void Action_Perform_CLevel_Inc()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_CLevel_Inc()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDABCLevelReqMsg(0);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_CLevel_Dec(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_CLevel_Dec();
    return true;
}
#endif
void Action_Perform_CLevel_Dec()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_CLevel_Dec()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDABCLevelReqMsg(1);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Activate_DAB_TestMode(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Activate_DAB_TestMode();
    return true;
}
#endif
void Action_Activate_DAB_TestMode()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Activate_DAB_TestMode()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTestModeDABQuality(1);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Deactivate_DAB_TestMode(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Deactivate_DAB_TestMode();
    return true;
}
#endif
void Action_Deactivate_DAB_TestMode()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Deactivate_DAB_TestMode()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTestModeDABQuality(0);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Select_1(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Preset_Select_1();
    return true;
}
#endif
void Action_Perform_Preset_Select_1()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Preset_Select_1()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPresetSelectMsg(1);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Select_2(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Preset_Select_2();
    return true;
}
#endif
void Action_Perform_Preset_Select_2()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Preset_Select_2()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPresetSelectMsg(2);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Select_3(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Preset_Select_3();
    return true;
}
#endif
void Action_Perform_Preset_Select_3()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Preset_Select_3()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPresetSelectMsg(3);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Select_4(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Preset_Select_4();
    return true;
}
#endif
void Action_Perform_Preset_Select_4()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Preset_Select_4()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPresetSelectMsg(4);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Select_5(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Preset_Select_5();
    return true;
}
#endif
void Action_Perform_Preset_Select_5()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Preset_Select_5()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPresetSelectMsg(5);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Select_6(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Preset_Select_6();
    return true;
}
#endif
void Action_Perform_Preset_Select_6()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Preset_Select_6()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPresetSelectMsg(6);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Select_7(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Preset_Select_7();
    return true;
}
#endif
void Action_Perform_Preset_Select_7()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Preset_Select_7()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPresetSelectMsg(7);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Select_8(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Preset_Select_8();
    return true;
}
#endif
void Action_Perform_Preset_Select_8()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Preset_Select_8()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPresetSelectMsg(8);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Select_9(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Preset_Select_9();
    return true;
}
#endif
void Action_Perform_Preset_Select_9()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Preset_Select_9()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPresetSelectMsg(9);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Select_10(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Preset_Select_10();
    return true;
}
#endif
void Action_Perform_Preset_Select_10()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Preset_Select_10()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPresetSelectMsg(10);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Select_11(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Preset_Select_11();
    return true;
}
#endif
void Action_Perform_Preset_Select_11()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Preset_Select_11()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPresetSelectMsg(11);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Select_12(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Preset_Select_12();
    return true;
}
#endif
void Action_Perform_Preset_Select_12()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Preset_Select_12()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPresetSelectMsg(12);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Popup_1(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Preset_Popup_1();
    return true;
}
#endif
void Action_Perform_Preset_Popup_1()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Preset_Popup_1()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPresetPopupMsg(1);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Popup_2(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Preset_Popup_2();
    return true;
}
#endif
void Action_Perform_Preset_Popup_2()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Preset_Popup_2()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPresetPopupMsg(2);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Popup_3(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Preset_Popup_3();
    return true;
}
#endif
void Action_Perform_Preset_Popup_3()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Preset_Popup_3()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPresetPopupMsg(3);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Popup_4(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Preset_Popup_4();
    return true;
}
#endif
void Action_Perform_Preset_Popup_4()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Preset_Popup_4()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPresetPopupMsg(4);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Popup_5(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Preset_Popup_5();
    return true;
}
#endif
void Action_Perform_Preset_Popup_5()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Preset_Popup_5()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPresetPopupMsg(5);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Popup_6(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Preset_Popup_6();
    return true;
}
#endif
void Action_Perform_Preset_Popup_6()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Preset_Popup_6()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPresetPopupMsg(6);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Popup_7(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Preset_Popup_7();
    return true;
}
#endif
void Action_Perform_Preset_Popup_7()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Preset_Popup_7()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPresetPopupMsg(7);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Popup_8(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Preset_Popup_8();
    return true;
}
#endif
void Action_Perform_Preset_Popup_8()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Preset_Popup_8()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPresetPopupMsg(8);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Popup_9(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Preset_Popup_9();
    return true;
}
#endif
void Action_Perform_Preset_Popup_9()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Preset_Popup_9()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPresetPopupMsg(9);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Popup_10(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Preset_Popup_10();
    return true;
}
#endif
void Action_Perform_Preset_Popup_10()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Preset_Popup_10()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPresetPopupMsg(10);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Popup_11(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Preset_Popup_11();
    return true;
}
#endif
void Action_Perform_Preset_Popup_11()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Preset_Popup_11()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPresetPopupMsg(11);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Popup_12(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Preset_Popup_12();
    return true;
}
#endif
void Action_Perform_Preset_Popup_12()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Preset_Popup_12()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPresetPopupMsg(12);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_CannotStore_Popup(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_CannotStore_Popup();
    return true;
}
#endif
void Action_Perform_CannotStore_Popup()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_CannotStore_Popup()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendCannotStorePopupMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Store_1(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Preset_Store_1();
    return true;
}
#endif
void Action_Perform_Preset_Store_1()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Preset_Store_1()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendLPReleaseMsg(Courier::Int8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Store_2(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Preset_Store_2();
    return true;
}
#endif
void Action_Perform_Preset_Store_2()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Preset_Store_2()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendLPReleaseMsg(Courier::Int8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Store_3(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Preset_Store_3();
    return true;
}
#endif
void Action_Perform_Preset_Store_3()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Preset_Store_3()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendLPReleaseMsg(Courier::Int8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Store_4(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Preset_Store_4();
    return true;
}
#endif
void Action_Perform_Preset_Store_4()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Preset_Store_4()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendLPReleaseMsg(Courier::Int8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Store_5(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Preset_Store_5();
    return true;
}
#endif
void Action_Perform_Preset_Store_5()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Preset_Store_5()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendLPReleaseMsg(Courier::Int8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Store_6(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Preset_Store_6();
    return true;
}
#endif
void Action_Perform_Preset_Store_6()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Preset_Store_6()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendLPReleaseMsg(Courier::Int8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Store_7(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Preset_Store_7();
    return true;
}
#endif
void Action_Perform_Preset_Store_7()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Preset_Store_7()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendLPReleaseMsg(Courier::Int8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Store_8(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Preset_Store_8();
    return true;
}
#endif
void Action_Perform_Preset_Store_8()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Preset_Store_8()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendLPReleaseMsg(Courier::Int8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Store_9(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Preset_Store_9();
    return true;
}
#endif
void Action_Perform_Preset_Store_9()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Preset_Store_9()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendLPReleaseMsg(Courier::Int8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Store_10(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Preset_Store_10();
    return true;
}
#endif
void Action_Perform_Preset_Store_10()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Preset_Store_10()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendLPReleaseMsg(Courier::Int8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Store_11(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Preset_Store_11();
    return true;
}
#endif
void Action_Perform_Preset_Store_11()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Preset_Store_11()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendLPReleaseMsg(Courier::Int8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Store_12(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Preset_Store_12();
    return true;
}
#endif
void Action_Perform_Preset_Store_12()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Preset_Store_12()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendLPReleaseMsg(Courier::Int8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Seek_Stop(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Seek_Stop();
    return true;
}
#endif
void Action_Perform_Seek_Stop()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Seek_Stop()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSeekReqMsg(0);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Seek_Next(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Seek_Next();
    return true;
}
#endif
void Action_Perform_Seek_Next()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Seek_Next()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSeekReqMsg(1);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Seek_Previous(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Seek_Previous();
    return true;
}
#endif
void Action_Perform_Seek_Previous()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Seek_Previous()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSeekReqMsg(7);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Seek_Next_Repeat(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Seek_Next_Repeat();
    return true;
}
#endif
void Action_Perform_Seek_Next_Repeat()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Seek_Next_Repeat()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSeekReqMsg(25);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Seek_Previous_Repeat(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Seek_Previous_Repeat();
    return true;
}
#endif
void Action_Perform_Seek_Previous_Repeat()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Seek_Previous_Repeat()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSeekReqMsg(26);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Seek_Previous_Jump(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Seek_Previous_Jump();
    return true;
}
#endif
void Action_Perform_Seek_Previous_Jump()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Seek_Previous_Jump()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSeekReqMsg(34);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Seek_Next_Jump(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Seek_Next_Jump();
    return true;
}
#endif
void Action_Perform_Seek_Next_Jump()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Seek_Next_Jump()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSeekReqMsg(33);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_RefTunerModule_Scene_Tuner_FM(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_RefTunerModule_Scene_Tuner_FM();
    return true;
}
#endif
void Action_Perform_RefTunerModule_Scene_Tuner_FM()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_RefTunerModule_Scene_Tuner_FM()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSetWaveBandMsg(EN_BAND_FM);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_RefTunerModule_Scene_Tuner_AM(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_RefTunerModule_Scene_Tuner_AM();
    return true;
}
#endif
void Action_Perform_RefTunerModule_Scene_Tuner_AM()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_RefTunerModule_Scene_Tuner_AM()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSetWaveBandMsg(EN_BAND_MW);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Freq_Tuning_StepUp(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Freq_Tuning_StepUp();
    return true;
}
#endif
void Action_Perform_Freq_Tuning_StepUp()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Freq_Tuning_StepUp()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTuneFrequencyReqMsg(0, 1);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Freq_Tuning_StepDown(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Freq_Tuning_StepDown();
    return true;
}
#endif
void Action_Perform_Freq_Tuning_StepDown()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Freq_Tuning_StepDown()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTuneFrequencyReqMsg(1, 1);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Freq_Scan_Start(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Freq_Scan_Start();
    return true;
}
#endif
void Action_Perform_Freq_Scan_Start()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Freq_Scan_Start()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendScanReqMsg(3);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Freq_Scan_Stop(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Freq_Scan_Stop();
    return true;
}
#endif
void Action_Perform_Freq_Scan_Stop()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Freq_Scan_Stop()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendScanReqMsg(0);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_MediaChange(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_MediaChange();
    return true;
}
#endif
void Action_Perform_MediaChange()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_MediaChange()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendMediaChangeMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_HomeScreenChange(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_HomeScreenChange();
    return true;
}
#endif
void Action_Perform_HomeScreenChange()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_HomeScreenChange()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendHomeScreenMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_BTPhoneMsgChange(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_BTPhoneMsgChange();
    return true;
}
#endif
void Action_Perform_BTPhoneMsgChange()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_BTPhoneMsgChange()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendBTPhoneMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_NaviChange(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_NaviChange();
    return true;
}
#endif
void Action_Perform_NaviChange()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_NaviChange()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendNaviMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_MirrorLinkChange(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_MirrorLinkChange();
    return true;
}
#endif
void Action_Perform_MirrorLinkChange()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_MirrorLinkChange()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendMirrorLinkMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_PreformTunerAppActReqMsg(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_PreformTunerAppActReqMsg();
    return true;
}
#endif
void Action_PreformTunerAppActReqMsg()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action PreformTunerAppActReqMsg()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTunerAppActReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Preform_AFListExit(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Preform_AFListExit();
    return true;
}
#endif
void Action_Preform_AFListExit()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Preform_AFListExit()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAFListExitMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_DAB_TM_Freq_Seek_Next(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_DAB_TM_Freq_Seek_Next();
    return true;
}
#endif
void Action_Perform_DAB_TM_Freq_Seek_Next()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_DAB_TM_Freq_Seek_Next()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDABTMSeekReqMsg(0);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_DAB_TM_Freq_Seek_Previous(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_DAB_TM_Freq_Seek_Previous();
    return true;
}
#endif
void Action_Perform_DAB_TM_Freq_Seek_Previous()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_DAB_TM_Freq_Seek_Previous()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDABTMSeekReqMsg(1);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_DAB_TM_Ensemble_Seek_Next(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_DAB_TM_Ensemble_Seek_Next();
    return true;
}
#endif
void Action_Perform_DAB_TM_Ensemble_Seek_Next()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_DAB_TM_Ensemble_Seek_Next()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDABTMSeekReqMsg(2);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_DAB_TM_Ensemble_Seek_Previous(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_DAB_TM_Ensemble_Seek_Previous();
    return true;
}
#endif
void Action_Perform_DAB_TM_Ensemble_Seek_Previous()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_DAB_TM_Ensemble_Seek_Previous()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDABTMSeekReqMsg(3);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_SourceSelection(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TunerViewReq_SourceSelection();
    return true;
}
#endif
void Action_TunerViewReq_SourceSelection()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action TunerViewReq_SourceSelection()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTunerViewReqMsg(VIEW_SOURCE_SELECTION);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_FM1(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TunerViewReq_FM1();
    return true;
}
#endif
void Action_TunerViewReq_FM1()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action TunerViewReq_FM1()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTunerViewReqMsg(VIEW_FM1);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_FM2(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TunerViewReq_FM2();
    return true;
}
#endif
void Action_TunerViewReq_FM2()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action TunerViewReq_FM2()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTunerViewReqMsg(VIEW_FM2);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_FM_AST(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TunerViewReq_FM_AST();
    return true;
}
#endif
void Action_TunerViewReq_FM_AST()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action TunerViewReq_FM_AST()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTunerViewReqMsg(VIEW_FM_AST);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_AM(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TunerViewReq_AM();
    return true;
}
#endif
void Action_TunerViewReq_AM()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action TunerViewReq_AM()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTunerViewReqMsg(VIEW_AM);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_AM_AST(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TunerViewReq_AM_AST();
    return true;
}
#endif
void Action_TunerViewReq_AM_AST()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action TunerViewReq_AM_AST()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTunerViewReqMsg(VIEW_AM_AST);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_DAB(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TunerViewReq_DAB();
    return true;
}
#endif
void Action_TunerViewReq_DAB()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action TunerViewReq_DAB()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTunerViewReqMsg(VIEW_DAB);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_DAB_Monitor(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TunerViewReq_DAB_Monitor();
    return true;
}
#endif
void Action_TunerViewReq_DAB_Monitor()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action TunerViewReq_DAB_Monitor()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTunerViewReqMsg(VIEW_DAB_MONITOR);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_DAB_AST(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TunerViewReq_DAB_AST();
    return true;
}
#endif
void Action_TunerViewReq_DAB_AST()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action TunerViewReq_DAB_AST()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTunerViewReqMsg(VIEW_DAB_AST);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_WEATHERBAND(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TunerViewReq_WEATHERBAND();
    return true;
}
#endif
void Action_TunerViewReq_WEATHERBAND()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action TunerViewReq_WEATHERBAND()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTunerViewReqMsg(VIEW_WEATHERBAND);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_WEATHERBAND_MONITOR(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TunerViewReq_WEATHERBAND_MONITOR();
    return true;
}
#endif
void Action_TunerViewReq_WEATHERBAND_MONITOR()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action TunerViewReq_WEATHERBAND_MONITOR()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTunerViewReqMsg(VIEW_WEATHERBAND_MONITOR);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_DRM(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TunerViewReq_DRM();
    return true;
}
#endif
void Action_TunerViewReq_DRM()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action TunerViewReq_DRM()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTunerViewReqMsg(VIEW_DRM);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_DRM_AST(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TunerViewReq_DRM_AST();
    return true;
}
#endif
void Action_TunerViewReq_DRM_AST()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action TunerViewReq_DRM_AST()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTunerViewReqMsg(VIEW_DRM_AST);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_DRM_SL(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TunerViewReq_DRM_SL();
    return true;
}
#endif
void Action_TunerViewReq_DRM_SL()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action TunerViewReq_DRM_SL()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTunerViewReqMsg(VIEW_DRM_SL);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_OPT_DRMPTY(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TunerViewReq_OPT_DRMPTY();
    return true;
}
#endif
void Action_TunerViewReq_OPT_DRMPTY()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action TunerViewReq_OPT_DRMPTY()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTunerViewReqMsg(VIEW_OPT_DRMPTY);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_OPT_FMAM(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TunerViewReq_OPT_FMAM();
    return true;
}
#endif
void Action_TunerViewReq_OPT_FMAM()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action TunerViewReq_OPT_FMAM()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTunerViewReqMsg(VIEW_OPT_FMAM);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_OPT_DABPTY(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TunerViewReq_OPT_DABPTY();
    return true;
}
#endif
void Action_TunerViewReq_OPT_DABPTY()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action TunerViewReq_OPT_DABPTY()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTunerViewReqMsg(VIEW_OPT_DABPTY);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_FM_TESTMODE(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TunerViewReq_FM_TESTMODE();
    return true;
}
#endif
void Action_TunerViewReq_FM_TESTMODE()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action TunerViewReq_FM_TESTMODE()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTunerViewReqMsg(VIEW_FM_TESTMODE);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_FM_MONITORTESTMODE(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TunerViewReq_FM_MONITORTESTMODE();
    return true;
}
#endif
void Action_TunerViewReq_FM_MONITORTESTMODE()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action TunerViewReq_FM_MONITORTESTMODE()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTunerViewReqMsg(VIEW_FM_MONITORTESTMODE);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_AM_TESTMODE(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TunerViewReq_AM_TESTMODE();
    return true;
}
#endif
void Action_TunerViewReq_AM_TESTMODE()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action TunerViewReq_AM_TESTMODE()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTunerViewReqMsg(VIEW_AM_TESTMODE);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_AM_MONITORTESTMODE(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TunerViewReq_AM_MONITORTESTMODE();
    return true;
}
#endif
void Action_TunerViewReq_AM_MONITORTESTMODE()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action TunerViewReq_AM_MONITORTESTMODE()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTunerViewReqMsg(VIEW_AM_MONITORTESTMODE);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_Previous(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TunerViewReq_Previous();
    return true;
}
#endif
void Action_TunerViewReq_Previous()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action TunerViewReq_Previous()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTunerViewReqMsg(VIEW_PREVIOUS);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_PlayView(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TunerViewReq_PlayView();
    return true;
}
#endif
void Action_TunerViewReq_PlayView()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action TunerViewReq_PlayView()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTunerViewReqMsg(VIEW_PLAYVIEW);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_FM_SL(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TunerViewReq_FM_SL();
    return true;
}
#endif
void Action_TunerViewReq_FM_SL()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action TunerViewReq_FM_SL()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTunerViewReqMsg(VIEW_FM_SL);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_DAB_SL(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TunerViewReq_DAB_SL();
    return true;
}
#endif
void Action_TunerViewReq_DAB_SL()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action TunerViewReq_DAB_SL()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTunerViewReqMsg(VIEW_DAB_SL);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_TT_MONITOR1(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TunerViewReq_TT_MONITOR1();
    return true;
}
#endif
void Action_TunerViewReq_TT_MONITOR1()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action TunerViewReq_TT_MONITOR1()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTunerViewReqMsg(VIEW_TT_MONITOR1);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_TT_MONITOR2(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TunerViewReq_TT_MONITOR2();
    return true;
}
#endif
void Action_TunerViewReq_TT_MONITOR2()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action TunerViewReq_TT_MONITOR2()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTunerViewReqMsg(VIEW_TT_MONITOR2);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_TT_MONITOR3(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TunerViewReq_TT_MONITOR3();
    return true;
}
#endif
void Action_TunerViewReq_TT_MONITOR3()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action TunerViewReq_TT_MONITOR3()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTunerViewReqMsg(VIEW_TT_MONITOR3);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_DAB_SETUP_MONITOR(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TunerViewReq_DAB_SETUP_MONITOR();
    return true;
}
#endif
void Action_TunerViewReq_DAB_SETUP_MONITOR()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action TunerViewReq_DAB_SETUP_MONITOR()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTunerViewReqMsg(VIEW_DAB_SETUP_MONITOR);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_DAB_Quality_TestMode(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TunerViewReq_DAB_Quality_TestMode();
    return true;
}
#endif
void Action_TunerViewReq_DAB_Quality_TestMode()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action TunerViewReq_DAB_Quality_TestMode()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTunerViewReqMsg(VIEW_DAB_QUALITY_TESTMODE);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_DAB_Service_Info_TestMod(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TunerViewReq_DAB_Service_Info_TestMod();
    return true;
}
#endif
void Action_TunerViewReq_DAB_Service_Info_TestMod()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action TunerViewReq_DAB_Service_Info_TestMod()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTunerViewReqMsg(VIEW_DAB_SERVICE_INFO_TESTMODE);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_DAB_Expert_API_TestMode(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TunerViewReq_DAB_Expert_API_TestMode();
    return true;
}
#endif
void Action_TunerViewReq_DAB_Expert_API_TestMode()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action TunerViewReq_DAB_Expert_API_TestMode()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTunerViewReqMsg(VIEW_DAB_EXPERT_API_TESTMODE);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_DRMSetup_Monitor(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TunerViewReq_DRMSetup_Monitor();
    return true;
}
#endif
void Action_TunerViewReq_DRMSetup_Monitor()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action TunerViewReq_DRMSetup_Monitor()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTunerViewReqMsg(VIEW_DRM_TESTMODESCREEN);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_AF_L(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TunerViewReq_AF_L();
    return true;
}
#endif
void Action_TunerViewReq_AF_L()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action TunerViewReq_AF_L()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTunerViewReqMsg(VIEW_AF_LIST);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_TMC(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TunerViewReq_TMC();
    return true;
}
#endif
void Action_TunerViewReq_TMC()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action TunerViewReq_TMC()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTunerViewReqMsg(VIEW_TMC);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_TMC_L(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TunerViewReq_TMC_L();
    return true;
}
#endif
void Action_TunerViewReq_TMC_L()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action TunerViewReq_TMC_L()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTunerViewReqMsg(VIEW_TMC_LIST);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_TMC_INFO(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TunerViewReq_TMC_INFO();
    return true;
}
#endif
void Action_TunerViewReq_TMC_INFO()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action TunerViewReq_TMC_INFO()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTunerViewReqMsg(VIEW_TMC_INFO);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_TMC_STN_INFO(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TunerViewReq_TMC_STN_INFO();
    return true;
}
#endif
void Action_TunerViewReq_TMC_STN_INFO()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action TunerViewReq_TMC_STN_INFO()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTunerViewReqMsg(VIEW_TMC_STN_INFO);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_TestModeScreens(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TunerViewReq_TestModeScreens();
    return true;
}
#endif
void Action_TunerViewReq_TestModeScreens()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action TunerViewReq_TestModeScreens()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTunerViewReqMsg(VIEW_TESTMODESCREENS);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TunerTestModeViewReqMsg_Start(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TunerTestModeViewReqMsg_Start();
    return true;
}
#endif
void Action_TunerTestModeViewReqMsg_Start()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action TunerTestModeViewReqMsg_Start()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTuner_TestmodeViewReqMsg(1);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TunerTestModeViewReqMsg_Stop(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TunerTestModeViewReqMsg_Stop();
    return true;
}
#endif
void Action_TunerTestModeViewReqMsg_Stop()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action TunerTestModeViewReqMsg_Stop()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTuner_TestmodeViewReqMsg(2);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_MASTER_GADGET_TUNER(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TunerViewReq_MASTER_GADGET_TUNER();
    return true;
}
#endif
void Action_TunerViewReq_MASTER_GADGET_TUNER()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action TunerViewReq_MASTER_GADGET_TUNER()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTunerViewReqMsg(VIEW_MASTER_GADGET_TUNER);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_FM_INFO(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TunerViewReq_FM_INFO();
    return true;
}
#endif
void Action_TunerViewReq_FM_INFO()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action TunerViewReq_FM_INFO()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTunerViewReqMsg(VIEW_FM_INFO);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_AM_INFO(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TunerViewReq_AM_INFO();
    return true;
}
#endif
void Action_TunerViewReq_AM_INFO()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action TunerViewReq_AM_INFO()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTunerViewReqMsg(VIEW_AM_INFO);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_HDDTM_TESTMODE(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TunerViewReq_HDDTM_TESTMODE();
    return true;
}
#endif
void Action_TunerViewReq_HDDTM_TESTMODE()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action TunerViewReq_HDDTM_TESTMODE()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTunerViewReqMsg(VIEW_HDDTM_TESTMODE);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_HDPARAMTUNING_TESTMODE(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TunerViewReq_HDPARAMTUNING_TESTMODE();
    return true;
}
#endif
void Action_TunerViewReq_HDPARAMTUNING_TESTMODE()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action TunerViewReq_HDPARAMTUNING_TESTMODE()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTunerViewReqMsg(VIEW_HDPARAMTUNING_TESTMODE);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Activate_Home_Source(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Activate_Home_Source();
    return true;
}
#endif
void Action_Perform_Activate_Home_Source()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Activate_Home_Source()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSwitchApplicationReq(APPID_APPHMI_MASTER, SURFACEID_MAIN_SURFACE_MASTER);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_AutoStore_AM(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_AutoStore_AM();
    return true;
}
#endif
void Action_Perform_AutoStore_AM()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_AutoStore_AM()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAutoStoreReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_AutoStore_FM(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_AutoStore_FM();
    return true;
}
#endif
void Action_Perform_AutoStore_FM()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_AutoStore_FM()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAutoStoreReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_AutoStore_DAB(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_AutoStore_DAB();
    return true;
}
#endif
void Action_Perform_AutoStore_DAB()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_AutoStore_DAB()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAutoStoreReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_RequestBrowseList(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_RequestBrowseList(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_RequestBrowseList(Courier::UInt8 const & aG_SM_ListType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action RequestBrowseList(aG_SM_ListType = %d)", aG_SM_ListType));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendBrowseListReqMsg(aG_SM_ListType);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_RequestBrowseListExit(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_RequestBrowseListExit(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_RequestBrowseListExit(Courier::UInt8 const & aG_SM_ListType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action RequestBrowseListExit(aG_SM_ListType = %d)", aG_SM_ListType));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendBrowseListExitMsg(aG_SM_ListType);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_StationBrowseList(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_StationBrowseList();
    return true;
}
#endif
void Action_StationBrowseList()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action StationBrowseList()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendStationListReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_DABStationBrowseList(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_DABStationBrowseList();
    return true;
}
#endif
void Action_DABStationBrowseList()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action DABStationBrowseList()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDABStationListReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_FMMonitorMessageSharxHiCut(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_FMMonitorMessageSharxHiCut(parameters[(::Json::Value::UInt)0].asUInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_FMMonitorMessageSharxHiCut(Candera::UInt8 const & aFirstArg, Candera::UInt8 const & aSecondArg)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action FMMonitorMessageSharxHiCut(aFirstArg = ?Candera::UInt8?, aSecondArg = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendFMMonitorMessage(aFirstArg, aSecondArg);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Tuner_fn(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 3) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt() && parameters[(::Json::Value::UInt)2].isUInt())) { return false; }
    Action_Perform_Tuner_fn(parameters[(::Json::Value::UInt)0].asUInt(), parameters[(::Json::Value::UInt)1].asUInt(), parameters[(::Json::Value::UInt)2].asUInt());
    return true;
}
#endif
void Action_Perform_Tuner_fn(Courier::Int8 const & aEventId, Courier::Int32 const & aFirstArg, Courier::Int32 const & aSecondArg)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Tuner_fn(aEventId = %d, aFirstArg = %d, aSecondArg = %d)", aEventId,aFirstArg,aSecondArg));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTunerBLMsg(aEventId, aFirstArg, aSecondArg);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Next_fn_FM(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Next_fn_FM();
    return true;
}
#endif
void Action_Perform_Next_fn_FM()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Next_fn_FM()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendNextSelectMsg_FM();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Previous_fn_FM(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Previous_fn_FM();
    return true;
}
#endif
void Action_Perform_Previous_fn_FM()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Previous_fn_FM()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPreviousSelectMsg_FM();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Next_fn_AM(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Next_fn_AM();
    return true;
}
#endif
void Action_Perform_Next_fn_AM()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Next_fn_AM()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendNextSelectMsg_AM();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Previous_fn_AM(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Previous_fn_AM();
    return true;
}
#endif
void Action_Perform_Previous_fn_AM()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Previous_fn_AM()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPreviousSelectMsg_AM();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Next_fn_DAB(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Next_fn_DAB();
    return true;
}
#endif
void Action_Perform_Next_fn_DAB()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Next_fn_DAB()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendNextSelectMsg_DAB();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Previous_fn_DAB(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Previous_fn_DAB();
    return true;
}
#endif
void Action_Perform_Previous_fn_DAB()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Previous_fn_DAB()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPreviousSelectMsg_DAB();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Next_fn(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Next_fn();
    return true;
}
#endif
void Action_Perform_Next_fn()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Next_fn()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendNextIconSelectMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Previous_fn(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Previous_fn();
    return true;
}
#endif
void Action_Perform_Previous_fn()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Previous_fn()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPreviousIconSelectMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Abort_Next_Previous_Icon_fn(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Abort_Next_Previous_Icon_fn();
    return true;
}
#endif
void Action_Perform_Abort_Next_Previous_Icon_fn()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Abort_Next_Previous_Icon_fn()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAbortNextPreviousIcon();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Notify_Init_Finished(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Notify_Init_Finished();
    return true;
}
#endif
void Action_Notify_Init_Finished()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Notify_Init_Finished()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendGuiStartupFinishedUpdMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Main_Src_Select(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Main_Src_Select();
    return true;
}
#endif
void Action_Perform_Main_Src_Select()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Main_Src_Select()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendButtonMainSrcActivate(1);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Tuner_Src_Select(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Tuner_Src_Select();
    return true;
}
#endif
void Action_Perform_Tuner_Src_Select()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Tuner_Src_Select()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendButtonMainSrcActivate(2);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Home_Src_Toggle(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Home_Src_Toggle();
    return true;
}
#endif
void Action_Perform_Home_Src_Toggle()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Home_Src_Toggle()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendButtonMainSrcActivate(3);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Send_Context(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_Perform_Send_Context(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_Perform_Send_Context(Courier::UInt8 const & aContextScene)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Send_Context(aContextScene = %d)", aContextScene));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendContextToMaster(aContextScene);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Tuner_Wx_fn(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_Perform_Tuner_Wx_fn(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_Perform_Tuner_Wx_fn(Courier::Int32 const & aEventId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Tuner_Wx_fn(aEventId = %d)", aEventId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTuner_WxBLMsg(aEventId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Stop_Next_Previous(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Stop_Next_Previous();
    return true;
}
#endif
void Action_Perform_Stop_Next_Previous()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Perform_Stop_Next_Previous()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendCloseNextPrev();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Update_Preset_Focused(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Update_Preset_Focused();
    return true;
}
#endif
void Action_Update_Preset_Focused()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Update_Preset_Focused()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendUpdatePresetFocused();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Update_FMPreset_Focused(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Update_FMPreset_Focused();
    return true;
}
#endif
void Action_Update_FMPreset_Focused()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Update_FMPreset_Focused()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendUpdateFMPresetFocused();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Update_AMPreset_Focused(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Update_AMPreset_Focused();
    return true;
}
#endif
void Action_Update_AMPreset_Focused()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Update_AMPreset_Focused()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendUpdateAMPresetFocused();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Update_Previous_View(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Update_Previous_View();
    return true;
}
#endif
void Action_Update_Previous_View()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action Update_Previous_View()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendViewPreviousMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacChangeLanguageReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_gacChangeLanguageReq(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_gacChangeLanguageReq(enLanguageId const & aLanguageId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacChangeLanguageReq(aLanguageId = ?enLanguageId?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendChangeLanguageReqMsg(aLanguageId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacHideFocusInViewReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacHideFocusInViewReq(::Courier::ViewId(AppHmi_TunerStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacHideFocusInViewReq(::Courier::ViewId const & aView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacHideFocusInViewReq(aView = %50s)", aView.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendFocusReqMsg(FOCUS_HIDE, FOCUS_TIMER_NO_ACTION, aView, Candera::String());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_NextLevelTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_NextLevelTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_NextLevelTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action NextLevelTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_PreviousLevelTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_PreviousLevelTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_PreviousLevelTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action PreviousLevelTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_DualViewLeftTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_DualViewLeftTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_DualViewLeftTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action DualViewLeftTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_DualViewRightTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_DualViewRightTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_DualViewRightTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action DualViewRightTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_PageFlipBackTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_PageFlipBackTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_PageFlipBackTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action PageFlipBackTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_PageFlipFrontTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_PageFlipFrontTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_PageFlipFrontTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action PageFlipFrontTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_ZoomInTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 3) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt() && parameters[(::Json::Value::UInt)2].isInt())) { return false; }
    Action_ZoomInTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt(), parameters[(::Json::Value::UInt)2].asInt());
    return true;
}
#endif
void Action_ZoomInTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action ZoomInTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?, aPos = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, aPos);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_ZoomOutTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 3) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt() && parameters[(::Json::Value::UInt)2].isInt())) { return false; }
    Action_ZoomOutTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt(), parameters[(::Json::Value::UInt)2].asInt());
    return true;
}
#endif
void Action_ZoomOutTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action ZoomOutTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?, aPos = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, aPos);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_FadeTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_FadeTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_FadeTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action FadeTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacWaitAnimationStartReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacWaitAnimationStartReq();
    return true;
}
#endif
void Action_gacWaitAnimationStartReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacWaitAnimationStartReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAnimationReqMsg(Courier::AnimationAction::Start, ::Courier::ViewId(), Courier::CompositePath(), ::Courier::ItemId("Global#Animations#WAIT_ANIMATION"), Courier::AnimationProperties());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acFocusOnRightEncoderReqUpd(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_acFocusOnRightEncoderReqUpd(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_acFocusOnRightEncoderReqUpd(bool const & aIsFocusUsed)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action acFocusOnRightEncoderReqUpd(aIsFocusUsed = %d)", aIsFocusUsed));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendFocusOnRightEncoderReqUpdMsg(aIsFocusUsed);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSetGadgetSceenActiveStatus(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_acSetGadgetSceenActiveStatus(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_acSetGadgetSceenActiveStatus(bool const & aIsGadgetAtive)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action acSetGadgetSceenActiveStatus(aIsGadgetAtive = %d)", aIsGadgetAtive));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendStoreActiveGadgetReqMsg(aIsGadgetAtive);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acHKNotificationMsg(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_acHKNotificationMsg(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_acHKNotificationMsg(Courier::UInt8 const & aHKCode, Courier::UInt8 const & aHKState)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action acHKNotificationMsg(aHKCode = %d, aHKState = %d)", aHKCode,aHKState));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendHardKeyPressNotificationMsg(1, aHKCode, aHKState);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acPerform_CloseAllDropdowns(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acPerform_CloseAllDropdowns();
    return true;
}
#endif
void Action_acPerform_CloseAllDropdowns()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action acPerform_CloseAllDropdowns()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDropdownChangeMsg(Candera::DropdownChangeClose, 0);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acPerform_CloseDropdown(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acPerform_CloseDropdown(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acPerform_CloseDropdown(::Courier::UInt32 const & aListId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action acPerform_CloseDropdown(aListId = ?::Courier::UInt32?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDropdownChangeMsg(Candera::DropdownChangeClose, aListId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acPerform_OpenDropdown(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acPerform_OpenDropdown(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acPerform_OpenDropdown(::Courier::UInt32 const & aListId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action acPerform_OpenDropdown(aListId = ?::Courier::UInt32?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDropdownChangeMsg(Candera::DropdownChangeOpen, aListId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acPerform_ToggleDropdown(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acPerform_ToggleDropdown(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acPerform_ToggleDropdown(::Courier::UInt32 const & aListId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action acPerform_ToggleDropdown(aListId = ?::Courier::UInt32?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDropdownChangeMsg(Candera::DropdownChangeToggle, aListId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acStartAppPopupTimer(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_acStartAppPopupTimer(parameters[(::Json::Value::UInt)0].asUInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_acStartAppPopupTimer(Courier::UInt32 const & aViewId, Courier::UInt32 const & aTimeout)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action acStartAppPopupTimer(aViewId = %d, aTimeout = %d)", aViewId,aTimeout));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendStartPopupTimerReqMsg(aViewId, aTimeout);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acStopAppPopupTimer(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acStopAppPopupTimer(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acStopAppPopupTimer(Courier::UInt32 const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action acStopAppPopupTimer(aViewId = %d)", aViewId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendStopPopupTimerReqMsg(aViewId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acPostBeep(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_acPostBeep(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_acPostBeep(Courier::Int32 const & aBeepType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action acPostBeep(aBeepType = %d)", aBeepType));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPlayBeepReqMsg(aBeepType);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacCheckToClosePopup(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacCheckToClosePopup(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacCheckToClosePopup(Courier::UInt32 const & aPopupId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacCheckToClosePopup(aPopupId = %d)", aPopupId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendCheckToClosePopupMsg(aPopupId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acRestartAppPopupTimer(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acRestartAppPopupTimer(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acRestartAppPopupTimer(Courier::UInt32 const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action acRestartAppPopupTimer(aViewId = %d)", aViewId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendRestartPopupTimerReqMsg(aViewId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchBackRes(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacContextSwitchBackRes(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacContextSwitchBackRes(Courier::UInt32 const & aSwitchId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacContextSwitchBackRes(aSwitchId = %d)", aSwitchId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendContextSwitchInResMsg(aSwitchId, CONTEXT_TRANSITION_BACK);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchCompleteRes(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacContextSwitchCompleteRes(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacContextSwitchCompleteRes(Courier::UInt32 const & aSwitchId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacContextSwitchCompleteRes(aSwitchId = %d)", aSwitchId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendContextSwitchInResMsg(aSwitchId, CONTEXT_TRANSITION_COMPLETE);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchFailedRes(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacContextSwitchFailedRes(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacContextSwitchFailedRes(Courier::UInt32 const & aSwitchId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacContextSwitchFailedRes(aSwitchId = %d)", aSwitchId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendContextSwitchInResMsg(aSwitchId, CONTEXT_TRANSITION_FAILED);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchDoneRes(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacContextSwitchDoneRes(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacContextSwitchDoneRes(Courier::UInt32 const & aSwitchId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacContextSwitchDoneRes(aSwitchId = %d)", aSwitchId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendContextSwitchInResMsg(aSwitchId, CONTEXT_TRANSITION_DONE);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchOutReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 3) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt() && parameters[(::Json::Value::UInt)2].isUInt())) { return false; }
    Action_gacContextSwitchOutReq(parameters[(::Json::Value::UInt)0].asUInt(), parameters[(::Json::Value::UInt)1].asUInt(), parameters[(::Json::Value::UInt)2].asUInt());
    return true;
}
#endif
void Action_gacContextSwitchOutReq(Courier::UInt32 const & aTargetContextId, Courier::UInt32 const & aSourceContextId, Courier::UInt32 const & aTargetAppId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacContextSwitchOutReq(aTargetContextId = %d, aSourceContextId = %d, aTargetAppId = %d)", aTargetContextId,aSourceContextId,aTargetAppId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendContextSwitchOutReqMsg(aTargetContextId, aSourceContextId, aTargetAppId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacCurrentScreenDisplayReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacCurrentScreenDisplayReq();
    return true;
}
#endif
void Action_gacCurrentScreenDisplayReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacCurrentScreenDisplayReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendCurrentScreenDisplayReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacLaunchBarDisplayReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_gacLaunchBarDisplayReq(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_gacLaunchBarDisplayReq(bool const & aVisibility)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacLaunchBarDisplayReq(aVisibility = %d)", aVisibility));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendLaunchBarDisplayReqMsg(aVisibility);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacNavTBTSwipe(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacNavTBTSwipe();
    return true;
}
#endif
void Action_gacNavTBTSwipe()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacNavTBTSwipe()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendNavTBTSwipeReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPerformListBtnRightEncoderChangeUpd(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 4) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isUInt() && parameters[(::Json::Value::UInt)2].isUInt() && parameters[(::Json::Value::UInt)3].isUInt())) { return false; }
    Action_gacPerformListBtnRightEncoderChangeUpd(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asUInt(), parameters[(::Json::Value::UInt)2].asUInt(), parameters[(::Json::Value::UInt)3].asUInt());
    return true;
}
#endif
void Action_gacPerformListBtnRightEncoderChangeUpd(Courier::Int8 const & aSteps, Courier::UInt32 const & aListId, Courier::UInt32 const & aRowId, Courier::UInt32 const & aColumnId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacPerformListBtnRightEncoderChangeUpd(aSteps = %d, aListId = %d, aRowId = %d, aColumnId = %d)", aSteps,aListId,aRowId,aColumnId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListItemRightEncoderChangeUpdMsg(aSteps, aListId, aRowId, aColumnId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListUp(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacScrollListUp();
    return true;
}
#endif
void Action_gacScrollListUp()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacScrollListUp()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListChangeMsg(::Courier::UInt32(), ListChangeUp, 1, ListChangeMsgSourceUnknown, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListDown(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacScrollListDown();
    return true;
}
#endif
void Action_gacScrollListDown()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacScrollListDown()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListChangeMsg(::Courier::UInt32(), ListChangeDown, 1, ListChangeMsgSourceUnknown, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacScrollPageUp(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacScrollPageUp();
    return true;
}
#endif
void Action_gacScrollPageUp()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacScrollPageUp()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListChangeMsg(::Courier::UInt32(), ListChangePageUp, 1, ListChangeMsgSourceUnknown, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacScrollPageDown(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacScrollPageDown();
    return true;
}
#endif
void Action_gacScrollPageDown()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacScrollPageDown()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListChangeMsg(::Courier::UInt32(), ListChangePageDown, 1, ListChangeMsgSourceUnknown, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListFocusUp(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacScrollListFocusUp(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacScrollListFocusUp(Courier::UInt32 const & aListId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacScrollListFocusUp(aListId = %d)", aListId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListFocusScrollReqMsg(aListId, -1);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListFocusDown(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacScrollListFocusDown(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacScrollListFocusDown(Courier::UInt32 const & aListId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacScrollListFocusDown(aListId = %d)", aListId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListFocusScrollReqMsg(aListId, 1);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPerformListFocusLockDataResetUpd(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacPerformListFocusLockDataResetUpd();
    return true;
}
#endif
void Action_gacPerformListFocusLockDataResetUpd()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacPerformListFocusLockDataResetUpd()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListFocusLockDataResetReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacSetApplicationMode(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacSetApplicationMode(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacSetApplicationMode(Courier::UInt32 const & aModeId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacSetApplicationMode(aModeId = %d)", aModeId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSetApplicationModeReqMsg(aModeId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacSpellerBbehaviorReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_gacSpellerBbehaviorReq(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_gacSpellerBbehaviorReq(bool const & aEnable)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacSpellerBbehaviorReq(aEnable = %d)", aEnable));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSpellerBbehaviorReqMsg(aEnable);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacStatusBarDisplayReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_gacStatusBarDisplayReq(parameters[(::Json::Value::UInt)0].asBool(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_gacStatusBarDisplayReq(bool const & aVisibility, Courier::Int32 const & aHeaderType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacStatusBarDisplayReq(aVisibility = %d, aHeaderType = %d)", aVisibility,aHeaderType));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendStatusBarDisplayReqMsg(aVisibility, aHeaderType);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacTBTRetriggerAcousticOutput(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacTBTRetriggerAcousticOutput();
    return true;
}
#endif
void Action_gacTBTRetriggerAcousticOutput()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacTBTRetriggerAcousticOutput()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTBTRetriggerAcousticMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacWaitAnimationStopReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacWaitAnimationStopReq();
    return true;
}
#endif
void Action_gacWaitAnimationStopReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacWaitAnimationStopReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAnimationReqMsg(Courier::AnimationAction::Stop, ::Courier::ViewId(), Courier::CompositePath(), ::Courier::ItemId("Global#Animations#WAIT_ANIMATION"), Courier::AnimationProperties());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewCreateReq(::Courier::ViewId(AppHmi_TunerStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewCreateReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacViewCreateReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendViewReqMsg(Courier::ViewAction::Create, aViewId, true, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateAllReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewCreateAllReq(::Courier::ViewId(AppHmi_TunerStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewCreateAllReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacViewCreateAllReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendViewReqMsg(Courier::ViewAction::CreateAll, aViewId, true, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewDestroyReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewDestroyReq(::Courier::ViewId(AppHmi_TunerStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewDestroyReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacViewDestroyReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendViewReqMsg(Courier::ViewAction::Destroy, aViewId, false, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewClearReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewClearReq(::Courier::ViewId(AppHmi_TunerStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewClearReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacViewClearReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendViewReqMsg(Courier::ViewAction::Clear, aViewId, true, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewShowReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewShowReq(::Courier::ViewId(AppHmi_TunerStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewShowReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacViewShowReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendActivationReqMsg(aViewId, true, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewHideReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewHideReq(::Courier::ViewId(AppHmi_TunerStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewHideReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacViewHideReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendActivationReqMsg(aViewId, false, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateWithoutLoadReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewCreateWithoutLoadReq(::Courier::ViewId(AppHmi_TunerStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewCreateWithoutLoadReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacViewCreateWithoutLoadReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendViewReqMsg(Courier::ViewAction::Create, aViewId, false, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewAsyncLoadReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewAsyncLoadReq(::Courier::ViewId(AppHmi_TunerStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewAsyncLoadReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacViewAsyncLoadReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAsyncLoadReqMsg(aViewId, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewActivateWithoutRenderingReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewActivateWithoutRenderingReq(::Courier::ViewId(AppHmi_TunerStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewActivateWithoutRenderingReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacViewActivateWithoutRenderingReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendActivationReqMsg(aViewId, true, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupCreateAndSBShowReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacPopupCreateAndSBShowReq(::Courier::ViewId(AppHmi_TunerStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacPopupCreateAndSBShowReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacPopupCreateAndSBShowReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupReqMsg(hmibase::popups::Show, aViewId, hmibase::DEFAULT_UNKNOWN_DISPLAY);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupCreateAndSBShowReqForMultiDisplay(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacPopupCreateAndSBShowReqForMultiDisplay(parameters[(::Json::Value::UInt)0].asUInt(), ::Courier::ViewId(AppHmi_TunerStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)1].asUInt())));
    return true;
}
#endif
void Action_gacPopupCreateAndSBShowReqForMultiDisplay(Courier::UInt32 const & aPopupDisplayID, ::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacPopupCreateAndSBShowReqForMultiDisplay(aPopupDisplayID = %d, aViewId = %50s)", aPopupDisplayID,aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupReqMsg(hmibase::popups::Show, aViewId, aPopupDisplayID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupSBCloseReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacPopupSBCloseReq(::Courier::ViewId(AppHmi_TunerStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacPopupSBCloseReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacPopupSBCloseReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupReqMsg(hmibase::popups::Hide, aViewId, hmibase::DEFAULT_UNKNOWN_DISPLAY);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupSBCloseReqForMultiDisplay(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacPopupSBCloseReqForMultiDisplay(parameters[(::Json::Value::UInt)0].asUInt(), ::Courier::ViewId(AppHmi_TunerStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)1].asUInt())));
    return true;
}
#endif
void Action_gacPopupSBCloseReqForMultiDisplay(Courier::UInt32 const & aPopupDisplayID, ::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacPopupSBCloseReqForMultiDisplay(aPopupDisplayID = %d, aViewId = %50s)", aPopupDisplayID,aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupReqMsg(hmibase::popups::Hide, aViewId, aPopupDisplayID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupRestartTimerReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacPopupRestartTimerReq(::Courier::ViewId(AppHmi_TunerStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacPopupRestartTimerReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacPopupRestartTimerReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupReqMsg(hmibase::popups::RestartTimer, aViewId, hmibase::DEFAULT_UNKNOWN_DISPLAY);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupRestartTimerReqForMultiDisplay(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacPopupRestartTimerReqForMultiDisplay(parameters[(::Json::Value::UInt)0].asUInt(), ::Courier::ViewId(AppHmi_TunerStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)1].asUInt())));
    return true;
}
#endif
void Action_gacPopupRestartTimerReqForMultiDisplay(Courier::UInt32 const & aPopupDisplayID, ::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacPopupRestartTimerReqForMultiDisplay(aPopupDisplayID = %d, aViewId = %50s)", aPopupDisplayID,aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupReqMsg(hmibase::popups::RestartTimer, aViewId, aPopupDisplayID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateAndShowReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewCreateAndShowReq(::Courier::ViewId(AppHmi_TunerStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewCreateAndShowReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacViewCreateAndShowReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendExtendedViewReqMsg(hmibase::views::CreateAndShow, aViewId, 0);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewHideAndDestroyReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewHideAndDestroyReq(::Courier::ViewId(AppHmi_TunerStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewHideAndDestroyReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacViewHideAndDestroyReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendExtendedViewReqMsg(hmibase::views::HideAndDestroy, aViewId, 0);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacSceneTransitionEnter(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacSceneTransitionEnter(::Courier::ViewId(AppHmi_TunerStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt(), ))parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacSceneTransitionEnter(::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacSceneTransitionEnter(aViewId = %50s, aHint = %d)", aViewId.CStr(),aHint));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendExtendedViewReqMsg(hmibase::views::TransitionEnter, aViewId, aHint);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacSceneTransitionLeave(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacSceneTransitionLeave(::Courier::ViewId(AppHmi_TunerStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt(), ))parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacSceneTransitionLeave(::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacSceneTransitionLeave(aViewId = %50s, aHint = %d)", aViewId.CStr(),aHint));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendExtendedViewReqMsg(hmibase::views::TransitionLeave, aViewId, aHint);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayStatusLineReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_gacDisplayStatusLineReq(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_gacDisplayStatusLineReq(Courier::Int32 const & aDisplayRegionType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacDisplayStatusLineReq(aDisplayRegionType = %d)", aDisplayRegionType));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::STATUS_LINE, aDisplayRegionType, true, hmibase::DEFAULT_UNKNOWN_DISPLAY, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacHideStatusLineReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_gacHideStatusLineReq(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_gacHideStatusLineReq(Courier::Int32 const & aDisplayRegionType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacHideStatusLineReq(aDisplayRegionType = %d)", aDisplayRegionType));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::STATUS_LINE, aDisplayRegionType, false, hmibase::DEFAULT_UNKNOWN_DISPLAY, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayFooterLineReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacDisplayFooterLineReq();
    return true;
}
#endif
void Action_gacDisplayFooterLineReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacDisplayFooterLineReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::FOOTER_LINE, Courier::Int32(), true, hmibase::DEFAULT_UNKNOWN_DISPLAY, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacHideFooterLineReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacHideFooterLineReq();
    return true;
}
#endif
void Action_gacHideFooterLineReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacHideFooterLineReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::FOOTER_LINE, Courier::Int32(), false, hmibase::DEFAULT_UNKNOWN_DISPLAY, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayStatusLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacDisplayStatusLineMultiDisplayReq(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacDisplayStatusLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacDisplayStatusLineMultiDisplayReq(aDisplayRegionType = %d, aDisplayID = %d)", aDisplayRegionType,aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::STATUS_LINE, aDisplayRegionType, true, aDisplayID, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacHideStatusLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacHideStatusLineMultiDisplayReq(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacHideStatusLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacHideStatusLineMultiDisplayReq(aDisplayRegionType = %d, aDisplayID = %d)", aDisplayRegionType,aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::STATUS_LINE, aDisplayRegionType, false, aDisplayID, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayFooterLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacDisplayFooterLineMultiDisplayReq(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacDisplayFooterLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacDisplayFooterLineMultiDisplayReq(aDisplayRegionType = %d, aDisplayID = %d)", aDisplayRegionType,aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::FOOTER_LINE, aDisplayRegionType, true, aDisplayID, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacHideFooterLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacHideFooterLineMultiDisplayReq(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacHideFooterLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacHideFooterLineMultiDisplayReq(aDisplayRegionType = %d, aDisplayID = %d)", aDisplayRegionType,aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::FOOTER_LINE, aDisplayRegionType, false, aDisplayID, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacRegisterForCloseOnTouchSession(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacRegisterForCloseOnTouchSession(::Courier::ViewId(AppHmi_TunerStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacRegisterForCloseOnTouchSession(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacRegisterForCloseOnTouchSession(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendRegisterForCloseOnTouchSessionReqMsg(true, aViewId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacDeregisterForCloseOnTouchSessionReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacDeregisterForCloseOnTouchSessionReq(::Courier::ViewId(AppHmi_TunerStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacDeregisterForCloseOnTouchSessionReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacDeregisterForCloseOnTouchSessionReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendRegisterForCloseOnTouchSessionReqMsg(false, aViewId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterPrioEnableReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacPopupFilterPrioEnableReq(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacPopupFilterPrioEnableReq(Courier::UInt32 const & aPrio)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacPopupFilterPrioEnableReq(aPrio = %d)", aPrio));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupFilterPrioEnableReqMsg(aPrio);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterAllEnableReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacPopupFilterAllEnableReq();
    return true;
}
#endif
void Action_gacPopupFilterAllEnableReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacPopupFilterAllEnableReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupFilterAllEnableReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterDisableReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacPopupFilterDisableReq();
    return true;
}
#endif
void Action_gacPopupFilterDisableReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacPopupFilterDisableReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupFilterDisableReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacProfileChange(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_gacProfileChange(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_gacProfileChange(Courier::UInt32 const & aProfile)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacProfileChange(aProfile = %d)", aProfile));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendProfileSwitchMsg(aProfile);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterPrioEnableReqForDisplay(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacPopupFilterPrioEnableReqForDisplay(parameters[(::Json::Value::UInt)0].asUInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacPopupFilterPrioEnableReqForDisplay(Courier::UInt32 const & aPrio, Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacPopupFilterPrioEnableReqForDisplay(aPrio = %d, aDisplayID = %d)", aPrio,aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendMultiDisplayPopupFilterReqMsg(hmibase::ENABLE_PRIO, aPrio, aDisplayID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterAllEnableReqForDisplay(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacPopupFilterAllEnableReqForDisplay(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacPopupFilterAllEnableReqForDisplay(Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacPopupFilterAllEnableReqForDisplay(aDisplayID = %d)", aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendMultiDisplayPopupFilterReqMsg(hmibase::ENABLE_ALL, 0, aDisplayID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterDisableReqForDisplay(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacPopupFilterDisableReqForDisplay(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacPopupFilterDisableReqForDisplay(Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacPopupFilterDisableReqForDisplay(aDisplayID = %d)", aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendMultiDisplayPopupFilterReqMsg(hmibase::DISABLE_ALL, 0, aDisplayID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacStartSceneTransitionAnimation(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 4) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt() && parameters[(::Json::Value::UInt)2].isUInt() && parameters[(::Json::Value::UInt)3].isInt())) { return false; }
    Action_gacStartSceneTransitionAnimation(::Courier::ViewId(AppHmi_TunerStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt(), ))::Courier::ViewId(AppHmi_TunerStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)1].asUInt(), ))parameters[(::Json::Value::UInt)2].asUInt(), parameters[(::Json::Value::UInt)3].asInt());
    return true;
}
#endif
void Action_gacStartSceneTransitionAnimation(::Courier::ViewId const & aSourceView, ::Courier::ViewId const & aDestinationView, Courier::UInt32 const & aUserData1, Courier::Int8 const & aUserData2)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacStartSceneTransitionAnimation(aSourceView = %50s, aDestinationView = %50s, aUserData1 = %d, aUserData2 = %d)", aSourceView.CStr(),aDestinationView.CStr(),aUserData1,aUserData2));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendCreateNewDestroyOld(aSourceView, aDestinationView, aUserData1, aUserData2);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacDecrementActiveAnimationCount(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacDecrementActiveAnimationCount();
    return true;
}
#endif
void Action_gacDecrementActiveAnimationCount()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TUNER_SM, "SM_ACTIONS:    Trigger action gacDecrementActiveAnimationCount()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendNotifierMessage();
    COURIER_UNUSED(ok);
}
//====  defines and includes TTFis output - added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====    

unsigned short AppHmi_TunerStateMachineImpl::GetTraceClass (){  
   return TR_CLASS_APPHMI_TUNER_SM; 
}

//====  member function with TTFis output - end                        key: SM_TTFis_SBHFMSRF ==== 

#include "hmibase/util/Macros.h"

#ifdef CIT_SIMULATION
#define CIT_EVENT_ID(eventId, hashId) hashId
#else
#define CIT_EVENT_ID(eventId, hashId) eventId
#endif
// ------------------------------------------------------------------------

#if !defined onTopPopupSurfaceInvisible
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onTopPopupSurfaceInvisible 0xffff
#pragma _REMINDER("Using dummy value symbol onTopPopupSurfaceInvisible ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onTopPopupSurfaceInvisible -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onTopPopupSurfaceVisible
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onTopPopupSurfaceVisible 0xffff
#pragma _REMINDER("Using dummy value symbol onTopPopupSurfaceVisible ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onTopPopupSurfaceVisible -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onTopPopupSurfaceUnqueued
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onTopPopupSurfaceUnqueued 0xffff
#pragma _REMINDER("Using dummy value symbol onTopPopupSurfaceUnqueued ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onTopPopupSurfaceUnqueued -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onTopPopupSurfaceQueued
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onTopPopupSurfaceQueued 0xffff
#pragma _REMINDER("Using dummy value symbol onTopPopupSurfaceQueued ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onTopPopupSurfaceQueued -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onCenterPopupSurfaceInvisible
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onCenterPopupSurfaceInvisible 0xffff
#pragma _REMINDER("Using dummy value symbol onCenterPopupSurfaceInvisible ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onCenterPopupSurfaceInvisible -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onCenterPopupSurfaceVisible
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onCenterPopupSurfaceVisible 0xffff
#pragma _REMINDER("Using dummy value symbol onCenterPopupSurfaceVisible ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onCenterPopupSurfaceVisible -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onCenterPopupSurfaceUnqueued
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onCenterPopupSurfaceUnqueued 0xffff
#pragma _REMINDER("Using dummy value symbol onCenterPopupSurfaceUnqueued ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onCenterPopupSurfaceUnqueued -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onCenterPopupSurfaceQueued
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onCenterPopupSurfaceQueued 0xffff
#pragma _REMINDER("Using dummy value symbol onCenterPopupSurfaceQueued ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onCenterPopupSurfaceQueued -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onPopupInvisible
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onPopupInvisible 0xffff
#pragma _REMINDER("Using dummy value symbol onPopupInvisible ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onPopupInvisible -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onPopupVisible
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onPopupVisible 0xffff
#pragma _REMINDER("Using dummy value symbol onPopupVisible ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onPopupVisible -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onPopupUnqueued
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onPopupUnqueued 0xffff
#pragma _REMINDER("Using dummy value symbol onPopupUnqueued ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onPopupUnqueued -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onPopupQueued
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onPopupQueued 0xffff
#pragma _REMINDER("Using dummy value symbol onPopupQueued ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onPopupQueued -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForSurfaceStateChangedUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);

#ifdef onTopPopupSurfaceInvisible
    if ((message.GetSurfaceId() == SURFACEID_TOP_POPUP_SURFACE_TUNER) && (message.GetState() == SURFACESTATE_INVISIBLE)) { eventId = CIT_EVENT_ID(onTopPopupSurfaceInvisible, 0x3598CF84); return true; }
#endif
#ifdef onTopPopupSurfaceVisible
    if ((message.GetSurfaceId() == SURFACEID_TOP_POPUP_SURFACE_TUNER) && (message.GetState() == SURFACESTATE_VISIBLE)) { eventId = CIT_EVENT_ID(onTopPopupSurfaceVisible, 0x984F8ED8); return true; }
#endif
#ifdef onTopPopupSurfaceUnqueued
    if ((message.GetSurfaceId() == SURFACEID_TOP_POPUP_SURFACE_TUNER) && (message.GetState() == SURFACESTATE_UNQUEUED)) { eventId = CIT_EVENT_ID(onTopPopupSurfaceUnqueued, 0x912024BE); return true; }
#endif
#ifdef onTopPopupSurfaceQueued
    if ((message.GetSurfaceId() == SURFACEID_TOP_POPUP_SURFACE_TUNER) && (message.GetState() == SURFACESTATE_QUEUED)) { eventId = CIT_EVENT_ID(onTopPopupSurfaceQueued, 0xB630DDBD); return true; }
#endif
#ifdef onCenterPopupSurfaceInvisible
    if ((message.GetSurfaceId() == SURFACEID_CENTER_POPUP_SURFACE_TUNER) && (message.GetState() == SURFACESTATE_INVISIBLE)) { eventId = CIT_EVENT_ID(onCenterPopupSurfaceInvisible, 0x9BDB722F); return true; }
#endif
#ifdef onCenterPopupSurfaceVisible
    if ((message.GetSurfaceId() == SURFACEID_CENTER_POPUP_SURFACE_TUNER) && (message.GetState() == SURFACESTATE_VISIBLE)) { eventId = CIT_EVENT_ID(onCenterPopupSurfaceVisible, 0x23B97E51); return true; }
#endif
#ifdef onCenterPopupSurfaceUnqueued
    if ((message.GetSurfaceId() == SURFACEID_CENTER_POPUP_SURFACE_TUNER) && (message.GetState() == SURFACESTATE_UNQUEUED)) { eventId = CIT_EVENT_ID(onCenterPopupSurfaceUnqueued, 0xAA79C7DD); return true; }
#endif
#ifdef onCenterPopupSurfaceQueued
    if ((message.GetSurfaceId() == SURFACEID_CENTER_POPUP_SURFACE_TUNER) && (message.GetState() == SURFACESTATE_QUEUED)) { eventId = CIT_EVENT_ID(onCenterPopupSurfaceQueued, 0xFC0D2293); return true; }
#endif
#ifdef onPopupInvisible
    if ((message.GetState() == SURFACESTATE_INVISIBLE)) { eventId = CIT_EVENT_ID(onPopupInvisible, 0x6C1CD62F); return true; }
#endif
#ifdef onPopupVisible
    if ((message.GetState() == SURFACESTATE_VISIBLE)) { eventId = CIT_EVENT_ID(onPopupVisible, 0xB78D7AE0); return true; }
#endif
#ifdef onPopupUnqueued
    if ((message.GetState() == SURFACESTATE_UNQUEUED)) { eventId = CIT_EVENT_ID(onPopupUnqueued, 0xDB0D29F4); return true; }
#endif
#ifdef onPopupQueued
    if ((message.GetState() == SURFACESTATE_QUEUED)) { eventId = CIT_EVENT_ID(onPopupQueued, 0xBBE6896C); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSurfaceStateChangedUpdMsg(AppHmi_TunerStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
#ifdef onTopPopupSurfaceInvisible
    if (eventId == onTopPopupSurfaceInvisible) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_TunerStateMachineImpl::VS_Ret_Ok, AppHmi_TunerStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onTopPopupSurfaceInvisible.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onTopPopupSurfaceVisible
    if (eventId == onTopPopupSurfaceVisible) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_TunerStateMachineImpl::VS_Ret_Ok, AppHmi_TunerStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onTopPopupSurfaceVisible.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onTopPopupSurfaceUnqueued
    if (eventId == onTopPopupSurfaceUnqueued) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_TunerStateMachineImpl::VS_Ret_Ok, AppHmi_TunerStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onTopPopupSurfaceUnqueued.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onTopPopupSurfaceQueued
    if (eventId == onTopPopupSurfaceQueued) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_TunerStateMachineImpl::VS_Ret_Ok, AppHmi_TunerStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onTopPopupSurfaceQueued.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onCenterPopupSurfaceInvisible
    if (eventId == onCenterPopupSurfaceInvisible) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_TunerStateMachineImpl::VS_Ret_Ok, AppHmi_TunerStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onCenterPopupSurfaceInvisible.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onCenterPopupSurfaceVisible
    if (eventId == onCenterPopupSurfaceVisible) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_TunerStateMachineImpl::VS_Ret_Ok, AppHmi_TunerStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onCenterPopupSurfaceVisible.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onCenterPopupSurfaceUnqueued
    if (eventId == onCenterPopupSurfaceUnqueued) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_TunerStateMachineImpl::VS_Ret_Ok, AppHmi_TunerStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onCenterPopupSurfaceUnqueued.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onCenterPopupSurfaceQueued
    if (eventId == onCenterPopupSurfaceQueued) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_TunerStateMachineImpl::VS_Ret_Ok, AppHmi_TunerStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onCenterPopupSurfaceQueued.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onPopupInvisible
    if (eventId == onPopupInvisible) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_TunerStateMachineImpl::VS_Ret_Ok, AppHmi_TunerStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onPopupInvisible.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onPopupVisible
    if (eventId == onPopupVisible) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_TunerStateMachineImpl::VS_Ret_Ok, AppHmi_TunerStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onPopupVisible.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onPopupUnqueued
    if (eventId == onPopupUnqueued) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_TunerStateMachineImpl::VS_Ret_Ok, AppHmi_TunerStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onPopupUnqueued.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onPopupQueued
    if (eventId == onPopupQueued) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_TunerStateMachineImpl::VS_Ret_Ok, AppHmi_TunerStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onPopupQueued.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_TunerStateMachineImpl::VS_Ret_Ok, AppHmi_TunerStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForButtonReactionMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::ButtonReactionMsg const & message = static_cast< ::ButtonReactionMsg const &>(aMessage);

#ifdef OnButtonReactionMsg_TunerModule_Gadget_Tuner_MASTER_GADGET_TUNER_SEEKMENU_Btn_Previous_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#Gadget_Tuner#MASTER_GADGET_TUNER_SEEKMENU")) && (message.GetSender() == ::Courier::Identifier(0xd3bad9ef /* Btn_Previous/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_Gadget_Tuner_MASTER_GADGET_TUNER_SEEKMENU_Btn_Previous_ButtonWidget_enRelease, 0x8BEC3A21); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_1_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0x5e7e68f4 /* Layer_TouchArea_Preset_1/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_1_ButtonWidget_enRelease, 0xC9121B05); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_2_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0x966c3b3e /* Layer_TouchArea_Preset_2/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_2_ButtonWidget_enRelease, 0x015261B4); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_3_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0xaaaa6541 /* Layer_TouchArea_Preset_3/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_3_ButtonWidget_enRelease, 0xE523D3A8); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_4_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0x378f839d /* Layer_TouchArea_Preset_4/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_4_ButtonWidget_enRelease, 0x42E5E2BD); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_5_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0xd80bf0d5 /* Layer_TouchArea_Preset_5/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_5_ButtonWidget_enRelease, 0xB8797A9C); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_6_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0xad746719 /* Layer_TouchArea_Preset_6/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_6_ButtonWidget_enRelease, 0xA5873678); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_7_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0xf4b7f014 /* Layer_TouchArea_Preset_7/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_7_ButtonWidget_enRelease, 0x773FEDB7); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_BtnWidget2D_SrvList_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0xe8afbaab /* BtnWidget2D_SrvList */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_BtnWidget2D_SrvList_enRelease, 0x8865A921); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_8_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0x84fb073a /* Layer_TouchArea_Preset_8/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_8_ButtonWidget_enRelease, 0x90949826); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_10_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0xb9da2cf8 /* Layer_TouchArea_Preset_10/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_10_ButtonWidget_enRelease, 0x06D49744); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_11_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0x582a8787 /* Layer_TouchArea_Preset_11/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_11_ButtonWidget_enRelease, 0xBA8FD2E1); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_12_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0xf3c138d5 /* Layer_TouchArea_Preset_12/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_12_ButtonWidget_enRelease, 0xD3004684); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_1_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0x5e7e68f4 /* Layer_TouchArea_Preset_1/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_1_ButtonWidget_enShortPressRelease, 0x89E83E1B); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_2_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0x966c3b3e /* Layer_TouchArea_Preset_2/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_2_ButtonWidget_enShortPressRelease, 0xEADC7202); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_3_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0xaaaa6541 /* Layer_TouchArea_Preset_3/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_3_ButtonWidget_enShortPressRelease, 0x8C6B35A6); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_4_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0x378f839d /* Layer_TouchArea_Preset_4/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_4_ButtonWidget_enShortPressRelease, 0xEA01E2FE); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_9_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0xc48d7eaa /* Layer_TouchArea_Preset_9/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_9_ButtonWidget_enRelease, 0xD2A1A093); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_5_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0xd80bf0d5 /* Layer_TouchArea_Preset_5/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_5_ButtonWidget_enShortPressRelease, 0x9F73A258); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_SearchPrevious_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0xcd890a81 /* Layer_TouchArea_SearchPrevious/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_SearchPrevious_ButtonWidget_enRelease, 0xBC62D53B); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Source_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0xccdf81cf /* Layer_TouchArea_Source/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Source_ButtonWidget_enLongPress, 0x709A438A); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_OPT_DRMPTY_ButtonWidget2D_Back_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_OPT_DRMPTY")) && (message.GetSender() == ::Courier::Identifier(0xeca16c04 /* ButtonWidget2D_Back */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_OPT_DRMPTY_ButtonWidget2D_Back_enRelease, 0xBA1B1CF8); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AF_L_Button_Back_BG_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AF_L")) && (message.GetSender() == ::Courier::Identifier(0x408b82c4 /* Button_Back_BG/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AF_L_Button_Back_BG_ButtonWidget_enRelease, 0xF04BA5FB); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_TMC_Button_Back_BG_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_TMC")) && (message.GetSender() == ::Courier::Identifier(0x408b82c4 /* Button_Back_BG/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_TMC_Button_Back_BG_ButtonWidget_enRelease, 0xC083C5FF); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_TMC_Layer_TouchArea_MI_Btn_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_TMC")) && (message.GetSender() == ::Courier::Identifier(0xf0dcc8ec /* Layer_TouchArea_MI_Btn/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_TMC_Layer_TouchArea_MI_Btn_ButtonWidget_enRelease, 0x5040F034); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_TMC_Layer_TouchArea_TMCList_Btn_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_TMC")) && (message.GetSender() == ::Courier::Identifier(0xf24ca0fd /* Layer_TouchArea_TMCList_Btn/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_TMC_Layer_TouchArea_TMCList_Btn_ButtonWidget_enRelease, 0x4B98A712); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_TMC_INFO_Button_Back_BG_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_TMC_INFO")) && (message.GetSender() == ::Courier::Identifier(0x408b82c4 /* Button_Back_BG/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_TMC_INFO_Button_Back_BG_ButtonWidget_enRelease, 0xB93C4CE0); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_TMC_L_Button_Back_BG_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_TMC_L")) && (message.GetSender() == ::Courier::Identifier(0x408b82c4 /* Button_Back_BG/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_TMC_L_Button_Back_BG_ButtonWidget_enRelease, 0xEB8B66C5); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_SearchNext_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0x26924a2e /* Layer_TouchArea_SearchNext/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_SearchNext_ButtonWidget_enRelease, 0xD5538896); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_TMC_STN_INFO_ButtonWidget2D_Back_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_TMC_STN_INFO")) && (message.GetSender() == ::Courier::Identifier(0xeca16c04 /* ButtonWidget2D_Back */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_TMC_STN_INFO_ButtonWidget2D_Back_enRelease, 0x87B90622); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_SL_Textbox_DAB_Refresh_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB_SL")) && (message.GetSender() == ::Courier::Identifier(0x4564f83b /* Textbox_DAB_Refresh/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_SL_Textbox_DAB_Refresh_ButtonWidget_enRelease, 0x688FD8BA); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_SL_btn_2D_Listback_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM_SL")) && (message.GetSender() == ::Courier::Identifier(0x75909c21 /* btn_2D_Listback */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_SL_btn_2D_Listback_enRelease, 0x56D2150E); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_SL_ButtonWidget2D_Refresh_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM_SL")) && (message.GetSender() == ::Courier::Identifier(0x55055151 /* ButtonWidget2D_Refresh */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_SL_ButtonWidget2D_Refresh_enRelease, 0x63E9E1E7); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_Morepresets_Next_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0xc1dbda95 /* Layer_Morepresets_Next/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_Morepresets_Next_ButtonWidget_enRelease, 0x9B447C78); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_Morepresets_Previous_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0x3323c210 /* Layer_Morepresets_Previous/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_Morepresets_Previous_ButtonWidget_enRelease, 0xE152D781); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Source_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0xccdf81cf /* Layer_TouchArea_Source/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Source_ButtonWidget_enRelease, 0x1860E137); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Icon_StationList_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0x3bdb8384 /* Icon_StationList/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Icon_StationList_ButtonWidget_enRelease, 0x138652C2); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_SL_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB_SL")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_SL_Layer_TouchArea_Back_ButtonWidget_enRelease, 0x3818BE3A); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_6_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0xad746719 /* Layer_TouchArea_Preset_6/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_6_ButtonWidget_enShortPressRelease, 0xF134A2C7); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_7_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0xf4b7f014 /* Layer_TouchArea_Preset_7/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_7_ButtonWidget_enShortPressRelease, 0x2E700169); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_8_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0x84fb073a /* Layer_TouchArea_Preset_8/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_8_ButtonWidget_enShortPressRelease, 0xF4161A88); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_6_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0xad746719 /* Layer_TouchArea_Preset_6/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_6_ButtonWidget_enLongPressRelease, 0xC74B5E8C); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_7_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0xf4b7f014 /* Layer_TouchArea_Preset_7/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_7_ButtonWidget_enLongPressRelease, 0x78136700); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_8_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0x84fb073a /* Layer_TouchArea_Preset_8/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_8_ButtonWidget_enLongPressRelease, 0x0549AC85); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_9_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0xc48d7eaa /* Layer_TouchArea_Preset_9/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_9_ButtonWidget_enLongPressRelease, 0x36E80DF8); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_10_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0xb9da2cf8 /* Layer_TouchArea_Preset_10/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_10_ButtonWidget_enLongPressRelease, 0xB5167DD1); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_11_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0x582a8787 /* Layer_TouchArea_Preset_11/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_11_ButtonWidget_enLongPressRelease, 0x02F6CBBC); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_12_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0xf3c138d5 /* Layer_TouchArea_Preset_12/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_12_ButtonWidget_enLongPressRelease, 0x80E6540B); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_5_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0xd80bf0d5 /* Layer_TouchArea_Preset_5/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_5_ButtonWidget_enLongPressRelease, 0x2EB35D28); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_1_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0x5e7e68f4 /* Layer_TouchArea_Preset_1/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_1_ButtonWidget_enShortPress, 0x03B78DC8); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_3_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0xaaaa6541 /* Layer_TouchArea_Preset_3/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_3_ButtonWidget_enShortPress, 0xBE5C37AD); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_4_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0x378f839d /* Layer_TouchArea_Preset_4/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_4_ButtonWidget_enShortPress, 0x3642EBAB); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_5_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0xd80bf0d5 /* Layer_TouchArea_Preset_5/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_5_ButtonWidget_enShortPress, 0xFC81DB6F); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_6_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0xad746719 /* Layer_TouchArea_Preset_6/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_6_ButtonWidget_enShortPress, 0x976A09B4); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_7_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0xf4b7f014 /* Layer_TouchArea_Preset_7/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_7_ButtonWidget_enShortPress, 0x917DABBA); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_8_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0x84fb073a /* Layer_TouchArea_Preset_8/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_8_ButtonWidget_enShortPress, 0x95456C0F); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_9_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0xc48d7eaa /* Layer_TouchArea_Preset_9/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_9_ButtonWidget_enShortPress, 0x8285E7D3); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_2_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0x966c3b3e /* Layer_TouchArea_Preset_2/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_2_ButtonWidget_enShortPress, 0xEAED26D3); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_4_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0x378f839d /* Layer_TouchArea_Preset_4/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_4_ButtonWidget_enLongPressRelease, 0x8EC5014C); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_3_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0xaaaa6541 /* Layer_TouchArea_Preset_3/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_3_ButtonWidget_enLongPressRelease, 0x2A329016); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_2_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0x966c3b3e /* Layer_TouchArea_Preset_2/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_2_ButtonWidget_enLongPressRelease, 0x467ACF9C); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_9_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0xc48d7eaa /* Layer_TouchArea_Preset_9/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_9_ButtonWidget_enShortPressRelease, 0x28A75C83); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_10_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0xb9da2cf8 /* Layer_TouchArea_Preset_10/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_10_ButtonWidget_enShortPressRelease, 0x3465866F); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_11_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0x582a8787 /* Layer_TouchArea_Preset_11/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_11_ButtonWidget_enShortPressRelease, 0x75A8584F); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_12_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0xf3c138d5 /* Layer_TouchArea_Preset_12/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_12_ButtonWidget_enShortPressRelease, 0x52F1E9AD); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_1_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0x5e7e68f4 /* Layer_TouchArea_Preset_1/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_1_ButtonWidget_enLongPress, 0xE7E93734); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_2_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0x966c3b3e /* Layer_TouchArea_Preset_2/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_2_ButtonWidget_enLongPress, 0xE378A229); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_3_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0xaaaa6541 /* Layer_TouchArea_Preset_3/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_3_ButtonWidget_enLongPress, 0x3EAD6437); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_4_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0x378f839d /* Layer_TouchArea_Preset_4/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_4_ButtonWidget_enLongPress, 0x8BB0E160); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_5_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0xd80bf0d5 /* Layer_TouchArea_Preset_5/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_5_ButtonWidget_enLongPress, 0x3E0B649F); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_6_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0xad746719 /* Layer_TouchArea_Preset_6/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_6_ButtonWidget_enLongPress, 0xD0486B91); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_7_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0xf4b7f014 /* Layer_TouchArea_Preset_7/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_7_ButtonWidget_enLongPress, 0x5B7E23FD); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_8_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0x84fb073a /* Layer_TouchArea_Preset_8/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_8_ButtonWidget_enLongPress, 0x2D7C3716); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_9_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0xc48d7eaa /* Layer_TouchArea_Preset_9/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_9_ButtonWidget_enLongPress, 0xAFDDF6D0); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_10_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0xb9da2cf8 /* Layer_TouchArea_Preset_10/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_10_ButtonWidget_enLongPress, 0xE61A1D1E); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_11_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0x582a8787 /* Layer_TouchArea_Preset_11/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_11_ButtonWidget_enLongPress, 0x5A5076AA); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_12_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0xf3c138d5 /* Layer_TouchArea_Preset_12/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_12_ButtonWidget_enLongPress, 0x632C4A3E); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_1_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0x5e7e68f4 /* Layer_TouchArea_Preset_1/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_1_ButtonWidget_enLongPressRelease, 0xE9BE81F7); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_OPT_DABPTY_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_OPT_DABPTY")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_OPT_DABPTY_Layer_TouchArea_Back_ButtonWidget_enRelease, 0x44F76E1C); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_10_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0xb9da2cf8 /* Layer_TouchArea_Preset_10/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_10_ButtonWidget_enShortPress, 0x739F02A4); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_SL_Textbox_Refresh_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_SL")) && (message.GetSender() == ::Courier::Identifier(0x2164a059 /* Textbox_Refresh/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_SL_Textbox_Refresh_ButtonWidget_enRelease, 0xFCA3998F); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_SysPopupScene_Pfo_WB_Layer_TouchArea_Close_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#SysPopupScene#Pfo_WB")) && (message.GetSender() == ::Courier::Identifier(0x16e5a73b /* Layer_TouchArea_Close/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_SysPopupScene_Pfo_WB_Layer_TouchArea_Close_ButtonWidget_enRelease, 0x4929AFF0); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_SearchNext_ButtonWidget_enPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_AST")) && (message.GetSender() == ::Courier::Identifier(0x26924a2e /* Layer_TouchArea_SearchNext/ButtonWidget */)) && (message.GetEnReaction() == enPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_SearchNext_ButtonWidget_enPress, 0xFC44999C); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_SearchPrevious_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_AST")) && (message.GetSender() == ::Courier::Identifier(0xcd890a81 /* Layer_TouchArea_SearchPrevious/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_SearchPrevious_ButtonWidget_enShortPress, 0x42CAB902); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_SearchNext_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_AST")) && (message.GetSender() == ::Courier::Identifier(0x26924a2e /* Layer_TouchArea_SearchNext/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_SearchNext_ButtonWidget_enShortPress, 0x424C871A); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_SearchPrevious_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_AST")) && (message.GetSender() == ::Courier::Identifier(0xcd890a81 /* Layer_TouchArea_SearchPrevious/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_SearchPrevious_ButtonWidget_enRelease, 0xF2C5B921); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_SearchNext_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_AST")) && (message.GetSender() == ::Courier::Identifier(0x26924a2e /* Layer_TouchArea_SearchNext/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_SearchNext_ButtonWidget_enRelease, 0xD429810F); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_SearchPrevious_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_AST")) && (message.GetSender() == ::Courier::Identifier(0xcd890a81 /* Layer_TouchArea_SearchPrevious/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_SearchPrevious_ButtonWidget_enShortPressRelease, 0x4B30E7BC); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_SearchNext_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_AST")) && (message.GetSender() == ::Courier::Identifier(0x26924a2e /* Layer_TouchArea_SearchNext/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_SearchNext_ButtonWidget_enShortPressRelease, 0x0468C1FE); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_SearchPrevious_ButtonWidget_enPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_AST")) && (message.GetSender() == ::Courier::Identifier(0xcd890a81 /* Layer_TouchArea_SearchPrevious/ButtonWidget */)) && (message.GetEnReaction() == enPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_SearchPrevious_ButtonWidget_enPress, 0x22D7C31B); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_SearchPrevious_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_AST")) && (message.GetSender() == ::Courier::Identifier(0xcd890a81 /* Layer_TouchArea_SearchPrevious/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_SearchPrevious_ButtonWidget_enLongPressRelease, 0x5005F0B4); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_TouchArea_FreqStepUp_normal_Button_enPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_AST")) && (message.GetSender() == ::Courier::Identifier(0x558a16a3 /* TouchArea_FreqStepUp_normal/Button */)) && (message.GetEnReaction() == enPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_TouchArea_FreqStepUp_normal_Button_enPress, 0x75B01051); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_TouchArea_FreqStepDown_normal_Button_enPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_AST")) && (message.GetSender() == ::Courier::Identifier(0x2be9f953 /* TouchArea_FreqStepDown_normal/Button */)) && (message.GetEnReaction() == enPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_TouchArea_FreqStepDown_normal_Button_enPress, 0x6BACA7C9); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_TouchArea_FreqStepUp_normal_Button_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_AST")) && (message.GetSender() == ::Courier::Identifier(0x558a16a3 /* TouchArea_FreqStepUp_normal/Button */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_TouchArea_FreqStepUp_normal_Button_enShortPressRelease, 0xEF82F558); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_TouchArea_FreqStepDown_normal_Button_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_AST")) && (message.GetSender() == ::Courier::Identifier(0x2be9f953 /* TouchArea_FreqStepDown_normal/Button */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_TouchArea_FreqStepDown_normal_Button_enShortPressRelease, 0x77A70231); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_TouchArea_FreqStepUp_normal_Button_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_AST")) && (message.GetSender() == ::Courier::Identifier(0x558a16a3 /* TouchArea_FreqStepUp_normal/Button */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_TouchArea_FreqStepUp_normal_Button_enRelease, 0x648B1681); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_TouchArea_FreqStepDown_normal_Button_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_AST")) && (message.GetSender() == ::Courier::Identifier(0x2be9f953 /* TouchArea_FreqStepDown_normal/Button */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_TouchArea_FreqStepDown_normal_Button_enRelease, 0x33B37821); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_TouchArea_FreqStepUp_normal_Button_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_AST")) && (message.GetSender() == ::Courier::Identifier(0x558a16a3 /* TouchArea_FreqStepUp_normal/Button */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_TouchArea_FreqStepUp_normal_Button_enShortPress, 0xFCCF4309); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_SearchNext_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_AST")) && (message.GetSender() == ::Courier::Identifier(0x26924a2e /* Layer_TouchArea_SearchNext/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_SearchNext_ButtonWidget_enLongPressRelease, 0xC33EB086); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_TouchArea_FreqStepDown_normal_Button_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_AST")) && (message.GetSender() == ::Courier::Identifier(0x2be9f953 /* TouchArea_FreqStepDown_normal/Button */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_TouchArea_FreqStepDown_normal_Button_enShortPress, 0xDF785CFC); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_6_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_AST")) && (message.GetSender() == ::Courier::Identifier(0x4d32eac1 /* Layer_TouchArea_PresetAST_6/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_6_ButtonWidget_enLongPressRelease, 0x04BD7A18); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_4_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_AST")) && (message.GetSender() == ::Courier::Identifier(0x427883c0 /* Layer_TouchArea_PresetAST_4/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_4_ButtonWidget_enLongPressRelease, 0x3F266E1A); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_6_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_AST")) && (message.GetSender() == ::Courier::Identifier(0x4d32eac1 /* Layer_TouchArea_PresetAST_6/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_6_ButtonWidget_enShortPress, 0x14E169E6); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_1_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_AST")) && (message.GetSender() == ::Courier::Identifier(0x7a1cabdb /* Layer_TouchArea_PresetAST_1/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_1_ButtonWidget_enShortPressRelease, 0x46F47D46); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_2_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_AST")) && (message.GetSender() == ::Courier::Identifier(0x39c4e83d /* Layer_TouchArea_PresetAST_2/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_2_ButtonWidget_enShortPressRelease, 0x3644357E); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_3_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_AST")) && (message.GetSender() == ::Courier::Identifier(0xf6b6489f /* Layer_TouchArea_PresetAST_3/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_3_ButtonWidget_enShortPressRelease, 0x5DCF6307); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_4_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_AST")) && (message.GetSender() == ::Courier::Identifier(0x427883c0 /* Layer_TouchArea_PresetAST_4/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_4_ButtonWidget_enShortPressRelease, 0x14823131); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_5_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_AST")) && (message.GetSender() == ::Courier::Identifier(0x134d2804 /* Layer_TouchArea_PresetAST_5/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_5_ButtonWidget_enShortPressRelease, 0xA2B6972C); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_6_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_AST")) && (message.GetSender() == ::Courier::Identifier(0x4d32eac1 /* Layer_TouchArea_PresetAST_6/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_6_ButtonWidget_enShortPressRelease, 0x6DC70E23); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_5_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_AST")) && (message.GetSender() == ::Courier::Identifier(0x134d2804 /* Layer_TouchArea_PresetAST_5/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_5_ButtonWidget_enLongPressRelease, 0x643F2DFC); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_1_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_AST")) && (message.GetSender() == ::Courier::Identifier(0x7a1cabdb /* Layer_TouchArea_PresetAST_1/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_1_ButtonWidget_enLongPress, 0x70567793); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_3_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_AST")) && (message.GetSender() == ::Courier::Identifier(0xf6b6489f /* Layer_TouchArea_PresetAST_3/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_3_ButtonWidget_enLongPress, 0x69032EDE); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_4_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_AST")) && (message.GetSender() == ::Courier::Identifier(0x427883c0 /* Layer_TouchArea_PresetAST_4/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_4_ButtonWidget_enLongPress, 0xD1E8EA69); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_5_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_AST")) && (message.GetSender() == ::Courier::Identifier(0x134d2804 /* Layer_TouchArea_PresetAST_5/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_5_ButtonWidget_enLongPress, 0x7012A7D5); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_6_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_AST")) && (message.GetSender() == ::Courier::Identifier(0x4d32eac1 /* Layer_TouchArea_PresetAST_6/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_6_ButtonWidget_enLongPress, 0x8AB3157F); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_1_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_AST")) && (message.GetSender() == ::Courier::Identifier(0x7a1cabdb /* Layer_TouchArea_PresetAST_1/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_1_ButtonWidget_enLongPressRelease, 0x43E1179C); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_2_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_AST")) && (message.GetSender() == ::Courier::Identifier(0x39c4e83d /* Layer_TouchArea_PresetAST_2/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_2_ButtonWidget_enLongPressRelease, 0xEFA05524); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_3_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_AST")) && (message.GetSender() == ::Courier::Identifier(0xf6b6489f /* Layer_TouchArea_PresetAST_3/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_3_ButtonWidget_enLongPressRelease, 0x40684ACE); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_2_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_AST")) && (message.GetSender() == ::Courier::Identifier(0x39c4e83d /* Layer_TouchArea_PresetAST_2/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_2_ButtonWidget_enLongPress, 0xB4C26420); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_TouchArea_FreqStepUp_normal_Button_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_AST")) && (message.GetSender() == ::Courier::Identifier(0x558a16a3 /* TouchArea_FreqStepUp_normal/Button */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_TouchArea_FreqStepUp_normal_Button_enLongPressRelease, 0xEF9C0DD4); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_TouchArea_FreqStepDown_normal_Button_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_AST")) && (message.GetSender() == ::Courier::Identifier(0x2be9f953 /* TouchArea_FreqStepDown_normal/Button */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_TouchArea_FreqStepDown_normal_Button_enLongPressRelease, 0xE35725F1); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_Layer_TouchArea_Source_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_SourceSelection_Radio")) && (message.GetSender() == ::Courier::Identifier(0xccdf81cf /* Layer_TouchArea_Source/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_Layer_TouchArea_Source_ButtonWidget_enRelease, 0x5A2A3D96); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_woNav_Layer_TouchArea_Source_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_SourceSelection_Radio_woNav")) && (message.GetSender() == ::Courier::Identifier(0xccdf81cf /* Layer_TouchArea_Source/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_woNav_Layer_TouchArea_Source_ButtonWidget_enRelease, 0x2610D62E); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_woNav_btn_bn_Back_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_SourceSelection_Radio_woNav")) && (message.GetSender() == ::Courier::Identifier(0xa557383e /* btn_bn_Back */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_woNav_btn_bn_Back_enLongPress, 0xB7A4E868); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_woNav_Layer_TouchArea_FM1_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_SourceSelection_Radio_woNav")) && (message.GetSender() == ::Courier::Identifier(0xbc8c8b2e /* Layer_TouchArea_FM1/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_woNav_Layer_TouchArea_FM1_ButtonWidget_enRelease, 0xD3BE2331); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_woNav_Layer_TouchArea_FM2_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_SourceSelection_Radio_woNav")) && (message.GetSender() == ::Courier::Identifier(0x76cd0510 /* Layer_TouchArea_FM2/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_woNav_Layer_TouchArea_FM2_ButtonWidget_enRelease, 0x9FF839A2); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_woNav_Layer_TouchArea_FM_AST_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_SourceSelection_Radio_woNav")) && (message.GetSender() == ::Courier::Identifier(0x57beb9bf /* Layer_TouchArea_FM_AST/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_woNav_Layer_TouchArea_FM_AST_ButtonWidget_enRelease, 0xB89FB055); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_woNav_Layer_TouchArea_AM_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_SourceSelection_Radio_woNav")) && (message.GetSender() == ::Courier::Identifier(0xec86b34e /* Layer_TouchArea_AM/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_woNav_Layer_TouchArea_AM_ButtonWidget_enRelease, 0xC5F831A7); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_woNav_Layer_TouchArea_AM_AST_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_SourceSelection_Radio_woNav")) && (message.GetSender() == ::Courier::Identifier(0xdf82042e /* Layer_TouchArea_AM_AST/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_woNav_Layer_TouchArea_AM_AST_ButtonWidget_enRelease, 0x5D802F26); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_OPT_FMAM_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_OPT_FMAM")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_OPT_FMAM_Layer_TouchArea_Back_ButtonWidget_enRelease, 0xFE44954B); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_woNav_Layer_TouchArea_DAB_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_SourceSelection_Radio_woNav")) && (message.GetSender() == ::Courier::Identifier(0x7e2a8142 /* Layer_TouchArea_DAB/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_woNav_Layer_TouchArea_DAB_ButtonWidget_enRelease, 0xFF542F13); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_woNav_btn_bn_DRM_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_SourceSelection_Radio_woNav")) && (message.GetSender() == ::Courier::Identifier(0x9e048b7f /* btn_bn_DRM */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_woNav_btn_bn_DRM_enRelease, 0x3F7F073A); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_woNav_btn_bn_DRM_AST_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_SourceSelection_Radio_woNav")) && (message.GetSender() == ::Courier::Identifier(0x93e8ae7c /* btn_bn_DRM_AST */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_woNav_btn_bn_DRM_AST_enRelease, 0x13429ED7); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_TestMode_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_TestMode")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_TestMode_Layer_TouchArea_Back_ButtonWidget_enRelease, 0x3F2DFD1E); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_TestMode_btn_bn_back_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_TestMode")) && (message.GetSender() == ::Courier::Identifier(0x9b7f61fb /* btn_bn_back */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_TestMode_btn_bn_back_enRelease, 0xB260BE9D); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_TestMode_btn_bn_back_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM_TestMode")) && (message.GetSender() == ::Courier::Identifier(0x9b7f61fb /* btn_bn_back */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_TestMode_btn_bn_back_enRelease, 0x6836C622); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_TestModeScreen_btn_bn_back_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM_TestModeScreen")) && (message.GetSender() == ::Courier::Identifier(0x9b7f61fb /* btn_bn_back */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_TestModeScreen_btn_bn_back_enRelease, 0x05BF93FA); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_SysPopupScene_Pfo_TA_Layer_TouchArea_Close_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#SysPopupScene#Pfo_TA")) && (message.GetSender() == ::Courier::Identifier(0x16e5a73b /* Layer_TouchArea_Close/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_SysPopupScene_Pfo_TA_Layer_TouchArea_Close_ButtonWidget_enRelease, 0x83577BF8); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_woNav_Layer_TouchArea_DAB_AST_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_SourceSelection_Radio_woNav")) && (message.GetSender() == ::Courier::Identifier(0x7236dbf1 /* Layer_TouchArea_DAB_AST/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_woNav_Layer_TouchArea_DAB_AST_ButtonWidget_enRelease, 0x95881864); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_woNav_Layer_TouchArea_Settings_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_SourceSelection_Radio_woNav")) && (message.GetSender() == ::Courier::Identifier(0x67fef3d9 /* Layer_TouchArea_Settings/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_woNav_Layer_TouchArea_Settings_ButtonWidget_enRelease, 0x14530E0D); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_Layer_TouchArea_Settings_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_SourceSelection_Radio")) && (message.GetSender() == ::Courier::Identifier(0x67fef3d9 /* Layer_TouchArea_Settings/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_Layer_TouchArea_Settings_ButtonWidget_enRelease, 0xFE869C7D); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_btn_bn_DRM_AST_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_SourceSelection_Radio")) && (message.GetSender() == ::Courier::Identifier(0x93e8ae7c /* btn_bn_DRM_AST */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_btn_bn_DRM_AST_enRelease, 0x486E3FC6); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_Layer_TouchArea_Source_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_SourceSelection_Radio")) && (message.GetSender() == ::Courier::Identifier(0xccdf81cf /* Layer_TouchArea_Source/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_Layer_TouchArea_Source_ButtonWidget_enLongPress, 0x343000AE); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_Layer_TabRadio_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_SourceSelection_Radio")) && (message.GetSender() == ::Courier::Identifier(0xe38eb662 /* Layer_TabRadio/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_Layer_TabRadio_ButtonWidget_enRelease, 0x780E9DC5); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_Layer_TabMedia_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_SourceSelection_Radio")) && (message.GetSender() == ::Courier::Identifier(0xcd18e96c /* Layer_TabMedia/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_Layer_TabMedia_ButtonWidget_enRelease, 0x49BC07AF); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_Layer_TouchArea_FM1_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_SourceSelection_Radio")) && (message.GetSender() == ::Courier::Identifier(0xbc8c8b2e /* Layer_TouchArea_FM1/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_Layer_TouchArea_FM1_ButtonWidget_enRelease, 0xEBABC23E); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_Layer_TouchArea_WX_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_SourceSelection_Radio")) && (message.GetSender() == ::Courier::Identifier(0xd9368aa5 /* Layer_TouchArea_WX/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_Layer_TouchArea_WX_ButtonWidget_enRelease, 0x5C7285E2); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_Layer_TouchArea_FM1_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_SourceSelection_Radio")) && (message.GetSender() == ::Courier::Identifier(0xbc8c8b2e /* Layer_TouchArea_FM1/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_Layer_TouchArea_FM1_ButtonWidget_enLongPress, 0xE407E367); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_Layer_TouchArea_AM_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_SourceSelection_Radio")) && (message.GetSender() == ::Courier::Identifier(0xec86b34e /* Layer_TouchArea_AM/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_Layer_TouchArea_AM_ButtonWidget_enLongPress, 0x541E7C20); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_Layer_TouchArea_AM_AST_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_SourceSelection_Radio")) && (message.GetSender() == ::Courier::Identifier(0xdf82042e /* Layer_TouchArea_AM_AST/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_Layer_TouchArea_AM_AST_ButtonWidget_enLongPress, 0x9E435EA0); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_Layer_TouchArea_DAB_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_SourceSelection_Radio")) && (message.GetSender() == ::Courier::Identifier(0x7e2a8142 /* Layer_TouchArea_DAB/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_Layer_TouchArea_DAB_ButtonWidget_enLongPress, 0x343ADE0C); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_Layer_TouchArea_FM2_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_SourceSelection_Radio")) && (message.GetSender() == ::Courier::Identifier(0x76cd0510 /* Layer_TouchArea_FM2/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_Layer_TouchArea_FM2_ButtonWidget_enRelease, 0x78793CCA); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_Layer_TouchArea_FM_AST_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_SourceSelection_Radio")) && (message.GetSender() == ::Courier::Identifier(0x57beb9bf /* Layer_TouchArea_FM_AST/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_Layer_TouchArea_FM_AST_ButtonWidget_enRelease, 0x482D0533); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_Layer_TouchArea_AM_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_SourceSelection_Radio")) && (message.GetSender() == ::Courier::Identifier(0xec86b34e /* Layer_TouchArea_AM/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_Layer_TouchArea_AM_ButtonWidget_enRelease, 0xCD02F822); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_Layer_TouchArea_AM_AST_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_SourceSelection_Radio")) && (message.GetSender() == ::Courier::Identifier(0xdf82042e /* Layer_TouchArea_AM_AST/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_Layer_TouchArea_AM_AST_ButtonWidget_enRelease, 0x2D07BF19); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_Layer_TouchArea_DAB_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_SourceSelection_Radio")) && (message.GetSender() == ::Courier::Identifier(0x7e2a8142 /* Layer_TouchArea_DAB/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_Layer_TouchArea_DAB_ButtonWidget_enRelease, 0xB48C0E48); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_Layer_TouchArea_DAB_AST_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_SourceSelection_Radio")) && (message.GetSender() == ::Courier::Identifier(0x7236dbf1 /* Layer_TouchArea_DAB_AST/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_Layer_TouchArea_DAB_AST_ButtonWidget_enRelease, 0x4FF96538); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_Layer_TouchArea_SXM_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_SourceSelection_Radio")) && (message.GetSender() == ::Courier::Identifier(0xf2e94041 /* Layer_TouchArea_SXM/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_Layer_TouchArea_SXM_ButtonWidget_enRelease, 0x8F85F10D); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_btn_bn_DRM_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_SourceSelection_Radio")) && (message.GetSender() == ::Courier::Identifier(0x9e048b7f /* btn_bn_DRM */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_btn_bn_DRM_enRelease, 0x53757BD9); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_SL_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_SL")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_SL_Layer_TouchArea_Back_ButtonWidget_enRelease, 0x75FC0286); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_11_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0x582a8787 /* Layer_TouchArea_Preset_11/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_11_ButtonWidget_enShortPress, 0xFE273262); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_12_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB")) && (message.GetSender() == ::Courier::Identifier(0xf3c138d5 /* Layer_TouchArea_Preset_12/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_12_ButtonWidget_enShortPress, 0xB99E1FBF); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_Source_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB_AST")) && (message.GetSender() == ::Courier::Identifier(0xccdf81cf /* Layer_TouchArea_Source/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_Source_ButtonWidget_enRelease, 0x25BFA40A); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor3_Layer_TouchArea_Next_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_Triple_Tuner_Monitor3")) && (message.GetSender() == ::Courier::Identifier(0x4e7f0732 /* Layer_TouchArea_Next/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor3_Layer_TouchArea_Next_ButtonWidget_enRelease, 0xD9EB460F); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor3_Layer_TouchArea_Stepup_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_Triple_Tuner_Monitor3")) && (message.GetSender() == ::Courier::Identifier(0x4817fece /* Layer_TouchArea_Stepup/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor3_Layer_TouchArea_Stepup_ButtonWidget_enRelease, 0x84695A6A); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor3_Layer_TouchArea_Stepdown_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_Triple_Tuner_Monitor3")) && (message.GetSender() == ::Courier::Identifier(0x704386f1 /* Layer_TouchArea_Stepdown/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor3_Layer_TouchArea_Stepdown_ButtonWidget_enRelease, 0x001FF9F7); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor3_Layer_TouchArea_Seekdn_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_Triple_Tuner_Monitor3")) && (message.GetSender() == ::Courier::Identifier(0x3ca8043c /* Layer_TouchArea_Seekdn/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor3_Layer_TouchArea_Seekdn_ButtonWidget_enRelease, 0xB25CCDEA); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor3_Layer_TouchArea_Seekup_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_Triple_Tuner_Monitor3")) && (message.GetSender() == ::Courier::Identifier(0xc732cea4 /* Layer_TouchArea_Seekup/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor3_Layer_TouchArea_Seekup_ButtonWidget_enRelease, 0x6DC9A9A6); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor3_Textbox_Tuner1_Band_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_Triple_Tuner_Monitor3")) && (message.GetSender() == ::Courier::Identifier(0xe83731d1 /* Textbox_Tuner1_Band/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor3_Textbox_Tuner1_Band_ButtonWidget_enRelease, 0xE6E08B93); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor3_Textbox_Tuner2_Band_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_Triple_Tuner_Monitor3")) && (message.GetSender() == ::Courier::Identifier(0x016a8f1d /* Textbox_Tuner2_Band/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor3_Textbox_Tuner2_Band_ButtonWidget_enRelease, 0x30E74B2A); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor3_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_Triple_Tuner_Monitor3")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor3_Layer_TouchArea_Back_ButtonWidget_enRelease, 0x14F2D1BD); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor3_Textbox_Tuner3_Band_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_Triple_Tuner_Monitor3")) && (message.GetSender() == ::Courier::Identifier(0xc5610203 /* Textbox_Tuner3_Band/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor3_Textbox_Tuner3_Band_ButtonWidget_enRelease, 0xD40210B1); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor3_Textbox_Tuner1_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_Triple_Tuner_Monitor3")) && (message.GetSender() == ::Courier::Identifier(0xf2170da7 /* Textbox_Tuner1/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor3_Textbox_Tuner1_ButtonWidget_enRelease, 0xEBAD5EF0); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor3_Textbox_Tuner2_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_Triple_Tuner_Monitor3")) && (message.GetSender() == ::Courier::Identifier(0xb39448a5 /* Textbox_Tuner2/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor3_Textbox_Tuner2_ButtonWidget_enRelease, 0xEF84BB83); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor3_Textbox_Tuner3_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_Triple_Tuner_Monitor3")) && (message.GetSender() == ::Courier::Identifier(0x3d3df8b4 /* Textbox_Tuner3/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor3_Textbox_Tuner3_ButtonWidget_enRelease, 0xB1F2BE43); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor3_Textbox_Tuner4_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_Triple_Tuner_Monitor3")) && (message.GetSender() == ::Courier::Identifier(0x70d5bb8b /* Textbox_Tuner4/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor3_Textbox_Tuner4_ButtonWidget_enRelease, 0x4355EC8F); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_WeatherBand_Layer_TouchArea_Preset_1_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_WeatherBand")) && (message.GetSender() == ::Courier::Identifier(0x5e7e68f4 /* Layer_TouchArea_Preset_1/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_WeatherBand_Layer_TouchArea_Preset_1_ButtonWidget_enRelease, 0xE058329F); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_WeatherBand_Layer_TouchArea_Preset_2_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_WeatherBand")) && (message.GetSender() == ::Courier::Identifier(0x966c3b3e /* Layer_TouchArea_Preset_2/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_WeatherBand_Layer_TouchArea_Preset_2_ButtonWidget_enRelease, 0x65FEA9EA); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_WeatherBand_Layer_TouchArea_Preset_3_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_WeatherBand")) && (message.GetSender() == ::Courier::Identifier(0xaaaa6541 /* Layer_TouchArea_Preset_3/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_WeatherBand_Layer_TouchArea_Preset_3_ButtonWidget_enRelease, 0xE24A8671); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor3_Textbox_Tuner4_Band_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_Triple_Tuner_Monitor3")) && (message.GetSender() == ::Courier::Identifier(0xcdc4eb74 /* Textbox_Tuner4_Band/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor3_Textbox_Tuner4_Band_ButtonWidget_enRelease, 0x792B324E); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_WeatherBand_Layer_TouchArea_Preset_4_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_WeatherBand")) && (message.GetSender() == ::Courier::Identifier(0x378f839d /* Layer_TouchArea_Preset_4/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_WeatherBand_Layer_TouchArea_Preset_4_ButtonWidget_enRelease, 0x67B9330C); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor2_Textbox_Tuner_AF_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_Triple_Tuner_Monitor2")) && (message.GetSender() == ::Courier::Identifier(0x2fa8a518 /* Textbox_Tuner_AF/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor2_Textbox_Tuner_AF_ButtonWidget_enRelease, 0x2A2BE4E5); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor2_Textbox_Tuner3_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_Triple_Tuner_Monitor2")) && (message.GetSender() == ::Courier::Identifier(0x3d3df8b4 /* Textbox_Tuner3/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor2_Textbox_Tuner3_ButtonWidget_enRelease, 0x750AED3C); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor_Textbox_Tuner1_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_Triple_Tuner_Monitor")) && (message.GetSender() == ::Courier::Identifier(0xf2170da7 /* Textbox_Tuner1/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor_Textbox_Tuner1_ButtonWidget_enRelease, 0x32F5257F); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor_Textbox_Tuner2_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_Triple_Tuner_Monitor")) && (message.GetSender() == ::Courier::Identifier(0xb39448a5 /* Textbox_Tuner2/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor_Textbox_Tuner2_ButtonWidget_enRelease, 0xB1FA49FF); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor_Textbox_Tuner3_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_Triple_Tuner_Monitor")) && (message.GetSender() == ::Courier::Identifier(0x3d3df8b4 /* Textbox_Tuner3/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor_Textbox_Tuner3_ButtonWidget_enRelease, 0x7183D0B3); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor_Textbox_Tuner4_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_Triple_Tuner_Monitor")) && (message.GetSender() == ::Courier::Identifier(0x70d5bb8b /* Textbox_Tuner4/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor_Textbox_Tuner4_ButtonWidget_enRelease, 0xB6FA2484); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor2_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_Triple_Tuner_Monitor2")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor2_Layer_TouchArea_Back_ButtonWidget_enRelease, 0x1F395E4B); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor2_Layer_TouchArea_Next_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_Triple_Tuner_Monitor2")) && (message.GetSender() == ::Courier::Identifier(0x4e7f0732 /* Layer_TouchArea_Next/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor2_Layer_TouchArea_Next_ButtonWidget_enRelease, 0xD00FE9F0); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor2_Layer_TouchArea_Stepup_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_Triple_Tuner_Monitor2")) && (message.GetSender() == ::Courier::Identifier(0x4817fece /* Layer_TouchArea_Stepup/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor2_Layer_TouchArea_Stepup_ButtonWidget_enRelease, 0xBF68CB5D); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor2_Textbox_Tuner4_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_Triple_Tuner_Monitor2")) && (message.GetSender() == ::Courier::Identifier(0x70d5bb8b /* Textbox_Tuner4/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor2_Textbox_Tuner4_ButtonWidget_enRelease, 0x251277CC); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor2_Layer_TouchArea_Stepdown_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_Triple_Tuner_Monitor2")) && (message.GetSender() == ::Courier::Identifier(0x704386f1 /* Layer_TouchArea_Stepdown/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor2_Layer_TouchArea_Stepdown_ButtonWidget_enRelease, 0x7AB600C4); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor2_Layer_TouchArea_Seekup_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_Triple_Tuner_Monitor2")) && (message.GetSender() == ::Courier::Identifier(0xc732cea4 /* Layer_TouchArea_Seekup/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor2_Layer_TouchArea_Seekup_ButtonWidget_enRelease, 0xC3490FBE); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor2_Textbox_Tuner1_Band_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_Triple_Tuner_Monitor2")) && (message.GetSender() == ::Courier::Identifier(0xe83731d1 /* Textbox_Tuner1_Band/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor2_Textbox_Tuner1_Band_ButtonWidget_enRelease, 0x4CFF2268); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor2_Textbox_Tuner2_Band_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_Triple_Tuner_Monitor2")) && (message.GetSender() == ::Courier::Identifier(0x016a8f1d /* Textbox_Tuner2_Band/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor2_Textbox_Tuner2_Band_ButtonWidget_enRelease, 0x8EE29EF7); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor2_Textbox_Tuner3_Band_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_Triple_Tuner_Monitor2")) && (message.GetSender() == ::Courier::Identifier(0xc5610203 /* Textbox_Tuner3_Band/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor2_Textbox_Tuner3_Band_ButtonWidget_enRelease, 0x3945D700); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor2_Textbox_Tuner4_Band_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_Triple_Tuner_Monitor2")) && (message.GetSender() == ::Courier::Identifier(0xcdc4eb74 /* Textbox_Tuner4_Band/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor2_Textbox_Tuner4_Band_ButtonWidget_enRelease, 0x86DD782C); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor2_Textbox_Tuner1_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_Triple_Tuner_Monitor2")) && (message.GetSender() == ::Courier::Identifier(0xf2170da7 /* Textbox_Tuner1/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor2_Textbox_Tuner1_ButtonWidget_enRelease, 0x7AE0F2C1); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor2_Textbox_Tuner2_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_Triple_Tuner_Monitor2")) && (message.GetSender() == ::Courier::Identifier(0xb39448a5 /* Textbox_Tuner2/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor2_Textbox_Tuner2_ButtonWidget_enRelease, 0x46F4928D); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor2_Layer_TouchArea_Seekdn_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_Triple_Tuner_Monitor2")) && (message.GetSender() == ::Courier::Identifier(0x3ca8043c /* Layer_TouchArea_Seekdn/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor2_Layer_TouchArea_Seekdn_ButtonWidget_enRelease, 0xD778EF92); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_WeatherBand_Layer_TouchArea_Preset_5_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_WeatherBand")) && (message.GetSender() == ::Courier::Identifier(0xd80bf0d5 /* Layer_TouchArea_Preset_5/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_WeatherBand_Layer_TouchArea_Preset_5_ButtonWidget_enRelease, 0x400C5518); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_WeatherBand_Layer_TouchArea_Preset_6_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_WeatherBand")) && (message.GetSender() == ::Courier::Identifier(0xad746719 /* Layer_TouchArea_Preset_6/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_WeatherBand_Layer_TouchArea_Preset_6_ButtonWidget_enRelease, 0x0C42F435); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_WeatherBand_Layer_TouchArea_Preset_7_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_WeatherBand")) && (message.GetSender() == ::Courier::Identifier(0xf4b7f014 /* Layer_TouchArea_Preset_7/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_WeatherBand_Layer_TouchArea_Preset_7_ButtonWidget_enRelease, 0xF9C3DD76); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Service_Info_TestMode_Layer_TouchArea_Seekdn_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB_Service_Info_TestMode")) && (message.GetSender() == ::Courier::Identifier(0x3ca8043c /* Layer_TouchArea_Seekdn/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Service_Info_TestMode_Layer_TouchArea_Seekdn_ButtonWidget_enRelease, 0xDEE3206F); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Service_Info_TestMode_Layer_TouchArea_Stepup_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB_Service_Info_TestMode")) && (message.GetSender() == ::Courier::Identifier(0x4817fece /* Layer_TouchArea_Stepup/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Service_Info_TestMode_Layer_TouchArea_Stepup_ButtonWidget_enRelease, 0x1A7DE978); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Service_Info_TestMode_Layer_TouchArea_Stepdown_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB_Service_Info_TestMode")) && (message.GetSender() == ::Courier::Identifier(0x704386f1 /* Layer_TouchArea_Stepdown/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Service_Info_TestMode_Layer_TouchArea_Stepdown_ButtonWidget_enRelease, 0x87211F5A); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Expert_API_TestMode_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB_Expert_API_TestMode")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Expert_API_TestMode_Layer_TouchArea_Back_ButtonWidget_enRelease, 0x5B90107A); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Expert_API_TestMode_Layer_TouchArea_Next_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB_Expert_API_TestMode")) && (message.GetSender() == ::Courier::Identifier(0x4e7f0732 /* Layer_TouchArea_Next/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Expert_API_TestMode_Layer_TouchArea_Next_ButtonWidget_enRelease, 0x91C7F5FB); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Expert_API_TestMode_Layer_TouchArea_Seekup_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB_Expert_API_TestMode")) && (message.GetSender() == ::Courier::Identifier(0xc732cea4 /* Layer_TouchArea_Seekup/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Expert_API_TestMode_Layer_TouchArea_Seekup_ButtonWidget_enRelease, 0x27478EDF); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Expert_API_TestMode_Layer_TouchArea_Seekdn_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB_Expert_API_TestMode")) && (message.GetSender() == ::Courier::Identifier(0x3ca8043c /* Layer_TouchArea_Seekdn/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Expert_API_TestMode_Layer_TouchArea_Seekdn_ButtonWidget_enRelease, 0x972FBBF6); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Service_Info_TestMode_Layer_TouchArea_Seekup_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB_Service_Info_TestMode")) && (message.GetSender() == ::Courier::Identifier(0xc732cea4 /* Layer_TouchArea_Seekup/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Service_Info_TestMode_Layer_TouchArea_Seekup_ButtonWidget_enRelease, 0xCA4EB804); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Expert_API_TestMode_Layer_TouchArea_Stepup_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB_Expert_API_TestMode")) && (message.GetSender() == ::Courier::Identifier(0x4817fece /* Layer_TouchArea_Stepup/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Expert_API_TestMode_Layer_TouchArea_Stepup_ButtonWidget_enRelease, 0xBAB27CD5); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_TestModeScreens_Button_Back_BG_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_TestModeScreens")) && (message.GetSender() == ::Courier::Identifier(0x408b82c4 /* Button_Back_BG/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_TestModeScreens_Button_Back_BG_ButtonWidget_enRelease, 0x06A5068B); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_TestModeScreens_Layer_TouchArea_FM_Btn_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_TestModeScreens")) && (message.GetSender() == ::Courier::Identifier(0x390925ef /* Layer_TouchArea_FM_Btn/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_TestModeScreens_Layer_TouchArea_FM_Btn_ButtonWidget_enRelease, 0x88B0120C); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_TestModeScreens_Layer_TouchArea_DAB_Btn_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_TestModeScreens")) && (message.GetSender() == ::Courier::Identifier(0xf5dd8688 /* Layer_TouchArea_DAB_Btn/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_TestModeScreens_Layer_TouchArea_DAB_Btn_ButtonWidget_enRelease, 0xC04A41B8); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_TestModeScreens_Layer_TouchArea_TMC_Btn_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_TestModeScreens")) && (message.GetSender() == ::Courier::Identifier(0xb4415f2b /* Layer_TouchArea_TMC_Btn/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_TestModeScreens_Layer_TouchArea_TMC_Btn_ButtonWidget_enRelease, 0xF709B321); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_TestModeScreens_ButtonWidget2D_DRMSetup_Btn_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_TestModeScreens")) && (message.GetSender() == ::Courier::Identifier(0x6de3330e /* ButtonWidget2D_DRMSetup_Btn */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_TestModeScreens_ButtonWidget2D_DRMSetup_Btn_enRelease, 0x6DDACCBB); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_ButtonWidget2D_Refresh_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM")) && (message.GetSender() == ::Courier::Identifier(0x55055151 /* ButtonWidget2D_Refresh */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_ButtonWidget2D_Refresh_enRelease, 0xD7E9671B); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_ButtonWidget2D_Refresh_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM_AST")) && (message.GetSender() == ::Courier::Identifier(0x55055151 /* ButtonWidget2D_Refresh */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_ButtonWidget2D_Refresh_enRelease, 0x7D0B64CE); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Expert_API_TestMode_Layer_TouchArea_Stepdown_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB_Expert_API_TestMode")) && (message.GetSender() == ::Courier::Identifier(0x704386f1 /* Layer_TouchArea_Stepdown/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Expert_API_TestMode_Layer_TouchArea_Stepdown_ButtonWidget_enRelease, 0x55104D23); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Service_Info_TestMode_Layer_TouchArea_Next_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB_Service_Info_TestMode")) && (message.GetSender() == ::Courier::Identifier(0x4e7f0732 /* Layer_TouchArea_Next/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Service_Info_TestMode_Layer_TouchArea_Next_ButtonWidget_enRelease, 0xBB8B10EC); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Service_Info_TestMode_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB_Service_Info_TestMode")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Service_Info_TestMode_Layer_TouchArea_Back_ButtonWidget_enRelease, 0xADF9BBE2); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Quality_TestMode_Layer_TouchArea_Stepdown_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB_Quality_TestMode")) && (message.GetSender() == ::Courier::Identifier(0x704386f1 /* Layer_TouchArea_Stepdown/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Quality_TestMode_Layer_TouchArea_Stepdown_ButtonWidget_enRelease, 0xD2F59621); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_WeatherBand_Layer_TouchArea_Preset_8_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_WeatherBand")) && (message.GetSender() == ::Courier::Identifier(0x84fb073a /* Layer_TouchArea_Preset_8/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_WeatherBand_Layer_TouchArea_Preset_8_ButtonWidget_enRelease, 0x038BC451); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_WeatherBand_Layer_TouchArea_Preset_9_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_WeatherBand")) && (message.GetSender() == ::Courier::Identifier(0xc48d7eaa /* Layer_TouchArea_Preset_9/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_WeatherBand_Layer_TouchArea_Preset_9_ButtonWidget_enRelease, 0xB37B09FD); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_WeatherBand_Layer_TouchArea_Preset_10_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_WeatherBand")) && (message.GetSender() == ::Courier::Identifier(0xb9da2cf8 /* Layer_TouchArea_Preset_10/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_WeatherBand_Layer_TouchArea_Preset_10_ButtonWidget_enRelease, 0x47388ECB); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_WeatherBand_Layer_TouchArea_Source_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_WeatherBand")) && (message.GetSender() == ::Courier::Identifier(0xccdf81cf /* Layer_TouchArea_Source/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_WeatherBand_Layer_TouchArea_Source_ButtonWidget_enRelease, 0xD74FB515); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_WeatherBand_Layer_TouchArea_Source_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_WeatherBand")) && (message.GetSender() == ::Courier::Identifier(0xccdf81cf /* Layer_TouchArea_Source/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_WeatherBand_Layer_TouchArea_Source_ButtonWidget_enLongPress, 0xB5811DC6); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_WeatherBand_Monitor_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_WeatherBand_Monitor")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_WeatherBand_Monitor_Layer_TouchArea_Back_ButtonWidget_enRelease, 0x600F9277); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Setup_Monitor_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB_Setup_Monitor")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Setup_Monitor_Layer_TouchArea_Back_ButtonWidget_enRelease, 0x62672364); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Setup_Monitor_Layer_TouchArea_Next_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB_Setup_Monitor")) && (message.GetSender() == ::Courier::Identifier(0x4e7f0732 /* Layer_TouchArea_Next/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Setup_Monitor_Layer_TouchArea_Next_ButtonWidget_enRelease, 0x69A3B2F3); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Setup_Monitor_Btn_Highcut_Dec_Button_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB_Setup_Monitor")) && (message.GetSender() == ::Courier::Identifier(0x34dec3af /* Btn_Highcut_Dec/Button */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Setup_Monitor_Btn_Highcut_Dec_Button_enRelease, 0xF96EDA70); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Setup_Monitor_Btn_Highcut_Inc_Button_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB_Setup_Monitor")) && (message.GetSender() == ::Courier::Identifier(0x52c2d123 /* Btn_Highcut_Inc/Button */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Setup_Monitor_Btn_Highcut_Inc_Button_enRelease, 0xA4A79A07); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Setup_Monitor_Btn_Sharx_Dec_Button_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB_Setup_Monitor")) && (message.GetSender() == ::Courier::Identifier(0x4726bc2f /* Btn_Sharx_Dec/Button */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Setup_Monitor_Btn_Sharx_Dec_Button_enRelease, 0x48043110); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Setup_Monitor_Btn_Sharx_Inc_Button_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB_Setup_Monitor")) && (message.GetSender() == ::Courier::Identifier(0xff2f1012 /* Btn_Sharx_Inc/Button */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Setup_Monitor_Btn_Sharx_Inc_Button_enRelease, 0x1EE6B1DA); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Quality_TestMode_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB_Quality_TestMode")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Quality_TestMode_Layer_TouchArea_Back_ButtonWidget_enRelease, 0xE4654211); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Quality_TestMode_Layer_TouchArea_Next_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB_Quality_TestMode")) && (message.GetSender() == ::Courier::Identifier(0x4e7f0732 /* Layer_TouchArea_Next/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Quality_TestMode_Layer_TouchArea_Next_ButtonWidget_enRelease, 0xFE64C8EF); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Quality_TestMode_Layer_TouchArea_Seekup_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB_Quality_TestMode")) && (message.GetSender() == ::Courier::Identifier(0xc732cea4 /* Layer_TouchArea_Seekup/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Quality_TestMode_Layer_TouchArea_Seekup_ButtonWidget_enRelease, 0xEF230CDC); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Quality_TestMode_Layer_TouchArea_Seekdn_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB_Quality_TestMode")) && (message.GetSender() == ::Courier::Identifier(0x3ca8043c /* Layer_TouchArea_Seekdn/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Quality_TestMode_Layer_TouchArea_Seekdn_ButtonWidget_enRelease, 0xF061132A); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Quality_TestMode_Layer_TouchArea_Stepup_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB_Quality_TestMode")) && (message.GetSender() == ::Courier::Identifier(0x4817fece /* Layer_TouchArea_Stepup/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Quality_TestMode_Layer_TouchArea_Stepup_ButtonWidget_enRelease, 0x420B67AE); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor_Textbox_Tuner4_Band_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_Triple_Tuner_Monitor")) && (message.GetSender() == ::Courier::Identifier(0xcdc4eb74 /* Textbox_Tuner4_Band/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor_Textbox_Tuner4_Band_ButtonWidget_enRelease, 0x72045DA3); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor_Textbox_Tuner3_Band_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_Triple_Tuner_Monitor")) && (message.GetSender() == ::Courier::Identifier(0xc5610203 /* Textbox_Tuner3_Band/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor_Textbox_Tuner3_Band_ButtonWidget_enRelease, 0x8E4FC576); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor_Textbox_Tuner2_Band_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_Triple_Tuner_Monitor")) && (message.GetSender() == ::Courier::Identifier(0x016a8f1d /* Textbox_Tuner2_Band/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor_Textbox_Tuner2_Band_ButtonWidget_enRelease, 0x0DB45C61); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor_Textbox_Tuner1_Band_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_Triple_Tuner_Monitor")) && (message.GetSender() == ::Courier::Identifier(0xe83731d1 /* Textbox_Tuner1_Band/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor_Textbox_Tuner1_Band_ButtonWidget_enRelease, 0xD0D8F7BB); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_Preset_6_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB_AST")) && (message.GetSender() == ::Courier::Identifier(0xad746719 /* Layer_TouchArea_Preset_6/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_Preset_6_ButtonWidget_enShortPress, 0x98EA7E5A); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_Source_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM")) && (message.GetSender() == ::Courier::Identifier(0xccdf81cf /* Layer_TouchArea_Source/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_Source_ButtonWidget_enRelease, 0xF78ADEEF); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_SearchPrevious_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM")) && (message.GetSender() == ::Courier::Identifier(0xcd890a81 /* Layer_TouchArea_SearchPrevious/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_SearchPrevious_ButtonWidget_enLongPress, 0xDDFF7062); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_SearchNext_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM")) && (message.GetSender() == ::Courier::Identifier(0x26924a2e /* Layer_TouchArea_SearchNext/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_SearchNext_ButtonWidget_enRelease, 0x26458826); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_SearchPrevious_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM")) && (message.GetSender() == ::Courier::Identifier(0xcd890a81 /* Layer_TouchArea_SearchPrevious/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_SearchPrevious_ButtonWidget_enRelease, 0xCDA4A576); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_SearchNext_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM")) && (message.GetSender() == ::Courier::Identifier(0x26924a2e /* Layer_TouchArea_SearchNext/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_SearchNext_ButtonWidget_enLongPress, 0xCD0B0923); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_BtnWidget2D_SrvList_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM")) && (message.GetSender() == ::Courier::Identifier(0xe8afbaab /* BtnWidget2D_SrvList */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_BtnWidget2D_SrvList_enRelease, 0x5078E7EF); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_Preset_5_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB_AST")) && (message.GetSender() == ::Courier::Identifier(0xd80bf0d5 /* Layer_TouchArea_Preset_5/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_Preset_5_ButtonWidget_enShortPress, 0xA3D8E52C); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_Preset_1_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM")) && (message.GetSender() == ::Courier::Identifier(0x5e7e68f4 /* Layer_TouchArea_Preset_1/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_Preset_1_ButtonWidget_enRelease, 0x4ED50E43); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_Preset_3_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM")) && (message.GetSender() == ::Courier::Identifier(0xaaaa6541 /* Layer_TouchArea_Preset_3/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_Preset_3_ButtonWidget_enRelease, 0x2CAFEA04); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_Preset_4_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM")) && (message.GetSender() == ::Courier::Identifier(0x378f839d /* Layer_TouchArea_Preset_4/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_Preset_4_ButtonWidget_enRelease, 0x013A4E4E); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_Preset_5_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM")) && (message.GetSender() == ::Courier::Identifier(0xd80bf0d5 /* Layer_TouchArea_Preset_5/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_Preset_5_ButtonWidget_enRelease, 0x59455055); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_Preset_6_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM")) && (message.GetSender() == ::Courier::Identifier(0xad746719 /* Layer_TouchArea_Preset_6/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_Preset_6_ButtonWidget_enRelease, 0x2E7DC355); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_Preset_1_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM")) && (message.GetSender() == ::Courier::Identifier(0x5e7e68f4 /* Layer_TouchArea_Preset_1/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_Preset_1_ButtonWidget_enShortPressRelease, 0x56164B4C); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_Preset_2_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM")) && (message.GetSender() == ::Courier::Identifier(0x966c3b3e /* Layer_TouchArea_Preset_2/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_Preset_2_ButtonWidget_enShortPressRelease, 0x83739B60); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_Preset_3_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM")) && (message.GetSender() == ::Courier::Identifier(0xaaaa6541 /* Layer_TouchArea_Preset_3/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_Preset_3_ButtonWidget_enShortPressRelease, 0xACEBE2E9); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_Preset_2_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM")) && (message.GetSender() == ::Courier::Identifier(0x966c3b3e /* Layer_TouchArea_Preset_2/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_Preset_2_ButtonWidget_enRelease, 0xBFADD4DB); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_Preset_4_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB_AST")) && (message.GetSender() == ::Courier::Identifier(0x378f839d /* Layer_TouchArea_Preset_4/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_Preset_4_ButtonWidget_enShortPress, 0x0D83CC91); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_Preset_3_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB_AST")) && (message.GetSender() == ::Courier::Identifier(0xaaaa6541 /* Layer_TouchArea_Preset_3/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_Preset_3_ButtonWidget_enShortPress, 0x603DC085); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_Preset_2_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB_AST")) && (message.GetSender() == ::Courier::Identifier(0x966c3b3e /* Layer_TouchArea_Preset_2/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_Preset_2_ButtonWidget_enShortPress, 0xCD9F10C6); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_SearchNext_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB_AST")) && (message.GetSender() == ::Courier::Identifier(0x26924a2e /* Layer_TouchArea_SearchNext/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_SearchNext_ButtonWidget_enRelease, 0x07226771); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_SearchPrevious_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB_AST")) && (message.GetSender() == ::Courier::Identifier(0xcd890a81 /* Layer_TouchArea_SearchPrevious/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_SearchPrevious_ButtonWidget_enRelease, 0xBF2B20D1); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Icon_StationList_Button_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB_AST")) && (message.GetSender() == ::Courier::Identifier(0xf49b3391 /* Icon_StationList/Button */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Icon_StationList_Button_enRelease, 0xDEB2B99C); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_Preset_1_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB_AST")) && (message.GetSender() == ::Courier::Identifier(0x5e7e68f4 /* Layer_TouchArea_Preset_1/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_Preset_1_ButtonWidget_enRelease, 0x1577BD8B); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_Preset_2_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB_AST")) && (message.GetSender() == ::Courier::Identifier(0x966c3b3e /* Layer_TouchArea_Preset_2/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_Preset_2_ButtonWidget_enRelease, 0x1211944E); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_Preset_3_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB_AST")) && (message.GetSender() == ::Courier::Identifier(0xaaaa6541 /* Layer_TouchArea_Preset_3/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_Preset_3_ButtonWidget_enRelease, 0x9296551D); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_Preset_4_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB_AST")) && (message.GetSender() == ::Courier::Identifier(0x378f839d /* Layer_TouchArea_Preset_4/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_Preset_4_ButtonWidget_enRelease, 0x7D6F7470); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_Preset_5_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB_AST")) && (message.GetSender() == ::Courier::Identifier(0xd80bf0d5 /* Layer_TouchArea_Preset_5/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_Preset_5_ButtonWidget_enRelease, 0xA09406E1); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_Preset_6_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB_AST")) && (message.GetSender() == ::Courier::Identifier(0xad746719 /* Layer_TouchArea_Preset_6/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_Preset_6_ButtonWidget_enRelease, 0xBE670CC6); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_Preset_1_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB_AST")) && (message.GetSender() == ::Courier::Identifier(0x5e7e68f4 /* Layer_TouchArea_Preset_1/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_Preset_1_ButtonWidget_enShortPressRelease, 0xFDFF8319); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_Preset_2_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB_AST")) && (message.GetSender() == ::Courier::Identifier(0x966c3b3e /* Layer_TouchArea_Preset_2/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_Preset_2_ButtonWidget_enShortPressRelease, 0xB99C2EB4); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_Preset_3_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB_AST")) && (message.GetSender() == ::Courier::Identifier(0xaaaa6541 /* Layer_TouchArea_Preset_3/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_Preset_3_ButtonWidget_enShortPressRelease, 0x38BAF988); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_Preset_4_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB_AST")) && (message.GetSender() == ::Courier::Identifier(0x378f839d /* Layer_TouchArea_Preset_4/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_Preset_4_ButtonWidget_enShortPressRelease, 0xB03FA0D8); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_Preset_5_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB_AST")) && (message.GetSender() == ::Courier::Identifier(0xd80bf0d5 /* Layer_TouchArea_Preset_5/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_Preset_5_ButtonWidget_enShortPressRelease, 0xA30AC5B7); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_Preset_6_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB_AST")) && (message.GetSender() == ::Courier::Identifier(0xad746719 /* Layer_TouchArea_Preset_6/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_Preset_6_ButtonWidget_enShortPressRelease, 0x20BC9B55); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_AST_ButtonWidget_enPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB_AST")) && (message.GetSender() == ::Courier::Identifier(0x9e370d5d /* Layer_TouchArea_AST/ButtonWidget */)) && (message.GetEnReaction() == enPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_AST_ButtonWidget_enPress, 0x8D3054AC); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_Preset_1_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB_AST")) && (message.GetSender() == ::Courier::Identifier(0x5e7e68f4 /* Layer_TouchArea_Preset_1/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_Preset_1_ButtonWidget_enShortPress, 0x474A73D9); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_Preset_4_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM")) && (message.GetSender() == ::Courier::Identifier(0x378f839d /* Layer_TouchArea_Preset_4/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_Preset_4_ButtonWidget_enShortPressRelease, 0x597E4B78); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Monitor_btn_bn_Back_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM_Monitor")) && (message.GetSender() == ::Courier::Identifier(0xa557383e /* btn_bn_Back */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Monitor_btn_bn_Back_enRelease, 0x5AFAAA30); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_Preset_5_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM")) && (message.GetSender() == ::Courier::Identifier(0xd80bf0d5 /* Layer_TouchArea_Preset_5/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_Preset_5_ButtonWidget_enShortPressRelease, 0x7D64978F); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_AST_ButtonWidget_enPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM")) && (message.GetSender() == ::Courier::Identifier(0x9e370d5d /* Layer_TouchArea_AST/ButtonWidget */)) && (message.GetEnReaction() == enPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_AST_ButtonWidget_enPress, 0xA06C55A4); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_Preset_4_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM_AST")) && (message.GetSender() == ::Courier::Identifier(0x378f839d /* Layer_TouchArea_Preset_4/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_Preset_4_ButtonWidget_enShortPressRelease, 0x07993235); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_Preset_5_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM_AST")) && (message.GetSender() == ::Courier::Identifier(0xd80bf0d5 /* Layer_TouchArea_Preset_5/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_Preset_5_ButtonWidget_enShortPressRelease, 0xD1C38929); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_Preset_6_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM_AST")) && (message.GetSender() == ::Courier::Identifier(0xad746719 /* Layer_TouchArea_Preset_6/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_Preset_6_ButtonWidget_enShortPressRelease, 0x06A73063); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_AST_ButtonWidget_enPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM_AST")) && (message.GetSender() == ::Courier::Identifier(0x9e370d5d /* Layer_TouchArea_AST/ButtonWidget */)) && (message.GetEnReaction() == enPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_AST_ButtonWidget_enPress, 0x38E56C32); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_Preset_1_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM_AST")) && (message.GetSender() == ::Courier::Identifier(0x5e7e68f4 /* Layer_TouchArea_Preset_1/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_Preset_1_ButtonWidget_enShortPress, 0x19DC63A6); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_Preset_2_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM_AST")) && (message.GetSender() == ::Courier::Identifier(0x966c3b3e /* Layer_TouchArea_Preset_2/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_Preset_2_ButtonWidget_enShortPress, 0x87917EBC); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_Preset_3_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM_AST")) && (message.GetSender() == ::Courier::Identifier(0xaaaa6541 /* Layer_TouchArea_Preset_3/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_Preset_3_ButtonWidget_enShortPress, 0x442EAABE); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_Preset_3_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM_AST")) && (message.GetSender() == ::Courier::Identifier(0xaaaa6541 /* Layer_TouchArea_Preset_3/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_Preset_3_ButtonWidget_enShortPressRelease, 0x34C4FC0D); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_Preset_4_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM_AST")) && (message.GetSender() == ::Courier::Identifier(0x378f839d /* Layer_TouchArea_Preset_4/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_Preset_4_ButtonWidget_enShortPress, 0xC69B810C); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_Preset_6_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM_AST")) && (message.GetSender() == ::Courier::Identifier(0xad746719 /* Layer_TouchArea_Preset_6/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_Preset_6_ButtonWidget_enShortPress, 0x7D65C519); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_Triple_Tuner_Monitor")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor_Layer_TouchArea_Back_ButtonWidget_enRelease, 0x4F71C242); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor_Layer_TouchArea_Next_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_Triple_Tuner_Monitor")) && (message.GetSender() == ::Courier::Identifier(0x4e7f0732 /* Layer_TouchArea_Next/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor_Layer_TouchArea_Next_ButtonWidget_enRelease, 0x574A0A14); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor_Layer_TouchArea_Stepup_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_Triple_Tuner_Monitor")) && (message.GetSender() == ::Courier::Identifier(0x4817fece /* Layer_TouchArea_Stepup/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor_Layer_TouchArea_Stepup_ButtonWidget_enRelease, 0x62E419D7); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor_Layer_TouchArea_Stepdown_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_Triple_Tuner_Monitor")) && (message.GetSender() == ::Courier::Identifier(0x704386f1 /* Layer_TouchArea_Stepdown/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor_Layer_TouchArea_Stepdown_ButtonWidget_enRelease, 0x27AA175D); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor_Layer_TouchArea_Seekdn_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_Triple_Tuner_Monitor")) && (message.GetSender() == ::Courier::Identifier(0x3ca8043c /* Layer_TouchArea_Seekdn/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor_Layer_TouchArea_Seekdn_ButtonWidget_enRelease, 0x95EFDB81); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor_Layer_TouchArea_Seekup_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_Triple_Tuner_Monitor")) && (message.GetSender() == ::Courier::Identifier(0xc732cea4 /* Layer_TouchArea_Seekup/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor_Layer_TouchArea_Seekup_ButtonWidget_enRelease, 0xF12E90B8); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_Preset_5_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM_AST")) && (message.GetSender() == ::Courier::Identifier(0xd80bf0d5 /* Layer_TouchArea_Preset_5/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_Preset_5_ButtonWidget_enShortPress, 0xE1167CDA); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_Preset_2_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM_AST")) && (message.GetSender() == ::Courier::Identifier(0x966c3b3e /* Layer_TouchArea_Preset_2/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_Preset_2_ButtonWidget_enShortPressRelease, 0xA0A319D9); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_Preset_1_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM_AST")) && (message.GetSender() == ::Courier::Identifier(0x5e7e68f4 /* Layer_TouchArea_Preset_1/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_Preset_1_ButtonWidget_enShortPressRelease, 0xD5FF1A57); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_Preset_6_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM_AST")) && (message.GetSender() == ::Courier::Identifier(0xad746719 /* Layer_TouchArea_Preset_6/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_Preset_6_ButtonWidget_enRelease, 0x30765DB9); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_Preset_1_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM")) && (message.GetSender() == ::Courier::Identifier(0x5e7e68f4 /* Layer_TouchArea_Preset_1/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_Preset_1_ButtonWidget_enShortPress, 0x027A8C72); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_Preset_2_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM")) && (message.GetSender() == ::Courier::Identifier(0x966c3b3e /* Layer_TouchArea_Preset_2/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_Preset_2_ButtonWidget_enShortPress, 0x93793C41); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_Preset_3_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM")) && (message.GetSender() == ::Courier::Identifier(0xaaaa6541 /* Layer_TouchArea_Preset_3/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_Preset_3_ButtonWidget_enShortPress, 0x98DAC4E4); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_Preset_4_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM")) && (message.GetSender() == ::Courier::Identifier(0x378f839d /* Layer_TouchArea_Preset_4/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_Preset_4_ButtonWidget_enShortPress, 0x0AA642BA); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_Preset_5_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM")) && (message.GetSender() == ::Courier::Identifier(0xd80bf0d5 /* Layer_TouchArea_Preset_5/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_Preset_5_ButtonWidget_enShortPress, 0x142C8E7E); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_Preset_6_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM")) && (message.GetSender() == ::Courier::Identifier(0xad746719 /* Layer_TouchArea_Preset_6/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_Preset_6_ButtonWidget_enShortPress, 0x317B89D2); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_Source_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM_AST")) && (message.GetSender() == ::Courier::Identifier(0xccdf81cf /* Layer_TouchArea_Source/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_Source_ButtonWidget_enRelease, 0x0AF77565); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_SearchNext_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM_AST")) && (message.GetSender() == ::Courier::Identifier(0x26924a2e /* Layer_TouchArea_SearchNext/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_SearchNext_ButtonWidget_enRelease, 0x7AB14A18); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_SearchPrevious_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM_AST")) && (message.GetSender() == ::Courier::Identifier(0xcd890a81 /* Layer_TouchArea_SearchPrevious/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_SearchPrevious_ButtonWidget_enRelease, 0x317CE9C6); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_SearchNext_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM_AST")) && (message.GetSender() == ::Courier::Identifier(0x26924a2e /* Layer_TouchArea_SearchNext/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_SearchNext_ButtonWidget_enLongPress, 0x331B7973); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_SearchPrevious_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM_AST")) && (message.GetSender() == ::Courier::Identifier(0xcd890a81 /* Layer_TouchArea_SearchPrevious/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_SearchPrevious_ButtonWidget_enLongPress, 0x65DEAB8B); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_BtnWidget2D_SrvList_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM_AST")) && (message.GetSender() == ::Courier::Identifier(0xe8afbaab /* BtnWidget2D_SrvList */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_BtnWidget2D_SrvList_enRelease, 0xCCE01D4C); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_Preset_1_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM_AST")) && (message.GetSender() == ::Courier::Identifier(0x5e7e68f4 /* Layer_TouchArea_Preset_1/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_Preset_1_ButtonWidget_enRelease, 0x152E39D7); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_Preset_2_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM_AST")) && (message.GetSender() == ::Courier::Identifier(0x966c3b3e /* Layer_TouchArea_Preset_2/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_Preset_2_ButtonWidget_enRelease, 0x2BF0D3B1); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_Preset_3_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM_AST")) && (message.GetSender() == ::Courier::Identifier(0xaaaa6541 /* Layer_TouchArea_Preset_3/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_Preset_3_ButtonWidget_enRelease, 0xC9D3D9E9); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_Preset_4_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM_AST")) && (message.GetSender() == ::Courier::Identifier(0x378f839d /* Layer_TouchArea_Preset_4/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_Preset_4_ButtonWidget_enRelease, 0xCE88126A); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_Preset_5_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM_AST")) && (message.GetSender() == ::Courier::Identifier(0xd80bf0d5 /* Layer_TouchArea_Preset_5/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_Preset_5_ButtonWidget_enRelease, 0x13F07391); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_Preset_6_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM")) && (message.GetSender() == ::Courier::Identifier(0xad746719 /* Layer_TouchArea_Preset_6/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_Preset_6_ButtonWidget_enShortPressRelease, 0x8C07F4DE); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_4_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_AST")) && (message.GetSender() == ::Courier::Identifier(0x427883c0 /* Layer_TouchArea_PresetAST_4/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_4_ButtonWidget_enShortPress, 0x3FCBCD24); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_5_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_AST")) && (message.GetSender() == ::Courier::Identifier(0x134d2804 /* Layer_TouchArea_PresetAST_5/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_5_ButtonWidget_enShortPress, 0xE4139A48); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_2_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_AST")) && (message.GetSender() == ::Courier::Identifier(0x39c4e83d /* Layer_TouchArea_PresetAST_2/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_2_ButtonWidget_enShortPress, 0xBA2D47BD); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_TouchArea_FreqStepDown_normal_Button_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0x2be9f953 /* TouchArea_FreqStepDown_normal/Button */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_TouchArea_FreqStepDown_normal_Button_enLongPressRelease, 0x305DFD6F); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_Morepresets_Next_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0xc1dbda95 /* Layer_Morepresets_Next/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_Morepresets_Next_ButtonWidget_enRelease, 0x2553E30A); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_Morepresets_Previous_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0x3323c210 /* Layer_Morepresets_Previous/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_Morepresets_Previous_ButtonWidget_enRelease, 0xACBB19A2); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Source_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0xccdf81cf /* Layer_TouchArea_Source/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Source_ButtonWidget_enRelease, 0xFEE0A8E4); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Source_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0xccdf81cf /* Layer_TouchArea_Source/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Source_ButtonWidget_enLongPress, 0x361137AD); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_TouchArea_FreqStepUp_normal_Button_enAbortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0x558a16a3 /* TouchArea_FreqStepUp_normal/Button */)) && (message.GetEnReaction() == enAbortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_TouchArea_FreqStepUp_normal_Button_enAbortPress, 0x259C0619); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_TouchArea_FreqStepDown_normal_Button_enAbortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0x2be9f953 /* TouchArea_FreqStepDown_normal/Button */)) && (message.GetEnReaction() == enAbortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_TouchArea_FreqStepDown_normal_Button_enAbortPress, 0x15EE3C60); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_TouchArea_FreqStepUp_normal_Button_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0x558a16a3 /* TouchArea_FreqStepUp_normal/Button */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_TouchArea_FreqStepUp_normal_Button_enLongPressRelease, 0xA64B6D0B); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_SearchNext_ButtonWidget_enAbortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0x26924a2e /* Layer_TouchArea_SearchNext/ButtonWidget */)) && (message.GetEnReaction() == enAbortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_SearchNext_ButtonWidget_enAbortPress, 0xF1FEE847); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_TouchArea_FreqStepUp_normal_Button_enAbortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0x558a16a3 /* TouchArea_FreqStepUp_normal/Button */)) && (message.GetEnReaction() == enAbortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_TouchArea_FreqStepUp_normal_Button_enAbortPress, 0x9587A959); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_TouchArea_FreqStepDown_normal_Button_enAbortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0x2be9f953 /* TouchArea_FreqStepDown_normal/Button */)) && (message.GetEnReaction() == enAbortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_TouchArea_FreqStepDown_normal_Button_enAbortPress, 0x753859CD); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_SearchNext_ButtonWidget_enAbortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0x26924a2e /* Layer_TouchArea_SearchNext/ButtonWidget */)) && (message.GetEnReaction() == enAbortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_SearchNext_ButtonWidget_enAbortPress, 0xCDDA3BC7); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_SearchPrevious_ButtonWidget_enAbortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0xcd890a81 /* Layer_TouchArea_SearchPrevious/ButtonWidget */)) && (message.GetEnReaction() == enAbortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_SearchPrevious_ButtonWidget_enAbortPress, 0x6B930DCC); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_Morepresets_Next_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0xc1dbda95 /* Layer_Morepresets_Next/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_Morepresets_Next_ButtonWidget_enRelease, 0xB9A7A9BF); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_Morepresets_Previous_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0x3323c210 /* Layer_Morepresets_Previous/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_Morepresets_Previous_ButtonWidget_enRelease, 0x37D2D492); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Source_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0xccdf81cf /* Layer_TouchArea_Source/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Source_ButtonWidget_enRelease, 0xE22E6B7B); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_SearchPrevious_ButtonWidget_enAbortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0xcd890a81 /* Layer_TouchArea_SearchPrevious/ButtonWidget */)) && (message.GetEnReaction() == enAbortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_SearchPrevious_ButtonWidget_enAbortPress, 0x1E5C5241); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_TouchArea_FreqStepDown_normal_Button_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0x2be9f953 /* TouchArea_FreqStepDown_normal/Button */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_TouchArea_FreqStepDown_normal_Button_enShortPressRelease, 0xFB722B55); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_TouchArea_FreqStepUp_normal_Button_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0x558a16a3 /* TouchArea_FreqStepUp_normal/Button */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_TouchArea_FreqStepUp_normal_Button_enShortPressRelease, 0xB655542F); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_TouchArea_FreqStepDown_normal_Button_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0x2be9f953 /* TouchArea_FreqStepDown_normal/Button */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_TouchArea_FreqStepDown_normal_Button_enRelease, 0x2D40BFBA); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_10_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0xb9da2cf8 /* Layer_TouchArea_Preset_10/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_10_ButtonWidget_enLongPressRelease, 0x03A653C9); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_11_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0x582a8787 /* Layer_TouchArea_Preset_11/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_11_ButtonWidget_enLongPressRelease, 0x7BF07423); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_12_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0xf3c138d5 /* Layer_TouchArea_Preset_12/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_12_ButtonWidget_enLongPressRelease, 0x10EE9697); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_SearchPrevious_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0xcd890a81 /* Layer_TouchArea_SearchPrevious/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_SearchPrevious_ButtonWidget_enRelease, 0xAAB764DC); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_SearchNext_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0x26924a2e /* Layer_TouchArea_SearchNext/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_SearchNext_ButtonWidget_enRelease, 0x940B7D57); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_SearchPrevious_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0xcd890a81 /* Layer_TouchArea_SearchPrevious/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_SearchPrevious_ButtonWidget_enShortPress, 0x529D49FA); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_SearchNext_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0x26924a2e /* Layer_TouchArea_SearchNext/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_SearchNext_ButtonWidget_enShortPress, 0xEC1C0C93); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_SearchPrevious_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0xcd890a81 /* Layer_TouchArea_SearchPrevious/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_SearchPrevious_ButtonWidget_enShortPressRelease, 0xA144E781); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_SearchNext_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0x26924a2e /* Layer_TouchArea_SearchNext/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_SearchNext_ButtonWidget_enShortPressRelease, 0x3A35F923); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_SearchPrevious_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0xcd890a81 /* Layer_TouchArea_SearchPrevious/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_SearchPrevious_ButtonWidget_enLongPressRelease, 0x2406E5D0); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_SearchNext_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0x26924a2e /* Layer_TouchArea_SearchNext/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_SearchNext_ButtonWidget_enLongPressRelease, 0xCEE39D70); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Scan_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0x4cf01c3a /* Layer_TouchArea_Scan/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Scan_ButtonWidget_enRelease, 0xFC8A282C); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_TouchArea_FreqStepUp_normal_Button_enPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0x558a16a3 /* TouchArea_FreqStepUp_normal/Button */)) && (message.GetEnReaction() == enPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_TouchArea_FreqStepUp_normal_Button_enPress, 0xA95F9E2B); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_TouchArea_FreqStepDown_normal_Button_enPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0x2be9f953 /* TouchArea_FreqStepDown_normal/Button */)) && (message.GetEnReaction() == enPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_TouchArea_FreqStepDown_normal_Button_enPress, 0xEE93F920); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_TouchArea_FreqStepUp_normal_Button_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0x558a16a3 /* TouchArea_FreqStepUp_normal/Button */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_TouchArea_FreqStepUp_normal_Button_enShortPress, 0x0FA1F9C2); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_TouchArea_FreqStepDown_normal_Button_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0x2be9f953 /* TouchArea_FreqStepDown_normal/Button */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_TouchArea_FreqStepDown_normal_Button_enShortPress, 0x80CF53BA); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_TouchArea_FreqStepUp_normal_Button_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0x558a16a3 /* TouchArea_FreqStepUp_normal/Button */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_TouchArea_FreqStepUp_normal_Button_enRelease, 0xF16786A6); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Source_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0xccdf81cf /* Layer_TouchArea_Source/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Source_ButtonWidget_enLongPress, 0xF0AA275B); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_9_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0xc48d7eaa /* Layer_TouchArea_Preset_9/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_9_ButtonWidget_enLongPressRelease, 0xBBC8C02F); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Icon_StationList_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0x3bdb8384 /* Icon_StationList/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Icon_StationList_ButtonWidget_enRelease, 0xE3E6E5AE); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_2_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0x966c3b3e /* Layer_TouchArea_Preset_2/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_2_ButtonWidget_enRelease, 0x7510ACEE); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_6_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0xad746719 /* Layer_TouchArea_Preset_6/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_6_ButtonWidget_enShortPressRelease, 0x164C89B5); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_TouchArea_FMHD_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0xe1c9bb28 /* TouchArea_FMHD/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_TouchArea_FMHD_ButtonWidget_enRelease, 0x59E5E463); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_TouchArea_AMHD_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0xd29b9bac /* TouchArea_AMHD/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_TouchArea_AMHD_ButtonWidget_enRelease, 0x20010AB4); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Toucharea_hd_info_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0xd2eb766c /* Toucharea_hd_info/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Toucharea_hd_info_ButtonWidget_enRelease, 0x1A61C32F); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Toucharea_hd_info_AM_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0x40918516 /* Toucharea_hd_info_AM/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Toucharea_hd_info_AM_ButtonWidget_enRelease, 0x04DAD041); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_INFO_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_INFO")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_INFO_Layer_TouchArea_Back_ButtonWidget_enRelease, 0x0F63E62B); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_INFO_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_INFO")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_INFO_Layer_TouchArea_Back_ButtonWidget_enRelease, 0x9603D9AB); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_5_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0xd80bf0d5 /* Layer_TouchArea_Preset_5/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_5_ButtonWidget_enShortPressRelease, 0x2094F417); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_TestModeScreens_Toucharea_hd_testmode_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_TestModeScreens")) && (message.GetSender() == ::Courier::Identifier(0x1e021451 /* Toucharea_hd_testmode/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_TestModeScreens_Toucharea_hd_testmode_ButtonWidget_enRelease, 0xA087EB0D); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_TestModeScreens_TouchArea_SXM_Settings_Btn_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_TestModeScreens")) && (message.GetSender() == ::Courier::Identifier(0x7edcb452 /* TouchArea_SXM_Settings_Btn/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_TestModeScreens_TouchArea_SXM_Settings_Btn_ButtonWidget_enRelease, 0x575684BF); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_HDDTM_TESTMODE_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_HDDTM_TESTMODE")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_HDDTM_TESTMODE_Layer_TouchArea_Back_ButtonWidget_enRelease, 0xA4462D02); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_HDDTM_TESTMODE_Layer_TouchArea_SeekUp_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_HDDTM_TESTMODE")) && (message.GetSender() == ::Courier::Identifier(0x03e54e2c /* Layer_TouchArea_SeekUp/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_HDDTM_TESTMODE_Layer_TouchArea_SeekUp_ButtonWidget_enRelease, 0xDBBD16BE); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_HDDTM_TESTMODE_Layer_TouchArea_SeekDown_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_HDDTM_TESTMODE")) && (message.GetSender() == ::Courier::Identifier(0x42f2f4ca /* Layer_TouchArea_SeekDown/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_HDDTM_TESTMODE_Layer_TouchArea_SeekDown_ButtonWidget_enRelease, 0xD070F0A9); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_HDDTM_TESTMODE_Btn_SplitAudio_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_HDDTM_TESTMODE")) && (message.GetSender() == ::Courier::Identifier(0xf4b9f9fa /* Btn_SplitAudio/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_HDDTM_TESTMODE_Btn_SplitAudio_ButtonWidget_enRelease, 0x7408A4E8); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_HDDTM_TESTMODE_Btn_ResetTransitions_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_HDDTM_TESTMODE")) && (message.GetSender() == ::Courier::Identifier(0x4738f1bb /* Btn_ResetTransitions/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_HDDTM_TESTMODE_Btn_ResetTransitions_ButtonWidget_enRelease, 0x426A4CFD); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_HDDTM_TESTMODE_Btn_HdParamTuning_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_HDDTM_TESTMODE")) && (message.GetSender() == ::Courier::Identifier(0x413980ef /* Btn_HdParamTuning/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_HDDTM_TESTMODE_Btn_HdParamTuning_ButtonWidget_enRelease, 0x87237A84); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_TestModeScreens_TouchArea_SXM_Monitor_Btn_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_TestModeScreens")) && (message.GetSender() == ::Courier::Identifier(0x0afec05d /* TouchArea_SXM_Monitor_Btn/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_TestModeScreens_TouchArea_SXM_Monitor_Btn_ButtonWidget_enRelease, 0x69F47747); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_4_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0x378f839d /* Layer_TouchArea_Preset_4/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_4_ButtonWidget_enShortPressRelease, 0x64F0686F); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_3_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0xaaaa6541 /* Layer_TouchArea_Preset_3/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_3_ButtonWidget_enShortPressRelease, 0xD8CE1B7D); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_2_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0x966c3b3e /* Layer_TouchArea_Preset_2/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_2_ButtonWidget_enShortPressRelease, 0x7B03B190); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_3_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0xaaaa6541 /* Layer_TouchArea_Preset_3/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_3_ButtonWidget_enRelease, 0x289190ED); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_4_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0x378f839d /* Layer_TouchArea_Preset_4/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_4_ButtonWidget_enRelease, 0xFE5EAC9B); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_5_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0xd80bf0d5 /* Layer_TouchArea_Preset_5/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_5_ButtonWidget_enRelease, 0x0C9095E1); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_6_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0xad746719 /* Layer_TouchArea_Preset_6/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_6_ButtonWidget_enRelease, 0x5FFECD4A); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_1_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0x5e7e68f4 /* Layer_TouchArea_Preset_1/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_1_ButtonWidget_enLongPress, 0xED206ABD); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_2_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0x966c3b3e /* Layer_TouchArea_Preset_2/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_2_ButtonWidget_enLongPress, 0x0CA12725); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_3_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0xaaaa6541 /* Layer_TouchArea_Preset_3/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_3_ButtonWidget_enLongPress, 0xEFAB0D02); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_4_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0x378f839d /* Layer_TouchArea_Preset_4/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_4_ButtonWidget_enLongPress, 0x048B76CE); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_5_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0xd80bf0d5 /* Layer_TouchArea_Preset_5/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_5_ButtonWidget_enLongPress, 0x23BE181E); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_6_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0xad746719 /* Layer_TouchArea_Preset_6/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_6_ButtonWidget_enLongPress, 0x289A5D39); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_1_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0x5e7e68f4 /* Layer_TouchArea_Preset_1/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_1_ButtonWidget_enShortPress, 0x7769581D); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_2_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0x966c3b3e /* Layer_TouchArea_Preset_2/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_2_ButtonWidget_enShortPress, 0x0E3F5581); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_3_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0xaaaa6541 /* Layer_TouchArea_Preset_3/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_3_ButtonWidget_enShortPress, 0x7D19807F); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_4_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0x378f839d /* Layer_TouchArea_Preset_4/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_4_ButtonWidget_enShortPress, 0xBD75EB96); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_5_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0xd80bf0d5 /* Layer_TouchArea_Preset_5/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_5_ButtonWidget_enShortPress, 0xF89B891E); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_6_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0xad746719 /* Layer_TouchArea_Preset_6/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_6_ButtonWidget_enShortPress, 0x27833B53); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_1_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0x5e7e68f4 /* Layer_TouchArea_Preset_1/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_1_ButtonWidget_enShortPressRelease, 0x6B749399); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_1_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0x5e7e68f4 /* Layer_TouchArea_Preset_1/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_1_ButtonWidget_enRelease, 0xEE373D1B); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_8_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0x84fb073a /* Layer_TouchArea_Preset_8/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_8_ButtonWidget_enLongPressRelease, 0x6A294A68); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_7_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0xf4b7f014 /* Layer_TouchArea_Preset_7/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_7_ButtonWidget_enLongPressRelease, 0xAB5331E4); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_6_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0xad746719 /* Layer_TouchArea_Preset_6/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_6_ButtonWidget_enLongPressRelease, 0x2C779392); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_6_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0xad746719 /* Layer_TouchArea_Preset_6/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_6_ButtonWidget_enRelease, 0x77B62845); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_7_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0xf4b7f014 /* Layer_TouchArea_Preset_7/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_7_ButtonWidget_enRelease, 0x082D7CA8); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_8_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0x84fb073a /* Layer_TouchArea_Preset_8/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_8_ButtonWidget_enRelease, 0x17EDA9D8); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_9_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0xc48d7eaa /* Layer_TouchArea_Preset_9/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_9_ButtonWidget_enRelease, 0x85ED30F9); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_10_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0xb9da2cf8 /* Layer_TouchArea_Preset_10/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_10_ButtonWidget_enRelease, 0xE42E8222); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_11_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0x582a8787 /* Layer_TouchArea_Preset_11/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_11_ButtonWidget_enRelease, 0xC8550E7F); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_12_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0xf3c138d5 /* Layer_TouchArea_Preset_12/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_12_ButtonWidget_enRelease, 0x11C93659); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_5_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0xd80bf0d5 /* Layer_TouchArea_Preset_5/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_5_ButtonWidget_enRelease, 0x899F9EE9); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_1_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0x5e7e68f4 /* Layer_TouchArea_Preset_1/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_1_ButtonWidget_enLongPress, 0x4493998D); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_3_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0xaaaa6541 /* Layer_TouchArea_Preset_3/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_3_ButtonWidget_enLongPress, 0xDB337F4A); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_4_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0x378f839d /* Layer_TouchArea_Preset_4/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_4_ButtonWidget_enLongPress, 0x94B45D60); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_5_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0xd80bf0d5 /* Layer_TouchArea_Preset_5/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_5_ButtonWidget_enLongPress, 0x06745D3C); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_6_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0xad746719 /* Layer_TouchArea_Preset_6/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_6_ButtonWidget_enLongPress, 0xA0C900B0); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_7_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0xf4b7f014 /* Layer_TouchArea_Preset_7/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_7_ButtonWidget_enLongPress, 0xEE638A03); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_8_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0x84fb073a /* Layer_TouchArea_Preset_8/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_8_ButtonWidget_enLongPress, 0x1B6C2818); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_9_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0xc48d7eaa /* Layer_TouchArea_Preset_9/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_9_ButtonWidget_enLongPress, 0xEF9C194D); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_2_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0x966c3b3e /* Layer_TouchArea_Preset_2/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_2_ButtonWidget_enLongPress, 0x53269E5E); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_4_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0x378f839d /* Layer_TouchArea_Preset_4/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_4_ButtonWidget_enRelease, 0x17A29976); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_3_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0xaaaa6541 /* Layer_TouchArea_Preset_3/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_3_ButtonWidget_enRelease, 0xB4B229F5); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_2_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0x966c3b3e /* Layer_TouchArea_Preset_2/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_2_ButtonWidget_enRelease, 0xA70BAA3C); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_Gadget_Tuner_MASTER_GADGET_TUNER_SEEKMENU_Btn_Next_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#Gadget_Tuner#MASTER_GADGET_TUNER_SEEKMENU")) && (message.GetSender() == ::Courier::Identifier(0x3b0da4f7 /* Btn_Next/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_Gadget_Tuner_MASTER_GADGET_TUNER_SEEKMENU_Btn_Next_ButtonWidget_enRelease, 0xD7F395A9); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_Gadget_Tuner_MASTER_GADGET_TUNER_SEEKMENU_Btn_Scan_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#Gadget_Tuner#MASTER_GADGET_TUNER_SEEKMENU")) && (message.GetSender() == ::Courier::Identifier(0x63fcfcd3 /* Btn_Scan/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_Gadget_Tuner_MASTER_GADGET_TUNER_SEEKMENU_Btn_Scan_ButtonWidget_enRelease, 0x5C711E51); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_Gadget_Tuner_MASTER_GADGET_TUNER_Btn_Previous_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#Gadget_Tuner#MASTER_GADGET_TUNER")) && (message.GetSender() == ::Courier::Identifier(0xd3bad9ef /* Btn_Previous/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_Gadget_Tuner_MASTER_GADGET_TUNER_Btn_Previous_ButtonWidget_enRelease, 0x64CAF927); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_Gadget_Tuner_MASTER_GADGET_TUNER_Btn_Next_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#Gadget_Tuner#MASTER_GADGET_TUNER")) && (message.GetSender() == ::Courier::Identifier(0x3b0da4f7 /* Btn_Next/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_Gadget_Tuner_MASTER_GADGET_TUNER_Btn_Next_ButtonWidget_enRelease, 0x1C026F8D); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_Gadget_Tuner_MASTER_GADGET_TUNER_Btn_Scan_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#Gadget_Tuner#MASTER_GADGET_TUNER")) && (message.GetSender() == ::Courier::Identifier(0x63fcfcd3 /* Btn_Scan/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_Gadget_Tuner_MASTER_GADGET_TUNER_Btn_Scan_ButtonWidget_enRelease, 0xFB706CB5); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_Gadget_Tuner_MASTER_GADGET_TUNER_Btn_Previous_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#Gadget_Tuner#MASTER_GADGET_TUNER")) && (message.GetSender() == ::Courier::Identifier(0xd3bad9ef /* Btn_Previous/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_Gadget_Tuner_MASTER_GADGET_TUNER_Btn_Previous_ButtonWidget_enShortPress, 0xE0F565F3); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_Gadget_Tuner_MASTER_GADGET_TUNER_Btn_Previous_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#Gadget_Tuner#MASTER_GADGET_TUNER")) && (message.GetSender() == ::Courier::Identifier(0xd3bad9ef /* Btn_Previous/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_Gadget_Tuner_MASTER_GADGET_TUNER_Btn_Previous_ButtonWidget_enShortPressRelease, 0xC8F602DD); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_Gadget_Tuner_MASTER_GADGET_TUNER_Btn_Previous_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#Gadget_Tuner#MASTER_GADGET_TUNER")) && (message.GetSender() == ::Courier::Identifier(0xd3bad9ef /* Btn_Previous/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_Gadget_Tuner_MASTER_GADGET_TUNER_Btn_Previous_ButtonWidget_enLongPressRelease, 0x16F5D51B); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_Gadget_Tuner_MASTER_GADGET_TUNER_Btn_Next_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#Gadget_Tuner#MASTER_GADGET_TUNER")) && (message.GetSender() == ::Courier::Identifier(0x3b0da4f7 /* Btn_Next/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_Gadget_Tuner_MASTER_GADGET_TUNER_Btn_Next_ButtonWidget_enShortPress, 0x2AD37770); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_Gadget_Tuner_MASTER_GADGET_TUNER_Btn_Next_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#Gadget_Tuner#MASTER_GADGET_TUNER")) && (message.GetSender() == ::Courier::Identifier(0x3b0da4f7 /* Btn_Next/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_Gadget_Tuner_MASTER_GADGET_TUNER_Btn_Next_ButtonWidget_enShortPressRelease, 0x8A16745D); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_Gadget_Tuner_MASTER_GADGET_TUNER_Btn_Next_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#Gadget_Tuner#MASTER_GADGET_TUNER")) && (message.GetSender() == ::Courier::Identifier(0x3b0da4f7 /* Btn_Next/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_Gadget_Tuner_MASTER_GADGET_TUNER_Btn_Next_ButtonWidget_enLongPressRelease, 0x14154BCC); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_Gadget_Tuner_MASTER_GADGET_TUNER_Button_Src_Select_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#Gadget_Tuner#MASTER_GADGET_TUNER")) && (message.GetSender() == ::Courier::Identifier(0xfeaeae87 /* Button_Src_Select/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_Gadget_Tuner_MASTER_GADGET_TUNER_Button_Src_Select_ButtonWidget_enRelease, 0x390CB324); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_Gadget_Tuner_MASTER_GADGET_TUNER_TouchArea_TunerBtn_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#Gadget_Tuner#MASTER_GADGET_TUNER")) && (message.GetSender() == ::Courier::Identifier(0x26df6cf0 /* TouchArea_TunerBtn/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_Gadget_Tuner_MASTER_GADGET_TUNER_TouchArea_TunerBtn_ButtonWidget_enRelease, 0xC4B502F4); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_Gadget_Tuner_MASTER_GADGET_TUNER_Toucharea_Tuner_icon_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#Gadget_Tuner#MASTER_GADGET_TUNER")) && (message.GetSender() == ::Courier::Identifier(0x2dbf30b4 /* Toucharea_Tuner_icon/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_Gadget_Tuner_MASTER_GADGET_TUNER_Toucharea_Tuner_icon_ButtonWidget_enRelease, 0xF3D582B9); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_Gadget_Tuner_MASTER_GADGET_TUNER_Btn_Previous_ButtonWidget_enAbortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#Gadget_Tuner#MASTER_GADGET_TUNER")) && (message.GetSender() == ::Courier::Identifier(0xd3bad9ef /* Btn_Previous/ButtonWidget */)) && (message.GetEnReaction() == enAbortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_Gadget_Tuner_MASTER_GADGET_TUNER_Btn_Previous_ButtonWidget_enAbortPress, 0xD5421C06); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_Gadget_Tuner_MASTER_GADGET_TUNER_Btn_Next_ButtonWidget_enAbortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#Gadget_Tuner#MASTER_GADGET_TUNER")) && (message.GetSender() == ::Courier::Identifier(0x3b0da4f7 /* Btn_Next/ButtonWidget */)) && (message.GetEnReaction() == enAbortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_Gadget_Tuner_MASTER_GADGET_TUNER_Btn_Next_ButtonWidget_enAbortPress, 0x9355116A); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_1_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0x5e7e68f4 /* Layer_TouchArea_Preset_1/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_1_ButtonWidget_enRelease, 0x46ADA2C7); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_10_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0xb9da2cf8 /* Layer_TouchArea_Preset_10/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_10_ButtonWidget_enLongPress, 0x759830FC); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_11_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0x582a8787 /* Layer_TouchArea_Preset_11/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_11_ButtonWidget_enLongPress, 0xE6A8C517); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_12_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0xf3c138d5 /* Layer_TouchArea_Preset_12/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_12_ButtonWidget_enLongPress, 0xE25B0779); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_1_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0x5e7e68f4 /* Layer_TouchArea_Preset_1/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_1_ButtonWidget_enShortPress, 0xE0582FE6); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_11_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0x582a8787 /* Layer_TouchArea_Preset_11/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_11_ButtonWidget_enShortPressRelease, 0xC767BEB3); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_12_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0xf3c138d5 /* Layer_TouchArea_Preset_12/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_12_ButtonWidget_enShortPressRelease, 0x1567387F); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_TestMode_Button_Back_BG_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_TestMode")) && (message.GetSender() == ::Courier::Identifier(0x408b82c4 /* Button_Back_BG/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_TestMode_Button_Back_BG_ButtonWidget_enRelease, 0xD8276E60); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_TestMode_btn_bn_back_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_TestMode")) && (message.GetSender() == ::Courier::Identifier(0x9b7f61fb /* btn_bn_back */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_TestMode_btn_bn_back_enLongPressRelease, 0x364AB166); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_TestMode_btn_bn_next_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_TestMode")) && (message.GetSender() == ::Courier::Identifier(0xcd61a1b4 /* btn_bn_next */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_TestMode_btn_bn_next_enRelease, 0x443B0CC8); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_TestModeScreen_btn_bn_FreqNext_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM_TestModeScreen")) && (message.GetSender() == ::Courier::Identifier(0xdc9b22e0 /* btn_bn_FreqNext */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_TestModeScreen_btn_bn_FreqNext_enRelease, 0xF36FB8B4); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_TestModeScreen_btn_bn_FreqPrevious_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM_TestModeScreen")) && (message.GetSender() == ::Courier::Identifier(0x68f644e5 /* btn_bn_FreqPrevious */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_TestModeScreen_btn_bn_FreqPrevious_enRelease, 0xECD039A0); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_TestModeScreen_btn_bn_SIDNext_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM_TestModeScreen")) && (message.GetSender() == ::Courier::Identifier(0x421ca36c /* btn_bn_SIDNext */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_TestModeScreen_btn_bn_SIDNext_enRelease, 0x76759446); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_TestModeScreen_btn_bn_SIDPrevious_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DRM_TestModeScreen")) && (message.GetSender() == ::Courier::Identifier(0x92f5d2e4 /* btn_bn_SIDPrevious */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_TestModeScreen_btn_bn_SIDPrevious_enRelease, 0x516A1C6C); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_MonitorTestMode_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_MonitorTestMode")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_MonitorTestMode_Layer_TouchArea_Back_ButtonWidget_enRelease, 0x63BC3299); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_MonitorTestMode_Layer_TouchArea_Next_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_MonitorTestMode")) && (message.GetSender() == ::Courier::Identifier(0x4e7f0732 /* Layer_TouchArea_Next/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_MonitorTestMode_Layer_TouchArea_Next_ButtonWidget_enRelease, 0x3CDBDC02); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_MonitorTestMode_Layer_TouchArea_Source_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_MonitorTestMode")) && (message.GetSender() == ::Courier::Identifier(0xccdf81cf /* Layer_TouchArea_Source/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_MonitorTestMode_Layer_TouchArea_Source_ButtonWidget_enRelease, 0x8070457C); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_1_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0x5e7e68f4 /* Layer_TouchArea_Preset_1/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_1_ButtonWidget_enLongPressRelease, 0x2EC7161A); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_2_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0x966c3b3e /* Layer_TouchArea_Preset_2/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_2_ButtonWidget_enLongPressRelease, 0xEB36907F); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_3_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0xaaaa6541 /* Layer_TouchArea_Preset_3/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_3_ButtonWidget_enLongPressRelease, 0x85B63106); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_4_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0x378f839d /* Layer_TouchArea_Preset_4/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_4_ButtonWidget_enLongPressRelease, 0xA5807816); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_5_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0xd80bf0d5 /* Layer_TouchArea_Preset_5/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_5_ButtonWidget_enLongPressRelease, 0x8F261A90); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_10_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0xb9da2cf8 /* Layer_TouchArea_Preset_10/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_10_ButtonWidget_enShortPressRelease, 0x3791AC5D); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_HDDTM_TESTMODE_hd_param_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_HDDTM_TESTMODE")) && (message.GetSender() == ::Courier::Identifier(0x0990a844 /* hd_param/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_HDDTM_TESTMODE_hd_param_ButtonWidget_enRelease, 0xC6637899); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_9_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0xc48d7eaa /* Layer_TouchArea_Preset_9/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_9_ButtonWidget_enShortPressRelease, 0xF89153AD); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_7_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0xf4b7f014 /* Layer_TouchArea_Preset_7/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_7_ButtonWidget_enShortPressRelease, 0x14FE1E83); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_2_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0x966c3b3e /* Layer_TouchArea_Preset_2/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_2_ButtonWidget_enShortPress, 0xC9C9EDE4); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_3_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0xaaaa6541 /* Layer_TouchArea_Preset_3/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_3_ButtonWidget_enShortPress, 0x8877A666); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_4_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0x378f839d /* Layer_TouchArea_Preset_4/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_4_ButtonWidget_enShortPress, 0x992BC614); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_5_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0xd80bf0d5 /* Layer_TouchArea_Preset_5/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_5_ButtonWidget_enShortPress, 0x2CD4F5F0); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_6_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0xad746719 /* Layer_TouchArea_Preset_6/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_6_ButtonWidget_enShortPress, 0x116E6D3C); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_7_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0xf4b7f014 /* Layer_TouchArea_Preset_7/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_7_ButtonWidget_enShortPress, 0x3A45EBBF); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_8_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0x84fb073a /* Layer_TouchArea_Preset_8/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_8_ButtonWidget_enShortPress, 0x3A48B8BA); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_9_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0xc48d7eaa /* Layer_TouchArea_Preset_9/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_9_ButtonWidget_enShortPress, 0x2FCB095A); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_10_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0xb9da2cf8 /* Layer_TouchArea_Preset_10/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_10_ButtonWidget_enShortPress, 0x317B0881); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_11_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0x582a8787 /* Layer_TouchArea_Preset_11/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_11_ButtonWidget_enShortPress, 0x9D75CB7E); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_12_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0xf3c138d5 /* Layer_TouchArea_Preset_12/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_12_ButtonWidget_enShortPress, 0x04976511); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_1_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0x5e7e68f4 /* Layer_TouchArea_Preset_1/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_1_ButtonWidget_enShortPressRelease, 0x212E8ECA); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_2_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0x966c3b3e /* Layer_TouchArea_Preset_2/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_2_ButtonWidget_enShortPressRelease, 0x4159E176); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_3_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0xaaaa6541 /* Layer_TouchArea_Preset_3/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_3_ButtonWidget_enShortPressRelease, 0x18747CC3); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_4_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0x378f839d /* Layer_TouchArea_Preset_4/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_4_ButtonWidget_enShortPressRelease, 0x90C18513); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_5_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0xd80bf0d5 /* Layer_TouchArea_Preset_5/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_5_ButtonWidget_enShortPressRelease, 0x2E3A9B75); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_6_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0xad746719 /* Layer_TouchArea_Preset_6/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_6_ButtonWidget_enShortPressRelease, 0x53101FDD); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_8_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_S")) && (message.GetSender() == ::Courier::Identifier(0x84fb073a /* Layer_TouchArea_Preset_8/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_8_ButtonWidget_enShortPressRelease, 0x5749E156); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_3_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_AST")) && (message.GetSender() == ::Courier::Identifier(0xf6b6489f /* Layer_TouchArea_PresetAST_3/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_3_ButtonWidget_enShortPress, 0x4F264428); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_HDDTM_TESTMODE_HD_AudioProg0_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_HDDTM_TESTMODE")) && (message.GetSender() == ::Courier::Identifier(0x8e6f2e1d /* HD_AudioProg0/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_HDDTM_TESTMODE_HD_AudioProg0_ButtonWidget_enRelease, 0x1ADB8846); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_HDDTM_TESTMODE_HD_AudioProg2_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_HDDTM_TESTMODE")) && (message.GetSender() == ::Courier::Identifier(0xef0762bb /* HD_AudioProg2/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_HDDTM_TESTMODE_HD_AudioProg2_ButtonWidget_enRelease, 0x76C7819A); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_4_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_AST_S")) && (message.GetSender() == ::Courier::Identifier(0x378f839d /* Layer_TouchArea_Preset_4/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_4_ButtonWidget_enShortPressRelease, 0xF32708D9); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_5_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_AST_S")) && (message.GetSender() == ::Courier::Identifier(0xd80bf0d5 /* Layer_TouchArea_Preset_5/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_5_ButtonWidget_enShortPressRelease, 0x5B907E2D); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_6_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_AST_S")) && (message.GetSender() == ::Courier::Identifier(0xad746719 /* Layer_TouchArea_Preset_6/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_6_ButtonWidget_enShortPressRelease, 0xDF126B31); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_1_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_AST_S")) && (message.GetSender() == ::Courier::Identifier(0x5e7e68f4 /* Layer_TouchArea_Preset_1/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_1_ButtonWidget_enLongPress, 0x06205AB3); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_2_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_AST_S")) && (message.GetSender() == ::Courier::Identifier(0x966c3b3e /* Layer_TouchArea_Preset_2/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_2_ButtonWidget_enLongPress, 0xA759388A); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_3_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_AST_S")) && (message.GetSender() == ::Courier::Identifier(0xaaaa6541 /* Layer_TouchArea_Preset_3/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_3_ButtonWidget_enLongPress, 0xA5F28789); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_4_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_AST_S")) && (message.GetSender() == ::Courier::Identifier(0x378f839d /* Layer_TouchArea_Preset_4/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_4_ButtonWidget_enLongPress, 0xF02A9D91); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_3_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_AST_S")) && (message.GetSender() == ::Courier::Identifier(0xaaaa6541 /* Layer_TouchArea_Preset_3/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_3_ButtonWidget_enShortPressRelease, 0x6E44D9DA); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_5_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_AST_S")) && (message.GetSender() == ::Courier::Identifier(0xd80bf0d5 /* Layer_TouchArea_Preset_5/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_5_ButtonWidget_enLongPress, 0x27B62517); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_1_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_AST_S")) && (message.GetSender() == ::Courier::Identifier(0x5e7e68f4 /* Layer_TouchArea_Preset_1/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_1_ButtonWidget_enLongPressRelease, 0x84ED4AB9); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_2_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_AST_S")) && (message.GetSender() == ::Courier::Identifier(0x966c3b3e /* Layer_TouchArea_Preset_2/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_2_ButtonWidget_enLongPressRelease, 0x4F7DC1BE); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_3_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_AST_S")) && (message.GetSender() == ::Courier::Identifier(0xaaaa6541 /* Layer_TouchArea_Preset_3/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_3_ButtonWidget_enLongPressRelease, 0x5D849956); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_4_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_AST_S")) && (message.GetSender() == ::Courier::Identifier(0x378f839d /* Layer_TouchArea_Preset_4/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_4_ButtonWidget_enLongPressRelease, 0x293196CA); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_5_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_AST_S")) && (message.GetSender() == ::Courier::Identifier(0xd80bf0d5 /* Layer_TouchArea_Preset_5/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_5_ButtonWidget_enLongPressRelease, 0xCB9C528D); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_6_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_AST_S")) && (message.GetSender() == ::Courier::Identifier(0xad746719 /* Layer_TouchArea_Preset_6/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_6_ButtonWidget_enLongPressRelease, 0xB8F1B01B); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_SearchPrevious_ButtonWidget_enPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_AST_S")) && (message.GetSender() == ::Courier::Identifier(0xcd890a81 /* Layer_TouchArea_SearchPrevious/ButtonWidget */)) && (message.GetEnReaction() == enPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_SearchPrevious_ButtonWidget_enPress, 0x56261D13); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_6_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_AST_S")) && (message.GetSender() == ::Courier::Identifier(0xad746719 /* Layer_TouchArea_Preset_6/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_6_ButtonWidget_enLongPress, 0x3E2C3474); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_SearchNext_ButtonWidget_enPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_AST_S")) && (message.GetSender() == ::Courier::Identifier(0x26924a2e /* Layer_TouchArea_SearchNext/ButtonWidget */)) && (message.GetEnReaction() == enPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_SearchNext_ButtonWidget_enPress, 0xA56624CE); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_2_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_AST_S")) && (message.GetSender() == ::Courier::Identifier(0x966c3b3e /* Layer_TouchArea_Preset_2/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_2_ButtonWidget_enShortPressRelease, 0x9003E53B); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_6_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_AST_S")) && (message.GetSender() == ::Courier::Identifier(0xad746719 /* Layer_TouchArea_Preset_6/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_6_ButtonWidget_enShortPress, 0x87942F6E); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_TouchArea_FreqStepDown_normal_Button_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM2")) && (message.GetSender() == ::Courier::Identifier(0x2be9f953 /* TouchArea_FreqStepDown_normal/Button */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_TouchArea_FreqStepDown_normal_Button_enShortPress, 0x27EB987E); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_TouchArea_FreqStepUp_normal_Button_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM2")) && (message.GetSender() == ::Courier::Identifier(0x558a16a3 /* TouchArea_FreqStepUp_normal/Button */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_TouchArea_FreqStepUp_normal_Button_enLongPressRelease, 0xF6D89D73); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_TouchArea_FreqStepDown_normal_Button_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM2")) && (message.GetSender() == ::Courier::Identifier(0x2be9f953 /* TouchArea_FreqStepDown_normal/Button */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_TouchArea_FreqStepDown_normal_Button_enLongPressRelease, 0xE08BD495); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Source_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_AST_S")) && (message.GetSender() == ::Courier::Identifier(0xccdf81cf /* Layer_TouchArea_Source/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Source_ButtonWidget_enRelease, 0x88AB8EFB); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_AST_ButtonWidget_enPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_AST_S")) && (message.GetSender() == ::Courier::Identifier(0x9e370d5d /* Layer_TouchArea_AST/ButtonWidget */)) && (message.GetEnReaction() == enPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_AST_ButtonWidget_enPress, 0x474FA1EA); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_1_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_AST_S")) && (message.GetSender() == ::Courier::Identifier(0x5e7e68f4 /* Layer_TouchArea_Preset_1/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_1_ButtonWidget_enRelease, 0x6BB29A68); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_2_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_AST_S")) && (message.GetSender() == ::Courier::Identifier(0x966c3b3e /* Layer_TouchArea_Preset_2/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_2_ButtonWidget_enRelease, 0x71C4871D); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_1_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_AST_S")) && (message.GetSender() == ::Courier::Identifier(0x5e7e68f4 /* Layer_TouchArea_Preset_1/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_1_ButtonWidget_enShortPressRelease, 0xFA3E444F); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_3_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_AST_S")) && (message.GetSender() == ::Courier::Identifier(0xaaaa6541 /* Layer_TouchArea_Preset_3/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_3_ButtonWidget_enRelease, 0x4DEF57C1); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_5_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_AST_S")) && (message.GetSender() == ::Courier::Identifier(0xd80bf0d5 /* Layer_TouchArea_Preset_5/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_5_ButtonWidget_enRelease, 0x308166C4); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_6_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_AST_S")) && (message.GetSender() == ::Courier::Identifier(0xad746719 /* Layer_TouchArea_Preset_6/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_6_ButtonWidget_enRelease, 0xA48A190D); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_1_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_AST_S")) && (message.GetSender() == ::Courier::Identifier(0x5e7e68f4 /* Layer_TouchArea_Preset_1/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_1_ButtonWidget_enShortPress, 0xE47EA582); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_2_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_AST_S")) && (message.GetSender() == ::Courier::Identifier(0x966c3b3e /* Layer_TouchArea_Preset_2/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_2_ButtonWidget_enShortPress, 0x806100F1); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_3_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_AST_S")) && (message.GetSender() == ::Courier::Identifier(0xaaaa6541 /* Layer_TouchArea_Preset_3/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_3_ButtonWidget_enShortPress, 0xA8E944E2); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_4_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_AST_S")) && (message.GetSender() == ::Courier::Identifier(0x378f839d /* Layer_TouchArea_Preset_4/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_4_ButtonWidget_enShortPress, 0x4D52566C); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_5_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_AST_S")) && (message.GetSender() == ::Courier::Identifier(0xd80bf0d5 /* Layer_TouchArea_Preset_5/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_5_ButtonWidget_enShortPress, 0x22B5D5F3); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_4_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_AST_S")) && (message.GetSender() == ::Courier::Identifier(0x378f839d /* Layer_TouchArea_Preset_4/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_4_ButtonWidget_enRelease, 0x273BB142); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_HDDTM_TESTMODE_HD_AudioProg1_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_HDDTM_TESTMODE")) && (message.GetSender() == ::Courier::Identifier(0x6fb329fb /* HD_AudioProg1/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_HDDTM_TESTMODE_HD_AudioProg1_ButtonWidget_enRelease, 0x14391799); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_SearchPrevious_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_AST_S")) && (message.GetSender() == ::Courier::Identifier(0xcd890a81 /* Layer_TouchArea_SearchPrevious/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_SearchPrevious_ButtonWidget_enShortPress, 0xD4D4D6F4); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_SearchPrevious_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_AST_S")) && (message.GetSender() == ::Courier::Identifier(0xcd890a81 /* Layer_TouchArea_SearchPrevious/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_SearchPrevious_ButtonWidget_enRelease, 0x728DC305); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_MonitorTestMode_ButtonToggle_RDS_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_MonitorTestMode")) && (message.GetSender() == ::Courier::Identifier(0x9536f980 /* ButtonToggle_RDS/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_MonitorTestMode_ButtonToggle_RDS_ButtonWidget2D_enRelease, 0x7006A7D8); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_MonitorTestMode_ButtonToggle_PhaseDiversity_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_MonitorTestMode")) && (message.GetSender() == ::Courier::Identifier(0x20afa82d /* ButtonToggle_PhaseDiversity/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_MonitorTestMode_ButtonToggle_PhaseDiversity_ButtonWidget2D_enRelease, 0x72F9BA11); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_MonitorTestMode_Btn_Sharx_Inc_Button_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_MonitorTestMode")) && (message.GetSender() == ::Courier::Identifier(0xff2f1012 /* Btn_Sharx_Inc/Button */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_MonitorTestMode_Btn_Sharx_Inc_Button_enRelease, 0x7A7E6D09); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_MonitorTestMode_Btn_Sharx_Dec_Button_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_MonitorTestMode")) && (message.GetSender() == ::Courier::Identifier(0x4726bc2f /* Btn_Sharx_Dec/Button */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_MonitorTestMode_Btn_Sharx_Dec_Button_enRelease, 0xAFAD9DB3); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_MonitorTestMode_Btn_Highcut_Inc_Button_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_MonitorTestMode")) && (message.GetSender() == ::Courier::Identifier(0x52c2d123 /* Btn_Highcut_Inc/Button */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_MonitorTestMode_Btn_Highcut_Inc_Button_enRelease, 0x269F6639); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_MonitorTestMode_Btn_Highcut_Dec_Button_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_MonitorTestMode")) && (message.GetSender() == ::Courier::Identifier(0x34dec3af /* Btn_Highcut_Dec/Button */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_MonitorTestMode_Btn_Highcut_Dec_Button_enRelease, 0x389F0EB9); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_AST_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_AST")) && (message.GetSender() == ::Courier::Identifier(0x9e370d5d /* Layer_TouchArea_AST/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_AST_ButtonWidget_enShortPress, 0xF62CB356); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_MonitorTestMode_ButtonToggle_Measure_Mode_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_MonitorTestMode")) && (message.GetSender() == ::Courier::Identifier(0xe5a0b179 /* ButtonToggle_Measure_Mode/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_MonitorTestMode_ButtonToggle_Measure_Mode_ButtonWidget2D_enRelease, 0x5564A12B); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_AST_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_AST")) && (message.GetSender() == ::Courier::Identifier(0x9e370d5d /* Layer_TouchArea_AST/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_AST_ButtonWidget_enShortPressRelease, 0x9D5F67B7); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_1_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_AST")) && (message.GetSender() == ::Courier::Identifier(0x7a1cabdb /* Layer_TouchArea_PresetAST_1/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_1_ButtonWidget_enRelease, 0x5F7D2253); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_2_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_AST")) && (message.GetSender() == ::Courier::Identifier(0x39c4e83d /* Layer_TouchArea_PresetAST_2/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_2_ButtonWidget_enRelease, 0x59FF19B6); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_3_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_AST")) && (message.GetSender() == ::Courier::Identifier(0xf6b6489f /* Layer_TouchArea_PresetAST_3/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_3_ButtonWidget_enRelease, 0xD543C304); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_4_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_AST")) && (message.GetSender() == ::Courier::Identifier(0x427883c0 /* Layer_TouchArea_PresetAST_4/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_4_ButtonWidget_enRelease, 0x4A9C9FE0); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_5_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_AST")) && (message.GetSender() == ::Courier::Identifier(0x134d2804 /* Layer_TouchArea_PresetAST_5/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_5_ButtonWidget_enRelease, 0xC0AD568E); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_6_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_AST")) && (message.GetSender() == ::Courier::Identifier(0x4d32eac1 /* Layer_TouchArea_PresetAST_6/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_6_ButtonWidget_enRelease, 0xF0DFCAA6); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_1_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_AST")) && (message.GetSender() == ::Courier::Identifier(0x7a1cabdb /* Layer_TouchArea_PresetAST_1/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_1_ButtonWidget_enShortPress, 0xC87FFF5E); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_AST_ButtonWidget_enPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_AST")) && (message.GetSender() == ::Courier::Identifier(0x9e370d5d /* Layer_TouchArea_AST/ButtonWidget */)) && (message.GetEnReaction() == enPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_AST_ButtonWidget_enPress, 0xEE3D39DB); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_SearchNext_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_AST_S")) && (message.GetSender() == ::Courier::Identifier(0x26924a2e /* Layer_TouchArea_SearchNext/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_SearchNext_ButtonWidget_enShortPress, 0x3D0E0BBD); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_MonitorTestMode_ButtonToggle_TAStatus_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_MonitorTestMode")) && (message.GetSender() == ::Courier::Identifier(0x8c94ae00 /* ButtonToggle_TAStatus/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_MonitorTestMode_ButtonToggle_TAStatus_ButtonWidget2D_enRelease, 0xDF32F839); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Icon_StationList_Button_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_AST")) && (message.GetSender() == ::Courier::Identifier(0xf49b3391 /* Icon_StationList/Button */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Icon_StationList_Button_enRelease, 0x28B0B313); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_SearchNext_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_AST_S")) && (message.GetSender() == ::Courier::Identifier(0x26924a2e /* Layer_TouchArea_SearchNext/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_SearchNext_ButtonWidget_enRelease, 0x7CEBFE69); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_SearchPrevious_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_AST_S")) && (message.GetSender() == ::Courier::Identifier(0xcd890a81 /* Layer_TouchArea_SearchPrevious/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_SearchPrevious_ButtonWidget_enShortPressRelease, 0x6EB62F3A); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_SearchNext_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_AST_S")) && (message.GetSender() == ::Courier::Identifier(0x26924a2e /* Layer_TouchArea_SearchNext/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_SearchNext_ButtonWidget_enShortPressRelease, 0x97FBF963); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_SearchPrevious_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_AST_S")) && (message.GetSender() == ::Courier::Identifier(0xcd890a81 /* Layer_TouchArea_SearchPrevious/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_SearchPrevious_ButtonWidget_enLongPressRelease, 0xD211F4E4); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_SearchNext_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_AST_S")) && (message.GetSender() == ::Courier::Identifier(0x26924a2e /* Layer_TouchArea_SearchNext/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_SearchNext_ButtonWidget_enLongPressRelease, 0x2B484D74); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_TouchArea_FreqStepUp_normal_Button_enPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_AST_S")) && (message.GetSender() == ::Courier::Identifier(0x558a16a3 /* TouchArea_FreqStepUp_normal/Button */)) && (message.GetEnReaction() == enPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_TouchArea_FreqStepUp_normal_Button_enPress, 0x888991A8); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_TouchArea_FreqStepDown_normal_Button_enPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_AST_S")) && (message.GetSender() == ::Courier::Identifier(0x2be9f953 /* TouchArea_FreqStepDown_normal/Button */)) && (message.GetEnReaction() == enPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_TouchArea_FreqStepDown_normal_Button_enPress, 0xC129729A); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_MonitorTestMode_ButtonToggle_AF_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_MonitorTestMode")) && (message.GetSender() == ::Courier::Identifier(0xf0689a7e /* ButtonToggle_AF/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_MonitorTestMode_ButtonToggle_AF_ButtonWidget2D_enRelease, 0x6492A8C1); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_TouchArea_FreqStepUp_normal_Button_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_AST_S")) && (message.GetSender() == ::Courier::Identifier(0x558a16a3 /* TouchArea_FreqStepUp_normal/Button */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_TouchArea_FreqStepUp_normal_Button_enShortPressRelease, 0xDB06B90A); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_TouchArea_FreqStepUp_normal_Button_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_AST_S")) && (message.GetSender() == ::Courier::Identifier(0x558a16a3 /* TouchArea_FreqStepUp_normal/Button */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_TouchArea_FreqStepUp_normal_Button_enRelease, 0x34D7DF58); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_TouchArea_FreqStepDown_normal_Button_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_AST_S")) && (message.GetSender() == ::Courier::Identifier(0x2be9f953 /* TouchArea_FreqStepDown_normal/Button */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_TouchArea_FreqStepDown_normal_Button_enRelease, 0x447DADF8); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_TouchArea_FreqStepUp_normal_Button_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_AST_S")) && (message.GetSender() == ::Courier::Identifier(0x558a16a3 /* TouchArea_FreqStepUp_normal/Button */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_TouchArea_FreqStepUp_normal_Button_enShortPress, 0xBCF7874C); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_TouchArea_FreqStepDown_normal_Button_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_AST_S")) && (message.GetSender() == ::Courier::Identifier(0x2be9f953 /* TouchArea_FreqStepDown_normal/Button */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_TouchArea_FreqStepDown_normal_Button_enShortPress, 0x08A900A8); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_TouchArea_FreqStepUp_normal_Button_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_AST_S")) && (message.GetSender() == ::Courier::Identifier(0x558a16a3 /* TouchArea_FreqStepUp_normal/Button */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_TouchArea_FreqStepUp_normal_Button_enLongPressRelease, 0xDDEF57C5); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_TouchArea_FreqStepDown_normal_Button_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_AST_S")) && (message.GetSender() == ::Courier::Identifier(0x2be9f953 /* TouchArea_FreqStepDown_normal/Button */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_TouchArea_FreqStepDown_normal_Button_enLongPressRelease, 0x7371CE65); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_Source_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM_AST")) && (message.GetSender() == ::Courier::Identifier(0xccdf81cf /* Layer_TouchArea_Source/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_Source_ButtonWidget_enRelease, 0xA935A6C7); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_TouchArea_FreqStepDown_normal_Button_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_AM_AST_S")) && (message.GetSender() == ::Courier::Identifier(0x2be9f953 /* TouchArea_FreqStepDown_normal/Button */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_TouchArea_FreqStepDown_normal_Button_enShortPressRelease, 0x5C6D9A83); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_TouchArea_FreqStepDown_normal_Button_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM2")) && (message.GetSender() == ::Courier::Identifier(0x2be9f953 /* TouchArea_FreqStepDown_normal/Button */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_TouchArea_FreqStepDown_normal_Button_enRelease, 0xA0E1B98E); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_TouchArea_FreqStepUp_normal_Button_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM2")) && (message.GetSender() == ::Courier::Identifier(0x558a16a3 /* TouchArea_FreqStepUp_normal/Button */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_TouchArea_FreqStepUp_normal_Button_enShortPress, 0x8B6418E7); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_TouchArea_FreqStepDown_normal_Button_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM2")) && (message.GetSender() == ::Courier::Identifier(0x2be9f953 /* TouchArea_FreqStepDown_normal/Button */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_TouchArea_FreqStepDown_normal_Button_enShortPressRelease, 0x36A9BB31); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_SearchNext_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0x26924a2e /* Layer_TouchArea_SearchNext/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_SearchNext_ButtonWidget_enLongPressRelease, 0xD1FC5598); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Scan_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0x4cf01c3a /* Layer_TouchArea_Scan/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Scan_ButtonWidget_enRelease, 0xA0988654); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_TouchArea_FreqStepUp_normal_Button_enPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0x558a16a3 /* TouchArea_FreqStepUp_normal/Button */)) && (message.GetEnReaction() == enPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_TouchArea_FreqStepUp_normal_Button_enPress, 0xEA6B1FAB); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_TouchArea_FreqStepDown_normal_Button_enPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0x2be9f953 /* TouchArea_FreqStepDown_normal/Button */)) && (message.GetEnReaction() == enPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_TouchArea_FreqStepDown_normal_Button_enPress, 0xF8F98CAF); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_TouchArea_FreqStepUp_normal_Button_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0x558a16a3 /* TouchArea_FreqStepUp_normal/Button */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_TouchArea_FreqStepUp_normal_Button_enShortPress, 0xAE5F9D6A); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_TouchArea_FreqStepDown_normal_Button_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0x2be9f953 /* TouchArea_FreqStepDown_normal/Button */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_TouchArea_FreqStepDown_normal_Button_enShortPress, 0xDA27BE41); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_TouchArea_FreqStepUp_normal_Button_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0x558a16a3 /* TouchArea_FreqStepUp_normal/Button */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_TouchArea_FreqStepUp_normal_Button_enRelease, 0x63AD203E); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_TouchArea_FreqStepDown_normal_Button_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0x2be9f953 /* TouchArea_FreqStepDown_normal/Button */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_TouchArea_FreqStepDown_normal_Button_enRelease, 0x2CFE314F); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_TouchArea_FreqStepUp_normal_Button_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0x558a16a3 /* TouchArea_FreqStepUp_normal/Button */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_TouchArea_FreqStepUp_normal_Button_enShortPressRelease, 0x1DFC9F30); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_TouchArea_FreqStepDown_normal_Button_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0x2be9f953 /* TouchArea_FreqStepDown_normal/Button */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_TouchArea_FreqStepDown_normal_Button_enShortPressRelease, 0x6D17825E); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_TouchArea_FreqStepUp_normal_Button_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0x558a16a3 /* TouchArea_FreqStepUp_normal/Button */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_TouchArea_FreqStepUp_normal_Button_enLongPressRelease, 0x84AA06C8); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_TouchArea_FreqStepDown_normal_Button_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0x2be9f953 /* TouchArea_FreqStepDown_normal/Button */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_TouchArea_FreqStepDown_normal_Button_enLongPressRelease, 0x5A75311D); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_Layer_TouchArea_Source_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM2")) && (message.GetSender() == ::Courier::Identifier(0xccdf81cf /* Layer_TouchArea_Source/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_Layer_TouchArea_Source_ButtonWidget_enRelease, 0x26361D97); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_Icon_StationList_Button_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM2")) && (message.GetSender() == ::Courier::Identifier(0xf49b3391 /* Icon_StationList/Button */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_Icon_StationList_Button_enRelease, 0x15BE2E33); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_7_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0xf4b7f014 /* Layer_TouchArea_Preset_7/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_7_ButtonWidget_enRelease, 0xF6A93FB9); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_8_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0x84fb073a /* Layer_TouchArea_Preset_8/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_8_ButtonWidget_enRelease, 0xC41ECF97); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_9_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0xc48d7eaa /* Layer_TouchArea_Preset_9/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_9_ButtonWidget_enRelease, 0xBF26DDAF); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_SearchPrevious_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0xcd890a81 /* Layer_TouchArea_SearchPrevious/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_SearchPrevious_ButtonWidget_enLongPressRelease, 0xC7894926); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_10_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0xb9da2cf8 /* Layer_TouchArea_Preset_10/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_10_ButtonWidget_enRelease, 0xBEA9D798); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_SearchNext_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0x26924a2e /* Layer_TouchArea_SearchNext/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_SearchNext_ButtonWidget_enShortPress, 0xD8E10EDA); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_SearchNext_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0x26924a2e /* Layer_TouchArea_SearchNext/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_SearchNext_ButtonWidget_enRelease, 0x2664B609); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_HDDTM_TESTMODE_HD_AudioProg3_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_HDDTM_TESTMODE")) && (message.GetSender() == ::Courier::Identifier(0x6dbd36e0 /* HD_AudioProg3/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_HDDTM_TESTMODE_HD_AudioProg3_ButtonWidget_enRelease, 0xA5B75E13); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_HDDTM_TESTMODE_HD_AudioProg4_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_HDDTM_TESTMODE")) && (message.GetSender() == ::Courier::Identifier(0xb20ecb3e /* HD_AudioProg4/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_HDDTM_TESTMODE_HD_AudioProg4_ButtonWidget_enRelease, 0x3EB39933); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_HDDTM_TESTMODE_HD_AudioProg5_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_HDDTM_TESTMODE")) && (message.GetSender() == ::Courier::Identifier(0x23534486 /* HD_AudioProg5/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_HDDTM_TESTMODE_HD_AudioProg5_ButtonWidget_enRelease, 0x75F8D553); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_HDDTM_TESTMODE_HD_AudioProg6_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_HDDTM_TESTMODE")) && (message.GetSender() == ::Courier::Identifier(0x0ae53e20 /* HD_AudioProg6/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_HDDTM_TESTMODE_HD_AudioProg6_ButtonWidget_enRelease, 0x9AD8AE56); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_HDDTM_TESTMODE_HD_AudioProg7_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_HDDTM_TESTMODE")) && (message.GetSender() == ::Courier::Identifier(0x551943e0 /* HD_AudioProg7/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_HDDTM_TESTMODE_HD_AudioProg7_ButtonWidget_enRelease, 0x672650AB); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_HDPARAMTUNING_TESTMODE_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_HDPARAMTUNING_TESTMODE")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_HDPARAMTUNING_TESTMODE_Layer_TouchArea_Back_ButtonWidget_enRelease, 0x094B0587); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_HDPARAMTUNING_TESTMODE_Increment_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_HDPARAMTUNING_TESTMODE")) && (message.GetSender() == ::Courier::Identifier(0xa7429c17 /* Increment/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_HDPARAMTUNING_TESTMODE_Increment_ButtonWidget_enRelease, 0x66A80D9E); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_HDPARAMTUNING_TESTMODE_Decrement_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_HDPARAMTUNING_TESTMODE")) && (message.GetSender() == ::Courier::Identifier(0x7ddd3509 /* Decrement/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_HDPARAMTUNING_TESTMODE_Decrement_ButtonWidget_enRelease, 0x6D12A683); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_1_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0x5e7e68f4 /* Layer_TouchArea_Preset_1/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_1_ButtonWidget_enLongPressRelease, 0xD37904DE); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_2_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0x966c3b3e /* Layer_TouchArea_Preset_2/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_2_ButtonWidget_enLongPressRelease, 0xF57612C6); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_3_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0xaaaa6541 /* Layer_TouchArea_Preset_3/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_3_ButtonWidget_enLongPressRelease, 0xE0EC18E7); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_4_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0x378f839d /* Layer_TouchArea_Preset_4/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_4_ButtonWidget_enLongPressRelease, 0x8CA552F1); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_5_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0xd80bf0d5 /* Layer_TouchArea_Preset_5/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_5_ButtonWidget_enLongPressRelease, 0x68D37CD2); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_6_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0xad746719 /* Layer_TouchArea_Preset_6/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_6_ButtonWidget_enLongPressRelease, 0xE85064FD); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_SearchPrevious_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0xcd890a81 /* Layer_TouchArea_SearchPrevious/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_SearchPrevious_ButtonWidget_enShortPressRelease, 0x674CA16A); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_SearchNext_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0x26924a2e /* Layer_TouchArea_SearchNext/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_SearchNext_ButtonWidget_enShortPressRelease, 0xA6CBFF45); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_SearchPrevious_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0xcd890a81 /* Layer_TouchArea_SearchPrevious/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_SearchPrevious_ButtonWidget_enRelease, 0x84B97ACD); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_SearchPrevious_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0xcd890a81 /* Layer_TouchArea_SearchPrevious/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_SearchPrevious_ButtonWidget_enShortPress, 0xAAE3F889); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_11_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0x582a8787 /* Layer_TouchArea_Preset_11/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_11_ButtonWidget_enRelease, 0x0E290CB5); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Monitor_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_DAB_Monitor")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Monitor_Layer_TouchArea_Back_ButtonWidget_enRelease, 0x80792D1F); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_11_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0x582a8787 /* Layer_TouchArea_Preset_11/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_11_ButtonWidget_enLongPress, 0xC3C1612D); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_12_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0xf3c138d5 /* Layer_TouchArea_Preset_12/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_12_ButtonWidget_enLongPress, 0x1DD978E7); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_7_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0xf4b7f014 /* Layer_TouchArea_Preset_7/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_7_ButtonWidget_enLongPressRelease, 0xDDFBFA8B); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_8_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0x84fb073a /* Layer_TouchArea_Preset_8/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_8_ButtonWidget_enLongPressRelease, 0x63E577D7); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_9_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0xc48d7eaa /* Layer_TouchArea_Preset_9/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_9_ButtonWidget_enLongPressRelease, 0x25EC50C7); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_10_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0xb9da2cf8 /* Layer_TouchArea_Preset_10/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_10_ButtonWidget_enLongPressRelease, 0x97D03230); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_11_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0x582a8787 /* Layer_TouchArea_Preset_11/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_11_ButtonWidget_enLongPressRelease, 0x17E35B67); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_12_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0xf3c138d5 /* Layer_TouchArea_Preset_12/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_12_ButtonWidget_enLongPressRelease, 0x272A8DF7); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_Layer_TouchArea_SearchPrevious_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM2")) && (message.GetSender() == ::Courier::Identifier(0xcd890a81 /* Layer_TouchArea_SearchPrevious/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_Layer_TouchArea_SearchPrevious_ButtonWidget_enShortPressRelease, 0x4CE8B8B8); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_Layer_TouchArea_SearchNext_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM2")) && (message.GetSender() == ::Courier::Identifier(0x26924a2e /* Layer_TouchArea_SearchNext/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_Layer_TouchArea_SearchNext_ButtonWidget_enShortPressRelease, 0x0BDD0E9C); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_Layer_TouchArea_SearchPrevious_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM2")) && (message.GetSender() == ::Courier::Identifier(0xcd890a81 /* Layer_TouchArea_SearchPrevious/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_Layer_TouchArea_SearchPrevious_ButtonWidget_enShortPress, 0x212CEA25); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_Layer_TouchArea_SearchNext_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM2")) && (message.GetSender() == ::Courier::Identifier(0x26924a2e /* Layer_TouchArea_SearchNext/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_Layer_TouchArea_SearchNext_ButtonWidget_enShortPress, 0x835F4E31); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_Layer_TouchArea_SearchPrevious_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM2")) && (message.GetSender() == ::Courier::Identifier(0xcd890a81 /* Layer_TouchArea_SearchPrevious/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_Layer_TouchArea_SearchPrevious_ButtonWidget_enRelease, 0x0BFE3142); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_Layer_TouchArea_SearchNext_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM2")) && (message.GetSender() == ::Courier::Identifier(0x26924a2e /* Layer_TouchArea_SearchNext/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_Layer_TouchArea_SearchNext_ButtonWidget_enRelease, 0x0C57852B); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_Layer_TouchArea_SearchPrevious_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM2")) && (message.GetSender() == ::Courier::Identifier(0xcd890a81 /* Layer_TouchArea_SearchPrevious/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_Layer_TouchArea_SearchPrevious_ButtonWidget_enLongPressRelease, 0x04D9CF19); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_Layer_TouchArea_SearchNext_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM2")) && (message.GetSender() == ::Courier::Identifier(0x26924a2e /* Layer_TouchArea_SearchNext/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_Layer_TouchArea_SearchNext_ButtonWidget_enLongPressRelease, 0x1CF8FA84); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_TouchArea_FreqStepUp_normal_Button_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM2")) && (message.GetSender() == ::Courier::Identifier(0x558a16a3 /* TouchArea_FreqStepUp_normal/Button */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_TouchArea_FreqStepUp_normal_Button_enRelease, 0x76588B9B); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_10_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0xb9da2cf8 /* Layer_TouchArea_Preset_10/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_10_ButtonWidget_enLongPress, 0x020147B0); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_9_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0xc48d7eaa /* Layer_TouchArea_Preset_9/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_9_ButtonWidget_enLongPress, 0xEA98AFC5); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_8_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0x84fb073a /* Layer_TouchArea_Preset_8/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_8_ButtonWidget_enLongPress, 0xB7055080); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_TouchArea_FreqStepUp_normal_Button_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM2")) && (message.GetSender() == ::Courier::Identifier(0x558a16a3 /* TouchArea_FreqStepUp_normal/Button */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_TouchArea_FreqStepUp_normal_Button_enShortPressRelease, 0x8412516D); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_TouchArea_FreqStepDown_normal_Button_enPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM2")) && (message.GetSender() == ::Courier::Identifier(0x2be9f953 /* TouchArea_FreqStepDown_normal/Button */)) && (message.GetEnReaction() == enPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_TouchArea_FreqStepDown_normal_Button_enPress, 0x80262CF0); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_12_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0xf3c138d5 /* Layer_TouchArea_Preset_12/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_12_ButtonWidget_enRelease, 0x7EF70B29); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_7_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0xf4b7f014 /* Layer_TouchArea_Preset_7/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_7_ButtonWidget_enShortPress, 0x4E61B2D8); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_8_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0x84fb073a /* Layer_TouchArea_Preset_8/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_8_ButtonWidget_enShortPress, 0x26141D75); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_9_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0xc48d7eaa /* Layer_TouchArea_Preset_9/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_9_ButtonWidget_enShortPress, 0x314E5993); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_10_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0xb9da2cf8 /* Layer_TouchArea_Preset_10/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_10_ButtonWidget_enShortPress, 0x2A732173); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_Layer_TouchArea_Scan_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM2")) && (message.GetSender() == ::Courier::Identifier(0x4cf01c3a /* Layer_TouchArea_Scan/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_Layer_TouchArea_Scan_ButtonWidget_enRelease, 0x984679EE); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_11_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0x582a8787 /* Layer_TouchArea_Preset_11/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_11_ButtonWidget_enShortPress, 0xE142FA6A); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_7_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0xf4b7f014 /* Layer_TouchArea_Preset_7/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_7_ButtonWidget_enShortPressRelease, 0xEAF295A9); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_8_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0x84fb073a /* Layer_TouchArea_Preset_8/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_8_ButtonWidget_enShortPressRelease, 0xB189C5E5); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_9_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0xc48d7eaa /* Layer_TouchArea_Preset_9/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_9_ButtonWidget_enShortPressRelease, 0xFFE11A11); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_10_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0xb9da2cf8 /* Layer_TouchArea_Preset_10/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_10_ButtonWidget_enShortPressRelease, 0xAF1EF6CF); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_11_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0x582a8787 /* Layer_TouchArea_Preset_11/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_11_ButtonWidget_enShortPressRelease, 0x42AECCFD); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_12_ButtonWidget_enShortPressRelease
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0xf3c138d5 /* Layer_TouchArea_Preset_12/ButtonWidget */)) && (message.GetEnReaction() == enShortPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_12_ButtonWidget_enShortPressRelease, 0xC0583E23); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_7_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0xf4b7f014 /* Layer_TouchArea_Preset_7/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_7_ButtonWidget_enLongPress, 0xB3C73D42); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_12_ButtonWidget_enShortPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM1_S")) && (message.GetSender() == ::Courier::Identifier(0xf3c138d5 /* Layer_TouchArea_Preset_12/ButtonWidget */)) && (message.GetEnReaction() == enShortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_12_ButtonWidget_enShortPress, 0x4C0C1D49); return true; }
#endif
#ifdef OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_TouchArea_FreqStepUp_normal_Button_enPress
    if ((message.GetView() == ::Courier::ViewId("TunerModule#TunerScenes#R_FM2")) && (message.GetSender() == ::Courier::Identifier(0x558a16a3 /* TouchArea_FreqStepUp_normal/Button */)) && (message.GetEnReaction() == enPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_TouchArea_FreqStepUp_normal_Button_enPress, 0xB0567F25); return true; }
#endif
#ifdef OnButtonReactionMsg_Layer_AppFlyIn_btn_bn_Phone_enRelease
    if ((message.GetSender() == ::Courier::Identifier(0x08777fcb /* Layer_AppFlyIn/btn_bn_Phone */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Layer_AppFlyIn_btn_bn_Phone_enRelease, 0x58A6C605); return true; }
#endif
#ifdef OnButtonReactionMsg_Layer_AppFlyIn_btn_bn_Navi_enRelease
    if ((message.GetSender() == ::Courier::Identifier(0x5960bd72 /* Layer_AppFlyIn/btn_bn_Navi */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Layer_AppFlyIn_btn_bn_Navi_enRelease, 0x5621CB49); return true; }
#endif
#ifdef OnButtonReactionMsg_Layer_AppFlyIn_btn_bn_Media_enRelease
    if ((message.GetSender() == ::Courier::Identifier(0xd48f6006 /* Layer_AppFlyIn/btn_bn_Media */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Layer_AppFlyIn_btn_bn_Media_enRelease, 0x6067466C); return true; }
#endif
#ifdef OnButtonReactionMsg_Layer_AppFlyIn_btn_bn_MirrorLink_enRelease
    if ((message.GetSender() == ::Courier::Identifier(0xf5700898 /* Layer_AppFlyIn/btn_bn_MirrorLink */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Layer_AppFlyIn_btn_bn_MirrorLink_enRelease, 0x01C099F4); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForButtonReactionMsg(AppHmi_TunerStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::ButtonReactionMsg const & message = static_cast< ::ButtonReactionMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_TunerStateMachineImpl::VS_Ret_Ok, AppHmi_TunerStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForActivateApplicationMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnActivateApplicationMsg, 0xC70281BB);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActivateApplicationMsg(AppHmi_TunerStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_TunerStateMachineImpl::VS_Ret_Ok, AppHmi_TunerStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForDeactivateApplicationMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnDeactivateApplicationMsg, 0x37E7CAFB);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForDeactivateApplicationMsg(AppHmi_TunerStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_TunerStateMachineImpl::VS_Ret_Ok, AppHmi_TunerStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForTunerViewMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnTunerViewMsg, 0x19F47277);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForTunerViewMsg(AppHmi_TunerStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_TunerStateMachineImpl::VS_Ret_Ok, AppHmi_TunerStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForEnableView(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::EnableView const & message = static_cast< ::EnableView const &>(aMessage);

#ifdef OnEnableView_TunerModule_TunerScenes_R_OPT_FMAM
    if ((message.GetViewName() == ::Courier::ViewId("TunerModule#TunerScenes#R_OPT_FMAM"))) { eventId = CIT_EVENT_ID(OnEnableView_TunerModule_TunerScenes_R_OPT_FMAM, 0x5ED7DDCF); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForEnableView(AppHmi_TunerStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::EnableView const & message = static_cast< ::EnableView const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_TunerStateMachineImpl::VS_Ret_Ok, AppHmi_TunerStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForDisableView(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::DisableView const & message = static_cast< ::DisableView const &>(aMessage);

#ifdef OnDisableView_TunerModule_TunerScenes_R_OPT_FMAM
    if ((message.GetViewName() == ::Courier::ViewId("TunerModule#TunerScenes#R_OPT_FMAM"))) { eventId = CIT_EVENT_ID(OnDisableView_TunerModule_TunerScenes_R_OPT_FMAM, 0xD4D25AB2); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForDisableView(AppHmi_TunerStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::DisableView const & message = static_cast< ::DisableView const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_TunerStateMachineImpl::VS_Ret_Ok, AppHmi_TunerStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForShutdownMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnShutdownMsg, 0x756C0DF3);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForShutdownMsg(AppHmi_TunerStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_TunerStateMachineImpl::VS_Ret_Ok, AppHmi_TunerStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForActivationResMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::Courier::ActivationResMsg const & message = static_cast< ::Courier::ActivationResMsg const &>(aMessage);

#ifdef OnActivationResMsg_TunerModule_TunerPopupScene_Pfo_StorePreset_1
    if ((message.GetViewId() == ::Courier::ViewId("TunerModule#TunerPopupScene#Pfo_StorePreset")) && (message.GetSuccess() == 1)) { eventId = CIT_EVENT_ID(OnActivationResMsg_TunerModule_TunerPopupScene_Pfo_StorePreset_1, 0x4D0EE082); return true; }
#endif
#ifdef OnActivationResMsg_TunerModule_TunerPopupScene_Pfo_CannotStore_1
    if ((message.GetViewId() == ::Courier::ViewId("TunerModule#TunerPopupScene#Pfo_CannotStore")) && (message.GetSuccess() == 1)) { eventId = CIT_EVENT_ID(OnActivationResMsg_TunerModule_TunerPopupScene_Pfo_CannotStore_1, 0x36287D1E); return true; }
#endif
#ifdef OnActivationResMsg_TunerModule_TunerPopupScene_Pfo_UpdateDAB_SL_1
    if ((message.GetViewId() == ::Courier::ViewId("TunerModule#TunerPopupScene#Pfo_UpdateDAB_SL")) && (message.GetSuccess() == 1)) { eventId = CIT_EVENT_ID(OnActivationResMsg_TunerModule_TunerPopupScene_Pfo_UpdateDAB_SL_1, 0x55EEEBDD); return true; }
#endif
#ifdef OnActivationResMsg_TunerModule_TunerPopupScene_Pfo_UpdateFM_SL_1
    if ((message.GetViewId() == ::Courier::ViewId("TunerModule#TunerPopupScene#Pfo_UpdateFM_SL")) && (message.GetSuccess() == 1)) { eventId = CIT_EVENT_ID(OnActivationResMsg_TunerModule_TunerPopupScene_Pfo_UpdateFM_SL_1, 0x58B10F53); return true; }
#endif
#ifdef OnActivationResMsg_TunerModule_TunerPopupScene_Pfo_Autostore_1
    if ((message.GetViewId() == ::Courier::ViewId("TunerModule#TunerPopupScene#Pfo_Autostore")) && (message.GetSuccess() == 1)) { eventId = CIT_EVENT_ID(OnActivationResMsg_TunerModule_TunerPopupScene_Pfo_Autostore_1, 0x92148F81); return true; }
#endif
#ifdef OnActivationResMsg_TunerModule_SysPopupScene_Pfo_PTY31_1
    if ((message.GetViewId() == ::Courier::ViewId("TunerModule#SysPopupScene#Pfo_PTY31")) && (message.GetSuccess() == 1)) { eventId = CIT_EVENT_ID(OnActivationResMsg_TunerModule_SysPopupScene_Pfo_PTY31_1, 0x2842B3C8); return true; }
#endif
#ifdef OnActivationResMsg_TunerModule_SysPopupScene_Pfo_TA_1
    if ((message.GetViewId() == ::Courier::ViewId("TunerModule#SysPopupScene#Pfo_TA")) && (message.GetSuccess() == 1)) { eventId = CIT_EVENT_ID(OnActivationResMsg_TunerModule_SysPopupScene_Pfo_TA_1, 0xC72F72E5); return true; }
#endif
#ifdef OnActivationResMsg_TunerModule_SysPopupScene_Pfo_WB_1
    if ((message.GetViewId() == ::Courier::ViewId("TunerModule#SysPopupScene#Pfo_WB")) && (message.GetSuccess() == 1)) { eventId = CIT_EVENT_ID(OnActivationResMsg_TunerModule_SysPopupScene_Pfo_WB_1, 0xA4F5B761); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActivationResMsg(AppHmi_TunerStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::Courier::ActivationResMsg const & message = static_cast< ::Courier::ActivationResMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_TunerStateMachineImpl::VS_Ret_Ok, AppHmi_TunerStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForActivityMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::ActivityMsg const & message = static_cast< ::ActivityMsg const &>(aMessage);

#ifdef OnActivityMsg_eActivityID_TUNER_SOURCE_SELECTION
    if ((message.GetActivityID() == eActivityID_TUNER_SOURCE_SELECTION)) { eventId = CIT_EVENT_ID(OnActivityMsg_eActivityID_TUNER_SOURCE_SELECTION, 0xAF0D1A54); return true; }
#endif
#ifdef OnActivityMsg_eActivityID_TUNER_FM1
    if ((message.GetActivityID() == eActivityID_TUNER_FM1)) { eventId = CIT_EVENT_ID(OnActivityMsg_eActivityID_TUNER_FM1, 0x54E4151C); return true; }
#endif
#ifdef OnActivityMsg_eActivityID_TUNER_FM2
    if ((message.GetActivityID() == eActivityID_TUNER_FM2)) { eventId = CIT_EVENT_ID(OnActivityMsg_eActivityID_TUNER_FM2, 0x1B3021B1); return true; }
#endif
#ifdef OnActivityMsg_eActivityID_TUNER_FM_AST
    if ((message.GetActivityID() == eActivityID_TUNER_FM_AST)) { eventId = CIT_EVENT_ID(OnActivityMsg_eActivityID_TUNER_FM_AST, 0xAD58B4E9); return true; }
#endif
#ifdef OnActivityMsg_eActivityID_TUNER_AM
    if ((message.GetActivityID() == eActivityID_TUNER_AM)) { eventId = CIT_EVENT_ID(OnActivityMsg_eActivityID_TUNER_AM, 0xCD31E1F7); return true; }
#endif
#ifdef OnActivityMsg_eActivityID_TUNER_AM_AST
    if ((message.GetActivityID() == eActivityID_TUNER_AM_AST)) { eventId = CIT_EVENT_ID(OnActivityMsg_eActivityID_TUNER_AM_AST, 0x09242053); return true; }
#endif
#ifdef OnActivityMsg_eActivityID_TUNER_DAB
    if ((message.GetActivityID() == eActivityID_TUNER_DAB)) { eventId = CIT_EVENT_ID(OnActivityMsg_eActivityID_TUNER_DAB, 0x701B289B); return true; }
#endif
#ifdef OnActivityMsg_eActivityID_TUNER_DAB_AST
    if ((message.GetActivityID() == eActivityID_TUNER_DAB_AST)) { eventId = CIT_EVENT_ID(OnActivityMsg_eActivityID_TUNER_DAB_AST, 0xE364F274); return true; }
#endif
#ifdef OnActivityMsg_eActivityID_TUNER_DRM
    if ((message.GetActivityID() == eActivityID_TUNER_DRM)) { eventId = CIT_EVENT_ID(OnActivityMsg_eActivityID_TUNER_DRM, 0xC4C7F074); return true; }
#endif
#ifdef OnActivityMsg_eActivityID_TUNER_DRM_AST
    if ((message.GetActivityID() == eActivityID_TUNER_DRM_AST)) { eventId = CIT_EVENT_ID(OnActivityMsg_eActivityID_TUNER_DRM_AST, 0x5A9719E8); return true; }
#endif
#ifdef OnActivityMsg_eActivityID_TUNER_SETTINGS_VIEW
    if ((message.GetActivityID() == eActivityID_TUNER_SETTINGS_VIEW)) { eventId = CIT_EVENT_ID(OnActivityMsg_eActivityID_TUNER_SETTINGS_VIEW, 0x51DF1EAA); return true; }
#endif
#ifdef OnActivityMsg_eActivityID_NO_CHANGE
    if ((message.GetActivityID() == eActivityID_NO_CHANGE)) { eventId = CIT_EVENT_ID(OnActivityMsg_eActivityID_NO_CHANGE, 0x1118D220); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActivityMsg(AppHmi_TunerStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::ActivityMsg const & message = static_cast< ::ActivityMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_TunerStateMachineImpl::VS_Ret_Ok, AppHmi_TunerStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForEnableTESTModeView(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::EnableTESTModeView const & message = static_cast< ::EnableTESTModeView const &>(aMessage);

#ifdef OnEnableTESTModeView_eActivityID_TUNER_FM1
    if ((message.GetViewName() == eActivityID_TUNER_FM1)) { eventId = CIT_EVENT_ID(OnEnableTESTModeView_eActivityID_TUNER_FM1, 0xA290709A); return true; }
#endif
#ifdef OnEnableTESTModeView_eActivityID_TUNER_AM
    if ((message.GetViewName() == eActivityID_TUNER_AM)) { eventId = CIT_EVENT_ID(OnEnableTESTModeView_eActivityID_TUNER_AM, 0xC4E19EBA); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForEnableTESTModeView(AppHmi_TunerStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::EnableTESTModeView const & message = static_cast< ::EnableTESTModeView const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_TunerStateMachineImpl::VS_Ret_Ok, AppHmi_TunerStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForTunerPLMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::TunerPLMsg const & message = static_cast< ::TunerPLMsg const &>(aMessage);

#ifdef OnTunerPLMsg_1
    if ((message.GetEventId() == 1)) { eventId = CIT_EVENT_ID(OnTunerPLMsg_1, 0x549D2326); return true; }
#endif
#ifdef OnTunerPLMsg_6
    if ((message.GetEventId() == 6)) { eventId = CIT_EVENT_ID(OnTunerPLMsg_6, 0x776F68C2); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForTunerPLMsg(AppHmi_TunerStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::TunerPLMsg const & message = static_cast< ::TunerPLMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_TunerStateMachineImpl::VS_Ret_Ok, AppHmi_TunerStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForBrowseListRespMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnBrowseListRespMsg, 0x8C1F15A1);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForBrowseListRespMsg(AppHmi_TunerStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_TunerStateMachineImpl::VS_Ret_Ok, AppHmi_TunerStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForPopup_PFO_TA(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnPopup_PFO_TA, 0x468D7232);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForPopup_PFO_TA(AppHmi_TunerStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_TunerStateMachineImpl::VS_Ret_Ok, AppHmi_TunerStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForPopup_PFO_PTY31(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnPopup_PFO_PTY31, 0x51768932);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForPopup_PFO_PTY31(AppHmi_TunerStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_TunerStateMachineImpl::VS_Ret_Ok, AppHmi_TunerStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForPopup_PFO_TAclose(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnPopup_PFO_TAclose, 0x0E264370);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForPopup_PFO_TAclose(AppHmi_TunerStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_TunerStateMachineImpl::VS_Ret_Ok, AppHmi_TunerStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForPopup_PFO_PTY31close(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnPopup_PFO_PTY31close, 0x1C5C6BE9);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForPopup_PFO_PTY31close(AppHmi_TunerStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_TunerStateMachineImpl::VS_Ret_Ok, AppHmi_TunerStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForPopup_PFO_AST(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnPopup_PFO_AST, 0x2C599964);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForPopup_PFO_AST(AppHmi_TunerStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_TunerStateMachineImpl::VS_Ret_Ok, AppHmi_TunerStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForPopup_PFO_ASTClose(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnPopup_PFO_ASTClose, 0x44DA962E);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForPopup_PFO_ASTClose(AppHmi_TunerStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_TunerStateMachineImpl::VS_Ret_Ok, AppHmi_TunerStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForPopup_PFO_WB(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnPopup_PFO_WB, 0x0F88FC3A);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForPopup_PFO_WB(AppHmi_TunerStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_TunerStateMachineImpl::VS_Ret_Ok, AppHmi_TunerStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForPopup_PFO_WBclose(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnPopup_PFO_WBclose, 0x684D9639);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForPopup_PFO_WBclose(AppHmi_TunerStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_TunerStateMachineImpl::VS_Ret_Ok, AppHmi_TunerStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onEncoderStatusChanged_RIGHT_ENC
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onEncoderStatusChanged_RIGHT_ENC 0xffff
#pragma _REMINDER("Using dummy value symbol onEncoderStatusChanged_RIGHT_ENC ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onEncoderStatusChanged_RIGHT_ENC -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForEncoderStatusChangedUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::EncoderStatusChangedUpdMsg const & message = static_cast< ::EncoderStatusChangedUpdMsg const &>(aMessage);

#ifdef onEncoderStatusChanged_RIGHT_ENC
    if ((message.GetEncCode() == ENCCODE_RIGHT_ENCODER)) { eventId = CIT_EVENT_ID(onEncoderStatusChanged_RIGHT_ENC, 0x67E5D82B); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForEncoderStatusChangedUpdMsg(AppHmi_TunerStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::EncoderStatusChangedUpdMsg const & message = static_cast< ::EncoderStatusChangedUpdMsg const &>(aMessage);
#ifdef onEncoderStatusChanged_RIGHT_ENC
    if (eventId == onEncoderStatusChanged_RIGHT_ENC) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_TunerStateMachineImpl::VS_Ret_Ok, AppHmi_TunerStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetEncSteps()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onEncoderStatusChanged_RIGHT_ENC.EncSteps = message.GetEncSteps();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_TunerStateMachineImpl::VS_Ret_Ok, AppHmi_TunerStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForHKStatusChangedUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::HKStatusChangedUpdMsg const & message = static_cast< ::HKStatusChangedUpdMsg const &>(aMessage);

#ifdef onHKStatusChanged_HK_SELECT_UP
    if ((message.GetHKCode() == HARDKEYCODE_HK_SELECT) && (message.GetHKState() == HARDKEYSTATE_UP)) { eventId = CIT_EVENT_ID(onHKStatusChanged_HK_SELECT_UP, 0x263EAF7F); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForHKStatusChangedUpdMsg(AppHmi_TunerStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::HKStatusChangedUpdMsg const & message = static_cast< ::HKStatusChangedUpdMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_TunerStateMachineImpl::VS_Ret_Ok, AppHmi_TunerStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onPopupTimerExpiry
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onPopupTimerExpiry 0xffff
#pragma _REMINDER("Using dummy value symbol onPopupTimerExpiry ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onPopupTimerExpiry -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForExpiredPopupTimerResMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(onPopupTimerExpiry, 0xF3C96D17);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForExpiredPopupTimerResMsg(AppHmi_TunerStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::ExpiredPopupTimerResMsg const & message = static_cast< ::ExpiredPopupTimerResMsg const &>(aMessage);
#ifdef onPopupTimerExpiry
    if (eventId == onPopupTimerExpiry) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_TunerStateMachineImpl::VS_Ret_Ok, AppHmi_TunerStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetViewId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onPopupTimerExpiry.ViewId = message.GetViewId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_TunerStateMachineImpl::VS_Ret_Ok, AppHmi_TunerStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onActivateImageProviderRequest
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onActivateImageProviderRequest 0xffff
#pragma _REMINDER("Using dummy value symbol onActivateImageProviderRequest ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onActivateImageProviderRequest -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onDeactivateImageProviderRequest
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onDeactivateImageProviderRequest 0xffff
#pragma _REMINDER("Using dummy value symbol onDeactivateImageProviderRequest ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onDeactivateImageProviderRequest -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForActivateImageProviderReqMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::hmibase::gadget::ActivateImageProviderReqMsg const & message = static_cast< ::hmibase::gadget::ActivateImageProviderReqMsg const &>(aMessage);

#ifdef onActivateImageProviderRequest
    if ((message.GetActivate() == 1)) { eventId = CIT_EVENT_ID(onActivateImageProviderRequest, 0xDD62EA5B); return true; }
#endif
#ifdef onDeactivateImageProviderRequest
    if ((message.GetActivate() == 0)) { eventId = CIT_EVENT_ID(onDeactivateImageProviderRequest, 0x9FE98C1E); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActivateImageProviderReqMsg(AppHmi_TunerStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::hmibase::gadget::ActivateImageProviderReqMsg const & message = static_cast< ::hmibase::gadget::ActivateImageProviderReqMsg const &>(aMessage);
#ifdef onActivateImageProviderRequest
    if (eventId == onActivateImageProviderRequest) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_TunerStateMachineImpl::VS_Ret_Ok, AppHmi_TunerStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetInstanceId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onActivateImageProviderRequest.InstanceId = message.GetInstanceId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onDeactivateImageProviderRequest
    if (eventId == onDeactivateImageProviderRequest) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_TunerStateMachineImpl::VS_Ret_Ok, AppHmi_TunerStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetInstanceId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onDeactivateImageProviderRequest.InstanceId = message.GetInstanceId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_TunerStateMachineImpl::VS_Ret_Ok, AppHmi_TunerStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForHMISubStateChangedUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::HMISubStateChangedUpdMsg const & message = static_cast< ::HMISubStateChangedUpdMsg const &>(aMessage);

#ifdef onHMISubStateChanged_ON
    if ((message.GetSubState() == HMISTATE_SHOW_HMI)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_ON, 0x76CF2B88); return true; }
#endif
#ifdef onHMISubStateChanged_CLOCK
    if ((message.GetSubState() == HMISTATE_SHOW_CLOCK)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_CLOCK, 0xF96478DC); return true; }
#endif
#ifdef onHMISubStateChanged_OFF
    if ((message.GetSubState() == HMISTATE_SHOW_OFF)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_OFF, 0x776D7D8A); return true; }
#endif
#ifdef onHMISubStateChanged_STANDBY_RESTRICTED
    if ((message.GetSubState() == HMISTATE_STANDBY_RESTRICTED)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_STANDBY_RESTRICTED, 0xA15C3CEE); return true; }
#endif
#ifdef onHMISubStateChanged_STANDBY
    if ((message.GetSubState() == HMISTATE_STANDBY)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_STANDBY, 0x0D0F5602); return true; }
#endif
#ifdef onHMISubStateChanged_PHONE
    if ((message.GetSubState() == HMISTATE_PHONE)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_PHONE, 0xC8D83B8B); return true; }
#endif
#ifdef onHMISubStateChanged_NO_DISPLAY
    if ((message.GetSubState() == HMISTATE_SHOW_NO_DISPLAY)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_NO_DISPLAY, 0xE4658CFD); return true; }
#endif
#ifdef onHMISubStateChanged_SECURE
    if ((message.GetSubState() == HMISTATE_SECURE)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_SECURE, 0xAB89D7A8); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForHMISubStateChangedUpdMsg(AppHmi_TunerStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::HMISubStateChangedUpdMsg const & message = static_cast< ::HMISubStateChangedUpdMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_TunerStateMachineImpl::VS_Ret_Ok, AppHmi_TunerStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForApplicationStateUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::ApplicationStateUpdMsg const & message = static_cast< ::ApplicationStateUpdMsg const &>(aMessage);

#ifdef onAppStatusChanged_FOREGROUND
    if ((message.GetState() == hmibase::IN_FOREGROUND)) { eventId = CIT_EVENT_ID(onAppStatusChanged_FOREGROUND, 0xDE9448E3); return true; }
#endif
#ifdef onAppStatusChanged_BACKGROUND
    if ((message.GetState() == hmibase::IN_BACKGROUND)) { eventId = CIT_EVENT_ID(onAppStatusChanged_BACKGROUND, 0x6D1B3A68); return true; }
#endif
#ifdef onAppStatusPrepare_BACKGROUND
    if ((message.GetState() == hmibase::TO_BACKGROUND)) { eventId = CIT_EVENT_ID(onAppStatusPrepare_BACKGROUND, 0x4C8518AE); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForApplicationStateUpdMsg(AppHmi_TunerStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::ApplicationStateUpdMsg const & message = static_cast< ::ApplicationStateUpdMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_TunerStateMachineImpl::VS_Ret_Ok, AppHmi_TunerStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onSubSurfaceUpdMsgChanged_FOREGROUND
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onSubSurfaceUpdMsgChanged_FOREGROUND 0xffff
#pragma _REMINDER("Using dummy value symbol onSubSurfaceUpdMsgChanged_FOREGROUND ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onSubSurfaceUpdMsgChanged_FOREGROUND -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onSubSurfaceUpdMsgChanged_BACKGROUND
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onSubSurfaceUpdMsgChanged_BACKGROUND 0xffff
#pragma _REMINDER("Using dummy value symbol onSubSurfaceUpdMsgChanged_BACKGROUND ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onSubSurfaceUpdMsgChanged_BACKGROUND -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForSubSurfaceUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::SubSurfaceUpdMsg const & message = static_cast< ::SubSurfaceUpdMsg const &>(aMessage);

#ifdef onSubSurfaceUpdMsgChanged_FOREGROUND
    if ((message.GetState() == hmibase::IN_FOREGROUND)) { eventId = CIT_EVENT_ID(onSubSurfaceUpdMsgChanged_FOREGROUND, 0x9D4DF4FC); return true; }
#endif
#ifdef onSubSurfaceUpdMsgChanged_BACKGROUND
    if ((message.GetState() == hmibase::IN_BACKGROUND)) { eventId = CIT_EVENT_ID(onSubSurfaceUpdMsgChanged_BACKGROUND, 0x5790D8C1); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSubSurfaceUpdMsg(AppHmi_TunerStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::SubSurfaceUpdMsg const & message = static_cast< ::SubSurfaceUpdMsg const &>(aMessage);
#ifdef onSubSurfaceUpdMsgChanged_FOREGROUND
    if (eventId == onSubSurfaceUpdMsgChanged_FOREGROUND) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_TunerStateMachineImpl::VS_Ret_Ok, AppHmi_TunerStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetDisplayRegion(), message.GetDisplayID()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onSubSurfaceUpdMsgChanged_FOREGROUND.DisplayRegion = message.GetDisplayRegion();
        onClickParam.VSEPS_onSubSurfaceUpdMsgChanged_FOREGROUND.DisplayID = message.GetDisplayID();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onSubSurfaceUpdMsgChanged_BACKGROUND
    if (eventId == onSubSurfaceUpdMsgChanged_BACKGROUND) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_TunerStateMachineImpl::VS_Ret_Ok, AppHmi_TunerStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetDisplayRegion(), message.GetDisplayID()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onSubSurfaceUpdMsgChanged_BACKGROUND.DisplayRegion = message.GetDisplayRegion();
        onClickParam.VSEPS_onSubSurfaceUpdMsgChanged_BACKGROUND.DisplayID = message.GetDisplayID();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_TunerStateMachineImpl::VS_Ret_Ok, AppHmi_TunerStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForTransitionIndMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::Courier::TransitionIndMsg const & message = static_cast< ::Courier::TransitionIndMsg const &>(aMessage);

#ifdef OnNextLevelTransitionFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("NextLevelTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnNextLevelTransitionFinished, 0xE7DCE080); return true; }
#endif
#ifdef OnPreviousLevelTransitionFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("PreviousLevelTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnPreviousLevelTransitionFinished, 0x26C30D04); return true; }
#endif
#ifdef OnPageFlipBackFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("PageFlipBackTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnPageFlipBackFinished, 0x74F534EE); return true; }
#endif
#ifdef OnPageFlipFrontFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("PageFlipFrontTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnPageFlipFrontFinished, 0x437D9EFE); return true; }
#endif
#ifdef OnZoomInFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("ZoomInTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnZoomInFinished, 0xFBEEA58F); return true; }
#endif
#ifdef OnZoomOutFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("ZoomOutTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnZoomOutFinished, 0xF84B3BD1); return true; }
#endif
#ifdef OnFadeAnimationFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("FadeTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnFadeAnimationFinished, 0xE9A6D56C); return true; }
#endif
#ifdef OnDualViewLeftTransitionFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("DualViewLeftTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnDualViewLeftTransitionFinished, 0x403A65A4); return true; }
#endif
#ifdef OnDualViewRightTransitionFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("DualViewRightTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnDualViewRightTransitionFinished, 0x50B4DCCA); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForTransitionIndMsg(AppHmi_TunerStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::Courier::TransitionIndMsg const & message = static_cast< ::Courier::TransitionIndMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_TunerStateMachineImpl::VS_Ret_Ok, AppHmi_TunerStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
struct EventMapping
{
    ::FeatStd::UInt32 mHashId;
    bool (*mEventCallHandler)(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId);
};

struct EventDeductionMapping
{
    ::FeatStd::UInt32 mHashId;
    ::Cit::DeductResult::Enum (*mEventCallHandler)(AppHmi_TunerStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId);
};

static ::FeatStd::Int EventMappingCmp(::FeatStd::UInt32 hash, const EventMapping& em)
{
    return (hash == em.mHashId) ? 0 : ((hash < em.mHashId) ? -1 : 1);
}

static ::FeatStd::Int EventDeductionMappingCmp(::FeatStd::UInt32 hash, const EventDeductionMapping& em)
{
    return (hash == em.mHashId) ? 0 : ((hash < em.mHashId) ? -1 : 1);
}

bool AppHmi_TunerStateMachineImpl::HandleEventMapping(::Courier::Message const & message, ::FeatStd::UInt32& eventId) const
{
    static EventMapping events[29] = {
        { 0x04B8AFB9, HandleEventMappingForHKStatusChangedUpdMsg },
        { 0x0A5C35C8, HandleEventMappingForPopup_PFO_WB },
        { 0x2717107B, HandleEventMappingForPopup_PFO_AST },
        { 0x3824FE1D, HandleEventMappingForApplicationStateUpdMsg },
        { 0x4A69141E, HandleEventMappingForHMISubStateChangedUpdMsg },
        { 0x4FF79763, HandleEventMappingForEncoderStatusChangedUpdMsg },
        { 0x69FAC6F1, HandleEventMappingForSubSurfaceUpdMsg },
        { 0x6AE0FD3C, HandleEventMappingForButtonReactionMsg },
        { 0x7DE09752, HandleEventMappingForPopup_PFO_WBclose },
        { 0x815A24B6, HandleEventMappingForPopup_PFO_TA },
        { 0x8BBD0734, HandleEventMappingForEnableView },
        { 0x8D4DB5D8, HandleEventMappingForDisableView },
        { 0x93A5580A, HandleEventMappingForActivityMsg },
        { 0xA60CB9F4, HandleEventMappingForShutdownMsg },
        { 0xAE3CAAA7, HandleEventMappingForExpiredPopupTimerResMsg },
        { 0xB06A0D7F, HandleEventMappingForPopup_PFO_TAclose },
        { 0xB490953C, HandleEventMappingForTunerPLMsg },
        { 0xB88C5200, HandleEventMappingForTunerViewMsg },
        { 0xC277DA2B, HandleEventMappingForActivateApplicationMsg },
        { 0xC469BFCB, HandleEventMappingForPopup_PFO_PTY31 },
        { 0xC613E40C, HandleEventMappingForActivateImageProviderReqMsg },
        { 0xC7B455FB, HandleEventMappingForTransitionIndMsg },
        { 0xD4AC7BDB, HandleEventMappingForActivationResMsg },
        { 0xDAE968BA, HandleEventMappingForDeactivateApplicationMsg },
        { 0xE15D254D, HandleEventMappingForPopup_PFO_PTY31close },
        { 0xE2F61D55, HandleEventMappingForSurfaceStateChangedUpdMsg },
        { 0xEBD18759, HandleEventMappingForEnableTESTModeView },
        { 0xEFCC8AD1, HandleEventMappingForPopup_PFO_ASTClose },
        { 0xF6217210, HandleEventMappingForBrowseListRespMsg },
    };
    ::FeatStd::UInt32 hashId = message.GetId();
    const EventMapping* eventEntry = ::Courier::BinarySearch(hashId, events, 29, &EventMappingCmp);
    if (eventEntry && (hashId == eventEntry->mHashId)) {
        return eventEntry->mEventCallHandler(message, eventId);
    }
    return false;
}

// ------------------------------------------------------------------------
::Cit::DeductResult::Enum AppHmi_TunerStateMachineImpl::DeductEvent(::Courier::Message const & aMessage, ::FeatStd::UInt32 eventId)
{
    ::Cit::DeductResult::Enum deductResult = Cit::DeductResult::DeductOk;
    static EventDeductionMapping events[29] = {
        { 0x04B8AFB9, HandleEventDeductionForHKStatusChangedUpdMsg },
        { 0x0A5C35C8, HandleEventDeductionForPopup_PFO_WB },
        { 0x2717107B, HandleEventDeductionForPopup_PFO_AST },
        { 0x3824FE1D, HandleEventDeductionForApplicationStateUpdMsg },
        { 0x4A69141E, HandleEventDeductionForHMISubStateChangedUpdMsg },
        { 0x4FF79763, HandleEventDeductionForEncoderStatusChangedUpdMsg },
        { 0x69FAC6F1, HandleEventDeductionForSubSurfaceUpdMsg },
        { 0x6AE0FD3C, HandleEventDeductionForButtonReactionMsg },
        { 0x7DE09752, HandleEventDeductionForPopup_PFO_WBclose },
        { 0x815A24B6, HandleEventDeductionForPopup_PFO_TA },
        { 0x8BBD0734, HandleEventDeductionForEnableView },
        { 0x8D4DB5D8, HandleEventDeductionForDisableView },
        { 0x93A5580A, HandleEventDeductionForActivityMsg },
        { 0xA60CB9F4, HandleEventDeductionForShutdownMsg },
        { 0xAE3CAAA7, HandleEventDeductionForExpiredPopupTimerResMsg },
        { 0xB06A0D7F, HandleEventDeductionForPopup_PFO_TAclose },
        { 0xB490953C, HandleEventDeductionForTunerPLMsg },
        { 0xB88C5200, HandleEventDeductionForTunerViewMsg },
        { 0xC277DA2B, HandleEventDeductionForActivateApplicationMsg },
        { 0xC469BFCB, HandleEventDeductionForPopup_PFO_PTY31 },
        { 0xC613E40C, HandleEventDeductionForActivateImageProviderReqMsg },
        { 0xC7B455FB, HandleEventDeductionForTransitionIndMsg },
        { 0xD4AC7BDB, HandleEventDeductionForActivationResMsg },
        { 0xDAE968BA, HandleEventDeductionForDeactivateApplicationMsg },
        { 0xE15D254D, HandleEventDeductionForPopup_PFO_PTY31close },
        { 0xE2F61D55, HandleEventDeductionForSurfaceStateChangedUpdMsg },
        { 0xEBD18759, HandleEventDeductionForEnableTESTModeView },
        { 0xEFCC8AD1, HandleEventDeductionForPopup_PFO_ASTClose },
        { 0xF6217210, HandleEventDeductionForBrowseListRespMsg },
    };
    ::FeatStd::UInt32 hashId = aMessage.GetId();
    const EventDeductionMapping* eventEntry = ::Courier::BinarySearch(hashId, events, 29, &EventDeductionMappingCmp);
    if (eventEntry && (hashId == eventEntry->mHashId)) {
        deductResult = eventEntry->mEventCallHandler(this, aMessage, eventId);
    }
    else {
        typedef Cit::Internal::VSDeductHelper<VS_Ret_Ok, AppHmi_TunerStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
        return VSDeductHelper::ProcessOutput(*this, (*this.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
        return VSDeductHelper::ProcessOutput(*this, (*this.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
    }
    return deductResult;
}

// ------------------------------------------------------------------------
bool AppHmi_TunerStateMachineImpl::HandleDataBindingEventMapping(::Courier::AbstractDataItemMsg const & /* message */, ::FeatStd::UInt32 & /* eventId */) const
{
    return false;
}

#ifdef CIT_SIMULATION
struct EventNameMapping
{
    ::FeatStd::UInt32 mEventId;
    const ::FeatStd::Char* mEventName;
    void (*mGetEventArguments)(::Courier::Message const & message, Json::Value& eventArguments);
};

static ::FeatStd::Int EventNameMappingCmp(::FeatStd::UInt32 eventId, const EventNameMapping& em)
{
    return (eventId == em.mEventId) ? 0 : ((eventId < em.mEventId) ? -1 : 1);
}

static void GetEventArgumentsForonCenterPopupSurfaceVisible(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonTopPopupSurfaceInvisible(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonSubSurfaceUpdMsgChanged_BACKGROUND(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SubSurfaceUpdMsg const & message = static_cast< ::SubSurfaceUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::Int)message.GetDisplayRegion();
    eventArguments[(::Json::Value::UInt)1] = (::Json::Value::UInt)message.GetDisplayID();
}

static void GetEventArgumentsForonEncoderStatusChanged_RIGHT_ENC(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::EncoderStatusChangedUpdMsg const & message = static_cast< ::EncoderStatusChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::Int)message.GetEncSteps();
}

static void GetEventArgumentsForonPopupInvisible(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonTopPopupSurfaceUnqueued(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonTopPopupSurfaceVisible(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonCenterPopupSurfaceInvisible(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonSubSurfaceUpdMsgChanged_FOREGROUND(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SubSurfaceUpdMsg const & message = static_cast< ::SubSurfaceUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::Int)message.GetDisplayRegion();
    eventArguments[(::Json::Value::UInt)1] = (::Json::Value::UInt)message.GetDisplayID();
}

static void GetEventArgumentsForonDeactivateImageProviderRequest(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::hmibase::gadget::ActivateImageProviderReqMsg const & message = static_cast< ::hmibase::gadget::ActivateImageProviderReqMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetInstanceId();
}

static void GetEventArgumentsForonCenterPopupSurfaceUnqueued(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonTopPopupSurfaceQueued(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonPopupVisible(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonPopupQueued(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonPopupUnqueued(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonActivateImageProviderRequest(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::hmibase::gadget::ActivateImageProviderReqMsg const & message = static_cast< ::hmibase::gadget::ActivateImageProviderReqMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetInstanceId();
}

static void GetEventArgumentsForonPopupTimerExpiry(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::ExpiredPopupTimerResMsg const & message = static_cast< ::ExpiredPopupTimerResMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId();
}

static void GetEventArgumentsForonCenterPopupSurfaceQueued(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

const ::FeatStd::Char* AppHmi_TunerStateMachineImpl::GetEventName(::FeatStd::UInt32 eventId, ::Courier::Message const & message, Json::Value& eventArguments)
{
    static EventNameMapping events[732] = {
        { 0x001FF9F7, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor3_Layer_TouchArea_Stepdown_ButtonWidget_enRelease", 0 },
        { 0x013A4E4E, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_Preset_4_ButtonWidget_enRelease", 0 },
        { 0x015261B4, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_2_ButtonWidget_enRelease", 0 },
        { 0x01C099F4, "OnButtonReactionMsg_Layer_AppFlyIn_btn_bn_MirrorLink_enRelease", 0 },
        { 0x020147B0, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_10_ButtonWidget_enLongPress", 0 },
        { 0x027A8C72, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_Preset_1_ButtonWidget_enShortPress", 0 },
        { 0x02F6CBBC, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_11_ButtonWidget_enLongPressRelease", 0 },
        { 0x038BC451, "OnButtonReactionMsg_TunerModule_TunerScenes_R_WeatherBand_Layer_TouchArea_Preset_8_ButtonWidget_enRelease", 0 },
        { 0x03A653C9, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_10_ButtonWidget_enLongPressRelease", 0 },
        { 0x03B78DC8, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_1_ButtonWidget_enShortPress", 0 },
        { 0x0468C1FE, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_SearchNext_ButtonWidget_enShortPressRelease", 0 },
        { 0x048B76CE, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_4_ButtonWidget_enLongPress", 0 },
        { 0x04976511, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_12_ButtonWidget_enShortPress", 0 },
        { 0x04BD7A18, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_6_ButtonWidget_enLongPressRelease", 0 },
        { 0x04D9CF19, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_Layer_TouchArea_SearchPrevious_ButtonWidget_enLongPressRelease", 0 },
        { 0x04DAD041, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Toucharea_hd_info_AM_ButtonWidget_enRelease", 0 },
        { 0x0549AC85, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_8_ButtonWidget_enLongPressRelease", 0 },
        { 0x05BF93FA, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_TestModeScreen_btn_bn_back_enRelease", 0 },
        { 0x06205AB3, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_1_ButtonWidget_enLongPress", 0 },
        { 0x06745D3C, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_5_ButtonWidget_enLongPress", 0 },
        { 0x06A5068B, "OnButtonReactionMsg_TunerModule_TunerScenes_R_TestModeScreens_Button_Back_BG_ButtonWidget_enRelease", 0 },
        { 0x06A73063, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_Preset_6_ButtonWidget_enShortPressRelease", 0 },
        { 0x06D49744, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_10_ButtonWidget_enRelease", 0 },
        { 0x07226771, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_SearchNext_ButtonWidget_enRelease", 0 },
        { 0x07993235, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_Preset_4_ButtonWidget_enShortPressRelease", 0 },
        { 0x082D7CA8, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_7_ButtonWidget_enRelease", 0 },
        { 0x08A900A8, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_TouchArea_FreqStepDown_normal_Button_enShortPress", 0 },
        { 0x09242053, "OnActivityMsg_eActivityID_TUNER_AM_AST", 0 },
        { 0x094B0587, "OnButtonReactionMsg_TunerModule_TunerScenes_R_HDPARAMTUNING_TESTMODE_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0x0AA642BA, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_Preset_4_ButtonWidget_enShortPress", 0 },
        { 0x0AF77565, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_Source_ButtonWidget_enRelease", 0 },
        { 0x0BDD0E9C, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_Layer_TouchArea_SearchNext_ButtonWidget_enShortPressRelease", 0 },
        { 0x0BFE3142, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_Layer_TouchArea_SearchPrevious_ButtonWidget_enRelease", 0 },
        { 0x0C42F435, "OnButtonReactionMsg_TunerModule_TunerScenes_R_WeatherBand_Layer_TouchArea_Preset_6_ButtonWidget_enRelease", 0 },
        { 0x0C57852B, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_Layer_TouchArea_SearchNext_ButtonWidget_enRelease", 0 },
        { 0x0C9095E1, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_5_ButtonWidget_enRelease", 0 },
        { 0x0CA12725, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_2_ButtonWidget_enLongPress", 0 },
        { 0x0D0F5602, "onHMISubStateChanged_STANDBY", 0 },
        { 0x0D83CC91, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_Preset_4_ButtonWidget_enShortPress", 0 },
        { 0x0DB45C61, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor_Textbox_Tuner2_Band_ButtonWidget_enRelease", 0 },
        { 0x0E264370, "OnPopup_PFO_TAclose", 0 },
        { 0x0E290CB5, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_11_ButtonWidget_enRelease", 0 },
        { 0x0E3F5581, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_2_ButtonWidget_enShortPress", 0 },
        { 0x0F63E62B, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_INFO_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0x0F88FC3A, "OnPopup_PFO_WB", 0 },
        { 0x0FA1F9C2, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_TouchArea_FreqStepUp_normal_Button_enShortPress", 0 },
        { 0x10EE9697, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_12_ButtonWidget_enLongPressRelease", 0 },
        { 0x1118D220, "OnActivityMsg_eActivityID_NO_CHANGE", 0 },
        { 0x116E6D3C, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_6_ButtonWidget_enShortPress", 0 },
        { 0x11C93659, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_12_ButtonWidget_enRelease", 0 },
        { 0x1211944E, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_Preset_2_ButtonWidget_enRelease", 0 },
        { 0x13429ED7, "OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_woNav_btn_bn_DRM_AST_enRelease", 0 },
        { 0x138652C2, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Icon_StationList_ButtonWidget_enRelease", 0 },
        { 0x13F07391, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_Preset_5_ButtonWidget_enRelease", 0 },
        { 0x14154BCC, "OnButtonReactionMsg_TunerModule_Gadget_Tuner_MASTER_GADGET_TUNER_Btn_Next_ButtonWidget_enLongPressRelease", 0 },
        { 0x142C8E7E, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_Preset_5_ButtonWidget_enShortPress", 0 },
        { 0x14391799, "OnButtonReactionMsg_TunerModule_TunerScenes_R_HDDTM_TESTMODE_HD_AudioProg1_ButtonWidget_enRelease", 0 },
        { 0x14530E0D, "OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_woNav_Layer_TouchArea_Settings_ButtonWidget_enRelease", 0 },
        { 0x14823131, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_4_ButtonWidget_enShortPressRelease", 0 },
        { 0x14E169E6, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_6_ButtonWidget_enShortPress", 0 },
        { 0x14F2D1BD, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor3_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0x14FE1E83, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_7_ButtonWidget_enShortPressRelease", 0 },
        { 0x152E39D7, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_Preset_1_ButtonWidget_enRelease", 0 },
        { 0x1567387F, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_12_ButtonWidget_enShortPressRelease", 0 },
        { 0x1577BD8B, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_Preset_1_ButtonWidget_enRelease", 0 },
        { 0x15BE2E33, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_Icon_StationList_Button_enRelease", 0 },
        { 0x15EE3C60, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_TouchArea_FreqStepDown_normal_Button_enAbortPress", 0 },
        { 0x164C89B5, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_6_ButtonWidget_enShortPressRelease", 0 },
        { 0x16F5D51B, "OnButtonReactionMsg_TunerModule_Gadget_Tuner_MASTER_GADGET_TUNER_Btn_Previous_ButtonWidget_enLongPressRelease", 0 },
        { 0x17A29976, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_4_ButtonWidget_enRelease", 0 },
        { 0x17E35B67, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_11_ButtonWidget_enLongPressRelease", 0 },
        { 0x17EDA9D8, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_8_ButtonWidget_enRelease", 0 },
        { 0x1860E137, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Source_ButtonWidget_enRelease", 0 },
        { 0x18747CC3, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_3_ButtonWidget_enShortPressRelease", 0 },
        { 0x19DC63A6, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_Preset_1_ButtonWidget_enShortPress", 0 },
        { 0x19F47277, "OnTunerViewMsg", 0 },
        { 0x1A61C32F, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Toucharea_hd_info_ButtonWidget_enRelease", 0 },
        { 0x1A7DE978, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Service_Info_TestMode_Layer_TouchArea_Stepup_ButtonWidget_enRelease", 0 },
        { 0x1ADB8846, "OnButtonReactionMsg_TunerModule_TunerScenes_R_HDDTM_TESTMODE_HD_AudioProg0_ButtonWidget_enRelease", 0 },
        { 0x1B3021B1, "OnActivityMsg_eActivityID_TUNER_FM2", 0 },
        { 0x1B6C2818, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_8_ButtonWidget_enLongPress", 0 },
        { 0x1C026F8D, "OnButtonReactionMsg_TunerModule_Gadget_Tuner_MASTER_GADGET_TUNER_Btn_Next_ButtonWidget_enRelease", 0 },
        { 0x1C5C6BE9, "OnPopup_PFO_PTY31close", 0 },
        { 0x1CF8FA84, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_Layer_TouchArea_SearchNext_ButtonWidget_enLongPressRelease", 0 },
        { 0x1DD978E7, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_12_ButtonWidget_enLongPress", 0 },
        { 0x1DFC9F30, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_TouchArea_FreqStepUp_normal_Button_enShortPressRelease", 0 },
        { 0x1E5C5241, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_SearchPrevious_ButtonWidget_enAbortPress", 0 },
        { 0x1EE6B1DA, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Setup_Monitor_Btn_Sharx_Inc_Button_enRelease", 0 },
        { 0x1F395E4B, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor2_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0x20010AB4, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_TouchArea_AMHD_ButtonWidget_enRelease", 0 },
        { 0x2094F417, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_5_ButtonWidget_enShortPressRelease", 0 },
        { 0x20BC9B55, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_Preset_6_ButtonWidget_enShortPressRelease", 0 },
        { 0x212CEA25, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_Layer_TouchArea_SearchPrevious_ButtonWidget_enShortPress", 0 },
        { 0x212E8ECA, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_1_ButtonWidget_enShortPressRelease", 0 },
        { 0x22B5D5F3, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_5_ButtonWidget_enShortPress", 0 },
        { 0x22D7C31B, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_SearchPrevious_ButtonWidget_enPress", 0 },
        { 0x23B97E51, "onCenterPopupSurfaceVisible", GetEventArgumentsForonCenterPopupSurfaceVisible },
        { 0x23BE181E, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_5_ButtonWidget_enLongPress", 0 },
        { 0x2406E5D0, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_SearchPrevious_ButtonWidget_enLongPressRelease", 0 },
        { 0x251277CC, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor2_Textbox_Tuner4_ButtonWidget_enRelease", 0 },
        { 0x2553E30A, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_Morepresets_Next_ButtonWidget_enRelease", 0 },
        { 0x259C0619, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_TouchArea_FreqStepUp_normal_Button_enAbortPress", 0 },
        { 0x25BFA40A, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_Source_ButtonWidget_enRelease", 0 },
        { 0x25EC50C7, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_9_ButtonWidget_enLongPressRelease", 0 },
        { 0x2610D62E, "OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_woNav_Layer_TouchArea_Source_ButtonWidget_enRelease", 0 },
        { 0x26141D75, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_8_ButtonWidget_enShortPress", 0 },
        { 0x26361D97, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_Layer_TouchArea_Source_ButtonWidget_enRelease", 0 },
        { 0x263EAF7F, "onHKStatusChanged_HK_SELECT_UP", 0 },
        { 0x26458826, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_SearchNext_ButtonWidget_enRelease", 0 },
        { 0x2664B609, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_SearchNext_ButtonWidget_enRelease", 0 },
        { 0x269F6639, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_MonitorTestMode_Btn_Highcut_Inc_Button_enRelease", 0 },
        { 0x26C30D04, "OnPreviousLevelTransitionFinished", 0 },
        { 0x272A8DF7, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_12_ButtonWidget_enLongPressRelease", 0 },
        { 0x273BB142, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_4_ButtonWidget_enRelease", 0 },
        { 0x27478EDF, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Expert_API_TestMode_Layer_TouchArea_Seekup_ButtonWidget_enRelease", 0 },
        { 0x27833B53, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_6_ButtonWidget_enShortPress", 0 },
        { 0x27AA175D, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor_Layer_TouchArea_Stepdown_ButtonWidget_enRelease", 0 },
        { 0x27B62517, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_5_ButtonWidget_enLongPress", 0 },
        { 0x27EB987E, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_TouchArea_FreqStepDown_normal_Button_enShortPress", 0 },
        { 0x2842B3C8, "OnActivationResMsg_TunerModule_SysPopupScene_Pfo_PTY31_1", 0 },
        { 0x289190ED, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_3_ButtonWidget_enRelease", 0 },
        { 0x289A5D39, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_6_ButtonWidget_enLongPress", 0 },
        { 0x28A75C83, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_9_ButtonWidget_enShortPressRelease", 0 },
        { 0x28B0B313, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Icon_StationList_Button_enRelease", 0 },
        { 0x293196CA, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_4_ButtonWidget_enLongPressRelease", 0 },
        { 0x2A2BE4E5, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor2_Textbox_Tuner_AF_ButtonWidget_enRelease", 0 },
        { 0x2A329016, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_3_ButtonWidget_enLongPressRelease", 0 },
        { 0x2A732173, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_10_ButtonWidget_enShortPress", 0 },
        { 0x2AD37770, "OnButtonReactionMsg_TunerModule_Gadget_Tuner_MASTER_GADGET_TUNER_Btn_Next_ButtonWidget_enShortPress", 0 },
        { 0x2B484D74, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_SearchNext_ButtonWidget_enLongPressRelease", 0 },
        { 0x2BF0D3B1, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_Preset_2_ButtonWidget_enRelease", 0 },
        { 0x2C599964, "OnPopup_PFO_AST", 0 },
        { 0x2C779392, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_6_ButtonWidget_enLongPressRelease", 0 },
        { 0x2CAFEA04, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_Preset_3_ButtonWidget_enRelease", 0 },
        { 0x2CD4F5F0, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_5_ButtonWidget_enShortPress", 0 },
        { 0x2CFE314F, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_TouchArea_FreqStepDown_normal_Button_enRelease", 0 },
        { 0x2D07BF19, "OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_Layer_TouchArea_AM_AST_ButtonWidget_enRelease", 0 },
        { 0x2D40BFBA, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_TouchArea_FreqStepDown_normal_Button_enRelease", 0 },
        { 0x2D7C3716, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_8_ButtonWidget_enLongPress", 0 },
        { 0x2E3A9B75, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_5_ButtonWidget_enShortPressRelease", 0 },
        { 0x2E700169, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_7_ButtonWidget_enShortPressRelease", 0 },
        { 0x2E7DC355, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_Preset_6_ButtonWidget_enRelease", 0 },
        { 0x2EB35D28, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_5_ButtonWidget_enLongPressRelease", 0 },
        { 0x2EC7161A, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_1_ButtonWidget_enLongPressRelease", 0 },
        { 0x2FCB095A, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_9_ButtonWidget_enShortPress", 0 },
        { 0x305DFD6F, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_TouchArea_FreqStepDown_normal_Button_enLongPressRelease", 0 },
        { 0x30765DB9, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_Preset_6_ButtonWidget_enRelease", 0 },
        { 0x308166C4, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_5_ButtonWidget_enRelease", 0 },
        { 0x30E74B2A, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor3_Textbox_Tuner2_Band_ButtonWidget_enRelease", 0 },
        { 0x314E5993, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_9_ButtonWidget_enShortPress", 0 },
        { 0x317B0881, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_10_ButtonWidget_enShortPress", 0 },
        { 0x317B89D2, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_Preset_6_ButtonWidget_enShortPress", 0 },
        { 0x317CE9C6, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_SearchPrevious_ButtonWidget_enRelease", 0 },
        { 0x32F5257F, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor_Textbox_Tuner1_ButtonWidget_enRelease", 0 },
        { 0x331B7973, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_SearchNext_ButtonWidget_enLongPress", 0 },
        { 0x33B37821, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_TouchArea_FreqStepDown_normal_Button_enRelease", 0 },
        { 0x343000AE, "OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_Layer_TouchArea_Source_ButtonWidget_enLongPress", 0 },
        { 0x343ADE0C, "OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_Layer_TouchArea_DAB_ButtonWidget_enLongPress", 0 },
        { 0x3465866F, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_10_ButtonWidget_enShortPressRelease", 0 },
        { 0x34C4FC0D, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_Preset_3_ButtonWidget_enShortPressRelease", 0 },
        { 0x34D7DF58, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_TouchArea_FreqStepUp_normal_Button_enRelease", 0 },
        { 0x3598CF84, "onTopPopupSurfaceInvisible", GetEventArgumentsForonTopPopupSurfaceInvisible },
        { 0x361137AD, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Source_ButtonWidget_enLongPress", 0 },
        { 0x36287D1E, "OnActivationResMsg_TunerModule_TunerPopupScene_Pfo_CannotStore_1", 0 },
        { 0x3642EBAB, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_4_ButtonWidget_enShortPress", 0 },
        { 0x3644357E, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_2_ButtonWidget_enShortPressRelease", 0 },
        { 0x364AB166, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_TestMode_btn_bn_back_enLongPressRelease", 0 },
        { 0x36A9BB31, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_TouchArea_FreqStepDown_normal_Button_enShortPressRelease", 0 },
        { 0x36E80DF8, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_9_ButtonWidget_enLongPressRelease", 0 },
        { 0x3791AC5D, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_10_ButtonWidget_enShortPressRelease", 0 },
        { 0x37D2D492, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_Morepresets_Previous_ButtonWidget_enRelease", 0 },
        { 0x37E7CAFB, "OnDeactivateApplicationMsg", 0 },
        { 0x3818BE3A, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_SL_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0x389F0EB9, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_MonitorTestMode_Btn_Highcut_Dec_Button_enRelease", 0 },
        { 0x38BAF988, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_Preset_3_ButtonWidget_enShortPressRelease", 0 },
        { 0x38E56C32, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_AST_ButtonWidget_enPress", 0 },
        { 0x390CB324, "OnButtonReactionMsg_TunerModule_Gadget_Tuner_MASTER_GADGET_TUNER_Button_Src_Select_ButtonWidget_enRelease", 0 },
        { 0x3945D700, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor2_Textbox_Tuner3_Band_ButtonWidget_enRelease", 0 },
        { 0x3A35F923, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_SearchNext_ButtonWidget_enShortPressRelease", 0 },
        { 0x3A45EBBF, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_7_ButtonWidget_enShortPress", 0 },
        { 0x3A48B8BA, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_8_ButtonWidget_enShortPress", 0 },
        { 0x3CDBDC02, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_MonitorTestMode_Layer_TouchArea_Next_ButtonWidget_enRelease", 0 },
        { 0x3D0E0BBD, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_SearchNext_ButtonWidget_enShortPress", 0 },
        { 0x3E0B649F, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_5_ButtonWidget_enLongPress", 0 },
        { 0x3E2C3474, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_6_ButtonWidget_enLongPress", 0 },
        { 0x3EAD6437, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_3_ButtonWidget_enLongPress", 0 },
        { 0x3EB39933, "OnButtonReactionMsg_TunerModule_TunerScenes_R_HDDTM_TESTMODE_HD_AudioProg4_ButtonWidget_enRelease", 0 },
        { 0x3F266E1A, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_4_ButtonWidget_enLongPressRelease", 0 },
        { 0x3F2DFD1E, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_TestMode_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0x3F7F073A, "OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_woNav_btn_bn_DRM_enRelease", 0 },
        { 0x3FCBCD24, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_4_ButtonWidget_enShortPress", 0 },
        { 0x400C5518, "OnButtonReactionMsg_TunerModule_TunerScenes_R_WeatherBand_Layer_TouchArea_Preset_5_ButtonWidget_enRelease", 0 },
        { 0x403A65A4, "OnDualViewLeftTransitionFinished", 0 },
        { 0x40684ACE, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_3_ButtonWidget_enLongPressRelease", 0 },
        { 0x4159E176, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_2_ButtonWidget_enShortPressRelease", 0 },
        { 0x420B67AE, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Quality_TestMode_Layer_TouchArea_Stepup_ButtonWidget_enRelease", 0 },
        { 0x424C871A, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_SearchNext_ButtonWidget_enShortPress", 0 },
        { 0x426A4CFD, "OnButtonReactionMsg_TunerModule_TunerScenes_R_HDDTM_TESTMODE_Btn_ResetTransitions_ButtonWidget_enRelease", 0 },
        { 0x42AECCFD, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_11_ButtonWidget_enShortPressRelease", 0 },
        { 0x42CAB902, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_SearchPrevious_ButtonWidget_enShortPress", 0 },
        { 0x42E5E2BD, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_4_ButtonWidget_enRelease", 0 },
        { 0x4355EC8F, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor3_Textbox_Tuner4_ButtonWidget_enRelease", 0 },
        { 0x437D9EFE, "OnPageFlipFrontFinished", 0 },
        { 0x43E1179C, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_1_ButtonWidget_enLongPressRelease", 0 },
        { 0x442EAABE, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_Preset_3_ButtonWidget_enShortPress", 0 },
        { 0x443B0CC8, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_TestMode_btn_bn_next_enRelease", 0 },
        { 0x447DADF8, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_TouchArea_FreqStepDown_normal_Button_enRelease", 0 },
        { 0x4493998D, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_1_ButtonWidget_enLongPress", 0 },
        { 0x44DA962E, "OnPopup_PFO_ASTClose", 0 },
        { 0x44F76E1C, "OnButtonReactionMsg_TunerModule_TunerScenes_R_OPT_DABPTY_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0x467ACF9C, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_2_ButtonWidget_enLongPressRelease", 0 },
        { 0x468D7232, "OnPopup_PFO_TA", 0 },
        { 0x46ADA2C7, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_1_ButtonWidget_enRelease", 0 },
        { 0x46F47D46, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_1_ButtonWidget_enShortPressRelease", 0 },
        { 0x46F4928D, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor2_Textbox_Tuner2_ButtonWidget_enRelease", 0 },
        { 0x47388ECB, "OnButtonReactionMsg_TunerModule_TunerScenes_R_WeatherBand_Layer_TouchArea_Preset_10_ButtonWidget_enRelease", 0 },
        { 0x474A73D9, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_Preset_1_ButtonWidget_enShortPress", 0 },
        { 0x474FA1EA, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_AST_ButtonWidget_enPress", 0 },
        { 0x48043110, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Setup_Monitor_Btn_Sharx_Dec_Button_enRelease", 0 },
        { 0x482D0533, "OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_Layer_TouchArea_FM_AST_ButtonWidget_enRelease", 0 },
        { 0x486E3FC6, "OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_btn_bn_DRM_AST_enRelease", 0 },
        { 0x4929AFF0, "OnButtonReactionMsg_TunerModule_SysPopupScene_Pfo_WB_Layer_TouchArea_Close_ButtonWidget_enRelease", 0 },
        { 0x49BC07AF, "OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_Layer_TabMedia_ButtonWidget_enRelease", 0 },
        { 0x4A9C9FE0, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_4_ButtonWidget_enRelease", 0 },
        { 0x4B30E7BC, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_SearchPrevious_ButtonWidget_enShortPressRelease", 0 },
        { 0x4B98A712, "OnButtonReactionMsg_TunerModule_TunerScenes_R_TMC_Layer_TouchArea_TMCList_Btn_ButtonWidget_enRelease", 0 },
        { 0x4C0C1D49, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_12_ButtonWidget_enShortPress", 0 },
        { 0x4C8518AE, "onAppStatusPrepare_BACKGROUND", 0 },
        { 0x4CE8B8B8, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_Layer_TouchArea_SearchPrevious_ButtonWidget_enShortPressRelease", 0 },
        { 0x4CFF2268, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor2_Textbox_Tuner1_Band_ButtonWidget_enRelease", 0 },
        { 0x4D0EE082, "OnActivationResMsg_TunerModule_TunerPopupScene_Pfo_StorePreset_1", 0 },
        { 0x4D52566C, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_4_ButtonWidget_enShortPress", 0 },
        { 0x4DEF57C1, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_3_ButtonWidget_enRelease", 0 },
        { 0x4E61B2D8, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_7_ButtonWidget_enShortPress", 0 },
        { 0x4ED50E43, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_Preset_1_ButtonWidget_enRelease", 0 },
        { 0x4F264428, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_3_ButtonWidget_enShortPress", 0 },
        { 0x4F71C242, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0x4F7DC1BE, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_2_ButtonWidget_enLongPressRelease", 0 },
        { 0x4FF96538, "OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_Layer_TouchArea_DAB_AST_ButtonWidget_enRelease", 0 },
        { 0x5005F0B4, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_SearchPrevious_ButtonWidget_enLongPressRelease", 0 },
        { 0x5040F034, "OnButtonReactionMsg_TunerModule_TunerScenes_R_TMC_Layer_TouchArea_MI_Btn_ButtonWidget_enRelease", 0 },
        { 0x5078E7EF, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_BtnWidget2D_SrvList_enRelease", 0 },
        { 0x50B4DCCA, "OnDualViewRightTransitionFinished", 0 },
        { 0x516A1C6C, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_TestModeScreen_btn_bn_SIDPrevious_enRelease", 0 },
        { 0x51768932, "OnPopup_PFO_PTY31", 0 },
        { 0x51DF1EAA, "OnActivityMsg_eActivityID_TUNER_SETTINGS_VIEW", 0 },
        { 0x529D49FA, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_SearchPrevious_ButtonWidget_enShortPress", 0 },
        { 0x52F1E9AD, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_12_ButtonWidget_enShortPressRelease", 0 },
        { 0x53101FDD, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_6_ButtonWidget_enShortPressRelease", 0 },
        { 0x53269E5E, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_2_ButtonWidget_enLongPress", 0 },
        { 0x53757BD9, "OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_btn_bn_DRM_enRelease", 0 },
        { 0x541E7C20, "OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_Layer_TouchArea_AM_ButtonWidget_enLongPress", 0 },
        { 0x549D2326, "OnTunerPLMsg_1", 0 },
        { 0x54E4151C, "OnActivityMsg_eActivityID_TUNER_FM1", 0 },
        { 0x55104D23, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Expert_API_TestMode_Layer_TouchArea_Stepdown_ButtonWidget_enRelease", 0 },
        { 0x5564A12B, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_MonitorTestMode_ButtonToggle_Measure_Mode_ButtonWidget2D_enRelease", 0 },
        { 0x55EEEBDD, "OnActivationResMsg_TunerModule_TunerPopupScene_Pfo_UpdateDAB_SL_1", 0 },
        { 0x56164B4C, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_Preset_1_ButtonWidget_enShortPressRelease", 0 },
        { 0x5621CB49, "OnButtonReactionMsg_Layer_AppFlyIn_btn_bn_Navi_enRelease", 0 },
        { 0x56261D13, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_SearchPrevious_ButtonWidget_enPress", 0 },
        { 0x56D2150E, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_SL_btn_2D_Listback_enRelease", 0 },
        { 0x5749E156, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_8_ButtonWidget_enShortPressRelease", 0 },
        { 0x574A0A14, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor_Layer_TouchArea_Next_ButtonWidget_enRelease", 0 },
        { 0x575684BF, "OnButtonReactionMsg_TunerModule_TunerScenes_R_TestModeScreens_TouchArea_SXM_Settings_Btn_ButtonWidget_enRelease", 0 },
        { 0x5790D8C1, "onSubSurfaceUpdMsgChanged_BACKGROUND", GetEventArgumentsForonSubSurfaceUpdMsgChanged_BACKGROUND },
        { 0x58A6C605, "OnButtonReactionMsg_Layer_AppFlyIn_btn_bn_Phone_enRelease", 0 },
        { 0x58B10F53, "OnActivationResMsg_TunerModule_TunerPopupScene_Pfo_UpdateFM_SL_1", 0 },
        { 0x59455055, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_Preset_5_ButtonWidget_enRelease", 0 },
        { 0x597E4B78, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_Preset_4_ButtonWidget_enShortPressRelease", 0 },
        { 0x59E5E463, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_TouchArea_FMHD_ButtonWidget_enRelease", 0 },
        { 0x59FF19B6, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_2_ButtonWidget_enRelease", 0 },
        { 0x5A2A3D96, "OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_Layer_TouchArea_Source_ButtonWidget_enRelease", 0 },
        { 0x5A5076AA, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_11_ButtonWidget_enLongPress", 0 },
        { 0x5A75311D, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_TouchArea_FreqStepDown_normal_Button_enLongPressRelease", 0 },
        { 0x5A9719E8, "OnActivityMsg_eActivityID_TUNER_DRM_AST", 0 },
        { 0x5AFAAA30, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Monitor_btn_bn_Back_enRelease", 0 },
        { 0x5B7E23FD, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_7_ButtonWidget_enLongPress", 0 },
        { 0x5B90107A, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Expert_API_TestMode_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0x5B907E2D, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_5_ButtonWidget_enShortPressRelease", 0 },
        { 0x5C6D9A83, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_TouchArea_FreqStepDown_normal_Button_enShortPressRelease", 0 },
        { 0x5C711E51, "OnButtonReactionMsg_TunerModule_Gadget_Tuner_MASTER_GADGET_TUNER_SEEKMENU_Btn_Scan_ButtonWidget_enRelease", 0 },
        { 0x5C7285E2, "OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_Layer_TouchArea_WX_ButtonWidget_enRelease", 0 },
        { 0x5D802F26, "OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_woNav_Layer_TouchArea_AM_AST_ButtonWidget_enRelease", 0 },
        { 0x5D849956, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_3_ButtonWidget_enLongPressRelease", 0 },
        { 0x5DCF6307, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_3_ButtonWidget_enShortPressRelease", 0 },
        { 0x5ED7DDCF, "OnEnableView_TunerModule_TunerScenes_R_OPT_FMAM", 0 },
        { 0x5F7D2253, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_1_ButtonWidget_enRelease", 0 },
        { 0x5FFECD4A, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_6_ButtonWidget_enRelease", 0 },
        { 0x600F9277, "OnButtonReactionMsg_TunerModule_TunerScenes_R_WeatherBand_Monitor_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0x603DC085, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_Preset_3_ButtonWidget_enShortPress", 0 },
        { 0x6067466C, "OnButtonReactionMsg_Layer_AppFlyIn_btn_bn_Media_enRelease", 0 },
        { 0x62672364, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Setup_Monitor_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0x62E419D7, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor_Layer_TouchArea_Stepup_ButtonWidget_enRelease", 0 },
        { 0x632C4A3E, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_12_ButtonWidget_enLongPress", 0 },
        { 0x63AD203E, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_TouchArea_FreqStepUp_normal_Button_enRelease", 0 },
        { 0x63BC3299, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_MonitorTestMode_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0x63E577D7, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_8_ButtonWidget_enLongPressRelease", 0 },
        { 0x63E9E1E7, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_SL_ButtonWidget2D_Refresh_enRelease", 0 },
        { 0x643F2DFC, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_5_ButtonWidget_enLongPressRelease", 0 },
        { 0x648B1681, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_TouchArea_FreqStepUp_normal_Button_enRelease", 0 },
        { 0x6492A8C1, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_MonitorTestMode_ButtonToggle_AF_ButtonWidget2D_enRelease", 0 },
        { 0x64CAF927, "OnButtonReactionMsg_TunerModule_Gadget_Tuner_MASTER_GADGET_TUNER_Btn_Previous_ButtonWidget_enRelease", 0 },
        { 0x64F0686F, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_4_ButtonWidget_enShortPressRelease", 0 },
        { 0x65DEAB8B, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_SearchPrevious_ButtonWidget_enLongPress", 0 },
        { 0x65FEA9EA, "OnButtonReactionMsg_TunerModule_TunerScenes_R_WeatherBand_Layer_TouchArea_Preset_2_ButtonWidget_enRelease", 0 },
        { 0x66A80D9E, "OnButtonReactionMsg_TunerModule_TunerScenes_R_HDPARAMTUNING_TESTMODE_Increment_ButtonWidget_enRelease", 0 },
        { 0x672650AB, "OnButtonReactionMsg_TunerModule_TunerScenes_R_HDDTM_TESTMODE_HD_AudioProg7_ButtonWidget_enRelease", 0 },
        { 0x674CA16A, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_SearchPrevious_ButtonWidget_enShortPressRelease", 0 },
        { 0x67B9330C, "OnButtonReactionMsg_TunerModule_TunerScenes_R_WeatherBand_Layer_TouchArea_Preset_4_ButtonWidget_enRelease", 0 },
        { 0x67E5D82B, "onEncoderStatusChanged_RIGHT_ENC", GetEventArgumentsForonEncoderStatusChanged_RIGHT_ENC },
        { 0x6836C622, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_TestMode_btn_bn_back_enRelease", 0 },
        { 0x684D9639, "OnPopup_PFO_WBclose", 0 },
        { 0x688FD8BA, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_SL_Textbox_DAB_Refresh_ButtonWidget_enRelease", 0 },
        { 0x68D37CD2, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_5_ButtonWidget_enLongPressRelease", 0 },
        { 0x69032EDE, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_3_ButtonWidget_enLongPress", 0 },
        { 0x69A3B2F3, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Setup_Monitor_Layer_TouchArea_Next_ButtonWidget_enRelease", 0 },
        { 0x69F47747, "OnButtonReactionMsg_TunerModule_TunerScenes_R_TestModeScreens_TouchArea_SXM_Monitor_Btn_ButtonWidget_enRelease", 0 },
        { 0x6A294A68, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_8_ButtonWidget_enLongPressRelease", 0 },
        { 0x6B749399, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_1_ButtonWidget_enShortPressRelease", 0 },
        { 0x6B930DCC, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_SearchPrevious_ButtonWidget_enAbortPress", 0 },
        { 0x6BACA7C9, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_TouchArea_FreqStepDown_normal_Button_enPress", 0 },
        { 0x6BB29A68, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_1_ButtonWidget_enRelease", 0 },
        { 0x6C1CD62F, "onPopupInvisible", GetEventArgumentsForonPopupInvisible },
        { 0x6D12A683, "OnButtonReactionMsg_TunerModule_TunerScenes_R_HDPARAMTUNING_TESTMODE_Decrement_ButtonWidget_enRelease", 0 },
        { 0x6D17825E, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_TouchArea_FreqStepDown_normal_Button_enShortPressRelease", 0 },
        { 0x6D1B3A68, "onAppStatusChanged_BACKGROUND", 0 },
        { 0x6DC70E23, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_6_ButtonWidget_enShortPressRelease", 0 },
        { 0x6DC9A9A6, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor3_Layer_TouchArea_Seekup_ButtonWidget_enRelease", 0 },
        { 0x6DDACCBB, "OnButtonReactionMsg_TunerModule_TunerScenes_R_TestModeScreens_ButtonWidget2D_DRMSetup_Btn_enRelease", 0 },
        { 0x6E44D9DA, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_3_ButtonWidget_enShortPressRelease", 0 },
        { 0x6EB62F3A, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_SearchPrevious_ButtonWidget_enShortPressRelease", 0 },
        { 0x7006A7D8, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_MonitorTestMode_ButtonToggle_RDS_ButtonWidget2D_enRelease", 0 },
        { 0x7012A7D5, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_5_ButtonWidget_enLongPress", 0 },
        { 0x701B289B, "OnActivityMsg_eActivityID_TUNER_DAB", 0 },
        { 0x70567793, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_1_ButtonWidget_enLongPress", 0 },
        { 0x709A438A, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Source_ButtonWidget_enLongPress", 0 },
        { 0x7183D0B3, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor_Textbox_Tuner3_ButtonWidget_enRelease", 0 },
        { 0x71C4871D, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_2_ButtonWidget_enRelease", 0 },
        { 0x72045DA3, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor_Textbox_Tuner4_Band_ButtonWidget_enRelease", 0 },
        { 0x728DC305, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_SearchPrevious_ButtonWidget_enRelease", 0 },
        { 0x72F9BA11, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_MonitorTestMode_ButtonToggle_PhaseDiversity_ButtonWidget2D_enRelease", 0 },
        { 0x7371CE65, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_TouchArea_FreqStepDown_normal_Button_enLongPressRelease", 0 },
        { 0x739F02A4, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_10_ButtonWidget_enShortPress", 0 },
        { 0x7408A4E8, "OnButtonReactionMsg_TunerModule_TunerScenes_R_HDDTM_TESTMODE_Btn_SplitAudio_ButtonWidget_enRelease", 0 },
        { 0x74F534EE, "OnPageFlipBackFinished", 0 },
        { 0x750AED3C, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor2_Textbox_Tuner3_ButtonWidget_enRelease", 0 },
        { 0x7510ACEE, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_2_ButtonWidget_enRelease", 0 },
        { 0x753859CD, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_TouchArea_FreqStepDown_normal_Button_enAbortPress", 0 },
        { 0x756C0DF3, "OnShutdownMsg", 0 },
        { 0x759830FC, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_10_ButtonWidget_enLongPress", 0 },
        { 0x75A8584F, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_11_ButtonWidget_enShortPressRelease", 0 },
        { 0x75B01051, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_TouchArea_FreqStepUp_normal_Button_enPress", 0 },
        { 0x75F8D553, "OnButtonReactionMsg_TunerModule_TunerScenes_R_HDDTM_TESTMODE_HD_AudioProg5_ButtonWidget_enRelease", 0 },
        { 0x75FC0286, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_SL_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0x76588B9B, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_TouchArea_FreqStepUp_normal_Button_enRelease", 0 },
        { 0x76759446, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_TestModeScreen_btn_bn_SIDNext_enRelease", 0 },
        { 0x76C7819A, "OnButtonReactionMsg_TunerModule_TunerScenes_R_HDDTM_TESTMODE_HD_AudioProg2_ButtonWidget_enRelease", 0 },
        { 0x76CF2B88, "onHMISubStateChanged_ON", 0 },
        { 0x773FEDB7, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_7_ButtonWidget_enRelease", 0 },
        { 0x7769581D, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_1_ButtonWidget_enShortPress", 0 },
        { 0x776D7D8A, "onHMISubStateChanged_OFF", 0 },
        { 0x776F68C2, "OnTunerPLMsg_6", 0 },
        { 0x77A70231, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_TouchArea_FreqStepDown_normal_Button_enShortPressRelease", 0 },
        { 0x77B62845, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_6_ButtonWidget_enRelease", 0 },
        { 0x780E9DC5, "OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_Layer_TabRadio_ButtonWidget_enRelease", 0 },
        { 0x78136700, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_7_ButtonWidget_enLongPressRelease", 0 },
        { 0x78793CCA, "OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_Layer_TouchArea_FM2_ButtonWidget_enRelease", 0 },
        { 0x792B324E, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor3_Textbox_Tuner4_Band_ButtonWidget_enRelease", 0 },
        { 0x7A7E6D09, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_MonitorTestMode_Btn_Sharx_Inc_Button_enRelease", 0 },
        { 0x7AB14A18, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_SearchNext_ButtonWidget_enRelease", 0 },
        { 0x7AB600C4, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor2_Layer_TouchArea_Stepdown_ButtonWidget_enRelease", 0 },
        { 0x7AE0F2C1, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor2_Textbox_Tuner1_ButtonWidget_enRelease", 0 },
        { 0x7B03B190, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_2_ButtonWidget_enShortPressRelease", 0 },
        { 0x7BF07423, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_11_ButtonWidget_enLongPressRelease", 0 },
        { 0x7CEBFE69, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_SearchNext_ButtonWidget_enRelease", 0 },
        { 0x7D0B64CE, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_ButtonWidget2D_Refresh_enRelease", 0 },
        { 0x7D19807F, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_3_ButtonWidget_enShortPress", 0 },
        { 0x7D64978F, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_Preset_5_ButtonWidget_enShortPressRelease", 0 },
        { 0x7D65C519, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_Preset_6_ButtonWidget_enShortPress", 0 },
        { 0x7D6F7470, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_Preset_4_ButtonWidget_enRelease", 0 },
        { 0x7EF70B29, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_12_ButtonWidget_enRelease", 0 },
        { 0x80262CF0, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_TouchArea_FreqStepDown_normal_Button_enPress", 0 },
        { 0x806100F1, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_2_ButtonWidget_enShortPress", 0 },
        { 0x8070457C, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_MonitorTestMode_Layer_TouchArea_Source_ButtonWidget_enRelease", 0 },
        { 0x80792D1F, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Monitor_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0x80CF53BA, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_TouchArea_FreqStepDown_normal_Button_enShortPress", 0 },
        { 0x80E6540B, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_12_ButtonWidget_enLongPressRelease", 0 },
        { 0x8285E7D3, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_9_ButtonWidget_enShortPress", 0 },
        { 0x83577BF8, "OnButtonReactionMsg_TunerModule_SysPopupScene_Pfo_TA_Layer_TouchArea_Close_ButtonWidget_enRelease", 0 },
        { 0x835F4E31, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_Layer_TouchArea_SearchNext_ButtonWidget_enShortPress", 0 },
        { 0x83739B60, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_Preset_2_ButtonWidget_enShortPressRelease", 0 },
        { 0x8412516D, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_TouchArea_FreqStepUp_normal_Button_enShortPressRelease", 0 },
        { 0x84695A6A, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor3_Layer_TouchArea_Stepup_ButtonWidget_enRelease", 0 },
        { 0x84AA06C8, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_TouchArea_FreqStepUp_normal_Button_enLongPressRelease", 0 },
        { 0x84B97ACD, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_SearchPrevious_ButtonWidget_enRelease", 0 },
        { 0x84ED4AB9, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_1_ButtonWidget_enLongPressRelease", 0 },
        { 0x85B63106, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_3_ButtonWidget_enLongPressRelease", 0 },
        { 0x85ED30F9, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_9_ButtonWidget_enRelease", 0 },
        { 0x86DD782C, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor2_Textbox_Tuner4_Band_ButtonWidget_enRelease", 0 },
        { 0x87211F5A, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Service_Info_TestMode_Layer_TouchArea_Stepdown_ButtonWidget_enRelease", 0 },
        { 0x87237A84, "OnButtonReactionMsg_TunerModule_TunerScenes_R_HDDTM_TESTMODE_Btn_HdParamTuning_ButtonWidget_enRelease", 0 },
        { 0x87917EBC, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_Preset_2_ButtonWidget_enShortPress", 0 },
        { 0x87942F6E, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_6_ButtonWidget_enShortPress", 0 },
        { 0x87B90622, "OnButtonReactionMsg_TunerModule_TunerScenes_R_TMC_STN_INFO_ButtonWidget2D_Back_enRelease", 0 },
        { 0x8865A921, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_BtnWidget2D_SrvList_enRelease", 0 },
        { 0x8877A666, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_3_ButtonWidget_enShortPress", 0 },
        { 0x888991A8, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_TouchArea_FreqStepUp_normal_Button_enPress", 0 },
        { 0x88AB8EFB, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Source_ButtonWidget_enRelease", 0 },
        { 0x88B0120C, "OnButtonReactionMsg_TunerModule_TunerScenes_R_TestModeScreens_Layer_TouchArea_FM_Btn_ButtonWidget_enRelease", 0 },
        { 0x899F9EE9, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_5_ButtonWidget_enRelease", 0 },
        { 0x89E83E1B, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_1_ButtonWidget_enShortPressRelease", 0 },
        { 0x8A16745D, "OnButtonReactionMsg_TunerModule_Gadget_Tuner_MASTER_GADGET_TUNER_Btn_Next_ButtonWidget_enShortPressRelease", 0 },
        { 0x8AB3157F, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_6_ButtonWidget_enLongPress", 0 },
        { 0x8B6418E7, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_TouchArea_FreqStepUp_normal_Button_enShortPress", 0 },
        { 0x8BB0E160, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_4_ButtonWidget_enLongPress", 0 },
        { 0x8BEC3A21, "OnButtonReactionMsg_TunerModule_Gadget_Tuner_MASTER_GADGET_TUNER_SEEKMENU_Btn_Previous_ButtonWidget_enRelease", 0 },
        { 0x8C07F4DE, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_Preset_6_ButtonWidget_enShortPressRelease", 0 },
        { 0x8C1F15A1, "OnBrowseListRespMsg", 0 },
        { 0x8C6B35A6, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_3_ButtonWidget_enShortPressRelease", 0 },
        { 0x8CA552F1, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_4_ButtonWidget_enLongPressRelease", 0 },
        { 0x8D3054AC, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_AST_ButtonWidget_enPress", 0 },
        { 0x8E4FC576, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor_Textbox_Tuner3_Band_ButtonWidget_enRelease", 0 },
        { 0x8EC5014C, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_4_ButtonWidget_enLongPressRelease", 0 },
        { 0x8EE29EF7, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor2_Textbox_Tuner2_Band_ButtonWidget_enRelease", 0 },
        { 0x8F261A90, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_5_ButtonWidget_enLongPressRelease", 0 },
        { 0x8F85F10D, "OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_Layer_TouchArea_SXM_ButtonWidget_enRelease", 0 },
        { 0x9003E53B, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_2_ButtonWidget_enShortPressRelease", 0 },
        { 0x90949826, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_8_ButtonWidget_enRelease", 0 },
        { 0x90C18513, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_4_ButtonWidget_enShortPressRelease", 0 },
        { 0x912024BE, "onTopPopupSurfaceUnqueued", GetEventArgumentsForonTopPopupSurfaceUnqueued },
        { 0x917DABBA, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_7_ButtonWidget_enShortPress", 0 },
        { 0x91C7F5FB, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Expert_API_TestMode_Layer_TouchArea_Next_ButtonWidget_enRelease", 0 },
        { 0x92148F81, "OnActivationResMsg_TunerModule_TunerPopupScene_Pfo_Autostore_1", 0 },
        { 0x9296551D, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_Preset_3_ButtonWidget_enRelease", 0 },
        { 0x9355116A, "OnButtonReactionMsg_TunerModule_Gadget_Tuner_MASTER_GADGET_TUNER_Btn_Next_ButtonWidget_enAbortPress", 0 },
        { 0x93793C41, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_Preset_2_ButtonWidget_enShortPress", 0 },
        { 0x940B7D57, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_SearchNext_ButtonWidget_enRelease", 0 },
        { 0x94B45D60, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_4_ButtonWidget_enLongPress", 0 },
        { 0x95456C0F, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_8_ButtonWidget_enShortPress", 0 },
        { 0x9587A959, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_TouchArea_FreqStepUp_normal_Button_enAbortPress", 0 },
        { 0x95881864, "OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_woNav_Layer_TouchArea_DAB_AST_ButtonWidget_enRelease", 0 },
        { 0x95EFDB81, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor_Layer_TouchArea_Seekdn_ButtonWidget_enRelease", 0 },
        { 0x9603D9AB, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_INFO_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0x972FBBF6, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Expert_API_TestMode_Layer_TouchArea_Seekdn_ButtonWidget_enRelease", 0 },
        { 0x976A09B4, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_6_ButtonWidget_enShortPress", 0 },
        { 0x97D03230, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_10_ButtonWidget_enLongPressRelease", 0 },
        { 0x97FBF963, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_SearchNext_ButtonWidget_enShortPressRelease", 0 },
        { 0x984679EE, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_Layer_TouchArea_Scan_ButtonWidget_enRelease", 0 },
        { 0x984F8ED8, "onTopPopupSurfaceVisible", GetEventArgumentsForonTopPopupSurfaceVisible },
        { 0x98DAC4E4, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_Preset_3_ButtonWidget_enShortPress", 0 },
        { 0x98EA7E5A, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_Preset_6_ButtonWidget_enShortPress", 0 },
        { 0x992BC614, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_4_ButtonWidget_enShortPress", 0 },
        { 0x9AD8AE56, "OnButtonReactionMsg_TunerModule_TunerScenes_R_HDDTM_TESTMODE_HD_AudioProg6_ButtonWidget_enRelease", 0 },
        { 0x9B447C78, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_Morepresets_Next_ButtonWidget_enRelease", 0 },
        { 0x9BDB722F, "onCenterPopupSurfaceInvisible", GetEventArgumentsForonCenterPopupSurfaceInvisible },
        { 0x9D4DF4FC, "onSubSurfaceUpdMsgChanged_FOREGROUND", GetEventArgumentsForonSubSurfaceUpdMsgChanged_FOREGROUND },
        { 0x9D5F67B7, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_AST_ButtonWidget_enShortPressRelease", 0 },
        { 0x9D75CB7E, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_11_ButtonWidget_enShortPress", 0 },
        { 0x9E435EA0, "OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_Layer_TouchArea_AM_AST_ButtonWidget_enLongPress", 0 },
        { 0x9F73A258, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_5_ButtonWidget_enShortPressRelease", 0 },
        { 0x9FE98C1E, "onDeactivateImageProviderRequest", GetEventArgumentsForonDeactivateImageProviderRequest },
        { 0x9FF839A2, "OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_woNav_Layer_TouchArea_FM2_ButtonWidget_enRelease", 0 },
        { 0xA06C55A4, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_AST_ButtonWidget_enPress", 0 },
        { 0xA087EB0D, "OnButtonReactionMsg_TunerModule_TunerScenes_R_TestModeScreens_Toucharea_hd_testmode_ButtonWidget_enRelease", 0 },
        { 0xA09406E1, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_Preset_5_ButtonWidget_enRelease", 0 },
        { 0xA0988654, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Scan_ButtonWidget_enRelease", 0 },
        { 0xA0A319D9, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_Preset_2_ButtonWidget_enShortPressRelease", 0 },
        { 0xA0C900B0, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_6_ButtonWidget_enLongPress", 0 },
        { 0xA0E1B98E, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_TouchArea_FreqStepDown_normal_Button_enRelease", 0 },
        { 0xA144E781, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_SearchPrevious_ButtonWidget_enShortPressRelease", 0 },
        { 0xA15C3CEE, "onHMISubStateChanged_STANDBY_RESTRICTED", 0 },
        { 0xA290709A, "OnEnableTESTModeView_eActivityID_TUNER_FM1", 0 },
        { 0xA2B6972C, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_5_ButtonWidget_enShortPressRelease", 0 },
        { 0xA30AC5B7, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_Preset_5_ButtonWidget_enShortPressRelease", 0 },
        { 0xA3D8E52C, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_Preset_5_ButtonWidget_enShortPress", 0 },
        { 0xA4462D02, "OnButtonReactionMsg_TunerModule_TunerScenes_R_HDDTM_TESTMODE_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0xA48A190D, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_6_ButtonWidget_enRelease", 0 },
        { 0xA4A79A07, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Setup_Monitor_Btn_Highcut_Inc_Button_enRelease", 0 },
        { 0xA4F5B761, "OnActivationResMsg_TunerModule_SysPopupScene_Pfo_WB_1", 0 },
        { 0xA56624CE, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_SearchNext_ButtonWidget_enPress", 0 },
        { 0xA5807816, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_4_ButtonWidget_enLongPressRelease", 0 },
        { 0xA5873678, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_6_ButtonWidget_enRelease", 0 },
        { 0xA5B75E13, "OnButtonReactionMsg_TunerModule_TunerScenes_R_HDDTM_TESTMODE_HD_AudioProg3_ButtonWidget_enRelease", 0 },
        { 0xA5F28789, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_3_ButtonWidget_enLongPress", 0 },
        { 0xA64B6D0B, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_TouchArea_FreqStepUp_normal_Button_enLongPressRelease", 0 },
        { 0xA6CBFF45, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_SearchNext_ButtonWidget_enShortPressRelease", 0 },
        { 0xA70BAA3C, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_2_ButtonWidget_enRelease", 0 },
        { 0xA759388A, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_2_ButtonWidget_enLongPress", 0 },
        { 0xA8E944E2, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_3_ButtonWidget_enShortPress", 0 },
        { 0xA935A6C7, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_Source_ButtonWidget_enRelease", 0 },
        { 0xA95F9E2B, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_TouchArea_FreqStepUp_normal_Button_enPress", 0 },
        { 0xAA79C7DD, "onCenterPopupSurfaceUnqueued", GetEventArgumentsForonCenterPopupSurfaceUnqueued },
        { 0xAAB764DC, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_SearchPrevious_ButtonWidget_enRelease", 0 },
        { 0xAAE3F889, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_SearchPrevious_ButtonWidget_enShortPress", 0 },
        { 0xAB5331E4, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_7_ButtonWidget_enLongPressRelease", 0 },
        { 0xAB89D7A8, "onHMISubStateChanged_SECURE", 0 },
        { 0xACBB19A2, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_Morepresets_Previous_ButtonWidget_enRelease", 0 },
        { 0xACEBE2E9, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_Preset_3_ButtonWidget_enShortPressRelease", 0 },
        { 0xAD58B4E9, "OnActivityMsg_eActivityID_TUNER_FM_AST", 0 },
        { 0xADF9BBE2, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Service_Info_TestMode_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0xAE5F9D6A, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_TouchArea_FreqStepUp_normal_Button_enShortPress", 0 },
        { 0xAF0D1A54, "OnActivityMsg_eActivityID_TUNER_SOURCE_SELECTION", 0 },
        { 0xAF1EF6CF, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_10_ButtonWidget_enShortPressRelease", 0 },
        { 0xAFAD9DB3, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_MonitorTestMode_Btn_Sharx_Dec_Button_enRelease", 0 },
        { 0xAFDDF6D0, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_9_ButtonWidget_enLongPress", 0 },
        { 0xB03FA0D8, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_Preset_4_ButtonWidget_enShortPressRelease", 0 },
        { 0xB0567F25, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_TouchArea_FreqStepUp_normal_Button_enPress", 0 },
        { 0xB189C5E5, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_8_ButtonWidget_enShortPressRelease", 0 },
        { 0xB1F2BE43, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor3_Textbox_Tuner3_ButtonWidget_enRelease", 0 },
        { 0xB1FA49FF, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor_Textbox_Tuner2_ButtonWidget_enRelease", 0 },
        { 0xB25CCDEA, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor3_Layer_TouchArea_Seekdn_ButtonWidget_enRelease", 0 },
        { 0xB260BE9D, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_TestMode_btn_bn_back_enRelease", 0 },
        { 0xB37B09FD, "OnButtonReactionMsg_TunerModule_TunerScenes_R_WeatherBand_Layer_TouchArea_Preset_9_ButtonWidget_enRelease", 0 },
        { 0xB3C73D42, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_7_ButtonWidget_enLongPress", 0 },
        { 0xB48C0E48, "OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_Layer_TouchArea_DAB_ButtonWidget_enRelease", 0 },
        { 0xB4B229F5, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_3_ButtonWidget_enRelease", 0 },
        { 0xB4C26420, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_2_ButtonWidget_enLongPress", 0 },
        { 0xB5167DD1, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_10_ButtonWidget_enLongPressRelease", 0 },
        { 0xB5811DC6, "OnButtonReactionMsg_TunerModule_TunerScenes_R_WeatherBand_Layer_TouchArea_Source_ButtonWidget_enLongPress", 0 },
        { 0xB630DDBD, "onTopPopupSurfaceQueued", GetEventArgumentsForonTopPopupSurfaceQueued },
        { 0xB655542F, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_TouchArea_FreqStepUp_normal_Button_enShortPressRelease", 0 },
        { 0xB6FA2484, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor_Textbox_Tuner4_ButtonWidget_enRelease", 0 },
        { 0xB7055080, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_8_ButtonWidget_enLongPress", 0 },
        { 0xB78D7AE0, "onPopupVisible", GetEventArgumentsForonPopupVisible },
        { 0xB7A4E868, "OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_woNav_btn_bn_Back_enLongPress", 0 },
        { 0xB8797A9C, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_5_ButtonWidget_enRelease", 0 },
        { 0xB89FB055, "OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_woNav_Layer_TouchArea_FM_AST_ButtonWidget_enRelease", 0 },
        { 0xB8F1B01B, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_6_ButtonWidget_enLongPressRelease", 0 },
        { 0xB93C4CE0, "OnButtonReactionMsg_TunerModule_TunerScenes_R_TMC_INFO_Button_Back_BG_ButtonWidget_enRelease", 0 },
        { 0xB99C2EB4, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_Preset_2_ButtonWidget_enShortPressRelease", 0 },
        { 0xB99E1FBF, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_12_ButtonWidget_enShortPress", 0 },
        { 0xB9A7A9BF, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_Morepresets_Next_ButtonWidget_enRelease", 0 },
        { 0xBA1B1CF8, "OnButtonReactionMsg_TunerModule_TunerScenes_R_OPT_DRMPTY_ButtonWidget2D_Back_enRelease", 0 },
        { 0xBA2D47BD, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_2_ButtonWidget_enShortPress", 0 },
        { 0xBA8FD2E1, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_11_ButtonWidget_enRelease", 0 },
        { 0xBAB27CD5, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Expert_API_TestMode_Layer_TouchArea_Stepup_ButtonWidget_enRelease", 0 },
        { 0xBB8B10EC, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Service_Info_TestMode_Layer_TouchArea_Next_ButtonWidget_enRelease", 0 },
        { 0xBBC8C02F, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_9_ButtonWidget_enLongPressRelease", 0 },
        { 0xBBE6896C, "onPopupQueued", GetEventArgumentsForonPopupQueued },
        { 0xBC62D53B, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_SearchPrevious_ButtonWidget_enRelease", 0 },
        { 0xBCF7874C, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_TouchArea_FreqStepUp_normal_Button_enShortPress", 0 },
        { 0xBD75EB96, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_4_ButtonWidget_enShortPress", 0 },
        { 0xBE5C37AD, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_3_ButtonWidget_enShortPress", 0 },
        { 0xBE670CC6, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_Preset_6_ButtonWidget_enRelease", 0 },
        { 0xBEA9D798, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_10_ButtonWidget_enRelease", 0 },
        { 0xBF26DDAF, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_9_ButtonWidget_enRelease", 0 },
        { 0xBF2B20D1, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_SearchPrevious_ButtonWidget_enRelease", 0 },
        { 0xBF68CB5D, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor2_Layer_TouchArea_Stepup_ButtonWidget_enRelease", 0 },
        { 0xBFADD4DB, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_Preset_2_ButtonWidget_enRelease", 0 },
        { 0xC04A41B8, "OnButtonReactionMsg_TunerModule_TunerScenes_R_TestModeScreens_Layer_TouchArea_DAB_Btn_ButtonWidget_enRelease", 0 },
        { 0xC0583E23, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_12_ButtonWidget_enShortPressRelease", 0 },
        { 0xC083C5FF, "OnButtonReactionMsg_TunerModule_TunerScenes_R_TMC_Button_Back_BG_ButtonWidget_enRelease", 0 },
        { 0xC0AD568E, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_5_ButtonWidget_enRelease", 0 },
        { 0xC129729A, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_TouchArea_FreqStepDown_normal_Button_enPress", 0 },
        { 0xC33EB086, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_SearchNext_ButtonWidget_enLongPressRelease", 0 },
        { 0xC3490FBE, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor2_Layer_TouchArea_Seekup_ButtonWidget_enRelease", 0 },
        { 0xC3C1612D, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_11_ButtonWidget_enLongPress", 0 },
        { 0xC41ECF97, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_8_ButtonWidget_enRelease", 0 },
        { 0xC4B502F4, "OnButtonReactionMsg_TunerModule_Gadget_Tuner_MASTER_GADGET_TUNER_TouchArea_TunerBtn_ButtonWidget_enRelease", 0 },
        { 0xC4C7F074, "OnActivityMsg_eActivityID_TUNER_DRM", 0 },
        { 0xC4E19EBA, "OnEnableTESTModeView_eActivityID_TUNER_AM", 0 },
        { 0xC5F831A7, "OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_woNav_Layer_TouchArea_AM_ButtonWidget_enRelease", 0 },
        { 0xC6637899, "OnButtonReactionMsg_TunerModule_TunerScenes_R_HDDTM_TESTMODE_hd_param_ButtonWidget_enRelease", 0 },
        { 0xC69B810C, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_Preset_4_ButtonWidget_enShortPress", 0 },
        { 0xC70281BB, "OnActivateApplicationMsg", 0 },
        { 0xC72F72E5, "OnActivationResMsg_TunerModule_SysPopupScene_Pfo_TA_1", 0 },
        { 0xC74B5E8C, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_6_ButtonWidget_enLongPressRelease", 0 },
        { 0xC767BEB3, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_11_ButtonWidget_enShortPressRelease", 0 },
        { 0xC7894926, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_SearchPrevious_ButtonWidget_enLongPressRelease", 0 },
        { 0xC8550E7F, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_11_ButtonWidget_enRelease", 0 },
        { 0xC87FFF5E, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_1_ButtonWidget_enShortPress", 0 },
        { 0xC8D83B8B, "onHMISubStateChanged_PHONE", 0 },
        { 0xC8F602DD, "OnButtonReactionMsg_TunerModule_Gadget_Tuner_MASTER_GADGET_TUNER_Btn_Previous_ButtonWidget_enShortPressRelease", 0 },
        { 0xC9121B05, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_1_ButtonWidget_enRelease", 0 },
        { 0xC9C9EDE4, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_2_ButtonWidget_enShortPress", 0 },
        { 0xC9D3D9E9, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_Preset_3_ButtonWidget_enRelease", 0 },
        { 0xCA4EB804, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Service_Info_TestMode_Layer_TouchArea_Seekup_ButtonWidget_enRelease", 0 },
        { 0xCB9C528D, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_5_ButtonWidget_enLongPressRelease", 0 },
        { 0xCCE01D4C, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_BtnWidget2D_SrvList_enRelease", 0 },
        { 0xCD02F822, "OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_Layer_TouchArea_AM_ButtonWidget_enRelease", 0 },
        { 0xCD0B0923, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_SearchNext_ButtonWidget_enLongPress", 0 },
        { 0xCD31E1F7, "OnActivityMsg_eActivityID_TUNER_AM", 0 },
        { 0xCD9F10C6, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_Preset_2_ButtonWidget_enShortPress", 0 },
        { 0xCDA4A576, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_SearchPrevious_ButtonWidget_enRelease", 0 },
        { 0xCDDA3BC7, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_SearchNext_ButtonWidget_enAbortPress", 0 },
        { 0xCE88126A, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_Preset_4_ButtonWidget_enRelease", 0 },
        { 0xCEE39D70, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_SearchNext_ButtonWidget_enLongPressRelease", 0 },
        { 0xD00FE9F0, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor2_Layer_TouchArea_Next_ButtonWidget_enRelease", 0 },
        { 0xD0486B91, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_6_ButtonWidget_enLongPress", 0 },
        { 0xD070F0A9, "OnButtonReactionMsg_TunerModule_TunerScenes_R_HDDTM_TESTMODE_Layer_TouchArea_SeekDown_ButtonWidget_enRelease", 0 },
        { 0xD0D8F7BB, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor_Textbox_Tuner1_Band_ButtonWidget_enRelease", 0 },
        { 0xD1C38929, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_Preset_5_ButtonWidget_enShortPressRelease", 0 },
        { 0xD1E8EA69, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_4_ButtonWidget_enLongPress", 0 },
        { 0xD1FC5598, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_SearchNext_ButtonWidget_enLongPressRelease", 0 },
        { 0xD211F4E4, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_SearchPrevious_ButtonWidget_enLongPressRelease", 0 },
        { 0xD2A1A093, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_9_ButtonWidget_enRelease", 0 },
        { 0xD2F59621, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Quality_TestMode_Layer_TouchArea_Stepdown_ButtonWidget_enRelease", 0 },
        { 0xD3004684, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_12_ButtonWidget_enRelease", 0 },
        { 0xD37904DE, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_1_ButtonWidget_enLongPressRelease", 0 },
        { 0xD3BE2331, "OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_woNav_Layer_TouchArea_FM1_ButtonWidget_enRelease", 0 },
        { 0xD40210B1, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor3_Textbox_Tuner3_Band_ButtonWidget_enRelease", 0 },
        { 0xD429810F, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_SearchNext_ButtonWidget_enRelease", 0 },
        { 0xD4D25AB2, "OnDisableView_TunerModule_TunerScenes_R_OPT_FMAM", 0 },
        { 0xD4D4D6F4, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_SearchPrevious_ButtonWidget_enShortPress", 0 },
        { 0xD5421C06, "OnButtonReactionMsg_TunerModule_Gadget_Tuner_MASTER_GADGET_TUNER_Btn_Previous_ButtonWidget_enAbortPress", 0 },
        { 0xD543C304, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_3_ButtonWidget_enRelease", 0 },
        { 0xD5538896, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_SearchNext_ButtonWidget_enRelease", 0 },
        { 0xD5FF1A57, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_Preset_1_ButtonWidget_enShortPressRelease", 0 },
        { 0xD74FB515, "OnButtonReactionMsg_TunerModule_TunerScenes_R_WeatherBand_Layer_TouchArea_Source_ButtonWidget_enRelease", 0 },
        { 0xD778EF92, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor2_Layer_TouchArea_Seekdn_ButtonWidget_enRelease", 0 },
        { 0xD7E9671B, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_ButtonWidget2D_Refresh_enRelease", 0 },
        { 0xD7F395A9, "OnButtonReactionMsg_TunerModule_Gadget_Tuner_MASTER_GADGET_TUNER_SEEKMENU_Btn_Next_ButtonWidget_enRelease", 0 },
        { 0xD8276E60, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_TestMode_Button_Back_BG_ButtonWidget_enRelease", 0 },
        { 0xD8CE1B7D, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_3_ButtonWidget_enShortPressRelease", 0 },
        { 0xD8E10EDA, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_SearchNext_ButtonWidget_enShortPress", 0 },
        { 0xD9EB460F, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor3_Layer_TouchArea_Next_ButtonWidget_enRelease", 0 },
        { 0xDA27BE41, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_TouchArea_FreqStepDown_normal_Button_enShortPress", 0 },
        { 0xDB06B90A, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_TouchArea_FreqStepUp_normal_Button_enShortPressRelease", 0 },
        { 0xDB0D29F4, "onPopupUnqueued", GetEventArgumentsForonPopupUnqueued },
        { 0xDB337F4A, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_3_ButtonWidget_enLongPress", 0 },
        { 0xDBBD16BE, "OnButtonReactionMsg_TunerModule_TunerScenes_R_HDDTM_TESTMODE_Layer_TouchArea_SeekUp_ButtonWidget_enRelease", 0 },
        { 0xDD62EA5B, "onActivateImageProviderRequest", GetEventArgumentsForonActivateImageProviderRequest },
        { 0xDDEF57C5, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_TouchArea_FreqStepUp_normal_Button_enLongPressRelease", 0 },
        { 0xDDFBFA8B, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_7_ButtonWidget_enLongPressRelease", 0 },
        { 0xDDFF7062, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_SearchPrevious_ButtonWidget_enLongPress", 0 },
        { 0xDE9448E3, "onAppStatusChanged_FOREGROUND", 0 },
        { 0xDEB2B99C, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Icon_StationList_Button_enRelease", 0 },
        { 0xDEE3206F, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Service_Info_TestMode_Layer_TouchArea_Seekdn_ButtonWidget_enRelease", 0 },
        { 0xDF126B31, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_6_ButtonWidget_enShortPressRelease", 0 },
        { 0xDF32F839, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_MonitorTestMode_ButtonToggle_TAStatus_ButtonWidget2D_enRelease", 0 },
        { 0xDF785CFC, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_TouchArea_FreqStepDown_normal_Button_enShortPress", 0 },
        { 0xE0582FE6, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_1_ButtonWidget_enShortPress", 0 },
        { 0xE058329F, "OnButtonReactionMsg_TunerModule_TunerScenes_R_WeatherBand_Layer_TouchArea_Preset_1_ButtonWidget_enRelease", 0 },
        { 0xE08BD495, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_TouchArea_FreqStepDown_normal_Button_enLongPressRelease", 0 },
        { 0xE0EC18E7, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_3_ButtonWidget_enLongPressRelease", 0 },
        { 0xE0F565F3, "OnButtonReactionMsg_TunerModule_Gadget_Tuner_MASTER_GADGET_TUNER_Btn_Previous_ButtonWidget_enShortPress", 0 },
        { 0xE1167CDA, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_AST_Layer_TouchArea_Preset_5_ButtonWidget_enShortPress", 0 },
        { 0xE142FA6A, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_11_ButtonWidget_enShortPress", 0 },
        { 0xE152D781, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_Morepresets_Previous_ButtonWidget_enRelease", 0 },
        { 0xE22E6B7B, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Source_ButtonWidget_enRelease", 0 },
        { 0xE24A8671, "OnButtonReactionMsg_TunerModule_TunerScenes_R_WeatherBand_Layer_TouchArea_Preset_3_ButtonWidget_enRelease", 0 },
        { 0xE25B0779, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_12_ButtonWidget_enLongPress", 0 },
        { 0xE35725F1, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_TouchArea_FreqStepDown_normal_Button_enLongPressRelease", 0 },
        { 0xE364F274, "OnActivityMsg_eActivityID_TUNER_DAB_AST", 0 },
        { 0xE378A229, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_2_ButtonWidget_enLongPress", 0 },
        { 0xE3E6E5AE, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Icon_StationList_ButtonWidget_enRelease", 0 },
        { 0xE407E367, "OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_Layer_TouchArea_FM1_ButtonWidget_enLongPress", 0 },
        { 0xE4139A48, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_5_ButtonWidget_enShortPress", 0 },
        { 0xE42E8222, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_10_ButtonWidget_enRelease", 0 },
        { 0xE4654211, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Quality_TestMode_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0xE4658CFD, "onHMISubStateChanged_NO_DISPLAY", 0 },
        { 0xE47EA582, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_1_ButtonWidget_enShortPress", 0 },
        { 0xE523D3A8, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_3_ButtonWidget_enRelease", 0 },
        { 0xE61A1D1E, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_10_ButtonWidget_enLongPress", 0 },
        { 0xE6A8C517, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_11_ButtonWidget_enLongPress", 0 },
        { 0xE6E08B93, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor3_Textbox_Tuner1_Band_ButtonWidget_enRelease", 0 },
        { 0xE7DCE080, "OnNextLevelTransitionFinished", 0 },
        { 0xE7E93734, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_1_ButtonWidget_enLongPress", 0 },
        { 0xE85064FD, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_6_ButtonWidget_enLongPressRelease", 0 },
        { 0xE9A6D56C, "OnFadeAnimationFinished", 0 },
        { 0xE9BE81F7, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_1_ButtonWidget_enLongPressRelease", 0 },
        { 0xEA01E2FE, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_4_ButtonWidget_enShortPressRelease", 0 },
        { 0xEA6B1FAB, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_TouchArea_FreqStepUp_normal_Button_enPress", 0 },
        { 0xEA98AFC5, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_9_ButtonWidget_enLongPress", 0 },
        { 0xEADC7202, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_2_ButtonWidget_enShortPressRelease", 0 },
        { 0xEAED26D3, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_2_ButtonWidget_enShortPress", 0 },
        { 0xEAF295A9, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_7_ButtonWidget_enShortPressRelease", 0 },
        { 0xEB36907F, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_2_ButtonWidget_enLongPressRelease", 0 },
        { 0xEB8B66C5, "OnButtonReactionMsg_TunerModule_TunerScenes_R_TMC_L_Button_Back_BG_ButtonWidget_enRelease", 0 },
        { 0xEBABC23E, "OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_Layer_TouchArea_FM1_ButtonWidget_enRelease", 0 },
        { 0xEBAD5EF0, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor3_Textbox_Tuner1_ButtonWidget_enRelease", 0 },
        { 0xEC1C0C93, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_SearchNext_ButtonWidget_enShortPress", 0 },
        { 0xECD039A0, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_TestModeScreen_btn_bn_FreqPrevious_enRelease", 0 },
        { 0xED206ABD, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_1_ButtonWidget_enLongPress", 0 },
        { 0xEE373D1B, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_1_ButtonWidget_enRelease", 0 },
        { 0xEE3D39DB, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_AST_ButtonWidget_enPress", 0 },
        { 0xEE638A03, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_7_ButtonWidget_enLongPress", 0 },
        { 0xEE93F920, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_TouchArea_FreqStepDown_normal_Button_enPress", 0 },
        { 0xEF230CDC, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Quality_TestMode_Layer_TouchArea_Seekup_ButtonWidget_enRelease", 0 },
        { 0xEF82F558, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_TouchArea_FreqStepUp_normal_Button_enShortPressRelease", 0 },
        { 0xEF84BB83, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor3_Textbox_Tuner2_ButtonWidget_enRelease", 0 },
        { 0xEF9C0DD4, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_TouchArea_FreqStepUp_normal_Button_enLongPressRelease", 0 },
        { 0xEF9C194D, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_9_ButtonWidget_enLongPress", 0 },
        { 0xEFA05524, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_2_ButtonWidget_enLongPressRelease", 0 },
        { 0xEFAB0D02, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_3_ButtonWidget_enLongPress", 0 },
        { 0xF02A9D91, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_4_ButtonWidget_enLongPress", 0 },
        { 0xF04BA5FB, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AF_L_Button_Back_BG_ButtonWidget_enRelease", 0 },
        { 0xF061132A, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Quality_TestMode_Layer_TouchArea_Seekdn_ButtonWidget_enRelease", 0 },
        { 0xF0AA275B, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Source_ButtonWidget_enLongPress", 0 },
        { 0xF0DFCAA6, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_PresetAST_6_ButtonWidget_enRelease", 0 },
        { 0xF12E90B8, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_Triple_Tuner_Monitor_Layer_TouchArea_Seekup_ButtonWidget_enRelease", 0 },
        { 0xF134A2C7, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_6_ButtonWidget_enShortPressRelease", 0 },
        { 0xF16786A6, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_TouchArea_FreqStepUp_normal_Button_enRelease", 0 },
        { 0xF1FEE847, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_SearchNext_ButtonWidget_enAbortPress", 0 },
        { 0xF2C5B921, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_SearchPrevious_ButtonWidget_enRelease", 0 },
        { 0xF32708D9, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_4_ButtonWidget_enShortPressRelease", 0 },
        { 0xF36FB8B4, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_TestModeScreen_btn_bn_FreqNext_enRelease", 0 },
        { 0xF3C96D17, "onPopupTimerExpiry", GetEventArgumentsForonPopupTimerExpiry },
        { 0xF3D582B9, "OnButtonReactionMsg_TunerModule_Gadget_Tuner_MASTER_GADGET_TUNER_Toucharea_Tuner_icon_ButtonWidget_enRelease", 0 },
        { 0xF4161A88, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_8_ButtonWidget_enShortPressRelease", 0 },
        { 0xF57612C6, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_2_ButtonWidget_enLongPressRelease", 0 },
        { 0xF62CB356, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_AST_ButtonWidget_enShortPress", 0 },
        { 0xF6A93FB9, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_7_ButtonWidget_enRelease", 0 },
        { 0xF6D89D73, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM2_TouchArea_FreqStepUp_normal_Button_enLongPressRelease", 0 },
        { 0xF709B321, "OnButtonReactionMsg_TunerModule_TunerScenes_R_TestModeScreens_Layer_TouchArea_TMC_Btn_ButtonWidget_enRelease", 0 },
        { 0xF78ADEEF, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DRM_Layer_TouchArea_Source_ButtonWidget_enRelease", 0 },
        { 0xF84B3BD1, "OnZoomOutFinished", 0 },
        { 0xF89153AD, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Preset_9_ButtonWidget_enShortPressRelease", 0 },
        { 0xF89B891E, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_5_ButtonWidget_enShortPress", 0 },
        { 0xF8F98CAF, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_TouchArea_FreqStepDown_normal_Button_enPress", 0 },
        { 0xF96478DC, "onHMISubStateChanged_CLOCK", 0 },
        { 0xF96EDA70, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Setup_Monitor_Btn_Highcut_Dec_Button_enRelease", 0 },
        { 0xF9C3DD76, "OnButtonReactionMsg_TunerModule_TunerScenes_R_WeatherBand_Layer_TouchArea_Preset_7_ButtonWidget_enRelease", 0 },
        { 0xFA3E444F, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_AST_S_Layer_TouchArea_Preset_1_ButtonWidget_enShortPressRelease", 0 },
        { 0xFB706CB5, "OnButtonReactionMsg_TunerModule_Gadget_Tuner_MASTER_GADGET_TUNER_Btn_Scan_ButtonWidget_enRelease", 0 },
        { 0xFB722B55, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_TouchArea_FreqStepDown_normal_Button_enShortPressRelease", 0 },
        { 0xFBEEA58F, "OnZoomInFinished", 0 },
        { 0xFC0D2293, "onCenterPopupSurfaceQueued", GetEventArgumentsForonCenterPopupSurfaceQueued },
        { 0xFC44999C, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_Layer_TouchArea_SearchNext_ButtonWidget_enPress", 0 },
        { 0xFC81DB6F, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_5_ButtonWidget_enShortPress", 0 },
        { 0xFC8A282C, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Scan_ButtonWidget_enRelease", 0 },
        { 0xFCA3998F, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_SL_Textbox_Refresh_ButtonWidget_enRelease", 0 },
        { 0xFCCF4309, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM_AST_TouchArea_FreqStepUp_normal_Button_enShortPress", 0 },
        { 0xFDFF8319, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_AST_Layer_TouchArea_Preset_1_ButtonWidget_enShortPressRelease", 0 },
        { 0xFE273262, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Layer_TouchArea_Preset_11_ButtonWidget_enShortPress", 0 },
        { 0xFE44954B, "OnButtonReactionMsg_TunerModule_TunerScenes_R_OPT_FMAM_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0xFE5EAC9B, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_4_ButtonWidget_enRelease", 0 },
        { 0xFE64C8EF, "OnButtonReactionMsg_TunerModule_TunerScenes_R_DAB_Quality_TestMode_Layer_TouchArea_Next_ButtonWidget_enRelease", 0 },
        { 0xFE869C7D, "OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_Layer_TouchArea_Settings_ButtonWidget_enRelease", 0 },
        { 0xFEE0A8E4, "OnButtonReactionMsg_TunerModule_TunerScenes_R_AM_S_Layer_TouchArea_Source_ButtonWidget_enRelease", 0 },
        { 0xFF542F13, "OnButtonReactionMsg_TunerModule_TunerScenes_R_SourceSelection_Radio_woNav_Layer_TouchArea_DAB_ButtonWidget_enRelease", 0 },
        { 0xFFE11A11, "OnButtonReactionMsg_TunerModule_TunerScenes_R_FM1_S_Layer_TouchArea_Preset_9_ButtonWidget_enShortPressRelease", 0 },
    };
    const EventNameMapping* eventEntry = ::Courier::BinarySearch(eventId, events, 732, &EventNameMappingCmp);
    if (eventEntry && (eventId == eventEntry->mEventId)) {
        if (0 != eventEntry->mGetEventArguments) {
            eventEntry->mGetEventArguments(message, eventArguments);
        }
        return eventEntry->mEventName;
    }
    return 0;
}
#endif
// ------------------------------------------------------------------------
struct IdToNameMapping
{
    ::FeatStd::UInt32 mId;
    const ::FeatStd::Char* mName;
};

static ::FeatStd::Int IdToNameMappingCmp(::FeatStd::UInt32 id, const IdToNameMapping& nm)
{
    return (id == nm.mId) ? 0 : ((id < nm.mId) ? -1 : 1);
}

const ::FeatStd::Char * AppHmi_TunerStateMachineImpl::GetNameFromId(::FeatStd::UInt32 id)
{
    static IdToNameMapping names[56] = {
        { 0x0047AA97, "TunerModule#TunerScenes#R_DRM_AST" },
        { 0x033A8793, "TunerModule#TunerScenes#R_TMC_INFO" },
        { 0x08FB1BFC, "TunerModule#TunerScenes#R_DRM_SL" },
        { 0x0EE458DC, "TunerModule#TunerScenes#R_FM1_S" },
        { 0x1060A3F5, "TunerModule#TunerScenes#R_DAB_Quality_TestMode" },
        { 0x139A4812, "TunerModule#TunerScenes#R_FM_TestMode" },
        { 0x1A033B2A, "TunerModule#TunerScenes#R_DAB_AST" },
        { 0x20CC54B0, "TunerModule#TunerPopupScene#Pfo_AutoStore" },
        { 0x29FA39F4, "TunerModule#TunerScenes#R_FM_AST" },
        { 0x2D15CBA8, "TunerModule#TunerScenes#R_AM_INFO" },
        { 0x2F964543, "TunerModule#TunerScenes#R_TestModeScreens" },
        { 0x31AB6446, "TunerModule#TunerPopupScene#Pfo_UpdateFM_SL" },
        { 0x35AD7510, "TunerModule#TunerScenes#R_FM_Triple_Tuner_Monitor3" },
        { 0x3C51E942, "TunerModule#TunerPopupScene#Pfo_CannotStore" },
        { 0x4802CA84, "TunerModule#TunerScenes#R_DRM" },
        { 0x4ADC46D2, "TunerModule#TunerScenes#R_DAB_Setup_Monitor" },
        { 0x5825FDC9, "TunerModule#TunerScenes#R_HDPARAMTUNING_TESTMODE" },
        { 0x583AB396, "TunerModule#TunerScenes#R_OPT_DRMPTY" },
        { 0x5BC7CB41, "TunerModule#Gadget_Tuner#MASTER_GADGET_TUNER" },
        { 0x636E980E, "TunerModule#TunerScenes#R_AF_L" },
        { 0x68FCF0EE, "TunerModule#TunerScenes#R_DRM_TestMode" },
        { 0x6A193F05, "TunerModule#TunerScenes#R_WeatherBand_Monitor" },
        { 0x6C6B24A1, "TunerModule#TunerScenes#R_WeatherBand" },
        { 0x6FE38891, "TunerModule#TunerScenes#R_DAB" },
        { 0x701E3694, "TunerModule#Gadget_Tuner_Mute#MASTER_GADGET_TUNER_MUTE" },
        { 0x731B2169, "TunerModule#TunerScenes#R_OPT_DABPTY" },
        { 0x73A89E0C, "TunerModule#TunerScenes#R_TMC_STN_INFO" },
        { 0x73D391DA, "TunerModule#SysPopupScene#Pfo_TA" },
        { 0x7AE4371A, "TunerModule#TunerScenes#R_OPT_FMAM" },
        { 0x8316DF4D, "TunerModule#TunerScenes#R_DAB_Expert_API_TestMode" },
        { 0x8AE3C1B2, "TunerModule#TunerScenes#R_AM_S" },
        { 0x8DDDA9CD, "TunerModule#TunerScenes#R_TMC" },
        { 0x94044297, "TunerModule#TunerScenes#R_DRM_TestModeScreen" },
        { 0x96A1F4E2, "TunerModule#TunerScenes#R_AM_MonitorTestMode" },
        { 0xA211832E, "TunerModule#TunerPopupScene#Pfo_UpdateDAB_SL" },
        { 0xA3A756DF, "TunerModule#TunerScenes#R_TMC_L" },
        { 0xA7DFFD22, "TunerModule#SysPopupScene" },
        { 0xA94B6658, "TunerModule#TunerScenes#R_AM_TestMode" },
        { 0xA9A321C9, "TunerModule#TunerScenes#R_SourceSelection_Radio" },
        { 0xABFADBC1, "TunerModule#TunerScenes#R_DAB_Monitor" },
        { 0xABFE6390, "TunerModule#TunerScenes#R_DAB_SL" },
        { 0xAD1D6580, "TunerModule#TunerScenes#R_SourceSelection_Radio_woNav" },
        { 0xADC8A790, "TunerModule#TunerScenes#R_FM_SL" },
        { 0xAF272DC9, "TunerModule#TunerScenes#R_FM_Triple_Tuner_Monitor" },
        { 0xAFB9500B, "TunerModule#TunerScenes#R_HDDTM_TESTMODE" },
        { 0xB04BB80E, "TunerModule#TunerScenes#R_FM_INFO" },
        { 0xB3A9F107, "TunerModule#TunerScenes#R_FM_Triple_Tuner_Monitor2" },
        { 0xBB9F24E4, "TunerModule#SysPopupScene#Pfo_WB" },
        { 0xD12FE05A, "TunerModule#Gadget_Tuner_Frequency#MASTER_GADGET_TUNER_FREQUENCY" },
        { 0xDBB4C8FF, "TunerModule#TunerScenes#R_DAB_Service_Info_TestMode" },
        { 0xDCB157BA, "TunerModule#SysPopupScene#Pfo_PTY31" },
        { 0xE379AEC9, "TunerModule#TunerPopupScene#Pfo_StorePreset" },
        { 0xEAF72AEB, "TunerModule#Gadget_Tuner_SeekMenu#MASTER_GADGET_TUNER_SEEKMENU" },
        { 0xEC01E139, "TunerModule#TunerScenes#R_FM2" },
        { 0xFB717B92, "TunerModule#TunerScenes#R_FM_MonitorTestMode" },
        { 0xFF7BBA62, "TunerModule#TunerScenes#R_AM_AST_S" },
    };
    const IdToNameMapping *nameEntry = ::Courier::BinarySearch(id, names, 56, &IdToNameMappingCmp);
    if(nameEntry != 0 && id == nameEntry->mId) {
        return nameEntry->mName;
    }
    return "";
}

// ------------------------------------------------------------------------

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::acHdOnOffUpdate(::FeatStd::Int8 aBand)
{
    Action_acHdOnOffUpdate(Courier::Int8(aBand));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::acHdParameterUpdate(::FeatStd::Int8 aUpdate)
{
    Action_acHdParameterUpdate(Courier::Int8(aUpdate));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::acHdListAccess(::FeatStd::Int8 aScreenStatus)
{
    Action_acHdListAccess(Courier::Int8(aScreenStatus));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::acDtmSplitAudio()
{
    Action_acDtmSplitAudio();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::acDtmResetTransitions()
{
    Action_acDtmResetTransitions();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::acHdParameterTuningUpdate(::FeatStd::Int8 aTuneType)
{
    Action_acHdParameterTuningUpdate(Courier::Int8(aTuneType));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::acHdAudioProgSelect(::FeatStd::UInt32 aProgVal)
{
    Action_acHdAudioProgSelect(Courier::UInt32(aProgVal));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_TunerSelect_1()
{
    Action_Perform_TunerSelect_1();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_TunerSelect_2()
{
    Action_Perform_TunerSelect_2();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_TunerSelect_3()
{
    Action_Perform_TunerSelect_3();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_TunerSelect_4()
{
    Action_Perform_TunerSelect_4();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_BandSelect_Tuner1()
{
    Action_Perform_BandSelect_Tuner1();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_BandSelect_Tuner2()
{
    Action_Perform_BandSelect_Tuner2();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_BandSelect_Tuner3()
{
    Action_Perform_BandSelect_Tuner3();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_BandSelect_Tuner4()
{
    Action_Perform_BandSelect_Tuner4();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_SXM_Context()
{
    Action_Perform_SXM_Context();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_TestmodeBlock_Context()
{
    Action_Perform_TestmodeBlock_Context();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_SXMMonitor_Context()
{
    Action_Perform_SXMMonitor_Context();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_SXMSettings_Context()
{
    Action_Perform_SXMSettings_Context();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_SettingsBackBtn_Context()
{
    Action_Perform_SettingsBackBtn_Context();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Service_Linking_Inc()
{
    Action_Perform_Service_Linking_Inc();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Service_Linking_Dec()
{
    Action_Perform_Service_Linking_Dec();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Service_Link_Inc()
{
    Action_Perform_Service_Link_Inc();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Service_Link_Dec()
{
    Action_Perform_Service_Link_Dec();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_CLevel_Inc()
{
    Action_Perform_CLevel_Inc();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_CLevel_Dec()
{
    Action_Perform_CLevel_Dec();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Activate_DAB_TestMode()
{
    Action_Activate_DAB_TestMode();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Deactivate_DAB_TestMode()
{
    Action_Deactivate_DAB_TestMode();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Preset_Select_1()
{
    Action_Perform_Preset_Select_1();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Preset_Select_2()
{
    Action_Perform_Preset_Select_2();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Preset_Select_3()
{
    Action_Perform_Preset_Select_3();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Preset_Select_4()
{
    Action_Perform_Preset_Select_4();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Preset_Select_5()
{
    Action_Perform_Preset_Select_5();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Preset_Select_6()
{
    Action_Perform_Preset_Select_6();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Preset_Select_7()
{
    Action_Perform_Preset_Select_7();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Preset_Select_8()
{
    Action_Perform_Preset_Select_8();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Preset_Select_9()
{
    Action_Perform_Preset_Select_9();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Preset_Select_10()
{
    Action_Perform_Preset_Select_10();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Preset_Select_11()
{
    Action_Perform_Preset_Select_11();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Preset_Select_12()
{
    Action_Perform_Preset_Select_12();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Preset_Popup_1()
{
    Action_Perform_Preset_Popup_1();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Preset_Popup_2()
{
    Action_Perform_Preset_Popup_2();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Preset_Popup_3()
{
    Action_Perform_Preset_Popup_3();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Preset_Popup_4()
{
    Action_Perform_Preset_Popup_4();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Preset_Popup_5()
{
    Action_Perform_Preset_Popup_5();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Preset_Popup_6()
{
    Action_Perform_Preset_Popup_6();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Preset_Popup_7()
{
    Action_Perform_Preset_Popup_7();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Preset_Popup_8()
{
    Action_Perform_Preset_Popup_8();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Preset_Popup_9()
{
    Action_Perform_Preset_Popup_9();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Preset_Popup_10()
{
    Action_Perform_Preset_Popup_10();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Preset_Popup_11()
{
    Action_Perform_Preset_Popup_11();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Preset_Popup_12()
{
    Action_Perform_Preset_Popup_12();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_CannotStore_Popup()
{
    Action_Perform_CannotStore_Popup();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Preset_Store_1()
{
    Action_Perform_Preset_Store_1();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Preset_Store_2()
{
    Action_Perform_Preset_Store_2();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Preset_Store_3()
{
    Action_Perform_Preset_Store_3();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Preset_Store_4()
{
    Action_Perform_Preset_Store_4();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Preset_Store_5()
{
    Action_Perform_Preset_Store_5();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Preset_Store_6()
{
    Action_Perform_Preset_Store_6();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Preset_Store_7()
{
    Action_Perform_Preset_Store_7();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Preset_Store_8()
{
    Action_Perform_Preset_Store_8();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Preset_Store_9()
{
    Action_Perform_Preset_Store_9();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Preset_Store_10()
{
    Action_Perform_Preset_Store_10();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Preset_Store_11()
{
    Action_Perform_Preset_Store_11();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Preset_Store_12()
{
    Action_Perform_Preset_Store_12();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Seek_Stop()
{
    Action_Perform_Seek_Stop();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Seek_Next()
{
    Action_Perform_Seek_Next();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Seek_Previous()
{
    Action_Perform_Seek_Previous();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Seek_Next_Repeat()
{
    Action_Perform_Seek_Next_Repeat();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Seek_Previous_Repeat()
{
    Action_Perform_Seek_Previous_Repeat();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Seek_Previous_Jump()
{
    Action_Perform_Seek_Previous_Jump();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Seek_Next_Jump()
{
    Action_Perform_Seek_Next_Jump();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_RefTunerModule_Scene_Tuner_FM()
{
    Action_Perform_RefTunerModule_Scene_Tuner_FM();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_RefTunerModule_Scene_Tuner_AM()
{
    Action_Perform_RefTunerModule_Scene_Tuner_AM();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Freq_Tuning_StepUp()
{
    Action_Perform_Freq_Tuning_StepUp();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Freq_Tuning_StepDown()
{
    Action_Perform_Freq_Tuning_StepDown();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Freq_Scan_Start()
{
    Action_Perform_Freq_Scan_Start();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Freq_Scan_Stop()
{
    Action_Perform_Freq_Scan_Stop();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_MediaChange()
{
    Action_Perform_MediaChange();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_HomeScreenChange()
{
    Action_Perform_HomeScreenChange();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_BTPhoneMsgChange()
{
    Action_Perform_BTPhoneMsgChange();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_NaviChange()
{
    Action_Perform_NaviChange();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_MirrorLinkChange()
{
    Action_Perform_MirrorLinkChange();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::PreformTunerAppActReqMsg()
{
    Action_PreformTunerAppActReqMsg();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Preform_AFListExit()
{
    Action_Preform_AFListExit();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_DAB_TM_Freq_Seek_Next()
{
    Action_Perform_DAB_TM_Freq_Seek_Next();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_DAB_TM_Freq_Seek_Previous()
{
    Action_Perform_DAB_TM_Freq_Seek_Previous();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_DAB_TM_Ensemble_Seek_Next()
{
    Action_Perform_DAB_TM_Ensemble_Seek_Next();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_DAB_TM_Ensemble_Seek_Previous()
{
    Action_Perform_DAB_TM_Ensemble_Seek_Previous();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::TunerViewReq_SourceSelection()
{
    Action_TunerViewReq_SourceSelection();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::TunerViewReq_FM1()
{
    Action_TunerViewReq_FM1();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::TunerViewReq_FM2()
{
    Action_TunerViewReq_FM2();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::TunerViewReq_FM_AST()
{
    Action_TunerViewReq_FM_AST();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::TunerViewReq_AM()
{
    Action_TunerViewReq_AM();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::TunerViewReq_AM_AST()
{
    Action_TunerViewReq_AM_AST();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::TunerViewReq_DAB()
{
    Action_TunerViewReq_DAB();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::TunerViewReq_DAB_Monitor()
{
    Action_TunerViewReq_DAB_Monitor();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::TunerViewReq_DAB_AST()
{
    Action_TunerViewReq_DAB_AST();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::TunerViewReq_WEATHERBAND()
{
    Action_TunerViewReq_WEATHERBAND();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::TunerViewReq_WEATHERBAND_MONITOR()
{
    Action_TunerViewReq_WEATHERBAND_MONITOR();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::TunerViewReq_DRM()
{
    Action_TunerViewReq_DRM();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::TunerViewReq_DRM_AST()
{
    Action_TunerViewReq_DRM_AST();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::TunerViewReq_DRM_SL()
{
    Action_TunerViewReq_DRM_SL();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::TunerViewReq_OPT_DRMPTY()
{
    Action_TunerViewReq_OPT_DRMPTY();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::TunerViewReq_OPT_FMAM()
{
    Action_TunerViewReq_OPT_FMAM();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::TunerViewReq_OPT_DABPTY()
{
    Action_TunerViewReq_OPT_DABPTY();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::TunerViewReq_FM_TESTMODE()
{
    Action_TunerViewReq_FM_TESTMODE();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::TunerViewReq_FM_MONITORTESTMODE()
{
    Action_TunerViewReq_FM_MONITORTESTMODE();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::TunerViewReq_AM_TESTMODE()
{
    Action_TunerViewReq_AM_TESTMODE();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::TunerViewReq_AM_MONITORTESTMODE()
{
    Action_TunerViewReq_AM_MONITORTESTMODE();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::TunerViewReq_Previous()
{
    Action_TunerViewReq_Previous();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::TunerViewReq_PlayView()
{
    Action_TunerViewReq_PlayView();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::TunerViewReq_FM_SL()
{
    Action_TunerViewReq_FM_SL();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::TunerViewReq_DAB_SL()
{
    Action_TunerViewReq_DAB_SL();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::TunerViewReq_TT_MONITOR1()
{
    Action_TunerViewReq_TT_MONITOR1();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::TunerViewReq_TT_MONITOR2()
{
    Action_TunerViewReq_TT_MONITOR2();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::TunerViewReq_TT_MONITOR3()
{
    Action_TunerViewReq_TT_MONITOR3();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::TunerViewReq_DAB_SETUP_MONITOR()
{
    Action_TunerViewReq_DAB_SETUP_MONITOR();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::TunerViewReq_DAB_Quality_TestMode()
{
    Action_TunerViewReq_DAB_Quality_TestMode();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::TunerViewReq_DAB_Service_Info_TestMod()
{
    Action_TunerViewReq_DAB_Service_Info_TestMod();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::TunerViewReq_DAB_Expert_API_TestMode()
{
    Action_TunerViewReq_DAB_Expert_API_TestMode();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::TunerViewReq_DRMSetup_Monitor()
{
    Action_TunerViewReq_DRMSetup_Monitor();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::TunerViewReq_AF_L()
{
    Action_TunerViewReq_AF_L();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::TunerViewReq_TMC()
{
    Action_TunerViewReq_TMC();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::TunerViewReq_TMC_L()
{
    Action_TunerViewReq_TMC_L();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::TunerViewReq_TMC_INFO()
{
    Action_TunerViewReq_TMC_INFO();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::TunerViewReq_TMC_STN_INFO()
{
    Action_TunerViewReq_TMC_STN_INFO();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::TunerViewReq_TestModeScreens()
{
    Action_TunerViewReq_TestModeScreens();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::TunerTestModeViewReqMsg_Start()
{
    Action_TunerTestModeViewReqMsg_Start();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::TunerTestModeViewReqMsg_Stop()
{
    Action_TunerTestModeViewReqMsg_Stop();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::TunerViewReq_MASTER_GADGET_TUNER()
{
    Action_TunerViewReq_MASTER_GADGET_TUNER();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::TunerViewReq_FM_INFO()
{
    Action_TunerViewReq_FM_INFO();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::TunerViewReq_AM_INFO()
{
    Action_TunerViewReq_AM_INFO();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::TunerViewReq_HDDTM_TESTMODE()
{
    Action_TunerViewReq_HDDTM_TESTMODE();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::TunerViewReq_HDPARAMTUNING_TESTMODE()
{
    Action_TunerViewReq_HDPARAMTUNING_TESTMODE();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Activate_Home_Source()
{
    Action_Perform_Activate_Home_Source();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_AutoStore_AM()
{
    Action_Perform_AutoStore_AM();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_AutoStore_FM()
{
    Action_Perform_AutoStore_FM();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_AutoStore_DAB()
{
    Action_Perform_AutoStore_DAB();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::RequestBrowseList(::FeatStd::UInt8 aG_SM_ListType)
{
    Action_RequestBrowseList(Courier::UInt8(aG_SM_ListType));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::RequestBrowseListExit(::FeatStd::UInt8 aG_SM_ListType)
{
    Action_RequestBrowseListExit(Courier::UInt8(aG_SM_ListType));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::StationBrowseList()
{
    Action_StationBrowseList();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::DABStationBrowseList()
{
    Action_DABStationBrowseList();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::FMMonitorMessageSharxHiCut(::FeatStd::UInt8 aFirstArg, ::FeatStd::UInt8 aSecondArg)
{
    Action_FMMonitorMessageSharxHiCut(Candera::UInt8(aFirstArg), Candera::UInt8(aSecondArg));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Tuner_fn(::FeatStd::UInt8 aEventId, ::FeatStd::UInt32 aFirstArg, ::FeatStd::UInt32 aSecondArg)
{
    Action_Perform_Tuner_fn(Courier::Int8(aEventId), Courier::Int32(aFirstArg), Courier::Int32(aSecondArg));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Next_fn_FM()
{
    Action_Perform_Next_fn_FM();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Previous_fn_FM()
{
    Action_Perform_Previous_fn_FM();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Next_fn_AM()
{
    Action_Perform_Next_fn_AM();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Previous_fn_AM()
{
    Action_Perform_Previous_fn_AM();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Next_fn_DAB()
{
    Action_Perform_Next_fn_DAB();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Previous_fn_DAB()
{
    Action_Perform_Previous_fn_DAB();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Next_fn()
{
    Action_Perform_Next_fn();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Previous_fn()
{
    Action_Perform_Previous_fn();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Abort_Next_Previous_Icon_fn()
{
    Action_Perform_Abort_Next_Previous_Icon_fn();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Notify_Init_Finished()
{
    Action_Notify_Init_Finished();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Main_Src_Select()
{
    Action_Perform_Main_Src_Select();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Tuner_Src_Select()
{
    Action_Perform_Tuner_Src_Select();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Home_Src_Toggle()
{
    Action_Perform_Home_Src_Toggle();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Send_Context(::FeatStd::UInt8 aContextScene)
{
    Action_Perform_Send_Context(Courier::UInt8(aContextScene));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Tuner_Wx_fn(::FeatStd::UInt32 aEventId)
{
    Action_Perform_Tuner_Wx_fn(Courier::Int32(aEventId));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Perform_Stop_Next_Previous()
{
    Action_Perform_Stop_Next_Previous();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Update_Preset_Focused()
{
    Action_Update_Preset_Focused();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Update_FMPreset_Focused()
{
    Action_Update_FMPreset_Focused();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Update_AMPreset_Focused()
{
    Action_Update_AMPreset_Focused();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::Update_Previous_View()
{
    Action_Update_Previous_View();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacChangeLanguageReq(::FeatStd::Int32 aLanguageId)
{
    Action_gacChangeLanguageReq(enLanguageId(aLanguageId));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacHideFocusInViewReq(::FeatStd::UInt32 aView)
{
    Action_gacHideFocusInViewReq(::Courier::ViewId(AppHmi_TunerStateMachineImpl::GetNameFromId(aView)));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::NextLevelTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_NextLevelTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::PreviousLevelTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_PreviousLevelTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::DualViewLeftTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_DualViewLeftTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::DualViewRightTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_DualViewRightTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::PageFlipBackTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_PageFlipBackTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::PageFlipFrontTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_PageFlipFrontTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::ZoomInTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView, ::FeatStd::Int8 aPos)
{
    Action_ZoomInTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView), Candera::UInt8(aPos));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::ZoomOutTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView, ::FeatStd::Int8 aPos)
{
    Action_ZoomOutTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView), Candera::UInt8(aPos));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::FadeTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_FadeTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacWaitAnimationStartReq()
{
    Action_gacWaitAnimationStartReq();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::acFocusOnRightEncoderReqUpd(bool aIsFocusUsed)
{
    Action_acFocusOnRightEncoderReqUpd(bool(aIsFocusUsed));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::acSetGadgetSceenActiveStatus(bool aIsGadgetAtive)
{
    Action_acSetGadgetSceenActiveStatus(bool(aIsGadgetAtive));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::acHKNotificationMsg(::FeatStd::Int8 aHKCode, ::FeatStd::Int8 aHKState)
{
    Action_acHKNotificationMsg(Courier::UInt8(aHKCode), Courier::UInt8(aHKState));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::acPerform_CloseAllDropdowns()
{
    Action_acPerform_CloseAllDropdowns();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::acPerform_CloseDropdown(::FeatStd::UInt32 aListId)
{
    Action_acPerform_CloseDropdown(::Courier::UInt32(aListId));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::acPerform_OpenDropdown(::FeatStd::UInt32 aListId)
{
    Action_acPerform_OpenDropdown(::Courier::UInt32(aListId));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::acPerform_ToggleDropdown(::FeatStd::UInt32 aListId)
{
    Action_acPerform_ToggleDropdown(::Courier::UInt32(aListId));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::acStartAppPopupTimer(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aTimeout)
{
    Action_acStartAppPopupTimer(Courier::UInt32(aViewId), Courier::UInt32(aTimeout));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::acStopAppPopupTimer(::FeatStd::UInt32 aViewId)
{
    Action_acStopAppPopupTimer(Courier::UInt32(aViewId));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::acPostBeep(::FeatStd::Int8 aBeepType)
{
    Action_acPostBeep(Courier::Int32(aBeepType));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacCheckToClosePopup(::FeatStd::UInt32 aPopupId)
{
    Action_gacCheckToClosePopup(Courier::UInt32(aPopupId));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::acRestartAppPopupTimer(::FeatStd::UInt32 aViewId)
{
    Action_acRestartAppPopupTimer(Courier::UInt32(aViewId));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacContextSwitchBackRes(::FeatStd::UInt32 aSwitchId)
{
    Action_gacContextSwitchBackRes(Courier::UInt32(aSwitchId));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacContextSwitchCompleteRes(::FeatStd::UInt32 aSwitchId)
{
    Action_gacContextSwitchCompleteRes(Courier::UInt32(aSwitchId));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacContextSwitchFailedRes(::FeatStd::UInt32 aSwitchId)
{
    Action_gacContextSwitchFailedRes(Courier::UInt32(aSwitchId));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacContextSwitchDoneRes(::FeatStd::UInt32 aSwitchId)
{
    Action_gacContextSwitchDoneRes(Courier::UInt32(aSwitchId));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacContextSwitchOutReq(::FeatStd::UInt32 aTargetContextId, ::FeatStd::UInt32 aSourceContextId, ::FeatStd::UInt32 aTargetAppId)
{
    Action_gacContextSwitchOutReq(Courier::UInt32(aTargetContextId), Courier::UInt32(aSourceContextId), Courier::UInt32(aTargetAppId));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacCurrentScreenDisplayReq()
{
    Action_gacCurrentScreenDisplayReq();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacLaunchBarDisplayReq(bool aVisibility)
{
    Action_gacLaunchBarDisplayReq(bool(aVisibility));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacNavTBTSwipe()
{
    Action_gacNavTBTSwipe();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacPerformListBtnRightEncoderChangeUpd(::FeatStd::Int8 aSteps, ::FeatStd::UInt32 aListId, ::FeatStd::UInt32 aRowId, ::FeatStd::UInt32 aColumnId)
{
    Action_gacPerformListBtnRightEncoderChangeUpd(Courier::Int8(aSteps), Courier::UInt32(aListId), Courier::UInt32(aRowId), Courier::UInt32(aColumnId));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacScrollListUp()
{
    Action_gacScrollListUp();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacScrollListDown()
{
    Action_gacScrollListDown();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacScrollPageUp()
{
    Action_gacScrollPageUp();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacScrollPageDown()
{
    Action_gacScrollPageDown();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacScrollListFocusUp(::FeatStd::UInt32 aListId)
{
    Action_gacScrollListFocusUp(Courier::UInt32(aListId));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacScrollListFocusDown(::FeatStd::UInt32 aListId)
{
    Action_gacScrollListFocusDown(Courier::UInt32(aListId));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacPerformListFocusLockDataResetUpd()
{
    Action_gacPerformListFocusLockDataResetUpd();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacSetApplicationMode(::FeatStd::UInt32 aModeId)
{
    Action_gacSetApplicationMode(Courier::UInt32(aModeId));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacSpellerBbehaviorReq(bool aEnable)
{
    Action_gacSpellerBbehaviorReq(bool(aEnable));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacStatusBarDisplayReq(bool aVisibility, ::FeatStd::Int32 aHeaderType)
{
    Action_gacStatusBarDisplayReq(bool(aVisibility), Courier::Int32(aHeaderType));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacTBTRetriggerAcousticOutput()
{
    Action_gacTBTRetriggerAcousticOutput();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacWaitAnimationStopReq()
{
    Action_gacWaitAnimationStopReq();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacViewCreateReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewCreateReq(::Courier::ViewId(AppHmi_TunerStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacViewCreateAllReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewCreateAllReq(::Courier::ViewId(AppHmi_TunerStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacViewDestroyReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewDestroyReq(::Courier::ViewId(AppHmi_TunerStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacViewClearReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewClearReq(::Courier::ViewId(AppHmi_TunerStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacViewShowReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewShowReq(::Courier::ViewId(AppHmi_TunerStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacViewHideReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewHideReq(::Courier::ViewId(AppHmi_TunerStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacViewCreateWithoutLoadReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewCreateWithoutLoadReq(::Courier::ViewId(AppHmi_TunerStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacViewAsyncLoadReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewAsyncLoadReq(::Courier::ViewId(AppHmi_TunerStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacViewActivateWithoutRenderingReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewActivateWithoutRenderingReq(::Courier::ViewId(AppHmi_TunerStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacPopupCreateAndSBShowReq(::FeatStd::UInt32 aViewId)
{
    Action_gacPopupCreateAndSBShowReq(::Courier::ViewId(AppHmi_TunerStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacPopupCreateAndSBShowReqForMultiDisplay(::FeatStd::UInt32 aPopupDisplayID, ::FeatStd::UInt32 aViewId)
{
    Action_gacPopupCreateAndSBShowReqForMultiDisplay(Courier::UInt32(aPopupDisplayID), ::Courier::ViewId(AppHmi_TunerStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacPopupSBCloseReq(::FeatStd::UInt32 aViewId)
{
    Action_gacPopupSBCloseReq(::Courier::ViewId(AppHmi_TunerStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacPopupSBCloseReqForMultiDisplay(::FeatStd::UInt32 aPopupDisplayID, ::FeatStd::UInt32 aViewId)
{
    Action_gacPopupSBCloseReqForMultiDisplay(Courier::UInt32(aPopupDisplayID), ::Courier::ViewId(AppHmi_TunerStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacPopupRestartTimerReq(::FeatStd::UInt32 aViewId)
{
    Action_gacPopupRestartTimerReq(::Courier::ViewId(AppHmi_TunerStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacPopupRestartTimerReqForMultiDisplay(::FeatStd::UInt32 aPopupDisplayID, ::FeatStd::UInt32 aViewId)
{
    Action_gacPopupRestartTimerReqForMultiDisplay(Courier::UInt32(aPopupDisplayID), ::Courier::ViewId(AppHmi_TunerStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacViewCreateAndShowReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewCreateAndShowReq(::Courier::ViewId(AppHmi_TunerStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacViewHideAndDestroyReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewHideAndDestroyReq(::Courier::ViewId(AppHmi_TunerStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacSceneTransitionEnter(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aHint)
{
    Action_gacSceneTransitionEnter(::Courier::ViewId(AppHmi_TunerStateMachineImpl::GetNameFromId(aViewId)), Courier::UInt32(aHint));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacSceneTransitionLeave(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aHint)
{
    Action_gacSceneTransitionLeave(::Courier::ViewId(AppHmi_TunerStateMachineImpl::GetNameFromId(aViewId)), Courier::UInt32(aHint));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacDisplayStatusLineReq(::FeatStd::Int32 aDisplayRegionType)
{
    Action_gacDisplayStatusLineReq(Courier::Int32(aDisplayRegionType));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacHideStatusLineReq(::FeatStd::Int32 aDisplayRegionType)
{
    Action_gacHideStatusLineReq(Courier::Int32(aDisplayRegionType));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacDisplayFooterLineReq()
{
    Action_gacDisplayFooterLineReq();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacHideFooterLineReq()
{
    Action_gacHideFooterLineReq();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacDisplayStatusLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID)
{
    Action_gacDisplayStatusLineMultiDisplayReq(Courier::Int32(aDisplayRegionType), Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacHideStatusLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID)
{
    Action_gacHideStatusLineMultiDisplayReq(Courier::Int32(aDisplayRegionType), Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacDisplayFooterLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID)
{
    Action_gacDisplayFooterLineMultiDisplayReq(Courier::Int32(aDisplayRegionType), Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacHideFooterLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID)
{
    Action_gacHideFooterLineMultiDisplayReq(Courier::Int32(aDisplayRegionType), Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacRegisterForCloseOnTouchSession(::FeatStd::UInt32 aViewId)
{
    Action_gacRegisterForCloseOnTouchSession(::Courier::ViewId(AppHmi_TunerStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacDeregisterForCloseOnTouchSessionReq(::FeatStd::UInt32 aViewId)
{
    Action_gacDeregisterForCloseOnTouchSessionReq(::Courier::ViewId(AppHmi_TunerStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacPopupFilterPrioEnableReq(::FeatStd::UInt32 aPrio)
{
    Action_gacPopupFilterPrioEnableReq(Courier::UInt32(aPrio));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacPopupFilterAllEnableReq()
{
    Action_gacPopupFilterAllEnableReq();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacPopupFilterDisableReq()
{
    Action_gacPopupFilterDisableReq();
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacProfileChange(::FeatStd::Int8 aProfile)
{
    Action_gacProfileChange(Courier::UInt32(aProfile));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacPopupFilterPrioEnableReqForDisplay(::FeatStd::UInt32 aPrio, ::FeatStd::UInt32 aDisplayID)
{
    Action_gacPopupFilterPrioEnableReqForDisplay(Courier::UInt32(aPrio), Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacPopupFilterAllEnableReqForDisplay(::FeatStd::UInt32 aDisplayID)
{
    Action_gacPopupFilterAllEnableReqForDisplay(Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacPopupFilterDisableReqForDisplay(::FeatStd::UInt32 aDisplayID)
{
    Action_gacPopupFilterDisableReqForDisplay(Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacStartSceneTransitionAnimation(::FeatStd::UInt32 aSourceView, ::FeatStd::UInt32 aDestinationView, ::FeatStd::UInt32 aUserData1, ::FeatStd::Int8 aUserData2)
{
    Action_gacStartSceneTransitionAnimation(::Courier::ViewId(AppHmi_TunerStateMachineImpl::GetNameFromId(aSourceView)), ::Courier::ViewId(AppHmi_TunerStateMachineImpl::GetNameFromId(aDestinationView)), Courier::UInt32(aUserData1), Courier::Int8(aUserData2));
}

// ------------------------------------------------------------------------
void AppHmi_TunerStateMachineImpl::gacDecrementActiveAnimationCount()
{
    Action_gacDecrementActiveAnimationCount();
}
#ifdef CIT_SIMULATION
struct ActionMapping
{
    ::FeatStd::UInt32 mHashId;
    bool (*mActionCallHandler)(const ::Json::Value& parameters, ::Json::Value &response);
};

static ::FeatStd::Int ActionMappingCmp(::FeatStd::UInt32 hash, const ActionMapping& am)
{
    return (hash == am.mHashId) ? 0 : ((hash < am.mHashId) ? -1 : 1);
}

bool AppHmi_TunerStateMachineImpl::CallAction(const ::FeatStd::Char* actionName, const ::Json::Value& parameters, ::Json::Value &response)
{
    static ActionMapping actions[248] = {
        { 0x0171B363, CallAction_Perform_SettingsBackBtn_Context },
        { 0x02A6F746, CallAction_Perform_BandSelect_Tuner1 },
        { 0x036A7B40, CallAction_Perform_Tuner_Wx_fn },
        { 0x049D466A, CallAction_TunerViewReq_TestModeScreens },
        { 0x0884F877, CallAction_gacScrollListUp },
        { 0x089FCD89, CallAction_Perform_RefTunerModule_Scene_Tuner_FM },
        { 0x090A895B, CallAction_gacScrollListFocusDown },
        { 0x0A4C5DC9, CallAction_gacDisplayStatusLineMultiDisplayReq },
        { 0x0C279721, CallAction_gacDecrementActiveAnimationCount },
        { 0x0CC5B505, CallAction_Perform_Preset_Store_3 },
        { 0x0F0F54E4, CallAction_TunerViewReq_DAB },
        { 0x10371A8A, CallAction_RequestBrowseListExit },
        { 0x10F393E3, CallAction_Perform_BandSelect_Tuner2 },
        { 0x11519413, CallAction_Perform_Freq_Scan_Start },
        { 0x11915CFE, CallAction_acStopAppPopupTimer },
        { 0x11A810C3, CallAction_Perform_Send_Context },
        { 0x143BB5BD, CallAction_Perform_Preset_Popup_1 },
        { 0x15061065, CallAction_gacViewShowReq },
        { 0x1647CC9A, CallAction_TunerViewReq_FM_TESTMODE },
        { 0x16FAD1E6, CallAction_TunerViewReq_DAB_SL },
        { 0x186A69F1, CallAction_gacWaitAnimationStopReq },
        { 0x187DA604, CallAction_acPerform_OpenDropdown },
        { 0x1990523D, CallAction_Perform_Seek_Stop },
        { 0x1A9FB747, CallAction_Perform_Preset_Select_12 },
        { 0x1B1BC37D, CallAction_Perform_Preset_Popup_3 },
        { 0x1BC6E0A9, CallAction_ZoomInTransition },
        { 0x1ED9D92D, CallAction_Perform_Preset_Store_6 },
        { 0x1F79358A, CallAction_Perform_SXM_Context },
        { 0x21D28195, CallAction_Perform_Freq_Scan_Stop },
        { 0x21E3828E, CallAction_gacDisplayStatusLineReq },
        { 0x236D1366, CallAction_Perform_CLevel_Dec },
        { 0x236FE7C4, CallAction_Perform_Main_Src_Select },
        { 0x23EBED8E, CallAction_Perform_Freq_Tuning_StepDown },
        { 0x251DE22F, CallAction_gacContextSwitchCompleteRes },
        { 0x254E0D94, CallAction_gacViewHideReq },
        { 0x258104C2, CallAction_DualViewLeftTransition },
        { 0x264B8E81, CallAction_gacPopupRestartTimerReqForMultiDisplay },
        { 0x27CE647F, CallAction_gacScrollListFocusUp },
        { 0x29C60A74, CallAction_Perform_AutoStore_AM },
        { 0x29D14586, CallAction_gacDisplayFooterLineMultiDisplayReq },
        { 0x2A1E6CB2, CallAction_gacDeregisterForCloseOnTouchSessionReq },
        { 0x2A8EA16F, CallAction_TunerViewReq_AM_INFO },
        { 0x2AE288D8, CallAction_gacViewDestroyReq },
        { 0x30527C1E, CallAction_Perform_Preset_Store_5 },
        { 0x30822B6F, CallAction_Perform_Home_Src_Toggle },
        { 0x30C8D840, CallAction_gacStartSceneTransitionAnimation },
        { 0x30CCEEDF, CallAction_Perform_Preset_Popup_2 },
        { 0x314C188D, CallAction_Perform_TunerSelect_3 },
        { 0x325BE13A, CallAction_gacViewCreateReq },
        { 0x32DBDE04, CallAction_Perform_DAB_TM_Ensemble_Seek_Previous },
        { 0x334571BF, CallAction_acHKNotificationMsg },
        { 0x33C2B4D9, CallAction_Perform_Seek_Next },
        { 0x35DEDD19, CallAction_TunerViewReq_AM_AST },
        { 0x3651881C, CallAction_Perform_Preset_Store_9 },
        { 0x3A77E6A2, CallAction_Update_Previous_View },
        { 0x3B55C0FA, CallAction_Perform_MediaChange },
        { 0x3BB18A69, CallAction_gacPopupFilterAllEnableReq },
        { 0x3CD6874A, CallAction_TunerViewReq_AF_L },
        { 0x3D67AA3F, CallAction_acHdListAccess },
        { 0x3E4B491B, CallAction_Perform_Seek_Previous_Repeat },
        { 0x3E4CE5A1, CallAction_gacContextSwitchDoneRes },
        { 0x3E76317A, CallAction_Perform_Preset_Select_9 },
        { 0x3E7F9726, CallAction_gacSceneTransitionEnter },
        { 0x3FDD879F, CallAction_Perform_Service_Link_Dec },
        { 0x401674CD, CallAction_TunerViewReq_DAB_Quality_TestMode },
        { 0x41201119, CallAction_acStartAppPopupTimer },
        { 0x43BFBD71, CallAction_Perform_Preset_Select_1 },
        { 0x45779834, CallAction_Perform_Preset_Popup_5 },
        { 0x47BA8C2D, CallAction_Deactivate_DAB_TestMode },
        { 0x49989AB7, CallAction_FMMonitorMessageSharxHiCut },
        { 0x49B42EE1, CallAction_Perform_Preset_Store_8 },
        { 0x49F9D7B8, CallAction_TunerViewReq_DRM_AST },
        { 0x4A897BDB, CallAction_TunerViewReq_MASTER_GADGET_TUNER },
        { 0x4CD9A6F8, CallAction_Perform_Preset_Popup_4 },
        { 0x4EAD095F, CallAction_Perform_DAB_TM_Freq_Seek_Next },
        { 0x4EDD8DA2, CallAction_TunerViewReq_PlayView },
        { 0x4EFA7EE3, CallAction_acHdParameterUpdate },
        { 0x4FAA9899, CallAction_TunerViewReq_TMC_INFO },
        { 0x4FBF2A5F, CallAction_Perform_Next_fn_AM },
        { 0x51874FF9, CallAction_Update_AMPreset_Focused },
        { 0x524E6431, CallAction_Perform_RefTunerModule_Scene_Tuner_AM },
        { 0x5542A963, CallAction_Perform_Previous_fn_DAB },
        { 0x5644013C, CallAction_RequestBrowseList },
        { 0x573EB339, CallAction_gacContextSwitchFailedRes },
        { 0x57AA275B, CallAction_gacViewCreateWithoutLoadReq },
        { 0x5871A2DE, CallAction_Perform_BandSelect_Tuner3 },
        { 0x59148CB0, CallAction_FadeTransition },
        { 0x59C82D8E, CallAction_NextLevelTransition },
        { 0x59F03621, CallAction_gacChangeLanguageReq },
        { 0x5CC8F8D0, CallAction_Perform_Service_Linking_Dec },
        { 0x5D4614CD, CallAction_TunerViewReq_DAB_AST },
        { 0x5E6A0449, CallAction_Perform_Seek_Next_Repeat },
        { 0x5EEB4891, CallAction_Perform_Tuner_Src_Select },
        { 0x609EB5CE, CallAction_TunerViewReq_HDPARAMTUNING_TESTMODE },
        { 0x60E513C0, CallAction_gacTBTRetriggerAcousticOutput },
        { 0x60E926BB, CallAction_TunerTestModeViewReqMsg_Start },
        { 0x624351CB, CallAction_Perform_Preset_Popup_7 },
        { 0x629132A7, CallAction_gacPopupFilterDisableReq },
        { 0x6314FC1E, CallAction_Perform_TunerSelect_2 },
        { 0x6607DF2F, CallAction_Perform_Seek_Next_Jump },
        { 0x660F9332, CallAction_TunerViewReq_FM_MONITORTESTMODE },
        { 0x67B7653B, CallAction_gacDisplayFooterLineReq },
        { 0x694E5D29, CallAction_TunerViewReq_TMC_L },
        { 0x6986F397, CallAction_Perform_Preset_Popup_12 },
        { 0x6CBC9250, CallAction_Perform_AutoStore_DAB },
        { 0x6D230ED3, CallAction_Perform_Preset_Select_7 },
        { 0x6D3A31B2, CallAction_TunerViewReq_FM_INFO },
        { 0x6F8B5392, CallAction_Update_FMPreset_Focused },
        { 0x71D314BD, CallAction_Perform_DAB_TM_Freq_Seek_Previous },
        { 0x744079F2, CallAction_Perform_Stop_Next_Previous },
        { 0x7531D066, CallAction_Notify_Init_Finished },
        { 0x75E49D1D, CallAction_gacPerformListFocusLockDataResetUpd },
        { 0x76EE4CA4, CallAction_gacHideStatusLineMultiDisplayReq },
        { 0x7768235D, CallAction_Perform_Preset_Select_6 },
        { 0x78A08333, CallAction_TunerViewReq_AM_MONITORTESTMODE },
        { 0x791DF896, CallAction_acPerform_CloseAllDropdowns },
        { 0x791E7F81, CallAction_Perform_Preset_Popup_6 },
        { 0x7A39C2D9, CallAction_Perform_Previous_fn_FM },
        { 0x7B37E7E8, CallAction_TunerViewReq_DAB_Service_Info_TestMod },
        { 0x7B893A52, CallAction_TunerViewReq_DRM },
        { 0x7CB9B5FC, CallAction_TunerViewReq_AM },
        { 0x7CED9BD6, CallAction_Perform_Abort_Next_Previous_Icon_fn },
        { 0x7D7B49B4, CallAction_acFocusOnRightEncoderReqUpd },
        { 0x7EE4AB88, CallAction_gacPopupRestartTimerReq },
        { 0x7F2A7817, CallAction_Perform_Next_fn },
        { 0x80F298A7, CallAction_acDtmResetTransitions },
        { 0x825D899E, CallAction_TunerViewReq_FM_AST },
        { 0x82D15005, CallAction_PageFlipBackTransition },
        { 0x830F3C39, CallAction_Perform_SXMSettings_Context },
        { 0x84CBB2FA, CallAction_acHdOnOffUpdate },
        { 0x85A70E39, CallAction_Perform_Seek_Previous },
        { 0x86B8FF6C, CallAction_Perform_BandSelect_Tuner4 },
        { 0x881D2454, CallAction_gacPopupFilterAllEnableReqForDisplay },
        { 0x8AA5C874, CallAction_TunerViewReq_TT_MONITOR2 },
        { 0x8C3ED2E8, CallAction_Perform_AutoStore_FM },
        { 0x8DBF28A6, CallAction_Perform_Preset_Popup_9 },
        { 0x8FEBA5D7, CallAction_TunerViewReq_OPT_FMAM },
        { 0x908A55A1, CallAction_Perform_Preset_Select_8 },
        { 0x91BB105A, CallAction_gacLaunchBarDisplayReq },
        { 0x92E89951, CallAction_TunerViewReq_WEATHERBAND_MONITOR },
        { 0x931FBB71, CallAction_TunerViewReq_FM2 },
        { 0x93218F8C, CallAction_gacContextSwitchOutReq },
        { 0x93CBC317, CallAction_Perform_Preset_Store_7 },
        { 0x9413356E, CallAction_Perform_Preset_Popup_8 },
        { 0x948F96CC, CallAction_gacScrollListDown },
        { 0x95F0D5E3, CallAction_Perform_Previous_fn },
        { 0x96350312, CallAction_acSetGadgetSceenActiveStatus },
        { 0x96D3C730, CallAction_gacPopupSBCloseReqForMultiDisplay },
        { 0x972AD4A8, CallAction_TunerViewReq_OPT_DABPTY },
        { 0x99258E0B, CallAction_gacStatusBarDisplayReq },
        { 0x998AE63E, CallAction_TunerViewReq_TT_MONITOR3 },
        { 0x9F2A0D29, CallAction_TunerViewReq_TMC },
        { 0x9F87F08B, CallAction_acPostBeep },
        { 0x9FA26D73, CallAction_gacPopupFilterDisableReqForDisplay },
        { 0xA0A6F9FA, CallAction_gacViewHideAndDestroyReq },
        { 0xA13DE454, CallAction_Perform_Preset_Store_11 },
        { 0xA172CF4E, CallAction_Perform_Activate_Home_Source },
        { 0xA4355D05, CallAction_Perform_SXMMonitor_Context },
        { 0xA7B62A65, CallAction_gacPopupFilterPrioEnableReqForDisplay },
        { 0xA84DC23C, CallAction_gacHideFocusInViewReq },
        { 0xA9C7F42F, CallAction_gacHideStatusLineReq },
        { 0xAB49461E, CallAction_gacViewCreateAndShowReq },
        { 0xAD947FF9, CallAction_gacCurrentScreenDisplayReq },
        { 0xAE48BF55, CallAction_DualViewRightTransition },
        { 0xAED784B7, CallAction_DABStationBrowseList },
        { 0xAF6880B1, CallAction_Perform_Preset_Store_10 },
        { 0xAFB14254, CallAction_gacWaitAnimationStartReq },
        { 0xAFC09F4C, CallAction_TunerTestModeViewReqMsg_Stop },
        { 0xB09E64E0, CallAction_TunerViewReq_HDDTM_TESTMODE },
        { 0xB187E1CB, CallAction_Perform_Next_fn_FM },
        { 0xB3FA9C85, CallAction_Perform_Preset_Select_3 },
        { 0xB516D5D3, CallAction_Perform_Freq_Tuning_StepUp },
        { 0xB570FF65, CallAction_Perform_Next_fn_DAB },
        { 0xB68EC82A, CallAction_Preform_AFListExit },
        { 0xB75C40CD, CallAction_TunerViewReq_TMC_STN_INFO },
        { 0xB7F7CF94, CallAction_TunerViewReq_AM_TESTMODE },
        { 0xB9AE888E, CallAction_TunerViewReq_FM1 },
        { 0xBB441DAC, CallAction_gacRegisterForCloseOnTouchSession },
        { 0xBCD2ACD1, CallAction_TunerViewReq_TT_MONITOR1 },
        { 0xBDECE418, CallAction_gacSetApplicationMode },
        { 0xBDF5B1DE, CallAction_Perform_TunerSelect_1 },
        { 0xBE3DB10B, CallAction_Perform_Preset_Select_2 },
        { 0xBEF6021E, CallAction_acPerform_ToggleDropdown },
        { 0xBF4E7813, CallAction_Perform_MirrorLinkChange },
        { 0xC0200CA1, CallAction_TunerViewReq_OPT_DRMPTY },
        { 0xC0B8F68C, CallAction_acHdParameterTuningUpdate },
        { 0xC303080F, CallAction_Perform_Preset_Select_11 },
        { 0xC37EE8E9, CallAction_gacPopupFilterPrioEnableReq },
        { 0xC3AF4EFC, CallAction_Activate_DAB_TestMode },
        { 0xC495DF99, CallAction_TunerViewReq_DAB_SETUP_MONITOR },
        { 0xC51CE603, CallAction_gacViewCreateAllReq },
        { 0xC5DD5738, CallAction_gacProfileChange },
        { 0xC65CAED0, CallAction_gacSpellerBbehaviorReq },
        { 0xC6E58994, CallAction_PreformTunerAppActReqMsg },
        { 0xC71E1302, CallAction_TunerViewReq_DRMSetup_Monitor },
        { 0xC8539D8B, CallAction_gacSceneTransitionLeave },
        { 0xC8EA8B79, CallAction_acRestartAppPopupTimer },
        { 0xC9B447F8, CallAction_Perform_Preset_Select_5 },
        { 0xC9EB88D6, CallAction_gacViewClearReq },
        { 0xCB8DBDEF, CallAction_gacHideFooterLineReq },
        { 0xCCF0B5DF, CallAction_Perform_BTPhoneMsgChange },
        { 0xCCF1A98B, CallAction_PreviousLevelTransition },
        { 0xCDAE1317, CallAction_Perform_HomeScreenChange },
        { 0xD0E9F1AA, CallAction_Perform_CannotStore_Popup },
        { 0xD1AA4F4D, CallAction_ZoomOutTransition },
        { 0xD41A9C20, CallAction_TunerViewReq_DRM_SL },
        { 0xD5F685D5, CallAction_PageFlipFrontTransition },
        { 0xD63C2357, CallAction_gacViewAsyncLoadReq },
        { 0xD848B1D0, CallAction_Perform_NaviChange },
        { 0xD85027C7, CallAction_TunerViewReq_SourceSelection },
        { 0xD908CD8C, CallAction_Perform_Preset_Store_1 },
        { 0xD98C6419, CallAction_gacViewActivateWithoutRenderingReq },
        { 0xDA6FAF3C, CallAction_Perform_CLevel_Inc },
        { 0xDB665FD5, CallAction_acPerform_CloseDropdown },
        { 0xDD4D179D, CallAction_gacHideFooterLineMultiDisplayReq },
        { 0xDD71F921, CallAction_gacPerformListBtnRightEncoderChangeUpd },
        { 0xDEF8F609, CallAction_Perform_Service_Linking_Inc },
        { 0xE0904D3B, CallAction_Update_Preset_Focused },
        { 0xE0EF3086, CallAction_gacPopupCreateAndSBShowReqForMultiDisplay },
        { 0xE0F040AD, CallAction_acHdAudioProgSelect },
        { 0xE1D07830, CallAction_Perform_Preset_Select_4 },
        { 0xE26F8FFD, CallAction_TunerViewReq_DAB_Monitor },
        { 0xE2DBFB05, CallAction_TunerViewReq_Previous },
        { 0xE3E33CA5, CallAction_Perform_DAB_TM_Ensemble_Seek_Next },
        { 0xE44B693A, CallAction_Perform_Preset_Popup_11 },
        { 0xE500B03C, CallAction_gacContextSwitchBackRes },
        { 0xE8C08777, CallAction_Perform_TunerSelect_4 },
        { 0xE94E6E17, CallAction_Perform_Preset_Store_2 },
        { 0xE95FE354, CallAction_TunerViewReq_DAB_Expert_API_TestMode },
        { 0xEA36F64D, CallAction_Perform_Preset_Store_12 },
        { 0xEA4E5859, CallAction_acDtmSplitAudio },
        { 0xEB17228B, CallAction_Perform_Service_Link_Inc },
        { 0xEB51CB7E, CallAction_gacPopupSBCloseReq },
        { 0xEB65F4C4, CallAction_Perform_Seek_Previous_Jump },
        { 0xEB770027, CallAction_StationBrowseList },
        { 0xEBF5488A, CallAction_Perform_TestmodeBlock_Context },
        { 0xEC64DB0F, CallAction_gacScrollPageDown },
        { 0xEE11F57F, CallAction_gacScrollPageUp },
        { 0xEE131A83, CallAction_gacNavTBTSwipe },
        { 0xF0A1D4B5, CallAction_gacCheckToClosePopup },
        { 0xF17E085D, CallAction_gacPopupCreateAndSBShowReq },
        { 0xF2794BD6, CallAction_Perform_Previous_fn_AM },
        { 0xF68E0DBF, CallAction_Perform_Preset_Popup_10 },
        { 0xF6C7B8B4, CallAction_TunerViewReq_FM_SL },
        { 0xF8B07369, CallAction_Perform_Preset_Select_10 },
        { 0xFACF47DC, CallAction_Perform_Tuner_fn },
        { 0xFB2011BA, CallAction_Perform_Preset_Store_4 },
        { 0xFE66F876, CallAction_TunerViewReq_WEATHERBAND },
    };
    ::FeatStd::UInt32 hashId = ::Courier::Identifier::CalcHash(actionName);
    const ActionMapping* action = ::Courier::BinarySearch(hashId, actions, 248, &ActionMappingCmp);
    if (action && (hashId == action->mHashId)) {
        return action->mActionCallHandler(parameters, response);
    }
    return false;
}
#endif
namespace Courier {
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CameraGroupReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CameraGroupResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ActivationReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ActivationResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewRenderingReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewRenderingResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewMessagingReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewMessagingResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CameraGroupActivationReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CameraGroupActivationResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TryLoadReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::LoadReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DelayedUnloadMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::LoadResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TryAsyncLoadReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::AsyncLoadReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::AsyncLoadResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::AsyncLoadIndMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CameraGroupLoadReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CameraGroupLoadResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ThemeReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ThemeResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::AnimationReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::AnimationResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::AnimationIndMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::SetPropertyReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::SetPropertyResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::SetFocusReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::SetFocusResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::LostFocusIndMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TransitionReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TransitionResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TransitionIndMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::InvalidateReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::RenderReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::RenderResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::LayerReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::LayerResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ParentViewActivateEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ParentViewRenderingEnabledEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ParentViewInitContentEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ParentViewLoadEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::FocusEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::LostFocusEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TransitionStartedEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TransitionFinishedEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::SetCultureReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::SetCultureResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CultureChangeIndMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewPlaceholderReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewPlaceholderResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewMsgBase, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::WidgetMsgBase, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::Internal::DataBindingMsgBase, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::Internal::BindingSourceBaseMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::Internal::ReleaseDataItemMsgBase, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::Internal::DataItemMsgBase, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::Internal::ListEventMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::input::TouchAbort, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::input::TouchSessionStartEvent, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::input::TouchSessionStopEvent, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::IdUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::ConsumerMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::ProviderUpdateIndicationMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::TouchForwardReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::TouchAbortReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::ActivateImageProviderReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::ExternalImageProviderReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::ExternalImageProviderGroupReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::DrmAllocationStatusMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::DrmGarbageCollectorReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::DrmGCTimeoutMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::PositionBaseMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::SlaveSurfaceRepositionBaseMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::DirectTextureConsumerContentIndicationMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::PositionInfoReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::PositionInfoResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::SlaveSurfaceRepositionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::SlaveSurfaceRepositionResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::WidgetCheckReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::NotifierMessage, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TimerExpiredMsg, 15);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::GuiStartupFinishedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CreateNewDestroyOld, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EnterKeyStatusChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusControlReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusGroupReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::UpdateFocusSessionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RefreshFocusSessionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusSessionFinishedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RegisterFocusableWidgetsReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::JoystickStatusChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusChangedReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SurfaceStateChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::LayerStateChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SBPopupTimerExpiryUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::HMISubStateChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::QueryTraceInfoReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FollowUpActionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::WidgetPropertySetterReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SimTouchReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CloseOnTouchReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RegisterForCloseOnTouchSessionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SetClosePopupExternalTouchMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ClosePopupOnExternalTouchReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PlayBeepReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ChangeHmiSubStateReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EvalSubSurfaceReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ExecuteSubSurfaceReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ExecuteSubSurfaceResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ExtendedViewReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::LocalizationReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DecrementActiveAnimationCountMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PopupReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SetApplicationAsMandatoryReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ApplicationStateUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SubSurfaceUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ApplicationRenderedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ApplicationSwitchCompleteUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SubSurfaceSwitchCompleteUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SbAnimationStateChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SbCurrentStatusUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PopupDisplayStatusUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ShowHMISubSurfaceReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StartLayerAnimationReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PopupFilterPrioEnableReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PopupFilterAllEnableReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PopupFilterDisableReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::MultiDisplayPopupFilterReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RestartMenuTimeoutTimerReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RenderingCompleteMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CreateTextMetaDataCollectionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DumpScreenReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TraverseViewsReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropCheckSourceReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropCheckSourceResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropCheckDestinationReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropCheckDestinationResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropCompleteReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropCompleteResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropAbortReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropStatusUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ProfileSwitchMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TransitionMediatorOnDataCompleteMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ManualSceneActionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EglWaitNativeReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EglWaitNativeResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ResetGadgetCacheReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::AttachedAnimationReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::SenderMessage, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::TouchUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::AnimationWidgetReqMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::AnimationWidgetIndMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ButtonListItemUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ButtonReactionMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ButtonSlideMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ButtonGroupReqMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ColorBarDataUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::combobox::ComboBoxUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::combobox::ComboBoxReqMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DropdownCurrentValueChangedMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DropdownChangeMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::editfield::EditFieldUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::editfield::EditFieldHightlightReqMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gesture::GestureMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gesture::TapGestureMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gesture::DragGestureMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gesture::SwipeGestureMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gesture::PinchSpreadGestureMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gesture::RotateGestureMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gizmo::GizmoUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListDateProviderReqMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListDateProviderResMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListDataProviderUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListChangeMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListAnimatedChangeReqMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListChangedUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListMovementFinishedUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListStatusUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListVisibiltyUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListFocusChangeReqMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SliderCurrentValueChangedMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::LockOutMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListItemExpandReqMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListItemExpandEndUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListCustomAnimationReqMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListCustomAnimationResMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListCustomAnimationIndMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListMorphReqMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListContentUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListVisualContentUpdateMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListCacheReqMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::pageedit::PageEditUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PanelSlideReqMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PanelStateMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SpellerKeyPressed, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SpellerCtrlKeyPressed, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SpellerStatusChangedUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SubSpellerStatusUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TimerWidgetExpiryMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::HWR_CandidateUpdate, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::HWR_TextWidgetUpdate, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ScrollableTextUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActiveSurfaceViewUpdateMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ChangeLanguageReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StartPopupTimerReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StopPopupTimerReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RestartPopupTimerReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ExpiredPopupTimerResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListFocusResetReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EnableCameraRenderingReq, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SwitchApplicationStateReq, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DisableCameraRenderingReq, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DummyMess, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivityMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivateApplicationMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DeactivateApplicationMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::HardKeyPressNotificationMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusOnRightEncoderReqUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StoreActiveGadgetReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CheckToClosePopupMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ContextSwitchOutReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ContextSwitchInResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CurrentScreenDisplayReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::LaunchBarDisplayReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::NavTBTSwipeReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListItemRightEncoderChangeUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListFocusLockDataResetReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListFocusScrollReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SetApplicationModeReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SpellerBbehaviorReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StatusBarDisplayReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TBTRetriggerAcousticMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StartGadgetAnimationReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ControlPanelButtonPressInfo, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::AppStatusUpdateMsg, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CannotStorePopupMsg, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Popup_PFO_TA, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Popup_PFO_PTY31, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Popup_PFO_TAclose, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Popup_PFO_PTY31close, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Popup_PFO_AST, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Popup_PFO_ASTClose, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Popup_PFO_WB, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Popup_PFO_WBclose, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TuneFrequencyReqMsg, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SeekReqMsg, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ScanReqMsg, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::AutoStoreReqMsg, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SourceSelReqMsg, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TunerViewReqMsg, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Tuner_TestmodeViewReqMsg, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DABServiceReqMsg, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DABServiceLinkReqMsg, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DABCLevelReqMsg, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TestModeDABQuality, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Slider_TunerFrequencyMsg, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::BTPhoneMsg, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::NaviMsg, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::MirrorLinkMsg, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TunerViewMsg, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EnableView, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DisableView, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TunerAppActReqMsg, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RDSSupport, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TunerBLMsg, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TunerPLMsg, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EnableTESTModeView, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DABTMSeekReqMsg, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::UpdateTunerStatusMsg, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivateTunerMsg, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Update_ProgressBarMsg, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TripleTunerMonitorDataSet1, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TripleTunerMonitorDataSet2, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TripleTunerMonitorDataSet3, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TunerReqMsg, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DABTestModeActiveServiceInfo, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DABTestModeActiveEnsembleInfo, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DABTestModeTunerStatusInfo, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DABTestModeBGTestmodeInfo, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DABTestModeGTestmodeInfo, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DABTestModeActiveServiceInfo1, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DABTestModeAnnoStatus, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DABTestModeActiveCompInfo, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DABTestModeGAvailabilty, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DABTestModeServiceFollowingStatus, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DABTestModeTASource, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TunerEngineeringModeMsg2, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DRMEngineeringModeMsg, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DRMEngineeringModeMsg_1, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DRMEngineeringModeMsg_2, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::AFListExitMsg, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DABServiceLinkingMsg, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DABConcealmentLevelMsg, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::AntennaStatus, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::BandscanStatus, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::UpdateScanMsg, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::UpdateAutoStoreMsg, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::BrowseListReqMsg, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StationListReqMsg, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DABStationListReqMsg, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::BrowseListRespMsg, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::BrowseListItemSelReq, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PopulateScrollListWindowRequest, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::BrowseListExitMsg, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActiveLineIndexInfoMsg, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DABChannelInfoMsg, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TmcInfoData, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TmcStnInfoData, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SwitchApplicationReq, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FMMonitorMessage, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::NextSelectMsg_AM, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PreviousSelectMsg_AM, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::NextSelectMsg_DAB, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PreviousSelectMsg_DAB, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::NextSelectMsg_FM, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Tuner_WxBLMsg, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PreviousSelectMsg_FM, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::NextIconSelectMsg, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PreviousIconSelectMsg, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::AbortNextPreviousIcon, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ButtonMainSrcActivate, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::HdOnOffReqMsg, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ChannelInfoMsg, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DtmSplitAudioReqMsg, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DtmResetTransitionsReqMsg, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::HdParameterTuningMsg, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::HdParameterListUpdate, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::HdAudioProgSelectMsg, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::HdListAccessUpdateMsg, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ContextToMaster, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CloseNextPrev, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SXMContextMsg, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TestmodeBlockContextMsg, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SXMSettingsTestmodeContextMsg, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SXMMonitorContextMsg, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FMAMBackContextMsg, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ViewPreviousMsg, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActiveRenderedView, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::onHardKeyPress, 50);
} // namespace Courier

// ------------------------------------------------------------------------
CheckBoxListItemDataBindingSource::CheckBoxListItemDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::CheckBoxListItemItem)
{
}

// ------------------------------------------------------------------------
StationInfoSourceDataBindingSource::StationInfoSourceDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::StationInfoSourceItem)
{
}

// ------------------------------------------------------------------------
HomeScreenInfoDataBindingSource::HomeScreenInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::HomeScreenInfoItem)
{
}

// ------------------------------------------------------------------------
RadioBandInfoDataBindingSource::RadioBandInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::RadioBandInfoItem)
{
}

// ------------------------------------------------------------------------
FMStationListDataBindingSource::FMStationListDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::FMStationListItem)
{
}

// ------------------------------------------------------------------------
RDSOptionsDataBindingSource::RDSOptionsDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::RDSOptionsItem)
{
}

// ------------------------------------------------------------------------
PresetInfoWBDataBindingSource::PresetInfoWBDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::PresetInfoWBItem)
{
}

// ------------------------------------------------------------------------
WBPresetInfoDataBindingSource::WBPresetInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::WBPresetInfoItem)
{
}

// ------------------------------------------------------------------------
PresetInfoFM1DataBindingSource::PresetInfoFM1DataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::PresetInfoFM1Item)
{
}

// ------------------------------------------------------------------------
PresetInfoFM2DataBindingSource::PresetInfoFM2DataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::PresetInfoFM2Item)
{
}

// ------------------------------------------------------------------------
PresetInfoFMASTDataBindingSource::PresetInfoFMASTDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::PresetInfoFMASTItem)
{
}

// ------------------------------------------------------------------------
PresetInfoAMDataBindingSource::PresetInfoAMDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::PresetInfoAMItem)
{
}

// ------------------------------------------------------------------------
PresetInfoAMASTDataBindingSource::PresetInfoAMASTDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::PresetInfoAMASTItem)
{
}

// ------------------------------------------------------------------------
PresetInfoDABDataBindingSource::PresetInfoDABDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::PresetInfoDABItem)
{
}

// ------------------------------------------------------------------------
PresetInfoDABASTDataBindingSource::PresetInfoDABASTDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::PresetInfoDABASTItem)
{
}

// ------------------------------------------------------------------------
PresetInfoDRMDataBindingSource::PresetInfoDRMDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::PresetInfoDRMItem)
{
}

// ------------------------------------------------------------------------
PresetInfoDRMASTDataBindingSource::PresetInfoDRMASTDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::PresetInfoDRMASTItem)
{
}

// ------------------------------------------------------------------------
EngineeringInfoDataBindingSource::EngineeringInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::EngineeringInfoItem)
{
}

// ------------------------------------------------------------------------
LayerNextPresets_FMDataBindingSource::LayerNextPresets_FMDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::LayerNextPresets_FMItem)
{
}

// ------------------------------------------------------------------------
LayerNextPresets_AMDataBindingSource::LayerNextPresets_AMDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::LayerNextPresets_AMItem)
{
}

// ------------------------------------------------------------------------
LayerNextPresets_DABDataBindingSource::LayerNextPresets_DABDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::LayerNextPresets_DABItem)
{
}

// ------------------------------------------------------------------------
EngineeringInfo1DataBindingSource::EngineeringInfo1DataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::EngineeringInfo1Item)
{
}

// ------------------------------------------------------------------------
EngineeringInfo2DataBindingSource::EngineeringInfo2DataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::EngineeringInfo2Item)
{
}

// ------------------------------------------------------------------------
EngineeringInfoDRMDataBindingSource::EngineeringInfoDRMDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::EngineeringInfoDRMItem)
{
}

// ------------------------------------------------------------------------
Scan_ASTDataBindingSource::Scan_ASTDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::Scan_ASTItem)
{
}

// ------------------------------------------------------------------------
Scan_StatusDataBindingSource::Scan_StatusDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::Scan_StatusItem)
{
}

// ------------------------------------------------------------------------
Source_SlectionDataBindingSource::Source_SlectionDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::Source_SlectionItem)
{
}

// ------------------------------------------------------------------------
Preset_PopupDataBindingSource::Preset_PopupDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::Preset_PopupItem)
{
}

// ------------------------------------------------------------------------
PgBar_timerDataBindingSource::PgBar_timerDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::PgBar_timerItem)
{
}

// ------------------------------------------------------------------------
tuningScale_SliderMarkerPositionDataBindingSource::tuningScale_SliderMarkerPositionDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::tuningScale_SliderMarkerPositionItem)
{
}

// ------------------------------------------------------------------------
tuningSliderDataBindingSource::tuningSliderDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::tuningSliderItem)
{
}

// ------------------------------------------------------------------------
TunerOptionsDataBindingSource::TunerOptionsDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::TunerOptionsItem)
{
}

// ------------------------------------------------------------------------
DABOptionsDataBindingSource::DABOptionsDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::DABOptionsItem)
{
}

// ------------------------------------------------------------------------
DRMOptionsDataBindingSource::DRMOptionsDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::DRMOptionsItem)
{
}

// ------------------------------------------------------------------------
MenuSelectionDataBindingSource::MenuSelectionDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::MenuSelectionItem)
{
}

// ------------------------------------------------------------------------
Menu_NumOptionsDataBindingSource::Menu_NumOptionsDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::Menu_NumOptionsItem)
{
}

// ------------------------------------------------------------------------
AppFlyInDataBindingSource::AppFlyInDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::AppFlyInItem)
{
}

// ------------------------------------------------------------------------
BrowseListPointerDataBindingSource::BrowseListPointerDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::BrowseListPointerItem)
{
}

// ------------------------------------------------------------------------
BrowseListSizeDataBindingSource::BrowseListSizeDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::BrowseListSizeItem)
{
}

// ------------------------------------------------------------------------
BrowseListSelectedLineDataBindingSource::BrowseListSelectedLineDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::BrowseListSelectedLineItem)
{
}

// ------------------------------------------------------------------------
DABChannelInfoDataBindingSource::DABChannelInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::DABChannelInfoItem)
{
}

// ------------------------------------------------------------------------
ActiveBankInfoDataBindingSource::ActiveBankInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::ActiveBankInfoItem)
{
}

// ------------------------------------------------------------------------
ActiveSourceInfoDataBindingSource::ActiveSourceInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::ActiveSourceInfoItem)
{
}

// ------------------------------------------------------------------------
VariantInfoDataBindingSource::VariantInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::VariantInfoItem)
{
}

// ------------------------------------------------------------------------
TAInfoDataBindingSource::TAInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::TAInfoItem)
{
}

// ------------------------------------------------------------------------
DABPresetInfoDataBindingSource::DABPresetInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::DABPresetInfoItem)
{
}

// ------------------------------------------------------------------------
FMAMPresetInfoDataBindingSource::FMAMPresetInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::FMAMPresetInfoItem)
{
}

// ------------------------------------------------------------------------
AMPresetInfoDataBindingSource::AMPresetInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::AMPresetInfoItem)
{
}

// ------------------------------------------------------------------------
Tuner1DataBindingSource::Tuner1DataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::Tuner1Item)
{
}

// ------------------------------------------------------------------------
Tuner2DataBindingSource::Tuner2DataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::Tuner2Item)
{
}

// ------------------------------------------------------------------------
Tuner3DataBindingSource::Tuner3DataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::Tuner3Item)
{
}

// ------------------------------------------------------------------------
Tuner4DataBindingSource::Tuner4DataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::Tuner4Item)
{
}

// ------------------------------------------------------------------------
TunerSource_BandDataBindingSource::TunerSource_BandDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::TunerSource_BandItem)
{
}

// ------------------------------------------------------------------------
DAB_Setup_ScreenDataBindingSource::DAB_Setup_ScreenDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::DAB_Setup_ScreenItem)
{
}

// ------------------------------------------------------------------------
DAB_Test_ModeDataBindingSource::DAB_Test_ModeDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::DAB_Test_ModeItem)
{
}

// ------------------------------------------------------------------------
DAB_Setup_Screen_ActiveTuner_InfoDataBindingSource::DAB_Setup_Screen_ActiveTuner_InfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::DAB_Setup_Screen_ActiveTuner_InfoItem)
{
}

// ------------------------------------------------------------------------
DABTestModeEnsembleInfoDataBindingSource::DABTestModeEnsembleInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::DABTestModeEnsembleInfoItem)
{
}

// ------------------------------------------------------------------------
DABGTestModeInfoDataBindingSource::DABGTestModeInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::DABGTestModeInfoItem)
{
}

// ------------------------------------------------------------------------
DABGTestModeAnnoStatusInfoDataBindingSource::DABGTestModeAnnoStatusInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::DABGTestModeAnnoStatusInfoItem)
{
}

// ------------------------------------------------------------------------
DABGTestModeActiveCompDataBindingSource::DABGTestModeActiveCompDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::DABGTestModeActiveCompItem)
{
}

// ------------------------------------------------------------------------
DABTestModeGAvailabiltyInfoDataBindingSource::DABTestModeGAvailabiltyInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::DABTestModeGAvailabiltyInfoItem)
{
}

// ------------------------------------------------------------------------
DABTestModeServiceFollowingInfoDataBindingSource::DABTestModeServiceFollowingInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::DABTestModeServiceFollowingInfoItem)
{
}

// ------------------------------------------------------------------------
TmcInformationDataDataBindingSource::TmcInformationDataDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::TmcInformationDataItem)
{
}

// ------------------------------------------------------------------------
TmcStationInfoDataDataBindingSource::TmcStationInfoDataDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::TmcStationInfoDataItem)
{
}

// ------------------------------------------------------------------------
TestModeAvailabilityInfoDataBindingSource::TestModeAvailabilityInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::TestModeAvailabilityInfoItem)
{
}

// ------------------------------------------------------------------------
FMSetupMenuInfoDataBindingSource::FMSetupMenuInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::FMSetupMenuInfoItem)
{
}

// ------------------------------------------------------------------------
NextPrevious_Status_FMDataBindingSource::NextPrevious_Status_FMDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::NextPrevious_Status_FMItem)
{
}

// ------------------------------------------------------------------------
NextPrevious_Status_AMDataBindingSource::NextPrevious_Status_AMDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::NextPrevious_Status_AMItem)
{
}

// ------------------------------------------------------------------------
NextPrevious_Status_DABDataBindingSource::NextPrevious_Status_DABDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::NextPrevious_Status_DABItem)
{
}

// ------------------------------------------------------------------------
SearchNextPrevious_IconActiveDataBindingSource::SearchNextPrevious_IconActiveDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SearchNextPrevious_IconActiveItem)
{
}

// ------------------------------------------------------------------------
AMFMLogoImageDataBindingSource::AMFMLogoImageDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::AMFMLogoImageItem)
{
}

// ------------------------------------------------------------------------
ChannelInfoDataBindingSource::ChannelInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::ChannelInfoItem)
{
}

// ------------------------------------------------------------------------
FmHdLogoDataBindingSource::FmHdLogoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::FmHdLogoItem)
{
}

// ------------------------------------------------------------------------
AmHdLogoDataBindingSource::AmHdLogoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::AmHdLogoItem)
{
}

// ------------------------------------------------------------------------
HDButtonVisibilityDataBindingSource::HDButtonVisibilityDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::HDButtonVisibilityItem)
{
}

// ------------------------------------------------------------------------
AmHdOnOffDataBindingSource::AmHdOnOffDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::AmHdOnOffItem)
{
}

// ------------------------------------------------------------------------
FmHdOnOffDataBindingSource::FmHdOnOffDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::FmHdOnOffItem)
{
}

// ------------------------------------------------------------------------
HDProgramListVisibilityDataBindingSource::HDProgramListVisibilityDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::HDProgramListVisibilityItem)
{
}

// ------------------------------------------------------------------------
HDAudioMPSDataBindingSource::HDAudioMPSDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::HDAudioMPSItem)
{
}

// ------------------------------------------------------------------------
HDAudioSPS1DataBindingSource::HDAudioSPS1DataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::HDAudioSPS1Item)
{
}

// ------------------------------------------------------------------------
HDAudioSPS2DataBindingSource::HDAudioSPS2DataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::HDAudioSPS2Item)
{
}

// ------------------------------------------------------------------------
HDAudioSPS3DataBindingSource::HDAudioSPS3DataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::HDAudioSPS3Item)
{
}

// ------------------------------------------------------------------------
HDAudioSPS4DataBindingSource::HDAudioSPS4DataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::HDAudioSPS4Item)
{
}

// ------------------------------------------------------------------------
HDAudioSPS5DataBindingSource::HDAudioSPS5DataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::HDAudioSPS5Item)
{
}

// ------------------------------------------------------------------------
HDAudioSPS6DataBindingSource::HDAudioSPS6DataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::HDAudioSPS6Item)
{
}

// ------------------------------------------------------------------------
HDAudioSPS7DataBindingSource::HDAudioSPS7DataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::HDAudioSPS7Item)
{
}

// ------------------------------------------------------------------------
HDIconPreset1DataBindingSource::HDIconPreset1DataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::HDIconPreset1Item)
{
}

// ------------------------------------------------------------------------
HDIconPreset2DataBindingSource::HDIconPreset2DataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::HDIconPreset2Item)
{
}

// ------------------------------------------------------------------------
HDIconPreset3DataBindingSource::HDIconPreset3DataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::HDIconPreset3Item)
{
}

// ------------------------------------------------------------------------
HDIconPreset4DataBindingSource::HDIconPreset4DataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::HDIconPreset4Item)
{
}

// ------------------------------------------------------------------------
HDIconPreset5DataBindingSource::HDIconPreset5DataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::HDIconPreset5Item)
{
}

// ------------------------------------------------------------------------
HDIconPreset6DataBindingSource::HDIconPreset6DataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::HDIconPreset6Item)
{
}

// ------------------------------------------------------------------------
HDIconPreset7DataBindingSource::HDIconPreset7DataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::HDIconPreset7Item)
{
}

// ------------------------------------------------------------------------
HDIconPreset8DataBindingSource::HDIconPreset8DataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::HDIconPreset8Item)
{
}

// ------------------------------------------------------------------------
HDIconPreset9DataBindingSource::HDIconPreset9DataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::HDIconPreset9Item)
{
}

// ------------------------------------------------------------------------
HDIconPreset10DataBindingSource::HDIconPreset10DataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::HDIconPreset10Item)
{
}

// ------------------------------------------------------------------------
HDIconPreset11DataBindingSource::HDIconPreset11DataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::HDIconPreset11Item)
{
}

// ------------------------------------------------------------------------
HDIconPreset12DataBindingSource::HDIconPreset12DataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::HDIconPreset12Item)
{
}

// ------------------------------------------------------------------------
DtmHDDataBindingSource::DtmHDDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::DtmHDItem)
{
}

// ------------------------------------------------------------------------
HDParamTuningIconDataBindingSource::HDParamTuningIconDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::HDParamTuningIconItem)
{
}

// ------------------------------------------------------------------------
TMHDAudioMPSDataBindingSource::TMHDAudioMPSDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::TMHDAudioMPSItem)
{
}

// ------------------------------------------------------------------------
TMHDAudioSPS1DataBindingSource::TMHDAudioSPS1DataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::TMHDAudioSPS1Item)
{
}

// ------------------------------------------------------------------------
TMHDAudioSPS2DataBindingSource::TMHDAudioSPS2DataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::TMHDAudioSPS2Item)
{
}

// ------------------------------------------------------------------------
TMHDAudioSPS3DataBindingSource::TMHDAudioSPS3DataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::TMHDAudioSPS3Item)
{
}

// ------------------------------------------------------------------------
TMHDAudioSPS4DataBindingSource::TMHDAudioSPS4DataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::TMHDAudioSPS4Item)
{
}

// ------------------------------------------------------------------------
TMHDAudioSPS5DataBindingSource::TMHDAudioSPS5DataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::TMHDAudioSPS5Item)
{
}

// ------------------------------------------------------------------------
TMHDAudioSPS6DataBindingSource::TMHDAudioSPS6DataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::TMHDAudioSPS6Item)
{
}

// ------------------------------------------------------------------------
TMHDAudioSPS7DataBindingSource::TMHDAudioSPS7DataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::TMHDAudioSPS7Item)
{
}

// ------------------------------------------------------------------------
RdsRadioTextDataBindingSource::RdsRadioTextDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::RdsRadioTextItem)
{
}

// ------------------------------------------------------------------------
HomeScreenFmHdLogoDataBindingSource::HomeScreenFmHdLogoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::HomeScreenFmHdLogoItem)
{
}

// ------------------------------------------------------------------------
HomeScreenAmHdLogoDataBindingSource::HomeScreenAmHdLogoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::HomeScreenAmHdLogoItem)
{
}

// ------------------------------------------------------------------------
SPIVisibilityTunerDataBindingSource::SPIVisibilityTunerDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SPIVisibilityTunerItem)
{
}

// ------------------------------------------------------------------------
ListScrollBarInfoDataBindingSource::ListScrollBarInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::ListScrollBarInfoItem)
{
}

typedef void InvalidData;
struct InvalidDataBindingSource {
    static const ::FeatStd::UInt32 cHierarchyNodeCount = 1;
};

// table of shared DataItemDescriptor
static const ::Courier::Internal::DataBinding::DataItemDescriptor gItemDesc[cDataItemDescriptorCount] = {
    {   // 0 - ::InvalidData
        COURIER_DATA_ITEM_TYPE_ID(::InvalidData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 1 - ::CheckBoxListItemData
        COURIER_DATA_ITEM_TYPE_ID(::CheckBoxListItemData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 2 - ::CheckBoxListItemData::mListItemName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::CheckBoxListItemData, mListItemName)
    },
    {   // 3 - ::CheckBoxListItemData::mToggleIconSwitchIndex
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt8),
        COURIER_ITEM_MEMBER(::CheckBoxListItemData, mToggleIconSwitchIndex)
    },
    {   // 4 - ::StationInfoSourceData
        COURIER_DATA_ITEM_TYPE_ID(::StationInfoSourceData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 5 - ::StationInfoSourceData::mPSName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::StationInfoSourceData, mPSName)
    },
    {   // 6 - ::StationInfoSourceData::mAMPSName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::StationInfoSourceData, mAMPSName)
    },
    {   // 7 - ::StationInfoSourceData::mAMFrequency
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::StationInfoSourceData, mAMFrequency)
    },
    {   // 8 - ::StationInfoSourceData::mFMFrequency
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::StationInfoSourceData, mFMFrequency)
    },
    {   // 9 - ::StationInfoSourceData::mDRMFrequency
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::StationInfoSourceData, mDRMFrequency)
    },
    {   // 10 - ::StationInfoSourceData::mRadioText
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::StationInfoSourceData, mRadioText)
    },
    {   // 11 - ::StationInfoSourceData::mUnit
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::StationInfoSourceData, mUnit)
    },
    {   // 12 - ::StationInfoSourceData::mViewName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::StationInfoSourceData, mViewName)
    },
    {   // 13 - ::StationInfoSourceData::mTPInfo
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::StationInfoSourceData, mTPInfo)
    },
    {   // 14 - ::StationInfoSourceData::mDabTPInfo
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::StationInfoSourceData, mDabTPInfo)
    },
    {   // 15 - ::StationInfoSourceData::mCurrentStationTPInfo
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::StationInfoSourceData, mCurrentStationTPInfo)
    },
    {   // 16 - ::StationInfoSourceData::mVisible_Txt_Wgt_RDS
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::StationInfoSourceData, mVisible_Txt_Wgt_RDS)
    },
    {   // 17 - ::StationInfoSourceData::mVisible_Txt_Wgt_NoRDS
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::StationInfoSourceData, mVisible_Txt_Wgt_NoRDS)
    },
    {   // 18 - ::StationInfoSourceData::mVisible_Txt_Wgt_Navi
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::StationInfoSourceData, mVisible_Txt_Wgt_Navi)
    },
    {   // 19 - ::StationInfoSourceData::mVisible_Txt_Wgt_EU
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::StationInfoSourceData, mVisible_Txt_Wgt_EU)
    },
    {   // 20 - ::StationInfoSourceData::mVariant_Type
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::StationInfoSourceData, mVariant_Type)
    },
    {   // 21 - ::StationInfoSourceData::mVariant_Type_NonEU
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::StationInfoSourceData, mVariant_Type_NonEU)
    },
    {   // 22 - ::StationInfoSourceData::mTA_SourcePSName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::StationInfoSourceData, mTA_SourcePSName)
    },
    {   // 23 - ::StationInfoSourceData::mDRM_ServiceLabel
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::StationInfoSourceData, mDRM_ServiceLabel)
    },
    {   // 24 - ::StationInfoSourceData::mDRMStatus
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::StationInfoSourceData, mDRMStatus)
    },
    {   // 25 - ::StationInfoSourceData::mVisible_DRMService
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::StationInfoSourceData, mVisible_DRMService)
    },
    {   // 26 - ::StationInfoSourceData::mVisible_DRMRadioText
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::StationInfoSourceData, mVisible_DRMRadioText)
    },
    {   // 27 - ::StationInfoSourceData::mVisible_DRMFrequency
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::StationInfoSourceData, mVisible_DRMFrequency)
    },
    {   // 28 - ::StationInfoSourceData::mDRMPTY
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::StationInfoSourceData, mDRMPTY)
    },
    {   // 29 - ::StationInfoSourceData::mIcon_station
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::StationInfoSourceData, mIcon_station)
    },
    {   // 30 - ::StationInfoSourceData::mDAB_Icon_station
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt32),
        COURIER_ITEM_MEMBER(::StationInfoSourceData, mDAB_Icon_station)
    },
    {   // 31 - ::HomeScreenInfoData
        COURIER_DATA_ITEM_TYPE_ID(::HomeScreenInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 32 - ::HomeScreenInfoData::mHomeScreen_ActiveIconIndex
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt32),
        COURIER_ITEM_MEMBER(::HomeScreenInfoData, mHomeScreen_ActiveIconIndex)
    },
    {   // 33 - ::HomeScreenInfoData::mHomeScreen_ActiveSourceText
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::HomeScreenInfoData, mHomeScreen_ActiveSourceText)
    },
    {   // 34 - ::HomeScreenInfoData::mHomeScreen_DABServiceName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::HomeScreenInfoData, mHomeScreen_DABServiceName)
    },
    {   // 35 - ::HomeScreenInfoData::mHomeScreen_ScanInvisible
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::HomeScreenInfoData, mHomeScreen_ScanInvisible)
    },
    {   // 36 - ::HomeScreenInfoData::mHomeScreen_DABServicevisiblity
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::HomeScreenInfoData, mHomeScreen_DABServicevisiblity)
    },
    {   // 37 - ::HomeScreenInfoData::mHomeScreen_MuteIconStatus
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::HomeScreenInfoData, mHomeScreen_MuteIconStatus)
    },
    {   // 38 - ::HomeScreenInfoData::mHomeFrequency
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::HomeScreenInfoData, mHomeFrequency)
    },
    {   // 39 - ::HomeScreenInfoData::mHomeScreen_PACStatus
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::HomeScreenInfoData, mHomeScreen_PACStatus)
    },
    {   // 40 - ::HomeScreenInfoData::mHomeWeatherbandText
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::HomeScreenInfoData, mHomeWeatherbandText)
    },
    {   // 41 - ::HomeScreenInfoData::mFrequencyUnit
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::HomeScreenInfoData, mFrequencyUnit)
    },
    {   // 42 - ::HomeScreenInfoData::mHomeScreen_NextPreviousIconStatus
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::HomeScreenInfoData, mHomeScreen_NextPreviousIconStatus)
    },
    {   // 43 - ::HomeScreenInfoData::mHomeFrequencyStationName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::HomeScreenInfoData, mHomeFrequencyStationName)
    },
    {   // 44 - ::HomeScreenInfoData::mHomeFrequencyStationNameVisibility
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::HomeScreenInfoData, mHomeFrequencyStationNameVisibility)
    },
    {   // 45 - ::RadioBandInfoData
        COURIER_DATA_ITEM_TYPE_ID(::RadioBandInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 46 - ::RadioBandInfoData::mVisible_Txt_Wgt_Band
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::RadioBandInfoData, mVisible_Txt_Wgt_Band)
    },
    {   // 47 - ::RadioBandInfoData::mVisible_Txt_Wgt_Mute
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::RadioBandInfoData, mVisible_Txt_Wgt_Mute)
    },
    {   // 48 - ::RadioBandInfoData::mVisible_Txt_Wgt_TA
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::RadioBandInfoData, mVisible_Txt_Wgt_TA)
    },
    {   // 49 - ::RadioBandInfoData::mVisible_Txt_Wgt_TA_In_AM
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::RadioBandInfoData, mVisible_Txt_Wgt_TA_In_AM)
    },
    {   // 50 - ::RadioBandInfoData::mImage_TA
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::RadioBandInfoData, mImage_TA)
    },
    {   // 51 - ::RadioBandInfoData::mVisible_Txt_Wgt_TA_FM
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::RadioBandInfoData, mVisible_Txt_Wgt_TA_FM)
    },
    {   // 52 - ::RadioBandInfoData::mVisible_Txt_Wgt_TA_DAB
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::RadioBandInfoData, mVisible_Txt_Wgt_TA_DAB)
    },
    {   // 53 - ::FMStationListData
        COURIER_DATA_ITEM_TYPE_ID(::FMStationListData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 54 - ::FMStationListData::mpresetnumber
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt32),
        COURIER_ITEM_MEMBER(::FMStationListData, mpresetnumber)
    },
    {   // 55 - ::FMStationListData::mstation_name
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::FMStationListData, mstation_name)
    },
    {   // 56 - ::FMStationListData::mTraffic_program
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::FMStationListData, mTraffic_program)
    },
    {   // 57 - ::RDSOptionsData
        COURIER_DATA_ITEM_TYPE_ID(::RDSOptionsData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 58 - ::RDSOptionsData::mVisible_TA_Icon
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::RDSOptionsData, mVisible_TA_Icon)
    },
    {   // 59 - ::RDSOptionsData::mVisible_TA_Icon_Cross
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::RDSOptionsData, mVisible_TA_Icon_Cross)
    },
    {   // 60 - ::RDSOptionsData::mVisible_TA
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::RDSOptionsData, mVisible_TA)
    },
    {   // 61 - ::RDSOptionsData::mVisible_RadioText
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::RDSOptionsData, mVisible_RadioText)
    },
    {   // 62 - ::RDSOptionsData::mVisible_AF
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::RDSOptionsData, mVisible_AF)
    },
    {   // 63 - ::RDSOptionsData::mVisible_Reg
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::RDSOptionsData, mVisible_Reg)
    },
    {   // 64 - ::RDSOptionsData::mVisible_DRMAFS
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::RDSOptionsData, mVisible_DRMAFS)
    },
    {   // 65 - ::PresetInfoWBData
        COURIER_DATA_ITEM_TYPE_ID(::PresetInfoWBData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 66 - ::PresetInfoWBData::mWBName1
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoWBData, mWBName1)
    },
    {   // 67 - ::PresetInfoWBData::mWBName2
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoWBData, mWBName2)
    },
    {   // 68 - ::PresetInfoWBData::mWBName3
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoWBData, mWBName3)
    },
    {   // 69 - ::PresetInfoWBData::mWBName4
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoWBData, mWBName4)
    },
    {   // 70 - ::PresetInfoWBData::mWBName5
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoWBData, mWBName5)
    },
    {   // 71 - ::PresetInfoWBData::mWBName6
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoWBData, mWBName6)
    },
    {   // 72 - ::PresetInfoWBData::mWBName7
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoWBData, mWBName7)
    },
    {   // 73 - ::PresetInfoWBData::mWBName8
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoWBData, mWBName8)
    },
    {   // 74 - ::PresetInfoWBData::mWBName9
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoWBData, mWBName9)
    },
    {   // 75 - ::PresetInfoWBData::mWBName10
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoWBData, mWBName10)
    },
    {   // 76 - ::PresetInfoWBData::mWBmode
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoWBData, mWBmode)
    },
    {   // 77 - ::PresetInfoWBData::mWBFrequency
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoWBData, mWBFrequency)
    },
    {   // 78 - ::WBPresetInfoData
        COURIER_DATA_ITEM_TYPE_ID(::WBPresetInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 79 - ::WBPresetInfoData::mPreset_1_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::WBPresetInfoData, mPreset_1_Active)
    },
    {   // 80 - ::WBPresetInfoData::mPreset_2_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::WBPresetInfoData, mPreset_2_Active)
    },
    {   // 81 - ::WBPresetInfoData::mPreset_3_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::WBPresetInfoData, mPreset_3_Active)
    },
    {   // 82 - ::WBPresetInfoData::mPreset_4_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::WBPresetInfoData, mPreset_4_Active)
    },
    {   // 83 - ::WBPresetInfoData::mPreset_5_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::WBPresetInfoData, mPreset_5_Active)
    },
    {   // 84 - ::WBPresetInfoData::mPreset_6_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::WBPresetInfoData, mPreset_6_Active)
    },
    {   // 85 - ::WBPresetInfoData::mPreset_7_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::WBPresetInfoData, mPreset_7_Active)
    },
    {   // 86 - ::WBPresetInfoData::mPreset_8_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::WBPresetInfoData, mPreset_8_Active)
    },
    {   // 87 - ::WBPresetInfoData::mPreset_9_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::WBPresetInfoData, mPreset_9_Active)
    },
    {   // 88 - ::WBPresetInfoData::mPreset_10_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::WBPresetInfoData, mPreset_10_Active)
    },
    {   // 89 - ::PresetInfoFM1Data
        COURIER_DATA_ITEM_TYPE_ID(::PresetInfoFM1Data),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 90 - ::PresetInfoFM1Data::mPSName1
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoFM1Data, mPSName1)
    },
    {   // 91 - ::PresetInfoFM1Data::mPSName2
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoFM1Data, mPSName2)
    },
    {   // 92 - ::PresetInfoFM1Data::mPSName3
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoFM1Data, mPSName3)
    },
    {   // 93 - ::PresetInfoFM1Data::mPSName4
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoFM1Data, mPSName4)
    },
    {   // 94 - ::PresetInfoFM1Data::mPSName5
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoFM1Data, mPSName5)
    },
    {   // 95 - ::PresetInfoFM1Data::mPSName6
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoFM1Data, mPSName6)
    },
    {   // 96 - ::PresetInfoFM2Data
        COURIER_DATA_ITEM_TYPE_ID(::PresetInfoFM2Data),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 97 - ::PresetInfoFM2Data::mPSName1
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoFM2Data, mPSName1)
    },
    {   // 98 - ::PresetInfoFM2Data::mPSName2
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoFM2Data, mPSName2)
    },
    {   // 99 - ::PresetInfoFM2Data::mPSName3
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoFM2Data, mPSName3)
    },
    {   // 100 - ::PresetInfoFM2Data::mPSName4
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoFM2Data, mPSName4)
    },
    {   // 101 - ::PresetInfoFM2Data::mPSName5
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoFM2Data, mPSName5)
    },
    {   // 102 - ::PresetInfoFM2Data::mPSName6
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoFM2Data, mPSName6)
    },
    {   // 103 - ::PresetInfoFMASTData
        COURIER_DATA_ITEM_TYPE_ID(::PresetInfoFMASTData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 104 - ::PresetInfoFMASTData::mPSName1
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoFMASTData, mPSName1)
    },
    {   // 105 - ::PresetInfoFMASTData::mPSName2
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoFMASTData, mPSName2)
    },
    {   // 106 - ::PresetInfoFMASTData::mPSName3
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoFMASTData, mPSName3)
    },
    {   // 107 - ::PresetInfoFMASTData::mPSName4
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoFMASTData, mPSName4)
    },
    {   // 108 - ::PresetInfoFMASTData::mPSName5
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoFMASTData, mPSName5)
    },
    {   // 109 - ::PresetInfoFMASTData::mPSName6
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoFMASTData, mPSName6)
    },
    {   // 110 - ::PresetInfoAMData
        COURIER_DATA_ITEM_TYPE_ID(::PresetInfoAMData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 111 - ::PresetInfoAMData::mPSName1
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoAMData, mPSName1)
    },
    {   // 112 - ::PresetInfoAMData::mPSName2
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoAMData, mPSName2)
    },
    {   // 113 - ::PresetInfoAMData::mPSName3
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoAMData, mPSName3)
    },
    {   // 114 - ::PresetInfoAMData::mPSName4
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoAMData, mPSName4)
    },
    {   // 115 - ::PresetInfoAMData::mPSName5
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoAMData, mPSName5)
    },
    {   // 116 - ::PresetInfoAMData::mPSName6
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoAMData, mPSName6)
    },
    {   // 117 - ::PresetInfoAMData::mPSName7
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoAMData, mPSName7)
    },
    {   // 118 - ::PresetInfoAMData::mPSName8
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoAMData, mPSName8)
    },
    {   // 119 - ::PresetInfoAMData::mPSName9
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoAMData, mPSName9)
    },
    {   // 120 - ::PresetInfoAMData::mPSName10
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoAMData, mPSName10)
    },
    {   // 121 - ::PresetInfoAMData::mPSName11
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoAMData, mPSName11)
    },
    {   // 122 - ::PresetInfoAMData::mPSName12
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoAMData, mPSName12)
    },
    {   // 123 - ::PresetInfoAMASTData
        COURIER_DATA_ITEM_TYPE_ID(::PresetInfoAMASTData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 124 - ::PresetInfoAMASTData::mPSName1
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoAMASTData, mPSName1)
    },
    {   // 125 - ::PresetInfoAMASTData::mPSName2
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoAMASTData, mPSName2)
    },
    {   // 126 - ::PresetInfoAMASTData::mPSName3
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoAMASTData, mPSName3)
    },
    {   // 127 - ::PresetInfoAMASTData::mPSName4
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoAMASTData, mPSName4)
    },
    {   // 128 - ::PresetInfoAMASTData::mPSName5
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoAMASTData, mPSName5)
    },
    {   // 129 - ::PresetInfoAMASTData::mPSName6
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoAMASTData, mPSName6)
    },
    {   // 130 - ::PresetInfoDABData
        COURIER_DATA_ITEM_TYPE_ID(::PresetInfoDABData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 131 - ::PresetInfoDABData::mPSName1
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoDABData, mPSName1)
    },
    {   // 132 - ::PresetInfoDABData::mPSName2
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoDABData, mPSName2)
    },
    {   // 133 - ::PresetInfoDABData::mPSName3
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoDABData, mPSName3)
    },
    {   // 134 - ::PresetInfoDABData::mPSName4
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoDABData, mPSName4)
    },
    {   // 135 - ::PresetInfoDABData::mPSName5
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoDABData, mPSName5)
    },
    {   // 136 - ::PresetInfoDABData::mPSName6
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoDABData, mPSName6)
    },
    {   // 137 - ::PresetInfoDABData::mPSName7
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoDABData, mPSName7)
    },
    {   // 138 - ::PresetInfoDABData::mPSName8
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoDABData, mPSName8)
    },
    {   // 139 - ::PresetInfoDABData::mPSName9
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoDABData, mPSName9)
    },
    {   // 140 - ::PresetInfoDABData::mPSName10
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoDABData, mPSName10)
    },
    {   // 141 - ::PresetInfoDABData::mPSName11
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoDABData, mPSName11)
    },
    {   // 142 - ::PresetInfoDABData::mPSName12
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoDABData, mPSName12)
    },
    {   // 143 - ::PresetInfoDABASTData
        COURIER_DATA_ITEM_TYPE_ID(::PresetInfoDABASTData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 144 - ::PresetInfoDABASTData::mPSName1
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoDABASTData, mPSName1)
    },
    {   // 145 - ::PresetInfoDABASTData::mPSName2
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoDABASTData, mPSName2)
    },
    {   // 146 - ::PresetInfoDABASTData::mPSName3
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoDABASTData, mPSName3)
    },
    {   // 147 - ::PresetInfoDABASTData::mPSName4
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoDABASTData, mPSName4)
    },
    {   // 148 - ::PresetInfoDABASTData::mPSName5
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoDABASTData, mPSName5)
    },
    {   // 149 - ::PresetInfoDABASTData::mPSName6
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoDABASTData, mPSName6)
    },
    {   // 150 - ::PresetInfoDRMData
        COURIER_DATA_ITEM_TYPE_ID(::PresetInfoDRMData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 151 - ::PresetInfoDRMData::mPSName1
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoDRMData, mPSName1)
    },
    {   // 152 - ::PresetInfoDRMData::mPSName2
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoDRMData, mPSName2)
    },
    {   // 153 - ::PresetInfoDRMData::mPSName3
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoDRMData, mPSName3)
    },
    {   // 154 - ::PresetInfoDRMData::mPSName4
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoDRMData, mPSName4)
    },
    {   // 155 - ::PresetInfoDRMData::mPSName5
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoDRMData, mPSName5)
    },
    {   // 156 - ::PresetInfoDRMData::mPSName6
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoDRMData, mPSName6)
    },
    {   // 157 - ::PresetInfoDRMASTData
        COURIER_DATA_ITEM_TYPE_ID(::PresetInfoDRMASTData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 158 - ::PresetInfoDRMASTData::mPSName1
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoDRMASTData, mPSName1)
    },
    {   // 159 - ::PresetInfoDRMASTData::mPSName2
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoDRMASTData, mPSName2)
    },
    {   // 160 - ::PresetInfoDRMASTData::mPSName3
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoDRMASTData, mPSName3)
    },
    {   // 161 - ::PresetInfoDRMASTData::mPSName4
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoDRMASTData, mPSName4)
    },
    {   // 162 - ::PresetInfoDRMASTData::mPSName5
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoDRMASTData, mPSName5)
    },
    {   // 163 - ::PresetInfoDRMASTData::mPSName6
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoDRMASTData, mPSName6)
    },
    {   // 164 - ::EngineeringInfoData
        COURIER_DATA_ITEM_TYPE_ID(::EngineeringInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 165 - ::EngineeringInfoData::m_szFrequency
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfoData, m_szFrequency)
    },
    {   // 166 - ::EngineeringInfoData::m_szPSName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfoData, m_szPSName)
    },
    {   // 167 - ::EngineeringInfoData::m_szPI
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfoData, m_szPI)
    },
    {   // 168 - ::EngineeringInfoData::m_szFieldstrength
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfoData, m_szFieldstrength)
    },
    {   // 169 - ::EngineeringInfoData::m_szQuality
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfoData, m_szQuality)
    },
    {   // 170 - ::EngineeringInfoData::m_szSharx
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfoData, m_szSharx)
    },
    {   // 171 - ::EngineeringInfoData::m_szHicut
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfoData, m_szHicut)
    },
    {   // 172 - ::EngineeringInfoData::m_szFMDeviation
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfoData, m_szFMDeviation)
    },
    {   // 173 - ::EngineeringInfoData::m_szChannelSeparation
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfoData, m_szChannelSeparation)
    },
    {   // 174 - ::LayerNextPresets_FMData
        COURIER_DATA_ITEM_TYPE_ID(::LayerNextPresets_FMData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 175 - ::LayerNextPresets_FMData::mNextPreviousIndex_FM
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::LayerNextPresets_FMData, mNextPreviousIndex_FM)
    },
    {   // 176 - ::LayerNextPresets_AMData
        COURIER_DATA_ITEM_TYPE_ID(::LayerNextPresets_AMData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 177 - ::LayerNextPresets_AMData::mNextPreviousIndex_AM
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::LayerNextPresets_AMData, mNextPreviousIndex_AM)
    },
    {   // 178 - ::LayerNextPresets_DABData
        COURIER_DATA_ITEM_TYPE_ID(::LayerNextPresets_DABData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 179 - ::LayerNextPresets_DABData::mNextPreviousIndex_DAB
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::LayerNextPresets_DABData, mNextPreviousIndex_DAB)
    },
    {   // 180 - ::EngineeringInfo1Data
        COURIER_DATA_ITEM_TYPE_ID(::EngineeringInfo1Data),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 181 - ::EngineeringInfo1Data::mMultipathQuality
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfo1Data, mMultipathQuality)
    },
    {   // 182 - ::EngineeringInfo1Data::mnChannel
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfo1Data, mnChannel)
    },
    {   // 183 - ::EngineeringInfo1Data::mRDS
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfo1Data, mRDS)
    },
    {   // 184 - ::EngineeringInfo1Data::mAntennaStatus
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfo1Data, mAntennaStatus)
    },
    {   // 185 - ::EngineeringInfo1Data::mReceptionQuality
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfo1Data, mReceptionQuality)
    },
    {   // 186 - ::EngineeringInfo1Data::mSzSharx
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfo1Data, mSzSharx)
    },
    {   // 187 - ::EngineeringInfo1Data::mSzHicut
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfo1Data, mSzHicut)
    },
    {   // 188 - ::EngineeringInfo1Data::mTPFlag
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfo1Data, mTPFlag)
    },
    {   // 189 - ::EngineeringInfo2Data
        COURIER_DATA_ITEM_TYPE_ID(::EngineeringInfo2Data),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 190 - ::EngineeringInfo2Data::mTAFlag
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfo2Data, mTAFlag)
    },
    {   // 191 - ::EngineeringInfo2Data::mAltFrequency
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfo2Data, mAltFrequency)
    },
    {   // 192 - ::EngineeringInfo2Data::mAFonOff
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::EngineeringInfo2Data, mAFonOff)
    },
    {   // 193 - ::EngineeringInfo2Data::mBandscanOnOff
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::EngineeringInfo2Data, mBandscanOnOff)
    },
    {   // 194 - ::EngineeringInfo2Data::mMeasureOnOff
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::EngineeringInfo2Data, mMeasureOnOff)
    },
    {   // 195 - ::EngineeringInfo2Data::mFreqStepFM
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfo2Data, mFreqStepFM)
    },
    {   // 196 - ::EngineeringInfo2Data::mFreqStepAM
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfo2Data, mFreqStepAM)
    },
    {   // 197 - ::EngineeringInfo2Data::mRFLevelAM
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfo2Data, mRFLevelAM)
    },
    {   // 198 - ::EngineeringInfo2Data::mLinearAudio
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::EngineeringInfo2Data, mLinearAudio)
    },
    {   // 199 - ::EngineeringInfo2Data::mAMTuner
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfo2Data, mAMTuner)
    },
    {   // 200 - ::EngineeringInfo2Data::mFMTuner1
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfo2Data, mFMTuner1)
    },
    {   // 201 - ::EngineeringInfo2Data::mFMTuner2
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfo2Data, mFMTuner2)
    },
    {   // 202 - ::EngineeringInfo2Data::mFMTuner3
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfo2Data, mFMTuner3)
    },
    {   // 203 - ::EngineeringInfo2Data::mFMTuner4
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfo2Data, mFMTuner4)
    },
    {   // 204 - ::EngineeringInfo2Data::mDABTuner
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfo2Data, mDABTuner)
    },
    {   // 205 - ::EngineeringInfoDRMData
        COURIER_DATA_ITEM_TYPE_ID(::EngineeringInfoDRMData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 206 - ::EngineeringInfoDRMData::mFrequency
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfoDRMData, mFrequency)
    },
    {   // 207 - ::EngineeringInfoDRMData::mFieldStrength
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfoDRMData, mFieldStrength)
    },
    {   // 208 - ::EngineeringInfoDRMData::mSyncStatus
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfoDRMData, mSyncStatus)
    },
    {   // 209 - ::EngineeringInfoDRMData::mRobustnessMode
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfoDRMData, mRobustnessMode)
    },
    {   // 210 - ::EngineeringInfoDRMData::mBandwidth
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfoDRMData, mBandwidth)
    },
    {   // 211 - ::EngineeringInfoDRMData::mInter_Depth
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfoDRMData, mInter_Depth)
    },
    {   // 212 - ::EngineeringInfoDRMData::mRecnfg_idx
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfoDRMData, mRecnfg_idx)
    },
    {   // 213 - ::EngineeringInfoDRMData::mService_ID
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfoDRMData, mService_ID)
    },
    {   // 214 - ::EngineeringInfoDRMData::mService_Label
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfoDRMData, mService_Label)
    },
    {   // 215 - ::EngineeringInfoDRMData::mPTY
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfoDRMData, mPTY)
    },
    {   // 216 - ::EngineeringInfoDRMData::mLanguage
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfoDRMData, mLanguage)
    },
    {   // 217 - ::EngineeringInfoDRMData::mFAC
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfoDRMData, mFAC)
    },
    {   // 218 - ::EngineeringInfoDRMData::mSDC
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfoDRMData, mSDC)
    },
    {   // 219 - ::EngineeringInfoDRMData::mAudioCRC
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfoDRMData, mAudioCRC)
    },
    {   // 220 - ::EngineeringInfoDRMData::mAudioMute
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfoDRMData, mAudioMute)
    },
    {   // 221 - ::EngineeringInfoDRMData::mServiceQuality
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfoDRMData, mServiceQuality)
    },
    {   // 222 - ::EngineeringInfoDRMData::mAudioCoding
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfoDRMData, mAudioCoding)
    },
    {   // 223 - ::EngineeringInfoDRMData::mSBR
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfoDRMData, mSBR)
    },
    {   // 224 - ::EngineeringInfoDRMData::mAudioMode
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfoDRMData, mAudioMode)
    },
    {   // 225 - ::EngineeringInfoDRMData::mSamplingRate
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfoDRMData, mSamplingRate)
    },
    {   // 226 - ::EngineeringInfoDRMData::mTextFlag
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfoDRMData, mTextFlag)
    },
    {   // 227 - ::EngineeringInfoDRMData::mIBER
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfoDRMData, mIBER)
    },
    {   // 228 - ::EngineeringInfoDRMData::mPrLevel_PartA
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfoDRMData, mPrLevel_PartA)
    },
    {   // 229 - ::EngineeringInfoDRMData::mPrLevel_Partb
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfoDRMData, mPrLevel_Partb)
    },
    {   // 230 - ::Scan_ASTData
        COURIER_DATA_ITEM_TYPE_ID(::Scan_ASTData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 231 - ::Scan_ASTData::mIsActive
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::Scan_ASTData, mIsActive)
    },
    {   // 232 - ::Scan_ASTData::mIsDAB_AST_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::Scan_ASTData, mIsDAB_AST_Active)
    },
    {   // 233 - ::Scan_ASTData::mIsAM_AST_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::Scan_ASTData, mIsAM_AST_Active)
    },
    {   // 234 - ::Scan_ASTData::mIsFM_AST_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::Scan_ASTData, mIsFM_AST_Active)
    },
    {   // 235 - ::Scan_ASTData::mIsDRM_AST_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::Scan_ASTData, mIsDRM_AST_Active)
    },
    {   // 236 - ::Scan_StatusData
        COURIER_DATA_ITEM_TYPE_ID(::Scan_StatusData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 237 - ::Scan_StatusData::mIsActiveScan
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::Scan_StatusData, mIsActiveScan)
    },
    {   // 238 - ::Source_SlectionData
        COURIER_DATA_ITEM_TYPE_ID(::Source_SlectionData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 239 - ::Source_SlectionData::mFM1Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::Source_SlectionData, mFM1Active)
    },
    {   // 240 - ::Source_SlectionData::mFM2Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::Source_SlectionData, mFM2Active)
    },
    {   // 241 - ::Source_SlectionData::mFMASTActive
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::Source_SlectionData, mFMASTActive)
    },
    {   // 242 - ::Source_SlectionData::mAMActive
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::Source_SlectionData, mAMActive)
    },
    {   // 243 - ::Source_SlectionData::mAMASTActive
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::Source_SlectionData, mAMASTActive)
    },
    {   // 244 - ::Source_SlectionData::mWXActive
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::Source_SlectionData, mWXActive)
    },
    {   // 245 - ::Source_SlectionData::mDABActive
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::Source_SlectionData, mDABActive)
    },
    {   // 246 - ::Source_SlectionData::mDABASTActive
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::Source_SlectionData, mDABASTActive)
    },
    {   // 247 - ::Source_SlectionData::mSXMActive
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::Source_SlectionData, mSXMActive)
    },
    {   // 248 - ::Preset_PopupData
        COURIER_DATA_ITEM_TYPE_ID(::Preset_PopupData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 249 - ::Preset_PopupData::mPopup_text_1
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Preset_PopupData, mPopup_text_1)
    },
    {   // 250 - ::Preset_PopupData::mPopup_text_2
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Preset_PopupData, mPopup_text_2)
    },
    {   // 251 - ::Preset_PopupData::mAST_CannotStore
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Preset_PopupData, mAST_CannotStore)
    },
    {   // 252 - ::Preset_PopupData::mCurrentValue
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::Preset_PopupData, mCurrentValue)
    },
    {   // 253 - ::Preset_PopupData::mTotalValue
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::Preset_PopupData, mTotalValue)
    },
    {   // 254 - ::Preset_PopupData::mVisible_Txt_Wgt_1
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::Preset_PopupData, mVisible_Txt_Wgt_1)
    },
    {   // 255 - ::Preset_PopupData::mVisible_Txt_Wgt_2
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::Preset_PopupData, mVisible_Txt_Wgt_2)
    },
    {   // 256 - ::PgBar_timerData
        COURIER_DATA_ITEM_TYPE_ID(::PgBar_timerData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 257 - ::PgBar_timerData::mTimerValue
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt32),
        COURIER_ITEM_MEMBER(::PgBar_timerData, mTimerValue)
    },
    {   // 258 - ::PgBar_timerData::mNoOfSteps
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::PgBar_timerData, mNoOfSteps)
    },
    {   // 259 - ::PgBar_timerData::mTimerStart
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::PgBar_timerData, mTimerStart)
    },
    {   // 260 - ::tuningScale_SliderMarkerPositionData
        COURIER_DATA_ITEM_TYPE_ID(::tuningScale_SliderMarkerPositionData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 261 - ::tuningScale_SliderMarkerPositionData::mCurrentValue
        COURIER_DATA_ITEM_TYPE_ID( Candera::Float),
        COURIER_ITEM_MEMBER(::tuningScale_SliderMarkerPositionData, mCurrentValue)
    },
    {   // 262 - ::tuningScale_SliderMarkerPositionData::mDragCurrentValue
        COURIER_DATA_ITEM_TYPE_ID( Candera::Float),
        COURIER_ITEM_MEMBER(::tuningScale_SliderMarkerPositionData, mDragCurrentValue)
    },
    {   // 263 - ::tuningSliderData
        COURIER_DATA_ITEM_TYPE_ID(::tuningSliderData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 264 - ::tuningSliderData::mStepSizeAM
        COURIER_DATA_ITEM_TYPE_ID( Candera::Float),
        COURIER_ITEM_MEMBER(::tuningSliderData, mStepSizeAM)
    },
    {   // 265 - ::tuningSliderData::mMaxValueAM
        COURIER_DATA_ITEM_TYPE_ID( Candera::Float),
        COURIER_ITEM_MEMBER(::tuningSliderData, mMaxValueAM)
    },
    {   // 266 - ::tuningSliderData::mMinValueAM
        COURIER_DATA_ITEM_TYPE_ID( Candera::Float),
        COURIER_ITEM_MEMBER(::tuningSliderData, mMinValueAM)
    },
    {   // 267 - ::tuningSliderData::mNoOfStepsAM
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::tuningSliderData, mNoOfStepsAM)
    },
    {   // 268 - ::tuningSliderData::mImage_SliderAM
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::tuningSliderData, mImage_SliderAM)
    },
    {   // 269 - ::tuningSliderData::mImage_Slider_BG
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::tuningSliderData, mImage_Slider_BG)
    },
    {   // 270 - ::tuningSliderData::mStepSizeFM
        COURIER_DATA_ITEM_TYPE_ID( Candera::Float),
        COURIER_ITEM_MEMBER(::tuningSliderData, mStepSizeFM)
    },
    {   // 271 - ::tuningSliderData::mMaxValueFM
        COURIER_DATA_ITEM_TYPE_ID( Candera::Float),
        COURIER_ITEM_MEMBER(::tuningSliderData, mMaxValueFM)
    },
    {   // 272 - ::tuningSliderData::mTotalTimeFM
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::tuningSliderData, mTotalTimeFM)
    },
    {   // 273 - ::tuningSliderData::mNoOfStepsFM
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::tuningSliderData, mNoOfStepsFM)
    },
    {   // 274 - ::tuningSliderData::mImage_SliderFM
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::tuningSliderData, mImage_SliderFM)
    },
    {   // 275 - ::TunerOptionsData
        COURIER_DATA_ITEM_TYPE_ID(::TunerOptionsData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 276 - ::TunerOptionsData::misChecked_TA
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::TunerOptionsData, misChecked_TA)
    },
    {   // 277 - ::TunerOptionsData::misChecked_RadioTxt
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::TunerOptionsData, misChecked_RadioTxt)
    },
    {   // 278 - ::TunerOptionsData::misChecked_RDSRegPgm
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::TunerOptionsData, misChecked_RDSRegPgm)
    },
    {   // 279 - ::TunerOptionsData::misChecked_AltFreq
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::TunerOptionsData, misChecked_AltFreq)
    },
    {   // 280 - ::TunerOptionsData::misChecked_DAB_DynamicContent
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::TunerOptionsData, misChecked_DAB_DynamicContent)
    },
    {   // 281 - ::TunerOptionsData::misChecked_DAB_FM_Following
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::TunerOptionsData, misChecked_DAB_FM_Following)
    },
    {   // 282 - ::TunerOptionsData::misChecked_DAB_DAB_Linking
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::TunerOptionsData, misChecked_DAB_DAB_Linking)
    },
    {   // 283 - ::TunerOptionsData::misChecked_DRM_DynamicContent
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::TunerOptionsData, misChecked_DRM_DynamicContent)
    },
    {   // 284 - ::TunerOptionsData::misChecked_DRMFrequency
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::TunerOptionsData, misChecked_DRMFrequency)
    },
    {   // 285 - ::TunerOptionsData::misChecked_DRMAFSEARCH
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::TunerOptionsData, misChecked_DRMAFSEARCH)
    },
    {   // 286 - ::DABOptionsData
        COURIER_DATA_ITEM_TYPE_ID(::DABOptionsData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 287 - ::DABOptionsData::misChecked_EnablePTYFilter
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::DABOptionsData, misChecked_EnablePTYFilter)
    },
    {   // 288 - ::DABOptionsData::misChecked_News
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::DABOptionsData, misChecked_News)
    },
    {   // 289 - ::DABOptionsData::misChecked_Culture
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::DABOptionsData, misChecked_Culture)
    },
    {   // 290 - ::DABOptionsData::misChecked_Sports
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::DABOptionsData, misChecked_Sports)
    },
    {   // 291 - ::DABOptionsData::misChecked_Music
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::DABOptionsData, misChecked_Music)
    },
    {   // 292 - ::DABOptionsData::misChecked_Special
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::DABOptionsData, misChecked_Special)
    },
    {   // 293 - ::DRMOptionsData
        COURIER_DATA_ITEM_TYPE_ID(::DRMOptionsData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 294 - ::DRMOptionsData::misChecked_EnablePTYFilter
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::DRMOptionsData, misChecked_EnablePTYFilter)
    },
    {   // 295 - ::DRMOptionsData::misChecked_News
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::DRMOptionsData, misChecked_News)
    },
    {   // 296 - ::DRMOptionsData::misChecked_Culture
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::DRMOptionsData, misChecked_Culture)
    },
    {   // 297 - ::DRMOptionsData::misChecked_Sports
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::DRMOptionsData, misChecked_Sports)
    },
    {   // 298 - ::DRMOptionsData::misChecked_Music
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::DRMOptionsData, misChecked_Music)
    },
    {   // 299 - ::DRMOptionsData::misChecked_Special
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::DRMOptionsData, misChecked_Special)
    },
    {   // 300 - ::MenuSelectionData
        COURIER_DATA_ITEM_TYPE_ID(::MenuSelectionData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 301 - ::MenuSelectionData::mMainMenu_Selection
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt32),
        COURIER_ITEM_MEMBER(::MenuSelectionData, mMainMenu_Selection)
    },
    {   // 302 - ::MenuSelectionData::mDABPTYOption_Selection
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt32),
        COURIER_ITEM_MEMBER(::MenuSelectionData, mDABPTYOption_Selection)
    },
    {   // 303 - ::MenuSelectionData::mDRMPTYOption_Selection
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt32),
        COURIER_ITEM_MEMBER(::MenuSelectionData, mDRMPTYOption_Selection)
    },
    {   // 304 - ::Menu_NumOptionsData
        COURIER_DATA_ITEM_TYPE_ID(::Menu_NumOptionsData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 305 - ::Menu_NumOptionsData::mMainMenu_NumOptions
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt32),
        COURIER_ITEM_MEMBER(::Menu_NumOptionsData, mMainMenu_NumOptions)
    },
    {   // 306 - ::AppFlyInData
        COURIER_DATA_ITEM_TYPE_ID(::AppFlyInData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 307 - ::AppFlyInData::mBTDeviceState
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::AppFlyInData, mBTDeviceState)
    },
    {   // 308 - ::AppFlyInData::mPhoneCallDuration
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::AppFlyInData, mPhoneCallDuration)
    },
    {   // 309 - ::AppFlyInData::mTextPhoneCallDuration
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::AppFlyInData, mTextPhoneCallDuration)
    },
    {   // 310 - ::AppFlyInData::mPhoneRoaming
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::AppFlyInData, mPhoneRoaming)
    },
    {   // 311 - ::AppFlyInData::mPhoneCharge
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::AppFlyInData, mPhoneCharge)
    },
    {   // 312 - ::AppFlyInData::mPhoneSPILink
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::AppFlyInData, mPhoneSPILink)
    },
    {   // 313 - ::AppFlyInData::mNaviRGStaus
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::AppFlyInData, mNaviRGStaus)
    },
    {   // 314 - ::AppFlyInData::mNaviETADTD
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::AppFlyInData, mNaviETADTD)
    },
    {   // 315 - ::AppFlyInData::mNaviDirection
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt32),
        COURIER_ITEM_MEMBER(::AppFlyInData, mNaviDirection)
    },
    {   // 316 - ::AppFlyInData::mNaviDuration
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::AppFlyInData, mNaviDuration)
    },
    {   // 317 - ::AppFlyInData::mNaviTimeToDestination
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::AppFlyInData, mNaviTimeToDestination)
    },
    {   // 318 - ::AppFlyInData::mVisible_Navi
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::AppFlyInData, mVisible_Navi)
    },
    {   // 319 - ::AppFlyInData::mVisible_Media
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::AppFlyInData, mVisible_Media)
    },
    {   // 320 - ::BrowseListPointerData
        COURIER_DATA_ITEM_TYPE_ID(::BrowseListPointerData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 321 - ::BrowseListSizeData
        COURIER_DATA_ITEM_TYPE_ID(::BrowseListSizeData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 322 - ::BrowseListSizeData::mTun_StationListSize
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::BrowseListSizeData, mTun_StationListSize)
    },
    {   // 323 - ::BrowseListSizeData::mDAB_ServiceListSize
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::BrowseListSizeData, mDAB_ServiceListSize)
    },
    {   // 324 - ::BrowseListSizeData::mAF_ServiceListSize
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::BrowseListSizeData, mAF_ServiceListSize)
    },
    {   // 325 - ::BrowseListSizeData::mTMC_ServiceListSize
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::BrowseListSizeData, mTMC_ServiceListSize)
    },
    {   // 326 - ::BrowseListSizeData::mDRM_ServiceListSize
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::BrowseListSizeData, mDRM_ServiceListSize)
    },
    {   // 327 - ::BrowseListSizeData::mTun_StationWindowListSize
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::BrowseListSizeData, mTun_StationWindowListSize)
    },
    {   // 328 - ::BrowseListSizeData::mDAB_ServiceWindowListSize
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::BrowseListSizeData, mDAB_ServiceWindowListSize)
    },
    {   // 329 - ::BrowseListSizeData::mAF_ServiceWindowListSize
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::BrowseListSizeData, mAF_ServiceWindowListSize)
    },
    {   // 330 - ::BrowseListSizeData::mTMC_ServiceWindowListSize
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::BrowseListSizeData, mTMC_ServiceWindowListSize)
    },
    {   // 331 - ::BrowseListSizeData::mDRM_ServiceWindowListSize
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::BrowseListSizeData, mDRM_ServiceWindowListSize)
    },
    {   // 332 - ::BrowseListSelectedLineData
        COURIER_DATA_ITEM_TYPE_ID(::BrowseListSelectedLineData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 333 - ::BrowseListSelectedLineData::mTun_StationSelected
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::BrowseListSelectedLineData, mTun_StationSelected)
    },
    {   // 334 - ::BrowseListSelectedLineData::mDAB_ServiceSelected
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::BrowseListSelectedLineData, mDAB_ServiceSelected)
    },
    {   // 335 - ::BrowseListSelectedLineData::mAF_ServiceSelected
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::BrowseListSelectedLineData, mAF_ServiceSelected)
    },
    {   // 336 - ::BrowseListSelectedLineData::mTMC_ServiceSelected
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::BrowseListSelectedLineData, mTMC_ServiceSelected)
    },
    {   // 337 - ::BrowseListSelectedLineData::mDRM_StationSelected
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::BrowseListSelectedLineData, mDRM_StationSelected)
    },
    {   // 338 - ::DABChannelInfoData
        COURIER_DATA_ITEM_TYPE_ID(::DABChannelInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 339 - ::DABChannelInfoData::mTpStatus
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DABChannelInfoData, mTpStatus)
    },
    {   // 340 - ::DABChannelInfoData::mDabStatus
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DABChannelInfoData, mDabStatus)
    },
    {   // 341 - ::DABChannelInfoData::mEnsembleLabel
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DABChannelInfoData, mEnsembleLabel)
    },
    {   // 342 - ::DABChannelInfoData::mServiceLabel
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DABChannelInfoData, mServiceLabel)
    },
    {   // 343 - ::DABChannelInfoData::mRadioText
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DABChannelInfoData, mRadioText)
    },
    {   // 344 - ::DABChannelInfoData::mRadioTextVisible
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::DABChannelInfoData, mRadioTextVisible)
    },
    {   // 345 - ::ActiveBankInfoData
        COURIER_DATA_ITEM_TYPE_ID(::ActiveBankInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 346 - ::ActiveBankInfoData::mFM1_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::ActiveBankInfoData, mFM1_Active)
    },
    {   // 347 - ::ActiveBankInfoData::mFM2_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::ActiveBankInfoData, mFM2_Active)
    },
    {   // 348 - ::ActiveBankInfoData::mFMAST_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::ActiveBankInfoData, mFMAST_Active)
    },
    {   // 349 - ::ActiveBankInfoData::mAM_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::ActiveBankInfoData, mAM_Active)
    },
    {   // 350 - ::ActiveBankInfoData::mAMAST_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::ActiveBankInfoData, mAMAST_Active)
    },
    {   // 351 - ::ActiveBankInfoData::mDAB_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::ActiveBankInfoData, mDAB_Active)
    },
    {   // 352 - ::ActiveBankInfoData::mDAB_AST_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::ActiveBankInfoData, mDAB_AST_Active)
    },
    {   // 353 - ::ActiveBankInfoData::mDRM_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::ActiveBankInfoData, mDRM_Active)
    },
    {   // 354 - ::ActiveBankInfoData::mDRM_AST_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::ActiveBankInfoData, mDRM_AST_Active)
    },
    {   // 355 - ::ActiveSourceInfoData
        COURIER_DATA_ITEM_TYPE_ID(::ActiveSourceInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 356 - ::ActiveSourceInfoData::mBitmapforSource
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::ActiveSourceInfoData, mBitmapforSource)
    },
    {   // 357 - ::ActiveSourceInfoData::mActiveSource
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::ActiveSourceInfoData, mActiveSource)
    },
    {   // 358 - ::VariantInfoData
        COURIER_DATA_ITEM_TYPE_ID(::VariantInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 359 - ::VariantInfoData::mDAB_Available
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::VariantInfoData, mDAB_Available)
    },
    {   // 360 - ::VariantInfoData::mWX_Available
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::VariantInfoData, mWX_Available)
    },
    {   // 361 - ::VariantInfoData::mDest_Reg_DRM
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::VariantInfoData, mDest_Reg_DRM)
    },
    {   // 362 - ::VariantInfoData::mDAB_Mounted
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::VariantInfoData, mDAB_Mounted)
    },
    {   // 363 - ::VariantInfoData::mHD_Available
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::VariantInfoData, mHD_Available)
    },
    {   // 364 - ::VariantInfoData::mAM_Activation
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::VariantInfoData, mAM_Activation)
    },
    {   // 365 - ::VariantInfoData::mFM_Activation
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::VariantInfoData, mFM_Activation)
    },
    {   // 366 - ::VariantInfoData::mSXM_Mounted
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::VariantInfoData, mSXM_Mounted)
    },
    {   // 367 - ::TAInfoData
        COURIER_DATA_ITEM_TYPE_ID(::TAInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 368 - ::TAInfoData::mTAPSName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::TAInfoData, mTAPSName)
    },
    {   // 369 - ::TAInfoData::mPTY31PSName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::TAInfoData, mPTY31PSName)
    },
    {   // 370 - ::DABPresetInfoData
        COURIER_DATA_ITEM_TYPE_ID(::DABPresetInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 371 - ::DABPresetInfoData::mPreset_1_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::DABPresetInfoData, mPreset_1_Active)
    },
    {   // 372 - ::DABPresetInfoData::mPreset_2_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::DABPresetInfoData, mPreset_2_Active)
    },
    {   // 373 - ::DABPresetInfoData::mPreset_3_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::DABPresetInfoData, mPreset_3_Active)
    },
    {   // 374 - ::DABPresetInfoData::mPreset_4_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::DABPresetInfoData, mPreset_4_Active)
    },
    {   // 375 - ::DABPresetInfoData::mPreset_5_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::DABPresetInfoData, mPreset_5_Active)
    },
    {   // 376 - ::DABPresetInfoData::mPreset_6_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::DABPresetInfoData, mPreset_6_Active)
    },
    {   // 377 - ::DABPresetInfoData::mPreset_7_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::DABPresetInfoData, mPreset_7_Active)
    },
    {   // 378 - ::DABPresetInfoData::mPreset_8_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::DABPresetInfoData, mPreset_8_Active)
    },
    {   // 379 - ::DABPresetInfoData::mPreset_9_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::DABPresetInfoData, mPreset_9_Active)
    },
    {   // 380 - ::DABPresetInfoData::mPreset_10_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::DABPresetInfoData, mPreset_10_Active)
    },
    {   // 381 - ::DABPresetInfoData::mPreset_11_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::DABPresetInfoData, mPreset_11_Active)
    },
    {   // 382 - ::DABPresetInfoData::mPreset_12_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::DABPresetInfoData, mPreset_12_Active)
    },
    {   // 383 - ::FMAMPresetInfoData
        COURIER_DATA_ITEM_TYPE_ID(::FMAMPresetInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 384 - ::FMAMPresetInfoData::mPreset_1_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::FMAMPresetInfoData, mPreset_1_Active)
    },
    {   // 385 - ::FMAMPresetInfoData::mPreset_2_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::FMAMPresetInfoData, mPreset_2_Active)
    },
    {   // 386 - ::FMAMPresetInfoData::mPreset_3_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::FMAMPresetInfoData, mPreset_3_Active)
    },
    {   // 387 - ::FMAMPresetInfoData::mPreset_4_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::FMAMPresetInfoData, mPreset_4_Active)
    },
    {   // 388 - ::FMAMPresetInfoData::mPreset_5_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::FMAMPresetInfoData, mPreset_5_Active)
    },
    {   // 389 - ::FMAMPresetInfoData::mPreset_6_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::FMAMPresetInfoData, mPreset_6_Active)
    },
    {   // 390 - ::FMAMPresetInfoData::mPreset_7_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::FMAMPresetInfoData, mPreset_7_Active)
    },
    {   // 391 - ::FMAMPresetInfoData::mPreset_8_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::FMAMPresetInfoData, mPreset_8_Active)
    },
    {   // 392 - ::FMAMPresetInfoData::mPreset_9_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::FMAMPresetInfoData, mPreset_9_Active)
    },
    {   // 393 - ::FMAMPresetInfoData::mPreset_10_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::FMAMPresetInfoData, mPreset_10_Active)
    },
    {   // 394 - ::FMAMPresetInfoData::mPreset_11_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::FMAMPresetInfoData, mPreset_11_Active)
    },
    {   // 395 - ::FMAMPresetInfoData::mPreset_12_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::FMAMPresetInfoData, mPreset_12_Active)
    },
    {   // 396 - ::AMPresetInfoData
        COURIER_DATA_ITEM_TYPE_ID(::AMPresetInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 397 - ::AMPresetInfoData::mPreset_1_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::AMPresetInfoData, mPreset_1_Active)
    },
    {   // 398 - ::AMPresetInfoData::mPreset_2_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::AMPresetInfoData, mPreset_2_Active)
    },
    {   // 399 - ::AMPresetInfoData::mPreset_3_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::AMPresetInfoData, mPreset_3_Active)
    },
    {   // 400 - ::AMPresetInfoData::mPreset_4_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::AMPresetInfoData, mPreset_4_Active)
    },
    {   // 401 - ::AMPresetInfoData::mPreset_5_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::AMPresetInfoData, mPreset_5_Active)
    },
    {   // 402 - ::AMPresetInfoData::mPreset_6_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::AMPresetInfoData, mPreset_6_Active)
    },
    {   // 403 - ::AMPresetInfoData::mPreset_7_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::AMPresetInfoData, mPreset_7_Active)
    },
    {   // 404 - ::AMPresetInfoData::mPreset_8_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::AMPresetInfoData, mPreset_8_Active)
    },
    {   // 405 - ::AMPresetInfoData::mPreset_9_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::AMPresetInfoData, mPreset_9_Active)
    },
    {   // 406 - ::AMPresetInfoData::mPreset_10_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::AMPresetInfoData, mPreset_10_Active)
    },
    {   // 407 - ::AMPresetInfoData::mPreset_11_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::AMPresetInfoData, mPreset_11_Active)
    },
    {   // 408 - ::AMPresetInfoData::mPreset_12_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::AMPresetInfoData, mPreset_12_Active)
    },
    {   // 409 - ::Tuner1Data
        COURIER_DATA_ITEM_TYPE_ID(::Tuner1Data),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 410 - ::Tuner1Data::mFreq
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner1Data, mFreq)
    },
    {   // 411 - ::Tuner1Data::mPI
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner1Data, mPI)
    },
    {   // 412 - ::Tuner1Data::mPS
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner1Data, mPS)
    },
    {   // 413 - ::Tuner1Data::mFSQ
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner1Data, mFSQ)
    },
    {   // 414 - ::Tuner1Data::mHicut
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner1Data, mHicut)
    },
    {   // 415 - ::Tuner1Data::mSharx
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner1Data, mSharx)
    },
    {   // 416 - ::Tuner1Data::mTP
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner1Data, mTP)
    },
    {   // 417 - ::Tuner1Data::mTA
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner1Data, mTA)
    },
    {   // 418 - ::Tuner1Data::mRDS
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner1Data, mRDS)
    },
    {   // 419 - ::Tuner1Data::mAF
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner1Data, mAF)
    },
    {   // 420 - ::Tuner1Data::mDev
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner1Data, mDev)
    },
    {   // 421 - ::Tuner1Data::mCS
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner1Data, mCS)
    },
    {   // 422 - ::Tuner1Data::mMPNC
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner1Data, mMPNC)
    },
    {   // 423 - ::Tuner1Data::mBand
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner1Data, mBand)
    },
    {   // 424 - ::Tuner2Data
        COURIER_DATA_ITEM_TYPE_ID(::Tuner2Data),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 425 - ::Tuner2Data::mFreq
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner2Data, mFreq)
    },
    {   // 426 - ::Tuner2Data::mPI
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner2Data, mPI)
    },
    {   // 427 - ::Tuner2Data::mPS
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner2Data, mPS)
    },
    {   // 428 - ::Tuner2Data::mFSQ
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner2Data, mFSQ)
    },
    {   // 429 - ::Tuner2Data::mHicut
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner2Data, mHicut)
    },
    {   // 430 - ::Tuner2Data::mSharx
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner2Data, mSharx)
    },
    {   // 431 - ::Tuner2Data::mTP
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner2Data, mTP)
    },
    {   // 432 - ::Tuner2Data::mTA
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner2Data, mTA)
    },
    {   // 433 - ::Tuner2Data::mRDS
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner2Data, mRDS)
    },
    {   // 434 - ::Tuner2Data::mAF
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner2Data, mAF)
    },
    {   // 435 - ::Tuner2Data::mDev
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner2Data, mDev)
    },
    {   // 436 - ::Tuner2Data::mCS
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner2Data, mCS)
    },
    {   // 437 - ::Tuner2Data::mMPNC
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner2Data, mMPNC)
    },
    {   // 438 - ::Tuner2Data::mBand
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner2Data, mBand)
    },
    {   // 439 - ::Tuner3Data
        COURIER_DATA_ITEM_TYPE_ID(::Tuner3Data),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 440 - ::Tuner3Data::mFreq
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner3Data, mFreq)
    },
    {   // 441 - ::Tuner3Data::mPI
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner3Data, mPI)
    },
    {   // 442 - ::Tuner3Data::mPS
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner3Data, mPS)
    },
    {   // 443 - ::Tuner3Data::mFSQ
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner3Data, mFSQ)
    },
    {   // 444 - ::Tuner3Data::mHicut
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner3Data, mHicut)
    },
    {   // 445 - ::Tuner3Data::mSharx
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner3Data, mSharx)
    },
    {   // 446 - ::Tuner3Data::mTP
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner3Data, mTP)
    },
    {   // 447 - ::Tuner3Data::mTA
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner3Data, mTA)
    },
    {   // 448 - ::Tuner3Data::mRDS
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner3Data, mRDS)
    },
    {   // 449 - ::Tuner3Data::mAF
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner3Data, mAF)
    },
    {   // 450 - ::Tuner3Data::mDev
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner3Data, mDev)
    },
    {   // 451 - ::Tuner3Data::mCS
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner3Data, mCS)
    },
    {   // 452 - ::Tuner3Data::mMPNC
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner3Data, mMPNC)
    },
    {   // 453 - ::Tuner3Data::mBand
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner3Data, mBand)
    },
    {   // 454 - ::Tuner4Data
        COURIER_DATA_ITEM_TYPE_ID(::Tuner4Data),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 455 - ::Tuner4Data::mFreq
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner4Data, mFreq)
    },
    {   // 456 - ::Tuner4Data::mPI
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner4Data, mPI)
    },
    {   // 457 - ::Tuner4Data::mPS
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner4Data, mPS)
    },
    {   // 458 - ::Tuner4Data::mFSQ
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner4Data, mFSQ)
    },
    {   // 459 - ::Tuner4Data::mHicut
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner4Data, mHicut)
    },
    {   // 460 - ::Tuner4Data::mSharx
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner4Data, mSharx)
    },
    {   // 461 - ::Tuner4Data::mTP
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner4Data, mTP)
    },
    {   // 462 - ::Tuner4Data::mTA
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner4Data, mTA)
    },
    {   // 463 - ::Tuner4Data::mRDS
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner4Data, mRDS)
    },
    {   // 464 - ::Tuner4Data::mAF
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner4Data, mAF)
    },
    {   // 465 - ::Tuner4Data::mDev
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner4Data, mDev)
    },
    {   // 466 - ::Tuner4Data::mCS
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner4Data, mCS)
    },
    {   // 467 - ::Tuner4Data::mMPNC
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner4Data, mMPNC)
    },
    {   // 468 - ::Tuner4Data::mBand
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner4Data, mBand)
    },
    {   // 469 - ::TunerSource_BandData
        COURIER_DATA_ITEM_TYPE_ID(::TunerSource_BandData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 470 - ::TunerSource_BandData::mTunerSource1
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::TunerSource_BandData, mTunerSource1)
    },
    {   // 471 - ::TunerSource_BandData::mTunerSource2
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::TunerSource_BandData, mTunerSource2)
    },
    {   // 472 - ::TunerSource_BandData::mTunerSource3
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::TunerSource_BandData, mTunerSource3)
    },
    {   // 473 - ::TunerSource_BandData::mTunerSource4
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::TunerSource_BandData, mTunerSource4)
    },
    {   // 474 - ::TunerSource_BandData::mBandEnable1
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::TunerSource_BandData, mBandEnable1)
    },
    {   // 475 - ::TunerSource_BandData::mBandEnable2
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::TunerSource_BandData, mBandEnable2)
    },
    {   // 476 - ::TunerSource_BandData::mBandEnable3
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::TunerSource_BandData, mBandEnable3)
    },
    {   // 477 - ::TunerSource_BandData::mBandEnable4
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::TunerSource_BandData, mBandEnable4)
    },
    {   // 478 - ::TunerSource_BandData::mBand1
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::TunerSource_BandData, mBand1)
    },
    {   // 479 - ::TunerSource_BandData::mBand2
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::TunerSource_BandData, mBand2)
    },
    {   // 480 - ::TunerSource_BandData::mBand3
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::TunerSource_BandData, mBand3)
    },
    {   // 481 - ::TunerSource_BandData::mBand4
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::TunerSource_BandData, mBand4)
    },
    {   // 482 - ::DAB_Setup_ScreenData
        COURIER_DATA_ITEM_TYPE_ID(::DAB_Setup_ScreenData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 483 - ::DAB_Setup_ScreenData::mServiceLinking
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Setup_ScreenData, mServiceLinking)
    },
    {   // 484 - ::DAB_Setup_ScreenData::mConcealmentLevel
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Setup_ScreenData, mConcealmentLevel)
    },
    {   // 485 - ::DAB_Test_ModeData
        COURIER_DATA_ITEM_TYPE_ID(::DAB_Test_ModeData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 486 - ::DAB_Test_ModeData::mchannel_Num
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Test_ModeData, mchannel_Num)
    },
    {   // 487 - ::DAB_Test_ModeData::mEnsemble_Lbl
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Test_ModeData, mEnsemble_Lbl)
    },
    {   // 488 - ::DAB_Test_ModeData::mEnsemble_ID
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Test_ModeData, mEnsemble_ID)
    },
    {   // 489 - ::DAB_Test_ModeData::mService_ID
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Test_ModeData, mService_ID)
    },
    {   // 490 - ::DAB_Test_ModeData::mEnsemble_freq
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Test_ModeData, mEnsemble_freq)
    },
    {   // 491 - ::DAB_Test_ModeData::mService_Lbl
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Test_ModeData, mService_Lbl)
    },
    {   // 492 - ::DAB_Test_ModeData::mAud_Data_Bit_Rate
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Test_ModeData, mAud_Data_Bit_Rate)
    },
    {   // 493 - ::DAB_Test_ModeData::mMSC
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Test_ModeData, mMSC)
    },
    {   // 494 - ::DAB_Test_ModeData::mFIC
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Test_ModeData, mFIC)
    },
    {   // 495 - ::DAB_Test_ModeData::mNET
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Test_ModeData, mNET)
    },
    {   // 496 - ::DAB_Test_ModeData::mRS_FEC
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Test_ModeData, mRS_FEC)
    },
    {   // 497 - ::DAB_Test_ModeData::mSync_flag
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Test_ModeData, mSync_flag)
    },
    {   // 498 - ::DAB_Test_ModeData::mQA
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Test_ModeData, mQA)
    },
    {   // 499 - ::DAB_Test_ModeData::mQS
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Test_ModeData, mQS)
    },
    {   // 500 - ::DAB_Test_ModeData::mField_Strength
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Test_ModeData, mField_Strength)
    },
    {   // 501 - ::DAB_Test_ModeData::mMute_flag
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Test_ModeData, mMute_flag)
    },
    {   // 502 - ::DAB_Test_ModeData::mBg_tuner_ens_freq
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Test_ModeData, mBg_tuner_ens_freq)
    },
    {   // 503 - ::DAB_Test_ModeData::mBg_Ensemble_ID
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Test_ModeData, mBg_Ensemble_ID)
    },
    {   // 504 - ::DAB_Test_ModeData::mBg_FIC
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Test_ModeData, mBg_FIC)
    },
    {   // 505 - ::DAB_Test_ModeData::mAudio_Mode
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Test_ModeData, mAudio_Mode)
    },
    {   // 506 - ::DAB_Test_ModeData::mFreq_Table
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Test_ModeData, mFreq_Table)
    },
    {   // 507 - ::DAB_Test_ModeData::mBGMode
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Test_ModeData, mBGMode)
    },
    {   // 508 - ::DAB_Test_ModeData::mBGSync_flag
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Test_ModeData, mBGSync_flag)
    },
    {   // 509 - ::DAB_Test_ModeData::mTASrc
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Test_ModeData, mTASrc)
    },
    {   // 510 - ::DAB_Setup_Screen_ActiveTuner_InfoData
        COURIER_DATA_ITEM_TYPE_ID(::DAB_Setup_Screen_ActiveTuner_InfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 511 - ::DAB_Setup_Screen_ActiveTuner_InfoData::mDRC
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Setup_Screen_ActiveTuner_InfoData, mDRC)
    },
    {   // 512 - ::DAB_Setup_Screen_ActiveTuner_InfoData::mPS
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Setup_Screen_ActiveTuner_InfoData, mPS)
    },
    {   // 513 - ::DAB_Setup_Screen_ActiveTuner_InfoData::mSM_ACC
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Setup_Screen_ActiveTuner_InfoData, mSM_ACC)
    },
    {   // 514 - ::DAB_Setup_Screen_ActiveTuner_InfoData::mSR
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Setup_Screen_ActiveTuner_InfoData, mSR)
    },
    {   // 515 - ::DAB_Setup_Screen_ActiveTuner_InfoData::mTP
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Setup_Screen_ActiveTuner_InfoData, mTP)
    },
    {   // 516 - ::DABTestModeEnsembleInfoData
        COURIER_DATA_ITEM_TYPE_ID(::DABTestModeEnsembleInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 517 - ::DABTestModeEnsembleInfoData::mNoOfAud_DataServiceComp
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DABTestModeEnsembleInfoData, mNoOfAud_DataServiceComp)
    },
    {   // 518 - ::DABTestModeEnsembleInfoData::mNoOfAud_DataService
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DABTestModeEnsembleInfoData, mNoOfAud_DataService)
    },
    {   // 519 - ::DABTestModeEnsembleInfoData::mNoOfEnsembles
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DABTestModeEnsembleInfoData, mNoOfEnsembles)
    },
    {   // 520 - ::DABGTestModeInfoData
        COURIER_DATA_ITEM_TYPE_ID(::DABGTestModeInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 521 - ::DABGTestModeInfoData::mFM
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DABGTestModeInfoData, mFM)
    },
    {   // 522 - ::DABGTestModeInfoData::mPI
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DABGTestModeInfoData, mPI)
    },
    {   // 523 - ::DABGTestModeInfoData::mQFM
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DABGTestModeInfoData, mQFM)
    },
    {   // 524 - ::DABGTestModeInfoData::mPL
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DABGTestModeInfoData, mPL)
    },
    {   // 525 - ::DABGTestModeAnnoStatusInfoData
        COURIER_DATA_ITEM_TYPE_ID(::DABGTestModeAnnoStatusInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 526 - ::DABGTestModeAnnoStatusInfoData::mASW
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DABGTestModeAnnoStatusInfoData, mASW)
    },
    {   // 527 - ::DABGTestModeAnnoStatusInfoData::mASU
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DABGTestModeAnnoStatusInfoData, mASU)
    },
    {   // 528 - ::DABGTestModeActiveCompData
        COURIER_DATA_ITEM_TYPE_ID(::DABGTestModeActiveCompData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 529 - ::DABGTestModeActiveCompData::mSC
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DABGTestModeActiveCompData, mSC)
    },
    {   // 530 - ::DABGTestModeActiveCompData::mSCType
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DABGTestModeActiveCompData, mSCType)
    },
    {   // 531 - ::DABTestModeGAvailabiltyInfoData
        COURIER_DATA_ITEM_TYPE_ID(::DABTestModeGAvailabiltyInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 532 - ::DABTestModeGAvailabiltyInfoData::mTA
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DABTestModeGAvailabiltyInfoData, mTA)
    },
    {   // 533 - ::DABTestModeGAvailabiltyInfoData::mIndicator
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DABTestModeGAvailabiltyInfoData, mIndicator)
    },
    {   // 534 - ::DABTestModeGAvailabiltyInfoData::mDABDAB
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DABTestModeGAvailabiltyInfoData, mDABDAB)
    },
    {   // 535 - ::DABTestModeServiceFollowingInfoData
        COURIER_DATA_ITEM_TYPE_ID(::DABTestModeServiceFollowingInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 536 - ::DABTestModeServiceFollowingInfoData::mTSU
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DABTestModeServiceFollowingInfoData, mTSU)
    },
    {   // 537 - ::TmcInformationDataData
        COURIER_DATA_ITEM_TYPE_ID(::TmcInformationDataData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 538 - ::TmcInformationDataData::mNumberOfMsg
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::TmcInformationDataData, mNumberOfMsg)
    },
    {   // 539 - ::TmcInformationDataData::mSelectedMsg
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::TmcInformationDataData, mSelectedMsg)
    },
    {   // 540 - ::TmcInformationDataData::mLastMsgRecd
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::TmcInformationDataData, mLastMsgRecd)
    },
    {   // 541 - ::TmcStationInfoDataData
        COURIER_DATA_ITEM_TYPE_ID(::TmcStationInfoDataData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 542 - ::TmcStationInfoDataData::mPS
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::TmcStationInfoDataData, mPS)
    },
    {   // 543 - ::TmcStationInfoDataData::mPI
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::TmcStationInfoDataData, mPI)
    },
    {   // 544 - ::TmcStationInfoDataData::mCC
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::TmcStationInfoDataData, mCC)
    },
    {   // 545 - ::TmcStationInfoDataData::mSID
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::TmcStationInfoDataData, mSID)
    },
    {   // 546 - ::TmcStationInfoDataData::mLTN
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::TmcStationInfoDataData, mLTN)
    },
    {   // 547 - ::TmcStationInfoDataData::mQuality
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::TmcStationInfoDataData, mQuality)
    },
    {   // 548 - ::TestModeAvailabilityInfoData
        COURIER_DATA_ITEM_TYPE_ID(::TestModeAvailabilityInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 549 - ::TestModeAvailabilityInfoData::mFMTestModeAvail
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::TestModeAvailabilityInfoData, mFMTestModeAvail)
    },
    {   // 550 - ::TestModeAvailabilityInfoData::mDABTestModeAvail
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::TestModeAvailabilityInfoData, mDABTestModeAvail)
    },
    {   // 551 - ::FMSetupMenuInfoData
        COURIER_DATA_ITEM_TYPE_ID(::FMSetupMenuInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 552 - ::FMSetupMenuInfoData::mToggleAF
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::FMSetupMenuInfoData, mToggleAF)
    },
    {   // 553 - ::FMSetupMenuInfoData::mToggleMM
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::FMSetupMenuInfoData, mToggleMM)
    },
    {   // 554 - ::FMSetupMenuInfoData::mToggleTA_status
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::FMSetupMenuInfoData, mToggleTA_status)
    },
    {   // 555 - ::FMSetupMenuInfoData::mToggleRDS
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::FMSetupMenuInfoData, mToggleRDS)
    },
    {   // 556 - ::FMSetupMenuInfoData::mTogglePhaseDiversity
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::FMSetupMenuInfoData, mTogglePhaseDiversity)
    },
    {   // 557 - ::NextPrevious_Status_FMData
        COURIER_DATA_ITEM_TYPE_ID(::NextPrevious_Status_FMData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 558 - ::NextPrevious_Status_FMData::mIsNextActive_FM
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::NextPrevious_Status_FMData, mIsNextActive_FM)
    },
    {   // 559 - ::NextPrevious_Status_FMData::mIsPreviousActive_FM
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::NextPrevious_Status_FMData, mIsPreviousActive_FM)
    },
    {   // 560 - ::NextPrevious_Status_AMData
        COURIER_DATA_ITEM_TYPE_ID(::NextPrevious_Status_AMData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 561 - ::NextPrevious_Status_AMData::mIsNextActive_AM
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::NextPrevious_Status_AMData, mIsNextActive_AM)
    },
    {   // 562 - ::NextPrevious_Status_AMData::mIsPreviousActive_AM
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::NextPrevious_Status_AMData, mIsPreviousActive_AM)
    },
    {   // 563 - ::NextPrevious_Status_DABData
        COURIER_DATA_ITEM_TYPE_ID(::NextPrevious_Status_DABData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 564 - ::NextPrevious_Status_DABData::mIsNextActive_DAB
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::NextPrevious_Status_DABData, mIsNextActive_DAB)
    },
    {   // 565 - ::NextPrevious_Status_DABData::mIsPreviousActive_DAB
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::NextPrevious_Status_DABData, mIsPreviousActive_DAB)
    },
    {   // 566 - ::SearchNextPrevious_IconActiveData
        COURIER_DATA_ITEM_TYPE_ID(::SearchNextPrevious_IconActiveData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 567 - ::SearchNextPrevious_IconActiveData::mIsNextIconActive
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SearchNextPrevious_IconActiveData, mIsNextIconActive)
    },
    {   // 568 - ::SearchNextPrevious_IconActiveData::mIsPreviousIconActive
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SearchNextPrevious_IconActiveData, mIsPreviousIconActive)
    },
    {   // 569 - ::AMFMLogoImageData
        COURIER_DATA_ITEM_TYPE_ID(::AMFMLogoImageData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 570 - ::AMFMLogoImageData::mAMFMLogo
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::AMFMLogoImageData, mAMFMLogo)
    },
    {   // 571 - ::AMFMLogoImageData::mAMFMDefalutLogo
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::AMFMLogoImageData, mAMFMDefalutLogo)
    },
    {   // 572 - ::AMFMLogoImageData::mAMFMLogoVisibility
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::AMFMLogoImageData, mAMFMLogoVisibility)
    },
    {   // 573 - ::ChannelInfoData
        COURIER_DATA_ITEM_TYPE_ID(::ChannelInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 574 - ::ChannelInfoData::mAdvisoryText
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::ChannelInfoData, mAdvisoryText)
    },
    {   // 575 - ::ChannelInfoData::mArtist
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::ChannelInfoData, mArtist)
    },
    {   // 576 - ::ChannelInfoData::mAlbum
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::ChannelInfoData, mAlbum)
    },
    {   // 577 - ::ChannelInfoData::mTrack
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::ChannelInfoData, mTrack)
    },
    {   // 578 - ::ChannelInfoData::mArtistAlbumSwitch
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt8),
        COURIER_ITEM_MEMBER(::ChannelInfoData, mArtistAlbumSwitch)
    },
    {   // 579 - ::ChannelInfoData::mIsBallGameModeVisible
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::ChannelInfoData, mIsBallGameModeVisible)
    },
    {   // 580 - ::ChannelInfoData::mCategory
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::ChannelInfoData, mCategory)
    },
    {   // 581 - ::FmHdLogoData
        COURIER_DATA_ITEM_TYPE_ID(::FmHdLogoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 582 - ::FmHdLogoData::mFmHdLogoIndex
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt8),
        COURIER_ITEM_MEMBER(::FmHdLogoData, mFmHdLogoIndex)
    },
    {   // 583 - ::AmHdLogoData
        COURIER_DATA_ITEM_TYPE_ID(::AmHdLogoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 584 - ::AmHdLogoData::mAmHdLogoIndex
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt8),
        COURIER_ITEM_MEMBER(::AmHdLogoData, mAmHdLogoIndex)
    },
    {   // 585 - ::HDButtonVisibilityData
        COURIER_DATA_ITEM_TYPE_ID(::HDButtonVisibilityData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 586 - ::HDButtonVisibilityData::misHdVisible
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::HDButtonVisibilityData, misHdVisible)
    },
    {   // 587 - ::AmHdOnOffData
        COURIER_DATA_ITEM_TYPE_ID(::AmHdOnOffData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 588 - ::AmHdOnOffData::mIsActive
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::AmHdOnOffData, mIsActive)
    },
    {   // 589 - ::FmHdOnOffData
        COURIER_DATA_ITEM_TYPE_ID(::FmHdOnOffData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 590 - ::FmHdOnOffData::mIsActive
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::FmHdOnOffData, mIsActive)
    },
    {   // 591 - ::HDProgramListVisibilityData
        COURIER_DATA_ITEM_TYPE_ID(::HDProgramListVisibilityData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 592 - ::HDProgramListVisibilityData::misHdProgramListVisible
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::HDProgramListVisibilityData, misHdProgramListVisible)
    },
    {   // 593 - ::HDAudioMPSData
        COURIER_DATA_ITEM_TYPE_ID(::HDAudioMPSData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 594 - ::HDAudioMPSData::mHD_Prog_MPS_switch
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt32),
        COURIER_ITEM_MEMBER(::HDAudioMPSData, mHD_Prog_MPS_switch)
    },
    {   // 595 - ::HDAudioMPSData::mHD_Prog_MPS_size
        COURIER_DATA_ITEM_TYPE_ID(Candera::Vector2),
        COURIER_ITEM_MEMBER(::HDAudioMPSData, mHD_Prog_MPS_size)
    },
    {   // 596 - ::HDAudioSPS1Data
        COURIER_DATA_ITEM_TYPE_ID(::HDAudioSPS1Data),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 597 - ::HDAudioSPS1Data::mHD_Prog_SPS1_switch
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt32),
        COURIER_ITEM_MEMBER(::HDAudioSPS1Data, mHD_Prog_SPS1_switch)
    },
    {   // 598 - ::HDAudioSPS1Data::mHD_Prog_SPS1_size
        COURIER_DATA_ITEM_TYPE_ID(Candera::Vector2),
        COURIER_ITEM_MEMBER(::HDAudioSPS1Data, mHD_Prog_SPS1_size)
    },
    {   // 599 - ::HDAudioSPS2Data
        COURIER_DATA_ITEM_TYPE_ID(::HDAudioSPS2Data),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 600 - ::HDAudioSPS2Data::mHD_Prog_SPS2_switch
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt32),
        COURIER_ITEM_MEMBER(::HDAudioSPS2Data, mHD_Prog_SPS2_switch)
    },
    {   // 601 - ::HDAudioSPS2Data::mHD_Prog_SPS2_size
        COURIER_DATA_ITEM_TYPE_ID(Candera::Vector2),
        COURIER_ITEM_MEMBER(::HDAudioSPS2Data, mHD_Prog_SPS2_size)
    },
    {   // 602 - ::HDAudioSPS3Data
        COURIER_DATA_ITEM_TYPE_ID(::HDAudioSPS3Data),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 603 - ::HDAudioSPS3Data::mHD_Prog_SPS3_switch
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt32),
        COURIER_ITEM_MEMBER(::HDAudioSPS3Data, mHD_Prog_SPS3_switch)
    },
    {   // 604 - ::HDAudioSPS3Data::mHD_Prog_SPS3_size
        COURIER_DATA_ITEM_TYPE_ID(Candera::Vector2),
        COURIER_ITEM_MEMBER(::HDAudioSPS3Data, mHD_Prog_SPS3_size)
    },
    {   // 605 - ::HDAudioSPS4Data
        COURIER_DATA_ITEM_TYPE_ID(::HDAudioSPS4Data),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 606 - ::HDAudioSPS4Data::mHD_Prog_SPS4_switch
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt32),
        COURIER_ITEM_MEMBER(::HDAudioSPS4Data, mHD_Prog_SPS4_switch)
    },
    {   // 607 - ::HDAudioSPS4Data::mHD_Prog_SPS4_size
        COURIER_DATA_ITEM_TYPE_ID(Candera::Vector2),
        COURIER_ITEM_MEMBER(::HDAudioSPS4Data, mHD_Prog_SPS4_size)
    },
    {   // 608 - ::HDAudioSPS5Data
        COURIER_DATA_ITEM_TYPE_ID(::HDAudioSPS5Data),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 609 - ::HDAudioSPS5Data::mHD_Prog_SPS5_switch
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt32),
        COURIER_ITEM_MEMBER(::HDAudioSPS5Data, mHD_Prog_SPS5_switch)
    },
    {   // 610 - ::HDAudioSPS5Data::mHD_Prog_SPS5_size
        COURIER_DATA_ITEM_TYPE_ID(Candera::Vector2),
        COURIER_ITEM_MEMBER(::HDAudioSPS5Data, mHD_Prog_SPS5_size)
    },
    {   // 611 - ::HDAudioSPS6Data
        COURIER_DATA_ITEM_TYPE_ID(::HDAudioSPS6Data),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 612 - ::HDAudioSPS6Data::mHD_Prog_SPS6_switch
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt32),
        COURIER_ITEM_MEMBER(::HDAudioSPS6Data, mHD_Prog_SPS6_switch)
    },
    {   // 613 - ::HDAudioSPS6Data::mHD_Prog_SPS6_size
        COURIER_DATA_ITEM_TYPE_ID(Candera::Vector2),
        COURIER_ITEM_MEMBER(::HDAudioSPS6Data, mHD_Prog_SPS6_size)
    },
    {   // 614 - ::HDAudioSPS7Data
        COURIER_DATA_ITEM_TYPE_ID(::HDAudioSPS7Data),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 615 - ::HDAudioSPS7Data::mHD_Prog_SPS7_switch
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt32),
        COURIER_ITEM_MEMBER(::HDAudioSPS7Data, mHD_Prog_SPS7_switch)
    },
    {   // 616 - ::HDAudioSPS7Data::mHD_Prog_SPS7_size
        COURIER_DATA_ITEM_TYPE_ID(Candera::Vector2),
        COURIER_ITEM_MEMBER(::HDAudioSPS7Data, mHD_Prog_SPS7_size)
    },
    {   // 617 - ::HDIconPreset1Data
        COURIER_DATA_ITEM_TYPE_ID(::HDIconPreset1Data),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 618 - ::HDIconPreset1Data::mHD_Preset_1
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt32),
        COURIER_ITEM_MEMBER(::HDIconPreset1Data, mHD_Preset_1)
    },
    {   // 619 - ::HDIconPreset1Data::mHD_Preset_1_value
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::HDIconPreset1Data, mHD_Preset_1_value)
    },
    {   // 620 - ::HDIconPreset2Data
        COURIER_DATA_ITEM_TYPE_ID(::HDIconPreset2Data),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 621 - ::HDIconPreset2Data::mHD_Preset_2
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt32),
        COURIER_ITEM_MEMBER(::HDIconPreset2Data, mHD_Preset_2)
    },
    {   // 622 - ::HDIconPreset2Data::mHD_Preset_2_value
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::HDIconPreset2Data, mHD_Preset_2_value)
    },
    {   // 623 - ::HDIconPreset3Data
        COURIER_DATA_ITEM_TYPE_ID(::HDIconPreset3Data),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 624 - ::HDIconPreset3Data::mHD_Preset_3
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt32),
        COURIER_ITEM_MEMBER(::HDIconPreset3Data, mHD_Preset_3)
    },
    {   // 625 - ::HDIconPreset3Data::mHD_Preset_3_value
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::HDIconPreset3Data, mHD_Preset_3_value)
    },
    {   // 626 - ::HDIconPreset4Data
        COURIER_DATA_ITEM_TYPE_ID(::HDIconPreset4Data),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 627 - ::HDIconPreset4Data::mHD_Preset_4
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt32),
        COURIER_ITEM_MEMBER(::HDIconPreset4Data, mHD_Preset_4)
    },
    {   // 628 - ::HDIconPreset4Data::mHD_Preset_4_value
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::HDIconPreset4Data, mHD_Preset_4_value)
    },
    {   // 629 - ::HDIconPreset5Data
        COURIER_DATA_ITEM_TYPE_ID(::HDIconPreset5Data),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 630 - ::HDIconPreset5Data::mHD_Preset_5
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt32),
        COURIER_ITEM_MEMBER(::HDIconPreset5Data, mHD_Preset_5)
    },
    {   // 631 - ::HDIconPreset5Data::mHD_Preset_5_value
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::HDIconPreset5Data, mHD_Preset_5_value)
    },
    {   // 632 - ::HDIconPreset6Data
        COURIER_DATA_ITEM_TYPE_ID(::HDIconPreset6Data),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 633 - ::HDIconPreset6Data::mHD_Preset_6
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt32),
        COURIER_ITEM_MEMBER(::HDIconPreset6Data, mHD_Preset_6)
    },
    {   // 634 - ::HDIconPreset6Data::mHD_Preset_6_value
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::HDIconPreset6Data, mHD_Preset_6_value)
    },
    {   // 635 - ::HDIconPreset7Data
        COURIER_DATA_ITEM_TYPE_ID(::HDIconPreset7Data),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 636 - ::HDIconPreset7Data::mHD_Preset_7
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt32),
        COURIER_ITEM_MEMBER(::HDIconPreset7Data, mHD_Preset_7)
    },
    {   // 637 - ::HDIconPreset7Data::mHD_Preset_7_value
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::HDIconPreset7Data, mHD_Preset_7_value)
    },
    {   // 638 - ::HDIconPreset8Data
        COURIER_DATA_ITEM_TYPE_ID(::HDIconPreset8Data),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 639 - ::HDIconPreset8Data::mHD_Preset_8
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt32),
        COURIER_ITEM_MEMBER(::HDIconPreset8Data, mHD_Preset_8)
    },
    {   // 640 - ::HDIconPreset8Data::mHD_Preset_8_value
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::HDIconPreset8Data, mHD_Preset_8_value)
    },
    {   // 641 - ::HDIconPreset9Data
        COURIER_DATA_ITEM_TYPE_ID(::HDIconPreset9Data),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 642 - ::HDIconPreset9Data::mHD_Preset_9
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt32),
        COURIER_ITEM_MEMBER(::HDIconPreset9Data, mHD_Preset_9)
    },
    {   // 643 - ::HDIconPreset9Data::mHD_Preset_9_value
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::HDIconPreset9Data, mHD_Preset_9_value)
    },
    {   // 644 - ::HDIconPreset10Data
        COURIER_DATA_ITEM_TYPE_ID(::HDIconPreset10Data),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 645 - ::HDIconPreset10Data::mHD_Preset_10
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt32),
        COURIER_ITEM_MEMBER(::HDIconPreset10Data, mHD_Preset_10)
    },
    {   // 646 - ::HDIconPreset10Data::mHD_Preset_10_value
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::HDIconPreset10Data, mHD_Preset_10_value)
    },
    {   // 647 - ::HDIconPreset11Data
        COURIER_DATA_ITEM_TYPE_ID(::HDIconPreset11Data),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 648 - ::HDIconPreset11Data::mHD_Preset_11
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt32),
        COURIER_ITEM_MEMBER(::HDIconPreset11Data, mHD_Preset_11)
    },
    {   // 649 - ::HDIconPreset11Data::mHD_Preset_11_value
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::HDIconPreset11Data, mHD_Preset_11_value)
    },
    {   // 650 - ::HDIconPreset12Data
        COURIER_DATA_ITEM_TYPE_ID(::HDIconPreset12Data),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 651 - ::HDIconPreset12Data::mHD_Preset_12
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt32),
        COURIER_ITEM_MEMBER(::HDIconPreset12Data, mHD_Preset_12)
    },
    {   // 652 - ::HDIconPreset12Data::mHD_Preset_12_value
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::HDIconPreset12Data, mHD_Preset_12_value)
    },
    {   // 653 - ::DtmHDData
        COURIER_DATA_ITEM_TYPE_ID(::DtmHDData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 654 - ::DtmHDData::mHDStatus
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DtmHDData, mHDStatus)
    },
    {   // 655 - ::DtmHDData::mSISStatus
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DtmHDData, mSISStatus)
    },
    {   // 656 - ::DtmHDData::mAUDStatus
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DtmHDData, mAUDStatus)
    },
    {   // 657 - ::DtmHDData::mBlendStatus
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DtmHDData, mBlendStatus)
    },
    {   // 658 - ::DtmHDData::mHDCallSign
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DtmHDData, mHDCallSign)
    },
    {   // 659 - ::DtmHDData::mHD10Freq
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DtmHDData, mHD10Freq)
    },
    {   // 660 - ::DtmHDData::mHD10FST
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DtmHDData, mHD10FST)
    },
    {   // 661 - ::DtmHDData::mHD10CdNo
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DtmHDData, mHD10CdNo)
    },
    {   // 662 - ::DtmHDData::mHD10AudQual
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DtmHDData, mHD10AudQual)
    },
    {   // 663 - ::DtmHDData::mHD05Freq
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DtmHDData, mHD05Freq)
    },
    {   // 664 - ::DtmHDData::mHD05FST
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DtmHDData, mHD05FST)
    },
    {   // 665 - ::DtmHDData::mHD05CdNo
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DtmHDData, mHD05CdNo)
    },
    {   // 666 - ::DtmHDData::mTransitions
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DtmHDData, mTransitions)
    },
    {   // 667 - ::HDParamTuningIconData
        COURIER_DATA_ITEM_TYPE_ID(::HDParamTuningIconData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 668 - ::HDParamTuningIconData::mHD_Icon
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::HDParamTuningIconData, mHD_Icon)
    },
    {   // 669 - ::TMHDAudioMPSData
        COURIER_DATA_ITEM_TYPE_ID(::TMHDAudioMPSData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 670 - ::TMHDAudioMPSData::mTMHD_Prog_MPS_switch
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt32),
        COURIER_ITEM_MEMBER(::TMHDAudioMPSData, mTMHD_Prog_MPS_switch)
    },
    {   // 671 - ::TMHDAudioMPSData::mTMHD_Prog_MPS_available
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt32),
        COURIER_ITEM_MEMBER(::TMHDAudioMPSData, mTMHD_Prog_MPS_available)
    },
    {   // 672 - ::TMHDAudioSPS1Data
        COURIER_DATA_ITEM_TYPE_ID(::TMHDAudioSPS1Data),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 673 - ::TMHDAudioSPS1Data::mTMHD_Prog_SPS1_switch
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt32),
        COURIER_ITEM_MEMBER(::TMHDAudioSPS1Data, mTMHD_Prog_SPS1_switch)
    },
    {   // 674 - ::TMHDAudioSPS1Data::mTMHD_Prog_SPS1_available
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt32),
        COURIER_ITEM_MEMBER(::TMHDAudioSPS1Data, mTMHD_Prog_SPS1_available)
    },
    {   // 675 - ::TMHDAudioSPS2Data
        COURIER_DATA_ITEM_TYPE_ID(::TMHDAudioSPS2Data),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 676 - ::TMHDAudioSPS2Data::mTMHD_Prog_SPS2_switch
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt32),
        COURIER_ITEM_MEMBER(::TMHDAudioSPS2Data, mTMHD_Prog_SPS2_switch)
    },
    {   // 677 - ::TMHDAudioSPS2Data::mTMHD_Prog_SPS2_available
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt32),
        COURIER_ITEM_MEMBER(::TMHDAudioSPS2Data, mTMHD_Prog_SPS2_available)
    },
    {   // 678 - ::TMHDAudioSPS3Data
        COURIER_DATA_ITEM_TYPE_ID(::TMHDAudioSPS3Data),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 679 - ::TMHDAudioSPS3Data::mTMHD_Prog_SPS3_switch
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt32),
        COURIER_ITEM_MEMBER(::TMHDAudioSPS3Data, mTMHD_Prog_SPS3_switch)
    },
    {   // 680 - ::TMHDAudioSPS3Data::mTMHD_Prog_SPS3_available
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt32),
        COURIER_ITEM_MEMBER(::TMHDAudioSPS3Data, mTMHD_Prog_SPS3_available)
    },
    {   // 681 - ::TMHDAudioSPS4Data
        COURIER_DATA_ITEM_TYPE_ID(::TMHDAudioSPS4Data),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 682 - ::TMHDAudioSPS4Data::mTMHD_Prog_SPS4_switch
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt32),
        COURIER_ITEM_MEMBER(::TMHDAudioSPS4Data, mTMHD_Prog_SPS4_switch)
    },
    {   // 683 - ::TMHDAudioSPS4Data::mTMHD_Prog_SPS4_available
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt32),
        COURIER_ITEM_MEMBER(::TMHDAudioSPS4Data, mTMHD_Prog_SPS4_available)
    },
    {   // 684 - ::TMHDAudioSPS5Data
        COURIER_DATA_ITEM_TYPE_ID(::TMHDAudioSPS5Data),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 685 - ::TMHDAudioSPS5Data::mTMHD_Prog_SPS5_switch
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt32),
        COURIER_ITEM_MEMBER(::TMHDAudioSPS5Data, mTMHD_Prog_SPS5_switch)
    },
    {   // 686 - ::TMHDAudioSPS5Data::mTMHD_Prog_SPS5_available
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt32),
        COURIER_ITEM_MEMBER(::TMHDAudioSPS5Data, mTMHD_Prog_SPS5_available)
    },
    {   // 687 - ::TMHDAudioSPS6Data
        COURIER_DATA_ITEM_TYPE_ID(::TMHDAudioSPS6Data),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 688 - ::TMHDAudioSPS6Data::mTMHD_Prog_SPS6_switch
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt32),
        COURIER_ITEM_MEMBER(::TMHDAudioSPS6Data, mTMHD_Prog_SPS6_switch)
    },
    {   // 689 - ::TMHDAudioSPS6Data::mTMHD_Prog_SPS6_available
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt32),
        COURIER_ITEM_MEMBER(::TMHDAudioSPS6Data, mTMHD_Prog_SPS6_available)
    },
    {   // 690 - ::TMHDAudioSPS7Data
        COURIER_DATA_ITEM_TYPE_ID(::TMHDAudioSPS7Data),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 691 - ::TMHDAudioSPS7Data::mTMHD_Prog_SPS7_switch
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt32),
        COURIER_ITEM_MEMBER(::TMHDAudioSPS7Data, mTMHD_Prog_SPS7_switch)
    },
    {   // 692 - ::TMHDAudioSPS7Data::mTMHD_Prog_SPS7_available
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt32),
        COURIER_ITEM_MEMBER(::TMHDAudioSPS7Data, mTMHD_Prog_SPS7_available)
    },
    {   // 693 - ::RdsRadioTextData
        COURIER_DATA_ITEM_TYPE_ID(::RdsRadioTextData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 694 - ::RdsRadioTextData::mText
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::RdsRadioTextData, mText)
    },
    {   // 695 - ::HomeScreenFmHdLogoData
        COURIER_DATA_ITEM_TYPE_ID(::HomeScreenFmHdLogoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 696 - ::HomeScreenFmHdLogoData::mHomeScreen_FmHdLogo
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt8),
        COURIER_ITEM_MEMBER(::HomeScreenFmHdLogoData, mHomeScreen_FmHdLogo)
    },
    {   // 697 - ::HomeScreenAmHdLogoData
        COURIER_DATA_ITEM_TYPE_ID(::HomeScreenAmHdLogoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 698 - ::HomeScreenAmHdLogoData::mHomeScreen_AmHdLogo
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt8),
        COURIER_ITEM_MEMBER(::HomeScreenAmHdLogoData, mHomeScreen_AmHdLogo)
    },
    {   // 699 - ::SPIVisibilityTunerData
        COURIER_DATA_ITEM_TYPE_ID(::SPIVisibilityTunerData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 700 - ::SPIVisibilityTunerData::mSPIIsvisibleTuner
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SPIVisibilityTunerData, mSPIIsvisibleTuner)
    },
    {   // 701 - ::SPIVisibilityTunerData::mSPIIsvisibleTunerFMTuner
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SPIVisibilityTunerData, mSPIIsvisibleTunerFMTuner)
    },
    {   // 702 - ::ListScrollBarInfoData
        COURIER_DATA_ITEM_TYPE_ID(::ListScrollBarInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 703 - ::ListScrollBarInfoData::mEnabled
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::ListScrollBarInfoData, mEnabled)
    },
};

// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gInvalidHierarchyNodes[InvalidDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x00000000, /Invalid),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 0,
        /* mParentIndex        */ 0,    // ItemKey::InvalidItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 0,    // ::InvalidData
        /* mItemKey            */ 0
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gCheckBoxListItemHierarchyNodes[CheckBoxListItemDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD3928E76, /CheckBoxListItem),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::CheckBoxListItemItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 1,    // ::CheckBoxListItemData
        /* mItemKey            */ 588
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE1ED37DF, /CheckBoxListItem/ListItemName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::CheckBoxListItemItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 2,    // ::CheckBoxListItemData::mListItemName
        /* mItemKey            */ 624
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB03A6D2C, /CheckBoxListItem/ToggleIconSwitchIndex),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::CheckBoxListItemItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 3,    // ::CheckBoxListItemData::mToggleIconSwitchIndex
        /* mItemKey            */ 496
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gStationInfoSourceHierarchyNodes[StationInfoSourceDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xAD12D276, /StationInfoSource),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 2,
        /* mParentIndex        */ 0,    // ItemKey::StationInfoSourceItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 4,    // ::StationInfoSourceData
        /* mItemKey            */ 486
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3D25BA35, /StationInfoSource/PSName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 2,
        /* mParentIndex   