/************************************************************************
*FILE: AppHmi_TunerDatabinding.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(AppHmi_TunerDatabinding_h)
#define AppHmi_TunerDatabinding_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <CanderaWidget/String/String.h>
#include <Candera/Engine2D/Core/Image2D.h>

// =========================================================================
struct CheckBoxListItemData {
    Candera::String mListItemName;
    Courier::UInt8 mToggleIconSwitchIndex;

    CheckBoxListItemData();
};

// =========================================================================
struct StationInfoSourceData {
    Candera::String mPSName;
    Candera::String mAMPSName;
    Candera::String mAMFrequency;
    Candera::String mFMFrequency;
    Candera::String mDRMFrequency;
    Candera::String mRadioText;
    Candera::String mUnit;
    Candera::String mViewName;
    bool mTPInfo;
    bool mDabTPInfo;
    bool mCurrentStationTPInfo;
    bool mVisible_Txt_Wgt_RDS;
    bool mVisible_Txt_Wgt_NoRDS;
    bool mVisible_Txt_Wgt_Navi;
    bool mVisible_Txt_Wgt_EU;
    bool mVariant_Type;
    bool mVariant_Type_NonEU;
    Candera::String mTA_SourcePSName;
    Candera::String mDRM_ServiceLabel;
    Candera::String mDRMStatus;
    bool mVisible_DRMService;
    bool mVisible_DRMRadioText;
    bool mVisible_DRMFrequency;
    Candera::String mDRMPTY;
    bool mIcon_station;
    Candera::UInt32 mDAB_Icon_station;

    StationInfoSourceData();
};

// =========================================================================
struct HomeScreenInfoData {
    Candera::UInt32 mHomeScreen_ActiveIconIndex;
    Candera::String mHomeScreen_ActiveSourceText;
    Candera::String mHomeScreen_DABServiceName;
    bool mHomeScreen_ScanInvisible;
    bool mHomeScreen_DABServicevisiblity;
    bool mHomeScreen_MuteIconStatus;
    Candera::String mHomeFrequency;
    bool mHomeScreen_PACStatus;
    Candera::String mHomeWeatherbandText;
    Candera::String mFrequencyUnit;
    bool mHomeScreen_NextPreviousIconStatus;
    Candera::String mHomeFrequencyStationName;
    bool mHomeFrequencyStationNameVisibility;

    HomeScreenInfoData();
};

// =========================================================================
struct RadioBandInfoData {
    bool mVisible_Txt_Wgt_Band;
    bool mVisible_Txt_Wgt_Mute;
    bool mVisible_Txt_Wgt_TA;
    bool mVisible_Txt_Wgt_TA_In_AM;
    Candera::String mImage_TA;
    bool mVisible_Txt_Wgt_TA_FM;
    bool mVisible_Txt_Wgt_TA_DAB;

    RadioBandInfoData();
};

// =========================================================================
struct FMStationListData {
    Candera::UInt32 mpresetnumber;
    Candera::String mstation_name;
    Candera::String mTraffic_program;

    FMStationListData();
};

// =========================================================================
struct RDSOptionsData {
    bool mVisible_TA_Icon;
    bool mVisible_TA_Icon_Cross;
    bool mVisible_TA;
    bool mVisible_RadioText;
    bool mVisible_AF;
    bool mVisible_Reg;
    bool mVisible_DRMAFS;

    RDSOptionsData();
};

// =========================================================================
struct PresetInfoWBData {
    Candera::String mWBName1;
    Candera::String mWBName2;
    Candera::String mWBName3;
    Candera::String mWBName4;
    Candera::String mWBName5;
    Candera::String mWBName6;
    Candera::String mWBName7;
    Candera::String mWBName8;
    Candera::String mWBName9;
    Candera::String mWBName10;
    Candera::String mWBmode;
    Candera::String mWBFrequency;

    PresetInfoWBData();
};

// =========================================================================
struct WBPresetInfoData {
    bool mPreset_1_Active;
    bool mPreset_2_Active;
    bool mPreset_3_Active;
    bool mPreset_4_Active;
    bool mPreset_5_Active;
    bool mPreset_6_Active;
    bool mPreset_7_Active;
    bool mPreset_8_Active;
    bool mPreset_9_Active;
    bool mPreset_10_Active;

    WBPresetInfoData();
};

// =========================================================================
struct PresetInfoFM1Data {
    Candera::String mPSName1;
    Candera::String mPSName2;
    Candera::String mPSName3;
    Candera::String mPSName4;
    Candera::String mPSName5;
    Candera::String mPSName6;

    PresetInfoFM1Data();
};

// =========================================================================
struct PresetInfoFM2Data {
    Candera::String mPSName1;
    Candera::String mPSName2;
    Candera::String mPSName3;
    Candera::String mPSName4;
    Candera::String mPSName5;
    Candera::String mPSName6;

    PresetInfoFM2Data();
};

// =========================================================================
struct PresetInfoFMASTData {
    Candera::String mPSName1;
    Candera::String mPSName2;
    Candera::String mPSName3;
    Candera::String mPSName4;
    Candera::String mPSName5;
    Candera::String mPSName6;

    PresetInfoFMASTData();
};

// =========================================================================
struct PresetInfoAMData {
    Candera::String mPSName1;
    Candera::String mPSName2;
    Candera::String mPSName3;
    Candera::String mPSName4;
    Candera::String mPSName5;
    Candera::String mPSName6;
    Candera::String mPSName7;
    Candera::String mPSName8;
    Candera::String mPSName9;
    Candera::String mPSName10;
    Candera::String mPSName11;
    Candera::String mPSName12;

    PresetInfoAMData();
};

// =========================================================================
struct PresetInfoAMASTData {
    Candera::String mPSName1;
    Candera::String mPSName2;
    Candera::String mPSName3;
    Candera::String mPSName4;
    Candera::String mPSName5;
    Candera::String mPSName6;

    PresetInfoAMASTData();
};

// =========================================================================
struct PresetInfoDABData {
    Candera::String mPSName1;
    Candera::String mPSName2;
    Candera::String mPSName3;
    Candera::String mPSName4;
    Candera::String mPSName5;
    Candera::String mPSName6;
    Candera::String mPSName7;
    Candera::String mPSName8;
    Candera::String mPSName9;
    Candera::String mPSName10;
    Candera::String mPSName11;
    Candera::String mPSName12;

    PresetInfoDABData();
};

// =========================================================================
struct PresetInfoDABASTData {
    Candera::String mPSName1;
    Candera::String mPSName2;
    Candera::String mPSName3;
    Candera::String mPSName4;
    Candera::String mPSName5;
    Candera::String mPSName6;

    PresetInfoDABASTData();
};

// =========================================================================
struct PresetInfoDRMData {
    Candera::String mPSName1;
    Candera::String mPSName2;
    Candera::String mPSName3;
    Candera::String mPSName4;
    Candera::String mPSName5;
    Candera::String mPSName6;

    PresetInfoDRMData();
};

// =========================================================================
struct PresetInfoDRMASTData {
    Candera::String mPSName1;
    Candera::String mPSName2;
    Candera::String mPSName3;
    Candera::String mPSName4;
    Candera::String mPSName5;
    Candera::String mPSName6;

    PresetInfoDRMASTData();
};

// =========================================================================
struct EngineeringInfoData {
    Candera::String m_szFrequency;
    Candera::String m_szPSName;
    Candera::String m_szPI;
    Candera::String m_szFieldstrength;
    Candera::String m_szQuality;
    Candera::String m_szSharx;
    Candera::String m_szHicut;
    Candera::String m_szFMDeviation;
    Candera::String m_szChannelSeparation;

    EngineeringInfoData();
};

// =========================================================================
struct LayerNextPresets_FMData {
    Candera::UInt8 mNextPreviousIndex_FM;

    LayerNextPresets_FMData();
};

// =========================================================================
struct LayerNextPresets_AMData {
    Candera::UInt8 mNextPreviousIndex_AM;

    LayerNextPresets_AMData();
};

// =========================================================================
struct LayerNextPresets_DABData {
    Candera::UInt8 mNextPreviousIndex_DAB;

    LayerNextPresets_DABData();
};

// =========================================================================
struct EngineeringInfo1Data {
    Candera::String mMultipathQuality;
    Candera::String mnChannel;
    Candera::String mRDS;
    Candera::String mAntennaStatus;
    Candera::String mReceptionQuality;
    Candera::String mSzSharx;
    Candera::String mSzHicut;
    Candera::String mTPFlag;

    EngineeringInfo1Data();
};

// =========================================================================
struct EngineeringInfo2Data {
    Candera::String mTAFlag;
    Candera::String mAltFrequency;
    Candera::UInt8 mAFonOff;
    Candera::UInt8 mBandscanOnOff;
    Candera::UInt8 mMeasureOnOff;
    Candera::String mFreqStepFM;
    Candera::String mFreqStepAM;
    Candera::String mRFLevelAM;
    Candera::UInt8 mLinearAudio;
    Candera::String mAMTuner;
    Candera::String mFMTuner1;
    Candera::String mFMTuner2;
    Candera::String mFMTuner3;
    Candera::String mFMTuner4;
    Candera::String mDABTuner;

    EngineeringInfo2Data();
};

// =========================================================================
struct EngineeringInfoDRMData {
    Candera::String mFrequency;
    Candera::String mFieldStrength;
    Candera::String mSyncStatus;
    Candera::String mRobustnessMode;
    Candera::String mBandwidth;
    Candera::String mInter_Depth;
    Candera::String mRecnfg_idx;
    Candera::String mService_ID;
    Candera::String mService_Label;
    Candera::String mPTY;
    Candera::String mLanguage;
    Candera::String mFAC;
    Candera::String mSDC;
    Candera::String mAudioCRC;
    Candera::String mAudioMute;
    Candera::String mServiceQuality;
    Candera::String mAudioCoding;
    Candera::String mSBR;
    Candera::String mAudioMode;
    Candera::String mSamplingRate;
    Candera::String mTextFlag;
    Candera::String mIBER;
    Candera::String mPrLevel_PartA;
    Candera::String mPrLevel_Partb;

    EngineeringInfoDRMData();
};

// =========================================================================
struct Scan_ASTData {
    bool mIsActive;
    bool mIsDAB_AST_Active;
    bool mIsAM_AST_Active;
    bool mIsFM_AST_Active;
    bool mIsDRM_AST_Active;

    Scan_ASTData();
};

// =========================================================================
struct Scan_StatusData {
    bool mIsActiveScan;

    Scan_StatusData();
};

// =========================================================================
struct Source_SlectionData {
    bool mFM1Active;
    bool mFM2Active;
    bool mFMASTActive;
    bool mAMActive;
    bool mAMASTActive;
    bool mWXActive;
    bool mDABActive;
    bool mDABASTActive;
    bool mSXMActive;

    Source_SlectionData();
};

// =========================================================================
struct Preset_PopupData {
    Candera::String mPopup_text_1;
    Candera::String mPopup_text_2;
    Candera::String mAST_CannotStore;
    Candera::UInt16 mCurrentValue;
    Candera::UInt16 mTotalValue;
    bool mVisible_Txt_Wgt_1;
    bool mVisible_Txt_Wgt_2;

    Preset_PopupData();
};

// =========================================================================
struct PgBar_timerData {
    Candera::UInt32 mTimerValue;
    Candera::UInt16 mNoOfSteps;
    bool mTimerStart;

    PgBar_timerData();
};

// =========================================================================
struct tuningScale_SliderMarkerPositionData {
     Candera::Float mCurrentValue;
     Candera::Float mDragCurrentValue;

    tuningScale_SliderMarkerPositionData();
};

// =========================================================================
struct tuningSliderData {
     Candera::Float mStepSizeAM;
     Candera::Float mMaxValueAM;
     Candera::Float mMinValueAM;
    Candera::UInt16 mNoOfStepsAM;
    Candera::String mImage_SliderAM;
    Candera::String mImage_Slider_BG;
     Candera::Float mStepSizeFM;
     Candera::Float mMaxValueFM;
    Candera::String mTotalTimeFM;
    Candera::UInt16 mNoOfStepsFM;
    Candera::String mImage_SliderFM;

    tuningSliderData();
};

// =========================================================================
struct TunerOptionsData {
    Candera::UInt8 misChecked_TA;
    Candera::UInt8 misChecked_RadioTxt;
    Candera::UInt8 misChecked_RDSRegPgm;
    Candera::UInt8 misChecked_AltFreq;
    Candera::UInt8 misChecked_DAB_DynamicContent;
    Candera::UInt8 misChecked_DAB_FM_Following;
    Candera::UInt8 misChecked_DAB_DAB_Linking;
    Candera::UInt8 misChecked_DRM_DynamicContent;
    Candera::UInt8 misChecked_DRMFrequency;
    Candera::UInt8 misChecked_DRMAFSEARCH;

    TunerOptionsData();
};

// =========================================================================
struct DABOptionsData {
    Candera::UInt8 misChecked_EnablePTYFilter;
    Candera::UInt8 misChecked_News;
    Candera::UInt8 misChecked_Culture;
    Candera::UInt8 misChecked_Sports;
    Candera::UInt8 misChecked_Music;
    Candera::UInt8 misChecked_Special;

    DABOptionsData();
};

// =========================================================================
struct DRMOptionsData {
    Candera::UInt8 misChecked_EnablePTYFilter;
    Candera::UInt8 misChecked_News;
    Candera::UInt8 misChecked_Culture;
    Candera::UInt8 misChecked_Sports;
    Candera::UInt8 misChecked_Music;
    Candera::UInt8 misChecked_Special;

    DRMOptionsData();
};

// =========================================================================
struct MenuSelectionData {
    Candera::UInt32 mMainMenu_Selection;
    Candera::UInt32 mDABPTYOption_Selection;
    Candera::UInt32 mDRMPTYOption_Selection;

    MenuSelectionData();
};

// =========================================================================
struct Menu_NumOptionsData {
    Candera::UInt32 mMainMenu_NumOptions;

    Menu_NumOptionsData();
};

// =========================================================================
struct AppFlyInData {
    Candera::String mBTDeviceState;
    Candera::String mPhoneCallDuration;
    Candera::String mTextPhoneCallDuration;
    Candera::String mPhoneRoaming;
    Candera::String mPhoneCharge;
    bool mPhoneSPILink;
    Candera::String mNaviRGStaus;
    Candera::String mNaviETADTD;
    Candera::UInt32 mNaviDirection;
    Candera::String mNaviDuration;
    bool mNaviTimeToDestination;
    bool mVisible_Navi;
    bool mVisible_Media;

    AppFlyInData();
};

// =========================================================================
struct BrowseListPointerData {
};

// =========================================================================
struct BrowseListSizeData {
    Candera::UInt16 mTun_StationListSize;
    Candera::UInt16 mDAB_ServiceListSize;
    Candera::UInt16 mAF_ServiceListSize;
    Candera::UInt16 mTMC_ServiceListSize;
    Candera::UInt16 mDRM_ServiceListSize;
    Candera::UInt16 mTun_StationWindowListSize;
    Candera::UInt16 mDAB_ServiceWindowListSize;
    Candera::UInt16 mAF_ServiceWindowListSize;
    Candera::UInt16 mTMC_ServiceWindowListSize;
    Candera::UInt16 mDRM_ServiceWindowListSize;

    BrowseListSizeData();
};

// =========================================================================
struct BrowseListSelectedLineData {
    Candera::UInt16 mTun_StationSelected;
    Candera::UInt16 mDAB_ServiceSelected;
    Candera::UInt16 mAF_ServiceSelected;
    Candera::UInt16 mTMC_ServiceSelected;
    Candera::UInt16 mDRM_StationSelected;

    BrowseListSelectedLineData();
};

// =========================================================================
struct DABChannelInfoData {
    Candera::String mTpStatus;
    Candera::String mDabStatus;
    Candera::String mEnsembleLabel;
    Candera::String mServiceLabel;
    Candera::String mRadioText;
    bool mRadioTextVisible;

    DABChannelInfoData();
};

// =========================================================================
struct ActiveBankInfoData {
    bool mFM1_Active;
    bool mFM2_Active;
    bool mFMAST_Active;
    bool mAM_Active;
    bool mAMAST_Active;
    bool mDAB_Active;
    bool mDAB_AST_Active;
    bool mDRM_Active;
    bool mDRM_AST_Active;

    ActiveBankInfoData();
};

// =========================================================================
struct ActiveSourceInfoData {
    Candera::String mBitmapforSource;
    bool mActiveSource;

    ActiveSourceInfoData();
};

// =========================================================================
struct VariantInfoData {
    bool mDAB_Available;
    bool mWX_Available;
    bool mDest_Reg_DRM;
    bool mDAB_Mounted;
    bool mHD_Available;
    bool mAM_Activation;
    bool mFM_Activation;
    bool mSXM_Mounted;

    VariantInfoData();
};

// =========================================================================
struct TAInfoData {
    Candera::String mTAPSName;
    Candera::String mPTY31PSName;

    TAInfoData();
};

// =========================================================================
struct DABPresetInfoData {
    bool mPreset_1_Active;
    bool mPreset_2_Active;
    bool mPreset_3_Active;
    bool mPreset_4_Active;
    bool mPreset_5_Active;
    bool mPreset_6_Active;
    bool mPreset_7_Active;
    bool mPreset_8_Active;
    bool mPreset_9_Active;
    bool mPreset_10_Active;
    bool mPreset_11_Active;
    bool mPreset_12_Active;

    DABPresetInfoData();
};

// =========================================================================
struct FMAMPresetInfoData {
    bool mPreset_1_Active;
    bool mPreset_2_Active;
    bool mPreset_3_Active;
    bool mPreset_4_Active;
    bool mPreset_5_Active;
    bool mPreset_6_Active;
    bool mPreset_7_Active;
    bool mPreset_8_Active;
    bool mPreset_9_Active;
    bool mPreset_10_Active;
    bool mPreset_11_Active;
    bool mPreset_12_Active;

    FMAMPresetInfoData();
};

// =========================================================================
struct AMPresetInfoData {
    bool mPreset_1_Active;
    bool mPreset_2_Active;
    bool mPreset_3_Active;
    bool mPreset_4_Active;
    bool mPreset_5_Active;
    bool mPreset_6_Active;
    bool mPreset_7_Active;
    bool mPreset_8_Active;
    bool mPreset_9_Active;
    bool mPreset_10_Active;
    bool mPreset_11_Active;
    bool mPreset_12_Active;

    AMPresetInfoData();
};

// =========================================================================
struct Tuner1Data {
    Candera::String mFreq;
    Candera::String mPI;
    Candera::String mPS;
    Candera::String mFSQ;
    Candera::String mHicut;
    Candera::String mSharx;
    Candera::String mTP;
    Candera::String mTA;
    Candera::String mRDS;
    Candera::String mAF;
    Candera::String mDev;
    Candera::String mCS;
    Candera::String mMPNC;
    Candera::String mBand;

    Tuner1Data();
};

// =========================================================================
struct Tuner2Data {
    Candera::String mFreq;
    Candera::String mPI;
    Candera::String mPS;
    Candera::String mFSQ;
    Candera::String mHicut;
    Candera::String mSharx;
    Candera::String mTP;
    Candera::String mTA;
    Candera::String mRDS;
    Candera::String mAF;
    Candera::String mDev;
    Candera::String mCS;
    Candera::String mMPNC;
    Candera::String mBand;

    Tuner2Data();
};

// =========================================================================
struct Tuner3Data {
    Candera::String mFreq;
    Candera::String mPI;
    Candera::String mPS;
    Candera::String mFSQ;
    Candera::String mHicut;
    Candera::String mSharx;
    Candera::String mTP;
    Candera::String mTA;
    Candera::String mRDS;
    Candera::String mAF;
    Candera::String mDev;
    Candera::String mCS;
    Candera::String mMPNC;
    Candera::String mBand;

    Tuner3Data();
};

// =========================================================================
struct Tuner4Data {
    Candera::String mFreq;
    Candera::String mPI;
    Candera::String mPS;
    Candera::String mFSQ;
    Candera::String mHicut;
    Candera::String mSharx;
    Candera::String mTP;
    Candera::String mTA;
    Candera::String mRDS;
    Candera::String mAF;
    Candera::String mDev;
    Candera::String mCS;
    Candera::String mMPNC;
    Candera::String mBand;

    Tuner4Data();
};

// =========================================================================
struct TunerSource_BandData {
    bool mTunerSource1;
    bool mTunerSource2;
    bool mTunerSource3;
    bool mTunerSource4;
    bool mBandEnable1;
    bool mBandEnable2;
    bool mBandEnable3;
    bool mBandEnable4;
    Candera::String mBand1;
    Candera::String mBand2;
    Candera::String mBand3;
    Candera::String mBand4;

    TunerSource_BandData();
};

// =========================================================================
struct DAB_Setup_ScreenData {
    Candera::String mServiceLinking;
    Candera::String mConcealmentLevel;

    DAB_Setup_ScreenData();
};

// =========================================================================
struct DAB_Test_ModeData {
    Candera::String mchannel_Num;
    Candera::String mEnsemble_Lbl;
    Candera::String mEnsemble_ID;
    Candera::String mService_ID;
    Candera::String mEnsemble_freq;
    Candera::String mService_Lbl;
    Candera::String mAud_Data_Bit_Rate;
    Candera::String mMSC;
    Candera::String mFIC;
    Candera::String mNET;
    Candera::String mRS_FEC;
    Candera::String mSync_flag;
    Candera::String mQA;
    Candera::String mQS;
    Candera::String mField_Strength;
    Candera::String mMute_flag;
    Candera::String mBg_tuner_ens_freq;
    Candera::String mBg_Ensemble_ID;
    Candera::String mBg_FIC;
    Candera::String mAudio_Mode;
    Candera::String mFreq_Table;
    Candera::String mBGMode;
    Candera::String mBGSync_flag;
    Candera::String mTASrc;

    DAB_Test_ModeData();
};

// =========================================================================
struct DAB_Setup_Screen_ActiveTuner_InfoData {
    Candera::String mDRC;
    Candera::String mPS;
    Candera::String mSM_ACC;
    Candera::String mSR;
    Candera::String mTP;

    DAB_Setup_Screen_ActiveTuner_InfoData();
};

// =========================================================================
struct DABTestModeEnsembleInfoData {
    Candera::String mNoOfAud_DataServiceComp;
    Candera::String mNoOfAud_DataService;
    Candera::String mNoOfEnsembles;

    DABTestModeEnsembleInfoData();
};

// =========================================================================
struct DABGTestModeInfoData {
    Candera::String mFM;
    Candera::String mPI;
    Candera::String mQFM;
    Candera::String mPL;

    DABGTestModeInfoData();
};

// =========================================================================
struct DABGTestModeAnnoStatusInfoData {
    Candera::String mASW;
    Candera::String mASU;

    DABGTestModeAnnoStatusInfoData();
};

// =========================================================================
struct DABGTestModeActiveCompData {
    Candera::String mSC;
    Candera::String mSCType;

    DABGTestModeActiveCompData();
};

// =========================================================================
struct DABTestModeGAvailabiltyInfoData {
    Candera::String mTA;
    Candera::String mIndicator;
    Candera::String mDABDAB;

    DABTestModeGAvailabiltyInfoData();
};

// =========================================================================
struct DABTestModeServiceFollowingInfoData {
    Candera::String mTSU;

    DABTestModeServiceFollowingInfoData();
};

// =========================================================================
struct TmcInformationDataData {
    Candera::String mNumberOfMsg;
    Candera::String mSelectedMsg;
    Candera::String mLastMsgRecd;

    TmcInformationDataData();
};

// =========================================================================
struct TmcStationInfoDataData {
    Candera::String mPS;
    Candera::String mPI;
    Candera::String mCC;
    Candera::String mSID;
    Candera::String mLTN;
    Candera::String mQuality;

    TmcStationInfoDataData();
};

// =========================================================================
struct TestModeAvailabilityInfoData {
    bool mFMTestModeAvail;
    bool mDABTestModeAvail;

    TestModeAvailabilityInfoData();
};

// =========================================================================
struct FMSetupMenuInfoData {
    bool mToggleAF;
    bool mToggleMM;
    bool mToggleTA_status;
    bool mToggleRDS;
    bool mTogglePhaseDiversity;

    FMSetupMenuInfoData();
};

// =========================================================================
struct NextPrevious_Status_FMData {
    bool mIsNextActive_FM;
    bool mIsPreviousActive_FM;

    NextPrevious_Status_FMData();
};

// =========================================================================
struct NextPrevious_Status_AMData {
    bool mIsNextActive_AM;
    bool mIsPreviousActive_AM;

    NextPrevious_Status_AMData();
};

// =========================================================================
struct NextPrevious_Status_DABData {
    bool mIsNextActive_DAB;
    bool mIsPreviousActive_DAB;

    NextPrevious_Status_DABData();
};

// =========================================================================
struct SearchNextPrevious_IconActiveData {
    bool mIsNextIconActive;
    bool mIsPreviousIconActive;

    SearchNextPrevious_IconActiveData();
};

// =========================================================================
struct AMFMLogoImageData {
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mAMFMLogo;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mAMFMDefalutLogo;
    bool mAMFMLogoVisibility;

    AMFMLogoImageData();
};

// =========================================================================
struct ChannelInfoData {
    Candera::String mAdvisoryText;
    Candera::String mArtist;
    Candera::String mAlbum;
    Candera::String mTrack;
    Courier::UInt8 mArtistAlbumSwitch;
    bool mIsBallGameModeVisible;
    Candera::String mCategory;

    ChannelInfoData();
};

// =========================================================================
struct FmHdLogoData {
    Courier::UInt8 mFmHdLogoIndex;

    FmHdLogoData();
};

// =========================================================================
struct AmHdLogoData {
    Courier::UInt8 mAmHdLogoIndex;

    AmHdLogoData();
};

// =========================================================================
struct HDButtonVisibilityData {
    bool misHdVisible;

    HDButtonVisibilityData();
};

// =========================================================================
struct AmHdOnOffData {
    bool mIsActive;

    AmHdOnOffData();
};

// =========================================================================
struct FmHdOnOffData {
    bool mIsActive;

    FmHdOnOffData();
};

// =========================================================================
struct HDProgramListVisibilityData {
    bool misHdProgramListVisible;

    HDProgramListVisibilityData();
};

// =========================================================================
struct HDAudioMPSData {
    Courier::UInt32 mHD_Prog_MPS_switch;
    Candera::Vector2 mHD_Prog_MPS_size;

    HDAudioMPSData();
};

// =========================================================================
struct HDAudioSPS1Data {
    Courier::UInt32 mHD_Prog_SPS1_switch;
    Candera::Vector2 mHD_Prog_SPS1_size;

    HDAudioSPS1Data();
};

// =========================================================================
struct HDAudioSPS2Data {
    Courier::UInt32 mHD_Prog_SPS2_switch;
    Candera::Vector2 mHD_Prog_SPS2_size;

    HDAudioSPS2Data();
};

// =========================================================================
struct HDAudioSPS3Data {
    Courier::UInt32 mHD_Prog_SPS3_switch;
    Candera::Vector2 mHD_Prog_SPS3_size;

    HDAudioSPS3Data();
};

// =========================================================================
struct HDAudioSPS4Data {
    Courier::UInt32 mHD_Prog_SPS4_switch;
    Candera::Vector2 mHD_Prog_SPS4_size;

    HDAudioSPS4Data();
};

// =========================================================================
struct HDAudioSPS5Data {
    Courier::UInt32 mHD_Prog_SPS5_switch;
    Candera::Vector2 mHD_Prog_SPS5_size;

    HDAudioSPS5Data();
};

// =========================================================================
struct HDAudioSPS6Data {
    Courier::UInt32 mHD_Prog_SPS6_switch;
    Candera::Vector2 mHD_Prog_SPS6_size;

    HDAudioSPS6Data();
};

// =========================================================================
struct HDAudioSPS7Data {
    Courier::UInt32 mHD_Prog_SPS7_switch;
    Candera::Vector2 mHD_Prog_SPS7_size;

    HDAudioSPS7Data();
};

// =========================================================================
struct HDIconPreset1Data {
    Courier::UInt32 mHD_Preset_1;
    Candera::String mHD_Preset_1_value;

    HDIconPreset1Data();
};

// =========================================================================
struct HDIconPreset2Data {
    Courier::UInt32 mHD_Preset_2;
    Candera::String mHD_Preset_2_value;

    HDIconPreset2Data();
};

// =========================================================================
struct HDIconPreset3Data {
    Courier::UInt32 mHD_Preset_3;
    Candera::String mHD_Preset_3_value;

    HDIconPreset3Data();
};

// =========================================================================
struct HDIconPreset4Data {
    Courier::UInt32 mHD_Preset_4;
    Candera::String mHD_Preset_4_value;

    HDIconPreset4Data();
};

// =========================================================================
struct HDIconPreset5Data {
    Courier::UInt32 mHD_Preset_5;
    Candera::String mHD_Preset_5_value;

    HDIconPreset5Data();
};

// =========================================================================
struct HDIconPreset6Data {
    Courier::UInt32 mHD_Preset_6;
    Candera::String mHD_Preset_6_value;

    HDIconPreset6Data();
};

// =========================================================================
struct HDIconPreset7Data {
    Courier::UInt32 mHD_Preset_7;
    Candera::String mHD_Preset_7_value;

    HDIconPreset7Data();
};

// =========================================================================
struct HDIconPreset8Data {
    Courier::UInt32 mHD_Preset_8;
    Candera::String mHD_Preset_8_value;

    HDIconPreset8Data();
};

// =========================================================================
struct HDIconPreset9Data {
    Courier::UInt32 mHD_Preset_9;
    Candera::String mHD_Preset_9_value;

    HDIconPreset9Data();
};

// =========================================================================
struct HDIconPreset10Data {
    Courier::UInt32 mHD_Preset_10;
    Candera::String mHD_Preset_10_value;

    HDIconPreset10Data();
};

// =========================================================================
struct HDIconPreset11Data {
    Courier::UInt32 mHD_Preset_11;
    Candera::String mHD_Preset_11_value;

    HDIconPreset11Data();
};

// =========================================================================
struct HDIconPreset12Data {
    Courier::UInt32 mHD_Preset_12;
    Candera::String mHD_Preset_12_value;

    HDIconPreset12Data();
};

// =========================================================================
struct DtmHDData {
    Candera::String mHDStatus;
    Candera::String mSISStatus;
    Candera::String mAUDStatus;
    Candera::String mBlendStatus;
    Candera::String mHDCallSign;
    Candera::String mHD10Freq;
    Candera::String mHD10FST;
    Candera::String mHD10CdNo;
    Candera::String mHD10AudQual;
    Candera::String mHD05Freq;
    Candera::String mHD05FST;
    Candera::String mHD05CdNo;
    Candera::String mTransitions;
};

// =========================================================================
struct HDParamTuningIconData {
    bool mHD_Icon;

    HDParamTuningIconData();
};

// =========================================================================
struct TMHDAudioMPSData {
    Courier::UInt32 mTMHD_Prog_MPS_switch;
    Courier::UInt32 mTMHD_Prog_MPS_available;

    TMHDAudioMPSData();
};

// =========================================================================
struct TMHDAudioSPS1Data {
    Courier::UInt32 mTMHD_Prog_SPS1_switch;
    Courier::UInt32 mTMHD_Prog_SPS1_available;

    TMHDAudioSPS1Data();
};

// =========================================================================
struct TMHDAudioSPS2Data {
    Courier::UInt32 mTMHD_Prog_SPS2_switch;
    Courier::UInt32 mTMHD_Prog_SPS2_available;

    TMHDAudioSPS2Data();
};

// =========================================================================
struct TMHDAudioSPS3Data {
    Courier::UInt32 mTMHD_Prog_SPS3_switch;
    Courier::UInt32 mTMHD_Prog_SPS3_available;

    TMHDAudioSPS3Data();
};

// =========================================================================
struct TMHDAudioSPS4Data {
    Courier::UInt32 mTMHD_Prog_SPS4_switch;
    Courier::UInt32 mTMHD_Prog_SPS4_available;

    TMHDAudioSPS4Data();
};

// =========================================================================
struct TMHDAudioSPS5Data {
    Courier::UInt32 mTMHD_Prog_SPS5_switch;
    Courier::UInt32 mTMHD_Prog_SPS5_available;

    TMHDAudioSPS5Data();
};

// =========================================================================
struct TMHDAudioSPS6Data {
    Courier::UInt32 mTMHD_Prog_SPS6_switch;
    Courier::UInt32 mTMHD_Prog_SPS6_available;

    TMHDAudioSPS6Data();
};

// =========================================================================
struct TMHDAudioSPS7Data {
    Courier::UInt32 mTMHD_Prog_SPS7_switch;
    Courier::UInt32 mTMHD_Prog_SPS7_available;

    TMHDAudioSPS7Data();
};

// =========================================================================
struct RdsRadioTextData {
    Candera::String mText;
};

// =========================================================================
struct HomeScreenFmHdLogoData {
    Courier::UInt8 mHomeScreen_FmHdLogo;

    HomeScreenFmHdLogoData();
};

// =========================================================================
struct HomeScreenAmHdLogoData {
    Courier::UInt8 mHomeScreen_AmHdLogo;

    HomeScreenAmHdLogoData();
};

// =========================================================================
struct SPIVisibilityTunerData {
    bool mSPIIsvisibleTuner;
    bool mSPIIsvisibleTunerFMTuner;

    SPIVisibilityTunerData();
};
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
namespace FeatStd {
template<> ::FeatStd::UInt32 StringBufferAppender< ::CheckBoxListItemData >::Append(::FeatStd::StringBuffer& stringBuffer, ::CheckBoxListItemData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::StationInfoSourceData >::Append(::FeatStd::StringBuffer& stringBuffer, ::StationInfoSourceData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::HomeScreenInfoData >::Append(::FeatStd::StringBuffer& stringBuffer, ::HomeScreenInfoData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::RadioBandInfoData >::Append(::FeatStd::StringBuffer& stringBuffer, ::RadioBandInfoData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::FMStationListData >::Append(::FeatStd::StringBuffer& stringBuffer, ::FMStationListData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::RDSOptionsData >::Append(::FeatStd::StringBuffer& stringBuffer, ::RDSOptionsData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::PresetInfoWBData >::Append(::FeatStd::StringBuffer& stringBuffer, ::PresetInfoWBData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::WBPresetInfoData >::Append(::FeatStd::StringBuffer& stringBuffer, ::WBPresetInfoData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::PresetInfoFM1Data >::Append(::FeatStd::StringBuffer& stringBuffer, ::PresetInfoFM1Data const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::PresetInfoFM2Data >::Append(::FeatStd::StringBuffer& stringBuffer, ::PresetInfoFM2Data const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::PresetInfoFMASTData >::Append(::FeatStd::StringBuffer& stringBuffer, ::PresetInfoFMASTData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::PresetInfoAMData >::Append(::FeatStd::StringBuffer& stringBuffer, ::PresetInfoAMData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::PresetInfoAMASTData >::Append(::FeatStd::StringBuffer& stringBuffer, ::PresetInfoAMASTData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::PresetInfoDABData >::Append(::FeatStd::StringBuffer& stringBuffer, ::PresetInfoDABData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::PresetInfoDABASTData >::Append(::FeatStd::StringBuffer& stringBuffer, ::PresetInfoDABASTData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::PresetInfoDRMData >::Append(::FeatStd::StringBuffer& stringBuffer, ::PresetInfoDRMData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::PresetInfoDRMASTData >::Append(::FeatStd::StringBuffer& stringBuffer, ::PresetInfoDRMASTData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::EngineeringInfoData >::Append(::FeatStd::StringBuffer& stringBuffer, ::EngineeringInfoData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::LayerNextPresets_FMData >::Append(::FeatStd::StringBuffer& stringBuffer, ::LayerNextPresets_FMData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::LayerNextPresets_AMData >::Append(::FeatStd::StringBuffer& stringBuffer, ::LayerNextPresets_AMData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::LayerNextPresets_DABData >::Append(::FeatStd::StringBuffer& stringBuffer, ::LayerNextPresets_DABData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::EngineeringInfo1Data >::Append(::FeatStd::StringBuffer& stringBuffer, ::EngineeringInfo1Data const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::EngineeringInfo2Data >::Append(::FeatStd::StringBuffer& stringBuffer, ::EngineeringInfo2Data const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::EngineeringInfoDRMData >::Append(::FeatStd::StringBuffer& stringBuffer, ::EngineeringInfoDRMData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::Scan_ASTData >::Append(::FeatStd::StringBuffer& stringBuffer, ::Scan_ASTData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::Scan_StatusData >::Append(::FeatStd::StringBuffer& stringBuffer, ::Scan_StatusData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::Source_SlectionData >::Append(::FeatStd::StringBuffer& stringBuffer, ::Source_SlectionData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::Preset_PopupData >::Append(::FeatStd::StringBuffer& stringBuffer, ::Preset_PopupData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::PgBar_timerData >::Append(::FeatStd::StringBuffer& stringBuffer, ::PgBar_timerData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::tuningScale_SliderMarkerPositionData >::Append(::FeatStd::StringBuffer& stringBuffer, ::tuningScale_SliderMarkerPositionData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::tuningSliderData >::Append(::FeatStd::StringBuffer& stringBuffer, ::tuningSliderData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::TunerOptionsData >::Append(::FeatStd::StringBuffer& stringBuffer, ::TunerOptionsData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::DABOptionsData >::Append(::FeatStd::StringBuffer& stringBuffer, ::DABOptionsData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::DRMOptionsData >::Append(::FeatStd::StringBuffer& stringBuffer, ::DRMOptionsData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::MenuSelectionData >::Append(::FeatStd::StringBuffer& stringBuffer, ::MenuSelectionData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::Menu_NumOptionsData >::Append(::FeatStd::StringBuffer& stringBuffer, ::Menu_NumOptionsData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::AppFlyInData >::Append(::FeatStd::StringBuffer& stringBuffer, ::AppFlyInData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::BrowseListPointerData >::Append(::FeatStd::StringBuffer& stringBuffer, ::BrowseListPointerData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::BrowseListSizeData >::Append(::FeatStd::StringBuffer& stringBuffer, ::BrowseListSizeData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::BrowseListSelectedLineData >::Append(::FeatStd::StringBuffer& stringBuffer, ::BrowseListSelectedLineData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::DABChannelInfoData >::Append(::FeatStd::StringBuffer& stringBuffer, ::DABChannelInfoData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::ActiveBankInfoData >::Append(::FeatStd::StringBuffer& stringBuffer, ::ActiveBankInfoData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::ActiveSourceInfoData >::Append(::FeatStd::StringBuffer& stringBuffer, ::ActiveSourceInfoData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::VariantInfoData >::Append(::FeatStd::StringBuffer& stringBuffer, ::VariantInfoData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::TAInfoData >::Append(::FeatStd::StringBuffer& stringBuffer, ::TAInfoData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::DABPresetInfoData >::Append(::FeatStd::StringBuffer& stringBuffer, ::DABPresetInfoData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::FMAMPresetInfoData >::Append(::FeatStd::StringBuffer& stringBuffer, ::FMAMPresetInfoData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::AMPresetInfoData >::Append(::FeatStd::StringBuffer& stringBuffer, ::AMPresetInfoData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::Tuner1Data >::Append(::FeatStd::StringBuffer& stringBuffer, ::Tuner1Data const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::Tuner2Data >::Append(::FeatStd::StringBuffer& stringBuffer, ::Tuner2Data const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::Tuner3Data >::Append(::FeatStd::StringBuffer& stringBuffer, ::Tuner3Data const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::Tuner4Data >::Append(::FeatStd::StringBuffer& stringBuffer, ::Tuner4Data const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::TunerSource_BandData >::Append(::FeatStd::StringBuffer& stringBuffer, ::TunerSource_BandData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::DAB_Setup_ScreenData >::Append(::FeatStd::StringBuffer& stringBuffer, ::DAB_Setup_ScreenData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::DAB_Test_ModeData >::Append(::FeatStd::StringBuffer& stringBuffer, ::DAB_Test_ModeData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::DAB_Setup_Screen_ActiveTuner_InfoData >::Append(::FeatStd::StringBuffer& stringBuffer, ::DAB_Setup_Screen_ActiveTuner_InfoData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::DABTestModeEnsembleInfoData >::Append(::FeatStd::StringBuffer& stringBuffer, ::DABTestModeEnsembleInfoData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::DABGTestModeInfoData >::Append(::FeatStd::StringBuffer& stringBuffer, ::DABGTestModeInfoData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::DABGTestModeAnnoStatusInfoData >::Append(::FeatStd::StringBuffer& stringBuffer, ::DABGTestModeAnnoStatusInfoData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::DABGTestModeActiveCompData >::Append(::FeatStd::StringBuffer& stringBuffer, ::DABGTestModeActiveCompData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::DABTestModeGAvailabiltyInfoData >::Append(::FeatStd::StringBuffer& stringBuffer, ::DABTestModeGAvailabiltyInfoData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::DABTestModeServiceFollowingInfoData >::Append(::FeatStd::StringBuffer& stringBuffer, ::DABTestModeServiceFollowingInfoData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::TmcInformationDataData >::Append(::FeatStd::StringBuffer& stringBuffer, ::TmcInformationDataData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::TmcStationInfoDataData >::Append(::FeatStd::StringBuffer& stringBuffer, ::TmcStationInfoDataData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::TestModeAvailabilityInfoData >::Append(::FeatStd::StringBuffer& stringBuffer, ::TestModeAvailabilityInfoData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::FMSetupMenuInfoData >::Append(::FeatStd::StringBuffer& stringBuffer, ::FMSetupMenuInfoData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::NextPrevious_Status_FMData >::Append(::FeatStd::StringBuffer& stringBuffer, ::NextPrevious_Status_FMData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::NextPrevious_Status_AMData >::Append(::FeatStd::StringBuffer& stringBuffer, ::NextPrevious_Status_AMData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::NextPrevious_Status_DABData >::Append(::FeatStd::StringBuffer& stringBuffer, ::NextPrevious_Status_DABData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::SearchNextPrevious_IconActiveData >::Append(::FeatStd::StringBuffer& stringBuffer, ::SearchNextPrevious_IconActiveData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::AMFMLogoImageData >::Append(::FeatStd::StringBuffer& stringBuffer, ::AMFMLogoImageData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::ChannelInfoData >::Append(::FeatStd::StringBuffer& stringBuffer, ::ChannelInfoData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::FmHdLogoData >::Append(::FeatStd::StringBuffer& stringBuffer, ::FmHdLogoData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::AmHdLogoData >::Append(::FeatStd::StringBuffer& stringBuffer, ::AmHdLogoData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::HDButtonVisibilityData >::Append(::FeatStd::StringBuffer& stringBuffer, ::HDButtonVisibilityData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::AmHdOnOffData >::Append(::FeatStd::StringBuffer& stringBuffer, ::AmHdOnOffData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::FmHdOnOffData >::Append(::FeatStd::StringBuffer& stringBuffer, ::FmHdOnOffData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::HDProgramListVisibilityData >::Append(::FeatStd::StringBuffer& stringBuffer, ::HDProgramListVisibilityData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::HDAudioMPSData >::Append(::FeatStd::StringBuffer& stringBuffer, ::HDAudioMPSData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::HDAudioSPS1Data >::Append(::FeatStd::StringBuffer& stringBuffer, ::HDAudioSPS1Data const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::HDAudioSPS2Data >::Append(::FeatStd::StringBuffer& stringBuffer, ::HDAudioSPS2Data const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::HDAudioSPS3Data >::Append(::FeatStd::StringBuffer& stringBuffer, ::HDAudioSPS3Data const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::HDAudioSPS4Data >::Append(::FeatStd::StringBuffer& stringBuffer, ::HDAudioSPS4Data const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::HDAudioSPS5Data >::Append(::FeatStd::StringBuffer& stringBuffer, ::HDAudioSPS5Data const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::HDAudioSPS6Data >::Append(::FeatStd::StringBuffer& stringBuffer, ::HDAudioSPS6Data const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::HDAudioSPS7Data >::Append(::FeatStd::StringBuffer& stringBuffer, ::HDAudioSPS7Data const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::HDIconPreset1Data >::Append(::FeatStd::StringBuffer& stringBuffer, ::HDIconPreset1Data const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::HDIconPreset2Data >::Append(::FeatStd::StringBuffer& stringBuffer, ::HDIconPreset2Data const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::HDIconPreset3Data >::Append(::FeatStd::StringBuffer& stringBuffer, ::HDIconPreset3Data const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::HDIconPreset4Data >::Append(::FeatStd::StringBuffer& stringBuffer, ::HDIconPreset4Data const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::HDIconPreset5Data >::Append(::FeatStd::StringBuffer& stringBuffer, ::HDIconPreset5Data const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::HDIconPreset6Data >::Append(::FeatStd::StringBuffer& stringBuffer, ::HDIconPreset6Data const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::HDIconPreset7Data >::Append(::FeatStd::StringBuffer& stringBuffer, ::HDIconPreset7Data const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::HDIconPreset8Data >::Append(::FeatStd::StringBuffer& stringBuffer, ::HDIconPreset8Data const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::HDIconPreset9Data >::Append(::FeatStd::StringBuffer& stringBuffer, ::HDIconPreset9Data const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::HDIconPreset10Data >::Append(::FeatStd::StringBuffer& stringBuffer, ::HDIconPreset10Data const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::HDIconPreset11Data >::Append(::FeatStd::StringBuffer& stringBuffer, ::HDIconPreset11Data const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::HDIconPreset12Data >::Append(::FeatStd::StringBuffer& stringBuffer, ::HDIconPreset12Data const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::DtmHDData >::Append(::FeatStd::StringBuffer& stringBuffer, ::DtmHDData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::HDParamTuningIconData >::Append(::FeatStd::StringBuffer& stringBuffer, ::HDParamTuningIconData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::TMHDAudioMPSData >::Append(::FeatStd::StringBuffer& stringBuffer, ::TMHDAudioMPSData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::TMHDAudioSPS1Data >::Append(::FeatStd::StringBuffer& stringBuffer, ::TMHDAudioSPS1Data const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::TMHDAudioSPS2Data >::Append(::FeatStd::StringBuffer& stringBuffer, ::TMHDAudioSPS2Data const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::TMHDAudioSPS3Data >::Append(::FeatStd::StringBuffer& stringBuffer, ::TMHDAudioSPS3Data const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::TMHDAudioSPS4Data >::Append(::FeatStd::StringBuffer& stringBuffer, ::TMHDAudioSPS4Data const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::TMHDAudioSPS5Data >::Append(::FeatStd::StringBuffer& stringBuffer, ::TMHDAudioSPS5Data const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::TMHDAudioSPS6Data >::Append(::FeatStd::StringBuffer& stringBuffer, ::TMHDAudioSPS6Data const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::TMHDAudioSPS7Data >::Append(::FeatStd::StringBuffer& stringBuffer, ::TMHDAudioSPS7Data const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::RdsRadioTextData >::Append(::FeatStd::StringBuffer& stringBuffer, ::RdsRadioTextData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::HomeScreenFmHdLogoData >::Append(::FeatStd::StringBuffer& stringBuffer, ::HomeScreenFmHdLogoData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::HomeScreenAmHdLogoData >::Append(::FeatStd::StringBuffer& stringBuffer, ::HomeScreenAmHdLogoData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::SPIVisibilityTunerData >::Append(::FeatStd::StringBuffer& stringBuffer, ::SPIVisibilityTunerData const & object);
} // namespace FeatStd
#endif
#endif // AppHmi_TunerDatabinding_h
