/************************************************************************
*FILE: AppHmi_TestmodeStateMachine.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(AppHmi_TestmodeStateMachine_h)
#define AppHmi_TestmodeStateMachine_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Courier/Messaging/Message.h>
#include <AppHmi_TestmodeStateMachineSEMLibB.h>
#include <AppHmi_TestmodeStateMachineData.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Cit/VisualStateGlueLayer/DeductResult.h>
#ifdef CIT_SIMULATION
#include <json/value.h>
#endif
#include <AppHmi_TestmodeTypes.h>
#include <AppHmi_TestmodeConstants.h>
#include <AppHmi_TestmodeMessages.h>
#include <AppHmi_TestmodeDatabinding.h>
#include <AppHmi_TestmodeViews.h>
#include <AppHmi_TestmodeController.h>
// ------------------------------------------------------------------------
class AppHmi_TestmodeStateMachineImpl : public AppHmi_TestmodeStateMachine
{
public:
    typedef AppHmi_TestmodeStateMachine Base;

#ifdef VISUALSTATE_7_TRACE
    // Mapping of data types of API to get rid of include dependencies
    //typedef SEM_ACTION_EXPRESSION_TYPE VS_Type_ActionExpression;
	using Base::VS_Type_ActionExpression;
    //typedef SEM_EVENT_TYPE VS_Type_Event;
	//typedef SEM_STATE_TYPE VS_Type_State;
	//typedef SEM_EXPLANATION_TYPE VS_Type_Explanation;
	//typedef SEM_STATE_MACHINE_TYPE VS_Type_Statemachine;
	using Base::VS_Type_Event;
	using Base::VS_Type_State;
	using Base::VS_Type_Explanation;
	using Base::VS_Type_Statemachine;

    // Mapping of enums and defines of API to get rid of include dependencies
    //enum { VS_Ret_Ok = SES_OKAY };
    //enum { VS_Ret_Found = SES_FOUND };
	enum { VS_Ret_Ok = Base::VS_Ret_Ok };
	enum { VS_Ret_Found = Base::VS_Ret_Found };
    enum { VS_Evt_Reset = SE_RESET };
    enum { VS_Ret_Error = SES_RANGE_ERR };
#else
#ifndef VISUALSTATE_HCODER
    typedef SEM_ACTION_EXPRESSION_TYPE VS_Type_ActionExpression;
    typedef SEM_EVENT_TYPE VS_Type_Event;
    typedef SEM_STATE_TYPE VS_Type_State;
    typedef SEM_EXPLANATION_TYPE VS_Type_Explanation;
    typedef SEM_STATE_MACHINE_TYPE VS_Type_Statemachine;
    enum { VS_Ret_Ok = SES_OKAY };
    enum { VS_Ret_Found = SES_FOUND };
    enum { VS_Evt_Reset = SE_RESET };
    enum { VS_Ret_Error = SES_RANGE_ERR };
#else
    enum { VS_Ret_Ok = 0U };
    enum { VS_Ret_Found = 1U };
    enum { VS_Evt_Reset = 0U };
    enum { VS_Ret_Error = 4U };
#endif
#endif
// ------------------------------------------------------------------------

    // Mapping of args passed as hashId to corresponding identifier
    static const ::FeatStd::Char *GetNameFromId(::FeatStd::UInt32 id);

// ------------------------------------------------------------------------
    virtual void PerformLinearAudio();
    virtual void PerformHealthCareMntrDTCMsg(::FeatStd::UInt8 aHealthCareMntrDTCack);
    virtual void PerformFMEnhancer();
    virtual void DABIconVisibilityMsg();
    virtual void Perform_Activate_Home_Source();
    virtual void FMMonitorMessageSharxHiCut(::FeatStd::UInt8 aFirstArg, ::FeatStd::UInt8 aSecondArg);
    virtual void Perform_Tuner_fn(::FeatStd::UInt8 aEventId, ::FeatStd::UInt32 aFirstArg, ::FeatStd::UInt32 aSecondArg);
    virtual void Perform_TestMode_Active_Screen(bool aStartMonitor);
    virtual void Perform_ChannelList_Screen_Active(bool aStartMonitor);
    virtual void SXMAudioRecallorStore(::FeatStd::UInt8 aPresetRowIndex, ::FeatStd::UInt8 aPresetColIndex, ::FeatStd::UInt8 aPresetAction);
    virtual void Perform_SXM_Audio_Allocation();
    virtual void Notify_Init_Finished();
    virtual void Perform_WX_Audio_Allocation();
    virtual void Perform_Tuner_Wx_fn(::FeatStd::UInt32 aEventId);
    virtual void Perform_Testmode_Context();
    virtual void gacChangeLanguageReq(::FeatStd::Int32 aLanguageId);
    virtual void gacHideFocusInViewReq(::FeatStd::UInt32 aView);
    virtual void NextLevelTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void PreviousLevelTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void DualViewLeftTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void DualViewRightTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void PageFlipBackTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void PageFlipFrontTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void ZoomInTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView, ::FeatStd::Int8 aPos);
    virtual void ZoomOutTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView, ::FeatStd::Int8 aPos);
    virtual void FadeTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void gacWaitAnimationStartReq();
    virtual void acFocusOnRightEncoderReqUpd(bool aIsFocusUsed);
    virtual void acSetGadgetSceenActiveStatus(bool aIsGadgetAtive);
    virtual void acHKNotificationMsg(::FeatStd::Int8 aHKCode, ::FeatStd::Int8 aHKState);
    virtual void acPerform_CloseAllDropdowns();
    virtual void acPerform_CloseDropdown(::FeatStd::UInt32 aListId);
    virtual void acPerform_OpenDropdown(::FeatStd::UInt32 aListId);
    virtual void acPerform_ToggleDropdown(::FeatStd::UInt32 aListId);
    virtual void acStartAppPopupTimer(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aTimeout);
    virtual void acStopAppPopupTimer(::FeatStd::UInt32 aViewId);
    virtual void acPostBeep(::FeatStd::Int8 aBeepType);
    virtual void gacCheckToClosePopup(::FeatStd::UInt32 aPopupId);
    virtual void acRestartAppPopupTimer(::FeatStd::UInt32 aViewId);
    virtual void gacContextSwitchBackRes(::FeatStd::UInt32 aSwitchId);
    virtual void gacContextSwitchCompleteRes(::FeatStd::UInt32 aSwitchId);
    virtual void gacContextSwitchFailedRes(::FeatStd::UInt32 aSwitchId);
    virtual void gacContextSwitchDoneRes(::FeatStd::UInt32 aSwitchId);
    virtual void gacContextSwitchOutReq(::FeatStd::UInt32 aTargetContextId, ::FeatStd::UInt32 aSourceContextId, ::FeatStd::UInt32 aTargetAppId);
    virtual void gacCurrentScreenDisplayReq();
    virtual void gacLaunchBarDisplayReq(bool aVisibility);
    virtual void gacNavTBTSwipe();
    virtual void gacPerformListBtnRightEncoderChangeUpd(::FeatStd::Int8 aSteps, ::FeatStd::UInt32 aListId, ::FeatStd::UInt32 aRowId, ::FeatStd::UInt32 aColumnId);
    virtual void gacScrollListUp();
    virtual void gacScrollListDown();
    virtual void gacScrollPageUp();
    virtual void gacScrollPageDown();
    virtual void gacScrollListFocusUp(::FeatStd::UInt32 aListId);
    virtual void gacScrollListFocusDown(::FeatStd::UInt32 aListId);
    virtual void gacPerformListFocusLockDataResetUpd();
    virtual void gacSetApplicationMode(::FeatStd::UInt32 aModeId);
    virtual void gacSpellerBbehaviorReq(bool aEnable);
    virtual void gacStatusBarDisplayReq(bool aVisibility, ::FeatStd::Int32 aHeaderType);
    virtual void gacTBTRetriggerAcousticOutput();
    virtual void gacWaitAnimationStopReq();
    virtual void gacViewCreateReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewCreateAllReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewDestroyReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewClearReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewShowReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewHideReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewCreateWithoutLoadReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewAsyncLoadReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewActivateWithoutRenderingReq(::FeatStd::UInt32 aViewId);
    virtual void gacPopupCreateAndSBShowReq(::FeatStd::UInt32 aViewId);
    virtual void gacPopupCreateAndSBShowReqForMultiDisplay(::FeatStd::UInt32 aPopupDisplayID, ::FeatStd::UInt32 aViewId);
    virtual void gacPopupSBCloseReq(::FeatStd::UInt32 aViewId);
    virtual void gacPopupSBCloseReqForMultiDisplay(::FeatStd::UInt32 aPopupDisplayID, ::FeatStd::UInt32 aViewId);
    virtual void gacPopupRestartTimerReq(::FeatStd::UInt32 aViewId);
    virtual void gacPopupRestartTimerReqForMultiDisplay(::FeatStd::UInt32 aPopupDisplayID, ::FeatStd::UInt32 aViewId);
    virtual void gacViewCreateAndShowReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewHideAndDestroyReq(::FeatStd::UInt32 aViewId);
    virtual void gacSceneTransitionEnter(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aHint);
    virtual void gacSceneTransitionLeave(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aHint);
    virtual void gacDisplayStatusLineReq(::FeatStd::Int32 aDisplayRegionType);
    virtual void gacHideStatusLineReq(::FeatStd::Int32 aDisplayRegionType);
    virtual void gacDisplayFooterLineReq();
    virtual void gacHideFooterLineReq();
    virtual void gacDisplayStatusLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID);
    virtual void gacHideStatusLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID);
    virtual void gacDisplayFooterLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID);
    virtual void gacHideFooterLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID);
    virtual void gacRegisterForCloseOnTouchSession(::FeatStd::UInt32 aViewId);
    virtual void gacDeregisterForCloseOnTouchSessionReq(::FeatStd::UInt32 aViewId);
    virtual void gacPopupFilterPrioEnableReq(::FeatStd::UInt32 aPrio);
    virtual void gacPopupFilterAllEnableReq();
    virtual void gacPopupFilterDisableReq();
    virtual void gacProfileChange(::FeatStd::Int8 aProfile);
    virtual void gacPopupFilterPrioEnableReqForDisplay(::FeatStd::UInt32 aPrio, ::FeatStd::UInt32 aDisplayID);
    virtual void gacPopupFilterAllEnableReqForDisplay(::FeatStd::UInt32 aDisplayID);
    virtual void gacPopupFilterDisableReqForDisplay(::FeatStd::UInt32 aDisplayID);
    virtual void gacStartSceneTransitionAnimation(::FeatStd::UInt32 aSourceView, ::FeatStd::UInt32 aDestinationView, ::FeatStd::UInt32 aUserData1, ::FeatStd::Int8 aUserData2);
    virtual void gacDecrementActiveAnimationCount();

#ifdef CIT_SIMULATION
    bool CallAction(const ::FeatStd::Char* actionName, const ::Json::Value& parameters, ::Json::Value &response);
    const ::FeatStd::Char* GetEventName(::FeatStd::UInt32 eventId, ::Courier::Message const & message, Json::Value& eventArgument);
#endif
    // Added function for deduction of one event to simplify the event loop
    bool HandleDataBindingEventMapping(::Courier::AbstractDataItemMsg const & message, ::FeatStd::UInt32& eventId) const;
    bool HandleEventMapping(::Courier::Message const & message, ::FeatStd::UInt32& eventId) const;

    ::Cit::DeductResult::Enum DeductEvent(::Courier::Message const & message, ::FeatStd::UInt32 eventId);

    //====  member function with TTFis output - added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====

	virtual unsigned short GetTraceClass();
	int GetNumberOfStatemachines();
    //====  member function with TTFis output - end                        key: SM_TTFis_SBHFMSRF ====
};

// ------------------------------------------------------------------------
bool SendLinearAudioReqMsg();
bool SendHealthCareMntrDTCMsg(enHealthCareMntrDTCType const & aHealthCareMntrDTCack);
bool SendFMEnhancerReqMsg();
bool SendDABIconVisibility();
bool SendSwitchApplicationReq(enApplicationId const & aApplicationID, enSurfaceId const & aSurfaceID);
bool SendFMMonitorMessage(Candera::UInt8 const & aFirstArg, Candera::UInt8 const & aSecondArg);
bool SendTunerBLMsg(Courier::Int8 const & aEventId, Courier::Int32 const & aFirstArg, Courier::Int32 const & aSecondArg);
bool SendSxmDTMTestModeMonitorSelReqMsg(bool const & aStartMonitor);
bool SendSXMAudioCustomizeListReqMsg(bool const & aStartMonitor);
bool SendSXMAudioRecallorStoreReqMsg(Courier::UInt8 const & aPresetRowIndex, Courier::UInt8 const & aPresetColIndex, Courier::UInt8 const & aPresetAction);
bool SendSXMAudioAllocateReqMsg();
bool SendGuiStartupFinishedUpdMsg();
bool SendWXAudioAllocateReqMsg();
bool SendTuner_WxBLMsg(Courier::Int32 const & aEventId);
bool SendContextToMaster();
bool SendChangeLanguageReqMsg(enLanguageId const & aLanguageId);
bool SendFocusReqMsg(FocusActionEnum const & aAction, FocusTimerActionEnum const & aTimerAction, ::Courier::ViewId const & aView, Candera::String const & aWidget);
bool SendDummyMess(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos);
bool SendAnimationReqMsg(Courier::AnimationAction::Enum const & aAnimationAction, ::Courier::ViewId const & aViewId, Courier::CompositePath const & aCompositePath, ::Courier::ItemId const & aAnimationId, Courier::AnimationProperties const & aAnimationProperties);
bool SendFocusOnRightEncoderReqUpdMsg(bool const & aIsFocusUsed);
bool SendStoreActiveGadgetReqMsg(bool const & aIsGadgetAtive);
bool SendHardKeyPressNotificationMsg(Courier::UInt8 const & aDummy, Courier::UInt8 const & aHKCode, Courier::UInt8 const & aHKState);
bool SendDropdownChangeMsg(::Candera::DropdownChangeType const & aDropdownChangeType, ::Courier::UInt32 const & aListId);
bool SendStartPopupTimerReqMsg(Courier::UInt32 const & aViewId, Courier::UInt32 const & aTimeout);
bool SendStopPopupTimerReqMsg(Courier::UInt32 const & aViewId);
bool SendPlayBeepReqMsg(Courier::Int32 const & aBeepType);
bool SendCheckToClosePopupMsg(Courier::UInt32 const & aPopupId);
bool SendRestartPopupTimerReqMsg(Courier::UInt32 const & aViewId);
bool SendContextSwitchInResMsg(Courier::UInt32 const & aSwitchId, Courier::UInt32 const & aResponseType);
bool SendContextSwitchOutReqMsg(Courier::UInt32 const & aTargetContextId, Courier::UInt32 const & aSourceContextId, Courier::UInt32 const & aTargetAppId);
bool SendCurrentScreenDisplayReqMsg();
bool SendLaunchBarDisplayReqMsg(bool const & aVisibility);
bool SendNavTBTSwipeReqMsg();
bool SendListItemRightEncoderChangeUpdMsg(Courier::Int8 const & aSteps, Courier::UInt32 const & aListId, Courier::UInt32 const & aRowId, Courier::UInt32 const & aColumnId);
bool SendListChangeMsg(::Courier::UInt32 const & aListId, ListChangeType const & aListChangeType, ::Courier::Int32 const & aValue, ListChangeMsgSourceType const & aListChangeMsgSource, bool const & aImmediatePositioning);
bool SendListFocusScrollReqMsg(Courier::UInt32 const & aListId, Courier::Int32 const & aSteps);
bool SendListFocusLockDataResetReqMsg();
bool SendSetApplicationModeReqMsg(Courier::UInt32 const & aModeId);
bool SendSpellerBbehaviorReqMsg(bool const & aEnable);
bool SendStatusBarDisplayReqMsg(bool const & aVisibility, Courier::Int32 const & aHeaderType);
bool SendTBTRetriggerAcousticMsg();
bool SendViewReqMsg(Courier::ViewAction::Enum const & aViewAction, ::Courier::ViewId const & aViewId, bool const & aShallInitScene, bool const & aShallLoadScene);
bool SendActivationReqMsg(::Courier::ViewId const & aViewId, bool const & aActivation, bool const & aEnableRendering);
bool SendAsyncLoadReqMsg(::Courier::ViewId const & aViewId, bool const & aLoad);
bool SendPopupReqMsg(hmibase::popups::CommandEnum const & aCommand, ::Courier::ViewId const & aViewId, Courier::UInt32 const & aPopupDisplayID);
bool SendExtendedViewReqMsg(hmibase::views::CommandEnum const & aCommand, ::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint);
bool SendShowHMISubSurfaceReqMsg(hmibase::displayRegion const & aDisplayRegion, Courier::Int32 const & aDisplayRegionType, bool const & aShowSubSurface, Courier::UInt32 const & aDisplayID, bool const & aLockSubSurface);
bool SendRegisterForCloseOnTouchSessionReqMsg(bool const & aRegister, ::Courier::ViewId const & aViewId);
bool SendPopupFilterPrioEnableReqMsg(Courier::UInt32 const & aPrio);
bool SendPopupFilterAllEnableReqMsg();
bool SendPopupFilterDisableReqMsg();
bool SendProfileSwitchMsg(Courier::UInt32 const & aProfile);
bool SendMultiDisplayPopupFilterReqMsg(hmibase::PopupFilterType const & aPopupFilterType, Courier::UInt32 const & aPrio, Courier::UInt32 const & aDisplayID);
bool SendCreateNewDestroyOld(::Courier::ViewId const & aSourceView, ::Courier::ViewId const & aDestinationView, Courier::UInt32 const & aUserData1, Courier::Int8 const & aUserData2);
bool SendNotifierMessage();

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_PerformLinearAudio(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_PerformLinearAudio();
#ifdef CIT_SIMULATION
bool CallAction_PerformHealthCareMntrDTCMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_PerformHealthCareMntrDTCMsg(enHealthCareMntrDTCType const & aHealthCareMntrDTCack);
#ifdef CIT_SIMULATION
bool CallAction_PerformFMEnhancer(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_PerformFMEnhancer();
#ifdef CIT_SIMULATION
bool CallAction_DABIconVisibilityMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_DABIconVisibilityMsg();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Activate_Home_Source(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Activate_Home_Source();
#ifdef CIT_SIMULATION
bool CallAction_FMMonitorMessageSharxHiCut(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_FMMonitorMessageSharxHiCut(Candera::UInt8 const & aFirstArg, Candera::UInt8 const & aSecondArg);
#ifdef CIT_SIMULATION
bool CallAction_Perform_Tuner_fn(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Tuner_fn(Courier::Int8 const & aEventId, Courier::Int32 const & aFirstArg, Courier::Int32 const & aSecondArg);
#ifdef CIT_SIMULATION
bool CallAction_Perform_TestMode_Active_Screen(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_TestMode_Active_Screen(bool const & aStartMonitor);
#ifdef CIT_SIMULATION
bool CallAction_Perform_ChannelList_Screen_Active(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_ChannelList_Screen_Active(bool const & aStartMonitor);
#ifdef CIT_SIMULATION
bool CallAction_SXMAudioRecallorStore(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_SXMAudioRecallorStore(Courier::UInt8 const & aPresetRowIndex, Courier::UInt8 const & aPresetColIndex, Courier::UInt8 const & aPresetAction);
#ifdef CIT_SIMULATION
bool CallAction_Perform_SXM_Audio_Allocation(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_SXM_Audio_Allocation();
#ifdef CIT_SIMULATION
bool CallAction_Notify_Init_Finished(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Notify_Init_Finished();
#ifdef CIT_SIMULATION
bool CallAction_Perform_WX_Audio_Allocation(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_WX_Audio_Allocation();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Tuner_Wx_fn(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Tuner_Wx_fn(Courier::Int32 const & aEventId);
#ifdef CIT_SIMULATION
bool CallAction_Perform_Testmode_Context(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Testmode_Context();
#ifdef CIT_SIMULATION
bool CallAction_gacChangeLanguageReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacChangeLanguageReq(enLanguageId const & aLanguageId);
#ifdef CIT_SIMULATION
bool CallAction_gacHideFocusInViewReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacHideFocusInViewReq(::Courier::ViewId const & aView);
#ifdef CIT_SIMULATION
bool CallAction_NextLevelTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_NextLevelTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_PreviousLevelTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_PreviousLevelTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_DualViewLeftTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_DualViewLeftTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_DualViewRightTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_DualViewRightTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_PageFlipBackTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_PageFlipBackTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_PageFlipFrontTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_PageFlipFrontTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_ZoomInTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_ZoomInTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos);
#ifdef CIT_SIMULATION
bool CallAction_ZoomOutTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_ZoomOutTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos);
#ifdef CIT_SIMULATION
bool CallAction_FadeTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_FadeTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_gacWaitAnimationStartReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacWaitAnimationStartReq();
#ifdef CIT_SIMULATION
bool CallAction_acFocusOnRightEncoderReqUpd(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acFocusOnRightEncoderReqUpd(bool const & aIsFocusUsed);
#ifdef CIT_SIMULATION
bool CallAction_acSetGadgetSceenActiveStatus(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSetGadgetSceenActiveStatus(bool const & aIsGadgetAtive);
#ifdef CIT_SIMULATION
bool CallAction_acHKNotificationMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acHKNotificationMsg(Courier::UInt8 const & aHKCode, Courier::UInt8 const & aHKState);
#ifdef CIT_SIMULATION
bool CallAction_acPerform_CloseAllDropdowns(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPerform_CloseAllDropdowns();
#ifdef CIT_SIMULATION
bool CallAction_acPerform_CloseDropdown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPerform_CloseDropdown(::Courier::UInt32 const & aListId);
#ifdef CIT_SIMULATION
bool CallAction_acPerform_OpenDropdown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPerform_OpenDropdown(::Courier::UInt32 const & aListId);
#ifdef CIT_SIMULATION
bool CallAction_acPerform_ToggleDropdown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPerform_ToggleDropdown(::Courier::UInt32 const & aListId);
#ifdef CIT_SIMULATION
bool CallAction_acStartAppPopupTimer(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acStartAppPopupTimer(Courier::UInt32 const & aViewId, Courier::UInt32 const & aTimeout);
#ifdef CIT_SIMULATION
bool CallAction_acStopAppPopupTimer(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acStopAppPopupTimer(Courier::UInt32 const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_acPostBeep(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPostBeep(Courier::Int32 const & aBeepType);
#ifdef CIT_SIMULATION
bool CallAction_gacCheckToClosePopup(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacCheckToClosePopup(Courier::UInt32 const & aPopupId);
#ifdef CIT_SIMULATION
bool CallAction_acRestartAppPopupTimer(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acRestartAppPopupTimer(Courier::UInt32 const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchBackRes(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacContextSwitchBackRes(Courier::UInt32 const & aSwitchId);
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchCompleteRes(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacContextSwitchCompleteRes(Courier::UInt32 const & aSwitchId);
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchFailedRes(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacContextSwitchFailedRes(Courier::UInt32 const & aSwitchId);
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchDoneRes(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacContextSwitchDoneRes(Courier::UInt32 const & aSwitchId);
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchOutReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacContextSwitchOutReq(Courier::UInt32 const & aTargetContextId, Courier::UInt32 const & aSourceContextId, Courier::UInt32 const & aTargetAppId);
#ifdef CIT_SIMULATION
bool CallAction_gacCurrentScreenDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacCurrentScreenDisplayReq();
#ifdef CIT_SIMULATION
bool CallAction_gacLaunchBarDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacLaunchBarDisplayReq(bool const & aVisibility);
#ifdef CIT_SIMULATION
bool CallAction_gacNavTBTSwipe(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacNavTBTSwipe();
#ifdef CIT_SIMULATION
bool CallAction_gacPerformListBtnRightEncoderChangeUpd(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPerformListBtnRightEncoderChangeUpd(Courier::Int8 const & aSteps, Courier::UInt32 const & aListId, Courier::UInt32 const & aRowId, Courier::UInt32 const & aColumnId);
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListUp(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollListUp();
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListDown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollListDown();
#ifdef CIT_SIMULATION
bool CallAction_gacScrollPageUp(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollPageUp();
#ifdef CIT_SIMULATION
bool CallAction_gacScrollPageDown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollPageDown();
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListFocusUp(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollListFocusUp(Courier::UInt32 const & aListId);
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListFocusDown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollListFocusDown(Courier::UInt32 const & aListId);
#ifdef CIT_SIMULATION
bool CallAction_gacPerformListFocusLockDataResetUpd(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPerformListFocusLockDataResetUpd();
#ifdef CIT_SIMULATION
bool CallAction_gacSetApplicationMode(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacSetApplicationMode(Courier::UInt32 const & aModeId);
#ifdef CIT_SIMULATION
bool CallAction_gacSpellerBbehaviorReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacSpellerBbehaviorReq(bool const & aEnable);
#ifdef CIT_SIMULATION
bool CallAction_gacStatusBarDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacStatusBarDisplayReq(bool const & aVisibility, Courier::Int32 const & aHeaderType);
#ifdef CIT_SIMULATION
bool CallAction_gacTBTRetriggerAcousticOutput(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacTBTRetriggerAcousticOutput();
#ifdef CIT_SIMULATION
bool CallAction_gacWaitAnimationStopReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacWaitAnimationStopReq();
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewCreateReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateAllReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewCreateAllReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewDestroyReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewDestroyReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewClearReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewClearReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewShowReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewShowReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewHideReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewHideReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateWithoutLoadReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewCreateWithoutLoadReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewAsyncLoadReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewAsyncLoadReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewActivateWithoutRenderingReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewActivateWithoutRenderingReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupCreateAndSBShowReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupCreateAndSBShowReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupCreateAndSBShowReqForMultiDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupCreateAndSBShowReqForMultiDisplay(Courier::UInt32 const & aPopupDisplayID, ::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupSBCloseReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupSBCloseReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupSBCloseReqForMultiDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupSBCloseReqForMultiDisplay(Courier::UInt32 const & aPopupDisplayID, ::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupRestartTimerReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupRestartTimerReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupRestartTimerReqForMultiDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupRestartTimerReqForMultiDisplay(Courier::UInt32 const & aPopupDisplayID, ::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateAndShowReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewCreateAndShowReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewHideAndDestroyReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewHideAndDestroyReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacSceneTransitionEnter(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacSceneTransitionEnter(::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint);
#ifdef CIT_SIMULATION
bool CallAction_gacSceneTransitionLeave(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacSceneTransitionLeave(::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint);
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayStatusLineReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDisplayStatusLineReq(Courier::Int32 const & aDisplayRegionType);
#ifdef CIT_SIMULATION
bool CallAction_gacHideStatusLineReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacHideStatusLineReq(Courier::Int32 const & aDisplayRegionType);
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayFooterLineReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDisplayFooterLineReq();
#ifdef CIT_SIMULATION
bool CallAction_gacHideFooterLineReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacHideFooterLineReq();
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayStatusLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDisplayStatusLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacHideStatusLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacHideStatusLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayFooterLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDisplayFooterLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacHideFooterLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacHideFooterLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacRegisterForCloseOnTouchSession(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacRegisterForCloseOnTouchSession(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacDeregisterForCloseOnTouchSessionReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDeregisterForCloseOnTouchSessionReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterPrioEnableReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterPrioEnableReq(Courier::UInt32 const & aPrio);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterAllEnableReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterAllEnableReq();
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterDisableReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterDisableReq();
#ifdef CIT_SIMULATION
bool CallAction_gacProfileChange(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacProfileChange(Courier::UInt32 const & aProfile);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterPrioEnableReqForDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterPrioEnableReqForDisplay(Courier::UInt32 const & aPrio, Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterAllEnableReqForDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterAllEnableReqForDisplay(Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterDisableReqForDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterDisableReqForDisplay(Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacStartSceneTransitionAnimation(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacStartSceneTransitionAnimation(::Courier::ViewId const & aSourceView, ::Courier::ViewId const & aDestinationView, Courier::UInt32 const & aUserData1, Courier::Int8 const & aUserData2);
#ifdef CIT_SIMULATION
bool CallAction_gacDecrementActiveAnimationCount(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDecrementActiveAnimationCount();

// overall number of HierarchyNodes
static const ::FeatStd::UInt32 cGlobalDataItemHierarchyNodeCount = 256;
// overall number of DataItemDescriptor nodes
static const ::FeatStd::UInt32 cDataItemDescriptorCount = 256;
// overall number of BindingSources
static const ::FeatStd::UInt32 cBindingSourceCount = 34;
// maximum number of HierarchyNodes in a BindingSource
static const ::FeatStd::UInt32 cBindingSourceItemCountMax = 28;

// =========================================================================

class DAB_Test_ModeDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 28;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 1;
    static const ::Courier::DataItemKey cDataItemKey = 82;

    typedef ::DAB_Test_ModeData Data;

    DAB_Test_ModeDataBindingSource();
};

typedef ::Courier::DataItemMsg< DAB_Test_ModeDataBindingSource > DAB_Test_ModeDataItemMsg;

// =========================================================================

class DAB_Setup_Screen_ActiveTuner_InfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 6;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 2;
    static const ::Courier::DataItemKey cDataItemKey = 86;

    typedef ::DAB_Setup_Screen_ActiveTuner_InfoData Data;

    DAB_Setup_Screen_ActiveTuner_InfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< DAB_Setup_Screen_ActiveTuner_InfoDataBindingSource > DAB_Setup_Screen_ActiveTuner_InfoDataItemMsg;

// =========================================================================

class Smart_InfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 3;
    static const ::Courier::DataItemKey cDataItemKey = 198;

    typedef ::Smart_InfoData Data;

    Smart_InfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< Smart_InfoDataBindingSource > Smart_InfoDataItemMsg;

// =========================================================================

class DABTestModeEnsembleInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 4;
    static const ::Courier::DataItemKey cDataItemKey = 196;

    typedef ::DABTestModeEnsembleInfoData Data;

    DABTestModeEnsembleInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< DABTestModeEnsembleInfoDataBindingSource > DABTestModeEnsembleInfoDataItemMsg;

// =========================================================================

class HealthCareMonitorDTCinfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 5;
    static const ::Courier::DataItemKey cDataItemKey = 140;

    typedef ::HealthCareMonitorDTCinfoData Data;

    HealthCareMonitorDTCinfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< HealthCareMonitorDTCinfoDataBindingSource > HealthCareMonitorDTCinfoDataItemMsg;

// =========================================================================

class Tuner1DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 14;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 6;
    static const ::Courier::DataItemKey cDataItemKey = 143;

    typedef ::Tuner1Data Data;

    Tuner1DataBindingSource();
};

typedef ::Courier::DataItemMsg< Tuner1DataBindingSource > Tuner1DataItemMsg;

// =========================================================================

class Tuner2DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 14;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 7;
    static const ::Courier::DataItemKey cDataItemKey = 107;

    typedef ::Tuner2Data Data;

    Tuner2DataBindingSource();
};

typedef ::Courier::DataItemMsg< Tuner2DataBindingSource > Tuner2DataItemMsg;

// =========================================================================

class Tuner3DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 14;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 8;
    static const ::Courier::DataItemKey cDataItemKey = 127;

    typedef ::Tuner3Data Data;

    Tuner3DataBindingSource();
};

typedef ::Courier::DataItemMsg< Tuner3DataBindingSource > Tuner3DataItemMsg;

// =========================================================================

class Tuner4DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 14;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 9;
    static const ::Courier::DataItemKey cDataItemKey = 247;

    typedef ::Tuner4Data Data;

    Tuner4DataBindingSource();
};

typedef ::Courier::DataItemMsg< Tuner4DataBindingSource > Tuner4DataItemMsg;

// =========================================================================

class DABGTestModeInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 5;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 10;
    static const ::Courier::DataItemKey cDataItemKey = 206;

    typedef ::DABGTestModeInfoData Data;

    DABGTestModeInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< DABGTestModeInfoDataBindingSource > DABGTestModeInfoDataItemMsg;

// =========================================================================

class DAB_Setup_ScreenDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 11;
    static const ::Courier::DataItemKey cDataItemKey = 173;

    typedef ::DAB_Setup_ScreenData Data;

    DAB_Setup_ScreenDataBindingSource();
};

typedef ::Courier::DataItemMsg< DAB_Setup_ScreenDataBindingSource > DAB_Setup_ScreenDataItemMsg;

// =========================================================================

class DABGTestModeAnnoStatusInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 12;
    static const ::Courier::DataItemKey cDataItemKey = 237;

    typedef ::DABGTestModeAnnoStatusInfoData Data;

    DABGTestModeAnnoStatusInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< DABGTestModeAnnoStatusInfoDataBindingSource > DABGTestModeAnnoStatusInfoDataItemMsg;

// =========================================================================

class DABGTestModeActiveCompDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 13;
    static const ::Courier::DataItemKey cDataItemKey = 208;

    typedef ::DABGTestModeActiveCompData Data;

    DABGTestModeActiveCompDataBindingSource();
};

typedef ::Courier::DataItemMsg< DABGTestModeActiveCompDataBindingSource > DABGTestModeActiveCompDataItemMsg;

// =========================================================================

class DABTestModeGAvailabiltyInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 14;
    static const ::Courier::DataItemKey cDataItemKey = 204;

    typedef ::DABTestModeGAvailabiltyInfoData Data;

    DABTestModeGAvailabiltyInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< DABTestModeGAvailabiltyInfoDataBindingSource > DABTestModeGAvailabiltyInfoDataItemMsg;

// =========================================================================

class DABTestModeServiceFollowingInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 15;
    static const ::Courier::DataItemKey cDataItemKey = 165;

    typedef ::DABTestModeServiceFollowingInfoData Data;

    DABTestModeServiceFollowingInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< DABTestModeServiceFollowingInfoDataBindingSource > DABTestModeServiceFollowingInfoDataItemMsg;

// =========================================================================

class EngineeringInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 10;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 16;
    static const ::Courier::DataItemKey cDataItemKey = 195;

    typedef ::EngineeringInfoData Data;

    EngineeringInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< EngineeringInfoDataBindingSource > EngineeringInfoDataItemMsg;

// =========================================================================

class EngineeringInfo1DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 9;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 17;
    static const ::Courier::DataItemKey cDataItemKey = 100;

    typedef ::EngineeringInfo1Data Data;

    EngineeringInfo1DataBindingSource();
};

typedef ::Courier::DataItemMsg< EngineeringInfo1DataBindingSource > EngineeringInfo1DataItemMsg;

// =========================================================================

class EngineeringInfo2DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 16;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 18;
    static const ::Courier::DataItemKey cDataItemKey = 155;

    typedef ::EngineeringInfo2Data Data;

    EngineeringInfo2DataBindingSource();
};

typedef ::Courier::DataItemMsg< EngineeringInfo2DataBindingSource > EngineeringInfo2DataItemMsg;

// =========================================================================

class TunerSource_BandDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 13;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 19;
    static const ::Courier::DataItemKey cDataItemKey = 67;

    typedef ::TunerSource_BandData Data;

    TunerSource_BandDataBindingSource();
};

typedef ::Courier::DataItemMsg< TunerSource_BandDataBindingSource > TunerSource_BandDataItemMsg;

// =========================================================================

class PresetInfoWBDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 13;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 20;
    static const ::Courier::DataItemKey cDataItemKey = 24;

    typedef ::PresetInfoWBData Data;

    PresetInfoWBDataBindingSource();
};

typedef ::Courier::DataItemMsg< PresetInfoWBDataBindingSource > PresetInfoWBDataItemMsg;

// =========================================================================

class WBPresetInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 11;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 21;
    static const ::Courier::DataItemKey cDataItemKey = 135;

    typedef ::WBPresetInfoData Data;

    WBPresetInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< WBPresetInfoDataBindingSource > WBPresetInfoDataItemMsg;

// =========================================================================

class FMSetupMenuInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 6;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 22;
    static const ::Courier::DataItemKey cDataItemKey = 79;

    typedef ::FMSetupMenuInfoData Data;

    FMSetupMenuInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< FMSetupMenuInfoDataBindingSource > FMSetupMenuInfoDataItemMsg;

// =========================================================================

class AudioTestModeDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 23;
    static const ::Courier::DataItemKey cDataItemKey = 99;

    typedef ::AudioTestModeData Data;

    AudioTestModeDataBindingSource();
};

typedef ::Courier::DataItemMsg< AudioTestModeDataBindingSource > AudioTestModeDataItemMsg;

// =========================================================================

class PhoneTestMode_ListItemDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 24;
    static const ::Courier::DataItemKey cDataItemKey = 118;

    typedef ::PhoneTestMode_ListItemData Data;

    PhoneTestMode_ListItemDataBindingSource();
};

typedef ::Courier::DataItemMsg< PhoneTestMode_ListItemDataBindingSource > PhoneTestMode_ListItemDataItemMsg;

// =========================================================================

class ListId_FlexDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 25;
    static const ::Courier::DataItemKey cDataItemKey = 49;

    typedef ::ListId_FlexData Data;

    ListId_FlexDataBindingSource();
};

typedef ::Courier::DataItemMsg< ListId_FlexDataBindingSource > ListId_FlexDataItemMsg;

// =========================================================================

class ListDataSizeDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 26;
    static const ::Courier::DataItemKey cDataItemKey = 36;

    typedef ::ListDataSizeData Data;

    ListDataSizeDataBindingSource();
};

typedef ::Courier::DataItemMsg< ListDataSizeDataBindingSource > ListDataSizeDataItemMsg;

// =========================================================================

class SystemSettingTestModeDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 27;
    static const ::Courier::DataItemKey cDataItemKey = 226;

    typedef ::SystemSettingTestModeData Data;

    SystemSettingTestModeDataBindingSource();
};

typedef ::Courier::DataItemMsg< SystemSettingTestModeDataBindingSource > SystemSettingTestModeDataItemMsg;

// =========================================================================

class RVCTestModeDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 28;
    static const ::Courier::DataItemKey cDataItemKey = 221;

    typedef ::RVCTestModeData Data;

    RVCTestModeDataBindingSource();
};

typedef ::Courier::DataItemMsg< RVCTestModeDataBindingSource > RVCTestModeDataItemMsg;

// =========================================================================

class SxmChannelInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 16;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 29;
    static const ::Courier::DataItemKey cDataItemKey = 11;

    typedef ::SxmChannelInfoData Data;

    SxmChannelInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< SxmChannelInfoDataBindingSource > SxmChannelInfoDataItemMsg;

// =========================================================================

class SxmTpopChannelInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 30;
    static const ::Courier::DataItemKey cDataItemKey = 59;

    typedef ::SxmTpopChannelInfoData Data;

    SxmTpopChannelInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< SxmTpopChannelInfoDataBindingSource > SxmTpopChannelInfoDataItemMsg;

// =========================================================================

class PresetInfoSXMDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 19;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 31;
    static const ::Courier::DataItemKey cDataItemKey = 104;

    typedef ::PresetInfoSXMData Data;

    PresetInfoSXMDataBindingSource();
};

typedef ::Courier::DataItemMsg< PresetInfoSXMDataBindingSource > PresetInfoSXMDataItemMsg;

// =========================================================================

class SXMAntennaInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 32;
    static const ::Courier::DataItemKey cDataItemKey = 89;

    typedef ::SXMAntennaInfoData Data;

    SXMAntennaInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< SXMAntennaInfoDataBindingSource > SXMAntennaInfoDataItemMsg;

// =========================================================================

class ListScrollBarInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 33;
    static const ::Courier::DataItemKey cDataItemKey = 73;

    typedef ::ListScrollBarInfoData Data;

    ListScrollBarInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< ListScrollBarInfoDataBindingSource > ListScrollBarInfoDataItemMsg;

namespace ItemKey {
        static const ::Courier::DataItemKey InvalidItem = 0;
        static const ::Courier::DataItemKey SxmChannelInfoItem = 11;
        static const ::Courier::DataItemKey PresetInfoWBItem = 24;
        static const ::Courier::DataItemKey ListDataSizeItem = 36;
        static const ::Courier::DataItemKey ListId_FlexItem = 49;
        static const ::Courier::DataItemKey SxmTpopChannelInfoItem = 59;
        static const ::Courier::DataItemKey TunerSource_BandItem = 67;
        static const ::Courier::DataItemKey ListScrollBarInfoItem = 73;
        static const ::Courier::DataItemKey FMSetupMenuInfoItem = 79;
        static const ::Courier::DataItemKey DAB_Test_ModeItem = 82;
        static const ::Courier::DataItemKey DAB_Setup_Screen_ActiveTuner_InfoItem = 86;
        static const ::Courier::DataItemKey SXMAntennaInfoItem = 89;
        static const ::Courier::DataItemKey AudioTestModeItem = 99;
        static const ::Courier::DataItemKey EngineeringInfo1Item = 100;
        static const ::Courier::DataItemKey PresetInfoSXMItem = 104;
        static const ::Courier::DataItemKey Tuner2Item = 107;
        static const ::Courier::DataItemKey PhoneTestMode_ListItemItem = 118;
        static const ::Courier::DataItemKey Tuner3Item = 127;
        static const ::Courier::DataItemKey WBPresetInfoItem = 135;
        static const ::Courier::DataItemKey HealthCareMonitorDTCinfoItem = 140;
        static const ::Courier::DataItemKey Tuner1Item = 143;
        static const ::Courier::DataItemKey EngineeringInfo2Item = 155;
        static const ::Courier::DataItemKey DABTestModeServiceFollowingInfoItem = 165;
        static const ::Courier::DataItemKey DAB_Setup_ScreenItem = 173;
        static const ::Courier::DataItemKey EngineeringInfoItem = 195;
        static const ::Courier::DataItemKey DABTestModeEnsembleInfoItem = 196;
        static const ::Courier::DataItemKey Smart_InfoItem = 198;
        static const ::Courier::DataItemKey DABTestModeGAvailabiltyInfoItem = 204;
        static const ::Courier::DataItemKey DABGTestModeInfoItem = 206;
        static const ::Courier::DataItemKey DABGTestModeActiveCompItem = 208;
        static const ::Courier::DataItemKey RVCTestModeItem = 221;
        static const ::Courier::DataItemKey SystemSettingTestModeItem = 226;
        static const ::Courier::DataItemKey DABGTestModeAnnoStatusInfoItem = 237;
        static const ::Courier::DataItemKey Tuner4Item = 247;

    namespace SxmChannelInfo {
            static const ::Courier::DataItemKey ChannelIDItem = 180;
            static const ::Courier::DataItemKey CategoryNameItem = 199;
            static const ::Courier::DataItemKey ArtistNameItem = 20;
            static const ::Courier::DataItemKey SongTitleItem = 167;
            static const ::Courier::DataItemKey PresetNumberItem = 250;
            static const ::Courier::DataItemKey ChannelNameItem = 9;
            static const ::Courier::DataItemKey SxmCGVisibilityItem = 236;
            static const ::Courier::DataItemKey SxmAlbumartVisibilityItem = 191;
            static const ::Courier::DataItemKey PresetNumberVisibilityItem = 48;
            static const ::Courier::DataItemKey AdvisoryMessageItem = 227;
            static const ::Courier::DataItemKey AdvisoryMessageVisibilityItem = 178;
            static const ::Courier::DataItemKey StatusLineTextorIconItem = 2;
            static const ::Courier::DataItemKey PresetNumberForGadgetItem = 124;
            static const ::Courier::DataItemKey SxmInitializedItem = 253;
            static const ::Courier::DataItemKey SongTitleAndArtistNameItem = 205;
    } // namespace SxmChannelInfo

    namespace PresetInfoWB {
            static const ::Courier::DataItemKey WBName1Item = 161;
            static const ::Courier::DataItemKey WBName2Item = 182;
            static const ::Courier::DataItemKey WBName3Item = 133;
            static const ::Courier::DataItemKey WBName4Item = 149;
            static const ::Courier::DataItemKey WBName5Item = 97;
            static const ::Courier::DataItemKey WBName6Item = 114;
            static const ::Courier::DataItemKey WBName7Item = 44;
            static const ::Courier::DataItemKey WBName8Item = 58;
            static const ::Courier::DataItemKey WBName9Item = 15;
            static const ::Courier::DataItemKey WBName10Item = 132;
            static const ::Courier::DataItemKey WBmodeItem = 238;
            static const ::Courier::DataItemKey WBFrequencyItem = 145;
    } // namespace PresetInfoWB

    namespace ListDataSize {
            static const ::Courier::DataItemKey TestmodeBTListSizeItem = 217;
    } // namespace ListDataSize

    namespace ListId_Flex {
            static const ::Courier::DataItemKey TestmodeListIdItem = 21;
    } // namespace ListId_Flex

    namespace SxmTpopChannelInfo {
            static const ::Courier::DataItemKey ChannelIDItem = 7;
            static const ::Courier::DataItemKey ChannelNameItem = 108;
    } // namespace SxmTpopChannelInfo

    namespace TunerSource_Band {
            static const ::Courier::DataItemKey TunerSource1Item = 231;
            static const ::Courier::DataItemKey TunerSource2Item = 214;
            static const ::Courier::DataItemKey TunerSource3Item = 76;
            static const ::Courier::DataItemKey TunerSource4Item = 61;
            static const ::Courier::DataItemKey BandEnable1Item = 28;
            static const ::Courier::DataItemKey BandEnable2Item = 46;
            static const ::Courier::DataItemKey BandEnable3Item = 138;
            static const ::Courier::DataItemKey BandEnable4Item = 101;
            static const ::Courier::DataItemKey Band1Item = 129;
            static const ::Courier::DataItemKey Band2Item = 84;
            static const ::Courier::DataItemKey Band3Item = 90;
            static const ::Courier::DataItemKey Band4Item = 43;
    } // namespace TunerSource_Band

    namespace ListScrollBarInfo {
            static const ::Courier::DataItemKey EnabledItem = 233;
    } // namespace ListScrollBarInfo

    namespace FMSetupMenuInfo {
            static const ::Courier::DataItemKey ToggleAFItem = 213;
            static const ::Courier::DataItemKey ToggleMMItem = 8;
            static const ::Courier::DataItemKey ToggleTA_statusItem = 14;
            static const ::Courier::DataItemKey ToggleRDSItem = 220;
            static const ::Courier::DataItemKey TogglePhaseDiversityItem = 27;
    } // namespace FMSetupMenuInfo

    namespace DAB_Test_Mode {
            static const ::Courier::DataItemKey channel_NumItem = 246;
            static const ::Courier::DataItemKey Ensemble_LblItem = 119;
            static const ::Courier::DataItemKey Ensemble_IDItem = 126;
            static const ::Courier::DataItemKey Service_IDItem = 210;
            static const ::Courier::DataItemKey Ensemble_freqItem = 26;
            static const ::Courier::DataItemKey Service_LblItem = 4;
            static const ::Courier::DataItemKey Aud_Data_Bit_RateItem = 121;
            static const ::Courier::DataItemKey MSCItem = 111;
            static const ::Courier::DataItemKey FICItem = 30;
            static const ::Courier::DataItemKey NetbitErrorrateItem = 189;
            static const ::Courier::DataItemKey NETItem = 234;
            static const ::Courier::DataItemKey RS_FECItem = 113;
            static const ::Courier::DataItemKey Sync_flagItem = 3;
            static const ::Courier::DataItemKey QAItem = 33;
            static const ::Courier::DataItemKey QSItem = 179;
            static const ::Courier::DataItemKey Field_StrengthItem = 125;
            static const ::Courier::DataItemKey Mute_flagItem = 207;
            static const ::Courier::DataItemKey Bg_tuner_ens_freqItem = 232;
            static const ::Courier::DataItemKey Bg_Ensemble_IDItem = 240;
            static const ::Courier::DataItemKey Bg_FICItem = 71;
            static const ::Courier::DataItemKey Audio_ModeItem = 110;
            static const ::Courier::DataItemKey Freq_TableItem = 154;
            static const ::Courier::DataItemKey BGModeItem = 243;
            static const ::Courier::DataItemKey BGSync_flagItem = 106;
            static const ::Courier::DataItemKey TASrcItem = 85;
            static const ::Courier::DataItemKey DABIconVisibilityItem = 144;
            static const ::Courier::DataItemKey SXMIconVisibilityItem = 164;
    } // namespace DAB_Test_Mode

    namespace DAB_Setup_Screen_ActiveTuner_Info {
            static const ::Courier::DataItemKey DRCItem = 192;
            static const ::Courier::DataItemKey PSItem = 116;
            static const ::Courier::DataItemKey SM_ACCItem = 153;
            static const ::Courier::DataItemKey SRItem = 32;
            static const ::Courier::DataItemKey TPItem = 34;
    } // namespace DAB_Setup_Screen_ActiveTuner_Info

    namespace SXMAntennaInfo {
            static const ::Courier::DataItemKey AntennaStatusItem = 109;
    } // namespace SXMAntennaInfo

    namespace AudioTestMode {
            static const ::Courier::DataItemKey LinearAudioItem = 78;
            static const ::Courier::DataItemKey FMEnhancerItem = 112;
    } // namespace AudioTestMode

    namespace EngineeringInfo1 {
            static const ::Courier::DataItemKey MultipathQualityItem = 38;
            static const ::Courier::DataItemKey nChannelItem = 150;
            static const ::Courier::DataItemKey RDSItem = 25;
            static const ::Courier::DataItemKey AntennaStatusItem = 136;
            static const ::Courier::DataItemKey ReceptionQualityItem = 91;
            static const ::Courier::DataItemKey SzSharxItem = 60;
            static const ::Courier::DataItemKey SzHicutItem = 55;
            static const ::Courier::DataItemKey TPFlagItem = 157;
    } // namespace EngineeringInfo1

    namespace PresetInfoSXM {
            static const ::Courier::DataItemKey PSName1Item = 57;
            static const ::Courier::DataItemKey PSName2Item = 47;
            static const ::Courier::DataItemKey PSName3Item = 95;
            static const ::Courier::DataItemKey PSName4Item = 190;
            static const ::Courier::DataItemKey PSName5Item = 239;
            static const ::Courier::DataItemKey PSName6Item = 229;
            static const ::Courier::DataItemKey PSName7Item = 16;
            static const ::Courier::DataItemKey PSName8Item = 156;
            static const ::Courier::DataItemKey PSName9Item = 141;
            static const ::Courier::DataItemKey PSName10Item = 184;
            static const ::Courier::DataItemKey PSName11Item = 188;
            static const ::Courier::DataItemKey PSName12Item = 174;
            static const ::Courier::DataItemKey PSName13Item = 218;
            static const ::Courier::DataItemKey PSName14Item = 201;
            static const ::Courier::DataItemKey PSName15Item = 17;
            static const ::Courier::DataItemKey PSName16Item = 235;
            static const ::Courier::DataItemKey PSName17Item = 50;
            static const ::Courier::DataItemKey PSName18Item = 35;
    } // namespace PresetInfoSXM

    namespace Tuner2 {
            static const ::Courier::DataItemKey FreqItem = 194;
            static const ::Courier::DataItemKey PIItem = 62;
            static const ::Courier::DataItemKey PSItem = 122;
            static const ::Courier::DataItemKey FSQItem = 120;
            static const ::Courier::DataItemKey HicutItem = 102;
            static const ::Courier::DataItemKey SharxItem = 245;
            static const ::Courier::DataItemKey TPItem = 53;
            static const ::Courier::DataItemKey TAItem = 52;
            static const ::Courier::DataItemKey RDSItem = 151;
            static const ::Courier::DataItemKey AFItem = 131;
            static const ::Courier::DataItemKey DevItem = 160;
            static const ::Courier::DataItemKey CSItem = 193;
            static const ::Courier::DataItemKey MPNCItem = 228;
    } // namespace Tuner2

    namespace PhoneTestMode_ListItem {
            static const ::Courier::DataItemKey TestmodeListItemValueItem = 211;
            static const ::Courier::DataItemKey TestmodeListItemNameItem = 186;
    } // namespace PhoneTestMode_ListItem

    namespace Tuner3 {
            static const ::Courier::DataItemKey FreqItem = 249;
            static const ::Courier::DataItemKey PIItem = 203;
            static const ::Courier::DataItemKey PSItem = 19;
            static const ::Courier::DataItemKey FSQItem = 170;
            static const ::Courier::DataItemKey HicutItem = 251;
            static const ::Courier::DataItemKey SharxItem = 176;
            static const ::Courier::DataItemKey TPItem = 163;
            static const ::Courier::DataItemKey TAItem = 219;
            static const ::Courier::DataItemKey RDSItem = 5;
            static const ::Courier::DataItemKey AFItem = 139;
            static const ::Courier::DataItemKey DevItem = 202;
            static const ::Courier::DataItemKey CSItem = 12;
            static const ::Courier::DataItemKey MPNCItem = 41;
    } // namespace Tuner3

    namespace WBPresetInfo {
            static const ::Courier::DataItemKey Preset_1_ActiveItem = 22;
            static const ::Courier::DataItemKey Preset_2_ActiveItem = 1;
            static const ::Courier::DataItemKey Preset_3_ActiveItem = 168;
            static const ::Courier::DataItemKey Preset_4_ActiveItem = 242;
            static const ::Courier::DataItemKey Preset_5_ActiveItem = 215;
            static const ::Courier::DataItemKey Preset_6_ActiveItem = 166;
            static const ::Courier::DataItemKey Preset_7_ActiveItem = 87;
            static const ::Courier::DataItemKey Preset_8_ActiveItem = 241;
            static const ::Courier::DataItemKey Preset_9_ActiveItem = 147;
            static const ::Courier::DataItemKey Preset_10_ActiveItem = 183;
    } // namespace WBPresetInfo

    namespace HealthCareMonitorDTCinfo {
            static const ::Courier::DataItemKey HCMDTCline1Item = 209;
            static const ::Courier::DataItemKey HCMDTCline2Item = 222;
            static const ::Courier::DataItemKey HCMDTCline3Item = 172;
    } // namespace HealthCareMonitorDTCinfo

    namespace Tuner1 {
            static const ::Courier::DataItemKey FreqItem = 51;
            static const ::Courier::DataItemKey PIItem = 94;
            static const ::Courier::DataItemKey PSItem = 29;
            static const ::Courier::DataItemKey FSQItem = 98;
            static const ::Courier::DataItemKey HicutItem = 64;
            static const ::Courier::DataItemKey SharxItem = 115;
            static const ::Courier::DataItemKey TPItem = 230;
            static const ::Courier::DataItemKey TAItem = 81;
            static const ::Courier::DataItemKey RDSItem = 10;
            static const ::Courier::DataItemKey AFItem = 137;
            static const ::Courier::DataItemKey DevItem = 162;
            static const ::Courier::DataItemKey CSItem = 134;
            static const ::Courier::DataItemKey MPNCItem = 244;
    } // namespace Tuner1

    namespace EngineeringInfo2 {
            static const ::Courier::DataItemKey TAFlagItem = 103;
            static const ::Courier::DataItemKey AltFrequencyItem = 6;
            static const ::Courier::DataItemKey AFonOffItem = 225;
            static const ::Courier::DataItemKey BandscanOnOffItem = 152;
            static const ::Courier::DataItemKey MeasureOnOffItem = 200;
            static const ::Courier::DataItemKey FreqStepFMItem = 187;
            static const ::Courier::DataItemKey FreqStepAMItem = 56;
            static const ::Courier::DataItemKey RFLevelAMItem = 128;
            static const ::Courier::DataItemKey LinearAudioItem = 197;
            static const ::Courier::DataItemKey AMTunerItem = 148;
            static const ::Courier::DataItemKey FMTuner1Item = 123;
            static const ::Courier::DataItemKey FMTuner2Item = 13;
            static const ::Courier::DataItemKey FMTuner3Item = 31;
            static const ::Courier::DataItemKey FMTuner4Item = 37;
            static const ::Courier::DataItemKey DABTunerItem = 80;
    } // namespace EngineeringInfo2

    namespace DABTestModeServiceFollowingInfo {
            static const ::Courier::DataItemKey TSUItem = 117;
    } // namespace DABTestModeServiceFollowingInfo

    namespace DAB_Setup_Screen {
            static const ::Courier::DataItemKey ServiceLinkingItem = 255;
            static const ::Courier::DataItemKey ConcealmentLevelItem = 254;
    } // namespace DAB_Setup_Screen

    namespace EngineeringInfo {
            static const ::Courier::DataItemKey _szFrequencyItem = 68;
            static const ::Courier::DataItemKey _szPSNameItem = 45;
            static const ::Courier::DataItemKey _szPIItem = 42;
            static const ::Courier::DataItemKey _szFieldstrengthItem = 39;
            static const ::Courier::DataItemKey _szQualityItem = 65;
            static const ::Courier::DataItemKey _szSharxItem = 159;
            static const ::Courier::DataItemKey _szHicutItem = 83;
            static const ::Courier::DataItemKey _szFMDeviationItem = 216;
            static const ::Courier::DataItemKey _szChannelSeparationItem = 92;
    } // namespace EngineeringInfo

    namespace DABTestModeEnsembleInfo {
            static const ::Courier::DataItemKey NoOfAud_DataServiceCompItem = 146;
            static const ::Courier::DataItemKey NoOfAud_DataServiceItem = 177;
            static const ::Courier::DataItemKey NoOfEnsemblesItem = 105;
    } // namespace DABTestModeEnsembleInfo

    namespace Smart_Info {
            static const ::Courier::DataItemKey NaviIconVisibilityItem = 72;
            static const ::Courier::DataItemKey CameraIconVisibilityItem = 175;
    } // namespace Smart_Info

    namespace DABTestModeGAvailabiltyInfo {
            static const ::Courier::DataItemKey TAItem = 185;
            static const ::Courier::DataItemKey IndicatorItem = 171;
            static const ::Courier::DataItemKey DABDABItem = 212;
    } // namespace DABTestModeGAvailabiltyInfo

    namespace DABGTestModeInfo {
            static const ::Courier::DataItemKey FMItem = 66;
            static const ::Courier::DataItemKey PIItem = 69;
            static const ::Courier::DataItemKey QFMItem = 40;
            static const ::Courier::DataItemKey PLItem = 181;
    } // namespace DABGTestModeInfo

    namespace DABGTestModeActiveComp {
            static const ::Courier::DataItemKey SCItem = 224;
            static const ::Courier::DataItemKey SCTypeItem = 142;
    } // namespace DABGTestModeActiveComp

    namespace RVCTestMode {
            static const ::Courier::DataItemKey ToggleVisibleItem = 223;
    } // namespace RVCTestMode

    namespace SystemSettingTestMode {
            static const ::Courier::DataItemKey SettingScreenTestItem = 18;
    } // namespace SystemSettingTestMode

    namespace DABGTestModeAnnoStatusInfo {
            static const ::Courier::DataItemKey ASWItem = 54;
            static const ::Courier::DataItemKey ASUItem = 75;
    } // namespace DABGTestModeAnnoStatusInfo

    namespace Tuner4 {
            static const ::Courier::DataItemKey FreqItem = 130;
            static const ::Courier::DataItemKey PIItem = 158;
            static const ::Courier::DataItemKey PSItem = 70;
            static const ::Courier::DataItemKey FSQItem = 93;
            static const ::Courier::DataItemKey HicutItem = 77;
            static const ::Courier::DataItemKey SharxItem = 169;
            static const ::Courier::DataItemKey TPItem = 96;
            static const ::Courier::DataItemKey TAItem = 74;
            static const ::Courier::DataItemKey RDSItem = 23;
            static const ::Courier::DataItemKey AFItem = 248;
            static const ::Courier::DataItemKey DevItem = 88;
            static const ::Courier::DataItemKey CSItem = 252;
            static const ::Courier::DataItemKey MPNCItem = 63;
    } // namespace Tuner4
} // namespace ItemKey

bool InitDataBinding();

#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
namespace FeatStd {
// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DAB_Test_ModeDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DAB_Test_ModeDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DAB_Setup_Screen_ActiveTuner_InfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DAB_Setup_Screen_ActiveTuner_InfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Smart_InfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Smart_InfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DABTestModeEnsembleInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DABTestModeEnsembleInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HealthCareMonitorDTCinfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HealthCareMonitorDTCinfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Tuner1DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Tuner1DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Tuner2DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Tuner2DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Tuner3DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Tuner3DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Tuner4DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Tuner4DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DABGTestModeInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DABGTestModeInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DAB_Setup_ScreenDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DAB_Setup_ScreenDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DABGTestModeAnnoStatusInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DABGTestModeAnnoStatusInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DABGTestModeActiveCompDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DABGTestModeActiveCompDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DABTestModeGAvailabiltyInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DABTestModeGAvailabiltyInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DABTestModeServiceFollowingInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DABTestModeServiceFollowingInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::EngineeringInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::EngineeringInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::EngineeringInfo1DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::EngineeringInfo1DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::EngineeringInfo2DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::EngineeringInfo2DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::TunerSource_BandDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::TunerSource_BandDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PresetInfoWBDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PresetInfoWBDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::WBPresetInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::WBPresetInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::FMSetupMenuInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::FMSetupMenuInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::AudioTestModeDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::AudioTestModeDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PhoneTestMode_ListItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PhoneTestMode_ListItemDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ListId_FlexDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ListId_FlexDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ListDataSizeDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ListDataSizeDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SystemSettingTestModeDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SystemSettingTestModeDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::RVCTestModeDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::RVCTestModeDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmChannelInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmChannelInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmTpopChannelInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmTpopChannelInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PresetInfoSXMDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PresetInfoSXMDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SXMAntennaInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SXMAntennaInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ListScrollBarInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ListScrollBarInfoDataBindingSource > const& dataItemContainer);
} // namespace FeatStd
#endif // FEATSTD_STRINGBUFFER_APPENDER_ENABLED
#endif // AppHmi_TestmodeStateMachine_h
