/************************************************************************
*FILE: AppHmi_SystemStateMachine.cpp 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#include "AppHmi_SystemStateMachine.h"
#include <FeatStd/Util/StaticObject.h>
#include <Cit/VisualStateGlueLayer/VisualStateGlueLayer.h>
#include <Courier/Util/Util.h>
using namespace ::hmibase;

//====  defines and includes TTFis output - added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
#include "hmi_trace_if.h"
#include "View/CGI/CourierMsgTracing/CourierMessageMapTrace.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_SM
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/AppHmi_SystemStateMachine.cpp.trc.h"
#endif                            
//====  defines and includes TTFis output - end                        key: SM_TTFis_SBHFMSRF ====

// ------------------------------------------------------------------------

// ------------------------------------------------------------------------
bool SendUpdatePopupTextReqMsg(enPopUpType const & aPopupTextID)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::UpdatePopupTextReqMsg)(aPopupTextID);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSystemInstallationMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SystemInstallationMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSWUpdateAbortRebootMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SWUpdateAbortRebootMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendOEMPinOkMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::OEMPinOkMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendStartUSBStickBinaryValidationReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::StartUSBStickBinaryValidationReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSetSoftwareUpdateTypeMsg(enSoftwareUpdateType const & aUpdateType)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SetSoftwareUpdateTypeMsg)(aUpdateType);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendEnableButtonsonNopopMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::EnableButtonsonNopopMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendStartDownloadReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::StartDownloadReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSetReleaseFilterReqMsg(enSoftwareDownloadMode const & aDownloadMode)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SetReleaseFilterReqMsg)(aDownloadMode);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendStartMISStageOneUpdateMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::StartMISStageOneUpdateMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendrvcEntryView()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::rvcEntryView)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendrvcExitView()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::rvcExitView)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendHandlePendingSWDLMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::HandlePendingSWDLMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendChangeMeasurementvalueReqMsg(enMenu const & aMeasurementOptions, enReaction const & aReaction)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ChangeMeasurementvalueReqMsg)(aMeasurementOptions, aReaction);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendChangeClockTimeformatReqMsg(enTimeformatOption const & aTimeFormatOptions, enReaction const & aReaction)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ChangeClockTimeformatReqMsg)(aTimeFormatOptions, aReaction);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendChangeGpsClockTimeformatReqMsg(enGpsClkTimeformatOption const & aGpsTimeFormatOptions, enReaction const & aReaction)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ChangeGpsClockTimeformatReqMsg)(aGpsTimeFormatOptions, aReaction);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendChangeGpsClockClkModeReqMsg(enGpsClkClockModeformatOption const & aGpsClkClockModeOptions, enReaction const & aReaction)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ChangeGpsClockClkModeReqMsg)(aGpsClkClockModeOptions, aReaction);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendChangeClockTimeZoneReqMsg(Courier::UInt16 const & aSelectedTimeZoneItem)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ChangeClockTimeZoneReqMsg)(aSelectedTimeZoneItem);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendChangeClockformatReqMsg(enClockformatOption const & aClockFormatOptions, enReaction const & aReaction)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ChangeClockformatReqMsg)(aClockFormatOptions, aReaction);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendChangeAuxlevelvalueReqMsg(enAuxlevelOption const & aAuxLevelOptions, enReaction const & aReaction)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ChangeAuxlevelvalueReqMsg)(aAuxLevelOptions, aReaction);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendChangeDisplaySettingModevalueReqMsg(enDisplaySettingModeOption const & aDisplaySettingModeOptions, enReaction const & aReaction)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ChangeDisplaySettingModevalueReqMsg)(aDisplaySettingModeOptions, aReaction);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendChangeLCDOnOff4GammaCASettingModevalReqMsg(enLCDOnOffGammaCASettingModeOption const & aLCDOnOffGammaCASettingModeOptions, enReaction const & aReaction)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ChangeLCDOnOff4GammaCASettingModevalReqMsg)(aLCDOnOffGammaCASettingModeOptions, aReaction);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendChangeMonitorUpDown4GammaCASettingModevalReqMsg(enMonitorUpDownGammaCASettingModeOption const & aMonitorUpDownGammaCASettingModeOptions, enReaction const & aReaction)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ChangeMonitorUpDown4GammaCASettingModevalReqMsg)(aMonitorUpDownGammaCASettingModeOptions, aReaction);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSwitchApplicationReq(enApplicationId const & aApplicationID, enSurfaceId const & aSurfaceID)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SwitchApplicationReq)(aApplicationID, aSurfaceID);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSwitchCabin_A_ApplicationReq(enApplicationId const & aApplicationID, enSurfaceId const & aSurfaceID)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SwitchCabin_A_ApplicationReq)(aApplicationID, aSurfaceID);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSwitchCabin_B_ApplicationReq(enApplicationId const & aApplicationID, enSurfaceId const & aSurfaceID)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SwitchCabin_B_ApplicationReq)(aApplicationID, aSurfaceID);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendChangeHourValueReq(Courier::UInt8 const & aHrValue_Incr_or_Decr)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ChangeHourValueReq)(aHrValue_Incr_or_Decr);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendChangeMinuteValueReq(Courier::UInt8 const & aMinuteValue_Incr_or_Decr)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ChangeMinuteValueReq)(aMinuteValue_Incr_or_Decr);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendTimeFormatPL_Msg(Courier::UInt8 const & aTimeFormat_12Hor24H)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::TimeFormatPL_Msg)(aTimeFormat_12Hor24H);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendCLKSetModePL_Msg(Courier::UInt8 const & aCLKSetModeGPS_Manual_PL)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::CLKSetModePL_Msg)(aCLKSetModeGPS_Manual_PL);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendDateFormat_PL_EU_HMI(Courier::UInt8 const & aDateEU)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::DateFormat_PL_EU_HMI)(aDateEU);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendDateFormat_PL_CN_HMI(Courier::UInt8 const & aDateCN)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::DateFormat_PL_CN_HMI)(aDateCN);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendChangeLanguageReq(Courier::UInt8 const & aRegion_ID, Courier::UInt8 const & aCountry_ID, Courier::UInt8 const & aLanguage_ID)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ChangeLanguageReq)(aRegion_ID, aCountry_ID, aLanguage_ID);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendTimeZone_PL(Courier::UInt16 const & aTimeZone)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::TimeZone_PL)(aTimeZone);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendUpdateCLKSetModeResp(Courier::UInt8 const & aUpdated_CLKSetMode)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::UpdateCLKSetModeResp)(aUpdated_CLKSetMode);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendUpdate_EntryIDSoundSettings(Courier::UInt8 const & aEntryFromApp)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::Update_EntryIDSoundSettings)(aEntryFromApp);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendDayLightSaving_Touch_PL(bool const & aDayLightSaving_Touch)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::DayLightSaving_Touch_PL)(aDayLightSaving_Touch);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSpeedLockChangeReqMsg(Courier::Int8 const & aSLCheckBoxStatus)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SpeedLockChangeReqMsg)(aSLCheckBoxStatus);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendAS_Inc_Dec_Msg(Courier::Int8 const & aAS_Inc_Dec)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::AS_Inc_Dec_Msg)(aAS_Inc_Dec);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSwivelModeMsg(Courier::UInt8 const & aSelectedModeItem)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SwivelModeMsg)(aSelectedModeItem);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendCockpitModeMsg(enBatterySaverModeType const & aCockpitModeStatus)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::CockpitModeMsg)(aCockpitModeStatus);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPopupStatusMsg(Courier::UInt32 const & aActiveViewId, Courier::UInt8 const & aPopupStatus)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::PopupStatusMsg)(aActiveViewId, aPopupStatus);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSendPluginReq()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SendPluginReq)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendAS_AuxLevel_PL_Msg(Courier::Int8 const & aAS_AuxLevel_PL)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::AS_AuxLevel_PL_Msg)(aAS_AuxLevel_PL);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendAS_Beep_Touch_PL_Msg(Courier::Int8 const & aAS_Beep_Touch_PL)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::AS_Beep_Touch_PL_Msg)(aAS_Beep_Touch_PL);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendAS_Speed_Volume_PL_Msg(Courier::Int8 const & aAS_Speed_Volume_PL)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::AS_Speed_Volume_PL_Msg)(aAS_Speed_Volume_PL);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendAS_Equilizer_PL_Msg(Courier::Int8 const & aAS_Equilizer_PL)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::AS_Equilizer_PL_Msg)(aAS_Equilizer_PL);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendAS_SwitchSetting_Msg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::AS_SwitchSetting_Msg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendUpdateLanguageRegionCN_HMI(Candera::UInt8 const & aCandidateCN)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::UpdateLanguageRegionCN_HMI)(aCandidateCN);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendUpdateLanguageRegionGEX_HMI(Candera::UInt8 const & aCandidateGEX)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::UpdateLanguageRegionGEX_HMI)(aCandidateGEX);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSwitchApplicationStateReq(Candera::UInt16 const & aApplicationID, Candera::UInt16 const & aApplicationState, Candera::UInt8 const & aActivityID)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SwitchApplicationStateReq)(aApplicationID, aApplicationState, aActivityID);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSwitchToRVCApplication()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SwitchToRVCApplication)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSwitchToMediaApplication()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SwitchToMediaApplication)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSwitchToTunerApplication()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SwitchToTunerApplication)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendDecBrightnessLevelMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::DecBrightnessLevelMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendIncBrightnessLevelMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::IncBrightnessLevelMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendDecClockHourLevelMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::DecClockHourLevelMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendIncClockHourLevelMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::IncClockHourLevelMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendDecClockMinuteLevelMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::DecClockMinuteLevelMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendIncClockMinuteLevelMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::IncClockMinuteLevelMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendMediaRadioBack4mAudio()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::MediaRadioBack4mAudio)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendVideoMixedSourceBack4mCabinHome()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::VideoMixedSourceBack4mCabinHome)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendLevelOff()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::LevelOff)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendLevelOne()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::LevelOne)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendLevelTwo()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::LevelTwo)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendLevelThree()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::LevelThree)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPrivateModeLevelOne()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::PrivateModeLevelOne)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPrivateModeLevelTwo()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::PrivateModeLevelTwo)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPrivateModeLevelThree()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::PrivateModeLevelThree)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendEqlPrstFlat()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::EqlPrstFlat)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendEqlPrstPop()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::EqlPrstPop)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendEqlPrstRock()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::EqlPrstRock)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendEqlPrstHiphop()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::EqlPrstHiphop)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendEqlPrstClassic()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::EqlPrstClassic)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendEqlPrstJazz()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::EqlPrstJazz)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendDTCSubSystemCMC19SwDetailsMsg(Courier::UInt32 const & aCurrentSubSystemType)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::DTCSubSystemCMC19SwDetailsMsg)(aCurrentSubSystemType);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendListRefreshMsg(Courier::UInt32 const & aListId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ListRefreshMsg)(aListId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendClkDateFmt1()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ClkDateFmt1)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendGuiStartupFinishedUpdMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::GuiStartupFinishedUpdMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendClkDateFmt2()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ClkDateFmt2)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendClkDateFmt3()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ClkDateFmt3)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendClkDateFmt4()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ClkDateFmt4)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendClkDateFmt5()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ClkDateFmt5)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendClkDateFmt6()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ClkDateFmt6)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSettingSceneMsg(Courier::UInt16 const & aSettingType)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SettingSceneMsg)(aSettingType);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendStartPopupTimerReqMsg(Courier::UInt32 const & aViewId, Courier::UInt32 const & aTimeout)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::StartPopupTimerReqMsg)(aViewId, aTimeout);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendRebootOnSWDLCompleteMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::RebootOnSWDLCompleteMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendHandleRebootOnUSBRemovalMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::HandleRebootOnUSBRemovalMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendRequestMISupdateContextSwitchMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::RequestMISupdateContextSwitchMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendStartSWDowngrade()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::StartSWDowngrade)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendDisplayClockScene()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::DisplayClockScene)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendFactoryResetSM()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::FactoryResetSM)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendFactoryResetSMBeep()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::FactoryResetSMBeep)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendChangeLanguageReqMsg(enLanguageId const & aLanguageId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ChangeLanguageReqMsg)(aLanguageId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendFocusReqMsg(FocusActionEnum const & aAction, FocusTimerActionEnum const & aTimerAction, ::Courier::ViewId const & aView, Candera::String const & aWidget)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::FocusReqMsg)(aAction, aTimerAction, aView, aWidget);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendDummyMess(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::DummyMess)(aFirstView, aSecondView, aPos);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendAnimationReqMsg(Courier::AnimationAction::Enum const & aAnimationAction, ::Courier::ViewId const & aViewId, Courier::CompositePath const & aCompositePath, ::Courier::ItemId const & aAnimationId, Courier::AnimationProperties const & aAnimationProperties)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::Courier::AnimationReqMsg)(aAnimationAction, aViewId, aCompositePath, aAnimationId, aAnimationProperties);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendFocusOnRightEncoderReqUpdMsg(bool const & aIsFocusUsed)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::FocusOnRightEncoderReqUpdMsg)(aIsFocusUsed);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendStoreActiveGadgetReqMsg(bool const & aIsGadgetAtive)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::StoreActiveGadgetReqMsg)(aIsGadgetAtive);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendHardKeyPressNotificationMsg(Courier::UInt8 const & aDummy, Courier::UInt8 const & aHKCode, Courier::UInt8 const & aHKState)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::HardKeyPressNotificationMsg)(aDummy, aHKCode, aHKState);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendDropdownChangeMsg(::Candera::DropdownChangeType const & aDropdownChangeType, ::Courier::UInt32 const & aListId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::DropdownChangeMsg)(aDropdownChangeType, aListId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendStopPopupTimerReqMsg(Courier::UInt32 const & aViewId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::StopPopupTimerReqMsg)(aViewId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPlayBeepReqMsg(Courier::Int32 const & aBeepType)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::PlayBeepReqMsg)(aBeepType);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendCheckToClosePopupMsg(Courier::UInt32 const & aPopupId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::CheckToClosePopupMsg)(aPopupId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendRestartPopupTimerReqMsg(Courier::UInt32 const & aViewId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::RestartPopupTimerReqMsg)(aViewId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendContextSwitchInResMsg(Courier::UInt32 const & aSwitchId, Courier::UInt32 const & aResponseType)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ContextSwitchInResMsg)(aSwitchId, aResponseType);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendContextSwitchOutReqMsg(Courier::UInt32 const & aTargetContextId, Courier::UInt32 const & aSourceContextId, Courier::UInt32 const & aTargetAppId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ContextSwitchOutReqMsg)(aTargetContextId, aSourceContextId, aTargetAppId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendCurrentScreenDisplayReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::CurrentScreenDisplayReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendLaunchBarDisplayReqMsg(bool const & aVisibility)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::LaunchBarDisplayReqMsg)(aVisibility);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendNavTBTSwipeReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::NavTBTSwipeReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendListItemRightEncoderChangeUpdMsg(Courier::Int8 const & aSteps, Courier::UInt32 const & aListId, Courier::UInt32 const & aRowId, Courier::UInt32 const & aColumnId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ListItemRightEncoderChangeUpdMsg)(aSteps, aListId, aRowId, aColumnId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendListChangeMsg(::Courier::UInt32 const & aListId, ListChangeType const & aListChangeType, ::Courier::Int32 const & aValue, ListChangeMsgSourceType const & aListChangeMsgSource, bool const & aImmediatePositioning)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ListChangeMsg)(aListId, aListChangeType, aValue, aListChangeMsgSource, aImmediatePositioning);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendListFocusScrollReqMsg(Courier::UInt32 const & aListId, Courier::Int32 const & aSteps)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ListFocusScrollReqMsg)(aListId, aSteps);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendListFocusLockDataResetReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ListFocusLockDataResetReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSetApplicationModeReqMsg(Courier::UInt32 const & aModeId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SetApplicationModeReqMsg)(aModeId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSpellerBbehaviorReqMsg(bool const & aEnable)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SpellerBbehaviorReqMsg)(aEnable);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendStatusBarDisplayReqMsg(bool const & aVisibility, Courier::Int32 const & aHeaderType)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::StatusBarDisplayReqMsg)(aVisibility, aHeaderType);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendTBTRetriggerAcousticMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::TBTRetriggerAcousticMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendViewReqMsg(Courier::ViewAction::Enum const & aViewAction, ::Courier::ViewId const & aViewId, bool const & aShallInitScene, bool const & aShallLoadScene)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::Courier::ViewReqMsg)(aViewAction, aViewId, aShallInitScene, aShallLoadScene);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendActivationReqMsg(::Courier::ViewId const & aViewId, bool const & aActivation, bool const & aEnableRendering)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::Courier::ActivationReqMsg)(aViewId, aActivation, aEnableRendering);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendAsyncLoadReqMsg(::Courier::ViewId const & aViewId, bool const & aLoad)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::Courier::AsyncLoadReqMsg)(aViewId, aLoad);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPopupReqMsg(hmibase::popups::CommandEnum const & aCommand, ::Courier::ViewId const & aViewId, Courier::UInt32 const & aPopupDisplayID)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::PopupReqMsg)(aCommand, aViewId, aPopupDisplayID);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendExtendedViewReqMsg(hmibase::views::CommandEnum const & aCommand, ::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ExtendedViewReqMsg)(aCommand, aViewId, aHint);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendShowHMISubSurfaceReqMsg(hmibase::displayRegion const & aDisplayRegion, Courier::Int32 const & aDisplayRegionType, bool const & aShowSubSurface, Courier::UInt32 const & aDisplayID, bool const & aLockSubSurface)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ShowHMISubSurfaceReqMsg)(aDisplayRegion, aDisplayRegionType, aShowSubSurface, aDisplayID, aLockSubSurface);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendRegisterForCloseOnTouchSessionReqMsg(bool const & aRegister, ::Courier::ViewId const & aViewId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::RegisterForCloseOnTouchSessionReqMsg)(aRegister, aViewId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPopupFilterPrioEnableReqMsg(Courier::UInt32 const & aPrio)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::PopupFilterPrioEnableReqMsg)(aPrio);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPopupFilterAllEnableReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::PopupFilterAllEnableReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPopupFilterDisableReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::PopupFilterDisableReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendProfileSwitchMsg(Courier::UInt32 const & aProfile)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ProfileSwitchMsg)(aProfile);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendMultiDisplayPopupFilterReqMsg(hmibase::PopupFilterType const & aPopupFilterType, Courier::UInt32 const & aPrio, Courier::UInt32 const & aDisplayID)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::MultiDisplayPopupFilterReqMsg)(aPopupFilterType, aPrio, aDisplayID);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendCreateNewDestroyOld(::Courier::ViewId const & aSourceView, ::Courier::ViewId const & aDestinationView, Courier::UInt32 const & aUserData1, Courier::Int8 const & aUserData2)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::CreateNewDestroyOld)(aSourceView, aDestinationView, aUserData1, aUserData2);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendNotifierMessage()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::NotifierMessage)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acUpdatePopupText(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acUpdatePopupText(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acUpdatePopupText(enPopUpType const & aPopupTextID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action acUpdatePopupText(aPopupTextID = ?enPopUpType?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendUpdatePopupTextReqMsg(aPopupTextID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSystemInstallation(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acSystemInstallation();
    return true;
}
#endif
void Action_acSystemInstallation()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action acSystemInstallation()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSystemInstallationMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSWUpdateAbortReboot(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acSWUpdateAbortReboot();
    return true;
}
#endif
void Action_acSWUpdateAbortReboot()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action acSWUpdateAbortReboot()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSWUpdateAbortRebootMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acOEMPinOk(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acOEMPinOk();
    return true;
}
#endif
void Action_acOEMPinOk()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action acOEMPinOk()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendOEMPinOkMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acStartUSBStickBinaryValidation(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acStartUSBStickBinaryValidation();
    return true;
}
#endif
void Action_acStartUSBStickBinaryValidation()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action acStartUSBStickBinaryValidation()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendStartUSBStickBinaryValidationReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSetSoftwareUpdateType(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acSetSoftwareUpdateType(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acSetSoftwareUpdateType(enSoftwareUpdateType const & aUpdateType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action acSetSoftwareUpdateType(aUpdateType = ?enSoftwareUpdateType?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSetSoftwareUpdateTypeMsg(aUpdateType);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acEnableButtonsonNopopType(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acEnableButtonsonNopopType();
    return true;
}
#endif
void Action_acEnableButtonsonNopopType()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action acEnableButtonsonNopopType()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendEnableButtonsonNopopMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acStartSoftwareDownload(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acStartSoftwareDownload();
    return true;
}
#endif
void Action_acStartSoftwareDownload()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action acStartSoftwareDownload()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendStartDownloadReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSetReleaseFilter(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acSetReleaseFilter(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acSetReleaseFilter(enSoftwareDownloadMode const & aDownloadMode)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action acSetReleaseFilter(aDownloadMode = ?enSoftwareDownloadMode?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSetReleaseFilterReqMsg(aDownloadMode);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acStartMISStageOneUpdate(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acStartMISStageOneUpdate();
    return true;
}
#endif
void Action_acStartMISStageOneUpdate()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action acStartMISStageOneUpdate()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendStartMISStageOneUpdateMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acRVCEntryViewUpdate(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acRVCEntryViewUpdate();
    return true;
}
#endif
void Action_acRVCEntryViewUpdate()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action acRVCEntryViewUpdate()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendrvcEntryView();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acRVCExitViewupdate(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acRVCExitViewupdate();
    return true;
}
#endif
void Action_acRVCExitViewupdate()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action acRVCExitViewupdate()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendrvcExitView();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acHandlePendingSWDL(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acHandlePendingSWDL();
    return true;
}
#endif
void Action_acHandlePendingSWDL()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action acHandlePendingSWDL()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendHandlePendingSWDLMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_ChangeMeasurementvalueReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_ChangeMeasurementvalueReq(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_ChangeMeasurementvalueReq(enMenu const & aMeasurementOptions)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action ChangeMeasurementvalueReq(aMeasurementOptions = ?enMenu?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendChangeMeasurementvalueReqMsg(aMeasurementOptions, enReaction());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_ChangeClockTimeformatReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_ChangeClockTimeformatReq(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_ChangeClockTimeformatReq(enTimeformatOption const & aTimeFormatOptions)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action ChangeClockTimeformatReq(aTimeFormatOptions = ?enTimeformatOption?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendChangeClockTimeformatReqMsg(aTimeFormatOptions, enReaction());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_ChangeGpsClockTimeformatReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_ChangeGpsClockTimeformatReq(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_ChangeGpsClockTimeformatReq(enGpsClkTimeformatOption const & aGpsTimeFormatOptions)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action ChangeGpsClockTimeformatReq(aGpsTimeFormatOptions = ?enGpsClkTimeformatOption?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendChangeGpsClockTimeformatReqMsg(aGpsTimeFormatOptions, enReaction());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_ChangeGpsClockClkModeReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_ChangeGpsClockClkModeReq(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_ChangeGpsClockClkModeReq(enGpsClkClockModeformatOption const & aGpsClkClockModeOptions)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action ChangeGpsClockClkModeReq(aGpsClkClockModeOptions = ?enGpsClkClockModeformatOption?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendChangeGpsClockClkModeReqMsg(aGpsClkClockModeOptions, enReaction());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_ChangeClockTimeZoneReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_ChangeClockTimeZoneReq(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_ChangeClockTimeZoneReq(Courier::UInt16 const & aSelectedTimeZoneItem)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action ChangeClockTimeZoneReq(aSelectedTimeZoneItem = %d)", aSelectedTimeZoneItem));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendChangeClockTimeZoneReqMsg(aSelectedTimeZoneItem);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_ChangeClockformatReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_ChangeClockformatReq(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_ChangeClockformatReq(enClockformatOption const & aClockFormatOptions)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action ChangeClockformatReq(aClockFormatOptions = ?enClockformatOption?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendChangeClockformatReqMsg(aClockFormatOptions, enReaction());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_ChangeAuxlevelvalueReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_ChangeAuxlevelvalueReq(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_ChangeAuxlevelvalueReq(enAuxlevelOption const & aAuxLevelOptions)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action ChangeAuxlevelvalueReq(aAuxLevelOptions = ?enAuxlevelOption?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendChangeAuxlevelvalueReqMsg(aAuxLevelOptions, enReaction());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_ChangeDisplaySettingModevalueReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_ChangeDisplaySettingModevalueReq(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_ChangeDisplaySettingModevalueReq(enDisplaySettingModeOption const & aDisplaySettingModeOptions)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action ChangeDisplaySettingModevalueReq(aDisplaySettingModeOptions = ?enDisplaySettingModeOption?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendChangeDisplaySettingModevalueReqMsg(aDisplaySettingModeOptions, enReaction());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_ChangeLCDOnOff4GammaCASettingModevalReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_ChangeLCDOnOff4GammaCASettingModevalReq(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_ChangeLCDOnOff4GammaCASettingModevalReq(enLCDOnOffGammaCASettingModeOption const & aLCDOnOffGammaCASettingModeOptions)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action ChangeLCDOnOff4GammaCASettingModevalReq(aLCDOnOffGammaCASettingModeOptions = ?enLCDOnOffGammaCASettingModeOption?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendChangeLCDOnOff4GammaCASettingModevalReqMsg(aLCDOnOffGammaCASettingModeOptions, enReaction());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_ChangeMonitorUpDown4GammaCASettingModevalReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_ChangeMonitorUpDown4GammaCASettingModevalReq(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_ChangeMonitorUpDown4GammaCASettingModevalReq(enMonitorUpDownGammaCASettingModeOption const & aMonitorUpDownGammaCASettingModeOptions)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action ChangeMonitorUpDown4GammaCASettingModevalReq(aMonitorUpDownGammaCASettingModeOptions = ?enMonitorUpDownGammaCASettingModeOption?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendChangeMonitorUpDown4GammaCASettingModevalReqMsg(aMonitorUpDownGammaCASettingModeOptions, enReaction());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Activate_Home_Source(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Activate_Home_Source();
    return true;
}
#endif
void Action_Perform_Activate_Home_Source()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_Activate_Home_Source()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSwitchApplicationReq(APPID_APPHMI_MASTER, SURFACEID_MAIN_SURFACE_MASTER);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Activate_RVC_Source(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Activate_RVC_Source();
    return true;
}
#endif
void Action_Perform_Activate_RVC_Source()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_Activate_RVC_Source()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSwitchApplicationReq(APPID_APPHMI_MASTER, SURFACEID_MAIN_SURFACE_MASTER);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Activate_Home_Cabin_A(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Activate_Home_Cabin_A();
    return true;
}
#endif
void Action_Perform_Activate_Home_Cabin_A()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_Activate_Home_Cabin_A()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSwitchCabin_A_ApplicationReq(APPID_APPHMI_MASTER, SURFACEID_MAIN_SURFACE_MASTER);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Activate_Home_Cabin_B(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Activate_Home_Cabin_B();
    return true;
}
#endif
void Action_Perform_Activate_Home_Cabin_B()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_Activate_Home_Cabin_B()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSwitchCabin_B_ApplicationReq(APPID_APPHMI_MASTER, SURFACEID_MAIN_SURFACE_MASTER);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Hour_Dec(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Hour_Dec();
    return true;
}
#endif
void Action_Perform_Hour_Dec()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_Hour_Dec()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendChangeHourValueReq(1);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Hour_Inc(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Hour_Inc();
    return true;
}
#endif
void Action_Perform_Hour_Inc()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_Hour_Inc()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendChangeHourValueReq(2);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Minute_Dec(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Minute_Dec();
    return true;
}
#endif
void Action_Perform_Minute_Dec()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_Minute_Dec()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendChangeMinuteValueReq(1);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Minute_Inc(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Minute_Inc();
    return true;
}
#endif
void Action_Perform_Minute_Inc()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_Minute_Inc()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendChangeMinuteValueReq(2);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_TimeFormat12H(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_TimeFormat12H();
    return true;
}
#endif
void Action_Perform_TimeFormat12H()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_TimeFormat12H()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTimeFormatPL_Msg(1);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_TimeFormat24H(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_TimeFormat24H();
    return true;
}
#endif
void Action_Perform_TimeFormat24H()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_TimeFormat24H()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTimeFormatPL_Msg(2);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_CLKSetMode_GPS(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_CLKSetMode_GPS();
    return true;
}
#endif
void Action_Perform_CLKSetMode_GPS()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_CLKSetMode_GPS()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendCLKSetModePL_Msg(1);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_CLKSetMode_Manual(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_CLKSetMode_Manual();
    return true;
}
#endif
void Action_Perform_CLKSetMode_Manual()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_CLKSetMode_Manual()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendCLKSetModePL_Msg(2);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_DateFormat_EU_1(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_DateFormat_EU_1();
    return true;
}
#endif
void Action_DateFormat_EU_1()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action DateFormat_EU_1()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDateFormat_PL_EU_HMI(1);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_DateFormat_EU_2(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_DateFormat_EU_2();
    return true;
}
#endif
void Action_DateFormat_EU_2()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action DateFormat_EU_2()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDateFormat_PL_EU_HMI(2);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_DateFormat_EU_3(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_DateFormat_EU_3();
    return true;
}
#endif
void Action_DateFormat_EU_3()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action DateFormat_EU_3()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDateFormat_PL_EU_HMI(3);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_DateFormat_EU_4(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_DateFormat_EU_4();
    return true;
}
#endif
void Action_DateFormat_EU_4()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action DateFormat_EU_4()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDateFormat_PL_EU_HMI(4);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_DateFormat_EU_5(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_DateFormat_EU_5();
    return true;
}
#endif
void Action_DateFormat_EU_5()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action DateFormat_EU_5()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDateFormat_PL_EU_HMI(5);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_DateFormat_EU_6(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_DateFormat_EU_6();
    return true;
}
#endif
void Action_DateFormat_EU_6()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action DateFormat_EU_6()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDateFormat_PL_EU_HMI(6);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_DateFormat_CN_1(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_DateFormat_CN_1();
    return true;
}
#endif
void Action_DateFormat_CN_1()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action DateFormat_CN_1()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDateFormat_PL_CN_HMI(1);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_DateFormat_CN_2(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_DateFormat_CN_2();
    return true;
}
#endif
void Action_DateFormat_CN_2()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action DateFormat_CN_2()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDateFormat_PL_CN_HMI(2);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Candidate_EU_1(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Candidate_EU_1();
    return true;
}
#endif
void Action_Candidate_EU_1()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Candidate_EU_1()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendChangeLanguageReq(1, 1, 1);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Candidate_EU_2(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Candidate_EU_2();
    return true;
}
#endif
void Action_Candidate_EU_2()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Candidate_EU_2()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendChangeLanguageReq(1, 1, 2);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Candidate_EU_3(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Candidate_EU_3();
    return true;
}
#endif
void Action_Candidate_EU_3()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Candidate_EU_3()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendChangeLanguageReq(1, 1, 3);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Candidate_EU_4(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Candidate_EU_4();
    return true;
}
#endif
void Action_Candidate_EU_4()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Candidate_EU_4()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendChangeLanguageReq(1, 1, 4);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Candidate_EU_5(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Candidate_EU_5();
    return true;
}
#endif
void Action_Candidate_EU_5()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Candidate_EU_5()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendChangeLanguageReq(1, 1, 5);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Candidate_EU_6(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Candidate_EU_6();
    return true;
}
#endif
void Action_Candidate_EU_6()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Candidate_EU_6()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendChangeLanguageReq(1, 1, 6);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Candidate_EU_7(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Candidate_EU_7();
    return true;
}
#endif
void Action_Candidate_EU_7()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Candidate_EU_7()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendChangeLanguageReq(1, 1, 7);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Candidate_EU_8(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Candidate_EU_8();
    return true;
}
#endif
void Action_Candidate_EU_8()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Candidate_EU_8()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendChangeLanguageReq(1, 1, 8);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Candidate_EU_9(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Candidate_EU_9();
    return true;
}
#endif
void Action_Candidate_EU_9()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Candidate_EU_9()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendChangeLanguageReq(1, 1, 9);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Candidate_EU_10(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Candidate_EU_10();
    return true;
}
#endif
void Action_Candidate_EU_10()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Candidate_EU_10()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendChangeLanguageReq(1, 1, 10);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Candidate_EU_11(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Candidate_EU_11();
    return true;
}
#endif
void Action_Candidate_EU_11()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Candidate_EU_11()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendChangeLanguageReq(1, 1, 11);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Candidate_EU_12(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Candidate_EU_12();
    return true;
}
#endif
void Action_Candidate_EU_12()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Candidate_EU_12()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendChangeLanguageReq(1, 1, 12);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Candidate_EU_13(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Candidate_EU_13();
    return true;
}
#endif
void Action_Candidate_EU_13()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Candidate_EU_13()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendChangeLanguageReq(1, 1, 13);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Candidate_EU_14(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Candidate_EU_14();
    return true;
}
#endif
void Action_Candidate_EU_14()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Candidate_EU_14()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendChangeLanguageReq(1, 1, 14);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Candidate_EU_15(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Candidate_EU_15();
    return true;
}
#endif
void Action_Candidate_EU_15()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Candidate_EU_15()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendChangeLanguageReq(1, 1, 15);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_1(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TimeZone_1();
    return true;
}
#endif
void Action_TimeZone_1()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action TimeZone_1()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTimeZone_PL(1);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_2(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TimeZone_2();
    return true;
}
#endif
void Action_TimeZone_2()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action TimeZone_2()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTimeZone_PL(2);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_3(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TimeZone_3();
    return true;
}
#endif
void Action_TimeZone_3()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action TimeZone_3()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTimeZone_PL(3);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_4(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TimeZone_4();
    return true;
}
#endif
void Action_TimeZone_4()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action TimeZone_4()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTimeZone_PL(4);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_5(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TimeZone_5();
    return true;
}
#endif
void Action_TimeZone_5()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action TimeZone_5()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTimeZone_PL(5);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_6(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TimeZone_6();
    return true;
}
#endif
void Action_TimeZone_6()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action TimeZone_6()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTimeZone_PL(6);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_7(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TimeZone_7();
    return true;
}
#endif
void Action_TimeZone_7()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action TimeZone_7()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTimeZone_PL(7);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_8(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TimeZone_8();
    return true;
}
#endif
void Action_TimeZone_8()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action TimeZone_8()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTimeZone_PL(8);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_9(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TimeZone_9();
    return true;
}
#endif
void Action_TimeZone_9()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action TimeZone_9()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTimeZone_PL(9);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_10(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TimeZone_10();
    return true;
}
#endif
void Action_TimeZone_10()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action TimeZone_10()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTimeZone_PL(10);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_11(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TimeZone_11();
    return true;
}
#endif
void Action_TimeZone_11()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action TimeZone_11()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTimeZone_PL(11);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_12(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TimeZone_12();
    return true;
}
#endif
void Action_TimeZone_12()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action TimeZone_12()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTimeZone_PL(12);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_13(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TimeZone_13();
    return true;
}
#endif
void Action_TimeZone_13()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action TimeZone_13()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTimeZone_PL(13);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_14(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TimeZone_14();
    return true;
}
#endif
void Action_TimeZone_14()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action TimeZone_14()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTimeZone_PL(14);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_15(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TimeZone_15();
    return true;
}
#endif
void Action_TimeZone_15()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action TimeZone_15()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTimeZone_PL(15);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_16(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TimeZone_16();
    return true;
}
#endif
void Action_TimeZone_16()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action TimeZone_16()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTimeZone_PL(16);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_17(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TimeZone_17();
    return true;
}
#endif
void Action_TimeZone_17()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action TimeZone_17()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTimeZone_PL(17);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_18(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TimeZone_18();
    return true;
}
#endif
void Action_TimeZone_18()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action TimeZone_18()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTimeZone_PL(18);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_19(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TimeZone_19();
    return true;
}
#endif
void Action_TimeZone_19()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action TimeZone_19()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTimeZone_PL(19);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_20(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TimeZone_20();
    return true;
}
#endif
void Action_TimeZone_20()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action TimeZone_20()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTimeZone_PL(20);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_21(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TimeZone_21();
    return true;
}
#endif
void Action_TimeZone_21()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action TimeZone_21()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTimeZone_PL(21);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_22(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TimeZone_22();
    return true;
}
#endif
void Action_TimeZone_22()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action TimeZone_22()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTimeZone_PL(22);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_23(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TimeZone_23();
    return true;
}
#endif
void Action_TimeZone_23()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action TimeZone_23()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTimeZone_PL(23);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_24(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TimeZone_24();
    return true;
}
#endif
void Action_TimeZone_24()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action TimeZone_24()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTimeZone_PL(24);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_25(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TimeZone_25();
    return true;
}
#endif
void Action_TimeZone_25()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action TimeZone_25()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTimeZone_PL(25);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_26(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TimeZone_26();
    return true;
}
#endif
void Action_TimeZone_26()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action TimeZone_26()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTimeZone_PL(26);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_27(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TimeZone_27();
    return true;
}
#endif
void Action_TimeZone_27()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action TimeZone_27()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTimeZone_PL(27);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_28(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TimeZone_28();
    return true;
}
#endif
void Action_TimeZone_28()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action TimeZone_28()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTimeZone_PL(28);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_29(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TimeZone_29();
    return true;
}
#endif
void Action_TimeZone_29()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action TimeZone_29()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTimeZone_PL(29);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_30(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TimeZone_30();
    return true;
}
#endif
void Action_TimeZone_30()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action TimeZone_30()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTimeZone_PL(30);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_31(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TimeZone_31();
    return true;
}
#endif
void Action_TimeZone_31()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action TimeZone_31()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTimeZone_PL(31);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_32(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TimeZone_32();
    return true;
}
#endif
void Action_TimeZone_32()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action TimeZone_32()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTimeZone_PL(32);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_33(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TimeZone_33();
    return true;
}
#endif
void Action_TimeZone_33()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action TimeZone_33()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTimeZone_PL(33);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_34(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TimeZone_34();
    return true;
}
#endif
void Action_TimeZone_34()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action TimeZone_34()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTimeZone_PL(34);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_35(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TimeZone_35();
    return true;
}
#endif
void Action_TimeZone_35()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action TimeZone_35()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTimeZone_PL(35);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_36(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TimeZone_36();
    return true;
}
#endif
void Action_TimeZone_36()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action TimeZone_36()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTimeZone_PL(36);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_37(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TimeZone_37();
    return true;
}
#endif
void Action_TimeZone_37()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action TimeZone_37()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTimeZone_PL(37);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_38(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TimeZone_38();
    return true;
}
#endif
void Action_TimeZone_38()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action TimeZone_38()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTimeZone_PL(38);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_39(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TimeZone_39();
    return true;
}
#endif
void Action_TimeZone_39()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action TimeZone_39()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTimeZone_PL(39);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_40(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TimeZone_40();
    return true;
}
#endif
void Action_TimeZone_40()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action TimeZone_40()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTimeZone_PL(40);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_41(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TimeZone_41();
    return true;
}
#endif
void Action_TimeZone_41()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action TimeZone_41()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTimeZone_PL(41);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_42(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TimeZone_42();
    return true;
}
#endif
void Action_TimeZone_42()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action TimeZone_42()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTimeZone_PL(42);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_43(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TimeZone_43();
    return true;
}
#endif
void Action_TimeZone_43()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action TimeZone_43()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTimeZone_PL(43);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_44(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TimeZone_44();
    return true;
}
#endif
void Action_TimeZone_44()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action TimeZone_44()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTimeZone_PL(44);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_45(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TimeZone_45();
    return true;
}
#endif
void Action_TimeZone_45()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action TimeZone_45()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTimeZone_PL(45);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_46(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TimeZone_46();
    return true;
}
#endif
void Action_TimeZone_46()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action TimeZone_46()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTimeZone_PL(46);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_47(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TimeZone_47();
    return true;
}
#endif
void Action_TimeZone_47()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action TimeZone_47()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTimeZone_PL(47);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_48(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_TimeZone_48();
    return true;
}
#endif
void Action_TimeZone_48()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action TimeZone_48()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTimeZone_PL(48);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_GoToGPS(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_GoToGPS();
    return true;
}
#endif
void Action_GoToGPS()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action GoToGPS()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendUpdateCLKSetModeResp(1);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_GoToManual(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_GoToManual();
    return true;
}
#endif
void Action_GoToManual()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action GoToManual()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendUpdateCLKSetModeResp(2);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Update_SoundSetting_Entry(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_Perform_Update_SoundSetting_Entry(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_Perform_Update_SoundSetting_Entry(Courier::UInt8 const & aEntryFromApp)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_Update_SoundSetting_Entry(aEntryFromApp = %d)", aEntryFromApp));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendUpdate_EntryIDSoundSettings(aEntryFromApp);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Touch(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Touch();
    return true;
}
#endif
void Action_Perform_Touch()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_Touch()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDayLightSaving_Touch_PL(1);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_SpeedLockTouch(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_SpeedLockTouch();
    return true;
}
#endif
void Action_Perform_SpeedLockTouch()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_SpeedLockTouch()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSpeedLockChangeReqMsg(1);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Bass_Dec(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Bass_Dec();
    return true;
}
#endif
void Action_Perform_Bass_Dec()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_Bass_Dec()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAS_Inc_Dec_Msg(1);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Bass_Inc(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Bass_Inc();
    return true;
}
#endif
void Action_Perform_Bass_Inc()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_Bass_Inc()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAS_Inc_Dec_Msg(2);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Treble_Dec(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Treble_Dec();
    return true;
}
#endif
void Action_Perform_Treble_Dec()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_Treble_Dec()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAS_Inc_Dec_Msg(3);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Treble_Inc(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Treble_Inc();
    return true;
}
#endif
void Action_Perform_Treble_Inc()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_Treble_Inc()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAS_Inc_Dec_Msg(4);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Balance_Inc(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Balance_Inc();
    return true;
}
#endif
void Action_Perform_Balance_Inc()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_Balance_Inc()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAS_Inc_Dec_Msg(5);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Balance_Dec(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Balance_Dec();
    return true;
}
#endif
void Action_Perform_Balance_Dec()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_Balance_Dec()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAS_Inc_Dec_Msg(6);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Fader_Inc(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Fader_Inc();
    return true;
}
#endif
void Action_Perform_Fader_Inc()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_Fader_Inc()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAS_Inc_Dec_Msg(7);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Fader_Dec(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Fader_Dec();
    return true;
}
#endif
void Action_Perform_Fader_Dec()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_Fader_Dec()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAS_Inc_Dec_Msg(8);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acPerformSwivelSetRequest(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acPerformSwivelSetRequest(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acPerformSwivelSetRequest(Courier::UInt8 const & aSelectedModeItem)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action acPerformSwivelSetRequest(aSelectedModeItem = %d)", aSelectedModeItem));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSwivelModeMsg(aSelectedModeItem);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_PerformCockpitMode(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_PerformCockpitMode(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_PerformCockpitMode(enBatterySaverModeType const & aCockpitModeStatus)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action PerformCockpitMode(aCockpitModeStatus = ?enBatterySaverModeType?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendCockpitModeMsg(aCockpitModeStatus);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSendPopupStatus(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_acSendPopupStatus(parameters[(::Json::Value::UInt)0].asUInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_acSendPopupStatus(Courier::UInt32 const & aActiveViewId, Courier::UInt8 const & aPopupStatus)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action acSendPopupStatus(aActiveViewId = %d, aPopupStatus = %d)", aActiveViewId,aPopupStatus));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupStatusMsg(aActiveViewId, aPopupStatus);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSendPluginReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acSendPluginReq();
    return true;
}
#endif
void Action_acSendPluginReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action acSendPluginReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSendPluginReq();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Aux_Loud(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Aux_Loud();
    return true;
}
#endif
void Action_Perform_Aux_Loud()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_Aux_Loud()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAS_AuxLevel_PL_Msg(1);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Aux_Middle(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Aux_Middle();
    return true;
}
#endif
void Action_Perform_Aux_Middle()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_Aux_Middle()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAS_AuxLevel_PL_Msg(2);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Aux_Quiet(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Aux_Quiet();
    return true;
}
#endif
void Action_Perform_Aux_Quiet()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_Aux_Quiet()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAS_AuxLevel_PL_Msg(3);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Beep(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Beep();
    return true;
}
#endif
void Action_Perform_Beep()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_Beep()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAS_Beep_Touch_PL_Msg(1);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Touch_Click(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Touch_Click();
    return true;
}
#endif
void Action_Perform_Touch_Click()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_Touch_Click()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAS_Beep_Touch_PL_Msg(2);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Speed_Off(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Speed_Off();
    return true;
}
#endif
void Action_Perform_Speed_Off()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_Speed_Off()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAS_Speed_Volume_PL_Msg(0);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Speed_Level1(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Speed_Level1();
    return true;
}
#endif
void Action_Perform_Speed_Level1()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_Speed_Level1()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAS_Speed_Volume_PL_Msg(1);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Speed_Level2(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Speed_Level2();
    return true;
}
#endif
void Action_Perform_Speed_Level2()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_Speed_Level2()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAS_Speed_Volume_PL_Msg(2);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Speed_Level3(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Speed_Level3();
    return true;
}
#endif
void Action_Perform_Speed_Level3()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_Speed_Level3()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAS_Speed_Volume_PL_Msg(3);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Equilizer_Flat(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Equilizer_Flat();
    return true;
}
#endif
void Action_Perform_Equilizer_Flat()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_Equilizer_Flat()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAS_Equilizer_PL_Msg(1);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Equilizer_Pop(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Equilizer_Pop();
    return true;
}
#endif
void Action_Perform_Equilizer_Pop()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_Equilizer_Pop()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAS_Equilizer_PL_Msg(2);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Equilizer_Rock(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Equilizer_Rock();
    return true;
}
#endif
void Action_Perform_Equilizer_Rock()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_Equilizer_Rock()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAS_Equilizer_PL_Msg(3);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Equilizer_Hiphop(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Equilizer_Hiphop();
    return true;
}
#endif
void Action_Perform_Equilizer_Hiphop()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_Equilizer_Hiphop()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAS_Equilizer_PL_Msg(4);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Equilizer_Classic(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Equilizer_Classic();
    return true;
}
#endif
void Action_Perform_Equilizer_Classic()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_Equilizer_Classic()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAS_Equilizer_PL_Msg(5);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Equilizer_Jazz(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Equilizer_Jazz();
    return true;
}
#endif
void Action_Perform_Equilizer_Jazz()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_Equilizer_Jazz()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAS_Equilizer_PL_Msg(6);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Back(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Back();
    return true;
}
#endif
void Action_Perform_Back()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_Back()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAS_SwitchSetting_Msg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_SetLanguageReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_SetLanguageReq();
    return true;
}
#endif
void Action_SetLanguageReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action SetLanguageReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendChangeLanguageReq(Courier::UInt8(), Courier::UInt8(), Courier::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Candidate_CN_1(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Candidate_CN_1();
    return true;
}
#endif
void Action_Candidate_CN_1()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Candidate_CN_1()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendUpdateLanguageRegionCN_HMI(1);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Candidate_CN_2(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Candidate_CN_2();
    return true;
}
#endif
void Action_Candidate_CN_2()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Candidate_CN_2()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendUpdateLanguageRegionCN_HMI(2);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Candidate_GEX_1(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Candidate_GEX_1();
    return true;
}
#endif
void Action_Candidate_GEX_1()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Candidate_GEX_1()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendUpdateLanguageRegionGEX_HMI(1);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Candidate_GEX_2(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Candidate_GEX_2();
    return true;
}
#endif
void Action_Candidate_GEX_2()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Candidate_GEX_2()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendUpdateLanguageRegionGEX_HMI(2);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Candidate_GEX_3(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Candidate_GEX_3();
    return true;
}
#endif
void Action_Candidate_GEX_3()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Candidate_GEX_3()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendUpdateLanguageRegionGEX_HMI(3);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Candidate_GEX_4(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Candidate_GEX_4();
    return true;
}
#endif
void Action_Candidate_GEX_4()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Candidate_GEX_4()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendUpdateLanguageRegionGEX_HMI(4);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Candidate_GEX_5(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Candidate_GEX_5();
    return true;
}
#endif
void Action_Candidate_GEX_5()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Candidate_GEX_5()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendUpdateLanguageRegionGEX_HMI(5);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Switch_SoundSettingsApp(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Switch_SoundSettingsApp();
    return true;
}
#endif
void Action_Perform_Switch_SoundSettingsApp()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_Switch_SoundSettingsApp()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSwitchApplicationStateReq(Candera::UInt16(), Candera::UInt16(), 0);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Switch_SecurityPINApp(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Switch_SecurityPINApp();
    return true;
}
#endif
void Action_Perform_Switch_SecurityPINApp()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_Switch_SecurityPINApp()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSwitchApplicationStateReq(118, Candera::UInt16(), 0);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Switch_RearViewCamera_SettingsApp(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Switch_RearViewCamera_SettingsApp();
    return true;
}
#endif
void Action_Perform_Switch_RearViewCamera_SettingsApp()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_Switch_RearViewCamera_SettingsApp()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSwitchToRVCApplication();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Switch_Media_SettingsApp(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Switch_Media_SettingsApp();
    return true;
}
#endif
void Action_Perform_Switch_Media_SettingsApp()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_Switch_Media_SettingsApp()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSwitchToMediaApplication();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Switch_Tuner_SettingsApp(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Switch_Tuner_SettingsApp();
    return true;
}
#endif
void Action_Perform_Switch_Tuner_SettingsApp()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_Switch_Tuner_SettingsApp()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSwitchToTunerApplication();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Brightness_Dec(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Brightness_Dec();
    return true;
}
#endif
void Action_Perform_Brightness_Dec()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_Brightness_Dec()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDecBrightnessLevelMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Brightness_Inc(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Brightness_Inc();
    return true;
}
#endif
void Action_Perform_Brightness_Inc()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_Brightness_Inc()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendIncBrightnessLevelMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_ClockHour_Dec(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_ClockHour_Dec();
    return true;
}
#endif
void Action_Perform_ClockHour_Dec()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_ClockHour_Dec()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDecClockHourLevelMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_ClockHour_Inc(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_ClockHour_Inc();
    return true;
}
#endif
void Action_Perform_ClockHour_Inc()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_ClockHour_Inc()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendIncClockHourLevelMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_ClockMinute_Dec(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_ClockMinute_Dec();
    return true;
}
#endif
void Action_Perform_ClockMinute_Dec()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_ClockMinute_Dec()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDecClockMinuteLevelMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_ClockMinute_Inc(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_ClockMinute_Inc();
    return true;
}
#endif
void Action_Perform_ClockMinute_Inc()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_ClockMinute_Inc()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendIncClockMinuteLevelMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_MediaRadioBack4mAudio(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_MediaRadioBack4mAudio();
    return true;
}
#endif
void Action_Perform_MediaRadioBack4mAudio()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_MediaRadioBack4mAudio()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendMediaRadioBack4mAudio();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_VideoMixedSourceBack4mCabinHome(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_VideoMixedSourceBack4mCabinHome();
    return true;
}
#endif
void Action_Perform_VideoMixedSourceBack4mCabinHome()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_VideoMixedSourceBack4mCabinHome()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendVideoMixedSourceBack4mCabinHome();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_LevelOff(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_LevelOff();
    return true;
}
#endif
void Action_Perform_LevelOff()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_LevelOff()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendLevelOff();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_LevelOne(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_LevelOne();
    return true;
}
#endif
void Action_Perform_LevelOne()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_LevelOne()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendLevelOne();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_LevelTwo(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_LevelTwo();
    return true;
}
#endif
void Action_Perform_LevelTwo()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_LevelTwo()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendLevelTwo();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_LevelThree(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_LevelThree();
    return true;
}
#endif
void Action_Perform_LevelThree()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_LevelThree()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendLevelThree();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_PrivateModeLevelOne(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_PrivateModeLevelOne();
    return true;
}
#endif
void Action_Perform_PrivateModeLevelOne()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_PrivateModeLevelOne()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPrivateModeLevelOne();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_PrivateModeLevelTwo(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_PrivateModeLevelTwo();
    return true;
}
#endif
void Action_Perform_PrivateModeLevelTwo()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_PrivateModeLevelTwo()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPrivateModeLevelTwo();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_PrivateModeLevelThree(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_PrivateModeLevelThree();
    return true;
}
#endif
void Action_Perform_PrivateModeLevelThree()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_PrivateModeLevelThree()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPrivateModeLevelThree();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_EqlPrstFlat(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_EqlPrstFlat();
    return true;
}
#endif
void Action_Perform_EqlPrstFlat()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_EqlPrstFlat()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendEqlPrstFlat();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_EqlPrstPop(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_EqlPrstPop();
    return true;
}
#endif
void Action_Perform_EqlPrstPop()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_EqlPrstPop()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendEqlPrstPop();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_EqlPrstRock(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_EqlPrstRock();
    return true;
}
#endif
void Action_Perform_EqlPrstRock()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_EqlPrstRock()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendEqlPrstRock();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_EqlPrstHiphop(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_EqlPrstHiphop();
    return true;
}
#endif
void Action_Perform_EqlPrstHiphop()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_EqlPrstHiphop()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendEqlPrstHiphop();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_EqlPrstClassic(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_EqlPrstClassic();
    return true;
}
#endif
void Action_Perform_EqlPrstClassic()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_EqlPrstClassic()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendEqlPrstClassic();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_EqlPrstJazz(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_EqlPrstJazz();
    return true;
}
#endif
void Action_Perform_EqlPrstJazz()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_EqlPrstJazz()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendEqlPrstJazz();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_DTCSubSystemCMC19SwDetailsMsg(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_Perform_DTCSubSystemCMC19SwDetailsMsg(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_Perform_DTCSubSystemCMC19SwDetailsMsg(Courier::UInt32 const & aCurrentSubSystemType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_DTCSubSystemCMC19SwDetailsMsg(aCurrentSubSystemType = %d)", aCurrentSubSystemType));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDTCSubSystemCMC19SwDetailsMsg(aCurrentSubSystemType);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acPerformListRefresh(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acPerformListRefresh(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acPerformListRefresh(Courier::UInt32 const & aListId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action acPerformListRefresh(aListId = %d)", aListId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListRefreshMsg(aListId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_ClkDateFmt1(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_ClkDateFmt1();
    return true;
}
#endif
void Action_Perform_ClkDateFmt1()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_ClkDateFmt1()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendClkDateFmt1();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Notify_Init_Finished(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Notify_Init_Finished();
    return true;
}
#endif
void Action_Notify_Init_Finished()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Notify_Init_Finished()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendGuiStartupFinishedUpdMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_ClkDateFmt2(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_ClkDateFmt2();
    return true;
}
#endif
void Action_Perform_ClkDateFmt2()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_ClkDateFmt2()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendClkDateFmt2();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_ClkDateFmt3(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_ClkDateFmt3();
    return true;
}
#endif
void Action_Perform_ClkDateFmt3()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_ClkDateFmt3()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendClkDateFmt3();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_ClkDateFmt4(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_ClkDateFmt4();
    return true;
}
#endif
void Action_Perform_ClkDateFmt4()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_ClkDateFmt4()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendClkDateFmt4();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_ClkDateFmt5(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_ClkDateFmt5();
    return true;
}
#endif
void Action_Perform_ClkDateFmt5()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_ClkDateFmt5()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendClkDateFmt5();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_ClkDateFmt6(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_ClkDateFmt6();
    return true;
}
#endif
void Action_Perform_ClkDateFmt6()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_ClkDateFmt6()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendClkDateFmt6();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_SettingSceneMsg(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_Perform_SettingSceneMsg(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_Perform_SettingSceneMsg(Courier::UInt16 const & aSettingType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_SettingSceneMsg(aSettingType = %d)", aSettingType));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSettingSceneMsg(aSettingType);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acStartPopupTimer(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_acStartPopupTimer(parameters[(::Json::Value::UInt)0].asUInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_acStartPopupTimer(Courier::UInt32 const & aViewId, Courier::UInt32 const & aTimeout)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action acStartPopupTimer(aViewId = %d, aTimeout = %d)", aViewId,aTimeout));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendStartPopupTimerReqMsg(aViewId, aTimeout);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acRebootOnSWDLComplete(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acRebootOnSWDLComplete();
    return true;
}
#endif
void Action_acRebootOnSWDLComplete()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action acRebootOnSWDLComplete()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendRebootOnSWDLCompleteMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acHandleRebootOnUSBRemoval(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acHandleRebootOnUSBRemoval();
    return true;
}
#endif
void Action_acHandleRebootOnUSBRemoval()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action acHandleRebootOnUSBRemoval()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendHandleRebootOnUSBRemovalMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acReqSWDLContextSwitchRequest(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acReqSWDLContextSwitchRequest();
    return true;
}
#endif
void Action_acReqSWDLContextSwitchRequest()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action acReqSWDLContextSwitchRequest()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendRequestMISupdateContextSwitchMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_SWUpdate_Downgrade(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_SWUpdate_Downgrade();
    return true;
}
#endif
void Action_Perform_SWUpdate_Downgrade()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_SWUpdate_Downgrade()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendStartSWDowngrade();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_DisplayClockScene(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_DisplayClockScene();
    return true;
}
#endif
void Action_Perform_DisplayClockScene()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_DisplayClockScene()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDisplayClockScene();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_FactoryResetSM(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_FactoryResetSM();
    return true;
}
#endif
void Action_Perform_FactoryResetSM()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_FactoryResetSM()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendFactoryResetSM();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_FactoryResetSMBeep(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_FactoryResetSMBeep();
    return true;
}
#endif
void Action_Perform_FactoryResetSMBeep()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action Perform_FactoryResetSMBeep()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendFactoryResetSMBeep();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacChangeLanguageReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_gacChangeLanguageReq(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_gacChangeLanguageReq(enLanguageId const & aLanguageId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacChangeLanguageReq(aLanguageId = ?enLanguageId?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendChangeLanguageReqMsg(aLanguageId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacHideFocusInViewReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacHideFocusInViewReq(::Courier::ViewId(AppHmi_SystemStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacHideFocusInViewReq(::Courier::ViewId const & aView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacHideFocusInViewReq(aView = %50s)", aView.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendFocusReqMsg(FOCUS_HIDE, FOCUS_TIMER_NO_ACTION, aView, Candera::String());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_NextLevelTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_NextLevelTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_NextLevelTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action NextLevelTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_PreviousLevelTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_PreviousLevelTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_PreviousLevelTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action PreviousLevelTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_DualViewLeftTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_DualViewLeftTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_DualViewLeftTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action DualViewLeftTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_DualViewRightTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_DualViewRightTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_DualViewRightTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action DualViewRightTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_PageFlipBackTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_PageFlipBackTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_PageFlipBackTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action PageFlipBackTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_PageFlipFrontTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_PageFlipFrontTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_PageFlipFrontTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action PageFlipFrontTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_ZoomInTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 3) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt() && parameters[(::Json::Value::UInt)2].isInt())) { return false; }
    Action_ZoomInTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt(), parameters[(::Json::Value::UInt)2].asInt());
    return true;
}
#endif
void Action_ZoomInTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action ZoomInTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?, aPos = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, aPos);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_ZoomOutTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 3) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt() && parameters[(::Json::Value::UInt)2].isInt())) { return false; }
    Action_ZoomOutTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt(), parameters[(::Json::Value::UInt)2].asInt());
    return true;
}
#endif
void Action_ZoomOutTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action ZoomOutTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?, aPos = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, aPos);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_FadeTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_FadeTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_FadeTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action FadeTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacWaitAnimationStartReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacWaitAnimationStartReq();
    return true;
}
#endif
void Action_gacWaitAnimationStartReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacWaitAnimationStartReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAnimationReqMsg(Courier::AnimationAction::Start, ::Courier::ViewId(), Courier::CompositePath(), ::Courier::ItemId("Global#Animations#WAIT_ANIMATION"), Courier::AnimationProperties());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acFocusOnRightEncoderReqUpd(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_acFocusOnRightEncoderReqUpd(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_acFocusOnRightEncoderReqUpd(bool const & aIsFocusUsed)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action acFocusOnRightEncoderReqUpd(aIsFocusUsed = %d)", aIsFocusUsed));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendFocusOnRightEncoderReqUpdMsg(aIsFocusUsed);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSetGadgetSceenActiveStatus(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_acSetGadgetSceenActiveStatus(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_acSetGadgetSceenActiveStatus(bool const & aIsGadgetAtive)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action acSetGadgetSceenActiveStatus(aIsGadgetAtive = %d)", aIsGadgetAtive));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendStoreActiveGadgetReqMsg(aIsGadgetAtive);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acHKNotificationMsg(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_acHKNotificationMsg(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_acHKNotificationMsg(Courier::UInt8 const & aHKCode, Courier::UInt8 const & aHKState)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action acHKNotificationMsg(aHKCode = %d, aHKState = %d)", aHKCode,aHKState));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendHardKeyPressNotificationMsg(1, aHKCode, aHKState);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acPerform_CloseAllDropdowns(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acPerform_CloseAllDropdowns();
    return true;
}
#endif
void Action_acPerform_CloseAllDropdowns()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action acPerform_CloseAllDropdowns()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDropdownChangeMsg(Candera::DropdownChangeClose, 0);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acPerform_CloseDropdown(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acPerform_CloseDropdown(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acPerform_CloseDropdown(::Courier::UInt32 const & aListId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action acPerform_CloseDropdown(aListId = ?::Courier::UInt32?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDropdownChangeMsg(Candera::DropdownChangeClose, aListId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acPerform_OpenDropdown(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acPerform_OpenDropdown(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acPerform_OpenDropdown(::Courier::UInt32 const & aListId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action acPerform_OpenDropdown(aListId = ?::Courier::UInt32?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDropdownChangeMsg(Candera::DropdownChangeOpen, aListId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acPerform_ToggleDropdown(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acPerform_ToggleDropdown(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acPerform_ToggleDropdown(::Courier::UInt32 const & aListId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action acPerform_ToggleDropdown(aListId = ?::Courier::UInt32?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDropdownChangeMsg(Candera::DropdownChangeToggle, aListId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acStartAppPopupTimer(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_acStartAppPopupTimer(parameters[(::Json::Value::UInt)0].asUInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_acStartAppPopupTimer(Courier::UInt32 const & aViewId, Courier::UInt32 const & aTimeout)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action acStartAppPopupTimer(aViewId = %d, aTimeout = %d)", aViewId,aTimeout));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendStartPopupTimerReqMsg(aViewId, aTimeout);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acStopAppPopupTimer(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acStopAppPopupTimer(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acStopAppPopupTimer(Courier::UInt32 const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action acStopAppPopupTimer(aViewId = %d)", aViewId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendStopPopupTimerReqMsg(aViewId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acPostBeep(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_acPostBeep(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_acPostBeep(Courier::Int32 const & aBeepType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action acPostBeep(aBeepType = %d)", aBeepType));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPlayBeepReqMsg(aBeepType);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacCheckToClosePopup(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacCheckToClosePopup(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacCheckToClosePopup(Courier::UInt32 const & aPopupId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacCheckToClosePopup(aPopupId = %d)", aPopupId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendCheckToClosePopupMsg(aPopupId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acRestartAppPopupTimer(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acRestartAppPopupTimer(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acRestartAppPopupTimer(Courier::UInt32 const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action acRestartAppPopupTimer(aViewId = %d)", aViewId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendRestartPopupTimerReqMsg(aViewId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchBackRes(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacContextSwitchBackRes(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacContextSwitchBackRes(Courier::UInt32 const & aSwitchId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacContextSwitchBackRes(aSwitchId = %d)", aSwitchId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendContextSwitchInResMsg(aSwitchId, CONTEXT_TRANSITION_BACK);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchCompleteRes(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacContextSwitchCompleteRes(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacContextSwitchCompleteRes(Courier::UInt32 const & aSwitchId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacContextSwitchCompleteRes(aSwitchId = %d)", aSwitchId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendContextSwitchInResMsg(aSwitchId, CONTEXT_TRANSITION_COMPLETE);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchFailedRes(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacContextSwitchFailedRes(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacContextSwitchFailedRes(Courier::UInt32 const & aSwitchId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacContextSwitchFailedRes(aSwitchId = %d)", aSwitchId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendContextSwitchInResMsg(aSwitchId, CONTEXT_TRANSITION_FAILED);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchDoneRes(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacContextSwitchDoneRes(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacContextSwitchDoneRes(Courier::UInt32 const & aSwitchId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacContextSwitchDoneRes(aSwitchId = %d)", aSwitchId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendContextSwitchInResMsg(aSwitchId, CONTEXT_TRANSITION_DONE);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchOutReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 3) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt() && parameters[(::Json::Value::UInt)2].isUInt())) { return false; }
    Action_gacContextSwitchOutReq(parameters[(::Json::Value::UInt)0].asUInt(), parameters[(::Json::Value::UInt)1].asUInt(), parameters[(::Json::Value::UInt)2].asUInt());
    return true;
}
#endif
void Action_gacContextSwitchOutReq(Courier::UInt32 const & aTargetContextId, Courier::UInt32 const & aSourceContextId, Courier::UInt32 const & aTargetAppId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacContextSwitchOutReq(aTargetContextId = %d, aSourceContextId = %d, aTargetAppId = %d)", aTargetContextId,aSourceContextId,aTargetAppId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendContextSwitchOutReqMsg(aTargetContextId, aSourceContextId, aTargetAppId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacCurrentScreenDisplayReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacCurrentScreenDisplayReq();
    return true;
}
#endif
void Action_gacCurrentScreenDisplayReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacCurrentScreenDisplayReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendCurrentScreenDisplayReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacLaunchBarDisplayReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_gacLaunchBarDisplayReq(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_gacLaunchBarDisplayReq(bool const & aVisibility)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacLaunchBarDisplayReq(aVisibility = %d)", aVisibility));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendLaunchBarDisplayReqMsg(aVisibility);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacNavTBTSwipe(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacNavTBTSwipe();
    return true;
}
#endif
void Action_gacNavTBTSwipe()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacNavTBTSwipe()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendNavTBTSwipeReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPerformListBtnRightEncoderChangeUpd(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 4) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isUInt() && parameters[(::Json::Value::UInt)2].isUInt() && parameters[(::Json::Value::UInt)3].isUInt())) { return false; }
    Action_gacPerformListBtnRightEncoderChangeUpd(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asUInt(), parameters[(::Json::Value::UInt)2].asUInt(), parameters[(::Json::Value::UInt)3].asUInt());
    return true;
}
#endif
void Action_gacPerformListBtnRightEncoderChangeUpd(Courier::Int8 const & aSteps, Courier::UInt32 const & aListId, Courier::UInt32 const & aRowId, Courier::UInt32 const & aColumnId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacPerformListBtnRightEncoderChangeUpd(aSteps = %d, aListId = %d, aRowId = %d, aColumnId = %d)", aSteps,aListId,aRowId,aColumnId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListItemRightEncoderChangeUpdMsg(aSteps, aListId, aRowId, aColumnId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListUp(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacScrollListUp();
    return true;
}
#endif
void Action_gacScrollListUp()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacScrollListUp()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListChangeMsg(::Courier::UInt32(), ListChangeUp, 1, ListChangeMsgSourceUnknown, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListDown(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacScrollListDown();
    return true;
}
#endif
void Action_gacScrollListDown()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacScrollListDown()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListChangeMsg(::Courier::UInt32(), ListChangeDown, 1, ListChangeMsgSourceUnknown, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacScrollPageUp(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacScrollPageUp();
    return true;
}
#endif
void Action_gacScrollPageUp()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacScrollPageUp()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListChangeMsg(::Courier::UInt32(), ListChangePageUp, 1, ListChangeMsgSourceUnknown, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacScrollPageDown(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacScrollPageDown();
    return true;
}
#endif
void Action_gacScrollPageDown()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacScrollPageDown()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListChangeMsg(::Courier::UInt32(), ListChangePageDown, 1, ListChangeMsgSourceUnknown, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListFocusUp(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacScrollListFocusUp(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacScrollListFocusUp(Courier::UInt32 const & aListId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacScrollListFocusUp(aListId = %d)", aListId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListFocusScrollReqMsg(aListId, -1);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListFocusDown(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacScrollListFocusDown(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacScrollListFocusDown(Courier::UInt32 const & aListId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacScrollListFocusDown(aListId = %d)", aListId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListFocusScrollReqMsg(aListId, 1);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPerformListFocusLockDataResetUpd(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacPerformListFocusLockDataResetUpd();
    return true;
}
#endif
void Action_gacPerformListFocusLockDataResetUpd()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacPerformListFocusLockDataResetUpd()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListFocusLockDataResetReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacSetApplicationMode(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacSetApplicationMode(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacSetApplicationMode(Courier::UInt32 const & aModeId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacSetApplicationMode(aModeId = %d)", aModeId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSetApplicationModeReqMsg(aModeId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacSpellerBbehaviorReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_gacSpellerBbehaviorReq(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_gacSpellerBbehaviorReq(bool const & aEnable)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacSpellerBbehaviorReq(aEnable = %d)", aEnable));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSpellerBbehaviorReqMsg(aEnable);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacStatusBarDisplayReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_gacStatusBarDisplayReq(parameters[(::Json::Value::UInt)0].asBool(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_gacStatusBarDisplayReq(bool const & aVisibility, Courier::Int32 const & aHeaderType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacStatusBarDisplayReq(aVisibility = %d, aHeaderType = %d)", aVisibility,aHeaderType));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendStatusBarDisplayReqMsg(aVisibility, aHeaderType);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacTBTRetriggerAcousticOutput(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacTBTRetriggerAcousticOutput();
    return true;
}
#endif
void Action_gacTBTRetriggerAcousticOutput()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacTBTRetriggerAcousticOutput()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTBTRetriggerAcousticMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacWaitAnimationStopReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacWaitAnimationStopReq();
    return true;
}
#endif
void Action_gacWaitAnimationStopReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacWaitAnimationStopReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAnimationReqMsg(Courier::AnimationAction::Stop, ::Courier::ViewId(), Courier::CompositePath(), ::Courier::ItemId("Global#Animations#WAIT_ANIMATION"), Courier::AnimationProperties());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewCreateReq(::Courier::ViewId(AppHmi_SystemStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewCreateReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacViewCreateReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendViewReqMsg(Courier::ViewAction::Create, aViewId, true, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateAllReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewCreateAllReq(::Courier::ViewId(AppHmi_SystemStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewCreateAllReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacViewCreateAllReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendViewReqMsg(Courier::ViewAction::CreateAll, aViewId, true, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewDestroyReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewDestroyReq(::Courier::ViewId(AppHmi_SystemStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewDestroyReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacViewDestroyReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendViewReqMsg(Courier::ViewAction::Destroy, aViewId, false, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewClearReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewClearReq(::Courier::ViewId(AppHmi_SystemStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewClearReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacViewClearReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendViewReqMsg(Courier::ViewAction::Clear, aViewId, true, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewShowReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewShowReq(::Courier::ViewId(AppHmi_SystemStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewShowReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacViewShowReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendActivationReqMsg(aViewId, true, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewHideReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewHideReq(::Courier::ViewId(AppHmi_SystemStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewHideReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacViewHideReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendActivationReqMsg(aViewId, false, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateWithoutLoadReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewCreateWithoutLoadReq(::Courier::ViewId(AppHmi_SystemStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewCreateWithoutLoadReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacViewCreateWithoutLoadReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendViewReqMsg(Courier::ViewAction::Create, aViewId, false, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewAsyncLoadReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewAsyncLoadReq(::Courier::ViewId(AppHmi_SystemStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewAsyncLoadReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacViewAsyncLoadReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAsyncLoadReqMsg(aViewId, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewActivateWithoutRenderingReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewActivateWithoutRenderingReq(::Courier::ViewId(AppHmi_SystemStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewActivateWithoutRenderingReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacViewActivateWithoutRenderingReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendActivationReqMsg(aViewId, true, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupCreateAndSBShowReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacPopupCreateAndSBShowReq(::Courier::ViewId(AppHmi_SystemStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacPopupCreateAndSBShowReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacPopupCreateAndSBShowReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupReqMsg(hmibase::popups::Show, aViewId, hmibase::DEFAULT_UNKNOWN_DISPLAY);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupCreateAndSBShowReqForMultiDisplay(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacPopupCreateAndSBShowReqForMultiDisplay(parameters[(::Json::Value::UInt)0].asUInt(), ::Courier::ViewId(AppHmi_SystemStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)1].asUInt())));
    return true;
}
#endif
void Action_gacPopupCreateAndSBShowReqForMultiDisplay(Courier::UInt32 const & aPopupDisplayID, ::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacPopupCreateAndSBShowReqForMultiDisplay(aPopupDisplayID = %d, aViewId = %50s)", aPopupDisplayID,aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupReqMsg(hmibase::popups::Show, aViewId, aPopupDisplayID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupSBCloseReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacPopupSBCloseReq(::Courier::ViewId(AppHmi_SystemStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacPopupSBCloseReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacPopupSBCloseReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupReqMsg(hmibase::popups::Hide, aViewId, hmibase::DEFAULT_UNKNOWN_DISPLAY);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupSBCloseReqForMultiDisplay(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacPopupSBCloseReqForMultiDisplay(parameters[(::Json::Value::UInt)0].asUInt(), ::Courier::ViewId(AppHmi_SystemStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)1].asUInt())));
    return true;
}
#endif
void Action_gacPopupSBCloseReqForMultiDisplay(Courier::UInt32 const & aPopupDisplayID, ::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacPopupSBCloseReqForMultiDisplay(aPopupDisplayID = %d, aViewId = %50s)", aPopupDisplayID,aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupReqMsg(hmibase::popups::Hide, aViewId, aPopupDisplayID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupRestartTimerReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacPopupRestartTimerReq(::Courier::ViewId(AppHmi_SystemStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacPopupRestartTimerReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacPopupRestartTimerReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupReqMsg(hmibase::popups::RestartTimer, aViewId, hmibase::DEFAULT_UNKNOWN_DISPLAY);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupRestartTimerReqForMultiDisplay(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacPopupRestartTimerReqForMultiDisplay(parameters[(::Json::Value::UInt)0].asUInt(), ::Courier::ViewId(AppHmi_SystemStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)1].asUInt())));
    return true;
}
#endif
void Action_gacPopupRestartTimerReqForMultiDisplay(Courier::UInt32 const & aPopupDisplayID, ::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacPopupRestartTimerReqForMultiDisplay(aPopupDisplayID = %d, aViewId = %50s)", aPopupDisplayID,aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupReqMsg(hmibase::popups::RestartTimer, aViewId, aPopupDisplayID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateAndShowReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewCreateAndShowReq(::Courier::ViewId(AppHmi_SystemStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewCreateAndShowReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacViewCreateAndShowReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendExtendedViewReqMsg(hmibase::views::CreateAndShow, aViewId, 0);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewHideAndDestroyReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewHideAndDestroyReq(::Courier::ViewId(AppHmi_SystemStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewHideAndDestroyReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacViewHideAndDestroyReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendExtendedViewReqMsg(hmibase::views::HideAndDestroy, aViewId, 0);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacSceneTransitionEnter(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacSceneTransitionEnter(::Courier::ViewId(AppHmi_SystemStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt(), ))parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacSceneTransitionEnter(::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacSceneTransitionEnter(aViewId = %50s, aHint = %d)", aViewId.CStr(),aHint));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendExtendedViewReqMsg(hmibase::views::TransitionEnter, aViewId, aHint);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacSceneTransitionLeave(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacSceneTransitionLeave(::Courier::ViewId(AppHmi_SystemStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt(), ))parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacSceneTransitionLeave(::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacSceneTransitionLeave(aViewId = %50s, aHint = %d)", aViewId.CStr(),aHint));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendExtendedViewReqMsg(hmibase::views::TransitionLeave, aViewId, aHint);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayStatusLineReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_gacDisplayStatusLineReq(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_gacDisplayStatusLineReq(Courier::Int32 const & aDisplayRegionType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacDisplayStatusLineReq(aDisplayRegionType = %d)", aDisplayRegionType));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::STATUS_LINE, aDisplayRegionType, true, hmibase::DEFAULT_UNKNOWN_DISPLAY, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacHideStatusLineReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_gacHideStatusLineReq(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_gacHideStatusLineReq(Courier::Int32 const & aDisplayRegionType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacHideStatusLineReq(aDisplayRegionType = %d)", aDisplayRegionType));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::STATUS_LINE, aDisplayRegionType, false, hmibase::DEFAULT_UNKNOWN_DISPLAY, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayFooterLineReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacDisplayFooterLineReq();
    return true;
}
#endif
void Action_gacDisplayFooterLineReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacDisplayFooterLineReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::FOOTER_LINE, Courier::Int32(), true, hmibase::DEFAULT_UNKNOWN_DISPLAY, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacHideFooterLineReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacHideFooterLineReq();
    return true;
}
#endif
void Action_gacHideFooterLineReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacHideFooterLineReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::FOOTER_LINE, Courier::Int32(), false, hmibase::DEFAULT_UNKNOWN_DISPLAY, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayStatusLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacDisplayStatusLineMultiDisplayReq(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacDisplayStatusLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacDisplayStatusLineMultiDisplayReq(aDisplayRegionType = %d, aDisplayID = %d)", aDisplayRegionType,aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::STATUS_LINE, aDisplayRegionType, true, aDisplayID, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacHideStatusLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacHideStatusLineMultiDisplayReq(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacHideStatusLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacHideStatusLineMultiDisplayReq(aDisplayRegionType = %d, aDisplayID = %d)", aDisplayRegionType,aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::STATUS_LINE, aDisplayRegionType, false, aDisplayID, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayFooterLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacDisplayFooterLineMultiDisplayReq(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacDisplayFooterLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacDisplayFooterLineMultiDisplayReq(aDisplayRegionType = %d, aDisplayID = %d)", aDisplayRegionType,aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::FOOTER_LINE, aDisplayRegionType, true, aDisplayID, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacHideFooterLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacHideFooterLineMultiDisplayReq(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacHideFooterLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacHideFooterLineMultiDisplayReq(aDisplayRegionType = %d, aDisplayID = %d)", aDisplayRegionType,aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::FOOTER_LINE, aDisplayRegionType, false, aDisplayID, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacRegisterForCloseOnTouchSession(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacRegisterForCloseOnTouchSession(::Courier::ViewId(AppHmi_SystemStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacRegisterForCloseOnTouchSession(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacRegisterForCloseOnTouchSession(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendRegisterForCloseOnTouchSessionReqMsg(true, aViewId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacDeregisterForCloseOnTouchSessionReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacDeregisterForCloseOnTouchSessionReq(::Courier::ViewId(AppHmi_SystemStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacDeregisterForCloseOnTouchSessionReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacDeregisterForCloseOnTouchSessionReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendRegisterForCloseOnTouchSessionReqMsg(false, aViewId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterPrioEnableReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacPopupFilterPrioEnableReq(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacPopupFilterPrioEnableReq(Courier::UInt32 const & aPrio)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacPopupFilterPrioEnableReq(aPrio = %d)", aPrio));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupFilterPrioEnableReqMsg(aPrio);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterAllEnableReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacPopupFilterAllEnableReq();
    return true;
}
#endif
void Action_gacPopupFilterAllEnableReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacPopupFilterAllEnableReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupFilterAllEnableReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterDisableReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacPopupFilterDisableReq();
    return true;
}
#endif
void Action_gacPopupFilterDisableReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacPopupFilterDisableReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupFilterDisableReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacProfileChange(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_gacProfileChange(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_gacProfileChange(Courier::UInt32 const & aProfile)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacProfileChange(aProfile = %d)", aProfile));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendProfileSwitchMsg(aProfile);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterPrioEnableReqForDisplay(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacPopupFilterPrioEnableReqForDisplay(parameters[(::Json::Value::UInt)0].asUInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacPopupFilterPrioEnableReqForDisplay(Courier::UInt32 const & aPrio, Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacPopupFilterPrioEnableReqForDisplay(aPrio = %d, aDisplayID = %d)", aPrio,aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendMultiDisplayPopupFilterReqMsg(hmibase::ENABLE_PRIO, aPrio, aDisplayID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterAllEnableReqForDisplay(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacPopupFilterAllEnableReqForDisplay(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacPopupFilterAllEnableReqForDisplay(Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacPopupFilterAllEnableReqForDisplay(aDisplayID = %d)", aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendMultiDisplayPopupFilterReqMsg(hmibase::ENABLE_ALL, 0, aDisplayID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterDisableReqForDisplay(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacPopupFilterDisableReqForDisplay(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacPopupFilterDisableReqForDisplay(Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacPopupFilterDisableReqForDisplay(aDisplayID = %d)", aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendMultiDisplayPopupFilterReqMsg(hmibase::DISABLE_ALL, 0, aDisplayID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacStartSceneTransitionAnimation(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 4) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt() && parameters[(::Json::Value::UInt)2].isUInt() && parameters[(::Json::Value::UInt)3].isInt())) { return false; }
    Action_gacStartSceneTransitionAnimation(::Courier::ViewId(AppHmi_SystemStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt(), ))::Courier::ViewId(AppHmi_SystemStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)1].asUInt(), ))parameters[(::Json::Value::UInt)2].asUInt(), parameters[(::Json::Value::UInt)3].asInt());
    return true;
}
#endif
void Action_gacStartSceneTransitionAnimation(::Courier::ViewId const & aSourceView, ::Courier::ViewId const & aDestinationView, Courier::UInt32 const & aUserData1, Courier::Int8 const & aUserData2)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacStartSceneTransitionAnimation(aSourceView = %50s, aDestinationView = %50s, aUserData1 = %d, aUserData2 = %d)", aSourceView.CStr(),aDestinationView.CStr(),aUserData1,aUserData2));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendCreateNewDestroyOld(aSourceView, aDestinationView, aUserData1, aUserData2);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacDecrementActiveAnimationCount(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacDecrementActiveAnimationCount();
    return true;
}
#endif
void Action_gacDecrementActiveAnimationCount()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SYSTEM_SM, "SM_ACTIONS:    Trigger action gacDecrementActiveAnimationCount()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendNotifierMessage();
    COURIER_UNUSED(ok);
}
//====  defines and includes TTFis output - added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====    

unsigned short AppHmi_SystemStateMachineImpl::GetTraceClass (){  
   return TR_CLASS_APPHMI_SYSTEM_SM; 
}

//====  member function with TTFis output - end                        key: SM_TTFis_SBHFMSRF ==== 

#include "hmibase/util/Macros.h"

#ifdef CIT_SIMULATION
#define CIT_EVENT_ID(eventId, hashId) hashId
#else
#define CIT_EVENT_ID(eventId, hashId) eventId
#endif
// ------------------------------------------------------------------------
static bool HandleEventMappingForActivateApplicationMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnActivateApplicationMsg, 0xC70281BB);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActivateApplicationMsg(AppHmi_SystemStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForDeactivateApplicationMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnDeactivateApplicationMsg, 0x37E7CAFB);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForDeactivateApplicationMsg(AppHmi_SystemStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForShutdownMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnShutdownMsg, 0x756C0DF3);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForShutdownMsg(AppHmi_SystemStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForUpdateCLKSetModeResp(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::UpdateCLKSetModeResp const & message = static_cast< ::UpdateCLKSetModeResp const &>(aMessage);

#ifdef Activate_GPS_Mode
    if ((message.GetUpdated_CLKSetMode() == 1)) { eventId = CIT_EVENT_ID(Activate_GPS_Mode, 0x3C1D2BE9); return true; }
#endif
#ifdef Activate_Manual_Mode
    if ((message.GetUpdated_CLKSetMode() == 2)) { eventId = CIT_EVENT_ID(Activate_Manual_Mode, 0x8F9B51C2); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForUpdateCLKSetModeResp(AppHmi_SystemStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::UpdateCLKSetModeResp const & message = static_cast< ::UpdateCLKSetModeResp const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForActivityMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::ActivityMsg const & message = static_cast< ::ActivityMsg const &>(aMessage);

#ifdef OnActivityMsg_eActivityID_MEDIA_SOUND_SETTINGS
    if ((message.GetActivityID() == eActivityID_MEDIA_SOUND_SETTINGS)) { eventId = CIT_EVENT_ID(OnActivityMsg_eActivityID_MEDIA_SOUND_SETTINGS, 0xF70A1512); return true; }
#endif
#ifdef OnActivityMsg_eActivityID_TUNER_SOUND_SETTINGS
    if ((message.GetActivityID() == eActivityID_TUNER_SOUND_SETTINGS)) { eventId = CIT_EVENT_ID(OnActivityMsg_eActivityID_TUNER_SOUND_SETTINGS, 0xF541AFCD); return true; }
#endif
    eventId = CIT_EVENT_ID(Activate_DeepHistory, 0x124F0846);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActivityMsg(AppHmi_SystemStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::ActivityMsg const & message = static_cast< ::ActivityMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForButtonReactionMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::ButtonReactionMsg const & message = static_cast< ::ButtonReactionMsg const &>(aMessage);

#ifdef OnButtonReactionMsg_Volume_PopUp_Scenes_SwUpdate_Downgrade_Btn_Update_enRelease
    if ((message.GetView() == ::Courier::ViewId("Volume_PopUp#Scenes#SwUpdate_Downgrade")) && (message.GetSender() == ::Courier::Identifier(0x64129020 /* Btn_Update */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Volume_PopUp_Scenes_SwUpdate_Downgrade_Btn_Update_enRelease, 0x3D181B2D); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_24_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_TimeZone")) && (message.GetSender() == ::Courier::Identifier(0x36d978a8 /* Rbtn_TimeZone_24 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_24_enRelease, 0x03A57AEB); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_25_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_TimeZone")) && (message.GetSender() == ::Courier::Identifier(0x0a239f3d /* Rbtn_TimeZone_25 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_25_enRelease, 0x0CECE954); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_26_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_TimeZone")) && (message.GetSender() == ::Courier::Identifier(0x0af3a0dd /* Rbtn_TimeZone_26 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_26_enRelease, 0xA6A89982); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_27_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_TimeZone")) && (message.GetSender() == ::Courier::Identifier(0x5d59c5a8 /* Rbtn_TimeZone_27 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_27_enRelease, 0x6EA32A6C); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_28_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_TimeZone")) && (message.GetSender() == ::Courier::Identifier(0x6f20e936 /* Rbtn_TimeZone_28 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_28_enRelease, 0xAF79B008); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_29_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_TimeZone")) && (message.GetSender() == ::Courier::Identifier(0x3fcf0a93 /* Rbtn_TimeZone_29 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_29_enRelease, 0x90E615CC); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_30_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_TimeZone")) && (message.GetSender() == ::Courier::Identifier(0xd84c3a6b /* Rbtn_TimeZone_30 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_30_enRelease, 0x922FC898); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_31_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_TimeZone")) && (message.GetSender() == ::Courier::Identifier(0xcaf69fc0 /* Rbtn_TimeZone_31 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_31_enRelease, 0xD120809C); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_32_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_TimeZone")) && (message.GetSender() == ::Courier::Identifier(0x1c0641e2 /* Rbtn_TimeZone_32 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_32_enRelease, 0xB59B20BF); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_33_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_TimeZone")) && (message.GetSender() == ::Courier::Identifier(0x0db7a545 /* Rbtn_TimeZone_33 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_33_enRelease, 0x5756B5FE); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_34_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_TimeZone")) && (message.GetSender() == ::Courier::Identifier(0xfd510478 /* Rbtn_TimeZone_34 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_34_enRelease, 0xFF56604A); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_35_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_TimeZone")) && (message.GetSender() == ::Courier::Identifier(0x72f6efc2 /* Rbtn_TimeZone_35 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_35_enRelease, 0x92721CBE); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_36_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_TimeZone")) && (message.GetSender() == ::Courier::Identifier(0x61dd4d8f /* Rbtn_TimeZone_36 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_36_enRelease, 0x0622D8BF); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_37_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_TimeZone")) && (message.GetSender() == ::Courier::Identifier(0x5333303b /* Rbtn_TimeZone_37 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_37_enRelease, 0xE7EFF36A); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_38_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_TimeZone")) && (message.GetSender() == ::Courier::Identifier(0x469096f6 /* Rbtn_TimeZone_38 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_38_enRelease, 0x9CD4D971); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_39_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_TimeZone")) && (message.GetSender() == ::Courier::Identifier(0xb79e7914 /* Rbtn_TimeZone_39 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_39_enRelease, 0x9CEC98B6); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_40_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_TimeZone")) && (message.GetSender() == ::Courier::Identifier(0xd2f8377b /* Rbtn_TimeZone_40 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_40_enRelease, 0x69A14F76); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_41_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_TimeZone")) && (message.GetSender() == ::Courier::Identifier(0xbfcc9124 /* Rbtn_TimeZone_41 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_41_enRelease, 0xAB4FC796); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_42_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_TimeZone")) && (message.GetSender() == ::Courier::Identifier(0xb6127db0 /* Rbtn_TimeZone_42 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_42_enRelease, 0x9E8291F5); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_43_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_TimeZone")) && (message.GetSender() == ::Courier::Identifier(0x8a40260c /* Rbtn_TimeZone_43 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_43_enRelease, 0x97DE6D52); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_44_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_TimeZone")) && (message.GetSender() == ::Courier::Identifier(0x78828291 /* Rbtn_TimeZone_44 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_44_enRelease, 0xF7A64C25); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_45_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_TimeZone")) && (message.GetSender() == ::Courier::Identifier(0x63ec5961 /* Rbtn_TimeZone_45 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_45_enRelease, 0xCBB9BB9F); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_46_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_TimeZone")) && (message.GetSender() == ::Courier::Identifier(0x7609fd9c /* Rbtn_TimeZone_46 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_46_enRelease, 0x38C23FAA); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_47_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_TimeZone")) && (message.GetSender() == ::Courier::Identifier(0x2e3bee01 /* Rbtn_TimeZone_47 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_47_enRelease, 0xC553E5AC); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_48_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_TimeZone")) && (message.GetSender() == ::Courier::Identifier(0x387e0285 /* Rbtn_TimeZone_48 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_48_enRelease, 0x2B962B1A); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_23_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_TimeZone")) && (message.GetSender() == ::Courier::Identifier(0x25f856e6 /* Rbtn_TimeZone_23 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_23_enRelease, 0x48B4E639); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_22_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_TimeZone")) && (message.GetSender() == ::Courier::Identifier(0xd3983223 /* Rbtn_TimeZone_22 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_22_enRelease, 0xD00B1FD4); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_21_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_TimeZone")) && (message.GetSender() == ::Courier::Identifier(0xfa597fa5 /* Rbtn_TimeZone_21 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_21_enRelease, 0x37C3CBD2); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_20_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_TimeZone")) && (message.GetSender() == ::Courier::Identifier(0xe822db38 /* Rbtn_TimeZone_20 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_20_enRelease, 0x20B14F3C); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_DateFmtEU_Rbtn_DateFmtEU_6_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_CS_DateFmtEU")) && (message.GetSender() == ::Courier::Identifier(0x3fcedf0c /* Rbtn_DateFmtEU_6 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_DateFmtEU_Rbtn_DateFmtEU_6_enRelease, 0x631F0B40); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_DateFmtCN_btn_DateFmtIN_Back_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_CS_DateFmtCN")) && (message.GetSender() == ::Courier::Identifier(0x83915977 /* btn_DateFmtIN_Back */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_DateFmtCN_btn_DateFmtIN_Back_enRelease, 0x38722D60); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_DateFmtCN_btn_DateFmtIN_Back_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_CS_DateFmtCN")) && (message.GetSender() == ::Courier::Identifier(0x83915977 /* btn_DateFmtIN_Back */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_DateFmtCN_btn_DateFmtIN_Back_enLongPressRelease, 0x5CF05C8E); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_DateFmtCN_Rbtn_DateFmtIN_1_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_CS_DateFmtCN")) && (message.GetSender() == ::Courier::Identifier(0x99d5df23 /* Rbtn_DateFmtIN_1 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_DateFmtCN_Rbtn_DateFmtIN_1_enRelease, 0xA18D63C2); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_DateFmtCN_Rbtn_DateFmtIN_2_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_CS_DateFmtCN")) && (message.GetSender() == ::Courier::Identifier(0x5c0d638f /* Rbtn_DateFmtIN_2 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_DateFmtCN_Rbtn_DateFmtIN_2_enRelease, 0xFFFD4EF5); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_Back_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_TimeZone")) && (message.GetSender() == ::Courier::Identifier(0x8b2521a0 /* Rbtn_TimeZone_Back */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_Back_enRelease, 0xB9E855A5); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_Back_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_TimeZone")) && (message.GetSender() == ::Courier::Identifier(0x8b2521a0 /* Rbtn_TimeZone_Back */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_Back_enLongPressRelease, 0xDE03E4F3); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_1_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_TimeZone")) && (message.GetSender() == ::Courier::Identifier(0xe91907d5 /* Rbtn_TimeZone_1 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_1_enRelease, 0xE26B80F2); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_2_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_TimeZone")) && (message.GetSender() == ::Courier::Identifier(0x6d050faf /* Rbtn_TimeZone_2 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_2_enRelease, 0x77AB85EF); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_3_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_TimeZone")) && (message.GetSender() == ::Courier::Identifier(0x9ac2eb2a /* Rbtn_TimeZone_3 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_3_enRelease, 0xE017647F); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_4_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_TimeZone")) && (message.GetSender() == ::Courier::Identifier(0x8fbf5523 /* Rbtn_TimeZone_4 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_4_enRelease, 0xE77FA7E9); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_5_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_TimeZone")) && (message.GetSender() == ::Courier::Identifier(0x3e0031a6 /* Rbtn_TimeZone_5 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_5_enRelease, 0x2F1539C3); return true; }
#endif
#ifdef OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_btn_AS_back_enRelease
    if ((message.GetView() == ::Courier::ViewId("AudioSetting#Scenes#SO_AS")) && (message.GetSender() == ::Courier::Identifier(0x65c1ae28 /* btn_AS_back */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_btn_AS_back_enRelease, 0xECD46AD6); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_6_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_TimeZone")) && (message.GetSender() == ::Courier::Identifier(0xbe02b1ad /* Rbtn_TimeZone_6 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_6_enRelease, 0x7785F729); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_8_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_TimeZone")) && (message.GetSender() == ::Courier::Identifier(0xe18578b2 /* Rbtn_TimeZone_8 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_8_enRelease, 0xF0E525E2); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_9_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_TimeZone")) && (message.GetSender() == ::Courier::Identifier(0x76b5a310 /* Rbtn_TimeZone_9 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_9_enRelease, 0x70705B63); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_10_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_TimeZone")) && (message.GetSender() == ::Courier::Identifier(0xb384fdad /* Rbtn_TimeZone_10 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_10_enRelease, 0xFCD1FE5A); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_11_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_TimeZone")) && (message.GetSender() == ::Courier::Identifier(0x413c991a /* Rbtn_TimeZone_11 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_11_enRelease, 0xD9988551); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_12_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_TimeZone")) && (message.GetSender() == ::Courier::Identifier(0x8f0934b6 /* Rbtn_TimeZone_12 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_12_enRelease, 0x4CBFB51D); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_13_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_TimeZone")) && (message.GetSender() == ::Courier::Identifier(0x9cc8d035 /* Rbtn_TimeZone_13 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_13_enRelease, 0x53AEFC6E); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_14_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_TimeZone")) && (message.GetSender() == ::Courier::Identifier(0xeefaf498 /* Rbtn_TimeZone_14 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_14_enRelease, 0x4B18DA2B); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_15_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_TimeZone")) && (message.GetSender() == ::Courier::Identifier(0x7cb5900f /* Rbtn_TimeZone_15 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_15_enRelease, 0x9709B95B); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_16_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_TimeZone")) && (message.GetSender() == ::Courier::Identifier(0xb6708384 /* Rbtn_TimeZone_16 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_16_enRelease, 0xFE6323DF); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_17_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_TimeZone")) && (message.GetSender() == ::Courier::Identifier(0xc5b4a20c /* Rbtn_TimeZone_17 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_17_enRelease, 0x56CA7F5E); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_18_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_TimeZone")) && (message.GetSender() == ::Courier::Identifier(0x213e595a /* Rbtn_TimeZone_18 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_18_enRelease, 0xD6AD87DA); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_19_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_TimeZone")) && (message.GetSender() == ::Courier::Identifier(0x3303fce5 /* Rbtn_TimeZone_19 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_19_enRelease, 0x9B3F5F0D); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_7_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_TimeZone")) && (message.GetSender() == ::Courier::Identifier(0xb3549c51 /* Rbtn_TimeZone_7 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_7_enRelease, 0x0F8A6E48); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_DateFmtEU_Rbtn_DateFmtEU_5_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_CS_DateFmtEU")) && (message.GetSender() == ::Courier::Identifier(0x2e0e3b8b /* Rbtn_DateFmtEU_5 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_DateFmtEU_Rbtn_DateFmtEU_5_enRelease, 0xACDAB50F); return true; }
#endif
#ifdef OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_btn_AS_back_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("AudioSetting#Scenes#SO_AS")) && (message.GetSender() == ::Courier::Identifier(0x65c1ae28 /* btn_AS_back */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_btn_AS_back_enLongPressRelease, 0x03015DE1); return true; }
#endif
#ifdef OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_btn_AS_DecBass_enRelease
    if ((message.GetView() == ::Courier::ViewId("AudioSetting#Scenes#SO_AS")) && (message.GetSender() == ::Courier::Identifier(0x5147b864 /* btn_AS_DecBass */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_btn_AS_DecBass_enRelease, 0xAA7E8EAD); return true; }
#endif
#ifdef ev_SoftwareDownloadMode_TouchareaBack
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SoftwareDownload#screen_3")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_SoftwareDownloadMode_TouchareaBack, 0x899A6B52); return true; }
#endif
#ifdef ev_onUserConfirmation_3linePopup
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SoftwareDownload#PopUp_three_line_single_button")) && (message.GetSender() == ::Courier::Identifier(0xeaebbe6c /* Layer_Yes/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_onUserConfirmation_3linePopup, 0x422770B0); return true; }
#endif
#ifdef ev_onUserConfirmation_SystemInstallationPopup
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SoftwareDownload#Pfo_SystemInstallation")) && (message.GetSender() == ::Courier::Identifier(0xeaebbe6c /* Layer_Yes/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_onUserConfirmation_SystemInstallationPopup, 0x4D3AC74B); return true; }
#endif
#ifdef ev_onUserConfirmation_2linePopup
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SoftwareDownload#PopUp_two_line_single_button")) && (message.GetSender() == ::Courier::Identifier(0xeaebbe6c /* Layer_Yes/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_onUserConfirmation_2linePopup, 0x14B85A24); return true; }
#endif
#ifdef ev_onUserConfirmation_4linePopup
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SoftwareDownload#Popup_Four_line_single_button")) && (message.GetSender() == ::Courier::Identifier(0xeaebbe6c /* Layer_Yes/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_onUserConfirmation_4linePopup, 0x3BBE4C40); return true; }
#endif
#ifdef ev_onUserConfirmation_5linePopup_Yes_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SoftwareDownload#PopUp_five_line_double_button")) && (message.GetSender() == ::Courier::Identifier(0xeaebbe6c /* Layer_Yes/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_onUserConfirmation_5linePopup_Yes_touch, 0x930EFC0F); return true; }
#endif
#ifdef ev_onUserConfirmation_5linePopup_No_tocuh
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SoftwareDownload#PopUp_five_line_double_button")) && (message.GetSender() == ::Courier::Identifier(0xb5018479 /* Layer_No/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_onUserConfirmation_5linePopup_No_tocuh, 0xE653CE2E); return true; }
#endif
#ifdef ev_onUserConfirmation_3linePopup_Up_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SoftwareDownload#PopUp_three_line_three_button")) && (message.GetSender() == ::Courier::Identifier(0x3596caf5 /* Layer_Up/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_onUserConfirmation_3linePopup_Up_touch, 0x23BE23BB); return true; }
#endif
#ifdef ev_onUserConfirmation_3linePopup_Down_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SoftwareDownload#PopUp_three_line_three_button")) && (message.GetSender() == ::Courier::Identifier(0x870c893c /* Layer_Down/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_onUserConfirmation_3linePopup_Down_touch, 0x4F8153EE); return true; }
#endif
#ifdef ev_onUserConfirmation_3linePopup_Auto_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SoftwareDownload#PopUp_three_line_three_button")) && (message.GetSender() == ::Courier::Identifier(0xc6cbb4b0 /* Layer_Auto/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_onUserConfirmation_3linePopup_Auto_touch, 0xF75E8902); return true; }
#endif
#ifdef ev_onUserConfirmation_6linePopup_Yes_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SoftwareDownload#PopUp_six_line_two_button")) && (message.GetSender() == ::Courier::Identifier(0xeaebbe6c /* Layer_Yes/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_onUserConfirmation_6linePopup_Yes_touch, 0x32205B9E); return true; }
#endif
#ifdef ev_onUserConfirmation_6linePopup_No_tocuh
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SoftwareDownload#PopUp_six_line_two_button")) && (message.GetSender() == ::Courier::Identifier(0xb5018479 /* Layer_No/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_onUserConfirmation_6linePopup_No_tocuh, 0x55F851B3); return true; }
#endif
#ifdef ev_onUserConfirmationForReboot_3linePopup
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SoftwareDownload#PopUp_three_line_single_reboot_button")) && (message.GetSender() == ::Courier::Identifier(0xe69afebe /* Layer_reboot/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_onUserConfirmationForReboot_3linePopup, 0xB39B84C7); return true; }
#endif
#ifdef ev_onSWupdateConfirmation_popup_Yes_tocuh
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SoftwareDownload#PopUp_two_line_two_button")) && (message.GetSender() == ::Courier::Identifier(0xeaebbe6c /* Layer_Yes/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_onSWupdateConfirmation_popup_Yes_tocuh, 0x95E6EC07); return true; }
#endif
#ifdef ev_onSWupdateConfirmation_popup_No_tocuh
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SoftwareDownload#PopUp_two_line_two_button")) && (message.GetSender() == ::Courier::Identifier(0xb5018479 /* Layer_No/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_onSWupdateConfirmation_popup_No_tocuh, 0x8707C29E); return true; }
#endif
#ifdef ev_onSWSameGrade_YesTouch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SoftwareDownload#PopUp_three_line_two_button")) && (message.GetSender() == ::Courier::Identifier(0xeaebbe6c /* Layer_Yes/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_onSWSameGrade_YesTouch, 0x7919BAB0); return true; }
#endif
#ifdef ev_onSWSameGrade_NoTouch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SoftwareDownload#PopUp_three_line_two_button")) && (message.GetSender() == ::Courier::Identifier(0xb5018479 /* Layer_No/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_onSWSameGrade_NoTouch, 0x776E4824); return true; }
#endif
#ifdef ev_onSwivel_GS_CA_YesTouch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SoftwareDownload#PopUp_three_line_two_button_Swivel_GS_CA")) && (message.GetSender() == ::Courier::Identifier(0xeaebbe6c /* Layer_Yes/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_onSwivel_GS_CA_YesTouch, 0xB11C8A96); return true; }
#endif
#ifdef ev_onSwivel_GS_CA_NoTouch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SoftwareDownload#PopUp_three_line_two_button_Swivel_GS_CA")) && (message.GetSender() == ::Courier::Identifier(0xb5018479 /* Layer_No/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_onSwivel_GS_CA_NoTouch, 0xAA2CABB9); return true; }
#endif
#ifdef ev_onSWDetails_Back_Touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SoftwareDownload#screen_4")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_onSWDetails_Back_Touch, 0x5B50A4C8); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SoftwareDownload_screen_5_Layer_TouchArea_Back_1_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SoftwareDownload#screen_5")) && (message.GetSender() == ::Courier::Identifier(0xa464eb78 /* Layer_TouchArea_Back_1/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SoftwareDownload_screen_5_Layer_TouchArea_Back_1_ButtonWidget_enRelease, 0x037452DD); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SoftwareDownload_screen_6_Layer_TouchArea_Back_1_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SoftwareDownload#screen_6")) && (message.GetSender() == ::Courier::Identifier(0xa464eb78 /* Layer_TouchArea_Back_1/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SoftwareDownload_screen_6_Layer_TouchArea_Back_1_ButtonWidget_enRelease, 0xA8B38EB4); return true; }
#endif
#ifdef ev_onMIS_SystemUpdate_Complete
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SoftwareDownload#Stage_one_MIS_SystemUpdate")) && (message.GetSender() == ::Courier::Identifier(0xfd3966dc /* Layer_Confirm/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_onMIS_SystemUpdate_Complete, 0x0CC5FFC9); return true; }
#endif
#ifdef ev_onMIS_SystemUpdate_Abort
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SoftwareDownload#Stage_one_MIS_SystemUpdate")) && (message.GetSender() == ::Courier::Identifier(0x9a3e3daf /* Layer_Abort/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_onMIS_SystemUpdate_Abort, 0xBCBAB806); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SoftwareDownload_Stage_one_MIS_SystemUpdate_Layer_Details_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SoftwareDownload#Stage_one_MIS_SystemUpdate")) && (message.GetSender() == ::Courier::Identifier(0xcb7d191b /* Layer_Details/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SoftwareDownload_Stage_one_MIS_SystemUpdate_Layer_Details_ButtonWidget_enRelease, 0x6B7973D3); return true; }
#endif
#ifdef ev_SoftwareDownloadMode_Details
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SoftwareDownload#screen_3")) && (message.GetSender() == ::Courier::Identifier(0xcb7d191b /* Layer_Details/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_SoftwareDownloadMode_Details, 0x6C354B69); return true; }
#endif
#ifdef ev_SoftwareDownloadMode_FullUpdate
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SoftwareDownload#screen_3")) && (message.GetSender() == ::Courier::Identifier(0x60aced63 /* Layer_FullUpdate/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_SoftwareDownloadMode_FullUpdate, 0xDA9724A9); return true; }
#endif
#ifdef ev_SoftwareDownloadMode_QuickUpdate
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SoftwareDownload#screen_3")) && (message.GetSender() == ::Courier::Identifier(0x3f2c5b6b /* Layer_QuickUpdate/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_SoftwareDownloadMode_QuickUpdate, 0x14ACE9C5); return true; }
#endif
#ifdef ev_SoftwareDownloadModeEngScreen_TouchareaBack
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SoftwareDownload#SW_screen_1")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_SoftwareDownloadModeEngScreen_TouchareaBack, 0xF11EAE44); return true; }
#endif
#ifdef OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_btn_AS_IncTreble_enRelease
    if ((message.GetView() == ::Courier::ViewId("AudioSetting#Scenes#SO_AS")) && (message.GetSender() == ::Courier::Identifier(0x9e1c39d5 /* btn_AS_IncTreble */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_btn_AS_IncTreble_enRelease, 0x12AB0612); return true; }
#endif
#ifdef OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_btn_AS_DecTreble_enRelease
    if ((message.GetView() == ::Courier::ViewId("AudioSetting#Scenes#SO_AS")) && (message.GetSender() == ::Courier::Identifier(0x9eb5eb98 /* btn_AS_DecTreble */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_btn_AS_DecTreble_enRelease, 0xB71DB6A9); return true; }
#endif
#ifdef OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_btn_AS_IncBalance_enRelease
    if ((message.GetView() == ::Courier::ViewId("AudioSetting#Scenes#SO_AS")) && (message.GetSender() == ::Courier::Identifier(0xc306fe9b /* btn_AS_IncBalance */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_btn_AS_IncBalance_enRelease, 0x1C6BCE4E); return true; }
#endif
#ifdef OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_btn_AS_DecBalance_enRelease
    if ((message.GetView() == ::Courier::ViewId("AudioSetting#Scenes#SO_AS")) && (message.GetSender() == ::Courier::Identifier(0x256fe792 /* btn_AS_DecBalance */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_btn_AS_DecBalance_enRelease, 0x24C4852E); return true; }
#endif
#ifdef OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_btn_AS_IncFader_enRelease
    if ((message.GetView() == ::Courier::ViewId("AudioSetting#Scenes#SO_AS")) && (message.GetSender() == ::Courier::Identifier(0x572dc517 /* btn_AS_IncFader */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_btn_AS_IncFader_enRelease, 0x807E7249); return true; }
#endif
#ifdef OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_btn_AS_DecFader_enRelease
    if ((message.GetView() == ::Courier::ViewId("AudioSetting#Scenes#SO_AS")) && (message.GetSender() == ::Courier::Identifier(0x5323eb88 /* btn_AS_DecFader */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_btn_AS_DecFader_enRelease, 0xE81A7325); return true; }
#endif
#ifdef OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_Button_EqPrst_enRelease
    if ((message.GetView() == ::Courier::ViewId("AudioSetting#Scenes#SO_AS")) && (message.GetSender() == ::Courier::Identifier(0x4fe6c713 /* Button_EqPrst */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_Button_EqPrst_enRelease, 0x9D3AED75); return true; }
#endif
#ifdef OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_Button_SpeedDepVol_enRelease
    if ((message.GetView() == ::Courier::ViewId("AudioSetting#Scenes#SO_AS")) && (message.GetSender() == ::Courier::Identifier(0x89a95393 /* Button_SpeedDepVol */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_Button_SpeedDepVol_enRelease, 0xD9B2912B); return true; }
#endif
#ifdef OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_tg_bn_BeepTones_enRelease
    if ((message.GetView() == ::Courier::ViewId("AudioSetting#Scenes#SO_AS")) && (message.GetSender() == ::Courier::Identifier(0x7a874628 /* tg_bn_BeepTones */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_tg_bn_BeepTones_enRelease, 0x8AC2EB49); return true; }
#endif
#ifdef OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_tg_bn_TouchClick_enRelease
    if ((message.GetView() == ::Courier::ViewId("AudioSetting#Scenes#SO_AS")) && (message.GetSender() == ::Courier::Identifier(0x85cb7041 /* tg_bn_TouchClick */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_tg_bn_TouchClick_enRelease, 0x683DAFF4); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_RVCBrightnessSettings_btn_RVC_DecBrightness_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SysSettingsScenes#SO_RVCBrightnessSettings")) && (message.GetSender() == ::Courier::Identifier(0x211f31b9 /* btn_RVC_DecBrightness */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_RVCBrightnessSettings_btn_RVC_DecBrightness_enRelease, 0x7D529CE7); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_RVCBrightnessSettings_btn_RVC_IncBrightness_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SysSettingsScenes#SO_RVCBrightnessSettings")) && (message.GetSender() == ::Courier::Identifier(0x5b0c7020 /* btn_RVC_IncBrightness */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_RVCBrightnessSettings_btn_RVC_IncBrightness_enRelease, 0x54D87580); return true; }
#endif
#ifdef OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_btn_AS_IncBass_enRelease
    if ((message.GetView() == ::Courier::ViewId("AudioSetting#Scenes#SO_AS")) && (message.GetSender() == ::Courier::Identifier(0x1971527f /* btn_AS_IncBass */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_btn_AS_IncBass_enRelease, 0xCD9348DC); return true; }
#endif
#ifdef OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_EqlPreset_Rbtn_EqlPrst_Flat_enRelease
    if ((message.GetView() == ::Courier::ViewId("AudioSetting#Scenes#SO_AS_EqlPreset")) && (message.GetSender() == ::Courier::Identifier(0x51b3377b /* Rbtn_EqlPrst_Flat */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_EqlPreset_Rbtn_EqlPrst_Flat_enRelease, 0xE2418A6E); return true; }
#endif
#ifdef OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_EqlPreset_Rbtn_EqlPrst_Rock_enRelease
    if ((message.GetView() == ::Courier::ViewId("AudioSetting#Scenes#SO_AS_EqlPreset")) && (message.GetSender() == ::Courier::Identifier(0xcfd8e2e6 /* Rbtn_EqlPrst_Rock */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_EqlPreset_Rbtn_EqlPrst_Rock_enRelease, 0xCC798E20); return true; }
#endif
#ifdef OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_EqlPreset_Rbtn_EqlPrst_Hiphop_enRelease
    if ((message.GetView() == ::Courier::ViewId("AudioSetting#Scenes#SO_AS_EqlPreset")) && (message.GetSender() == ::Courier::Identifier(0xe9b19cee /* Rbtn_EqlPrst_Hiphop */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_EqlPreset_Rbtn_EqlPrst_Hiphop_enRelease, 0x532C9552); return true; }
#endif
#ifdef OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_EqlPreset_Rbtn_EqlPrst_Classic_enRelease
    if ((message.GetView() == ::Courier::ViewId("AudioSetting#Scenes#SO_AS_EqlPreset")) && (message.GetSender() == ::Courier::Identifier(0xdc950920 /* Rbtn_EqlPrst_Classic */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_EqlPreset_Rbtn_EqlPrst_Classic_enRelease, 0x0B4DDFDE); return true; }
#endif
#ifdef OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_EqlPreset_Rbtn_EqlPrst_Jazz_enRelease
    if ((message.GetView() == ::Courier::ViewId("AudioSetting#Scenes#SO_AS_EqlPreset")) && (message.GetSender() == ::Courier::Identifier(0x417c64e1 /* Rbtn_EqlPrst_Jazz */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_EqlPreset_Rbtn_EqlPrst_Jazz_enRelease, 0x10085DE5); return true; }
#endif
#ifdef OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_SpeedDepVol_Rbtn_SpdDepVol_Off_enRelease
    if ((message.GetView() == ::Courier::ViewId("AudioSetting#Scenes#SO_AS_SpeedDepVol")) && (message.GetSender() == ::Courier::Identifier(0x57775d5a /* Rbtn_SpdDepVol_Off */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_SpeedDepVol_Rbtn_SpdDepVol_Off_enRelease, 0x49D1FBCE); return true; }
#endif
#ifdef OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_SpeedDepVol_Rbtn_SpdDepVol_Lvl1_enRelease
    if ((message.GetView() == ::Courier::ViewId("AudioSetting#Scenes#SO_AS_SpeedDepVol")) && (message.GetSender() == ::Courier::Identifier(0x0c308657 /* Rbtn_SpdDepVol_Lvl1 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_SpeedDepVol_Rbtn_SpdDepVol_Lvl1_enRelease, 0x6261D53C); return true; }
#endif
#ifdef OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_SpeedDepVol_Rbtn_SpdDepVol_Lvl2_enRelease
    if ((message.GetView() == ::Courier::ViewId("AudioSetting#Scenes#SO_AS_SpeedDepVol")) && (message.GetSender() == ::Courier::Identifier(0xd3b8956c /* Rbtn_SpdDepVol_Lvl2 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_SpeedDepVol_Rbtn_SpdDepVol_Lvl2_enRelease, 0x75BF246C); return true; }
#endif
#ifdef OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_SpeedDepVol_Rbtn_SpdDepVol_Lvl3_enRelease
    if ((message.GetView() == ::Courier::ViewId("AudioSetting#Scenes#SO_AS_SpeedDepVol")) && (message.GetSender() == ::Courier::Identifier(0x05eff9da /* Rbtn_SpdDepVol_Lvl3 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_SpeedDepVol_Rbtn_SpdDepVol_Lvl3_enRelease, 0x1C9B2825); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_DS_Layer_TouchArea_DSIncrease_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SysSettingsScenes#SO_DS")) && (message.GetSender() == ::Courier::Identifier(0x18f0671a /* Layer_TouchArea_DSIncrease/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_DS_Layer_TouchArea_DSIncrease_ButtonWidget_enRelease, 0xB36968CE); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_DS_Layer_TouchArea_DSDecrease_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SysSettingsScenes#SO_DS")) && (message.GetSender() == ::Courier::Identifier(0xd64bb179 /* Layer_TouchArea_DSDecrease/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_DS_Layer_TouchArea_DSDecrease_ButtonWidget_enRelease, 0x10F5E6F4); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_DS_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SysSettingsScenes#SO_DS")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_DS_Layer_TouchArea_Back_ButtonWidget_enRelease, 0xA4DAF086); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_SysSettings_Layer_Display_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SysSettingsScenes#SO_SysSettings")) && (message.GetSender() == ::Courier::Identifier(0x76c55986 /* Layer_Display/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_SysSettings_Layer_Display_ButtonWidget_enRelease, 0x611570E8); return true; }
#endif
#ifdef OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_EqlPreset_Rbtn_EqlPrst_Pop_enRelease
    if ((message.GetView() == ::Courier::ViewId("AudioSetting#Scenes#SO_AS_EqlPreset")) && (message.GetSender() == ::Courier::Identifier(0xddc828b2 /* Rbtn_EqlPrst_Pop */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_EqlPreset_Rbtn_EqlPrst_Pop_enRelease, 0x1E5E4E6B); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_DateFmtEU_Rbtn_DateFmtEU_4_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_CS_DateFmtEU")) && (message.GetSender() == ::Courier::Identifier(0x8144614a /* Rbtn_DateFmtEU_4 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_DateFmtEU_Rbtn_DateFmtEU_4_enRelease, 0x01933FC4); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_DateFmtEU_Rbtn_DateFmtEU_3_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_CS_DateFmtEU")) && (message.GetSender() == ::Courier::Identifier(0x940c06d9 /* Rbtn_DateFmtEU_3 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_DateFmtEU_Rbtn_DateFmtEU_3_enRelease, 0xEDA60FCA); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_DateFmtEU_Rbtn_DateFmtEU_2_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_CS_DateFmtEU")) && (message.GetSender() == ::Courier::Identifier(0xa5c22a45 /* Rbtn_DateFmtEU_2 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_DateFmtEU_Rbtn_DateFmtEU_2_enRelease, 0xD6E4F553); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_GlassSettings_CA_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SysSettingsScenes#SO_GlassSettings_CA")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_GlassSettings_CA_Layer_TouchArea_Back_ButtonWidget_enRelease, 0xAFDB2FE5); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_RVCSettings_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SysSettingsScenes#SO_RVCSettings")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_RVCSettings_Layer_TouchArea_Back_ButtonWidget_enRelease, 0x6B8AEE6C); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_RVCContrastSettings_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SysSettingsScenes#SO_RVCContrastSettings")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_RVCContrastSettings_Layer_TouchArea_Back_ButtonWidget_enRelease, 0xC508F138); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_RVCBrightnessSettings_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SysSettingsScenes#SO_RVCBrightnessSettings")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_RVCBrightnessSettings_Layer_TouchArea_Back_ButtonWidget_enRelease, 0x01A9B690); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_DTCInformation_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SysSettingsScenes#SO_DTCInformation")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_DTCInformation_Layer_TouchArea_Back_ButtonWidget_enRelease, 0x45EB10F6); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_OSS_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SysSettingsScenes#SO_OSS")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_OSS_Layer_TouchArea_Back_ButtonWidget_enRelease, 0xB34A0602); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_SoftwareVersion_CIS_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SysSettingsScenes#SO_SoftwareVersion_CIS")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_SoftwareVersion_CIS_Layer_TouchArea_Back_ButtonWidget_enRelease, 0xADEC7FBC); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SoftwareDownload_Pfo_SysSetFactDefault_Layer_Yes_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SoftwareDownload#Pfo_SysSetFactDefault")) && (message.GetSender() == ::Courier::Identifier(0xeaebbe6c /* Layer_Yes/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SoftwareDownload_Pfo_SysSetFactDefault_Layer_Yes_ButtonWidget_enRelease, 0xA2FDB673); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SoftwareDownload_Pfo_SysSetFactDefault_Layer_No_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SoftwareDownload#Pfo_SysSetFactDefault")) && (message.GetSender() == ::Courier::Identifier(0xb5018479 /* Layer_No/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SoftwareDownload_Pfo_SysSetFactDefault_Layer_No_ButtonWidget_enRelease, 0x66662D60); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_AS_EqlPreset_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SysSettingsScenes#SO_AS_EqlPreset")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_AS_EqlPreset_Layer_TouchArea_Back_ButtonWidget_enRelease, 0x4D51B22F); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_AS_SpeedDepVol_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SysSettingsScenes#SO_AS_SpeedDepVol")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_AS_SpeedDepVol_Layer_TouchArea_Back_ButtonWidget_enRelease, 0x518F01BD); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_SysSettings_CA_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SysSettingsScenes#SO_SysSettings_CA")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_SysSettings_CA_Layer_TouchArea_Back_ButtonWidget_enRelease, 0x545088E9); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_audioSetting_CA_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SysSettingsScenes#SO_audioSetting_CA")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_audioSetting_CA_Layer_TouchArea_Back_ButtonWidget_enRelease, 0xDEBDBA98); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_glass_setting_CA_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SysSettingsScenes#SO_glass_setting_CA")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_glass_setting_CA_Layer_TouchArea_Back_ButtonWidget_enRelease, 0x7FF1CEE3); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_VideoMixSource_CA_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SysSettingsScenes#SO_VideoMixSource_CA")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_VideoMixSource_CA_Layer_TouchArea_Back_ButtonWidget_enRelease, 0x0867EF49); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_OSS_CA_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SysSettingsScenes#SO_OSS_CA")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_OSS_CA_Layer_TouchArea_Back_ButtonWidget_enRelease, 0x2E52902B); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_SysSettings_CB_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SysSettingsScenes#SO_SysSettings_CB")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_SysSettings_CB_Layer_TouchArea_Back_ButtonWidget_enRelease, 0x23C27BBB); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_AS_SpeedDepVol_Layer_SpdDepVol_Off_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SysSettingsScenes#SO_AS_SpeedDepVol")) && (message.GetSender() == ::Courier::Identifier(0x7827a345 /* Layer_SpdDepVol_Off/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_AS_SpeedDepVol_Layer_SpdDepVol_Off_ButtonWidget2D_enRelease, 0xA8A41D06); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_AS_SpeedDepVol_Layer_SpdDepVol_Lvl1_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SysSettingsScenes#SO_AS_SpeedDepVol")) && (message.GetSender() == ::Courier::Identifier(0x0eb3290d /* Layer_SpdDepVol_Lvl1/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_AS_SpeedDepVol_Layer_SpdDepVol_Lvl1_ButtonWidget2D_enRelease, 0xA497282A); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_AS_SpeedDepVol_Layer_SpdDepVol_Lvl2_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SysSettingsScenes#SO_AS_SpeedDepVol")) && (message.GetSender() == ::Courier::Identifier(0x65366c01 /* Layer_SpdDepVol_Lvl2/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_AS_SpeedDepVol_Layer_SpdDepVol_Lvl2_ButtonWidget2D_enRelease, 0xD769A77C); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_AS_SpeedDepVol_Layer_SpdDepVol_Lvl3_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SysSettingsScenes#SO_AS_SpeedDepVol")) && (message.GetSender() == ::Courier::Identifier(0x8f1df518 /* Layer_SpdDepVol_Lvl3/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_AS_SpeedDepVol_Layer_SpdDepVol_Lvl3_ButtonWidget2D_enRelease, 0xB95729C0); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_AS_PrivateMode_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SysSettingsScenes#SO_AS_PrivateMode")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_AS_PrivateMode_Layer_TouchArea_Back_ButtonWidget_enRelease, 0x777C8CDC); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_AS_PrivateMode_Layer_PrivateMode_1_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SysSettingsScenes#SO_AS_PrivateMode")) && (message.GetSender() == ::Courier::Identifier(0x8e404e1f /* Layer_PrivateMode_1/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_AS_PrivateMode_Layer_PrivateMode_1_ButtonWidget2D_enRelease, 0x7C54F8A0); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_AS_PrivateMode_Layer_PrivateMode_2_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SysSettingsScenes#SO_AS_PrivateMode")) && (message.GetSender() == ::Courier::Identifier(0xf05f6b1b /* Layer_PrivateMode_2/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_AS_PrivateMode_Layer_PrivateMode_2_ButtonWidget2D_enRelease, 0x11AA1EFE); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_AS_PrivateMode_Layer_PrivateMode_3_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SysSettingsScenes#SO_AS_PrivateMode")) && (message.GetSender() == ::Courier::Identifier(0x384f2308 /* Layer_PrivateMode_3/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_AS_PrivateMode_Layer_PrivateMode_3_ButtonWidget2D_enRelease, 0x1B6EA63A); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_OEM_MENU_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SysSettingsScenes#SO_OEM_MENU")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_OEM_MENU_Layer_TouchArea_Back_ButtonWidget_enRelease, 0x263702DA); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_MIC_AS_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SysSettingsScenes#SO_MIC_AS")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_MIC_AS_Layer_TouchArea_Back_ButtonWidget_enRelease, 0xF7FF9993); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_AudioSettings_CA_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SysSettingsScenes#SO_AudioSettings_CA")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_AudioSettings_CA_Layer_TouchArea_Back_ButtonWidget_enRelease, 0x51D11212); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_ConfigurationVersion_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SysSettingsScenes#SO_ConfigurationVersion")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_ConfigurationVersion_Layer_TouchArea_Back_ButtonWidget_enRelease, 0xCEF41805); return true; }
#endif
#ifdef OnButtonReactionMsg_Volume_PopUp_Scenes_SwUpdate_Downgrade_Btn_Cancel_enRelease
    if ((message.GetView() == ::Courier::ViewId("Volume_PopUp#Scenes#SwUpdate_Downgrade")) && (message.GetSender() == ::Courier::Identifier(0xb4246fe1 /* Btn_Cancel */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Volume_PopUp_Scenes_SwUpdate_Downgrade_Btn_Cancel_enRelease, 0x30EC2327); return true; }
#endif
#ifdef OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_SysSettings_Button_Language_enRelease
    if ((message.GetView() == ::Courier::ViewId("SystemSettings#SysSettingsScenes#SO_SysSettings")) && (message.GetSender() == ::Courier::Identifier(0x83a0ae82 /* Button_Language */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_SysSettings_Button_Language_enRelease, 0x47BEDA5F); return true; }
#endif
#ifdef OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_SysSettings_Button_SoundSettings_enRelease
    if ((message.GetView() == ::Courier::ViewId("SystemSettings#SysSettingsScenes#SO_SysSettings")) && (message.GetSender() == ::Courier::Identifier(0x5f519069 /* Button_SoundSettings */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_SysSettings_Button_SoundSettings_enRelease, 0xC6F6402F); return true; }
#endif
#ifdef OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_SysSettings_Button_Display_enRelease
    if ((message.GetView() == ::Courier::ViewId("SystemSettings#SysSettingsScenes#SO_SysSettings")) && (message.GetSender() == ::Courier::Identifier(0x207578b2 /* Button_Display */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_SysSettings_Button_Display_enRelease, 0xFF401E0D); return true; }
#endif
#ifdef OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_SysSettings_Button_SecurityPIN_enRelease
    if ((message.GetView() == ::Courier::ViewId("SystemSettings#SysSettingsScenes#SO_SysSettings")) && (message.GetSender() == ::Courier::Identifier(0x17f1d48b /* Button_SecurityPIN */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_SysSettings_Button_SecurityPIN_enRelease, 0x21DF6227); return true; }
#endif
#ifdef OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_SysSettings_Button_Clock_enRelease
    if ((message.GetView() == ::Courier::ViewId("SystemSettings#SysSettingsScenes#SO_SysSettings")) && (message.GetSender() == ::Courier::Identifier(0x624dc58b /* Button_Clock */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_SysSettings_Button_Clock_enRelease, 0x5E139939); return true; }
#endif
#ifdef OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_SysSettings_ToggleButtonWidget2D_SpeedLock_enRelease
    if ((message.GetView() == ::Courier::ViewId("SystemSettings#SysSettingsScenes#SO_SysSettings")) && (message.GetSender() == ::Courier::Identifier(0x39a906dd /* ToggleButtonWidget2D_SpeedLock */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_SysSettings_ToggleButtonWidget2D_SpeedLock_enRelease, 0x717B063B); return true; }
#endif
#ifdef OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_SysSettings_Button_RearViewCameraSetting_enRelease
    if ((message.GetView() == ::Courier::ViewId("SystemSettings#SysSettingsScenes#SO_SysSettings")) && (message.GetSender() == ::Courier::Identifier(0x6c07d436 /* Button_RearViewCameraSetting */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_SysSettings_Button_RearViewCameraSetting_enRelease, 0x816BEAC6); return true; }
#endif
#ifdef OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_EU_Button_Back_enRelease
    if ((message.GetView() == ::Courier::ViewId("SystemSettings#SysSettingsScenes#SO_LS_EU")) && (message.GetSender() == ::Courier::Identifier(0x4725ee69 /* Button_Back */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_EU_Button_Back_enRelease, 0x6457DC49); return true; }
#endif
#ifdef OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_EU_Candidate_EU_1_enRelease
    if ((message.GetView() == ::Courier::ViewId("SystemSettings#SysSettingsScenes#SO_LS_EU")) && (message.GetSender() == ::Courier::Identifier(0x18a2b303 /* Candidate_EU_1 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_EU_Candidate_EU_1_enRelease, 0xEEC67B5A); return true; }
#endif
#ifdef OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_EU_Candidate_EU_2_enRelease
    if ((message.GetView() == ::Courier::ViewId("SystemSettings#SysSettingsScenes#SO_LS_EU")) && (message.GetSender() == ::Courier::Identifier(0x2aec5796 /* Candidate_EU_2 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_EU_Candidate_EU_2_enRelease, 0x862CDFC1); return true; }
#endif
#ifdef OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_EU_Candidate_EU_3_enRelease
    if ((message.GetView() == ::Courier::ViewId("SystemSettings#SysSettingsScenes#SO_LS_EU")) && (message.GetSender() == ::Courier::Identifier(0xe21845ef /* Candidate_EU_3 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_EU_Candidate_EU_3_enRelease, 0x36E9812F); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_AS_EqlPreset_Layer_EqlPrst_Flat_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SysSettingsScenes#SO_AS_EqlPreset")) && (message.GetSender() == ::Courier::Identifier(0xa20c0424 /* Layer_EqlPrst_Flat/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_AS_EqlPreset_Layer_EqlPrst_Flat_ButtonWidget2D_enRelease, 0x0A101753); return true; }
#endif
#ifdef OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_EU_Candidate_EU_4_enRelease
    if ((message.GetView() == ::Courier::ViewId("SystemSettings#SysSettingsScenes#SO_LS_EU")) && (message.GetSender() == ::Courier::Identifier(0x0e779ead /* Candidate_EU_4 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_EU_Candidate_EU_4_enRelease, 0x337BA1F2); return true; }
#endif
#ifdef OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_EU_Candidate_EU_6_enRelease
    if ((message.GetView() == ::Courier::ViewId("SystemSettings#SysSettingsScenes#SO_LS_EU")) && (message.GetSender() == ::Courier::Identifier(0x61f5c5a8 /* Candidate_EU_6 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_EU_Candidate_EU_6_enRelease, 0x261D5EE5); return true; }
#endif
#ifdef OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_EU_Candidate_EU_7_enRelease
    if ((message.GetView() == ::Courier::ViewId("SystemSettings#SysSettingsScenes#SO_LS_EU")) && (message.GetSender() == ::Courier::Identifier(0x35146be6 /* Candidate_EU_7 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_EU_Candidate_EU_7_enRelease, 0x74333E59); return true; }
#endif
#ifdef OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_EU_Candidate_EU_8_enRelease
    if ((message.GetView() == ::Courier::ViewId("SystemSettings#SysSettingsScenes#SO_LS_EU")) && (message.GetSender() == ::Courier::Identifier(0x454b0c53 /* Candidate_EU_8 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_EU_Candidate_EU_8_enRelease, 0xFC949046); return true; }
#endif
#ifdef OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_EU_Candidate_EU_9_enRelease
    if ((message.GetView() == ::Courier::ViewId("SystemSettings#SysSettingsScenes#SO_LS_EU")) && (message.GetSender() == ::Courier::Identifier(0xae2d5e16 /* Candidate_EU_9 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_EU_Candidate_EU_9_enRelease, 0xA7CDF918); return true; }
#endif
#ifdef OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_EU_Candidate_EU_10_enRelease
    if ((message.GetView() == ::Courier::ViewId("SystemSettings#SysSettingsScenes#SO_LS_EU")) && (message.GetSender() == ::Courier::Identifier(0xf483080b /* Candidate_EU_10 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_EU_Candidate_EU_10_enRelease, 0x3D88717E); return true; }
#endif
#ifdef OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_EU_Candidate_EU_11_enRelease
    if ((message.GetView() == ::Courier::ViewId("SystemSettings#SysSettingsScenes#SO_LS_EU")) && (message.GetSender() == ::Courier::Identifier(0xe6cb6c9c /* Candidate_EU_11 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_EU_Candidate_EU_11_enRelease, 0x0DF61042); return true; }
#endif
#ifdef OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_EU_Candidate_EU_12_enRelease
    if ((message.GetView() == ::Courier::ViewId("SystemSettings#SysSettingsScenes#SO_LS_EU")) && (message.GetSender() == ::Courier::Identifier(0xb3d306a8 /* Candidate_EU_12 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_EU_Candidate_EU_12_enRelease, 0x18A128AD); return true; }
#endif
#ifdef OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_EU_Candidate_EU_13_enRelease
    if ((message.GetView() == ::Courier::ViewId("SystemSettings#SysSettingsScenes#SO_LS_EU")) && (message.GetSender() == ::Courier::Identifier(0xa52be95a /* Candidate_EU_13 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_EU_Candidate_EU_13_enRelease, 0x56274B00); return true; }
#endif
#ifdef OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_EU_Candidate_EU_14_enRelease
    if ((message.GetView() == ::Courier::ViewId("SystemSettings#SysSettingsScenes#SO_LS_EU")) && (message.GetSender() == ::Courier::Identifier(0x97624dc7 /* Candidate_EU_14 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_EU_Candidate_EU_14_enRelease, 0xCFE52021); return true; }
#endif
#ifdef OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_EU_Candidate_EU_15_enRelease
    if ((message.GetView() == ::Courier::ViewId("SystemSettings#SysSettingsScenes#SO_LS_EU")) && (message.GetSender() == ::Courier::Identifier(0x78a21047 /* Candidate_EU_15 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_EU_Candidate_EU_15_enRelease, 0xDB9013ED); return true; }
#endif
#ifdef OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_CN_Button_Back_enRelease
    if ((message.GetView() == ::Courier::ViewId("SystemSettings#SysSettingsScenes#SO_LS_CN")) && (message.GetSender() == ::Courier::Identifier(0x4725ee69 /* Button_Back */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_CN_Button_Back_enRelease, 0x7018D47E); return true; }
#endif
#ifdef OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_CN_Candidate_CN_1_enRelease
    if ((message.GetView() == ::Courier::ViewId("SystemSettings#SysSettingsScenes#SO_LS_CN")) && (message.GetSender() == ::Courier::Identifier(0x99483447 /* Candidate_CN_1 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_CN_Candidate_CN_1_enRelease, 0xAF0F27C0); return true; }
#endif
#ifdef OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_EU_Candidate_EU_5_enRelease
    if ((message.GetView() == ::Courier::ViewId("SystemSettings#SysSettingsScenes#SO_LS_EU")) && (message.GetSender() == ::Courier::Identifier(0x4f8820cd /* Candidate_EU_5 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_EU_Candidate_EU_5_enRelease, 0x1B7ACA45); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_AS_EqlPreset_Layer_EqlPrst_Pop_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SysSettingsScenes#SO_AS_EqlPreset")) && (message.GetSender() == ::Courier::Identifier(0x39802b46 /* Layer_EqlPrst_Pop/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_AS_EqlPreset_Layer_EqlPrst_Pop_ButtonWidget2D_enRelease, 0x3A12F992); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_AS_EqlPreset_Layer_EqlPrst_Rock_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SysSettingsScenes#SO_AS_EqlPreset")) && (message.GetSender() == ::Courier::Identifier(0x9075e636 /* Layer_EqlPrst_Rock/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_AS_EqlPreset_Layer_EqlPrst_Rock_ButtonWidget2D_enRelease, 0x4273EDF7); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_AS_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SysSettingsScenes#SO_AS")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_AS_Layer_TouchArea_Back_ButtonWidget_enRelease, 0x49F898C2); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_GPS_Button_CS_GPS_24HFormat_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_CS_GPS")) && (message.GetSender() == ::Courier::Identifier(0x594d71dd /* Button_CS_GPS_24HFormat */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_GPS_Button_CS_GPS_24HFormat_enRelease, 0x7C6E800E); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_GPS_Button_CS_GPS_CLKSetMode_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_CS_GPS")) && (message.GetSender() == ::Courier::Identifier(0x66c276ea /* Button_CS_GPS_CLKSetMode */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_GPS_Button_CS_GPS_CLKSetMode_enRelease, 0xA89B5B28); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_GPS_Button_CS_GPSMode_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_CS_GPS")) && (message.GetSender() == ::Courier::Identifier(0x5a3e167e /* Button_CS_GPSMode */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_GPS_Button_CS_GPSMode_enRelease, 0x8F6CEB73); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_GPS_Button_CS_ManualMode_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_CS_GPS")) && (message.GetSender() == ::Courier::Identifier(0x54092a94 /* Button_CS_ManualMode */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_GPS_Button_CS_ManualMode_enRelease, 0xF71E9D10); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_GPS_tg_DayLightbn_TouchClick_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_CS_GPS")) && (message.GetSender() == ::Courier::Identifier(0x882f4da7 /* tg_DayLightbn_TouchClick */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_GPS_tg_DayLightbn_TouchClick_enRelease, 0xBD091A78); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_GPS_btn_TimeZone_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_CS_GPS")) && (message.GetSender() == ::Courier::Identifier(0xa8ed10d7 /* btn_TimeZone */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_GPS_btn_TimeZone_enRelease, 0x88051082); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_Manual_btn_CS_Manual_back_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_CS_Manual")) && (message.GetSender() == ::Courier::Identifier(0x74de05a4 /* btn_CS_Manual_back */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_Manual_btn_CS_Manual_back_enRelease, 0x3FA37BA8); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_Manual_btn_CS_Manual_back_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_CS_Manual")) && (message.GetSender() == ::Courier::Identifier(0x74de05a4 /* btn_CS_Manual_back */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_Manual_btn_CS_Manual_back_enLongPressRelease, 0x41330B82); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_Manual_Button_CS_Manual_CLKSetMode_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_CS_Manual")) && (message.GetSender() == ::Courier::Identifier(0xd15f3ec6 /* Button_CS_Manual_CLKSetMode */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_Manual_Button_CS_Manual_CLKSetMode_enRelease, 0x2F03A4B5); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_Manual_Button_Hr_IINC_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_CS_Manual")) && (message.GetSender() == ::Courier::Identifier(0xfc2c8523 /* Button_Hr_IINC */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_Manual_Button_Hr_IINC_enRelease, 0xA80D0542); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_Manual_Button_Hr_IINC_enRepeatPressSecondary
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_CS_Manual")) && (message.GetSender() == ::Courier::Identifier(0xfc2c8523 /* Button_Hr_IINC */)) && (message.GetEnReaction() == enRepeatPressSecondary)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_Manual_Button_Hr_IINC_enRepeatPressSecondary, 0xE54738ED); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_Manual_Button_Hr_DEC_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_CS_Manual")) && (message.GetSender() == ::Courier::Identifier(0x42572295 /* Button_Hr_DEC */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_Manual_Button_Hr_DEC_enRelease, 0x6BC3A1B8); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_GPS_Button_CS_GPS_12HFormat_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_CS_GPS")) && (message.GetSender() == ::Courier::Identifier(0xd0098fc5 /* Button_CS_GPS_12HFormat */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_GPS_Button_CS_GPS_12HFormat_enRelease, 0x519B2D15); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_Manual_Button_Hr_DEC_enRepeatPressSecondary
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_CS_Manual")) && (message.GetSender() == ::Courier::Identifier(0x42572295 /* Button_Hr_DEC */)) && (message.GetEnReaction() == enRepeatPressSecondary)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_Manual_Button_Hr_DEC_enRepeatPressSecondary, 0x23D8F4B4); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_Manual_Button_Min_INCR_enRepeatPressSecondary
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_CS_Manual")) && (message.GetSender() == ::Courier::Identifier(0x212f1d66 /* Button_Min_INCR */)) && (message.GetEnReaction() == enRepeatPressSecondary)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_Manual_Button_Min_INCR_enRepeatPressSecondary, 0x21D91FD4); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_Manual_Button_Min_DECR_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_CS_Manual")) && (message.GetSender() == ::Courier::Identifier(0x5b96e97f /* Button_Min_DECR */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_Manual_Button_Min_DECR_enRelease, 0xC97C66BF); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_Manual_Button_Min_DECR_enRepeatPressSecondary
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_CS_Manual")) && (message.GetSender() == ::Courier::Identifier(0x5b96e97f /* Button_Min_DECR */)) && (message.GetEnReaction() == enRepeatPressSecondary)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_Manual_Button_Min_DECR_enRepeatPressSecondary, 0x0412ADF3); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_Manual_Button_CS_Manual_DateFormat_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_CS_Manual")) && (message.GetSender() == ::Courier::Identifier(0xca9a4aae /* Button_CS_Manual_DateFormat */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_Manual_Button_CS_Manual_DateFormat_enRelease, 0xA7F94F4D); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_Manual_Button_CS_Manual_TimeFormat_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_CS_Manual")) && (message.GetSender() == ::Courier::Identifier(0x5df8c3dd /* Button_CS_Manual_TimeFormat */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_Manual_Button_CS_Manual_TimeFormat_enRelease, 0x592AEE16); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_Manual_Button_CS_Manual_12HFormat_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_CS_Manual")) && (message.GetSender() == ::Courier::Identifier(0x1b018978 /* Button_CS_Manual_12HFormat */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_Manual_Button_CS_Manual_12HFormat_enRelease, 0x8A115F78); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_Manual_Button_CS_Manual_24HFormat_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_CS_Manual")) && (message.GetSender() == ::Courier::Identifier(0xaf91e243 /* Button_CS_Manual_24HFormat */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_Manual_Button_CS_Manual_24HFormat_enRelease, 0x847E4DAD); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_Manual_Button_CS_GPSMode_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_CS_Manual")) && (message.GetSender() == ::Courier::Identifier(0x5a3e167e /* Button_CS_GPSMode */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_Manual_Button_CS_GPSMode_enRelease, 0xA0E61664); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_Manual_Button_CS_ManualMode_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_CS_Manual")) && (message.GetSender() == ::Courier::Identifier(0x54092a94 /* Button_CS_ManualMode */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_Manual_Button_CS_ManualMode_enRelease, 0x6F10E7B2); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_DateFmtEU_btn_DateFmtEU_Back_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_CS_DateFmtEU")) && (message.GetSender() == ::Courier::Identifier(0x21cc3e39 /* btn_DateFmtEU_Back */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_DateFmtEU_btn_DateFmtEU_Back_enRelease, 0xA1B43481); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_DateFmtEU_btn_DateFmtEU_Back_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_CS_DateFmtEU")) && (message.GetSender() == ::Courier::Identifier(0x21cc3e39 /* btn_DateFmtEU_Back */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_DateFmtEU_btn_DateFmtEU_Back_enLongPressRelease, 0xD1225501); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_DateFmtEU_Rbtn_DateFmtEU_1_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_CS_DateFmtEU")) && (message.GetSender() == ::Courier::Identifier(0xb880cfc2 /* Rbtn_DateFmtEU_1 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_DateFmtEU_Rbtn_DateFmtEU_1_enRelease, 0x80993518); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_Manual_Button_Min_INCR_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_CS_Manual")) && (message.GetSender() == ::Courier::Identifier(0x212f1d66 /* Button_Min_INCR */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_Manual_Button_Min_INCR_enRelease, 0x4927AC3B); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SoftwareDownload_SWUpdate_Update_Info_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SoftwareDownload#SWUpdate_Update_Info")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SoftwareDownload_SWUpdate_Update_Info_Layer_TouchArea_Back_ButtonWidget_enRelease, 0x973CB4FE); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_GPS_Button_CS_GPS_TimeFormat_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_CS_GPS")) && (message.GetSender() == ::Courier::Identifier(0xe58b2293 /* Button_CS_GPS_TimeFormat */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_GPS_Button_CS_GPS_TimeFormat_enRelease, 0x6FE3C79C); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_GPS_btn_CS_GPS_back_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_CS_GPS")) && (message.GetSender() == ::Courier::Identifier(0x755ac7df /* btn_CS_GPS_back */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_GPS_btn_CS_GPS_back_enLongPressRelease, 0x65A5197A); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_AS_EqlPreset_Layer_EqlPrst_HipHop_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SysSettingsScenes#SO_AS_EqlPreset")) && (message.GetSender() == ::Courier::Identifier(0x2950b82e /* Layer_EqlPrst_HipHop/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_AS_EqlPreset_Layer_EqlPrst_HipHop_ButtonWidget2D_enRelease, 0xD2334C55); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_AS_EqlPreset_Layer_EqlPrst_Classic_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SysSettingsScenes#SO_AS_EqlPreset")) && (message.GetSender() == ::Courier::Identifier(0xe72c4891 /* Layer_EqlPrst_Classic/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_AS_EqlPreset_Layer_EqlPrst_Classic_ButtonWidget2D_enRelease, 0x8C1DC1DA); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_AS_EqlPreset_Layer_EqlPrst_Jazz_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SysSettingsScenes#SO_AS_EqlPreset")) && (message.GetSender() == ::Courier::Identifier(0xb40ffe4f /* Layer_EqlPrst_Jazz/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_AS_EqlPreset_Layer_EqlPrst_Jazz_ButtonWidget2D_enRelease, 0x9BF91F7C); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_OEM_PIN_Button_OK_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SysSettingsScenes#SO_OEM_PIN")) && (message.GetSender() == ::Courier::Identifier(0x93fe5f74 /* Button_OK/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_OEM_PIN_Button_OK_ButtonWidget_enRelease, 0x30E69C4B); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_OEM_PIN_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SysSettingsScenes#SO_OEM_PIN")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_OEM_PIN_Layer_TouchArea_Back_ButtonWidget_enRelease, 0xEB0AE622); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_GS_SwivelCalibration_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SysSettingsScenes#SO_GS_SwivelCalibration")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_GS_SwivelCalibration_Layer_TouchArea_Back_ButtonWidget_enRelease, 0xB07A71B2); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_CS_DateFmt_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SysSettingsScenes#SO_CS_DateFmt")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_CS_DateFmt_Layer_TouchArea_Back_ButtonWidget_enRelease, 0xC62D4CB7); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_CS_TimeZone_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SysSettingsScenes#SO_CS_TimeZone")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_CS_TimeZone_Layer_TouchArea_Back_ButtonWidget_enRelease, 0xDB861496); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_CS_DateFmt_Layer_Radiobutton_DateFormat1_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SysSettingsScenes#SO_CS_DateFmt")) && (message.GetSender() == ::Courier::Identifier(0xa43e7c28 /* Layer_Radiobutton_DateFormat1/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_CS_DateFmt_Layer_Radiobutton_DateFormat1_ButtonWidget2D_enRelease, 0x3E2FC646); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_CS_DateFmt_Layer_Radiobutton_DateFormat2_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SysSettingsScenes#SO_CS_DateFmt")) && (message.GetSender() == ::Courier::Identifier(0x8f44d168 /* Layer_Radiobutton_DateFormat2/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_CS_DateFmt_Layer_Radiobutton_DateFormat2_ButtonWidget2D_enRelease, 0x7C78443E); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_CS_DateFmt_Layer_Radiobutton_DateFormat3_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SysSettingsScenes#SO_CS_DateFmt")) && (message.GetSender() == ::Courier::Identifier(0xe5a05718 /* Layer_Radiobutton_DateFormat3/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_CS_DateFmt_Layer_Radiobutton_DateFormat3_ButtonWidget2D_enRelease, 0x8178EDD9); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_CS_DateFmt_Layer_Radiobutton_DateFormat4_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SysSettingsScenes#SO_CS_DateFmt")) && (message.GetSender() == ::Courier::Identifier(0x8f4746c5 /* Layer_Radiobutton_DateFormat4/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_CS_DateFmt_Layer_Radiobutton_DateFormat4_ButtonWidget2D_enRelease, 0x4BC08607); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_GPS_Button_CS_GPS_DateFormat_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_CS_GPS")) && (message.GetSender() == ::Courier::Identifier(0xdb5e5ddb /* Button_CS_GPS_DateFormat */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_GPS_Button_CS_GPS_DateFormat_enRelease, 0x47BB4BB8); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_CS_DateFmt_Layer_Radiobutton_DateFormat5_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SysSettingsScenes#SO_CS_DateFmt")) && (message.GetSender() == ::Courier::Identifier(0x69a52170 /* Layer_Radiobutton_DateFormat5/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_CS_DateFmt_Layer_Radiobutton_DateFormat5_ButtonWidget2D_enRelease, 0xA938C729); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_CS_GPS_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SysSettingsScenes#SO_CS_GPS")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_CS_GPS_Layer_TouchArea_Back_ButtonWidget_enRelease, 0x4DB607B2); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_CS_Manual_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SysSettingsScenes#SO_CS_Manual")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_CS_Manual_Layer_TouchArea_Back_ButtonWidget_enRelease, 0xA23B086E); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_LS_EU_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SysSettingsScenes#SO_LS_EU")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_LS_EU_Layer_TouchArea_Back_ButtonWidget_enRelease, 0x0D02E21F); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_LS_Nafta_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SysSettingsScenes#SO_LS_Nafta")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_LS_Nafta_Layer_TouchArea_Back_ButtonWidget_enRelease, 0x87DB82AA); return true; }
#endif
#ifdef OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_CN_Candidate_CN_2_enRelease
    if ((message.GetView() == ::Courier::ViewId("SystemSettings#SysSettingsScenes#SO_LS_CN")) && (message.GetSender() == ::Courier::Identifier(0x6bf5d9a3 /* Candidate_CN_2 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_CN_Candidate_CN_2_enRelease, 0x930DB55F); return true; }
#endif
#ifdef OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_GEX_Button_Back_enRelease
    if ((message.GetView() == ::Courier::ViewId("SystemSettings#SysSettingsScenes#SO_LS_GEX")) && (message.GetSender() == ::Courier::Identifier(0x4725ee69 /* Button_Back */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_GEX_Button_Back_enRelease, 0x51B5EA74); return true; }
#endif
#ifdef OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_GEX_Candidate_GEX_1_enRelease
    if ((message.GetView() == ::Courier::ViewId("SystemSettings#SysSettingsScenes#SO_LS_GEX")) && (message.GetSender() == ::Courier::Identifier(0xf565ae0c /* Candidate_GEX_1 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_GEX_Candidate_GEX_1_enRelease, 0x15C094B4); return true; }
#endif
#ifdef OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_GEX_Candidate_GEX_2_enRelease
    if ((message.GetView() == ::Courier::ViewId("SystemSettings#SysSettingsScenes#SO_LS_GEX")) && (message.GetSender() == ::Courier::Identifier(0xbf4e41de /* Candidate_GEX_2 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_GEX_Candidate_GEX_2_enRelease, 0x23767312); return true; }
#endif
#ifdef OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_GEX_Candidate_GEX_3_enRelease
    if ((message.GetView() == ::Courier::ViewId("SystemSettings#SysSettingsScenes#SO_LS_GEX")) && (message.GetSender() == ::Courier::Identifier(0x090a5555 /* Candidate_GEX_3 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_GEX_Candidate_GEX_3_enRelease, 0x0BDCFBAA); return true; }
#endif
#ifdef OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_GEX_Candidate_GEX_4_enRelease
    if ((message.GetView() == ::Courier::ViewId("SystemSettings#SysSettingsScenes#SO_LS_GEX")) && (message.GetSender() == ::Courier::Identifier(0xe2ca08d5 /* Candidate_GEX_4 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_GEX_Candidate_GEX_4_enRelease, 0xDBDE7200); return true; }
#endif
#ifdef OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_GEX_Candidate_GEX_5_enRelease
    if ((message.GetView() == ::Courier::ViewId("SystemSettings#SysSettingsScenes#SO_LS_GEX")) && (message.GetSender() == ::Courier::Identifier(0xbadc38fa /* Candidate_GEX_5 */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_GEX_Candidate_GEX_5_enRelease, 0x62B0327F); return true; }
#endif
#ifdef OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_GPS_btn_CS_GPS_back_enRelease
    if ((message.GetView() == ::Courier::ViewId("ClockSetting#Scenes#SO_CS_GPS")) && (message.GetSender() == ::Courier::Identifier(0x755ac7df /* btn_CS_GPS_back */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_GPS_btn_CS_GPS_back_enRelease, 0x1FFC37D3); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_CS_DateFmt_Layer_Radiobutton_DateFormat6_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SysSettingsScenes#SO_CS_DateFmt")) && (message.GetSender() == ::Courier::Identifier(0xac9194ad /* Layer_Radiobutton_DateFormat6/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_CS_DateFmt_Layer_Radiobutton_DateFormat6_ButtonWidget2D_enRelease, 0x855900B5); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_SysSettings_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_System#SysSettingsScenes#SO_SysSettings")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_SysSettings_Layer_TouchArea_Back_ButtonWidget_enRelease, 0x9AA15851); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForButtonReactionMsg(AppHmi_SystemStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::ButtonReactionMsg const & message = static_cast< ::ButtonReactionMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onTopPopupSurfaceInvisible
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onTopPopupSurfaceInvisible 0xffff
#pragma _REMINDER("Using dummy value symbol onTopPopupSurfaceInvisible ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onTopPopupSurfaceInvisible -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onTopPopupSurfaceVisible
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onTopPopupSurfaceVisible 0xffff
#pragma _REMINDER("Using dummy value symbol onTopPopupSurfaceVisible ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onTopPopupSurfaceVisible -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onTopPopupSurfaceUnqueued
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onTopPopupSurfaceUnqueued 0xffff
#pragma _REMINDER("Using dummy value symbol onTopPopupSurfaceUnqueued ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onTopPopupSurfaceUnqueued -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onTopPopupSurfaceQueued
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onTopPopupSurfaceQueued 0xffff
#pragma _REMINDER("Using dummy value symbol onTopPopupSurfaceQueued ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onTopPopupSurfaceQueued -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onCenterPopupSurfaceInvisible
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onCenterPopupSurfaceInvisible 0xffff
#pragma _REMINDER("Using dummy value symbol onCenterPopupSurfaceInvisible ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onCenterPopupSurfaceInvisible -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onCenterPopupSurfaceVisible
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onCenterPopupSurfaceVisible 0xffff
#pragma _REMINDER("Using dummy value symbol onCenterPopupSurfaceVisible ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onCenterPopupSurfaceVisible -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onCenterPopupSurfaceUnqueued
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onCenterPopupSurfaceUnqueued 0xffff
#pragma _REMINDER("Using dummy value symbol onCenterPopupSurfaceUnqueued ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onCenterPopupSurfaceUnqueued -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onCenterPopupSurfaceQueued
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onCenterPopupSurfaceQueued 0xffff
#pragma _REMINDER("Using dummy value symbol onCenterPopupSurfaceQueued ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onCenterPopupSurfaceQueued -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onSystemInstallationPopupSurfaceInvisible
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onSystemInstallationPopupSurfaceInvisible 0xffff
#pragma _REMINDER("Using dummy value symbol onSystemInstallationPopupSurfaceInvisible ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onSystemInstallationPopupSurfaceInvisible -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onSystemInstallationPopupSurfaceVisible
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onSystemInstallationPopupSurfaceVisible 0xffff
#pragma _REMINDER("Using dummy value symbol onSystemInstallationPopupSurfaceVisible ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onSystemInstallationPopupSurfaceVisible -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onSystemInstallationPopupSurfaceUnqueued
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onSystemInstallationPopupSurfaceUnqueued 0xffff
#pragma _REMINDER("Using dummy value symbol onSystemInstallationPopupSurfaceUnqueued ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onSystemInstallationPopupSurfaceUnqueued -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onSystemInstallationPopupSurfaceQueued
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onSystemInstallationPopupSurfaceQueued 0xffff
#pragma _REMINDER("Using dummy value symbol onSystemInstallationPopupSurfaceQueued ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onSystemInstallationPopupSurfaceQueued -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onPopupVisible
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onPopupVisible 0xffff
#pragma _REMINDER("Using dummy value symbol onPopupVisible ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onPopupVisible -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onPopupUnqueued
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onPopupUnqueued 0xffff
#pragma _REMINDER("Using dummy value symbol onPopupUnqueued ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onPopupUnqueued -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onPopupQueued
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onPopupQueued 0xffff
#pragma _REMINDER("Using dummy value symbol onPopupQueued ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onPopupQueued -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForSurfaceStateChangedUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);

#ifdef onTopPopupSurfaceInvisible
    if ((message.GetSurfaceId() == SURFACEID_TOP_POPUP_SURFACE_SYSTEM) && (message.GetState() == SURFACESTATE_INVISIBLE)) { eventId = CIT_EVENT_ID(onTopPopupSurfaceInvisible, 0x3598CF84); return true; }
#endif
#ifdef onTopPopupSurfaceVisible
    if ((message.GetSurfaceId() == SURFACEID_TOP_POPUP_SURFACE_SYSTEM) && (message.GetState() == SURFACESTATE_VISIBLE)) { eventId = CIT_EVENT_ID(onTopPopupSurfaceVisible, 0x984F8ED8); return true; }
#endif
#ifdef onTopPopupSurfaceUnqueued
    if ((message.GetSurfaceId() == SURFACEID_TOP_POPUP_SURFACE_SYSTEM) && (message.GetState() == SURFACESTATE_UNQUEUED)) { eventId = CIT_EVENT_ID(onTopPopupSurfaceUnqueued, 0x912024BE); return true; }
#endif
#ifdef onTopPopupSurfaceQueued
    if ((message.GetSurfaceId() == SURFACEID_TOP_POPUP_SURFACE_SYSTEM) && (message.GetState() == SURFACESTATE_QUEUED)) { eventId = CIT_EVENT_ID(onTopPopupSurfaceQueued, 0xB630DDBD); return true; }
#endif
#ifdef onCenterPopupSurfaceInvisible
    if ((message.GetSurfaceId() == SURFACEID_CENTER_POPUP_SURFACE_SYSTEM) && (message.GetState() == SURFACESTATE_INVISIBLE)) { eventId = CIT_EVENT_ID(onCenterPopupSurfaceInvisible, 0x9BDB722F); return true; }
#endif
#ifdef onCenterPopupSurfaceVisible
    if ((message.GetSurfaceId() == SURFACEID_CENTER_POPUP_SURFACE_SYSTEM) && (message.GetState() == SURFACESTATE_VISIBLE)) { eventId = CIT_EVENT_ID(onCenterPopupSurfaceVisible, 0x23B97E51); return true; }
#endif
#ifdef onCenterPopupSurfaceUnqueued
    if ((message.GetSurfaceId() == SURFACEID_CENTER_POPUP_SURFACE_SYSTEM) && (message.GetState() == SURFACESTATE_UNQUEUED)) { eventId = CIT_EVENT_ID(onCenterPopupSurfaceUnqueued, 0xAA79C7DD); return true; }
#endif
#ifdef onCenterPopupSurfaceQueued
    if ((message.GetSurfaceId() == SURFACEID_CENTER_POPUP_SURFACE_SYSTEM) && (message.GetState() == SURFACESTATE_QUEUED)) { eventId = CIT_EVENT_ID(onCenterPopupSurfaceQueued, 0xFC0D2293); return true; }
#endif
#ifdef onSystemInstallationPopupSurfaceInvisible
    if ((message.GetSurfaceId() == SURFACEID_SYSTEMINSTALLATION_POPUP_SURFACE) && (message.GetState() == SURFACESTATE_INVISIBLE)) { eventId = CIT_EVENT_ID(onSystemInstallationPopupSurfaceInvisible, 0xBCDB58A1); return true; }
#endif
#ifdef onSystemInstallationPopupSurfaceVisible
    if ((message.GetSurfaceId() == SURFACEID_SYSTEMINSTALLATION_POPUP_SURFACE) && (message.GetState() == SURFACESTATE_VISIBLE)) { eventId = CIT_EVENT_ID(onSystemInstallationPopupSurfaceVisible, 0xCDBE0AD4); return true; }
#endif
#ifdef onSystemInstallationPopupSurfaceUnqueued
    if ((message.GetSurfaceId() == SURFACEID_SYSTEMINSTALLATION_POPUP_SURFACE) && (message.GetState() == SURFACESTATE_UNQUEUED)) { eventId = CIT_EVENT_ID(onSystemInstallationPopupSurfaceUnqueued, 0xB798DA5A); return true; }
#endif
#ifdef onSystemInstallationPopupSurfaceQueued
    if ((message.GetSurfaceId() == SURFACEID_SYSTEMINSTALLATION_POPUP_SURFACE) && (message.GetState() == SURFACESTATE_QUEUED)) { eventId = CIT_EVENT_ID(onSystemInstallationPopupSurfaceQueued, 0x5F180209); return true; }
#endif
#ifdef onPopupVisible
    if ((message.GetState() == SURFACESTATE_VISIBLE)) { eventId = CIT_EVENT_ID(onPopupVisible, 0xB78D7AE0); return true; }
#endif
#ifdef onPopupUnqueued
    if ((message.GetState() == SURFACESTATE_UNQUEUED)) { eventId = CIT_EVENT_ID(onPopupUnqueued, 0xDB0D29F4); return true; }
#endif
#ifdef onPopupQueued
    if ((message.GetState() == SURFACESTATE_QUEUED)) { eventId = CIT_EVENT_ID(onPopupQueued, 0xBBE6896C); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSurfaceStateChangedUpdMsg(AppHmi_SystemStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
#ifdef onTopPopupSurfaceInvisible
    if (eventId == onTopPopupSurfaceInvisible) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onTopPopupSurfaceInvisible.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onTopPopupSurfaceVisible
    if (eventId == onTopPopupSurfaceVisible) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onTopPopupSurfaceVisible.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onTopPopupSurfaceUnqueued
    if (eventId == onTopPopupSurfaceUnqueued) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onTopPopupSurfaceUnqueued.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onTopPopupSurfaceQueued
    if (eventId == onTopPopupSurfaceQueued) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onTopPopupSurfaceQueued.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onCenterPopupSurfaceInvisible
    if (eventId == onCenterPopupSurfaceInvisible) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onCenterPopupSurfaceInvisible.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onCenterPopupSurfaceVisible
    if (eventId == onCenterPopupSurfaceVisible) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onCenterPopupSurfaceVisible.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onCenterPopupSurfaceUnqueued
    if (eventId == onCenterPopupSurfaceUnqueued) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onCenterPopupSurfaceUnqueued.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onCenterPopupSurfaceQueued
    if (eventId == onCenterPopupSurfaceQueued) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onCenterPopupSurfaceQueued.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onSystemInstallationPopupSurfaceInvisible
    if (eventId == onSystemInstallationPopupSurfaceInvisible) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onSystemInstallationPopupSurfaceInvisible.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onSystemInstallationPopupSurfaceVisible
    if (eventId == onSystemInstallationPopupSurfaceVisible) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onSystemInstallationPopupSurfaceVisible.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onSystemInstallationPopupSurfaceUnqueued
    if (eventId == onSystemInstallationPopupSurfaceUnqueued) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onSystemInstallationPopupSurfaceUnqueued.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onSystemInstallationPopupSurfaceQueued
    if (eventId == onSystemInstallationPopupSurfaceQueued) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onSystemInstallationPopupSurfaceQueued.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onPopupVisible
    if (eventId == onPopupVisible) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onPopupVisible.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onPopupUnqueued
    if (eventId == onPopupUnqueued) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onPopupUnqueued.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onPopupQueued
    if (eventId == onPopupQueued) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onPopupQueued.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForPopup_Privacy_open(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnPopup_Privacy_open, 0x37BF2FAA);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForPopup_Privacy_open(AppHmi_SystemStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForActivationResMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::Courier::ActivationResMsg const & message = static_cast< ::Courier::ActivationResMsg const &>(aMessage);

#ifdef OnActivationResMsg_Volume_PopUp_Scenes_SwUpdate_Downgrade_1
    if ((message.GetViewId() == ::Courier::ViewId("Volume_PopUp#Scenes#SwUpdate_Downgrade")) && (message.GetSuccess() == 1)) { eventId = CIT_EVENT_ID(OnActivationResMsg_Volume_PopUp_Scenes_SwUpdate_Downgrade_1, 0x434EC498); return true; }
#endif
#ifdef OnActivationResMsg_Volume_PopUp_Scenes_So_VolumeArea_1
    if ((message.GetViewId() == ::Courier::ViewId("Volume_PopUp#Scenes#So_VolumeArea")) && (message.GetSuccess() == 1)) { eventId = CIT_EVENT_ID(OnActivationResMsg_Volume_PopUp_Scenes_So_VolumeArea_1, 0xFA2089CF); return true; }
#endif
#ifdef OnActivationResMsg_SystemSettings_PopupScenes_Pfo_GeneralMsg_Touch_1
    if ((message.GetViewId() == ::Courier::ViewId("SystemSettings#PopupScenes#Pfo_GeneralMsg_Touch")) && (message.GetSuccess() == 1)) { eventId = CIT_EVENT_ID(OnActivationResMsg_SystemSettings_PopupScenes_Pfo_GeneralMsg_Touch_1, 0xDB8EDCBA); return true; }
#endif
#ifdef OnActivationResMsg_AppHmi_System_SoftwareDownload_Pfo_SysSetFactReset_1
    if ((message.GetViewId() == ::Courier::ViewId("AppHmi_System#SoftwareDownload#Pfo_SysSetFactReset")) && (message.GetSuccess() == 1)) { eventId = CIT_EVENT_ID(OnActivationResMsg_AppHmi_System_SoftwareDownload_Pfo_SysSetFactReset_1, 0xB2B486E0); return true; }
#endif
#ifdef OnActivationResMsg_AppHmi_System_SoftwareDownload_Pfo_SysSetFactDefault_1
    if ((message.GetViewId() == ::Courier::ViewId("AppHmi_System#SoftwareDownload#Pfo_SysSetFactDefault")) && (message.GetSuccess() == 1)) { eventId = CIT_EVENT_ID(OnActivationResMsg_AppHmi_System_SoftwareDownload_Pfo_SysSetFactDefault_1, 0x6920FBAB); return true; }
#endif
#ifdef OnActivationResMsg_AppHmi_System_SoftwareDownload_Pfo_SpeedLock_CP_1
    if ((message.GetViewId() == ::Courier::ViewId("AppHmi_System#SoftwareDownload#Pfo_SpeedLock_CP")) && (message.GetSuccess() == 1)) { eventId = CIT_EVENT_ID(OnActivationResMsg_AppHmi_System_SoftwareDownload_Pfo_SpeedLock_CP_1, 0x7F3630A8); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActivationResMsg(AppHmi_SystemStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::Courier::ActivationResMsg const & message = static_cast< ::Courier::ActivationResMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined ev_OnButtonPressMeasurementTypeItem
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define ev_OnButtonPressMeasurementTypeItem 0xffff
#pragma _REMINDER("Using dummy value symbol ev_OnButtonPressMeasurementTypeItem ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol ev_OnButtonPressMeasurementTypeItem -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined ev_OnButtonPressAuxTypeItem
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define ev_OnButtonPressAuxTypeItem 0xffff
#pragma _REMINDER("Using dummy value symbol ev_OnButtonPressAuxTypeItem ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol ev_OnButtonPressAuxTypeItem -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined ev_OnButtonPressGammaMonitorFlipCADropItem
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define ev_OnButtonPressGammaMonitorFlipCADropItem 0xffff
#pragma _REMINDER("Using dummy value symbol ev_OnButtonPressGammaMonitorFlipCADropItem ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol ev_OnButtonPressGammaMonitorFlipCADropItem -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined ev_OnButtonPressGammaLCDOnOffCADropItem
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define ev_OnButtonPressGammaLCDOnOffCADropItem 0xffff
#pragma _REMINDER("Using dummy value symbol ev_OnButtonPressGammaLCDOnOffCADropItem ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol ev_OnButtonPressGammaLCDOnOffCADropItem -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined ev_OnButtonPressDisplayModeItem
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define ev_OnButtonPressDisplayModeItem 0xffff
#pragma _REMINDER("Using dummy value symbol ev_OnButtonPressDisplayModeItem ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol ev_OnButtonPressDisplayModeItem -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined ev_OnButtonPressTimeformatTypeItem
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define ev_OnButtonPressTimeformatTypeItem 0xffff
#pragma _REMINDER("Using dummy value symbol ev_OnButtonPressTimeformatTypeItem ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol ev_OnButtonPressTimeformatTypeItem -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined ev_OnButtonPressGpsClkTimeformatTypeItem
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define ev_OnButtonPressGpsClkTimeformatTypeItem 0xffff
#pragma _REMINDER("Using dummy value symbol ev_OnButtonPressGpsClkTimeformatTypeItem ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol ev_OnButtonPressGpsClkTimeformatTypeItem -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined ev_OnButtonPressGpsClkClockModeTypeItem
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define ev_OnButtonPressGpsClkClockModeTypeItem 0xffff
#pragma _REMINDER("Using dummy value symbol ev_OnButtonPressGpsClkClockModeTypeItem ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol ev_OnButtonPressGpsClkClockModeTypeItem -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined ev_OnButtonPressClockFormatTypeItem
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define ev_OnButtonPressClockFormatTypeItem 0xffff
#pragma _REMINDER("Using dummy value symbol ev_OnButtonPressClockFormatTypeItem ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol ev_OnButtonPressClockFormatTypeItem -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined ev_OnButtonPressClockTimeZoneItem
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define ev_OnButtonPressClockTimeZoneItem 0xffff
#pragma _REMINDER("Using dummy value symbol ev_OnButtonPressClockTimeZoneItem ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol ev_OnButtonPressClockTimeZoneItem -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined evSubSystem_OnButtonPressDTCCodeStatusListTypeItem
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define evSubSystem_OnButtonPressDTCCodeStatusListTypeItem 0xffff
#pragma _REMINDER("Using dummy value symbol evSubSystem_OnButtonPressDTCCodeStatusListTypeItem ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol evSubSystem_OnButtonPressDTCCodeStatusListTypeItem -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined ev_OnButtonPressOnSoftwareUpdateHistoryListItem
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define ev_OnButtonPressOnSoftwareUpdateHistoryListItem 0xffff
#pragma _REMINDER("Using dummy value symbol ev_OnButtonPressOnSoftwareUpdateHistoryListItem ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol ev_OnButtonPressOnSoftwareUpdateHistoryListItem -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined ev_OnButtonPressGpsClkDateFmtPreset
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define ev_OnButtonPressGpsClkDateFmtPreset 0xffff
#pragma _REMINDER("Using dummy value symbol ev_OnButtonPressGpsClkDateFmtPreset ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol ev_OnButtonPressGpsClkDateFmtPreset -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForButtonListItemUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::ButtonListItemUpdMsg const & message = static_cast< ::ButtonListItemUpdMsg const &>(aMessage);

#ifdef ev_RVC_Brightness_touch
    if ((message.GetListId() == LIST_ID_RVC_LIST) && (message.GetHdl() == BRIGHTNESS_SETTING) && (message.GetReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_RVC_Brightness_touch, 0x108466DC); return true; }
#endif
#ifdef ev_OnButtonPressClkDateFmtPreset
    if ((message.GetListId() == LIST_ID_SYSTEM_CLOCK_LIST) && (message.GetHdl() == DateFmtRBtnClk) && (message.GetReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_OnButtonPressClkDateFmtPreset, 0x07167C75); return true; }
#endif
#ifdef ev_OnButtonPressGammaMainListSwivelCalibration
    if ((message.GetListId() == LIST_ID_SYSTEM_SO_OEM_MENU) && (message.GetHdl() == Swivel_Calibration) && (message.GetReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_OnButtonPressGammaMainListSwivelCalibration, 0xBE236FF7); return true; }
#endif
#ifdef ev_OnButtonPressPrivateMode
    if ((message.GetListId() == LIST_ID_SYSTEM_AUDIO_LIST) && (message.GetHdl() == PrivateMode) && (message.GetReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_OnButtonPressPrivateMode, 0xD9448639); return true; }
#endif
#ifdef ev_OnButtonPress4mCabinA2OSS
    if ((message.GetListId() == LIST_ID_CABIN_A_MAIN_LIST) && (message.GetHdl() == OPEN_SOURCE_SOFTWARE_CA) && (message.GetReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_OnButtonPress4mCabinA2OSS, 0xF7C2F6EB); return true; }
#endif
#ifdef ev_OnButtonPress4mCabinA2VideoMixSource
    if ((message.GetListId() == LIST_ID_CABIN_A_MAIN_LIST) && (message.GetHdl() == VIDEOMIXSOURCE_CA) && (message.GetReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_OnButtonPress4mCabinA2VideoMixSource, 0xC5039804); return true; }
#endif
#ifdef ev_OnButtonPress4mCabinA2Glass
    if ((message.GetListId() == LIST_ID_CABIN_A_MAIN_LIST) && (message.GetHdl() == GLASS_SETTING_CA) && (message.GetReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_OnButtonPress4mCabinA2Glass, 0x185FDB18); return true; }
#endif
#ifdef ev_OnButtonPressSpeedLockVol
    if ((message.GetListId() == LIST_ID_SYSTEM_AUDIO_LIST) && (message.GetHdl() == SpeedLockDepVol) && (message.GetReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_OnButtonPressSpeedLockVol, 0xC6A3829F); return true; }
#endif
#ifdef ev_OnButtonPressAudioEquilizerPreset
    if ((message.GetListId() == LIST_ID_SYSTEM_AUDIO_LIST) && (message.GetHdl() == EqlPrset) && (message.GetReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_OnButtonPressAudioEquilizerPreset, 0xE1CDB3C3); return true; }
#endif
#ifdef ev_OnButtonPressLanguageListTypeItem
    if ((message.GetListId() == LIST_ID_SYSTEM_MAIN_LIST) && (message.GetHdl() == LANGUAGE) && (message.GetReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_OnButtonPressLanguageListTypeItem, 0x1119C6A4); return true; }
#endif
#ifdef ev_OnButtonPressSoundListTypeItem
    if ((message.GetListId() == LIST_ID_SYSTEM_MAIN_LIST) && (message.GetHdl() == SOUND_SETTING) && (message.GetReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_OnButtonPressSoundListTypeItem, 0xD1EEE4AE); return true; }
#endif
#ifdef ev_RVC_Contrast_touch
    if ((message.GetListId() == LIST_ID_RVC_LIST) && (message.GetHdl() == CONTRAST_SETTING) && (message.GetReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_RVC_Contrast_touch, 0x5F236A4F); return true; }
#endif
#ifdef ev_OnButtonPressCAMain2AudioTypeItem
    if ((message.GetListId() == LIST_ID_CABIN_A_MAIN_LIST) && (message.GetHdl() == SOUND_SETTING_CA) && (message.GetReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_OnButtonPressCAMain2AudioTypeItem, 0x06FA5BA0); return true; }
#endif
#ifdef ev_OnButtonPressGpsClkBtnFwdPreset
    if ((message.GetListId() == LIST_ID_SYSTEM_MAIN_LIST) && (message.GetHdl() == CLOCK) && (message.GetReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_OnButtonPressGpsClkBtnFwdPreset, 0x38A40997); return true; }
#endif
#ifdef ev_OnButtonPressDisplayTypeItem
    if ((message.GetListId() == LIST_ID_SYSTEM_MAIN_LIST) && (message.GetHdl() == DISPLAY_SETTING) && (message.GetReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_OnButtonPressDisplayTypeItem, 0xF38C5993); return true; }
#endif
#ifdef ev_OnButtonPressSystemInstallationListTypeItem
    if ((message.GetListId() == LIST_ID_SYSTEM_MAIN_LIST) && (message.GetReaction() == enRelease) && (message.GetHdl() == SYSTEM_INSTALLATION)) { eventId = CIT_EVENT_ID(ev_OnButtonPressSystemInstallationListTypeItem, 0x9FD2F3DB); return true; }
#endif
#ifdef ev_OnButtonPressClockTypeItem
    if ((message.GetListId() == LIST_ID_SYSTEM_MAIN_LIST) && (message.GetHdl() == CLOCK) && (message.GetReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_OnButtonPressClockTypeItem, 0x302618BC); return true; }
#endif
#ifdef ev_OnButtonPressConfigVersionItem
    if ((message.GetListId() == LIST_ID_SYSTEM_MAIN_LIST) && (message.GetHdl() == CONFIGURATION_VERSION) && (message.GetReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_OnButtonPressConfigVersionItem, 0xF4B21FBE); return true; }
#endif
#ifdef ev_OnButtonPressAuxTypeItem
    if ((message.GetListId() == LIST_ID_SYSTEM_AUDIO_AUXLEVEL_LIST) && (message.GetReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_OnButtonPressAuxTypeItem, 0x20FE0FA2); return true; }
#endif
#ifdef ev_OnButtonPressGammaMonitorFlipCADropItem
    if ((message.GetListId() == LIST_ID_CABIN_A_GLASS_MONITOR_FLIP_PANEL_DD_LIST) && (message.GetReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_OnButtonPressGammaMonitorFlipCADropItem, 0x69F4447F); return true; }
#endif
#ifdef ev_OnButtonPressGammaLCDOnOffCADropItem
    if ((message.GetListId() == LIST_ID_CABIN_A_GAMMA_LCD_PANEL_LIST) && (message.GetReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_OnButtonPressGammaLCDOnOffCADropItem, 0xDE9A8E1C); return true; }
#endif
#ifdef ev_OnButtonPressDisplayModeItem
    if ((message.GetListId() == LIST_ID_SYSTEM_DISPLAYSETTING_DAYNIGHTAUTOMODE_LIST) && (message.GetReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_OnButtonPressDisplayModeItem, 0x1128B30A); return true; }
#endif
#ifdef ev_OnButtonPressTimeformatTypeItem
    if ((message.GetListId() == LIST_ID_SYSTEM_CLOCK_TIMEFORMAT_LIST) && (message.GetReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_OnButtonPressTimeformatTypeItem, 0x0CE1EA59); return true; }
#endif
#ifdef ev_OnButtonPressGpsClkTimeformatTypeItem
    if ((message.GetListId() == LIST_ID_SYSTEM_GPS_CLOCK_TIMEFORMAT_LIST) && (message.GetReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_OnButtonPressGpsClkTimeformatTypeItem, 0x5CA5AAD0); return true; }
#endif
#ifdef ev_OnButtonPressOnSoftwareUpdateHistoryListItem
    if ((message.GetListId() == LIST_ID_SW_DOWNLOAD_HISTORY) && (message.GetReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_OnButtonPressOnSoftwareUpdateHistoryListItem, 0xC33BEC95); return true; }
#endif
#ifdef evSubSystem_OnButtonPressDTCCodeStatusListTypeItem
    if ((message.GetListId() == LIST_ID_SYSTEM_SWVERSION_CIS_LIST) && (message.GetReaction() == enRelease)) { eventId = CIT_EVENT_ID(evSubSystem_OnButtonPressDTCCodeStatusListTypeItem, 0xAFC6C4B4); return true; }
#endif
#ifdef ev_OnButtonPressClockFormatTypeItem
    if ((message.GetListId() == LIST_ID_SYSTEM_CLOCK_CLOCKFORMAT_LIST) && (message.GetReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_OnButtonPressClockFormatTypeItem, 0x38A97D86); return true; }
#endif
#ifdef ev_OnButtonPressClockTimeZoneItem
    if ((message.GetListId() == LIST_ID_SETTINGS_SYSTEM_CLOCK_TIMEZONE) && (message.GetReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_OnButtonPressClockTimeZoneItem, 0x3780BE62); return true; }
#endif
#ifdef ev_OnButtonPressGpsClkDateFmtPreset
    if ((message.GetListId() == LIST_ID_SYSTEM_GPS_CLOCK_LIST) && (message.GetReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_OnButtonPressGpsClkDateFmtPreset, 0x199D766D); return true; }
#endif
#ifdef ev_OnButtonPressGpsClkClockModeTypeItem
    if ((message.GetListId() == LIST_ID_SYSTEM_GPS_CLOCK_CLOCKFORMAT_LIST) && (message.GetReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_OnButtonPressGpsClkClockModeTypeItem, 0x53187AA3); return true; }
#endif
#ifdef ev_OnButtonPressMeasurementTypeItem
    if ((message.GetListId() == LIST_ID_SYSTEM_MEASUREMENTUNIT_LIST) && (message.GetReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_OnButtonPressMeasurementTypeItem, 0xD66C096D); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForButtonListItemUpdMsg(AppHmi_SystemStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::ButtonListItemUpdMsg const & message = static_cast< ::ButtonListItemUpdMsg const &>(aMessage);
#ifdef ev_OnButtonPressMeasurementTypeItem
    if (eventId == ev_OnButtonPressMeasurementTypeItem) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetHdl()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_ev_OnButtonPressMeasurementTypeItem.Hdl = message.GetHdl();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef ev_OnButtonPressAuxTypeItem
    if (eventId == ev_OnButtonPressAuxTypeItem) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetHdl()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_ev_OnButtonPressAuxTypeItem.Hdl = message.GetHdl();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef ev_OnButtonPressGammaMonitorFlipCADropItem
    if (eventId == ev_OnButtonPressGammaMonitorFlipCADropItem) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetHdl()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_ev_OnButtonPressGammaMonitorFlipCADropItem.Hdl = message.GetHdl();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef ev_OnButtonPressGammaLCDOnOffCADropItem
    if (eventId == ev_OnButtonPressGammaLCDOnOffCADropItem) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetHdl()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_ev_OnButtonPressGammaLCDOnOffCADropItem.Hdl = message.GetHdl();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef ev_OnButtonPressDisplayModeItem
    if (eventId == ev_OnButtonPressDisplayModeItem) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetHdl()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_ev_OnButtonPressDisplayModeItem.Hdl = message.GetHdl();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef ev_OnButtonPressTimeformatTypeItem
    if (eventId == ev_OnButtonPressTimeformatTypeItem) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetHdl()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_ev_OnButtonPressTimeformatTypeItem.Hdl = message.GetHdl();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef ev_OnButtonPressGpsClkTimeformatTypeItem
    if (eventId == ev_OnButtonPressGpsClkTimeformatTypeItem) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetHdl()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_ev_OnButtonPressGpsClkTimeformatTypeItem.Hdl = message.GetHdl();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef ev_OnButtonPressGpsClkClockModeTypeItem
    if (eventId == ev_OnButtonPressGpsClkClockModeTypeItem) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetHdl()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_ev_OnButtonPressGpsClkClockModeTypeItem.Hdl = message.GetHdl();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef ev_OnButtonPressClockFormatTypeItem
    if (eventId == ev_OnButtonPressClockFormatTypeItem) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetHdl()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_ev_OnButtonPressClockFormatTypeItem.Hdl = message.GetHdl();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef ev_OnButtonPressClockTimeZoneItem
    if (eventId == ev_OnButtonPressClockTimeZoneItem) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetHdl()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_ev_OnButtonPressClockTimeZoneItem.Hdl = message.GetHdl();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef evSubSystem_OnButtonPressDTCCodeStatusListTypeItem
    if (eventId == evSubSystem_OnButtonPressDTCCodeStatusListTypeItem) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetHdl()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_evSubSystem_OnButtonPressDTCCodeStatusListTypeItem.Hdl = message.GetHdl();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef ev_OnButtonPressOnSoftwareUpdateHistoryListItem
    if (eventId == ev_OnButtonPressOnSoftwareUpdateHistoryListItem) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetHdl()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_ev_OnButtonPressOnSoftwareUpdateHistoryListItem.Hdl = message.GetHdl();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef ev_OnButtonPressGpsClkDateFmtPreset
    if (eventId == ev_OnButtonPressGpsClkDateFmtPreset) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetHdl()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_ev_OnButtonPressGpsClkDateFmtPreset.Hdl = message.GetHdl();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForStartSoftwareUpdatePressMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_OnButtonPressStartSoftwareUpdateItem, 0x2EE8CAD7);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForStartSoftwareUpdatePressMsg(AppHmi_SystemStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForStartSoftwareUpdateLongPressMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_OnButtonLongPressStartSoftwareUpdateItem, 0x979D78E5);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForStartSoftwareUpdateLongPressMsg(AppHmi_SystemStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForStartSoftwareUpdateHistoryMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_OnButtonPressSoftwareUpdateHistoryItem, 0x4722E73F);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForStartSoftwareUpdateHistoryMsg(AppHmi_SystemStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForOEMSettingMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_OnButtonPressOEMSettingItem, 0xDA6C7FD4);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForOEMSettingMsg(AppHmi_SystemStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForOEMMenuMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_EnterOEMMenu, 0x4362F640);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForOEMMenuMsg(AppHmi_SystemStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForOpenSourceSoftwareMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_OnButtonPressSoSettingSoOssPress, 0x6FD95322);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForOpenSourceSoftwareMsg(AppHmi_SystemStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForSoftwareVersionCISMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_OnButtonPressSoSettingSoSWVersionCISPress, 0x795C2850);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSoftwareVersionCISMsg(AppHmi_SystemStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForResetFactorySettingsMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_OnButtonPressresetfactorysetting, 0x5CBA30B8);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForResetFactorySettingsMsg(AppHmi_SystemStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined OnClonedHKStatusMsg
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define OnClonedHKStatusMsg 0xffff
#pragma _REMINDER("Using dummy value symbol OnClonedHKStatusMsg ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol OnClonedHKStatusMsg -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForClonedHKStatusMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnClonedHKStatusMsg, 0x8E3BDF7A);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForClonedHKStatusMsg(AppHmi_SystemStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::ClonedHKStatusMsg const & message = static_cast< ::ClonedHKStatusMsg const &>(aMessage);
#ifdef OnClonedHKStatusMsg
    if (eventId == OnClonedHKStatusMsg) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetHKCode(), message.GetHKState()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_OnClonedHKStatusMsg.HKCode = message.GetHKCode();
        onClickParam.VSEPS_OnClonedHKStatusMsg.HKState = message.GetHKState();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForSpeedLockMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_OnButtonPressSpeedLock, 0x79BEBD42);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSpeedLockMsg(AppHmi_SystemStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForDisplayclock(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnDisplayclock, 0x493BE7CB);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForDisplayclock(AppHmi_SystemStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForMediaEntry2AudioSetting_1(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnMediaEntry2AudioSetting_1, 0x7210B8B9);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForMediaEntry2AudioSetting_1(AppHmi_SystemStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForGotoMainSoundSettings(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnGotoMainSoundSettings, 0xB23A5997);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForGotoMainSoundSettings(AppHmi_SystemStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForGotoMicSettings(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnGotoMicSettings, 0x96E07D66);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForGotoMicSettings(AppHmi_SystemStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForGotoMainCabinASettings(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnGotoMainCabinASettings, 0xD74AE057);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForGotoMainCabinASettings(AppHmi_SystemStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForDisplayAudioSetting4Tuner(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnDisplayAudioSetting4Tuner, 0x59D7EB51);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForDisplayAudioSetting4Tuner(AppHmi_SystemStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForDisplayAudioSetting4Media(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnDisplayAudioSetting4Media, 0x8326E048);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForDisplayAudioSetting4Media(AppHmi_SystemStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForDisplayAudioSetting4Volume(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnDisplayAudioSetting4Volume, 0xD9B8A15D);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForDisplayAudioSetting4Volume(AppHmi_SystemStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForReleaseDocPropertyUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::ReleaseDocPropertyUpdMsg const & message = static_cast< ::ReleaseDocPropertyUpdMsg const &>(aMessage);

#ifdef ev_onNewUSBStickFound
    if ((message.GetDownloadType() == 0)) { eventId = CIT_EVENT_ID(ev_onNewUSBStickFound, 0x372319B8); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForReleaseDocPropertyUpdMsg(AppHmi_SystemStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::ReleaseDocPropertyUpdMsg const & message = static_cast< ::ReleaseDocPropertyUpdMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForUSBValidationCompleteMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_onUSBStickValidationComplete, 0xC4A893F7);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForUSBValidationCompleteMsg(AppHmi_SystemStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForUSBStickRemovedUpdMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_onUSBStickRemoved, 0x4064030B);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForUSBStickRemovedUpdMsg(AppHmi_SystemStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForSWCompactibilityUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::SWCompactibilityUpdMsg const & message = static_cast< ::SWCompactibilityUpdMsg const &>(aMessage);

#ifdef ev_onSWSameVersion
    if ((message.GetSWCompType() == 1)) { eventId = CIT_EVENT_ID(ev_onSWSameVersion, 0xE71FD5BB); return true; }
#endif
#ifdef ev_onSWDowngrade
    if ((message.GetSWCompType() == 2)) { eventId = CIT_EVENT_ID(ev_onSWDowngrade, 0x2CDB1E82); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSWCompactibilityUpdMsg(AppHmi_SystemStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::SWCompactibilityUpdMsg const & message = static_cast< ::SWCompactibilityUpdMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForIncompatibleUSBUpdMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_onIncompatiblestickfound, 0xFF37F05A);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForIncompatibleUSBUpdMsg(AppHmi_SystemStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForIncompatibleUsbFormatMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_onIncompatibleUsbFormat, 0x863ADC76);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForIncompatibleUsbFormatMsg(AppHmi_SystemStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForCustomerModeFilterUpdMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_onCustomerModeFilterUpdated, 0x5437F3B8);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForCustomerModeFilterUpdMsg(AppHmi_SystemStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForEnggModeFilterUpdMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_onEnggModeFilterUpdated, 0x82B2A2F3);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForEnggModeFilterUpdMsg(AppHmi_SystemStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined ev_onTimeOutOfMISUpdate
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define ev_onTimeOutOfMISUpdate 0xffff
#pragma _REMINDER("Using dummy value symbol ev_onTimeOutOfMISUpdate ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol ev_onTimeOutOfMISUpdate -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onPopupTimerExpiry
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onPopupTimerExpiry 0xffff
#pragma _REMINDER("Using dummy value symbol onPopupTimerExpiry ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onPopupTimerExpiry -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForExpiredPopupTimerResMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_onTimeOutOfMISUpdate, 0x0F2DADC1);
    return true;
    eventId = CIT_EVENT_ID(onPopupTimerExpiry, 0xF3C96D17);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForExpiredPopupTimerResMsg(AppHmi_SystemStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::ExpiredPopupTimerResMsg const & message = static_cast< ::ExpiredPopupTimerResMsg const &>(aMessage);
#ifdef ev_onTimeOutOfMISUpdate
    if (eventId == ev_onTimeOutOfMISUpdate) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetViewId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_ev_onTimeOutOfMISUpdate.ViewId = message.GetViewId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onPopupTimerExpiry
    if (eventId == onPopupTimerExpiry) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetViewId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onPopupTimerExpiry.ViewId = message.GetViewId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForOnReceivingStageOneEstTimeMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_OnReceivingStageOneEstTime, 0x468BB490);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForOnReceivingStageOneEstTimeMsg(AppHmi_SystemStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForSWUpdateStageOneCompleteMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_onPopupTimedout, 0x2559D537);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSWUpdateStageOneCompleteMsg(AppHmi_SystemStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined ev_onMIS_ResultExtraction
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define ev_onMIS_ResultExtraction 0xffff
#pragma _REMINDER("Using dummy value symbol ev_onMIS_ResultExtraction ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol ev_onMIS_ResultExtraction -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForSWupdateResultNotificationMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_onMIS_ResultExtraction, 0xEFA22F23);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSWupdateResultNotificationMsg(AppHmi_SystemStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::SWupdateResultNotificationMsg const & message = static_cast< ::SWupdateResultNotificationMsg const &>(aMessage);
#ifdef ev_onMIS_ResultExtraction
    if (eventId == ev_onMIS_ResultExtraction) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetResultPopupType()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_ev_onMIS_ResultExtraction.ResultPopupType = message.GetResultPopupType();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForExitOnSWDLFailureMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_OnMISStageOneFailed, 0xE656DF72);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForExitOnSWDLFailureMsg(AppHmi_SystemStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForSwitchToSWDLMISprogressBarSceneMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_ContextSwitchToMISStageOne, 0x92BC70E4);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSwitchToSWDLMISprogressBarSceneMsg(AppHmi_SystemStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForOnXMLAvailabilityExitBusyWaitMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_OnXMLAvailabilityExitBusyWaitMsg, 0x22B6C7BA);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForOnXMLAvailabilityExitBusyWaitMsg(AppHmi_SystemStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForActivate_Popup_RenderingDiagnosis(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnActivate_Popup_RenderingDiagnosis, 0x209E60F0);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActivate_Popup_RenderingDiagnosis(AppHmi_SystemStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForHide_Popup_RenderingDiagnosis(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnHide_Popup_RenderingDiagnosis, 0x0A73EC4D);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForHide_Popup_RenderingDiagnosis(AppHmi_SystemStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForActivateSWDowngradePopup(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnActivateSWDowngradePopup, 0x3A44654A);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActivateSWDowngradePopup(AppHmi_SystemStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForDeactivateSWDowngradePopup(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnDeactivateSWDowngradePopup, 0x387A46A9);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForDeactivateSWDowngradePopup(AppHmi_SystemStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForActivateSpeedLock_CP_Popup(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnActivateSpeedLock_CP_Popup, 0xEC31A0F7);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActivateSpeedLock_CP_Popup(AppHmi_SystemStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForSceneTranstoEP(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnSceneTranstoEP, 0x3BDA2260);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSceneTranstoEP(AppHmi_SystemStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForSceneTranstoSpeedDepVol(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnSceneTranstoSpeedDepVol, 0x9C324A48);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSceneTranstoSpeedDepVol(AppHmi_SystemStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForSceneTranstoAS(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnSceneTranstoAS, 0xD59CD2C0);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSceneTranstoAS(AppHmi_SystemStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForSceneTranstoDisplay(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnSceneTranstoDisplay, 0x9D4A461F);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSceneTranstoDisplay(AppHmi_SystemStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForSceneTranstoClock(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnSceneTranstoClock, 0x28FD82D6);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSceneTranstoClock(AppHmi_SystemStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForSceneTranstoLanguage(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnSceneTranstoLanguage, 0xFB10DC7A);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSceneTranstoLanguage(AppHmi_SystemStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForSceneTranstoSecurity(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnSceneTranstoSecurity, 0x3BA9193E);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSceneTranstoSecurity(AppHmi_SystemStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForSceneTranstoFactory(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnSceneTranstoFactory, 0x806C1FE9);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSceneTranstoFactory(AppHmi_SystemStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForSceneTranstoOSS(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnSceneTranstoOSS, 0xA7236AAD);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSceneTranstoOSS(AppHmi_SystemStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForActivate_PopUp(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnActivate_PopUp, 0x73294DEB);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActivate_PopUp(AppHmi_SystemStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForTransitionIndMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::Courier::TransitionIndMsg const & message = static_cast< ::Courier::TransitionIndMsg const &>(aMessage);

#ifdef OnNextLevelTransitionFininshed_SysSettingsToDisplaySettings
    if ((message.GetTransitionId() == ::Courier::ItemId("NextLevelTransition")) && (message.GetFirstViewId() == ::Courier::ViewId("SystemSettings#SysSettingsScenes#SO_SysSettings")) && (message.GetSecondViewId() == ::Courier::ViewId("DisplaySettings#Scenes#SO_DS")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnNextLevelTransitionFininshed_SysSettingsToDisplaySettings, 0x12666775); return true; }
#endif
#ifdef OnNextLevelTransitionFininshed_SysSettingsToClockSettings
    if ((message.GetTransitionId() == ::Courier::ItemId("NextLevelTransition")) && (message.GetFirstViewId() == ::Courier::ViewId("SystemSettings#SysSettingsScenes#SO_SysSettings")) && (message.GetSecondViewId() == ::Courier::ViewId("ClockSetting#Scenes#SO_CS_GPS")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnNextLevelTransitionFininshed_SysSettingsToClockSettings, 0xB2076462); return true; }
#endif
#ifdef OnPreviousLevelTransitionFinished_DateFormatCNToManual
    if ((message.GetTransitionId() == ::Courier::ItemId("PreviousLevelTransition")) && (message.GetFirstViewId() == ::Courier::ViewId("ClockSetting#Scenes#SO_CS_DateFmtCN")) && (message.GetSecondViewId() == ::Courier::ViewId("ClockSetting#Scenes#SO_CS_Manual")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnPreviousLevelTransitionFinished_DateFormatCNToManual, 0xF3E112A8); return true; }
#endif
#ifdef OnPreviousLevelTransitionFinished_DateFormatCNToGPS
    if ((message.GetTransitionId() == ::Courier::ItemId("PreviousLevelTransition")) && (message.GetFirstViewId() == ::Courier::ViewId("ClockSetting#Scenes#SO_CS_DateFmtCN")) && (message.GetSecondViewId() == ::Courier::ViewId("ClockSetting#Scenes#SO_CS_GPS")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnPreviousLevelTransitionFinished_DateFormatCNToGPS, 0x764A3094); return true; }
#endif
#ifdef OnPreviousLevelTransitionFinished_DateFormatEUToManual
    if ((message.GetTransitionId() == ::Courier::ItemId("PreviousLevelTransition")) && (message.GetFirstViewId() == ::Courier::ViewId("ClockSetting#Scenes#SO_CS_DateFmtEU")) && (message.GetSecondViewId() == ::Courier::ViewId("ClockSetting#Scenes#SO_CS_Manual")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnPreviousLevelTransitionFinished_DateFormatEUToManual, 0x97106018); return true; }
#endif
#ifdef OnPreviousLevelTransitionFinished_SpeedDepVolTOSetting
    if ((message.GetTransitionId() == ::Courier::ItemId("PreviousLevelTransition")) && (message.GetFirstViewId() == ::Courier::ViewId("AudioSetting#Scenes#SO_AS_SpeedDepVol")) && (message.GetSecondViewId() == ::Courier::ViewId("SystemSettings#SysSettingsScenes#SO_SysSettings")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnPreviousLevelTransitionFinished_SpeedDepVolTOSetting, 0xF56C2662); return true; }
#endif
#ifdef OnPreviousLevelTransitionFinished_EqlPresetTOSetting
    if ((message.GetTransitionId() == ::Courier::ItemId("PreviousLevelTransition")) && (message.GetFirstViewId() == ::Courier::ViewId("AudioSetting#Scenes#SO_AS_EqlPreset")) && (message.GetSecondViewId() == ::Courier::ViewId("SystemSettings#SysSettingsScenes#SO_SysSettings")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnPreviousLevelTransitionFinished_EqlPresetTOSetting, 0x2CA8F08B); return true; }
#endif
#ifdef OnNextLevelTransitionFininshed_ManualToDateFormatCN
    if ((message.GetTransitionId() == ::Courier::ItemId("NextLevelTransition")) && (message.GetFirstViewId() == ::Courier::ViewId("ClockSetting#Scenes#SO_CS_Manual")) && (message.GetSecondViewId() == ::Courier::ViewId("ClockSetting#Scenes#SO_CS_DateFmtCN")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnNextLevelTransitionFininshed_ManualToDateFormatCN, 0x4EC1CE6A); return true; }
#endif
#ifdef OnPreviousLevelTransitionFinished_DateFormatEUToGPS
    if ((message.GetTransitionId() == ::Courier::ItemId("PreviousLevelTransition")) && (message.GetFirstViewId() == ::Courier::ViewId("ClockSetting#Scenes#SO_CS_DateFmtEU")) && (message.GetSecondViewId() == ::Courier::ViewId("ClockSetting#Scenes#SO_CS_GPS")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnPreviousLevelTransitionFinished_DateFormatEUToGPS, 0x4BA1CA0F); return true; }
#endif
#ifdef OnNextLevelTransitionFininshed_GPSToTimeZone
    if ((message.GetTransitionId() == ::Courier::ItemId("NextLevelTransition")) && (message.GetFirstViewId() == ::Courier::ViewId("ClockSetting#Scenes#SO_CS_GPS")) && (message.GetSecondViewId() == ::Courier::ViewId("ClockSetting#Scenes#SO_TimeZone")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnNextLevelTransitionFininshed_GPSToTimeZone, 0xD6E837E0); return true; }
#endif
#ifdef OnNextLevelTransitionFininshed_GPSToDateFormatCN
    if ((message.GetTransitionId() == ::Courier::ItemId("NextLevelTransition")) && (message.GetFirstViewId() == ::Courier::ViewId("ClockSetting#Scenes#SO_CS_GPS")) && (message.GetSecondViewId() == ::Courier::ViewId("ClockSetting#Scenes#SO_CS_DateFmtCN")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnNextLevelTransitionFininshed_GPSToDateFormatCN, 0x40E8223D); return true; }
#endif
#ifdef OnNextLevelTransitionFininshed_GPSToDateFormatEU
    if ((message.GetTransitionId() == ::Courier::ItemId("NextLevelTransition")) && (message.GetFirstViewId() == ::Courier::ViewId("ClockSetting#Scenes#SO_CS_GPS")) && (message.GetSecondViewId() == ::Courier::ViewId("ClockSetting#Scenes#SO_CS_DateFmtEU")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnNextLevelTransitionFininshed_GPSToDateFormatEU, 0x76078ED7); return true; }
#endif
#ifdef OnNextLevelTransitionFininshed_SysSettingsToLanguage_EU
    if ((message.GetTransitionId() == ::Courier::ItemId("NextLevelTransition")) && (message.GetFirstViewId() == ::Courier::ViewId("SystemSettings#SysSettingsScenes#SO_SysSettings")) && (message.GetSecondViewId() == ::Courier::ViewId("SystemSettings#SysSettingsScenes#SO_LS_EU")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnNextLevelTransitionFininshed_SysSettingsToLanguage_EU, 0x73BA716D); return true; }
#endif
#ifdef OnNextLevelTransitionFininshed_SysSettingsToLanguage_CN
    if ((message.GetTransitionId() == ::Courier::ItemId("NextLevelTransition")) && (message.GetFirstViewId() == ::Courier::ViewId("SystemSettings#SysSettingsScenes#SO_SysSettings")) && (message.GetSecondViewId() == ::Courier::ViewId("SystemSettings#SysSettingsScenes#SO_LS_CN")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnNextLevelTransitionFininshed_SysSettingsToLanguage_CN, 0x6A475C4B); return true; }
#endif
#ifdef OnNextLevelTransitionFininshed_SysSettingsToLanguageSettings
    if ((message.GetTransitionId() == ::Courier::ItemId("NextLevelTransition")) && (message.GetFirstViewId() == ::Courier::ViewId("SystemSettings#SysSettingsScenes#SO_SysSettings")) && (message.GetSecondViewId() == ::Courier::ViewId("SystemSettings#SysSettingsScenes#SO_LS_GEX")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnNextLevelTransitionFininshed_SysSettingsToLanguageSettings, 0x1EBC2C84); return true; }
#endif
#ifdef OnNextLevelTransitionFininshed_SysSettingsToAudioSettings
    if ((message.GetTransitionId() == ::Courier::ItemId("NextLevelTransition")) && (message.GetFirstViewId() == ::Courier::ViewId("SystemSettings#SysSettingsScenes#SO_SysSettings")) && (message.GetSecondViewId() == ::Courier::ViewId("AudioSetting#Scenes#SO_AS")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnNextLevelTransitionFininshed_SysSettingsToAudioSettings, 0x251E0E34); return true; }
#endif
#ifdef OnNextLevelTransitionFininshed_ManualToDateFormatEU
    if ((message.GetTransitionId() == ::Courier::ItemId("NextLevelTransition")) && (message.GetFirstViewId() == ::Courier::ViewId("ClockSetting#Scenes#SO_CS_Manual")) && (message.GetSecondViewId() == ::Courier::ViewId("ClockSetting#Scenes#SO_CS_DateFmtEU")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnNextLevelTransitionFininshed_ManualToDateFormatEU, 0x286F8D6E); return true; }
#endif
#ifdef OnFadeAnimationFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("FadeTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnFadeAnimationFinished, 0xE9A6D56C); return true; }
#endif
#ifdef OnZoomOutFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("ZoomOutTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnZoomOutFinished, 0xF84B3BD1); return true; }
#endif
#ifdef OnZoomInFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("ZoomInTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnZoomInFinished, 0xFBEEA58F); return true; }
#endif
#ifdef OnNextLevelTransitionFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("NextLevelTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnNextLevelTransitionFinished, 0xE7DCE080); return true; }
#endif
#ifdef OnPageFlipBackFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("PageFlipBackTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnPageFlipBackFinished, 0x74F534EE); return true; }
#endif
#ifdef OnPreviousLevelTransitionFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("PreviousLevelTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnPreviousLevelTransitionFinished, 0x26C30D04); return true; }
#endif
#ifdef OnDualViewLeftTransitionFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("DualViewLeftTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnDualViewLeftTransitionFinished, 0x403A65A4); return true; }
#endif
#ifdef OnPageFlipFrontFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("PageFlipFrontTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnPageFlipFrontFinished, 0x437D9EFE); return true; }
#endif
#ifdef OnDualViewRightTransitionFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("DualViewRightTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnDualViewRightTransitionFinished, 0x50B4DCCA); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForTransitionIndMsg(AppHmi_SystemStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::Courier::TransitionIndMsg const & message = static_cast< ::Courier::TransitionIndMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForPopup_Reset_System(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnPopup_Reset_System, 0xE87C955E);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForPopup_Reset_System(AppHmi_SystemStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onEncoderStatusChanged_RIGHT_ENC
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onEncoderStatusChanged_RIGHT_ENC 0xffff
#pragma _REMINDER("Using dummy value symbol onEncoderStatusChanged_RIGHT_ENC ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onEncoderStatusChanged_RIGHT_ENC -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForEncoderStatusChangedUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::EncoderStatusChangedUpdMsg const & message = static_cast< ::EncoderStatusChangedUpdMsg const &>(aMessage);

#ifdef onEncoderStatusChanged_RIGHT_ENC
    if ((message.GetEncCode() == ENCCODE_RIGHT_ENCODER)) { eventId = CIT_EVENT_ID(onEncoderStatusChanged_RIGHT_ENC, 0x67E5D82B); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForEncoderStatusChangedUpdMsg(AppHmi_SystemStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::EncoderStatusChangedUpdMsg const & message = static_cast< ::EncoderStatusChangedUpdMsg const &>(aMessage);
#ifdef onEncoderStatusChanged_RIGHT_ENC
    if (eventId == onEncoderStatusChanged_RIGHT_ENC) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetEncSteps()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onEncoderStatusChanged_RIGHT_ENC.EncSteps = message.GetEncSteps();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForHKStatusChangedUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::HKStatusChangedUpdMsg const & message = static_cast< ::HKStatusChangedUpdMsg const &>(aMessage);

#ifdef onHKStatusChanged_HK_SELECT_UP
    if ((message.GetHKCode() == HARDKEYCODE_HK_SELECT) && (message.GetHKState() == HARDKEYSTATE_UP)) { eventId = CIT_EVENT_ID(onHKStatusChanged_HK_SELECT_UP, 0x263EAF7F); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForHKStatusChangedUpdMsg(AppHmi_SystemStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::HKStatusChangedUpdMsg const & message = static_cast< ::HKStatusChangedUpdMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onActivateImageProviderRequest
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onActivateImageProviderRequest 0xffff
#pragma _REMINDER("Using dummy value symbol onActivateImageProviderRequest ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onActivateImageProviderRequest -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onDeactivateImageProviderRequest
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onDeactivateImageProviderRequest 0xffff
#pragma _REMINDER("Using dummy value symbol onDeactivateImageProviderRequest ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onDeactivateImageProviderRequest -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForActivateImageProviderReqMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::hmibase::gadget::ActivateImageProviderReqMsg const & message = static_cast< ::hmibase::gadget::ActivateImageProviderReqMsg const &>(aMessage);

#ifdef onActivateImageProviderRequest
    if ((message.GetActivate() == 1)) { eventId = CIT_EVENT_ID(onActivateImageProviderRequest, 0xDD62EA5B); return true; }
#endif
#ifdef onDeactivateImageProviderRequest
    if ((message.GetActivate() == 0)) { eventId = CIT_EVENT_ID(onDeactivateImageProviderRequest, 0x9FE98C1E); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActivateImageProviderReqMsg(AppHmi_SystemStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::hmibase::gadget::ActivateImageProviderReqMsg const & message = static_cast< ::hmibase::gadget::ActivateImageProviderReqMsg const &>(aMessage);
#ifdef onActivateImageProviderRequest
    if (eventId == onActivateImageProviderRequest) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetInstanceId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onActivateImageProviderRequest.InstanceId = message.GetInstanceId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onDeactivateImageProviderRequest
    if (eventId == onDeactivateImageProviderRequest) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetInstanceId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onDeactivateImageProviderRequest.InstanceId = message.GetInstanceId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForHMISubStateChangedUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::HMISubStateChangedUpdMsg const & message = static_cast< ::HMISubStateChangedUpdMsg const &>(aMessage);

#ifdef onHMISubStateChanged_ON
    if ((message.GetSubState() == HMISTATE_SHOW_HMI)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_ON, 0x76CF2B88); return true; }
#endif
#ifdef onHMISubStateChanged_CLOCK
    if ((message.GetSubState() == HMISTATE_SHOW_CLOCK)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_CLOCK, 0xF96478DC); return true; }
#endif
#ifdef onHMISubStateChanged_OFF
    if ((message.GetSubState() == HMISTATE_SHOW_OFF)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_OFF, 0x776D7D8A); return true; }
#endif
#ifdef onHMISubStateChanged_STANDBY_RESTRICTED
    if ((message.GetSubState() == HMISTATE_STANDBY_RESTRICTED)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_STANDBY_RESTRICTED, 0xA15C3CEE); return true; }
#endif
#ifdef onHMISubStateChanged_STANDBY
    if ((message.GetSubState() == HMISTATE_STANDBY)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_STANDBY, 0x0D0F5602); return true; }
#endif
#ifdef onHMISubStateChanged_PHONE
    if ((message.GetSubState() == HMISTATE_PHONE)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_PHONE, 0xC8D83B8B); return true; }
#endif
#ifdef onHMISubStateChanged_NO_DISPLAY
    if ((message.GetSubState() == HMISTATE_SHOW_NO_DISPLAY)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_NO_DISPLAY, 0xE4658CFD); return true; }
#endif
#ifdef onHMISubStateChanged_SECURE
    if ((message.GetSubState() == HMISTATE_SECURE)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_SECURE, 0xAB89D7A8); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForHMISubStateChangedUpdMsg(AppHmi_SystemStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::HMISubStateChangedUpdMsg const & message = static_cast< ::HMISubStateChangedUpdMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForApplicationStateUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::ApplicationStateUpdMsg const & message = static_cast< ::ApplicationStateUpdMsg const &>(aMessage);

#ifdef onAppStatusChanged_FOREGROUND
    if ((message.GetState() == hmibase::IN_FOREGROUND)) { eventId = CIT_EVENT_ID(onAppStatusChanged_FOREGROUND, 0xDE9448E3); return true; }
#endif
#ifdef onAppStatusChanged_BACKGROUND
    if ((message.GetState() == hmibase::IN_BACKGROUND)) { eventId = CIT_EVENT_ID(onAppStatusChanged_BACKGROUND, 0x6D1B3A68); return true; }
#endif
#ifdef onAppStatusPrepare_BACKGROUND
    if ((message.GetState() == hmibase::TO_BACKGROUND)) { eventId = CIT_EVENT_ID(onAppStatusPrepare_BACKGROUND, 0x4C8518AE); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForApplicationStateUpdMsg(AppHmi_SystemStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::ApplicationStateUpdMsg const & message = static_cast< ::ApplicationStateUpdMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onSubSurfaceUpdMsgChanged_FOREGROUND
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onSubSurfaceUpdMsgChanged_FOREGROUND 0xffff
#pragma _REMINDER("Using dummy value symbol onSubSurfaceUpdMsgChanged_FOREGROUND ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onSubSurfaceUpdMsgChanged_FOREGROUND -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onSubSurfaceUpdMsgChanged_BACKGROUND
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onSubSurfaceUpdMsgChanged_BACKGROUND 0xffff
#pragma _REMINDER("Using dummy value symbol onSubSurfaceUpdMsgChanged_BACKGROUND ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onSubSurfaceUpdMsgChanged_BACKGROUND -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForSubSurfaceUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::SubSurfaceUpdMsg const & message = static_cast< ::SubSurfaceUpdMsg const &>(aMessage);

#ifdef onSubSurfaceUpdMsgChanged_FOREGROUND
    if ((message.GetState() == hmibase::IN_FOREGROUND)) { eventId = CIT_EVENT_ID(onSubSurfaceUpdMsgChanged_FOREGROUND, 0x9D4DF4FC); return true; }
#endif
#ifdef onSubSurfaceUpdMsgChanged_BACKGROUND
    if ((message.GetState() == hmibase::IN_BACKGROUND)) { eventId = CIT_EVENT_ID(onSubSurfaceUpdMsgChanged_BACKGROUND, 0x5790D8C1); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSubSurfaceUpdMsg(AppHmi_SystemStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::SubSurfaceUpdMsg const & message = static_cast< ::SubSurfaceUpdMsg const &>(aMessage);
#ifdef onSubSurfaceUpdMsgChanged_FOREGROUND
    if (eventId == onSubSurfaceUpdMsgChanged_FOREGROUND) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetDisplayRegion(), message.GetDisplayID()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onSubSurfaceUpdMsgChanged_FOREGROUND.DisplayRegion = message.GetDisplayRegion();
        onClickParam.VSEPS_onSubSurfaceUpdMsgChanged_FOREGROUND.DisplayID = message.GetDisplayID();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onSubSurfaceUpdMsgChanged_BACKGROUND
    if (eventId == onSubSurfaceUpdMsgChanged_BACKGROUND) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetDisplayRegion(), message.GetDisplayID()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onSubSurfaceUpdMsgChanged_BACKGROUND.DisplayRegion = message.GetDisplayRegion();
        onClickParam.VSEPS_onSubSurfaceUpdMsgChanged_BACKGROUND.DisplayID = message.GetDisplayID();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_SystemStateMachineImpl::VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
struct EventMapping
{
    ::FeatStd::UInt32 mHashId;
    bool (*mEventCallHandler)(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId);
};

struct EventDeductionMapping
{
    ::FeatStd::UInt32 mHashId;
    ::Cit::DeductResult::Enum (*mEventCallHandler)(AppHmi_SystemStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId);
};

static ::FeatStd::Int EventMappingCmp(::FeatStd::UInt32 hash, const EventMapping& em)
{
    return (hash == em.mHashId) ? 0 : ((hash < em.mHashId) ? -1 : 1);
}

static ::FeatStd::Int EventDeductionMappingCmp(::FeatStd::UInt32 hash, const EventDeductionMapping& em)
{
    return (hash == em.mHashId) ? 0 : ((hash < em.mHashId) ? -1 : 1);
}

bool AppHmi_SystemStateMachineImpl::HandleEventMapping(::Courier::Message const & message, ::FeatStd::UInt32& eventId) const
{
    static EventMapping events[66] = {
        { 0x01320681, HandleEventMappingForSceneTranstoDisplay },
        { 0x04B8AFB9, HandleEventMappingForHKStatusChangedUpdMsg },
        { 0x0B315CC6, HandleEventMappingForExitOnSWDLFailureMsg },
        { 0x0BC96C7F, HandleEventMappingForSceneTranstoFactory },
        { 0x1222F8FD, HandleEventMappingForGotoMicSettings },
        { 0x128DE921, HandleEventMappingForIncompatibleUSBUpdMsg },
        { 0x1536C3F4, HandleEventMappingForButtonListItemUpdMsg },
        { 0x157A5594, HandleEventMappingForOEMSettingMsg },
        { 0x18BA17DA, HandleEventMappingForSceneTranstoClock },
        { 0x216AA422, HandleEventMappingForActivate_PopUp },
        { 0x21E076C5, HandleEventMappingForSceneTranstoLanguage },
        { 0x28ADC177, HandleEventMappingForStartSoftwareUpdateHistoryMsg },
        { 0x2D64B53B, HandleEventMappingForActivate_Popup_RenderingDiagnosis },
        { 0x304D0E48, HandleEventMappingForSceneTranstoSecurity },
        { 0x343785F3, HandleEventMappingForStartSoftwareUpdateLongPressMsg },
        { 0x3735E2CC, HandleEventMappingForPopup_Reset_System },
        { 0x3824FE1D, HandleEventMappingForApplicationStateUpdMsg },
        { 0x398FE0AB, HandleEventMappingForOpenSourceSoftwareMsg },
        { 0x431885FF, HandleEventMappingForUSBValidationCompleteMsg },
        { 0x4A69141E, HandleEventMappingForHMISubStateChangedUpdMsg },
        { 0x4D14C60C, HandleEventMappingForSceneTranstoAS },
        { 0x4F0291F7, HandleEventMappingForDisplayAudioSetting4Tuner },
        { 0x4FF79763, HandleEventMappingForEncoderStatusChangedUpdMsg },
        { 0x59006113, HandleEventMappingForEnggModeFilterUpdMsg },
        { 0x5CB190E6, HandleEventMappingForOEMMenuMsg },
        { 0x5D46FC1E, HandleEventMappingForActivateSpeedLock_CP_Popup },
        { 0x62DA2CEE, HandleEventMappingForResetFactorySettingsMsg },
        { 0x69FAC6F1, HandleEventMappingForSubSurfaceUpdMsg },
        { 0x6A140832, HandleEventMappingForUpdateCLKSetModeResp },
        { 0x6AE0FD3C, HandleEventMappingForButtonReactionMsg },
        { 0x6EED5687, HandleEventMappingForClonedHKStatusMsg },
        { 0x70B86E1D, HandleEventMappingForStartSoftwareUpdatePressMsg },
        { 0x7474B999, HandleEventMappingForPopup_Privacy_open },
        { 0x784F7B76, HandleEventMappingForOnXMLAvailabilityExitBusyWaitMsg },
        { 0x83670D8C, HandleEventMappingForDisplayAudioSetting4Media },
        { 0x851A3BDB, HandleEventMappingForOnReceivingStageOneEstTimeMsg },
        { 0x891E6B33, HandleEventMappingForSwitchToSWDLMISprogressBarSceneMsg },
        { 0x8FBDDED8, HandleEventMappingForDisplayAudioSetting4Volume },
        { 0x93A5580A, HandleEventMappingForActivityMsg },
        { 0x9A65FDAF, HandleEventMappingForSoftwareVersionCISMsg },
        { 0xA03D285E, HandleEventMappingForSWupdateResultNotificationMsg },
        { 0xA348A425, HandleEventMappingForSpeedLockMsg },
        { 0xA3BA3D05, HandleEventMappingForDisplayclock },
        { 0xA60CB9F4, HandleEventMappingForShutdownMsg },
        { 0xAE3CAAA7, HandleEventMappingForExpiredPopupTimerResMsg },
        { 0xAEC46B06, HandleEventMappingForIncompatibleUsbFormatMsg },
        { 0xB05D844B, HandleEventMappingForSceneTranstoOSS },
        { 0xB4A208EE, HandleEventMappingForMediaEntry2AudioSetting_1 },
        { 0xB6D1D019, HandleEventMappingForCustomerModeFilterUpdMsg },
        { 0xB73746B5, HandleEventMappingForGotoMainSoundSettings },
        { 0xC14FF11A, HandleEventMappingForUSBStickRemovedUpdMsg },
        { 0xC277DA2B, HandleEventMappingForActivateApplicationMsg },
        { 0xC613E40C, HandleEventMappingForActivateImageProviderReqMsg },
        { 0xC7B455FB, HandleEventMappingForTransitionIndMsg },
        { 0xC94E2014, HandleEventMappingForReleaseDocPropertyUpdMsg },
        { 0xD4AC7BDB, HandleEventMappingForActivationResMsg },
        { 0xDAE968BA, HandleEventMappingForDeactivateApplicationMsg },
        { 0xDF0746EC, HandleEventMappingForSWCompactibilityUpdMsg },
        { 0xE289A6CE, HandleEventMappingForActivateSWDowngradePopup },
        { 0xE2F61D55, HandleEventMappingForSurfaceStateChangedUpdMsg },
        { 0xEA99C3A7, HandleEventMappingForSceneTranstoEP },
        { 0xECC3E293, HandleEventMappingForHide_Popup_RenderingDiagnosis },
        { 0xEEFC58E9, HandleEventMappingForSceneTranstoSpeedDepVol },
        { 0xF84AB17C, HandleEventMappingForGotoMainCabinASettings },
        { 0xFCBE24B7, HandleEventMappingForDeactivateSWDowngradePopup },
        { 0xFCE1918E, HandleEventMappingForSWUpdateStageOneCompleteMsg },
    };
    ::FeatStd::UInt32 hashId = message.GetId();
    const EventMapping* eventEntry = ::Courier::BinarySearch(hashId, events, 66, &EventMappingCmp);
    if (eventEntry && (hashId == eventEntry->mHashId)) {
        return eventEntry->mEventCallHandler(message, eventId);
    }
    return false;
}

// ------------------------------------------------------------------------
::Cit::DeductResult::Enum AppHmi_SystemStateMachineImpl::DeductEvent(::Courier::Message const & aMessage, ::FeatStd::UInt32 eventId)
{
    ::Cit::DeductResult::Enum deductResult = Cit::DeductResult::DeductOk;
    static EventDeductionMapping events[66] = {
        { 0x01320681, HandleEventDeductionForSceneTranstoDisplay },
        { 0x04B8AFB9, HandleEventDeductionForHKStatusChangedUpdMsg },
        { 0x0B315CC6, HandleEventDeductionForExitOnSWDLFailureMsg },
        { 0x0BC96C7F, HandleEventDeductionForSceneTranstoFactory },
        { 0x1222F8FD, HandleEventDeductionForGotoMicSettings },
        { 0x128DE921, HandleEventDeductionForIncompatibleUSBUpdMsg },
        { 0x1536C3F4, HandleEventDeductionForButtonListItemUpdMsg },
        { 0x157A5594, HandleEventDeductionForOEMSettingMsg },
        { 0x18BA17DA, HandleEventDeductionForSceneTranstoClock },
        { 0x216AA422, HandleEventDeductionForActivate_PopUp },
        { 0x21E076C5, HandleEventDeductionForSceneTranstoLanguage },
        { 0x28ADC177, HandleEventDeductionForStartSoftwareUpdateHistoryMsg },
        { 0x2D64B53B, HandleEventDeductionForActivate_Popup_RenderingDiagnosis },
        { 0x304D0E48, HandleEventDeductionForSceneTranstoSecurity },
        { 0x343785F3, HandleEventDeductionForStartSoftwareUpdateLongPressMsg },
        { 0x3735E2CC, HandleEventDeductionForPopup_Reset_System },
        { 0x3824FE1D, HandleEventDeductionForApplicationStateUpdMsg },
        { 0x398FE0AB, HandleEventDeductionForOpenSourceSoftwareMsg },
        { 0x431885FF, HandleEventDeductionForUSBValidationCompleteMsg },
        { 0x4A69141E, HandleEventDeductionForHMISubStateChangedUpdMsg },
        { 0x4D14C60C, HandleEventDeductionForSceneTranstoAS },
        { 0x4F0291F7, HandleEventDeductionForDisplayAudioSetting4Tuner },
        { 0x4FF79763, HandleEventDeductionForEncoderStatusChangedUpdMsg },
        { 0x59006113, HandleEventDeductionForEnggModeFilterUpdMsg },
        { 0x5CB190E6, HandleEventDeductionForOEMMenuMsg },
        { 0x5D46FC1E, HandleEventDeductionForActivateSpeedLock_CP_Popup },
        { 0x62DA2CEE, HandleEventDeductionForResetFactorySettingsMsg },
        { 0x69FAC6F1, HandleEventDeductionForSubSurfaceUpdMsg },
        { 0x6A140832, HandleEventDeductionForUpdateCLKSetModeResp },
        { 0x6AE0FD3C, HandleEventDeductionForButtonReactionMsg },
        { 0x6EED5687, HandleEventDeductionForClonedHKStatusMsg },
        { 0x70B86E1D, HandleEventDeductionForStartSoftwareUpdatePressMsg },
        { 0x7474B999, HandleEventDeductionForPopup_Privacy_open },
        { 0x784F7B76, HandleEventDeductionForOnXMLAvailabilityExitBusyWaitMsg },
        { 0x83670D8C, HandleEventDeductionForDisplayAudioSetting4Media },
        { 0x851A3BDB, HandleEventDeductionForOnReceivingStageOneEstTimeMsg },
        { 0x891E6B33, HandleEventDeductionForSwitchToSWDLMISprogressBarSceneMsg },
        { 0x8FBDDED8, HandleEventDeductionForDisplayAudioSetting4Volume },
        { 0x93A5580A, HandleEventDeductionForActivityMsg },
        { 0x9A65FDAF, HandleEventDeductionForSoftwareVersionCISMsg },
        { 0xA03D285E, HandleEventDeductionForSWupdateResultNotificationMsg },
        { 0xA348A425, HandleEventDeductionForSpeedLockMsg },
        { 0xA3BA3D05, HandleEventDeductionForDisplayclock },
        { 0xA60CB9F4, HandleEventDeductionForShutdownMsg },
        { 0xAE3CAAA7, HandleEventDeductionForExpiredPopupTimerResMsg },
        { 0xAEC46B06, HandleEventDeductionForIncompatibleUsbFormatMsg },
        { 0xB05D844B, HandleEventDeductionForSceneTranstoOSS },
        { 0xB4A208EE, HandleEventDeductionForMediaEntry2AudioSetting_1 },
        { 0xB6D1D019, HandleEventDeductionForCustomerModeFilterUpdMsg },
        { 0xB73746B5, HandleEventDeductionForGotoMainSoundSettings },
        { 0xC14FF11A, HandleEventDeductionForUSBStickRemovedUpdMsg },
        { 0xC277DA2B, HandleEventDeductionForActivateApplicationMsg },
        { 0xC613E40C, HandleEventDeductionForActivateImageProviderReqMsg },
        { 0xC7B455FB, HandleEventDeductionForTransitionIndMsg },
        { 0xC94E2014, HandleEventDeductionForReleaseDocPropertyUpdMsg },
        { 0xD4AC7BDB, HandleEventDeductionForActivationResMsg },
        { 0xDAE968BA, HandleEventDeductionForDeactivateApplicationMsg },
        { 0xDF0746EC, HandleEventDeductionForSWCompactibilityUpdMsg },
        { 0xE289A6CE, HandleEventDeductionForActivateSWDowngradePopup },
        { 0xE2F61D55, HandleEventDeductionForSurfaceStateChangedUpdMsg },
        { 0xEA99C3A7, HandleEventDeductionForSceneTranstoEP },
        { 0xECC3E293, HandleEventDeductionForHide_Popup_RenderingDiagnosis },
        { 0xEEFC58E9, HandleEventDeductionForSceneTranstoSpeedDepVol },
        { 0xF84AB17C, HandleEventDeductionForGotoMainCabinASettings },
        { 0xFCBE24B7, HandleEventDeductionForDeactivateSWDowngradePopup },
        { 0xFCE1918E, HandleEventDeductionForSWUpdateStageOneCompleteMsg },
    };
    ::FeatStd::UInt32 hashId = aMessage.GetId();
    const EventDeductionMapping* eventEntry = ::Courier::BinarySearch(hashId, events, 66, &EventDeductionMappingCmp);
    if (eventEntry && (hashId == eventEntry->mHashId)) {
        deductResult = eventEntry->mEventCallHandler(this, aMessage, eventId);
    }
    else {
        typedef Cit::Internal::VSDeductHelper<VS_Ret_Ok, AppHmi_SystemStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
        return VSDeductHelper::ProcessOutput(*this, (*this.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
        return VSDeductHelper::ProcessOutput(*this, (*this.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
    }
    return deductResult;
}

// ------------------------------------------------------------------------
bool AppHmi_SystemStateMachineImpl::HandleDataBindingEventMapping(::Courier::AbstractDataItemMsg const & /* message */, ::FeatStd::UInt32 & /* eventId */) const
{
    return false;
}

#ifdef CIT_SIMULATION
struct EventNameMapping
{
    ::FeatStd::UInt32 mEventId;
    const ::FeatStd::Char* mEventName;
    void (*mGetEventArguments)(::Courier::Message const & message, Json::Value& eventArguments);
};

static ::FeatStd::Int EventNameMappingCmp(::FeatStd::UInt32 eventId, const EventNameMapping& em)
{
    return (eventId == em.mEventId) ? 0 : ((eventId < em.mEventId) ? -1 : 1);
}

static void GetEventArgumentsForev_OnButtonPressTimeformatTypeItem(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::ButtonListItemUpdMsg const & message = static_cast< ::ButtonListItemUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetHdl();
}

static void GetEventArgumentsForev_onTimeOutOfMISUpdate(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::ExpiredPopupTimerResMsg const & message = static_cast< ::ExpiredPopupTimerResMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId();
}

static void GetEventArgumentsForev_OnButtonPressDisplayModeItem(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::ButtonListItemUpdMsg const & message = static_cast< ::ButtonListItemUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetHdl();
}

static void GetEventArgumentsForev_OnButtonPressGpsClkDateFmtPreset(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::ButtonListItemUpdMsg const & message = static_cast< ::ButtonListItemUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetHdl();
}

static void GetEventArgumentsForev_OnButtonPressAuxTypeItem(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::ButtonListItemUpdMsg const & message = static_cast< ::ButtonListItemUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetHdl();
}

static void GetEventArgumentsForonCenterPopupSurfaceVisible(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonTopPopupSurfaceInvisible(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForev_OnButtonPressClockTimeZoneItem(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::ButtonListItemUpdMsg const & message = static_cast< ::ButtonListItemUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetHdl();
}

static void GetEventArgumentsForev_OnButtonPressClockFormatTypeItem(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::ButtonListItemUpdMsg const & message = static_cast< ::ButtonListItemUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetHdl();
}

static void GetEventArgumentsForev_OnButtonPressGpsClkClockModeTypeItem(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::ButtonListItemUpdMsg const & message = static_cast< ::ButtonListItemUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetHdl();
}

static void GetEventArgumentsForonSubSurfaceUpdMsgChanged_BACKGROUND(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SubSurfaceUpdMsg const & message = static_cast< ::SubSurfaceUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::Int)message.GetDisplayRegion();
    eventArguments[(::Json::Value::UInt)1] = (::Json::Value::UInt)message.GetDisplayID();
}

static void GetEventArgumentsForev_OnButtonPressGpsClkTimeformatTypeItem(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::ButtonListItemUpdMsg const & message = static_cast< ::ButtonListItemUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetHdl();
}

static void GetEventArgumentsForonSystemInstallationPopupSurfaceQueued(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonEncoderStatusChanged_RIGHT_ENC(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::EncoderStatusChangedUpdMsg const & message = static_cast< ::EncoderStatusChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::Int)message.GetEncSteps();
}

static void GetEventArgumentsForev_OnButtonPressGammaMonitorFlipCADropItem(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::ButtonListItemUpdMsg const & message = static_cast< ::ButtonListItemUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetHdl();
}

static void GetEventArgumentsForOnClonedHKStatusMsg(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::ClonedHKStatusMsg const & message = static_cast< ::ClonedHKStatusMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetHKCode();
    eventArguments[(::Json::Value::UInt)1] = (::Json::Value::UInt)message.GetHKState();
}

static void GetEventArgumentsForonTopPopupSurfaceUnqueued(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonTopPopupSurfaceVisible(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonCenterPopupSurfaceInvisible(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonSubSurfaceUpdMsgChanged_FOREGROUND(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SubSurfaceUpdMsg const & message = static_cast< ::SubSurfaceUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::Int)message.GetDisplayRegion();
    eventArguments[(::Json::Value::UInt)1] = (::Json::Value::UInt)message.GetDisplayID();
}

static void GetEventArgumentsForonDeactivateImageProviderRequest(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::hmibase::gadget::ActivateImageProviderReqMsg const & message = static_cast< ::hmibase::gadget::ActivateImageProviderReqMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetInstanceId();
}

static void GetEventArgumentsForonCenterPopupSurfaceUnqueued(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForevSubSystem_OnButtonPressDTCCodeStatusListTypeItem(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::ButtonListItemUpdMsg const & message = static_cast< ::ButtonListItemUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetHdl();
}

static void GetEventArgumentsForonTopPopupSurfaceQueued(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonPopupVisible(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonSystemInstallationPopupSurfaceUnqueued(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonPopupQueued(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonSystemInstallationPopupSurfaceInvisible(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForev_OnButtonPressOnSoftwareUpdateHistoryListItem(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::ButtonListItemUpdMsg const & message = static_cast< ::ButtonListItemUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetHdl();
}

static void GetEventArgumentsForonSystemInstallationPopupSurfaceVisible(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForev_OnButtonPressMeasurementTypeItem(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::ButtonListItemUpdMsg const & message = static_cast< ::ButtonListItemUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetHdl();
}

static void GetEventArgumentsForonPopupUnqueued(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonActivateImageProviderRequest(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::hmibase::gadget::ActivateImageProviderReqMsg const & message = static_cast< ::hmibase::gadget::ActivateImageProviderReqMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetInstanceId();
}

static void GetEventArgumentsForev_OnButtonPressGammaLCDOnOffCADropItem(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::ButtonListItemUpdMsg const & message = static_cast< ::ButtonListItemUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetHdl();
}

static void GetEventArgumentsForev_onMIS_ResultExtraction(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SWupdateResultNotificationMsg const & message = static_cast< ::SWupdateResultNotificationMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetResultPopupType();
}

static void GetEventArgumentsForonPopupTimerExpiry(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::ExpiredPopupTimerResMsg const & message = static_cast< ::ExpiredPopupTimerResMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId();
}

static void GetEventArgumentsForonCenterPopupSurfaceQueued(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

const ::FeatStd::Char* AppHmi_SystemStateMachineImpl::GetEventName(::FeatStd::UInt32 eventId, ::Courier::Message const & message, Json::Value& eventArguments)
{
    static EventNameMapping events[391] = {
        { 0x01933FC4, "OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_DateFmtEU_Rbtn_DateFmtEU_4_enRelease", 0 },
        { 0x01A9B690, "OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_RVCBrightnessSettings_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0x03015DE1, "OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_btn_AS_back_enLongPressRelease", 0 },
        { 0x037452DD, "OnButtonReactionMsg_AppHmi_System_SoftwareDownload_screen_5_Layer_TouchArea_Back_1_ButtonWidget_enRelease", 0 },
        { 0x03A57AEB, "OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_24_enRelease", 0 },
        { 0x0412ADF3, "OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_Manual_Button_Min_DECR_enRepeatPressSecondary", 0 },
        { 0x0622D8BF, "OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_36_enRelease", 0 },
        { 0x06FA5BA0, "ev_OnButtonPressCAMain2AudioTypeItem", 0 },
        { 0x07167C75, "ev_OnButtonPressClkDateFmtPreset", 0 },
        { 0x0867EF49, "OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_VideoMixSource_CA_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0x0A101753, "OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_AS_EqlPreset_Layer_EqlPrst_Flat_ButtonWidget2D_enRelease", 0 },
        { 0x0A73EC4D, "OnHide_Popup_RenderingDiagnosis", 0 },
        { 0x0B4DDFDE, "OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_EqlPreset_Rbtn_EqlPrst_Classic_enRelease", 0 },
        { 0x0BDCFBAA, "OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_GEX_Candidate_GEX_3_enRelease", 0 },
        { 0x0CC5FFC9, "ev_onMIS_SystemUpdate_Complete", 0 },
        { 0x0CE1EA59, "ev_OnButtonPressTimeformatTypeItem", GetEventArgumentsForev_OnButtonPressTimeformatTypeItem },
        { 0x0CECE954, "OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_25_enRelease", 0 },
        { 0x0D02E21F, "OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_LS_EU_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0x0D0F5602, "onHMISubStateChanged_STANDBY", 0 },
        { 0x0DF61042, "OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_EU_Candidate_EU_11_enRelease", 0 },
        { 0x0F2DADC1, "ev_onTimeOutOfMISUpdate", GetEventArgumentsForev_onTimeOutOfMISUpdate },
        { 0x0F8A6E48, "OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_7_enRelease", 0 },
        { 0x10085DE5, "OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_EqlPreset_Rbtn_EqlPrst_Jazz_enRelease", 0 },
        { 0x108466DC, "ev_RVC_Brightness_touch", 0 },
        { 0x10F5E6F4, "OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_DS_Layer_TouchArea_DSDecrease_ButtonWidget_enRelease", 0 },
        { 0x1119C6A4, "ev_OnButtonPressLanguageListTypeItem", 0 },
        { 0x1128B30A, "ev_OnButtonPressDisplayModeItem", GetEventArgumentsForev_OnButtonPressDisplayModeItem },
        { 0x11AA1EFE, "OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_AS_PrivateMode_Layer_PrivateMode_2_ButtonWidget2D_enRelease", 0 },
        { 0x124F0846, "Activate_DeepHistory", 0 },
        { 0x12666775, "OnNextLevelTransitionFininshed_SysSettingsToDisplaySettings", 0 },
        { 0x12AB0612, "OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_btn_AS_IncTreble_enRelease", 0 },
        { 0x14ACE9C5, "ev_SoftwareDownloadMode_QuickUpdate", 0 },
        { 0x14B85A24, "ev_onUserConfirmation_2linePopup", 0 },
        { 0x15C094B4, "OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_GEX_Candidate_GEX_1_enRelease", 0 },
        { 0x185FDB18, "ev_OnButtonPress4mCabinA2Glass", 0 },
        { 0x18A128AD, "OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_EU_Candidate_EU_12_enRelease", 0 },
        { 0x199D766D, "ev_OnButtonPressGpsClkDateFmtPreset", GetEventArgumentsForev_OnButtonPressGpsClkDateFmtPreset },
        { 0x1B6EA63A, "OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_AS_PrivateMode_Layer_PrivateMode_3_ButtonWidget2D_enRelease", 0 },
        { 0x1B7ACA45, "OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_EU_Candidate_EU_5_enRelease", 0 },
        { 0x1C6BCE4E, "OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_btn_AS_IncBalance_enRelease", 0 },
        { 0x1C9B2825, "OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_SpeedDepVol_Rbtn_SpdDepVol_Lvl3_enRelease", 0 },
        { 0x1E5E4E6B, "OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_EqlPreset_Rbtn_EqlPrst_Pop_enRelease", 0 },
        { 0x1EBC2C84, "OnNextLevelTransitionFininshed_SysSettingsToLanguageSettings", 0 },
        { 0x1FFC37D3, "OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_GPS_btn_CS_GPS_back_enRelease", 0 },
        { 0x209E60F0, "OnActivate_Popup_RenderingDiagnosis", 0 },
        { 0x20B14F3C, "OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_20_enRelease", 0 },
        { 0x20FE0FA2, "ev_OnButtonPressAuxTypeItem", GetEventArgumentsForev_OnButtonPressAuxTypeItem },
        { 0x21D91FD4, "OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_Manual_Button_Min_INCR_enRepeatPressSecondary", 0 },
        { 0x21DF6227, "OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_SysSettings_Button_SecurityPIN_enRelease", 0 },
        { 0x22B6C7BA, "ev_OnXMLAvailabilityExitBusyWaitMsg", 0 },
        { 0x23767312, "OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_GEX_Candidate_GEX_2_enRelease", 0 },
        { 0x23B97E51, "onCenterPopupSurfaceVisible", GetEventArgumentsForonCenterPopupSurfaceVisible },
        { 0x23BE23BB, "ev_onUserConfirmation_3linePopup_Up_touch", 0 },
        { 0x23C27BBB, "OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_SysSettings_CB_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0x23D8F4B4, "OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_Manual_Button_Hr_DEC_enRepeatPressSecondary", 0 },
        { 0x24C4852E, "OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_btn_AS_DecBalance_enRelease", 0 },
        { 0x251E0E34, "OnNextLevelTransitionFininshed_SysSettingsToAudioSettings", 0 },
        { 0x2559D537, "ev_onPopupTimedout", 0 },
        { 0x261D5EE5, "OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_EU_Candidate_EU_6_enRelease", 0 },
        { 0x263702DA, "OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_OEM_MENU_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0x263EAF7F, "onHKStatusChanged_HK_SELECT_UP", 0 },
        { 0x26C30D04, "OnPreviousLevelTransitionFinished", 0 },
        { 0x286F8D6E, "OnNextLevelTransitionFininshed_ManualToDateFormatEU", 0 },
        { 0x28FD82D6, "OnSceneTranstoClock", 0 },
        { 0x2B962B1A, "OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_48_enRelease", 0 },
        { 0x2CA8F08B, "OnPreviousLevelTransitionFinished_EqlPresetTOSetting", 0 },
        { 0x2CDB1E82, "ev_onSWDowngrade", 0 },
        { 0x2E52902B, "OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_OSS_CA_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0x2EE8CAD7, "ev_OnButtonPressStartSoftwareUpdateItem", 0 },
        { 0x2F03A4B5, "OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_Manual_Button_CS_Manual_CLKSetMode_enRelease", 0 },
        { 0x2F1539C3, "OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_5_enRelease", 0 },
        { 0x302618BC, "ev_OnButtonPressClockTypeItem", 0 },
        { 0x30E69C4B, "OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_OEM_PIN_Button_OK_ButtonWidget_enRelease", 0 },
        { 0x30EC2327, "OnButtonReactionMsg_Volume_PopUp_Scenes_SwUpdate_Downgrade_Btn_Cancel_enRelease", 0 },
        { 0x32205B9E, "ev_onUserConfirmation_6linePopup_Yes_touch", 0 },
        { 0x337BA1F2, "OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_EU_Candidate_EU_4_enRelease", 0 },
        { 0x3598CF84, "onTopPopupSurfaceInvisible", GetEventArgumentsForonTopPopupSurfaceInvisible },
        { 0x36E9812F, "OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_EU_Candidate_EU_3_enRelease", 0 },
        { 0x372319B8, "ev_onNewUSBStickFound", 0 },
        { 0x3780BE62, "ev_OnButtonPressClockTimeZoneItem", GetEventArgumentsForev_OnButtonPressClockTimeZoneItem },
        { 0x37BF2FAA, "OnPopup_Privacy_open", 0 },
        { 0x37C3CBD2, "OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_21_enRelease", 0 },
        { 0x37E7CAFB, "OnDeactivateApplicationMsg", 0 },
        { 0x38722D60, "OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_DateFmtCN_btn_DateFmtIN_Back_enRelease", 0 },
        { 0x387A46A9, "OnDeactivateSWDowngradePopup", 0 },
        { 0x38A40997, "ev_OnButtonPressGpsClkBtnFwdPreset", 0 },
        { 0x38A97D86, "ev_OnButtonPressClockFormatTypeItem", GetEventArgumentsForev_OnButtonPressClockFormatTypeItem },
        { 0x38C23FAA, "OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_46_enRelease", 0 },
        { 0x3A12F992, "OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_AS_EqlPreset_Layer_EqlPrst_Pop_ButtonWidget2D_enRelease", 0 },
        { 0x3A44654A, "OnActivateSWDowngradePopup", 0 },
        { 0x3BA9193E, "OnSceneTranstoSecurity", 0 },
        { 0x3BBE4C40, "ev_onUserConfirmation_4linePopup", 0 },
        { 0x3BDA2260, "OnSceneTranstoEP", 0 },
        { 0x3C1D2BE9, "Activate_GPS_Mode", 0 },
        { 0x3D181B2D, "OnButtonReactionMsg_Volume_PopUp_Scenes_SwUpdate_Downgrade_Btn_Update_enRelease", 0 },
        { 0x3D88717E, "OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_EU_Candidate_EU_10_enRelease", 0 },
        { 0x3E2FC646, "OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_CS_DateFmt_Layer_Radiobutton_DateFormat1_ButtonWidget2D_enRelease", 0 },
        { 0x3FA37BA8, "OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_Manual_btn_CS_Manual_back_enRelease", 0 },
        { 0x403A65A4, "OnDualViewLeftTransitionFinished", 0 },
        { 0x4064030B, "ev_onUSBStickRemoved", 0 },
        { 0x40E8223D, "OnNextLevelTransitionFininshed_GPSToDateFormatCN", 0 },
        { 0x41330B82, "OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_Manual_btn_CS_Manual_back_enLongPressRelease", 0 },
        { 0x422770B0, "ev_onUserConfirmation_3linePopup", 0 },
        { 0x4273EDF7, "OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_AS_EqlPreset_Layer_EqlPrst_Rock_ButtonWidget2D_enRelease", 0 },
        { 0x434EC498, "OnActivationResMsg_Volume_PopUp_Scenes_SwUpdate_Downgrade_1", 0 },
        { 0x4362F640, "ev_EnterOEMMenu", 0 },
        { 0x437D9EFE, "OnPageFlipFrontFinished", 0 },
        { 0x45EB10F6, "OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_DTCInformation_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0x468BB490, "ev_OnReceivingStageOneEstTime", 0 },
        { 0x4722E73F, "ev_OnButtonPressSoftwareUpdateHistoryItem", 0 },
        { 0x47BB4BB8, "OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_GPS_Button_CS_GPS_DateFormat_enRelease", 0 },
        { 0x47BEDA5F, "OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_SysSettings_Button_Language_enRelease", 0 },
        { 0x48B4E639, "OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_23_enRelease", 0 },
        { 0x4927AC3B, "OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_Manual_Button_Min_INCR_enRelease", 0 },
        { 0x493BE7CB, "OnDisplayclock", 0 },
        { 0x49D1FBCE, "OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_SpeedDepVol_Rbtn_SpdDepVol_Off_enRelease", 0 },
        { 0x49F898C2, "OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_AS_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0x4B18DA2B, "OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_14_enRelease", 0 },
        { 0x4BA1CA0F, "OnPreviousLevelTransitionFinished_DateFormatEUToGPS", 0 },
        { 0x4BC08607, "OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_CS_DateFmt_Layer_Radiobutton_DateFormat4_ButtonWidget2D_enRelease", 0 },
        { 0x4C8518AE, "onAppStatusPrepare_BACKGROUND", 0 },
        { 0x4CBFB51D, "OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_12_enRelease", 0 },
        { 0x4D3AC74B, "ev_onUserConfirmation_SystemInstallationPopup", 0 },
        { 0x4D51B22F, "OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_AS_EqlPreset_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0x4DB607B2, "OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_CS_GPS_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0x4EC1CE6A, "OnNextLevelTransitionFininshed_ManualToDateFormatCN", 0 },
        { 0x4F8153EE, "ev_onUserConfirmation_3linePopup_Down_touch", 0 },
        { 0x50B4DCCA, "OnDualViewRightTransitionFinished", 0 },
        { 0x518F01BD, "OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_AS_SpeedDepVol_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0x519B2D15, "OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_GPS_Button_CS_GPS_12HFormat_enRelease", 0 },
        { 0x51B5EA74, "OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_GEX_Button_Back_enRelease", 0 },
        { 0x51D11212, "OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_AudioSettings_CA_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0x53187AA3, "ev_OnButtonPressGpsClkClockModeTypeItem", GetEventArgumentsForev_OnButtonPressGpsClkClockModeTypeItem },
        { 0x532C9552, "OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_EqlPreset_Rbtn_EqlPrst_Hiphop_enRelease", 0 },
        { 0x53AEFC6E, "OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_13_enRelease", 0 },
        { 0x5437F3B8, "ev_onCustomerModeFilterUpdated", 0 },
        { 0x545088E9, "OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_SysSettings_CA_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0x54D87580, "OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_RVCBrightnessSettings_btn_RVC_IncBrightness_enRelease", 0 },
        { 0x55F851B3, "ev_onUserConfirmation_6linePopup_No_tocuh", 0 },
        { 0x56274B00, "OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_EU_Candidate_EU_13_enRelease", 0 },
        { 0x56CA7F5E, "OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_17_enRelease", 0 },
        { 0x5756B5FE, "OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_33_enRelease", 0 },
        { 0x5790D8C1, "onSubSurfaceUpdMsgChanged_BACKGROUND", GetEventArgumentsForonSubSurfaceUpdMsgChanged_BACKGROUND },
        { 0x592AEE16, "OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_Manual_Button_CS_Manual_TimeFormat_enRelease", 0 },
        { 0x59D7EB51, "OnDisplayAudioSetting4Tuner", 0 },
        { 0x5B50A4C8, "ev_onSWDetails_Back_Touch", 0 },
        { 0x5CA5AAD0, "ev_OnButtonPressGpsClkTimeformatTypeItem", GetEventArgumentsForev_OnButtonPressGpsClkTimeformatTypeItem },
        { 0x5CBA30B8, "ev_OnButtonPressresetfactorysetting", 0 },
        { 0x5CF05C8E, "OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_DateFmtCN_btn_DateFmtIN_Back_enLongPressRelease", 0 },
        { 0x5E139939, "OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_SysSettings_Button_Clock_enRelease", 0 },
        { 0x5F180209, "onSystemInstallationPopupSurfaceQueued", GetEventArgumentsForonSystemInstallationPopupSurfaceQueued },
        { 0x5F236A4F, "ev_RVC_Contrast_touch", 0 },
        { 0x611570E8, "OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_SysSettings_Layer_Display_ButtonWidget_enRelease", 0 },
        { 0x6261D53C, "OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_SpeedDepVol_Rbtn_SpdDepVol_Lvl1_enRelease", 0 },
        { 0x62B0327F, "OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_GEX_Candidate_GEX_5_enRelease", 0 },
        { 0x631F0B40, "OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_DateFmtEU_Rbtn_DateFmtEU_6_enRelease", 0 },
        { 0x6457DC49, "OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_EU_Button_Back_enRelease", 0 },
        { 0x65A5197A, "OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_GPS_btn_CS_GPS_back_enLongPressRelease", 0 },
        { 0x66662D60, "OnButtonReactionMsg_AppHmi_System_SoftwareDownload_Pfo_SysSetFactDefault_Layer_No_ButtonWidget_enRelease", 0 },
        { 0x67E5D82B, "onEncoderStatusChanged_RIGHT_ENC", GetEventArgumentsForonEncoderStatusChanged_RIGHT_ENC },
        { 0x683DAFF4, "OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_tg_bn_TouchClick_enRelease", 0 },
        { 0x6920FBAB, "OnActivationResMsg_AppHmi_System_SoftwareDownload_Pfo_SysSetFactDefault_1", 0 },
        { 0x69A14F76, "OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_40_enRelease", 0 },
        { 0x69F4447F, "ev_OnButtonPressGammaMonitorFlipCADropItem", GetEventArgumentsForev_OnButtonPressGammaMonitorFlipCADropItem },
        { 0x6A475C4B, "OnNextLevelTransitionFininshed_SysSettingsToLanguage_CN", 0 },
        { 0x6B7973D3, "OnButtonReactionMsg_AppHmi_System_SoftwareDownload_Stage_one_MIS_SystemUpdate_Layer_Details_ButtonWidget_enRelease", 0 },
        { 0x6B8AEE6C, "OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_RVCSettings_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0x6BC3A1B8, "OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_Manual_Button_Hr_DEC_enRelease", 0 },
        { 0x6C354B69, "ev_SoftwareDownloadMode_Details", 0 },
        { 0x6D1B3A68, "onAppStatusChanged_BACKGROUND", 0 },
        { 0x6EA32A6C, "OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_27_enRelease", 0 },
        { 0x6F10E7B2, "OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_Manual_Button_CS_ManualMode_enRelease", 0 },
        { 0x6FD95322, "ev_OnButtonPressSoSettingSoOssPress", 0 },
        { 0x6FE3C79C, "OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_GPS_Button_CS_GPS_TimeFormat_enRelease", 0 },
        { 0x7018D47E, "OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_CN_Button_Back_enRelease", 0 },
        { 0x70705B63, "OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_9_enRelease", 0 },
        { 0x717B063B, "OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_SysSettings_ToggleButtonWidget2D_SpeedLock_enRelease", 0 },
        { 0x7210B8B9, "OnMediaEntry2AudioSetting_1", 0 },
        { 0x73294DEB, "OnActivate_PopUp", 0 },
        { 0x73BA716D, "OnNextLevelTransitionFininshed_SysSettingsToLanguage_EU", 0 },
        { 0x74333E59, "OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_EU_Candidate_EU_7_enRelease", 0 },
        { 0x74F534EE, "OnPageFlipBackFinished", 0 },
        { 0x756C0DF3, "OnShutdownMsg", 0 },
        { 0x75BF246C, "OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_SpeedDepVol_Rbtn_SpdDepVol_Lvl2_enRelease", 0 },
        { 0x76078ED7, "OnNextLevelTransitionFininshed_GPSToDateFormatEU", 0 },
        { 0x764A3094, "OnPreviousLevelTransitionFinished_DateFormatCNToGPS", 0 },
        { 0x76CF2B88, "onHMISubStateChanged_ON", 0 },
        { 0x776D7D8A, "onHMISubStateChanged_OFF", 0 },
        { 0x776E4824, "ev_onSWSameGrade_NoTouch", 0 },
        { 0x777C8CDC, "OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_AS_PrivateMode_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0x7785F729, "OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_6_enRelease", 0 },
        { 0x77AB85EF, "OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_2_enRelease", 0 },
        { 0x7919BAB0, "ev_onSWSameGrade_YesTouch", 0 },
        { 0x795C2850, "ev_OnButtonPressSoSettingSoSWVersionCISPress", 0 },
        { 0x79BEBD42, "ev_OnButtonPressSpeedLock", 0 },
        { 0x7C54F8A0, "OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_AS_PrivateMode_Layer_PrivateMode_1_ButtonWidget2D_enRelease", 0 },
        { 0x7C6E800E, "OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_GPS_Button_CS_GPS_24HFormat_enRelease", 0 },
        { 0x7C78443E, "OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_CS_DateFmt_Layer_Radiobutton_DateFormat2_ButtonWidget2D_enRelease", 0 },
        { 0x7D529CE7, "OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_RVCBrightnessSettings_btn_RVC_DecBrightness_enRelease", 0 },
        { 0x7F3630A8, "OnActivationResMsg_AppHmi_System_SoftwareDownload_Pfo_SpeedLock_CP_1", 0 },
        { 0x7FF1CEE3, "OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_glass_setting_CA_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0x806C1FE9, "OnSceneTranstoFactory", 0 },
        { 0x807E7249, "OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_btn_AS_IncFader_enRelease", 0 },
        { 0x80993518, "OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_DateFmtEU_Rbtn_DateFmtEU_1_enRelease", 0 },
        { 0x816BEAC6, "OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_SysSettings_Button_RearViewCameraSetting_enRelease", 0 },
        { 0x8178EDD9, "OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_CS_DateFmt_Layer_Radiobutton_DateFormat3_ButtonWidget2D_enRelease", 0 },
        { 0x82B2A2F3, "ev_onEnggModeFilterUpdated", 0 },
        { 0x8326E048, "OnDisplayAudioSetting4Media", 0 },
        { 0x847E4DAD, "OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_Manual_Button_CS_Manual_24HFormat_enRelease", 0 },
        { 0x855900B5, "OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_CS_DateFmt_Layer_Radiobutton_DateFormat6_ButtonWidget2D_enRelease", 0 },
        { 0x862CDFC1, "OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_EU_Candidate_EU_2_enRelease", 0 },
        { 0x863ADC76, "ev_onIncompatibleUsbFormat", 0 },
        { 0x8707C29E, "ev_onSWupdateConfirmation_popup_No_tocuh", 0 },
        { 0x87DB82AA, "OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_LS_Nafta_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0x88051082, "OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_GPS_btn_TimeZone_enRelease", 0 },
        { 0x899A6B52, "ev_SoftwareDownloadMode_TouchareaBack", 0 },
        { 0x8A115F78, "OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_Manual_Button_CS_Manual_12HFormat_enRelease", 0 },
        { 0x8AC2EB49, "OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_tg_bn_BeepTones_enRelease", 0 },
        { 0x8C1DC1DA, "OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_AS_EqlPreset_Layer_EqlPrst_Classic_ButtonWidget2D_enRelease", 0 },
        { 0x8E3BDF7A, "OnClonedHKStatusMsg", GetEventArgumentsForOnClonedHKStatusMsg },
        { 0x8F6CEB73, "OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_GPS_Button_CS_GPSMode_enRelease", 0 },
        { 0x8F9B51C2, "Activate_Manual_Mode", 0 },
        { 0x90E615CC, "OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_29_enRelease", 0 },
        { 0x912024BE, "onTopPopupSurfaceUnqueued", GetEventArgumentsForonTopPopupSurfaceUnqueued },
        { 0x922FC898, "OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_30_enRelease", 0 },
        { 0x92721CBE, "OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_35_enRelease", 0 },
        { 0x92BC70E4, "ev_ContextSwitchToMISStageOne", 0 },
        { 0x930DB55F, "OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_CN_Candidate_CN_2_enRelease", 0 },
        { 0x930EFC0F, "ev_onUserConfirmation_5linePopup_Yes_touch", 0 },
        { 0x95E6EC07, "ev_onSWupdateConfirmation_popup_Yes_tocuh", 0 },
        { 0x96E07D66, "OnGotoMicSettings", 0 },
        { 0x9709B95B, "OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_15_enRelease", 0 },
        { 0x97106018, "OnPreviousLevelTransitionFinished_DateFormatEUToManual", 0 },
        { 0x973CB4FE, "OnButtonReactionMsg_AppHmi_System_SoftwareDownload_SWUpdate_Update_Info_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0x979D78E5, "ev_OnButtonLongPressStartSoftwareUpdateItem", 0 },
        { 0x97DE6D52, "OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_43_enRelease", 0 },
        { 0x984F8ED8, "onTopPopupSurfaceVisible", GetEventArgumentsForonTopPopupSurfaceVisible },
        { 0x9AA15851, "OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_SysSettings_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0x9B3F5F0D, "OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_19_enRelease", 0 },
        { 0x9BDB722F, "onCenterPopupSurfaceInvisible", GetEventArgumentsForonCenterPopupSurfaceInvisible },
        { 0x9BF91F7C, "OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_AS_EqlPreset_Layer_EqlPrst_Jazz_ButtonWidget2D_enRelease", 0 },
        { 0x9C324A48, "OnSceneTranstoSpeedDepVol", 0 },
        { 0x9CD4D971, "OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_38_enRelease", 0 },
        { 0x9CEC98B6, "OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_39_enRelease", 0 },
        { 0x9D3AED75, "OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_Button_EqPrst_enRelease", 0 },
        { 0x9D4A461F, "OnSceneTranstoDisplay", 0 },
        { 0x9D4DF4FC, "onSubSurfaceUpdMsgChanged_FOREGROUND", GetEventArgumentsForonSubSurfaceUpdMsgChanged_FOREGROUND },
        { 0x9E8291F5, "OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_42_enRelease", 0 },
        { 0x9FD2F3DB, "ev_OnButtonPressSystemInstallationListTypeItem", 0 },
        { 0x9FE98C1E, "onDeactivateImageProviderRequest", GetEventArgumentsForonDeactivateImageProviderRequest },
        { 0xA0E61664, "OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_Manual_Button_CS_GPSMode_enRelease", 0 },
        { 0xA15C3CEE, "onHMISubStateChanged_STANDBY_RESTRICTED", 0 },
        { 0xA18D63C2, "OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_DateFmtCN_Rbtn_DateFmtIN_1_enRelease", 0 },
        { 0xA1B43481, "OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_DateFmtEU_btn_DateFmtEU_Back_enRelease", 0 },
        { 0xA23B086E, "OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_CS_Manual_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0xA2FDB673, "OnButtonReactionMsg_AppHmi_System_SoftwareDownload_Pfo_SysSetFactDefault_Layer_Yes_ButtonWidget_enRelease", 0 },
        { 0xA497282A, "OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_AS_SpeedDepVol_Layer_SpdDepVol_Lvl1_ButtonWidget2D_enRelease", 0 },
        { 0xA4DAF086, "OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_DS_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0xA6A89982, "OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_26_enRelease", 0 },
        { 0xA7236AAD, "OnSceneTranstoOSS", 0 },
        { 0xA7CDF918, "OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_EU_Candidate_EU_9_enRelease", 0 },
        { 0xA7F94F4D, "OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_Manual_Button_CS_Manual_DateFormat_enRelease", 0 },
        { 0xA80D0542, "OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_Manual_Button_Hr_IINC_enRelease", 0 },
        { 0xA89B5B28, "OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_GPS_Button_CS_GPS_CLKSetMode_enRelease", 0 },
        { 0xA8A41D06, "OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_AS_SpeedDepVol_Layer_SpdDepVol_Off_ButtonWidget2D_enRelease", 0 },
        { 0xA8B38EB4, "OnButtonReactionMsg_AppHmi_System_SoftwareDownload_screen_6_Layer_TouchArea_Back_1_ButtonWidget_enRelease", 0 },
        { 0xA938C729, "OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_CS_DateFmt_Layer_Radiobutton_DateFormat5_ButtonWidget2D_enRelease", 0 },
        { 0xAA2CABB9, "ev_onSwivel_GS_CA_NoTouch", 0 },
        { 0xAA79C7DD, "onCenterPopupSurfaceUnqueued", GetEventArgumentsForonCenterPopupSurfaceUnqueued },
        { 0xAA7E8EAD, "OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_btn_AS_DecBass_enRelease", 0 },
        { 0xAB4FC796, "OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_41_enRelease", 0 },
        { 0xAB89D7A8, "onHMISubStateChanged_SECURE", 0 },
        { 0xACDAB50F, "OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_DateFmtEU_Rbtn_DateFmtEU_5_enRelease", 0 },
        { 0xADEC7FBC, "OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_SoftwareVersion_CIS_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0xAF0F27C0, "OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_CN_Candidate_CN_1_enRelease", 0 },
        { 0xAF79B008, "OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_28_enRelease", 0 },
        { 0xAFC6C4B4, "evSubSystem_OnButtonPressDTCCodeStatusListTypeItem", GetEventArgumentsForevSubSystem_OnButtonPressDTCCodeStatusListTypeItem },
        { 0xAFDB2FE5, "OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_GlassSettings_CA_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0xB07A71B2, "OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_GS_SwivelCalibration_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0xB11C8A96, "ev_onSwivel_GS_CA_YesTouch", 0 },
        { 0xB2076462, "OnNextLevelTransitionFininshed_SysSettingsToClockSettings", 0 },
        { 0xB23A5997, "OnGotoMainSoundSettings", 0 },
        { 0xB2B486E0, "OnActivationResMsg_AppHmi_System_SoftwareDownload_Pfo_SysSetFactReset_1", 0 },
        { 0xB34A0602, "OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_OSS_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0xB36968CE, "OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_DS_Layer_TouchArea_DSIncrease_ButtonWidget_enRelease", 0 },
        { 0xB39B84C7, "ev_onUserConfirmationForReboot_3linePopup", 0 },
        { 0xB59B20BF, "OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_32_enRelease", 0 },
        { 0xB630DDBD, "onTopPopupSurfaceQueued", GetEventArgumentsForonTopPopupSurfaceQueued },
        { 0xB71DB6A9, "OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_btn_AS_DecTreble_enRelease", 0 },
        { 0xB78D7AE0, "onPopupVisible", GetEventArgumentsForonPopupVisible },
        { 0xB798DA5A, "onSystemInstallationPopupSurfaceUnqueued", GetEventArgumentsForonSystemInstallationPopupSurfaceUnqueued },
        { 0xB95729C0, "OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_AS_SpeedDepVol_Layer_SpdDepVol_Lvl3_ButtonWidget2D_enRelease", 0 },
        { 0xB9E855A5, "OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_Back_enRelease", 0 },
        { 0xBBE6896C, "onPopupQueued", GetEventArgumentsForonPopupQueued },
        { 0xBCBAB806, "ev_onMIS_SystemUpdate_Abort", 0 },
        { 0xBCDB58A1, "onSystemInstallationPopupSurfaceInvisible", GetEventArgumentsForonSystemInstallationPopupSurfaceInvisible },
        { 0xBD091A78, "OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_GPS_tg_DayLightbn_TouchClick_enRelease", 0 },
        { 0xBE236FF7, "ev_OnButtonPressGammaMainListSwivelCalibration", 0 },
        { 0xC33BEC95, "ev_OnButtonPressOnSoftwareUpdateHistoryListItem", GetEventArgumentsForev_OnButtonPressOnSoftwareUpdateHistoryListItem },
        { 0xC4A893F7, "ev_onUSBStickValidationComplete", 0 },
        { 0xC5039804, "ev_OnButtonPress4mCabinA2VideoMixSource", 0 },
        { 0xC508F138, "OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_RVCContrastSettings_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0xC553E5AC, "OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_47_enRelease", 0 },
        { 0xC62D4CB7, "OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_CS_DateFmt_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0xC6A3829F, "ev_OnButtonPressSpeedLockVol", 0 },
        { 0xC6F6402F, "OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_SysSettings_Button_SoundSettings_enRelease", 0 },
        { 0xC70281BB, "OnActivateApplicationMsg", 0 },
        { 0xC8D83B8B, "onHMISubStateChanged_PHONE", 0 },
        { 0xC97C66BF, "OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_Manual_Button_Min_DECR_enRelease", 0 },
        { 0xCBB9BB9F, "OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_45_enRelease", 0 },
        { 0xCC798E20, "OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_EqlPreset_Rbtn_EqlPrst_Rock_enRelease", 0 },
        { 0xCD9348DC, "OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_btn_AS_IncBass_enRelease", 0 },
        { 0xCDBE0AD4, "onSystemInstallationPopupSurfaceVisible", GetEventArgumentsForonSystemInstallationPopupSurfaceVisible },
        { 0xCEF41805, "OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_ConfigurationVersion_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0xCFE52021, "OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_EU_Candidate_EU_14_enRelease", 0 },
        { 0xD00B1FD4, "OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_22_enRelease", 0 },
        { 0xD120809C, "OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_31_enRelease", 0 },
        { 0xD1225501, "OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_DateFmtEU_btn_DateFmtEU_Back_enLongPressRelease", 0 },
        { 0xD1EEE4AE, "ev_OnButtonPressSoundListTypeItem", 0 },
        { 0xD2334C55, "OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_AS_EqlPreset_Layer_EqlPrst_HipHop_ButtonWidget2D_enRelease", 0 },
        { 0xD59CD2C0, "OnSceneTranstoAS", 0 },
        { 0xD66C096D, "ev_OnButtonPressMeasurementTypeItem", GetEventArgumentsForev_OnButtonPressMeasurementTypeItem },
        { 0xD6AD87DA, "OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_18_enRelease", 0 },
        { 0xD6E4F553, "OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_DateFmtEU_Rbtn_DateFmtEU_2_enRelease", 0 },
        { 0xD6E837E0, "OnNextLevelTransitionFininshed_GPSToTimeZone", 0 },
        { 0xD74AE057, "OnGotoMainCabinASettings", 0 },
        { 0xD769A77C, "OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_AS_SpeedDepVol_Layer_SpdDepVol_Lvl2_ButtonWidget2D_enRelease", 0 },
        { 0xD9448639, "ev_OnButtonPressPrivateMode", 0 },
        { 0xD9988551, "OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_11_enRelease", 0 },
        { 0xD9B2912B, "OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_Button_SpeedDepVol_enRelease", 0 },
        { 0xD9B8A15D, "OnDisplayAudioSetting4Volume", 0 },
        { 0xDA6C7FD4, "ev_OnButtonPressOEMSettingItem", 0 },
        { 0xDA9724A9, "ev_SoftwareDownloadMode_FullUpdate", 0 },
        { 0xDB0D29F4, "onPopupUnqueued", GetEventArgumentsForonPopupUnqueued },
        { 0xDB861496, "OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_CS_TimeZone_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0xDB8EDCBA, "OnActivationResMsg_SystemSettings_PopupScenes_Pfo_GeneralMsg_Touch_1", 0 },
        { 0xDB9013ED, "OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_EU_Candidate_EU_15_enRelease", 0 },
        { 0xDBDE7200, "OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_GEX_Candidate_GEX_4_enRelease", 0 },
        { 0xDD62EA5B, "onActivateImageProviderRequest", GetEventArgumentsForonActivateImageProviderRequest },
        { 0xDE03E4F3, "OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_Back_enLongPressRelease", 0 },
        { 0xDE9448E3, "onAppStatusChanged_FOREGROUND", 0 },
        { 0xDE9A8E1C, "ev_OnButtonPressGammaLCDOnOffCADropItem", GetEventArgumentsForev_OnButtonPressGammaLCDOnOffCADropItem },
        { 0xDEBDBA98, "OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_audioSetting_CA_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0xE017647F, "OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_3_enRelease", 0 },
        { 0xE1CDB3C3, "ev_OnButtonPressAudioEquilizerPreset", 0 },
        { 0xE2418A6E, "OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_EqlPreset_Rbtn_EqlPrst_Flat_enRelease", 0 },
        { 0xE26B80F2, "OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_1_enRelease", 0 },
        { 0xE4658CFD, "onHMISubStateChanged_NO_DISPLAY", 0 },
        { 0xE54738ED, "OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_Manual_Button_Hr_IINC_enRepeatPressSecondary", 0 },
        { 0xE653CE2E, "ev_onUserConfirmation_5linePopup_No_tocuh", 0 },
        { 0xE656DF72, "ev_OnMISStageOneFailed", 0 },
        { 0xE71FD5BB, "ev_onSWSameVersion", 0 },
        { 0xE77FA7E9, "OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_4_enRelease", 0 },
        { 0xE7DCE080, "OnNextLevelTransitionFinished", 0 },
        { 0xE7EFF36A, "OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_37_enRelease", 0 },
        { 0xE81A7325, "OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_btn_AS_DecFader_enRelease", 0 },
        { 0xE87C955E, "OnPopup_Reset_System", 0 },
        { 0xE9A6D56C, "OnFadeAnimationFinished", 0 },
        { 0xEB0AE622, "OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_OEM_PIN_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0xEC31A0F7, "OnActivateSpeedLock_CP_Popup", 0 },
        { 0xECD46AD6, "OnButtonReactionMsg_AudioSetting_Scenes_SO_AS_btn_AS_back_enRelease", 0 },
        { 0xEDA60FCA, "OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_DateFmtEU_Rbtn_DateFmtEU_3_enRelease", 0 },
        { 0xEEC67B5A, "OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_EU_Candidate_EU_1_enRelease", 0 },
        { 0xEFA22F23, "ev_onMIS_ResultExtraction", GetEventArgumentsForev_onMIS_ResultExtraction },
        { 0xF0E525E2, "OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_8_enRelease", 0 },
        { 0xF11EAE44, "ev_SoftwareDownloadModeEngScreen_TouchareaBack", 0 },
        { 0xF38C5993, "ev_OnButtonPressDisplayTypeItem", 0 },
        { 0xF3C96D17, "onPopupTimerExpiry", GetEventArgumentsForonPopupTimerExpiry },
        { 0xF3E112A8, "OnPreviousLevelTransitionFinished_DateFormatCNToManual", 0 },
        { 0xF4B21FBE, "ev_OnButtonPressConfigVersionItem", 0 },
        { 0xF541AFCD, "OnActivityMsg_eActivityID_TUNER_SOUND_SETTINGS", 0 },
        { 0xF56C2662, "OnPreviousLevelTransitionFinished_SpeedDepVolTOSetting", 0 },
        { 0xF70A1512, "OnActivityMsg_eActivityID_MEDIA_SOUND_SETTINGS", 0 },
        { 0xF71E9D10, "OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_GPS_Button_CS_ManualMode_enRelease", 0 },
        { 0xF75E8902, "ev_onUserConfirmation_3linePopup_Auto_touch", 0 },
        { 0xF7A64C25, "OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_44_enRelease", 0 },
        { 0xF7C2F6EB, "ev_OnButtonPress4mCabinA2OSS", 0 },
        { 0xF7FF9993, "OnButtonReactionMsg_AppHmi_System_SysSettingsScenes_SO_MIC_AS_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0xF84B3BD1, "OnZoomOutFinished", 0 },
        { 0xF96478DC, "onHMISubStateChanged_CLOCK", 0 },
        { 0xFA2089CF, "OnActivationResMsg_Volume_PopUp_Scenes_So_VolumeArea_1", 0 },
        { 0xFB10DC7A, "OnSceneTranstoLanguage", 0 },
        { 0xFBEEA58F, "OnZoomInFinished", 0 },
        { 0xFC0D2293, "onCenterPopupSurfaceQueued", GetEventArgumentsForonCenterPopupSurfaceQueued },
        { 0xFC949046, "OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_LS_EU_Candidate_EU_8_enRelease", 0 },
        { 0xFCD1FE5A, "OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_10_enRelease", 0 },
        { 0xFE6323DF, "OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_16_enRelease", 0 },
        { 0xFF37F05A, "ev_onIncompatiblestickfound", 0 },
        { 0xFF401E0D, "OnButtonReactionMsg_SystemSettings_SysSettingsScenes_SO_SysSettings_Button_Display_enRelease", 0 },
        { 0xFF56604A, "OnButtonReactionMsg_ClockSetting_Scenes_SO_TimeZone_Rbtn_TimeZone_34_enRelease", 0 },
        { 0xFFFD4EF5, "OnButtonReactionMsg_ClockSetting_Scenes_SO_CS_DateFmtCN_Rbtn_DateFmtIN_2_enRelease", 0 },
    };
    const EventNameMapping* eventEntry = ::Courier::BinarySearch(eventId, events, 391, &EventNameMappingCmp);
    if (eventEntry && (eventId == eventEntry->mEventId)) {
        if (0 != eventEntry->mGetEventArguments) {
            eventEntry->mGetEventArguments(message, eventArguments);
        }
        return eventEntry->mEventName;
    }
    return 0;
}
#endif
// ------------------------------------------------------------------------
struct IdToNameMapping
{
    ::FeatStd::UInt32 mId;
    const ::FeatStd::Char* mName;
};

static ::FeatStd::Int IdToNameMappingCmp(::FeatStd::UInt32 id, const IdToNameMapping& nm)
{
    return (id == nm.mId) ? 0 : ((id < nm.mId) ? -1 : 1);
}

const ::FeatStd::Char * AppHmi_SystemStateMachineImpl::GetNameFromId(::FeatStd::UInt32 id)
{
    static IdToNameMapping names[62] = {
        { 0x03082C7D, "AppHmi_System#SysSettingsScenes#SO_SoftwareVersion_CIS" },
        { 0x0611AD1A, "AppHmi_System#SysSettingsScenes#SO_CS_TimeZone" },
        { 0x0FD7EF15, "AppHmi_System#SysSettingsScenes#SO_GS_SwivelCalibration" },
        { 0x13765772, "AppHmi_System#SoftwareDownload#Pfo_CabinAMonConnection" },
        { 0x14674FD5, "AppHmi_System#SysSettingsScenes#SO_AS_PrivateMode" },
        { 0x19B6E124, "AppHmi_System#SysSettingsScenes#SO_CS_DateFmt" },
        { 0x1ACC5072, "AppHmi_System#SoftwareDownload#Pfo_SwivelCalibration" },
        { 0x1BC6B6C4, "AppHmi_System#SysSettingsScenes#SO_MIC_AS" },
        { 0x1FDC32DA, "AppHmi_System#SoftwareDownload#Pfo_SpeedLock_CP" },
        { 0x202A2F99, "AppHmi_System#SoftwareDownload#PopUp_three_line_two_button_Swivel_GS_CA" },
        { 0x26948746, "AppHmi_System#SysSettingsScenes#SO_CS_GPS" },
        { 0x2C15B349, "AppHmi_System#SysSettingsScenes#SO_AS" },
        { 0x2CB9AA64, "AppHmi_System#SoftwareDownload#Pfo_2LineAbortStage2" },
        { 0x2E29DFB9, "AppHmi_System#SoftwareDownload#PopUp_two_line_single_button" },
        { 0x345BFA2C, "AppHmi_System#SysSettingsScenes#SystemInstallation" },
        { 0x38B3CE74, "AppHmi_System#SoftwareDownload#busy_screen" },
        { 0x39891759, "AppHmi_System#SoftwareDownload#Popup_Four_line_single_button" },
        { 0x431E8CD9, "AppHmi_System#Gadget_System#MASTER_GADGET_SYSTEM" },
        { 0x45D02CB4, "AppHmi_System#SysSettingsScenes#SO_AS_EqlPreset" },
        { 0x4C38947D, "AppHmi_System#SoftwareDownload#Pfo_SysInst_SubSys_Unavailable" },
        { 0x590262AE, "AppHmi_System#SysSettingsScenes#SO_ConfigurationVersion" },
        { 0x5C300984, "AppHmi_System#SysSettingsScenes#SO_OSS" },
        { 0x5E7E0B57, "AppHmi_System#SoftwareDownload#Pfo_SoftwareVersionFetchingError" },
        { 0x5FEBCCD0, "AppHmi_System#SoftwareDownload#PopUp_three_line_Swivel_GS_CA" },
        { 0x61A1BA87, "AppHmi_System#SysSettingsScenes#SO_VideoMixSource_CA" },
        { 0x6C71176B, "AppHmi_System#SysSettingsScenes#SO_CS_Manual" },
        { 0x6D204697, "AppHmi_System#SoftwareDownload#Pfo_SysSetFactReset" },
        { 0x6EC4592E, "AppHmi_System#SoftwareDownload#PopUp_three_line_single_button" },
        { 0x734498E5, "AppHmi_System#SoftwareDownload#SW_screen_1" },
        { 0x7C944F0C, "AppHmi_System#SysSettingsScenes#SO_DS" },
        { 0x7D8073E3, "AppHmi_System#SysSettingsScenes#SO_OSS_CA" },
        { 0x802110CA, "AppHmi_System#SysSettingsScenes#SO_GlassSettings_CA" },
        { 0x8E7AF063, "AppHmi_System#SoftwareDownload#PopUp_three_line_two_button" },
        { 0x94483D9A, "AppHmi_System#SoftwareDownload#PopUp_five_line_double_button" },
        { 0x957E0C74, "AppHmi_System#SoftwareDownload#Pfo_SysSetFactDefault" },
        { 0x99253B02, "AppHmi_System#SysSettingsScenes#SO_AudioSettings_CA" },
        { 0x99D2103B, "AppHmi_System#SysSettingsScenes#SO_LS_EU" },
        { 0xA033E284, "AppHmi_System#SoftwareDownload#PopUp_three_line_single_reboot_button" },
        { 0xAC5C491A, "AppHmi_System#SoftwareDownload#screen_6" },
        { 0xB0E66BC6, "AppHmi_System#SoftwareDownload#Pfo_SystemInstallation" },
        { 0xB684A8A3, "AppHmi_System#SoftwareDownload#Stage_one_MIS_SystemUpdate" },
        { 0xB7905CCD, "AppHmi_System#SettingsPopUp#Pfo_PrivateModeAudioSetting" },
        { 0xBAED3F28, "AppHmi_System#SysSettingsScenes#SO_LS_Nafta" },
        { 0xBE3EB889, "AppHmi_System#SoftwareDownload#Pfo_SysSetSupplierReset" },
        { 0xC284756A, "AppHmi_System#SoftwareDownload#screen_5" },
        { 0xC42C8688, "AppHmi_System#SysSettingsScenes#SO_RVCSettings" },
        { 0xC58BE038, "AppHmi_System#SysSettingsScenes#SO_DTCInformation" },
        { 0xC6C696E9, "AppHmi_System#SoftwareDownload#PopUp_six_line_two_button" },
        { 0xC890D6EF, "AppHmi_System#SysSettingsScenes#SO_AS_SpeedDepVol" },
        { 0xD174A733, "AppHmi_System#SoftwareDownload#SWUpdate_Update_Info" },
        { 0xD1A713AF, "AppHmi_System#SoftwareDownload#screen_4" },
        { 0xDDBE435D, "AppHmi_System#SysSettingsScenes#SO_SysSettings" },
        { 0xE2AB0E4C, "AppHmi_System#SysSettingsScenes#SO_SysSettings_CB" },
        { 0xE4F09EAE, "AppHmi_System#SoftwareDownload#PopUp_three_line_three_button" },
        { 0xE5BB5FDD, "AppHmi_System#SoftwareDownload#PopUp_two_line_two_button" },
        { 0xE5F03C41, "AppHmi_System#SoftwareDownload#screen_3" },
        { 0xE9EC2F69, "AppHmi_System#SysSettingsScenes#SO_RVCContrastSettings" },
        { 0xF09EAA33, "AppHmi_System#SysSettingsScenes#SO_SysSettings_CA" },
        { 0xF68543EE, "AppHmi_System#SysSettingsScenes#SO_OEM_PIN" },
        { 0xF7324E66, "AppHmi_System#SysSettingsScenes#SO_RVCBrightnessSettings" },
        { 0xFA1148CF, "AppHmi_System#SysSettingsScenes#SO_OEM_MENU" },
        { 0xFB274628, "AppHmi_System#SoftwareDownload#MIS_SystemUpdate_Progress" },
    };
    const IdToNameMapping *nameEntry = ::Courier::BinarySearch(id, names, 62, &IdToNameMappingCmp);
    if(nameEntry != 0 && id == nameEntry->mId) {
        return nameEntry->mName;
    }
    return "";
}

// ------------------------------------------------------------------------

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::acUpdatePopupText(::FeatStd::UInt8 aPopupTextID)
{
    Action_acUpdatePopupText(enPopUpType(aPopupTextID));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::acSystemInstallation()
{
    Action_acSystemInstallation();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::acSWUpdateAbortReboot()
{
    Action_acSWUpdateAbortReboot();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::acOEMPinOk()
{
    Action_acOEMPinOk();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::acStartUSBStickBinaryValidation()
{
    Action_acStartUSBStickBinaryValidation();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::acSetSoftwareUpdateType(::FeatStd::UInt32 aUpdateType)
{
    Action_acSetSoftwareUpdateType(enSoftwareUpdateType(aUpdateType));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::acEnableButtonsonNopopType()
{
    Action_acEnableButtonsonNopopType();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::acStartSoftwareDownload()
{
    Action_acStartSoftwareDownload();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::acSetReleaseFilter(::FeatStd::UInt32 aDownloadMode)
{
    Action_acSetReleaseFilter(enSoftwareDownloadMode(aDownloadMode));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::acStartMISStageOneUpdate()
{
    Action_acStartMISStageOneUpdate();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::acRVCEntryViewUpdate()
{
    Action_acRVCEntryViewUpdate();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::acRVCExitViewupdate()
{
    Action_acRVCExitViewupdate();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::acHandlePendingSWDL()
{
    Action_acHandlePendingSWDL();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::ChangeMeasurementvalueReq(::FeatStd::UInt32 aMeasurementOptions)
{
    Action_ChangeMeasurementvalueReq(enMenu(aMeasurementOptions));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::ChangeClockTimeformatReq(::FeatStd::UInt32 aTimeFormatOptions)
{
    Action_ChangeClockTimeformatReq(enTimeformatOption(aTimeFormatOptions));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::ChangeGpsClockTimeformatReq(::FeatStd::UInt32 aGpsTimeFormatOptions)
{
    Action_ChangeGpsClockTimeformatReq(enGpsClkTimeformatOption(aGpsTimeFormatOptions));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::ChangeGpsClockClkModeReq(::FeatStd::UInt32 aGpsClkClockModeOptions)
{
    Action_ChangeGpsClockClkModeReq(enGpsClkClockModeformatOption(aGpsClkClockModeOptions));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::ChangeClockTimeZoneReq(::FeatStd::UInt32 aSelectedTimeZoneItem)
{
    Action_ChangeClockTimeZoneReq(Courier::UInt16(aSelectedTimeZoneItem));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::ChangeClockformatReq(::FeatStd::UInt32 aClockFormatOptions)
{
    Action_ChangeClockformatReq(enClockformatOption(aClockFormatOptions));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::ChangeAuxlevelvalueReq(::FeatStd::UInt32 aAuxLevelOptions)
{
    Action_ChangeAuxlevelvalueReq(enAuxlevelOption(aAuxLevelOptions));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::ChangeDisplaySettingModevalueReq(::FeatStd::UInt32 aDisplaySettingModeOptions)
{
    Action_ChangeDisplaySettingModevalueReq(enDisplaySettingModeOption(aDisplaySettingModeOptions));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::ChangeLCDOnOff4GammaCASettingModevalReq(::FeatStd::UInt32 aLCDOnOffGammaCASettingModeOptions)
{
    Action_ChangeLCDOnOff4GammaCASettingModevalReq(enLCDOnOffGammaCASettingModeOption(aLCDOnOffGammaCASettingModeOptions));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::ChangeMonitorUpDown4GammaCASettingModevalReq(::FeatStd::UInt32 aMonitorUpDownGammaCASettingModeOptions)
{
    Action_ChangeMonitorUpDown4GammaCASettingModevalReq(enMonitorUpDownGammaCASettingModeOption(aMonitorUpDownGammaCASettingModeOptions));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_Activate_Home_Source()
{
    Action_Perform_Activate_Home_Source();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_Activate_RVC_Source()
{
    Action_Perform_Activate_RVC_Source();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_Activate_Home_Cabin_A()
{
    Action_Perform_Activate_Home_Cabin_A();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_Activate_Home_Cabin_B()
{
    Action_Perform_Activate_Home_Cabin_B();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_Hour_Dec()
{
    Action_Perform_Hour_Dec();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_Hour_Inc()
{
    Action_Perform_Hour_Inc();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_Minute_Dec()
{
    Action_Perform_Minute_Dec();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_Minute_Inc()
{
    Action_Perform_Minute_Inc();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_TimeFormat12H()
{
    Action_Perform_TimeFormat12H();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_TimeFormat24H()
{
    Action_Perform_TimeFormat24H();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_CLKSetMode_GPS()
{
    Action_Perform_CLKSetMode_GPS();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_CLKSetMode_Manual()
{
    Action_Perform_CLKSetMode_Manual();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::DateFormat_EU_1()
{
    Action_DateFormat_EU_1();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::DateFormat_EU_2()
{
    Action_DateFormat_EU_2();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::DateFormat_EU_3()
{
    Action_DateFormat_EU_3();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::DateFormat_EU_4()
{
    Action_DateFormat_EU_4();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::DateFormat_EU_5()
{
    Action_DateFormat_EU_5();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::DateFormat_EU_6()
{
    Action_DateFormat_EU_6();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::DateFormat_CN_1()
{
    Action_DateFormat_CN_1();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::DateFormat_CN_2()
{
    Action_DateFormat_CN_2();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Candidate_EU_1()
{
    Action_Candidate_EU_1();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Candidate_EU_2()
{
    Action_Candidate_EU_2();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Candidate_EU_3()
{
    Action_Candidate_EU_3();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Candidate_EU_4()
{
    Action_Candidate_EU_4();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Candidate_EU_5()
{
    Action_Candidate_EU_5();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Candidate_EU_6()
{
    Action_Candidate_EU_6();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Candidate_EU_7()
{
    Action_Candidate_EU_7();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Candidate_EU_8()
{
    Action_Candidate_EU_8();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Candidate_EU_9()
{
    Action_Candidate_EU_9();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Candidate_EU_10()
{
    Action_Candidate_EU_10();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Candidate_EU_11()
{
    Action_Candidate_EU_11();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Candidate_EU_12()
{
    Action_Candidate_EU_12();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Candidate_EU_13()
{
    Action_Candidate_EU_13();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Candidate_EU_14()
{
    Action_Candidate_EU_14();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Candidate_EU_15()
{
    Action_Candidate_EU_15();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::TimeZone_1()
{
    Action_TimeZone_1();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::TimeZone_2()
{
    Action_TimeZone_2();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::TimeZone_3()
{
    Action_TimeZone_3();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::TimeZone_4()
{
    Action_TimeZone_4();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::TimeZone_5()
{
    Action_TimeZone_5();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::TimeZone_6()
{
    Action_TimeZone_6();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::TimeZone_7()
{
    Action_TimeZone_7();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::TimeZone_8()
{
    Action_TimeZone_8();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::TimeZone_9()
{
    Action_TimeZone_9();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::TimeZone_10()
{
    Action_TimeZone_10();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::TimeZone_11()
{
    Action_TimeZone_11();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::TimeZone_12()
{
    Action_TimeZone_12();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::TimeZone_13()
{
    Action_TimeZone_13();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::TimeZone_14()
{
    Action_TimeZone_14();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::TimeZone_15()
{
    Action_TimeZone_15();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::TimeZone_16()
{
    Action_TimeZone_16();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::TimeZone_17()
{
    Action_TimeZone_17();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::TimeZone_18()
{
    Action_TimeZone_18();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::TimeZone_19()
{
    Action_TimeZone_19();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::TimeZone_20()
{
    Action_TimeZone_20();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::TimeZone_21()
{
    Action_TimeZone_21();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::TimeZone_22()
{
    Action_TimeZone_22();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::TimeZone_23()
{
    Action_TimeZone_23();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::TimeZone_24()
{
    Action_TimeZone_24();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::TimeZone_25()
{
    Action_TimeZone_25();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::TimeZone_26()
{
    Action_TimeZone_26();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::TimeZone_27()
{
    Action_TimeZone_27();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::TimeZone_28()
{
    Action_TimeZone_28();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::TimeZone_29()
{
    Action_TimeZone_29();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::TimeZone_30()
{
    Action_TimeZone_30();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::TimeZone_31()
{
    Action_TimeZone_31();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::TimeZone_32()
{
    Action_TimeZone_32();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::TimeZone_33()
{
    Action_TimeZone_33();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::TimeZone_34()
{
    Action_TimeZone_34();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::TimeZone_35()
{
    Action_TimeZone_35();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::TimeZone_36()
{
    Action_TimeZone_36();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::TimeZone_37()
{
    Action_TimeZone_37();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::TimeZone_38()
{
    Action_TimeZone_38();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::TimeZone_39()
{
    Action_TimeZone_39();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::TimeZone_40()
{
    Action_TimeZone_40();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::TimeZone_41()
{
    Action_TimeZone_41();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::TimeZone_42()
{
    Action_TimeZone_42();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::TimeZone_43()
{
    Action_TimeZone_43();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::TimeZone_44()
{
    Action_TimeZone_44();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::TimeZone_45()
{
    Action_TimeZone_45();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::TimeZone_46()
{
    Action_TimeZone_46();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::TimeZone_47()
{
    Action_TimeZone_47();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::TimeZone_48()
{
    Action_TimeZone_48();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::GoToGPS()
{
    Action_GoToGPS();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::GoToManual()
{
    Action_GoToManual();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_Update_SoundSetting_Entry(::FeatStd::UInt8 aEntryFromApp)
{
    Action_Perform_Update_SoundSetting_Entry(Courier::UInt8(aEntryFromApp));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_Touch()
{
    Action_Perform_Touch();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_SpeedLockTouch()
{
    Action_Perform_SpeedLockTouch();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_Bass_Dec()
{
    Action_Perform_Bass_Dec();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_Bass_Inc()
{
    Action_Perform_Bass_Inc();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_Treble_Dec()
{
    Action_Perform_Treble_Dec();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_Treble_Inc()
{
    Action_Perform_Treble_Inc();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_Balance_Inc()
{
    Action_Perform_Balance_Inc();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_Balance_Dec()
{
    Action_Perform_Balance_Dec();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_Fader_Inc()
{
    Action_Perform_Fader_Inc();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_Fader_Dec()
{
    Action_Perform_Fader_Dec();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::acPerformSwivelSetRequest(::FeatStd::UInt8 aSelectedModeItem)
{
    Action_acPerformSwivelSetRequest(Courier::UInt8(aSelectedModeItem));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::PerformCockpitMode(::FeatStd::UInt8 aCockpitModeStatus)
{
    Action_PerformCockpitMode(enBatterySaverModeType(aCockpitModeStatus));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::acSendPopupStatus(::FeatStd::UInt32 aActiveViewId, ::FeatStd::UInt8 aPopupStatus)
{
    Action_acSendPopupStatus(Courier::UInt32(aActiveViewId), Courier::UInt8(aPopupStatus));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::acSendPluginReq()
{
    Action_acSendPluginReq();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_Aux_Loud()
{
    Action_Perform_Aux_Loud();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_Aux_Middle()
{
    Action_Perform_Aux_Middle();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_Aux_Quiet()
{
    Action_Perform_Aux_Quiet();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_Beep()
{
    Action_Perform_Beep();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_Touch_Click()
{
    Action_Perform_Touch_Click();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_Speed_Off()
{
    Action_Perform_Speed_Off();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_Speed_Level1()
{
    Action_Perform_Speed_Level1();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_Speed_Level2()
{
    Action_Perform_Speed_Level2();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_Speed_Level3()
{
    Action_Perform_Speed_Level3();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_Equilizer_Flat()
{
    Action_Perform_Equilizer_Flat();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_Equilizer_Pop()
{
    Action_Perform_Equilizer_Pop();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_Equilizer_Rock()
{
    Action_Perform_Equilizer_Rock();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_Equilizer_Hiphop()
{
    Action_Perform_Equilizer_Hiphop();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_Equilizer_Classic()
{
    Action_Perform_Equilizer_Classic();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_Equilizer_Jazz()
{
    Action_Perform_Equilizer_Jazz();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_Back()
{
    Action_Perform_Back();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::SetLanguageReq()
{
    Action_SetLanguageReq();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Candidate_CN_1()
{
    Action_Candidate_CN_1();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Candidate_CN_2()
{
    Action_Candidate_CN_2();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Candidate_GEX_1()
{
    Action_Candidate_GEX_1();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Candidate_GEX_2()
{
    Action_Candidate_GEX_2();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Candidate_GEX_3()
{
    Action_Candidate_GEX_3();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Candidate_GEX_4()
{
    Action_Candidate_GEX_4();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Candidate_GEX_5()
{
    Action_Candidate_GEX_5();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_Switch_SoundSettingsApp()
{
    Action_Perform_Switch_SoundSettingsApp();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_Switch_SecurityPINApp()
{
    Action_Perform_Switch_SecurityPINApp();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_Switch_RearViewCamera_SettingsApp()
{
    Action_Perform_Switch_RearViewCamera_SettingsApp();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_Switch_Media_SettingsApp()
{
    Action_Perform_Switch_Media_SettingsApp();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_Switch_Tuner_SettingsApp()
{
    Action_Perform_Switch_Tuner_SettingsApp();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_Brightness_Dec()
{
    Action_Perform_Brightness_Dec();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_Brightness_Inc()
{
    Action_Perform_Brightness_Inc();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_ClockHour_Dec()
{
    Action_Perform_ClockHour_Dec();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_ClockHour_Inc()
{
    Action_Perform_ClockHour_Inc();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_ClockMinute_Dec()
{
    Action_Perform_ClockMinute_Dec();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_ClockMinute_Inc()
{
    Action_Perform_ClockMinute_Inc();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_MediaRadioBack4mAudio()
{
    Action_Perform_MediaRadioBack4mAudio();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_VideoMixedSourceBack4mCabinHome()
{
    Action_Perform_VideoMixedSourceBack4mCabinHome();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_LevelOff()
{
    Action_Perform_LevelOff();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_LevelOne()
{
    Action_Perform_LevelOne();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_LevelTwo()
{
    Action_Perform_LevelTwo();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_LevelThree()
{
    Action_Perform_LevelThree();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_PrivateModeLevelOne()
{
    Action_Perform_PrivateModeLevelOne();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_PrivateModeLevelTwo()
{
    Action_Perform_PrivateModeLevelTwo();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_PrivateModeLevelThree()
{
    Action_Perform_PrivateModeLevelThree();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_EqlPrstFlat()
{
    Action_Perform_EqlPrstFlat();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_EqlPrstPop()
{
    Action_Perform_EqlPrstPop();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_EqlPrstRock()
{
    Action_Perform_EqlPrstRock();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_EqlPrstHiphop()
{
    Action_Perform_EqlPrstHiphop();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_EqlPrstClassic()
{
    Action_Perform_EqlPrstClassic();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_EqlPrstJazz()
{
    Action_Perform_EqlPrstJazz();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_DTCSubSystemCMC19SwDetailsMsg(::FeatStd::UInt32 aCurrentSubSystemType)
{
    Action_Perform_DTCSubSystemCMC19SwDetailsMsg(Courier::UInt32(aCurrentSubSystemType));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::acPerformListRefresh(::FeatStd::UInt32 aListId)
{
    Action_acPerformListRefresh(Courier::UInt32(aListId));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_ClkDateFmt1()
{
    Action_Perform_ClkDateFmt1();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Notify_Init_Finished()
{
    Action_Notify_Init_Finished();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_ClkDateFmt2()
{
    Action_Perform_ClkDateFmt2();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_ClkDateFmt3()
{
    Action_Perform_ClkDateFmt3();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_ClkDateFmt4()
{
    Action_Perform_ClkDateFmt4();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_ClkDateFmt5()
{
    Action_Perform_ClkDateFmt5();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_ClkDateFmt6()
{
    Action_Perform_ClkDateFmt6();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_SettingSceneMsg(::FeatStd::UInt16 aSettingType)
{
    Action_Perform_SettingSceneMsg(Courier::UInt16(aSettingType));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::acStartPopupTimer(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aTimeout)
{
    Action_acStartPopupTimer(Courier::UInt32(aViewId), Courier::UInt32(aTimeout));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::acRebootOnSWDLComplete()
{
    Action_acRebootOnSWDLComplete();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::acHandleRebootOnUSBRemoval()
{
    Action_acHandleRebootOnUSBRemoval();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::acReqSWDLContextSwitchRequest()
{
    Action_acReqSWDLContextSwitchRequest();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_SWUpdate_Downgrade()
{
    Action_Perform_SWUpdate_Downgrade();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_DisplayClockScene()
{
    Action_Perform_DisplayClockScene();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_FactoryResetSM()
{
    Action_Perform_FactoryResetSM();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::Perform_FactoryResetSMBeep()
{
    Action_Perform_FactoryResetSMBeep();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacChangeLanguageReq(::FeatStd::Int32 aLanguageId)
{
    Action_gacChangeLanguageReq(enLanguageId(aLanguageId));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacHideFocusInViewReq(::FeatStd::UInt32 aView)
{
    Action_gacHideFocusInViewReq(::Courier::ViewId(AppHmi_SystemStateMachineImpl::GetNameFromId(aView)));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::NextLevelTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_NextLevelTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::PreviousLevelTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_PreviousLevelTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::DualViewLeftTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_DualViewLeftTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::DualViewRightTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_DualViewRightTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::PageFlipBackTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_PageFlipBackTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::PageFlipFrontTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_PageFlipFrontTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::ZoomInTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView, ::FeatStd::Int8 aPos)
{
    Action_ZoomInTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView), Candera::UInt8(aPos));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::ZoomOutTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView, ::FeatStd::Int8 aPos)
{
    Action_ZoomOutTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView), Candera::UInt8(aPos));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::FadeTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_FadeTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacWaitAnimationStartReq()
{
    Action_gacWaitAnimationStartReq();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::acFocusOnRightEncoderReqUpd(bool aIsFocusUsed)
{
    Action_acFocusOnRightEncoderReqUpd(bool(aIsFocusUsed));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::acSetGadgetSceenActiveStatus(bool aIsGadgetAtive)
{
    Action_acSetGadgetSceenActiveStatus(bool(aIsGadgetAtive));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::acHKNotificationMsg(::FeatStd::Int8 aHKCode, ::FeatStd::Int8 aHKState)
{
    Action_acHKNotificationMsg(Courier::UInt8(aHKCode), Courier::UInt8(aHKState));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::acPerform_CloseAllDropdowns()
{
    Action_acPerform_CloseAllDropdowns();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::acPerform_CloseDropdown(::FeatStd::UInt32 aListId)
{
    Action_acPerform_CloseDropdown(::Courier::UInt32(aListId));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::acPerform_OpenDropdown(::FeatStd::UInt32 aListId)
{
    Action_acPerform_OpenDropdown(::Courier::UInt32(aListId));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::acPerform_ToggleDropdown(::FeatStd::UInt32 aListId)
{
    Action_acPerform_ToggleDropdown(::Courier::UInt32(aListId));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::acStartAppPopupTimer(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aTimeout)
{
    Action_acStartAppPopupTimer(Courier::UInt32(aViewId), Courier::UInt32(aTimeout));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::acStopAppPopupTimer(::FeatStd::UInt32 aViewId)
{
    Action_acStopAppPopupTimer(Courier::UInt32(aViewId));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::acPostBeep(::FeatStd::Int8 aBeepType)
{
    Action_acPostBeep(Courier::Int32(aBeepType));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacCheckToClosePopup(::FeatStd::UInt32 aPopupId)
{
    Action_gacCheckToClosePopup(Courier::UInt32(aPopupId));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::acRestartAppPopupTimer(::FeatStd::UInt32 aViewId)
{
    Action_acRestartAppPopupTimer(Courier::UInt32(aViewId));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacContextSwitchBackRes(::FeatStd::UInt32 aSwitchId)
{
    Action_gacContextSwitchBackRes(Courier::UInt32(aSwitchId));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacContextSwitchCompleteRes(::FeatStd::UInt32 aSwitchId)
{
    Action_gacContextSwitchCompleteRes(Courier::UInt32(aSwitchId));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacContextSwitchFailedRes(::FeatStd::UInt32 aSwitchId)
{
    Action_gacContextSwitchFailedRes(Courier::UInt32(aSwitchId));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacContextSwitchDoneRes(::FeatStd::UInt32 aSwitchId)
{
    Action_gacContextSwitchDoneRes(Courier::UInt32(aSwitchId));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacContextSwitchOutReq(::FeatStd::UInt32 aTargetContextId, ::FeatStd::UInt32 aSourceContextId, ::FeatStd::UInt32 aTargetAppId)
{
    Action_gacContextSwitchOutReq(Courier::UInt32(aTargetContextId), Courier::UInt32(aSourceContextId), Courier::UInt32(aTargetAppId));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacCurrentScreenDisplayReq()
{
    Action_gacCurrentScreenDisplayReq();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacLaunchBarDisplayReq(bool aVisibility)
{
    Action_gacLaunchBarDisplayReq(bool(aVisibility));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacNavTBTSwipe()
{
    Action_gacNavTBTSwipe();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacPerformListBtnRightEncoderChangeUpd(::FeatStd::Int8 aSteps, ::FeatStd::UInt32 aListId, ::FeatStd::UInt32 aRowId, ::FeatStd::UInt32 aColumnId)
{
    Action_gacPerformListBtnRightEncoderChangeUpd(Courier::Int8(aSteps), Courier::UInt32(aListId), Courier::UInt32(aRowId), Courier::UInt32(aColumnId));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacScrollListUp()
{
    Action_gacScrollListUp();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacScrollListDown()
{
    Action_gacScrollListDown();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacScrollPageUp()
{
    Action_gacScrollPageUp();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacScrollPageDown()
{
    Action_gacScrollPageDown();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacScrollListFocusUp(::FeatStd::UInt32 aListId)
{
    Action_gacScrollListFocusUp(Courier::UInt32(aListId));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacScrollListFocusDown(::FeatStd::UInt32 aListId)
{
    Action_gacScrollListFocusDown(Courier::UInt32(aListId));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacPerformListFocusLockDataResetUpd()
{
    Action_gacPerformListFocusLockDataResetUpd();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacSetApplicationMode(::FeatStd::UInt32 aModeId)
{
    Action_gacSetApplicationMode(Courier::UInt32(aModeId));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacSpellerBbehaviorReq(bool aEnable)
{
    Action_gacSpellerBbehaviorReq(bool(aEnable));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacStatusBarDisplayReq(bool aVisibility, ::FeatStd::Int32 aHeaderType)
{
    Action_gacStatusBarDisplayReq(bool(aVisibility), Courier::Int32(aHeaderType));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacTBTRetriggerAcousticOutput()
{
    Action_gacTBTRetriggerAcousticOutput();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacWaitAnimationStopReq()
{
    Action_gacWaitAnimationStopReq();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacViewCreateReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewCreateReq(::Courier::ViewId(AppHmi_SystemStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacViewCreateAllReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewCreateAllReq(::Courier::ViewId(AppHmi_SystemStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacViewDestroyReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewDestroyReq(::Courier::ViewId(AppHmi_SystemStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacViewClearReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewClearReq(::Courier::ViewId(AppHmi_SystemStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacViewShowReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewShowReq(::Courier::ViewId(AppHmi_SystemStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacViewHideReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewHideReq(::Courier::ViewId(AppHmi_SystemStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacViewCreateWithoutLoadReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewCreateWithoutLoadReq(::Courier::ViewId(AppHmi_SystemStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacViewAsyncLoadReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewAsyncLoadReq(::Courier::ViewId(AppHmi_SystemStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacViewActivateWithoutRenderingReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewActivateWithoutRenderingReq(::Courier::ViewId(AppHmi_SystemStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacPopupCreateAndSBShowReq(::FeatStd::UInt32 aViewId)
{
    Action_gacPopupCreateAndSBShowReq(::Courier::ViewId(AppHmi_SystemStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacPopupCreateAndSBShowReqForMultiDisplay(::FeatStd::UInt32 aPopupDisplayID, ::FeatStd::UInt32 aViewId)
{
    Action_gacPopupCreateAndSBShowReqForMultiDisplay(Courier::UInt32(aPopupDisplayID), ::Courier::ViewId(AppHmi_SystemStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacPopupSBCloseReq(::FeatStd::UInt32 aViewId)
{
    Action_gacPopupSBCloseReq(::Courier::ViewId(AppHmi_SystemStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacPopupSBCloseReqForMultiDisplay(::FeatStd::UInt32 aPopupDisplayID, ::FeatStd::UInt32 aViewId)
{
    Action_gacPopupSBCloseReqForMultiDisplay(Courier::UInt32(aPopupDisplayID), ::Courier::ViewId(AppHmi_SystemStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacPopupRestartTimerReq(::FeatStd::UInt32 aViewId)
{
    Action_gacPopupRestartTimerReq(::Courier::ViewId(AppHmi_SystemStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacPopupRestartTimerReqForMultiDisplay(::FeatStd::UInt32 aPopupDisplayID, ::FeatStd::UInt32 aViewId)
{
    Action_gacPopupRestartTimerReqForMultiDisplay(Courier::UInt32(aPopupDisplayID), ::Courier::ViewId(AppHmi_SystemStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacViewCreateAndShowReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewCreateAndShowReq(::Courier::ViewId(AppHmi_SystemStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacViewHideAndDestroyReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewHideAndDestroyReq(::Courier::ViewId(AppHmi_SystemStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacSceneTransitionEnter(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aHint)
{
    Action_gacSceneTransitionEnter(::Courier::ViewId(AppHmi_SystemStateMachineImpl::GetNameFromId(aViewId)), Courier::UInt32(aHint));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacSceneTransitionLeave(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aHint)
{
    Action_gacSceneTransitionLeave(::Courier::ViewId(AppHmi_SystemStateMachineImpl::GetNameFromId(aViewId)), Courier::UInt32(aHint));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacDisplayStatusLineReq(::FeatStd::Int32 aDisplayRegionType)
{
    Action_gacDisplayStatusLineReq(Courier::Int32(aDisplayRegionType));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacHideStatusLineReq(::FeatStd::Int32 aDisplayRegionType)
{
    Action_gacHideStatusLineReq(Courier::Int32(aDisplayRegionType));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacDisplayFooterLineReq()
{
    Action_gacDisplayFooterLineReq();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacHideFooterLineReq()
{
    Action_gacHideFooterLineReq();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacDisplayStatusLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID)
{
    Action_gacDisplayStatusLineMultiDisplayReq(Courier::Int32(aDisplayRegionType), Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacHideStatusLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID)
{
    Action_gacHideStatusLineMultiDisplayReq(Courier::Int32(aDisplayRegionType), Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacDisplayFooterLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID)
{
    Action_gacDisplayFooterLineMultiDisplayReq(Courier::Int32(aDisplayRegionType), Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacHideFooterLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID)
{
    Action_gacHideFooterLineMultiDisplayReq(Courier::Int32(aDisplayRegionType), Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacRegisterForCloseOnTouchSession(::FeatStd::UInt32 aViewId)
{
    Action_gacRegisterForCloseOnTouchSession(::Courier::ViewId(AppHmi_SystemStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacDeregisterForCloseOnTouchSessionReq(::FeatStd::UInt32 aViewId)
{
    Action_gacDeregisterForCloseOnTouchSessionReq(::Courier::ViewId(AppHmi_SystemStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacPopupFilterPrioEnableReq(::FeatStd::UInt32 aPrio)
{
    Action_gacPopupFilterPrioEnableReq(Courier::UInt32(aPrio));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacPopupFilterAllEnableReq()
{
    Action_gacPopupFilterAllEnableReq();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacPopupFilterDisableReq()
{
    Action_gacPopupFilterDisableReq();
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacProfileChange(::FeatStd::Int8 aProfile)
{
    Action_gacProfileChange(Courier::UInt32(aProfile));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacPopupFilterPrioEnableReqForDisplay(::FeatStd::UInt32 aPrio, ::FeatStd::UInt32 aDisplayID)
{
    Action_gacPopupFilterPrioEnableReqForDisplay(Courier::UInt32(aPrio), Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacPopupFilterAllEnableReqForDisplay(::FeatStd::UInt32 aDisplayID)
{
    Action_gacPopupFilterAllEnableReqForDisplay(Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacPopupFilterDisableReqForDisplay(::FeatStd::UInt32 aDisplayID)
{
    Action_gacPopupFilterDisableReqForDisplay(Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacStartSceneTransitionAnimation(::FeatStd::UInt32 aSourceView, ::FeatStd::UInt32 aDestinationView, ::FeatStd::UInt32 aUserData1, ::FeatStd::Int8 aUserData2)
{
    Action_gacStartSceneTransitionAnimation(::Courier::ViewId(AppHmi_SystemStateMachineImpl::GetNameFromId(aSourceView)), ::Courier::ViewId(AppHmi_SystemStateMachineImpl::GetNameFromId(aDestinationView)), Courier::UInt32(aUserData1), Courier::Int8(aUserData2));
}

// ------------------------------------------------------------------------
void AppHmi_SystemStateMachineImpl::gacDecrementActiveAnimationCount()
{
    Action_gacDecrementActiveAnimationCount();
}
#ifdef CIT_SIMULATION
struct ActionMapping
{
    ::FeatStd::UInt32 mHashId;
    bool (*mActionCallHandler)(const ::Json::Value& parameters, ::Json::Value &response);
};

static ::FeatStd::Int ActionMappingCmp(::FeatStd::UInt32 hash, const ActionMapping& am)
{
    return (hash == am.mHashId) ? 0 : ((hash < am.mHashId) ? -1 : 1);
}

bool AppHmi_SystemStateMachineImpl::CallAction(const ::FeatStd::Char* actionName, const ::Json::Value& parameters, ::Json::Value &response)
{
    static ActionMapping actions[274] = {
        { 0x00452679, CallAction_TimeZone_24 },
        { 0x030C7C97, CallAction_Perform_ClockMinute_Dec },
        { 0x04EE30AB, CallAction_TimeZone_11 },
        { 0x074CBC41, CallAction_Perform_ClkDateFmt4 },
        { 0x084B4370, CallAction_DateFormat_EU_2 },
        { 0x0884F877, CallAction_gacScrollListUp },
        { 0x090A5555, CallAction_Candidate_GEX_3 },
        { 0x090A895B, CallAction_gacScrollListFocusDown },
        { 0x09EF60F3, CallAction_ChangeLCDOnOff4GammaCASettingModevalReq },
        { 0x0A4C5DC9, CallAction_gacDisplayStatusLineMultiDisplayReq },
        { 0x0AA2AD61, CallAction_SetLanguageReq },
        { 0x0C279721, CallAction_gacDecrementActiveAnimationCount },
        { 0x0E779EAD, CallAction_Candidate_EU_4 },
        { 0x0E8826CB, CallAction_TimeZone_46 },
        { 0x0F2A7635, CallAction_Perform_Speed_Level3 },
        { 0x11915CFE, CallAction_acStopAppPopupTimer },
        { 0x136A5474, CallAction_acRebootOnSWDLComplete },
        { 0x13F4E126, CallAction_DateFormat_CN_1 },
        { 0x15061065, CallAction_gacViewShowReq },
        { 0x1642D354, CallAction_TimeZone_18 },
        { 0x1661D2B2, CallAction_TimeZone_29 },
        { 0x16A2E01F, CallAction_DateFormat_EU_3 },
        { 0x186A69F1, CallAction_gacWaitAnimationStopReq },
        { 0x187DA604, CallAction_acPerform_OpenDropdown },
        { 0x18A2B303, CallAction_Candidate_EU_1 },
        { 0x1A4477EE, CallAction_acSetReleaseFilter },
        { 0x1BC6E0A9, CallAction_ZoomInTransition },
        { 0x1E17C937, CallAction_Perform_LevelTwo },
        { 0x1E8F6315, CallAction_TimeZone_20 },
        { 0x1E9CE2A8, CallAction_TimeZone_35 },
        { 0x20CFDB3D, CallAction_Perform_LevelThree },
        { 0x20DFC96D, CallAction_Perform_DisplayClockScene },
        { 0x21E3828E, CallAction_gacDisplayStatusLineReq },
        { 0x248B9DC7, CallAction_Perform_Bass_Inc },
        { 0x251DE22F, CallAction_gacContextSwitchCompleteRes },
        { 0x254E0D94, CallAction_gacViewHideReq },
        { 0x258104C2, CallAction_DualViewLeftTransition },
        { 0x2589E7D0, CallAction_Perform_SettingSceneMsg },
        { 0x264B8E81, CallAction_gacPopupRestartTimerReqForMultiDisplay },
        { 0x2764D78F, CallAction_acEnableButtonsonNopopType },
        { 0x27CE647F, CallAction_gacScrollListFocusUp },
        { 0x288577D9, CallAction_TimeZone_17 },
        { 0x299A7201, CallAction_Perform_MediaRadioBack4mAudio },
        { 0x29D14586, CallAction_gacDisplayFooterLineMultiDisplayReq },
        { 0x2A1E6CB2, CallAction_gacDeregisterForCloseOnTouchSessionReq },
        { 0x2AE288D8, CallAction_gacViewDestroyReq },
        { 0x2AEC5796, CallAction_Candidate_EU_2 },
        { 0x2F2B504B, CallAction_Perform_VideoMixedSourceBack4mCabinHome },
        { 0x2F2F1A65, CallAction_Perform_EqlPrstPop },
        { 0x30C8D840, CallAction_gacStartSceneTransitionAnimation },
        { 0x325BE13A, CallAction_gacViewCreateReq },
        { 0x334571BF, CallAction_acHKNotificationMsg },
        { 0x33BE5F33, CallAction_TimeZone_3 },
        { 0x35146BE6, CallAction_Candidate_EU_7 },
        { 0x35D254A9, CallAction_acHandlePendingSWDL },
        { 0x35E42D75, CallAction_acSystemInstallation },
        { 0x39597C6D, CallAction_TimeZone_41 },
        { 0x39E940F1, CallAction_Perform_Switch_Tuner_SettingsApp },
        { 0x3B571C9C, CallAction_TimeZone_26 },
        { 0x3BB18A69, CallAction_gacPopupFilterAllEnableReq },
        { 0x3C6FCAAF, CallAction_Perform_Aux_Middle },
        { 0x3C72F3A8, CallAction_acStartPopupTimer },
        { 0x3E4CE5A1, CallAction_gacContextSwitchDoneRes },
        { 0x3E7F9726, CallAction_gacSceneTransitionEnter },
        { 0x3E918730, CallAction_ChangeClockformatReq },
        { 0x3F1424F6, CallAction_TimeZone_14 },
        { 0x3FA50285, CallAction_Perform_Minute_Inc },
        { 0x41201119, CallAction_acStartAppPopupTimer },
        { 0x43094BDE, CallAction_Perform_EqlPrstJazz },
        { 0x432EB936, CallAction_DateFormat_EU_1 },
        { 0x454B0C53, CallAction_Candidate_EU_8 },
        { 0x45C2033E, CallAction_TimeZone_9 },
        { 0x47ACD4A1, CallAction_acReqSWDLContextSwitchRequest },
        { 0x484634EA, CallAction_Perform_Back },
        { 0x48C73F4D, CallAction_Perform_Treble_Dec },
        { 0x49032513, CallAction_Perform_Activate_Home_Cabin_A },
        { 0x4E0741FC, CallAction_TimeZone_25 },
        { 0x4ED683E2, CallAction_Perform_Equilizer_Rock },
        { 0x4F8820CD, CallAction_Candidate_EU_5 },
        { 0x5010B4D9, CallAction_Perform_Switch_RearViewCamera_SettingsApp },
        { 0x50CA4862, CallAction_TimeZone_13 },
        { 0x512C8141, CallAction_GoToGPS },
        { 0x53363749, CallAction_Perform_Switch_Media_SettingsApp },
        { 0x53DEE53D, CallAction_acPerformSwivelSetRequest },
        { 0x545D861D, CallAction_acOEMPinOk },
        { 0x5483A0C1, CallAction_TimeZone_8 },
        { 0x56A8631B, CallAction_Perform_Hour_Dec },
        { 0x56B3ED37, CallAction_acSWUpdateAbortReboot },
        { 0x573EB339, CallAction_gacContextSwitchFailedRes },
        { 0x576F70D9, CallAction_Perform_LevelOff },
        { 0x577F546C, CallAction_TimeZone_37 },
        { 0x57AA275B, CallAction_gacViewCreateWithoutLoadReq },
        { 0x59148CB0, CallAction_FadeTransition },
        { 0x593D5870, CallAction_TimeZone_22 },
        { 0x59C82D8E, CallAction_NextLevelTransition },
        { 0x59F03621, CallAction_gacChangeLanguageReq },
        { 0x5E254F57, CallAction_Perform_Activate_Home_Cabin_B },
        { 0x6040CA3F, CallAction_TimeZone_45 },
        { 0x60E513C0, CallAction_gacTBTRetriggerAcousticOutput },
        { 0x61F5C5A8, CallAction_Candidate_EU_6 },
        { 0x6216FF07, CallAction_acSetSoftwareUpdateType },
        { 0x629132A7, CallAction_gacPopupFilterDisableReq },
        { 0x63347532, CallAction_Perform_Switch_SecurityPINApp },
        { 0x638648CD, CallAction_Perform_Switch_SoundSettingsApp },
        { 0x638DEDE9, CallAction_TimeZone_12 },
        { 0x65A9F0C1, CallAction_TimeZone_36 },
        { 0x65C7BA3F, CallAction_ChangeMonitorUpDown4GammaCASettingModevalReq },
        { 0x67507752, CallAction_Perform_Equilizer_Flat },
        { 0x6784218F, CallAction_Perform_Equilizer_Jazz },
        { 0x67B7653B, CallAction_gacDisplayFooterLineReq },
        { 0x6844F790, CallAction_Perform_LevelOne },
        { 0x68F477DE, CallAction_TimeZone_21 },
        { 0x6BF5D9A3, CallAction_Candidate_CN_2 },
        { 0x6F1478DB, CallAction_PerformCockpitMode },
        { 0x6FF68248, CallAction_ChangeGpsClockClkModeReq },
        { 0x72C16F40, CallAction_TimeZone_44 },
        { 0x74AA46A5, CallAction_acRVCEntryViewUpdate },
        { 0x750CBA63, CallAction_Perform_PrivateModeLevelOne },
        { 0x7531D066, CallAction_Notify_Init_Finished },
        { 0x753E0FE1, CallAction_TimeZone_31 },
        { 0x75E49D1D, CallAction_gacPerformListFocusLockDataResetUpd },
        { 0x7626A6D8, CallAction_Perform_Aux_Loud },
        { 0x76EE4CA4, CallAction_gacHideStatusLineMultiDisplayReq },
        { 0x777542B4, CallAction_GoToManual },
        { 0x788D17E7, CallAction_TimeZone_19 },
        { 0x78A21047, CallAction_Candidate_EU_15 },
        { 0x791DF896, CallAction_acPerform_CloseAllDropdowns },
        { 0x7B744D2E, CallAction_ChangeClockTimeformatReq },
        { 0x7D7B49B4, CallAction_acFocusOnRightEncoderReqUpd },
        { 0x7EE4AB88, CallAction_gacPopupRestartTimerReq },
        { 0x81CF35D2, CallAction_acStartSoftwareDownload },
        { 0x82D15005, CallAction_PageFlipBackTransition },
        { 0x82F3AB4C, CallAction_TimeZone_30 },
        { 0x86589B40, CallAction_Perform_ClockHour_Inc },
        { 0x881D2454, CallAction_gacPopupFilterAllEnableReqForDisplay },
        { 0x8A7FC2A5, CallAction_Perform_ClkDateFmt5 },
        { 0x8D3D1233, CallAction_TimeZone_4 },
        { 0x8D7B31EC, CallAction_acSendPluginReq },
        { 0x8D8FE976, CallAction_Perform_TimeFormat24H },
        { 0x8E1BDBA2, CallAction_Perform_EqlPrstRock },
        { 0x8E5F3C37, CallAction_Perform_Brightness_Dec },
        { 0x8FF2BB2A, CallAction_acRVCExitViewupdate },
        { 0x91BB105A, CallAction_gacLaunchBarDisplayReq },
        { 0x93218F8C, CallAction_gacContextSwitchOutReq },
        { 0x93346A4E, CallAction_Perform_CLKSetMode_Manual },
        { 0x948F96CC, CallAction_gacScrollListDown },
        { 0x95A6A1E7, CallAction_Perform_Beep },
        { 0x96350312, CallAction_acSetGadgetSceenActiveStatus },
        { 0x96D3C730, CallAction_gacPopupSBCloseReqForMultiDisplay },
        { 0x97624DC7, CallAction_Candidate_EU_14 },
        { 0x99258E0B, CallAction_gacStatusBarDisplayReq },
        { 0x99483447, CallAction_Candidate_CN_1 },
        { 0x9CC96738, CallAction_Perform_ClkDateFmt6 },
        { 0x9CEBC471, CallAction_ChangeGpsClockTimeformatReq },
        { 0x9D20E10A, CallAction_TimeZone_10 },
        { 0x9F7F14FC, CallAction_ChangeMeasurementvalueReq },
        { 0x9F87F08B, CallAction_acPostBeep },
        { 0x9FA26D73, CallAction_gacPopupFilterDisableReqForDisplay },
        { 0xA0A6F9FA, CallAction_gacViewHideAndDestroyReq },
        { 0xA0EB02B8, CallAction_Perform_Equilizer_Hiphop },
        { 0xA13E9A5F, CallAction_Perform_Speed_Level2 },
        { 0xA172CF4E, CallAction_Perform_Activate_Home_Source },
        { 0xA52BE95A, CallAction_Candidate_EU_13 },
        { 0xA6038545, CallAction_DateFormat_CN_2 },
        { 0xA6480D6E, CallAction_Perform_FactoryResetSMBeep },
        { 0xA7B62A65, CallAction_gacPopupFilterPrioEnableReqForDisplay },
        { 0xA84DC23C, CallAction_gacHideFocusInViewReq },
        { 0xA9C7F42F, CallAction_gacHideStatusLineReq },
        { 0xAB49461E, CallAction_gacViewCreateAndShowReq },
        { 0xAC6057DE, CallAction_Perform_DTCSubSystemCMC19SwDetailsMsg },
        { 0xAC70CE46, CallAction_Perform_Treble_Inc },
        { 0xAD2D379A, CallAction_ChangeClockTimeZoneReq },
        { 0xAD947FF9, CallAction_gacCurrentScreenDisplayReq },
        { 0xAE2D5E16, CallAction_Candidate_EU_9 },
        { 0xAE48BF55, CallAction_DualViewRightTransition },
        { 0xAFB14254, CallAction_gacWaitAnimationStartReq },
        { 0xB38E5181, CallAction_ChangeDisplaySettingModevalueReq },
        { 0xB3A37D70, CallAction_Perform_EqlPrstHiphop },
        { 0xB3D306A8, CallAction_Candidate_EU_12 },
        { 0xB3DCF176, CallAction_TimeZone_48 },
        { 0xB5213778, CallAction_Perform_SWUpdate_Downgrade },
        { 0xB75A14A4, CallAction_TimeZone_27 },
        { 0xB844B985, CallAction_Perform_Speed_Off },
        { 0xBA699BA3, CallAction_TimeZone_16 },
        { 0xBADC38FA, CallAction_Candidate_GEX_5 },
        { 0xBB441DAC, CallAction_gacRegisterForCloseOnTouchSession },
        { 0xBB991CA2, CallAction_TimeZone_38 },
        { 0xBBFD43E4, CallAction_Perform_Balance_Inc },
        { 0xBC261DC8, CallAction_TimeZone_32 },
        { 0xBDECE418, CallAction_gacSetApplicationMode },
        { 0xBEF6021E, CallAction_acPerform_ToggleDropdown },
        { 0xBF4E41DE, CallAction_Candidate_GEX_2 },
        { 0xC37EE8E9, CallAction_gacPopupFilterPrioEnableReq },
        { 0xC40791CB, CallAction_TimeZone_40 },
        { 0xC48311D1, CallAction_Perform_Brightness_Inc },
        { 0xC4E035F3, CallAction_Perform_Equilizer_Pop },
        { 0xC51CE603, CallAction_gacViewCreateAllReq },
        { 0xC56BB0C7, CallAction_TimeZone_28 },
        { 0xC5DD5738, CallAction_gacProfileChange },
        { 0xC65CAED0, CallAction_gacSpellerBbehaviorReq },
        { 0xC8488849, CallAction_TimeZone_2 },
        { 0xC8539D8B, CallAction_gacSceneTransitionLeave },
        { 0xC8B46E69, CallAction_Perform_PrivateModeLevelThree },
        { 0xC8EA8B79, CallAction_acRestartAppPopupTimer },
        { 0xC9663A0D, CallAction_Perform_CLKSetMode_GPS },
        { 0xC9EB88D6, CallAction_gacViewClearReq },
        { 0xCB8DBDEF, CallAction_gacHideFooterLineReq },
        { 0xCC034AAD, CallAction_DateFormat_EU_6 },
        { 0xCC273F1E, CallAction_TimeZone_15 },
        { 0xCCF1A98B, CallAction_PreviousLevelTransition },
        { 0xCD3B618A, CallAction_Perform_FactoryResetSM },
        { 0xCEA82A47, CallAction_Perform_Touch },
        { 0xD00C2464, CallAction_Perform_Fader_Dec },
        { 0xD0DDCDB6, CallAction_Perform_Bass_Dec },
        { 0xD15535F4, CallAction_Perform_ClockHour_Dec },
        { 0xD1AA4F4D, CallAction_ZoomOutTransition },
        { 0xD1B75113, CallAction_Perform_ClkDateFmt1 },
        { 0xD233A77A, CallAction_Perform_Activate_RVC_Source },
        { 0xD375FBE8, CallAction_acStartUSBStickBinaryValidation },
        { 0xD5F685D5, CallAction_PageFlipFrontTransition },
        { 0xD633D1A5, CallAction_Perform_Balance_Dec },
        { 0xD63C2357, CallAction_gacViewAsyncLoadReq },
        { 0xD6470643, CallAction_Perform_Fader_Inc },
        { 0xD6B33722, CallAction_TimeZone_43 },
        { 0xD98C6419, CallAction_gacViewActivateWithoutRenderingReq },
        { 0xDA46AC49, CallAction_TimeZone_7 },
        { 0xDA8E68E7, CallAction_acPerformListRefresh },
        { 0xDB665FD5, CallAction_acPerform_CloseDropdown },
        { 0xDD0EE6DC, CallAction_Perform_TimeFormat12H },
        { 0xDD4D179D, CallAction_gacHideFooterLineMultiDisplayReq },
        { 0xDD71F921, CallAction_gacPerformListBtnRightEncoderChangeUpd },
        { 0xDDD40E46, CallAction_Perform_PrivateModeLevelTwo },
        { 0xDE17B3E7, CallAction_TimeZone_1 },
        { 0xDE714E56, CallAction_Perform_Hour_Inc },
        { 0xDEF5FE47, CallAction_Perform_Equilizer_Classic },
        { 0xDF485126, CallAction_Perform_Aux_Quiet },
        { 0xDF70FD26, CallAction_acStartMISStageOneUpdate },
        { 0xDF9B48F2, CallAction_TimeZone_42 },
        { 0xE0EF3086, CallAction_gacPopupCreateAndSBShowReqForMultiDisplay },
        { 0xE21845EF, CallAction_Candidate_EU_3 },
        { 0xE2CA08D5, CallAction_Candidate_GEX_4 },
        { 0xE3F4F58E, CallAction_Perform_ClkDateFmt2 },
        { 0xE500B03C, CallAction_gacContextSwitchBackRes },
        { 0xE535DC91, CallAction_acHandleRebootOnUSBRemoval },
        { 0xE5D8712C, CallAction_TimeZone_33 },
        { 0xE5E37136, CallAction_TimeZone_39 },
        { 0xE6CB6C9C, CallAction_Candidate_EU_11 },
        { 0xE78C6F9E, CallAction_acSendPopupStatus },
        { 0xE90F49DA, CallAction_TimeZone_6 },
        { 0xEA0806EA, CallAction_DateFormat_EU_4 },
        { 0xEB51CB7E, CallAction_gacPopupSBCloseReq },
        { 0xEC09B091, CallAction_Perform_SpeedLockTouch },
        { 0xEC113003, CallAction_Perform_Speed_Level1 },
        { 0xEC64DB0F, CallAction_gacScrollPageDown },
        { 0xEDEAB952, CallAction_Perform_EqlPrstFlat },
        { 0xEE11F57F, CallAction_gacScrollPageUp },
        { 0xEE131A83, CallAction_gacNavTBTSwipe },
        { 0xEEEA94FA, CallAction_Perform_Minute_Dec },
        { 0xF06EEB52, CallAction_Perform_EqlPrstClassic },
        { 0xF0A1D4B5, CallAction_gacCheckToClosePopup },
        { 0xF17E085D, CallAction_gacPopupCreateAndSBShowReq },
        { 0xF1BB6808, CallAction_ChangeAuxlevelvalueReq },
        { 0xF2720AD3, CallAction_TimeZone_23 },
        { 0xF483080B, CallAction_Candidate_EU_10 },
        { 0xF52E8FCC, CallAction_TimeZone_34 },
        { 0xF563FD83, CallAction_Perform_ClockMinute_Inc },
        { 0xF565AE0C, CallAction_Candidate_GEX_1 },
        { 0xF72A1BFC, CallAction_Perform_ClkDateFmt3 },
        { 0xF7350ACD, CallAction_acUpdatePopupText },
        { 0xF9E1D939, CallAction_Perform_Update_SoundSetting_Entry },
        { 0xFBB30121, CallAction_TimeZone_47 },
        { 0xFC0F2AF8, CallAction_DateFormat_EU_5 },
        { 0xFDC77F8F, CallAction_Perform_Touch_Click },
        { 0xFF7C76B4, CallAction_TimeZone_5 },
    };
    ::FeatStd::UInt32 hashId = ::Courier::Identifier::CalcHash(actionName);
    const ActionMapping* action = ::Courier::BinarySearch(hashId, actions, 274, &ActionMappingCmp);
    if (action && (hashId == action->mHashId)) {
        return action->mActionCallHandler(parameters, response);
    }
    return false;
}
#endif
namespace Courier {
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CameraGroupReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CameraGroupResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ActivationReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ActivationResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewRenderingReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewRenderingResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewMessagingReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewMessagingResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CameraGroupActivationReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CameraGroupActivationResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TryLoadReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::LoadReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DelayedUnloadMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::LoadResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TryAsyncLoadReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::AsyncLoadReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::AsyncLoadResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::AsyncLoadIndMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CameraGroupLoadReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CameraGroupLoadResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ThemeReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ThemeResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::AnimationReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::AnimationResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::AnimationIndMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::SetPropertyReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::SetPropertyResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::SetFocusReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::SetFocusResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::LostFocusIndMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TransitionReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TransitionResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TransitionIndMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::InvalidateReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::RenderReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::RenderResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::LayerReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::LayerResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ParentViewActivateEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ParentViewRenderingEnabledEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ParentViewInitContentEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ParentViewLoadEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::FocusEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::LostFocusEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TransitionStartedEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TransitionFinishedEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::SetCultureReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::SetCultureResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CultureChangeIndMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewPlaceholderReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewPlaceholderResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewMsgBase, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::WidgetMsgBase, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::Internal::DataBindingMsgBase, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::Internal::BindingSourceBaseMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::Internal::ReleaseDataItemMsgBase, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::Internal::DataItemMsgBase, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::Internal::ListEventMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::input::TouchAbort, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::input::TouchSessionStartEvent, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::input::TouchSessionStopEvent, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::IdUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::ConsumerMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::ProviderUpdateIndicationMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::TouchForwardReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::TouchAbortReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::ActivateImageProviderReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::ExternalImageProviderReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::ExternalImageProviderGroupReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::DrmAllocationStatusMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::DrmGarbageCollectorReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::DrmGCTimeoutMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::PositionBaseMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::SlaveSurfaceRepositionBaseMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::DirectTextureConsumerContentIndicationMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::PositionInfoReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::PositionInfoResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::SlaveSurfaceRepositionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::SlaveSurfaceRepositionResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::WidgetCheckReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::NotifierMessage, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TimerExpiredMsg, 15);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::GuiStartupFinishedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CreateNewDestroyOld, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EnterKeyStatusChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusControlReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusGroupReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::UpdateFocusSessionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RefreshFocusSessionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusSessionFinishedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RegisterFocusableWidgetsReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::JoystickStatusChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusChangedReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SurfaceStateChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::LayerStateChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SBPopupTimerExpiryUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::HMISubStateChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::QueryTraceInfoReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FollowUpActionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::WidgetPropertySetterReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SimTouchReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CloseOnTouchReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RegisterForCloseOnTouchSessionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SetClosePopupExternalTouchMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ClosePopupOnExternalTouchReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PlayBeepReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ChangeHmiSubStateReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EvalSubSurfaceReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ExecuteSubSurfaceReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ExecuteSubSurfaceResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ExtendedViewReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::LocalizationReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DecrementActiveAnimationCountMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PopupReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SetApplicationAsMandatoryReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ApplicationStateUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SubSurfaceUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ApplicationRenderedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ApplicationSwitchCompleteUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SubSurfaceSwitchCompleteUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SbAnimationStateChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SbCurrentStatusUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PopupDisplayStatusUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ShowHMISubSurfaceReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StartLayerAnimationReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PopupFilterPrioEnableReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PopupFilterAllEnableReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PopupFilterDisableReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::MultiDisplayPopupFilterReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RestartMenuTimeoutTimerReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RenderingCompleteMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CreateTextMetaDataCollectionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DumpScreenReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TraverseViewsReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropCheckSourceReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropCheckSourceResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropCheckDestinationReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropCheckDestinationResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropCompleteReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropCompleteResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropAbortReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropStatusUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ProfileSwitchMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TransitionMediatorOnDataCompleteMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ManualSceneActionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EglWaitNativeReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EglWaitNativeResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ResetGadgetCacheReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::AttachedAnimationReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::SenderMessage, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::TouchUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::AnimationWidgetReqMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::AnimationWidgetIndMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ButtonListItemUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ButtonSlideMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ButtonGroupReqMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ColorBarDataUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::combobox::ComboBoxUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::combobox::ComboBoxReqMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DropdownCurrentValueChangedMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DropdownChangeMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::editfield::EditFieldUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::editfield::EditFieldHightlightReqMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gesture::GestureMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gesture::TapGestureMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gesture::DragGestureMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gesture::SwipeGestureMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gesture::PinchSpreadGestureMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gesture::RotateGestureMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gizmo::GizmoUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListDateProviderReqMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListDateProviderResMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListDataProviderUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListChangeMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListAnimatedChangeReqMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListChangedUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListMovementFinishedUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListStatusUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListVisibiltyUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListFocusChangeReqMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SliderCurrentValueChangedMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::LockOutMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListItemExpandReqMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListItemExpandEndUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListCustomAnimationReqMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListCustomAnimationResMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListCustomAnimationIndMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListMorphReqMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListContentUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListVisualContentUpdateMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListCacheReqMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::pageedit::PageEditUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PanelSlideReqMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PanelStateMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SpellerKeyPressed, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SpellerCtrlKeyPressed, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SpellerStatusChangedUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SubSpellerStatusUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TimerWidgetExpiryMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::HWR_CandidateUpdate, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::HWR_TextWidgetUpdate, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ScrollableTextUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActiveSurfaceViewUpdateMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ChangeLanguageReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StartPopupTimerReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StopPopupTimerReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RestartPopupTimerReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ExpiredPopupTimerResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListFocusResetReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EnableCameraRenderingReq, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SwitchApplicationStateReq, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DisableCameraRenderingReq, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DummyMess, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivityMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivateApplicationMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DeactivateApplicationMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::HardKeyPressNotificationMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusOnRightEncoderReqUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StoreActiveGadgetReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CheckToClosePopupMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ContextSwitchOutReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ContextSwitchInResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CurrentScreenDisplayReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::LaunchBarDisplayReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::NavTBTSwipeReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListItemRightEncoderChangeUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListFocusLockDataResetReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListFocusScrollReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SetApplicationModeReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SpellerBbehaviorReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StatusBarDisplayReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TBTRetriggerAcousticMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StartGadgetAnimationReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ControlPanelButtonPressInfo, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::UpdateLanguageRegionCN_HMI, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::UpdateLanguageRegionGEX_HMI, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DateFormat_PL_EU_HMI, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DateFormat_PL_CN_HMI, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ChangeMeasurementvalueReqMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ChangeClockTimeformatReqMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ChangeGpsClockTimeformatReqMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ChangeGpsClockClkModeReqMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ChangeClockTimeZoneReqMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SwivelModeMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CockpitModeMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PopupStatusMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SendPluginReq, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Displayclock, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DisplayAudioSetting4Tuner, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DisplayAudioSetting4Media, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DisplayAudioSetting4Volume, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ChangeClockformatReqMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ChangeAuxlevelvalueReqMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ChangeDisplaySettingModevalueReqMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ChangeLCDOnOff4GammaCASettingModevalReqMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ChangeMonitorUpDown4GammaCASettingModevalReqMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CheckBoxMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::AS_Equilizer_PL_Msg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::AS_Speed_Volume_PL_Msg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::AS_AuxLevel_PL_Msg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::AS_ExtDVDLevel_PL_Msg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SceneTranstoEP, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SceneTranstoSpeedDepVol, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SceneTranstoAS, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SceneTranstoDisplay, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SceneTranstoClock, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SceneTranstoLanguage, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SceneTranstoSecurity, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SceneTranstoFactory, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SceneTranstoOSS, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ResetFactDef, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SWUpdate_Downgrade, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ChangeLanguageResp, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ChangeMeasurementUnitReq, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::AS_ExtDVDLevel_BL_Msg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::AS_Beep_Touch_PL_Msg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::AS_SwitchSetting_Msg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::IncClockHourLevelMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DecClockHourLevelMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::IncClockMinuteLevelMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DecClockMinuteLevelMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SwitchApplicationReq, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SwitchCabin_A_ApplicationReq, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SwitchCabin_B_ApplicationReq, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Update_AuxLevel, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Update_ExtDVDLevel, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::UpdateCheckBoxMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SwitchToRVCApplication, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SwitchToMediaApplication, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SwitchToTunerApplication, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::UpdateCurrentSource, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Update_VolumeValue, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Activate_PopUp, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Activate_Popup_RenderingDiagnosis, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Hide_Popup_RenderingDiagnosis, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Update_EntryIDSoundSettings, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::UpdateDateResp, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::UpdateTimeFormatResp, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::UpdateTimeZoneResp, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::UpdateCLKSetModeResp, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::UpdateHourValueResp, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Update_AM_PM, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::UpdateMinuteValueResp, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Update_DLS_Resp, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ResetFactDefMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ResetFactDefCompleteMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::MeaUnitMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::MeaUnitMsgFromBL, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::HandleSoundSettingsBackButton, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivateSettingsMainView, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StartSWDowngrade, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivateSWDowngradePopup, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DeactivateSWDowngradePopup, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::USBStickAvailableStatusUpdMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::USBStickRemovedUpdMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SWCompactibilityUpdMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SetUpdateOptionOnlyReqMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ReadReleaseDocReqMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ReleaseDocPropertyUpdMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::IncompatibleUSBUpdMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::IncompatibleUsbFormatMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SystemInstallationMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SWUpdateAbortRebootMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::OEMPinOkMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::UpdatePopupTextReqMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StartUSBStickBinaryValidationReqMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SetSoftwareUpdateTypeMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EnableButtonsonNopopMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StartDownloadReqMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::USBValidationCompleteMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ReadSWUpdateDetailsInfo, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SetReleaseFilterReqMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CustomerModeFilterUpdMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EnggModeFilterUpdMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StartMISStageOneUpdateMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::rvcEntryView, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::rvcExitView, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::MISUpdateStartTimeExpiredMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::OnReceivingStageOneEstTimeMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SWUpdateStageOneCompleteMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SWupdateResultNotificationMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RebootOnSWDLCompleteMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ExitOnSWDLFailureMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::HandleRebootOnUSBRemovalMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::HandlePendingSWDLMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RequestMISupdateContextSwitchMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SwitchToSWDLMISprogressBarSceneMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::OnXMLAvailabilityExitBusyWaitMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::MediaRadioBack4mAudio, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::VideoMixedSourceBack4mCabinHome, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::LevelOff, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::LevelOne, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::LevelTwo, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::LevelThree, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PrivateModeLevelOne, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PrivateModeLevelTwo, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PrivateModeLevelThree, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::MediaEntry2AudioSetting_1, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::GotoMainSoundSettings, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::GotoMicSettings, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::GotoMainCabinASettings, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SettingSceneMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EqlPrstFlat, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EqlPrstPop, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EqlPrstRock, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EqlPrstHiphop, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EqlPrstClassic, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EqlPrstJazz, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DTCSubSystemCMC19SwDetailsMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListRefreshMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ClkDateFmt1, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ClkDateFmt2, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ClkDateFmt3, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ClkDateFmt4, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ClkDateFmt5, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ClkDateFmt6, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RVCBrightness, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RVCContrast, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DisplayClockScene, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivateSpeedLock_CP_Popup, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Popup_Reset_System, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SpeedLockMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PrivateModeMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::OpenSourceSoftwareMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::OpenSourceSoftwareCaMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SoftwareVersionCISMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ClonedHKStatusMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ResetFactorySettingsMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Popup_Privacy_open, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StartSoftwareUpdatePressMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StartSoftwareUpdateLongPressMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StartSoftwareUpdateHistoryMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::OEMSettingMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::OEMMenuMsg, 100);
} // namespace Courier

// ------------------------------------------------------------------------
DropdownmenuComboDataBindingSource::DropdownmenuComboDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::DropdownmenuComboItem)
{
}

// ------------------------------------------------------------------------
CheckBoxListItemDataBindingSource::CheckBoxListItemDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::CheckBoxListItemItem)
{
}

// ------------------------------------------------------------------------
SwVersionNodeSwitchItemDataBindingSource::SwVersionNodeSwitchItemDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SwVersionNodeSwitchItemItem)
{
}

// ------------------------------------------------------------------------
DisplaySettingsModeDataBindingSource::DisplaySettingsModeDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::DisplaySettingsModeItem)
{
}

// ------------------------------------------------------------------------
DisplaySettingsBrightnessDataBindingSource::DisplaySettingsBrightnessDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::DisplaySettingsBrightnessItem)
{
}

// ------------------------------------------------------------------------
BrightnessIncValDataBindingSource::BrightnessIncValDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::BrightnessIncValItem)
{
}

// ------------------------------------------------------------------------
BrightnessDecValDataBindingSource::BrightnessDecValDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::BrightnessDecValItem)
{
}

// ------------------------------------------------------------------------
GenPopupMsgDataBindingSource::GenPopupMsgDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::GenPopupMsgItem)
{
}

// ------------------------------------------------------------------------
CAAudiolevelUpdateItemDataBindingSource::CAAudiolevelUpdateItemDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::CAAudiolevelUpdateItemItem)
{
}

// ------------------------------------------------------------------------
CAMICBeepAudiolevelUpdateItemDataBindingSource::CAMICBeepAudiolevelUpdateItemDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::CAMICBeepAudiolevelUpdateItemItem)
{
}

// ------------------------------------------------------------------------
BasslevelUpdateItemDataBindingSource::BasslevelUpdateItemDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::BasslevelUpdateItemItem)
{
}

// ------------------------------------------------------------------------
RVCBrightnessUpdateItemDataBindingSource::RVCBrightnessUpdateItemDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::RVCBrightnessUpdateItemItem)
{
}

// ------------------------------------------------------------------------
RVCContrastUpdateItemDataBindingSource::RVCContrastUpdateItemDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::RVCContrastUpdateItemItem)
{
}

// ------------------------------------------------------------------------
DispSettingValueUpdateItemDataBindingSource::DispSettingValueUpdateItemDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::DispSettingValueUpdateItemItem)
{
}

// ------------------------------------------------------------------------
HourValueUpdateItemDataBindingSource::HourValueUpdateItemDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::HourValueUpdateItemItem)
{
}

// ------------------------------------------------------------------------
TreblelevelUpdateItemDataBindingSource::TreblelevelUpdateItemDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::TreblelevelUpdateItemItem)
{
}

// ------------------------------------------------------------------------
BalancelevelUpdateItemDataBindingSource::BalancelevelUpdateItemDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::BalancelevelUpdateItemItem)
{
}

// ------------------------------------------------------------------------
LanguageSettingMenuDataBindingSource::LanguageSettingMenuDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::LanguageSettingMenuItem)
{
}

// ------------------------------------------------------------------------
OEMPINKeyInfoDataBindingSource::OEMPINKeyInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::OEMPINKeyInfoItem)
{
}

// ------------------------------------------------------------------------
OEMPINCursorStateDataBindingSource::OEMPINCursorStateDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::OEMPINCursorStateItem)
{
}

// ------------------------------------------------------------------------
OEMPINEditableStateDataBindingSource::OEMPINEditableStateDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::OEMPINEditableStateItem)
{
}

// ------------------------------------------------------------------------
OEMPIN1TextInfoDataBindingSource::OEMPIN1TextInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::OEMPIN1TextInfoItem)
{
}

// ------------------------------------------------------------------------
OEMPIN2TextInfoDataBindingSource::OEMPIN2TextInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::OEMPIN2TextInfoItem)
{
}

// ------------------------------------------------------------------------
OEMPIN3TextInfoDataBindingSource::OEMPIN3TextInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::OEMPIN3TextInfoItem)
{
}

// ------------------------------------------------------------------------
OEMPIN4TextInfoDataBindingSource::OEMPIN4TextInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::OEMPIN4TextInfoItem)
{
}

// ------------------------------------------------------------------------
OEMKey1InputDataBindingSource::OEMKey1InputDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::OEMKey1InputItem)
{
}

// ------------------------------------------------------------------------
OEMKey2InputDataBindingSource::OEMKey2InputDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::OEMKey2InputItem)
{
}

// ------------------------------------------------------------------------
OEMKey3InputDataBindingSource::OEMKey3InputDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::OEMKey3InputItem)
{
}

// ------------------------------------------------------------------------
OEMKey4InputDataBindingSource::OEMKey4InputDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::OEMKey4InputItem)
{
}

// ------------------------------------------------------------------------
OEMAuthenticationInfoTextDataBindingSource::OEMAuthenticationInfoTextDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::OEMAuthenticationInfoTextItem)
{
}

// ------------------------------------------------------------------------
OEMSpeedLockUpdateDataBindingSource::OEMSpeedLockUpdateDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::OEMSpeedLockUpdateItem)
{
}

// ------------------------------------------------------------------------
NaftaLang_SettingMenuDataBindingSource::NaftaLang_SettingMenuDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::NaftaLang_SettingMenuItem)
{
}

// ------------------------------------------------------------------------
vmsCabinMenuDataBindingSource::vmsCabinMenuDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::vmsCabinMenuItem)
{
}

// ------------------------------------------------------------------------
ClockHourSettingValueDataBindingSource::ClockHourSettingValueDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::ClockHourSettingValueItem)
{
}

// ------------------------------------------------------------------------
ClockMinuteSettingValueDataBindingSource::ClockMinuteSettingValueDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::ClockMinuteSettingValueItem)
{
}

// ------------------------------------------------------------------------
ClockTimeZoneDataBindingSource::ClockTimeZoneDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::ClockTimeZoneItem)
{
}

// ------------------------------------------------------------------------
SpeedDependentVolumeControlDataBindingSource::SpeedDependentVolumeControlDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SpeedDependentVolumeControlItem)
{
}

// ------------------------------------------------------------------------
PrivateModeSettingDataBindingSource::PrivateModeSettingDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::PrivateModeSettingItem)
{
}

// ------------------------------------------------------------------------
DTCHeadingUpdateItemDataBindingSource::DTCHeadingUpdateItemDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::DTCHeadingUpdateItemItem)
{
}

// ------------------------------------------------------------------------
SOASEquilizerPresetDataBindingSource::SOASEquilizerPresetDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SOASEquilizerPresetItem)
{
}

// ------------------------------------------------------------------------
ClockDateFormatDataBindingSource::ClockDateFormatDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::ClockDateFormatItem)
{
}

// ------------------------------------------------------------------------
DateFmtUpdateItemDataBindingSource::DateFmtUpdateItemDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::DateFmtUpdateItemItem)
{
}

// ------------------------------------------------------------------------
MasterGadgetSystemDataBindingSource::MasterGadgetSystemDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::MasterGadgetSystemItem)
{
}

// ------------------------------------------------------------------------
SWUpdateDetailsDataBindingSource::SWUpdateDetailsDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SWUpdateDetailsItem)
{
}

// ------------------------------------------------------------------------
SWUpdateMainDataBindingSource::SWUpdateMainDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SWUpdateMainItem)
{
}

// ------------------------------------------------------------------------
SWUpdateHistoryDetailsDataBindingSource::SWUpdateHistoryDetailsDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SWUpdateHistoryDetailsItem)
{
}

// ------------------------------------------------------------------------
SwivelPopupDataBindingSource::SwivelPopupDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SwivelPopupItem)
{
}

// ------------------------------------------------------------------------
SWUpdateStickInfoDataBindingSource::SWUpdateStickInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SWUpdateStickInfoItem)
{
}

// ------------------------------------------------------------------------
SWQuickUpdateEnableDataBindingSource::SWQuickUpdateEnableDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SWQuickUpdateEnableItem)
{
}

// ------------------------------------------------------------------------
SWFullUpdateEnableDataBindingSource::SWFullUpdateEnableDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SWFullUpdateEnableItem)
{
}

// ------------------------------------------------------------------------
SWUpdateDetailsEnableDataBindingSource::SWUpdateDetailsEnableDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SWUpdateDetailsEnableItem)
{
}

// ------------------------------------------------------------------------
SWUpdatebackbuttonEnableDataBindingSource::SWUpdatebackbuttonEnableDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SWUpdatebackbuttonEnableItem)
{
}

// ------------------------------------------------------------------------
DownlaodTypeInfoDataBindingSource::DownlaodTypeInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::DownlaodTypeInfoItem)
{
}

// ------------------------------------------------------------------------
SWUpdateNameSmartDataBindingSource::SWUpdateNameSmartDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SWUpdateNameSmartItem)
{
}

// ------------------------------------------------------------------------
PopupTextDataBindingSource::PopupTextDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::PopupTextItem)
{
}

// ------------------------------------------------------------------------
SystemInstallationDataBindingSource::SystemInstallationDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SystemInstallationItem)
{
}

// ------------------------------------------------------------------------
SWDetailsTextDataBindingSource::SWDetailsTextDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SWDetailsTextItem)
{
}

// ------------------------------------------------------------------------
SWHistoryDetailsTextDataBindingSource::SWHistoryDetailsTextDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SWHistoryDetailsTextItem)
{
}

// ------------------------------------------------------------------------
SWUpdateResultsDataBindingSource::SWUpdateResultsDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SWUpdateResultsItem)
{
}

// ------------------------------------------------------------------------
SystemsettingMainIconDataBindingSource::SystemsettingMainIconDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SystemsettingMainIconItem)
{
}

// ------------------------------------------------------------------------
CabinAsettingMainIconDataBindingSource::CabinAsettingMainIconDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::CabinAsettingMainIconItem)
{
}

// ------------------------------------------------------------------------
CabinBsettingMainIconDataBindingSource::CabinBsettingMainIconDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::CabinBsettingMainIconItem)
{
}

// ------------------------------------------------------------------------
SystemsettingSwVerNDLanguageIconDataBindingSource::SystemsettingSwVerNDLanguageIconDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SystemsettingSwVerNDLanguageIconItem)
{
}

// ------------------------------------------------------------------------
speedlockUpdatesVisibilityDataBindingSource::speedlockUpdatesVisibilityDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::speedlockUpdatesVisibilityItem)
{
}

// ------------------------------------------------------------------------
bluetoothVisibilityDataBindingSource::bluetoothVisibilityDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::bluetoothVisibilityItem)
{
}

// ------------------------------------------------------------------------
PopUpButtonVisibilityDataBindingSource::PopUpButtonVisibilityDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::PopUpButtonVisibilityItem)
{
}

// ------------------------------------------------------------------------
SWUpdateListItemEnableDataBindingSource::SWUpdateListItemEnableDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SWUpdateListItemEnableItem)
{
}

// ------------------------------------------------------------------------
MISStage1ResultsDataBindingSource::MISStage1ResultsDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::MISStage1ResultsItem)
{
}

// ------------------------------------------------------------------------
ListScrollBarInfoDataBindingSource::ListScrollBarInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::ListScrollBarInfoItem)
{
}

typedef void InvalidData;
struct InvalidDataBindingSource {
    static const ::FeatStd::UInt32 cHierarchyNodeCount = 1;
};

// table of shared DataItemDescriptor
static const ::Courier::Internal::DataBinding::DataItemDescriptor gItemDesc[cDataItemDescriptorCount] = {
    {   // 0 - ::InvalidData
        COURIER_DATA_ITEM_TYPE_ID(::InvalidData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 1 - ::DropdownmenuComboData
        COURIER_DATA_ITEM_TYPE_ID(::DropdownmenuComboData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 2 - ::DropdownmenuComboData::mItem
        COURIER_DATA_ITEM_TYPE_ID(::enMenu),
        COURIER_ITEM_MEMBER(::DropdownmenuComboData, mItem)
    },
    {   // 3 - ::DropdownmenuComboData::mItemvalue
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DropdownmenuComboData, mItemvalue)
    },
    {   // 4 - ::CheckBoxListItemData
        COURIER_DATA_ITEM_TYPE_ID(::CheckBoxListItemData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 5 - ::CheckBoxListItemData::mToggleIconSwitchIndex
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt8),
        COURIER_ITEM_MEMBER(::CheckBoxListItemData, mToggleIconSwitchIndex)
    },
    {   // 6 - ::SwVersionNodeSwitchItemData
        COURIER_DATA_ITEM_TYPE_ID(::SwVersionNodeSwitchItemData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 7 - ::SwVersionNodeSwitchItemData::mToggleNodeIndex
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt8),
        COURIER_ITEM_MEMBER(::SwVersionNodeSwitchItemData, mToggleNodeIndex)
    },
    {   // 8 - ::DisplaySettingsModeData
        COURIER_DATA_ITEM_TYPE_ID(::DisplaySettingsModeData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 9 - ::DisplaySettingsModeData::mCurrModeVal
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DisplaySettingsModeData, mCurrModeVal)
    },
    {   // 10 - ::DisplaySettingsBrightnessData
        COURIER_DATA_ITEM_TYPE_ID(::DisplaySettingsBrightnessData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 11 - ::DisplaySettingsBrightnessData::mCurrBrightnessVal
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DisplaySettingsBrightnessData, mCurrBrightnessVal)
    },
    {   // 12 - ::BrightnessIncValData
        COURIER_DATA_ITEM_TYPE_ID(::BrightnessIncValData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 13 - ::BrightnessIncValData::misClicked_Inc
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::BrightnessIncValData, misClicked_Inc)
    },
    {   // 14 - ::BrightnessDecValData
        COURIER_DATA_ITEM_TYPE_ID(::BrightnessDecValData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 15 - ::BrightnessDecValData::misClicked_Dec
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::BrightnessDecValData, misClicked_Dec)
    },
    {   // 16 - ::GenPopupMsgData
        COURIER_DATA_ITEM_TYPE_ID(::GenPopupMsgData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 17 - ::GenPopupMsgData::mCurrMsg
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::GenPopupMsgData, mCurrMsg)
    },
    {   // 18 - ::CAAudiolevelUpdateItemData
        COURIER_DATA_ITEM_TYPE_ID(::CAAudiolevelUpdateItemData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 19 - ::CAAudiolevelUpdateItemData::mCAAudiolevelIndex
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::CAAudiolevelUpdateItemData, mCAAudiolevelIndex)
    },
    {   // 20 - ::CAMICBeepAudiolevelUpdateItemData
        COURIER_DATA_ITEM_TYPE_ID(::CAMICBeepAudiolevelUpdateItemData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 21 - ::CAMICBeepAudiolevelUpdateItemData::mCAMicBeepAudiolevelIndex
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::CAMICBeepAudiolevelUpdateItemData, mCAMicBeepAudiolevelIndex)
    },
    {   // 22 - ::BasslevelUpdateItemData
        COURIER_DATA_ITEM_TYPE_ID(::BasslevelUpdateItemData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 23 - ::BasslevelUpdateItemData::mBasslevelIndex
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::BasslevelUpdateItemData, mBasslevelIndex)
    },
    {   // 24 - ::RVCBrightnessUpdateItemData
        COURIER_DATA_ITEM_TYPE_ID(::RVCBrightnessUpdateItemData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 25 - ::RVCBrightnessUpdateItemData::mRVCBrightnessIndex
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::RVCBrightnessUpdateItemData, mRVCBrightnessIndex)
    },
    {   // 26 - ::RVCContrastUpdateItemData
        COURIER_DATA_ITEM_TYPE_ID(::RVCContrastUpdateItemData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 27 - ::RVCContrastUpdateItemData::mRVCContrastIndex
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::RVCContrastUpdateItemData, mRVCContrastIndex)
    },
    {   // 28 - ::DispSettingValueUpdateItemData
        COURIER_DATA_ITEM_TYPE_ID(::DispSettingValueUpdateItemData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 29 - ::DispSettingValueUpdateItemData::mDispLevelIndex
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DispSettingValueUpdateItemData, mDispLevelIndex)
    },
    {   // 30 - ::DispSettingValueUpdateItemData::mGreyBrightnessTextCumImage
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::DispSettingValueUpdateItemData, mGreyBrightnessTextCumImage)
    },
    {   // 31 - ::HourValueUpdateItemData
        COURIER_DATA_ITEM_TYPE_ID(::HourValueUpdateItemData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 32 - ::HourValueUpdateItemData::mHourValueIndex
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::HourValueUpdateItemData, mHourValueIndex)
    },
    {   // 33 - ::TreblelevelUpdateItemData
        COURIER_DATA_ITEM_TYPE_ID(::TreblelevelUpdateItemData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 34 - ::TreblelevelUpdateItemData::mTreblelevelIndex
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::TreblelevelUpdateItemData, mTreblelevelIndex)
    },
    {   // 35 - ::BalancelevelUpdateItemData
        COURIER_DATA_ITEM_TYPE_ID(::BalancelevelUpdateItemData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 36 - ::BalancelevelUpdateItemData::mBalancelevelIndex
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::BalancelevelUpdateItemData, mBalancelevelIndex)
    },
    {   // 37 - ::LanguageSettingMenuData
        COURIER_DATA_ITEM_TYPE_ID(::LanguageSettingMenuData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 38 - ::LanguageSettingMenuData::mlanguageval
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::LanguageSettingMenuData, mlanguageval)
    },
    {   // 39 - ::LanguageSettingMenuData::mLanguageActiveColorTextInfo
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::LanguageSettingMenuData, mLanguageActiveColorTextInfo)
    },
    {   // 40 - ::OEMPINKeyInfoData
        COURIER_DATA_ITEM_TYPE_ID(::OEMPINKeyInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 41 - ::OEMPINKeyInfoData::mPressedKey
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::OEMPINKeyInfoData, mPressedKey)
    },
    {   // 42 - ::OEMPINCursorStateData
        COURIER_DATA_ITEM_TYPE_ID(::OEMPINCursorStateData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 43 - ::OEMPINCursorStateData::mState1
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::OEMPINCursorStateData, mState1)
    },
    {   // 44 - ::OEMPINCursorStateData::mState2
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::OEMPINCursorStateData, mState2)
    },
    {   // 45 - ::OEMPINCursorStateData::mState3
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::OEMPINCursorStateData, mState3)
    },
    {   // 46 - ::OEMPINCursorStateData::mState4
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::OEMPINCursorStateData, mState4)
    },
    {   // 47 - ::OEMPINEditableStateData
        COURIER_DATA_ITEM_TYPE_ID(::OEMPINEditableStateData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 48 - ::OEMPINEditableStateData::mEditableState1
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::OEMPINEditableStateData, mEditableState1)
    },
    {   // 49 - ::OEMPINEditableStateData::mEditableState2
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::OEMPINEditableStateData, mEditableState2)
    },
    {   // 50 - ::OEMPINEditableStateData::mEditableState3
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::OEMPINEditableStateData, mEditableState3)
    },
    {   // 51 - ::OEMPINEditableStateData::mEditableState4
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::OEMPINEditableStateData, mEditableState4)
    },
    {   // 52 - ::OEMPIN1TextInfoData
        COURIER_DATA_ITEM_TYPE_ID(::OEMPIN1TextInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 53 - ::OEMPIN1TextInfoData::mText
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::OEMPIN1TextInfoData, mText)
    },
    {   // 54 - ::OEMPIN2TextInfoData
        COURIER_DATA_ITEM_TYPE_ID(::OEMPIN2TextInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 55 - ::OEMPIN2TextInfoData::mText
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::OEMPIN2TextInfoData, mText)
    },
    {   // 56 - ::OEMPIN3TextInfoData
        COURIER_DATA_ITEM_TYPE_ID(::OEMPIN3TextInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 57 - ::OEMPIN3TextInfoData::mText
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::OEMPIN3TextInfoData, mText)
    },
    {   // 58 - ::OEMPIN4TextInfoData
        COURIER_DATA_ITEM_TYPE_ID(::OEMPIN4TextInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 59 - ::OEMPIN4TextInfoData::mText
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::OEMPIN4TextInfoData, mText)
    },
    {   // 60 - ::OEMKey1InputData
        COURIER_DATA_ITEM_TYPE_ID(::OEMKey1InputData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 61 - ::OEMKey1InputData::mText
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::OEMKey1InputData, mText)
    },
    {   // 62 - ::OEMKey2InputData
        COURIER_DATA_ITEM_TYPE_ID(::OEMKey2InputData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 63 - ::OEMKey2InputData::mText
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::OEMKey2InputData, mText)
    },
    {   // 64 - ::OEMKey3InputData
        COURIER_DATA_ITEM_TYPE_ID(::OEMKey3InputData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 65 - ::OEMKey3InputData::mText
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::OEMKey3InputData, mText)
    },
    {   // 66 - ::OEMKey4InputData
        COURIER_DATA_ITEM_TYPE_ID(::OEMKey4InputData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 67 - ::OEMKey4InputData::mText
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::OEMKey4InputData, mText)
    },
    {   // 68 - ::OEMAuthenticationInfoTextData
        COURIER_DATA_ITEM_TYPE_ID(::OEMAuthenticationInfoTextData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 69 - ::OEMAuthenticationInfoTextData::mText
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::OEMAuthenticationInfoTextData, mText)
    },
    {   // 70 - ::OEMAuthenticationInfoTextData::mTextColor
        COURIER_DATA_ITEM_TYPE_ID(Candera::Color),
        COURIER_ITEM_MEMBER(::OEMAuthenticationInfoTextData, mTextColor)
    },
    {   // 71 - ::OEMAuthenticationInfoTextData::mSpellerEnable
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::OEMAuthenticationInfoTextData, mSpellerEnable)
    },
    {   // 72 - ::OEMAuthenticationInfoTextData::mActiveStatus
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::OEMAuthenticationInfoTextData, mActiveStatus)
    },
    {   // 73 - ::OEMSpeedLockUpdateData
        COURIER_DATA_ITEM_TYPE_ID(::OEMSpeedLockUpdateData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 74 - ::OEMSpeedLockUpdateData::mstatus
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::OEMSpeedLockUpdateData, mstatus)
    },
    {   // 75 - ::NaftaLang_SettingMenuData
        COURIER_DATA_ITEM_TYPE_ID(::NaftaLang_SettingMenuData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 76 - ::NaftaLang_SettingMenuData::mnaftalang_val
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::NaftaLang_SettingMenuData, mnaftalang_val)
    },
    {   // 77 - ::NaftaLang_SettingMenuData::mnaftalang_ActiveColor
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::NaftaLang_SettingMenuData, mnaftalang_ActiveColor)
    },
    {   // 78 - ::vmsCabinMenuData
        COURIER_DATA_ITEM_TYPE_ID(::vmsCabinMenuData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 79 - ::vmsCabinMenuData::mvmsSourceName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::vmsCabinMenuData, mvmsSourceName)
    },
    {   // 80 - ::vmsCabinMenuData::mvmsSourceRadioBtnEnDisb
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt8),
        COURIER_ITEM_MEMBER(::vmsCabinMenuData, mvmsSourceRadioBtnEnDisb)
    },
    {   // 81 - ::vmsCabinMenuData::mvmsSourceTextEnDisb
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::vmsCabinMenuData, mvmsSourceTextEnDisb)
    },
    {   // 82 - ::ClockHourSettingValueData
        COURIER_DATA_ITEM_TYPE_ID(::ClockHourSettingValueData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 83 - ::ClockHourSettingValueData::mCurrHourVal
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::ClockHourSettingValueData, mCurrHourVal)
    },
    {   // 84 - ::ClockMinuteSettingValueData
        COURIER_DATA_ITEM_TYPE_ID(::ClockMinuteSettingValueData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 85 - ::ClockMinuteSettingValueData::mCurrMinuteVal
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::ClockMinuteSettingValueData, mCurrMinuteVal)
    },
    {   // 86 - ::ClockTimeZoneData
        COURIER_DATA_ITEM_TYPE_ID(::ClockTimeZoneData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 87 - ::ClockTimeZoneData::mOFFSetHourText
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::ClockTimeZoneData, mOFFSetHourText)
    },
    {   // 88 - ::ClockTimeZoneData::mOFFSetMinuteText
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::ClockTimeZoneData, mOFFSetMinuteText)
    },
    {   // 89 - ::SpeedDependentVolumeControlData
        COURIER_DATA_ITEM_TYPE_ID(::SpeedDependentVolumeControlData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 90 - ::SpeedDependentVolumeControlData::mToggleOFF
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SpeedDependentVolumeControlData, mToggleOFF)
    },
    {   // 91 - ::SpeedDependentVolumeControlData::mToggleLVL1
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SpeedDependentVolumeControlData, mToggleLVL1)
    },
    {   // 92 - ::SpeedDependentVolumeControlData::mToggleLVL2
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SpeedDependentVolumeControlData, mToggleLVL2)
    },
    {   // 93 - ::SpeedDependentVolumeControlData::mToggleLVL3
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SpeedDependentVolumeControlData, mToggleLVL3)
    },
    {   // 94 - ::SpeedDependentVolumeControlData::mColorOFF
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SpeedDependentVolumeControlData, mColorOFF)
    },
    {   // 95 - ::SpeedDependentVolumeControlData::mColorLVL1
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SpeedDependentVolumeControlData, mColorLVL1)
    },
    {   // 96 - ::SpeedDependentVolumeControlData::mColorLVL2
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SpeedDependentVolumeControlData, mColorLVL2)
    },
    {   // 97 - ::SpeedDependentVolumeControlData::mColorLVL3
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SpeedDependentVolumeControlData, mColorLVL3)
    },
    {   // 98 - ::PrivateModeSettingData
        COURIER_DATA_ITEM_TYPE_ID(::PrivateModeSettingData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 99 - ::PrivateModeSettingData::mPrivate_1_Toggle
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::PrivateModeSettingData, mPrivate_1_Toggle)
    },
    {   // 100 - ::PrivateModeSettingData::mPrivate_2_Toggle
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::PrivateModeSettingData, mPrivate_2_Toggle)
    },
    {   // 101 - ::PrivateModeSettingData::mPrivate_3_Toggle
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::PrivateModeSettingData, mPrivate_3_Toggle)
    },
    {   // 102 - ::PrivateModeSettingData::mPrivate_1_ColorChg
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::PrivateModeSettingData, mPrivate_1_ColorChg)
    },
    {   // 103 - ::PrivateModeSettingData::mPrivate_2_ColorChg
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::PrivateModeSettingData, mPrivate_2_ColorChg)
    },
    {   // 104 - ::PrivateModeSettingData::mPrivate_3_ColorChg
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::PrivateModeSettingData, mPrivate_3_ColorChg)
    },
    {   // 105 - ::DTCHeadingUpdateItemData
        COURIER_DATA_ITEM_TYPE_ID(::DTCHeadingUpdateItemData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 106 - ::DTCHeadingUpdateItemData::mDTCHeadingData
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DTCHeadingUpdateItemData, mDTCHeadingData)
    },
    {   // 107 - ::SOASEquilizerPresetData
        COURIER_DATA_ITEM_TYPE_ID(::SOASEquilizerPresetData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 108 - ::SOASEquilizerPresetData::mToggleEqlPrstFLAT
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SOASEquilizerPresetData, mToggleEqlPrstFLAT)
    },
    {   // 109 - ::SOASEquilizerPresetData::mToggleEqlPrstPOP
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SOASEquilizerPresetData, mToggleEqlPrstPOP)
    },
    {   // 110 - ::SOASEquilizerPresetData::mToggleEqlPrstROCK
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SOASEquilizerPresetData, mToggleEqlPrstROCK)
    },
    {   // 111 - ::SOASEquilizerPresetData::mToggleEqlPrstHIPHOP
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SOASEquilizerPresetData, mToggleEqlPrstHIPHOP)
    },
    {   // 112 - ::SOASEquilizerPresetData::mToggleEqlPrstCLASSIC
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SOASEquilizerPresetData, mToggleEqlPrstCLASSIC)
    },
    {   // 113 - ::SOASEquilizerPresetData::mToggleEqlPrstJAZZ
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SOASEquilizerPresetData, mToggleEqlPrstJAZZ)
    },
    {   // 114 - ::SOASEquilizerPresetData::mColorEqlPrstFLAT
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SOASEquilizerPresetData, mColorEqlPrstFLAT)
    },
    {   // 115 - ::SOASEquilizerPresetData::mColorEqlPrstPOP
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SOASEquilizerPresetData, mColorEqlPrstPOP)
    },
    {   // 116 - ::SOASEquilizerPresetData::mColorEqlPrstROCK
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SOASEquilizerPresetData, mColorEqlPrstROCK)
    },
    {   // 117 - ::SOASEquilizerPresetData::mColorEqlPrstHIPHOP
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SOASEquilizerPresetData, mColorEqlPrstHIPHOP)
    },
    {   // 118 - ::SOASEquilizerPresetData::mColorEqlPrstCLASSIC
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SOASEquilizerPresetData, mColorEqlPrstCLASSIC)
    },
    {   // 119 - ::SOASEquilizerPresetData::mColorEqlPrstJAZZ
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SOASEquilizerPresetData, mColorEqlPrstJAZZ)
    },
    {   // 120 - ::ClockDateFormatData
        COURIER_DATA_ITEM_TYPE_ID(::ClockDateFormatData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 121 - ::ClockDateFormatData::mToggleClkDateFmt1
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::ClockDateFormatData, mToggleClkDateFmt1)
    },
    {   // 122 - ::ClockDateFormatData::mToggleClkDateFmt2
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::ClockDateFormatData, mToggleClkDateFmt2)
    },
    {   // 123 - ::ClockDateFormatData::mToggleClkDateFmt3
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::ClockDateFormatData, mToggleClkDateFmt3)
    },
    {   // 124 - ::ClockDateFormatData::mToggleClkDateFmt4
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::ClockDateFormatData, mToggleClkDateFmt4)
    },
    {   // 125 - ::ClockDateFormatData::mToggleClkDateFmt5
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::ClockDateFormatData, mToggleClkDateFmt5)
    },
    {   // 126 - ::ClockDateFormatData::mToggleClkDateFmt6
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::ClockDateFormatData, mToggleClkDateFmt6)
    },
    {   // 127 - ::ClockDateFormatData::mColorClkDateFmt1
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::ClockDateFormatData, mColorClkDateFmt1)
    },
    {   // 128 - ::ClockDateFormatData::mColorClkDateFmt2
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::ClockDateFormatData, mColorClkDateFmt2)
    },
    {   // 129 - ::ClockDateFormatData::mColorClkDateFmt3
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::ClockDateFormatData, mColorClkDateFmt3)
    },
    {   // 130 - ::ClockDateFormatData::mColorClkDateFmt4
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::ClockDateFormatData, mColorClkDateFmt4)
    },
    {   // 131 - ::ClockDateFormatData::mColorClkDateFmt5
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::ClockDateFormatData, mColorClkDateFmt5)
    },
    {   // 132 - ::ClockDateFormatData::mColorClkDateFmt6
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::ClockDateFormatData, mColorClkDateFmt6)
    },
    {   // 133 - ::DateFmtUpdateItemData
        COURIER_DATA_ITEM_TYPE_ID(::DateFmtUpdateItemData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 134 - ::DateFmtUpdateItemData::mDateItem
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DateFmtUpdateItemData, mDateItem)
    },
    {   // 135 - ::MasterGadgetSystemData
        COURIER_DATA_ITEM_TYPE_ID(::MasterGadgetSystemData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 136 - ::MasterGadgetSystemData::mTimevalue
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::MasterGadgetSystemData, mTimevalue)
    },
    {   // 137 - ::MasterGadgetSystemData::mTimeAmPm
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::MasterGadgetSystemData, mTimeAmPm)
    },
    {   // 138 - ::SWUpdateDetailsData
        COURIER_DATA_ITEM_TYPE_ID(::SWUpdateDetailsData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 139 - ::SWUpdateDetailsData::mMainCurrentVersion
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SWUpdateDetailsData, mMainCurrentVersion)
    },
    {   // 140 - ::SWUpdateMainData
        COURIER_DATA_ITEM_TYPE_ID(::SWUpdateMainData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 141 - ::SWUpdateMainData::mMediaVersion
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SWUpdateMainData, mMediaVersion)
    },
    {   // 142 - ::SWUpdateMainData::mCurrentVersion
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SWUpdateMainData, mCurrentVersion)
    },
    {   // 143 - ::SWUpdateMainData::mIsNeedFlashing
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SWUpdateMainData, mIsNeedFlashing)
    },
    {   // 144 - ::SWUpdateMainData::mEstimatedTime
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SWUpdateMainData, mEstimatedTime)
    },
    {   // 145 - ::SWUpdateMainData::mSameversionText
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SWUpdateMainData, mSameversionText)
    },
    {   // 146 - ::SWUpdateMainData::mIsSameversionTextvisible
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SWUpdateMainData, mIsSameversionTextvisible)
    },
    {   // 147 - ::SWUpdateMainData::mEstimatedTimeofFota
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SWUpdateMainData, mEstimatedTimeofFota)
    },
    {   // 148 - ::SWUpdateMainData::mEstimatedTotalOtaTime
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SWUpdateMainData, mEstimatedTotalOtaTime)
    },
    {   // 149 - ::SWUpdateMainData::mEstimatedMinutes
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SWUpdateMainData, mEstimatedMinutes)
    },
    {   // 150 - ::SWUpdateMainData::mCustomerPopupDetails
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SWUpdateMainData, mCustomerPopupDetails)
    },
    {   // 151 - ::SWUpdateMainData::mBackGroundUpdTextInfo
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SWUpdateMainData, mBackGroundUpdTextInfo)
    },
    {   // 152 - ::SWUpdateHistoryDetailsData
        COURIER_DATA_ITEM_TYPE_ID(::SWUpdateHistoryDetailsData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 153 - ::SWUpdateHistoryDetailsData::mHistoryDetail
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SWUpdateHistoryDetailsData, mHistoryDetail)
    },
    {   // 154 - ::SwivelPopupData
        COURIER_DATA_ITEM_TYPE_ID(::SwivelPopupData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 155 - ::SwivelPopupData::mActiveSwivelStateAuto
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::SwivelPopupData, mActiveSwivelStateAuto)
    },
    {   // 156 - ::SwivelPopupData::mActiveSwivelStateUp
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::SwivelPopupData, mActiveSwivelStateUp)
    },
    {   // 157 - ::SwivelPopupData::mActiveSwivelStateDown
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::SwivelPopupData, mActiveSwivelStateDown)
    },
    {   // 158 - ::SWUpdateStickInfoData
        COURIER_DATA_ITEM_TYPE_ID(::SWUpdateStickInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 159 - ::SWUpdateStickInfoData::mValidDownloadStickStatus
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SWUpdateStickInfoData, mValidDownloadStickStatus)
    },
    {   // 160 - ::SWUpdateStickInfoData::mUsbStickAvailableStatus
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SWUpdateStickInfoData, mUsbStickAvailableStatus)
    },
    {   // 161 - ::SWUpdateStickInfoData::mIsNotSameVersion
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SWUpdateStickInfoData, mIsNotSameVersion)
    },
    {   // 162 - ::SWQuickUpdateEnableData
        COURIER_DATA_ITEM_TYPE_ID(::SWQuickUpdateEnableData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 163 - ::SWQuickUpdateEnableData::mButtonenable
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SWQuickUpdateEnableData, mButtonenable)
    },
    {   // 164 - ::SWFullUpdateEnableData
        COURIER_DATA_ITEM_TYPE_ID(::SWFullUpdateEnableData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 165 - ::SWFullUpdateEnableData::mButtonenable
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SWFullUpdateEnableData, mButtonenable)
    },
    {   // 166 - ::SWUpdateDetailsEnableData
        COURIER_DATA_ITEM_TYPE_ID(::SWUpdateDetailsEnableData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 167 - ::SWUpdateDetailsEnableData::mButtonenable
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SWUpdateDetailsEnableData, mButtonenable)
    },
    {   // 168 - ::SWUpdatebackbuttonEnableData
        COURIER_DATA_ITEM_TYPE_ID(::SWUpdatebackbuttonEnableData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 169 - ::SWUpdatebackbuttonEnableData::mButtonenable
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SWUpdatebackbuttonEnableData, mButtonenable)
    },
    {   // 170 - ::DownlaodTypeInfoData
        COURIER_DATA_ITEM_TYPE_ID(::DownlaodTypeInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 171 - ::DownlaodTypeInfoData::mDownlaodType
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::DownlaodTypeInfoData, mDownlaodType)
    },
    {   // 172 - ::SWUpdateNameSmartData
        COURIER_DATA_ITEM_TYPE_ID(::SWUpdateNameSmartData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 173 - ::SWUpdateNameSmartData::misVisble
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SWUpdateNameSmartData, misVisble)
    },
    {   // 174 - ::PopupTextData
        COURIER_DATA_ITEM_TYPE_ID(::PopupTextData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 175 - ::PopupTextData::mLine1
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PopupTextData, mLine1)
    },
    {   // 176 - ::PopupTextData::mLine2
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PopupTextData, mLine2)
    },
    {   // 177 - ::PopupTextData::mLine3
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PopupTextData, mLine3)
    },
    {   // 178 - ::PopupTextData::mLine4
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PopupTextData, mLine4)
    },
    {   // 179 - ::PopupTextData::mLine5
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PopupTextData, mLine5)
    },
    {   // 180 - ::PopupTextData::mLine6
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PopupTextData, mLine6)
    },
    {   // 181 - ::PopupTextData::mProgressValue
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::PopupTextData, mProgressValue)
    },
    {   // 182 - ::PopupTextData::mProgressValueStr
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PopupTextData, mProgressValueStr)
    },
    {   // 183 - ::SystemInstallationData
        COURIER_DATA_ITEM_TYPE_ID(::SystemInstallationData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 184 - ::SystemInstallationData::mSysInstallationProgressValue
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::SystemInstallationData, mSysInstallationProgressValue)
    },
    {   // 185 - ::SystemInstallationData::mSysInstallationProgressValueStr
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SystemInstallationData, mSysInstallationProgressValueStr)
    },
    {   // 186 - ::SystemInstallationData::mTextbox1Visibility
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SystemInstallationData, mTextbox1Visibility)
    },
    {   // 187 - ::SystemInstallationData::mTextbox2Visibility
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SystemInstallationData, mTextbox2Visibility)
    },
    {   // 188 - ::SystemInstallationData::mTextbox3Visibility
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SystemInstallationData, mTextbox3Visibility)
    },
    {   // 189 - ::SystemInstallationData::mTextbox4Visibility
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SystemInstallationData, mTextbox4Visibility)
    },
    {   // 190 - ::SystemInstallationData::mTextbox5Visibility
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SystemInstallationData, mTextbox5Visibility)
    },
    {   // 191 - ::SystemInstallationData::mWaitAnimationVisibility
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SystemInstallationData, mWaitAnimationVisibility)
    },
    {   // 192 - ::SystemInstallationData::mFailureMessage
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SystemInstallationData, mFailureMessage)
    },
    {   // 193 - ::SWDetailsTextData
        COURIER_DATA_ITEM_TYPE_ID(::SWDetailsTextData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 194 - ::SWDetailsTextData::mSubModuleName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SWDetailsTextData, mSubModuleName)
    },
    {   // 195 - ::SWDetailsTextData::mCurrentVersion
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SWDetailsTextData, mCurrentVersion)
    },
    {   // 196 - ::SWDetailsTextData::mMediaVersion
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SWDetailsTextData, mMediaVersion)
    },
    {   // 197 - ::SWHistoryDetailsTextData
        COURIER_DATA_ITEM_TYPE_ID(::SWHistoryDetailsTextData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 198 - ::SWHistoryDetailsTextData::mdevicename
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SWHistoryDetailsTextData, mdevicename)
    },
    {   // 199 - ::SWHistoryDetailsTextData::mmodulename
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SWHistoryDetailsTextData, mmodulename)
    },
    {   // 200 - ::SWHistoryDetailsTextData::msubmodule
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SWHistoryDetailsTextData, msubmodule)
    },
    {   // 201 - ::SWHistoryDetailsTextData::msubmoduleversion
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SWHistoryDetailsTextData, msubmoduleversion)
    },
    {   // 202 - ::SWUpdateResultsData
        COURIER_DATA_ITEM_TYPE_ID(::SWUpdateResultsData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 203 - ::SWUpdateResultsData::mComponentName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SWUpdateResultsData, mComponentName)
    },
    {   // 204 - ::SWUpdateResultsData::mUpdateResult
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SWUpdateResultsData, mUpdateResult)
    },
    {   // 205 - ::SWUpdateResultsData::mReserved
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SWUpdateResultsData, mReserved)
    },
    {   // 206 - ::SystemsettingMainIconData
        COURIER_DATA_ITEM_TYPE_ID(::SystemsettingMainIconData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 207 - ::SystemsettingMainIconData::mSystemMainIconNormalBitmap
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::SystemsettingMainIconData, mSystemMainIconNormalBitmap)
    },
    {   // 208 - ::SystemsettingMainIconData::mSystemMainIconPressedBitmap
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::SystemsettingMainIconData, mSystemMainIconPressedBitmap)
    },
    {   // 209 - ::SystemsettingMainIconData::mSystemMainIconFocusedBitmap
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::SystemsettingMainIconData, mSystemMainIconFocusedBitmap)
    },
    {   // 210 - ::SystemsettingMainIconData::mSystemMainNameInfo
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SystemsettingMainIconData, mSystemMainNameInfo)
    },
    {   // 211 - ::SystemsettingMainIconData::mSystemMainActiveTextInfo
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SystemsettingMainIconData, mSystemMainActiveTextInfo)
    },
    {   // 212 - ::CabinAsettingMainIconData
        COURIER_DATA_ITEM_TYPE_ID(::CabinAsettingMainIconData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 213 - ::CabinAsettingMainIconData::mCabinAMainIconNormalBitmap
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::CabinAsettingMainIconData, mCabinAMainIconNormalBitmap)
    },
    {   // 214 - ::CabinAsettingMainIconData::mCabinAMainIconPressedBitmap
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::CabinAsettingMainIconData, mCabinAMainIconPressedBitmap)
    },
    {   // 215 - ::CabinAsettingMainIconData::mCabinAMainIconFocusedBitmap
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::CabinAsettingMainIconData, mCabinAMainIconFocusedBitmap)
    },
    {   // 216 - ::CabinAsettingMainIconData::mCabinAMainIconDisbaledBitmap
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::CabinAsettingMainIconData, mCabinAMainIconDisbaledBitmap)
    },
    {   // 217 - ::CabinAsettingMainIconData::mCabinAMainNameInfo
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::CabinAsettingMainIconData, mCabinAMainNameInfo)
    },
    {   // 218 - ::CabinAsettingMainIconData::mCabinAMainActiveTextInfo
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::CabinAsettingMainIconData, mCabinAMainActiveTextInfo)
    },
    {   // 219 - ::CabinBsettingMainIconData
        COURIER_DATA_ITEM_TYPE_ID(::CabinBsettingMainIconData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 220 - ::CabinBsettingMainIconData::mCabinBMainIconNormalBitmap
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::CabinBsettingMainIconData, mCabinBMainIconNormalBitmap)
    },
    {   // 221 - ::CabinBsettingMainIconData::mCabinBMainIconPressedBitmap
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::CabinBsettingMainIconData, mCabinBMainIconPressedBitmap)
    },
    {   // 222 - ::CabinBsettingMainIconData::mCabinBMainIconFocusedBitmap
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::CabinBsettingMainIconData, mCabinBMainIconFocusedBitmap)
    },
    {   // 223 - ::CabinBsettingMainIconData::mCabinBMainNameInfo
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::CabinBsettingMainIconData, mCabinBMainNameInfo)
    },
    {   // 224 - ::CabinBsettingMainIconData::mCabinBMainActiveTextInfo
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::CabinBsettingMainIconData, mCabinBMainActiveTextInfo)
    },
    {   // 225 - ::SystemsettingSwVerNDLanguageIconData
        COURIER_DATA_ITEM_TYPE_ID(::SystemsettingSwVerNDLanguageIconData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 226 - ::SystemsettingSwVerNDLanguageIconData::mSystemSwVerNDLanguageIconNormalBitmap
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::SystemsettingSwVerNDLanguageIconData, mSystemSwVerNDLanguageIconNormalBitmap)
    },
    {   // 227 - ::SystemsettingSwVerNDLanguageIconData::mSystemSwVerNDLanguageIconPressedBitmap
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::SystemsettingSwVerNDLanguageIconData, mSystemSwVerNDLanguageIconPressedBitmap)
    },
    {   // 228 - ::SystemsettingSwVerNDLanguageIconData::mSystemSwVerNDLanguageIconFocusedBitmap
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::SystemsettingSwVerNDLanguageIconData, mSystemSwVerNDLanguageIconFocusedBitmap)
    },
    {   // 229 - ::speedlockUpdatesVisibilityData
        COURIER_DATA_ITEM_TYPE_ID(::speedlockUpdatesVisibilityData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 230 - ::speedlockUpdatesVisibilityData::mSpeedlocktextVisibility
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::speedlockUpdatesVisibilityData, mSpeedlocktextVisibility)
    },
    {   // 231 - ::speedlockUpdatesVisibilityData::mSpeedlocktextVisibility_1
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::speedlockUpdatesVisibilityData, mSpeedlocktextVisibility_1)
    },
    {   // 232 - ::bluetoothVisibilityData
        COURIER_DATA_ITEM_TYPE_ID(::bluetoothVisibilityData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 233 - ::bluetoothVisibilityData::mButtonHighlight
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::bluetoothVisibilityData, mButtonHighlight)
    },
    {   // 234 - ::PopUpButtonVisibilityData
        COURIER_DATA_ITEM_TYPE_ID(::PopUpButtonVisibilityData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 235 - ::PopUpButtonVisibilityData::mButtonVisibility
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::PopUpButtonVisibilityData, mButtonVisibility)
    },
    {   // 236 - ::SWUpdateListItemEnableData
        COURIER_DATA_ITEM_TYPE_ID(::SWUpdateListItemEnableData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 237 - ::SWUpdateListItemEnableData::mButtonEnable
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SWUpdateListItemEnableData, mButtonEnable)
    },
    {   // 238 - ::MISStage1ResultsData
        COURIER_DATA_ITEM_TYPE_ID(::MISStage1ResultsData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 239 - ::MISStage1ResultsData::mAbortButtonEnable
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::MISStage1ResultsData, mAbortButtonEnable)
    },
    {   // 240 - ::MISStage1ResultsData::mNextbuttonEnable
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::MISStage1ResultsData, mNextbuttonEnable)
    },
    {   // 241 - ::MISStage1ResultsData::mDetailsbuttonEnable
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::MISStage1ResultsData, mDetailsbuttonEnable)
    },
    {   // 242 - ::ListScrollBarInfoData
        COURIER_DATA_ITEM_TYPE_ID(::ListScrollBarInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 243 - ::ListScrollBarInfoData::mEnabled
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::ListScrollBarInfoData, mEnabled)
    },
};

// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gInvalidHierarchyNodes[InvalidDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x00000000, /Invalid),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 0,
        /* mParentIndex        */ 0,    // ItemKey::InvalidItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 0,    // ::InvalidData
        /* mItemKey            */ 0
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gDropdownmenuComboHierarchyNodes[DropdownmenuComboDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x84170525, /DropdownmenuCombo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::DropdownmenuComboItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 1,    // ::DropdownmenuComboData
        /* mItemKey            */ 125
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xCF0129CF, /DropdownmenuCombo/Item),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::DropdownmenuComboItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 2,    // ::DropdownmenuComboData::mItem
        /* mItemKey            */ 192
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC876BD77, /DropdownmenuCombo/Itemvalue),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::DropdownmenuComboItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 3,    // ::DropdownmenuComboData::mItemvalue
        /* mItemKey            */ 189
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gCheckBoxListItemHierarchyNodes[CheckBoxListItemDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD3928E76, /CheckBoxListItem),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 2,
        /* mParentIndex        */ 0,    // ItemKey::CheckBoxListItemItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 4,    // ::CheckBoxListItemData
        /* mItemKey            */ 197
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB03A6D2C, /CheckBoxListItem/ToggleIconSwitchIndex),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 2,
        /* mParentIndex        */ 0,    // ItemKey::CheckBoxListItemItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 5,    // ::CheckBoxListItemData::mToggleIconSwitchIndex
        /* mItemKey            */ 174
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSwVersionNodeSwitchItemHierarchyNodes[SwVersionNodeSwitchItemDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xDCA69363, /SwVersionNodeSwitchItem),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 3,
        /* mParentIndex        */ 0,    // ItemKey::SwVersionNodeSwitchItemItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 6,    // ::SwVersionNodeSwitchItemData
        /* mItemKey            */ 206
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7F3187FB, /SwVersionNodeSwitchItem/ToggleNodeIndex),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 3,
        /* mParentIndex        */ 0,    // ItemKey::SwVersionNodeSwitchItemItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 7,    // ::SwVersionNodeSwitchItemData::mToggleNodeIndex
        /* mItemKey            */ 120
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gDisplaySettingsModeHierarchyNodes[DisplaySettingsModeDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB3364696, /DisplaySettingsMode),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 4,
        /* mParentIndex        */ 0,    // ItemKey::DisplaySettingsModeItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 8,    // ::DisplaySettingsModeData
        /* mItemKey            */ 176
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x365190E5, /DisplaySettingsMode/CurrModeVal),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 4,
        /* mParentIndex        */ 0,    // ItemKey::DisplaySettingsModeItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 9,    // ::DisplaySettingsModeData::mCurrModeVal
        /* mItemKey            */ 62
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gDisplaySettingsBrightnessHierarchyNodes[DisplaySettingsBrightnessDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x067F8780, /DisplaySettingsBrightness),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 5,
        /* mParentIndex        */ 0,    // ItemKey::DisplaySettingsBrightnessItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 10,    // ::DisplaySettingsBrightnessData
        /* mItemKey            */ 10
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x8E31D044, /DisplaySettingsBrightness/CurrBrightnessVal),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 5,
        /* mParentIndex        */ 0,    // ItemKey::DisplaySettingsBrightnessItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 11,    // ::DisplaySettingsBrightnessData::mCurrBrightnessVal
        /* mItemKey            */ 137
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gBrightnessIncValHierarchyNodes[BrightnessIncValDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x8DA99CD0, /BrightnessIncVal),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 6,
        /* mParentIndex        */ 0,    // ItemKey::BrightnessIncValItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 12,    // ::BrightnessIncValData
        /* mItemKey            */ 136
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x142C18F2, /BrightnessIncVal/isClicked_Inc),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 6,
        /* mParentIndex        */ 0,    // ItemKey::BrightnessIncValItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 13,    // ::BrightnessIncValData::misClicked_Inc
        /* mItemKey            */ 22
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gBrightnessDecValHierarchyNodes[BrightnessDecValDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA4E8DCD4, /BrightnessDecVal),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 7,
        /* mParentIndex        */ 0,    // ItemKey::BrightnessDecValItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 14,    // ::BrightnessDecValData
        /* mItemKey            */ 159
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x436DCFAC, /BrightnessDecVal/isClicked_Dec),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 7,
        /* mParentIndex        */ 0,    // ItemKey::BrightnessDecValItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 15,    // ::BrightnessDecValData::misClicked_Dec
        /* mItemKey            */ 81
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gGenPopupMsgHierarchyNodes[GenPopupMsgDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x396C9BB8, /GenPopupMsg),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 8,
        /* mParentIndex        */ 0,    // ItemKey::GenPopupMsgItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 16,    // ::GenPopupMsgData
        /* mItemKey            */ 64
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3B59C5C7, /GenPopupMsg/CurrMsg),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 8,
        /* mParentIndex        */ 0,    // ItemKey::GenPopupMsgItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 17,    // ::GenPopupMsgData::mCurrMsg
        /* mItemKey            */ 68
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gCAAudiolevelUpdateItemHierarchyNodes[CAAudiolevelUpdateItemDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x610D7472, /CAAudiolevelUpdateItem),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 9,
        /* mParentIndex        */ 0,    // ItemKey::CAAudiolevelUpdateItemItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 18,    // ::CAAudiolevelUpdateItemData
        /* mItemKey            */ 108
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD7BD15F1, /CAAudiolevelUpdateItem/CAAudiolevelIndex),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 9,
        /* mParentIndex        */ 0,    // ItemKey::CAAudiolevelUpdateItemItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 19,    // ::CAAudiolevelUpdateItemData::mCAAudiolevelIndex
        /* mItemKey            */ 200
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gCAMICBeepAudiolevelUpdateItemHierarchyNodes[CAMICBeepAudiolevelUpdateItemDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x60AEA6E5, /CAMICBeepAudiolevelUpdateItem),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 10,
        /* mParentIndex        */ 0,    // ItemKey::CAMICBeepAudiolevelUpdateItemItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 20,    // ::CAMICBeepAudiolevelUpdateItemData
        /* mItemKey            */ 106
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xFB7067AA, /CAMICBeepAudiolevelUpdateItem/CAMicBeepAudiolevelIndex),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 10,
        /* mParentIndex        */ 0,    // ItemKey::CAMICBeepAudiolevelUpdateItemItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 21,    // ::CAMICBeepAudiolevelUpdateItemData::mCAMicBeepAudiolevelIndex
        /* mItemKey            */ 241
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gBasslevelUpdateItemHierarchyNodes[BasslevelUpdateItemDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x86F18393, /BasslevelUpdateItem),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 11,
        /* mParentIndex        */ 0,    // ItemKey::BasslevelUpdateItemItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 22,    // ::BasslevelUpdateItemData
        /* mItemKey            */ 130
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x903F4989, /BasslevelUpdateItem/BasslevelIndex),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 11,
        /* mParentIndex        */ 0,    // ItemKey::BasslevelUpdateItemItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 23,    // ::BasslevelUpdateItemData::mBasslevelIndex
        /* mItemKey            */ 142
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gRVCBrightnessUpdateItemHierarchyNodes[RVCBrightnessUpdateItemDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x9DC50CBA, /RVCBrightnessUpdateItem),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 12,
        /* mParentIndex        */ 0,    // ItemKey::RVCBrightnessUpdateItemItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 24,    // ::RVCBrightnessUpdateItemData
        /* mItemKey            */ 155
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD007BDEB, /RVCBrightnessUpdateItem/RVCBrightnessIndex),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 12,
        /* mParentIndex        */ 0,    // ItemKey::RVCBrightnessUpdateItemItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 25,    // ::RVCBrightnessUpdateItemData::mRVCBrightnessIndex
        /* mItemKey            */ 193
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gRVCContrastUpdateItemHierarchyNodes[RVCContrastUpdateItemDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x008C9EDF, /RVCContrastUpdateItem),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 13,
        /* mParentIndex        */ 0,    // ItemKey::RVCContrastUpdateItemItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 26,    // ::RVCContrastUpdateItemData
        /* mItemKey            */ 2
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xDCDCEDA7, /RVCContrastUpdateItem/RVCContrastIndex),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 13,
        /* mParentIndex        */ 0,    // ItemKey::RVCContrastUpdateItemItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 27,    // ::RVCContrastUpdateItemData::mRVCContrastIndex
        /* mItemKey            */ 207
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gDispSettingValueUpdateItemHierarchyNodes[DispSettingValueUpdateItemDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x08DC7868, /DispSettingValueUpdateItem),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 14,
        /* mParentIndex        */ 0,    // ItemKey::DispSettingValueUpdateItemItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 28,    // ::DispSettingValueUpdateItemData
        /* mItemKey            */ 13
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF1A369DB, /DispSettingValueUpdateItem/DispLevelIndex),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 14,
        /* mParentIndex        */ 0,    // ItemKey::DispSettingValueUpdateItemItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 29,    // ::DispSettingValueUpdateItemData::mDispLevelIndex
        /* mItemKey            */ 232
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF8D8AD97, /DispSettingValueUpdateItem/GreyBrightnessTextCumImage),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 14,
        /* mParentIndex        */ 0,    // ItemKey::DispSettingValueUpdateItemItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 30,    // ::DispSettingValueUpdateItemData::mGreyBrightnessTextCumImage
        /* mItemKey            */ 237
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gHourValueUpdateItemHierarchyNodes[HourValueUpdateItemDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xEADAF24B, /HourValueUpdateItem),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 15,
        /* mParentIndex        */ 0,    // ItemKey::HourValueUpdateItemItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 31,    // ::HourValueUpdateItemData
        /* mItemKey            */ 224
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x0214F80B, /HourValueUpdateItem/HourValueIndex),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 15,
        /* mParentIndex        */ 0,    // ItemKey::HourValueUpdateItemItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 32,    // ::HourValueUpdateItemData::mHourValueIndex
        /* mItemKey            */ 6
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gTreblelevelUpdateItemHierarchyNodes[TreblelevelUpdateItemDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB62DC843, /TreblelevelUpdateItem),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 16,
        /* mParentIndex        */ 0,    // ItemKey::TreblelevelUpdateItemItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 33,    // ::TreblelevelUpdateItemData
        /* mItemKey            */ 179
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xBAAFB2DE, /TreblelevelUpdateItem/TreblelevelIndex),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 16,
        /* mParentIndex        */ 0,    // ItemKey::TreblelevelUpdateItemItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 34,    // ::TreblelevelUpdateItemData::mTreblelevelIndex
        /* mItemKey            */ 181
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gBalancelevelUpdateItemHierarchyNodes[BalancelevelUpdateItemDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x83EBDB55, /BalancelevelUpdateItem),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 17,
        /* mParentIndex        */ 0,    // ItemKey::BalancelevelUpdateItemItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 35,    // ::BalancelevelUpdateItemData
        /* mItemKey            */ 124
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x9B566878, /BalancelevelUpdateItem/BalancelevelIndex),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 17,
        /* mParentIndex        */ 0,    // ItemKey::BalancelevelUpdateItemItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 36,    // ::BalancelevelUpdateItemData::mBalancelevelIndex
        /* mItemKey            */ 152
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gLanguageSettingMenuHierarchyNodes[LanguageSettingMenuDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xACE176F2, /LanguageSettingMenu),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 18,
        /* mParentIndex        */ 0,    // ItemKey::LanguageSettingMenuItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 37,    // ::LanguageSettingMenuData
        /* mItemKey            */ 167
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x8FFBD51A, /LanguageSettingMenu/languageval),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 18,
        /* mParentIndex        */ 0,    // ItemKey::LanguageSettingMenuItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 38,    // ::LanguageSettingMenuData::mlanguageval
        /* mItemKey            */ 141
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x99F30FB2, /LanguageSettingMenu/LanguageActiveColorTextInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 18,
        /* mParentIndex        */ 0,    // ItemKey::LanguageSettingMenuItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 39,    // ::LanguageSettingMenuData::mLanguageActiveColorTextInfo
        /* mItemKey            */ 150
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gOEMPINKeyInfoHierarchyNodes[OEMPINKeyInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF4EDA952, /OEMPINKeyInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 19,
        /* mParentIndex        */ 0,    // ItemKey::OEMPINKeyInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 40,    // ::OEMPINKeyInfoData
        /* mItemKey            */ 234
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x2CDE987B, /OEMPINKeyInfo/PressedKey),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 19,
        /* mParentIndex        */ 0,    // ItemKey::OEMPINKeyInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 41,    // ::OEMPINKeyInfoData::mPressedKey
        /* mItemKey            */ 51
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gOEMPINCursorStateHierarchyNodes[OEMPINCursorStateDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB384A309, /OEMPINCursorState),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 20,
        /* mParentIndex        */ 0,    // ItemKey::OEMPINCursorStateItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 42,    // ::OEMPINCursorStateData
        /* mItemKey            */ 177
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE0B4C9B0, /OEMPINCursorState/State1),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 20,
        /* mParentIndex        */ 0,    // ItemKey::OEMPINCursorStateItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 43,    // ::OEMPINCursorStateData::mState1
        /* mItemKey            */ 211
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD27F2D45, /OEMPINCursorState/State2),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 20,
        /* mParentIndex        */ 0,    // ItemKey::OEMPINCursorStateItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 44,    // ::OEMPINCursorStateData::mState2
        /* mItemKey            */ 196
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x87269695, /OEMPINCursorState/State3),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 20,
        /* mParentIndex        */ 0,    // ItemKey::OEMPINCursorStateItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 45,    // ::OEMPINCursorStateData::mState3
        /* mItemKey            */ 131
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF0DE6A03, /OEMPINCursorState/State4),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 20,
        /* mParentIndex        */ 0,    // ItemKey::OEMPINCursorStateItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 46,    // ::OEMPINCursorStateData::mState4
        /* mItemKey            */ 231
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gOEMPINEditableStateHierarchyNodes[OEMPINEditableStateDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x91B75E81, /OEMPINEditableState),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 21,
        /* mParentIndex        */ 0,    // ItemKey::OEMPINEditableStateItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 47,    // ::OEMPINEditableStateData
        /* mItemKey            */ 144
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF6D0EBE5, /OEMPINEditableState/EditableState1),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 21,
        /* mParentIndex        */ 0,    // ItemKey::OEMPINEditableStateItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 48,    // ::OEMPINEditableStateData::mEditableState1
        /* mItemKey            */ 236
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC94490CD, /OEMPINEditableState/EditableState2),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 21,
        /* mParentIndex        */ 0,    // ItemKey::OEMPINEditableStateItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 49,    // ::OEMPINEditableStateData::mEditableState2
        /* mItemKey            */ 190
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xDB0E3460, /OEMPINEditableState/EditableState3),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 21,
        /* mParentIndex        */ 0,    // ItemKey::OEMPINEditableStateItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 50,    // ::OEMPINEditableStateData::mEditableState3
        /* mItemKey            */ 204
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xADA0D986, /OEMPINEditableState/EditableState4),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 21,
        /* mParentIndex        */ 0,    // ItemKey::OEMPINEditableStateItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 51,    // ::OEMPINEditableStateData::mEditableState4
        /* mItemKey            */ 170
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gOEMPIN1TextInfoHierarchyNodes[OEMPIN1TextInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xFF9AE165, /OEMPIN1TextInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 22,
        /* mParentIndex        */ 0,    // ItemKey::OEMPIN1TextInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 52,    // ::OEMPIN1TextInfoData
        /* mItemKey            */ 243
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5BFC5ECC, /OEMPIN1TextInfo/Text),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 22,
        /* mParentIndex        */ 0,    // ItemKey::OEMPIN1TextInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 53,    // ::OEMPIN1TextInfoData::mText
        /* mItemKey            */ 98
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gOEMPIN2TextInfoHierarchyNodes[OEMPIN2TextInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x24792886, /OEMPIN2TextInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 23,
        /* mParentIndex        */ 0,    // ItemKey::OEMPIN2TextInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 54,    // ::OEMPIN2TextInfoData
        /* mItemKey            */ 40
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x9CE8FD2F, /OEMPIN2TextInfo/Text),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 23,
        /* mParentIndex        */ 0,    // ItemKey::OEMPIN2TextInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 55,    // ::OEMPIN2TextInfoData::mText
        /* mItemKey            */ 154
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gOEMPIN3TextInfoHierarchyNodes[OEMPIN3TextInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD076F8E6, /OEMPIN3TextInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 24,
        /* mParentIndex        */ 0,    // ItemKey::OEMPIN3TextInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 56,    // ::OEMPIN3TextInfoData
        /* mItemKey            */ 194
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x14CD44B4, /OEMPIN3TextInfo/Text),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 24,
        /* mParentIndex        */ 0,    // ItemKey::OEMPIN3TextInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 57,    // ::OEMPIN3TextInfoData::mText
        /* mItemKey            */ 24
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gOEMPIN4TextInfoHierarchyNodes[OEMPIN4TextInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE73B6F40, /OEMPIN4TextInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 25,
        /* mParentIndex        */ 0,    // ItemKey::OEMPIN4TextInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 58,    // ::OEMPIN4TextInfoData
        /* mItemKey            */ 218
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB5DF5579, /OEMPIN4TextInfo/Text),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 25,
        /* mParentIndex        */ 0,    // ItemKey::OEMPIN4TextInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 59,    // ::OEMPIN4TextInfoData::mText
        /* mItemKey            */ 178
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gOEMKey1InputHierarchyNodes[OEMKey1InputDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xAF99678B, /OEMKey1Input),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 26,
        /* mParentIndex        */ 0,    // ItemKey::OEMKey1InputItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 60,    // ::OEMKey1InputData
        /* mItemKey            */ 173
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xEAF56B45, /OEMKey1Input/Text),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 26,
        /* mParentIndex        */ 0,    // ItemKey::OEMKey1InputItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 61,    // ::OEMKey1InputData::mText
        /* mItemKey            */ 225
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gOEMKey2InputHierarchyNodes[OEMKey2InputDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5295A4BD, /OEMKey2Input),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 27,
        /* mParentIndex        */ 0,    // ItemKey::OEMKey2InputItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 62,    // ::OEMKey2InputData
        /* mItemKey            */ 91
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5E78CFBB, /OEMKey2Input/Text),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 27,
        /* mParentIndex        */ 0,    // ItemKey::OEMKey2InputItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 63,    // ::OEMKey2InputData::mText
        /* mItemKey            */ 103
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gOEMKey3InputHierarchyNodes[OEMKey3InputDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x865434B7, /OEMKey3Input),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 28,
        /* mParentIndex        */ 0,    // ItemKey::OEMKey3InputItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 64,    // ::OEMKey3InputData
        /* mItemKey            */ 129
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xBDBDFE6B, /OEMKey3Input/Text),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 28,
        /* mParentIndex        */ 0,    // ItemKey::OEMKey3InputItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 65,    // ::OEMKey3InputData::mText
        /* mItemKey            */ 183
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gOEMKey4InputHierarchyNodes[OEMKey4InputDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5C8B5C98, /OEMKey4Input),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 29,
        /* mParentIndex        */ 0,    // ItemKey::OEMKey4InputItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 66,    // ::OEMKey4InputData
        /* mItemKey            */ 102
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xEC37F95F, /OEMKey4Input/Text),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 29,
        /* mParentIndex        */ 0,    // ItemKey::OEMKey4InputItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 67,    // ::OEMKey4InputData::mText
        /* mItemKey            */ 227
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gOEMAuthenticationInfoTextHierarchyNodes[OEMAuthenticationInfoTextDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3A87D943, /OEMAuthenticationInfoText),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 30,
        /* mParentIndex        */ 0,    // ItemKey::OEMAuthenticationInfoTextItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 68,    // ::OEMAuthenticationInfoTextData
        /* mItemKey            */ 67
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x6E11F788, /OEMAuthenticationInfoText/Text),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 30,
        /* mParentIndex        */ 0,    // ItemKey::OEMAuthenticationInfoTextItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 69,    // ::OEMAuthenticationInfoTextData::mText
        /* mItemKey            */ 112
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xCE36FC2A, /OEMAuthenticationInfoText/TextColor),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 30,
        /* mParentIndex        */ 0,    // ItemKey::OEMAuthenticationInfoTextItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 70,    // ::OEMAuthenticationInfoTextData::mTextColor
        /* mItemKey            */ 191
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF92B1D86, /OEMAuthenticationInfoText/SpellerEnable),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 30,
        /* mParentIndex        */ 0,    // ItemKey::OEMAuthenticationInfoTextItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 71,    // ::OEMAuthenticationInfoTextData::mSpellerEnable
        /* mItemKey            */ 238
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x4C0392C3, /OEMAuthenticationInfoText/ActiveStatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 30,
        /* mParentIndex        */ 0,    // ItemKey::OEMAuthenticationInfoTextItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 72,    // ::OEMAuthenticationInfoTextData::mActiveStatus
        /* mItemKey            */ 86
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gOEMSpeedLockUpdateHierarchyNodes[OEMSpeedLockUpdateDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD703D7D0, /OEMSpeedLockUpdate),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 31,
        /* mParentIndex        */ 0,    // ItemKey::OEMSpeedLockUpdateItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 73,    // ::OEMSpeedLockUpdateData
        /* mItemKey            */ 199
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x84B6033F, /OEMSpeedLockUpdate/status),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 31,
        /* mParentIndex        */ 0,    // ItemKey::OEMSpeedLockUpdateItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 74,    // ::OEMSpeedLockUpdateData::mstatus
        /* mItemKey            */ 127
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gNaftaLang_SettingMenuHierarchyNodes[NaftaLang_SettingMenuDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3BFF1657, /NaftaLang_SettingMenu),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 32,
        /* mParentIndex        */ 0,    // ItemKey::NaftaLang_SettingMenuItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 75,    // ::NaftaLang_SettingMenuData
        /* mItemKey            */ 70
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x1E44C3AC, /NaftaLang_SettingMenu/naftalang_val),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 32,
        /* mParentIndex        */ 0,    // ItemKey::NaftaLang_SettingMenuItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 76,    // ::NaftaLang_SettingMenuData::mnaftalang_val
        /* mItemKey            */ 33
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x2F903491, /NaftaLang_SettingMenu/naftalang_ActiveColor),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 32,
        /* mParentIndex        */ 0,    // ItemKey::NaftaLang_SettingMenuItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 77,    // ::NaftaLang_SettingMenuData::mnaftalang_ActiveColor
        /* mItemKey            */ 54
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gvmsCabinMenuHierarchyNodes[vmsCabinMenuDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3E5C6161, /vmsCabinMenu),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 33,
        /* mParentIndex        */ 0,    // ItemKey::vmsCabinMenuItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 78,    // ::vmsCabinMenuData
        /* mItemKey            */ 73
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x130ED7E4, /vmsCabinMenu/vmsSourceName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 33,
        /* mParentIndex        */ 0,    // ItemKey::vmsCabinMenuItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 79,    // ::vmsCabinMenuData::mvmsSourceName
        /* mItemKey            */ 19
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x0D7F6E37, /vmsCabinMenu/vmsSourceRadioBtnEnDisb),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 33,
        /* mParentIndex        */ 0,    // ItemKey::vmsCabinMenuItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 80,    // ::vmsCabinMenuData::mvmsSourceRadioBtnEnDisb
        /* mItemKey            */ 15
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x8D1AE1A9, /vmsCabinMenu/vmsSourceTextEnDisb),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 33,
        /* mParentIndex        */ 0,    // ItemKey::vmsCabinMenuItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 81,    // ::vmsCabinMenuData::mvmsSourceTextEnDisb
        /* mItemKey            */ 135
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gClockHourSettingValueHierarchyNodes[ClockHourSettingValueDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x95271AD8, /ClockHourSettingValue),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 34,
        /* mParentIndex        */ 0,    // ItemKey::ClockHourSettingValueItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 82,    // ::ClockHourSettingValueData
        /* mItemKey            */ 145
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x2BA1018D, /ClockHourSettingValue/CurrHourVal),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 34,
        /* mParentIndex        */ 0,    // ItemKey::ClockHourSettingValueItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 83,    // ::ClockHourSettingValueData::mCurrHourVal
        /* mItemKey            */ 49
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gClockMinuteSettingValueHierarchyNodes[ClockMinuteSettingValueDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x08064D29, /ClockMinuteSettingValue),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 35,
        /* mParentIndex        */ 0,    // ItemKey::ClockMinuteSettingValueItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 84,    // ::ClockMinuteSettingValueData
        /* mItemKey            */ 12
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x236F0220, /ClockMinuteSettingValue/CurrMinuteVal),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 35,
        /* mParentIndex        */ 0,    // ItemKey::ClockMinuteSettingValueItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 85,    // ::ClockMinuteSettingValueData::mCurrMinuteVal
        /* mItemKey            */ 36
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gClockTimeZoneHierarchyNodes[ClockTimeZoneDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xAF97F2D2, /ClockTimeZone),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 36,
        /* mParentIndex        */ 0,    // ItemKey::ClockTimeZoneItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 86,    // ::ClockTimeZoneData
        /* mItemKey            */ 172
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x43364BBE, /ClockTimeZone/OFFSetHourText),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 36,
        /* mParentIndex        */ 0,    // ItemKey::ClockTimeZoneItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 87,    // ::ClockTimeZoneData::mOFFSetHourText
        /* mItemKey            */ 80
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC801A1B6, /ClockTimeZone/OFFSetMinuteText),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 36,
        /* mParentIndex        */ 0,    // ItemKey::ClockTimeZoneItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 88,    // ::ClockTimeZoneData::mOFFSetMinuteText
        /* mItemKey            */ 188
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSpeedDependentVolumeControlHierarchyNodes[SpeedDependentVolumeControlDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x172E540F, /SpeedDependentVolumeControl),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 37,
        /* mParentIndex        */ 0,    // ItemKey::SpeedDependentVolumeControlItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 89,    // ::SpeedDependentVolumeControlData
        /* mItemKey            */ 26
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x658A135F, /SpeedDependentVolumeControl/ToggleOFF),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 37,
        /* mParentIndex        */ 0,    // ItemKey::SpeedDependentVolumeControlItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 90,    // ::SpeedDependentVolumeControlData::mToggleOFF
        /* mItemKey            */ 109
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x23728839, /SpeedDependentVolumeControl/ToggleLVL1),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 37,
        /* mParentIndex        */ 0,    // ItemKey::SpeedDependentVolumeControlItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 91,    // ::SpeedDependentVolumeControlData::mToggleLVL1
        /* mItemKey            */ 37
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x4B03D75B, /SpeedDependentVolumeControl/ToggleLVL2),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 37,
        /* mParentIndex        */ 0,    // ItemKey::SpeedDependentVolumeControlItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 92,    // ::SpeedDependentVolumeControlData::mToggleLVL2
        /* mItemKey            */ 85
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE9199384, /SpeedDependentVolumeControl/ToggleLVL3),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 37,
        /* mParentIndex        */ 0,    // ItemKey::SpeedDependentVolumeControlItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 93,    // ::SpeedDependentVolumeControlData::mToggleLVL3
        /* mItemKey            */ 220
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF5314537, /SpeedDependentVolumeControl/ColorOFF),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 37,
        /* mParentIndex        */ 0,    // ItemKey::SpeedDependentVolumeControlItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 94,    // ::SpeedDependentVolumeControlData::mColorOFF
        /* mItemKey            */ 235
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD263A925, /SpeedDependentVolumeControl/ColorLVL1),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 37,
        /* mParentIndex        */ 0,    // ItemKey::SpeedDependentVolumeControlItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 95,    // ::SpeedDependentVolumeControlData::mColorLVL1
        /* mItemKey            */ 195
    },
    { // 7
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE041C4E1, /SpeedDependentVolumeControl/ColorLVL2),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 37,
        /* mParentIndex        */ 0,    // ItemKey::SpeedDependentVolumeControlItem
        /* mLocalIndex         */ 7,
        /* mDescriptorIndex    */ 96,    // ::SpeedDependentVolumeControlData::mColorLVL2
        /* mItemKey            */ 210
    },
    { // 8
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xEF5A6312, /SpeedDependentVolumeControl/ColorLVL3),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 37,
        /* mParentIndex        */ 0,    // ItemKey::SpeedDependentVolumeControlItem
        /* mLocalIndex         */ 8,
        /* mDescriptorIndex    */ 97,    // ::SpeedDependentVolumeControlData::mColorLVL3
        /* mItemKey            */ 229
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gPrivateModeSettingHierarchyNodes[PrivateModeSettingDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3A21A723, /PrivateModeSetting),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 38,
        /* mParentIndex        */ 0,    // ItemKey::PrivateModeSettingItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 98,    // ::PrivateModeSettingData
        /* mItemKey            */ 65
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x141911A8, /PrivateModeSetting/Private_1_Toggle),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 38,
        /* mParentIndex        */ 0,    // ItemKey::PrivateModeSettingItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 99,    // ::PrivateModeSettingData::mPrivate_1_Toggle
        /* mItemKey            */ 21
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xBA5FCDF2, /PrivateModeSetting/Private_2_Toggle),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 38,
        /* mParentIndex        */ 0,    // ItemKey::PrivateModeSettingItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 100,    // ::PrivateModeSettingData::mPrivate_2_Toggle
        /* mItemKey            */ 180
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x074D01B4, /PrivateModeSetting/Private_3_Toggle),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 38,
        /* mParentIndex        */ 0,    // ItemKey::PrivateModeSettingItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 101,    // ::PrivateModeSettingData::mPrivate_3_Toggle
        /* mItemKey            */ 11
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x0539EE2F, /PrivateModeSetting/Private_1_ColorChg),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 38,
        /* mParentIndex        */ 0,    // ItemKey::PrivateModeSettingItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 102,    // ::PrivateModeSettingData::mPrivate_1_ColorChg
        /* mItemKey            */ 8
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x556D305C, /PrivateModeSetting/Private_2_ColorChg),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 38,
        /* mParentIndex        */ 0,    // ItemKey::PrivateModeSettingItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 103,    // ::PrivateModeSettingData::mPrivate_2_ColorChg
        /* mItemKey            */ 95
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5101E7A5, /PrivateModeSetting/Private_3_ColorChg),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 38,
        /* mParentIndex        */ 0,    // ItemKey::PrivateModeSettingItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 104,    // ::PrivateModeSettingData::mPrivate_3_ColorChg
        /* mItemKey            */ 90
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gDTCHeadingUpdateItemHierarchyNodes[DTCHeadingUpdateItemDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA6223550, /DTCHeadingUpdateItem),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 39,
        /* mParentIndex        */ 0,    // ItemKey::DTCHeadingUpdateItemItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 105,    // ::DTCHeadingUpdateItemData
        /* mItemKey            */ 162
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x50A3F1F6, /DTCHeadingUpdateItem/DTCHeadingData),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 39,
        /* mParentIndex        */ 0,    // ItemKey::DTCHeadingUpdateItemItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 106,    // ::DTCHeadingUpdateItemData::mDTCHeadingData
        /* mItemKey            */ 89
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSOASEquilizerPresetHierarchyNodes[SOASEquilizerPresetDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xDC499CC7, /SOASEquilizerPreset),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 40,
        /* mParentIndex        */ 0,    // ItemKey::SOASEquilizerPresetItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 107,    // ::SOASEquilizerPresetData
        /* mItemKey            */ 205
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x6CE64C95, /SOASEquilizerPreset/ToggleEqlPrstFLAT),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 40,
        /* mParentIndex        */ 0,    // ItemKey::SOASEquilizerPresetItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 108,    // ::SOASEquilizerPresetData::mToggleEqlPrstFLAT
        /* mItemKey            */ 111
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA84959D6, /SOASEquilizerPreset/ToggleEqlPrstPOP),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 40,
        /* mParentIndex        */ 0,    // ItemKey::SOASEquilizerPresetItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 109,    // ::SOASEquilizerPresetData::mToggleEqlPrstPOP
        /* mItemKey            */ 164
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x6F4E3BB0, /SOASEquilizerPreset/ToggleEqlPrstROCK),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 40,
        /* mParentIndex        */ 0,    // ItemKey::SOASEquilizerPresetItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 110,    // ::SOASEquilizerPresetData::mToggleEqlPrstROCK
        /* mItemKey            */ 113
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x36452E34, /SOASEquilizerPreset/ToggleEqlPrstHIPHOP),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 40,
        /* mParentIndex        */ 0,    // ItemKey::SOASEquilizerPresetItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 111,    // ::SOASEquilizerPresetData::mToggleEqlPrstHIPHOP
        /* mItemKey            */ 61
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x30A9193B, /SOASEquilizerPreset/ToggleEqlPrstCLASSIC),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 40,
        /* mParentIndex        */ 0,    // ItemKey::SOASEquilizerPresetItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 112,    // ::SOASEquilizerPresetData::mToggleEqlPrstCLASSIC
        /* mItemKey            */ 55
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x145E03DD, /SOASEquilizerPreset/ToggleEqlPrstJAZZ),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 40,
        /* mParentIndex        */ 0,    // ItemKey::SOASEquilizerPresetItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 113,    // ::SOASEquilizerPresetData::mToggleEqlPrstJAZZ
        /* mItemKey            */ 23
    },
    { // 7
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD9E1F219, /SOASEquilizerPreset/ColorEqlPrstFLAT),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 40,
        /* mParentIndex        */ 0,    // ItemKey::SOASEquilizerPresetItem
        /* mLocalIndex         */ 7,
        /* mDescriptorIndex    */ 114,    // ::SOASEquilizerPresetData::mColorEqlPrstFLAT
        /* mItemKey            */ 202
    },
    { // 8
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB1297800, /SOASEquilizerPreset/ColorEqlPrstPOP),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 40,
        /* mParentIndex        */ 0,    // ItemKey::SOASEquilizerPresetItem
        /* mLocalIndex         */ 8,
        /* mDescriptorIndex    */ 115,    // ::SOASEquilizerPresetData::mColorEqlPrstPOP
        /* mItemKey            */ 175
    },
    { // 9
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x6048F4D3, /SOASEquilizerPreset/ColorEqlPrstROCK),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 40,
        /* mParentIndex        */ 0,    // ItemKey::SOASEquilizerPresetItem
        /* mLocalIndex         */ 9,
        /* mDescriptorIndex    */ 116,    // ::SOASEquilizerPresetData::mColorEqlPrstROCK
        /* mItemKey            */ 105
    },
    { // 10
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA5C2377D, /SOASEquilizerPreset/ColorEqlPrstHIPHOP),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 40,
        /* mParentIndex        */ 0,    // ItemKey::SOASEquilizerPresetItem
        /* mLocalIndex         */ 10,
        /* mDescriptorIndex    */ 117,    // ::SOASEquilizerPresetData::mColorEqlPrstHIPHOP
        /* mItemKey            */ 161
    },
    { // 11
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x105C60C7, /SOASEquilizerPreset/ColorEqlPrstCLASSIC),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 40,
        /* mParentIndex        */ 0,    // ItemKey::SOASEquilizerPresetItem
        /* mLocalIndex         */ 11,
        /* mDescriptorIndex    */ 118,    // ::SOASEquilizerPresetData::mColorEqlPrstCLASSIC
        /* mItemKey            */ 18
    },
    { // 12
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA3FAC5F5, /SOASEquilizerPreset/ColorEqlPrstJAZZ),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 40,
        /* mParentIndex        */ 0,    // ItemKey::SOASEquilizerPresetItem
        /* mLocalIndex         */ 12,
        /* mDescriptorIndex    */ 119,    // ::SOASEquilizerPresetData::mColorEqlPrstJAZZ
        /* mItemKey            */ 158
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gClockDateFormatHierarchyNodes[ClockDateFormatDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x9FF76DC1, /ClockDateFormat),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 41,
        /* mParentIndex        */ 0,    // ItemKey::ClockDateFormatItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 120,    // ::ClockDateFormatData
        /* mItemKey            */ 157
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA501847E, /ClockDateFormat/ToggleClkDateFmt1),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 41,
        /* mParentIndex        */ 0,    // ItemKey::ClockDateFormatItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 121,    // ::ClockDateFormatData::mToggleClkDateFmt1
        /* mItemKey            */ 160
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xEB551144, /ClockDateFormat/ToggleClkDateFmt2),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 41,
        /* mParentIndex        */ 0,    // ItemKey::ClockDateFormatItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 122,    // ::ClockDateFormatData::mToggleClkDateFmt2
        /* mItemKey            */ 226
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x1D0CF4B3, /ClockDateFormat/ToggleClkDateFmt3),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 41,
        /* mParentIndex        */ 0,    // ItemKey::ClockDateFormatItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 123,    // ::ClockDateFormatData::mToggleClkDateFmt3
        /* mItemKey            */ 31
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x4ECB582F, /ClockDateFormat/ToggleClkDateFmt4),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 41,
        /* mParentIndex        */ 0,    // ItemKey::ClockDateFormatItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 124,    // ::ClockDateFormatData::mToggleClkDateFmt4
        /* mItemKey            */ 88
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x00F53C84, /ClockDateFormat/ToggleClkDateFmt5),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 41,
        /* mParentIndex        */ 0,    // ItemKey::ClockDateFormatItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 125,    // ::ClockDateFormatData::mToggleClkDateFmt5
        /* mItemKey            */ 3
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x2468836A, /ClockDateFormat/ToggleClkDateFmt6),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 41,
        /* mParentIndex        */ 0,    // ItemKey::ClockDateFormatItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 126,    // ::ClockDateFormatData::mToggleClkDateFmt6
        /* mItemKey            */ 39
    },
    { // 7
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x105B6239, /ClockDateFormat/ColorClkDateFmt1),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 41,
        /* mParentIndex        */ 0,    // ItemKey::ClockDateFormatItem
        /* mLocalIndex         */ 7,
        /* mDescriptorIndex    */ 127,    // ::ClockDateFormatData::mColorClkDateFmt1
        /* mItemKey            */ 17
    },
    { // 8
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5C18F9B3, /ClockDateFormat/ColorClkDateFmt2),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 41,
        /* mParentIndex        */ 0,    // ItemKey::ClockDateFormatItem
        /* mLocalIndex         */ 8,
        /* mDescriptorIndex    */ 128,    // ::ClockDateFormatData::mColorClkDateFmt2
        /* mItemKey            */ 100
    },
    { // 9
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x31FAA577, /ClockDateFormat/ColorClkDateFmt3),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 41,
        /* mParentIndex        */ 0,    // ItemKey::ClockDateFormatItem
        /* mLocalIndex         */ 9,
        /* mDescriptorIndex    */ 129,    // ::ClockDateFormatData::mColorClkDateFmt3
        /* mItemKey            */ 57
    },
    { // 10
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE153845A, /ClockDateFormat/ColorClkDateFmt4),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 41,
        /* mParentIndex        */ 0,    // ItemKey::ClockDateFormatItem
        /* mLocalIndex         */ 10,
        /* mDescriptorIndex    */ 130,    // ::ClockDateFormatData::mColorClkDateFmt4
        /* mItemKey            */ 212
    },
    { // 11
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x0C13D9DA, /ClockDateFormat/ColorClkDateFmt5),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 41,
        /* mParentIndex        */ 0,    // ItemKey::ClockDateFormatItem
        /* mLocalIndex         */ 11,
        /* mDescriptorIndex    */ 131,    // ::ClockDateFormatData::mColorClkDateFmt5
        /* mItemKey            */ 14
    },
    { // 12
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x1C7A7AA7, /ClockDateFormat/ColorClkDateFmt6),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 41,
        /* mParentIndex        */ 0,    // ItemKey::ClockDateFormatItem
        /* mLocalIndex         */ 12,
        /* mDescriptorIndex    */ 132,    // ::ClockDateFormatData::mColorClkDateFmt6
        /* mItemKey            */ 30
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gDateFmtUpdateItemHierarchyNodes[DateFmtUpdateItemDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x2982643D, /DateFmtUpdateItem),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 42,
        /* mParentIndex        */ 0,    // ItemKey::DateFmtUpdateItemItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 133,    // ::DateFmtUpdateItemData
        /* mItemKey            */ 46
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x255C7535, /DateFmtUpdateItem/DateItem),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 42,
        /* mParentIndex        */ 0,    // ItemKey::DateFmtUpdateItemItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 134,    // ::DateFmtUpdateItemData::mDateItem
        /* mItemKey            */ 41
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gMasterGadgetSystemHierarchyNodes[MasterGadgetSystemDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xDD0F3479, /MasterGadgetSystem),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 43,
        /* mParentIndex        */ 0,    // ItemKey::MasterGadgetSystemItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 135,    // ::MasterGadgetSystemData
        /* mItemKey            */ 208
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x80FA8AA1, /MasterGadgetSystem/Timevalue),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 43,
        /* mParentIndex        */ 0,    // ItemKey::MasterGadgetSystemItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 136,    // ::MasterGadgetSystemData::mTimevalue
        /* mItemKey            */ 122
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5C01FA4B, /MasterGadgetSystem/TimeAmPm),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 43,
        /* mParentIndex        */ 0,    // ItemKey::MasterGadgetSystemItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 137,    // ::MasterGadgetSystemData::mTimeAmPm
        /* mItemKey            */ 99
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSWUpdateDetailsHierarchyNodes[SWUpdateDetailsDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x00FA9FD7, /SWUpdateDetails),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 44,
        /* mParentIndex        */ 0,    // ItemKey::SWUpdateDetailsItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 138,    // ::SWUpdateDetailsData
        /* mItemKey            */ 4
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x97D18470, /SWUpdateDetails/MainCurrentVersion),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 44,
        /* mParentIndex        */ 0,    // ItemKey::SWUpdateDetailsItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 139,    // ::SWUpdateDetailsData::mMainCurrentVersion
        /* mItemKey            */ 148
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSWUpdateMainHierarchyNodes[SWUpdateMainDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3BE92E58, /SWUpdateMain),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 45,
        /* mParentIndex        */ 0,    // ItemKey::SWUpdateMainItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 140,    // ::SWUpdateMainData
        /* mItemKey            */ 69
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5B4C1E20, /SWUpdateMain/MediaVersion),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 45,
        /* mParentIndex        */ 0,    // ItemKey::SWUpdateMainItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 141,    // ::SWUpdateMainData::mMediaVersion
        /* mItemKey            */ 96
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x1D7BFF23, /SWUpdateMain/CurrentVersion),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 45,
        /* mParentIndex        */ 0,    // ItemKey::SWUpdateMainItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 142,    // ::SWUpdateMainData::mCurrentVersion
        /* mItemKey            */ 32
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x19384583, /SWUpdateMain/IsNeedFlashing),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 45,
        /* mParentIndex        */ 0,    // ItemKey::SWUpdateMainItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 143,    // ::SWUpdateMainData::mIsNeedFlashing
        /* mItemKey            */ 27
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x4D894638, /SWUpdateMain/EstimatedTime),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 45,
        /* mParentIndex        */ 0,    // ItemKey::SWUpdateMainItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 144,    // ::SWUpdateMainData::mEstimatedTime
        /* mItemKey            */ 87
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x96E70FCB, /SWUpdateMain/SameversionText),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 45,
        /* mParentIndex        */ 0,    // ItemKey::SWUpdateMainItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 145,    // ::SWUpdateMainData::mSameversionText
        /* mItemKey            */ 147
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x8CD6181B, /SWUpdateMain/IsSameversionTextvisible),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 45,
        /* mParentIndex        */ 0,    // ItemKey::SWUpdateMainItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 146,    // ::SWUpdateMainData::mIsSameversionTextvisible
        /* mItemKey            */ 134
    },
    { // 7
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x74FD6095, /SWUpdateMain/EstimatedTimeofFota),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 45,
        /* mParentIndex        */ 0,    // ItemKey::SWUpdateMainItem
        /* mLocalIndex         */ 7,
        /* mDescriptorIndex    */ 147,    // ::SWUpdateMainData::mEstimatedTimeofFota
        /* mItemKey            */ 114
    },
    { // 8
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xBE2582CD, /SWUpdateMain/EstimatedTotalOtaTime),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 45,
        /* mParentIndex        */ 0,    // ItemKey::SWUpdateMainItem
        /* mLocalIndex         */ 8,
        /* mDescriptorIndex    */ 148,    // ::SWUpdateMainData::mEstimatedTotalOtaTime
        /* mItemKey            */ 184
    },
    { // 9
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xFCFFFCCE, /SWUpdateMain/EstimatedMinutes),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 45,
        /* mParentIndex        */ 0,    // ItemKey::SWUpdateMainItem
        /* mLocalIndex         */ 9,
        /* mDescriptorIndex    */ 149,    // ::SWUpdateMainData::mEstimatedMinutes
        /* mItemKey            */ 242
    },
    { // 10
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3331A135, /SWUpdateMain/CustomerPopupDetails),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 45,
        /* mParentIndex        */ 0,    // ItemKey::SWUpdateMainItem
        /* mLocalIndex         */ 10,
        /* mDescriptorIndex    */ 150,    // ::SWUpdateMainData::mCustomerPopupDetails
        /* mItemKey            */ 59
    },
    { // 11
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x8EA41ACC, /SWUpdateMain/BackGroundUpdTextInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 45,
        /* mParentIndex        */ 0,    // ItemKey::SWUpdateMainItem
        /* mLocalIndex         */ 11,
        /* mDescriptorIndex    */ 151,    // ::SWUpdateMainData::mBackGroundUpdTextInfo
        /* mItemKey            */ 138
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSWUpdateHistoryDetailsHierarchyNodes[SWUpdateHistoryDetailsDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x9680E09E, /SWUpdateHistoryDetails),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 46,
        /* mParentIndex        */ 0,    // ItemKey::SWUpdateHistoryDetailsItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 152,    // ::SWUpdateHistoryDetailsData
        /* mItemKey            */ 146
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x761E0152, /SWUpdateHistoryDetails/HistoryDetail),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 46,
        /* mParentIndex        */ 0,    // ItemKey::SWUpdateHistoryDetailsItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 153,    // ::SWUpdateHistoryDetailsData::mHistoryDetail
        /* mItemKey            */ 115
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSwivelPopupHierarchyNodes[SwivelPopupDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x243769F5, /SwivelPopup),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 47,
        /* mParentIndex        */ 0,    // ItemKey::SwivelPopupItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 154,    // ::SwivelPopupData
        /* mItemKey            */ 38
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x2022F19E, /SwivelPopup/ActiveSwivelStateAuto),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 47,
        /* mParentIndex        */ 0,    // ItemKey::SwivelPopupItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 155,    // ::SwivelPopupData::mActiveSwivelStateAuto
        /* mItemKey            */ 34
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7AAB5962, /SwivelPopup/ActiveSwivelStateUp),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 47,
        /* mParentIndex        */ 0,    // ItemKey::SwivelPopupItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 156,    // ::SwivelPopupData::mActiveSwivelStateUp
        /* mItemKey            */ 118
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x43268C39, /SwivelPopup/ActiveSwivelStateDown),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 47,
        /* mParentIndex        */ 0,    // ItemKey::SwivelPopupItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 157,    // ::SwivelPopupData::mActiveSwivelStateDown
        /* mItemKey            */ 79
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSWUpdateStickInfoHierarchyNodes[SWUpdateStickInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x99AA3C3E, /SWUpdateStickInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 48,
        /* mParentIndex        */ 0,    // ItemKey::SWUpdateStickInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 158,    // ::SWUpdateStickInfoData
        /* mItemKey            */ 149
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xEA0E4C99, /SWUpdateStickInfo/ValidDownloadStickStatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 48,
        /* mParentIndex        */ 0,    // ItemKey::SWUpdateStickInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 159,    // ::SWUpdateStickInfoData::mValidDownloadStickStatus
        /* mItemKey            */ 222
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x79DCF2B6, /SWUpdateStickInfo/UsbStickAvailableStatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 48,
        /* mParentIndex        */ 0,    // ItemKey::SWUpdateStickInfoItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 160,    // ::SWUpdateStickInfoData::mUsbStickAvailableStatus
        /* mItemKey            */ 116
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x0E76C726, /SWUpdateStickInfo/IsNotSameVersion),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 48,
        /* mParentIndex        */ 0,    // ItemKey::SWUpdateStickInfoItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 161,    // ::SWUpdateStickInfoData::mIsNotSameVersion
        /* mItemKey            */ 16
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSWQuickUpdateEnableHierarchyNodes[SWQuickUpdateEnableDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xADDEBB9C, /SWQuickUpdateEnable),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 49,
        /* mParentIndex        */ 0,    // ItemKey::SWQuickUpdateEnableItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 162,    // ::SWQuickUpdateEnableData
        /* mItemKey            */ 171
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x8FDCD8FD, /SWQuickUpdateEnable/Buttonenable),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 49,
        /* mParentIndex        */ 0,    // ItemKey::SWQuickUpdateEnableItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 163,    // ::SWQuickUpdateEnableData::mButtonenable
        /* mItemKey            */ 140
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSWFullUpdateEnableHierarchyNodes[SWFullUpdateEnableDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xAD24221C, /SWFullUpdateEnable),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 50,
        /* mParentIndex        */ 0,    // ItemKey::SWFullUpdateEnableItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 164,    // ::SWFullUpdateEnableData
        /* mItemKey            */ 168
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3F829438, /SWFullUpdateEnable/Buttonenable),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 50,
        /* mParentIndex        */ 0,    // ItemKey::SWFullUpdateEnableItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 165,    // ::SWFullUpdateEnableData::mButtonenable
        /* mItemKey            */ 74
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSWUpdateDetailsEnableHierarchyNodes[SWUpdateDetailsEnableDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC6A6117E, /SWUpdateDetailsEnable),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 51,
        /* mParentIndex        */ 0,    // ItemKey::SWUpdateDetailsEnableItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 166,    // ::SWUpdateDetailsEnableData
        /* mItemKey            */ 187
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x40EA09D4, /SWUpdateDetailsEnable/Buttonenable),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 51,
        /* mParentIndex        */ 0,    // ItemKey::SWUpdateDetailsEnableItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 167,    // ::SWUpdateDetailsEnableData::mButtonenable
        /* mItemKey            */ 76
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSWUpdatebackbuttonEnableHierarchyNodes[SWUpdatebackbuttonEnableDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3E26858E, /SWUpdatebackbuttonEnable),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 52,
        /* mParentIndex        */ 0,    // ItemKey::SWUpdatebackbuttonEnableItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 168,    // ::SWUpdatebackbuttonEnableData
        /* mItemKey            */ 72
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x55225457, /SWUpdatebackbuttonEnable/Buttonenable),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 52,
        /* mParentIndex        */ 0,    // ItemKey::SWUpdatebackbuttonEnableItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 169,    // ::SWUpdatebackbuttonEnableData::mButtonenable
        /* mItemKey            */ 94
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gDownlaodTypeInfoHierarchyNodes[DownlaodTypeInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x8BA42D5B, /DownlaodTypeInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 53,
        /* mParentIndex        */ 0,    // ItemKey::DownlaodTypeInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 170,    // ::DownlaodTypeInfoData
        /* mItemKey            */ 133
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7FC76C8B, /DownlaodTypeInfo/DownlaodType),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 53,
        /* mParentIndex        */ 0,    // ItemKey::DownlaodTypeInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 171,    // ::DownlaodTypeInfoData::mDownlaodType
        /* mItemKey            */ 121
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSWUpdateNameSmartHierarchyNodes[SWUpdateNameSmartDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x131851B9, /SWUpdateNameSmart),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 54,
        /* mParentIndex        */ 0,    // ItemKey::SWUpdateNameSmartItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 172,    // ::SWUpdateNameSmartData
        /* mItemKey            */ 20
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE4CEDC31, /SWUpdateNameSmart/isVisble),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 54,
        /* mParentIndex        */ 0,    // ItemKey::SWUpdateNameSmartItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 173,    // ::SWUpdateNameSmartData::misVisble
        /* mItemKey            */ 215
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gPopupTextHierarchyNodes[PopupTextDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3A6158CD, /PopupText),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 55,
        /* mParentIndex        */ 0,    // ItemKey::PopupTextItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 174,    // ::PopupTextData
        /* mItemKey            */ 66
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x9F086D63, /PopupText/Line1),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 55,
        /* mParentIndex        */ 0,    // ItemKey::PopupTextItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 175,    // ::PopupTextData::mLine1
        /* mItemKey            */ 156
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA8548007, /PopupText/Line2),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 55,
        /* mParentIndex        */ 0,    // ItemKey::PopupTextItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 176,    // ::PopupTextData::mLine2
        /* mItemKey            */ 165
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xBC052768, /PopupText/Line3),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 55,
        /* mParentIndex        */ 0,    // ItemKey::PopupTextItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 177,    // ::PopupTextData::mLine3
        /* mItemKey            */ 182
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD6405BDE, /PopupText/Line4),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 55,
        /* mParentIndex        */ 0,    // ItemKey::PopupTextItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 178,    // ::PopupTextData::mLine4
        /* mItemKey            */ 198
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE76BFE35, /PopupText/Line5),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 55,
        /* mParentIndex        */ 0,    // ItemKey::PopupTextItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 179,    // ::PopupTextData::mLine5
        /* mItemKey            */ 219
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF1AA12B1, /PopupText/Line6),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 55,
        /* mParentIndex        */ 0,    // ItemKey::PopupTextItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 180,    // ::PopupTextData::mLine6
        /* mItemKey            */ 233
    },
    { // 7
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x918D611E, /PopupText/ProgressValue),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 55,
        /* mParentIndex        */ 0,    // ItemKey::PopupTextItem
        /* mLocalIndex         */ 7,
        /* mDescriptorIndex    */ 181,    // ::PopupTextData::mProgressValue
        /* mItemKey            */ 143
    },
    { // 8
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x037AB729, /PopupText/ProgressValueStr),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 55,
        /* mParentIndex        */ 0,    // ItemKey::PopupTextItem
        /* mLocalIndex         */ 8,
        /* mDescriptorIndex    */ 182,    // ::PopupTextData::mProgressValueStr
        /* mItemKey            */ 7
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSystemInstallationHierarchyNodes[SystemInstallationDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC552890F, /SystemInstallation),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 56,
        /* mParentIndex        */ 0,    // ItemKey::SystemInstallationItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 183,    // ::SystemInstallationData
        /* mItemKey            */ 186
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x9A88F4AD, /SystemInstallation/SysInstallationProgressValue),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 56,
        /* mParentIndex        */ 0,    // ItemKey::SystemInstallationItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 184,    // ::SystemInstallationData::mSysInstallationProgressValue
        /* mItemKey            */ 151
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x0605103E, /SystemInstallation/SysInstallationProgressValueStr),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 56,
        /* mParentIndex        */ 0,    // ItemKey::SystemInstallationItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 185,    // ::SystemInstallationData::mSysInstallationProgressValueStr
        /* mItemKey            */ 9
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE978D1AE, /SystemInstallation/Textbox1Visibility),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 56,
        /* mParentIndex        */ 0,    // ItemKey::SystemInstallationItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 186,    // ::SystemInstallationData::mTextbox1Visibility
        /* mItemKey            */ 221
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3297E072, /SystemInstallation/Textbox2Visibility),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 56,
        /* mParentIndex        */ 0,    // ItemKey::SystemInstallationItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 187,    // ::SystemInstallationData::mTextbox2Visibility
        /* mItemKey            */ 58
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x26B4CA9C, /SystemInstallation/Textbox3Visibility),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 56,
        /* mParentIndex        */ 0,    // ItemKey::SystemInstallationItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 188,    // ::SystemInstallationData::mTextbox3Visibility
        /* mItemKey            */ 42
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x9BDFDC92, /SystemInstallation/Textbox4Visibility),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 56,
        /* mParentIndex        */ 0,    // ItemKey::SystemInstallationItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 189,    // ::SystemInstallationData::mTextbox4Visibility
        /* mItemKey            */ 153
    },
    { // 7
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x66B7193A, /SystemInstallation/Textbox5Visibility),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 56,
        /* mParentIndex        */ 0,    // ItemKey::SystemInstallationItem
        /* mLocalIndex         */ 7,
        /* mDescriptorIndex    */ 190,    // ::SystemInstallationData::mTextbox5Visibility
        /* mItemKey            */ 110
    },
    { // 8
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x60EDF25E, /SystemInstallation/WaitAnimationVisibility),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 56,
        /* mParentIndex        */ 0,    // ItemKey::SystemInstallationItem
        /* mLocalIndex         */ 8,
        /* mDescriptorIndex    */ 191,    // ::SystemInstallationData::mWaitAnimationVisibility
        /* mItemKey            */ 107
    },
    { // 9
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x8417C17C, /SystemInstallation/FailureMessage),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 56,
        /* mParentIndex        */ 0,    // ItemKey::SystemInstallationItem
        /* mLocalIndex         */ 9,
        /* mDescriptorIndex    */ 192,    // ::SystemInstallationData::mFailureMessage
        /* mItemKey            */ 126
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSWDetailsTextHierarchyNodes[SWDetailsTextDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x42726831, /SWDetailsText),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 57,
        /* mParentIndex        */ 0,    // ItemKey::SWDetailsTextItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 193,    // ::SWDetailsTextData
        /* mItemKey            */ 78
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x1B1FBD60, /SWDetailsText/SubModuleName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 57,
        /* mParentIndex        */ 0,    // ItemKey::SWDetailsTextItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 194,    // ::SWDetailsTextData::mSubModuleName
        /* mItemKey            */ 29
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA86B76A1, /SWDetailsText/CurrentVersion),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 57,
        /* mParentIndex        */ 0,    // ItemKey::SWDetailsTextItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 195,    // ::SWDetailsTextData::mCurrentVersion
        /* mItemKey            */ 166
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x887990C9, /SWDetailsText/MediaVersion),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 57,
        /* mParentIndex        */ 0,    // ItemKey::SWDetailsTextItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 196,    // ::SWDetailsTextData::mMediaVersion
        /* mItemKey            */ 132
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSWHistoryDetailsTextHierarchyNodes[SWHistoryDetailsTextDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x276622A9, /SWHistoryDetailsText),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 58,
        /* mParentIndex        */ 0,    // ItemKey::SWHistoryDetailsTextItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 197,    // ::SWHistoryDetailsTextData
        /* mItemKey            */ 43
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x2D545769, /SWHistoryDetailsText/devicename),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 58,
        /* mParentIndex        */ 0,    // ItemKey::SWHistoryDetailsTextItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 198,    // ::SWHistoryDetailsTextData::mdevicename
        /* mItemKey            */ 52
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5B4EEC1E, /SWHistoryDetailsText/modulename),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 58,
        /* mParentIndex        */ 0,    // ItemKey::SWHistoryDetailsTextItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 199,    // ::SWHistoryDetailsTextData::mmodulename
        /* mItemKey            */ 97
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE001A1D4, /SWHistoryDetailsText/submodule),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 58,
        /* mParentIndex        */ 0,    // ItemKey::SWHistoryDetailsTextItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 200,    // ::SWHistoryDetailsTextData::msubmodule
        /* mItemKey            */ 209
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7A132C55, /SWHistoryDetailsText/submoduleversion),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 58,
        /* mParentIndex        */ 0,    // ItemKey::SWHistoryDetailsTextItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 201,    // ::SWHistoryDetailsTextData::msubmoduleversion
        /* mItemKey            */ 117
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSWUpdateResultsHierarchyNodes[SWUpdateResultsDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE24D14D3, /SWUpdateResults),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 59,
        /* mParentIndex        */ 0,    // ItemKey::SWUpdateResultsItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 202,    // ::SWUpdateResultsData
        /* mItemKey            */ 213
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x4A667544, /SWUpdateResults/ComponentName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 59,
        /* mParentIndex        */ 0,    // ItemKey::SWUpdateResultsItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 203,    // ::SWUpdateResultsData::mComponentName
        /* mItemKey            */ 84
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x199084A3, /SWUpdateResults/UpdateResult),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 59,
        /* mParentIndex        */ 0,    // ItemKey::SWUpdateResultsItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 204,    // ::SWUpdateResultsData::mUpdateResult
        /* mItemKey            */ 28
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x0029FC28, /SWUpdateResults/Reserved),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 59,
        /* mParentIndex        */ 0,    // ItemKey::SWUpdateResultsItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 205,    // ::SWUpdateResultsData::mReserved
        /* mItemKey            */ 1
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSystemsettingMainIconHierarchyNodes[SystemsettingMainIconDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x2AF5AB75, /SystemsettingMainIcon),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 60,
        /* mParentIndex        */ 0,    // ItemKey::SystemsettingMainIconItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 206,    // ::SystemsettingMainIconData
        /* mItemKey            */ 48
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x34CE59BB, /SystemsettingMainIcon/SystemMainIconNormalBitmap),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 60,
        /* mParentIndex        */ 0,    // ItemKey::SystemsettingMainIconItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 207,    // ::SystemsettingMainIconData::mSystemMainIconNormalBitmap
        /* mItemKey            */ 60
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x1692580D, /SystemsettingMainIcon/SystemMainIconPressedBitmap),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 60,
        /* mParentIndex        */ 0,    // ItemKey::SystemsettingMainIconItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 208,    // ::SystemsettingMainIconData::mSystemMainIconPressedBitmap
        /* mItemKey            */ 25
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x40BFD152, /SystemsettingMainIcon/SystemMainIconFocusedBitmap),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 60,
        /* mParentIndex        */ 0,    // ItemKey::SystemsettingMainIconItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 209,    // ::SystemsettingMainIconData::mSystemMainIconFocusedBitmap
        /* mItemKey            */ 75
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5F4853D0, /SystemsettingMainIcon/SystemMainNameInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 60,
        /* mParentIndex        */ 0,    // ItemKey::SystemsettingMainIconItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 210,    // ::SystemsettingMainIconData::mSystemMainNameInfo
        /* mItemKey            */ 104
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xAD7BC8EE, /SystemsettingMainIcon/SystemMainActiveTextInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 60,
        /* mParentIndex        */ 0,    // ItemKey::SystemsettingMainIconItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 211,    // ::SystemsettingMainIconData::mSystemMainActiveTextInfo
        /* mItemKey            */ 169
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gCabinAsettingMainIconHierarchyNodes[CabinAsettingMainIconDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x2A922C89, /CabinAsettingMainIcon),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 61,
        /* mParentIndex        */ 0,    // ItemKey::CabinAsettingMainIconItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 212,    // ::CabinAsettingMainIconData
        /* mItemKey            */ 47
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF9755176, /CabinAsettingMainIcon/CabinAMainIconNormalBitmap),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 61,
        /* mParentIndex        */ 0,    // ItemKey::CabinAsettingMainIconItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 213,    // ::CabinAsettingMainIconData::mCabinAMainIconNormalBitmap
        /* mItemKey            */ 239
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x01839B6B, /CabinAsettingMainIcon/CabinAMainIconPressedBitmap),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 61,
        /* mParentIndex        */ 0,    // ItemKey::CabinAsettingMainIconItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 214,    // ::CabinAsettingMainIconData::mCabinAMainIconPressedBitmap
        /* mItemKey            */ 5
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD9924D2C, /CabinAsettingMainIcon/CabinAMainIconFocusedBitmap),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 61,
        /* mParentIndex        */ 0,    // ItemKey::CabinAsettingMainIconItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 215,    // ::CabinAsettingMainIconData::mCabinAMainIconFocusedBitmap
        /* mItemKey            */ 201
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x81A09F4F, /CabinAsettingMainIcon/CabinAMainIconDisbaledBitmap),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 61,
        /* mParentIndex        */ 0,    // ItemKey::CabinAsettingMainIconItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 216,    // ::CabinAsettingMainIconData::mCabinAMainIconDisbaledBitmap
        /* mItemKey            */ 123
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xFA05932A, /CabinAsettingMainIcon/CabinAMainNameInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 61,
        /* mParentIndex        */ 0,    // ItemKey::CabinAsettingMainIconItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 217,    // ::CabinAsettingMainIconData::mCabinAMainNameInfo
        /* mItemKey            */ 240
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xED310FEE, /CabinAsettingMainIcon/CabinAMainActiveTextInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 61,
        /* mParentIndex        */ 0,    // ItemKey::CabinAsettingMainIconItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 218,    // ::CabinAsettingMainIconData::mCabinAMainActiveTextInfo
        /* mItemKey            */ 228
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gCabinBsettingMainIconHierarchyNodes[CabinBsettingMainIconDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7D981217, /CabinBsettingMainIcon),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 62,
        /* mParentIndex        */ 0,    // ItemKey::CabinBsettingMainIconItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 219,    // ::CabinBsettingMainIconData
        /* mItemKey            */ 119
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE5059E3C, /CabinBsettingMainIcon/CabinBMainIconNormalBitmap),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 62,
        /* mParentIndex        */ 0,    // ItemKey::CabinBsettingMainIconItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 220,    // ::CabinBsettingMainIconData::mCabinBMainIconNormalBitmap
        /* mItemKey            */ 216
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE6927F20, /CabinBsettingMainIcon/CabinBMainIconPressedBitmap),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 62,
        /* mParentIndex        */ 0,    // ItemKey::CabinBsettingMainIconItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 221,    // ::CabinBsettingMainIconData::mCabinBMainIconPressedBitmap
        /* mItemKey            */ 217
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x36A721B8, /CabinBsettingMainIcon/CabinBMainIconFocusedBitmap),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 62,
        /* mParentIndex        */ 0,    // ItemKey::CabinBsettingMainIconItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 222,    // ::CabinBsettingMainIconData::mCabinBMainIconFocusedBitmap
        /* mItemKey            */ 63
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xEA0F17EB, /CabinBsettingMainIcon/CabinBMainNameInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 62,
        /* mParentIndex        */ 0,    // ItemKey::CabinBsettingMainIconItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 223,    // ::CabinBsettingMainIconData::mCabinBMainNameInfo
        /* mItemKey            */ 223
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x2C1AE8DB, /CabinBsettingMainIcon/CabinBMainActiveTextInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 62,
        /* mParentIndex        */ 0,    // ItemKey::CabinBsettingMainIconItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 224,    // ::CabinBsettingMainIconData::mCabinBMainActiveTextInfo
        /* mItemKey            */ 50
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSystemsettingSwVerNDLanguageIconHierarchyNodes[SystemsettingSwVerNDLanguageIconDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x297A0F4E, /SystemsettingSwVerNDLanguageIcon),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 63,
        /* mParentIndex        */ 0,    // ItemKey::SystemsettingSwVerNDLanguageIconItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 225,    // ::SystemsettingSwVerNDLanguageIconData
        /* mItemKey            */ 45
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x41EB29D4, /SystemsettingSwVerNDLanguageIcon/SystemSwVerNDLanguageIconNormalBitmap),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 63,
        /* mParentIndex        */ 0,    // ItemKey::SystemsettingSwVerNDLanguageIconItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 226,    // ::SystemsettingSwVerNDLanguageIconData::mSystemSwVerNDLanguageIconNormalBitmap
        /* mItemKey            */ 77
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x22D74F88, /SystemsettingSwVerNDLanguageIcon/SystemSwVerNDLanguageIconPressedBitmap),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 63,
        /* mParentIndex        */ 0,    // ItemKey::SystemsettingSwVerNDLanguageIconItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 227,    // ::SystemsettingSwVerNDLanguageIconData::mSystemSwVerNDLanguageIconPressedBitmap
        /* mItemKey            */ 35
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x8F7C9A29, /SystemsettingSwVerNDLanguageIcon/SystemSwVerNDLanguageIconFocusedBitmap),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 63,
        /* mParentIndex        */ 0,    // ItemKey::SystemsettingSwVerNDLanguageIconItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 228,    // ::SystemsettingSwVerNDLanguageIconData::mSystemSwVerNDLanguageIconFocusedBitmap
        /* mItemKey            */ 139
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gspeedlockUpdatesVisibilityHierarchyNodes[speedlockUpdatesVisibilityDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC03465D9, /speedlockUpdatesVisibility),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 64,
        /* mParentIndex        */ 0,    // ItemKey::speedlockUpdatesVisibilityItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 229,    // ::speedlockUpdatesVisibilityData
        /* mItemKey            */ 185
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x529A6887, /speedlockUpdatesVisibility/SpeedlocktextVisibility),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 64,
        /* mParentIndex        */ 0,    // ItemKey::speedlockUpdatesVisibilityItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 230,    // ::speedlockUpdatesVisibilityData::mSpeedlocktextVisibility
        /* mItemKey            */ 92
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA6AA4F46, /speedlockUpdatesVisibility/SpeedlocktextVisibility_1),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 64,
        /* mParentIndex        */ 0,    // ItemKey::speedlockUpdatesVisibilityItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 231,    // ::speedlockUpdatesVisibilityData::mSpeedlocktextVisibility_1
        /* mItemKey            */ 163
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gbluetoothVisibilityHierarchyNodes[bluetoothVisibilityDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x319D5C41, /bluetoothVisibility),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 65,
        /* mParentIndex        */ 0,    // ItemKey::bluetoothVisibilityItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 232,    // ::bluetoothVisibilityData
        /* mItemKey            */ 56
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xDAAE4DE8, /bluetoothVisibility/ButtonHighlight),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 65,
        /* mParentIndex        */ 0,    // ItemKey::bluetoothVisibilityItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 233,    // ::bluetoothVisibilityData::mButtonHighlight
        /* mItemKey            */ 203
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gPopUpButtonVisibilityHierarchyNodes[PopUpButtonVisibilityDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x52A1F00C, /PopUpButtonVisibility),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 66,
        /* mParentIndex        */ 0,    // ItemKey::PopUpButtonVisibilityItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 234,    // ::PopUpButtonVisibilityData
        /* mItemKey            */ 93
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xEFC4D3B0, /PopUpButtonVisibility/ButtonVisibility),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 66,
        /* mParentIndex        */ 0,    // ItemKey::PopUpButtonVisibilityItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 235,    // ::PopUpButtonVisibilityData::mButtonVisibility
        /* mItemKey            */ 230
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSWUpdateListItemEnableHierarchyNodes[SWUpdateListItemEnableDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x85EB1607, /SWUpdateListItemEnable),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 67,
        /* mParentIndex        */ 0,    // ItemKey::SWUpdateListItemEnableItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 236,    // ::SWUpdateListItemEnableData
        /* mItemKey            */ 128
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3DF63BB5, /SWUpdateListItemEnable/ButtonEnable),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 67,
        /* mParentIndex        */ 0,    // ItemKey::SWUpdateListItemEnableItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 237,    // ::SWUpdateListItemEnableData::mButtonEnable
        /* mItemKey            */ 71
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gMISStage1ResultsHierarchyNodes[MISStage1ResultsDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x49ECE951, /MISStage1Results),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 68,
        /* mParentIndex        */ 0,    // ItemKey::MISStage1ResultsItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 238,    // ::MISStage1ResultsData
        /* mItemKey            */ 83
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5C193BD5, /MISStage1Results/AbortButtonEnable),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 68,
        /* mParentIndex        */ 0,    // ItemKey::MISStage1ResultsItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 239,    // ::MISStage1ResultsData::mAbortButtonEnable
        /* mItemKey            */ 101
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x2E599D77, /MISStage1Results/NextbuttonEnable),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 68,
        /* mParentIndex        */ 0,    // ItemKey::MISStage1ResultsItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 240,    // ::MISStage1ResultsData::mNextbuttonEnable
        /* mItemKey            */ 53
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x288B7EA9, /MISStage1Results/DetailsbuttonEnable),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 68,
        /* mParentIndex        */ 0,    // ItemKey::MISStage1ResultsItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 241,    // ::MISStage1ResultsData::mDetailsbuttonEnable
        /* mItemKey            */ 44
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gListScrollBarInfoHierarchyNodes[ListScrollBarInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x44E9662C, /ListScrollBarInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 69,
        /* mParentIndex        */ 0,    // ItemKey::ListScrollBarInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 242,    // ::ListScrollBarInfoData
        /* mItemKey            */ 82
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE2697E96, /ListScrollBarInfo/Enabled),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 69,
        /* mParentIndex        */ 0,    // ItemKey::ListScrollBarInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 243,    // ::ListScrollBarInfoData::mEnabled
        /* mItemKey            */ 214
    },
};

// array of pointers to all hierarchy nodes - sorted by HashId
const ::Courier::Internal::DataBinding::DataItemHierarchyNode * const gGlobalHierachyNodeTable[cGlobalDataItemHierarchyNodeCount] = {
    &gInvalidHierarchyNodes[0],
    &gSWUpdateResultsHierarchyNodes[3],
    &gRVCContrastUpdateItemHierarchyNodes[0],
    &gClockDateFormatHierarchyNodes[5],
    &gSWUpdateDetailsHierarchyNodes[0],
    &gCabinAsettingMainIconHierarchyNodes[2],
    &gHourValueUpdateItemHierarchyNodes[1],
    &gPopupTextHierarchyNodes[8],
    &gPrivateModeSettingHierarchyNodes[4],
    &gSystemInstallationHierarchyNodes[2],
    &gDisplaySettingsBrightnessHierarchyNodes[0],
    &gPrivateModeSettingHierarchyNodes[3],
    &gClockMinuteSettingValueHierarchyNodes[0],
    &gDispSettingValueUpdateItemHierarchyNodes[0],
    &gClockDateFormatHierarchyNodes[11],
    &gvmsCabinMenuHierarchyNodes[2],
    &gSWUpdateStickInfoHierarchyNodes[3],
    &gClockDateFormatHierarchyNodes[7],
    &gSOASEquilizerPresetHierarchyNodes[11],
    &gvmsCabinMenuHierarchyNodes[1],
    &gSWUpdateNameSmartHierarchyNodes[0],
    &gPrivateModeSettingHierarchyNodes[1],
    &gBrightnessIncValHierarchyNodes[1],
    &gSOASEquilizerPresetHierarchyNodes[6],
    &gOEMPIN3TextInfoHierarchyNodes[1],
    &gSystemsettingMainIconHierarchyNodes[2],
    &gSpeedDependentVolumeControlHierarchyNodes[0],
    &gSWUpdateMainHierarchyNodes[3],
    &gSWUpdateResultsHierarchyNodes[2],
    &gSWDetailsTextHierarchyNodes[1],
    &gClockDateFormatHierarchyNodes[12],
    &gClockDateFormatHierarchyNodes[3],
    &gSWUpdateMainHierarchyNodes[2],
    &gNaftaLang_SettingMenuHierarchyNodes[1],
    &gSwivelPopupHierarchyNodes[1],
    &gSystemsettingSwVerNDLanguageIconHierarchyNodes[2],
    &gClockMinuteSettingValueHierarchyNodes[1],
    &gSpeedDependentVolumeControlHierarchyNodes[2],
    &gSwivelPopupHierarchyNodes[0],
    &gClockDateFormatHierarchyNodes[6],
    &gOEMPIN2TextInfoHierarchyNodes[0],
    &gDateFmtUpdateItemHierarchyNodes[1],
    &gSystemInstallationHierarchyNodes[5],
    &gSWHistoryDetailsTextHierarchyNodes[0],
    &gMISStage1ResultsHierarchyNodes[3],
    &gSystemsettingSwVerNDLanguageIconHierarchyNodes[0],
    &gDateFmtUpdateItemHierarchyNodes[0],
    &gCabinAsettingMainIconHierarchyNodes[0],
    &gSystemsettingMainIconHierarchyNodes[0],
    &gClockHourSettingValueHierarchyNodes[1],
    &gCabinBsettingMainIconHierarchyNodes[5],
    &gOEMPINKeyInfoHierarchyNodes[1],
    &gSWHistoryDetailsTextHierarchyNodes[1],
    &gMISStage1ResultsHierarchyNodes[2],
    &gNaftaLang_SettingMenuHierarchyNodes[2],
    &gSOASEquilizerPresetHierarchyNodes[5],
    &gbluetoothVisibilityHierarchyNodes[0],
    &gClockDateFormatHierarchyNodes[9],
    &gSystemInstallationHierarchyNodes[4],
    &gSWUpdateMainHierarchyNodes[10],
    &gSystemsettingMainIconHierarchyNodes[1],
    &gSOASEquilizerPresetHierarchyNodes[4],
    &gDisplaySettingsModeHierarchyNodes[1],
    &gCabinBsettingMainIconHierarchyNodes[3],
    &gGenPopupMsgHierarchyNodes[0],
    &gPrivateModeSettingHierarchyNodes[0],
    &gPopupTextHierarchyNodes[0],
    &gOEMAuthenticationInfoTextHierarchyNodes[0],
    &gGenPopupMsgHierarchyNodes[1],
    &gSWUpdateMainHierarchyNodes[0],
    &gNaftaLang_SettingMenuHierarchyNodes[0],
    &gSWUpdateListItemEnableHierarchyNodes[1],
    &gSWUpdatebackbuttonEnableHierarchyNodes[0],
    &gvmsCabinMenuHierarchyNodes[0],
    &gSWFullUpdateEnableHierarchyNodes[1],
    &gSystemsettingMainIconHierarchyNodes[3],
    &gSWUpdateDetailsEnableHierarchyNodes[1],
    &gSystemsettingSwVerNDLanguageIconHierarchyNodes[1],
    &gSWDetailsTextHierarchyNodes[0],
    &gSwivelPopupHierarchyNodes[3],
    &gClockTimeZoneHierarchyNodes[1],
    &gBrightnessDecValHierarchyNodes[1],
    &gListScrollBarInfoHierarchyNodes[0],
    &gMISStage1ResultsHierarchyNodes[0],
    &gSWUpdateResultsHierarchyNodes[1],
    &gSpeedDependentVolumeControlHierarchyNodes[3],
    &gOEMAuthenticationInfoTextHierarchyNodes[4],
    &gSWUpdateMainHierarchyNodes[4],
    &gClockDateFormatHierarchyNodes[4],
    &gDTCHeadingUpdateItemHierarchyNodes[1],
    &gPrivateModeSettingHierarchyNodes[6],
    &gOEMKey2InputHierarchyNodes[0],
    &gspeedlockUpdatesVisibilityHierarchyNodes[1],
    &gPopUpButtonVisibilityHierarchyNodes[0],
    &gSWUpdatebackbuttonEnableHierarchyNodes[1],
    &gPrivateModeSettingHierarchyNodes[5],
    &gSWUpdateMainHierarchyNodes[1],
    &gSWHistoryDetailsTextHierarchyNodes[2],
    &gOEMPIN1TextInfoHierarchyNodes[1],
    &gMasterGadgetSystemHierarchyNodes[2],
    &gClockDateFormatHierarchyNodes[8],
    &gMISStage1ResultsHierarchyNodes[1],
    &gOEMKey4InputHierarchyNodes[0],
    &gOEMKey2InputHierarchyNodes[1],
    &gSystemsettingMainIconHierarchyNodes[4],
    &gSOASEquilizerPresetHierarchyNodes[9],
    &gCAMICBeepAudiolevelUpdateItemHierarchyNodes[0],
    &gSystemInstallationHierarchyNodes[8],
    &gCAAudiolevelUpdateItemHierarchyNodes[0],
    &gSpeedDependentVolumeControlHierarchyNodes[1],
    &gSystemInstallationHierarchyNodes[7],
    &gSOASEquilizerPresetHierarchyNodes[1],
    &gOEMAuthenticationInfoTextHierarchyNodes[1],
    &gSOASEquilizerPresetHierarchyNodes[3],
    &gSWUpdateMainHierarchyNodes[7],
    &gSWUpdateHistoryDetailsHierarchyNodes[1],
    &gSWUpdateStickInfoHierarchyNodes[2],
    &gSWHistoryDetailsTextHierarchyNodes[4],
    &gSwivelPopupHierarchyNodes[2],
    &gCabinBsettingMainIconHierarchyNodes[0],
    &gSwVersionNodeSwitchItemHierarchyNodes[1],
    &gDownlaodTypeInfoHierarchyNodes[1],
    &gMasterGadgetSystemHierarchyNodes[1],
    &gCabinAsettingMainIconHierarchyNodes[4],
    &gBalancelevelUpdateItemHierarchyNodes[0],
    &gDropdownmenuComboHierarchyNodes[0],
    &gSystemInstallationHierarchyNodes[9],
    &gOEMSpeedLockUpdateHierarchyNodes[1],
    &gSWUpdateListItemEnableHierarchyNodes[0],
    &gOEMKey3InputHierarchyNodes[0],
    &gBasslevelUpdateItemHierarchyNodes[0],
    &gOEMPINCursorStateHierarchyNodes[3],
    &gSWDetailsTextHierarchyNodes[3],
    &gDownlaodTypeInfoHierarchyNodes[0],
    &gSWUpdateMainHierarchyNodes[6],
    &gvmsCabinMenuHierarchyNodes[3],
    &gBrightnessIncValHierarchyNodes[0],
    &gDisplaySettingsBrightnessHierarchyNodes[1],
    &gSWUpdateMainHierarchyNodes[11],
    &gSystemsettingSwVerNDLanguageIconHierarchyNodes[3],
    &gSWQuickUpdateEnableHierarchyNodes[1],
    &gLanguageSettingMenuHierarchyNodes[1],
    &gBasslevelUpdateItemHierarchyNodes[1],
    &gPopupTextHierarchyNodes[7],
    &gOEMPINEditableStateHierarchyNodes[0],
    &gClockHourSettingValueHierarchyNodes[0],
    &gSWUpdateHistoryDetailsHierarchyNodes[0],
    &gSWUpdateMainHierarchyNodes[5],
    &gSWUpdateDetailsHierarchyNodes[1],
    &gSWUpdateStickInfoHierarchyNodes[0],
    &gLanguageSettingMenuHierarchyNodes[2],
    &gSystemInstallationHierarchyNodes[1],
    &gBalancelevelUpdateItemHierarchyNodes[1],
    &gSystemInstallationHierarchyNodes[6],
    &gOEMPIN2TextInfoHierarchyNodes[1],
    &gRVCBrightnessUpdateItemHierarchyNodes[0],
    &gPopupTextHierarchyNodes[1],
    &gClockDateFormatHierarchyNodes[0],
    &gSOASEquilizerPresetHierarchyNodes[12],
    &gBrightnessDecValHierarchyNodes[0],
    &gClockDateFormatHierarchyNodes[1],
    &gSOASEquilizerPresetHierarchyNodes[10],
    &gDTCHeadingUpdateItemHierarchyNodes[0],
    &gspeedlockUpdatesVisibilityHierarchyNodes[2],
    &gSOASEquilizerPresetHierarchyNodes[2],
    &gPopupTextHierarchyNodes[2],
    &gSWDetailsTextHierarchyNodes[2],
    &gLanguageSettingMenuHierarchyNodes[0],
    &gSWFullUpdateEnableHierarchyNodes[0],
    &gSystemsettingMainIconHierarchyNodes[5],
    &gOEMPINEditableStateHierarchyNodes[4],
    &gSWQuickUpdateEnableHierarchyNodes[0],
    &gClockTimeZoneHierarchyNodes[0],
    &gOEMKey1InputHierarchyNodes[0],
    &gCheckBoxListItemHierarchyNodes[1],
    &gSOASEquilizerPresetHierarchyNodes[8],
    &gDisplaySettingsModeHierarchyNodes[0],
    &gOEMPINCursorStateHierarchyNodes[0],
    &gOEMPIN4TextInfoHierarchyNodes[1],
    &gTreblelevelUpdateItemHierarchyNodes[0],
    &gPrivateModeSettingHierarchyNodes[2],
    &gTreblelevelUpdateItemHierarchyNodes[1],
    &gPopupTextHierarchyNodes[3],
    &gOEMKey3InputHierarchyNodes[1],
    &gSWUpdateMainHierarchyNodes[8],
    &gspeedlockUpdatesVisibilityHierarchyNodes[0],
    &gSystemInstallationHierarchyNodes[0],
    &gSWUpdateDetailsEnableHierarchyNodes[0],
    &gClockTimeZoneHierarchyNodes[2],
    &gDropdownmenuComboHierarchyNodes[2],
    &gOEMPINEditableStateHierarchyNodes[2],
    &gOEMAuthenticationInfoTextHierarchyNodes[2],
    &gDropdownmenuComboHierarchyNodes[1],
    &gRVCBrightnessUpdateItemHierarchyNodes[1],
    &gOEMPIN3TextInfoHierarchyNodes[0],
    &gSpeedDependentVolumeControlHierarchyNodes[6],
    &gOEMPINCursorStateHierarchyNodes[2],
    &gCheckBoxListItemHierarchyNodes[0],
    &gPopupTextHierarchyNodes[4],
    &gOEMSpeedLockUpdateHierarchyNodes[0],
    &gCAAudiolevelUpdateItemHierarchyNodes[1],
    &gCabinAsettingMainIconHierarchyNodes[3],
    &gSOASEquilizerPresetHierarchyNodes[7],
    &gbluetoothVisibilityHierarchyNodes[1],
    &gOEMPINEditableStateHierarchyNodes[3],
    &gSOASEquilizerPresetHierarchyNodes[0],
    &gSwVersionNodeSwitchItemHierarchyNodes[0],
    &gRVCContrastUpdateItemHierarchyNodes[1],
    &gMasterGadgetSystemHierarchyNodes[0],
    &gSWHistoryDetailsTextHierarchyNodes[3],
    &gSpeedDependentVolumeControlHierarchyNodes[7],
    &gOEMPINCursorStateHierarchyNodes[1],
    &gClockDateFormatHierarchyNodes[10],
    &gSWUpdateResultsHierarchyNodes[0],
    &gListScrollBarInfoHierarchyNodes[1],
    &gSWUpdateNameSmartHierarchyNodes[1],
    &gCabinBsettingMainIconHierarchyNodes[1],
    &gCabinBsettingMainIconHierarchyNodes[2],
    &gOEMPIN4TextInfoHierarchyNodes[0],
    &gPopupTextHierarchyNodes[5],
    &gSpeedDependentVolumeControlHierarchyNodes[4],
    &gSystemInstallationHierarchyNodes[3],
    &gSWUpdateStickInfoHierarchyNodes[1],
    &gCabinBsettingMainIconHierarchyNodes[4],
    &gHourValueUpdateItemHierarchyNodes[0],
    &gOEMKey1InputHierarchyNodes[1],
    &gClockDateFormatHierarchyNodes[2],
    &gOEMKey4InputHierarchyNodes[1],
    &gCabinAsettingMainIconHierarchyNodes[6],
    &gSpeedDependentVolumeControlHierarchyNodes[8],
    &gPopUpButtonVisibilityHierarchyNodes[1],
    &gOEMPINCursorStateHierarchyNodes[4],
    &gDispSettingValueUpdateItemHierarchyNodes[1],
    &gPopupTextHierarchyNodes[6],
    &gOEMPINKeyInfoHierarchyNodes[0],
    &gSpeedDependentVolumeControlHierarchyNodes[5],
    &gOEMPINEditableStateHierarchyNodes[1],
    &gDispSettingValueUpdateItemHierarchyNodes[2],
    &gOEMAuthenticationInfoTextHierarchyNodes[3],
    &gCabinAsettingMainIconHierarchyNodes[1],
    &gCabinAsettingMainIconHierarchyNodes[5],
    &gCAMICBeepAudiolevelUpdateItemHierarchyNodes[1],
    &gSWUpdateMainHierarchyNodes[9],
    &gOEMPIN1TextInfoHierarchyNodes[0],
};

// binding source root table - indexed with BindingSourceIndex 
static const ::Courier::Internal::DataBinding::BindingSourceRootStorage gBindingSourceMap[cBindingSourceCount] = {
    { InvalidDataBindingSource::cHierarchyNodeCount, gInvalidHierarchyNodes },
    { DropdownmenuComboDataBindingSource::cHierarchyNodeCount, gDropdownmenuComboHierarchyNodes },
    { CheckBoxListItemDataBindingSource::cHierarchyNodeCount, gCheckBoxListItemHierarchyNodes },
    { SwVersionNodeSwitchItemDataBindingSource::cHierarchyNodeCount, gSwVersionNodeSwitchItemHierarchyNodes },
    { DisplaySettingsModeDataBindingSource::cHierarchyNodeCount, gDisplaySettingsModeHierarchyNodes },
    { DisplaySettingsBrightnessDataBindingSource::cHierarchyNodeCount, gDisplaySettingsBrightnessHierarchyNodes },
    { BrightnessIncValDataBindingSource::cHierarchyNodeCount, gBrightnessIncValHierarchyNodes },
    { BrightnessDecValDataBindingSource::cHierarchyNodeCount, gBrightnessDecValHierarchyNodes },
    { GenPopupMsgDataBindingSource::cHierarchyNodeCount, gGenPopupMsgHierarchyNodes },
    { CAAudiolevelUpdateItemDataBindingSource::cHierarchyNodeCount, gCAAudiolevelUpdateItemHierarchyNodes },
    { CAMICBeepAudiolevelUpdateItemDataBindingSource::cHierarchyNodeCount, gCAMICBeepAudiolevelUpdateItemHierarchyNodes },
    { BasslevelUpdateItemDataBindingSource::cHierarchyNodeCount, gBasslevelUpdateItemHierarchyNodes },
    { RVCBrightnessUpdateItemDataBindingSource::cHierarchyNodeCount, gRVCBrightnessUpdateItemHierarchyNodes },
    { RVCContrastUpdateItemDataBindingSource::cHierarchyNodeCount, gRVCContrastUpdateItemHierarchyNodes },
    { DispSettingValueUpdateItemDataBindingSource::cHierarchyNodeCount, gDispSettingValueUpdateItemHierarchyNodes },
    { HourValueUpdateItemDataBindingSource::cHierarchyNodeCount, gHourValueUpdateItemHierarchyNodes },
    { TreblelevelUpdateItemDataBindingSource::cHierarchyNodeCount, gTreblelevelUpdateItemHierarchyNodes },
    { BalancelevelUpdateItemDataBindingSource::cHierarchyNodeCount, gBalancelevelUpdateItemHierarchyNodes },
    { LanguageSettingMenuDataBindingSource::cHierarchyNodeCount, gLanguageSettingMenuHierarchyNodes },
    { OEMPINKeyInfoDataBindingSource::cHierarchyNodeCount, gOEMPINKeyInfoHierarchyNodes },
    { OEMPINCursorStateDataBindingSource::cHierarchyNodeCount, gOEMPINCursorStateHierarchyNodes },
    { OEMPINEditableStateDataBindingSource::cHierarchyNodeCount, gOEMPINEditableStateHierarchyNodes },
    { OEMPIN1TextInfoDataBindingSource::cHierarchyNodeCount, gOEMPIN1TextInfoHierarchyNodes },
    { OEMPIN2TextInfoDataBindingSource::cHierarchyNodeCount, gOEMPIN2TextInfoHierarchyNodes },
    { OEMPIN3TextInfoDataBindingSource::cHierarchyNodeCount, gOEMPIN3TextInfoHierarchyNodes },
    { OEMPIN4TextInfoDataBindingSource::cHierarchyNodeCount, gOEMPIN4TextInfoHierarchyNodes },
    { OEMKey1InputDataBindingSource::cHierarchyNodeCount, gOEMKey1InputHierarchyNodes },
    { OEMKey2InputDataBindingSource::cHierarchyNodeCount, gOEMKey2InputHierarchyNodes },
    { OEMKey3InputDataBindingSource::cHierarchyNodeCount, gOEMKey3InputHierarchyNodes },
    { OEMKey4InputDataBindingSource::cHierarchyNodeCount, gOEMKey4InputHierarchyNodes },
    { OEMAuthenticationInfoTextDataBindingSource::cHierarchyNodeCount, gOEMAuthenticationInfoTextHierarchyNodes },
    { OEMSpeedLockUpdateDataBindingSource::cHierarchyNodeCount, gOEMSpeedLockUpdateHierarchyNodes },
    { NaftaLang_SettingMenuDataBindingSource::cHierarchyNodeCount, gNaftaLang_SettingMenuHierarchyNodes },
    { vmsCabinMenuDataBindingSource::cHierarchyNodeCount, gvmsCabinMenuHierarchyNodes },
    { ClockHourSettingValueDataBindingSource::cHierarchyNodeCount, gClockHourSettingValueHierarchyNodes },
    { ClockMinuteSettingValueDataBindingSource::cHierarchyNodeCount, gClockMinuteSettingValueHierarchyNodes },
    { ClockTimeZoneDataBindingSource::cHierarchyNodeCount, gClockTimeZoneHierarchyNodes },
    { SpeedDependentVolumeControlDataBindingSource::cHierarchyNodeCount, gSpeedDependentVolumeControlHierarchyNodes },
    { PrivateModeSettingDataBindingSource::cHierarchyNodeCount, gPrivateModeSettingHierarchyNodes },
    { DTCHeadingUpdateItemDataBindingSource::cHierarchyNodeCount, gDTCHeadingUpdateItemHierarchyNodes },
    { SOASEquilizerPresetDataBindingSource::cHierarchyNodeCount, gSOASEquilizerPresetHierarchyNodes },
    { ClockDateFormatDataBindingSource::cHierarchyNodeCount, gClockDateFormatHierarchyNodes },
    { DateFmtUpdateItemDataBindingSource::cHierarchyNodeCount, gDateFmtUpdateItemHierarchyNodes },
    { MasterGadgetSystemDataBindingSource::cHierarchyNodeCount, gMasterGadgetSystemHierarchyNodes },
    { SWUpdateDetailsDataBindingSource::cHierarchyNodeCount, gSWUpdateDetailsHierarchyNodes },
    { SWUpdateMainDataBindingSource::cHierarchyNodeCount, gSWUpdateMainHierarchyNodes },
    { SWUpdateHistoryDetailsDataBindingSource::cHierarchyNodeCount, gSWUpdateHistoryDetailsHierarchyNodes },
    { SwivelPopupDataBindingSource::cHierarchyNodeCount, gSwivelPopupHierarchyNodes },
    { SWUpdateStickInfoDataBindingSource::cHierarchyNodeCount, gSWUpdateStickInfoHierarchyNodes },
    { SWQuickUpdateEnableDataBindingSource::cHierarchyNodeCount, gSWQuickUpdateEnableHierarchyNodes },
    { SWFullUpdateEnableDataBindingSource::cHierarchyNodeCount, gSWFullUpdateEnableHierarchyNodes },
    { SWUpdateDetailsEnableDataBindingSource::cHierarchyNodeCount, gSWUpdateDetailsEnableHierarchyNodes },
    { SWUpdatebackbuttonEnableDataBindingSource::cHierarchyNodeCount, gSWUpdatebackbuttonEnableHierarchyNodes },
    { DownlaodTypeInfoDataBindingSource::cHierarchyNodeCount, gDownlaodTypeInfoHierarchyNodes },
    { SWUpdateNameSmartDataBindingSource::cHierarchyNodeCount, gSWUpdateNameSmartHierarchyNodes },
    { PopupTextDataBindingSource::cHierarchyNodeCount, gPopupTextHierarchyNodes },
    { SystemInstallationDataBindingSource::cHierarchyNodeCount, gSystemInstallationHierarchyNodes },
    { SWDetailsTextDataBindingSource::cHierarchyNodeCount, gSWDetailsTextHierarchyNodes },
    { SWHistoryDetailsTextDataBindingSource::cHierarchyNodeCount, gSWHistoryDetailsTextHierarchyNodes },
    { SWUpdateResultsDataBindingSource::cHierarchyNodeCount, gSWUpdateResultsHierarchyNodes },
    { SystemsettingMainIconDataBindingSource::cHierarchyNodeCount, gSystemsettingMainIconHierarchyNodes },
    { CabinAsettingMainIconDataBindingSource::cHierarchyNodeCount, gCabinAsettingMainIconHierarchyNodes },
    { CabinBsettingMainIconDataBindingSource::cHierarchyNodeCount, gCabinBsettingMainIconHierarchyNodes },
    { SystemsettingSwVerNDLanguageIconDataBindingSource::cHierarchyNodeCount, gSystemsettingSwVerNDLanguageIconHierarchyNodes },
    { speedlockUpdatesVisibilityDataBindingSource::cHierarchyNodeCount, gspeedlockUpdatesVisibilityHierarchyNodes },
    { bluetoothVisibilityDataBindingSource::cHierarchyNodeCount, gbluetoothVisibilityHierarchyNodes },
    { PopUpButtonVisibilityDataBindingSource::cHierarchyNodeCount, gPopUpButtonVisibilityHierarchyNodes },
    { SWUpdateListItemEnableDataBindingSource::cHierarchyNodeCount, gSWUpdateListItemEnableHierarchyNodes },
    { MISStage1ResultsDataBindingSource::cHierarchyNodeCount, gMISStage1ResultsHierarchyNodes },
    { ListScrollBarInfoDataBindingSource::cHierarchyNodeCount, gListScrollBarInfoHierarchyNodes },
};

// Init function prototype
static bool InitDataBindingGenerated(void);

// Infrastructure defnition
static const ::Courier::Internal::DataBinding::DataBindingInfrastructure gInfrastructure = { 
    cGlobalDataItemHierarchyNodeCount, gGlobalHierachyNodeTable, 
    cBindingSourceCount, gBindingSourceMap,
    cDataItemDescriptorCount, gItemDesc,
    &InitDataBindingGenerated
};

// ------------------------------------------------------------------------
static bool InitDataBindingGenerated(void)
{
    /* if one of these assertion fails, increase the limits defined in Courier/DataBinding/Infrastructure.h */
    COURIER_COMPILETIME_ASSERT(cBindingSourceItemCountMax < ::Courier::cBindingSourceHierarchyNodeMax);
    COURIER_COMPILETIME_ASSERT(cDataItemDescriptorCount < ::Courier::cItemDescriptorMax);
    COURIER_COMPILETIME_ASSERT(cBindingSourceCount < ::Courier::cBindingSourceMax);

    static ::Courier::Internal::DataBinding::BindingSourceRevisionStoreImpl<cBindingSourceCount> theRevisionStore;

    bool ok = true;
    {
        FEATSTD_UNSYNCED_STATIC_OBJECT(DropdownmenuComboDataBindingSource, bsDropdownmenuCombo);
        FEATSTD_UNSYNCED_STATIC_OBJECT(CheckBoxListItemDataBindingSource, bsCheckBoxListItem);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SwVersionNodeSwitchItemDataBindingSource, bsSwVersionNodeSwitchItem);
        FEATSTD_UNSYNCED_STATIC_OBJECT(DisplaySettingsModeDataBindingSource, bsDisplaySettingsMode);
        FEATSTD_UNSYNCED_STATIC_OBJECT(DisplaySettingsBrightnessDataBindingSource, bsDisplaySettingsBrightness);
        FEATSTD_UNSYNCED_STATIC_OBJECT(BrightnessIncValDataBindingSource, bsBrightnessIncVal);
        FEATSTD_UNSYNCED_STATIC_OBJECT(BrightnessDecValDataBindingSource, bsBrightnessDecVal);
        FEATSTD_UNSYNCED_STATIC_OBJECT(GenPopupMsgDataBindingSource, bsGenPopupMsg);
        FEATSTD_UNSYNCED_STATIC_OBJECT(CAAudiolevelUpdateItemDataBindingSource, bsCAAudiolevelUpdateItem);
        FEATSTD_UNSYNCED_STATIC_OBJECT(CAMICBeepAudiolevelUpdateItemDataBindingSource, bsCAMICBeepAudiolevelUpdateItem);
        FEATSTD_UNSYNCED_STATIC_OBJECT(BasslevelUpdateItemDataBindingSource, bsBasslevelUpdateItem);
        FEATSTD_UNSYNCED_STATIC_OBJECT(RVCBrightnessUpdateItemDataBindingSource, bsRVCBrightnessUpdateItem);
        FEATSTD_UNSYNCED_STATIC_OBJECT(RVCContrastUpdateItemDataBindingSource, bsRVCContrastUpdateItem);
        FEATSTD_UNSYNCED_STATIC_OBJECT(DispSettingValueUpdateItemDataBindingSource, bsDispSettingValueUpdateItem);
        FEATSTD_UNSYNCED_STATIC_OBJECT(HourValueUpdateItemDataBindingSource, bsHourValueUpdateItem);
        FEATSTD_UNSYNCED_STATIC_OBJECT(TreblelevelUpdateItemDataBindingSource, bsTreblelevelUpdateItem);
        FEATSTD_UNSYNCED_STATIC_OBJECT(BalancelevelUpdateItemDataBindingSource, bsBalancelevelUpdateItem);
        FEATSTD_UNSYNCED_STATIC_OBJECT(LanguageSettingMenuDataBindingSource, bsLanguageSettingMenu);
        FEATSTD_UNSYNCED_STATIC_OBJECT(OEMPINKeyInfoDataBindingSource, bsOEMPINKeyInfo);
        FEATSTD_UNSYNCED_STATIC_OBJECT(OEMPINCursorStateDataBindingSource, bsOEMPINCursorState);
        FEATSTD_UNSYNCED_STATIC_OBJECT(OEMPINEditableStateDataBindingSource, bsOEMPINEditableState);
        FEATSTD_UNSYNCED_STATIC_OBJECT(OEMPIN1TextInfoDataBindingSource, bsOEMPIN1TextInfo);
        FEATSTD_UNSYNCED_STATIC_OBJECT(OEMPIN2TextInfoDataBindingSource, bsOEMPIN2TextInfo);
        FEATSTD_UNSYNCED_STATIC_OBJECT(OEMPIN3TextInfoDataBindingSource, bsOEMPIN3TextInfo);
        FEATSTD_UNSYNCED_STATIC_OBJECT(OEMPIN4TextInfoDataBindingSource, bsOEMPIN4TextInfo);
        FEATSTD_UNSYNCED_STATIC_OBJECT(OEMKey1InputDataBindingSource, bsOEMKey1Input);
        FEATSTD_UNSYNCED_STATIC_OBJECT(OEMKey2InputDataBindingSource, bsOEMKey2Input);
        FEATSTD_UNSYNCED_STATIC_OBJECT(OEMKey3InputDataBindingSource, bsOEMKey3Input);
        FEATSTD_UNSYNCED_STATIC_OBJECT(OEMKey4InputDataBindingSource, bsOEMKey4Input);
        FEATSTD_UNSYNCED_STATIC_OBJECT(OEMAuthenticationInfoTextDataBindingSource, bsOEMAuthenticationInfoText);
        FEATSTD_UNSYNCED_STATIC_OBJECT(OEMSpeedLockUpdateDataBindingSource, bsOEMSpeedLockUpdate);
        FEATSTD_UNSYNCED_STATIC_OBJECT(NaftaLang_SettingMenuDataBindingSource, bsNaftaLang_SettingMenu);
        FEATSTD_UNSYNCED_STATIC_OBJECT(vmsCabinMenuDataBindingSource, bsvmsCabinMenu);
        FEATSTD_UNSYNCED_STATIC_OBJECT(ClockHourSettingValueDataBindingSource, bsClockHourSettingValue);
        FEATSTD_UNSYNCED_STATIC_OBJECT(ClockMinuteSettingValueDataBindingSource, bsClockMinuteSettingValue);
        FEATSTD_UNSYNCED_STATIC_OBJECT(ClockTimeZoneDataBindingSource, bsClockTimeZone);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SpeedDependentVolumeControlDataBindingSource, bsSpeedDependentVolumeControl);
        FEATSTD_UNSYNCED_STATIC_OBJECT(PrivateModeSettingDataBindingSource, bsPrivateModeSetting);
        FEATSTD_UNSYNCED_STATIC_OBJECT(DTCHeadingUpdateItemDataBindingSource, bsDTCHeadingUpdateItem);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SOASEquilizerPresetDataBindingSource, bsSOASEquilizerPreset);
        FEATSTD_UNSYNCED_STATIC_OBJECT(ClockDateFormatDataBindingSource, bsClockDateFormat);
        FEATSTD_UNSYNCED_STATIC_OBJECT(DateFmtUpdateItemDataBindingSource, bsDateFmtUpdateItem);
        FEATSTD_UNSYNCED_STATIC_OBJECT(MasterGadgetSystemDataBindingSource, bsMasterGadgetSystem);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SWUpdateDetailsDataBindingSource, bsSWUpdateDetails);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SWUpdateMainDataBindingSource, bsSWUpdateMain);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SWUpdateHistoryDetailsDataBindingSource, bsSWUpdateHistoryDetails);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SwivelPopupDataBindingSource, bsSwivelPopup);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SWUpdateStickInfoDataBindingSource, bsSWUpdateStickInfo);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SWQuickUpdateEnableDataBindingSource, bsSWQuickUpdateEnable);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SWFullUpdateEnableDataBindingSource, bsSWFullUpdateEnable);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SWUpdateDetailsEnableDataBindingSource, bsSWUpdateDetailsEnable);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SWUpdatebackbuttonEnableDataBindingSource, bsSWUpdatebackbuttonEnable);
        FEATSTD_UNSYNCED_STATIC_OBJECT(DownlaodTypeInfoDataBindingSource, bsDownlaodTypeInfo);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SWUpdateNameSmartDataBindingSource, bsSWUpdateNameSmart);
        FEATSTD_UNSYNCED_STATIC_OBJECT(PopupTextDataBindingSource, bsPopupText);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SystemInstallationDataBindingSource, bsSystemInstallation);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SWDetailsTextDataBindingSource, bsSWDetailsText);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SWHistoryDetailsTextDataBindingSource, bsSWHistoryDetailsText);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SWUpdateResultsDataBindingSource, bsSWUpdateResults);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SystemsettingMainIconDataBindingSource, bsSystemsettingMainIcon);
        FEATSTD_UNSYNCED_STATIC_OBJECT(CabinAsettingMainIconDataBindingSource, bsCabinAsettingMainIcon);
        FEATSTD_UNSYNCED_STATIC_OBJECT(CabinBsettingMainIconDataBindingSource, bsCabinBsettingMainIcon);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SystemsettingSwVerNDLanguageIconDataBindingSource, bsSystemsettingSwVerNDLanguageIcon);
        FEATSTD_UNSYNCED_STATIC_OBJECT(speedlockUpdatesVisibilityDataBindingSource, bsspeedlockUpdatesVisibility);
        FEATSTD_UNSYNCED_STATIC_OBJECT(bluetoothVisibilityDataBindingSource, bsbluetoothVisibility);
        FEATSTD_UNSYNCED_STATIC_OBJECT(PopUpButtonVisibilityDataBindingSource, bsPopUpButtonVisibility);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SWUpdateListItemEnableDataBindingSource, bsSWUpdateListItemEnable);
        FEATSTD_UNSYNCED_STATIC_OBJECT(MISStage1ResultsDataBindingSource, bsMISStage1Results);
        FEATSTD_UNSYNCED_STATIC_OBJECT(ListScrollBarInfoDataBindingSource, bsListScrollBarInfo);
        static ::Courier::Internal::ModelBindingSource *bindingSources[cBindingSourceCount] = { 
            0,
            &bsDropdownmenuCombo, 
            &bsCheckBoxListItem, 
            &bsSwVersionNodeSwitchItem, 
            &bsDisplaySettingsMode, 
            &bsDisplaySettingsBrightness, 
            &bsBrightnessIncVal, 
            &bsBrightnessDecVal, 
            &bsGenPopupMsg, 
            &bsCAAudiolevelUpdateItem, 
            &bsCAMICBeepAudiolevelUpdateItem, 
            &bsBasslevelUpdateItem, 
            &bsRVCBrightnessUpdateItem, 
            &bsRVCContrastUpdateItem, 
            &bsDispSettingValueUpdateItem, 
            &bsHourValueUpdateItem, 
            &bsTreblelevelUpdateItem, 
            &bsBalancelevelUpdateItem, 
            &bsLanguageSettingMenu, 
            &bsOEMPINKeyInfo, 
            &bsOEMPINCursorState, 
            &bsOEMPINEditableState, 
            &bsOEMPIN1TextInfo, 
            &bsOEMPIN2TextInfo, 
            &bsOEMPIN3TextInfo, 
            &bsOEMPIN4TextInfo, 
            &bsOEMKey1Input, 
            &bsOEMKey2Input, 
            &bsOEMKey3Input, 
            &bsOEMKey4Input, 
            &bsOEMAuthenticationInfoText, 
            &bsOEMSpeedLockUpdate, 
            &bsNaftaLang_SettingMenu, 
            &bsvmsCabinMenu, 
            &bsClockHourSettingValue, 
            &bsClockMinuteSettingValue, 
            &bsClockTimeZone, 
            &bsSpeedDependentVolumeControl, 
            &bsPrivateModeSetting, 
            &bsDTCHeadingUpdateItem, 
            &bsSOASEquilizerPreset, 
            &bsClockDateFormat, 
            &bsDateFmtUpdateItem, 
            &bsMasterGadgetSystem, 
            &bsSWUpdateDetails, 
            &bsSWUpdateMain, 
            &bsSWUpdateHistoryDetails, 
            &bsSwivelPopup, 
            &bsSWUpdateStickInfo, 
            &bsSWQuickUpdateEnable, 
            &bsSWFullUpdateEnable, 
            &bsSWUpdateDetailsEnable, 
            &bsSWUpdatebackbuttonEnable, 
            &bsDownlaodTypeInfo, 
            &bsSWUpdateNameSmart, 
            &bsPopupText, 
            &bsSystemInstallation, 
            &bsSWDetailsText, 
            &bsSWHistoryDetailsText, 
            &bsSWUpdateResults, 
            &bsSystemsettingMainIcon, 
            &bsCabinAsettingMainIcon, 
            &bsCabinBsettingMainIcon, 
            &bsSystemsettingSwVerNDLanguageIcon, 
            &bsspeedlockUpdatesVisibility, 
            &bsbluetoothVisibility, 
            &bsPopUpButtonVisibility, 
            &bsSWUpdateListItemEnable, 
            &bsMISStage1Results, 
            &bsListScrollBarInfo, 
        };
        ok = ok && ::Courier::Register(::Courier::ComponentId(::Courier::ComponentType::View), bindingSources, cBindingSourceCount);
    }
    {
        FEATSTD_UNSYNCED_STATIC_OBJECT(::Courier::Internal::AsyncGenericModelBindingSource, bsSWUpdateStickInfo, ItemKey::SWUpdateStickInfoItem);
        FEATSTD_UNSYNCED_STATIC_OBJECT(::Courier::Internal::AsyncGenericModelBindingSource, bsSWQuickUpdateEnable, ItemKey::SWQuickUpdateEnableItem);
        FEATSTD_UNSYNCED_STATIC_OBJECT(::Courier::Internal::AsyncGenericModelBindingSource, bsSWFullUpdateEnable, ItemKey::SWFullUpdateEnableItem);
        FEATSTD_UNSYNCED_STATIC_OBJECT(::Courier::Internal::AsyncGenericModelBindingSource, bsSWUpdateDetailsEnable, ItemKey::SWUpdateDetailsEnableItem);
        FEATSTD_UNSYNCED_STATIC_OBJECT(::Courier::Internal::AsyncGenericModelBindingSource, bsSWUpdatebackbuttonEnable, ItemKey::SWUpdatebackbuttonEnableItem);
        FEATSTD_UNSYNCED_STATIC_OBJECT(::Courier::Internal::AsyncGenericModelBindingSource, bsDownlaodTypeInfo, ItemKey::DownlaodTypeInfoItem);
        static ::Courier::Internal::ModelBindingSource *bindingSources[cBindingSourceCount] = { 
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            &bsSWUpdateStickInfo, 
            &bsSWQuickUpdateEnable, 
            &bsSWFullUpdateEnable, 
            &bsSWUpdateDetailsEnable, 
            &bsSWUpdatebackbuttonEnable, 
            &bsDownlaodTypeInfo, 
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
        };
        ok = ok && ::Courier::Register(::Courier::ComponentId(::Courier::ComponentType::Controller), bindingSources, cBindingSourceCount);
    }
    return ok;
}

namespace Courier {
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::DropdownmenuComboDataBindingSource>, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::CheckBoxListItemDataBindingSource>, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SwVersionNodeSwitchItemDataBindingSource>, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::DisplaySettingsModeDataBindingSource>, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::DisplaySettingsBrightnessDataBindingSource>, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::BrightnessIncValDataBindingSource>, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::BrightnessDecValDataBindingSource>, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::GenPopupMsgDataBindingSource>, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::CAAudiolevelUpdateItemDataBindingSource>, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::CAMICBeepAudiolevelUpdateItemDataBindingSource>, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::BasslevelUpdateItemDataBindingSource>, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::RVCBrightnessUpdateItemDataBindingSource>, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::RVCContrastUpdateItemDataBindingSource>, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::DispSettingValueUpdateItemDataBindingSource>, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::HourValueUpdateItemDataBindingSource>, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::TreblelevelUpdateItemDataBindingSource>, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::BalancelevelUpdateItemDataBindingSource>, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::LanguageSettingMenuDataBindingSource>, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::OEMPINKeyInfoDataBindingSource>, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::OEMPINCursorStateDataBindingSource>, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::OEMPINEditableStateDataBindingSource>, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::OEMPIN1TextInfoDataBindingSource>, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::OEMPIN2TextInfoDataBindingSource>, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::OEMPIN3TextInfoDataBindingSource>, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::OEMPIN4TextInfoDataBindingSource>, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::OEMKey1InputDataBindingSource>, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::OEMKey2InputDataBindingSource>, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::OEMKey3InputDataBindingSource>, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::OEMKey4InputDataBindingSource>, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::OEMAuthenticationInfoTextDataBindingSource>, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::OEMSpeedLockUpdateDataBindingSource>, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::NaftaLang_SettingMenuDataBindingSource>, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::vmsCabinMenuDataBindingSource>, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::ClockHourSettingValueDataBindingSource>, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::ClockMinuteSettingValueDataBindingSource>, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::ClockTimeZoneDataBindingSource>, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SpeedDependentVolumeControlDataBindingSource>, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::PrivateModeSettingDataBindingSource>, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::DTCHeadingUpdateItemDataBindingSource>, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SOASEquilizerPresetDataBindingSource>, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::ClockDateFormatDataBindingSource>, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::DateFmtUpdateItemDataBindingSource>, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::MasterGadgetSystemDataBindingSource>, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SWUpdateDetailsDataBindingSource>, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SWUpdateMainDataBindingSource>, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SWUpdateHistoryDetailsDataBindingSource>, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SwivelPopupDataBindingSource>, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SWUpdateStickInfoDataBindingSource>, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SWQuickUpdateEnableDataBindingSource>, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SWFullUpdateEnableDataBindingSource>, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SWUpdateDetailsEnableDataBindingSource>, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SWUpdatebackbuttonEnableDataBindingSource>, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::DownlaodTypeInfoDataBindingSource>, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SWUpdateNameSmartDataBindingSource>, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::PopupTextDataBindingSource>, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SystemInstallationDataBindingSource>, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SWDetailsTextDataBindingSource>, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SWHistoryDetailsTextDataBindingSource>, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SWUpdateResultsDataBindingSource>, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SystemsettingMainIconDataBindingSource>, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::CabinAsettingMainIconDataBindingSource>, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::CabinBsettingMainIconDataBindingSource>, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SystemsettingSwVerNDLanguageIconDataBindingSource>, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::speedlockUpdatesVisibilityDataBindingSource>, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::bluetoothVisibilityDataBindingSource>, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::PopUpButtonVisibilityDataBindingSource>, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SWUpdateListItemEnableDataBindingSource>, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::MISStage1ResultsDataBindingSource>, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::ListScrollBarInfoDataBindingSource>, 5);
} // namespace Courier

#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
namespace FeatStd {
// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DropdownmenuComboDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DropdownmenuComboDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::CheckBoxListItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::CheckBoxListItemDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SwVersionNodeSwitchItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SwVersionNodeSwitchItemDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DisplaySettingsModeDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DisplaySettingsModeDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DisplaySettingsBrightnessDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DisplaySettingsBrightnessDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::BrightnessIncValDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::BrightnessIncValDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::BrightnessDecValDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::BrightnessDecValDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::GenPopupMsgDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::GenPopupMsgDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::CAAudiolevelUpdateItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::CAAudiolevelUpdateItemDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::CAMICBeepAudiolevelUpdateItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::CAMICBeepAudiolevelUpdateItemDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::BasslevelUpdateItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::BasslevelUpdateItemDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::RVCBrightnessUpdateItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::RVCBrightnessUpdateItemDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::RVCContrastUpdateItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::RVCContrastUpdateItemDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DispSettingValueUpdateItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DispSettingValueUpdateItemDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HourValueUpdateItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HourValueUpdateItemDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::TreblelevelUpdateItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::TreblelevelUpdateItemDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::BalancelevelUpdateItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::BalancelevelUpdateItemDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::LanguageSettingMenuDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::LanguageSettingMenuDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::OEMPINKeyInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::OEMPINKeyInfoDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::OEMPINCursorStateDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::OEMPINCursorStateDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::OEMPINEditableStateDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::OEMPINEditableStateDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::OEMPIN1TextInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::OEMPIN1TextInfoDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::OEMPIN2TextInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::OEMPIN2TextInfoDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::OEMPIN3TextInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::OEMPIN3TextInfoDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::OEMPIN4TextInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::OEMPIN4TextInfoDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::OEMKey1InputDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::OEMKey1InputDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::OEMKey2InputDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::OEMKey2InputDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::OEMKey3InputDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::OEMKey3InputDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::OEMKey4InputDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::OEMKey4InputDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::OEMAuthenticationInfoTextDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::OEMAuthenticationInfoTextDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::OEMSpeedLockUpdateDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::OEMSpeedLockUpdateDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::NaftaLang_SettingMenuDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::NaftaLang_SettingMenuDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::vmsCabinMenuDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::vmsCabinMenuDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ClockHourSettingValueDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ClockHourSettingValueDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ClockMinuteSettingValueDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ClockMinuteSettingValueDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ClockTimeZoneDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ClockTimeZoneDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SpeedDependentVolumeControlDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SpeedDependentVolumeControlDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PrivateModeSettingDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PrivateModeSettingDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DTCHeadingUpdateItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DTCHeadingUpdateItemDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SOASEquilizerPresetDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SOASEquilizerPresetDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ClockDateFormatDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ClockDateFormatDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DateFmtUpdateItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DateFmtUpdateItemDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::MasterGadgetSystemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::MasterGadgetSystemDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SWUpdateDetailsDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SWUpdateDetailsDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SWUpdateMainDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SWUpdateMainDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SWUpdateHistoryDetailsDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SWUpdateHistoryDetailsDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SwivelPopupDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SwivelPopupDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SWUpdateStickInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SWUpdateStickInfoDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SWQuickUpdateEnableDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SWQuickUpdateEnableDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SWFullUpdateEnableDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SWFullUpdateEnableDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SWUpdateDetailsEnableDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SWUpdateDetailsEnableDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SWUpdatebackbuttonEnableDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SWUpdatebackbuttonEnableDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DownlaodTypeInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DownlaodTypeInfoDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SWUpdateNameSmartDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SWUpdateNameSmartDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PopupTextDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PopupTextDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SystemInstallationDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SystemInstallationDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SWDetailsTextDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SWDetailsTextDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SWHistoryDetailsTextDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SWHistoryDetailsTextDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SWUpdateResultsDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SWUpdateResultsDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SystemsettingMainIconDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SystemsettingMainIconDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::CabinAsettingMainIconDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::CabinAsettingMainIconDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::CabinBsettingMainIconDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::CabinBsettingMainIconDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SystemsettingSwVerNDLanguageIconDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SystemsettingSwVerNDLanguageIconDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::speedlockUpdatesVisibilityDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::speedlockUpdatesVisibilityDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::bluetoothVisibilityDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::bluetoothVisibilityDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PopUpButtonVisibilityDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PopUpButtonVisibilityDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SWUpdateListItemEnableDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SWUpdateListItemEnableDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::MISStage1ResultsDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::MISStage1ResultsDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ListScrollBarInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ListScrollBarInfoDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }
} // namespace FeatStd
#endif
COURIER_DATABINDING_INFRASTRUCTURE(::gInfrastructure);
