/************************************************************************
*FILE: AppHmi_SdsStateMachine.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(AppHmi_SdsStateMachine_h)
#define AppHmi_SdsStateMachine_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Courier/Messaging/Message.h>
#include <AppHmi_SdsStateMachineSEMLibB.h>
#include <AppHmi_SdsStateMachineData.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Cit/VisualStateGlueLayer/DeductResult.h>
#ifdef CIT_SIMULATION
#include <json/value.h>
#endif
#include <ProjectBaseTypes.h>
#include <ProjectBaseConstants.h>
#include <ProjectBaseMsgs.h>
#include <ProjectBaseStateMachine.h>
#include <AppHmi_SdsTypes.h>
#include <AppHmi_SdsMessages.h>
#include <AppHmi_SdsConstants.h>
#include <AppHmi_SdsDatabinding.h>
#include <AppHmi_SdsViews.h>
#include <AppHmi_SdsController.h>
// ------------------------------------------------------------------------
class AppHmi_SdsStateMachineImpl : public AppHmi_SdsStateMachine
{
public:
    typedef AppHmi_SdsStateMachine Base;

#ifdef VISUALSTATE_7_TRACE
    // Mapping of data types of API to get rid of include dependencies
    //typedef SEM_ACTION_EXPRESSION_TYPE VS_Type_ActionExpression;
	using Base::VS_Type_ActionExpression;
    //typedef SEM_EVENT_TYPE VS_Type_Event;
	//typedef SEM_STATE_TYPE VS_Type_State;
	//typedef SEM_EXPLANATION_TYPE VS_Type_Explanation;
	//typedef SEM_STATE_MACHINE_TYPE VS_Type_Statemachine;
	using Base::VS_Type_Event;
	using Base::VS_Type_State;
	using Base::VS_Type_Explanation;
	using Base::VS_Type_Statemachine;

    // Mapping of enums and defines of API to get rid of include dependencies
    //enum { VS_Ret_Ok = SES_OKAY };
    //enum { VS_Ret_Found = SES_FOUND };
	enum { VS_Ret_Ok = Base::VS_Ret_Ok };
	enum { VS_Ret_Found = Base::VS_Ret_Found };
    enum { VS_Evt_Reset = SE_RESET };
    enum { VS_Ret_Error = SES_RANGE_ERR };
#else
#ifndef VISUALSTATE_HCODER
    typedef SEM_ACTION_EXPRESSION_TYPE VS_Type_ActionExpression;
    typedef SEM_EVENT_TYPE VS_Type_Event;
    typedef SEM_STATE_TYPE VS_Type_State;
    typedef SEM_EXPLANATION_TYPE VS_Type_Explanation;
    typedef SEM_STATE_MACHINE_TYPE VS_Type_Statemachine;
    enum { VS_Ret_Ok = SES_OKAY };
    enum { VS_Ret_Found = SES_FOUND };
    enum { VS_Evt_Reset = SE_RESET };
    enum { VS_Ret_Error = SES_RANGE_ERR };
#else
    enum { VS_Ret_Ok = 0U };
    enum { VS_Ret_Found = 1U };
    enum { VS_Evt_Reset = 0U };
    enum { VS_Ret_Error = 4U };
#endif
#endif
// ------------------------------------------------------------------------

    // Mapping of args passed as hashId to corresponding identifier
    static const ::FeatStd::Char *GetNameFromId(::FeatStd::UInt32 id);

// ------------------------------------------------------------------------
    virtual void gacChangeLanguageReq(::FeatStd::Int32 aLanguageId);
    virtual void gacHideFocusInViewReq(::FeatStd::UInt32 aView);
    virtual void NextLevelTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void PreviousLevelTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void DualViewLeftTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void DualViewRightTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void PageFlipBackTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void PageFlipFrontTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void ZoomInTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView, ::FeatStd::Int8 aPos);
    virtual void ZoomOutTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView, ::FeatStd::Int8 aPos);
    virtual void FadeTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void gacWaitAnimationStartReq();
    virtual void acFocusOnRightEncoderReqUpd(bool aIsFocusUsed);
    virtual void acSetGadgetSceenActiveStatus(bool aIsGadgetAtive);
    virtual void acHKNotificationMsg(::FeatStd::Int8 aHKCode, ::FeatStd::Int8 aHKState);
    virtual void acPerform_CloseAllDropdowns();
    virtual void acPerform_CloseDropdown(::FeatStd::UInt32 aListId);
    virtual void acPerform_OpenDropdown(::FeatStd::UInt32 aListId);
    virtual void acPerform_ToggleDropdown(::FeatStd::UInt32 aListId);
    virtual void acStartAppPopupTimer(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aTimeout);
    virtual void acStopAppPopupTimer(::FeatStd::UInt32 aViewId);
    virtual void acPostBeep(::FeatStd::Int8 aBeepType);
    virtual void gacCheckToClosePopup(::FeatStd::UInt32 aPopupId);
    virtual void acRestartAppPopupTimer(::FeatStd::UInt32 aViewId);
    virtual void gacContextSwitchBackRes(::FeatStd::UInt32 aSwitchId);
    virtual void gacContextSwitchCompleteRes(::FeatStd::UInt32 aSwitchId);
    virtual void gacContextSwitchFailedRes(::FeatStd::UInt32 aSwitchId);
    virtual void gacContextSwitchDoneRes(::FeatStd::UInt32 aSwitchId);
    virtual void gacContextSwitchOutReq(::FeatStd::UInt32 aTargetContextId, ::FeatStd::UInt32 aSourceContextId, ::FeatStd::UInt32 aTargetAppId);
    virtual void gacCurrentScreenDisplayReq();
    virtual void gacLaunchBarDisplayReq(bool aVisibility);
    virtual void gacNavTBTSwipe();
    virtual void gacPerformListBtnRightEncoderChangeUpd(::FeatStd::Int8 aSteps, ::FeatStd::UInt32 aListId, ::FeatStd::UInt32 aRowId, ::FeatStd::UInt32 aColumnId);
    virtual void gacScrollListUp();
    virtual void gacScrollListDown();
    virtual void gacScrollPageUp();
    virtual void gacScrollPageDown();
    virtual void gacScrollListFocusUp(::FeatStd::UInt32 aListId);
    virtual void gacScrollListFocusDown(::FeatStd::UInt32 aListId);
    virtual void gacPerformListFocusLockDataResetUpd();
    virtual void gacSetApplicationMode(::FeatStd::UInt32 aModeId);
    virtual void gacSpellerBbehaviorReq(bool aEnable);
    virtual void gacStatusBarDisplayReq(bool aVisibility, ::FeatStd::Int32 aHeaderType);
    virtual void gacTBTRetriggerAcousticOutput();
    virtual void gacWaitAnimationStopReq();
    virtual void gacViewCreateReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewCreateAllReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewDestroyReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewClearReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewShowReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewHideReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewCreateWithoutLoadReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewAsyncLoadReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewActivateWithoutRenderingReq(::FeatStd::UInt32 aViewId);
    virtual void gacPopupCreateAndSBShowReq(::FeatStd::UInt32 aViewId);
    virtual void gacPopupCreateAndSBShowReqForMultiDisplay(::FeatStd::UInt32 aPopupDisplayID, ::FeatStd::UInt32 aViewId);
    virtual void gacPopupSBCloseReq(::FeatStd::UInt32 aViewId);
    virtual void gacPopupSBCloseReqForMultiDisplay(::FeatStd::UInt32 aPopupDisplayID, ::FeatStd::UInt32 aViewId);
    virtual void gacPopupRestartTimerReq(::FeatStd::UInt32 aViewId);
    virtual void gacPopupRestartTimerReqForMultiDisplay(::FeatStd::UInt32 aPopupDisplayID, ::FeatStd::UInt32 aViewId);
    virtual void gacViewCreateAndShowReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewHideAndDestroyReq(::FeatStd::UInt32 aViewId);
    virtual void gacSceneTransitionEnter(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aHint);
    virtual void gacSceneTransitionLeave(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aHint);
    virtual void gacDisplayStatusLineReq(::FeatStd::Int32 aDisplayRegionType);
    virtual void gacHideStatusLineReq(::FeatStd::Int32 aDisplayRegionType);
    virtual void gacDisplayFooterLineReq();
    virtual void gacHideFooterLineReq();
    virtual void gacDisplayStatusLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID);
    virtual void gacHideStatusLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID);
    virtual void gacDisplayFooterLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID);
    virtual void gacHideFooterLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID);
    virtual void gacRegisterForCloseOnTouchSession(::FeatStd::UInt32 aViewId);
    virtual void gacDeregisterForCloseOnTouchSessionReq(::FeatStd::UInt32 aViewId);
    virtual void gacPopupFilterPrioEnableReq(::FeatStd::UInt32 aPrio);
    virtual void gacPopupFilterAllEnableReq();
    virtual void gacPopupFilterDisableReq();
    virtual void gacProfileChange(::FeatStd::Int8 aProfile);
    virtual void gacPopupFilterPrioEnableReqForDisplay(::FeatStd::UInt32 aPrio, ::FeatStd::UInt32 aDisplayID);
    virtual void gacPopupFilterAllEnableReqForDisplay(::FeatStd::UInt32 aDisplayID);
    virtual void gacPopupFilterDisableReqForDisplay(::FeatStd::UInt32 aDisplayID);
    virtual void gacStartSceneTransitionAnimation(::FeatStd::UInt32 aSourceView, ::FeatStd::UInt32 aDestinationView, ::FeatStd::UInt32 aUserData1, ::FeatStd::Int8 aUserData2);
    virtual void gacDecrementActiveAnimationCount();
    virtual void Notify_Init_Finished();

#ifdef CIT_SIMULATION
    bool CallAction(const ::FeatStd::Char* actionName, const ::Json::Value& parameters, ::Json::Value &response);
    const ::FeatStd::Char* GetEventName(::FeatStd::UInt32 eventId, ::Courier::Message const & message, Json::Value& eventArgument);
#endif
    // Added function for deduction of one event to simplify the event loop
    bool HandleDataBindingEventMapping(::Courier::AbstractDataItemMsg const & message, ::FeatStd::UInt32& eventId) const;
    bool HandleEventMapping(::Courier::Message const & message, ::FeatStd::UInt32& eventId) const;

    ::Cit::DeductResult::Enum DeductEvent(::Courier::Message const & message, ::FeatStd::UInt32 eventId);

    //====  member function with TTFis output - added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====

	virtual unsigned short GetTraceClass();
	int GetNumberOfStatemachines();
    //====  member function with TTFis output - end                        key: SM_TTFis_SBHFMSRF ====
};

// ------------------------------------------------------------------------
bool SendChangeLanguageReqMsg(enLanguageId const & aLanguageId);
bool SendFocusReqMsg(FocusActionEnum const & aAction, FocusTimerActionEnum const & aTimerAction, ::Courier::ViewId const & aView, Candera::String const & aWidget);
bool SendDummyMess(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos);
bool SendAnimationReqMsg(Courier::AnimationAction::Enum const & aAnimationAction, ::Courier::ViewId const & aViewId, Courier::CompositePath const & aCompositePath, ::Courier::ItemId const & aAnimationId, Courier::AnimationProperties const & aAnimationProperties);
bool SendFocusOnRightEncoderReqUpdMsg(bool const & aIsFocusUsed);
bool SendStoreActiveGadgetReqMsg(bool const & aIsGadgetAtive);
bool SendHardKeyPressNotificationMsg(Courier::UInt8 const & aDummy, Courier::UInt8 const & aHKCode, Courier::UInt8 const & aHKState);
bool SendDropdownChangeMsg(::Candera::DropdownChangeType const & aDropdownChangeType, ::Courier::UInt32 const & aListId);
bool SendStartPopupTimerReqMsg(Courier::UInt32 const & aViewId, Courier::UInt32 const & aTimeout);
bool SendStopPopupTimerReqMsg(Courier::UInt32 const & aViewId);
bool SendPlayBeepReqMsg(Courier::Int32 const & aBeepType);
bool SendCheckToClosePopupMsg(Courier::UInt32 const & aPopupId);
bool SendRestartPopupTimerReqMsg(Courier::UInt32 const & aViewId);
bool SendContextSwitchInResMsg(Courier::UInt32 const & aSwitchId, Courier::UInt32 const & aResponseType);
bool SendContextSwitchOutReqMsg(Courier::UInt32 const & aTargetContextId, Courier::UInt32 const & aSourceContextId, Courier::UInt32 const & aTargetAppId);
bool SendCurrentScreenDisplayReqMsg();
bool SendLaunchBarDisplayReqMsg(bool const & aVisibility);
bool SendNavTBTSwipeReqMsg();
bool SendListItemRightEncoderChangeUpdMsg(Courier::Int8 const & aSteps, Courier::UInt32 const & aListId, Courier::UInt32 const & aRowId, Courier::UInt32 const & aColumnId);
bool SendListChangeMsg(::Courier::UInt32 const & aListId, ListChangeType const & aListChangeType, ::Courier::Int32 const & aValue, ListChangeMsgSourceType const & aListChangeMsgSource, bool const & aImmediatePositioning);
bool SendListFocusScrollReqMsg(Courier::UInt32 const & aListId, Courier::Int32 const & aSteps);
bool SendListFocusLockDataResetReqMsg();
bool SendSetApplicationModeReqMsg(Courier::UInt32 const & aModeId);
bool SendSpellerBbehaviorReqMsg(bool const & aEnable);
bool SendStatusBarDisplayReqMsg(bool const & aVisibility, Courier::Int32 const & aHeaderType);
bool SendTBTRetriggerAcousticMsg();
bool SendViewReqMsg(Courier::ViewAction::Enum const & aViewAction, ::Courier::ViewId const & aViewId, bool const & aShallInitScene, bool const & aShallLoadScene);
bool SendActivationReqMsg(::Courier::ViewId const & aViewId, bool const & aActivation, bool const & aEnableRendering);
bool SendAsyncLoadReqMsg(::Courier::ViewId const & aViewId, bool const & aLoad);
bool SendPopupReqMsg(hmibase::popups::CommandEnum const & aCommand, ::Courier::ViewId const & aViewId, Courier::UInt32 const & aPopupDisplayID);
bool SendExtendedViewReqMsg(hmibase::views::CommandEnum const & aCommand, ::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint);
bool SendShowHMISubSurfaceReqMsg(hmibase::displayRegion const & aDisplayRegion, Courier::Int32 const & aDisplayRegionType, bool const & aShowSubSurface, Courier::UInt32 const & aDisplayID, bool const & aLockSubSurface);
bool SendRegisterForCloseOnTouchSessionReqMsg(bool const & aRegister, ::Courier::ViewId const & aViewId);
bool SendPopupFilterPrioEnableReqMsg(Courier::UInt32 const & aPrio);
bool SendPopupFilterAllEnableReqMsg();
bool SendPopupFilterDisableReqMsg();
bool SendProfileSwitchMsg(Courier::UInt32 const & aProfile);
bool SendMultiDisplayPopupFilterReqMsg(hmibase::PopupFilterType const & aPopupFilterType, Courier::UInt32 const & aPrio, Courier::UInt32 const & aDisplayID);
bool SendCreateNewDestroyOld(::Courier::ViewId const & aSourceView, ::Courier::ViewId const & aDestinationView, Courier::UInt32 const & aUserData1, Courier::Int8 const & aUserData2);
bool SendNotifierMessage();
bool SendGuiStartupFinishedUpdMsg();

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacChangeLanguageReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacChangeLanguageReq(enLanguageId const & aLanguageId);
#ifdef CIT_SIMULATION
bool CallAction_gacHideFocusInViewReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacHideFocusInViewReq(::Courier::ViewId const & aView);
#ifdef CIT_SIMULATION
bool CallAction_NextLevelTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_NextLevelTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_PreviousLevelTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_PreviousLevelTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_DualViewLeftTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_DualViewLeftTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_DualViewRightTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_DualViewRightTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_PageFlipBackTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_PageFlipBackTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_PageFlipFrontTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_PageFlipFrontTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_ZoomInTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_ZoomInTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos);
#ifdef CIT_SIMULATION
bool CallAction_ZoomOutTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_ZoomOutTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos);
#ifdef CIT_SIMULATION
bool CallAction_FadeTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_FadeTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_gacWaitAnimationStartReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacWaitAnimationStartReq();
#ifdef CIT_SIMULATION
bool CallAction_acFocusOnRightEncoderReqUpd(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acFocusOnRightEncoderReqUpd(bool const & aIsFocusUsed);
#ifdef CIT_SIMULATION
bool CallAction_acSetGadgetSceenActiveStatus(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSetGadgetSceenActiveStatus(bool const & aIsGadgetAtive);
#ifdef CIT_SIMULATION
bool CallAction_acHKNotificationMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acHKNotificationMsg(Courier::UInt8 const & aHKCode, Courier::UInt8 const & aHKState);
#ifdef CIT_SIMULATION
bool CallAction_acPerform_CloseAllDropdowns(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPerform_CloseAllDropdowns();
#ifdef CIT_SIMULATION
bool CallAction_acPerform_CloseDropdown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPerform_CloseDropdown(::Courier::UInt32 const & aListId);
#ifdef CIT_SIMULATION
bool CallAction_acPerform_OpenDropdown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPerform_OpenDropdown(::Courier::UInt32 const & aListId);
#ifdef CIT_SIMULATION
bool CallAction_acPerform_ToggleDropdown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPerform_ToggleDropdown(::Courier::UInt32 const & aListId);
#ifdef CIT_SIMULATION
bool CallAction_acStartAppPopupTimer(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acStartAppPopupTimer(Courier::UInt32 const & aViewId, Courier::UInt32 const & aTimeout);
#ifdef CIT_SIMULATION
bool CallAction_acStopAppPopupTimer(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acStopAppPopupTimer(Courier::UInt32 const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_acPostBeep(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPostBeep(Courier::Int32 const & aBeepType);
#ifdef CIT_SIMULATION
bool CallAction_gacCheckToClosePopup(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacCheckToClosePopup(Courier::UInt32 const & aPopupId);
#ifdef CIT_SIMULATION
bool CallAction_acRestartAppPopupTimer(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acRestartAppPopupTimer(Courier::UInt32 const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchBackRes(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacContextSwitchBackRes(Courier::UInt32 const & aSwitchId);
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchCompleteRes(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacContextSwitchCompleteRes(Courier::UInt32 const & aSwitchId);
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchFailedRes(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacContextSwitchFailedRes(Courier::UInt32 const & aSwitchId);
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchDoneRes(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacContextSwitchDoneRes(Courier::UInt32 const & aSwitchId);
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchOutReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacContextSwitchOutReq(Courier::UInt32 const & aTargetContextId, Courier::UInt32 const & aSourceContextId, Courier::UInt32 const & aTargetAppId);
#ifdef CIT_SIMULATION
bool CallAction_gacCurrentScreenDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacCurrentScreenDisplayReq();
#ifdef CIT_SIMULATION
bool CallAction_gacLaunchBarDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacLaunchBarDisplayReq(bool const & aVisibility);
#ifdef CIT_SIMULATION
bool CallAction_gacNavTBTSwipe(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacNavTBTSwipe();
#ifdef CIT_SIMULATION
bool CallAction_gacPerformListBtnRightEncoderChangeUpd(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPerformListBtnRightEncoderChangeUpd(Courier::Int8 const & aSteps, Courier::UInt32 const & aListId, Courier::UInt32 const & aRowId, Courier::UInt32 const & aColumnId);
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListUp(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollListUp();
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListDown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollListDown();
#ifdef CIT_SIMULATION
bool CallAction_gacScrollPageUp(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollPageUp();
#ifdef CIT_SIMULATION
bool CallAction_gacScrollPageDown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollPageDown();
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListFocusUp(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollListFocusUp(Courier::UInt32 const & aListId);
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListFocusDown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollListFocusDown(Courier::UInt32 const & aListId);
#ifdef CIT_SIMULATION
bool CallAction_gacPerformListFocusLockDataResetUpd(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPerformListFocusLockDataResetUpd();
#ifdef CIT_SIMULATION
bool CallAction_gacSetApplicationMode(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacSetApplicationMode(Courier::UInt32 const & aModeId);
#ifdef CIT_SIMULATION
bool CallAction_gacSpellerBbehaviorReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacSpellerBbehaviorReq(bool const & aEnable);
#ifdef CIT_SIMULATION
bool CallAction_gacStatusBarDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacStatusBarDisplayReq(bool const & aVisibility, Courier::Int32 const & aHeaderType);
#ifdef CIT_SIMULATION
bool CallAction_gacTBTRetriggerAcousticOutput(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacTBTRetriggerAcousticOutput();
#ifdef CIT_SIMULATION
bool CallAction_gacWaitAnimationStopReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacWaitAnimationStopReq();
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewCreateReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateAllReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewCreateAllReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewDestroyReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewDestroyReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewClearReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewClearReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewShowReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewShowReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewHideReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewHideReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateWithoutLoadReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewCreateWithoutLoadReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewAsyncLoadReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewAsyncLoadReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewActivateWithoutRenderingReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewActivateWithoutRenderingReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupCreateAndSBShowReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupCreateAndSBShowReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupCreateAndSBShowReqForMultiDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupCreateAndSBShowReqForMultiDisplay(Courier::UInt32 const & aPopupDisplayID, ::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupSBCloseReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupSBCloseReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupSBCloseReqForMultiDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupSBCloseReqForMultiDisplay(Courier::UInt32 const & aPopupDisplayID, ::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupRestartTimerReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupRestartTimerReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupRestartTimerReqForMultiDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupRestartTimerReqForMultiDisplay(Courier::UInt32 const & aPopupDisplayID, ::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateAndShowReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewCreateAndShowReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewHideAndDestroyReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewHideAndDestroyReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacSceneTransitionEnter(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacSceneTransitionEnter(::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint);
#ifdef CIT_SIMULATION
bool CallAction_gacSceneTransitionLeave(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacSceneTransitionLeave(::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint);
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayStatusLineReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDisplayStatusLineReq(Courier::Int32 const & aDisplayRegionType);
#ifdef CIT_SIMULATION
bool CallAction_gacHideStatusLineReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacHideStatusLineReq(Courier::Int32 const & aDisplayRegionType);
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayFooterLineReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDisplayFooterLineReq();
#ifdef CIT_SIMULATION
bool CallAction_gacHideFooterLineReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacHideFooterLineReq();
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayStatusLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDisplayStatusLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacHideStatusLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacHideStatusLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayFooterLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDisplayFooterLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacHideFooterLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacHideFooterLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacRegisterForCloseOnTouchSession(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacRegisterForCloseOnTouchSession(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacDeregisterForCloseOnTouchSessionReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDeregisterForCloseOnTouchSessionReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterPrioEnableReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterPrioEnableReq(Courier::UInt32 const & aPrio);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterAllEnableReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterAllEnableReq();
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterDisableReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterDisableReq();
#ifdef CIT_SIMULATION
bool CallAction_gacProfileChange(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacProfileChange(Courier::UInt32 const & aProfile);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterPrioEnableReqForDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterPrioEnableReqForDisplay(Courier::UInt32 const & aPrio, Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterAllEnableReqForDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterAllEnableReqForDisplay(Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterDisableReqForDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterDisableReqForDisplay(Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacStartSceneTransitionAnimation(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacStartSceneTransitionAnimation(::Courier::ViewId const & aSourceView, ::Courier::ViewId const & aDestinationView, Courier::UInt32 const & aUserData1, Courier::Int8 const & aUserData2);
#ifdef CIT_SIMULATION
bool CallAction_gacDecrementActiveAnimationCount(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDecrementActiveAnimationCount();
#ifdef CIT_SIMULATION
bool CallAction_Notify_Init_Finished(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Notify_Init_Finished();

// overall number of HierarchyNodes
static const ::FeatStd::UInt32 cGlobalDataItemHierarchyNodeCount = 70;
// overall number of DataItemDescriptor nodes
static const ::FeatStd::UInt32 cDataItemDescriptorCount = 70;
// overall number of BindingSources
static const ::FeatStd::UInt32 cBindingSourceCount = 30;
// maximum number of HierarchyNodes in a BindingSource
static const ::FeatStd::UInt32 cBindingSourceItemCountMax = 9;

// =========================================================================

class ListScrollBarInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 1;
    static const ::Courier::DataItemKey cDataItemKey = 18;

    typedef ::ListScrollBarInfoData Data;

    ListScrollBarInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< ListScrollBarInfoDataBindingSource > ListScrollBarInfoDataItemMsg;

// =========================================================================

class PopUpTextDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 2;
    static const ::Courier::DataItemKey cDataItemKey = 45;

    typedef ::PopUpTextData Data;

    PopUpTextDataBindingSource();
};

typedef ::Courier::DataItemMsg< PopUpTextDataBindingSource > PopUpTextDataItemMsg;

// =========================================================================

class PopUpSingleTextDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 3;
    static const ::Courier::DataItemKey cDataItemKey = 50;

    typedef ::PopUpSingleTextData Data;

    PopUpSingleTextDataBindingSource();
};

typedef ::Courier::DataItemMsg< PopUpSingleTextDataBindingSource > PopUpSingleTextDataItemMsg;

// =========================================================================

class ListSliderDisplayDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 4;
    static const ::Courier::DataItemKey cDataItemKey = 12;

    typedef ::ListSliderDisplayData Data;

    ListSliderDisplayDataBindingSource();
};

typedef ::Courier::DataItemMsg< ListSliderDisplayDataBindingSource > ListSliderDisplayDataItemMsg;

// =========================================================================

class NextButtonActiveStatusDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 5;
    static const ::Courier::DataItemKey cDataItemKey = 43;

    typedef ::NextButtonActiveStatusData Data;

    NextButtonActiveStatusDataBindingSource();
};

typedef ::Courier::DataItemMsg< NextButtonActiveStatusDataBindingSource > NextButtonActiveStatusDataItemMsg;

// =========================================================================

class PrevButtonActiveStatusDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 6;
    static const ::Courier::DataItemKey cDataItemKey = 10;

    typedef ::PrevButtonActiveStatusData Data;

    PrevButtonActiveStatusDataBindingSource();
};

typedef ::Courier::DataItemMsg< PrevButtonActiveStatusDataBindingSource > PrevButtonActiveStatusDataItemMsg;

// =========================================================================

class ListPageNumberDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 7;
    static const ::Courier::DataItemKey cDataItemKey = 23;

    typedef ::ListPageNumberData Data;

    ListPageNumberDataBindingSource();
};

typedef ::Courier::DataItemMsg< ListPageNumberDataBindingSource > ListPageNumberDataItemMsg;

// =========================================================================

class PopUpMultipleTextDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 9;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 8;
    static const ::Courier::DataItemKey cDataItemKey = 57;

    typedef ::PopUpMultipleTextData Data;

    PopUpMultipleTextDataBindingSource();
};

typedef ::Courier::DataItemMsg< PopUpMultipleTextDataBindingSource > PopUpMultipleTextDataItemMsg;

// =========================================================================

class TimedStepMovementSliderDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 9;
    static const ::Courier::DataItemKey cDataItemKey = 41;

    typedef ::TimedStepMovementSliderData Data;

    TimedStepMovementSliderDataBindingSource();
};

typedef ::Courier::DataItemMsg< TimedStepMovementSliderDataBindingSource > TimedStepMovementSliderDataItemMsg;

// =========================================================================

class BargeInEnableStatusDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 10;
    static const ::Courier::DataItemKey cDataItemKey = 5;

    typedef ::BargeInEnableStatusData Data;

    BargeInEnableStatusDataBindingSource();
};

typedef ::Courier::DataItemMsg< BargeInEnableStatusDataBindingSource > BargeInEnableStatusDataItemMsg;

// =========================================================================

class SRStatusDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 11;
    static const ::Courier::DataItemKey cDataItemKey = 27;

    typedef ::SRStatusData Data;

    SRStatusDataBindingSource();
};

typedef ::Courier::DataItemMsg< SRStatusDataBindingSource > SRStatusDataItemMsg;

// =========================================================================

class MediaDeviceConnectedStatusDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 12;
    static const ::Courier::DataItemKey cDataItemKey = 47;

    typedef ::MediaDeviceConnectedStatusData Data;

    MediaDeviceConnectedStatusDataBindingSource();
};

typedef ::Courier::DataItemMsg< MediaDeviceConnectedStatusDataBindingSource > MediaDeviceConnectedStatusDataItemMsg;

// =========================================================================

class CallNameEnabledStatusDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 13;
    static const ::Courier::DataItemKey cDataItemKey = 40;

    typedef ::CallNameEnabledStatusData Data;

    CallNameEnabledStatusDataBindingSource();
};

typedef ::Courier::DataItemMsg< CallNameEnabledStatusDataBindingSource > CallNameEnabledStatusDataItemMsg;

// =========================================================================

class PhoneAvailableStatusDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 14;
    static const ::Courier::DataItemKey cDataItemKey = 16;

    typedef ::PhoneAvailableStatusData Data;

    PhoneAvailableStatusDataBindingSource();
};

typedef ::Courier::DataItemMsg< PhoneAvailableStatusDataBindingSource > PhoneAvailableStatusDataItemMsg;

// =========================================================================

class NavigationAvailableStatusDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 15;
    static const ::Courier::DataItemKey cDataItemKey = 68;

    typedef ::NavigationAvailableStatusData Data;

    NavigationAvailableStatusDataBindingSource();
};

typedef ::Courier::DataItemMsg< NavigationAvailableStatusDataBindingSource > NavigationAvailableStatusDataItemMsg;

// =========================================================================

class AddressEntryStatusDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 16;
    static const ::Courier::DataItemKey cDataItemKey = 39;

    typedef ::AddressEntryStatusData Data;

    AddressEntryStatusDataBindingSource();
};

typedef ::Courier::DataItemMsg< AddressEntryStatusDataBindingSource > AddressEntryStatusDataItemMsg;

// =========================================================================

class RouteInProgressStatusDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 17;
    static const ::Courier::DataItemKey cDataItemKey = 66;

    typedef ::RouteInProgressStatusData Data;

    RouteInProgressStatusDataBindingSource();
};

typedef ::Courier::DataItemMsg< RouteInProgressStatusDataBindingSource > RouteInProgressStatusDataItemMsg;

// =========================================================================

class Nav_AddressAvailableStatusDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 18;
    static const ::Courier::DataItemKey cDataItemKey = 17;

    typedef ::Nav_AddressAvailableStatusData Data;

    Nav_AddressAvailableStatusDataBindingSource();
};

typedef ::Courier::DataItemMsg< Nav_AddressAvailableStatusDataBindingSource > Nav_AddressAvailableStatusDataItemMsg;

// =========================================================================

class Nav_RouteProgressAvailableStatusDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 19;
    static const ::Courier::DataItemKey cDataItemKey = 4;

    typedef ::Nav_RouteProgressAvailableStatusData Data;

    Nav_RouteProgressAvailableStatusDataBindingSource();
};

typedef ::Courier::DataItemMsg< Nav_RouteProgressAvailableStatusDataBindingSource > Nav_RouteProgressAvailableStatusDataItemMsg;

// =========================================================================

class Nav_AddressEntryRouteProgressAvailableStatusDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 20;
    static const ::Courier::DataItemKey cDataItemKey = 69;

    typedef ::Nav_AddressEntryRouteProgressAvailableStatusData Data;

    Nav_AddressEntryRouteProgressAvailableStatusDataBindingSource();
};

typedef ::Courier::DataItemMsg< Nav_AddressEntryRouteProgressAvailableStatusDataBindingSource > Nav_AddressEntryRouteProgressAvailableStatusDataItemMsg;

// =========================================================================

class PhoneNumberAvailableStatusDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 21;
    static const ::Courier::DataItemKey cDataItemKey = 42;

    typedef ::PhoneNumberAvailableStatusData Data;

    PhoneNumberAvailableStatusDataBindingSource();
};

typedef ::Courier::DataItemMsg< PhoneNumberAvailableStatusDataBindingSource > PhoneNumberAvailableStatusDataItemMsg;

// =========================================================================

class AlbumAvailableStatusDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 22;
    static const ::Courier::DataItemKey cDataItemKey = 38;

    typedef ::AlbumAvailableStatusData Data;

    AlbumAvailableStatusDataBindingSource();
};

typedef ::Courier::DataItemMsg< AlbumAvailableStatusDataBindingSource > AlbumAvailableStatusDataItemMsg;

// =========================================================================

class ArtistAvailableStatusDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 23;
    static const ::Courier::DataItemKey cDataItemKey = 65;

    typedef ::ArtistAvailableStatusData Data;

    ArtistAvailableStatusDataBindingSource();
};

typedef ::Courier::DataItemMsg< ArtistAvailableStatusDataBindingSource > ArtistAvailableStatusDataItemMsg;

// =========================================================================

class GenreAvailableStatusDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 24;
    static const ::Courier::DataItemKey cDataItemKey = 26;

    typedef ::GenreAvailableStatusData Data;

    GenreAvailableStatusDataBindingSource();
};

typedef ::Courier::DataItemMsg< GenreAvailableStatusDataBindingSource > GenreAvailableStatusDataItemMsg;

// =========================================================================

class SongAvailableStatusDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 25;
    static const ::Courier::DataItemKey cDataItemKey = 34;

    typedef ::SongAvailableStatusData Data;

    SongAvailableStatusDataBindingSource();
};

typedef ::Courier::DataItemMsg< SongAvailableStatusDataBindingSource > SongAvailableStatusDataItemMsg;

// =========================================================================

class AudiobookAvailableStatusDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 26;
    static const ::Courier::DataItemKey cDataItemKey = 33;

    typedef ::AudiobookAvailableStatusData Data;

    AudiobookAvailableStatusDataBindingSource();
};

typedef ::Courier::DataItemMsg< AudiobookAvailableStatusDataBindingSource > AudiobookAvailableStatusDataItemMsg;

// =========================================================================

class PodcastAvailableStatusDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 27;
    static const ::Courier::DataItemKey cDataItemKey = 9;

    typedef ::PodcastAvailableStatusData Data;

    PodcastAvailableStatusDataBindingSource();
};

typedef ::Courier::DataItemMsg< PodcastAvailableStatusDataBindingSource > PodcastAvailableStatusDataItemMsg;

// =========================================================================

class PlaylistAvailableStatusDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 28;
    static const ::Courier::DataItemKey cDataItemKey = 36;

    typedef ::PlaylistAvailableStatusData Data;

    PlaylistAvailableStatusDataBindingSource();
};

typedef ::Courier::DataItemMsg< PlaylistAvailableStatusDataBindingSource > PlaylistAvailableStatusDataItemMsg;

// =========================================================================

class HouseNumberRangeDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 29;
    static const ::Courier::DataItemKey cDataItemKey = 62;

    typedef ::HouseNumberRangeData Data;

    HouseNumberRangeDataBindingSource();
};

typedef ::Courier::DataItemMsg< HouseNumberRangeDataBindingSource > HouseNumberRangeDataItemMsg;

namespace ItemKey {
        static const ::Courier::DataItemKey InvalidItem = 0;
        static const ::Courier::DataItemKey Nav_RouteProgressAvailableStatusItem = 4;
        static const ::Courier::DataItemKey BargeInEnableStatusItem = 5;
        static const ::Courier::DataItemKey PodcastAvailableStatusItem = 9;
        static const ::Courier::DataItemKey PrevButtonActiveStatusItem = 10;
        static const ::Courier::DataItemKey ListSliderDisplayItem = 12;
        static const ::Courier::DataItemKey PhoneAvailableStatusItem = 16;
        static const ::Courier::DataItemKey Nav_AddressAvailableStatusItem = 17;
        static const ::Courier::DataItemKey ListScrollBarInfoItem = 18;
        static const ::Courier::DataItemKey ListPageNumberItem = 23;
        static const ::Courier::DataItemKey GenreAvailableStatusItem = 26;
        static const ::Courier::DataItemKey SRStatusItem = 27;
        static const ::Courier::DataItemKey AudiobookAvailableStatusItem = 33;
        static const ::Courier::DataItemKey SongAvailableStatusItem = 34;
        static const ::Courier::DataItemKey PlaylistAvailableStatusItem = 36;
        static const ::Courier::DataItemKey AlbumAvailableStatusItem = 38;
        static const ::Courier::DataItemKey AddressEntryStatusItem = 39;
        static const ::Courier::DataItemKey CallNameEnabledStatusItem = 40;
        static const ::Courier::DataItemKey TimedStepMovementSliderItem = 41;
        static const ::Courier::DataItemKey PhoneNumberAvailableStatusItem = 42;
        static const ::Courier::DataItemKey NextButtonActiveStatusItem = 43;
        static const ::Courier::DataItemKey PopUpTextItem = 45;
        static const ::Courier::DataItemKey MediaDeviceConnectedStatusItem = 47;
        static const ::Courier::DataItemKey PopUpSingleTextItem = 50;
        static const ::Courier::DataItemKey PopUpMultipleTextItem = 57;
        static const ::Courier::DataItemKey HouseNumberRangeItem = 62;
        static const ::Courier::DataItemKey ArtistAvailableStatusItem = 65;
        static const ::Courier::DataItemKey RouteInProgressStatusItem = 66;
        static const ::Courier::DataItemKey NavigationAvailableStatusItem = 68;
        static const ::Courier::DataItemKey Nav_AddressEntryRouteProgressAvailableStatusItem = 69;

    namespace Nav_RouteProgressAvailableStatus {
            static const ::Courier::DataItemKey isVisibleItem = 37;
    } // namespace Nav_RouteProgressAvailableStatus

    namespace BargeInEnableStatus {
            static const ::Courier::DataItemKey BargeInEnableItem = 61;
    } // namespace BargeInEnableStatus

    namespace PodcastAvailableStatus {
            static const ::Courier::DataItemKey isEnableItem = 52;
    } // namespace PodcastAvailableStatus

    namespace PrevButtonActiveStatus {
            static const ::Courier::DataItemKey PrevButtonActiveItem = 53;
    } // namespace PrevButtonActiveStatus

    namespace ListSliderDisplay {
            static const ::Courier::DataItemKey SliderVisibleItem = 15;
    } // namespace ListSliderDisplay

    namespace PhoneAvailableStatus {
            static const ::Courier::DataItemKey isEnableItem = 46;
    } // namespace PhoneAvailableStatus

    namespace Nav_AddressAvailableStatus {
            static const ::Courier::DataItemKey isVisibleItem = 44;
    } // namespace Nav_AddressAvailableStatus

    namespace ListScrollBarInfo {
            static const ::Courier::DataItemKey EnabledItem = 64;
    } // namespace ListScrollBarInfo

    namespace ListPageNumber {
            static const ::Courier::DataItemKey PageNumberItem = 56;
    } // namespace ListPageNumber

    namespace GenreAvailableStatus {
            static const ::Courier::DataItemKey isEnableItem = 14;
    } // namespace GenreAvailableStatus

    namespace SRStatus {
            static const ::Courier::DataItemKey Icon_SRStatusItem = 35;
    } // namespace SRStatus

    namespace AudiobookAvailableStatus {
            static const ::Courier::DataItemKey isEnableItem = 60;
    } // namespace AudiobookAvailableStatus

    namespace SongAvailableStatus {
            static const ::Courier::DataItemKey isEnableItem = 8;
    } // namespace SongAvailableStatus

    namespace PlaylistAvailableStatus {
            static const ::Courier::DataItemKey isEnableItem = 31;
    } // namespace PlaylistAvailableStatus

    namespace AlbumAvailableStatus {
            static const ::Courier::DataItemKey isEnableItem = 67;
    } // namespace AlbumAvailableStatus

    namespace AddressEntryStatus {
            static const ::Courier::DataItemKey isVisibleItem = 2;
    } // namespace AddressEntryStatus

    namespace CallNameEnabledStatus {
            static const ::Courier::DataItemKey isEnableItem = 11;
    } // namespace CallNameEnabledStatus

    namespace TimedStepMovementSlider {
            static const ::Courier::DataItemKey CurrentValueItem = 49;
            static const ::Courier::DataItemKey StepSizeItem = 6;
            static const ::Courier::DataItemKey NumOfStepsItem = 54;
    } // namespace TimedStepMovementSlider

    namespace PhoneNumberAvailableStatus {
            static const ::Courier::DataItemKey isVisibleItem = 59;
    } // namespace PhoneNumberAvailableStatus

    namespace NextButtonActiveStatus {
            static const ::Courier::DataItemKey NextButtonActiveItem = 22;
    } // namespace NextButtonActiveStatus

    namespace PopUpText {
            static const ::Courier::DataItemKey DynamicTextItem = 29;
            static const ::Courier::DataItemKey ChangeCountryStateTextItem = 25;
    } // namespace PopUpText

    namespace MediaDeviceConnectedStatus {
            static const ::Courier::DataItemKey isEnableItem = 24;
    } // namespace MediaDeviceConnectedStatus

    namespace PopUpSingleText {
            static const ::Courier::DataItemKey SRTextItem = 55;
    } // namespace PopUpSingleText

    namespace PopUpMultipleText {
            static const ::Courier::DataItemKey SROneItem = 58;
            static const ::Courier::DataItemKey SRPlusItem = 30;
            static const ::Courier::DataItemKey SRStarItem = 3;
            static const ::Courier::DataItemKey SRHashItem = 13;
            static const ::Courier::DataItemKey SRReadNumberItem = 19;
            static const ::Courier::DataItemKey SRCallNumberItem = 1;
            static const ::Courier::DataItemKey SRCorrectItem = 51;
            static const ::Courier::DataItemKey SRDeleteAllItem = 63;
    } // namespace PopUpMultipleText

    namespace HouseNumberRange {
            static const ::Courier::DataItemKey isVisibleItem = 20;
    } // namespace HouseNumberRange

    namespace ArtistAvailableStatus {
            static const ::Courier::DataItemKey isEnableItem = 28;
    } // namespace ArtistAvailableStatus

    namespace RouteInProgressStatus {
            static const ::Courier::DataItemKey isVisibleItem = 48;
    } // namespace RouteInProgressStatus

    namespace NavigationAvailableStatus {
            static const ::Courier::DataItemKey isVisibleItem = 32;
    } // namespace NavigationAvailableStatus

    namespace Nav_AddressEntryRouteProgressAvailableStatus {
            static const ::Courier::DataItemKey isRGVisibleItem = 7;
            static const ::Courier::DataItemKey isAddressVisibleItem = 21;
    } // namespace Nav_AddressEntryRouteProgressAvailableStatus
} // namespace ItemKey

bool InitDataBinding();

#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
namespace FeatStd {
// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ListScrollBarInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ListScrollBarInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PopUpTextDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PopUpTextDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PopUpSingleTextDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PopUpSingleTextDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ListSliderDisplayDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ListSliderDisplayDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::NextButtonActiveStatusDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::NextButtonActiveStatusDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PrevButtonActiveStatusDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PrevButtonActiveStatusDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ListPageNumberDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ListPageNumberDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PopUpMultipleTextDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PopUpMultipleTextDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::TimedStepMovementSliderDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::TimedStepMovementSliderDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::BargeInEnableStatusDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::BargeInEnableStatusDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SRStatusDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SRStatusDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::MediaDeviceConnectedStatusDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::MediaDeviceConnectedStatusDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::CallNameEnabledStatusDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::CallNameEnabledStatusDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PhoneAvailableStatusDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PhoneAvailableStatusDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::NavigationAvailableStatusDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::NavigationAvailableStatusDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::AddressEntryStatusDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::AddressEntryStatusDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::RouteInProgressStatusDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::RouteInProgressStatusDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Nav_AddressAvailableStatusDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Nav_AddressAvailableStatusDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Nav_RouteProgressAvailableStatusDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Nav_RouteProgressAvailableStatusDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Nav_AddressEntryRouteProgressAvailableStatusDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Nav_AddressEntryRouteProgressAvailableStatusDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PhoneNumberAvailableStatusDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PhoneNumberAvailableStatusDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::AlbumAvailableStatusDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::AlbumAvailableStatusDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ArtistAvailableStatusDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ArtistAvailableStatusDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::GenreAvailableStatusDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::GenreAvailableStatusDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SongAvailableStatusDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SongAvailableStatusDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::AudiobookAvailableStatusDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::AudiobookAvailableStatusDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PodcastAvailableStatusDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PodcastAvailableStatusDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PlaylistAvailableStatusDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PlaylistAvailableStatusDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HouseNumberRangeDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HouseNumberRangeDataBindingSource > const& dataItemContainer);
} // namespace FeatStd
#endif // FEATSTD_STRINGBUFFER_APPENDER_ENABLED
#endif // AppHmi_SdsStateMachine_h
