/************************************************************************
*FILE: AppHmi_SPIStateMachineData.cpp 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/*
 * Id:        AppHmi_SPIStateMachineData.cpp
 *
 * Function:  VS System Data Source File.
 *
 * Generated: Wed May 25 00:10:07 2022
 *
 * Coder 7, 3, 2, 2426
 * 
 * This is an automatically generated file. It will be overwritten by the Coder.
 * 
 * DO NOT EDIT THE FILE!
 */


#include "AppHmi_SPIStateMachineSEMLibB.h"


#include "AppHmi_SPIStateMachineData.h"


#include <stdarg.h>


/*
 * VS System External Variable Definitions.
 */
VS_INT m_ActiveDeviceCategory = 0;

VS_INT m_CurrentView = 0;

VS_INT m_DeviceConnectionStatus = 0;

VS_BOOL m_FirstTime = 0;

VS_INT m_LastState = 1;

VS_INT m_MirrorLinkORDipo = 0;

VS_BOOL m_OnParkingBreak = 0;

VS_INT m_SessionActive = 0;

VS_INT m_SessionStatus = 0;

VS_INT m_bFGAppLaunchable = 0;

VS_BOOL sm_variant_smart = 0;


/*
 * SEM Deduct Function.
 */
unsigned char AppHmi_SPIStateMachine::SEM_Deduct (SEM_EVENT_TYPE EventNo, ...)
{
  va_list ap;

  va_start(ap, EventNo);
  if (SEM.State == 0x00u /* STATE_SEM_NOT_INITIALIZED */)
  {
    return SES_NOT_INITIALIZED;
  }
  if (VS_NOF_EVENTS <= EventNo)
  {
    return (SES_RANGE_ERR);
  }
  switch (EventNo)
  {
  case 67:
    EventArgsVar.DB91.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 71:
    EventArgsVar.DB91.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 72:
    EventArgsVar.DB91.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 73:
    EventArgsVar.DB91.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 74:
    EventArgsVar.DB91.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 75:
    EventArgsVar.DB91.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 76:
    EventArgsVar.DB76.VS_INT8Var[0] = (VS_INT8) va_arg(ap, VS_INT);
    break;

  case 86:
    EventArgsVar.DB91.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 87:
    EventArgsVar.DB90.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 88:
    EventArgsVar.DB90.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 89:
    EventArgsVar.DB90.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 90:
    EventArgsVar.DB90.VS_INT32Var[0] = (VS_INT32) va_arg(ap, VS_INT32_VAARG);
    EventArgsVar.DB90.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 91:
    EventArgsVar.DB91.VS_INT32Var[0] = (VS_INT32) va_arg(ap, VS_INT32_VAARG);
    EventArgsVar.DB91.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 92:
    EventArgsVar.DB91.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 93:
    EventArgsVar.DB93.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 94:
    EventArgsVar.DB90.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 95:
    EventArgsVar.DB90.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  default:
    break;
  }
  SEM.EventNo = EventNo;
  SEM.DIt = 2;
  SEM.State = 0x02u; /* STATE_SEM_PREPARE */

  va_end(ap);
  return (SES_OKAY);
}


/*
 * Guard Expression Functions.
 */
VS_BOOL AppHmi_SPIStateMachine::VSGuard (SEM_GUARD_EXPRESSION_TYPE i)
{
  switch (i)
  {
  case 0:
    return (VS_BOOL)(EventArgsVar.DB90.VS_UINT32Var[0] == SPI_AppPopup_Pfo_SPI_Retry);
  case 1:
    return (VS_BOOL)(EventArgsVar.DB91.VS_UINT32Var[0] == SPI_SysPopup_Pfo_2ndDeviceConnectConfirmation);
  case 2:
    return (VS_BOOL)(EventArgsVar.DB91.VS_UINT32Var[0] == SPI_SysPopup_Pfo_ParkedCondition);
  case 3:
    return (VS_BOOL)(EventArgsVar.DB91.VS_UINT32Var[0] == SPI_SysPopup_Pfo_1stDeviceConnection);
  case 4:
    return (VS_BOOL)(EventArgsVar.DB91.VS_UINT32Var[0] == SPI_SysPopup_Pfo_SPI_BT_Pairing);
  case 5:
    return (VS_BOOL)(EventArgsVar.DB91.VS_UINT32Var[0] == 10 && sm_variant_smart == 0);
  case 6:
    return (VS_BOOL)(EventArgsVar.DB91.VS_UINT32Var[0] == 10 && sm_variant_smart == 1);
  case 7:
    return (VS_BOOL)(m_MirrorLinkORDipo == 2);
  case 8:
    return (VS_BOOL)(m_MirrorLinkORDipo == 1 || m_MirrorLinkORDipo == 3);
  case 9:
    return (VS_BOOL)((m_ActiveDeviceCategory == 3 || m_ActiveDeviceCategory == 1) && m_SessionStatus == 2);
  case 10:
    return (VS_BOOL)(m_MirrorLinkORDipo == 2 && m_DeviceConnectionStatus == 1);
  case 11:
    return (VS_BOOL)(m_DeviceConnectionStatus == 0 || m_SessionStatus == 0 || m_SessionStatus == 1);
  case 12:
    return (VS_BOOL)(m_DeviceConnectionStatus == 1 && m_ActiveDeviceCategory == 4 && (m_SessionStatus == 2 || m_SessionStatus == 7));
  case 13:
    return (VS_BOOL)(m_MirrorLinkORDipo == 2 && m_FirstTime == 1);
  case 14:
    return (VS_BOOL)((m_MirrorLinkORDipo == 1 || m_MirrorLinkORDipo == 3) && m_SessionActive == 2);
  case 15:
    return (VS_BOOL)(m_MirrorLinkORDipo == 2 && m_FirstTime == 0 && m_bFGAppLaunchable == 1 && m_SessionActive == 1);
  case 16:
    return (VS_BOOL)(m_MirrorLinkORDipo == 2 && m_FirstTime == 0 && (m_bFGAppLaunchable == 0 || m_SessionActive == 0));
  case 17:
    return (VS_BOOL)(m_DeviceConnectionStatus == 0);
  case 18:
    return (VS_BOOL)(m_MirrorLinkORDipo == 2 && m_LastState == 1);
  case 19:
    return (VS_BOOL)(m_MirrorLinkORDipo == 2 && m_LastState == 2 && m_bFGAppLaunchable == 1 && m_SessionActive == 1);
  case 20:
    return (VS_BOOL)(m_MirrorLinkORDipo == 2 && m_LastState == 2 && (m_bFGAppLaunchable == 0 || m_SessionActive == 0));
  case 21:
    return (VS_BOOL)(m_DeviceConnectionStatus == 1);
  }
  return (VS_BOOL)(m_MirrorLinkORDipo == 2 && m_bFGAppLaunchable == 1 && m_SessionActive == 1 && m_LastState == 2 && m_FirstTime == 0);
}


/*
 * Action Expressions Wrapper Function.
 */
VS_VOID AppHmi_SPIStateMachine::VSAction (SEM_ACTION_EXPRESSION_TYPE i)
{
  switch (i)
  {
  case 1:
    Activate_Home();
    break;
  case 3:
    ApplicationFGAction();
    break;
  case 6:
    DeviceConnection();
    break;
  case 8:
    GetApplicationList();
    break;
  case 10:
    InitForDipo();
    break;
  case 11:
    InitForMirrorLink();
    break;
  case 12:
    LaunchAAPorCPApp();
    break;
  case 13:
    LaunchLastApplication();
    break;
  case 15:
    LaunchMySpinApp();
    break;
  case 19:
    MarkLastActiveStateAppList();
    break;
  case 21:
    Notify_Init_Finished();
    break;
  case 24:
    SPIApplicationTest();
    break;
  case 25:
    SPIEntry();
    break;
  case 27:
    SPI_ActivityId();
    break;
  case 28:
    SecondDeviceConnectConfirmationNO();
    break;
  case 29:
    SecondDeviceConnectConfirmationYes();
    break;
  case 32:
    SwitchToHomeScreen();
    break;
  case 33:
    SwitchToSPIHome();
    break;
  case 54:
    m_CurrentView = VIEW_NONE;
    break;
  case 55:
    m_CurrentView = VIEW_S_FULLSCREEN;
    break;
  case 56:
    m_CurrentView = VIEW_PHONE_NOT_CONNECTED;
    break;
  case 57:
    m_CurrentView = VIEW_MYSPIN_APPVIEW;
    break;
  case 58:
    gacViewHideAndDestroyReq(SPI_AppPopup_Pfo_SPI_Retry);
    break;
  case 59:
    gacViewHideAndDestroyReq(SPI_SysPopup_Pfo_2ndDeviceConnectConfirmation);
    break;
  case 60:
    gacViewHideAndDestroyReq(SPI_SysPopup_Pfo_ParkedCondition);
    break;
  case 61:
    gacViewHideAndDestroyReq(SPI_SysPopup_Pfo_1stDeviceConnection);
    break;
  case 62:
    gacViewHideAndDestroyReq(SPI_SysPopup_Pfo_SPI_BT_Pairing);
    break;
  case 63:
    gacPopupSBCloseReq(SPI_AppPopup_Pfo_SPI_Retry);
    break;
  case 64:
    gacViewClearReq(SPI_SysPopup_Pfo_SPI_BT_Pairing);
    break;
  case 65:
    gacViewHideReq(SPI_SysPopup_Pfo_SPI_BT_Pairing);
    break;
  case 66:
    gacViewClearReq(SPI_SysPopup_Pfo_ParkedCondition);
    break;
  case 67:
    gacViewHideReq(SPI_SysPopup_Pfo_ParkedCondition);
    break;
  case 68:
    gacViewClearReq(SPI_SysPopup_Pfo_1stDeviceConnection);
    break;
  case 69:
    gacViewHideReq(SPI_SysPopup_Pfo_1stDeviceConnection);
    break;
  case 70:
    gacViewClearReq(SPI_SysPopup_Pfo_2ndDeviceConnectConfirmation);
    break;
  case 71:
    gacViewHideReq(SPI_SysPopup_Pfo_2ndDeviceConnectConfirmation);
    break;
  case 72:
    gacPopupCreateAndSBShowReq(SPI_SysPopup_Pfo_SPI_BT_Pairing);
    break;
  case 73:
    gacPopupSBCloseReq(SPI_SysPopup_Pfo_SPI_BT_Pairing);
    break;
  case 74:
    gacPopupCreateAndSBShowReq(SPI_SysPopup_Pfo_2ndDeviceConnectConfirmation);
    break;
  case 75:
    gacPopupCreateAndSBShowReq(SPI_SysPopup_Pfo_ParkedCondition);
    break;
  case 76:
    gacPopupSBCloseReq(SPI_SysPopup_Pfo_ParkedCondition);
    break;
  case 77:
    gacPopupCreateAndSBShowReq(SPI_SysPopup_Pfo_1stDeviceConnection);
    break;
  case 78:
    gacPopupSBCloseReq(SPI_SysPopup_Pfo_1stDeviceConnection);
    break;
  case 79:
    gacViewCreateReq(SPI_AppPopup_Pfo_SPI_Retry);
    break;
  case 80:
    gacViewShowReq(SPI_AppPopup_Pfo_SPI_Retry);
    break;
  case 81:
    gacViewCreateReq(SPI_SysPopup_Pfo_2ndDeviceConnectConfirmation);
    break;
  case 82:
    gacViewShowReq(SPI_SysPopup_Pfo_2ndDeviceConnectConfirmation);
    break;
  case 83:
    gacPopupSBCloseReq(SPI_SysPopup_Pfo_2ndDeviceConnectConfirmation);
    break;
  case 84:
    gacViewCreateReq(SPI_SysPopup_Pfo_ParkedCondition);
    break;
  case 85:
    gacViewShowReq(SPI_SysPopup_Pfo_ParkedCondition);
    break;
  case 86:
    gacViewCreateReq(SPI_SysPopup_Pfo_1stDeviceConnection);
    break;
  case 87:
    gacViewShowReq(SPI_SysPopup_Pfo_1stDeviceConnection);
    break;
  case 88:
    gacViewCreateReq(SPI_SysPopup_Pfo_SPI_BT_Pairing);
    break;
  case 89:
    gacViewShowReq(SPI_SysPopup_Pfo_SPI_BT_Pairing);
    break;
  case 90:
    gacViewHideReq(SPI_Scenes_S_FullScreen);
    break;
  case 91:
    gacViewDestroyReq(SPI_Scenes_S_FullScreen);
    break;
  case 92:
    gacViewHideReq(SPI_Scenes_Phone_not_connected);
    break;
  case 93:
    gacViewDestroyReq(SPI_Scenes_Phone_not_connected);
    break;
  case 94:
    gacViewHideReq(SPI_Scenes_mySPIN_AppView);
    break;
  case 95:
    gacViewDestroyReq(SPI_Scenes_mySPIN_AppView);
    break;
  case 96:
    gacViewDestroyReq(SPI_SysPopup_Pfo_2ndDeviceConnectConfirmation);
    break;
  case 97:
    gacViewDestroyReq(SPI_SysPopup_Pfo_SPIMessage);
    break;
  case 98:
    gacViewDestroyReq(SPI_SysPopup_Pfo_Connect_BT);
    break;
  case 99:
    gacPopupCreateAndSBShowReq(SPI_AppPopup_Pfo_SPI_Retry);
    break;
  case 100:
    gacViewCreateReq(SPI_Gadget_SPI_SPI_GADGET);
    break;
  case 101:
    gacViewShowReq(SPI_Gadget_SPI_SPI_GADGET);
    break;
  case 102:
    gacViewCreateAndShowReq(SPI_Gadget_SPI_SPI_GADGET_Smart);
    break;
  case 103:
    gacViewHideReq(SPI_Gadget_SPI_SPI_GADGET);
    break;
  case 104:
    gacViewDestroyReq(SPI_Gadget_SPI_SPI_GADGET);
    break;
  case 105:
    gacViewHideAndDestroyReq(SPI_Gadget_SPI_SPI_GADGET_Smart);
    break;
  case 106:
    gacViewCreateReq(SPI_Scenes_S_FullScreen);
    break;
  case 107:
    gacViewShowReq(SPI_Scenes_S_FullScreen);
    break;
  case 108:
    gacViewCreateReq(SPI_Scenes_Phone_not_connected);
    break;
  case 109:
    gacViewShowReq(SPI_Scenes_Phone_not_connected);
    break;
  case 110:
    gacViewCreateReq(SPI_Scenes_mySPIN_AppView);
    break;
  case 111:
    gacViewShowReq(SPI_Scenes_mySPIN_AppView);
    break;

  default:
    break;
  }
}
