/************************************************************************
*FILE: AppHmi_SPIStateMachine.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(AppHmi_SPIStateMachine_h)
#define AppHmi_SPIStateMachine_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Courier/Messaging/Message.h>
#include <AppHmi_SPIStateMachineSEMLibB.h>
#include <AppHmi_SPIStateMachineData.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Cit/VisualStateGlueLayer/DeductResult.h>
#ifdef CIT_SIMULATION
#include <json/value.h>
#endif
#include <AppHmi_SPITypes.h>
#include <AppHmi_SPIMessages.h>
#include <AppHmi_SPIConstants.h>
#include <AppHmi_SPIDatabinding.h>
#include <AppHmi_SPIViews.h>
#include <AppHmi_SPIController.h>
// ------------------------------------------------------------------------
class AppHmi_SPIStateMachineImpl : public AppHmi_SPIStateMachine
{
public:
    typedef AppHmi_SPIStateMachine Base;

#ifdef VISUALSTATE_7_TRACE
    // Mapping of data types of API to get rid of include dependencies
    //typedef SEM_ACTION_EXPRESSION_TYPE VS_Type_ActionExpression;
	using Base::VS_Type_ActionExpression;
    //typedef SEM_EVENT_TYPE VS_Type_Event;
	//typedef SEM_STATE_TYPE VS_Type_State;
	//typedef SEM_EXPLANATION_TYPE VS_Type_Explanation;
	//typedef SEM_STATE_MACHINE_TYPE VS_Type_Statemachine;
	using Base::VS_Type_Event;
	using Base::VS_Type_State;
	using Base::VS_Type_Explanation;
	using Base::VS_Type_Statemachine;

    // Mapping of enums and defines of API to get rid of include dependencies
    //enum { VS_Ret_Ok = SES_OKAY };
    //enum { VS_Ret_Found = SES_FOUND };
	enum { VS_Ret_Ok = Base::VS_Ret_Ok };
	enum { VS_Ret_Found = Base::VS_Ret_Found };
    enum { VS_Evt_Reset = SE_RESET };
    enum { VS_Ret_Error = SES_RANGE_ERR };
#else
#ifndef VISUALSTATE_HCODER
    typedef SEM_ACTION_EXPRESSION_TYPE VS_Type_ActionExpression;
    typedef SEM_EVENT_TYPE VS_Type_Event;
    typedef SEM_STATE_TYPE VS_Type_State;
    typedef SEM_EXPLANATION_TYPE VS_Type_Explanation;
    typedef SEM_STATE_MACHINE_TYPE VS_Type_Statemachine;
    enum { VS_Ret_Ok = SES_OKAY };
    enum { VS_Ret_Found = SES_FOUND };
    enum { VS_Evt_Reset = SE_RESET };
    enum { VS_Ret_Error = SES_RANGE_ERR };
#else
    enum { VS_Ret_Ok = 0U };
    enum { VS_Ret_Found = 1U };
    enum { VS_Evt_Reset = 0U };
    enum { VS_Ret_Error = 4U };
#endif
#endif
// ------------------------------------------------------------------------

    // Mapping of args passed as hashId to corresponding identifier
    static const ::FeatStd::Char *GetNameFromId(::FeatStd::UInt32 id);

// ------------------------------------------------------------------------
    virtual void Activate_Home();
    virtual void SPI_ActivityId();
    virtual void SwitchToHomeScreen();
    virtual void SwitchToSPIHome();
    virtual void LaunchMySpinApp();
    virtual void LaunchAAPorCPApp();
    virtual void DeviceConnection();
    virtual void SPIEntry();
    virtual void Notify_Init_Finished();
    virtual void Activate_BT_SR_Session();
    virtual void Halt_BT_SR_Session();
    virtual void SPIMessagePopupAction();
    virtual void BackToHomeScreen();
    virtual void RevertMirrorLinkView();
    virtual void LaunchPhoneApp();
    virtual void LaunchNaviApp();
    virtual void LaunchMediaApp();
    virtual void GetApplicationList();
    virtual void InitForDipo();
    virtual void InitForMirrorLink();
    virtual void LaunchLastApplication();
    virtual void BackToActiveSession();
    virtual void StartedActiveSession();
    virtual void SiriOnExitAction();
    virtual void SecondDeviceConnectConfirmationYes();
    virtual void SecondDeviceConnectConfirmationNO();
    virtual void Pfo_Connect_BTOK();
    virtual void MarkLastActiveStateAppList();
    virtual void MarkLastActiveStateFullScreen();
    virtual void ApplicationFGAction();
    virtual void ApplicationBGAction();
    virtual void SPIApplicationTest();
    virtual void ToggleML();
    virtual void ToggleTA();
    virtual void TogglePA();
    virtual void UpdateS_OPTSettings();
    virtual void MarkConnectSPScreen();
    virtual void ExitConnectSPScreen();
    virtual void gacChangeLanguageReq(::FeatStd::Int32 aLanguageId);
    virtual void gacHideFocusInViewReq(::FeatStd::UInt32 aView);
    virtual void NextLevelTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void PreviousLevelTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void DualViewLeftTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void DualViewRightTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void PageFlipBackTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void PageFlipFrontTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void ZoomInTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView, ::FeatStd::Int8 aPos);
    virtual void ZoomOutTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView, ::FeatStd::Int8 aPos);
    virtual void FadeTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void gacWaitAnimationStartReq();
    virtual void acFocusOnRightEncoderReqUpd(bool aIsFocusUsed);
    virtual void acSetGadgetSceenActiveStatus(bool aIsGadgetAtive);
    virtual void acHKNotificationMsg(::FeatStd::Int8 aHKCode, ::FeatStd::Int8 aHKState);
    virtual void acPerform_CloseAllDropdowns();
    virtual void acPerform_CloseDropdown(::FeatStd::UInt32 aListId);
    virtual void acPerform_OpenDropdown(::FeatStd::UInt32 aListId);
    virtual void acPerform_ToggleDropdown(::FeatStd::UInt32 aListId);
    virtual void acStartAppPopupTimer(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aTimeout);
    virtual void acStopAppPopupTimer(::FeatStd::UInt32 aViewId);
    virtual void acPostBeep(::FeatStd::Int8 aBeepType);
    virtual void gacCheckToClosePopup(::FeatStd::UInt32 aPopupId);
    virtual void acRestartAppPopupTimer(::FeatStd::UInt32 aViewId);
    virtual void gacContextSwitchBackRes(::FeatStd::UInt32 aSwitchId);
    virtual void gacContextSwitchCompleteRes(::FeatStd::UInt32 aSwitchId);
    virtual void gacContextSwitchFailedRes(::FeatStd::UInt32 aSwitchId);
    virtual void gacContextSwitchDoneRes(::FeatStd::UInt32 aSwitchId);
    virtual void gacContextSwitchOutReq(::FeatStd::UInt32 aTargetContextId, ::FeatStd::UInt32 aSourceContextId, ::FeatStd::UInt32 aTargetAppId);
    virtual void gacCurrentScreenDisplayReq();
    virtual void gacLaunchBarDisplayReq(bool aVisibility);
    virtual void gacNavTBTSwipe();
    virtual void gacPerformListBtnRightEncoderChangeUpd(::FeatStd::Int8 aSteps, ::FeatStd::UInt32 aListId, ::FeatStd::UInt32 aRowId, ::FeatStd::UInt32 aColumnId);
    virtual void gacScrollListUp();
    virtual void gacScrollListDown();
    virtual void gacScrollPageUp();
    virtual void gacScrollPageDown();
    virtual void gacScrollListFocusUp(::FeatStd::UInt32 aListId);
    virtual void gacScrollListFocusDown(::FeatStd::UInt32 aListId);
    virtual void gacPerformListFocusLockDataResetUpd();
    virtual void gacSetApplicationMode(::FeatStd::UInt32 aModeId);
    virtual void gacSpellerBbehaviorReq(bool aEnable);
    virtual void gacStatusBarDisplayReq(bool aVisibility, ::FeatStd::Int32 aHeaderType);
    virtual void gacTBTRetriggerAcousticOutput();
    virtual void gacWaitAnimationStopReq();
    virtual void gacViewCreateReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewCreateAllReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewDestroyReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewClearReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewShowReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewHideReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewCreateWithoutLoadReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewAsyncLoadReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewActivateWithoutRenderingReq(::FeatStd::UInt32 aViewId);
    virtual void gacPopupCreateAndSBShowReq(::FeatStd::UInt32 aViewId);
    virtual void gacPopupCreateAndSBShowReqForMultiDisplay(::FeatStd::UInt32 aPopupDisplayID, ::FeatStd::UInt32 aViewId);
    virtual void gacPopupSBCloseReq(::FeatStd::UInt32 aViewId);
    virtual void gacPopupSBCloseReqForMultiDisplay(::FeatStd::UInt32 aPopupDisplayID, ::FeatStd::UInt32 aViewId);
    virtual void gacPopupRestartTimerReq(::FeatStd::UInt32 aViewId);
    virtual void gacPopupRestartTimerReqForMultiDisplay(::FeatStd::UInt32 aPopupDisplayID, ::FeatStd::UInt32 aViewId);
    virtual void gacViewCreateAndShowReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewHideAndDestroyReq(::FeatStd::UInt32 aViewId);
    virtual void gacSceneTransitionEnter(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aHint);
    virtual void gacSceneTransitionLeave(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aHint);
    virtual void gacDisplayStatusLineReq(::FeatStd::Int32 aDisplayRegionType);
    virtual void gacHideStatusLineReq(::FeatStd::Int32 aDisplayRegionType);
    virtual void gacDisplayFooterLineReq();
    virtual void gacHideFooterLineReq();
    virtual void gacDisplayStatusLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID);
    virtual void gacHideStatusLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID);
    virtual void gacDisplayFooterLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID);
    virtual void gacHideFooterLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID);
    virtual void gacRegisterForCloseOnTouchSession(::FeatStd::UInt32 aViewId);
    virtual void gacDeregisterForCloseOnTouchSessionReq(::FeatStd::UInt32 aViewId);
    virtual void gacPopupFilterPrioEnableReq(::FeatStd::UInt32 aPrio);
    virtual void gacPopupFilterAllEnableReq();
    virtual void gacPopupFilterDisableReq();
    virtual void gacProfileChange(::FeatStd::Int8 aProfile);
    virtual void gacPopupFilterPrioEnableReqForDisplay(::FeatStd::UInt32 aPrio, ::FeatStd::UInt32 aDisplayID);
    virtual void gacPopupFilterAllEnableReqForDisplay(::FeatStd::UInt32 aDisplayID);
    virtual void gacPopupFilterDisableReqForDisplay(::FeatStd::UInt32 aDisplayID);
    virtual void gacStartSceneTransitionAnimation(::FeatStd::UInt32 aSourceView, ::FeatStd::UInt32 aDestinationView, ::FeatStd::UInt32 aUserData1, ::FeatStd::Int8 aUserData2);
    virtual void gacDecrementActiveAnimationCount();

#ifdef CIT_SIMULATION
    bool CallAction(const ::FeatStd::Char* actionName, const ::Json::Value& parameters, ::Json::Value &response);
    const ::FeatStd::Char* GetEventName(::FeatStd::UInt32 eventId, ::Courier::Message const & message, Json::Value& eventArgument);
#endif
    // Added function for deduction of one event to simplify the event loop
    bool HandleDataBindingEventMapping(::Courier::AbstractDataItemMsg const & message, ::FeatStd::UInt32& eventId) const;
    bool HandleEventMapping(::Courier::Message const & message, ::FeatStd::UInt32& eventId) const;

    ::Cit::DeductResult::Enum DeductEvent(::Courier::Message const & message, ::FeatStd::UInt32 eventId);

    //====  member function with TTFis output - added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====

	virtual unsigned short GetTraceClass();
	int GetNumberOfStatemachines();
    //====  member function with TTFis output - end                        key: SM_TTFis_SBHFMSRF ====
};

// ------------------------------------------------------------------------
bool SendSwitchToHomeScreenReq();
bool SendViewSPIActivityId();
bool SendSwitchToSPIHomeReq();
bool SendLaunchMySpinAppMsg();
bool SendLaunchAAPorCPAppMsg();
bool SendDeviceConnectionMsg();
bool SendSPIEntryMsg();
bool SendGuiStartupFinishedUpdMsg();
bool SendBTSRSessionStartAppReqMsg();
bool SendBTSRSessionStopAppReqMsg();
bool SendSPIPopupActionMsg();
bool SendGoToHomeScreenMsg();
bool SendRevertMirrorLinkViewMsg();
bool SendLaunchPhoneAppMsg();
bool SendLaunchNaviAppMsg();
bool SendLaunchMediaAppMsg();
bool SendGetApplicationListMsg();
bool SendInitForDipoMsg();
bool SendInitForMirrorLinkMsg();
bool SendLaunchLastApplicationMsg();
bool SendBackToActiveSessionMsg();
bool SendStartedActiveSessionMsg();
bool SendSiriOnExitMsg();
bool SendSecondDeviceConnectConfirmationYesMsg();
bool SendSecondDeviceConnectConfirmationNOMsg();
bool SendPfo_Connect_BTOKMsg();
bool SendMarkLastActiveStateAppListMsg();
bool SendMarkLastActiveStateFullScreenMsg();
bool SendApplicationFGActionMsg();
bool SendApplicationBGActionMsg();
bool SendSPIApplicationTestMsg();
bool SendToggleMLMsg();
bool SendToggleTAMsg();
bool SendTogglePAMsg();
bool SendUpdateS_OPTSettingsMsg(Candera::UInt8 const & aShowMirrorLink, Candera::UInt8 const & aTrafficAnnouncement, Candera::UInt8 const & aPhoneApplication);
bool SendMarkConnectSPScreenMsg();
bool SendExitConnectSPScreenMsg();
bool SendChangeLanguageReqMsg(enLanguageId const & aLanguageId);
bool SendFocusReqMsg(FocusActionEnum const & aAction, FocusTimerActionEnum const & aTimerAction, ::Courier::ViewId const & aView, Candera::String const & aWidget);
bool SendDummyMess(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos);
bool SendAnimationReqMsg(Courier::AnimationAction::Enum const & aAnimationAction, ::Courier::ViewId const & aViewId, Courier::CompositePath const & aCompositePath, ::Courier::ItemId const & aAnimationId, Courier::AnimationProperties const & aAnimationProperties);
bool SendFocusOnRightEncoderReqUpdMsg(bool const & aIsFocusUsed);
bool SendStoreActiveGadgetReqMsg(bool const & aIsGadgetAtive);
bool SendHardKeyPressNotificationMsg(Courier::UInt8 const & aDummy, Courier::UInt8 const & aHKCode, Courier::UInt8 const & aHKState);
bool SendDropdownChangeMsg(::Candera::DropdownChangeType const & aDropdownChangeType, ::Courier::UInt32 const & aListId);
bool SendStartPopupTimerReqMsg(Courier::UInt32 const & aViewId, Courier::UInt32 const & aTimeout);
bool SendStopPopupTimerReqMsg(Courier::UInt32 const & aViewId);
bool SendPlayBeepReqMsg(Courier::Int32 const & aBeepType);
bool SendCheckToClosePopupMsg(Courier::UInt32 const & aPopupId);
bool SendRestartPopupTimerReqMsg(Courier::UInt32 const & aViewId);
bool SendContextSwitchInResMsg(Courier::UInt32 const & aSwitchId, Courier::UInt32 const & aResponseType);
bool SendContextSwitchOutReqMsg(Courier::UInt32 const & aTargetContextId, Courier::UInt32 const & aSourceContextId, Courier::UInt32 const & aTargetAppId);
bool SendCurrentScreenDisplayReqMsg();
bool SendLaunchBarDisplayReqMsg(bool const & aVisibility);
bool SendNavTBTSwipeReqMsg();
bool SendListItemRightEncoderChangeUpdMsg(Courier::Int8 const & aSteps, Courier::UInt32 const & aListId, Courier::UInt32 const & aRowId, Courier::UInt32 const & aColumnId);
bool SendListChangeMsg(::Courier::UInt32 const & aListId, ListChangeType const & aListChangeType, ::Courier::Int32 const & aValue, ListChangeMsgSourceType const & aListChangeMsgSource, bool const & aImmediatePositioning);
bool SendListFocusScrollReqMsg(Courier::UInt32 const & aListId, Courier::Int32 const & aSteps);
bool SendListFocusLockDataResetReqMsg();
bool SendSetApplicationModeReqMsg(Courier::UInt32 const & aModeId);
bool SendSpellerBbehaviorReqMsg(bool const & aEnable);
bool SendStatusBarDisplayReqMsg(bool const & aVisibility, Courier::Int32 const & aHeaderType);
bool SendTBTRetriggerAcousticMsg();
bool SendViewReqMsg(Courier::ViewAction::Enum const & aViewAction, ::Courier::ViewId const & aViewId, bool const & aShallInitScene, bool const & aShallLoadScene);
bool SendActivationReqMsg(::Courier::ViewId const & aViewId, bool const & aActivation, bool const & aEnableRendering);
bool SendAsyncLoadReqMsg(::Courier::ViewId const & aViewId, bool const & aLoad);
bool SendPopupReqMsg(hmibase::popups::CommandEnum const & aCommand, ::Courier::ViewId const & aViewId, Courier::UInt32 const & aPopupDisplayID);
bool SendExtendedViewReqMsg(hmibase::views::CommandEnum const & aCommand, ::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint);
bool SendShowHMISubSurfaceReqMsg(hmibase::displayRegion const & aDisplayRegion, Courier::Int32 const & aDisplayRegionType, bool const & aShowSubSurface, Courier::UInt32 const & aDisplayID, bool const & aLockSubSurface);
bool SendRegisterForCloseOnTouchSessionReqMsg(bool const & aRegister, ::Courier::ViewId const & aViewId);
bool SendPopupFilterPrioEnableReqMsg(Courier::UInt32 const & aPrio);
bool SendPopupFilterAllEnableReqMsg();
bool SendPopupFilterDisableReqMsg();
bool SendProfileSwitchMsg(Courier::UInt32 const & aProfile);
bool SendMultiDisplayPopupFilterReqMsg(hmibase::PopupFilterType const & aPopupFilterType, Courier::UInt32 const & aPrio, Courier::UInt32 const & aDisplayID);
bool SendCreateNewDestroyOld(::Courier::ViewId const & aSourceView, ::Courier::ViewId const & aDestinationView, Courier::UInt32 const & aUserData1, Courier::Int8 const & aUserData2);
bool SendNotifierMessage();

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Activate_Home(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Activate_Home();
#ifdef CIT_SIMULATION
bool CallAction_SPI_ActivityId(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_SPI_ActivityId();
#ifdef CIT_SIMULATION
bool CallAction_SwitchToHomeScreen(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_SwitchToHomeScreen();
#ifdef CIT_SIMULATION
bool CallAction_SwitchToSPIHome(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_SwitchToSPIHome();
#ifdef CIT_SIMULATION
bool CallAction_LaunchMySpinApp(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_LaunchMySpinApp();
#ifdef CIT_SIMULATION
bool CallAction_LaunchAAPorCPApp(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_LaunchAAPorCPApp();
#ifdef CIT_SIMULATION
bool CallAction_DeviceConnection(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_DeviceConnection();
#ifdef CIT_SIMULATION
bool CallAction_SPIEntry(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_SPIEntry();
#ifdef CIT_SIMULATION
bool CallAction_Notify_Init_Finished(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Notify_Init_Finished();
#ifdef CIT_SIMULATION
bool CallAction_Activate_BT_SR_Session(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Activate_BT_SR_Session();
#ifdef CIT_SIMULATION
bool CallAction_Halt_BT_SR_Session(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Halt_BT_SR_Session();
#ifdef CIT_SIMULATION
bool CallAction_SPIMessagePopupAction(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_SPIMessagePopupAction();
#ifdef CIT_SIMULATION
bool CallAction_BackToHomeScreen(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_BackToHomeScreen();
#ifdef CIT_SIMULATION
bool CallAction_RevertMirrorLinkView(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_RevertMirrorLinkView();
#ifdef CIT_SIMULATION
bool CallAction_LaunchPhoneApp(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_LaunchPhoneApp();
#ifdef CIT_SIMULATION
bool CallAction_LaunchNaviApp(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_LaunchNaviApp();
#ifdef CIT_SIMULATION
bool CallAction_LaunchMediaApp(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_LaunchMediaApp();
#ifdef CIT_SIMULATION
bool CallAction_GetApplicationList(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_GetApplicationList();
#ifdef CIT_SIMULATION
bool CallAction_InitForDipo(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_InitForDipo();
#ifdef CIT_SIMULATION
bool CallAction_InitForMirrorLink(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_InitForMirrorLink();
#ifdef CIT_SIMULATION
bool CallAction_LaunchLastApplication(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_LaunchLastApplication();
#ifdef CIT_SIMULATION
bool CallAction_BackToActiveSession(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_BackToActiveSession();
#ifdef CIT_SIMULATION
bool CallAction_StartedActiveSession(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_StartedActiveSession();
#ifdef CIT_SIMULATION
bool CallAction_SiriOnExitAction(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_SiriOnExitAction();
#ifdef CIT_SIMULATION
bool CallAction_SecondDeviceConnectConfirmationYes(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_SecondDeviceConnectConfirmationYes();
#ifdef CIT_SIMULATION
bool CallAction_SecondDeviceConnectConfirmationNO(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_SecondDeviceConnectConfirmationNO();
#ifdef CIT_SIMULATION
bool CallAction_Pfo_Connect_BTOK(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Pfo_Connect_BTOK();
#ifdef CIT_SIMULATION
bool CallAction_MarkLastActiveStateAppList(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_MarkLastActiveStateAppList();
#ifdef CIT_SIMULATION
bool CallAction_MarkLastActiveStateFullScreen(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_MarkLastActiveStateFullScreen();
#ifdef CIT_SIMULATION
bool CallAction_ApplicationFGAction(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_ApplicationFGAction();
#ifdef CIT_SIMULATION
bool CallAction_ApplicationBGAction(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_ApplicationBGAction();
#ifdef CIT_SIMULATION
bool CallAction_SPIApplicationTest(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_SPIApplicationTest();
#ifdef CIT_SIMULATION
bool CallAction_ToggleML(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_ToggleML();
#ifdef CIT_SIMULATION
bool CallAction_ToggleTA(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_ToggleTA();
#ifdef CIT_SIMULATION
bool CallAction_TogglePA(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TogglePA();
#ifdef CIT_SIMULATION
bool CallAction_UpdateS_OPTSettings(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_UpdateS_OPTSettings();
#ifdef CIT_SIMULATION
bool CallAction_MarkConnectSPScreen(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_MarkConnectSPScreen();
#ifdef CIT_SIMULATION
bool CallAction_ExitConnectSPScreen(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_ExitConnectSPScreen();
#ifdef CIT_SIMULATION
bool CallAction_gacChangeLanguageReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacChangeLanguageReq(enLanguageId const & aLanguageId);
#ifdef CIT_SIMULATION
bool CallAction_gacHideFocusInViewReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacHideFocusInViewReq(::Courier::ViewId const & aView);
#ifdef CIT_SIMULATION
bool CallAction_NextLevelTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_NextLevelTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_PreviousLevelTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_PreviousLevelTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_DualViewLeftTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_DualViewLeftTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_DualViewRightTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_DualViewRightTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_PageFlipBackTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_PageFlipBackTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_PageFlipFrontTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_PageFlipFrontTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_ZoomInTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_ZoomInTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos);
#ifdef CIT_SIMULATION
bool CallAction_ZoomOutTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_ZoomOutTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos);
#ifdef CIT_SIMULATION
bool CallAction_FadeTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_FadeTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_gacWaitAnimationStartReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacWaitAnimationStartReq();
#ifdef CIT_SIMULATION
bool CallAction_acFocusOnRightEncoderReqUpd(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acFocusOnRightEncoderReqUpd(bool const & aIsFocusUsed);
#ifdef CIT_SIMULATION
bool CallAction_acSetGadgetSceenActiveStatus(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSetGadgetSceenActiveStatus(bool const & aIsGadgetAtive);
#ifdef CIT_SIMULATION
bool CallAction_acHKNotificationMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acHKNotificationMsg(Courier::UInt8 const & aHKCode, Courier::UInt8 const & aHKState);
#ifdef CIT_SIMULATION
bool CallAction_acPerform_CloseAllDropdowns(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPerform_CloseAllDropdowns();
#ifdef CIT_SIMULATION
bool CallAction_acPerform_CloseDropdown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPerform_CloseDropdown(::Courier::UInt32 const & aListId);
#ifdef CIT_SIMULATION
bool CallAction_acPerform_OpenDropdown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPerform_OpenDropdown(::Courier::UInt32 const & aListId);
#ifdef CIT_SIMULATION
bool CallAction_acPerform_ToggleDropdown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPerform_ToggleDropdown(::Courier::UInt32 const & aListId);
#ifdef CIT_SIMULATION
bool CallAction_acStartAppPopupTimer(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acStartAppPopupTimer(Courier::UInt32 const & aViewId, Courier::UInt32 const & aTimeout);
#ifdef CIT_SIMULATION
bool CallAction_acStopAppPopupTimer(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acStopAppPopupTimer(Courier::UInt32 const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_acPostBeep(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPostBeep(Courier::Int32 const & aBeepType);
#ifdef CIT_SIMULATION
bool CallAction_gacCheckToClosePopup(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacCheckToClosePopup(Courier::UInt32 const & aPopupId);
#ifdef CIT_SIMULATION
bool CallAction_acRestartAppPopupTimer(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acRestartAppPopupTimer(Courier::UInt32 const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchBackRes(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacContextSwitchBackRes(Courier::UInt32 const & aSwitchId);
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchCompleteRes(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacContextSwitchCompleteRes(Courier::UInt32 const & aSwitchId);
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchFailedRes(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacContextSwitchFailedRes(Courier::UInt32 const & aSwitchId);
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchDoneRes(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacContextSwitchDoneRes(Courier::UInt32 const & aSwitchId);
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchOutReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacContextSwitchOutReq(Courier::UInt32 const & aTargetContextId, Courier::UInt32 const & aSourceContextId, Courier::UInt32 const & aTargetAppId);
#ifdef CIT_SIMULATION
bool CallAction_gacCurrentScreenDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacCurrentScreenDisplayReq();
#ifdef CIT_SIMULATION
bool CallAction_gacLaunchBarDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacLaunchBarDisplayReq(bool const & aVisibility);
#ifdef CIT_SIMULATION
bool CallAction_gacNavTBTSwipe(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacNavTBTSwipe();
#ifdef CIT_SIMULATION
bool CallAction_gacPerformListBtnRightEncoderChangeUpd(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPerformListBtnRightEncoderChangeUpd(Courier::Int8 const & aSteps, Courier::UInt32 const & aListId, Courier::UInt32 const & aRowId, Courier::UInt32 const & aColumnId);
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListUp(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollListUp();
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListDown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollListDown();
#ifdef CIT_SIMULATION
bool CallAction_gacScrollPageUp(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollPageUp();
#ifdef CIT_SIMULATION
bool CallAction_gacScrollPageDown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollPageDown();
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListFocusUp(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollListFocusUp(Courier::UInt32 const & aListId);
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListFocusDown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollListFocusDown(Courier::UInt32 const & aListId);
#ifdef CIT_SIMULATION
bool CallAction_gacPerformListFocusLockDataResetUpd(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPerformListFocusLockDataResetUpd();
#ifdef CIT_SIMULATION
bool CallAction_gacSetApplicationMode(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacSetApplicationMode(Courier::UInt32 const & aModeId);
#ifdef CIT_SIMULATION
bool CallAction_gacSpellerBbehaviorReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacSpellerBbehaviorReq(bool const & aEnable);
#ifdef CIT_SIMULATION
bool CallAction_gacStatusBarDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacStatusBarDisplayReq(bool const & aVisibility, Courier::Int32 const & aHeaderType);
#ifdef CIT_SIMULATION
bool CallAction_gacTBTRetriggerAcousticOutput(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacTBTRetriggerAcousticOutput();
#ifdef CIT_SIMULATION
bool CallAction_gacWaitAnimationStopReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacWaitAnimationStopReq();
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewCreateReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateAllReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewCreateAllReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewDestroyReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewDestroyReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewClearReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewClearReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewShowReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewShowReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewHideReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewHideReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateWithoutLoadReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewCreateWithoutLoadReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewAsyncLoadReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewAsyncLoadReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewActivateWithoutRenderingReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewActivateWithoutRenderingReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupCreateAndSBShowReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupCreateAndSBShowReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupCreateAndSBShowReqForMultiDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupCreateAndSBShowReqForMultiDisplay(Courier::UInt32 const & aPopupDisplayID, ::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupSBCloseReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupSBCloseReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupSBCloseReqForMultiDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupSBCloseReqForMultiDisplay(Courier::UInt32 const & aPopupDisplayID, ::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupRestartTimerReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupRestartTimerReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupRestartTimerReqForMultiDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupRestartTimerReqForMultiDisplay(Courier::UInt32 const & aPopupDisplayID, ::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateAndShowReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewCreateAndShowReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewHideAndDestroyReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewHideAndDestroyReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacSceneTransitionEnter(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacSceneTransitionEnter(::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint);
#ifdef CIT_SIMULATION
bool CallAction_gacSceneTransitionLeave(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacSceneTransitionLeave(::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint);
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayStatusLineReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDisplayStatusLineReq(Courier::Int32 const & aDisplayRegionType);
#ifdef CIT_SIMULATION
bool CallAction_gacHideStatusLineReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacHideStatusLineReq(Courier::Int32 const & aDisplayRegionType);
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayFooterLineReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDisplayFooterLineReq();
#ifdef CIT_SIMULATION
bool CallAction_gacHideFooterLineReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacHideFooterLineReq();
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayStatusLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDisplayStatusLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacHideStatusLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacHideStatusLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayFooterLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDisplayFooterLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacHideFooterLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacHideFooterLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacRegisterForCloseOnTouchSession(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacRegisterForCloseOnTouchSession(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacDeregisterForCloseOnTouchSessionReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDeregisterForCloseOnTouchSessionReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterPrioEnableReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterPrioEnableReq(Courier::UInt32 const & aPrio);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterAllEnableReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterAllEnableReq();
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterDisableReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterDisableReq();
#ifdef CIT_SIMULATION
bool CallAction_gacProfileChange(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacProfileChange(Courier::UInt32 const & aProfile);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterPrioEnableReqForDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterPrioEnableReqForDisplay(Courier::UInt32 const & aPrio, Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterAllEnableReqForDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterAllEnableReqForDisplay(Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterDisableReqForDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterDisableReqForDisplay(Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacStartSceneTransitionAnimation(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacStartSceneTransitionAnimation(::Courier::ViewId const & aSourceView, ::Courier::ViewId const & aDestinationView, Courier::UInt32 const & aUserData1, Courier::Int8 const & aUserData2);
#ifdef CIT_SIMULATION
bool CallAction_gacDecrementActiveAnimationCount(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDecrementActiveAnimationCount();

// overall number of HierarchyNodes
static const ::FeatStd::UInt32 cGlobalDataItemHierarchyNodeCount = 60;
// overall number of DataItemDescriptor nodes
static const ::FeatStd::UInt32 cDataItemDescriptorCount = 60;
// overall number of BindingSources
static const ::FeatStd::UInt32 cBindingSourceCount = 27;
// maximum number of HierarchyNodes in a BindingSource
static const ::FeatStd::UInt32 cBindingSourceItemCountMax = 8;

// =========================================================================

class Application_List_IconURLDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 1;
    static const ::Courier::DataItemKey cDataItemKey = 25;

    typedef ::Application_List_IconURLData Data;

    Application_List_IconURLDataBindingSource();
};

typedef ::Courier::DataItemMsg< Application_List_IconURLDataBindingSource > Application_List_IconURLDataItemMsg;

// =========================================================================

class Application_ListSizeDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 2;
    static const ::Courier::DataItemKey cDataItemKey = 46;

    typedef ::Application_ListSizeData Data;

    Application_ListSizeDataBindingSource();
};

typedef ::Courier::DataItemMsg< Application_ListSizeDataBindingSource > Application_ListSizeDataItemMsg;

// =========================================================================

class Application_ListSelectedLineDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 3;
    static const ::Courier::DataItemKey cDataItemKey = 53;

    typedef ::Application_ListSelectedLineData Data;

    Application_ListSelectedLineDataBindingSource();
};

typedef ::Courier::DataItemMsg< Application_ListSelectedLineDataBindingSource > Application_ListSelectedLineDataItemMsg;

// =========================================================================

class Application_ListFocusIndexDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 4;
    static const ::Courier::DataItemKey cDataItemKey = 41;

    typedef ::Application_ListFocusIndexData Data;

    Application_ListFocusIndexDataBindingSource();
};

typedef ::Courier::DataItemMsg< Application_ListFocusIndexDataBindingSource > Application_ListFocusIndexDataItemMsg;

// =========================================================================

class Application_ListWindowSizeDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 5;
    static const ::Courier::DataItemKey cDataItemKey = 21;

    typedef ::Application_ListWindowSizeData Data;

    Application_ListWindowSizeDataBindingSource();
};

typedef ::Courier::DataItemMsg< Application_ListWindowSizeDataBindingSource > Application_ListWindowSizeDataItemMsg;

// =========================================================================

class Application_ListViewportSizeDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 6;
    static const ::Courier::DataItemKey cDataItemKey = 17;

    typedef ::Application_ListViewportSizeData Data;

    Application_ListViewportSizeDataBindingSource();
};

typedef ::Courier::DataItemMsg< Application_ListViewportSizeDataBindingSource > Application_ListViewportSizeDataItemMsg;

// =========================================================================

class SPIGadgetInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 8;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 7;
    static const ::Courier::DataItemKey cDataItemKey = 51;

    typedef ::SPIGadgetInfoData Data;

    SPIGadgetInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< SPIGadgetInfoDataBindingSource > SPIGadgetInfoDataItemMsg;

// =========================================================================

class Application_List_SceneHeaderDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 8;
    static const ::Courier::DataItemKey cDataItemKey = 40;

    typedef ::Application_List_SceneHeaderData Data;

    Application_List_SceneHeaderDataBindingSource();
};

typedef ::Courier::DataItemMsg< Application_List_SceneHeaderDataBindingSource > Application_List_SceneHeaderDataItemMsg;

// =========================================================================

class SIRIDeviceNameDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 9;
    static const ::Courier::DataItemKey cDataItemKey = 19;

    typedef ::SIRIDeviceNameData Data;

    SIRIDeviceNameDataBindingSource();
};

typedef ::Courier::DataItemMsg< SIRIDeviceNameDataBindingSource > SIRIDeviceNameDataItemMsg;

// =========================================================================

class SIRIIconSRStatusDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 10;
    static const ::Courier::DataItemKey cDataItemKey = 13;

    typedef ::SIRIIconSRStatusData Data;

    SIRIIconSRStatusDataBindingSource();
};

typedef ::Courier::DataItemMsg< SIRIIconSRStatusDataBindingSource > SIRIIconSRStatusDataItemMsg;

// =========================================================================

class SPI_PFO_Dev_SwitcherIndexDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 11;
    static const ::Courier::DataItemKey cDataItemKey = 18;

    typedef ::SPI_PFO_Dev_SwitcherIndexData Data;

    SPI_PFO_Dev_SwitcherIndexDataBindingSource();
};

typedef ::Courier::DataItemMsg< SPI_PFO_Dev_SwitcherIndexDataBindingSource > SPI_PFO_Dev_SwitcherIndexDataItemMsg;

// =========================================================================

class SPI_PFO_2ndDev_Conf_PopupDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 12;
    static const ::Courier::DataItemKey cDataItemKey = 15;

    typedef ::SPI_PFO_2ndDev_Conf_PopupData Data;

    SPI_PFO_2ndDev_Conf_PopupDataBindingSource();
};

typedef ::Courier::DataItemMsg< SPI_PFO_2ndDev_Conf_PopupDataBindingSource > SPI_PFO_2ndDev_Conf_PopupDataItemMsg;

// =========================================================================

class SPI_PFO_Message_SwitcherIndexDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 13;
    static const ::Courier::DataItemKey cDataItemKey = 47;

    typedef ::SPI_PFO_Message_SwitcherIndexData Data;

    SPI_PFO_Message_SwitcherIndexDataBindingSource();
};

typedef ::Courier::DataItemMsg< SPI_PFO_Message_SwitcherIndexDataBindingSource > SPI_PFO_Message_SwitcherIndexDataItemMsg;

// =========================================================================

class SPI_PFO_Message_MsgTextDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 14;
    static const ::Courier::DataItemKey cDataItemKey = 42;

    typedef ::SPI_PFO_Message_MsgTextData Data;

    SPI_PFO_Message_MsgTextDataBindingSource();
};

typedef ::Courier::DataItemMsg< SPI_PFO_Message_MsgTextDataBindingSource > SPI_PFO_Message_MsgTextDataItemMsg;

// =========================================================================

class Checkbox1DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 15;
    static const ::Courier::DataItemKey cDataItemKey = 12;

    typedef ::Checkbox1Data Data;

    Checkbox1DataBindingSource();
};

typedef ::Courier::DataItemMsg< Checkbox1DataBindingSource > Checkbox1DataItemMsg;

// =========================================================================

class Checkbox2DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 16;
    static const ::Courier::DataItemKey cDataItemKey = 58;

    typedef ::Checkbox2Data Data;

    Checkbox2DataBindingSource();
};

typedef ::Courier::DataItemMsg< Checkbox2DataBindingSource > Checkbox2DataItemMsg;

// =========================================================================

class Checkbox3DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 17;
    static const ::Courier::DataItemKey cDataItemKey = 16;

    typedef ::Checkbox3Data Data;

    Checkbox3DataBindingSource();
};

typedef ::Courier::DataItemMsg< Checkbox3DataBindingSource > Checkbox3DataItemMsg;

// =========================================================================

class CarPlay_TouchClickDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 18;
    static const ::Courier::DataItemKey cDataItemKey = 5;

    typedef ::CarPlay_TouchClickData Data;

    CarPlay_TouchClickDataBindingSource();
};

typedef ::Courier::DataItemMsg< CarPlay_TouchClickDataBindingSource > CarPlay_TouchClickDataItemMsg;

// =========================================================================

class ML_TouchClickDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 19;
    static const ::Courier::DataItemKey cDataItemKey = 3;

    typedef ::ML_TouchClickData Data;

    ML_TouchClickDataBindingSource();
};

typedef ::Courier::DataItemMsg< ML_TouchClickDataBindingSource > ML_TouchClickDataItemMsg;

// =========================================================================

class AAP_TouchClickDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 20;
    static const ::Courier::DataItemKey cDataItemKey = 4;

    typedef ::AAP_TouchClickData Data;

    AAP_TouchClickDataBindingSource();
};

typedef ::Courier::DataItemMsg< AAP_TouchClickDataBindingSource > AAP_TouchClickDataItemMsg;

// =========================================================================

class SpeedLock_TouchClickDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 21;
    static const ::Courier::DataItemKey cDataItemKey = 59;

    typedef ::SpeedLock_TouchClickData Data;

    SpeedLock_TouchClickDataBindingSource();
};

typedef ::Courier::DataItemMsg< SpeedLock_TouchClickDataBindingSource > SpeedLock_TouchClickDataItemMsg;

// =========================================================================

class UpdatePriorityModeDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 22;
    static const ::Courier::DataItemKey cDataItemKey = 56;

    typedef ::UpdatePriorityModeData Data;

    UpdatePriorityModeDataBindingSource();
};

typedef ::Courier::DataItemMsg< UpdatePriorityModeDataBindingSource > UpdatePriorityModeDataItemMsg;

// =========================================================================

class SelectedPriorityModeDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 23;
    static const ::Courier::DataItemKey cDataItemKey = 52;

    typedef ::SelectedPriorityModeData Data;

    SelectedPriorityModeDataBindingSource();
};

typedef ::Courier::DataItemMsg< SelectedPriorityModeDataBindingSource > SelectedPriorityModeDataItemMsg;

// =========================================================================

class ML_KDS_BindingDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 24;
    static const ::Courier::DataItemKey cDataItemKey = 7;

    typedef ::ML_KDS_BindingData Data;

    ML_KDS_BindingDataBindingSource();
};

typedef ::Courier::DataItemMsg< ML_KDS_BindingDataBindingSource > ML_KDS_BindingDataItemMsg;

// =========================================================================

class SPI_Disclaimer_SwitcherIndexDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 25;
    static const ::Courier::DataItemKey cDataItemKey = 32;

    typedef ::SPI_Disclaimer_SwitcherIndexData Data;

    SPI_Disclaimer_SwitcherIndexDataBindingSource();
};

typedef ::Courier::DataItemMsg< SPI_Disclaimer_SwitcherIndexDataBindingSource > SPI_Disclaimer_SwitcherIndexDataItemMsg;

// =========================================================================

class ListScrollBarInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 26;
    static const ::Courier::DataItemKey cDataItemKey = 14;

    typedef ::ListScrollBarInfoData Data;

    ListScrollBarInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< ListScrollBarInfoDataBindingSource > ListScrollBarInfoDataItemMsg;

namespace ItemKey {
        static const ::Courier::DataItemKey InvalidItem = 0;
        static const ::Courier::DataItemKey ML_TouchClickItem = 3;
        static const ::Courier::DataItemKey AAP_TouchClickItem = 4;
        static const ::Courier::DataItemKey CarPlay_TouchClickItem = 5;
        static const ::Courier::DataItemKey ML_KDS_BindingItem = 7;
        static const ::Courier::DataItemKey Checkbox1Item = 12;
        static const ::Courier::DataItemKey SIRIIconSRStatusItem = 13;
        static const ::Courier::DataItemKey ListScrollBarInfoItem = 14;
        static const ::Courier::DataItemKey SPI_PFO_2ndDev_Conf_PopupItem = 15;
        static const ::Courier::DataItemKey Checkbox3Item = 16;
        static const ::Courier::DataItemKey Application_ListViewportSizeItem = 17;
        static const ::Courier::DataItemKey SPI_PFO_Dev_SwitcherIndexItem = 18;
        static const ::Courier::DataItemKey SIRIDeviceNameItem = 19;
        static const ::Courier::DataItemKey Application_ListWindowSizeItem = 21;
        static const ::Courier::DataItemKey Application_List_IconURLItem = 25;
        static const ::Courier::DataItemKey SPI_Disclaimer_SwitcherIndexItem = 32;
        static const ::Courier::DataItemKey Application_List_SceneHeaderItem = 40;
        static const ::Courier::DataItemKey Application_ListFocusIndexItem = 41;
        static const ::Courier::DataItemKey SPI_PFO_Message_MsgTextItem = 42;
        static const ::Courier::DataItemKey Application_ListSizeItem = 46;
        static const ::Courier::DataItemKey SPI_PFO_Message_SwitcherIndexItem = 47;
        static const ::Courier::DataItemKey SPIGadgetInfoItem = 51;
        static const ::Courier::DataItemKey SelectedPriorityModeItem = 52;
        static const ::Courier::DataItemKey Application_ListSelectedLineItem = 53;
        static const ::Courier::DataItemKey UpdatePriorityModeItem = 56;
        static const ::Courier::DataItemKey Checkbox2Item = 58;
        static const ::Courier::DataItemKey SpeedLock_TouchClickItem = 59;

    namespace ML_TouchClick {
            static const ::Courier::DataItemKey isChecked_MLItem = 33;
    } // namespace ML_TouchClick

    namespace AAP_TouchClick {
            static const ::Courier::DataItemKey isChecked_AAPItem = 28;
    } // namespace AAP_TouchClick

    namespace CarPlay_TouchClick {
            static const ::Courier::DataItemKey isChecked_CarPlayItem = 49;
    } // namespace CarPlay_TouchClick

    namespace ML_KDS_Binding {
            static const ::Courier::DataItemKey isML_KDS_DisabledItem = 29;
    } // namespace ML_KDS_Binding

    namespace Checkbox1 {
            static const ::Courier::DataItemKey Checkbox1Item = 54;
    } // namespace Checkbox1

    namespace SIRIIconSRStatus {
            static const ::Courier::DataItemKey IconSRStatusItem = 50;
    } // namespace SIRIIconSRStatus

    namespace ListScrollBarInfo {
            static const ::Courier::DataItemKey EnabledItem = 48;
    } // namespace ListScrollBarInfo

    namespace SPI_PFO_2ndDev_Conf_Popup {
            static const ::Courier::DataItemKey Device1NameItem = 39;
    } // namespace SPI_PFO_2ndDev_Conf_Popup

    namespace Checkbox3 {
            static const ::Courier::DataItemKey Checkbox3Item = 43;
    } // namespace Checkbox3

    namespace Application_ListViewportSize {
            static const ::Courier::DataItemKey SizeOfViewPortItem = 36;
    } // namespace Application_ListViewportSize

    namespace SPI_PFO_Dev_SwitcherIndex {
            static const ::Courier::DataItemKey DevGroupIndexItem = 11;
    } // namespace SPI_PFO_Dev_SwitcherIndex

    namespace SIRIDeviceName {
            static const ::Courier::DataItemKey DeviceNameItem = 22;
    } // namespace SIRIDeviceName

    namespace Application_ListWindowSize {
            static const ::Courier::DataItemKey SizeOfWindowItem = 10;
    } // namespace Application_ListWindowSize

    namespace Application_List_IconURL {
            static const ::Courier::DataItemKey AppLisIconURLItem = 38;
    } // namespace Application_List_IconURL

    namespace SPI_Disclaimer_SwitcherIndex {
            static const ::Courier::DataItemKey MsgIndexItem = 45;
    } // namespace SPI_Disclaimer_SwitcherIndex

    namespace Application_List_SceneHeader {
            static const ::Courier::DataItemKey AppListHeader_PhoneNameItem = 57;
    } // namespace Application_List_SceneHeader

    namespace Application_ListFocusIndex {
            static const ::Courier::DataItemKey FocusedIndexItem = 8;
    } // namespace Application_ListFocusIndex

    namespace SPI_PFO_Message_MsgText {
            static const ::Courier::DataItemKey String1Item = 26;
            static const ::Courier::DataItemKey String2Item = 55;
    } // namespace SPI_PFO_Message_MsgText

    namespace Application_ListSize {
            static const ::Courier::DataItemKey Application_ListSizeItem = 23;
    } // namespace Application_ListSize

    namespace SPI_PFO_Message_SwitcherIndex {
            static const ::Courier::DataItemKey GroupIndexItem = 31;
    } // namespace SPI_PFO_Message_SwitcherIndex

    namespace SPIGadgetInfo {
            static const ::Courier::DataItemKey IsMySpinActiveItem = 27;
            static const ::Courier::DataItemKey IsCarPlayActiveItem = 35;
            static const ::Courier::DataItemKey IsAndroidAutoActiveItem = 37;
            static const ::Courier::DataItemKey IsDeviceConnectedItem = 24;
            static const ::Courier::DataItemKey IsDeviceDisonnectedItem = 30;
            static const ::Courier::DataItemKey HomeTileDeviceStatusTextItem = 44;
            static const ::Courier::DataItemKey DeviceConnectionItem = 1;
    } // namespace SPIGadgetInfo

    namespace SelectedPriorityMode {
            static const ::Courier::DataItemKey IsAAP_MLItem = 6;
    } // namespace SelectedPriorityMode

    namespace Application_ListSelectedLine {
            static const ::Courier::DataItemKey Application_SelectedItem = 34;
    } // namespace Application_ListSelectedLine

    namespace UpdatePriorityMode {
            static const ::Courier::DataItemKey SelectedAAP_MLItem = 2;
    } // namespace UpdatePriorityMode

    namespace Checkbox2 {
            static const ::Courier::DataItemKey Checkbox2Item = 20;
    } // namespace Checkbox2

    namespace SpeedLock_TouchClick {
            static const ::Courier::DataItemKey isChecked_SpeedLockItem = 9;
    } // namespace SpeedLock_TouchClick
} // namespace ItemKey

bool InitDataBinding();

#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
namespace FeatStd {
// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Application_List_IconURLDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Application_List_IconURLDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Application_ListSizeDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Application_ListSizeDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Application_ListSelectedLineDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Application_ListSelectedLineDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Application_ListFocusIndexDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Application_ListFocusIndexDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Application_ListWindowSizeDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Application_ListWindowSizeDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Application_ListViewportSizeDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Application_ListViewportSizeDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SPIGadgetInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SPIGadgetInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Application_List_SceneHeaderDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Application_List_SceneHeaderDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SIRIDeviceNameDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SIRIDeviceNameDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SIRIIconSRStatusDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SIRIIconSRStatusDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SPI_PFO_Dev_SwitcherIndexDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SPI_PFO_Dev_SwitcherIndexDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SPI_PFO_2ndDev_Conf_PopupDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SPI_PFO_2ndDev_Conf_PopupDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SPI_PFO_Message_SwitcherIndexDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SPI_PFO_Message_SwitcherIndexDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SPI_PFO_Message_MsgTextDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SPI_PFO_Message_MsgTextDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Checkbox1DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Checkbox1DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Checkbox2DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Checkbox2DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Checkbox3DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Checkbox3DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::CarPlay_TouchClickDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::CarPlay_TouchClickDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ML_TouchClickDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ML_TouchClickDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::AAP_TouchClickDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::AAP_TouchClickDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SpeedLock_TouchClickDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SpeedLock_TouchClickDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::UpdatePriorityModeDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::UpdatePriorityModeDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SelectedPriorityModeDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SelectedPriorityModeDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ML_KDS_BindingDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ML_KDS_BindingDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SPI_Disclaimer_SwitcherIndexDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SPI_Disclaimer_SwitcherIndexDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ListScrollBarInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ListScrollBarInfoDataBindingSource > const& dataItemContainer);
} // namespace FeatStd
#endif // FEATSTD_STRINGBUFFER_APPENDER_ENABLED
#endif // AppHmi_SPIStateMachine_h
