/************************************************************************
*FILE: AppHmi_SPIMessages.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(AppHmi_SPIMessages_h)
#define AppHmi_SPIMessages_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Courier/Messaging/Message.h>
#include <Courier/Platform/MessageFactory.h>
#include <ProjectBaseMsgs.h>
#include <ProjectBaseTypes.h>
#include <SPIDefines.h>
// ------------------------------------------------------------------------
class SwitchApplicationReq : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SwitchApplicationReq, ::NotifierMessage, 0x8943A2E6);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        SwitchApplicationReq(enApplicationId const & aApplicationID, enSurfaceId const & aSurfaceID);
        virtual ~SwitchApplicationReq();

        enApplicationId const & GetApplicationID() const { return mApplicationID; }
        void SetApplicationID(enApplicationId const & value) { mApplicationID = value; }
        enSurfaceId const & GetSurfaceID() const { return mSurfaceID; }
        void SetSurfaceID(enSurfaceId const & value) { mSurfaceID = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(SwitchApplicationReq);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSwitchApplicationReqMetaData;
        static ::Courier::Message::ModifiableMetadata mSwitchApplicationReqModifiableMetadata;
        static const ::Courier::ComponentId mSwitchApplicationReqSubscriberList[];

        enApplicationId mApplicationID;
        enSurfaceId mSurfaceID;
};

// ------------------------------------------------------------------------
class ViewSPIActivityId : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ViewSPIActivityId, ::NotifierMessage, 0xA29E2C5F);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        ViewSPIActivityId();
        virtual ~ViewSPIActivityId();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mViewSPIActivityIdMetaData;
        static ::Courier::Message::ModifiableMetadata mViewSPIActivityIdModifiableMetadata;
        static const ::Courier::ComponentId mViewSPIActivityIdSubscriberList[];
};

// ------------------------------------------------------------------------
class SwitchToHomeScreenReq : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SwitchToHomeScreenReq, ::NotifierMessage, 0xCA9021F9);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        SwitchToHomeScreenReq();
        virtual ~SwitchToHomeScreenReq();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSwitchToHomeScreenReqMetaData;
        static ::Courier::Message::ModifiableMetadata mSwitchToHomeScreenReqModifiableMetadata;
        static const ::Courier::ComponentId mSwitchToHomeScreenReqSubscriberList[];
};

// ------------------------------------------------------------------------
class LaunchMySpinAppMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(LaunchMySpinAppMsg, ::NotifierMessage, 0x0415F056);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        LaunchMySpinAppMsg();
        virtual ~LaunchMySpinAppMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mLaunchMySpinAppMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mLaunchMySpinAppMsgModifiableMetadata;
        static const ::Courier::ComponentId mLaunchMySpinAppMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class LaunchAAPorCPAppMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(LaunchAAPorCPAppMsg, ::NotifierMessage, 0xB92E9EBA);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        LaunchAAPorCPAppMsg();
        virtual ~LaunchAAPorCPAppMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mLaunchAAPorCPAppMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mLaunchAAPorCPAppMsgModifiableMetadata;
        static const ::Courier::ComponentId mLaunchAAPorCPAppMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class DeviceConnectionMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(DeviceConnectionMsg, ::NotifierMessage, 0x549971CD);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        DeviceConnectionMsg();
        virtual ~DeviceConnectionMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mDeviceConnectionMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mDeviceConnectionMsgModifiableMetadata;
        static const ::Courier::ComponentId mDeviceConnectionMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class SPIEntryMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SPIEntryMsg, ::NotifierMessage, 0xC8D493E9);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        SPIEntryMsg();
        virtual ~SPIEntryMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSPIEntryMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mSPIEntryMsgModifiableMetadata;
        static const ::Courier::ComponentId mSPIEntryMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class SPIView_mySPIN_AppView : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SPIView_mySPIN_AppView, ::NotifierMessage, 0x0ADCEA4E);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        SPIView_mySPIN_AppView();
        virtual ~SPIView_mySPIN_AppView();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSPIView_mySPIN_AppViewMetaData;
        static ::Courier::Message::ModifiableMetadata mSPIView_mySPIN_AppViewModifiableMetadata;
        static const ::Courier::ComponentId mSPIView_mySPIN_AppViewSubscriberList[];
};

// ------------------------------------------------------------------------
class SPIView_AAPorCP_AppView : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SPIView_AAPorCP_AppView, ::NotifierMessage, 0x1C2A8495);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        SPIView_AAPorCP_AppView();
        virtual ~SPIView_AAPorCP_AppView();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSPIView_AAPorCP_AppViewMetaData;
        static ::Courier::Message::ModifiableMetadata mSPIView_AAPorCP_AppViewModifiableMetadata;
        static const ::Courier::ComponentId mSPIView_AAPorCP_AppViewSubscriberList[];
};

// ------------------------------------------------------------------------
class SPIView_Phone_not_connected : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SPIView_Phone_not_connected, ::NotifierMessage, 0x006044A9);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        SPIView_Phone_not_connected();
        virtual ~SPIView_Phone_not_connected();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSPIView_Phone_not_connectedMetaData;
        static ::Courier::Message::ModifiableMetadata mSPIView_Phone_not_connectedModifiableMetadata;
        static const ::Courier::ComponentId mSPIView_Phone_not_connectedSubscriberList[];
};

// ------------------------------------------------------------------------
class SwitchToSPIHomeReq : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SwitchToSPIHomeReq, ::NotifierMessage, 0x63A25CB2);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        SwitchToSPIHomeReq();
        virtual ~SwitchToSPIHomeReq();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSwitchToSPIHomeReqMetaData;
        static ::Courier::Message::ModifiableMetadata mSwitchToSPIHomeReqModifiableMetadata;
        static const ::Courier::ComponentId mSwitchToSPIHomeReqSubscriberList[];
};

// ------------------------------------------------------------------------
class ApplicationListMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ApplicationListMsg, ::NotifierMessage, 0x89315165);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ApplicationListMsg(Candera::UInt16 const & aListSize);
        virtual ~ApplicationListMsg();

        Candera::UInt16 const & GetListSize() const { return mListSize; }
        void SetListSize(Candera::UInt16 const & value) { mListSize = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ApplicationListMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mApplicationListMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mApplicationListMsgModifiableMetadata;
        static const ::Courier::ComponentId mApplicationListMsgSubscriberList[];

        Candera::UInt16 mListSize;
};

// ------------------------------------------------------------------------
class UpdateAppListHeaderMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(UpdateAppListHeaderMsg, ::NotifierMessage, 0xB4A9E96A);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        UpdateAppListHeaderMsg(Candera::String const & aAppListHeader_PhoneName);
        virtual ~UpdateAppListHeaderMsg();

        Candera::String const & GetAppListHeader_PhoneName() const { return mAppListHeader_PhoneName; }
        void SetAppListHeader_PhoneName(Candera::String const & value) { mAppListHeader_PhoneName = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(UpdateAppListHeaderMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mUpdateAppListHeaderMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mUpdateAppListHeaderMsgModifiableMetadata;
        static const ::Courier::ComponentId mUpdateAppListHeaderMsgSubscriberList[];

        Candera::String mAppListHeader_PhoneName;
};

// ------------------------------------------------------------------------
class UpdateVehicleBreakStatusMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(UpdateVehicleBreakStatusMsg, ::NotifierMessage, 0xAC23E802);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        UpdateVehicleBreakStatusMsg(bool const & aVehicleBreakStatus);
        virtual ~UpdateVehicleBreakStatusMsg();

        bool const & GetVehicleBreakStatus() const { return mVehicleBreakStatus; }
        void SetVehicleBreakStatus(bool const & value) { mVehicleBreakStatus = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(UpdateVehicleBreakStatusMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mUpdateVehicleBreakStatusMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mUpdateVehicleBreakStatusMsgModifiableMetadata;
        static const ::Courier::ComponentId mUpdateVehicleBreakStatusMsgSubscriberList[];

        bool mVehicleBreakStatus;
};

// ------------------------------------------------------------------------
class UpdateFGAppLaunchableStatusMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(UpdateFGAppLaunchableStatusMsg, ::NotifierMessage, 0x121A0D2D);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        UpdateFGAppLaunchableStatusMsg(bool const & aFGAppLaunchableStatus);
        virtual ~UpdateFGAppLaunchableStatusMsg();

        bool const & GetFGAppLaunchableStatus() const { return mFGAppLaunchableStatus; }
        void SetFGAppLaunchableStatus(bool const & value) { mFGAppLaunchableStatus = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(UpdateFGAppLaunchableStatusMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mUpdateFGAppLaunchableStatusMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mUpdateFGAppLaunchableStatusMsgModifiableMetadata;
        static const ::Courier::ComponentId mUpdateFGAppLaunchableStatusMsgSubscriberList[];

        bool mFGAppLaunchableStatus;
};

// ------------------------------------------------------------------------
class UpdateSessionInactiveStatusMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(UpdateSessionInactiveStatusMsg, ::NotifierMessage, 0x09FCB4DF);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        UpdateSessionInactiveStatusMsg(Candera::UInt32 const & aSessionInactiveStatus);
        virtual ~UpdateSessionInactiveStatusMsg();

        Candera::UInt32 const & GetSessionInactiveStatus() const { return mSessionInactiveStatus; }
        void SetSessionInactiveStatus(Candera::UInt32 const & value) { mSessionInactiveStatus = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(UpdateSessionInactiveStatusMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mUpdateSessionInactiveStatusMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mUpdateSessionInactiveStatusMsgModifiableMetadata;
        static const ::Courier::ComponentId mUpdateSessionInactiveStatusMsgSubscriberList[];

        Candera::UInt32 mSessionInactiveStatus;
};

// ------------------------------------------------------------------------
class ShowMirrorLinkView : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ShowMirrorLinkView, ::NotifierMessage, 0xDAD53F18);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ShowMirrorLinkView();
        virtual ~ShowMirrorLinkView();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mShowMirrorLinkViewMetaData;
        static ::Courier::Message::ModifiableMetadata mShowMirrorLinkViewModifiableMetadata;
        static const ::Courier::ComponentId mShowMirrorLinkViewSubscriberList[];
};

// ------------------------------------------------------------------------
class ShowApplicationListView : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ShowApplicationListView, ::NotifierMessage, 0x8B619E6E);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ShowApplicationListView();
        virtual ~ShowApplicationListView();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mShowApplicationListViewMetaData;
        static ::Courier::Message::ModifiableMetadata mShowApplicationListViewModifiableMetadata;
        static const ::Courier::ComponentId mShowApplicationListViewSubscriberList[];
};

// ------------------------------------------------------------------------
class ShowSPIOptionView : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ShowSPIOptionView, ::NotifierMessage, 0x03D82442);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ShowSPIOptionView();
        virtual ~ShowSPIOptionView();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mShowSPIOptionViewMetaData;
        static ::Courier::Message::ModifiableMetadata mShowSPIOptionViewModifiableMetadata;
        static const ::Courier::ComponentId mShowSPIOptionViewSubscriberList[];
};

// ------------------------------------------------------------------------
class HideSPIOptionView : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(HideSPIOptionView, ::NotifierMessage, 0x1018F03D);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        HideSPIOptionView();
        virtual ~HideSPIOptionView();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mHideSPIOptionViewMetaData;
        static ::Courier::Message::ModifiableMetadata mHideSPIOptionViewModifiableMetadata;
        static const ::Courier::ComponentId mHideSPIOptionViewSubscriberList[];
};

// ------------------------------------------------------------------------
class LaunchApplicationReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(LaunchApplicationReqMsg, ::NotifierMessage, 0xEB5D11A8);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        LaunchApplicationReqMsg(Candera::UInt16 const & aApplicationIndex);
        virtual ~LaunchApplicationReqMsg();

        Candera::UInt16 const & GetApplicationIndex() const { return mApplicationIndex; }
        void SetApplicationIndex(Candera::UInt16 const & value) { mApplicationIndex = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(LaunchApplicationReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mLaunchApplicationReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mLaunchApplicationReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mLaunchApplicationReqMsgSubscriberList[];

        Candera::UInt16 mApplicationIndex;
};

// ------------------------------------------------------------------------
class UpdateDeviceCategoryMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(UpdateDeviceCategoryMsg, ::NotifierMessage, 0xAB65B5EA);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        UpdateDeviceCategoryMsg(Candera::UInt32 const & aDeviceCategory);
        virtual ~UpdateDeviceCategoryMsg();

        Candera::UInt32 const & GetDeviceCategory() const { return mDeviceCategory; }
        void SetDeviceCategory(Candera::UInt32 const & value) { mDeviceCategory = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(UpdateDeviceCategoryMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mUpdateDeviceCategoryMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mUpdateDeviceCategoryMsgModifiableMetadata;
        static const ::Courier::ComponentId mUpdateDeviceCategoryMsgSubscriberList[];

        Candera::UInt32 mDeviceCategory;
};

// ------------------------------------------------------------------------
class HidePopupRequestMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(HidePopupRequestMsg, ::NotifierMessage, 0x298356CF);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        HidePopupRequestMsg(Candera::UInt32 const & aPopupID);
        virtual ~HidePopupRequestMsg();

        Candera::UInt32 const & GetPopupID() const { return mPopupID; }
        void SetPopupID(Candera::UInt32 const & value) { mPopupID = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(HidePopupRequestMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mHidePopupRequestMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mHidePopupRequestMsgModifiableMetadata;
        static const ::Courier::ComponentId mHidePopupRequestMsgSubscriberList[];

        Candera::UInt32 mPopupID;
};

// ------------------------------------------------------------------------
class SPIPopupActionMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SPIPopupActionMsg, ::NotifierMessage, 0xA10EF819);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        SPIPopupActionMsg();
        virtual ~SPIPopupActionMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSPIPopupActionMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mSPIPopupActionMsgModifiableMetadata;
        static const ::Courier::ComponentId mSPIPopupActionMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class GoToHomeScreenMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(GoToHomeScreenMsg, ::NotifierMessage, 0x5C94C7A8);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        GoToHomeScreenMsg();
        virtual ~GoToHomeScreenMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mGoToHomeScreenMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mGoToHomeScreenMsgModifiableMetadata;
        static const ::Courier::ComponentId mGoToHomeScreenMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class LaunchPhoneAppMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(LaunchPhoneAppMsg, ::NotifierMessage, 0xFB3E2636);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        LaunchPhoneAppMsg();
        virtual ~LaunchPhoneAppMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mLaunchPhoneAppMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mLaunchPhoneAppMsgModifiableMetadata;
        static const ::Courier::ComponentId mLaunchPhoneAppMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class LaunchNaviAppMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(LaunchNaviAppMsg, ::NotifierMessage, 0x7B1E39D1);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        LaunchNaviAppMsg();
        virtual ~LaunchNaviAppMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mLaunchNaviAppMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mLaunchNaviAppMsgModifiableMetadata;
        static const ::Courier::ComponentId mLaunchNaviAppMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class LaunchMediaAppMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(LaunchMediaAppMsg, ::NotifierMessage, 0xA26AE90F);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        LaunchMediaAppMsg();
        virtual ~LaunchMediaAppMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mLaunchMediaAppMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mLaunchMediaAppMsgModifiableMetadata;
        static const ::Courier::ComponentId mLaunchMediaAppMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class GetApplicationListMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(GetApplicationListMsg, ::NotifierMessage, 0xD36F60BE);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        GetApplicationListMsg();
        virtual ~GetApplicationListMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mGetApplicationListMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mGetApplicationListMsgModifiableMetadata;
        static const ::Courier::ComponentId mGetApplicationListMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class InitForDipoMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(InitForDipoMsg, ::NotifierMessage, 0xE8DC77BB);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        InitForDipoMsg();
        virtual ~InitForDipoMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mInitForDipoMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mInitForDipoMsgModifiableMetadata;
        static const ::Courier::ComponentId mInitForDipoMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class InitForMirrorLinkMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(InitForMirrorLinkMsg, ::NotifierMessage, 0xACA6C8AF);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        InitForMirrorLinkMsg();
        virtual ~InitForMirrorLinkMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mInitForMirrorLinkMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mInitForMirrorLinkMsgModifiableMetadata;
        static const ::Courier::ComponentId mInitForMirrorLinkMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class LaunchLastApplicationMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(LaunchLastApplicationMsg, ::NotifierMessage, 0xC65C1AF5);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        LaunchLastApplicationMsg();
        virtual ~LaunchLastApplicationMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mLaunchLastApplicationMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mLaunchLastApplicationMsgModifiableMetadata;
        static const ::Courier::ComponentId mLaunchLastApplicationMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class BackToActiveSessionMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(BackToActiveSessionMsg, ::NotifierMessage, 0xB81A6E02);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        BackToActiveSessionMsg();
        virtual ~BackToActiveSessionMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mBackToActiveSessionMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mBackToActiveSessionMsgModifiableMetadata;
        static const ::Courier::ComponentId mBackToActiveSessionMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class RevertMirrorLinkViewMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(RevertMirrorLinkViewMsg, ::NotifierMessage, 0x950D7613);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        RevertMirrorLinkViewMsg();
        virtual ~RevertMirrorLinkViewMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mRevertMirrorLinkViewMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mRevertMirrorLinkViewMsgModifiableMetadata;
        static const ::Courier::ComponentId mRevertMirrorLinkViewMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class SPI_BT_Pairing_Popup : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SPI_BT_Pairing_Popup, ::NotifierMessage, 0xD2569646);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        SPI_BT_Pairing_Popup();
        virtual ~SPI_BT_Pairing_Popup();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSPI_BT_Pairing_PopupMetaData;
        static ::Courier::Message::ModifiableMetadata mSPI_BT_Pairing_PopupModifiableMetadata;
        static const ::Courier::ComponentId mSPI_BT_Pairing_PopupSubscriberList[];
};

// ------------------------------------------------------------------------
class SPI_BT_Pairing_Popup_Close : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SPI_BT_Pairing_Popup_Close, ::NotifierMessage, 0x63ED7BC5);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        SPI_BT_Pairing_Popup_Close();
        virtual ~SPI_BT_Pairing_Popup_Close();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSPI_BT_Pairing_Popup_CloseMetaData;
        static ::Courier::Message::ModifiableMetadata mSPI_BT_Pairing_Popup_CloseModifiableMetadata;
        static const ::Courier::ComponentId mSPI_BT_Pairing_Popup_CloseSubscriberList[];
};

// ------------------------------------------------------------------------
class SPI_FirstDeviceConnection : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SPI_FirstDeviceConnection, ::NotifierMessage, 0xF64944D5);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        SPI_FirstDeviceConnection();
        virtual ~SPI_FirstDeviceConnection();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSPI_FirstDeviceConnectionMetaData;
        static ::Courier::Message::ModifiableMetadata mSPI_FirstDeviceConnectionModifiableMetadata;
        static const ::Courier::ComponentId mSPI_FirstDeviceConnectionSubscriberList[];
};

// ------------------------------------------------------------------------
class SPI_FirstDeviceConnection_Close : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SPI_FirstDeviceConnection_Close, ::NotifierMessage, 0x22CEC856);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        SPI_FirstDeviceConnection_Close();
        virtual ~SPI_FirstDeviceConnection_Close();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSPI_FirstDeviceConnection_CloseMetaData;
        static ::Courier::Message::ModifiableMetadata mSPI_FirstDeviceConnection_CloseModifiableMetadata;
        static const ::Courier::ComponentId mSPI_FirstDeviceConnection_CloseSubscriberList[];
};

// ------------------------------------------------------------------------
class SPI_ParkedCondition_Popup : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SPI_ParkedCondition_Popup, ::NotifierMessage, 0x6C919D96);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        SPI_ParkedCondition_Popup();
        virtual ~SPI_ParkedCondition_Popup();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSPI_ParkedCondition_PopupMetaData;
        static ::Courier::Message::ModifiableMetadata mSPI_ParkedCondition_PopupModifiableMetadata;
        static const ::Courier::ComponentId mSPI_ParkedCondition_PopupSubscriberList[];
};

// ------------------------------------------------------------------------
class SPI_SPI_ParkedCondition_Popup_Close : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SPI_SPI_ParkedCondition_Popup_Close, ::NotifierMessage, 0x4F1B4451);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        SPI_SPI_ParkedCondition_Popup_Close();
        virtual ~SPI_SPI_ParkedCondition_Popup_Close();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSPI_SPI_ParkedCondition_Popup_CloseMetaData;
        static ::Courier::Message::ModifiableMetadata mSPI_SPI_ParkedCondition_Popup_CloseModifiableMetadata;
        static const ::Courier::ComponentId mSPI_SPI_ParkedCondition_Popup_CloseSubscriberList[];
};

// ------------------------------------------------------------------------
class SPI_Retry_Popup : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SPI_Retry_Popup, ::NotifierMessage, 0x267974D7);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        SPI_Retry_Popup();
        virtual ~SPI_Retry_Popup();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSPI_Retry_PopupMetaData;
        static ::Courier::Message::ModifiableMetadata mSPI_Retry_PopupModifiableMetadata;
        static const ::Courier::ComponentId mSPI_Retry_PopupSubscriberList[];
};

// ------------------------------------------------------------------------
class SPI_Retry_Popup_Close : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SPI_Retry_Popup_Close, ::NotifierMessage, 0x45071742);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        SPI_Retry_Popup_Close();
        virtual ~SPI_Retry_Popup_Close();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSPI_Retry_Popup_CloseMetaData;
        static ::Courier::Message::ModifiableMetadata mSPI_Retry_Popup_CloseModifiableMetadata;
        static const ::Courier::ComponentId mSPI_Retry_Popup_CloseSubscriberList[];
};

// ------------------------------------------------------------------------
class StartedActiveSessionMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(StartedActiveSessionMsg, ::NotifierMessage, 0x9CDC49D2);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        StartedActiveSessionMsg();
        virtual ~StartedActiveSessionMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mStartedActiveSessionMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mStartedActiveSessionMsgModifiableMetadata;
        static const ::Courier::ComponentId mStartedActiveSessionMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class UpdateDeviceDisconnectionStatusMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(UpdateDeviceDisconnectionStatusMsg, ::NotifierMessage, 0x4F2C898E);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        UpdateDeviceDisconnectionStatusMsg(bool const & aActiveSessionCheck);
        virtual ~UpdateDeviceDisconnectionStatusMsg();

        bool const & GetActiveSessionCheck() const { return mActiveSessionCheck; }
        void SetActiveSessionCheck(bool const & value) { mActiveSessionCheck = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(UpdateDeviceDisconnectionStatusMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mUpdateDeviceDisconnectionStatusMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mUpdateDeviceDisconnectionStatusMsgModifiableMetadata;
        static const ::Courier::ComponentId mUpdateDeviceDisconnectionStatusMsgSubscriberList[];

        bool mActiveSessionCheck;
};

// ------------------------------------------------------------------------
class MarkLastActiveStateAppListMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(MarkLastActiveStateAppListMsg, ::NotifierMessage, 0xCDCA9A7F);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        MarkLastActiveStateAppListMsg();
        virtual ~MarkLastActiveStateAppListMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mMarkLastActiveStateAppListMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mMarkLastActiveStateAppListMsgModifiableMetadata;
        static const ::Courier::ComponentId mMarkLastActiveStateAppListMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class MarkLastActiveStateFullScreenMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(MarkLastActiveStateFullScreenMsg, ::NotifierMessage, 0x7BFB40B3);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        MarkLastActiveStateFullScreenMsg();
        virtual ~MarkLastActiveStateFullScreenMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mMarkLastActiveStateFullScreenMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mMarkLastActiveStateFullScreenMsgModifiableMetadata;
        static const ::Courier::ComponentId mMarkLastActiveStateFullScreenMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class ApplicationFGActionMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ApplicationFGActionMsg, ::NotifierMessage, 0x25FFA83F);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ApplicationFGActionMsg();
        virtual ~ApplicationFGActionMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mApplicationFGActionMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mApplicationFGActionMsgModifiableMetadata;
        static const ::Courier::ComponentId mApplicationFGActionMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class ApplicationBGActionMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ApplicationBGActionMsg, ::NotifierMessage, 0x53CBCE18);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ApplicationBGActionMsg();
        virtual ~ApplicationBGActionMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mApplicationBGActionMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mApplicationBGActionMsgModifiableMetadata;
        static const ::Courier::ComponentId mApplicationBGActionMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class SPIApplicationTestMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SPIApplicationTestMsg, ::NotifierMessage, 0x9ACA9ED5);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        SPIApplicationTestMsg();
        virtual ~SPIApplicationTestMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSPIApplicationTestMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mSPIApplicationTestMsgModifiableMetadata;
        static const ::Courier::ComponentId mSPIApplicationTestMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class BTSRSessionStartAppReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(BTSRSessionStartAppReqMsg, ::NotifierMessage, 0x9BDCFDC1);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        BTSRSessionStartAppReqMsg();
        virtual ~BTSRSessionStartAppReqMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mBTSRSessionStartAppReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mBTSRSessionStartAppReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mBTSRSessionStartAppReqMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class BTSRSessionStopAppReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(BTSRSessionStopAppReqMsg, ::NotifierMessage, 0x0F6441FC);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        BTSRSessionStopAppReqMsg();
        virtual ~BTSRSessionStopAppReqMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mBTSRSessionStopAppReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mBTSRSessionStopAppReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mBTSRSessionStopAppReqMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class SiriSessionActiveAppMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SiriSessionActiveAppMsg, ::NotifierMessage, 0x6F1678E0);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        SiriSessionActiveAppMsg(Courier::Int8 const & aStatus, Courier::Int8 const & aSupported);
        virtual ~SiriSessionActiveAppMsg();

        Courier::Int8 const & GetStatus() const { return mStatus; }
        void SetStatus(Courier::Int8 const & value) { mStatus = value; }
        Courier::Int8 const & GetSupported() const { return mSupported; }
        void SetSupported(Courier::Int8 const & value) { mSupported = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(SiriSessionActiveAppMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSiriSessionActiveAppMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mSiriSessionActiveAppMsgModifiableMetadata;
        static const ::Courier::ComponentId mSiriSessionActiveAppMsgSubscriberList[];

        Courier::Int8 mStatus;
        Courier::Int8 mSupported;
};

// ------------------------------------------------------------------------
class EnableView : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(EnableView, ::NotifierMessage, 0x8BBD0734);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        EnableView(::Courier::ViewId const & aViewName);
        virtual ~EnableView();

        ::Courier::ViewId const & GetViewName() const { return mViewName; }
        void SetViewName(::Courier::ViewId const & value) { mViewName = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(EnableView);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mEnableViewMetaData;
        static ::Courier::Message::ModifiableMetadata mEnableViewModifiableMetadata;
        static const ::Courier::ComponentId mEnableViewSubscriberList[];

        ::Courier::ViewId mViewName;
};

// ------------------------------------------------------------------------
class DisableView : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(DisableView, ::NotifierMessage, 0x8D4DB5D8);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        DisableView(::Courier::ViewId const & aViewName);
        virtual ~DisableView();

        ::Courier::ViewId const & GetViewName() const { return mViewName; }
        void SetViewName(::Courier::ViewId const & value) { mViewName = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(DisableView);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mDisableViewMetaData;
        static ::Courier::Message::ModifiableMetadata mDisableViewModifiableMetadata;
        static const ::Courier::ComponentId mDisableViewSubscriberList[];

        ::Courier::ViewId mViewName;
};

// ------------------------------------------------------------------------
class SiriOnExitMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SiriOnExitMsg, ::NotifierMessage, 0xF81CBE96);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        SiriOnExitMsg();
        virtual ~SiriOnExitMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSiriOnExitMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mSiriOnExitMsgModifiableMetadata;
        static const ::Courier::ComponentId mSiriOnExitMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class SRIconStatusMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SRIconStatusMsg, ::NotifierMessage, 0xDE858ABA);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        SRIconStatusMsg(bool const & aSRIconStatus);
        virtual ~SRIconStatusMsg();

        bool const & GetSRIconStatus() const { return mSRIconStatus; }
        void SetSRIconStatus(bool const & value) { mSRIconStatus = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(SRIconStatusMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSRIconStatusMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mSRIconStatusMsgModifiableMetadata;
        static const ::Courier::ComponentId mSRIconStatusMsgSubscriberList[];

        bool mSRIconStatus;
};

// ------------------------------------------------------------------------
class DeviceNameLogic : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(DeviceNameLogic, ::NotifierMessage, 0x82C0957A);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        DeviceNameLogic(Candera::String const & aBTDeviceName);
        virtual ~DeviceNameLogic();

        Candera::String const & GetBTDeviceName() const { return mBTDeviceName; }
        void SetBTDeviceName(Candera::String const & value) { mBTDeviceName = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(DeviceNameLogic);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mDeviceNameLogicMetaData;
        static ::Courier::Message::ModifiableMetadata mDeviceNameLogicModifiableMetadata;
        static const ::Courier::ComponentId mDeviceNameLogicSubscriberList[];

        Candera::String mBTDeviceName;
};

// ------------------------------------------------------------------------
class CarPlay_Checkbox_Touch : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(CarPlay_Checkbox_Touch, ::NotifierMessage, 0x6F35F660);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        CarPlay_Checkbox_Touch(bool const & aIsCarPlay_Checkbox_Touch);
        virtual ~CarPlay_Checkbox_Touch();

        bool const & GetIsCarPlay_Checkbox_Touch() const { return mIsCarPlay_Checkbox_Touch; }
        void SetIsCarPlay_Checkbox_Touch(bool const & value) { mIsCarPlay_Checkbox_Touch = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(CarPlay_Checkbox_Touch);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mCarPlay_Checkbox_TouchMetaData;
        static ::Courier::Message::ModifiableMetadata mCarPlay_Checkbox_TouchModifiableMetadata;
        static const ::Courier::ComponentId mCarPlay_Checkbox_TouchSubscriberList[];

        bool mIsCarPlay_Checkbox_Touch;
};

// ------------------------------------------------------------------------
class ML_Checkbox_Touch : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ML_Checkbox_Touch, ::NotifierMessage, 0x5F0CA6C6);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ML_Checkbox_Touch(bool const & aIsML_Checkbox_Touch);
        virtual ~ML_Checkbox_Touch();

        bool const & GetIsML_Checkbox_Touch() const { return mIsML_Checkbox_Touch; }
        void SetIsML_Checkbox_Touch(bool const & value) { mIsML_Checkbox_Touch = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ML_Checkbox_Touch);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mML_Checkbox_TouchMetaData;
        static ::Courier::Message::ModifiableMetadata mML_Checkbox_TouchModifiableMetadata;
        static const ::Courier::ComponentId mML_Checkbox_TouchSubscriberList[];

        bool mIsML_Checkbox_Touch;
};

// ------------------------------------------------------------------------
class AAP_Checkbox_Touch : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(AAP_Checkbox_Touch, ::NotifierMessage, 0xDB941319);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        AAP_Checkbox_Touch(bool const & aIsAAP_Checkbox_Touch);
        virtual ~AAP_Checkbox_Touch();

        bool const & GetIsAAP_Checkbox_Touch() const { return mIsAAP_Checkbox_Touch; }
        void SetIsAAP_Checkbox_Touch(bool const & value) { mIsAAP_Checkbox_Touch = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(AAP_Checkbox_Touch);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mAAP_Checkbox_TouchMetaData;
        static ::Courier::Message::ModifiableMetadata mAAP_Checkbox_TouchModifiableMetadata;
        static const ::Courier::ComponentId mAAP_Checkbox_TouchSubscriberList[];

        bool mIsAAP_Checkbox_Touch;
};

// ------------------------------------------------------------------------
class SpeedLock_Checkbox_Touch : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SpeedLock_Checkbox_Touch, ::NotifierMessage, 0xA913E8D0);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        SpeedLock_Checkbox_Touch(bool const & aIsSL_Checkbox_Touch);
        virtual ~SpeedLock_Checkbox_Touch();

        bool const & GetIsSL_Checkbox_Touch() const { return mIsSL_Checkbox_Touch; }
        void SetIsSL_Checkbox_Touch(bool const & value) { mIsSL_Checkbox_Touch = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(SpeedLock_Checkbox_Touch);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSpeedLock_Checkbox_TouchMetaData;
        static ::Courier::Message::ModifiableMetadata mSpeedLock_Checkbox_TouchModifiableMetadata;
        static const ::Courier::ComponentId mSpeedLock_Checkbox_TouchSubscriberList[];

        bool mIsSL_Checkbox_Touch;
};

// ------------------------------------------------------------------------
class UpdateS_OPTView : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(UpdateS_OPTView, ::NotifierMessage, 0x215B58AC);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        UpdateS_OPTView(Candera::UInt8 const & aCarPlayOption, Candera::UInt8 const & aMLOption, Candera::UInt8 const & aAAPOption);
        virtual ~UpdateS_OPTView();

        Candera::UInt8 const & GetCarPlayOption() const { return mCarPlayOption; }
        void SetCarPlayOption(Candera::UInt8 const & value) { mCarPlayOption = value; }
        Candera::UInt8 const & GetMLOption() const { return mMLOption; }
        void SetMLOption(Candera::UInt8 const & value) { mMLOption = value; }
        Candera::UInt8 const & GetAAPOption() const { return mAAPOption; }
        void SetAAPOption(Candera::UInt8 const & value) { mAAPOption = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(UpdateS_OPTView);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mUpdateS_OPTViewMetaData;
        static ::Courier::Message::ModifiableMetadata mUpdateS_OPTViewModifiableMetadata;
        static const ::Courier::ComponentId mUpdateS_OPTViewSubscriberList[];

        Candera::UInt8 mCarPlayOption;
        Candera::UInt8 mMLOption;
        Candera::UInt8 mAAPOption;
};

// ------------------------------------------------------------------------
class UpdateSL_CheckBox : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(UpdateSL_CheckBox, ::NotifierMessage, 0xA682928E);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        UpdateSL_CheckBox(Candera::UInt8 const & aSpeedLockOption);
        virtual ~UpdateSL_CheckBox();

        Candera::UInt8 const & GetSpeedLockOption() const { return mSpeedLockOption; }
        void SetSpeedLockOption(Candera::UInt8 const & value) { mSpeedLockOption = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(UpdateSL_CheckBox);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mUpdateSL_CheckBoxMetaData;
        static ::Courier::Message::ModifiableMetadata mUpdateSL_CheckBoxModifiableMetadata;
        static const ::Courier::ComponentId mUpdateSL_CheckBoxSubscriberList[];

        Candera::UInt8 mSpeedLockOption;
};

// ------------------------------------------------------------------------
class AAP_MLModePL_Msg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(AAP_MLModePL_Msg, ::NotifierMessage, 0xB7B96678);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        AAP_MLModePL_Msg(Courier::UInt8 const & aSetModeAAP_ML_PL);
        virtual ~AAP_MLModePL_Msg();

        Courier::UInt8 const & GetSetModeAAP_ML_PL() const { return mSetModeAAP_ML_PL; }
        void SetSetModeAAP_ML_PL(Courier::UInt8 const & value) { mSetModeAAP_ML_PL = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(AAP_MLModePL_Msg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mAAP_MLModePL_MsgMetaData;
        static ::Courier::Message::ModifiableMetadata mAAP_MLModePL_MsgModifiableMetadata;
        static const ::Courier::ComponentId mAAP_MLModePL_MsgSubscriberList[];

        Courier::UInt8 mSetModeAAP_ML_PL;
};

// ------------------------------------------------------------------------
class UpdateAAP_MLModeResp : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(UpdateAAP_MLModeResp, ::NotifierMessage, 0x221BB7B6);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        UpdateAAP_MLModeResp(Courier::UInt8 const & aUpdated_AAP_MLMode);
        virtual ~UpdateAAP_MLModeResp();

        Courier::UInt8 const & GetUpdated_AAP_MLMode() const { return mUpdated_AAP_MLMode; }
        void SetUpdated_AAP_MLMode(Courier::UInt8 const & value) { mUpdated_AAP_MLMode = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(UpdateAAP_MLModeResp);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mUpdateAAP_MLModeRespMetaData;
        static ::Courier::Message::ModifiableMetadata mUpdateAAP_MLModeRespModifiableMetadata;
        static const ::Courier::ComponentId mUpdateAAP_MLModeRespSubscriberList[];

        Courier::UInt8 mUpdated_AAP_MLMode;
};

// ------------------------------------------------------------------------
class Update_ML_KDSConfig : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(Update_ML_KDSConfig, ::NotifierMessage, 0x8205B9CD);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        Update_ML_KDSConfig(Courier::UInt8 const & aUpdateML_KDS);
        virtual ~Update_ML_KDSConfig();

        Courier::UInt8 const & GetUpdateML_KDS() const { return mUpdateML_KDS; }
        void SetUpdateML_KDS(Courier::UInt8 const & value) { mUpdateML_KDS = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(Update_ML_KDSConfig);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mUpdate_ML_KDSConfigMetaData;
        static ::Courier::Message::ModifiableMetadata mUpdate_ML_KDSConfigModifiableMetadata;
        static const ::Courier::ComponentId mUpdate_ML_KDSConfigSubscriberList[];

        Courier::UInt8 mUpdateML_KDS;
};

// ------------------------------------------------------------------------
class EnableBTPopupView : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(EnableBTPopupView, ::NotifierMessage, 0x63792124);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        EnableBTPopupView(::Courier::ViewId const & aViewName);
        virtual ~EnableBTPopupView();

        ::Courier::ViewId const & GetViewName() const { return mViewName; }
        void SetViewName(::Courier::ViewId const & value) { mViewName = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(EnableBTPopupView);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mEnableBTPopupViewMetaData;
        static ::Courier::Message::ModifiableMetadata mEnableBTPopupViewModifiableMetadata;
        static const ::Courier::ComponentId mEnableBTPopupViewSubscriberList[];

        ::Courier::ViewId mViewName;
};

// ------------------------------------------------------------------------
class DisableBTPopupView : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(DisableBTPopupView, ::NotifierMessage, 0x8B83A442);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        DisableBTPopupView(::Courier::ViewId const & aViewName);
        virtual ~DisableBTPopupView();

        ::Courier::ViewId const & GetViewName() const { return mViewName; }
        void SetViewName(::Courier::ViewId const & value) { mViewName = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(DisableBTPopupView);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mDisableBTPopupViewMetaData;
        static ::Courier::Message::ModifiableMetadata mDisableBTPopupViewModifiableMetadata;
        static const ::Courier::ComponentId mDisableBTPopupViewSubscriberList[];

        ::Courier::ViewId mViewName;
};

// ------------------------------------------------------------------------
class SPI_PFO_2ndDevice_Connect_confirmation : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SPI_PFO_2ndDevice_Connect_confirmation, ::NotifierMessage, 0x846CEB5A);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        SPI_PFO_2ndDevice_Connect_confirmation();
        virtual ~SPI_PFO_2ndDevice_Connect_confirmation();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSPI_PFO_2ndDevice_Connect_confirmationMetaData;
        static ::Courier::Message::ModifiableMetadata mSPI_PFO_2ndDevice_Connect_confirmationModifiableMetadata;
        static const ::Courier::ComponentId mSPI_PFO_2ndDevice_Connect_confirmationSubscriberList[];
};

// ------------------------------------------------------------------------
class Enable2ndDeviceConnectConfirmationView : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(Enable2ndDeviceConnectConfirmationView, ::NotifierMessage, 0xF778DF04);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        Enable2ndDeviceConnectConfirmationView(::Courier::ViewId const & aViewName);
        virtual ~Enable2ndDeviceConnectConfirmationView();

        ::Courier::ViewId const & GetViewName() const { return mViewName; }
        void SetViewName(::Courier::ViewId const & value) { mViewName = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(Enable2ndDeviceConnectConfirmationView);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mEnable2ndDeviceConnectConfirmationViewMetaData;
        static ::Courier::Message::ModifiableMetadata mEnable2ndDeviceConnectConfirmationViewModifiableMetadata;
        static const ::Courier::ComponentId mEnable2ndDeviceConnectConfirmationViewSubscriberList[];

        ::Courier::ViewId mViewName;
};

// ------------------------------------------------------------------------
class Disable2ndDeviceConnectConfirmationView : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(Disable2ndDeviceConnectConfirmationView, ::NotifierMessage, 0x4F935C3F);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        Disable2ndDeviceConnectConfirmationView(::Courier::ViewId const & aViewName);
        virtual ~Disable2ndDeviceConnectConfirmationView();

        ::Courier::ViewId const & GetViewName() const { return mViewName; }
        void SetViewName(::Courier::ViewId const & value) { mViewName = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(Disable2ndDeviceConnectConfirmationView);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mDisable2ndDeviceConnectConfirmationViewMetaData;
        static ::Courier::Message::ModifiableMetadata mDisable2ndDeviceConnectConfirmationViewModifiableMetadata;
        static const ::Courier::ComponentId mDisable2ndDeviceConnectConfirmationViewSubscriberList[];

        ::Courier::ViewId mViewName;
};

// ------------------------------------------------------------------------
class SecondDeviceConnectConfirmationYesMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SecondDeviceConnectConfirmationYesMsg, ::NotifierMessage, 0xE7297315);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        SecondDeviceConnectConfirmationYesMsg();
        virtual ~SecondDeviceConnectConfirmationYesMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSecondDeviceConnectConfirmationYesMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mSecondDeviceConnectConfirmationYesMsgModifiableMetadata;
        static const ::Courier::ComponentId mSecondDeviceConnectConfirmationYesMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class SecondDeviceConnectConfirmationNOMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SecondDeviceConnectConfirmationNOMsg, ::NotifierMessage, 0xFE7D7F73);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        SecondDeviceConnectConfirmationNOMsg();
        virtual ~SecondDeviceConnectConfirmationNOMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSecondDeviceConnectConfirmationNOMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mSecondDeviceConnectConfirmationNOMsgModifiableMetadata;
        static const ::Courier::ComponentId mSecondDeviceConnectConfirmationNOMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class EnablePfo_SPIMessageView : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(EnablePfo_SPIMessageView, ::NotifierMessage, 0x8940681A);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        EnablePfo_SPIMessageView(::Courier::ViewId const & aViewName);
        virtual ~EnablePfo_SPIMessageView();

        ::Courier::ViewId const & GetViewName() const { return mViewName; }
        void SetViewName(::Courier::ViewId const & value) { mViewName = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(EnablePfo_SPIMessageView);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mEnablePfo_SPIMessageViewMetaData;
        static ::Courier::Message::ModifiableMetadata mEnablePfo_SPIMessageViewModifiableMetadata;
        static const ::Courier::ComponentId mEnablePfo_SPIMessageViewSubscriberList[];

        ::Courier::ViewId mViewName;
};

// ------------------------------------------------------------------------
class DisablePfo_SPIMessageView : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(DisablePfo_SPIMessageView, ::NotifierMessage, 0x2EA963AE);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        DisablePfo_SPIMessageView(::Courier::ViewId const & aViewName);
        virtual ~DisablePfo_SPIMessageView();

        ::Courier::ViewId const & GetViewName() const { return mViewName; }
        void SetViewName(::Courier::ViewId const & value) { mViewName = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(DisablePfo_SPIMessageView);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mDisablePfo_SPIMessageViewMetaData;
        static ::Courier::Message::ModifiableMetadata mDisablePfo_SPIMessageViewModifiableMetadata;
        static const ::Courier::ComponentId mDisablePfo_SPIMessageViewSubscriberList[];

        ::Courier::ViewId mViewName;
};

// ------------------------------------------------------------------------
class ShowSPI_Pfo_Message : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ShowSPI_Pfo_Message, ::NotifierMessage, 0x024CAB88);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ShowSPI_Pfo_Message(Candera::UInt8 const & aMessage_Switch_Index, Candera::String const & aSPI_Message_String1, Candera::String const & aSPI_Message_String2);
        virtual ~ShowSPI_Pfo_Message();

        Candera::UInt8 const & GetMessage_Switch_Index() const { return mMessage_Switch_Index; }
        void SetMessage_Switch_Index(Candera::UInt8 const & value) { mMessage_Switch_Index = value; }
        Candera::String const & GetSPI_Message_String1() const { return mSPI_Message_String1; }
        void SetSPI_Message_String1(Candera::String const & value) { mSPI_Message_String1 = value; }
        Candera::String const & GetSPI_Message_String2() const { return mSPI_Message_String2; }
        void SetSPI_Message_String2(Candera::String const & value) { mSPI_Message_String2 = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ShowSPI_Pfo_Message);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mShowSPI_Pfo_MessageMetaData;
        static ::Courier::Message::ModifiableMetadata mShowSPI_Pfo_MessageModifiableMetadata;
        static const ::Courier::ComponentId mShowSPI_Pfo_MessageSubscriberList[];

        Candera::UInt8 mMessage_Switch_Index;
        Candera::String mSPI_Message_String1;
        Candera::String mSPI_Message_String2;
};

// ------------------------------------------------------------------------
class ShowSPI_2ndDev_Conf_Message : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ShowSPI_2ndDev_Conf_Message, ::NotifierMessage, 0xA1B396C1);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ShowSPI_2ndDev_Conf_Message(Candera::UInt8 const & aMessage_Switch_Index, Candera::String const & aSPI_Conf_Message_String1, Candera::String const & aSPI_Conf_Message_String2);
        virtual ~ShowSPI_2ndDev_Conf_Message();

        Candera::UInt8 const & GetMessage_Switch_Index() const { return mMessage_Switch_Index; }
        void SetMessage_Switch_Index(Candera::UInt8 const & value) { mMessage_Switch_Index = value; }
        Candera::String const & GetSPI_Conf_Message_String1() const { return mSPI_Conf_Message_String1; }
        void SetSPI_Conf_Message_String1(Candera::String const & value) { mSPI_Conf_Message_String1 = value; }
        Candera::String const & GetSPI_Conf_Message_String2() const { return mSPI_Conf_Message_String2; }
        void SetSPI_Conf_Message_String2(Candera::String const & value) { mSPI_Conf_Message_String2 = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ShowSPI_2ndDev_Conf_Message);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mShowSPI_2ndDev_Conf_MessageMetaData;
        static ::Courier::Message::ModifiableMetadata mShowSPI_2ndDev_Conf_MessageModifiableMetadata;
        static const ::Courier::ComponentId mShowSPI_2ndDev_Conf_MessageSubscriberList[];

        Candera::UInt8 mMessage_Switch_Index;
        Candera::String mSPI_Conf_Message_String1;
        Candera::String mSPI_Conf_Message_String2;
};

// ------------------------------------------------------------------------
class EnablePfo_Connect_BTView : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(EnablePfo_Connect_BTView, ::NotifierMessage, 0x8166BB69);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        EnablePfo_Connect_BTView(::Courier::ViewId const & aViewName);
        virtual ~EnablePfo_Connect_BTView();

        ::Courier::ViewId const & GetViewName() const { return mViewName; }
        void SetViewName(::Courier::ViewId const & value) { mViewName = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(EnablePfo_Connect_BTView);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mEnablePfo_Connect_BTViewMetaData;
        static ::Courier::Message::ModifiableMetadata mEnablePfo_Connect_BTViewModifiableMetadata;
        static const ::Courier::ComponentId mEnablePfo_Connect_BTViewSubscriberList[];

        ::Courier::ViewId mViewName;
};

// ------------------------------------------------------------------------
class DisablePfo_Connect_BTView : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(DisablePfo_Connect_BTView, ::NotifierMessage, 0xC770D9D9);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        DisablePfo_Connect_BTView(::Courier::ViewId const & aViewName);
        virtual ~DisablePfo_Connect_BTView();

        ::Courier::ViewId const & GetViewName() const { return mViewName; }
        void SetViewName(::Courier::ViewId const & value) { mViewName = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(DisablePfo_Connect_BTView);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mDisablePfo_Connect_BTViewMetaData;
        static ::Courier::Message::ModifiableMetadata mDisablePfo_Connect_BTViewModifiableMetadata;
        static const ::Courier::ComponentId mDisablePfo_Connect_BTViewSubscriberList[];

        ::Courier::ViewId mViewName;
};

// ------------------------------------------------------------------------
class Pfo_Connect_BTOKMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(Pfo_Connect_BTOKMsg, ::NotifierMessage, 0xDDE8F034);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        Pfo_Connect_BTOKMsg();
        virtual ~Pfo_Connect_BTOKMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mPfo_Connect_BTOKMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mPfo_Connect_BTOKMsgModifiableMetadata;
        static const ::Courier::ComponentId mPfo_Connect_BTOKMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class ToggleMLMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ToggleMLMsg, ::NotifierMessage, 0x8D230B18);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ToggleMLMsg();
        virtual ~ToggleMLMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mToggleMLMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mToggleMLMsgModifiableMetadata;
        static const ::Courier::ComponentId mToggleMLMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class ToggleTAMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ToggleTAMsg, ::NotifierMessage, 0x4F58A7B9);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ToggleTAMsg();
        virtual ~ToggleTAMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mToggleTAMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mToggleTAMsgModifiableMetadata;
        static const ::Courier::ComponentId mToggleTAMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class TogglePAMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(TogglePAMsg, ::NotifierMessage, 0x1F1D5DC0);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        TogglePAMsg();
        virtual ~TogglePAMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mTogglePAMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mTogglePAMsgModifiableMetadata;
        static const ::Courier::ComponentId mTogglePAMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class UpdateS_OPTSettingsMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(UpdateS_OPTSettingsMsg, ::NotifierMessage, 0xFF6CE60C);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        UpdateS_OPTSettingsMsg(Candera::UInt8 const & aShowMirrorLink, Candera::UInt8 const & aTrafficAnnouncement, Candera::UInt8 const & aPhoneApplication);
        virtual ~UpdateS_OPTSettingsMsg();

        Candera::UInt8 const & GetShowMirrorLink() const { return mShowMirrorLink; }
        void SetShowMirrorLink(Candera::UInt8 const & value) { mShowMirrorLink = value; }
        Candera::UInt8 const & GetTrafficAnnouncement() const { return mTrafficAnnouncement; }
        void SetTrafficAnnouncement(Candera::UInt8 const & value) { mTrafficAnnouncement = value; }
        Candera::UInt8 const & GetPhoneApplication() const { return mPhoneApplication; }
        void SetPhoneApplication(Candera::UInt8 const & value) { mPhoneApplication = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(UpdateS_OPTSettingsMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mUpdateS_OPTSettingsMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mUpdateS_OPTSettingsMsgModifiableMetadata;
        static const ::Courier::ComponentId mUpdateS_OPTSettingsMsgSubscriberList[];

        Candera::UInt8 mShowMirrorLink;
        Candera::UInt8 mTrafficAnnouncement;
        Candera::UInt8 mPhoneApplication;
};

// ------------------------------------------------------------------------
class Enable_OPTView : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(Enable_OPTView, ::NotifierMessage, 0x423AAFD0);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        Enable_OPTView(::Courier::ViewId const & aViewName);
        virtual ~Enable_OPTView();

        ::Courier::ViewId const & GetViewName() const { return mViewName; }
        void SetViewName(::Courier::ViewId const & value) { mViewName = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(Enable_OPTView);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mEnable_OPTViewMetaData;
        static ::Courier::Message::ModifiableMetadata mEnable_OPTViewModifiableMetadata;
        static const ::Courier::ComponentId mEnable_OPTViewSubscriberList[];

        ::Courier::ViewId mViewName;
};

// ------------------------------------------------------------------------
class Disable_OPTView : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(Disable_OPTView, ::NotifierMessage, 0x90C77B26);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        Disable_OPTView(::Courier::ViewId const & aViewName);
        virtual ~Disable_OPTView();

        ::Courier::ViewId const & GetViewName() const { return mViewName; }
        void SetViewName(::Courier::ViewId const & value) { mViewName = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(Disable_OPTView);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mDisable_OPTViewMetaData;
        static ::Courier::Message::ModifiableMetadata mDisable_OPTViewModifiableMetadata;
        static const ::Courier::ComponentId mDisable_OPTViewSubscriberList[];

        ::Courier::ViewId mViewName;
};

// ------------------------------------------------------------------------
class UpdateSPDisConnStatusMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(UpdateSPDisConnStatusMsg, ::NotifierMessage, 0x40E82375);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        UpdateSPDisConnStatusMsg(bool const & aDeviceConDisconStatus);
        virtual ~UpdateSPDisConnStatusMsg();

        bool const & GetDeviceConDisconStatus() const { return mDeviceConDisconStatus; }
        void SetDeviceConDisconStatus(bool const & value) { mDeviceConDisconStatus = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(UpdateSPDisConnStatusMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mUpdateSPDisConnStatusMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mUpdateSPDisConnStatusMsgModifiableMetadata;
        static const ::Courier::ComponentId mUpdateSPDisConnStatusMsgSubscriberList[];

        bool mDeviceConDisconStatus;
};

// ------------------------------------------------------------------------
class MarkConnectSPScreenMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(MarkConnectSPScreenMsg, ::NotifierMessage, 0x492016B3);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        MarkConnectSPScreenMsg();
        virtual ~MarkConnectSPScreenMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mMarkConnectSPScreenMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mMarkConnectSPScreenMsgModifiableMetadata;
        static const ::Courier::ComponentId mMarkConnectSPScreenMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class ExitConnectSPScreenMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ExitConnectSPScreenMsg, ::NotifierMessage, 0xCCD9EA74);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ExitConnectSPScreenMsg();
        virtual ~ExitConnectSPScreenMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mExitConnectSPScreenMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mExitConnectSPScreenMsgModifiableMetadata;
        static const ::Courier::ComponentId mExitConnectSPScreenMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class Enable_Projection_ListVIEW : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(Enable_Projection_ListVIEW, ::NotifierMessage, 0xBF4FB198);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        Enable_Projection_ListVIEW();
        virtual ~Enable_Projection_ListVIEW();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mEnable_Projection_ListVIEWMetaData;
        static ::Courier::Message::ModifiableMetadata mEnable_Projection_ListVIEWModifiableMetadata;
        static const ::Courier::ComponentId mEnable_Projection_ListVIEWSubscriberList[];
};

// ------------------------------------------------------------------------
class Enable_ConnectSP_VIEW : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(Enable_ConnectSP_VIEW, ::NotifierMessage, 0x910F16A5);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        Enable_ConnectSP_VIEW();
        virtual ~Enable_ConnectSP_VIEW();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mEnable_ConnectSP_VIEWMetaData;
        static ::Courier::Message::ModifiableMetadata mEnable_ConnectSP_VIEWModifiableMetadata;
        static const ::Courier::ComponentId mEnable_ConnectSP_VIEWSubscriberList[];
};

// ------------------------------------------------------------------------
class ShowSPI_Disclaimer_Msg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ShowSPI_Disclaimer_Msg, ::NotifierMessage, 0x75750DE2);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ShowSPI_Disclaimer_Msg(Candera::UInt8 const & aMsg_Switch_Index);
        virtual ~ShowSPI_Disclaimer_Msg();

        Candera::UInt8 const & GetMsg_Switch_Index() const { return mMsg_Switch_Index; }
        void SetMsg_Switch_Index(Candera::UInt8 const & value) { mMsg_Switch_Index = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ShowSPI_Disclaimer_Msg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mShowSPI_Disclaimer_MsgMetaData;
        static ::Courier::Message::ModifiableMetadata mShowSPI_Disclaimer_MsgModifiableMetadata;
        static const ::Courier::ComponentId mShowSPI_Disclaimer_MsgSubscriberList[];

        Candera::UInt8 mMsg_Switch_Index;
};

#endif // AppHmi_SPIMessages_h
