/************************************************************************
*FILE: AppHmi_PhoneStateMachineData.cpp 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/*
 * Id:        AppHmi_PhoneStateMachineData.cpp
 *
 * Function:  VS System Data Source File.
 *
 * Generated: Fri Mar 08 11:43:24 2024
 *
 * Coder 7, 3, 2, 2426
 * 
 * This is an automatically generated file. It will be overwritten by the Coder.
 * 
 * DO NOT EDIT THE FILE!
 */


#include "AppHmi_PhoneStateMachineSEMLibB.h"


#include "AppHmi_PhoneStateMachineData.h"


#include <stdarg.h>


/*
 * VS System External Variable Definitions.
 */
VS_UINT32 CurrentView = 0ul;

VS_INT DeviceTypeConnected = 0;

VS_INT IsAcceptRequested = 0;

VS_INT IsContactListPersistent = 0;

VS_INT IsDTMFActive = 0;

VS_BOOL IsDeviceConnected = 0;

VS_BOOL IsDeviceConnectingActive = 0;

VS_BOOL IsDeviceListOperationProgress = 0;

VS_BOOL IsDialed = 0;

VS_BOOL IsIntercomCallActive = 0;

VS_BOOL IsParingActive = 0;

VS_BOOL IsReadAloudActive = 0;

VS_BOOL IsRejectRequested = 0;

VS_BOOL IsSMSContactActive = 0;

VS_INT ListViewID = 0;

VS_INT Sm_ActiveSource = 0;

VS_BOOL bBTVRViewShown = 0;

VS_BOOL bChangeDeviceStateReq = 0;

VS_INT g_SM_CPWhileBTConn = 0;

VS_BOOL g_SM_IsRVCViewEnabled = 0;

VS_INT g_SM_SpiSessionStatus = 0;

VS_BOOL sm_variant_intercom = 1;

VS_BOOL sm_variant_kitchen = 1;


/*
 * VS System Internal Variable Initializing Function.
 */
void AppHmi_PhoneStateMachine::SEM_InitInternalVariables (void)
{
  CallListDownloadStatus = 0;
  CallStatus = 0;
  ContactsCallListNotPersistant = 0;
  IntercomCallScreenInfo = 0;
  IsAppActivatedInternally = 0;
  IsContactsBackSelected = 0;
  IsDeviceInDiscoverableMode = 0;
  IsDeviceReseted = 1;
  IsHomeScreenActive = 0;
  IsSMSActive = 0;
  IsSMSExpandActive = 0;
  PhoneBookDownloadStatus = 0;
  PreviousActiveStateForCallAction = 0L;
  PreviousActiveStateForOPT = 0L;
  PreviousActiveStateForPhoneSelection = 0L;
  PreviousCallStaus = 0;
  PreviousScreenEntry = 0ul;
  PreviousScreenEntryBTVR = 0ul;
  RequestEntryState = 0ul;
  WasCallListLoadingActive = 0;
  WasContactListLoadingActive = 0;
  WasDTMFActive = 0;
}


void AppHmi_PhoneStateMachine::BufferVariables (SEM_EVENT_TYPE EventNo)
{
  if (EventNo >= 296)
  {
    EventNo -= 21;
  }
  switch (EventNo)
  {
  case 6:
    VSDBVar.DB6.VS_INTVar[0] = IsAcceptRequested;
    break;
  case 27:
    VSDBVar.DB27.VS_BOOLVar[0] = IsRejectRequested;
    break;
  case 72:
    VSDBVar.DB72.VS_UINT32Var[0] = PreviousScreenEntryBTVR;
    break;
  case 157:
    VSDBVar.DB157.VS_UINT32Var[0] = PreviousScreenEntry;
    break;
  case 175:
    VSDBVar.DB179.VS_BOOLVar[0] = IsReadAloudActive;
    break;
  case 179:
    VSDBVar.DB179.VS_BOOLVar[0] = IsReadAloudActive;
    break;
  case 193:
    VSDBVar.DB193.VS_INTVar[0] = IsAppActivatedInternally;
    break;
  case 225:
    VSDBVar.DB225.VS_INT32Var[0] = PreviousActiveStateForOPT;
    break;
  case 301:
    VSDBVar.DB193.VS_INTVar[0] = WasContactListLoadingActive;
    break;
  case 304:
    VSDBVar.DB193.VS_INTVar[0] = IntercomCallScreenInfo;
    break;

  default:
    break;
  }
}


/*
 * SEM Deduct Function.
 */
unsigned char AppHmi_PhoneStateMachine::SEM_Deduct (SEM_EVENT_TYPE EventNo, ...)
{
  va_list ap;

  va_start(ap, EventNo);
  if (SEM.State == 0x00u /* STATE_SEM_NOT_INITIALIZED */)
  {
    return SES_NOT_INITIALIZED;
  }
  if (VS_NOF_EVENTS <= EventNo)
  {
    return (SES_RANGE_ERR);
  }
  switch (EventNo)
  {
  case 217:
    EventArgsVar.DB218.VS_INT8Var[0] = (VS_INT8) va_arg(ap, VS_INT);
    break;

  case 218:
    EventArgsVar.DB218.VS_INT8Var[0] = (VS_INT8) va_arg(ap, VS_INT);
    break;

  case 267:
    EventArgsVar.DB267.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 271:
    EventArgsVar.DB267.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 272:
    EventArgsVar.DB267.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 273:
    EventArgsVar.DB267.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 274:
    EventArgsVar.DB274.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 275:
    EventArgsVar.DB290.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 276:
    EventArgsVar.DB276.VS_INT8Var[0] = (VS_INT8) va_arg(ap, VS_INT);
    break;

  case 286:
    EventArgsVar.DB290.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 287:
    EventArgsVar.DB290.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 288:
    EventArgsVar.DB290.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 289:
    EventArgsVar.DB290.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 290:
    EventArgsVar.DB290.VS_INT32Var[0] = (VS_INT32) va_arg(ap, VS_INT32_VAARG);
    EventArgsVar.DB290.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 291:
    EventArgsVar.DB290.VS_INT32Var[0] = (VS_INT32) va_arg(ap, VS_INT32_VAARG);
    EventArgsVar.DB290.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 292:
    EventArgsVar.DB290.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 293:
    EventArgsVar.DB290.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 294:
    EventArgsVar.DB290.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 295:
    EventArgsVar.DB290.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  default:
    break;
  }
  if (EventNo == SE_RESET)
  {
    SEM.EventNo = SE_RESET;
    SEM.DIt = 2;
  }
  else
  {
    SEM.EventNo = VS_TRIGGERLESS_TRIGGER;
    SEM.DIt = 0;
  }
  SEM.State = 0x02u; /* STATE_SEM_PREPARE */
  SEM.InitialEventNo = EventNo;
  SEM.OriginalEventNo = EventNo;

  va_end(ap);
  return (SES_OKAY);
}


/*
 * Guard Expression Functions.
 */
VS_BOOL AppHmi_PhoneStateMachine::VSGuard (SEM_GUARD_EXPRESSION_TYPE i)
{
  switch (i)
  {
  case 0:
    return (VS_BOOL)(EventArgsVar.DB218.VS_INT8Var[0] == INCOMING_CALL_DEVICETYPE_ACTIVE);
  case 1:
    return (VS_BOOL)(IsIntercomCallActive == 0);
  case 2:
    return (VS_BOOL)(EventArgsVar.DB218.VS_INT8Var[0] == INCOMING_CALL_DEVICETYPE_PASSIVE);
  case 3:
    return (VS_BOOL)(CallStatus == 9);
  case 4:
    return (VS_BOOL)(IsAcceptRequested != 1);
  case 5:
    return (VS_BOOL)(IsRejectRequested != 1);
  case 6:
    return (VS_BOOL)(IsReadAloudActive == 1);
  case 7:
    return (VS_BOOL)(VS_BOOL_FALSE == g_SM_IsRVCViewEnabled);
  case 8:
    return (VS_BOOL)(IsParingActive == 1);
  case 9:
    return (VS_BOOL)(CallStatus == 2 || CallStatus == 1);
  case 10:
    return (VS_BOOL)(CallStatus == 4 || CallStatus == 3);
  case 11:
    return (VS_BOOL)(CallStatus > 4 && CallStatus <= 8);
  case 12:
    return (VS_BOOL)(CallStatus != 0 && CallStatus != 9);
  case 13:
    return (VS_BOOL)(DeviceTypeConnected == 1);
  case 14:
    return (VS_BOOL)(CallStatus == 0 || CallStatus == 9);
  case 15:
    return (VS_BOOL)(DeviceTypeConnected != 1);
  case 16:
    return (VS_BOOL)(CallStatus == 0);
  case 17:
    return (VS_BOOL)(CallStatus == PreviousCallStaus);
  case 18:
    return (VS_BOOL)(PhoneBookDownloadStatus != 2);
  case 19:
    return (VS_BOOL)(PhoneBookDownloadStatus == 2);
  case 20:
    return (VS_BOOL)(g_SM_SpiSessionStatus != SPI_SESSION_ANDROID_AUTO_ACTIVE && g_SM_SpiSessionStatus != SPI_SESSION_CARPLAY_ACTIVE);
  case 21:
    return (VS_BOOL)(CallListDownloadStatus != 2);
  case 22:
    return (VS_BOOL)(CallListDownloadStatus == 2);
  case 23:
    return (VS_BOOL)(CallStatus == 3);
  case 24:
    return (VS_BOOL)(g_SM_SpiSessionStatus == SPI_SESSION_ANDROID_AUTO_ACTIVE || g_SM_SpiSessionStatus == SPI_SESSION_CARPLAY_ACTIVE);
  case 25:
    return (VS_BOOL)(IsHomeScreenActive != 1);
  case 26:
    return (VS_BOOL)(CallStatus != 0);
  case 27:
    return (VS_BOOL)(IsHomeScreenActive == 1);
  case 28:
    return (VS_BOOL)(IsDeviceConnectingActive != 1);
  case 29:
    return (VS_BOOL)(CallStatus == 3 || CallStatus == 4);
  case 30:
    return (VS_BOOL)(CallStatus != 0 && CallStatus != 3 && CallStatus != 4 && CallStatus != 9);
  case 31:
    return (VS_BOOL)(IsDeviceInDiscoverableMode == 1);
  case 32:
    return (VS_BOOL)(IsAppActivatedInternally == 1);
  case 33:
    return (VS_BOOL)(EventArgsVar.DB290.VS_UINT32Var[0] == 3 && sm_variant_intercom == 1 && sm_variant_kitchen == 1);
  case 34:
    return (VS_BOOL)(Sm_ActiveSource == 0);
  case 35:
    return (VS_BOOL)(Sm_ActiveSource == 1);
  case 36:
    return (VS_BOOL)(IsIntercomCallActive == 1);
  case 37:
    return (VS_BOOL)(EventArgsVar.DB267.VS_UINT32Var[0] == 3 && sm_variant_kitchen == 1 && sm_variant_intercom == 1);
  case 38:
    return (VS_BOOL)(EventArgsVar.DB267.VS_UINT32Var[0] == 3 && sm_variant_intercom == 0 && sm_variant_kitchen == 0);
  case 39:
    return (VS_BOOL)(EventArgsVar.DB267.VS_UINT32Var[0] == 27 && sm_variant_kitchen == 1 && sm_variant_intercom == 1);
  case 40:
    return (VS_BOOL)(EventArgsVar.DB290.VS_UINT32Var[0] == 3 && sm_variant_intercom == 0 && sm_variant_kitchen == 0);
  case 41:
    return (VS_BOOL)(EventArgsVar.DB290.VS_UINT32Var[0] == 27 && sm_variant_kitchen == 1 && sm_variant_intercom == 1);
  case 42:
    return (VS_BOOL)(EventArgsVar.DB267.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_PriorityCall_BT);
  case 43:
    return (VS_BOOL)(EventArgsVar.DB274.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_PriorityCall_BT);
  case 44:
    return (VS_BOOL)(EventArgsVar.DB267.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_PriorityCall_Intercom);
  case 45:
    return (VS_BOOL)(EventArgsVar.DB274.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_PriorityCall_Intercom);
  case 46:
    return (VS_BOOL)(EventArgsVar.DB267.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_MIC_PhoneCall);
  case 47:
    return (VS_BOOL)(EventArgsVar.DB274.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_MIC_PhoneCall);
  case 48:
    return (VS_BOOL)(EventArgsVar.DB267.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_MIC_IntercomCall);
  case 49:
    return (VS_BOOL)(EventArgsVar.DB274.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_MIC_IntercomCall);
  case 50:
    return (VS_BOOL)(EventArgsVar.DB267.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_MIC_CallHistory_Contacts);
  case 51:
    return (VS_BOOL)(EventArgsVar.DB274.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_MIC_CallHistory_Contacts);
  case 52:
    return (VS_BOOL)(EventArgsVar.DB267.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_Intercom_RTP_stream_failure);
  case 53:
    return (VS_BOOL)(EventArgsVar.DB274.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_Intercom_RTP_stream_failure);
  case 54:
    return (VS_BOOL)(EventArgsVar.DB267.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_Intercom_IncomingCall);
  case 55:
    return (VS_BOOL)(EventArgsVar.DB274.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_Intercom_IncomingCall);
  case 56:
    return (VS_BOOL)(EventArgsVar.DB267.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_PassiveDeviceIncomingCall);
  case 57:
    return (VS_BOOL)(VSDBVar.DB6.VS_INTVar[0] != 1);
  case 58:
    return (VS_BOOL)(VSDBVar.DB27.VS_BOOLVar[0] != 1);
  case 59:
    return (VS_BOOL)(EventArgsVar.DB274.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_PassiveDeviceIncomingCall);
  case 60:
    return (VS_BOOL)(EventArgsVar.DB267.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_SR_SIRI_Main);
  case 61:
    return (VS_BOOL)(EventArgsVar.DB274.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_SR_SIRI_Main);
  case 62:
    return (VS_BOOL)(EventArgsVar.DB267.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_ConnectionFailed);
  case 63:
    return (VS_BOOL)(EventArgsVar.DB274.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_ConnectionFailed);
  case 64:
    return (VS_BOOL)(EventArgsVar.DB267.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_PhonebookDLFailed);
  case 65:
    return (VS_BOOL)(EventArgsVar.DB274.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_PhonebookDLFailed);
  case 66:
    return (VS_BOOL)(EventArgsVar.DB267.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_PhonebookDLIncomplete);
  case 67:
    return (VS_BOOL)(EventArgsVar.DB274.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_PhonebookDLIncomplete);
  case 68:
    return (VS_BOOL)(EventArgsVar.DB267.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_SIRI_EyeFree);
  case 69:
    return (VS_BOOL)(EventArgsVar.DB274.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_SIRI_EyeFree);
  case 70:
    return (VS_BOOL)(EventArgsVar.DB267.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_DeviceConnected);
  case 71:
    return (VS_BOOL)(EventArgsVar.DB274.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_DeviceConnected);
  case 72:
    return (VS_BOOL)(EventArgsVar.DB267.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_DeviceDisConnected);
  case 73:
    return (VS_BOOL)(EventArgsVar.DB274.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_DeviceDisConnected);
  case 74:
    return (VS_BOOL)(EventArgsVar.DB267.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_SMSExpand);
  case 75:
    return (VS_BOOL)(IsSMSContactActive == 1);
  case 76:
    return (VS_BOOL)(VSDBVar.DB179.VS_BOOLVar[0] == 0);
  case 77:
    return (VS_BOOL)(VSDBVar.DB179.VS_BOOLVar[0] == 1);
  case 78:
    return (VS_BOOL)(EventArgsVar.DB274.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_SMSExpand);
  case 79:
    return (VS_BOOL)(EventArgsVar.DB267.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_SMS);
  case 80:
    return (VS_BOOL)(EventArgsVar.DB274.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_SMS);
  case 81:
    return (VS_BOOL)(EventArgsVar.DB267.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_IncomingCall);
  case 82:
    return (VS_BOOL)(EventArgsVar.DB274.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_IncomingCall);
  case 83:
    return (VS_BOOL)(EventArgsVar.DB290.VS_UINT32Var[0] == AppHmi_PhoneModule_App_Popup_Pfo_DeviceConnecting);
  case 84:
    return (VS_BOOL)(EventArgsVar.DB290.VS_UINT32Var[0] == AppHmi_PhoneModule_App_Popup_Pfo_DeviceDeleting);
  case 85:
    return (VS_BOOL)(EventArgsVar.DB290.VS_UINT32Var[0] == AppHmi_PhoneModule_App_Popup_Pfo_DeviceDeleted);
  case 86:
    return (VS_BOOL)(EventArgsVar.DB290.VS_UINT32Var[0] == AppHmi_PhoneModule_App_Popup_Pfo_DeleteDeviceConfirmation);
  case 87:
    return (VS_BOOL)(EventArgsVar.DB290.VS_UINT32Var[0] == AppHmi_PhoneModule_App_Popup_Pfo_WaitForConfirmation);
  case 88:
    return (VS_BOOL)(EventArgsVar.DB290.VS_UINT32Var[0] == AppHmi_PhoneModule_App_Popup_Pfo_PairingInitiate);
  case 89:
    return (VS_BOOL)(EventArgsVar.DB290.VS_UINT32Var[0] == AppHmi_PhoneModule_App_Popup_Pfo_NumCompPairing);
  case 90:
    return (VS_BOOL)(EventArgsVar.DB290.VS_UINT32Var[0] == AppHmi_PhoneModule_App_Popup_Pfo_JustWorksPairingWaiting);
  case 91:
    return (VS_BOOL)(EventArgsVar.DB290.VS_UINT32Var[0] == AppHmi_PhoneModule_App_Popup_Pfo_JustWorksPairing);
  case 92:
    return (VS_BOOL)(EventArgsVar.DB290.VS_UINT32Var[0] == AppHmi_PhoneModule_App_Popup_Pfo_DeviceListFull);
  case 93:
    return (VS_BOOL)(EventArgsVar.DB290.VS_UINT32Var[0] == AppHmi_PhoneModule_App_Popup_Pfo_DeviceDisconnectConfirmation);
  case 94:
    return (VS_BOOL)(CallStatus != 9);
  case 95:
    return (VS_BOOL)(CallStatus != 1);
  case 96:
    return (VS_BOOL)(CallStatus != 3);
  case 97:
    return (VS_BOOL)(CallStatus != 2);
  case 98:
    return (VS_BOOL)(CallStatus != 4);
  case 99:
    return (VS_BOOL)(CallStatus != 7);
  case 100:
    return (VS_BOOL)(CallStatus != 5);
  case 101:
    return (VS_BOOL)(CallStatus != 6);
  case 102:
    return (VS_BOOL)(CallStatus != 8);
  case 103:
    return (VS_BOOL)(VSDBVar.DB225.VS_INT32Var[0] == AppHmi_PhoneModule_PhoneScenes_P_PhoneSelection && CallStatus == 0 && DeviceTypeConnected == 1 || CallStatus == 0 && DeviceTypeConnected != 1);
  case 104:
    return (VS_BOOL)(VSDBVar.DB225.VS_INT32Var[0] != AppHmi_PhoneModule_PhoneScenes_P_PhoneSelection);
  case 105:
    return (VS_BOOL)(CallStatus == 1 || CallStatus == 2);
  case 106:
    return (VS_BOOL)(CallStatus >= 4 && CallStatus <= 8);
  case 107:
    return (VS_BOOL)(PreviousActiveStateForOPT != AppHmi_PhoneModule_PhoneScenes_P_Call && PreviousActiveStateForOPT != AppHmi_PhoneModule_PhoneScenes_P_Call_DialPad);
  case 108:
    return (VS_BOOL)(PreviousActiveStateForOPT != AppHmi_PhoneModule_PhoneScenes_P_MultipleCall && PreviousActiveStateForOPT != AppHmi_PhoneModule_PhoneScenes_P_MultipleCall_DialPad);
  case 109:
    return (VS_BOOL)(PreviousActiveStateForOPT != AppHmi_PhoneModule_PhoneScenes_P_Call_Connecting);
  case 110:
    return (VS_BOOL)(IsDeviceConnected == 1);
  case 111:
    return (VS_BOOL)(PreviousActiveStateForCallAction == AppHmi_PhoneModule_PhoneScenes_P_PhoneSelection && VSDBVar.DB193.VS_INTVar[0] != 1);
  case 112:
    return (VS_BOOL)(VSDBVar.DB193.VS_INTVar[0] == 1 && g_SM_CPWhileBTConn == 0);
  case 113:
    return (VS_BOOL)(VSDBVar.DB193.VS_INTVar[0] == 1 && g_SM_CPWhileBTConn == 1);
  case 114:
    return (VS_BOOL)(VSDBVar.DB157.VS_UINT32Var[0] == AppHmi_PhoneModule_PhoneScenes_P_CallList);
  case 115:
    return (VS_BOOL)(IntercomCallScreenInfo == 1 || IntercomCallScreenInfo == 5 || IntercomCallScreenInfo == 0);
  case 116:
    return (VS_BOOL)(VSDBVar.DB157.VS_UINT32Var[0] == AppHmi_PhoneModule_PhoneScenes_P_Contacts);
  case 117:
    return (VS_BOOL)(VSDBVar.DB157.VS_UINT32Var[0] == AppHmi_PhoneModule_PhoneScenes_P_DialPad);
  case 118:
    return (VS_BOOL)(VSDBVar.DB157.VS_UINT32Var[0] == AppHmi_PhoneModule_PhoneScenes_P_PhoneSelection);
  case 119:
    return (VS_BOOL)(VSDBVar.DB157.VS_UINT32Var[0] == AppHmi_PhoneModule_PhoneScenes_I_Contacts);
  case 120:
    return (VS_BOOL)(VSDBVar.DB193.VS_INTVar[0] > 1 && VSDBVar.DB193.VS_INTVar[0] < 5);
  case 121:
    return (VS_BOOL)(VSDBVar.DB193.VS_INTVar[0] == 2);
  case 122:
    return (VS_BOOL)(VSDBVar.DB193.VS_INTVar[0] == 4);
  case 123:
    return (VS_BOOL)(VSDBVar.DB193.VS_INTVar[0] == 3);
  case 124:
    return (VS_BOOL)(0 < CallStatus && CallStatus < 9);
  case 125:
    return (VS_BOOL)(IntercomCallScreenInfo == 2 || IntercomCallScreenInfo == 4 || IntercomCallScreenInfo == 3);
  case 126:
    return (VS_BOOL)(VSDBVar.DB72.VS_UINT32Var[0] == AppHmi_PhoneModule_PhoneScenes_P_PhoneSelection);
  case 127:
    return (VS_BOOL)(VSDBVar.DB72.VS_UINT32Var[0] == AppHmi_PhoneModule_PhoneScenes_P_DialPad);
  case 128:
    return (VS_BOOL)(VSDBVar.DB72.VS_UINT32Var[0] == AppHmi_PhoneModule_PhoneScenes_P_Contacts);
  case 129:
    return (VS_BOOL)(VSDBVar.DB72.VS_UINT32Var[0] == AppHmi_PhoneModule_PhoneScenes_P_CallList);
  case 130:
    return (VS_BOOL)(VSDBVar.DB72.VS_UINT32Var[0] == AppHmi_PhoneModule_PhoneScenes_P_OPT_SETTINGS);
  case 131:
    return (VS_BOOL)(IsParingActive != 1);
  case 132:
    return (VS_BOOL)(DeviceTypeConnected == 0);
  case 133:
    return (VS_BOOL)(RequestEntryState == Enum_EntryRequest_ToPhoneSelection);
  case 134:
    return (VS_BOOL)(RequestEntryState == Enum_EntryRequest_ToCallList);
  case 135:
    return (VS_BOOL)(IsDialed != 1);
  case 136:
    return (VS_BOOL)(WasCallListLoadingActive != 1);
  case 137:
    return (VS_BOOL)(WasCallListLoadingActive == 1);
  case 138:
    return (VS_BOOL)(VSDBVar.DB193.VS_INTVar[0] != 1);
  case 139:
    return (VS_BOOL)(IsContactListPersistent == 0);
  case 140:
    return (VS_BOOL)(VSDBVar.DB193.VS_INTVar[0] == 1);
  case 141:
    return (VS_BOOL)(IsContactListPersistent == 1);
  case 142:
    return (VS_BOOL)(ContactsCallListNotPersistant != 1);
  }
  return (VS_BOOL)(ContactsCallListNotPersistant == 1);
}


/*
 * Action Expressions Wrapper Function.
 */
VS_VOID AppHmi_PhoneStateMachine::VSAction (SEM_ACTION_EXPRESSION_TYPE i)
{
  switch (i)
  {
  case 0:
    Activate_BT_SR_Session();
    break;
  case 1:
    BTVROnExitAction();
    break;
  case 2:
    DeActivate_BT_SR_Session();
    break;
  case 3:
    Halt_BT_SR_Session();
    break;
  case 4:
    Language_Update();
    break;
  case 5:
    Perform_Activate_BTPhone_Application_Call_Connecting();
    break;
  case 6:
    Perform_Activate_BTPhone_Application_Call_List();
    break;
  case 9:
    Perform_Activate_BTPhone_Application_On_Call();
    break;
  case 10:
    Perform_Activate_BTPhone_Application_On_Intercomcall();
    break;
  case 11:
    Perform_Activate_BTPhone_Application_On_Multiparty_Call();
    break;
  case 13:
    Perform_Activate_Listen();
    break;
  case 14:
    Perform_Activate_Media_Application();
    break;
  case 15:
    Perform_Activate_Media_Source_Selection();
    break;
  case 16:
    Perform_Activate_Navi_Application();
    break;
  case 17:
    Perform_Activate_Radio_Application();
    break;
  case 18:
    Perform_Activate_SPI_Application();
    break;
  case 19:
    Perform_AppHmi_PhoneModule_AcceptCall();
    break;
  case 20:
    Perform_AppHmi_PhoneModule_AddNewDevice();
    break;
  case 21:
    Perform_AppHmi_PhoneModule_BackButtonPressReq();
    break;
  case 22:
    Perform_AppHmi_PhoneModule_CallListReq();
    break;
  case 23:
    Perform_AppHmi_PhoneModule_CancelDialing();
    break;
  case 24:
    Perform_AppHmi_PhoneModule_ChangeRingtoneSettingsReq();
    break;
  case 25:
    Perform_AppHmi_PhoneModule_ChangeSMSSettingsReq();
    break;
  case 26:
    Perform_AppHmi_PhoneModule_Clear_EditFieldReq();
    break;
  case 27:
    Perform_AppHmi_PhoneModule_ContactDetailsListEntryReq();
    break;
  case 28:
    Perform_AppHmi_PhoneModule_ContactListReq_Begining();
    break;
  case 29:
    Perform_AppHmi_PhoneModule_ContactListReq_History();
    break;
  case 30:
    Perform_AppHmi_PhoneModule_DeleteDeviceConfirmationReq();
    break;
  case 31:
    Perform_AppHmi_PhoneModule_DeviceListReq();
    break;
  case 32:
    Perform_AppHmi_PhoneModule_DialCall_Model();
    break;
  case 33:
    Perform_AppHmi_PhoneModule_DisconnectDeviceConfirmationReq();
    break;
  case 34:
    Perform_AppHmi_PhoneModule_Handsfree_Status_ChangeReq();
    break;
  case 35:
    Perform_AppHmi_PhoneModule_HangUpCall();
    break;
  case 36:
    Perform_AppHmi_PhoneModule_IContactsReq();
    break;
  case 37:
    Perform_AppHmi_PhoneModule_IntercomStatusMsg();
    break;
  case 39:
    Perform_AppHmi_PhoneModule_MessageCall();
    break;
  case 40:
    Perform_AppHmi_PhoneModule_MicMute_Status_ChangeReq();
    break;
  case 41:
    Perform_AppHmi_PhoneModule_Pairing_Cancel();
    break;
  case 42:
    Perform_AppHmi_PhoneModule_Pairing_No();
    break;
  case 43:
    Perform_AppHmi_PhoneModule_Pairing_Yes();
    break;
  case 44:
    Perform_AppHmi_PhoneModule_PlayReadMessageAloudReq();
    break;
  case 45:
    Perform_AppHmi_PhoneModule_PrivateMode();
    break;
  case 46:
    Perform_AppHmi_PhoneModule_RejectCall();
    break;
  case 47:
    Perform_AppHmi_PhoneModule_ResetCallListDataReq();
    break;
  case 49:
    Perform_AppHmi_PhoneModule_Ringtone_Mute();
    break;
  case 50:
    Perform_AppHmi_PhoneModule_StopReadMessageAloudReq();
    break;
  case 51:
    Perform_AppHmi_PhoneModule_SwapMultipleCallReq();
    break;
  case 52:
    Perform_Deactivate_BTPhone_Application();
    break;
  case 53:
    Perform_IConference_RejectCall();
    break;
  case 54:
    Perform_Intercom_AcceptCall();
    break;
  case 55:
    Perform_Intercom_RejectCall();
    break;
  case 57:
    Perform_Network_Operator_Req();
    break;
  case 58:
    Phone_ActivityId();
    break;
  case 75:
    RequestEntryState = Enum_EntryRequest_AppInBackground;
    break;
  case 76:
    IsAcceptRequested = 0;
    break;
  case 77:
    IsRejectRequested = 0;
    break;
  case 78:
    CallStatus = 9;
    break;
  case 79:
    IsAcceptRequested = 1;
    break;
  case 80:
    IsRejectRequested = 1;
    break;
  case 81:
    IsParingActive = 0;
    break;
  case 82:
    IsDeviceInDiscoverableMode = 0;
    break;
  case 83:
    IsDeviceListOperationProgress = 0;
    break;
  case 84:
    IsDialed = 0;
    break;
  case 85:
    IsDTMFActive = 0;
    break;
  case 86:
    CurrentView = AppHmi_PhoneModule_PhoneScenes_P_Call;
    break;
  case 87:
    CurrentView = AppHmi_PhoneModule_PhoneScenes_P_Call_Connecting;
    break;
  case 88:
    CurrentView = AppHmi_PhoneModule_PhoneScenes_P_MultipleCall;
    break;
  case 89:
    PreviousScreenEntryBTVR = AppHmi_PhoneModule_PhoneScenes_P_PhoneSelection;
    break;
  case 90:
    PreviousScreenEntry = AppHmi_PhoneModule_PhoneScenes_P_PhoneSelection;
    break;
  case 91:
    CurrentView = AppHmi_PhoneModule_PhoneScenes_P_PhoneSelection;
    break;
  case 92:
    PreviousActiveStateForOPT = AppHmi_PhoneModule_PhoneScenes_P_PhoneSelection;
    break;
  case 93:
    PreviousActiveStateForCallAction = AppHmi_PhoneModule_PhoneScenes_P_PhoneSelection;
    break;
  case 94:
    ListViewID = 0;
    break;
  case 95:
    CurrentView = AppHmi_PhoneModule_PhoneScenes_P_OPT;
    break;
  case 96:
    PreviousScreenEntryBTVR = AppHmi_PhoneModule_PhoneScenes_P_DialPad;
    break;
  case 97:
    PreviousScreenEntry = AppHmi_PhoneModule_PhoneScenes_P_DialPad;
    break;
  case 98:
    CurrentView = AppHmi_PhoneModule_PhoneScenes_P_DialPad;
    break;
  case 99:
    PreviousActiveStateForPhoneSelection = AppHmi_PhoneModule_PhoneScenes_P_DialPad;
    break;
  case 100:
    PreviousActiveStateForCallAction = AppHmi_PhoneModule_PhoneScenes_P_DialPad;
    break;
  case 101:
    PreviousActiveStateForOPT = AppHmi_PhoneModule_PhoneScenes_P_DialPad;
    break;
  case 102:
    CurrentView = AppHmi_PhoneModule_PhoneScenes_P_CallList_Loading;
    break;
  case 103:
    PreviousActiveStateForPhoneSelection = AppHmi_PhoneModule_PhoneScenes_P_CallList_Loading;
    break;
  case 104:
    PreviousActiveStateForCallAction = AppHmi_PhoneModule_PhoneScenes_P_CallList_Loading;
    break;
  case 105:
    PreviousActiveStateForOPT = AppHmi_PhoneModule_PhoneScenes_P_CallList_Loading;
    break;
  case 106:
    WasCallListLoadingActive = 0;
    break;
  case 107:
    PreviousScreenEntryBTVR = AppHmi_PhoneModule_PhoneScenes_P_CallList;
    break;
  case 108:
    PreviousScreenEntry = AppHmi_PhoneModule_PhoneScenes_P_CallList;
    break;
  case 109:
    CurrentView = AppHmi_PhoneModule_PhoneScenes_P_CallList;
    break;
  case 110:
    PreviousActiveStateForPhoneSelection = AppHmi_PhoneModule_PhoneScenes_P_CallList;
    break;
  case 111:
    PreviousActiveStateForCallAction = AppHmi_PhoneModule_PhoneScenes_P_CallList;
    break;
  case 112:
    PreviousActiveStateForOPT = AppHmi_PhoneModule_PhoneScenes_P_CallList;
    break;
  case 113:
    ListViewID = 2;
    break;
  case 114:
    PreviousScreenEntryBTVR = AppHmi_PhoneModule_PhoneScenes_P_Contacts;
    break;
  case 115:
    PreviousScreenEntry = AppHmi_PhoneModule_PhoneScenes_P_Contacts;
    break;
  case 116:
    CurrentView = AppHmi_PhoneModule_PhoneScenes_P_Contacts;
    break;
  case 117:
    PreviousActiveStateForCallAction = AppHmi_PhoneModule_PhoneScenes_P_Contacts;
    break;
  case 118:
    PreviousActiveStateForPhoneSelection = AppHmi_PhoneModule_PhoneScenes_P_Contacts;
    break;
  case 119:
    PreviousActiveStateForOPT = AppHmi_PhoneModule_PhoneScenes_P_Contacts;
    break;
  case 120:
    ListViewID = 3;
    break;
  case 121:
    CurrentView = AppHmi_PhoneModule_PhoneScenes_P_Contacts_Loading;
    break;
  case 122:
    PreviousActiveStateForPhoneSelection = AppHmi_PhoneModule_PhoneScenes_P_Contacts_Loading;
    break;
  case 123:
    PreviousActiveStateForCallAction = AppHmi_PhoneModule_PhoneScenes_P_Contacts_Loading;
    break;
  case 124:
    PreviousActiveStateForOPT = AppHmi_PhoneModule_PhoneScenes_P_Contacts_Loading;
    break;
  case 125:
    WasContactListLoadingActive = 1;
    break;
  case 126:
    CurrentView = AppHmi_PhoneModule_PhoneScenes_P_Contacts_Call;
    break;
  case 127:
    PreviousActiveStateForPhoneSelection = AppHmi_PhoneModule_PhoneScenes_P_Contacts_Call;
    break;
  case 128:
    PreviousActiveStateForCallAction = AppHmi_PhoneModule_PhoneScenes_P_Contacts_Call;
    break;
  case 129:
    PreviousActiveStateForOPT = AppHmi_PhoneModule_PhoneScenes_P_Contacts_Call;
    break;
  case 130:
    ListViewID = 4;
    break;
  case 131:
    CurrentView = AppHmi_PhoneModule_PhoneScenes_P_Call_Disconnecting;
    break;
  case 132:
    CurrentView = AppHmi_PhoneModule_PhoneScenes_P_Call_DialPad;
    break;
  case 133:
    IsDTMFActive = 1;
    break;
  case 134:
    CurrentView = AppHmi_PhoneModule_PhoneScenes_P_MultipleCall_DialPad;
    break;
  case 135:
    CurrentView = AppHmi_PhoneModule_PhoneScenes_P_SR_SIRI_Main;
    break;
  case 136:
    PreviousScreenEntryBTVR = AppHmi_PhoneModule_PhoneScenes_P_OPT_SETTINGS;
    break;
  case 137:
    PreviousScreenEntry = AppHmi_PhoneModule_PhoneScenes_I_Contacts;
    break;
  case 138:
    CurrentView = AppHmi_PhoneModule_PhoneScenes_I_Contacts;
    break;
  case 139:
    CurrentView = AppHmi_PhoneModule_PhoneScenes_I_Call_Connecting;
    break;
  case 140:
    IntercomCallScreenInfo = 2;
    break;
  case 141:
    CurrentView = AppHmi_PhoneModule_PhoneScenes_P_IntercomCall;
    break;
  case 142:
    IntercomCallScreenInfo = 3;
    break;
  case 143:
    CurrentView = AppHmi_PhoneModule_PhoneScenes_P_Intercom_ConferenceCall;
    break;
  case 144:
    IntercomCallScreenInfo = 4;
    break;
  case 145:
    PhoneBookDownloadStatus = 0;
    break;
  case 146:
    CallListDownloadStatus = 0;
    break;
  case 147:
    IsDeviceReseted = 1;
    break;
  case 148:
    IsSMSActive = 1;
    break;
  case 149:
    PhoneBookDownloadStatus = 2;
    break;
  case 150:
    PhoneBookDownloadStatus = 1;
    break;
  case 151:
    CallListDownloadStatus = 2;
    break;
  case 152:
    CallListDownloadStatus = 1;
    break;
  case 153:
    CallStatus = 0;
    break;
  case 154:
    IsHomeScreenActive = 0;
    break;
  case 155:
    IsHomeScreenActive = 1;
    break;
  case 156:
    IsDeviceConnectingActive = 0;
    break;
  case 157:
    IsAppActivatedInternally = 0;
    break;
  case 158:
    RequestEntryState = Enum_EntryRequest_ToPhoneSelection;
    break;
  case 159:
    RequestEntryState = Enum_EntryRequest_ToCallList;
    break;
  case 160:
    CurrentView = AppHmi_PhoneModule_Gadget_Phone_MASTER__GADGET_PHONE;
    break;
  case 161:
    CurrentView = AppHmi_PhoneModule_Gadget_Phone_MASTER__GADGET_PHONE_Smart;
    break;
  case 162:
    CurrentView = AppHmi_PhoneModule_Gadget_Phone_MASTER__GADGET_PHONE_NON_NAVI;
    break;
  case 163:
    IsReadAloudActive = 1;
    break;
  case 164:
    IsContactListPersistent = 0;
    break;
  case 165:
    CurrentView = 0;
    break;
  case 166:
    PreviousCallStaus = CallStatus;
    break;
  case 167:
    CallStatus = 7;
    break;
  case 168:
    CallStatus = 5;
    break;
  case 169:
    CallStatus = 6;
    break;
  case 170:
    CallStatus = 8;
    break;
  case 171:
    CallStatus = 3;
    break;
  case 172:
    CallStatus = 1;
    break;
  case 173:
    CallStatus = 2;
    break;
  case 174:
    CallStatus = 4;
    break;
  case 175:
    IsAppActivatedInternally = 1;
    break;
  case 176:
    IntercomCallScreenInfo = 0;
    break;
  case 177:
    IsDeviceInDiscoverableMode = 1;
    break;
  case 178:
    IsParingActive = 1;
    break;
  case 179:
    IsDeviceReseted = 0;
    break;
  case 180:
    IsDialed = 1;
    break;
  case 181:
    ContactsCallListNotPersistant = 1;
    break;
  case 182:
    WasContactListLoadingActive = 0;
    break;
  case 183:
    IsContactsBackSelected = 0;
    break;
  case 184:
    ContactsCallListNotPersistant = 0;
    break;
  case 185:
    gacViewHideReq(AppHmi_PhoneModule_Gadget_Phone_MASTER__GADGET_PHONE);
    break;
  case 186:
    gacViewDestroyReq(AppHmi_PhoneModule_Gadget_Phone_MASTER__GADGET_PHONE);
    break;
  case 187:
    gacViewHideAndDestroyReq(AppHmi_PhoneModule_Gadget_Phone_MASTER__GADGET_PHONE_NON_NAVI);
    break;
  case 188:
    gacViewHideAndDestroyReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PriorityCall_BT);
    break;
  case 189:
    gacViewHideAndDestroyReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PriorityCall_Intercom);
    break;
  case 190:
    gacViewHideAndDestroyReq(AppHmi_PhoneModule_Sys_Popup_Pfo_MIC_PhoneCall);
    break;
  case 191:
    gacViewHideAndDestroyReq(AppHmi_PhoneModule_Sys_Popup_Pfo_MIC_IntercomCall);
    break;
  case 192:
    gacViewHideAndDestroyReq(AppHmi_PhoneModule_Sys_Popup_Pfo_MIC_CallHistory_Contacts);
    break;
  case 193:
    gacViewDestroyReq(AppHmi_PhoneModule_Sys_Popup_Pfo_Intercom_RTP_stream_failure);
    break;
  case 194:
    gacViewDestroyReq(AppHmi_PhoneModule_Sys_Popup_Pfo_Intercom_IncomingCall);
    break;
  case 195:
    gacViewHideAndDestroyReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PassiveDeviceIncomingCall);
    break;
  case 196:
    gacViewHideAndDestroyReq(AppHmi_PhoneModule_Sys_Popup_SR_SIRI_Main);
    break;
  case 197:
    gacViewHideAndDestroyReq(AppHmi_PhoneModule_Sys_Popup_Pfo_ConnectionFailed);
    break;
  case 198:
    gacViewHideAndDestroyReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PhonebookDLFailed);
    break;
  case 199:
    gacViewHideAndDestroyReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PhonebookDLIncomplete);
    break;
  case 200:
    gacViewDestroyReq(AppHmi_PhoneModule_Sys_Popup_Pfo_SIRI_EyeFree);
    break;
  case 201:
    gacViewDestroyReq(AppHmi_PhoneModule_Sys_Popup_Pfo_DeviceConnected);
    break;
  case 202:
    gacViewDestroyReq(AppHmi_PhoneModule_Sys_Popup_Pfo_DeviceDisConnected);
    break;
  case 203:
    gacViewHideAndDestroyReq(AppHmi_PhoneModule_Sys_Popup_Pfo_SMSExpand);
    break;
  case 204:
    gacViewHideAndDestroyReq(AppHmi_PhoneModule_Sys_Popup_Pfo_SMS);
    break;
  case 205:
    gacViewHideAndDestroyReq(AppHmi_PhoneModule_Sys_Popup_Pfo_IncomingCall);
    break;
  case 206:
    gacViewDestroyReq(AppHmi_PhoneModule_App_Popup_Pfo_DeviceConnecting);
    break;
  case 207:
    gacViewDestroyReq(AppHmi_PhoneModule_App_Popup_Pfo_DeviceDeleting);
    break;
  case 208:
    gacViewDestroyReq(AppHmi_PhoneModule_App_Popup_Pfo_DeviceDeleted);
    break;
  case 209:
    gacViewDestroyReq(AppHmi_PhoneModule_App_Popup_Pfo_DeleteDeviceConfirmation);
    break;
  case 210:
    gacViewDestroyReq(AppHmi_PhoneModule_App_Popup_Pfo_WaitForConfirmation);
    break;
  case 211:
    gacViewDestroyReq(AppHmi_PhoneModule_App_Popup_Pfo_NumCompPairing);
    break;
  case 212:
    gacViewDestroyReq(AppHmi_PhoneModule_App_Popup_Pfo_JustWorksPairingWaiting);
    break;
  case 213:
    gacViewDestroyReq(AppHmi_PhoneModule_App_Popup_Pfo_JustWorksPairing);
    break;
  case 214:
    gacViewDestroyReq(AppHmi_PhoneModule_App_Popup_Pfo_DeviceListFull);
    break;
  case 215:
    gacViewDestroyReq(AppHmi_PhoneModule_App_Popup_Pfo_DeviceDisconnectConfirmation);
    break;
  case 216:
    gacPopupSBCloseReq(AppHmi_PhoneModule_Sys_Popup_SR_SIRI_Main);
    break;
  case 217:
    gacPopupSBCloseReq(AppHmi_PhoneModule_Sys_Popup_Pfo_IncomingCall);
    break;
  case 218:
    gacPopupSBCloseReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PassiveDeviceIncomingCall);
    break;
  case 219:
    gacPopupCreateAndSBShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_IncomingCall);
    break;
  case 220:
    gacPopupCreateAndSBShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PassiveDeviceIncomingCall);
    break;
  case 221:
    gacPopupCreateAndSBShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_Intercom_IncomingCall);
    break;
  case 222:
    gacPopupCreateAndSBShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_Intercom_RTP_stream_failure);
    break;
  case 223:
    gacPopupCreateAndSBShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_MIC_CallHistory_Contacts);
    break;
  case 224:
    gacPopupSBCloseReq(AppHmi_PhoneModule_Sys_Popup_Pfo_Intercom_IncomingCall);
    break;
  case 225:
    gacPopupCreateAndSBShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_MIC_IntercomCall);
    break;
  case 226:
    gacPopupCreateAndSBShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_MIC_PhoneCall);
    break;
  case 227:
    gacPopupCreateAndSBShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PriorityCall_BT);
    break;
  case 228:
    gacPopupCreateAndSBShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PriorityCall_Intercom);
    break;
  case 229:
    gacViewHideReq(AppHmi_PhoneModule_App_Popup_Pfo_DeviceConnecting);
    break;
  case 230:
    gacViewClearReq(AppHmi_PhoneModule_App_Popup_Pfo_DeviceConnecting);
    break;
  case 231:
    gacViewHideReq(AppHmi_PhoneModule_App_Popup_Pfo_DeviceDeleting);
    break;
  case 232:
    gacViewClearReq(AppHmi_PhoneModule_App_Popup_Pfo_DeviceDeleting);
    break;
  case 233:
    gacViewHideReq(AppHmi_PhoneModule_App_Popup_Pfo_DeviceDeleted);
    break;
  case 234:
    gacViewClearReq(AppHmi_PhoneModule_App_Popup_Pfo_DeviceDeleted);
    break;
  case 235:
    gacViewHideReq(AppHmi_PhoneModule_App_Popup_Pfo_DeleteDeviceConfirmation);
    break;
  case 236:
    gacViewClearReq(AppHmi_PhoneModule_App_Popup_Pfo_DeleteDeviceConfirmation);
    break;
  case 237:
    gacViewHideReq(AppHmi_PhoneModule_App_Popup_Pfo_WaitForConfirmation);
    break;
  case 238:
    gacViewClearReq(AppHmi_PhoneModule_App_Popup_Pfo_WaitForConfirmation);
    break;
  case 239:
    gacViewHideReq(AppHmi_PhoneModule_App_Popup_Pfo_PairingInitiate);
    break;
  case 240:
    gacViewClearReq(AppHmi_PhoneModule_App_Popup_Pfo_PairingInitiate);
    break;
  case 241:
    gacViewHideReq(AppHmi_PhoneModule_App_Popup_Pfo_NumCompPairing);
    break;
  case 242:
    gacViewClearReq(AppHmi_PhoneModule_App_Popup_Pfo_NumCompPairing);
    break;
  case 243:
    gacViewHideReq(AppHmi_PhoneModule_App_Popup_Pfo_JustWorksPairingWaiting);
    break;
  case 244:
    gacViewClearReq(AppHmi_PhoneModule_App_Popup_Pfo_JustWorksPairingWaiting);
    break;
  case 245:
    gacViewHideReq(AppHmi_PhoneModule_App_Popup_Pfo_JustWorksPairing);
    break;
  case 246:
    gacViewClearReq(AppHmi_PhoneModule_App_Popup_Pfo_JustWorksPairing);
    break;
  case 247:
    gacViewHideReq(AppHmi_PhoneModule_App_Popup_Pfo_DeviceListFull);
    break;
  case 248:
    gacViewClearReq(AppHmi_PhoneModule_App_Popup_Pfo_DeviceListFull);
    break;
  case 249:
    gacViewHideReq(AppHmi_PhoneModule_App_Popup_Pfo_DeviceDisconnectConfirmation);
    break;
  case 250:
    gacViewClearReq(AppHmi_PhoneModule_App_Popup_Pfo_DeviceDisconnectConfirmation);
    break;
  case 251:
    gacPopupSBCloseReq(AppHmi_PhoneModule_App_Popup_Pfo_DeviceDeleting);
    break;
  case 252:
    gacPopupSBCloseReq(AppHmi_PhoneModule_App_Popup_Pfo_PairingInitiate);
    break;
  case 253:
    gacPopupCreateAndSBShowReq(AppHmi_PhoneModule_App_Popup_Pfo_JustWorksPairing);
    break;
  case 254:
    gacPopupCreateAndSBShowReq(AppHmi_PhoneModule_App_Popup_Pfo_NumCompPairing);
    break;
  case 255:
    gacPopupSBCloseReq(AppHmi_PhoneModule_App_Popup_Pfo_NumCompPairing);
    break;
  case 256:
    gacPopupSBCloseReq(AppHmi_PhoneModule_App_Popup_Pfo_JustWorksPairing);
    break;
  case 257:
    gacPopupSBCloseReq(AppHmi_PhoneModule_App_Popup_Pfo_WaitForConfirmation);
    break;
  case 258:
    gacPopupSBCloseReq(AppHmi_PhoneModule_App_Popup_Pfo_JustWorksPairingWaiting);
    break;
  case 259:
    gacPopupSBCloseReq(AppHmi_PhoneModule_App_Popup_Pfo_DeviceConnecting);
    break;
  case 260:
    gacViewHideReq(CurrentView);
    break;
  case 261:
    gacViewDestroyReq(CurrentView);
    break;
  case 262:
    gacViewHideReq(AppHmi_PhoneModule_PhoneScenes_P_Call_Connecting);
    break;
  case 263:
    gacViewDestroyReq(AppHmi_PhoneModule_PhoneScenes_P_Call_Connecting);
    break;
  case 264:
    gacViewHideReq(AppHmi_PhoneModule_PhoneScenes_P_Call_Disconnecting);
    break;
  case 265:
    gacViewDestroyReq(AppHmi_PhoneModule_PhoneScenes_P_Call_Disconnecting);
    break;
  case 266:
    gacViewHideReq(AppHmi_PhoneModule_PhoneScenes_P_Call);
    break;
  case 267:
    gacViewDestroyReq(AppHmi_PhoneModule_PhoneScenes_P_Call);
    break;
  case 268:
    gacViewHideReq(AppHmi_PhoneModule_PhoneScenes_P_Call_DialPad);
    break;
  case 269:
    gacViewDestroyReq(AppHmi_PhoneModule_PhoneScenes_P_Call_DialPad);
    break;
  case 270:
    gacViewHideReq(AppHmi_PhoneModule_PhoneScenes_P_MultipleCall);
    break;
  case 271:
    gacViewDestroyReq(AppHmi_PhoneModule_PhoneScenes_P_MultipleCall);
    break;
  case 272:
    gacViewHideReq(AppHmi_PhoneModule_PhoneScenes_P_MultipleCall_DialPad);
    break;
  case 273:
    gacViewDestroyReq(AppHmi_PhoneModule_PhoneScenes_P_MultipleCall_DialPad);
    break;
  case 274:
    gacViewHideReq(AppHmi_PhoneModule_PhoneScenes_P_SR_SIRI_Main);
    break;
  case 275:
    gacViewDestroyReq(AppHmi_PhoneModule_PhoneScenes_P_SR_SIRI_Main);
    break;
  case 276:
    gacViewHideAndDestroyReq(AppHmi_PhoneModule_PhoneScenes_P_OPT_SETTINGS);
    break;
  case 277:
    gacViewHideReq(AppHmi_PhoneModule_PhoneScenes_I_Contacts);
    break;
  case 278:
    gacViewDestroyReq(AppHmi_PhoneModule_PhoneScenes_I_Contacts);
    break;
  case 279:
    gacViewHideReq(AppHmi_PhoneModule_PhoneScenes_P_IntercomCall);
    break;
  case 280:
    gacViewDestroyReq(AppHmi_PhoneModule_PhoneScenes_P_IntercomCall);
    break;
  case 281:
    gacViewHideReq(AppHmi_PhoneModule_PhoneScenes_I_Call_Connecting);
    break;
  case 282:
    gacViewDestroyReq(AppHmi_PhoneModule_PhoneScenes_I_Call_Connecting);
    break;
  case 283:
    gacViewHideReq(AppHmi_PhoneModule_PhoneScenes_P_Intercom_ConferenceCall);
    break;
  case 284:
    gacViewDestroyReq(AppHmi_PhoneModule_PhoneScenes_P_Intercom_ConferenceCall);
    break;
  case 285:
    gacViewCreateReq(AppHmi_PhoneModule_PhoneScenes_P_Call);
    break;
  case 286:
    gacViewShowReq(AppHmi_PhoneModule_PhoneScenes_P_Call);
    break;
  case 287:
    gacViewCreateReq(AppHmi_PhoneModule_PhoneScenes_P_Call_Connecting);
    break;
  case 288:
    gacViewShowReq(AppHmi_PhoneModule_PhoneScenes_P_Call_Connecting);
    break;
  case 289:
    gacViewCreateReq(AppHmi_PhoneModule_PhoneScenes_P_MultipleCall);
    break;
  case 290:
    gacViewShowReq(AppHmi_PhoneModule_PhoneScenes_P_MultipleCall);
    break;
  case 291:
    gacViewCreateReq(CurrentView);
    break;
  case 292:
    gacViewShowReq(CurrentView);
    break;
  case 293:
    gacViewCreateReq(AppHmi_PhoneModule_PhoneScenes_P_Call_Disconnecting);
    break;
  case 294:
    gacViewShowReq(AppHmi_PhoneModule_PhoneScenes_P_Call_Disconnecting);
    break;
  case 295:
    gacViewCreateReq(AppHmi_PhoneModule_PhoneScenes_P_Call_DialPad);
    break;
  case 296:
    gacViewShowReq(AppHmi_PhoneModule_PhoneScenes_P_Call_DialPad);
    break;
  case 297:
    gacViewCreateReq(AppHmi_PhoneModule_PhoneScenes_P_MultipleCall_DialPad);
    break;
  case 298:
    gacViewShowReq(AppHmi_PhoneModule_PhoneScenes_P_MultipleCall_DialPad);
    break;
  case 299:
    gacViewCreateReq(AppHmi_PhoneModule_PhoneScenes_P_SR_SIRI_Main);
    break;
  case 300:
    gacViewShowReq(AppHmi_PhoneModule_PhoneScenes_P_SR_SIRI_Main);
    break;
  case 301:
    gacViewCreateAndShowReq(AppHmi_PhoneModule_PhoneScenes_P_OPT_SETTINGS);
    break;
  case 302:
    gacViewCreateReq(AppHmi_PhoneModule_PhoneScenes_I_Contacts);
    break;
  case 303:
    gacViewShowReq(AppHmi_PhoneModule_PhoneScenes_I_Contacts);
    break;
  case 304:
    gacViewCreateReq(AppHmi_PhoneModule_PhoneScenes_I_Call_Connecting);
    break;
  case 305:
    gacViewShowReq(AppHmi_PhoneModule_PhoneScenes_I_Call_Connecting);
    break;
  case 306:
    gacViewCreateReq(AppHmi_PhoneModule_PhoneScenes_P_IntercomCall);
    break;
  case 307:
    gacViewShowReq(AppHmi_PhoneModule_PhoneScenes_P_IntercomCall);
    break;
  case 308:
    gacViewCreateReq(AppHmi_PhoneModule_PhoneScenes_P_Intercom_ConferenceCall);
    break;
  case 309:
    gacViewShowReq(AppHmi_PhoneModule_PhoneScenes_P_Intercom_ConferenceCall);
    break;
  case 310:
    gacPopupCreateAndSBShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_DeviceConnected);
    break;
  case 311:
    gacPopupCreateAndSBShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_SMS);
    break;
  case 312:
    gacPopupCreateAndSBShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PhonebookDLFailed);
    break;
  case 313:
    gacViewHideAndDestroyReq(AppHmi_PhoneModule_App_Popup_Pfo_DeviceDeleting);
    break;
  case 314:
    gacPopupCreateAndSBShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_DeviceDisConnected);
    break;
  case 315:
    gacPopupCreateAndSBShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_ConnectionFailed);
    break;
  case 316:
    gacPopupCreateAndSBShowReq(AppHmi_PhoneModule_App_Popup_Pfo_DeviceConnecting);
    break;
  case 317:
    ActivatePhoneGadgetResponse(0);
    break;
  case 318:
    ActivatePhoneGadgetResponse(1);
    break;
  case 319:
    ActivatePhoneGadgetResponse(2);
    break;
  case 320:
    ActivatePhoneGadgetResponse(10);
    break;
  case 321:
    ActivatePhoneGadgetResponse(11);
    break;
  case 322:
    gacViewCreateReq(AppHmi_PhoneModule_Gadget_Phone_MASTER__GADGET_PHONE);
    break;
  case 323:
    gacViewShowReq(AppHmi_PhoneModule_Gadget_Phone_MASTER__GADGET_PHONE);
    break;
  case 324:
    gacViewCreateAndShowReq(AppHmi_PhoneModule_Gadget_Phone_MASTER__GADGET_PHONE_Smart);
    break;
  case 325:
    gacViewCreateReq(AppHmi_PhoneModule_Gadget_Phone_MASTER__GADGET_PHONE_NON_NAVI);
    break;
  case 326:
    gacViewShowReq(AppHmi_PhoneModule_Gadget_Phone_MASTER__GADGET_PHONE_NON_NAVI);
    break;
  case 327:
    gacViewHideAndDestroyReq(AppHmi_PhoneModule_Gadget_Phone_MASTER__GADGET_PHONE_Smart);
    break;
  case 328:
    gacViewHideReq(AppHmi_PhoneModule_Gadget_Phone_MASTER__GADGET_PHONE_NON_NAVI);
    break;
  case 329:
    gacViewDestroyReq(AppHmi_PhoneModule_Gadget_Phone_MASTER__GADGET_PHONE_NON_NAVI);
    break;
  case 330:
    gacViewHideReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PriorityCall_BT);
    break;
  case 331:
    gacViewClearReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PriorityCall_BT);
    break;
  case 332:
    gacPopupSBCloseReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PriorityCall_BT);
    break;
  case 333:
    gacViewCreateReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PriorityCall_BT);
    break;
  case 334:
    gacViewShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PriorityCall_BT);
    break;
  case 335:
    gacViewHideReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PriorityCall_Intercom);
    break;
  case 336:
    gacViewClearReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PriorityCall_Intercom);
    break;
  case 337:
    gacPopupSBCloseReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PriorityCall_Intercom);
    break;
  case 338:
    gacViewCreateReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PriorityCall_Intercom);
    break;
  case 339:
    gacViewShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PriorityCall_Intercom);
    break;
  case 340:
    gacViewHideReq(AppHmi_PhoneModule_Sys_Popup_Pfo_MIC_PhoneCall);
    break;
  case 341:
    gacViewClearReq(AppHmi_PhoneModule_Sys_Popup_Pfo_MIC_PhoneCall);
    break;
  case 342:
    gacViewCreateReq(AppHmi_PhoneModule_Sys_Popup_Pfo_MIC_PhoneCall);
    break;
  case 343:
    gacViewShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_MIC_PhoneCall);
    break;
  case 344:
    gacViewHideReq(AppHmi_PhoneModule_Sys_Popup_Pfo_MIC_IntercomCall);
    break;
  case 345:
    gacViewClearReq(AppHmi_PhoneModule_Sys_Popup_Pfo_MIC_IntercomCall);
    break;
  case 346:
    gacViewCreateReq(AppHmi_PhoneModule_Sys_Popup_Pfo_MIC_IntercomCall);
    break;
  case 347:
    gacViewShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_MIC_IntercomCall);
    break;
  case 348:
    gacViewHideReq(AppHmi_PhoneModule_Sys_Popup_Pfo_MIC_CallHistory_Contacts);
    break;
  case 349:
    gacViewClearReq(AppHmi_PhoneModule_Sys_Popup_Pfo_MIC_CallHistory_Contacts);
    break;
  case 350:
    gacViewCreateReq(AppHmi_PhoneModule_Sys_Popup_Pfo_MIC_CallHistory_Contacts);
    break;
  case 351:
    gacViewShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_MIC_CallHistory_Contacts);
    break;
  case 352:
    gacViewHideReq(AppHmi_PhoneModule_Sys_Popup_Pfo_Intercom_RTP_stream_failure);
    break;
  case 353:
    gacViewClearReq(AppHmi_PhoneModule_Sys_Popup_Pfo_Intercom_RTP_stream_failure);
    break;
  case 354:
    gacViewShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_Intercom_RTP_stream_failure);
    break;
  case 355:
    gacViewHideReq(AppHmi_PhoneModule_Sys_Popup_Pfo_Intercom_IncomingCall);
    break;
  case 356:
    gacViewClearReq(AppHmi_PhoneModule_Sys_Popup_Pfo_Intercom_IncomingCall);
    break;
  case 357:
    gacViewHideReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PassiveDeviceIncomingCall);
    break;
  case 358:
    gacViewClearReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PassiveDeviceIncomingCall);
    break;
  case 359:
    gacViewHideReq(AppHmi_PhoneModule_Sys_Popup_SR_SIRI_Main);
    break;
  case 360:
    gacViewClearReq(AppHmi_PhoneModule_Sys_Popup_SR_SIRI_Main);
    break;
  case 361:
    gacViewHideReq(AppHmi_PhoneModule_Sys_Popup_Pfo_ConnectionFailed);
    break;
  case 362:
    gacViewClearReq(AppHmi_PhoneModule_Sys_Popup_Pfo_ConnectionFailed);
    break;
  case 363:
    gacViewHideReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PhonebookDLFailed);
    break;
  case 364:
    gacViewClearReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PhonebookDLFailed);
    break;
  case 365:
    gacViewHideReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PhonebookDLIncomplete);
    break;
  case 366:
    gacViewClearReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PhonebookDLIncomplete);
    break;
  case 367:
    gacViewHideReq(AppHmi_PhoneModule_Sys_Popup_Pfo_SIRI_EyeFree);
    break;
  case 368:
    gacViewClearReq(AppHmi_PhoneModule_Sys_Popup_Pfo_SIRI_EyeFree);
    break;
  case 369:
    gacViewHideReq(AppHmi_PhoneModule_Sys_Popup_Pfo_DeviceConnected);
    break;
  case 370:
    gacViewClearReq(AppHmi_PhoneModule_Sys_Popup_Pfo_DeviceConnected);
    break;
  case 371:
    gacViewHideReq(AppHmi_PhoneModule_Sys_Popup_Pfo_DeviceDisConnected);
    break;
  case 372:
    gacViewClearReq(AppHmi_PhoneModule_Sys_Popup_Pfo_DeviceDisConnected);
    break;
  case 373:
    gacViewHideReq(AppHmi_PhoneModule_Sys_Popup_Pfo_SMSExpand);
    break;
  case 374:
    gacViewClearReq(AppHmi_PhoneModule_Sys_Popup_Pfo_SMSExpand);
    break;
  case 375:
    gacViewHideReq(AppHmi_PhoneModule_Sys_Popup_Pfo_SMS);
    break;
  case 376:
    gacViewClearReq(AppHmi_PhoneModule_Sys_Popup_Pfo_SMS);
    break;
  case 377:
    gacViewHideReq(AppHmi_PhoneModule_Sys_Popup_Pfo_IncomingCall);
    break;
  case 378:
    gacViewClearReq(AppHmi_PhoneModule_Sys_Popup_Pfo_IncomingCall);
    break;
  case 379:
    gacViewShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_Intercom_IncomingCall);
    break;
  case 380:
    gacViewCreateReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PassiveDeviceIncomingCall);
    break;
  case 381:
    gacViewShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PassiveDeviceIncomingCall);
    break;
  case 382:
    gacViewCreateReq(AppHmi_PhoneModule_Sys_Popup_SR_SIRI_Main);
    break;
  case 383:
    gacViewShowReq(AppHmi_PhoneModule_Sys_Popup_SR_SIRI_Main);
    break;
  case 384:
    gacViewCreateReq(AppHmi_PhoneModule_Sys_Popup_Pfo_ConnectionFailed);
    break;
  case 385:
    gacViewShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_ConnectionFailed);
    break;
  case 386:
    gacViewCreateReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PhonebookDLFailed);
    break;
  case 387:
    gacViewShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PhonebookDLFailed);
    break;
  case 388:
    gacPopupSBCloseReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PhonebookDLIncomplete);
    break;
  case 389:
    gacViewCreateReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PhonebookDLIncomplete);
    break;
  case 390:
    gacViewShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PhonebookDLIncomplete);
    break;
  case 391:
    gacViewCreateReq(AppHmi_PhoneModule_Sys_Popup_Pfo_SIRI_EyeFree);
    break;
  case 392:
    gacViewShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_SIRI_EyeFree);
    break;
  case 393:
    gacViewShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_DeviceConnected);
    break;
  case 394:
    gacViewShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_DeviceDisConnected);
    break;
  case 395:
    gacPopupSBCloseReq(AppHmi_PhoneModule_Sys_Popup_Pfo_SMSExpand);
    break;
  case 396:
    gacViewCreateReq(AppHmi_PhoneModule_Sys_Popup_Pfo_SMSExpand);
    break;
  case 397:
    gacViewShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_SMSExpand);
    break;
  case 398:
    gacPopupSBCloseReq(AppHmi_PhoneModule_Sys_Popup_Pfo_SMS);
    break;
  case 399:
    gacPopupCreateAndSBShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_SMSExpand);
    break;
  case 400:
    gacViewCreateReq(AppHmi_PhoneModule_Sys_Popup_Pfo_SMS);
    break;
  case 401:
    gacViewShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_SMS);
    break;
  case 402:
    acPostBeep(Enum_hmibase_BEEPTYPE_SMS_INCOMING);
    break;
  case 403:
    gacViewCreateReq(AppHmi_PhoneModule_Sys_Popup_Pfo_IncomingCall);
    break;
  case 404:
    gacViewShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_IncomingCall);
    break;
  case 405:
    gacViewShowReq(AppHmi_PhoneModule_App_Popup_Pfo_DeviceConnecting);
    break;
  case 406:
    gacPopupSBCloseReq(AppHmi_PhoneModule_App_Popup_Pfo_DeleteDeviceConfirmation);
    break;
  case 407:
    gacViewShowReq(AppHmi_PhoneModule_App_Popup_Pfo_DeviceDeleting);
    break;
  case 408:
    gacViewShowReq(AppHmi_PhoneModule_App_Popup_Pfo_DeviceDeleted);
    break;
  case 409:
    gacPopupCreateAndSBShowReq(AppHmi_PhoneModule_App_Popup_Pfo_DeviceDeleting);
    break;
  case 410:
    gacViewShowReq(AppHmi_PhoneModule_App_Popup_Pfo_DeleteDeviceConfirmation);
    break;
  case 411:
    gacViewCreateAndShowReq(AppHmi_PhoneModule_App_Popup_Pfo_WaitForConfirmation);
    break;
  case 412:
    gacViewDestroyReq(AppHmi_PhoneModule_App_Popup_Pfo_PairingInitiate);
    break;
  case 413:
    gacPopupCreateAndSBShowReq(AppHmi_PhoneModule_App_Popup_Pfo_DeviceListFull);
    break;
  case 414:
    gacViewShowReq(AppHmi_PhoneModule_App_Popup_Pfo_PairingInitiate);
    break;
  case 415:
    gacPopupCreateAndSBShowReq(AppHmi_PhoneModule_App_Popup_Pfo_WaitForConfirmation);
    break;
  case 416:
    gacViewCreateAndShowReq(AppHmi_PhoneModule_App_Popup_Pfo_NumCompPairing);
    break;
  case 417:
    gacViewCreateAndShowReq(AppHmi_PhoneModule_App_Popup_Pfo_JustWorksPairingWaiting);
    break;
  case 418:
    gacPopupCreateAndSBShowReq(AppHmi_PhoneModule_App_Popup_Pfo_JustWorksPairingWaiting);
    break;
  case 419:
    gacPopupSBCloseReq(AppHmi_PhoneModule_App_Popup_Pfo_DeviceListFull);
    break;
  case 420:
    gacViewShowReq(AppHmi_PhoneModule_App_Popup_Pfo_DeviceListFull);
    break;
  case 421:
    gacPopupSBCloseReq(AppHmi_PhoneModule_App_Popup_Pfo_DeviceDisconnectConfirmation);
    break;
  case 422:
    gacViewShowReq(AppHmi_PhoneModule_App_Popup_Pfo_DeviceDisconnectConfirmation);
    break;
  case 423:
    gacPopupCreateAndSBShowReq(AppHmi_PhoneModule_App_Popup_Pfo_DeleteDeviceConfirmation);
    break;
  case 424:
    gacPopupCreateAndSBShowReq(AppHmi_PhoneModule_App_Popup_Pfo_DeviceDisconnectConfirmation);
    break;
  case 425:
    gacPopupCreateAndSBShowReq(AppHmi_PhoneModule_App_Popup_Pfo_DeviceDeleted);
    break;
  case 426:
    gacPopupCreateAndSBShowReq(AppHmi_PhoneModule_App_Popup_Pfo_PairingInitiate);
    break;

  default:
    break;
  }
}
