/************************************************************************
*FILE: AppHmi_PhoneStateMachine.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(AppHmi_PhoneStateMachine_h)
#define AppHmi_PhoneStateMachine_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Courier/Platform/MessageFactory.h>
#include <Courier/Messaging/Message.h>
#include <AppHmi_PhoneStateMachineSEMLibB.h>
#include <AppHmi_PhoneStateMachineData.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Cit/VisualStateGlueLayer/DeductResult.h>
#ifdef CIT_SIMULATION
#include <json/value.h>
#endif
#include <AppHmi_PhoneTypes.h>
#include <AppHmi_PhoneMessages.h>
#include <AppHmi_PhoneConstants.h>
#include <AppHmi_PhoneDatabinding.h>
#include <AppHmi_PhoneViews.h>
#include <AppHmi_PhoneController.h>
// ------------------------------------------------------------------------
class AppHmi_PhoneStateMachineImpl : public AppHmi_PhoneStateMachine
{
public:
    typedef AppHmi_PhoneStateMachine Base;

#ifdef VISUALSTATE_7_TRACE
    // Mapping of data types of API to get rid of include dependencies
    //typedef SEM_ACTION_EXPRESSION_TYPE VS_Type_ActionExpression;
	using Base::VS_Type_ActionExpression;
    //typedef SEM_EVENT_TYPE VS_Type_Event;
	//typedef SEM_STATE_TYPE VS_Type_State;
	//typedef SEM_EXPLANATION_TYPE VS_Type_Explanation;
	//typedef SEM_STATE_MACHINE_TYPE VS_Type_Statemachine;
	using Base::VS_Type_Event;
	using Base::VS_Type_State;
	using Base::VS_Type_Explanation;
	using Base::VS_Type_Statemachine;

    // Mapping of enums and defines of API to get rid of include dependencies
    //enum { VS_Ret_Ok = SES_OKAY };
    //enum { VS_Ret_Found = SES_FOUND };
	enum { VS_Ret_Ok = Base::VS_Ret_Ok };
	enum { VS_Ret_Found = Base::VS_Ret_Found };
    enum { VS_Evt_Reset = SE_RESET };
    enum { VS_Ret_Error = SES_RANGE_ERR };
#else
#ifndef VISUALSTATE_HCODER
    typedef SEM_ACTION_EXPRESSION_TYPE VS_Type_ActionExpression;
    typedef SEM_EVENT_TYPE VS_Type_Event;
    typedef SEM_STATE_TYPE VS_Type_State;
    typedef SEM_EXPLANATION_TYPE VS_Type_Explanation;
    typedef SEM_STATE_MACHINE_TYPE VS_Type_Statemachine;
    enum { VS_Ret_Ok = SES_OKAY };
    enum { VS_Ret_Found = SES_FOUND };
    enum { VS_Evt_Reset = SE_RESET };
    enum { VS_Ret_Error = SES_RANGE_ERR };
#else
    enum { VS_Ret_Ok = 0U };
    enum { VS_Ret_Found = 1U };
    enum { VS_Evt_Reset = 0U };
    enum { VS_Ret_Error = 4U };
#endif
#endif
// ------------------------------------------------------------------------

    // Mapping of args passed as hashId to corresponding identifier
    static const ::FeatStd::Char *GetNameFromId(::FeatStd::UInt32 id);

// ------------------------------------------------------------------------
    virtual void Perform_AppHmi_PhoneModule_AddNewDevice();
    virtual void Perform_AppHmi_PhoneModule_DeviceListReq();
    virtual void Perform_AppHmi_PhoneModule_DeleteDeviceConfirmationReq();
    virtual void Perform_AppHmi_PhoneModule_DisconnectDeviceConfirmationReq();
    virtual void Perform_AppHmi_PhoneModule_BackButtonPressReq();
    virtual void Perform_AppHmi_PhoneModule_ResetCallListDataReq();
    virtual void Perform_AppHmi_PhoneModule_ResetContactListDataReq();
    virtual void Perform_AppHmi_PhoneModule_Pairing_No();
    virtual void Perform_AppHmi_PhoneModule_Pairing_Cancel();
    virtual void Perform_AppHmi_PhoneModule_Pairing_Yes();
    virtual void Perform_AppHmi_PhoneModule_AcceptCall();
    virtual void Perform_AppHmi_PhoneModule_RejectCall();
    virtual void Perform_Intercom_AcceptCall();
    virtual void Perform_Intercom_RejectCall();
    virtual void Perform_Intercom_RejectConfCall();
    virtual void Perform_IConference_RejectCall();
    virtual void Perform_AppHmi_PhoneModule_HangUpCall();
    virtual void Perform_AppHmi_PhoneModule_CancelDialing();
    virtual void Perform_AppHmi_PhoneModule_DialCall_Model();
    virtual void Perform_AppHmi_PhoneModule_CallListReq();
    virtual void Perform_AppHmi_PhoneModule_IContactsReq();
    virtual void Perform_AppHmi_PhoneModule_IntercomStatusMsg();
    virtual void Perform_AppHmi_PhoneModule_Handsfree_Status_ChangeReq();
    virtual void Perform_AppHmi_PhoneModule_Clear_EditFieldReq();
    virtual void Perform_AppHmi_PhoneModule_MicMute_Status_ChangeReq();
    virtual void Perform_AppHmi_PhoneModule_MessageCall();
    virtual void Perform_AppHmi_PhoneModule_SwapMultipleCallReq();
    virtual void Perform_AppHmi_PhoneModule_ChangeRingtoneSettingsReq();
    virtual void Perform_AppHmi_PhoneModule_ChangeSMSSettingsReq();
    virtual void Perform_AppHmi_PhoneModule_PlayReadMessageAloudReq();
    virtual void Perform_AppHmi_PhoneModule_StopReadMessageAloudReq();
    virtual void Perform_AppHmi_PhoneModule_MatchListEntryReq();
    virtual void Perform_AppHmi_PhoneModule_ContactDetailsListEntryReq();
    virtual void Perform_AppHmi_PhoneModule_ContactListReq_History();
    virtual void Perform_AppHmi_PhoneModule_ContactListReq_Begining();
    virtual void Perform_AppHmi_PhoneModule_Ringtone_Mute();
    virtual void Perform_Activate_SPI_Application();
    virtual void Perform_Activate_Listen();
    virtual void ActivatePhoneGadgetResponse(::FeatStd::Int8 aRequestType);
    virtual void Perform_Network_Operator_Req();
    virtual void Perform_Activate_Radio_Application();
    virtual void Perform_Activate_Media_Application();
    virtual void Perform_Activate_Media_Source_Selection();
    virtual void Perform_Activate_Home_Source();
    virtual void Phone_ActivityId();
    virtual void Perform_Activate_Navi_Application();
    virtual void Perform_Activate_BTPhone_Application_Call_List();
    virtual void Perform_Activate_BTPhone_Application_Contact_List();
    virtual void Perform_Activate_BTPhone_Application_Device_List();
    virtual void Perform_Activate_BTPhone_Application_Call_Connecting();
    virtual void Perform_Activate_BTPhone_Application_On_Call();
    virtual void Perform_Activate_BTPhone_Application_On_Multiparty_Call();
    virtual void Perform_Deactivate_BTPhone_Application();
    virtual void Activate_BT_SR_Session();
    virtual void Halt_BT_SR_Session();
    virtual void BTVROnExitAction();
    virtual void DeActivate_BT_SR_Session();
    virtual void Perform_Activate_BTPhone_Application_On_Intercomcall();
    virtual void Perform_AppHmi_PhoneModule_PrivateMode();
    virtual void Language_Update();
    virtual void gacChangeLanguageReq(::FeatStd::Int32 aLanguageId);
    virtual void gacHideFocusInViewReq(::FeatStd::UInt32 aView);
    virtual void NextLevelTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void PreviousLevelTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void DualViewLeftTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void DualViewRightTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void PageFlipBackTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void PageFlipFrontTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void ZoomInTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView, ::FeatStd::Int8 aPos);
    virtual void ZoomOutTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView, ::FeatStd::Int8 aPos);
    virtual void FadeTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void gacWaitAnimationStartReq();
    virtual void acFocusOnRightEncoderReqUpd(bool aIsFocusUsed);
    virtual void acSetGadgetSceenActiveStatus(bool aIsGadgetAtive);
    virtual void acHKNotificationMsg(::FeatStd::Int8 aHKCode, ::FeatStd::Int8 aHKState);
    virtual void acPerform_CloseAllDropdowns();
    virtual void acPerform_CloseDropdown(::FeatStd::UInt32 aListId);
    virtual void acPerform_OpenDropdown(::FeatStd::UInt32 aListId);
    virtual void acPerform_ToggleDropdown(::FeatStd::UInt32 aListId);
    virtual void acStartAppPopupTimer(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aTimeout);
    virtual void acStopAppPopupTimer(::FeatStd::UInt32 aViewId);
    virtual void acPostBeep(::FeatStd::Int8 aBeepType);
    virtual void gacCheckToClosePopup(::FeatStd::UInt32 aPopupId);
    virtual void acRestartAppPopupTimer(::FeatStd::UInt32 aViewId);
    virtual void gacContextSwitchBackRes(::FeatStd::UInt32 aSwitchId);
    virtual void gacContextSwitchCompleteRes(::FeatStd::UInt32 aSwitchId);
    virtual void gacContextSwitchFailedRes(::FeatStd::UInt32 aSwitchId);
    virtual void gacContextSwitchDoneRes(::FeatStd::UInt32 aSwitchId);
    virtual void gacContextSwitchOutReq(::FeatStd::UInt32 aTargetContextId, ::FeatStd::UInt32 aSourceContextId, ::FeatStd::UInt32 aTargetAppId);
    virtual void gacCurrentScreenDisplayReq();
    virtual void gacLaunchBarDisplayReq(bool aVisibility);
    virtual void gacNavTBTSwipe();
    virtual void gacPerformListBtnRightEncoderChangeUpd(::FeatStd::Int8 aSteps, ::FeatStd::UInt32 aListId, ::FeatStd::UInt32 aRowId, ::FeatStd::UInt32 aColumnId);
    virtual void gacScrollListUp();
    virtual void gacScrollListDown();
    virtual void gacScrollPageUp();
    virtual void gacScrollPageDown();
    virtual void gacScrollListFocusUp(::FeatStd::UInt32 aListId);
    virtual void gacScrollListFocusDown(::FeatStd::UInt32 aListId);
    virtual void gacPerformListFocusLockDataResetUpd();
    virtual void gacSetApplicationMode(::FeatStd::UInt32 aModeId);
    virtual void gacSpellerBbehaviorReq(bool aEnable);
    virtual void gacStatusBarDisplayReq(bool aVisibility, ::FeatStd::Int32 aHeaderType);
    virtual void gacTBTRetriggerAcousticOutput();
    virtual void gacWaitAnimationStopReq();
    virtual void gacViewCreateReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewCreateAllReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewDestroyReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewClearReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewShowReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewHideReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewCreateWithoutLoadReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewAsyncLoadReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewActivateWithoutRenderingReq(::FeatStd::UInt32 aViewId);
    virtual void gacPopupCreateAndSBShowReq(::FeatStd::UInt32 aViewId);
    virtual void gacPopupCreateAndSBShowReqForMultiDisplay(::FeatStd::UInt32 aPopupDisplayID, ::FeatStd::UInt32 aViewId);
    virtual void gacPopupSBCloseReq(::FeatStd::UInt32 aViewId);
    virtual void gacPopupSBCloseReqForMultiDisplay(::FeatStd::UInt32 aPopupDisplayID, ::FeatStd::UInt32 aViewId);
    virtual void gacPopupRestartTimerReq(::FeatStd::UInt32 aViewId);
    virtual void gacPopupRestartTimerReqForMultiDisplay(::FeatStd::UInt32 aPopupDisplayID, ::FeatStd::UInt32 aViewId);
    virtual void gacViewCreateAndShowReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewHideAndDestroyReq(::FeatStd::UInt32 aViewId);
    virtual void gacSceneTransitionEnter(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aHint);
    virtual void gacSceneTransitionLeave(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aHint);
    virtual void gacDisplayStatusLineReq(::FeatStd::Int32 aDisplayRegionType);
    virtual void gacHideStatusLineReq(::FeatStd::Int32 aDisplayRegionType);
    virtual void gacDisplayFooterLineReq();
    virtual void gacHideFooterLineReq();
    virtual void gacDisplayStatusLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID);
    virtual void gacHideStatusLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID);
    virtual void gacDisplayFooterLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID);
    virtual void gacHideFooterLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID);
    virtual void gacRegisterForCloseOnTouchSession(::FeatStd::UInt32 aViewId);
    virtual void gacDeregisterForCloseOnTouchSessionReq(::FeatStd::UInt32 aViewId);
    virtual void gacPopupFilterPrioEnableReq(::FeatStd::UInt32 aPrio);
    virtual void gacPopupFilterAllEnableReq();
    virtual void gacPopupFilterDisableReq();
    virtual void gacProfileChange(::FeatStd::Int8 aProfile);
    virtual void gacPopupFilterPrioEnableReqForDisplay(::FeatStd::UInt32 aPrio, ::FeatStd::UInt32 aDisplayID);
    virtual void gacPopupFilterAllEnableReqForDisplay(::FeatStd::UInt32 aDisplayID);
    virtual void gacPopupFilterDisableReqForDisplay(::FeatStd::UInt32 aDisplayID);
    virtual void gacStartSceneTransitionAnimation(::FeatStd::UInt32 aSourceView, ::FeatStd::UInt32 aDestinationView, ::FeatStd::UInt32 aUserData1, ::FeatStd::Int8 aUserData2);
    virtual void gacDecrementActiveAnimationCount();

#ifdef CIT_SIMULATION
    bool CallAction(const ::FeatStd::Char* actionName, const ::Json::Value& parameters, ::Json::Value &response);
    const ::FeatStd::Char* GetEventName(::FeatStd::UInt32 eventId, ::Courier::Message const & message, Json::Value& eventArgument);
#endif
    // Added function for deduction of one event to simplify the event loop
    bool HandleDataBindingEventMapping(::Courier::AbstractDataItemMsg const & message, ::FeatStd::UInt32& eventId) const;
    bool HandleEventMapping(::Courier::Message const & message, ::FeatStd::UInt32& eventId) const;

    ::Cit::DeductResult::Enum DeductEvent(::Courier::Message const & message, ::FeatStd::UInt32 eventId);

    //====  member function with TTFis output - added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====

	virtual unsigned short GetTraceClass();
	int GetNumberOfStatemachines();
    //====  member function with TTFis output - end                        key: SM_TTFis_SBHFMSRF ====
};

// ------------------------------------------------------------------------
bool SendAddNewDeviceReq();
bool SendDeviceListReq();
bool SendDeleteDeviceConfirmationReq();
bool SendDisconnectDeviceConfirmationReq();
bool SendOnBackButtonPressMsg();
bool SendResetListDataReq(Courier::UInt8 const & aListID);
bool SendSSPResponseReq(btphn_tenBTPairingResponse const & aPairingResponse);
bool SendIncomingCallResponseReq(btphn_tenPhoneIncomingCallResponse const & aCallStatus);
bool SendIntercomCallResponseReq(IntercomCallResponse const & aCallActionStatus);
bool SendTerminateIConfCall();
bool SendTerminateCallReq();
bool SendCancelDialCallReq();
bool SendDialCall_ModelReq();
bool SendCallListReq();
bool SendIContactsReq();
bool SendIntercomStatusMsg();
bool SendTransferVehicleAudioReq();
bool SendClearEditFieldRequestReq();
bool SendMicMuteStateReq();
bool SendMessageDialReq();
bool SendSwapMultipleCallReq();
bool SendChangeRingtoneSettingsReq();
bool SendChangeSMSSettingsReq();
bool SendReadMessageAloudReq(btphn_trMsgPlayBackAction const & aPlayBackAction);
bool SendMatchListEntryReq();
bool SendContactDetailsReq(Courier::UInt16 const & aContactListIndex);
bool SendContactListReq(bool const & aIsPersistencyRequired);
bool SendRingtoneMuteReq();
bool SendActivateSPIReq();
bool SendActivateListenReq();
bool SendPhoneGadgetRequestMsg(Courier::UInt8 const & aRequestType);
bool SendNetworkOperatorReq();
bool SendSwitchApplicationStateReq(Candera::UInt16 const & aApplicationID, Candera::UInt16 const & aApplicationState, Candera::UInt8 const & aActivityID);
bool SendSwitchApplicationReq(enApplicationId const & aApplicationID, enSurfaceId const & aSurfaceID);
bool SendViewPhoneActivityId();
bool SendBTVRSessionStartAppReqMsg();
bool SendBTVRSessionStopAppReqMsg();
bool SendBTVROnExitMsg();
bool SendBTVRSessionExitAppReqMsg();
bool SendPrivateModeUpdateMsg();
bool SendGuiStartupFinishedUpdMsg();
bool SendChangeLanguageReqMsg(enLanguageId const & aLanguageId);
bool SendFocusReqMsg(FocusActionEnum const & aAction, FocusTimerActionEnum const & aTimerAction, ::Courier::ViewId const & aView, Candera::String const & aWidget);
bool SendDummyMess(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos);
bool SendAnimationReqMsg(Courier::AnimationAction::Enum const & aAnimationAction, ::Courier::ViewId const & aViewId, Courier::CompositePath const & aCompositePath, ::Courier::ItemId const & aAnimationId, Courier::AnimationProperties const & aAnimationProperties);
bool SendFocusOnRightEncoderReqUpdMsg(bool const & aIsFocusUsed);
bool SendStoreActiveGadgetReqMsg(bool const & aIsGadgetAtive);
bool SendHardKeyPressNotificationMsg(Courier::UInt8 const & aDummy, Courier::UInt8 const & aHKCode, Courier::UInt8 const & aHKState);
bool SendDropdownChangeMsg(::Candera::DropdownChangeType const & aDropdownChangeType, ::Courier::UInt32 const & aListId);
bool SendStartPopupTimerReqMsg(Courier::UInt32 const & aViewId, Courier::UInt32 const & aTimeout);
bool SendStopPopupTimerReqMsg(Courier::UInt32 const & aViewId);
bool SendPlayBeepReqMsg(Courier::Int32 const & aBeepType);
bool SendCheckToClosePopupMsg(Courier::UInt32 const & aPopupId);
bool SendRestartPopupTimerReqMsg(Courier::UInt32 const & aViewId);
bool SendContextSwitchInResMsg(Courier::UInt32 const & aSwitchId, Courier::UInt32 const & aResponseType);
bool SendContextSwitchOutReqMsg(Courier::UInt32 const & aTargetContextId, Courier::UInt32 const & aSourceContextId, Courier::UInt32 const & aTargetAppId);
bool SendCurrentScreenDisplayReqMsg();
bool SendLaunchBarDisplayReqMsg(bool const & aVisibility);
bool SendNavTBTSwipeReqMsg();
bool SendListItemRightEncoderChangeUpdMsg(Courier::Int8 const & aSteps, Courier::UInt32 const & aListId, Courier::UInt32 const & aRowId, Courier::UInt32 const & aColumnId);
bool SendListChangeMsg(::Courier::UInt32 const & aListId, ListChangeType const & aListChangeType, ::Courier::Int32 const & aValue, ListChangeMsgSourceType const & aListChangeMsgSource, bool const & aImmediatePositioning);
bool SendListFocusScrollReqMsg(Courier::UInt32 const & aListId, Courier::Int32 const & aSteps);
bool SendListFocusLockDataResetReqMsg();
bool SendSetApplicationModeReqMsg(Courier::UInt32 const & aModeId);
bool SendSpellerBbehaviorReqMsg(bool const & aEnable);
bool SendStatusBarDisplayReqMsg(bool const & aVisibility, Courier::Int32 const & aHeaderType);
bool SendTBTRetriggerAcousticMsg();
bool SendViewReqMsg(Courier::ViewAction::Enum const & aViewAction, ::Courier::ViewId const & aViewId, bool const & aShallInitScene, bool const & aShallLoadScene);
bool SendActivationReqMsg(::Courier::ViewId const & aViewId, bool const & aActivation, bool const & aEnableRendering);
bool SendAsyncLoadReqMsg(::Courier::ViewId const & aViewId, bool const & aLoad);
bool SendPopupReqMsg(hmibase::popups::CommandEnum const & aCommand, ::Courier::ViewId const & aViewId, Courier::UInt32 const & aPopupDisplayID);
bool SendExtendedViewReqMsg(hmibase::views::CommandEnum const & aCommand, ::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint);
bool SendShowHMISubSurfaceReqMsg(hmibase::displayRegion const & aDisplayRegion, Courier::Int32 const & aDisplayRegionType, bool const & aShowSubSurface, Courier::UInt32 const & aDisplayID, bool const & aLockSubSurface);
bool SendRegisterForCloseOnTouchSessionReqMsg(bool const & aRegister, ::Courier::ViewId const & aViewId);
bool SendPopupFilterPrioEnableReqMsg(Courier::UInt32 const & aPrio);
bool SendPopupFilterAllEnableReqMsg();
bool SendPopupFilterDisableReqMsg();
bool SendProfileSwitchMsg(Courier::UInt32 const & aProfile);
bool SendMultiDisplayPopupFilterReqMsg(hmibase::PopupFilterType const & aPopupFilterType, Courier::UInt32 const & aPrio, Courier::UInt32 const & aDisplayID);
bool SendCreateNewDestroyOld(::Courier::ViewId const & aSourceView, ::Courier::ViewId const & aDestinationView, Courier::UInt32 const & aUserData1, Courier::Int8 const & aUserData2);
bool SendNotifierMessage();

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_AddNewDevice(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_AppHmi_PhoneModule_AddNewDevice();
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_DeviceListReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_AppHmi_PhoneModule_DeviceListReq();
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_DeleteDeviceConfirmationReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_AppHmi_PhoneModule_DeleteDeviceConfirmationReq();
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_DisconnectDeviceConfirmationReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_AppHmi_PhoneModule_DisconnectDeviceConfirmationReq();
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_BackButtonPressReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_AppHmi_PhoneModule_BackButtonPressReq();
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_ResetCallListDataReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_AppHmi_PhoneModule_ResetCallListDataReq();
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_ResetContactListDataReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_AppHmi_PhoneModule_ResetContactListDataReq();
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_Pairing_No(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_AppHmi_PhoneModule_Pairing_No();
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_Pairing_Cancel(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_AppHmi_PhoneModule_Pairing_Cancel();
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_Pairing_Yes(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_AppHmi_PhoneModule_Pairing_Yes();
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_AcceptCall(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_AppHmi_PhoneModule_AcceptCall();
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_RejectCall(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_AppHmi_PhoneModule_RejectCall();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Intercom_AcceptCall(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Intercom_AcceptCall();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Intercom_RejectCall(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Intercom_RejectCall();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Intercom_RejectConfCall(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Intercom_RejectConfCall();
#ifdef CIT_SIMULATION
bool CallAction_Perform_IConference_RejectCall(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_IConference_RejectCall();
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_HangUpCall(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_AppHmi_PhoneModule_HangUpCall();
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_CancelDialing(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_AppHmi_PhoneModule_CancelDialing();
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_DialCall_Model(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_AppHmi_PhoneModule_DialCall_Model();
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_CallListReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_AppHmi_PhoneModule_CallListReq();
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_IContactsReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_AppHmi_PhoneModule_IContactsReq();
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_IntercomStatusMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_AppHmi_PhoneModule_IntercomStatusMsg();
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_Handsfree_Status_ChangeReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_AppHmi_PhoneModule_Handsfree_Status_ChangeReq();
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_Clear_EditFieldReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_AppHmi_PhoneModule_Clear_EditFieldReq();
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_MicMute_Status_ChangeReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_AppHmi_PhoneModule_MicMute_Status_ChangeReq();
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_MessageCall(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_AppHmi_PhoneModule_MessageCall();
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_SwapMultipleCallReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_AppHmi_PhoneModule_SwapMultipleCallReq();
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_ChangeRingtoneSettingsReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_AppHmi_PhoneModule_ChangeRingtoneSettingsReq();
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_ChangeSMSSettingsReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_AppHmi_PhoneModule_ChangeSMSSettingsReq();
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_PlayReadMessageAloudReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_AppHmi_PhoneModule_PlayReadMessageAloudReq();
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_StopReadMessageAloudReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_AppHmi_PhoneModule_StopReadMessageAloudReq();
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_MatchListEntryReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_AppHmi_PhoneModule_MatchListEntryReq();
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_ContactDetailsListEntryReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_AppHmi_PhoneModule_ContactDetailsListEntryReq();
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_ContactListReq_History(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_AppHmi_PhoneModule_ContactListReq_History();
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_ContactListReq_Begining(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_AppHmi_PhoneModule_ContactListReq_Begining();
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_Ringtone_Mute(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_AppHmi_PhoneModule_Ringtone_Mute();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Activate_SPI_Application(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Activate_SPI_Application();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Activate_Listen(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Activate_Listen();
#ifdef CIT_SIMULATION
bool CallAction_ActivatePhoneGadgetResponse(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_ActivatePhoneGadgetResponse(Courier::UInt8 const & aRequestType);
#ifdef CIT_SIMULATION
bool CallAction_Perform_Network_Operator_Req(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Network_Operator_Req();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Activate_Radio_Application(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Activate_Radio_Application();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Activate_Media_Application(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Activate_Media_Application();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Activate_Media_Source_Selection(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Activate_Media_Source_Selection();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Activate_Home_Source(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Activate_Home_Source();
#ifdef CIT_SIMULATION
bool CallAction_Phone_ActivityId(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Phone_ActivityId();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Activate_Navi_Application(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Activate_Navi_Application();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Activate_BTPhone_Application_Call_List(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Activate_BTPhone_Application_Call_List();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Activate_BTPhone_Application_Contact_List(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Activate_BTPhone_Application_Contact_List();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Activate_BTPhone_Application_Device_List(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Activate_BTPhone_Application_Device_List();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Activate_BTPhone_Application_Call_Connecting(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Activate_BTPhone_Application_Call_Connecting();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Activate_BTPhone_Application_On_Call(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Activate_BTPhone_Application_On_Call();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Activate_BTPhone_Application_On_Multiparty_Call(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Activate_BTPhone_Application_On_Multiparty_Call();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Deactivate_BTPhone_Application(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Deactivate_BTPhone_Application();
#ifdef CIT_SIMULATION
bool CallAction_Activate_BT_SR_Session(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Activate_BT_SR_Session();
#ifdef CIT_SIMULATION
bool CallAction_Halt_BT_SR_Session(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Halt_BT_SR_Session();
#ifdef CIT_SIMULATION
bool CallAction_BTVROnExitAction(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_BTVROnExitAction();
#ifdef CIT_SIMULATION
bool CallAction_DeActivate_BT_SR_Session(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_DeActivate_BT_SR_Session();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Activate_BTPhone_Application_On_Intercomcall(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Activate_BTPhone_Application_On_Intercomcall();
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_PrivateMode(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_AppHmi_PhoneModule_PrivateMode();
#ifdef CIT_SIMULATION
bool CallAction_Language_Update(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Language_Update();
#ifdef CIT_SIMULATION
bool CallAction_gacChangeLanguageReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacChangeLanguageReq(enLanguageId const & aLanguageId);
#ifdef CIT_SIMULATION
bool CallAction_gacHideFocusInViewReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacHideFocusInViewReq(::Courier::ViewId const & aView);
#ifdef CIT_SIMULATION
bool CallAction_NextLevelTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_NextLevelTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_PreviousLevelTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_PreviousLevelTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_DualViewLeftTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_DualViewLeftTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_DualViewRightTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_DualViewRightTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_PageFlipBackTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_PageFlipBackTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_PageFlipFrontTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_PageFlipFrontTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_ZoomInTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_ZoomInTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos);
#ifdef CIT_SIMULATION
bool CallAction_ZoomOutTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_ZoomOutTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos);
#ifdef CIT_SIMULATION
bool CallAction_FadeTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_FadeTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_gacWaitAnimationStartReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacWaitAnimationStartReq();
#ifdef CIT_SIMULATION
bool CallAction_acFocusOnRightEncoderReqUpd(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acFocusOnRightEncoderReqUpd(bool const & aIsFocusUsed);
#ifdef CIT_SIMULATION
bool CallAction_acSetGadgetSceenActiveStatus(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSetGadgetSceenActiveStatus(bool const & aIsGadgetAtive);
#ifdef CIT_SIMULATION
bool CallAction_acHKNotificationMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acHKNotificationMsg(Courier::UInt8 const & aHKCode, Courier::UInt8 const & aHKState);
#ifdef CIT_SIMULATION
bool CallAction_acPerform_CloseAllDropdowns(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPerform_CloseAllDropdowns();
#ifdef CIT_SIMULATION
bool CallAction_acPerform_CloseDropdown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPerform_CloseDropdown(::Courier::UInt32 const & aListId);
#ifdef CIT_SIMULATION
bool CallAction_acPerform_OpenDropdown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPerform_OpenDropdown(::Courier::UInt32 const & aListId);
#ifdef CIT_SIMULATION
bool CallAction_acPerform_ToggleDropdown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPerform_ToggleDropdown(::Courier::UInt32 const & aListId);
#ifdef CIT_SIMULATION
bool CallAction_acStartAppPopupTimer(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acStartAppPopupTimer(Courier::UInt32 const & aViewId, Courier::UInt32 const & aTimeout);
#ifdef CIT_SIMULATION
bool CallAction_acStopAppPopupTimer(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acStopAppPopupTimer(Courier::UInt32 const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_acPostBeep(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPostBeep(Courier::Int32 const & aBeepType);
#ifdef CIT_SIMULATION
bool CallAction_gacCheckToClosePopup(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacCheckToClosePopup(Courier::UInt32 const & aPopupId);
#ifdef CIT_SIMULATION
bool CallAction_acRestartAppPopupTimer(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acRestartAppPopupTimer(Courier::UInt32 const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchBackRes(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacContextSwitchBackRes(Courier::UInt32 const & aSwitchId);
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchCompleteRes(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacContextSwitchCompleteRes(Courier::UInt32 const & aSwitchId);
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchFailedRes(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacContextSwitchFailedRes(Courier::UInt32 const & aSwitchId);
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchDoneRes(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacContextSwitchDoneRes(Courier::UInt32 const & aSwitchId);
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchOutReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacContextSwitchOutReq(Courier::UInt32 const & aTargetContextId, Courier::UInt32 const & aSourceContextId, Courier::UInt32 const & aTargetAppId);
#ifdef CIT_SIMULATION
bool CallAction_gacCurrentScreenDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacCurrentScreenDisplayReq();
#ifdef CIT_SIMULATION
bool CallAction_gacLaunchBarDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacLaunchBarDisplayReq(bool const & aVisibility);
#ifdef CIT_SIMULATION
bool CallAction_gacNavTBTSwipe(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacNavTBTSwipe();
#ifdef CIT_SIMULATION
bool CallAction_gacPerformListBtnRightEncoderChangeUpd(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPerformListBtnRightEncoderChangeUpd(Courier::Int8 const & aSteps, Courier::UInt32 const & aListId, Courier::UInt32 const & aRowId, Courier::UInt32 const & aColumnId);
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListUp(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollListUp();
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListDown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollListDown();
#ifdef CIT_SIMULATION
bool CallAction_gacScrollPageUp(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollPageUp();
#ifdef CIT_SIMULATION
bool CallAction_gacScrollPageDown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollPageDown();
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListFocusUp(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollListFocusUp(Courier::UInt32 const & aListId);
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListFocusDown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollListFocusDown(Courier::UInt32 const & aListId);
#ifdef CIT_SIMULATION
bool CallAction_gacPerformListFocusLockDataResetUpd(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPerformListFocusLockDataResetUpd();
#ifdef CIT_SIMULATION
bool CallAction_gacSetApplicationMode(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacSetApplicationMode(Courier::UInt32 const & aModeId);
#ifdef CIT_SIMULATION
bool CallAction_gacSpellerBbehaviorReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacSpellerBbehaviorReq(bool const & aEnable);
#ifdef CIT_SIMULATION
bool CallAction_gacStatusBarDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacStatusBarDisplayReq(bool const & aVisibility, Courier::Int32 const & aHeaderType);
#ifdef CIT_SIMULATION
bool CallAction_gacTBTRetriggerAcousticOutput(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacTBTRetriggerAcousticOutput();
#ifdef CIT_SIMULATION
bool CallAction_gacWaitAnimationStopReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacWaitAnimationStopReq();
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewCreateReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateAllReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewCreateAllReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewDestroyReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewDestroyReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewClearReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewClearReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewShowReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewShowReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewHideReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewHideReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateWithoutLoadReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewCreateWithoutLoadReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewAsyncLoadReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewAsyncLoadReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewActivateWithoutRenderingReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewActivateWithoutRenderingReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupCreateAndSBShowReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupCreateAndSBShowReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupCreateAndSBShowReqForMultiDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupCreateAndSBShowReqForMultiDisplay(Courier::UInt32 const & aPopupDisplayID, ::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupSBCloseReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupSBCloseReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupSBCloseReqForMultiDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupSBCloseReqForMultiDisplay(Courier::UInt32 const & aPopupDisplayID, ::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupRestartTimerReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupRestartTimerReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupRestartTimerReqForMultiDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupRestartTimerReqForMultiDisplay(Courier::UInt32 const & aPopupDisplayID, ::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateAndShowReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewCreateAndShowReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewHideAndDestroyReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewHideAndDestroyReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacSceneTransitionEnter(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacSceneTransitionEnter(::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint);
#ifdef CIT_SIMULATION
bool CallAction_gacSceneTransitionLeave(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacSceneTransitionLeave(::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint);
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayStatusLineReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDisplayStatusLineReq(Courier::Int32 const & aDisplayRegionType);
#ifdef CIT_SIMULATION
bool CallAction_gacHideStatusLineReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacHideStatusLineReq(Courier::Int32 const & aDisplayRegionType);
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayFooterLineReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDisplayFooterLineReq();
#ifdef CIT_SIMULATION
bool CallAction_gacHideFooterLineReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacHideFooterLineReq();
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayStatusLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDisplayStatusLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacHideStatusLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacHideStatusLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayFooterLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDisplayFooterLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacHideFooterLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacHideFooterLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacRegisterForCloseOnTouchSession(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacRegisterForCloseOnTouchSession(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacDeregisterForCloseOnTouchSessionReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDeregisterForCloseOnTouchSessionReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterPrioEnableReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterPrioEnableReq(Courier::UInt32 const & aPrio);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterAllEnableReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterAllEnableReq();
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterDisableReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterDisableReq();
#ifdef CIT_SIMULATION
bool CallAction_gacProfileChange(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacProfileChange(Courier::UInt32 const & aProfile);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterPrioEnableReqForDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterPrioEnableReqForDisplay(Courier::UInt32 const & aPrio, Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterAllEnableReqForDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterAllEnableReqForDisplay(Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterDisableReqForDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterDisableReqForDisplay(Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacStartSceneTransitionAnimation(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacStartSceneTransitionAnimation(::Courier::ViewId const & aSourceView, ::Courier::ViewId const & aDestinationView, Courier::UInt32 const & aUserData1, Courier::Int8 const & aUserData2);
#ifdef CIT_SIMULATION
bool CallAction_gacDecrementActiveAnimationCount(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDecrementActiveAnimationCount();

// overall number of HierarchyNodes
static const ::FeatStd::UInt32 cGlobalDataItemHierarchyNodeCount = 203;
// overall number of DataItemDescriptor nodes
static const ::FeatStd::UInt32 cDataItemDescriptorCount = 203;
// overall number of BindingSources
static const ::FeatStd::UInt32 cBindingSourceCount = 59;
// maximum number of HierarchyNodes in a BindingSource
static const ::FeatStd::UInt32 cBindingSourceItemCountMax = 12;

// =========================================================================

class ListId_FlexDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 10;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 1;
    static const ::Courier::DataItemKey cDataItemKey = 26;

    typedef ::ListId_FlexData Data;

    ListId_FlexDataBindingSource();
};

typedef ::Courier::DataItemMsg< ListId_FlexDataBindingSource > ListId_FlexDataItemMsg;

// =========================================================================

class ListDataSizeDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 9;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 2;
    static const ::Courier::DataItemKey cDataItemKey = 17;

    typedef ::ListDataSizeData Data;

    ListDataSizeDataBindingSource();
};

typedef ::Courier::DataItemMsg< ListDataSizeDataBindingSource > ListDataSizeDataItemMsg;

// =========================================================================

class PairedDevice_ListItemDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 7;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 3;
    static const ::Courier::DataItemKey cDataItemKey = 8;

    typedef ::PairedDevice_ListItemData Data;

    PairedDevice_ListItemDataBindingSource();
};

typedef ::Courier::DataItemMsg< PairedDevice_ListItemDataBindingSource > PairedDevice_ListItemDataItemMsg;

// =========================================================================

class CallList_ListItemDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 6;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 4;
    static const ::Courier::DataItemKey cDataItemKey = 62;

    typedef ::CallList_ListItemData Data;

    CallList_ListItemDataBindingSource();
};

typedef ::Courier::DataItemMsg< CallList_ListItemDataBindingSource > CallList_ListItemDataItemMsg;

// =========================================================================

class ContactList_ListItemDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 5;
    static const ::Courier::DataItemKey cDataItemKey = 91;

    typedef ::ContactList_ListItemData Data;

    ContactList_ListItemDataBindingSource();
};

typedef ::Courier::DataItemMsg< ContactList_ListItemDataBindingSource > ContactList_ListItemDataItemMsg;

// =========================================================================

class MatchList_ListItemDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 6;
    static const ::Courier::DataItemKey cDataItemKey = 102;

    typedef ::MatchList_ListItemData Data;

    MatchList_ListItemDataBindingSource();
};

typedef ::Courier::DataItemMsg< MatchList_ListItemDataBindingSource > MatchList_ListItemDataItemMsg;

// =========================================================================

class IContactsList_ListItemDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 7;
    static const ::Courier::DataItemKey cDataItemKey = 37;

    typedef ::IContactsList_ListItemData Data;

    IContactsList_ListItemDataBindingSource();
};

typedef ::Courier::DataItemMsg< IContactsList_ListItemDataBindingSource > IContactsList_ListItemDataItemMsg;

// =========================================================================

class Intercom_SupportStatusDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 8;
    static const ::Courier::DataItemKey cDataItemKey = 36;

    typedef ::Intercom_SupportStatusData Data;

    Intercom_SupportStatusDataBindingSource();
};

typedef ::Courier::DataItemMsg< Intercom_SupportStatusDataBindingSource > Intercom_SupportStatusDataItemMsg;

// =========================================================================

class ContactCall_ListItemDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 9;
    static const ::Courier::DataItemKey cDataItemKey = 170;

    typedef ::ContactCall_ListItemData Data;

    ContactCall_ListItemDataBindingSource();
};

typedef ::Courier::DataItemMsg< ContactCall_ListItemDataBindingSource > ContactCall_ListItemDataItemMsg;

// =========================================================================

class ViewPortStartIndexDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 10;
    static const ::Courier::DataItemKey cDataItemKey = 149;

    typedef ::ViewPortStartIndexData Data;

    ViewPortStartIndexDataBindingSource();
};

typedef ::Courier::DataItemMsg< ViewPortStartIndexDataBindingSource > ViewPortStartIndexDataItemMsg;

// =========================================================================

class ConnectedActiveBTDeviceNameDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 11;
    static const ::Courier::DataItemKey cDataItemKey = 2;

    typedef ::ConnectedActiveBTDeviceNameData Data;

    ConnectedActiveBTDeviceNameDataBindingSource();
};

typedef ::Courier::DataItemMsg< ConnectedActiveBTDeviceNameDataBindingSource > ConnectedActiveBTDeviceNameDataItemMsg;

// =========================================================================

class ConnectedBTDeviceNameDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 12;
    static const ::Courier::DataItemKey cDataItemKey = 48;

    typedef ::ConnectedBTDeviceNameData Data;

    ConnectedBTDeviceNameDataBindingSource();
};

typedef ::Courier::DataItemMsg< ConnectedBTDeviceNameDataBindingSource > ConnectedBTDeviceNameDataItemMsg;

// =========================================================================

class DisconnectedBTDeviceNameDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 13;
    static const ::Courier::DataItemKey cDataItemKey = 125;

    typedef ::DisconnectedBTDeviceNameData Data;

    DisconnectedBTDeviceNameDataBindingSource();
};

typedef ::Courier::DataItemMsg< DisconnectedBTDeviceNameDataBindingSource > DisconnectedBTDeviceNameDataItemMsg;

// =========================================================================

class VarientTypeDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 14;
    static const ::Courier::DataItemKey cDataItemKey = 3;

    typedef ::VarientTypeData Data;

    VarientTypeDataBindingSource();
};

typedef ::Courier::DataItemMsg< VarientTypeDataBindingSource > VarientTypeDataItemMsg;

// =========================================================================

class SPIStatusDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 15;
    static const ::Courier::DataItemKey cDataItemKey = 177;

    typedef ::SPIStatusData Data;

    SPIStatusDataBindingSource();
};

typedef ::Courier::DataItemMsg< SPIStatusDataBindingSource > SPIStatusDataItemMsg;

// =========================================================================

class IsListNotemptyDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 16;
    static const ::Courier::DataItemKey cDataItemKey = 169;

    typedef ::IsListNotemptyData Data;

    IsListNotemptyDataBindingSource();
};

typedef ::Courier::DataItemMsg< IsListNotemptyDataBindingSource > IsListNotemptyDataItemMsg;

// =========================================================================

class ContactCallNameDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 17;
    static const ::Courier::DataItemKey cDataItemKey = 4;

    typedef ::ContactCallNameData Data;

    ContactCallNameDataBindingSource();
};

typedef ::Courier::DataItemMsg< ContactCallNameDataBindingSource > ContactCallNameDataItemMsg;

// =========================================================================

class FriendlyVehicleNameDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 18;
    static const ::Courier::DataItemKey cDataItemKey = 94;

    typedef ::FriendlyVehicleNameData Data;

    FriendlyVehicleNameDataBindingSource();
};

typedef ::Courier::DataItemMsg< FriendlyVehicleNameDataBindingSource > FriendlyVehicleNameDataItemMsg;

// =========================================================================

class PairingDeviceInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 19;
    static const ::Courier::DataItemKey cDataItemKey = 114;

    typedef ::PairingDeviceInfoData Data;

    PairingDeviceInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< PairingDeviceInfoDataBindingSource > PairingDeviceInfoDataItemMsg;

// =========================================================================

class DeviceInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 20;
    static const ::Courier::DataItemKey cDataItemKey = 134;

    typedef ::DeviceInfoData Data;

    DeviceInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< DeviceInfoDataBindingSource > DeviceInfoDataItemMsg;

// =========================================================================

class MatchedItemsDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 21;
    static const ::Courier::DataItemKey cDataItemKey = 30;

    typedef ::MatchedItemsData Data;

    MatchedItemsDataBindingSource();
};

typedef ::Courier::DataItemMsg< MatchedItemsDataBindingSource > MatchedItemsDataItemMsg;

// =========================================================================

class PhoneButtonTextDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 22;
    static const ::Courier::DataItemKey cDataItemKey = 200;

    typedef ::PhoneButtonTextData Data;

    PhoneButtonTextDataBindingSource();
};

typedef ::Courier::DataItemMsg< PhoneButtonTextDataBindingSource > PhoneButtonTextDataItemMsg;

// =========================================================================

class MicEnableDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 23;
    static const ::Courier::DataItemKey cDataItemKey = 53;

    typedef ::MicEnableData Data;

    MicEnableDataBindingSource();
};

typedef ::Courier::DataItemMsg< MicEnableDataBindingSource > MicEnableDataItemMsg;

// =========================================================================

class VehicleAudioStatusDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 24;
    static const ::Courier::DataItemKey cDataItemKey = 50;

    typedef ::VehicleAudioStatusData Data;

    VehicleAudioStatusDataBindingSource();
};

typedef ::Courier::DataItemMsg< VehicleAudioStatusDataBindingSource > VehicleAudioStatusDataItemMsg;

// =========================================================================

class PrivateModeStatusDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 25;
    static const ::Courier::DataItemKey cDataItemKey = 14;

    typedef ::PrivateModeStatusData Data;

    PrivateModeStatusDataBindingSource();
};

typedef ::Courier::DataItemMsg< PrivateModeStatusDataBindingSource > PrivateModeStatusDataItemMsg;

// =========================================================================

class SettingsDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 7;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 26;
    static const ::Courier::DataItemKey cDataItemKey = 74;

    typedef ::SettingsData Data;

    SettingsDataBindingSource();
};

typedef ::Courier::DataItemMsg< SettingsDataBindingSource > SettingsDataItemMsg;

// =========================================================================

class CallProgressDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 6;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 27;
    static const ::Courier::DataItemKey cDataItemKey = 6;

    typedef ::CallProgressData Data;

    CallProgressDataBindingSource();
};

typedef ::Courier::DataItemMsg< CallProgressDataBindingSource > CallProgressDataItemMsg;

// =========================================================================

class IntercomIncomingCallDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 28;
    static const ::Courier::DataItemKey cDataItemKey = 146;

    typedef ::IntercomIncomingCallData Data;

    IntercomIncomingCallDataBindingSource();
};

typedef ::Courier::DataItemMsg< IntercomIncomingCallDataBindingSource > IntercomIncomingCallDataItemMsg;

// =========================================================================

class IntercomMissedIncomingCallDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 29;
    static const ::Courier::DataItemKey cDataItemKey = 59;

    typedef ::IntercomMissedIncomingCallData Data;

    IntercomMissedIncomingCallDataBindingSource();
};

typedef ::Courier::DataItemMsg< IntercomMissedIncomingCallDataBindingSource > IntercomMissedIncomingCallDataItemMsg;

// =========================================================================

class IntercomCallProgressDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 30;
    static const ::Courier::DataItemKey cDataItemKey = 143;

    typedef ::IntercomCallProgressData Data;

    IntercomCallProgressDataBindingSource();
};

typedef ::Courier::DataItemMsg< IntercomCallProgressDataBindingSource > IntercomCallProgressDataItemMsg;

// =========================================================================

class IntercomConfCallDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 31;
    static const ::Courier::DataItemKey cDataItemKey = 18;

    typedef ::IntercomConfCallData Data;

    IntercomConfCallDataBindingSource();
};

typedef ::Courier::DataItemMsg< IntercomConfCallDataBindingSource > IntercomConfCallDataItemMsg;

// =========================================================================

class PhoneStatusDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 7;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 32;
    static const ::Courier::DataItemKey cDataItemKey = 13;

    typedef ::PhoneStatusData Data;

    PhoneStatusDataBindingSource();
};

typedef ::Courier::DataItemMsg< PhoneStatusDataBindingSource > PhoneStatusDataItemMsg;

// =========================================================================

class ValidCharSetDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 33;
    static const ::Courier::DataItemKey cDataItemKey = 46;

    typedef ::ValidCharSetData Data;

    ValidCharSetDataBindingSource();
};

typedef ::Courier::DataItemMsg< ValidCharSetDataBindingSource > ValidCharSetDataItemMsg;

// =========================================================================

class SuggesstionTextDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 34;
    static const ::Courier::DataItemKey cDataItemKey = 172;

    typedef ::SuggesstionTextData Data;

    SuggesstionTextDataBindingSource();
};

typedef ::Courier::DataItemMsg< SuggesstionTextDataBindingSource > SuggesstionTextDataItemMsg;

// =========================================================================

class EntryTextDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 35;
    static const ::Courier::DataItemKey cDataItemKey = 21;

    typedef ::EntryTextData Data;

    EntryTextDataBindingSource();
};

typedef ::Courier::DataItemMsg< EntryTextDataBindingSource > EntryTextDataItemMsg;

// =========================================================================

class PhoneDialPadInputTextDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 36;
    static const ::Courier::DataItemKey cDataItemKey = 184;

    typedef ::PhoneDialPadInputTextData Data;

    PhoneDialPadInputTextDataBindingSource();
};

typedef ::Courier::DataItemMsg< PhoneDialPadInputTextDataBindingSource > PhoneDialPadInputTextDataItemMsg;

// =========================================================================

class BTTelltalesDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 37;
    static const ::Courier::DataItemKey cDataItemKey = 54;

    typedef ::BTTelltalesData Data;

    BTTelltalesDataBindingSource();
};

typedef ::Courier::DataItemMsg< BTTelltalesDataBindingSource > BTTelltalesDataItemMsg;

// =========================================================================

class RoamingDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 38;
    static const ::Courier::DataItemKey cDataItemKey = 56;

    typedef ::RoamingData Data;

    RoamingDataBindingSource();
};

typedef ::Courier::DataItemMsg< RoamingDataBindingSource > RoamingDataItemMsg;

// =========================================================================

class DialButtonDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 39;
    static const ::Courier::DataItemKey cDataItemKey = 159;

    typedef ::DialButtonData Data;

    DialButtonDataBindingSource();
};

typedef ::Courier::DataItemMsg< DialButtonDataBindingSource > DialButtonDataItemMsg;

// =========================================================================

class MatchListDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 40;
    static const ::Courier::DataItemKey cDataItemKey = 186;

    typedef ::MatchListData Data;

    MatchListDataBindingSource();
};

typedef ::Courier::DataItemMsg< MatchListDataBindingSource > MatchListDataItemMsg;

// =========================================================================

class DialPadButtonDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 41;
    static const ::Courier::DataItemKey cDataItemKey = 189;

    typedef ::DialPadButtonData Data;

    DialPadButtonDataBindingSource();
};

typedef ::Courier::DataItemMsg< DialPadButtonDataBindingSource > DialPadButtonDataItemMsg;

// =========================================================================

class IsActiveDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 42;
    static const ::Courier::DataItemKey cDataItemKey = 39;

    typedef ::IsActiveData Data;

    IsActiveDataBindingSource();
};

typedef ::Courier::DataItemMsg< IsActiveDataBindingSource > IsActiveDataItemMsg;

// =========================================================================

class PhoneGadgetInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 7;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 43;
    static const ::Courier::DataItemKey cDataItemKey = 176;

    typedef ::PhoneGadgetInfoData Data;

    PhoneGadgetInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< PhoneGadgetInfoDataBindingSource > PhoneGadgetInfoDataItemMsg;

// =========================================================================

class MsgProgressDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 8;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 44;
    static const ::Courier::DataItemKey cDataItemKey = 195;

    typedef ::MsgProgressData Data;

    MsgProgressDataBindingSource();
};

typedef ::Courier::DataItemMsg< MsgProgressDataBindingSource > MsgProgressDataItemMsg;

// =========================================================================

class MultipleCallProgressDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 12;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 45;
    static const ::Courier::DataItemKey cDataItemKey = 41;

    typedef ::MultipleCallProgressData Data;

    MultipleCallProgressDataBindingSource();
};

typedef ::Courier::DataItemMsg< MultipleCallProgressDataBindingSource > MultipleCallProgressDataItemMsg;

// =========================================================================

class IncomingCallDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 5;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 46;
    static const ::Courier::DataItemKey cDataItemKey = 83;

    typedef ::IncomingCallData Data;

    IncomingCallDataBindingSource();
};

typedef ::Courier::DataItemMsg< IncomingCallDataBindingSource > IncomingCallDataItemMsg;

// =========================================================================

class NetworkOperatorDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 47;
    static const ::Courier::DataItemKey cDataItemKey = 57;

    typedef ::NetworkOperatorData Data;

    NetworkOperatorDataBindingSource();
};

typedef ::Courier::DataItemMsg< NetworkOperatorDataBindingSource > NetworkOperatorDataItemMsg;

// =========================================================================

class BTVRDeviceNameDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 48;
    static const ::Courier::DataItemKey cDataItemKey = 51;

    typedef ::BTVRDeviceNameData Data;

    BTVRDeviceNameDataBindingSource();
};

typedef ::Courier::DataItemMsg< BTVRDeviceNameDataBindingSource > BTVRDeviceNameDataItemMsg;

// =========================================================================

class BTVRIconSRStatusDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 49;
    static const ::Courier::DataItemKey cDataItemKey = 160;

    typedef ::BTVRIconSRStatusData Data;

    BTVRIconSRStatusDataBindingSource();
};

typedef ::Courier::DataItemMsg< BTVRIconSRStatusDataBindingSource > BTVRIconSRStatusDataItemMsg;

// =========================================================================

class BTVRIconSRStatusIndexDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 50;
    static const ::Courier::DataItemKey cDataItemKey = 38;

    typedef ::BTVRIconSRStatusIndexData Data;

    BTVRIconSRStatusIndexDataBindingSource();
};

typedef ::Courier::DataItemMsg< BTVRIconSRStatusIndexDataBindingSource > BTVRIconSRStatusIndexDataItemMsg;

// =========================================================================

class QuickScrollSearchDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 51;
    static const ::Courier::DataItemKey cDataItemKey = 139;

    typedef ::QuickScrollSearchData Data;

    QuickScrollSearchDataBindingSource();
};

typedef ::Courier::DataItemMsg< QuickScrollSearchDataBindingSource > QuickScrollSearchDataItemMsg;

// =========================================================================

class LoadingAnimationInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 5;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 52;
    static const ::Courier::DataItemKey cDataItemKey = 71;

    typedef ::LoadingAnimationInfoData Data;

    LoadingAnimationInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< LoadingAnimationInfoDataBindingSource > LoadingAnimationInfoDataItemMsg;

// =========================================================================

class AndroidAutoSessionInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 53;
    static const ::Courier::DataItemKey cDataItemKey = 34;

    typedef ::AndroidAutoSessionInfoData Data;

    AndroidAutoSessionInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< AndroidAutoSessionInfoDataBindingSource > AndroidAutoSessionInfoDataItemMsg;

// =========================================================================

class BTONOFFDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 54;
    static const ::Courier::DataItemKey cDataItemKey = 201;

    typedef ::BTONOFFData Data;

    BTONOFFDataBindingSource();
};

typedef ::Courier::DataItemMsg< BTONOFFDataBindingSource > BTONOFFDataItemMsg;

// =========================================================================

class IntercomenableDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 55;
    static const ::Courier::DataItemKey cDataItemKey = 126;

    typedef ::IntercomenableData Data;

    IntercomenableDataBindingSource();
};

typedef ::Courier::DataItemMsg< IntercomenableDataBindingSource > IntercomenableDataItemMsg;

// =========================================================================

class AddCallEnableDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 56;
    static const ::Courier::DataItemKey cDataItemKey = 157;

    typedef ::AddCallEnableData Data;

    AddCallEnableDataBindingSource();
};

typedef ::Courier::DataItemMsg< AddCallEnableDataBindingSource > AddCallEnableDataItemMsg;

// =========================================================================

class SpeedLockDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 57;
    static const ::Courier::DataItemKey cDataItemKey = 78;

    typedef ::SpeedLockData Data;

    SpeedLockDataBindingSource();
};

typedef ::Courier::DataItemMsg< SpeedLockDataBindingSource > SpeedLockDataItemMsg;

// =========================================================================

class ListScrollBarInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 58;
    static const ::Courier::DataItemKey cDataItemKey = 42;

    typedef ::ListScrollBarInfoData Data;

    ListScrollBarInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< ListScrollBarInfoDataBindingSource > ListScrollBarInfoDataItemMsg;

namespace ItemKey {
        static const ::Courier::DataItemKey InvalidItem = 0;
        static const ::Courier::DataItemKey ConnectedActiveBTDeviceNameItem = 2;
        static const ::Courier::DataItemKey VarientTypeItem = 3;
        static const ::Courier::DataItemKey ContactCallNameItem = 4;
        static const ::Courier::DataItemKey CallProgressItem = 6;
        static const ::Courier::DataItemKey PairedDevice_ListItemItem = 8;
        static const ::Courier::DataItemKey PhoneStatusItem = 13;
        static const ::Courier::DataItemKey PrivateModeStatusItem = 14;
        static const ::Courier::DataItemKey ListDataSizeItem = 17;
        static const ::Courier::DataItemKey IntercomConfCallItem = 18;
        static const ::Courier::DataItemKey EntryTextItem = 21;
        static const ::Courier::DataItemKey ListId_FlexItem = 26;
        static const ::Courier::DataItemKey MatchedItemsItem = 30;
        static const ::Courier::DataItemKey AndroidAutoSessionInfoItem = 34;
        static const ::Courier::DataItemKey Intercom_SupportStatusItem = 36;
        static const ::Courier::DataItemKey IContactsList_ListItemItem = 37;
        static const ::Courier::DataItemKey BTVRIconSRStatusIndexItem = 38;
        static const ::Courier::DataItemKey IsActiveItem = 39;
        static const ::Courier::DataItemKey MultipleCallProgressItem = 41;
        static const ::Courier::DataItemKey ListScrollBarInfoItem = 42;
        static const ::Courier::DataItemKey ValidCharSetItem = 46;
        static const ::Courier::DataItemKey ConnectedBTDeviceNameItem = 48;
        static const ::Courier::DataItemKey VehicleAudioStatusItem = 50;
        static const ::Courier::DataItemKey BTVRDeviceNameItem = 51;
        static const ::Courier::DataItemKey MicEnableItem = 53;
        static const ::Courier::DataItemKey BTTelltalesItem = 54;
        static const ::Courier::DataItemKey RoamingItem = 56;
        static const ::Courier::DataItemKey NetworkOperatorItem = 57;
        static const ::Courier::DataItemKey IntercomMissedIncomingCallItem = 59;
        static const ::Courier::DataItemKey CallList_ListItemItem = 62;
        static const ::Courier::DataItemKey LoadingAnimationInfoItem = 71;
        static const ::Courier::DataItemKey SettingsItem = 74;
        static const ::Courier::DataItemKey SpeedLockItem = 78;
        static const ::Courier::DataItemKey IncomingCallItem = 83;
        static const ::Courier::DataItemKey ContactList_ListItemItem = 91;
        static const ::Courier::DataItemKey FriendlyVehicleNameItem = 94;
        static const ::Courier::DataItemKey MatchList_ListItemItem = 102;
        static const ::Courier::DataItemKey PairingDeviceInfoItem = 114;
        static const ::Courier::DataItemKey DisconnectedBTDeviceNameItem = 125;
        static const ::Courier::DataItemKey IntercomenableItem = 126;
        static const ::Courier::DataItemKey DeviceInfoItem = 134;
        static const ::Courier::DataItemKey QuickScrollSearchItem = 139;
        static const ::Courier::DataItemKey IntercomCallProgressItem = 143;
        static const ::Courier::DataItemKey IntercomIncomingCallItem = 146;
        static const ::Courier::DataItemKey ViewPortStartIndexItem = 149;
        static const ::Courier::DataItemKey AddCallEnableItem = 157;
        static const ::Courier::DataItemKey DialButtonItem = 159;
        static const ::Courier::DataItemKey BTVRIconSRStatusItem = 160;
        static const ::Courier::DataItemKey IsListNotemptyItem = 169;
        static const ::Courier::DataItemKey ContactCall_ListItemItem = 170;
        static const ::Courier::DataItemKey SuggesstionTextItem = 172;
        static const ::Courier::DataItemKey PhoneGadgetInfoItem = 176;
        static const ::Courier::DataItemKey SPIStatusItem = 177;
        static const ::Courier::DataItemKey PhoneDialPadInputTextItem = 184;
        static const ::Courier::DataItemKey MatchListItem = 186;
        static const ::Courier::DataItemKey DialPadButtonItem = 189;
        static const ::Courier::DataItemKey MsgProgressItem = 195;
        static const ::Courier::DataItemKey PhoneButtonTextItem = 200;
        static const ::Courier::DataItemKey BTONOFFItem = 201;

    namespace ConnectedActiveBTDeviceName {
            static const ::Courier::DataItemKey DeviceNameItem = 73;
    } // namespace ConnectedActiveBTDeviceName

    namespace VarientType {
            static const ::Courier::DataItemKey SwitcherIndexItem = 202;
            static const ::Courier::DataItemKey EnableNaviItem = 181;
    } // namespace VarientType

    namespace ContactCallName {
            static const ::Courier::DataItemKey CallerNameItem = 98;
    } // namespace ContactCallName

    namespace CallProgress {
            static const ::Courier::DataItemKey CallDurationItem = 81;
            static const ::Courier::DataItemKey CallerIDItem = 85;
            static const ::Courier::DataItemKey ContactTypeItem = 33;
            static const ::Courier::DataItemKey CallStatusItem = 127;
            static const ::Courier::DataItemKey GadgetCallerIDItem = 32;
    } // namespace CallProgress

    namespace PairedDevice_ListItem {
            static const ::Courier::DataItemKey DeviceTypeIndexItem = 140;
            static const ::Courier::DataItemKey DeviceNameItem = 29;
            static const ::Courier::DataItemKey ProfilePhoneItem = 90;
            static const ::Courier::DataItemKey ProfileAudioItem = 131;
            static const ::Courier::DataItemKey BTIconItem = 171;
            static const ::Courier::DataItemKey DeviceNameTxtColorItem = 104;
    } // namespace PairedDevice_ListItem

    namespace PhoneStatus {
            static const ::Courier::DataItemKey BatteryStatusItem = 115;
            static const ::Courier::DataItemKey SignalStatusItem = 168;
            static const ::Courier::DataItemKey NetworkStatusItem = 173;
            static const ::Courier::DataItemKey MissedCallStatusItem = 178;
            static const ::Courier::DataItemKey SignalStatusinGadgetItem = 45;
            static const ::Courier::DataItemKey BatteryStatusinGadgetItem = 165;
    } // namespace PhoneStatus

    namespace PrivateModeStatus {
            static const ::Courier::DataItemKey IsSelectedItem = 154;
    } // namespace PrivateModeStatus

    namespace ListDataSize {
            static const ::Courier::DataItemKey PairedDeviceListSizeItem = 75;
            static const ::Courier::DataItemKey ContactListSizeItem = 119;
            static const ::Courier::DataItemKey MatchListSizeItem = 129;
            static const ::Courier::DataItemKey ContactCallListSizeItem = 166;
            static const ::Courier::DataItemKey CallListSizeItem = 12;
            static const ::Courier::DataItemKey SortOrderSizeItem = 147;
            static const ::Courier::DataItemKey IContactsSizeItem = 137;
            static const ::Courier::DataItemKey IConfCallSizeItem = 64;
    } // namespace ListDataSize

    namespace IntercomConfCall {
            static const ::Courier::DataItemKey CallerIDItem = 96;
            static const ::Courier::DataItemKey ContactTypeItem = 199;
            static const ::Courier::DataItemKey CallStatusItem = 180;
    } // namespace IntercomConfCall

    namespace EntryText {
            static const ::Courier::DataItemKey TextItem = 93;
    } // namespace EntryText

    namespace ListId_Flex {
            static const ::Courier::DataItemKey PairedDeviceListIdItem = 118;
            static const ::Courier::DataItemKey PhoneContactListIdItem = 35;
            static const ::Courier::DataItemKey MatchListIdItem = 61;
            static const ::Courier::DataItemKey ContactCallListIdItem = 174;
            static const ::Courier::DataItemKey CallListIdItem = 65;
            static const ::Courier::DataItemKey SettingListIdItem = 124;
            static const ::Courier::DataItemKey DropDownListIdItem = 79;
            static const ::Courier::DataItemKey IntercomContactsListIdItem = 153;
            static const ::Courier::DataItemKey IntercomConfCallListIdItem = 16;
    } // namespace ListId_Flex

    namespace MatchedItems {
            static const ::Courier::DataItemKey CountItem = 9;
    } // namespace MatchedItems

    namespace AndroidAutoSessionInfo {
            static const ::Courier::DataItemKey SessionStatusItem = 10;
            static const ::Courier::DataItemKey SessionStatusIndexItem = 15;
    } // namespace AndroidAutoSessionInfo

    namespace Intercom_SupportStatus {
            static const ::Courier::DataItemKey Intercom_SupportedItem = 87;
            static const ::Courier::DataItemKey Intercom_NotSupportedItem = 5;
    } // namespace Intercom_SupportStatus

    namespace IContactsList_ListItem {
            static const ::Courier::DataItemKey IContactNameItem = 7;
            static const ::Courier::DataItemKey IContacttypeItem = 179;
            static const ::Courier::DataItemKey ICallStatusItem = 47;
    } // namespace IContactsList_ListItem

    namespace BTVRIconSRStatusIndex {
            static const ::Courier::DataItemKey IconSRStatusIndexItem = 162;
    } // namespace BTVRIconSRStatusIndex

    namespace IsActive {
            static const ::Courier::DataItemKey IsAddPhoneDisabledItem = 167;
    } // namespace IsActive

    namespace MultipleCallProgress {
            static const ::Courier::DataItemKey ActiveCallerIDItem = 112;
            static const ::Courier::DataItemKey OnHoldCallerIDItem = 60;
            static const ::Courier::DataItemKey ActiveCallDurationItem = 80;
            static const ::Courier::DataItemKey OnHoldCallDurationItem = 99;
            static const ::Courier::DataItemKey ActiveCallStatusItem = 49;
            static const ::Courier::DataItemKey OnHoldCallerStatusItem = 100;
            static const ::Courier::DataItemKey ActiveContactTypeItem = 142;
            static const ::Courier::DataItemKey OnHoldContactTypeItem = 25;
            static const ::Courier::DataItemKey CallTypeItem = 11;
            static const ::Courier::DataItemKey IsEnableDialPadItem = 86;
            static const ::Courier::DataItemKey IsEnableSwapItem = 135;
    } // namespace MultipleCallProgress

    namespace ListScrollBarInfo {
            static const ::Courier::DataItemKey EnabledItem = 175;
    } // namespace ListScrollBarInfo

    namespace ValidCharSet {
            static const ::Courier::DataItemKey CharacterSetItem = 151;
    } // namespace ValidCharSet

    namespace ConnectedBTDeviceName {
            static const ::Courier::DataItemKey DeviceNameItem = 138;
    } // namespace ConnectedBTDeviceName

    namespace VehicleAudioStatus {
            static const ::Courier::DataItemKey IsSelectedItem = 20;
    } // namespace VehicleAudioStatus

    namespace BTVRDeviceName {
            static const ::Courier::DataItemKey DeviceNameItem = 155;
    } // namespace BTVRDeviceName

    namespace MicEnable {
            static const ::Courier::DataItemKey IsSelectedItem = 182;
            static const ::Courier::DataItemKey EnabledItem = 188;
    } // namespace MicEnable

    namespace BTTelltales {
            static const ::Courier::DataItemKey ImagePathItem = 103;
            static const ::Courier::DataItemKey LoadAssetBitmapItem = 117;
    } // namespace BTTelltales

    namespace Roaming {
            static const ::Courier::DataItemKey EnabledItem = 110;
    } // namespace Roaming

    namespace NetworkOperator {
            static const ::Courier::DataItemKey OperatorNameItem = 1;
            static const ::Courier::DataItemKey TextNodeMaxSizeItem = 185;
    } // namespace NetworkOperator

    namespace IntercomMissedIncomingCall {
            static const ::Courier::DataItemKey MissedCallerInfoItem = 120;
    } // namespace IntercomMissedIncomingCall

    namespace CallList_ListItem {
            static const ::Courier::DataItemKey CallInfoIconItem = 108;
            static const ::Courier::DataItemKey CallerNameItem = 136;
            static const ::Courier::DataItemKey CallNumberOfTimesItem = 197;
            static const ::Courier::DataItemKey CallDateItem = 40;
            static const ::Courier::DataItemKey CallListFocusIndexItem = 156;
    } // namespace CallList_ListItem

    namespace LoadingAnimationInfo {
            static const ::Courier::DataItemKey Channel1_PhonebookItem = 31;
            static const ::Courier::DataItemKey Channel1_CalllistItem = 111;
            static const ::Courier::DataItemKey Channel2_PhonebookItem = 130;
            static const ::Courier::DataItemKey Channel2_CalllistItem = 55;
    } // namespace LoadingAnimationInfo

    namespace Settings {
            static const ::Courier::DataItemKey UsePhoneRingtone_IsSelectedItem = 158;
            static const ::Courier::DataItemKey ShowIncomingText_IsSelectedItem = 77;
            static const ::Courier::DataItemKey SortPhoneBookTypeTextItem = 23;
            static const ::Courier::DataItemKey SelectedLineItem = 27;
            static const ::Courier::DataItemKey IsInBandSupportedItem = 164;
            static const ::Courier::DataItemKey EnableDisableSortOrderItem = 84;
    } // namespace Settings

    namespace SpeedLock {
            static const ::Courier::DataItemKey SpeedLockStatusItem = 194;
            static const ::Courier::DataItemKey DialPadCallButtonStatusItem = 97;
    } // namespace SpeedLock

    namespace IncomingCall {
            static const ::Courier::DataItemKey CallerIDItem = 105;
            static const ::Courier::DataItemKey ContactTypeItem = 187;
            static const ::Courier::DataItemKey CountItem = 190;
            static const ::Courier::DataItemKey DeviceNameItem = 122;
    } // namespace IncomingCall

    namespace ContactList_ListItem {
            static const ::Courier::DataItemKey ContactNameItem = 113;
            static const ::Courier::DataItemKey PhoneNumberCountItem = 28;
            static const ::Courier::DataItemKey ContactsFocusIndexItem = 22;
    } // namespace ContactList_ListItem

    namespace FriendlyVehicleName {
            static const ::Courier::DataItemKey HUDNameItem = 43;
    } // namespace FriendlyVehicleName

    namespace MatchList_ListItem {
            static const ::Courier::DataItemKey MatchedNumberItem = 106;
            static const ::Courier::DataItemKey MatchedContactNameItem = 121;
    } // namespace MatchList_ListItem

    namespace PairingDeviceInfo {
            static const ::Courier::DataItemKey DeviceNameItem = 152;
            static const ::Courier::DataItemKey PairingPINItem = 145;
    } // namespace PairingDeviceInfo

    namespace DisconnectedBTDeviceName {
            static const ::Courier::DataItemKey DeviceNameItem = 191;
    } // namespace DisconnectedBTDeviceName

    namespace Intercomenable {
            static const ::Courier::DataItemKey IntercomenableItem = 101;
    } // namespace Intercomenable

    namespace DeviceInfo {
            static const ::Courier::DataItemKey DeviceNameItem = 198;
    } // namespace DeviceInfo

    namespace QuickScrollSearch {
            static const ::Courier::DataItemKey ScrollVisibleItem = 109;
            static const ::Courier::DataItemKey ScrollSearchCharItem = 192;
    } // namespace QuickScrollSearch

    namespace IntercomCallProgress {
            static const ::Courier::DataItemKey CallerIDItem = 70;
            static const ::Courier::DataItemKey ContactTypeItem = 107;
    } // namespace IntercomCallProgress

    namespace IntercomIncomingCall {
            static const ::Courier::DataItemKey CallerIDItem = 161;
            static const ::Courier::DataItemKey ContactTypeItem = 63;
    } // namespace IntercomIncomingCall

    namespace ViewPortStartIndex {
            static const ::Courier::DataItemKey ContactListIndexItem = 67;
    } // namespace ViewPortStartIndex

    namespace AddCallEnable {
            static const ::Courier::DataItemKey AddCallEnableItem = 19;
    } // namespace AddCallEnable

    namespace DialButton {
            static const ::Courier::DataItemKey EnabledItem = 163;
    } // namespace DialButton

    namespace BTVRIconSRStatus {
            static const ::Courier::DataItemKey IconSRStatusItem = 144;
    } // namespace BTVRIconSRStatus

    namespace IsListNotempty {
            static const ::Courier::DataItemKey CallListItem = 82;
            static const ::Courier::DataItemKey ContactListItem = 68;
    } // namespace IsListNotempty

    namespace ContactCall_ListItem {
            static const ::Courier::DataItemKey ContactInfoIconItem = 196;
            static const ::Courier::DataItemKey ContactPhoneNumberItem = 128;
            static const ::Courier::DataItemKey PrimaryIconItem = 44;
    } // namespace ContactCall_ListItem

    namespace SuggesstionText {
            static const ::Courier::DataItemKey TextItem = 92;
    } // namespace SuggesstionText

    namespace PhoneGadgetInfo {
            static const ::Courier::DataItemKey PhoneHandleItem = 89;
            static const ::Courier::DataItemKey PhoneSignalStatusItem = 148;
            static const ::Courier::DataItemKey PhoneBatteryStatusItem = 95;
            static const ::Courier::DataItemKey IndexForGadgetBGItem = 150;
            static const ::Courier::DataItemKey IndexForGadgetContentItem = 193;
            static const ::Courier::DataItemKey IndexForIntercomTextInfoItem = 123;
    } // namespace PhoneGadgetInfo

    namespace SPIStatus {
            static const ::Courier::DataItemKey EnableSPIItem = 72;
    } // namespace SPIStatus

    namespace PhoneDialPadInputText {
            static const ::Courier::DataItemKey TextItem = 133;
    } // namespace PhoneDialPadInputText

    namespace MatchList {
            static const ::Courier::DataItemKey EnabledItem = 183;
    } // namespace MatchList

    namespace DialPadButton {
            static const ::Courier::DataItemKey EnabledItem = 52;
    } // namespace DialPadButton

    namespace MsgProgress {
            static const ::Courier::DataItemKey CallerIDItem = 69;
            static const ::Courier::DataItemKey TimeHourItem = 66;
            static const ::Courier::DataItemKey SubjectItem = 58;
            static const ::Courier::DataItemKey ShortMessageItem = 24;
            static const ::Courier::DataItemKey ValidContactItem = 132;
            static const ::Courier::DataItemKey PlayBackActionItem = 76;
            static const ::Courier::DataItemKey IsEnableReadOutAloudItem = 88;
    } // namespace MsgProgress

    namespace PhoneButtonText {
            static const ::Courier::DataItemKey SourceItem = 116;
    } // namespace PhoneButtonText

    namespace BTONOFF {
            static const ::Courier::DataItemKey BTONOFFStatusItem = 141;
    } // namespace BTONOFF
} // namespace ItemKey

bool InitDataBinding();

#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
namespace FeatStd {
// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ListId_FlexDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ListId_FlexDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ListDataSizeDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ListDataSizeDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PairedDevice_ListItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PairedDevice_ListItemDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::CallList_ListItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::CallList_ListItemDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ContactList_ListItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ContactList_ListItemDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::MatchList_ListItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::MatchList_ListItemDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::IContactsList_ListItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::IContactsList_ListItemDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Intercom_SupportStatusDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Intercom_SupportStatusDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ContactCall_ListItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ContactCall_ListItemDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ViewPortStartIndexDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ViewPortStartIndexDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ConnectedActiveBTDeviceNameDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ConnectedActiveBTDeviceNameDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ConnectedBTDeviceNameDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ConnectedBTDeviceNameDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DisconnectedBTDeviceNameDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DisconnectedBTDeviceNameDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::VarientTypeDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::VarientTypeDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SPIStatusDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SPIStatusDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::IsListNotemptyDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::IsListNotemptyDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ContactCallNameDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ContactCallNameDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::FriendlyVehicleNameDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::FriendlyVehicleNameDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PairingDeviceInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PairingDeviceInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DeviceInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DeviceInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::MatchedItemsDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::MatchedItemsDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PhoneButtonTextDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PhoneButtonTextDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::MicEnableDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::MicEnableDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::VehicleAudioStatusDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::VehicleAudioStatusDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PrivateModeStatusDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PrivateModeStatusDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SettingsDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SettingsDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::CallProgressDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::CallProgressDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::IntercomIncomingCallDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::IntercomIncomingCallDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::IntercomMissedIncomingCallDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::IntercomMissedIncomingCallDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::IntercomCallProgressDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::IntercomCallProgressDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::IntercomConfCallDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::IntercomConfCallDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PhoneStatusDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PhoneStatusDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ValidCharSetDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ValidCharSetDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SuggesstionTextDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SuggesstionTextDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::EntryTextDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::EntryTextDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PhoneDialPadInputTextDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PhoneDialPadInputTextDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::BTTelltalesDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::BTTelltalesDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::RoamingDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::RoamingDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DialButtonDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DialButtonDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::MatchListDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::MatchListDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DialPadButtonDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DialPadButtonDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::IsActiveDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::IsActiveDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PhoneGadgetInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PhoneGadgetInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::MsgProgressDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::MsgProgressDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::MultipleCallProgressDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::MultipleCallProgressDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::IncomingCallDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::IncomingCallDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::NetworkOperatorDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::NetworkOperatorDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::BTVRDeviceNameDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::BTVRDeviceNameDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::BTVRIconSRStatusDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::BTVRIconSRStatusDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::BTVRIconSRStatusIndexDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::BTVRIconSRStatusIndexDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::QuickScrollSearchDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::QuickScrollSearchDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::LoadingAnimationInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::LoadingAnimationInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::AndroidAutoSessionInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::AndroidAutoSessionInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::BTONOFFDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::BTONOFFDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::IntercomenableDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::IntercomenableDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::AddCallEnableDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::AddCallEnableDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SpeedLockDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SpeedLockDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ListScrollBarInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ListScrollBarInfoDataBindingSource > const& dataItemContainer);
} // namespace FeatStd
#endif // FEATSTD_STRINGBUFFER_APPENDER_ENABLED
#endif // AppHmi_PhoneStateMachine_h
