/************************************************************************
*FILE: AppHmi_PhoneStateMachine.cpp 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#include "AppHmi_PhoneStateMachine.h"
#include <FeatStd/Util/StaticObject.h>
#include <Cit/VisualStateGlueLayer/VisualStateGlueLayer.h>
#include <Courier/Util/Util.h>
using namespace ::hmibase;
using namespace ::hmi;

//====  defines and includes TTFis output - added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
#include "hmi_trace_if.h"
#include "View/CGI/CourierMsgTracing/CourierMessageMapTrace.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_SM
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/AppHmi_PhoneStateMachine.cpp.trc.h"
#endif                            
//====  defines and includes TTFis output - end                        key: SM_TTFis_SBHFMSRF ====

// ------------------------------------------------------------------------

// ------------------------------------------------------------------------
bool SendAddNewDeviceReq()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::AddNewDeviceReq)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendDeviceListReq()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::DeviceListReq)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendDeleteDeviceConfirmationReq()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::DeleteDeviceConfirmationReq)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendDisconnectDeviceConfirmationReq()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::DisconnectDeviceConfirmationReq)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendOnBackButtonPressMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::OnBackButtonPressMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendResetListDataReq(Courier::UInt8 const & aListID)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ResetListDataReq)(aListID);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSSPResponseReq(btphn_tenBTPairingResponse const & aPairingResponse)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SSPResponseReq)(aPairingResponse);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendIncomingCallResponseReq(btphn_tenPhoneIncomingCallResponse const & aCallStatus)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::IncomingCallResponseReq)(aCallStatus);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendIntercomCallResponseReq(IntercomCallResponse const & aCallActionStatus)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::IntercomCallResponseReq)(aCallActionStatus);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendTerminateIConfCall()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::TerminateIConfCall)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendTerminateCallReq()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::TerminateCallReq)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendCancelDialCallReq()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::CancelDialCallReq)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendDialCall_ModelReq()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::DialCall_ModelReq)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendCallListReq()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::CallListReq)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendIContactsReq()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::IContactsReq)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendIntercomStatusMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::IntercomStatusMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendTransferVehicleAudioReq()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::TransferVehicleAudioReq)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendClearEditFieldRequestReq()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ClearEditFieldRequestReq)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendMicMuteStateReq()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::MicMuteStateReq)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendMessageDialReq()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::MessageDialReq)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSwapMultipleCallReq()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SwapMultipleCallReq)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendChangeRingtoneSettingsReq()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ChangeRingtoneSettingsReq)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendChangeSMSSettingsReq()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ChangeSMSSettingsReq)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendReadMessageAloudReq(btphn_trMsgPlayBackAction const & aPlayBackAction)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ReadMessageAloudReq)(aPlayBackAction);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendMatchListEntryReq()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::MatchListEntryReq)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendContactDetailsReq(Courier::UInt16 const & aContactListIndex)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ContactDetailsReq)(aContactListIndex);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendContactListReq(bool const & aIsPersistencyRequired)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ContactListReq)(aIsPersistencyRequired);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendRingtoneMuteReq()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::RingtoneMuteReq)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendActivateSPIReq()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ActivateSPIReq)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendActivateListenReq()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ActivateListenReq)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPhoneGadgetRequestMsg(Courier::UInt8 const & aRequestType)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::PhoneGadgetRequestMsg)(aRequestType);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendNetworkOperatorReq()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::NetworkOperatorReq)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSwitchApplicationStateReq(Candera::UInt16 const & aApplicationID, Candera::UInt16 const & aApplicationState, Candera::UInt8 const & aActivityID)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SwitchApplicationStateReq)(aApplicationID, aApplicationState, aActivityID);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSwitchApplicationReq(enApplicationId const & aApplicationID, enSurfaceId const & aSurfaceID)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SwitchApplicationReq)(aApplicationID, aSurfaceID);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendViewPhoneActivityId()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ViewPhoneActivityId)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendBTVRSessionStartAppReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::BTVRSessionStartAppReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendBTVRSessionStopAppReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::BTVRSessionStopAppReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendBTVROnExitMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::BTVROnExitMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendBTVRSessionExitAppReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::BTVRSessionExitAppReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPrivateModeUpdateMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::PrivateModeUpdateMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendGuiStartupFinishedUpdMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::GuiStartupFinishedUpdMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendChangeLanguageReqMsg(enLanguageId const & aLanguageId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ChangeLanguageReqMsg)(aLanguageId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendFocusReqMsg(FocusActionEnum const & aAction, FocusTimerActionEnum const & aTimerAction, ::Courier::ViewId const & aView, Candera::String const & aWidget)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::FocusReqMsg)(aAction, aTimerAction, aView, aWidget);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendDummyMess(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::DummyMess)(aFirstView, aSecondView, aPos);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendAnimationReqMsg(Courier::AnimationAction::Enum const & aAnimationAction, ::Courier::ViewId const & aViewId, Courier::CompositePath const & aCompositePath, ::Courier::ItemId const & aAnimationId, Courier::AnimationProperties const & aAnimationProperties)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::Courier::AnimationReqMsg)(aAnimationAction, aViewId, aCompositePath, aAnimationId, aAnimationProperties);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendFocusOnRightEncoderReqUpdMsg(bool const & aIsFocusUsed)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::FocusOnRightEncoderReqUpdMsg)(aIsFocusUsed);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendStoreActiveGadgetReqMsg(bool const & aIsGadgetAtive)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::StoreActiveGadgetReqMsg)(aIsGadgetAtive);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendHardKeyPressNotificationMsg(Courier::UInt8 const & aDummy, Courier::UInt8 const & aHKCode, Courier::UInt8 const & aHKState)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::HardKeyPressNotificationMsg)(aDummy, aHKCode, aHKState);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendDropdownChangeMsg(::Candera::DropdownChangeType const & aDropdownChangeType, ::Courier::UInt32 const & aListId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::DropdownChangeMsg)(aDropdownChangeType, aListId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendStartPopupTimerReqMsg(Courier::UInt32 const & aViewId, Courier::UInt32 const & aTimeout)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::StartPopupTimerReqMsg)(aViewId, aTimeout);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendStopPopupTimerReqMsg(Courier::UInt32 const & aViewId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::StopPopupTimerReqMsg)(aViewId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPlayBeepReqMsg(Courier::Int32 const & aBeepType)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::PlayBeepReqMsg)(aBeepType);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendCheckToClosePopupMsg(Courier::UInt32 const & aPopupId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::CheckToClosePopupMsg)(aPopupId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendRestartPopupTimerReqMsg(Courier::UInt32 const & aViewId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::RestartPopupTimerReqMsg)(aViewId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendContextSwitchInResMsg(Courier::UInt32 const & aSwitchId, Courier::UInt32 const & aResponseType)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ContextSwitchInResMsg)(aSwitchId, aResponseType);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendContextSwitchOutReqMsg(Courier::UInt32 const & aTargetContextId, Courier::UInt32 const & aSourceContextId, Courier::UInt32 const & aTargetAppId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ContextSwitchOutReqMsg)(aTargetContextId, aSourceContextId, aTargetAppId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendCurrentScreenDisplayReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::CurrentScreenDisplayReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendLaunchBarDisplayReqMsg(bool const & aVisibility)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::LaunchBarDisplayReqMsg)(aVisibility);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendNavTBTSwipeReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::NavTBTSwipeReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendListItemRightEncoderChangeUpdMsg(Courier::Int8 const & aSteps, Courier::UInt32 const & aListId, Courier::UInt32 const & aRowId, Courier::UInt32 const & aColumnId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ListItemRightEncoderChangeUpdMsg)(aSteps, aListId, aRowId, aColumnId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendListChangeMsg(::Courier::UInt32 const & aListId, ListChangeType const & aListChangeType, ::Courier::Int32 const & aValue, ListChangeMsgSourceType const & aListChangeMsgSource, bool const & aImmediatePositioning)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ListChangeMsg)(aListId, aListChangeType, aValue, aListChangeMsgSource, aImmediatePositioning);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendListFocusScrollReqMsg(Courier::UInt32 const & aListId, Courier::Int32 const & aSteps)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ListFocusScrollReqMsg)(aListId, aSteps);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendListFocusLockDataResetReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ListFocusLockDataResetReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSetApplicationModeReqMsg(Courier::UInt32 const & aModeId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SetApplicationModeReqMsg)(aModeId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSpellerBbehaviorReqMsg(bool const & aEnable)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SpellerBbehaviorReqMsg)(aEnable);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendStatusBarDisplayReqMsg(bool const & aVisibility, Courier::Int32 const & aHeaderType)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::StatusBarDisplayReqMsg)(aVisibility, aHeaderType);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendTBTRetriggerAcousticMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::TBTRetriggerAcousticMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendViewReqMsg(Courier::ViewAction::Enum const & aViewAction, ::Courier::ViewId const & aViewId, bool const & aShallInitScene, bool const & aShallLoadScene)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::Courier::ViewReqMsg)(aViewAction, aViewId, aShallInitScene, aShallLoadScene);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendActivationReqMsg(::Courier::ViewId const & aViewId, bool const & aActivation, bool const & aEnableRendering)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::Courier::ActivationReqMsg)(aViewId, aActivation, aEnableRendering);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendAsyncLoadReqMsg(::Courier::ViewId const & aViewId, bool const & aLoad)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::Courier::AsyncLoadReqMsg)(aViewId, aLoad);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPopupReqMsg(hmibase::popups::CommandEnum const & aCommand, ::Courier::ViewId const & aViewId, Courier::UInt32 const & aPopupDisplayID)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::PopupReqMsg)(aCommand, aViewId, aPopupDisplayID);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendExtendedViewReqMsg(hmibase::views::CommandEnum const & aCommand, ::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ExtendedViewReqMsg)(aCommand, aViewId, aHint);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendShowHMISubSurfaceReqMsg(hmibase::displayRegion const & aDisplayRegion, Courier::Int32 const & aDisplayRegionType, bool const & aShowSubSurface, Courier::UInt32 const & aDisplayID, bool const & aLockSubSurface)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ShowHMISubSurfaceReqMsg)(aDisplayRegion, aDisplayRegionType, aShowSubSurface, aDisplayID, aLockSubSurface);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendRegisterForCloseOnTouchSessionReqMsg(bool const & aRegister, ::Courier::ViewId const & aViewId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::RegisterForCloseOnTouchSessionReqMsg)(aRegister, aViewId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPopupFilterPrioEnableReqMsg(Courier::UInt32 const & aPrio)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::PopupFilterPrioEnableReqMsg)(aPrio);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPopupFilterAllEnableReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::PopupFilterAllEnableReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPopupFilterDisableReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::PopupFilterDisableReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendProfileSwitchMsg(Courier::UInt32 const & aProfile)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ProfileSwitchMsg)(aProfile);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendMultiDisplayPopupFilterReqMsg(hmibase::PopupFilterType const & aPopupFilterType, Courier::UInt32 const & aPrio, Courier::UInt32 const & aDisplayID)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::MultiDisplayPopupFilterReqMsg)(aPopupFilterType, aPrio, aDisplayID);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendCreateNewDestroyOld(::Courier::ViewId const & aSourceView, ::Courier::ViewId const & aDestinationView, Courier::UInt32 const & aUserData1, Courier::Int8 const & aUserData2)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::CreateNewDestroyOld)(aSourceView, aDestinationView, aUserData1, aUserData2);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendNotifierMessage()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::NotifierMessage)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_AddNewDevice(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_AppHmi_PhoneModule_AddNewDevice();
    return true;
}
#endif
void Action_Perform_AppHmi_PhoneModule_AddNewDevice()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action Perform_AppHmi_PhoneModule_AddNewDevice()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAddNewDeviceReq();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_DeviceListReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_AppHmi_PhoneModule_DeviceListReq();
    return true;
}
#endif
void Action_Perform_AppHmi_PhoneModule_DeviceListReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action Perform_AppHmi_PhoneModule_DeviceListReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDeviceListReq();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_DeleteDeviceConfirmationReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_AppHmi_PhoneModule_DeleteDeviceConfirmationReq();
    return true;
}
#endif
void Action_Perform_AppHmi_PhoneModule_DeleteDeviceConfirmationReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action Perform_AppHmi_PhoneModule_DeleteDeviceConfirmationReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDeleteDeviceConfirmationReq();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_DisconnectDeviceConfirmationReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_AppHmi_PhoneModule_DisconnectDeviceConfirmationReq();
    return true;
}
#endif
void Action_Perform_AppHmi_PhoneModule_DisconnectDeviceConfirmationReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action Perform_AppHmi_PhoneModule_DisconnectDeviceConfirmationReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDisconnectDeviceConfirmationReq();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_BackButtonPressReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_AppHmi_PhoneModule_BackButtonPressReq();
    return true;
}
#endif
void Action_Perform_AppHmi_PhoneModule_BackButtonPressReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action Perform_AppHmi_PhoneModule_BackButtonPressReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendOnBackButtonPressMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_ResetCallListDataReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_AppHmi_PhoneModule_ResetCallListDataReq();
    return true;
}
#endif
void Action_Perform_AppHmi_PhoneModule_ResetCallListDataReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action Perform_AppHmi_PhoneModule_ResetCallListDataReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendResetListDataReq(2);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_ResetContactListDataReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_AppHmi_PhoneModule_ResetContactListDataReq();
    return true;
}
#endif
void Action_Perform_AppHmi_PhoneModule_ResetContactListDataReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action Perform_AppHmi_PhoneModule_ResetContactListDataReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendResetListDataReq(3);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_Pairing_No(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_AppHmi_PhoneModule_Pairing_No();
    return true;
}
#endif
void Action_Perform_AppHmi_PhoneModule_Pairing_No()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action Perform_AppHmi_PhoneModule_Pairing_No()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSSPResponseReq(BTPHN_EN_PAIRING_RESPONSE_NO);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_Pairing_Cancel(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_AppHmi_PhoneModule_Pairing_Cancel();
    return true;
}
#endif
void Action_Perform_AppHmi_PhoneModule_Pairing_Cancel()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action Perform_AppHmi_PhoneModule_Pairing_Cancel()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSSPResponseReq(BTPHN_EN_PAIRING_RESPONSE_CANCEL);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_Pairing_Yes(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_AppHmi_PhoneModule_Pairing_Yes();
    return true;
}
#endif
void Action_Perform_AppHmi_PhoneModule_Pairing_Yes()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action Perform_AppHmi_PhoneModule_Pairing_Yes()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSSPResponseReq(BTPHN_EN_PAIRING_RESPONSE_YES);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_AcceptCall(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_AppHmi_PhoneModule_AcceptCall();
    return true;
}
#endif
void Action_Perform_AppHmi_PhoneModule_AcceptCall()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action Perform_AppHmi_PhoneModule_AcceptCall()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendIncomingCallResponseReq(BTPHN_EN_INCOMINGCALL_RESPONSE_ACCEPT);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_RejectCall(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_AppHmi_PhoneModule_RejectCall();
    return true;
}
#endif
void Action_Perform_AppHmi_PhoneModule_RejectCall()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action Perform_AppHmi_PhoneModule_RejectCall()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendIncomingCallResponseReq(BTPHN_EN_INCOMINGCALL_RESPONSE_REJECT);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Intercom_AcceptCall(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Intercom_AcceptCall();
    return true;
}
#endif
void Action_Perform_Intercom_AcceptCall()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action Perform_Intercom_AcceptCall()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendIntercomCallResponseReq(INTERCOMCALL_RESPONSE_ACCEPT);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Intercom_RejectCall(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Intercom_RejectCall();
    return true;
}
#endif
void Action_Perform_Intercom_RejectCall()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action Perform_Intercom_RejectCall()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendIntercomCallResponseReq(INTERCOMCALL_RESPONSE_REJECT);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Intercom_RejectConfCall(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Intercom_RejectConfCall();
    return true;
}
#endif
void Action_Perform_Intercom_RejectConfCall()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action Perform_Intercom_RejectConfCall()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendIntercomCallResponseReq(INTERCOMCALL_RESPONSE_CONF_REJECT);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_IConference_RejectCall(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_IConference_RejectCall();
    return true;
}
#endif
void Action_Perform_IConference_RejectCall()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action Perform_IConference_RejectCall()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTerminateIConfCall();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_HangUpCall(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_AppHmi_PhoneModule_HangUpCall();
    return true;
}
#endif
void Action_Perform_AppHmi_PhoneModule_HangUpCall()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action Perform_AppHmi_PhoneModule_HangUpCall()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTerminateCallReq();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_CancelDialing(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_AppHmi_PhoneModule_CancelDialing();
    return true;
}
#endif
void Action_Perform_AppHmi_PhoneModule_CancelDialing()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action Perform_AppHmi_PhoneModule_CancelDialing()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendCancelDialCallReq();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_DialCall_Model(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_AppHmi_PhoneModule_DialCall_Model();
    return true;
}
#endif
void Action_Perform_AppHmi_PhoneModule_DialCall_Model()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action Perform_AppHmi_PhoneModule_DialCall_Model()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDialCall_ModelReq();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_CallListReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_AppHmi_PhoneModule_CallListReq();
    return true;
}
#endif
void Action_Perform_AppHmi_PhoneModule_CallListReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action Perform_AppHmi_PhoneModule_CallListReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendCallListReq();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_IContactsReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_AppHmi_PhoneModule_IContactsReq();
    return true;
}
#endif
void Action_Perform_AppHmi_PhoneModule_IContactsReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action Perform_AppHmi_PhoneModule_IContactsReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendIContactsReq();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_IntercomStatusMsg(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_AppHmi_PhoneModule_IntercomStatusMsg();
    return true;
}
#endif
void Action_Perform_AppHmi_PhoneModule_IntercomStatusMsg()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action Perform_AppHmi_PhoneModule_IntercomStatusMsg()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendIntercomStatusMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_Handsfree_Status_ChangeReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_AppHmi_PhoneModule_Handsfree_Status_ChangeReq();
    return true;
}
#endif
void Action_Perform_AppHmi_PhoneModule_Handsfree_Status_ChangeReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action Perform_AppHmi_PhoneModule_Handsfree_Status_ChangeReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTransferVehicleAudioReq();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_Clear_EditFieldReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_AppHmi_PhoneModule_Clear_EditFieldReq();
    return true;
}
#endif
void Action_Perform_AppHmi_PhoneModule_Clear_EditFieldReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action Perform_AppHmi_PhoneModule_Clear_EditFieldReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendClearEditFieldRequestReq();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_MicMute_Status_ChangeReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_AppHmi_PhoneModule_MicMute_Status_ChangeReq();
    return true;
}
#endif
void Action_Perform_AppHmi_PhoneModule_MicMute_Status_ChangeReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action Perform_AppHmi_PhoneModule_MicMute_Status_ChangeReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendMicMuteStateReq();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_MessageCall(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_AppHmi_PhoneModule_MessageCall();
    return true;
}
#endif
void Action_Perform_AppHmi_PhoneModule_MessageCall()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action Perform_AppHmi_PhoneModule_MessageCall()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendMessageDialReq();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_SwapMultipleCallReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_AppHmi_PhoneModule_SwapMultipleCallReq();
    return true;
}
#endif
void Action_Perform_AppHmi_PhoneModule_SwapMultipleCallReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action Perform_AppHmi_PhoneModule_SwapMultipleCallReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSwapMultipleCallReq();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_ChangeRingtoneSettingsReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_AppHmi_PhoneModule_ChangeRingtoneSettingsReq();
    return true;
}
#endif
void Action_Perform_AppHmi_PhoneModule_ChangeRingtoneSettingsReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action Perform_AppHmi_PhoneModule_ChangeRingtoneSettingsReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendChangeRingtoneSettingsReq();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_ChangeSMSSettingsReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_AppHmi_PhoneModule_ChangeSMSSettingsReq();
    return true;
}
#endif
void Action_Perform_AppHmi_PhoneModule_ChangeSMSSettingsReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action Perform_AppHmi_PhoneModule_ChangeSMSSettingsReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendChangeSMSSettingsReq();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_PlayReadMessageAloudReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_AppHmi_PhoneModule_PlayReadMessageAloudReq();
    return true;
}
#endif
void Action_Perform_AppHmi_PhoneModule_PlayReadMessageAloudReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action Perform_AppHmi_PhoneModule_PlayReadMessageAloudReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendReadMessageAloudReq(BTPHN_EN_E8PBA_PLAY);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_StopReadMessageAloudReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_AppHmi_PhoneModule_StopReadMessageAloudReq();
    return true;
}
#endif
void Action_Perform_AppHmi_PhoneModule_StopReadMessageAloudReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action Perform_AppHmi_PhoneModule_StopReadMessageAloudReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendReadMessageAloudReq(BTPHN_EN_E8PBA_STOP);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_MatchListEntryReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_AppHmi_PhoneModule_MatchListEntryReq();
    return true;
}
#endif
void Action_Perform_AppHmi_PhoneModule_MatchListEntryReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action Perform_AppHmi_PhoneModule_MatchListEntryReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendMatchListEntryReq();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_ContactDetailsListEntryReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_AppHmi_PhoneModule_ContactDetailsListEntryReq();
    return true;
}
#endif
void Action_Perform_AppHmi_PhoneModule_ContactDetailsListEntryReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action Perform_AppHmi_PhoneModule_ContactDetailsListEntryReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendContactDetailsReq(255);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_ContactListReq_History(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_AppHmi_PhoneModule_ContactListReq_History();
    return true;
}
#endif
void Action_Perform_AppHmi_PhoneModule_ContactListReq_History()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action Perform_AppHmi_PhoneModule_ContactListReq_History()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendContactListReq(TRUE);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_ContactListReq_Begining(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_AppHmi_PhoneModule_ContactListReq_Begining();
    return true;
}
#endif
void Action_Perform_AppHmi_PhoneModule_ContactListReq_Begining()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action Perform_AppHmi_PhoneModule_ContactListReq_Begining()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendContactListReq(FALSE);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_Ringtone_Mute(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_AppHmi_PhoneModule_Ringtone_Mute();
    return true;
}
#endif
void Action_Perform_AppHmi_PhoneModule_Ringtone_Mute()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action Perform_AppHmi_PhoneModule_Ringtone_Mute()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendRingtoneMuteReq();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Activate_SPI_Application(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Activate_SPI_Application();
    return true;
}
#endif
void Action_Perform_Activate_SPI_Application()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action Perform_Activate_SPI_Application()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendActivateSPIReq();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Activate_Listen(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Activate_Listen();
    return true;
}
#endif
void Action_Perform_Activate_Listen()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action Perform_Activate_Listen()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendActivateListenReq();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_ActivatePhoneGadgetResponse(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_ActivatePhoneGadgetResponse(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_ActivatePhoneGadgetResponse(Courier::UInt8 const & aRequestType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action ActivatePhoneGadgetResponse(aRequestType = %d)", aRequestType));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPhoneGadgetRequestMsg(aRequestType);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Network_Operator_Req(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Network_Operator_Req();
    return true;
}
#endif
void Action_Perform_Network_Operator_Req()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action Perform_Network_Operator_Req()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendNetworkOperatorReq();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Activate_Radio_Application(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Activate_Radio_Application();
    return true;
}
#endif
void Action_Perform_Activate_Radio_Application()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action Perform_Activate_Radio_Application()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSwitchApplicationStateReq(TUNER_APP_ID, EN_APP_STATE_FG, 0);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Activate_Media_Application(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Activate_Media_Application();
    return true;
}
#endif
void Action_Perform_Activate_Media_Application()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action Perform_Activate_Media_Application()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSwitchApplicationStateReq(MEDIA_APP_ID, EN_APP_STATE_FG, eActivityID_MEDIA_PLAY);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Activate_Media_Source_Selection(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Activate_Media_Source_Selection();
    return true;
}
#endif
void Action_Perform_Activate_Media_Source_Selection()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action Perform_Activate_Media_Source_Selection()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSwitchApplicationStateReq(MEDIA_APP_ID, EN_APP_STATE_FG, eActivityID_MEDIA_SOURCE_SELECTION);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Activate_Home_Source(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Activate_Home_Source();
    return true;
}
#endif
void Action_Perform_Activate_Home_Source()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action Perform_Activate_Home_Source()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSwitchApplicationReq(APPID_APPHMI_MASTER, SURFACEID_MAIN_SURFACE_MASTER);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Phone_ActivityId(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Phone_ActivityId();
    return true;
}
#endif
void Action_Phone_ActivityId()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action Phone_ActivityId()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendViewPhoneActivityId();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Activate_Navi_Application(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Activate_Navi_Application();
    return true;
}
#endif
void Action_Perform_Activate_Navi_Application()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action Perform_Activate_Navi_Application()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSwitchApplicationStateReq(NAVI_APP_ID, EN_APP_STATE_FG, eActivityID_NAVI_MAP);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Activate_BTPhone_Application_Call_List(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Activate_BTPhone_Application_Call_List();
    return true;
}
#endif
void Action_Perform_Activate_BTPhone_Application_Call_List()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action Perform_Activate_BTPhone_Application_Call_List()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSwitchApplicationStateReq(PHONE_APP_ID, EN_APP_STATE_FG, eActivityID_PHONE_CALL_LIST);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Activate_BTPhone_Application_Contact_List(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Activate_BTPhone_Application_Contact_List();
    return true;
}
#endif
void Action_Perform_Activate_BTPhone_Application_Contact_List()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action Perform_Activate_BTPhone_Application_Contact_List()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSwitchApplicationStateReq(PHONE_APP_ID, EN_APP_STATE_FG, eActivityID_PHONE_CONTACT_LIST);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Activate_BTPhone_Application_Device_List(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Activate_BTPhone_Application_Device_List();
    return true;
}
#endif
void Action_Perform_Activate_BTPhone_Application_Device_List()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action Perform_Activate_BTPhone_Application_Device_List()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSwitchApplicationStateReq(PHONE_APP_ID, EN_APP_STATE_FG, eActivityID_PHONE_DEVICE_SELECTION);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Activate_BTPhone_Application_Call_Connecting(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Activate_BTPhone_Application_Call_Connecting();
    return true;
}
#endif
void Action_Perform_Activate_BTPhone_Application_Call_Connecting()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action Perform_Activate_BTPhone_Application_Call_Connecting()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSwitchApplicationStateReq(PHONE_APP_ID, EN_APP_STATE_FG, eActivityID_PHONE_CALL_CONNECTING);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Activate_BTPhone_Application_On_Call(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Activate_BTPhone_Application_On_Call();
    return true;
}
#endif
void Action_Perform_Activate_BTPhone_Application_On_Call()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action Perform_Activate_BTPhone_Application_On_Call()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSwitchApplicationStateReq(PHONE_APP_ID, EN_APP_STATE_FG, eActivityID_PHONE_ON_CALL);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Activate_BTPhone_Application_On_Multiparty_Call(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Activate_BTPhone_Application_On_Multiparty_Call();
    return true;
}
#endif
void Action_Perform_Activate_BTPhone_Application_On_Multiparty_Call()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action Perform_Activate_BTPhone_Application_On_Multiparty_Call()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSwitchApplicationStateReq(PHONE_APP_ID, EN_APP_STATE_FG, eActivityID_PHONE_ON_MULTIPARTY_CALL);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Deactivate_BTPhone_Application(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Deactivate_BTPhone_Application();
    return true;
}
#endif
void Action_Perform_Deactivate_BTPhone_Application()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action Perform_Deactivate_BTPhone_Application()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSwitchApplicationStateReq(PHONE_APP_ID, EN_APP_STATE_BG, 0);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Activate_BT_SR_Session(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Activate_BT_SR_Session();
    return true;
}
#endif
void Action_Activate_BT_SR_Session()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action Activate_BT_SR_Session()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendBTVRSessionStartAppReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Halt_BT_SR_Session(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Halt_BT_SR_Session();
    return true;
}
#endif
void Action_Halt_BT_SR_Session()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action Halt_BT_SR_Session()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendBTVRSessionStopAppReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_BTVROnExitAction(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_BTVROnExitAction();
    return true;
}
#endif
void Action_BTVROnExitAction()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action BTVROnExitAction()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendBTVROnExitMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_DeActivate_BT_SR_Session(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_DeActivate_BT_SR_Session();
    return true;
}
#endif
void Action_DeActivate_BT_SR_Session()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action DeActivate_BT_SR_Session()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendBTVRSessionExitAppReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Activate_BTPhone_Application_On_Intercomcall(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Activate_BTPhone_Application_On_Intercomcall();
    return true;
}
#endif
void Action_Perform_Activate_BTPhone_Application_On_Intercomcall()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action Perform_Activate_BTPhone_Application_On_Intercomcall()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSwitchApplicationStateReq(PHONE_APP_ID, EN_APP_STATE_FG, eActivityID_PHONE_ON_INTERCOMCALL);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_AppHmi_PhoneModule_PrivateMode(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_AppHmi_PhoneModule_PrivateMode();
    return true;
}
#endif
void Action_Perform_AppHmi_PhoneModule_PrivateMode()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action Perform_AppHmi_PhoneModule_PrivateMode()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPrivateModeUpdateMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Language_Update(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Language_Update();
    return true;
}
#endif
void Action_Language_Update()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action Language_Update()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendGuiStartupFinishedUpdMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacChangeLanguageReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_gacChangeLanguageReq(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_gacChangeLanguageReq(enLanguageId const & aLanguageId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacChangeLanguageReq(aLanguageId = ?enLanguageId?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendChangeLanguageReqMsg(aLanguageId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacHideFocusInViewReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacHideFocusInViewReq(::Courier::ViewId(AppHmi_PhoneStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacHideFocusInViewReq(::Courier::ViewId const & aView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacHideFocusInViewReq(aView = %50s)", aView.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendFocusReqMsg(FOCUS_HIDE, FOCUS_TIMER_NO_ACTION, aView, Candera::String());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_NextLevelTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_NextLevelTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_NextLevelTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action NextLevelTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_PreviousLevelTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_PreviousLevelTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_PreviousLevelTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action PreviousLevelTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_DualViewLeftTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_DualViewLeftTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_DualViewLeftTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action DualViewLeftTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_DualViewRightTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_DualViewRightTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_DualViewRightTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action DualViewRightTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_PageFlipBackTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_PageFlipBackTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_PageFlipBackTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action PageFlipBackTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_PageFlipFrontTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_PageFlipFrontTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_PageFlipFrontTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action PageFlipFrontTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_ZoomInTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 3) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt() && parameters[(::Json::Value::UInt)2].isInt())) { return false; }
    Action_ZoomInTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt(), parameters[(::Json::Value::UInt)2].asInt());
    return true;
}
#endif
void Action_ZoomInTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action ZoomInTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?, aPos = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, aPos);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_ZoomOutTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 3) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt() && parameters[(::Json::Value::UInt)2].isInt())) { return false; }
    Action_ZoomOutTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt(), parameters[(::Json::Value::UInt)2].asInt());
    return true;
}
#endif
void Action_ZoomOutTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action ZoomOutTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?, aPos = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, aPos);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_FadeTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_FadeTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_FadeTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action FadeTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacWaitAnimationStartReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacWaitAnimationStartReq();
    return true;
}
#endif
void Action_gacWaitAnimationStartReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacWaitAnimationStartReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAnimationReqMsg(Courier::AnimationAction::Start, ::Courier::ViewId(), Courier::CompositePath(), ::Courier::ItemId("Global#Animations#WAIT_ANIMATION"), Courier::AnimationProperties());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acFocusOnRightEncoderReqUpd(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_acFocusOnRightEncoderReqUpd(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_acFocusOnRightEncoderReqUpd(bool const & aIsFocusUsed)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action acFocusOnRightEncoderReqUpd(aIsFocusUsed = %d)", aIsFocusUsed));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendFocusOnRightEncoderReqUpdMsg(aIsFocusUsed);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSetGadgetSceenActiveStatus(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_acSetGadgetSceenActiveStatus(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_acSetGadgetSceenActiveStatus(bool const & aIsGadgetAtive)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action acSetGadgetSceenActiveStatus(aIsGadgetAtive = %d)", aIsGadgetAtive));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendStoreActiveGadgetReqMsg(aIsGadgetAtive);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acHKNotificationMsg(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_acHKNotificationMsg(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_acHKNotificationMsg(Courier::UInt8 const & aHKCode, Courier::UInt8 const & aHKState)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action acHKNotificationMsg(aHKCode = %d, aHKState = %d)", aHKCode,aHKState));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendHardKeyPressNotificationMsg(1, aHKCode, aHKState);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acPerform_CloseAllDropdowns(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acPerform_CloseAllDropdowns();
    return true;
}
#endif
void Action_acPerform_CloseAllDropdowns()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action acPerform_CloseAllDropdowns()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDropdownChangeMsg(Candera::DropdownChangeClose, 0);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acPerform_CloseDropdown(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acPerform_CloseDropdown(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acPerform_CloseDropdown(::Courier::UInt32 const & aListId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action acPerform_CloseDropdown(aListId = ?::Courier::UInt32?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDropdownChangeMsg(Candera::DropdownChangeClose, aListId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acPerform_OpenDropdown(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acPerform_OpenDropdown(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acPerform_OpenDropdown(::Courier::UInt32 const & aListId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action acPerform_OpenDropdown(aListId = ?::Courier::UInt32?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDropdownChangeMsg(Candera::DropdownChangeOpen, aListId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acPerform_ToggleDropdown(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acPerform_ToggleDropdown(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acPerform_ToggleDropdown(::Courier::UInt32 const & aListId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action acPerform_ToggleDropdown(aListId = ?::Courier::UInt32?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDropdownChangeMsg(Candera::DropdownChangeToggle, aListId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acStartAppPopupTimer(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_acStartAppPopupTimer(parameters[(::Json::Value::UInt)0].asUInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_acStartAppPopupTimer(Courier::UInt32 const & aViewId, Courier::UInt32 const & aTimeout)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action acStartAppPopupTimer(aViewId = %d, aTimeout = %d)", aViewId,aTimeout));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendStartPopupTimerReqMsg(aViewId, aTimeout);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acStopAppPopupTimer(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acStopAppPopupTimer(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acStopAppPopupTimer(Courier::UInt32 const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action acStopAppPopupTimer(aViewId = %d)", aViewId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendStopPopupTimerReqMsg(aViewId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acPostBeep(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_acPostBeep(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_acPostBeep(Courier::Int32 const & aBeepType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action acPostBeep(aBeepType = %d)", aBeepType));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPlayBeepReqMsg(aBeepType);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacCheckToClosePopup(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacCheckToClosePopup(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacCheckToClosePopup(Courier::UInt32 const & aPopupId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacCheckToClosePopup(aPopupId = %d)", aPopupId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendCheckToClosePopupMsg(aPopupId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acRestartAppPopupTimer(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acRestartAppPopupTimer(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acRestartAppPopupTimer(Courier::UInt32 const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action acRestartAppPopupTimer(aViewId = %d)", aViewId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendRestartPopupTimerReqMsg(aViewId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchBackRes(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacContextSwitchBackRes(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacContextSwitchBackRes(Courier::UInt32 const & aSwitchId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacContextSwitchBackRes(aSwitchId = %d)", aSwitchId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendContextSwitchInResMsg(aSwitchId, CONTEXT_TRANSITION_BACK);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchCompleteRes(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacContextSwitchCompleteRes(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacContextSwitchCompleteRes(Courier::UInt32 const & aSwitchId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacContextSwitchCompleteRes(aSwitchId = %d)", aSwitchId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendContextSwitchInResMsg(aSwitchId, CONTEXT_TRANSITION_COMPLETE);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchFailedRes(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacContextSwitchFailedRes(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacContextSwitchFailedRes(Courier::UInt32 const & aSwitchId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacContextSwitchFailedRes(aSwitchId = %d)", aSwitchId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendContextSwitchInResMsg(aSwitchId, CONTEXT_TRANSITION_FAILED);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchDoneRes(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacContextSwitchDoneRes(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacContextSwitchDoneRes(Courier::UInt32 const & aSwitchId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacContextSwitchDoneRes(aSwitchId = %d)", aSwitchId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendContextSwitchInResMsg(aSwitchId, CONTEXT_TRANSITION_DONE);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchOutReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 3) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt() && parameters[(::Json::Value::UInt)2].isUInt())) { return false; }
    Action_gacContextSwitchOutReq(parameters[(::Json::Value::UInt)0].asUInt(), parameters[(::Json::Value::UInt)1].asUInt(), parameters[(::Json::Value::UInt)2].asUInt());
    return true;
}
#endif
void Action_gacContextSwitchOutReq(Courier::UInt32 const & aTargetContextId, Courier::UInt32 const & aSourceContextId, Courier::UInt32 const & aTargetAppId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacContextSwitchOutReq(aTargetContextId = %d, aSourceContextId = %d, aTargetAppId = %d)", aTargetContextId,aSourceContextId,aTargetAppId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendContextSwitchOutReqMsg(aTargetContextId, aSourceContextId, aTargetAppId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacCurrentScreenDisplayReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacCurrentScreenDisplayReq();
    return true;
}
#endif
void Action_gacCurrentScreenDisplayReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacCurrentScreenDisplayReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendCurrentScreenDisplayReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacLaunchBarDisplayReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_gacLaunchBarDisplayReq(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_gacLaunchBarDisplayReq(bool const & aVisibility)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacLaunchBarDisplayReq(aVisibility = %d)", aVisibility));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendLaunchBarDisplayReqMsg(aVisibility);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacNavTBTSwipe(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacNavTBTSwipe();
    return true;
}
#endif
void Action_gacNavTBTSwipe()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacNavTBTSwipe()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendNavTBTSwipeReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPerformListBtnRightEncoderChangeUpd(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 4) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isUInt() && parameters[(::Json::Value::UInt)2].isUInt() && parameters[(::Json::Value::UInt)3].isUInt())) { return false; }
    Action_gacPerformListBtnRightEncoderChangeUpd(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asUInt(), parameters[(::Json::Value::UInt)2].asUInt(), parameters[(::Json::Value::UInt)3].asUInt());
    return true;
}
#endif
void Action_gacPerformListBtnRightEncoderChangeUpd(Courier::Int8 const & aSteps, Courier::UInt32 const & aListId, Courier::UInt32 const & aRowId, Courier::UInt32 const & aColumnId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacPerformListBtnRightEncoderChangeUpd(aSteps = %d, aListId = %d, aRowId = %d, aColumnId = %d)", aSteps,aListId,aRowId,aColumnId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListItemRightEncoderChangeUpdMsg(aSteps, aListId, aRowId, aColumnId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListUp(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacScrollListUp();
    return true;
}
#endif
void Action_gacScrollListUp()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacScrollListUp()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListChangeMsg(::Courier::UInt32(), ListChangeUp, 1, ListChangeMsgSourceUnknown, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListDown(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacScrollListDown();
    return true;
}
#endif
void Action_gacScrollListDown()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacScrollListDown()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListChangeMsg(::Courier::UInt32(), ListChangeDown, 1, ListChangeMsgSourceUnknown, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacScrollPageUp(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacScrollPageUp();
    return true;
}
#endif
void Action_gacScrollPageUp()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacScrollPageUp()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListChangeMsg(::Courier::UInt32(), ListChangePageUp, 1, ListChangeMsgSourceUnknown, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacScrollPageDown(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacScrollPageDown();
    return true;
}
#endif
void Action_gacScrollPageDown()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacScrollPageDown()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListChangeMsg(::Courier::UInt32(), ListChangePageDown, 1, ListChangeMsgSourceUnknown, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListFocusUp(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacScrollListFocusUp(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacScrollListFocusUp(Courier::UInt32 const & aListId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacScrollListFocusUp(aListId = %d)", aListId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListFocusScrollReqMsg(aListId, -1);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListFocusDown(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacScrollListFocusDown(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacScrollListFocusDown(Courier::UInt32 const & aListId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacScrollListFocusDown(aListId = %d)", aListId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListFocusScrollReqMsg(aListId, 1);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPerformListFocusLockDataResetUpd(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacPerformListFocusLockDataResetUpd();
    return true;
}
#endif
void Action_gacPerformListFocusLockDataResetUpd()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacPerformListFocusLockDataResetUpd()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListFocusLockDataResetReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacSetApplicationMode(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacSetApplicationMode(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacSetApplicationMode(Courier::UInt32 const & aModeId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacSetApplicationMode(aModeId = %d)", aModeId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSetApplicationModeReqMsg(aModeId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacSpellerBbehaviorReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_gacSpellerBbehaviorReq(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_gacSpellerBbehaviorReq(bool const & aEnable)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacSpellerBbehaviorReq(aEnable = %d)", aEnable));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSpellerBbehaviorReqMsg(aEnable);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacStatusBarDisplayReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_gacStatusBarDisplayReq(parameters[(::Json::Value::UInt)0].asBool(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_gacStatusBarDisplayReq(bool const & aVisibility, Courier::Int32 const & aHeaderType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacStatusBarDisplayReq(aVisibility = %d, aHeaderType = %d)", aVisibility,aHeaderType));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendStatusBarDisplayReqMsg(aVisibility, aHeaderType);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacTBTRetriggerAcousticOutput(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacTBTRetriggerAcousticOutput();
    return true;
}
#endif
void Action_gacTBTRetriggerAcousticOutput()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacTBTRetriggerAcousticOutput()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTBTRetriggerAcousticMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacWaitAnimationStopReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacWaitAnimationStopReq();
    return true;
}
#endif
void Action_gacWaitAnimationStopReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacWaitAnimationStopReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAnimationReqMsg(Courier::AnimationAction::Stop, ::Courier::ViewId(), Courier::CompositePath(), ::Courier::ItemId("Global#Animations#WAIT_ANIMATION"), Courier::AnimationProperties());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewCreateReq(::Courier::ViewId(AppHmi_PhoneStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewCreateReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacViewCreateReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendViewReqMsg(Courier::ViewAction::Create, aViewId, true, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateAllReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewCreateAllReq(::Courier::ViewId(AppHmi_PhoneStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewCreateAllReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacViewCreateAllReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendViewReqMsg(Courier::ViewAction::CreateAll, aViewId, true, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewDestroyReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewDestroyReq(::Courier::ViewId(AppHmi_PhoneStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewDestroyReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacViewDestroyReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendViewReqMsg(Courier::ViewAction::Destroy, aViewId, false, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewClearReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewClearReq(::Courier::ViewId(AppHmi_PhoneStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewClearReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacViewClearReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendViewReqMsg(Courier::ViewAction::Clear, aViewId, true, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewShowReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewShowReq(::Courier::ViewId(AppHmi_PhoneStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewShowReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacViewShowReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendActivationReqMsg(aViewId, true, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewHideReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewHideReq(::Courier::ViewId(AppHmi_PhoneStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewHideReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacViewHideReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendActivationReqMsg(aViewId, false, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateWithoutLoadReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewCreateWithoutLoadReq(::Courier::ViewId(AppHmi_PhoneStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewCreateWithoutLoadReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacViewCreateWithoutLoadReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendViewReqMsg(Courier::ViewAction::Create, aViewId, false, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewAsyncLoadReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewAsyncLoadReq(::Courier::ViewId(AppHmi_PhoneStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewAsyncLoadReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacViewAsyncLoadReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAsyncLoadReqMsg(aViewId, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewActivateWithoutRenderingReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewActivateWithoutRenderingReq(::Courier::ViewId(AppHmi_PhoneStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewActivateWithoutRenderingReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacViewActivateWithoutRenderingReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendActivationReqMsg(aViewId, true, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupCreateAndSBShowReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacPopupCreateAndSBShowReq(::Courier::ViewId(AppHmi_PhoneStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacPopupCreateAndSBShowReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacPopupCreateAndSBShowReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupReqMsg(hmibase::popups::Show, aViewId, hmibase::DEFAULT_UNKNOWN_DISPLAY);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupCreateAndSBShowReqForMultiDisplay(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacPopupCreateAndSBShowReqForMultiDisplay(parameters[(::Json::Value::UInt)0].asUInt(), ::Courier::ViewId(AppHmi_PhoneStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)1].asUInt())));
    return true;
}
#endif
void Action_gacPopupCreateAndSBShowReqForMultiDisplay(Courier::UInt32 const & aPopupDisplayID, ::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacPopupCreateAndSBShowReqForMultiDisplay(aPopupDisplayID = %d, aViewId = %50s)", aPopupDisplayID,aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupReqMsg(hmibase::popups::Show, aViewId, aPopupDisplayID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupSBCloseReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacPopupSBCloseReq(::Courier::ViewId(AppHmi_PhoneStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacPopupSBCloseReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacPopupSBCloseReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupReqMsg(hmibase::popups::Hide, aViewId, hmibase::DEFAULT_UNKNOWN_DISPLAY);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupSBCloseReqForMultiDisplay(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacPopupSBCloseReqForMultiDisplay(parameters[(::Json::Value::UInt)0].asUInt(), ::Courier::ViewId(AppHmi_PhoneStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)1].asUInt())));
    return true;
}
#endif
void Action_gacPopupSBCloseReqForMultiDisplay(Courier::UInt32 const & aPopupDisplayID, ::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacPopupSBCloseReqForMultiDisplay(aPopupDisplayID = %d, aViewId = %50s)", aPopupDisplayID,aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupReqMsg(hmibase::popups::Hide, aViewId, aPopupDisplayID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupRestartTimerReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacPopupRestartTimerReq(::Courier::ViewId(AppHmi_PhoneStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacPopupRestartTimerReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacPopupRestartTimerReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupReqMsg(hmibase::popups::RestartTimer, aViewId, hmibase::DEFAULT_UNKNOWN_DISPLAY);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupRestartTimerReqForMultiDisplay(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacPopupRestartTimerReqForMultiDisplay(parameters[(::Json::Value::UInt)0].asUInt(), ::Courier::ViewId(AppHmi_PhoneStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)1].asUInt())));
    return true;
}
#endif
void Action_gacPopupRestartTimerReqForMultiDisplay(Courier::UInt32 const & aPopupDisplayID, ::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacPopupRestartTimerReqForMultiDisplay(aPopupDisplayID = %d, aViewId = %50s)", aPopupDisplayID,aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupReqMsg(hmibase::popups::RestartTimer, aViewId, aPopupDisplayID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateAndShowReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewCreateAndShowReq(::Courier::ViewId(AppHmi_PhoneStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewCreateAndShowReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacViewCreateAndShowReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendExtendedViewReqMsg(hmibase::views::CreateAndShow, aViewId, 0);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewHideAndDestroyReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewHideAndDestroyReq(::Courier::ViewId(AppHmi_PhoneStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewHideAndDestroyReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacViewHideAndDestroyReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendExtendedViewReqMsg(hmibase::views::HideAndDestroy, aViewId, 0);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacSceneTransitionEnter(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacSceneTransitionEnter(::Courier::ViewId(AppHmi_PhoneStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt(), ))parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacSceneTransitionEnter(::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacSceneTransitionEnter(aViewId = %50s, aHint = %d)", aViewId.CStr(),aHint));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendExtendedViewReqMsg(hmibase::views::TransitionEnter, aViewId, aHint);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacSceneTransitionLeave(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacSceneTransitionLeave(::Courier::ViewId(AppHmi_PhoneStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt(), ))parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacSceneTransitionLeave(::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacSceneTransitionLeave(aViewId = %50s, aHint = %d)", aViewId.CStr(),aHint));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendExtendedViewReqMsg(hmibase::views::TransitionLeave, aViewId, aHint);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayStatusLineReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_gacDisplayStatusLineReq(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_gacDisplayStatusLineReq(Courier::Int32 const & aDisplayRegionType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacDisplayStatusLineReq(aDisplayRegionType = %d)", aDisplayRegionType));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::STATUS_LINE, aDisplayRegionType, true, hmibase::DEFAULT_UNKNOWN_DISPLAY, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacHideStatusLineReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_gacHideStatusLineReq(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_gacHideStatusLineReq(Courier::Int32 const & aDisplayRegionType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacHideStatusLineReq(aDisplayRegionType = %d)", aDisplayRegionType));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::STATUS_LINE, aDisplayRegionType, false, hmibase::DEFAULT_UNKNOWN_DISPLAY, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayFooterLineReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacDisplayFooterLineReq();
    return true;
}
#endif
void Action_gacDisplayFooterLineReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacDisplayFooterLineReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::FOOTER_LINE, Courier::Int32(), true, hmibase::DEFAULT_UNKNOWN_DISPLAY, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacHideFooterLineReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacHideFooterLineReq();
    return true;
}
#endif
void Action_gacHideFooterLineReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacHideFooterLineReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::FOOTER_LINE, Courier::Int32(), false, hmibase::DEFAULT_UNKNOWN_DISPLAY, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayStatusLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacDisplayStatusLineMultiDisplayReq(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacDisplayStatusLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacDisplayStatusLineMultiDisplayReq(aDisplayRegionType = %d, aDisplayID = %d)", aDisplayRegionType,aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::STATUS_LINE, aDisplayRegionType, true, aDisplayID, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacHideStatusLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacHideStatusLineMultiDisplayReq(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacHideStatusLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacHideStatusLineMultiDisplayReq(aDisplayRegionType = %d, aDisplayID = %d)", aDisplayRegionType,aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::STATUS_LINE, aDisplayRegionType, false, aDisplayID, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayFooterLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacDisplayFooterLineMultiDisplayReq(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacDisplayFooterLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacDisplayFooterLineMultiDisplayReq(aDisplayRegionType = %d, aDisplayID = %d)", aDisplayRegionType,aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::FOOTER_LINE, aDisplayRegionType, true, aDisplayID, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacHideFooterLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacHideFooterLineMultiDisplayReq(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacHideFooterLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacHideFooterLineMultiDisplayReq(aDisplayRegionType = %d, aDisplayID = %d)", aDisplayRegionType,aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::FOOTER_LINE, aDisplayRegionType, false, aDisplayID, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacRegisterForCloseOnTouchSession(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacRegisterForCloseOnTouchSession(::Courier::ViewId(AppHmi_PhoneStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacRegisterForCloseOnTouchSession(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacRegisterForCloseOnTouchSession(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendRegisterForCloseOnTouchSessionReqMsg(true, aViewId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacDeregisterForCloseOnTouchSessionReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacDeregisterForCloseOnTouchSessionReq(::Courier::ViewId(AppHmi_PhoneStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacDeregisterForCloseOnTouchSessionReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacDeregisterForCloseOnTouchSessionReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendRegisterForCloseOnTouchSessionReqMsg(false, aViewId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterPrioEnableReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacPopupFilterPrioEnableReq(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacPopupFilterPrioEnableReq(Courier::UInt32 const & aPrio)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacPopupFilterPrioEnableReq(aPrio = %d)", aPrio));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupFilterPrioEnableReqMsg(aPrio);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterAllEnableReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacPopupFilterAllEnableReq();
    return true;
}
#endif
void Action_gacPopupFilterAllEnableReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacPopupFilterAllEnableReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupFilterAllEnableReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterDisableReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacPopupFilterDisableReq();
    return true;
}
#endif
void Action_gacPopupFilterDisableReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacPopupFilterDisableReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupFilterDisableReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacProfileChange(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_gacProfileChange(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_gacProfileChange(Courier::UInt32 const & aProfile)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacProfileChange(aProfile = %d)", aProfile));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendProfileSwitchMsg(aProfile);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterPrioEnableReqForDisplay(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacPopupFilterPrioEnableReqForDisplay(parameters[(::Json::Value::UInt)0].asUInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacPopupFilterPrioEnableReqForDisplay(Courier::UInt32 const & aPrio, Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacPopupFilterPrioEnableReqForDisplay(aPrio = %d, aDisplayID = %d)", aPrio,aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendMultiDisplayPopupFilterReqMsg(hmibase::ENABLE_PRIO, aPrio, aDisplayID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterAllEnableReqForDisplay(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacPopupFilterAllEnableReqForDisplay(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacPopupFilterAllEnableReqForDisplay(Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacPopupFilterAllEnableReqForDisplay(aDisplayID = %d)", aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendMultiDisplayPopupFilterReqMsg(hmibase::ENABLE_ALL, 0, aDisplayID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterDisableReqForDisplay(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacPopupFilterDisableReqForDisplay(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacPopupFilterDisableReqForDisplay(Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacPopupFilterDisableReqForDisplay(aDisplayID = %d)", aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendMultiDisplayPopupFilterReqMsg(hmibase::DISABLE_ALL, 0, aDisplayID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacStartSceneTransitionAnimation(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 4) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt() && parameters[(::Json::Value::UInt)2].isUInt() && parameters[(::Json::Value::UInt)3].isInt())) { return false; }
    Action_gacStartSceneTransitionAnimation(::Courier::ViewId(AppHmi_PhoneStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt(), ))::Courier::ViewId(AppHmi_PhoneStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)1].asUInt(), ))parameters[(::Json::Value::UInt)2].asUInt(), parameters[(::Json::Value::UInt)3].asInt());
    return true;
}
#endif
void Action_gacStartSceneTransitionAnimation(::Courier::ViewId const & aSourceView, ::Courier::ViewId const & aDestinationView, Courier::UInt32 const & aUserData1, Courier::Int8 const & aUserData2)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacStartSceneTransitionAnimation(aSourceView = %50s, aDestinationView = %50s, aUserData1 = %d, aUserData2 = %d)", aSourceView.CStr(),aDestinationView.CStr(),aUserData1,aUserData2));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendCreateNewDestroyOld(aSourceView, aDestinationView, aUserData1, aUserData2);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacDecrementActiveAnimationCount(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacDecrementActiveAnimationCount();
    return true;
}
#endif
void Action_gacDecrementActiveAnimationCount()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_PHONE_SM, "SM_ACTIONS:    Trigger action gacDecrementActiveAnimationCount()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendNotifierMessage();
    COURIER_UNUSED(ok);
}
//====  defines and includes TTFis output - added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====    

unsigned short AppHmi_PhoneStateMachineImpl::GetTraceClass (){  
   return TR_CLASS_APPHMI_PHONE_SM; 
}

//====  member function with TTFis output - end                        key: SM_TTFis_SBHFMSRF ==== 

#include "hmibase/util/Macros.h"

#ifdef CIT_SIMULATION
#define CIT_EVENT_ID(eventId, hashId) hashId
#else
#define CIT_EVENT_ID(eventId, hashId) eventId
#endif
// ------------------------------------------------------------------------
static bool HandleEventMappingForShutdownMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnShutdownMsg, 0x756C0DF3);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForShutdownMsg(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForSpiSessionMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnSpiSessionMsg, 0xA2BA16D2);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSpiSessionMsg(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForSpeedLockstatusIndMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnSpeedLockstatusIndMsg, 0x98BD981F);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSpeedLockstatusIndMsg(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForClosePairingPopupsOnSpeedLockstatusMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ClosePairingPopupsOnSpeedLockstatus, 0xC5458961);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForClosePairingPopupsOnSpeedLockstatusMsg(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForButtonReactionMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::ButtonReactionMsg const & message = static_cast< ::ButtonReactionMsg const &>(aMessage);

#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_PhoneSelection_Layer_AddPhone_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_PhoneSelection")) && (message.GetSender() == ::Courier::Identifier(0xaaf7e94e /* Layer_AddPhone/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_PhoneSelection_Layer_AddPhone_ButtonWidget_enRelease, 0xAF540B1E); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Contacts_Loading_Layer_HeaderPhone_ButtonWidget2D_Media_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_Contacts_Loading")) && (message.GetSender() == ::Courier::Identifier(0x814d46cb /* Layer_HeaderPhone/ButtonWidget2D_Media */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Contacts_Loading_Layer_HeaderPhone_ButtonWidget2D_Media_enRelease, 0x2FCE97E1); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Contacts_Layer_HeaderPhone_ButtonWidget2D_Media_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_Contacts")) && (message.GetSender() == ::Courier::Identifier(0x814d46cb /* Layer_HeaderPhone/ButtonWidget2D_Media */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Contacts_Layer_HeaderPhone_ButtonWidget2D_Media_enRelease, 0xADDB3CB8); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_DialPad_Layer_HeaderPhone_ButtonWidget2D_Media_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_DialPad")) && (message.GetSender() == ::Courier::Identifier(0x814d46cb /* Layer_HeaderPhone/ButtonWidget2D_Media */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_DialPad_Layer_HeaderPhone_ButtonWidget2D_Media_enRelease, 0xF50D3527); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_CallList_Layer_HeaderPhone_ButtonWidget2D_Media_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_CallList")) && (message.GetSender() == ::Courier::Identifier(0x814d46cb /* Layer_HeaderPhone/ButtonWidget2D_Media */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_CallList_Layer_HeaderPhone_ButtonWidget2D_Media_enRelease, 0xB320790B); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_CallList_Loading_Layer_HeaderPhone_ButtonWidget2D_Media_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_CallList_Loading")) && (message.GetSender() == ::Courier::Identifier(0x814d46cb /* Layer_HeaderPhone/ButtonWidget2D_Media */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_CallList_Loading_Layer_HeaderPhone_ButtonWidget2D_Media_enRelease, 0x87281151); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Contacts_Loading_Layer_HeaderPhone_ButtonWidget2D_SPI_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_Contacts_Loading")) && (message.GetSender() == ::Courier::Identifier(0x1656cd21 /* Layer_HeaderPhone/ButtonWidget2D_SPI */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Contacts_Loading_Layer_HeaderPhone_ButtonWidget2D_SPI_enRelease, 0x027A3929); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Contacts_Layer_HeaderPhone_ButtonWidget2D_SPI_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_Contacts")) && (message.GetSender() == ::Courier::Identifier(0x1656cd21 /* Layer_HeaderPhone/ButtonWidget2D_SPI */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Contacts_Layer_HeaderPhone_ButtonWidget2D_SPI_enRelease, 0x58E330E4); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_DialPad_Layer_HeaderPhone_ButtonWidget2D_SPI_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_DialPad")) && (message.GetSender() == ::Courier::Identifier(0x1656cd21 /* Layer_HeaderPhone/ButtonWidget2D_SPI */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_DialPad_Layer_HeaderPhone_ButtonWidget2D_SPI_enRelease, 0xB653159C); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_CallList_Layer_HeaderPhone_ButtonWidget2D_SPI_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_CallList")) && (message.GetSender() == ::Courier::Identifier(0x1656cd21 /* Layer_HeaderPhone/ButtonWidget2D_SPI */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_CallList_Layer_HeaderPhone_ButtonWidget2D_SPI_enRelease, 0x1FC84BE0); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_CallList_Loading_Layer_HeaderPhone_ButtonWidget2D_SPI_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_CallList_Loading")) && (message.GetSender() == ::Courier::Identifier(0x1656cd21 /* Layer_HeaderPhone/ButtonWidget2D_SPI */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_CallList_Loading_Layer_HeaderPhone_ButtonWidget2D_SPI_enRelease, 0x557167BF); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_PhonebookDLIncomplete_Layer_OK_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#Sys_Popup#Pfo_PhonebookDLIncomplete")) && (message.GetSender() == ::Courier::Identifier(0x0f5c304a /* Layer_OK/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_PhonebookDLIncomplete_Layer_OK_ButtonWidget_enRelease, 0x6BC6C7C8); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_App_Popup_Pfo_WaitForConfirmation_Layer_Cancel_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#App_Popup#Pfo_WaitForConfirmation")) && (message.GetSender() == ::Courier::Identifier(0xa0c01df4 /* Layer_Cancel/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_App_Popup_Pfo_WaitForConfirmation_Layer_Cancel_ButtonWidget_enRelease, 0xE78CB8A4); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_App_Popup_Pfo_PairingInitiate_Layer_Cancel_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#App_Popup#Pfo_PairingInitiate")) && (message.GetSender() == ::Courier::Identifier(0xa0c01df4 /* Layer_Cancel/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_App_Popup_Pfo_PairingInitiate_Layer_Cancel_ButtonWidget_enRelease, 0xAFE3F29D); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_App_Popup_Pfo_NumCompPairing_Layer_Yes_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#App_Popup#Pfo_NumCompPairing")) && (message.GetSender() == ::Courier::Identifier(0xeaebbe6c /* Layer_Yes/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_App_Popup_Pfo_NumCompPairing_Layer_Yes_ButtonWidget_enRelease, 0x60AD01EA); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_App_Popup_Pfo_NumCompPairing_Layer_No_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#App_Popup#Pfo_NumCompPairing")) && (message.GetSender() == ::Courier::Identifier(0xb5018479 /* Layer_No/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_App_Popup_Pfo_NumCompPairing_Layer_No_ButtonWidget_enRelease, 0xA33E059B); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_App_Popup_Pfo_JustWorksPairing_Layer_Yes_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#App_Popup#Pfo_JustWorksPairing")) && (message.GetSender() == ::Courier::Identifier(0xeaebbe6c /* Layer_Yes/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_App_Popup_Pfo_JustWorksPairing_Layer_Yes_ButtonWidget_enRelease, 0x5E14F00D); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_App_Popup_Pfo_JustWorksPairing_Layer_No_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#App_Popup#Pfo_JustWorksPairing")) && (message.GetSender() == ::Courier::Identifier(0xb5018479 /* Layer_No/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_App_Popup_Pfo_JustWorksPairing_Layer_No_ButtonWidget_enRelease, 0x6126C9E5); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_App_Popup_Pfo_DeviceListFull_Layer_OK_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#App_Popup#Pfo_DeviceListFull")) && (message.GetSender() == ::Courier::Identifier(0x0f5c304a /* Layer_OK/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_App_Popup_Pfo_DeviceListFull_Layer_OK_ButtonWidget_enRelease, 0x957D1215); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_App_Popup_Pfo_DeviceDisconnectConfirmation_Layer_Yes_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#App_Popup#Pfo_DeviceDisconnectConfirmation")) && (message.GetSender() == ::Courier::Identifier(0xeaebbe6c /* Layer_Yes/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_App_Popup_Pfo_DeviceDisconnectConfirmation_Layer_Yes_ButtonWidget_enRelease, 0xFB766D09); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_App_Popup_Pfo_DeviceDisconnectConfirmation_Layer_No_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#App_Popup#Pfo_DeviceDisconnectConfirmation")) && (message.GetSender() == ::Courier::Identifier(0xb5018479 /* Layer_No/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_App_Popup_Pfo_DeviceDisconnectConfirmation_Layer_No_ButtonWidget_enRelease, 0x40B09F90); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_App_Popup_Pfo_DeleteDeviceConfirmation_Layer_Yes_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#App_Popup#Pfo_DeleteDeviceConfirmation")) && (message.GetSender() == ::Courier::Identifier(0xeaebbe6c /* Layer_Yes/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_App_Popup_Pfo_DeleteDeviceConfirmation_Layer_Yes_ButtonWidget_enRelease, 0x252BB334); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_App_Popup_Pfo_DeleteDeviceConfirmation_Layer_No_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#App_Popup#Pfo_DeleteDeviceConfirmation")) && (message.GetSender() == ::Courier::Identifier(0xb5018479 /* Layer_No/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_App_Popup_Pfo_DeleteDeviceConfirmation_Layer_No_ButtonWidget_enRelease, 0x59FA971D); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_SMSExpand_Layer_Readaloud_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#Sys_Popup#Pfo_SMSExpand")) && (message.GetSender() == ::Courier::Identifier(0x2d8aa2d9 /* Layer_Readaloud/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_SMSExpand_Layer_Readaloud_ButtonWidget_enRelease, 0x063AB855); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_SMSExpand_Layer_TouchArea_Close_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#Sys_Popup#Pfo_SMSExpand")) && (message.GetSender() == ::Courier::Identifier(0x16e5a73b /* Layer_TouchArea_Close/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_SMSExpand_Layer_TouchArea_Close_ButtonWidget_enRelease, 0x6291A012); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_SMSExpand_Layer_TouchArea_Call_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#Sys_Popup#Pfo_SMSExpand")) && (message.GetSender() == ::Courier::Identifier(0x0e94ec52 /* Layer_TouchArea_Call/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_SMSExpand_Layer_TouchArea_Call_ButtonWidget_enRelease, 0x1F37A1A2); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_CallList_Loading_Layer_HeaderPhone_ButtonWidget2D_Radio_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_CallList_Loading")) && (message.GetSender() == ::Courier::Identifier(0xf22f7eb2 /* Layer_HeaderPhone/ButtonWidget2D_Radio */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_CallList_Loading_Layer_HeaderPhone_ButtonWidget2D_Radio_enRelease, 0x90936AF2); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_CallList_Layer_HeaderPhone_ButtonWidget2D_Radio_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_CallList")) && (message.GetSender() == ::Courier::Identifier(0xf22f7eb2 /* Layer_HeaderPhone/ButtonWidget2D_Radio */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_CallList_Layer_HeaderPhone_ButtonWidget2D_Radio_enRelease, 0xFC84D96A); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_DialPad_Layer_HeaderPhone_ButtonWidget2D_Radio_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_DialPad")) && (message.GetSender() == ::Courier::Identifier(0xf22f7eb2 /* Layer_HeaderPhone/ButtonWidget2D_Radio */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_DialPad_Layer_HeaderPhone_ButtonWidget2D_Radio_enRelease, 0x95866363); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Contacts_Layer_HeaderPhone_ButtonWidget2D_Radio_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_Contacts")) && (message.GetSender() == ::Courier::Identifier(0xf22f7eb2 /* Layer_HeaderPhone/ButtonWidget2D_Radio */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Contacts_Layer_HeaderPhone_ButtonWidget2D_Radio_enRelease, 0xC44B109F); return true; }
#endif
#ifdef TogglePhoneHandle_Smart
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#Gadget_Phone#MASTER__GADGET_PHONE_Smart")) && (message.GetSender() == ::Courier::Identifier(0x28d0580c /* TouchArea_Icon_Phone/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(TogglePhoneHandle_Smart, 0xDADA27EC); return true; }
#endif
#ifdef ReqPhoneContentContextSwitch_NonNavi
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#Gadget_Phone#MASTER__GADGET_PHONE_NON_NAVI")) && (message.GetSender() == ::Courier::Identifier(0x4c1715cb /* TouchArea_PhoneContent/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ReqPhoneContentContextSwitch_NonNavi, 0xA5A028CE); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_Gadget_Phone_MASTER__GADGET_PHONE_NON_NAVI_TouchArea_PhoneBtn_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#Gadget_Phone#MASTER__GADGET_PHONE_NON_NAVI")) && (message.GetSender() == ::Courier::Identifier(0x5f5622dd /* TouchArea_PhoneBtn/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_Gadget_Phone_MASTER__GADGET_PHONE_NON_NAVI_TouchArea_PhoneBtn_ButtonWidget_enRelease, 0x06F7F237); return true; }
#endif
#ifdef TogglePhoneHandle_NonNavi
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#Gadget_Phone#MASTER__GADGET_PHONE_NON_NAVI")) && (message.GetSender() == ::Courier::Identifier(0x28d0580c /* TouchArea_Icon_Phone/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(TogglePhoneHandle_NonNavi, 0x3ADED12D); return true; }
#endif
#ifdef ReqPhoneContentContextSwitch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#Gadget_Phone#MASTER__GADGET_PHONE")) && (message.GetSender() == ::Courier::Identifier(0x4c1715cb /* TouchArea_PhoneContent/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ReqPhoneContentContextSwitch, 0x5E204A52); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_Gadget_Phone_MASTER__GADGET_PHONE_TouchArea_PhoneBtn_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#Gadget_Phone#MASTER__GADGET_PHONE")) && (message.GetSender() == ::Courier::Identifier(0x5f5622dd /* TouchArea_PhoneBtn/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_Gadget_Phone_MASTER__GADGET_PHONE_TouchArea_PhoneBtn_ButtonWidget_enRelease, 0x4BE2B8D7); return true; }
#endif
#ifdef TogglePhoneHandle
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#Gadget_Phone#MASTER__GADGET_PHONE")) && (message.GetSender() == ::Courier::Identifier(0x28d0580c /* TouchArea_Icon_Phone/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(TogglePhoneHandle, 0xEA9EA5D8); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_PriorityCall_BT_Layer_Yes_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#Sys_Popup#Pfo_PriorityCall_BT")) && (message.GetSender() == ::Courier::Identifier(0xeaebbe6c /* Layer_Yes/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_PriorityCall_BT_Layer_Yes_ButtonWidget_enRelease, 0xFAE44A15); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_PriorityCall_Intercom_Layer_Yes_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#Sys_Popup#Pfo_PriorityCall_Intercom")) && (message.GetSender() == ::Courier::Identifier(0xeaebbe6c /* Layer_Yes/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_PriorityCall_Intercom_Layer_Yes_ButtonWidget_enRelease, 0x3F9C1B2B); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_SR_SIRI_Main_Layer_SRSRBTSpeechRecExit_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_SR_SIRI_Main")) && (message.GetSender() == ::Courier::Identifier(0x4b5e670b /* Layer_SRSRBTSpeechRecExit/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_SR_SIRI_Main_Layer_SRSRBTSpeechRecExit_ButtonWidget_enRelease, 0xA5772E78); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_SR_SIRI_Main_Layer_SRSRBTSpeechRecStop_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_SR_SIRI_Main")) && (message.GetSender() == ::Courier::Identifier(0x0ffb7192 /* Layer_SRSRBTSpeechRecStop/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_SR_SIRI_Main_Layer_SRSRBTSpeechRecStop_ButtonWidget_enRelease, 0xE1979225); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_SR_SIRI_Main_Layer_SRSRBTSpeechRecStart_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_SR_SIRI_Main")) && (message.GetSender() == ::Courier::Identifier(0x1e9296ef /* Layer_SRSRBTSpeechRecStart/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_SR_SIRI_Main_Layer_SRSRBTSpeechRecStart_ButtonWidget_enRelease, 0x3B45E4A9); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_SMS_Layer_Read_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#Sys_Popup#Pfo_SMS")) && (message.GetSender() == ::Courier::Identifier(0x65313539 /* Layer_Read/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_SMS_Layer_Read_ButtonWidget_enRelease, 0x881BFD51); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_Sys_Popup_SR_SIRI_Main_Layer_SRSRBTSpeechRecExit_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#Sys_Popup#SR_SIRI_Main")) && (message.GetSender() == ::Courier::Identifier(0x4b5e670b /* Layer_SRSRBTSpeechRecExit/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_Sys_Popup_SR_SIRI_Main_Layer_SRSRBTSpeechRecExit_ButtonWidget_enRelease, 0xDF7B04C9); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_Sys_Popup_SR_SIRI_Main_Layer_SRSRBTSpeechRecStart_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#Sys_Popup#SR_SIRI_Main")) && (message.GetSender() == ::Courier::Identifier(0x1e9296ef /* Layer_SRSRBTSpeechRecStart/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_Sys_Popup_SR_SIRI_Main_Layer_SRSRBTSpeechRecStart_ButtonWidget_enRelease, 0xCF94F7EF); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Contacts_Loading_Layer_HeaderPhone_ButtonWidget2D_Navi_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_Contacts_Loading")) && (message.GetSender() == ::Courier::Identifier(0x3818fb2c /* Layer_HeaderPhone/ButtonWidget2D_Navi */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Contacts_Loading_Layer_HeaderPhone_ButtonWidget2D_Navi_enRelease, 0x46684A77); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_DialPad_MatchList_Layer_HeaderPhone_ButtonWidget2D_Navi_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_DialPad_MatchList")) && (message.GetSender() == ::Courier::Identifier(0x3818fb2c /* Layer_HeaderPhone/ButtonWidget2D_Navi */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_DialPad_MatchList_Layer_HeaderPhone_ButtonWidget2D_Navi_enRelease, 0xDA7D1113); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_DialPad_Layer_HeaderPhone_ButtonWidget2D_Navi_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_DialPad")) && (message.GetSender() == ::Courier::Identifier(0x3818fb2c /* Layer_HeaderPhone/ButtonWidget2D_Navi */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_DialPad_Layer_HeaderPhone_ButtonWidget2D_Navi_enRelease, 0xD683DF01); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_CallList_Layer_HeaderPhone_ButtonWidget2D_Navi_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_CallList")) && (message.GetSender() == ::Courier::Identifier(0x3818fb2c /* Layer_HeaderPhone/ButtonWidget2D_Navi */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_CallList_Layer_HeaderPhone_ButtonWidget2D_Navi_enRelease, 0xD69CD058); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_CallList_Loading_Layer_HeaderPhone_ButtonWidget2D_Navi_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_CallList_Loading")) && (message.GetSender() == ::Courier::Identifier(0x3818fb2c /* Layer_HeaderPhone/ButtonWidget2D_Navi */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_CallList_Loading_Layer_HeaderPhone_ButtonWidget2D_Navi_enRelease, 0xCE5219D5); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Contacts_Loading_Layer_HeaderPhone_ButtonWidget2D_Listen_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_Contacts_Loading")) && (message.GetSender() == ::Courier::Identifier(0x8f9a3665 /* Layer_HeaderPhone/ButtonWidget2D_Listen */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Contacts_Loading_Layer_HeaderPhone_ButtonWidget2D_Listen_enRelease, 0x9B76BC60); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Contacts_Layer_HeaderPhone_ButtonWidget2D_Listen_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_Contacts")) && (message.GetSender() == ::Courier::Identifier(0x8f9a3665 /* Layer_HeaderPhone/ButtonWidget2D_Listen */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Contacts_Layer_HeaderPhone_ButtonWidget2D_Listen_enRelease, 0x129F3D6F); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_DialPad_Layer_HeaderPhone_ButtonWidget2D_Listen_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_DialPad")) && (message.GetSender() == ::Courier::Identifier(0x8f9a3665 /* Layer_HeaderPhone/ButtonWidget2D_Listen */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_DialPad_Layer_HeaderPhone_ButtonWidget2D_Listen_enRelease, 0xA851CE0D); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_CallList_Layer_HeaderPhone_ButtonWidget2D_Listen_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_CallList")) && (message.GetSender() == ::Courier::Identifier(0x8f9a3665 /* Layer_HeaderPhone/ButtonWidget2D_Listen */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_CallList_Layer_HeaderPhone_ButtonWidget2D_Listen_enRelease, 0xA755043C); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_CallList_Loading_Layer_HeaderPhone_ButtonWidget2D_Listen_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_CallList_Loading")) && (message.GetSender() == ::Courier::Identifier(0x8f9a3665 /* Layer_HeaderPhone/ButtonWidget2D_Listen */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_CallList_Loading_Layer_HeaderPhone_ButtonWidget2D_Listen_enRelease, 0xD7150BC1); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Contacts_Loading_Layer_HeaderPhone_ButtonWidget2D_Radio_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_Contacts_Loading")) && (message.GetSender() == ::Courier::Identifier(0xf22f7eb2 /* Layer_HeaderPhone/ButtonWidget2D_Radio */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Contacts_Loading_Layer_HeaderPhone_ButtonWidget2D_Radio_enRelease, 0x4043813E); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_Sys_Popup_SR_SIRI_Main_Layer_SRSRBTSpeechRecStop_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#Sys_Popup#SR_SIRI_Main")) && (message.GetSender() == ::Courier::Identifier(0x0ffb7192 /* Layer_SRSRBTSpeechRecStop/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_Sys_Popup_SR_SIRI_Main_Layer_SRSRBTSpeechRecStop_ButtonWidget_enRelease, 0xE05BFB75); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_Gadget_Phone_MASTER__GADGET_PHONE_Smart_TouchArea_PhoneBtn_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#Gadget_Phone#MASTER__GADGET_PHONE_Smart")) && (message.GetSender() == ::Courier::Identifier(0x5f5622dd /* TouchArea_PhoneBtn/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_Gadget_Phone_MASTER__GADGET_PHONE_Smart_TouchArea_PhoneBtn_ButtonWidget_enRelease, 0x1992CF4B); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_SMS_Layer_Readaloud_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#Sys_Popup#Pfo_SMS")) && (message.GetSender() == ::Courier::Identifier(0x2d8aa2d9 /* Layer_Readaloud/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_SMS_Layer_Readaloud_ButtonWidget_enRelease, 0xE4F33869); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_SMS_Layer_TouchArea_Call_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#Sys_Popup#Pfo_SMS")) && (message.GetSender() == ::Courier::Identifier(0x0e94ec52 /* Layer_TouchArea_Call/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_SMS_Layer_TouchArea_Call_ButtonWidget_enRelease, 0x5CE63CA9); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_OPT_SETTINGS_Button_Back_icon_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_OPT_SETTINGS")) && (message.GetSender() == ::Courier::Identifier(0xa1899648 /* Button_Back_icon/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_OPT_SETTINGS_Button_Back_icon_ButtonWidget_enRelease, 0xD8AF90ED); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Contacts_opt_se_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_Contacts")) && (message.GetSender() == ::Courier::Identifier(0xd3786289 /* opt_se/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Contacts_opt_se_ButtonWidget_enRelease, 0xB2B3C41C); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Contacts_Layer_TabDialpad_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_Contacts")) && (message.GetSender() == ::Courier::Identifier(0x4b705d00 /* Layer_TabDialpad/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Contacts_Layer_TabDialpad_ButtonWidget_enRelease, 0x943FE71D); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Contacts_Layer_TabCalls_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_Contacts")) && (message.GetSender() == ::Courier::Identifier(0x1a4e8c67 /* Layer_TabCalls/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Contacts_Layer_TabCalls_ButtonWidget_enRelease, 0x490D9B02); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Contacts_Layer_HeaderPhone_ButtonWidget2D_PhoneName_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_Contacts")) && (message.GetSender() == ::Courier::Identifier(0x0d986328 /* Layer_HeaderPhone/ButtonWidget2D_PhoneName */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Contacts_Layer_HeaderPhone_ButtonWidget2D_PhoneName_enRelease, 0x73812164); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Contacts_Layer_TouchArea_Phone_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_Contacts")) && (message.GetSender() == ::Courier::Identifier(0x2a89b8ac /* Layer_TouchArea_Phone/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Contacts_Layer_TouchArea_Phone_ButtonWidget_enRelease, 0x54F1B1AA); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_CallList_Loading_Layer_TabDialpad_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_CallList_Loading")) && (message.GetSender() == ::Courier::Identifier(0x4b705d00 /* Layer_TabDialpad/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_CallList_Loading_Layer_TabDialpad_ButtonWidget_enRelease, 0x21EA9E63); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_CallList_Loading_Layer_TabContacts_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_CallList_Loading")) && (message.GetSender() == ::Courier::Identifier(0x78a16603 /* Layer_TabContacts/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_CallList_Loading_Layer_TabContacts_ButtonWidget_enRelease, 0xE2D4F4E5); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_CallList_Loading_Layer_TouchArea_Phone_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_CallList_Loading")) && (message.GetSender() == ::Courier::Identifier(0x2a89b8ac /* Layer_TouchArea_Phone/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_CallList_Loading_Layer_TouchArea_Phone_ButtonWidget_enRelease, 0xDEFA926B); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_CallList_Layer_TabDialpad_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_CallList")) && (message.GetSender() == ::Courier::Identifier(0x4b705d00 /* Layer_TabDialpad/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_CallList_Layer_TabDialpad_ButtonWidget_enRelease, 0x0FEC8911); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_CallList_Layer_TabContacts_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_CallList")) && (message.GetSender() == ::Courier::Identifier(0x78a16603 /* Layer_TabContacts/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_CallList_Layer_TabContacts_ButtonWidget_enRelease, 0xD8354CB8); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_CallList_Layer_HeaderPhone_ButtonWidget2D_PhoneName_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_CallList")) && (message.GetSender() == ::Courier::Identifier(0x0d986328 /* Layer_HeaderPhone/ButtonWidget2D_PhoneName */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_CallList_Layer_HeaderPhone_ButtonWidget2D_PhoneName_enRelease, 0xF9A0E92C); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_CallList_Layer_TouchArea_Phone_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_CallList")) && (message.GetSender() == ::Courier::Identifier(0x2a89b8ac /* Layer_TouchArea_Phone/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_CallList_Layer_TouchArea_Phone_ButtonWidget_enRelease, 0xE01277A1); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Call_Layer_Icon_PhoneMute_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_Call")) && (message.GetSender() == ::Courier::Identifier(0x50a734ad /* Layer_Icon_PhoneMute/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Call_Layer_Icon_PhoneMute_ButtonWidget2D_enRelease, 0xE30A79B0); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Call_Layer_Icon_Handset_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_Call")) && (message.GetSender() == ::Courier::Identifier(0xd40264d1 /* Layer_Icon_Handset/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Call_Layer_Icon_Handset_ButtonWidget2D_enRelease, 0x2EA8666C); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Call_Layer_TouchArea_DialPad_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_Call")) && (message.GetSender() == ::Courier::Identifier(0x1d66e029 /* Layer_TouchArea_DialPad/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Call_Layer_TouchArea_DialPad_ButtonWidget_enRelease, 0xEE183E4B); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Intercom_ConferenceCall_Layer_TouchArea_Call_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_Intercom_ConferenceCall")) && (message.GetSender() == ::Courier::Identifier(0x0e94ec52 /* Layer_TouchArea_Call/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Intercom_ConferenceCall_Layer_TouchArea_Call_ButtonWidget_enRelease, 0x414A14B7); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Intercom_ConferenceCall_Layer_TouchArea_HangUp_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_Intercom_ConferenceCall")) && (message.GetSender() == ::Courier::Identifier(0x6e028f9c /* Layer_TouchArea_HangUp/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Intercom_ConferenceCall_Layer_TouchArea_HangUp_ButtonWidget_enRelease, 0xBE7D1CB2); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_IntercomCall_Layer_TouchArea_Call_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_IntercomCall")) && (message.GetSender() == ::Courier::Identifier(0x0e94ec52 /* Layer_TouchArea_Call/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_IntercomCall_Layer_TouchArea_Call_ButtonWidget_enRelease, 0x72027194); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_IntercomCall_Layer_TouchArea_HangUp_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_IntercomCall")) && (message.GetSender() == ::Courier::Identifier(0x6e028f9c /* Layer_TouchArea_HangUp/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_IntercomCall_Layer_TouchArea_HangUp_ButtonWidget_enRelease, 0x43DED828); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Call_Layer_TouchArea_HangUp_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_Call")) && (message.GetSender() == ::Courier::Identifier(0x6e028f9c /* Layer_TouchArea_HangUp/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Call_Layer_TouchArea_HangUp_ButtonWidget_enRelease, 0xA2344E29); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Call_DialPad_Layer_TouchArea_HangUp_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_Call_DialPad")) && (message.GetSender() == ::Courier::Identifier(0x6e028f9c /* Layer_TouchArea_HangUp/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Call_DialPad_Layer_TouchArea_HangUp_ButtonWidget_enRelease, 0x43E5379D); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Call_DialPad_Layer_SpellerExpander_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_Call_DialPad")) && (message.GetSender() == ::Courier::Identifier(0xfb6d39e0 /* Layer_SpellerExpander/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Call_DialPad_Layer_SpellerExpander_ButtonWidget_enRelease, 0xF7B04001); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_I_Contacts_Layer_TouchArea_Phone_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#I_Contacts")) && (message.GetSender() == ::Courier::Identifier(0x2a89b8ac /* Layer_TouchArea_Phone/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_I_Contacts_Layer_TouchArea_Phone_ButtonWidget_enRelease, 0xEFB97EA7); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_PhoneSelection_Layer_TouchArea_Phone_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_PhoneSelection")) && (message.GetSender() == ::Courier::Identifier(0x2a89b8ac /* Layer_TouchArea_Phone/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_PhoneSelection_Layer_TouchArea_Phone_ButtonWidget_enRelease, 0x21EA5442); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_OPT_SETTINGS_Layer_UsePhoneRingtone_1_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_OPT_SETTINGS")) && (message.GetSender() == ::Courier::Identifier(0x4fa68250 /* Layer_UsePhoneRingtone_1/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_OPT_SETTINGS_Layer_UsePhoneRingtone_1_ButtonWidget2D_enRelease, 0x9FD51F5C); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_OPT_SETTINGS_Layer_ShowSMS_1_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_OPT_SETTINGS")) && (message.GetSender() == ::Courier::Identifier(0x974b51aa /* Layer_ShowSMS_1/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_OPT_SETTINGS_Layer_ShowSMS_1_ButtonWidget2D_enRelease, 0xE927938F); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_PhoneSelection_OPT_SET_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_PhoneSelection")) && (message.GetSender() == ::Courier::Identifier(0x92c923e2 /* OPT_SET/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_PhoneSelection_OPT_SET_ButtonWidget_enRelease, 0x71D394B6); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Contacts_Loading_Layer_HeaderPhone_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_Contacts_Loading")) && (message.GetSender() == ::Courier::Identifier(0x536e9f8a /* Layer_HeaderPhone/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Contacts_Loading_Layer_HeaderPhone_ButtonWidget_enRelease, 0x992F07B2); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_PassiveDeviceIncomingCall_Layer_TouchArea_HangUp_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#Sys_Popup#Pfo_PassiveDeviceIncomingCall")) && (message.GetSender() == ::Courier::Identifier(0x6e028f9c /* Layer_TouchArea_HangUp/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_PassiveDeviceIncomingCall_Layer_TouchArea_HangUp_ButtonWidget_enRelease, 0xF49B6A2E); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_PassiveDeviceIncomingCall_Layer_TouchArea_Call_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#Sys_Popup#Pfo_PassiveDeviceIncomingCall")) && (message.GetSender() == ::Courier::Identifier(0x0e94ec52 /* Layer_TouchArea_Call/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_PassiveDeviceIncomingCall_Layer_TouchArea_Call_ButtonWidget_enRelease, 0x70C03DA6); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_Intercom_IncomingCall_Layer_TouchArea_HangUp_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#Sys_Popup#Pfo_Intercom_IncomingCall")) && (message.GetSender() == ::Courier::Identifier(0x6e028f9c /* Layer_TouchArea_HangUp/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_Intercom_IncomingCall_Layer_TouchArea_HangUp_ButtonWidget_enRelease, 0x1898D4DF); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_Intercom_IncomingCall_Layer_TouchArea_Call_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#Sys_Popup#Pfo_Intercom_IncomingCall")) && (message.GetSender() == ::Courier::Identifier(0x0e94ec52 /* Layer_TouchArea_Call/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_Intercom_IncomingCall_Layer_TouchArea_Call_ButtonWidget_enRelease, 0xC36EB8DF); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_IncomingCall_Layer_TouchArea_HangUp_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#Sys_Popup#Pfo_IncomingCall")) && (message.GetSender() == ::Courier::Identifier(0x6e028f9c /* Layer_TouchArea_HangUp/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_IncomingCall_Layer_TouchArea_HangUp_ButtonWidget_enRelease, 0x7C8C0F37); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_IncomingCall_Layer_TouchArea_Call_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#Sys_Popup#Pfo_IncomingCall")) && (message.GetSender() == ::Courier::Identifier(0x0e94ec52 /* Layer_TouchArea_Call/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_IncomingCall_Layer_TouchArea_Call_ButtonWidget_enRelease, 0x5D685E55); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_MultipleCall_Layer_TouchArea_Switch_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_MultipleCall")) && (message.GetSender() == ::Courier::Identifier(0x573018c7 /* Layer_TouchArea_Switch/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_MultipleCall_Layer_TouchArea_Switch_ButtonWidget_enRelease, 0xE47C4454); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_MultipleCall_Layer_TouchArea_HangUp_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_MultipleCall")) && (message.GetSender() == ::Courier::Identifier(0x6e028f9c /* Layer_TouchArea_HangUp/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_MultipleCall_Layer_TouchArea_HangUp_ButtonWidget_enRelease, 0x2DAEA0B7); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_MultipleCall_Layer_TouchArea_DialPad_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_MultipleCall")) && (message.GetSender() == ::Courier::Identifier(0x1d66e029 /* Layer_TouchArea_DialPad/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_MultipleCall_Layer_TouchArea_DialPad_ButtonWidget_enRelease, 0xDC0D3D16); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_MultipleCall_Layer_Handset_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_MultipleCall")) && (message.GetSender() == ::Courier::Identifier(0xd7f23025 /* Layer_Handset/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_MultipleCall_Layer_Handset_ButtonWidget2D_enRelease, 0xFAADD06D); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_MultipleCall_Layer_Mute_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_MultipleCall")) && (message.GetSender() == ::Courier::Identifier(0xb728abce /* Layer_Mute/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_MultipleCall_Layer_Mute_ButtonWidget2D_enRelease, 0xF01F1FA6); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_OPT_Layer_Checkbox_ShowSMS_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_OPT")) && (message.GetSender() == ::Courier::Identifier(0x7a7b8fca /* Layer_Checkbox_ShowSMS/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_OPT_Layer_Checkbox_ShowSMS_ButtonWidget2D_enRelease, 0xB0EA418D); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_SMS_Layer_TouchArea_Close_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#Sys_Popup#Pfo_SMS")) && (message.GetSender() == ::Courier::Identifier(0x16e5a73b /* Layer_TouchArea_Close/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_SMS_Layer_TouchArea_Close_ButtonWidget_enRelease, 0x403C310A); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_OPT_Layer_Checkbox_UsePhoneRingtone_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_OPT")) && (message.GetSender() == ::Courier::Identifier(0x00d771e3 /* Layer_Checkbox_UsePhoneRingtone/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_OPT_Layer_Checkbox_UsePhoneRingtone_ButtonWidget2D_enRelease, 0x1106503B); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_MultipleCall_DialPad_Layer_SpellerExpander_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_MultipleCall_DialPad")) && (message.GetSender() == ::Courier::Identifier(0xfb6d39e0 /* Layer_SpellerExpander/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_MultipleCall_DialPad_Layer_SpellerExpander_ButtonWidget_enRelease, 0x18C67501); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_DialPad_Layer_TouchArea_Phone_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_DialPad")) && (message.GetSender() == ::Courier::Identifier(0x2a89b8ac /* Layer_TouchArea_Phone/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_DialPad_Layer_TouchArea_Phone_ButtonWidget_enRelease, 0x021D41B4); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_DialPad_Layer_TabCalls_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_DialPad")) && (message.GetSender() == ::Courier::Identifier(0x1a4e8c67 /* Layer_TabCalls/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_DialPad_Layer_TabCalls_ButtonWidget_enRelease, 0x807245E1); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_DialPad_Layer_TabContacts_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_DialPad")) && (message.GetSender() == ::Courier::Identifier(0x78a16603 /* Layer_TabContacts/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_DialPad_Layer_TabContacts_ButtonWidget_enRelease, 0xB81D78C8); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_DialPad_Layer_SpellerExpander_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_DialPad")) && (message.GetSender() == ::Courier::Identifier(0xfb6d39e0 /* Layer_SpellerExpander/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_DialPad_Layer_SpellerExpander_ButtonWidget_enRelease, 0xF55F1AAC); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_DialPad_Layer_Call_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_DialPad")) && (message.GetSender() == ::Courier::Identifier(0x31754bad /* Layer_Call/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_DialPad_Layer_Call_ButtonWidget_enRelease, 0x541100D0); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_I_Call_Connecting_Layer_TouchArea_HangUp_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#I_Call_Connecting")) && (message.GetSender() == ::Courier::Identifier(0x6e028f9c /* Layer_TouchArea_HangUp/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_I_Call_Connecting_Layer_TouchArea_HangUp_ButtonWidget_enRelease, 0x617C683D); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Call_Connecting_Layer_TouchArea_HangUp_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_Call_Connecting")) && (message.GetSender() == ::Courier::Identifier(0x6e028f9c /* Layer_TouchArea_HangUp/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Call_Connecting_Layer_TouchArea_HangUp_ButtonWidget_enRelease, 0x303718F1); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Contacts_Call_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_Contacts_Call")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Contacts_Call_Layer_TouchArea_Back_ButtonWidget_enRelease, 0x0A5CF04C); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Contacts_Loading_Layer_TabDialpad_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_Contacts_Loading")) && (message.GetSender() == ::Courier::Identifier(0x4b705d00 /* Layer_TabDialpad/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Contacts_Loading_Layer_TabDialpad_ButtonWidget_enRelease, 0xFFFBD8E5); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Contacts_Loading_Layer_TabCalls_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_Contacts_Loading")) && (message.GetSender() == ::Courier::Identifier(0x1a4e8c67 /* Layer_TabCalls/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Contacts_Loading_Layer_TabCalls_ButtonWidget_enRelease, 0x6B23A352); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Contacts_Loading_Layer_TouchArea_Phone_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_Contacts_Loading")) && (message.GetSender() == ::Courier::Identifier(0x2a89b8ac /* Layer_TouchArea_Phone/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Contacts_Loading_Layer_TouchArea_Phone_ButtonWidget_enRelease, 0x5A18CEB8); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_MultipleCall_DialPad_Layer_TouchArea_HangUp_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_MultipleCall_DialPad")) && (message.GetSender() == ::Courier::Identifier(0x6e028f9c /* Layer_TouchArea_HangUp/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_MultipleCall_DialPad_Layer_TouchArea_HangUp_ButtonWidget_enRelease, 0x5106AC87); return true; }
#endif
#ifdef ReqPhoneContentContextSwitch_Smart
    if ((message.GetView() == ::Courier::ViewId("AppHmi_PhoneModule#Gadget_Phone#MASTER__GADGET_PHONE_Smart")) && (message.GetSender() == ::Courier::Identifier(0x4c1715cb /* TouchArea_PhoneContent/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ReqPhoneContentContextSwitch_Smart, 0xF3765187); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForButtonReactionMsg(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::ButtonReactionMsg const & message = static_cast< ::ButtonReactionMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForAddNewDeviceResp(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::AddNewDeviceResp const & message = static_cast< ::AddNewDeviceResp const &>(aMessage);

#ifdef OnAddNewDeviceResp_BTPHN_EN_PAIRING_TYPE_SSP_NUMERIC_COMPARISON
    if ((message.GetPairingType() == BTPHN_EN_PAIRING_TYPE_SSP_NUMERIC_COMPARISON)) { eventId = CIT_EVENT_ID(OnAddNewDeviceResp_BTPHN_EN_PAIRING_TYPE_SSP_NUMERIC_COMPARISON, 0x4FBC1718); return true; }
#endif
#ifdef OnAddNewDeviceResp_BTPHN_EN_PAIRING_TYPE_LEGACY
    if ((message.GetPairingType() == BTPHN_EN_PAIRING_TYPE_LEGACY)) { eventId = CIT_EVENT_ID(OnAddNewDeviceResp_BTPHN_EN_PAIRING_TYPE_LEGACY, 0x405583C6); return true; }
#endif
#ifdef OnAddNewDeviceResp_BTPHN_EN_PAIRING_TYPE_SSP_JUST_WORKS
    if ((message.GetPairingType() == BTPHN_EN_PAIRING_TYPE_SSP_JUST_WORKS)) { eventId = CIT_EVENT_ID(OnAddNewDeviceResp_BTPHN_EN_PAIRING_TYPE_SSP_JUST_WORKS, 0xC20764E5); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForAddNewDeviceResp(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::AddNewDeviceResp const & message = static_cast< ::AddNewDeviceResp const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForPairingStatusResp(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::PairingStatusResp const & message = static_cast< ::PairingStatusResp const &>(aMessage);

#ifdef OnPairingStatusResp_BTPHN_EN_PAIRING_STATUS_TIMEOUT
    if ((message.GetPairingStatus() == BTPHN_EN_PAIRING_STATUS_TIMEOUT)) { eventId = CIT_EVENT_ID(OnPairingStatusResp_BTPHN_EN_PAIRING_STATUS_TIMEOUT, 0x12DBED30); return true; }
#endif
#ifdef OnPairingStatusResp_BTPHN_EN_PAIRING_STATUS_UNSUCCESSFUL
    if ((message.GetPairingStatus() == BTPHN_EN_PAIRING_STATUS_UNSUCCESSFUL)) { eventId = CIT_EVENT_ID(OnPairingStatusResp_BTPHN_EN_PAIRING_STATUS_UNSUCCESSFUL, 0x4638EED6); return true; }
#endif
#ifdef OnPairingStatusResp_BTPHN_EN_PAIRING_STATUS_CONNECTIONLOST
    if ((message.GetPairingStatus() == BTPHN_EN_PAIRING_STATUS_CONNECTIONLOST)) { eventId = CIT_EVENT_ID(OnPairingStatusResp_BTPHN_EN_PAIRING_STATUS_CONNECTIONLOST, 0x96036A38); return true; }
#endif
#ifdef OnPairingStatusResp_BTPHN_EN_PAIRING_STATUS_CANCELLED
    if ((message.GetPairingStatus() == BTPHN_EN_PAIRING_STATUS_CANCELLED)) { eventId = CIT_EVENT_ID(OnPairingStatusResp_BTPHN_EN_PAIRING_STATUS_CANCELLED, 0xF30788AF); return true; }
#endif
#ifdef OnPairingStatusResp_BTPHN_EN_PAIRING_STATUS_SUCCESSFUL
    if ((message.GetPairingStatus() == BTPHN_EN_PAIRING_STATUS_SUCCESSFUL)) { eventId = CIT_EVENT_ID(OnPairingStatusResp_BTPHN_EN_PAIRING_STATUS_SUCCESSFUL, 0x529C9034); return true; }
#endif
#ifdef OnPairingStatusResp_BTPHN_EN_PAIRING_STATUS_AUTHENTICATIONFAILURE
    if ((message.GetPairingStatus() == BTPHN_EN_PAIRING_STATUS_AUTHENTICATIONFAILURE)) { eventId = CIT_EVENT_ID(OnPairingStatusResp_BTPHN_EN_PAIRING_STATUS_AUTHENTICATIONFAILURE, 0x7A40C425); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForPairingStatusResp(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::PairingStatusResp const & message = static_cast< ::PairingStatusResp const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForDeviceStatusResp(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::DeviceStatusResp const & message = static_cast< ::DeviceStatusResp const &>(aMessage);

#ifdef OnDeviceStatusResp_BTPHN_EN_DEVICE_CONNECTED
    if ((message.GetDeviceStatus() == BTPHN_EN_DEVICE_CONNECTED)) { eventId = CIT_EVENT_ID(OnDeviceStatusResp_BTPHN_EN_DEVICE_CONNECTED, 0x2952978C); return true; }
#endif
#ifdef OnDeviceStatusResp_BTPHN_EN_DEVICE_DISCONNECTED
    if ((message.GetDeviceStatus() == BTPHN_EN_DEVICE_DISCONNECTED)) { eventId = CIT_EVENT_ID(OnDeviceStatusResp_BTPHN_EN_DEVICE_DISCONNECTED, 0xDF9225B5); return true; }
#endif
#ifdef OnDeviceStatusResp_BTPHN_EN_DEVICE_CONNECTED_OSD
    if ((message.GetDeviceStatus() == BTPHN_EN_DEVICE_CONNECTED_OSD)) { eventId = CIT_EVENT_ID(OnDeviceStatusResp_BTPHN_EN_DEVICE_CONNECTED_OSD, 0x86E99036); return true; }
#endif
#ifdef OnDeviceStatusResp_BTPHN_EN_DEVICE_DELETED
    if ((message.GetDeviceStatus() == BTPHN_EN_DEVICE_DELETED)) { eventId = CIT_EVENT_ID(OnDeviceStatusResp_BTPHN_EN_DEVICE_DELETED, 0xF492BCC7); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForDeviceStatusResp(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::DeviceStatusResp const & message = static_cast< ::DeviceStatusResp const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForDeviceListFullResp(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnDeviceListFullResp, 0xCEEB9813);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForDeviceListFullResp(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForIntercomIncomingCallResp(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnIntercomIncomingCallResp, 0xD155618D);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForIntercomIncomingCallResp(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForIntercomRTPStreamFailureResp(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnIntercomRTPStreamFailureResp, 0xD0640E45);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForIntercomRTPStreamFailureResp(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForIntercomIncomingCallHardKeyResp(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnIntercomIncomingCallHardKeyResp, 0x4CE98F70);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForIntercomIncomingCallHardKeyResp(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForClearEditFieldResp(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnClearEditFieldResp, 0x518AC750);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForClearEditFieldResp(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForConnectedDeviceSelectedResp(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::ConnectedDeviceSelectedResp const & message = static_cast< ::ConnectedDeviceSelectedResp const &>(aMessage);

#ifdef OnConnectedDeviceSelectedResp_BTPHN_C_VALUE_ONE
    if ((message.GetIsHandsFreeSupported() == BTPHN_C_VALUE_ONE)) { eventId = CIT_EVENT_ID(OnConnectedDeviceSelectedResp_BTPHN_C_VALUE_ONE, 0xBE2D5DEE); return true; }
#endif
#ifdef OnConnectedDeviceSelectedResp_BTPHN_C_VALUE_ZERO
    if ((message.GetIsHandsFreeSupported() == BTPHN_C_VALUE_ZERO)) { eventId = CIT_EVENT_ID(OnConnectedDeviceSelectedResp_BTPHN_C_VALUE_ZERO, 0xDC5BA625); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForConnectedDeviceSelectedResp(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::ConnectedDeviceSelectedResp const & message = static_cast< ::ConnectedDeviceSelectedResp const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForPairingPinResp(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnPairingPinResp, 0x313C2D85);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForPairingPinResp(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForDeleteDeviceResp(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnDeleteDeviceResp, 0x633B5EFC);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForDeleteDeviceResp(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForDisconnectDeviceResp(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnDisconnectDeviceResp, 0xE562F2BF);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForDisconnectDeviceResp(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForContactDetailsResp(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnContactDetailsResp, 0x704DBE19);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForContactDetailsResp(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForContactListWindowResp(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnContactListWindowResp, 0x53FEEF3D);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForContactListWindowResp(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForCallListWindowResp(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnCallListWindowResp, 0x4F088DE5);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForCallListWindowResp(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForApplicationSwitchInitiationStatus(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnApplicationSwitchInitiationStatus, 0x157286E4);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForApplicationSwitchInitiationStatus(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForCallListDownloadStateResp(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::CallListDownloadStateResp const & message = static_cast< ::CallListDownloadStateResp const &>(aMessage);

#ifdef OnCallListDownloadStateResp_BTPHN_EN_RCDS_NOT_STARTED
    if ((message.GetCallListDS() == BTPHN_EN_RCDS_NOT_STARTED)) { eventId = CIT_EVENT_ID(OnCallListDownloadStateResp_BTPHN_EN_RCDS_NOT_STARTED, 0x21A485EC); return true; }
#endif
#ifdef OnCallListDownloadStateResp_BTPHN_EN_RCDS_IN_PROCESS
    if ((message.GetCallListDS() == BTPHN_EN_RCDS_IN_PROCESS)) { eventId = CIT_EVENT_ID(OnCallListDownloadStateResp_BTPHN_EN_RCDS_IN_PROCESS, 0x8F530E70); return true; }
#endif
#ifdef OnCallListDownloadStateResp_BTPHN_EN_RCDS_COMPLETE
    if ((message.GetCallListDS() == BTPHN_EN_RCDS_COMPLETE)) { eventId = CIT_EVENT_ID(OnCallListDownloadStateResp_BTPHN_EN_RCDS_COMPLETE, 0x7E1D5174); return true; }
#endif
#ifdef OnCallListDownloadStateResp_BTPHN_EN_RCDS_ERROR
    if ((message.GetCallListDS() == BTPHN_EN_RCDS_ERROR)) { eventId = CIT_EVENT_ID(OnCallListDownloadStateResp_BTPHN_EN_RCDS_ERROR, 0x47E33294); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForCallListDownloadStateResp(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::CallListDownloadStateResp const & message = static_cast< ::CallListDownloadStateResp const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForPhnBkDownloadStateResp(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::PhnBkDownloadStateResp const & message = static_cast< ::PhnBkDownloadStateResp const &>(aMessage);

#ifdef PhoneBook_Download_Not_Started
    if ((message.GetPhoneBookDS() == BTPHN_EN_PBDS_NOT_STARTED)) { eventId = CIT_EVENT_ID(PhoneBook_Download_Not_Started, 0x1B2A21D3); return true; }
#endif
#ifdef PhoneBook_Download_InProgress
    if ((message.GetPhoneBookDS() == BTPHN_EN_PBDS_CONTACT_INFO)) { eventId = CIT_EVENT_ID(PhoneBook_Download_InProgress, 0x0107147B); return true; }
#endif
#ifdef PhoneBook_Download_Complete
    if ((message.GetPhoneBookDS() == BTPHN_EN_PBDS_COMPLETE)) { eventId = CIT_EVENT_ID(PhoneBook_Download_Complete, 0x74976DFC); return true; }
#endif
#ifdef PhoneBook_Download_Error
    if ((message.GetPhoneBookDS() == BTPHN_EN_PBDS_ERROR)) { eventId = CIT_EVENT_ID(PhoneBook_Download_Error, 0x17F6BE09); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForPhnBkDownloadStateResp(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::PhnBkDownloadStateResp const & message = static_cast< ::PhnBkDownloadStateResp const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForBTServiceErrResp(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::BTServiceErrResp const & message = static_cast< ::BTServiceErrResp const &>(aMessage);

#ifdef OnBTServiceErrResp_BTPHN_EN_BT_CHANGEDEVICESTATE
    if ((message.GetServiceType() == BTPHN_EN_BT_CHANGEDEVICESTATE)) { eventId = CIT_EVENT_ID(OnBTServiceErrResp_BTPHN_EN_BT_CHANGEDEVICESTATE, 0x92993AAA); return true; }
#endif
#ifdef OnBTServiceErrResp_BTPHN_EN_BT_CONNECTIONFAILED
    if ((message.GetServiceType() == BTPHN_EN_BT_CONNECTIONFAILED)) { eventId = CIT_EVENT_ID(OnBTServiceErrResp_BTPHN_EN_BT_CONNECTIONFAILED, 0x04397934); return true; }
#endif
#ifdef OnBTServiceErrResp_BTPHN_EN_BT_ADDNEWDEVICE
    if ((message.GetServiceType() == BTPHN_EN_BT_ADDNEWDEVICE)) { eventId = CIT_EVENT_ID(OnBTServiceErrResp_BTPHN_EN_BT_ADDNEWDEVICE, 0x88C22161); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForBTServiceErrResp(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::BTServiceErrResp const & message = static_cast< ::BTServiceErrResp const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForSLCStatusResp(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::SLCStatusResp const & message = static_cast< ::SLCStatusResp const &>(aMessage);

#ifdef OnSLCStatusResp_0
    if ((message.GetSLCStatus() == 0)) { eventId = CIT_EVENT_ID(OnSLCStatusResp_0, 0x8448D561); return true; }
#endif
#ifdef OnSLCStatusResp_1
    if ((message.GetSLCStatus() == 1)) { eventId = CIT_EVENT_ID(OnSLCStatusResp_1, 0xEEFAAAB7); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSLCStatusResp(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::SLCStatusResp const & message = static_cast< ::SLCStatusResp const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForECallStatusResp(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::ECallStatusResp const & message = static_cast< ::ECallStatusResp const &>(aMessage);

#ifdef OnECallStatusResp_1
    if ((message.GetIsECallActive() == 1)) { eventId = CIT_EVENT_ID(OnECallStatusResp_1, 0xB3DF12E7); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForECallStatusResp(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::ECallStatusResp const & message = static_cast< ::ECallStatusResp const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForConnectionStatusResp(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::ConnectionStatusResp const & message = static_cast< ::ConnectionStatusResp const &>(aMessage);

#ifdef OnConnectionStatusResp_0
    if ((message.GetBConnectionStatus() == 0)) { eventId = CIT_EVENT_ID(OnConnectionStatusResp_0, 0x33C8F767); return true; }
#endif
#ifdef OnConnectionStatusResp_1
    if ((message.GetBConnectionStatus() == 1)) { eventId = CIT_EVENT_ID(OnConnectionStatusResp_1, 0x6A9BE50C); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForConnectionStatusResp(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::ConnectionStatusResp const & message = static_cast< ::ConnectionStatusResp const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForMICContactsCallHistoryResp(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(Pfo_MICContactsCallHistoryResp, 0x3AC09AAF);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForMICContactsCallHistoryResp(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForMICIntercomCallResp(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(Pfo_MICIntercomCallResp, 0x634D3BF9);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForMICIntercomCallResp(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForMICPhoneCallResp(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(Pfo_MICPhoneCallResp, 0x5EB92C68);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForMICPhoneCallResp(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForMICIncCallPopupCloseResp(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(Pfo_MICIncCallPopupCloseResp, 0x21F54113);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForMICIncCallPopupCloseResp(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForMICOutCallPopupCloseResp(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(Pfo_MICOutCallPopupCloseResp, 0xDF26B227);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForMICOutCallPopupCloseResp(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForMICActiveCallPopupCloseResp(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(Pfo_MICActiveCallPopupCloseResp, 0x7DC1044D);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForMICActiveCallPopupCloseResp(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForShowPriorityCall_BT_Req(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(PriorityCallPopup_BT_Req, 0x97D49257);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForShowPriorityCall_BT_Req(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForShowPriorityCall_Intercom_Req(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(PriorityCallPopup_Intercom_Req, 0x06B4F341);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForShowPriorityCall_Intercom_Req(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForHomeAppStateResp(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::HomeAppStateResp const & message = static_cast< ::HomeAppStateResp const &>(aMessage);

#ifdef OnHomeAppStateResp_0
    if ((message.GetIsHomeActive() == 0)) { eventId = CIT_EVENT_ID(OnHomeAppStateResp_0, 0x25419F23); return true; }
#endif
#ifdef OnHomeAppStateResp_1
    if ((message.GetIsHomeActive() == 1)) { eventId = CIT_EVENT_ID(OnHomeAppStateResp_1, 0x52F27A84); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForHomeAppStateResp(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::HomeAppStateResp const & message = static_cast< ::HomeAppStateResp const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForCallStatusResp(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::CallStatusResp const & message = static_cast< ::CallStatusResp const &>(aMessage);

#ifdef OnCallStatusResp_BTPHN_EN_DIALING
    if ((message.GetCallStatus() == BTPHN_EN_DIALING)) { eventId = CIT_EVENT_ID(OnCallStatusResp_BTPHN_EN_DIALING, 0x255A6126); return true; }
#endif
#ifdef OnCallStatusResp_BTPHN_EN_ACTIVE
    if ((message.GetCallStatus() == BTPHN_EN_ACTIVE)) { eventId = CIT_EVENT_ID(OnCallStatusResp_BTPHN_EN_ACTIVE, 0x293BAACB); return true; }
#endif
#ifdef OnCallStatusResp_BTPHN_EN_IDLE
    if ((message.GetCallStatus() == BTPHN_EN_IDLE)) { eventId = CIT_EVENT_ID(OnCallStatusResp_BTPHN_EN_IDLE, 0x0B21F17A); return true; }
#endif
#ifdef OnCallStatusResp_BTPHN_EN_DISCONNECTING
    if ((message.GetCallStatus() == BTPHN_EN_DISCONNECTING)) { eventId = CIT_EVENT_ID(OnCallStatusResp_BTPHN_EN_DISCONNECTING, 0x4F41E729); return true; }
#endif
#ifdef OnCallStatusResp_BTPHN_EN_ON_HOLD
    if ((message.GetCallStatus() == BTPHN_EN_ON_HOLD)) { eventId = CIT_EVENT_ID(OnCallStatusResp_BTPHN_EN_ON_HOLD, 0x8FB4D5EB); return true; }
#endif
#ifdef OnCallStatusResp_BTPHN_EN_RINGTONE
    if ((message.GetCallStatus() == BTPHN_EN_RINGTONE)) { eventId = CIT_EVENT_ID(OnCallStatusResp_BTPHN_EN_RINGTONE, 0x884EA3AC); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForCallStatusResp(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::CallStatusResp const & message = static_cast< ::CallStatusResp const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined OnIncomingCallResp_BTPHN_EN_INRINGING
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define OnIncomingCallResp_BTPHN_EN_INRINGING 0xffff
#pragma _REMINDER("Using dummy value symbol OnIncomingCallResp_BTPHN_EN_INRINGING ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol OnIncomingCallResp_BTPHN_EN_INRINGING -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined OnIncomingCallResp_BTPHN_EN_INIDLE
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define OnIncomingCallResp_BTPHN_EN_INIDLE 0xffff
#pragma _REMINDER("Using dummy value symbol OnIncomingCallResp_BTPHN_EN_INIDLE ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol OnIncomingCallResp_BTPHN_EN_INIDLE -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForIncomingCallResp(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::IncomingCallResp const & message = static_cast< ::IncomingCallResp const &>(aMessage);

#ifdef OnIncomingCallResp_BTPHN_EN_INRINGING
    if ((message.GetStatus() == BTPHN_EN_INRINGING)) { eventId = CIT_EVENT_ID(OnIncomingCallResp_BTPHN_EN_INRINGING, 0xDCDA98B3); return true; }
#endif
#ifdef OnIncomingCallResp_BTPHN_EN_INIDLE
    if ((message.GetStatus() == BTPHN_EN_INIDLE)) { eventId = CIT_EVENT_ID(OnIncomingCallResp_BTPHN_EN_INIDLE, 0x4192A43E); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForIncomingCallResp(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::IncomingCallResp const & message = static_cast< ::IncomingCallResp const &>(aMessage);
#ifdef OnIncomingCallResp_BTPHN_EN_INRINGING
    if (eventId == OnIncomingCallResp_BTPHN_EN_INRINGING) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetDeviceType()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_OnIncomingCallResp_BTPHN_EN_INRINGING.DeviceType = message.GetDeviceType();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef OnIncomingCallResp_BTPHN_EN_INIDLE
    if (eventId == OnIncomingCallResp_BTPHN_EN_INIDLE) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetDeviceType()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_OnIncomingCallResp_BTPHN_EN_INIDLE.DeviceType = message.GetDeviceType();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForIncomingMessageListResp(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnIncomingMessageListResp, 0x82ABC1C3);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForIncomingMessageListResp(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForIntercomCallEndStatus(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnIntercomCallEndStatus, 0x3B718C13);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForIntercomCallEndStatus(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForAcceptOutgoingIntercomCall(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnAcceptOutgoingIntercomCall, 0x73D232EF);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForAcceptOutgoingIntercomCall(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForSwitchToICallConnecting(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnSwitchToICallConnecting, 0xB7452695);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSwitchToICallConnecting(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForSwitchToIConferenceCall(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnSwitchToIConferenceCall, 0x2170A1DE);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSwitchToIConferenceCall(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForMultipleCallStatusResp(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::MultipleCallStatusResp const & message = static_cast< ::MultipleCallStatusResp const &>(aMessage);

#ifdef Multiparty_1_Active_2_Active
    if ((message.GetFirstCallStatus() == BTPHN_EN_ACTIVE) && (message.GetSecondCallStatus() == BTPHN_EN_ACTIVE)) { eventId = CIT_EVENT_ID(Multiparty_1_Active_2_Active, 0x0F7A9F4D); return true; }
#endif
#ifdef Multiparty_1_Hold_2_Hold
    if ((message.GetFirstCallStatus() == BTPHN_EN_ON_HOLD) && (message.GetSecondCallStatus() == BTPHN_EN_ON_HOLD)) { eventId = CIT_EVENT_ID(Multiparty_1_Hold_2_Hold, 0x1A0C543A); return true; }
#endif
#ifdef Multiparty_1_Active_2_Hold
    if ((message.GetFirstCallStatus() == BTPHN_EN_ACTIVE) && (message.GetSecondCallStatus() == BTPHN_EN_ON_HOLD)) { eventId = CIT_EVENT_ID(Multiparty_1_Active_2_Hold, 0x344D1AD8); return true; }
#endif
#ifdef Multiparty_1_Hold_2_Active
    if ((message.GetFirstCallStatus() == BTPHN_EN_ON_HOLD) && (message.GetSecondCallStatus() == BTPHN_EN_ACTIVE)) { eventId = CIT_EVENT_ID(Multiparty_1_Hold_2_Active, 0x7164B377); return true; }
#endif
#ifdef Multiparty_Conference
    if ((message.GetFirstCallStatus() == BTPHN_EN_CONFERENCE) && (message.GetSecondCallStatus() == BTPHN_EN_CONFERENCE)) { eventId = CIT_EVENT_ID(Multiparty_Conference, 0x9B30BCAC); return true; }
#endif
#ifdef Multiparty_SecondCall_Dialing
    if ((message.GetSecondCallStatus() == BTPHN_EN_DIALING)) { eventId = CIT_EVENT_ID(Multiparty_SecondCall_Dialing, 0x1F600E3E); return true; }
#endif
#ifdef Multiparty_FirstCall_Dialing
    if ((message.GetFirstCallStatus() == BTPHN_EN_DIALING)) { eventId = CIT_EVENT_ID(Multiparty_FirstCall_Dialing, 0x00971FAF); return true; }
#endif
#ifdef Multiparty_SecondCall_Ringing
    if ((message.GetSecondCallStatus() == BTPHN_EN_RINGTONE)) { eventId = CIT_EVENT_ID(Multiparty_SecondCall_Ringing, 0xF4DFDC68); return true; }
#endif
#ifdef Multiparty_FirstCall_Ringing
    if ((message.GetFirstCallStatus() == BTPHN_EN_RINGTONE)) { eventId = CIT_EVENT_ID(Multiparty_FirstCall_Ringing, 0x2C433518); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForMultipleCallStatusResp(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::MultipleCallStatusResp const & message = static_cast< ::MultipleCallStatusResp const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForOptionKeyResp(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnOptionKeyResp, 0xB70B86AA);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForOptionKeyResp(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForSWCHookResp(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::SWCHookResp const & message = static_cast< ::SWCHookResp const &>(aMessage);

#ifdef OnSWCHookResp_BTPHN_EN_OFFHOOK_ACTIVATE
    if ((message.GetOnOffHookStatus() == BTPHN_EN_OFFHOOK_ACTIVATE)) { eventId = CIT_EVENT_ID(OnSWCHookResp_BTPHN_EN_OFFHOOK_ACTIVATE, 0x4D3D22EA); return true; }
#endif
#ifdef OnSWCHookResp_BTPHN_EN_ONHOOK_TERMINATE
    if ((message.GetOnOffHookStatus() == BTPHN_EN_ONHOOK_TERMINATE)) { eventId = CIT_EVENT_ID(OnSWCHookResp_BTPHN_EN_ONHOOK_TERMINATE, 0xC8A66858); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSWCHookResp(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::SWCHookResp const & message = static_cast< ::SWCHookResp const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForSWCMuteResp(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnSWCMuteResp, 0xFF0B8CB4);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSWCMuteResp(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForBTVRStatusResp(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::BTVRStatusResp const & message = static_cast< ::BTVRStatusResp const &>(aMessage);

#ifdef OnBTVRStatusResp_true
    if ((message.GetBtvrSessionStatus() == true)) { eventId = CIT_EVENT_ID(OnBTVRStatusResp_true, 0x49877438); return true; }
#endif
#ifdef OnBTVRStatusResp_false
    if ((message.GetBtvrSessionStatus() == false)) { eventId = CIT_EVENT_ID(OnBTVRStatusResp_false, 0xF74726B3); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForBTVRStatusResp(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::BTVRStatusResp const & message = static_cast< ::BTVRStatusResp const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForGenericCANBTVRReq(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(Trigger_GenericCANBTVRReq, 0x57FE6183);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForGenericCANBTVRReq(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForActivateApplicationMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnActivateApplicationMsg, 0xC70281BB);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActivateApplicationMsg(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForDeactivateApplicationMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnDeactivateApplicationMsg, 0x37E7CAFB);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForDeactivateApplicationMsg(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForActivityMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::ActivityMsg const & message = static_cast< ::ActivityMsg const &>(aMessage);

#ifdef Activate_Call_List
    if ((message.GetActivityID() == eActivityID_PHONE_CALL_LIST)) { eventId = CIT_EVENT_ID(Activate_Call_List, 0xA71E95AC); return true; }
#endif
#ifdef Activate_Contact_List
    if ((message.GetActivityID() == eActivityID_PHONE_CONTACT_LIST)) { eventId = CIT_EVENT_ID(Activate_Contact_List, 0x3F99E34E); return true; }
#endif
#ifdef Activate_Device_List
    if ((message.GetActivityID() == eActivityID_PHONE_DEVICE_SELECTION)) { eventId = CIT_EVENT_ID(Activate_Device_List, 0x312735D0); return true; }
#endif
#ifdef Activate_Call_Connecting
    if ((message.GetActivityID() == eActivityID_PHONE_CALL_CONNECTING)) { eventId = CIT_EVENT_ID(Activate_Call_Connecting, 0x5F065AAF); return true; }
#endif
#ifdef Activate_On_Call
    if ((message.GetActivityID() == eActivityID_PHONE_ON_CALL)) { eventId = CIT_EVENT_ID(Activate_On_Call, 0x57F1533A); return true; }
#endif
#ifdef Activate_On_Multiparty_Call
    if ((message.GetActivityID() == eActivityID_PHONE_ON_MULTIPARTY_CALL)) { eventId = CIT_EVENT_ID(Activate_On_Multiparty_Call, 0x4E6FD7E8); return true; }
#endif
#ifdef Activate_History
    if ((message.GetActivityID() == eActivityID_NO_CHANGE)) { eventId = CIT_EVENT_ID(Activate_History, 0x5FB1A184); return true; }
#endif
#ifdef Activate_On_IntercomCall
    if ((message.GetActivityID() == eActivityID_PHONE_ON_INTERCOMCALL)) { eventId = CIT_EVENT_ID(Activate_On_IntercomCall, 0x56EC22D6); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActivityMsg(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::ActivityMsg const & message = static_cast< ::ActivityMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForActivationResMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::Courier::ActivationResMsg const & message = static_cast< ::Courier::ActivationResMsg const &>(aMessage);

#ifdef OnActivationResMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_IncomingCall_1
    if ((message.GetViewId() == ::Courier::ViewId("AppHmi_PhoneModule#Sys_Popup#Pfo_IncomingCall")) && (message.GetSuccess() == 1)) { eventId = CIT_EVENT_ID(OnActivationResMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_IncomingCall_1, 0x60E616BC); return true; }
#endif
#ifdef OnActivationResMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_MIC_PhoneCall_1
    if ((message.GetViewId() == ::Courier::ViewId("AppHmi_PhoneModule#Sys_Popup#Pfo_MIC_PhoneCall")) && (message.GetSuccess() == 1)) { eventId = CIT_EVENT_ID(OnActivationResMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_MIC_PhoneCall_1, 0x69DE1080); return true; }
#endif
#ifdef OnActivationResMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_MIC_IntercomCall_1
    if ((message.GetViewId() == ::Courier::ViewId("AppHmi_PhoneModule#Sys_Popup#Pfo_MIC_IntercomCall")) && (message.GetSuccess() == 1)) { eventId = CIT_EVENT_ID(OnActivationResMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_MIC_IntercomCall_1, 0x272B042F); return true; }
#endif
#ifdef OnActivationResMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_MIC_CallHistory_Contacts_1
    if ((message.GetViewId() == ::Courier::ViewId("AppHmi_PhoneModule#Sys_Popup#Pfo_MIC_CallHistory_Contacts")) && (message.GetSuccess() == 1)) { eventId = CIT_EVENT_ID(OnActivationResMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_MIC_CallHistory_Contacts_1, 0x7E2C01C4); return true; }
#endif
#ifdef OnActivationResMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_PassiveDeviceIncomingCall_1
    if ((message.GetViewId() == ::Courier::ViewId("AppHmi_PhoneModule#Sys_Popup#Pfo_PassiveDeviceIncomingCall")) && (message.GetSuccess() == 1)) { eventId = CIT_EVENT_ID(OnActivationResMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_PassiveDeviceIncomingCall_1, 0xEDF17D92); return true; }
#endif
#ifdef OnActivationResMsg_AppHmi_PhoneModule_Sys_Popup_SR_SIRI_Main_1
    if ((message.GetViewId() == ::Courier::ViewId("AppHmi_PhoneModule#Sys_Popup#SR_SIRI_Main")) && (message.GetSuccess() == 1)) { eventId = CIT_EVENT_ID(OnActivationResMsg_AppHmi_PhoneModule_Sys_Popup_SR_SIRI_Main_1, 0x95DF677C); return true; }
#endif
#ifdef OnActivationResMsg_AppHmi_PhoneModule_App_Popup_Pfo_DeviceDeleting_1
    if ((message.GetViewId() == ::Courier::ViewId("AppHmi_PhoneModule#App_Popup#Pfo_DeviceDeleting")) && (message.GetSuccess() == 1)) { eventId = CIT_EVENT_ID(OnActivationResMsg_AppHmi_PhoneModule_App_Popup_Pfo_DeviceDeleting_1, 0x6D02E92A); return true; }
#endif
#ifdef OnActivationResMsg_AppHmi_PhoneModule_App_Popup_Pfo_DeviceDeleted_1
    if ((message.GetViewId() == ::Courier::ViewId("AppHmi_PhoneModule#App_Popup#Pfo_DeviceDeleted")) && (message.GetSuccess() == 1)) { eventId = CIT_EVENT_ID(OnActivationResMsg_AppHmi_PhoneModule_App_Popup_Pfo_DeviceDeleted_1, 0x5D48B341); return true; }
#endif
#ifdef OnActivationResMsg_AppHmi_PhoneModule_App_Popup_Pfo_DeleteDeviceConfirmation_1
    if ((message.GetViewId() == ::Courier::ViewId("AppHmi_PhoneModule#App_Popup#Pfo_DeleteDeviceConfirmation")) && (message.GetSuccess() == 1)) { eventId = CIT_EVENT_ID(OnActivationResMsg_AppHmi_PhoneModule_App_Popup_Pfo_DeleteDeviceConfirmation_1, 0xD839F7AA); return true; }
#endif
#ifdef OnActivationResMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_PhonebookDLFailed_1
    if ((message.GetViewId() == ::Courier::ViewId("AppHmi_PhoneModule#Sys_Popup#Pfo_PhonebookDLFailed")) && (message.GetSuccess() == 1)) { eventId = CIT_EVENT_ID(OnActivationResMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_PhonebookDLFailed_1, 0x5E101645); return true; }
#endif
#ifdef OnActivationResMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_PhonebookDLIncomplete_1
    if ((message.GetViewId() == ::Courier::ViewId("AppHmi_PhoneModule#Sys_Popup#Pfo_PhonebookDLIncomplete")) && (message.GetSuccess() == 1)) { eventId = CIT_EVENT_ID(OnActivationResMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_PhonebookDLIncomplete_1, 0x5FC96725); return true; }
#endif
#ifdef OnActivationResMsg_AppHmi_PhoneModule_App_Popup_Pfo_WaitForConfirmation_1
    if ((message.GetViewId() == ::Courier::ViewId("AppHmi_PhoneModule#App_Popup#Pfo_WaitForConfirmation")) && (message.GetSuccess() == 1)) { eventId = CIT_EVENT_ID(OnActivationResMsg_AppHmi_PhoneModule_App_Popup_Pfo_WaitForConfirmation_1, 0xF0695058); return true; }
#endif
#ifdef OnActivationResMsg_AppHmi_PhoneModule_App_Popup_Pfo_DeviceConnecting_1
    if ((message.GetViewId() == ::Courier::ViewId("AppHmi_PhoneModule#App_Popup#Pfo_DeviceConnecting")) && (message.GetSuccess() == 1)) { eventId = CIT_EVENT_ID(OnActivationResMsg_AppHmi_PhoneModule_App_Popup_Pfo_DeviceConnecting_1, 0x33806006); return true; }
#endif
#ifdef OnActivationResMsg_AppHmi_PhoneModule_App_Popup_Pfo_PairingInitiate_1
    if ((message.GetViewId() == ::Courier::ViewId("AppHmi_PhoneModule#App_Popup#Pfo_PairingInitiate")) && (message.GetSuccess() == 1)) { eventId = CIT_EVENT_ID(OnActivationResMsg_AppHmi_PhoneModule_App_Popup_Pfo_PairingInitiate_1, 0xA7CD1B80); return true; }
#endif
#ifdef OnActivationResMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_ConnectionFailed_1
    if ((message.GetViewId() == ::Courier::ViewId("AppHmi_PhoneModule#Sys_Popup#Pfo_ConnectionFailed")) && (message.GetSuccess() == 1)) { eventId = CIT_EVENT_ID(OnActivationResMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_ConnectionFailed_1, 0x7C9A52BF); return true; }
#endif
#ifdef OnActivationResMsg_AppHmi_PhoneModule_App_Popup_Pfo_NumCompPairing_1
    if ((message.GetViewId() == ::Courier::ViewId("AppHmi_PhoneModule#App_Popup#Pfo_NumCompPairing")) && (message.GetSuccess() == 1)) { eventId = CIT_EVENT_ID(OnActivationResMsg_AppHmi_PhoneModule_App_Popup_Pfo_NumCompPairing_1, 0xF35157EE); return true; }
#endif
#ifdef OnActivationResMsg_AppHmi_PhoneModule_App_Popup_Pfo_JustWorksPairingWaiting_1
    if ((message.GetViewId() == ::Courier::ViewId("AppHmi_PhoneModule#App_Popup#Pfo_JustWorksPairingWaiting")) && (message.GetSuccess() == 1)) { eventId = CIT_EVENT_ID(OnActivationResMsg_AppHmi_PhoneModule_App_Popup_Pfo_JustWorksPairingWaiting_1, 0x1FB4F8F8); return true; }
#endif
#ifdef OnActivationResMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_Intercom_RTP_stream_failure_1
    if ((message.GetViewId() == ::Courier::ViewId("AppHmi_PhoneModule#Sys_Popup#Pfo_Intercom_RTP_stream_failure")) && (message.GetSuccess() == 1)) { eventId = CIT_EVENT_ID(OnActivationResMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_Intercom_RTP_stream_failure_1, 0xCB7A2ED5); return true; }
#endif
#ifdef OnActivationResMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_DeviceDisConnected_1
    if ((message.GetViewId() == ::Courier::ViewId("AppHmi_PhoneModule#Sys_Popup#Pfo_DeviceDisConnected")) && (message.GetSuccess() == 1)) { eventId = CIT_EVENT_ID(OnActivationResMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_DeviceDisConnected_1, 0x6BF7C777); return true; }
#endif
#ifdef OnActivationResMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_DeviceConnected_1
    if ((message.GetViewId() == ::Courier::ViewId("AppHmi_PhoneModule#Sys_Popup#Pfo_DeviceConnected")) && (message.GetSuccess() == 1)) { eventId = CIT_EVENT_ID(OnActivationResMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_DeviceConnected_1, 0x94D9AE54); return true; }
#endif
#ifdef OnActivationResMsg_AppHmi_PhoneModule_App_Popup_Pfo_JustWorksPairing_1
    if ((message.GetViewId() == ::Courier::ViewId("AppHmi_PhoneModule#App_Popup#Pfo_JustWorksPairing")) && (message.GetSuccess() == 1)) { eventId = CIT_EVENT_ID(OnActivationResMsg_AppHmi_PhoneModule_App_Popup_Pfo_JustWorksPairing_1, 0x7C88FFB5); return true; }
#endif
#ifdef OnActivationResMsg_AppHmi_PhoneModule_App_Popup_Pfo_DeviceListFull_1
    if ((message.GetViewId() == ::Courier::ViewId("AppHmi_PhoneModule#App_Popup#Pfo_DeviceListFull")) && (message.GetSuccess() == 1)) { eventId = CIT_EVENT_ID(OnActivationResMsg_AppHmi_PhoneModule_App_Popup_Pfo_DeviceListFull_1, 0x0A2FE341); return true; }
#endif
#ifdef OnActivationResMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_SMSExpand_1
    if ((message.GetViewId() == ::Courier::ViewId("AppHmi_PhoneModule#Sys_Popup#Pfo_SMSExpand")) && (message.GetSuccess() == 1)) { eventId = CIT_EVENT_ID(OnActivationResMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_SMSExpand_1, 0x6FADB707); return true; }
#endif
#ifdef OnActivationResMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_SMS_1
    if ((message.GetViewId() == ::Courier::ViewId("AppHmi_PhoneModule#Sys_Popup#Pfo_SMS")) && (message.GetSuccess() == 1)) { eventId = CIT_EVENT_ID(OnActivationResMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_SMS_1, 0x68B7EC7B); return true; }
#endif
#ifdef OnActivationResMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_PriorityCall_BT_1
    if ((message.GetViewId() == ::Courier::ViewId("AppHmi_PhoneModule#Sys_Popup#Pfo_PriorityCall_BT")) && (message.GetSuccess() == 1)) { eventId = CIT_EVENT_ID(OnActivationResMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_PriorityCall_BT_1, 0x967D2656); return true; }
#endif
#ifdef OnActivationResMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_PriorityCall_Intercom_1
    if ((message.GetViewId() == ::Courier::ViewId("AppHmi_PhoneModule#Sys_Popup#Pfo_PriorityCall_Intercom")) && (message.GetSuccess() == 1)) { eventId = CIT_EVENT_ID(OnActivationResMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_PriorityCall_Intercom_1, 0x8F456BA8); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActivationResMsg(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::Courier::ActivationResMsg const & message = static_cast< ::Courier::ActivationResMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onTopPopupSurfaceInvisible
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onTopPopupSurfaceInvisible 0xffff
#pragma _REMINDER("Using dummy value symbol onTopPopupSurfaceInvisible ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onTopPopupSurfaceInvisible -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onTopPopupSurfaceVisible
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onTopPopupSurfaceVisible 0xffff
#pragma _REMINDER("Using dummy value symbol onTopPopupSurfaceVisible ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onTopPopupSurfaceVisible -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onTopPopupSurfaceUnqueued
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onTopPopupSurfaceUnqueued 0xffff
#pragma _REMINDER("Using dummy value symbol onTopPopupSurfaceUnqueued ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onTopPopupSurfaceUnqueued -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onTopPopupSurfaceQueued
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onTopPopupSurfaceQueued 0xffff
#pragma _REMINDER("Using dummy value symbol onTopPopupSurfaceQueued ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onTopPopupSurfaceQueued -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onCenterPopupSurfaceInvisible
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onCenterPopupSurfaceInvisible 0xffff
#pragma _REMINDER("Using dummy value symbol onCenterPopupSurfaceInvisible ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onCenterPopupSurfaceInvisible -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onCenterPopupSurfaceVisible
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onCenterPopupSurfaceVisible 0xffff
#pragma _REMINDER("Using dummy value symbol onCenterPopupSurfaceVisible ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onCenterPopupSurfaceVisible -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onCenterPopupSurfaceUnqueued
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onCenterPopupSurfaceUnqueued 0xffff
#pragma _REMINDER("Using dummy value symbol onCenterPopupSurfaceUnqueued ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onCenterPopupSurfaceUnqueued -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onCenterPopupSurfaceQueued
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onCenterPopupSurfaceQueued 0xffff
#pragma _REMINDER("Using dummy value symbol onCenterPopupSurfaceQueued ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onCenterPopupSurfaceQueued -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onPopupVisible
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onPopupVisible 0xffff
#pragma _REMINDER("Using dummy value symbol onPopupVisible ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onPopupVisible -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onPopupUnqueued
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onPopupUnqueued 0xffff
#pragma _REMINDER("Using dummy value symbol onPopupUnqueued ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onPopupUnqueued -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onPopupQueued
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onPopupQueued 0xffff
#pragma _REMINDER("Using dummy value symbol onPopupQueued ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onPopupQueued -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForSurfaceStateChangedUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);

#ifdef onTopPopupSurfaceInvisible
    if ((message.GetSurfaceId() == SURFACEID_TOP_POPUP_SURFACE_PHONE) && (message.GetState() == SURFACESTATE_INVISIBLE)) { eventId = CIT_EVENT_ID(onTopPopupSurfaceInvisible, 0x3598CF84); return true; }
#endif
#ifdef onTopPopupSurfaceVisible
    if ((message.GetSurfaceId() == SURFACEID_TOP_POPUP_SURFACE_PHONE) && (message.GetState() == SURFACESTATE_VISIBLE)) { eventId = CIT_EVENT_ID(onTopPopupSurfaceVisible, 0x984F8ED8); return true; }
#endif
#ifdef onTopPopupSurfaceUnqueued
    if ((message.GetSurfaceId() == SURFACEID_TOP_POPUP_SURFACE_PHONE) && (message.GetState() == SURFACESTATE_UNQUEUED)) { eventId = CIT_EVENT_ID(onTopPopupSurfaceUnqueued, 0x912024BE); return true; }
#endif
#ifdef onTopPopupSurfaceQueued
    if ((message.GetSurfaceId() == SURFACEID_TOP_POPUP_SURFACE_PHONE) && (message.GetState() == SURFACESTATE_QUEUED)) { eventId = CIT_EVENT_ID(onTopPopupSurfaceQueued, 0xB630DDBD); return true; }
#endif
#ifdef onCenterPopupSurfaceInvisible
    if ((message.GetSurfaceId() == SURFACEID_CENTER_POPUP_SURFACE_PHONE) && (message.GetState() == SURFACESTATE_INVISIBLE)) { eventId = CIT_EVENT_ID(onCenterPopupSurfaceInvisible, 0x9BDB722F); return true; }
#endif
#ifdef onCenterPopupSurfaceVisible
    if ((message.GetSurfaceId() == SURFACEID_CENTER_POPUP_SURFACE_PHONE) && (message.GetState() == SURFACESTATE_VISIBLE)) { eventId = CIT_EVENT_ID(onCenterPopupSurfaceVisible, 0x23B97E51); return true; }
#endif
#ifdef onCenterPopupSurfaceUnqueued
    if ((message.GetSurfaceId() == SURFACEID_CENTER_POPUP_SURFACE_PHONE) && (message.GetState() == SURFACESTATE_UNQUEUED)) { eventId = CIT_EVENT_ID(onCenterPopupSurfaceUnqueued, 0xAA79C7DD); return true; }
#endif
#ifdef onCenterPopupSurfaceQueued
    if ((message.GetSurfaceId() == SURFACEID_CENTER_POPUP_SURFACE_PHONE) && (message.GetState() == SURFACESTATE_QUEUED)) { eventId = CIT_EVENT_ID(onCenterPopupSurfaceQueued, 0xFC0D2293); return true; }
#endif
#ifdef onPopupVisible
    if ((message.GetState() == SURFACESTATE_VISIBLE)) { eventId = CIT_EVENT_ID(onPopupVisible, 0xB78D7AE0); return true; }
#endif
#ifdef onPopupUnqueued
    if ((message.GetState() == SURFACESTATE_UNQUEUED)) { eventId = CIT_EVENT_ID(onPopupUnqueued, 0xDB0D29F4); return true; }
#endif
#ifdef onPopupQueued
    if ((message.GetState() == SURFACESTATE_QUEUED)) { eventId = CIT_EVENT_ID(onPopupQueued, 0xBBE6896C); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSurfaceStateChangedUpdMsg(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
#ifdef onTopPopupSurfaceInvisible
    if (eventId == onTopPopupSurfaceInvisible) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onTopPopupSurfaceInvisible.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onTopPopupSurfaceVisible
    if (eventId == onTopPopupSurfaceVisible) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onTopPopupSurfaceVisible.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onTopPopupSurfaceUnqueued
    if (eventId == onTopPopupSurfaceUnqueued) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onTopPopupSurfaceUnqueued.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onTopPopupSurfaceQueued
    if (eventId == onTopPopupSurfaceQueued) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onTopPopupSurfaceQueued.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onCenterPopupSurfaceInvisible
    if (eventId == onCenterPopupSurfaceInvisible) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onCenterPopupSurfaceInvisible.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onCenterPopupSurfaceVisible
    if (eventId == onCenterPopupSurfaceVisible) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onCenterPopupSurfaceVisible.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onCenterPopupSurfaceUnqueued
    if (eventId == onCenterPopupSurfaceUnqueued) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onCenterPopupSurfaceUnqueued.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onCenterPopupSurfaceQueued
    if (eventId == onCenterPopupSurfaceQueued) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onCenterPopupSurfaceQueued.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onPopupVisible
    if (eventId == onPopupVisible) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onPopupVisible.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onPopupUnqueued
    if (eventId == onPopupUnqueued) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onPopupUnqueued.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onPopupQueued
    if (eventId == onPopupQueued) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onPopupQueued.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForAcceptCallMCP(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ActivateCallMCP, 0x63C4EEF1);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForAcceptCallMCP(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForRejectCallOnMCPRejectBtnPress(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(EvRejectCallOnMCPRejectBtn, 0x4CC2E06E);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForRejectCallOnMCPRejectBtnPress(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForActivateAddDeviceMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ActivateAddDeviceScene, 0xB348A4F9);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActivateAddDeviceMsg(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForActivateCallListMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ActivateCallListScene, 0xB5E9C039);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActivateCallListMsg(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForActivateCallListLoadingMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ActivateCallListLoadingScene, 0x546421CB);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActivateCallListLoadingMsg(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForActivateContactListLoadingMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ActivateContactListLoadingScene, 0x517C7E7E);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActivateContactListLoadingMsg(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForActivateContactListMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ActivateContactScene, 0x4EE9D53B);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActivateContactListMsg(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForActivateDialPadMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ActivateDialPadScene, 0x5D063F95);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActivateDialPadMsg(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForActivateCallConnectingSceneMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ActivateCallConnectingScene, 0x1EFA5FBF);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActivateCallConnectingSceneMsg(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForActivateOnCallSceneMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ActivateOnCallScene, 0x89C61E06);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActivateOnCallSceneMsg(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForActivateOnMultipleCallSceneMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ActivateOnMultipleCallScene, 0x670E4823);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActivateOnMultipleCallSceneMsg(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForActivateOnContactCallMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ActivateOnContactCallScene, 0xA22E3193);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActivateOnContactCallMsg(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForActivateOnSettingSceneMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ActivateOnSettingScene, 0x06F20A53);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActivateOnSettingSceneMsg(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForActivateOnIntercomCallSceneMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ActivateOnIntercomCallScene, 0x2F0C4274);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActivateOnIntercomCallSceneMsg(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForActivateOnIntercomConfCallSceneMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ActivateOnIntercomConfCallScene, 0x9C0A110F);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActivateOnIntercomConfCallSceneMsg(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForActivateOnICallConnectingSceneMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ActivateOnICallConnectingScene, 0x54D2E537);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActivateOnICallConnectingSceneMsg(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForActivateOnIContactsSceneMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ActivateOnIContactsScene, 0x475B590E);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActivateOnIContactsSceneMsg(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onEncoderStatusChanged_RIGHT_ENC
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onEncoderStatusChanged_RIGHT_ENC 0xffff
#pragma _REMINDER("Using dummy value symbol onEncoderStatusChanged_RIGHT_ENC ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onEncoderStatusChanged_RIGHT_ENC -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForEncoderStatusChangedUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::EncoderStatusChangedUpdMsg const & message = static_cast< ::EncoderStatusChangedUpdMsg const &>(aMessage);

#ifdef onEncoderStatusChanged_RIGHT_ENC
    if ((message.GetEncCode() == ENCCODE_RIGHT_ENCODER)) { eventId = CIT_EVENT_ID(onEncoderStatusChanged_RIGHT_ENC, 0x67E5D82B); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForEncoderStatusChangedUpdMsg(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::EncoderStatusChangedUpdMsg const & message = static_cast< ::EncoderStatusChangedUpdMsg const &>(aMessage);
#ifdef onEncoderStatusChanged_RIGHT_ENC
    if (eventId == onEncoderStatusChanged_RIGHT_ENC) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetEncSteps()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onEncoderStatusChanged_RIGHT_ENC.EncSteps = message.GetEncSteps();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForHKStatusChangedUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::HKStatusChangedUpdMsg const & message = static_cast< ::HKStatusChangedUpdMsg const &>(aMessage);

#ifdef onHKStatusChanged_HK_SELECT_UP
    if ((message.GetHKCode() == HARDKEYCODE_HK_SELECT) && (message.GetHKState() == HARDKEYSTATE_UP)) { eventId = CIT_EVENT_ID(onHKStatusChanged_HK_SELECT_UP, 0x263EAF7F); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForHKStatusChangedUpdMsg(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::HKStatusChangedUpdMsg const & message = static_cast< ::HKStatusChangedUpdMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onPopupTimerExpiry
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onPopupTimerExpiry 0xffff
#pragma _REMINDER("Using dummy value symbol onPopupTimerExpiry ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onPopupTimerExpiry -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForExpiredPopupTimerResMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(onPopupTimerExpiry, 0xF3C96D17);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForExpiredPopupTimerResMsg(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::ExpiredPopupTimerResMsg const & message = static_cast< ::ExpiredPopupTimerResMsg const &>(aMessage);
#ifdef onPopupTimerExpiry
    if (eventId == onPopupTimerExpiry) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetViewId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onPopupTimerExpiry.ViewId = message.GetViewId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onActivateImageProviderRequest
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onActivateImageProviderRequest 0xffff
#pragma _REMINDER("Using dummy value symbol onActivateImageProviderRequest ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onActivateImageProviderRequest -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onDeactivateImageProviderRequest
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onDeactivateImageProviderRequest 0xffff
#pragma _REMINDER("Using dummy value symbol onDeactivateImageProviderRequest ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onDeactivateImageProviderRequest -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForActivateImageProviderReqMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::hmibase::gadget::ActivateImageProviderReqMsg const & message = static_cast< ::hmibase::gadget::ActivateImageProviderReqMsg const &>(aMessage);

#ifdef onActivateImageProviderRequest
    if ((message.GetActivate() == 1)) { eventId = CIT_EVENT_ID(onActivateImageProviderRequest, 0xDD62EA5B); return true; }
#endif
#ifdef onDeactivateImageProviderRequest
    if ((message.GetActivate() == 0)) { eventId = CIT_EVENT_ID(onDeactivateImageProviderRequest, 0x9FE98C1E); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActivateImageProviderReqMsg(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::hmibase::gadget::ActivateImageProviderReqMsg const & message = static_cast< ::hmibase::gadget::ActivateImageProviderReqMsg const &>(aMessage);
#ifdef onActivateImageProviderRequest
    if (eventId == onActivateImageProviderRequest) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetInstanceId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onActivateImageProviderRequest.InstanceId = message.GetInstanceId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onDeactivateImageProviderRequest
    if (eventId == onDeactivateImageProviderRequest) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetInstanceId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onDeactivateImageProviderRequest.InstanceId = message.GetInstanceId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForHMISubStateChangedUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::HMISubStateChangedUpdMsg const & message = static_cast< ::HMISubStateChangedUpdMsg const &>(aMessage);

#ifdef onHMISubStateChanged_ON
    if ((message.GetSubState() == HMISTATE_SHOW_HMI)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_ON, 0x76CF2B88); return true; }
#endif
#ifdef onHMISubStateChanged_CLOCK
    if ((message.GetSubState() == HMISTATE_SHOW_CLOCK)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_CLOCK, 0xF96478DC); return true; }
#endif
#ifdef onHMISubStateChanged_OFF
    if ((message.GetSubState() == HMISTATE_SHOW_OFF)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_OFF, 0x776D7D8A); return true; }
#endif
#ifdef onHMISubStateChanged_STANDBY_RESTRICTED
    if ((message.GetSubState() == HMISTATE_STANDBY_RESTRICTED)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_STANDBY_RESTRICTED, 0xA15C3CEE); return true; }
#endif
#ifdef onHMISubStateChanged_STANDBY
    if ((message.GetSubState() == HMISTATE_STANDBY)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_STANDBY, 0x0D0F5602); return true; }
#endif
#ifdef onHMISubStateChanged_PHONE
    if ((message.GetSubState() == HMISTATE_PHONE)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_PHONE, 0xC8D83B8B); return true; }
#endif
#ifdef onHMISubStateChanged_NO_DISPLAY
    if ((message.GetSubState() == HMISTATE_SHOW_NO_DISPLAY)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_NO_DISPLAY, 0xE4658CFD); return true; }
#endif
#ifdef onHMISubStateChanged_SECURE
    if ((message.GetSubState() == HMISTATE_SECURE)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_SECURE, 0xAB89D7A8); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForHMISubStateChangedUpdMsg(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::HMISubStateChangedUpdMsg const & message = static_cast< ::HMISubStateChangedUpdMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForApplicationStateUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::ApplicationStateUpdMsg const & message = static_cast< ::ApplicationStateUpdMsg const &>(aMessage);

#ifdef onAppStatusChanged_FOREGROUND
    if ((message.GetState() == hmibase::IN_FOREGROUND)) { eventId = CIT_EVENT_ID(onAppStatusChanged_FOREGROUND, 0xDE9448E3); return true; }
#endif
#ifdef onAppStatusChanged_BACKGROUND
    if ((message.GetState() == hmibase::IN_BACKGROUND)) { eventId = CIT_EVENT_ID(onAppStatusChanged_BACKGROUND, 0x6D1B3A68); return true; }
#endif
#ifdef onAppStatusPrepare_BACKGROUND
    if ((message.GetState() == hmibase::TO_BACKGROUND)) { eventId = CIT_EVENT_ID(onAppStatusPrepare_BACKGROUND, 0x4C8518AE); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForApplicationStateUpdMsg(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::ApplicationStateUpdMsg const & message = static_cast< ::ApplicationStateUpdMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onSubSurfaceUpdMsgChanged_FOREGROUND
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onSubSurfaceUpdMsgChanged_FOREGROUND 0xffff
#pragma _REMINDER("Using dummy value symbol onSubSurfaceUpdMsgChanged_FOREGROUND ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onSubSurfaceUpdMsgChanged_FOREGROUND -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onSubSurfaceUpdMsgChanged_BACKGROUND
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onSubSurfaceUpdMsgChanged_BACKGROUND 0xffff
#pragma _REMINDER("Using dummy value symbol onSubSurfaceUpdMsgChanged_BACKGROUND ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onSubSurfaceUpdMsgChanged_BACKGROUND -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForSubSurfaceUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::SubSurfaceUpdMsg const & message = static_cast< ::SubSurfaceUpdMsg const &>(aMessage);

#ifdef onSubSurfaceUpdMsgChanged_FOREGROUND
    if ((message.GetState() == hmibase::IN_FOREGROUND)) { eventId = CIT_EVENT_ID(onSubSurfaceUpdMsgChanged_FOREGROUND, 0x9D4DF4FC); return true; }
#endif
#ifdef onSubSurfaceUpdMsgChanged_BACKGROUND
    if ((message.GetState() == hmibase::IN_BACKGROUND)) { eventId = CIT_EVENT_ID(onSubSurfaceUpdMsgChanged_BACKGROUND, 0x5790D8C1); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSubSurfaceUpdMsg(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::SubSurfaceUpdMsg const & message = static_cast< ::SubSurfaceUpdMsg const &>(aMessage);
#ifdef onSubSurfaceUpdMsgChanged_FOREGROUND
    if (eventId == onSubSurfaceUpdMsgChanged_FOREGROUND) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetDisplayRegion(), message.GetDisplayID()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onSubSurfaceUpdMsgChanged_FOREGROUND.DisplayRegion = message.GetDisplayRegion();
        onClickParam.VSEPS_onSubSurfaceUpdMsgChanged_FOREGROUND.DisplayID = message.GetDisplayID();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onSubSurfaceUpdMsgChanged_BACKGROUND
    if (eventId == onSubSurfaceUpdMsgChanged_BACKGROUND) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetDisplayRegion(), message.GetDisplayID()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onSubSurfaceUpdMsgChanged_BACKGROUND.DisplayRegion = message.GetDisplayRegion();
        onClickParam.VSEPS_onSubSurfaceUpdMsgChanged_BACKGROUND.DisplayID = message.GetDisplayID();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForTransitionIndMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::Courier::TransitionIndMsg const & message = static_cast< ::Courier::TransitionIndMsg const &>(aMessage);

#ifdef OnNextLevelTransitionFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("NextLevelTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnNextLevelTransitionFinished, 0xE7DCE080); return true; }
#endif
#ifdef OnPreviousLevelTransitionFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("PreviousLevelTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnPreviousLevelTransitionFinished, 0x26C30D04); return true; }
#endif
#ifdef OnPageFlipBackFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("PageFlipBackTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnPageFlipBackFinished, 0x74F534EE); return true; }
#endif
#ifdef OnPageFlipFrontFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("PageFlipFrontTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnPageFlipFrontFinished, 0x437D9EFE); return true; }
#endif
#ifdef OnZoomInFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("ZoomInTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnZoomInFinished, 0xFBEEA58F); return true; }
#endif
#ifdef OnZoomOutFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("ZoomOutTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnZoomOutFinished, 0xF84B3BD1); return true; }
#endif
#ifdef OnFadeAnimationFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("FadeTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnFadeAnimationFinished, 0xE9A6D56C); return true; }
#endif
#ifdef OnDualViewLeftTransitionFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("DualViewLeftTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnDualViewLeftTransitionFinished, 0x403A65A4); return true; }
#endif
#ifdef OnDualViewRightTransitionFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("DualViewRightTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnDualViewRightTransitionFinished, 0x50B4DCCA); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForTransitionIndMsg(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::Courier::TransitionIndMsg const & message = static_cast< ::Courier::TransitionIndMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_PhoneStateMachineImpl::VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
struct EventMapping
{
    ::FeatStd::UInt32 mHashId;
    bool (*mEventCallHandler)(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId);
};

struct EventDeductionMapping
{
    ::FeatStd::UInt32 mHashId;
    ::Cit::DeductResult::Enum (*mEventCallHandler)(AppHmi_PhoneStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId);
};

static ::FeatStd::Int EventMappingCmp(::FeatStd::UInt32 hash, const EventMapping& em)
{
    return (hash == em.mHashId) ? 0 : ((hash < em.mHashId) ? -1 : 1);
}

static ::FeatStd::Int EventDeductionMappingCmp(::FeatStd::UInt32 hash, const EventDeductionMapping& em)
{
    return (hash == em.mHashId) ? 0 : ((hash < em.mHashId) ? -1 : 1);
}

bool AppHmi_PhoneStateMachineImpl::HandleEventMapping(::Courier::Message const & message, ::FeatStd::UInt32& eventId) const
{
    static EventMapping events[79] = {
        { 0x04B8AFB9, HandleEventMappingForHKStatusChangedUpdMsg },
        { 0x08E31803, HandleEventMappingForClosePairingPopupsOnSpeedLockstatusMsg },
        { 0x08F14937, HandleEventMappingForMICOutCallPopupCloseResp },
        { 0x15B48B8E, HandleEventMappingForConnectedDeviceSelectedResp },
        { 0x18566658, HandleEventMappingForHomeAppStateResp },
        { 0x1AA2A7D9, HandleEventMappingForRejectCallOnMCPRejectBtnPress },
        { 0x20088505, HandleEventMappingForDeviceStatusResp },
        { 0x2325CA36, HandleEventMappingForShowPriorityCall_BT_Req },
        { 0x23C96CEE, HandleEventMappingForConnectionStatusResp },
        { 0x2BEE0D78, HandleEventMappingForSWCHookResp },
        { 0x2DEE9869, HandleEventMappingForDisconnectDeviceResp },
        { 0x30DA74DA, HandleEventMappingForIntercomIncomingCallHardKeyResp },
        { 0x33764D6C, HandleEventMappingForContactDetailsResp },
        { 0x3510645E, HandleEventMappingForBTVRStatusResp },
        { 0x3682914D, HandleEventMappingForSLCStatusResp },
        { 0x3824FE1D, HandleEventMappingForApplicationStateUpdMsg },
        { 0x38764B41, HandleEventMappingForActivateOnCallSceneMsg },
        { 0x3D0F1CDA, HandleEventMappingForPhnBkDownloadStateResp },
        { 0x4465EF1C, HandleEventMappingForMICIntercomCallResp },
        { 0x44BDA938, HandleEventMappingForSpiSessionMsg },
        { 0x46B4CF5E, HandleEventMappingForMICContactsCallHistoryResp },
        { 0x47F4FAE7, HandleEventMappingForMICIncCallPopupCloseResp },
        { 0x4A69141E, HandleEventMappingForHMISubStateChangedUpdMsg },
        { 0x4F695CEE, HandleEventMappingForCallStatusResp },
        { 0x4FF79763, HandleEventMappingForEncoderStatusChangedUpdMsg },
        { 0x569FCB0B, HandleEventMappingForCallListWindowResp },
        { 0x5D876854, HandleEventMappingForIntercomIncomingCallResp },
        { 0x5E81CC87, HandleEventMappingForApplicationSwitchInitiationStatus },
        { 0x617EB764, HandleEventMappingForAcceptCallMCP },
        { 0x633C0788, HandleEventMappingForActivateCallListLoadingMsg },
        { 0x63726DFC, HandleEventMappingForIntercomRTPStreamFailureResp },
        { 0x696FEA46, HandleEventMappingForSwitchToICallConnecting },
        { 0x69FAC6F1, HandleEventMappingForSubSurfaceUpdMsg },
        { 0x6AE0FD3C, HandleEventMappingForButtonReactionMsg },
        { 0x72CE0DF0, HandleEventMappingForPairingStatusResp },
        { 0x784B9EF4, HandleEventMappingForMICPhoneCallResp },
        { 0x78F67032, HandleEventMappingForActivateCallListMsg },
        { 0x7E461865, HandleEventMappingForSpeedLockstatusIndMsg },
        { 0x81C40499, HandleEventMappingForDeviceListFullResp },
        { 0x86579005, HandleEventMappingForOptionKeyResp },
        { 0x8D689F2D, HandleEventMappingForActivateOnMultipleCallSceneMsg },
        { 0x92F4B97F, HandleEventMappingForActivateContactListLoadingMsg },
        { 0x937285CC, HandleEventMappingForActivateOnIContactsSceneMsg },
        { 0x93A5580A, HandleEventMappingForActivityMsg },
        { 0x95C8A426, HandleEventMappingForActivateOnIntercomConfCallSceneMsg },
        { 0x95EBCD6F, HandleEventMappingForIncomingMessageListResp },
        { 0x98182C04, HandleEventMappingForActivateAddDeviceMsg },
        { 0x98944A72, HandleEventMappingForActivateDialPadMsg },
        { 0x9A9AC23C, HandleEventMappingForShowPriorityCall_Intercom_Req },
        { 0xA1D892FC, HandleEventMappingForSWCMuteResp },
        { 0xA336988A, HandleEventMappingForGenericCANBTVRReq },
        { 0xA3E55A03, HandleEventMappingForActivateCallConnectingSceneMsg },
        { 0xA60CB9F4, HandleEventMappingForShutdownMsg },
        { 0xA8FCC062, HandleEventMappingForPairingPinResp },
        { 0xA931E498, HandleEventMappingForMICActiveCallPopupCloseResp },
        { 0xAE3CAAA7, HandleEventMappingForExpiredPopupTimerResMsg },
        { 0xB2742515, HandleEventMappingForActivateOnContactCallMsg },
        { 0xB533099B, HandleEventMappingForBTServiceErrResp },
        { 0xB5819F4F, HandleEventMappingForActivateContactListMsg },
        { 0xB86E3010, HandleEventMappingForDeleteDeviceResp },
        { 0xBE7FE0ED, HandleEventMappingForSwitchToIConferenceCall },
        { 0xC1B2FF23, HandleEventMappingForActivateOnICallConnectingSceneMsg },
        { 0xC277DA2B, HandleEventMappingForActivateApplicationMsg },
        { 0xC5C8DD66, HandleEventMappingForClearEditFieldResp },
        { 0xC613E40C, HandleEventMappingForActivateImageProviderReqMsg },
        { 0xC7B455FB, HandleEventMappingForTransitionIndMsg },
        { 0xD01DA932, HandleEventMappingForMultipleCallStatusResp },
        { 0xD4AC7BDB, HandleEventMappingForActivationResMsg },
        { 0xD7EF1E4B, HandleEventMappingForAddNewDeviceResp },
        { 0xDAE968BA, HandleEventMappingForDeactivateApplicationMsg },
        { 0xE2F61D55, HandleEventMappingForSurfaceStateChangedUpdMsg },
        { 0xE36FD8F2, HandleEventMappingForECallStatusResp },
        { 0xE41170CF, HandleEventMappingForAcceptOutgoingIntercomCall },
        { 0xE6844213, HandleEventMappingForIncomingCallResp },
        { 0xEB055979, HandleEventMappingForIntercomCallEndStatus },
        { 0xF2600C39, HandleEventMappingForContactListWindowResp },
        { 0xF5658F3B, HandleEventMappingForActivateOnSettingSceneMsg },
        { 0xF8FE5962, HandleEventMappingForActivateOnIntercomCallSceneMsg },
        { 0xFCD31EF0, HandleEventMappingForCallListDownloadStateResp },
    };
    ::FeatStd::UInt32 hashId = message.GetId();
    const EventMapping* eventEntry = ::Courier::BinarySearch(hashId, events, 79, &EventMappingCmp);
    if (eventEntry && (hashId == eventEntry->mHashId)) {
        return eventEntry->mEventCallHandler(message, eventId);
    }
    return false;
}

// ------------------------------------------------------------------------
::Cit::DeductResult::Enum AppHmi_PhoneStateMachineImpl::DeductEvent(::Courier::Message const & aMessage, ::FeatStd::UInt32 eventId)
{
    ::Cit::DeductResult::Enum deductResult = Cit::DeductResult::DeductOk;
    static EventDeductionMapping events[79] = {
        { 0x04B8AFB9, HandleEventDeductionForHKStatusChangedUpdMsg },
        { 0x08E31803, HandleEventDeductionForClosePairingPopupsOnSpeedLockstatusMsg },
        { 0x08F14937, HandleEventDeductionForMICOutCallPopupCloseResp },
        { 0x15B48B8E, HandleEventDeductionForConnectedDeviceSelectedResp },
        { 0x18566658, HandleEventDeductionForHomeAppStateResp },
        { 0x1AA2A7D9, HandleEventDeductionForRejectCallOnMCPRejectBtnPress },
        { 0x20088505, HandleEventDeductionForDeviceStatusResp },
        { 0x2325CA36, HandleEventDeductionForShowPriorityCall_BT_Req },
        { 0x23C96CEE, HandleEventDeductionForConnectionStatusResp },
        { 0x2BEE0D78, HandleEventDeductionForSWCHookResp },
        { 0x2DEE9869, HandleEventDeductionForDisconnectDeviceResp },
        { 0x30DA74DA, HandleEventDeductionForIntercomIncomingCallHardKeyResp },
        { 0x33764D6C, HandleEventDeductionForContactDetailsResp },
        { 0x3510645E, HandleEventDeductionForBTVRStatusResp },
        { 0x3682914D, HandleEventDeductionForSLCStatusResp },
        { 0x3824FE1D, HandleEventDeductionForApplicationStateUpdMsg },
        { 0x38764B41, HandleEventDeductionForActivateOnCallSceneMsg },
        { 0x3D0F1CDA, HandleEventDeductionForPhnBkDownloadStateResp },
        { 0x4465EF1C, HandleEventDeductionForMICIntercomCallResp },
        { 0x44BDA938, HandleEventDeductionForSpiSessionMsg },
        { 0x46B4CF5E, HandleEventDeductionForMICContactsCallHistoryResp },
        { 0x47F4FAE7, HandleEventDeductionForMICIncCallPopupCloseResp },
        { 0x4A69141E, HandleEventDeductionForHMISubStateChangedUpdMsg },
        { 0x4F695CEE, HandleEventDeductionForCallStatusResp },
        { 0x4FF79763, HandleEventDeductionForEncoderStatusChangedUpdMsg },
        { 0x569FCB0B, HandleEventDeductionForCallListWindowResp },
        { 0x5D876854, HandleEventDeductionForIntercomIncomingCallResp },
        { 0x5E81CC87, HandleEventDeductionForApplicationSwitchInitiationStatus },
        { 0x617EB764, HandleEventDeductionForAcceptCallMCP },
        { 0x633C0788, HandleEventDeductionForActivateCallListLoadingMsg },
        { 0x63726DFC, HandleEventDeductionForIntercomRTPStreamFailureResp },
        { 0x696FEA46, HandleEventDeductionForSwitchToICallConnecting },
        { 0x69FAC6F1, HandleEventDeductionForSubSurfaceUpdMsg },
        { 0x6AE0FD3C, HandleEventDeductionForButtonReactionMsg },
        { 0x72CE0DF0, HandleEventDeductionForPairingStatusResp },
        { 0x784B9EF4, HandleEventDeductionForMICPhoneCallResp },
        { 0x78F67032, HandleEventDeductionForActivateCallListMsg },
        { 0x7E461865, HandleEventDeductionForSpeedLockstatusIndMsg },
        { 0x81C40499, HandleEventDeductionForDeviceListFullResp },
        { 0x86579005, HandleEventDeductionForOptionKeyResp },
        { 0x8D689F2D, HandleEventDeductionForActivateOnMultipleCallSceneMsg },
        { 0x92F4B97F, HandleEventDeductionForActivateContactListLoadingMsg },
        { 0x937285CC, HandleEventDeductionForActivateOnIContactsSceneMsg },
        { 0x93A5580A, HandleEventDeductionForActivityMsg },
        { 0x95C8A426, HandleEventDeductionForActivateOnIntercomConfCallSceneMsg },
        { 0x95EBCD6F, HandleEventDeductionForIncomingMessageListResp },
        { 0x98182C04, HandleEventDeductionForActivateAddDeviceMsg },
        { 0x98944A72, HandleEventDeductionForActivateDialPadMsg },
        { 0x9A9AC23C, HandleEventDeductionForShowPriorityCall_Intercom_Req },
        { 0xA1D892FC, HandleEventDeductionForSWCMuteResp },
        { 0xA336988A, HandleEventDeductionForGenericCANBTVRReq },
        { 0xA3E55A03, HandleEventDeductionForActivateCallConnectingSceneMsg },
        { 0xA60CB9F4, HandleEventDeductionForShutdownMsg },
        { 0xA8FCC062, HandleEventDeductionForPairingPinResp },
        { 0xA931E498, HandleEventDeductionForMICActiveCallPopupCloseResp },
        { 0xAE3CAAA7, HandleEventDeductionForExpiredPopupTimerResMsg },
        { 0xB2742515, HandleEventDeductionForActivateOnContactCallMsg },
        { 0xB533099B, HandleEventDeductionForBTServiceErrResp },
        { 0xB5819F4F, HandleEventDeductionForActivateContactListMsg },
        { 0xB86E3010, HandleEventDeductionForDeleteDeviceResp },
        { 0xBE7FE0ED, HandleEventDeductionForSwitchToIConferenceCall },
        { 0xC1B2FF23, HandleEventDeductionForActivateOnICallConnectingSceneMsg },
        { 0xC277DA2B, HandleEventDeductionForActivateApplicationMsg },
        { 0xC5C8DD66, HandleEventDeductionForClearEditFieldResp },
        { 0xC613E40C, HandleEventDeductionForActivateImageProviderReqMsg },
        { 0xC7B455FB, HandleEventDeductionForTransitionIndMsg },
        { 0xD01DA932, HandleEventDeductionForMultipleCallStatusResp },
        { 0xD4AC7BDB, HandleEventDeductionForActivationResMsg },
        { 0xD7EF1E4B, HandleEventDeductionForAddNewDeviceResp },
        { 0xDAE968BA, HandleEventDeductionForDeactivateApplicationMsg },
        { 0xE2F61D55, HandleEventDeductionForSurfaceStateChangedUpdMsg },
        { 0xE36FD8F2, HandleEventDeductionForECallStatusResp },
        { 0xE41170CF, HandleEventDeductionForAcceptOutgoingIntercomCall },
        { 0xE6844213, HandleEventDeductionForIncomingCallResp },
        { 0xEB055979, HandleEventDeductionForIntercomCallEndStatus },
        { 0xF2600C39, HandleEventDeductionForContactListWindowResp },
        { 0xF5658F3B, HandleEventDeductionForActivateOnSettingSceneMsg },
        { 0xF8FE5962, HandleEventDeductionForActivateOnIntercomCallSceneMsg },
        { 0xFCD31EF0, HandleEventDeductionForCallListDownloadStateResp },
    };
    ::FeatStd::UInt32 hashId = aMessage.GetId();
    const EventDeductionMapping* eventEntry = ::Courier::BinarySearch(hashId, events, 79, &EventDeductionMappingCmp);
    if (eventEntry && (hashId == eventEntry->mHashId)) {
        deductResult = eventEntry->mEventCallHandler(this, aMessage, eventId);
    }
    else {
        typedef Cit::Internal::VSDeductHelper<VS_Ret_Ok, AppHmi_PhoneStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
        return VSDeductHelper::ProcessOutput(*this, (*this.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
        return VSDeductHelper::ProcessOutput(*this, (*this.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
    }
    return deductResult;
}

// ------------------------------------------------------------------------
bool AppHmi_PhoneStateMachineImpl::HandleDataBindingEventMapping(::Courier::AbstractDataItemMsg const & /* message */, ::FeatStd::UInt32 & /* eventId */) const
{
    return false;
}

#ifdef CIT_SIMULATION
struct EventNameMapping
{
    ::FeatStd::UInt32 mEventId;
    const ::FeatStd::Char* mEventName;
    void (*mGetEventArguments)(::Courier::Message const & message, Json::Value& eventArguments);
};

static ::FeatStd::Int EventNameMappingCmp(::FeatStd::UInt32 eventId, const EventNameMapping& em)
{
    return (eventId == em.mEventId) ? 0 : ((eventId < em.mEventId) ? -1 : 1);
}

static void GetEventArgumentsForonCenterPopupSurfaceVisible(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonTopPopupSurfaceInvisible(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForOnIncomingCallResp_BTPHN_EN_INIDLE(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::IncomingCallResp const & message = static_cast< ::IncomingCallResp const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::Int)message.GetDeviceType();
}

static void GetEventArgumentsForonSubSurfaceUpdMsgChanged_BACKGROUND(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SubSurfaceUpdMsg const & message = static_cast< ::SubSurfaceUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::Int)message.GetDisplayRegion();
    eventArguments[(::Json::Value::UInt)1] = (::Json::Value::UInt)message.GetDisplayID();
}

static void GetEventArgumentsForonEncoderStatusChanged_RIGHT_ENC(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::EncoderStatusChangedUpdMsg const & message = static_cast< ::EncoderStatusChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::Int)message.GetEncSteps();
}

static void GetEventArgumentsForonTopPopupSurfaceUnqueued(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonTopPopupSurfaceVisible(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonCenterPopupSurfaceInvisible(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonSubSurfaceUpdMsgChanged_FOREGROUND(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SubSurfaceUpdMsg const & message = static_cast< ::SubSurfaceUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::Int)message.GetDisplayRegion();
    eventArguments[(::Json::Value::UInt)1] = (::Json::Value::UInt)message.GetDisplayID();
}

static void GetEventArgumentsForonDeactivateImageProviderRequest(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::hmibase::gadget::ActivateImageProviderReqMsg const & message = static_cast< ::hmibase::gadget::ActivateImageProviderReqMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetInstanceId();
}

static void GetEventArgumentsForonCenterPopupSurfaceUnqueued(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonTopPopupSurfaceQueued(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonPopupVisible(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonPopupQueued(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonPopupUnqueued(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForOnIncomingCallResp_BTPHN_EN_INRINGING(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::IncomingCallResp const & message = static_cast< ::IncomingCallResp const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::Int)message.GetDeviceType();
}

static void GetEventArgumentsForonActivateImageProviderRequest(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::hmibase::gadget::ActivateImageProviderReqMsg const & message = static_cast< ::hmibase::gadget::ActivateImageProviderReqMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetInstanceId();
}

static void GetEventArgumentsForonPopupTimerExpiry(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::ExpiredPopupTimerResMsg const & message = static_cast< ::ExpiredPopupTimerResMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId();
}

static void GetEventArgumentsForonCenterPopupSurfaceQueued(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

const ::FeatStd::Char* AppHmi_PhoneStateMachineImpl::GetEventName(::FeatStd::UInt32 eventId, ::Courier::Message const & message, Json::Value& eventArguments)
{
    static EventNameMapping events[294] = {
        { 0x00971FAF, "Multiparty_FirstCall_Dialing", 0 },
        { 0x0107147B, "PhoneBook_Download_InProgress", 0 },
        { 0x021D41B4, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_DialPad_Layer_TouchArea_Phone_ButtonWidget_enRelease", 0 },
        { 0x027A3929, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Contacts_Loading_Layer_HeaderPhone_ButtonWidget2D_SPI_enRelease", 0 },
        { 0x04397934, "OnBTServiceErrResp_BTPHN_EN_BT_CONNECTIONFAILED", 0 },
        { 0x063AB855, "OnButtonReactionMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_SMSExpand_Layer_Readaloud_ButtonWidget_enRelease", 0 },
        { 0x06B4F341, "PriorityCallPopup_Intercom_Req", 0 },
        { 0x06F20A53, "ActivateOnSettingScene", 0 },
        { 0x06F7F237, "OnButtonReactionMsg_AppHmi_PhoneModule_Gadget_Phone_MASTER__GADGET_PHONE_NON_NAVI_TouchArea_PhoneBtn_ButtonWidget_enRelease", 0 },
        { 0x0A2FE341, "OnActivationResMsg_AppHmi_PhoneModule_App_Popup_Pfo_DeviceListFull_1", 0 },
        { 0x0A5CF04C, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Contacts_Call_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0x0B21F17A, "OnCallStatusResp_BTPHN_EN_IDLE", 0 },
        { 0x0D0F5602, "onHMISubStateChanged_STANDBY", 0 },
        { 0x0F7A9F4D, "Multiparty_1_Active_2_Active", 0 },
        { 0x0FEC8911, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_CallList_Layer_TabDialpad_ButtonWidget_enRelease", 0 },
        { 0x1106503B, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_OPT_Layer_Checkbox_UsePhoneRingtone_ButtonWidget2D_enRelease", 0 },
        { 0x129F3D6F, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Contacts_Layer_HeaderPhone_ButtonWidget2D_Listen_enRelease", 0 },
        { 0x12DBED30, "OnPairingStatusResp_BTPHN_EN_PAIRING_STATUS_TIMEOUT", 0 },
        { 0x157286E4, "OnApplicationSwitchInitiationStatus", 0 },
        { 0x17F6BE09, "PhoneBook_Download_Error", 0 },
        { 0x1898D4DF, "OnButtonReactionMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_Intercom_IncomingCall_Layer_TouchArea_HangUp_ButtonWidget_enRelease", 0 },
        { 0x18C67501, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_MultipleCall_DialPad_Layer_SpellerExpander_ButtonWidget_enRelease", 0 },
        { 0x1992CF4B, "OnButtonReactionMsg_AppHmi_PhoneModule_Gadget_Phone_MASTER__GADGET_PHONE_Smart_TouchArea_PhoneBtn_ButtonWidget_enRelease", 0 },
        { 0x1A0C543A, "Multiparty_1_Hold_2_Hold", 0 },
        { 0x1B2A21D3, "PhoneBook_Download_Not_Started", 0 },
        { 0x1EFA5FBF, "ActivateCallConnectingScene", 0 },
        { 0x1F37A1A2, "OnButtonReactionMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_SMSExpand_Layer_TouchArea_Call_ButtonWidget_enRelease", 0 },
        { 0x1F600E3E, "Multiparty_SecondCall_Dialing", 0 },
        { 0x1FB4F8F8, "OnActivationResMsg_AppHmi_PhoneModule_App_Popup_Pfo_JustWorksPairingWaiting_1", 0 },
        { 0x1FC84BE0, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_CallList_Layer_HeaderPhone_ButtonWidget2D_SPI_enRelease", 0 },
        { 0x2170A1DE, "OnSwitchToIConferenceCall", 0 },
        { 0x21A485EC, "OnCallListDownloadStateResp_BTPHN_EN_RCDS_NOT_STARTED", 0 },
        { 0x21EA5442, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_PhoneSelection_Layer_TouchArea_Phone_ButtonWidget_enRelease", 0 },
        { 0x21EA9E63, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_CallList_Loading_Layer_TabDialpad_ButtonWidget_enRelease", 0 },
        { 0x21F54113, "Pfo_MICIncCallPopupCloseResp", 0 },
        { 0x23B97E51, "onCenterPopupSurfaceVisible", GetEventArgumentsForonCenterPopupSurfaceVisible },
        { 0x252BB334, "OnButtonReactionMsg_AppHmi_PhoneModule_App_Popup_Pfo_DeleteDeviceConfirmation_Layer_Yes_ButtonWidget_enRelease", 0 },
        { 0x25419F23, "OnHomeAppStateResp_0", 0 },
        { 0x255A6126, "OnCallStatusResp_BTPHN_EN_DIALING", 0 },
        { 0x263EAF7F, "onHKStatusChanged_HK_SELECT_UP", 0 },
        { 0x26C30D04, "OnPreviousLevelTransitionFinished", 0 },
        { 0x272B042F, "OnActivationResMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_MIC_IntercomCall_1", 0 },
        { 0x293BAACB, "OnCallStatusResp_BTPHN_EN_ACTIVE", 0 },
        { 0x2952978C, "OnDeviceStatusResp_BTPHN_EN_DEVICE_CONNECTED", 0 },
        { 0x2C433518, "Multiparty_FirstCall_Ringing", 0 },
        { 0x2DAEA0B7, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_MultipleCall_Layer_TouchArea_HangUp_ButtonWidget_enRelease", 0 },
        { 0x2EA8666C, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Call_Layer_Icon_Handset_ButtonWidget2D_enRelease", 0 },
        { 0x2F0C4274, "ActivateOnIntercomCallScene", 0 },
        { 0x2FCE97E1, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Contacts_Loading_Layer_HeaderPhone_ButtonWidget2D_Media_enRelease", 0 },
        { 0x303718F1, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Call_Connecting_Layer_TouchArea_HangUp_ButtonWidget_enRelease", 0 },
        { 0x312735D0, "Activate_Device_List", 0 },
        { 0x313C2D85, "OnPairingPinResp", 0 },
        { 0x33806006, "OnActivationResMsg_AppHmi_PhoneModule_App_Popup_Pfo_DeviceConnecting_1", 0 },
        { 0x33C8F767, "OnConnectionStatusResp_0", 0 },
        { 0x344D1AD8, "Multiparty_1_Active_2_Hold", 0 },
        { 0x3598CF84, "onTopPopupSurfaceInvisible", GetEventArgumentsForonTopPopupSurfaceInvisible },
        { 0x37E7CAFB, "OnDeactivateApplicationMsg", 0 },
        { 0x3AC09AAF, "Pfo_MICContactsCallHistoryResp", 0 },
        { 0x3ADED12D, "TogglePhoneHandle_NonNavi", 0 },
        { 0x3B45E4A9, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_SR_SIRI_Main_Layer_SRSRBTSpeechRecStart_ButtonWidget_enRelease", 0 },
        { 0x3B718C13, "OnIntercomCallEndStatus", 0 },
        { 0x3F99E34E, "Activate_Contact_List", 0 },
        { 0x3F9C1B2B, "OnButtonReactionMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_PriorityCall_Intercom_Layer_Yes_ButtonWidget_enRelease", 0 },
        { 0x403A65A4, "OnDualViewLeftTransitionFinished", 0 },
        { 0x403C310A, "OnButtonReactionMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_SMS_Layer_TouchArea_Close_ButtonWidget_enRelease", 0 },
        { 0x4043813E, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Contacts_Loading_Layer_HeaderPhone_ButtonWidget2D_Radio_enRelease", 0 },
        { 0x405583C6, "OnAddNewDeviceResp_BTPHN_EN_PAIRING_TYPE_LEGACY", 0 },
        { 0x40B09F90, "OnButtonReactionMsg_AppHmi_PhoneModule_App_Popup_Pfo_DeviceDisconnectConfirmation_Layer_No_ButtonWidget_enRelease", 0 },
        { 0x414A14B7, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Intercom_ConferenceCall_Layer_TouchArea_Call_ButtonWidget_enRelease", 0 },
        { 0x4192A43E, "OnIncomingCallResp_BTPHN_EN_INIDLE", GetEventArgumentsForOnIncomingCallResp_BTPHN_EN_INIDLE },
        { 0x437D9EFE, "OnPageFlipFrontFinished", 0 },
        { 0x43DED828, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_IntercomCall_Layer_TouchArea_HangUp_ButtonWidget_enRelease", 0 },
        { 0x43E5379D, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Call_DialPad_Layer_TouchArea_HangUp_ButtonWidget_enRelease", 0 },
        { 0x4638EED6, "OnPairingStatusResp_BTPHN_EN_PAIRING_STATUS_UNSUCCESSFUL", 0 },
        { 0x46684A77, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Contacts_Loading_Layer_HeaderPhone_ButtonWidget2D_Navi_enRelease", 0 },
        { 0x475B590E, "ActivateOnIContactsScene", 0 },
        { 0x47E33294, "OnCallListDownloadStateResp_BTPHN_EN_RCDS_ERROR", 0 },
        { 0x490D9B02, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Contacts_Layer_TabCalls_ButtonWidget_enRelease", 0 },
        { 0x49877438, "OnBTVRStatusResp_true", 0 },
        { 0x4BE2B8D7, "OnButtonReactionMsg_AppHmi_PhoneModule_Gadget_Phone_MASTER__GADGET_PHONE_TouchArea_PhoneBtn_ButtonWidget_enRelease", 0 },
        { 0x4C8518AE, "onAppStatusPrepare_BACKGROUND", 0 },
        { 0x4CC2E06E, "EvRejectCallOnMCPRejectBtn", 0 },
        { 0x4CE98F70, "OnIntercomIncomingCallHardKeyResp", 0 },
        { 0x4D3D22EA, "OnSWCHookResp_BTPHN_EN_OFFHOOK_ACTIVATE", 0 },
        { 0x4E6FD7E8, "Activate_On_Multiparty_Call", 0 },
        { 0x4EE9D53B, "ActivateContactScene", 0 },
        { 0x4F088DE5, "OnCallListWindowResp", 0 },
        { 0x4F41E729, "OnCallStatusResp_BTPHN_EN_DISCONNECTING", 0 },
        { 0x4FBC1718, "OnAddNewDeviceResp_BTPHN_EN_PAIRING_TYPE_SSP_NUMERIC_COMPARISON", 0 },
        { 0x50B4DCCA, "OnDualViewRightTransitionFinished", 0 },
        { 0x5106AC87, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_MultipleCall_DialPad_Layer_TouchArea_HangUp_ButtonWidget_enRelease", 0 },
        { 0x517C7E7E, "ActivateContactListLoadingScene", 0 },
        { 0x518AC750, "OnClearEditFieldResp", 0 },
        { 0x529C9034, "OnPairingStatusResp_BTPHN_EN_PAIRING_STATUS_SUCCESSFUL", 0 },
        { 0x52F27A84, "OnHomeAppStateResp_1", 0 },
        { 0x53FEEF3D, "OnContactListWindowResp", 0 },
        { 0x541100D0, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_DialPad_Layer_Call_ButtonWidget_enRelease", 0 },
        { 0x546421CB, "ActivateCallListLoadingScene", 0 },
        { 0x54D2E537, "ActivateOnICallConnectingScene", 0 },
        { 0x54F1B1AA, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Contacts_Layer_TouchArea_Phone_ButtonWidget_enRelease", 0 },
        { 0x557167BF, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_CallList_Loading_Layer_HeaderPhone_ButtonWidget2D_SPI_enRelease", 0 },
        { 0x56EC22D6, "Activate_On_IntercomCall", 0 },
        { 0x5790D8C1, "onSubSurfaceUpdMsgChanged_BACKGROUND", GetEventArgumentsForonSubSurfaceUpdMsgChanged_BACKGROUND },
        { 0x57F1533A, "Activate_On_Call", 0 },
        { 0x57FE6183, "Trigger_GenericCANBTVRReq", 0 },
        { 0x58E330E4, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Contacts_Layer_HeaderPhone_ButtonWidget2D_SPI_enRelease", 0 },
        { 0x59FA971D, "OnButtonReactionMsg_AppHmi_PhoneModule_App_Popup_Pfo_DeleteDeviceConfirmation_Layer_No_ButtonWidget_enRelease", 0 },
        { 0x5A18CEB8, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Contacts_Loading_Layer_TouchArea_Phone_ButtonWidget_enRelease", 0 },
        { 0x5CE63CA9, "OnButtonReactionMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_SMS_Layer_TouchArea_Call_ButtonWidget_enRelease", 0 },
        { 0x5D063F95, "ActivateDialPadScene", 0 },
        { 0x5D48B341, "OnActivationResMsg_AppHmi_PhoneModule_App_Popup_Pfo_DeviceDeleted_1", 0 },
        { 0x5D685E55, "OnButtonReactionMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_IncomingCall_Layer_TouchArea_Call_ButtonWidget_enRelease", 0 },
        { 0x5E101645, "OnActivationResMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_PhonebookDLFailed_1", 0 },
        { 0x5E14F00D, "OnButtonReactionMsg_AppHmi_PhoneModule_App_Popup_Pfo_JustWorksPairing_Layer_Yes_ButtonWidget_enRelease", 0 },
        { 0x5E204A52, "ReqPhoneContentContextSwitch", 0 },
        { 0x5EB92C68, "Pfo_MICPhoneCallResp", 0 },
        { 0x5F065AAF, "Activate_Call_Connecting", 0 },
        { 0x5FB1A184, "Activate_History", 0 },
        { 0x5FC96725, "OnActivationResMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_PhonebookDLIncomplete_1", 0 },
        { 0x60AD01EA, "OnButtonReactionMsg_AppHmi_PhoneModule_App_Popup_Pfo_NumCompPairing_Layer_Yes_ButtonWidget_enRelease", 0 },
        { 0x60E616BC, "OnActivationResMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_IncomingCall_1", 0 },
        { 0x6126C9E5, "OnButtonReactionMsg_AppHmi_PhoneModule_App_Popup_Pfo_JustWorksPairing_Layer_No_ButtonWidget_enRelease", 0 },
        { 0x617C683D, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_I_Call_Connecting_Layer_TouchArea_HangUp_ButtonWidget_enRelease", 0 },
        { 0x6291A012, "OnButtonReactionMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_SMSExpand_Layer_TouchArea_Close_ButtonWidget_enRelease", 0 },
        { 0x633B5EFC, "OnDeleteDeviceResp", 0 },
        { 0x634D3BF9, "Pfo_MICIntercomCallResp", 0 },
        { 0x63C4EEF1, "ActivateCallMCP", 0 },
        { 0x670E4823, "ActivateOnMultipleCallScene", 0 },
        { 0x67E5D82B, "onEncoderStatusChanged_RIGHT_ENC", GetEventArgumentsForonEncoderStatusChanged_RIGHT_ENC },
        { 0x68B7EC7B, "OnActivationResMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_SMS_1", 0 },
        { 0x69DE1080, "OnActivationResMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_MIC_PhoneCall_1", 0 },
        { 0x6A9BE50C, "OnConnectionStatusResp_1", 0 },
        { 0x6B23A352, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Contacts_Loading_Layer_TabCalls_ButtonWidget_enRelease", 0 },
        { 0x6BC6C7C8, "OnButtonReactionMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_PhonebookDLIncomplete_Layer_OK_ButtonWidget_enRelease", 0 },
        { 0x6BF7C777, "OnActivationResMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_DeviceDisConnected_1", 0 },
        { 0x6D02E92A, "OnActivationResMsg_AppHmi_PhoneModule_App_Popup_Pfo_DeviceDeleting_1", 0 },
        { 0x6D1B3A68, "onAppStatusChanged_BACKGROUND", 0 },
        { 0x6FADB707, "OnActivationResMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_SMSExpand_1", 0 },
        { 0x704DBE19, "OnContactDetailsResp", 0 },
        { 0x70C03DA6, "OnButtonReactionMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_PassiveDeviceIncomingCall_Layer_TouchArea_Call_ButtonWidget_enRelease", 0 },
        { 0x7164B377, "Multiparty_1_Hold_2_Active", 0 },
        { 0x71D394B6, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_PhoneSelection_OPT_SET_ButtonWidget_enRelease", 0 },
        { 0x72027194, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_IntercomCall_Layer_TouchArea_Call_ButtonWidget_enRelease", 0 },
        { 0x73812164, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Contacts_Layer_HeaderPhone_ButtonWidget2D_PhoneName_enRelease", 0 },
        { 0x73D232EF, "OnAcceptOutgoingIntercomCall", 0 },
        { 0x74976DFC, "PhoneBook_Download_Complete", 0 },
        { 0x74F534EE, "OnPageFlipBackFinished", 0 },
        { 0x756C0DF3, "OnShutdownMsg", 0 },
        { 0x76CF2B88, "onHMISubStateChanged_ON", 0 },
        { 0x776D7D8A, "onHMISubStateChanged_OFF", 0 },
        { 0x7A40C425, "OnPairingStatusResp_BTPHN_EN_PAIRING_STATUS_AUTHENTICATIONFAILURE", 0 },
        { 0x7C88FFB5, "OnActivationResMsg_AppHmi_PhoneModule_App_Popup_Pfo_JustWorksPairing_1", 0 },
        { 0x7C8C0F37, "OnButtonReactionMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_IncomingCall_Layer_TouchArea_HangUp_ButtonWidget_enRelease", 0 },
        { 0x7C9A52BF, "OnActivationResMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_ConnectionFailed_1", 0 },
        { 0x7DC1044D, "Pfo_MICActiveCallPopupCloseResp", 0 },
        { 0x7E1D5174, "OnCallListDownloadStateResp_BTPHN_EN_RCDS_COMPLETE", 0 },
        { 0x7E2C01C4, "OnActivationResMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_MIC_CallHistory_Contacts_1", 0 },
        { 0x807245E1, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_DialPad_Layer_TabCalls_ButtonWidget_enRelease", 0 },
        { 0x82ABC1C3, "OnIncomingMessageListResp", 0 },
        { 0x8448D561, "OnSLCStatusResp_0", 0 },
        { 0x86E99036, "OnDeviceStatusResp_BTPHN_EN_DEVICE_CONNECTED_OSD", 0 },
        { 0x87281151, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_CallList_Loading_Layer_HeaderPhone_ButtonWidget2D_Media_enRelease", 0 },
        { 0x881BFD51, "OnButtonReactionMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_SMS_Layer_Read_ButtonWidget_enRelease", 0 },
        { 0x884EA3AC, "OnCallStatusResp_BTPHN_EN_RINGTONE", 0 },
        { 0x88C22161, "OnBTServiceErrResp_BTPHN_EN_BT_ADDNEWDEVICE", 0 },
        { 0x89C61E06, "ActivateOnCallScene", 0 },
        { 0x8F456BA8, "OnActivationResMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_PriorityCall_Intercom_1", 0 },
        { 0x8F530E70, "OnCallListDownloadStateResp_BTPHN_EN_RCDS_IN_PROCESS", 0 },
        { 0x8FB4D5EB, "OnCallStatusResp_BTPHN_EN_ON_HOLD", 0 },
        { 0x90936AF2, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_CallList_Loading_Layer_HeaderPhone_ButtonWidget2D_Radio_enRelease", 0 },
        { 0x912024BE, "onTopPopupSurfaceUnqueued", GetEventArgumentsForonTopPopupSurfaceUnqueued },
        { 0x92993AAA, "OnBTServiceErrResp_BTPHN_EN_BT_CHANGEDEVICESTATE", 0 },
        { 0x943FE71D, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Contacts_Layer_TabDialpad_ButtonWidget_enRelease", 0 },
        { 0x94D9AE54, "OnActivationResMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_DeviceConnected_1", 0 },
        { 0x957D1215, "OnButtonReactionMsg_AppHmi_PhoneModule_App_Popup_Pfo_DeviceListFull_Layer_OK_ButtonWidget_enRelease", 0 },
        { 0x95866363, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_DialPad_Layer_HeaderPhone_ButtonWidget2D_Radio_enRelease", 0 },
        { 0x95DF677C, "OnActivationResMsg_AppHmi_PhoneModule_Sys_Popup_SR_SIRI_Main_1", 0 },
        { 0x96036A38, "OnPairingStatusResp_BTPHN_EN_PAIRING_STATUS_CONNECTIONLOST", 0 },
        { 0x967D2656, "OnActivationResMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_PriorityCall_BT_1", 0 },
        { 0x97D49257, "PriorityCallPopup_BT_Req", 0 },
        { 0x984F8ED8, "onTopPopupSurfaceVisible", GetEventArgumentsForonTopPopupSurfaceVisible },
        { 0x98BD981F, "OnSpeedLockstatusIndMsg", 0 },
        { 0x992F07B2, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Contacts_Loading_Layer_HeaderPhone_ButtonWidget_enRelease", 0 },
        { 0x9B30BCAC, "Multiparty_Conference", 0 },
        { 0x9B76BC60, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Contacts_Loading_Layer_HeaderPhone_ButtonWidget2D_Listen_enRelease", 0 },
        { 0x9BDB722F, "onCenterPopupSurfaceInvisible", GetEventArgumentsForonCenterPopupSurfaceInvisible },
        { 0x9C0A110F, "ActivateOnIntercomConfCallScene", 0 },
        { 0x9D4DF4FC, "onSubSurfaceUpdMsgChanged_FOREGROUND", GetEventArgumentsForonSubSurfaceUpdMsgChanged_FOREGROUND },
        { 0x9FD51F5C, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_OPT_SETTINGS_Layer_UsePhoneRingtone_1_ButtonWidget2D_enRelease", 0 },
        { 0x9FE98C1E, "onDeactivateImageProviderRequest", GetEventArgumentsForonDeactivateImageProviderRequest },
        { 0xA15C3CEE, "onHMISubStateChanged_STANDBY_RESTRICTED", 0 },
        { 0xA22E3193, "ActivateOnContactCallScene", 0 },
        { 0xA2344E29, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Call_Layer_TouchArea_HangUp_ButtonWidget_enRelease", 0 },
        { 0xA2BA16D2, "OnSpiSessionMsg", 0 },
        { 0xA33E059B, "OnButtonReactionMsg_AppHmi_PhoneModule_App_Popup_Pfo_NumCompPairing_Layer_No_ButtonWidget_enRelease", 0 },
        { 0xA5772E78, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_SR_SIRI_Main_Layer_SRSRBTSpeechRecExit_ButtonWidget_enRelease", 0 },
        { 0xA5A028CE, "ReqPhoneContentContextSwitch_NonNavi", 0 },
        { 0xA71E95AC, "Activate_Call_List", 0 },
        { 0xA755043C, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_CallList_Layer_HeaderPhone_ButtonWidget2D_Listen_enRelease", 0 },
        { 0xA7CD1B80, "OnActivationResMsg_AppHmi_PhoneModule_App_Popup_Pfo_PairingInitiate_1", 0 },
        { 0xA851CE0D, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_DialPad_Layer_HeaderPhone_ButtonWidget2D_Listen_enRelease", 0 },
        { 0xAA79C7DD, "onCenterPopupSurfaceUnqueued", GetEventArgumentsForonCenterPopupSurfaceUnqueued },
        { 0xAB89D7A8, "onHMISubStateChanged_SECURE", 0 },
        { 0xADDB3CB8, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Contacts_Layer_HeaderPhone_ButtonWidget2D_Media_enRelease", 0 },
        { 0xAF540B1E, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_PhoneSelection_Layer_AddPhone_ButtonWidget_enRelease", 0 },
        { 0xAFE3F29D, "OnButtonReactionMsg_AppHmi_PhoneModule_App_Popup_Pfo_PairingInitiate_Layer_Cancel_ButtonWidget_enRelease", 0 },
        { 0xB0EA418D, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_OPT_Layer_Checkbox_ShowSMS_ButtonWidget2D_enRelease", 0 },
        { 0xB2B3C41C, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Contacts_opt_se_ButtonWidget_enRelease", 0 },
        { 0xB320790B, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_CallList_Layer_HeaderPhone_ButtonWidget2D_Media_enRelease", 0 },
        { 0xB348A4F9, "ActivateAddDeviceScene", 0 },
        { 0xB3DF12E7, "OnECallStatusResp_1", 0 },
        { 0xB5E9C039, "ActivateCallListScene", 0 },
        { 0xB630DDBD, "onTopPopupSurfaceQueued", GetEventArgumentsForonTopPopupSurfaceQueued },
        { 0xB653159C, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_DialPad_Layer_HeaderPhone_ButtonWidget2D_SPI_enRelease", 0 },
        { 0xB70B86AA, "OnOptionKeyResp", 0 },
        { 0xB7452695, "OnSwitchToICallConnecting", 0 },
        { 0xB78D7AE0, "onPopupVisible", GetEventArgumentsForonPopupVisible },
        { 0xB81D78C8, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_DialPad_Layer_TabContacts_ButtonWidget_enRelease", 0 },
        { 0xBBE6896C, "onPopupQueued", GetEventArgumentsForonPopupQueued },
        { 0xBE2D5DEE, "OnConnectedDeviceSelectedResp_BTPHN_C_VALUE_ONE", 0 },
        { 0xBE7D1CB2, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Intercom_ConferenceCall_Layer_TouchArea_HangUp_ButtonWidget_enRelease", 0 },
        { 0xC20764E5, "OnAddNewDeviceResp_BTPHN_EN_PAIRING_TYPE_SSP_JUST_WORKS", 0 },
        { 0xC36EB8DF, "OnButtonReactionMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_Intercom_IncomingCall_Layer_TouchArea_Call_ButtonWidget_enRelease", 0 },
        { 0xC44B109F, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Contacts_Layer_HeaderPhone_ButtonWidget2D_Radio_enRelease", 0 },
        { 0xC5458961, "ClosePairingPopupsOnSpeedLockstatus", 0 },
        { 0xC70281BB, "OnActivateApplicationMsg", 0 },
        { 0xC8A66858, "OnSWCHookResp_BTPHN_EN_ONHOOK_TERMINATE", 0 },
        { 0xC8D83B8B, "onHMISubStateChanged_PHONE", 0 },
        { 0xCB7A2ED5, "OnActivationResMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_Intercom_RTP_stream_failure_1", 0 },
        { 0xCE5219D5, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_CallList_Loading_Layer_HeaderPhone_ButtonWidget2D_Navi_enRelease", 0 },
        { 0xCEEB9813, "OnDeviceListFullResp", 0 },
        { 0xCF94F7EF, "OnButtonReactionMsg_AppHmi_PhoneModule_Sys_Popup_SR_SIRI_Main_Layer_SRSRBTSpeechRecStart_ButtonWidget_enRelease", 0 },
        { 0xD0640E45, "OnIntercomRTPStreamFailureResp", 0 },
        { 0xD155618D, "OnIntercomIncomingCallResp", 0 },
        { 0xD683DF01, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_DialPad_Layer_HeaderPhone_ButtonWidget2D_Navi_enRelease", 0 },
        { 0xD69CD058, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_CallList_Layer_HeaderPhone_ButtonWidget2D_Navi_enRelease", 0 },
        { 0xD7150BC1, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_CallList_Loading_Layer_HeaderPhone_ButtonWidget2D_Listen_enRelease", 0 },
        { 0xD8354CB8, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_CallList_Layer_TabContacts_ButtonWidget_enRelease", 0 },
        { 0xD839F7AA, "OnActivationResMsg_AppHmi_PhoneModule_App_Popup_Pfo_DeleteDeviceConfirmation_1", 0 },
        { 0xD8AF90ED, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_OPT_SETTINGS_Button_Back_icon_ButtonWidget_enRelease", 0 },
        { 0xDA7D1113, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_DialPad_MatchList_Layer_HeaderPhone_ButtonWidget2D_Navi_enRelease", 0 },
        { 0xDADA27EC, "TogglePhoneHandle_Smart", 0 },
        { 0xDB0D29F4, "onPopupUnqueued", GetEventArgumentsForonPopupUnqueued },
        { 0xDC0D3D16, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_MultipleCall_Layer_TouchArea_DialPad_ButtonWidget_enRelease", 0 },
        { 0xDC5BA625, "OnConnectedDeviceSelectedResp_BTPHN_C_VALUE_ZERO", 0 },
        { 0xDCDA98B3, "OnIncomingCallResp_BTPHN_EN_INRINGING", GetEventArgumentsForOnIncomingCallResp_BTPHN_EN_INRINGING },
        { 0xDD62EA5B, "onActivateImageProviderRequest", GetEventArgumentsForonActivateImageProviderRequest },
        { 0xDE9448E3, "onAppStatusChanged_FOREGROUND", 0 },
        { 0xDEFA926B, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_CallList_Loading_Layer_TouchArea_Phone_ButtonWidget_enRelease", 0 },
        { 0xDF26B227, "Pfo_MICOutCallPopupCloseResp", 0 },
        { 0xDF7B04C9, "OnButtonReactionMsg_AppHmi_PhoneModule_Sys_Popup_SR_SIRI_Main_Layer_SRSRBTSpeechRecExit_ButtonWidget_enRelease", 0 },
        { 0xDF9225B5, "OnDeviceStatusResp_BTPHN_EN_DEVICE_DISCONNECTED", 0 },
        { 0xE01277A1, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_CallList_Layer_TouchArea_Phone_ButtonWidget_enRelease", 0 },
        { 0xE05BFB75, "OnButtonReactionMsg_AppHmi_PhoneModule_Sys_Popup_SR_SIRI_Main_Layer_SRSRBTSpeechRecStop_ButtonWidget_enRelease", 0 },
        { 0xE1979225, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_SR_SIRI_Main_Layer_SRSRBTSpeechRecStop_ButtonWidget_enRelease", 0 },
        { 0xE2D4F4E5, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_CallList_Loading_Layer_TabContacts_ButtonWidget_enRelease", 0 },
        { 0xE30A79B0, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Call_Layer_Icon_PhoneMute_ButtonWidget2D_enRelease", 0 },
        { 0xE4658CFD, "onHMISubStateChanged_NO_DISPLAY", 0 },
        { 0xE47C4454, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_MultipleCall_Layer_TouchArea_Switch_ButtonWidget_enRelease", 0 },
        { 0xE4F33869, "OnButtonReactionMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_SMS_Layer_Readaloud_ButtonWidget_enRelease", 0 },
        { 0xE562F2BF, "OnDisconnectDeviceResp", 0 },
        { 0xE78CB8A4, "OnButtonReactionMsg_AppHmi_PhoneModule_App_Popup_Pfo_WaitForConfirmation_Layer_Cancel_ButtonWidget_enRelease", 0 },
        { 0xE7DCE080, "OnNextLevelTransitionFinished", 0 },
        { 0xE927938F, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_OPT_SETTINGS_Layer_ShowSMS_1_ButtonWidget2D_enRelease", 0 },
        { 0xE9A6D56C, "OnFadeAnimationFinished", 0 },
        { 0xEA9EA5D8, "TogglePhoneHandle", 0 },
        { 0xEDF17D92, "OnActivationResMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_PassiveDeviceIncomingCall_1", 0 },
        { 0xEE183E4B, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Call_Layer_TouchArea_DialPad_ButtonWidget_enRelease", 0 },
        { 0xEEFAAAB7, "OnSLCStatusResp_1", 0 },
        { 0xEFB97EA7, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_I_Contacts_Layer_TouchArea_Phone_ButtonWidget_enRelease", 0 },
        { 0xF01F1FA6, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_MultipleCall_Layer_Mute_ButtonWidget2D_enRelease", 0 },
        { 0xF0695058, "OnActivationResMsg_AppHmi_PhoneModule_App_Popup_Pfo_WaitForConfirmation_1", 0 },
        { 0xF30788AF, "OnPairingStatusResp_BTPHN_EN_PAIRING_STATUS_CANCELLED", 0 },
        { 0xF35157EE, "OnActivationResMsg_AppHmi_PhoneModule_App_Popup_Pfo_NumCompPairing_1", 0 },
        { 0xF3765187, "ReqPhoneContentContextSwitch_Smart", 0 },
        { 0xF3C96D17, "onPopupTimerExpiry", GetEventArgumentsForonPopupTimerExpiry },
        { 0xF492BCC7, "OnDeviceStatusResp_BTPHN_EN_DEVICE_DELETED", 0 },
        { 0xF49B6A2E, "OnButtonReactionMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_PassiveDeviceIncomingCall_Layer_TouchArea_HangUp_ButtonWidget_enRelease", 0 },
        { 0xF4DFDC68, "Multiparty_SecondCall_Ringing", 0 },
        { 0xF50D3527, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_DialPad_Layer_HeaderPhone_ButtonWidget2D_Media_enRelease", 0 },
        { 0xF55F1AAC, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_DialPad_Layer_SpellerExpander_ButtonWidget_enRelease", 0 },
        { 0xF74726B3, "OnBTVRStatusResp_false", 0 },
        { 0xF7B04001, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Call_DialPad_Layer_SpellerExpander_ButtonWidget_enRelease", 0 },
        { 0xF84B3BD1, "OnZoomOutFinished", 0 },
        { 0xF96478DC, "onHMISubStateChanged_CLOCK", 0 },
        { 0xF9A0E92C, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_CallList_Layer_HeaderPhone_ButtonWidget2D_PhoneName_enRelease", 0 },
        { 0xFAADD06D, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_MultipleCall_Layer_Handset_ButtonWidget2D_enRelease", 0 },
        { 0xFAE44A15, "OnButtonReactionMsg_AppHmi_PhoneModule_Sys_Popup_Pfo_PriorityCall_BT_Layer_Yes_ButtonWidget_enRelease", 0 },
        { 0xFB766D09, "OnButtonReactionMsg_AppHmi_PhoneModule_App_Popup_Pfo_DeviceDisconnectConfirmation_Layer_Yes_ButtonWidget_enRelease", 0 },
        { 0xFBEEA58F, "OnZoomInFinished", 0 },
        { 0xFC0D2293, "onCenterPopupSurfaceQueued", GetEventArgumentsForonCenterPopupSurfaceQueued },
        { 0xFC84D96A, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_CallList_Layer_HeaderPhone_ButtonWidget2D_Radio_enRelease", 0 },
        { 0xFF0B8CB4, "OnSWCMuteResp", 0 },
        { 0xFFFBD8E5, "OnButtonReactionMsg_AppHmi_PhoneModule_PhoneScenes_P_Contacts_Loading_Layer_TabDialpad_ButtonWidget_enRelease", 0 },
    };
    const EventNameMapping* eventEntry = ::Courier::BinarySearch(eventId, events, 294, &EventNameMappingCmp);
    if (eventEntry && (eventId == eventEntry->mEventId)) {
        if (0 != eventEntry->mGetEventArguments) {
            eventEntry->mGetEventArguments(message, eventArguments);
        }
        return eventEntry->mEventName;
    }
    return 0;
}
#endif
// ------------------------------------------------------------------------
struct IdToNameMapping
{
    ::FeatStd::UInt32 mId;
    const ::FeatStd::Char* mName;
};

static ::FeatStd::Int IdToNameMappingCmp(::FeatStd::UInt32 id, const IdToNameMapping& nm)
{
    return (id == nm.mId) ? 0 : ((id < nm.mId) ? -1 : 1);
}

const ::FeatStd::Char * AppHmi_PhoneStateMachineImpl::GetNameFromId(::FeatStd::UInt32 id)
{
    static IdToNameMapping names[52] = {
        { 0x04F58CBE, "AppHmi_PhoneModule#Sys_Popup#Pfo_SIRI_EyeFree" },
        { 0x0786E642, "AppHmi_PhoneModule#Sys_Popup#Pfo_PriorityCall_Intercom" },
        { 0x0B2B6CB5, "AppHmi_PhoneModule#PhoneScenes#P_MultipleCall_DialPad" },
        { 0x0BF0A2A5, "AppHmi_PhoneModule#PhoneScenes#P_Call_Disconnecting" },
        { 0x125A4B06, "AppHmi_PhoneModule#PhoneScenes#I_Call_Connecting" },
        { 0x148855D6, "AppHmi_PhoneModule#PhoneScenes#P_Contacts" },
        { 0x19AA872C, "AppHmi_PhoneModule#Sys_Popup#Pfo_PriorityCall_BT" },
        { 0x1E335EF3, "AppHmi_PhoneModule#Sys_Popup#Pfo_MIC_IntercomCall" },
        { 0x20C88818, "AppHmi_PhoneModule#PhoneScenes#P_PhoneSelection" },
        { 0x24E45F4F, "AppHmi_PhoneModule#App_Popup#Pfo_DeleteDeviceConfirmation" },
        { 0x25116576, "AppHmi_PhoneModule#PhoneScenes#P_Call" },
        { 0x2C6603E4, "AppHmi_PhoneModule#Gadget_Phone#MASTER__GADGET_PHONE_NON_NAVI" },
        { 0x2CB3B9CB, "AppHmi_PhoneModule#App_Popup#Pfo_WaitForConfirmation" },
        { 0x31DBA6A7, "AppHmi_PhoneModule#PhoneScenes#P_OPT_SETTINGS" },
        { 0x33E40617, "AppHmi_PhoneModule#PhoneScenes#P_SR_SIRI_Main" },
        { 0x36AED1B4, "AppHmi_PhoneModule#App_Popup#Pfo_DeviceDeleted" },
        { 0x3FE9681F, "AppHmi_PhoneModule#App_Popup#Pfo_PairingInitiate" },
        { 0x4031F381, "AppHmi_PhoneModule#Sys_Popup#Pfo_Intercom_RTP_stream_failure" },
        { 0x421061F8, "AppHmi_PhoneModule#Sys_Popup#Pfo_PhonebookDLIncomplete" },
        { 0x44344FD5, "AppHmi_PhoneModule#App_Popup#Pfo_NumCompPairing" },
        { 0x459D874E, "AppHmi_PhoneModule#Sys_Popup#Pfo_SMS" },
        { 0x48A292A7, "AppHmi_PhoneModule#Sys_Popup#Pfo_DeviceDisConnected" },
        { 0x4AAB408B, "AppHmi_PhoneModule#PhoneScenes#P_CallList_Loading" },
        { 0x5689E7F0, "AppHmi_PhoneModule#App_Popup#Pfo_DeviceConnecting" },
        { 0x575D15DF, "AppHmi_PhoneModule#PhoneScenes#P_IntercomCall" },
        { 0x5797A141, "AppHmi_PhoneModule#App_Popup#Pfo_DeviceDisconnectConfirmation" },
        { 0x5C805BFA, "AppHmi_PhoneModule#Sys_Popup#Pfo_MIC_CallHistory_Contacts" },
        { 0x5F708271, "AppHmi_PhoneModule#Sys_Popup#SR_SIRI_Main" },
        { 0x6947B659, "AppHmi_PhoneModule#PhoneScenes#P_Call_Connecting" },
        { 0x6E9DFA7F, "AppHmi_PhoneModule#PhoneScenes#I_Contacts" },
        { 0x75F3D9A8, "AppHmi_PhoneModule#PhoneScenes#P_Intercom_ConferenceCall" },
        { 0x7735D7A8, "AppHmi_PhoneModule#Gadget_Phone#MASTER__GADGET_PHONE_Smart" },
        { 0x7B4CBA9D, "AppHmi_PhoneModule#PhoneScenes#P_Contacts_Call" },
        { 0x8057D8BE, "AppHmi_PhoneModule#App_Popup#Pfo_JustWorksPairing" },
        { 0x83D4F604, "AppHmi_PhoneModule#Sys_Popup#Pfo_PhonebookDLFailed" },
        { 0x8412AF25, "AppHmi_PhoneModule#App_Popup#Pfo_JustWorksPairingWaiting" },
        { 0x865548BE, "AppHmi_PhoneModule#PhoneScenes#P_DialPad" },
        { 0x94E80FB0, "AppHmi_PhoneModule#App_Popup#Pfo_DeviceDeleting" },
        { 0x9B2CFC7F, "AppHmi_PhoneModule#PhoneScenes#P_OPT" },
        { 0x9BF264B6, "AppHmi_PhoneModule#Sys_Popup#Pfo_PassiveDeviceIncomingCall" },
        { 0xB247327A, "AppHmi_PhoneModule#PhoneScenes#P_Contacts_Loading" },
        { 0xBC447BCD, "AppHmi_PhoneModule#Sys_Popup#Pfo_Intercom_IncomingCall" },
        { 0xBCA37573, "AppHmi_PhoneModule#Sys_Popup#Pfo_IncomingCall" },
        { 0xBED8BD2F, "AppHmi_PhoneModule#App_Popup#Pfo_DeviceListFull" },
        { 0xC366F8A7, "AppHmi_PhoneModule#Gadget_Phone#MASTER__GADGET_PHONE" },
        { 0xCBB96BAD, "AppHmi_PhoneModule#Sys_Popup#Pfo_DeviceConnected" },
        { 0xD39C392E, "AppHmi_PhoneModule#PhoneScenes#P_Call_DialPad" },
        { 0xD9A2C83C, "AppHmi_PhoneModule#Sys_Popup#Pfo_SMSExpand" },
        { 0xDEA29A01, "AppHmi_PhoneModule#Sys_Popup#Pfo_MIC_PhoneCall" },
        { 0xF954370D, "AppHmi_PhoneModule#Sys_Popup#Pfo_ConnectionFailed" },
        { 0xFA2C82EF, "AppHmi_PhoneModule#PhoneScenes#P_MultipleCall" },
        { 0xFFAF48B9, "AppHmi_PhoneModule#PhoneScenes#P_CallList" },
    };
    const IdToNameMapping *nameEntry = ::Courier::BinarySearch(id, names, 52, &IdToNameMappingCmp);
    if(nameEntry != 0 && id == nameEntry->mId) {
        return nameEntry->mName;
    }
    return "";
}

// ------------------------------------------------------------------------

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::Perform_AppHmi_PhoneModule_AddNewDevice()
{
    Action_Perform_AppHmi_PhoneModule_AddNewDevice();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::Perform_AppHmi_PhoneModule_DeviceListReq()
{
    Action_Perform_AppHmi_PhoneModule_DeviceListReq();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::Perform_AppHmi_PhoneModule_DeleteDeviceConfirmationReq()
{
    Action_Perform_AppHmi_PhoneModule_DeleteDeviceConfirmationReq();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::Perform_AppHmi_PhoneModule_DisconnectDeviceConfirmationReq()
{
    Action_Perform_AppHmi_PhoneModule_DisconnectDeviceConfirmationReq();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::Perform_AppHmi_PhoneModule_BackButtonPressReq()
{
    Action_Perform_AppHmi_PhoneModule_BackButtonPressReq();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::Perform_AppHmi_PhoneModule_ResetCallListDataReq()
{
    Action_Perform_AppHmi_PhoneModule_ResetCallListDataReq();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::Perform_AppHmi_PhoneModule_ResetContactListDataReq()
{
    Action_Perform_AppHmi_PhoneModule_ResetContactListDataReq();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::Perform_AppHmi_PhoneModule_Pairing_No()
{
    Action_Perform_AppHmi_PhoneModule_Pairing_No();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::Perform_AppHmi_PhoneModule_Pairing_Cancel()
{
    Action_Perform_AppHmi_PhoneModule_Pairing_Cancel();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::Perform_AppHmi_PhoneModule_Pairing_Yes()
{
    Action_Perform_AppHmi_PhoneModule_Pairing_Yes();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::Perform_AppHmi_PhoneModule_AcceptCall()
{
    Action_Perform_AppHmi_PhoneModule_AcceptCall();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::Perform_AppHmi_PhoneModule_RejectCall()
{
    Action_Perform_AppHmi_PhoneModule_RejectCall();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::Perform_Intercom_AcceptCall()
{
    Action_Perform_Intercom_AcceptCall();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::Perform_Intercom_RejectCall()
{
    Action_Perform_Intercom_RejectCall();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::Perform_Intercom_RejectConfCall()
{
    Action_Perform_Intercom_RejectConfCall();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::Perform_IConference_RejectCall()
{
    Action_Perform_IConference_RejectCall();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::Perform_AppHmi_PhoneModule_HangUpCall()
{
    Action_Perform_AppHmi_PhoneModule_HangUpCall();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::Perform_AppHmi_PhoneModule_CancelDialing()
{
    Action_Perform_AppHmi_PhoneModule_CancelDialing();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::Perform_AppHmi_PhoneModule_DialCall_Model()
{
    Action_Perform_AppHmi_PhoneModule_DialCall_Model();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::Perform_AppHmi_PhoneModule_CallListReq()
{
    Action_Perform_AppHmi_PhoneModule_CallListReq();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::Perform_AppHmi_PhoneModule_IContactsReq()
{
    Action_Perform_AppHmi_PhoneModule_IContactsReq();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::Perform_AppHmi_PhoneModule_IntercomStatusMsg()
{
    Action_Perform_AppHmi_PhoneModule_IntercomStatusMsg();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::Perform_AppHmi_PhoneModule_Handsfree_Status_ChangeReq()
{
    Action_Perform_AppHmi_PhoneModule_Handsfree_Status_ChangeReq();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::Perform_AppHmi_PhoneModule_Clear_EditFieldReq()
{
    Action_Perform_AppHmi_PhoneModule_Clear_EditFieldReq();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::Perform_AppHmi_PhoneModule_MicMute_Status_ChangeReq()
{
    Action_Perform_AppHmi_PhoneModule_MicMute_Status_ChangeReq();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::Perform_AppHmi_PhoneModule_MessageCall()
{
    Action_Perform_AppHmi_PhoneModule_MessageCall();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::Perform_AppHmi_PhoneModule_SwapMultipleCallReq()
{
    Action_Perform_AppHmi_PhoneModule_SwapMultipleCallReq();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::Perform_AppHmi_PhoneModule_ChangeRingtoneSettingsReq()
{
    Action_Perform_AppHmi_PhoneModule_ChangeRingtoneSettingsReq();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::Perform_AppHmi_PhoneModule_ChangeSMSSettingsReq()
{
    Action_Perform_AppHmi_PhoneModule_ChangeSMSSettingsReq();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::Perform_AppHmi_PhoneModule_PlayReadMessageAloudReq()
{
    Action_Perform_AppHmi_PhoneModule_PlayReadMessageAloudReq();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::Perform_AppHmi_PhoneModule_StopReadMessageAloudReq()
{
    Action_Perform_AppHmi_PhoneModule_StopReadMessageAloudReq();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::Perform_AppHmi_PhoneModule_MatchListEntryReq()
{
    Action_Perform_AppHmi_PhoneModule_MatchListEntryReq();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::Perform_AppHmi_PhoneModule_ContactDetailsListEntryReq()
{
    Action_Perform_AppHmi_PhoneModule_ContactDetailsListEntryReq();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::Perform_AppHmi_PhoneModule_ContactListReq_History()
{
    Action_Perform_AppHmi_PhoneModule_ContactListReq_History();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::Perform_AppHmi_PhoneModule_ContactListReq_Begining()
{
    Action_Perform_AppHmi_PhoneModule_ContactListReq_Begining();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::Perform_AppHmi_PhoneModule_Ringtone_Mute()
{
    Action_Perform_AppHmi_PhoneModule_Ringtone_Mute();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::Perform_Activate_SPI_Application()
{
    Action_Perform_Activate_SPI_Application();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::Perform_Activate_Listen()
{
    Action_Perform_Activate_Listen();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::ActivatePhoneGadgetResponse(::FeatStd::Int8 aRequestType)
{
    Action_ActivatePhoneGadgetResponse(Courier::UInt8(aRequestType));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::Perform_Network_Operator_Req()
{
    Action_Perform_Network_Operator_Req();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::Perform_Activate_Radio_Application()
{
    Action_Perform_Activate_Radio_Application();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::Perform_Activate_Media_Application()
{
    Action_Perform_Activate_Media_Application();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::Perform_Activate_Media_Source_Selection()
{
    Action_Perform_Activate_Media_Source_Selection();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::Perform_Activate_Home_Source()
{
    Action_Perform_Activate_Home_Source();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::Phone_ActivityId()
{
    Action_Phone_ActivityId();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::Perform_Activate_Navi_Application()
{
    Action_Perform_Activate_Navi_Application();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::Perform_Activate_BTPhone_Application_Call_List()
{
    Action_Perform_Activate_BTPhone_Application_Call_List();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::Perform_Activate_BTPhone_Application_Contact_List()
{
    Action_Perform_Activate_BTPhone_Application_Contact_List();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::Perform_Activate_BTPhone_Application_Device_List()
{
    Action_Perform_Activate_BTPhone_Application_Device_List();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::Perform_Activate_BTPhone_Application_Call_Connecting()
{
    Action_Perform_Activate_BTPhone_Application_Call_Connecting();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::Perform_Activate_BTPhone_Application_On_Call()
{
    Action_Perform_Activate_BTPhone_Application_On_Call();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::Perform_Activate_BTPhone_Application_On_Multiparty_Call()
{
    Action_Perform_Activate_BTPhone_Application_On_Multiparty_Call();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::Perform_Deactivate_BTPhone_Application()
{
    Action_Perform_Deactivate_BTPhone_Application();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::Activate_BT_SR_Session()
{
    Action_Activate_BT_SR_Session();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::Halt_BT_SR_Session()
{
    Action_Halt_BT_SR_Session();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::BTVROnExitAction()
{
    Action_BTVROnExitAction();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::DeActivate_BT_SR_Session()
{
    Action_DeActivate_BT_SR_Session();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::Perform_Activate_BTPhone_Application_On_Intercomcall()
{
    Action_Perform_Activate_BTPhone_Application_On_Intercomcall();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::Perform_AppHmi_PhoneModule_PrivateMode()
{
    Action_Perform_AppHmi_PhoneModule_PrivateMode();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::Language_Update()
{
    Action_Language_Update();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacChangeLanguageReq(::FeatStd::Int32 aLanguageId)
{
    Action_gacChangeLanguageReq(enLanguageId(aLanguageId));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacHideFocusInViewReq(::FeatStd::UInt32 aView)
{
    Action_gacHideFocusInViewReq(::Courier::ViewId(AppHmi_PhoneStateMachineImpl::GetNameFromId(aView)));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::NextLevelTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_NextLevelTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::PreviousLevelTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_PreviousLevelTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::DualViewLeftTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_DualViewLeftTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::DualViewRightTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_DualViewRightTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::PageFlipBackTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_PageFlipBackTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::PageFlipFrontTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_PageFlipFrontTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::ZoomInTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView, ::FeatStd::Int8 aPos)
{
    Action_ZoomInTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView), Candera::UInt8(aPos));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::ZoomOutTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView, ::FeatStd::Int8 aPos)
{
    Action_ZoomOutTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView), Candera::UInt8(aPos));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::FadeTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_FadeTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacWaitAnimationStartReq()
{
    Action_gacWaitAnimationStartReq();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::acFocusOnRightEncoderReqUpd(bool aIsFocusUsed)
{
    Action_acFocusOnRightEncoderReqUpd(bool(aIsFocusUsed));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::acSetGadgetSceenActiveStatus(bool aIsGadgetAtive)
{
    Action_acSetGadgetSceenActiveStatus(bool(aIsGadgetAtive));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::acHKNotificationMsg(::FeatStd::Int8 aHKCode, ::FeatStd::Int8 aHKState)
{
    Action_acHKNotificationMsg(Courier::UInt8(aHKCode), Courier::UInt8(aHKState));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::acPerform_CloseAllDropdowns()
{
    Action_acPerform_CloseAllDropdowns();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::acPerform_CloseDropdown(::FeatStd::UInt32 aListId)
{
    Action_acPerform_CloseDropdown(::Courier::UInt32(aListId));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::acPerform_OpenDropdown(::FeatStd::UInt32 aListId)
{
    Action_acPerform_OpenDropdown(::Courier::UInt32(aListId));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::acPerform_ToggleDropdown(::FeatStd::UInt32 aListId)
{
    Action_acPerform_ToggleDropdown(::Courier::UInt32(aListId));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::acStartAppPopupTimer(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aTimeout)
{
    Action_acStartAppPopupTimer(Courier::UInt32(aViewId), Courier::UInt32(aTimeout));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::acStopAppPopupTimer(::FeatStd::UInt32 aViewId)
{
    Action_acStopAppPopupTimer(Courier::UInt32(aViewId));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::acPostBeep(::FeatStd::Int8 aBeepType)
{
    Action_acPostBeep(Courier::Int32(aBeepType));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacCheckToClosePopup(::FeatStd::UInt32 aPopupId)
{
    Action_gacCheckToClosePopup(Courier::UInt32(aPopupId));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::acRestartAppPopupTimer(::FeatStd::UInt32 aViewId)
{
    Action_acRestartAppPopupTimer(Courier::UInt32(aViewId));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacContextSwitchBackRes(::FeatStd::UInt32 aSwitchId)
{
    Action_gacContextSwitchBackRes(Courier::UInt32(aSwitchId));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacContextSwitchCompleteRes(::FeatStd::UInt32 aSwitchId)
{
    Action_gacContextSwitchCompleteRes(Courier::UInt32(aSwitchId));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacContextSwitchFailedRes(::FeatStd::UInt32 aSwitchId)
{
    Action_gacContextSwitchFailedRes(Courier::UInt32(aSwitchId));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacContextSwitchDoneRes(::FeatStd::UInt32 aSwitchId)
{
    Action_gacContextSwitchDoneRes(Courier::UInt32(aSwitchId));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacContextSwitchOutReq(::FeatStd::UInt32 aTargetContextId, ::FeatStd::UInt32 aSourceContextId, ::FeatStd::UInt32 aTargetAppId)
{
    Action_gacContextSwitchOutReq(Courier::UInt32(aTargetContextId), Courier::UInt32(aSourceContextId), Courier::UInt32(aTargetAppId));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacCurrentScreenDisplayReq()
{
    Action_gacCurrentScreenDisplayReq();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacLaunchBarDisplayReq(bool aVisibility)
{
    Action_gacLaunchBarDisplayReq(bool(aVisibility));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacNavTBTSwipe()
{
    Action_gacNavTBTSwipe();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacPerformListBtnRightEncoderChangeUpd(::FeatStd::Int8 aSteps, ::FeatStd::UInt32 aListId, ::FeatStd::UInt32 aRowId, ::FeatStd::UInt32 aColumnId)
{
    Action_gacPerformListBtnRightEncoderChangeUpd(Courier::Int8(aSteps), Courier::UInt32(aListId), Courier::UInt32(aRowId), Courier::UInt32(aColumnId));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacScrollListUp()
{
    Action_gacScrollListUp();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacScrollListDown()
{
    Action_gacScrollListDown();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacScrollPageUp()
{
    Action_gacScrollPageUp();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacScrollPageDown()
{
    Action_gacScrollPageDown();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacScrollListFocusUp(::FeatStd::UInt32 aListId)
{
    Action_gacScrollListFocusUp(Courier::UInt32(aListId));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacScrollListFocusDown(::FeatStd::UInt32 aListId)
{
    Action_gacScrollListFocusDown(Courier::UInt32(aListId));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacPerformListFocusLockDataResetUpd()
{
    Action_gacPerformListFocusLockDataResetUpd();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacSetApplicationMode(::FeatStd::UInt32 aModeId)
{
    Action_gacSetApplicationMode(Courier::UInt32(aModeId));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacSpellerBbehaviorReq(bool aEnable)
{
    Action_gacSpellerBbehaviorReq(bool(aEnable));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacStatusBarDisplayReq(bool aVisibility, ::FeatStd::Int32 aHeaderType)
{
    Action_gacStatusBarDisplayReq(bool(aVisibility), Courier::Int32(aHeaderType));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacTBTRetriggerAcousticOutput()
{
    Action_gacTBTRetriggerAcousticOutput();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacWaitAnimationStopReq()
{
    Action_gacWaitAnimationStopReq();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacViewCreateReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewCreateReq(::Courier::ViewId(AppHmi_PhoneStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacViewCreateAllReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewCreateAllReq(::Courier::ViewId(AppHmi_PhoneStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacViewDestroyReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewDestroyReq(::Courier::ViewId(AppHmi_PhoneStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacViewClearReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewClearReq(::Courier::ViewId(AppHmi_PhoneStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacViewShowReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewShowReq(::Courier::ViewId(AppHmi_PhoneStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacViewHideReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewHideReq(::Courier::ViewId(AppHmi_PhoneStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacViewCreateWithoutLoadReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewCreateWithoutLoadReq(::Courier::ViewId(AppHmi_PhoneStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacViewAsyncLoadReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewAsyncLoadReq(::Courier::ViewId(AppHmi_PhoneStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacViewActivateWithoutRenderingReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewActivateWithoutRenderingReq(::Courier::ViewId(AppHmi_PhoneStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacPopupCreateAndSBShowReq(::FeatStd::UInt32 aViewId)
{
    Action_gacPopupCreateAndSBShowReq(::Courier::ViewId(AppHmi_PhoneStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacPopupCreateAndSBShowReqForMultiDisplay(::FeatStd::UInt32 aPopupDisplayID, ::FeatStd::UInt32 aViewId)
{
    Action_gacPopupCreateAndSBShowReqForMultiDisplay(Courier::UInt32(aPopupDisplayID), ::Courier::ViewId(AppHmi_PhoneStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacPopupSBCloseReq(::FeatStd::UInt32 aViewId)
{
    Action_gacPopupSBCloseReq(::Courier::ViewId(AppHmi_PhoneStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacPopupSBCloseReqForMultiDisplay(::FeatStd::UInt32 aPopupDisplayID, ::FeatStd::UInt32 aViewId)
{
    Action_gacPopupSBCloseReqForMultiDisplay(Courier::UInt32(aPopupDisplayID), ::Courier::ViewId(AppHmi_PhoneStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacPopupRestartTimerReq(::FeatStd::UInt32 aViewId)
{
    Action_gacPopupRestartTimerReq(::Courier::ViewId(AppHmi_PhoneStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacPopupRestartTimerReqForMultiDisplay(::FeatStd::UInt32 aPopupDisplayID, ::FeatStd::UInt32 aViewId)
{
    Action_gacPopupRestartTimerReqForMultiDisplay(Courier::UInt32(aPopupDisplayID), ::Courier::ViewId(AppHmi_PhoneStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacViewCreateAndShowReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewCreateAndShowReq(::Courier::ViewId(AppHmi_PhoneStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacViewHideAndDestroyReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewHideAndDestroyReq(::Courier::ViewId(AppHmi_PhoneStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacSceneTransitionEnter(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aHint)
{
    Action_gacSceneTransitionEnter(::Courier::ViewId(AppHmi_PhoneStateMachineImpl::GetNameFromId(aViewId)), Courier::UInt32(aHint));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacSceneTransitionLeave(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aHint)
{
    Action_gacSceneTransitionLeave(::Courier::ViewId(AppHmi_PhoneStateMachineImpl::GetNameFromId(aViewId)), Courier::UInt32(aHint));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacDisplayStatusLineReq(::FeatStd::Int32 aDisplayRegionType)
{
    Action_gacDisplayStatusLineReq(Courier::Int32(aDisplayRegionType));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacHideStatusLineReq(::FeatStd::Int32 aDisplayRegionType)
{
    Action_gacHideStatusLineReq(Courier::Int32(aDisplayRegionType));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacDisplayFooterLineReq()
{
    Action_gacDisplayFooterLineReq();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacHideFooterLineReq()
{
    Action_gacHideFooterLineReq();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacDisplayStatusLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID)
{
    Action_gacDisplayStatusLineMultiDisplayReq(Courier::Int32(aDisplayRegionType), Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacHideStatusLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID)
{
    Action_gacHideStatusLineMultiDisplayReq(Courier::Int32(aDisplayRegionType), Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacDisplayFooterLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID)
{
    Action_gacDisplayFooterLineMultiDisplayReq(Courier::Int32(aDisplayRegionType), Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacHideFooterLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID)
{
    Action_gacHideFooterLineMultiDisplayReq(Courier::Int32(aDisplayRegionType), Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacRegisterForCloseOnTouchSession(::FeatStd::UInt32 aViewId)
{
    Action_gacRegisterForCloseOnTouchSession(::Courier::ViewId(AppHmi_PhoneStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacDeregisterForCloseOnTouchSessionReq(::FeatStd::UInt32 aViewId)
{
    Action_gacDeregisterForCloseOnTouchSessionReq(::Courier::ViewId(AppHmi_PhoneStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacPopupFilterPrioEnableReq(::FeatStd::UInt32 aPrio)
{
    Action_gacPopupFilterPrioEnableReq(Courier::UInt32(aPrio));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacPopupFilterAllEnableReq()
{
    Action_gacPopupFilterAllEnableReq();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacPopupFilterDisableReq()
{
    Action_gacPopupFilterDisableReq();
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacProfileChange(::FeatStd::Int8 aProfile)
{
    Action_gacProfileChange(Courier::UInt32(aProfile));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacPopupFilterPrioEnableReqForDisplay(::FeatStd::UInt32 aPrio, ::FeatStd::UInt32 aDisplayID)
{
    Action_gacPopupFilterPrioEnableReqForDisplay(Courier::UInt32(aPrio), Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacPopupFilterAllEnableReqForDisplay(::FeatStd::UInt32 aDisplayID)
{
    Action_gacPopupFilterAllEnableReqForDisplay(Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacPopupFilterDisableReqForDisplay(::FeatStd::UInt32 aDisplayID)
{
    Action_gacPopupFilterDisableReqForDisplay(Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacStartSceneTransitionAnimation(::FeatStd::UInt32 aSourceView, ::FeatStd::UInt32 aDestinationView, ::FeatStd::UInt32 aUserData1, ::FeatStd::Int8 aUserData2)
{
    Action_gacStartSceneTransitionAnimation(::Courier::ViewId(AppHmi_PhoneStateMachineImpl::GetNameFromId(aSourceView)), ::Courier::ViewId(AppHmi_PhoneStateMachineImpl::GetNameFromId(aDestinationView)), Courier::UInt32(aUserData1), Courier::Int8(aUserData2));
}

// ------------------------------------------------------------------------
void AppHmi_PhoneStateMachineImpl::gacDecrementActiveAnimationCount()
{
    Action_gacDecrementActiveAnimationCount();
}
#ifdef CIT_SIMULATION
struct ActionMapping
{
    ::FeatStd::UInt32 mHashId;
    bool (*mActionCallHandler)(const ::Json::Value& parameters, ::Json::Value &response);
};

static ::FeatStd::Int ActionMappingCmp(::FeatStd::UInt32 hash, const ActionMapping& am)
{
    return (hash == am.mHashId) ? 0 : ((hash < am.mHashId) ? -1 : 1);
}

bool AppHmi_PhoneStateMachineImpl::CallAction(const ::FeatStd::Char* actionName, const ::Json::Value& parameters, ::Json::Value &response)
{
    static ActionMapping actions[143] = {
        { 0x05B410F7, CallAction_Perform_AppHmi_PhoneModule_AcceptCall },
        { 0x0884F877, CallAction_gacScrollListUp },
        { 0x090A895B, CallAction_gacScrollListFocusDown },
        { 0x092E54CB, CallAction_Perform_Activate_BTPhone_Application_On_Intercomcall },
        { 0x0A4C5DC9, CallAction_gacDisplayStatusLineMultiDisplayReq },
        { 0x0BD02196, CallAction_Perform_Intercom_RejectCall },
        { 0x0C279721, CallAction_gacDecrementActiveAnimationCount },
        { 0x0E32700C, CallAction_Perform_AppHmi_PhoneModule_MicMute_Status_ChangeReq },
        { 0x0F08E05B, CallAction_Perform_AppHmi_PhoneModule_DialCall_Model },
        { 0x11179F4F, CallAction_Perform_AppHmi_PhoneModule_Pairing_Yes },
        { 0x11915CFE, CallAction_acStopAppPopupTimer },
        { 0x15061065, CallAction_gacViewShowReq },
        { 0x15FB0C23, CallAction_Perform_AppHmi_PhoneModule_BackButtonPressReq },
        { 0x1635671A, CallAction_Perform_AppHmi_PhoneModule_IContactsReq },
        { 0x186A69F1, CallAction_gacWaitAnimationStopReq },
        { 0x187DA604, CallAction_acPerform_OpenDropdown },
        { 0x18B9A142, CallAction_Perform_Activate_SPI_Application },
        { 0x1BC6E0A9, CallAction_ZoomInTransition },
        { 0x1C396751, CallAction_Perform_AppHmi_PhoneModule_HangUpCall },
        { 0x1FDF30CB, CallAction_Perform_Network_Operator_Req },
        { 0x1FE51D23, CallAction_DeActivate_BT_SR_Session },
        { 0x21E3828E, CallAction_gacDisplayStatusLineReq },
        { 0x251DE22F, CallAction_gacContextSwitchCompleteRes },
        { 0x254E0D94, CallAction_gacViewHideReq },
        { 0x258104C2, CallAction_DualViewLeftTransition },
        { 0x264B8E81, CallAction_gacPopupRestartTimerReqForMultiDisplay },
        { 0x27CE647F, CallAction_gacScrollListFocusUp },
        { 0x29D14586, CallAction_gacDisplayFooterLineMultiDisplayReq },
        { 0x2A1E6CB2, CallAction_gacDeregisterForCloseOnTouchSessionReq },
        { 0x2AE288D8, CallAction_gacViewDestroyReq },
        { 0x2BE78CC1, CallAction_BTVROnExitAction },
        { 0x30C8D840, CallAction_gacStartSceneTransitionAnimation },
        { 0x32343C8A, CallAction_ActivatePhoneGadgetResponse },
        { 0x325BE13A, CallAction_gacViewCreateReq },
        { 0x334571BF, CallAction_acHKNotificationMsg },
        { 0x36BE1E9C, CallAction_Perform_Activate_Radio_Application },
        { 0x376F4D43, CallAction_Perform_AppHmi_PhoneModule_DeviceListReq },
        { 0x3BB18A69, CallAction_gacPopupFilterAllEnableReq },
        { 0x3D76E74C, CallAction_Perform_AppHmi_PhoneModule_Clear_EditFieldReq },
        { 0x3E4CE5A1, CallAction_gacContextSwitchDoneRes },
        { 0x3E7F9726, CallAction_gacSceneTransitionEnter },
        { 0x41201119, CallAction_acStartAppPopupTimer },
        { 0x42BC6EDF, CallAction_Perform_AppHmi_PhoneModule_MatchListEntryReq },
        { 0x435EF00D, CallAction_Perform_Activate_BTPhone_Application_On_Multiparty_Call },
        { 0x449EC865, CallAction_Perform_Activate_Navi_Application },
        { 0x4F9A7A5F, CallAction_Perform_Activate_Media_Source_Selection },
        { 0x5140B2B0, CallAction_Perform_AppHmi_PhoneModule_ChangeRingtoneSettingsReq },
        { 0x5440F00A, CallAction_Perform_AppHmi_PhoneModule_Handsfree_Status_ChangeReq },
        { 0x573EB339, CallAction_gacContextSwitchFailedRes },
        { 0x57AA275B, CallAction_gacViewCreateWithoutLoadReq },
        { 0x59148CB0, CallAction_FadeTransition },
        { 0x59C82D8E, CallAction_NextLevelTransition },
        { 0x59F03621, CallAction_gacChangeLanguageReq },
        { 0x5D5B493F, CallAction_Perform_AppHmi_PhoneModule_MessageCall },
        { 0x5F83D46A, CallAction_Perform_Activate_BTPhone_Application_Call_List },
        { 0x60E513C0, CallAction_gacTBTRetriggerAcousticOutput },
        { 0x61E496CF, CallAction_Perform_AppHmi_PhoneModule_Pairing_Cancel },
        { 0x629132A7, CallAction_gacPopupFilterDisableReq },
        { 0x67B7653B, CallAction_gacDisplayFooterLineReq },
        { 0x73F53CFC, CallAction_Perform_AppHmi_PhoneModule_RejectCall },
        { 0x74DFE6B5, CallAction_Perform_IConference_RejectCall },
        { 0x75E49D1D, CallAction_gacPerformListFocusLockDataResetUpd },
        { 0x76EE4CA4, CallAction_gacHideStatusLineMultiDisplayReq },
        { 0x791DF896, CallAction_acPerform_CloseAllDropdowns },
        { 0x7C55D2C7, CallAction_Phone_ActivityId },
        { 0x7D7B49B4, CallAction_acFocusOnRightEncoderReqUpd },
        { 0x7EE4AB88, CallAction_gacPopupRestartTimerReq },
        { 0x82D15005, CallAction_PageFlipBackTransition },
        { 0x866A51E6, CallAction_Perform_Intercom_RejectConfCall },
        { 0x881D2454, CallAction_gacPopupFilterAllEnableReqForDisplay },
        { 0x8D29F65D, CallAction_Language_Update },
        { 0x8E7BBAC5, CallAction_Perform_AppHmi_PhoneModule_ResetCallListDataReq },
        { 0x91BB105A, CallAction_gacLaunchBarDisplayReq },
        { 0x93218F8C, CallAction_gacContextSwitchOutReq },
        { 0x946AB4AA, CallAction_Perform_AppHmi_PhoneModule_IntercomStatusMsg },
        { 0x948F96CC, CallAction_gacScrollListDown },
        { 0x96350312, CallAction_acSetGadgetSceenActiveStatus },
        { 0x96D3C730, CallAction_gacPopupSBCloseReqForMultiDisplay },
        { 0x99258E0B, CallAction_gacStatusBarDisplayReq },
        { 0x993305A7, CallAction_Halt_BT_SR_Session },
        { 0x9A216CC9, CallAction_Perform_AppHmi_PhoneModule_CancelDialing },
        { 0x9F87F08B, CallAction_acPostBeep },
        { 0x9FA26D73, CallAction_gacPopupFilterDisableReqForDisplay },
        { 0xA0A6F9FA, CallAction_gacViewHideAndDestroyReq },
        { 0xA172CF4E, CallAction_Perform_Activate_Home_Source },
        { 0xA6CDDBBF, CallAction_Perform_Activate_BTPhone_Application_Call_Connecting },
        { 0xA7B62A65, CallAction_gacPopupFilterPrioEnableReqForDisplay },
        { 0xA8462864, CallAction_Perform_AppHmi_PhoneModule_ContactListReq_Begining },
        { 0xA84DC23C, CallAction_gacHideFocusInViewReq },
        { 0xA8A7C9E5, CallAction_Perform_AppHmi_PhoneModule_PlayReadMessageAloudReq },
        { 0xA9C7F42F, CallAction_gacHideStatusLineReq },
        { 0xAB49461E, CallAction_gacViewCreateAndShowReq },
        { 0xAD947FF9, CallAction_gacCurrentScreenDisplayReq },
        { 0xAE48BF55, CallAction_DualViewRightTransition },
        { 0xAFB14254, CallAction_gacWaitAnimationStartReq },
        { 0xB3412AF6, CallAction_Perform_Activate_BTPhone_Application_Device_List },
        { 0xB73C0E2F, CallAction_Perform_Activate_BTPhone_Application_On_Call },
        { 0xBB441DAC, CallAction_gacRegisterForCloseOnTouchSession },
        { 0xBDECE418, CallAction_gacSetApplicationMode },
        { 0xBEF6021E, CallAction_acPerform_ToggleDropdown },
        { 0xC37EE8E9, CallAction_gacPopupFilterPrioEnableReq },
        { 0xC51CE603, CallAction_gacViewCreateAllReq },
        { 0xC5DD5738, CallAction_gacProfileChange },
        { 0xC65CAED0, CallAction_gacSpellerBbehaviorReq },
        { 0xC8539D8B, CallAction_gacSceneTransitionLeave },
        { 0xC8EA8B79, CallAction_acRestartAppPopupTimer },
        { 0xC9EB88D6, CallAction_gacViewClearReq },
        { 0xCA4786D2, CallAction_Perform_AppHmi_PhoneModule_ContactDetailsListEntryReq },
        { 0xCA492DA8, CallAction_Perform_AppHmi_PhoneModule_CallListReq },
        { 0xCB8DBDEF, CallAction_gacHideFooterLineReq },
        { 0xCCF1A98B, CallAction_PreviousLevelTransition },
        { 0xCF35941E, CallAction_Perform_AppHmi_PhoneModule_StopReadMessageAloudReq },
        { 0xD1AA4F4D, CallAction_ZoomOutTransition },
        { 0xD30113AE, CallAction_Perform_AppHmi_PhoneModule_PrivateMode },
        { 0xD35FB082, CallAction_Perform_Activate_Listen },
        { 0xD5F685D5, CallAction_PageFlipFrontTransition },
        { 0xD63C2357, CallAction_gacViewAsyncLoadReq },
        { 0xD6DD4554, CallAction_Perform_AppHmi_PhoneModule_Pairing_No },
        { 0xD74673C2, CallAction_Perform_AppHmi_PhoneModule_DeleteDeviceConfirmationReq },
        { 0xD7E75622, CallAction_Perform_AppHmi_PhoneModule_ContactListReq_History },
        { 0xD98C6419, CallAction_gacViewActivateWithoutRenderingReq },
        { 0xDA235F9D, CallAction_Perform_Intercom_AcceptCall },
        { 0xDB665FD5, CallAction_acPerform_CloseDropdown },
        { 0xDD4D179D, CallAction_gacHideFooterLineMultiDisplayReq },
        { 0xDD5934E9, CallAction_Perform_AppHmi_PhoneModule_SwapMultipleCallReq },
        { 0xDD71F921, CallAction_gacPerformListBtnRightEncoderChangeUpd },
        { 0xE0EF3086, CallAction_gacPopupCreateAndSBShowReqForMultiDisplay },
        { 0xE20F2BAE, CallAction_Perform_AppHmi_PhoneModule_DisconnectDeviceConfirmationReq },
        { 0xE24AB12E, CallAction_Perform_Activate_Media_Application },
        { 0xE500B03C, CallAction_gacContextSwitchBackRes },
        { 0xE732A948, CallAction_Activate_BT_SR_Session },
        { 0xEB51CB7E, CallAction_gacPopupSBCloseReq },
        { 0xEBDFCEF0, CallAction_Perform_AppHmi_PhoneModule_AddNewDevice },
        { 0xEC64DB0F, CallAction_gacScrollPageDown },
        { 0xEE11F57F, CallAction_gacScrollPageUp },
        { 0xEE131A83, CallAction_gacNavTBTSwipe },
        { 0xEFC40951, CallAction_Perform_Activate_BTPhone_Application_Contact_List },
        { 0xF0A1D4B5, CallAction_gacCheckToClosePopup },
        { 0xF17E085D, CallAction_gacPopupCreateAndSBShowReq },
        { 0xFB9BD6B5, CallAction_Perform_AppHmi_PhoneModule_ChangeSMSSettingsReq },
        { 0xFCBBF2D5, CallAction_Perform_AppHmi_PhoneModule_ResetContactListDataReq },
        { 0xFF8436D8, CallAction_Perform_Deactivate_BTPhone_Application },
        { 0xFFEDF9AB, CallAction_Perform_AppHmi_PhoneModule_Ringtone_Mute },
    };
    ::FeatStd::UInt32 hashId = ::Courier::Identifier::CalcHash(actionName);
    const ActionMapping* action = ::Courier::BinarySearch(hashId, actions, 143, &ActionMappingCmp);
    if (action && (hashId == action->mHashId)) {
        return action->mActionCallHandler(parameters, response);
    }
    return false;
}
#endif
namespace Courier {
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TouchMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::KeyDownMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CameraGroupReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CameraGroupResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ActivationReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ActivationResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewRenderingReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewRenderingResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewMessagingReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewMessagingResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CameraGroupActivationReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CameraGroupActivationResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TryLoadReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::LoadReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DelayedUnloadMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::LoadResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TryAsyncLoadReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::AsyncLoadReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::AsyncLoadResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::AsyncLoadIndMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CameraGroupLoadReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CameraGroupLoadResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ThemeReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ThemeResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::AnimationReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::AnimationResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::AnimationIndMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::SetPropertyReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::SetPropertyResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::SetFocusReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::SetFocusResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::LostFocusIndMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TransitionReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TransitionResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TransitionIndMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::InvalidateReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::RenderReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::RenderResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::LayerReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::LayerResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ParentViewActivateEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ParentViewRenderingEnabledEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ParentViewInitContentEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ParentViewLoadEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::FocusEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::LostFocusEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TransitionStartedEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TransitionFinishedEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::SetCultureReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::SetCultureResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CultureChangeIndMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewPlaceholderReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewPlaceholderResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewMsgBase, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::WidgetMsgBase, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::Internal::DataBindingMsgBase, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::Internal::BindingSourceBaseMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::Internal::ReleaseDataItemMsgBase, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::Internal::DataItemMsgBase, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::Internal::ListEventMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::input::TouchAbort, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::input::TouchSessionStartEvent, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::input::TouchSessionStopEvent, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::IdUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::ConsumerMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::ProviderUpdateIndicationMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::TouchForwardReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::TouchAbortReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::ActivateImageProviderReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::ExternalImageProviderReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::ExternalImageProviderGroupReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::DrmAllocationStatusMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::DrmGarbageCollectorReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::DrmGCTimeoutMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::PositionBaseMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::SlaveSurfaceRepositionBaseMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::DirectTextureConsumerContentIndicationMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::PositionInfoReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::PositionInfoResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::SlaveSurfaceRepositionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::SlaveSurfaceRepositionResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::WidgetCheckReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::NotifierMessage, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TimerExpiredMsg, 15);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::GuiStartupFinishedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CreateNewDestroyOld, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EnterKeyStatusChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusControlReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusGroupReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::UpdateFocusSessionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RefreshFocusSessionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusSessionFinishedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RegisterFocusableWidgetsReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::JoystickStatusChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusChangedReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SurfaceStateChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::LayerStateChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SBPopupTimerExpiryUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::HMISubStateChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::QueryTraceInfoReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FollowUpActionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::WidgetPropertySetterReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SimTouchReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CloseOnTouchReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RegisterForCloseOnTouchSessionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SetClosePopupExternalTouchMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ClosePopupOnExternalTouchReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PlayBeepReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ChangeHmiSubStateReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EvalSubSurfaceReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ExecuteSubSurfaceReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ExecuteSubSurfaceResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ExtendedViewReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::LocalizationReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DecrementActiveAnimationCountMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PopupReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SetApplicationAsMandatoryReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ApplicationStateUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SubSurfaceUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ApplicationRenderedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ApplicationSwitchCompleteUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SubSurfaceSwitchCompleteUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SbAnimationStateChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SbCurrentStatusUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PopupDisplayStatusUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ShowHMISubSurfaceReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StartLayerAnimationReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PopupFilterPrioEnableReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PopupFilterAllEnableReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PopupFilterDisableReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::MultiDisplayPopupFilterReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RestartMenuTimeoutTimerReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RenderingCompleteMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CreateTextMetaDataCollectionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DumpScreenReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TraverseViewsReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropCheckSourceReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropCheckSourceResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropCheckDestinationReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropCheckDestinationResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropCompleteReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropCompleteResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropAbortReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropStatusUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ProfileSwitchMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TransitionMediatorOnDataCompleteMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ManualSceneActionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EglWaitNativeReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EglWaitNativeResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ResetGadgetCacheReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::AttachedAnimationReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::SenderMessage, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::TouchUpdMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::AnimationWidgetReqMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::AnimationWidgetIndMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ButtonListItemUpdMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ButtonReactionMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ButtonSlideMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ButtonGroupReqMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ColorBarDataUpdMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::combobox::ComboBoxUpdMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::combobox::ComboBoxReqMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DropdownCurrentValueChangedMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DropdownChangeMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::editfield::EditFieldUpdMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::editfield::EditFieldHightlightReqMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gesture::GestureMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gesture::TapGestureMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gesture::DragGestureMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gesture::SwipeGestureMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gesture::PinchSpreadGestureMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gesture::RotateGestureMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gizmo::GizmoUpdMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListDateProviderReqMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListDateProviderResMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListDataProviderUpdMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListChangeMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListAnimatedChangeReqMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListChangedUpdMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListMovementFinishedUpdMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListStatusUpdMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListVisibiltyUpdMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListFocusChangeReqMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SliderCurrentValueChangedMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::LockOutMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListItemExpandReqMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListItemExpandEndUpdMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListCustomAnimationReqMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListCustomAnimationResMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListCustomAnimationIndMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListMorphReqMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListContentUpdMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListVisualContentUpdateMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListCacheReqMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::pageedit::PageEditUpdMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PanelSlideReqMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PanelStateMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SpellerKeyPressed, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SpellerCtrlKeyPressed, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SpellerStatusChangedUpdMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SubSpellerStatusUpdMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TimerWidgetExpiryMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::HWR_CandidateUpdate, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::HWR_TextWidgetUpdate, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ScrollableTextUpdMsg, 100);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActiveSurfaceViewUpdateMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ChangeLanguageReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StartPopupTimerReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StopPopupTimerReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RestartPopupTimerReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ExpiredPopupTimerResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListFocusResetReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EnableCameraRenderingReq, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SwitchApplicationStateReq, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DisableCameraRenderingReq, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DummyMess, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivityMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivateApplicationMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DeactivateApplicationMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::HardKeyPressNotificationMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusOnRightEncoderReqUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StoreActiveGadgetReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CheckToClosePopupMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ContextSwitchOutReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ContextSwitchInResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CurrentScreenDisplayReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::LaunchBarDisplayReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::NavTBTSwipeReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListItemRightEncoderChangeUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListFocusLockDataResetReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListFocusScrollReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SetApplicationModeReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SpellerBbehaviorReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StatusBarDisplayReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TBTRetriggerAcousticMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StartGadgetAnimationReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ControlPanelButtonPressInfo, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DialCall_ModelReq, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ClearEditFieldRequestReq, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ChangeRingtoneSettingsReq, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::MatchListEntryReq, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DeleteDeviceConfirmationReq, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DisconnectDeviceConfirmationReq, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DeleteDeviceResp, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DisconnectDeviceResp, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ConnectedDeviceSelectedResp, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ResetListDataReq, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::AddNewDeviceReq, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PrivateModeUpdateMsg, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::AddNewDeviceResp, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::VehicleBTNameResp, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PairingStatusResp, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SwitchApplicationReq, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ViewPhoneActivityId, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::BtOnOffStatusAppFlyInReq, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PhoneAppflyinReq, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ResetSortOrderReq, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SSPResponseReq, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DeviceStatusResp, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ChangeDeviceStateReq, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DeviceListFullResp, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::IntercomIncomingCallResp, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::IntercomRTPStreamFailureResp, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::IntercomIncomingCallHardKeyResp, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ClearEditFieldResp, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DeviceListReq, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DeviceListResp, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DeviceHandleResp, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ChangeRingtoneReq, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ChangeRingtoneResp, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::InBandRingtoneResp, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ConnectionFailedResp, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::BTServiceErrResp, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::BluetoothOnOffResp, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::IncomingCallResponseReq, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::IntercomCallResponseReq, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::IntercomDialCall, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TerminateIConfCall, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TerminateCallReq, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::NetworkStatusResp, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DialCallReq, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CancelDialCallReq, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SendDTMFReq, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::MicMuteStateReq, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::MicMuteStateResp, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::VehicleAudioResp, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TransferVehicleAudioReq, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::MicMuteStateReqFromCAN, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TransferVehicleAudioReqFromCAN, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SwapMultipleCallReq, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SLCStatusResp, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RingtoneMuteReq, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PhnServiceErrResp, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::MatchListReq, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CallListReq, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::IContactsReq, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::NetworkOperatorReq, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CallListDialReq, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ContactDetailsReq, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ContactDetailsResp, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ContactDetailsDialReq, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::MatchListSelectReq, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PhnBkDownloadStateResp, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CallListDownloadStateResp, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ContactListWindowResp, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ContactListIndexResp, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CallListWindowResp, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::WindowListScrollReq, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ConnectionStatusResp, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::BatteryLevelResp, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DeviceNameReq, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DeviceNameResp, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::NavigationSupportResp, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::NavigationServiceResp, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SPIStatusResp, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ContactListReq, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SortPhoneBookReq, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SortPhoneBookResp, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::BTVRStatusResp, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::GenericCANBTVRReq, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::MessageDialReq, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::OptionKeyResp, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ApplicationSwitchInitiationStatus, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SWCHookResp, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SWCMuteResp, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ECallStatusResp, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ChangeSMSSettingsReq, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ChangeSMSSettingsResp, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::HomeAppStateResp, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivateSPIReq, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivateListenReq, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ReadMessageAloudReq, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::BTVRSessionStartAppReqMsg, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::BTVRSessionStopAppReqMsg, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::BTVRSessionExitAppReqMsg, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::OnBackButtonPressMsg, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::OnIncomingCallRespMsg, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::OnCallEndRespMsg, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::OnContextSwitchOnExitOfBTVRMsg, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::OnIntercomIncomingConfCallRespMsg, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::OnIntercomConfCallEndRespMsg, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::OnIntercomIncomingCallRespMsg, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::OnIntercomCallEndRespMsg, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::IntercomCallEndStatus, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::AcceptOutgoingIntercomCall, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SwitchToICallConnecting, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SwitchToIConferenceCall, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::BTVROnExitMsg, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::IntercomStatusMsg, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SRIconStatusMsg, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PhoneGadgetRequestMsg, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TriggerSceneTransitionMsg, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivateAddDeviceMsg, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivateCallListMsg, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivateCallListLoadingMsg, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivateContactListLoadingMsg, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivateContactListMsg, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivateDialPadMsg, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivateCallConnectingSceneMsg, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivateOnCallSceneMsg, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivateOnMultipleCallSceneMsg, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivateOnContactCallMsg, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivateOnIntercomCallSceneMsg, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivateOnIntercomConfCallSceneMsg, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivateOnICallConnectingSceneMsg, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivateOnIContactsSceneMsg, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivateOnSettingSceneMsg, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::AcceptCallMCP, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RejectCallOnMCPRejectBtnPress, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::onHardKeyPress, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SpeedLockstatusIndMsg, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ClosePairingPopupsOnSpeedLockstatusMsg, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SpiSessionMsg, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RequestCallConnectingMsg, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::MICContactsCallHistoryResp, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::MICIntercomCallResp, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::MICPhoneCallResp, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::MICIncCallPopupCloseResp, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::MICOutCallPopupCloseResp, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::MICActiveCallPopupCloseResp, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ShowPriorityCall_BT_Req, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ShowPriorityCall_Intercom_Req, 25);
} // namespace Courier

// ------------------------------------------------------------------------
ListId_FlexDataBindingSource::ListId_FlexDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::ListId_FlexItem)
{
}

// ------------------------------------------------------------------------
ListDataSizeDataBindingSource::ListDataSizeDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::ListDataSizeItem)
{
}

// ------------------------------------------------------------------------
PairedDevice_ListItemDataBindingSource::PairedDevice_ListItemDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::PairedDevice_ListItemItem)
{
}

// ------------------------------------------------------------------------
CallList_ListItemDataBindingSource::CallList_ListItemDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::CallList_ListItemItem)
{
}

// ------------------------------------------------------------------------
ContactList_ListItemDataBindingSource::ContactList_ListItemDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::ContactList_ListItemItem)
{
}

// ------------------------------------------------------------------------
MatchList_ListItemDataBindingSource::MatchList_ListItemDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::MatchList_ListItemItem)
{
}

// ------------------------------------------------------------------------
IContactsList_ListItemDataBindingSource::IContactsList_ListItemDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::IContactsList_ListItemItem)
{
}

// ------------------------------------------------------------------------
Intercom_SupportStatusDataBindingSource::Intercom_SupportStatusDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::Intercom_SupportStatusItem)
{
}

// ------------------------------------------------------------------------
ContactCall_ListItemDataBindingSource::ContactCall_ListItemDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::ContactCall_ListItemItem)
{
}

// ------------------------------------------------------------------------
ViewPortStartIndexDataBindingSource::ViewPortStartIndexDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::ViewPortStartIndexItem)
{
}

// ------------------------------------------------------------------------
ConnectedActiveBTDeviceNameDataBindingSource::ConnectedActiveBTDeviceNameDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::ConnectedActiveBTDeviceNameItem)
{
}

// ------------------------------------------------------------------------
ConnectedBTDeviceNameDataBindingSource::ConnectedBTDeviceNameDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::ConnectedBTDeviceNameItem)
{
}

// ------------------------------------------------------------------------
DisconnectedBTDeviceNameDataBindingSource::DisconnectedBTDeviceNameDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::DisconnectedBTDeviceNameItem)
{
}

// ------------------------------------------------------------------------
VarientTypeDataBindingSource::VarientTypeDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::VarientTypeItem)
{
}

// ------------------------------------------------------------------------
SPIStatusDataBindingSource::SPIStatusDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SPIStatusItem)
{
}

// ------------------------------------------------------------------------
IsListNotemptyDataBindingSource::IsListNotemptyDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::IsListNotemptyItem)
{
}

// ------------------------------------------------------------------------
ContactCallNameDataBindingSource::ContactCallNameDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::ContactCallNameItem)
{
}

// ------------------------------------------------------------------------
FriendlyVehicleNameDataBindingSource::FriendlyVehicleNameDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::FriendlyVehicleNameItem)
{
}

// ------------------------------------------------------------------------
PairingDeviceInfoDataBindingSource::PairingDeviceInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::PairingDeviceInfoItem)
{
}

// ------------------------------------------------------------------------
DeviceInfoDataBindingSource::DeviceInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::DeviceInfoItem)
{
}

// ------------------------------------------------------------------------
MatchedItemsDataBindingSource::MatchedItemsDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::MatchedItemsItem)
{
}

// ------------------------------------------------------------------------
PhoneButtonTextDataBindingSource::PhoneButtonTextDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::PhoneButtonTextItem)
{
}

// ------------------------------------------------------------------------
MicEnableDataBindingSource::MicEnableDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::MicEnableItem)
{
}

// ------------------------------------------------------------------------
VehicleAudioStatusDataBindingSource::VehicleAudioStatusDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::VehicleAudioStatusItem)
{
}

// ------------------------------------------------------------------------
PrivateModeStatusDataBindingSource::PrivateModeStatusDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::PrivateModeStatusItem)
{
}

// ------------------------------------------------------------------------
SettingsDataBindingSource::SettingsDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SettingsItem)
{
}

// ------------------------------------------------------------------------
CallProgressDataBindingSource::CallProgressDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::CallProgressItem)
{
}

// ------------------------------------------------------------------------
IntercomIncomingCallDataBindingSource::IntercomIncomingCallDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::IntercomIncomingCallItem)
{
}

// ------------------------------------------------------------------------
IntercomMissedIncomingCallDataBindingSource::IntercomMissedIncomingCallDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::IntercomMissedIncomingCallItem)
{
}

// ------------------------------------------------------------------------
IntercomCallProgressDataBindingSource::IntercomCallProgressDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::IntercomCallProgressItem)
{
}

// ------------------------------------------------------------------------
IntercomConfCallDataBindingSource::IntercomConfCallDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::IntercomConfCallItem)
{
}

// ------------------------------------------------------------------------
PhoneStatusDataBindingSource::PhoneStatusDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::PhoneStatusItem)
{
}

// ------------------------------------------------------------------------
ValidCharSetDataBindingSource::ValidCharSetDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::ValidCharSetItem)
{
}

// ------------------------------------------------------------------------
SuggesstionTextDataBindingSource::SuggesstionTextDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SuggesstionTextItem)
{
}

// ------------------------------------------------------------------------
EntryTextDataBindingSource::EntryTextDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::EntryTextItem)
{
}

// ------------------------------------------------------------------------
PhoneDialPadInputTextDataBindingSource::PhoneDialPadInputTextDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::PhoneDialPadInputTextItem)
{
}

// ------------------------------------------------------------------------
BTTelltalesDataBindingSource::BTTelltalesDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::BTTelltalesItem)
{
}

// ------------------------------------------------------------------------
RoamingDataBindingSource::RoamingDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::RoamingItem)
{
}

// ------------------------------------------------------------------------
DialButtonDataBindingSource::DialButtonDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::DialButtonItem)
{
}

// ------------------------------------------------------------------------
MatchListDataBindingSource::MatchListDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::MatchListItem)
{
}

// ------------------------------------------------------------------------
DialPadButtonDataBindingSource::DialPadButtonDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::DialPadButtonItem)
{
}

// ------------------------------------------------------------------------
IsActiveDataBindingSource::IsActiveDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::IsActiveItem)
{
}

// ------------------------------------------------------------------------
PhoneGadgetInfoDataBindingSource::PhoneGadgetInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::PhoneGadgetInfoItem)
{
}

// ------------------------------------------------------------------------
MsgProgressDataBindingSource::MsgProgressDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::MsgProgressItem)
{
}

// ------------------------------------------------------------------------
MultipleCallProgressDataBindingSource::MultipleCallProgressDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::MultipleCallProgressItem)
{
}

// ------------------------------------------------------------------------
IncomingCallDataBindingSource::IncomingCallDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::IncomingCallItem)
{
}

// ------------------------------------------------------------------------
NetworkOperatorDataBindingSource::NetworkOperatorDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::NetworkOperatorItem)
{
}

// ------------------------------------------------------------------------
BTVRDeviceNameDataBindingSource::BTVRDeviceNameDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::BTVRDeviceNameItem)
{
}

// ------------------------------------------------------------------------
BTVRIconSRStatusDataBindingSource::BTVRIconSRStatusDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::BTVRIconSRStatusItem)
{
}

// ------------------------------------------------------------------------
BTVRIconSRStatusIndexDataBindingSource::BTVRIconSRStatusIndexDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::BTVRIconSRStatusIndexItem)
{
}

// ------------------------------------------------------------------------
QuickScrollSearchDataBindingSource::QuickScrollSearchDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::QuickScrollSearchItem)
{
}

// ------------------------------------------------------------------------
LoadingAnimationInfoDataBindingSource::LoadingAnimationInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::LoadingAnimationInfoItem)
{
}

// ------------------------------------------------------------------------
AndroidAutoSessionInfoDataBindingSource::AndroidAutoSessionInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::AndroidAutoSessionInfoItem)
{
}

// ------------------------------------------------------------------------
BTONOFFDataBindingSource::BTONOFFDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::BTONOFFItem)
{
}

// ------------------------------------------------------------------------
IntercomenableDataBindingSource::IntercomenableDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::IntercomenableItem)
{
}

// ------------------------------------------------------------------------
AddCallEnableDataBindingSource::AddCallEnableDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::AddCallEnableItem)
{
}

// ------------------------------------------------------------------------
SpeedLockDataBindingSource::SpeedLockDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SpeedLockItem)
{
}

// ------------------------------------------------------------------------
ListScrollBarInfoDataBindingSource::ListScrollBarInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::ListScrollBarInfoItem)
{
}

typedef void InvalidData;
struct InvalidDataBindingSource {
    static const ::FeatStd::UInt32 cHierarchyNodeCount = 1;
};

// table of shared DataItemDescriptor
static const ::Courier::Internal::DataBinding::DataItemDescriptor gItemDesc[cDataItemDescriptorCount] = {
    {   // 0 - ::InvalidData
        COURIER_DATA_ITEM_TYPE_ID(::InvalidData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 1 - ::ListId_FlexData
        COURIER_DATA_ITEM_TYPE_ID(::ListId_FlexData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 2 - ::ListId_FlexData::mPairedDeviceListId
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt32),
        COURIER_ITEM_MEMBER(::ListId_FlexData, mPairedDeviceListId)
    },
    {   // 3 - ::ListId_FlexData::mPhoneContactListId
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt32),
        COURIER_ITEM_MEMBER(::ListId_FlexData, mPhoneContactListId)
    },
    {   // 4 - ::ListId_FlexData::mMatchListId
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt32),
        COURIER_ITEM_MEMBER(::ListId_FlexData, mMatchListId)
    },
    {   // 5 - ::ListId_FlexData::mContactCallListId
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt32),
        COURIER_ITEM_MEMBER(::ListId_FlexData, mContactCallListId)
    },
    {   // 6 - ::ListId_FlexData::mCallListId
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt32),
        COURIER_ITEM_MEMBER(::ListId_FlexData, mCallListId)
    },
    {   // 7 - ::ListId_FlexData::mSettingListId
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt32),
        COURIER_ITEM_MEMBER(::ListId_FlexData, mSettingListId)
    },
    {   // 8 - ::ListId_FlexData::mDropDownListId
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt32),
        COURIER_ITEM_MEMBER(::ListId_FlexData, mDropDownListId)
    },
    {   // 9 - ::ListId_FlexData::mIntercomContactsListId
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt32),
        COURIER_ITEM_MEMBER(::ListId_FlexData, mIntercomContactsListId)
    },
    {   // 10 - ::ListId_FlexData::mIntercomConfCallListId
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt32),
        COURIER_ITEM_MEMBER(::ListId_FlexData, mIntercomConfCallListId)
    },
    {   // 11 - ::ListDataSizeData
        COURIER_DATA_ITEM_TYPE_ID(::ListDataSizeData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 12 - ::ListDataSizeData::mPairedDeviceListSize
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::ListDataSizeData, mPairedDeviceListSize)
    },
    {   // 13 - ::ListDataSizeData::mContactListSize
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::ListDataSizeData, mContactListSize)
    },
    {   // 14 - ::ListDataSizeData::mMatchListSize
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::ListDataSizeData, mMatchListSize)
    },
    {   // 15 - ::ListDataSizeData::mContactCallListSize
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::ListDataSizeData, mContactCallListSize)
    },
    {   // 16 - ::ListDataSizeData::mCallListSize
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::ListDataSizeData, mCallListSize)
    },
    {   // 17 - ::ListDataSizeData::mSortOrderSize
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::ListDataSizeData, mSortOrderSize)
    },
    {   // 18 - ::ListDataSizeData::mIContactsSize
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::ListDataSizeData, mIContactsSize)
    },
    {   // 19 - ::ListDataSizeData::mIConfCallSize
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::ListDataSizeData, mIConfCallSize)
    },
    {   // 20 - ::PairedDevice_ListItemData
        COURIER_DATA_ITEM_TYPE_ID(::PairedDevice_ListItemData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 21 - ::PairedDevice_ListItemData::mDeviceTypeIndex
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::PairedDevice_ListItemData, mDeviceTypeIndex)
    },
    {   // 22 - ::PairedDevice_ListItemData::mDeviceName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PairedDevice_ListItemData, mDeviceName)
    },
    {   // 23 - ::PairedDevice_ListItemData::mProfilePhone
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::PairedDevice_ListItemData, mProfilePhone)
    },
    {   // 24 - ::PairedDevice_ListItemData::mProfileAudio
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::PairedDevice_ListItemData, mProfileAudio)
    },
    {   // 25 - ::PairedDevice_ListItemData::mBTIcon
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::PairedDevice_ListItemData, mBTIcon)
    },
    {   // 26 - ::PairedDevice_ListItemData::mDeviceNameTxtColor
        COURIER_DATA_ITEM_TYPE_ID(Candera::Color),
        COURIER_ITEM_MEMBER(::PairedDevice_ListItemData, mDeviceNameTxtColor)
    },
    {   // 27 - ::CallList_ListItemData
        COURIER_DATA_ITEM_TYPE_ID(::CallList_ListItemData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 28 - ::CallList_ListItemData::mCallInfoIcon
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::CallList_ListItemData, mCallInfoIcon)
    },
    {   // 29 - ::CallList_ListItemData::mCallerName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::CallList_ListItemData, mCallerName)
    },
    {   // 30 - ::CallList_ListItemData::mCallNumberOfTimes
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::CallList_ListItemData, mCallNumberOfTimes)
    },
    {   // 31 - ::CallList_ListItemData::mCallDate
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::CallList_ListItemData, mCallDate)
    },
    {   // 32 - ::CallList_ListItemData::mCallListFocusIndex
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::CallList_ListItemData, mCallListFocusIndex)
    },
    {   // 33 - ::ContactList_ListItemData
        COURIER_DATA_ITEM_TYPE_ID(::ContactList_ListItemData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 34 - ::ContactList_ListItemData::mContactName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::ContactList_ListItemData, mContactName)
    },
    {   // 35 - ::ContactList_ListItemData::mPhoneNumberCount
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::ContactList_ListItemData, mPhoneNumberCount)
    },
    {   // 36 - ::ContactList_ListItemData::mContactsFocusIndex
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::ContactList_ListItemData, mContactsFocusIndex)
    },
    {   // 37 - ::MatchList_ListItemData
        COURIER_DATA_ITEM_TYPE_ID(::MatchList_ListItemData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 38 - ::MatchList_ListItemData::mMatchedNumber
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::MatchList_ListItemData, mMatchedNumber)
    },
    {   // 39 - ::MatchList_ListItemData::mMatchedContactName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::MatchList_ListItemData, mMatchedContactName)
    },
    {   // 40 - ::IContactsList_ListItemData
        COURIER_DATA_ITEM_TYPE_ID(::IContactsList_ListItemData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 41 - ::IContactsList_ListItemData::mIContactName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::IContactsList_ListItemData, mIContactName)
    },
    {   // 42 - ::IContactsList_ListItemData::mIContacttype
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::IContactsList_ListItemData, mIContacttype)
    },
    {   // 43 - ::IContactsList_ListItemData::mICallStatus
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::IContactsList_ListItemData, mICallStatus)
    },
    {   // 44 - ::Intercom_SupportStatusData
        COURIER_DATA_ITEM_TYPE_ID(::Intercom_SupportStatusData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 45 - ::Intercom_SupportStatusData::mIntercom_Supported
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::Intercom_SupportStatusData, mIntercom_Supported)
    },
    {   // 46 - ::Intercom_SupportStatusData::mIntercom_NotSupported
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::Intercom_SupportStatusData, mIntercom_NotSupported)
    },
    {   // 47 - ::ContactCall_ListItemData
        COURIER_DATA_ITEM_TYPE_ID(::ContactCall_ListItemData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 48 - ::ContactCall_ListItemData::mContactInfoIcon
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::ContactCall_ListItemData, mContactInfoIcon)
    },
    {   // 49 - ::ContactCall_ListItemData::mContactPhoneNumber
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::ContactCall_ListItemData, mContactPhoneNumber)
    },
    {   // 50 - ::ContactCall_ListItemData::mPrimaryIcon
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::ContactCall_ListItemData, mPrimaryIcon)
    },
    {   // 51 - ::ViewPortStartIndexData
        COURIER_DATA_ITEM_TYPE_ID(::ViewPortStartIndexData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 52 - ::ViewPortStartIndexData::mContactListIndex
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::ViewPortStartIndexData, mContactListIndex)
    },
    {   // 53 - ::ConnectedActiveBTDeviceNameData
        COURIER_DATA_ITEM_TYPE_ID(::ConnectedActiveBTDeviceNameData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 54 - ::ConnectedActiveBTDeviceNameData::mDeviceName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::ConnectedActiveBTDeviceNameData, mDeviceName)
    },
    {   // 55 - ::ConnectedBTDeviceNameData
        COURIER_DATA_ITEM_TYPE_ID(::ConnectedBTDeviceNameData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 56 - ::ConnectedBTDeviceNameData::mDeviceName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::ConnectedBTDeviceNameData, mDeviceName)
    },
    {   // 57 - ::DisconnectedBTDeviceNameData
        COURIER_DATA_ITEM_TYPE_ID(::DisconnectedBTDeviceNameData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 58 - ::DisconnectedBTDeviceNameData::mDeviceName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DisconnectedBTDeviceNameData, mDeviceName)
    },
    {   // 59 - ::VarientTypeData
        COURIER_DATA_ITEM_TYPE_ID(::VarientTypeData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 60 - ::VarientTypeData::mSwitcherIndex
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::VarientTypeData, mSwitcherIndex)
    },
    {   // 61 - ::VarientTypeData::mEnableNavi
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::VarientTypeData, mEnableNavi)
    },
    {   // 62 - ::SPIStatusData
        COURIER_DATA_ITEM_TYPE_ID(::SPIStatusData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 63 - ::SPIStatusData::mEnableSPI
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SPIStatusData, mEnableSPI)
    },
    {   // 64 - ::IsListNotemptyData
        COURIER_DATA_ITEM_TYPE_ID(::IsListNotemptyData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 65 - ::IsListNotemptyData::mCallList
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::IsListNotemptyData, mCallList)
    },
    {   // 66 - ::IsListNotemptyData::mContactList
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::IsListNotemptyData, mContactList)
    },
    {   // 67 - ::ContactCallNameData
        COURIER_DATA_ITEM_TYPE_ID(::ContactCallNameData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 68 - ::ContactCallNameData::mCallerName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::ContactCallNameData, mCallerName)
    },
    {   // 69 - ::FriendlyVehicleNameData
        COURIER_DATA_ITEM_TYPE_ID(::FriendlyVehicleNameData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 70 - ::FriendlyVehicleNameData::mHUDName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::FriendlyVehicleNameData, mHUDName)
    },
    {   // 71 - ::PairingDeviceInfoData
        COURIER_DATA_ITEM_TYPE_ID(::PairingDeviceInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 72 - ::PairingDeviceInfoData::mDeviceName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PairingDeviceInfoData, mDeviceName)
    },
    {   // 73 - ::PairingDeviceInfoData::mPairingPIN
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PairingDeviceInfoData, mPairingPIN)
    },
    {   // 74 - ::DeviceInfoData
        COURIER_DATA_ITEM_TYPE_ID(::DeviceInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 75 - ::DeviceInfoData::mDeviceName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DeviceInfoData, mDeviceName)
    },
    {   // 76 - ::MatchedItemsData
        COURIER_DATA_ITEM_TYPE_ID(::MatchedItemsData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 77 - ::MatchedItemsData::mCount
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::MatchedItemsData, mCount)
    },
    {   // 78 - ::PhoneButtonTextData
        COURIER_DATA_ITEM_TYPE_ID(::PhoneButtonTextData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 79 - ::PhoneButtonTextData::mSource
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PhoneButtonTextData, mSource)
    },
    {   // 80 - ::MicEnableData
        COURIER_DATA_ITEM_TYPE_ID(::MicEnableData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 81 - ::MicEnableData::mIsSelected
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::MicEnableData, mIsSelected)
    },
    {   // 82 - ::MicEnableData::mEnabled
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::MicEnableData, mEnabled)
    },
    {   // 83 - ::VehicleAudioStatusData
        COURIER_DATA_ITEM_TYPE_ID(::VehicleAudioStatusData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 84 - ::VehicleAudioStatusData::mIsSelected
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::VehicleAudioStatusData, mIsSelected)
    },
    {   // 85 - ::PrivateModeStatusData
        COURIER_DATA_ITEM_TYPE_ID(::PrivateModeStatusData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 86 - ::PrivateModeStatusData::mIsSelected
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::PrivateModeStatusData, mIsSelected)
    },
    {   // 87 - ::SettingsData
        COURIER_DATA_ITEM_TYPE_ID(::SettingsData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 88 - ::SettingsData::mUsePhoneRingtone_IsSelected
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::SettingsData, mUsePhoneRingtone_IsSelected)
    },
    {   // 89 - ::SettingsData::mShowIncomingText_IsSelected
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::SettingsData, mShowIncomingText_IsSelected)
    },
    {   // 90 - ::SettingsData::mSortPhoneBookTypeText
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SettingsData, mSortPhoneBookTypeText)
    },
    {   // 91 - ::SettingsData::mSelectedLine
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::SettingsData, mSelectedLine)
    },
    {   // 92 - ::SettingsData::mIsInBandSupported
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SettingsData, mIsInBandSupported)
    },
    {   // 93 - ::SettingsData::mEnableDisableSortOrder
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SettingsData, mEnableDisableSortOrder)
    },
    {   // 94 - ::CallProgressData
        COURIER_DATA_ITEM_TYPE_ID(::CallProgressData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 95 - ::CallProgressData::mCallDuration
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::CallProgressData, mCallDuration)
    },
    {   // 96 - ::CallProgressData::mCallerID
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::CallProgressData, mCallerID)
    },
    {   // 97 - ::CallProgressData::mContactType
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::CallProgressData, mContactType)
    },
    {   // 98 - ::CallProgressData::mCallStatus
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::CallProgressData, mCallStatus)
    },
    {   // 99 - ::CallProgressData::mGadgetCallerID
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::CallProgressData, mGadgetCallerID)
    },
    {   // 100 - ::IntercomIncomingCallData
        COURIER_DATA_ITEM_TYPE_ID(::IntercomIncomingCallData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 101 - ::IntercomIncomingCallData::mCallerID
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::IntercomIncomingCallData, mCallerID)
    },
    {   // 102 - ::IntercomIncomingCallData::mContactType
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::IntercomIncomingCallData, mContactType)
    },
    {   // 103 - ::IntercomMissedIncomingCallData
        COURIER_DATA_ITEM_TYPE_ID(::IntercomMissedIncomingCallData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 104 - ::IntercomMissedIncomingCallData::mMissedCallerInfo
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::IntercomMissedIncomingCallData, mMissedCallerInfo)
    },
    {   // 105 - ::IntercomCallProgressData
        COURIER_DATA_ITEM_TYPE_ID(::IntercomCallProgressData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 106 - ::IntercomCallProgressData::mCallerID
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::IntercomCallProgressData, mCallerID)
    },
    {   // 107 - ::IntercomCallProgressData::mContactType
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::IntercomCallProgressData, mContactType)
    },
    {   // 108 - ::IntercomConfCallData
        COURIER_DATA_ITEM_TYPE_ID(::IntercomConfCallData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 109 - ::IntercomConfCallData::mCallerID
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::IntercomConfCallData, mCallerID)
    },
    {   // 110 - ::IntercomConfCallData::mContactType
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::IntercomConfCallData, mContactType)
    },
    {   // 111 - ::IntercomConfCallData::mCallStatus
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::IntercomConfCallData, mCallStatus)
    },
    {   // 112 - ::PhoneStatusData
        COURIER_DATA_ITEM_TYPE_ID(::PhoneStatusData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 113 - ::PhoneStatusData::mBatteryStatus
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::PhoneStatusData, mBatteryStatus)
    },
    {   // 114 - ::PhoneStatusData::mSignalStatus
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::PhoneStatusData, mSignalStatus)
    },
    {   // 115 - ::PhoneStatusData::mNetworkStatus
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::PhoneStatusData, mNetworkStatus)
    },
    {   // 116 - ::PhoneStatusData::mMissedCallStatus
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt32),
        COURIER_ITEM_MEMBER(::PhoneStatusData, mMissedCallStatus)
    },
    {   // 117 - ::PhoneStatusData::mSignalStatusinGadget
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::PhoneStatusData, mSignalStatusinGadget)
    },
    {   // 118 - ::PhoneStatusData::mBatteryStatusinGadget
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::PhoneStatusData, mBatteryStatusinGadget)
    },
    {   // 119 - ::ValidCharSetData
        COURIER_DATA_ITEM_TYPE_ID(::ValidCharSetData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 120 - ::ValidCharSetData::mCharacterSet
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::ValidCharSetData, mCharacterSet)
    },
    {   // 121 - ::SuggesstionTextData
        COURIER_DATA_ITEM_TYPE_ID(::SuggesstionTextData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 122 - ::SuggesstionTextData::mText
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SuggesstionTextData, mText)
    },
    {   // 123 - ::EntryTextData
        COURIER_DATA_ITEM_TYPE_ID(::EntryTextData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 124 - ::EntryTextData::mText
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EntryTextData, mText)
    },
    {   // 125 - ::PhoneDialPadInputTextData
        COURIER_DATA_ITEM_TYPE_ID(::PhoneDialPadInputTextData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 126 - ::PhoneDialPadInputTextData::mText
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PhoneDialPadInputTextData, mText)
    },
    {   // 127 - ::BTTelltalesData
        COURIER_DATA_ITEM_TYPE_ID(::BTTelltalesData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 128 - ::BTTelltalesData::mImagePath
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::BTTelltalesData, mImagePath)
    },
    {   // 129 - ::BTTelltalesData::mLoadAssetBitmap
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::BTTelltalesData, mLoadAssetBitmap)
    },
    {   // 130 - ::RoamingData
        COURIER_DATA_ITEM_TYPE_ID(::RoamingData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 131 - ::RoamingData::mEnabled
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::RoamingData, mEnabled)
    },
    {   // 132 - ::DialButtonData
        COURIER_DATA_ITEM_TYPE_ID(::DialButtonData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 133 - ::DialButtonData::mEnabled
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::DialButtonData, mEnabled)
    },
    {   // 134 - ::MatchListData
        COURIER_DATA_ITEM_TYPE_ID(::MatchListData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 135 - ::MatchListData::mEnabled
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::MatchListData, mEnabled)
    },
    {   // 136 - ::DialPadButtonData
        COURIER_DATA_ITEM_TYPE_ID(::DialPadButtonData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 137 - ::DialPadButtonData::mEnabled
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::DialPadButtonData, mEnabled)
    },
    {   // 138 - ::IsActiveData
        COURIER_DATA_ITEM_TYPE_ID(::IsActiveData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 139 - ::IsActiveData::mIsAddPhoneDisabled
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::IsActiveData, mIsAddPhoneDisabled)
    },
    {   // 140 - ::PhoneGadgetInfoData
        COURIER_DATA_ITEM_TYPE_ID(::PhoneGadgetInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 141 - ::PhoneGadgetInfoData::mPhoneHandle
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::PhoneGadgetInfoData, mPhoneHandle)
    },
    {   // 142 - ::PhoneGadgetInfoData::mPhoneSignalStatus
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::PhoneGadgetInfoData, mPhoneSignalStatus)
    },
    {   // 143 - ::PhoneGadgetInfoData::mPhoneBatteryStatus
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::PhoneGadgetInfoData, mPhoneBatteryStatus)
    },
    {   // 144 - ::PhoneGadgetInfoData::mIndexForGadgetBG
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::PhoneGadgetInfoData, mIndexForGadgetBG)
    },
    {   // 145 - ::PhoneGadgetInfoData::mIndexForGadgetContent
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::PhoneGadgetInfoData, mIndexForGadgetContent)
    },
    {   // 146 - ::PhoneGadgetInfoData::mIndexForIntercomTextInfo
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::PhoneGadgetInfoData, mIndexForIntercomTextInfo)
    },
    {   // 147 - ::MsgProgressData
        COURIER_DATA_ITEM_TYPE_ID(::MsgProgressData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 148 - ::MsgProgressData::mCallerID
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::MsgProgressData, mCallerID)
    },
    {   // 149 - ::MsgProgressData::mTimeHour
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::MsgProgressData, mTimeHour)
    },
    {   // 150 - ::MsgProgressData::mSubject
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::MsgProgressData, mSubject)
    },
    {   // 151 - ::MsgProgressData::mShortMessage
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::MsgProgressData, mShortMessage)
    },
    {   // 152 - ::MsgProgressData::mValidContact
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::MsgProgressData, mValidContact)
    },
    {   // 153 - ::MsgProgressData::mPlayBackAction
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::MsgProgressData, mPlayBackAction)
    },
    {   // 154 - ::MsgProgressData::mIsEnableReadOutAloud
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::MsgProgressData, mIsEnableReadOutAloud)
    },
    {   // 155 - ::MultipleCallProgressData
        COURIER_DATA_ITEM_TYPE_ID(::MultipleCallProgressData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 156 - ::MultipleCallProgressData::mActiveCallerID
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::MultipleCallProgressData, mActiveCallerID)
    },
    {   // 157 - ::MultipleCallProgressData::mOnHoldCallerID
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::MultipleCallProgressData, mOnHoldCallerID)
    },
    {   // 158 - ::MultipleCallProgressData::mActiveCallDuration
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::MultipleCallProgressData, mActiveCallDuration)
    },
    {   // 159 - ::MultipleCallProgressData::mOnHoldCallDuration
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::MultipleCallProgressData, mOnHoldCallDuration)
    },
    {   // 160 - ::MultipleCallProgressData::mActiveCallStatus
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::MultipleCallProgressData, mActiveCallStatus)
    },
    {   // 161 - ::MultipleCallProgressData::mOnHoldCallerStatus
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::MultipleCallProgressData, mOnHoldCallerStatus)
    },
    {   // 162 - ::MultipleCallProgressData::mActiveContactType
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::MultipleCallProgressData, mActiveContactType)
    },
    {   // 163 - ::MultipleCallProgressData::mOnHoldContactType
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::MultipleCallProgressData, mOnHoldContactType)
    },
    {   // 164 - ::MultipleCallProgressData::mCallType
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::MultipleCallProgressData, mCallType)
    },
    {   // 165 - ::MultipleCallProgressData::mIsEnableDialPad
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::MultipleCallProgressData, mIsEnableDialPad)
    },
    {   // 166 - ::MultipleCallProgressData::mIsEnableSwap
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::MultipleCallProgressData, mIsEnableSwap)
    },
    {   // 167 - ::IncomingCallData
        COURIER_DATA_ITEM_TYPE_ID(::IncomingCallData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 168 - ::IncomingCallData::mCallerID
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::IncomingCallData, mCallerID)
    },
    {   // 169 - ::IncomingCallData::mContactType
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::IncomingCallData, mContactType)
    },
    {   // 170 - ::IncomingCallData::mCount
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::IncomingCallData, mCount)
    },
    {   // 171 - ::IncomingCallData::mDeviceName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::IncomingCallData, mDeviceName)
    },
    {   // 172 - ::NetworkOperatorData
        COURIER_DATA_ITEM_TYPE_ID(::NetworkOperatorData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 173 - ::NetworkOperatorData::mOperatorName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::NetworkOperatorData, mOperatorName)
    },
    {   // 174 - ::NetworkOperatorData::mTextNodeMaxSize
        COURIER_DATA_ITEM_TYPE_ID(Candera::Vector2),
        COURIER_ITEM_MEMBER(::NetworkOperatorData, mTextNodeMaxSize)
    },
    {   // 175 - ::BTVRDeviceNameData
        COURIER_DATA_ITEM_TYPE_ID(::BTVRDeviceNameData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 176 - ::BTVRDeviceNameData::mDeviceName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::BTVRDeviceNameData, mDeviceName)
    },
    {   // 177 - ::BTVRIconSRStatusData
        COURIER_DATA_ITEM_TYPE_ID(::BTVRIconSRStatusData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 178 - ::BTVRIconSRStatusData::mIconSRStatus
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::BTVRIconSRStatusData, mIconSRStatus)
    },
    {   // 179 - ::BTVRIconSRStatusIndexData
        COURIER_DATA_ITEM_TYPE_ID(::BTVRIconSRStatusIndexData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 180 - ::BTVRIconSRStatusIndexData::mIconSRStatusIndex
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::BTVRIconSRStatusIndexData, mIconSRStatusIndex)
    },
    {   // 181 - ::QuickScrollSearchData
        COURIER_DATA_ITEM_TYPE_ID(::QuickScrollSearchData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 182 - ::QuickScrollSearchData::mScrollVisible
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::QuickScrollSearchData, mScrollVisible)
    },
    {   // 183 - ::QuickScrollSearchData::mScrollSearchChar
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::QuickScrollSearchData, mScrollSearchChar)
    },
    {   // 184 - ::LoadingAnimationInfoData
        COURIER_DATA_ITEM_TYPE_ID(::LoadingAnimationInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 185 - ::LoadingAnimationInfoData::mChannel1_Phonebook
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::LoadingAnimationInfoData, mChannel1_Phonebook)
    },
    {   // 186 - ::LoadingAnimationInfoData::mChannel1_Calllist
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::LoadingAnimationInfoData, mChannel1_Calllist)
    },
    {   // 187 - ::LoadingAnimationInfoData::mChannel2_Phonebook
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::LoadingAnimationInfoData, mChannel2_Phonebook)
    },
    {   // 188 - ::LoadingAnimationInfoData::mChannel2_Calllist
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::LoadingAnimationInfoData, mChannel2_Calllist)
    },
    {   // 189 - ::AndroidAutoSessionInfoData
        COURIER_DATA_ITEM_TYPE_ID(::AndroidAutoSessionInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 190 - ::AndroidAutoSessionInfoData::mSessionStatus
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::AndroidAutoSessionInfoData, mSessionStatus)
    },
    {   // 191 - ::AndroidAutoSessionInfoData::mSessionStatusIndex
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::AndroidAutoSessionInfoData, mSessionStatusIndex)
    },
    {   // 192 - ::BTONOFFData
        COURIER_DATA_ITEM_TYPE_ID(::BTONOFFData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 193 - ::BTONOFFData::mBTONOFFStatus
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::BTONOFFData, mBTONOFFStatus)
    },
    {   // 194 - ::IntercomenableData
        COURIER_DATA_ITEM_TYPE_ID(::IntercomenableData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 195 - ::IntercomenableData::mIntercomenable
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::IntercomenableData, mIntercomenable)
    },
    {   // 196 - ::AddCallEnableData
        COURIER_DATA_ITEM_TYPE_ID(::AddCallEnableData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 197 - ::AddCallEnableData::mAddCallEnable
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::AddCallEnableData, mAddCallEnable)
    },
    {   // 198 - ::SpeedLockData
        COURIER_DATA_ITEM_TYPE_ID(::SpeedLockData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 199 - ::SpeedLockData::mSpeedLockStatus
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SpeedLockData, mSpeedLockStatus)
    },
    {   // 200 - ::SpeedLockData::mDialPadCallButtonStatus
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SpeedLockData, mDialPadCallButtonStatus)
    },
    {   // 201 - ::ListScrollBarInfoData
        COURIER_DATA_ITEM_TYPE_ID(::ListScrollBarInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 202 - ::ListScrollBarInfoData::mEnabled
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::ListScrollBarInfoData, mEnabled)
    },
};

// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gInvalidHierarchyNodes[InvalidDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x00000000, /Invalid),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 0,
        /* mParentIndex        */ 0,    // ItemKey::InvalidItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 0,    // ::InvalidData
        /* mItemKey            */ 0
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gListId_FlexHierarchyNodes[ListId_FlexDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x2C21DEEA, /ListId_Flex),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::ListId_FlexItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 1,    // ::ListId_FlexData
        /* mItemKey            */ 26
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x9C3EC3C9, /ListId_Flex/PairedDeviceListId),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode) | ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::ReadOnly),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::ListId_FlexItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 2,    // ::ListId_FlexData::mPairedDeviceListId
        /* mItemKey            */ 118
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x389918EA, /ListId_Flex/PhoneContactListId),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode) | ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::ReadOnly),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::ListId_FlexItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 3,    // ::ListId_FlexData::mPhoneContactListId
        /* mItemKey            */ 35
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5DE9C0E2, /ListId_Flex/MatchListId),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode) | ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::ReadOnly),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::ListId_FlexItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 4,    // ::ListId_FlexData::mMatchListId
        /* mItemKey            */ 61
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE252DA92, /ListId_Flex/ContactCallListId),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode) | ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::ReadOnly),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::ListId_FlexItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 5,    // ::ListId_FlexData::mContactCallListId
        /* mItemKey            */ 174
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x60E524A5, /ListId_Flex/CallListId),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode) | ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::ReadOnly),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::ListId_FlexItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 6,    // ::ListId_FlexData::mCallListId
        /* mItemKey            */ 65
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xAA5B3EAE, /ListId_Flex/SettingListId),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode) | ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::ReadOnly),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::ListId_FlexItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 7,    // ::ListId_FlexData::mSettingListId
        /* mItemKey            */ 124
    },
    { // 7
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x76627F93, /ListId_Flex/DropDownListId),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode) | ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::ReadOnly),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::ListId_FlexItem
        /* mLocalIndex         */ 7,
        /* mDescriptorIndex    */ 8,    // ::ListId_FlexData::mDropDownListId
        /* mItemKey            */ 79
    },
    { // 8
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xCA245903, /ListId_Flex/IntercomContactsListId),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode) | ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::ReadOnly),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::ListId_FlexItem
        /* mLocalIndex         */ 8,
        /* mDescriptorIndex    */ 9,    // ::ListId_FlexData::mIntercomContactsListId
        /* mItemKey            */ 153
    },
    { // 9
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x1F79F23D, /ListId_Flex/IntercomConfCallListId),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode) | ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::ReadOnly),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::ListId_FlexItem
        /* mLocalIndex         */ 9,
        /* mDescriptorIndex    */ 10,    // ::ListId_FlexData::mIntercomConfCallListId
        /* mItemKey            */ 16
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gListDataSizeHierarchyNodes[ListDataSizeDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x1F89D3F0, /ListDataSize),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 2,
        /* mParentIndex        */ 0,    // ItemKey::ListDataSizeItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 11,    // ::ListDataSizeData
        /* mItemKey            */ 17
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x73CFC111, /ListDataSize/PairedDeviceListSize),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 2,
        /* mParentIndex        */ 0,    // ItemKey::ListDataSizeItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 12,    // ::ListDataSizeData::mPairedDeviceListSize
        /* mItemKey            */ 75
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA0310BE2, /ListDataSize/ContactListSize),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 2,
        /* mParentIndex        */ 0,    // ItemKey::ListDataSizeItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 13,    // ::ListDataSizeData::mContactListSize
        /* mItemKey            */ 119
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB09BF1C7, /ListDataSize/MatchListSize),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 2,
        /* mParentIndex        */ 0,    // ItemKey::ListDataSizeItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 14,    // ::ListDataSizeData::mMatchListSize
        /* mItemKey            */ 129
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD7DFEF33, /ListDataSize/ContactCallListSize),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 2,
        /* mParentIndex        */ 0,    // ItemKey::ListDataSizeItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 15,    // ::ListDataSizeData::mContactCallListSize
        /* mItemKey            */ 166
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x13D0BBBF, /ListDataSize/CallListSize),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 2,
        /* mParentIndex        */ 0,    // ItemKey::ListDataSizeItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 16,    // ::ListDataSizeData::mCallListSize
        /* mItemKey            */ 12
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC39C1167, /ListDataSize/SortOrderSize),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 2,
        /* mParentIndex        */ 0,    // ItemKey::ListDataSizeItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 17,    // ::ListDataSizeData::mSortOrderSize
        /* mItemKey            */ 147
    },
    { // 7
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB812C1AA, /ListDataSize/IContactsSize),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 2,
        /* mParentIndex        */ 0,    // ItemKey::ListDataSizeItem
        /* mLocalIndex         */ 7,
        /* mDescriptorIndex    */ 18,    // ::ListDataSizeData::mIContactsSize
        /* mItemKey            */ 137
    },
    { // 8
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x60DD3CF7, /ListDataSize/IConfCallSize),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 2,
        /* mParentIndex        */ 0,    // ItemKey::ListDataSizeItem
        /* mLocalIndex         */ 8,
        /* mDescriptorIndex    */ 19,    // ::ListDataSizeData::mIConfCallSize
        /* mItemKey            */ 64
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gPairedDevice_ListItemHierarchyNodes[PairedDevice_ListItemDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x10FF3495, /PairedDevice_ListItem),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 3,
        /* mParentIndex        */ 0,    // ItemKey::PairedDevice_ListItemItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 20,    // ::PairedDevice_ListItemData
        /* mItemKey            */ 8
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB9DA08B8, /PairedDevice_ListItem/DeviceTypeIndex),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 3,
        /* mParentIndex        */ 0,    // ItemKey::PairedDevice_ListItemItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 21,    // ::PairedDevice_ListItemData::mDeviceTypeIndex
        /* mItemKey            */ 140
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x300F62E3, /PairedDevice_ListItem/DeviceName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 3,
        /* mParentIndex        */ 0,    // ItemKey::PairedDevice_ListItemItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 22,    // ::PairedDevice_ListItemData::mDeviceName
        /* mItemKey            */ 29
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7F204191, /PairedDevice_ListItem/ProfilePhone),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 3,
        /* mParentIndex        */ 0,    // ItemKey::PairedDevice_ListItemItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 23,    // ::PairedDevice_ListItemData::mProfilePhone
        /* mItemKey            */ 90
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB272701D, /PairedDevice_ListItem/ProfileAudio),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 3,
        /* mParentIndex        */ 0,    // ItemKey::PairedDevice_ListItemItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 24,    // ::PairedDevice_ListItemData::mProfileAudio
        /* mItemKey            */ 131
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xDF129B1F, /PairedDevice_ListItem/BTIcon),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 3,
        /* mParentIndex        */ 0,    // ItemKey::PairedDevice_ListItemItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 25,    // ::PairedDevice_ListItemData::mBTIcon
        /* mItemKey            */ 171
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x8CA33B52, /PairedDevice_ListItem/DeviceNameTxtColor),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode) | ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::ReadOnly),
        /* mBindingSourceIndex */ 3,
        /* mParentIndex        */ 0,    // ItemKey::PairedDevice_ListItemItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 26,    // ::PairedDevice_ListItemData::mDeviceNameTxtColor
        /* mItemKey            */ 104
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gCallList_ListItemHierarchyNodes[CallList_ListItemDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5E02A5FC, /CallList_ListItem),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 4,
        /* mParentIndex        */ 0,    // ItemKey::CallList_ListItemItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 27,    // ::CallList_ListItemData
        /* mItemKey            */ 62
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x90D72E53, /CallList_ListItem/CallInfoIcon),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 4,
        /* mParentIndex        */ 0,    // ItemKey::CallList_ListItemItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 28,    // ::CallList_ListItemData::mCallInfoIcon
        /* mItemKey            */ 108
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB4E9C8FB, /CallList_ListItem/CallerName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 4,
        /* mParentIndex        */ 0,    // ItemKey::CallList_ListItemItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 29,    // ::CallList_ListItemData::mCallerName
        /* mItemKey            */ 136
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xFA8C8977, /CallList_ListItem/CallNumberOfTimes),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 4,
        /* mParentIndex        */ 0,    // ItemKey::CallList_ListItemItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 30,    // ::CallList_ListItemData::mCallNumberOfTimes
        /* mItemKey            */ 197
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3F5DE70F, /CallList_ListItem/CallDate),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 4,
        /* mParentIndex        */ 0,    // ItemKey::CallList_ListItemItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 31,    // ::CallList_ListItemData::mCallDate
        /* mItemKey            */ 40
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xCD0F8D48, /CallList_ListItem/CallListFocusIndex),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 4,
        /* mParentIndex        */ 0,    // ItemKey::CallList_ListItemItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 32,    // ::CallList_ListItemData::mCallListFocusIndex
        /* mItemKey            */ 156
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gContactList_ListItemHierarchyNodes[ContactList_ListItemDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x80B9D274, /ContactList_ListItem),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 5,
        /* mParentIndex        */ 0,    // ItemKey::ContactList_ListItemItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 33,    // ::ContactList_ListItemData
        /* mItemKey            */ 91
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x98BE94A8, /ContactList_ListItem/ContactName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 5,
        /* mParentIndex        */ 0,    // ItemKey::ContactList_ListItemItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 34,    // ::ContactList_ListItemData::mContactName
        /* mItemKey            */ 113
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x2F1D25E6, /ContactList_ListItem/PhoneNumberCount),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 5,
        /* mParentIndex        */ 0,    // ItemKey::ContactList_ListItemItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 35,    // ::ContactList_ListItemData::mPhoneNumberCount
        /* mItemKey            */ 28
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x2756376B, /ContactList_ListItem/ContactsFocusIndex),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 5,
        /* mParentIndex        */ 0,    // ItemKey::ContactList_ListItemItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 36,    // ::ContactList_ListItemData::mContactsFocusIndex
        /* mItemKey            */ 22
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gMatchList_ListItemHierarchyNodes[MatchList_ListItemDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x8C73D7DD, /MatchList_ListItem),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 6,
        /* mParentIndex        */ 0,    // ItemKey::MatchList_ListItemItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 37,    // ::MatchList_ListItemData
        /* mItemKey            */ 102
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x8E3ECA4A, /MatchList_ListItem/MatchedNumber),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 6,
        /* mParentIndex        */ 0,    // ItemKey::MatchList_ListItemItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 38,    // ::MatchList_ListItemData::mMatchedNumber
        /* mItemKey            */ 106
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA476D36C, /MatchList_ListItem/MatchedContactName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 6,
        /* mParentIndex        */ 0,    // ItemKey::MatchList_ListItemItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 39,    // ::MatchList_ListItemData::mMatchedContactName
        /* mItemKey            */ 121
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gIContactsList_ListItemHierarchyNodes[IContactsList_ListItemDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3D0E06F9, /IContactsList_ListItem),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 7,
        /* mParentIndex        */ 0,    // ItemKey::IContactsList_ListItemItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 40,    // ::IContactsList_ListItemData
        /* mItemKey            */ 37
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x10D63AD0, /IContactsList_ListItem/IContactName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 7,
        /* mParentIndex        */ 0,    // ItemKey::IContactsList_ListItemItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 41,    // ::IContactsList_ListItemData::mIContactName
        /* mItemKey            */ 7
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE5E6DCF4, /IContactsList_ListItem/IContacttype),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 7,
        /* mParentIndex        */ 0,    // ItemKey::IContactsList_ListItemItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 42,    // ::IContactsList_ListItemData::mIContacttype
        /* mItemKey            */ 179
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x4F28B29F, /IContactsList_ListItem/ICallStatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 7,
        /* mParentIndex        */ 0,    // ItemKey::IContactsList_ListItemItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 43,    // ::IContactsList_ListItemData::mICallStatus
        /* mItemKey            */ 47
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gIntercom_SupportStatusHierarchyNodes[Intercom_SupportStatusDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3C9ECD32, /Intercom_SupportStatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 8,
        /* mParentIndex        */ 0,    // ItemKey::Intercom_SupportStatusItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 44,    // ::Intercom_SupportStatusData
        /* mItemKey            */ 36
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7D29BEAF, /Intercom_SupportStatus/Intercom_Supported),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 8,
        /* mParentIndex        */ 0,    // ItemKey::Intercom_SupportStatusItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 45,    // ::Intercom_SupportStatusData::mIntercom_Supported
        /* mItemKey            */ 87
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x0D842CFF, /Intercom_SupportStatus/Intercom_NotSupported),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 8,
        /* mParentIndex        */ 0,    // ItemKey::Intercom_SupportStatusItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 46,    // ::Intercom_SupportStatusData::mIntercom_NotSupported
        /* mItemKey            */ 5
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gContactCall_ListItemHierarchyNodes[ContactCall_ListItemDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xDE8BB3DA, /ContactCall_ListItem),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 9,
        /* mParentIndex        */ 0,    // ItemKey::ContactCall_ListItemItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 47,    // ::ContactCall_ListItemData
        /* mItemKey            */ 170
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF9681496, /ContactCall_ListItem/ContactInfoIcon),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 9,
        /* mParentIndex        */ 0,    // ItemKey::ContactCall_ListItemItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 48,    // ::ContactCall_ListItemData::mContactInfoIcon
        /* mItemKey            */ 196
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB0241029, /ContactCall_ListItem/ContactPhoneNumber),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 9,
        /* mParentIndex        */ 0,    // ItemKey::ContactCall_ListItemItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 49,    // ::ContactCall_ListItemData::mContactPhoneNumber
        /* mItemKey            */ 128
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x4851E172, /ContactCall_ListItem/PrimaryIcon),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 9,
        /* mParentIndex        */ 0,    // ItemKey::ContactCall_ListItemItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 50,    // ::ContactCall_ListItemData::mPrimaryIcon
        /* mItemKey            */ 44
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gViewPortStartIndexHierarchyNodes[ViewPortStartIndexDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC59105BC, /ViewPortStartIndex),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 10,
        /* mParentIndex        */ 0,    // ItemKey::ViewPortStartIndexItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 51,    // ::ViewPortStartIndexData
        /* mItemKey            */ 149
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x662E10AC, /ViewPortStartIndex/ContactListIndex),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 10,
        /* mParentIndex        */ 0,    // ItemKey::ViewPortStartIndexItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 52,    // ::ViewPortStartIndexData::mContactListIndex
        /* mItemKey            */ 67
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gConnectedActiveBTDeviceNameHierarchyNodes[ConnectedActiveBTDeviceNameDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x014A77B0, /ConnectedActiveBTDeviceName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 11,
        /* mParentIndex        */ 0,    // ItemKey::ConnectedActiveBTDeviceNameItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 53,    // ::ConnectedActiveBTDeviceNameData
        /* mItemKey            */ 2
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x6E1305C3, /ConnectedActiveBTDeviceName/DeviceName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 11,
        /* mParentIndex        */ 0,    // ItemKey::ConnectedActiveBTDeviceNameItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 54,    // ::ConnectedActiveBTDeviceNameData::mDeviceName
        /* mItemKey            */ 73
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gConnectedBTDeviceNameHierarchyNodes[ConnectedBTDeviceNameDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x508DB4C8, /ConnectedBTDeviceName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 12,
        /* mParentIndex        */ 0,    // ItemKey::ConnectedBTDeviceNameItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 55,    // ::ConnectedBTDeviceNameData
        /* mItemKey            */ 48
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB86097B8, /ConnectedBTDeviceName/DeviceName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 12,
        /* mParentIndex        */ 0,    // ItemKey::ConnectedBTDeviceNameItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 56,    // ::ConnectedBTDeviceNameData::mDeviceName
        /* mItemKey            */ 138
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gDisconnectedBTDeviceNameHierarchyNodes[DisconnectedBTDeviceNameDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xAD626746, /DisconnectedBTDeviceName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 13,
        /* mParentIndex        */ 0,    // ItemKey::DisconnectedBTDeviceNameItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 57,    // ::DisconnectedBTDeviceNameData
        /* mItemKey            */ 125
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF4B9342C, /DisconnectedBTDeviceName/DeviceName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 13,
        /* mParentIndex        */ 0,    // ItemKey::DisconnectedBTDeviceNameItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 58,    // ::DisconnectedBTDeviceNameData::mDeviceName
        /* mItemKey            */ 191
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gVarientTypeHierarchyNodes[VarientTypeDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x05D58FDC, /VarientType),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 14,
        /* mParentIndex        */ 0,    // ItemKey::VarientTypeItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 59,    // ::VarientTypeData
        /* mItemKey            */ 3
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xFF85B73E, /VarientType/SwitcherIndex),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 14,
        /* mParentIndex        */ 0,    // ItemKey::VarientTypeItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 60,    // ::VarientTypeData::mSwitcherIndex
        /* mItemKey            */ 202
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE8C748D8, /VarientType/EnableNavi),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 14,
        /* mParentIndex        */ 0,    // ItemKey::VarientTypeItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 61,    // ::VarientTypeData::mEnableNavi
        /* mItemKey            */ 181
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSPIStatusHierarchyNodes[SPIStatusDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE4A19BDA, /SPIStatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 15,
        /* mParentIndex        */ 0,    // ItemKey::SPIStatusItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 62,    // ::SPIStatusData
        /* mItemKey            */ 177
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x6B2F8D13, /SPIStatus/EnableSPI),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 15,
        /* mParentIndex        */ 0,    // ItemKey::SPIStatusItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 63,    // ::SPIStatusData::mEnableSPI
        /* mItemKey            */ 72
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gIsListNotemptyHierarchyNodes[IsListNotemptyDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xDD525D83, /IsListNotempty),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 16,
        /* mParentIndex        */ 0,    // ItemKey::IsListNotemptyItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 64,    // ::IsListNotemptyData
        /* mItemKey            */ 169
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7926E0F3, /IsListNotempty/CallList),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 16,
        /* mParentIndex        */ 0,    // ItemKey::IsListNotemptyItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 65,    // ::IsListNotemptyData::mCallList
        /* mItemKey            */ 82
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x68B00414, /IsListNotempty/ContactList),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 16,
        /* mParentIndex        */ 0,    // ItemKey::IsListNotemptyItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 66,    // ::IsListNotemptyData::mContactList
        /* mItemKey            */ 68
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gContactCallNameHierarchyNodes[ContactCallNameDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x082A7BE5, /ContactCallName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 17,
        /* mParentIndex        */ 0,    // ItemKey::ContactCallNameItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 67,    // ::ContactCallNameData
        /* mItemKey            */ 4
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x8985C335, /ContactCallName/CallerName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 17,
        /* mParentIndex        */ 0,    // ItemKey::ContactCallNameItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 68,    // ::ContactCallNameData::mCallerName
        /* mItemKey            */ 98
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gFriendlyVehicleNameHierarchyNodes[FriendlyVehicleNameDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x83F89578, /FriendlyVehicleName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 18,
        /* mParentIndex        */ 0,    // ItemKey::FriendlyVehicleNameItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 69,    // ::FriendlyVehicleNameData
        /* mItemKey            */ 94
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x45EA9565, /FriendlyVehicleName/HUDName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 18,
        /* mParentIndex        */ 0,    // ItemKey::FriendlyVehicleNameItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 70,    // ::FriendlyVehicleNameData::mHUDName
        /* mItemKey            */ 43
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gPairingDeviceInfoHierarchyNodes[PairingDeviceInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x993E2DD8, /PairingDeviceInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 19,
        /* mParentIndex        */ 0,    // ItemKey::PairingDeviceInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 71,    // ::PairingDeviceInfoData
        /* mItemKey            */ 114
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC99D1246, /PairingDeviceInfo/DeviceName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 19,
        /* mParentIndex        */ 0,    // ItemKey::PairingDeviceInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 72,    // ::PairingDeviceInfoData::mDeviceName
        /* mItemKey            */ 152
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC19A1A05, /PairingDeviceInfo/PairingPIN),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 19,
        /* mParentIndex        */ 0,    // ItemKey::PairingDeviceInfoItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 73,    // ::PairingDeviceInfoData::mPairingPIN
        /* mItemKey            */ 145
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gDeviceInfoHierarchyNodes[DeviceInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB44A0604, /DeviceInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 20,
        /* mParentIndex        */ 0,    // ItemKey::DeviceInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 74,    // ::DeviceInfoData
        /* mItemKey            */ 134
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xFD403990, /DeviceInfo/DeviceName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 20,
        /* mParentIndex        */ 0,    // ItemKey::DeviceInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 75,    // ::DeviceInfoData::mDeviceName
        /* mItemKey            */ 198
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gMatchedItemsHierarchyNodes[MatchedItemsDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x30A4AC03, /MatchedItems),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 21,
        /* mParentIndex        */ 0,    // ItemKey::MatchedItemsItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 76,    // ::MatchedItemsData
        /* mItemKey            */ 30
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x1218CFDF, /MatchedItems/Count),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 21,
        /* mParentIndex        */ 0,    // ItemKey::MatchedItemsItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 77,    // ::MatchedItemsData::mCount
        /* mItemKey            */ 9
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gPhoneButtonTextHierarchyNodes[PhoneButtonTextDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xFECF1A54, /PhoneButtonText),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 22,
        /* mParentIndex        */ 0,    // ItemKey::PhoneButtonTextItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 78,    // ::PhoneButtonTextData
        /* mItemKey            */ 200
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x9B1CC36D, /PhoneButtonText/Source),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 22,
        /* mParentIndex        */ 0,    // ItemKey::PhoneButtonTextItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 79,    // ::PhoneButtonTextData::mSource
        /* mItemKey            */ 116
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gMicEnableHierarchyNodes[MicEnableDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x583F3BA8, /MicEnable),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 23,
        /* mParentIndex        */ 0,    // ItemKey::MicEnableItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 80,    // ::MicEnableData
        /* mItemKey            */ 53
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xEA42A52E, /MicEnable/IsSelected),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 23,
        /* mParentIndex        */ 0,    // ItemKey::MicEnableItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 81,    // ::MicEnableData::mIsSelected
        /* mItemKey            */ 182
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF009308D, /MicEnable/Enabled),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 23,
        /* mParentIndex        */ 0,    // ItemKey::MicEnableItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 82,    // ::MicEnableData::mEnabled
        /* mItemKey            */ 188
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gVehicleAudioStatusHierarchyNodes[VehicleAudioStatusDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x535A7E3E, /VehicleAudioStatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 24,
        /* mParentIndex        */ 0,    // ItemKey::VehicleAudioStatusItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 83,    // ::VehicleAudioStatusData
        /* mItemKey            */ 50
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x238B7327, /VehicleAudioStatus/IsSelected),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 24,
        /* mParentIndex        */ 0,    // ItemKey::VehicleAudioStatusItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 84,    // ::VehicleAudioStatusData::mIsSelected
        /* mItemKey            */ 20
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gPrivateModeStatusHierarchyNodes[PrivateModeStatusDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x15C95B85, /PrivateModeStatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 25,
        /* mParentIndex        */ 0,    // ItemKey::PrivateModeStatusItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 85,    // ::PrivateModeStatusData
        /* mItemKey            */ 14
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xCB205788, /PrivateModeStatus/IsSelected),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 25,
        /* mParentIndex        */ 0,    // ItemKey::PrivateModeStatusItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 86,    // ::PrivateModeStatusData::mIsSelected
        /* mItemKey            */ 154
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSettingsHierarchyNodes[SettingsDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x71A718A4, /Settings),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 26,
        /* mParentIndex        */ 0,    // ItemKey::SettingsItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 87,    // ::SettingsData
        /* mItemKey            */ 74
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD00D3C46, /Settings/UsePhoneRingtone_IsSelected),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 26,
        /* mParentIndex        */ 0,    // ItemKey::SettingsItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 88,    // ::SettingsData::mUsePhoneRingtone_IsSelected
        /* mItemKey            */ 158
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x75A8D66C, /Settings/ShowIncomingText_IsSelected),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 26,
        /* mParentIndex        */ 0,    // ItemKey::SettingsItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 89,    // ::SettingsData::mShowIncomingText_IsSelected
        /* mItemKey            */ 77
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x280B9107, /Settings/SortPhoneBookTypeText),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 26,
        /* mParentIndex        */ 0,    // ItemKey::SettingsItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 90,    // ::SettingsData::mSortPhoneBookTypeText
        /* mItemKey            */ 23
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x2C344492, /Settings/SelectedLine),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 26,
        /* mParentIndex        */ 0,    // ItemKey::SettingsItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 91,    // ::SettingsData::mSelectedLine
        /* mItemKey            */ 27
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD375DDF3, /Settings/IsInBandSupported),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 26,
        /* mParentIndex        */ 0,    // ItemKey::SettingsItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 92,    // ::SettingsData::mIsInBandSupported
        /* mItemKey            */ 164
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x796C6EF9, /Settings/EnableDisableSortOrder),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 26,
        /* mParentIndex        */ 0,    // ItemKey::SettingsItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 93,    // ::SettingsData::mEnableDisableSortOrder
        /* mItemKey            */ 84
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gCallProgressHierarchyNodes[CallProgressDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x1008E207, /CallProgress),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 27,
        /* mParentIndex        */ 0,    // ItemKey::CallProgressItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 94,    // ::CallProgressData
        /* mItemKey            */ 6
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x791666C6, /CallProgress/CallDuration),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 27,
        /* mParentIndex        */ 0,    // ItemKey::CallProgressItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 95,    // ::CallProgressData::mCallDuration
        /* mItemKey            */ 81
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7A9ECCBE, /CallProgress/CallerID),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 27,
        /* mParentIndex        */ 0,    // ItemKey::CallProgressItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 96,    // ::CallProgressData::mCallerID
        /* mItemKey            */ 85
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x337414B0, /CallProgress/ContactType),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 27,
        /* mParentIndex        */ 0,    // ItemKey::CallProgressItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 97,    // ::CallProgressData::mContactType
        /* mItemKey            */ 33
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xAFCC3E4E, /CallProgress/CallStatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 27,
        /* mParentIndex        */ 0,    // ItemKey::CallProgressItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 98,    // ::CallProgressData::mCallStatus
        /* mItemKey            */ 127
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3185FEB0, /CallProgress/GadgetCallerID),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 27,
        /* mParentIndex        */ 0,    // ItemKey::CallProgressItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 99,    // ::CallProgressData::mGadgetCallerID
        /* mItemKey            */ 32
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gIntercomIncomingCallHierarchyNodes[IntercomIncomingCallDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC27AAAA9, /IntercomIncomingCall),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 28,
        /* mParentIndex        */ 0,    // ItemKey::IntercomIncomingCallItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 100,    // ::IntercomIncomingCallData
        /* mItemKey            */ 146
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD24765FC, /IntercomIncomingCall/CallerID),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 28,
        /* mParentIndex        */ 0,    // ItemKey::IntercomIncomingCallItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 101,    // ::IntercomIncomingCallData::mCallerID
        /* mItemKey            */ 161
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5E1D6505, /IntercomIncomingCall/ContactType),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 28,
        /* mParentIndex        */ 0,    // ItemKey::IntercomIncomingCallItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 102,    // ::IntercomIncomingCallData::mContactType
        /* mItemKey            */ 63
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gIntercomMissedIncomingCallHierarchyNodes[IntercomMissedIncomingCallDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5C4E5575, /IntercomMissedIncomingCall),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 29,
        /* mParentIndex        */ 0,    // ItemKey::IntercomMissedIncomingCallItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 103,    // ::IntercomMissedIncomingCallData
        /* mItemKey            */ 59
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA1BAB393, /IntercomMissedIncomingCall/MissedCallerInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 29,
        /* mParentIndex        */ 0,    // ItemKey::IntercomMissedIncomingCallItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 104,    // ::IntercomMissedIncomingCallData::mMissedCallerInfo
        /* mItemKey            */ 120
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gIntercomCallProgressHierarchyNodes[IntercomCallProgressDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xBEF55EA7, /IntercomCallProgress),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 30,
        /* mParentIndex        */ 0,    // ItemKey::IntercomCallProgressItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 105,    // ::IntercomCallProgressData
        /* mItemKey            */ 143
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x6A0E9E92, /IntercomCallProgress/CallerID),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 30,
        /* mParentIndex        */ 0,    // ItemKey::IntercomCallProgressItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 106,    // ::IntercomCallProgressData::mCallerID
        /* mItemKey            */ 70
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x90527177, /IntercomCallProgress/ContactType),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 30,
        /* mParentIndex        */ 0,    // ItemKey::IntercomCallProgressItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 107,    // ::IntercomCallProgressData::mContactType
        /* mItemKey            */ 107
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gIntercomConfCallHierarchyNodes[IntercomConfCallDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x1FBB8BAF, /IntercomConfCall),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 31,
        /* mParentIndex        */ 0,    // ItemKey::IntercomConfCallItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 108,    // ::IntercomConfCallData
        /* mItemKey            */ 18
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x89417397, /IntercomConfCall/CallerID),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 31,
        /* mParentIndex        */ 0,    // ItemKey::IntercomConfCallItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 109,    // ::IntercomConfCallData::mCallerID
        /* mItemKey            */ 96
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xFDFD8A5D, /IntercomConfCall/ContactType),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 31,
        /* mParentIndex        */ 0,    // ItemKey::IntercomConfCallItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 110,    // ::IntercomConfCallData::mContactType
        /* mItemKey            */ 199
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE68B7C05, /IntercomConfCall/CallStatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 31,
        /* mParentIndex        */ 0,    // ItemKey::IntercomConfCallItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 111,    // ::IntercomConfCallData::mCallStatus
        /* mItemKey            */ 180
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gPhoneStatusHierarchyNodes[PhoneStatusDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x14857821, /PhoneStatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 32,
        /* mParentIndex        */ 0,    // ItemKey::PhoneStatusItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 112,    // ::PhoneStatusData
        /* mItemKey            */ 13
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x9ADBD507, /PhoneStatus/BatteryStatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 32,
        /* mParentIndex        */ 0,    // ItemKey::PhoneStatusItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 113,    // ::PhoneStatusData::mBatteryStatus
        /* mItemKey            */ 115
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xDBE00E54, /PhoneStatus/SignalStatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 32,
        /* mParentIndex        */ 0,    // ItemKey::PhoneStatusItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 114,    // ::PhoneStatusData::mSignalStatus
        /* mItemKey            */ 168
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xDFEF5AE0, /PhoneStatus/NetworkStatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 32,
        /* mParentIndex        */ 0,    // ItemKey::PhoneStatusItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 115,    // ::PhoneStatusData::mNetworkStatus
        /* mItemKey            */ 173
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE5BDCCB6, /PhoneStatus/MissedCallStatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 32,
        /* mParentIndex        */ 0,    // ItemKey::PhoneStatusItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 116,    // ::PhoneStatusData::mMissedCallStatus
        /* mItemKey            */ 178
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x4867166C, /PhoneStatus/SignalStatusinGadget),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 32,
        /* mParentIndex        */ 0,    // ItemKey::PhoneStatusItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 117,    // ::PhoneStatusData::mSignalStatusinGadget
        /* mItemKey            */ 45
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD47E8F4E, /PhoneStatus/BatteryStatusinGadget),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 32,
        /* mParentIndex        */ 0,    // ItemKey::PhoneStatusItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 118,    // ::PhoneStatusData::mBatteryStatusinGadget
        /* mItemKey            */ 165
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gValidCharSetHierarchyNodes[ValidCharSetDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x4CE6BBC4, /ValidCharSet),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 33,
        /* mParentIndex        */ 0,    // ItemKey::ValidCharSetItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 119,    // ::ValidCharSetData
        /* mItemKey            */ 46
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC8E2059C, /ValidCharSet/CharacterSet),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 33,
        /* mParentIndex        */ 0,    // ItemKey::ValidCharSetItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 120,    // ::ValidCharSetData::mCharacterSet
        /* mItemKey            */ 151
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSuggesstionTextHierarchyNodes[SuggesstionTextDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xDFE51693, /SuggesstionText),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 34,
        /* mParentIndex        */ 0,    // ItemKey::SuggesstionTextItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 121,    // ::SuggesstionTextData
        /* mItemKey            */ 172
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x8235D469, /SuggesstionText/Text),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 34,
        /* mParentIndex        */ 0,    // ItemKey::SuggesstionTextItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 122,    // ::SuggesstionTextData::mText
        /* mItemKey            */ 92
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gEntryTextHierarchyNodes[EntryTextDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x24EEC068, /EntryText),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 35,
        /* mParentIndex        */ 0,    // ItemKey::EntryTextItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 123,    // ::EntryTextData
        /* mItemKey            */ 21
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x8340EEE6, /EntryText/Text),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 35,
        /* mParentIndex        */ 0,    // ItemKey::EntryTextItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 124,    // ::EntryTextData::mText
        /* mItemKey            */ 93
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gPhoneDialPadInputTextHierarchyNodes[PhoneDialPadInputTextDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xEBDC97D1, /PhoneDialPadInputText),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 36,
        /* mParentIndex        */ 0,    // ItemKey::PhoneDialPadInputTextItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 125,    // ::PhoneDialPadInputTextData
        /* mItemKey            */ 184
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB4325280, /PhoneDialPadInputText/Text),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 36,
        /* mParentIndex        */ 0,    // ItemKey::PhoneDialPadInputTextItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 126,    // ::PhoneDialPadInputTextData::mText
        /* mItemKey            */ 133
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gBTTelltalesHierarchyNodes[BTTelltalesDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x58F3F957, /BTTelltales),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 37,
        /* mParentIndex        */ 0,    // ItemKey::BTTelltalesItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 127,    // ::BTTelltalesData
        /* mItemKey            */ 54
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x8C98B0DC, /BTTelltales/ImagePath),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 37,
        /* mParentIndex        */ 0,    // ItemKey::BTTelltalesItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 128,    // ::BTTelltalesData::mImagePath
        /* mItemKey            */ 103
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x9B30849E, /BTTelltales/LoadAssetBitmap),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 37,
        /* mParentIndex        */ 0,    // ItemKey::BTTelltalesItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 129,    // ::BTTelltalesData::mLoadAssetBitmap
        /* mItemKey            */ 117
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gRoamingHierarchyNodes[RoamingDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x59822FA4, /Roaming),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 38,
        /* mParentIndex        */ 0,    // ItemKey::RoamingItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 130,    // ::RoamingData
        /* mItemKey            */ 56
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x91348A56, /Roaming/Enabled),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 38,
        /* mParentIndex        */ 0,    // ItemKey::RoamingItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 131,    // ::RoamingData::mEnabled
        /* mItemKey            */ 110
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gDialButtonHierarchyNodes[DialButtonDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD01E2A50, /DialButton),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 39,
        /* mParentIndex        */ 0,    // ItemKey::DialButtonItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 132,    // ::DialButtonData
        /* mItemKey            */ 159
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD30879C3, /DialButton/Enabled),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 39,
        /* mParentIndex        */ 0,    // ItemKey::DialButtonItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 133,    // ::DialButtonData::mEnabled
        /* mItemKey            */ 163
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gMatchListHierarchyNodes[MatchListDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xED95047F, /MatchList),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 40,
        /* mParentIndex        */ 0,    // ItemKey::MatchListItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 134,    // ::MatchListData
        /* mItemKey            */ 186
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xEA5BD196, /MatchList/Enabled),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 40,
        /* mParentIndex        */ 0,    // ItemKey::MatchListItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 135,    // ::MatchListData::mEnabled
        /* mItemKey            */ 183
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gDialPadButtonHierarchyNodes[DialPadButtonDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF1B605C2, /DialPadButton),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 41,
        /* mParentIndex        */ 0,    // ItemKey::DialPadButtonItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 136,    // ::DialPadButtonData
        /* mItemKey            */ 189
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x57535D98, /DialPadButton/Enabled),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 41,
        /* mParentIndex        */ 0,    // ItemKey::DialPadButtonItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 137,    // ::DialPadButtonData::mEnabled
        /* mItemKey            */ 52
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gIsActiveHierarchyNodes[IsActiveDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3EE2D208, /IsActive),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 42,
        /* mParentIndex        */ 0,    // ItemKey::IsActiveItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 138,    // ::IsActiveData
        /* mItemKey            */ 39
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD903419D, /IsActive/IsAddPhoneDisabled),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 42,
        /* mParentIndex        */ 0,    // ItemKey::IsActiveItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 139,    // ::IsActiveData::mIsAddPhoneDisabled
        /* mItemKey            */ 167
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gPhoneGadgetInfoHierarchyNodes[PhoneGadgetInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE46845F7, /PhoneGadgetInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 43,
        /* mParentIndex        */ 0,    // ItemKey::PhoneGadgetInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 140,    // ::PhoneGadgetInfoData
        /* mItemKey            */ 176
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7DAA35D4, /PhoneGadgetInfo/PhoneHandle),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 43,
        /* mParentIndex        */ 0,    // ItemKey::PhoneGadgetInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 141,    // ::PhoneGadgetInfoData::mPhoneHandle
        /* mItemKey            */ 89
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC4F27C38, /PhoneGadgetInfo/PhoneSignalStatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 43,
        /* mParentIndex        */ 0,    // ItemKey::PhoneGadgetInfoItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 142,    // ::PhoneGadgetInfoData::mPhoneSignalStatus
        /* mItemKey            */ 148
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x8856857D, /PhoneGadgetInfo/PhoneBatteryStatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 43,
        /* mParentIndex        */ 0,    // ItemKey::PhoneGadgetInfoItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 143,    // ::PhoneGadgetInfoData::mPhoneBatteryStatus
        /* mItemKey            */ 95
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC6E58AEB, /PhoneGadgetInfo/IndexForGadgetBG),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 43,
        /* mParentIndex        */ 0,    // ItemKey::PhoneGadgetInfoItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 144,    // ::PhoneGadgetInfoData::mIndexForGadgetBG
        /* mItemKey            */ 150
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF6272816, /PhoneGadgetInfo/IndexForGadgetContent),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 43,
        /* mParentIndex        */ 0,    // ItemKey::PhoneGadgetInfoItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 145,    // ::PhoneGadgetInfoData::mIndexForGadgetContent
        /* mItemKey            */ 193
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA7F0E258, /PhoneGadgetInfo/IndexForIntercomTextInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 43,
        /* mParentIndex        */ 0,    // ItemKey::PhoneGadgetInfoItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 146,    // ::PhoneGadgetInfoData::mIndexForIntercomTextInfo
        /* mItemKey            */ 123
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gMsgProgressHierarchyNodes[MsgProgressDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF8D21274, /MsgProgress),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 44,
        /* mParentIndex        */ 0,    // ItemKey::MsgProgressItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 147,    // ::MsgProgressData
        /* mItemKey            */ 195
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x69B3E3BD, /MsgProgress/CallerID),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 44,
        /* mParentIndex        */ 0,    // ItemKey::MsgProgressItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 148,    // ::MsgProgressData::mCallerID
        /* mItemKey            */ 69
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x61A05083, /MsgProgress/TimeHour),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 44,
        /* mParentIndex        */ 0,    // ItemKey::MsgProgressItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 149,    // ::MsgProgressData::mTimeHour
        /* mItemKey            */ 66
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5B29E8DB, /MsgProgress/Subject),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 44,
        /* mParentIndex        */ 0,    // ItemKey::MsgProgressItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 150,    // ::MsgProgressData::mSubject
        /* mItemKey            */ 58
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x29615A4D, /MsgProgress/ShortMessage),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 44,
        /* mParentIndex        */ 0,    // ItemKey::MsgProgressItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 151,    // ::MsgProgressData::mShortMessage
        /* mItemKey            */ 24
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB3F09D25, /MsgProgress/ValidContact),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 44,
        /* mParentIndex        */ 0,    // ItemKey::MsgProgressItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 152,    // ::MsgProgressData::mValidContact
        /* mItemKey            */ 132
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x746230D4, /MsgProgress/PlayBackAction),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 44,
        /* mParentIndex        */ 0,    // ItemKey::MsgProgressItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 153,    // ::MsgProgressData::mPlayBackAction
        /* mItemKey            */ 76
    },
    { // 7
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7D6FFE06, /MsgProgress/IsEnableReadOutAloud),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 44,
        /* mParentIndex        */ 0,    // ItemKey::MsgProgressItem
        /* mLocalIndex         */ 7,
        /* mDescriptorIndex    */ 154,    // ::MsgProgressData::mIsEnableReadOutAloud
        /* mItemKey            */ 88
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gMultipleCallProgressHierarchyNodes[MultipleCallProgressDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x40A7B462, /MultipleCallProgress),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 45,
        /* mParentIndex        */ 0,    // ItemKey::MultipleCallProgressItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 155,    // ::MultipleCallProgressData
        /* mItemKey            */ 41
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x95DBEA9B, /MultipleCallProgress/ActiveCallerID),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 45,
        /* mParentIndex        */ 0,    // ItemKey::MultipleCallProgressItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 156,    // ::MultipleCallProgressData::mActiveCallerID
        /* mItemKey            */ 112
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5DC5CD8C, /MultipleCallProgress/OnHoldCallerID),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 45,
        /* mParentIndex        */ 0,    // ItemKey::MultipleCallProgressItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 157,    // ::MultipleCallProgressData::mOnHoldCallerID
        /* mItemKey            */ 60
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x78DAFF08, /MultipleCallProgress/ActiveCallDuration),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 45,
        /* mParentIndex        */ 0,    // ItemKey::MultipleCallProgressItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 158,    // ::MultipleCallProgressData::mActiveCallDuration
        /* mItemKey            */ 80
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x89865BBA, /MultipleCallProgress/OnHoldCallDuration),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 45,
        /* mParentIndex        */ 0,    // ItemKey::MultipleCallProgressItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 159,    // ::MultipleCallProgressData::mOnHoldCallDuration
        /* mItemKey            */ 99
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5328417E, /MultipleCallProgress/ActiveCallStatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 45,
        /* mParentIndex        */ 0,    // ItemKey::MultipleCallProgressItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 160,    // ::MultipleCallProgressData::mActiveCallStatus
        /* mItemKey            */ 49
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x8A263484, /MultipleCallProgress/OnHoldCallerStatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 45,
        /* mParentIndex        */ 0,    // ItemKey::MultipleCallProgressItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 161,    // ::MultipleCallProgressData::mOnHoldCallerStatus
        /* mItemKey            */ 100
    },
    { // 7
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xBBAE0D0C, /MultipleCallProgress/ActiveContactType),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 45,
        /* mParentIndex        */ 0,    // ItemKey::MultipleCallProgressItem
        /* mLocalIndex         */ 7,
        /* mDescriptorIndex    */ 162,    // ::MultipleCallProgressData::mActiveContactType
        /* mItemKey            */ 142
    },
    { // 8
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x2ACBEB44, /MultipleCallProgress/OnHoldContactType),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 45,
        /* mParentIndex        */ 0,    // ItemKey::MultipleCallProgressItem
        /* mLocalIndex         */ 8,
        /* mDescriptorIndex    */ 163,    // ::MultipleCallProgressData::mOnHoldContactType
        /* mItemKey            */ 25
    },
    { // 9
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x1294305F, /MultipleCallProgress/CallType),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 45,
        /* mParentIndex        */ 0,    // ItemKey::MultipleCallProgressItem
        /* mLocalIndex         */ 9,
        /* mDescriptorIndex    */ 164,    // ::MultipleCallProgressData::mCallType
        /* mItemKey            */ 11
    },
    { // 10
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7B3A2256, /MultipleCallProgress/IsEnableDialPad),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 45,
        /* mParentIndex        */ 0,    // ItemKey::MultipleCallProgressItem
        /* mLocalIndex         */ 10,
        /* mDescriptorIndex    */ 165,    // ::MultipleCallProgressData::mIsEnableDialPad
        /* mItemKey            */ 86
    },
    { // 11
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB45959A7, /MultipleCallProgress/IsEnableSwap),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 45,
        /* mParentIndex        */ 0,    // ItemKey::MultipleCallProgressItem
        /* mLocalIndex         */ 11,
        /* mDescriptorIndex    */ 166,    // ::MultipleCallProgressData::mIsEnableSwap
        /* mItemKey            */ 135
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gIncomingCallHierarchyNodes[IncomingCallDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x795E1440, /IncomingCall),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 46,
        /* mParentIndex        */ 0,    // ItemKey::IncomingCallItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 167,    // ::IncomingCallData
        /* mItemKey            */ 83
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x8DBF3660, /IncomingCall/CallerID),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 46,
        /* mParentIndex        */ 0,    // ItemKey::IncomingCallItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 168,    // ::IncomingCallData::mCallerID
        /* mItemKey            */ 105
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xEDD7F51D, /IncomingCall/ContactType),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 46,
        /* mParentIndex        */ 0,    // ItemKey::IncomingCallItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 169,    // ::IncomingCallData::mContactType
        /* mItemKey            */ 187
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF318CD33, /IncomingCall/Count),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 46,
        /* mParentIndex        */ 0,    // ItemKey::IncomingCallItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 170,    // ::IncomingCallData::mCount
        /* mItemKey            */ 190
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA799A93D, /IncomingCall/DeviceName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 46,
        /* mParentIndex        */ 0,    // ItemKey::IncomingCallItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 171,    // ::IncomingCallData::mDeviceName
        /* mItemKey            */ 122
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gNetworkOperatorHierarchyNodes[NetworkOperatorDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5A294CA4, /NetworkOperator),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 47,
        /* mParentIndex        */ 0,    // ItemKey::NetworkOperatorItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 172,    // ::NetworkOperatorData
        /* mItemKey            */ 57
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x00AD12D3, /NetworkOperator/OperatorName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 47,
        /* mParentIndex        */ 0,    // ItemKey::NetworkOperatorItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 173,    // ::NetworkOperatorData::mOperatorName
        /* mItemKey            */ 1
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xED0BF81D, /NetworkOperator/TextNodeMaxSize),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 47,
        /* mParentIndex        */ 0,    // ItemKey::NetworkOperatorItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 174,    // ::NetworkOperatorData::mTextNodeMaxSize
        /* mItemKey            */ 185
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gBTVRDeviceNameHierarchyNodes[BTVRDeviceNameDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x53C2E768, /BTVRDeviceName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 48,
        /* mParentIndex        */ 0,    // ItemKey::BTVRDeviceNameItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 175,    // ::BTVRDeviceNameData
        /* mItemKey            */ 51
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xCB5E1AD6, /BTVRDeviceName/DeviceName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 48,
        /* mParentIndex        */ 0,    // ItemKey::BTVRDeviceNameItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 176,    // ::BTVRDeviceNameData::mDeviceName
        /* mItemKey            */ 155
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gBTVRIconSRStatusHierarchyNodes[BTVRIconSRStatusDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD068E0D7, /BTVRIconSRStatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 49,
        /* mParentIndex        */ 0,    // ItemKey::BTVRIconSRStatusItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 177,    // ::BTVRIconSRStatusData
        /* mItemKey            */ 160
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC176DBC5, /BTVRIconSRStatus/IconSRStatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 49,
        /* mParentIndex        */ 0,    // ItemKey::BTVRIconSRStatusItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 178,    // ::BTVRIconSRStatusData::mIconSRStatus
        /* mItemKey            */ 144
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gBTVRIconSRStatusIndexHierarchyNodes[BTVRIconSRStatusIndexDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3EAA7C55, /BTVRIconSRStatusIndex),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 50,
        /* mParentIndex        */ 0,    // ItemKey::BTVRIconSRStatusIndexItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 179,    // ::BTVRIconSRStatusIndexData
        /* mItemKey            */ 38
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD2C80334, /BTVRIconSRStatusIndex/IconSRStatusIndex),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 50,
        /* mParentIndex        */ 0,    // ItemKey::BTVRIconSRStatusIndexItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 180,    // ::BTVRIconSRStatusIndexData::mIconSRStatusIndex
        /* mItemKey            */ 162
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gQuickScrollSearchHierarchyNodes[QuickScrollSearchDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB8E3EDC2, /QuickScrollSearch),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 51,
        /* mParentIndex        */ 0,    // ItemKey::QuickScrollSearchItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 181,    // ::QuickScrollSearchData
        /* mItemKey            */ 139
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x91294E39, /QuickScrollSearch/ScrollVisible),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 51,
        /* mParentIndex        */ 0,    // ItemKey::QuickScrollSearchItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 182,    // ::QuickScrollSearchData::mScrollVisible
        /* mItemKey            */ 109
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF58175D8, /QuickScrollSearch/ScrollSearchChar),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 51,
        /* mParentIndex        */ 0,    // ItemKey::QuickScrollSearchItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 183,    // ::QuickScrollSearchData::mScrollSearchChar
        /* mItemKey            */ 192
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gLoadingAnimationInfoHierarchyNodes[LoadingAnimationInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x6A94829B, /LoadingAnimationInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 52,
        /* mParentIndex        */ 0,    // ItemKey::LoadingAnimationInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 184,    // ::LoadingAnimationInfoData
        /* mItemKey            */ 71
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3178D738, /LoadingAnimationInfo/Channel1_Phonebook),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 52,
        /* mParentIndex        */ 0,    // ItemKey::LoadingAnimationInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 185,    // ::LoadingAnimationInfoData::mChannel1_Phonebook
        /* mItemKey            */ 31
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x93CEE6D3, /LoadingAnimationInfo/Channel1_Calllist),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 52,
        /* mParentIndex        */ 0,    // ItemKey::LoadingAnimationInfoItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 186,    // ::LoadingAnimationInfoData::mChannel1_Calllist
        /* mItemKey            */ 111
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB136C6DA, /LoadingAnimationInfo/Channel2_Phonebook),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 52,
        /* mParentIndex        */ 0,    // ItemKey::LoadingAnimationInfoItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 187,    // ::LoadingAnimationInfoData::mChannel2_Phonebook
        /* mItemKey            */ 130
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x596AA0EF, /LoadingAnimationInfo/Channel2_Calllist),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 52,
        /* mParentIndex        */ 0,    // ItemKey::LoadingAnimationInfoItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 188,    // ::LoadingAnimationInfoData::mChannel2_Calllist
        /* mItemKey            */ 55
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gAndroidAutoSessionInfoHierarchyNodes[AndroidAutoSessionInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x35D821CB, /AndroidAutoSessionInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 53,
        /* mParentIndex        */ 0,    // ItemKey::AndroidAutoSessionInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 189,    // ::AndroidAutoSessionInfoData
        /* mItemKey            */ 34
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x1265EC36, /AndroidAutoSessionInfo/SessionStatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 53,
        /* mParentIndex        */ 0,    // ItemKey::AndroidAutoSessionInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 190,    // ::AndroidAutoSessionInfoData::mSessionStatus
        /* mItemKey            */ 10
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x1F4AA778, /AndroidAutoSessionInfo/SessionStatusIndex),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 53,
        /* mParentIndex        */ 0,    // ItemKey::AndroidAutoSessionInfoItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 191,    // ::AndroidAutoSessionInfoData::mSessionStatusIndex
        /* mItemKey            */ 15
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gBTONOFFHierarchyNodes[BTONOFFDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xFEEB6BAB, /BTONOFF),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 54,
        /* mParentIndex        */ 0,    // ItemKey::BTONOFFItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 192,    // ::BTONOFFData
        /* mItemKey            */ 201
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xBB2FF0BC, /BTONOFF/BTONOFFStatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 54,
        /* mParentIndex        */ 0,    // ItemKey::BTONOFFItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 193,    // ::BTONOFFData::mBTONOFFStatus
        /* mItemKey            */ 141
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gIntercomenableHierarchyNodes[IntercomenableDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xAFBBE505, /Intercomenable),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 55,
        /* mParentIndex        */ 0,    // ItemKey::IntercomenableItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 194,    // ::IntercomenableData
        /* mItemKey            */ 126
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x8A3BFD16, /Intercomenable/Intercomenable),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 55,
        /* mParentIndex        */ 0,    // ItemKey::IntercomenableItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 195,    // ::IntercomenableData::mIntercomenable
        /* mItemKey            */ 101
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gAddCallEnableHierarchyNodes[AddCallEnableDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xCD222D2D, /AddCallEnable),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 56,
        /* mParentIndex        */ 0,    // ItemKey::AddCallEnableItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 196,    // ::AddCallEnableData
        /* mItemKey            */ 157
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x2106D4A3, /AddCallEnable/AddCallEnable),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 56,
        /* mParentIndex        */ 0,    // ItemKey::AddCallEnableItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 197,    // ::AddCallEnableData::mAddCallEnable
        /* mItemKey            */ 19
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSpeedLockHierarchyNodes[SpeedLockDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x75E25BE7, /SpeedLock),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 57,
        /* mParentIndex        */ 0,    // ItemKey::SpeedLockItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 198,    // ::SpeedLockData
        /* mItemKey            */ 78
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF8736269, /SpeedLock/SpeedLockStatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 57,
        /* mParentIndex        */ 0,    // ItemKey::SpeedLockItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 199,    // ::SpeedLockData::mSpeedLockStatus
        /* mItemKey            */ 194
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x896C0656, /SpeedLock/DialPadCallButtonStatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 57,
        /* mParentIndex        */ 0,    // ItemKey::SpeedLockItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 200,    // ::SpeedLockData::mDialPadCallButtonStatus
        /* mItemKey            */ 97
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gListScrollBarInfoHierarchyNodes[ListScrollBarInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x44E9662C, /ListScrollBarInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 58,
        /* mParentIndex        */ 0,    // ItemKey::ListScrollBarInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 201,    // ::ListScrollBarInfoData
        /* mItemKey            */ 42
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE2697E96, /ListScrollBarInfo/Enabled),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 58,
        /* mParentIndex        */ 0,    // ItemKey::ListScrollBarInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 202,    // ::ListScrollBarInfoData::mEnabled
        /* mItemKey            */ 175
    },
};

// array of pointers to all hierarchy nodes - sorted by HashId
const ::Courier::Internal::DataBinding::DataItemHierarchyNode * const gGlobalHierachyNodeTable[cGlobalDataItemHierarchyNodeCount] = {
    &gInvalidHierarchyNodes[0],
    &gNetworkOperatorHierarchyNodes[1],
    &gConnectedActiveBTDeviceNameHierarchyNodes[0],
    &gVarientTypeHierarchyNodes[0],
    &gContactCallNameHierarchyNodes[0],
    &gIntercom_SupportStatusHierarchyNodes[2],
    &gCallProgressHierarchyNodes[0],
    &gIContactsList_ListItemHierarchyNodes[1],
    &gPairedDevice_ListItemHierarchyNodes[0],
    &gMatchedItemsHierarchyNodes[1],
    &gAndroidAutoSessionInfoHierarchyNodes[1],
    &gMultipleCallProgressHierarchyNodes[9],
    &gListDataSizeHierarchyNodes[5],
    &gPhoneStatusHierarchyNodes[0],
    &gPrivateModeStatusHierarchyNodes[0],
    &gAndroidAutoSessionInfoHierarchyNodes[2],
    &gListId_FlexHierarchyNodes[9],
    &gListDataSizeHierarchyNodes[0],
    &gIntercomConfCallHierarchyNodes[0],
    &gAddCallEnableHierarchyNodes[1],
    &gVehicleAudioStatusHierarchyNodes[1],
    &gEntryTextHierarchyNodes[0],
    &gContactList_ListItemHierarchyNodes[3],
    &gSettingsHierarchyNodes[3],
    &gMsgProgressHierarchyNodes[4],
    &gMultipleCallProgressHierarchyNodes[8],
    &gListId_FlexHierarchyNodes[0],
    &gSettingsHierarchyNodes[4],
    &gContactList_ListItemHierarchyNodes[2],
    &gPairedDevice_ListItemHierarchyNodes[2],
    &gMatchedItemsHierarchyNodes[0],
    &gLoadingAnimationInfoHierarchyNodes[1],
    &gCallProgressHierarchyNodes[5],
    &gCallProgressHierarchyNodes[3],
    &gAndroidAutoSessionInfoHierarchyNodes[0],
    &gListId_FlexHierarchyNodes[2],
    &gIntercom_SupportStatusHierarchyNodes[0],
    &gIContactsList_ListItemHierarchyNodes[0],
    &gBTVRIconSRStatusIndexHierarchyNodes[0],
    &gIsActiveHierarchyNodes[0],
    &gCallList_ListItemHierarchyNodes[4],
    &gMultipleCallProgressHierarchyNodes[0],
    &gListScrollBarInfoHierarchyNodes[0],
    &gFriendlyVehicleNameHierarchyNodes[1],
    &gContactCall_ListItemHierarchyNodes[3],
    &gPhoneStatusHierarchyNodes[5],
    &gValidCharSetHierarchyNodes[0],
    &gIContactsList_ListItemHierarchyNodes[3],
    &gConnectedBTDeviceNameHierarchyNodes[0],
    &gMultipleCallProgressHierarchyNodes[5],
    &gVehicleAudioStatusHierarchyNodes[0],
    &gBTVRDeviceNameHierarchyNodes[0],
    &gDialPadButtonHierarchyNodes[1],
    &gMicEnableHierarchyNodes[0],
    &gBTTelltalesHierarchyNodes[0],
    &gLoadingAnimationInfoHierarchyNodes[4],
    &gRoamingHierarchyNodes[0],
    &gNetworkOperatorHierarchyNodes[0],
    &gMsgProgressHierarchyNodes[3],
    &gIntercomMissedIncomingCallHierarchyNodes[0],
    &gMultipleCallProgressHierarchyNodes[2],
    &gListId_FlexHierarchyNodes[3],
    &gCallList_ListItemHierarchyNodes[0],
    &gIntercomIncomingCallHierarchyNodes[2],
    &gListDataSizeHierarchyNodes[8],
    &gListId_FlexHierarchyNodes[5],
    &gMsgProgressHierarchyNodes[2],
    &gViewPortStartIndexHierarchyNodes[1],
    &gIsListNotemptyHierarchyNodes[2],
    &gMsgProgressHierarchyNodes[1],
    &gIntercomCallProgressHierarchyNodes[1],
    &gLoadingAnimationInfoHierarchyNodes[0],
    &gSPIStatusHierarchyNodes[1],
    &gConnectedActiveBTDeviceNameHierarchyNodes[1],
    &gSettingsHierarchyNodes[0],
    &gListDataSizeHierarchyNodes[1],
    &gMsgProgressHierarchyNodes[6],
    &gSettingsHierarchyNodes[2],
    &gSpeedLockHierarchyNodes[0],
    &gListId_FlexHierarchyNodes[7],
    &gMultipleCallProgressHierarchyNodes[3],
    &gCallProgressHierarchyNodes[1],
    &gIsListNotemptyHierarchyNodes[1],
    &gIncomingCallHierarchyNodes[0],
    &gSettingsHierarchyNodes[6],
    &gCallProgressHierarchyNodes[2],
    &gMultipleCallProgressHierarchyNodes[10],
    &gIntercom_SupportStatusHierarchyNodes[1],
    &gMsgProgressHierarchyNodes[7],
    &gPhoneGadgetInfoHierarchyNodes[1],
    &gPairedDevice_ListItemHierarchyNodes[3],
    &gContactList_ListItemHierarchyNodes[0],
    &gSuggesstionTextHierarchyNodes[1],
    &gEntryTextHierarchyNodes[1],
    &gFriendlyVehicleNameHierarchyNodes[0],
    &gPhoneGadgetInfoHierarchyNodes[3],
    &gIntercomConfCallHierarchyNodes[1],
    &gSpeedLockHierarchyNodes[2],
    &gContactCallNameHierarchyNodes[1],
    &gMultipleCallProgressHierarchyNodes[4],
    &gMultipleCallProgressHierarchyNodes[6],
    &gIntercomenableHierarchyNodes[1],
    &gMatchList_ListItemHierarchyNodes[0],
    &gBTTelltalesHierarchyNodes[1],
    &gPairedDevice_ListItemHierarchyNodes[6],
    &gIncomingCallHierarchyNodes[1],
    &gMatchList_ListItemHierarchyNodes[1],
    &gIntercomCallProgressHierarchyNodes[2],
    &gCallList_ListItemHierarchyNodes[1],
    &gQuickScrollSearchHierarchyNodes[1],
    &gRoamingHierarchyNodes[1],
    &gLoadingAnimationInfoHierarchyNodes[2],
    &gMultipleCallProgressHierarchyNodes[1],
    &gContactList_ListItemHierarchyNodes[1],
    &gPairingDeviceInfoHierarchyNodes[0],
    &gPhoneStatusHierarchyNodes[1],
    &gPhoneButtonTextHierarchyNodes[1],
    &gBTTelltalesHierarchyNodes[2],
    &gListId_FlexHierarchyNodes[1],
    &gListDataSizeHierarchyNodes[2],
    &gIntercomMissedIncomingCallHierarchyNodes[1],
    &gMatchList_ListItemHierarchyNodes[2],
    &gIncomingCallHierarchyNodes[4],
    &gPhoneGadgetInfoHierarchyNodes[6],
    &gListId_FlexHierarchyNodes[6],
    &gDisconnectedBTDeviceNameHierarchyNodes[0],
    &gIntercomenableHierarchyNodes[0],
    &gCallProgressHierarchyNodes[4],
    &gContactCall_ListItemHierarchyNodes[2],
    &gListDataSizeHierarchyNodes[3],
    &gLoadingAnimationInfoHierarchyNodes[3],
    &gPairedDevice_ListItemHierarchyNodes[4],
    &gMsgProgressHierarchyNodes[5],
    &gPhoneDialPadInputTextHierarchyNodes[1],
    &gDeviceInfoHierarchyNodes[0],
    &gMultipleCallProgressHierarchyNodes[11],
    &gCallList_ListItemHierarchyNodes[2],
    &gListDataSizeHierarchyNodes[7],
    &gConnectedBTDeviceNameHierarchyNodes[1],
    &gQuickScrollSearchHierarchyNodes[0],
    &gPairedDevice_ListItemHierarchyNodes[1],
    &gBTONOFFHierarchyNodes[1],
    &gMultipleCallProgressHierarchyNodes[7],
    &gIntercomCallProgressHierarchyNodes[0],
    &gBTVRIconSRStatusHierarchyNodes[1],
    &gPairingDeviceInfoHierarchyNodes[2],
    &gIntercomIncomingCallHierarchyNodes[0],
    &gListDataSizeHierarchyNodes[6],
    &gPhoneGadgetInfoHierarchyNodes[2],
    &gViewPortStartIndexHierarchyNodes[0],
    &gPhoneGadgetInfoHierarchyNodes[4],
    &gValidCharSetHierarchyNodes[1],
    &gPairingDeviceInfoHierarchyNodes[1],
    &gListId_FlexHierarchyNodes[8],
    &gPrivateModeStatusHierarchyNodes[1],
    &gBTVRDeviceNameHierarchyNodes[1],
    &gCallList_ListItemHierarchyNodes[5],
    &gAddCallEnableHierarchyNodes[0],
    &gSettingsHierarchyNodes[1],
    &gDialButtonHierarchyNodes[0],
    &gBTVRIconSRStatusHierarchyNodes[0],
    &gIntercomIncomingCallHierarchyNodes[1],
    &gBTVRIconSRStatusIndexHierarchyNodes[1],
    &gDialButtonHierarchyNodes[1],
    &gSettingsHierarchyNodes[5],
    &gPhoneStatusHierarchyNodes[6],
    &gListDataSizeHierarchyNodes[4],
    &gIsActiveHierarchyNodes[1],
    &gPhoneStatusHierarchyNodes[2],
    &gIsListNotemptyHierarchyNodes[0],
    &gContactCall_ListItemHierarchyNodes[0],
    &gPairedDevice_ListItemHierarchyNodes[5],
    &gSuggesstionTextHierarchyNodes[0],
    &gPhoneStatusHierarchyNodes[3],
    &gListId_FlexHierarchyNodes[4],
    &gListScrollBarInfoHierarchyNodes[1],
    &gPhoneGadgetInfoHierarchyNodes[0],
    &gSPIStatusHierarchyNodes[0],
    &gPhoneStatusHierarchyNodes[4],
    &gIContactsList_ListItemHierarchyNodes[2],
    &gIntercomConfCallHierarchyNodes[3],
    &gVarientTypeHierarchyNodes[2],
    &gMicEnableHierarchyNodes[1],
    &gMatchListHierarchyNodes[1],
    &gPhoneDialPadInputTextHierarchyNodes[0],
    &gNetworkOperatorHierarchyNodes[2],
    &gMatchListHierarchyNodes[0],
    &gIncomingCallHierarchyNodes[2],
    &gMicEnableHierarchyNodes[2],
    &gDialPadButtonHierarchyNodes[0],
    &gIncomingCallHierarchyNodes[3],
    &gDisconnectedBTDeviceNameHierarchyNodes[1],
    &gQuickScrollSearchHierarchyNodes[2],
    &gPhoneGadgetInfoHierarchyNodes[5],
    &gSpeedLockHierarchyNodes[1],
    &gMsgProgressHierarchyNodes[0],
    &gContactCall_ListItemHierarchyNodes[1],
    &gCallList_ListItemHierarchyNodes[3],
    &gDeviceInfoHierarchyNodes[1],
    &gIntercomConfCallHierarchyNodes[2],
    &gPhoneButtonTextHierarchyNodes[0],
    &gBTONOFFHierarchyNodes[0],
    &gVarientTypeHierarchyNodes[1],
};

// binding source root table - indexed with BindingSourceIndex 
static const ::Courier::Internal::DataBinding::BindingSourceRootStorage gBindingSourceMap[cBindingSourceCount] = {
    { InvalidDataBindingSource::cHierarchyNodeCount, gInvalidHierarchyNodes },
    { ListId_FlexDataBindingSource::cHierarchyNodeCount, gListId_FlexHierarchyNodes },
    { ListDataSizeDataBindingSource::cHierarchyNodeCount, gListDataSizeHierarchyNodes },
    { PairedDevice_ListItemDataBindingSource::cHierarchyNodeCount, gPairedDevice_ListItemHierarchyNodes },
    { CallList_ListItemDataBindingSource::cHierarchyNodeCount, gCallList_ListItemHierarchyNodes },
    { ContactList_ListItemDataBindingSource::cHierarchyNodeCount, gContactList_ListItemHierarchyNodes },
    { MatchList_ListItemDataBindingSource::cHierarchyNodeCount, gMatchList_ListItemHierarchyNodes },
    { IContactsList_ListItemDataBindingSource::cHierarchyNodeCount, gIContactsList_ListItemHierarchyNodes },
    { Intercom_SupportStatusDataBindingSource::cHierarchyNodeCount, gIntercom_SupportStatusHierarchyNodes },
    { ContactCall_ListItemDataBindingSource::cHierarchyNodeCount, gContactCall_ListItemHierarchyNodes },
    { ViewPortStartIndexDataBindingSource::cHierarchyNodeCount, gViewPortStartIndexHierarchyNodes },
    { ConnectedActiveBTDeviceNameDataBindingSource::cHierarchyNodeCount, gConnectedActiveBTDeviceNameHierarchyNodes },
    { ConnectedBTDeviceNameDataBindingSource::cHierarchyNodeCount, gConnectedBTDeviceNameHierarchyNodes },
    { DisconnectedBTDeviceNameDataBindingSource::cHierarchyNodeCount, gDisconnectedBTDeviceNameHierarchyNodes },
    { VarientTypeDataBindingSource::cHierarchyNodeCount, gVarientTypeHierarchyNodes },
    { SPIStatusDataBindingSource::cHierarchyNodeCount, gSPIStatusHierarchyNodes },
    { IsListNotemptyDataBindingSource::cHierarchyNodeCount, gIsListNotemptyHierarchyNodes },
    { ContactCallNameDataBindingSource::cHierarchyNodeCount, gContactCallNameHierarchyNodes },
    { FriendlyVehicleNameDataBindingSource::cHierarchyNodeCount, gFriendlyVehicleNameHierarchyNodes },
    { PairingDeviceInfoDataBindingSource::cHierarchyNodeCount, gPairingDeviceInfoHierarchyNodes },
    { DeviceInfoDataBindingSource::cHierarchyNodeCount, gDeviceInfoHierarchyNodes },
    { MatchedItemsDataBindingSource::cHierarchyNodeCount, gMatchedItemsHierarchyNodes },
    { PhoneButtonTextDataBindingSource::cHierarchyNodeCount, gPhoneButtonTextHierarchyNodes },
    { MicEnableDataBindingSource::cHierarchyNodeCount, gMicEnableHierarchyNodes },
    { VehicleAudioStatusDataBindingSource::cHierarchyNodeCount, gVehicleAudioStatusHierarchyNodes },
    { PrivateModeStatusDataBindingSource::cHierarchyNodeCount, gPrivateModeStatusHierarchyNodes },
    { SettingsDataBindingSource::cHierarchyNodeCount, gSettingsHierarchyNodes },
    { CallProgressDataBindingSource::cHierarchyNodeCount, gCallProgressHierarchyNodes },
    { IntercomIncomingCallDataBindingSource::cHierarchyNodeCount, gIntercomIncomingCallHierarchyNodes },
    { IntercomMissedIncomingCallDataBindingSource::cHierarchyNodeCount, gIntercomMissedIncomingCallHierarchyNodes },
    { IntercomCallProgressDataBindingSource::cHierarchyNodeCount, gIntercomCallProgressHierarchyNodes },
    { IntercomConfCallDataBindingSource::cHierarchyNodeCount, gIntercomConfCallHierarchyNodes },
    { PhoneStatusDataBindingSource::cHierarchyNodeCount, gPhoneStatusHierarchyNodes },
    { ValidCharSetDataBindingSource::cHierarchyNodeCount, gValidCharSetHierarchyNodes },
    { SuggesstionTextDataBindingSource::cHierarchyNodeCount, gSuggesstionTextHierarchyNodes },
    { EntryTextDataBindingSource::cHierarchyNodeCount, gEntryTextHierarchyNodes },
    { PhoneDialPadInputTextDataBindingSource::cHierarchyNodeCount, gPhoneDialPadInputTextHierarchyNodes },
    { BTTelltalesDataBindingSource::cHierarchyNodeCount, gBTTelltalesHierarchyNodes },
    { RoamingDataBindingSource::cHierarchyNodeCount, gRoamingHierarchyNodes },
    { DialButtonDataBindingSource::cHierarchyNodeCount, gDialButtonHierarchyNodes },
    { MatchListDataBindingSource::cHierarchyNodeCount, gMatchListHierarchyNodes },
    { DialPadButtonDataBindingSource::cHierarchyNodeCount, gDialPadButtonHierarchyNodes },
    { IsActiveDataBindingSource::cHierarchyNodeCount, gIsActiveHierarchyNodes },
    { PhoneGadgetInfoDataBindingSource::cHierarchyNodeCount, gPhoneGadgetInfoHierarchyNodes },
    { MsgProgressDataBindingSource::cHierarchyNodeCount, gMsgProgressHierarchyNodes },
    { MultipleCallProgressDataBindingSource::cHierarchyNodeCount, gMultipleCallProgressHierarchyNodes },
    { IncomingCallDataBindingSource::cHierarchyNodeCount, gIncomingCallHierarchyNodes },
    { NetworkOperatorDataBindingSource::cHierarchyNodeCount, gNetworkOperatorHierarchyNodes },
    { BTVRDeviceNameDataBindingSource::cHierarchyNodeCount, gBTVRDeviceNameHierarchyNodes },
    { BTVRIconSRStatusDataBindingSource::cHierarchyNodeCount, gBTVRIconSRStatusHierarchyNodes },
    { BTVRIconSRStatusIndexDataBindingSource::cHierarchyNodeCount, gBTVRIconSRStatusIndexHierarchyNodes },
    { QuickScrollSearchDataBindingSource::cHierarchyNodeCount, gQuickScrollSearchHierarchyNodes },
    { LoadingAnimationInfoDataBindingSource::cHierarchyNodeCount, gLoadingAnimationInfoHierarchyNodes },
    { AndroidAutoSessionInfoDataBindingSource::cHierarchyNodeCount, gAndroidAutoSessionInfoHierarchyNodes },
    { BTONOFFDataBindingSource::cHierarchyNodeCount, gBTONOFFHierarchyNodes },
    { IntercomenableDataBindingSource::cHierarchyNodeCount, gIntercomenableHierarchyNodes },
    { AddCallEnableDataBindingSource::cHierarchyNodeCount, gAddCallEnableHierarchyNodes },
    { SpeedLockDataBindingSource::cHierarchyNodeCount, gSpeedLockHierarchyNodes },
    { ListScrollBarInfoDataBindingSource::cHierarchyNodeCount, gListScrollBarInfoHierarchyNodes },
};

// Init function prototype
static bool InitDataBindingGenerated(void);

// Infrastructure defnition
static const ::Courier::Internal::DataBinding::DataBindingInfrastructure gInfrastructure = { 
    cGlobalDataItemHierarchyNodeCount, gGlobalHierachyNodeTable, 
    cBindingSourceCount, gBindingSourceMap,
    cDataItemDescriptorCount, gItemDesc,
    &InitDataBindingGenerated
};

// ------------------------------------------------------------------------
static bool InitDataBindingGenerated(void)
{
    /* if one of these assertion fails, increase the limits defined in Courier/DataBinding/Infrastructure.h */
    COURIER_COMPILETIME_ASSERT(cBindingSourceItemCountMax < ::Courier::cBindingSourceHierarchyNodeMax);
    COURIER_COMPILETIME_ASSERT(cDataItemDescriptorCount < ::Courier::cItemDescriptorMax);
    COURIER_COMPILETIME_ASSERT(cBindingSourceCount < ::Courier::cBindingSourceMax);

    static ::Courier::Internal::DataBinding::BindingSourceRevisionStoreImpl<cBindingSourceCount> theRevisionStore;

    bool ok = true;
    {
        FEATSTD_UNSYNCED_STATIC_OBJECT(ListId_FlexDataBindingSource, bsListId_Flex);
        FEATSTD_UNSYNCED_STATIC_OBJECT(ListDataSizeDataBindingSource, bsListDataSize);
        FEATSTD_UNSYNCED_STATIC_OBJECT(PairedDevice_ListItemDataBindingSource, bsPairedDevice_ListItem);
        FEATSTD_UNSYNCED_STATIC_OBJECT(CallList_ListItemDataBindingSource, bsCallList_ListItem);
        FEATSTD_UNSYNCED_STATIC_OBJECT(ContactList_ListItemDataBindingSource, bsContactList_ListItem);
        FEATSTD_UNSYNCED_STATIC_OBJECT(MatchList_ListItemDataBindingSource, bsMatchList_ListItem);
        FEATSTD_UNSYNCED_STATIC_OBJECT(IContactsList_ListItemDataBindingSource, bsIContactsList_ListItem);
        FEATSTD_UNSYNCED_STATIC_OBJECT(Intercom_SupportStatusDataBindingSource, bsIntercom_SupportStatus);
        FEATSTD_UNSYNCED_STATIC_OBJECT(ContactCall_ListItemDataBindingSource, bsContactCall_ListItem);
        FEATSTD_UNSYNCED_STATIC_OBJECT(ViewPortStartIndexDataBindingSource, bsViewPortStartIndex);
        FEATSTD_UNSYNCED_STATIC_OBJECT(ConnectedActiveBTDeviceNameDataBindingSource, bsConnectedActiveBTDeviceName);
        FEATSTD_UNSYNCED_STATIC_OBJECT(ConnectedBTDeviceNameDataBindingSource, bsConnectedBTDeviceName);
        FEATSTD_UNSYNCED_STATIC_OBJECT(DisconnectedBTDeviceNameDataBindingSource, bsDisconnectedBTDeviceName);
        FEATSTD_UNSYNCED_STATIC_OBJECT(VarientTypeDataBindingSource, bsVarientType);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SPIStatusDataBindingSource, bsSPIStatus);
        FEATSTD_UNSYNCED_STATIC_OBJECT(IsListNotemptyDataBindingSource, bsIsListNotempty);
        FEATSTD_UNSYNCED_STATIC_OBJECT(ContactCallNameDataBindingSource, bsContactCallName);
        FEATSTD_UNSYNCED_STATIC_OBJECT(FriendlyVehicleNameDataBindingSource, bsFriendlyVehicleName);
        FEATSTD_UNSYNCED_STATIC_OBJECT(PairingDeviceInfoDataBindingSource, bsPairingDeviceInfo);
        FEATSTD_UNSYNCED_STATIC_OBJECT(DeviceInfoDataBindingSource, bsDeviceInfo);
        FEATSTD_UNSYNCED_STATIC_OBJECT(MatchedItemsDataBindingSource, bsMatchedItems);
        FEATSTD_UNSYNCED_STATIC_OBJECT(PhoneButtonTextDataBindingSource, bsPhoneButtonText);
        FEATSTD_UNSYNCED_STATIC_OBJECT(MicEnableDataBindingSource, bsMicEnable);
        FEATSTD_UNSYNCED_STATIC_OBJECT(VehicleAudioStatusDataBindingSource, bsVehicleAudioStatus);
        FEATSTD_UNSYNCED_STATIC_OBJECT(PrivateModeStatusDataBindingSource, bsPrivateModeStatus);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SettingsDataBindingSource, bsSettings);
        FEATSTD_UNSYNCED_STATIC_OBJECT(CallProgressDataBindingSource, bsCallProgress);
        FEATSTD_UNSYNCED_STATIC_OBJECT(IntercomIncomingCallDataBindingSource, bsIntercomIncomingCall);
        FEATSTD_UNSYNCED_STATIC_OBJECT(IntercomMissedIncomingCallDataBindingSource, bsIntercomMissedIncomingCall);
        FEATSTD_UNSYNCED_STATIC_OBJECT(IntercomCallProgressDataBindingSource, bsIntercomCallProgress);
        FEATSTD_UNSYNCED_STATIC_OBJECT(IntercomConfCallDataBindingSource, bsIntercomConfCall);
        FEATSTD_UNSYNCED_STATIC_OBJECT(PhoneStatusDataBindingSource, bsPhoneStatus);
        FEATSTD_UNSYNCED_STATIC_OBJECT(ValidCharSetDataBindingSource, bsValidCharSet);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SuggesstionTextDataBindingSource, bsSuggesstionText);
        FEATSTD_UNSYNCED_STATIC_OBJECT(EntryTextDataBindingSource, bsEntryText);
        FEATSTD_UNSYNCED_STATIC_OBJECT(PhoneDialPadInputTextDataBindingSource, bsPhoneDialPadInputText);
        FEATSTD_UNSYNCED_STATIC_OBJECT(BTTelltalesDataBindingSource, bsBTTelltales);
        FEATSTD_UNSYNCED_STATIC_OBJECT(RoamingDataBindingSource, bsRoaming);
        FEATSTD_UNSYNCED_STATIC_OBJECT(DialButtonDataBindingSource, bsDialButton);
        FEATSTD_UNSYNCED_STATIC_OBJECT(MatchListDataBindingSource, bsMatchList);
        FEATSTD_UNSYNCED_STATIC_OBJECT(DialPadButtonDataBindingSource, bsDialPadButton);
        FEATSTD_UNSYNCED_STATIC_OBJECT(IsActiveDataBindingSource, bsIsActive);
        FEATSTD_UNSYNCED_STATIC_OBJECT(PhoneGadgetInfoDataBindingSource, bsPhoneGadgetInfo);
        FEATSTD_UNSYNCED_STATIC_OBJECT(MsgProgressDataBindingSource, bsMsgProgress);
        FEATSTD_UNSYNCED_STATIC_OBJECT(MultipleCallProgressDataBindingSource, bsMultipleCallProgress);
        FEATSTD_UNSYNCED_STATIC_OBJECT(IncomingCallDataBindingSource, bsIncomingCall);
        FEATSTD_UNSYNCED_STATIC_OBJECT(NetworkOperatorDataBindingSource, bsNetworkOperator);
        FEATSTD_UNSYNCED_STATIC_OBJECT(BTVRDeviceNameDataBindingSource, bsBTVRDeviceName);
        FEATSTD_UNSYNCED_STATIC_OBJECT(BTVRIconSRStatusDataBindingSource, bsBTVRIconSRStatus);
        FEATSTD_UNSYNCED_STATIC_OBJECT(BTVRIconSRStatusIndexDataBindingSource, bsBTVRIconSRStatusIndex);
        FEATSTD_UNSYNCED_STATIC_OBJECT(QuickScrollSearchDataBindingSource, bsQuickScrollSearch);
        FEATSTD_UNSYNCED_STATIC_OBJECT(LoadingAnimationInfoDataBindingSource, bsLoadingAnimationInfo);
        FEATSTD_UNSYNCED_STATIC_OBJECT(AndroidAutoSessionInfoDataBindingSource, bsAndroidAutoSessionInfo);
        FEATSTD_UNSYNCED_STATIC_OBJECT(BTONOFFDataBindingSource, bsBTONOFF);
        FEATSTD_UNSYNCED_STATIC_OBJECT(IntercomenableDataBindingSource, bsIntercomenable);
        FEATSTD_UNSYNCED_STATIC_OBJECT(AddCallEnableDataBindingSource, bsAddCallEnable);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SpeedLockDataBindingSource, bsSpeedLock);
        FEATSTD_UNSYNCED_STATIC_OBJECT(ListScrollBarInfoDataBindingSource, bsListScrollBarInfo);
        static ::Courier::Internal::ModelBindingSource *bindingSources[cBindingSourceCount] = { 
            0,
            &bsListId_Flex, 
            &bsListDataSize, 
            &bsPairedDevice_ListItem, 
            &bsCallList_ListItem, 
            &bsContactList_ListItem, 
            &bsMatchList_ListItem, 
            &bsIContactsList_ListItem, 
            &bsIntercom_SupportStatus, 
            &bsContactCall_ListItem, 
            &bsViewPortStartIndex, 
            &bsConnectedActiveBTDeviceName, 
            &bsConnectedBTDeviceName, 
            &bsDisconnectedBTDeviceName, 
            &bsVarientType, 
            &bsSPIStatus, 
            &bsIsListNotempty, 
            &bsContactCallName, 
            &bsFriendlyVehicleName, 
            &bsPairingDeviceInfo, 
            &bsDeviceInfo, 
            &bsMatchedItems, 
            &bsPhoneButtonText, 
            &bsMicEnable, 
            &bsVehicleAudioStatus, 
            &bsPrivateModeStatus, 
            &bsSettings, 
            &bsCallProgress, 
            &bsIntercomIncomingCall, 
            &bsIntercomMissedIncomingCall, 
            &bsIntercomCallProgress, 
            &bsIntercomConfCall, 
            &bsPhoneStatus, 
            &bsValidCharSet, 
            &bsSuggesstionText, 
            &bsEntryText, 
            &bsPhoneDialPadInputText, 
            &bsBTTelltales, 
            &bsRoaming, 
            &bsDialButton, 
            &bsMatchList, 
            &bsDialPadButton, 
            &bsIsActive, 
            &bsPhoneGadgetInfo, 
            &bsMsgProgress, 
            &bsMultipleCallProgress, 
            &bsIncomingCall, 
            &bsNetworkOperator, 
            &bsBTVRDeviceName, 
            &bsBTVRIconSRStatus, 
            &bsBTVRIconSRStatusIndex, 
            &bsQuickScrollSearch, 
            &bsLoadingAnimationInfo, 
            &bsAndroidAutoSessionInfo, 
            &bsBTONOFF, 
            &bsIntercomenable, 
            &bsAddCallEnable, 
            &bsSpeedLock, 
            &bsListScrollBarInfo, 
        };
        ok = ok && ::Courier::Register(::Courier::ComponentId(::Courier::ComponentType::View), bindingSources, cBindingSourceCount);
    }
    return ok;
}

namespace Courier {
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::ListId_FlexDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::ListDataSizeDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::PairedDevice_ListItemDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::CallList_ListItemDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::ContactList_ListItemDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::MatchList_ListItemDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::IContactsList_ListItemDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::Intercom_SupportStatusDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::ContactCall_ListItemDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::ViewPortStartIndexDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::ConnectedActiveBTDeviceNameDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::ConnectedBTDeviceNameDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::DisconnectedBTDeviceNameDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::VarientTypeDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SPIStatusDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::IsListNotemptyDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::ContactCallNameDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::FriendlyVehicleNameDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::PairingDeviceInfoDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::DeviceInfoDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::MatchedItemsDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::PhoneButtonTextDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::MicEnableDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::VehicleAudioStatusDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::PrivateModeStatusDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SettingsDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::CallProgressDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::IntercomIncomingCallDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::IntercomMissedIncomingCallDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::IntercomCallProgressDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::IntercomConfCallDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::PhoneStatusDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::ValidCharSetDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SuggesstionTextDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::EntryTextDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::PhoneDialPadInputTextDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::BTTelltalesDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::RoamingDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::DialButtonDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::MatchListDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::DialPadButtonDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::IsActiveDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::PhoneGadgetInfoDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::MsgProgressDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::MultipleCallProgressDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::IncomingCallDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::NetworkOperatorDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::BTVRDeviceNameDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::BTVRIconSRStatusDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::BTVRIconSRStatusIndexDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::QuickScrollSearchDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::LoadingAnimationInfoDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::AndroidAutoSessionInfoDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::BTONOFFDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::IntercomenableDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::AddCallEnableDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SpeedLockDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::ListScrollBarInfoDataBindingSource>, 5);
} // namespace Courier

#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
namespace FeatStd {
// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ListId_FlexDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ListId_FlexDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ListDataSizeDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ListDataSizeDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PairedDevice_ListItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PairedDevice_ListItemDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::CallList_ListItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::CallList_ListItemDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ContactList_ListItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ContactList_ListItemDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::MatchList_ListItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::MatchList_ListItemDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::IContactsList_ListItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::IContactsList_ListItemDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Intercom_SupportStatusDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Intercom_SupportStatusDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ContactCall_ListItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ContactCall_ListItemDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ViewPortStartIndexDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ViewPortStartIndexDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ConnectedActiveBTDeviceNameDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ConnectedActiveBTDeviceNameDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ConnectedBTDeviceNameDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ConnectedBTDeviceNameDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DisconnectedBTDeviceNameDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DisconnectedBTDeviceNameDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::VarientTypeDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::VarientTypeDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SPIStatusDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SPIStatusDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::IsListNotemptyDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::IsListNotemptyDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ContactCallNameDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ContactCallNameDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::FriendlyVehicleNameDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::FriendlyVehicleNameDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PairingDeviceInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PairingDeviceInfoDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DeviceInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DeviceInfoDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::MatchedItemsDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::MatchedItemsDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PhoneButtonTextDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PhoneButtonTextDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::MicEnableDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::MicEnableDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::VehicleAudioStatusDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::VehicleAudioStatusDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PrivateModeStatusDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PrivateModeStatusDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SettingsDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SettingsDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::CallProgressDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::CallProgressDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::IntercomIncomingCallDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::IntercomIncomingCallDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::IntercomMissedIncomingCallDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::IntercomMissedIncomingCallDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::IntercomCallProgressDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::IntercomCallProgressDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::IntercomConfCallDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::IntercomConfCallDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PhoneStatusDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PhoneStatusDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ValidCharSetDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ValidCharSetDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SuggesstionTextDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SuggesstionTextDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::EntryTextDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::EntryTextDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PhoneDialPadInputTextDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PhoneDialPadInputTextDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::BTTelltalesDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::BTTelltalesDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::RoamingDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::RoamingDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DialButtonDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DialButtonDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::MatchListDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::MatchListDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DialPadButtonDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DialPadButtonDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::IsActiveDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::IsActiveDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PhoneGadgetInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PhoneGadgetInfoDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::MsgProgressDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::MsgProgressDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::MultipleCallProgressDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::MultipleCallProgressDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::IncomingCallDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::IncomingCallDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::NetworkOperatorDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::NetworkOperatorDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::BTVRDeviceNameDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::BTVRDeviceNameDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::BTVRIconSRStatusDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::BTVRIconSRStatusDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::BTVRIconSRStatusIndexDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::BTVRIconSRStatusIndexDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::QuickScrollSearchDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::QuickScrollSearchDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::LoadingAnimationInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::LoadingAnimationInfoDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::AndroidAutoSessionInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::AndroidAutoSessionInfoDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::BTONOFFDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::BTONOFFDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::IntercomenableDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::IntercomenableDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::AddCallEnableDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::AddCallEnableDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SpeedLockDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SpeedLockDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ListScrollBarInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ListScrollBarInfoDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }
} // namespace FeatStd
#endif
COURIER_DATABINDING_INFRASTRUCTURE(::gInfrastructure);
