/************************************************************************
*FILE: AppHmi_NavigationStateMachineData.cpp 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/*
 * Id:        AppHmi_NavigationStateMachineData.cpp
 *
 * Function:  VS System Data Source File.
 *
 * Generated: Tue Jan 17 22:10:38 2023
 *
 * Coder 7, 3, 2, 2426
 * 
 * This is an automatically generated file. It will be overwritten by the Coder.
 * 
 * DO NOT EDIT THE FILE!
 */


#include "AppHmi_NavigationStateMachineSEMLibB.h"


#include "AppHmi_NavigationStateMachineData.h"


#include <stdarg.h>


/*
 * VS System External Variable Definitions.
 */
VS_BOOL EXT_IsMapScrollTapEnable = 0;

VS_BOOL EXT_bCenterMapToCurrentPosition = 0;

VS_BOOL EXT_bIsGuidanceActive = 0;

VS_BOOL EXT_bIsMapCameraModeChangeDone = 0;

VS_BOOL EXT_bIsMaxFavReached = 0;

VS_BOOL EXT_bIsNaviAppRunning = 0;

VS_BOOL EXT_bIsPOIFts = 0;

VS_BOOL EXT_bIsPremiumTrafficDisclaimerShown = 0;

VS_BOOL EXT_bIsSpeedLockActive = 0;

VS_BOOL EXT_bIsUPOIContext = 0;

VS_BOOL EXT_bIsWaypointDestinationIndex = 0;

VS_BOOL Ext_bIsEnableByMapOKBtn = 0;


/*
 * VS System Internal Variable Initializing Function.
 */
void AppHmi_NavigationStateMachine::SEM_InitInternalVariables (void)
{
  IN_ByMapSubLevelViewID = 0ul;
  IN_bIsBrowseBack = 0;
  IN_bIsCautionAccepted = 0;
  IN_bIsDestGuidance = 0;
  IN_bIsDestinationDetailedInfo = 0;
  IN_bIsFavorite = 0;
  IN_bIsGoToHomeEnabled = 0;
  IN_bIsHomeAddressInput = 0;
  IN_bIsMapPickInOptionScene = 0;
  IN_bIsMapShown = 0;
  IN_bIsMapUpdateTriggered = 0;
  IN_bIsNaviAppinForeground = 0;
  IN_bIsNaviGadgetTitlePressed = 0;
  IN_bIsNaviMap = 0;
  IN_bIsOPTVehicleBackTouch = 0;
  IN_bIsPickPOIOnMap = 0;
  IN_bIsSelectedFavDelete = 0;
  IN_bIsSettingsSavedDuringActiveRG = 0;
  IN_bIsSettingsShownFirstOnNaviFG = 0;
  IN_bIsSublevel = 0;
  IN_bIsTMCOnRoute = 0;
  IN_bIsTrafficDetourDisplayed = 0;
  IN_bIsUPOIFreeTextSearch = 0;
  IN_bIsUPOIInvalidate = 0;
  IN_bIsVehicleProfileChanged = 0;
  IN_u32CurrentMapViewState = 0ul;
  IN_u32CurrentNaviContext = 0ul;
  IN_u32CurrentSceneViewId = 0ul;
  IN_u32EntryToPOI = 0ul;
  IN_u32PreviousSceneViewId = 0ul;
  IN_u32PreviousSceneViewIdBeforeSettings = 0ul;
  IN_u32SecondPreviousSceneViewId = 0ul;
  IN_u8AddressInput = 0u;
  IN_u8LastEnteredDetailedInfo = 0;
  IN_u8POISelected = 0u;
  IN_u8PopupType = 0u;
  IN_u8SettingMapsOtherHierarchyLevel = 0;
  IN_u8TrafficDetialBackHandling = 0u;
  Inu32PopupOK = 0;
}


void AppHmi_NavigationStateMachine::BufferVariables (SEM_EVENT_TYPE EventNo)
{
  if (EventNo >= 304)
  {
    EventNo -= 1;
  }
  switch (EventNo)
  {
  case 1:
    VSDBVar.DB166.VS_BOOLVar[0] = EXT_bIsGuidanceActive;
    break;
  case 45:
    VSDBVar.DB45.VS_BOOLVar[0] = IN_bIsMapPickInOptionScene;
    VSDBVar.DB45.VS_UINT8Var[0] = IN_u8TrafficDetialBackHandling;
    VSDBVar.DB45.VS_BOOLVar[1] = IN_bIsTMCOnRoute;
    break;
  case 97:
    VSDBVar.DB97.VS_UINT32Var[0] = IN_u32PreviousSceneViewId;
    VSDBVar.DB97.VS_INTVar[0] = IN_u8LastEnteredDetailedInfo;
    break;
  case 104:
    VSDBVar.DB166.VS_INTVar[0] = IN_u8LastEnteredDetailedInfo;
    break;
  case 110:
    VSDBVar.DB166.VS_BOOLVar[0] = IN_bIsHomeAddressInput;
    break;
  case 154:
    VSDBVar.DB97.VS_UINT32Var[0] = IN_u32EntryToPOI;
    break;
  case 165:
    VSDBVar.DB166.VS_BOOLVar[0] = IN_bIsDestGuidance;
    break;
  case 166:
    VSDBVar.DB166.VS_BOOLVar[0] = IN_bIsFavorite;
    VSDBVar.DB166.VS_INTVar[0] = IN_u8LastEnteredDetailedInfo;
    break;
  case 179:
    VSDBVar.DB166.VS_INTVar[0] = IN_u8LastEnteredDetailedInfo;
    break;
  case 228:
    VSDBVar.DB166.VS_INTVar[0] = IN_u8LastEnteredDetailedInfo;
    break;
  case 320:
    VSDBVar.DB97.VS_INTVar[0] = IN_u8LastEnteredDetailedInfo;
    break;
  case 322:
    VSDBVar.DB97.VS_INTVar[0] = IN_u8LastEnteredDetailedInfo;
    break;

  default:
    break;
  }
}


/*
 * SEM Deduct Function.
 */
unsigned char AppHmi_NavigationStateMachine::SEM_Deduct (SEM_EVENT_TYPE EventNo, ...)
{
  va_list ap;

  va_start(ap, EventNo);
  if (SEM.State == 0x00u /* STATE_SEM_NOT_INITIALIZED */)
  {
    return SES_NOT_INITIALIZED;
  }
  if (VS_NOF_EVENTS <= EventNo)
  {
    return (SES_RANGE_ERR);
  }
  switch (EventNo)
  {
  case 20:
    EventArgsVar.DB47.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 29:
    EventArgsVar.DB47.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 30:
    EventArgsVar.DB47.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 47:
    EventArgsVar.DB47.VS_BOOLVar[0] = (VS_BOOL) va_arg(ap, VS_INT);
    EventArgsVar.DB47.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 90:
    EventArgsVar.DB47.VS_BOOLVar[0] = (VS_BOOL) va_arg(ap, VS_INT);
    break;

  case 96:
    EventArgsVar.DB47.VS_BOOLVar[0] = (VS_BOOL) va_arg(ap, VS_INT);
    break;

  case 102:
    EventArgsVar.DB47.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 103:
    EventArgsVar.DB47.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 126:
    EventArgsVar.DB47.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 170:
    EventArgsVar.DB170.VS_UINT8Var[0] = (VS_UINT8) va_arg(ap, VS_INT);
    break;

  case 179:
    EventArgsVar.DB47.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 184:
    EventArgsVar.DB47.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 201:
    EventArgsVar.DB47.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 202:
    EventArgsVar.DB47.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 203:
    EventArgsVar.DB47.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 204:
    EventArgsVar.DB47.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 205:
    EventArgsVar.DB47.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 206:
    EventArgsVar.DB47.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 209:
    EventArgsVar.DB170.VS_UINT8Var[0] = (VS_UINT8) va_arg(ap, VS_INT);
    break;

  case 213:
    EventArgsVar.DB47.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 244:
    EventArgsVar.DB47.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 252:
    EventArgsVar.DB47.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 254:
    EventArgsVar.DB47.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 258:
    EventArgsVar.DB47.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 259:
    EventArgsVar.DB47.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 260:
    EventArgsVar.DB47.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 261:
    EventArgsVar.DB47.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 262:
    EventArgsVar.DB47.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 263:
    EventArgsVar.DB47.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 266:
    EventArgsVar.DB266.VS_INT8Var[0] = (VS_INT8) va_arg(ap, VS_INT);
    break;

  case 268:
    EventArgsVar.DB47.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 276:
    EventArgsVar.DB47.VS_BOOLVar[0] = (VS_BOOL) va_arg(ap, VS_INT);
    break;

  case 289:
    EventArgsVar.DB297.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 292:
    EventArgsVar.DB297.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 293:
    EventArgsVar.DB297.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 294:
    EventArgsVar.DB297.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 295:
    EventArgsVar.DB297.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 296:
    EventArgsVar.DB297.VS_INT32Var[0] = (VS_INT32) va_arg(ap, VS_INT32_VAARG);
    EventArgsVar.DB297.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 297:
    EventArgsVar.DB297.VS_INT32Var[0] = (VS_INT32) va_arg(ap, VS_INT32_VAARG);
    EventArgsVar.DB297.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 298:
    EventArgsVar.DB297.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 299:
    EventArgsVar.DB297.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 300:
    EventArgsVar.DB297.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 301:
    EventArgsVar.DB297.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  default:
    break;
  }
  if (EventNo == SE_RESET)
  {
    SEM.EventNo = SE_RESET;
    SEM.DIt = 2;
  }
  else
  {
    SEM.EventNo = VS_TRIGGERLESS_TRIGGER;
    SEM.DIt = 0;
  }
  SEM.State = 0x02u; /* STATE_SEM_PREPARE */
  SEM.InitialEventNo = EventNo;
  SEM.OriginalEventNo = EventNo;

  va_end(ap);
  return (SES_OKAY);
}


/*
 * Guard Expression Functions.
 */
VS_BOOL AppHmi_NavigationStateMachine::VSGuard (SEM_GUARD_EXPRESSION_TYPE i)
{
  switch (i)
  {
  case 0:
    return (VS_BOOL)(EventArgsVar.DB297.VS_UINT32Var[0] == AppHmi_NavigationModule_NavigationScenes_Pfo_LatLong_Invalid);
  case 1:
    return (VS_BOOL)(EventArgsVar.DB297.VS_UINT32Var[0] == AppHmi_NavigationModule_NavigationScenes_Pfo_SingleLine_TwoButton);
  case 2:
    return (VS_BOOL)(IN_u8PopupType == Enum_POPUP_RESET_ALL_SETTINGS);
  case 3:
    return (VS_BOOL)(IN_u8PopupType == Enum_POPUP_SKIP_WAYPOINT);
  case 4:
    return (VS_BOOL)(EventArgsVar.DB297.VS_UINT32Var[0] == AppHmi_NavigationModule_NavigationScenes_Pfo_Dest_CalcRoute);
  case 5:
    return (VS_BOOL)(EventArgsVar.DB47.VS_UINT32Var[0] == AppHmi_NavigationModule_NavigationScenes_Pfo_Dest_CalcRoute);
  case 6:
    return (VS_BOOL)(EventArgsVar.DB297.VS_UINT32Var[0] == AppHmi_NavigationModule_NavigationScenes_Pfo_MultiLine_TwoButton);
  case 7:
    return (VS_BOOL)(VSDBVar.DB166.VS_BOOLVar[0] == Enum_BOOL_TRUE);
  case 8:
    return (VS_BOOL)(IN_u8PopupType != Enum_POPUP_VEHICLE_SETTINGS_SAVE_DURING_RG);
  case 9:
    return (VS_BOOL)(VSDBVar.DB166.VS_BOOLVar[0] == Enum_BOOL_FALSE);
  case 10:
    return (VS_BOOL)(IN_u8PopupType == Enum_POPUP_USER_POI_DELETE);
  case 11:
    return (VS_BOOL)(IN_u8PopupType == Enum_POPUP_VEHICLE_SETTINGS_SAVE_DURING_RG);
  case 12:
    return (VS_BOOL)(EventArgsVar.DB297.VS_UINT32Var[0] == AppHmi_NavigationModule_NavigationScenes_Pfo_ThreeLine_TwoButton);
  case 13:
    return (VS_BOOL)(EventArgsVar.DB297.VS_UINT32Var[0] == AppHmi_NavigationModule_NavigationScenes_Pfo_HomeEdit_Info_ThreeLine);
  case 14:
    return (VS_BOOL)(EventArgsVar.DB297.VS_UINT32Var[0] == AppHmi_NavigationModule_NavigationScenes_Pfo_MultiLine_Text);
  case 15:
    return (VS_BOOL)(EventArgsVar.DB297.VS_UINT32Var[0] == AppHmi_NavigationModule_NavigationScenes_Pfo_SpeedLockInfo);
  case 16:
    return (VS_BOOL)(EXT_bIsSpeedLockActive == Enum_BOOL_FALSE);
  case 17:
    return (VS_BOOL)(EventArgsVar.DB297.VS_UINT32Var[0] == AppHmi_NavigationModule_NavigationScenes_Pfo_FiveLine_TwoButton);
  case 18:
    return (VS_BOOL)(IN_u8PopupType == Enum_POPUP_USER_POI_IMPORT);
  case 19:
    return (VS_BOOL)(EventArgsVar.DB297.VS_UINT32Var[0] == AppHmi_NavigationModule_NavigationScenes_Pfo_ThreeLine_Text);
  case 20:
    return (VS_BOOL)(EventArgsVar.DB297.VS_UINT32Var[0] == AppHmi_NavigationModule_NavigationScenes_Pfo_SingleLine_SingleButton);
  case 21:
    return (VS_BOOL)(EventArgsVar.DB297.VS_UINT32Var[0] == AppHmi_NavigationModule_NavigationScenes_Pfo_ThreeLine_OneButton);
  case 22:
    return (VS_BOOL)(EventArgsVar.DB297.VS_UINT32Var[0] == AppHmi_NavigationModule_NavigationScenes_Pfo_MapUpdate_Progress);
  case 23:
    return (VS_BOOL)(EventArgsVar.DB47.VS_UINT32Var[0] == AppHmi_NavigationModule_NavigationScenes_Pfo_LCVHardRestrictionInfo_Multiple);
  case 24:
    return (VS_BOOL)(EventArgsVar.DB47.VS_UINT32Var[0] == AppHmi_NavigationModule_NavigationScenes_Pfo_LCVHardRestrictionConfirm_Multiple);
  case 25:
    return (VS_BOOL)(EventArgsVar.DB47.VS_UINT32Var[0] == AppHmi_NavigationModule_NavigationScenes_Pfo_RouteInfo);
  case 26:
    return (VS_BOOL)(EventArgsVar.DB47.VS_UINT32Var[0] == AppHmi_NavigationModule_NavigationScenes_Pfo_LCVRestrictionInfo);
  case 27:
    return (VS_BOOL)(EventArgsVar.DB47.VS_UINT32Var[0] == AppHmi_NavigationModule_NavigationScenes_Pfo_MapOut_Notification);
  case 28:
    return (VS_BOOL)(EventArgsVar.DB47.VS_UINT32Var[0] == AppHmi_NavigationModule_NavigationScenes_Pfo_FourLine_SingleButton);
  case 29:
    return (VS_BOOL)(EventArgsVar.DB47.VS_UINT32Var[0] == AppHmi_NavigationModule_NavigationScenes_Pfo_XUrgent_Message);
  case 30:
    return (VS_BOOL)(EventArgsVar.DB47.VS_UINT32Var[0] == AppHmi_NavigationModule_NavigationScenes_Pfo_Sys_ThreeLine_Text);
  case 31:
    return (VS_BOOL)(EventArgsVar.DB47.VS_UINT32Var[0] == AppHmi_NavigationModule_NavigationScenes_Pfo_MapUpdate_Error);
  case 32:
    return (VS_BOOL)(EventArgsVar.DB47.VS_UINT32Var[0] == AppHmi_NavigationModule_NavigationScenes_Pfo_MapUpdate_Interactive);
  case 33:
    return (VS_BOOL)(EventArgsVar.DB47.VS_UINT32Var[0] == AppHmi_NavigationModule_NavigationScenes_Pfo_SoftPhysicalRestrictionInfo);
  case 34:
    return (VS_BOOL)(IN_u8PopupType == Enum_POPUP_SOFT_PHYSICAL_RESTRICTIONS);
  case 35:
    return (VS_BOOL)(EventArgsVar.DB47.VS_UINT32Var[0] == AppHmi_NavigationModule_NavigationScenes_Pfo_AvoidTollRoad);
  case 36:
    return (VS_BOOL)(IN_u8PopupType == Enum_POPUP_AVOID_TOLL_ROAD);
  case 37:
    return (VS_BOOL)(EventArgsVar.DB47.VS_UINT32Var[0] == AppHmi_NavigationModule_NavigationScenes_Pfo_PremiumTrafficDisabled);
  case 38:
    return (VS_BOOL)(EventArgsVar.DB47.VS_UINT32Var[0] == AppHmi_NavigationModule_NavigationScenes_Pfo_LCVHardRestrictionInfo_ActiveRG);
  case 39:
    return (VS_BOOL)(EventArgsVar.DB47.VS_UINT32Var[0] == Enum_NAVIGATION_GADGET);
  case 40:
    return (VS_BOOL)(dgNaviMiddlewareStatus() == Enum_BOOL_TRUE);
  case 41:
    return (VS_BOOL)(EventArgsVar.DB47.VS_UINT32Var[0] == Enum_MAP_OVERLAY);
  case 42:
    return (VS_BOOL)(IN_bIsNaviMap == 0 && IN_bIsCautionAccepted == Enum_BOOL_FALSE);
  case 43:
    return (VS_BOOL)(IN_bIsCautionAccepted == Enum_BOOL_FALSE);
  case 44:
    return (VS_BOOL)(IN_bIsCautionAccepted == Enum_BOOL_TRUE);
  case 45:
    return (VS_BOOL)(EventArgsVar.DB47.VS_UINT32Var[0] == Enum_CONTEXT_SWITCH_FROM_TRAFFIC_DETOUR);
  case 46:
    return (VS_BOOL)(EventArgsVar.DB47.VS_UINT32Var[0] == AppHmi_NavigationModule_NavigationScenes_N_StreamedMap_SubOptions);
  case 47:
    return (VS_BOOL)(EventArgsVar.DB47.VS_BOOLVar[0] == Enum_BOOL_TRUE);
  case 48:
    return (VS_BOOL)(EventArgsVar.DB47.VS_BOOLVar[0] == Enum_BOOL_FALSE);
  case 49:
    return (VS_BOOL)(IN_bIsSettingsSavedDuringActiveRG == Enum_BOOL_FALSE);
  case 50:
    return (VS_BOOL)(IN_bIsUPOIInvalidate == Enum_BOOL_FALSE);
  case 51:
    return (VS_BOOL)(IN_bIsSettingsSavedDuringActiveRG == Enum_BOOL_TRUE);
  case 52:
    return (VS_BOOL)(IN_bIsUPOIInvalidate == Enum_BOOL_TRUE);
  case 53:
    return (VS_BOOL)(EventArgsVar.DB47.VS_UINT32Var[0] == 1);
  case 54:
    return (VS_BOOL)(IN_u32PreviousSceneViewId == AppHmi_NavigationModule_NavigationScenes_Pfo_Dest_VehicleInfo);
  case 55:
    return (VS_BOOL)(EventArgsVar.DB47.VS_UINT32Var[0] == 0);
  case 56:
    return (VS_BOOL)(EventArgsVar.DB47.VS_UINT32Var[0] == 2);
  case 57:
    return (VS_BOOL)(EXT_bIsUPOIContext == Enum_BOOL_TRUE);
  case 58:
    return (VS_BOOL)(IN_u32CurrentNaviContext != Enum_CONTEXT_SWITCH_FROM_SETTINGS && IN_u32CurrentNaviContext != Enum_CONTEXT_SWITCH_FROM_TRAFFIC_DETOUR);
  case 59:
    return (VS_BOOL)(IN_u32CurrentNaviContext == Enum_CONTEXT_SWITCH_FROM_SETTINGS);
  case 60:
    return (VS_BOOL)(IN_u32CurrentNaviContext == Enum_CONTEXT_SWITCH_FROM_TRAFFIC_DETOUR);
  case 61:
    return (VS_BOOL)(IN_u32CurrentNaviContext != Enum_CONTEXT_SWITCH_FROM_SETTINGS);
  case 62:
    return (VS_BOOL)(dgEngineeringMenuTopListStatus() == 0);
  case 63:
    return (VS_BOOL)(IN_u32CurrentNaviContext == Enum_CONTEXT_SWITCH_FROM_DESTINATIONS);
  case 64:
    return (VS_BOOL)(IN_u32CurrentNaviContext == Enum_CONTEXT_SWITCH_FROM_N_MAP);
  case 65:
    return (VS_BOOL)(IN_u32CurrentNaviContext == Enum_CONTEXT_SWITCH_FROM_ENGGMENU);
  case 66:
    return (VS_BOOL)(IN_u32PreviousSceneViewId == AppHmi_NavigationModule_NavigationScenes_N_OPT);
  case 67:
    return (VS_BOOL)(IN_u8SettingMapsOtherHierarchyLevel == Enum_MAP_SETTINGS_LEFT_SPLIT_MAP);
  case 68:
    return (VS_BOOL)(IN_u8SettingMapsOtherHierarchyLevel == Enum_MAP_SETTINGS_TRACKING_DOTS);
  case 69:
    return (VS_BOOL)(IN_u8SettingMapsOtherHierarchyLevel == Enum_MAP_SETTINGS_OTHERS_MAIN);
  case 70:
    return (VS_BOOL)(IN_u8SettingMapsOtherHierarchyLevel != Enum_MAP_SETTINGS_OTHERS_MAIN);
  case 71:
    return (VS_BOOL)(IN_bIsOPTVehicleBackTouch == Enum_BOOL_TRUE);
  case 72:
    return (VS_BOOL)(EXT_bIsPremiumTrafficDisclaimerShown == Enum_BOOL_FALSE);
  case 73:
    return (VS_BOOL)(EXT_bIsGuidanceActive == Enum_BOOL_TRUE);
  case 74:
    return (VS_BOOL)(EXT_bIsGuidanceActive == Enum_BOOL_FALSE && VSDBVar.DB45.VS_UINT8Var[0] != 1);
  case 75:
    return (VS_BOOL)(VSDBVar.DB45.VS_UINT8Var[0] == 1);
  case 76:
    return (VS_BOOL)(EXT_bIsGuidanceActive == Enum_BOOL_FALSE);
  case 77:
    return (VS_BOOL)(IN_u8LastEnteredDetailedInfo == NAVI_HMI_SM_C_TMC_DETAILEDINFO && VSDBVar.DB45.VS_BOOLVar[1] == Enum_BOOL_TRUE && VSDBVar.DB45.VS_UINT8Var[0] != 1);
  case 78:
    return (VS_BOOL)(IN_u8LastEnteredDetailedInfo == NAVI_HMI_SM_C_TMC_DETAILEDINFO && VSDBVar.DB45.VS_BOOLVar[1] == Enum_BOOL_FALSE && VSDBVar.DB45.VS_UINT8Var[0] != 1);
  case 79:
    return (VS_BOOL)(VSDBVar.DB97.VS_INTVar[0] == NAVI_HMI_SM_C_TMC_DETAILEDINFO && EXT_bIsGuidanceActive == Enum_BOOL_FALSE);
  case 80:
    return (VS_BOOL)(VSDBVar.DB97.VS_INTVar[0] == NAVI_HMI_SM_C_TMC_DETAILEDINFO && EXT_bIsGuidanceActive == Enum_BOOL_TRUE);
  case 81:
    return (VS_BOOL)(VSDBVar.DB97.VS_INTVar[0] == NAVI_HMI_SM_C_WAYPOINT_DETAILEDINFO);
  case 82:
    return (VS_BOOL)(VSDBVar.DB97.VS_INTVar[0] == NAVI_HMI_SM_C_ROUTE_DESTINATIONINFO);
  case 83:
    return (VS_BOOL)(VSDBVar.DB97.VS_INTVar[0] == NAVI_HMI_SM_C_PICK_IN_MAP_DETAILEDINFO);
  case 84:
    return (VS_BOOL)(VSDBVar.DB97.VS_INTVar[0] == NAVI_HMI_SM_C_LATLONG_DETAILEDINFO);
  case 85:
    return (VS_BOOL)(VSDBVar.DB97.VS_INTVar[0] == NAVI_HMI_SM_C_LASTDESTINATION_DETAILEDINFO);
  case 86:
    return (VS_BOOL)(VSDBVar.DB97.VS_INTVar[0] == NAVI_HMI_SM_C_HOME_DETAILEDINFO);
  case 87:
    return (VS_BOOL)(VSDBVar.DB97.VS_INTVar[0] == NAVI_HMI_SM_C_FAVORITE_DETAILEDINFO);
  case 88:
    return (VS_BOOL)(VSDBVar.DB97.VS_INTVar[0] == NAVI_HMI_SM_C_BYMAP_DETAILEDINFO);
  case 89:
    return (VS_BOOL)(VSDBVar.DB97.VS_INTVar[0] == NAVI_HMI_SM_C_POI_DETAILEDINFO);
  case 90:
    return (VS_BOOL)(VSDBVar.DB97.VS_INTVar[0] == NAVI_HMI_SM_C_ADDRESSINPUT_DETAILEDINFO);
  case 91:
    return (VS_BOOL)(dgEngineeringMenuListStatus() == 1);
  case 92:
    return (VS_BOOL)(dgEngineeringMenuTopListStatus() != 0);
  case 93:
    return (VS_BOOL)(dgEngineeringMenuListStatus() != 1);
  case 94:
    return (VS_BOOL)(EventArgsVar.DB47.VS_UINT32Var[0] == Enum_SHOW_DESTINATION_GUIDANCE);
  case 95:
    return (VS_BOOL)(EventArgsVar.DB47.VS_UINT32Var[0] == Enum_SHOW_MULTIPLE_ROUTE);
  case 96:
    return (VS_BOOL)(EXT_bIsSpeedLockActive == Enum_BOOL_TRUE);
  case 97:
    return (VS_BOOL)(EXT_bIsGuidanceActive == 0 && IN_u32PreviousSceneViewId == AppHmi_NavigationModule_NavigationScenes_N_Guidance);
  case 98:
    return (VS_BOOL)(EXT_bIsGuidanceActive == 0 && IN_u32PreviousSceneViewId == AppHmi_NavigationModule_NavigationScenes_N_PickInMapOption);
  case 99:
    return (VS_BOOL)(IN_u32PreviousSceneViewId == AppHmi_NavigationModule_NavigationScenes_N_MyPOIs_AddressInput);
  case 100:
    return (VS_BOOL)(IN_u32PreviousSceneViewId == AppHmi_NavigationModule_NavigationScenes_N_NewDest_AddressInput);
  case 101:
    return (VS_BOOL)(VSDBVar.DB166.VS_BOOLVar[0] == 0);
  case 102:
    return (VS_BOOL)(IN_bIsDestGuidance == Enum_BOOL_TRUE);
  case 103:
    return (VS_BOOL)(VSDBVar.DB97.VS_UINT32Var[0] == Enum_POI_ENTRY_FROM_NEARBY_AND_ONROUTE_AND_ATDEST && EXT_bIsGuidanceActive == 1);
  case 104:
    return (VS_BOOL)(VSDBVar.DB97.VS_UINT32Var[0] == Enum_POI_ENTRY_FROM_POIAROUND);
  case 105:
    return (VS_BOOL)(VSDBVar.DB97.VS_UINT32Var[0] == Enum_POI_ENTRY_FROM_SEARCH);
  case 106:
    return (VS_BOOL)(VSDBVar.DB97.VS_UINT32Var[0] == Enum_POI_ENTRY_FROM_NEARBY_AND_ONROUTE_AND_ATDEST && EXT_bIsGuidanceActive == 0);
  case 107:
    return (VS_BOOL)(dgPOIResultListStatus() == 1);
  case 108:
    return (VS_BOOL)(IN_bIsBrowseBack == Enum_BOOL_FALSE);
  case 109:
    return (VS_BOOL)(dgPOIResultListStatus() != 1);
  case 110:
    return (VS_BOOL)(IN_bIsBrowseBack == Enum_BOOL_TRUE);
  case 111:
    return (VS_BOOL)(IN_bIsSublevel == 1);
  case 112:
    return (VS_BOOL)(EXT_bIsPOIFts == 0);
  case 113:
    return (VS_BOOL)(IN_bIsSublevel == Enum_BOOL_FALSE);
  case 114:
    return (VS_BOOL)(EXT_bIsPOIFts == Enum_BOOL_FALSE);
  case 115:
    return (VS_BOOL)(EXT_bIsPOIFts == Enum_BOOL_TRUE);
  case 116:
    return (VS_BOOL)(dgPOIResultListStatus() == 0 && dgPOITopCategoryStatus() == 0);
  case 117:
    return (VS_BOOL)(dgPOITopCategoryStatus() != 1);
  case 118:
    return (VS_BOOL)(dgPOITopCategoryStatus() == 1);
  case 119:
    return (VS_BOOL)(EXT_bIsUPOIContext == Enum_BOOL_FALSE);
  case 120:
    return (VS_BOOL)(IN_u8LastEnteredDetailedInfo == NAVI_HMI_SM_C_POI_DETAILEDINFO);
  case 121:
    return (VS_BOOL)(IN_u32CurrentSceneViewId == AppHmi_NavigationModule_NavigationScenes_N_MyPOIs_AddressInput);
  case 122:
    return (VS_BOOL)(IN_u32CurrentSceneViewId == AppHmi_NavigationModule_NavigationScenes_N_LatLongInput);
  case 123:
    return (VS_BOOL)(IN_u8LastEnteredDetailedInfo == NAVI_HMI_SM_C_LATLONG_DETAILEDINFO);
  case 124:
    return (VS_BOOL)(VSDBVar.DB166.VS_INTVar[0] == NAVI_HMI_SM_C_LASTDESTINATION_DETAILEDINFO);
  case 125:
    return (VS_BOOL)(IN_u8LastEnteredDetailedInfo == NAVI_HMI_SM_C_LASTDESTINATION_DETAILEDINFO);
  case 126:
    return (VS_BOOL)(IN_bIsHomeAddressInput == Enum_BOOL_TRUE);
  case 127:
    return (VS_BOOL)(IN_u32PreviousSceneViewId == AppHmi_NavigationModule_NavigationScenes_N_Map);
  case 128:
    return (VS_BOOL)(IN_u32PreviousSceneViewId == AppHmi_NavigationModule_NavigationScenes_N_Favorites);
  case 129:
    return (VS_BOOL)(VSDBVar.DB166.VS_INTVar[0] == NAVI_HMI_SM_C_HOME_DETAILEDINFO);
  case 130:
    return (VS_BOOL)(IN_u8LastEnteredDetailedInfo == NAVI_HMI_SM_C_HOME_DETAILEDINFO);
  case 131:
    return (VS_BOOL)(IN_u8LastEnteredDetailedInfo == NAVI_HMI_SM_C_FAVORITE_DETAILEDINFO);
  case 132:
    return (VS_BOOL)(VSDBVar.DB166.VS_INTVar[0] == NAVI_HMI_SM_C_FAVORITE_DETAILEDINFO);
  case 133:
    return (VS_BOOL)(VSDBVar.DB166.VS_INTVar[0] == 2);
  case 134:
    return (VS_BOOL)(IN_bIsFavorite == Enum_BOOL_TRUE && VSDBVar.DB166.VS_INTVar[0] == NAVI_HMI_SM_C_POI_DETAILEDINFO);
  case 135:
    return (VS_BOOL)(IN_bIsFavorite == Enum_BOOL_TRUE);
  case 136:
    return (VS_BOOL)(IN_bIsFavorite == Enum_BOOL_TRUE && VSDBVar.DB166.VS_INTVar[0] == NAVI_HMI_SM_C_BYMAP_DETAILEDINFO);
  case 137:
    return (VS_BOOL)(IN_bIsFavorite == Enum_BOOL_TRUE && VSDBVar.DB166.VS_INTVar[0] == NAVI_HMI_SM_C_ADDRESSINPUT_DETAILEDINFO);
  case 138:
    return (VS_BOOL)(IN_bIsFavorite == Enum_BOOL_TRUE && VSDBVar.DB166.VS_INTVar[0] == NAVI_HMI_SM_C_ROUTE_DESTINATIONINFO);
  case 139:
    return (VS_BOOL)(IN_bIsFavorite == Enum_BOOL_TRUE && VSDBVar.DB166.VS_INTVar[0] == NAVI_HMI_SM_C_LATLONG_DETAILEDINFO);
  case 140:
    return (VS_BOOL)(IN_bIsFavorite == Enum_BOOL_TRUE && VSDBVar.DB166.VS_INTVar[0] == NAVI_HMI_SM_C_WAYPOINT_DETAILEDINFO);
  case 141:
    return (VS_BOOL)(IN_u32CurrentSceneViewId == AppHmi_NavigationModule_NavigationScenes_N_Fav_AddFavorites);
  case 142:
    return (VS_BOOL)(IN_bIsGoToHomeEnabled == Enum_BOOL_TRUE);
  case 143:
    return (VS_BOOL)(IN_bIsGoToHomeEnabled == Enum_BOOL_FALSE);
  case 144:
    return (VS_BOOL)(EXT_bIsGuidanceActive == 0);
  case 145:
    return (VS_BOOL)(VSDBVar.DB97.VS_UINT32Var[0] == AppHmi_NavigationModule_NavigationScenes_N_NewDestination);
  case 146:
    return (VS_BOOL)(VSDBVar.DB97.VS_UINT32Var[0] == AppHmi_NavigationModule_NavigationScenes_N_Map);
  case 147:
    return (VS_BOOL)(IN_u8TrafficDetialBackHandling == 1 && EXT_bIsGuidanceActive == Enum_BOOL_FALSE);
  case 148:
    return (VS_BOOL)(IN_u8TrafficDetialBackHandling == 1 && EXT_bIsGuidanceActive == Enum_BOOL_TRUE);
  case 149:
    return (VS_BOOL)(IN_u8LastEnteredDetailedInfo == NAVI_HMI_SM_C_BYMAP_DETAILEDINFO && VSDBVar.DB45.VS_BOOLVar[0] == Enum_BOOL_FALSE && IN_bIsPickPOIOnMap == Enum_BOOL_FALSE);
  case 150:
    return (VS_BOOL)(VSDBVar.DB45.VS_BOOLVar[0] == 1 && IN_u8LastEnteredDetailedInfo == NAVI_HMI_SM_C_BYMAP_DETAILEDINFO);
  case 151:
    return (VS_BOOL)(IN_u8LastEnteredDetailedInfo == NAVI_HMI_SM_C_BYMAP_DETAILEDINFO && VSDBVar.DB45.VS_BOOLVar[0] == Enum_BOOL_FALSE && IN_bIsPickPOIOnMap == Enum_BOOL_TRUE);
  case 152:
    return (VS_BOOL)(IN_ByMapSubLevelViewID == AppHmi_NavigationModule_NavigationScenes_N_Map_Move);
  case 153:
    return (VS_BOOL)(EventArgsVar.DB170.VS_UINT8Var[0] == 3);
  case 154:
    return (VS_BOOL)(IN_ByMapSubLevelViewID == AppHmi_NavigationModule_NavigationScenes_N_POIInfo);
  case 155:
    return (VS_BOOL)(EventArgsVar.DB170.VS_UINT8Var[0] == 2);
  case 156:
    return (VS_BOOL)(IN_u8LastEnteredDetailedInfo == NAVI_HMI_SM_C_ADDRESSINPUT_DETAILEDINFO);
  case 157:
    return (VS_BOOL)(IN_u32CurrentSceneViewId == AppHmi_NavigationModule_NavigationScenes_N_SpellerEdit);
  case 158:
    return (VS_BOOL)(IN_bIsUPOIFreeTextSearch == Enum_BOOL_TRUE);
  case 159:
    return (VS_BOOL)(IN_bIsUPOIFreeTextSearch == Enum_BOOL_FALSE);
  case 160:
    return (VS_BOOL)(VSDBVar.DB166.VS_INTVar[0] == NAVI_HMI_SM_C_LATLONG_DETAILEDINFO);
  case 161:
    return (VS_BOOL)(VSDBVar.DB166.VS_INTVar[0] == NAVI_HMI_SM_C_ADDRESSINPUT_DETAILEDINFO);
  case 162:
    return (VS_BOOL)(VSDBVar.DB166.VS_INTVar[0] == NAVI_HMI_SM_C_POI_DETAILEDINFO);
  case 163:
    return (VS_BOOL)(VSDBVar.DB166.VS_INTVar[0] == NAVI_HMI_SM_C_BYMAP_DETAILEDINFO);
  case 164:
    return (VS_BOOL)(VSDBVar.DB166.VS_INTVar[0] == NAVI_HMI_SM_C_ROUTE_DESTINATIONINFO);
  case 165:
    return (VS_BOOL)(VSDBVar.DB166.VS_INTVar[0] == NAVI_HMI_SM_C_WAYPOINT_DETAILEDINFO);
  case 166:
    return (VS_BOOL)(EXT_bIsMaxFavReached == Enum_BOOL_FALSE);
  case 167:
    return (VS_BOOL)(EXT_bIsMaxFavReached == Enum_BOOL_TRUE);
  case 168:
    return (VS_BOOL)(VSDBVar.DB166.VS_INTVar[0] == NAVI_HMI_SM_C_WAYPOINT_DETAILEDINFO && IN_u8PopupType == 7 && EXT_bIsWaypointDestinationIndex == Enum_BOOL_TRUE);
  case 169:
    return (VS_BOOL)(VSDBVar.DB166.VS_INTVar[0] == NAVI_HMI_SM_C_WAYPOINT_DETAILEDINFO && IN_u8PopupType == 8);
  case 170:
    return (VS_BOOL)(VSDBVar.DB166.VS_INTVar[0] == NAVI_HMI_SM_C_WAYPOINT_DETAILEDINFO && IN_u8PopupType == 7 && EXT_bIsWaypointDestinationIndex == 0);
  }
  return (VS_BOOL)(IN_u8LastEnteredDetailedInfo == NAVI_HMI_SM_C_WAYPOINT_DETAILEDINFO);
}


/*
 * Action Expressions Wrapper Function.
 */
VS_VOID AppHmi_NavigationStateMachine::VSAction (SEM_ACTION_EXPRESSION_TYPE i)
{
  switch (i)
  {
  case 0:
    Notify_Init_Finished();
    break;
  case 1:
    acAcceptTrafficAlternativeReqMsg();
    break;
  case 2:
    acApplyDetailedRoutepreferencesOptions();
    break;
  case 3:
    acApplyGuidanceSettings();
    break;
  case 4:
    acApplyMapViewSettings();
    break;
  case 5:
    acApplyPremiumTrafficSettings();
    break;
  case 6:
    acApplyRoutePreferenceOptions();
    break;
  case 7:
    acApplySettings();
    break;
  case 8:
    acApplyTrafficIconsSettings();
    break;
  case 9:
    acAvoidTollRoad();
    break;
  case 10:
    acCancelActiveRouteGuidance();
    break;
  case 11:
    acCancelMultipleRouteIfAvailable();
    break;
  case 13:
    acChangeCoordinateFormat();
    break;
  case 15:
    acCheckIsSatelliteSourceChanged();
    break;
  case 16:
    acCheckIsVehicleSettingsChanged();
    break;
  case 18:
    acDeleteAllUPOIsReqMsg();
    break;
  case 19:
    acDeleteTrackingPoint();
    break;
  case 20:
    acDeselectEngineeringMenu();
    break;
  case 21:
    acDisableWhereAmI();
    break;
  case 22:
    acEnableWhereAmI();
    break;
  case 23:
    acEnterEngineeringMenu();
    break;
  case 24:
    acExitEngineeringMenu();
    break;
  case 25:
    acFetchPremiumTrafficSettings();
    break;
  case 27:
    acFreezeMapAction();
    break;
  case 28:
    acHardRestrictionConfirmMultiple();
    break;
  case 29:
    acInitializeLatLongSpellerEntry();
    break;
  case 30:
    acLeaveFormBasedAddressInput();
    break;
  case 31:
    acLeftMapViewSetMapScaleSettings();
    break;
  case 32:
    acMapScreen();
    break;
  case 33:
    acMapTimerExpired();
    break;
  case 34:
    acNAVDATAUPDATE_Nav_ErrorMsgDuringUpdatePressOk();
    break;
  case 35:
    acNAVDATAUPDATE_Nav_FullMapUpdateNo();
    break;
  case 36:
    acPOICategoryBrowseBack();
    break;
  case 37:
    acPOILeaveFts();
    break;
  case 38:
    acPOILeaveInput();
    break;
  case 39:
    acPOIStartFts();
    break;
  case 41:
    acRecenterMap();
    break;
  case 42:
    acRejectTrafficAlternativeReqMsg();
    break;
  case 43:
    acReleasePickInMap();
    break;
  case 44:
    acReleaseXUrgentTrafficMessageReqMsg();
    break;
  case 45:
    acReplaceHomeFav();
    break;
  case 46:
    acResetAllNaviSettings();
    break;
  case 47:
    acResetCoordinates();
    break;
  case 48:
    acResetDetailedAddress();
    break;
  case 49:
    acResetEngineeringMenu();
    break;
  case 51:
    acResetTripCountReqMsg();
    break;
  case 52:
    acResetVehicleProfileInfo();
    break;
  case 54:
    acRetriggerLastGuidedRoute();
    break;
  case 55:
    acRouteStartGuidance();
    break;
  case 56:
    acSavePickInMapCoordinates();
    break;
  case 58:
    acSetLatDecimalsActive();
    break;
  case 59:
    acSetLatDegreesActive();
    break;
  case 60:
    acSetLatLongInputValues();
    break;
  case 61:
    acSetLatMinutesActive();
    break;
  case 62:
    acSetLatSecondsActive();
    break;
  case 63:
    acSetLongDecimalsActive();
    break;
  case 64:
    acSetLongDegreesActive();
    break;
  case 65:
    acSetLongMinutesActive();
    break;
  case 66:
    acSetLongSecondsActive();
    break;
  case 67:
    acSetPOISearchLocation();
    break;
  case 68:
    acSetPickInMapLocation();
    break;
  case 69:
    acShowAllPOICategory();
    break;
  case 70:
    acStartRouteGuidance();
    break;
  case 71:
    acStartTrafficDetourTimer();
    break;
  case 72:
    acStoreLocationOnByMapOkPress();
    break;
  case 73:
    acSwitchContextFromNavDataUpdate();
    break;
  case 74:
    acSwitchContextFromTrafficDetour();
    break;
  case 75:
    acToggleEastWest();
    break;
  case 76:
    acToggleSouthNorth();
    break;
  case 77:
    acTriggerMapPicking();
    break;
  case 78:
    acUPOIBrowseBack();
    break;
  case 79:
    acUPOILeaveInput();
    break;
  case 80:
    acUPOIResetCoordinates();
    break;
  case 81:
    acUnfreezeMapAction();
    break;
  case 82:
    acUpdateSpeedLockPopupText();
    break;
  case 83:
    acUpdateStartupVehicleProfileInfo();
    break;
  case 107:
    EXT_IsMapScrollTapEnable = Enum_BOOL_TRUE;
    break;
  case 108:
    IN_bIsMapShown = Enum_BOOL_FALSE;
    break;
  case 109:
    IN_bIsDestGuidance = Enum_BOOL_FALSE;
    break;
  case 110:
    Ext_bIsEnableByMapOKBtn = Enum_BOOL_FALSE;
    break;
  case 111:
    IN_u32CurrentSceneViewId = AppHmi_NavigationModule_NavigationScenes_N_NewDestination;
    break;
  case 112:
    IN_bIsDestGuidance = Enum_BOOL_TRUE;
    break;
  case 113:
    IN_bIsSettingsSavedDuringActiveRG = Enum_BOOL_TRUE;
    break;
  case 114:
    IN_bIsSettingsSavedDuringActiveRG = Enum_BOOL_FALSE;
    break;
  case 115:
    IN_bIsMapUpdateTriggered = Enum_BOOL_FALSE;
    break;
  case 116:
    IN_bIsMapUpdateTriggered = Enum_BOOL_TRUE;
    break;
  case 117:
    IN_bIsCautionAccepted = Enum_BOOL_TRUE;
    break;
  case 118:
    EXT_bIsUPOIContext = Enum_BOOL_FALSE;
    break;
  case 119:
    EXT_bIsNaviAppRunning = Enum_BOOL_TRUE;
    break;
  case 120:
    IN_u32CurrentNaviContext = EventArgsVar.DB47.VS_UINT32Var[0];
    break;
  case 121:
    IN_u8PopupType = EventArgsVar.DB170.VS_UINT8Var[0];
    break;
  case 122:
    IN_u32PreviousSceneViewIdBeforeSettings = IN_u32PreviousSceneViewId;
    break;
  case 123:
    IN_bIsUPOIInvalidate = Enum_BOOL_FALSE;
    break;
  case 124:
    IN_bIsVehicleProfileChanged = Enum_BOOL_FALSE;
    break;
  case 125:
    IN_u32CurrentSceneViewId = AppHmi_NavigationModule_NavigationScenes_N_OPT;
    break;
  case 126:
    IN_u32PreviousSceneViewId = IN_u32PreviousSceneViewIdBeforeSettings;
    break;
  case 127:
    IN_u32CurrentSceneViewId = AppHmi_NavigationModule_NavigationScenes_N_Map;
    break;
  case 128:
    IN_bIsMapShown = Enum_BOOL_TRUE;
    break;
  case 129:
    EXT_bIsGuidanceActive = Enum_BOOL_FALSE;
    break;
  case 130:
    IN_u32CurrentMapViewState = dgMainMapScreenStateValue();
    break;
  case 131:
    EXT_bIsGuidanceActive = Enum_BOOL_TRUE;
    break;
  case 132:
    IN_u8TrafficDetialBackHandling = 0;
    break;
  case 133:
    IN_u8LastEnteredDetailedInfo = NAVI_HMI_SM_C_TMC_DETAILEDINFO;
    break;
  case 134:
    IN_bIsTMCOnRoute = Enum_BOOL_TRUE;
    break;
  case 135:
    IN_bIsTMCOnRoute = Enum_BOOL_FALSE;
    break;
  case 136:
    EXT_IsMapScrollTapEnable = Enum_BOOL_FALSE;
    break;
  case 137:
    EXT_bIsMapCameraModeChangeDone = Enum_BOOL_FALSE;
    break;
  case 138:
    IN_u32PreviousSceneViewId = AppHmi_NavigationModule_NavigationScenes_N_NewDestination;
    break;
  case 139:
    IN_bIsHomeAddressInput = Enum_BOOL_FALSE;
    break;
  case 140:
    EXT_bIsPOIFts = Enum_BOOL_FALSE;
    break;
  case 141:
    IN_u8LastEnteredDetailedInfo = NAVI_HMI_SM_C_POI_DETAILEDINFO;
    break;
  case 142:
    IN_u32CurrentSceneViewId = AppHmi_NavigationModule_NavigationScenes_N_MyPOIs_AddressInput;
    break;
  case 143:
    IN_u32CurrentSceneViewId = AppHmi_NavigationModule_NavigationScenes_N_LatLongInput;
    break;
  case 144:
    IN_u8LastEnteredDetailedInfo = NAVI_HMI_SM_C_LATLONG_DETAILEDINFO;
    break;
  case 145:
    IN_u8LastEnteredDetailedInfo = NAVI_HMI_SM_C_LASTDESTINATION_DETAILEDINFO;
    break;
  case 146:
    IN_bIsHomeAddressInput = Enum_BOOL_TRUE;
    break;
  case 147:
    IN_u8LastEnteredDetailedInfo = NAVI_HMI_SM_C_HOME_DETAILEDINFO;
    break;
  case 148:
    IN_u8LastEnteredDetailedInfo = NAVI_HMI_SM_C_FAVORITE_DETAILEDINFO;
    break;
  case 149:
    IN_u32CurrentSceneViewId = AppHmi_NavigationModule_NavigationScenes_N_Fav_AddFavorites;
    break;
  case 150:
    IN_bIsFavorite = Enum_BOOL_TRUE;
    break;
  case 151:
    Inu32PopupOK = 1;
    break;
  case 152:
    IN_u8LastEnteredDetailedInfo = NAVI_HMI_SM_C_ROUTE_DESTINATIONINFO;
    break;
  case 153:
    IN_u8LastEnteredDetailedInfo = NAVI_HMI_SM_C_WAYPOINT_DETAILEDINFO;
    break;
  case 154:
    IN_u8TrafficDetialBackHandling = 1;
    break;
  case 155:
    IN_bIsMapPickInOptionScene = 0;
    break;
  case 156:
    IN_u32CurrentSceneViewId = AppHmi_NavigationModule_NavigationScenes_N_Map_Move;
    break;
  case 157:
    IN_u8LastEnteredDetailedInfo = NAVI_HMI_SM_C_BYMAP_DETAILEDINFO;
    break;
  case 158:
    IN_bIsMapPickInOptionScene = 1;
    break;
  case 159:
    IN_u8LastEnteredDetailedInfo = NAVI_HMI_SM_C_ADDRESSINPUT_DETAILEDINFO;
    break;
  case 160:
    IN_u32CurrentSceneViewId = AppHmi_NavigationModule_NavigationScenes_N_SpellerEdit;
    break;
  case 161:
    IN_bIsUPOIInvalidate = Enum_BOOL_TRUE;
    break;
  case 162:
    IN_u32CurrentNaviContext = EventArgsVar.DB47.VS_UINT32Var[0];
    break;
  case 163:
    IN_u32CurrentNaviContext = EventArgsVar.DB47.VS_UINT32Var[0];
    break;
  case 164:
    EXT_bCenterMapToCurrentPosition = Enum_BOOL_TRUE;
    break;
  case 165:
    IN_u32PreviousSceneViewId = AppHmi_NavigationModule_NavigationScenes_N_OPT;
    break;
  case 166:
    IN_bIsOPTVehicleBackTouch = Enum_BOOL_FALSE;
    break;
  case 167:
    IN_u8SettingMapsOtherHierarchyLevel = Enum_MAP_SETTINGS_OTHERS_MAIN;
    break;
  case 168:
    IN_u8SettingMapsOtherHierarchyLevel = EventArgsVar.DB47.VS_UINT32Var[0];
    break;
  case 169:
    IN_u8PopupType = 9;
    break;
  case 170:
    IN_u32PreviousSceneViewId = AppHmi_NavigationModule_NavigationScenes_Pfo_Dest_VehicleInfo;
    break;
  case 171:
    IN_u8PopupType = Enum_POPUP_VEHICLE_SETTINGS_SAVE_DURING_RG;
    break;
  case 172:
    EXT_bIsPremiumTrafficDisclaimerShown = Enum_BOOL_TRUE;
    break;
  case 173:
    EXT_bIsPremiumTrafficDisclaimerShown = Enum_BOOL_FALSE;
    break;
  case 174:
    IN_bIsGoToHomeEnabled = EventArgsVar.DB47.VS_BOOLVar[0];
    break;
  case 175:
    IN_u32PreviousSceneViewId = AppHmi_NavigationModule_NavigationScenes_N_Map;
    break;
  case 176:
    IN_u32PreviousSceneViewId = AppHmi_NavigationModule_NavigationScenes_N_Map_ActiveRG;
    break;
  case 177:
    IN_u32EntryToPOI = Enum_POI_ENTRY_FROM_NEARBY_AND_ONROUTE_AND_ATDEST;
    break;
  case 178:
    IN_u8POISelected = Enum_SEARCHSCOPE_AROUND_CURRENT_VEHICLE_POSITION;
    break;
  case 179:
    Ext_bIsEnableByMapOKBtn = Enum_BOOL_TRUE;
    break;
  case 180:
    IN_bIsUPOIFreeTextSearch = Enum_BOOL_TRUE;
    break;
  case 181:
    IN_bIsUPOIFreeTextSearch = Enum_BOOL_FALSE;
    break;
  case 182:
    IN_u32EntryToPOI = Enum_POI_ENTRY_DEFAULT;
    break;
  case 183:
    IN_u32PreviousSceneViewId = IN_u32SecondPreviousSceneViewId;
    break;
  case 184:
    EXT_bIsPOIFts = 1;
    break;
  case 185:
    IN_bIsBrowseBack = Enum_BOOL_FALSE;
    break;
  case 186:
    IN_bIsBrowseBack = Enum_BOOL_TRUE;
    break;
  case 187:
    IN_bIsSublevel = Enum_BOOL_TRUE;
    break;
  case 188:
    IN_bIsSublevel = Enum_BOOL_FALSE;
    break;
  case 189:
    EXT_bIsPOIFts = 0;
    break;
  case 190:
    IN_u8PopupType = 1;
    break;
  case 191:
    IN_u8PopupType = 0;
    break;
  case 192:
    IN_u32PreviousSceneViewId = AppHmi_NavigationModule_NavigationScenes_N_Favorites;
    break;
  case 193:
    IN_u32PreviousSceneViewId = AppHmi_NavigationModule_NavigationScenes_N_Fav_SetHome;
    break;
  case 194:
    IN_u8PopupType = Enum_POPUP_FAVORITES_DELETE_ALL;
    break;
  case 195:
    IN_bIsSelectedFavDelete = Enum_BOOL_TRUE;
    break;
  case 196:
    IN_u8PopupType = Enum_POPUP_FAVORITES_DELETE;
    break;
  case 197:
    IN_bIsSelectedFavDelete = Enum_BOOL_FALSE;
    break;
  case 198:
    IN_u32PreviousSceneViewId = AppHmi_NavigationModule_NavigationScenes_N_Guidance;
    break;
  case 199:
    IN_u8POISelected = Enum_SEARCHSCOPE_ALONG_ROUTE;
    break;
  case 200:
    IN_u8POISelected = Enum_SEARCHSCOPE_AROUND_WAYPOINT_POSITION;
    break;
  case 201:
    EXT_bIsGuidanceActive = 0;
    break;
  case 202:
    IN_ByMapSubLevelViewID = AppHmi_NavigationModule_NavigationScenes_N_Map_Move;
    break;
  case 203:
    IN_bIsPickPOIOnMap = Enum_BOOL_TRUE;
    break;
  case 204:
    IN_bIsPickPOIOnMap = Enum_BOOL_FALSE;
    break;
  case 205:
    IN_u8LastEnteredDetailedInfo = NAVI_HMI_SM_C_PICK_IN_MAP_DETAILEDINFO;
    break;
  case 206:
    IN_ByMapSubLevelViewID = AppHmi_NavigationModule_NavigationScenes_N_POIInfo;
    break;
  case 207:
    IN_u32EntryToPOI = Enum_POI_ENTRY_FROM_POIAROUND;
    break;
  case 208:
    IN_u32SecondPreviousSceneViewId = IN_u32PreviousSceneViewId;
    break;
  case 209:
    IN_u32PreviousSceneViewId = AppHmi_NavigationModule_NavigationScenes_N_PickInMapOption;
    break;
  case 210:
    IN_u32EntryToPOI = Enum_POI_ENTRY_FROM_SEARCH;
    break;
  case 211:
    IN_u32PreviousSceneViewId = AppHmi_NavigationModule_NavigationScenes_N_MyPOIs_AddressInput;
    break;
  case 212:
    IN_u32PreviousSceneViewId = AppHmi_NavigationModule_NavigationScenes_N_NewDest_AddressInput;
    break;
  case 213:
    EXT_bIsUPOIContext = Enum_BOOL_TRUE;
    break;
  case 214:
    IN_bIsFavorite = Enum_BOOL_FALSE;
    break;
  case 215:
    IN_u8PopupType = 2;
    break;
  case 216:
    IN_u8PopupType = 8;
    break;
  case 217:
    IN_u8PopupType = 7;
    break;
  case 218:
    gacViewDestroyReq(AppHmi_NavigationModule_NavigationScenes_Pfo_LatLong_Invalid);
    break;
  case 219:
    gacViewDestroyReq(AppHmi_NavigationModule_NavigationScenes_Pfo_SingleLine_TwoButton);
    break;
  case 220:
    gacViewDestroyReq(AppHmi_NavigationModule_NavigationScenes_Pfo_Dest_CalcRoute);
    break;
  case 221:
    gacViewDestroyReq(AppHmi_NavigationModule_NavigationScenes_Pfo_MultiLine_TwoButton);
    break;
  case 222:
    gacViewHideAndDestroyReq(AppHmi_NavigationModule_NavigationScenes_Pfo_ThreeLine_TwoButton);
    break;
  case 223:
    gacViewDestroyReq(AppHmi_NavigationModule_NavigationScenes_Pfo_HomeEdit_Info_ThreeLine);
    break;
  case 224:
    gacViewDestroyReq(AppHmi_NavigationModule_NavigationScenes_Pfo_MultiLine_Text);
    break;
  case 225:
    gacViewDestroyReq(AppHmi_NavigationModule_NavigationScenes_Pfo_SpeedLockInfo);
    break;
  case 226:
    gacViewHideAndDestroyReq(AppHmi_NavigationModule_NavigationScenes_Pfo_FiveLine_TwoButton);
    break;
  case 227:
    gacViewDestroyReq(AppHmi_NavigationModule_NavigationScenes_Pfo_ThreeLine_Text);
    break;
  case 228:
    gacViewDestroyReq(AppHmi_NavigationModule_NavigationScenes_Pfo_SingleLine_SingleButton);
    break;
  case 229:
    gacViewDestroyReq(AppHmi_NavigationModule_NavigationScenes_Pfo_ThreeLine_OneButton);
    break;
  case 230:
    gacViewDestroyReq(AppHmi_NavigationModule_NavigationScenes_Pfo_MapUpdate_Progress);
    break;
  case 231:
    gacViewDestroyReq(AppHmi_NavigationModule_NavigationScenes_Pfo_LCVHardRestrictionInfo_Multiple);
    break;
  case 232:
    gacViewDestroyReq(AppHmi_NavigationModule_NavigationScenes_Pfo_LCVHardRestrictionConfirm_Multiple);
    break;
  case 233:
    gacViewDestroyReq(AppHmi_NavigationModule_NavigationScenes_Pfo_RouteInfo);
    break;
  case 234:
    gacViewDestroyReq(AppHmi_NavigationModule_NavigationScenes_Pfo_LCVRestrictionInfo);
    break;
  case 235:
    gacViewDestroyReq(AppHmi_NavigationModule_NavigationScenes_Pfo_MapOut_Notification);
    break;
  case 236:
    gacViewDestroyReq(AppHmi_NavigationModule_NavigationScenes_Pfo_FourLine_SingleButton);
    break;
  case 237:
    gacViewDestroyReq(AppHmi_NavigationModule_NavigationScenes_Pfo_XUrgent_Message);
    break;
  case 238:
    gacViewDestroyReq(AppHmi_NavigationModule_NavigationScenes_Pfo_Sys_ThreeLine_Text);
    break;
  case 239:
    gacViewDestroyReq(AppHmi_NavigationModule_NavigationScenes_Pfo_MapUpdate_Error);
    break;
  case 240:
    gacViewDestroyReq(AppHmi_NavigationModule_NavigationScenes_Pfo_MapUpdate_Interactive);
    break;
  case 241:
    gacViewDestroyReq(AppHmi_NavigationModule_NavigationScenes_Pfo_SoftPhysicalRestrictionInfo);
    break;
  case 242:
    gacViewDestroyReq(AppHmi_NavigationModule_NavigationScenes_Pfo_AvoidTollRoad);
    break;
  case 243:
    gacViewDestroyReq(AppHmi_NavigationModule_NavigationScenes_Pfo_LCVHardRestrictionInfo_ActiveRG);
    break;
  case 244:
    gacViewHideAndDestroyReq(AppHmi_NavigationModule_NavigationScenes_N_Disclaimer);
    break;
  case 245:
    gacViewHideAndDestroyReq(AppHmi_NavigationModule_NavigationScenes_N_Map);
    break;
  case 246:
    gacViewHideAndDestroyReq(AppHmi_NavigationModule_NavigationScenes_N_Map_ActiveRG);
    break;
  case 247:
    gacViewHideAndDestroyReq(AppHmi_NavigationModule_NavigationScenes_N_TMC_AllNoRG);
    break;
  case 248:
    gacViewHideAndDestroyReq(AppHmi_NavigationModule_NavigationScenes_N_Address_DetailedInfo);
    break;
  case 249:
    gacViewHideAndDestroyReq(AppHmi_NavigationModule_NavigationScenes_N_TMC_OnRoute);
    break;
  case 250:
    gacViewHideAndDestroyReq(AppHmi_NavigationModule_NavigationScenes_N_TMC_AllActiveRG);
    break;
  case 251:
    gacViewHideReq(AppHmi_NavigationModule_NavigationScenes_N_Map_Move);
    break;
  case 252:
    gacViewDestroyReq(AppHmi_NavigationModule_NavigationScenes_N_Map_Move);
    break;
  case 253:
    gacViewHideAndDestroyReq(AppHmi_NavigationModule_NavigationScenes_N_NewDestination);
    break;
  case 254:
    gacViewHideAndDestroyReq(AppHmi_NavigationModule_NavigationScenes_N_POI_CategoryRoot);
    break;
  case 255:
    gacViewHideAndDestroyReq(AppHmi_NavigationModule_NavigationScenes_N_POI_CategorySublevel);
    break;
  case 256:
    gacViewHideAndDestroyReq(AppHmi_NavigationModule_NavigationScenes_N_POI_List);
    break;
  case 257:
    acInavlidateSpellerEntry(Enum_BOOL_TRUE);
    break;
  case 258:
    gacViewHideAndDestroyReq(AppHmi_NavigationModule_NavigationScenes_N_SpellerEdit);
    break;
  case 259:
    gacViewHideAndDestroyReq(AppHmi_NavigationModule_NavigationScenes_N_Speller_MatchList);
    break;
  case 260:
    gacViewHideAndDestroyReq(AppHmi_NavigationModule_NavigationScenes_N_LatLongInput);
    break;
  case 261:
    gacViewHideAndDestroyReq(AppHmi_NavigationModule_NavigationScenes_N_LastDestinations);
    break;
  case 262:
    gacViewHideAndDestroyReq(AppHmi_NavigationModule_NavigationScenes_N_Favorites);
    break;
  case 263:
    gacViewHideAndDestroyReq(AppHmi_NavigationModule_NavigationScenes_N_Fav_SetHome);
    break;
  case 264:
    gacViewHideAndDestroyReq(AppHmi_NavigationModule_NavigationScenes_N_Fav_AddFavorites);
    break;
  case 265:
    gacViewHideAndDestroyReq(AppHmi_NavigationModule_NavigationScenes_N_ReplaceFavorites);
    break;
  case 266:
    gacPopupSBCloseReq(AppHmi_NavigationModule_NavigationScenes_Pfo_ThreeLine_TwoButton);
    break;
  case 267:
    gacViewHideAndDestroyReq(AppHmi_NavigationModule_NavigationScenes_N_Guidance);
    break;
  case 268:
    gacViewHideAndDestroyReq(AppHmi_NavigationModule_NavigationScenes_N_Guidance_ShowRouteList);
    break;
  case 269:
    acShowRouteListView(Enum_BOOL_FALSE);
    break;
  case 270:
    gacViewHideAndDestroyReq(AppHmi_NavigationModule_NavigationScenes_N_Guidance_BlockRouteList);
    break;
  case 271:
    acShowWaypointListView(Enum_BOOL_FALSE);
    break;
  case 272:
    gacViewHideAndDestroyReq(AppHmi_NavigationModule_NavigationScenes_N_Waypoints);
    break;
  case 273:
    gacViewHideAndDestroyReq(AppHmi_NavigationModule_NavigationScenes_N_Dest_Guidance);
    break;
  case 274:
    acSendContext(Enum_CONTEXT_SWITCH_FROM_DESTINATIONS);
    break;
  case 275:
    gacViewHideAndDestroyReq(AppHmi_NavigationModule_NavigationScenes_N_POIInfo);
    break;
  case 276:
    gacViewHideAndDestroyReq(AppHmi_NavigationModule_NavigationScenes_N_PickInMapOption);
    break;
  case 277:
    gacViewHideAndDestroyReq(AppHmi_NavigationModule_NavigationScenes_N_MyPOIs_AddressInput);
    break;
  case 278:
    gacViewHideAndDestroyReq(AppHmi_NavigationModule_NavigationScenes_N_NewDest_AddressInput);
    break;
  case 279:
    gacViewHideAndDestroyReq(AppHmi_NavigationModule_NavigationScenes_N_Testmode_EngineeringMenu);
    break;
  case 280:
    gacViewHideAndDestroyReq(AppHmi_NavigationModule_NavigationScenes_N_Testmode_EngineeringMenuDetails);
    break;
  case 281:
    gacViewHideAndDestroyReq(AppHmi_NavigationModule_NavigationScenes_N_OPT_RouteOptions);
    break;
  case 282:
    gacViewHideAndDestroyReq(AppHmi_NavigationModule_NavigationScenes_N_OPT);
    break;
  case 283:
    gacViewHideAndDestroyReq(AppHmi_NavigationModule_NavigationScenes_N_OPT_RouteOptions_Others);
    break;
  case 284:
    gacViewHideAndDestroyReq(AppHmi_NavigationModule_NavigationScenes_N_OPT_MapOptions);
    break;
  case 285:
    acShowPoisOnMapView(Enum_BOOL_FALSE);
    break;
  case 286:
    gacViewHideAndDestroyReq(AppHmi_NavigationModule_NavigationScenes_N_OPT_MapOptions_OnMap);
    break;
  case 287:
    gacViewHideAndDestroyReq(AppHmi_NavigationModule_NavigationScenes_N_OPT_MapOption_Others);
    break;
  case 288:
    gacViewHideAndDestroyReq(AppHmi_NavigationModule_NavigationScenes_N_OPT_MapOption_MapColor);
    break;
  case 289:
    gacViewHideReq(AppHmi_NavigationModule_NavigationScenes_N_MapScale);
    break;
  case 290:
    gacViewDestroyReq(AppHmi_NavigationModule_NavigationScenes_N_MapScale);
    break;
  case 291:
    gacViewHideAndDestroyReq(AppHmi_NavigationModule_NavigationScenes_N_OPT_VehicleOptions);
    break;
  case 292:
    gacViewHideAndDestroyReq(AppHmi_NavigationModule_NavigationScenes_N_OPT_GuidanceOptions);
    break;
  case 293:
    gacViewHideAndDestroyReq(AppHmi_NavigationModule_NavigationScenes_N_OPT_TrafficOptions);
    break;
  case 294:
    gacViewHideAndDestroyReq(AppHmi_NavigationModule_NavigationScenes_N_OPT_PositionAndGPSInfo);
    break;
  case 295:
    gacViewHideAndDestroyReq(AppHmi_NavigationModule_NavigationScenes_Pfo_Dest_VehicleInfo);
    break;
  case 296:
    gacViewHideAndDestroyReq(AppHmi_NavigationModule_NavigationScenes_N_StreamedMap_Settings);
    break;
  case 297:
    gacViewHideAndDestroyReq(AppHmi_NavigationModule_NavigationScenes_N_StreamedMap_SubOptions);
    break;
  case 298:
    gacViewHideAndDestroyReq(AppHmi_NavigationModule_NavigationScenes_N_OPT_SpeedLimitOption);
    break;
  case 299:
    gacViewHideAndDestroyReq(AppHmi_NavigationModule_NavigationScenes_N_OPT_TrafficIcons);
    break;
  case 300:
    gacViewHideAndDestroyReq(AppHmi_NavigationModule_NavigationScenes_N_OPT_PremiumTraffic);
    break;
  case 301:
    gacViewHideAndDestroyReq(AppHmi_NavigationModule_NavigationScenes_N_OPT_PremiumTraffic_Disclaimer);
    break;
  case 302:
    gacViewHideAndDestroyReq(AppHmi_NavigationModule_NavigationScenes_N_OPT_MyPOIs_POIOPT);
    break;
  case 303:
    acSendContext(Enum_CONTEXT_SWITCH_FROM_SETTINGS);
    break;
  case 304:
    gacViewHideAndDestroyReq(AppHmi_NavigationModule_NavigationScenes_N_Alternateroute);
    break;
  case 305:
    gacViewShowReq(AppHmi_NavigationModule_NavigationScenes_Pfo_LatLong_Invalid);
    break;
  case 306:
    gacViewHideReq(AppHmi_NavigationModule_NavigationScenes_Pfo_LatLong_Invalid);
    break;
  case 307:
    gacViewClearReq(AppHmi_NavigationModule_NavigationScenes_Pfo_LatLong_Invalid);
    break;
  case 308:
    gacPopupSBCloseReq(AppHmi_NavigationModule_NavigationScenes_Pfo_LatLong_Invalid);
    break;
  case 309:
    gacViewShowReq(AppHmi_NavigationModule_NavigationScenes_Pfo_SingleLine_TwoButton);
    break;
  case 310:
    gacViewHideReq(AppHmi_NavigationModule_NavigationScenes_Pfo_SingleLine_TwoButton);
    break;
  case 311:
    gacViewClearReq(AppHmi_NavigationModule_NavigationScenes_Pfo_SingleLine_TwoButton);
    break;
  case 312:
    gacPopupSBCloseReq(AppHmi_NavigationModule_NavigationScenes_Pfo_SingleLine_TwoButton);
    break;
  case 313:
    acSkipWaypointReqMsg(Enum_BOOL_FALSE);
    break;
  case 314:
    acSkipWaypointReqMsg(Enum_BOOL_TRUE);
    break;
  case 315:
    gacViewHideReq(AppHmi_NavigationModule_NavigationScenes_Pfo_Dest_CalcRoute);
    break;
  case 316:
    gacViewClearReq(AppHmi_NavigationModule_NavigationScenes_Pfo_Dest_CalcRoute);
    break;
  case 317:
    gacPopupSBCloseReq(AppHmi_NavigationModule_NavigationScenes_Pfo_Dest_CalcRoute);
    break;
  case 318:
    gacViewShowReq(AppHmi_NavigationModule_NavigationScenes_Pfo_Dest_CalcRoute);
    break;
  case 319:
    gacViewHideReq(AppHmi_NavigationModule_NavigationScenes_Pfo_MultiLine_TwoButton);
    break;
  case 320:
    gacViewClearReq(AppHmi_NavigationModule_NavigationScenes_Pfo_MultiLine_TwoButton);
    break;
  case 321:
    gacViewHideReq(AppHmi_NavigationModule_NavigationScenes_Pfo_ThreeLine_TwoButton);
    break;
  case 322:
    gacViewClearReq(AppHmi_NavigationModule_NavigationScenes_Pfo_ThreeLine_TwoButton);
    break;
  case 323:
    gacViewHideReq(AppHmi_NavigationModule_NavigationScenes_Pfo_HomeEdit_Info_ThreeLine);
    break;
  case 324:
    gacViewClearReq(AppHmi_NavigationModule_NavigationScenes_Pfo_HomeEdit_Info_ThreeLine);
    break;
  case 325:
    gacViewHideReq(AppHmi_NavigationModule_NavigationScenes_Pfo_MultiLine_Text);
    break;
  case 326:
    gacViewClearReq(AppHmi_NavigationModule_NavigationScenes_Pfo_MultiLine_Text);
    break;
  case 327:
    gacViewHideReq(AppHmi_NavigationModule_NavigationScenes_Pfo_SpeedLockInfo);
    break;
  case 328:
    gacViewClearReq(AppHmi_NavigationModule_NavigationScenes_Pfo_SpeedLockInfo);
    break;
  case 329:
    acImportUPOIsReqMsg(Enum_BOOL_FALSE);
    break;
  case 330:
    gacViewHideReq(AppHmi_NavigationModule_NavigationScenes_Pfo_FiveLine_TwoButton);
    break;
  case 331:
    gacViewClearReq(AppHmi_NavigationModule_NavigationScenes_Pfo_FiveLine_TwoButton);
    break;
  case 332:
    gacViewHideReq(AppHmi_NavigationModule_NavigationScenes_Pfo_ThreeLine_Text);
    break;
  case 333:
    gacViewClearReq(AppHmi_NavigationModule_NavigationScenes_Pfo_ThreeLine_Text);
    break;
  case 334:
    gacViewHideReq(AppHmi_NavigationModule_NavigationScenes_Pfo_SingleLine_SingleButton);
    break;
  case 335:
    gacViewClearReq(AppHmi_NavigationModule_NavigationScenes_Pfo_SingleLine_SingleButton);
    break;
  case 336:
    gacViewHideReq(AppHmi_NavigationModule_NavigationScenes_Pfo_ThreeLine_OneButton);
    break;
  case 337:
    gacViewClearReq(AppHmi_NavigationModule_NavigationScenes_Pfo_ThreeLine_OneButton);
    break;
  case 338:
    gacViewHideReq(AppHmi_NavigationModule_NavigationScenes_Pfo_MapUpdate_Progress);
    break;
  case 339:
    gacViewClearReq(AppHmi_NavigationModule_NavigationScenes_Pfo_MapUpdate_Progress);
    break;
  case 340:
    gacViewHideReq(AppHmi_NavigationModule_NavigationScenes_Pfo_LCVHardRestrictionInfo_Multiple);
    break;
  case 341:
    gacViewClearReq(AppHmi_NavigationModule_NavigationScenes_Pfo_LCVHardRestrictionInfo_Multiple);
    break;
  case 342:
    gacViewHideReq(AppHmi_NavigationModule_NavigationScenes_Pfo_LCVHardRestrictionConfirm_Multiple);
    break;
  case 343:
    gacViewClearReq(AppHmi_NavigationModule_NavigationScenes_Pfo_LCVHardRestrictionConfirm_Multiple);
    break;
  case 344:
    gacViewHideReq(AppHmi_NavigationModule_NavigationScenes_Pfo_RouteInfo);
    break;
  case 345:
    gacViewClearReq(AppHmi_NavigationModule_NavigationScenes_Pfo_RouteInfo);
    break;
  case 346:
    gacViewHideReq(AppHmi_NavigationModule_NavigationScenes_Pfo_LCVRestrictionInfo);
    break;
  case 347:
    gacViewClearReq(AppHmi_NavigationModule_NavigationScenes_Pfo_LCVRestrictionInfo);
    break;
  case 348:
    gacViewHideReq(AppHmi_NavigationModule_NavigationScenes_Pfo_MapOut_Notification);
    break;
  case 349:
    gacViewClearReq(AppHmi_NavigationModule_NavigationScenes_Pfo_MapOut_Notification);
    break;
  case 350:
    gacViewHideReq(AppHmi_NavigationModule_NavigationScenes_Pfo_FourLine_SingleButton);
    break;
  case 351:
    gacViewClearReq(AppHmi_NavigationModule_NavigationScenes_Pfo_FourLine_SingleButton);
    break;
  case 352:
    gacViewHideReq(AppHmi_NavigationModule_NavigationScenes_Pfo_XUrgent_Message);
    break;
  case 353:
    gacViewClearReq(AppHmi_NavigationModule_NavigationScenes_Pfo_XUrgent_Message);
    break;
  case 354:
    gacViewHideReq(AppHmi_NavigationModule_NavigationScenes_Pfo_Sys_ThreeLine_Text);
    break;
  case 355:
    gacViewClearReq(AppHmi_NavigationModule_NavigationScenes_Pfo_Sys_ThreeLine_Text);
    break;
  case 356:
    gacViewHideReq(AppHmi_NavigationModule_NavigationScenes_Pfo_MapUpdate_Error);
    break;
  case 357:
    gacViewClearReq(AppHmi_NavigationModule_NavigationScenes_Pfo_MapUpdate_Error);
    break;
  case 358:
    gacViewHideReq(AppHmi_NavigationModule_NavigationScenes_Pfo_MapUpdate_Interactive);
    break;
  case 359:
    gacViewClearReq(AppHmi_NavigationModule_NavigationScenes_Pfo_MapUpdate_Interactive);
    break;
  case 360:
    acNAVDATAUPDATE_Nav_FullMapUpdateYes(IN_bIsMapUpdateTriggered);
    break;
  case 361:
    gacViewHideReq(AppHmi_NavigationModule_NavigationScenes_Pfo_SoftPhysicalRestrictionInfo);
    break;
  case 362:
    gacViewClearReq(AppHmi_NavigationModule_NavigationScenes_Pfo_SoftPhysicalRestrictionInfo);
    break;
  case 363:
    gacViewHideReq(AppHmi_NavigationModule_NavigationScenes_Pfo_AvoidTollRoad);
    break;
  case 364:
    gacViewClearReq(AppHmi_NavigationModule_NavigationScenes_Pfo_AvoidTollRoad);
    break;
  case 365:
    gacViewDestroyReq(AppHmi_NavigationModule_NavigationScenes_Pfo_PremiumTrafficDisabled);
    break;
  case 366:
    gacViewHideReq(AppHmi_NavigationModule_NavigationScenes_Pfo_PremiumTrafficDisabled);
    break;
  case 367:
    gacViewClearReq(AppHmi_NavigationModule_NavigationScenes_Pfo_PremiumTrafficDisabled);
    break;
  case 368:
    gacViewHideReq(AppHmi_NavigationModule_NavigationScenes_Pfo_LCVHardRestrictionInfo_ActiveRG);
    break;
  case 369:
    gacViewClearReq(AppHmi_NavigationModule_NavigationScenes_Pfo_LCVHardRestrictionInfo_ActiveRG);
    break;
  case 370:
    gacViewHideReq(AppHmi_NavigationModule_NavigationScenes_N_Navigation_Gadget);
    break;
  case 371:
    gacViewDestroyReq(AppHmi_NavigationModule_NavigationScenes_N_Navigation_Gadget);
    break;
  case 372:
    gacViewHideReq(AppHmi_NavigationModule_NavigationScenes_N_Map_TravelerCabin_Glass);
    break;
  case 373:
    gacViewDestroyReq(AppHmi_NavigationModule_NavigationScenes_N_Map_TravelerCabin_Glass);
    break;
  case 374:
    gacPopupSBCloseReq(AppHmi_NavigationModule_NavigationScenes_Pfo_MultiLine_TwoButton);
    break;
  case 375:
    acSetMapLayerVisibility(Enum_BOOL_TRUE);
    break;
  case 376:
    gacViewCreateAndShowReq(AppHmi_NavigationModule_NavigationScenes_N_Dest_Guidance);
    break;
  case 377:
    acUpdateVehicleProfilePopupStatus(Enum_BOOL_FALSE);
    break;
  case 378:
    gacViewShowReq(AppHmi_NavigationModule_NavigationScenes_Pfo_MultiLine_TwoButton);
    break;
  case 379:
    gacViewCreateAndShowReq(AppHmi_NavigationModule_NavigationScenes_Pfo_ThreeLine_TwoButton);
    break;
  case 380:
    gacViewShowReq(AppHmi_NavigationModule_NavigationScenes_Pfo_HomeEdit_Info_ThreeLine);
    break;
  case 381:
    gacViewShowReq(AppHmi_NavigationModule_NavigationScenes_Pfo_MultiLine_Text);
    break;
  case 382:
    gacViewShowReq(AppHmi_NavigationModule_NavigationScenes_Pfo_SpeedLockInfo);
    break;
  case 383:
    gacPopupSBCloseReq(AppHmi_NavigationModule_NavigationScenes_Pfo_SpeedLockInfo);
    break;
  case 384:
    gacViewCreateAndShowReq(AppHmi_NavigationModule_NavigationScenes_Pfo_FiveLine_TwoButton);
    break;
  case 385:
    acImportUPOIsReqMsg(Enum_BOOL_TRUE);
    break;
  case 386:
    gacPopupSBCloseReq(AppHmi_NavigationModule_NavigationScenes_Pfo_FiveLine_TwoButton);
    break;
  case 387:
    gacViewShowReq(AppHmi_NavigationModule_NavigationScenes_Pfo_ThreeLine_Text);
    break;
  case 388:
    gacViewShowReq(AppHmi_NavigationModule_NavigationScenes_Pfo_SingleLine_SingleButton);
    break;
  case 389:
    gacPopupSBCloseReq(AppHmi_NavigationModule_NavigationScenes_Pfo_SingleLine_SingleButton);
    break;
  case 390:
    gacViewShowReq(AppHmi_NavigationModule_NavigationScenes_Pfo_ThreeLine_OneButton);
    break;
  case 391:
    gacPopupSBCloseReq(AppHmi_NavigationModule_NavigationScenes_Pfo_ThreeLine_OneButton);
    break;
  case 392:
    gacViewShowReq(AppHmi_NavigationModule_NavigationScenes_Pfo_MapUpdate_Progress);
    break;
  case 393:
    gacViewShowReq(AppHmi_NavigationModule_NavigationScenes_Pfo_LCVHardRestrictionInfo_Multiple);
    break;
  case 394:
    gacPopupSBCloseReq(AppHmi_NavigationModule_NavigationScenes_Pfo_LCVHardRestrictionInfo_Multiple);
    break;
  case 395:
    gacViewShowReq(AppHmi_NavigationModule_NavigationScenes_Pfo_LCVHardRestrictionConfirm_Multiple);
    break;
  case 396:
    gacPopupSBCloseReq(AppHmi_NavigationModule_NavigationScenes_Pfo_LCVHardRestrictionConfirm_Multiple);
    break;
  case 397:
    gacViewShowReq(AppHmi_NavigationModule_NavigationScenes_Pfo_RouteInfo);
    break;
  case 398:
    gacPopupSBCloseReq(AppHmi_NavigationModule_NavigationScenes_Pfo_LCVRestrictionInfo);
    break;
  case 399:
    gacViewShowReq(AppHmi_NavigationModule_NavigationScenes_Pfo_LCVRestrictionInfo);
    break;
  case 400:
    gacViewShowReq(AppHmi_NavigationModule_NavigationScenes_Pfo_MapOut_Notification);
    break;
  case 401:
    gacViewShowReq(AppHmi_NavigationModule_NavigationScenes_Pfo_FourLine_SingleButton);
    break;
  case 402:
    gacPopupSBCloseReq(AppHmi_NavigationModule_NavigationScenes_Pfo_FourLine_SingleButton);
    break;
  case 403:
    gacViewShowReq(AppHmi_NavigationModule_NavigationScenes_Pfo_XUrgent_Message);
    break;
  case 404:
    gacPopupSBCloseReq(AppHmi_NavigationModule_NavigationScenes_Pfo_XUrgent_Message);
    break;
  case 405:
    gacViewShowReq(AppHmi_NavigationModule_NavigationScenes_Pfo_Sys_ThreeLine_Text);
    break;
  case 406:
    gacViewShowReq(AppHmi_NavigationModule_NavigationScenes_Pfo_MapUpdate_Error);
    break;
  case 407:
    gacPopupSBCloseReq(AppHmi_NavigationModule_NavigationScenes_Pfo_MapUpdate_Error);
    break;
  case 408:
    gacViewShowReq(AppHmi_NavigationModule_NavigationScenes_Pfo_MapUpdate_Interactive);
    break;
  case 409:
    gacPopupSBCloseReq(AppHmi_NavigationModule_NavigationScenes_Pfo_MapUpdate_Interactive);
    break;
  case 410:
    gacViewShowReq(AppHmi_NavigationModule_NavigationScenes_Pfo_SoftPhysicalRestrictionInfo);
    break;
  case 411:
    gacPopupSBCloseReq(AppHmi_NavigationModule_NavigationScenes_Pfo_SoftPhysicalRestrictionInfo);
    break;
  case 412:
    acSoftRestrictionMsg(Enum_BOOL_TRUE);
    break;
  case 413:
    acSoftRestrictionMsg(Enum_BOOL_FALSE);
    break;
  case 414:
    gacViewShowReq(AppHmi_NavigationModule_NavigationScenes_Pfo_AvoidTollRoad);
    break;
  case 415:
    gacPopupSBCloseReq(AppHmi_NavigationModule_NavigationScenes_Pfo_AvoidTollRoad);
    break;
  case 416:
    gacViewCreateAndShowReq(AppHmi_NavigationModule_NavigationScenes_Pfo_PremiumTrafficDisabled);
    break;
  case 417:
    gacPopupSBCloseReq(AppHmi_NavigationModule_NavigationScenes_Pfo_PremiumTrafficDisabled);
    break;
  case 418:
    gacViewShowReq(AppHmi_NavigationModule_NavigationScenes_Pfo_LCVHardRestrictionInfo_ActiveRG);
    break;
  case 419:
    gacPopupSBCloseReq(AppHmi_NavigationModule_NavigationScenes_Pfo_LCVHardRestrictionInfo_ActiveRG);
    break;
  case 420:
    acContextSwitch(Enum_CONTEXT_SWITCH_FROM_HOMESCREEN, Enum_CONTEXT_SWITCH_TO_NEW_DESTINATION);
    break;
  case 421:
    acContextSwitch(Enum_CONTEXT_SWITCH_FROM_HOMESCREEN, Enum_CONTEXT_SWITCH_TO_MAP);
    break;
  case 422:
    gacViewCreateReq(AppHmi_NavigationModule_NavigationScenes_N_Navigation_Gadget);
    break;
  case 423:
    gacViewShowReq(AppHmi_NavigationModule_NavigationScenes_N_Navigation_Gadget);
    break;
  case 424:
    gacViewCreateReq(AppHmi_NavigationModule_NavigationScenes_N_Map_TravelerCabin_Glass);
    break;
  case 425:
    gacViewShowReq(AppHmi_NavigationModule_NavigationScenes_N_Map_TravelerCabin_Glass);
    break;
  case 426:
    acValidateNaviEntryCondition(IN_bIsCautionAccepted);
    break;
  case 427:
    acSetMapLayerVisibility(Enum_BOOL_FALSE);
    break;
  case 428:
    gacViewCreateReq(AppHmi_NavigationModule_NavigationScenes_N_Disclaimer);
    break;
  case 429:
    acUpdateContextonBackground(IN_u32CurrentSceneViewId);
    break;
  case 430:
    gacViewShowReq(AppHmi_NavigationModule_NavigationScenes_N_Disclaimer);
    break;
  case 431:
    gacViewCreateAndShowReq(AppHmi_NavigationModule_NavigationScenes_N_OPT);
    break;
  case 432:
    acSendContext(Enum_CONTEXT_SWITCH_FROM_TRAFFIC_DETOUR);
    break;
  case 433:
    gacViewCreateReq(AppHmi_NavigationModule_NavigationScenes_N_Alternateroute);
    break;
  case 434:
    acSetMapCameraModeAction(Enum_MAP_CAMERA_AND_VIEW_MODE_TRAFFIC_DETOUR_50PERCENT);
    break;
  case 435:
    gacViewShowReq(AppHmi_NavigationModule_NavigationScenes_N_Alternateroute);
    break;
  case 436:
    acNavigationPopUpVisible(AppHmi_NavigationModule_NavigationScenes_N_StreamedMap_SubOptions, EventArgsVar.DB47.VS_UINT32Var[0]);
    break;
  case 437:
    acStopTimer(AppHmi_NavigationModule_NavigationScenes_N_StreamedMap_SubOptions);
    break;
  case 438:
    gacViewCreateAndShowReq(AppHmi_NavigationModule_NavigationScenes_N_Map);
    break;
  case 439:
    acSetMapCameraModeAction(Enum_MAP_CAMERA_AND_VIEW_MODE_MAP_MAIN_SCREEN);
    break;
  case 440:
    gacViewCreateAndShowReq(AppHmi_NavigationModule_NavigationScenes_N_Map_ActiveRG);
    break;
  case 441:
    acToggleRouteOverviewBtn(Enum_BOOL_FALSE);
    break;
  case 442:
    acSetMapCameraModeAction(IN_u32CurrentMapViewState);
    break;
  case 443:
    gacViewCreateAndShowReq(AppHmi_NavigationModule_NavigationScenes_N_TMC_AllNoRG);
    break;
  case 444:
    acSetMapCameraModeAction(Enum_MAP_CAMERA_AND_VIEW_MODE_LOCATION_DETAILS);
    break;
  case 445:
    gacViewCreateAndShowReq(AppHmi_NavigationModule_NavigationScenes_N_Address_DetailedInfo);
    break;
  case 446:
    gacViewCreateAndShowReq(AppHmi_NavigationModule_NavigationScenes_N_TMC_OnRoute);
    break;
  case 447:
    gacViewCreateAndShowReq(AppHmi_NavigationModule_NavigationScenes_N_TMC_AllActiveRG);
    break;
  case 448:
    acSetBackButtonLevel(Enum_BACK_BUTTON_LEVEL_THREE);
    break;
  case 449:
    gacViewCreateReq(AppHmi_NavigationModule_NavigationScenes_N_Map_Move);
    break;
  case 450:
    acSetMapCameraModeAction(Enum_MAP_CAMERA_AND_VIEW_MODE_MAP_SCROLL);
    break;
  case 451:
    acStartPicking(Enum_MAP_PICKING_FOR_DETAILED_INFO_LOCATION_SCROLL);
    break;
  case 452:
    gacViewShowReq(AppHmi_NavigationModule_NavigationScenes_N_Map_Move);
    break;
  case 453:
    gacViewCreateAndShowReq(AppHmi_NavigationModule_NavigationScenes_N_NewDestination);
    break;
  case 454:
    acInitPOICategoryBrowse(IN_u8POISelected);
    break;
  case 455:
    gacViewCreateAndShowReq(AppHmi_NavigationModule_NavigationScenes_N_POI_CategoryRoot);
    break;
  case 456:
    gacViewCreateAndShowReq(AppHmi_NavigationModule_NavigationScenes_N_POI_CategorySublevel);
    break;
  case 457:
    gacViewCreateAndShowReq(AppHmi_NavigationModule_NavigationScenes_N_POI_List);
    break;
  case 458:
    gacViewCreateAndShowReq(AppHmi_NavigationModule_NavigationScenes_N_SpellerEdit);
    break;
  case 459:
    gacViewCreateAndShowReq(AppHmi_NavigationModule_NavigationScenes_N_Speller_MatchList);
    break;
  case 460:
    gacViewCreateAndShowReq(AppHmi_NavigationModule_NavigationScenes_N_LatLongInput);
    break;
  case 461:
    gacViewCreateAndShowReq(AppHmi_NavigationModule_NavigationScenes_N_LastDestinations);
    break;
  case 462:
    gacViewCreateAndShowReq(AppHmi_NavigationModule_NavigationScenes_N_Favorites);
    break;
  case 463:
    gacViewCreateAndShowReq(AppHmi_NavigationModule_NavigationScenes_N_Fav_SetHome);
    break;
  case 464:
    acSetPreviosulyActiveSceneName(IN_u8LastEnteredDetailedInfo);
    break;
  case 465:
    gacViewCreateAndShowReq(AppHmi_NavigationModule_NavigationScenes_N_Fav_AddFavorites);
    break;
  case 466:
    gacViewCreateAndShowReq(AppHmi_NavigationModule_NavigationScenes_N_ReplaceFavorites);
    break;
  case 467:
    acSetMaxFavPopupVisibilityStatus(Enum_BOOL_TRUE);
    break;
  case 468:
    gacViewCreateAndShowReq(AppHmi_NavigationModule_NavigationScenes_N_Guidance);
    break;
  case 469:
    gacViewCreateAndShowReq(AppHmi_NavigationModule_NavigationScenes_N_Guidance_ShowRouteList);
    break;
  case 470:
    acShowRouteListView(Enum_BOOL_TRUE);
    break;
  case 471:
    gacViewCreateAndShowReq(AppHmi_NavigationModule_NavigationScenes_N_Guidance_BlockRouteList);
    break;
  case 472:
    acShowWaypointListView(Enum_BOOL_TRUE);
    break;
  case 473:
    gacViewCreateAndShowReq(AppHmi_NavigationModule_NavigationScenes_N_Waypoints);
    break;
  case 474:
    acSetBackButtonLevel(Enum_BACK_BUTTON_LEVEL_ONE);
    break;
  case 475:
    gacViewCreateAndShowReq(AppHmi_NavigationModule_NavigationScenes_N_POIInfo);
    break;
  case 476:
    gacViewCreateAndShowReq(AppHmi_NavigationModule_NavigationScenes_N_PickInMapOption);
    break;
  case 477:
    gacViewCreateAndShowReq(AppHmi_NavigationModule_NavigationScenes_N_MyPOIs_AddressInput);
    break;
  case 478:
    gacViewCreateAndShowReq(AppHmi_NavigationModule_NavigationScenes_N_NewDest_AddressInput);
    break;
  case 479:
    acSendContext(Enum_CONTEXT_SWITCH_FROM_ENGGMENU);
    break;
  case 480:
    gacViewCreateAndShowReq(AppHmi_NavigationModule_NavigationScenes_N_Testmode_EngineeringMenu);
    break;
  case 481:
    gacViewCreateAndShowReq(AppHmi_NavigationModule_NavigationScenes_N_Testmode_EngineeringMenuDetails);
    break;
  case 482:
    acMapZoomIn(Enum_MAP_VIEW_PRIMARY, 1);
    break;
  case 483:
    acMapZoomOut(Enum_MAP_VIEW_PRIMARY, 1);
    break;
  case 484:
    acCompassOrientation(Enum_MAP_VIEW_PRIMARY);
    break;
  case 485:
    acCompassOrientation(Enum_MAP_VIEW_SECONDARY);
    break;
  case 486:
    acMapZoomIn(Enum_MAP_VIEW_PRIMARY, 0);
    break;
  case 487:
    acMapZoomOut(Enum_MAP_VIEW_PRIMARY, 0);
    break;
  case 488:
    acContextSwitch(Enum_CONTEXT_SWITCH_FROM_ENGGMENU, Enum_CONTEXT_SWITCH_TO_TESTMODE);
    break;
  case 489:
    gacViewCreateAndShowReq(AppHmi_NavigationModule_NavigationScenes_N_OPT_RouteOptions_Others);
    break;
  case 490:
    acChangeRouteTypeItem(EventArgsVar.DB47.VS_UINT32Var[0]);
    break;
  case 491:
    acChangeCustomRouteItem(EventArgsVar.DB47.VS_UINT32Var[0]);
    break;
  case 492:
    acChangeEstimatedTimeItem(EventArgsVar.DB47.VS_UINT32Var[0]);
    break;
  case 493:
    acChangeTimeOnMapItem(EventArgsVar.DB47.VS_UINT32Var[0]);
    break;
  case 494:
    gacViewCreateAndShowReq(AppHmi_NavigationModule_NavigationScenes_N_OPT_RouteOptions);
    break;
  case 495:
    gacViewCreateAndShowReq(AppHmi_NavigationModule_NavigationScenes_N_OPT_MapOptions);
    break;
  case 496:
    gacViewCreateAndShowReq(AppHmi_NavigationModule_NavigationScenes_N_OPT_VehicleOptions);
    break;
  case 497:
    gacViewCreateAndShowReq(AppHmi_NavigationModule_NavigationScenes_N_OPT_GuidanceOptions);
    break;
  case 498:
    gacViewCreateAndShowReq(AppHmi_NavigationModule_NavigationScenes_N_OPT_TrafficOptions);
    break;
  case 499:
    acSetMapCameraModeAction(Enum_MAP_CAMERA_AND_VIEW_MODE_CARSOR_LEFT_OVERVIEW);
    break;
  case 500:
    gacViewCreateAndShowReq(AppHmi_NavigationModule_NavigationScenes_N_OPT_PositionAndGPSInfo);
    break;
  case 501:
    gacViewCreateAndShowReq(AppHmi_NavigationModule_NavigationScenes_N_OPT_MyPOIs_POIOPT);
    break;
  case 502:
    acChangeUseTrafficInfoItem(EventArgsVar.DB47.VS_UINT32Var[0]);
    break;
  case 503:
    acChangeUseTollRoadItem(EventArgsVar.DB47.VS_UINT32Var[0]);
    break;
  case 504:
    acShowPoisOnMapView(Enum_BOOL_TRUE);
    break;
  case 505:
    gacViewCreateAndShowReq(AppHmi_NavigationModule_NavigationScenes_N_OPT_MapOptions_OnMap);
    break;
  case 506:
    acActivateMapSettingOthersList(Enum_MAP_SETTINGS_OTHERS_MAIN);
    break;
  case 507:
    gacViewCreateAndShowReq(AppHmi_NavigationModule_NavigationScenes_N_OPT_MapOption_Others);
    break;
  case 508:
    acActivateMapSettingOthersList(EventArgsVar.DB47.VS_UINT32Var[0]);
    break;
  case 509:
    acSetMapCameraModeAction(Enum_MAP_CAMERA_AND_VIEW_MODE_MAP_COLOR_VIEW_RIGHT);
    break;
  case 510:
    gacViewCreateAndShowReq(AppHmi_NavigationModule_NavigationScenes_N_OPT_MapOption_MapColor);
    break;
  case 511:
    gacViewCreateReq(AppHmi_NavigationModule_NavigationScenes_N_MapScale);
    break;
  case 512:
    acSetMapCameraModeAction(Enum_MAP_CAMERA_AND_VIEW_MODE_LEFT_SPLITMAP_SCALE);
    break;
  case 513:
    gacViewShowReq(AppHmi_NavigationModule_NavigationScenes_N_MapScale);
    break;
  case 514:
    acUpdateDeletePopupText(IN_u8PopupType);
    break;
  case 515:
    gacViewCreateAndShowReq(AppHmi_NavigationModule_NavigationScenes_Pfo_Dest_VehicleInfo);
    break;
  case 516:
    gacViewCreateAndShowReq(AppHmi_NavigationModule_NavigationScenes_N_OPT_SpeedLimitOption);
    break;
  case 517:
    gacViewCreateAndShowReq(AppHmi_NavigationModule_NavigationScenes_N_OPT_PremiumTraffic);
    break;
  case 518:
    gacViewCreateAndShowReq(AppHmi_NavigationModule_NavigationScenes_N_OPT_TrafficIcons);
    break;
  case 519:
    acActivateStreamMapSettingSubOptionList(EventArgsVar.DB47.VS_UINT32Var[0]);
    break;
  case 520:
    gacViewCreateAndShowReq(AppHmi_NavigationModule_NavigationScenes_N_StreamedMap_SubOptions);
    break;
  case 521:
    gacViewCreateAndShowReq(AppHmi_NavigationModule_NavigationScenes_N_StreamedMap_Settings);
    break;
  case 522:
    gacViewCreateAndShowReq(AppHmi_NavigationModule_NavigationScenes_N_OPT_PremiumTraffic_Disclaimer);
    break;
  case 523:
    acStartPicking(Enum_MAP_PICKING_FOR_STREET_AUTOPICK);
    break;
  case 524:
    acSetPickingTimer(Enum_BOOL_TRUE, NAVI_HMI_SM_C_MAP_PICKING_TIMER_MAPCENTER);
    break;
  case 525:
    acStartPicking(Enum_MAP_PICKING_FOR_POI);
    break;
  case 526:
    acMapZoomIn(Enum_MAP_VIEW_SECONDARY, 1);
    break;
  case 527:
    acMapZoomOut(Enum_MAP_VIEW_SECONDARY, 1);
    break;
  case 528:
    acHighlightActiveRoute(Enum_ROUTE_TYPE_FASTEST);
    break;
  case 529:
    acHighlightActiveRoute(Enum_ROUTE_TYPE_ECONOMIC);
    break;
  case 530:
    acHighlightActiveRoute(Enum_ROUTE_TYPE_SHORTEST);
    break;
  case 531:
    acToggleRouteOverviewBtn(Enum_BOOL_TRUE);
    break;
  case 532:
    acSetMapCameraModeAction(Enum_MAP_CAMERA_AND_VIEW_MODE_ROUTE_OVERVIEW);
    break;
  case 533:
    acInitDestinationInput(AppHmi_NavigationModule_NavigationScenes_N_MyPOIs_AddressInput, Enum_BOOL_FALSE);
    break;
  case 534:
    acInitDestinationInput(AppHmi_NavigationModule_NavigationScenes_N_NewDest_AddressInput, Enum_BOOL_FALSE);
    break;
  case 535:
    acEnableGuidanceButton_NewAddress(1);
    break;
  case 536:
    acContextSwitch(Enum_CONTEXT_SWITCH_FROM_DESTINATIONS, Enum_CONTEXT_SWITCH_TO_HOMESCREEN);
    break;
  case 537:
    acInitDestinationInput(AppHmi_NavigationModule_NavigationScenes_N_MyPOIs_AddressInput, Enum_BOOL_TRUE);
    break;
  case 538:
    acInitDestinationInput(AppHmi_NavigationModule_NavigationScenes_N_NewDest_AddressInput, Enum_BOOL_TRUE);
    break;
  case 539:
    acShowPopupText(Enum_POPUP_MAX_WAYPOINTS_REACHED);
    break;
  case 540:
    acInavlidateSpellerEntry(Enum_BOOL_FALSE);
    break;
  case 541:
    ac_N_SpellerEdit_Ok_touch(AppHmi_NavigationModule_NavigationScenes_N_POI_List);
    break;
  case 542:
    gacPopupCreateAndSBShowReq(AppHmi_NavigationModule_NavigationScenes_Pfo_SpeedLockInfo);
    break;
  case 543:
    ac_N_SpellerEdit_Ok_touch(AppHmi_NavigationModule_NavigationScenes_N_NewDest_AddressInput);
    break;
  case 544:
    acDeletePreviousDestination(IN_u8PopupType);
    break;
  case 545:
    acEnableGuidanceButton_NewAddress(0);
    break;
  case 546:
    acFavDelete(IN_u8PopupType, Enum_BOOL_TRUE);
    break;
  case 547:
    acShowPopupText(Enum_POPUP_FAVORITES_HOME_EDIT);
    break;
  case 548:
    acFavDelete(IN_u8PopupType, Enum_BOOL_FALSE);
    break;
  case 549:
    ac_N_SpellerEdit_Ok_touch(AppHmi_NavigationModule_NavigationScenes_N_Favorites);
    break;
  case 550:
    ac_N_SpellerEdit_Ok_touch(AppHmi_NavigationModule_NavigationScenes_N_Fav_AddFavorites);
    break;
  case 551:
    acSetWaypointoption(EXT_bIsGuidanceActive);
    break;
  case 552:
    acInitPOICategoryBrowse(Enum_SEARCHSCOPE_AROUND_CURRENT_LOCATION_POSITION);
    break;
  case 553:
    acInitPOICategoryBrowse(Enum_SEARCHSCOPE_AT_ADDRESS);
    break;
  case 554:
    ac_N_SpellerEdit_Ok_touch(AppHmi_NavigationModule_NavigationScenes_N_SpellerEdit);
    break;
  case 555:
    acUPOIStartInput(IN_bIsUPOIFreeTextSearch);
    break;
  case 556:
    acNavigationPopUpVisible(AppHmi_NavigationModule_NavigationScenes_Pfo_MultiLine_Text, 4000);
    break;
  case 557:
    acWaypointDelete(IN_u8PopupType);
    break;

  default:
    break;
  }
}
