/************************************************************************
*FILE: AppHmi_NavigationDatabinding.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(AppHmi_NavigationDatabinding_h)
#define AppHmi_NavigationDatabinding_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <AppHmi_NavigationConstants.h>
#include <ProjectBaseDataBinding.h>
#include <CanderaWidget/String/String.h>
#include <Candera/Engine2D/Core/Image2D.h>

// =========================================================================
struct SignpostTextData {
    Candera::String mSignpostfirstline;
    Candera::String mSignpostsecondline;
    Candera::Color mTextLinesColor;
    Candera::Color mBackgroundImageColor;
    Candera::String mExitNumber;
    Candera::Margin mExitNumberPositioning;
    bool mSignpostActive;
    bool mExitNumberExists;
    Courier::UInt8 mSignpostRegionType;
    Candera::String mSignpostDirectionName;
    Candera::HorizontalAlignment mSignpostPosition;

    SignpostTextData();
};

// =========================================================================
struct HlgImageDataData {
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mHlgImage;
    bool mHlgImageVisible;
    bool mToggleLaneGuidanceVisibility;

    HlgImageDataData();
};

// =========================================================================
struct RoadIconsData {
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mRoadIconImage;
};

// =========================================================================
struct MapModeData {
    bool mIsDayModeActive;

    MapModeData();
};

// =========================================================================
struct BTTetheringStateData {
    Candera::UInt8 mTetheringIndex;

    BTTetheringStateData();
};

// =========================================================================
struct AddressInputValueData {
    Candera::String mCountry;
    Candera::String mState;
    Candera::String mCity;
    Candera::String mStreet;
    Candera::String mHousenum;
    Candera::String mIntersection;

    AddressInputValueData();
};

// =========================================================================
struct ChangeCountryButtonData {
    bool mIsVisible;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mCountryIcon;

    ChangeCountryButtonData();
};

// =========================================================================
struct PreviousDestinationValData {
    Candera::String mPOIaddress;

    PreviousDestinationValData();
};

// =========================================================================
struct VariantButtonData {
    bool mVisibleCountry;
    bool mVisibleState;
    bool mVisibleProvince;

    VariantButtonData();
};

// =========================================================================
struct DEDisableButtonData {
    bool mCity;
    bool mStreet;
    bool mInterSection;
    bool mHousenum;
    bool mDetails;
    bool mGuidance;
    bool mPOISearch;
};

// =========================================================================
struct AddressInputValPOIData {
    Candera::String mCountry;
    Candera::String mCity;
    Candera::String mPOISearch;

    AddressInputValPOIData();
};

// =========================================================================
struct AddressInputValDetailsData {
    Candera::String mLine1;
    Candera::String mLine2;
    Candera::String mLine3;
    Candera::String mLine4;
    Candera::String mPOIAmbiguousDetails2;

    AddressInputValDetailsData();
};

// =========================================================================
struct PlaceInfoButtonsData {
    bool mGoHereVisibility;

    PlaceInfoButtonsData();
};

// =========================================================================
struct PlaceInfoDetailsData {
    Candera::String mName;
    Candera::String mAddress;
    Candera::String mPhonenumber;
    Candera::String mLine4;

    PlaceInfoDetailsData();
};

// =========================================================================
struct TwoLinePopuptextData {
    Candera::String mPopuptextLine1;
    Candera::String mPopuptextLine2;

    TwoLinePopuptextData();
};

// =========================================================================
struct MultiLinePopuptextData {
    Candera::String mTextLine1;
    Candera::String mTextLine2;

    MultiLinePopuptextData();
};

// =========================================================================
struct ThreeLinePopuptextData {
    Candera::String mTextLine1;
    Candera::String mTextLine2;
    Candera::String mTextLine3;

    ThreeLinePopuptextData();
};

// =========================================================================
struct RouteInfoPopupTextData {
    Candera::String mTextLine1;
    Candera::String mTextLine2;

    RouteInfoPopupTextData();
};

// =========================================================================
struct FourLinePopupTextData {
    Candera::String mMultiLineText;

    FourLinePopupTextData();
};

// =========================================================================
struct FiveLinePopupTextData {
    Candera::String mPopupTextLine1;
    Candera::String mPopupTextLine2;
    Candera::String mPopupTextLine3;
    Candera::String mPopupTextLine4;
    Candera::String mPopupTextLine5;

    FiveLinePopupTextData();
};

// =========================================================================
struct SpellerPressedKeyInfoData {
    Candera::String mPressedKey;

    SpellerPressedKeyInfoData();
};

// =========================================================================
struct SpellerPagesData {
    Candera::String mSpellerPageNumber;

    SpellerPagesData();
};

// =========================================================================
struct SpellerTextInfoData {
    Candera::String mText;

    SpellerTextInfoData();
};

// =========================================================================
struct NaviSpellerInfoData {
    Candera::UInt32 mCountryCode;
    Candera::UInt32 mLanguageCode;

    NaviSpellerInfoData();
};

// =========================================================================
struct AddressEntryTitleTextData {
    Candera::String mTitleValue;

    AddressEntryTitleTextData();
};

// =========================================================================
struct NaviMiddlewareStatusData {
    bool mIsNaviMiddlewareActive;

    NaviMiddlewareStatusData();
};

// =========================================================================
struct FreeTextListItemData {
    Candera::String mName;
};

// =========================================================================
struct SpellerEntryTextReceivedInfoData {
    Candera::String mEntryText;
    Candera::String mSuggestedText;
    Candera::String mValidChar;
    Candera::String mMatches;
    bool mEnteredChar;
    bool mCandidateListVisibility;
    bool mStateNameVisibility;

    SpellerEntryTextReceivedInfoData();
};

// =========================================================================
struct AddressEntryInputMatchesData {
    Candera::String mNoOfMatches;
};

// =========================================================================
struct GuidanceBlockUnblockButtonData {
    Candera::String mBlockUnblockText;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mBlockUnblockNormalIcon;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mBlockUnblockPressedIcon;
    bool mBlockUnblockEnable;

    GuidanceBlockUnblockButtonData();
};

// =========================================================================
struct POICategoryRootItemData {
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mIconNormalBitmap;
    Candera::String mName;
};

// =========================================================================
struct ShowPOIsOnMapItemData {
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mIconNormalBitmap;
};

// =========================================================================
struct ShowRouteListItemData {
    Candera::String mRouteListItem;
    Candera::String mDistanceInfo;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mTurnIconActiveBitmap;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mRoadIconActiveBitmap;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mRouteSelectionActiveBitmap;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mRouteList_BlockUnblockNormalIcon;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mRouteList_BlockUnblockPressedIcon;
};

// =========================================================================
struct BlockRouteListItemData {
    bool mRecalcEnableDisable;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mRecalculateIcon;
};

// =========================================================================
struct POICategoryListItemData {
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mDirectionIconActiveBitmap;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mDirectionIconActiveFocusesBitmap;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mDirectionIconNormalBitmap;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mDirectionIconFocusedBitmap;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mDirectionIconPressedBitmap;
    Candera::String mName;
    Candera::String mDistance;
    Candera::String mAddress;
    bool mVisible;

    POICategoryListItemData();
};

// =========================================================================
struct POIDetailedInfoData {
    Candera::String mName;
    Candera::String mAddress;
};

// =========================================================================
struct POICategoryBrowseCheckData {
    bool mPOITopCategoryStatus;
    bool mPOIResultListStatus;

    POICategoryBrowseCheckData();
};

// =========================================================================
struct StoredLocationIconData {
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mLocationIconActiveBitmap;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mLocationIconActiveFocusesBitmap;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mLocationIconNormalBitmap;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mLocationIconFocusedBitmap;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mLocationIconPressedBitmap;
    Candera::String mLocationNameInfo;
};

// =========================================================================
struct AddressDetailedInfoIconData {
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mFav_EditNormalIcon;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mFav_EditPressedIcon;
    bool mDeleteIconButtonVisibility;
    bool mDeleteAllIconButtonVisibility;

    AddressDetailedInfoIconData();
};

// =========================================================================
struct AddressInputButtonVisibilityData {
    bool mDetailInfoButtonVisibility;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mGuidance_HomeNormalIconEnabled;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mGuidance_HomePressedIconEnabled;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mGuidance_HomeIconDisabled;

    AddressInputButtonVisibilityData();
};

// =========================================================================
struct TrafficIconsData {
    Candera::String mTrafficIconName;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mTrafficIconImage;
    Courier::UInt8 mToggleIconSwitchIndex;

    TrafficIconsData();
};

// =========================================================================
struct GuidanceSettingsData {
    Courier::UInt8 mCurrentGuidanceVolume;
    Courier::UInt8 mGuidanceVoiceStatus;
    Courier::UInt8 mTrafficAnnouncementStatus;
    Courier::UInt8 mTollBothGuideStatus;

    GuidanceSettingsData();
};

// =========================================================================
struct CheckBoxListItemData {
    Candera::String mListItemName;
    Courier::UInt8 mToggleIconSwitchIndex;

    CheckBoxListItemData();
};

// =========================================================================
struct RoutePreferenceCheckBoxListItemData {
    bool mCheckBoxStatus;

    RoutePreferenceCheckBoxListItemData();
};

// =========================================================================
struct RoutePreferenceAdjustmentListItemData {
    Candera::String mRouteTypeOption;
    Candera::String mOptionValue;

    RoutePreferenceAdjustmentListItemData();
};

// =========================================================================
struct NavigationGadgetInfoData {
    Courier::UInt8 mIsGuidanceActive;
    Candera::String mHomeTileStreetStr;

    NavigationGadgetInfoData();
};

// =========================================================================
struct LatLongSpellerPressedKeyInfoData {
    Candera::String mPressedKey_LatLongEditField;
};

// =========================================================================
struct LatLongSpellerTextReceivedData {
    Candera::String mTextReceive_LatLongEditField;
};

// =========================================================================
struct LatLongEditFieldBGImageItemData {
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mLatitudeDegreesBGBitmap;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mLatitudeMinutesBGBitmap;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mLatitudeSecondsBGBitmap;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mLatitudeDecimalsBGBitmap;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mLongitudeDegreesBGBitmap;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mLongitudeMinutesBGBitmap;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mLongitudeSecondsBGBitmap;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mLongitudeDecimalsBGBitmap;
};

// =========================================================================
struct LatLongDataValuesData {
    Candera::String mLatDegreesInputValues;
    Candera::String mLongDegreesInputValues;
    Candera::String mLatMinutesInputValues;
    Candera::String mLongMinutesInputValues;
    Candera::String mLatSecondsInputValues;
    Candera::String mLongSecondsInputValues;
    Candera::String mLatDecimalsInputValues;
    Candera::String mLongDecimalsInputValues;
};

// =========================================================================
struct LatLongCoordinatesDirectionData {
    Candera::String mNorthSouthEditFieldTxt;
    Candera::String mEastWestEditFieldTxt;
    Candera::String mNorthSouthButtonTxt;
    Candera::String mEastWestButtonTxt;
    bool mActiveNorthSouthEditField;
    bool mActiveEastWestEditField;

    LatLongCoordinatesDirectionData();
};

// =========================================================================
struct ToggleButtonTextData {
    Candera::String mSouthNorthButtonText;
    Candera::String mEastWestButtonText;

    ToggleButtonTextData();
};

// =========================================================================
struct LatLongCoordinatesFormatData {
    Courier::UInt8 mLatLongFormatIndex;

    LatLongCoordinatesFormatData();
};

// =========================================================================
struct EnableSetLatLongButtonData {
    bool mIsButtonVisible;
    bool mIsPopUpVisible;

    EnableSetLatLongButtonData();
};

// =========================================================================
struct PickFromMapDataData {
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mMapPickingImage;
    Candera::String mMapPickingType;
    Candera::String mMapPickingPhoneNumber;
    Candera::String mSelectedRoad;
    Candera::String mMapPickingInfo;
    Courier::UInt32 mMapPickingNumber;
    Courier::UInt32 mMapPickingSize;
    bool mPhoneNumberAvailable;
    bool mIsValidLocationAvailable;
    bool mMapPickingInfoAvailable;
    Courier::UInt32 mLineSwitchIndex;
    Candera::String mFirstLineInfo;
    Candera::String mSecondLineInfo;
    bool mEnablePreviousInfoArrow;
    bool mEnableNextInfoArrow;
    Candera::String mCurrentAndTotalPageNumberDisplay;
    Courier::UInt32 mWaypointNumber;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mPickedDirection;
    Candera::String mPickedDistance;
    Candera::String mDetailPickingInfo;
};

// =========================================================================
struct EnableOkButtonData {
    bool mIsOKButtonVisible;

    EnableOkButtonData();
};

// =========================================================================
struct EnablePhoneButtonData {
    bool mIsPhoneButtonVisible;

    EnablePhoneButtonData();
};

// =========================================================================
struct EnableGuidanceButtonData {
    bool mIsGuidanceButtonVisible;
    bool mIsFavButtonVisible;
    Candera::UInt8 mBackButtonLevelIndex;

    EnableGuidanceButtonData();
};

// =========================================================================
struct CompassButtonData {
    Candera::UInt32 mCompassOrientation;

    CompassButtonData();
};

// =========================================================================
struct MapoutScreenDataData {
    Candera::String mETADestination;
    Candera::String mETAWaypoint;
    bool mIsWaypointPresent;

    MapoutScreenDataData();
};

// =========================================================================
struct MapScreenDataData {
    Candera::String mPickingResultLatitudeLongitude;
    Candera::String mCurrentStreet;
    Candera::String mCurrentCity;
    Candera::String mDistanceToDestination;
    Candera::String mTimeToDestination;
    Candera::String mArrivalTimeToBeShownOnMap;
    Candera::String mETATextLabelValue;
    Candera::UInt32 mCompassArrowDirection;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mCompassArrowDirectionIcon;
    Candera::String mZoomLevel;
    Courier::Float mZoomSliderCurrentValue;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mSecMapCompassArrowDirectionIcon;
    Candera::String mSecZoomLevel;
    Courier::UInt8 mScaleImageSwitch;
    Candera::String mSpeedLimit;
    bool misSpeedLimitPresent;
    bool misOverSpeedWarning;
    Candera::String mSpeedlimitWithUnit;
    Candera::UInt32 mSpeedcountryCode;
    Candera::Vector2 mSpeedLimitIconPosition;
    bool mShowMapActiveRGButtons;
    bool mStartShowMapActiveRGButtonTimer;
    bool mIsGuidanceVoiceEnabled;
    Candera::String mMuteUnmuteText;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mMuteUnmuteNormalIcon;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mMuteUnmutePressedIcon;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mMuteUnmuteDisabledIcon;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mNaviGadgetIcon;

    MapScreenDataData();
};

// =========================================================================
struct SplitMapScreenDataData {
    Candera::Vector2 mLaneGuidanceSplitViewPosition;
    bool mEnableSplitMapItems;

    SplitMapScreenDataData();
};

// =========================================================================
struct MapMainScreenStateData {
    Courier::UInt8 mMapMainScreenStateValue;

    MapMainScreenStateData();
};

// =========================================================================
struct TurnListETAItemData {
    Candera::String mDistanceToDestination;
    Candera::String mTimeToDestination;
    Candera::String mDestinationName;

    TurnListETAItemData();
};

// =========================================================================
struct ODRDataData {
    Candera::String mTurnToStreet;
    Candera::String mTurnToStreetWithDistance;
    Candera::String mDistanceToManeuver;
    Candera::String mDistanceToManeuverUnit;
    Courier::Float mManeuverBargraphValue;
    bool mShowManeuverBargraph;
    Candera::UInt32 mManeuverSymbolIndex;

    ODRDataData();
};

// =========================================================================
struct RouteOverviewBtnData {
    bool mIsRouteOverviewBtnEnabled;

    RouteOverviewBtnData();
};

// =========================================================================
struct MapSettingOthersListIDData {
    Courier::UInt32 mListID;

    MapSettingOthersListIDData();
};

// =========================================================================
struct NaviBackButtonLevelData {
    Candera::UInt8 mBackButtonLevel;

    NaviBackButtonLevelData();
};

// =========================================================================
struct MapSettingsOthersTitleData {
    Candera::String mMapOtherSettingsTitleValue;
};

// =========================================================================
struct ZoomBarInfoData {
    bool mIsZoomTimerStart;
    bool mIsZoomBarDisplayed;

    ZoomBarInfoData();
};

// =========================================================================
struct MultiLinePopupTextData {
    Candera::String mThreeLinePopupText1;
    Candera::String mThreeLinePopupText2;
    Candera::String mThreeLinePopupText3;

    MultiLinePopupTextData();
};

// =========================================================================
struct SettingSliderData {
    bool mIncreasable;
    bool mDecreasable;
    Candera::Int mCurrentValue;
    bool mButtonIsActive;

    SettingSliderData();
};

// =========================================================================
struct WhereAmIScreenDataData {
    Candera::String mCurrentStreetInfo;
    Candera::String mCurrentCityInfo;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mCurrentStreetRoadNrImage;

    WhereAmIScreenDataData();
};

// =========================================================================
struct WaypointListInfoData {
    Candera::String mWaypointListItem;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mWaypointNormalIcon;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mWaypointPressedIcon;

    WaypointListInfoData();
};

// =========================================================================
struct GPSInfoData {
    Candera::String mDateValue;
    Candera::String mAltitudeValue;
    Candera::String mCapturedSatelliteNumber;
    Candera::String mSearchingSatelliteNumber;
    Candera::String mGnssModeType;
    Candera::String mLatViaSensor;
    Candera::String mLongViaSensor;
    Candera::String mVisibleSatellite;
    Candera::String mGNSSTypeInfo;
    Candera::String mTimeInfo;
    Candera::String mHeadingInfo;
    Candera::String mGPSCoordinate;
    bool mGPSUnAvailable;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mSatelliteIcon;
    bool mSatelliteIconVisibility;

    GPSInfoData();
};

// =========================================================================
struct SwitchindexData {
    Courier::UInt8 mIndexValue;

    SwitchindexData();
};

// =========================================================================
struct LaneGuidanceData {
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mBitmapImage1;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mBitmapImage2;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mBitmapImage3;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mBitmapImage4;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mBitmapImage5;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mBitmapImage6;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mBitmapImage7;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mBitmapImage8;
    Candera::String mHovOccupancy;

    LaneGuidanceData();
};

// =========================================================================
struct RouteGuidancetextImageUpdationData {
    Candera::String mText;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mIcon_Normal;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mIcon_Pressed;

    RouteGuidancetextImageUpdationData();
};

// =========================================================================
struct TrafficMessagesData {
    Candera::String mTrafficMessageText;
    Candera::String mDistanceInfo;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mDirectionIconActiveBitmap;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mTrafficIconActiveBitmap;

    TrafficMessagesData();
};

// =========================================================================
struct POITitleData {
    Candera::String mPOITitleValue;

    POITitleData();
};

// =========================================================================
struct POITopCategoryTitleData {
    Candera::String mPOITopCategoryTitleValue;

    POITopCategoryTitleData();
};

// =========================================================================
struct PreviousDestCountData {
    Courier::UInt8 mTotalPreviousDestCount;

    PreviousDestCountData();
};

// =========================================================================
struct HeaderTimeData {
    Candera::String mText;

    HeaderTimeData();
};

// =========================================================================
struct HardRestrictionData {
    bool mIsFullRGEnabled;

    HardRestrictionData();
};

// =========================================================================
struct TimeDisplayData {
    Candera::String mHour;
    Candera::String mMinute;

    TimeDisplayData();
};

// =========================================================================
struct StreamMapContentData {
    Candera::String mLatitude;
    Candera::String mLongtitude;
    Candera::String mSpeed;
    Candera::String mNextMajorStation;
    bool mIsLatitudeEnabled;
    bool mIsLongtitudeEnabled;
    bool mIsSpeedEnabled;
    bool mIsNextMajorStationEnabled;

    StreamMapContentData();
};

// =========================================================================
struct NavDataPopupTextData {
    Candera::String mCurrentNavDataVersion;
    Candera::String mNewNavDataVersion;
    Candera::UInt32 mEstimatedUpdateTime;
    Candera::String mRemainingTime;
    Candera::String mErrorMsgLine1;
    Candera::UInt32 mProgressValue;

    NavDataPopupTextData();
};

// =========================================================================
struct AlternativeRouteItemsData {
    Candera::String mDistanceToDestinationFirst;
    Candera::String mDistanceToDestinationSecond;
    Candera::String mDistanceToDestinationThird;
    Candera::String mTimeToDestinationFirst;
    Candera::String mTimeToDestinationSecond;
    Candera::String mTimeToDestinationThird;
    bool mMoreRouteFirstBtnActive;
    bool mMoreRouteSecondBtnActive;
    bool mMoreRouteThirdBtnActive;
    bool mMoreRouteFirstBtnEnabled;
    bool mMoreRouteSecondBtnEnabled;
    bool mMoreRouteThirdBtnEnabled;
    bool mMoreRouteFirstBtnLoading;
    bool mMoreRouteSecondBtnLoading;
    bool mMoreRouteThirdBtnLoading;
    bool mMoreRouteFirstBtnTouchable;
    bool mMoreRouteSecondBtnTouchable;
    bool mMoreRouteThirdBtnTouchable;

    AlternativeRouteItemsData();
};

// =========================================================================
struct RouteSwitchbtnData {
    bool mIsAlternativeRouteBtnEnabled;

    RouteSwitchbtnData();
};

// =========================================================================
struct GuidanceRouteSwitchbtnData {
    bool mButtonIsActive;

    GuidanceRouteSwitchbtnData();
};

// =========================================================================
struct TrafficDetourDetailsData {
    Candera::String mTimeDifference;
    Candera::String mDistanceDifference;
    Candera::String mDistanceToTraffic;
    Candera::String mTrafficIncidentDetails;
    Candera::String mTrafficIncidentName;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mTrafficIncidentIcon;
    Candera::String mHasTrafficMessageDescription;

    TrafficDetourDetailsData();
};

// =========================================================================
struct XUrgentTrafficMessageData {
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mTrafficIncidentIcon;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mDirection;
    Candera::String mDistance;
    Candera::String mDetails;
};

// =========================================================================
struct EngineeringMenuDetailsData {
    Candera::String mEngineeringMenuTextDetails;
    bool mIsDemoModeEnabled;

    EngineeringMenuDetailsData();
};

// =========================================================================
struct EngineeringMenuTitleData {
    Candera::String mTitleDetail;

    EngineeringMenuTitleData();
};

// =========================================================================
struct EngineeringMenuListCheckData {
    bool mEngineeringMenuListStatus;
    bool mEngineeringMenuTopListStatus;

    EngineeringMenuListCheckData();
};

// =========================================================================
struct VehicleProfileInfoData {
    Candera::String mProfile;
    Candera::String mLength;
    Candera::String mHeight;
    Candera::String mWidth;
    Candera::String mTotalWeight;
    Candera::String mTrailerType;
    Candera::String mMaxSpeed;
    Candera::String mGoodsType;
    Candera::String mLoadPerAxle;
    bool mIsTruckType;

    VehicleProfileInfoData();
};

// =========================================================================
struct StreamedMapSettingData {
    bool mStreamedMapTypeSettingStatus;

    StreamedMapSettingData();
};

// =========================================================================
struct MyPOIsAvailabilityData {
    bool mIsMyPOIsAvailable;

    MyPOIsAvailabilityData();
};

// =========================================================================
struct RouteOptionsBorderData {
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mFastestIcon;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mShortestIcon;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mOptimisedIcon;
};

// =========================================================================
struct RouteRestrictionsPopupTextData {
    Candera::String mTextLine1;
    Candera::String mTextLine2;
    Candera::String mTextLine3;

    RouteRestrictionsPopupTextData();
};

// =========================================================================
struct SoftRestrictionData {
    bool mIsSoftPhysicalRestriction;

    SoftRestrictionData();
};

// =========================================================================
struct MapOptionOthersSettingData {
    bool mMapOptionOthersSettingStatus;

    MapOptionOthersSettingData();
};
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
namespace FeatStd {
template<> ::FeatStd::UInt32 StringBufferAppender< ::SignpostTextData >::Append(::FeatStd::StringBuffer& stringBuffer, ::SignpostTextData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::HlgImageDataData >::Append(::FeatStd::StringBuffer& stringBuffer, ::HlgImageDataData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::RoadIconsData >::Append(::FeatStd::StringBuffer& stringBuffer, ::RoadIconsData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::MapModeData >::Append(::FeatStd::StringBuffer& stringBuffer, ::MapModeData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::BTTetheringStateData >::Append(::FeatStd::StringBuffer& stringBuffer, ::BTTetheringStateData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::AddressInputValueData >::Append(::FeatStd::StringBuffer& stringBuffer, ::AddressInputValueData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::ChangeCountryButtonData >::Append(::FeatStd::StringBuffer& stringBuffer, ::ChangeCountryButtonData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::PreviousDestinationValData >::Append(::FeatStd::StringBuffer& stringBuffer, ::PreviousDestinationValData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::VariantButtonData >::Append(::FeatStd::StringBuffer& stringBuffer, ::VariantButtonData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::DEDisableButtonData >::Append(::FeatStd::StringBuffer& stringBuffer, ::DEDisableButtonData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::AddressInputValPOIData >::Append(::FeatStd::StringBuffer& stringBuffer, ::AddressInputValPOIData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::AddressInputValDetailsData >::Append(::FeatStd::StringBuffer& stringBuffer, ::AddressInputValDetailsData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::PlaceInfoButtonsData >::Append(::FeatStd::StringBuffer& stringBuffer, ::PlaceInfoButtonsData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::PlaceInfoDetailsData >::Append(::FeatStd::StringBuffer& stringBuffer, ::PlaceInfoDetailsData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::TwoLinePopuptextData >::Append(::FeatStd::StringBuffer& stringBuffer, ::TwoLinePopuptextData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::MultiLinePopuptextData >::Append(::FeatStd::StringBuffer& stringBuffer, ::MultiLinePopuptextData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::ThreeLinePopuptextData >::Append(::FeatStd::StringBuffer& stringBuffer, ::ThreeLinePopuptextData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::RouteInfoPopupTextData >::Append(::FeatStd::StringBuffer& stringBuffer, ::RouteInfoPopupTextData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::FourLinePopupTextData >::Append(::FeatStd::StringBuffer& stringBuffer, ::FourLinePopupTextData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::FiveLinePopupTextData >::Append(::FeatStd::StringBuffer& stringBuffer, ::FiveLinePopupTextData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::SpellerPressedKeyInfoData >::Append(::FeatStd::StringBuffer& stringBuffer, ::SpellerPressedKeyInfoData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::SpellerPagesData >::Append(::FeatStd::StringBuffer& stringBuffer, ::SpellerPagesData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::SpellerTextInfoData >::Append(::FeatStd::StringBuffer& stringBuffer, ::SpellerTextInfoData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::NaviSpellerInfoData >::Append(::FeatStd::StringBuffer& stringBuffer, ::NaviSpellerInfoData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::AddressEntryTitleTextData >::Append(::FeatStd::StringBuffer& stringBuffer, ::AddressEntryTitleTextData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::NaviMiddlewareStatusData >::Append(::FeatStd::StringBuffer& stringBuffer, ::NaviMiddlewareStatusData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::FreeTextListItemData >::Append(::FeatStd::StringBuffer& stringBuffer, ::FreeTextListItemData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::SpellerEntryTextReceivedInfoData >::Append(::FeatStd::StringBuffer& stringBuffer, ::SpellerEntryTextReceivedInfoData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::AddressEntryInputMatchesData >::Append(::FeatStd::StringBuffer& stringBuffer, ::AddressEntryInputMatchesData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::GuidanceBlockUnblockButtonData >::Append(::FeatStd::StringBuffer& stringBuffer, ::GuidanceBlockUnblockButtonData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::POICategoryRootItemData >::Append(::FeatStd::StringBuffer& stringBuffer, ::POICategoryRootItemData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::ShowPOIsOnMapItemData >::Append(::FeatStd::StringBuffer& stringBuffer, ::ShowPOIsOnMapItemData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::ShowRouteListItemData >::Append(::FeatStd::StringBuffer& stringBuffer, ::ShowRouteListItemData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::BlockRouteListItemData >::Append(::FeatStd::StringBuffer& stringBuffer, ::BlockRouteListItemData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::POICategoryListItemData >::Append(::FeatStd::StringBuffer& stringBuffer, ::POICategoryListItemData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::POIDetailedInfoData >::Append(::FeatStd::StringBuffer& stringBuffer, ::POIDetailedInfoData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::POICategoryBrowseCheckData >::Append(::FeatStd::StringBuffer& stringBuffer, ::POICategoryBrowseCheckData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::StoredLocationIconData >::Append(::FeatStd::StringBuffer& stringBuffer, ::StoredLocationIconData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::AddressDetailedInfoIconData >::Append(::FeatStd::StringBuffer& stringBuffer, ::AddressDetailedInfoIconData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::AddressInputButtonVisibilityData >::Append(::FeatStd::StringBuffer& stringBuffer, ::AddressInputButtonVisibilityData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::TrafficIconsData >::Append(::FeatStd::StringBuffer& stringBuffer, ::TrafficIconsData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::GuidanceSettingsData >::Append(::FeatStd::StringBuffer& stringBuffer, ::GuidanceSettingsData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::CheckBoxListItemData >::Append(::FeatStd::StringBuffer& stringBuffer, ::CheckBoxListItemData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::RoutePreferenceCheckBoxListItemData >::Append(::FeatStd::StringBuffer& stringBuffer, ::RoutePreferenceCheckBoxListItemData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::RoutePreferenceAdjustmentListItemData >::Append(::FeatStd::StringBuffer& stringBuffer, ::RoutePreferenceAdjustmentListItemData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::NavigationGadgetInfoData >::Append(::FeatStd::StringBuffer& stringBuffer, ::NavigationGadgetInfoData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::LatLongSpellerPressedKeyInfoData >::Append(::FeatStd::StringBuffer& stringBuffer, ::LatLongSpellerPressedKeyInfoData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::LatLongSpellerTextReceivedData >::Append(::FeatStd::StringBuffer& stringBuffer, ::LatLongSpellerTextReceivedData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::LatLongEditFieldBGImageItemData >::Append(::FeatStd::StringBuffer& stringBuffer, ::LatLongEditFieldBGImageItemData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::LatLongDataValuesData >::Append(::FeatStd::StringBuffer& stringBuffer, ::LatLongDataValuesData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::LatLongCoordinatesDirectionData >::Append(::FeatStd::StringBuffer& stringBuffer, ::LatLongCoordinatesDirectionData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::ToggleButtonTextData >::Append(::FeatStd::StringBuffer& stringBuffer, ::ToggleButtonTextData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::LatLongCoordinatesFormatData >::Append(::FeatStd::StringBuffer& stringBuffer, ::LatLongCoordinatesFormatData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::EnableSetLatLongButtonData >::Append(::FeatStd::StringBuffer& stringBuffer, ::EnableSetLatLongButtonData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::PickFromMapDataData >::Append(::FeatStd::StringBuffer& stringBuffer, ::PickFromMapDataData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::EnableOkButtonData >::Append(::FeatStd::StringBuffer& stringBuffer, ::EnableOkButtonData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::EnablePhoneButtonData >::Append(::FeatStd::StringBuffer& stringBuffer, ::EnablePhoneButtonData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::EnableGuidanceButtonData >::Append(::FeatStd::StringBuffer& stringBuffer, ::EnableGuidanceButtonData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::CompassButtonData >::Append(::FeatStd::StringBuffer& stringBuffer, ::CompassButtonData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::MapoutScreenDataData >::Append(::FeatStd::StringBuffer& stringBuffer, ::MapoutScreenDataData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::MapScreenDataData >::Append(::FeatStd::StringBuffer& stringBuffer, ::MapScreenDataData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::SplitMapScreenDataData >::Append(::FeatStd::StringBuffer& stringBuffer, ::SplitMapScreenDataData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::MapMainScreenStateData >::Append(::FeatStd::StringBuffer& stringBuffer, ::MapMainScreenStateData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::TurnListETAItemData >::Append(::FeatStd::StringBuffer& stringBuffer, ::TurnListETAItemData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::ODRDataData >::Append(::FeatStd::StringBuffer& stringBuffer, ::ODRDataData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::RouteOverviewBtnData >::Append(::FeatStd::StringBuffer& stringBuffer, ::RouteOverviewBtnData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::MapSettingOthersListIDData >::Append(::FeatStd::StringBuffer& stringBuffer, ::MapSettingOthersListIDData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::NaviBackButtonLevelData >::Append(::FeatStd::StringBuffer& stringBuffer, ::NaviBackButtonLevelData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::MapSettingsOthersTitleData >::Append(::FeatStd::StringBuffer& stringBuffer, ::MapSettingsOthersTitleData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::ZoomBarInfoData >::Append(::FeatStd::StringBuffer& stringBuffer, ::ZoomBarInfoData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::MultiLinePopupTextData >::Append(::FeatStd::StringBuffer& stringBuffer, ::MultiLinePopupTextData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::SettingSliderData >::Append(::FeatStd::StringBuffer& stringBuffer, ::SettingSliderData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::WhereAmIScreenDataData >::Append(::FeatStd::StringBuffer& stringBuffer, ::WhereAmIScreenDataData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::WaypointListInfoData >::Append(::FeatStd::StringBuffer& stringBuffer, ::WaypointListInfoData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::GPSInfoData >::Append(::FeatStd::StringBuffer& stringBuffer, ::GPSInfoData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::SwitchindexData >::Append(::FeatStd::StringBuffer& stringBuffer, ::SwitchindexData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::LaneGuidanceData >::Append(::FeatStd::StringBuffer& stringBuffer, ::LaneGuidanceData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::RouteGuidancetextImageUpdationData >::Append(::FeatStd::StringBuffer& stringBuffer, ::RouteGuidancetextImageUpdationData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::TrafficMessagesData >::Append(::FeatStd::StringBuffer& stringBuffer, ::TrafficMessagesData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::POITitleData >::Append(::FeatStd::StringBuffer& stringBuffer, ::POITitleData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::POITopCategoryTitleData >::Append(::FeatStd::StringBuffer& stringBuffer, ::POITopCategoryTitleData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::PreviousDestCountData >::Append(::FeatStd::StringBuffer& stringBuffer, ::PreviousDestCountData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::HeaderTimeData >::Append(::FeatStd::StringBuffer& stringBuffer, ::HeaderTimeData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::HardRestrictionData >::Append(::FeatStd::StringBuffer& stringBuffer, ::HardRestrictionData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::TimeDisplayData >::Append(::FeatStd::StringBuffer& stringBuffer, ::TimeDisplayData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::StreamMapContentData >::Append(::FeatStd::StringBuffer& stringBuffer, ::StreamMapContentData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::NavDataPopupTextData >::Append(::FeatStd::StringBuffer& stringBuffer, ::NavDataPopupTextData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::AlternativeRouteItemsData >::Append(::FeatStd::StringBuffer& stringBuffer, ::AlternativeRouteItemsData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::RouteSwitchbtnData >::Append(::FeatStd::StringBuffer& stringBuffer, ::RouteSwitchbtnData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::GuidanceRouteSwitchbtnData >::Append(::FeatStd::StringBuffer& stringBuffer, ::GuidanceRouteSwitchbtnData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::TrafficDetourDetailsData >::Append(::FeatStd::StringBuffer& stringBuffer, ::TrafficDetourDetailsData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::XUrgentTrafficMessageData >::Append(::FeatStd::StringBuffer& stringBuffer, ::XUrgentTrafficMessageData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::EngineeringMenuDetailsData >::Append(::FeatStd::StringBuffer& stringBuffer, ::EngineeringMenuDetailsData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::EngineeringMenuTitleData >::Append(::FeatStd::StringBuffer& stringBuffer, ::EngineeringMenuTitleData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::EngineeringMenuListCheckData >::Append(::FeatStd::StringBuffer& stringBuffer, ::EngineeringMenuListCheckData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::VehicleProfileInfoData >::Append(::FeatStd::StringBuffer& stringBuffer, ::VehicleProfileInfoData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::StreamedMapSettingData >::Append(::FeatStd::StringBuffer& stringBuffer, ::StreamedMapSettingData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::MyPOIsAvailabilityData >::Append(::FeatStd::StringBuffer& stringBuffer, ::MyPOIsAvailabilityData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::RouteOptionsBorderData >::Append(::FeatStd::StringBuffer& stringBuffer, ::RouteOptionsBorderData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::RouteRestrictionsPopupTextData >::Append(::FeatStd::StringBuffer& stringBuffer, ::RouteRestrictionsPopupTextData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::SoftRestrictionData >::Append(::FeatStd::StringBuffer& stringBuffer, ::SoftRestrictionData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::MapOptionOthersSettingData >::Append(::FeatStd::StringBuffer& stringBuffer, ::MapOptionOthersSettingData const & object);
} // namespace FeatStd
#endif
#endif // AppHmi_NavigationDatabinding_h
