/************************************************************************
*FILE: AppHmi_MediaStateMachineData.cpp 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/*
 * Id:        AppHmi_MediaStateMachineData.cpp
 *
 * Function:  VS System Data Source File.
 *
 * Generated: Mon Feb 06 13:40:13 2023
 *
 * Coder 7, 3, 2, 2426
 * 
 * This is an automatically generated file. It will be overwritten by the Coder.
 * 
 * DO NOT EDIT THE FILE!
 */


#include "AppHmi_MediaStateMachineSEMLibB.h"


#include "AppHmi_MediaStateMachineData.h"


#include <stdarg.h>


/*
 * VS System External Variable Definitions.
 */
VS_BOOL SM_VARIANT_TYPE_VIDEO = 1;

VS_INT g_SM_ActiveMediaActivityID = 0;

VS_UINT8 g_SM_ActiveMediaSource = 0u;

VS_INT g_SM_ActiveRegion = 2;

VS_INT g_SM_ActiveUSBCameraPort = 0;

VS_INT g_SM_Activity_SourceSel = 0;

VS_INT g_SM_BTDeviceStatus = 0;

VS_INT8 g_SM_CarPlayStatus = 0;

VS_UINT32 g_SM_CurrentView = 0ul;

VS_INT g_SM_DevConnTypeChanged = 0;

VS_INT g_SM_InitialTabLoading = 0;

VS_INT g_SM_IsIAPDevice = 0;

VS_INT g_SM_IsSourceCheckState = 0;

VS_INT g_SM_ListType = 255;

VS_INT g_SM_MediaFileType = 1;

VS_INT g_SM_PfoMessage_PopUpActive = 0;

VS_INT g_SM_PrepareDeactivate = 0;

VS_INT g_SM_RequestedView = 0;

VS_INT g_SM_ScreenRecreate = 0;

VS_INT g_SM_SourceSelectStatus = 0;

VS_BOOL g_SM_VARIANT_AUX = 1;

VS_INT g_SM_VideoreRestriction = 0;

VS_INT g_SM_optionselstatus = 0;


/*
 * VS System Internal Variable Initializing Function.
 */
void AppHmi_MediaStateMachine::SEM_InitInternalVariables (void)
{
  SMInternal_MediaActivityID = 0.;
}


void AppHmi_MediaStateMachine::BufferVariables (SEM_EVENT_TYPE EventNo)
{
  switch (EventNo)
  {
  case 27:
    VSDBVar.DB27.VS_INTVar[0] = g_SM_IsSourceCheckState;
    break;

  default:
    break;
  }
}


/*
 * SEM Deduct Function.
 */
unsigned char AppHmi_MediaStateMachine::SEM_Deduct (SEM_EVENT_TYPE EventNo, ...)
{
  va_list ap;

  va_start(ap, EventNo);
  if (SEM.State == 0x00u /* STATE_SEM_NOT_INITIALIZED */)
  {
    return SES_NOT_INITIALIZED;
  }
  if (VS_NOF_EVENTS <= EventNo)
  {
    return (SES_RANGE_ERR);
  }
  switch (EventNo)
  {
  case 331:
    EventArgsVar.DB352.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 340:
    EventArgsVar.DB352.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 341:
    EventArgsVar.DB352.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 345:
    EventArgsVar.DB352.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 346:
    EventArgsVar.DB352.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 347:
    EventArgsVar.DB352.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 348:
    EventArgsVar.DB352.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 349:
    EventArgsVar.DB352.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 350:
    EventArgsVar.DB352.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 351:
    EventArgsVar.DB351.VS_INT8Var[0] = (VS_INT8) va_arg(ap, VS_INT);
    break;

  case 352:
    EventArgsVar.DB352.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    EventArgsVar.DB352.VS_UINT32Var[1] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 353:
    EventArgsVar.DB352.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 363:
    EventArgsVar.DB352.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 364:
    EventArgsVar.DB365.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 365:
    EventArgsVar.DB365.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 366:
    EventArgsVar.DB368.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 367:
    EventArgsVar.DB368.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 368:
    EventArgsVar.DB368.VS_INT32Var[0] = (VS_INT32) va_arg(ap, VS_INT32_VAARG);
    EventArgsVar.DB368.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 369:
    EventArgsVar.DB368.VS_INT32Var[0] = (VS_INT32) va_arg(ap, VS_INT32_VAARG);
    EventArgsVar.DB368.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 370:
    EventArgsVar.DB368.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 371:
    EventArgsVar.DB368.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 372:
    EventArgsVar.DB368.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 373:
    EventArgsVar.DB368.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  default:
    break;
  }
  if (EventNo == SE_RESET)
  {
    SEM.EventNo = SE_RESET;
    SEM.DIt = 2;
  }
  else
  {
    SEM.EventNo = VS_TRIGGERLESS_TRIGGER;
    SEM.DIt = 0;
  }
  SEM.State = 0x02u; /* STATE_SEM_PREPARE */
  SEM.InitialEventNo = EventNo;

  va_end(ap);
  return (SES_OKAY);
}


/*
 * Guard Expression Functions.
 */
VS_BOOL AppHmi_MediaStateMachine::VSGuard (SEM_GUARD_EXPRESSION_TYPE i)
{
  switch (i)
  {
  case 0:
    return (VS_BOOL)(EventArgsVar.DB352.VS_UINT32Var[0] == Media_MediaPlayer_Pop_Up_system_Pfo_MediaMessage);
  case 1:
    return (VS_BOOL)(EventArgsVar.DB352.VS_UINT32Var[0] == Media_MediaPlayer_Pop_Up_system_Pfo_MediaDB_Download_Successful);
  case 2:
    return (VS_BOOL)(EventArgsVar.DB352.VS_UINT32Var[0] == Media_MediaPlayer_Pop_Up_system_Pfo_MediaUnsupportedPopupMessage);
  case 3:
    return (VS_BOOL)(EventArgsVar.DB352.VS_UINT32Var[0] == Media_MediaPlayer_Pop_Up_system_Pfo_MediaUnsupportedPopupMessageHUB);
  case 4:
    return (VS_BOOL)(EventArgsVar.DB352.VS_UINT32Var[0] == Media_MediaPlayer_Pop_Up_system_Pfo_MediaDB_Download_Failure);
  case 5:
    return (VS_BOOL)(g_SM_ActiveMediaSource != Enum_FI_EN_E8DTY_UNKNOWN);
  case 6:
    return (VS_BOOL)(g_SM_ActiveMediaSource != Enum_FI_EN_E8DTY_UNKNOWN && g_SM_DevConnTypeChanged == 1);
  case 7:
    return (VS_BOOL)(VSDBVar.DB27.VS_INTVar[0] == 0 && g_SM_ActiveMediaSource == Enum_FI_EN_E8DTY_UNKNOWN);
  case 8:
    return (VS_BOOL)(g_SM_IsIAPDevice == 0);
  case 9:
    return (VS_BOOL)(g_SM_IsIAPDevice == 1);
  case 10:
    return (VS_BOOL)(g_SM_VARIANT_AUX == 1);
  case 11:
    return (VS_BOOL)(g_SM_ActiveMediaSource == Enum_FI_EN_E8DTY_UNKNOWN);
  case 12:
    return (VS_BOOL)(g_SM_ActiveMediaSource == Enum_FI_EN_E8DTY_IPHONE || g_SM_ActiveMediaSource == Enum_FI_EN_E8DTY_IPOD);
  case 13:
    return (VS_BOOL)(g_SM_ActiveMediaSource == Enum_FI_EN_E8DTY_USB && g_SM_MediaFileType == SM_MEDIA_VIDEO_FILE);
  case 14:
    return (VS_BOOL)((g_SM_ActiveMediaSource == Enum_FI_EN_E8DTY_USB || g_SM_ActiveMediaSource == Enum_FI_EN_E8DTY_MTP) && g_SM_MediaFileType != SM_MEDIA_VIDEO_FILE);
  case 15:
    return (VS_BOOL)(g_SM_ActiveMediaSource == Enum_FI_EN_E8DTY_AUX);
  case 16:
    return (VS_BOOL)(g_SM_ActiveMediaSource == Enum_FI_EN_E8DTY_BLUETOOTH);
  case 17:
    return (VS_BOOL)(g_SM_ActiveMediaSource == Enum_FI_EN_E8DTY_IPOD || g_SM_ActiveMediaSource == Enum_FI_EN_E8DTY_IPHONE);
  case 18:
    return (VS_BOOL)(EventArgsVar.DB352.VS_UINT32Var[0] == Enum_MEDIA_GADGET);
  case 19:
    return (VS_BOOL)(g_SM_ActiveMediaSource != Enum_FI_EN_E8DTY_IPOD && g_SM_ActiveMediaSource != Enum_FI_EN_E8DTY_IPHONE);
  case 20:
    return (VS_BOOL)(g_SM_ActiveMediaSource != Enum_FI_EN_E8DTY_IPOD && g_SM_ActiveMediaSource != Enum_FI_EN_E8DTY_IPHONE && g_SM_ActiveMediaSource != Enum_FI_EN_E8DTY_USB_CAMERAPORT && g_SM_ActiveMediaSource != Enum_FI_EN_E8DTY_ROUTER_USB);
  case 21:
    return (VS_BOOL)(EventArgsVar.DB365.VS_UINT32Var[0] == Media_MediaPlayer_Pop_Up_system_Pfo_MediaMessage);
  case 22:
    return (VS_BOOL)(IsMediaMessageAvailable() == 1);
  case 23:
    return (VS_BOOL)(VSDBVar.DB27.VS_INTVar[0] == 1);
  case 24:
    return (VS_BOOL)(EventArgsVar.DB368.VS_UINT32Var[0] == Media_MediaPlayer_Pop_Up_Pfo_MediaConfirmBTPairing);
  case 25:
    return (VS_BOOL)(EventArgsVar.DB368.VS_UINT32Var[0] == Media_MediaPlayer_Pop_Up_Pfo_VideoDisableMessage);
  case 26:
    return (VS_BOOL)(EventArgsVar.DB368.VS_UINT32Var[0] == Media_MediaPlayer_Pop_Up_Pfo_WMA_DRM_ProtectedFileMessage);
  case 27:
    return (VS_BOOL)(EventArgsVar.DB352.VS_UINT32Var[0] == Media_MediaPlayer_Pop_Up_Pfo_WaitScene);
  case 28:
    return (VS_BOOL)(EventArgsVar.DB368.VS_UINT32Var[0] == Media_MediaPlayer_Pop_Up_Pfo_MediaBTStreamingUnavailable);
  case 29:
    return (VS_BOOL)(EventArgsVar.DB368.VS_UINT32Var[0] == Media_MediaPlayer_Pop_Up_Pfo_MediaGlassUnavailableMessage);
  case 30:
    return (VS_BOOL)(EventArgsVar.DB352.VS_UINT32Var[0] == Media_MediaPlayer_Pop_Up_Pfo_NoPlayableContentPopup);
  case 31:
    return (VS_BOOL)(EventArgsVar.DB365.VS_UINT32Var[0] == Media_MediaPlayer_Pop_Up_Pfo_NoPlayableContentPopup);
  case 32:
    return (VS_BOOL)(EventArgsVar.DB368.VS_UINT32Var[0] == Media_MediaPlayer_Pop_Up_Pfo_MediaDB_Download_Error);
  case 33:
    return (VS_BOOL)(EventArgsVar.DB368.VS_UINT32Var[0] == Media_MediaPlayer_Pop_Up_Pfo_SignalRangeError);
  case 34:
    return (VS_BOOL)(EventArgsVar.DB365.VS_UINT32Var[0] == Media_MediaPlayer_Pop_Up_Pfo_SignalRangeError);
  case 35:
    return (VS_BOOL)((g_SM_ActiveMediaSource == Enum_FI_EN_E8DTY_USB || g_SM_ActiveMediaSource == Enum_FI_EN_E8DTY_MTP) && g_SM_MediaFileType == SM_MEDIA_AUDIO_FILE);
  case 36:
    return (VS_BOOL)(g_SM_ActiveMediaSource == Enum_FI_EN_E8DTY_USB_CAMERAPORT_HDMI);
  case 37:
    return (VS_BOOL)(g_SM_ActiveMediaSource == Enum_FI_EN_E8DTY_USB_CAMERAPORT_HDMI_2);
  case 38:
    return (VS_BOOL)(g_SM_ActiveMediaSource == Enum_FI_EN_E8DTY_USB_CAMERAPORT_HDMI_3);
  case 39:
    return (VS_BOOL)(g_SM_ActiveMediaSource == Enum_FI_EN_E8DTY_USB_CAMERAPORT);
  case 40:
    return (VS_BOOL)(g_SM_ActiveMediaSource == Enum_FI_EN_E8DTY_IPOD && (g_SM_MediaFileType == SM_MEDIA_AUDIO_FILE || g_SM_MediaFileType == SM_MEDIA_VIDEO_FILE));
  case 41:
    return (VS_BOOL)(g_SM_ActiveMediaSource == Enum_FI_EN_E8DTY_AUX && g_SM_VARIANT_AUX == 1);
  case 42:
    return (VS_BOOL)(g_SM_MediaFileType == SM_MEDIA_VIDEO_FILE && (g_SM_ActiveMediaSource == Enum_FI_EN_E8DTY_SD || g_SM_ActiveMediaSource == Enum_FI_EN_E8DTY_USB) && SM_VARIANT_TYPE_VIDEO == 1 && g_SM_ActiveRegion == Enum_REGION_COCKPIT);
  case 43:
    return (VS_BOOL)(g_SM_MediaFileType == SM_MEDIA_VIDEO_FILE && (g_SM_ActiveMediaSource == Enum_FI_EN_E8DTY_SD || g_SM_ActiveMediaSource == Enum_FI_EN_E8DTY_USB) && SM_VARIANT_TYPE_VIDEO == 1 && g_SM_ActiveRegion == Enum_REGION_CABIN_A);
  case 44:
    return (VS_BOOL)(g_SM_ActiveMediaSource == Enum_FI_EN_E8DTY_IPHONE && (g_SM_MediaFileType == SM_MEDIA_AUDIO_FILE || g_SM_MediaFileType == SM_MEDIA_VIDEO_FILE));
  case 45:
    return (VS_BOOL)(g_SM_ActiveMediaSource == Enum_FI_EN_E8DTY_SD && g_SM_MediaFileType == SM_MEDIA_AUDIO_FILE);
  case 46:
    return (VS_BOOL)(g_SM_ActiveMediaSource == Enum_FI_EN_E8DTY_UNKNOWN && g_SM_PrepareDeactivate == 0);
  case 47:
    return (VS_BOOL)(g_SM_ActiveMediaSource == Enum_FI_EN_E8DTY_ROUTER_USB);
  case 48:
    return (VS_BOOL)(g_SM_ActiveMediaActivityID == SM_MEDIA_ACTIVITYID_SOURCE_SELECTION);
  case 49:
    return (VS_BOOL)(g_SM_BTDeviceStatus == 0);
  case 50:
    return (VS_BOOL)(g_SM_BTDeviceStatus == 1);
  case 51:
    return (VS_BOOL)(g_SM_ListType == SM_MEDIA_LISTTYPE_INVALID);
  case 52:
    return (VS_BOOL)(g_SM_VideoreRestriction == 1);
  }
  return (VS_BOOL)(g_SM_ActiveMediaSource != Enum_FI_EN_E8DTY_USB_CAMERAPORT);
}


/*
 * Action Expressions Wrapper Function.
 */
VS_VOID AppHmi_MediaStateMachine::VSAction (SEM_ACTION_EXPRESSION_TYPE i)
{
  switch (i)
  {
  case 0:
    Activate_ButtonMainSrcActivate();
    break;
  case 1:
    Activate_LayerSoundSettingsMsg();
    break;
  case 2:
    Activate_Suz_BTPhoneApplication();
    break;
  case 3:
    Activate_Suz_MirrorLinkApplication();
    break;
  case 4:
    Activate_Suz_NaviApplication();
    break;
  case 7:
    Activate_Suz_TunerApplication();
    break;
  case 8:
    Activate_Suz_TunerNowPlaying();
    break;
  case 9:
    BTBrowseButtonPressed();
    break;
  case 10:
    BrowseButtonPressed();
    break;
  case 13:
    ExternalMediaAllButtonPressUpd();
    break;
  case 14:
    ExternalMediaBackButtonPressUpd();
    break;
  case 15:
    ExternalMediaTabListPageDown();
    break;
  case 16:
    ExternalMediaTabListPageUp();
    break;
  case 17:
    ExternaldvdVideoConnectRequest();
    break;
  case 18:
    ExternaldvdVideodisconnectRequest();
    break;
  case 19:
    HorTabListBtnPageDown();
    break;
  case 20:
    HorTabListBtnPageUp();
    break;
  case 22:
    Notify_Init_Finished();
    break;
  case 25:
    Perform_Activate_Home_Source();
    break;
  case 31:
    Perform_MediaMessage_Popup();
    break;
  case 32:
    Perform_MediaModule_AUX();
    break;
  case 33:
    Perform_MediaModule_BLUETOOTH();
    break;
  case 34:
    Perform_MediaModule_CAMERAPORTHDMI();
    break;
  case 35:
    Perform_MediaModule_CAMERAPORTUSB();
    break;
  case 36:
    Perform_MediaModule_IPOD();
    break;
  case 38:
    Perform_MediaModule_SD();
    break;
  case 39:
    Perform_MediaModule_USB();
    break;
  case 41:
    Perform_MediaModule_USB2();
    break;
  case 42:
    Perform_MediaTabGadget();
    break;
  case 43:
    Perform_MediaToggle();
    break;
  case 45:
    Perform_VideoOnEXTDVDParkingBreakRequestMsg();
    break;
  case 46:
    Perform_VideoOnEXTDVDSpeedRequestMsg();
    break;
  case 47:
    Perform_VideoOnParkingBreakRequestMsg();
    break;
  case 48:
    Perform_VideoOnSpeedRequestMsg();
    break;
  case 49:
    Perform_Video_Timer_Start();
    break;
  case 50:
    Perform_Video_Timer_Stop();
    break;
  case 55:
    RequestPlayBackActionSeek();
    break;
  case 60:
    StartVideoStreaming();
    break;
  case 65:
    StopVideoStreaming();
    break;
  case 67:
    VideoBrowseButtonPressed();
    break;
  case 68:
    VideoDisconnectOnSongRequest();
    break;
  case 69:
    VideoOnsongRequest();
    break;
  case 71:
    acPerform_MediaSettingBackBtnPress();
    break;
  case 85:
    gacWaitAnimationStartReq();
    break;
  case 86:
    gacWaitAnimationStopReq();
    break;
  case 87:
    g_SM_RequestedView = 0;
    break;
  case 88:
    g_SM_Activity_SourceSel = 0;
    break;
  case 89:
    g_SM_IsSourceCheckState = 0;
    break;
  case 90:
    g_SM_RequestedView = Media_MediaPlayerScenes_M_SourceSelection_Media;
    break;
  case 91:
    g_SM_CurrentView = Media_MediaPlayerScenes_M_SourceSelection_Media;
    break;
  case 92:
    g_SM_IsSourceCheckState = 1;
    break;
  case 93:
    g_SM_RequestedView = Media_MediaPlayerScenes_M_AppleDevice;
    break;
  case 94:
    g_SM_DevConnTypeChanged = 0;
    break;
  case 95:
    g_SM_CurrentView = Media_MediaPlayerScenes_M_AppleDevice;
    break;
  case 96:
    g_SM_CurrentView = Media_MediaPlayerScenes_M_IPOD_BT;
    break;
  case 97:
    g_SM_RequestedView = Media_MediaPlayerScenes_M_IPOD_BT;
    break;
  case 98:
    g_SM_RequestedView = Media_MediaPlayerScenes_M_OPT;
    break;
  case 99:
    g_SM_RequestedView = Media_MediaPlayerScenes_M_BT;
    break;
  case 100:
    g_SM_CurrentView = Media_MediaPlayerScenes_M_BT;
    break;
  case 101:
    g_SM_RequestedView = Media_MediaPlayerScenes_M_AUX;
    break;
  case 102:
    g_SM_CurrentView = Media_MediaPlayerScenes_M_AUX;
    break;
  case 103:
    g_SM_RequestedView = Media_MediaPlayerScenes_M_USB;
    break;
  case 104:
    g_SM_CurrentView = Media_MediaPlayerScenes_M_USB;
    break;
  case 105:
    g_SM_RequestedView = Media_MediaPlayerScenes_M_VideoPlayer;
    break;
  case 106:
    g_SM_CurrentView = Media_MediaPlayerScenes_M_VideoPlayer;
    break;
  case 107:
    SMInternal_MediaActivityID = EventArgsVar.DB352.VS_UINT32Var[0];
    break;
  case 108:
    g_SM_PfoMessage_PopUpActive = 1;
    break;
  case 109:
    g_SM_PfoMessage_PopUpActive = 0;
    break;
  case 110:
    g_SM_CurrentView = Media_MediaPlayerScenes_M_SD;
    break;
  case 111:
    g_SM_RequestedView = Media_MediaPlayerScenes_M_SD;
    break;
  case 112:
    g_SM_RequestedView = Media_MediaPlayerScenes_M_VideoPlayer_FullScreen;
    break;
  case 113:
    g_SM_CurrentView = Media_MediaPlayerScenes_M_VideoPlayer_FullScreen;
    break;
  case 114:
    g_SM_CurrentView = Media_MediaPlayerScenes_M_ExternalDVD;
    break;
  case 115:
    g_SM_RequestedView = Media_MediaPlayerScenes_M_ExternalDVD;
    break;
  case 116:
    g_SM_CurrentView = Media_MediaPlayerScenes_M_ExternalDVD_FullScreen;
    break;
  case 117:
    g_SM_RequestedView = Media_MediaPlayerScenes_M_ExternalDVD_FullScreen;
    break;
  case 118:
    g_SM_CurrentView = Media_MediaPlayerScenes_M_USBCAMERAPORT;
    break;
  case 119:
    g_SM_RequestedView = Media_MediaPlayerScenes_M_USBCAMERAPORT;
    break;
  case 120:
    g_SM_CurrentView = Media_MediaPlayerScenes_M_USBROUTER;
    break;
  case 121:
    g_SM_RequestedView = Media_MediaPlayerScenes_M_USBROUTER;
    break;
  case 122:
    g_SM_CurrentView = Media_MediaPlayerScenes_M_Album;
    break;
  case 123:
    g_SM_CurrentView = Media_MediaPlayerScenes_M_Album_External;
    break;
  case 124:
    g_SM_RequestedView = Media_MediaPlayerScenes_M_CAMPORTHDMI_1;
    break;
  case 125:
    g_SM_RequestedView = Media_MediaPlayerScenes_M_CAMPORTHDMI_2;
    break;
  case 126:
    g_SM_RequestedView = Media_MediaPlayerScenes_M_CAMPORTHDMI_3;
    break;
  case 127:
    g_SM_ActiveUSBCameraPort = 0;
    break;
  case 128:
    gacViewHideReq(Media_Gadget_Media_MASTER__GADGET_MEDIA);
    break;
  case 129:
    gacViewDestroyReq(Media_Gadget_Media_MASTER__GADGET_MEDIA);
    break;
  case 130:
    gacViewHideAndDestroyReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaMessage);
    break;
  case 131:
    gacViewHideAndDestroyReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaUnsupportedPopupMessage);
    break;
  case 132:
    gacViewHideAndDestroyReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaUnsupportedPopupMessageHUB);
    break;
  case 133:
    gacViewHideAndDestroyReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaDB_Download_Successful);
    break;
  case 134:
    gacViewHideAndDestroyReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaDB_Download_Failure);
    break;
  case 135:
    gacViewHideAndDestroyReq(Media_MediaPlayer_Pop_Up_Pfo_MediaConfirmBTPairing);
    break;
  case 136:
    gacViewHideAndDestroyReq(Media_MediaPlayer_Pop_Up_Pfo_VideoDisableMessage);
    break;
  case 137:
    gacViewHideAndDestroyReq(Media_MediaPlayer_Pop_Up_Pfo_WMA_DRM_ProtectedFileMessage);
    break;
  case 138:
    gacViewHideAndDestroyReq(Media_MediaPlayer_Pop_Up_Pfo_WaitScene);
    break;
  case 139:
    gacViewHideAndDestroyReq(Media_MediaPlayer_Pop_Up_Pfo_MediaBTStreamingUnavailable);
    break;
  case 140:
    gacViewHideAndDestroyReq(Media_MediaPlayer_Pop_Up_Pfo_MediaGlassUnavailableMessage);
    break;
  case 141:
    gacViewHideAndDestroyReq(Media_MediaPlayer_Pop_Up_Pfo_NoPlayableContentPopup);
    break;
  case 142:
    gacViewHideAndDestroyReq(Media_MediaPlayer_Pop_Up_Pfo_MediaDB_Download_Error);
    break;
  case 143:
    gacViewHideAndDestroyReq(Media_MediaPlayer_Pop_Up_Pfo_SignalRangeError);
    break;
  case 144:
    gacPopupCreateAndSBShowReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaMessage);
    break;
  case 145:
    gacPopupCreateAndSBShowReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaDB_Download_Successful);
    break;
  case 146:
    gacPopupSBCloseReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaDB_Download_Successful);
    break;
  case 147:
    gacPopupSBCloseReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaMessage);
    break;
  case 148:
    gacPopupCreateAndSBShowReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaUnsupportedPopupMessage);
    break;
  case 149:
    gacPopupSBCloseReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaUnsupportedPopupMessage);
    break;
  case 150:
    gacPopupCreateAndSBShowReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaUnsupportedPopupMessageHUB);
    break;
  case 151:
    gacPopupSBCloseReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaUnsupportedPopupMessageHUB);
    break;
  case 152:
    gacPopupCreateAndSBShowReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaDB_Download_Failure);
    break;
  case 153:
    gacPopupSBCloseReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaDB_Download_Failure);
    break;
  case 154:
    gacViewHideReq(Media_MediaPlayerScenes_M_OPT);
    break;
  case 155:
    gacViewDestroyReq(Media_MediaPlayerScenes_M_OPT);
    break;
  case 156:
    gacViewHideReq(Media_MediaPlayerScenes_M_SourceSelection_Media);
    break;
  case 157:
    gacViewDestroyReq(Media_MediaPlayerScenes_M_SourceSelection_Media);
    break;
  case 158:
    gacViewHideReq(Media_MediaPlayerScenes_M_USB);
    break;
  case 159:
    gacViewDestroyReq(Media_MediaPlayerScenes_M_USB);
    break;
  case 160:
    gacViewHideReq(Media_MediaPlayerScenes_M_AppleDevice);
    break;
  case 161:
    gacViewDestroyReq(Media_MediaPlayerScenes_M_AppleDevice);
    break;
  case 162:
    gacViewHideReq(Media_MediaPlayerScenes_M_SD);
    break;
  case 163:
    gacViewDestroyReq(Media_MediaPlayerScenes_M_SD);
    break;
  case 164:
    gacViewHideReq(Media_MediaPlayerScenes_M_BT);
    break;
  case 165:
    gacViewDestroyReq(Media_MediaPlayerScenes_M_BT);
    break;
  case 166:
    gacViewHideReq(Media_MediaPlayerScenes_M_AUX);
    break;
  case 167:
    gacViewDestroyReq(Media_MediaPlayerScenes_M_AUX);
    break;
  case 168:
    gacViewHideReq(Media_MediaPlayerScenes_M_VideoPlayer);
    break;
  case 169:
    gacViewDestroyReq(Media_MediaPlayerScenes_M_VideoPlayer);
    break;
  case 170:
    gacViewHideReq(Media_MediaPlayerScenes_M_VideoPlayer_FullScreen);
    break;
  case 171:
    gacViewDestroyReq(Media_MediaPlayerScenes_M_VideoPlayer_FullScreen);
    break;
  case 172:
    gacViewHideReq(Media_MediaPlayerScenes_M_IPOD_BT);
    break;
  case 173:
    gacViewDestroyReq(Media_MediaPlayerScenes_M_IPOD_BT);
    break;
  case 174:
    gacViewHideReq(Media_MediaPlayerScenes_M_ExternalDVD);
    break;
  case 175:
    gacViewDestroyReq(Media_MediaPlayerScenes_M_ExternalDVD);
    break;
  case 176:
    gacViewHideReq(Media_MediaPlayerScenes_M_ExternalDVD_FullScreen);
    break;
  case 177:
    gacViewDestroyReq(Media_MediaPlayerScenes_M_ExternalDVD_FullScreen);
    break;
  case 178:
    gacViewHideReq(Media_MediaPlayerScenes_M_CAMPORTHDMI_1);
    break;
  case 179:
    gacViewDestroyReq(Media_MediaPlayerScenes_M_CAMPORTHDMI_1);
    break;
  case 180:
    gacViewHideAndDestroyReq(Media_MediaPlayerScenes_M_USBCAMERAPORT);
    break;
  case 181:
    gacViewHideAndDestroyReq(Media_MediaPlayerScenes_M_USBROUTER);
    break;
  case 182:
    gacViewHideReq(Media_MediaPlayerScenes_M_CAMPORTHDMI_2);
    break;
  case 183:
    gacViewDestroyReq(Media_MediaPlayerScenes_M_CAMPORTHDMI_2);
    break;
  case 184:
    gacViewHideReq(Media_MediaPlayerScenes_M_CAMPORTHDMI_3);
    break;
  case 185:
    gacViewDestroyReq(Media_MediaPlayerScenes_M_CAMPORTHDMI_3);
    break;
  case 186:
    gacViewHideReq(Media_MediaPlayerScenes_M_Album);
    break;
  case 187:
    gacViewDestroyReq(Media_MediaPlayerScenes_M_Album);
    break;
  case 188:
    gacViewHideReq(Media_MediaPlayerScenes_M_Album_External);
    break;
  case 189:
    gacViewDestroyReq(Media_MediaPlayerScenes_M_Album_External);
    break;
  case 190:
    gacPopupSBCloseReq(Media_MediaPlayer_Pop_Up_Pfo_WaitScene);
    break;
  case 191:
    BrowseListActive(0);
    break;
  case 192:
    Perform_MediaSceneMsg(12);
    break;
  case 193:
    gacViewCreateReq(Media_MediaPlayerScenes_M_SourceSelection_Media);
    break;
  case 194:
    gacViewShowReq(Media_MediaPlayerScenes_M_SourceSelection_Media);
    break;
  case 195:
    acPerform_UpdateCurrentMediaState(Enum_MEDIA_STATE_SOURCESELECTION);
    break;
  case 196:
    gacViewCreateReq(Media_MediaPlayerScenes_M_AppleDevice);
    break;
  case 197:
    gacViewShowReq(Media_MediaPlayerScenes_M_AppleDevice);
    break;
  case 198:
    acPerform_UpdateCurrentMediaState(Enum_MEDIA_STATE_NOWPLAYING);
    break;
  case 199:
    gacViewCreateReq(Media_MediaPlayerScenes_M_IPOD_BT);
    break;
  case 200:
    gacViewShowReq(Media_MediaPlayerScenes_M_IPOD_BT);
    break;
  case 201:
    Perform_MediaSceneMsg(SM_MEDIA_OPT_SETTINGS);
    break;
  case 202:
    gacViewCreateReq(Media_MediaPlayerScenes_M_OPT);
    break;
  case 203:
    gacViewShowReq(Media_MediaPlayerScenes_M_OPT);
    break;
  case 204:
    acPerform_UpdateCurrentMediaState(Enum_MEDIA_STATE_SETTINGS);
    break;
  case 205:
    gacViewCreateReq(Media_MediaPlayerScenes_M_BT);
    break;
  case 206:
    gacViewShowReq(Media_MediaPlayerScenes_M_BT);
    break;
  case 207:
    gacViewCreateReq(Media_MediaPlayerScenes_M_AUX);
    break;
  case 208:
    gacViewShowReq(Media_MediaPlayerScenes_M_AUX);
    break;
  case 209:
    gacViewCreateReq(Media_MediaPlayerScenes_M_USB);
    break;
  case 210:
    gacViewShowReq(Media_MediaPlayerScenes_M_USB);
    break;
  case 211:
    gacViewCreateReq(Media_MediaPlayerScenes_M_VideoPlayer);
    break;
  case 212:
    gacViewShowReq(Media_MediaPlayerScenes_M_VideoPlayer);
    break;
  case 213:
    acPerform_AppleHIDCommandMsg(Enum_HID_SCAN_NEXT_TRACK, Enum_KEY_RELEASE);
    break;
  case 214:
    acPerform_AppleHIDCommandMsg(Enum_HID_SCAN_PREV_TRACK, Enum_KEY_RELEASE);
    break;
  case 215:
    acPerform_AppleHIDCommandMsg(Enum_HID_PLAY, Enum_KEY_RELEASE);
    break;
  case 216:
    acPerform_AppleHIDCommandMsg(Enum_HID_REPEAT, Enum_KEY_RELEASE);
    break;
  case 217:
    acPerform_AppleHIDCommandMsg(Enum_HID_RANDOM, Enum_KEY_RELEASE);
    break;
  case 218:
    MediaBTOperation(SM_MEDIA_FFWD_STOP);
    break;
  case 219:
    MediaBTOperation(SM_MEDIA_FRWD_STOP);
    break;
  case 220:
    MediaOperation(SM_MEDIA_FFWD_STOP);
    break;
  case 221:
    MediaOperation(SM_MEDIA_FRWD_STOP);
    break;
  case 222:
    MediaOperation(SM_MEDIA_NEXT);
    break;
  case 223:
    acPerform_AppleHIDCommandMsg(Enum_HID_SCAN_PREV_TRACK, Enum_KEY_PRESS);
    break;
  case 224:
    acPerform_AppleHIDCommandMsg(Enum_HID_SCAN_NEXT_TRACK, Enum_KEY_PRESS);
    break;
  case 225:
    acPerform_AppleHIDCommandMsg(Enum_HID_PLAY, Enum_KEY_PRESS);
    break;
  case 226:
    MediaOperation(SM_MEDIA_FFWD);
    break;
  case 227:
    MediaOperation(SM_MEDIA_PREVIOUS);
    break;
  case 228:
    MediaOperation(SM_MEDIA_FRWD);
    break;
  case 229:
    MediaOperation(SM_MEDIA_PLAY);
    break;
  case 230:
    gacViewCreateReq(Media_Gadget_Media_MASTER__GADGET_MEDIA);
    break;
  case 231:
    gacViewShowReq(Media_Gadget_Media_MASTER__GADGET_MEDIA);
    break;
  case 232:
    gacViewCreateReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaMessage);
    break;
  case 233:
    gacViewShowReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaMessage);
    break;
  case 234:
    acStartAppPopupTimer(Media_MediaPlayer_Pop_Up_system_Pfo_MediaMessage, 3000);
    break;
  case 235:
    gacViewHideReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaMessage);
    break;
  case 236:
    gacViewClearReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaMessage);
    break;
  case 237:
    gacViewCreateReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaUnsupportedPopupMessage);
    break;
  case 238:
    gacViewShowReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaUnsupportedPopupMessage);
    break;
  case 239:
    gacViewHideReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaUnsupportedPopupMessage);
    break;
  case 240:
    gacViewClearReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaUnsupportedPopupMessage);
    break;
  case 241:
    gacViewCreateReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaUnsupportedPopupMessageHUB);
    break;
  case 242:
    gacViewShowReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaUnsupportedPopupMessageHUB);
    break;
  case 243:
    gacViewHideReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaUnsupportedPopupMessageHUB);
    break;
  case 244:
    gacViewClearReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaUnsupportedPopupMessageHUB);
    break;
  case 245:
    gacViewCreateReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaDB_Download_Successful);
    break;
  case 246:
    gacViewShowReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaDB_Download_Successful);
    break;
  case 247:
    gacViewHideReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaDB_Download_Successful);
    break;
  case 248:
    gacViewClearReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaDB_Download_Successful);
    break;
  case 249:
    gacViewCreateReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaDB_Download_Failure);
    break;
  case 250:
    gacViewShowReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaDB_Download_Failure);
    break;
  case 251:
    gacViewHideReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaDB_Download_Failure);
    break;
  case 252:
    gacViewClearReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaDB_Download_Failure);
    break;
  case 253:
    gacViewHideReq(Media_MediaPlayer_Pop_Up_Pfo_MediaConfirmBTPairing);
    break;
  case 254:
    gacViewClearReq(Media_MediaPlayer_Pop_Up_Pfo_MediaConfirmBTPairing);
    break;
  case 255:
    gacViewHideReq(Media_MediaPlayer_Pop_Up_Pfo_VideoDisableMessage);
    break;
  case 256:
    gacViewClearReq(Media_MediaPlayer_Pop_Up_Pfo_VideoDisableMessage);
    break;
  case 257:
    gacViewHideReq(Media_MediaPlayer_Pop_Up_Pfo_WaitScene);
    break;
  case 258:
    gacViewClearReq(Media_MediaPlayer_Pop_Up_Pfo_WaitScene);
    break;
  case 259:
    gacViewHideReq(Media_MediaPlayer_Pop_Up_Pfo_MediaBTStreamingUnavailable);
    break;
  case 260:
    gacViewClearReq(Media_MediaPlayer_Pop_Up_Pfo_MediaBTStreamingUnavailable);
    break;
  case 261:
    gacViewHideReq(Media_MediaPlayer_Pop_Up_Pfo_MediaGlassUnavailableMessage);
    break;
  case 262:
    gacViewClearReq(Media_MediaPlayer_Pop_Up_Pfo_MediaGlassUnavailableMessage);
    break;
  case 263:
    gacViewHideReq(Media_MediaPlayer_Pop_Up_Pfo_NoPlayableContentPopup);
    break;
  case 264:
    gacViewClearReq(Media_MediaPlayer_Pop_Up_Pfo_NoPlayableContentPopup);
    break;
  case 265:
    gacViewHideReq(Media_MediaPlayer_Pop_Up_Pfo_MediaDB_Download_Error);
    break;
  case 266:
    gacViewClearReq(Media_MediaPlayer_Pop_Up_Pfo_MediaDB_Download_Error);
    break;
  case 267:
    gacViewHideReq(Media_MediaPlayer_Pop_Up_Pfo_SignalRangeError);
    break;
  case 268:
    gacViewClearReq(Media_MediaPlayer_Pop_Up_Pfo_SignalRangeError);
    break;
  case 269:
    gacPopupCreateAndSBShowReq(Media_MediaPlayer_Pop_Up_Pfo_VideoDisableMessage);
    break;
  case 270:
    gacPopupSBCloseReq(Media_MediaPlayer_Pop_Up_Pfo_VideoDisableMessage);
    break;
  case 271:
    gacPopupCreateAndSBShowReq(Media_MediaPlayer_Pop_Up_Pfo_WMA_DRM_ProtectedFileMessage);
    break;
  case 272:
    gacPopupSBCloseReq(Media_MediaPlayer_Pop_Up_Pfo_WMA_DRM_ProtectedFileMessage);
    break;
  case 273:
    gacPopupCreateAndSBShowReq(Media_MediaPlayer_Pop_Up_Pfo_MediaGlassUnavailableMessage);
    break;
  case 274:
    gacPopupCreateAndSBShowReq(Media_MediaPlayer_Pop_Up_Pfo_NoPlayableContentPopup);
    break;
  case 275:
    gacPopupSBCloseReq(Media_MediaPlayer_Pop_Up_Pfo_NoPlayableContentPopup);
    break;
  case 276:
    gacPopupCreateAndSBShowReq(Media_MediaPlayer_Pop_Up_Pfo_SignalRangeError);
    break;
  case 277:
    gacPopupCreateAndSBShowReq(Media_MediaPlayer_Pop_Up_Pfo_MediaConfirmBTPairing);
    break;
  case 278:
    gacPopupSBCloseReq(Media_MediaPlayer_Pop_Up_Pfo_MediaConfirmBTPairing);
    break;
  case 279:
    gacViewCreateReq(Media_MediaPlayer_Pop_Up_Pfo_MediaConfirmBTPairing);
    break;
  case 280:
    gacViewShowReq(Media_MediaPlayer_Pop_Up_Pfo_MediaConfirmBTPairing);
    break;
  case 281:
    gacViewCreateReq(Media_MediaPlayer_Pop_Up_Pfo_VideoDisableMessage);
    break;
  case 282:
    gacViewShowReq(Media_MediaPlayer_Pop_Up_Pfo_VideoDisableMessage);
    break;
  case 283:
    gacViewShowReq(Media_MediaPlayer_Pop_Up_Pfo_WMA_DRM_ProtectedFileMessage);
    break;
  case 284:
    gacViewCreateReq(Media_MediaPlayer_Pop_Up_Pfo_WMA_DRM_ProtectedFileMessage);
    break;
  case 285:
    gacViewCreateReq(Media_MediaPlayer_Pop_Up_Pfo_WaitScene);
    break;
  case 286:
    gacViewShowReq(Media_MediaPlayer_Pop_Up_Pfo_WaitScene);
    break;
  case 287:
    gacViewCreateReq(Media_MediaPlayer_Pop_Up_Pfo_MediaBTStreamingUnavailable);
    break;
  case 288:
    gacViewShowReq(Media_MediaPlayer_Pop_Up_Pfo_MediaBTStreamingUnavailable);
    break;
  case 289:
    gacViewCreateReq(Media_MediaPlayer_Pop_Up_Pfo_MediaGlassUnavailableMessage);
    break;
  case 290:
    gacViewShowReq(Media_MediaPlayer_Pop_Up_Pfo_MediaGlassUnavailableMessage);
    break;
  case 291:
    gacViewCreateReq(Media_MediaPlayer_Pop_Up_Pfo_NoPlayableContentPopup);
    break;
  case 292:
    gacViewShowReq(Media_MediaPlayer_Pop_Up_Pfo_NoPlayableContentPopup);
    break;
  case 293:
    acStartAppPopupTimer(Media_MediaPlayer_Pop_Up_Pfo_NoPlayableContentPopup, 5000);
    break;
  case 294:
    gacViewCreateReq(Media_MediaPlayer_Pop_Up_Pfo_MediaDB_Download_Error);
    break;
  case 295:
    gacViewShowReq(Media_MediaPlayer_Pop_Up_Pfo_MediaDB_Download_Error);
    break;
  case 296:
    gacViewCreateReq(Media_MediaPlayer_Pop_Up_Pfo_SignalRangeError);
    break;
  case 297:
    gacViewShowReq(Media_MediaPlayer_Pop_Up_Pfo_SignalRangeError);
    break;
  case 298:
    acStartAppPopupTimer(Media_MediaPlayer_Pop_Up_Pfo_SignalRangeError, 5000);
    break;
  case 299:
    gacPopupSBCloseReq(Media_MediaPlayer_Pop_Up_Pfo_SignalRangeError);
    break;
  case 300:
    gacViewCreateReq(Media_MediaPlayerScenes_M_SD);
    break;
  case 301:
    gacViewShowReq(Media_MediaPlayerScenes_M_SD);
    break;
  case 302:
    Perform_MediaSceneMsg(SM_MEDIA_VIDEO_FULLSCREEN);
    break;
  case 303:
    gacViewCreateReq(Media_MediaPlayerScenes_M_VideoPlayer_FullScreen);
    break;
  case 304:
    gacViewShowReq(Media_MediaPlayerScenes_M_VideoPlayer_FullScreen);
    break;
  case 305:
    gacViewCreateReq(Media_MediaPlayerScenes_M_ExternalDVD);
    break;
  case 306:
    gacViewShowReq(Media_MediaPlayerScenes_M_ExternalDVD);
    break;
  case 307:
    gacViewCreateReq(Media_MediaPlayerScenes_M_ExternalDVD_FullScreen);
    break;
  case 308:
    gacViewShowReq(Media_MediaPlayerScenes_M_ExternalDVD_FullScreen);
    break;
  case 309:
    gacViewCreateReq(Media_MediaPlayerScenes_M_CAMPORTHDMI_1);
    break;
  case 310:
    gacViewShowReq(Media_MediaPlayerScenes_M_CAMPORTHDMI_1);
    break;
  case 311:
    gacViewCreateAndShowReq(Media_MediaPlayerScenes_M_USBCAMERAPORT);
    break;
  case 312:
    gacViewCreateAndShowReq(Media_MediaPlayerScenes_M_USBROUTER);
    break;
  case 313:
    gacViewCreateReq(Media_MediaPlayerScenes_M_CAMPORTHDMI_2);
    break;
  case 314:
    gacViewShowReq(Media_MediaPlayerScenes_M_CAMPORTHDMI_2);
    break;
  case 315:
    gacViewCreateReq(Media_MediaPlayerScenes_M_CAMPORTHDMI_3);
    break;
  case 316:
    gacViewShowReq(Media_MediaPlayerScenes_M_CAMPORTHDMI_3);
    break;
  case 317:
    Perform_MediaSceneMsg(SM_MEDIA_LIST_BROWSE);
    break;
  case 318:
    gacViewCreateReq(Media_MediaPlayerScenes_M_Album);
    break;
  case 319:
    gacViewShowReq(Media_MediaPlayerScenes_M_Album);
    break;
  case 320:
    acPerform_UpdateCurrentMediaState(Enum_MEDIA_STATE_LIST);
    break;
  case 321:
    gacViewCreateReq(Media_MediaPlayerScenes_M_Album_External);
    break;
  case 322:
    gacViewShowReq(Media_MediaPlayerScenes_M_Album_External);
    break;
  case 323:
    MediaOperation(SM_MEDIA_REPEATOFF);
    break;
  case 324:
    MediaOperation(SM_MEDIA_SHUFFLEOFF);
    break;
  case 325:
    acPerform_AppleHIDCommandMsg(Enum_HID_REPEAT, Enum_KEY_PRESS);
    break;
  case 326:
    acPerform_AppleHIDCommandMsg(Enum_HID_RANDOM, Enum_KEY_PRESS);
    break;
  case 327:
    MediaBTOperation(SM_MEDIA_FFWD);
    break;
  case 328:
    MediaBTOperation(SM_MEDIA_NEXT);
    break;
  case 329:
    MediaBTOperation(SM_MEDIA_PLAY);
    break;
  case 330:
    MediaBTOperation(SM_MEDIA_FRWD);
    break;
  case 331:
    MediaBTOperation(SM_MEDIA_PREVIOUS);
    break;
  case 332:
    MediaBTOperation(SM_MEDIA_REPEATOFF);
    break;
  case 333:
    MediaBTOperation(SM_MEDIA_SHUFFLEOFF);
    break;
  case 334:
    HorListTabButtonItem(EventArgsVar.DB352.VS_UINT32Var[0]);
    break;
  case 335:
    gacPopupCreateAndSBShowReq(Media_MediaPlayer_Pop_Up_Pfo_WaitScene);
    break;
  case 336:
    ExternalBrowseScreenExitUpd(LIST_ID_EXTERNAL_MEDIA_VER);
    break;
  case 337:
    ExternalMediaTabBtnPressUpd(EventArgsVar.DB352.VS_UINT32Var[0]);
    break;
  case 338:
    ExternalMediaListItemPressUpd(EventArgsVar.DB352.VS_UINT32Var[0], EventArgsVar.DB352.VS_UINT32Var[1]);
    break;

  default:
    break;
  }
}
