/************************************************************************
*FILE: AppHmi_MediaStateMachine.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(AppHmi_MediaStateMachine_h)
#define AppHmi_MediaStateMachine_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Courier/Messaging/Message.h>
#include <AppHmi_MediaStateMachineSEMLibB.h>
#include <AppHmi_MediaStateMachineData.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Cit/VisualStateGlueLayer/DeductResult.h>
#ifdef CIT_SIMULATION
#include <json/value.h>
#endif
#include <AppHmi_MediaTypes.h>
#include <AppHmi_MediaMessages.h>
#include <AppHmi_MediaConstants.h>
#include <AppHmi_MediaDatabinding.h>
#include <AppHmi_MediaViews.h>
#include <AppHmi_MediaController.h>
// ------------------------------------------------------------------------
class AppHmi_MediaStateMachineImpl : public AppHmi_MediaStateMachine
{
public:
    typedef AppHmi_MediaStateMachine Base;

#ifdef VISUALSTATE_7_TRACE
    // Mapping of data types of API to get rid of include dependencies
    //typedef SEM_ACTION_EXPRESSION_TYPE VS_Type_ActionExpression;
	using Base::VS_Type_ActionExpression;
    //typedef SEM_EVENT_TYPE VS_Type_Event;
	//typedef SEM_STATE_TYPE VS_Type_State;
	//typedef SEM_EXPLANATION_TYPE VS_Type_Explanation;
	//typedef SEM_STATE_MACHINE_TYPE VS_Type_Statemachine;
	using Base::VS_Type_Event;
	using Base::VS_Type_State;
	using Base::VS_Type_Explanation;
	using Base::VS_Type_Statemachine;

    // Mapping of enums and defines of API to get rid of include dependencies
    //enum { VS_Ret_Ok = SES_OKAY };
    //enum { VS_Ret_Found = SES_FOUND };
	enum { VS_Ret_Ok = Base::VS_Ret_Ok };
	enum { VS_Ret_Found = Base::VS_Ret_Found };
    enum { VS_Evt_Reset = SE_RESET };
    enum { VS_Ret_Error = SES_RANGE_ERR };
#else
#ifndef VISUALSTATE_HCODER
    typedef SEM_ACTION_EXPRESSION_TYPE VS_Type_ActionExpression;
    typedef SEM_EVENT_TYPE VS_Type_Event;
    typedef SEM_STATE_TYPE VS_Type_State;
    typedef SEM_EXPLANATION_TYPE VS_Type_Explanation;
    typedef SEM_STATE_MACHINE_TYPE VS_Type_Statemachine;
    enum { VS_Ret_Ok = SES_OKAY };
    enum { VS_Ret_Found = SES_FOUND };
    enum { VS_Evt_Reset = SE_RESET };
    enum { VS_Ret_Error = SES_RANGE_ERR };
#else
    enum { VS_Ret_Ok = 0U };
    enum { VS_Ret_Found = 1U };
    enum { VS_Evt_Reset = 0U };
    enum { VS_Ret_Error = 4U };
#endif
#endif
// ------------------------------------------------------------------------

    // Mapping of args passed as hashId to corresponding identifier
    static const ::FeatStd::Char *GetNameFromId(::FeatStd::UInt32 id);

// ------------------------------------------------------------------------
    virtual void Perform_MediaTabGadget();
    virtual void Perform_MediaToggle();
    virtual void Perform_USBCameraPortInvisibility();
    virtual void Notify_Init_Finished();
    virtual void acPerform_UsbElapsedTimeSeekBackMsg(::FeatStd::UInt32 aSeekValue);
    virtual void OptionSelStateRespMsg();
    virtual void Activate_Suz_TunerNowPlaying();
    virtual void Activate_ButtonMainSrcActivate();
    virtual void Activate_Suz_PreviousApplication();
    virtual void Activate_Suz_NaviApplication();
    virtual void Activate_Suz_MirrorLinkApplication();
    virtual void Activate_Suz_SoundSettingsApplication();
    virtual void Activate_LayerSoundSettingsMsg();
    virtual void Perform_Activate_Home_Source();
    virtual void Activate_Suz_BTPhoneApplication();
    virtual void Activate_Suz_TunerApplication();
    virtual void Perform_MediaModule_USB2();
    virtual void Perform_MediaModule_USB1();
    virtual void Perform_MediaModule_USB();
    virtual void Perform_MediaModule_IPOD();
    virtual void Perform_MediaModule_SD();
    virtual void Perform_MediaModule_BLUETOOTH();
    virtual void Perform_MediaModule_CAMERAPORTUSB();
    virtual void Perform_MediaModule_CAMERAPORTHDMI();
    virtual void Perform_MediaModule_ROUTERUSB();
    virtual void Perform_MediaModule_AUX();
    virtual void Perform_MediaSceneMsg(::FeatStd::UInt16 aMediaType);
    virtual void MediaOperation(::FeatStd::UInt16 aOperationType);
    virtual void MediaBTOperation(::FeatStd::UInt16 aOperationType);
    virtual void ActivateAUXApp(::FeatStd::UInt8 aCheckboxStatus);
    virtual void ActivateSDCard(::FeatStd::UInt8 aCheckboxStatus);
    virtual void ActivateExternalDVD(::FeatStd::UInt8 aCheckboxStatus);
    virtual void ActivateTAApp(::FeatStd::UInt8 aCheckboxStatus);
    virtual void acPerform_AppleHIDCommandMsg(::FeatStd::UInt8 aHIDCommand, ::FeatStd::UInt8 aKeyEvent);
    virtual void HorListTabButtonItem(::FeatStd::UInt32 aSelectMediaTab);
    virtual void BTBrowseButtonPressed();
    virtual void VideoBrowseButtonPressed();
    virtual void BrowseButtonPressed();
    virtual void HorTabListBtnPageUp();
    virtual void HorTabListBtnPageDown();
    virtual void ExternalMediaTabBtnPressUpd(::FeatStd::UInt32 aSelectMediaTab);
    virtual void ExternalBrowseScreenExitUpd(::FeatStd::UInt32 aListId);
    virtual void ExternalMediaTabListPageUp();
    virtual void ExternalMediaTabListPageDown();
    virtual void ExternalMediaBackButtonPressUpd();
    virtual void ExternalMediaAllButtonPressUpd();
    virtual void ExternalMediaListItemPressUpd(::FeatStd::UInt32 aHdl, ::FeatStd::UInt32 aSubHdl);
    virtual void RequestPlayBackActionSeek();
    virtual void RequestBTPlayBackActionSeek();
    virtual void RequestNextBrowseTabs();
    virtual void RequestPreviousBrowseTabs();
    virtual void RequestBrowseList(::FeatStd::UInt8 aG_SM_ListType);
    virtual void RequestParentFolderItems();
    virtual void RequestClearFolderListData();
    virtual void RequestAudioAllocationForMode(::FeatStd::UInt8 aDeviceType);
    virtual void Perform_FastRewindStart_Popup();
    virtual void Perform_FastForwardStart_Popup();
    virtual void Perform_BTDeviceNameUpdateStatusMsg();
    virtual void BrowseListActive(::FeatStd::UInt8 aIsActive);
    virtual void Perform_VideoOnSpeedRequestMsg();
    virtual void Perform_VideoOnParkingBreakRequestMsg();
    virtual void Perform_VideoOnEXTDVDSpeedRequestMsg();
    virtual void Perform_VideoOnEXTDVDParkingBreakRequestMsg();
    virtual void StartVideoStreaming();
    virtual void StartFolderViewEntryRespMsg();
    virtual void StopFolderViewExitRespMsg();
    virtual void StartVideoViewEntryRespMsg();
    virtual void StopVideoViewExitRespMsg();
    virtual void StartSDCardViewEntryRespMsg();
    virtual void StopSDCardViewExitRespMsg();
    virtual void StartUSBViewEntryRespMsg();
    virtual void StopUSBViewExitRespMsg();
    virtual void StopVideoStreaming();
    virtual void Perform_FastRewindStop_Popup();
    virtual void Perform_FastForwardStop_Popup();
    virtual void Perform_MediaMessage_Popup();
    virtual void VideoOnsongRequest();
    virtual void Perform_Video_Timer_Start();
    virtual void Perform_Video_Timer_Stop();
    virtual void VideoDisconnectOnSongRequest();
    virtual void ExternaldvdVideoConnectRequest();
    virtual void ExternalDVDDevicenameRequest();
    virtual void ExternalAuxDevicenameRequest();
    virtual void ExternaldvdVideodisconnectRequest();
    virtual void NowplayingAlbumartViewRequest();
    virtual void acPerform_UpdateCurrentMediaState(::FeatStd::UInt8 aCurrentState);
    virtual void acPerform_MediaSettingBackBtnPress();
    virtual void gacChangeLanguageReq(::FeatStd::Int32 aLanguageId);
    virtual void gacHideFocusInViewReq(::FeatStd::UInt32 aView);
    virtual void NextLevelTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void PreviousLevelTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void DualViewLeftTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void DualViewRightTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void PageFlipBackTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void PageFlipFrontTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void ZoomInTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView, ::FeatStd::Int8 aPos);
    virtual void ZoomOutTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView, ::FeatStd::Int8 aPos);
    virtual void FadeTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void gacWaitAnimationStartReq();
    virtual void acFocusOnRightEncoderReqUpd(bool aIsFocusUsed);
    virtual void acSetGadgetSceenActiveStatus(bool aIsGadgetAtive);
    virtual void acHKNotificationMsg(::FeatStd::Int8 aHKCode, ::FeatStd::Int8 aHKState);
    virtual void acPerform_CloseAllDropdowns();
    virtual void acPerform_CloseDropdown(::FeatStd::UInt32 aListId);
    virtual void acPerform_OpenDropdown(::FeatStd::UInt32 aListId);
    virtual void acPerform_ToggleDropdown(::FeatStd::UInt32 aListId);
    virtual void acStartAppPopupTimer(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aTimeout);
    virtual void acStopAppPopupTimer(::FeatStd::UInt32 aViewId);
    virtual void acPostBeep(::FeatStd::Int8 aBeepType);
    virtual void gacCheckToClosePopup(::FeatStd::UInt32 aPopupId);
    virtual void acRestartAppPopupTimer(::FeatStd::UInt32 aViewId);
    virtual void gacContextSwitchBackRes(::FeatStd::UInt32 aSwitchId);
    virtual void gacContextSwitchCompleteRes(::FeatStd::UInt32 aSwitchId);
    virtual void gacContextSwitchFailedRes(::FeatStd::UInt32 aSwitchId);
    virtual void gacContextSwitchDoneRes(::FeatStd::UInt32 aSwitchId);
    virtual void gacContextSwitchOutReq(::FeatStd::UInt32 aTargetContextId, ::FeatStd::UInt32 aSourceContextId, ::FeatStd::UInt32 aTargetAppId);
    virtual void gacCurrentScreenDisplayReq();
    virtual void gacLaunchBarDisplayReq(bool aVisibility);
    virtual void gacNavTBTSwipe();
    virtual void gacPerformListBtnRightEncoderChangeUpd(::FeatStd::Int8 aSteps, ::FeatStd::UInt32 aListId, ::FeatStd::UInt32 aRowId, ::FeatStd::UInt32 aColumnId);
    virtual void gacScrollListUp();
    virtual void gacScrollListDown();
    virtual void gacScrollPageUp();
    virtual void gacScrollPageDown();
    virtual void gacScrollListFocusUp(::FeatStd::UInt32 aListId);
    virtual void gacScrollListFocusDown(::FeatStd::UInt32 aListId);
    virtual void gacPerformListFocusLockDataResetUpd();
    virtual void gacSetApplicationMode(::FeatStd::UInt32 aModeId);
    virtual void gacSpellerBbehaviorReq(bool aEnable);
    virtual void gacStatusBarDisplayReq(bool aVisibility, ::FeatStd::Int32 aHeaderType);
    virtual void gacTBTRetriggerAcousticOutput();
    virtual void gacWaitAnimationStopReq();
    virtual void gacViewCreateReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewCreateAllReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewDestroyReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewClearReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewShowReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewHideReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewCreateWithoutLoadReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewAsyncLoadReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewActivateWithoutRenderingReq(::FeatStd::UInt32 aViewId);
    virtual void gacPopupCreateAndSBShowReq(::FeatStd::UInt32 aViewId);
    virtual void gacPopupCreateAndSBShowReqForMultiDisplay(::FeatStd::UInt32 aPopupDisplayID, ::FeatStd::UInt32 aViewId);
    virtual void gacPopupSBCloseReq(::FeatStd::UInt32 aViewId);
    virtual void gacPopupSBCloseReqForMultiDisplay(::FeatStd::UInt32 aPopupDisplayID, ::FeatStd::UInt32 aViewId);
    virtual void gacPopupRestartTimerReq(::FeatStd::UInt32 aViewId);
    virtual void gacPopupRestartTimerReqForMultiDisplay(::FeatStd::UInt32 aPopupDisplayID, ::FeatStd::UInt32 aViewId);
    virtual void gacViewCreateAndShowReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewHideAndDestroyReq(::FeatStd::UInt32 aViewId);
    virtual void gacSceneTransitionEnter(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aHint);
    virtual void gacSceneTransitionLeave(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aHint);
    virtual void gacDisplayStatusLineReq(::FeatStd::Int32 aDisplayRegionType);
    virtual void gacHideStatusLineReq(::FeatStd::Int32 aDisplayRegionType);
    virtual void gacDisplayFooterLineReq();
    virtual void gacHideFooterLineReq();
    virtual void gacDisplayStatusLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID);
    virtual void gacHideStatusLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID);
    virtual void gacDisplayFooterLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID);
    virtual void gacHideFooterLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID);
    virtual void gacRegisterForCloseOnTouchSession(::FeatStd::UInt32 aViewId);
    virtual void gacDeregisterForCloseOnTouchSessionReq(::FeatStd::UInt32 aViewId);
    virtual void gacPopupFilterPrioEnableReq(::FeatStd::UInt32 aPrio);
    virtual void gacPopupFilterAllEnableReq();
    virtual void gacPopupFilterDisableReq();
    virtual void gacProfileChange(::FeatStd::Int8 aProfile);
    virtual void gacPopupFilterPrioEnableReqForDisplay(::FeatStd::UInt32 aPrio, ::FeatStd::UInt32 aDisplayID);
    virtual void gacPopupFilterAllEnableReqForDisplay(::FeatStd::UInt32 aDisplayID);
    virtual void gacPopupFilterDisableReqForDisplay(::FeatStd::UInt32 aDisplayID);
    virtual void gacStartSceneTransitionAnimation(::FeatStd::UInt32 aSourceView, ::FeatStd::UInt32 aDestinationView, ::FeatStd::UInt32 aUserData1, ::FeatStd::Int8 aUserData2);
    virtual void gacDecrementActiveAnimationCount();

// ------------------------------------------------------------------------
    virtual bool IsMediaMessageAvailable();

#ifdef CIT_SIMULATION
    bool CallAction(const ::FeatStd::Char* actionName, const ::Json::Value& parameters, ::Json::Value &response);
    const ::FeatStd::Char* GetEventName(::FeatStd::UInt32 eventId, ::Courier::Message const & message, Json::Value& eventArgument);
#endif
    // Added function for deduction of one event to simplify the event loop
    bool HandleDataBindingEventMapping(::Courier::AbstractDataItemMsg const & message, ::FeatStd::UInt32& eventId) const;
    bool HandleEventMapping(::Courier::Message const & message, ::FeatStd::UInt32& eventId) const;

    ::Cit::DeductResult::Enum DeductEvent(::Courier::Message const & message, ::FeatStd::UInt32 eventId);

    //====  member function with TTFis output - added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====

	virtual unsigned short GetTraceClass();
	int GetNumberOfStatemachines();
    //====  member function with TTFis output - end                        key: SM_TTFis_SBHFMSRF ====
};

// ------------------------------------------------------------------------
bool SendSelectHomescreenMediaTab();
bool SendHomescreenToggle();
bool SendUSBCameraPortInvisibility();
bool SendGuiStartupFinishedUpdMsg();
bool SendUsbElapsedTimeSeekBackMsg(Courier::UInt32 const & aSeekValue);
bool SendOptionSelStateResp(Courier::UInt const & aOptionSelection);
bool SendSwitchToTunerNowPlaying();
bool SendButtonMainSrcActivate();
bool SendSwitchToPreviousApplication();
bool SendSwitchToNaviApplication();
bool SendSwitchToMirrorLinkApplication();
bool SendSwitchToSoundSettingsApplication();
bool SendLayerSoundSettingsMsg();
bool SendSwitchApplicationReq(enApplicationId const & aApplicationID, enSurfaceId const & aSurfaceID);
bool SendUSB2SelectDeviceMsg(tenDeviceType const & aDeviceSrc);
bool SendUSB1SelectDeviceMsg(tenDeviceType const & aDeviceSrc);
bool SendSelectDeviceSourceMsg(tenDeviceType const & aDeviceSrc);
bool SendMediaSceneMsg(Courier::UInt16 const & aMediaType);
bool SendMediaOperationMsgReq(Courier::UInt16 const & aOperationType);
bool SendMediaBTOperationMsgReq(Courier::UInt16 const & aOperationType);
bool SendActivateAUXAppReqMsg(Candera::UInt8 const & aCheckboxStatus);
bool SendActivateSDCardAppReqMsg(Candera::UInt8 const & aCheckboxStatus);
bool SendActivateExternalDVDAppReqMsg(Candera::UInt8 const & aCheckboxStatus);
bool SendActivateTAAppReqMsg(Candera::UInt8 const & aCheckboxStatus);
bool SendAppleHIDCommandMsg(Courier::UInt8 const & aHIDCommand, Courier::UInt8 const & aKeyEvent);
bool SendChangeHorListTabButtonRegMsg(Courier::UInt8 const & aSelectMediaTab);
bool SendBTBrowsePressedUpdMsg();
bool SendVideoBrowsePressedUpdMsg();
bool SendBrowseBtnPressedUpdMsg();
bool SendHorTabButtonPageUpReqMsg();
bool SendHorTabButtonPageDownReqMsg();
bool SendExternalMediaTabBtnPressUpdMsg(Courier::UInt8 const & aSelectMediaTab);
bool SendExternalBrowseScreenExitUpdMsg(Courier::UInt32 const & aListId);
bool SendExternalMediaTabListPageUpReqMsg();
bool SendExternalMediaTabListPageDownReqMsg();
bool SendExternalMediaBackButtonPressUpdMsg();
bool SendExternalMediaAllButtonPressUpdMsg();
bool SendExternalMediaListItemPressUpdMsg(Courier::UInt32 const & aHdl, Courier::UInt32 const & aSubHdl);
bool SendSeekMediaAppReqMsg(Courier::Int16 const & aPlaypointPosition, Courier::Int16 const & aPlaypointFormat);
bool SendSeekBTMediaAppReqMsg(Courier::Int16 const & aPlaypointPosition, Courier::Int16 const & aPlaypointFormat);
bool SendNextBrowseTabsReqMsg();
bool SendPreviousBrowseTabsReqMsg();
bool SendBrowseListReqMsg(Courier::UInt8 const & aG_SM_ListType);
bool SendRequestUpFolderItems();
bool SendClearFolderListData();
bool SendAudioAllocationForModeMsg(tenDeviceType const & aDeviceType);
bool SendFastForwardRewindPopupMsg(Courier::Int8 const & aActionType);
bool SendUpdateBTDeviceNameUpdateStatusMsg();
bool SendBrowseListActiveRef(bool const & aIsActive);
bool SendVideoOnSpeedRequestMsg();
bool SendVideoOnParkingBreakRequestMsg();
bool SendVideoOnExtDVDSpeedRequestMsg();
bool SendDVDVideoStartStreaming();
bool SendFolderViewEntryRespMsg();
bool SendFolderViewExitRespMsg();
bool SendVideoViewEntryRespMsg();
bool SendVideoViewExitRespMsg();
bool SendSDCardViewEntryRespMsg();
bool SendSDCardViewExitRespMsg();
bool SendUSBViewEntryRespMsg();
bool SendUSBViewExitRespMsg();
bool SendDVDStopVideoStreaming();
bool SendFastForwardRewindReleaseMsg(Courier::Int8 const & aActionType);
bool SendMediaMessagepopupMsg();
bool SendVideoRequest();
bool SendStartVideoTimerMsg();
bool SendStopVideoTimerMsg();
bool SendVideoDisconnectRequest();
bool SendExtDVDVideoConnectRequest();
bool SendExtDVDDevicenameRequest();
bool SendAuxDevicenameRequest();
bool SendExtDVDVideoDisconnectRequest();
bool SendNowplayingAlbumartView();
bool SendCurrentMediaStateUpdMsg(Courier::UInt8 const & aCurrentState);
bool SendMediaSettingBackBtnPressUpdMsg();
bool SendChangeLanguageReqMsg(enLanguageId const & aLanguageId);
bool SendFocusReqMsg(FocusActionEnum const & aAction, FocusTimerActionEnum const & aTimerAction, ::Courier::ViewId const & aView, Candera::String const & aWidget);
bool SendDummyMess(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos);
bool SendAnimationReqMsg(Courier::AnimationAction::Enum const & aAnimationAction, ::Courier::ViewId const & aViewId, Courier::CompositePath const & aCompositePath, ::Courier::ItemId const & aAnimationId, Courier::AnimationProperties const & aAnimationProperties);
bool SendFocusOnRightEncoderReqUpdMsg(bool const & aIsFocusUsed);
bool SendStoreActiveGadgetReqMsg(bool const & aIsGadgetAtive);
bool SendHardKeyPressNotificationMsg(Courier::UInt8 const & aDummy, Courier::UInt8 const & aHKCode, Courier::UInt8 const & aHKState);
bool SendDropdownChangeMsg(::Candera::DropdownChangeType const & aDropdownChangeType, ::Courier::UInt32 const & aListId);
bool SendStartPopupTimerReqMsg(Courier::UInt32 const & aViewId, Courier::UInt32 const & aTimeout);
bool SendStopPopupTimerReqMsg(Courier::UInt32 const & aViewId);
bool SendPlayBeepReqMsg(Courier::Int32 const & aBeepType);
bool SendCheckToClosePopupMsg(Courier::UInt32 const & aPopupId);
bool SendRestartPopupTimerReqMsg(Courier::UInt32 const & aViewId);
bool SendContextSwitchInResMsg(Courier::UInt32 const & aSwitchId, Courier::UInt32 const & aResponseType);
bool SendContextSwitchOutReqMsg(Courier::UInt32 const & aTargetContextId, Courier::UInt32 const & aSourceContextId, Courier::UInt32 const & aTargetAppId);
bool SendCurrentScreenDisplayReqMsg();
bool SendLaunchBarDisplayReqMsg(bool const & aVisibility);
bool SendNavTBTSwipeReqMsg();
bool SendListItemRightEncoderChangeUpdMsg(Courier::Int8 const & aSteps, Courier::UInt32 const & aListId, Courier::UInt32 const & aRowId, Courier::UInt32 const & aColumnId);
bool SendListChangeMsg(::Courier::UInt32 const & aListId, ListChangeType const & aListChangeType, ::Courier::Int32 const & aValue, ListChangeMsgSourceType const & aListChangeMsgSource, bool const & aImmediatePositioning);
bool SendListFocusScrollReqMsg(Courier::UInt32 const & aListId, Courier::Int32 const & aSteps);
bool SendListFocusLockDataResetReqMsg();
bool SendSetApplicationModeReqMsg(Courier::UInt32 const & aModeId);
bool SendSpellerBbehaviorReqMsg(bool const & aEnable);
bool SendStatusBarDisplayReqMsg(bool const & aVisibility, Courier::Int32 const & aHeaderType);
bool SendTBTRetriggerAcousticMsg();
bool SendViewReqMsg(Courier::ViewAction::Enum const & aViewAction, ::Courier::ViewId const & aViewId, bool const & aShallInitScene, bool const & aShallLoadScene);
bool SendActivationReqMsg(::Courier::ViewId const & aViewId, bool const & aActivation, bool const & aEnableRendering);
bool SendAsyncLoadReqMsg(::Courier::ViewId const & aViewId, bool const & aLoad);
bool SendPopupReqMsg(hmibase::popups::CommandEnum const & aCommand, ::Courier::ViewId const & aViewId, Courier::UInt32 const & aPopupDisplayID);
bool SendExtendedViewReqMsg(hmibase::views::CommandEnum const & aCommand, ::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint);
bool SendShowHMISubSurfaceReqMsg(hmibase::displayRegion const & aDisplayRegion, Courier::Int32 const & aDisplayRegionType, bool const & aShowSubSurface, Courier::UInt32 const & aDisplayID, bool const & aLockSubSurface);
bool SendRegisterForCloseOnTouchSessionReqMsg(bool const & aRegister, ::Courier::ViewId const & aViewId);
bool SendPopupFilterPrioEnableReqMsg(Courier::UInt32 const & aPrio);
bool SendPopupFilterAllEnableReqMsg();
bool SendPopupFilterDisableReqMsg();
bool SendProfileSwitchMsg(Courier::UInt32 const & aProfile);
bool SendMultiDisplayPopupFilterReqMsg(hmibase::PopupFilterType const & aPopupFilterType, Courier::UInt32 const & aPrio, Courier::UInt32 const & aDisplayID);
bool SendCreateNewDestroyOld(::Courier::ViewId const & aSourceView, ::Courier::ViewId const & aDestinationView, Courier::UInt32 const & aUserData1, Courier::Int8 const & aUserData2);
bool SendNotifierMessage();

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_MediaTabGadget(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_MediaTabGadget();
#ifdef CIT_SIMULATION
bool CallAction_Perform_MediaToggle(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_MediaToggle();
#ifdef CIT_SIMULATION
bool CallAction_Perform_USBCameraPortInvisibility(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_USBCameraPortInvisibility();
#ifdef CIT_SIMULATION
bool CallAction_Notify_Init_Finished(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Notify_Init_Finished();
#ifdef CIT_SIMULATION
bool CallAction_acPerform_UsbElapsedTimeSeekBackMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPerform_UsbElapsedTimeSeekBackMsg(Courier::UInt32 const & aSeekValue);
#ifdef CIT_SIMULATION
bool CallAction_OptionSelStateRespMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_OptionSelStateRespMsg();
#ifdef CIT_SIMULATION
bool CallAction_Activate_Suz_TunerNowPlaying(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Activate_Suz_TunerNowPlaying();
#ifdef CIT_SIMULATION
bool CallAction_Activate_ButtonMainSrcActivate(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Activate_ButtonMainSrcActivate();
#ifdef CIT_SIMULATION
bool CallAction_Activate_Suz_PreviousApplication(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Activate_Suz_PreviousApplication();
#ifdef CIT_SIMULATION
bool CallAction_Activate_Suz_NaviApplication(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Activate_Suz_NaviApplication();
#ifdef CIT_SIMULATION
bool CallAction_Activate_Suz_MirrorLinkApplication(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Activate_Suz_MirrorLinkApplication();
#ifdef CIT_SIMULATION
bool CallAction_Activate_Suz_SoundSettingsApplication(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Activate_Suz_SoundSettingsApplication();
#ifdef CIT_SIMULATION
bool CallAction_Activate_LayerSoundSettingsMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Activate_LayerSoundSettingsMsg();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Activate_Home_Source(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Activate_Home_Source();
#ifdef CIT_SIMULATION
bool CallAction_Activate_Suz_BTPhoneApplication(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Activate_Suz_BTPhoneApplication();
#ifdef CIT_SIMULATION
bool CallAction_Activate_Suz_TunerApplication(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Activate_Suz_TunerApplication();
#ifdef CIT_SIMULATION
bool CallAction_Perform_MediaModule_USB2(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_MediaModule_USB2();
#ifdef CIT_SIMULATION
bool CallAction_Perform_MediaModule_USB1(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_MediaModule_USB1();
#ifdef CIT_SIMULATION
bool CallAction_Perform_MediaModule_USB(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_MediaModule_USB();
#ifdef CIT_SIMULATION
bool CallAction_Perform_MediaModule_IPOD(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_MediaModule_IPOD();
#ifdef CIT_SIMULATION
bool CallAction_Perform_MediaModule_SD(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_MediaModule_SD();
#ifdef CIT_SIMULATION
bool CallAction_Perform_MediaModule_BLUETOOTH(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_MediaModule_BLUETOOTH();
#ifdef CIT_SIMULATION
bool CallAction_Perform_MediaModule_CAMERAPORTUSB(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_MediaModule_CAMERAPORTUSB();
#ifdef CIT_SIMULATION
bool CallAction_Perform_MediaModule_CAMERAPORTHDMI(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_MediaModule_CAMERAPORTHDMI();
#ifdef CIT_SIMULATION
bool CallAction_Perform_MediaModule_ROUTERUSB(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_MediaModule_ROUTERUSB();
#ifdef CIT_SIMULATION
bool CallAction_Perform_MediaModule_AUX(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_MediaModule_AUX();
#ifdef CIT_SIMULATION
bool CallAction_Perform_MediaSceneMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_MediaSceneMsg(Courier::UInt16 const & aMediaType);
#ifdef CIT_SIMULATION
bool CallAction_MediaOperation(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_MediaOperation(Courier::UInt16 const & aOperationType);
#ifdef CIT_SIMULATION
bool CallAction_MediaBTOperation(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_MediaBTOperation(Courier::UInt16 const & aOperationType);
#ifdef CIT_SIMULATION
bool CallAction_ActivateAUXApp(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_ActivateAUXApp(Candera::UInt8 const & aCheckboxStatus);
#ifdef CIT_SIMULATION
bool CallAction_ActivateSDCard(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_ActivateSDCard(Candera::UInt8 const & aCheckboxStatus);
#ifdef CIT_SIMULATION
bool CallAction_ActivateExternalDVD(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_ActivateExternalDVD(Candera::UInt8 const & aCheckboxStatus);
#ifdef CIT_SIMULATION
bool CallAction_ActivateTAApp(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_ActivateTAApp(Candera::UInt8 const & aCheckboxStatus);
#ifdef CIT_SIMULATION
bool CallAction_acPerform_AppleHIDCommandMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPerform_AppleHIDCommandMsg(Courier::UInt8 const & aHIDCommand, Courier::UInt8 const & aKeyEvent);
#ifdef CIT_SIMULATION
bool CallAction_HorListTabButtonItem(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_HorListTabButtonItem(Courier::UInt8 const & aSelectMediaTab);
#ifdef CIT_SIMULATION
bool CallAction_BTBrowseButtonPressed(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_BTBrowseButtonPressed();
#ifdef CIT_SIMULATION
bool CallAction_VideoBrowseButtonPressed(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_VideoBrowseButtonPressed();
#ifdef CIT_SIMULATION
bool CallAction_BrowseButtonPressed(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_BrowseButtonPressed();
#ifdef CIT_SIMULATION
bool CallAction_HorTabListBtnPageUp(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_HorTabListBtnPageUp();
#ifdef CIT_SIMULATION
bool CallAction_HorTabListBtnPageDown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_HorTabListBtnPageDown();
#ifdef CIT_SIMULATION
bool CallAction_ExternalMediaTabBtnPressUpd(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_ExternalMediaTabBtnPressUpd(Courier::UInt8 const & aSelectMediaTab);
#ifdef CIT_SIMULATION
bool CallAction_ExternalBrowseScreenExitUpd(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_ExternalBrowseScreenExitUpd(Courier::UInt32 const & aListId);
#ifdef CIT_SIMULATION
bool CallAction_ExternalMediaTabListPageUp(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_ExternalMediaTabListPageUp();
#ifdef CIT_SIMULATION
bool CallAction_ExternalMediaTabListPageDown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_ExternalMediaTabListPageDown();
#ifdef CIT_SIMULATION
bool CallAction_ExternalMediaBackButtonPressUpd(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_ExternalMediaBackButtonPressUpd();
#ifdef CIT_SIMULATION
bool CallAction_ExternalMediaAllButtonPressUpd(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_ExternalMediaAllButtonPressUpd();
#ifdef CIT_SIMULATION
bool CallAction_ExternalMediaListItemPressUpd(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_ExternalMediaListItemPressUpd(Courier::UInt32 const & aHdl, Courier::UInt32 const & aSubHdl);
#ifdef CIT_SIMULATION
bool CallAction_RequestPlayBackActionSeek(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_RequestPlayBackActionSeek();
#ifdef CIT_SIMULATION
bool CallAction_RequestBTPlayBackActionSeek(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_RequestBTPlayBackActionSeek();
#ifdef CIT_SIMULATION
bool CallAction_RequestNextBrowseTabs(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_RequestNextBrowseTabs();
#ifdef CIT_SIMULATION
bool CallAction_RequestPreviousBrowseTabs(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_RequestPreviousBrowseTabs();
#ifdef CIT_SIMULATION
bool CallAction_RequestBrowseList(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_RequestBrowseList(Courier::UInt8 const & aG_SM_ListType);
#ifdef CIT_SIMULATION
bool CallAction_RequestParentFolderItems(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_RequestParentFolderItems();
#ifdef CIT_SIMULATION
bool CallAction_RequestClearFolderListData(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_RequestClearFolderListData();
#ifdef CIT_SIMULATION
bool CallAction_RequestAudioAllocationForMode(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_RequestAudioAllocationForMode(tenDeviceType const & aDeviceType);
#ifdef CIT_SIMULATION
bool CallAction_Perform_FastRewindStart_Popup(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_FastRewindStart_Popup();
#ifdef CIT_SIMULATION
bool CallAction_Perform_FastForwardStart_Popup(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_FastForwardStart_Popup();
#ifdef CIT_SIMULATION
bool CallAction_Perform_BTDeviceNameUpdateStatusMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_BTDeviceNameUpdateStatusMsg();
#ifdef CIT_SIMULATION
bool CallAction_BrowseListActive(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_BrowseListActive(bool const & aIsActive);
#ifdef CIT_SIMULATION
bool CallAction_Perform_VideoOnSpeedRequestMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_VideoOnSpeedRequestMsg();
#ifdef CIT_SIMULATION
bool CallAction_Perform_VideoOnParkingBreakRequestMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_VideoOnParkingBreakRequestMsg();
#ifdef CIT_SIMULATION
bool CallAction_Perform_VideoOnEXTDVDSpeedRequestMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_VideoOnEXTDVDSpeedRequestMsg();
#ifdef CIT_SIMULATION
bool CallAction_Perform_VideoOnEXTDVDParkingBreakRequestMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_VideoOnEXTDVDParkingBreakRequestMsg();
#ifdef CIT_SIMULATION
bool CallAction_StartVideoStreaming(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_StartVideoStreaming();
#ifdef CIT_SIMULATION
bool CallAction_StartFolderViewEntryRespMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_StartFolderViewEntryRespMsg();
#ifdef CIT_SIMULATION
bool CallAction_StopFolderViewExitRespMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_StopFolderViewExitRespMsg();
#ifdef CIT_SIMULATION
bool CallAction_StartVideoViewEntryRespMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_StartVideoViewEntryRespMsg();
#ifdef CIT_SIMULATION
bool CallAction_StopVideoViewExitRespMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_StopVideoViewExitRespMsg();
#ifdef CIT_SIMULATION
bool CallAction_StartSDCardViewEntryRespMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_StartSDCardViewEntryRespMsg();
#ifdef CIT_SIMULATION
bool CallAction_StopSDCardViewExitRespMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_StopSDCardViewExitRespMsg();
#ifdef CIT_SIMULATION
bool CallAction_StartUSBViewEntryRespMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_StartUSBViewEntryRespMsg();
#ifdef CIT_SIMULATION
bool CallAction_StopUSBViewExitRespMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_StopUSBViewExitRespMsg();
#ifdef CIT_SIMULATION
bool CallAction_StopVideoStreaming(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_StopVideoStreaming();
#ifdef CIT_SIMULATION
bool CallAction_Perform_FastRewindStop_Popup(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_FastRewindStop_Popup();
#ifdef CIT_SIMULATION
bool CallAction_Perform_FastForwardStop_Popup(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_FastForwardStop_Popup();
#ifdef CIT_SIMULATION
bool CallAction_Perform_MediaMessage_Popup(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_MediaMessage_Popup();
#ifdef CIT_SIMULATION
bool CallAction_VideoOnsongRequest(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_VideoOnsongRequest();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Video_Timer_Start(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Video_Timer_Start();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Video_Timer_Stop(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Video_Timer_Stop();
#ifdef CIT_SIMULATION
bool CallAction_VideoDisconnectOnSongRequest(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_VideoDisconnectOnSongRequest();
#ifdef CIT_SIMULATION
bool CallAction_ExternaldvdVideoConnectRequest(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_ExternaldvdVideoConnectRequest();
#ifdef CIT_SIMULATION
bool CallAction_ExternalDVDDevicenameRequest(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_ExternalDVDDevicenameRequest();
#ifdef CIT_SIMULATION
bool CallAction_ExternalAuxDevicenameRequest(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_ExternalAuxDevicenameRequest();
#ifdef CIT_SIMULATION
bool CallAction_ExternaldvdVideodisconnectRequest(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_ExternaldvdVideodisconnectRequest();
#ifdef CIT_SIMULATION
bool CallAction_NowplayingAlbumartViewRequest(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_NowplayingAlbumartViewRequest();
#ifdef CIT_SIMULATION
bool CallAction_acPerform_UpdateCurrentMediaState(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPerform_UpdateCurrentMediaState(Courier::UInt8 const & aCurrentState);
#ifdef CIT_SIMULATION
bool CallAction_acPerform_MediaSettingBackBtnPress(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPerform_MediaSettingBackBtnPress();
#ifdef CIT_SIMULATION
bool CallAction_gacChangeLanguageReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacChangeLanguageReq(enLanguageId const & aLanguageId);
#ifdef CIT_SIMULATION
bool CallAction_gacHideFocusInViewReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacHideFocusInViewReq(::Courier::ViewId const & aView);
#ifdef CIT_SIMULATION
bool CallAction_NextLevelTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_NextLevelTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_PreviousLevelTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_PreviousLevelTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_DualViewLeftTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_DualViewLeftTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_DualViewRightTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_DualViewRightTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_PageFlipBackTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_PageFlipBackTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_PageFlipFrontTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_PageFlipFrontTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_ZoomInTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_ZoomInTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos);
#ifdef CIT_SIMULATION
bool CallAction_ZoomOutTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_ZoomOutTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos);
#ifdef CIT_SIMULATION
bool CallAction_FadeTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_FadeTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_gacWaitAnimationStartReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacWaitAnimationStartReq();
#ifdef CIT_SIMULATION
bool CallAction_acFocusOnRightEncoderReqUpd(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acFocusOnRightEncoderReqUpd(bool const & aIsFocusUsed);
#ifdef CIT_SIMULATION
bool CallAction_acSetGadgetSceenActiveStatus(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSetGadgetSceenActiveStatus(bool const & aIsGadgetAtive);
#ifdef CIT_SIMULATION
bool CallAction_acHKNotificationMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acHKNotificationMsg(Courier::UInt8 const & aHKCode, Courier::UInt8 const & aHKState);
#ifdef CIT_SIMULATION
bool CallAction_acPerform_CloseAllDropdowns(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPerform_CloseAllDropdowns();
#ifdef CIT_SIMULATION
bool CallAction_acPerform_CloseDropdown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPerform_CloseDropdown(::Courier::UInt32 const & aListId);
#ifdef CIT_SIMULATION
bool CallAction_acPerform_OpenDropdown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPerform_OpenDropdown(::Courier::UInt32 const & aListId);
#ifdef CIT_SIMULATION
bool CallAction_acPerform_ToggleDropdown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPerform_ToggleDropdown(::Courier::UInt32 const & aListId);
#ifdef CIT_SIMULATION
bool CallAction_acStartAppPopupTimer(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acStartAppPopupTimer(Courier::UInt32 const & aViewId, Courier::UInt32 const & aTimeout);
#ifdef CIT_SIMULATION
bool CallAction_acStopAppPopupTimer(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acStopAppPopupTimer(Courier::UInt32 const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_acPostBeep(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPostBeep(Courier::Int32 const & aBeepType);
#ifdef CIT_SIMULATION
bool CallAction_gacCheckToClosePopup(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacCheckToClosePopup(Courier::UInt32 const & aPopupId);
#ifdef CIT_SIMULATION
bool CallAction_acRestartAppPopupTimer(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acRestartAppPopupTimer(Courier::UInt32 const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchBackRes(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacContextSwitchBackRes(Courier::UInt32 const & aSwitchId);
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchCompleteRes(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacContextSwitchCompleteRes(Courier::UInt32 const & aSwitchId);
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchFailedRes(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacContextSwitchFailedRes(Courier::UInt32 const & aSwitchId);
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchDoneRes(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacContextSwitchDoneRes(Courier::UInt32 const & aSwitchId);
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchOutReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacContextSwitchOutReq(Courier::UInt32 const & aTargetContextId, Courier::UInt32 const & aSourceContextId, Courier::UInt32 const & aTargetAppId);
#ifdef CIT_SIMULATION
bool CallAction_gacCurrentScreenDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacCurrentScreenDisplayReq();
#ifdef CIT_SIMULATION
bool CallAction_gacLaunchBarDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacLaunchBarDisplayReq(bool const & aVisibility);
#ifdef CIT_SIMULATION
bool CallAction_gacNavTBTSwipe(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacNavTBTSwipe();
#ifdef CIT_SIMULATION
bool CallAction_gacPerformListBtnRightEncoderChangeUpd(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPerformListBtnRightEncoderChangeUpd(Courier::Int8 const & aSteps, Courier::UInt32 const & aListId, Courier::UInt32 const & aRowId, Courier::UInt32 const & aColumnId);
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListUp(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollListUp();
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListDown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollListDown();
#ifdef CIT_SIMULATION
bool CallAction_gacScrollPageUp(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollPageUp();
#ifdef CIT_SIMULATION
bool CallAction_gacScrollPageDown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollPageDown();
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListFocusUp(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollListFocusUp(Courier::UInt32 const & aListId);
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListFocusDown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollListFocusDown(Courier::UInt32 const & aListId);
#ifdef CIT_SIMULATION
bool CallAction_gacPerformListFocusLockDataResetUpd(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPerformListFocusLockDataResetUpd();
#ifdef CIT_SIMULATION
bool CallAction_gacSetApplicationMode(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacSetApplicationMode(Courier::UInt32 const & aModeId);
#ifdef CIT_SIMULATION
bool CallAction_gacSpellerBbehaviorReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacSpellerBbehaviorReq(bool const & aEnable);
#ifdef CIT_SIMULATION
bool CallAction_gacStatusBarDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacStatusBarDisplayReq(bool const & aVisibility, Courier::Int32 const & aHeaderType);
#ifdef CIT_SIMULATION
bool CallAction_gacTBTRetriggerAcousticOutput(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacTBTRetriggerAcousticOutput();
#ifdef CIT_SIMULATION
bool CallAction_gacWaitAnimationStopReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacWaitAnimationStopReq();
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewCreateReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateAllReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewCreateAllReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewDestroyReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewDestroyReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewClearReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewClearReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewShowReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewShowReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewHideReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewHideReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateWithoutLoadReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewCreateWithoutLoadReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewAsyncLoadReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewAsyncLoadReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewActivateWithoutRenderingReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewActivateWithoutRenderingReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupCreateAndSBShowReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupCreateAndSBShowReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupCreateAndSBShowReqForMultiDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupCreateAndSBShowReqForMultiDisplay(Courier::UInt32 const & aPopupDisplayID, ::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupSBCloseReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupSBCloseReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupSBCloseReqForMultiDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupSBCloseReqForMultiDisplay(Courier::UInt32 const & aPopupDisplayID, ::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupRestartTimerReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupRestartTimerReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupRestartTimerReqForMultiDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupRestartTimerReqForMultiDisplay(Courier::UInt32 const & aPopupDisplayID, ::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateAndShowReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewCreateAndShowReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewHideAndDestroyReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewHideAndDestroyReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacSceneTransitionEnter(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacSceneTransitionEnter(::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint);
#ifdef CIT_SIMULATION
bool CallAction_gacSceneTransitionLeave(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacSceneTransitionLeave(::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint);
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayStatusLineReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDisplayStatusLineReq(Courier::Int32 const & aDisplayRegionType);
#ifdef CIT_SIMULATION
bool CallAction_gacHideStatusLineReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacHideStatusLineReq(Courier::Int32 const & aDisplayRegionType);
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayFooterLineReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDisplayFooterLineReq();
#ifdef CIT_SIMULATION
bool CallAction_gacHideFooterLineReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacHideFooterLineReq();
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayStatusLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDisplayStatusLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacHideStatusLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacHideStatusLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayFooterLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDisplayFooterLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacHideFooterLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacHideFooterLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacRegisterForCloseOnTouchSession(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacRegisterForCloseOnTouchSession(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacDeregisterForCloseOnTouchSessionReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDeregisterForCloseOnTouchSessionReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterPrioEnableReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterPrioEnableReq(Courier::UInt32 const & aPrio);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterAllEnableReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterAllEnableReq();
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterDisableReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterDisableReq();
#ifdef CIT_SIMULATION
bool CallAction_gacProfileChange(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacProfileChange(Courier::UInt32 const & aProfile);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterPrioEnableReqForDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterPrioEnableReqForDisplay(Courier::UInt32 const & aPrio, Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterAllEnableReqForDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterAllEnableReqForDisplay(Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterDisableReqForDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterDisableReqForDisplay(Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacStartSceneTransitionAnimation(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacStartSceneTransitionAnimation(::Courier::ViewId const & aSourceView, ::Courier::ViewId const & aDestinationView, Courier::UInt32 const & aUserData1, Courier::Int8 const & aUserData2);
#ifdef CIT_SIMULATION
bool CallAction_gacDecrementActiveAnimationCount(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDecrementActiveAnimationCount();

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_IsMediaMessageAvailable(const ::Json::Value& parameters, ::Json::Value &response);
#endif
bool Action_IsMediaMessageAvailable();

// overall number of HierarchyNodes
static const ::FeatStd::UInt32 cGlobalDataItemHierarchyNodeCount = 529;
// overall number of DataItemDescriptor nodes
static const ::FeatStd::UInt32 cDataItemDescriptorCount = 529;
// overall number of BindingSources
static const ::FeatStd::UInt32 cBindingSourceCount = 153;
// maximum number of HierarchyNodes in a BindingSource
static const ::FeatStd::UInt32 cBindingSourceItemCountMax = 25;

// =========================================================================

class DeviceConnectionDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 5;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 1;
    static const ::Courier::DataItemKey cDataItemKey = 512;

    typedef ::DeviceConnectionData Data;

    DeviceConnectionDataBindingSource();
};

typedef ::Courier::DataItemMsg< DeviceConnectionDataBindingSource > DeviceConnectionDataItemMsg;

// =========================================================================

class BTVisibilityDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 2;
    static const ::Courier::DataItemKey cDataItemKey = 301;

    typedef ::BTVisibilityData Data;

    BTVisibilityDataBindingSource();
};

typedef ::Courier::DataItemMsg< BTVisibilityDataBindingSource > BTVisibilityDataItemMsg;

// =========================================================================

class SPIVisibilityDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 3;
    static const ::Courier::DataItemKey cDataItemKey = 527;

    typedef ::SPIVisibilityData Data;

    SPIVisibilityDataBindingSource();
};

typedef ::Courier::DataItemMsg< SPIVisibilityDataBindingSource > SPIVisibilityDataItemMsg;

// =========================================================================

class PlaybackActionDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 20;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 4;
    static const ::Courier::DataItemKey cDataItemKey = 215;

    typedef ::PlaybackActionData Data;

    PlaybackActionDataBindingSource();
};

typedef ::Courier::DataItemMsg< PlaybackActionDataBindingSource > PlaybackActionDataItemMsg;

// =========================================================================

class USBCameraPortPlaybackActionDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 16;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 5;
    static const ::Courier::DataItemKey cDataItemKey = 339;

    typedef ::USBCameraPortPlaybackActionData Data;

    USBCameraPortPlaybackActionDataBindingSource();
};

typedef ::Courier::DataItemMsg< USBCameraPortPlaybackActionDataBindingSource > USBCameraPortPlaybackActionDataItemMsg;

// =========================================================================

class USBRouterPlaybackActionDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 10;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 6;
    static const ::Courier::DataItemKey cDataItemKey = 400;

    typedef ::USBRouterPlaybackActionData Data;

    USBRouterPlaybackActionDataBindingSource();
};

typedef ::Courier::DataItemMsg< USBRouterPlaybackActionDataBindingSource > USBRouterPlaybackActionDataItemMsg;

// =========================================================================

class MuteInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 7;
    static const ::Courier::DataItemKey cDataItemKey = 43;

    typedef ::MuteInfoData Data;

    MuteInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< MuteInfoDataBindingSource > MuteInfoDataItemMsg;

// =========================================================================

class MuteInfoforAuxDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 8;
    static const ::Courier::DataItemKey cDataItemKey = 329;

    typedef ::MuteInfoforAuxData Data;

    MuteInfoforAuxDataBindingSource();
};

typedef ::Courier::DataItemMsg< MuteInfoforAuxDataBindingSource > MuteInfoforAuxDataItemMsg;

// =========================================================================

class USB2VisibilityDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 9;
    static const ::Courier::DataItemKey cDataItemKey = 39;

    typedef ::USB2VisibilityData Data;

    USB2VisibilityDataBindingSource();
};

typedef ::Courier::DataItemMsg< USB2VisibilityDataBindingSource > USB2VisibilityDataItemMsg;

// =========================================================================

class VariantInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 10;
    static const ::Courier::DataItemKey cDataItemKey = 30;

    typedef ::VariantInfoData Data;

    VariantInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< VariantInfoDataBindingSource > VariantInfoDataItemMsg;

// =========================================================================

class ExternalMediaSourceDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 11;
    static const ::Courier::DataItemKey cDataItemKey = 126;

    typedef ::ExternalMediaSourceData Data;

    ExternalMediaSourceDataBindingSource();
};

typedef ::Courier::DataItemMsg< ExternalMediaSourceDataBindingSource > ExternalMediaSourceDataItemMsg;

// =========================================================================

class TabVideoSourceDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 12;
    static const ::Courier::DataItemKey cDataItemKey = 401;

    typedef ::TabVideoSourceData Data;

    TabVideoSourceDataBindingSource();
};

typedef ::Courier::DataItemMsg< TabVideoSourceDataBindingSource > TabVideoSourceDataItemMsg;

// =========================================================================

class BTNowplayIconsDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 13;
    static const ::Courier::DataItemKey cDataItemKey = 429;

    typedef ::BTNowplayIconsData Data;

    BTNowplayIconsDataBindingSource();
};

typedef ::Courier::DataItemMsg< BTNowplayIconsDataBindingSource > BTNowplayIconsDataItemMsg;

// =========================================================================

class ID3CoverDataForGadgetDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 14;
    static const ::Courier::DataItemKey cDataItemKey = 265;

    typedef ::ID3CoverDataForGadgetData Data;

    ID3CoverDataForGadgetDataBindingSource();
};

typedef ::Courier::DataItemMsg< ID3CoverDataForGadgetDataBindingSource > ID3CoverDataForGadgetDataItemMsg;

// =========================================================================

class ID3CoverDataForCamportUSBGadgetDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 15;
    static const ::Courier::DataItemKey cDataItemKey = 360;

    typedef ::ID3CoverDataForCamportUSBGadgetData Data;

    ID3CoverDataForCamportUSBGadgetDataBindingSource();
};

typedef ::Courier::DataItemMsg< ID3CoverDataForCamportUSBGadgetDataBindingSource > ID3CoverDataForCamportUSBGadgetDataItemMsg;

// =========================================================================

class ID3CoverDataForRouterUSBGadgetDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 16;
    static const ::Courier::DataItemKey cDataItemKey = 147;

    typedef ::ID3CoverDataForRouterUSBGadgetData Data;

    ID3CoverDataForRouterUSBGadgetDataBindingSource();
};

typedef ::Courier::DataItemMsg< ID3CoverDataForRouterUSBGadgetDataBindingSource > ID3CoverDataForRouterUSBGadgetDataItemMsg;

// =========================================================================

class ID3CoverDataForCamportUSBDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 17;
    static const ::Courier::DataItemKey cDataItemKey = 443;

    typedef ::ID3CoverDataForCamportUSBData Data;

    ID3CoverDataForCamportUSBDataBindingSource();
};

typedef ::Courier::DataItemMsg< ID3CoverDataForCamportUSBDataBindingSource > ID3CoverDataForCamportUSBDataItemMsg;

// =========================================================================

class ID3CoverDataForRouterUSBDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 18;
    static const ::Courier::DataItemKey cDataItemKey = 106;

    typedef ::ID3CoverDataForRouterUSBData Data;

    ID3CoverDataForRouterUSBDataBindingSource();
};

typedef ::Courier::DataItemMsg< ID3CoverDataForRouterUSBDataBindingSource > ID3CoverDataForRouterUSBDataItemMsg;

// =========================================================================

class AlbumListItemDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 19;
    static const ::Courier::DataItemKey cDataItemKey = 35;

    typedef ::AlbumListItemData Data;

    AlbumListItemDataBindingSource();
};

typedef ::Courier::DataItemMsg< AlbumListItemDataBindingSource > AlbumListItemDataItemMsg;

// =========================================================================

class VideoPlaybackActionDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 20;
    static const ::Courier::DataItemKey cDataItemKey = 90;

    typedef ::VideoPlaybackActionData Data;

    VideoPlaybackActionDataBindingSource();
};

typedef ::Courier::DataItemMsg< VideoPlaybackActionDataBindingSource > VideoPlaybackActionDataItemMsg;

// =========================================================================

class AppleDeviceDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 20;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 21;
    static const ::Courier::DataItemKey cDataItemKey = 188;

    typedef ::AppleDeviceData Data;

    AppleDeviceDataBindingSource();
};

typedef ::Courier::DataItemMsg< AppleDeviceDataBindingSource > AppleDeviceDataItemMsg;

// =========================================================================

class IconsDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 22;
    static const ::Courier::DataItemKey cDataItemKey = 456;

    typedef ::IconsData Data;

    IconsDataBindingSource();
};

typedef ::Courier::DataItemMsg< IconsDataBindingSource > IconsDataItemMsg;

// =========================================================================

class IconsVisibilityDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 7;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 23;
    static const ::Courier::DataItemKey cDataItemKey = 326;

    typedef ::IconsVisibilityData Data;

    IconsVisibilityDataBindingSource();
};

typedef ::Courier::DataItemMsg< IconsVisibilityDataBindingSource > IconsVisibilityDataItemMsg;

// =========================================================================

class NavigationVarientTypeDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 24;
    static const ::Courier::DataItemKey cDataItemKey = 441;

    typedef ::NavigationVarientTypeData Data;

    NavigationVarientTypeDataBindingSource();
};

typedef ::Courier::DataItemMsg< NavigationVarientTypeDataBindingSource > NavigationVarientTypeDataItemMsg;

// =========================================================================

class ID3CoverDataForAppleDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 25;
    static const ::Courier::DataItemKey cDataItemKey = 131;

    typedef ::ID3CoverDataForAppleData Data;

    ID3CoverDataForAppleDataBindingSource();
};

typedef ::Courier::DataItemMsg< ID3CoverDataForAppleDataBindingSource > ID3CoverDataForAppleDataItemMsg;

// =========================================================================

class ID3CoverDataForBTDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 26;
    static const ::Courier::DataItemKey cDataItemKey = 157;

    typedef ::ID3CoverDataForBTData Data;

    ID3CoverDataForBTDataBindingSource();
};

typedef ::Courier::DataItemMsg< ID3CoverDataForBTDataBindingSource > ID3CoverDataForBTDataItemMsg;

// =========================================================================

class SDCardDeviceDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 19;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 27;
    static const ::Courier::DataItemKey cDataItemKey = 203;

    typedef ::SDCardDeviceData Data;

    SDCardDeviceDataBindingSource();
};

typedef ::Courier::DataItemMsg< SDCardDeviceDataBindingSource > SDCardDeviceDataItemMsg;

// =========================================================================

class ID3CoverDataForSDCardDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 28;
    static const ::Courier::DataItemKey cDataItemKey = 452;

    typedef ::ID3CoverDataForSDCardData Data;

    ID3CoverDataForSDCardDataBindingSource();
};

typedef ::Courier::DataItemMsg< ID3CoverDataForSDCardDataBindingSource > ID3CoverDataForSDCardDataItemMsg;

// =========================================================================

class VideoPlayerFullScreeenDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 29;
    static const ::Courier::DataItemKey cDataItemKey = 168;

    typedef ::VideoPlayerFullScreeenData Data;

    VideoPlayerFullScreeenDataBindingSource();
};

typedef ::Courier::DataItemMsg< VideoPlayerFullScreeenDataBindingSource > VideoPlayerFullScreeenDataItemMsg;

// =========================================================================

class IpodButtonDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 30;
    static const ::Courier::DataItemKey cDataItemKey = 369;

    typedef ::IpodButtonData Data;

    IpodButtonDataBindingSource();
};

typedef ::Courier::DataItemMsg< IpodButtonDataBindingSource > IpodButtonDataItemMsg;

// =========================================================================

class AuxButtonDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 31;
    static const ::Courier::DataItemKey cDataItemKey = 465;

    typedef ::AuxButtonData Data;

    AuxButtonDataBindingSource();
};

typedef ::Courier::DataItemMsg< AuxButtonDataBindingSource > AuxButtonDataItemMsg;

// =========================================================================

class USBButtonDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 32;
    static const ::Courier::DataItemKey cDataItemKey = 404;

    typedef ::USBButtonData Data;

    USBButtonDataBindingSource();
};

typedef ::Courier::DataItemMsg< USBButtonDataBindingSource > USBButtonDataItemMsg;

// =========================================================================

class USB1ButtonDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 33;
    static const ::Courier::DataItemKey cDataItemKey = 189;

    typedef ::USB1ButtonData Data;

    USB1ButtonDataBindingSource();
};

typedef ::Courier::DataItemMsg< USB1ButtonDataBindingSource > USB1ButtonDataItemMsg;

// =========================================================================

class USB2ButtonDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 34;
    static const ::Courier::DataItemKey cDataItemKey = 227;

    typedef ::USB2ButtonData Data;

    USB2ButtonDataBindingSource();
};

typedef ::Courier::DataItemMsg< USB2ButtonDataBindingSource > USB2ButtonDataItemMsg;

// =========================================================================

class SDCardButtonDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 35;
    static const ::Courier::DataItemKey cDataItemKey = 517;

    typedef ::SDCardButtonData Data;

    SDCardButtonDataBindingSource();
};

typedef ::Courier::DataItemMsg< SDCardButtonDataBindingSource > SDCardButtonDataItemMsg;

// =========================================================================

class BTButtonDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 36;
    static const ::Courier::DataItemKey cDataItemKey = 311;

    typedef ::BTButtonData Data;

    BTButtonDataBindingSource();
};

typedef ::Courier::DataItemMsg< BTButtonDataBindingSource > BTButtonDataItemMsg;

// =========================================================================

class ExternalDVDButtonDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 37;
    static const ::Courier::DataItemKey cDataItemKey = 78;

    typedef ::ExternalDVDButtonData Data;

    ExternalDVDButtonDataBindingSource();
};

typedef ::Courier::DataItemMsg< ExternalDVDButtonDataBindingSource > ExternalDVDButtonDataItemMsg;

// =========================================================================

class Camport1USBButtonDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 38;
    static const ::Courier::DataItemKey cDataItemKey = 115;

    typedef ::Camport1USBButtonData Data;

    Camport1USBButtonDataBindingSource();
};

typedef ::Courier::DataItemMsg< Camport1USBButtonDataBindingSource > Camport1USBButtonDataItemMsg;

// =========================================================================

class Camport1HDMIButtonDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 39;
    static const ::Courier::DataItemKey cDataItemKey = 170;

    typedef ::Camport1HDMIButtonData Data;

    Camport1HDMIButtonDataBindingSource();
};

typedef ::Courier::DataItemMsg< Camport1HDMIButtonDataBindingSource > Camport1HDMIButtonDataItemMsg;

// =========================================================================

class ExternalDVDStatusDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 40;
    static const ::Courier::DataItemKey cDataItemKey = 304;

    typedef ::ExternalDVDStatusData Data;

    ExternalDVDStatusDataBindingSource();
};

typedef ::Courier::DataItemMsg< ExternalDVDStatusDataBindingSource > ExternalDVDStatusDataItemMsg;

// =========================================================================

class TAStatusDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 41;
    static const ::Courier::DataItemKey cDataItemKey = 394;

    typedef ::TAStatusData Data;

    TAStatusDataBindingSource();
};

typedef ::Courier::DataItemMsg< TAStatusDataBindingSource > TAStatusDataItemMsg;

// =========================================================================

class AUXStatusDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 42;
    static const ::Courier::DataItemKey cDataItemKey = 105;

    typedef ::AUXStatusData Data;

    AUXStatusDataBindingSource();
};

typedef ::Courier::DataItemMsg< AUXStatusDataBindingSource > AUXStatusDataItemMsg;

// =========================================================================

class SDCardStatusDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 43;
    static const ::Courier::DataItemKey cDataItemKey = 144;

    typedef ::SDCardStatusData Data;

    SDCardStatusDataBindingSource();
};

typedef ::Courier::DataItemMsg< SDCardStatusDataBindingSource > SDCardStatusDataItemMsg;

// =========================================================================

class TitleTabDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 44;
    static const ::Courier::DataItemKey cDataItemKey = 446;

    typedef ::TitleTabData Data;

    TitleTabDataBindingSource();
};

typedef ::Courier::DataItemMsg< TitleTabDataBindingSource > TitleTabDataItemMsg;

// =========================================================================

class ArtistTabDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 45;
    static const ::Courier::DataItemKey cDataItemKey = 325;

    typedef ::ArtistTabData Data;

    ArtistTabDataBindingSource();
};

typedef ::Courier::DataItemMsg< ArtistTabDataBindingSource > ArtistTabDataItemMsg;

// =========================================================================

class AlbumTabDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 46;
    static const ::Courier::DataItemKey cDataItemKey = 435;

    typedef ::AlbumTabData Data;

    AlbumTabDataBindingSource();
};

typedef ::Courier::DataItemMsg< AlbumTabDataBindingSource > AlbumTabDataItemMsg;

// =========================================================================

class GenreTabDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 47;
    static const ::Courier::DataItemKey cDataItemKey = 85;

    typedef ::GenreTabData Data;

    GenreTabDataBindingSource();
};

typedef ::Courier::DataItemMsg< GenreTabDataBindingSource > GenreTabDataItemMsg;

// =========================================================================

class FolderTabDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 48;
    static const ::Courier::DataItemKey cDataItemKey = 288;

    typedef ::FolderTabData Data;

    FolderTabDataBindingSource();
};

typedef ::Courier::DataItemMsg< FolderTabDataBindingSource > FolderTabDataItemMsg;

// =========================================================================

class PlaylistTabDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 49;
    static const ::Courier::DataItemKey cDataItemKey = 223;

    typedef ::PlaylistTabData Data;

    PlaylistTabDataBindingSource();
};

typedef ::Courier::DataItemMsg< PlaylistTabDataBindingSource > PlaylistTabDataItemMsg;

// =========================================================================

class AudiobookTabDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 50;
    static const ::Courier::DataItemKey cDataItemKey = 447;

    typedef ::AudiobookTabData Data;

    AudiobookTabDataBindingSource();
};

typedef ::Courier::DataItemMsg< AudiobookTabDataBindingSource > AudiobookTabDataItemMsg;

// =========================================================================

class PodcastTabDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 51;
    static const ::Courier::DataItemKey cDataItemKey = 214;

    typedef ::PodcastTabData Data;

    PodcastTabDataBindingSource();
};

typedef ::Courier::DataItemMsg< PodcastTabDataBindingSource > PodcastTabDataItemMsg;

// =========================================================================

class VideoTabDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 52;
    static const ::Courier::DataItemKey cDataItemKey = 47;

    typedef ::VideoTabData Data;

    VideoTabDataBindingSource();
};

typedef ::Courier::DataItemMsg< VideoTabDataBindingSource > VideoTabDataItemMsg;

// =========================================================================

class ExternalDVDVisibililtyDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 53;
    static const ::Courier::DataItemKey cDataItemKey = 406;

    typedef ::ExternalDVDVisibililtyData Data;

    ExternalDVDVisibililtyDataBindingSource();
};

typedef ::Courier::DataItemMsg< ExternalDVDVisibililtyDataBindingSource > ExternalDVDVisibililtyDataItemMsg;

// =========================================================================

class AUXVisibilityDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 54;
    static const ::Courier::DataItemKey cDataItemKey = 267;

    typedef ::AUXVisibilityData Data;

    AUXVisibilityDataBindingSource();
};

typedef ::Courier::DataItemMsg< AUXVisibilityDataBindingSource > AUXVisibilityDataItemMsg;

// =========================================================================

class SDCardVisibilityDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 55;
    static const ::Courier::DataItemKey cDataItemKey = 413;

    typedef ::SDCardVisibilityData Data;

    SDCardVisibilityDataBindingSource();
};

typedef ::Courier::DataItemMsg< SDCardVisibilityDataBindingSource > SDCardVisibilityDataItemMsg;

// =========================================================================

class TAIconStatusDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 56;
    static const ::Courier::DataItemKey cDataItemKey = 51;

    typedef ::TAIconStatusData Data;

    TAIconStatusDataBindingSource();
};

typedef ::Courier::DataItemMsg< TAIconStatusDataBindingSource > TAIconStatusDataItemMsg;

// =========================================================================

class DeviceConnectStatusDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 18;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 57;
    static const ::Courier::DataItemKey cDataItemKey = 473;

    typedef ::DeviceConnectStatusData Data;

    DeviceConnectStatusDataBindingSource();
};

typedef ::Courier::DataItemMsg< DeviceConnectStatusDataBindingSource > DeviceConnectStatusDataItemMsg;

// =========================================================================

class ExternalDeviceConnectedDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 58;
    static const ::Courier::DataItemKey cDataItemKey = 55;

    typedef ::ExternalDeviceConnectedData Data;

    ExternalDeviceConnectedDataBindingSource();
};

typedef ::Courier::DataItemMsg< ExternalDeviceConnectedDataBindingSource > ExternalDeviceConnectedDataItemMsg;

// =========================================================================

class DBInPreparationDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 59;
    static const ::Courier::DataItemKey cDataItemKey = 169;

    typedef ::DBInPreparationData Data;

    DBInPreparationDataBindingSource();
};

typedef ::Courier::DataItemMsg< DBInPreparationDataBindingSource > DBInPreparationDataItemMsg;

// =========================================================================

class DBDownloadErrorDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 60;
    static const ::Courier::DataItemKey cDataItemKey = 275;

    typedef ::DBDownloadErrorData Data;

    DBDownloadErrorDataBindingSource();
};

typedef ::Courier::DataItemMsg< DBDownloadErrorDataBindingSource > DBDownloadErrorDataItemMsg;

// =========================================================================

class DeviceNameAndStatusDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 61;
    static const ::Courier::DataItemKey cDataItemKey = 300;

    typedef ::DeviceNameAndStatusData Data;

    DeviceNameAndStatusDataBindingSource();
};

typedef ::Courier::DataItemMsg< DeviceNameAndStatusDataBindingSource > DeviceNameAndStatusDataItemMsg;

// =========================================================================

class BrowseListSizeDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 6;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 62;
    static const ::Courier::DataItemKey cDataItemKey = 297;

    typedef ::BrowseListSizeData Data;

    BrowseListSizeDataBindingSource();
};

typedef ::Courier::DataItemMsg< BrowseListSizeDataBindingSource > BrowseListSizeDataItemMsg;

// =========================================================================

class BrowseListSelectedLineDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 6;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 63;
    static const ::Courier::DataItemKey cDataItemKey = 138;

    typedef ::BrowseListSelectedLineData Data;

    BrowseListSelectedLineDataBindingSource();
};

typedef ::Courier::DataItemMsg< BrowseListSelectedLineDataBindingSource > BrowseListSelectedLineDataItemMsg;

// =========================================================================

class Artist_AlbumListSizeDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 64;
    static const ::Courier::DataItemKey cDataItemKey = 355;

    typedef ::Artist_AlbumListSizeData Data;

    Artist_AlbumListSizeDataBindingSource();
};

typedef ::Courier::DataItemMsg< Artist_AlbumListSizeDataBindingSource > Artist_AlbumListSizeDataItemMsg;

// =========================================================================

class Artist_AlbumListSelectedLineDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 65;
    static const ::Courier::DataItemKey cDataItemKey = 477;

    typedef ::Artist_AlbumListSelectedLineData Data;

    Artist_AlbumListSelectedLineDataBindingSource();
};

typedef ::Courier::DataItemMsg< Artist_AlbumListSelectedLineDataBindingSource > Artist_AlbumListSelectedLineDataItemMsg;

// =========================================================================

class Artist_Album_TitleListSizeDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 66;
    static const ::Courier::DataItemKey cDataItemKey = 15;

    typedef ::Artist_Album_TitleListSizeData Data;

    Artist_Album_TitleListSizeDataBindingSource();
};

typedef ::Courier::DataItemMsg< Artist_Album_TitleListSizeDataBindingSource > Artist_Album_TitleListSizeDataItemMsg;

// =========================================================================

class Artist_Album_TitleListSelectedLineDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 67;
    static const ::Courier::DataItemKey cDataItemKey = 284;

    typedef ::Artist_Album_TitleListSelectedLineData Data;

    Artist_Album_TitleListSelectedLineDataBindingSource();
};

typedef ::Courier::DataItemMsg< Artist_Album_TitleListSelectedLineDataBindingSource > Artist_Album_TitleListSelectedLineDataItemMsg;

// =========================================================================

class Album_TitleListSizeDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 68;
    static const ::Courier::DataItemKey cDataItemKey = 176;

    typedef ::Album_TitleListSizeData Data;

    Album_TitleListSizeDataBindingSource();
};

typedef ::Courier::DataItemMsg< Album_TitleListSizeDataBindingSource > Album_TitleListSizeDataItemMsg;

// =========================================================================

class Album_TitleListSelectedLineDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 69;
    static const ::Courier::DataItemKey cDataItemKey = 103;

    typedef ::Album_TitleListSelectedLineData Data;

    Album_TitleListSelectedLineDataBindingSource();
};

typedef ::Courier::DataItemMsg< Album_TitleListSelectedLineDataBindingSource > Album_TitleListSelectedLineDataItemMsg;

// =========================================================================

class Title_ListSizeDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 70;
    static const ::Courier::DataItemKey cDataItemKey = 331;

    typedef ::Title_ListSizeData Data;

    Title_ListSizeDataBindingSource();
};

typedef ::Courier::DataItemMsg< Title_ListSizeDataBindingSource > Title_ListSizeDataItemMsg;

// =========================================================================

class TitleListSelectedLineDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 71;
    static const ::Courier::DataItemKey cDataItemKey = 289;

    typedef ::TitleListSelectedLineData Data;

    TitleListSelectedLineDataBindingSource();
};

typedef ::Courier::DataItemMsg< TitleListSelectedLineDataBindingSource > TitleListSelectedLineDataItemMsg;

// =========================================================================

class Genre_ArtistListSizeDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 72;
    static const ::Courier::DataItemKey cDataItemKey = 387;

    typedef ::Genre_ArtistListSizeData Data;

    Genre_ArtistListSizeDataBindingSource();
};

typedef ::Courier::DataItemMsg< Genre_ArtistListSizeDataBindingSource > Genre_ArtistListSizeDataItemMsg;

// =========================================================================

class Genre_ArtistListSelectedLineDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 73;
    static const ::Courier::DataItemKey cDataItemKey = 67;

    typedef ::Genre_ArtistListSelectedLineData Data;

    Genre_ArtistListSelectedLineDataBindingSource();
};

typedef ::Courier::DataItemMsg< Genre_ArtistListSelectedLineDataBindingSource > Genre_ArtistListSelectedLineDataItemMsg;

// =========================================================================

class Genre_AllAlbumsListSizeDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 74;
    static const ::Courier::DataItemKey cDataItemKey = 154;

    typedef ::Genre_AllAlbumsListSizeData Data;

    Genre_AllAlbumsListSizeDataBindingSource();
};

typedef ::Courier::DataItemMsg< Genre_AllAlbumsListSizeDataBindingSource > Genre_AllAlbumsListSizeDataItemMsg;

// =========================================================================

class Genre_AllAlbumsListSelectedLineDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 75;
    static const ::Courier::DataItemKey cDataItemKey = 526;

    typedef ::Genre_AllAlbumsListSelectedLineData Data;

    Genre_AllAlbumsListSelectedLineDataBindingSource();
};

typedef ::Courier::DataItemMsg< Genre_AllAlbumsListSelectedLineDataBindingSource > Genre_AllAlbumsListSelectedLineDataItemMsg;

// =========================================================================

class Genre_Artist_AlbumListSizeDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 76;
    static const ::Courier::DataItemKey cDataItemKey = 384;

    typedef ::Genre_Artist_AlbumListSizeData Data;

    Genre_Artist_AlbumListSizeDataBindingSource();
};

typedef ::Courier::DataItemMsg< Genre_Artist_AlbumListSizeDataBindingSource > Genre_Artist_AlbumListSizeDataItemMsg;

// =========================================================================

class Genre_Artist_AlbumListSelectedLineDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 77;
    static const ::Courier::DataItemKey cDataItemKey = 117;

    typedef ::Genre_Artist_AlbumListSelectedLineData Data;

    Genre_Artist_AlbumListSelectedLineDataBindingSource();
};

typedef ::Courier::DataItemMsg< Genre_Artist_AlbumListSelectedLineDataBindingSource > Genre_Artist_AlbumListSelectedLineDataItemMsg;

// =========================================================================

class Genre_TitleListSizeDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 78;
    static const ::Courier::DataItemKey cDataItemKey = 438;

    typedef ::Genre_TitleListSizeData Data;

    Genre_TitleListSizeDataBindingSource();
};

typedef ::Courier::DataItemMsg< Genre_TitleListSizeDataBindingSource > Genre_TitleListSizeDataItemMsg;

// =========================================================================

class Genre_TitleListSelectedLineDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 79;
    static const ::Courier::DataItemKey cDataItemKey = 191;

    typedef ::Genre_TitleListSelectedLineData Data;

    Genre_TitleListSelectedLineDataBindingSource();
};

typedef ::Courier::DataItemMsg< Genre_TitleListSelectedLineDataBindingSource > Genre_TitleListSelectedLineDataItemMsg;

// =========================================================================

class FastForwardRewindPopupDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 80;
    static const ::Courier::DataItemKey cDataItemKey = 66;

    typedef ::FastForwardRewindPopupData Data;

    FastForwardRewindPopupDataBindingSource();
};

typedef ::Courier::DataItemMsg< FastForwardRewindPopupDataBindingSource > FastForwardRewindPopupDataItemMsg;

// =========================================================================

class BTShuffleDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 81;
    static const ::Courier::DataItemKey cDataItemKey = 213;

    typedef ::BTShuffleData Data;

    BTShuffleDataBindingSource();
};

typedef ::Courier::DataItemMsg< BTShuffleDataBindingSource > BTShuffleDataItemMsg;

// =========================================================================

class BTRepeatDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 82;
    static const ::Courier::DataItemKey cDataItemKey = 244;

    typedef ::BTRepeatData Data;

    BTRepeatDataBindingSource();
};

typedef ::Courier::DataItemMsg< BTRepeatDataBindingSource > BTRepeatDataItemMsg;

// =========================================================================

class BTPlayInfoUpdateDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 13;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 83;
    static const ::Courier::DataItemKey cDataItemKey = 13;

    typedef ::BTPlayInfoUpdateData Data;

    BTPlayInfoUpdateDataBindingSource();
};

typedef ::Courier::DataItemMsg< BTPlayInfoUpdateDataBindingSource > BTPlayInfoUpdateDataItemMsg;

// =========================================================================

class BTSliderVisibilityDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 84;
    static const ::Courier::DataItemKey cDataItemKey = 160;

    typedef ::BTSliderVisibilityData Data;

    BTSliderVisibilityDataBindingSource();
};

typedef ::Courier::DataItemMsg< BTSliderVisibilityDataBindingSource > BTSliderVisibilityDataItemMsg;

// =========================================================================

class BTTotalTimeVisibilityDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 85;
    static const ::Courier::DataItemKey cDataItemKey = 426;

    typedef ::BTTotalTimeVisibilityData Data;

    BTTotalTimeVisibilityDataBindingSource();
};

typedef ::Courier::DataItemMsg< BTTotalTimeVisibilityDataBindingSource > BTTotalTimeVisibilityDataItemMsg;

// =========================================================================

class BTElapsedTimeVisibilityDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 86;
    static const ::Courier::DataItemKey cDataItemKey = 89;

    typedef ::BTElapsedTimeVisibilityData Data;

    BTElapsedTimeVisibilityDataBindingSource();
};

typedef ::Courier::DataItemMsg< BTElapsedTimeVisibilityDataBindingSource > BTElapsedTimeVisibilityDataItemMsg;

// =========================================================================

class ID3CoverDataDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 87;
    static const ::Courier::DataItemKey cDataItemKey = 449;

    typedef ::ID3CoverDataData Data;

    ID3CoverDataDataBindingSource();
};

typedef ::Courier::DataItemMsg< ID3CoverDataDataBindingSource > ID3CoverDataDataItemMsg;

// =========================================================================

class Audiobook_ListSizeDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 88;
    static const ::Courier::DataItemKey cDataItemKey = 100;

    typedef ::Audiobook_ListSizeData Data;

    Audiobook_ListSizeDataBindingSource();
};

typedef ::Courier::DataItemMsg< Audiobook_ListSizeDataBindingSource > Audiobook_ListSizeDataItemMsg;

// =========================================================================

class AudiobookListSelectedLineDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 89;
    static const ::Courier::DataItemKey cDataItemKey = 431;

    typedef ::AudiobookListSelectedLineData Data;

    AudiobookListSelectedLineDataBindingSource();
};

typedef ::Courier::DataItemMsg< AudiobookListSelectedLineDataBindingSource > AudiobookListSelectedLineDataItemMsg;

// =========================================================================

class AudiobookChapter_ListSizeDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 90;
    static const ::Courier::DataItemKey cDataItemKey = 219;

    typedef ::AudiobookChapter_ListSizeData Data;

    AudiobookChapter_ListSizeDataBindingSource();
};

typedef ::Courier::DataItemMsg< AudiobookChapter_ListSizeDataBindingSource > AudiobookChapter_ListSizeDataItemMsg;

// =========================================================================

class AudiobookChapterListSelectedLineDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 91;
    static const ::Courier::DataItemKey cDataItemKey = 33;

    typedef ::AudiobookChapterListSelectedLineData Data;

    AudiobookChapterListSelectedLineDataBindingSource();
};

typedef ::Courier::DataItemMsg< AudiobookChapterListSelectedLineDataBindingSource > AudiobookChapterListSelectedLineDataItemMsg;

// =========================================================================

class Playlist_ListSizeDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 92;
    static const ::Courier::DataItemKey cDataItemKey = 194;

    typedef ::Playlist_ListSizeData Data;

    Playlist_ListSizeDataBindingSource();
};

typedef ::Courier::DataItemMsg< Playlist_ListSizeDataBindingSource > Playlist_ListSizeDataItemMsg;

// =========================================================================

class PlaylistListSelectedLineDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 93;
    static const ::Courier::DataItemKey cDataItemKey = 469;

    typedef ::PlaylistListSelectedLineData Data;

    PlaylistListSelectedLineDataBindingSource();
};

typedef ::Courier::DataItemMsg< PlaylistListSelectedLineDataBindingSource > PlaylistListSelectedLineDataItemMsg;

// =========================================================================

class PlaylistTitle_ListSizeDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 94;
    static const ::Courier::DataItemKey cDataItemKey = 385;

    typedef ::PlaylistTitle_ListSizeData Data;

    PlaylistTitle_ListSizeDataBindingSource();
};

typedef ::Courier::DataItemMsg< PlaylistTitle_ListSizeDataBindingSource > PlaylistTitle_ListSizeDataItemMsg;

// =========================================================================

class PlaylistTitleListSelectedLineDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 95;
    static const ::Courier::DataItemKey cDataItemKey = 224;

    typedef ::PlaylistTitleListSelectedLineData Data;

    PlaylistTitleListSelectedLineDataBindingSource();
};

typedef ::Courier::DataItemMsg< PlaylistTitleListSelectedLineDataBindingSource > PlaylistTitleListSelectedLineDataItemMsg;

// =========================================================================

class Podcast_EpisodeListSizeDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 96;
    static const ::Courier::DataItemKey cDataItemKey = 259;

    typedef ::Podcast_EpisodeListSizeData Data;

    Podcast_EpisodeListSizeDataBindingSource();
};

typedef ::Courier::DataItemMsg< Podcast_EpisodeListSizeDataBindingSource > Podcast_EpisodeListSizeDataItemMsg;

// =========================================================================

class Podcast_EpisodeListSelectedLineDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 97;
    static const ::Courier::DataItemKey cDataItemKey = 162;

    typedef ::Podcast_EpisodeListSelectedLineData Data;

    Podcast_EpisodeListSelectedLineDataBindingSource();
};

typedef ::Courier::DataItemMsg< Podcast_EpisodeListSelectedLineDataBindingSource > Podcast_EpisodeListSelectedLineDataItemMsg;

// =========================================================================

class Video_EpisodeListSizeDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 98;
    static const ::Courier::DataItemKey cDataItemKey = 178;

    typedef ::Video_EpisodeListSizeData Data;

    Video_EpisodeListSizeDataBindingSource();
};

typedef ::Courier::DataItemMsg< Video_EpisodeListSizeDataBindingSource > Video_EpisodeListSizeDataItemMsg;

// =========================================================================

class Video_EpisodeListSelectedLineDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 99;
    static const ::Courier::DataItemKey cDataItemKey = 174;

    typedef ::Video_EpisodeListSelectedLineData Data;

    Video_EpisodeListSelectedLineDataBindingSource();
};

typedef ::Courier::DataItemMsg< Video_EpisodeListSelectedLineDataBindingSource > Video_EpisodeListSelectedLineDataItemMsg;

// =========================================================================

class Folder_ListSizeDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 100;
    static const ::Courier::DataItemKey cDataItemKey = 291;

    typedef ::Folder_ListSizeData Data;

    Folder_ListSizeDataBindingSource();
};

typedef ::Courier::DataItemMsg< Folder_ListSizeDataBindingSource > Folder_ListSizeDataItemMsg;

// =========================================================================

class Folder_ListSelectedLineDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 101;
    static const ::Courier::DataItemKey cDataItemKey = 274;

    typedef ::Folder_ListSelectedLineData Data;

    Folder_ListSelectedLineDataBindingSource();
};

typedef ::Courier::DataItemMsg< Folder_ListSelectedLineDataBindingSource > Folder_ListSelectedLineDataItemMsg;

// =========================================================================

class FolderFile_ListSizeDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 102;
    static const ::Courier::DataItemKey cDataItemKey = 392;

    typedef ::FolderFile_ListSizeData Data;

    FolderFile_ListSizeDataBindingSource();
};

typedef ::Courier::DataItemMsg< FolderFile_ListSizeDataBindingSource > FolderFile_ListSizeDataItemMsg;

// =========================================================================

class FolderFile_ListSelectedLineDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 103;
    static const ::Courier::DataItemKey cDataItemKey = 127;

    typedef ::FolderFile_ListSelectedLineData Data;

    FolderFile_ListSelectedLineDataBindingSource();
};

typedef ::Courier::DataItemMsg< FolderFile_ListSelectedLineDataBindingSource > FolderFile_ListSelectedLineDataItemMsg;

// =========================================================================

class Folder_NameDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 104;
    static const ::Courier::DataItemKey cDataItemKey = 525;

    typedef ::Folder_NameData Data;

    Folder_NameDataBindingSource();
};

typedef ::Courier::DataItemMsg< Folder_NameDataBindingSource > Folder_NameDataItemMsg;

// =========================================================================

class NotebookdataDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 105;
    static const ::Courier::DataItemKey cDataItemKey = 458;

    typedef ::NotebookdataData Data;

    NotebookdataDataBindingSource();
};

typedef ::Courier::DataItemMsg< NotebookdataDataBindingSource > NotebookdataDataItemMsg;

// =========================================================================

class TabNextPrevIndexDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 5;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 106;
    static const ::Courier::DataItemKey cDataItemKey = 280;

    typedef ::TabNextPrevIndexData Data;

    TabNextPrevIndexDataBindingSource();
};

typedef ::Courier::DataItemMsg< TabNextPrevIndexDataBindingSource > TabNextPrevIndexDataItemMsg;

// =========================================================================

class ListstatusDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 25;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 107;
    static const ::Courier::DataItemKey cDataItemKey = 361;

    typedef ::ListstatusData Data;

    ListstatusDataBindingSource();
};

typedef ::Courier::DataItemMsg< ListstatusDataBindingSource > ListstatusDataItemMsg;

// =========================================================================

class SDRepeatOptionDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 108;
    static const ::Courier::DataItemKey cDataItemKey = 129;

    typedef ::SDRepeatOptionData Data;

    SDRepeatOptionDataBindingSource();
};

typedef ::Courier::DataItemMsg< SDRepeatOptionDataBindingSource > SDRepeatOptionDataItemMsg;

// =========================================================================

class USBRepeatOptionDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 109;
    static const ::Courier::DataItemKey cDataItemKey = 97;

    typedef ::USBRepeatOptionData Data;

    USBRepeatOptionDataBindingSource();
};

typedef ::Courier::DataItemMsg< USBRepeatOptionDataBindingSource > USBRepeatOptionDataItemMsg;

// =========================================================================

class USBCameraPortRepeatOptionDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 110;
    static const ::Courier::DataItemKey cDataItemKey = 111;

    typedef ::USBCameraPortRepeatOptionData Data;

    USBCameraPortRepeatOptionDataBindingSource();
};

typedef ::Courier::DataItemMsg< USBCameraPortRepeatOptionDataBindingSource > USBCameraPortRepeatOptionDataItemMsg;

// =========================================================================

class USBRouterRepeatOptionDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 111;
    static const ::Courier::DataItemKey cDataItemKey = 315;

    typedef ::USBRouterRepeatOptionData Data;

    USBRouterRepeatOptionDataBindingSource();
};

typedef ::Courier::DataItemMsg< USBRouterRepeatOptionDataBindingSource > USBRouterRepeatOptionDataItemMsg;

// =========================================================================

class BTRepeatOptionDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 112;
    static const ::Courier::DataItemKey cDataItemKey = 340;

    typedef ::BTRepeatOptionData Data;

    BTRepeatOptionDataBindingSource();
};

typedef ::Courier::DataItemMsg< BTRepeatOptionDataBindingSource > BTRepeatOptionDataItemMsg;

// =========================================================================

class AppleRepeatOptionDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 113;
    static const ::Courier::DataItemKey cDataItemKey = 202;

    typedef ::AppleRepeatOptionData Data;

    AppleRepeatOptionDataBindingSource();
};

typedef ::Courier::DataItemMsg< AppleRepeatOptionDataBindingSource > AppleRepeatOptionDataItemMsg;

// =========================================================================

class SDShuffleOptionDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 114;
    static const ::Courier::DataItemKey cDataItemKey = 95;

    typedef ::SDShuffleOptionData Data;

    SDShuffleOptionDataBindingSource();
};

typedef ::Courier::DataItemMsg< SDShuffleOptionDataBindingSource > SDShuffleOptionDataItemMsg;

// =========================================================================

class USBShuffleOptionDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 115;
    static const ::Courier::DataItemKey cDataItemKey = 49;

    typedef ::USBShuffleOptionData Data;

    USBShuffleOptionDataBindingSource();
};

typedef ::Courier::DataItemMsg< USBShuffleOptionDataBindingSource > USBShuffleOptionDataItemMsg;

// =========================================================================

class USBCameraPortShuffleOptionDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 116;
    static const ::Courier::DataItemKey cDataItemKey = 344;

    typedef ::USBCameraPortShuffleOptionData Data;

    USBCameraPortShuffleOptionDataBindingSource();
};

typedef ::Courier::DataItemMsg< USBCameraPortShuffleOptionDataBindingSource > USBCameraPortShuffleOptionDataItemMsg;

// =========================================================================

class USBRouterShuffleOptionDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 117;
    static const ::Courier::DataItemKey cDataItemKey = 57;

    typedef ::USBRouterShuffleOptionData Data;

    USBRouterShuffleOptionDataBindingSource();
};

typedef ::Courier::DataItemMsg< USBRouterShuffleOptionDataBindingSource > USBRouterShuffleOptionDataItemMsg;

// =========================================================================

class USBPlayPauseOptionDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 118;
    static const ::Courier::DataItemKey cDataItemKey = 87;

    typedef ::USBPlayPauseOptionData Data;

    USBPlayPauseOptionDataBindingSource();
};

typedef ::Courier::DataItemMsg< USBPlayPauseOptionDataBindingSource > USBPlayPauseOptionDataItemMsg;

// =========================================================================

class USBCameraPortPlayPauseOptionDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 119;
    static const ::Courier::DataItemKey cDataItemKey = 479;

    typedef ::USBCameraPortPlayPauseOptionData Data;

    USBCameraPortPlayPauseOptionDataBindingSource();
};

typedef ::Courier::DataItemMsg< USBCameraPortPlayPauseOptionDataBindingSource > USBCameraPortPlayPauseOptionDataItemMsg;

// =========================================================================

class USBRouterPlayPauseOptionDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 120;
    static const ::Courier::DataItemKey cDataItemKey = 273;

    typedef ::USBRouterPlayPauseOptionData Data;

    USBRouterPlayPauseOptionDataBindingSource();
};

typedef ::Courier::DataItemMsg< USBRouterPlayPauseOptionDataBindingSource > USBRouterPlayPauseOptionDataItemMsg;

// =========================================================================

class ApplePlayPauseOptionDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 121;
    static const ::Courier::DataItemKey cDataItemKey = 474;

    typedef ::ApplePlayPauseOptionData Data;

    ApplePlayPauseOptionDataBindingSource();
};

typedef ::Courier::DataItemMsg< ApplePlayPauseOptionDataBindingSource > ApplePlayPauseOptionDataItemMsg;

// =========================================================================

class BTPlayPauseOptionDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 122;
    static const ::Courier::DataItemKey cDataItemKey = 216;

    typedef ::BTPlayPauseOptionData Data;

    BTPlayPauseOptionDataBindingSource();
};

typedef ::Courier::DataItemMsg< BTPlayPauseOptionDataBindingSource > BTPlayPauseOptionDataItemMsg;

// =========================================================================

class BTShuffleOptionDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 123;
    static const ::Courier::DataItemKey cDataItemKey = 269;

    typedef ::BTShuffleOptionData Data;

    BTShuffleOptionDataBindingSource();
};

typedef ::Courier::DataItemMsg< BTShuffleOptionDataBindingSource > BTShuffleOptionDataItemMsg;

// =========================================================================

class AppleShuffleOptionDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 124;
    static const ::Courier::DataItemKey cDataItemKey = 24;

    typedef ::AppleShuffleOptionData Data;

    AppleShuffleOptionDataBindingSource();
};

typedef ::Courier::DataItemMsg< AppleShuffleOptionDataBindingSource > AppleShuffleOptionDataItemMsg;

// =========================================================================

class SPIConnectionTypeDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 125;
    static const ::Courier::DataItemKey cDataItemKey = 31;

    typedef ::SPIConnectionTypeData Data;

    SPIConnectionTypeDataBindingSource();
};

typedef ::Courier::DataItemMsg< SPIConnectionTypeDataBindingSource > SPIConnectionTypeDataItemMsg;

// =========================================================================

class AuxFeatureControllerDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 126;
    static const ::Courier::DataItemKey cDataItemKey = 82;

    typedef ::AuxFeatureControllerData Data;

    AuxFeatureControllerDataBindingSource();
};

typedef ::Courier::DataItemMsg< AuxFeatureControllerDataBindingSource > AuxFeatureControllerDataItemMsg;

// =========================================================================

class MediaListIDDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 127;
    static const ::Courier::DataItemKey cDataItemKey = 528;

    typedef ::MediaListIDData Data;

    MediaListIDDataBindingSource();
};

typedef ::Courier::DataItemMsg< MediaListIDDataBindingSource > MediaListIDDataItemMsg;

// =========================================================================

class MediaTabActiveStateDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 10;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 128;
    static const ::Courier::DataItemKey cDataItemKey = 81;

    typedef ::MediaTabActiveStateData Data;

    MediaTabActiveStateDataBindingSource();
};

typedef ::Courier::DataItemMsg< MediaTabActiveStateDataBindingSource > MediaTabActiveStateDataItemMsg;

// =========================================================================

class VideoTabActivationDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 129;
    static const ::Courier::DataItemKey cDataItemKey = 207;

    typedef ::VideoTabActivationData Data;

    VideoTabActivationDataBindingSource();
};

typedef ::Courier::DataItemMsg< VideoTabActivationDataBindingSource > VideoTabActivationDataItemMsg;

// =========================================================================

class USBCameraPortAlbumVisibilityDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 130;
    static const ::Courier::DataItemKey cDataItemKey = 79;

    typedef ::USBCameraPortAlbumVisibilityData Data;

    USBCameraPortAlbumVisibilityDataBindingSource();
};

typedef ::Courier::DataItemMsg< USBCameraPortAlbumVisibilityDataBindingSource > USBCameraPortAlbumVisibilityDataItemMsg;

// =========================================================================

class USBRouterAlbumVisibilityDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 131;
    static const ::Courier::DataItemKey cDataItemKey = 229;

    typedef ::USBRouterAlbumVisibilityData Data;

    USBRouterAlbumVisibilityDataBindingSource();
};

typedef ::Courier::DataItemMsg< USBRouterAlbumVisibilityDataBindingSource > USBRouterAlbumVisibilityDataItemMsg;

// =========================================================================

class AuxActivationDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 132;
    static const ::Courier::DataItemKey cDataItemKey = 305;

    typedef ::AuxActivationData Data;

    AuxActivationDataBindingSource();
};

typedef ::Courier::DataItemMsg< AuxActivationDataBindingSource > AuxActivationDataItemMsg;

// =========================================================================

class FolderListDataItemDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 133;
    static const ::Courier::DataItemKey cDataItemKey = 345;

    typedef ::FolderListDataItemData Data;

    FolderListDataItemDataBindingSource();
};

typedef ::Courier::DataItemMsg< FolderListDataItemDataBindingSource > FolderListDataItemDataItemMsg;

// =========================================================================

class DownloadVisibilityDataItemDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 134;
    static const ::Courier::DataItemKey cDataItemKey = 467;

    typedef ::DownloadVisibilityDataItemData Data;

    DownloadVisibilityDataItemDataBindingSource();
};

typedef ::Courier::DataItemMsg< DownloadVisibilityDataItemDataBindingSource > DownloadVisibilityDataItemDataItemMsg;

// =========================================================================

class FolderFileListDataItemDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 135;
    static const ::Courier::DataItemKey cDataItemKey = 26;

    typedef ::FolderFileListDataItemData Data;

    FolderFileListDataItemDataBindingSource();
};

typedef ::Courier::DataItemMsg< FolderFileListDataItemDataBindingSource > FolderFileListDataItemDataItemMsg;

// =========================================================================

class BrowseTextChangeDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 136;
    static const ::Courier::DataItemKey cDataItemKey = 296;

    typedef ::BrowseTextChangeData Data;

    BrowseTextChangeDataBindingSource();
};

typedef ::Courier::DataItemMsg< BrowseTextChangeDataBindingSource > BrowseTextChangeDataItemMsg;

// =========================================================================

class ExternalBrowseTextInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 137;
    static const ::Courier::DataItemKey cDataItemKey = 98;

    typedef ::ExternalBrowseTextInfoData Data;

    ExternalBrowseTextInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< ExternalBrowseTextInfoDataBindingSource > ExternalBrowseTextInfoDataItemMsg;

// =========================================================================

class BrowserScreenListSizeDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 12;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 138;
    static const ::Courier::DataItemKey cDataItemKey = 68;

    typedef ::BrowserScreenListSizeData Data;

    BrowserScreenListSizeDataBindingSource();
};

typedef ::Courier::DataItemMsg< BrowserScreenListSizeDataBindingSource > BrowserScreenListSizeDataItemMsg;

// =========================================================================

class BrowseListInfoTextDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 139;
    static const ::Courier::DataItemKey cDataItemKey = 232;

    typedef ::BrowseListInfoTextData Data;

    BrowseListInfoTextDataBindingSource();
};

typedef ::Courier::DataItemMsg< BrowseListInfoTextDataBindingSource > BrowseListInfoTextDataItemMsg;

// =========================================================================

class MediaTabDisabledStateDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 7;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 140;
    static const ::Courier::DataItemKey cDataItemKey = 471;

    typedef ::MediaTabDisabledStateData Data;

    MediaTabDisabledStateDataBindingSource();
};

typedef ::Courier::DataItemMsg< MediaTabDisabledStateDataBindingSource > MediaTabDisabledStateDataItemMsg;

// =========================================================================

class MuteStateVisibleGadgetDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 5;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 141;
    static const ::Courier::DataItemKey cDataItemKey = 25;

    typedef ::MuteStateVisibleGadgetData Data;

    MuteStateVisibleGadgetDataBindingSource();
};

typedef ::Courier::DataItemMsg< MuteStateVisibleGadgetDataBindingSource > MuteStateVisibleGadgetDataItemMsg;

// =========================================================================

class MediaSourceUpdateInGadgetDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 142;
    static const ::Courier::DataItemKey cDataItemKey = 73;

    typedef ::MediaSourceUpdateInGadgetData Data;

    MediaSourceUpdateInGadgetDataBindingSource();
};

typedef ::Courier::DataItemMsg< MediaSourceUpdateInGadgetDataBindingSource > MediaSourceUpdateInGadgetDataItemMsg;

// =========================================================================

class MediaMetaDataUpdateInGadgetDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 143;
    static const ::Courier::DataItemKey cDataItemKey = 245;

    typedef ::MediaMetaDataUpdateInGadgetData Data;

    MediaMetaDataUpdateInGadgetDataBindingSource();
};

typedef ::Courier::DataItemMsg< MediaMetaDataUpdateInGadgetDataBindingSource > MediaMetaDataUpdateInGadgetDataItemMsg;

// =========================================================================

class PlaybackActionGadgetDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 7;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 144;
    static const ::Courier::DataItemKey cDataItemKey = 247;

    typedef ::PlaybackActionGadgetData Data;

    PlaybackActionGadgetDataBindingSource();
};

typedef ::Courier::DataItemMsg< PlaybackActionGadgetDataBindingSource > PlaybackActionGadgetDataItemMsg;

// =========================================================================

class PlaybackActionCabinAGadgetDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 7;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 145;
    static const ::Courier::DataItemKey cDataItemKey = 454;

    typedef ::PlaybackActionCabinAGadgetData Data;

    PlaybackActionCabinAGadgetDataBindingSource();
};

typedef ::Courier::DataItemMsg< PlaybackActionCabinAGadgetDataBindingSource > PlaybackActionCabinAGadgetDataItemMsg;

// =========================================================================

class PlaybackActionRouterGadgetDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 7;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 146;
    static const ::Courier::DataItemKey cDataItemKey = 376;

    typedef ::PlaybackActionRouterGadgetData Data;

    PlaybackActionRouterGadgetDataBindingSource();
};

typedef ::Courier::DataItemMsg< PlaybackActionRouterGadgetDataBindingSource > PlaybackActionRouterGadgetDataItemMsg;

// =========================================================================

class GadgetItemVisibilityStateDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 5;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 147;
    static const ::Courier::DataItemKey cDataItemKey = 142;

    typedef ::GadgetItemVisibilityStateData Data;

    GadgetItemVisibilityStateDataBindingSource();
};

typedef ::Courier::DataItemMsg< GadgetItemVisibilityStateDataBindingSource > GadgetItemVisibilityStateDataItemMsg;

// =========================================================================

class GadgetPlayPauseOptionDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 148;
    static const ::Courier::DataItemKey cDataItemKey = 425;

    typedef ::GadgetPlayPauseOptionData Data;

    GadgetPlayPauseOptionDataBindingSource();
};

typedef ::Courier::DataItemMsg< GadgetPlayPauseOptionDataBindingSource > GadgetPlayPauseOptionDataItemMsg;

// =========================================================================

class MediaSourceUSBNameInGadgetDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 149;
    static const ::Courier::DataItemKey cDataItemKey = 393;

    typedef ::MediaSourceUSBNameInGadgetData Data;

    MediaSourceUSBNameInGadgetDataBindingSource();
};

typedef ::Courier::DataItemMsg< MediaSourceUSBNameInGadgetDataBindingSource > MediaSourceUSBNameInGadgetDataItemMsg;

// =========================================================================

class CamportUSBGadgetPlayPauseOptionDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 150;
    static const ::Courier::DataItemKey cDataItemKey = 32;

    typedef ::CamportUSBGadgetPlayPauseOptionData Data;

    CamportUSBGadgetPlayPauseOptionDataBindingSource();
};

typedef ::Courier::DataItemMsg< CamportUSBGadgetPlayPauseOptionDataBindingSource > CamportUSBGadgetPlayPauseOptionDataItemMsg;

// =========================================================================

class RouterUSBGadgetPlayPauseOptionDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 151;
    static const ::Courier::DataItemKey cDataItemKey = 75;

    typedef ::RouterUSBGadgetPlayPauseOptionData Data;

    RouterUSBGadgetPlayPauseOptionDataBindingSource();
};

typedef ::Courier::DataItemMsg< RouterUSBGadgetPlayPauseOptionDataBindingSource > RouterUSBGadgetPlayPauseOptionDataItemMsg;

// =========================================================================

class ListScrollBarInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 152;
    static const ::Courier::DataItemKey cDataItemKey = 148;

    typedef ::ListScrollBarInfoData Data;

    ListScrollBarInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< ListScrollBarInfoDataBindingSource > ListScrollBarInfoDataItemMsg;

namespace ItemKey {
        static const ::Courier::DataItemKey InvalidItem = 0;
        static const ::Courier::DataItemKey BTPlayInfoUpdateItem = 13;
        static const ::Courier::DataItemKey Artist_Album_TitleListSizeItem = 15;
        static const ::Courier::DataItemKey AppleShuffleOptionItem = 24;
        static const ::Courier::DataItemKey MuteStateVisibleGadgetItem = 25;
        static const ::Courier::DataItemKey FolderFileListDataItemItem = 26;
        static const ::Courier::DataItemKey VariantInfoItem = 30;
        static const ::Courier::DataItemKey SPIConnectionTypeItem = 31;
        static const ::Courier::DataItemKey CamportUSBGadgetPlayPauseOptionItem = 32;
        static const ::Courier::DataItemKey AudiobookChapterListSelectedLineItem = 33;
        static const ::Courier::DataItemKey AlbumListItemItem = 35;
        static const ::Courier::DataItemKey USB2VisibilityItem = 39;
        static const ::Courier::DataItemKey MuteInfoItem = 43;
        static const ::Courier::DataItemKey VideoTabItem = 47;
        static const ::Courier::DataItemKey USBShuffleOptionItem = 49;
        static const ::Courier::DataItemKey TAIconStatusItem = 51;
        static const ::Courier::DataItemKey ExternalDeviceConnectedItem = 55;
        static const ::Courier::DataItemKey USBRouterShuffleOptionItem = 57;
        static const ::Courier::DataItemKey FastForwardRewindPopupItem = 66;
        static const ::Courier::DataItemKey Genre_ArtistListSelectedLineItem = 67;
        static const ::Courier::DataItemKey BrowserScreenListSizeItem = 68;
        static const ::Courier::DataItemKey MediaSourceUpdateInGadgetItem = 73;
        static const ::Courier::DataItemKey RouterUSBGadgetPlayPauseOptionItem = 75;
        static const ::Courier::DataItemKey ExternalDVDButtonItem = 78;
        static const ::Courier::DataItemKey USBCameraPortAlbumVisibilityItem = 79;
        static const ::Courier::DataItemKey MediaTabActiveStateItem = 81;
        static const ::Courier::DataItemKey AuxFeatureControllerItem = 82;
        static const ::Courier::DataItemKey GenreTabItem = 85;
        static const ::Courier::DataItemKey USBPlayPauseOptionItem = 87;
        static const ::Courier::DataItemKey BTElapsedTimeVisibilityItem = 89;
        static const ::Courier::DataItemKey VideoPlaybackActionItem = 90;
        static const ::Courier::DataItemKey SDShuffleOptionItem = 95;
        static const ::Courier::DataItemKey USBRepeatOptionItem = 97;
        static const ::Courier::DataItemKey ExternalBrowseTextInfoItem = 98;
        static const ::Courier::DataItemKey Audiobook_ListSizeItem = 100;
        static const ::Courier::DataItemKey Album_TitleListSelectedLineItem = 103;
        static const ::Courier::DataItemKey AUXStatusItem = 105;
        static const ::Courier::DataItemKey ID3CoverDataForRouterUSBItem = 106;
        static const ::Courier::DataItemKey USBCameraPortRepeatOptionItem = 111;
        static const ::Courier::DataItemKey Camport1USBButtonItem = 115;
        static const ::Courier::DataItemKey Genre_Artist_AlbumListSelectedLineItem = 117;
        static const ::Courier::DataItemKey ExternalMediaSourceItem = 126;
        static const ::Courier::DataItemKey FolderFile_ListSelectedLineItem = 127;
        static const ::Courier::DataItemKey SDRepeatOptionItem = 129;
        static const ::Courier::DataItemKey ID3CoverDataForAppleItem = 131;
        static const ::Courier::DataItemKey BrowseListSelectedLineItem = 138;
        static const ::Courier::DataItemKey GadgetItemVisibilityStateItem = 142;
        static const ::Courier::DataItemKey SDCardStatusItem = 144;
        static const ::Courier::DataItemKey ID3CoverDataForRouterUSBGadgetItem = 147;
        static const ::Courier::DataItemKey ListScrollBarInfoItem = 148;
        static const ::Courier::DataItemKey Genre_AllAlbumsListSizeItem = 154;
        static const ::Courier::DataItemKey ID3CoverDataForBTItem = 157;
        static const ::Courier::DataItemKey BTSliderVisibilityItem = 160;
        static const ::Courier::DataItemKey Podcast_EpisodeListSelectedLineItem = 162;
        static const ::Courier::DataItemKey VideoPlayerFullScreeenItem = 168;
        static const ::Courier::DataItemKey DBInPreparationItem = 169;
        static const ::Courier::DataItemKey Camport1HDMIButtonItem = 170;
        static const ::Courier::DataItemKey Video_EpisodeListSelectedLineItem = 174;
        static const ::Courier::DataItemKey Album_TitleListSizeItem = 176;
        static const ::Courier::DataItemKey Video_EpisodeListSizeItem = 178;
        static const ::Courier::DataItemKey AppleDeviceItem = 188;
        static const ::Courier::DataItemKey USB1ButtonItem = 189;
        static const ::Courier::DataItemKey Genre_TitleListSelectedLineItem = 191;
        static const ::Courier::DataItemKey Playlist_ListSizeItem = 194;
        static const ::Courier::DataItemKey AppleRepeatOptionItem = 202;
        static const ::Courier::DataItemKey SDCardDeviceItem = 203;
        static const ::Courier::DataItemKey VideoTabActivationItem = 207;
        static const ::Courier::DataItemKey BTShuffleItem = 213;
        static const ::Courier::DataItemKey PodcastTabItem = 214;
        static const ::Courier::DataItemKey PlaybackActionItem = 215;
        static const ::Courier::DataItemKey BTPlayPauseOptionItem = 216;
        static const ::Courier::DataItemKey AudiobookChapter_ListSizeItem = 219;
        static const ::Courier::DataItemKey PlaylistTabItem = 223;
        static const ::Courier::DataItemKey PlaylistTitleListSelectedLineItem = 224;
        static const ::Courier::DataItemKey USB2ButtonItem = 227;
        static const ::Courier::DataItemKey USBRouterAlbumVisibilityItem = 229;
        static const ::Courier::DataItemKey BrowseListInfoTextItem = 232;
        static const ::Courier::DataItemKey BTRepeatItem = 244;
        static const ::Courier::DataItemKey MediaMetaDataUpdateInGadgetItem = 245;
        static const ::Courier::DataItemKey PlaybackActionGadgetItem = 247;
        static const ::Courier::DataItemKey Podcast_EpisodeListSizeItem = 259;
        static const ::Courier::DataItemKey ID3CoverDataForGadgetItem = 265;
        static const ::Courier::DataItemKey AUXVisibilityItem = 267;
        static const ::Courier::DataItemKey BTShuffleOptionItem = 269;
        static const ::Courier::DataItemKey USBRouterPlayPauseOptionItem = 273;
        static const ::Courier::DataItemKey Folder_ListSelectedLineItem = 274;
        static const ::Courier::DataItemKey DBDownloadErrorItem = 275;
        static const ::Courier::DataItemKey TabNextPrevIndexItem = 280;
        static const ::Courier::DataItemKey Artist_Album_TitleListSelectedLineItem = 284;
        static const ::Courier::DataItemKey FolderTabItem = 288;
        static const ::Courier::DataItemKey TitleListSelectedLineItem = 289;
        static const ::Courier::DataItemKey Folder_ListSizeItem = 291;
        static const ::Courier::DataItemKey BrowseTextChangeItem = 296;
        static const ::Courier::DataItemKey BrowseListSizeItem = 297;
        static const ::Courier::DataItemKey DeviceNameAndStatusItem = 300;
        static const ::Courier::DataItemKey BTVisibilityItem = 301;
        static const ::Courier::DataItemKey ExternalDVDStatusItem = 304;
        static const ::Courier::DataItemKey AuxActivationItem = 305;
        static const ::Courier::DataItemKey BTButtonItem = 311;
        static const ::Courier::DataItemKey USBRouterRepeatOptionItem = 315;
        static const ::Courier::DataItemKey ArtistTabItem = 325;
        static const ::Courier::DataItemKey IconsVisibilityItem = 326;
        static const ::Courier::DataItemKey MuteInfoforAuxItem = 329;
        static const ::Courier::DataItemKey Title_ListSizeItem = 331;
        static const ::Courier::DataItemKey USBCameraPortPlaybackActionItem = 339;
        static const ::Courier::DataItemKey BTRepeatOptionItem = 340;
        static const ::Courier::DataItemKey USBCameraPortShuffleOptionItem = 344;
        static const ::Courier::DataItemKey FolderListDataItemItem = 345;
        static const ::Courier::DataItemKey Artist_AlbumListSizeItem = 355;
        static const ::Courier::DataItemKey ID3CoverDataForCamportUSBGadgetItem = 360;
        static const ::Courier::DataItemKey ListstatusItem = 361;
        static const ::Courier::DataItemKey IpodButtonItem = 369;
        static const ::Courier::DataItemKey PlaybackActionRouterGadgetItem = 376;
        static const ::Courier::DataItemKey Genre_Artist_AlbumListSizeItem = 384;
        static const ::Courier::DataItemKey PlaylistTitle_ListSizeItem = 385;
        static const ::Courier::DataItemKey Genre_ArtistListSizeItem = 387;
        static const ::Courier::DataItemKey FolderFile_ListSizeItem = 392;
        static const ::Courier::DataItemKey MediaSourceUSBNameInGadgetItem = 393;
        static const ::Courier::DataItemKey TAStatusItem = 394;
        static const ::Courier::DataItemKey USBRouterPlaybackActionItem = 400;
        static const ::Courier::DataItemKey TabVideoSourceItem = 401;
        static const ::Courier::DataItemKey USBButtonItem = 404;
        static const ::Courier::DataItemKey ExternalDVDVisibililtyItem = 406;
        static const ::Courier::DataItemKey SDCardVisibilityItem = 413;
        static const ::Courier::DataItemKey GadgetPlayPauseOptionItem = 425;
        static const ::Courier::DataItemKey BTTotalTimeVisibilityItem = 426;
        static const ::Courier::DataItemKey BTNowplayIconsItem = 429;
        static const ::Courier::DataItemKey AudiobookListSelectedLineItem = 431;
        static const ::Courier::DataItemKey AlbumTabItem = 435;
        static const ::Courier::DataItemKey Genre_TitleListSizeItem = 438;
        static const ::Courier::DataItemKey NavigationVarientTypeItem = 441;
        static const ::Courier::DataItemKey ID3CoverDataForCamportUSBItem = 443;
        static const ::Courier::DataItemKey TitleTabItem = 446;
        static const ::Courier::DataItemKey AudiobookTabItem = 447;
        static const ::Courier::DataItemKey ID3CoverDataItem = 449;
        static const ::Courier::DataItemKey ID3CoverDataForSDCardItem = 452;
        static const ::Courier::DataItemKey PlaybackActionCabinAGadgetItem = 454;
        static const ::Courier::DataItemKey IconsItem = 456;
        static const ::Courier::DataItemKey NotebookdataItem = 458;
        static const ::Courier::DataItemKey AuxButtonItem = 465;
        static const ::Courier::DataItemKey DownloadVisibilityDataItemItem = 467;
        static const ::Courier::DataItemKey PlaylistListSelectedLineItem = 469;
        static const ::Courier::DataItemKey MediaTabDisabledStateItem = 471;
        static const ::Courier::DataItemKey DeviceConnectStatusItem = 473;
        static const ::Courier::DataItemKey ApplePlayPauseOptionItem = 474;
        static const ::Courier::DataItemKey Artist_AlbumListSelectedLineItem = 477;
        static const ::Courier::DataItemKey USBCameraPortPlayPauseOptionItem = 479;
        static const ::Courier::DataItemKey DeviceConnectionItem = 512;
        static const ::Courier::DataItemKey SDCardButtonItem = 517;
        static const ::Courier::DataItemKey Folder_NameItem = 525;
        static const ::Courier::DataItemKey Genre_AllAlbumsListSelectedLineItem = 526;
        static const ::Courier::DataItemKey SPIVisibilityItem = 527;
        static const ::Courier::DataItemKey MediaListIDItem = 528;

    namespace BTPlayInfoUpdate {
            static const ::Courier::DataItemKey SourceNameItem = 119;
            static const ::Courier::DataItemKey ArtistNameItem = 180;
            static const ::Courier::DataItemKey TitleNameItem = 430;
            static const ::Courier::DataItemKey AlbumNameItem = 343;
            static const ::Courier::DataItemKey CurrentTrackNoItem = 200;
            static const ::Courier::DataItemKey TotalTrackNoItem = 407;
            static const ::Courier::DataItemKey TotalTimeItem = 351;
            static const ::Courier::DataItemKey ElapsedTimeItem = 112;
            static const ::Courier::DataItemKey SliderTotalTimeItem = 83;
            static const ::Courier::DataItemKey SliderElapsedTimeItem = 412;
            static const ::Courier::DataItemKey DragCurrentValueItem = 287;
            static const ::Courier::DataItemKey PlayIconNameItem = 420;
    } // namespace BTPlayInfoUpdate

    namespace Artist_Album_TitleListSize {
            static const ::Courier::DataItemKey ArtistAlbumTitleWindowListSizeItem = 478;
    } // namespace Artist_Album_TitleListSize

    namespace AppleShuffleOption {
            static const ::Courier::DataItemKey ShuffleOffItem = 363;
            static const ::Courier::DataItemKey ShuffleOnItem = 327;
            static const ::Courier::DataItemKey ShuffleIndexItem = 490;
    } // namespace AppleShuffleOption

    namespace MuteStateVisibleGadget {
            static const ::Courier::DataItemKey MuteImageVisibilityItem = 402;
            static const ::Courier::DataItemKey PlayEnableIconVisibleItem = 364;
            static const ::Courier::DataItemKey ControlIconStatusItem = 263;
            static const ::Courier::DataItemKey PlayDisableIconVisibleItem = 155;
    } // namespace MuteStateVisibleGadget

    namespace FolderFileListDataItem {
            static const ::Courier::DataItemKey FolderFileIconImageIndexItem = 243;
    } // namespace FolderFileListDataItem

    namespace VariantInfo {
            static const ::Courier::DataItemKey TA_SettingsItem = 415;
    } // namespace VariantInfo

    namespace SPIConnectionType {
            static const ::Courier::DataItemKey SPIConnectionIndexItem = 492;
    } // namespace SPIConnectionType

    namespace CamportUSBGadgetPlayPauseOption {
            static const ::Courier::DataItemKey PlayPauseIndexItem = 293;
    } // namespace CamportUSBGadgetPlayPauseOption

    namespace AudiobookChapterListSelectedLine {
            static const ::Courier::DataItemKey AudiobookChapterListSelectedLineItem = 17;
    } // namespace AudiobookChapterListSelectedLine

    namespace AlbumListItem {
            static const ::Courier::DataItemKey AlbumNameItem = 308;
    } // namespace AlbumListItem

    namespace USB2Visibility {
            static const ::Courier::DataItemKey USB2IsvisibleItem = 94;
    } // namespace USB2Visibility

    namespace MuteInfo {
            static const ::Courier::DataItemKey MuteStatusItem = 397;
    } // namespace MuteInfo

    namespace VideoTab {
            static const ::Courier::DataItemKey i8IsActiveItem = 38;
    } // namespace VideoTab

    namespace USBShuffleOption {
            static const ::Courier::DataItemKey ShuffleOffItem = 270;
            static const ::Courier::DataItemKey ShuffleOnItem = 220;
            static const ::Courier::DataItemKey ShuffleIndexItem = 462;
    } // namespace USBShuffleOption

    namespace TAIconStatus {
            static const ::Courier::DataItemKey TAIconIndexItem = 104;
    } // namespace TAIconStatus

    namespace ExternalDeviceConnected {
            static const ::Courier::DataItemKey DbDownloadDeviceItem = 72;
    } // namespace ExternalDeviceConnected

    namespace USBRouterShuffleOption {
            static const ::Courier::DataItemKey ShuffleOffItem = 80;
            static const ::Courier::DataItemKey ShuffleOnItem = 61;
            static const ::Courier::DataItemKey ShuffleIndexItem = 276;
    } // namespace USBRouterShuffleOption

    namespace FastForwardRewindPopup {
            static const ::Courier::DataItemKey FastForwardRewindTextItem = 459;
            static const ::Courier::DataItemKey CurrentValueItem = 391;
    } // namespace FastForwardRewindPopup

    namespace Genre_ArtistListSelectedLine {
            static const ::Courier::DataItemKey GenreArtistSelectedItem = 440;
    } // namespace Genre_ArtistListSelectedLine

    namespace BrowserScreenListSize {
            static const ::Courier::DataItemKey PreviousButtonSizeItem = 121;
            static const ::Courier::DataItemKey AllAlbumAndTitleButtonSizeItem = 165;
            static const ::Courier::DataItemKey VerticalListSizeItem = 54;
            static const ::Courier::DataItemKey ScrollBarSizeItem = 313;
            static const ::Courier::DataItemKey PreviousButtonVisibilityItem = 5;
            static const ::Courier::DataItemKey AllAlbumAndTitleButtonVisibilityItem = 150;
            static const ::Courier::DataItemKey AllAlbumAndTitleTextItem = 374;
            static const ::Courier::DataItemKey AlbumIconVisibilityItem = 205;
            static const ::Courier::DataItemKey TitleIconVisibilityItem = 139;
            static const ::Courier::DataItemKey ListVisibilityItem = 470;
            static const ::Courier::DataItemKey ScrollBarSliderSizeItem = 212;
    } // namespace BrowserScreenListSize

    namespace MediaSourceUpdateInGadget {
            static const ::Courier::DataItemKey MediaSourceIndexItem = 19;
    } // namespace MediaSourceUpdateInGadget

    namespace RouterUSBGadgetPlayPauseOption {
            static const ::Courier::DataItemKey PlayPauseIndexItem = 218;
    } // namespace RouterUSBGadgetPlayPauseOption

    namespace ExternalDVDButton {
            static const ::Courier::DataItemKey i8IsActiveItem = 285;
    } // namespace ExternalDVDButton

    namespace USBCameraPortAlbumVisibility {
            static const ::Courier::DataItemKey IconAndTextVisiblityItem = 8;
    } // namespace USBCameraPortAlbumVisibility

    namespace MediaTabActiveState {
            static const ::Courier::DataItemKey TitleTabActiveStateChangeItem = 228;
            static const ::Courier::DataItemKey ArtistTabActiveStateChangeItem = 255;
            static const ::Courier::DataItemKey AlbumTabActiveStateChangeItem = 167;
            static const ::Courier::DataItemKey GenreTabActiveStateChangeItem = 201;
            static const ::Courier::DataItemKey FolderTabActiveStateChangeItem = 499;
            static const ::Courier::DataItemKey PlaylistTabActiveStateChangeItem = 199;
            static const ::Courier::DataItemKey AudioBkTabActiveStateChangeItem = 102;
            static const ::Courier::DataItemKey PodcastTabActiveStateChangeItem = 122;
            static const ::Courier::DataItemKey VideoTabActiveStateChangeItem = 323;
    } // namespace MediaTabActiveState

    namespace AuxFeatureController {
            static const ::Courier::DataItemKey EnableStatusItem = 439;
    } // namespace AuxFeatureController

    namespace GenreTab {
            static const ::Courier::DataItemKey i8IsActiveItem = 141;
    } // namespace GenreTab

    namespace USBPlayPauseOption {
            static const ::Courier::DataItemKey PlayPauseIndexItem = 185;
    } // namespace USBPlayPauseOption

    namespace BTElapsedTimeVisibility {
            static const ::Courier::DataItemKey i8IsvisibleItem = 521;
    } // namespace BTElapsedTimeVisibility

    namespace VideoPlaybackAction {
            static const ::Courier::DataItemKey VideoTitleItem = 125;
            static const ::Courier::DataItemKey VideoEpisodeItem = 281;
    } // namespace VideoPlaybackAction

    namespace SDShuffleOption {
            static const ::Courier::DataItemKey ShuffleOffItem = 204;
            static const ::Courier::DataItemKey ShuffleOnItem = 303;
    } // namespace SDShuffleOption

    namespace USBRepeatOption {
            static const ::Courier::DataItemKey RepeatTrackItem = 405;
            static const ::Courier::DataItemKey RepeatListItem = 424;
            static const ::Courier::DataItemKey RepeatIndexItem = 379;
    } // namespace USBRepeatOption

    namespace ExternalBrowseTextInfo {
            static const ::Courier::DataItemKey BrowseTextItem = 231;
    } // namespace ExternalBrowseTextInfo

    namespace Audiobook_ListSize {
            static const ::Courier::DataItemKey AudiobookWindowListSizeItem = 484;
    } // namespace Audiobook_ListSize

    namespace Album_TitleListSelectedLine {
            static const ::Courier::DataItemKey AlbumTitleSelectedItem = 118;
    } // namespace Album_TitleListSelectedLine

    namespace AUXStatus {
            static const ::Courier::DataItemKey i8IsCheckedItem = 513;
    } // namespace AUXStatus

    namespace ID3CoverDataForRouterUSB {
            static const ::Courier::DataItemKey RouterAlbumImageItem = 510;
    } // namespace ID3CoverDataForRouterUSB

    namespace USBCameraPortRepeatOption {
            static const ::Courier::DataItemKey RepeatTrackItem = 268;
            static const ::Courier::DataItemKey RepeatListItem = 317;
            static const ::Courier::DataItemKey RepeatIndexItem = 143;
    } // namespace USBCameraPortRepeatOption

    namespace Camport1USBButton {
            static const ::Courier::DataItemKey i8IsActiveItem = 64;
    } // namespace Camport1USBButton

    namespace Genre_Artist_AlbumListSelectedLine {
            static const ::Courier::DataItemKey GenreArtistAlbumSelectedItem = 262;
    } // namespace Genre_Artist_AlbumListSelectedLine

    namespace ExternalMediaSource {
            static const ::Courier::DataItemKey EMPMediaSourceVisibilityItem = 445;
            static const ::Courier::DataItemKey EMPHMIMediaSourceVisibilityItem = 193;
    } // namespace ExternalMediaSource

    namespace FolderFile_ListSelectedLine {
            static const ::Courier::DataItemKey FolderFileSelectedItem = 146;
    } // namespace FolderFile_ListSelectedLine

    namespace SDRepeatOption {
            static const ::Courier::DataItemKey RepeatTrackItem = 310;
            static const ::Courier::DataItemKey RepeatListItem = 181;
    } // namespace SDRepeatOption

    namespace ID3CoverDataForApple {
            static const ::Courier::DataItemKey ImageItem = 520;
    } // namespace ID3CoverDataForApple

    namespace BrowseListSelectedLine {
            static const ::Courier::DataItemKey ArtistSelectedItem = 124;
            static const ::Courier::DataItemKey AlbumSelectedItem = 422;
            static const ::Courier::DataItemKey GenreSelectedItem = 433;
            static const ::Courier::DataItemKey PodcastSelectedItem = 237;
            static const ::Courier::DataItemKey VideoSelectedItem = 398;
    } // namespace BrowseListSelectedLine

    namespace GadgetItemVisibilityState {
            static const ::Courier::DataItemKey GadgetButtonsVisibleStateItem = 468;
            static const ::Courier::DataItemKey GadgetSourceIconAndTextVisibleStateItem = 497;
            static const ::Courier::DataItemKey GadgetCabinDefaultTextVisibleStateItem = 282;
            static const ::Courier::DataItemKey GadgetCabinRestorationTextVisibleStateItem = 52;
    } // namespace GadgetItemVisibilityState

    namespace SDCardStatus {
            static const ::Courier::DataItemKey i8IsCheckedItem = 4;
    } // namespace SDCardStatus

    namespace ID3CoverDataForRouterUSBGadget {
            static const ::Courier::DataItemKey GadgetImageItem = 36;
    } // namespace ID3CoverDataForRouterUSBGadget

    namespace ListScrollBarInfo {
            static const ::Courier::DataItemKey EnabledItem = 455;
    } // namespace ListScrollBarInfo

    namespace Genre_AllAlbumsListSize {
            static const ::Courier::DataItemKey GenreAllAlbumsWindowListSizeItem = 2;
    } // namespace Genre_AllAlbumsListSize

    namespace ID3CoverDataForBT {
            static const ::Courier::DataItemKey ImageItem = 349;
    } // namespace ID3CoverDataForBT

    namespace BTSliderVisibility {
            static const ::Courier::DataItemKey i8IsvisibleItem = 368;
    } // namespace BTSliderVisibility

    namespace Podcast_EpisodeListSelectedLine {
            static const ::Courier::DataItemKey PodcastEpisodeSelectedItem = 44;
    } // namespace Podcast_EpisodeListSelectedLine

    namespace VideoPlayerFullScreeen {
            static const ::Courier::DataItemKey PlayIconNameItem = 196;
    } // namespace VideoPlayerFullScreeen

    namespace DBInPreparation {
            static const ::Courier::DataItemKey DeviceTypeItem = 249;
    } // namespace DBInPreparation

    namespace Camport1HDMIButton {
            static const ::Courier::DataItemKey i8IsActiveItem = 40;
    } // namespace Camport1HDMIButton

    namespace Video_EpisodeListSelectedLine {
            static const ::Courier::DataItemKey VideoEpisodeSelectedItem = 453;
    } // namespace Video_EpisodeListSelectedLine

    namespace Album_TitleListSize {
            static const ::Courier::DataItemKey AlbumTitleWindowListSizeItem = 225;
    } // namespace Album_TitleListSize

    namespace Video_EpisodeListSize {
            static const ::Courier::DataItemKey VideoEpisodeWindowListSizeItem = 93;
    } // namespace Video_EpisodeListSize

    namespace AppleDevice {
            static const ::Courier::DataItemKey SourceNameItem = 63;
            static const ::Courier::DataItemKey ArtistNameItem = 163;
            static const ::Courier::DataItemKey TitleNameItem = 514;
            static const ::Courier::DataItemKey AlbumNameItem = 486;
            static const ::Courier::DataItemKey VideoNameItem = 403;
            static const ::Courier::DataItemKey CurrentTrackNoItem = 292;
            static const ::Courier::DataItemKey TotalTrackNoItem = 390;
            static const ::Courier::DataItemKey TotalTimeItem = 16;
            static const ::Courier::DataItemKey ElapsedTimeItem = 330;
            static const ::Courier::DataItemKey SliderTotalTimeItem = 322;
            static const ::Courier::DataItemKey SliderElapsedTimeItem = 27;
            static const ::Courier::DataItemKey DragCurrentValueItem = 130;
            static const ::Courier::DataItemKey RepeatOptionItem = 114;
            static const ::Courier::DataItemKey ShuffleOptionItem = 346;
            static const ::Courier::DataItemKey SeekCurrentPositionItem = 290;
            static const ::Courier::DataItemKey PlayIconNameItem = 382;
            static const ::Courier::DataItemKey RepeatIconNameItem = 251;
            static const ::Courier::DataItemKey ShuffleIconNameItem = 457;
            static const ::Courier::DataItemKey ArtistIconItem = 248;
    } // namespace AppleDevice

    namespace USB1Button {
            static const ::Courier::DataItemKey isConnectedWithHubItem = 278;
    } // namespace USB1Button

    namespace Genre_TitleListSelectedLine {
            static const ::Courier::DataItemKey GenreTitleSelectedItem = 466;
    } // namespace Genre_TitleListSelectedLine

    namespace Playlist_ListSize {
            static const ::Courier::DataItemKey PlaylistWindowListSizeItem = 187;
    } // namespace Playlist_ListSize

    namespace AppleRepeatOption {
            static const ::Courier::DataItemKey RepeatTrackItem = 135;
            static const ::Courier::DataItemKey RepeatListItem = 341;
            static const ::Courier::DataItemKey RepeatIndexItem = 358;
    } // namespace AppleRepeatOption

    namespace SDCardDevice {
            static const ::Courier::DataItemKey SourceNameItem = 256;
            static const ::Courier::DataItemKey ArtistNameItem = 84;
            static const ::Courier::DataItemKey TitleNameItem = 417;
            static const ::Courier::DataItemKey AlbumNameItem = 372;
            static const ::Courier::DataItemKey VideoNameItem = 451;
            static const ::Courier::DataItemKey CurrentTrackNoItem = 6;
            static const ::Courier::DataItemKey TotalTrackNoItem = 123;
            static const ::Courier::DataItemKey TotalTimeItem = 295;
            static const ::Courier::DataItemKey ElapsedTimeItem = 277;
            static const ::Courier::DataItemKey SliderTotalTimeItem = 502;
            static const ::Courier::DataItemKey SliderElapsedTimeItem = 286;
            static const ::Courier::DataItemKey DragCurrentValueItem = 493;
            static const ::Courier::DataItemKey RepeatOptionItem = 432;
            static const ::Courier::DataItemKey ShuffleOptionItem = 381;
            static const ::Courier::DataItemKey SeekCurrentPositionItem = 42;
            static const ::Courier::DataItemKey PlayIconNameItem = 352;
            static const ::Courier::DataItemKey RepeatIconNameItem = 217;
            static const ::Courier::DataItemKey ShuffleIconNameItem = 62;
    } // namespace SDCardDevice

    namespace VideoTabActivation {
            static const ::Courier::DataItemKey IsVideoTabActiveVariantItem = 18;
    } // namespace VideoTabActivation

    namespace BTShuffle {
            static const ::Courier::DataItemKey BTShuffleOptionItem = 501;
            static const ::Courier::DataItemKey BTShuffleIconNameItem = 208;
    } // namespace BTShuffle

    namespace PodcastTab {
            static const ::Courier::DataItemKey i8IsActiveItem = 233;
    } // namespace PodcastTab

    namespace PlaybackAction {
            static const ::Courier::DataItemKey SourceNameItem = 240;
            static const ::Courier::DataItemKey ArtistNameItem = 279;
            static const ::Courier::DataItemKey TitleNameItem = 461;
            static const ::Courier::DataItemKey AlbumNameItem = 522;
            static const ::Courier::DataItemKey VideoNameItem = 175;
            static const ::Courier::DataItemKey CurrentTrackNoItem = 476;
            static const ::Courier::DataItemKey TotalTrackNoItem = 509;
            static const ::Courier::DataItemKey TotalTimeItem = 172;
            static const ::Courier::DataItemKey ElapsedTimeItem = 28;
            static const ::Courier::DataItemKey SliderTotalTimeItem = 48;
            static const ::Courier::DataItemKey SliderElapsedTimeItem = 252;
            static const ::Courier::DataItemKey DragCurrentValueItem = 359;
            static const ::Courier::DataItemKey RepeatOptionItem = 487;
            static const ::Courier::DataItemKey ShuffleOptionItem = 356;
            static const ::Courier::DataItemKey SeekCurrentPositionItem = 460;
            static const ::Courier::DataItemKey PlayIconNameItem = 70;
            static const ::Courier::DataItemKey RepeatIconNameItem = 253;
            static const ::Courier::DataItemKey ShuffleIconNameItem = 37;
            static const ::Courier::DataItemKey DummyImageItem = 347;
    } // namespace PlaybackAction

    namespace BTPlayPauseOption {
            static const ::Courier::DataItemKey PlayPauseIndexItem = 337;
    } // namespace BTPlayPauseOption

    namespace AudiobookChapter_ListSize {
            static const ::Courier::DataItemKey AudiobookChapterWindowListSizeItem = 151;
    } // namespace AudiobookChapter_ListSize

    namespace PlaylistTab {
            static const ::Courier::DataItemKey i8IsActiveItem = 472;
    } // namespace PlaylistTab

    namespace PlaylistTitleListSelectedLine {
            static const ::Courier::DataItemKey PlaylistTitleListSelectedLineItem = 475;
    } // namespace PlaylistTitleListSelectedLine

    namespace USB2Button {
            static const ::Courier::DataItemKey i8IsActiveItem = 373;
    } // namespace USB2Button

    namespace USBRouterAlbumVisibility {
            static const ::Courier::DataItemKey IconAndTextVisiblityItem = 409;
    } // namespace USBRouterAlbumVisibility

    namespace BrowseListInfoText {
            static const ::Courier::DataItemKey ListInfoTextVisiblityItem = 166;
    } // namespace BrowseListInfoText

    namespace BTRepeat {
            static const ::Courier::DataItemKey BTRepeatOptionItem = 334;
            static const ::Courier::DataItemKey BTRepeatIconNameItem = 321;
    } // namespace BTRepeat

    namespace MediaMetaDataUpdateInGadget {
            static const ::Courier::DataItemKey MediaGadgetIndexItem = 239;
    } // namespace MediaMetaDataUpdateInGadget

    namespace PlaybackActionGadget {
            static const ::Courier::DataItemKey ArtistNameItem = 209;
            static const ::Courier::DataItemKey TitleNameItem = 46;
            static const ::Courier::DataItemKey ElapsedTimeItem = 173;
            static const ::Courier::DataItemKey TotalTimeItem = 511;
            static const ::Courier::DataItemKey SliderTotalTimeItem = 272;
            static const ::Courier::DataItemKey SliderElapsedTimeItem = 507;
    } // namespace PlaybackActionGadget

    namespace Podcast_EpisodeListSize {
            static const ::Courier::DataItemKey PodcastEpisodeWindowListSizeItem = 354;
    } // namespace Podcast_EpisodeListSize

    namespace ID3CoverDataForGadget {
            static const ::Courier::DataItemKey GadgetImageItem = 516;
    } // namespace ID3CoverDataForGadget

    namespace AUXVisibility {
            static const ::Courier::DataItemKey i8IsvisibleItem = 448;
    } // namespace AUXVisibility

    namespace BTShuffleOption {
            static const ::Courier::DataItemKey ShuffleOffItem = 134;
            static const ::Courier::DataItemKey ShuffleOnItem = 92;
            static const ::Courier::DataItemKey ShuffleIndexItem = 226;
    } // namespace BTShuffleOption

    namespace USBRouterPlayPauseOption {
            static const ::Courier::DataItemKey PlayPauseIndexItem = 132;
    } // namespace USBRouterPlayPauseOption

    namespace Folder_ListSelectedLine {
            static const ::Courier::DataItemKey FolderSelectedItem = 183;
    } // namespace Folder_ListSelectedLine

    namespace DBDownloadError {
            static const ::Courier::DataItemKey ExternalDeviceTypeItem = 241;
    } // namespace DBDownloadError

    namespace TabNextPrevIndex {
            static const ::Courier::DataItemKey NextIndexItem = 444;
            static const ::Courier::DataItemKey PrevIndexItem = 489;
            static const ::Courier::DataItemKey EnableTouchNextItem = 523;
            static const ::Courier::DataItemKey EnableTouchPrevItem = 519;
    } // namespace TabNextPrevIndex

    namespace Artist_Album_TitleListSelectedLine {
            static const ::Courier::DataItemKey ArtistAlbumTitleSelectedItem = 319;
    } // namespace Artist_Album_TitleListSelectedLine

    namespace FolderTab {
            static const ::Courier::DataItemKey i8IsActiveItem = 145;
    } // namespace FolderTab

    namespace TitleListSelectedLine {
            static const ::Courier::DataItemKey TitleListSelectedLineItem = 436;
    } // namespace TitleListSelectedLine

    namespace Folder_ListSize {
            static const ::Courier::DataItemKey FolderWindowListSizeItem = 137;
    } // namespace Folder_ListSize

    namespace BrowseTextChange {
            static const ::Courier::DataItemKey BrowseTextItem = 109;
    } // namespace BrowseTextChange

    namespace BrowseListSize {
            static const ::Courier::DataItemKey ArtistWindowListSizeItem = 260;
            static const ::Courier::DataItemKey AlbumWindowListSizeItem = 408;
            static const ::Courier::DataItemKey GenreWindowListSizeItem = 10;
            static const ::Courier::DataItemKey PodcastWindowListSizeItem = 3;
            static const ::Courier::DataItemKey VideoWindowListSizeItem = 113;
    } // namespace BrowseListSize

    namespace DeviceNameAndStatus {
            static const ::Courier::DataItemKey BTDeviceMuteStatusItem = 342;
            static const ::Courier::DataItemKey AUXMuteStatusItem = 210;
            static const ::Courier::DataItemKey ExternalDVDMuteStatusItem = 419;
    } // namespace DeviceNameAndStatus

    namespace BTVisibility {
            static const ::Courier::DataItemKey BTIsvisibleItem = 21;
    } // namespace BTVisibility

    namespace ExternalDVDStatus {
            static const ::Courier::DataItemKey i8IsCheckedItem = 485;
    } // namespace ExternalDVDStatus

    namespace AuxActivation {
            static const ::Courier::DataItemKey IsAuxActiveVariantItem = 182;
    } // namespace AuxActivation

    namespace BTButton {
            static const ::Courier::DataItemKey i8IsActiveItem = 164;
    } // namespace BTButton

    namespace USBRouterRepeatOption {
            static const ::Courier::DataItemKey RepeatTrackItem = 383;
            static const ::Courier::DataItemKey RepeatIndexItem = 158;
    } // namespace USBRouterRepeatOption

    namespace ArtistTab {
            static const ::Courier::DataItemKey i8IsActiveItem = 91;
    } // namespace ArtistTab

    namespace IconsVisibility {
            static const ::Courier::DataItemKey IconArtistVisiblityItem = 12;
            static const ::Courier::DataItemKey IconArtistPodcastVisiblityItem = 312;
            static const ::Courier::DataItemKey IconTitleVisiblityItem = 190;
            static const ::Courier::DataItemKey IconTitlePodcastVisiblityItem = 294;
            static const ::Courier::DataItemKey IconAlbumVisiblityItem = 222;
            static const ::Courier::DataItemKey IconAlbumAudioBookVisiblityItem = 236;
    } // namespace IconsVisibility

    namespace MuteInfoforAux {
            static const ::Courier::DataItemKey MuteStatusforAuxItem = 481;
    } // namespace MuteInfoforAux

    namespace Title_ListSize {
            static const ::Courier::DataItemKey TitleWindowListSizeItem = 211;
    } // namespace Title_ListSize

    namespace USBCameraPortPlaybackAction {
            static const ::Courier::DataItemKey SourceNameItem = 71;
            static const ::Courier::DataItemKey ArtistNameItem = 246;
            static const ::Courier::DataItemKey TitleNameItem = 336;
            static const ::Courier::DataItemKey AlbumNameItem = 69;
            static const ::Courier::DataItemKey CurrentTrackNoItem = 370;
            static const ::Courier::DataItemKey TotalTimeItem = 20;
            static const ::Courier::DataItemKey ElapsedTimeItem = 1;
            static const ::Courier::DataItemKey SliderTotalTimeItem = 506;
            static const ::Courier::DataItemKey SliderElapsedTimeItem = 7;
            static const ::Courier::DataItemKey DragCurrentValueItem = 389;
            static const ::Courier::DataItemKey RepeatOptionItem = 515;
            static const ::Courier::DataItemKey ShuffleOptionItem = 371;
            static const ::Courier::DataItemKey PlayIconNameItem = 65;
            static const ::Courier::DataItemKey RepeatIconNameItem = 258;
            static const ::Courier::DataItemKey ShuffleIconNameItem = 235;
    } // namespace USBCameraPortPlaybackAction

    namespace BTRepeatOption {
            static const ::Courier::DataItemKey RepeatTrackItem = 230;
            static const ::Courier::DataItemKey RepeatListItem = 328;
            static const ::Courier::DataItemKey RepeatIndexItem = 375;
    } // namespace BTRepeatOption

    namespace USBCameraPortShuffleOption {
            static const ::Courier::DataItemKey ShuffleOffItem = 206;
            static const ::Courier::DataItemKey ShuffleOnItem = 367;
            static const ::Courier::DataItemKey ShuffleIndexItem = 221;
    } // namespace USBCameraPortShuffleOption

    namespace FolderListDataItem {
            static const ::Courier::DataItemKey IconImageIndexValItem = 378;
    } // namespace FolderListDataItem

    namespace Artist_AlbumListSize {
            static const ::Courier::DataItemKey Artist_AlbumWindowListSizeItem = 159;
    } // namespace Artist_AlbumListSize

    namespace ID3CoverDataForCamportUSBGadget {
            static const ::Courier::DataItemKey GadgetImageItem = 186;
    } // namespace ID3CoverDataForCamportUSBGadget

    namespace Liststatus {
            static const ::Courier::DataItemKey ViewportstartIndexAlbumItem = 365;
            static const ::Courier::DataItemKey ViewportstartIndexAlbum_songItem = 503;
            static const ::Courier::DataItemKey ViewportstartIndexArtistItem = 480;
            static const ::Courier::DataItemKey ViewportstartIndexArtist_AlbumItem = 283;
            static const ::Courier::DataItemKey ViewportstartIndexArtist_Album_SongItem = 366;
            static const ::Courier::DataItemKey ViewportstartIndexArtist_SongItem = 179;
            static const ::Courier::DataItemKey ViewportstartIndexAudiobookItem = 318;
            static const ::Courier::DataItemKey ViewportstartIndexAudiobooktitle_ChapterItem = 86;
            static const ::Courier::DataItemKey ViewportstartIndexFolderItem = 362;
            static const ::Courier::DataItemKey ViewportstartIndexFolder_FileItem = 316;
            static const ::Courier::DataItemKey ViewportstartIndexGenreItem = 261;
            static const ::Courier::DataItemKey ViewportstartIndexGenre_AlbumItem = 242;
            static const ::Courier::DataItemKey ViewportstartIndexGenre_Album_SongItem = 156;
            static const ::Courier::DataItemKey ViewportstartIndexGenre_ArtistItem = 338;
            static const ::Courier::DataItemKey ViewportstartIndexGenre_Artist_AlbumItem = 171;
            static const ::Courier::DataItemKey ViewportstartIndexGenre_Artist_Album_SongItem = 250;
            static const ::Courier::DataItemKey ViewportstartIndexGenre_Artist_SongItem = 149;
            static const ::Courier::DataItemKey ViewportstartIndexPlaylistItem = 427;
            static const ::Courier::DataItemKey ViewportstartIndexPlaylist_SongItem = 314;
            static const ::Courier::DataItemKey ViewportstartIndexPodcastItem = 120;
            static const ::Courier::DataItemKey ViewportstartIndexPodcast_EpisodeItem = 488;
            static const ::Courier::DataItemKey ViewportstartIndexSongItem = 74;
            static const ::Courier::DataItemKey ViewportstartIndexVideoItem = 494;
            static const ::Courier::DataItemKey ViewportstartIndexVideo_EpisodeItem = 99;
    } // namespace Liststatus

    namespace IpodButton {
            static const ::Courier::DataItemKey i8IsActiveItem = 34;
    } // namespace IpodButton

    namespace PlaybackActionRouterGadget {
            static const ::Courier::DataItemKey ArtistNameItem = 257;
            static const ::Courier::DataItemKey TitleNameItem = 29;
            static const ::Courier::DataItemKey ElapsedTimeItem = 482;
            static const ::Courier::DataItemKey TotalTimeItem = 56;
            static const ::Courier::DataItemKey SliderTotalTimeItem = 116;
            static const ::Courier::DataItemKey SliderElapsedTimeItem = 464;
    } // namespace PlaybackActionRouterGadget

    namespace Genre_Artist_AlbumListSize {
            static const ::Courier::DataItemKey GenreArtistAlbumWindowListSizeItem = 504;
    } // namespace Genre_Artist_AlbumListSize

    namespace PlaylistTitle_ListSize {
            static const ::Courier::DataItemKey PlaylistTitleWindowListSizeItem = 524;
    } // namespace PlaylistTitle_ListSize

    namespace Genre_ArtistListSize {
            static const ::Courier::DataItemKey GenreArtistWindowListSizeItem = 96;
    } // namespace Genre_ArtistListSize

    namespace FolderFile_ListSize {
            static const ::Courier::DataItemKey FolderFile_WindowListSizeItem = 101;
    } // namespace FolderFile_ListSize

    namespace MediaSourceUSBNameInGadget {
            static const ::Courier::DataItemKey USBNameItem = 60;
    } // namespace MediaSourceUSBNameInGadget

    namespace TAStatus {
            static const ::Courier::DataItemKey i8IsCheckedItem = 332;
    } // namespace TAStatus

    namespace USBRouterPlaybackAction {
            static const ::Courier::DataItemKey SourceNameItem = 508;
            static const ::Courier::DataItemKey ArtistNameItem = 254;
            static const ::Courier::DataItemKey TitleNameItem = 353;
            static const ::Courier::DataItemKey AlbumNameItem = 411;
            static const ::Courier::DataItemKey CurrentTrackNoItem = 271;
            static const ::Courier::DataItemKey TotalTimeItem = 463;
            static const ::Courier::DataItemKey ElapsedTimeItem = 153;
            static const ::Courier::DataItemKey SliderTotalTimeItem = 309;
            static const ::Courier::DataItemKey SliderElapsedTimeItem = 491;
    } // namespace USBRouterPlaybackAction

    namespace TabVideoSource {
            static const ::Courier::DataItemKey TabVideoSourceVisibilityItem = 41;
            static const ::Courier::DataItemKey TabVideoSourceEnableItem = 299;
    } // namespace TabVideoSource

    namespace USBButton {
            static const ::Courier::DataItemKey i8IsActiveItem = 238;
    } // namespace USBButton

    namespace ExternalDVDVisibililty {
            static const ::Courier::DataItemKey i8IsvisibleItem = 414;
    } // namespace ExternalDVDVisibililty

    namespace SDCardVisibility {
            static const ::Courier::DataItemKey i8IsvisibleItem = 266;
    } // namespace SDCardVisibility

    namespace GadgetPlayPauseOption {
            static const ::Courier::DataItemKey PlayPauseIndexItem = 14;
    } // namespace GadgetPlayPauseOption

    namespace BTTotalTimeVisibility {
            static const ::Courier::DataItemKey i8IsvisibleItem = 140;
    } // namespace BTTotalTimeVisibility

    namespace BTNowplayIcons {
            static const ::Courier::DataItemKey ShuffleIconStatusItem = 335;
            static const ::Courier::DataItemKey RepeatIconStatusItem = 377;
            static const ::Courier::DataItemKey BrowseIconStatusItem = 128;
    } // namespace BTNowplayIcons

    namespace AudiobookListSelectedLine {
            static const ::Courier::DataItemKey AudiobookListSelectedLineItem = 348;
    } // namespace AudiobookListSelectedLine

    namespace AlbumTab {
            static const ::Courier::DataItemKey i8IsActiveItem = 399;
    } // namespace AlbumTab

    namespace Genre_TitleListSize {
            static const ::Courier::DataItemKey GenreTitleWindowListSizeItem = 110;
    } // namespace Genre_TitleListSize

    namespace NavigationVarientType {
            static const ::Courier::DataItemKey NavigationsupportIndexItem = 320;
    } // namespace NavigationVarientType

    namespace ID3CoverDataForCamportUSB {
            static const ::Courier::DataItemKey CamportAlbumImageItem = 108;
    } // namespace ID3CoverDataForCamportUSB

    namespace TitleTab {
            static const ::Courier::DataItemKey i8IsActiveItem = 195;
    } // namespace TitleTab

    namespace AudiobookTab {
            static const ::Courier::DataItemKey i8IsActiveItem = 22;
    } // namespace AudiobookTab

    namespace ID3CoverData {
            static const ::Courier::DataItemKey ImageItem = 302;
    } // namespace ID3CoverData

    namespace ID3CoverDataForSDCard {
            static const ::Courier::DataItemKey ImageItem = 77;
    } // namespace ID3CoverDataForSDCard

    namespace PlaybackActionCabinAGadget {
            static const ::Courier::DataItemKey ArtistNameItem = 500;
            static const ::Courier::DataItemKey TitleNameItem = 53;
            static const ::Courier::DataItemKey ElapsedTimeItem = 23;
            static const ::Courier::DataItemKey TotalTimeItem = 395;
            static const ::Courier::DataItemKey SliderTotalTimeItem = 324;
            static const ::Courier::DataItemKey SliderElapsedTimeItem = 184;
    } // namespace PlaybackActionCabinAGadget

    namespace Icons {
            static const ::Courier::DataItemKey IconArtistFlipItem = 88;
            static const ::Courier::DataItemKey IconTitleFlipItem = 59;
            static const ::Courier::DataItemKey IconAlbumFlipItem = 386;
    } // namespace Icons

    namespace Notebookdata {
            static const ::Courier::DataItemKey CurrentTabItem = 306;
    } // namespace Notebookdata

    namespace AuxButton {
            static const ::Courier::DataItemKey i8IsActiveItem = 423;
    } // namespace AuxButton

    namespace DownloadVisibilityDataItem {
            static const ::Courier::DataItemKey DownloadIconVisibilityValItem = 437;
            static const ::Courier::DataItemKey DownloadIconSwitchValItem = 380;
            static const ::Courier::DataItemKey DownloadAnimationStatusItem = 107;
    } // namespace DownloadVisibilityDataItem

    namespace PlaylistListSelectedLine {
            static const ::Courier::DataItemKey PlaylistListSelectedLineItem = 518;
    } // namespace PlaylistListSelectedLine

    namespace MediaTabDisabledState {
            static const ::Courier::DataItemKey GenreTabDisabledStateChangeItem = 418;
            static const ::Courier::DataItemKey PlaylistTabDisabledStateChangeItem = 152;
            static const ::Courier::DataItemKey AlbumTabDisabledStateChangeItem = 357;
            static const ::Courier::DataItemKey AudiobookTabDisabledStateChangeItem = 434;
            static const ::Courier::DataItemKey PageUpDisabledStateChangeItem = 264;
            static const ::Courier::DataItemKey PageDownDisabledStateChangeItem = 505;
    } // namespace MediaTabDisabledState

    namespace DeviceConnectStatus {
            static const ::Courier::DataItemKey MediaMessage1Item = 442;
            static const ::Courier::DataItemKey MediaMessage2Item = 421;
            static const ::Courier::DataItemKey MediaMessage3Item = 450;
            static const ::Courier::DataItemKey MediaMessage4Item = 498;
            static const ::Courier::DataItemKey Message1VisibleItem = 350;
            static const ::Courier::DataItemKey Message2VisibleItem = 197;
            static const ::Courier::DataItemKey Message3VisibleItem = 496;
            static const ::Courier::DataItemKey Message4VisibleItem = 410;
            static const ::Courier::DataItemKey MediaMessageUpdateFlagItem = 50;
            static const ::Courier::DataItemKey MediaMessageDeviceConnectedItem = 76;
            static const ::Courier::DataItemKey MediaMessageDeviceDisconnectedItem = 136;
            static const ::Courier::DataItemKey MediaMessageNoDeviceItem = 416;
            static const ::Courier::DataItemKey MessageDeviceConnectedVisibleItem = 307;
            static const ::Courier::DataItemKey MessageDeviceDisconnectedVisibleItem = 396;
            static const ::Courier::DataItemKey MessageNoDeviceVisibleItem = 298;
            static const ::Courier::DataItemKey MediamessageIconindexItem = 11;
            static const ::Courier::DataItemKey MediamessageIconVisibleStateItem = 388;
    } // namespace DeviceConnectStatus

    namespace ApplePlayPauseOption {
            static const ::Courier::DataItemKey PlayPauseIndexItem = 133;
    } // namespace ApplePlayPauseOption

    namespace Artist_AlbumListSelectedLine {
            static const ::Courier::DataItemKey Artist_AlbumSelectedItem = 483;
    } // namespace Artist_AlbumListSelectedLine

    namespace USBCameraPortPlayPauseOption {
            static const ::Courier::DataItemKey PlayPauseIndexItem = 428;
    } // namespace USBCameraPortPlayPauseOption

    namespace DeviceConnection {
            static const ::Courier::DataItemKey USBDeviceNameItem = 58;
            static const ::Courier::DataItemKey AppleDeviceNameItem = 45;
            static const ::Courier::DataItemKey BTDeviceNameItem = 333;
            static const ::Courier::DataItemKey SDCardDeviceNameItem = 177;
    } // namespace DeviceConnection

    namespace SDCardButton {
            static const ::Courier::DataItemKey i8IsActiveItem = 192;
    } // namespace SDCardButton

    namespace Folder_Name {
            static const ::Courier::DataItemKey FolderFileNameItem = 198;
    } // namespace Folder_Name

    namespace Genre_AllAlbumsListSelectedLine {
            static const ::Courier::DataItemKey GenreAllAlbumsSelectedItem = 161;
    } // namespace Genre_AllAlbumsListSelectedLine

    namespace SPIVisibility {
            static const ::Courier::DataItemKey SPIIsvisibleItem = 495;
    } // namespace SPIVisibility

    namespace MediaListID {
            static const ::Courier::DataItemKey AlbumListIDItem = 234;
            static const ::Courier::DataItemKey TitleListIDItem = 9;
    } // namespace MediaListID
} // namespace ItemKey

bool InitDataBinding();

#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
namespace FeatStd {
// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DeviceConnectionDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DeviceConnectionDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::BTVisibilityDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::BTVisibilityDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SPIVisibilityDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SPIVisibilityDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PlaybackActionDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PlaybackActionDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::USBCameraPortPlaybackActionDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::USBCameraPortPlaybackActionDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::USBRouterPlaybackActionDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::USBRouterPlaybackActionDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::MuteInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::MuteInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::MuteInfoforAuxDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::MuteInfoforAuxDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::USB2VisibilityDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::USB2VisibilityDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::VariantInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::VariantInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ExternalMediaSourceDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ExternalMediaSourceDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::TabVideoSourceDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::TabVideoSourceDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::BTNowplayIconsDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::BTNowplayIconsDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ID3CoverDataForGadgetDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ID3CoverDataForGadgetDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ID3CoverDataForCamportUSBGadgetDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ID3CoverDataForCamportUSBGadgetDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ID3CoverDataForRouterUSBGadgetDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ID3CoverDataForRouterUSBGadgetDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ID3CoverDataForCamportUSBDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ID3CoverDataForCamportUSBDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ID3CoverDataForRouterUSBDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ID3CoverDataForRouterUSBDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::AlbumListItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::AlbumListItemDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::VideoPlaybackActionDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::VideoPlaybackActionDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::AppleDeviceDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::AppleDeviceDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::IconsDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::IconsDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::IconsVisibilityDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::IconsVisibilityDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::NavigationVarientTypeDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::NavigationVarientTypeDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ID3CoverDataForAppleDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ID3CoverDataForAppleDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ID3CoverDataForBTDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ID3CoverDataForBTDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SDCardDeviceDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SDCardDeviceDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ID3CoverDataForSDCardDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ID3CoverDataForSDCardDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::VideoPlayerFullScreeenDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::VideoPlayerFullScreeenDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::IpodButtonDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::IpodButtonDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::AuxButtonDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::AuxButtonDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::USBButtonDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::USBButtonDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::USB1ButtonDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::USB1ButtonDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::USB2ButtonDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::USB2ButtonDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SDCardButtonDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SDCardButtonDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::BTButtonDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::BTButtonDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ExternalDVDButtonDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ExternalDVDButtonDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Camport1USBButtonDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Camport1USBButtonDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Camport1HDMIButtonDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Camport1HDMIButtonDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ExternalDVDStatusDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ExternalDVDStatusDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::TAStatusDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::TAStatusDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::AUXStatusDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::AUXStatusDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SDCardStatusDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SDCardStatusDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::TitleTabDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::TitleTabDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ArtistTabDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ArtistTabDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::AlbumTabDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::AlbumTabDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::GenreTabDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::GenreTabDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::FolderTabDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::FolderTabDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PlaylistTabDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PlaylistTabDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::AudiobookTabDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::AudiobookTabDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PodcastTabDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PodcastTabDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::VideoTabDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::VideoTabDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ExternalDVDVisibililtyDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ExternalDVDVisibililtyDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::AUXVisibilityDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::AUXVisibilityDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SDCardVisibilityDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SDCardVisibilityDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::TAIconStatusDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::TAIconStatusDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DeviceConnectStatusDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DeviceConnectStatusDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ExternalDeviceConnectedDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ExternalDeviceConnectedDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DBInPreparationDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DBInPreparationDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DBDownloadErrorDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DBDownloadErrorDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DeviceNameAndStatusDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DeviceNameAndStatusDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::BrowseListSizeDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::BrowseListSizeDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::BrowseListSelectedLineDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::BrowseListSelectedLineDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Artist_AlbumListSizeDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Artist_AlbumListSizeDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Artist_AlbumListSelectedLineDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Artist_AlbumListSelectedLineDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Artist_Album_TitleListSizeDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Artist_Album_TitleListSizeDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Artist_Album_TitleListSelectedLineDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Artist_Album_TitleListSelectedLineDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Album_TitleListSizeDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Album_TitleListSizeDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Album_TitleListSelectedLineDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Album_TitleListSelectedLineDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Title_ListSizeDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Title_ListSizeDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::TitleListSelectedLineDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::TitleListSelectedLineDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Genre_ArtistListSizeDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Genre_ArtistListSizeDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Genre_ArtistListSelectedLineDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Genre_ArtistListSelectedLineDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Genre_AllAlbumsListSizeDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Genre_AllAlbumsListSizeDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Genre_AllAlbumsListSelectedLineDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Genre_AllAlbumsListSelectedLineDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Genre_Artist_AlbumListSizeDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Genre_Artist_AlbumListSizeDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Genre_Artist_AlbumListSelectedLineDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Genre_Artist_AlbumListSelectedLineDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Genre_TitleListSizeDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Genre_TitleListSizeDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Genre_TitleListSelectedLineDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Genre_TitleListSelectedLineDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::FastForwardRewindPopupDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::FastForwardRewindPopupDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::BTShuffleDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::BTShuffleDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::BTRepeatDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::BTRepeatDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::BTPlayInfoUpdateDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::BTPlayInfoUpdateDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::BTSliderVisibilityDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::BTSliderVisibilityDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::BTTotalTimeVisibilityDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::BTTotalTimeVisibilityDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::BTElapsedTimeVisibilityDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::BTElapsedTimeVisibilityDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ID3CoverDataDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ID3CoverDataDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Audiobook_ListSizeDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Audiobook_ListSizeDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::AudiobookListSelectedLineDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::AudiobookListSelectedLineDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::AudiobookChapter_ListSizeDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::AudiobookChapter_ListSizeDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::AudiobookChapterListSelectedLineDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::AudiobookChapterListSelectedLineDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Playlist_ListSizeDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Playlist_ListSizeDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PlaylistListSelectedLineDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PlaylistListSelectedLineDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PlaylistTitle_ListSizeDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PlaylistTitle_ListSizeDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PlaylistTitleListSelectedLineDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PlaylistTitleListSelectedLineDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Podcast_EpisodeListSizeDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Podcast_EpisodeListSizeDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Podcast_EpisodeListSelectedLineDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Podcast_EpisodeListSelectedLineDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Video_EpisodeListSizeDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Video_EpisodeListSizeDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Video_EpisodeListSelectedLineDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Video_EpisodeListSelectedLineDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Folder_ListSizeDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Folder_ListSizeDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Folder_ListSelectedLineDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Folder_ListSelectedLineDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::FolderFile_ListSizeDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::FolderFile_ListSizeDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::FolderFile_ListSelectedLineDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::FolderFile_ListSelectedLineDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Folder_NameDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Folder_NameDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::NotebookdataDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::NotebookdataDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::TabNextPrevIndexDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::TabNextPrevIndexDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ListstatusDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ListstatusDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SDRepeatOptionDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SDRepeatOptionDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::USBRepeatOptionDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::USBRepeatOptionDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::USBCameraPortRepeatOptionDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::USBCameraPortRepeatOptionDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::USBRouterRepeatOptionDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::USBRouterRepeatOptionDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::BTRepeatOptionDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::BTRepeatOptionDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::AppleRepeatOptionDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::AppleRepeatOptionDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SDShuffleOptionDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SDShuffleOptionDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::USBShuffleOptionDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::USBShuffleOptionDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::USBCameraPortShuffleOptionDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::USBCameraPortShuffleOptionDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::USBRouterShuffleOptionDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::USBRouterShuffleOptionDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::USBPlayPauseOptionDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::USBPlayPauseOptionDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::USBCameraPortPlayPauseOptionDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::USBCameraPortPlayPauseOptionDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::USBRouterPlayPauseOptionDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::USBRouterPlayPauseOptionDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ApplePlayPauseOptionDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ApplePlayPauseOptionDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::BTPlayPauseOptionDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::BTPlayPauseOptionDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::BTShuffleOptionDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::BTShuffleOptionDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::AppleShuffleOptionDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::AppleShuffleOptionDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SPIConnectionTypeDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SPIConnectionTypeDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::AuxFeatureControllerDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::AuxFeatureControllerDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::MediaListIDDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::MediaListIDDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::MediaTabActiveStateDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::MediaTabActiveStateDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::VideoTabActivationDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::VideoTabActivationDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::USBCameraPortAlbumVisibilityDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::USBCameraPortAlbumVisibilityDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::USBRouterAlbumVisibilityDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::USBRouterAlbumVisibilityDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::AuxActivationDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::AuxActivationDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::FolderListDataItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::FolderListDataItemDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DownloadVisibilityDataItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DownloadVisibilityDataItemDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::FolderFileListDataItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::FolderFileListDataItemDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::BrowseTextChangeDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::BrowseTextChangeDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ExternalBrowseTextInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ExternalBrowseTextInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::BrowserScreenListSizeDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::BrowserScreenListSizeDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::BrowseListInfoTextDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::BrowseListInfoTextDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::MediaTabDisabledStateDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::MediaTabDisabledStateDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::MuteStateVisibleGadgetDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::MuteStateVisibleGadgetDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::MediaSourceUpdateInGadgetDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::MediaSourceUpdateInGadgetDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::MediaMetaDataUpdateInGadgetDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::MediaMetaDataUpdateInGadgetDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PlaybackActionGadgetDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PlaybackActionGadgetDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PlaybackActionCabinAGadgetDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PlaybackActionCabinAGadgetDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PlaybackActionRouterGadgetDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PlaybackActionRouterGadgetDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::GadgetItemVisibilityStateDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::GadgetItemVisibilityStateDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::GadgetPlayPauseOptionDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::GadgetPlayPauseOptionDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::MediaSourceUSBNameInGadgetDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::MediaSourceUSBNameInGadgetDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::CamportUSBGadgetPlayPauseOptionDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::CamportUSBGadgetPlayPauseOptionDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::RouterUSBGadgetPlayPauseOptionDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::RouterUSBGadgetPlayPauseOptionDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ListScrollBarInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ListScrollBarInfoDataBindingSource > const& dataItemContainer);
} // namespace FeatStd
#endif // FEATSTD_STRINGBUFFER_APPENDER_ENABLED
#endif // AppHmi_MediaStateMachine_h
