/************************************************************************
*FILE: AppHmi_MediaStateMachine.cpp 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#include "AppHmi_MediaStateMachine.h"
#include <FeatStd/Util/StaticObject.h>
#include <Cit/VisualStateGlueLayer/VisualStateGlueLayer.h>
#include <Courier/Util/Util.h>
using namespace ::hmibase;

//====  defines and includes TTFis output - added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
#include "hmi_trace_if.h"
#include "View/CGI/CourierMsgTracing/CourierMessageMapTrace.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_SM
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/AppHmi_MediaStateMachine.cpp.trc.h"
#endif                            
//====  defines and includes TTFis output - end                        key: SM_TTFis_SBHFMSRF ====

// ------------------------------------------------------------------------

// ------------------------------------------------------------------------
bool SendSelectHomescreenMediaTab()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SelectHomescreenMediaTab)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendHomescreenToggle()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::HomescreenToggle)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendUSBCameraPortInvisibility()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::USBCameraPortInvisibility)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendGuiStartupFinishedUpdMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::GuiStartupFinishedUpdMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendUsbElapsedTimeSeekBackMsg(Courier::UInt32 const & aSeekValue)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::UsbElapsedTimeSeekBackMsg)(aSeekValue);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendOptionSelStateResp(Courier::UInt const & aOptionSelection)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::OptionSelStateResp)(aOptionSelection);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSwitchToTunerNowPlaying()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SwitchToTunerNowPlaying)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendButtonMainSrcActivate()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ButtonMainSrcActivate)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSwitchToPreviousApplication()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SwitchToPreviousApplication)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSwitchToNaviApplication()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SwitchToNaviApplication)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSwitchToMirrorLinkApplication()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SwitchToMirrorLinkApplication)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSwitchToSoundSettingsApplication()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SwitchToSoundSettingsApplication)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendLayerSoundSettingsMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::LayerSoundSettingsMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSwitchApplicationReq(enApplicationId const & aApplicationID, enSurfaceId const & aSurfaceID)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SwitchApplicationReq)(aApplicationID, aSurfaceID);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendUSB2SelectDeviceMsg(tenDeviceType const & aDeviceSrc)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::USB2SelectDeviceMsg)(aDeviceSrc);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendUSB1SelectDeviceMsg(tenDeviceType const & aDeviceSrc)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::USB1SelectDeviceMsg)(aDeviceSrc);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSelectDeviceSourceMsg(tenDeviceType const & aDeviceSrc)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SelectDeviceSourceMsg)(aDeviceSrc);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendMediaSceneMsg(Courier::UInt16 const & aMediaType)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::MediaSceneMsg)(aMediaType);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendMediaOperationMsgReq(Courier::UInt16 const & aOperationType)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::MediaOperationMsgReq)(aOperationType);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendMediaBTOperationMsgReq(Courier::UInt16 const & aOperationType)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::MediaBTOperationMsgReq)(aOperationType);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendActivateAUXAppReqMsg(Candera::UInt8 const & aCheckboxStatus)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ActivateAUXAppReqMsg)(aCheckboxStatus);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendActivateSDCardAppReqMsg(Candera::UInt8 const & aCheckboxStatus)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ActivateSDCardAppReqMsg)(aCheckboxStatus);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendActivateExternalDVDAppReqMsg(Candera::UInt8 const & aCheckboxStatus)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ActivateExternalDVDAppReqMsg)(aCheckboxStatus);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendActivateTAAppReqMsg(Candera::UInt8 const & aCheckboxStatus)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ActivateTAAppReqMsg)(aCheckboxStatus);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendAppleHIDCommandMsg(Courier::UInt8 const & aHIDCommand, Courier::UInt8 const & aKeyEvent)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::AppleHIDCommandMsg)(aHIDCommand, aKeyEvent);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendChangeHorListTabButtonRegMsg(Courier::UInt8 const & aSelectMediaTab)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ChangeHorListTabButtonRegMsg)(aSelectMediaTab);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendBTBrowsePressedUpdMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::BTBrowsePressedUpdMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendVideoBrowsePressedUpdMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::VideoBrowsePressedUpdMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendBrowseBtnPressedUpdMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::BrowseBtnPressedUpdMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendHorTabButtonPageUpReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::HorTabButtonPageUpReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendHorTabButtonPageDownReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::HorTabButtonPageDownReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendExternalMediaTabBtnPressUpdMsg(Courier::UInt8 const & aSelectMediaTab)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ExternalMediaTabBtnPressUpdMsg)(aSelectMediaTab);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendExternalBrowseScreenExitUpdMsg(Courier::UInt32 const & aListId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ExternalBrowseScreenExitUpdMsg)(aListId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendExternalMediaTabListPageUpReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ExternalMediaTabListPageUpReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendExternalMediaTabListPageDownReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ExternalMediaTabListPageDownReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendExternalMediaBackButtonPressUpdMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ExternalMediaBackButtonPressUpdMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendExternalMediaAllButtonPressUpdMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ExternalMediaAllButtonPressUpdMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendExternalMediaListItemPressUpdMsg(Courier::UInt32 const & aHdl, Courier::UInt32 const & aSubHdl)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ExternalMediaListItemPressUpdMsg)(aHdl, aSubHdl);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSeekMediaAppReqMsg(Courier::Int16 const & aPlaypointPosition, Courier::Int16 const & aPlaypointFormat)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SeekMediaAppReqMsg)(aPlaypointPosition, aPlaypointFormat);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSeekBTMediaAppReqMsg(Courier::Int16 const & aPlaypointPosition, Courier::Int16 const & aPlaypointFormat)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SeekBTMediaAppReqMsg)(aPlaypointPosition, aPlaypointFormat);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendNextBrowseTabsReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::NextBrowseTabsReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPreviousBrowseTabsReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::PreviousBrowseTabsReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendBrowseListReqMsg(Courier::UInt8 const & aG_SM_ListType)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::BrowseListReqMsg)(aG_SM_ListType);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendRequestUpFolderItems()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::RequestUpFolderItems)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendClearFolderListData()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ClearFolderListData)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendAudioAllocationForModeMsg(tenDeviceType const & aDeviceType)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::AudioAllocationForModeMsg)(aDeviceType);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendFastForwardRewindPopupMsg(Courier::Int8 const & aActionType)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::FastForwardRewindPopupMsg)(aActionType);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendUpdateBTDeviceNameUpdateStatusMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::UpdateBTDeviceNameUpdateStatusMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendBrowseListActiveRef(bool const & aIsActive)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::BrowseListActiveRef)(aIsActive);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendVideoOnSpeedRequestMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::VideoOnSpeedRequestMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendVideoOnParkingBreakRequestMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::VideoOnParkingBreakRequestMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendVideoOnExtDVDSpeedRequestMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::VideoOnExtDVDSpeedRequestMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendDVDVideoStartStreaming()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::DVDVideoStartStreaming)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendFolderViewEntryRespMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::FolderViewEntryRespMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendFolderViewExitRespMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::FolderViewExitRespMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendVideoViewEntryRespMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::VideoViewEntryRespMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendVideoViewExitRespMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::VideoViewExitRespMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSDCardViewEntryRespMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SDCardViewEntryRespMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSDCardViewExitRespMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SDCardViewExitRespMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendUSBViewEntryRespMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::USBViewEntryRespMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendUSBViewExitRespMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::USBViewExitRespMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendDVDStopVideoStreaming()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::DVDStopVideoStreaming)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendFastForwardRewindReleaseMsg(Courier::Int8 const & aActionType)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::FastForwardRewindReleaseMsg)(aActionType);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendMediaMessagepopupMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::MediaMessagepopupMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendVideoRequest()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::VideoRequest)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendStartVideoTimerMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::StartVideoTimerMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendStopVideoTimerMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::StopVideoTimerMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendVideoDisconnectRequest()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::VideoDisconnectRequest)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendExtDVDVideoConnectRequest()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ExtDVDVideoConnectRequest)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendExtDVDDevicenameRequest()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ExtDVDDevicenameRequest)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendAuxDevicenameRequest()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::AuxDevicenameRequest)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendExtDVDVideoDisconnectRequest()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ExtDVDVideoDisconnectRequest)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendNowplayingAlbumartView()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::NowplayingAlbumartView)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendCurrentMediaStateUpdMsg(Courier::UInt8 const & aCurrentState)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::CurrentMediaStateUpdMsg)(aCurrentState);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendMediaSettingBackBtnPressUpdMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::MediaSettingBackBtnPressUpdMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendChangeLanguageReqMsg(enLanguageId const & aLanguageId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ChangeLanguageReqMsg)(aLanguageId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendFocusReqMsg(FocusActionEnum const & aAction, FocusTimerActionEnum const & aTimerAction, ::Courier::ViewId const & aView, Candera::String const & aWidget)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::FocusReqMsg)(aAction, aTimerAction, aView, aWidget);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendDummyMess(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::DummyMess)(aFirstView, aSecondView, aPos);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendAnimationReqMsg(Courier::AnimationAction::Enum const & aAnimationAction, ::Courier::ViewId const & aViewId, Courier::CompositePath const & aCompositePath, ::Courier::ItemId const & aAnimationId, Courier::AnimationProperties const & aAnimationProperties)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::Courier::AnimationReqMsg)(aAnimationAction, aViewId, aCompositePath, aAnimationId, aAnimationProperties);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendFocusOnRightEncoderReqUpdMsg(bool const & aIsFocusUsed)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::FocusOnRightEncoderReqUpdMsg)(aIsFocusUsed);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendStoreActiveGadgetReqMsg(bool const & aIsGadgetAtive)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::StoreActiveGadgetReqMsg)(aIsGadgetAtive);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendHardKeyPressNotificationMsg(Courier::UInt8 const & aDummy, Courier::UInt8 const & aHKCode, Courier::UInt8 const & aHKState)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::HardKeyPressNotificationMsg)(aDummy, aHKCode, aHKState);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendDropdownChangeMsg(::Candera::DropdownChangeType const & aDropdownChangeType, ::Courier::UInt32 const & aListId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::DropdownChangeMsg)(aDropdownChangeType, aListId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendStartPopupTimerReqMsg(Courier::UInt32 const & aViewId, Courier::UInt32 const & aTimeout)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::StartPopupTimerReqMsg)(aViewId, aTimeout);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendStopPopupTimerReqMsg(Courier::UInt32 const & aViewId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::StopPopupTimerReqMsg)(aViewId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPlayBeepReqMsg(Courier::Int32 const & aBeepType)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::PlayBeepReqMsg)(aBeepType);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendCheckToClosePopupMsg(Courier::UInt32 const & aPopupId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::CheckToClosePopupMsg)(aPopupId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendRestartPopupTimerReqMsg(Courier::UInt32 const & aViewId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::RestartPopupTimerReqMsg)(aViewId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendContextSwitchInResMsg(Courier::UInt32 const & aSwitchId, Courier::UInt32 const & aResponseType)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ContextSwitchInResMsg)(aSwitchId, aResponseType);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendContextSwitchOutReqMsg(Courier::UInt32 const & aTargetContextId, Courier::UInt32 const & aSourceContextId, Courier::UInt32 const & aTargetAppId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ContextSwitchOutReqMsg)(aTargetContextId, aSourceContextId, aTargetAppId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendCurrentScreenDisplayReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::CurrentScreenDisplayReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendLaunchBarDisplayReqMsg(bool const & aVisibility)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::LaunchBarDisplayReqMsg)(aVisibility);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendNavTBTSwipeReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::NavTBTSwipeReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendListItemRightEncoderChangeUpdMsg(Courier::Int8 const & aSteps, Courier::UInt32 const & aListId, Courier::UInt32 const & aRowId, Courier::UInt32 const & aColumnId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ListItemRightEncoderChangeUpdMsg)(aSteps, aListId, aRowId, aColumnId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendListChangeMsg(::Courier::UInt32 const & aListId, ListChangeType const & aListChangeType, ::Courier::Int32 const & aValue, ListChangeMsgSourceType const & aListChangeMsgSource, bool const & aImmediatePositioning)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ListChangeMsg)(aListId, aListChangeType, aValue, aListChangeMsgSource, aImmediatePositioning);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendListFocusScrollReqMsg(Courier::UInt32 const & aListId, Courier::Int32 const & aSteps)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ListFocusScrollReqMsg)(aListId, aSteps);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendListFocusLockDataResetReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ListFocusLockDataResetReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSetApplicationModeReqMsg(Courier::UInt32 const & aModeId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SetApplicationModeReqMsg)(aModeId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSpellerBbehaviorReqMsg(bool const & aEnable)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SpellerBbehaviorReqMsg)(aEnable);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendStatusBarDisplayReqMsg(bool const & aVisibility, Courier::Int32 const & aHeaderType)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::StatusBarDisplayReqMsg)(aVisibility, aHeaderType);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendTBTRetriggerAcousticMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::TBTRetriggerAcousticMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendViewReqMsg(Courier::ViewAction::Enum const & aViewAction, ::Courier::ViewId const & aViewId, bool const & aShallInitScene, bool const & aShallLoadScene)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::Courier::ViewReqMsg)(aViewAction, aViewId, aShallInitScene, aShallLoadScene);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendActivationReqMsg(::Courier::ViewId const & aViewId, bool const & aActivation, bool const & aEnableRendering)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::Courier::ActivationReqMsg)(aViewId, aActivation, aEnableRendering);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendAsyncLoadReqMsg(::Courier::ViewId const & aViewId, bool const & aLoad)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::Courier::AsyncLoadReqMsg)(aViewId, aLoad);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPopupReqMsg(hmibase::popups::CommandEnum const & aCommand, ::Courier::ViewId const & aViewId, Courier::UInt32 const & aPopupDisplayID)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::PopupReqMsg)(aCommand, aViewId, aPopupDisplayID);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendExtendedViewReqMsg(hmibase::views::CommandEnum const & aCommand, ::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ExtendedViewReqMsg)(aCommand, aViewId, aHint);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendShowHMISubSurfaceReqMsg(hmibase::displayRegion const & aDisplayRegion, Courier::Int32 const & aDisplayRegionType, bool const & aShowSubSurface, Courier::UInt32 const & aDisplayID, bool const & aLockSubSurface)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ShowHMISubSurfaceReqMsg)(aDisplayRegion, aDisplayRegionType, aShowSubSurface, aDisplayID, aLockSubSurface);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendRegisterForCloseOnTouchSessionReqMsg(bool const & aRegister, ::Courier::ViewId const & aViewId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::RegisterForCloseOnTouchSessionReqMsg)(aRegister, aViewId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPopupFilterPrioEnableReqMsg(Courier::UInt32 const & aPrio)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::PopupFilterPrioEnableReqMsg)(aPrio);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPopupFilterAllEnableReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::PopupFilterAllEnableReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPopupFilterDisableReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::PopupFilterDisableReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendProfileSwitchMsg(Courier::UInt32 const & aProfile)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ProfileSwitchMsg)(aProfile);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendMultiDisplayPopupFilterReqMsg(hmibase::PopupFilterType const & aPopupFilterType, Courier::UInt32 const & aPrio, Courier::UInt32 const & aDisplayID)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::MultiDisplayPopupFilterReqMsg)(aPopupFilterType, aPrio, aDisplayID);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendCreateNewDestroyOld(::Courier::ViewId const & aSourceView, ::Courier::ViewId const & aDestinationView, Courier::UInt32 const & aUserData1, Courier::Int8 const & aUserData2)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::CreateNewDestroyOld)(aSourceView, aDestinationView, aUserData1, aUserData2);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendNotifierMessage()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::NotifierMessage)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_MediaTabGadget(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_MediaTabGadget();
    return true;
}
#endif
void Action_Perform_MediaTabGadget()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action Perform_MediaTabGadget()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSelectHomescreenMediaTab();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_MediaToggle(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_MediaToggle();
    return true;
}
#endif
void Action_Perform_MediaToggle()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action Perform_MediaToggle()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendHomescreenToggle();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_USBCameraPortInvisibility(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_USBCameraPortInvisibility();
    return true;
}
#endif
void Action_Perform_USBCameraPortInvisibility()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action Perform_USBCameraPortInvisibility()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendUSBCameraPortInvisibility();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Notify_Init_Finished(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Notify_Init_Finished();
    return true;
}
#endif
void Action_Notify_Init_Finished()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action Notify_Init_Finished()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendGuiStartupFinishedUpdMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acPerform_UsbElapsedTimeSeekBackMsg(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acPerform_UsbElapsedTimeSeekBackMsg(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acPerform_UsbElapsedTimeSeekBackMsg(Courier::UInt32 const & aSeekValue)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action acPerform_UsbElapsedTimeSeekBackMsg(aSeekValue = %d)", aSeekValue));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendUsbElapsedTimeSeekBackMsg(aSeekValue);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_OptionSelStateRespMsg(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_OptionSelStateRespMsg();
    return true;
}
#endif
void Action_OptionSelStateRespMsg()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action OptionSelStateRespMsg()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendOptionSelStateResp(Courier::UInt());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Activate_Suz_TunerNowPlaying(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Activate_Suz_TunerNowPlaying();
    return true;
}
#endif
void Action_Activate_Suz_TunerNowPlaying()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action Activate_Suz_TunerNowPlaying()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSwitchToTunerNowPlaying();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Activate_ButtonMainSrcActivate(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Activate_ButtonMainSrcActivate();
    return true;
}
#endif
void Action_Activate_ButtonMainSrcActivate()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action Activate_ButtonMainSrcActivate()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendButtonMainSrcActivate();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Activate_Suz_PreviousApplication(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Activate_Suz_PreviousApplication();
    return true;
}
#endif
void Action_Activate_Suz_PreviousApplication()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action Activate_Suz_PreviousApplication()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSwitchToPreviousApplication();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Activate_Suz_NaviApplication(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Activate_Suz_NaviApplication();
    return true;
}
#endif
void Action_Activate_Suz_NaviApplication()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action Activate_Suz_NaviApplication()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSwitchToNaviApplication();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Activate_Suz_MirrorLinkApplication(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Activate_Suz_MirrorLinkApplication();
    return true;
}
#endif
void Action_Activate_Suz_MirrorLinkApplication()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action Activate_Suz_MirrorLinkApplication()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSwitchToMirrorLinkApplication();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Activate_Suz_SoundSettingsApplication(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Activate_Suz_SoundSettingsApplication();
    return true;
}
#endif
void Action_Activate_Suz_SoundSettingsApplication()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action Activate_Suz_SoundSettingsApplication()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSwitchToSoundSettingsApplication();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Activate_LayerSoundSettingsMsg(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Activate_LayerSoundSettingsMsg();
    return true;
}
#endif
void Action_Activate_LayerSoundSettingsMsg()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action Activate_LayerSoundSettingsMsg()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendLayerSoundSettingsMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Activate_Home_Source(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Activate_Home_Source();
    return true;
}
#endif
void Action_Perform_Activate_Home_Source()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action Perform_Activate_Home_Source()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSwitchApplicationReq(APPID_APPHMI_MASTER, SURFACEID_MAIN_SURFACE_MASTER);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Activate_Suz_BTPhoneApplication(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Activate_Suz_BTPhoneApplication();
    return true;
}
#endif
void Action_Activate_Suz_BTPhoneApplication()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action Activate_Suz_BTPhoneApplication()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSwitchApplicationReq(APPID_APPHMI_PHONE, SURFACEID_MAIN_SURFACE_PHONE);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Activate_Suz_TunerApplication(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Activate_Suz_TunerApplication();
    return true;
}
#endif
void Action_Activate_Suz_TunerApplication()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action Activate_Suz_TunerApplication()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSwitchApplicationReq(APPID_APPHMI_TUNER, SURFACEID_MAIN_SURFACE_TUNER);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_MediaModule_USB2(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_MediaModule_USB2();
    return true;
}
#endif
void Action_Perform_MediaModule_USB2()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action Perform_MediaModule_USB2()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendUSB2SelectDeviceMsg(FI_EN_E8DTY_USB);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_MediaModule_USB1(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_MediaModule_USB1();
    return true;
}
#endif
void Action_Perform_MediaModule_USB1()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action Perform_MediaModule_USB1()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendUSB1SelectDeviceMsg(FI_EN_E8DTY_USB);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_MediaModule_USB(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_MediaModule_USB();
    return true;
}
#endif
void Action_Perform_MediaModule_USB()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action Perform_MediaModule_USB()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSelectDeviceSourceMsg(FI_EN_E8DTY_USB);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_MediaModule_IPOD(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_MediaModule_IPOD();
    return true;
}
#endif
void Action_Perform_MediaModule_IPOD()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action Perform_MediaModule_IPOD()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSelectDeviceSourceMsg(FI_EN_E8DTY_IPOD);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_MediaModule_SD(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_MediaModule_SD();
    return true;
}
#endif
void Action_Perform_MediaModule_SD()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action Perform_MediaModule_SD()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSelectDeviceSourceMsg(FI_EN_E8DTY_SD);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_MediaModule_BLUETOOTH(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_MediaModule_BLUETOOTH();
    return true;
}
#endif
void Action_Perform_MediaModule_BLUETOOTH()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action Perform_MediaModule_BLUETOOTH()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSelectDeviceSourceMsg(FI_EN_E8DTY_BLUETOOTH);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_MediaModule_CAMERAPORTUSB(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_MediaModule_CAMERAPORTUSB();
    return true;
}
#endif
void Action_Perform_MediaModule_CAMERAPORTUSB()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action Perform_MediaModule_CAMERAPORTUSB()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSelectDeviceSourceMsg(FI_EN_E8DTY_USB_CAMERAPORT);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_MediaModule_CAMERAPORTHDMI(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_MediaModule_CAMERAPORTHDMI();
    return true;
}
#endif
void Action_Perform_MediaModule_CAMERAPORTHDMI()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action Perform_MediaModule_CAMERAPORTHDMI()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSelectDeviceSourceMsg(FI_EN_E8DTY_USB_CAMERAPORT_HDMI);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_MediaModule_ROUTERUSB(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_MediaModule_ROUTERUSB();
    return true;
}
#endif
void Action_Perform_MediaModule_ROUTERUSB()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action Perform_MediaModule_ROUTERUSB()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSelectDeviceSourceMsg(FI_EN_E8DTY_ROUTER_USB);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_MediaModule_AUX(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_MediaModule_AUX();
    return true;
}
#endif
void Action_Perform_MediaModule_AUX()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action Perform_MediaModule_AUX()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSelectDeviceSourceMsg(FI_EN_E8DTY_AUX);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_MediaSceneMsg(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_Perform_MediaSceneMsg(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_Perform_MediaSceneMsg(Courier::UInt16 const & aMediaType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action Perform_MediaSceneMsg(aMediaType = %d)", aMediaType));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendMediaSceneMsg(aMediaType);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_MediaOperation(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_MediaOperation(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_MediaOperation(Courier::UInt16 const & aOperationType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action MediaOperation(aOperationType = %d)", aOperationType));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendMediaOperationMsgReq(aOperationType);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_MediaBTOperation(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_MediaBTOperation(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_MediaBTOperation(Courier::UInt16 const & aOperationType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action MediaBTOperation(aOperationType = %d)", aOperationType));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendMediaBTOperationMsgReq(aOperationType);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_ActivateAUXApp(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_ActivateAUXApp(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_ActivateAUXApp(Candera::UInt8 const & aCheckboxStatus)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action ActivateAUXApp(aCheckboxStatus = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendActivateAUXAppReqMsg(aCheckboxStatus);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_ActivateSDCard(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_ActivateSDCard(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_ActivateSDCard(Candera::UInt8 const & aCheckboxStatus)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action ActivateSDCard(aCheckboxStatus = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendActivateSDCardAppReqMsg(aCheckboxStatus);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_ActivateExternalDVD(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_ActivateExternalDVD(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_ActivateExternalDVD(Candera::UInt8 const & aCheckboxStatus)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action ActivateExternalDVD(aCheckboxStatus = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendActivateExternalDVDAppReqMsg(aCheckboxStatus);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_ActivateTAApp(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_ActivateTAApp(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_ActivateTAApp(Candera::UInt8 const & aCheckboxStatus)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action ActivateTAApp(aCheckboxStatus = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendActivateTAAppReqMsg(aCheckboxStatus);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acPerform_AppleHIDCommandMsg(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_acPerform_AppleHIDCommandMsg(parameters[(::Json::Value::UInt)0].asUInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_acPerform_AppleHIDCommandMsg(Courier::UInt8 const & aHIDCommand, Courier::UInt8 const & aKeyEvent)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action acPerform_AppleHIDCommandMsg(aHIDCommand = %d, aKeyEvent = %d)", aHIDCommand,aKeyEvent));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAppleHIDCommandMsg(aHIDCommand, aKeyEvent);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_HorListTabButtonItem(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_HorListTabButtonItem(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_HorListTabButtonItem(Courier::UInt8 const & aSelectMediaTab)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action HorListTabButtonItem(aSelectMediaTab = %d)", aSelectMediaTab));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendChangeHorListTabButtonRegMsg(aSelectMediaTab);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_BTBrowseButtonPressed(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_BTBrowseButtonPressed();
    return true;
}
#endif
void Action_BTBrowseButtonPressed()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action BTBrowseButtonPressed()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendBTBrowsePressedUpdMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_VideoBrowseButtonPressed(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_VideoBrowseButtonPressed();
    return true;
}
#endif
void Action_VideoBrowseButtonPressed()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action VideoBrowseButtonPressed()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendVideoBrowsePressedUpdMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_BrowseButtonPressed(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_BrowseButtonPressed();
    return true;
}
#endif
void Action_BrowseButtonPressed()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action BrowseButtonPressed()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendBrowseBtnPressedUpdMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_HorTabListBtnPageUp(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_HorTabListBtnPageUp();
    return true;
}
#endif
void Action_HorTabListBtnPageUp()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action HorTabListBtnPageUp()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendHorTabButtonPageUpReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_HorTabListBtnPageDown(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_HorTabListBtnPageDown();
    return true;
}
#endif
void Action_HorTabListBtnPageDown()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action HorTabListBtnPageDown()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendHorTabButtonPageDownReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_ExternalMediaTabBtnPressUpd(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_ExternalMediaTabBtnPressUpd(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_ExternalMediaTabBtnPressUpd(Courier::UInt8 const & aSelectMediaTab)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action ExternalMediaTabBtnPressUpd(aSelectMediaTab = %d)", aSelectMediaTab));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendExternalMediaTabBtnPressUpdMsg(aSelectMediaTab);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_ExternalBrowseScreenExitUpd(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_ExternalBrowseScreenExitUpd(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_ExternalBrowseScreenExitUpd(Courier::UInt32 const & aListId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action ExternalBrowseScreenExitUpd(aListId = %d)", aListId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendExternalBrowseScreenExitUpdMsg(aListId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_ExternalMediaTabListPageUp(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_ExternalMediaTabListPageUp();
    return true;
}
#endif
void Action_ExternalMediaTabListPageUp()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action ExternalMediaTabListPageUp()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendExternalMediaTabListPageUpReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_ExternalMediaTabListPageDown(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_ExternalMediaTabListPageDown();
    return true;
}
#endif
void Action_ExternalMediaTabListPageDown()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action ExternalMediaTabListPageDown()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendExternalMediaTabListPageDownReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_ExternalMediaBackButtonPressUpd(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_ExternalMediaBackButtonPressUpd();
    return true;
}
#endif
void Action_ExternalMediaBackButtonPressUpd()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action ExternalMediaBackButtonPressUpd()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendExternalMediaBackButtonPressUpdMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_ExternalMediaAllButtonPressUpd(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_ExternalMediaAllButtonPressUpd();
    return true;
}
#endif
void Action_ExternalMediaAllButtonPressUpd()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action ExternalMediaAllButtonPressUpd()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendExternalMediaAllButtonPressUpdMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_ExternalMediaListItemPressUpd(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_ExternalMediaListItemPressUpd(parameters[(::Json::Value::UInt)0].asUInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_ExternalMediaListItemPressUpd(Courier::UInt32 const & aHdl, Courier::UInt32 const & aSubHdl)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action ExternalMediaListItemPressUpd(aHdl = %d, aSubHdl = %d)", aHdl,aSubHdl));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendExternalMediaListItemPressUpdMsg(aHdl, aSubHdl);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_RequestPlayBackActionSeek(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_RequestPlayBackActionSeek();
    return true;
}
#endif
void Action_RequestPlayBackActionSeek()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action RequestPlayBackActionSeek()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSeekMediaAppReqMsg(Courier::Int16(), Courier::Int16());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_RequestBTPlayBackActionSeek(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_RequestBTPlayBackActionSeek();
    return true;
}
#endif
void Action_RequestBTPlayBackActionSeek()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action RequestBTPlayBackActionSeek()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSeekBTMediaAppReqMsg(Courier::Int16(), Courier::Int16());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_RequestNextBrowseTabs(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_RequestNextBrowseTabs();
    return true;
}
#endif
void Action_RequestNextBrowseTabs()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action RequestNextBrowseTabs()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendNextBrowseTabsReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_RequestPreviousBrowseTabs(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_RequestPreviousBrowseTabs();
    return true;
}
#endif
void Action_RequestPreviousBrowseTabs()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action RequestPreviousBrowseTabs()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPreviousBrowseTabsReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_RequestBrowseList(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_RequestBrowseList(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_RequestBrowseList(Courier::UInt8 const & aG_SM_ListType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action RequestBrowseList(aG_SM_ListType = %d)", aG_SM_ListType));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendBrowseListReqMsg(aG_SM_ListType);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_RequestParentFolderItems(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_RequestParentFolderItems();
    return true;
}
#endif
void Action_RequestParentFolderItems()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action RequestParentFolderItems()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendRequestUpFolderItems();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_RequestClearFolderListData(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_RequestClearFolderListData();
    return true;
}
#endif
void Action_RequestClearFolderListData()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action RequestClearFolderListData()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendClearFolderListData();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_RequestAudioAllocationForMode(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_RequestAudioAllocationForMode(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_RequestAudioAllocationForMode(tenDeviceType const & aDeviceType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action RequestAudioAllocationForMode(aDeviceType = ?tenDeviceType?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAudioAllocationForModeMsg(aDeviceType);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_FastRewindStart_Popup(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_FastRewindStart_Popup();
    return true;
}
#endif
void Action_Perform_FastRewindStart_Popup()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action Perform_FastRewindStart_Popup()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendFastForwardRewindPopupMsg(5);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_FastForwardStart_Popup(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_FastForwardStart_Popup();
    return true;
}
#endif
void Action_Perform_FastForwardStart_Popup()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action Perform_FastForwardStart_Popup()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendFastForwardRewindPopupMsg(7);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_BTDeviceNameUpdateStatusMsg(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_BTDeviceNameUpdateStatusMsg();
    return true;
}
#endif
void Action_Perform_BTDeviceNameUpdateStatusMsg()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action Perform_BTDeviceNameUpdateStatusMsg()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendUpdateBTDeviceNameUpdateStatusMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_BrowseListActive(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_BrowseListActive(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_BrowseListActive(bool const & aIsActive)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action BrowseListActive(aIsActive = %d)", aIsActive));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendBrowseListActiveRef(aIsActive);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_VideoOnSpeedRequestMsg(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_VideoOnSpeedRequestMsg();
    return true;
}
#endif
void Action_Perform_VideoOnSpeedRequestMsg()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action Perform_VideoOnSpeedRequestMsg()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendVideoOnSpeedRequestMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_VideoOnParkingBreakRequestMsg(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_VideoOnParkingBreakRequestMsg();
    return true;
}
#endif
void Action_Perform_VideoOnParkingBreakRequestMsg()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action Perform_VideoOnParkingBreakRequestMsg()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendVideoOnParkingBreakRequestMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_VideoOnEXTDVDSpeedRequestMsg(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_VideoOnEXTDVDSpeedRequestMsg();
    return true;
}
#endif
void Action_Perform_VideoOnEXTDVDSpeedRequestMsg()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action Perform_VideoOnEXTDVDSpeedRequestMsg()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendVideoOnExtDVDSpeedRequestMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_VideoOnEXTDVDParkingBreakRequestMsg(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_VideoOnEXTDVDParkingBreakRequestMsg();
    return true;
}
#endif
void Action_Perform_VideoOnEXTDVDParkingBreakRequestMsg()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action Perform_VideoOnEXTDVDParkingBreakRequestMsg()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendVideoOnExtDVDSpeedRequestMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_StartVideoStreaming(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_StartVideoStreaming();
    return true;
}
#endif
void Action_StartVideoStreaming()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action StartVideoStreaming()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDVDVideoStartStreaming();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_StartFolderViewEntryRespMsg(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_StartFolderViewEntryRespMsg();
    return true;
}
#endif
void Action_StartFolderViewEntryRespMsg()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action StartFolderViewEntryRespMsg()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendFolderViewEntryRespMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_StopFolderViewExitRespMsg(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_StopFolderViewExitRespMsg();
    return true;
}
#endif
void Action_StopFolderViewExitRespMsg()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action StopFolderViewExitRespMsg()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendFolderViewExitRespMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_StartVideoViewEntryRespMsg(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_StartVideoViewEntryRespMsg();
    return true;
}
#endif
void Action_StartVideoViewEntryRespMsg()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action StartVideoViewEntryRespMsg()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendVideoViewEntryRespMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_StopVideoViewExitRespMsg(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_StopVideoViewExitRespMsg();
    return true;
}
#endif
void Action_StopVideoViewExitRespMsg()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action StopVideoViewExitRespMsg()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendVideoViewExitRespMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_StartSDCardViewEntryRespMsg(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_StartSDCardViewEntryRespMsg();
    return true;
}
#endif
void Action_StartSDCardViewEntryRespMsg()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action StartSDCardViewEntryRespMsg()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSDCardViewEntryRespMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_StopSDCardViewExitRespMsg(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_StopSDCardViewExitRespMsg();
    return true;
}
#endif
void Action_StopSDCardViewExitRespMsg()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action StopSDCardViewExitRespMsg()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSDCardViewExitRespMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_StartUSBViewEntryRespMsg(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_StartUSBViewEntryRespMsg();
    return true;
}
#endif
void Action_StartUSBViewEntryRespMsg()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action StartUSBViewEntryRespMsg()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendUSBViewEntryRespMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_StopUSBViewExitRespMsg(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_StopUSBViewExitRespMsg();
    return true;
}
#endif
void Action_StopUSBViewExitRespMsg()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action StopUSBViewExitRespMsg()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendUSBViewExitRespMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_StopVideoStreaming(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_StopVideoStreaming();
    return true;
}
#endif
void Action_StopVideoStreaming()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action StopVideoStreaming()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDVDStopVideoStreaming();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_FastRewindStop_Popup(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_FastRewindStop_Popup();
    return true;
}
#endif
void Action_Perform_FastRewindStop_Popup()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action Perform_FastRewindStop_Popup()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendFastForwardRewindReleaseMsg(6);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_FastForwardStop_Popup(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_FastForwardStop_Popup();
    return true;
}
#endif
void Action_Perform_FastForwardStop_Popup()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action Perform_FastForwardStop_Popup()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendFastForwardRewindReleaseMsg(8);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_MediaMessage_Popup(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_MediaMessage_Popup();
    return true;
}
#endif
void Action_Perform_MediaMessage_Popup()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action Perform_MediaMessage_Popup()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendMediaMessagepopupMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_VideoOnsongRequest(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_VideoOnsongRequest();
    return true;
}
#endif
void Action_VideoOnsongRequest()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action VideoOnsongRequest()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendVideoRequest();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Video_Timer_Start(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Video_Timer_Start();
    return true;
}
#endif
void Action_Perform_Video_Timer_Start()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action Perform_Video_Timer_Start()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendStartVideoTimerMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Video_Timer_Stop(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Video_Timer_Stop();
    return true;
}
#endif
void Action_Perform_Video_Timer_Stop()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action Perform_Video_Timer_Stop()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendStopVideoTimerMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_VideoDisconnectOnSongRequest(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_VideoDisconnectOnSongRequest();
    return true;
}
#endif
void Action_VideoDisconnectOnSongRequest()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action VideoDisconnectOnSongRequest()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendVideoDisconnectRequest();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_ExternaldvdVideoConnectRequest(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_ExternaldvdVideoConnectRequest();
    return true;
}
#endif
void Action_ExternaldvdVideoConnectRequest()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action ExternaldvdVideoConnectRequest()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendExtDVDVideoConnectRequest();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_ExternalDVDDevicenameRequest(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_ExternalDVDDevicenameRequest();
    return true;
}
#endif
void Action_ExternalDVDDevicenameRequest()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action ExternalDVDDevicenameRequest()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendExtDVDDevicenameRequest();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_ExternalAuxDevicenameRequest(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_ExternalAuxDevicenameRequest();
    return true;
}
#endif
void Action_ExternalAuxDevicenameRequest()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action ExternalAuxDevicenameRequest()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAuxDevicenameRequest();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_ExternaldvdVideodisconnectRequest(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_ExternaldvdVideodisconnectRequest();
    return true;
}
#endif
void Action_ExternaldvdVideodisconnectRequest()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action ExternaldvdVideodisconnectRequest()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendExtDVDVideoDisconnectRequest();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_NowplayingAlbumartViewRequest(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_NowplayingAlbumartViewRequest();
    return true;
}
#endif
void Action_NowplayingAlbumartViewRequest()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action NowplayingAlbumartViewRequest()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendNowplayingAlbumartView();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acPerform_UpdateCurrentMediaState(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acPerform_UpdateCurrentMediaState(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acPerform_UpdateCurrentMediaState(Courier::UInt8 const & aCurrentState)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action acPerform_UpdateCurrentMediaState(aCurrentState = %d)", aCurrentState));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendCurrentMediaStateUpdMsg(aCurrentState);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acPerform_MediaSettingBackBtnPress(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acPerform_MediaSettingBackBtnPress();
    return true;
}
#endif
void Action_acPerform_MediaSettingBackBtnPress()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action acPerform_MediaSettingBackBtnPress()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendMediaSettingBackBtnPressUpdMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacChangeLanguageReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_gacChangeLanguageReq(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_gacChangeLanguageReq(enLanguageId const & aLanguageId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacChangeLanguageReq(aLanguageId = ?enLanguageId?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendChangeLanguageReqMsg(aLanguageId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacHideFocusInViewReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacHideFocusInViewReq(::Courier::ViewId(AppHmi_MediaStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacHideFocusInViewReq(::Courier::ViewId const & aView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacHideFocusInViewReq(aView = %50s)", aView.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendFocusReqMsg(FOCUS_HIDE, FOCUS_TIMER_NO_ACTION, aView, Candera::String());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_NextLevelTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_NextLevelTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_NextLevelTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action NextLevelTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_PreviousLevelTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_PreviousLevelTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_PreviousLevelTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action PreviousLevelTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_DualViewLeftTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_DualViewLeftTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_DualViewLeftTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action DualViewLeftTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_DualViewRightTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_DualViewRightTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_DualViewRightTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action DualViewRightTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_PageFlipBackTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_PageFlipBackTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_PageFlipBackTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action PageFlipBackTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_PageFlipFrontTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_PageFlipFrontTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_PageFlipFrontTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action PageFlipFrontTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_ZoomInTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 3) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt() && parameters[(::Json::Value::UInt)2].isInt())) { return false; }
    Action_ZoomInTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt(), parameters[(::Json::Value::UInt)2].asInt());
    return true;
}
#endif
void Action_ZoomInTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action ZoomInTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?, aPos = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, aPos);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_ZoomOutTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 3) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt() && parameters[(::Json::Value::UInt)2].isInt())) { return false; }
    Action_ZoomOutTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt(), parameters[(::Json::Value::UInt)2].asInt());
    return true;
}
#endif
void Action_ZoomOutTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action ZoomOutTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?, aPos = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, aPos);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_FadeTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_FadeTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_FadeTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action FadeTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacWaitAnimationStartReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacWaitAnimationStartReq();
    return true;
}
#endif
void Action_gacWaitAnimationStartReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacWaitAnimationStartReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAnimationReqMsg(Courier::AnimationAction::Start, ::Courier::ViewId(), Courier::CompositePath(), ::Courier::ItemId("Global#Animations#WAIT_ANIMATION"), Courier::AnimationProperties());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acFocusOnRightEncoderReqUpd(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_acFocusOnRightEncoderReqUpd(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_acFocusOnRightEncoderReqUpd(bool const & aIsFocusUsed)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action acFocusOnRightEncoderReqUpd(aIsFocusUsed = %d)", aIsFocusUsed));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendFocusOnRightEncoderReqUpdMsg(aIsFocusUsed);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSetGadgetSceenActiveStatus(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_acSetGadgetSceenActiveStatus(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_acSetGadgetSceenActiveStatus(bool const & aIsGadgetAtive)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action acSetGadgetSceenActiveStatus(aIsGadgetAtive = %d)", aIsGadgetAtive));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendStoreActiveGadgetReqMsg(aIsGadgetAtive);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acHKNotificationMsg(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_acHKNotificationMsg(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_acHKNotificationMsg(Courier::UInt8 const & aHKCode, Courier::UInt8 const & aHKState)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action acHKNotificationMsg(aHKCode = %d, aHKState = %d)", aHKCode,aHKState));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendHardKeyPressNotificationMsg(1, aHKCode, aHKState);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acPerform_CloseAllDropdowns(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acPerform_CloseAllDropdowns();
    return true;
}
#endif
void Action_acPerform_CloseAllDropdowns()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action acPerform_CloseAllDropdowns()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDropdownChangeMsg(Candera::DropdownChangeClose, 0);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acPerform_CloseDropdown(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acPerform_CloseDropdown(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acPerform_CloseDropdown(::Courier::UInt32 const & aListId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action acPerform_CloseDropdown(aListId = ?::Courier::UInt32?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDropdownChangeMsg(Candera::DropdownChangeClose, aListId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acPerform_OpenDropdown(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acPerform_OpenDropdown(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acPerform_OpenDropdown(::Courier::UInt32 const & aListId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action acPerform_OpenDropdown(aListId = ?::Courier::UInt32?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDropdownChangeMsg(Candera::DropdownChangeOpen, aListId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acPerform_ToggleDropdown(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acPerform_ToggleDropdown(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acPerform_ToggleDropdown(::Courier::UInt32 const & aListId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action acPerform_ToggleDropdown(aListId = ?::Courier::UInt32?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDropdownChangeMsg(Candera::DropdownChangeToggle, aListId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acStartAppPopupTimer(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_acStartAppPopupTimer(parameters[(::Json::Value::UInt)0].asUInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_acStartAppPopupTimer(Courier::UInt32 const & aViewId, Courier::UInt32 const & aTimeout)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action acStartAppPopupTimer(aViewId = %d, aTimeout = %d)", aViewId,aTimeout));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendStartPopupTimerReqMsg(aViewId, aTimeout);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acStopAppPopupTimer(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acStopAppPopupTimer(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acStopAppPopupTimer(Courier::UInt32 const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action acStopAppPopupTimer(aViewId = %d)", aViewId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendStopPopupTimerReqMsg(aViewId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acPostBeep(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_acPostBeep(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_acPostBeep(Courier::Int32 const & aBeepType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action acPostBeep(aBeepType = %d)", aBeepType));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPlayBeepReqMsg(aBeepType);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacCheckToClosePopup(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacCheckToClosePopup(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacCheckToClosePopup(Courier::UInt32 const & aPopupId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacCheckToClosePopup(aPopupId = %d)", aPopupId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendCheckToClosePopupMsg(aPopupId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acRestartAppPopupTimer(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acRestartAppPopupTimer(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acRestartAppPopupTimer(Courier::UInt32 const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action acRestartAppPopupTimer(aViewId = %d)", aViewId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendRestartPopupTimerReqMsg(aViewId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchBackRes(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacContextSwitchBackRes(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacContextSwitchBackRes(Courier::UInt32 const & aSwitchId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacContextSwitchBackRes(aSwitchId = %d)", aSwitchId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendContextSwitchInResMsg(aSwitchId, CONTEXT_TRANSITION_BACK);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchCompleteRes(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacContextSwitchCompleteRes(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacContextSwitchCompleteRes(Courier::UInt32 const & aSwitchId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacContextSwitchCompleteRes(aSwitchId = %d)", aSwitchId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendContextSwitchInResMsg(aSwitchId, CONTEXT_TRANSITION_COMPLETE);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchFailedRes(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacContextSwitchFailedRes(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacContextSwitchFailedRes(Courier::UInt32 const & aSwitchId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacContextSwitchFailedRes(aSwitchId = %d)", aSwitchId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendContextSwitchInResMsg(aSwitchId, CONTEXT_TRANSITION_FAILED);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchDoneRes(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacContextSwitchDoneRes(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacContextSwitchDoneRes(Courier::UInt32 const & aSwitchId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacContextSwitchDoneRes(aSwitchId = %d)", aSwitchId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendContextSwitchInResMsg(aSwitchId, CONTEXT_TRANSITION_DONE);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchOutReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 3) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt() && parameters[(::Json::Value::UInt)2].isUInt())) { return false; }
    Action_gacContextSwitchOutReq(parameters[(::Json::Value::UInt)0].asUInt(), parameters[(::Json::Value::UInt)1].asUInt(), parameters[(::Json::Value::UInt)2].asUInt());
    return true;
}
#endif
void Action_gacContextSwitchOutReq(Courier::UInt32 const & aTargetContextId, Courier::UInt32 const & aSourceContextId, Courier::UInt32 const & aTargetAppId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacContextSwitchOutReq(aTargetContextId = %d, aSourceContextId = %d, aTargetAppId = %d)", aTargetContextId,aSourceContextId,aTargetAppId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendContextSwitchOutReqMsg(aTargetContextId, aSourceContextId, aTargetAppId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacCurrentScreenDisplayReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacCurrentScreenDisplayReq();
    return true;
}
#endif
void Action_gacCurrentScreenDisplayReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacCurrentScreenDisplayReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendCurrentScreenDisplayReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacLaunchBarDisplayReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_gacLaunchBarDisplayReq(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_gacLaunchBarDisplayReq(bool const & aVisibility)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacLaunchBarDisplayReq(aVisibility = %d)", aVisibility));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendLaunchBarDisplayReqMsg(aVisibility);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacNavTBTSwipe(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacNavTBTSwipe();
    return true;
}
#endif
void Action_gacNavTBTSwipe()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacNavTBTSwipe()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendNavTBTSwipeReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPerformListBtnRightEncoderChangeUpd(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 4) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isUInt() && parameters[(::Json::Value::UInt)2].isUInt() && parameters[(::Json::Value::UInt)3].isUInt())) { return false; }
    Action_gacPerformListBtnRightEncoderChangeUpd(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asUInt(), parameters[(::Json::Value::UInt)2].asUInt(), parameters[(::Json::Value::UInt)3].asUInt());
    return true;
}
#endif
void Action_gacPerformListBtnRightEncoderChangeUpd(Courier::Int8 const & aSteps, Courier::UInt32 const & aListId, Courier::UInt32 const & aRowId, Courier::UInt32 const & aColumnId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacPerformListBtnRightEncoderChangeUpd(aSteps = %d, aListId = %d, aRowId = %d, aColumnId = %d)", aSteps,aListId,aRowId,aColumnId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListItemRightEncoderChangeUpdMsg(aSteps, aListId, aRowId, aColumnId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListUp(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacScrollListUp();
    return true;
}
#endif
void Action_gacScrollListUp()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacScrollListUp()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListChangeMsg(::Courier::UInt32(), ListChangeUp, 1, ListChangeMsgSourceUnknown, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListDown(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacScrollListDown();
    return true;
}
#endif
void Action_gacScrollListDown()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacScrollListDown()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListChangeMsg(::Courier::UInt32(), ListChangeDown, 1, ListChangeMsgSourceUnknown, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacScrollPageUp(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacScrollPageUp();
    return true;
}
#endif
void Action_gacScrollPageUp()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacScrollPageUp()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListChangeMsg(::Courier::UInt32(), ListChangePageUp, 1, ListChangeMsgSourceUnknown, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacScrollPageDown(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacScrollPageDown();
    return true;
}
#endif
void Action_gacScrollPageDown()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacScrollPageDown()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListChangeMsg(::Courier::UInt32(), ListChangePageDown, 1, ListChangeMsgSourceUnknown, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListFocusUp(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacScrollListFocusUp(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacScrollListFocusUp(Courier::UInt32 const & aListId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacScrollListFocusUp(aListId = %d)", aListId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListFocusScrollReqMsg(aListId, -1);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListFocusDown(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacScrollListFocusDown(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacScrollListFocusDown(Courier::UInt32 const & aListId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacScrollListFocusDown(aListId = %d)", aListId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListFocusScrollReqMsg(aListId, 1);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPerformListFocusLockDataResetUpd(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacPerformListFocusLockDataResetUpd();
    return true;
}
#endif
void Action_gacPerformListFocusLockDataResetUpd()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacPerformListFocusLockDataResetUpd()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListFocusLockDataResetReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacSetApplicationMode(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacSetApplicationMode(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacSetApplicationMode(Courier::UInt32 const & aModeId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacSetApplicationMode(aModeId = %d)", aModeId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSetApplicationModeReqMsg(aModeId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacSpellerBbehaviorReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_gacSpellerBbehaviorReq(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_gacSpellerBbehaviorReq(bool const & aEnable)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacSpellerBbehaviorReq(aEnable = %d)", aEnable));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSpellerBbehaviorReqMsg(aEnable);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacStatusBarDisplayReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_gacStatusBarDisplayReq(parameters[(::Json::Value::UInt)0].asBool(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_gacStatusBarDisplayReq(bool const & aVisibility, Courier::Int32 const & aHeaderType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacStatusBarDisplayReq(aVisibility = %d, aHeaderType = %d)", aVisibility,aHeaderType));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendStatusBarDisplayReqMsg(aVisibility, aHeaderType);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacTBTRetriggerAcousticOutput(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacTBTRetriggerAcousticOutput();
    return true;
}
#endif
void Action_gacTBTRetriggerAcousticOutput()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacTBTRetriggerAcousticOutput()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTBTRetriggerAcousticMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacWaitAnimationStopReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacWaitAnimationStopReq();
    return true;
}
#endif
void Action_gacWaitAnimationStopReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacWaitAnimationStopReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAnimationReqMsg(Courier::AnimationAction::Stop, ::Courier::ViewId(), Courier::CompositePath(), ::Courier::ItemId("Global#Animations#WAIT_ANIMATION"), Courier::AnimationProperties());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewCreateReq(::Courier::ViewId(AppHmi_MediaStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewCreateReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacViewCreateReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendViewReqMsg(Courier::ViewAction::Create, aViewId, true, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateAllReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewCreateAllReq(::Courier::ViewId(AppHmi_MediaStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewCreateAllReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacViewCreateAllReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendViewReqMsg(Courier::ViewAction::CreateAll, aViewId, true, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewDestroyReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewDestroyReq(::Courier::ViewId(AppHmi_MediaStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewDestroyReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacViewDestroyReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendViewReqMsg(Courier::ViewAction::Destroy, aViewId, false, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewClearReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewClearReq(::Courier::ViewId(AppHmi_MediaStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewClearReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacViewClearReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendViewReqMsg(Courier::ViewAction::Clear, aViewId, true, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewShowReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewShowReq(::Courier::ViewId(AppHmi_MediaStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewShowReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacViewShowReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendActivationReqMsg(aViewId, true, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewHideReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewHideReq(::Courier::ViewId(AppHmi_MediaStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewHideReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacViewHideReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendActivationReqMsg(aViewId, false, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateWithoutLoadReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewCreateWithoutLoadReq(::Courier::ViewId(AppHmi_MediaStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewCreateWithoutLoadReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacViewCreateWithoutLoadReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendViewReqMsg(Courier::ViewAction::Create, aViewId, false, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewAsyncLoadReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewAsyncLoadReq(::Courier::ViewId(AppHmi_MediaStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewAsyncLoadReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacViewAsyncLoadReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAsyncLoadReqMsg(aViewId, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewActivateWithoutRenderingReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewActivateWithoutRenderingReq(::Courier::ViewId(AppHmi_MediaStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewActivateWithoutRenderingReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacViewActivateWithoutRenderingReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendActivationReqMsg(aViewId, true, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupCreateAndSBShowReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacPopupCreateAndSBShowReq(::Courier::ViewId(AppHmi_MediaStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacPopupCreateAndSBShowReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacPopupCreateAndSBShowReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupReqMsg(hmibase::popups::Show, aViewId, hmibase::DEFAULT_UNKNOWN_DISPLAY);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupCreateAndSBShowReqForMultiDisplay(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacPopupCreateAndSBShowReqForMultiDisplay(parameters[(::Json::Value::UInt)0].asUInt(), ::Courier::ViewId(AppHmi_MediaStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)1].asUInt())));
    return true;
}
#endif
void Action_gacPopupCreateAndSBShowReqForMultiDisplay(Courier::UInt32 const & aPopupDisplayID, ::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacPopupCreateAndSBShowReqForMultiDisplay(aPopupDisplayID = %d, aViewId = %50s)", aPopupDisplayID,aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupReqMsg(hmibase::popups::Show, aViewId, aPopupDisplayID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupSBCloseReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacPopupSBCloseReq(::Courier::ViewId(AppHmi_MediaStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacPopupSBCloseReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacPopupSBCloseReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupReqMsg(hmibase::popups::Hide, aViewId, hmibase::DEFAULT_UNKNOWN_DISPLAY);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupSBCloseReqForMultiDisplay(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacPopupSBCloseReqForMultiDisplay(parameters[(::Json::Value::UInt)0].asUInt(), ::Courier::ViewId(AppHmi_MediaStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)1].asUInt())));
    return true;
}
#endif
void Action_gacPopupSBCloseReqForMultiDisplay(Courier::UInt32 const & aPopupDisplayID, ::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacPopupSBCloseReqForMultiDisplay(aPopupDisplayID = %d, aViewId = %50s)", aPopupDisplayID,aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupReqMsg(hmibase::popups::Hide, aViewId, aPopupDisplayID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupRestartTimerReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacPopupRestartTimerReq(::Courier::ViewId(AppHmi_MediaStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacPopupRestartTimerReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacPopupRestartTimerReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupReqMsg(hmibase::popups::RestartTimer, aViewId, hmibase::DEFAULT_UNKNOWN_DISPLAY);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupRestartTimerReqForMultiDisplay(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacPopupRestartTimerReqForMultiDisplay(parameters[(::Json::Value::UInt)0].asUInt(), ::Courier::ViewId(AppHmi_MediaStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)1].asUInt())));
    return true;
}
#endif
void Action_gacPopupRestartTimerReqForMultiDisplay(Courier::UInt32 const & aPopupDisplayID, ::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacPopupRestartTimerReqForMultiDisplay(aPopupDisplayID = %d, aViewId = %50s)", aPopupDisplayID,aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupReqMsg(hmibase::popups::RestartTimer, aViewId, aPopupDisplayID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateAndShowReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewCreateAndShowReq(::Courier::ViewId(AppHmi_MediaStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewCreateAndShowReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacViewCreateAndShowReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendExtendedViewReqMsg(hmibase::views::CreateAndShow, aViewId, 0);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewHideAndDestroyReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewHideAndDestroyReq(::Courier::ViewId(AppHmi_MediaStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewHideAndDestroyReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacViewHideAndDestroyReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendExtendedViewReqMsg(hmibase::views::HideAndDestroy, aViewId, 0);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacSceneTransitionEnter(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacSceneTransitionEnter(::Courier::ViewId(AppHmi_MediaStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt(), ))parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacSceneTransitionEnter(::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacSceneTransitionEnter(aViewId = %50s, aHint = %d)", aViewId.CStr(),aHint));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendExtendedViewReqMsg(hmibase::views::TransitionEnter, aViewId, aHint);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacSceneTransitionLeave(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacSceneTransitionLeave(::Courier::ViewId(AppHmi_MediaStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt(), ))parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacSceneTransitionLeave(::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacSceneTransitionLeave(aViewId = %50s, aHint = %d)", aViewId.CStr(),aHint));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendExtendedViewReqMsg(hmibase::views::TransitionLeave, aViewId, aHint);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayStatusLineReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_gacDisplayStatusLineReq(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_gacDisplayStatusLineReq(Courier::Int32 const & aDisplayRegionType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacDisplayStatusLineReq(aDisplayRegionType = %d)", aDisplayRegionType));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::STATUS_LINE, aDisplayRegionType, true, hmibase::DEFAULT_UNKNOWN_DISPLAY, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacHideStatusLineReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_gacHideStatusLineReq(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_gacHideStatusLineReq(Courier::Int32 const & aDisplayRegionType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacHideStatusLineReq(aDisplayRegionType = %d)", aDisplayRegionType));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::STATUS_LINE, aDisplayRegionType, false, hmibase::DEFAULT_UNKNOWN_DISPLAY, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayFooterLineReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacDisplayFooterLineReq();
    return true;
}
#endif
void Action_gacDisplayFooterLineReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacDisplayFooterLineReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::FOOTER_LINE, Courier::Int32(), true, hmibase::DEFAULT_UNKNOWN_DISPLAY, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacHideFooterLineReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacHideFooterLineReq();
    return true;
}
#endif
void Action_gacHideFooterLineReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacHideFooterLineReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::FOOTER_LINE, Courier::Int32(), false, hmibase::DEFAULT_UNKNOWN_DISPLAY, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayStatusLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacDisplayStatusLineMultiDisplayReq(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacDisplayStatusLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacDisplayStatusLineMultiDisplayReq(aDisplayRegionType = %d, aDisplayID = %d)", aDisplayRegionType,aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::STATUS_LINE, aDisplayRegionType, true, aDisplayID, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacHideStatusLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacHideStatusLineMultiDisplayReq(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacHideStatusLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacHideStatusLineMultiDisplayReq(aDisplayRegionType = %d, aDisplayID = %d)", aDisplayRegionType,aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::STATUS_LINE, aDisplayRegionType, false, aDisplayID, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayFooterLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacDisplayFooterLineMultiDisplayReq(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacDisplayFooterLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacDisplayFooterLineMultiDisplayReq(aDisplayRegionType = %d, aDisplayID = %d)", aDisplayRegionType,aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::FOOTER_LINE, aDisplayRegionType, true, aDisplayID, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacHideFooterLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacHideFooterLineMultiDisplayReq(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacHideFooterLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacHideFooterLineMultiDisplayReq(aDisplayRegionType = %d, aDisplayID = %d)", aDisplayRegionType,aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::FOOTER_LINE, aDisplayRegionType, false, aDisplayID, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacRegisterForCloseOnTouchSession(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacRegisterForCloseOnTouchSession(::Courier::ViewId(AppHmi_MediaStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacRegisterForCloseOnTouchSession(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacRegisterForCloseOnTouchSession(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendRegisterForCloseOnTouchSessionReqMsg(true, aViewId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacDeregisterForCloseOnTouchSessionReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacDeregisterForCloseOnTouchSessionReq(::Courier::ViewId(AppHmi_MediaStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacDeregisterForCloseOnTouchSessionReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacDeregisterForCloseOnTouchSessionReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendRegisterForCloseOnTouchSessionReqMsg(false, aViewId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterPrioEnableReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacPopupFilterPrioEnableReq(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacPopupFilterPrioEnableReq(Courier::UInt32 const & aPrio)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacPopupFilterPrioEnableReq(aPrio = %d)", aPrio));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupFilterPrioEnableReqMsg(aPrio);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterAllEnableReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacPopupFilterAllEnableReq();
    return true;
}
#endif
void Action_gacPopupFilterAllEnableReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacPopupFilterAllEnableReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupFilterAllEnableReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterDisableReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacPopupFilterDisableReq();
    return true;
}
#endif
void Action_gacPopupFilterDisableReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacPopupFilterDisableReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupFilterDisableReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacProfileChange(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_gacProfileChange(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_gacProfileChange(Courier::UInt32 const & aProfile)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacProfileChange(aProfile = %d)", aProfile));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendProfileSwitchMsg(aProfile);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterPrioEnableReqForDisplay(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacPopupFilterPrioEnableReqForDisplay(parameters[(::Json::Value::UInt)0].asUInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacPopupFilterPrioEnableReqForDisplay(Courier::UInt32 const & aPrio, Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacPopupFilterPrioEnableReqForDisplay(aPrio = %d, aDisplayID = %d)", aPrio,aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendMultiDisplayPopupFilterReqMsg(hmibase::ENABLE_PRIO, aPrio, aDisplayID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterAllEnableReqForDisplay(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacPopupFilterAllEnableReqForDisplay(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacPopupFilterAllEnableReqForDisplay(Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacPopupFilterAllEnableReqForDisplay(aDisplayID = %d)", aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendMultiDisplayPopupFilterReqMsg(hmibase::ENABLE_ALL, 0, aDisplayID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterDisableReqForDisplay(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacPopupFilterDisableReqForDisplay(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacPopupFilterDisableReqForDisplay(Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacPopupFilterDisableReqForDisplay(aDisplayID = %d)", aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendMultiDisplayPopupFilterReqMsg(hmibase::DISABLE_ALL, 0, aDisplayID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacStartSceneTransitionAnimation(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 4) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt() && parameters[(::Json::Value::UInt)2].isUInt() && parameters[(::Json::Value::UInt)3].isInt())) { return false; }
    Action_gacStartSceneTransitionAnimation(::Courier::ViewId(AppHmi_MediaStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt(), ))::Courier::ViewId(AppHmi_MediaStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)1].asUInt(), ))parameters[(::Json::Value::UInt)2].asUInt(), parameters[(::Json::Value::UInt)3].asInt());
    return true;
}
#endif
void Action_gacStartSceneTransitionAnimation(::Courier::ViewId const & aSourceView, ::Courier::ViewId const & aDestinationView, Courier::UInt32 const & aUserData1, Courier::Int8 const & aUserData2)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacStartSceneTransitionAnimation(aSourceView = %50s, aDestinationView = %50s, aUserData1 = %d, aUserData2 = %d)", aSourceView.CStr(),aDestinationView.CStr(),aUserData1,aUserData2));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendCreateNewDestroyOld(aSourceView, aDestinationView, aUserData1, aUserData2);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacDecrementActiveAnimationCount(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacDecrementActiveAnimationCount();
    return true;
}
#endif
void Action_gacDecrementActiveAnimationCount()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MEDIA_SM, "SM_ACTIONS:    Trigger action gacDecrementActiveAnimationCount()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendNotifierMessage();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_IsMediaMessageAvailable(const ::Json::Value& /* parameters */, ::Json::Value &response)
{
    response["result"] = (bool)Action_IsMediaMessageAvailable();
    return true;
}
#endif
bool Action_IsMediaMessageAvailable()
{
    const bool* dataItem = ::Courier::Internal::AsyncGenericModelBindingSource::GetDataItemValue< const bool >(
        ::Courier::ComponentId(::Courier::ComponentType::Controller),
        ItemKey::DeviceConnectStatus::MediaMessageUpdateFlagItem);
    return (dataItem == 0) ? bool() : (bool)*dataItem;
}
//====  defines and includes TTFis output - added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====    

unsigned short AppHmi_MediaStateMachineImpl::GetTraceClass (){  
   return TR_CLASS_APPHMI_MEDIA_SM; 
}

//====  member function with TTFis output - end                        key: SM_TTFis_SBHFMSRF ==== 

#include "hmibase/util/Macros.h"

#ifdef CIT_SIMULATION
#define CIT_EVENT_ID(eventId, hashId) hashId
#else
#define CIT_EVENT_ID(eventId, hashId) eventId
#endif
// ------------------------------------------------------------------------

#if !defined onActivatePopUp
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onActivatePopUp 0xffff
#pragma _REMINDER("Using dummy value symbol onActivatePopUp ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onActivatePopUp -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForActivatePopUpMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(onActivatePopUp, 0x7E1514D3);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActivatePopUpMsg(AppHmi_MediaStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::ActivatePopUpMsg const & message = static_cast< ::ActivatePopUpMsg const &>(aMessage);
#ifdef onActivatePopUp
    if (eventId == onActivatePopUp) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetPopUpId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onActivatePopUp.PopUpId = message.GetPopUpId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onDeActivatePopUp
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onDeActivatePopUp 0xffff
#pragma _REMINDER("Using dummy value symbol onDeActivatePopUp ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onDeActivatePopUp -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForDeActivatePopUpMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(onDeActivatePopUp, 0xFC60099E);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForDeActivatePopUpMsg(AppHmi_MediaStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::DeActivatePopUpMsg const & message = static_cast< ::DeActivatePopUpMsg const &>(aMessage);
#ifdef onDeActivatePopUp
    if (eventId == onDeActivatePopUp) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetPopUpId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onDeActivatePopUp.PopUpId = message.GetPopUpId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForActivateApplicationMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnActivateApplicationMsg, 0xC70281BB);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActivateApplicationMsg(AppHmi_MediaStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForDeactivateApplicationMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnDeactivateApplicationMsg, 0x37E7CAFB);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForDeactivateApplicationMsg(AppHmi_MediaStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForAudioSongSelectionMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnAudioSongSelectionMsg, 0x08AEB6E8);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForAudioSongSelectionMsg(AppHmi_MediaStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForVideoSongSelectionMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnVideoSongSelectionMsg, 0xB19FAE70);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForVideoSongSelectionMsg(AppHmi_MediaStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForPlayAudioVideoSong(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnPlayAudioVideoSong, 0xA22BE2AB);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForPlayAudioVideoSong(AppHmi_MediaStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForActicvateAlbumSceneMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnActicvateAlbumSceneMsg, 0x3CB85614);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActicvateAlbumSceneMsg(AppHmi_MediaStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForActicvateVideorestrictionpopupmessage(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnActicvateVideorestrictionpopupmessage, 0x9C9DB457);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActicvateVideorestrictionpopupmessage(AppHmi_MediaStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForNewListEntryMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnNewListEntryMsg, 0xA9749321);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForNewListEntryMsg(AppHmi_MediaStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForButtonReactionMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::ButtonReactionMsg const & message = static_cast< ::ButtonReactionMsg const &>(aMessage);

#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_ButtonWidget2D_Back_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_SourceSelection_Media")) && (message.GetSender() == ::Courier::Identifier(0xeca16c04 /* ButtonWidget2D_Back */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_ButtonWidget2D_Back_enRelease, 0xE6DA3619); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayer_Pop_Up_Pfo_MediaMessage_Btn_MediaMessage_2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayer_Pop_Up#Pfo_MediaMessage")) && (message.GetSender() == ::Courier::Identifier(0x32edeaee /* Btn_MediaMessage_2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayer_Pop_Up_Pfo_MediaMessage_Btn_MediaMessage_2D_enRelease, 0x1B4F4FB6); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayer_Pop_Up_Pfo_MediaConfirmBTPairing_Layer_Yes_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayer_Pop_Up#Pfo_MediaConfirmBTPairing")) && (message.GetSender() == ::Courier::Identifier(0xeaebbe6c /* Layer_Yes/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayer_Pop_Up_Pfo_MediaConfirmBTPairing_Layer_Yes_ButtonWidget_enRelease, 0xCA7255C0); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayer_Pop_Up_Pfo_MediaConfirmBTPairing_Layer_No_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayer_Pop_Up#Pfo_MediaConfirmBTPairing")) && (message.GetSender() == ::Courier::Identifier(0xb5018479 /* Layer_No/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayer_Pop_Up_Pfo_MediaConfirmBTPairing_Layer_No_ButtonWidget_enRelease, 0x3F7DA2E7); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_Browse_ButtonWidget2D_Back_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_Browse")) && (message.GetSender() == ::Courier::Identifier(0xeca16c04 /* ButtonWidget2D_Back */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_Browse_ButtonWidget2D_Back_enRelease, 0x8D99E8B8); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_Artist_Album_ButtonWidget2D_Back_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_Artist_Album")) && (message.GetSender() == ::Courier::Identifier(0xeca16c04 /* ButtonWidget2D_Back */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_Artist_Album_ButtonWidget2D_Back_enRelease, 0x17F3DB70); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_Artist_Album_ButtonWidget2D_Up_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_Artist_Album")) && (message.GetSender() == ::Courier::Identifier(0x3cce3ffa /* ButtonWidget2D_Up */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_Artist_Album_ButtonWidget2D_Up_enRelease, 0xEB88273C); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_Artist_Album_ButtonWidget2D_AllTitles_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_Artist_Album")) && (message.GetSender() == ::Courier::Identifier(0x22b9bfe9 /* ButtonWidget2D_AllTitles */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_Artist_Album_ButtonWidget2D_AllTitles_enRelease, 0x508C833C); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_Artist_Album_Title_ButtonWidget2D_Back_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_Artist_Album_Title")) && (message.GetSender() == ::Courier::Identifier(0xeca16c04 /* ButtonWidget2D_Back */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_Artist_Album_Title_ButtonWidget2D_Back_enRelease, 0x257EA9A6); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_Artist_Album_Title_ButtonWidget2D_Up_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_Artist_Album_Title")) && (message.GetSender() == ::Courier::Identifier(0x3cce3ffa /* ButtonWidget2D_Up */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_Artist_Album_Title_ButtonWidget2D_Up_enRelease, 0x2BC3836D); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_USB_Layer_TouchArea_Source_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_USB")) && (message.GetSender() == ::Courier::Identifier(0xccdf81cf /* Layer_TouchArea_Source/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_USB_Layer_TouchArea_Source_ButtonWidget_enRelease, 0x10A64155); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_Genre_Artist_Album_ButtonWidget2D_Browse_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_Genre_Artist_Album")) && (message.GetSender() == ::Courier::Identifier(0x77d82fd6 /* ButtonWidget2D_Browse */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_Genre_Artist_Album_ButtonWidget2D_Browse_enRelease, 0x7C0BAEEC); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_Genre_Artist_Album_ButtonWidget2D_GenreArtAlbUp_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_Genre_Artist_Album")) && (message.GetSender() == ::Courier::Identifier(0xae0a1399 /* ButtonWidget2D_GenreArtAlbUp */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_Genre_Artist_Album_ButtonWidget2D_GenreArtAlbUp_enRelease, 0x6FEA8791); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_Genre_Artist_Album_ButtonWidget2D_GenreArtAlbAllTitles_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_Genre_Artist_Album")) && (message.GetSender() == ::Courier::Identifier(0x3313b482 /* ButtonWidget2D_GenreArtAlbAllTitles */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_Genre_Artist_Album_ButtonWidget2D_GenreArtAlbAllTitles_enRelease, 0xE9A647F4); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_Genre_Title_ButtonWidget2D_Browse_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_Genre_Title")) && (message.GetSender() == ::Courier::Identifier(0x77d82fd6 /* ButtonWidget2D_Browse */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_Genre_Title_ButtonWidget2D_Browse_enRelease, 0xFAF250CA); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_Genre_Title_ButtonWidget2D_Up_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_Genre_Title")) && (message.GetSender() == ::Courier::Identifier(0x3cce3ffa /* ButtonWidget2D_Up */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_Genre_Title_ButtonWidget2D_Up_enRelease, 0x3240BE5B); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_Genre_AllAlbums_ButtonWidget2D_Browse_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_Genre_AllAlbums")) && (message.GetSender() == ::Courier::Identifier(0x77d82fd6 /* ButtonWidget2D_Browse */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_Genre_AllAlbums_ButtonWidget2D_Browse_enRelease, 0x34C997FD); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_Genre_AllAlbums_ButtonWidget2D_Up_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_Genre_AllAlbums")) && (message.GetSender() == ::Courier::Identifier(0x3cce3ffa /* ButtonWidget2D_Up */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_Genre_AllAlbums_ButtonWidget2D_Up_enRelease, 0x26643E69); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_Genre_Artist_ButtonWidget2D_Browse_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_Genre_Artist")) && (message.GetSender() == ::Courier::Identifier(0x77d82fd6 /* ButtonWidget2D_Browse */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_Genre_Artist_ButtonWidget2D_Browse_enRelease, 0xE27E6143); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_Genre_Artist_ButtonWidget2D_Up_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_Genre_Artist")) && (message.GetSender() == ::Courier::Identifier(0x3cce3ffa /* ButtonWidget2D_Up */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_Genre_Artist_ButtonWidget2D_Up_enRelease, 0xD00E34DA); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_Genre_Artist_ButtonWidget2D_AllAlbums_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_Genre_Artist")) && (message.GetSender() == ::Courier::Identifier(0xba5692f5 /* ButtonWidget2D_AllAlbums */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_Genre_Artist_ButtonWidget2D_AllAlbums_enRelease, 0x72B647CA); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_BT_Layer_TouchArea_Source_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_BT")) && (message.GetSender() == ::Courier::Identifier(0xccdf81cf /* Layer_TouchArea_Source/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_BT_Layer_TouchArea_Source_ButtonWidget_enRelease, 0xD81BA747); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_BT_TouchArea_SourceInfoM_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_BT")) && (message.GetSender() == ::Courier::Identifier(0xe1c7ab76 /* TouchArea_SourceInfoM/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_BT_TouchArea_SourceInfoM_ButtonWidget_enRelease, 0xAC914560); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_BT_Layer_TouchArea_PlayPause_touched_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_BT")) && (message.GetSender() == ::Courier::Identifier(0xcd0f9441 /* Layer_TouchArea_PlayPause_touched/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_BT_Layer_TouchArea_PlayPause_touched_ButtonWidget2D_enRelease, 0x3AF692A4); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_BT_Layer_TouchArea_Repeat_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_BT")) && (message.GetSender() == ::Courier::Identifier(0xcbe54532 /* Layer_TouchArea_Repeat/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_BT_Layer_TouchArea_Repeat_ButtonWidget2D_enRelease, 0x2A66DF0A); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_BT_Layer_TouchArea_Shuffle_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_BT")) && (message.GetSender() == ::Courier::Identifier(0xf79ff856 /* Layer_TouchArea_Shuffle/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_BT_Layer_TouchArea_Shuffle_ButtonWidget2D_enRelease, 0xCB239938); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_BT_Layer_TouchArea_Next_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_BT")) && (message.GetSender() == ::Courier::Identifier(0x4e7f0732 /* Layer_TouchArea_Next/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_BT_Layer_TouchArea_Next_ButtonWidget_enRelease, 0xCCA2A0F0); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_BT_Layer_TouchArea_Previous_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_BT")) && (message.GetSender() == ::Courier::Identifier(0x0e79dedf /* Layer_TouchArea_Previous/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_BT_Layer_TouchArea_Previous_ButtonWidget_enRelease, 0xC3305219); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_CAMPORTHDMI_3_Layer_TouchArea_Source_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_CAMPORTHDMI_3")) && (message.GetSender() == ::Courier::Identifier(0xccdf81cf /* Layer_TouchArea_Source/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_CAMPORTHDMI_3_Layer_TouchArea_Source_ButtonWidget_enRelease, 0x0EBF0542); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_BT_Layer_Progressbar_SliderWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_BT")) && (message.GetSender() == ::Courier::Identifier(0x16421d92 /* Layer_Progressbar/SliderWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_BT_Layer_Progressbar_SliderWidget2D_enRelease, 0x39430FA5); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_CAMPORTHDMI_2_Layer_TouchArea_Source_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_CAMPORTHDMI_2")) && (message.GetSender() == ::Courier::Identifier(0xccdf81cf /* Layer_TouchArea_Source/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_CAMPORTHDMI_2_Layer_TouchArea_Source_ButtonWidget_enRelease, 0x668E52B3); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_AUX_ButtonWidget2D_Source_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_AUX")) && (message.GetSender() == ::Courier::Identifier(0x125e6914 /* ButtonWidget2D_Source */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_AUX_ButtonWidget2D_Source_enRelease, 0xBA9EFA80); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoPlayer_Layer_TouchArea_PlayPause_touched_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_VideoPlayer")) && (message.GetSender() == ::Courier::Identifier(0xcd0f9441 /* Layer_TouchArea_PlayPause_touched/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoPlayer_Layer_TouchArea_PlayPause_touched_ButtonWidget2D_enRelease, 0xE69C7F1E); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoPlayer_Layer_TouchArea_Previous_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_VideoPlayer")) && (message.GetSender() == ::Courier::Identifier(0x0e79dedf /* Layer_TouchArea_Previous/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoPlayer_Layer_TouchArea_Previous_ButtonWidget_enRelease, 0xE61DEB5E); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoPlayer_Layer_TouchArea_Next_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_VideoPlayer")) && (message.GetSender() == ::Courier::Identifier(0x4e7f0732 /* Layer_TouchArea_Next/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoPlayer_Layer_TouchArea_Next_ButtonWidget_enRelease, 0x4C1F4544); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoPlayer_Layer_TouchArea_Previous_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_VideoPlayer")) && (message.GetSender() == ::Courier::Identifier(0x0e79dedf /* Layer_TouchArea_Previous/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoPlayer_Layer_TouchArea_Previous_ButtonWidget_enLongPress, 0x69E689C9); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoPlayer_Layer_TouchArea_Previous_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_VideoPlayer")) && (message.GetSender() == ::Courier::Identifier(0x0e79dedf /* Layer_TouchArea_Previous/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoPlayer_Layer_TouchArea_Previous_ButtonWidget_enLongPressRelease, 0x1F4792F5); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoPlayer_Layer_TouchArea_Next_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_VideoPlayer")) && (message.GetSender() == ::Courier::Identifier(0x4e7f0732 /* Layer_TouchArea_Next/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoPlayer_Layer_TouchArea_Next_ButtonWidget_enLongPress, 0x276C47F3); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoPlayer_Layer_TouchArea_Next_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_VideoPlayer")) && (message.GetSender() == ::Courier::Identifier(0x4e7f0732 /* Layer_TouchArea_Next/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoPlayer_Layer_TouchArea_Next_ButtonWidget_enLongPressRelease, 0x3AC84C6F); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoPlayer_Layer_Progressbar_SliderWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_VideoPlayer")) && (message.GetSender() == ::Courier::Identifier(0x16421d92 /* Layer_Progressbar/SliderWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoPlayer_Layer_Progressbar_SliderWidget2D_enRelease, 0xB364073E); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoPlayer_Layer_Bg_Video_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_VideoPlayer")) && (message.GetSender() == ::Courier::Identifier(0xc8f4bf0b /* Layer_Bg_Video/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoPlayer_Layer_Bg_Video_ButtonWidget_enRelease, 0x015CB9E4); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoPlayer_Layer_AppFlyIn_ButtonWidget2D_Phone_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_VideoPlayer")) && (message.GetSender() == ::Courier::Identifier(0x6f985d7e /* Layer_AppFlyIn/ButtonWidget2D_Phone */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoPlayer_Layer_AppFlyIn_ButtonWidget2D_Phone_enRelease, 0x11B82E5A); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoPlayer_Layer_AppFlyIn_ButtonWidget2D_Radio_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_VideoPlayer")) && (message.GetSender() == ::Courier::Identifier(0xd6fbef00 /* Layer_AppFlyIn/ButtonWidget2D_Radio */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoPlayer_Layer_AppFlyIn_ButtonWidget2D_Radio_enRelease, 0x2877E5CD); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoPlayer_Layer_AppFlyIn_ButtonWidget2D_MirrorLink_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_VideoPlayer")) && (message.GetSender() == ::Courier::Identifier(0xc12f6d49 /* Layer_AppFlyIn/ButtonWidget2D_MirrorLink */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoPlayer_Layer_AppFlyIn_ButtonWidget2D_MirrorLink_enRelease, 0x4176710B); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoPlayer_Layer_AppFlyIn_ButtonWidget2D_Navi_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_VideoPlayer")) && (message.GetSender() == ::Courier::Identifier(0xe599f8f8 /* Layer_AppFlyIn/ButtonWidget2D_Navi */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoPlayer_Layer_AppFlyIn_ButtonWidget2D_Navi_enRelease, 0x00AD06BB); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoPlayer_Layer_TouchArea_SourceInfo_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_VideoPlayer")) && (message.GetSender() == ::Courier::Identifier(0x2c6a7de5 /* Layer_TouchArea_SourceInfo/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoPlayer_Layer_TouchArea_SourceInfo_ButtonWidget_enRelease, 0xAB7974EF); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoPlayer_FullScreen_Layer_Bg_Video_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_VideoPlayer_FullScreen")) && (message.GetSender() == ::Courier::Identifier(0xc8f4bf0b /* Layer_Bg_Video/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoPlayer_FullScreen_Layer_Bg_Video_ButtonWidget_enRelease, 0x338448AE); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoPlayer_FullScreen_Icon_Pause_Button_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_VideoPlayer_FullScreen")) && (message.GetSender() == ::Courier::Identifier(0x5d653602 /* Icon_Pause/Button */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoPlayer_FullScreen_Icon_Pause_Button_enRelease, 0x9AA88997); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_ExternalDVD_ButtonWidget2D_ExtDVD_Back_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_ExternalDVD")) && (message.GetSender() == ::Courier::Identifier(0x28dfc367 /* ButtonWidget2D_ExtDVD_Back */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_ExternalDVD_ButtonWidget2D_ExtDVD_Back_enRelease, 0x7AD778E9); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_ExternalDVD_Layer_AppFlyIn_ButtonWidget2D_MirrorLink_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_ExternalDVD")) && (message.GetSender() == ::Courier::Identifier(0xc12f6d49 /* Layer_AppFlyIn/ButtonWidget2D_MirrorLink */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_ExternalDVD_Layer_AppFlyIn_ButtonWidget2D_MirrorLink_enRelease, 0x60B0C6A9); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_ExternalDVD_Layer_AppFlyIn_ButtonWidget2D_Radio_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_ExternalDVD")) && (message.GetSender() == ::Courier::Identifier(0xd6fbef00 /* Layer_AppFlyIn/ButtonWidget2D_Radio */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_ExternalDVD_Layer_AppFlyIn_ButtonWidget2D_Radio_enRelease, 0xD30BCACE); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_ExternalDVD_Layer_AppFlyIn_ButtonWidget2D_Phone_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_ExternalDVD")) && (message.GetSender() == ::Courier::Identifier(0x6f985d7e /* Layer_AppFlyIn/ButtonWidget2D_Phone */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_ExternalDVD_Layer_AppFlyIn_ButtonWidget2D_Phone_enRelease, 0x8FBD2A94); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_ExternalDVD_ButtonWidget2D_ExternalDVD_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_ExternalDVD")) && (message.GetSender() == ::Courier::Identifier(0x03b25dbd /* ButtonWidget2D_ExternalDVD */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_ExternalDVD_ButtonWidget2D_ExternalDVD_enRelease, 0xF4148746); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_ExternalDVD_Layer_AppFlyIn_ButtonWidget2D_Navi_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_ExternalDVD")) && (message.GetSender() == ::Courier::Identifier(0xe599f8f8 /* Layer_AppFlyIn/ButtonWidget2D_Navi */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_ExternalDVD_Layer_AppFlyIn_ButtonWidget2D_Navi_enRelease, 0x0603B089); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_ExternalDVD_FullScreen_ButtonWidget2D_ExtDVDFullScreen_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_ExternalDVD_FullScreen")) && (message.GetSender() == ::Courier::Identifier(0x241c3cd2 /* ButtonWidget2D_ExtDVDFullScreen */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_ExternalDVD_FullScreen_ButtonWidget2D_ExtDVDFullScreen_enRelease, 0x9EE7031D); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_AUX_Layer_AppFlyIn_ButtonWidget2D_MirrorLink_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_AUX")) && (message.GetSender() == ::Courier::Identifier(0xc12f6d49 /* Layer_AppFlyIn/ButtonWidget2D_MirrorLink */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_AUX_Layer_AppFlyIn_ButtonWidget2D_MirrorLink_enRelease, 0xFA689B3C); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_AUX_Layer_AppFlyIn_ButtonWidget2D_Radio_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_AUX")) && (message.GetSender() == ::Courier::Identifier(0xd6fbef00 /* Layer_AppFlyIn/ButtonWidget2D_Radio */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_AUX_Layer_AppFlyIn_ButtonWidget2D_Radio_enRelease, 0x410812A4); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_AUX_Layer_AppFlyIn_ButtonWidget2D_Phone_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_AUX")) && (message.GetSender() == ::Courier::Identifier(0x6f985d7e /* Layer_AppFlyIn/ButtonWidget2D_Phone */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_AUX_Layer_AppFlyIn_ButtonWidget2D_Phone_enRelease, 0xC266640E); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_AUX_Layer_AppFlyIn_ButtonWidget2D_Navi_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_AUX")) && (message.GetSender() == ::Courier::Identifier(0xe599f8f8 /* Layer_AppFlyIn/ButtonWidget2D_Navi */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_AUX_Layer_AppFlyIn_ButtonWidget2D_Navi_enRelease, 0x03F6D3C7); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_CAMPORTHDMI_1_Layer_TouchArea_Source_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_CAMPORTHDMI_1")) && (message.GetSender() == ::Courier::Identifier(0xccdf81cf /* Layer_TouchArea_Source/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_CAMPORTHDMI_1_Layer_TouchArea_Source_ButtonWidget_enRelease, 0x7BDE9BF1); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoPlayer_Layer_TouchArea_Source_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_VideoPlayer")) && (message.GetSender() == ::Courier::Identifier(0xccdf81cf /* Layer_TouchArea_Source/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoPlayer_Layer_TouchArea_Source_ButtonWidget_enRelease, 0x3E4200A2); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_BT_Layer_TouchArea_Previous_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_BT")) && (message.GetSender() == ::Courier::Identifier(0x0e79dedf /* Layer_TouchArea_Previous/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_BT_Layer_TouchArea_Previous_ButtonWidget_enLongPress, 0x852A3076); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_BT_Layer_TouchArea_Next_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_BT")) && (message.GetSender() == ::Courier::Identifier(0x4e7f0732 /* Layer_TouchArea_Next/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_BT_Layer_TouchArea_Next_ButtonWidget_enLongPress, 0x30C68BC4); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBROUTER_Layer_TouchArea_Repeat_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_USBROUTER")) && (message.GetSender() == ::Courier::Identifier(0xcbe54532 /* Layer_TouchArea_Repeat/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBROUTER_Layer_TouchArea_Repeat_ButtonWidget2D_enRelease, 0x2D56E3BA); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBROUTER_Layer_TouchArea_Shuffle_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_USBROUTER")) && (message.GetSender() == ::Courier::Identifier(0xf79ff856 /* Layer_TouchArea_Shuffle/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBROUTER_Layer_TouchArea_Shuffle_ButtonWidget2D_enRelease, 0x1491BF1A); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBROUTER_Layer_TouchArea_Previous_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_USBROUTER")) && (message.GetSender() == ::Courier::Identifier(0x0e79dedf /* Layer_TouchArea_Previous/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBROUTER_Layer_TouchArea_Previous_ButtonWidget_enRelease, 0xC5DA527D); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBROUTER_Layer_TouchArea_Previous_ButtonWidget_enAbortPress
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_USBROUTER")) && (message.GetSender() == ::Courier::Identifier(0x0e79dedf /* Layer_TouchArea_Previous/ButtonWidget */)) && (message.GetEnReaction() == enAbortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBROUTER_Layer_TouchArea_Previous_ButtonWidget_enAbortPress, 0x113F1960); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBROUTER_Layer_TouchArea_Next_ButtonWidget_enAbortPress
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_USBROUTER")) && (message.GetSender() == ::Courier::Identifier(0x4e7f0732 /* Layer_TouchArea_Next/ButtonWidget */)) && (message.GetEnReaction() == enAbortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBROUTER_Layer_TouchArea_Next_ButtonWidget_enAbortPress, 0xB6678AA4); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBROUTER_Layer_TouchArea_Next_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_USBROUTER")) && (message.GetSender() == ::Courier::Identifier(0x4e7f0732 /* Layer_TouchArea_Next/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBROUTER_Layer_TouchArea_Next_ButtonWidget_enRelease, 0x260247B1); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBROUTER_Layer_TouchArea_Previous_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_USBROUTER")) && (message.GetSender() == ::Courier::Identifier(0x0e79dedf /* Layer_TouchArea_Previous/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBROUTER_Layer_TouchArea_Previous_ButtonWidget_enLongPress, 0x4F2C93B2); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBROUTER_Layer_TouchArea_Previous_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_USBROUTER")) && (message.GetSender() == ::Courier::Identifier(0x0e79dedf /* Layer_TouchArea_Previous/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBROUTER_Layer_TouchArea_Previous_ButtonWidget_enLongPressRelease, 0xBC04BFA6); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBROUTER_Layer_TouchArea_Next_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_USBROUTER")) && (message.GetSender() == ::Courier::Identifier(0x4e7f0732 /* Layer_TouchArea_Next/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBROUTER_Layer_TouchArea_Next_ButtonWidget_enLongPress, 0xAC02F5E9); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBROUTER_Layer_TouchArea_Next_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_USBROUTER")) && (message.GetSender() == ::Courier::Identifier(0x4e7f0732 /* Layer_TouchArea_Next/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBROUTER_Layer_TouchArea_Next_ButtonWidget_enLongPressRelease, 0x3CFF5A38); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBROUTER_Layer_Progressbar_SliderWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_USBROUTER")) && (message.GetSender() == ::Courier::Identifier(0x16421d92 /* Layer_Progressbar/SliderWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBROUTER_Layer_Progressbar_SliderWidget2D_enRelease, 0xFB598A70); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBROUTER_Layer_TouchArea_Source_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_USBROUTER")) && (message.GetSender() == ::Courier::Identifier(0xccdf81cf /* Layer_TouchArea_Source/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBROUTER_Layer_TouchArea_Source_ButtonWidget_enRelease, 0xDD31831E); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_Album_Title_ButtonWidget2D_Back_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_Album_Title")) && (message.GetSender() == ::Courier::Identifier(0xeca16c04 /* ButtonWidget2D_Back */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_Album_Title_ButtonWidget2D_Back_enRelease, 0x1EC6E3B5); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_Album_Title_ButtonWidget2D_Up_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_Album_Title")) && (message.GetSender() == ::Courier::Identifier(0x3cce3ffa /* ButtonWidget2D_Up */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_Album_Title_ButtonWidget2D_Up_enRelease, 0x47714017); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_Title_ButtonWidget2D_Back_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_Title")) && (message.GetSender() == ::Courier::Identifier(0xeca16c04 /* ButtonWidget2D_Back */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_Title_ButtonWidget2D_Back_enRelease, 0xC045E1AD); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_Artist_ButtonWidget2D_Back_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_Artist")) && (message.GetSender() == ::Courier::Identifier(0xeca16c04 /* ButtonWidget2D_Back */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_Artist_ButtonWidget2D_Back_enRelease, 0x4E0FE823); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_Album_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_Album")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_Album_Layer_TouchArea_Back_ButtonWidget_enRelease, 0x9650FEE3); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_Genre_ButtonWidget2D_Back_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_Genre")) && (message.GetSender() == ::Courier::Identifier(0xeca16c04 /* ButtonWidget2D_Back */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_Genre_ButtonWidget2D_Back_enRelease, 0x0076487C); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_Podcast_ButtonWidget2D_Back_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_Podcast")) && (message.GetSender() == ::Courier::Identifier(0xeca16c04 /* ButtonWidget2D_Back */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_Podcast_ButtonWidget2D_Back_enRelease, 0x9CBD8087); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_Playlist_ButtonWidget2D_Back_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_Playlist")) && (message.GetSender() == ::Courier::Identifier(0xeca16c04 /* ButtonWidget2D_Back */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_Playlist_ButtonWidget2D_Back_enRelease, 0x568EEF8A); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_Audiobook_ButtonWidget2D_Back_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_Audiobook")) && (message.GetSender() == ::Courier::Identifier(0xeca16c04 /* ButtonWidget2D_Back */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_Audiobook_ButtonWidget2D_Back_enRelease, 0x93348F0E); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_Video_ButtonWidget2D_Back_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_Video")) && (message.GetSender() == ::Courier::Identifier(0xeca16c04 /* ButtonWidget2D_Back */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_Video_ButtonWidget2D_Back_enRelease, 0x7B118B59); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_Folder_ButtonWidget2D_Back_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_Folder")) && (message.GetSender() == ::Courier::Identifier(0xeca16c04 /* ButtonWidget2D_Back */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_Folder_ButtonWidget2D_Back_enRelease, 0xB1B45BB5); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_Album_PageUpButton_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_Album")) && (message.GetSender() == ::Courier::Identifier(0x2be0503a /* PageUpButton/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_Album_PageUpButton_ButtonWidget2D_enRelease, 0x97D907D9); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_Album_PageDownButton_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_Album")) && (message.GetSender() == ::Courier::Identifier(0x980aa48f /* PageDownButton/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_Album_PageDownButton_ButtonWidget2D_enRelease, 0x985E3A53); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_Album_External_PageUpButton_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_Album_External")) && (message.GetSender() == ::Courier::Identifier(0x2be0503a /* PageUpButton/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_Album_External_PageUpButton_ButtonWidget2D_enRelease, 0x4D820EE8); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_Album_External_PageDownButton_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_Album_External")) && (message.GetSender() == ::Courier::Identifier(0x980aa48f /* PageDownButton/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_Album_External_PageDownButton_ButtonWidget2D_enRelease, 0xC0C2534D); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBROUTER_Layer_TouchArea_PlayPause_touched_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_USBROUTER")) && (message.GetSender() == ::Courier::Identifier(0xcd0f9441 /* Layer_TouchArea_PlayPause_touched/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBROUTER_Layer_TouchArea_PlayPause_touched_ButtonWidget2D_enRelease, 0x906325CA); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_BT_Layer_TouchArea_Previous_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_BT")) && (message.GetSender() == ::Courier::Identifier(0x0e79dedf /* Layer_TouchArea_Previous/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_BT_Layer_TouchArea_Previous_ButtonWidget_enLongPressRelease, 0x2A2BCC3E); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBROUTER_TouchArea_SourceInfoM_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_USBROUTER")) && (message.GetSender() == ::Courier::Identifier(0xe1c7ab76 /* TouchArea_SourceInfoM/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBROUTER_TouchArea_SourceInfoM_ButtonWidget_enRelease, 0x0CF74F8F); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBCAMERAPORT_Layer_Progressbar_SliderWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_USBCAMERAPORT")) && (message.GetSender() == ::Courier::Identifier(0x16421d92 /* Layer_Progressbar/SliderWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBCAMERAPORT_Layer_Progressbar_SliderWidget2D_enRelease, 0x5342E1BA); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_BT_Layer_TouchArea_Next_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_BT")) && (message.GetSender() == ::Courier::Identifier(0x4e7f0732 /* Layer_TouchArea_Next/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_BT_Layer_TouchArea_Next_ButtonWidget_enLongPressRelease, 0xCA5D0252); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_BT_Layer_AppFlyIn_ButtonWidget2D_Navi_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_BT")) && (message.GetSender() == ::Courier::Identifier(0xe599f8f8 /* Layer_AppFlyIn/ButtonWidget2D_Navi */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_BT_Layer_AppFlyIn_ButtonWidget2D_Navi_enRelease, 0x955736EE); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_BT_Layer_AppFlyIn_ButtonWidget2D_Phone_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_BT")) && (message.GetSender() == ::Courier::Identifier(0x6f985d7e /* Layer_AppFlyIn/ButtonWidget2D_Phone */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_BT_Layer_AppFlyIn_ButtonWidget2D_Phone_enRelease, 0xB8FEAFD9); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_BT_Layer_AppFlyIn_ButtonWidget2D_MirrorLink_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_BT")) && (message.GetSender() == ::Courier::Identifier(0xc12f6d49 /* Layer_AppFlyIn/ButtonWidget2D_MirrorLink */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_BT_Layer_AppFlyIn_ButtonWidget2D_MirrorLink_enRelease, 0x4BA43327); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_BT_Layer_AppFlyIn_ButtonWidget2D_Radio_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_BT")) && (message.GetSender() == ::Courier::Identifier(0xd6fbef00 /* Layer_AppFlyIn/ButtonWidget2D_Radio */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_BT_Layer_AppFlyIn_ButtonWidget2D_Radio_enRelease, 0x8704E204); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_Audiobook_Chapter_ButtonWidget2D_Browse_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_Audiobook_Chapter")) && (message.GetSender() == ::Courier::Identifier(0x77d82fd6 /* ButtonWidget2D_Browse */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_Audiobook_Chapter_ButtonWidget2D_Browse_enRelease, 0xADFD0969); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_Audiobook_Chapter_ButtonWidget2D_Up_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_Audiobook_Chapter")) && (message.GetSender() == ::Courier::Identifier(0x3cce3ffa /* ButtonWidget2D_Up */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_Audiobook_Chapter_ButtonWidget2D_Up_enRelease, 0x5527AC87); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_Playlist_Title_ButtonWidget2D_Browse_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_Playlist_Title")) && (message.GetSender() == ::Courier::Identifier(0x77d82fd6 /* ButtonWidget2D_Browse */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_Playlist_Title_ButtonWidget2D_Browse_enRelease, 0xB70D4F28); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_Playlist_Title_ButtonWidget2D_Up_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_Playlist_Title")) && (message.GetSender() == ::Courier::Identifier(0x3cce3ffa /* ButtonWidget2D_Up */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_Playlist_Title_ButtonWidget2D_Up_enRelease, 0x5B6DB552); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_Podcast_Episode_ButtonWidget2D_Browse_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_Podcast_Episode")) && (message.GetSender() == ::Courier::Identifier(0x77d82fd6 /* ButtonWidget2D_Browse */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_Podcast_Episode_ButtonWidget2D_Browse_enRelease, 0x9A49AFF9); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_Podcast_Episode_ButtonWidget2D_Up_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_Podcast_Episode")) && (message.GetSender() == ::Courier::Identifier(0x3cce3ffa /* ButtonWidget2D_Up */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_Podcast_Episode_ButtonWidget2D_Up_enRelease, 0x415A4C14); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoEpisode_ButtonWidget2D_Back_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_VideoEpisode")) && (message.GetSender() == ::Courier::Identifier(0xeca16c04 /* ButtonWidget2D_Back */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoEpisode_ButtonWidget2D_Back_enRelease, 0x67204134); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoEpisode_ButtonWidget2D_Up_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_VideoEpisode")) && (message.GetSender() == ::Courier::Identifier(0x3cce3ffa /* ButtonWidget2D_Up */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoEpisode_ButtonWidget2D_Up_enRelease, 0xC8C9C829); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_Folder_File_ButtonWidget2D_Up_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_Folder_File")) && (message.GetSender() == ::Courier::Identifier(0x3cce3ffa /* ButtonWidget2D_Up */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_Folder_File_ButtonWidget2D_Up_enRelease, 0x0D28BE09); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_Folder_File_ButtonWidget2D_Browse_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_Folder_File")) && (message.GetSender() == ::Courier::Identifier(0x77d82fd6 /* ButtonWidget2D_Browse */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_Folder_File_ButtonWidget2D_Browse_enRelease, 0x579F7D7A); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBCAMERAPORT_TouchArea_SourceInfoM_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_USBCAMERAPORT")) && (message.GetSender() == ::Courier::Identifier(0xe1c7ab76 /* TouchArea_SourceInfoM/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBCAMERAPORT_TouchArea_SourceInfoM_ButtonWidget_enRelease, 0xCFF2BD86); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBCAMERAPORT_Layer_TouchArea_PlayPause_touched_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_USBCAMERAPORT")) && (message.GetSender() == ::Courier::Identifier(0xcd0f9441 /* Layer_TouchArea_PlayPause_touched/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBCAMERAPORT_Layer_TouchArea_PlayPause_touched_ButtonWidget2D_enRelease, 0x5F15DC39); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBCAMERAPORT_Layer_TouchArea_Repeat_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_USBCAMERAPORT")) && (message.GetSender() == ::Courier::Identifier(0xcbe54532 /* Layer_TouchArea_Repeat/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBCAMERAPORT_Layer_TouchArea_Repeat_ButtonWidget2D_enRelease, 0xA0D66461); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBCAMERAPORT_Layer_TouchArea_Shuffle_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_USBCAMERAPORT")) && (message.GetSender() == ::Courier::Identifier(0xf79ff856 /* Layer_TouchArea_Shuffle/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBCAMERAPORT_Layer_TouchArea_Shuffle_ButtonWidget2D_enRelease, 0x75EC7557); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBCAMERAPORT_Layer_TouchArea_Previous_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_USBCAMERAPORT")) && (message.GetSender() == ::Courier::Identifier(0x0e79dedf /* Layer_TouchArea_Previous/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBCAMERAPORT_Layer_TouchArea_Previous_ButtonWidget_enRelease, 0xBCEA84D4); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBCAMERAPORT_Layer_TouchArea_Previous_ButtonWidget_enAbortPress
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_USBCAMERAPORT")) && (message.GetSender() == ::Courier::Identifier(0x0e79dedf /* Layer_TouchArea_Previous/ButtonWidget */)) && (message.GetEnReaction() == enAbortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBCAMERAPORT_Layer_TouchArea_Previous_ButtonWidget_enAbortPress, 0x4E8E41CD); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBCAMERAPORT_Layer_TouchArea_Next_ButtonWidget_enAbortPress
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_USBCAMERAPORT")) && (message.GetSender() == ::Courier::Identifier(0x4e7f0732 /* Layer_TouchArea_Next/ButtonWidget */)) && (message.GetEnReaction() == enAbortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBCAMERAPORT_Layer_TouchArea_Next_ButtonWidget_enAbortPress, 0x49216A70); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBCAMERAPORT_Layer_TouchArea_Next_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_USBCAMERAPORT")) && (message.GetSender() == ::Courier::Identifier(0x4e7f0732 /* Layer_TouchArea_Next/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBCAMERAPORT_Layer_TouchArea_Next_ButtonWidget_enRelease, 0x4E4C386C); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBCAMERAPORT_Layer_TouchArea_Previous_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_USBCAMERAPORT")) && (message.GetSender() == ::Courier::Identifier(0x0e79dedf /* Layer_TouchArea_Previous/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBCAMERAPORT_Layer_TouchArea_Previous_ButtonWidget_enLongPress, 0x642A343F); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBCAMERAPORT_Layer_TouchArea_Previous_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_USBCAMERAPORT")) && (message.GetSender() == ::Courier::Identifier(0x0e79dedf /* Layer_TouchArea_Previous/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBCAMERAPORT_Layer_TouchArea_Previous_ButtonWidget_enLongPressRelease, 0xC8D96BB1); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBCAMERAPORT_Layer_TouchArea_Next_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_USBCAMERAPORT")) && (message.GetSender() == ::Courier::Identifier(0x4e7f0732 /* Layer_TouchArea_Next/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBCAMERAPORT_Layer_TouchArea_Next_ButtonWidget_enLongPress, 0x132A0CF7); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBCAMERAPORT_Layer_TouchArea_Next_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_USBCAMERAPORT")) && (message.GetSender() == ::Courier::Identifier(0x4e7f0732 /* Layer_TouchArea_Next/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBCAMERAPORT_Layer_TouchArea_Next_ButtonWidget_enLongPressRelease, 0xAECC11F2); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBCAMERAPORT_Layer_TouchArea_Source_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_USBCAMERAPORT")) && (message.GetSender() == ::Courier::Identifier(0xccdf81cf /* Layer_TouchArea_Source/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBCAMERAPORT_Layer_TouchArea_Source_ButtonWidget_enRelease, 0x943B225F); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_Album_External_Button_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_Album_External")) && (message.GetSender() == ::Courier::Identifier(0xfd511ba4 /* Button_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_Album_External_Button_Back_ButtonWidget_enRelease, 0x290DF9A2); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_USB_Layer_AppFlyIn_ButtonWidget2D_MirrorLink_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_USB")) && (message.GetSender() == ::Courier::Identifier(0xc12f6d49 /* Layer_AppFlyIn/ButtonWidget2D_MirrorLink */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_USB_Layer_AppFlyIn_ButtonWidget2D_MirrorLink_enRelease, 0xA2E0872F); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_OPT_woRDS_tgBtn_Checkbox_ActivateAUX_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_OPT_woRDS")) && (message.GetSender() == ::Courier::Identifier(0x5aa4c625 /* tgBtn_Checkbox_ActivateAUX */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_OPT_woRDS_tgBtn_Checkbox_ActivateAUX_enRelease, 0x977D9652); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_TouchArea_Next_ButtonWidget_enAbortPress
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_AppleDevice")) && (message.GetSender() == ::Courier::Identifier(0x4e7f0732 /* Layer_TouchArea_Next/ButtonWidget */)) && (message.GetEnReaction() == enAbortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_TouchArea_Next_ButtonWidget_enAbortPress, 0xF8F1AE5F); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoPlayer_Layer_TouchArea_Previous_ButtonWidget_enAbortPress
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_VideoPlayer")) && (message.GetSender() == ::Courier::Identifier(0x0e79dedf /* Layer_TouchArea_Previous/ButtonWidget */)) && (message.GetEnReaction() == enAbortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoPlayer_Layer_TouchArea_Previous_ButtonWidget_enAbortPress, 0x4B001347); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoPlayer_Layer_TouchArea_Next_ButtonWidget_enAbortPress
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_VideoPlayer")) && (message.GetSender() == ::Courier::Identifier(0x4e7f0732 /* Layer_TouchArea_Next/ButtonWidget */)) && (message.GetEnReaction() == enAbortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoPlayer_Layer_TouchArea_Next_ButtonWidget_enAbortPress, 0xD0F6494A); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_Album_External_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_Album_External")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_Album_External_Layer_TouchArea_Back_ButtonWidget_enRelease, 0x27AC2BC2); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_Gadget_Media_MASTER__GADGET_MEDIA_Btn_Previous_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#Gadget_Media#MASTER__GADGET_MEDIA")) && (message.GetSender() == ::Courier::Identifier(0xd3bad9ef /* Btn_Previous/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_Gadget_Media_MASTER__GADGET_MEDIA_Btn_Previous_ButtonWidget_enRelease, 0x3FB14949); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_Gadget_Media_MASTER__GADGET_MEDIA_Btn_Previous_ButtonWidget_enPress
    if ((message.GetView() == ::Courier::ViewId("Media#Gadget_Media#MASTER__GADGET_MEDIA")) && (message.GetSender() == ::Courier::Identifier(0xd3bad9ef /* Btn_Previous/ButtonWidget */)) && (message.GetEnReaction() == enPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_Gadget_Media_MASTER__GADGET_MEDIA_Btn_Previous_ButtonWidget_enPress, 0x82BC71AC); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_Gadget_Media_MASTER__GADGET_MEDIA_Btn_Previous_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("Media#Gadget_Media#MASTER__GADGET_MEDIA")) && (message.GetSender() == ::Courier::Identifier(0xd3bad9ef /* Btn_Previous/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_Gadget_Media_MASTER__GADGET_MEDIA_Btn_Previous_ButtonWidget_enLongPress, 0xBC92553E); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_Gadget_Media_MASTER__GADGET_MEDIA_Background_Button_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#Gadget_Media#MASTER__GADGET_MEDIA")) && (message.GetSender() == ::Courier::Identifier(0x1217dd47 /* Background_Button/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_Gadget_Media_MASTER__GADGET_MEDIA_Background_Button_ButtonWidget_enRelease, 0xD6FF523D); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_Gadget_Media_MASTER__GADGET_MEDIA_Btn_Previous_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("Media#Gadget_Media#MASTER__GADGET_MEDIA")) && (message.GetSender() == ::Courier::Identifier(0xd3bad9ef /* Btn_Previous/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_Gadget_Media_MASTER__GADGET_MEDIA_Btn_Previous_ButtonWidget_enLongPressRelease, 0xFF6CB401); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_Gadget_Media_MASTER__GADGET_MEDIA_Btn_Previous_ButtonWidget_enAbortPress
    if ((message.GetView() == ::Courier::ViewId("Media#Gadget_Media#MASTER__GADGET_MEDIA")) && (message.GetSender() == ::Courier::Identifier(0xd3bad9ef /* Btn_Previous/ButtonWidget */)) && (message.GetEnReaction() == enAbortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_Gadget_Media_MASTER__GADGET_MEDIA_Btn_Previous_ButtonWidget_enAbortPress, 0x64488146); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_Gadget_Media_MASTER__GADGET_MEDIA_Btn_Next_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#Gadget_Media#MASTER__GADGET_MEDIA")) && (message.GetSender() == ::Courier::Identifier(0x3b0da4f7 /* Btn_Next/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_Gadget_Media_MASTER__GADGET_MEDIA_Btn_Next_ButtonWidget_enRelease, 0xC3A2D02F); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_Gadget_Media_MASTER__GADGET_MEDIA_Btn_Next_ButtonWidget_enPress
    if ((message.GetView() == ::Courier::ViewId("Media#Gadget_Media#MASTER__GADGET_MEDIA")) && (message.GetSender() == ::Courier::Identifier(0x3b0da4f7 /* Btn_Next/ButtonWidget */)) && (message.GetEnReaction() == enPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_Gadget_Media_MASTER__GADGET_MEDIA_Btn_Next_ButtonWidget_enPress, 0x213807EB); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_Gadget_Media_MASTER__GADGET_MEDIA_Btn_Next_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("Media#Gadget_Media#MASTER__GADGET_MEDIA")) && (message.GetSender() == ::Courier::Identifier(0x3b0da4f7 /* Btn_Next/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_Gadget_Media_MASTER__GADGET_MEDIA_Btn_Next_ButtonWidget_enLongPress, 0xAAF6DEAE); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_Gadget_Media_MASTER__GADGET_MEDIA_Btn_Next_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("Media#Gadget_Media#MASTER__GADGET_MEDIA")) && (message.GetSender() == ::Courier::Identifier(0x3b0da4f7 /* Btn_Next/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_Gadget_Media_MASTER__GADGET_MEDIA_Btn_Next_ButtonWidget_enLongPressRelease, 0x3FFA3F8E); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_Gadget_Media_MASTER__GADGET_MEDIA_Btn_Next_ButtonWidget_enAbortPress
    if ((message.GetView() == ::Courier::ViewId("Media#Gadget_Media#MASTER__GADGET_MEDIA")) && (message.GetSender() == ::Courier::Identifier(0x3b0da4f7 /* Btn_Next/ButtonWidget */)) && (message.GetEnReaction() == enAbortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_Gadget_Media_MASTER__GADGET_MEDIA_Btn_Next_ButtonWidget_enAbortPress, 0x619A36E8); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_Gadget_Media_MASTER__GADGET_MEDIA_Btn_Play_Pause_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#Gadget_Media#MASTER__GADGET_MEDIA")) && (message.GetSender() == ::Courier::Identifier(0x2a336180 /* Btn_Play_Pause/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_Gadget_Media_MASTER__GADGET_MEDIA_Btn_Play_Pause_ButtonWidget2D_enRelease, 0x09D97341); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_Gadget_Media_MASTER__GADGET_MEDIA_Btn_Play_Pause_ButtonWidget2D_enPress
    if ((message.GetView() == ::Courier::ViewId("Media#Gadget_Media#MASTER__GADGET_MEDIA")) && (message.GetSender() == ::Courier::Identifier(0x2a336180 /* Btn_Play_Pause/ButtonWidget2D */)) && (message.GetEnReaction() == enPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_Gadget_Media_MASTER__GADGET_MEDIA_Btn_Play_Pause_ButtonWidget2D_enPress, 0x2AEB8A5B); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_Gadget_Media_MASTER__GADGET_MEDIA_Btn_Play_Pause_ButtonWidget2D_enAbortPress
    if ((message.GetView() == ::Courier::ViewId("Media#Gadget_Media#MASTER__GADGET_MEDIA")) && (message.GetSender() == ::Courier::Identifier(0x2a336180 /* Btn_Play_Pause/ButtonWidget2D */)) && (message.GetEnReaction() == enAbortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_Gadget_Media_MASTER__GADGET_MEDIA_Btn_Play_Pause_ButtonWidget2D_enAbortPress, 0xD82BC9AE); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_Gadget_Media_MASTER__GADGET_MEDIA_HomescreenMediaTabText_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#Gadget_Media#MASTER__GADGET_MEDIA")) && (message.GetSender() == ::Courier::Identifier(0x59039a85 /* HomescreenMediaTabText/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_Gadget_Media_MASTER__GADGET_MEDIA_HomescreenMediaTabText_ButtonWidget_enRelease, 0xB877E525); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_Gadget_Media_MASTER__GADGET_MEDIA_HomescreenMediaTabIcon_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#Gadget_Media#MASTER__GADGET_MEDIA")) && (message.GetSender() == ::Courier::Identifier(0xaf0a2fb5 /* HomescreenMediaTabIcon/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_Gadget_Media_MASTER__GADGET_MEDIA_HomescreenMediaTabIcon_ButtonWidget_enRelease, 0x2CD3A7C2); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_USB_Layer_TouchArea_Next_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_USB")) && (message.GetSender() == ::Courier::Identifier(0x4e7f0732 /* Layer_TouchArea_Next/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_USB_Layer_TouchArea_Next_ButtonWidget_enRelease, 0x5D69B6B3); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_USB_Layer_TouchArea_Previous_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_USB")) && (message.GetSender() == ::Courier::Identifier(0x0e79dedf /* Layer_TouchArea_Previous/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_USB_Layer_TouchArea_Previous_ButtonWidget_enLongPress, 0xF72B9F0E); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_USB_Layer_TouchArea_Previous_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_USB")) && (message.GetSender() == ::Courier::Identifier(0x0e79dedf /* Layer_TouchArea_Previous/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_USB_Layer_TouchArea_Previous_ButtonWidget_enLongPressRelease, 0x3E63D0E7); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_USB_Layer_TouchArea_Next_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_USB")) && (message.GetSender() == ::Courier::Identifier(0x4e7f0732 /* Layer_TouchArea_Next/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_USB_Layer_TouchArea_Next_ButtonWidget_enLongPress, 0xA5EBD937); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_USB_Layer_TouchArea_Next_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_USB")) && (message.GetSender() == ::Courier::Identifier(0x4e7f0732 /* Layer_TouchArea_Next/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_USB_Layer_TouchArea_Next_ButtonWidget_enLongPressRelease, 0x146A7E8F); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_USB_Layer_Progressbar_SliderWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_USB")) && (message.GetSender() == ::Courier::Identifier(0x16421d92 /* Layer_Progressbar/SliderWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_USB_Layer_Progressbar_SliderWidget2D_enRelease, 0x64268C5A); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_USB_Layer_AppFlyIn_ButtonWidget2D_Phone_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_USB")) && (message.GetSender() == ::Courier::Identifier(0x6f985d7e /* Layer_AppFlyIn/ButtonWidget2D_Phone */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_USB_Layer_AppFlyIn_ButtonWidget2D_Phone_enRelease, 0x3CE9391C); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_TouchArea_Previous_ButtonWidget_enAbortPress
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_AppleDevice")) && (message.GetSender() == ::Courier::Identifier(0x0e79dedf /* Layer_TouchArea_Previous/ButtonWidget */)) && (message.GetEnReaction() == enAbortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_TouchArea_Previous_ButtonWidget_enAbortPress, 0x9C4C19AB); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_USB_Layer_AppFlyIn_ButtonWidget2D_Navi_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_USB")) && (message.GetSender() == ::Courier::Identifier(0xe599f8f8 /* Layer_AppFlyIn/ButtonWidget2D_Navi */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_USB_Layer_AppFlyIn_ButtonWidget2D_Navi_enRelease, 0x6CECBECF); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_BT_Layer_TouchArea_Next_ButtonWidget_enAbortPress
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_BT")) && (message.GetSender() == ::Courier::Identifier(0x4e7f0732 /* Layer_TouchArea_Next/ButtonWidget */)) && (message.GetEnReaction() == enAbortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_BT_Layer_TouchArea_Next_ButtonWidget_enAbortPress, 0x57A07100); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_USB_Layer_TouchArea_Next_ButtonWidget_enAbortPress
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_USB")) && (message.GetSender() == ::Courier::Identifier(0x4e7f0732 /* Layer_TouchArea_Next/ButtonWidget */)) && (message.GetEnReaction() == enAbortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_USB_Layer_TouchArea_Next_ButtonWidget_enAbortPress, 0x7DD7D84C); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_ButtonWidget2D_Media_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_SourceSelection_Media")) && (message.GetSender() == ::Courier::Identifier(0x312a8eee /* ButtonWidget2D_Media */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_ButtonWidget2D_Media_enRelease, 0xEA6686A1); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_Layer_TabRadio_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_SourceSelection_Media")) && (message.GetSender() == ::Courier::Identifier(0xe38eb662 /* Layer_TabRadio/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_Layer_TabRadio_ButtonWidget_enRelease, 0x85EF1917); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_Layer_AppleDevice_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_SourceSelection_Media")) && (message.GetSender() == ::Courier::Identifier(0xd6928639 /* Layer_AppleDevice/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_Layer_AppleDevice_ButtonWidget_enRelease, 0x89BE0089); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_Layer_Aux_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_SourceSelection_Media")) && (message.GetSender() == ::Courier::Identifier(0x489d68b6 /* Layer_Aux/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_Layer_Aux_ButtonWidget_enRelease, 0x7A5FA526); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_AUX_Layer_TouchArea_Source_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_AUX")) && (message.GetSender() == ::Courier::Identifier(0xccdf81cf /* Layer_TouchArea_Source/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_AUX_Layer_TouchArea_Source_ButtonWidget_enRelease, 0xA16E4912); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_Layer_USB_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_SourceSelection_Media")) && (message.GetSender() == ::Courier::Identifier(0xd30a7b8a /* Layer_USB/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_Layer_USB_ButtonWidget_enRelease, 0x5AC6AA89); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_Layer_USB_CameraPort_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_SourceSelection_Media")) && (message.GetSender() == ::Courier::Identifier(0xf708c1e5 /* Layer_USB_CameraPort/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_Layer_USB_CameraPort_ButtonWidget_enRelease, 0x31FDE017); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_Layer_USB2_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_SourceSelection_Media")) && (message.GetSender() == ::Courier::Identifier(0x344ff9f5 /* Layer_USB2/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_Layer_USB2_ButtonWidget_enRelease, 0x8F5649E1); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_Layer_HDMI_CameraPort_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_SourceSelection_Media")) && (message.GetSender() == ::Courier::Identifier(0x14d7d659 /* Layer_HDMI_CameraPort/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_Layer_HDMI_CameraPort_ButtonWidget_enRelease, 0x54B11634); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_Layer_Settings_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_SourceSelection_Media")) && (message.GetSender() == ::Courier::Identifier(0x202ad7c0 /* Layer_Settings/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_Layer_Settings_ButtonWidget_enRelease, 0xB5A2CDBE); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_Layer_BT_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_SourceSelection_Media")) && (message.GetSender() == ::Courier::Identifier(0x69abc0e5 /* Layer_BT/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_Layer_BT_ButtonWidget_enRelease, 0xA8B007FA); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_ButtonWidget2D_SDCard_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_SourceSelection_Media")) && (message.GetSender() == ::Courier::Identifier(0x0bee70b1 /* ButtonWidget2D_SDCard */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_ButtonWidget2D_SDCard_enRelease, 0x10ABA1C1); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_Layer_TouchArea_Source_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_SourceSelection_Media")) && (message.GetSender() == ::Courier::Identifier(0xccdf81cf /* Layer_TouchArea_Source/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_Layer_TouchArea_Source_ButtonWidget_enRelease, 0x04AB7E70); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_woNAV_ButtonWidget2D_Back_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_SourceSelection_Media_woNAV")) && (message.GetSender() == ::Courier::Identifier(0xeca16c04 /* ButtonWidget2D_Back */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_woNAV_ButtonWidget2D_Back_enRelease, 0x1F7A5D23); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_woNAV_ButtonWidget2D_Media_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_SourceSelection_Media_woNAV")) && (message.GetSender() == ::Courier::Identifier(0x312a8eee /* ButtonWidget2D_Media */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_woNAV_ButtonWidget2D_Media_enRelease, 0xA1FF8A3F); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_woNAV_ButtonWidget2D_AppleDevice_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_SourceSelection_Media_woNAV")) && (message.GetSender() == ::Courier::Identifier(0x8e7adbe1 /* ButtonWidget2D_AppleDevice */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_woNAV_ButtonWidget2D_AppleDevice_enRelease, 0x0F23F1F0); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_woNAV_ButtonWidget2D_Aux_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_SourceSelection_Media_woNAV")) && (message.GetSender() == ::Courier::Identifier(0x2d596d06 /* ButtonWidget2D_Aux */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_woNAV_ButtonWidget2D_Aux_enRelease, 0x89907345); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_woNAV_ButtonWidget2D_USB_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_SourceSelection_Media_woNAV")) && (message.GetSender() == ::Courier::Identifier(0x9f5b1e96 /* ButtonWidget2D_USB */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_woNAV_ButtonWidget2D_USB_enRelease, 0x8731478D); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_woNAV_ButtonWidget2D_ExternalDVD_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_SourceSelection_Media_woNAV")) && (message.GetSender() == ::Courier::Identifier(0x03b25dbd /* ButtonWidget2D_ExternalDVD */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_woNAV_ButtonWidget2D_ExternalDVD_enRelease, 0x73009A92); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_woNAV_ButtonWidget2D_BT_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_SourceSelection_Media_woNAV")) && (message.GetSender() == ::Courier::Identifier(0xd3c01653 /* ButtonWidget2D_BT */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_woNAV_ButtonWidget2D_BT_enRelease, 0x5639F3C7); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_woNAV_ButtonWidget2D_SDCard_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_SourceSelection_Media_woNAV")) && (message.GetSender() == ::Courier::Identifier(0x0bee70b1 /* ButtonWidget2D_SDCard */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_woNAV_ButtonWidget2D_SDCard_enRelease, 0x4093A801); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_USB_TouchArea_SourceInfoM_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_USB")) && (message.GetSender() == ::Courier::Identifier(0xe1c7ab76 /* TouchArea_SourceInfoM/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_USB_TouchArea_SourceInfoM_ButtonWidget_enRelease, 0xCAFD7978); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_USB_Layer_TouchArea_PlayPause_touched_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_USB")) && (message.GetSender() == ::Courier::Identifier(0xcd0f9441 /* Layer_TouchArea_PlayPause_touched/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_USB_Layer_TouchArea_PlayPause_touched_ButtonWidget2D_enRelease, 0x5642715E); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_USB_Layer_TouchArea_Repeat_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_USB")) && (message.GetSender() == ::Courier::Identifier(0xcbe54532 /* Layer_TouchArea_Repeat/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_USB_Layer_TouchArea_Repeat_ButtonWidget2D_enRelease, 0xD58DC6F5); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_USB_Layer_TouchArea_Shuffle_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_USB")) && (message.GetSender() == ::Courier::Identifier(0xf79ff856 /* Layer_TouchArea_Shuffle/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_USB_Layer_TouchArea_Shuffle_ButtonWidget2D_enRelease, 0xA8129B9B); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_USB_Layer_TouchArea_Previous_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_USB")) && (message.GetSender() == ::Courier::Identifier(0x0e79dedf /* Layer_TouchArea_Previous/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_USB_Layer_TouchArea_Previous_ButtonWidget_enRelease, 0xEB2766EF); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_USB_Layer_TouchArea_Previous_ButtonWidget_enAbortPress
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_USB")) && (message.GetSender() == ::Courier::Identifier(0x0e79dedf /* Layer_TouchArea_Previous/ButtonWidget */)) && (message.GetEnReaction() == enAbortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_USB_Layer_TouchArea_Previous_ButtonWidget_enAbortPress, 0x3944963D); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_BT_Layer_TouchArea_Previous_ButtonWidget_enAbortPress
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_BT")) && (message.GetSender() == ::Courier::Identifier(0x0e79dedf /* Layer_TouchArea_Previous/ButtonWidget */)) && (message.GetEnReaction() == enAbortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_BT_Layer_TouchArea_Previous_ButtonWidget_enAbortPress, 0x24E43348); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_OPT_woRDS_ButtonWidget2D_SoundSettings_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_OPT_woRDS")) && (message.GetSender() == ::Courier::Identifier(0x1955f21a /* ButtonWidget2D_SoundSettings */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_OPT_woRDS_ButtonWidget2D_SoundSettings_enRelease, 0x8271C101); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_USB_Layer_AppFlyIn_ButtonWidget2D_Radio_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_USB")) && (message.GetSender() == ::Courier::Identifier(0xd6fbef00 /* Layer_AppFlyIn/ButtonWidget2D_Radio */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_USB_Layer_AppFlyIn_ButtonWidget2D_Radio_enRelease, 0x4DEF4D2C); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_TouchArea_PlayPause_touched_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_AppleDevice")) && (message.GetSender() == ::Courier::Identifier(0xcd0f9441 /* Layer_TouchArea_PlayPause_touched/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_TouchArea_PlayPause_touched_ButtonWidget2D_enRelease, 0x287C46C3); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_IPOD_BT_ButtonWidget2D_Next_enLongPress
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_IPOD_BT")) && (message.GetSender() == ::Courier::Identifier(0x8e06969d /* ButtonWidget2D_Next */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_IPOD_BT_ButtonWidget2D_Next_enLongPress, 0x5A7BE1FD); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_IPOD_BT_ButtonWidget2D_Next_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_IPOD_BT")) && (message.GetSender() == ::Courier::Identifier(0x8e06969d /* ButtonWidget2D_Next */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_IPOD_BT_ButtonWidget2D_Next_enLongPressRelease, 0xFF1F340C); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_IPOD_BT_SliderWidget2D_Seek_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_IPOD_BT")) && (message.GetSender() == ::Courier::Identifier(0xc2466e08 /* SliderWidget2D_Seek */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_IPOD_BT_SliderWidget2D_Seek_enRelease, 0xC19ED54A); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_IPOD_BT_Layer_AppFlyIn_ButtonWidget2D_Phone_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_IPOD_BT")) && (message.GetSender() == ::Courier::Identifier(0x6f985d7e /* Layer_AppFlyIn/ButtonWidget2D_Phone */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_IPOD_BT_Layer_AppFlyIn_ButtonWidget2D_Phone_enRelease, 0x9EF6B437); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_IPOD_BT_Layer_AppFlyIn_ButtonWidget2D_Navi_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_IPOD_BT")) && (message.GetSender() == ::Courier::Identifier(0xe599f8f8 /* Layer_AppFlyIn/ButtonWidget2D_Navi */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_IPOD_BT_Layer_AppFlyIn_ButtonWidget2D_Navi_enRelease, 0xB6F9EF98); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_IPOD_BT_Layer_AppFlyIn_ButtonWidget2D_MirrorLink_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_IPOD_BT")) && (message.GetSender() == ::Courier::Identifier(0xc12f6d49 /* Layer_AppFlyIn/ButtonWidget2D_MirrorLink */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_IPOD_BT_Layer_AppFlyIn_ButtonWidget2D_MirrorLink_enRelease, 0x84E38AFC); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_IPOD_BT_ButtonWidget2D_List_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_IPOD_BT")) && (message.GetSender() == ::Courier::Identifier(0xfbeb3c5e /* ButtonWidget2D_List */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_IPOD_BT_ButtonWidget2D_List_enRelease, 0xBC156E11); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_SD_ButtonWidget2D_Source_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_SD")) && (message.GetSender() == ::Courier::Identifier(0x125e6914 /* ButtonWidget2D_Source */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_SD_ButtonWidget2D_Source_enRelease, 0x71C47D00); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_SD_ButtonWidget2D_Play_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_SD")) && (message.GetSender() == ::Courier::Identifier(0xbd381356 /* ButtonWidget2D_Play */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_SD_ButtonWidget2D_Play_enRelease, 0xD60C65DC); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_SD_ButtonWidget2D_Repeat_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_SD")) && (message.GetSender() == ::Courier::Identifier(0x126ecbe9 /* ButtonWidget2D_Repeat */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_SD_ButtonWidget2D_Repeat_enRelease, 0x43B133F0); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_SD_ButtonWidget2D_Shuffle_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_SD")) && (message.GetSender() == ::Courier::Identifier(0xf2f17e72 /* ButtonWidget2D_Shuffle */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_SD_ButtonWidget2D_Shuffle_enRelease, 0x71FA6B0E); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_SD_ButtonWidget2D_Prev_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_SD")) && (message.GetSender() == ::Courier::Identifier(0x631d56bf /* ButtonWidget2D_Prev */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_SD_ButtonWidget2D_Prev_enRelease, 0xE7228EE2); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_SD_ButtonWidget2D_Next_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_SD")) && (message.GetSender() == ::Courier::Identifier(0x8e06969d /* ButtonWidget2D_Next */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_SD_ButtonWidget2D_Next_enRelease, 0xA3944155); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_SD_ButtonWidget2D_Prev_enLongPress
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_SD")) && (message.GetSender() == ::Courier::Identifier(0x631d56bf /* ButtonWidget2D_Prev */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_SD_ButtonWidget2D_Prev_enLongPress, 0x44667399); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_SD_ButtonWidget2D_Prev_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_SD")) && (message.GetSender() == ::Courier::Identifier(0x631d56bf /* ButtonWidget2D_Prev */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_SD_ButtonWidget2D_Prev_enLongPressRelease, 0x0F724534); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_SD_ButtonWidget2D_Next_enLongPress
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_SD")) && (message.GetSender() == ::Courier::Identifier(0x8e06969d /* ButtonWidget2D_Next */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_SD_ButtonWidget2D_Next_enLongPress, 0xD60E4F86); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_SD_ButtonWidget2D_Next_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_SD")) && (message.GetSender() == ::Courier::Identifier(0x8e06969d /* ButtonWidget2D_Next */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_SD_ButtonWidget2D_Next_enLongPressRelease, 0x5BCD7C57); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_SD_SliderWidget2D_Seek_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_SD")) && (message.GetSender() == ::Courier::Identifier(0xc2466e08 /* SliderWidget2D_Seek */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_SD_SliderWidget2D_Seek_enRelease, 0x9AFEF18F); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_SD_Layer_AppFlyIn_ButtonWidget2D_Phone_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_SD")) && (message.GetSender() == ::Courier::Identifier(0x6f985d7e /* Layer_AppFlyIn/ButtonWidget2D_Phone */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_SD_Layer_AppFlyIn_ButtonWidget2D_Phone_enRelease, 0xAC177B9E); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_SD_Layer_AppFlyIn_ButtonWidget2D_Radio_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_SD")) && (message.GetSender() == ::Courier::Identifier(0xd6fbef00 /* Layer_AppFlyIn/ButtonWidget2D_Radio */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_SD_Layer_AppFlyIn_ButtonWidget2D_Radio_enRelease, 0x9B95DF4F); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_SD_Layer_AppFlyIn_ButtonWidget2D_Navi_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_SD")) && (message.GetSender() == ::Courier::Identifier(0xe599f8f8 /* Layer_AppFlyIn/ButtonWidget2D_Navi */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_SD_Layer_AppFlyIn_ButtonWidget2D_Navi_enRelease, 0x386A16F4); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_SD_Layer_AppFlyIn_ButtonWidget2D_MirrorLink_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_SD")) && (message.GetSender() == ::Courier::Identifier(0xc12f6d49 /* Layer_AppFlyIn/ButtonWidget2D_MirrorLink */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_SD_Layer_AppFlyIn_ButtonWidget2D_MirrorLink_enRelease, 0x0793DF4E); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_SD_ButtonWidget2D_List_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_SD")) && (message.GetSender() == ::Courier::Identifier(0xfbeb3c5e /* ButtonWidget2D_List */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_SD_ButtonWidget2D_List_enRelease, 0x30B2AA70); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_OPT_Layer_SoundSettings_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_OPT")) && (message.GetSender() == ::Courier::Identifier(0x4eeb6b3f /* Layer_SoundSettings/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_OPT_Layer_SoundSettings_ButtonWidget_enRelease, 0x235CFC9D); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_OPT_Layer_TrafficAnnouncement_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_OPT")) && (message.GetSender() == ::Courier::Identifier(0xed17faa8 /* Layer_TrafficAnnouncement/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_OPT_Layer_TrafficAnnouncement_ButtonWidget2D_enRelease, 0x344AEBC2); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_OPT_Layer_TouchArea_Source_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_OPT")) && (message.GetSender() == ::Courier::Identifier(0xccdf81cf /* Layer_TouchArea_Source/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_OPT_Layer_TouchArea_Source_ButtonWidget_enRelease, 0xA8722469); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_OPT_woRDS_tgBtn_Checkbox_ActivateexternalDVD_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_OPT_woRDS")) && (message.GetSender() == ::Courier::Identifier(0x79507351 /* tgBtn_Checkbox_ActivateexternalDVD */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_OPT_woRDS_tgBtn_Checkbox_ActivateexternalDVD_enRelease, 0x4399B8F7); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_IPOD_BT_ButtonWidget2D_Prev_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_IPOD_BT")) && (message.GetSender() == ::Courier::Identifier(0x631d56bf /* ButtonWidget2D_Prev */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_IPOD_BT_ButtonWidget2D_Prev_enLongPressRelease, 0x520A915D); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_TouchArea_Source_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_AppleDevice")) && (message.GetSender() == ::Courier::Identifier(0xccdf81cf /* Layer_TouchArea_Source/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_TouchArea_Source_ButtonWidget_enRelease, 0x46B47DB5); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_IPOD_BT_ButtonWidget2D_Prev_enLongPress
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_IPOD_BT")) && (message.GetSender() == ::Courier::Identifier(0x631d56bf /* ButtonWidget2D_Prev */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_IPOD_BT_ButtonWidget2D_Prev_enLongPress, 0x5D330B82); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_IPOD_BT_ButtonWidget2D_Prev_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_IPOD_BT")) && (message.GetSender() == ::Courier::Identifier(0x631d56bf /* ButtonWidget2D_Prev */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_IPOD_BT_ButtonWidget2D_Prev_enRelease, 0x69505C6C); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_TouchArea_PlayPause_touched_ButtonWidget2D_enPress
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_AppleDevice")) && (message.GetSender() == ::Courier::Identifier(0xcd0f9441 /* Layer_TouchArea_PlayPause_touched/ButtonWidget2D */)) && (message.GetEnReaction() == enPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_TouchArea_PlayPause_touched_ButtonWidget2D_enPress, 0x74F449E5); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_TouchArea_PlayPause_touched_ButtonWidget2D_enAbortPress
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_AppleDevice")) && (message.GetSender() == ::Courier::Identifier(0xcd0f9441 /* Layer_TouchArea_PlayPause_touched/ButtonWidget2D */)) && (message.GetEnReaction() == enAbortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_TouchArea_PlayPause_touched_ButtonWidget2D_enAbortPress, 0x47192B67); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_TouchArea_Repeat_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_AppleDevice")) && (message.GetSender() == ::Courier::Identifier(0xcbe54532 /* Layer_TouchArea_Repeat/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_TouchArea_Repeat_ButtonWidget2D_enRelease, 0x0F8FE659); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_TouchArea_Repeat_ButtonWidget2D_enPress
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_AppleDevice")) && (message.GetSender() == ::Courier::Identifier(0xcbe54532 /* Layer_TouchArea_Repeat/ButtonWidget2D */)) && (message.GetEnReaction() == enPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_TouchArea_Repeat_ButtonWidget2D_enPress, 0xEB5BC2C4); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_TouchArea_Repeat_ButtonWidget2D_enAbortPress
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_AppleDevice")) && (message.GetSender() == ::Courier::Identifier(0xcbe54532 /* Layer_TouchArea_Repeat/ButtonWidget2D */)) && (message.GetEnReaction() == enAbortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_TouchArea_Repeat_ButtonWidget2D_enAbortPress, 0x43F34D61); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_TouchArea_Shuffle_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_AppleDevice")) && (message.GetSender() == ::Courier::Identifier(0xf79ff856 /* Layer_TouchArea_Shuffle/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_TouchArea_Shuffle_ButtonWidget2D_enRelease, 0x89C05740); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_TouchArea_Shuffle_ButtonWidget2D_enPress
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_AppleDevice")) && (message.GetSender() == ::Courier::Identifier(0xf79ff856 /* Layer_TouchArea_Shuffle/ButtonWidget2D */)) && (message.GetEnReaction() == enPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_TouchArea_Shuffle_ButtonWidget2D_enPress, 0x86C8DC2C); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_TouchArea_Shuffle_ButtonWidget2D_enAbortPress
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_AppleDevice")) && (message.GetSender() == ::Courier::Identifier(0xf79ff856 /* Layer_TouchArea_Shuffle/ButtonWidget2D */)) && (message.GetEnReaction() == enAbortPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_TouchArea_Shuffle_ButtonWidget2D_enAbortPress, 0x7361D54B); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_TouchArea_Previous_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_AppleDevice")) && (message.GetSender() == ::Courier::Identifier(0x0e79dedf /* Layer_TouchArea_Previous/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_TouchArea_Previous_ButtonWidget_enRelease, 0xB79A88C1); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_TouchArea_Previous_ButtonWidget_enPress
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_AppleDevice")) && (message.GetSender() == ::Courier::Identifier(0x0e79dedf /* Layer_TouchArea_Previous/ButtonWidget */)) && (message.GetEnReaction() == enPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_TouchArea_Previous_ButtonWidget_enPress, 0x5B6E8694); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_TouchArea_Next_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_AppleDevice")) && (message.GetSender() == ::Courier::Identifier(0x4e7f0732 /* Layer_TouchArea_Next/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_TouchArea_Next_ButtonWidget_enRelease, 0x07231E85); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_TouchArea_Next_ButtonWidget_enPress
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_AppleDevice")) && (message.GetSender() == ::Courier::Identifier(0x4e7f0732 /* Layer_TouchArea_Next/ButtonWidget */)) && (message.GetEnReaction() == enPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_TouchArea_Next_ButtonWidget_enPress, 0xA7188CBC); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_TouchArea_Previous_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_AppleDevice")) && (message.GetSender() == ::Courier::Identifier(0x0e79dedf /* Layer_TouchArea_Previous/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_TouchArea_Previous_ButtonWidget_enLongPress, 0x1BB5D3CC); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_TouchArea_Previous_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_AppleDevice")) && (message.GetSender() == ::Courier::Identifier(0x0e79dedf /* Layer_TouchArea_Previous/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_TouchArea_Previous_ButtonWidget_enLongPressRelease, 0x870DE0D0); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_TouchArea_Next_ButtonWidget_enLongPress
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_AppleDevice")) && (message.GetSender() == ::Courier::Identifier(0x4e7f0732 /* Layer_TouchArea_Next/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_TouchArea_Next_ButtonWidget_enLongPress, 0x200B7DF7); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_TouchArea_Next_ButtonWidget_enLongPressRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_AppleDevice")) && (message.GetSender() == ::Courier::Identifier(0x4e7f0732 /* Layer_TouchArea_Next/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_TouchArea_Next_ButtonWidget_enLongPressRelease, 0xFE306FE8); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_Progressbar_SliderWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_AppleDevice")) && (message.GetSender() == ::Courier::Identifier(0x16421d92 /* Layer_Progressbar/SliderWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_Progressbar_SliderWidget2D_enRelease, 0x3E31CB3F); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_AppFlyIn_ButtonWidget2D_Phone_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_AppleDevice")) && (message.GetSender() == ::Courier::Identifier(0x6f985d7e /* Layer_AppFlyIn/ButtonWidget2D_Phone */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_AppFlyIn_ButtonWidget2D_Phone_enRelease, 0x7874AABE); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_AppFlyIn_ButtonWidget2D_Radio_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_AppleDevice")) && (message.GetSender() == ::Courier::Identifier(0xd6fbef00 /* Layer_AppFlyIn/ButtonWidget2D_Radio */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_AppFlyIn_ButtonWidget2D_Radio_enRelease, 0x20F1A9CC); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_AppFlyIn_ButtonWidget2D_Navi_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_AppleDevice")) && (message.GetSender() == ::Courier::Identifier(0xe599f8f8 /* Layer_AppFlyIn/ButtonWidget2D_Navi */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_AppFlyIn_ButtonWidget2D_Navi_enRelease, 0x91A883CA); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_AppFlyIn_ButtonWidget2D_MirrorLink_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_AppleDevice")) && (message.GetSender() == ::Courier::Identifier(0xc12f6d49 /* Layer_AppFlyIn/ButtonWidget2D_MirrorLink */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_AppFlyIn_ButtonWidget2D_MirrorLink_enRelease, 0x461AFE8A); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_TouchArea_SourceInfoM_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_AppleDevice")) && (message.GetSender() == ::Courier::Identifier(0xe1c7ab76 /* TouchArea_SourceInfoM/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_TouchArea_SourceInfoM_ButtonWidget_enRelease, 0x51C11632); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_IPOD_BT_ButtonWidget2D_Source_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_IPOD_BT")) && (message.GetSender() == ::Courier::Identifier(0x125e6914 /* ButtonWidget2D_Source */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_IPOD_BT_ButtonWidget2D_Source_enRelease, 0x30D0F271); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_IPOD_BT_Layer_AppFlyIn_ButtonWidget2D_Radio_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_IPOD_BT")) && (message.GetSender() == ::Courier::Identifier(0xd6fbef00 /* Layer_AppFlyIn/ButtonWidget2D_Radio */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_IPOD_BT_Layer_AppFlyIn_ButtonWidget2D_Radio_enRelease, 0xC7366C6B); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_IPOD_BT_ButtonWidget2D_Play_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_IPOD_BT")) && (message.GetSender() == ::Courier::Identifier(0xbd381356 /* ButtonWidget2D_Play */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_IPOD_BT_ButtonWidget2D_Play_enRelease, 0xFB82263D); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_IPOD_BT_ButtonWidget2D_Repeat_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_IPOD_BT")) && (message.GetSender() == ::Courier::Identifier(0x126ecbe9 /* ButtonWidget2D_Repeat */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_IPOD_BT_ButtonWidget2D_Repeat_enRelease, 0x85833641); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_IPOD_BT_ButtonWidget2D_Shuffle_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_IPOD_BT")) && (message.GetSender() == ::Courier::Identifier(0xf2f17e72 /* ButtonWidget2D_Shuffle */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_IPOD_BT_ButtonWidget2D_Shuffle_enRelease, 0xD9419E1D); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_IPOD_BT_ButtonWidget2D_Next_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_IPOD_BT")) && (message.GetSender() == ::Courier::Identifier(0x8e06969d /* ButtonWidget2D_Next */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_IPOD_BT_ButtonWidget2D_Next_enRelease, 0xC0979B0B); return true; }
#endif
#ifdef OnButtonReactionMsg_Media_MediaPlayerScenes_M_Album_External_Button_All_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Media#MediaPlayerScenes#M_Album_External")) && (message.GetSender() == ::Courier::Identifier(0xb44e5603 /* Button_All/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Media_MediaPlayerScenes_M_Album_External_Button_All_ButtonWidget_enRelease, 0x3C71E22E); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForButtonReactionMsg(AppHmi_MediaStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::ButtonReactionMsg const & message = static_cast< ::ButtonReactionMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForActivationResMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::Courier::ActivationResMsg const & message = static_cast< ::Courier::ActivationResMsg const &>(aMessage);

#ifdef OnActivationResMsg_Media_MediaPlayer_Pop_Up_Pfo_FastForwardRewindStart_1
    if ((message.GetViewId() == ::Courier::ViewId("Media#MediaPlayer_Pop_Up#Pfo_FastForwardRewindStart")) && (message.GetSuccess() == 1)) { eventId = CIT_EVENT_ID(OnActivationResMsg_Media_MediaPlayer_Pop_Up_Pfo_FastForwardRewindStart_1, 0x26D83B21); return true; }
#endif
#ifdef OnActivationResMsg_Media_MediaPlayer_Pop_Up_system_Pfo_MediaMessage_1
    if ((message.GetViewId() == ::Courier::ViewId("Media#MediaPlayer_Pop_Up_system#Pfo_MediaMessage")) && (message.GetSuccess() == 1)) { eventId = CIT_EVENT_ID(OnActivationResMsg_Media_MediaPlayer_Pop_Up_system_Pfo_MediaMessage_1, 0x567FD67A); return true; }
#endif
#ifdef OnActivationResMsg_Media_MediaPlayer_Pop_Up_Pfo_MediaConfirmBTPairing_1
    if ((message.GetViewId() == ::Courier::ViewId("Media#MediaPlayer_Pop_Up#Pfo_MediaConfirmBTPairing")) && (message.GetSuccess() == 1)) { eventId = CIT_EVENT_ID(OnActivationResMsg_Media_MediaPlayer_Pop_Up_Pfo_MediaConfirmBTPairing_1, 0x755CE30A); return true; }
#endif
#ifdef OnActivationResMsg_Media_MediaPlayer_Pop_Up_Pfo_VideoDisableMessage_1
    if ((message.GetViewId() == ::Courier::ViewId("Media#MediaPlayer_Pop_Up#Pfo_VideoDisableMessage")) && (message.GetSuccess() == 1)) { eventId = CIT_EVENT_ID(OnActivationResMsg_Media_MediaPlayer_Pop_Up_Pfo_VideoDisableMessage_1, 0xA8BA919D); return true; }
#endif
#ifdef OnActivationResMsg_Media_MediaPlayer_Pop_Up_Pfo_WMA_DRM_ProtectedFileMessage_1
    if ((message.GetViewId() == ::Courier::ViewId("Media#MediaPlayer_Pop_Up#Pfo_WMA_DRM_ProtectedFileMessage")) && (message.GetSuccess() == 1)) { eventId = CIT_EVENT_ID(OnActivationResMsg_Media_MediaPlayer_Pop_Up_Pfo_WMA_DRM_ProtectedFileMessage_1, 0xDA5E5899); return true; }
#endif
#ifdef OnActivationResMsg_Media_MediaPlayer_Pop_Up_Pfo_MediaGlassUnavailableMessage_1
    if ((message.GetViewId() == ::Courier::ViewId("Media#MediaPlayer_Pop_Up#Pfo_MediaGlassUnavailableMessage")) && (message.GetSuccess() == 1)) { eventId = CIT_EVENT_ID(OnActivationResMsg_Media_MediaPlayer_Pop_Up_Pfo_MediaGlassUnavailableMessage_1, 0x21CD104E); return true; }
#endif
#ifdef OnActivationResMsg_Media_MediaPlayer_Pop_Up_Pfo_NoPlayableContentPopup_1
    if ((message.GetViewId() == ::Courier::ViewId("Media#MediaPlayer_Pop_Up#Pfo_NoPlayableContentPopup")) && (message.GetSuccess() == 1)) { eventId = CIT_EVENT_ID(OnActivationResMsg_Media_MediaPlayer_Pop_Up_Pfo_NoPlayableContentPopup_1, 0x2AC139E6); return true; }
#endif
#ifdef OnActivationResMsg_Media_MediaPlayer_Pop_Up_Pfo_SignalRangeError_1
    if ((message.GetViewId() == ::Courier::ViewId("Media#MediaPlayer_Pop_Up#Pfo_SignalRangeError")) && (message.GetSuccess() == 1)) { eventId = CIT_EVENT_ID(OnActivationResMsg_Media_MediaPlayer_Pop_Up_Pfo_SignalRangeError_1, 0x0FC10626); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActivationResMsg(AppHmi_MediaStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::Courier::ActivationResMsg const & message = static_cast< ::Courier::ActivationResMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForUpdateActiveDevicestatusMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnUpdateActiveDevicestatusMsg, 0x4F310548);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForUpdateActiveDevicestatusMsg(AppHmi_MediaStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForExtDVDConnectionModeStatusMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnExtDVDConnectionModeStatusMsg, 0x89CD0B33);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForExtDVDConnectionModeStatusMsg(AppHmi_MediaStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForVehicleSensorSpeedModestatusMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnVehicleSensorSpeedModestatusMsg, 0xAC06B472);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForVehicleSensorSpeedModestatusMsg(AppHmi_MediaStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForVehicleSensorparkingbreakStatusMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnVehicleSensorparkingbreakStatusMsg, 0x7CCA91E9);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForVehicleSensorparkingbreakStatusMsg(AppHmi_MediaStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForVehicleSensorExtDVDSpeedModestatusMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnVehicleSensorExtDVDSpeedModestatusMsg, 0xD785E8EC);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForVehicleSensorExtDVDSpeedModestatusMsg(AppHmi_MediaStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForVehicleSensorExtDVDparkingbreakStatusMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnVehicleSensorExtDVDparkingbreakStatusMsg, 0xBE68F9CC);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForVehicleSensorExtDVDparkingbreakStatusMsg(AppHmi_MediaStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForSourceSelectionStateResp(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::SourceSelectionStateResp const & message = static_cast< ::SourceSelectionStateResp const &>(aMessage);

#ifdef OnSourceSelectionStateResp_FI_EN_E8DTY_SrcSel
    if ((message.GetSourceSelection() == FI_EN_E8DTY_SrcSel)) { eventId = CIT_EVENT_ID(OnSourceSelectionStateResp_FI_EN_E8DTY_SrcSel, 0x28A45F85); return true; }
#endif
#ifdef OnSourceSelectionStateResp_FI_EN_E8DTY_SrcSel_WONAV
    if ((message.GetSourceSelection() == FI_EN_E8DTY_SrcSel_WONAV)) { eventId = CIT_EVENT_ID(OnSourceSelectionStateResp_FI_EN_E8DTY_SrcSel_WONAV, 0xB7ADAC96); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSourceSelectionStateResp(AppHmi_MediaStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::SourceSelectionStateResp const & message = static_cast< ::SourceSelectionStateResp const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForActivateSourceSwitchToDVD(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnActivateSourceSwitchToDVD, 0x612D64CD);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActivateSourceSwitchToDVD(AppHmi_MediaStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForActivateSourceSwitchToUSB(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnActivateSourceSwitchToUSB, 0x5BB819F6);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActivateSourceSwitchToUSB(AppHmi_MediaStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForActivateSourceSwitchToBT(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnActivateSourceSwitchToBT, 0x3F08B10F);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActivateSourceSwitchToBT(AppHmi_MediaStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForActivateSourceSwitchToAUX(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnActivateSourceSwitchToAUX, 0x66AEEED9);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActivateSourceSwitchToAUX(AppHmi_MediaStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForActivateSwitchToSourceSel(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnActivateSwitchToSourceSel, 0xBC56A0D9);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActivateSwitchToSourceSel(AppHmi_MediaStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForActivityMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::ActivityMsg const & message = static_cast< ::ActivityMsg const &>(aMessage);

#ifdef OnActivityMsg_eActivityID_MEDIA_PLAY
    if ((message.GetActivityID() == eActivityID_MEDIA_PLAY)) { eventId = CIT_EVENT_ID(OnActivityMsg_eActivityID_MEDIA_PLAY, 0x4CFD3B05); return true; }
#endif
#ifdef OnActivityMsg_eActivityID_MEDIA_USB
    if ((message.GetActivityID() == eActivityID_MEDIA_USB)) { eventId = CIT_EVENT_ID(OnActivityMsg_eActivityID_MEDIA_USB, 0x621FE4C1); return true; }
#endif
#ifdef OnActivityMsg_eActivityID_MEDIA_SDCARD
    if ((message.GetActivityID() == eActivityID_MEDIA_SDCARD)) { eventId = CIT_EVENT_ID(OnActivityMsg_eActivityID_MEDIA_SDCARD, 0x0269A291); return true; }
#endif
#ifdef OnActivityMsg_eActivityID_MEDIA_IPOD
    if ((message.GetActivityID() == eActivityID_MEDIA_IPOD)) { eventId = CIT_EVENT_ID(OnActivityMsg_eActivityID_MEDIA_IPOD, 0x9768B1CB); return true; }
#endif
#ifdef OnActivityMsg_eActivityID_MEDIA_AUX
    if ((message.GetActivityID() == eActivityID_MEDIA_AUX)) { eventId = CIT_EVENT_ID(OnActivityMsg_eActivityID_MEDIA_AUX, 0x3C32C57E); return true; }
#endif
#ifdef OnActivityMsg_eActivityID_MEDIA_DVD
    if ((message.GetActivityID() == eActivityID_MEDIA_DVD)) { eventId = CIT_EVENT_ID(OnActivityMsg_eActivityID_MEDIA_DVD, 0x6B874597); return true; }
#endif
#ifdef OnActivityMsg_eActivityID_MEDIA_BTSTREAMING
    if ((message.GetActivityID() == eActivityID_MEDIA_BTSTREAMING)) { eventId = CIT_EVENT_ID(OnActivityMsg_eActivityID_MEDIA_BTSTREAMING, 0xC801484C); return true; }
#endif
#ifdef OnActivityMsg_eActivityID_MEDIA_SOURCE_SELECTION
    if ((message.GetActivityID() == eActivityID_MEDIA_SOURCE_SELECTION)) { eventId = CIT_EVENT_ID(OnActivityMsg_eActivityID_MEDIA_SOURCE_SELECTION, 0x8C271FF9); return true; }
#endif
#ifdef OnActivityMsg_eActivityID_MEDIA_SETTINGS_VIEW
    if ((message.GetActivityID() == eActivityID_MEDIA_SETTINGS_VIEW)) { eventId = CIT_EVENT_ID(OnActivityMsg_eActivityID_MEDIA_SETTINGS_VIEW, 0xF1A4C0E5); return true; }
#endif
#ifdef OnActivityMsg_eActivityID_NO_CHANGE
    if ((message.GetActivityID() == eActivityID_NO_CHANGE)) { eventId = CIT_EVENT_ID(OnActivityMsg_eActivityID_NO_CHANGE, 0x1118D220); return true; }
#endif
#ifdef OnActivityMsg_eActivityID_MEDIA_SOURCE_SWITCH
    if ((message.GetActivityID() == eActivityID_MEDIA_SOURCE_SWITCH)) { eventId = CIT_EVENT_ID(OnActivityMsg_eActivityID_MEDIA_SOURCE_SWITCH, 0xDE90752B); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActivityMsg(AppHmi_MediaStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::ActivityMsg const & message = static_cast< ::ActivityMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onTopPopupSurfaceInvisible
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onTopPopupSurfaceInvisible 0xffff
#pragma _REMINDER("Using dummy value symbol onTopPopupSurfaceInvisible ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onTopPopupSurfaceInvisible -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onTopPopupSurfaceVisible
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onTopPopupSurfaceVisible 0xffff
#pragma _REMINDER("Using dummy value symbol onTopPopupSurfaceVisible ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onTopPopupSurfaceVisible -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onTopPopupSurfaceUnqueued
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onTopPopupSurfaceUnqueued 0xffff
#pragma _REMINDER("Using dummy value symbol onTopPopupSurfaceUnqueued ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onTopPopupSurfaceUnqueued -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onTopPopupSurfaceQueued
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onTopPopupSurfaceQueued 0xffff
#pragma _REMINDER("Using dummy value symbol onTopPopupSurfaceQueued ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onTopPopupSurfaceQueued -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onCenterPopupSurfaceInvisible
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onCenterPopupSurfaceInvisible 0xffff
#pragma _REMINDER("Using dummy value symbol onCenterPopupSurfaceInvisible ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onCenterPopupSurfaceInvisible -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onCenterPopupSurfaceVisible
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onCenterPopupSurfaceVisible 0xffff
#pragma _REMINDER("Using dummy value symbol onCenterPopupSurfaceVisible ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onCenterPopupSurfaceVisible -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onCenterPopupSurfaceUnqueued
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onCenterPopupSurfaceUnqueued 0xffff
#pragma _REMINDER("Using dummy value symbol onCenterPopupSurfaceUnqueued ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onCenterPopupSurfaceUnqueued -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onCenterPopupSurfaceQueued
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onCenterPopupSurfaceQueued 0xffff
#pragma _REMINDER("Using dummy value symbol onCenterPopupSurfaceQueued ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onCenterPopupSurfaceQueued -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onPopupVisible
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onPopupVisible 0xffff
#pragma _REMINDER("Using dummy value symbol onPopupVisible ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onPopupVisible -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onPopupUnqueued
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onPopupUnqueued 0xffff
#pragma _REMINDER("Using dummy value symbol onPopupUnqueued ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onPopupUnqueued -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onPopupQueued
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onPopupQueued 0xffff
#pragma _REMINDER("Using dummy value symbol onPopupQueued ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onPopupQueued -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForSurfaceStateChangedUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);

#ifdef onTopPopupSurfaceInvisible
    if ((message.GetSurfaceId() == SURFACEID_TOP_POPUP_SURFACE_MEDIA) && (message.GetState() == SURFACESTATE_INVISIBLE)) { eventId = CIT_EVENT_ID(onTopPopupSurfaceInvisible, 0x3598CF84); return true; }
#endif
#ifdef onTopPopupSurfaceVisible
    if ((message.GetSurfaceId() == SURFACEID_TOP_POPUP_SURFACE_MEDIA) && (message.GetState() == SURFACESTATE_VISIBLE)) { eventId = CIT_EVENT_ID(onTopPopupSurfaceVisible, 0x984F8ED8); return true; }
#endif
#ifdef onTopPopupSurfaceUnqueued
    if ((message.GetSurfaceId() == SURFACEID_TOP_POPUP_SURFACE_MEDIA) && (message.GetState() == SURFACESTATE_UNQUEUED)) { eventId = CIT_EVENT_ID(onTopPopupSurfaceUnqueued, 0x912024BE); return true; }
#endif
#ifdef onTopPopupSurfaceQueued
    if ((message.GetSurfaceId() == SURFACEID_TOP_POPUP_SURFACE_MEDIA) && (message.GetState() == SURFACESTATE_QUEUED)) { eventId = CIT_EVENT_ID(onTopPopupSurfaceQueued, 0xB630DDBD); return true; }
#endif
#ifdef onCenterPopupSurfaceInvisible
    if ((message.GetSurfaceId() == SURFACEID_CENTER_POPUP_SURFACE_MEDIA) && (message.GetState() == SURFACESTATE_INVISIBLE)) { eventId = CIT_EVENT_ID(onCenterPopupSurfaceInvisible, 0x9BDB722F); return true; }
#endif
#ifdef onCenterPopupSurfaceVisible
    if ((message.GetSurfaceId() == SURFACEID_CENTER_POPUP_SURFACE_MEDIA) && (message.GetState() == SURFACESTATE_VISIBLE)) { eventId = CIT_EVENT_ID(onCenterPopupSurfaceVisible, 0x23B97E51); return true; }
#endif
#ifdef onCenterPopupSurfaceUnqueued
    if ((message.GetSurfaceId() == SURFACEID_CENTER_POPUP_SURFACE_MEDIA) && (message.GetState() == SURFACESTATE_UNQUEUED)) { eventId = CIT_EVENT_ID(onCenterPopupSurfaceUnqueued, 0xAA79C7DD); return true; }
#endif
#ifdef onCenterPopupSurfaceQueued
    if ((message.GetSurfaceId() == SURFACEID_CENTER_POPUP_SURFACE_MEDIA) && (message.GetState() == SURFACESTATE_QUEUED)) { eventId = CIT_EVENT_ID(onCenterPopupSurfaceQueued, 0xFC0D2293); return true; }
#endif
#ifdef onPopupVisible
    if ((message.GetState() == SURFACESTATE_VISIBLE)) { eventId = CIT_EVENT_ID(onPopupVisible, 0xB78D7AE0); return true; }
#endif
#ifdef onPopupUnqueued
    if ((message.GetState() == SURFACESTATE_UNQUEUED)) { eventId = CIT_EVENT_ID(onPopupUnqueued, 0xDB0D29F4); return true; }
#endif
#ifdef onPopupQueued
    if ((message.GetState() == SURFACESTATE_QUEUED)) { eventId = CIT_EVENT_ID(onPopupQueued, 0xBBE6896C); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSurfaceStateChangedUpdMsg(AppHmi_MediaStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
#ifdef onTopPopupSurfaceInvisible
    if (eventId == onTopPopupSurfaceInvisible) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onTopPopupSurfaceInvisible.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onTopPopupSurfaceVisible
    if (eventId == onTopPopupSurfaceVisible) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onTopPopupSurfaceVisible.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onTopPopupSurfaceUnqueued
    if (eventId == onTopPopupSurfaceUnqueued) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onTopPopupSurfaceUnqueued.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onTopPopupSurfaceQueued
    if (eventId == onTopPopupSurfaceQueued) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onTopPopupSurfaceQueued.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onCenterPopupSurfaceInvisible
    if (eventId == onCenterPopupSurfaceInvisible) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onCenterPopupSurfaceInvisible.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onCenterPopupSurfaceVisible
    if (eventId == onCenterPopupSurfaceVisible) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onCenterPopupSurfaceVisible.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onCenterPopupSurfaceUnqueued
    if (eventId == onCenterPopupSurfaceUnqueued) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onCenterPopupSurfaceUnqueued.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onCenterPopupSurfaceQueued
    if (eventId == onCenterPopupSurfaceQueued) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onCenterPopupSurfaceQueued.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onPopupVisible
    if (eventId == onPopupVisible) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onPopupVisible.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onPopupUnqueued
    if (eventId == onPopupUnqueued) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onPopupUnqueued.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onPopupQueued
    if (eventId == onPopupQueued) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onPopupQueued.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForEnableView(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::EnableView const & message = static_cast< ::EnableView const &>(aMessage);

#ifdef OnEnableView_Media_MediaPlayerScenes_M_OPT
    if ((message.GetViewName() == ::Courier::ViewId("Media#MediaPlayerScenes#M_OPT"))) { eventId = CIT_EVENT_ID(OnEnableView_Media_MediaPlayerScenes_M_OPT, 0x17712003); return true; }
#endif
#ifdef OnEnableView_Media_MediaPlayerScenes_M_OPT_woRDS
    if ((message.GetViewName() == ::Courier::ViewId("Media#MediaPlayerScenes#M_OPT_woRDS"))) { eventId = CIT_EVENT_ID(OnEnableView_Media_MediaPlayerScenes_M_OPT_woRDS, 0x315CE6A4); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForEnableView(AppHmi_MediaStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::EnableView const & message = static_cast< ::EnableView const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForDisableView(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::DisableView const & message = static_cast< ::DisableView const &>(aMessage);

#ifdef OnDisableView_Media_MediaPlayerScenes_M_OPT
    if ((message.GetViewName() == ::Courier::ViewId("Media#MediaPlayerScenes#M_OPT"))) { eventId = CIT_EVENT_ID(OnDisableView_Media_MediaPlayerScenes_M_OPT, 0xC4D07F17); return true; }
#endif
#ifdef OnDisableView_Media_MediaPlayerScenes_M_OPT_woRDS
    if ((message.GetViewName() == ::Courier::ViewId("Media#MediaPlayerScenes#M_OPT_woRDS"))) { eventId = CIT_EVENT_ID(OnDisableView_Media_MediaPlayerScenes_M_OPT_woRDS, 0x91888118); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForDisableView(AppHmi_MediaStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::DisableView const & message = static_cast< ::DisableView const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForEnableandShowPopUp(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::EnableandShowPopUp const & message = static_cast< ::EnableandShowPopUp const &>(aMessage);

#ifdef OnEnableandShowPopUp_SM_MEDIA_PID_APP_POPUPMEDIAMESSAGE
    if ((message.GetPopUpId() == SM_MEDIA_PID_APP_POPUPMEDIAMESSAGE)) { eventId = CIT_EVENT_ID(OnEnableandShowPopUp_SM_MEDIA_PID_APP_POPUPMEDIAMESSAGE, 0x7488CD73); return true; }
#endif
#ifdef OnEnableandShowPopUp_SM_MEDIA_PID_APP_POPUPBTPHONEPAIRING
    if ((message.GetPopUpId() == SM_MEDIA_PID_APP_POPUPBTPHONEPAIRING)) { eventId = CIT_EVENT_ID(OnEnableandShowPopUp_SM_MEDIA_PID_APP_POPUPBTPHONEPAIRING, 0x8F8B72D2); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForEnableandShowPopUp(AppHmi_MediaStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::EnableandShowPopUp const & message = static_cast< ::EnableandShowPopUp const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForShutdownMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnShutdownMsg, 0x756C0DF3);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForShutdownMsg(AppHmi_MediaStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForBrowseListRespMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnBrowseListRespMsg, 0x8C1F15A1);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForBrowseListRespMsg(AppHmi_MediaStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForMediaMessagepopupRelease(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnMediaMessagepopupRelease, 0xC63A7303);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForMediaMessagepopupRelease(AppHmi_MediaStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForTransitionIndMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::Courier::TransitionIndMsg const & message = static_cast< ::Courier::TransitionIndMsg const &>(aMessage);

#ifdef OnPageFlipFrontFinishedSrc_USB
    if ((message.GetTransitionId() == ::Courier::ItemId("PageFlipFrontTransition")) && (message.GetFirstViewId() == ::Courier::ViewId("Media#MediaPlayerScenes#M_SourceSelection_Media")) && (message.GetSecondViewId() == ::Courier::ViewId("Media#MediaPlayerScenes#M_USB")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnPageFlipFrontFinishedSrc_USB, 0x7ED713B5); return true; }
#endif
#ifdef OnPageFlipBackFinishedTitleList_USB
    if ((message.GetTransitionId() == ::Courier::ItemId("PageFlipFrontTransition")) && (message.GetFirstViewId() == ::Courier::ViewId("Media#MediaPlayerScenes#M_Title")) && (message.GetSecondViewId() == ::Courier::ViewId("Media#MediaPlayerScenes#M_USB")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnPageFlipBackFinishedTitleList_USB, 0xE8F19318); return true; }
#endif
#ifdef OnPageFlipFrontFinishedUSB_TitleList
    if ((message.GetTransitionId() == ::Courier::ItemId("PageFlipFrontTransition")) && (message.GetFirstViewId() == ::Courier::ViewId("Media#MediaPlayerScenes#M_USB")) && (message.GetSecondViewId() == ::Courier::ViewId("Media#MediaPlayerScenes#M_Title")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnPageFlipFrontFinishedUSB_TitleList, 0x922F93B7); return true; }
#endif
#ifdef OnPageFlipBackFinishedExtDVD_SrcWoNAV
    if ((message.GetTransitionId() == ::Courier::ItemId("PageFlipFrontTransition")) && (message.GetFirstViewId() == ::Courier::ViewId("Media#MediaPlayerScenes#M_ExternalDVD")) && (message.GetSecondViewId() == ::Courier::ViewId("Media#MediaPlayerScenes#M_SourceSelection_Media_woNAV")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnPageFlipBackFinishedExtDVD_SrcWoNAV, 0x5A02A0DD); return true; }
#endif
#ifdef OnPageFlipBackFinishedBT_SrcWoNAV
    if ((message.GetTransitionId() == ::Courier::ItemId("PageFlipFrontTransition")) && (message.GetFirstViewId() == ::Courier::ViewId("Media#MediaPlayerScenes#M_BT")) && (message.GetSecondViewId() == ::Courier::ViewId("Media#MediaPlayerScenes#M_SourceSelection_Media_woNAV")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnPageFlipBackFinishedBT_SrcWoNAV, 0xCDB4DE26); return true; }
#endif
#ifdef OnPageFlipBackFinishedUSB_SrcWoNAV
    if ((message.GetTransitionId() == ::Courier::ItemId("PageFlipFrontTransition")) && (message.GetFirstViewId() == ::Courier::ViewId("Media#MediaPlayerScenes#M_USB")) && (message.GetSecondViewId() == ::Courier::ViewId("Media#MediaPlayerScenes#M_SourceSelection_Media_woNAV")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnPageFlipBackFinishedUSB_SrcWoNAV, 0xEDC979E2); return true; }
#endif
#ifdef OnPageFlipFrontFinishedSrcWoNAV_ExtDVD
    if ((message.GetTransitionId() == ::Courier::ItemId("PageFlipFrontTransition")) && (message.GetFirstViewId() == ::Courier::ViewId("Media#MediaPlayerScenes#M_SourceSelection_Media_woNAV")) && (message.GetSecondViewId() == ::Courier::ViewId("Media#MediaPlayerScenes#M_ExternalDVD")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnPageFlipFrontFinishedSrcWoNAV_ExtDVD, 0x8C040EEB); return true; }
#endif
#ifdef OnPageFlipFrontFinishedSrcWoNAV_BT
    if ((message.GetTransitionId() == ::Courier::ItemId("PageFlipFrontTransition")) && (message.GetFirstViewId() == ::Courier::ViewId("Media#MediaPlayerScenes#M_SourceSelection_Media_woNAV")) && (message.GetSecondViewId() == ::Courier::ViewId("Media#MediaPlayerScenes#M_BT")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnPageFlipFrontFinishedSrcWoNAV_BT, 0xB8AED9F9); return true; }
#endif
#ifdef OnPageFlipFrontFinishedSrcWoNAV_Aux
    if ((message.GetTransitionId() == ::Courier::ItemId("PageFlipFrontTransition")) && (message.GetFirstViewId() == ::Courier::ViewId("Media#MediaPlayerScenes#M_SourceSelection_Media_woNAV")) && (message.GetSecondViewId() == ::Courier::ViewId("Media#MediaPlayerScenes#M_AUX")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnPageFlipFrontFinishedSrcWoNAV_Aux, 0x7EB65EF8); return true; }
#endif
#ifdef OnPageFlipBackFinishedAux_SrcWoNAV
    if ((message.GetTransitionId() == ::Courier::ItemId("PageFlipFrontTransition")) && (message.GetFirstViewId() == ::Courier::ViewId("Media#MediaPlayerScenes#M_AUX")) && (message.GetSecondViewId() == ::Courier::ViewId("Media#MediaPlayerScenes#M_SourceSelection_Media_woNAV")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnPageFlipBackFinishedAux_SrcWoNAV, 0x0C68EC1A); return true; }
#endif
#ifdef OnPageFlipBackFinishedExtDVD_Src
    if ((message.GetTransitionId() == ::Courier::ItemId("PageFlipFrontTransition")) && (message.GetFirstViewId() == ::Courier::ViewId("Media#MediaPlayerScenes#M_ExternalDVD")) && (message.GetSecondViewId() == ::Courier::ViewId("Media#MediaPlayerScenes#M_SourceSelection_Media")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnPageFlipBackFinishedExtDVD_Src, 0xF74580D3); return true; }
#endif
#ifdef OnPageFlipBackFinishedBT_Src
    if ((message.GetTransitionId() == ::Courier::ItemId("PageFlipFrontTransition")) && (message.GetFirstViewId() == ::Courier::ViewId("Media#MediaPlayerScenes#M_BT")) && (message.GetSecondViewId() == ::Courier::ViewId("Media#MediaPlayerScenes#M_SourceSelection_Media")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnPageFlipBackFinishedBT_Src, 0x553D82F6); return true; }
#endif
#ifdef OnPageFlipBackFinishedAux_Src
    if ((message.GetTransitionId() == ::Courier::ItemId("PageFlipFrontTransition")) && (message.GetFirstViewId() == ::Courier::ViewId("Media#MediaPlayerScenes#M_AUX")) && (message.GetSecondViewId() == ::Courier::ViewId("Media#MediaPlayerScenes#M_SourceSelection_Media")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnPageFlipBackFinishedAux_Src, 0x268E1B7D); return true; }
#endif
#ifdef OnPageFlipBackFinishedUSB_Src
    if ((message.GetTransitionId() == ::Courier::ItemId("PageFlipFrontTransition")) && (message.GetFirstViewId() == ::Courier::ViewId("Media#MediaPlayerScenes#M_USB")) && (message.GetSecondViewId() == ::Courier::ViewId("Media#MediaPlayerScenes#M_SourceSelection_Media")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnPageFlipBackFinishedUSB_Src, 0x83CB8E78); return true; }
#endif
#ifdef OnPageFlipFrontFinishedSrc_ExtDVD
    if ((message.GetTransitionId() == ::Courier::ItemId("PageFlipFrontTransition")) && (message.GetFirstViewId() == ::Courier::ViewId("Media#MediaPlayerScenes#M_SourceSelection_Media")) && (message.GetSecondViewId() == ::Courier::ViewId("Media#MediaPlayerScenes#M_ExternalDVD")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnPageFlipFrontFinishedSrc_ExtDVD, 0xC9492AE9); return true; }
#endif
#ifdef OnPageFlipFrontFinishedSrc_BT
    if ((message.GetTransitionId() == ::Courier::ItemId("PageFlipFrontTransition")) && (message.GetFirstViewId() == ::Courier::ViewId("Media#MediaPlayerScenes#M_SourceSelection_Media")) && (message.GetSecondViewId() == ::Courier::ViewId("Media#MediaPlayerScenes#M_BT")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnPageFlipFrontFinishedSrc_BT, 0x8D50BBFB); return true; }
#endif
#ifdef OnPageFlipFrontFinishedSrc_Aux
    if ((message.GetTransitionId() == ::Courier::ItemId("PageFlipFrontTransition")) && (message.GetFirstViewId() == ::Courier::ViewId("Media#MediaPlayerScenes#M_SourceSelection_Media")) && (message.GetSecondViewId() == ::Courier::ViewId("Media#MediaPlayerScenes#M_AUX")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnPageFlipFrontFinishedSrc_Aux, 0x11D7EB40); return true; }
#endif
#ifdef OnPageFlipFrontFinishedSrcWoNAV_USB
    if ((message.GetTransitionId() == ::Courier::ItemId("PageFlipFrontTransition")) && (message.GetFirstViewId() == ::Courier::ViewId("Media#MediaPlayerScenes#M_SourceSelection_Media_woNAV")) && (message.GetSecondViewId() == ::Courier::ViewId("Media#MediaPlayerScenes#M_USB")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnPageFlipFrontFinishedSrcWoNAV_USB, 0xC5002AFD); return true; }
#endif
#ifdef OnFadeAnimationFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("FadeTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnFadeAnimationFinished, 0xE9A6D56C); return true; }
#endif
#ifdef OnZoomOutFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("ZoomOutTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnZoomOutFinished, 0xF84B3BD1); return true; }
#endif
#ifdef OnZoomInFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("ZoomInTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnZoomInFinished, 0xFBEEA58F); return true; }
#endif
#ifdef OnNextLevelTransitionFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("NextLevelTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnNextLevelTransitionFinished, 0xE7DCE080); return true; }
#endif
#ifdef OnPageFlipBackFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("PageFlipBackTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnPageFlipBackFinished, 0x74F534EE); return true; }
#endif
#ifdef OnPreviousLevelTransitionFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("PreviousLevelTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnPreviousLevelTransitionFinished, 0x26C30D04); return true; }
#endif
#ifdef OnDualViewLeftTransitionFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("DualViewLeftTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnDualViewLeftTransitionFinished, 0x403A65A4); return true; }
#endif
#ifdef OnPageFlipFrontFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("PageFlipFrontTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnPageFlipFrontFinished, 0x437D9EFE); return true; }
#endif
#ifdef OnDualViewRightTransitionFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("DualViewRightTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnDualViewRightTransitionFinished, 0x50B4DCCA); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForTransitionIndMsg(AppHmi_MediaStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::Courier::TransitionIndMsg const & message = static_cast< ::Courier::TransitionIndMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onHorListTabButtonItem
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onHorListTabButtonItem 0xffff
#pragma _REMINDER("Using dummy value symbol onHorListTabButtonItem ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onHorListTabButtonItem -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onExternalMediaTabButtonPress
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onExternalMediaTabButtonPress 0xffff
#pragma _REMINDER("Using dummy value symbol onExternalMediaTabButtonPress ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onExternalMediaTabButtonPress -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onExternalMediaListItemPress
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onExternalMediaListItemPress 0xffff
#pragma _REMINDER("Using dummy value symbol onExternalMediaListItemPress ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onExternalMediaListItemPress -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForButtonListItemUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::ButtonListItemUpdMsg const & message = static_cast< ::ButtonListItemUpdMsg const &>(aMessage);

#ifdef onHorListTabButtonItem
    if ((message.GetListId() == LISTID_MEDIA_HOR) && (message.GetReaction() == enRelease)) { eventId = CIT_EVENT_ID(onHorListTabButtonItem, 0x2324EAFF); return true; }
#endif
#ifdef onExternalMediaTabButtonPress
    if ((message.GetListId() == LISTID_EXTERNAL_MEDIA_HOR) && (message.GetReaction() == enRelease)) { eventId = CIT_EVENT_ID(onExternalMediaTabButtonPress, 0x15AAA995); return true; }
#endif
#ifdef onExternalMediaListItemPress
    if ((message.GetListId() == LIST_ID_EXTERNAL_MEDIA_VER) && (message.GetReaction() == enRelease)) { eventId = CIT_EVENT_ID(onExternalMediaListItemPress, 0xC205FC69); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForButtonListItemUpdMsg(AppHmi_MediaStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::ButtonListItemUpdMsg const & message = static_cast< ::ButtonListItemUpdMsg const &>(aMessage);
#ifdef onHorListTabButtonItem
    if (eventId == onHorListTabButtonItem) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetHdl()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onHorListTabButtonItem.Hdl = message.GetHdl();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onExternalMediaTabButtonPress
    if (eventId == onExternalMediaTabButtonPress) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetHdl()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onExternalMediaTabButtonPress.Hdl = message.GetHdl();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onExternalMediaListItemPress
    if (eventId == onExternalMediaListItemPress) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetHdl(), message.GetSubHdl()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onExternalMediaListItemPress.Hdl = message.GetHdl();
        onClickParam.VSEPS_onExternalMediaListItemPress.SubHdl = message.GetSubHdl();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForWaitAnimationReqMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::WaitAnimationReqMsg const & message = static_cast< ::WaitAnimationReqMsg const &>(aMessage);

#ifdef onWaitAnimationStart
    if ((message.GetRequestType() == ANIMATION_START)) { eventId = CIT_EVENT_ID(onWaitAnimationStart, 0x8BC98A40); return true; }
#endif
#ifdef onWaitAnimationStop
    if ((message.GetRequestType() == ANIMATION_STOP)) { eventId = CIT_EVENT_ID(onWaitAnimationStop, 0x1CFF5C6E); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForWaitAnimationReqMsg(AppHmi_MediaStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::WaitAnimationReqMsg const & message = static_cast< ::WaitAnimationReqMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForPopup_Pfo_VideoDisableMessage_Close(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnPopup_Pfo_VideoDisableMessage_Close, 0xDCCA5F91);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForPopup_Pfo_VideoDisableMessage_Close(AppHmi_MediaStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForActiveMediaSource_Appflyinn_Msg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnActiveMediaSource_Appflyinn_Msg, 0xDAC45BFD);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActiveMediaSource_Appflyinn_Msg(AppHmi_MediaStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForPopup_Pfo_VideoDisableMessage_Open(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnPopup_Pfo_VideoDisableMessage_Open, 0x276C78F3);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForPopup_Pfo_VideoDisableMessage_Open(AppHmi_MediaStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForOpen_Settings_Screen(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnOpen_Settings_Screen, 0xDA21E229);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForOpen_Settings_Screen(AppHmi_MediaStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForOpen_WMA_DRM_Popup(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnOpen_WMA_DRM_Popup, 0xA3650C33);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForOpen_WMA_DRM_Popup(AppHmi_MediaStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForClose_WMA_DRM_Popup(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnClose_WMA_DRM_Popup, 0xC27AC9B9);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForClose_WMA_DRM_Popup(AppHmi_MediaStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForPopup_Pfo_MediaGlassUnavailableMessage_Close(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnPopup_Pfo_MediaGlassUnavailableMessage_Close, 0x02D31FE5);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForPopup_Pfo_MediaGlassUnavailableMessage_Close(AppHmi_MediaStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForPopup_Pfo_MediaGlassUnavailableMessage_Open(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnPopup_Pfo_MediaGlassUnavailableMessage_Open, 0x15148244);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForPopup_Pfo_MediaGlassUnavailableMessage_Open(AppHmi_MediaStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForOpen_SourceSelection_Screen(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnOpen_SourceSelection_Screen, 0xEEA520DB);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForOpen_SourceSelection_Screen(AppHmi_MediaStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForSwitchFullScreenVideo(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnSwitchFullScreenVideo, 0x49B2C18F);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSwitchFullScreenVideo(AppHmi_MediaStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined OnUpdate_MediaActivityID
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define OnUpdate_MediaActivityID 0xffff
#pragma _REMINDER("Using dummy value symbol OnUpdate_MediaActivityID ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol OnUpdate_MediaActivityID -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForUpdate_MediaActivityID(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnUpdate_MediaActivityID, 0x49D85FE0);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForUpdate_MediaActivityID(AppHmi_MediaStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::Update_MediaActivityID const & message = static_cast< ::Update_MediaActivityID const &>(aMessage);
#ifdef OnUpdate_MediaActivityID
    if (eventId == OnUpdate_MediaActivityID) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetMediaActivityID()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_OnUpdate_MediaActivityID.MediaActivityID = message.GetMediaActivityID();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForPopup_Pfo_NoPlayableContentPopup_Close(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnPopup_Pfo_NoPlayableContentPopup_Close, 0x2E338282);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForPopup_Pfo_NoPlayableContentPopup_Close(AppHmi_MediaStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForPopup_Pfo_NoPlayableContentPopup_Open(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnPopup_Pfo_NoPlayableContentPopup_Open, 0x006B223E);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForPopup_Pfo_NoPlayableContentPopup_Open(AppHmi_MediaStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForPopup_Pfo_SignalRangeError_Open(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnPopup_Pfo_SignalRangeError_Open, 0x21A647E1);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForPopup_Pfo_SignalRangeError_Open(AppHmi_MediaStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onEncoderStatusChanged_RIGHT_ENC
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onEncoderStatusChanged_RIGHT_ENC 0xffff
#pragma _REMINDER("Using dummy value symbol onEncoderStatusChanged_RIGHT_ENC ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onEncoderStatusChanged_RIGHT_ENC -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForEncoderStatusChangedUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::EncoderStatusChangedUpdMsg const & message = static_cast< ::EncoderStatusChangedUpdMsg const &>(aMessage);

#ifdef onEncoderStatusChanged_RIGHT_ENC
    if ((message.GetEncCode() == ENCCODE_RIGHT_ENCODER)) { eventId = CIT_EVENT_ID(onEncoderStatusChanged_RIGHT_ENC, 0x67E5D82B); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForEncoderStatusChangedUpdMsg(AppHmi_MediaStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::EncoderStatusChangedUpdMsg const & message = static_cast< ::EncoderStatusChangedUpdMsg const &>(aMessage);
#ifdef onEncoderStatusChanged_RIGHT_ENC
    if (eventId == onEncoderStatusChanged_RIGHT_ENC) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetEncSteps()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onEncoderStatusChanged_RIGHT_ENC.EncSteps = message.GetEncSteps();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForHKStatusChangedUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::HKStatusChangedUpdMsg const & message = static_cast< ::HKStatusChangedUpdMsg const &>(aMessage);

#ifdef onHKStatusChanged_HK_SELECT_UP
    if ((message.GetHKCode() == HARDKEYCODE_HK_SELECT) && (message.GetHKState() == HARDKEYSTATE_UP)) { eventId = CIT_EVENT_ID(onHKStatusChanged_HK_SELECT_UP, 0x263EAF7F); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForHKStatusChangedUpdMsg(AppHmi_MediaStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::HKStatusChangedUpdMsg const & message = static_cast< ::HKStatusChangedUpdMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onPopupTimerExpiry
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onPopupTimerExpiry 0xffff
#pragma _REMINDER("Using dummy value symbol onPopupTimerExpiry ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onPopupTimerExpiry -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForExpiredPopupTimerResMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(onPopupTimerExpiry, 0xF3C96D17);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForExpiredPopupTimerResMsg(AppHmi_MediaStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::ExpiredPopupTimerResMsg const & message = static_cast< ::ExpiredPopupTimerResMsg const &>(aMessage);
#ifdef onPopupTimerExpiry
    if (eventId == onPopupTimerExpiry) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetViewId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onPopupTimerExpiry.ViewId = message.GetViewId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onActivateImageProviderRequest
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onActivateImageProviderRequest 0xffff
#pragma _REMINDER("Using dummy value symbol onActivateImageProviderRequest ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onActivateImageProviderRequest -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onDeactivateImageProviderRequest
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onDeactivateImageProviderRequest 0xffff
#pragma _REMINDER("Using dummy value symbol onDeactivateImageProviderRequest ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onDeactivateImageProviderRequest -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForActivateImageProviderReqMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::hmibase::gadget::ActivateImageProviderReqMsg const & message = static_cast< ::hmibase::gadget::ActivateImageProviderReqMsg const &>(aMessage);

#ifdef onActivateImageProviderRequest
    if ((message.GetActivate() == 1)) { eventId = CIT_EVENT_ID(onActivateImageProviderRequest, 0xDD62EA5B); return true; }
#endif
#ifdef onDeactivateImageProviderRequest
    if ((message.GetActivate() == 0)) { eventId = CIT_EVENT_ID(onDeactivateImageProviderRequest, 0x9FE98C1E); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActivateImageProviderReqMsg(AppHmi_MediaStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::hmibase::gadget::ActivateImageProviderReqMsg const & message = static_cast< ::hmibase::gadget::ActivateImageProviderReqMsg const &>(aMessage);
#ifdef onActivateImageProviderRequest
    if (eventId == onActivateImageProviderRequest) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetInstanceId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onActivateImageProviderRequest.InstanceId = message.GetInstanceId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onDeactivateImageProviderRequest
    if (eventId == onDeactivateImageProviderRequest) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetInstanceId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onDeactivateImageProviderRequest.InstanceId = message.GetInstanceId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForHMISubStateChangedUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::HMISubStateChangedUpdMsg const & message = static_cast< ::HMISubStateChangedUpdMsg const &>(aMessage);

#ifdef onHMISubStateChanged_ON
    if ((message.GetSubState() == HMISTATE_SHOW_HMI)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_ON, 0x76CF2B88); return true; }
#endif
#ifdef onHMISubStateChanged_CLOCK
    if ((message.GetSubState() == HMISTATE_SHOW_CLOCK)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_CLOCK, 0xF96478DC); return true; }
#endif
#ifdef onHMISubStateChanged_OFF
    if ((message.GetSubState() == HMISTATE_SHOW_OFF)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_OFF, 0x776D7D8A); return true; }
#endif
#ifdef onHMISubStateChanged_STANDBY_RESTRICTED
    if ((message.GetSubState() == HMISTATE_STANDBY_RESTRICTED)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_STANDBY_RESTRICTED, 0xA15C3CEE); return true; }
#endif
#ifdef onHMISubStateChanged_STANDBY
    if ((message.GetSubState() == HMISTATE_STANDBY)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_STANDBY, 0x0D0F5602); return true; }
#endif
#ifdef onHMISubStateChanged_PHONE
    if ((message.GetSubState() == HMISTATE_PHONE)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_PHONE, 0xC8D83B8B); return true; }
#endif
#ifdef onHMISubStateChanged_NO_DISPLAY
    if ((message.GetSubState() == HMISTATE_SHOW_NO_DISPLAY)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_NO_DISPLAY, 0xE4658CFD); return true; }
#endif
#ifdef onHMISubStateChanged_SECURE
    if ((message.GetSubState() == HMISTATE_SECURE)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_SECURE, 0xAB89D7A8); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForHMISubStateChangedUpdMsg(AppHmi_MediaStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::HMISubStateChangedUpdMsg const & message = static_cast< ::HMISubStateChangedUpdMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForApplicationStateUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::ApplicationStateUpdMsg const & message = static_cast< ::ApplicationStateUpdMsg const &>(aMessage);

#ifdef onAppStatusChanged_FOREGROUND
    if ((message.GetState() == hmibase::IN_FOREGROUND)) { eventId = CIT_EVENT_ID(onAppStatusChanged_FOREGROUND, 0xDE9448E3); return true; }
#endif
#ifdef onAppStatusChanged_BACKGROUND
    if ((message.GetState() == hmibase::IN_BACKGROUND)) { eventId = CIT_EVENT_ID(onAppStatusChanged_BACKGROUND, 0x6D1B3A68); return true; }
#endif
#ifdef onAppStatusPrepare_BACKGROUND
    if ((message.GetState() == hmibase::TO_BACKGROUND)) { eventId = CIT_EVENT_ID(onAppStatusPrepare_BACKGROUND, 0x4C8518AE); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForApplicationStateUpdMsg(AppHmi_MediaStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::ApplicationStateUpdMsg const & message = static_cast< ::ApplicationStateUpdMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onSubSurfaceUpdMsgChanged_FOREGROUND
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onSubSurfaceUpdMsgChanged_FOREGROUND 0xffff
#pragma _REMINDER("Using dummy value symbol onSubSurfaceUpdMsgChanged_FOREGROUND ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onSubSurfaceUpdMsgChanged_FOREGROUND -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onSubSurfaceUpdMsgChanged_BACKGROUND
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onSubSurfaceUpdMsgChanged_BACKGROUND 0xffff
#pragma _REMINDER("Using dummy value symbol onSubSurfaceUpdMsgChanged_BACKGROUND ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onSubSurfaceUpdMsgChanged_BACKGROUND -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForSubSurfaceUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::SubSurfaceUpdMsg const & message = static_cast< ::SubSurfaceUpdMsg const &>(aMessage);

#ifdef onSubSurfaceUpdMsgChanged_FOREGROUND
    if ((message.GetState() == hmibase::IN_FOREGROUND)) { eventId = CIT_EVENT_ID(onSubSurfaceUpdMsgChanged_FOREGROUND, 0x9D4DF4FC); return true; }
#endif
#ifdef onSubSurfaceUpdMsgChanged_BACKGROUND
    if ((message.GetState() == hmibase::IN_BACKGROUND)) { eventId = CIT_EVENT_ID(onSubSurfaceUpdMsgChanged_BACKGROUND, 0x5790D8C1); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSubSurfaceUpdMsg(AppHmi_MediaStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::SubSurfaceUpdMsg const & message = static_cast< ::SubSurfaceUpdMsg const &>(aMessage);
#ifdef onSubSurfaceUpdMsgChanged_FOREGROUND
    if (eventId == onSubSurfaceUpdMsgChanged_FOREGROUND) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetDisplayRegion(), message.GetDisplayID()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onSubSurfaceUpdMsgChanged_FOREGROUND.DisplayRegion = message.GetDisplayRegion();
        onClickParam.VSEPS_onSubSurfaceUpdMsgChanged_FOREGROUND.DisplayID = message.GetDisplayID();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onSubSurfaceUpdMsgChanged_BACKGROUND
    if (eventId == onSubSurfaceUpdMsgChanged_BACKGROUND) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetDisplayRegion(), message.GetDisplayID()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onSubSurfaceUpdMsgChanged_BACKGROUND.DisplayRegion = message.GetDisplayRegion();
        onClickParam.VSEPS_onSubSurfaceUpdMsgChanged_BACKGROUND.DisplayID = message.GetDisplayID();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_MediaStateMachineImpl::VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
struct EventMapping
{
    ::FeatStd::UInt32 mHashId;
    bool (*mEventCallHandler)(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId);
};

struct EventDeductionMapping
{
    ::FeatStd::UInt32 mHashId;
    ::Cit::DeductResult::Enum (*mEventCallHandler)(AppHmi_MediaStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId);
};

static ::FeatStd::Int EventMappingCmp(::FeatStd::UInt32 hash, const EventMapping& em)
{
    return (hash == em.mHashId) ? 0 : ((hash < em.mHashId) ? -1 : 1);
}

static ::FeatStd::Int EventDeductionMappingCmp(::FeatStd::UInt32 hash, const EventDeductionMapping& em)
{
    return (hash == em.mHashId) ? 0 : ((hash < em.mHashId) ? -1 : 1);
}

bool AppHmi_MediaStateMachineImpl::HandleEventMapping(::Courier::Message const & message, ::FeatStd::UInt32& eventId) const
{
    static EventMapping events[56] = {
        { 0x04B8AFB9, HandleEventMappingForHKStatusChangedUpdMsg },
        { 0x12D9BDE4, HandleEventMappingForActivateSwitchToSourceSel },
        { 0x1536C3F4, HandleEventMappingForButtonListItemUpdMsg },
        { 0x16AE3CBF, HandleEventMappingForOpen_WMA_DRM_Popup },
        { 0x21624D18, HandleEventMappingForVehicleSensorSpeedModestatusMsg },
        { 0x24423DF4, HandleEventMappingForPopup_Pfo_NoPlayableContentPopup_Close },
        { 0x2CC597E8, HandleEventMappingForSourceSelectionStateResp },
        { 0x321690B5, HandleEventMappingForPopup_Pfo_VideoDisableMessage_Close },
        { 0x376F1B6D, HandleEventMappingForVehicleSensorExtDVDSpeedModestatusMsg },
        { 0x3824FE1D, HandleEventMappingForApplicationStateUpdMsg },
        { 0x3D70E0BF, HandleEventMappingForUpdate_MediaActivityID },
        { 0x3D97BCE1, HandleEventMappingForOpen_Settings_Screen },
        { 0x3F18A543, HandleEventMappingForPopup_Pfo_VideoDisableMessage_Open },
        { 0x4A69141E, HandleEventMappingForHMISubStateChangedUpdMsg },
        { 0x4FF79763, HandleEventMappingForEncoderStatusChangedUpdMsg },
        { 0x61CB2777, HandleEventMappingForActivateSourceSwitchToUSB },
        { 0x662D515B, HandleEventMappingForSwitchFullScreenVideo },
        { 0x69FAC6F1, HandleEventMappingForSubSurfaceUpdMsg },
        { 0x6AE0FD3C, HandleEventMappingForButtonReactionMsg },
        { 0x792A7A89, HandleEventMappingForActicvateAlbumSceneMsg },
        { 0x7AF0C2F8, HandleEventMappingForActicvateVideorestrictionpopupmessage },
        { 0x7CC83844, HandleEventMappingForUpdateActiveDevicestatusMsg },
        { 0x80C6DAB8, HandleEventMappingForPopup_Pfo_MediaGlassUnavailableMessage_Open },
        { 0x8A611AAF, HandleEventMappingForNewListEntryMsg },
        { 0x8BBD0734, HandleEventMappingForEnableView },
        { 0x8C7564D4, HandleEventMappingForClose_WMA_DRM_Popup },
        { 0x8D4DB5D8, HandleEventMappingForDisableView },
        { 0x93A5580A, HandleEventMappingForActivityMsg },
        { 0x9B65735D, HandleEventMappingForPopup_Pfo_SignalRangeError_Open },
        { 0x9C2AB294, HandleEventMappingForAudioSongSelectionMsg },
        { 0xA53C85C8, HandleEventMappingForActivateSourceSwitchToBT },
        { 0xA60CB9F4, HandleEventMappingForShutdownMsg },
        { 0xAE3CAAA7, HandleEventMappingForExpiredPopupTimerResMsg },
        { 0xB417D195, HandleEventMappingForPlayAudioVideoSong },
        { 0xB42FFCB1, HandleEventMappingForPopup_Pfo_MediaGlassUnavailableMessage_Close },
        { 0xB75A5396, HandleEventMappingForVehicleSensorExtDVDparkingbreakStatusMsg },
        { 0xC277DA2B, HandleEventMappingForActivateApplicationMsg },
        { 0xC613E40C, HandleEventMappingForActivateImageProviderReqMsg },
        { 0xC7B455FB, HandleEventMappingForTransitionIndMsg },
        { 0xC9316303, HandleEventMappingForOpen_SourceSelection_Screen },
        { 0xD018667E, HandleEventMappingForActivateSourceSwitchToAUX },
        { 0xD1B49C1B, HandleEventMappingForActivateSourceSwitchToDVD },
        { 0xD1F2BA22, HandleEventMappingForMediaMessagepopupRelease },
        { 0xD384B04C, HandleEventMappingForActiveMediaSource_Appflyinn_Msg },
        { 0xD4AC7BDB, HandleEventMappingForActivationResMsg },
        { 0xD8F16798, HandleEventMappingForVehicleSensorparkingbreakStatusMsg },
        { 0xDAE968BA, HandleEventMappingForDeactivateApplicationMsg },
        { 0xE2F61D55, HandleEventMappingForSurfaceStateChangedUpdMsg },
        { 0xE4B830C9, HandleEventMappingForActivatePopUpMsg },
        { 0xF4489C45, HandleEventMappingForEnableandShowPopUp },
        { 0xF586EDD6, HandleEventMappingForWaitAnimationReqMsg },
        { 0xF6217210, HandleEventMappingForBrowseListRespMsg },
        { 0xF92AB393, HandleEventMappingForVideoSongSelectionMsg },
        { 0xF94C01AE, HandleEventMappingForPopup_Pfo_NoPlayableContentPopup_Open },
        { 0xFA81E285, HandleEventMappingForDeActivatePopUpMsg },
        { 0xFBA1F8A2, HandleEventMappingForExtDVDConnectionModeStatusMsg },
    };
    ::FeatStd::UInt32 hashId = message.GetId();
    const EventMapping* eventEntry = ::Courier::BinarySearch(hashId, events, 56, &EventMappingCmp);
    if (eventEntry && (hashId == eventEntry->mHashId)) {
        return eventEntry->mEventCallHandler(message, eventId);
    }
    return false;
}

// ------------------------------------------------------------------------
::Cit::DeductResult::Enum AppHmi_MediaStateMachineImpl::DeductEvent(::Courier::Message const & aMessage, ::FeatStd::UInt32 eventId)
{
    ::Cit::DeductResult::Enum deductResult = Cit::DeductResult::DeductOk;
    static EventDeductionMapping events[56] = {
        { 0x04B8AFB9, HandleEventDeductionForHKStatusChangedUpdMsg },
        { 0x12D9BDE4, HandleEventDeductionForActivateSwitchToSourceSel },
        { 0x1536C3F4, HandleEventDeductionForButtonListItemUpdMsg },
        { 0x16AE3CBF, HandleEventDeductionForOpen_WMA_DRM_Popup },
        { 0x21624D18, HandleEventDeductionForVehicleSensorSpeedModestatusMsg },
        { 0x24423DF4, HandleEventDeductionForPopup_Pfo_NoPlayableContentPopup_Close },
        { 0x2CC597E8, HandleEventDeductionForSourceSelectionStateResp },
        { 0x321690B5, HandleEventDeductionForPopup_Pfo_VideoDisableMessage_Close },
        { 0x376F1B6D, HandleEventDeductionForVehicleSensorExtDVDSpeedModestatusMsg },
        { 0x3824FE1D, HandleEventDeductionForApplicationStateUpdMsg },
        { 0x3D70E0BF, HandleEventDeductionForUpdate_MediaActivityID },
        { 0x3D97BCE1, HandleEventDeductionForOpen_Settings_Screen },
        { 0x3F18A543, HandleEventDeductionForPopup_Pfo_VideoDisableMessage_Open },
        { 0x4A69141E, HandleEventDeductionForHMISubStateChangedUpdMsg },
        { 0x4FF79763, HandleEventDeductionForEncoderStatusChangedUpdMsg },
        { 0x61CB2777, HandleEventDeductionForActivateSourceSwitchToUSB },
        { 0x662D515B, HandleEventDeductionForSwitchFullScreenVideo },
        { 0x69FAC6F1, HandleEventDeductionForSubSurfaceUpdMsg },
        { 0x6AE0FD3C, HandleEventDeductionForButtonReactionMsg },
        { 0x792A7A89, HandleEventDeductionForActicvateAlbumSceneMsg },
        { 0x7AF0C2F8, HandleEventDeductionForActicvateVideorestrictionpopupmessage },
        { 0x7CC83844, HandleEventDeductionForUpdateActiveDevicestatusMsg },
        { 0x80C6DAB8, HandleEventDeductionForPopup_Pfo_MediaGlassUnavailableMessage_Open },
        { 0x8A611AAF, HandleEventDeductionForNewListEntryMsg },
        { 0x8BBD0734, HandleEventDeductionForEnableView },
        { 0x8C7564D4, HandleEventDeductionForClose_WMA_DRM_Popup },
        { 0x8D4DB5D8, HandleEventDeductionForDisableView },
        { 0x93A5580A, HandleEventDeductionForActivityMsg },
        { 0x9B65735D, HandleEventDeductionForPopup_Pfo_SignalRangeError_Open },
        { 0x9C2AB294, HandleEventDeductionForAudioSongSelectionMsg },
        { 0xA53C85C8, HandleEventDeductionForActivateSourceSwitchToBT },
        { 0xA60CB9F4, HandleEventDeductionForShutdownMsg },
        { 0xAE3CAAA7, HandleEventDeductionForExpiredPopupTimerResMsg },
        { 0xB417D195, HandleEventDeductionForPlayAudioVideoSong },
        { 0xB42FFCB1, HandleEventDeductionForPopup_Pfo_MediaGlassUnavailableMessage_Close },
        { 0xB75A5396, HandleEventDeductionForVehicleSensorExtDVDparkingbreakStatusMsg },
        { 0xC277DA2B, HandleEventDeductionForActivateApplicationMsg },
        { 0xC613E40C, HandleEventDeductionForActivateImageProviderReqMsg },
        { 0xC7B455FB, HandleEventDeductionForTransitionIndMsg },
        { 0xC9316303, HandleEventDeductionForOpen_SourceSelection_Screen },
        { 0xD018667E, HandleEventDeductionForActivateSourceSwitchToAUX },
        { 0xD1B49C1B, HandleEventDeductionForActivateSourceSwitchToDVD },
        { 0xD1F2BA22, HandleEventDeductionForMediaMessagepopupRelease },
        { 0xD384B04C, HandleEventDeductionForActiveMediaSource_Appflyinn_Msg },
        { 0xD4AC7BDB, HandleEventDeductionForActivationResMsg },
        { 0xD8F16798, HandleEventDeductionForVehicleSensorparkingbreakStatusMsg },
        { 0xDAE968BA, HandleEventDeductionForDeactivateApplicationMsg },
        { 0xE2F61D55, HandleEventDeductionForSurfaceStateChangedUpdMsg },
        { 0xE4B830C9, HandleEventDeductionForActivatePopUpMsg },
        { 0xF4489C45, HandleEventDeductionForEnableandShowPopUp },
        { 0xF586EDD6, HandleEventDeductionForWaitAnimationReqMsg },
        { 0xF6217210, HandleEventDeductionForBrowseListRespMsg },
        { 0xF92AB393, HandleEventDeductionForVideoSongSelectionMsg },
        { 0xF94C01AE, HandleEventDeductionForPopup_Pfo_NoPlayableContentPopup_Open },
        { 0xFA81E285, HandleEventDeductionForDeActivatePopUpMsg },
        { 0xFBA1F8A2, HandleEventDeductionForExtDVDConnectionModeStatusMsg },
    };
    ::FeatStd::UInt32 hashId = aMessage.GetId();
    const EventDeductionMapping* eventEntry = ::Courier::BinarySearch(hashId, events, 56, &EventDeductionMappingCmp);
    if (eventEntry && (hashId == eventEntry->mHashId)) {
        deductResult = eventEntry->mEventCallHandler(this, aMessage, eventId);
    }
    else {
        typedef Cit::Internal::VSDeductHelper<VS_Ret_Ok, AppHmi_MediaStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
        return VSDeductHelper::ProcessOutput(*this, (*this.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
        return VSDeductHelper::ProcessOutput(*this, (*this.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
    }
    return deductResult;
}

// ------------------------------------------------------------------------
struct DataEventMapping
{
    ::Courier::DataItemKey mKey;
    ::FeatStd::UInt32 mEvent;
};

bool AppHmi_MediaStateMachineImpl::HandleDataBindingEventMapping(::Courier::AbstractDataItemMsg const &message, ::FeatStd::UInt32 &eventId) const
{
    static DataEventMapping dataEvents[1] = {
#ifdef ShowPopUp
        { ItemKey::DeviceConnectStatus::MediaMessageUpdateFlagItem, CIT_EVENT_ID(ShowPopUp, 0x1EB0487D) },
#endif
    };
    for (int i = 0; i < 1; ++i) {
        if (message.ItemRequiresUpdate(dataEvents[i].mKey)) {
            eventId = dataEvents[i].mEvent;
            return true;
        }
    }
    return false;
}

#ifdef CIT_SIMULATION
struct EventNameMapping
{
    ::FeatStd::UInt32 mEventId;
    const ::FeatStd::Char* mEventName;
    void (*mGetEventArguments)(::Courier::Message const & message, Json::Value& eventArguments);
};

static ::FeatStd::Int EventNameMappingCmp(::FeatStd::UInt32 eventId, const EventNameMapping& em)
{
    return (eventId == em.mEventId) ? 0 : ((eventId < em.mEventId) ? -1 : 1);
}

static void GetEventArgumentsForonExternalMediaTabButtonPress(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::ButtonListItemUpdMsg const & message = static_cast< ::ButtonListItemUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetHdl();
}

static void GetEventArgumentsForonHorListTabButtonItem(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::ButtonListItemUpdMsg const & message = static_cast< ::ButtonListItemUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetHdl();
}

static void GetEventArgumentsForonCenterPopupSurfaceVisible(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonTopPopupSurfaceInvisible(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForOnUpdate_MediaActivityID(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::Update_MediaActivityID const & message = static_cast< ::Update_MediaActivityID const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetMediaActivityID();
}

static void GetEventArgumentsForonSubSurfaceUpdMsgChanged_BACKGROUND(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SubSurfaceUpdMsg const & message = static_cast< ::SubSurfaceUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::Int)message.GetDisplayRegion();
    eventArguments[(::Json::Value::UInt)1] = (::Json::Value::UInt)message.GetDisplayID();
}

static void GetEventArgumentsForonEncoderStatusChanged_RIGHT_ENC(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::EncoderStatusChangedUpdMsg const & message = static_cast< ::EncoderStatusChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::Int)message.GetEncSteps();
}

static void GetEventArgumentsForonActivatePopUp(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::ActivatePopUpMsg const & message = static_cast< ::ActivatePopUpMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetPopUpId();
}

static void GetEventArgumentsForonTopPopupSurfaceUnqueued(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonTopPopupSurfaceVisible(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonCenterPopupSurfaceInvisible(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonSubSurfaceUpdMsgChanged_FOREGROUND(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SubSurfaceUpdMsg const & message = static_cast< ::SubSurfaceUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::Int)message.GetDisplayRegion();
    eventArguments[(::Json::Value::UInt)1] = (::Json::Value::UInt)message.GetDisplayID();
}

static void GetEventArgumentsForonDeactivateImageProviderRequest(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::hmibase::gadget::ActivateImageProviderReqMsg const & message = static_cast< ::hmibase::gadget::ActivateImageProviderReqMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetInstanceId();
}

static void GetEventArgumentsForonCenterPopupSurfaceUnqueued(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonTopPopupSurfaceQueued(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonPopupVisible(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonPopupQueued(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonExternalMediaListItemPress(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::ButtonListItemUpdMsg const & message = static_cast< ::ButtonListItemUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetHdl();
    eventArguments[(::Json::Value::UInt)1] = (::Json::Value::UInt)message.GetSubHdl();
}

static void GetEventArgumentsForonPopupUnqueued(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonActivateImageProviderRequest(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::hmibase::gadget::ActivateImageProviderReqMsg const & message = static_cast< ::hmibase::gadget::ActivateImageProviderReqMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetInstanceId();
}

static void GetEventArgumentsForonPopupTimerExpiry(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::ExpiredPopupTimerResMsg const & message = static_cast< ::ExpiredPopupTimerResMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId();
}

static void GetEventArgumentsForonCenterPopupSurfaceQueued(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonDeActivatePopUp(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::DeActivatePopUpMsg const & message = static_cast< ::DeActivatePopUpMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetPopUpId();
}

const ::FeatStd::Char* AppHmi_MediaStateMachineImpl::GetEventName(::FeatStd::UInt32 eventId, ::Courier::Message const & message, Json::Value& eventArguments)
{
    static EventNameMapping events[374] = {
        { 0x006B223E, "OnPopup_Pfo_NoPlayableContentPopup_Open", 0 },
        { 0x0076487C, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_Genre_ButtonWidget2D_Back_enRelease", 0 },
        { 0x00AD06BB, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoPlayer_Layer_AppFlyIn_ButtonWidget2D_Navi_enRelease", 0 },
        { 0x015CB9E4, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoPlayer_Layer_Bg_Video_ButtonWidget_enRelease", 0 },
        { 0x0269A291, "OnActivityMsg_eActivityID_MEDIA_SDCARD", 0 },
        { 0x02D31FE5, "OnPopup_Pfo_MediaGlassUnavailableMessage_Close", 0 },
        { 0x03F6D3C7, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_AUX_Layer_AppFlyIn_ButtonWidget2D_Navi_enRelease", 0 },
        { 0x04AB7E70, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_Layer_TouchArea_Source_ButtonWidget_enRelease", 0 },
        { 0x0603B089, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_ExternalDVD_Layer_AppFlyIn_ButtonWidget2D_Navi_enRelease", 0 },
        { 0x07231E85, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_TouchArea_Next_ButtonWidget_enRelease", 0 },
        { 0x0793DF4E, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_SD_Layer_AppFlyIn_ButtonWidget2D_MirrorLink_enRelease", 0 },
        { 0x08AEB6E8, "OnAudioSongSelectionMsg", 0 },
        { 0x09D97341, "OnButtonReactionMsg_Media_Gadget_Media_MASTER__GADGET_MEDIA_Btn_Play_Pause_ButtonWidget2D_enRelease", 0 },
        { 0x0C68EC1A, "OnPageFlipBackFinishedAux_SrcWoNAV", 0 },
        { 0x0CF74F8F, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBROUTER_TouchArea_SourceInfoM_ButtonWidget_enRelease", 0 },
        { 0x0D0F5602, "onHMISubStateChanged_STANDBY", 0 },
        { 0x0D28BE09, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_Folder_File_ButtonWidget2D_Up_enRelease", 0 },
        { 0x0EBF0542, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_CAMPORTHDMI_3_Layer_TouchArea_Source_ButtonWidget_enRelease", 0 },
        { 0x0F23F1F0, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_woNAV_ButtonWidget2D_AppleDevice_enRelease", 0 },
        { 0x0F724534, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_SD_ButtonWidget2D_Prev_enLongPressRelease", 0 },
        { 0x0F8FE659, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_TouchArea_Repeat_ButtonWidget2D_enRelease", 0 },
        { 0x0FC10626, "OnActivationResMsg_Media_MediaPlayer_Pop_Up_Pfo_SignalRangeError_1", 0 },
        { 0x10A64155, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_USB_Layer_TouchArea_Source_ButtonWidget_enRelease", 0 },
        { 0x10ABA1C1, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_ButtonWidget2D_SDCard_enRelease", 0 },
        { 0x1118D220, "OnActivityMsg_eActivityID_NO_CHANGE", 0 },
        { 0x113F1960, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBROUTER_Layer_TouchArea_Previous_ButtonWidget_enAbortPress", 0 },
        { 0x11B82E5A, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoPlayer_Layer_AppFlyIn_ButtonWidget2D_Phone_enRelease", 0 },
        { 0x11D7EB40, "OnPageFlipFrontFinishedSrc_Aux", 0 },
        { 0x132A0CF7, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBCAMERAPORT_Layer_TouchArea_Next_ButtonWidget_enLongPress", 0 },
        { 0x146A7E8F, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_USB_Layer_TouchArea_Next_ButtonWidget_enLongPressRelease", 0 },
        { 0x1491BF1A, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBROUTER_Layer_TouchArea_Shuffle_ButtonWidget2D_enRelease", 0 },
        { 0x15148244, "OnPopup_Pfo_MediaGlassUnavailableMessage_Open", 0 },
        { 0x15AAA995, "onExternalMediaTabButtonPress", GetEventArgumentsForonExternalMediaTabButtonPress },
        { 0x17712003, "OnEnableView_Media_MediaPlayerScenes_M_OPT", 0 },
        { 0x17F3DB70, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_Artist_Album_ButtonWidget2D_Back_enRelease", 0 },
        { 0x1B4F4FB6, "OnButtonReactionMsg_Media_MediaPlayer_Pop_Up_Pfo_MediaMessage_Btn_MediaMessage_2D_enRelease", 0 },
        { 0x1BB5D3CC, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_TouchArea_Previous_ButtonWidget_enLongPress", 0 },
        { 0x1CFF5C6E, "onWaitAnimationStop", 0 },
        { 0x1EB0487D, "ShowPopUp", 0 },
        { 0x1EC6E3B5, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_Album_Title_ButtonWidget2D_Back_enRelease", 0 },
        { 0x1F4792F5, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoPlayer_Layer_TouchArea_Previous_ButtonWidget_enLongPressRelease", 0 },
        { 0x1F7A5D23, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_woNAV_ButtonWidget2D_Back_enRelease", 0 },
        { 0x200B7DF7, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_TouchArea_Next_ButtonWidget_enLongPress", 0 },
        { 0x20F1A9CC, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_AppFlyIn_ButtonWidget2D_Radio_enRelease", 0 },
        { 0x213807EB, "OnButtonReactionMsg_Media_Gadget_Media_MASTER__GADGET_MEDIA_Btn_Next_ButtonWidget_enPress", 0 },
        { 0x21A647E1, "OnPopup_Pfo_SignalRangeError_Open", 0 },
        { 0x21CD104E, "OnActivationResMsg_Media_MediaPlayer_Pop_Up_Pfo_MediaGlassUnavailableMessage_1", 0 },
        { 0x2324EAFF, "onHorListTabButtonItem", GetEventArgumentsForonHorListTabButtonItem },
        { 0x235CFC9D, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_OPT_Layer_SoundSettings_ButtonWidget_enRelease", 0 },
        { 0x23B97E51, "onCenterPopupSurfaceVisible", GetEventArgumentsForonCenterPopupSurfaceVisible },
        { 0x24E43348, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_BT_Layer_TouchArea_Previous_ButtonWidget_enAbortPress", 0 },
        { 0x257EA9A6, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_Artist_Album_Title_ButtonWidget2D_Back_enRelease", 0 },
        { 0x260247B1, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBROUTER_Layer_TouchArea_Next_ButtonWidget_enRelease", 0 },
        { 0x263EAF7F, "onHKStatusChanged_HK_SELECT_UP", 0 },
        { 0x26643E69, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_Genre_AllAlbums_ButtonWidget2D_Up_enRelease", 0 },
        { 0x268E1B7D, "OnPageFlipBackFinishedAux_Src", 0 },
        { 0x26C30D04, "OnPreviousLevelTransitionFinished", 0 },
        { 0x26D83B21, "OnActivationResMsg_Media_MediaPlayer_Pop_Up_Pfo_FastForwardRewindStart_1", 0 },
        { 0x276C47F3, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoPlayer_Layer_TouchArea_Next_ButtonWidget_enLongPress", 0 },
        { 0x276C78F3, "OnPopup_Pfo_VideoDisableMessage_Open", 0 },
        { 0x27AC2BC2, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_Album_External_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0x2877E5CD, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoPlayer_Layer_AppFlyIn_ButtonWidget2D_Radio_enRelease", 0 },
        { 0x287C46C3, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_TouchArea_PlayPause_touched_ButtonWidget2D_enRelease", 0 },
        { 0x28A45F85, "OnSourceSelectionStateResp_FI_EN_E8DTY_SrcSel", 0 },
        { 0x290DF9A2, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_Album_External_Button_Back_ButtonWidget_enRelease", 0 },
        { 0x2A2BCC3E, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_BT_Layer_TouchArea_Previous_ButtonWidget_enLongPressRelease", 0 },
        { 0x2A66DF0A, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_BT_Layer_TouchArea_Repeat_ButtonWidget2D_enRelease", 0 },
        { 0x2AC139E6, "OnActivationResMsg_Media_MediaPlayer_Pop_Up_Pfo_NoPlayableContentPopup_1", 0 },
        { 0x2AEB8A5B, "OnButtonReactionMsg_Media_Gadget_Media_MASTER__GADGET_MEDIA_Btn_Play_Pause_ButtonWidget2D_enPress", 0 },
        { 0x2BC3836D, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_Artist_Album_Title_ButtonWidget2D_Up_enRelease", 0 },
        { 0x2CD3A7C2, "OnButtonReactionMsg_Media_Gadget_Media_MASTER__GADGET_MEDIA_HomescreenMediaTabIcon_ButtonWidget_enRelease", 0 },
        { 0x2D56E3BA, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBROUTER_Layer_TouchArea_Repeat_ButtonWidget2D_enRelease", 0 },
        { 0x2E338282, "OnPopup_Pfo_NoPlayableContentPopup_Close", 0 },
        { 0x30B2AA70, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_SD_ButtonWidget2D_List_enRelease", 0 },
        { 0x30C68BC4, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_BT_Layer_TouchArea_Next_ButtonWidget_enLongPress", 0 },
        { 0x30D0F271, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_IPOD_BT_ButtonWidget2D_Source_enRelease", 0 },
        { 0x315CE6A4, "OnEnableView_Media_MediaPlayerScenes_M_OPT_woRDS", 0 },
        { 0x31FDE017, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_Layer_USB_CameraPort_ButtonWidget_enRelease", 0 },
        { 0x3240BE5B, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_Genre_Title_ButtonWidget2D_Up_enRelease", 0 },
        { 0x338448AE, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoPlayer_FullScreen_Layer_Bg_Video_ButtonWidget_enRelease", 0 },
        { 0x344AEBC2, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_OPT_Layer_TrafficAnnouncement_ButtonWidget2D_enRelease", 0 },
        { 0x34C997FD, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_Genre_AllAlbums_ButtonWidget2D_Browse_enRelease", 0 },
        { 0x3598CF84, "onTopPopupSurfaceInvisible", GetEventArgumentsForonTopPopupSurfaceInvisible },
        { 0x37E7CAFB, "OnDeactivateApplicationMsg", 0 },
        { 0x386A16F4, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_SD_Layer_AppFlyIn_ButtonWidget2D_Navi_enRelease", 0 },
        { 0x39430FA5, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_BT_Layer_Progressbar_SliderWidget2D_enRelease", 0 },
        { 0x3944963D, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_USB_Layer_TouchArea_Previous_ButtonWidget_enAbortPress", 0 },
        { 0x3AC84C6F, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoPlayer_Layer_TouchArea_Next_ButtonWidget_enLongPressRelease", 0 },
        { 0x3AF692A4, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_BT_Layer_TouchArea_PlayPause_touched_ButtonWidget2D_enRelease", 0 },
        { 0x3C32C57E, "OnActivityMsg_eActivityID_MEDIA_AUX", 0 },
        { 0x3C71E22E, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_Album_External_Button_All_ButtonWidget_enRelease", 0 },
        { 0x3CB85614, "OnActicvateAlbumSceneMsg", 0 },
        { 0x3CE9391C, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_USB_Layer_AppFlyIn_ButtonWidget2D_Phone_enRelease", 0 },
        { 0x3CFF5A38, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBROUTER_Layer_TouchArea_Next_ButtonWidget_enLongPressRelease", 0 },
        { 0x3E31CB3F, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_Progressbar_SliderWidget2D_enRelease", 0 },
        { 0x3E4200A2, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoPlayer_Layer_TouchArea_Source_ButtonWidget_enRelease", 0 },
        { 0x3E63D0E7, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_USB_Layer_TouchArea_Previous_ButtonWidget_enLongPressRelease", 0 },
        { 0x3F08B10F, "OnActivateSourceSwitchToBT", 0 },
        { 0x3F7DA2E7, "OnButtonReactionMsg_Media_MediaPlayer_Pop_Up_Pfo_MediaConfirmBTPairing_Layer_No_ButtonWidget_enRelease", 0 },
        { 0x3FB14949, "OnButtonReactionMsg_Media_Gadget_Media_MASTER__GADGET_MEDIA_Btn_Previous_ButtonWidget_enRelease", 0 },
        { 0x3FFA3F8E, "OnButtonReactionMsg_Media_Gadget_Media_MASTER__GADGET_MEDIA_Btn_Next_ButtonWidget_enLongPressRelease", 0 },
        { 0x403A65A4, "OnDualViewLeftTransitionFinished", 0 },
        { 0x4093A801, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_woNAV_ButtonWidget2D_SDCard_enRelease", 0 },
        { 0x410812A4, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_AUX_Layer_AppFlyIn_ButtonWidget2D_Radio_enRelease", 0 },
        { 0x415A4C14, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_Podcast_Episode_ButtonWidget2D_Up_enRelease", 0 },
        { 0x4176710B, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoPlayer_Layer_AppFlyIn_ButtonWidget2D_MirrorLink_enRelease", 0 },
        { 0x437D9EFE, "OnPageFlipFrontFinished", 0 },
        { 0x4399B8F7, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_OPT_woRDS_tgBtn_Checkbox_ActivateexternalDVD_enRelease", 0 },
        { 0x43B133F0, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_SD_ButtonWidget2D_Repeat_enRelease", 0 },
        { 0x43F34D61, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_TouchArea_Repeat_ButtonWidget2D_enAbortPress", 0 },
        { 0x44667399, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_SD_ButtonWidget2D_Prev_enLongPress", 0 },
        { 0x461AFE8A, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_AppFlyIn_ButtonWidget2D_MirrorLink_enRelease", 0 },
        { 0x46B47DB5, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_TouchArea_Source_ButtonWidget_enRelease", 0 },
        { 0x47192B67, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_TouchArea_PlayPause_touched_ButtonWidget2D_enAbortPress", 0 },
        { 0x47714017, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_Album_Title_ButtonWidget2D_Up_enRelease", 0 },
        { 0x49216A70, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBCAMERAPORT_Layer_TouchArea_Next_ButtonWidget_enAbortPress", 0 },
        { 0x49B2C18F, "OnSwitchFullScreenVideo", 0 },
        { 0x49D85FE0, "OnUpdate_MediaActivityID", GetEventArgumentsForOnUpdate_MediaActivityID },
        { 0x4B001347, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoPlayer_Layer_TouchArea_Previous_ButtonWidget_enAbortPress", 0 },
        { 0x4BA43327, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_BT_Layer_AppFlyIn_ButtonWidget2D_MirrorLink_enRelease", 0 },
        { 0x4C1F4544, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoPlayer_Layer_TouchArea_Next_ButtonWidget_enRelease", 0 },
        { 0x4C8518AE, "onAppStatusPrepare_BACKGROUND", 0 },
        { 0x4CFD3B05, "OnActivityMsg_eActivityID_MEDIA_PLAY", 0 },
        { 0x4D820EE8, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_Album_External_PageUpButton_ButtonWidget2D_enRelease", 0 },
        { 0x4DEF4D2C, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_USB_Layer_AppFlyIn_ButtonWidget2D_Radio_enRelease", 0 },
        { 0x4E0FE823, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_Artist_ButtonWidget2D_Back_enRelease", 0 },
        { 0x4E4C386C, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBCAMERAPORT_Layer_TouchArea_Next_ButtonWidget_enRelease", 0 },
        { 0x4E8E41CD, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBCAMERAPORT_Layer_TouchArea_Previous_ButtonWidget_enAbortPress", 0 },
        { 0x4F2C93B2, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBROUTER_Layer_TouchArea_Previous_ButtonWidget_enLongPress", 0 },
        { 0x4F310548, "OnUpdateActiveDevicestatusMsg", 0 },
        { 0x508C833C, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_Artist_Album_ButtonWidget2D_AllTitles_enRelease", 0 },
        { 0x50B4DCCA, "OnDualViewRightTransitionFinished", 0 },
        { 0x51C11632, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_TouchArea_SourceInfoM_ButtonWidget_enRelease", 0 },
        { 0x520A915D, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_IPOD_BT_ButtonWidget2D_Prev_enLongPressRelease", 0 },
        { 0x5342E1BA, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBCAMERAPORT_Layer_Progressbar_SliderWidget2D_enRelease", 0 },
        { 0x54B11634, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_Layer_HDMI_CameraPort_ButtonWidget_enRelease", 0 },
        { 0x5527AC87, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_Audiobook_Chapter_ButtonWidget2D_Up_enRelease", 0 },
        { 0x553D82F6, "OnPageFlipBackFinishedBT_Src", 0 },
        { 0x5639F3C7, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_woNAV_ButtonWidget2D_BT_enRelease", 0 },
        { 0x5642715E, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_USB_Layer_TouchArea_PlayPause_touched_ButtonWidget2D_enRelease", 0 },
        { 0x567FD67A, "OnActivationResMsg_Media_MediaPlayer_Pop_Up_system_Pfo_MediaMessage_1", 0 },
        { 0x568EEF8A, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_Playlist_ButtonWidget2D_Back_enRelease", 0 },
        { 0x5790D8C1, "onSubSurfaceUpdMsgChanged_BACKGROUND", GetEventArgumentsForonSubSurfaceUpdMsgChanged_BACKGROUND },
        { 0x579F7D7A, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_Folder_File_ButtonWidget2D_Browse_enRelease", 0 },
        { 0x57A07100, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_BT_Layer_TouchArea_Next_ButtonWidget_enAbortPress", 0 },
        { 0x5A02A0DD, "OnPageFlipBackFinishedExtDVD_SrcWoNAV", 0 },
        { 0x5A7BE1FD, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_IPOD_BT_ButtonWidget2D_Next_enLongPress", 0 },
        { 0x5AC6AA89, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_Layer_USB_ButtonWidget_enRelease", 0 },
        { 0x5B6DB552, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_Playlist_Title_ButtonWidget2D_Up_enRelease", 0 },
        { 0x5B6E8694, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_TouchArea_Previous_ButtonWidget_enPress", 0 },
        { 0x5BB819F6, "OnActivateSourceSwitchToUSB", 0 },
        { 0x5BCD7C57, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_SD_ButtonWidget2D_Next_enLongPressRelease", 0 },
        { 0x5D330B82, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_IPOD_BT_ButtonWidget2D_Prev_enLongPress", 0 },
        { 0x5D69B6B3, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_USB_Layer_TouchArea_Next_ButtonWidget_enRelease", 0 },
        { 0x5F15DC39, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBCAMERAPORT_Layer_TouchArea_PlayPause_touched_ButtonWidget2D_enRelease", 0 },
        { 0x60B0C6A9, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_ExternalDVD_Layer_AppFlyIn_ButtonWidget2D_MirrorLink_enRelease", 0 },
        { 0x612D64CD, "OnActivateSourceSwitchToDVD", 0 },
        { 0x619A36E8, "OnButtonReactionMsg_Media_Gadget_Media_MASTER__GADGET_MEDIA_Btn_Next_ButtonWidget_enAbortPress", 0 },
        { 0x621FE4C1, "OnActivityMsg_eActivityID_MEDIA_USB", 0 },
        { 0x64268C5A, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_USB_Layer_Progressbar_SliderWidget2D_enRelease", 0 },
        { 0x642A343F, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBCAMERAPORT_Layer_TouchArea_Previous_ButtonWidget_enLongPress", 0 },
        { 0x64488146, "OnButtonReactionMsg_Media_Gadget_Media_MASTER__GADGET_MEDIA_Btn_Previous_ButtonWidget_enAbortPress", 0 },
        { 0x668E52B3, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_CAMPORTHDMI_2_Layer_TouchArea_Source_ButtonWidget_enRelease", 0 },
        { 0x66AEEED9, "OnActivateSourceSwitchToAUX", 0 },
        { 0x67204134, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoEpisode_ButtonWidget2D_Back_enRelease", 0 },
        { 0x67E5D82B, "onEncoderStatusChanged_RIGHT_ENC", GetEventArgumentsForonEncoderStatusChanged_RIGHT_ENC },
        { 0x69505C6C, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_IPOD_BT_ButtonWidget2D_Prev_enRelease", 0 },
        { 0x69E689C9, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoPlayer_Layer_TouchArea_Previous_ButtonWidget_enLongPress", 0 },
        { 0x6B874597, "OnActivityMsg_eActivityID_MEDIA_DVD", 0 },
        { 0x6CECBECF, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_USB_Layer_AppFlyIn_ButtonWidget2D_Navi_enRelease", 0 },
        { 0x6D1B3A68, "onAppStatusChanged_BACKGROUND", 0 },
        { 0x6FEA8791, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_Genre_Artist_Album_ButtonWidget2D_GenreArtAlbUp_enRelease", 0 },
        { 0x71C47D00, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_SD_ButtonWidget2D_Source_enRelease", 0 },
        { 0x71FA6B0E, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_SD_ButtonWidget2D_Shuffle_enRelease", 0 },
        { 0x72B647CA, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_Genre_Artist_ButtonWidget2D_AllAlbums_enRelease", 0 },
        { 0x73009A92, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_woNAV_ButtonWidget2D_ExternalDVD_enRelease", 0 },
        { 0x7361D54B, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_TouchArea_Shuffle_ButtonWidget2D_enAbortPress", 0 },
        { 0x7488CD73, "OnEnableandShowPopUp_SM_MEDIA_PID_APP_POPUPMEDIAMESSAGE", 0 },
        { 0x74F449E5, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_TouchArea_PlayPause_touched_ButtonWidget2D_enPress", 0 },
        { 0x74F534EE, "OnPageFlipBackFinished", 0 },
        { 0x755CE30A, "OnActivationResMsg_Media_MediaPlayer_Pop_Up_Pfo_MediaConfirmBTPairing_1", 0 },
        { 0x756C0DF3, "OnShutdownMsg", 0 },
        { 0x75EC7557, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBCAMERAPORT_Layer_TouchArea_Shuffle_ButtonWidget2D_enRelease", 0 },
        { 0x76CF2B88, "onHMISubStateChanged_ON", 0 },
        { 0x776D7D8A, "onHMISubStateChanged_OFF", 0 },
        { 0x7874AABE, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_AppFlyIn_ButtonWidget2D_Phone_enRelease", 0 },
        { 0x7A5FA526, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_Layer_Aux_ButtonWidget_enRelease", 0 },
        { 0x7AD778E9, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_ExternalDVD_ButtonWidget2D_ExtDVD_Back_enRelease", 0 },
        { 0x7B118B59, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_Video_ButtonWidget2D_Back_enRelease", 0 },
        { 0x7BDE9BF1, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_CAMPORTHDMI_1_Layer_TouchArea_Source_ButtonWidget_enRelease", 0 },
        { 0x7C0BAEEC, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_Genre_Artist_Album_ButtonWidget2D_Browse_enRelease", 0 },
        { 0x7CCA91E9, "OnVehicleSensorparkingbreakStatusMsg", 0 },
        { 0x7DD7D84C, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_USB_Layer_TouchArea_Next_ButtonWidget_enAbortPress", 0 },
        { 0x7E1514D3, "onActivatePopUp", GetEventArgumentsForonActivatePopUp },
        { 0x7EB65EF8, "OnPageFlipFrontFinishedSrcWoNAV_Aux", 0 },
        { 0x7ED713B5, "OnPageFlipFrontFinishedSrc_USB", 0 },
        { 0x8271C101, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_OPT_woRDS_ButtonWidget2D_SoundSettings_enRelease", 0 },
        { 0x82BC71AC, "OnButtonReactionMsg_Media_Gadget_Media_MASTER__GADGET_MEDIA_Btn_Previous_ButtonWidget_enPress", 0 },
        { 0x83CB8E78, "OnPageFlipBackFinishedUSB_Src", 0 },
        { 0x84E38AFC, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_IPOD_BT_Layer_AppFlyIn_ButtonWidget2D_MirrorLink_enRelease", 0 },
        { 0x852A3076, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_BT_Layer_TouchArea_Previous_ButtonWidget_enLongPress", 0 },
        { 0x85833641, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_IPOD_BT_ButtonWidget2D_Repeat_enRelease", 0 },
        { 0x85EF1917, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_Layer_TabRadio_ButtonWidget_enRelease", 0 },
        { 0x86C8DC2C, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_TouchArea_Shuffle_ButtonWidget2D_enPress", 0 },
        { 0x8704E204, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_BT_Layer_AppFlyIn_ButtonWidget2D_Radio_enRelease", 0 },
        { 0x870DE0D0, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_TouchArea_Previous_ButtonWidget_enLongPressRelease", 0 },
        { 0x8731478D, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_woNAV_ButtonWidget2D_USB_enRelease", 0 },
        { 0x89907345, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_woNAV_ButtonWidget2D_Aux_enRelease", 0 },
        { 0x89BE0089, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_Layer_AppleDevice_ButtonWidget_enRelease", 0 },
        { 0x89C05740, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_TouchArea_Shuffle_ButtonWidget2D_enRelease", 0 },
        { 0x89CD0B33, "OnExtDVDConnectionModeStatusMsg", 0 },
        { 0x8BC98A40, "onWaitAnimationStart", 0 },
        { 0x8C040EEB, "OnPageFlipFrontFinishedSrcWoNAV_ExtDVD", 0 },
        { 0x8C1F15A1, "OnBrowseListRespMsg", 0 },
        { 0x8C271FF9, "OnActivityMsg_eActivityID_MEDIA_SOURCE_SELECTION", 0 },
        { 0x8D50BBFB, "OnPageFlipFrontFinishedSrc_BT", 0 },
        { 0x8D99E8B8, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_Browse_ButtonWidget2D_Back_enRelease", 0 },
        { 0x8F5649E1, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_Layer_USB2_ButtonWidget_enRelease", 0 },
        { 0x8F8B72D2, "OnEnableandShowPopUp_SM_MEDIA_PID_APP_POPUPBTPHONEPAIRING", 0 },
        { 0x8FBD2A94, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_ExternalDVD_Layer_AppFlyIn_ButtonWidget2D_Phone_enRelease", 0 },
        { 0x906325CA, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBROUTER_Layer_TouchArea_PlayPause_touched_ButtonWidget2D_enRelease", 0 },
        { 0x912024BE, "onTopPopupSurfaceUnqueued", GetEventArgumentsForonTopPopupSurfaceUnqueued },
        { 0x91888118, "OnDisableView_Media_MediaPlayerScenes_M_OPT_woRDS", 0 },
        { 0x91A883CA, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_AppFlyIn_ButtonWidget2D_Navi_enRelease", 0 },
        { 0x922F93B7, "OnPageFlipFrontFinishedUSB_TitleList", 0 },
        { 0x93348F0E, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_Audiobook_ButtonWidget2D_Back_enRelease", 0 },
        { 0x943B225F, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBCAMERAPORT_Layer_TouchArea_Source_ButtonWidget_enRelease", 0 },
        { 0x955736EE, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_BT_Layer_AppFlyIn_ButtonWidget2D_Navi_enRelease", 0 },
        { 0x9650FEE3, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_Album_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0x9768B1CB, "OnActivityMsg_eActivityID_MEDIA_IPOD", 0 },
        { 0x977D9652, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_OPT_woRDS_tgBtn_Checkbox_ActivateAUX_enRelease", 0 },
        { 0x97D907D9, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_Album_PageUpButton_ButtonWidget2D_enRelease", 0 },
        { 0x984F8ED8, "onTopPopupSurfaceVisible", GetEventArgumentsForonTopPopupSurfaceVisible },
        { 0x985E3A53, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_Album_PageDownButton_ButtonWidget2D_enRelease", 0 },
        { 0x9A49AFF9, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_Podcast_Episode_ButtonWidget2D_Browse_enRelease", 0 },
        { 0x9AA88997, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoPlayer_FullScreen_Icon_Pause_Button_enRelease", 0 },
        { 0x9AFEF18F, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_SD_SliderWidget2D_Seek_enRelease", 0 },
        { 0x9B95DF4F, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_SD_Layer_AppFlyIn_ButtonWidget2D_Radio_enRelease", 0 },
        { 0x9BDB722F, "onCenterPopupSurfaceInvisible", GetEventArgumentsForonCenterPopupSurfaceInvisible },
        { 0x9C4C19AB, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_TouchArea_Previous_ButtonWidget_enAbortPress", 0 },
        { 0x9C9DB457, "OnActicvateVideorestrictionpopupmessage", 0 },
        { 0x9CBD8087, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_Podcast_ButtonWidget2D_Back_enRelease", 0 },
        { 0x9D4DF4FC, "onSubSurfaceUpdMsgChanged_FOREGROUND", GetEventArgumentsForonSubSurfaceUpdMsgChanged_FOREGROUND },
        { 0x9EE7031D, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_ExternalDVD_FullScreen_ButtonWidget2D_ExtDVDFullScreen_enRelease", 0 },
        { 0x9EF6B437, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_IPOD_BT_Layer_AppFlyIn_ButtonWidget2D_Phone_enRelease", 0 },
        { 0x9FE98C1E, "onDeactivateImageProviderRequest", GetEventArgumentsForonDeactivateImageProviderRequest },
        { 0xA0D66461, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBCAMERAPORT_Layer_TouchArea_Repeat_ButtonWidget2D_enRelease", 0 },
        { 0xA15C3CEE, "onHMISubStateChanged_STANDBY_RESTRICTED", 0 },
        { 0xA16E4912, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_AUX_Layer_TouchArea_Source_ButtonWidget_enRelease", 0 },
        { 0xA1FF8A3F, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_woNAV_ButtonWidget2D_Media_enRelease", 0 },
        { 0xA22BE2AB, "OnPlayAudioVideoSong", 0 },
        { 0xA2E0872F, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_USB_Layer_AppFlyIn_ButtonWidget2D_MirrorLink_enRelease", 0 },
        { 0xA3650C33, "OnOpen_WMA_DRM_Popup", 0 },
        { 0xA3944155, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_SD_ButtonWidget2D_Next_enRelease", 0 },
        { 0xA5EBD937, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_USB_Layer_TouchArea_Next_ButtonWidget_enLongPress", 0 },
        { 0xA7188CBC, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_TouchArea_Next_ButtonWidget_enPress", 0 },
        { 0xA8129B9B, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_USB_Layer_TouchArea_Shuffle_ButtonWidget2D_enRelease", 0 },
        { 0xA8722469, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_OPT_Layer_TouchArea_Source_ButtonWidget_enRelease", 0 },
        { 0xA8B007FA, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_Layer_BT_ButtonWidget_enRelease", 0 },
        { 0xA8BA919D, "OnActivationResMsg_Media_MediaPlayer_Pop_Up_Pfo_VideoDisableMessage_1", 0 },
        { 0xA9749321, "OnNewListEntryMsg", 0 },
        { 0xAA79C7DD, "onCenterPopupSurfaceUnqueued", GetEventArgumentsForonCenterPopupSurfaceUnqueued },
        { 0xAAF6DEAE, "OnButtonReactionMsg_Media_Gadget_Media_MASTER__GADGET_MEDIA_Btn_Next_ButtonWidget_enLongPress", 0 },
        { 0xAB7974EF, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoPlayer_Layer_TouchArea_SourceInfo_ButtonWidget_enRelease", 0 },
        { 0xAB89D7A8, "onHMISubStateChanged_SECURE", 0 },
        { 0xAC02F5E9, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBROUTER_Layer_TouchArea_Next_ButtonWidget_enLongPress", 0 },
        { 0xAC06B472, "OnVehicleSensorSpeedModestatusMsg", 0 },
        { 0xAC177B9E, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_SD_Layer_AppFlyIn_ButtonWidget2D_Phone_enRelease", 0 },
        { 0xAC914560, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_BT_TouchArea_SourceInfoM_ButtonWidget_enRelease", 0 },
        { 0xADFD0969, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_Audiobook_Chapter_ButtonWidget2D_Browse_enRelease", 0 },
        { 0xAECC11F2, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBCAMERAPORT_Layer_TouchArea_Next_ButtonWidget_enLongPressRelease", 0 },
        { 0xB19FAE70, "OnVideoSongSelectionMsg", 0 },
        { 0xB1B45BB5, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_Folder_ButtonWidget2D_Back_enRelease", 0 },
        { 0xB364073E, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoPlayer_Layer_Progressbar_SliderWidget2D_enRelease", 0 },
        { 0xB5A2CDBE, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_Layer_Settings_ButtonWidget_enRelease", 0 },
        { 0xB630DDBD, "onTopPopupSurfaceQueued", GetEventArgumentsForonTopPopupSurfaceQueued },
        { 0xB6678AA4, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBROUTER_Layer_TouchArea_Next_ButtonWidget_enAbortPress", 0 },
        { 0xB6F9EF98, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_IPOD_BT_Layer_AppFlyIn_ButtonWidget2D_Navi_enRelease", 0 },
        { 0xB70D4F28, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_Playlist_Title_ButtonWidget2D_Browse_enRelease", 0 },
        { 0xB78D7AE0, "onPopupVisible", GetEventArgumentsForonPopupVisible },
        { 0xB79A88C1, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_TouchArea_Previous_ButtonWidget_enRelease", 0 },
        { 0xB7ADAC96, "OnSourceSelectionStateResp_FI_EN_E8DTY_SrcSel_WONAV", 0 },
        { 0xB877E525, "OnButtonReactionMsg_Media_Gadget_Media_MASTER__GADGET_MEDIA_HomescreenMediaTabText_ButtonWidget_enRelease", 0 },
        { 0xB8AED9F9, "OnPageFlipFrontFinishedSrcWoNAV_BT", 0 },
        { 0xB8FEAFD9, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_BT_Layer_AppFlyIn_ButtonWidget2D_Phone_enRelease", 0 },
        { 0xBA9EFA80, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_AUX_ButtonWidget2D_Source_enRelease", 0 },
        { 0xBBE6896C, "onPopupQueued", GetEventArgumentsForonPopupQueued },
        { 0xBC04BFA6, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBROUTER_Layer_TouchArea_Previous_ButtonWidget_enLongPressRelease", 0 },
        { 0xBC156E11, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_IPOD_BT_ButtonWidget2D_List_enRelease", 0 },
        { 0xBC56A0D9, "OnActivateSwitchToSourceSel", 0 },
        { 0xBC92553E, "OnButtonReactionMsg_Media_Gadget_Media_MASTER__GADGET_MEDIA_Btn_Previous_ButtonWidget_enLongPress", 0 },
        { 0xBCEA84D4, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBCAMERAPORT_Layer_TouchArea_Previous_ButtonWidget_enRelease", 0 },
        { 0xBE68F9CC, "OnVehicleSensorExtDVDparkingbreakStatusMsg", 0 },
        { 0xC045E1AD, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_Title_ButtonWidget2D_Back_enRelease", 0 },
        { 0xC0979B0B, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_IPOD_BT_ButtonWidget2D_Next_enRelease", 0 },
        { 0xC0C2534D, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_Album_External_PageDownButton_ButtonWidget2D_enRelease", 0 },
        { 0xC19ED54A, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_IPOD_BT_SliderWidget2D_Seek_enRelease", 0 },
        { 0xC205FC69, "onExternalMediaListItemPress", GetEventArgumentsForonExternalMediaListItemPress },
        { 0xC266640E, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_AUX_Layer_AppFlyIn_ButtonWidget2D_Phone_enRelease", 0 },
        { 0xC27AC9B9, "OnClose_WMA_DRM_Popup", 0 },
        { 0xC3305219, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_BT_Layer_TouchArea_Previous_ButtonWidget_enRelease", 0 },
        { 0xC3A2D02F, "OnButtonReactionMsg_Media_Gadget_Media_MASTER__GADGET_MEDIA_Btn_Next_ButtonWidget_enRelease", 0 },
        { 0xC4D07F17, "OnDisableView_Media_MediaPlayerScenes_M_OPT", 0 },
        { 0xC5002AFD, "OnPageFlipFrontFinishedSrcWoNAV_USB", 0 },
        { 0xC5DA527D, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBROUTER_Layer_TouchArea_Previous_ButtonWidget_enRelease", 0 },
        { 0xC63A7303, "OnMediaMessagepopupRelease", 0 },
        { 0xC70281BB, "OnActivateApplicationMsg", 0 },
        { 0xC7366C6B, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_IPOD_BT_Layer_AppFlyIn_ButtonWidget2D_Radio_enRelease", 0 },
        { 0xC801484C, "OnActivityMsg_eActivityID_MEDIA_BTSTREAMING", 0 },
        { 0xC8C9C829, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoEpisode_ButtonWidget2D_Up_enRelease", 0 },
        { 0xC8D83B8B, "onHMISubStateChanged_PHONE", 0 },
        { 0xC8D96BB1, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBCAMERAPORT_Layer_TouchArea_Previous_ButtonWidget_enLongPressRelease", 0 },
        { 0xC9492AE9, "OnPageFlipFrontFinishedSrc_ExtDVD", 0 },
        { 0xCA5D0252, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_BT_Layer_TouchArea_Next_ButtonWidget_enLongPressRelease", 0 },
        { 0xCA7255C0, "OnButtonReactionMsg_Media_MediaPlayer_Pop_Up_Pfo_MediaConfirmBTPairing_Layer_Yes_ButtonWidget_enRelease", 0 },
        { 0xCAFD7978, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_USB_TouchArea_SourceInfoM_ButtonWidget_enRelease", 0 },
        { 0xCB239938, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_BT_Layer_TouchArea_Shuffle_ButtonWidget2D_enRelease", 0 },
        { 0xCCA2A0F0, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_BT_Layer_TouchArea_Next_ButtonWidget_enRelease", 0 },
        { 0xCDB4DE26, "OnPageFlipBackFinishedBT_SrcWoNAV", 0 },
        { 0xCFF2BD86, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBCAMERAPORT_TouchArea_SourceInfoM_ButtonWidget_enRelease", 0 },
        { 0xD00E34DA, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_Genre_Artist_ButtonWidget2D_Up_enRelease", 0 },
        { 0xD0F6494A, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoPlayer_Layer_TouchArea_Next_ButtonWidget_enAbortPress", 0 },
        { 0xD30BCACE, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_ExternalDVD_Layer_AppFlyIn_ButtonWidget2D_Radio_enRelease", 0 },
        { 0xD58DC6F5, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_USB_Layer_TouchArea_Repeat_ButtonWidget2D_enRelease", 0 },
        { 0xD60C65DC, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_SD_ButtonWidget2D_Play_enRelease", 0 },
        { 0xD60E4F86, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_SD_ButtonWidget2D_Next_enLongPress", 0 },
        { 0xD6FF523D, "OnButtonReactionMsg_Media_Gadget_Media_MASTER__GADGET_MEDIA_Background_Button_ButtonWidget_enRelease", 0 },
        { 0xD785E8EC, "OnVehicleSensorExtDVDSpeedModestatusMsg", 0 },
        { 0xD81BA747, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_BT_Layer_TouchArea_Source_ButtonWidget_enRelease", 0 },
        { 0xD82BC9AE, "OnButtonReactionMsg_Media_Gadget_Media_MASTER__GADGET_MEDIA_Btn_Play_Pause_ButtonWidget2D_enAbortPress", 0 },
        { 0xD9419E1D, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_IPOD_BT_ButtonWidget2D_Shuffle_enRelease", 0 },
        { 0xDA21E229, "OnOpen_Settings_Screen", 0 },
        { 0xDA5E5899, "OnActivationResMsg_Media_MediaPlayer_Pop_Up_Pfo_WMA_DRM_ProtectedFileMessage_1", 0 },
        { 0xDAC45BFD, "OnActiveMediaSource_Appflyinn_Msg", 0 },
        { 0xDB0D29F4, "onPopupUnqueued", GetEventArgumentsForonPopupUnqueued },
        { 0xDCCA5F91, "OnPopup_Pfo_VideoDisableMessage_Close", 0 },
        { 0xDD31831E, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBROUTER_Layer_TouchArea_Source_ButtonWidget_enRelease", 0 },
        { 0xDD62EA5B, "onActivateImageProviderRequest", GetEventArgumentsForonActivateImageProviderRequest },
        { 0xDE90752B, "OnActivityMsg_eActivityID_MEDIA_SOURCE_SWITCH", 0 },
        { 0xDE9448E3, "onAppStatusChanged_FOREGROUND", 0 },
        { 0xE27E6143, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_Genre_Artist_ButtonWidget2D_Browse_enRelease", 0 },
        { 0xE4658CFD, "onHMISubStateChanged_NO_DISPLAY", 0 },
        { 0xE61DEB5E, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoPlayer_Layer_TouchArea_Previous_ButtonWidget_enRelease", 0 },
        { 0xE69C7F1E, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_VideoPlayer_Layer_TouchArea_PlayPause_touched_ButtonWidget2D_enRelease", 0 },
        { 0xE6DA3619, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_ButtonWidget2D_Back_enRelease", 0 },
        { 0xE7228EE2, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_SD_ButtonWidget2D_Prev_enRelease", 0 },
        { 0xE7DCE080, "OnNextLevelTransitionFinished", 0 },
        { 0xE8F19318, "OnPageFlipBackFinishedTitleList_USB", 0 },
        { 0xE9A647F4, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_Genre_Artist_Album_ButtonWidget2D_GenreArtAlbAllTitles_enRelease", 0 },
        { 0xE9A6D56C, "OnFadeAnimationFinished", 0 },
        { 0xEA6686A1, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_SourceSelection_Media_ButtonWidget2D_Media_enRelease", 0 },
        { 0xEB2766EF, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_USB_Layer_TouchArea_Previous_ButtonWidget_enRelease", 0 },
        { 0xEB5BC2C4, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_TouchArea_Repeat_ButtonWidget2D_enPress", 0 },
        { 0xEB88273C, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_Artist_Album_ButtonWidget2D_Up_enRelease", 0 },
        { 0xEDC979E2, "OnPageFlipBackFinishedUSB_SrcWoNAV", 0 },
        { 0xEEA520DB, "OnOpen_SourceSelection_Screen", 0 },
        { 0xF1A4C0E5, "OnActivityMsg_eActivityID_MEDIA_SETTINGS_VIEW", 0 },
        { 0xF3C96D17, "onPopupTimerExpiry", GetEventArgumentsForonPopupTimerExpiry },
        { 0xF4148746, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_ExternalDVD_ButtonWidget2D_ExternalDVD_enRelease", 0 },
        { 0xF72B9F0E, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_USB_Layer_TouchArea_Previous_ButtonWidget_enLongPress", 0 },
        { 0xF74580D3, "OnPageFlipBackFinishedExtDVD_Src", 0 },
        { 0xF84B3BD1, "OnZoomOutFinished", 0 },
        { 0xF8F1AE5F, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_TouchArea_Next_ButtonWidget_enAbortPress", 0 },
        { 0xF96478DC, "onHMISubStateChanged_CLOCK", 0 },
        { 0xFA689B3C, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_AUX_Layer_AppFlyIn_ButtonWidget2D_MirrorLink_enRelease", 0 },
        { 0xFAF250CA, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_Genre_Title_ButtonWidget2D_Browse_enRelease", 0 },
        { 0xFB598A70, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_USBROUTER_Layer_Progressbar_SliderWidget2D_enRelease", 0 },
        { 0xFB82263D, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_IPOD_BT_ButtonWidget2D_Play_enRelease", 0 },
        { 0xFBEEA58F, "OnZoomInFinished", 0 },
        { 0xFC0D2293, "onCenterPopupSurfaceQueued", GetEventArgumentsForonCenterPopupSurfaceQueued },
        { 0xFC60099E, "onDeActivatePopUp", GetEventArgumentsForonDeActivatePopUp },
        { 0xFE306FE8, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_AppleDevice_Layer_TouchArea_Next_ButtonWidget_enLongPressRelease", 0 },
        { 0xFF1F340C, "OnButtonReactionMsg_Media_MediaPlayerScenes_M_IPOD_BT_ButtonWidget2D_Next_enLongPressRelease", 0 },
        { 0xFF6CB401, "OnButtonReactionMsg_Media_Gadget_Media_MASTER__GADGET_MEDIA_Btn_Previous_ButtonWidget_enLongPressRelease", 0 },
    };
    const EventNameMapping* eventEntry = ::Courier::BinarySearch(eventId, events, 374, &EventNameMappingCmp);
    if (eventEntry && (eventId == eventEntry->mEventId)) {
        if (0 != eventEntry->mGetEventArguments) {
            eventEntry->mGetEventArguments(message, eventArguments);
        }
        return eventEntry->mEventName;
    }
    return 0;
}
#endif
// ------------------------------------------------------------------------
struct IdToNameMapping
{
    ::FeatStd::UInt32 mId;
    const ::FeatStd::Char* mName;
};

static ::FeatStd::Int IdToNameMappingCmp(::FeatStd::UInt32 id, const IdToNameMapping& nm)
{
    return (id == nm.mId) ? 0 : ((id < nm.mId) ? -1 : 1);
}

const ::FeatStd::Char * AppHmi_MediaStateMachineImpl::GetNameFromId(::FeatStd::UInt32 id)
{
    static IdToNameMapping names[57] = {
        { 0x05C575B5, "Media#MediaPlayerScenes#M_USBROUTER" },
        { 0x07B3C6DD, "Media#MediaPlayerScenes#M_Genre_AllAlbums" },
        { 0x08969EA3, "Media#MediaPlayerScenes#M_CAMPORTHDMI_3" },
        { 0x0C2D098D, "Media#MediaPlayerScenes#M_VideoPlayer" },
        { 0x19B44422, "Media#MediaPlayerScenes#M_IPOD_BT" },
        { 0x1C2D4324, "Media#MediaPlayerScenes#M_AUX" },
        { 0x1DF488B1, "Media#MediaPlayerScenes#M_VideoPlayer_FullScreen" },
        { 0x1EC22893, "Media#MediaPlayer_Pop_Up#Pfo_NoPlayableContentPopup" },
        { 0x2078CFCF, "Media#MediaPlayerScenes#M_Artist_Album" },
        { 0x21EE60F9, "Media#MediaPlayerScenes#M_SD" },
        { 0x267EAAAB, "Media#MediaPlayer_Pop_Up_system#Pfo_MediaUnsupportedPopupMessageHUB" },
        { 0x273FC14D, "Media#MediaPlayerScenes#M_ExternalDVD" },
        { 0x2844EC3A, "Media#MediaPlayerScenes#M_BT" },
        { 0x3135B372, "Media#MediaPlayer_Pop_Up_system#Pfo_MediaUnsupportedPopupMessage" },
        { 0x381D00FE, "Media#MediaPlayerScenes#M_AppleDevice" },
        { 0x3B3C59BC, "Media#MediaPlayer_Pop_Up#Pfo_MediaBTStreamingUnavailable" },
        { 0x412F962A, "Media#MediaPlayerScenes#M_Playlist_Title" },
        { 0x4158AF33, "Media#MediaPlayer_Pop_Up#Pfo_MediaConfirmBTPairing" },
        { 0x43F94B9C, "Media#MediaPlayerScenes#M_Folder" },
        { 0x470E3B99, "Media#MediaPlayerScenes#M_Podcast_Episode" },
        { 0x47B934BD, "Media#MediaPlayer_Pop_Up_system#Pfo_MediaDB_Download_Failure" },
        { 0x581900CB, "Media#MediaPlayer_Pop_Up#Pfo_WaitScene" },
        { 0x5A6B7166, "Media#MediaPlayerScenes#M_Album_External" },
        { 0x5DCF5C3B, "Media#MediaPlayerScenes#M_Audiobook_Chapter" },
        { 0x61AFF014, "Media#MediaPlayer_Pop_Up#Pfo_WMA_DRM_ProtectedFileMessage" },
        { 0x63EF3BAB, "Media#MediaPlayerScenes#M_Playlist" },
        { 0x64CD2DE0, "Media#MediaPlayerScenes#M_Genre_Title" },
        { 0x662AAB30, "Media#MediaPlayer_Pop_Up#Pfo_MediaGlassUnavailableMessage" },
        { 0x6BBD5EB3, "Media#MediaPlayer_Pop_Up#Pfo_MediaDB_Download_Error" },
        { 0x6E86C285, "Media#MediaPlayerScenes#M_OPT_woRDS" },
        { 0x719F7017, "Media#MediaPlayerScenes#M_Genre_Artist_Album" },
        { 0x7236E4BD, "Media#MediaPlayerScenes#M_Folder_File" },
        { 0x7666DC10, "Media#MediaPlayerScenes#M_Album" },
        { 0x77BDC1A1, "Media#MediaPlayerScenes#M_USBCAMERAPORT" },
        { 0x7855AB88, "Media#MediaPlayer_Pop_Up_system#Pfo_MediaDB_Download_Successful" },
        { 0x79DEBF67, "Media#MediaPlayerScenes#M_VideoEpisode" },
        { 0x7F3F00E9, "Media#MediaPlayerScenes#M_USB" },
        { 0x896A823F, "Media#MediaPlayer_Pop_Up#Sys_Popup" },
        { 0x8AFF26C2, "Media#MediaPlayer_Pop_Up_system#Pfo_MediaMessage" },
        { 0x93ECCD67, "Media#MediaPlayerScenes#M_Video" },
        { 0xA4E960A5, "Media#MediaPlayerScenes#M_Title" },
        { 0xA78D2842, "Media#Gadget_Media#MASTER__GADGET_MEDIA" },
        { 0xAF9EF6AE, "Media#MediaPlayerScenes#M_Album_Title" },
        { 0xB0AB5D8E, "Media#MediaPlayerScenes#M_Artist_Album_Title" },
        { 0xB7CF4AB4, "Media#MediaPlayerScenes#M_Genre_Artist" },
        { 0xBDD9A89A, "Media#MediaPlayerScenes#M_Artist" },
        { 0xCF9498EB, "Media#MediaPlayer_Pop_Up#Pfo_VideoDisableMessage" },
        { 0xCFC57924, "Media#MediaPlayerScenes#M_ExternalDVD_FullScreen" },
        { 0xD4761C8C, "Media#MediaPlayerScenes#M_SourceSelection_Media_woNAV" },
        { 0xDA10B332, "Media#MediaPlayerScenes#M_Genre" },
        { 0xDC1BC5AA, "Media#MediaPlayerScenes#M_CAMPORTHDMI_1" },
        { 0xE13CE0CF, "Media#MediaPlayerScenes#M_OPT" },
        { 0xE61B2A28, "Media#MediaPlayer_Pop_Up#Pfo_SignalRangeError" },
        { 0xE98574FE, "Media#MediaPlayerScenes#M_Podcast" },
        { 0xF0B0EED4, "Media#MediaPlayerScenes#M_CAMPORTHDMI_2" },
        { 0xF797D37A, "Media#MediaPlayerScenes#M_Audiobook" },
        { 0xF84F9FD5, "Media#MediaPlayerScenes#M_SourceSelection_Media" },
    };
    const IdToNameMapping *nameEntry = ::Courier::BinarySearch(id, names, 57, &IdToNameMappingCmp);
    if(nameEntry != 0 && id == nameEntry->mId) {
        return nameEntry->mName;
    }
    return "";
}

// ------------------------------------------------------------------------

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::Perform_MediaTabGadget()
{
    Action_Perform_MediaTabGadget();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::Perform_MediaToggle()
{
    Action_Perform_MediaToggle();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::Perform_USBCameraPortInvisibility()
{
    Action_Perform_USBCameraPortInvisibility();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::Notify_Init_Finished()
{
    Action_Notify_Init_Finished();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::acPerform_UsbElapsedTimeSeekBackMsg(::FeatStd::UInt32 aSeekValue)
{
    Action_acPerform_UsbElapsedTimeSeekBackMsg(Courier::UInt32(aSeekValue));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::OptionSelStateRespMsg()
{
    Action_OptionSelStateRespMsg();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::Activate_Suz_TunerNowPlaying()
{
    Action_Activate_Suz_TunerNowPlaying();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::Activate_ButtonMainSrcActivate()
{
    Action_Activate_ButtonMainSrcActivate();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::Activate_Suz_PreviousApplication()
{
    Action_Activate_Suz_PreviousApplication();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::Activate_Suz_NaviApplication()
{
    Action_Activate_Suz_NaviApplication();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::Activate_Suz_MirrorLinkApplication()
{
    Action_Activate_Suz_MirrorLinkApplication();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::Activate_Suz_SoundSettingsApplication()
{
    Action_Activate_Suz_SoundSettingsApplication();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::Activate_LayerSoundSettingsMsg()
{
    Action_Activate_LayerSoundSettingsMsg();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::Perform_Activate_Home_Source()
{
    Action_Perform_Activate_Home_Source();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::Activate_Suz_BTPhoneApplication()
{
    Action_Activate_Suz_BTPhoneApplication();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::Activate_Suz_TunerApplication()
{
    Action_Activate_Suz_TunerApplication();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::Perform_MediaModule_USB2()
{
    Action_Perform_MediaModule_USB2();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::Perform_MediaModule_USB1()
{
    Action_Perform_MediaModule_USB1();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::Perform_MediaModule_USB()
{
    Action_Perform_MediaModule_USB();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::Perform_MediaModule_IPOD()
{
    Action_Perform_MediaModule_IPOD();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::Perform_MediaModule_SD()
{
    Action_Perform_MediaModule_SD();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::Perform_MediaModule_BLUETOOTH()
{
    Action_Perform_MediaModule_BLUETOOTH();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::Perform_MediaModule_CAMERAPORTUSB()
{
    Action_Perform_MediaModule_CAMERAPORTUSB();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::Perform_MediaModule_CAMERAPORTHDMI()
{
    Action_Perform_MediaModule_CAMERAPORTHDMI();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::Perform_MediaModule_ROUTERUSB()
{
    Action_Perform_MediaModule_ROUTERUSB();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::Perform_MediaModule_AUX()
{
    Action_Perform_MediaModule_AUX();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::Perform_MediaSceneMsg(::FeatStd::UInt16 aMediaType)
{
    Action_Perform_MediaSceneMsg(Courier::UInt16(aMediaType));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::MediaOperation(::FeatStd::UInt16 aOperationType)
{
    Action_MediaOperation(Courier::UInt16(aOperationType));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::MediaBTOperation(::FeatStd::UInt16 aOperationType)
{
    Action_MediaBTOperation(Courier::UInt16(aOperationType));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::ActivateAUXApp(::FeatStd::UInt8 aCheckboxStatus)
{
    Action_ActivateAUXApp(Candera::UInt8(aCheckboxStatus));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::ActivateSDCard(::FeatStd::UInt8 aCheckboxStatus)
{
    Action_ActivateSDCard(Candera::UInt8(aCheckboxStatus));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::ActivateExternalDVD(::FeatStd::UInt8 aCheckboxStatus)
{
    Action_ActivateExternalDVD(Candera::UInt8(aCheckboxStatus));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::ActivateTAApp(::FeatStd::UInt8 aCheckboxStatus)
{
    Action_ActivateTAApp(Candera::UInt8(aCheckboxStatus));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::acPerform_AppleHIDCommandMsg(::FeatStd::UInt8 aHIDCommand, ::FeatStd::UInt8 aKeyEvent)
{
    Action_acPerform_AppleHIDCommandMsg(Courier::UInt8(aHIDCommand), Courier::UInt8(aKeyEvent));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::HorListTabButtonItem(::FeatStd::UInt32 aSelectMediaTab)
{
    Action_HorListTabButtonItem(Courier::UInt8(aSelectMediaTab));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::BTBrowseButtonPressed()
{
    Action_BTBrowseButtonPressed();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::VideoBrowseButtonPressed()
{
    Action_VideoBrowseButtonPressed();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::BrowseButtonPressed()
{
    Action_BrowseButtonPressed();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::HorTabListBtnPageUp()
{
    Action_HorTabListBtnPageUp();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::HorTabListBtnPageDown()
{
    Action_HorTabListBtnPageDown();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::ExternalMediaTabBtnPressUpd(::FeatStd::UInt32 aSelectMediaTab)
{
    Action_ExternalMediaTabBtnPressUpd(Courier::UInt8(aSelectMediaTab));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::ExternalBrowseScreenExitUpd(::FeatStd::UInt32 aListId)
{
    Action_ExternalBrowseScreenExitUpd(Courier::UInt32(aListId));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::ExternalMediaTabListPageUp()
{
    Action_ExternalMediaTabListPageUp();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::ExternalMediaTabListPageDown()
{
    Action_ExternalMediaTabListPageDown();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::ExternalMediaBackButtonPressUpd()
{
    Action_ExternalMediaBackButtonPressUpd();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::ExternalMediaAllButtonPressUpd()
{
    Action_ExternalMediaAllButtonPressUpd();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::ExternalMediaListItemPressUpd(::FeatStd::UInt32 aHdl, ::FeatStd::UInt32 aSubHdl)
{
    Action_ExternalMediaListItemPressUpd(Courier::UInt32(aHdl), Courier::UInt32(aSubHdl));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::RequestPlayBackActionSeek()
{
    Action_RequestPlayBackActionSeek();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::RequestBTPlayBackActionSeek()
{
    Action_RequestBTPlayBackActionSeek();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::RequestNextBrowseTabs()
{
    Action_RequestNextBrowseTabs();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::RequestPreviousBrowseTabs()
{
    Action_RequestPreviousBrowseTabs();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::RequestBrowseList(::FeatStd::UInt8 aG_SM_ListType)
{
    Action_RequestBrowseList(Courier::UInt8(aG_SM_ListType));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::RequestParentFolderItems()
{
    Action_RequestParentFolderItems();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::RequestClearFolderListData()
{
    Action_RequestClearFolderListData();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::RequestAudioAllocationForMode(::FeatStd::UInt8 aDeviceType)
{
    Action_RequestAudioAllocationForMode(tenDeviceType(aDeviceType));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::Perform_FastRewindStart_Popup()
{
    Action_Perform_FastRewindStart_Popup();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::Perform_FastForwardStart_Popup()
{
    Action_Perform_FastForwardStart_Popup();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::Perform_BTDeviceNameUpdateStatusMsg()
{
    Action_Perform_BTDeviceNameUpdateStatusMsg();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::BrowseListActive(::FeatStd::UInt8 aIsActive)
{
    Action_BrowseListActive(bool(aIsActive));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::Perform_VideoOnSpeedRequestMsg()
{
    Action_Perform_VideoOnSpeedRequestMsg();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::Perform_VideoOnParkingBreakRequestMsg()
{
    Action_Perform_VideoOnParkingBreakRequestMsg();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::Perform_VideoOnEXTDVDSpeedRequestMsg()
{
    Action_Perform_VideoOnEXTDVDSpeedRequestMsg();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::Perform_VideoOnEXTDVDParkingBreakRequestMsg()
{
    Action_Perform_VideoOnEXTDVDParkingBreakRequestMsg();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::StartVideoStreaming()
{
    Action_StartVideoStreaming();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::StartFolderViewEntryRespMsg()
{
    Action_StartFolderViewEntryRespMsg();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::StopFolderViewExitRespMsg()
{
    Action_StopFolderViewExitRespMsg();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::StartVideoViewEntryRespMsg()
{
    Action_StartVideoViewEntryRespMsg();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::StopVideoViewExitRespMsg()
{
    Action_StopVideoViewExitRespMsg();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::StartSDCardViewEntryRespMsg()
{
    Action_StartSDCardViewEntryRespMsg();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::StopSDCardViewExitRespMsg()
{
    Action_StopSDCardViewExitRespMsg();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::StartUSBViewEntryRespMsg()
{
    Action_StartUSBViewEntryRespMsg();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::StopUSBViewExitRespMsg()
{
    Action_StopUSBViewExitRespMsg();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::StopVideoStreaming()
{
    Action_StopVideoStreaming();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::Perform_FastRewindStop_Popup()
{
    Action_Perform_FastRewindStop_Popup();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::Perform_FastForwardStop_Popup()
{
    Action_Perform_FastForwardStop_Popup();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::Perform_MediaMessage_Popup()
{
    Action_Perform_MediaMessage_Popup();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::VideoOnsongRequest()
{
    Action_VideoOnsongRequest();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::Perform_Video_Timer_Start()
{
    Action_Perform_Video_Timer_Start();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::Perform_Video_Timer_Stop()
{
    Action_Perform_Video_Timer_Stop();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::VideoDisconnectOnSongRequest()
{
    Action_VideoDisconnectOnSongRequest();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::ExternaldvdVideoConnectRequest()
{
    Action_ExternaldvdVideoConnectRequest();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::ExternalDVDDevicenameRequest()
{
    Action_ExternalDVDDevicenameRequest();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::ExternalAuxDevicenameRequest()
{
    Action_ExternalAuxDevicenameRequest();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::ExternaldvdVideodisconnectRequest()
{
    Action_ExternaldvdVideodisconnectRequest();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::NowplayingAlbumartViewRequest()
{
    Action_NowplayingAlbumartViewRequest();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::acPerform_UpdateCurrentMediaState(::FeatStd::UInt8 aCurrentState)
{
    Action_acPerform_UpdateCurrentMediaState(Courier::UInt8(aCurrentState));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::acPerform_MediaSettingBackBtnPress()
{
    Action_acPerform_MediaSettingBackBtnPress();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacChangeLanguageReq(::FeatStd::Int32 aLanguageId)
{
    Action_gacChangeLanguageReq(enLanguageId(aLanguageId));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacHideFocusInViewReq(::FeatStd::UInt32 aView)
{
    Action_gacHideFocusInViewReq(::Courier::ViewId(AppHmi_MediaStateMachineImpl::GetNameFromId(aView)));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::NextLevelTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_NextLevelTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::PreviousLevelTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_PreviousLevelTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::DualViewLeftTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_DualViewLeftTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::DualViewRightTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_DualViewRightTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::PageFlipBackTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_PageFlipBackTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::PageFlipFrontTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_PageFlipFrontTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::ZoomInTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView, ::FeatStd::Int8 aPos)
{
    Action_ZoomInTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView), Candera::UInt8(aPos));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::ZoomOutTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView, ::FeatStd::Int8 aPos)
{
    Action_ZoomOutTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView), Candera::UInt8(aPos));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::FadeTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_FadeTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacWaitAnimationStartReq()
{
    Action_gacWaitAnimationStartReq();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::acFocusOnRightEncoderReqUpd(bool aIsFocusUsed)
{
    Action_acFocusOnRightEncoderReqUpd(bool(aIsFocusUsed));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::acSetGadgetSceenActiveStatus(bool aIsGadgetAtive)
{
    Action_acSetGadgetSceenActiveStatus(bool(aIsGadgetAtive));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::acHKNotificationMsg(::FeatStd::Int8 aHKCode, ::FeatStd::Int8 aHKState)
{
    Action_acHKNotificationMsg(Courier::UInt8(aHKCode), Courier::UInt8(aHKState));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::acPerform_CloseAllDropdowns()
{
    Action_acPerform_CloseAllDropdowns();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::acPerform_CloseDropdown(::FeatStd::UInt32 aListId)
{
    Action_acPerform_CloseDropdown(::Courier::UInt32(aListId));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::acPerform_OpenDropdown(::FeatStd::UInt32 aListId)
{
    Action_acPerform_OpenDropdown(::Courier::UInt32(aListId));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::acPerform_ToggleDropdown(::FeatStd::UInt32 aListId)
{
    Action_acPerform_ToggleDropdown(::Courier::UInt32(aListId));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::acStartAppPopupTimer(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aTimeout)
{
    Action_acStartAppPopupTimer(Courier::UInt32(aViewId), Courier::UInt32(aTimeout));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::acStopAppPopupTimer(::FeatStd::UInt32 aViewId)
{
    Action_acStopAppPopupTimer(Courier::UInt32(aViewId));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::acPostBeep(::FeatStd::Int8 aBeepType)
{
    Action_acPostBeep(Courier::Int32(aBeepType));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacCheckToClosePopup(::FeatStd::UInt32 aPopupId)
{
    Action_gacCheckToClosePopup(Courier::UInt32(aPopupId));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::acRestartAppPopupTimer(::FeatStd::UInt32 aViewId)
{
    Action_acRestartAppPopupTimer(Courier::UInt32(aViewId));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacContextSwitchBackRes(::FeatStd::UInt32 aSwitchId)
{
    Action_gacContextSwitchBackRes(Courier::UInt32(aSwitchId));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacContextSwitchCompleteRes(::FeatStd::UInt32 aSwitchId)
{
    Action_gacContextSwitchCompleteRes(Courier::UInt32(aSwitchId));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacContextSwitchFailedRes(::FeatStd::UInt32 aSwitchId)
{
    Action_gacContextSwitchFailedRes(Courier::UInt32(aSwitchId));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacContextSwitchDoneRes(::FeatStd::UInt32 aSwitchId)
{
    Action_gacContextSwitchDoneRes(Courier::UInt32(aSwitchId));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacContextSwitchOutReq(::FeatStd::UInt32 aTargetContextId, ::FeatStd::UInt32 aSourceContextId, ::FeatStd::UInt32 aTargetAppId)
{
    Action_gacContextSwitchOutReq(Courier::UInt32(aTargetContextId), Courier::UInt32(aSourceContextId), Courier::UInt32(aTargetAppId));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacCurrentScreenDisplayReq()
{
    Action_gacCurrentScreenDisplayReq();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacLaunchBarDisplayReq(bool aVisibility)
{
    Action_gacLaunchBarDisplayReq(bool(aVisibility));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacNavTBTSwipe()
{
    Action_gacNavTBTSwipe();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacPerformListBtnRightEncoderChangeUpd(::FeatStd::Int8 aSteps, ::FeatStd::UInt32 aListId, ::FeatStd::UInt32 aRowId, ::FeatStd::UInt32 aColumnId)
{
    Action_gacPerformListBtnRightEncoderChangeUpd(Courier::Int8(aSteps), Courier::UInt32(aListId), Courier::UInt32(aRowId), Courier::UInt32(aColumnId));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacScrollListUp()
{
    Action_gacScrollListUp();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacScrollListDown()
{
    Action_gacScrollListDown();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacScrollPageUp()
{
    Action_gacScrollPageUp();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacScrollPageDown()
{
    Action_gacScrollPageDown();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacScrollListFocusUp(::FeatStd::UInt32 aListId)
{
    Action_gacScrollListFocusUp(Courier::UInt32(aListId));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacScrollListFocusDown(::FeatStd::UInt32 aListId)
{
    Action_gacScrollListFocusDown(Courier::UInt32(aListId));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacPerformListFocusLockDataResetUpd()
{
    Action_gacPerformListFocusLockDataResetUpd();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacSetApplicationMode(::FeatStd::UInt32 aModeId)
{
    Action_gacSetApplicationMode(Courier::UInt32(aModeId));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacSpellerBbehaviorReq(bool aEnable)
{
    Action_gacSpellerBbehaviorReq(bool(aEnable));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacStatusBarDisplayReq(bool aVisibility, ::FeatStd::Int32 aHeaderType)
{
    Action_gacStatusBarDisplayReq(bool(aVisibility), Courier::Int32(aHeaderType));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacTBTRetriggerAcousticOutput()
{
    Action_gacTBTRetriggerAcousticOutput();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacWaitAnimationStopReq()
{
    Action_gacWaitAnimationStopReq();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacViewCreateReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewCreateReq(::Courier::ViewId(AppHmi_MediaStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacViewCreateAllReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewCreateAllReq(::Courier::ViewId(AppHmi_MediaStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacViewDestroyReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewDestroyReq(::Courier::ViewId(AppHmi_MediaStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacViewClearReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewClearReq(::Courier::ViewId(AppHmi_MediaStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacViewShowReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewShowReq(::Courier::ViewId(AppHmi_MediaStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacViewHideReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewHideReq(::Courier::ViewId(AppHmi_MediaStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacViewCreateWithoutLoadReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewCreateWithoutLoadReq(::Courier::ViewId(AppHmi_MediaStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacViewAsyncLoadReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewAsyncLoadReq(::Courier::ViewId(AppHmi_MediaStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacViewActivateWithoutRenderingReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewActivateWithoutRenderingReq(::Courier::ViewId(AppHmi_MediaStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacPopupCreateAndSBShowReq(::FeatStd::UInt32 aViewId)
{
    Action_gacPopupCreateAndSBShowReq(::Courier::ViewId(AppHmi_MediaStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacPopupCreateAndSBShowReqForMultiDisplay(::FeatStd::UInt32 aPopupDisplayID, ::FeatStd::UInt32 aViewId)
{
    Action_gacPopupCreateAndSBShowReqForMultiDisplay(Courier::UInt32(aPopupDisplayID), ::Courier::ViewId(AppHmi_MediaStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacPopupSBCloseReq(::FeatStd::UInt32 aViewId)
{
    Action_gacPopupSBCloseReq(::Courier::ViewId(AppHmi_MediaStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacPopupSBCloseReqForMultiDisplay(::FeatStd::UInt32 aPopupDisplayID, ::FeatStd::UInt32 aViewId)
{
    Action_gacPopupSBCloseReqForMultiDisplay(Courier::UInt32(aPopupDisplayID), ::Courier::ViewId(AppHmi_MediaStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacPopupRestartTimerReq(::FeatStd::UInt32 aViewId)
{
    Action_gacPopupRestartTimerReq(::Courier::ViewId(AppHmi_MediaStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacPopupRestartTimerReqForMultiDisplay(::FeatStd::UInt32 aPopupDisplayID, ::FeatStd::UInt32 aViewId)
{
    Action_gacPopupRestartTimerReqForMultiDisplay(Courier::UInt32(aPopupDisplayID), ::Courier::ViewId(AppHmi_MediaStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacViewCreateAndShowReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewCreateAndShowReq(::Courier::ViewId(AppHmi_MediaStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacViewHideAndDestroyReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewHideAndDestroyReq(::Courier::ViewId(AppHmi_MediaStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacSceneTransitionEnter(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aHint)
{
    Action_gacSceneTransitionEnter(::Courier::ViewId(AppHmi_MediaStateMachineImpl::GetNameFromId(aViewId)), Courier::UInt32(aHint));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacSceneTransitionLeave(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aHint)
{
    Action_gacSceneTransitionLeave(::Courier::ViewId(AppHmi_MediaStateMachineImpl::GetNameFromId(aViewId)), Courier::UInt32(aHint));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacDisplayStatusLineReq(::FeatStd::Int32 aDisplayRegionType)
{
    Action_gacDisplayStatusLineReq(Courier::Int32(aDisplayRegionType));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacHideStatusLineReq(::FeatStd::Int32 aDisplayRegionType)
{
    Action_gacHideStatusLineReq(Courier::Int32(aDisplayRegionType));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacDisplayFooterLineReq()
{
    Action_gacDisplayFooterLineReq();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacHideFooterLineReq()
{
    Action_gacHideFooterLineReq();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacDisplayStatusLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID)
{
    Action_gacDisplayStatusLineMultiDisplayReq(Courier::Int32(aDisplayRegionType), Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacHideStatusLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID)
{
    Action_gacHideStatusLineMultiDisplayReq(Courier::Int32(aDisplayRegionType), Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacDisplayFooterLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID)
{
    Action_gacDisplayFooterLineMultiDisplayReq(Courier::Int32(aDisplayRegionType), Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacHideFooterLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID)
{
    Action_gacHideFooterLineMultiDisplayReq(Courier::Int32(aDisplayRegionType), Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacRegisterForCloseOnTouchSession(::FeatStd::UInt32 aViewId)
{
    Action_gacRegisterForCloseOnTouchSession(::Courier::ViewId(AppHmi_MediaStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacDeregisterForCloseOnTouchSessionReq(::FeatStd::UInt32 aViewId)
{
    Action_gacDeregisterForCloseOnTouchSessionReq(::Courier::ViewId(AppHmi_MediaStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacPopupFilterPrioEnableReq(::FeatStd::UInt32 aPrio)
{
    Action_gacPopupFilterPrioEnableReq(Courier::UInt32(aPrio));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacPopupFilterAllEnableReq()
{
    Action_gacPopupFilterAllEnableReq();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacPopupFilterDisableReq()
{
    Action_gacPopupFilterDisableReq();
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacProfileChange(::FeatStd::Int8 aProfile)
{
    Action_gacProfileChange(Courier::UInt32(aProfile));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacPopupFilterPrioEnableReqForDisplay(::FeatStd::UInt32 aPrio, ::FeatStd::UInt32 aDisplayID)
{
    Action_gacPopupFilterPrioEnableReqForDisplay(Courier::UInt32(aPrio), Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacPopupFilterAllEnableReqForDisplay(::FeatStd::UInt32 aDisplayID)
{
    Action_gacPopupFilterAllEnableReqForDisplay(Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacPopupFilterDisableReqForDisplay(::FeatStd::UInt32 aDisplayID)
{
    Action_gacPopupFilterDisableReqForDisplay(Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacStartSceneTransitionAnimation(::FeatStd::UInt32 aSourceView, ::FeatStd::UInt32 aDestinationView, ::FeatStd::UInt32 aUserData1, ::FeatStd::Int8 aUserData2)
{
    Action_gacStartSceneTransitionAnimation(::Courier::ViewId(AppHmi_MediaStateMachineImpl::GetNameFromId(aSourceView)), ::Courier::ViewId(AppHmi_MediaStateMachineImpl::GetNameFromId(aDestinationView)), Courier::UInt32(aUserData1), Courier::Int8(aUserData2));
}

// ------------------------------------------------------------------------
void AppHmi_MediaStateMachineImpl::gacDecrementActiveAnimationCount()
{
    Action_gacDecrementActiveAnimationCount();
}

// ------------------------------------------------------------------------

// ------------------------------------------------------------------------
bool AppHmi_MediaStateMachineImpl::IsMediaMessageAvailable()
{
    return Action_IsMediaMessageAvailable();
}
#ifdef CIT_SIMULATION
struct ActionMapping
{
    ::FeatStd::UInt32 mHashId;
    bool (*mActionCallHandler)(const ::Json::Value& parameters, ::Json::Value &response);
};

static ::FeatStd::Int ActionMappingCmp(::FeatStd::UInt32 hash, const ActionMapping& am)
{
    return (hash == am.mHashId) ? 0 : ((hash < am.mHashId) ? -1 : 1);
}

bool AppHmi_MediaStateMachineImpl::CallAction(const ::FeatStd::Char* actionName, const ::Json::Value& parameters, ::Json::Value &response)
{
    static ActionMapping actions[171] = {
        { 0x08600ADE, CallAction_Activate_Suz_MirrorLinkApplication },
        { 0x0884F877, CallAction_gacScrollListUp },
        { 0x090A895B, CallAction_gacScrollListFocusDown },
        { 0x0A4C5DC9, CallAction_gacDisplayStatusLineMultiDisplayReq },
        { 0x0B685ED3, CallAction_RequestPlayBackActionSeek },
        { 0x0C279721, CallAction_gacDecrementActiveAnimationCount },
        { 0x0E1CAF87, CallAction_MediaOperation },
        { 0x106C89C1, CallAction_Perform_BTDeviceNameUpdateStatusMsg },
        { 0x11451ED4, CallAction_Perform_VideoOnEXTDVDParkingBreakRequestMsg },
        { 0x11915CFE, CallAction_acStopAppPopupTimer },
        { 0x11A1B1CF, CallAction_Perform_MediaTabGadget },
        { 0x1280067A, CallAction_Perform_MediaModule_CAMERAPORTHDMI },
        { 0x12D5CE04, CallAction_RequestClearFolderListData },
        { 0x13118D8A, CallAction_Perform_MediaModule_CAMERAPORTUSB },
        { 0x15061065, CallAction_gacViewShowReq },
        { 0x15272842, CallAction_RequestNextBrowseTabs },
        { 0x186A69F1, CallAction_gacWaitAnimationStopReq },
        { 0x187DA604, CallAction_acPerform_OpenDropdown },
        { 0x18F90E42, CallAction_ExternalMediaBackButtonPressUpd },
        { 0x19930550, CallAction_BrowseListActive },
        { 0x1A387B15, CallAction_Perform_USBCameraPortInvisibility },
        { 0x1BC6E0A9, CallAction_ZoomInTransition },
        { 0x1DCBF24F, CallAction_ActivateAUXApp },
        { 0x1F62F2B6, CallAction_Activate_LayerSoundSettingsMsg },
        { 0x1FCF4692, CallAction_Perform_VideoOnEXTDVDSpeedRequestMsg },
        { 0x207DB5FB, CallAction_ActivateExternalDVD },
        { 0x21C6A653, CallAction_acPerform_MediaSettingBackBtnPress },
        { 0x21E3828E, CallAction_gacDisplayStatusLineReq },
        { 0x251DE22F, CallAction_gacContextSwitchCompleteRes },
        { 0x254E0D94, CallAction_gacViewHideReq },
        { 0x258104C2, CallAction_DualViewLeftTransition },
        { 0x264B8E81, CallAction_gacPopupRestartTimerReqForMultiDisplay },
        { 0x27CE647F, CallAction_gacScrollListFocusUp },
        { 0x29D14586, CallAction_gacDisplayFooterLineMultiDisplayReq },
        { 0x2A1E6CB2, CallAction_gacDeregisterForCloseOnTouchSessionReq },
        { 0x2AE288D8, CallAction_gacViewDestroyReq },
        { 0x2C05CFD9, CallAction_StartUSBViewEntryRespMsg },
        { 0x2DC1F3E8, CallAction_acPerform_AppleHIDCommandMsg },
        { 0x2EC786B2, CallAction_Perform_MediaModule_ROUTERUSB },
        { 0x30C8D840, CallAction_gacStartSceneTransitionAnimation },
        { 0x3223B606, CallAction_Perform_FastRewindStop_Popup },
        { 0x325BE13A, CallAction_gacViewCreateReq },
        { 0x334571BF, CallAction_acHKNotificationMsg },
        { 0x34B542D9, CallAction_Perform_FastForwardStart_Popup },
        { 0x3BB18A69, CallAction_gacPopupFilterAllEnableReq },
        { 0x3BE59FBF, CallAction_VideoDisconnectOnSongRequest },
        { 0x3C9D7D4E, CallAction_Perform_Video_Timer_Start },
        { 0x3E4CE5A1, CallAction_gacContextSwitchDoneRes },
        { 0x3E7F9726, CallAction_gacSceneTransitionEnter },
        { 0x41201119, CallAction_acStartAppPopupTimer },
        { 0x41FE7B56, CallAction_Activate_Suz_TunerNowPlaying },
        { 0x4257261F, CallAction_Perform_MediaSceneMsg },
        { 0x4297ECA1, CallAction_Perform_FastRewindStart_Popup },
        { 0x445996C2, CallAction_acPerform_UpdateCurrentMediaState },
        { 0x52647587, CallAction_Perform_FastForwardStop_Popup },
        { 0x5350D2AB, CallAction_ExternalMediaListItemPressUpd },
        { 0x5357E08A, CallAction_StopVideoStreaming },
        { 0x5644013C, CallAction_RequestBrowseList },
        { 0x573EB339, CallAction_gacContextSwitchFailedRes },
        { 0x57AA275B, CallAction_gacViewCreateWithoutLoadReq },
        { 0x59148CB0, CallAction_FadeTransition },
        { 0x595828BA, CallAction_Perform_MediaModule_USB1 },
        { 0x59C82D8E, CallAction_NextLevelTransition },
        { 0x59F03621, CallAction_gacChangeLanguageReq },
        { 0x600B216A, CallAction_Perform_MediaModule_SD },
        { 0x60E513C0, CallAction_gacTBTRetriggerAcousticOutput },
        { 0x629132A7, CallAction_gacPopupFilterDisableReq },
        { 0x62F4231F, CallAction_Activate_Suz_NaviApplication },
        { 0x63E0178E, CallAction_StartVideoStreaming },
        { 0x65A3A4F9, CallAction_ActivateTAApp },
        { 0x65E3BE3C, CallAction_ActivateSDCard },
        { 0x66A3F434, CallAction_Perform_MediaModule_AUX },
        { 0x678A451E, CallAction_Perform_MediaModule_USB2 },
        { 0x67B7653B, CallAction_gacDisplayFooterLineReq },
        { 0x714441CB, CallAction_StartSDCardViewEntryRespMsg },
        { 0x7346330F, CallAction_StopUSBViewExitRespMsg },
        { 0x7531D066, CallAction_Notify_Init_Finished },
        { 0x75E49D1D, CallAction_gacPerformListFocusLockDataResetUpd },
        { 0x76EE4CA4, CallAction_gacHideStatusLineMultiDisplayReq },
        { 0x773E5748, CallAction_ExternalDVDDevicenameRequest },
        { 0x78AA0307, CallAction_Activate_Suz_PreviousApplication },
        { 0x791DF896, CallAction_acPerform_CloseAllDropdowns },
        { 0x799AA7F9, CallAction_MediaBTOperation },
        { 0x7D7B49B4, CallAction_acFocusOnRightEncoderReqUpd },
        { 0x7EE4AB88, CallAction_gacPopupRestartTimerReq },
        { 0x7FE0BC9C, CallAction_IsMediaMessageAvailable },
        { 0x82D15005, CallAction_PageFlipBackTransition },
        { 0x831C211A, CallAction_RequestPreviousBrowseTabs },
        { 0x84D5D822, CallAction_Activate_Suz_BTPhoneApplication },
        { 0x881D2454, CallAction_gacPopupFilterAllEnableReqForDisplay },
        { 0x91BB105A, CallAction_gacLaunchBarDisplayReq },
        { 0x93218F8C, CallAction_gacContextSwitchOutReq },
        { 0x948F96CC, CallAction_gacScrollListDown },
        { 0x9493104D, CallAction_HorListTabButtonItem },
        { 0x95B695B6, CallAction_Perform_MediaModule_BLUETOOTH },
        { 0x96350312, CallAction_acSetGadgetSceenActiveStatus },
        { 0x96B49D48, CallAction_acPerform_UsbElapsedTimeSeekBackMsg },
        { 0x96D3C730, CallAction_gacPopupSBCloseReqForMultiDisplay },
        { 0x99258E0B, CallAction_gacStatusBarDisplayReq },
        { 0x9C4B1251, CallAction_BrowseButtonPressed },
        { 0x9F87F08B, CallAction_acPostBeep },
        { 0x9FA26D73, CallAction_gacPopupFilterDisableReqForDisplay },
        { 0xA0A6F9FA, CallAction_gacViewHideAndDestroyReq },
        { 0xA0AFA812, CallAction_Perform_VideoOnSpeedRequestMsg },
        { 0xA172CF4E, CallAction_Perform_Activate_Home_Source },
        { 0xA7B62A65, CallAction_gacPopupFilterPrioEnableReqForDisplay },
        { 0xA84DC23C, CallAction_gacHideFocusInViewReq },
        { 0xA8A1EBF3, CallAction_VideoBrowseButtonPressed },
        { 0xA903724B, CallAction_Perform_MediaModule_IPOD },
        { 0xA9C7F42F, CallAction_gacHideStatusLineReq },
        { 0xAB49461E, CallAction_gacViewCreateAndShowReq },
        { 0xAC9629EC, CallAction_StopVideoViewExitRespMsg },
        { 0xAD947FF9, CallAction_gacCurrentScreenDisplayReq },
        { 0xAE47EB8D, CallAction_VideoOnsongRequest },
        { 0xAE48BF55, CallAction_DualViewRightTransition },
        { 0xAFB14254, CallAction_gacWaitAnimationStartReq },
        { 0xB2BE9408, CallAction_HorTabListBtnPageDown },
        { 0xB53EAFC9, CallAction_Perform_MediaModule_USB },
        { 0xB6A7E26D, CallAction_StopSDCardViewExitRespMsg },
        { 0xB7335466, CallAction_RequestParentFolderItems },
        { 0xBB441DAC, CallAction_gacRegisterForCloseOnTouchSession },
        { 0xBBEF8A6A, CallAction_BTBrowseButtonPressed },
        { 0xBDECE418, CallAction_gacSetApplicationMode },
        { 0xBEF6021E, CallAction_acPerform_ToggleDropdown },
        { 0xC37EE8E9, CallAction_gacPopupFilterPrioEnableReq },
        { 0xC51CE603, CallAction_gacViewCreateAllReq },
        { 0xC5DD5738, CallAction_gacProfileChange },
        { 0xC65CAED0, CallAction_gacSpellerBbehaviorReq },
        { 0xC76BDA46, CallAction_ExternaldvdVideodisconnectRequest },
        { 0xC8539D8B, CallAction_gacSceneTransitionLeave },
        { 0xC870B817, CallAction_ExternalMediaTabListPageUp },
        { 0xC8EA8B79, CallAction_acRestartAppPopupTimer },
        { 0xC9EB88D6, CallAction_gacViewClearReq },
        { 0xCB8DBDEF, CallAction_gacHideFooterLineReq },
        { 0xCBB57B54, CallAction_ExternalBrowseScreenExitUpd },
        { 0xCC92B936, CallAction_Perform_MediaMessage_Popup },
        { 0xCCF1A98B, CallAction_PreviousLevelTransition },
        { 0xCFAFA26B, CallAction_ExternalMediaTabListPageDown },
        { 0xD0625C09, CallAction_ExternaldvdVideoConnectRequest },
        { 0xD1AA4F4D, CallAction_ZoomOutTransition },
        { 0xD29C0ECA, CallAction_StartVideoViewEntryRespMsg },
        { 0xD3329415, CallAction_ExternalMediaAllButtonPressUpd },
        { 0xD3B2D85C, CallAction_RequestBTPlayBackActionSeek },
        { 0xD4716F48, CallAction_ExternalMediaTabBtnPressUpd },
        { 0xD5F685D5, CallAction_PageFlipFrontTransition },
        { 0xD63C2357, CallAction_gacViewAsyncLoadReq },
        { 0xD933AAB9, CallAction_Activate_Suz_SoundSettingsApplication },
        { 0xD98C6419, CallAction_gacViewActivateWithoutRenderingReq },
        { 0xD99ABEBC, CallAction_Activate_ButtonMainSrcActivate },
        { 0xDB665FD5, CallAction_acPerform_CloseDropdown },
        { 0xDD4D179D, CallAction_gacHideFooterLineMultiDisplayReq },
        { 0xDD71F921, CallAction_gacPerformListBtnRightEncoderChangeUpd },
        { 0xDE2BF2CC, CallAction_NowplayingAlbumartViewRequest },
        { 0xE0EF3086, CallAction_gacPopupCreateAndSBShowReqForMultiDisplay },
        { 0xE1A50246, CallAction_RequestAudioAllocationForMode },
        { 0xE500B03C, CallAction_gacContextSwitchBackRes },
        { 0xE7CA9BFF, CallAction_HorTabListBtnPageUp },
        { 0xEB51CB7E, CallAction_gacPopupSBCloseReq },
        { 0xEB8D196B, CallAction_Perform_Video_Timer_Stop },
        { 0xEC64DB0F, CallAction_gacScrollPageDown },
        { 0xEE11F57F, CallAction_gacScrollPageUp },
        { 0xEE131A83, CallAction_gacNavTBTSwipe },
        { 0xF0A1D4B5, CallAction_gacCheckToClosePopup },
        { 0xF17E085D, CallAction_gacPopupCreateAndSBShowReq },
        { 0xF679DD7F, CallAction_Perform_MediaToggle },
        { 0xF82E6926, CallAction_ExternalAuxDevicenameRequest },
        { 0xFA50A8A2, CallAction_Activate_Suz_TunerApplication },
        { 0xFC259EBB, CallAction_StartFolderViewEntryRespMsg },
        { 0xFCDCBE41, CallAction_StopFolderViewExitRespMsg },
        { 0xFDABD161, CallAction_OptionSelStateRespMsg },
        { 0xFE29F486, CallAction_Perform_VideoOnParkingBreakRequestMsg },
    };
    ::FeatStd::UInt32 hashId = ::Courier::Identifier::CalcHash(actionName);
    const ActionMapping* action = ::Courier::BinarySearch(hashId, actions, 171, &ActionMappingCmp);
    if (action && (hashId == action->mHashId)) {
        return action->mActionCallHandler(parameters, response);
    }
    return false;
}
#endif
namespace Courier {
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CameraGroupReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CameraGroupResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ActivationReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ActivationResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewRenderingReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewRenderingResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewMessagingReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewMessagingResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CameraGroupActivationReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CameraGroupActivationResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TryLoadReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::LoadReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DelayedUnloadMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::LoadResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TryAsyncLoadReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::AsyncLoadReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::AsyncLoadResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::AsyncLoadIndMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CameraGroupLoadReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CameraGroupLoadResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ThemeReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ThemeResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::AnimationReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::AnimationResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::AnimationIndMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::SetPropertyReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::SetPropertyResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::SetFocusReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::SetFocusResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::LostFocusIndMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TransitionReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TransitionResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TransitionIndMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::InvalidateReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::RenderReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::RenderResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::LayerReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::LayerResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ParentViewActivateEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ParentViewRenderingEnabledEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ParentViewInitContentEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ParentViewLoadEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::FocusEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::LostFocusEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TransitionStartedEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TransitionFinishedEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::SetCultureReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::SetCultureResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CultureChangeIndMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewPlaceholderReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewPlaceholderResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewMsgBase, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::WidgetMsgBase, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::Internal::DataBindingMsgBase, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::Internal::BindingSourceBaseMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::Internal::ReleaseDataItemMsgBase, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::Internal::DataItemMsgBase, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::Internal::ListEventMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::input::TouchAbort, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::input::TouchSessionStartEvent, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::input::TouchSessionStopEvent, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::IdUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::ConsumerMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::ProviderUpdateIndicationMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::TouchForwardReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::TouchAbortReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::ActivateImageProviderReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::ExternalImageProviderReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::ExternalImageProviderGroupReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::DrmAllocationStatusMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::DrmGarbageCollectorReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::DrmGCTimeoutMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::PositionBaseMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::SlaveSurfaceRepositionBaseMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::DirectTextureConsumerContentIndicationMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::PositionInfoReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::PositionInfoResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::SlaveSurfaceRepositionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::SlaveSurfaceRepositionResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::WidgetCheckReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::NotifierMessage, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TimerExpiredMsg, 15);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::GuiStartupFinishedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CreateNewDestroyOld, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EnterKeyStatusChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusControlReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusGroupReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::UpdateFocusSessionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RefreshFocusSessionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusSessionFinishedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RegisterFocusableWidgetsReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::JoystickStatusChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusChangedReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SurfaceStateChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::LayerStateChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SBPopupTimerExpiryUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::HMISubStateChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::QueryTraceInfoReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FollowUpActionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::WidgetPropertySetterReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SimTouchReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CloseOnTouchReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RegisterForCloseOnTouchSessionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SetClosePopupExternalTouchMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ClosePopupOnExternalTouchReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PlayBeepReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ChangeHmiSubStateReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EvalSubSurfaceReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ExecuteSubSurfaceReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ExecuteSubSurfaceResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ExtendedViewReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::LocalizationReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DecrementActiveAnimationCountMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PopupReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SetApplicationAsMandatoryReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ApplicationStateUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SubSurfaceUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ApplicationRenderedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ApplicationSwitchCompleteUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SubSurfaceSwitchCompleteUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SbAnimationStateChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SbCurrentStatusUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PopupDisplayStatusUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ShowHMISubSurfaceReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StartLayerAnimationReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PopupFilterPrioEnableReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PopupFilterAllEnableReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PopupFilterDisableReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::MultiDisplayPopupFilterReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RestartMenuTimeoutTimerReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RenderingCompleteMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CreateTextMetaDataCollectionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DumpScreenReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TraverseViewsReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropCheckSourceReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropCheckSourceResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropCheckDestinationReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropCheckDestinationResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropCompleteReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropCompleteResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropAbortReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropStatusUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ProfileSwitchMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TransitionMediatorOnDataCompleteMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ManualSceneActionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EglWaitNativeReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EglWaitNativeResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ResetGadgetCacheReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::AttachedAnimationReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::SenderMessage, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::TouchUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::AnimationWidgetReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::AnimationWidgetIndMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ButtonListItemUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ButtonReactionMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ButtonSlideMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ButtonGroupReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ColorBarDataUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::combobox::ComboBoxUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::combobox::ComboBoxReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DropdownCurrentValueChangedMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DropdownChangeMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::editfield::EditFieldUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::editfield::EditFieldHightlightReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gesture::GestureMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gesture::TapGestureMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gesture::DragGestureMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gesture::SwipeGestureMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gesture::PinchSpreadGestureMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gesture::RotateGestureMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gizmo::GizmoUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListDateProviderReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListDateProviderResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListDataProviderUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListChangeMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListAnimatedChangeReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListChangedUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListMovementFinishedUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListStatusUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListVisibiltyUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListFocusChangeReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SliderCurrentValueChangedMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::LockOutMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListItemExpandReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListItemExpandEndUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListCustomAnimationReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListCustomAnimationResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListCustomAnimationIndMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListMorphReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListContentUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListVisualContentUpdateMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListCacheReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::pageedit::PageEditUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PanelSlideReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PanelStateMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SpellerKeyPressed, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SpellerCtrlKeyPressed, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SpellerStatusChangedUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SubSpellerStatusUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TimerWidgetExpiryMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::HWR_CandidateUpdate, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::HWR_TextWidgetUpdate, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ScrollableTextUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActiveSurfaceViewUpdateMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ChangeLanguageReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StartPopupTimerReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StopPopupTimerReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RestartPopupTimerReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ExpiredPopupTimerResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListFocusResetReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EnableCameraRenderingReq, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SwitchApplicationStateReq, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DisableCameraRenderingReq, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DummyMess, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivityMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivateApplicationMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DeactivateApplicationMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::HardKeyPressNotificationMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusOnRightEncoderReqUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StoreActiveGadgetReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CheckToClosePopupMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ContextSwitchOutReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ContextSwitchInResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CurrentScreenDisplayReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::LaunchBarDisplayReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::NavTBTSwipeReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListItemRightEncoderChangeUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListFocusLockDataResetReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListFocusScrollReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SetApplicationModeReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SpellerBbehaviorReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StatusBarDisplayReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TBTRetriggerAcousticMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StartGadgetAnimationReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ControlPanelButtonPressInfo, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Popup_Pfo_VideoDisableMessage_Close, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActiveMediaSource_Appflyinn_Msg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Popup_Pfo_VideoDisableMessage_Open, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Open_Settings_Screen, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Popup_Pfo_MediaGlassUnavailableMessage_Close, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Popup_Pfo_MediaGlassUnavailableMessage_Open, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Popup_Pfo_NoPlayableContentPopup_Close, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Popup_Pfo_NoPlayableContentPopup_Open, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Popup_Pfo_SignalRangeError_Open, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Open_SourceSelection_Screen, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Update_MediaActivityID, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Open_WMA_DRM_Popup, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Close_WMA_DRM_Popup, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ButtonMainSrcActivate, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::LayerSoundSettingsMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::NextBrowseTabsReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PreviousBrowseTabsReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ShowArtistBrowseTabReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ShowAlbumBrowseTabReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ShowTitleBrowseTabReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::HorTabButtonPageUpReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::HorTabButtonPageDownReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ExternalMediaTabListPageUpReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ExternalMediaTabListPageDownReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ExternalMediaBackButtonPressUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ExternalMediaAllButtonPressUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ShowGenreBrowseTabReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ShowAudiobookBrowseTabReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ShowPlaylistBrowseTabReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ShowPodcastBrowseTabReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ShowVideoBrowseTabReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ShowFolderBrowseTabReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActicvateAlbumSceneMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::NewListEntryMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::MediaMessagepopupMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::MediaMessagepopupRelease, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActicvateVideorestrictionpopupmessage, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::onHardKeyPress, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::AudioSongSelectionMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::VideoSongSelectionMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PlayAudioVideoSong, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivateSourceSwitchToDVD, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivateSourceSwitchToBT, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivateSourceSwitchToAUX, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivateSourceSwitchToUSB, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivateSwitchToSourceSel, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::UpdateBTDeviceNameUpdateStatusMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RetrieveLastBrowseListMsgReq, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PlayTimeStatusMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PlayBackStatusMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::VideoNowPlayingStatusMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PlayBackModeStatusMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ExtDVDConnectionModeStatusMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::VehicleSensorSpeedModestatusMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::VehicleSensorparkingbreakStatusMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::VideorestrictionpopupMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::VariantTypeUpdateMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::VehicleSensorExtDVDSpeedModestatusMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::VehicleSensorExtDVDparkingbreakStatusMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ExternalDVDVisiblestatus, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::NavigationAvailableStatus, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SDCardVisibileStatus, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::AUXVisibileStatus, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RepeatModeStatusMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::UpdateDeviceNameMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::UpdateActiveDevicestatusMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SourceSelectionStateResp, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::OptionSelStateResp, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::MediaOptionTabsReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::UpdateDeviceConnectionStatus, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::UpdateDevIndexingStatus, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SdcardOptionstatusMsgResp, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::AUXOptionstatusMsgResp, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ExternalDVDOptionstatusMsgResp, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TAoptionstatusMsgResp, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EnableView, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EnableandShowPopUp, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SelectHomescreenMediaTab, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::HomescreenToggle, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::USBCameraPortInvisibility, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SwitchFullScreenVideo, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StartVideoTimerMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StopVideoTimerMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DisableView, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::USB2SelectDeviceMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::USB1SelectDeviceMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SelectDeviceSourceMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::MediaOperationMsgReq, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActiveRenderedView, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::MediaSurfaceStateUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::MediaSceneMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::MediaBTOperationMsgReq, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivateAUXAppReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivateSDCardAppReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivateExternalDVDAppReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivateTAAppReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::BrowseListActiveRef, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::BrowseListReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::BrowseListRespMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::AudioAllocationForModeMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SwitchApplicationReq, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SwitchToTunerApplication, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SwitchToTunerNowPlaying, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SwitchToPreviousApplication, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SwitchToBTPhoneApplication, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SwitchToNaviApplication, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SwitchToMirrorLinkApplication, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SwitchToSoundSettingsApplication, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SeekMediaAppReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SeekBTMediaAppReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RequestUpFolderItems, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ClearFolderListData, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::VideoOnSpeedRequestMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::VideoOnParkingBreakRequestMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::VideoOnExtDVDSpeedRequestMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::VideoOnExtDVDParkingBreakRequestMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::VideoDisconnectRequest, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ExtDVDVideoConnectRequest, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ExtDVDDevicenameRequest, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::AuxDevicenameRequest, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ExtDVDVideoDisconnectRequest, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DVDVideoStartStreaming, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FolderViewEntryRespMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FolderViewExitRespMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::VideoViewEntryRespMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::VideoViewExitRespMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SDCardViewEntryRespMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SDCardViewExitRespMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::USBViewEntryRespMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::USBViewExitRespMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DVDStopVideoStreaming, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::VideoRequest, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::NowplayingAlbumartView, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ChangeHorListTabButtonRegMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ExternalMediaTabBtnPressUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ExternalBrowseScreenExitUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::BTBrowsePressedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::VideoBrowsePressedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::BrowseBtnPressedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ExternalMediaListItemPressUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::UsbElapsedTimeSeekBackMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::AppleHIDCommandMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CurrentMediaStateUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::MediaSettingBackBtnPressUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::WaitAnimationReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivatePopUpMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DeActivatePopUpMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SystemPopupDisplayStatusUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DBDownloadStateUpdateMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::MockCreateListandSliceListResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ExternalCamportVideoSourceAvailabilityMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ExternalCamportAudioSourceAvailabilityMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SourceAllocationMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ExternalHDMISourceAvailabilityMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ExternalRouterSourceAvailabilityMsg, 5);
} // namespace Courier

// ------------------------------------------------------------------------
DeviceConnectionDataBindingSource::DeviceConnectionDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::DeviceConnectionItem)
{
}

// ------------------------------------------------------------------------
BTVisibilityDataBindingSource::BTVisibilityDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::BTVisibilityItem)
{
}

// ------------------------------------------------------------------------
SPIVisibilityDataBindingSource::SPIVisibilityDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SPIVisibilityItem)
{
}

// ------------------------------------------------------------------------
PlaybackActionDataBindingSource::PlaybackActionDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::PlaybackActionItem)
{
}

// ------------------------------------------------------------------------
USBCameraPortPlaybackActionDataBindingSource::USBCameraPortPlaybackActionDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::USBCameraPortPlaybackActionItem)
{
}

// ------------------------------------------------------------------------
USBRouterPlaybackActionDataBindingSource::USBRouterPlaybackActionDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::USBRouterPlaybackActionItem)
{
}

// ------------------------------------------------------------------------
MuteInfoDataBindingSource::MuteInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::MuteInfoItem)
{
}

// ------------------------------------------------------------------------
MuteInfoforAuxDataBindingSource::MuteInfoforAuxDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::MuteInfoforAuxItem)
{
}

// ------------------------------------------------------------------------
USB2VisibilityDataBindingSource::USB2VisibilityDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::USB2VisibilityItem)
{
}

// ------------------------------------------------------------------------
VariantInfoDataBindingSource::VariantInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::VariantInfoItem)
{
}

// ------------------------------------------------------------------------
ExternalMediaSourceDataBindingSource::ExternalMediaSourceDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::ExternalMediaSourceItem)
{
}

// ------------------------------------------------------------------------
TabVideoSourceDataBindingSource::TabVideoSourceDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::TabVideoSourceItem)
{
}

// ------------------------------------------------------------------------
BTNowplayIconsDataBindingSource::BTNowplayIconsDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::BTNowplayIconsItem)
{
}

// ------------------------------------------------------------------------
ID3CoverDataForGadgetDataBindingSource::ID3CoverDataForGadgetDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::ID3CoverDataForGadgetItem)
{
}

// ------------------------------------------------------------------------
ID3CoverDataForCamportUSBGadgetDataBindingSource::ID3CoverDataForCamportUSBGadgetDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::ID3CoverDataForCamportUSBGadgetItem)
{
}

// ------------------------------------------------------------------------
ID3CoverDataForRouterUSBGadgetDataBindingSource::ID3CoverDataForRouterUSBGadgetDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::ID3CoverDataForRouterUSBGadgetItem)
{
}

// ------------------------------------------------------------------------
ID3CoverDataForCamportUSBDataBindingSource::ID3CoverDataForCamportUSBDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::ID3CoverDataForCamportUSBItem)
{
}

// ------------------------------------------------------------------------
ID3CoverDataForRouterUSBDataBindingSource::ID3CoverDataForRouterUSBDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::ID3CoverDataForRouterUSBItem)
{
}

// ------------------------------------------------------------------------
AlbumListItemDataBindingSource::AlbumListItemDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::AlbumListItemItem)
{
}

// ------------------------------------------------------------------------
VideoPlaybackActionDataBindingSource::VideoPlaybackActionDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::VideoPlaybackActionItem)
{
}

// ------------------------------------------------------------------------
AppleDeviceDataBindingSource::AppleDeviceDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::AppleDeviceItem)
{
}

// ------------------------------------------------------------------------
IconsDataBindingSource::IconsDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::IconsItem)
{
}

// ------------------------------------------------------------------------
IconsVisibilityDataBindingSource::IconsVisibilityDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::IconsVisibilityItem)
{
}

// ------------------------------------------------------------------------
NavigationVarientTypeDataBindingSource::NavigationVarientTypeDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::NavigationVarientTypeItem)
{
}

// ------------------------------------------------------------------------
ID3CoverDataForAppleDataBindingSource::ID3CoverDataForAppleDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::ID3CoverDataForAppleItem)
{
}

// ------------------------------------------------------------------------
ID3CoverDataForBTDataBindingSource::ID3CoverDataForBTDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::ID3CoverDataForBTItem)
{
}

// ------------------------------------------------------------------------
SDCardDeviceDataBindingSource::SDCardDeviceDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SDCardDeviceItem)
{
}

// ------------------------------------------------------------------------
ID3CoverDataForSDCardDataBindingSource::ID3CoverDataForSDCardDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::ID3CoverDataForSDCardItem)
{
}

// ------------------------------------------------------------------------
VideoPlayerFullScreeenDataBindingSource::VideoPlayerFullScreeenDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::VideoPlayerFullScreeenItem)
{
}

// ------------------------------------------------------------------------
IpodButtonDataBindingSource::IpodButtonDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::IpodButtonItem)
{
}

// ------------------------------------------------------------------------
AuxButtonDataBindingSource::AuxButtonDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::AuxButtonItem)
{
}

// ------------------------------------------------------------------------
USBButtonDataBindingSource::USBButtonDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::USBButtonItem)
{
}

// ------------------------------------------------------------------------
USB1ButtonDataBindingSource::USB1ButtonDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::USB1ButtonItem)
{
}

// ------------------------------------------------------------------------
USB2ButtonDataBindingSource::USB2ButtonDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::USB2ButtonItem)
{
}

// ------------------------------------------------------------------------
SDCardButtonDataBindingSource::SDCardButtonDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SDCardButtonItem)
{
}

// ------------------------------------------------------------------------
BTButtonDataBindingSource::BTButtonDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::BTButtonItem)
{
}

// ------------------------------------------------------------------------
ExternalDVDButtonDataBindingSource::ExternalDVDButtonDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::ExternalDVDButtonItem)
{
}

// ------------------------------------------------------------------------
Camport1USBButtonDataBindingSource::Camport1USBButtonDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::Camport1USBButtonItem)
{
}

// ------------------------------------------------------------------------
Camport1HDMIButtonDataBindingSource::Camport1HDMIButtonDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::Camport1HDMIButtonItem)
{
}

// ------------------------------------------------------------------------
ExternalDVDStatusDataBindingSource::ExternalDVDStatusDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::ExternalDVDStatusItem)
{
}

// ------------------------------------------------------------------------
TAStatusDataBindingSource::TAStatusDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::TAStatusItem)
{
}

// ------------------------------------------------------------------------
AUXStatusDataBindingSource::AUXStatusDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::AUXStatusItem)
{
}

// ------------------------------------------------------------------------
SDCardStatusDataBindingSource::SDCardStatusDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SDCardStatusItem)
{
}

// ------------------------------------------------------------------------
TitleTabDataBindingSource::TitleTabDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::TitleTabItem)
{
}

// ------------------------------------------------------------------------
ArtistTabDataBindingSource::ArtistTabDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::ArtistTabItem)
{
}

// ------------------------------------------------------------------------
AlbumTabDataBindingSource::AlbumTabDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::AlbumTabItem)
{
}

// ------------------------------------------------------------------------
GenreTabDataBindingSource::GenreTabDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::GenreTabItem)
{
}

// ------------------------------------------------------------------------
FolderTabDataBindingSource::FolderTabDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::FolderTabItem)
{
}

// ------------------------------------------------------------------------
PlaylistTabDataBindingSource::PlaylistTabDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::PlaylistTabItem)
{
}

// ------------------------------------------------------------------------
AudiobookTabDataBindingSource::AudiobookTabDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::AudiobookTabItem)
{
}

// ------------------------------------------------------------------------
PodcastTabDataBindingSource::PodcastTabDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::PodcastTabItem)
{
}

// ------------------------------------------------------------------------
VideoTabDataBindingSource::VideoTabDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::VideoTabItem)
{
}

// ------------------------------------------------------------------------
ExternalDVDVisibililtyDataBindingSource::ExternalDVDVisibililtyDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::ExternalDVDVisibililtyItem)
{
}

// ------------------------------------------------------------------------
AUXVisibilityDataBindingSource::AUXVisibilityDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::AUXVisibilityItem)
{
}

// ------------------------------------------------------------------------
SDCardVisibilityDataBindingSource::SDCardVisibilityDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SDCardVisibilityItem)
{
}

// ------------------------------------------------------------------------
TAIconStatusDataBindingSource::TAIconStatusDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::TAIconStatusItem)
{
}

// ------------------------------------------------------------------------
DeviceConnectStatusDataBindingSource::DeviceConnectStatusDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::DeviceConnectStatusItem)
{
}

// ------------------------------------------------------------------------
ExternalDeviceConnectedDataBindingSource::ExternalDeviceConnectedDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::ExternalDeviceConnectedItem)
{
}

// ------------------------------------------------------------------------
DBInPreparationDataBindingSource::DBInPreparationDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::DBInPreparationItem)
{
}

// ------------------------------------------------------------------------
DBDownloadErrorDataBindingSource::DBDownloadErrorDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::DBDownloadErrorItem)
{
}

// ------------------------------------------------------------------------
DeviceNameAndStatusDataBindingSource::DeviceNameAndStatusDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::DeviceNameAndStatusItem)
{
}

// ------------------------------------------------------------------------
BrowseListSizeDataBindingSource::BrowseListSizeDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::BrowseListSizeItem)
{
}

// ------------------------------------------------------------------------
BrowseListSelectedLineDataBindingSource::BrowseListSelectedLineDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::BrowseListSelectedLineItem)
{
}

// ------------------------------------------------------------------------
Artist_AlbumListSizeDataBindingSource::Artist_AlbumListSizeDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::Artist_AlbumListSizeItem)
{
}

// ------------------------------------------------------------------------
Artist_AlbumListSelectedLineDataBindingSource::Artist_AlbumListSelectedLineDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::Artist_AlbumListSelectedLineItem)
{
}

// ------------------------------------------------------------------------
Artist_Album_TitleListSizeDataBindingSource::Artist_Album_TitleListSizeDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::Artist_Album_TitleListSizeItem)
{
}

// ------------------------------------------------------------------------
Artist_Album_TitleListSelectedLineDataBindingSource::Artist_Album_TitleListSelectedLineDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::Artist_Album_TitleListSelectedLineItem)
{
}

// ------------------------------------------------------------------------
Album_TitleListSizeDataBindingSource::Album_TitleListSizeDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::Album_TitleListSizeItem)
{
}

// ------------------------------------------------------------------------
Album_TitleListSelectedLineDataBindingSource::Album_TitleListSelectedLineDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::Album_TitleListSelectedLineItem)
{
}

// ------------------------------------------------------------------------
Title_ListSizeDataBindingSource::Title_ListSizeDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::Title_ListSizeItem)
{
}

// ------------------------------------------------------------------------
TitleListSelectedLineDataBindingSource::TitleListSelectedLineDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::TitleListSelectedLineItem)
{
}

// ------------------------------------------------------------------------
Genre_ArtistListSizeDataBindingSource::Genre_ArtistListSizeDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::Genre_ArtistListSizeItem)
{
}

// ------------------------------------------------------------------------
Genre_ArtistListSelectedLineDataBindingSource::Genre_ArtistListSelectedLineDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::Genre_ArtistListSelectedLineItem)
{
}

// ------------------------------------------------------------------------
Genre_AllAlbumsListSizeDataBindingSource::Genre_AllAlbumsListSizeDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::Genre_AllAlbumsListSizeItem)
{
}

// ------------------------------------------------------------------------
Genre_AllAlbumsListSelectedLineDataBindingSource::Genre_AllAlbumsListSelectedLineDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::Genre_AllAlbumsListSelectedLineItem)
{
}

// ------------------------------------------------------------------------
Genre_Artist_AlbumListSizeDataBindingSource::Genre_Artist_AlbumListSizeDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::Genre_Artist_AlbumListSizeItem)
{
}

// ------------------------------------------------------------------------
Genre_Artist_AlbumListSelectedLineDataBindingSource::Genre_Artist_AlbumListSelectedLineDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::Genre_Artist_AlbumListSelectedLineItem)
{
}

// ------------------------------------------------------------------------
Genre_TitleListSizeDataBindingSource::Genre_TitleListSizeDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::Genre_TitleListSizeItem)
{
}

// ------------------------------------------------------------------------
Genre_TitleListSelectedLineDataBindingSource::Genre_TitleListSelectedLineDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::Genre_TitleListSelectedLineItem)
{
}

// ------------------------------------------------------------------------
FastForwardRewindPopupDataBindingSource::FastForwardRewindPopupDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::FastForwardRewindPopupItem)
{
}

// ------------------------------------------------------------------------
BTShuffleDataBindingSource::BTShuffleDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::BTShuffleItem)
{
}

// ------------------------------------------------------------------------
BTRepeatDataBindingSource::BTRepeatDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::BTRepeatItem)
{
}

// ------------------------------------------------------------------------
BTPlayInfoUpdateDataBindingSource::BTPlayInfoUpdateDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::BTPlayInfoUpdateItem)
{
}

// ------------------------------------------------------------------------
BTSliderVisibilityDataBindingSource::BTSliderVisibilityDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::BTSliderVisibilityItem)
{
}

// ------------------------------------------------------------------------
BTTotalTimeVisibilityDataBindingSource::BTTotalTimeVisibilityDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::BTTotalTimeVisibilityItem)
{
}

// ------------------------------------------------------------------------
BTElapsedTimeVisibilityDataBindingSource::BTElapsedTimeVisibilityDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::BTElapsedTimeVisibilityItem)
{
}

// ------------------------------------------------------------------------
ID3CoverDataDataBindingSource::ID3CoverDataDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::ID3CoverDataItem)
{
}

// ------------------------------------------------------------------------
Audiobook_ListSizeDataBindingSource::Audiobook_ListSizeDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::Audiobook_ListSizeItem)
{
}

// ------------------------------------------------------------------------
AudiobookListSelectedLineDataBindingSource::AudiobookListSelectedLineDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::AudiobookListSelectedLineItem)
{
}

// ------------------------------------------------------------------------
AudiobookChapter_ListSizeDataBindingSource::AudiobookChapter_ListSizeDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::AudiobookChapter_ListSizeItem)
{
}

// ------------------------------------------------------------------------
AudiobookChapterListSelectedLineDataBindingSource::AudiobookChapterListSelectedLineDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::AudiobookChapterListSelectedLineItem)
{
}

// ------------------------------------------------------------------------
Playlist_ListSizeDataBindingSource::Playlist_ListSizeDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::Playlist_ListSizeItem)
{
}

// ------------------------------------------------------------------------
PlaylistListSelectedLineDataBindingSource::PlaylistListSelectedLineDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::PlaylistListSelectedLineItem)
{
}

// ------------------------------------------------------------------------
PlaylistTitle_ListSizeDataBindingSource::PlaylistTitle_ListSizeDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::PlaylistTitle_ListSizeItem)
{
}

// ------------------------------------------------------------------------
PlaylistTitleListSelectedLineDataBindingSource::PlaylistTitleListSelectedLineDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::PlaylistTitleListSelectedLineItem)
{
}

// ------------------------------------------------------------------------
Podcast_EpisodeListSizeDataBindingSource::Podcast_EpisodeListSizeDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::Podcast_EpisodeListSizeItem)
{
}

// ------------------------------------------------------------------------
Podcast_EpisodeListSelectedLineDataBindingSource::Podcast_EpisodeListSelectedLineDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::Podcast_EpisodeListSelectedLineItem)
{
}

// ------------------------------------------------------------------------
Video_EpisodeListSizeDataBindingSource::Video_EpisodeListSizeDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::Video_EpisodeListSizeItem)
{
}

// ------------------------------------------------------------------------
Video_EpisodeListSelectedLineDataBindingSource::Video_EpisodeListSelectedLineDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::Video_EpisodeListSelectedLineItem)
{
}

// ------------------------------------------------------------------------
Folder_ListSizeDataBindingSource::Folder_ListSizeDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::Folder_ListSizeItem)
{
}

// ------------------------------------------------------------------------
Folder_ListSelectedLineDataBindingSource::Folder_ListSelectedLineDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::Folder_ListSelectedLineItem)
{
}

// ------------------------------------------------------------------------
FolderFile_ListSizeDataBindingSource::FolderFile_ListSizeDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::FolderFile_ListSizeItem)
{
}

// ------------------------------------------------------------------------
FolderFile_ListSelectedLineDataBindingSource::FolderFile_ListSelectedLineDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::FolderFile_ListSelectedLineItem)
{
}

// ------------------------------------------------------------------------
Folder_NameDataBindingSource::Folder_NameDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::Folder_NameItem)
{
}

// ------------------------------------------------------------------------
NotebookdataDataBindingSource::NotebookdataDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::NotebookdataItem)
{
}

// ------------------------------------------------------------------------
TabNextPrevIndexDataBindingSource::TabNextPrevIndexDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::TabNextPrevIndexItem)
{
}

// ------------------------------------------------------------------------
ListstatusDataBindingSource::ListstatusDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::ListstatusItem)
{
}

// ------------------------------------------------------------------------
SDRepeatOptionDataBindingSource::SDRepeatOptionDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SDRepeatOptionItem)
{
}

// ------------------------------------------------------------------------
USBRepeatOptionDataBindingSource::USBRepeatOptionDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::USBRepeatOptionItem)
{
}

// ------------------------------------------------------------------------
USBCameraPortRepeatOptionDataBindingSource::USBCameraPortRepeatOptionDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::USBCameraPortRepeatOptionItem)
{
}

// ------------------------------------------------------------------------
USBRouterRepeatOptionDataBindingSource::USBRouterRepeatOptionDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::USBRouterRepeatOptionItem)
{
}

// ------------------------------------------------------------------------
BTRepeatOptionDataBindingSource::BTRepeatOptionDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::BTRepeatOptionItem)
{
}

// ------------------------------------------------------------------------
AppleRepeatOptionDataBindingSource::AppleRepeatOptionDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::AppleRepeatOptionItem)
{
}

// ------------------------------------------------------------------------
SDShuffleOptionDataBindingSource::SDShuffleOptionDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SDShuffleOptionItem)
{
}

// ------------------------------------------------------------------------
USBShuffleOptionDataBindingSource::USBShuffleOptionDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::USBShuffleOptionItem)
{
}

// ------------------------------------------------------------------------
USBCameraPortShuffleOptionDataBindingSource::USBCameraPortShuffleOptionDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::USBCameraPortShuffleOptionItem)
{
}

// ------------------------------------------------------------------------
USBRouterShuffleOptionDataBindingSource::USBRouterShuffleOptionDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::USBRouterShuffleOptionItem)
{
}

// ------------------------------------------------------------------------
USBPlayPauseOptionDataBindingSource::USBPlayPauseOptionDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::USBPlayPauseOptionItem)
{
}

// ------------------------------------------------------------------------
USBCameraPortPlayPauseOptionDataBindingSource::USBCameraPortPlayPauseOptionDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::USBCameraPortPlayPauseOptionItem)
{
}

// ------------------------------------------------------------------------
USBRouterPlayPauseOptionDataBindingSource::USBRouterPlayPauseOptionDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::USBRouterPlayPauseOptionItem)
{
}

// ------------------------------------------------------------------------
ApplePlayPauseOptionDataBindingSource::ApplePlayPauseOptionDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::ApplePlayPauseOptionItem)
{
}

// ------------------------------------------------------------------------
BTPlayPauseOptionDataBindingSource::BTPlayPauseOptionDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::BTPlayPauseOptionItem)
{
}

// ------------------------------------------------------------------------
BTShuffleOptionDataBindingSource::BTShuffleOptionDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::BTShuffleOptionItem)
{
}

// ------------------------------------------------------------------------
AppleShuffleOptionDataBindingSource::AppleShuffleOptionDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::AppleShuffleOptionItem)
{
}

// ------------------------------------------------------------------------
SPIConnectionTypeDataBindingSource::SPIConnectionTypeDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SPIConnectionTypeItem)
{
}

// ------------------------------------------------------------------------
AuxFeatureControllerDataBindingSource::AuxFeatureControllerDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::AuxFeatureControllerItem)
{
}

// ------------------------------------------------------------------------
MediaListIDDataBindingSource::MediaListIDDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::MediaListIDItem)
{
}

// ------------------------------------------------------------------------
MediaTabActiveStateDataBindingSource::MediaTabActiveStateDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::MediaTabActiveStateItem)
{
}

// ------------------------------------------------------------------------
VideoTabActivationDataBindingSource::VideoTabActivationDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::VideoTabActivationItem)
{
}

// ------------------------------------------------------------------------
USBCameraPortAlbumVisibilityDataBindingSource::USBCameraPortAlbumVisibilityDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::USBCameraPortAlbumVisibilityItem)
{
}

// ------------------------------------------------------------------------
USBRouterAlbumVisibilityDataBindingSource::USBRouterAlbumVisibilityDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::USBRouterAlbumVisibilityItem)
{
}

// ------------------------------------------------------------------------
AuxActivationDataBindingSource::AuxActivationDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::AuxActivationItem)
{
}

// ------------------------------------------------------------------------
FolderListDataItemDataBindingSource::FolderListDataItemDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::FolderListDataItemItem)
{
}

// ------------------------------------------------------------------------
DownloadVisibilityDataItemDataBindingSource::DownloadVisibilityDataItemDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::DownloadVisibilityDataItemItem)
{
}

// ------------------------------------------------------------------------
FolderFileListDataItemDataBindingSource::FolderFileListDataItemDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::FolderFileListDataItemItem)
{
}

// ------------------------------------------------------------------------
BrowseTextChangeDataBindingSource::BrowseTextChangeDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::BrowseTextChangeItem)
{
}

// ------------------------------------------------------------------------
ExternalBrowseTextInfoDataBindingSource::ExternalBrowseTextInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::ExternalBrowseTextInfoItem)
{
}

// ------------------------------------------------------------------------
BrowserScreenListSizeDataBindingSource::BrowserScreenListSizeDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::BrowserScreenListSizeItem)
{
}

// ------------------------------------------------------------------------
BrowseListInfoTextDataBindingSource::BrowseListInfoTextDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::BrowseListInfoTextItem)
{
}

// ------------------------------------------------------------------------
MediaTabDisabledStateDataBindingSource::MediaTabDisabledStateDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::MediaTabDisabledStateItem)
{
}

// ------------------------------------------------------------------------
MuteStateVisibleGadgetDataBindingSource::MuteStateVisibleGadgetDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::MuteStateVisibleGadgetItem)
{
}

// ------------------------------------------------------------------------
MediaSourceUpdateInGadgetDataBindingSource::MediaSourceUpdateInGadgetDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::MediaSourceUpdateInGadgetItem)
{
}

// ------------------------------------------------------------------------
MediaMetaDataUpdateInGadgetDataBindingSource::MediaMetaDataUpdateInGadgetDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::MediaMetaDataUpdateInGadgetItem)
{
}

// ------------------------------------------------------------------------
PlaybackActionGadgetDataBindingSource::PlaybackActionGadgetDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::PlaybackActionGadgetItem)
{
}

// ------------------------------------------------------------------------
PlaybackActionCabinAGadgetDataBindingSource::PlaybackActionCabinAGadgetDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::PlaybackActionCabinAGadgetItem)
{
}

// ------------------------------------------------------------------------
PlaybackActionRouterGadgetDataBindingSource::PlaybackActionRouterGadgetDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::PlaybackActionRouterGadgetItem)
{
}

// ------------------------------------------------------------------------
GadgetItemVisibilityStateDataBindingSource::GadgetItemVisibilityStateDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::GadgetItemVisibilityStateItem)
{
}

// ------------------------------------------------------------------------
GadgetPlayPauseOptionDataBindingSource::GadgetPlayPauseOptionDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::GadgetPlayPauseOptionItem)
{
}

// ------------------------------------------------------------------------
MediaSourceUSBNameInGadgetDataBindingSource::MediaSourceUSBNameInGadgetDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::MediaSourceUSBNameInGadgetItem)
{
}

// ------------------------------------------------------------------------
CamportUSBGadgetPlayPauseOptionDataBindingSource::CamportUSBGadgetPlayPauseOptionDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::CamportUSBGadgetPlayPauseOptionItem)
{
}

// ------------------------------------------------------------------------
RouterUSBGadgetPlayPauseOptionDataBindingSource::RouterUSBGadgetPlayPauseOptionDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::RouterUSBGadgetPlayPauseOptionItem)
{
}

// ------------------------------------------------------------------------
ListScrollBarInfoDataBindingSource::ListScrollBarInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::ListScrollBarInfoItem)
{
}

typedef void InvalidData;
struct InvalidDataBindingSource {
    static const ::FeatStd::UInt32 cHierarchyNodeCount = 1;
};

// table of shared DataItemDescriptor
static const ::Courier::Internal::DataBinding::DataItemDescriptor gItemDesc[cDataItemDescriptorCount] = {
    {   // 0 - ::InvalidData
        COURIER_DATA_ITEM_TYPE_ID(::InvalidData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 1 - ::DeviceConnectionData
        COURIER_DATA_ITEM_TYPE_ID(::DeviceConnectionData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 2 - ::DeviceConnectionData::mUSBDeviceName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DeviceConnectionData, mUSBDeviceName)
    },
    {   // 3 - ::DeviceConnectionData::mAppleDeviceName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DeviceConnectionData, mAppleDeviceName)
    },
    {   // 4 - ::DeviceConnectionData::mBTDeviceName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DeviceConnectionData, mBTDeviceName)
    },
    {   // 5 - ::DeviceConnectionData::mSDCardDeviceName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DeviceConnectionData, mSDCardDeviceName)
    },
    {   // 6 - ::BTVisibilityData
        COURIER_DATA_ITEM_TYPE_ID(::BTVisibilityData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 7 - ::BTVisibilityData::mBTIsvisible
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::BTVisibilityData, mBTIsvisible)
    },
    {   // 8 - ::SPIVisibilityData
        COURIER_DATA_ITEM_TYPE_ID(::SPIVisibilityData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 9 - ::SPIVisibilityData::mSPIIsvisible
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SPIVisibilityData, mSPIIsvisible)
    },
    {   // 10 - ::PlaybackActionData
        COURIER_DATA_ITEM_TYPE_ID(::PlaybackActionData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 11 - ::PlaybackActionData::mSourceName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PlaybackActionData, mSourceName)
    },
    {   // 12 - ::PlaybackActionData::mArtistName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PlaybackActionData, mArtistName)
    },
    {   // 13 - ::PlaybackActionData::mTitleName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PlaybackActionData, mTitleName)
    },
    {   // 14 - ::PlaybackActionData::mAlbumName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PlaybackActionData, mAlbumName)
    },
    {   // 15 - ::PlaybackActionData::mVideoName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PlaybackActionData, mVideoName)
    },
    {   // 16 - ::PlaybackActionData::mCurrentTrackNo
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PlaybackActionData, mCurrentTrackNo)
    },
    {   // 17 - ::PlaybackActionData::mTotalTrackNo
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PlaybackActionData, mTotalTrackNo)
    },
    {   // 18 - ::PlaybackActionData::mTotalTime
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PlaybackActionData, mTotalTime)
    },
    {   // 19 - ::PlaybackActionData::mElapsedTime
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PlaybackActionData, mElapsedTime)
    },
    {   // 20 - ::PlaybackActionData::mSliderTotalTime
        COURIER_DATA_ITEM_TYPE_ID(Candera::Float),
        COURIER_ITEM_MEMBER(::PlaybackActionData, mSliderTotalTime)
    },
    {   // 21 - ::PlaybackActionData::mSliderElapsedTime
        COURIER_DATA_ITEM_TYPE_ID(Candera::Float),
        COURIER_ITEM_MEMBER(::PlaybackActionData, mSliderElapsedTime)
    },
    {   // 22 - ::PlaybackActionData::mDragCurrentValue
        COURIER_DATA_ITEM_TYPE_ID( Candera::Float),
        COURIER_ITEM_MEMBER(::PlaybackActionData, mDragCurrentValue)
    },
    {   // 23 - ::PlaybackActionData::mRepeatOption
        COURIER_DATA_ITEM_TYPE_ID(Courier::Int32),
        COURIER_ITEM_MEMBER(::PlaybackActionData, mRepeatOption)
    },
    {   // 24 - ::PlaybackActionData::mShuffleOption
        COURIER_DATA_ITEM_TYPE_ID(Courier::Int32),
        COURIER_ITEM_MEMBER(::PlaybackActionData, mShuffleOption)
    },
    {   // 25 - ::PlaybackActionData::mSeekCurrentPosition
        COURIER_DATA_ITEM_TYPE_ID(Courier::Int32),
        COURIER_ITEM_MEMBER(::PlaybackActionData, mSeekCurrentPosition)
    },
    {   // 26 - ::PlaybackActionData::mPlayIconName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PlaybackActionData, mPlayIconName)
    },
    {   // 27 - ::PlaybackActionData::mRepeatIconName
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::PlaybackActionData, mRepeatIconName)
    },
    {   // 28 - ::PlaybackActionData::mShuffleIconName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PlaybackActionData, mShuffleIconName)
    },
    {   // 29 - ::PlaybackActionData::mDummyImage
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::PlaybackActionData, mDummyImage)
    },
    {   // 30 - ::USBCameraPortPlaybackActionData
        COURIER_DATA_ITEM_TYPE_ID(::USBCameraPortPlaybackActionData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 31 - ::USBCameraPortPlaybackActionData::mSourceName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::USBCameraPortPlaybackActionData, mSourceName)
    },
    {   // 32 - ::USBCameraPortPlaybackActionData::mArtistName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::USBCameraPortPlaybackActionData, mArtistName)
    },
    {   // 33 - ::USBCameraPortPlaybackActionData::mTitleName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::USBCameraPortPlaybackActionData, mTitleName)
    },
    {   // 34 - ::USBCameraPortPlaybackActionData::mAlbumName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::USBCameraPortPlaybackActionData, mAlbumName)
    },
    {   // 35 - ::USBCameraPortPlaybackActionData::mCurrentTrackNo
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::USBCameraPortPlaybackActionData, mCurrentTrackNo)
    },
    {   // 36 - ::USBCameraPortPlaybackActionData::mTotalTime
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::USBCameraPortPlaybackActionData, mTotalTime)
    },
    {   // 37 - ::USBCameraPortPlaybackActionData::mElapsedTime
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::USBCameraPortPlaybackActionData, mElapsedTime)
    },
    {   // 38 - ::USBCameraPortPlaybackActionData::mSliderTotalTime
        COURIER_DATA_ITEM_TYPE_ID(Candera::Float),
        COURIER_ITEM_MEMBER(::USBCameraPortPlaybackActionData, mSliderTotalTime)
    },
    {   // 39 - ::USBCameraPortPlaybackActionData::mSliderElapsedTime
        COURIER_DATA_ITEM_TYPE_ID(Candera::Float),
        COURIER_ITEM_MEMBER(::USBCameraPortPlaybackActionData, mSliderElapsedTime)
    },
    {   // 40 - ::USBCameraPortPlaybackActionData::mDragCurrentValue
        COURIER_DATA_ITEM_TYPE_ID( Candera::Float),
        COURIER_ITEM_MEMBER(::USBCameraPortPlaybackActionData, mDragCurrentValue)
    },
    {   // 41 - ::USBCameraPortPlaybackActionData::mRepeatOption
        COURIER_DATA_ITEM_TYPE_ID(Courier::Int32),
        COURIER_ITEM_MEMBER(::USBCameraPortPlaybackActionData, mRepeatOption)
    },
    {   // 42 - ::USBCameraPortPlaybackActionData::mShuffleOption
        COURIER_DATA_ITEM_TYPE_ID(Courier::Int32),
        COURIER_ITEM_MEMBER(::USBCameraPortPlaybackActionData, mShuffleOption)
    },
    {   // 43 - ::USBCameraPortPlaybackActionData::mPlayIconName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::USBCameraPortPlaybackActionData, mPlayIconName)
    },
    {   // 44 - ::USBCameraPortPlaybackActionData::mRepeatIconName
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::USBCameraPortPlaybackActionData, mRepeatIconName)
    },
    {   // 45 - ::USBCameraPortPlaybackActionData::mShuffleIconName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::USBCameraPortPlaybackActionData, mShuffleIconName)
    },
    {   // 46 - ::USBRouterPlaybackActionData
        COURIER_DATA_ITEM_TYPE_ID(::USBRouterPlaybackActionData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 47 - ::USBRouterPlaybackActionData::mSourceName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::USBRouterPlaybackActionData, mSourceName)
    },
    {   // 48 - ::USBRouterPlaybackActionData::mArtistName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::USBRouterPlaybackActionData, mArtistName)
    },
    {   // 49 - ::USBRouterPlaybackActionData::mTitleName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::USBRouterPlaybackActionData, mTitleName)
    },
    {   // 50 - ::USBRouterPlaybackActionData::mAlbumName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::USBRouterPlaybackActionData, mAlbumName)
    },
    {   // 51 - ::USBRouterPlaybackActionData::mCurrentTrackNo
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::USBRouterPlaybackActionData, mCurrentTrackNo)
    },
    {   // 52 - ::USBRouterPlaybackActionData::mTotalTime
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::USBRouterPlaybackActionData, mTotalTime)
    },
    {   // 53 - ::USBRouterPlaybackActionData::mElapsedTime
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::USBRouterPlaybackActionData, mElapsedTime)
    },
    {   // 54 - ::USBRouterPlaybackActionData::mSliderTotalTime
        COURIER_DATA_ITEM_TYPE_ID(Candera::Float),
        COURIER_ITEM_MEMBER(::USBRouterPlaybackActionData, mSliderTotalTime)
    },
    {   // 55 - ::USBRouterPlaybackActionData::mSliderElapsedTime
        COURIER_DATA_ITEM_TYPE_ID(Candera::Float),
        COURIER_ITEM_MEMBER(::USBRouterPlaybackActionData, mSliderElapsedTime)
    },
    {   // 56 - ::MuteInfoData
        COURIER_DATA_ITEM_TYPE_ID(::MuteInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 57 - ::MuteInfoData::mMuteStatus
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::MuteInfoData, mMuteStatus)
    },
    {   // 58 - ::MuteInfoforAuxData
        COURIER_DATA_ITEM_TYPE_ID(::MuteInfoforAuxData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 59 - ::MuteInfoforAuxData::mMuteStatusforAux
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::MuteInfoforAuxData, mMuteStatusforAux)
    },
    {   // 60 - ::USB2VisibilityData
        COURIER_DATA_ITEM_TYPE_ID(::USB2VisibilityData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 61 - ::USB2VisibilityData::mUSB2Isvisible
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::USB2VisibilityData, mUSB2Isvisible)
    },
    {   // 62 - ::VariantInfoData
        COURIER_DATA_ITEM_TYPE_ID(::VariantInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 63 - ::VariantInfoData::mTA_Settings
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::VariantInfoData, mTA_Settings)
    },
    {   // 64 - ::ExternalMediaSourceData
        COURIER_DATA_ITEM_TYPE_ID(::ExternalMediaSourceData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 65 - ::ExternalMediaSourceData::mEMPMediaSourceVisibility
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::ExternalMediaSourceData, mEMPMediaSourceVisibility)
    },
    {   // 66 - ::ExternalMediaSourceData::mEMPHMIMediaSourceVisibility
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::ExternalMediaSourceData, mEMPHMIMediaSourceVisibility)
    },
    {   // 67 - ::TabVideoSourceData
        COURIER_DATA_ITEM_TYPE_ID(::TabVideoSourceData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 68 - ::TabVideoSourceData::mTabVideoSourceVisibility
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::TabVideoSourceData, mTabVideoSourceVisibility)
    },
    {   // 69 - ::TabVideoSourceData::mTabVideoSourceEnable
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::TabVideoSourceData, mTabVideoSourceEnable)
    },
    {   // 70 - ::BTNowplayIconsData
        COURIER_DATA_ITEM_TYPE_ID(::BTNowplayIconsData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 71 - ::BTNowplayIconsData::mShuffleIconStatus
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::BTNowplayIconsData, mShuffleIconStatus)
    },
    {   // 72 - ::BTNowplayIconsData::mRepeatIconStatus
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::BTNowplayIconsData, mRepeatIconStatus)
    },
    {   // 73 - ::BTNowplayIconsData::mBrowseIconStatus
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::BTNowplayIconsData, mBrowseIconStatus)
    },
    {   // 74 - ::ID3CoverDataForGadgetData
        COURIER_DATA_ITEM_TYPE_ID(::ID3CoverDataForGadgetData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 75 - ::ID3CoverDataForGadgetData::mGadgetImage
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::ID3CoverDataForGadgetData, mGadgetImage)
    },
    {   // 76 - ::ID3CoverDataForCamportUSBGadgetData
        COURIER_DATA_ITEM_TYPE_ID(::ID3CoverDataForCamportUSBGadgetData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 77 - ::ID3CoverDataForCamportUSBGadgetData::mGadgetImage
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::ID3CoverDataForCamportUSBGadgetData, mGadgetImage)
    },
    {   // 78 - ::ID3CoverDataForRouterUSBGadgetData
        COURIER_DATA_ITEM_TYPE_ID(::ID3CoverDataForRouterUSBGadgetData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 79 - ::ID3CoverDataForRouterUSBGadgetData::mGadgetImage
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::ID3CoverDataForRouterUSBGadgetData, mGadgetImage)
    },
    {   // 80 - ::ID3CoverDataForCamportUSBData
        COURIER_DATA_ITEM_TYPE_ID(::ID3CoverDataForCamportUSBData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 81 - ::ID3CoverDataForCamportUSBData::mCamportAlbumImage
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::ID3CoverDataForCamportUSBData, mCamportAlbumImage)
    },
    {   // 82 - ::ID3CoverDataForRouterUSBData
        COURIER_DATA_ITEM_TYPE_ID(::ID3CoverDataForRouterUSBData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 83 - ::ID3CoverDataForRouterUSBData::mRouterAlbumImage
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::ID3CoverDataForRouterUSBData, mRouterAlbumImage)
    },
    {   // 84 - ::AlbumListItemData
        COURIER_DATA_ITEM_TYPE_ID(::AlbumListItemData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 85 - ::AlbumListItemData::mAlbumName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::AlbumListItemData, mAlbumName)
    },
    {   // 86 - ::VideoPlaybackActionData
        COURIER_DATA_ITEM_TYPE_ID(::VideoPlaybackActionData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 87 - ::VideoPlaybackActionData::mVideoTitle
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::VideoPlaybackActionData, mVideoTitle)
    },
    {   // 88 - ::VideoPlaybackActionData::mVideoEpisode
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::VideoPlaybackActionData, mVideoEpisode)
    },
    {   // 89 - ::AppleDeviceData
        COURIER_DATA_ITEM_TYPE_ID(::AppleDeviceData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 90 - ::AppleDeviceData::mSourceName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::AppleDeviceData, mSourceName)
    },
    {   // 91 - ::AppleDeviceData::mArtistName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::AppleDeviceData, mArtistName)
    },
    {   // 92 - ::AppleDeviceData::mTitleName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::AppleDeviceData, mTitleName)
    },
    {   // 93 - ::AppleDeviceData::mAlbumName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::AppleDeviceData, mAlbumName)
    },
    {   // 94 - ::AppleDeviceData::mVideoName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::AppleDeviceData, mVideoName)
    },
    {   // 95 - ::AppleDeviceData::mCurrentTrackNo
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::AppleDeviceData, mCurrentTrackNo)
    },
    {   // 96 - ::AppleDeviceData::mTotalTrackNo
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::AppleDeviceData, mTotalTrackNo)
    },
    {   // 97 - ::AppleDeviceData::mTotalTime
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::AppleDeviceData, mTotalTime)
    },
    {   // 98 - ::AppleDeviceData::mElapsedTime
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::AppleDeviceData, mElapsedTime)
    },
    {   // 99 - ::AppleDeviceData::mSliderTotalTime
        COURIER_DATA_ITEM_TYPE_ID(Candera::Float),
        COURIER_ITEM_MEMBER(::AppleDeviceData, mSliderTotalTime)
    },
    {   // 100 - ::AppleDeviceData::mSliderElapsedTime
        COURIER_DATA_ITEM_TYPE_ID(Candera::Float),
        COURIER_ITEM_MEMBER(::AppleDeviceData, mSliderElapsedTime)
    },
    {   // 101 - ::AppleDeviceData::mDragCurrentValue
        COURIER_DATA_ITEM_TYPE_ID( Candera::Float),
        COURIER_ITEM_MEMBER(::AppleDeviceData, mDragCurrentValue)
    },
    {   // 102 - ::AppleDeviceData::mRepeatOption
        COURIER_DATA_ITEM_TYPE_ID(Courier::Int32),
        COURIER_ITEM_MEMBER(::AppleDeviceData, mRepeatOption)
    },
    {   // 103 - ::AppleDeviceData::mShuffleOption
        COURIER_DATA_ITEM_TYPE_ID(Courier::Int32),
        COURIER_ITEM_MEMBER(::AppleDeviceData, mShuffleOption)
    },
    {   // 104 - ::AppleDeviceData::mSeekCurrentPosition
        COURIER_DATA_ITEM_TYPE_ID(Courier::Int32),
        COURIER_ITEM_MEMBER(::AppleDeviceData, mSeekCurrentPosition)
    },
    {   // 105 - ::AppleDeviceData::mPlayIconName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::AppleDeviceData, mPlayIconName)
    },
    {   // 106 - ::AppleDeviceData::mRepeatIconName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::AppleDeviceData, mRepeatIconName)
    },
    {   // 107 - ::AppleDeviceData::mShuffleIconName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::AppleDeviceData, mShuffleIconName)
    },
    {   // 108 - ::AppleDeviceData::mArtistIcon
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::AppleDeviceData, mArtistIcon)
    },
    {   // 109 - ::IconsData
        COURIER_DATA_ITEM_TYPE_ID(::IconsData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 110 - ::IconsData::mIconArtistFlip
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::IconsData, mIconArtistFlip)
    },
    {   // 111 - ::IconsData::mIconTitleFlip
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::IconsData, mIconTitleFlip)
    },
    {   // 112 - ::IconsData::mIconAlbumFlip
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::IconsData, mIconAlbumFlip)
    },
    {   // 113 - ::IconsVisibilityData
        COURIER_DATA_ITEM_TYPE_ID(::IconsVisibilityData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 114 - ::IconsVisibilityData::mIconArtistVisiblity
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::IconsVisibilityData, mIconArtistVisiblity)
    },
    {   // 115 - ::IconsVisibilityData::mIconArtistPodcastVisiblity
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::IconsVisibilityData, mIconArtistPodcastVisiblity)
    },
    {   // 116 - ::IconsVisibilityData::mIconTitleVisiblity
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::IconsVisibilityData, mIconTitleVisiblity)
    },
    {   // 117 - ::IconsVisibilityData::mIconTitlePodcastVisiblity
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::IconsVisibilityData, mIconTitlePodcastVisiblity)
    },
    {   // 118 - ::IconsVisibilityData::mIconAlbumVisiblity
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::IconsVisibilityData, mIconAlbumVisiblity)
    },
    {   // 119 - ::IconsVisibilityData::mIconAlbumAudioBookVisiblity
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::IconsVisibilityData, mIconAlbumAudioBookVisiblity)
    },
    {   // 120 - ::NavigationVarientTypeData
        COURIER_DATA_ITEM_TYPE_ID(::NavigationVarientTypeData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 121 - ::NavigationVarientTypeData::mNavigationsupportIndex
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::NavigationVarientTypeData, mNavigationsupportIndex)
    },
    {   // 122 - ::ID3CoverDataForAppleData
        COURIER_DATA_ITEM_TYPE_ID(::ID3CoverDataForAppleData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 123 - ::ID3CoverDataForAppleData::mImage
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::ID3CoverDataForAppleData, mImage)
    },
    {   // 124 - ::ID3CoverDataForBTData
        COURIER_DATA_ITEM_TYPE_ID(::ID3CoverDataForBTData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 125 - ::ID3CoverDataForBTData::mImage
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::ID3CoverDataForBTData, mImage)
    },
    {   // 126 - ::SDCardDeviceData
        COURIER_DATA_ITEM_TYPE_ID(::SDCardDeviceData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 127 - ::SDCardDeviceData::mSourceName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SDCardDeviceData, mSourceName)
    },
    {   // 128 - ::SDCardDeviceData::mArtistName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SDCardDeviceData, mArtistName)
    },
    {   // 129 - ::SDCardDeviceData::mTitleName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SDCardDeviceData, mTitleName)
    },
    {   // 130 - ::SDCardDeviceData::mAlbumName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SDCardDeviceData, mAlbumName)
    },
    {   // 131 - ::SDCardDeviceData::mVideoName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SDCardDeviceData, mVideoName)
    },
    {   // 132 - ::SDCardDeviceData::mCurrentTrackNo
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SDCardDeviceData, mCurrentTrackNo)
    },
    {   // 133 - ::SDCardDeviceData::mTotalTrackNo
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SDCardDeviceData, mTotalTrackNo)
    },
    {   // 134 - ::SDCardDeviceData::mTotalTime
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SDCardDeviceData, mTotalTime)
    },
    {   // 135 - ::SDCardDeviceData::mElapsedTime
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SDCardDeviceData, mElapsedTime)
    },
    {   // 136 - ::SDCardDeviceData::mSliderTotalTime
        COURIER_DATA_ITEM_TYPE_ID(Candera::Float),
        COURIER_ITEM_MEMBER(::SDCardDeviceData, mSliderTotalTime)
    },
    {   // 137 - ::SDCardDeviceData::mSliderElapsedTime
        COURIER_DATA_ITEM_TYPE_ID(Candera::Float),
        COURIER_ITEM_MEMBER(::SDCardDeviceData, mSliderElapsedTime)
    },
    {   // 138 - ::SDCardDeviceData::mDragCurrentValue
        COURIER_DATA_ITEM_TYPE_ID( Candera::Float),
        COURIER_ITEM_MEMBER(::SDCardDeviceData, mDragCurrentValue)
    },
    {   // 139 - ::SDCardDeviceData::mRepeatOption
        COURIER_DATA_ITEM_TYPE_ID(Courier::Int32),
        COURIER_ITEM_MEMBER(::SDCardDeviceData, mRepeatOption)
    },
    {   // 140 - ::SDCardDeviceData::mShuffleOption
        COURIER_DATA_ITEM_TYPE_ID(Courier::Int32),
        COURIER_ITEM_MEMBER(::SDCardDeviceData, mShuffleOption)
    },
    {   // 141 - ::SDCardDeviceData::mSeekCurrentPosition
        COURIER_DATA_ITEM_TYPE_ID(Courier::Int32),
        COURIER_ITEM_MEMBER(::SDCardDeviceData, mSeekCurrentPosition)
    },
    {   // 142 - ::SDCardDeviceData::mPlayIconName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SDCardDeviceData, mPlayIconName)
    },
    {   // 143 - ::SDCardDeviceData::mRepeatIconName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SDCardDeviceData, mRepeatIconName)
    },
    {   // 144 - ::SDCardDeviceData::mShuffleIconName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SDCardDeviceData, mShuffleIconName)
    },
    {   // 145 - ::ID3CoverDataForSDCardData
        COURIER_DATA_ITEM_TYPE_ID(::ID3CoverDataForSDCardData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 146 - ::ID3CoverDataForSDCardData::mImage
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::ID3CoverDataForSDCardData, mImage)
    },
    {   // 147 - ::VideoPlayerFullScreeenData
        COURIER_DATA_ITEM_TYPE_ID(::VideoPlayerFullScreeenData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 148 - ::VideoPlayerFullScreeenData::mPlayIconName
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::VideoPlayerFullScreeenData, mPlayIconName)
    },
    {   // 149 - ::IpodButtonData
        COURIER_DATA_ITEM_TYPE_ID(::IpodButtonData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 150 - ::IpodButtonData::mi8IsActive
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::IpodButtonData, mi8IsActive)
    },
    {   // 151 - ::AuxButtonData
        COURIER_DATA_ITEM_TYPE_ID(::AuxButtonData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 152 - ::AuxButtonData::mi8IsActive
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::AuxButtonData, mi8IsActive)
    },
    {   // 153 - ::USBButtonData
        COURIER_DATA_ITEM_TYPE_ID(::USBButtonData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 154 - ::USBButtonData::mi8IsActive
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::USBButtonData, mi8IsActive)
    },
    {   // 155 - ::USB1ButtonData
        COURIER_DATA_ITEM_TYPE_ID(::USB1ButtonData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 156 - ::USB1ButtonData::misConnectedWithHub
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::USB1ButtonData, misConnectedWithHub)
    },
    {   // 157 - ::USB2ButtonData
        COURIER_DATA_ITEM_TYPE_ID(::USB2ButtonData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 158 - ::USB2ButtonData::mi8IsActive
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::USB2ButtonData, mi8IsActive)
    },
    {   // 159 - ::SDCardButtonData
        COURIER_DATA_ITEM_TYPE_ID(::SDCardButtonData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 160 - ::SDCardButtonData::mi8IsActive
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::SDCardButtonData, mi8IsActive)
    },
    {   // 161 - ::BTButtonData
        COURIER_DATA_ITEM_TYPE_ID(::BTButtonData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 162 - ::BTButtonData::mi8IsActive
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::BTButtonData, mi8IsActive)
    },
    {   // 163 - ::ExternalDVDButtonData
        COURIER_DATA_ITEM_TYPE_ID(::ExternalDVDButtonData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 164 - ::ExternalDVDButtonData::mi8IsActive
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::ExternalDVDButtonData, mi8IsActive)
    },
    {   // 165 - ::Camport1USBButtonData
        COURIER_DATA_ITEM_TYPE_ID(::Camport1USBButtonData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 166 - ::Camport1USBButtonData::mi8IsActive
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::Camport1USBButtonData, mi8IsActive)
    },
    {   // 167 - ::Camport1HDMIButtonData
        COURIER_DATA_ITEM_TYPE_ID(::Camport1HDMIButtonData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 168 - ::Camport1HDMIButtonData::mi8IsActive
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::Camport1HDMIButtonData, mi8IsActive)
    },
    {   // 169 - ::ExternalDVDStatusData
        COURIER_DATA_ITEM_TYPE_ID(::ExternalDVDStatusData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 170 - ::ExternalDVDStatusData::mi8IsChecked
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::ExternalDVDStatusData, mi8IsChecked)
    },
    {   // 171 - ::TAStatusData
        COURIER_DATA_ITEM_TYPE_ID(::TAStatusData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 172 - ::TAStatusData::mi8IsChecked
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::TAStatusData, mi8IsChecked)
    },
    {   // 173 - ::AUXStatusData
        COURIER_DATA_ITEM_TYPE_ID(::AUXStatusData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 174 - ::AUXStatusData::mi8IsChecked
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::AUXStatusData, mi8IsChecked)
    },
    {   // 175 - ::SDCardStatusData
        COURIER_DATA_ITEM_TYPE_ID(::SDCardStatusData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 176 - ::SDCardStatusData::mi8IsChecked
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::SDCardStatusData, mi8IsChecked)
    },
    {   // 177 - ::TitleTabData
        COURIER_DATA_ITEM_TYPE_ID(::TitleTabData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 178 - ::TitleTabData::mi8IsActive
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::TitleTabData, mi8IsActive)
    },
    {   // 179 - ::ArtistTabData
        COURIER_DATA_ITEM_TYPE_ID(::ArtistTabData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 180 - ::ArtistTabData::mi8IsActive
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::ArtistTabData, mi8IsActive)
    },
    {   // 181 - ::AlbumTabData
        COURIER_DATA_ITEM_TYPE_ID(::AlbumTabData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 182 - ::AlbumTabData::mi8IsActive
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::AlbumTabData, mi8IsActive)
    },
    {   // 183 - ::GenreTabData
        COURIER_DATA_ITEM_TYPE_ID(::GenreTabData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 184 - ::GenreTabData::mi8IsActive
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::GenreTabData, mi8IsActive)
    },
    {   // 185 - ::FolderTabData
        COURIER_DATA_ITEM_TYPE_ID(::FolderTabData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 186 - ::FolderTabData::mi8IsActive
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::FolderTabData, mi8IsActive)
    },
    {   // 187 - ::PlaylistTabData
        COURIER_DATA_ITEM_TYPE_ID(::PlaylistTabData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 188 - ::PlaylistTabData::mi8IsActive
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::PlaylistTabData, mi8IsActive)
    },
    {   // 189 - ::AudiobookTabData
        COURIER_DATA_ITEM_TYPE_ID(::AudiobookTabData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 190 - ::AudiobookTabData::mi8IsActive
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::AudiobookTabData, mi8IsActive)
    },
    {   // 191 - ::PodcastTabData
        COURIER_DATA_ITEM_TYPE_ID(::PodcastTabData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 192 - ::PodcastTabData::mi8IsActive
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::PodcastTabData, mi8IsActive)
    },
    {   // 193 - ::VideoTabData
        COURIER_DATA_ITEM_TYPE_ID(::VideoTabData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 194 - ::VideoTabData::mi8IsActive
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::VideoTabData, mi8IsActive)
    },
    {   // 195 - ::ExternalDVDVisibililtyData
        COURIER_DATA_ITEM_TYPE_ID(::ExternalDVDVisibililtyData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 196 - ::ExternalDVDVisibililtyData::mi8Isvisible
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::ExternalDVDVisibililtyData, mi8Isvisible)
    },
    {   // 197 - ::AUXVisibilityData
        COURIER_DATA_ITEM_TYPE_ID(::AUXVisibilityData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 198 - ::AUXVisibilityData::mi8Isvisible
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::AUXVisibilityData, mi8Isvisible)
    },
    {   // 199 - ::SDCardVisibilityData
        COURIER_DATA_ITEM_TYPE_ID(::SDCardVisibilityData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 200 - ::SDCardVisibilityData::mi8Isvisible
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SDCardVisibilityData, mi8Isvisible)
    },
    {   // 201 - ::TAIconStatusData
        COURIER_DATA_ITEM_TYPE_ID(::TAIconStatusData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 202 - ::TAIconStatusData::mTAIconIndex
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt16),
        COURIER_ITEM_MEMBER(::TAIconStatusData, mTAIconIndex)
    },
    {   // 203 - ::DeviceConnectStatusData
        COURIER_DATA_ITEM_TYPE_ID(::DeviceConnectStatusData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 204 - ::DeviceConnectStatusData::mMediaMessage1
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DeviceConnectStatusData, mMediaMessage1)
    },
    {   // 205 - ::DeviceConnectStatusData::mMediaMessage2
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DeviceConnectStatusData, mMediaMessage2)
    },
    {   // 206 - ::DeviceConnectStatusData::mMediaMessage3
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DeviceConnectStatusData, mMediaMessage3)
    },
    {   // 207 - ::DeviceConnectStatusData::mMediaMessage4
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DeviceConnectStatusData, mMediaMessage4)
    },
    {   // 208 - ::DeviceConnectStatusData::mMessage1Visible
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::DeviceConnectStatusData, mMessage1Visible)
    },
    {   // 209 - ::DeviceConnectStatusData::mMessage2Visible
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::DeviceConnectStatusData, mMessage2Visible)
    },
    {   // 210 - ::DeviceConnectStatusData::mMessage3Visible
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::DeviceConnectStatusData, mMessage3Visible)
    },
    {   // 211 - ::DeviceConnectStatusData::mMessage4Visible
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::DeviceConnectStatusData, mMessage4Visible)
    },
    {   // 212 - ::DeviceConnectStatusData::mMediaMessageUpdateFlag
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::DeviceConnectStatusData, mMediaMessageUpdateFlag)
    },
    {   // 213 - ::DeviceConnectStatusData::mMediaMessageDeviceConnected
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DeviceConnectStatusData, mMediaMessageDeviceConnected)
    },
    {   // 214 - ::DeviceConnectStatusData::mMediaMessageDeviceDisconnected
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DeviceConnectStatusData, mMediaMessageDeviceDisconnected)
    },
    {   // 215 - ::DeviceConnectStatusData::mMediaMessageNoDevice
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DeviceConnectStatusData, mMediaMessageNoDevice)
    },
    {   // 216 - ::DeviceConnectStatusData::mMessageDeviceConnectedVisible
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::DeviceConnectStatusData, mMessageDeviceConnectedVisible)
    },
    {   // 217 - ::DeviceConnectStatusData::mMessageDeviceDisconnectedVisible
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::DeviceConnectStatusData, mMessageDeviceDisconnectedVisible)
    },
    {   // 218 - ::DeviceConnectStatusData::mMessageNoDeviceVisible
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::DeviceConnectStatusData, mMessageNoDeviceVisible)
    },
    {   // 219 - ::DeviceConnectStatusData::mMediamessageIconindex
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::DeviceConnectStatusData, mMediamessageIconindex)
    },
    {   // 220 - ::DeviceConnectStatusData::mMediamessageIconVisibleState
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::DeviceConnectStatusData, mMediamessageIconVisibleState)
    },
    {   // 221 - ::ExternalDeviceConnectedData
        COURIER_DATA_ITEM_TYPE_ID(::ExternalDeviceConnectedData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 222 - ::ExternalDeviceConnectedData::mDbDownloadDevice
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::ExternalDeviceConnectedData, mDbDownloadDevice)
    },
    {   // 223 - ::DBInPreparationData
        COURIER_DATA_ITEM_TYPE_ID(::DBInPreparationData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 224 - ::DBInPreparationData::mDeviceType
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DBInPreparationData, mDeviceType)
    },
    {   // 225 - ::DBDownloadErrorData
        COURIER_DATA_ITEM_TYPE_ID(::DBDownloadErrorData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 226 - ::DBDownloadErrorData::mExternalDeviceType
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DBDownloadErrorData, mExternalDeviceType)
    },
    {   // 227 - ::DeviceNameAndStatusData
        COURIER_DATA_ITEM_TYPE_ID(::DeviceNameAndStatusData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 228 - ::DeviceNameAndStatusData::mBTDeviceMuteStatus
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DeviceNameAndStatusData, mBTDeviceMuteStatus)
    },
    {   // 229 - ::DeviceNameAndStatusData::mAUXMuteStatus
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DeviceNameAndStatusData, mAUXMuteStatus)
    },
    {   // 230 - ::DeviceNameAndStatusData::mExternalDVDMuteStatus
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DeviceNameAndStatusData, mExternalDVDMuteStatus)
    },
    {   // 231 - ::BrowseListSizeData
        COURIER_DATA_ITEM_TYPE_ID(::BrowseListSizeData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 232 - ::BrowseListSizeData::mArtistWindowListSize
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::BrowseListSizeData, mArtistWindowListSize)
    },
    {   // 233 - ::BrowseListSizeData::mAlbumWindowListSize
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::BrowseListSizeData, mAlbumWindowListSize)
    },
    {   // 234 - ::BrowseListSizeData::mGenreWindowListSize
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::BrowseListSizeData, mGenreWindowListSize)
    },
    {   // 235 - ::BrowseListSizeData::mPodcastWindowListSize
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::BrowseListSizeData, mPodcastWindowListSize)
    },
    {   // 236 - ::BrowseListSizeData::mVideoWindowListSize
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::BrowseListSizeData, mVideoWindowListSize)
    },
    {   // 237 - ::BrowseListSelectedLineData
        COURIER_DATA_ITEM_TYPE_ID(::BrowseListSelectedLineData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 238 - ::BrowseListSelectedLineData::mArtistSelected
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::BrowseListSelectedLineData, mArtistSelected)
    },
    {   // 239 - ::BrowseListSelectedLineData::mAlbumSelected
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::BrowseListSelectedLineData, mAlbumSelected)
    },
    {   // 240 - ::BrowseListSelectedLineData::mGenreSelected
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::BrowseListSelectedLineData, mGenreSelected)
    },
    {   // 241 - ::BrowseListSelectedLineData::mPodcastSelected
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::BrowseListSelectedLineData, mPodcastSelected)
    },
    {   // 242 - ::BrowseListSelectedLineData::mVideoSelected
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::BrowseListSelectedLineData, mVideoSelected)
    },
    {   // 243 - ::Artist_AlbumListSizeData
        COURIER_DATA_ITEM_TYPE_ID(::Artist_AlbumListSizeData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 244 - ::Artist_AlbumListSizeData::mArtist_AlbumWindowListSize
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::Artist_AlbumListSizeData, mArtist_AlbumWindowListSize)
    },
    {   // 245 - ::Artist_AlbumListSelectedLineData
        COURIER_DATA_ITEM_TYPE_ID(::Artist_AlbumListSelectedLineData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 246 - ::Artist_AlbumListSelectedLineData::mArtist_AlbumSelected
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::Artist_AlbumListSelectedLineData, mArtist_AlbumSelected)
    },
    {   // 247 - ::Artist_Album_TitleListSizeData
        COURIER_DATA_ITEM_TYPE_ID(::Artist_Album_TitleListSizeData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 248 - ::Artist_Album_TitleListSizeData::mArtistAlbumTitleWindowListSize
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::Artist_Album_TitleListSizeData, mArtistAlbumTitleWindowListSize)
    },
    {   // 249 - ::Artist_Album_TitleListSelectedLineData
        COURIER_DATA_ITEM_TYPE_ID(::Artist_Album_TitleListSelectedLineData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 250 - ::Artist_Album_TitleListSelectedLineData::mArtistAlbumTitleSelected
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::Artist_Album_TitleListSelectedLineData, mArtistAlbumTitleSelected)
    },
    {   // 251 - ::Album_TitleListSizeData
        COURIER_DATA_ITEM_TYPE_ID(::Album_TitleListSizeData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 252 - ::Album_TitleListSizeData::mAlbumTitleWindowListSize
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::Album_TitleListSizeData, mAlbumTitleWindowListSize)
    },
    {   // 253 - ::Album_TitleListSelectedLineData
        COURIER_DATA_ITEM_TYPE_ID(::Album_TitleListSelectedLineData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 254 - ::Album_TitleListSelectedLineData::mAlbumTitleSelected
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::Album_TitleListSelectedLineData, mAlbumTitleSelected)
    },
    {   // 255 - ::Title_ListSizeData
        COURIER_DATA_ITEM_TYPE_ID(::Title_ListSizeData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 256 - ::Title_ListSizeData::mTitleWindowListSize
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::Title_ListSizeData, mTitleWindowListSize)
    },
    {   // 257 - ::TitleListSelectedLineData
        COURIER_DATA_ITEM_TYPE_ID(::TitleListSelectedLineData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 258 - ::TitleListSelectedLineData::mTitleListSelectedLine
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::TitleListSelectedLineData, mTitleListSelectedLine)
    },
    {   // 259 - ::Genre_ArtistListSizeData
        COURIER_DATA_ITEM_TYPE_ID(::Genre_ArtistListSizeData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 260 - ::Genre_ArtistListSizeData::mGenreArtistWindowListSize
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::Genre_ArtistListSizeData, mGenreArtistWindowListSize)
    },
    {   // 261 - ::Genre_ArtistListSelectedLineData
        COURIER_DATA_ITEM_TYPE_ID(::Genre_ArtistListSelectedLineData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 262 - ::Genre_ArtistListSelectedLineData::mGenreArtistSelected
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::Genre_ArtistListSelectedLineData, mGenreArtistSelected)
    },
    {   // 263 - ::Genre_AllAlbumsListSizeData
        COURIER_DATA_ITEM_TYPE_ID(::Genre_AllAlbumsListSizeData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 264 - ::Genre_AllAlbumsListSizeData::mGenreAllAlbumsWindowListSize
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::Genre_AllAlbumsListSizeData, mGenreAllAlbumsWindowListSize)
    },
    {   // 265 - ::Genre_AllAlbumsListSelectedLineData
        COURIER_DATA_ITEM_TYPE_ID(::Genre_AllAlbumsListSelectedLineData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 266 - ::Genre_AllAlbumsListSelectedLineData::mGenreAllAlbumsSelected
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::Genre_AllAlbumsListSelectedLineData, mGenreAllAlbumsSelected)
    },
    {   // 267 - ::Genre_Artist_AlbumListSizeData
        COURIER_DATA_ITEM_TYPE_ID(::Genre_Artist_AlbumListSizeData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 268 - ::Genre_Artist_AlbumListSizeData::mGenreArtistAlbumWindowListSize
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::Genre_Artist_AlbumListSizeData, mGenreArtistAlbumWindowListSize)
    },
    {   // 269 - ::Genre_Artist_AlbumListSelectedLineData
        COURIER_DATA_ITEM_TYPE_ID(::Genre_Artist_AlbumListSelectedLineData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 270 - ::Genre_Artist_AlbumListSelectedLineData::mGenreArtistAlbumSelected
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::Genre_Artist_AlbumListSelectedLineData, mGenreArtistAlbumSelected)
    },
    {   // 271 - ::Genre_TitleListSizeData
        COURIER_DATA_ITEM_TYPE_ID(::Genre_TitleListSizeData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 272 - ::Genre_TitleListSizeData::mGenreTitleWindowListSize
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::Genre_TitleListSizeData, mGenreTitleWindowListSize)
    },
    {   // 273 - ::Genre_TitleListSelectedLineData
        COURIER_DATA_ITEM_TYPE_ID(::Genre_TitleListSelectedLineData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 274 - ::Genre_TitleListSelectedLineData::mGenreTitleSelected
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::Genre_TitleListSelectedLineData, mGenreTitleSelected)
    },
    {   // 275 - ::FastForwardRewindPopupData
        COURIER_DATA_ITEM_TYPE_ID(::FastForwardRewindPopupData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 276 - ::FastForwardRewindPopupData::mFastForwardRewindText
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::FastForwardRewindPopupData, mFastForwardRewindText)
    },
    {   // 277 - ::FastForwardRewindPopupData::mCurrentValue
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::FastForwardRewindPopupData, mCurrentValue)
    },
    {   // 278 - ::BTShuffleData
        COURIER_DATA_ITEM_TYPE_ID(::BTShuffleData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 279 - ::BTShuffleData::mBTShuffleOption
        COURIER_DATA_ITEM_TYPE_ID(Courier::Int32),
        COURIER_ITEM_MEMBER(::BTShuffleData, mBTShuffleOption)
    },
    {   // 280 - ::BTShuffleData::mBTShuffleIconName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::BTShuffleData, mBTShuffleIconName)
    },
    {   // 281 - ::BTRepeatData
        COURIER_DATA_ITEM_TYPE_ID(::BTRepeatData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 282 - ::BTRepeatData::mBTRepeatOption
        COURIER_DATA_ITEM_TYPE_ID(Courier::Int32),
        COURIER_ITEM_MEMBER(::BTRepeatData, mBTRepeatOption)
    },
    {   // 283 - ::BTRepeatData::mBTRepeatIconName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::BTRepeatData, mBTRepeatIconName)
    },
    {   // 284 - ::BTPlayInfoUpdateData
        COURIER_DATA_ITEM_TYPE_ID(::BTPlayInfoUpdateData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 285 - ::BTPlayInfoUpdateData::mSourceName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::BTPlayInfoUpdateData, mSourceName)
    },
    {   // 286 - ::BTPlayInfoUpdateData::mArtistName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::BTPlayInfoUpdateData, mArtistName)
    },
    {   // 287 - ::BTPlayInfoUpdateData::mTitleName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::BTPlayInfoUpdateData, mTitleName)
    },
    {   // 288 - ::BTPlayInfoUpdateData::mAlbumName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::BTPlayInfoUpdateData, mAlbumName)
    },
    {   // 289 - ::BTPlayInfoUpdateData::mCurrentTrackNo
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::BTPlayInfoUpdateData, mCurrentTrackNo)
    },
    {   // 290 - ::BTPlayInfoUpdateData::mTotalTrackNo
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::BTPlayInfoUpdateData, mTotalTrackNo)
    },
    {   // 291 - ::BTPlayInfoUpdateData::mTotalTime
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::BTPlayInfoUpdateData, mTotalTime)
    },
    {   // 292 - ::BTPlayInfoUpdateData::mElapsedTime
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::BTPlayInfoUpdateData, mElapsedTime)
    },
    {   // 293 - ::BTPlayInfoUpdateData::mSliderTotalTime
        COURIER_DATA_ITEM_TYPE_ID(Candera::Float),
        COURIER_ITEM_MEMBER(::BTPlayInfoUpdateData, mSliderTotalTime)
    },
    {   // 294 - ::BTPlayInfoUpdateData::mSliderElapsedTime
        COURIER_DATA_ITEM_TYPE_ID(Candera::Float),
        COURIER_ITEM_MEMBER(::BTPlayInfoUpdateData, mSliderElapsedTime)
    },
    {   // 295 - ::BTPlayInfoUpdateData::mDragCurrentValue
        COURIER_DATA_ITEM_TYPE_ID( Candera::Float),
        COURIER_ITEM_MEMBER(::BTPlayInfoUpdateData, mDragCurrentValue)
    },
    {   // 296 - ::BTPlayInfoUpdateData::mPlayIconName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::BTPlayInfoUpdateData, mPlayIconName)
    },
    {   // 297 - ::BTSliderVisibilityData
        COURIER_DATA_ITEM_TYPE_ID(::BTSliderVisibilityData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 298 - ::BTSliderVisibilityData::mi8Isvisible
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::BTSliderVisibilityData, mi8Isvisible)
    },
    {   // 299 - ::BTTotalTimeVisibilityData
        COURIER_DATA_ITEM_TYPE_ID(::BTTotalTimeVisibilityData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 300 - ::BTTotalTimeVisibilityData::mi8Isvisible
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::BTTotalTimeVisibilityData, mi8Isvisible)
    },
    {   // 301 - ::BTElapsedTimeVisibilityData
        COURIER_DATA_ITEM_TYPE_ID(::BTElapsedTimeVisibilityData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 302 - ::BTElapsedTimeVisibilityData::mi8Isvisible
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::BTElapsedTimeVisibilityData, mi8Isvisible)
    },
    {   // 303 - ::ID3CoverDataData
        COURIER_DATA_ITEM_TYPE_ID(::ID3CoverDataData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 304 - ::ID3CoverDataData::mImage
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::ID3CoverDataData, mImage)
    },
    {   // 305 - ::Audiobook_ListSizeData
        COURIER_DATA_ITEM_TYPE_ID(::Audiobook_ListSizeData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 306 - ::Audiobook_ListSizeData::mAudiobookWindowListSize
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::Audiobook_ListSizeData, mAudiobookWindowListSize)
    },
    {   // 307 - ::AudiobookListSelectedLineData
        COURIER_DATA_ITEM_TYPE_ID(::AudiobookListSelectedLineData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 308 - ::AudiobookListSelectedLineData::mAudiobookListSelectedLine
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::AudiobookListSelectedLineData, mAudiobookListSelectedLine)
    },
    {   // 309 - ::AudiobookChapter_ListSizeData
        COURIER_DATA_ITEM_TYPE_ID(::AudiobookChapter_ListSizeData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 310 - ::AudiobookChapter_ListSizeData::mAudiobookChapterWindowListSize
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::AudiobookChapter_ListSizeData, mAudiobookChapterWindowListSize)
    },
    {   // 311 - ::AudiobookChapterListSelectedLineData
        COURIER_DATA_ITEM_TYPE_ID(::AudiobookChapterListSelectedLineData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 312 - ::AudiobookChapterListSelectedLineData::mAudiobookChapterListSelectedLine
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::AudiobookChapterListSelectedLineData, mAudiobookChapterListSelectedLine)
    },
    {   // 313 - ::Playlist_ListSizeData
        COURIER_DATA_ITEM_TYPE_ID(::Playlist_ListSizeData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 314 - ::Playlist_ListSizeData::mPlaylistWindowListSize
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::Playlist_ListSizeData, mPlaylistWindowListSize)
    },
    {   // 315 - ::PlaylistListSelectedLineData
        COURIER_DATA_ITEM_TYPE_ID(::PlaylistListSelectedLineData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 316 - ::PlaylistListSelectedLineData::mPlaylistListSelectedLine
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::PlaylistListSelectedLineData, mPlaylistListSelectedLine)
    },
    {   // 317 - ::PlaylistTitle_ListSizeData
        COURIER_DATA_ITEM_TYPE_ID(::PlaylistTitle_ListSizeData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 318 - ::PlaylistTitle_ListSizeData::mPlaylistTitleWindowListSize
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::PlaylistTitle_ListSizeData, mPlaylistTitleWindowListSize)
    },
    {   // 319 - ::PlaylistTitleListSelectedLineData
        COURIER_DATA_ITEM_TYPE_ID(::PlaylistTitleListSelectedLineData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 320 - ::PlaylistTitleListSelectedLineData::mPlaylistTitleListSelectedLine
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::PlaylistTitleListSelectedLineData, mPlaylistTitleListSelectedLine)
    },
    {   // 321 - ::Podcast_EpisodeListSizeData
        COURIER_DATA_ITEM_TYPE_ID(::Podcast_EpisodeListSizeData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 322 - ::Podcast_EpisodeListSizeData::mPodcastEpisodeWindowListSize
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::Podcast_EpisodeListSizeData, mPodcastEpisodeWindowListSize)
    },
    {   // 323 - ::Podcast_EpisodeListSelectedLineData
        COURIER_DATA_ITEM_TYPE_ID(::Podcast_EpisodeListSelectedLineData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 324 - ::Podcast_EpisodeListSelectedLineData::mPodcastEpisodeSelected
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::Podcast_EpisodeListSelectedLineData, mPodcastEpisodeSelected)
    },
    {   // 325 - ::Video_EpisodeListSizeData
        COURIER_DATA_ITEM_TYPE_ID(::Video_EpisodeListSizeData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 326 - ::Video_EpisodeListSizeData::mVideoEpisodeWindowListSize
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::Video_EpisodeListSizeData, mVideoEpisodeWindowListSize)
    },
    {   // 327 - ::Video_EpisodeListSelectedLineData
        COURIER_DATA_ITEM_TYPE_ID(::Video_EpisodeListSelectedLineData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 328 - ::Video_EpisodeListSelectedLineData::mVideoEpisodeSelected
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::Video_EpisodeListSelectedLineData, mVideoEpisodeSelected)
    },
    {   // 329 - ::Folder_ListSizeData
        COURIER_DATA_ITEM_TYPE_ID(::Folder_ListSizeData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 330 - ::Folder_ListSizeData::mFolderWindowListSize
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::Folder_ListSizeData, mFolderWindowListSize)
    },
    {   // 331 - ::Folder_ListSelectedLineData
        COURIER_DATA_ITEM_TYPE_ID(::Folder_ListSelectedLineData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 332 - ::Folder_ListSelectedLineData::mFolderSelected
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::Folder_ListSelectedLineData, mFolderSelected)
    },
    {   // 333 - ::FolderFile_ListSizeData
        COURIER_DATA_ITEM_TYPE_ID(::FolderFile_ListSizeData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 334 - ::FolderFile_ListSizeData::mFolderFile_WindowListSize
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::FolderFile_ListSizeData, mFolderFile_WindowListSize)
    },
    {   // 335 - ::FolderFile_ListSelectedLineData
        COURIER_DATA_ITEM_TYPE_ID(::FolderFile_ListSelectedLineData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 336 - ::FolderFile_ListSelectedLineData::mFolderFileSelected
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::FolderFile_ListSelectedLineData, mFolderFileSelected)
    },
    {   // 337 - ::Folder_NameData
        COURIER_DATA_ITEM_TYPE_ID(::Folder_NameData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 338 - ::Folder_NameData::mFolderFileName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Folder_NameData, mFolderFileName)
    },
    {   // 339 - ::NotebookdataData
        COURIER_DATA_ITEM_TYPE_ID(::NotebookdataData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 340 - ::NotebookdataData::mCurrentTab
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::NotebookdataData, mCurrentTab)
    },
    {   // 341 - ::TabNextPrevIndexData
        COURIER_DATA_ITEM_TYPE_ID(::TabNextPrevIndexData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 342 - ::TabNextPrevIndexData::mNextIndex
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::TabNextPrevIndexData, mNextIndex)
    },
    {   // 343 - ::TabNextPrevIndexData::mPrevIndex
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::TabNextPrevIndexData, mPrevIndex)
    },
    {   // 344 - ::TabNextPrevIndexData::mEnableTouchNext
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::TabNextPrevIndexData, mEnableTouchNext)
    },
    {   // 345 - ::TabNextPrevIndexData::mEnableTouchPrev
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::TabNextPrevIndexData, mEnableTouchPrev)
    },
    {   // 346 - ::ListstatusData
        COURIER_DATA_ITEM_TYPE_ID(::ListstatusData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 347 - ::ListstatusData::mViewportstartIndexAlbum
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt32),
        COURIER_ITEM_MEMBER(::ListstatusData, mViewportstartIndexAlbum)
    },
    {   // 348 - ::ListstatusData::mViewportstartIndexAlbum_song
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt32),
        COURIER_ITEM_MEMBER(::ListstatusData, mViewportstartIndexAlbum_song)
    },
    {   // 349 - ::ListstatusData::mViewportstartIndexArtist
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt32),
        COURIER_ITEM_MEMBER(::ListstatusData, mViewportstartIndexArtist)
    },
    {   // 350 - ::ListstatusData::mViewportstartIndexArtist_Album
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt32),
        COURIER_ITEM_MEMBER(::ListstatusData, mViewportstartIndexArtist_Album)
    },
    {   // 351 - ::ListstatusData::mViewportstartIndexArtist_Album_Song
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt32),
        COURIER_ITEM_MEMBER(::ListstatusData, mViewportstartIndexArtist_Album_Song)
    },
    {   // 352 - ::ListstatusData::mViewportstartIndexArtist_Song
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt32),
        COURIER_ITEM_MEMBER(::ListstatusData, mViewportstartIndexArtist_Song)
    },
    {   // 353 - ::ListstatusData::mViewportstartIndexAudiobook
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt32),
        COURIER_ITEM_MEMBER(::ListstatusData, mViewportstartIndexAudiobook)
    },
    {   // 354 - ::ListstatusData::mViewportstartIndexAudiobooktitle_Chapter
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt32),
        COURIER_ITEM_MEMBER(::ListstatusData, mViewportstartIndexAudiobooktitle_Chapter)
    },
    {   // 355 - ::ListstatusData::mViewportstartIndexFolder
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt32),
        COURIER_ITEM_MEMBER(::ListstatusData, mViewportstartIndexFolder)
    },
    {   // 356 - ::ListstatusData::mViewportstartIndexFolder_File
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt32),
        COURIER_ITEM_MEMBER(::ListstatusData, mViewportstartIndexFolder_File)
    },
    {   // 357 - ::ListstatusData::mViewportstartIndexGenre
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt32),
        COURIER_ITEM_MEMBER(::ListstatusData, mViewportstartIndexGenre)
    },
    {   // 358 - ::ListstatusData::mViewportstartIndexGenre_Album
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt32),
        COURIER_ITEM_MEMBER(::ListstatusData, mViewportstartIndexGenre_Album)
    },
    {   // 359 - ::ListstatusData::mViewportstartIndexGenre_Album_Song
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt32),
        COURIER_ITEM_MEMBER(::ListstatusData, mViewportstartIndexGenre_Album_Song)
    },
    {   // 360 - ::ListstatusData::mViewportstartIndexGenre_Artist
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt32),
        COURIER_ITEM_MEMBER(::ListstatusData, mViewportstartIndexGenre_Artist)
    },
    {   // 361 - ::ListstatusData::mViewportstartIndexGenre_Artist_Album
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt32),
        COURIER_ITEM_MEMBER(::ListstatusData, mViewportstartIndexGenre_Artist_Album)
    },
    {   // 362 - ::ListstatusData::mViewportstartIndexGenre_Artist_Album_Song
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt32),
        COURIER_ITEM_MEMBER(::ListstatusData, mViewportstartIndexGenre_Artist_Album_Song)
    },
    {   // 363 - ::ListstatusData::mViewportstartIndexGenre_Artist_Song
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt32),
        COURIER_ITEM_MEMBER(::ListstatusData, mViewportstartIndexGenre_Artist_Song)
    },
    {   // 364 - ::ListstatusData::mViewportstartIndexPlaylist
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt32),
        COURIER_ITEM_MEMBER(::ListstatusData, mViewportstartIndexPlaylist)
    },
    {   // 365 - ::ListstatusData::mViewportstartIndexPlaylist_Song
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt32),
        COURIER_ITEM_MEMBER(::ListstatusData, mViewportstartIndexPlaylist_Song)
    },
    {   // 366 - ::ListstatusData::mViewportstartIndexPodcast
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt32),
        COURIER_ITEM_MEMBER(::ListstatusData, mViewportstartIndexPodcast)
    },
    {   // 367 - ::ListstatusData::mViewportstartIndexPodcast_Episode
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt32),
        COURIER_ITEM_MEMBER(::ListstatusData, mViewportstartIndexPodcast_Episode)
    },
    {   // 368 - ::ListstatusData::mViewportstartIndexSong
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt32),
        COURIER_ITEM_MEMBER(::ListstatusData, mViewportstartIndexSong)
    },
    {   // 369 - ::ListstatusData::mViewportstartIndexVideo
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt32),
        COURIER_ITEM_MEMBER(::ListstatusData, mViewportstartIndexVideo)
    },
    {   // 370 - ::ListstatusData::mViewportstartIndexVideo_Episode
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt32),
        COURIER_ITEM_MEMBER(::ListstatusData, mViewportstartIndexVideo_Episode)
    },
    {   // 371 - ::SDRepeatOptionData
        COURIER_DATA_ITEM_TYPE_ID(::SDRepeatOptionData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 372 - ::SDRepeatOptionData::mRepeatTrack
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SDRepeatOptionData, mRepeatTrack)
    },
    {   // 373 - ::SDRepeatOptionData::mRepeatList
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SDRepeatOptionData, mRepeatList)
    },
    {   // 374 - ::USBRepeatOptionData
        COURIER_DATA_ITEM_TYPE_ID(::USBRepeatOptionData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 375 - ::USBRepeatOptionData::mRepeatTrack
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::USBRepeatOptionData, mRepeatTrack)
    },
    {   // 376 - ::USBRepeatOptionData::mRepeatList
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::USBRepeatOptionData, mRepeatList)
    },
    {   // 377 - ::USBRepeatOptionData::mRepeatIndex
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::USBRepeatOptionData, mRepeatIndex)
    },
    {   // 378 - ::USBCameraPortRepeatOptionData
        COURIER_DATA_ITEM_TYPE_ID(::USBCameraPortRepeatOptionData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 379 - ::USBCameraPortRepeatOptionData::mRepeatTrack
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::USBCameraPortRepeatOptionData, mRepeatTrack)
    },
    {   // 380 - ::USBCameraPortRepeatOptionData::mRepeatList
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::USBCameraPortRepeatOptionData, mRepeatList)
    },
    {   // 381 - ::USBCameraPortRepeatOptionData::mRepeatIndex
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::USBCameraPortRepeatOptionData, mRepeatIndex)
    },
    {   // 382 - ::USBRouterRepeatOptionData
        COURIER_DATA_ITEM_TYPE_ID(::USBRouterRepeatOptionData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 383 - ::USBRouterRepeatOptionData::mRepeatTrack
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::USBRouterRepeatOptionData, mRepeatTrack)
    },
    {   // 384 - ::USBRouterRepeatOptionData::mRepeatIndex
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::USBRouterRepeatOptionData, mRepeatIndex)
    },
    {   // 385 - ::BTRepeatOptionData
        COURIER_DATA_ITEM_TYPE_ID(::BTRepeatOptionData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 386 - ::BTRepeatOptionData::mRepeatTrack
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::BTRepeatOptionData, mRepeatTrack)
    },
    {   // 387 - ::BTRepeatOptionData::mRepeatList
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::BTRepeatOptionData, mRepeatList)
    },
    {   // 388 - ::BTRepeatOptionData::mRepeatIndex
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::BTRepeatOptionData, mRepeatIndex)
    },
    {   // 389 - ::AppleRepeatOptionData
        COURIER_DATA_ITEM_TYPE_ID(::AppleRepeatOptionData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 390 - ::AppleRepeatOptionData::mRepeatTrack
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::AppleRepeatOptionData, mRepeatTrack)
    },
    {   // 391 - ::AppleRepeatOptionData::mRepeatList
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::AppleRepeatOptionData, mRepeatList)
    },
    {   // 392 - ::AppleRepeatOptionData::mRepeatIndex
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::AppleRepeatOptionData, mRepeatIndex)
    },
    {   // 393 - ::SDShuffleOptionData
        COURIER_DATA_ITEM_TYPE_ID(::SDShuffleOptionData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 394 - ::SDShuffleOptionData::mShuffleOff
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SDShuffleOptionData, mShuffleOff)
    },
    {   // 395 - ::SDShuffleOptionData::mShuffleOn
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SDShuffleOptionData, mShuffleOn)
    },
    {   // 396 - ::USBShuffleOptionData
        COURIER_DATA_ITEM_TYPE_ID(::USBShuffleOptionData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 397 - ::USBShuffleOptionData::mShuffleOff
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::USBShuffleOptionData, mShuffleOff)
    },
    {   // 398 - ::USBShuffleOptionData::mShuffleOn
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::USBShuffleOptionData, mShuffleOn)
    },
    {   // 399 - ::USBShuffleOptionData::mShuffleIndex
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::USBShuffleOptionData, mShuffleIndex)
    },
    {   // 400 - ::USBCameraPortShuffleOptionData
        COURIER_DATA_ITEM_TYPE_ID(::USBCameraPortShuffleOptionData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 401 - ::USBCameraPortShuffleOptionData::mShuffleOff
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::USBCameraPortShuffleOptionData, mShuffleOff)
    },
    {   // 402 - ::USBCameraPortShuffleOptionData::mShuffleOn
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::USBCameraPortShuffleOptionData, mShuffleOn)
    },
    {   // 403 - ::USBCameraPortShuffleOptionData::mShuffleIndex
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::USBCameraPortShuffleOptionData, mShuffleIndex)
    },
    {   // 404 - ::USBRouterShuffleOptionData
        COURIER_DATA_ITEM_TYPE_ID(::USBRouterShuffleOptionData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 405 - ::USBRouterShuffleOptionData::mShuffleOff
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::USBRouterShuffleOptionData, mShuffleOff)
    },
    {   // 406 - ::USBRouterShuffleOptionData::mShuffleOn
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::USBRouterShuffleOptionData, mShuffleOn)
    },
    {   // 407 - ::USBRouterShuffleOptionData::mShuffleIndex
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::USBRouterShuffleOptionData, mShuffleIndex)
    },
    {   // 408 - ::USBPlayPauseOptionData
        COURIER_DATA_ITEM_TYPE_ID(::USBPlayPauseOptionData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 409 - ::USBPlayPauseOptionData::mPlayPauseIndex
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::USBPlayPauseOptionData, mPlayPauseIndex)
    },
    {   // 410 - ::USBCameraPortPlayPauseOptionData
        COURIER_DATA_ITEM_TYPE_ID(::USBCameraPortPlayPauseOptionData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 411 - ::USBCameraPortPlayPauseOptionData::mPlayPauseIndex
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::USBCameraPortPlayPauseOptionData, mPlayPauseIndex)
    },
    {   // 412 - ::USBRouterPlayPauseOptionData
        COURIER_DATA_ITEM_TYPE_ID(::USBRouterPlayPauseOptionData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 413 - ::USBRouterPlayPauseOptionData::mPlayPauseIndex
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::USBRouterPlayPauseOptionData, mPlayPauseIndex)
    },
    {   // 414 - ::ApplePlayPauseOptionData
        COURIER_DATA_ITEM_TYPE_ID(::ApplePlayPauseOptionData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 415 - ::ApplePlayPauseOptionData::mPlayPauseIndex
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::ApplePlayPauseOptionData, mPlayPauseIndex)
    },
    {   // 416 - ::BTPlayPauseOptionData
        COURIER_DATA_ITEM_TYPE_ID(::BTPlayPauseOptionData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 417 - ::BTPlayPauseOptionData::mPlayPauseIndex
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::BTPlayPauseOptionData, mPlayPauseIndex)
    },
    {   // 418 - ::BTShuffleOptionData
        COURIER_DATA_ITEM_TYPE_ID(::BTShuffleOptionData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 419 - ::BTShuffleOptionData::mShuffleOff
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::BTShuffleOptionData, mShuffleOff)
    },
    {   // 420 - ::BTShuffleOptionData::mShuffleOn
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::BTShuffleOptionData, mShuffleOn)
    },
    {   // 421 - ::BTShuffleOptionData::mShuffleIndex
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::BTShuffleOptionData, mShuffleIndex)
    },
    {   // 422 - ::AppleShuffleOptionData
        COURIER_DATA_ITEM_TYPE_ID(::AppleShuffleOptionData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 423 - ::AppleShuffleOptionData::mShuffleOff
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::AppleShuffleOptionData, mShuffleOff)
    },
    {   // 424 - ::AppleShuffleOptionData::mShuffleOn
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::AppleShuffleOptionData, mShuffleOn)
    },
    {   // 425 - ::AppleShuffleOptionData::mShuffleIndex
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::AppleShuffleOptionData, mShuffleIndex)
    },
    {   // 426 - ::SPIConnectionTypeData
        COURIER_DATA_ITEM_TYPE_ID(::SPIConnectionTypeData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 427 - ::SPIConnectionTypeData::mSPIConnectionIndex
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::SPIConnectionTypeData, mSPIConnectionIndex)
    },
    {   // 428 - ::AuxFeatureControllerData
        COURIER_DATA_ITEM_TYPE_ID(::AuxFeatureControllerData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 429 - ::AuxFeatureControllerData::mEnableStatus
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::AuxFeatureControllerData, mEnableStatus)
    },
    {   // 430 - ::MediaListIDData
        COURIER_DATA_ITEM_TYPE_ID(::MediaListIDData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 431 - ::MediaListIDData::mAlbumListID
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::MediaListIDData, mAlbumListID)
    },
    {   // 432 - ::MediaListIDData::mTitleListID
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::MediaListIDData, mTitleListID)
    },
    {   // 433 - ::MediaTabActiveStateData
        COURIER_DATA_ITEM_TYPE_ID(::MediaTabActiveStateData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 434 - ::MediaTabActiveStateData::mTitleTabActiveStateChange
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::MediaTabActiveStateData, mTitleTabActiveStateChange)
    },
    {   // 435 - ::MediaTabActiveStateData::mArtistTabActiveStateChange
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::MediaTabActiveStateData, mArtistTabActiveStateChange)
    },
    {   // 436 - ::MediaTabActiveStateData::mAlbumTabActiveStateChange
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::MediaTabActiveStateData, mAlbumTabActiveStateChange)
    },
    {   // 437 - ::MediaTabActiveStateData::mGenreTabActiveStateChange
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::MediaTabActiveStateData, mGenreTabActiveStateChange)
    },
    {   // 438 - ::MediaTabActiveStateData::mFolderTabActiveStateChange
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::MediaTabActiveStateData, mFolderTabActiveStateChange)
    },
    {   // 439 - ::MediaTabActiveStateData::mPlaylistTabActiveStateChange
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::MediaTabActiveStateData, mPlaylistTabActiveStateChange)
    },
    {   // 440 - ::MediaTabActiveStateData::mAudioBkTabActiveStateChange
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::MediaTabActiveStateData, mAudioBkTabActiveStateChange)
    },
    {   // 441 - ::MediaTabActiveStateData::mPodcastTabActiveStateChange
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::MediaTabActiveStateData, mPodcastTabActiveStateChange)
    },
    {   // 442 - ::MediaTabActiveStateData::mVideoTabActiveStateChange
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::MediaTabActiveStateData, mVideoTabActiveStateChange)
    },
    {   // 443 - ::VideoTabActivationData
        COURIER_DATA_ITEM_TYPE_ID(::VideoTabActivationData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 444 - ::VideoTabActivationData::mIsVideoTabActiveVariant
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::VideoTabActivationData, mIsVideoTabActiveVariant)
    },
    {   // 445 - ::USBCameraPortAlbumVisibilityData
        COURIER_DATA_ITEM_TYPE_ID(::USBCameraPortAlbumVisibilityData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 446 - ::USBCameraPortAlbumVisibilityData::mIconAndTextVisiblity
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::USBCameraPortAlbumVisibilityData, mIconAndTextVisiblity)
    },
    {   // 447 - ::USBRouterAlbumVisibilityData
        COURIER_DATA_ITEM_TYPE_ID(::USBRouterAlbumVisibilityData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 448 - ::USBRouterAlbumVisibilityData::mIconAndTextVisiblity
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::USBRouterAlbumVisibilityData, mIconAndTextVisiblity)
    },
    {   // 449 - ::AuxActivationData
        COURIER_DATA_ITEM_TYPE_ID(::AuxActivationData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 450 - ::AuxActivationData::mIsAuxActiveVariant
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::AuxActivationData, mIsAuxActiveVariant)
    },
    {   // 451 - ::FolderListDataItemData
        COURIER_DATA_ITEM_TYPE_ID(::FolderListDataItemData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 452 - ::FolderListDataItemData::mIconImageIndexVal
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::FolderListDataItemData, mIconImageIndexVal)
    },
    {   // 453 - ::DownloadVisibilityDataItemData
        COURIER_DATA_ITEM_TYPE_ID(::DownloadVisibilityDataItemData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 454 - ::DownloadVisibilityDataItemData::mDownloadIconVisibilityVal
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::DownloadVisibilityDataItemData, mDownloadIconVisibilityVal)
    },
    {   // 455 - ::DownloadVisibilityDataItemData::mDownloadIconSwitchVal
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::DownloadVisibilityDataItemData, mDownloadIconSwitchVal)
    },
    {   // 456 - ::DownloadVisibilityDataItemData::mDownloadAnimationStatus
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::DownloadVisibilityDataItemData, mDownloadAnimationStatus)
    },
    {   // 457 - ::FolderFileListDataItemData
        COURIER_DATA_ITEM_TYPE_ID(::FolderFileListDataItemData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 458 - ::FolderFileListDataItemData::mFolderFileIconImageIndex
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::FolderFileListDataItemData, mFolderFileIconImageIndex)
    },
    {   // 459 - ::BrowseTextChangeData
        COURIER_DATA_ITEM_TYPE_ID(::BrowseTextChangeData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 460 - ::BrowseTextChangeData::mBrowseText
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::BrowseTextChangeData, mBrowseText)
    },
    {   // 461 - ::ExternalBrowseTextInfoData
        COURIER_DATA_ITEM_TYPE_ID(::ExternalBrowseTextInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 462 - ::ExternalBrowseTextInfoData::mBrowseText
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::ExternalBrowseTextInfoData, mBrowseText)
    },
    {   // 463 - ::BrowserScreenListSizeData
        COURIER_DATA_ITEM_TYPE_ID(::BrowserScreenListSizeData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 464 - ::BrowserScreenListSizeData::mPreviousButtonSize
        COURIER_DATA_ITEM_TYPE_ID(Candera::Vector2),
        COURIER_ITEM_MEMBER(::BrowserScreenListSizeData, mPreviousButtonSize)
    },
    {   // 465 - ::BrowserScreenListSizeData::mAllAlbumAndTitleButtonSize
        COURIER_DATA_ITEM_TYPE_ID(Candera::Vector2),
        COURIER_ITEM_MEMBER(::BrowserScreenListSizeData, mAllAlbumAndTitleButtonSize)
    },
    {   // 466 - ::BrowserScreenListSizeData::mVerticalListSize
        COURIER_DATA_ITEM_TYPE_ID(Candera::Vector2),
        COURIER_ITEM_MEMBER(::BrowserScreenListSizeData, mVerticalListSize)
    },
    {   // 467 - ::BrowserScreenListSizeData::mScrollBarSize
        COURIER_DATA_ITEM_TYPE_ID(Candera::Vector2),
        COURIER_ITEM_MEMBER(::BrowserScreenListSizeData, mScrollBarSize)
    },
    {   // 468 - ::BrowserScreenListSizeData::mPreviousButtonVisibility
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::BrowserScreenListSizeData, mPreviousButtonVisibility)
    },
    {   // 469 - ::BrowserScreenListSizeData::mAllAlbumAndTitleButtonVisibility
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::BrowserScreenListSizeData, mAllAlbumAndTitleButtonVisibility)
    },
    {   // 470 - ::BrowserScreenListSizeData::mAllAlbumAndTitleText
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::BrowserScreenListSizeData, mAllAlbumAndTitleText)
    },
    {   // 471 - ::BrowserScreenListSizeData::mAlbumIconVisibility
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::BrowserScreenListSizeData, mAlbumIconVisibility)
    },
    {   // 472 - ::BrowserScreenListSizeData::mTitleIconVisibility
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::BrowserScreenListSizeData, mTitleIconVisibility)
    },
    {   // 473 - ::BrowserScreenListSizeData::mListVisibility
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::BrowserScreenListSizeData, mListVisibility)
    },
    {   // 474 - ::BrowserScreenListSizeData::mScrollBarSliderSize
        COURIER_DATA_ITEM_TYPE_ID(Candera::Float),
        COURIER_ITEM_MEMBER(::BrowserScreenListSizeData, mScrollBarSliderSize)
    },
    {   // 475 - ::BrowseListInfoTextData
        COURIER_DATA_ITEM_TYPE_ID(::BrowseListInfoTextData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 476 - ::BrowseListInfoTextData::mListInfoTextVisiblity
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::BrowseListInfoTextData, mListInfoTextVisiblity)
    },
    {   // 477 - ::MediaTabDisabledStateData
        COURIER_DATA_ITEM_TYPE_ID(::MediaTabDisabledStateData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 478 - ::MediaTabDisabledStateData::mGenreTabDisabledStateChange
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::MediaTabDisabledStateData, mGenreTabDisabledStateChange)
    },
    {   // 479 - ::MediaTabDisabledStateData::mPlaylistTabDisabledStateChange
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::MediaTabDisabledStateData, mPlaylistTabDisabledStateChange)
    },
    {   // 480 - ::MediaTabDisabledStateData::mAlbumTabDisabledStateChange
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::MediaTabDisabledStateData, mAlbumTabDisabledStateChange)
    },
    {   // 481 - ::MediaTabDisabledStateData::mAudiobookTabDisabledStateChange
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::MediaTabDisabledStateData, mAudiobookTabDisabledStateChange)
    },
    {   // 482 - ::MediaTabDisabledStateData::mPageUpDisabledStateChange
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::MediaTabDisabledStateData, mPageUpDisabledStateChange)
    },
    {   // 483 - ::MediaTabDisabledStateData::mPageDownDisabledStateChange
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::MediaTabDisabledStateData, mPageDownDisabledStateChange)
    },
    {   // 484 - ::MuteStateVisibleGadgetData
        COURIER_DATA_ITEM_TYPE_ID(::MuteStateVisibleGadgetData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 485 - ::MuteStateVisibleGadgetData::mMuteImageVisibility
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::MuteStateVisibleGadgetData, mMuteImageVisibility)
    },
    {   // 486 - ::MuteStateVisibleGadgetData::mPlayEnableIconVisible
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::MuteStateVisibleGadgetData, mPlayEnableIconVisible)
    },
    {   // 487 - ::MuteStateVisibleGadgetData::mControlIconStatus
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::MuteStateVisibleGadgetData, mControlIconStatus)
    },
    {   // 488 - ::MuteStateVisibleGadgetData::mPlayDisableIconVisible
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::MuteStateVisibleGadgetData, mPlayDisableIconVisible)
    },
    {   // 489 - ::MediaSourceUpdateInGadgetData
        COURIER_DATA_ITEM_TYPE_ID(::MediaSourceUpdateInGadgetData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 490 - ::MediaSourceUpdateInGadgetData::mMediaSourceIndex
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::MediaSourceUpdateInGadgetData, mMediaSourceIndex)
    },
    {   // 491 - ::MediaMetaDataUpdateInGadgetData
        COURIER_DATA_ITEM_TYPE_ID(::MediaMetaDataUpdateInGadgetData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 492 - ::MediaMetaDataUpdateInGadgetData::mMediaGadgetIndex
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::MediaMetaDataUpdateInGadgetData, mMediaGadgetIndex)
    },
    {   // 493 - ::PlaybackActionGadgetData
        COURIER_DATA_ITEM_TYPE_ID(::PlaybackActionGadgetData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 494 - ::PlaybackActionGadgetData::mArtistName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PlaybackActionGadgetData, mArtistName)
    },
    {   // 495 - ::PlaybackActionGadgetData::mTitleName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PlaybackActionGadgetData, mTitleName)
    },
    {   // 496 - ::PlaybackActionGadgetData::mElapsedTime
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PlaybackActionGadgetData, mElapsedTime)
    },
    {   // 497 - ::PlaybackActionGadgetData::mTotalTime
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PlaybackActionGadgetData, mTotalTime)
    },
    {   // 498 - ::PlaybackActionGadgetData::mSliderTotalTime
        COURIER_DATA_ITEM_TYPE_ID(Candera::Float),
        COURIER_ITEM_MEMBER(::PlaybackActionGadgetData, mSliderTotalTime)
    },
    {   // 499 - ::PlaybackActionGadgetData::mSliderElapsedTime
        COURIER_DATA_ITEM_TYPE_ID(Candera::Float),
        COURIER_ITEM_MEMBER(::PlaybackActionGadgetData, mSliderElapsedTime)
    },
    {   // 500 - ::PlaybackActionCabinAGadgetData
        COURIER_DATA_ITEM_TYPE_ID(::PlaybackActionCabinAGadgetData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 501 - ::PlaybackActionCabinAGadgetData::mArtistName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PlaybackActionCabinAGadgetData, mArtistName)
    },
    {   // 502 - ::PlaybackActionCabinAGadgetData::mTitleName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PlaybackActionCabinAGadgetData, mTitleName)
    },
    {   // 503 - ::PlaybackActionCabinAGadgetData::mElapsedTime
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PlaybackActionCabinAGadgetData, mElapsedTime)
    },
    {   // 504 - ::PlaybackActionCabinAGadgetData::mTotalTime
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PlaybackActionCabinAGadgetData, mTotalTime)
    },
    {   // 505 - ::PlaybackActionCabinAGadgetData::mSliderTotalTime
        COURIER_DATA_ITEM_TYPE_ID(Candera::Float),
        COURIER_ITEM_MEMBER(::PlaybackActionCabinAGadgetData, mSliderTotalTime)
    },
    {   // 506 - ::PlaybackActionCabinAGadgetData::mSliderElapsedTime
        COURIER_DATA_ITEM_TYPE_ID(Candera::Float),
        COURIER_ITEM_MEMBER(::PlaybackActionCabinAGadgetData, mSliderElapsedTime)
    },
    {   // 507 - ::PlaybackActionRouterGadgetData
        COURIER_DATA_ITEM_TYPE_ID(::PlaybackActionRouterGadgetData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 508 - ::PlaybackActionRouterGadgetData::mArtistName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PlaybackActionRouterGadgetData, mArtistName)
    },
    {   // 509 - ::PlaybackActionRouterGadgetData::mTitleName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PlaybackActionRouterGadgetData, mTitleName)
    },
    {   // 510 - ::PlaybackActionRouterGadgetData::mElapsedTime
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PlaybackActionRouterGadgetData, mElapsedTime)
    },
    {   // 511 - ::PlaybackActionRouterGadgetData::mTotalTime
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PlaybackActionRouterGadgetData, mTotalTime)
    },
    {   // 512 - ::PlaybackActionRouterGadgetData::mSliderTotalTime
        COURIER_DATA_ITEM_TYPE_ID(Candera::Float),
        COURIER_ITEM_MEMBER(::PlaybackActionRouterGadgetData, mSliderTotalTime)
    },
    {   // 513 - ::PlaybackActionRouterGadgetData::mSliderElapsedTime
        COURIER_DATA_ITEM_TYPE_ID(Candera::Float),
        COURIER_ITEM_MEMBER(::PlaybackActionRouterGadgetData, mSliderElapsedTime)
    },
    {   // 514 - ::GadgetItemVisibilityStateData
        COURIER_DATA_ITEM_TYPE_ID(::GadgetItemVisibilityStateData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 515 - ::GadgetItemVisibilityStateData::mGadgetButtonsVisibleState
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::GadgetItemVisibilityStateData, mGadgetButtonsVisibleState)
    },
    {   // 516 - ::GadgetItemVisibilityStateData::mGadgetSourceIconAndTextVisibleState
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::GadgetItemVisibilityStateData, mGadgetSourceIconAndTextVisibleState)
    },
    {   // 517 - ::GadgetItemVisibilityStateData::mGadgetCabinDefaultTextVisibleState
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::GadgetItemVisibilityStateData, mGadgetCabinDefaultTextVisibleState)
    },
    {   // 518 - ::GadgetItemVisibilityStateData::mGadgetCabinRestorationTextVisibleState
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::GadgetItemVisibilityStateData, mGadgetCabinRestorationTextVisibleState)
    },
    {   // 519 - ::GadgetPlayPauseOptionData
        COURIER_DATA_ITEM_TYPE_ID(::GadgetPlayPauseOptionData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 520 - ::GadgetPlayPauseOptionData::mPlayPauseIndex
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::GadgetPlayPauseOptionData, mPlayPauseIndex)
    },
    {   // 521 - ::MediaSourceUSBNameInGadgetData
        COURIER_DATA_ITEM_TYPE_ID(::MediaSourceUSBNameInGadgetData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 522 - ::MediaSourceUSBNameInGadgetData::mUSBName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::MediaSourceUSBNameInGadgetData, mUSBName)
    },
    {   // 523 - ::CamportUSBGadgetPlayPauseOptionData
        COURIER_DATA_ITEM_TYPE_ID(::CamportUSBGadgetPlayPauseOptionData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 524 - ::CamportUSBGadgetPlayPauseOptionData::mPlayPauseIndex
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::CamportUSBGadgetPlayPauseOptionData, mPlayPauseIndex)
    },
    {   // 525 - ::RouterUSBGadgetPlayPauseOptionData
        COURIER_DATA_ITEM_TYPE_ID(::RouterUSBGadgetPlayPauseOptionData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 526 - ::RouterUSBGadgetPlayPauseOptionData::mPlayPauseIndex
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::RouterUSBGadgetPlayPauseOptionData, mPlayPauseIndex)
    },
    {   // 527 - ::ListScrollBarInfoData
        COURIER_DATA_ITEM_TYPE_ID(::ListScrollBarInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 528 - ::ListScrollBarInfoData::mEnabled
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::ListScrollBarInfoData, mEnabled)
    },
};

// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gInvalidHierarchyNodes[InvalidDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x00000000, /Invalid),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 0,
        /* mParentIndex        */ 0,    // ItemKey::InvalidItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 0,    // ::InvalidData
        /* mItemKey            */ 0
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gDeviceConnectionHierarchyNodes[DeviceConnectionDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xFA938CC3, /DeviceConnection),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::DeviceConnectionItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 1,    // ::DeviceConnectionData
        /* mItemKey            */ 512
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x1E513DB0, /DeviceConnection/USBDeviceName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::DeviceConnectionItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 2,    // ::DeviceConnectionData::mUSBDeviceName
        /* mItemKey            */ 58
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x185C631D, /DeviceConnection/AppleDeviceName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::DeviceConnectionItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 3,    // ::DeviceConnectionData::mAppleDeviceName
        /* mItemKey            */ 45
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x9E615CC5, /DeviceConnection/BTDeviceName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::DeviceConnectionItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 4,    // ::DeviceConnectionData::mBTDeviceName
        /* mItemKey            */ 333
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x53884CAA, /DeviceConnection/SDCardDeviceName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::DeviceConnectionItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 5,    // ::DeviceConnectionData::mSDCardDeviceName
        /* mItemKey            */ 177
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gBTVisibilityHierarchyNodes[BTVisibilityDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x8C547337, /BTVisibility),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 2,
        /* mParentIndex        */ 0,    // ItemKey::BTVisibilityItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 6,    // ::BTVisibilityData
        /* mItemKey            */ 301
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x0CAAFB03, /BTVisibility/BTIsvisible),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 2,
        /* mParentIndex        */ 0,    // ItemKey::BTVisibilityItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 7,    // ::BTVisibilityData::mBTIsvisible
        /* mItemKey            */ 21
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSPIVisibilityHierarchyNodes[SPIVisibilityDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xFEB1E0EA, /SPIVisibility),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 3,
        /* mParentIndex        */ 0,    // ItemKey::SPIVisibilityItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 8,    // ::SPIVisibilityData
        /* mItemKey            */ 527
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF211C84A, /SPIVisibility/SPIIsvisible),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 3,
        /* mParentIndex        */ 0,    // ItemKey::SPIVisibilityItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 9,    // ::SPIVisibilityData::mSPIIsvisible
        /* mItemKey            */ 495
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gPlaybackActionHierarchyNodes[PlaybackActionDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x66FC7CB4, /PlaybackAction),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 4,
        /* mParentIndex        */ 0,    // ItemKey::PlaybackActionItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 10,    // ::PlaybackActionData
        /* mItemKey            */ 215
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x70618D27, /PlaybackAction/SourceName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 4,
        /* mParentIndex        */ 0,    // ItemKey::PlaybackActionItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 11,    // ::PlaybackActionData::mSourceName
        /* mItemKey            */ 240
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x8254A656, /PlaybackAction/ArtistName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 4,
        /* mParentIndex        */ 0,    // ItemKey::PlaybackActionItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 12,    // ::PlaybackActionData::mArtistName
        /* mItemKey            */ 279
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE48CD601, /PlaybackAction/TitleName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 4,
        /* mParentIndex        */ 0,    // ItemKey::PlaybackActionItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 13,    // ::PlaybackActionData::mTitleName
        /* mItemKey            */ 461
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xFDE0DC95, /PlaybackAction/AlbumName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 4,
        /* mParentIndex        */ 0,    // ItemKey::PlaybackActionItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 14,    // ::PlaybackActionData::mAlbumName
        /* mItemKey            */ 522
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x51DBB4CA, /PlaybackAction/VideoName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 4,
        /* mParentIndex        */ 0,    // ItemKey::PlaybackActionItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 15,    // ::PlaybackActionData::mVideoName
        /* mItemKey            */ 175
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE9552A5A, /PlaybackAction/CurrentTrackNo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 4,
        /* mParentIndex        */ 0,    // ItemKey::PlaybackActionItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 16,    // ::PlaybackActionData::mCurrentTrackNo
        /* mItemKey            */ 476
    },
    { // 7
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF9DEC5DB, /PlaybackAction/TotalTrackNo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 4,
        /* mParentIndex        */ 0,    // ItemKey::PlaybackActionItem
        /* mLocalIndex         */ 7,
        /* mDescriptorIndex    */ 17,    // ::PlaybackActionData::mTotalTrackNo
        /* mItemKey            */ 509
    },
    { // 8
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x50DC423C, /PlaybackAction/TotalTime),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 4,
        /* mParentIndex        */ 0,    // ItemKey::PlaybackActionItem
        /* mLocalIndex         */ 8,
        /* mDescriptorIndex    */ 18,    // ::PlaybackActionData::mTotalTime
        /* mItemKey            */ 172
    },
    { // 9
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x0F8A679C, /PlaybackAction/ElapsedTime),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 4,
        /* mParentIndex        */ 0,    // ItemKey::PlaybackActionItem
        /* mLocalIndex         */ 9,
        /* mDescriptorIndex    */ 19,    // ::PlaybackActionData::mElapsedTime
        /* mItemKey            */ 28
    },
    { // 10
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x19198ADE, /PlaybackAction/SliderTotalTime),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 4,
        /* mParentIndex        */ 0,    // ItemKey::PlaybackActionItem
        /* mLocalIndex         */ 10,
        /* mDescriptorIndex    */ 20,    // ::PlaybackActionData::mSliderTotalTime
        /* mItemKey            */ 48
    },
    { // 11
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x73FE9010, /PlaybackAction/SliderElapsedTime),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 4,
        /* mParentIndex        */ 0,    // ItemKey::PlaybackActionItem
        /* mLocalIndex         */ 11,
        /* mDescriptorIndex    */ 21,    // ::PlaybackActionData::mSliderElapsedTime
        /* mItemKey            */ 252
    },
    { // 12
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xAD5939C9, /PlaybackAction/DragCurrentValue),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 4,
        /* mParentIndex        */ 0,    // ItemKey::PlaybackActionItem
        /* mLocalIndex         */ 12,
        /* mDescriptorIndex    */ 22,    // ::PlaybackActionData::mDragCurrentValue
        /* mItemKey            */ 359
    },
    { // 13
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xEC7EAF89, /PlaybackAction/RepeatOption),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 4,
        /* mParentIndex        */ 0,    // ItemKey::PlaybackActionItem
        /* mLocalIndex         */ 13,
        /* mDescriptorIndex    */ 23,    // ::PlaybackActionData::mRepeatOption
        /* mItemKey            */ 487
    },
    { // 14
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xACA2D460, /PlaybackAction/ShuffleOption),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 4,
        /* mParentIndex        */ 0,    // ItemKey::PlaybackActionItem
        /* mLocalIndex         */ 14,
        /* mDescriptorIndex    */ 24,    // ::PlaybackActionData::mShuffleOption
        /* mItemKey            */ 356
    },
    { // 15
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE379309D, /PlaybackAction/SeekCurrentPosition),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 4,
        /* mParentIndex        */ 0,    // ItemKey::PlaybackActionItem
        /* mLocalIndex         */ 15,
        /* mDescriptorIndex    */ 25,    // ::PlaybackActionData::mSeekCurrentPosition
        /* mItemKey            */ 460
    },
    { // 16
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x2336B625, /PlaybackAction/PlayIconName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 4,
        /* mParentIndex        */ 0,    // ItemKey::PlaybackActionItem
        /* mLocalIndex         */ 16,
        /* mDescriptorIndex    */ 26,    // ::PlaybackActionData::mPlayIconName
        /* mItemKey            */ 70
    },
    { // 17
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7489BBFB, /PlaybackAction/RepeatIconName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 4,
        /* mParentIndex        */ 0,    // ItemKey::PlaybackActionItem
        /* mLocalIndex         */ 17,
        /* mDescriptorIndex    */ 27,    // ::PlaybackActionData::mRepeatIconName
        /* mItemKey            */ 253
    },
    { // 18
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x151CDBE0, /PlaybackAction/ShuffleIconName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 4,
        /* mParentIndex        */ 0,    // ItemKey::PlaybackActionItem
        /* mLocalIndex         */ 18,
        /* mDescriptorIndex    */ 28,    // ::PlaybackActionData::mShuffleIconName
        /* mItemKey            */ 37
    },
    { // 19
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA71880E6, /PlaybackAction/DummyImage),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 4,
        /* mParentIndex        */ 0,    // ItemKey::PlaybackActionItem
        /* mLocalIndex         */ 19,
        /* mDescriptorIndex    */ 29,    // ::PlaybackActionData::mDummyImage
        /* mItemKey            */ 347
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gUSBCameraPortPlaybackActionHierarchyNodes[USBCameraPortPlaybackActionDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA34FEDDB, /USBCameraPortPlaybackAction),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 5,
        /* mParentIndex        */ 0,    // ItemKey::USBCameraPortPlaybackActionItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 30,    // ::USBCameraPortPlaybackActionData
        /* mItemKey            */ 339
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x23818B7D, /USBCameraPortPlaybackAction/SourceName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 5,
        /* mParentIndex        */ 0,    // ItemKey::USBCameraPortPlaybackActionItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 31,    // ::USBCameraPortPlaybackActionData::mSourceName
        /* mItemKey            */ 71
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x725445E5, /USBCameraPortPlaybackAction/ArtistName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 5,
        /* mParentIndex        */ 0,    // ItemKey::USBCameraPortPlaybackActionItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 32,    // ::USBCameraPortPlaybackActionData::mArtistName
        /* mItemKey            */ 246
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA1957130, /USBCameraPortPlaybackAction/TitleName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 5,
        /* mParentIndex        */ 0,    // ItemKey::USBCameraPortPlaybackActionItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 33,    // ::USBCameraPortPlaybackActionData::mTitleName
        /* mItemKey            */ 336
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x23266DA8, /USBCameraPortPlaybackAction/AlbumName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 5,
        /* mParentIndex        */ 0,    // ItemKey::USBCameraPortPlaybackActionItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 34,    // ::USBCameraPortPlaybackActionData::mAlbumName
        /* mItemKey            */ 69
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB4913FEE, /USBCameraPortPlaybackAction/CurrentTrackNo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 5,
        /* mParentIndex        */ 0,    // ItemKey::USBCameraPortPlaybackActionItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 35,    // ::USBCameraPortPlaybackActionData::mCurrentTrackNo
        /* mItemKey            */ 370
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x0C8E795B, /USBCameraPortPlaybackAction/TotalTime),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 5,
        /* mParentIndex        */ 0,    // ItemKey::USBCameraPortPlaybackActionItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 36,    // ::USBCameraPortPlaybackActionData::mTotalTime
        /* mItemKey            */ 20
    },
    { // 7
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x00755FA2, /USBCameraPortPlaybackAction/ElapsedTime),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 5,
        /* mParentIndex        */ 0,    // ItemKey::USBCameraPortPlaybackActionItem
        /* mLocalIndex         */ 7,
        /* mDescriptorIndex    */ 37,    // ::USBCameraPortPlaybackActionData::mElapsedTime
        /* mItemKey            */ 1
    },
    { // 8
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF75A9D3B, /USBCameraPortPlaybackAction/SliderTotalTime),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 5,
        /* mParentIndex        */ 0,    // ItemKey::USBCameraPortPlaybackActionItem
        /* mLocalIndex         */ 8,
        /* mDescriptorIndex    */ 38,    // ::USBCameraPortPlaybackActionData::mSliderTotalTime
        /* mItemKey            */ 506
    },
    { // 9
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x0471DA74, /USBCameraPortPlaybackAction/SliderElapsedTime),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 5,
        /* mParentIndex        */ 0,    // ItemKey::USBCameraPortPlaybackActionItem
        /* mLocalIndex         */ 9,
        /* mDescriptorIndex    */ 39,    // ::USBCameraPortPlaybackActionData::mSliderElapsedTime
        /* mItemKey            */ 7
    },
    { // 10
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xBEE0E18C, /USBCameraPortPlaybackAction/DragCurrentValue),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 5,
        /* mParentIndex        */ 0,    // ItemKey::USBCameraPortPlaybackActionItem
        /* mLocalIndex         */ 10,
        /* mDescriptorIndex    */ 40,    // ::USBCameraPortPlaybackActionData::mDragCurrentValue
        /* mItemKey            */ 389
    },
    { // 11
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xFBEFC53F, /USBCameraPortPlaybackAction/RepeatOption),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 5,
        /* mParentIndex        */ 0,    // ItemKey::USBCameraPortPlaybackActionItem
        /* mLocalIndex         */ 11,
        /* mDescriptorIndex    */ 41,    // ::USBCameraPortPlaybackActionData::mRepeatOption
        /* mItemKey            */ 515
    },
    { // 12
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB4F8BA7B, /USBCameraPortPlaybackAction/ShuffleOption),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 5,
        /* mParentIndex        */ 0,    // ItemKey::USBCameraPortPlaybackActionItem
        /* mLocalIndex         */ 12,
        /* mDescriptorIndex    */ 42,    // ::USBCameraPortPlaybackActionData::mShuffleOption
        /* mItemKey            */ 371
    },
    { // 13
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x21931B52, /USBCameraPortPlaybackAction/PlayIconName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 5,
        /* mParentIndex        */ 0,    // ItemKey::USBCameraPortPlaybackActionItem
        /* mLocalIndex         */ 13,
        /* mDescriptorIndex    */ 43,    // ::USBCameraPortPlaybackActionData::mPlayIconName
        /* mItemKey            */ 65
    },
    { // 14
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x769835D7, /USBCameraPortPlaybackAction/RepeatIconName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 5,
        /* mParentIndex        */ 0,    // ItemKey::USBCameraPortPlaybackActionItem
        /* mLocalIndex         */ 14,
        /* mDescriptorIndex    */ 44,    // ::USBCameraPortPlaybackActionData::mRepeatIconName
        /* mItemKey            */ 258
    },
    { // 15
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x6ECB1422, /USBCameraPortPlaybackAction/ShuffleIconName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 5,
        /* mParentIndex        */ 0,    // ItemKey::USBCameraPortPlaybackActionItem
        /* mLocalIndex         */ 15,
        /* mDescriptorIndex    */ 45,    // ::USBCameraPortPlaybackActionData::mShuffleIconName
        /* mItemKey            */ 235
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gUSBRouterPlaybackActionHierarchyNodes[USBRouterPlaybackActionDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC7DE6272, /USBRouterPlaybackAction),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 6,
        /* mParentIndex        */ 0,    // ItemKey::USBRouterPlaybackActionItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 46,    // ::USBRouterPlaybackActionData
        /* mItemKey            */ 400
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF80552AD, /USBRouterPlaybackAction/SourceName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 6,
        /* mParentIndex        */ 0,    // ItemKey::USBRouterPlaybackActionItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 47,    // ::USBRouterPlaybackActionData::mSourceName
        /* mItemKey            */ 508
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7506F4D5, /USBRouterPlaybackAction/ArtistName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 6,
        /* mParentIndex        */ 0,    // ItemKey::USBRouterPlaybackActionItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 48,    // ::USBRouterPlaybackActionData::mArtistName
        /* mItemKey            */ 254
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xAB4491D0, /USBRouterPlaybackAction/TitleName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 6,
        /* mParentIndex        */ 0,    // ItemKey::USBRouterPlaybackActionItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 49,    // ::USBRouterPlaybackActionData::mTitleName
        /* mItemKey            */ 353
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xCBEB93E6, /USBRouterPlaybackAction/AlbumName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 6,
        /* mParentIndex        */ 0,    // ItemKey::USBRouterPlaybackActionItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 50,    // ::USBRouterPlaybackActionData::mAlbumName
        /* mItemKey            */ 411
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7D891EDC, /USBRouterPlaybackAction/CurrentTrackNo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 6,
        /* mParentIndex        */ 0,    // ItemKey::USBRouterPlaybackActionItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 51,    // ::USBRouterPlaybackActionData::mCurrentTrackNo
        /* mItemKey            */ 271
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE4FB73C3, /USBRouterPlaybackAction/TotalTime),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 6,
        /* mParentIndex        */ 0,    // ItemKey::USBRouterPlaybackActionItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 52,    // ::USBRouterPlaybackActionData::mTotalTime
        /* mItemKey            */ 463
    },
    { // 7
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x47C47A55, /USBRouterPlaybackAction/ElapsedTime),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 6,
        /* mParentIndex        */ 0,    // ItemKey::USBRouterPlaybackActionItem
        /* mLocalIndex         */ 7,
        /* mDescriptorIndex    */ 53,    // ::USBRouterPlaybackActionData::mElapsedTime
        /* mItemKey            */ 153
    },
    { // 8
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x91CCE51D, /USBRouterPlaybackAction/SliderTotalTime),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 6,
        /* mParentIndex        */ 0,    // ItemKey::USBRouterPlaybackActionItem
        /* mLocalIndex         */ 8,
        /* mDescriptorIndex    */ 54,    // ::USBRouterPlaybackActionData::mSliderTotalTime
        /* mItemKey            */ 309
    },
    { // 9
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xEEE4D359, /USBRouterPlaybackAction/SliderElapsedTime),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 6,
        /* mParentIndex        */ 0,    // ItemKey::USBRouterPlaybackActionItem
        /* mLocalIndex         */ 9,
        /* mDescriptorIndex    */ 55,    // ::USBRouterPlaybackActionData::mSliderElapsedTime
        /* mItemKey            */ 491
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gMuteInfoHierarchyNodes[MuteInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x179485FC, /MuteInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 7,
        /* mParentIndex        */ 0,    // ItemKey::MuteInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 56,    // ::MuteInfoData
        /* mItemKey            */ 43
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC58D0D90, /MuteInfo/MuteStatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 7,
        /* mParentIndex        */ 0,    // ItemKey::MuteInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 57,    // ::MuteInfoData::mMuteStatus
        /* mItemKey            */ 397
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gMuteInfoforAuxHierarchyNodes[MuteInfoforAuxDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x9AC04C07, /MuteInfoforAux),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 8,
        /* mParentIndex        */ 0,    // ItemKey::MuteInfoforAuxItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 58,    // ::MuteInfoforAuxData
        /* mItemKey            */ 329
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xEA860737, /MuteInfoforAux/MuteStatusforAux),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 8,
        /* mParentIndex        */ 0,    // ItemKey::MuteInfoforAuxItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 59,    // ::MuteInfoforAuxData::mMuteStatusforAux
        /* mItemKey            */ 481
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gUSB2VisibilityHierarchyNodes[USB2VisibilityDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x159F9787, /USB2Visibility),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 9,
        /* mParentIndex        */ 0,    // ItemKey::USB2VisibilityItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 60,    // ::USB2VisibilityData
        /* mItemKey            */ 39
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x2C4AD39C, /USB2Visibility/USB2Isvisible),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 9,
        /* mParentIndex        */ 0,    // ItemKey::USB2VisibilityItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 61,    // ::USB2VisibilityData::mUSB2Isvisible
        /* mItemKey            */ 94
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gVariantInfoHierarchyNodes[VariantInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x101ECA99, /VariantInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 10,
        /* mParentIndex        */ 0,    // ItemKey::VariantInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 62,    // ::VariantInfoData
        /* mItemKey            */ 30
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xCCCA155B, /VariantInfo/TA_Settings),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 10,
        /* mParentIndex        */ 0,    // ItemKey::VariantInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 63,    // ::VariantInfoData::mTA_Settings
        /* mItemKey            */ 415
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gExternalMediaSourceHierarchyNodes[ExternalMediaSourceDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3C4D5E98, /ExternalMediaSource),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 11,
        /* mParentIndex        */ 0,    // ItemKey::ExternalMediaSourceItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 64,    // ::ExternalMediaSourceData
        /* mItemKey            */ 126
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE0335D72, /ExternalMediaSource/EMPMediaSourceVisibility),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 11,
        /* mParentIndex        */ 0,    // ItemKey::ExternalMediaSourceItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 65,    // ::ExternalMediaSourceData::mEMPMediaSourceVisibility
        /* mItemKey            */ 445
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5D3B7B1B, /ExternalMediaSource/EMPHMIMediaSourceVisibility),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 11,
        /* mParentIndex        */ 0,    // ItemKey::ExternalMediaSourceItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 66,    // ::ExternalMediaSourceData::mEMPHMIMediaSourceVisibility
        /* mItemKey            */ 193
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gTabVideoSourceHierarchyNodes[TabVideoSourceDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC81FF0B5, /TabVideoSource),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 12,
        /* mParentIndex        */ 0,    // ItemKey::TabVideoSourceItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 67,    // ::TabVideoSourceData
        /* mItemKey            */ 401
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x15F678E3, /TabVideoSource/TabVideoSourceVisibility),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 12,
        /* mParentIndex        */ 0,    // ItemKey::TabVideoSourceItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 68,    // ::TabVideoSourceData::mTabVideoSourceVisibility
        /* mItemKey            */ 41
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x8B3D1559, /TabVideoSource/TabVideoSourceEnable),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 12,
        /* mParentIndex        */ 0,    // ItemKey::TabVideoSourceItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 69,    // ::TabVideoSourceData::mTabVideoSourceEnable
        /* mItemKey            */ 299
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gBTNowplayIconsHierarchyNodes[BTNowplayIconsDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD582B148, /BTNowplayIcons),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 13,
        /* mParentIndex        */ 0,    // ItemKey::BTNowplayIconsItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 70,    // ::BTNowplayIconsData
        /* mItemKey            */ 429
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA044D2A7, /BTNowplayIcons/ShuffleIconStatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 13,
        /* mParentIndex        */ 0,    // ItemKey::BTNowplayIconsItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 71,    // ::BTNowplayIconsData::mShuffleIconStatus
        /* mItemKey            */ 335
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB88AE282, /BTNowplayIcons/RepeatIconStatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 13,
        /* mParentIndex        */ 0,    // ItemKey::BTNowplayIconsItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 72,    // ::BTNowplayIconsData::mRepeatIconStatus
        /* mItemKey            */ 377
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3C8027BC, /BTNowplayIcons/BrowseIconStatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 13,
        /* mParentIndex        */ 0,    // ItemKey::BTNowplayIconsItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 73,    // ::BTNowplayIconsData::mBrowseIconStatus
        /* mItemKey            */ 128
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gID3CoverDataForGadgetHierarchyNodes[ID3CoverDataForGadgetDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7B625685, /ID3CoverDataForGadget),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 14,
        /* mParentIndex        */ 0,    // ItemKey::ID3CoverDataForGadgetItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 74,    // ::ID3CoverDataForGadgetData
        /* mItemKey            */ 265
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xFC69AFF3, /ID3CoverDataForGadget/GadgetImage),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 14,
        /* mParentIndex        */ 0,    // ItemKey::ID3CoverDataForGadgetItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 75,    // ::ID3CoverDataForGadgetData::mGadgetImage
        /* mItemKey            */ 516
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gID3CoverDataForCamportUSBGadgetHierarchyNodes[ID3CoverDataForCamportUSBGadgetDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xAE1D0734, /ID3CoverDataForCamportUSBGadget),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 15,
        /* mParentIndex        */ 0,    // ItemKey::ID3CoverDataForCamportUSBGadgetItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 76,    // ::ID3CoverDataForCamportUSBGadgetData
        /* mItemKey            */ 360
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x58AE452E, /ID3CoverDataForCamportUSBGadget/GadgetImage),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 15,
        /* mParentIndex        */ 0,    // ItemKey::ID3CoverDataForCamportUSBGadgetItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 77,    // ::ID3CoverDataForCamportUSBGadgetData::mGadgetImage
        /* mItemKey            */ 186
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gID3CoverDataForRouterUSBGadgetHierarchyNodes[ID3CoverDataForRouterUSBGadgetDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x449F88F8, /ID3CoverDataForRouterUSBGadget),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 16,
        /* mParentIndex        */ 0,    // ItemKey::ID3CoverDataForRouterUSBGadgetItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 78,    // ::ID3CoverDataForRouterUSBGadgetData
        /* mItemKey            */ 147
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x1488B591, /ID3CoverDataForRouterUSBGadget/GadgetImage),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 16,
        /* mParentIndex        */ 0,    // ItemKey::ID3CoverDataForRouterUSBGadgetItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 79,    // ::ID3CoverDataForRouterUSBGadgetData::mGadgetImage
        /* mItemKey            */ 36
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gID3CoverDataForCamportUSBHierarchyNodes[ID3CoverDataForCamportUSBDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xDFBB2D23, /ID3CoverDataForCamportUSB),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 17,
        /* mParentIndex        */ 0,    // ItemKey::ID3CoverDataForCamportUSBItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 80,    // ::ID3CoverDataForCamportUSBData
        /* mItemKey            */ 443
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x351BEFF0, /ID3CoverDataForCamportUSB/CamportAlbumImage),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 17,
        /* mParentIndex        */ 0,    // ItemKey::ID3CoverDataForCamportUSBItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 81,    // ::ID3CoverDataForCamportUSBData::mCamportAlbumImage
        /* mItemKey            */ 108
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gID3CoverDataForRouterUSBHierarchyNodes[ID3CoverDataForRouterUSBDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x328F18DB, /ID3CoverDataForRouterUSB),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 18,
        /* mParentIndex        */ 0,    // ItemKey::ID3CoverDataForRouterUSBItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 82,    // ::ID3CoverDataForRouterUSBData
        /* mItemKey            */ 106
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xFA092465, /ID3CoverDataForRouterUSB/RouterAlbumImage),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 18,
        /* mParentIndex        */ 0,    // ItemKey::ID3CoverDataForRouterUSBItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 83,    // ::ID3CoverDataForRouterUSBData::mRouterAlbumImage
        /* mItemKey            */ 510
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gAlbumListItemHierarchyNodes[AlbumListItemDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x14463EA5, /AlbumListItem),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 19,
        /* mParentIndex        */ 0,    // ItemKey::AlbumListItemItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 84,    // ::AlbumListItemData
        /* mItemKey            */ 35
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x915EA668, /AlbumListItem/AlbumName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 19,
        /* mParentIndex        */ 0,    // ItemKey::AlbumListItemItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 85,    // ::AlbumListItemData::mAlbumName
        /* mItemKey            */ 308
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gVideoPlaybackActionHierarchyNodes[VideoPlaybackActionDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x29351885, /VideoPlaybackAction),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 20,
        /* mParentIndex        */ 0,    // ItemKey::VideoPlaybackActionItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 86,    // ::VideoPlaybackActionData
        /* mItemKey            */ 90
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3C2E0AE6, /VideoPlaybackAction/VideoTitle),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 20,
        /* mParentIndex        */ 0,    // ItemKey::VideoPlaybackActionItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 87,    // ::VideoPlaybackActionData::mVideoTitle
        /* mItemKey            */ 125
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x83179A6D, /VideoPlaybackAction/VideoEpisode),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 20,
        /* mParentIndex        */ 0,    // ItemKey::VideoPlaybackActionItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 88,    // ::VideoPlaybackActionData::mVideoEpisode
        /* mItemKey            */ 281
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gAppleDeviceHierarchyNodes[AppleDeviceDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5910E71D, /AppleDevice),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 21,
        /* mParentIndex        */ 0,    // ItemKey::AppleDeviceItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 89,    // ::AppleDeviceData
        /* mItemKey            */ 188
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x2021B91F, /AppleDevice/SourceName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 21,
        /* mParentIndex        */ 0,    // ItemKey::AppleDeviceItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 90,    // ::AppleDeviceData::mSourceName
        /* mItemKey            */ 63
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x4D645FA3, /AppleDevice/ArtistName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 21,
        /* mParentIndex        */ 0,    // ItemKey::AppleDeviceItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 91,    // ::AppleDeviceData::mArtistName
        /* mItemKey            */ 163
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xFB46B512, /AppleDevice/TitleName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 21,
        /* mParentIndex        */ 0,    // ItemKey::AppleDeviceItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 92,    // ::AppleDeviceData::mTitleName
        /* mItemKey            */ 514
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xEC39BDE9, /AppleDevice/AlbumName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 21,
        /* mParentIndex        */ 0,    // ItemKey::AppleDeviceItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 93,    // ::AppleDeviceData::mAlbumName
        /* mItemKey            */ 486
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xCA02AE98, /AppleDevice/VideoName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 21,
        /* mParentIndex        */ 0,    // ItemKey::AppleDeviceItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 94,    // ::AppleDeviceData::mVideoName
        /* mItemKey            */ 403
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x886AA2B7, /AppleDevice/CurrentTrackNo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 21,
        /* mParentIndex        */ 0,    // ItemKey::AppleDeviceItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 95,    // ::AppleDeviceData::mCurrentTrackNo
        /* mItemKey            */ 292
    },
    { // 7
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xBFA93123, /AppleDevice/TotalTrackNo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 21,
        /* mParentIndex        */ 0,    // ItemKey::AppleDeviceItem
        /* mLocalIndex         */ 7,
        /* mDescriptorIndex    */ 96,    // ::AppleDeviceData::mTotalTrackNo
        /* mItemKey            */ 390
    },
    { // 8
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x09EBD416, /AppleDevice/TotalTime),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 21,
        /* mParentIndex        */ 0,    // ItemKey::AppleDeviceItem
        /* mLocalIndex         */ 8,
        /* mDescriptorIndex    */ 97,    // ::AppleDeviceData::mTotalTime
        /* mItemKey            */ 16
    },
    { // 9
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x9B41DE54, /AppleDevice/ElapsedTime),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 21,
        /* mParentIndex        */ 0,    // ItemKey::AppleDeviceItem
        /* mLocalIndex         */ 9,
        /* mDescriptorIndex    */ 98,    // ::AppleDeviceData::mElapsedTime
        /* mItemKey            */ 330
    },
    { // 10
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x985AEF37, /AppleDevice/SliderTotalTime),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 21,
        /* mParentIndex        */ 0,    // ItemKey::AppleDeviceItem
        /* mLocalIndex         */ 10,
        /* mDescriptorIndex    */ 99,    // ::AppleDeviceData::mSliderTotalTime
        /* mItemKey            */ 322
    },
    { // 11
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x0F2D947F, /AppleDevice/SliderElapsedTime),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 21,
        /* mParentIndex        */ 0,    // ItemKey::AppleDeviceItem
        /* mLocalIndex         */ 11,
        /* mDescriptorIndex    */ 100,    // ::AppleDeviceData::mSliderElapsedTime
        /* mItemKey            */ 27
    },
    { // 12
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3D208DA3, /AppleDevice/DragCurrentValue),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 21,
        /* mParentIndex        */ 0,    // ItemKey::AppleDeviceItem
        /* mLocalIndex         */ 12,
        /* mDescriptorIndex    */ 101,    // ::AppleDeviceData::mDragCurrentValue
        /* mItemKey            */ 130
    },
    { // 13
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x37FB14EE, /AppleDevice/RepeatOption),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 21,
        /* mParentIndex        */ 0,    // ItemKey::AppleDeviceItem
        /* mLocalIndex         */ 13,
        /* mDescriptorIndex    */ 102,    // ::AppleDeviceData::mRepeatOption
        /* mItemKey            */ 114
    },
    { // 14
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA6591C0B, /AppleDevice/ShuffleOption),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 21,
        /* mParentIndex        */ 0,    // ItemKey::AppleDeviceItem
        /* mLocalIndex         */ 14,
        /* mDescriptorIndex    */ 103,    // ::AppleDeviceData::mShuffleOption
        /* mItemKey            */ 346
    },
    { // 15
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x8776A4FF, /AppleDevice/SeekCurrentPosition),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 21,
        /* mParentIndex        */ 0,    // ItemKey::AppleDeviceItem
        /* mLocalIndex         */ 15,
        /* mDescriptorIndex    */ 104,    // ::AppleDeviceData::mSeekCurrentPosition
        /* mItemKey            */ 290
    },
    { // 16
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xBBEFDA79, /AppleDevice/PlayIconName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 21,
        /* mParentIndex        */ 0,    // ItemKey::AppleDeviceItem
        /* mLocalIndex         */ 16,
        /* mDescriptorIndex    */ 105,    // ::AppleDeviceData::mPlayIconName
        /* mItemKey            */ 382
    },
    { // 17
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x735C3763, /AppleDevice/RepeatIconName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 21,
        /* mParentIndex        */ 0,    // ItemKey::AppleDeviceItem
        /* mLocalIndex         */ 17,
        /* mDescriptorIndex    */ 106,    // ::AppleDeviceData::mRepeatIconName
        /* mItemKey            */ 251
    },
    { // 18
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE2B92AFF, /AppleDevice/ShuffleIconName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 21,
        /* mParentIndex        */ 0,    // ItemKey::AppleDeviceItem
        /* mLocalIndex         */ 18,
        /* mDescriptorIndex    */ 107,    // ::AppleDeviceData::mShuffleIconName
        /* mItemKey            */ 457
    },
    { // 19
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x72B37716, /AppleDevice/ArtistIcon),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 21,
        /* mParentIndex        */ 0,    // ItemKey::AppleDeviceItem
        /* mLocalIndex         */ 19,
        /* mDescriptorIndex    */ 108,    // ::AppleDeviceData::mArtistIcon
        /* mItemKey            */ 248
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gIconsHierarchyNodes[IconsDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE27D665F, /Icons),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 22,
        /* mParentIndex        */ 0,    // ItemKey::IconsItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 109,    // ::IconsData
        /* mItemKey            */ 456
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x28CF50D7, /Icons/IconArtistFlip),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 22,
        /* mParentIndex        */ 0,    // ItemKey::IconsItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 110,    // ::IconsData::mIconArtistFlip
        /* mItemKey            */ 88
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x1EBB65BF, /Icons/IconTitleFlip),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 22,
        /* mParentIndex        */ 0,    // ItemKey::IconsItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 111,    // ::IconsData::mIconTitleFlip
        /* mItemKey            */ 59
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xBE138E85, /Icons/IconAlbumFlip),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 22,
        /* mParentIndex        */ 0,    // ItemKey::IconsItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 112,    // ::IconsData::mIconAlbumFlip
        /* mItemKey            */ 386
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gIconsVisibilityHierarchyNodes[IconsVisibilityDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x99DAEAC8, /IconsVisibility),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 23,
        /* mParentIndex        */ 0,    // ItemKey::IconsVisibilityItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 113,    // ::IconsVisibilityData
        /* mItemKey            */ 326
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x068D2D54, /IconsVisibility/IconArtistVisiblity),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 23,
        /* mParentIndex        */ 0,    // ItemKey::IconsVisibilityItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 114,    // ::IconsVisibilityData::mIconArtistVisiblity
        /* mItemKey            */ 12
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x941B2487, /IconsVisibility/IconArtistPodcastVisiblity),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 23,
        /* mParentIndex        */ 0,    // ItemKey::IconsVisibilityItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 115,    // ::IconsVisibilityData::mIconArtistPodcastVisiblity
        /* mItemKey            */ 312
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5AFC557D, /IconsVisibility/IconTitleVisiblity),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 23,
        /* mParentIndex        */ 0,    // ItemKey::IconsVisibilityItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 116,    // ::IconsVisibilityData::mIconTitleVisiblity
        /* mItemKey            */ 190
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x89D72D23, /IconsVisibility/IconTitlePodcastVisiblity),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 23,
        /* mParentIndex        */ 0,    // ItemKey::IconsVisibilityItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 117,    // ::IconsVisibilityData::mIconTitlePodcastVisiblity
        /* mItemKey            */ 294
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x69274816, /IconsVisibility/IconAlbumVisiblity),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 23,
        /* mParentIndex        */ 0,    // ItemKey::IconsVisibilityItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 118,    // ::IconsVisibilityData::mIconAlbumVisiblity
        /* mItemKey            */ 222
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x6EE6687E, /IconsVisibility/IconAlbumAudioBookVisiblity),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 23,
        /* mParentIndex        */ 0,    // ItemKey::IconsVisibilityItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 119,    // ::IconsVisibilityData::mIconAlbumAudioBookVisiblity
        /* mItemKey            */ 236
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gNavigationVarientTypeHierarchyNodes[NavigationVarientTypeDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xDF1B65C1, /NavigationVarientType),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 24,
        /* mParentIndex        */ 0,    // ItemKey::NavigationVarientTypeItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 120,    // ::NavigationVarientTypeData
        /* mItemKey            */ 441
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x980F3C88, /NavigationVarientType/NavigationsupportIndex),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 24,
        /* mParentIndex        */ 0,    // ItemKey::NavigationVarientTypeItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 121,    // ::NavigationVarientTypeData::mNavigationsupportIndex
        /* mItemKey            */ 320
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gID3CoverDataForAppleHierarchyNodes[ID3CoverDataForAppleDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3E385CBB, /ID3CoverDataForApple),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 25,
        /* mParentIndex        */ 0,    // ItemKey::ID3CoverDataForAppleItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 122,    // ::ID3CoverDataForAppleData
        /* mItemKey            */ 131
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xFD2CDEED, /ID3CoverDataForApple/Image),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 25,
        /* mParentIndex        */ 0,    // ItemKey::ID3CoverDataForAppleItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 123,    // ::ID3CoverDataForAppleData::mImage
        /* mItemKey            */ 520
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gID3CoverDataForBTHierarchyNodes[ID3CoverDataForBTDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x49B47D6C, /ID3CoverDataForBT),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 26,
        /* mParentIndex        */ 0,    // ItemKey::ID3CoverDataForBTItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 124,    // ::ID3CoverDataForBTData
        /* mItemKey            */ 157
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA8305FD9, /ID3CoverDataForBT/Image),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 26,
        /* mParentIndex        */ 0,    // ItemKey::ID3CoverDataForBTItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 125,    // ::ID3CoverDataForBTData::mImage
        /* mItemKey            */ 349
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSDCardDeviceHierarchyNodes[SDCardDeviceDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x619DD278, /SDCardDevice),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 27,
        /* mParentIndex        */ 0,    // ItemKey::SDCardDeviceItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 126,    // ::SDCardDeviceData
        /* mItemKey            */ 203
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x760DE56B, /SDCardDevice/SourceName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 27,
        /* mParentIndex        */ 0,    // ItemKey::SDCardDeviceItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 127,    // ::SDCardDeviceData::mSourceName
        /* mItemKey            */ 256
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x27DAF704, /SDCardDevice/ArtistName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 27,
        /* mParentIndex        */ 0,    // ItemKey::SDCardDeviceItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 128,    // ::SDCardDeviceData::mArtistName
        /* mItemKey            */ 84
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xCE018BC5, /SDCardDevice/TitleName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 27,
        /* mParentIndex        */ 0,    // ItemKey::SDCardDeviceItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 129,    // ::SDCardDeviceData::mTitleName
        /* mItemKey            */ 417
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB548F349, /SDCardDevice/AlbumName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 27,
        /* mParentIndex        */ 0,    // ItemKey::SDCardDeviceItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 130,    // ::SDCardDeviceData::mAlbumName
        /* mItemKey            */ 372
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE21D1343, /SDCardDevice/VideoName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 27,
        /* mParentIndex        */ 0,    // ItemKey::SDCardDeviceItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 131,    // ::SDCardDeviceData::mVideoName
        /* mItemKey            */ 451
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x03519A61, /SDCardDevice/CurrentTrackNo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 27,
        /* mParentIndex        */ 0,    // ItemKey::SDCardDeviceItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 132,    // ::SDCardDeviceData::mCurrentTrackNo
        /* mItemKey            */ 6
    },
    { // 7
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3BACEE35, /SDCardDevice/TotalTrackNo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 27,
        /* mParentIndex        */ 0,    // ItemKey::SDCardDeviceItem
        /* mLocalIndex         */ 7,
        /* mDescriptorIndex    */ 133,    // ::SDCardDeviceData::mTotalTrackNo
        /* mItemKey            */ 123
    },
    { // 8
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x89F3517E, /SDCardDevice/TotalTime),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 27,
        /* mParentIndex        */ 0,    // ItemKey::SDCardDeviceItem
        /* mLocalIndex         */ 8,
        /* mDescriptorIndex    */ 134,    // ::SDCardDeviceData::mTotalTime
        /* mItemKey            */ 295
    },
    { // 9
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7F7049E6, /SDCardDevice/ElapsedTime),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 27,
        /* mParentIndex        */ 0,    // ItemKey::SDCardDeviceItem
        /* mLocalIndex         */ 9,
        /* mDescriptorIndex    */ 135,    // ::SDCardDeviceData::mElapsedTime
        /* mItemKey            */ 277
    },
    { // 10
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF660397A, /SDCardDevice/SliderTotalTime),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 27,
        /* mParentIndex        */ 0,    // ItemKey::SDCardDeviceItem
        /* mLocalIndex         */ 10,
        /* mDescriptorIndex    */ 136,    // ::SDCardDeviceData::mSliderTotalTime
        /* mItemKey            */ 502
    },
    { // 11
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x85BF7372, /SDCardDevice/SliderElapsedTime),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 27,
        /* mParentIndex        */ 0,    // ItemKey::SDCardDeviceItem
        /* mLocalIndex         */ 11,
        /* mDescriptorIndex    */ 137,    // ::SDCardDeviceData::mSliderElapsedTime
        /* mItemKey            */ 286
    },
    { // 12
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF053748F, /SDCardDevice/DragCurrentValue),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 27,
        /* mParentIndex        */ 0,    // ItemKey::SDCardDeviceItem
        /* mLocalIndex         */ 12,
        /* mDescriptorIndex    */ 138,    // ::SDCardDeviceData::mDragCurrentValue
        /* mItemKey            */ 493
    },
    { // 13
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD6D03059, /SDCardDevice/RepeatOption),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 27,
        /* mParentIndex        */ 0,    // ItemKey::SDCardDeviceItem
        /* mLocalIndex         */ 13,
        /* mDescriptorIndex    */ 139,    // ::SDCardDeviceData::mRepeatOption
        /* mItemKey            */ 432
    },
    { // 14
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xBAF7F188, /SDCardDevice/ShuffleOption),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 27,
        /* mParentIndex        */ 0,    // ItemKey::SDCardDeviceItem
        /* mLocalIndex         */ 14,
        /* mDescriptorIndex    */ 140,    // ::SDCardDeviceData::mShuffleOption
        /* mItemKey            */ 381
    },
    { // 15
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x1635838C, /SDCardDevice/SeekCurrentPosition),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 27,
        /* mParentIndex        */ 0,    // ItemKey::SDCardDeviceItem
        /* mLocalIndex         */ 15,
        /* mDescriptorIndex    */ 141,    // ::SDCardDeviceData::mSeekCurrentPosition
        /* mItemKey            */ 42
    },
    { // 16
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA9F67BD6, /SDCardDevice/PlayIconName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 27,
        /* mParentIndex        */ 0,    // ItemKey::SDCardDeviceItem
        /* mLocalIndex         */ 16,
        /* mDescriptorIndex    */ 142,    // ::SDCardDeviceData::mPlayIconName
        /* mItemKey            */ 352
    },
    { // 17
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x68BA47A2, /SDCardDevice/RepeatIconName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 27,
        /* mParentIndex        */ 0,    // ItemKey::SDCardDeviceItem
        /* mLocalIndex         */ 17,
        /* mDescriptorIndex    */ 143,    // ::SDCardDeviceData::mRepeatIconName
        /* mItemKey            */ 217
    },
    { // 18
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x1F74313B, /SDCardDevice/ShuffleIconName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 27,
        /* mParentIndex        */ 0,    // ItemKey::SDCardDeviceItem
        /* mLocalIndex         */ 18,
        /* mDescriptorIndex    */ 144,    // ::SDCardDeviceData::mShuffleIconName
        /* mItemKey            */ 62
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gID3CoverDataForSDCardHierarchyNodes[ID3CoverDataForSDCardDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE21D9604, /ID3CoverDataForSDCard),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 28,
        /* mParentIndex        */ 0,    // ItemKey::ID3CoverDataForSDCardItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 145,    // ::ID3CoverDataForSDCardData
        /* mItemKey            */ 452
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x25FF5B88, /ID3CoverDataForSDCard/Image),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 28,
        /* mParentIndex        */ 0,    // ItemKey::ID3CoverDataForSDCardItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 146,    // ::ID3CoverDataForSDCardData::mImage
        /* mItemKey            */ 77
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gVideoPlayerFullScreeenHierarchyNodes[VideoPlayerFullScreeenDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x4F87CEA6, /VideoPlayerFullScreeen),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 29,
        /* mParentIndex        */ 0,    // ItemKey::VideoPlayerFullScreeenItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 147,    // ::VideoPlayerFullScreeenData
        /* mItemKey            */ 168
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5E63FADC, /VideoPlayerFullScreeen/PlayIconName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 29,
        /* mParentIndex        */ 0,    // ItemKey::VideoPlayerFullScreeenItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 148,    // ::VideoPlayerFullScreeenData::mPlayIconName
        /* mItemKey            */ 196
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gIpodButtonHierarchyNodes[IpodButtonDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB42470E4, /IpodButton),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 30,
        /* mParentIndex        */ 0,    // ItemKey::IpodButtonItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 149,    // ::IpodButtonData
        /* mItemKey            */ 369
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x143FEC44, /IpodButton/i8IsActive),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 30,
        /* mParentIndex        */ 0,    // ItemKey::IpodButtonItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 150,    // ::IpodButtonData::mi8IsActive
        /* mItemKey            */ 34
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gAuxButtonHierarchyNodes[AuxButtonDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE725FE93, /AuxButton),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 31,
        /* mParentIndex        */ 0,    // ItemKey::AuxButtonItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 151,    // ::AuxButtonData
        /* mItemKey            */ 465
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD1E375E9, /AuxButton/i8IsActive),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 31,
        /* mParentIndex        */ 0,    // ItemKey::AuxButtonItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 152,    // ::AuxButtonData::mi8IsActive
        /* mItemKey            */ 423
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gUSBButtonHierarchyNodes[USBButtonDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xCA0E9621, /USBButton),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 32,
        /* mParentIndex        */ 0,    // ItemKey::USBButtonItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 153,    // ::USBButtonData
        /* mItemKey            */ 404
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x702FD86B, /USBButton/i8IsActive),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 32,
        /* mParentIndex        */ 0,    // ItemKey::USBButtonItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 154,    // ::USBButtonData::mi8IsActive
        /* mItemKey            */ 238
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gUSB1ButtonHierarchyNodes[USB1ButtonDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5ADE2C08, /USB1Button),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 33,
        /* mParentIndex        */ 0,    // ItemKey::USB1ButtonItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 155,    // ::USB1ButtonData
        /* mItemKey            */ 189
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7FBDFDE9, /USB1Button/isConnectedWithHub),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 33,
        /* mParentIndex        */ 0,    // ItemKey::USB1ButtonItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 156,    // ::USB1ButtonData::misConnectedWithHub
        /* mItemKey            */ 278
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gUSB2ButtonHierarchyNodes[USB2ButtonDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x6B2F8843, /USB2Button),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 34,
        /* mParentIndex        */ 0,    // ItemKey::USB2ButtonItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 157,    // ::USB2ButtonData
        /* mItemKey            */ 227
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB55833F0, /USB2Button/i8IsActive),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 34,
        /* mParentIndex        */ 0,    // ItemKey::USB2ButtonItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 158,    // ::USB2ButtonData::mi8IsActive
        /* mItemKey            */ 373
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSDCardButtonHierarchyNodes[SDCardButtonDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xFCBB7701, /SDCardButton),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 35,
        /* mParentIndex        */ 0,    // ItemKey::SDCardButtonItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 159,    // ::SDCardButtonData
        /* mItemKey            */ 517
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5C9F9A3B, /SDCardButton/i8IsActive),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 35,
        /* mParentIndex        */ 0,    // ItemKey::SDCardButtonItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 160,    // ::SDCardButtonData::mi8IsActive
        /* mItemKey            */ 192
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gBTButtonHierarchyNodes[BTButtonDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x94084EDE, /BTButton),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 36,
        /* mParentIndex        */ 0,    // ItemKey::BTButtonItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 161,    // ::BTButtonData
        /* mItemKey            */ 311
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x4E87A0E9, /BTButton/i8IsActive),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 36,
        /* mParentIndex        */ 0,    // ItemKey::BTButtonItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 162,    // ::BTButtonData::mi8IsActive
        /* mItemKey            */ 164
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gExternalDVDButtonHierarchyNodes[ExternalDVDButtonDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x26006D3B, /ExternalDVDButton),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 37,
        /* mParentIndex        */ 0,    // ItemKey::ExternalDVDButtonItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 163,    // ::ExternalDVDButtonData
        /* mItemKey            */ 78
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x84FE390D, /ExternalDVDButton/i8IsActive),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 37,
        /* mParentIndex        */ 0,    // ItemKey::ExternalDVDButtonItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 164,    // ::ExternalDVDButtonData::mi8IsActive
        /* mItemKey            */ 285
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gCamport1USBButtonHierarchyNodes[Camport1USBButtonDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x38E3A1FF, /Camport1USBButton),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 38,
        /* mParentIndex        */ 0,    // ItemKey::Camport1USBButtonItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 165,    // ::Camport1USBButtonData
        /* mItemKey            */ 115
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x204002DF, /Camport1USBButton/i8IsActive),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 38,
        /* mParentIndex        */ 0,    // ItemKey::Camport1USBButtonItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 166,    // ::Camport1USBButtonData::mi8IsActive
        /* mItemKey            */ 64
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gCamport1HDMIButtonHierarchyNodes[Camport1HDMIButtonDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x4FC328FE, /Camport1HDMIButton),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 39,
        /* mParentIndex        */ 0,    // ItemKey::Camport1HDMIButtonItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 167,    // ::Camport1HDMIButtonData
        /* mItemKey            */ 170
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x15E05BED, /Camport1HDMIButton/i8IsActive),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 39,
        /* mParentIndex        */ 0,    // ItemKey::Camport1HDMIButtonItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 168,    // ::Camport1HDMIButtonData::mi8IsActive
        /* mItemKey            */ 40
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gExternalDVDStatusHierarchyNodes[ExternalDVDStatusDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x8E515DE1, /ExternalDVDStatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 40,
        /* mParentIndex        */ 0,    // ItemKey::ExternalDVDStatusItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 169,    // ::ExternalDVDStatusData
        /* mItemKey            */ 304
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xEBEE8A0B, /ExternalDVDStatus/i8IsChecked),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 40,
        /* mParentIndex        */ 0,    // ItemKey::ExternalDVDStatusItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 170,    // ::ExternalDVDStatusData::mi8IsChecked
        /* mItemKey            */ 485
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gTAStatusHierarchyNodes[TAStatusDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC39FE188, /TAStatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 41,
        /* mParentIndex        */ 0,    // ItemKey::TAStatusItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 171,    // ::TAStatusData
        /* mItemKey            */ 394
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x9DDB3F1D, /TAStatus/i8IsChecked),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 41,
        /* mParentIndex        */ 0,    // ItemKey::TAStatusItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 172,    // ::TAStatusData::mi8IsChecked
        /* mItemKey            */ 332
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gAUXStatusHierarchyNodes[AUXStatusDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x31BFA9EE, /AUXStatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 42,
        /* mParentIndex        */ 0,    // ItemKey::AUXStatusItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 173,    // ::AUXStatusData
        /* mItemKey            */ 105
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xFAFA3317, /AUXStatus/i8IsChecked),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 42,
        /* mParentIndex        */ 0,    // ItemKey::AUXStatusItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 174,    // ::AUXStatusData::mi8IsChecked
        /* mItemKey            */ 513
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSDCardStatusHierarchyNodes[SDCardStatusDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x43029659, /SDCardStatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 43,
        /* mParentIndex        */ 0,    // ItemKey::SDCardStatusItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 175,    // ::SDCardStatusData
        /* mItemKey            */ 144
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x02B38198, /SDCardStatus/i8IsChecked),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 43,
        /* mParentIndex        */ 0,    // ItemKey::SDCardStatusItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 176,    // ::SDCardStatusData::mi8IsChecked
        /* mItemKey            */ 4
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gTitleTabHierarchyNodes[TitleTabDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE087A4DA, /TitleTab),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 44,
        /* mParentIndex        */ 0,    // ItemKey::TitleTabItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 177,    // ::TitleTabData
        /* mItemKey            */ 446
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5DD495E7, /TitleTab/i8IsActive),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 44,
        /* mParentIndex        */ 0,    // ItemKey::TitleTabItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 178,    // ::TitleTabData::mi8IsActive
        /* mItemKey            */ 195
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gArtistTabHierarchyNodes[ArtistTabDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x99BC14DE, /ArtistTab),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 45,
        /* mParentIndex        */ 0,    // ItemKey::ArtistTabItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 179,    // ::ArtistTabData
        /* mItemKey            */ 325
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x2AA0B712, /ArtistTab/i8IsActive),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 45,
        /* mParentIndex        */ 0,    // ItemKey::ArtistTabItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 180,    // ::ArtistTabData::mi8IsActive
        /* mItemKey            */ 91
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gAlbumTabHierarchyNodes[AlbumTabDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xDA6313A4, /AlbumTab),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 46,
        /* mParentIndex        */ 0,    // ItemKey::AlbumTabItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 181,    // ::AlbumTabData
        /* mItemKey            */ 435
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC75BD836, /AlbumTab/i8IsActive),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 46,
        /* mParentIndex        */ 0,    // ItemKey::AlbumTabItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 182,    // ::AlbumTabData::mi8IsActive
        /* mItemKey            */ 399
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gGenreTabHierarchyNodes[GenreTabDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x2807D1F3, /GenreTab),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 47,
        /* mParentIndex        */ 0,    // ItemKey::GenreTabItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 183,    // ::GenreTabData
        /* mItemKey            */ 85
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x4268161A, /GenreTab/i8IsActive),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 47,
        /* mParentIndex        */ 0,    // ItemKey::GenreTabItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 184,    // ::GenreTabData::mi8IsActive
        /* mItemKey            */ 141
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gFolderTabHierarchyNodes[FolderTabDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x861C9BA9, /FolderTab),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 48,
        /* mParentIndex        */ 0,    // ItemKey::FolderTabItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 185,    // ::FolderTabData
        /* mItemKey            */ 288
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x4310061D, /FolderTab/i8IsActive),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 48,
        /* mParentIndex        */ 0,    // ItemKey::FolderTabItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 186,    // ::FolderTabData::mi8IsActive
        /* mItemKey            */ 145
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gPlaylistTabHierarchyNodes[PlaylistTabDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x694D9AEE, /PlaylistTab),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 49,
        /* mParentIndex        */ 0,    // ItemKey::PlaylistTabItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 187,    // ::PlaylistTabData
        /* mItemKey            */ 223
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE89946B7, /PlaylistTab/i8IsActive),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 49,
        /* mParentIndex        */ 0,    // ItemKey::PlaylistTabItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 188,    // ::PlaylistTabData::mi8IsActive
        /* mItemKey            */ 472
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gAudiobookTabHierarchyNodes[AudiobookTabDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE103CECD, /AudiobookTab),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 50,
        /* mParentIndex        */ 0,    // ItemKey::AudiobookTabItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 189,    // ::AudiobookTabData
        /* mItemKey            */ 447
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x0D1F689B, /AudiobookTab/i8IsActive),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 50,
        /* mParentIndex        */ 0,    // ItemKey::AudiobookTabItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 190,    // ::AudiobookTabData::mi8IsActive
        /* mItemKey            */ 22
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gPodcastTabHierarchyNodes[PodcastTabDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x66DAA1C7, /PodcastTab),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 51,
        /* mParentIndex        */ 0,    // ItemKey::PodcastTabItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 191,    // ::PodcastTabData
        /* mItemKey            */ 214
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x6D7FCD2B, /PodcastTab/i8IsActive),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 51,
        /* mParentIndex        */ 0,    // ItemKey::PodcastTabItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 192,    // ::PodcastTabData::mi8IsActive
        /* mItemKey            */ 233
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gVideoTabHierarchyNodes[VideoTabDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x18FBEA0C, /VideoTab),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 52,
        /* mParentIndex        */ 0,    // ItemKey::VideoTabItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 193,    // ::VideoTabData
        /* mItemKey            */ 47
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x157579A2, /VideoTab/i8IsActive),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 52,
        /* mParentIndex        */ 0,    // ItemKey::VideoTabItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 194,    // ::VideoTabData::mi8IsActive
        /* mItemKey            */ 38
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gExternalDVDVisibililtyHierarchyNodes[ExternalDVDVisibililtyDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xCAC13EE0, /ExternalDVDVisibililty),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 53,
        /* mParentIndex        */ 0,    // ItemKey::ExternalDVDVisibililtyItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 195,    // ::ExternalDVDVisibililtyData
        /* mItemKey            */ 406
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xCC6B861E, /ExternalDVDVisibililty/i8Isvisible),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 53,
        /* mParentIndex        */ 0,    // ItemKey::ExternalDVDVisibililtyItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 196,    // ::ExternalDVDVisibililtyData::mi8Isvisible
        /* mItemKey            */ 414
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gAUXVisibilityHierarchyNodes[AUXVisibilityDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7C115B36, /AUXVisibility),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 54,
        /* mParentIndex        */ 0,    // ItemKey::AUXVisibilityItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 197,    // ::AUXVisibilityData
        /* mItemKey            */ 267
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE1438DF4, /AUXVisibility/i8Isvisible),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 54,
        /* mParentIndex        */ 0,    // ItemKey::AUXVisibilityItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 198,    // ::AUXVisibilityData::mi8Isvisible
        /* mItemKey            */ 448
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSDCardVisibilityHierarchyNodes[SDCardVisibilityDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xCC5ABAFB, /SDCardVisibility),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 55,
        /* mParentIndex        */ 0,    // ItemKey::SDCardVisibilityItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 199,    // ::SDCardVisibilityData
        /* mItemKey            */ 413
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7B847D09, /SDCardVisibility/i8Isvisible),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 55,
        /* mParentIndex        */ 0,    // ItemKey::SDCardVisibilityItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 200,    // ::SDCardVisibilityData::mi8Isvisible
        /* mItemKey            */ 266
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gTAIconStatusHierarchyNodes[TAIconStatusDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x1C7BFF63, /TAIconStatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 56,
        /* mParentIndex        */ 0,    // ItemKey::TAIconStatusItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 201,    // ::TAIconStatusData
        /* mItemKey            */ 51
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3124C014, /TAIconStatus/TAIconIndex),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 56,
        /* mParentIndex        */ 0,    // ItemKey::TAIconStatusItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 202,    // ::TAIconStatusData::mTAIconIndex
        /* mItemKey            */ 104
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gDeviceConnectStatusHierarchyNodes[DeviceConnectStatusDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE8A4C3FD, /DeviceConnectStatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 57,
        /* mParentIndex        */ 0,    // ItemKey::DeviceConnectStatusItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 203,    // ::DeviceConnectStatusData
        /* mItemKey            */ 473
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xDFB8374E, /DeviceConnectStatus/MediaMessage1),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 57,
        /* mParentIndex        */ 0,    // ItemKey::DeviceConnectStatusItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 204,    // ::DeviceConnectStatusData::mMediaMessage1
        /* mItemKey            */ 442
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xCF65968D, /DeviceConnectStatus/MediaMessage2),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 57,
        /* mParentIndex        */ 0,    // ItemKey::DeviceConnectStatusItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 205,    // ::DeviceConnectStatusData::mMediaMessage2
        /* mItemKey            */ 421
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE217BBF1, /DeviceConnectStatus/MediaMessage3),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 57,
        /* mParentIndex        */ 0,    // ItemKey::DeviceConnectStatusItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 206,    // ::DeviceConnectStatusData::mMediaMessage3
        /* mItemKey            */ 450
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF3DA5F76, /DeviceConnectStatus/MediaMessage4),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 57,
        /* mParentIndex        */ 0,    // ItemKey::DeviceConnectStatusItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 207,    // ::DeviceConnectStatusData::mMediaMessage4
        /* mItemKey            */ 498
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA83B22D9, /DeviceConnectStatus/Message1Visible),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 57,
        /* mParentIndex        */ 0,    // ItemKey::DeviceConnectStatusItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 208,    // ::DeviceConnectStatusData::mMessage1Visible
        /* mItemKey            */ 350
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5E8162CD, /DeviceConnectStatus/Message2Visible),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 57,
        /* mParentIndex        */ 0,    // ItemKey::DeviceConnectStatusItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 209,    // ::DeviceConnectStatusData::mMessage2Visible
        /* mItemKey            */ 197
    },
    { // 7
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF36E9264, /DeviceConnectStatus/Message3Visible),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 57,
        /* mParentIndex        */ 0,    // ItemKey::DeviceConnectStatusItem
        /* mLocalIndex         */ 7,
        /* mDescriptorIndex    */ 210,    // ::DeviceConnectStatusData::mMessage3Visible
        /* mItemKey            */ 496
    },
    { // 8
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xCB326967, /DeviceConnectStatus/Message4Visible),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 57,
        /* mParentIndex        */ 0,    // ItemKey::DeviceConnectStatusItem
        /* mLocalIndex         */ 8,
        /* mDescriptorIndex    */ 211,    // ::DeviceConnectStatusData::mMessage4Visible
        /* mItemKey            */ 410
    },
    { // 9
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x1C1FF4B6, /DeviceConnectStatus/MediaMessageUpdateFlag),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 57,
        /* mParentIndex        */ 0,    // ItemKey::DeviceConnectStatusItem
        /* mLocalIndex         */ 9,
        /* mDescriptorIndex    */ 212,    // ::DeviceConnectStatusData::mMediaMessageUpdateFlag
        /* mItemKey            */ 50
    },
    { // 10
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x25EDEE22, /DeviceConnectStatus/MediaMessageDeviceConnected),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 57,
        /* mParentIndex        */ 0,    // ItemKey::DeviceConnectStatusItem
        /* mLocalIndex         */ 10,
        /* mDescriptorIndex    */ 213,    // ::DeviceConnectStatusData::mMediaMessageDeviceConnected
        /* mItemKey            */ 76
    },
    { // 11
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3F4531E7, /DeviceConnectStatus/MediaMessageDeviceDisconnected),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 57,
        /* mParentIndex        */ 0,    // ItemKey::DeviceConnectStatusItem
        /* mLocalIndex         */ 11,
        /* mDescriptorIndex    */ 214,    // ::DeviceConnectStatusData::mMediaMessageDeviceDisconnected
        /* mItemKey            */ 136
    },
    { // 12
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xCCF9C732, /DeviceConnectStatus/MediaMessageNoDevice),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 57,
        /* mParentIndex        */ 0,    // ItemKey::DeviceConnectStatusItem
        /* mLocalIndex         */ 12,
        /* mDescriptorIndex    */ 215,    // ::DeviceConnectStatusData::mMediaMessageNoDevice
        /* mItemKey            */ 416
    },
    { // 13
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x9002B075, /DeviceConnectStatus/MessageDeviceConnectedVisible),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 57,
        /* mParentIndex        */ 0,    // ItemKey::DeviceConnectStatusItem
        /* mLocalIndex         */ 13,
        /* mDescriptorIndex    */ 216,    // ::DeviceConnectStatusData::mMessageDeviceConnectedVisible
        /* mItemKey            */ 307
    },
    { // 14
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC57A85D7, /DeviceConnectStatus/MessageDeviceDisconnectedVisible),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 57,
        /* mParentIndex        */ 0,    // ItemKey::DeviceConnectStatusItem
        /* mLocalIndex         */ 14,
        /* mDescriptorIndex    */ 217,    // ::DeviceConnectStatusData::mMessageDeviceDisconnectedVisible
        /* mItemKey            */ 396
    },
    { // 15
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x8ACE9F39, /DeviceConnectStatus/MessageNoDeviceVisible),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 57,
        /* mParentIndex        */ 0,    // ItemKey::DeviceConnectStatusItem
        /* mLocalIndex         */ 15,
        /* mDescriptorIndex    */ 218,    // ::DeviceConnectStatusData::mMessageNoDeviceVisible
        /* mItemKey            */ 298
    },
    { // 16
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x0654C080, /DeviceConnectStatus/MediamessageIconindex),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 57,
        /* mParentIndex        */ 0,    // ItemKey::DeviceConnectStatusItem
        /* mLocalIndex         */ 16,
        /* mDescriptorIndex    */ 219,    // ::DeviceConnectStatusData::mMediamessageIconindex
        /* mItemKey            */ 11
    },
    { // 17
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xBE6A422F, /DeviceConnectStatus/MediamessageIconVisibleState),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 57,
        /* mParentIndex        */ 0,    // ItemKey::DeviceConnectStatusItem
        /* mLocalIndex         */ 17,
        /* mDescriptorIndex    */ 220,    // ::DeviceConnectStatusData::mMediamessageIconVisibleState
        /* mItemKey            */ 388
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gExternalDeviceConnectedHierarchyNodes[ExternalDeviceConnectedDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x1DA0FF9A, /ExternalDeviceConnected),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 58,
        /* mParentIndex        */ 0,    // ItemKey::ExternalDeviceConnectedItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 221,    // ::ExternalDeviceConnectedData
        /* mItemKey            */ 55
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x24892055, /ExternalDeviceConnected/DbDownloadDevice),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 58,
        /* mParentIndex        */ 0,    // ItemKey::ExternalDeviceConnectedItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 222,    // ::ExternalDeviceConnectedData::mDbDownloadDevice
        /* mItemKey            */ 72
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gDBInPreparationHierarchyNodes[DBInPreparationDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x4FABAB3A, /DBInPreparation),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 59,
        /* mParentIndex        */ 0,    // ItemKey::DBInPreparationItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 223,    // ::DBInPreparationData
        /* mItemKey            */ 169
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7338504E, /DBInPreparation/DeviceType),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 59,
        /* mParentIndex        */ 0,    // ItemKey::DBInPreparationItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 224,    // ::DBInPreparationData::mDeviceType
        /* mItemKey            */ 249
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gDBDownloadErrorHierarchyNodes[DBDownloadErrorDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7F1827D8, /DBDownloadError),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 60,
        /* mParentIndex        */ 0,    // ItemKey::DBDownloadErrorItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 225,    // ::DBDownloadErrorData
        /* mItemKey            */ 275
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x70791561, /DBDownloadError/ExternalDeviceType),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 60,
        /* mParentIndex        */ 0,    // ItemKey::DBDownloadErrorItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 226,    // ::DBDownloadErrorData::mExternalDeviceType
        /* mItemKey            */ 241
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gDeviceNameAndStatusHierarchyNodes[DeviceNameAndStatusDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x8B7F1EAD, /DeviceNameAndStatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 61,
        /* mParentIndex        */ 0,    // ItemKey::DeviceNameAndStatusItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 227,    // ::DeviceNameAndStatusData
        /* mItemKey            */ 300
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA42A518D, /DeviceNameAndStatus/BTDeviceMuteStatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 61,
        /* mParentIndex        */ 0,    // ItemKey::DeviceNameAndStatusItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 228,    // ::DeviceNameAndStatusData::mBTDeviceMuteStatus
        /* mItemKey            */ 342
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x6572D58B, /DeviceNameAndStatus/AUXMuteStatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 61,
        /* mParentIndex        */ 0,    // ItemKey::DeviceNameAndStatusItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 229,    // ::DeviceNameAndStatusData::mAUXMuteStatus
        /* mItemKey            */ 210
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xCE38FC08, /DeviceNameAndStatus/ExternalDVDMuteStatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 61,
        /* mParentIndex        */ 0,    // ItemKey::DeviceNameAndStatusItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 230,    // ::DeviceNameAndStatusData::mExternalDVDMuteStatus
        /* mItemKey            */ 419
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gBrowseListSizeHierarchyNodes[BrowseListSizeDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x8ABC9443, /BrowseListSize),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 62,
        /* mParentIndex        */ 0,    // ItemKey::BrowseListSizeItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 231,    // ::BrowseListSizeData
        /* mItemKey            */ 297
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7715989A, /BrowseListSize/ArtistWindowListSize),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 62,
        /* mParentIndex        */ 0,    // ItemKey::BrowseListSizeItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 232,    // ::BrowseListSizeData::mArtistWindowListSize
        /* mItemKey            */ 260
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xCAEF06C4, /BrowseListSize/AlbumWindowListSize),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 62,
        /* mParentIndex        */ 0,    // ItemKey::BrowseListSizeItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 233,    // ::BrowseListSizeData::mAlbumWindowListSize
        /* mItemKey            */ 408
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x061B3D10, /BrowseListSize/GenreWindowListSize),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 62,
        /* mParentIndex        */ 0,    // ItemKey::BrowseListSizeItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 234,    // ::BrowseListSizeData::mGenreWindowListSize
        /* mItemKey            */ 10
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x028C35E6, /BrowseListSize/PodcastWindowListSize),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 62,
        /* mParentIndex        */ 0,    // ItemKey::BrowseListSizeItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 235,    // ::BrowseListSizeData::mPodcastWindowListSize
        /* mItemKey            */ 3
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x366C2ECA, /BrowseListSize/VideoWindowListSize),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 62,
        /* mParentIndex        */ 0,    // ItemKey::BrowseListSizeItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 236,    // ::BrowseListSizeData::mVideoWindowListSize
        /* mItemKey            */ 113
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gBrowseListSelectedLineHierarchyNodes[BrowseListSelectedLineDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x40B2481E, /BrowseListSelectedLine),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 63,
        /* mParentIndex        */ 0,    // ItemKey::BrowseListSelectedLineItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 237,    // ::BrowseListSelectedLineData
        /* mItemKey            */ 138
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3BEFAA08, /BrowseListSelectedLine/ArtistSelected),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 63,
        /* mParentIndex        */ 0,    // ItemKey::BrowseListSelectedLineItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 238,    // ::BrowseListSelectedLineData::mArtistSelected
        /* mItemKey            */ 124
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xCFEA53D9, /BrowseListSelectedLine/AlbumSelected),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 63,
        /* mParentIndex        */ 0,    // ItemKey::BrowseListSelectedLineItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 239,    // ::BrowseListSelectedLineData::mAlbumSelected
        /* mItemKey            */ 422
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD73159F6, /BrowseListSelectedLine/GenreSelected),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 63,
        /* mParentIndex        */ 0,    // ItemKey::BrowseListSelectedLineItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 240,    // ::BrowseListSelectedLineData::mGenreSelected
        /* mItemKey            */ 433
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x6EF74E85, /BrowseListSelectedLine/PodcastSelected),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 63,
        /* mParentIndex        */ 0,    // ItemKey::BrowseListSelectedLineItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 241,    // ::BrowseListSelectedLineData::mPodcastSelected
        /* mItemKey            */ 237
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC74A2C8B, /BrowseListSelectedLine/VideoSelected),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 63,
        /* mParentIndex        */ 0,    // ItemKey::BrowseListSelectedLineItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 242,    // ::BrowseListSelectedLineData::mVideoSelected
        /* mItemKey            */ 398
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gArtist_AlbumListSizeHierarchyNodes[Artist_AlbumListSizeDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xAB8AB714, /Artist_AlbumListSize),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 64,
        /* mParentIndex        */ 0,    // ItemKey::Artist_AlbumListSizeItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 243,    // ::Artist_AlbumListSizeData
        /* mItemKey            */ 355
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x4B451505, /Artist_AlbumListSize/Artist_AlbumWindowListSize),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 64,
        /* mParentIndex        */ 0,    // ItemKey::Artist_AlbumListSizeItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 244,    // ::Artist_AlbumListSizeData::mArtist_AlbumWindowListSize
        /* mItemKey            */ 159
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gArtist_AlbumListSelectedLineHierarchyNodes[Artist_AlbumListSelectedLineDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE97D5D2B, /Artist_AlbumListSelectedLine),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 65,
        /* mParentIndex        */ 0,    // ItemKey::Artist_AlbumListSelectedLineItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 245,    // ::Artist_AlbumListSelectedLineData
        /* mItemKey            */ 477
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xEB37CF69, /Artist_AlbumListSelectedLine/Artist_AlbumSelected),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 65,
        /* mParentIndex        */ 0,    // ItemKey::Artist_AlbumListSelectedLineItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 246,    // ::Artist_AlbumListSelectedLineData::mArtist_AlbumSelected
        /* mItemKey            */ 483
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gArtist_Album_TitleListSizeHierarchyNodes[Artist_Album_TitleListSizeDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x07CB863E, /Artist_Album_TitleListSize),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 66,
        /* mParentIndex        */ 0,    // ItemKey::Artist_Album_TitleListSizeItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 247,    // ::Artist_Album_TitleListSizeData
        /* mItemKey            */ 15
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE9ACFAF8, /Artist_Album_TitleListSize/ArtistAlbumTitleWindowListSize),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 66,
        /* mParentIndex        */ 0,    // ItemKey::Artist_Album_TitleListSizeItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 248,    // ::Artist_Album_TitleListSizeData::mArtistAlbumTitleWindowListSize
        /* mItemKey            */ 478
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gArtist_Album_TitleListSelectedLineHierarchyNodes[Artist_Album_TitleListSelectedLineDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x847C3F43, /Artist_Album_TitleListSelectedLine),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 67,
        /* mParentIndex        */ 0,    // ItemKey::Artist_Album_TitleListSelectedLineItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 249,    // ::Artist_Album_TitleListSelectedLineData
        /* mItemKey            */ 284
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x97FBF09A, /Artist_Album_TitleListSelectedLine/ArtistAlbumTitleSelected),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 67,
        /* mParentIndex        */ 0,    // ItemKey::Artist_Album_TitleListSelectedLineItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 250,    // ::Artist_Album_TitleListSelectedLineData::mArtistAlbumTitleSelected
        /* mItemKey            */ 319
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gAlbum_TitleListSizeHierarchyNodes[Album_TitleListSizeDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5382C605, /Album_TitleListSize),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 68,
        /* mParentIndex        */ 0,    // ItemKey::Album_TitleListSizeItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 251,    // ::Album_TitleListSizeData
        /* mItemKey            */ 176
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x6AA4BFCB, /Album_TitleListSize/AlbumTitleWindowListSize),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 68,
        /* mParentIndex        */ 0,    // ItemKey::Album_TitleListSizeItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 252,    // ::Album_TitleListSizeData::mAlbumTitleWindowListSize
        /* mItemKey            */ 225
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gAlbum_TitleListSelectedLineHierarchyNodes[Album_TitleListSelectedLineDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x31205C56, /Album_TitleListSelectedLine),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 69,
        /* mParentIndex        */ 0,    // ItemKey::Album_TitleListSelectedLineItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 253,    // ::Album_TitleListSelectedLineData
        /* mItemKey            */ 103
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x397904EB, /Album_TitleListSelectedLine/AlbumTitleSelected),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 69,
        /* mParentIndex        */ 0,    // ItemKey::Album_TitleListSelectedLineItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 254,    // ::Album_TitleListSelectedLineData::mAlbumTitleSelected
        /* mItemKey            */ 118
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gTitle_ListSizeHierarchyNodes[Title_ListSizeDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x9DA09334, /Title_ListSize),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 70,
        /* mParentIndex        */ 0,    // ItemKey::Title_ListSizeItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 255,    // ::Title_ListSizeData
        /* mItemKey            */ 331
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x66581067, /Title_ListSize/TitleWindowListSize),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 70,
        /* mParentIndex        */ 0,    // ItemKey::Title_ListSizeItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 256,    // ::Title_ListSizeData::mTitleWindowListSize
        /* mItemKey            */ 211
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gTitleListSelectedLineHierarchyNodes[TitleListSelectedLineDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x86E18909, /TitleListSelectedLine),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 71,
        /* mParentIndex        */ 0,    // ItemKey::TitleListSelectedLineItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 257,    // ::TitleListSelectedLineData
        /* mItemKey            */ 289
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xDC5BD43D, /TitleListSelectedLine/TitleListSelectedLine),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 71,
        /* mParentIndex        */ 0,    // ItemKey::TitleListSelectedLineItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 258,    // ::TitleListSelectedLineData::mTitleListSelectedLine
        /* mItemKey            */ 436
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gGenre_ArtistListSizeHierarchyNodes[Genre_ArtistListSizeDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xBE312C37, /Genre_ArtistListSize),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 72,
        /* mParentIndex        */ 0,    // ItemKey::Genre_ArtistListSizeItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 259,    // ::Genre_ArtistListSizeData
        /* mItemKey            */ 387
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x2D1DA38A, /Genre_ArtistListSize/GenreArtistWindowListSize),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 72,
        /* mParentIndex        */ 0,    // ItemKey::Genre_ArtistListSizeItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 260,    // ::Genre_ArtistListSizeData::mGenreArtistWindowListSize
        /* mItemKey            */ 96
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gGenre_ArtistListSelectedLineHierarchyNodes[Genre_ArtistListSelectedLineDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x21E901B1, /Genre_ArtistListSelectedLine),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 73,
        /* mParentIndex        */ 0,    // ItemKey::Genre_ArtistListSelectedLineItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 261,    // ::Genre_ArtistListSelectedLineData
        /* mItemKey            */ 67
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xDF048A63, /Genre_ArtistListSelectedLine/GenreArtistSelected),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 73,
        /* mParentIndex        */ 0,    // ItemKey::Genre_ArtistListSelectedLineItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 262,    // ::Genre_ArtistListSelectedLineData::mGenreArtistSelected
        /* mItemKey            */ 440
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gGenre_AllAlbumsListSizeHierarchyNodes[Genre_AllAlbumsListSizeDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x4817B5EB, /Genre_AllAlbumsListSize),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 74,
        /* mParentIndex        */ 0,    // ItemKey::Genre_AllAlbumsListSizeItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 263,    // ::Genre_AllAlbumsListSizeData
        /* mItemKey            */ 154
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x0134A9A6, /Genre_AllAlbumsListSize/GenreAllAlbumsWindowListSize),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 74,
        /* mParentIndex        */ 0,    // ItemKey::Genre_AllAlbumsListSizeItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 264,    // ::Genre_AllAlbumsListSizeData::mGenreAllAlbumsWindowListSize
        /* mItemKey            */ 2
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gGenre_AllAlbumsListSelectedLineHierarchyNodes[Genre_AllAlbumsListSelectedLineDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xFEACF5A6, /Genre_AllAlbumsListSelectedLine),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 75,
        /* mParentIndex        */ 0,    // ItemKey::Genre_AllAlbumsListSelectedLineItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 265,    // ::Genre_AllAlbumsListSelectedLineData
        /* mItemKey            */ 526
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x4BAE1E63, /Genre_AllAlbumsListSelectedLine/GenreAllAlbumsSelected),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 75,
        /* mParentIndex        */ 0,    // ItemKey::Genre_AllAlbumsListSelectedLineItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 266,    // ::Genre_AllAlbumsListSelectedLineData::mGenreAllAlbumsSelected
        /* mItemKey            */ 161
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gGenre_Artist_AlbumListSizeHierarchyNodes[Genre_Artist_AlbumListSizeDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xBD088031, /Genre_Artist_AlbumListSize),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 76,
        /* mParentIndex        */ 0,    // ItemKey::Genre_Artist_AlbumListSizeItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 267,    // ::Genre_Artist_AlbumListSizeData
        /* mItemKey            */ 384
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF6FC2BBA, /Genre_Artist_AlbumListSize/GenreArtistAlbumWindowListSize),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 76,
        /* mParentIndex        */ 0,    // ItemKey::Genre_Artist_AlbumListSizeItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 268,    // ::Genre_Artist_AlbumListSizeData::mGenreArtistAlbumWindowListSize
        /* mItemKey            */ 504
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gGenre_Artist_AlbumListSelectedLineHierarchyNodes[Genre_Artist_AlbumListSelectedLineDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3927A3D9, /Genre_Artist_AlbumListSelectedLine),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 77,
        /* mParentIndex        */ 0,    // ItemKey::Genre_Artist_AlbumListSelectedLineItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 269,    // ::Genre_Artist_AlbumListSelectedLineData
        /* mItemKey            */ 117
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x796037BD, /Genre_Artist_AlbumListSelectedLine/GenreArtistAlbumSelected),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 77,
        /* mParentIndex        */ 0,    // ItemKey::Genre_Artist_AlbumListSelectedLineItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 270,    // ::Genre_Artist_AlbumListSelectedLineData::mGenreArtistAlbumSelected
        /* mItemKey            */ 262
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gGenre_TitleListSizeHierarchyNodes[Genre_TitleListSizeDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xDE70D748, /Genre_TitleListSize),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 78,
        /* mParentIndex        */ 0,    // ItemKey::Genre_TitleListSizeItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 271,    // ::Genre_TitleListSizeData
        /* mItemKey            */ 438
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x353DEF65, /Genre_TitleListSize/GenreTitleWindowListSize),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 78,
        /* mParentIndex        */ 0,    // ItemKey::Genre_TitleListSizeItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 272,    // ::Genre_TitleListSizeData::mGenreTitleWindowListSize
        /* mItemKey            */ 110
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gGenre_TitleListSelectedLineHierarchyNodes[Genre_TitleListSelectedLineDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5C154B38, /Genre_TitleListSelectedLine),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 79,
        /* mParentIndex        */ 0,    // ItemKey::Genre_TitleListSelectedLineItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 273,    // ::Genre_TitleListSelectedLineData
        /* mItemKey            */ 191
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE74A7367, /Genre_TitleListSelectedLine/GenreTitleSelected),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 79,
        /* mParentIndex        */ 0,    // ItemKey::Genre_TitleListSelectedLineItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 274,    // ::Genre_TitleListSelectedLineData::mGenreTitleSelected
        /* mItemKey            */ 466
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gFastForwardRewindPopupHierarchyNodes[FastForwardRewindPopupDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x21D55E7F, /FastForwardRewindPopup),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 80,
        /* mParentIndex        */ 0,    // ItemKey::FastForwardRewindPopupItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 275,    // ::FastForwardRewindPopupData
        /* mItemKey            */ 66
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE353FF1E, /FastForwardRewindPopup/FastForwardRewindText),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 80,
        /* mParentIndex        */ 0,    // ItemKey::FastForwardRewindPopupItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 276,    // ::FastForwardRewindPopupData::mFastForwardRewindText
        /* mItemKey            */ 459
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC163B1EA, /FastForwardRewindPopup/CurrentValue),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 80,
        /* mParentIndex        */ 0,    // ItemKey::FastForwardRewindPopupItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 277,    // ::FastForwardRewindPopupData::mCurrentValue
        /* mItemKey            */ 391
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gBTShuffleHierarchyNodes[BTShuffleDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x667FB80D, /BTShuffle),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 81,
        /* mParentIndex        */ 0,    // ItemKey::BTShuffleItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 278,    // ::BTShuffleData
        /* mItemKey            */ 213
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF5408A1C, /BTShuffle/BTShuffleOption),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 81,
        /* mParentIndex        */ 0,    // ItemKey::BTShuffleItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 279,    // ::BTShuffleData::mBTShuffleOption
        /* mItemKey            */ 501
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x6341B371, /BTShuffle/BTShuffleIconName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 81,
        /* mParentIndex        */ 0,    // ItemKey::BTShuffleItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 280,    // ::BTShuffleData::mBTShuffleIconName
        /* mItemKey            */ 208
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gBTRepeatHierarchyNodes[BTRepeatDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x71CD12C4, /BTRepeat),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 82,
        /* mParentIndex        */ 0,    // ItemKey::BTRepeatItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 281,    // ::BTRepeatData
        /* mItemKey            */ 244
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x9F9A4CFE, /BTRepeat/BTRepeatOption),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 82,
        /* mParentIndex        */ 0,    // ItemKey::BTRepeatItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 282,    // ::BTRepeatData::mBTRepeatOption
        /* mItemKey            */ 334
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x985A2168, /BTRepeat/BTRepeatIconName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 82,
        /* mParentIndex        */ 0,    // ItemKey::BTRepeatItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 283,    // ::BTRepeatData::mBTRepeatIconName
        /* mItemKey            */ 321
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gBTPlayInfoUpdateHierarchyNodes[BTPlayInfoUpdateDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x06A5A878, /BTPlayInfoUpdate),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 83,
        /* mParentIndex        */ 0,    // ItemKey::BTPlayInfoUpdateItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 284,    // ::BTPlayInfoUpdateData
        /* mItemKey            */ 13
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3A08B656, /BTPlayInfoUpdate/SourceName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 83,
        /* mParentIndex        */ 0,    // ItemKey::BTPlayInfoUpdateItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 285,    // ::BTPlayInfoUpdateData::mSourceName
        /* mItemKey            */ 119
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x556D8037, /BTPlayInfoUpdate/ArtistName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 83,
        /* mParentIndex        */ 0,    // ItemKey::BTPlayInfoUpdateItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 286,    // ::BTPlayInfoUpdateData::mArtistName
        /* mItemKey            */ 180
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD5FE6173, /BTPlayInfoUpdate/TitleName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 83,
        /* mParentIndex        */ 0,    // ItemKey::BTPlayInfoUpdateItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 287,    // ::BTPlayInfoUpdateData::mTitleName
        /* mItemKey            */ 430
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA42E0238, /BTPlayInfoUpdate/AlbumName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 83,
        /* mParentIndex        */ 0,    // ItemKey::BTPlayInfoUpdateItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 288,    // ::BTPlayInfoUpdateData::mAlbumName
        /* mItemKey            */ 343
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5FFA276A, /BTPlayInfoUpdate/CurrentTrackNo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 83,
        /* mParentIndex        */ 0,    // ItemKey::BTPlayInfoUpdateItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 289,    // ::BTPlayInfoUpdateData::mCurrentTrackNo
        /* mItemKey            */ 200
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xCAEC4262, /BTPlayInfoUpdate/TotalTrackNo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 83,
        /* mParentIndex        */ 0,    // ItemKey::BTPlayInfoUpdateItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 290,    // ::BTPlayInfoUpdateData::mTotalTrackNo
        /* mItemKey            */ 407
    },
    { // 7
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA8E874C0, /BTPlayInfoUpdate/TotalTime),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 83,
        /* mParentIndex        */ 0,    // ItemKey::BTPlayInfoUpdateItem
        /* mLocalIndex         */ 7,
        /* mDescriptorIndex    */ 291,    // ::BTPlayInfoUpdateData::mTotalTime
        /* mItemKey            */ 351
    },
    { // 8
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3646FE27, /BTPlayInfoUpdate/ElapsedTime),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 83,
        /* mParentIndex        */ 0,    // ItemKey::BTPlayInfoUpdateItem
        /* mLocalIndex         */ 8,
        /* mDescriptorIndex    */ 292,    // ::BTPlayInfoUpdateData::mElapsedTime
        /* mItemKey            */ 112
    },
    { // 9
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x27CC89C6, /BTPlayInfoUpdate/SliderTotalTime),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 83,
        /* mParentIndex        */ 0,    // ItemKey::BTPlayInfoUpdateItem
        /* mLocalIndex         */ 9,
        /* mDescriptorIndex    */ 293,    // ::BTPlayInfoUpdateData::mSliderTotalTime
        /* mItemKey            */ 83
    },
    { // 10
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xCC4D61E8, /BTPlayInfoUpdate/SliderElapsedTime),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 83,
        /* mParentIndex        */ 0,    // ItemKey::BTPlayInfoUpdateItem
        /* mLocalIndex         */ 10,
        /* mDescriptorIndex    */ 294,    // ::BTPlayInfoUpdateData::mSliderElapsedTime
        /* mItemKey            */ 412
    },
    { // 11
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x8609F08C, /BTPlayInfoUpdate/DragCurrentValue),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 83,
        /* mParentIndex        */ 0,    // ItemKey::BTPlayInfoUpdateItem
        /* mLocalIndex         */ 11,
        /* mDescriptorIndex    */ 295,    // ::BTPlayInfoUpdateData::mDragCurrentValue
        /* mItemKey            */ 287
    },
    { // 12
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xCEDF6742, /BTPlayInfoUpdate/PlayIconName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 83,
        /* mParentIndex        */ 0,    // ItemKey::BTPlayInfoUpdateItem
        /* mLocalIndex         */ 12,
        /* mDescriptorIndex    */ 296,    // ::BTPlayInfoUpdateData::mPlayIconName
        /* mItemKey            */ 420
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gBTSliderVisibilityHierarchyNodes[BTSliderVisibilityDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x4B7FC27F, /BTSliderVisibility),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 84,
        /* mParentIndex        */ 0,    // ItemKey::BTSliderVisibilityItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 297,    // ::BTSliderVisibilityData
        /* mItemKey            */ 160
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB2722729, /BTSliderVisibility/i8Isvisible),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 84,
        /* mParentIndex        */ 0,    // ItemKey::BTSliderVisibilityItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 298,    // ::BTSliderVisibilityData::mi8Isvisible
        /* mItemKey            */ 368
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gBTTotalTimeVisibilityHierarchyNodes[BTTotalTimeVisibilityDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD4444495, /BTTotalTimeVisibility),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 85,
        /* mParentIndex        */ 0,    // ItemKey::BTTotalTimeVisibilityItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 299,    // ::BTTotalTimeVisibilityData
        /* mItemKey            */ 426
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x41AFEBB3, /BTTotalTimeVisibility/i8Isvisible),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 85,
        /* mParentIndex        */ 0,    // ItemKey::BTTotalTimeVisibilityItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 300,    // ::BTTotalTimeVisibilityData::mi8Isvisible
        /* mItemKey            */ 140
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gBTElapsedTimeVisibilityHierarchyNodes[BTElapsedTimeVisibilityDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x292D1B97, /BTElapsedTimeVisibility),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 86,
        /* mParentIndex        */ 0,    // ItemKey::BTElapsedTimeVisibilityItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 301,    // ::BTElapsedTimeVisibilityData
        /* mItemKey            */ 89
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xFD93350B, /BTElapsedTimeVisibility/i8Isvisible),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 86,
        /* mParentIndex        */ 0,    // ItemKey::BTElapsedTimeVisibilityItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 302,    // ::BTElapsedTimeVisibilityData::mi8Isvisible
        /* mItemKey            */ 521
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gID3CoverDataHierarchyNodes[ID3CoverDataDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE1B00C18, /ID3CoverData),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 87,
        /* mParentIndex        */ 0,    // ItemKey::ID3CoverDataItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 303,    // ::ID3CoverDataData
        /* mItemKey            */ 449
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x8CB06071, /ID3CoverData/Image),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 87,
        /* mParentIndex        */ 0,    // ItemKey::ID3CoverDataItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 304,    // ::ID3CoverDataData::mImage
        /* mItemKey            */ 302
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gAudiobook_ListSizeHierarchyNodes[Audiobook_ListSizeDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3021CF16, /Audiobook_ListSize),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 88,
        /* mParentIndex        */ 0,    // ItemKey::Audiobook_ListSizeItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 305,    // ::Audiobook_ListSizeData
        /* mItemKey            */ 100
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xEBAC7C38, /Audiobook_ListSize/AudiobookWindowListSize),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 88,
        /* mParentIndex        */ 0,    // ItemKey::Audiobook_ListSizeItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 306,    // ::Audiobook_ListSizeData::mAudiobookWindowListSize
        /* mItemKey            */ 484
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gAudiobookListSelectedLineHierarchyNodes[AudiobookListSelectedLineDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD6425CFC, /AudiobookListSelectedLine),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 89,
        /* mParentIndex        */ 0,    // ItemKey::AudiobookListSelectedLineItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 307,    // ::AudiobookListSelectedLineData
        /* mItemKey            */ 431
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA7EFC52A, /AudiobookListSelectedLine/AudiobookListSelectedLine),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 89,
        /* mParentIndex        */ 0,    // ItemKey::AudiobookListSelectedLineItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 308,    // ::AudiobookListSelectedLineData::mAudiobookListSelectedLine
        /* mItemKey            */ 348
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gAudiobookChapter_ListSizeHierarchyNodes[AudiobookChapter_ListSizeDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x690F7D9D, /AudiobookChapter_ListSize),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 90,
        /* mParentIndex        */ 0,    // ItemKey::AudiobookChapter_ListSizeItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 309,    // ::AudiobookChapter_ListSizeData
        /* mItemKey            */ 219
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x469D0CAB, /AudiobookChapter_ListSize/AudiobookChapterWindowListSize),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 90,
        /* mParentIndex        */ 0,    // ItemKey::AudiobookChapter_ListSizeItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 310,    // ::AudiobookChapter_ListSizeData::mAudiobookChapterWindowListSize
        /* mItemKey            */ 151
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gAudiobookChapterListSelectedLineHierarchyNodes[AudiobookChapterListSelectedLineDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x1330AFFD, /AudiobookChapterListSelectedLine),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 91,
        /* mParentIndex        */ 0,    // ItemKey::AudiobookChapterListSelectedLineItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 311,    // ::AudiobookChapterListSelectedLineData
        /* mItemKey            */ 33
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x0A01D5EA, /AudiobookChapterListSelectedLine/AudiobookChapterListSelectedLine),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 91,
        /* mParentIndex        */ 0,    // ItemKey::AudiobookChapterListSelectedLineItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 312,    // ::AudiobookChapterListSelectedLineData::mAudiobookChapterListSelectedLine
        /* mItemKey            */ 17
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gPlaylist_ListSizeHierarchyNodes[Playlist_ListSizeDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5D4BF612, /Playlist_ListSize),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 92,
        /* mParentIndex        */ 0,    // ItemKey::Playlist_ListSizeItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 313,    // ::Playlist_ListSizeData
        /* mItemKey            */ 194
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x58C3DF1D, /Playlist_ListSize/PlaylistWindowListSize),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 92,
        /* mParentIndex        */ 0,    // ItemKey::Playlist_ListSizeItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 314,    // ::Playlist_ListSizeData::mPlaylistWindowListSize
        /* mItemKey            */ 187
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gPlaylistListSelectedLineHierarchyNodes[PlaylistListSelectedLineDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE80727B9, /PlaylistListSelectedLine),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 93,
        /* mParentIndex        */ 0,    // ItemKey::PlaylistListSelectedLineItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 315,    // ::PlaylistListSelectedLineData
        /* mItemKey            */ 469
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xFCCB9266, /PlaylistListSelectedLine/PlaylistListSelectedLine),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 93,
        /* mParentIndex        */ 0,    // ItemKey::PlaylistListSelectedLineItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 316,    // ::PlaylistListSelectedLineData::mPlaylistListSelectedLine
        /* mItemKey            */ 518
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gPlaylistTitle_ListSizeHierarchyNodes[PlaylistTitle_ListSizeDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xBDA10258, /PlaylistTitle_ListSize),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 94,
        /* mParentIndex        */ 0,    // ItemKey::PlaylistTitle_ListSizeItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 317,    // ::PlaylistTitle_ListSizeData
        /* mItemKey            */ 385
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xFE30F6FB, /PlaylistTitle_ListSize/PlaylistTitleWindowListSize),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 94,
        /* mParentIndex        */ 0,    // ItemKey::PlaylistTitle_ListSizeItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 318,    // ::PlaylistTitle_ListSizeData::mPlaylistTitleWindowListSize
        /* mItemKey            */ 524
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gPlaylistTitleListSelectedLineHierarchyNodes[PlaylistTitleListSelectedLineDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x69AA47C0, /PlaylistTitleListSelectedLine),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 95,
        /* mParentIndex        */ 0,    // ItemKey::PlaylistTitleListSelectedLineItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 319,    // ::PlaylistTitleListSelectedLineData
        /* mItemKey            */ 224
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE8CFB708, /PlaylistTitleListSelectedLine/PlaylistTitleListSelectedLine),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 95,
        /* mParentIndex        */ 0,    // ItemKey::PlaylistTitleListSelectedLineItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 320,    // ::PlaylistTitleListSelectedLineData::mPlaylistTitleListSelectedLine
        /* mItemKey            */ 475
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gPodcast_EpisodeListSizeHierarchyNodes[Podcast_EpisodeListSizeDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x770A69FE, /Podcast_EpisodeListSize),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 96,
        /* mParentIndex        */ 0,    // ItemKey::Podcast_EpisodeListSizeItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 321,    // ::Podcast_EpisodeListSizeData
        /* mItemKey            */ 259
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xAB84CFA5, /Podcast_EpisodeListSize/PodcastEpisodeWindowListSize),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 96,
        /* mParentIndex        */ 0,    // ItemKey::Podcast_EpisodeListSizeItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 322,    // ::Podcast_EpisodeListSizeData::mPodcastEpisodeWindowListSize
        /* mItemKey            */ 354
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gPodcast_EpisodeListSelectedLineHierarchyNodes[Podcast_EpisodeListSelectedLineDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x4D22C834, /Podcast_EpisodeListSelectedLine),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 97,
        /* mParentIndex        */ 0,    // ItemKey::Podcast_EpisodeListSelectedLineItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 323,    // ::Podcast_EpisodeListSelectedLineData
        /* mItemKey            */ 162
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x17A62613, /Podcast_EpisodeListSelectedLine/PodcastEpisodeSelected),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 97,
        /* mParentIndex        */ 0,    // ItemKey::Podcast_EpisodeListSelectedLineItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 324,    // ::Podcast_EpisodeListSelectedLineData::mPodcastEpisodeSelected
        /* mItemKey            */ 44
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gVideo_EpisodeListSizeHierarchyNodes[Video_EpisodeListSizeDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x53F160B9, /Video_EpisodeListSize),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 98,
        /* mParentIndex        */ 0,    // ItemKey::Video_EpisodeListSizeItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 325,    // ::Video_EpisodeListSizeData
        /* mItemKey            */ 178
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x2B264486, /Video_EpisodeListSize/VideoEpisodeWindowListSize),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 98,
        /* mParentIndex        */ 0,    // ItemKey::Video_EpisodeListSizeItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 326,    // ::Video_EpisodeListSizeData::mVideoEpisodeWindowListSize
        /* mItemKey            */ 93
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gVideo_EpisodeListSelectedLineHierarchyNodes[Video_EpisodeListSelectedLineDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5191695E, /Video_EpisodeListSelectedLine),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 99,
        /* mParentIndex        */ 0,    // ItemKey::Video_EpisodeListSelectedLineItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 327,    // ::Video_EpisodeListSelectedLineData
        /* mItemKey            */ 174
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE2469B92, /Video_EpisodeListSelectedLine/VideoEpisodeSelected),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 99,
        /* mParentIndex        */ 0,    // ItemKey::Video_EpisodeListSelectedLineItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 328,    // ::Video_EpisodeListSelectedLineData::mVideoEpisodeSelected
        /* mItemKey            */ 453
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gFolder_ListSizeHierarchyNodes[Folder_ListSizeDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x87AA907C, /Folder_ListSize),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 100,
        /* mParentIndex        */ 0,    // ItemKey::Folder_ListSizeItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 329,    // ::Folder_ListSizeData
        /* mItemKey            */ 291
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3FBE2AD8, /Folder_ListSize/FolderWindowListSize),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 100,
        /* mParentIndex        */ 0,    // ItemKey::Folder_ListSizeItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 330,    // ::Folder_ListSizeData::mFolderWindowListSize
        /* mItemKey            */ 137
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gFolder_ListSelectedLineHierarchyNodes[Folder_ListSelectedLineDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7F096618, /Folder_ListSelectedLine),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 101,
        /* mParentIndex        */ 0,    // ItemKey::Folder_ListSelectedLineItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 331,    // ::Folder_ListSelectedLineData
        /* mItemKey            */ 274
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x576AAE74, /Folder_ListSelectedLine/FolderSelected),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 101,
        /* mParentIndex        */ 0,    // ItemKey::Folder_ListSelectedLineItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 332,    // ::Folder_ListSelectedLineData::mFolderSelected
        /* mItemKey            */ 183
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gFolderFile_ListSizeHierarchyNodes[FolderFile_ListSizeDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC2A3548C, /FolderFile_ListSize),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 102,
        /* mParentIndex        */ 0,    // ItemKey::FolderFile_ListSizeItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 333,    // ::FolderFile_ListSizeData
        /* mItemKey            */ 392
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x302E79DE, /FolderFile_ListSize/FolderFile_WindowListSize),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 102,
        /* mParentIndex        */ 0,    // ItemKey::FolderFile_ListSizeItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 334,    // ::FolderFile_ListSizeData::mFolderFile_WindowListSize
        /* mItemKey            */ 101
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gFolderFile_ListSelectedLineHierarchyNodes[FolderFile_ListSelectedLineDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3C6318BB, /FolderFile_ListSelectedLine),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 103,
        /* mParentIndex        */ 0,    // ItemKey::FolderFile_ListSelectedLineItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 335,    // ::FolderFile_ListSelectedLineData
        /* mItemKey            */ 127
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x4402D0B3, /FolderFile_ListSelectedLine/FolderFileSelected),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 103,
        /* mParentIndex        */ 0,    // ItemKey::FolderFile_ListSelectedLineItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 336,    // ::FolderFile_ListSelectedLineData::mFolderFileSelected
        /* mItemKey            */ 146
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gFolder_NameHierarchyNodes[Folder_NameDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xFE7E23C7, /Folder_Name),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 104,
        /* mParentIndex        */ 0,    // ItemKey::Folder_NameItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 337,    // ::Folder_NameData
        /* mItemKey            */ 525
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5F9BF79D, /Folder_Name/FolderFileName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 104,
        /* mParentIndex        */ 0,    // ItemKey::Folder_NameItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 338,    // ::Folder_NameData::mFolderFileName
        /* mItemKey            */ 198
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gNotebookdataHierarchyNodes[NotebookdataDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE30BD5FC, /Notebookdata),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 105,
        /* mParentIndex        */ 0,    // ItemKey::NotebookdataItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 339,    // ::NotebookdataData
        /* mItemKey            */ 458
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x8FF5999E, /Notebookdata/CurrentTab),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 105,
        /* mParentIndex        */ 0,    // ItemKey::NotebookdataItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 340,    // ::NotebookdataData::mCurrentTab
        /* mItemKey            */ 306
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gTabNextPrevIndexHierarchyNodes[TabNextPrevIndexDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x82CE8CCB, /TabNextPrevIndex),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 106,
        /* mParentIndex        */ 0,    // ItemKey::TabNextPrevIndexItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 341,    // ::TabNextPrevIndexData
        /* mItemKey            */ 280
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xDFC2FD3A, /TabNextPrevIndex/NextIndex),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 106,
        /* mParentIndex        */ 0,    // ItemKey::TabNextPrevIndexItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 342,    // ::TabNextPrevIndexData::mNextIndex
        /* mItemKey            */ 444
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xEEB4F9DF, /TabNextPrevIndex/PrevIndex),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 106,
        /* mParentIndex        */ 0,    // ItemKey::TabNextPrevIndexItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 343,    // ::TabNextPrevIndexData::mPrevIndex
        /* mItemKey            */ 489
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xFDF36C55, /TabNextPrevIndex/EnableTouchNext),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 106,
        /* mParentIndex        */ 0,    // ItemKey::TabNextPrevIndexItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 344,    // ::TabNextPrevIndexData::mEnableTouchNext
        /* mItemKey            */ 523
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xFCF79B9A, /TabNextPrevIndex/EnableTouchPrev),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 106,
        /* mParentIndex        */ 0,    // ItemKey::TabNextPrevIndexItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 345,    // ::TabNextPrevIndexData::mEnableTouchPrev
        /* mItemKey            */ 519
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gListstatusHierarchyNodes[ListstatusDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xAE444902, /Liststatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 107,
        /* mParentIndex        */ 0,    // ItemKey::ListstatusItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 346,    // ::ListstatusData
        /* mItemKey            */ 361
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB034EBF4, /Liststatus/ViewportstartIndexAlbum),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 107,
        /* mParentIndex        */ 0,    // ItemKey::ListstatusItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 347,    // ::ListstatusData::mViewportstartIndexAlbum
        /* mItemKey            */ 365
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF673DC08, /Liststatus/ViewportstartIndexAlbum_song),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 107,
        /* mParentIndex        */ 0,    // ItemKey::ListstatusItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 348,    // ::ListstatusData::mViewportstartIndexAlbum_song
        /* mItemKey            */ 503
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xEA0DDBA7, /Liststatus/ViewportstartIndexArtist),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 107,
        /* mParentIndex        */ 0,    // ItemKey::ListstatusItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 349,    // ::ListstatusData::mViewportstartIndexArtist
        /* mItemKey            */ 480
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x84781184, /Liststatus/ViewportstartIndexArtist_Album),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 107,
        /* mParentIndex        */ 0,    // ItemKey::ListstatusItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 350,    // ::ListstatusData::mViewportstartIndexArtist_Album
        /* mItemKey            */ 283
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB17358FD, /Liststatus/ViewportstartIndexArtist_Album_Song),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 107,
        /* mParentIndex        */ 0,    // ItemKey::ListstatusItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 351,    // ::ListstatusData::mViewportstartIndexArtist_Album_Song
        /* mItemKey            */ 366
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x54A27D25, /Liststatus/ViewportstartIndexArtist_Song),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 107,
        /* mParentIndex        */ 0,    // ItemKey::ListstatusItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 352,    // ::ListstatusData::mViewportstartIndexArtist_Song
        /* mItemKey            */ 179
    },
    { // 7
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x97EFE60F, /Liststatus/ViewportstartIndexAudiobook),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 107,
        /* mParentIndex        */ 0,    // ItemKey::ListstatusItem
        /* mLocalIndex         */ 7,
        /* mDescriptorIndex    */ 353,    // ::ListstatusData::mViewportstartIndexAudiobook
        /* mItemKey            */ 318
    },
    { // 8
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x28196FA4, /Liststatus/ViewportstartIndexAudiobooktitle_Chapter),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 107,
        /* mParentIndex        */ 0,    // ItemKey::ListstatusItem
        /* mLocalIndex         */ 8,
        /* mDescriptorIndex    */ 354,    // ::ListstatusData::mViewportstartIndexAudiobooktitle_Chapter
        /* mItemKey            */ 86
    },
    { // 9
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xAE6A3FD3, /Liststatus/ViewportstartIndexFolder),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 107,
        /* mParentIndex        */ 0,    // ItemKey::ListstatusItem
        /* mLocalIndex         */ 9,
        /* mDescriptorIndex    */ 355,    // ::ListstatusData::mViewportstartIndexFolder
        /* mItemKey            */ 362
    },
    { // 10
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x970632D5, /Liststatus/ViewportstartIndexFolder_File),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 107,
        /* mParentIndex        */ 0,    // ItemKey::ListstatusItem
        /* mLocalIndex         */ 10,
        /* mDescriptorIndex    */ 356,    // ::ListstatusData::mViewportstartIndexFolder_File
        /* mItemKey            */ 316
    },
    { // 11
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x787B9EFA, /Liststatus/ViewportstartIndexGenre),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 107,
        /* mParentIndex        */ 0,    // ItemKey::ListstatusItem
        /* mLocalIndex         */ 11,
        /* mDescriptorIndex    */ 357,    // ::ListstatusData::mViewportstartIndexGenre
        /* mItemKey            */ 261
    },
    { // 12
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x70CB6682, /Liststatus/ViewportstartIndexGenre_Album),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 107,
        /* mParentIndex        */ 0,    // ItemKey::ListstatusItem
        /* mLocalIndex         */ 12,
        /* mDescriptorIndex    */ 358,    // ::ListstatusData::mViewportstartIndexGenre_Album
        /* mItemKey            */ 242
    },
    { // 13
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x4991D942, /Liststatus/ViewportstartIndexGenre_Album_Song),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 107,
        /* mParentIndex        */ 0,    // ItemKey::ListstatusItem
        /* mLocalIndex         */ 13,
        /* mDescriptorIndex    */ 359,    // ::ListstatusData::mViewportstartIndexGenre_Album_Song
        /* mItemKey            */ 156
    },
    { // 14
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA2C2EAD5, /Liststatus/ViewportstartIndexGenre_Artist),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 107,
        /* mParentIndex        */ 0,    // ItemKey::ListstatusItem
        /* mLocalIndex         */ 14,
        /* mDescriptorIndex    */ 360,    // ::ListstatusData::mViewportstartIndexGenre_Artist
        /* mItemKey            */ 338
    },
    { // 15
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x50A4DB1F, /Liststatus/ViewportstartIndexGenre_Artist_Album),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 107,
        /* mParentIndex        */ 0,    // ItemKey::ListstatusItem
        /* mLocalIndex         */ 15,
        /* mDescriptorIndex    */ 361,    // ::ListstatusData::mViewportstartIndexGenre_Artist_Album
        /* mItemKey            */ 171
    },
    { // 16
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7351076E, /Liststatus/ViewportstartIndexGenre_Artist_Album_Song),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 107,
        /* mParentIndex        */ 0,    // ItemKey::ListstatusItem
        /* mLocalIndex         */ 16,
        /* mDescriptorIndex    */ 362,    // ::ListstatusData::mViewportstartIndexGenre_Artist_Album_Song
        /* mItemKey            */ 250
    },
    { // 17
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x44FC9308, /Liststatus/ViewportstartIndexGenre_Artist_Song),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 107,
        /* mParentIndex        */ 0,    // ItemKey::ListstatusItem
        /* mLocalIndex         */ 17,
        /* mDescriptorIndex    */ 363,    // ::ListstatusData::mViewportstartIndexGenre_Artist_Song
        /* mItemKey            */ 149
    },
    { // 18
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD4CA471E, /Liststatus/ViewportstartIndexPlaylist),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 107,
        /* mParentIndex        */ 0,    // ItemKey::ListstatusItem
        /* mLocalIndex         */ 18,
        /* mDescriptorIndex    */ 364,    // ::ListstatusData::mViewportstartIndexPlaylist
        /* mItemKey            */ 427
    },
    { // 19
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x94E8D5F6, /Liststatus/ViewportstartIndexPlaylist_Song),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 107,
        /* mParentIndex        */ 0,    // ItemKey::ListstatusItem
        /* mLocalIndex         */ 19,
        /* mDescriptorIndex    */ 365,    // ::ListstatusData::mViewportstartIndexPlaylist_Song
        /* mItemKey            */ 314
    },
    { // 20
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3A6DD80A, /Liststatus/ViewportstartIndexPodcast),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 107,
        /* mParentIndex        */ 0,    // ItemKey::ListstatusItem
        /* mLocalIndex         */ 20,
        /* mDescriptorIndex    */ 366,    // ::ListstatusData::mViewportstartIndexPodcast
        /* mItemKey            */ 120
    },
    { // 21
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xECA20A5D, /Liststatus/ViewportstartIndexPodcast_Episode),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 107,
        /* mParentIndex        */ 0,    // ItemKey::ListstatusItem
        /* mLocalIndex         */ 21,
        /* mDescriptorIndex    */ 367,    // ::ListstatusData::mViewportstartIndexPodcast_Episode
        /* mItemKey            */ 488
    },
    { // 22
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x2592205B, /Liststatus/ViewportstartIndexSong),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 107,
        /* mParentIndex        */ 0,    // ItemKey::ListstatusItem
        /* mLocalIndex         */ 22,
        /* mDescriptorIndex    */ 368,    // ::ListstatusData::mViewportstartIndexSong
        /* mItemKey            */ 74
    },
    { // 23
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF0820D2C, /Liststatus/ViewportstartIndexVideo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 107,
        /* mParentIndex        */ 0,    // ItemKey::ListstatusItem
        /* mLocalIndex         */ 23,
        /* mDescriptorIndex    */ 369,    // ::ListstatusData::mViewportstartIndexVideo
        /* mItemKey            */ 494
    },
    { // 24
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x2F82C479, /Liststatus/ViewportstartIndexVideo_Episode),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 107,
        /* mParentIndex        */ 0,    // ItemKey::ListstatusItem
        /* mLocalIndex         */ 24,
        /* mDescriptorIndex    */ 370,    // ::ListstatusData::mViewportstartIndexVideo_Episode
        /* mItemKey            */ 99
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSDRepeatOptionHierarchyNodes[SDRepeatOptionDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3CA3C17F, /SDRepeatOption),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 108,
        /* mParentIndex        */ 0,    // ItemKey::SDRepeatOptionItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 371,    // ::SDRepeatOptionData
        /* mItemKey            */ 129
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x927943B8, /SDRepeatOption/RepeatTrack),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 108,
        /* mParentIndex        */ 0,    // ItemKey::SDRepeatOptionItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 372,    // ::SDRepeatOptionData::mRepeatTrack
        /* mItemKey            */ 310
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x56629030, /SDRepeatOption/RepeatList),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 108,
        /* mParentIndex        */ 0,    // ItemKey::SDRepeatOptionItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 373,    // ::SDRepeatOptionData::mRepeatList
        /* mItemKey            */ 181
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gUSBRepeatOptionHierarchyNodes[USBRepeatOptionDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x2D3F8019, /USBRepeatOption),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 109,
        /* mParentIndex        */ 0,    // ItemKey::USBRepeatOptionItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 374,    // ::USBRepeatOptionData
        /* mItemKey            */ 97
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xCA72B4D6, /USBRepeatOption/RepeatTrack),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 109,
        /* mParentIndex        */ 0,    // ItemKey::USBRepeatOptionItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 375,    // ::USBRepeatOptionData::mRepeatTrack
        /* mItemKey            */ 405
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD23DEFB3, /USBRepeatOption/RepeatList),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 109,
        /* mParentIndex        */ 0,    // ItemKey::USBRepeatOptionItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 376,    // ::USBRepeatOptionData::mRepeatList
        /* mItemKey            */ 424
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB92E95C5, /USBRepeatOption/RepeatIndex),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 109,
        /* mParentIndex        */ 0,    // ItemKey::USBRepeatOptionItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 377,    // ::USBRepeatOptionData::mRepeatIndex
        /* mItemKey            */ 379
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gUSBCameraPortRepeatOptionHierarchyNodes[USBCameraPortRepeatOptionDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x35C6A225, /USBCameraPortRepeatOption),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 110,
        /* mParentIndex        */ 0,    // ItemKey::USBCameraPortRepeatOptionItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 378,    // ::USBCameraPortRepeatOptionData
        /* mItemKey            */ 111
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7C2585C2, /USBCameraPortRepeatOption/RepeatTrack),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 110,
        /* mParentIndex        */ 0,    // ItemKey::USBCameraPortRepeatOptionItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 379,    // ::USBCameraPortRepeatOptionData::mRepeatTrack
        /* mItemKey            */ 268
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x977293A5, /USBCameraPortRepeatOption/RepeatList),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 110,
        /* mParentIndex        */ 0,    // ItemKey::USBCameraPortRepeatOptionItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 380,    // ::USBCameraPortRepeatOptionData::mRepeatList
        /* mItemKey            */ 317
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x42F1691F, /USBCameraPortRepeatOption/RepeatIndex),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 110,
        /* mParentIndex        */ 0,    // ItemKey::USBCameraPortRepeatOptionItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 381,    // ::USBCameraPortRepeatOptionData::mRepeatIndex
        /* mItemKey            */ 143
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gUSBRouterRepeatOptionHierarchyNodes[USBRouterRepeatOptionDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x9652CA77, /USBRouterRepeatOption),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 111,
        /* mParentIndex        */ 0,    // ItemKey::USBRouterRepeatOptionItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 382,    // ::USBRouterRepeatOptionData
        /* mItemKey            */ 315
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xBC25A592, /USBRouterRepeatOption/RepeatTrack),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 111,
        /* mParentIndex        */ 0,    // ItemKey::USBRouterRepeatOptionItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 383,    // ::USBRouterRepeatOptionData::mRepeatTrack
        /* mItemKey            */ 383
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x49D3D9CD, /USBRouterRepeatOption/RepeatIndex),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 111,
        /* mParentIndex        */ 0,    // ItemKey::USBRouterRepeatOptionItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 384,    // ::USBRouterRepeatOptionData::mRepeatIndex
        /* mItemKey            */ 158
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gBTRepeatOptionHierarchyNodes[BTRepeatOptionDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA39CE1AD, /BTRepeatOption),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 112,
        /* mParentIndex        */ 0,    // ItemKey::BTRepeatOptionItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 385,    // ::BTRepeatOptionData
        /* mItemKey            */ 340
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x6CDB4004, /BTRepeatOption/RepeatTrack),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 112,
        /* mParentIndex        */ 0,    // ItemKey::BTRepeatOptionItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 386,    // ::BTRepeatOptionData::mRepeatTrack
        /* mItemKey            */ 230
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x9A204420, /BTRepeatOption/RepeatList),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 112,
        /* mParentIndex        */ 0,    // ItemKey::BTRepeatOptionItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 387,    // ::BTRepeatOptionData::mRepeatList
        /* mItemKey            */ 328
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB73C68B4, /BTRepeatOption/RepeatIndex),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 112,
        /* mParentIndex        */ 0,    // ItemKey::BTRepeatOptionItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 388,    // ::BTRepeatOptionData::mRepeatIndex
        /* mItemKey            */ 375
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gAppleRepeatOptionHierarchyNodes[AppleRepeatOptionDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x61405F1A, /AppleRepeatOption),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 113,
        /* mParentIndex        */ 0,    // ItemKey::AppleRepeatOptionItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 389,    // ::AppleRepeatOptionData
        /* mItemKey            */ 202
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3EE0D43F, /AppleRepeatOption/RepeatTrack),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 113,
        /* mParentIndex        */ 0,    // ItemKey::AppleRepeatOptionItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 390,    // ::AppleRepeatOptionData::mRepeatTrack
        /* mItemKey            */ 135
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA4269B71, /AppleRepeatOption/RepeatList),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 113,
        /* mParentIndex        */ 0,    // ItemKey::AppleRepeatOptionItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 391,    // ::AppleRepeatOptionData::mRepeatList
        /* mItemKey            */ 341
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xAD3E4D38, /AppleRepeatOption/RepeatIndex),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 113,
        /* mParentIndex        */ 0,    // ItemKey::AppleRepeatOptionItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 392,    // ::AppleRepeatOptionData::mRepeatIndex
        /* mItemKey            */ 358
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSDShuffleOptionHierarchyNodes[SDShuffleOptionDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x2CF0BDF8, /SDShuffleOption),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 114,
        /* mParentIndex        */ 0,    // ItemKey::SDShuffleOptionItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 393,    // ::SDShuffleOptionData
        /* mItemKey            */ 95
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x61CF4C8F, /SDShuffleOption/ShuffleOff),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 114,
        /* mParentIndex        */ 0,    // ItemKey::SDShuffleOptionItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 394,    // ::SDShuffleOptionData::mShuffleOff
        /* mItemKey            */ 204
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x8D2E7428, /SDShuffleOption/ShuffleOn),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 114,
        /* mParentIndex        */ 0,    // ItemKey::SDShuffleOptionItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 395,    // ::SDShuffleOptionData::mShuffleOn
        /* mItemKey            */ 303
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gUSBShuffleOptionHierarchyNodes[USBShuffleOptionDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x19484866, /USBShuffleOption),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 115,
        /* mParentIndex        */ 0,    // ItemKey::USBShuffleOptionItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 396,    // ::USBShuffleOptionData
        /* mItemKey            */ 49
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7D8278FC, /USBShuffleOption/ShuffleOff),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 115,
        /* mParentIndex        */ 0,    // ItemKey::USBShuffleOptionItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 397,    // ::USBShuffleOptionData::mShuffleOff
        /* mItemKey            */ 270
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x6912B700, /USBShuffleOption/ShuffleOn),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 115,
        /* mParentIndex        */ 0,    // ItemKey::USBShuffleOptionItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 398,    // ::USBShuffleOptionData::mShuffleOn
        /* mItemKey            */ 220
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE4B33B20, /USBShuffleOption/ShuffleIndex),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 115,
        /* mParentIndex        */ 0,    // ItemKey::USBShuffleOptionItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 399,    // ::USBShuffleOptionData::mShuffleIndex
        /* mItemKey            */ 462
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gUSBCameraPortShuffleOptionHierarchyNodes[USBCameraPortShuffleOptionDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA58600AD, /USBCameraPortShuffleOption),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 116,
        /* mParentIndex        */ 0,    // ItemKey::USBCameraPortShuffleOptionItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 400,    // ::USBCameraPortShuffleOptionData
        /* mItemKey            */ 344
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x6318F8C5, /USBCameraPortShuffleOption/ShuffleOff),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 116,
        /* mParentIndex        */ 0,    // ItemKey::USBCameraPortShuffleOptionItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 401,    // ::USBCameraPortShuffleOptionData::mShuffleOff
        /* mItemKey            */ 206
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB2259BD5, /USBCameraPortShuffleOption/ShuffleOn),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 116,
        /* mParentIndex        */ 0,    // ItemKey::USBCameraPortShuffleOptionItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 402,    // ::USBCameraPortShuffleOptionData::mShuffleOn
        /* mItemKey            */ 367
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x691A6D53, /USBCameraPortShuffleOption/ShuffleIndex),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 116,
        /* mParentIndex        */ 0,    // ItemKey::USBCameraPortShuffleOptionItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 403,    // ::USBCameraPortShuffleOptionData::mShuffleIndex
        /* mItemKey            */ 221
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gUSBRouterShuffleOptionHierarchyNodes[USBRouterShuffleOptionDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x1DBC2A9B, /USBRouterShuffleOption),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 117,
        /* mParentIndex        */ 0,    // ItemKey::USBRouterShuffleOptionItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 404,    // ::USBRouterShuffleOptionData
        /* mItemKey            */ 57
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x2652C63C, /USBRouterShuffleOption/ShuffleOff),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 117,
        /* mParentIndex        */ 0,    // ItemKey::USBRouterShuffleOptionItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 405,    // ::USBRouterShuffleOptionData::mShuffleOff
        /* mItemKey            */ 80
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x1EFDEA4D, /USBRouterShuffleOption/ShuffleOn),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 117,
        /* mParentIndex        */ 0,    // ItemKey::USBRouterShuffleOptionItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 406,    // ::USBRouterShuffleOptionData::mShuffleOn
        /* mItemKey            */ 61
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7F232C1B, /USBRouterShuffleOption/ShuffleIndex),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 117,
        /* mParentIndex        */ 0,    // ItemKey::USBRouterShuffleOptionItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 407,    // ::USBRouterShuffleOptionData::mShuffleIndex
        /* mItemKey            */ 276
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gUSBPlayPauseOptionHierarchyNodes[USBPlayPauseOptionDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x2867B031, /USBPlayPauseOption),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 118,
        /* mParentIndex        */ 0,    // ItemKey::USBPlayPauseOptionItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 408,    // ::USBPlayPauseOptionData
        /* mItemKey            */ 87
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5849B29D, /USBPlayPauseOption/PlayPauseIndex),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 118,
        /* mParentIndex        */ 0,    // ItemKey::USBPlayPauseOptionItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 409,    // ::USBPlayPauseOptionData::mPlayPauseIndex
        /* mItemKey            */ 185
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gUSBCameraPortPlayPauseOptionHierarchyNodes[USBCameraPortPlayPauseOptionDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE9B8B4D3, /USBCameraPortPlayPauseOption),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 119,
        /* mParentIndex        */ 0,    // ItemKey::USBCameraPortPlayPauseOptionItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 410,    // ::USBCameraPortPlayPauseOptionData
        /* mItemKey            */ 479
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD4CF6759, /USBCameraPortPlayPauseOption/PlayPauseIndex),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 119,
        /* mParentIndex        */ 0,    // ItemKey::USBCameraPortPlayPauseOptionItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 411,    // ::USBCameraPortPlayPauseOptionData::mPlayPauseIndex
        /* mItemKey            */ 428
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gUSBRouterPlayPauseOptionHierarchyNodes[USBRouterPlayPauseOptionDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7E479D0C, /USBRouterPlayPauseOption),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 120,
        /* mParentIndex        */ 0,    // ItemKey::USBRouterPlayPauseOptionItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 412,    // ::USBRouterPlayPauseOptionData
        /* mItemKey            */ 273
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3E3EE08E, /USBRouterPlayPauseOption/PlayPauseIndex),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 120,
        /* mParentIndex        */ 0,    // ItemKey::USBRouterPlayPauseOptionItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 413,    // ::USBRouterPlayPauseOptionData::mPlayPauseIndex
        /* mItemKey            */ 132
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gApplePlayPauseOptionHierarchyNodes[ApplePlayPauseOptionDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE8AB37BF, /ApplePlayPauseOption),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 121,
        /* mParentIndex        */ 0,    // ItemKey::ApplePlayPauseOptionItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 414,    // ::ApplePlayPauseOptionData
        /* mItemKey            */ 474
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3E4B2168, /ApplePlayPauseOption/PlayPauseIndex),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 121,
        /* mParentIndex        */ 0,    // ItemKey::ApplePlayPauseOptionItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 415,    // ::ApplePlayPauseOptionData::mPlayPauseIndex
        /* mItemKey            */ 133
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gBTPlayPauseOptionHierarchyNodes[BTPlayPauseOptionDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x68B15F1A, /BTPlayPauseOption),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 122,
        /* mParentIndex        */ 0,    // ItemKey::BTPlayPauseOptionItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 416,    // ::BTPlayPauseOptionData
        /* mItemKey            */ 216
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA1ADB4B4, /BTPlayPauseOption/PlayPauseIndex),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 122,
        /* mParentIndex        */ 0,    // ItemKey::BTPlayPauseOptionItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 417,    // ::BTPlayPauseOptionData::mPlayPauseIndex
        /* mItemKey            */ 337
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gBTShuffleOptionHierarchyNodes[BTShuffleOptionDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7CC14FE4, /BTShuffleOption),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 123,
        /* mParentIndex        */ 0,    // ItemKey::BTShuffleOptionItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 418,    // ::BTShuffleOptionData
        /* mItemKey            */ 269
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3EA05213, /BTShuffleOption/ShuffleOff),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 123,
        /* mParentIndex        */ 0,    // ItemKey::BTShuffleOptionItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 419,    // ::BTShuffleOptionData::mShuffleOff
        /* mItemKey            */ 134
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x2AF4FC29, /BTShuffleOption/ShuffleOn),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 123,
        /* mParentIndex        */ 0,    // ItemKey::BTShuffleOptionItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 420,    // ::BTShuffleOptionData::mShuffleOn
        /* mItemKey            */ 92
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x6B0B176F, /BTShuffleOption/ShuffleIndex),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 123,
        /* mParentIndex        */ 0,    // ItemKey::BTShuffleOptionItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 421,    // ::BTShuffleOptionData::mShuffleIndex
        /* mItemKey            */ 226
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gAppleShuffleOptionHierarchyNodes[AppleShuffleOptionDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x0E7D03F4, /AppleShuffleOption),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 124,
        /* mParentIndex        */ 0,    // ItemKey::AppleShuffleOptionItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 422,    // ::AppleShuffleOptionData
        /* mItemKey            */ 24
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xAEE081B3, /AppleShuffleOption/ShuffleOff),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 124,
        /* mParentIndex        */ 0,    // ItemKey::AppleShuffleOptionItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 423,    // ::AppleShuffleOptionData::mShuffleOff
        /* mItemKey            */ 363
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x9A1D41FA, /AppleShuffleOption/ShuffleOn),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 124,
        /* mParentIndex        */ 0,    // ItemKey::AppleShuffleOptionItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 424,    // ::AppleShuffleOptionData::mShuffleOn
        /* mItemKey            */ 327
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xEEC51AE8, /AppleShuffleOption/ShuffleIndex),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 124,
        /* mParentIndex        */ 0,    // ItemKey::AppleShuffleOptionItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 425,    // ::AppleShuffleOptionData::mShuffleIndex
        /* mItemKey            */ 490
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSPIConnectionTypeHierarchyNodes[SPIConnectionTypeDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x11C7DE6B, /SPIConnectionType),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 125,
        /* mParentIndex        */ 0,    // ItemKey::SPIConnectionTypeItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 426,    // ::SPIConnectionTypeData
        /* mItemKey            */ 31
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF00F2EDB, /SPIConnectionType/SPIConnectionIndex),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 125,
        /* mParentIndex        */ 0,    // ItemKey::SPIConnectionTypeItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 427,    // ::SPIConnectionTypeData::mSPIConnectionIndex
        /* mItemKey            */ 492
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gAuxFeatureControllerHierarchyNodes[AuxFeatureControllerDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x274E40BA, /AuxFeatureController),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 126,
        /* mParentIndex        */ 0,    // ItemKey::AuxFeatureControllerItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 428,    // ::AuxFeatureControllerData
        /* mItemKey            */ 82
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xDEA793F2, /AuxFeatureController/EnableStatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 126,
        /* mParentIndex        */ 0,    // ItemKey::AuxFeatureControllerItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 429,    // ::AuxFeatureControllerData::mEnableStatus
        /* mItemKey            */ 439
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gMediaListIDHierarchyNodes[MediaListIDDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xFF5C674D, /MediaListID),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 127,
        /* mParentIndex        */ 0,    // ItemKey::MediaListIDItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 430,    // ::MediaListIDData
        /* mItemKey            */ 528
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x6E519A4B, /MediaListID/AlbumListID),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 127,
        /* mParentIndex        */ 0,    // ItemKey::MediaListIDItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 431,    // ::MediaListIDData::mAlbumListID
        /* mItemKey            */ 234
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x056436E3, /MediaListID/TitleListID),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 127,
        /* mParentIndex        */ 0,    // ItemKey::MediaListIDItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 432,    // ::MediaListIDData::mTitleListID
        /* mItemKey            */ 9
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gMediaTabActiveStateHierarchyNodes[MediaTabActiveStateDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x26EDB7FB, /MediaTabActiveState),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 128,
        /* mParentIndex        */ 0,    // ItemKey::MediaTabActiveStateItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 433,    // ::MediaTabActiveStateData
        /* mItemKey            */ 81
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x6C29FAC5, /MediaTabActiveState/TitleTabActiveStateChange),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 128,
        /* mParentIndex        */ 0,    // ItemKey::MediaTabActiveStateItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 434,    // ::MediaTabActiveStateData::mTitleTabActiveStateChange
        /* mItemKey            */ 228
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x75C1897A, /MediaTabActiveState/ArtistTabActiveStateChange),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 128,
        /* mParentIndex        */ 0,    // ItemKey::MediaTabActiveStateItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 435,    // ::MediaTabActiveStateData::mArtistTabActiveStateChange
        /* mItemKey            */ 255
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x4F80A22F, /MediaTabActiveState/AlbumTabActiveStateChange),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 128,
        /* mParentIndex        */ 0,    // ItemKey::MediaTabActiveStateItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 436,    // ::MediaTabActiveStateData::mAlbumTabActiveStateChange
        /* mItemKey            */ 167
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x6035B158, /MediaTabActiveState/GenreTabActiveStateChange),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 128,
        /* mParentIndex        */ 0,    // ItemKey::MediaTabActiveStateItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 437,    // ::MediaTabActiveStateData::mGenreTabActiveStateChange
        /* mItemKey            */ 201
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF3DE3B5F, /MediaTabActiveState/FolderTabActiveStateChange),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 128,
        /* mParentIndex        */ 0,    // ItemKey::MediaTabActiveStateItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 438,    // ::MediaTabActiveStateData::mFolderTabActiveStateChange
        /* mItemKey            */ 499
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5F9E8F83, /MediaTabActiveState/PlaylistTabActiveStateChange),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 128,
        /* mParentIndex        */ 0,    // ItemKey::MediaTabActiveStateItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 439,    // ::MediaTabActiveStateData::mPlaylistTabActiveStateChange
        /* mItemKey            */ 199
    },
    { // 7
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x30BFBC70, /MediaTabActiveState/AudioBkTabActiveStateChange),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 128,
        /* mParentIndex        */ 0,    // ItemKey::MediaTabActiveStateItem
        /* mLocalIndex         */ 7,
        /* mDescriptorIndex    */ 440,    // ::MediaTabActiveStateData::mAudioBkTabActiveStateChange
        /* mItemKey            */ 102
    },
    { // 8
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3B72AEA7, /MediaTabActiveState/PodcastTabActiveStateChange),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 128,
        /* mParentIndex        */ 0,    // ItemKey::MediaTabActiveStateItem
        /* mLocalIndex         */ 8,
        /* mDescriptorIndex    */ 441,    // ::MediaTabActiveStateData::mPodcastTabActiveStateChange
        /* mItemKey            */ 122
    },
    { // 9
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x985B28AE, /MediaTabActiveState/VideoTabActiveStateChange),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 128,
        /* mParentIndex        */ 0,    // ItemKey::MediaTabActiveStateItem
        /* mLocalIndex         */ 9,
        /* mDescriptorIndex    */ 442,    // ::MediaTabActiveStateData::mVideoTabActiveStateChange
        /* mItemKey            */ 323
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gVideoTabActivationHierarchyNodes[VideoTabActivationDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x6327D95E, /VideoTabActivation),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 129,
        /* mParentIndex        */ 0,    // ItemKey::VideoTabActivationItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 443,    // ::VideoTabActivationData
        /* mItemKey            */ 207
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x0B2124D9, /VideoTabActivation/IsVideoTabActiveVariant),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 129,
        /* mParentIndex        */ 0,    // ItemKey::VideoTabActivationItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 444,    // ::VideoTabActivationData::mIsVideoTabActiveVariant
        /* mItemKey            */ 18
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gUSBCameraPortAlbumVisibilityHierarchyNodes[USBCameraPortAlbumVisibilityDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x264058F5, /USBCameraPortAlbumVisibility),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 130,
        /* mParentIndex        */ 0,    // ItemKey::USBCameraPortAlbumVisibilityItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 445,    // ::USBCameraPortAlbumVisibilityData
        /* mItemKey            */ 79
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x055F94B0, /USBCameraPortAlbumVisibility/IconAndTextVisiblity),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 130,
        /* mParentIndex        */ 0,    // ItemKey::USBCameraPortAlbumVisibilityItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 446,    // ::USBCameraPortAlbumVisibilityData::mIconAndTextVisiblity
        /* mItemKey            */ 8
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gUSBRouterAlbumVisibilityHierarchyNodes[USBRouterAlbumVisibilityDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x6CA3C0A2, /USBRouterAlbumVisibility),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 131,
        /* mParentIndex        */ 0,    // ItemKey::USBRouterAlbumVisibilityItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 447,    // ::USBRouterAlbumVisibilityData
        /* mItemKey            */ 229
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xCB190268, /USBRouterAlbumVisibility/IconAndTextVisiblity),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 131,
        /* mParentIndex        */ 0,    // ItemKey::USBRouterAlbumVisibilityItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 448,    // ::USBRouterAlbumVisibilityData::mIconAndTextVisiblity
        /* mItemKey            */ 409
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gAuxActivationHierarchyNodes[AuxActivationDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x8E742C10, /AuxActivation),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 132,
        /* mParentIndex        */ 0,    // ItemKey::AuxActivationItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 449,    // ::AuxActivationData
        /* mItemKey            */ 305
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x566D9933, /AuxActivation/IsAuxActiveVariant),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 132,
        /* mParentIndex        */ 0,    // ItemKey::AuxActivationItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 450,    // ::AuxActivationData::mIsAuxActiveVariant
        /* mItemKey            */ 182
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gFolderListDataItemHierarchyNodes[FolderListDataItemDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA5BE478A, /FolderListDataItem),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 133,
        /* mParentIndex        */ 0,    // ItemKey::FolderListDataItemItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 451,    // ::FolderListDataItemData
        /* mItemKey            */ 345
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB91E1B60, /FolderListDataItem/IconImageIndexVal),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 133,
        /* mParentIndex        */ 0,    // ItemKey::FolderListDataItemItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 452,    // ::FolderListDataItemData::mIconImageIndexVal
        /* mItemKey            */ 378
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gDownloadVisibilityDataItemHierarchyNodes[DownloadVisibilityDataItemDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE79C6A43, /DownloadVisibilityDataItem),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 134,
        /* mParentIndex        */ 0,    // ItemKey::DownloadVisibilityDataItemItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 453,    // ::DownloadVisibilityDataItemData
        /* mItemKey            */ 467
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xDC8F7CE7, /DownloadVisibilityDataItem/DownloadIconVisibilityVal),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 134,
        /* mParentIndex        */ 0,    // ItemKey::DownloadVisibilityDataItemItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 454,    // ::DownloadVisibilityDataItemData::mDownloadIconVisibilityVal
        /* mItemKey            */ 437
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB9E3C576, /DownloadVisibilityDataItem/DownloadIconSwitchVal),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 134,
        /* mParentIndex        */ 0,    // ItemKey::DownloadVisibilityDataItemItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 455,    // ::DownloadVisibilityDataItemData::mDownloadIconSwitchVal
        /* mItemKey            */ 380
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3372849D, /DownloadVisibilityDataItem/DownloadAnimationStatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 134,
        /* mParentIndex        */ 0,    // ItemKey::DownloadVisibilityDataItemItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 456,    // ::DownloadVisibilityDataItemData::mDownloadAnimationStatus
        /* mItemKey            */ 107
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gFolderFileListDataItemHierarchyNodes[FolderFileListDataItemDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x0F1FF33E, /FolderFileListDataItem),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 135,
        /* mParentIndex        */ 0,    // ItemKey::FolderFileListDataItemItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 457,    // ::FolderFileListDataItemData
        /* mItemKey            */ 26
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x718DD610, /FolderFileListDataItem/FolderFileIconImageIndex),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 135,
        /* mParentIndex        */ 0,    // ItemKey::FolderFileListDataItemItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 458,    // ::FolderFileListDataItemData::mFolderFileIconImageIndex
        /* mItemKey            */ 243
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gBrowseTextChangeHierarchyNodes[BrowseTextChangeDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x8A019924, /BrowseTextChange),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 136,
        /* mParentIndex        */ 0,    // ItemKey::BrowseTextChangeItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 459,    // ::BrowseTextChangeData
        /* mItemKey            */ 296
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x353866A5, /BrowseTextChange/BrowseText),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 136,
        /* mParentIndex        */ 0,    // ItemKey::BrowseTextChangeItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 460,    // ::BrowseTextChangeData::mBrowseText
        /* mItemKey            */ 109
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gExternalBrowseTextInfoHierarchyNodes[ExternalBrowseTextInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x2F3C170D, /ExternalBrowseTextInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 137,
        /* mParentIndex        */ 0,    // ItemKey::ExternalBrowseTextInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 461,    // ::ExternalBrowseTextInfoData
        /* mItemKey            */ 98
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x6D151CA0, /ExternalBrowseTextInfo/BrowseText),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 137,
        /* mParentIndex        */ 0,    // ItemKey::ExternalBrowseTextInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 462,    // ::ExternalBr