/************************************************************************
*FILE: AppHmi_MediaDatabinding.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(AppHmi_MediaDatabinding_h)
#define AppHmi_MediaDatabinding_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <CanderaWidget/String/String.h>
#include <Candera/Engine2D/Core/Image2D.h>

// =========================================================================
struct DeviceConnectionData {
    Candera::String mUSBDeviceName;
    Candera::String mAppleDeviceName;
    Candera::String mBTDeviceName;
    Candera::String mSDCardDeviceName;

    DeviceConnectionData();
};

// =========================================================================
struct BTVisibilityData {
    bool mBTIsvisible;

    BTVisibilityData();
};

// =========================================================================
struct SPIVisibilityData {
    bool mSPIIsvisible;

    SPIVisibilityData();
};

// =========================================================================
struct PlaybackActionData {
    Candera::String mSourceName;
    Candera::String mArtistName;
    Candera::String mTitleName;
    Candera::String mAlbumName;
    Candera::String mVideoName;
    Candera::String mCurrentTrackNo;
    Candera::String mTotalTrackNo;
    Candera::String mTotalTime;
    Candera::String mElapsedTime;
    Candera::Float mSliderTotalTime;
    Candera::Float mSliderElapsedTime;
     Candera::Float mDragCurrentValue;
    Courier::Int32 mRepeatOption;
    Courier::Int32 mShuffleOption;
    Courier::Int32 mSeekCurrentPosition;
    Candera::String mPlayIconName;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mRepeatIconName;
    Candera::String mShuffleIconName;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mDummyImage;

    PlaybackActionData();
};

// =========================================================================
struct USBCameraPortPlaybackActionData {
    Candera::String mSourceName;
    Candera::String mArtistName;
    Candera::String mTitleName;
    Candera::String mAlbumName;
    Candera::String mCurrentTrackNo;
    Candera::String mTotalTime;
    Candera::String mElapsedTime;
    Candera::Float mSliderTotalTime;
    Candera::Float mSliderElapsedTime;
     Candera::Float mDragCurrentValue;
    Courier::Int32 mRepeatOption;
    Courier::Int32 mShuffleOption;
    Candera::String mPlayIconName;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mRepeatIconName;
    Candera::String mShuffleIconName;

    USBCameraPortPlaybackActionData();
};

// =========================================================================
struct USBRouterPlaybackActionData {
    Candera::String mSourceName;
    Candera::String mArtistName;
    Candera::String mTitleName;
    Candera::String mAlbumName;
    Candera::String mCurrentTrackNo;
    Candera::String mTotalTime;
    Candera::String mElapsedTime;
    Candera::Float mSliderTotalTime;
    Candera::Float mSliderElapsedTime;

    USBRouterPlaybackActionData();
};

// =========================================================================
struct MuteInfoData {
    Candera::String mMuteStatus;

    MuteInfoData();
};

// =========================================================================
struct MuteInfoforAuxData {
    Candera::String mMuteStatusforAux;

    MuteInfoforAuxData();
};

// =========================================================================
struct USB2VisibilityData {
    bool mUSB2Isvisible;

    USB2VisibilityData();
};

// =========================================================================
struct VariantInfoData {
    bool mTA_Settings;

    VariantInfoData();
};

// =========================================================================
struct ExternalMediaSourceData {
    Candera::UInt8 mEMPMediaSourceVisibility;
    Candera::UInt8 mEMPHMIMediaSourceVisibility;

    ExternalMediaSourceData();
};

// =========================================================================
struct TabVideoSourceData {
    bool mTabVideoSourceVisibility;
    bool mTabVideoSourceEnable;

    TabVideoSourceData();
};

// =========================================================================
struct BTNowplayIconsData {
    bool mShuffleIconStatus;
    bool mRepeatIconStatus;
    bool mBrowseIconStatus;

    BTNowplayIconsData();
};

// =========================================================================
struct ID3CoverDataForGadgetData {
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mGadgetImage;
};

// =========================================================================
struct ID3CoverDataForCamportUSBGadgetData {
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mGadgetImage;
};

// =========================================================================
struct ID3CoverDataForRouterUSBGadgetData {
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mGadgetImage;
};

// =========================================================================
struct ID3CoverDataForCamportUSBData {
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mCamportAlbumImage;
};

// =========================================================================
struct ID3CoverDataForRouterUSBData {
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mRouterAlbumImage;
};

// =========================================================================
struct AlbumListItemData {
    Candera::String mAlbumName;

    AlbumListItemData();
};

// =========================================================================
struct VideoPlaybackActionData {
    Candera::String mVideoTitle;
    Candera::String mVideoEpisode;

    VideoPlaybackActionData();
};

// =========================================================================
struct AppleDeviceData {
    Candera::String mSourceName;
    Candera::String mArtistName;
    Candera::String mTitleName;
    Candera::String mAlbumName;
    Candera::String mVideoName;
    Candera::String mCurrentTrackNo;
    Candera::String mTotalTrackNo;
    Candera::String mTotalTime;
    Candera::String mElapsedTime;
    Candera::Float mSliderTotalTime;
    Candera::Float mSliderElapsedTime;
     Candera::Float mDragCurrentValue;
    Courier::Int32 mRepeatOption;
    Courier::Int32 mShuffleOption;
    Courier::Int32 mSeekCurrentPosition;
    Candera::String mPlayIconName;
    Candera::String mRepeatIconName;
    Candera::String mShuffleIconName;
    bool mArtistIcon;

    AppleDeviceData();
};

// =========================================================================
struct IconsData {
    Candera::UInt8 mIconArtistFlip;
    Candera::UInt8 mIconTitleFlip;
    Candera::UInt8 mIconAlbumFlip;

    IconsData();
};

// =========================================================================
struct IconsVisibilityData {
    Candera::UInt8 mIconArtistVisiblity;
    Candera::UInt8 mIconArtistPodcastVisiblity;
    Candera::UInt8 mIconTitleVisiblity;
    Candera::UInt8 mIconTitlePodcastVisiblity;
    Candera::UInt8 mIconAlbumVisiblity;
    Candera::UInt8 mIconAlbumAudioBookVisiblity;

    IconsVisibilityData();
};

// =========================================================================
struct NavigationVarientTypeData {
    Candera::UInt8 mNavigationsupportIndex;

    NavigationVarientTypeData();
};

// =========================================================================
struct ID3CoverDataForAppleData {
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mImage;
};

// =========================================================================
struct ID3CoverDataForBTData {
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mImage;
};

// =========================================================================
struct SDCardDeviceData {
    Candera::String mSourceName;
    Candera::String mArtistName;
    Candera::String mTitleName;
    Candera::String mAlbumName;
    Candera::String mVideoName;
    Candera::String mCurrentTrackNo;
    Candera::String mTotalTrackNo;
    Candera::String mTotalTime;
    Candera::String mElapsedTime;
    Candera::Float mSliderTotalTime;
    Candera::Float mSliderElapsedTime;
     Candera::Float mDragCurrentValue;
    Courier::Int32 mRepeatOption;
    Courier::Int32 mShuffleOption;
    Courier::Int32 mSeekCurrentPosition;
    Candera::String mPlayIconName;
    Candera::String mRepeatIconName;
    Candera::String mShuffleIconName;

    SDCardDeviceData();
};

// =========================================================================
struct ID3CoverDataForSDCardData {
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mImage;
};

// =========================================================================
struct VideoPlayerFullScreeenData {
    bool mPlayIconName;

    VideoPlayerFullScreeenData();
};

// =========================================================================
struct IpodButtonData {
    Candera::UInt8 mi8IsActive;

    IpodButtonData();
};

// =========================================================================
struct AuxButtonData {
    Candera::UInt8 mi8IsActive;

    AuxButtonData();
};

// =========================================================================
struct USBButtonData {
    Candera::UInt8 mi8IsActive;

    USBButtonData();
};

// =========================================================================
struct USB1ButtonData {
    Candera::String misConnectedWithHub;

    USB1ButtonData();
};

// =========================================================================
struct USB2ButtonData {
    Candera::UInt8 mi8IsActive;

    USB2ButtonData();
};

// =========================================================================
struct SDCardButtonData {
    Candera::UInt8 mi8IsActive;

    SDCardButtonData();
};

// =========================================================================
struct BTButtonData {
    Candera::UInt8 mi8IsActive;

    BTButtonData();
};

// =========================================================================
struct ExternalDVDButtonData {
    Candera::UInt8 mi8IsActive;

    ExternalDVDButtonData();
};

// =========================================================================
struct Camport1USBButtonData {
    Candera::UInt8 mi8IsActive;

    Camport1USBButtonData();
};

// =========================================================================
struct Camport1HDMIButtonData {
    Candera::UInt8 mi8IsActive;

    Camport1HDMIButtonData();
};

// =========================================================================
struct ExternalDVDStatusData {
    Candera::UInt8 mi8IsChecked;

    ExternalDVDStatusData();
};

// =========================================================================
struct TAStatusData {
    Candera::UInt8 mi8IsChecked;

    TAStatusData();
};

// =========================================================================
struct AUXStatusData {
    Candera::UInt8 mi8IsChecked;

    AUXStatusData();
};

// =========================================================================
struct SDCardStatusData {
    Candera::UInt8 mi8IsChecked;

    SDCardStatusData();
};

// =========================================================================
struct TitleTabData {
    Candera::UInt8 mi8IsActive;

    TitleTabData();
};

// =========================================================================
struct ArtistTabData {
    Candera::UInt8 mi8IsActive;

    ArtistTabData();
};

// =========================================================================
struct AlbumTabData {
    Candera::UInt8 mi8IsActive;

    AlbumTabData();
};

// =========================================================================
struct GenreTabData {
    Candera::UInt8 mi8IsActive;

    GenreTabData();
};

// =========================================================================
struct FolderTabData {
    Candera::UInt8 mi8IsActive;

    FolderTabData();
};

// =========================================================================
struct PlaylistTabData {
    Candera::UInt8 mi8IsActive;

    PlaylistTabData();
};

// =========================================================================
struct AudiobookTabData {
    Candera::UInt8 mi8IsActive;

    AudiobookTabData();
};

// =========================================================================
struct PodcastTabData {
    Candera::UInt8 mi8IsActive;

    PodcastTabData();
};

// =========================================================================
struct VideoTabData {
    Candera::UInt8 mi8IsActive;

    VideoTabData();
};

// =========================================================================
struct ExternalDVDVisibililtyData {
    bool mi8Isvisible;

    ExternalDVDVisibililtyData();
};

// =========================================================================
struct AUXVisibilityData {
    bool mi8Isvisible;

    AUXVisibilityData();
};

// =========================================================================
struct SDCardVisibilityData {
    bool mi8Isvisible;

    SDCardVisibilityData();
};

// =========================================================================
struct TAIconStatusData {
    Courier::UInt16 mTAIconIndex;

    TAIconStatusData();
};

// =========================================================================
struct DeviceConnectStatusData {
    Candera::String mMediaMessage1;
    Candera::String mMediaMessage2;
    Candera::String mMediaMessage3;
    Candera::String mMediaMessage4;
    bool mMessage1Visible;
    bool mMessage2Visible;
    bool mMessage3Visible;
    bool mMessage4Visible;
    bool mMediaMessageUpdateFlag;
    Candera::String mMediaMessageDeviceConnected;
    Candera::String mMediaMessageDeviceDisconnected;
    Candera::String mMediaMessageNoDevice;
    bool mMessageDeviceConnectedVisible;
    bool mMessageDeviceDisconnectedVisible;
    bool mMessageNoDeviceVisible;
    Candera::UInt16 mMediamessageIconindex;
    bool mMediamessageIconVisibleState;

    DeviceConnectStatusData();
};

// =========================================================================
struct ExternalDeviceConnectedData {
    Candera::String mDbDownloadDevice;

    ExternalDeviceConnectedData();
};

// =========================================================================
struct DBInPreparationData {
    Candera::String mDeviceType;
};

// =========================================================================
struct DBDownloadErrorData {
    Candera::String mExternalDeviceType;
};

// =========================================================================
struct DeviceNameAndStatusData {
    Candera::String mBTDeviceMuteStatus;
    Candera::String mAUXMuteStatus;
    Candera::String mExternalDVDMuteStatus;

    DeviceNameAndStatusData();
};

// =========================================================================
struct BrowseListSizeData {
    Candera::UInt16 mArtistWindowListSize;
    Candera::UInt16 mAlbumWindowListSize;
    Candera::UInt16 mGenreWindowListSize;
    Candera::UInt16 mPodcastWindowListSize;
    Candera::UInt16 mVideoWindowListSize;

    BrowseListSizeData();
};

// =========================================================================
struct BrowseListSelectedLineData {
    Candera::UInt16 mArtistSelected;
    Candera::UInt16 mAlbumSelected;
    Candera::UInt16 mGenreSelected;
    Candera::UInt16 mPodcastSelected;
    Candera::UInt16 mVideoSelected;

    BrowseListSelectedLineData();
};

// =========================================================================
struct Artist_AlbumListSizeData {
    Candera::UInt16 mArtist_AlbumWindowListSize;

    Artist_AlbumListSizeData();
};

// =========================================================================
struct Artist_AlbumListSelectedLineData {
    Candera::UInt16 mArtist_AlbumSelected;

    Artist_AlbumListSelectedLineData();
};

// =========================================================================
struct Artist_Album_TitleListSizeData {
    Candera::UInt16 mArtistAlbumTitleWindowListSize;

    Artist_Album_TitleListSizeData();
};

// =========================================================================
struct Artist_Album_TitleListSelectedLineData {
    Candera::UInt16 mArtistAlbumTitleSelected;

    Artist_Album_TitleListSelectedLineData();
};

// =========================================================================
struct Album_TitleListSizeData {
    Candera::UInt16 mAlbumTitleWindowListSize;

    Album_TitleListSizeData();
};

// =========================================================================
struct Album_TitleListSelectedLineData {
    Candera::UInt16 mAlbumTitleSelected;

    Album_TitleListSelectedLineData();
};

// =========================================================================
struct Title_ListSizeData {
    Candera::UInt16 mTitleWindowListSize;

    Title_ListSizeData();
};

// =========================================================================
struct TitleListSelectedLineData {
    Candera::UInt16 mTitleListSelectedLine;

    TitleListSelectedLineData();
};

// =========================================================================
struct Genre_ArtistListSizeData {
    Candera::UInt16 mGenreArtistWindowListSize;

    Genre_ArtistListSizeData();
};

// =========================================================================
struct Genre_ArtistListSelectedLineData {
    Candera::UInt16 mGenreArtistSelected;

    Genre_ArtistListSelectedLineData();
};

// =========================================================================
struct Genre_AllAlbumsListSizeData {
    Candera::UInt16 mGenreAllAlbumsWindowListSize;

    Genre_AllAlbumsListSizeData();
};

// =========================================================================
struct Genre_AllAlbumsListSelectedLineData {
    Candera::UInt16 mGenreAllAlbumsSelected;

    Genre_AllAlbumsListSelectedLineData();
};

// =========================================================================
struct Genre_Artist_AlbumListSizeData {
    Candera::UInt16 mGenreArtistAlbumWindowListSize;

    Genre_Artist_AlbumListSizeData();
};

// =========================================================================
struct Genre_Artist_AlbumListSelectedLineData {
    Candera::UInt16 mGenreArtistAlbumSelected;

    Genre_Artist_AlbumListSelectedLineData();
};

// =========================================================================
struct Genre_TitleListSizeData {
    Candera::UInt16 mGenreTitleWindowListSize;

    Genre_TitleListSizeData();
};

// =========================================================================
struct Genre_TitleListSelectedLineData {
    Candera::UInt16 mGenreTitleSelected;

    Genre_TitleListSelectedLineData();
};

// =========================================================================
struct FastForwardRewindPopupData {
    Candera::String mFastForwardRewindText;
    Candera::UInt16 mCurrentValue;

    FastForwardRewindPopupData();
};

// =========================================================================
struct BTShuffleData {
    Courier::Int32 mBTShuffleOption;
    Candera::String mBTShuffleIconName;

    BTShuffleData();
};

// =========================================================================
struct BTRepeatData {
    Courier::Int32 mBTRepeatOption;
    Candera::String mBTRepeatIconName;

    BTRepeatData();
};

// =========================================================================
struct BTPlayInfoUpdateData {
    Candera::String mSourceName;
    Candera::String mArtistName;
    Candera::String mTitleName;
    Candera::String mAlbumName;
    Candera::String mCurrentTrackNo;
    Candera::String mTotalTrackNo;
    Candera::String mTotalTime;
    Candera::String mElapsedTime;
    Candera::Float mSliderTotalTime;
    Candera::Float mSliderElapsedTime;
     Candera::Float mDragCurrentValue;
    Candera::String mPlayIconName;

    BTPlayInfoUpdateData();
};

// =========================================================================
struct BTSliderVisibilityData {
    bool mi8Isvisible;

    BTSliderVisibilityData();
};

// =========================================================================
struct BTTotalTimeVisibilityData {
    bool mi8Isvisible;

    BTTotalTimeVisibilityData();
};

// =========================================================================
struct BTElapsedTimeVisibilityData {
    bool mi8Isvisible;

    BTElapsedTimeVisibilityData();
};

// =========================================================================
struct ID3CoverDataData {
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mImage;
};

// =========================================================================
struct Audiobook_ListSizeData {
    Candera::UInt16 mAudiobookWindowListSize;

    Audiobook_ListSizeData();
};

// =========================================================================
struct AudiobookListSelectedLineData {
    Candera::UInt16 mAudiobookListSelectedLine;

    AudiobookListSelectedLineData();
};

// =========================================================================
struct AudiobookChapter_ListSizeData {
    Candera::UInt16 mAudiobookChapterWindowListSize;

    AudiobookChapter_ListSizeData();
};

// =========================================================================
struct AudiobookChapterListSelectedLineData {
    Candera::UInt16 mAudiobookChapterListSelectedLine;

    AudiobookChapterListSelectedLineData();
};

// =========================================================================
struct Playlist_ListSizeData {
    Candera::UInt16 mPlaylistWindowListSize;

    Playlist_ListSizeData();
};

// =========================================================================
struct PlaylistListSelectedLineData {
    Candera::UInt16 mPlaylistListSelectedLine;

    PlaylistListSelectedLineData();
};

// =========================================================================
struct PlaylistTitle_ListSizeData {
    Candera::UInt16 mPlaylistTitleWindowListSize;

    PlaylistTitle_ListSizeData();
};

// =========================================================================
struct PlaylistTitleListSelectedLineData {
    Candera::UInt16 mPlaylistTitleListSelectedLine;

    PlaylistTitleListSelectedLineData();
};

// =========================================================================
struct Podcast_EpisodeListSizeData {
    Candera::UInt16 mPodcastEpisodeWindowListSize;

    Podcast_EpisodeListSizeData();
};

// =========================================================================
struct Podcast_EpisodeListSelectedLineData {
    Candera::UInt16 mPodcastEpisodeSelected;

    Podcast_EpisodeListSelectedLineData();
};

// =========================================================================
struct Video_EpisodeListSizeData {
    Candera::UInt16 mVideoEpisodeWindowListSize;

    Video_EpisodeListSizeData();
};

// =========================================================================
struct Video_EpisodeListSelectedLineData {
    Candera::UInt16 mVideoEpisodeSelected;

    Video_EpisodeListSelectedLineData();
};

// =========================================================================
struct Folder_ListSizeData {
    Candera::UInt16 mFolderWindowListSize;

    Folder_ListSizeData();
};

// =========================================================================
struct Folder_ListSelectedLineData {
    Candera::UInt16 mFolderSelected;

    Folder_ListSelectedLineData();
};

// =========================================================================
struct FolderFile_ListSizeData {
    Candera::UInt16 mFolderFile_WindowListSize;

    FolderFile_ListSizeData();
};

// =========================================================================
struct FolderFile_ListSelectedLineData {
    Candera::UInt16 mFolderFileSelected;

    FolderFile_ListSelectedLineData();
};

// =========================================================================
struct Folder_NameData {
    Candera::String mFolderFileName;

    Folder_NameData();
};

// =========================================================================
struct NotebookdataData {
    Candera::UInt16 mCurrentTab;

    NotebookdataData();
};

// =========================================================================
struct TabNextPrevIndexData {
    bool mNextIndex;
    bool mPrevIndex;
    bool mEnableTouchNext;
    bool mEnableTouchPrev;

    TabNextPrevIndexData();
};

// =========================================================================
struct ListstatusData {
    Candera::UInt32 mViewportstartIndexAlbum;
    Candera::UInt32 mViewportstartIndexAlbum_song;
    Candera::UInt32 mViewportstartIndexArtist;
    Candera::UInt32 mViewportstartIndexArtist_Album;
    Candera::UInt32 mViewportstartIndexArtist_Album_Song;
    Candera::UInt32 mViewportstartIndexArtist_Song;
    Candera::UInt32 mViewportstartIndexAudiobook;
    Candera::UInt32 mViewportstartIndexAudiobooktitle_Chapter;
    Candera::UInt32 mViewportstartIndexFolder;
    Candera::UInt32 mViewportstartIndexFolder_File;
    Candera::UInt32 mViewportstartIndexGenre;
    Candera::UInt32 mViewportstartIndexGenre_Album;
    Candera::UInt32 mViewportstartIndexGenre_Album_Song;
    Candera::UInt32 mViewportstartIndexGenre_Artist;
    Candera::UInt32 mViewportstartIndexGenre_Artist_Album;
    Candera::UInt32 mViewportstartIndexGenre_Artist_Album_Song;
    Candera::UInt32 mViewportstartIndexGenre_Artist_Song;
    Candera::UInt32 mViewportstartIndexPlaylist;
    Candera::UInt32 mViewportstartIndexPlaylist_Song;
    Candera::UInt32 mViewportstartIndexPodcast;
    Candera::UInt32 mViewportstartIndexPodcast_Episode;
    Candera::UInt32 mViewportstartIndexSong;
    Candera::UInt32 mViewportstartIndexVideo;
    Candera::UInt32 mViewportstartIndexVideo_Episode;

    ListstatusData();
};

// =========================================================================
struct SDRepeatOptionData {
    Candera::String mRepeatTrack;
    Candera::String mRepeatList;

    SDRepeatOptionData();
};

// =========================================================================
struct USBRepeatOptionData {
    Candera::String mRepeatTrack;
    Candera::String mRepeatList;
    Candera::UInt8 mRepeatIndex;

    USBRepeatOptionData();
};

// =========================================================================
struct USBCameraPortRepeatOptionData {
    Candera::String mRepeatTrack;
    Candera::String mRepeatList;
    Candera::UInt8 mRepeatIndex;

    USBCameraPortRepeatOptionData();
};

// =========================================================================
struct USBRouterRepeatOptionData {
    Candera::String mRepeatTrack;
    Candera::UInt8 mRepeatIndex;

    USBRouterRepeatOptionData();
};

// =========================================================================
struct BTRepeatOptionData {
    Candera::String mRepeatTrack;
    Candera::String mRepeatList;
    Candera::UInt8 mRepeatIndex;

    BTRepeatOptionData();
};

// =========================================================================
struct AppleRepeatOptionData {
    Candera::String mRepeatTrack;
    Candera::String mRepeatList;
    Candera::UInt8 mRepeatIndex;

    AppleRepeatOptionData();
};

// =========================================================================
struct SDShuffleOptionData {
    Candera::String mShuffleOff;
    Candera::String mShuffleOn;

    SDShuffleOptionData();
};

// =========================================================================
struct USBShuffleOptionData {
    Candera::String mShuffleOff;
    Candera::String mShuffleOn;
    Candera::UInt8 mShuffleIndex;

    USBShuffleOptionData();
};

// =========================================================================
struct USBCameraPortShuffleOptionData {
    Candera::String mShuffleOff;
    Candera::String mShuffleOn;
    Candera::UInt8 mShuffleIndex;

    USBCameraPortShuffleOptionData();
};

// =========================================================================
struct USBRouterShuffleOptionData {
    Candera::String mShuffleOff;
    Candera::String mShuffleOn;
    Candera::UInt8 mShuffleIndex;

    USBRouterShuffleOptionData();
};

// =========================================================================
struct USBPlayPauseOptionData {
    Candera::UInt8 mPlayPauseIndex;

    USBPlayPauseOptionData();
};

// =========================================================================
struct USBCameraPortPlayPauseOptionData {
    Candera::UInt8 mPlayPauseIndex;

    USBCameraPortPlayPauseOptionData();
};

// =========================================================================
struct USBRouterPlayPauseOptionData {
    Candera::UInt8 mPlayPauseIndex;

    USBRouterPlayPauseOptionData();
};

// =========================================================================
struct ApplePlayPauseOptionData {
    Candera::UInt8 mPlayPauseIndex;

    ApplePlayPauseOptionData();
};

// =========================================================================
struct BTPlayPauseOptionData {
    Candera::UInt8 mPlayPauseIndex;

    BTPlayPauseOptionData();
};

// =========================================================================
struct BTShuffleOptionData {
    Candera::String mShuffleOff;
    Candera::String mShuffleOn;
    Candera::UInt8 mShuffleIndex;

    BTShuffleOptionData();
};

// =========================================================================
struct AppleShuffleOptionData {
    Candera::String mShuffleOff;
    Candera::String mShuffleOn;
    Candera::UInt8 mShuffleIndex;

    AppleShuffleOptionData();
};

// =========================================================================
struct SPIConnectionTypeData {
    Candera::UInt8 mSPIConnectionIndex;

    SPIConnectionTypeData();
};

// =========================================================================
struct AuxFeatureControllerData {
    bool mEnableStatus;

    AuxFeatureControllerData();
};

// =========================================================================
struct MediaListIDData {
    Candera::UInt16 mAlbumListID;
    Candera::UInt16 mTitleListID;

    MediaListIDData();
};

// =========================================================================
struct MediaTabActiveStateData {
    bool mTitleTabActiveStateChange;
    bool mArtistTabActiveStateChange;
    bool mAlbumTabActiveStateChange;
    bool mGenreTabActiveStateChange;
    bool mFolderTabActiveStateChange;
    bool mPlaylistTabActiveStateChange;
    bool mAudioBkTabActiveStateChange;
    bool mPodcastTabActiveStateChange;
    bool mVideoTabActiveStateChange;

    MediaTabActiveStateData();
};

// =========================================================================
struct VideoTabActivationData {
    bool mIsVideoTabActiveVariant;

    VideoTabActivationData();
};

// =========================================================================
struct USBCameraPortAlbumVisibilityData {
    bool mIconAndTextVisiblity;

    USBCameraPortAlbumVisibilityData();
};

// =========================================================================
struct USBRouterAlbumVisibilityData {
    bool mIconAndTextVisiblity;

    USBRouterAlbumVisibilityData();
};

// =========================================================================
struct AuxActivationData {
    bool mIsAuxActiveVariant;

    AuxActivationData();
};

// =========================================================================
struct FolderListDataItemData {
    Candera::UInt16 mIconImageIndexVal;

    FolderListDataItemData();
};

// =========================================================================
struct DownloadVisibilityDataItemData {
    bool mDownloadIconVisibilityVal;
    Candera::UInt16 mDownloadIconSwitchVal;
    bool mDownloadAnimationStatus;

    DownloadVisibilityDataItemData();
};

// =========================================================================
struct FolderFileListDataItemData {
    Candera::UInt16 mFolderFileIconImageIndex;

    FolderFileListDataItemData();
};

// =========================================================================
struct BrowseTextChangeData {
    Candera::String mBrowseText;

    BrowseTextChangeData();
};

// =========================================================================
struct ExternalBrowseTextInfoData {
    Candera::String mBrowseText;

    ExternalBrowseTextInfoData();
};

// =========================================================================
struct BrowserScreenListSizeData {
    Candera::Vector2 mPreviousButtonSize;
    Candera::Vector2 mAllAlbumAndTitleButtonSize;
    Candera::Vector2 mVerticalListSize;
    Candera::Vector2 mScrollBarSize;
    bool mPreviousButtonVisibility;
    bool mAllAlbumAndTitleButtonVisibility;
    Candera::String mAllAlbumAndTitleText;
    bool mAlbumIconVisibility;
    bool mTitleIconVisibility;
    bool mListVisibility;
    Candera::Float mScrollBarSliderSize;

    BrowserScreenListSizeData();
};

// =========================================================================
struct BrowseListInfoTextData {
    bool mListInfoTextVisiblity;

    BrowseListInfoTextData();
};

// =========================================================================
struct MediaTabDisabledStateData {
    bool mGenreTabDisabledStateChange;
    bool mPlaylistTabDisabledStateChange;
    bool mAlbumTabDisabledStateChange;
    bool mAudiobookTabDisabledStateChange;
    bool mPageUpDisabledStateChange;
    bool mPageDownDisabledStateChange;

    MediaTabDisabledStateData();
};

// =========================================================================
struct MuteStateVisibleGadgetData {
    bool mMuteImageVisibility;
    bool mPlayEnableIconVisible;
    bool mControlIconStatus;
    bool mPlayDisableIconVisible;

    MuteStateVisibleGadgetData();
};

// =========================================================================
struct MediaSourceUpdateInGadgetData {
    Candera::UInt8 mMediaSourceIndex;

    MediaSourceUpdateInGadgetData();
};

// =========================================================================
struct MediaMetaDataUpdateInGadgetData {
    Candera::UInt8 mMediaGadgetIndex;

    MediaMetaDataUpdateInGadgetData();
};

// =========================================================================
struct PlaybackActionGadgetData {
    Candera::String mArtistName;
    Candera::String mTitleName;
    Candera::String mElapsedTime;
    Candera::String mTotalTime;
    Candera::Float mSliderTotalTime;
    Candera::Float mSliderElapsedTime;

    PlaybackActionGadgetData();
};

// =========================================================================
struct PlaybackActionCabinAGadgetData {
    Candera::String mArtistName;
    Candera::String mTitleName;
    Candera::String mElapsedTime;
    Candera::String mTotalTime;
    Candera::Float mSliderTotalTime;
    Candera::Float mSliderElapsedTime;

    PlaybackActionCabinAGadgetData();
};

// =========================================================================
struct PlaybackActionRouterGadgetData {
    Candera::String mArtistName;
    Candera::String mTitleName;
    Candera::String mElapsedTime;
    Candera::String mTotalTime;
    Candera::Float mSliderTotalTime;
    Candera::Float mSliderElapsedTime;

    PlaybackActionRouterGadgetData();
};

// =========================================================================
struct GadgetItemVisibilityStateData {
    bool mGadgetButtonsVisibleState;
    bool mGadgetSourceIconAndTextVisibleState;
    bool mGadgetCabinDefaultTextVisibleState;
    bool mGadgetCabinRestorationTextVisibleState;

    GadgetItemVisibilityStateData();
};

// =========================================================================
struct GadgetPlayPauseOptionData {
    Candera::UInt8 mPlayPauseIndex;

    GadgetPlayPauseOptionData();
};

// =========================================================================
struct MediaSourceUSBNameInGadgetData {
    Candera::String mUSBName;

    MediaSourceUSBNameInGadgetData();
};

// =========================================================================
struct CamportUSBGadgetPlayPauseOptionData {
    Candera::UInt8 mPlayPauseIndex;

    CamportUSBGadgetPlayPauseOptionData();
};

// =========================================================================
struct RouterUSBGadgetPlayPauseOptionData {
    Candera::UInt8 mPlayPauseIndex;

    RouterUSBGadgetPlayPauseOptionData();
};
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
namespace FeatStd {
template<> ::FeatStd::UInt32 StringBufferAppender< ::DeviceConnectionData >::Append(::FeatStd::StringBuffer& stringBuffer, ::DeviceConnectionData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::BTVisibilityData >::Append(::FeatStd::StringBuffer& stringBuffer, ::BTVisibilityData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::SPIVisibilityData >::Append(::FeatStd::StringBuffer& stringBuffer, ::SPIVisibilityData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::PlaybackActionData >::Append(::FeatStd::StringBuffer& stringBuffer, ::PlaybackActionData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::USBCameraPortPlaybackActionData >::Append(::FeatStd::StringBuffer& stringBuffer, ::USBCameraPortPlaybackActionData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::USBRouterPlaybackActionData >::Append(::FeatStd::StringBuffer& stringBuffer, ::USBRouterPlaybackActionData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::MuteInfoData >::Append(::FeatStd::StringBuffer& stringBuffer, ::MuteInfoData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::MuteInfoforAuxData >::Append(::FeatStd::StringBuffer& stringBuffer, ::MuteInfoforAuxData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::USB2VisibilityData >::Append(::FeatStd::StringBuffer& stringBuffer, ::USB2VisibilityData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::VariantInfoData >::Append(::FeatStd::StringBuffer& stringBuffer, ::VariantInfoData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::ExternalMediaSourceData >::Append(::FeatStd::StringBuffer& stringBuffer, ::ExternalMediaSourceData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::TabVideoSourceData >::Append(::FeatStd::StringBuffer& stringBuffer, ::TabVideoSourceData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::BTNowplayIconsData >::Append(::FeatStd::StringBuffer& stringBuffer, ::BTNowplayIconsData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::ID3CoverDataForGadgetData >::Append(::FeatStd::StringBuffer& stringBuffer, ::ID3CoverDataForGadgetData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::ID3CoverDataForCamportUSBGadgetData >::Append(::FeatStd::StringBuffer& stringBuffer, ::ID3CoverDataForCamportUSBGadgetData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::ID3CoverDataForRouterUSBGadgetData >::Append(::FeatStd::StringBuffer& stringBuffer, ::ID3CoverDataForRouterUSBGadgetData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::ID3CoverDataForCamportUSBData >::Append(::FeatStd::StringBuffer& stringBuffer, ::ID3CoverDataForCamportUSBData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::ID3CoverDataForRouterUSBData >::Append(::FeatStd::StringBuffer& stringBuffer, ::ID3CoverDataForRouterUSBData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::AlbumListItemData >::Append(::FeatStd::StringBuffer& stringBuffer, ::AlbumListItemData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::VideoPlaybackActionData >::Append(::FeatStd::StringBuffer& stringBuffer, ::VideoPlaybackActionData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::AppleDeviceData >::Append(::FeatStd::StringBuffer& stringBuffer, ::AppleDeviceData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::IconsData >::Append(::FeatStd::StringBuffer& stringBuffer, ::IconsData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::IconsVisibilityData >::Append(::FeatStd::StringBuffer& stringBuffer, ::IconsVisibilityData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::NavigationVarientTypeData >::Append(::FeatStd::StringBuffer& stringBuffer, ::NavigationVarientTypeData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::ID3CoverDataForAppleData >::Append(::FeatStd::StringBuffer& stringBuffer, ::ID3CoverDataForAppleData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::ID3CoverDataForBTData >::Append(::FeatStd::StringBuffer& stringBuffer, ::ID3CoverDataForBTData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::SDCardDeviceData >::Append(::FeatStd::StringBuffer& stringBuffer, ::SDCardDeviceData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::ID3CoverDataForSDCardData >::Append(::FeatStd::StringBuffer& stringBuffer, ::ID3CoverDataForSDCardData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::VideoPlayerFullScreeenData >::Append(::FeatStd::StringBuffer& stringBuffer, ::VideoPlayerFullScreeenData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::IpodButtonData >::Append(::FeatStd::StringBuffer& stringBuffer, ::IpodButtonData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::AuxButtonData >::Append(::FeatStd::StringBuffer& stringBuffer, ::AuxButtonData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::USBButtonData >::Append(::FeatStd::StringBuffer& stringBuffer, ::USBButtonData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::USB1ButtonData >::Append(::FeatStd::StringBuffer& stringBuffer, ::USB1ButtonData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::USB2ButtonData >::Append(::FeatStd::StringBuffer& stringBuffer, ::USB2ButtonData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::SDCardButtonData >::Append(::FeatStd::StringBuffer& stringBuffer, ::SDCardButtonData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::BTButtonData >::Append(::FeatStd::StringBuffer& stringBuffer, ::BTButtonData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::ExternalDVDButtonData >::Append(::FeatStd::StringBuffer& stringBuffer, ::ExternalDVDButtonData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::Camport1USBButtonData >::Append(::FeatStd::StringBuffer& stringBuffer, ::Camport1USBButtonData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::Camport1HDMIButtonData >::Append(::FeatStd::StringBuffer& stringBuffer, ::Camport1HDMIButtonData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::ExternalDVDStatusData >::Append(::FeatStd::StringBuffer& stringBuffer, ::ExternalDVDStatusData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::TAStatusData >::Append(::FeatStd::StringBuffer& stringBuffer, ::TAStatusData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::AUXStatusData >::Append(::FeatStd::StringBuffer& stringBuffer, ::AUXStatusData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::SDCardStatusData >::Append(::FeatStd::StringBuffer& stringBuffer, ::SDCardStatusData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::TitleTabData >::Append(::FeatStd::StringBuffer& stringBuffer, ::TitleTabData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::ArtistTabData >::Append(::FeatStd::StringBuffer& stringBuffer, ::ArtistTabData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::AlbumTabData >::Append(::FeatStd::StringBuffer& stringBuffer, ::AlbumTabData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::GenreTabData >::Append(::FeatStd::StringBuffer& stringBuffer, ::GenreTabData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::FolderTabData >::Append(::FeatStd::StringBuffer& stringBuffer, ::FolderTabData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::PlaylistTabData >::Append(::FeatStd::StringBuffer& stringBuffer, ::PlaylistTabData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::AudiobookTabData >::Append(::FeatStd::StringBuffer& stringBuffer, ::AudiobookTabData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::PodcastTabData >::Append(::FeatStd::StringBuffer& stringBuffer, ::PodcastTabData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::VideoTabData >::Append(::FeatStd::StringBuffer& stringBuffer, ::VideoTabData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::ExternalDVDVisibililtyData >::Append(::FeatStd::StringBuffer& stringBuffer, ::ExternalDVDVisibililtyData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::AUXVisibilityData >::Append(::FeatStd::StringBuffer& stringBuffer, ::AUXVisibilityData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::SDCardVisibilityData >::Append(::FeatStd::StringBuffer& stringBuffer, ::SDCardVisibilityData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::TAIconStatusData >::Append(::FeatStd::StringBuffer& stringBuffer, ::TAIconStatusData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::DeviceConnectStatusData >::Append(::FeatStd::StringBuffer& stringBuffer, ::DeviceConnectStatusData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::ExternalDeviceConnectedData >::Append(::FeatStd::StringBuffer& stringBuffer, ::ExternalDeviceConnectedData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::DBInPreparationData >::Append(::FeatStd::StringBuffer& stringBuffer, ::DBInPreparationData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::DBDownloadErrorData >::Append(::FeatStd::StringBuffer& stringBuffer, ::DBDownloadErrorData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::DeviceNameAndStatusData >::Append(::FeatStd::StringBuffer& stringBuffer, ::DeviceNameAndStatusData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::BrowseListSizeData >::Append(::FeatStd::StringBuffer& stringBuffer, ::BrowseListSizeData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::BrowseListSelectedLineData >::Append(::FeatStd::StringBuffer& stringBuffer, ::BrowseListSelectedLineData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::Artist_AlbumListSizeData >::Append(::FeatStd::StringBuffer& stringBuffer, ::Artist_AlbumListSizeData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::Artist_AlbumListSelectedLineData >::Append(::FeatStd::StringBuffer& stringBuffer, ::Artist_AlbumListSelectedLineData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::Artist_Album_TitleListSizeData >::Append(::FeatStd::StringBuffer& stringBuffer, ::Artist_Album_TitleListSizeData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::Artist_Album_TitleListSelectedLineData >::Append(::FeatStd::StringBuffer& stringBuffer, ::Artist_Album_TitleListSelectedLineData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::Album_TitleListSizeData >::Append(::FeatStd::StringBuffer& stringBuffer, ::Album_TitleListSizeData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::Album_TitleListSelectedLineData >::Append(::FeatStd::StringBuffer& stringBuffer, ::Album_TitleListSelectedLineData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::Title_ListSizeData >::Append(::FeatStd::StringBuffer& stringBuffer, ::Title_ListSizeData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::TitleListSelectedLineData >::Append(::FeatStd::StringBuffer& stringBuffer, ::TitleListSelectedLineData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::Genre_ArtistListSizeData >::Append(::FeatStd::StringBuffer& stringBuffer, ::Genre_ArtistListSizeData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::Genre_ArtistListSelectedLineData >::Append(::FeatStd::StringBuffer& stringBuffer, ::Genre_ArtistListSelectedLineData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::Genre_AllAlbumsListSizeData >::Append(::FeatStd::StringBuffer& stringBuffer, ::Genre_AllAlbumsListSizeData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::Genre_AllAlbumsListSelectedLineData >::Append(::FeatStd::StringBuffer& stringBuffer, ::Genre_AllAlbumsListSelectedLineData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::Genre_Artist_AlbumListSizeData >::Append(::FeatStd::StringBuffer& stringBuffer, ::Genre_Artist_AlbumListSizeData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::Genre_Artist_AlbumListSelectedLineData >::Append(::FeatStd::StringBuffer& stringBuffer, ::Genre_Artist_AlbumListSelectedLineData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::Genre_TitleListSizeData >::Append(::FeatStd::StringBuffer& stringBuffer, ::Genre_TitleListSizeData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::Genre_TitleListSelectedLineData >::Append(::FeatStd::StringBuffer& stringBuffer, ::Genre_TitleListSelectedLineData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::FastForwardRewindPopupData >::Append(::FeatStd::StringBuffer& stringBuffer, ::FastForwardRewindPopupData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::BTShuffleData >::Append(::FeatStd::StringBuffer& stringBuffer, ::BTShuffleData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::BTRepeatData >::Append(::FeatStd::StringBuffer& stringBuffer, ::BTRepeatData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::BTPlayInfoUpdateData >::Append(::FeatStd::StringBuffer& stringBuffer, ::BTPlayInfoUpdateData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::BTSliderVisibilityData >::Append(::FeatStd::StringBuffer& stringBuffer, ::BTSliderVisibilityData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::BTTotalTimeVisibilityData >::Append(::FeatStd::StringBuffer& stringBuffer, ::BTTotalTimeVisibilityData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::BTElapsedTimeVisibilityData >::Append(::FeatStd::StringBuffer& stringBuffer, ::BTElapsedTimeVisibilityData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::ID3CoverDataData >::Append(::FeatStd::StringBuffer& stringBuffer, ::ID3CoverDataData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::Audiobook_ListSizeData >::Append(::FeatStd::StringBuffer& stringBuffer, ::Audiobook_ListSizeData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::AudiobookListSelectedLineData >::Append(::FeatStd::StringBuffer& stringBuffer, ::AudiobookListSelectedLineData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::AudiobookChapter_ListSizeData >::Append(::FeatStd::StringBuffer& stringBuffer, ::AudiobookChapter_ListSizeData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::AudiobookChapterListSelectedLineData >::Append(::FeatStd::StringBuffer& stringBuffer, ::AudiobookChapterListSelectedLineData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::Playlist_ListSizeData >::Append(::FeatStd::StringBuffer& stringBuffer, ::Playlist_ListSizeData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::PlaylistListSelectedLineData >::Append(::FeatStd::StringBuffer& stringBuffer, ::PlaylistListSelectedLineData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::PlaylistTitle_ListSizeData >::Append(::FeatStd::StringBuffer& stringBuffer, ::PlaylistTitle_ListSizeData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::PlaylistTitleListSelectedLineData >::Append(::FeatStd::StringBuffer& stringBuffer, ::PlaylistTitleListSelectedLineData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::Podcast_EpisodeListSizeData >::Append(::FeatStd::StringBuffer& stringBuffer, ::Podcast_EpisodeListSizeData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::Podcast_EpisodeListSelectedLineData >::Append(::FeatStd::StringBuffer& stringBuffer, ::Podcast_EpisodeListSelectedLineData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::Video_EpisodeListSizeData >::Append(::FeatStd::StringBuffer& stringBuffer, ::Video_EpisodeListSizeData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::Video_EpisodeListSelectedLineData >::Append(::FeatStd::StringBuffer& stringBuffer, ::Video_EpisodeListSelectedLineData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::Folder_ListSizeData >::Append(::FeatStd::StringBuffer& stringBuffer, ::Folder_ListSizeData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::Folder_ListSelectedLineData >::Append(::FeatStd::StringBuffer& stringBuffer, ::Folder_ListSelectedLineData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::FolderFile_ListSizeData >::Append(::FeatStd::StringBuffer& stringBuffer, ::FolderFile_ListSizeData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::FolderFile_ListSelectedLineData >::Append(::FeatStd::StringBuffer& stringBuffer, ::FolderFile_ListSelectedLineData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::Folder_NameData >::Append(::FeatStd::StringBuffer& stringBuffer, ::Folder_NameData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::NotebookdataData >::Append(::FeatStd::StringBuffer& stringBuffer, ::NotebookdataData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::TabNextPrevIndexData >::Append(::FeatStd::StringBuffer& stringBuffer, ::TabNextPrevIndexData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::ListstatusData >::Append(::FeatStd::StringBuffer& stringBuffer, ::ListstatusData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::SDRepeatOptionData >::Append(::FeatStd::StringBuffer& stringBuffer, ::SDRepeatOptionData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::USBRepeatOptionData >::Append(::FeatStd::StringBuffer& stringBuffer, ::USBRepeatOptionData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::USBCameraPortRepeatOptionData >::Append(::FeatStd::StringBuffer& stringBuffer, ::USBCameraPortRepeatOptionData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::USBRouterRepeatOptionData >::Append(::FeatStd::StringBuffer& stringBuffer, ::USBRouterRepeatOptionData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::BTRepeatOptionData >::Append(::FeatStd::StringBuffer& stringBuffer, ::BTRepeatOptionData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::AppleRepeatOptionData >::Append(::FeatStd::StringBuffer& stringBuffer, ::AppleRepeatOptionData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::SDShuffleOptionData >::Append(::FeatStd::StringBuffer& stringBuffer, ::SDShuffleOptionData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::USBShuffleOptionData >::Append(::FeatStd::StringBuffer& stringBuffer, ::USBShuffleOptionData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::USBCameraPortShuffleOptionData >::Append(::FeatStd::StringBuffer& stringBuffer, ::USBCameraPortShuffleOptionData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::USBRouterShuffleOptionData >::Append(::FeatStd::StringBuffer& stringBuffer, ::USBRouterShuffleOptionData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::USBPlayPauseOptionData >::Append(::FeatStd::StringBuffer& stringBuffer, ::USBPlayPauseOptionData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::USBCameraPortPlayPauseOptionData >::Append(::FeatStd::StringBuffer& stringBuffer, ::USBCameraPortPlayPauseOptionData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::USBRouterPlayPauseOptionData >::Append(::FeatStd::StringBuffer& stringBuffer, ::USBRouterPlayPauseOptionData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::ApplePlayPauseOptionData >::Append(::FeatStd::StringBuffer& stringBuffer, ::ApplePlayPauseOptionData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::BTPlayPauseOptionData >::Append(::FeatStd::StringBuffer& stringBuffer, ::BTPlayPauseOptionData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::BTShuffleOptionData >::Append(::FeatStd::StringBuffer& stringBuffer, ::BTShuffleOptionData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::AppleShuffleOptionData >::Append(::FeatStd::StringBuffer& stringBuffer, ::AppleShuffleOptionData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::SPIConnectionTypeData >::Append(::FeatStd::StringBuffer& stringBuffer, ::SPIConnectionTypeData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::AuxFeatureControllerData >::Append(::FeatStd::StringBuffer& stringBuffer, ::AuxFeatureControllerData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::MediaListIDData >::Append(::FeatStd::StringBuffer& stringBuffer, ::MediaListIDData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::MediaTabActiveStateData >::Append(::FeatStd::StringBuffer& stringBuffer, ::MediaTabActiveStateData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::VideoTabActivationData >::Append(::FeatStd::StringBuffer& stringBuffer, ::VideoTabActivationData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::USBCameraPortAlbumVisibilityData >::Append(::FeatStd::StringBuffer& stringBuffer, ::USBCameraPortAlbumVisibilityData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::USBRouterAlbumVisibilityData >::Append(::FeatStd::StringBuffer& stringBuffer, ::USBRouterAlbumVisibilityData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::AuxActivationData >::Append(::FeatStd::StringBuffer& stringBuffer, ::AuxActivationData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::FolderListDataItemData >::Append(::FeatStd::StringBuffer& stringBuffer, ::FolderListDataItemData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::DownloadVisibilityDataItemData >::Append(::FeatStd::StringBuffer& stringBuffer, ::DownloadVisibilityDataItemData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::FolderFileListDataItemData >::Append(::FeatStd::StringBuffer& stringBuffer, ::FolderFileListDataItemData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::BrowseTextChangeData >::Append(::FeatStd::StringBuffer& stringBuffer, ::BrowseTextChangeData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::ExternalBrowseTextInfoData >::Append(::FeatStd::StringBuffer& stringBuffer, ::ExternalBrowseTextInfoData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::BrowserScreenListSizeData >::Append(::FeatStd::StringBuffer& stringBuffer, ::BrowserScreenListSizeData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::BrowseListInfoTextData >::Append(::FeatStd::StringBuffer& stringBuffer, ::BrowseListInfoTextData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::MediaTabDisabledStateData >::Append(::FeatStd::StringBuffer& stringBuffer, ::MediaTabDisabledStateData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::MuteStateVisibleGadgetData >::Append(::FeatStd::StringBuffer& stringBuffer, ::MuteStateVisibleGadgetData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::MediaSourceUpdateInGadgetData >::Append(::FeatStd::StringBuffer& stringBuffer, ::MediaSourceUpdateInGadgetData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::MediaMetaDataUpdateInGadgetData >::Append(::FeatStd::StringBuffer& stringBuffer, ::MediaMetaDataUpdateInGadgetData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::PlaybackActionGadgetData >::Append(::FeatStd::StringBuffer& stringBuffer, ::PlaybackActionGadgetData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::PlaybackActionCabinAGadgetData >::Append(::FeatStd::StringBuffer& stringBuffer, ::PlaybackActionCabinAGadgetData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::PlaybackActionRouterGadgetData >::Append(::FeatStd::StringBuffer& stringBuffer, ::PlaybackActionRouterGadgetData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::GadgetItemVisibilityStateData >::Append(::FeatStd::StringBuffer& stringBuffer, ::GadgetItemVisibilityStateData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::GadgetPlayPauseOptionData >::Append(::FeatStd::StringBuffer& stringBuffer, ::GadgetPlayPauseOptionData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::MediaSourceUSBNameInGadgetData >::Append(::FeatStd::StringBuffer& stringBuffer, ::MediaSourceUSBNameInGadgetData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::CamportUSBGadgetPlayPauseOptionData >::Append(::FeatStd::StringBuffer& stringBuffer, ::CamportUSBGadgetPlayPauseOptionData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::RouterUSBGadgetPlayPauseOptionData >::Append(::FeatStd::StringBuffer& stringBuffer, ::RouterUSBGadgetPlayPauseOptionData const & object);
} // namespace FeatStd
#endif
#endif // AppHmi_MediaDatabinding_h
