/************************************************************************
*FILE: AppHmi_MasterStateMachine.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(AppHmi_MasterStateMachine_h)
#define AppHmi_MasterStateMachine_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Courier/Platform/MessageFactory.h>
#include <Courier/Messaging/Message.h>
#include <AppHmi_MasterStateMachineSEMLibB.h>
#include <AppHmi_MasterStateMachineData.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Cit/VisualStateGlueLayer/DeductResult.h>
#ifdef CIT_SIMULATION
#include <json/value.h>
#endif
#include <AppHmi_MasterTypes.h>
#include <AppHmi_MasterConstants.h>
#include <AppHmi_MasterMessages.h>
#include <AppHmi_MasterDatabinding.h>
#include <AppHmi_MasterViews.h>
#include <AppHmi_MasterController.h>
// ------------------------------------------------------------------------
class AppHmi_MasterStateMachineImpl : public AppHmi_MasterStateMachine
{
public:
    typedef AppHmi_MasterStateMachine Base;

#ifdef VISUALSTATE_7_TRACE
    // Mapping of data types of API to get rid of include dependencies
    //typedef SEM_ACTION_EXPRESSION_TYPE VS_Type_ActionExpression;
	using Base::VS_Type_ActionExpression;
    //typedef SEM_EVENT_TYPE VS_Type_Event;
	//typedef SEM_STATE_TYPE VS_Type_State;
	//typedef SEM_EXPLANATION_TYPE VS_Type_Explanation;
	//typedef SEM_STATE_MACHINE_TYPE VS_Type_Statemachine;
	using Base::VS_Type_Event;
	using Base::VS_Type_State;
	using Base::VS_Type_Explanation;
	using Base::VS_Type_Statemachine;

    // Mapping of enums and defines of API to get rid of include dependencies
    //enum { VS_Ret_Ok = SES_OKAY };
    //enum { VS_Ret_Found = SES_FOUND };
	enum { VS_Ret_Ok = Base::VS_Ret_Ok };
	enum { VS_Ret_Found = Base::VS_Ret_Found };
    enum { VS_Evt_Reset = SE_RESET };
    enum { VS_Ret_Error = SES_RANGE_ERR };
#else
#ifndef VISUALSTATE_HCODER
    typedef SEM_ACTION_EXPRESSION_TYPE VS_Type_ActionExpression;
    typedef SEM_EVENT_TYPE VS_Type_Event;
    typedef SEM_STATE_TYPE VS_Type_State;
    typedef SEM_EXPLANATION_TYPE VS_Type_Explanation;
    typedef SEM_STATE_MACHINE_TYPE VS_Type_Statemachine;
    enum { VS_Ret_Ok = SES_OKAY };
    enum { VS_Ret_Found = SES_FOUND };
    enum { VS_Evt_Reset = SE_RESET };
    enum { VS_Ret_Error = SES_RANGE_ERR };
#else
    enum { VS_Ret_Ok = 0U };
    enum { VS_Ret_Found = 1U };
    enum { VS_Evt_Reset = 0U };
    enum { VS_Ret_Error = 4U };
#endif
#endif
// ------------------------------------------------------------------------

    // Mapping of args passed as hashId to corresponding identifier
    static const ::FeatStd::Char *GetNameFromId(::FeatStd::UInt32 id);

// ------------------------------------------------------------------------
    virtual void Notify_Init_Finished();
    virtual void acNoAction();
    virtual void acActivateMaster();
    virtual void acActivateApplication(::FeatStd::Int32 aSurfaceId, ::FeatStd::Int8 aAppId);
    virtual void acDeactivateApplication(::FeatStd::Int8 aAppId);
    virtual void acRequestSourceFM();
    virtual void acRequestSourceAM();
    virtual void acRequestSourceMedia();
    virtual void acVolumeReq(::FeatStd::Int32 aValue, ::FeatStd::UInt32 aU32RegionID);
    virtual void acMicVolumeReq(::FeatStd::Int32 aValue);
    virtual void acSetCabinVolumeReq(::FeatStd::Int32 aValue);
    virtual void acLastApplicationReq();
    virtual void acStartBeep(::FeatStd::Int8 aBeepType);
    virtual void acRequestHmiSubState();
    virtual void acSwitchBacklight(::FeatStd::Int32 aState);
    virtual void acActivateExternalImageProviderReq(::FeatStd::Int32 aInstanceId, ::FeatStd::Int32 aActivate);
    virtual void acDeactivateExternalImageProviderReq(::FeatStd::Int32 aInstanceId, ::FeatStd::UInt32 aActivate);
    virtual void acMasterCommonButtonVisibleReq(::FeatStd::Int32 aStatus);
    virtual void acMasterAppFlyInButtonVisibleReq(::FeatStd::Int32 aStatus);
    virtual void acReqSpeechSession();
    virtual void acConnect_DisconnectCameraToPluginMsg();
    virtual void acConnectAnalogCameraToPluginMsg(::FeatStd::Int32 aCameraId);
    virtual void acToggleMapOutStatus(::FeatStd::UInt32 aRegionId);
    virtual void acAudio_Active_SourceReqMsg(::FeatStd::Int32 aActiveApp_Index);
    virtual void acConnect_Disconnect_AudioToPluginMsg();
    virtual void acActivateRVC();
    virtual void acDeactivateRVC();
    virtual void acChangeRegion(::FeatStd::Int32 aRegionId);
    virtual void acContextSwitchFromHomeMsg(::FeatStd::Int32 aRegionId, ::FeatStd::Int32 aSourceAppId, ::FeatStd::Int32 aSourceActivityId, ::FeatStd::Int32 aTargetAppId, ::FeatStd::Int32 aTargetActivityId);
    virtual void acContextSwitchWithActiveRegion(::FeatStd::Int32 aSourceAppId, ::FeatStd::Int32 aSourceActivityId, ::FeatStd::Int32 aTargetAppId, ::FeatStd::Int32 aTargetActivityId);
    virtual void acContextSwitchWithLastActiveCabinRegion(::FeatStd::Int32 aSourceAppId, ::FeatStd::Int32 aSourceActivityId, ::FeatStd::Int32 aTargetAppId, ::FeatStd::Int32 aTargetActivityId);
    virtual void acStoreContextSwitchFromHomeMsg(::FeatStd::Int32 aRegionId, ::FeatStd::Int32 aTargetAppId, ::FeatStd::Int32 aTargetActivityId);
    virtual void acHourLogicModeStateMsg(bool aStatus);
    virtual void acActivateMIC(::FeatStd::Int32 aValue, bool aStatus, ::FeatStd::UInt8 aKeyType);
    virtual void acApplicationSwitchCompleteMsg();
    virtual void acActivate_Speech_Msg(::FeatStd::Int32 aValue);
    virtual void acUpdateSPM_HMI_ON();
    virtual void acStartDisclaimerTimerReqMsg();
    virtual void acStopDisclaimerTimerReqMsg();
    virtual void acReqHMIReadVIN();
    virtual void acShowCommonButton();
    virtual void acHideCommonButton();
    virtual void acExecuteCommonButtonActivationRequest(bool aActiveStatus);
    virtual void acEncoderStatusUpdateMsg(::FeatStd::UInt32 aU32EncoderKey, ::FeatStd::Int32 aEncoderSteps);
    virtual void acHKStatusUpdateMsg(::FeatStd::UInt32 aHkCode, ::FeatStd::UInt8 aHkState);
    virtual void acToggleMuteState(::FeatStd::UInt32 aU32RegionID);
    virtual void acPerformSceneStatusUpd(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aActiveStatus);
    virtual void acSetSystemMuteRequest(::FeatStd::UInt32 aRegionId, bool aMuteStatus);
    virtual void acSetHmiStartupMuteRequest(bool aMuteStatus);
    virtual void acControlPanelButtonPressUpdate(::FeatStd::UInt8 aControlPanelButton, ::FeatStd::UInt8 aButtonstate, ::FeatStd::UInt32 aReceiverAppID);
    virtual void acShowAppflyIn();
    virtual void acHideAppFlyIn();
    virtual void acExecuteContextSwitchRequest(::FeatStd::Int32 aRegionId, ::FeatStd::Int32 aSourceAppId, ::FeatStd::Int32 aSourceActivityId, ::FeatStd::Int32 aTargetAppId, ::FeatStd::Int32 aTargetActivityId, ::FeatStd::UInt32 aExecuteCode);
    virtual void acClearLastApplication();
    virtual void acRequestReset();
    virtual void acToggleUserOFF_ON();
    virtual void acHandleSettingsMsg(::FeatStd::UInt32 aRegionId);
    virtual void gacChangeLanguageReq(::FeatStd::Int32 aLanguageId);
    virtual void gacHideFocusInViewReq(::FeatStd::UInt32 aView);
    virtual void NextLevelTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void PreviousLevelTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void DualViewLeftTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void DualViewRightTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void PageFlipBackTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void PageFlipFrontTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void ZoomInTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView, ::FeatStd::Int8 aPos);
    virtual void ZoomOutTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView, ::FeatStd::Int8 aPos);
    virtual void FadeTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void gacWaitAnimationStartReq();
    virtual void acFocusOnRightEncoderReqUpd(bool aIsFocusUsed);
    virtual void acSetGadgetSceenActiveStatus(bool aIsGadgetAtive);
    virtual void acHKNotificationMsg(::FeatStd::Int8 aHKCode, ::FeatStd::Int8 aHKState);
    virtual void acPerform_CloseAllDropdowns();
    virtual void acPerform_CloseDropdown(::FeatStd::UInt32 aListId);
    virtual void acPerform_OpenDropdown(::FeatStd::UInt32 aListId);
    virtual void acPerform_ToggleDropdown(::FeatStd::UInt32 aListId);
    virtual void acStartAppPopupTimer(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aTimeout);
    virtual void acStopAppPopupTimer(::FeatStd::UInt32 aViewId);
    virtual void acPostBeep(::FeatStd::Int8 aBeepType);
    virtual void gacCheckToClosePopup(::FeatStd::UInt32 aPopupId);
    virtual void acRestartAppPopupTimer(::FeatStd::UInt32 aViewId);
    virtual void gacContextSwitchBackRes(::FeatStd::UInt32 aSwitchId);
    virtual void gacContextSwitchCompleteRes(::FeatStd::UInt32 aSwitchId);
    virtual void gacContextSwitchFailedRes(::FeatStd::UInt32 aSwitchId);
    virtual void gacContextSwitchDoneRes(::FeatStd::UInt32 aSwitchId);
    virtual void gacContextSwitchOutReq(::FeatStd::UInt32 aTargetContextId, ::FeatStd::UInt32 aSourceContextId, ::FeatStd::UInt32 aTargetAppId);
    virtual void gacCurrentScreenDisplayReq();
    virtual void gacLaunchBarDisplayReq(bool aVisibility);
    virtual void gacNavTBTSwipe();
    virtual void gacPerformListBtnRightEncoderChangeUpd(::FeatStd::Int8 aSteps, ::FeatStd::UInt32 aListId, ::FeatStd::UInt32 aRowId, ::FeatStd::UInt32 aColumnId);
    virtual void gacScrollListUp();
    virtual void gacScrollListDown();
    virtual void gacScrollPageUp();
    virtual void gacScrollPageDown();
    virtual void gacScrollListFocusUp(::FeatStd::UInt32 aListId);
    virtual void gacScrollListFocusDown(::FeatStd::UInt32 aListId);
    virtual void gacPerformListFocusLockDataResetUpd();
    virtual void gacSetApplicationMode(::FeatStd::UInt32 aModeId);
    virtual void gacSpellerBbehaviorReq(bool aEnable);
    virtual void gacStatusBarDisplayReq(bool aVisibility, ::FeatStd::Int32 aHeaderType);
    virtual void gacTBTRetriggerAcousticOutput();
    virtual void gacWaitAnimationStopReq();
    virtual void gacViewCreateReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewCreateAllReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewDestroyReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewClearReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewShowReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewHideReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewCreateWithoutLoadReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewAsyncLoadReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewActivateWithoutRenderingReq(::FeatStd::UInt32 aViewId);
    virtual void gacPopupCreateAndSBShowReq(::FeatStd::UInt32 aViewId);
    virtual void gacPopupCreateAndSBShowReqForMultiDisplay(::FeatStd::UInt32 aPopupDisplayID, ::FeatStd::UInt32 aViewId);
    virtual void gacPopupSBCloseReq(::FeatStd::UInt32 aViewId);
    virtual void gacPopupSBCloseReqForMultiDisplay(::FeatStd::UInt32 aPopupDisplayID, ::FeatStd::UInt32 aViewId);
    virtual void gacPopupRestartTimerReq(::FeatStd::UInt32 aViewId);
    virtual void gacPopupRestartTimerReqForMultiDisplay(::FeatStd::UInt32 aPopupDisplayID, ::FeatStd::UInt32 aViewId);
    virtual void gacViewCreateAndShowReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewHideAndDestroyReq(::FeatStd::UInt32 aViewId);
    virtual void gacSceneTransitionEnter(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aHint);
    virtual void gacSceneTransitionLeave(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aHint);
    virtual void gacDisplayStatusLineReq(::FeatStd::Int32 aDisplayRegionType);
    virtual void gacHideStatusLineReq(::FeatStd::Int32 aDisplayRegionType);
    virtual void gacDisplayFooterLineReq();
    virtual void gacHideFooterLineReq();
    virtual void gacDisplayStatusLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID);
    virtual void gacHideStatusLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID);
    virtual void gacDisplayFooterLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID);
    virtual void gacHideFooterLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID);
    virtual void gacRegisterForCloseOnTouchSession(::FeatStd::UInt32 aViewId);
    virtual void gacDeregisterForCloseOnTouchSessionReq(::FeatStd::UInt32 aViewId);
    virtual void gacPopupFilterPrioEnableReq(::FeatStd::UInt32 aPrio);
    virtual void gacPopupFilterAllEnableReq();
    virtual void gacPopupFilterDisableReq();
    virtual void gacProfileChange(::FeatStd::Int8 aProfile);
    virtual void gacPopupFilterPrioEnableReqForDisplay(::FeatStd::UInt32 aPrio, ::FeatStd::UInt32 aDisplayID);
    virtual void gacPopupFilterAllEnableReqForDisplay(::FeatStd::UInt32 aDisplayID);
    virtual void gacPopupFilterDisableReqForDisplay(::FeatStd::UInt32 aDisplayID);
    virtual void gacStartSceneTransitionAnimation(::FeatStd::UInt32 aSourceView, ::FeatStd::UInt32 aDestinationView, ::FeatStd::UInt32 aUserData1, ::FeatStd::Int8 aUserData2);
    virtual void gacDecrementActiveAnimationCount();

// ------------------------------------------------------------------------
    virtual bool fnIsInf4cvSmartVariant();
    virtual ::FeatStd::UInt32 fnGetRegionId();
    virtual ::FeatStd::UInt32 fnGetLastActiveCabinRegionId();
    virtual ::FeatStd::UInt32 fnGetAudioSinkId();
    virtual ::FeatStd::UInt32 fnGetRegionIdForAudioSink(::FeatStd::UInt32 aSinkId);
    virtual ::FeatStd::UInt32 fnGetAudioSinkIdForRegion(::FeatStd::UInt32 aRegionId);
    virtual bool fnIsRegionSupported(::FeatStd::UInt32 aRegionId);
    virtual ::FeatStd::UInt32 fnGetApplicationId(::FeatStd::UInt32 aSurfaceId);
    virtual ::FeatStd::UInt16 fnGetVariantId();
    virtual ::FeatStd::UInt16 fnGetVariantType();
    virtual bool fnIsAVRoutingAdaperXMLAvailable();

#ifdef CIT_SIMULATION
    bool CallAction(const ::FeatStd::Char* actionName, const ::Json::Value& parameters, ::Json::Value &response);
    const ::FeatStd::Char* GetEventName(::FeatStd::UInt32 eventId, ::Courier::Message const & message, Json::Value& eventArgument);
#endif
    // Added function for deduction of one event to simplify the event loop
    bool HandleDataBindingEventMapping(::Courier::AbstractDataItemMsg const & message, ::FeatStd::UInt32& eventId) const;
    bool HandleEventMapping(::Courier::Message const & message, ::FeatStd::UInt32& eventId) const;

    ::Cit::DeductResult::Enum DeductEvent(::Courier::Message const & message, ::FeatStd::UInt32 eventId);

    //====  member function with TTFis output - added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====

	virtual unsigned short GetTraceClass();
	int GetNumberOfStatemachines();
    //====  member function with TTFis output - end                        key: SM_TTFis_SBHFMSRF ====
};

// ------------------------------------------------------------------------
bool SendGuiStartupFinishedUpdMsg();
bool SendNotifierMessage();
bool SendActivateMasterApplicationReqMsg(Courier::UInt8 const & aDisplayStatus);
bool SendActivateApplicationReqMsg(Courier::Int32 const & aAppId, Courier::UInt32 const & aSurfaceId, Courier::UInt8 const & aDisplayStatus);
bool SendEnableConnectionReqMsg(AudioConnectionRequest::Enum const & aRequestId, Courier::Int32 const & aUserData1, Courier::Int32 const & aUserData2, Courier::Int32 const & aUserData3, Courier::Int32 const & aUserData4);
bool SendSetVolumeReqMsg(Courier::Int32 const & aValue, Courier::UInt32 const & aU32RegionID);
bool SendSetMicVolumeReqMsg(Courier::Int32 const & aValue);
bool SendSetCabinVolumeReqMsg(Courier::Int32 const & aValue);
bool SendStartBeepReqMsg(Courier::Int32 const & aBeepType);
bool SendChangeHmiSubStateReqMsg();
bool SendSwitchBacklightReqMsg(Courier::Int32 const & aState);
bool SendExternalImageProviderReqMsg(Courier::Int32 const & aInstanceId, bool const & aActivate, hmibase::gadget::gadgetSceneStatus const & aTargetState);
bool SendSubSurfaceVisibleMsg(Candera::String const & aApplicationName, hmibase::displayRegion const & aDisplayRegion, Courier::UInt32 const & aDisplayID, Courier::UInt32 const & aStatus);
bool SendReqSpeechSessionMsg();
bool SendConnect_DisconnectCameraToPluginMsg();
bool SendConnectAnalogCameraToPluginMsg(Courier::UInt32 const & aCameraId);
bool SendToggleMapOutStatus(Courier::Int32 const & aRegionId);
bool SendAudio_Active_SourceReqMsg(Courier::Int32 const & aActiveApp_Index);
bool SendConnect_DisconnectAudioToPluginMsg();
bool SendShowHideRVCSceneMsg(bool const & aShowhide);
bool SendChangeRegionMsg(Courier::UInt32 const & aRegionId);
bool SendContextSwitchFromHomeMsg(Courier::Int32 const & aRegionId, Courier::Int32 const & aSourceAppId, Courier::Int32 const & aSourceActivityId, Courier::Int32 const & aTargetAppId, Courier::Int32 const & aTargetActivityId);
bool SendStoreContextSwitchFromHomeMsg(Courier::Int32 const & aRegionId, Courier::Int32 const & aTargetAppId, Courier::Int32 const & aTargetActivityId);
bool SendHourLogicModeStateMsg(bool const & aStatus);
bool SendActivateMIC(Courier::Int32 const & aValue, bool const & aStatus, Courier::UInt8 const & aKeyType);
bool SendApplicationSwitchCompleteMsg();
bool SendActivate_Speech_Msg(Courier::Int32 const & aValue);
bool SendUpdateSPM_HMI_ON();
bool SendStartDisclaimerTimerReqMsg();
bool SendStopDisclaimerTimerReqMsg();
bool SendReqHMIReadVIN();
bool SendCommonButtonVisibleStatusUpdMsg(bool const & aVisibleStatus);
bool SendExecuteCommonButtonActivationRequestMsg(bool const & aActiveStatus);
bool SendEncoderStatusUpdateMsg(Courier::UInt32 const & aU32EncoderKey, Courier::Int32 const & aEncoderSteps);
bool SendHKStatusUpdateMsg(Courier::UInt32 const & aHkCode, Courier::UInt8 const & aHkState);
bool SendToggleMuteStateReqMsg(Courier::UInt32 const & aU32RegionID);
bool SendSceneStatusInfoMsg(Courier::UInt32 const & aViewId, Courier::UInt32 const & aActiveStatus);
bool SendSetSystemMuteReqMsg(Courier::UInt32 const & aRegionId, bool const & aMuteStatus);
bool SendSetHmiStartupMuteRequest(bool const & aMuteStatus);
bool SendControlPanelButtonPressUpdate(Courier::UInt8 const & aControlPanelButton, Courier::UInt8 const & aButtonstate, Courier::UInt32 const & aReceiverAppID);
bool SendAppFlyInActivationReqMsg(bool const & aActivationStatus);
bool SendExecuteContextSwitchRequestMsg(Courier::Int32 const & aRegionId, Courier::Int32 const & aSourceAppId, Courier::Int32 const & aSourceActivityId, Courier::Int32 const & aTargetAppId, Courier::Int32 const & aTargetActivityId, Courier::UInt32 const & aExecuteCode);
bool SendClearLastApplication();
bool SendFaciaON_OFF_Btn_ResetReqMsg();
bool SendFaciaON_OFF_Btn_ShutDownReqMsg();
bool SendHandleSettingsMsg(Courier::UInt32 const & aRegionId);
bool SendChangeLanguageReqMsg(enLanguageId const & aLanguageId);
bool SendFocusReqMsg(FocusActionEnum const & aAction, FocusTimerActionEnum const & aTimerAction, ::Courier::ViewId const & aView, Candera::String const & aWidget);
bool SendDummyMess(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos);
bool SendAnimationReqMsg(Courier::AnimationAction::Enum const & aAnimationAction, ::Courier::ViewId const & aViewId, Courier::CompositePath const & aCompositePath, ::Courier::ItemId const & aAnimationId, Courier::AnimationProperties const & aAnimationProperties);
bool SendFocusOnRightEncoderReqUpdMsg(bool const & aIsFocusUsed);
bool SendStoreActiveGadgetReqMsg(bool const & aIsGadgetAtive);
bool SendHardKeyPressNotificationMsg(Courier::UInt8 const & aDummy, Courier::UInt8 const & aHKCode, Courier::UInt8 const & aHKState);
bool SendDropdownChangeMsg(::Candera::DropdownChangeType const & aDropdownChangeType, ::Courier::UInt32 const & aListId);
bool SendStartPopupTimerReqMsg(Courier::UInt32 const & aViewId, Courier::UInt32 const & aTimeout);
bool SendStopPopupTimerReqMsg(Courier::UInt32 const & aViewId);
bool SendPlayBeepReqMsg(Courier::Int32 const & aBeepType);
bool SendCheckToClosePopupMsg(Courier::UInt32 const & aPopupId);
bool SendRestartPopupTimerReqMsg(Courier::UInt32 const & aViewId);
bool SendContextSwitchInResMsg(Courier::UInt32 const & aSwitchId, Courier::UInt32 const & aResponseType);
bool SendContextSwitchOutReqMsg(Courier::UInt32 const & aTargetContextId, Courier::UInt32 const & aSourceContextId, Courier::UInt32 const & aTargetAppId);
bool SendCurrentScreenDisplayReqMsg();
bool SendLaunchBarDisplayReqMsg(bool const & aVisibility);
bool SendNavTBTSwipeReqMsg();
bool SendListItemRightEncoderChangeUpdMsg(Courier::Int8 const & aSteps, Courier::UInt32 const & aListId, Courier::UInt32 const & aRowId, Courier::UInt32 const & aColumnId);
bool SendListChangeMsg(::Courier::UInt32 const & aListId, ListChangeType const & aListChangeType, ::Courier::Int32 const & aValue, ListChangeMsgSourceType const & aListChangeMsgSource, bool const & aImmediatePositioning);
bool SendListFocusScrollReqMsg(Courier::UInt32 const & aListId, Courier::Int32 const & aSteps);
bool SendListFocusLockDataResetReqMsg();
bool SendSetApplicationModeReqMsg(Courier::UInt32 const & aModeId);
bool SendSpellerBbehaviorReqMsg(bool const & aEnable);
bool SendStatusBarDisplayReqMsg(bool const & aVisibility, Courier::Int32 const & aHeaderType);
bool SendTBTRetriggerAcousticMsg();
bool SendViewReqMsg(Courier::ViewAction::Enum const & aViewAction, ::Courier::ViewId const & aViewId, bool const & aShallInitScene, bool const & aShallLoadScene);
bool SendActivationReqMsg(::Courier::ViewId const & aViewId, bool const & aActivation, bool const & aEnableRendering);
bool SendAsyncLoadReqMsg(::Courier::ViewId const & aViewId, bool const & aLoad);
bool SendPopupReqMsg(hmibase::popups::CommandEnum const & aCommand, ::Courier::ViewId const & aViewId, Courier::UInt32 const & aPopupDisplayID);
bool SendExtendedViewReqMsg(hmibase::views::CommandEnum const & aCommand, ::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint);
bool SendShowHMISubSurfaceReqMsg(hmibase::displayRegion const & aDisplayRegion, Courier::Int32 const & aDisplayRegionType, bool const & aShowSubSurface, Courier::UInt32 const & aDisplayID, bool const & aLockSubSurface);
bool SendRegisterForCloseOnTouchSessionReqMsg(bool const & aRegister, ::Courier::ViewId const & aViewId);
bool SendPopupFilterPrioEnableReqMsg(Courier::UInt32 const & aPrio);
bool SendPopupFilterAllEnableReqMsg();
bool SendPopupFilterDisableReqMsg();
bool SendProfileSwitchMsg(Courier::UInt32 const & aProfile);
bool SendMultiDisplayPopupFilterReqMsg(hmibase::PopupFilterType const & aPopupFilterType, Courier::UInt32 const & aPrio, Courier::UInt32 const & aDisplayID);
bool SendCreateNewDestroyOld(::Courier::ViewId const & aSourceView, ::Courier::ViewId const & aDestinationView, Courier::UInt32 const & aUserData1, Courier::Int8 const & aUserData2);

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Notify_Init_Finished(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Notify_Init_Finished();
#ifdef CIT_SIMULATION
bool CallAction_acNoAction(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acNoAction();
#ifdef CIT_SIMULATION
bool CallAction_acActivateMaster(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acActivateMaster();
#ifdef CIT_SIMULATION
bool CallAction_acActivateApplication(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acActivateApplication(Courier::UInt32 const & aSurfaceId, Courier::Int32 const & aAppId);
#ifdef CIT_SIMULATION
bool CallAction_acDeactivateApplication(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acDeactivateApplication(Courier::Int32 const & aAppId);
#ifdef CIT_SIMULATION
bool CallAction_acRequestSourceFM(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acRequestSourceFM();
#ifdef CIT_SIMULATION
bool CallAction_acRequestSourceAM(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acRequestSourceAM();
#ifdef CIT_SIMULATION
bool CallAction_acRequestSourceMedia(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acRequestSourceMedia();
#ifdef CIT_SIMULATION
bool CallAction_acVolumeReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acVolumeReq(Courier::Int32 const & aValue, Courier::UInt32 const & aU32RegionID);
#ifdef CIT_SIMULATION
bool CallAction_acMicVolumeReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acMicVolumeReq(Courier::Int32 const & aValue);
#ifdef CIT_SIMULATION
bool CallAction_acSetCabinVolumeReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSetCabinVolumeReq(Courier::Int32 const & aValue);
#ifdef CIT_SIMULATION
bool CallAction_acLastApplicationReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acLastApplicationReq();
#ifdef CIT_SIMULATION
bool CallAction_acStartBeep(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acStartBeep(Courier::Int32 const & aBeepType);
#ifdef CIT_SIMULATION
bool CallAction_acRequestHmiSubState(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acRequestHmiSubState();
#ifdef CIT_SIMULATION
bool CallAction_acSwitchBacklight(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSwitchBacklight(Courier::Int32 const & aState);
#ifdef CIT_SIMULATION
bool CallAction_acActivateExternalImageProviderReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acActivateExternalImageProviderReq(Courier::Int32 const & aInstanceId, bool const & aActivate);
#ifdef CIT_SIMULATION
bool CallAction_acDeactivateExternalImageProviderReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acDeactivateExternalImageProviderReq(Courier::Int32 const & aInstanceId, bool const & aActivate);
#ifdef CIT_SIMULATION
bool CallAction_acMasterCommonButtonVisibleReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acMasterCommonButtonVisibleReq(Courier::UInt32 const & aStatus);
#ifdef CIT_SIMULATION
bool CallAction_acMasterAppFlyInButtonVisibleReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acMasterAppFlyInButtonVisibleReq(Courier::UInt32 const & aStatus);
#ifdef CIT_SIMULATION
bool CallAction_acReqSpeechSession(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acReqSpeechSession();
#ifdef CIT_SIMULATION
bool CallAction_acConnect_DisconnectCameraToPluginMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acConnect_DisconnectCameraToPluginMsg();
#ifdef CIT_SIMULATION
bool CallAction_acConnectAnalogCameraToPluginMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acConnectAnalogCameraToPluginMsg(Courier::UInt32 const & aCameraId);
#ifdef CIT_SIMULATION
bool CallAction_acToggleMapOutStatus(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acToggleMapOutStatus(Courier::Int32 const & aRegionId);
#ifdef CIT_SIMULATION
bool CallAction_acAudio_Active_SourceReqMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acAudio_Active_SourceReqMsg(Courier::Int32 const & aActiveApp_Index);
#ifdef CIT_SIMULATION
bool CallAction_acConnect_Disconnect_AudioToPluginMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acConnect_Disconnect_AudioToPluginMsg();
#ifdef CIT_SIMULATION
bool CallAction_acActivateRVC(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acActivateRVC();
#ifdef CIT_SIMULATION
bool CallAction_acDeactivateRVC(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acDeactivateRVC();
#ifdef CIT_SIMULATION
bool CallAction_acChangeRegion(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acChangeRegion(Courier::UInt32 const & aRegionId);
#ifdef CIT_SIMULATION
bool CallAction_acContextSwitchFromHomeMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acContextSwitchFromHomeMsg(Courier::Int32 const & aRegionId, Courier::Int32 const & aSourceAppId, Courier::Int32 const & aSourceActivityId, Courier::Int32 const & aTargetAppId, Courier::Int32 const & aTargetActivityId);
#ifdef CIT_SIMULATION
bool CallAction_acContextSwitchWithActiveRegion(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acContextSwitchWithActiveRegion(Courier::Int32 const & aSourceAppId, Courier::Int32 const & aSourceActivityId, Courier::Int32 const & aTargetAppId, Courier::Int32 const & aTargetActivityId);
#ifdef CIT_SIMULATION
bool CallAction_acContextSwitchWithLastActiveCabinRegion(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acContextSwitchWithLastActiveCabinRegion(Courier::Int32 const & aSourceAppId, Courier::Int32 const & aSourceActivityId, Courier::Int32 const & aTargetAppId, Courier::Int32 const & aTargetActivityId);
#ifdef CIT_SIMULATION
bool CallAction_acStoreContextSwitchFromHomeMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acStoreContextSwitchFromHomeMsg(Courier::Int32 const & aRegionId, Courier::Int32 const & aTargetAppId, Courier::Int32 const & aTargetActivityId);
#ifdef CIT_SIMULATION
bool CallAction_acHourLogicModeStateMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acHourLogicModeStateMsg(bool const & aStatus);
#ifdef CIT_SIMULATION
bool CallAction_acActivateMIC(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acActivateMIC(Courier::Int32 const & aValue, bool const & aStatus, Courier::UInt8 const & aKeyType);
#ifdef CIT_SIMULATION
bool CallAction_acApplicationSwitchCompleteMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acApplicationSwitchCompleteMsg();
#ifdef CIT_SIMULATION
bool CallAction_acActivate_Speech_Msg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acActivate_Speech_Msg(Courier::Int32 const & aValue);
#ifdef CIT_SIMULATION
bool CallAction_acUpdateSPM_HMI_ON(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acUpdateSPM_HMI_ON();
#ifdef CIT_SIMULATION
bool CallAction_acStartDisclaimerTimerReqMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acStartDisclaimerTimerReqMsg();
#ifdef CIT_SIMULATION
bool CallAction_acStopDisclaimerTimerReqMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acStopDisclaimerTimerReqMsg();
#ifdef CIT_SIMULATION
bool CallAction_acReqHMIReadVIN(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acReqHMIReadVIN();
#ifdef CIT_SIMULATION
bool CallAction_acShowCommonButton(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acShowCommonButton();
#ifdef CIT_SIMULATION
bool CallAction_acHideCommonButton(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acHideCommonButton();
#ifdef CIT_SIMULATION
bool CallAction_acExecuteCommonButtonActivationRequest(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acExecuteCommonButtonActivationRequest(bool const & aActiveStatus);
#ifdef CIT_SIMULATION
bool CallAction_acEncoderStatusUpdateMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acEncoderStatusUpdateMsg(Courier::UInt32 const & aU32EncoderKey, Courier::Int32 const & aEncoderSteps);
#ifdef CIT_SIMULATION
bool CallAction_acHKStatusUpdateMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acHKStatusUpdateMsg(Courier::UInt32 const & aHkCode, Courier::UInt8 const & aHkState);
#ifdef CIT_SIMULATION
bool CallAction_acToggleMuteState(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acToggleMuteState(Courier::UInt32 const & aU32RegionID);
#ifdef CIT_SIMULATION
bool CallAction_acPerformSceneStatusUpd(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPerformSceneStatusUpd(Courier::UInt32 const & aViewId, Courier::UInt32 const & aActiveStatus);
#ifdef CIT_SIMULATION
bool CallAction_acSetSystemMuteRequest(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSetSystemMuteRequest(Courier::UInt32 const & aRegionId, bool const & aMuteStatus);
#ifdef CIT_SIMULATION
bool CallAction_acSetHmiStartupMuteRequest(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSetHmiStartupMuteRequest(bool const & aMuteStatus);
#ifdef CIT_SIMULATION
bool CallAction_acControlPanelButtonPressUpdate(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acControlPanelButtonPressUpdate(Courier::UInt8 const & aControlPanelButton, Courier::UInt8 const & aButtonstate, Courier::UInt32 const & aReceiverAppID);
#ifdef CIT_SIMULATION
bool CallAction_acShowAppflyIn(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acShowAppflyIn();
#ifdef CIT_SIMULATION
bool CallAction_acHideAppFlyIn(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acHideAppFlyIn();
#ifdef CIT_SIMULATION
bool CallAction_acExecuteContextSwitchRequest(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acExecuteContextSwitchRequest(Courier::Int32 const & aRegionId, Courier::Int32 const & aSourceAppId, Courier::Int32 const & aSourceActivityId, Courier::Int32 const & aTargetAppId, Courier::Int32 const & aTargetActivityId, Courier::UInt32 const & aExecuteCode);
#ifdef CIT_SIMULATION
bool CallAction_acClearLastApplication(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acClearLastApplication();
#ifdef CIT_SIMULATION
bool CallAction_acRequestReset(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acRequestReset();
#ifdef CIT_SIMULATION
bool CallAction_acToggleUserOFF_ON(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acToggleUserOFF_ON();
#ifdef CIT_SIMULATION
bool CallAction_acHandleSettingsMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acHandleSettingsMsg(Courier::UInt32 const & aRegionId);
#ifdef CIT_SIMULATION
bool CallAction_gacChangeLanguageReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacChangeLanguageReq(enLanguageId const & aLanguageId);
#ifdef CIT_SIMULATION
bool CallAction_gacHideFocusInViewReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacHideFocusInViewReq(::Courier::ViewId const & aView);
#ifdef CIT_SIMULATION
bool CallAction_NextLevelTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_NextLevelTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_PreviousLevelTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_PreviousLevelTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_DualViewLeftTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_DualViewLeftTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_DualViewRightTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_DualViewRightTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_PageFlipBackTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_PageFlipBackTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_PageFlipFrontTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_PageFlipFrontTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_ZoomInTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_ZoomInTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos);
#ifdef CIT_SIMULATION
bool CallAction_ZoomOutTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_ZoomOutTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos);
#ifdef CIT_SIMULATION
bool CallAction_FadeTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_FadeTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_gacWaitAnimationStartReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacWaitAnimationStartReq();
#ifdef CIT_SIMULATION
bool CallAction_acFocusOnRightEncoderReqUpd(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acFocusOnRightEncoderReqUpd(bool const & aIsFocusUsed);
#ifdef CIT_SIMULATION
bool CallAction_acSetGadgetSceenActiveStatus(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSetGadgetSceenActiveStatus(bool const & aIsGadgetAtive);
#ifdef CIT_SIMULATION
bool CallAction_acHKNotificationMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acHKNotificationMsg(Courier::UInt8 const & aHKCode, Courier::UInt8 const & aHKState);
#ifdef CIT_SIMULATION
bool CallAction_acPerform_CloseAllDropdowns(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPerform_CloseAllDropdowns();
#ifdef CIT_SIMULATION
bool CallAction_acPerform_CloseDropdown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPerform_CloseDropdown(::Courier::UInt32 const & aListId);
#ifdef CIT_SIMULATION
bool CallAction_acPerform_OpenDropdown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPerform_OpenDropdown(::Courier::UInt32 const & aListId);
#ifdef CIT_SIMULATION
bool CallAction_acPerform_ToggleDropdown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPerform_ToggleDropdown(::Courier::UInt32 const & aListId);
#ifdef CIT_SIMULATION
bool CallAction_acStartAppPopupTimer(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acStartAppPopupTimer(Courier::UInt32 const & aViewId, Courier::UInt32 const & aTimeout);
#ifdef CIT_SIMULATION
bool CallAction_acStopAppPopupTimer(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acStopAppPopupTimer(Courier::UInt32 const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_acPostBeep(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPostBeep(Courier::Int32 const & aBeepType);
#ifdef CIT_SIMULATION
bool CallAction_gacCheckToClosePopup(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacCheckToClosePopup(Courier::UInt32 const & aPopupId);
#ifdef CIT_SIMULATION
bool CallAction_acRestartAppPopupTimer(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acRestartAppPopupTimer(Courier::UInt32 const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchBackRes(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacContextSwitchBackRes(Courier::UInt32 const & aSwitchId);
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchCompleteRes(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacContextSwitchCompleteRes(Courier::UInt32 const & aSwitchId);
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchFailedRes(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacContextSwitchFailedRes(Courier::UInt32 const & aSwitchId);
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchDoneRes(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacContextSwitchDoneRes(Courier::UInt32 const & aSwitchId);
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchOutReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacContextSwitchOutReq(Courier::UInt32 const & aTargetContextId, Courier::UInt32 const & aSourceContextId, Courier::UInt32 const & aTargetAppId);
#ifdef CIT_SIMULATION
bool CallAction_gacCurrentScreenDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacCurrentScreenDisplayReq();
#ifdef CIT_SIMULATION
bool CallAction_gacLaunchBarDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacLaunchBarDisplayReq(bool const & aVisibility);
#ifdef CIT_SIMULATION
bool CallAction_gacNavTBTSwipe(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacNavTBTSwipe();
#ifdef CIT_SIMULATION
bool CallAction_gacPerformListBtnRightEncoderChangeUpd(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPerformListBtnRightEncoderChangeUpd(Courier::Int8 const & aSteps, Courier::UInt32 const & aListId, Courier::UInt32 const & aRowId, Courier::UInt32 const & aColumnId);
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListUp(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollListUp();
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListDown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollListDown();
#ifdef CIT_SIMULATION
bool CallAction_gacScrollPageUp(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollPageUp();
#ifdef CIT_SIMULATION
bool CallAction_gacScrollPageDown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollPageDown();
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListFocusUp(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollListFocusUp(Courier::UInt32 const & aListId);
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListFocusDown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollListFocusDown(Courier::UInt32 const & aListId);
#ifdef CIT_SIMULATION
bool CallAction_gacPerformListFocusLockDataResetUpd(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPerformListFocusLockDataResetUpd();
#ifdef CIT_SIMULATION
bool CallAction_gacSetApplicationMode(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacSetApplicationMode(Courier::UInt32 const & aModeId);
#ifdef CIT_SIMULATION
bool CallAction_gacSpellerBbehaviorReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacSpellerBbehaviorReq(bool const & aEnable);
#ifdef CIT_SIMULATION
bool CallAction_gacStatusBarDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacStatusBarDisplayReq(bool const & aVisibility, Courier::Int32 const & aHeaderType);
#ifdef CIT_SIMULATION
bool CallAction_gacTBTRetriggerAcousticOutput(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacTBTRetriggerAcousticOutput();
#ifdef CIT_SIMULATION
bool CallAction_gacWaitAnimationStopReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacWaitAnimationStopReq();
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewCreateReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateAllReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewCreateAllReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewDestroyReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewDestroyReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewClearReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewClearReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewShowReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewShowReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewHideReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewHideReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateWithoutLoadReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewCreateWithoutLoadReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewAsyncLoadReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewAsyncLoadReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewActivateWithoutRenderingReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewActivateWithoutRenderingReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupCreateAndSBShowReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupCreateAndSBShowReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupCreateAndSBShowReqForMultiDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupCreateAndSBShowReqForMultiDisplay(Courier::UInt32 const & aPopupDisplayID, ::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupSBCloseReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupSBCloseReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupSBCloseReqForMultiDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupSBCloseReqForMultiDisplay(Courier::UInt32 const & aPopupDisplayID, ::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupRestartTimerReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupRestartTimerReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupRestartTimerReqForMultiDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupRestartTimerReqForMultiDisplay(Courier::UInt32 const & aPopupDisplayID, ::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateAndShowReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewCreateAndShowReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewHideAndDestroyReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewHideAndDestroyReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacSceneTransitionEnter(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacSceneTransitionEnter(::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint);
#ifdef CIT_SIMULATION
bool CallAction_gacSceneTransitionLeave(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacSceneTransitionLeave(::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint);
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayStatusLineReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDisplayStatusLineReq(Courier::Int32 const & aDisplayRegionType);
#ifdef CIT_SIMULATION
bool CallAction_gacHideStatusLineReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacHideStatusLineReq(Courier::Int32 const & aDisplayRegionType);
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayFooterLineReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDisplayFooterLineReq();
#ifdef CIT_SIMULATION
bool CallAction_gacHideFooterLineReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacHideFooterLineReq();
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayStatusLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDisplayStatusLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacHideStatusLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacHideStatusLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayFooterLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDisplayFooterLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacHideFooterLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacHideFooterLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacRegisterForCloseOnTouchSession(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacRegisterForCloseOnTouchSession(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacDeregisterForCloseOnTouchSessionReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDeregisterForCloseOnTouchSessionReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterPrioEnableReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterPrioEnableReq(Courier::UInt32 const & aPrio);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterAllEnableReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterAllEnableReq();
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterDisableReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterDisableReq();
#ifdef CIT_SIMULATION
bool CallAction_gacProfileChange(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacProfileChange(Courier::UInt32 const & aProfile);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterPrioEnableReqForDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterPrioEnableReqForDisplay(Courier::UInt32 const & aPrio, Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterAllEnableReqForDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterAllEnableReqForDisplay(Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterDisableReqForDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterDisableReqForDisplay(Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacStartSceneTransitionAnimation(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacStartSceneTransitionAnimation(::Courier::ViewId const & aSourceView, ::Courier::ViewId const & aDestinationView, Courier::UInt32 const & aUserData1, Courier::Int8 const & aUserData2);
#ifdef CIT_SIMULATION
bool CallAction_gacDecrementActiveAnimationCount(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDecrementActiveAnimationCount();

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_fnIsInf4cvSmartVariant(const ::Json::Value& parameters, ::Json::Value &response);
#endif
bool fnIsInf4cvSmartVariant();
#ifdef CIT_SIMULATION
bool CallAction_fnGetRegionId(const ::Json::Value& parameters, ::Json::Value &response);
#endif
::FeatStd::UInt32 fnGetRegionId();
#ifdef CIT_SIMULATION
bool CallAction_fnGetLastActiveCabinRegionId(const ::Json::Value& parameters, ::Json::Value &response);
#endif
::FeatStd::UInt32 fnGetLastActiveCabinRegionId();
#ifdef CIT_SIMULATION
bool CallAction_fnGetAudioSinkId(const ::Json::Value& parameters, ::Json::Value &response);
#endif
::FeatStd::UInt32 fnGetAudioSinkId();
#ifdef CIT_SIMULATION
bool CallAction_fnGetRegionIdForAudioSink(const ::Json::Value& parameters, ::Json::Value &response);
#endif
::FeatStd::UInt32 fnGetRegionIdForAudioSink(::FeatStd::UInt32 aSinkId);
#ifdef CIT_SIMULATION
bool CallAction_fnGetAudioSinkIdForRegion(const ::Json::Value& parameters, ::Json::Value &response);
#endif
::FeatStd::UInt32 fnGetAudioSinkIdForRegion(::FeatStd::UInt32 aRegionId);
#ifdef CIT_SIMULATION
bool CallAction_fnIsRegionSupported(const ::Json::Value& parameters, ::Json::Value &response);
#endif
bool fnIsRegionSupported(::FeatStd::UInt32 aRegionId);
#ifdef CIT_SIMULATION
bool CallAction_fnGetApplicationId(const ::Json::Value& parameters, ::Json::Value &response);
#endif
::FeatStd::UInt32 fnGetApplicationId(::FeatStd::UInt32 aSurfaceId);
#ifdef CIT_SIMULATION
bool CallAction_fnGetVariantId(const ::Json::Value& parameters, ::Json::Value &response);
#endif
::FeatStd::UInt16 fnGetVariantId();
#ifdef CIT_SIMULATION
bool CallAction_fnGetVariantType(const ::Json::Value& parameters, ::Json::Value &response);
#endif
::FeatStd::UInt16 fnGetVariantType();
#ifdef CIT_SIMULATION
bool CallAction_fnIsAVRoutingAdaperXMLAvailable(const ::Json::Value& parameters, ::Json::Value &response);
#endif
bool fnIsAVRoutingAdaperXMLAvailable();

// overall number of HierarchyNodes
static const ::FeatStd::UInt32 cGlobalDataItemHierarchyNodeCount = 84;
// overall number of DataItemDescriptor nodes
static const ::FeatStd::UInt32 cDataItemDescriptorCount = 84;
// overall number of BindingSources
static const ::FeatStd::UInt32 cBindingSourceCount = 17;
// maximum number of HierarchyNodes in a BindingSource
static const ::FeatStd::UInt32 cBindingSourceItemCountMax = 22;

// =========================================================================

class VolumeInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 9;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 1;
    static const ::Courier::DataItemKey cDataItemKey = 35;

    typedef ::VolumeInfoData Data;

    VolumeInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< VolumeInfoDataBindingSource > VolumeInfoDataItemMsg;

// =========================================================================

class VolumeBarInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 7;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 2;
    static const ::Courier::DataItemKey cDataItemKey = 77;

    typedef ::VolumeBarInfoData Data;

    VolumeBarInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< VolumeBarInfoDataBindingSource > VolumeBarInfoDataItemMsg;

// =========================================================================

class AppFlyInListInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 5;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 3;
    static const ::Courier::DataItemKey cDataItemKey = 5;

    typedef ::AppFlyInListInfoData Data;

    AppFlyInListInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< AppFlyInListInfoDataBindingSource > AppFlyInListInfoDataItemMsg;

// =========================================================================

class SystemMuteInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 4;
    static const ::Courier::DataItemKey cDataItemKey = 13;

    typedef ::SystemMuteInfoData Data;

    SystemMuteInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< SystemMuteInfoDataBindingSource > SystemMuteInfoDataItemMsg;

// =========================================================================

class MmiModeDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 5;
    static const ::Courier::DataItemKey cDataItemKey = 22;

    typedef ::MmiModeData Data;

    MmiModeDataBindingSource();
};

typedef ::Courier::DataItemMsg< MmiModeDataBindingSource > MmiModeDataItemMsg;

// =========================================================================

class KDSStatusInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 6;
    static const ::Courier::DataItemKey cDataItemKey = 49;

    typedef ::KDSStatusInfoData Data;

    KDSStatusInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< KDSStatusInfoDataBindingSource > KDSStatusInfoDataItemMsg;

// =========================================================================

class StartupMsgInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 7;
    static const ::Courier::DataItemKey cDataItemKey = 38;

    typedef ::StartupMsgInfoData Data;

    StartupMsgInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< StartupMsgInfoDataBindingSource > StartupMsgInfoDataItemMsg;

// =========================================================================

class ControlPanelInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 8;
    static const ::Courier::DataItemKey cDataItemKey = 61;

    typedef ::ControlPanelInfoData Data;

    ControlPanelInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< ControlPanelInfoDataBindingSource > ControlPanelInfoDataItemMsg;

// =========================================================================

class CockpitCabinContextDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 9;
    static const ::Courier::DataItemKey cDataItemKey = 67;

    typedef ::CockpitCabinContextData Data;

    CockpitCabinContextDataBindingSource();
};

typedef ::Courier::DataItemMsg< CockpitCabinContextDataBindingSource > CockpitCabinContextDataItemMsg;

// =========================================================================

class WidgetControllersDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 6;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 10;
    static const ::Courier::DataItemKey cDataItemKey = 81;

    typedef ::WidgetControllersData Data;

    WidgetControllersDataBindingSource();
};

typedef ::Courier::DataItemMsg< WidgetControllersDataBindingSource > WidgetControllersDataItemMsg;

// =========================================================================

class SourceListItemInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 6;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 11;
    static const ::Courier::DataItemKey cDataItemKey = 43;

    typedef ::SourceListItemInfoData Data;

    SourceListItemInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< SourceListItemInfoDataBindingSource > SourceListItemInfoDataItemMsg;

// =========================================================================

class MIC1VolumeInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 12;
    static const ::Courier::DataItemKey cDataItemKey = 55;

    typedef ::MIC1VolumeInfoData Data;

    MIC1VolumeInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< MIC1VolumeInfoDataBindingSource > MIC1VolumeInfoDataItemMsg;

// =========================================================================

class Mic1KeyInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 13;
    static const ::Courier::DataItemKey cDataItemKey = 59;

    typedef ::Mic1KeyInfoData Data;

    Mic1KeyInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< Mic1KeyInfoDataBindingSource > Mic1KeyInfoDataItemMsg;

// =========================================================================

class MicCabinStatusDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 14;
    static const ::Courier::DataItemKey cDataItemKey = 74;

    typedef ::MicCabinStatusData Data;

    MicCabinStatusDataBindingSource();
};

typedef ::Courier::DataItemMsg< MicCabinStatusDataBindingSource > MicCabinStatusDataItemMsg;

// =========================================================================

class HomescreenGadgetInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 22;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 15;
    static const ::Courier::DataItemKey cDataItemKey = 54;

    typedef ::HomescreenGadgetInfoData Data;

    HomescreenGadgetInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< HomescreenGadgetInfoDataBindingSource > HomescreenGadgetInfoDataItemMsg;

// =========================================================================

class ListScrollBarInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 16;
    static const ::Courier::DataItemKey cDataItemKey = 19;

    typedef ::ListScrollBarInfoData Data;

    ListScrollBarInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< ListScrollBarInfoDataBindingSource > ListScrollBarInfoDataItemMsg;

namespace ItemKey {
        static const ::Courier::DataItemKey InvalidItem = 0;
        static const ::Courier::DataItemKey AppFlyInListInfoItem = 5;
        static const ::Courier::DataItemKey SystemMuteInfoItem = 13;
        static const ::Courier::DataItemKey ListScrollBarInfoItem = 19;
        static const ::Courier::DataItemKey MmiModeItem = 22;
        static const ::Courier::DataItemKey VolumeInfoItem = 35;
        static const ::Courier::DataItemKey StartupMsgInfoItem = 38;
        static const ::Courier::DataItemKey SourceListItemInfoItem = 43;
        static const ::Courier::DataItemKey KDSStatusInfoItem = 49;
        static const ::Courier::DataItemKey HomescreenGadgetInfoItem = 54;
        static const ::Courier::DataItemKey MIC1VolumeInfoItem = 55;
        static const ::Courier::DataItemKey Mic1KeyInfoItem = 59;
        static const ::Courier::DataItemKey ControlPanelInfoItem = 61;
        static const ::Courier::DataItemKey CockpitCabinContextItem = 67;
        static const ::Courier::DataItemKey MicCabinStatusItem = 74;
        static const ::Courier::DataItemKey VolumeBarInfoItem = 77;
        static const ::Courier::DataItemKey WidgetControllersItem = 81;

    namespace AppFlyInListInfo {
            static const ::Courier::DataItemKey AppFlyInEnabilityItem = 58;
            static const ::Courier::DataItemKey AppFlyInImageBgItem = 16;
            static const ::Courier::DataItemKey AppFlyInImageIconItem = 24;
            static const ::Courier::DataItemKey AppFlyInImageBorderItem = 60;
    } // namespace AppFlyInListInfo

    namespace SystemMuteInfo {
            static const ::Courier::DataItemKey Mute_UnMuteVal_CockpitItem = 8;
            static const ::Courier::DataItemKey Mute_UnMuteVal_CabinAItem = 48;
            static const ::Courier::DataItemKey Mute_UnMuteVal_CabinBItem = 41;
    } // namespace SystemMuteInfo

    namespace ListScrollBarInfo {
            static const ::Courier::DataItemKey EnabledItem = 73;
    } // namespace ListScrollBarInfo

    namespace MmiMode {
            static const ::Courier::DataItemKey ModeItem = 46;
    } // namespace MmiMode

    namespace VolumeInfo {
            static const ::Courier::DataItemKey VolumeValueItem = 34;
            static const ::Courier::DataItemKey VolumeValueStringItem = 7;
            static const ::Courier::DataItemKey CabinAVolumeValueItem = 20;
            static const ::Courier::DataItemKey CabinAVolumeValueStringItem = 30;
            static const ::Courier::DataItemKey VolumeSrcItem = 56;
            static const ::Courier::DataItemKey VolumeBarRedItem = 40;
            static const ::Courier::DataItemKey VolumeBarGreenItem = 6;
            static const ::Courier::DataItemKey CabinAControlPanel_Icon_StatusItem = 71;
    } // namespace VolumeInfo

    namespace StartupMsgInfo {
            static const ::Courier::DataItemKey PopupInitialVisibilityItem = 45;
            static const ::Courier::DataItemKey PopupreadyVisibilityItem = 44;
    } // namespace StartupMsgInfo

    namespace SourceListItemInfo {
            static const ::Courier::DataItemKey ItemTextItem = 31;
            static const ::Courier::DataItemKey ItemIsActiveItem = 26;
            static const ::Courier::DataItemKey ItemNormalBitmapItem = 29;
            static const ::Courier::DataItemKey ItemActiveBitmapItem = 23;
            static const ::Courier::DataItemKey ItemPressedBitmapItem = 33;
    } // namespace SourceListItemInfo

    namespace KDSStatusInfo {
            static const ::Courier::DataItemKey KDSStatusItem = 65;
    } // namespace KDSStatusInfo

    namespace HomescreenGadgetInfo {
            static const ::Courier::DataItemKey GadgetInstanceIdItem = 47;
            static const ::Courier::DataItemKey GadgetBgItem = 64;
            static const ::Courier::DataItemKey GadgetIconAreaBgNormalItem = 27;
            static const ::Courier::DataItemKey GadgetIconAreaBgPressedItem = 37;
            static const ::Courier::DataItemKey GadgetIconItem = 17;
            static const ::Courier::DataItemKey GadgetTouchAreaBgNormalItem = 63;
            static const ::Courier::DataItemKey GadgetTouchAreaBgPressedItem = 28;
            static const ::Courier::DataItemKey GadgetTouchAreaTextItem = 78;
            static const ::Courier::DataItemKey GadgetTouchAreaTextColourItem = 36;
            static const ::Courier::DataItemKey GadgetMarginItem = 25;
            static const ::Courier::DataItemKey GadgetSizeItem = 52;
            static const ::Courier::DataItemKey GadgetContentAvailableItem = 70;
            static const ::Courier::DataItemKey GadgetAnimationStatusItem = 66;
            static const ::Courier::DataItemKey GadgetFunctionAvailableItem = 82;
            static const ::Courier::DataItemKey GadgetMapOutTextItem = 4;
            static const ::Courier::DataItemKey GadgetVideoMixIconEnableStatusItem = 50;
            static const ::Courier::DataItemKey GadgetVideoMixIconVisibilityItem = 76;
            static const ::Courier::DataItemKey GadgetVideoMixTextItem = 72;
            static const ::Courier::DataItemKey GadgetNATransparentBgItem = 18;
            static const ::Courier::DataItemKey GadgetNAAnimationPositionItem = 79;
            static const ::Courier::DataItemKey GadgetNATextPositionItem = 21;
    } // namespace HomescreenGadgetInfo

    namespace MIC1VolumeInfo {
            static const ::Courier::DataItemKey Mic1MuteStatusItem = 9;
            static const ::Courier::DataItemKey Mic1ProgressBarVolumeValueItem = 80;
            static const ::Courier::DataItemKey Mic1VolumeValueItem = 69;
    } // namespace MIC1VolumeInfo

    namespace Mic1KeyInfo {
            static const ::Courier::DataItemKey Mic1TouchabilityStatusItem = 53;
    } // namespace Mic1KeyInfo

    namespace ControlPanelInfo {
            static const ::Courier::DataItemKey ContextItem = 11;
            static const ::Courier::DataItemKey SpeechIconEnableItem = 10;
            static const ::Courier::DataItemKey MicIconEnableStatusItem = 1;
    } // namespace ControlPanelInfo

    namespace CockpitCabinContext {
            static const ::Courier::DataItemKey CameraStreamStatus_CabinAItem = 15;
            static const ::Courier::DataItemKey CameraStreamStatus_CabinBItem = 51;
    } // namespace CockpitCabinContext

    namespace MicCabinStatus {
            static const ::Courier::DataItemKey CabinMicSourceIndexItem = 14;
    } // namespace MicCabinStatus

    namespace VolumeBarInfo {
            static const ::Courier::DataItemKey Volume_CurrentValItem = 3;
            static const ::Courier::DataItemKey Volume_TotalValItem = 57;
            static const ::Courier::DataItemKey Volume_NoOfStepsItem = 68;
            static const ::Courier::DataItemKey Volume_MaxValueItem = 83;
            static const ::Courier::DataItemKey Volume_MinValueItem = 12;
            static const ::Courier::DataItemKey Volume_StepSizeItem = 32;
    } // namespace VolumeBarInfo

    namespace WidgetControllers {
            static const ::Courier::DataItemKey swipegesture_idItem = 2;
            static const ::Courier::DataItemKey Pagination_visibilityItem = 62;
            static const ::Courier::DataItemKey Swipe_enable_disItem = 75;
            static const ::Courier::DataItemKey Scroll_enable_disItem = 39;
            static const ::Courier::DataItemKey BG_scro_enable_disItem = 42;
    } // namespace WidgetControllers
} // namespace ItemKey

bool InitDataBinding();

#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
namespace FeatStd {
// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::VolumeInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::VolumeInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::VolumeBarInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::VolumeBarInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::AppFlyInListInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::AppFlyInListInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SystemMuteInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SystemMuteInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::MmiModeDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::MmiModeDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::KDSStatusInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::KDSStatusInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::StartupMsgInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::StartupMsgInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ControlPanelInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ControlPanelInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::CockpitCabinContextDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::CockpitCabinContextDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::WidgetControllersDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::WidgetControllersDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SourceListItemInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SourceListItemInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::MIC1VolumeInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::MIC1VolumeInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Mic1KeyInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Mic1KeyInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::MicCabinStatusDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::MicCabinStatusDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HomescreenGadgetInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HomescreenGadgetInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ListScrollBarInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ListScrollBarInfoDataBindingSource > const& dataItemContainer);
} // namespace FeatStd
#endif // FEATSTD_STRINGBUFFER_APPENDER_ENABLED
#endif // AppHmi_MasterStateMachine_h
