/************************************************************************
*FILE: AppHmi_MasterStateMachine.cpp 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#include "AppHmi_MasterStateMachine.h"
#include <FeatStd/Util/StaticObject.h>
#include <Cit/VisualStateGlueLayer/VisualStateGlueLayer.h>
#include <Courier/Util/Util.h>
#include <Project.h>
#include <ApplicationSwitchConst.h>
using namespace ::hmi::apps;
using namespace ::hmi::apps::reference;
using namespace ::hmibase;
using namespace ::hmibase::app::base;

//====  defines and includes TTFis output - added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
#include "hmi_trace_if.h"
#include "View/CGI/CourierMsgTracing/CourierMessageMapTrace.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_SM
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/AppHmi_MasterStateMachine.cpp.trc.h"
#endif                            
//====  defines and includes TTFis output - end                        key: SM_TTFis_SBHFMSRF ====

// ------------------------------------------------------------------------

// ------------------------------------------------------------------------
bool SendGuiStartupFinishedUpdMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::GuiStartupFinishedUpdMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendNotifierMessage()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::NotifierMessage)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendActivateMasterApplicationReqMsg(Courier::UInt8 const & aDisplayStatus)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ActivateMasterApplicationReqMsg)(aDisplayStatus);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendActivateApplicationReqMsg(Courier::Int32 const & aAppId, Courier::UInt32 const & aSurfaceId, Courier::UInt8 const & aDisplayStatus)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ActivateApplicationReqMsg)(aAppId, aSurfaceId, aDisplayStatus);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendEnableConnectionReqMsg(AudioConnectionRequest::Enum const & aRequestId, Courier::Int32 const & aUserData1, Courier::Int32 const & aUserData2, Courier::Int32 const & aUserData3, Courier::Int32 const & aUserData4)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::EnableConnectionReqMsg)(aRequestId, aUserData1, aUserData2, aUserData3, aUserData4);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSetVolumeReqMsg(Courier::Int32 const & aValue, Courier::UInt32 const & aU32RegionID)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SetVolumeReqMsg)(aValue, aU32RegionID);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSetMicVolumeReqMsg(Courier::Int32 const & aValue)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SetMicVolumeReqMsg)(aValue);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSetCabinVolumeReqMsg(Courier::Int32 const & aValue)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SetCabinVolumeReqMsg)(aValue);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendStartBeepReqMsg(Courier::Int32 const & aBeepType)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::StartBeepReqMsg)(aBeepType);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendChangeHmiSubStateReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ChangeHmiSubStateReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSwitchBacklightReqMsg(Courier::Int32 const & aState)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SwitchBacklightReqMsg)(aState);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendExternalImageProviderReqMsg(Courier::Int32 const & aInstanceId, bool const & aActivate, hmibase::gadget::gadgetSceneStatus const & aTargetState)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::hmibase::gadget::ExternalImageProviderReqMsg)(aInstanceId, aActivate, aTargetState);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSubSurfaceVisibleMsg(Candera::String const & aApplicationName, hmibase::displayRegion const & aDisplayRegion, Courier::UInt32 const & aDisplayID, Courier::UInt32 const & aStatus)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SubSurfaceVisibleMsg)(aApplicationName, aDisplayRegion, aDisplayID, aStatus);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendReqSpeechSessionMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ReqSpeechSessionMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendConnect_DisconnectCameraToPluginMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::Connect_DisconnectCameraToPluginMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendConnectAnalogCameraToPluginMsg(Courier::UInt32 const & aCameraId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ConnectAnalogCameraToPluginMsg)(aCameraId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendToggleMapOutStatus(Courier::Int32 const & aRegionId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ToggleMapOutStatus)(aRegionId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendAudio_Active_SourceReqMsg(Courier::Int32 const & aActiveApp_Index)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::Audio_Active_SourceReqMsg)(aActiveApp_Index);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendConnect_DisconnectAudioToPluginMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::Connect_DisconnectAudioToPluginMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendShowHideRVCSceneMsg(bool const & aShowhide)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ShowHideRVCSceneMsg)(aShowhide);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendChangeRegionMsg(Courier::UInt32 const & aRegionId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ChangeRegionMsg)(aRegionId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendContextSwitchFromHomeMsg(Courier::Int32 const & aRegionId, Courier::Int32 const & aSourceAppId, Courier::Int32 const & aSourceActivityId, Courier::Int32 const & aTargetAppId, Courier::Int32 const & aTargetActivityId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ContextSwitchFromHomeMsg)(aRegionId, aSourceAppId, aSourceActivityId, aTargetAppId, aTargetActivityId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendStoreContextSwitchFromHomeMsg(Courier::Int32 const & aRegionId, Courier::Int32 const & aTargetAppId, Courier::Int32 const & aTargetActivityId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::StoreContextSwitchFromHomeMsg)(aRegionId, aTargetAppId, aTargetActivityId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendHourLogicModeStateMsg(bool const & aStatus)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::HourLogicModeStateMsg)(aStatus);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendActivateMIC(Courier::Int32 const & aValue, bool const & aStatus, Courier::UInt8 const & aKeyType)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ActivateMIC)(aValue, aStatus, aKeyType);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendApplicationSwitchCompleteMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ApplicationSwitchCompleteMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendActivate_Speech_Msg(Courier::Int32 const & aValue)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::Activate_Speech_Msg)(aValue);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendUpdateSPM_HMI_ON()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::UpdateSPM_HMI_ON)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendStartDisclaimerTimerReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::StartDisclaimerTimerReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendStopDisclaimerTimerReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::StopDisclaimerTimerReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendReqHMIReadVIN()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ReqHMIReadVIN)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendCommonButtonVisibleStatusUpdMsg(bool const & aVisibleStatus)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::CommonButtonVisibleStatusUpdMsg)(aVisibleStatus);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendExecuteCommonButtonActivationRequestMsg(bool const & aActiveStatus)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ExecuteCommonButtonActivationRequestMsg)(aActiveStatus);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendEncoderStatusUpdateMsg(Courier::UInt32 const & aU32EncoderKey, Courier::Int32 const & aEncoderSteps)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::EncoderStatusUpdateMsg)(aU32EncoderKey, aEncoderSteps);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendHKStatusUpdateMsg(Courier::UInt32 const & aHkCode, Courier::UInt8 const & aHkState)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::HKStatusUpdateMsg)(aHkCode, aHkState);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendToggleMuteStateReqMsg(Courier::UInt32 const & aU32RegionID)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ToggleMuteStateReqMsg)(aU32RegionID);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSceneStatusInfoMsg(Courier::UInt32 const & aViewId, Courier::UInt32 const & aActiveStatus)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SceneStatusInfoMsg)(aViewId, aActiveStatus);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSetSystemMuteReqMsg(Courier::UInt32 const & aRegionId, bool const & aMuteStatus)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SetSystemMuteReqMsg)(aRegionId, aMuteStatus);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSetHmiStartupMuteRequest(bool const & aMuteStatus)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SetHmiStartupMuteRequest)(aMuteStatus);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendControlPanelButtonPressUpdate(Courier::UInt8 const & aControlPanelButton, Courier::UInt8 const & aButtonstate, Courier::UInt32 const & aReceiverAppID)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ControlPanelButtonPressUpdate)(aControlPanelButton, aButtonstate, aReceiverAppID);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendAppFlyInActivationReqMsg(bool const & aActivationStatus)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::AppFlyInActivationReqMsg)(aActivationStatus);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendExecuteContextSwitchRequestMsg(Courier::Int32 const & aRegionId, Courier::Int32 const & aSourceAppId, Courier::Int32 const & aSourceActivityId, Courier::Int32 const & aTargetAppId, Courier::Int32 const & aTargetActivityId, Courier::UInt32 const & aExecuteCode)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ExecuteContextSwitchRequestMsg)(aRegionId, aSourceAppId, aSourceActivityId, aTargetAppId, aTargetActivityId, aExecuteCode);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendClearLastApplication()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ClearLastApplication)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendFaciaON_OFF_Btn_ResetReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::FaciaON_OFF_Btn_ResetReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendFaciaON_OFF_Btn_ShutDownReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::FaciaON_OFF_Btn_ShutDownReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendHandleSettingsMsg(Courier::UInt32 const & aRegionId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::HandleSettingsMsg)(aRegionId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendChangeLanguageReqMsg(enLanguageId const & aLanguageId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ChangeLanguageReqMsg)(aLanguageId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendFocusReqMsg(FocusActionEnum const & aAction, FocusTimerActionEnum const & aTimerAction, ::Courier::ViewId const & aView, Candera::String const & aWidget)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::FocusReqMsg)(aAction, aTimerAction, aView, aWidget);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendDummyMess(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::DummyMess)(aFirstView, aSecondView, aPos);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendAnimationReqMsg(Courier::AnimationAction::Enum const & aAnimationAction, ::Courier::ViewId const & aViewId, Courier::CompositePath const & aCompositePath, ::Courier::ItemId const & aAnimationId, Courier::AnimationProperties const & aAnimationProperties)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::Courier::AnimationReqMsg)(aAnimationAction, aViewId, aCompositePath, aAnimationId, aAnimationProperties);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendFocusOnRightEncoderReqUpdMsg(bool const & aIsFocusUsed)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::FocusOnRightEncoderReqUpdMsg)(aIsFocusUsed);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendStoreActiveGadgetReqMsg(bool const & aIsGadgetAtive)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::StoreActiveGadgetReqMsg)(aIsGadgetAtive);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendHardKeyPressNotificationMsg(Courier::UInt8 const & aDummy, Courier::UInt8 const & aHKCode, Courier::UInt8 const & aHKState)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::HardKeyPressNotificationMsg)(aDummy, aHKCode, aHKState);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendDropdownChangeMsg(::Candera::DropdownChangeType const & aDropdownChangeType, ::Courier::UInt32 const & aListId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::DropdownChangeMsg)(aDropdownChangeType, aListId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendStartPopupTimerReqMsg(Courier::UInt32 const & aViewId, Courier::UInt32 const & aTimeout)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::StartPopupTimerReqMsg)(aViewId, aTimeout);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendStopPopupTimerReqMsg(Courier::UInt32 const & aViewId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::StopPopupTimerReqMsg)(aViewId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPlayBeepReqMsg(Courier::Int32 const & aBeepType)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::PlayBeepReqMsg)(aBeepType);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendCheckToClosePopupMsg(Courier::UInt32 const & aPopupId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::CheckToClosePopupMsg)(aPopupId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendRestartPopupTimerReqMsg(Courier::UInt32 const & aViewId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::RestartPopupTimerReqMsg)(aViewId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendContextSwitchInResMsg(Courier::UInt32 const & aSwitchId, Courier::UInt32 const & aResponseType)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ContextSwitchInResMsg)(aSwitchId, aResponseType);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendContextSwitchOutReqMsg(Courier::UInt32 const & aTargetContextId, Courier::UInt32 const & aSourceContextId, Courier::UInt32 const & aTargetAppId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ContextSwitchOutReqMsg)(aTargetContextId, aSourceContextId, aTargetAppId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendCurrentScreenDisplayReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::CurrentScreenDisplayReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendLaunchBarDisplayReqMsg(bool const & aVisibility)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::LaunchBarDisplayReqMsg)(aVisibility);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendNavTBTSwipeReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::NavTBTSwipeReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendListItemRightEncoderChangeUpdMsg(Courier::Int8 const & aSteps, Courier::UInt32 const & aListId, Courier::UInt32 const & aRowId, Courier::UInt32 const & aColumnId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ListItemRightEncoderChangeUpdMsg)(aSteps, aListId, aRowId, aColumnId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendListChangeMsg(::Courier::UInt32 const & aListId, ListChangeType const & aListChangeType, ::Courier::Int32 const & aValue, ListChangeMsgSourceType const & aListChangeMsgSource, bool const & aImmediatePositioning)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ListChangeMsg)(aListId, aListChangeType, aValue, aListChangeMsgSource, aImmediatePositioning);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendListFocusScrollReqMsg(Courier::UInt32 const & aListId, Courier::Int32 const & aSteps)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ListFocusScrollReqMsg)(aListId, aSteps);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendListFocusLockDataResetReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ListFocusLockDataResetReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSetApplicationModeReqMsg(Courier::UInt32 const & aModeId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SetApplicationModeReqMsg)(aModeId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSpellerBbehaviorReqMsg(bool const & aEnable)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SpellerBbehaviorReqMsg)(aEnable);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendStatusBarDisplayReqMsg(bool const & aVisibility, Courier::Int32 const & aHeaderType)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::StatusBarDisplayReqMsg)(aVisibility, aHeaderType);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendTBTRetriggerAcousticMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::TBTRetriggerAcousticMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendViewReqMsg(Courier::ViewAction::Enum const & aViewAction, ::Courier::ViewId const & aViewId, bool const & aShallInitScene, bool const & aShallLoadScene)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::Courier::ViewReqMsg)(aViewAction, aViewId, aShallInitScene, aShallLoadScene);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendActivationReqMsg(::Courier::ViewId const & aViewId, bool const & aActivation, bool const & aEnableRendering)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::Courier::ActivationReqMsg)(aViewId, aActivation, aEnableRendering);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendAsyncLoadReqMsg(::Courier::ViewId const & aViewId, bool const & aLoad)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::Courier::AsyncLoadReqMsg)(aViewId, aLoad);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPopupReqMsg(hmibase::popups::CommandEnum const & aCommand, ::Courier::ViewId const & aViewId, Courier::UInt32 const & aPopupDisplayID)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::PopupReqMsg)(aCommand, aViewId, aPopupDisplayID);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendExtendedViewReqMsg(hmibase::views::CommandEnum const & aCommand, ::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ExtendedViewReqMsg)(aCommand, aViewId, aHint);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendShowHMISubSurfaceReqMsg(hmibase::displayRegion const & aDisplayRegion, Courier::Int32 const & aDisplayRegionType, bool const & aShowSubSurface, Courier::UInt32 const & aDisplayID, bool const & aLockSubSurface)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ShowHMISubSurfaceReqMsg)(aDisplayRegion, aDisplayRegionType, aShowSubSurface, aDisplayID, aLockSubSurface);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendRegisterForCloseOnTouchSessionReqMsg(bool const & aRegister, ::Courier::ViewId const & aViewId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::RegisterForCloseOnTouchSessionReqMsg)(aRegister, aViewId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPopupFilterPrioEnableReqMsg(Courier::UInt32 const & aPrio)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::PopupFilterPrioEnableReqMsg)(aPrio);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPopupFilterAllEnableReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::PopupFilterAllEnableReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPopupFilterDisableReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::PopupFilterDisableReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendProfileSwitchMsg(Courier::UInt32 const & aProfile)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ProfileSwitchMsg)(aProfile);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendMultiDisplayPopupFilterReqMsg(hmibase::PopupFilterType const & aPopupFilterType, Courier::UInt32 const & aPrio, Courier::UInt32 const & aDisplayID)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::MultiDisplayPopupFilterReqMsg)(aPopupFilterType, aPrio, aDisplayID);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendCreateNewDestroyOld(::Courier::ViewId const & aSourceView, ::Courier::ViewId const & aDestinationView, Courier::UInt32 const & aUserData1, Courier::Int8 const & aUserData2)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::CreateNewDestroyOld)(aSourceView, aDestinationView, aUserData1, aUserData2);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Notify_Init_Finished(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Notify_Init_Finished();
    return true;
}
#endif
void Action_Notify_Init_Finished()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action Notify_Init_Finished()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendGuiStartupFinishedUpdMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acNoAction(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acNoAction();
    return true;
}
#endif
void Action_acNoAction()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acNoAction()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendNotifierMessage();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acActivateMaster(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acActivateMaster();
    return true;
}
#endif
void Action_acActivateMaster()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acActivateMaster()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendActivateMasterApplicationReqMsg(1);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acActivateApplication(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_acActivateApplication(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_acActivateApplication(Courier::UInt32 const & aSurfaceId, Courier::Int32 const & aAppId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acActivateApplication(aSurfaceId = %d, aAppId = %d)", aSurfaceId,aAppId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendActivateApplicationReqMsg(aAppId, aSurfaceId, 1);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acDeactivateApplication(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_acDeactivateApplication(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_acDeactivateApplication(Courier::Int32 const & aAppId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acDeactivateApplication(aAppId = %d)", aAppId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendActivateApplicationReqMsg(aAppId, 0, 2);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acRequestSourceFM(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acRequestSourceFM();
    return true;
}
#endif
void Action_acRequestSourceFM()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acRequestSourceFM()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendEnableConnectionReqMsg(AudioConnectionRequest::GROUP_REQUEST, 0, Courier::Int32(), Courier::Int32(), Courier::Int32());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acRequestSourceAM(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acRequestSourceAM();
    return true;
}
#endif
void Action_acRequestSourceAM()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acRequestSourceAM()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendEnableConnectionReqMsg(AudioConnectionRequest::GROUP_REQUEST, 1, Courier::Int32(), Courier::Int32(), Courier::Int32());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acRequestSourceMedia(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acRequestSourceMedia();
    return true;
}
#endif
void Action_acRequestSourceMedia()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acRequestSourceMedia()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendEnableConnectionReqMsg(AudioConnectionRequest::GROUP_REQUEST, 2, Courier::Int32(), Courier::Int32(), Courier::Int32());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acVolumeReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_acVolumeReq(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_acVolumeReq(Courier::Int32 const & aValue, Courier::UInt32 const & aU32RegionID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acVolumeReq(aValue = %d, aU32RegionID = %d)", aValue,aU32RegionID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSetVolumeReqMsg(aValue, aU32RegionID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acMicVolumeReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_acMicVolumeReq(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_acMicVolumeReq(Courier::Int32 const & aValue)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acMicVolumeReq(aValue = %d)", aValue));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSetMicVolumeReqMsg(aValue);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSetCabinVolumeReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_acSetCabinVolumeReq(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_acSetCabinVolumeReq(Courier::Int32 const & aValue)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acSetCabinVolumeReq(aValue = %d)", aValue));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSetCabinVolumeReqMsg(aValue);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acLastApplicationReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acLastApplicationReq();
    return true;
}
#endif
void Action_acLastApplicationReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acLastApplicationReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendEnableConnectionReqMsg(AudioConnectionRequest::LAST_APPLICATION_REQUEST, Courier::Int32(), Courier::Int32(), Courier::Int32(), Courier::Int32());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acStartBeep(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_acStartBeep(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_acStartBeep(Courier::Int32 const & aBeepType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acStartBeep(aBeepType = %d)", aBeepType));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendStartBeepReqMsg(aBeepType);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acRequestHmiSubState(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acRequestHmiSubState();
    return true;
}
#endif
void Action_acRequestHmiSubState()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acRequestHmiSubState()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendChangeHmiSubStateReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSwitchBacklight(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_acSwitchBacklight(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_acSwitchBacklight(Courier::Int32 const & aState)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acSwitchBacklight(aState = %d)", aState));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSwitchBacklightReqMsg(aState);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acActivateExternalImageProviderReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_acActivateExternalImageProviderReq(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_acActivateExternalImageProviderReq(Courier::Int32 const & aInstanceId, bool const & aActivate)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acActivateExternalImageProviderReq(aInstanceId = %d, aActivate = %d)", aInstanceId,aActivate));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendExternalImageProviderReqMsg(aInstanceId, aActivate, hmibase::gadget::UNDEFINED);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acDeactivateExternalImageProviderReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_acDeactivateExternalImageProviderReq(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_acDeactivateExternalImageProviderReq(Courier::Int32 const & aInstanceId, bool const & aActivate)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acDeactivateExternalImageProviderReq(aInstanceId = %d, aActivate = %d)", aInstanceId,aActivate));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendExternalImageProviderReqMsg(aInstanceId, aActivate, hmibase::gadget::UNDEFINED);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acMasterCommonButtonVisibleReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_acMasterCommonButtonVisibleReq(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_acMasterCommonButtonVisibleReq(Courier::UInt32 const & aStatus)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acMasterCommonButtonVisibleReq(aStatus = %d)", aStatus));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSubSurfaceVisibleMsg(appHmi_Master, STATUS_LINE, 1, aStatus);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acMasterAppFlyInButtonVisibleReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_acMasterAppFlyInButtonVisibleReq(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_acMasterAppFlyInButtonVisibleReq(Courier::UInt32 const & aStatus)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acMasterAppFlyInButtonVisibleReq(aStatus = %d)", aStatus));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSubSurfaceVisibleMsg(appHmi_Master, FOOTER_LINE, 1, aStatus);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acReqSpeechSession(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acReqSpeechSession();
    return true;
}
#endif
void Action_acReqSpeechSession()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acReqSpeechSession()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendReqSpeechSessionMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acConnect_DisconnectCameraToPluginMsg(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acConnect_DisconnectCameraToPluginMsg();
    return true;
}
#endif
void Action_acConnect_DisconnectCameraToPluginMsg()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acConnect_DisconnectCameraToPluginMsg()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendConnect_DisconnectCameraToPluginMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acConnectAnalogCameraToPluginMsg(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_acConnectAnalogCameraToPluginMsg(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_acConnectAnalogCameraToPluginMsg(Courier::UInt32 const & aCameraId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acConnectAnalogCameraToPluginMsg(aCameraId = %d)", aCameraId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendConnectAnalogCameraToPluginMsg(aCameraId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acToggleMapOutStatus(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acToggleMapOutStatus(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acToggleMapOutStatus(Courier::Int32 const & aRegionId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acToggleMapOutStatus(aRegionId = %d)", aRegionId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendToggleMapOutStatus(aRegionId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acAudio_Active_SourceReqMsg(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_acAudio_Active_SourceReqMsg(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_acAudio_Active_SourceReqMsg(Courier::Int32 const & aActiveApp_Index)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acAudio_Active_SourceReqMsg(aActiveApp_Index = %d)", aActiveApp_Index));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAudio_Active_SourceReqMsg(aActiveApp_Index);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acConnect_Disconnect_AudioToPluginMsg(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acConnect_Disconnect_AudioToPluginMsg();
    return true;
}
#endif
void Action_acConnect_Disconnect_AudioToPluginMsg()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acConnect_Disconnect_AudioToPluginMsg()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendConnect_DisconnectAudioToPluginMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acActivateRVC(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acActivateRVC();
    return true;
}
#endif
void Action_acActivateRVC()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acActivateRVC()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHideRVCSceneMsg(true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acDeactivateRVC(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acDeactivateRVC();
    return true;
}
#endif
void Action_acDeactivateRVC()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acDeactivateRVC()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHideRVCSceneMsg(false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acChangeRegion(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_acChangeRegion(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_acChangeRegion(Courier::UInt32 const & aRegionId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acChangeRegion(aRegionId = %d)", aRegionId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendChangeRegionMsg(aRegionId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acContextSwitchFromHomeMsg(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 5) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt() && parameters[(::Json::Value::UInt)2].isInt() && parameters[(::Json::Value::UInt)3].isInt() && parameters[(::Json::Value::UInt)4].isInt())) { return false; }
    Action_acContextSwitchFromHomeMsg(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt(), parameters[(::Json::Value::UInt)2].asInt(), parameters[(::Json::Value::UInt)3].asInt(), parameters[(::Json::Value::UInt)4].asInt());
    return true;
}
#endif
void Action_acContextSwitchFromHomeMsg(Courier::Int32 const & aRegionId, Courier::Int32 const & aSourceAppId, Courier::Int32 const & aSourceActivityId, Courier::Int32 const & aTargetAppId, Courier::Int32 const & aTargetActivityId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acContextSwitchFromHomeMsg(aRegionId = %d, aSourceAppId = %d, aSourceActivityId = %d, aTargetAppId = %d, aTargetActivityId = %d)", aRegionId,aSourceAppId,aSourceActivityId,aTargetAppId,aTargetActivityId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendContextSwitchFromHomeMsg(aRegionId, aSourceAppId, aSourceActivityId, aTargetAppId, aTargetActivityId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acContextSwitchWithActiveRegion(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 4) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt() && parameters[(::Json::Value::UInt)2].isInt() && parameters[(::Json::Value::UInt)3].isInt())) { return false; }
    Action_acContextSwitchWithActiveRegion(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt(), parameters[(::Json::Value::UInt)2].asInt(), parameters[(::Json::Value::UInt)3].asInt());
    return true;
}
#endif
void Action_acContextSwitchWithActiveRegion(Courier::Int32 const & aSourceAppId, Courier::Int32 const & aSourceActivityId, Courier::Int32 const & aTargetAppId, Courier::Int32 const & aTargetActivityId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acContextSwitchWithActiveRegion(aSourceAppId = %d, aSourceActivityId = %d, aTargetAppId = %d, aTargetActivityId = %d)", aSourceAppId,aSourceActivityId,aTargetAppId,aTargetActivityId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendContextSwitchFromHomeMsg(fnGetRegionId(), aSourceAppId, aSourceActivityId, aTargetAppId, aTargetActivityId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acContextSwitchWithLastActiveCabinRegion(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 4) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt() && parameters[(::Json::Value::UInt)2].isInt() && parameters[(::Json::Value::UInt)3].isInt())) { return false; }
    Action_acContextSwitchWithLastActiveCabinRegion(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt(), parameters[(::Json::Value::UInt)2].asInt(), parameters[(::Json::Value::UInt)3].asInt());
    return true;
}
#endif
void Action_acContextSwitchWithLastActiveCabinRegion(Courier::Int32 const & aSourceAppId, Courier::Int32 const & aSourceActivityId, Courier::Int32 const & aTargetAppId, Courier::Int32 const & aTargetActivityId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acContextSwitchWithLastActiveCabinRegion(aSourceAppId = %d, aSourceActivityId = %d, aTargetAppId = %d, aTargetActivityId = %d)", aSourceAppId,aSourceActivityId,aTargetAppId,aTargetActivityId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendContextSwitchFromHomeMsg(fnGetLastActiveCabinRegionId(), aSourceAppId, aSourceActivityId, aTargetAppId, aTargetActivityId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acStoreContextSwitchFromHomeMsg(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 3) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt() && parameters[(::Json::Value::UInt)2].isInt())) { return false; }
    Action_acStoreContextSwitchFromHomeMsg(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt(), parameters[(::Json::Value::UInt)2].asInt());
    return true;
}
#endif
void Action_acStoreContextSwitchFromHomeMsg(Courier::Int32 const & aRegionId, Courier::Int32 const & aTargetAppId, Courier::Int32 const & aTargetActivityId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acStoreContextSwitchFromHomeMsg(aRegionId = %d, aTargetAppId = %d, aTargetActivityId = %d)", aRegionId,aTargetAppId,aTargetActivityId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendStoreContextSwitchFromHomeMsg(aRegionId, aTargetAppId, aTargetActivityId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acHourLogicModeStateMsg(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_acHourLogicModeStateMsg(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_acHourLogicModeStateMsg(bool const & aStatus)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acHourLogicModeStateMsg(aStatus = %d)", aStatus));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendHourLogicModeStateMsg(aStatus);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acActivateMIC(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 3) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isBool() && parameters[(::Json::Value::UInt)2].isUInt())) { return false; }
    Action_acActivateMIC(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asBool(), parameters[(::Json::Value::UInt)2].asUInt());
    return true;
}
#endif
void Action_acActivateMIC(Courier::Int32 const & aValue, bool const & aStatus, Courier::UInt8 const & aKeyType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acActivateMIC(aValue = %d, aStatus = %d, aKeyType = %d)", aValue,aStatus,aKeyType));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendActivateMIC(aValue, aStatus, aKeyType);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acApplicationSwitchCompleteMsg(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acApplicationSwitchCompleteMsg();
    return true;
}
#endif
void Action_acApplicationSwitchCompleteMsg()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acApplicationSwitchCompleteMsg()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendApplicationSwitchCompleteMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acActivate_Speech_Msg(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_acActivate_Speech_Msg(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_acActivate_Speech_Msg(Courier::Int32 const & aValue)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acActivate_Speech_Msg(aValue = %d)", aValue));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendActivate_Speech_Msg(aValue);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acUpdateSPM_HMI_ON(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acUpdateSPM_HMI_ON();
    return true;
}
#endif
void Action_acUpdateSPM_HMI_ON()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acUpdateSPM_HMI_ON()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendUpdateSPM_HMI_ON();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acStartDisclaimerTimerReqMsg(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acStartDisclaimerTimerReqMsg();
    return true;
}
#endif
void Action_acStartDisclaimerTimerReqMsg()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acStartDisclaimerTimerReqMsg()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendStartDisclaimerTimerReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acStopDisclaimerTimerReqMsg(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acStopDisclaimerTimerReqMsg();
    return true;
}
#endif
void Action_acStopDisclaimerTimerReqMsg()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acStopDisclaimerTimerReqMsg()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendStopDisclaimerTimerReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acReqHMIReadVIN(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acReqHMIReadVIN();
    return true;
}
#endif
void Action_acReqHMIReadVIN()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acReqHMIReadVIN()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendReqHMIReadVIN();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acShowCommonButton(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acShowCommonButton();
    return true;
}
#endif
void Action_acShowCommonButton()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acShowCommonButton()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendCommonButtonVisibleStatusUpdMsg(true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acHideCommonButton(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acHideCommonButton();
    return true;
}
#endif
void Action_acHideCommonButton()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acHideCommonButton()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendCommonButtonVisibleStatusUpdMsg(false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acExecuteCommonButtonActivationRequest(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_acExecuteCommonButtonActivationRequest(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_acExecuteCommonButtonActivationRequest(bool const & aActiveStatus)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acExecuteCommonButtonActivationRequest(aActiveStatus = %d)", aActiveStatus));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendExecuteCommonButtonActivationRequestMsg(aActiveStatus);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acEncoderStatusUpdateMsg(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_acEncoderStatusUpdateMsg(parameters[(::Json::Value::UInt)0].asUInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_acEncoderStatusUpdateMsg(Courier::UInt32 const & aU32EncoderKey, Courier::Int32 const & aEncoderSteps)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acEncoderStatusUpdateMsg(aU32EncoderKey = %d, aEncoderSteps = %d)", aU32EncoderKey,aEncoderSteps));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendEncoderStatusUpdateMsg(aU32EncoderKey, aEncoderSteps);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acHKStatusUpdateMsg(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_acHKStatusUpdateMsg(parameters[(::Json::Value::UInt)0].asUInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_acHKStatusUpdateMsg(Courier::UInt32 const & aHkCode, Courier::UInt8 const & aHkState)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acHKStatusUpdateMsg(aHkCode = %d, aHkState = %d)", aHkCode,aHkState));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendHKStatusUpdateMsg(aHkCode, aHkState);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acToggleMuteState(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acToggleMuteState(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acToggleMuteState(Courier::UInt32 const & aU32RegionID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acToggleMuteState(aU32RegionID = %d)", aU32RegionID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendToggleMuteStateReqMsg(aU32RegionID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acPerformSceneStatusUpd(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_acPerformSceneStatusUpd(parameters[(::Json::Value::UInt)0].asUInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_acPerformSceneStatusUpd(Courier::UInt32 const & aViewId, Courier::UInt32 const & aActiveStatus)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acPerformSceneStatusUpd(aViewId = %d, aActiveStatus = %d)", aViewId,aActiveStatus));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSceneStatusInfoMsg(aViewId, aActiveStatus);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSetSystemMuteRequest(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isBool())) { return false; }
    Action_acSetSystemMuteRequest(parameters[(::Json::Value::UInt)0].asUInt(), parameters[(::Json::Value::UInt)1].asBool());
    return true;
}
#endif
void Action_acSetSystemMuteRequest(Courier::UInt32 const & aRegionId, bool const & aMuteStatus)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acSetSystemMuteRequest(aRegionId = %d, aMuteStatus = %d)", aRegionId,aMuteStatus));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSetSystemMuteReqMsg(aRegionId, aMuteStatus);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSetHmiStartupMuteRequest(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_acSetHmiStartupMuteRequest(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_acSetHmiStartupMuteRequest(bool const & aMuteStatus)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acSetHmiStartupMuteRequest(aMuteStatus = %d)", aMuteStatus));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSetHmiStartupMuteRequest(aMuteStatus);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acControlPanelButtonPressUpdate(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 3) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt() && parameters[(::Json::Value::UInt)2].isUInt())) { return false; }
    Action_acControlPanelButtonPressUpdate(parameters[(::Json::Value::UInt)0].asUInt(), parameters[(::Json::Value::UInt)1].asUInt(), parameters[(::Json::Value::UInt)2].asUInt());
    return true;
}
#endif
void Action_acControlPanelButtonPressUpdate(Courier::UInt8 const & aControlPanelButton, Courier::UInt8 const & aButtonstate, Courier::UInt32 const & aReceiverAppID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acControlPanelButtonPressUpdate(aControlPanelButton = %d, aButtonstate = %d, aReceiverAppID = %d)", aControlPanelButton,aButtonstate,aReceiverAppID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendControlPanelButtonPressUpdate(aControlPanelButton, aButtonstate, aReceiverAppID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acShowAppflyIn(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acShowAppflyIn();
    return true;
}
#endif
void Action_acShowAppflyIn()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acShowAppflyIn()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAppFlyInActivationReqMsg(true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acHideAppFlyIn(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acHideAppFlyIn();
    return true;
}
#endif
void Action_acHideAppFlyIn()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acHideAppFlyIn()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAppFlyInActivationReqMsg(false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acExecuteContextSwitchRequest(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 6) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt() && parameters[(::Json::Value::UInt)2].isInt() && parameters[(::Json::Value::UInt)3].isInt() && parameters[(::Json::Value::UInt)4].isInt() && parameters[(::Json::Value::UInt)5].isUInt())) { return false; }
    Action_acExecuteContextSwitchRequest(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt(), parameters[(::Json::Value::UInt)2].asInt(), parameters[(::Json::Value::UInt)3].asInt(), parameters[(::Json::Value::UInt)4].asInt(), parameters[(::Json::Value::UInt)5].asUInt());
    return true;
}
#endif
void Action_acExecuteContextSwitchRequest(Courier::Int32 const & aRegionId, Courier::Int32 const & aSourceAppId, Courier::Int32 const & aSourceActivityId, Courier::Int32 const & aTargetAppId, Courier::Int32 const & aTargetActivityId, Courier::UInt32 const & aExecuteCode)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acExecuteContextSwitchRequest(aRegionId = %d, aSourceAppId = %d, aSourceActivityId = %d, aTargetAppId = %d, aTargetActivityId = %d, aExecuteCode = %d)", aRegionId,aSourceAppId,aSourceActivityId,aTargetAppId,aTargetActivityId,aExecuteCode));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendExecuteContextSwitchRequestMsg(aRegionId, aSourceAppId, aSourceActivityId, aTargetAppId, aTargetActivityId, aExecuteCode);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acClearLastApplication(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acClearLastApplication();
    return true;
}
#endif
void Action_acClearLastApplication()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acClearLastApplication()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendClearLastApplication();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acRequestReset(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acRequestReset();
    return true;
}
#endif
void Action_acRequestReset()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acRequestReset()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendFaciaON_OFF_Btn_ResetReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acToggleUserOFF_ON(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acToggleUserOFF_ON();
    return true;
}
#endif
void Action_acToggleUserOFF_ON()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acToggleUserOFF_ON()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendFaciaON_OFF_Btn_ShutDownReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acHandleSettingsMsg(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acHandleSettingsMsg(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acHandleSettingsMsg(Courier::UInt32 const & aRegionId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acHandleSettingsMsg(aRegionId = %d)", aRegionId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendHandleSettingsMsg(aRegionId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacChangeLanguageReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_gacChangeLanguageReq(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_gacChangeLanguageReq(enLanguageId const & aLanguageId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacChangeLanguageReq(aLanguageId = ?enLanguageId?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendChangeLanguageReqMsg(aLanguageId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacHideFocusInViewReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacHideFocusInViewReq(::Courier::ViewId(AppHmi_MasterStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacHideFocusInViewReq(::Courier::ViewId const & aView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacHideFocusInViewReq(aView = %50s)", aView.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendFocusReqMsg(FOCUS_HIDE, FOCUS_TIMER_NO_ACTION, aView, Candera::String());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_NextLevelTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_NextLevelTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_NextLevelTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action NextLevelTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_PreviousLevelTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_PreviousLevelTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_PreviousLevelTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action PreviousLevelTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_DualViewLeftTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_DualViewLeftTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_DualViewLeftTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action DualViewLeftTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_DualViewRightTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_DualViewRightTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_DualViewRightTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action DualViewRightTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_PageFlipBackTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_PageFlipBackTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_PageFlipBackTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action PageFlipBackTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_PageFlipFrontTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_PageFlipFrontTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_PageFlipFrontTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action PageFlipFrontTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_ZoomInTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 3) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt() && parameters[(::Json::Value::UInt)2].isInt())) { return false; }
    Action_ZoomInTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt(), parameters[(::Json::Value::UInt)2].asInt());
    return true;
}
#endif
void Action_ZoomInTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action ZoomInTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?, aPos = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, aPos);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_ZoomOutTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 3) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt() && parameters[(::Json::Value::UInt)2].isInt())) { return false; }
    Action_ZoomOutTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt(), parameters[(::Json::Value::UInt)2].asInt());
    return true;
}
#endif
void Action_ZoomOutTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action ZoomOutTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?, aPos = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, aPos);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_FadeTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_FadeTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_FadeTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action FadeTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacWaitAnimationStartReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacWaitAnimationStartReq();
    return true;
}
#endif
void Action_gacWaitAnimationStartReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacWaitAnimationStartReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAnimationReqMsg(Courier::AnimationAction::Start, ::Courier::ViewId(), Courier::CompositePath(), ::Courier::ItemId("Global#Animations#WAIT_ANIMATION"), Courier::AnimationProperties());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acFocusOnRightEncoderReqUpd(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_acFocusOnRightEncoderReqUpd(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_acFocusOnRightEncoderReqUpd(bool const & aIsFocusUsed)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acFocusOnRightEncoderReqUpd(aIsFocusUsed = %d)", aIsFocusUsed));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendFocusOnRightEncoderReqUpdMsg(aIsFocusUsed);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSetGadgetSceenActiveStatus(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_acSetGadgetSceenActiveStatus(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_acSetGadgetSceenActiveStatus(bool const & aIsGadgetAtive)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acSetGadgetSceenActiveStatus(aIsGadgetAtive = %d)", aIsGadgetAtive));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendStoreActiveGadgetReqMsg(aIsGadgetAtive);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acHKNotificationMsg(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_acHKNotificationMsg(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_acHKNotificationMsg(Courier::UInt8 const & aHKCode, Courier::UInt8 const & aHKState)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acHKNotificationMsg(aHKCode = %d, aHKState = %d)", aHKCode,aHKState));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendHardKeyPressNotificationMsg(1, aHKCode, aHKState);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acPerform_CloseAllDropdowns(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acPerform_CloseAllDropdowns();
    return true;
}
#endif
void Action_acPerform_CloseAllDropdowns()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acPerform_CloseAllDropdowns()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDropdownChangeMsg(Candera::DropdownChangeClose, 0);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acPerform_CloseDropdown(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acPerform_CloseDropdown(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acPerform_CloseDropdown(::Courier::UInt32 const & aListId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acPerform_CloseDropdown(aListId = ?::Courier::UInt32?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDropdownChangeMsg(Candera::DropdownChangeClose, aListId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acPerform_OpenDropdown(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acPerform_OpenDropdown(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acPerform_OpenDropdown(::Courier::UInt32 const & aListId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acPerform_OpenDropdown(aListId = ?::Courier::UInt32?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDropdownChangeMsg(Candera::DropdownChangeOpen, aListId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acPerform_ToggleDropdown(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acPerform_ToggleDropdown(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acPerform_ToggleDropdown(::Courier::UInt32 const & aListId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acPerform_ToggleDropdown(aListId = ?::Courier::UInt32?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDropdownChangeMsg(Candera::DropdownChangeToggle, aListId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acStartAppPopupTimer(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_acStartAppPopupTimer(parameters[(::Json::Value::UInt)0].asUInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_acStartAppPopupTimer(Courier::UInt32 const & aViewId, Courier::UInt32 const & aTimeout)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acStartAppPopupTimer(aViewId = %d, aTimeout = %d)", aViewId,aTimeout));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendStartPopupTimerReqMsg(aViewId, aTimeout);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acStopAppPopupTimer(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acStopAppPopupTimer(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acStopAppPopupTimer(Courier::UInt32 const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acStopAppPopupTimer(aViewId = %d)", aViewId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendStopPopupTimerReqMsg(aViewId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acPostBeep(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_acPostBeep(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_acPostBeep(Courier::Int32 const & aBeepType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acPostBeep(aBeepType = %d)", aBeepType));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPlayBeepReqMsg(aBeepType);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacCheckToClosePopup(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacCheckToClosePopup(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacCheckToClosePopup(Courier::UInt32 const & aPopupId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacCheckToClosePopup(aPopupId = %d)", aPopupId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendCheckToClosePopupMsg(aPopupId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acRestartAppPopupTimer(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acRestartAppPopupTimer(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acRestartAppPopupTimer(Courier::UInt32 const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action acRestartAppPopupTimer(aViewId = %d)", aViewId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendRestartPopupTimerReqMsg(aViewId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchBackRes(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacContextSwitchBackRes(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacContextSwitchBackRes(Courier::UInt32 const & aSwitchId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacContextSwitchBackRes(aSwitchId = %d)", aSwitchId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendContextSwitchInResMsg(aSwitchId, CONTEXT_TRANSITION_BACK);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchCompleteRes(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacContextSwitchCompleteRes(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacContextSwitchCompleteRes(Courier::UInt32 const & aSwitchId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacContextSwitchCompleteRes(aSwitchId = %d)", aSwitchId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendContextSwitchInResMsg(aSwitchId, CONTEXT_TRANSITION_COMPLETE);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchFailedRes(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacContextSwitchFailedRes(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacContextSwitchFailedRes(Courier::UInt32 const & aSwitchId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacContextSwitchFailedRes(aSwitchId = %d)", aSwitchId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendContextSwitchInResMsg(aSwitchId, CONTEXT_TRANSITION_FAILED);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchDoneRes(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacContextSwitchDoneRes(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacContextSwitchDoneRes(Courier::UInt32 const & aSwitchId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacContextSwitchDoneRes(aSwitchId = %d)", aSwitchId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendContextSwitchInResMsg(aSwitchId, CONTEXT_TRANSITION_DONE);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchOutReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 3) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt() && parameters[(::Json::Value::UInt)2].isUInt())) { return false; }
    Action_gacContextSwitchOutReq(parameters[(::Json::Value::UInt)0].asUInt(), parameters[(::Json::Value::UInt)1].asUInt(), parameters[(::Json::Value::UInt)2].asUInt());
    return true;
}
#endif
void Action_gacContextSwitchOutReq(Courier::UInt32 const & aTargetContextId, Courier::UInt32 const & aSourceContextId, Courier::UInt32 const & aTargetAppId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacContextSwitchOutReq(aTargetContextId = %d, aSourceContextId = %d, aTargetAppId = %d)", aTargetContextId,aSourceContextId,aTargetAppId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendContextSwitchOutReqMsg(aTargetContextId, aSourceContextId, aTargetAppId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacCurrentScreenDisplayReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacCurrentScreenDisplayReq();
    return true;
}
#endif
void Action_gacCurrentScreenDisplayReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacCurrentScreenDisplayReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendCurrentScreenDisplayReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacLaunchBarDisplayReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_gacLaunchBarDisplayReq(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_gacLaunchBarDisplayReq(bool const & aVisibility)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacLaunchBarDisplayReq(aVisibility = %d)", aVisibility));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendLaunchBarDisplayReqMsg(aVisibility);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacNavTBTSwipe(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacNavTBTSwipe();
    return true;
}
#endif
void Action_gacNavTBTSwipe()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacNavTBTSwipe()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendNavTBTSwipeReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPerformListBtnRightEncoderChangeUpd(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 4) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isUInt() && parameters[(::Json::Value::UInt)2].isUInt() && parameters[(::Json::Value::UInt)3].isUInt())) { return false; }
    Action_gacPerformListBtnRightEncoderChangeUpd(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asUInt(), parameters[(::Json::Value::UInt)2].asUInt(), parameters[(::Json::Value::UInt)3].asUInt());
    return true;
}
#endif
void Action_gacPerformListBtnRightEncoderChangeUpd(Courier::Int8 const & aSteps, Courier::UInt32 const & aListId, Courier::UInt32 const & aRowId, Courier::UInt32 const & aColumnId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacPerformListBtnRightEncoderChangeUpd(aSteps = %d, aListId = %d, aRowId = %d, aColumnId = %d)", aSteps,aListId,aRowId,aColumnId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListItemRightEncoderChangeUpdMsg(aSteps, aListId, aRowId, aColumnId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListUp(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacScrollListUp();
    return true;
}
#endif
void Action_gacScrollListUp()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacScrollListUp()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListChangeMsg(::Courier::UInt32(), ListChangeUp, 1, ListChangeMsgSourceUnknown, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListDown(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacScrollListDown();
    return true;
}
#endif
void Action_gacScrollListDown()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacScrollListDown()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListChangeMsg(::Courier::UInt32(), ListChangeDown, 1, ListChangeMsgSourceUnknown, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacScrollPageUp(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacScrollPageUp();
    return true;
}
#endif
void Action_gacScrollPageUp()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacScrollPageUp()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListChangeMsg(::Courier::UInt32(), ListChangePageUp, 1, ListChangeMsgSourceUnknown, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacScrollPageDown(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacScrollPageDown();
    return true;
}
#endif
void Action_gacScrollPageDown()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacScrollPageDown()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListChangeMsg(::Courier::UInt32(), ListChangePageDown, 1, ListChangeMsgSourceUnknown, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListFocusUp(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacScrollListFocusUp(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacScrollListFocusUp(Courier::UInt32 const & aListId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacScrollListFocusUp(aListId = %d)", aListId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListFocusScrollReqMsg(aListId, -1);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListFocusDown(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacScrollListFocusDown(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacScrollListFocusDown(Courier::UInt32 const & aListId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacScrollListFocusDown(aListId = %d)", aListId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListFocusScrollReqMsg(aListId, 1);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPerformListFocusLockDataResetUpd(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacPerformListFocusLockDataResetUpd();
    return true;
}
#endif
void Action_gacPerformListFocusLockDataResetUpd()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacPerformListFocusLockDataResetUpd()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListFocusLockDataResetReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacSetApplicationMode(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacSetApplicationMode(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacSetApplicationMode(Courier::UInt32 const & aModeId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacSetApplicationMode(aModeId = %d)", aModeId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSetApplicationModeReqMsg(aModeId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacSpellerBbehaviorReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_gacSpellerBbehaviorReq(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_gacSpellerBbehaviorReq(bool const & aEnable)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacSpellerBbehaviorReq(aEnable = %d)", aEnable));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSpellerBbehaviorReqMsg(aEnable);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacStatusBarDisplayReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_gacStatusBarDisplayReq(parameters[(::Json::Value::UInt)0].asBool(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_gacStatusBarDisplayReq(bool const & aVisibility, Courier::Int32 const & aHeaderType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacStatusBarDisplayReq(aVisibility = %d, aHeaderType = %d)", aVisibility,aHeaderType));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendStatusBarDisplayReqMsg(aVisibility, aHeaderType);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacTBTRetriggerAcousticOutput(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacTBTRetriggerAcousticOutput();
    return true;
}
#endif
void Action_gacTBTRetriggerAcousticOutput()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacTBTRetriggerAcousticOutput()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTBTRetriggerAcousticMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacWaitAnimationStopReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacWaitAnimationStopReq();
    return true;
}
#endif
void Action_gacWaitAnimationStopReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacWaitAnimationStopReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAnimationReqMsg(Courier::AnimationAction::Stop, ::Courier::ViewId(), Courier::CompositePath(), ::Courier::ItemId("Global#Animations#WAIT_ANIMATION"), Courier::AnimationProperties());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewCreateReq(::Courier::ViewId(AppHmi_MasterStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewCreateReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacViewCreateReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendViewReqMsg(Courier::ViewAction::Create, aViewId, true, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateAllReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewCreateAllReq(::Courier::ViewId(AppHmi_MasterStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewCreateAllReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacViewCreateAllReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendViewReqMsg(Courier::ViewAction::CreateAll, aViewId, true, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewDestroyReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewDestroyReq(::Courier::ViewId(AppHmi_MasterStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewDestroyReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacViewDestroyReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendViewReqMsg(Courier::ViewAction::Destroy, aViewId, false, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewClearReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewClearReq(::Courier::ViewId(AppHmi_MasterStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewClearReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacViewClearReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendViewReqMsg(Courier::ViewAction::Clear, aViewId, true, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewShowReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewShowReq(::Courier::ViewId(AppHmi_MasterStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewShowReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacViewShowReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendActivationReqMsg(aViewId, true, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewHideReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewHideReq(::Courier::ViewId(AppHmi_MasterStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewHideReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacViewHideReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendActivationReqMsg(aViewId, false, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateWithoutLoadReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewCreateWithoutLoadReq(::Courier::ViewId(AppHmi_MasterStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewCreateWithoutLoadReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacViewCreateWithoutLoadReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendViewReqMsg(Courier::ViewAction::Create, aViewId, false, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewAsyncLoadReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewAsyncLoadReq(::Courier::ViewId(AppHmi_MasterStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewAsyncLoadReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacViewAsyncLoadReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAsyncLoadReqMsg(aViewId, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewActivateWithoutRenderingReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewActivateWithoutRenderingReq(::Courier::ViewId(AppHmi_MasterStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewActivateWithoutRenderingReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacViewActivateWithoutRenderingReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendActivationReqMsg(aViewId, true, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupCreateAndSBShowReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacPopupCreateAndSBShowReq(::Courier::ViewId(AppHmi_MasterStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacPopupCreateAndSBShowReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacPopupCreateAndSBShowReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupReqMsg(hmibase::popups::Show, aViewId, hmibase::DEFAULT_UNKNOWN_DISPLAY);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupCreateAndSBShowReqForMultiDisplay(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacPopupCreateAndSBShowReqForMultiDisplay(parameters[(::Json::Value::UInt)0].asUInt(), ::Courier::ViewId(AppHmi_MasterStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)1].asUInt())));
    return true;
}
#endif
void Action_gacPopupCreateAndSBShowReqForMultiDisplay(Courier::UInt32 const & aPopupDisplayID, ::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacPopupCreateAndSBShowReqForMultiDisplay(aPopupDisplayID = %d, aViewId = %50s)", aPopupDisplayID,aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupReqMsg(hmibase::popups::Show, aViewId, aPopupDisplayID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupSBCloseReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacPopupSBCloseReq(::Courier::ViewId(AppHmi_MasterStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacPopupSBCloseReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacPopupSBCloseReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupReqMsg(hmibase::popups::Hide, aViewId, hmibase::DEFAULT_UNKNOWN_DISPLAY);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupSBCloseReqForMultiDisplay(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacPopupSBCloseReqForMultiDisplay(parameters[(::Json::Value::UInt)0].asUInt(), ::Courier::ViewId(AppHmi_MasterStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)1].asUInt())));
    return true;
}
#endif
void Action_gacPopupSBCloseReqForMultiDisplay(Courier::UInt32 const & aPopupDisplayID, ::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacPopupSBCloseReqForMultiDisplay(aPopupDisplayID = %d, aViewId = %50s)", aPopupDisplayID,aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupReqMsg(hmibase::popups::Hide, aViewId, aPopupDisplayID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupRestartTimerReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacPopupRestartTimerReq(::Courier::ViewId(AppHmi_MasterStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacPopupRestartTimerReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacPopupRestartTimerReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupReqMsg(hmibase::popups::RestartTimer, aViewId, hmibase::DEFAULT_UNKNOWN_DISPLAY);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupRestartTimerReqForMultiDisplay(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacPopupRestartTimerReqForMultiDisplay(parameters[(::Json::Value::UInt)0].asUInt(), ::Courier::ViewId(AppHmi_MasterStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)1].asUInt())));
    return true;
}
#endif
void Action_gacPopupRestartTimerReqForMultiDisplay(Courier::UInt32 const & aPopupDisplayID, ::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacPopupRestartTimerReqForMultiDisplay(aPopupDisplayID = %d, aViewId = %50s)", aPopupDisplayID,aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupReqMsg(hmibase::popups::RestartTimer, aViewId, aPopupDisplayID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateAndShowReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewCreateAndShowReq(::Courier::ViewId(AppHmi_MasterStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewCreateAndShowReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacViewCreateAndShowReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendExtendedViewReqMsg(hmibase::views::CreateAndShow, aViewId, 0);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewHideAndDestroyReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewHideAndDestroyReq(::Courier::ViewId(AppHmi_MasterStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewHideAndDestroyReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacViewHideAndDestroyReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendExtendedViewReqMsg(hmibase::views::HideAndDestroy, aViewId, 0);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacSceneTransitionEnter(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacSceneTransitionEnter(::Courier::ViewId(AppHmi_MasterStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt(), ))parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacSceneTransitionEnter(::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacSceneTransitionEnter(aViewId = %50s, aHint = %d)", aViewId.CStr(),aHint));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendExtendedViewReqMsg(hmibase::views::TransitionEnter, aViewId, aHint);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacSceneTransitionLeave(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacSceneTransitionLeave(::Courier::ViewId(AppHmi_MasterStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt(), ))parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacSceneTransitionLeave(::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacSceneTransitionLeave(aViewId = %50s, aHint = %d)", aViewId.CStr(),aHint));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendExtendedViewReqMsg(hmibase::views::TransitionLeave, aViewId, aHint);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayStatusLineReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_gacDisplayStatusLineReq(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_gacDisplayStatusLineReq(Courier::Int32 const & aDisplayRegionType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacDisplayStatusLineReq(aDisplayRegionType = %d)", aDisplayRegionType));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::STATUS_LINE, aDisplayRegionType, true, hmibase::DEFAULT_UNKNOWN_DISPLAY, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacHideStatusLineReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_gacHideStatusLineReq(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_gacHideStatusLineReq(Courier::Int32 const & aDisplayRegionType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacHideStatusLineReq(aDisplayRegionType = %d)", aDisplayRegionType));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::STATUS_LINE, aDisplayRegionType, false, hmibase::DEFAULT_UNKNOWN_DISPLAY, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayFooterLineReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacDisplayFooterLineReq();
    return true;
}
#endif
void Action_gacDisplayFooterLineReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacDisplayFooterLineReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::FOOTER_LINE, Courier::Int32(), true, hmibase::DEFAULT_UNKNOWN_DISPLAY, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacHideFooterLineReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacHideFooterLineReq();
    return true;
}
#endif
void Action_gacHideFooterLineReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacHideFooterLineReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::FOOTER_LINE, Courier::Int32(), false, hmibase::DEFAULT_UNKNOWN_DISPLAY, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayStatusLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacDisplayStatusLineMultiDisplayReq(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacDisplayStatusLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacDisplayStatusLineMultiDisplayReq(aDisplayRegionType = %d, aDisplayID = %d)", aDisplayRegionType,aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::STATUS_LINE, aDisplayRegionType, true, aDisplayID, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacHideStatusLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacHideStatusLineMultiDisplayReq(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacHideStatusLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacHideStatusLineMultiDisplayReq(aDisplayRegionType = %d, aDisplayID = %d)", aDisplayRegionType,aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::STATUS_LINE, aDisplayRegionType, false, aDisplayID, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayFooterLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacDisplayFooterLineMultiDisplayReq(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacDisplayFooterLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacDisplayFooterLineMultiDisplayReq(aDisplayRegionType = %d, aDisplayID = %d)", aDisplayRegionType,aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::FOOTER_LINE, aDisplayRegionType, true, aDisplayID, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacHideFooterLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacHideFooterLineMultiDisplayReq(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacHideFooterLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacHideFooterLineMultiDisplayReq(aDisplayRegionType = %d, aDisplayID = %d)", aDisplayRegionType,aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::FOOTER_LINE, aDisplayRegionType, false, aDisplayID, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacRegisterForCloseOnTouchSession(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacRegisterForCloseOnTouchSession(::Courier::ViewId(AppHmi_MasterStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacRegisterForCloseOnTouchSession(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacRegisterForCloseOnTouchSession(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendRegisterForCloseOnTouchSessionReqMsg(true, aViewId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacDeregisterForCloseOnTouchSessionReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacDeregisterForCloseOnTouchSessionReq(::Courier::ViewId(AppHmi_MasterStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacDeregisterForCloseOnTouchSessionReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacDeregisterForCloseOnTouchSessionReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendRegisterForCloseOnTouchSessionReqMsg(false, aViewId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterPrioEnableReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacPopupFilterPrioEnableReq(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacPopupFilterPrioEnableReq(Courier::UInt32 const & aPrio)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacPopupFilterPrioEnableReq(aPrio = %d)", aPrio));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupFilterPrioEnableReqMsg(aPrio);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterAllEnableReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacPopupFilterAllEnableReq();
    return true;
}
#endif
void Action_gacPopupFilterAllEnableReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacPopupFilterAllEnableReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupFilterAllEnableReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterDisableReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacPopupFilterDisableReq();
    return true;
}
#endif
void Action_gacPopupFilterDisableReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacPopupFilterDisableReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupFilterDisableReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacProfileChange(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_gacProfileChange(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_gacProfileChange(Courier::UInt32 const & aProfile)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacProfileChange(aProfile = %d)", aProfile));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendProfileSwitchMsg(aProfile);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterPrioEnableReqForDisplay(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacPopupFilterPrioEnableReqForDisplay(parameters[(::Json::Value::UInt)0].asUInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacPopupFilterPrioEnableReqForDisplay(Courier::UInt32 const & aPrio, Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacPopupFilterPrioEnableReqForDisplay(aPrio = %d, aDisplayID = %d)", aPrio,aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendMultiDisplayPopupFilterReqMsg(hmibase::ENABLE_PRIO, aPrio, aDisplayID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterAllEnableReqForDisplay(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacPopupFilterAllEnableReqForDisplay(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacPopupFilterAllEnableReqForDisplay(Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacPopupFilterAllEnableReqForDisplay(aDisplayID = %d)", aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendMultiDisplayPopupFilterReqMsg(hmibase::ENABLE_ALL, 0, aDisplayID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterDisableReqForDisplay(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacPopupFilterDisableReqForDisplay(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacPopupFilterDisableReqForDisplay(Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacPopupFilterDisableReqForDisplay(aDisplayID = %d)", aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendMultiDisplayPopupFilterReqMsg(hmibase::DISABLE_ALL, 0, aDisplayID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacStartSceneTransitionAnimation(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 4) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt() && parameters[(::Json::Value::UInt)2].isUInt() && parameters[(::Json::Value::UInt)3].isInt())) { return false; }
    Action_gacStartSceneTransitionAnimation(::Courier::ViewId(AppHmi_MasterStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt(), ))::Courier::ViewId(AppHmi_MasterStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)1].asUInt(), ))parameters[(::Json::Value::UInt)2].asUInt(), parameters[(::Json::Value::UInt)3].asInt());
    return true;
}
#endif
void Action_gacStartSceneTransitionAnimation(::Courier::ViewId const & aSourceView, ::Courier::ViewId const & aDestinationView, Courier::UInt32 const & aUserData1, Courier::Int8 const & aUserData2)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacStartSceneTransitionAnimation(aSourceView = %50s, aDestinationView = %50s, aUserData1 = %d, aUserData2 = %d)", aSourceView.CStr(),aDestinationView.CStr(),aUserData1,aUserData2));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendCreateNewDestroyOld(aSourceView, aDestinationView, aUserData1, aUserData2);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacDecrementActiveAnimationCount(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacDecrementActiveAnimationCount();
    return true;
}
#endif
void Action_gacDecrementActiveAnimationCount()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_MASTER_SM, "SM_ACTIONS:    Trigger action gacDecrementActiveAnimationCount()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendNotifierMessage();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_fnIsInf4cvSmartVariant(const ::Json::Value& /* parameters */, ::Json::Value &response)
{
    response["result"] = (bool)fnIsInf4cvSmartVariant();
    return true;
}
#endif
// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_fnGetRegionId(const ::Json::Value& /* parameters */, ::Json::Value &response)
{
    response["result"] = (::Json::Value::UInt)fnGetRegionId();
    return true;
}
#endif
// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_fnGetLastActiveCabinRegionId(const ::Json::Value& /* parameters */, ::Json::Value &response)
{
    response["result"] = (::Json::Value::UInt)fnGetLastActiveCabinRegionId();
    return true;
}
#endif
// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_fnGetAudioSinkId(const ::Json::Value& /* parameters */, ::Json::Value &response)
{
    response["result"] = (::Json::Value::UInt)fnGetAudioSinkId();
    return true;
}
#endif
// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_fnGetRegionIdForAudioSink(const ::Json::Value& parameters, ::Json::Value &response)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    response["result"] = (::Json::Value::UInt)fnGetRegionIdForAudioSink((::FeatStd::UInt32)parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_fnGetAudioSinkIdForRegion(const ::Json::Value& parameters, ::Json::Value &response)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    response["result"] = (::Json::Value::UInt)fnGetAudioSinkIdForRegion((::FeatStd::UInt32)parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_fnIsRegionSupported(const ::Json::Value& parameters, ::Json::Value &response)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    response["result"] = (bool)fnIsRegionSupported((::FeatStd::UInt32)parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_fnGetApplicationId(const ::Json::Value& parameters, ::Json::Value &response)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    response["result"] = (::Json::Value::UInt)fnGetApplicationId((::FeatStd::UInt32)parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_fnGetVariantId(const ::Json::Value& /* parameters */, ::Json::Value &response)
{
    response["result"] = (::Json::Value::UInt)fnGetVariantId();
    return true;
}
#endif
// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_fnGetVariantType(const ::Json::Value& /* parameters */, ::Json::Value &response)
{
    response["result"] = (::Json::Value::UInt)fnGetVariantType();
    return true;
}
#endif
// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_fnIsAVRoutingAdaperXMLAvailable(const ::Json::Value& /* parameters */, ::Json::Value &response)
{
    response["result"] = (bool)fnIsAVRoutingAdaperXMLAvailable();
    return true;
}
#endif
//====  defines and includes TTFis output - added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====    

unsigned short AppHmi_MasterStateMachineImpl::GetTraceClass (){  
   return TR_CLASS_APPHMI_MASTER_SM; 
}

//====  member function with TTFis output - end                        key: SM_TTFis_SBHFMSRF ==== 

#include "hmibase/util/Macros.h"

#ifdef CIT_SIMULATION
#define CIT_EVENT_ID(eventId, hashId) hashId
#else
#define CIT_EVENT_ID(eventId, hashId) eventId
#endif
// ------------------------------------------------------------------------
static bool HandleEventMappingForAppFlyInReqMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::AppFlyInReqMsg const & message = static_cast< ::AppFlyInReqMsg const &>(aMessage);

#ifdef onAppFlyInReqVisibleMsg
    if ((message.GetStatus() == true)) { eventId = CIT_EVENT_ID(onAppFlyInReqVisibleMsg, 0x758D7839); return true; }
#endif
#ifdef onAppFlyInReqInVisibleMsg
    if ((message.GetStatus() == false)) { eventId = CIT_EVENT_ID(onAppFlyInReqInVisibleMsg, 0xB3A0564E); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForAppFlyInReqMsg(AppHmi_MasterStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::AppFlyInReqMsg const & message = static_cast< ::AppFlyInReqMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onEncoder_HMI_BASE_1
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onEncoder_HMI_BASE_1 0xffff
#pragma _REMINDER("Using dummy value symbol onEncoder_HMI_BASE_1 ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onEncoder_HMI_BASE_1 -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onEncoderStatusChangedUpdMsg
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onEncoderStatusChangedUpdMsg 0xffff
#pragma _REMINDER("Using dummy value symbol onEncoderStatusChangedUpdMsg ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onEncoderStatusChangedUpdMsg -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onEncoderStatusChanged_RIGHT_ENC
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onEncoderStatusChanged_RIGHT_ENC 0xffff
#pragma _REMINDER("Using dummy value symbol onEncoderStatusChanged_RIGHT_ENC ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onEncoderStatusChanged_RIGHT_ENC -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForEncoderStatusChangedUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::EncoderStatusChangedUpdMsg const & message = static_cast< ::EncoderStatusChangedUpdMsg const &>(aMessage);

#ifdef onEncoder_HMI_BASE_1
    if ((message.GetEncCode() == ENCCODE_HMI_BASE_1)) { eventId = CIT_EVENT_ID(onEncoder_HMI_BASE_1, 0x4D9B3F88); return true; }
#endif
#ifdef onEncoderStatusChanged_RIGHT_ENC
    if ((message.GetEncCode() == ENCCODE_RIGHT_ENCODER)) { eventId = CIT_EVENT_ID(onEncoderStatusChanged_RIGHT_ENC, 0x67E5D82B); return true; }
#endif
    eventId = CIT_EVENT_ID(onEncoderStatusChangedUpdMsg, 0x0625A8CC);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForEncoderStatusChangedUpdMsg(AppHmi_MasterStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::EncoderStatusChangedUpdMsg const & message = static_cast< ::EncoderStatusChangedUpdMsg const &>(aMessage);
#ifdef onEncoder_HMI_BASE_1
    if (eventId == onEncoder_HMI_BASE_1) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetEncSteps()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onEncoder_HMI_BASE_1.EncSteps = message.GetEncSteps();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onEncoderStatusChangedUpdMsg
    if (eventId == onEncoderStatusChangedUpdMsg) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetEncCode(), message.GetEncSteps()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onEncoderStatusChangedUpdMsg.EncCode = message.GetEncCode();
        onClickParam.VSEPS_onEncoderStatusChangedUpdMsg.EncSteps = message.GetEncSteps();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onEncoderStatusChanged_RIGHT_ENC
    if (eventId == onEncoderStatusChanged_RIGHT_ENC) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetEncSteps()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onEncoderStatusChanged_RIGHT_ENC.EncSteps = message.GetEncSteps();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined OnClonedHKStatusChangedUpdMsg
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define OnClonedHKStatusChangedUpdMsg 0xffff
#pragma _REMINDER("Using dummy value symbol OnClonedHKStatusChangedUpdMsg ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol OnClonedHKStatusChangedUpdMsg -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForClonedHKStatusChangedUpdMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnClonedHKStatusChangedUpdMsg, 0x90A5898B);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForClonedHKStatusChangedUpdMsg(AppHmi_MasterStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::ClonedHKStatusChangedUpdMsg const & message = static_cast< ::ClonedHKStatusChangedUpdMsg const &>(aMessage);
#ifdef OnClonedHKStatusChangedUpdMsg
    if (eventId == OnClonedHKStatusChangedUpdMsg) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetHKCode(), message.GetHKState(), message.GetDisplayID(), message.GetUserData()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_OnClonedHKStatusChangedUpdMsg.HKCode = message.GetHKCode();
        onClickParam.VSEPS_OnClonedHKStatusChangedUpdMsg.HKState = message.GetHKState();
        onClickParam.VSEPS_OnClonedHKStatusChangedUpdMsg.DisplayID = message.GetDisplayID();
        onClickParam.VSEPS_OnClonedHKStatusChangedUpdMsg.UserData = message.GetUserData();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined OnClonedSurfaceStateChangedUpdMsg
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define OnClonedSurfaceStateChangedUpdMsg 0xffff
#pragma _REMINDER("Using dummy value symbol OnClonedSurfaceStateChangedUpdMsg ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol OnClonedSurfaceStateChangedUpdMsg -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForClonedSurfaceStateChangedUpdMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnClonedSurfaceStateChangedUpdMsg, 0x5A9FADEA);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForClonedSurfaceStateChangedUpdMsg(AppHmi_MasterStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::ClonedSurfaceStateChangedUpdMsg const & message = static_cast< ::ClonedSurfaceStateChangedUpdMsg const &>(aMessage);
#ifdef OnClonedSurfaceStateChangedUpdMsg
    if (eventId == OnClonedSurfaceStateChangedUpdMsg) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetSurfaceID(), message.GetSurfaceState()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_OnClonedSurfaceStateChangedUpdMsg.SurfaceID = message.GetSurfaceID();
        onClickParam.VSEPS_OnClonedSurfaceStateChangedUpdMsg.SurfaceState = message.GetSurfaceState();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onHKStatusChangedUpdMsg
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onHKStatusChangedUpdMsg 0xffff
#pragma _REMINDER("Using dummy value symbol onHKStatusChangedUpdMsg ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onHKStatusChangedUpdMsg -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForHKStatusChangedUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::HKStatusChangedUpdMsg const & message = static_cast< ::HKStatusChangedUpdMsg const &>(aMessage);

#ifdef onHKStatusChanged_HK_SELECT_UP
    if ((message.GetHKCode() == HARDKEYCODE_HK_SELECT) && (message.GetHKState() == HARDKEYSTATE_UP)) { eventId = CIT_EVENT_ID(onHKStatusChanged_HK_SELECT_UP, 0x263EAF7F); return true; }
#endif
    eventId = CIT_EVENT_ID(onHKStatusChangedUpdMsg, 0x0AD32850);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForHKStatusChangedUpdMsg(AppHmi_MasterStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::HKStatusChangedUpdMsg const & message = static_cast< ::HKStatusChangedUpdMsg const &>(aMessage);
#ifdef onHKStatusChangedUpdMsg
    if (eventId == onHKStatusChangedUpdMsg) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetHKCode(), message.GetHKState(), message.GetDisplayID(), message.GetUserData()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onHKStatusChangedUpdMsg.HKCode = message.GetHKCode();
        onClickParam.VSEPS_onHKStatusChangedUpdMsg.HKState = message.GetHKState();
        onClickParam.VSEPS_onHKStatusChangedUpdMsg.DisplayID = message.GetDisplayID();
        onClickParam.VSEPS_onHKStatusChangedUpdMsg.UserData = message.GetUserData();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForShowHideWaitSceneMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::ShowHideWaitSceneMsg const & message = static_cast< ::ShowHideWaitSceneMsg const &>(aMessage);

#ifdef onShowWaitScene
    if ((message.GetShowhide() == true)) { eventId = CIT_EVENT_ID(onShowWaitScene, 0x034DDF87); return true; }
#endif
#ifdef onHideWaitScene
    if ((message.GetShowhide() == false)) { eventId = CIT_EVENT_ID(onHideWaitScene, 0x1F21354F); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForShowHideWaitSceneMsg(AppHmi_MasterStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::ShowHideWaitSceneMsg const & message = static_cast< ::ShowHideWaitSceneMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForUpdateVINStatusToHMI(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(onUpdateVINStatusToHMI, 0xCD981DE3);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForUpdateVINStatusToHMI(AppHmi_MasterStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onUpdateAntiTheftStatus
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onUpdateAntiTheftStatus 0xffff
#pragma _REMINDER("Using dummy value symbol onUpdateAntiTheftStatus ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onUpdateAntiTheftStatus -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForUpdateAntiTheftStatus(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(onUpdateAntiTheftStatus, 0x46281EA6);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForUpdateAntiTheftStatus(AppHmi_MasterStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::UpdateAntiTheftStatus const & message = static_cast< ::UpdateAntiTheftStatus const &>(aMessage);
#ifdef onUpdateAntiTheftStatus
    if (eventId == onUpdateAntiTheftStatus) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetAntiTheftStatus()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onUpdateAntiTheftStatus.AntiTheftStatus = message.GetAntiTheftStatus();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForActivateRVCSceneMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::ActivateRVCSceneMsg const & message = static_cast< ::ActivateRVCSceneMsg const &>(aMessage);

#ifdef onShow_RVC
    if ((message.GetShowhide() == true)) { eventId = CIT_EVENT_ID(onShow_RVC, 0xAE14DD45); return true; }
#endif
#ifdef onHide_RVC
    if ((message.GetShowhide() == false)) { eventId = CIT_EVENT_ID(onHide_RVC, 0x949ABB48); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActivateRVCSceneMsg(AppHmi_MasterStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::ActivateRVCSceneMsg const & message = static_cast< ::ActivateRVCSceneMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onSwitchApplicationRequest
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onSwitchApplicationRequest 0xffff
#pragma _REMINDER("Using dummy value symbol onSwitchApplicationRequest ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onSwitchApplicationRequest -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForSwitchApplicationMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(onSwitchApplicationRequest, 0x945D15BF);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSwitchApplicationMsg(AppHmi_MasterStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::SwitchApplicationMsg const & message = static_cast< ::SwitchApplicationMsg const &>(aMessage);
#ifdef onSwitchApplicationRequest
    if (eventId == onSwitchApplicationRequest) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetAppID()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onSwitchApplicationRequest.AppID = message.GetAppID();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined OnVolumePopupReq
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define OnVolumePopupReq 0xffff
#pragma _REMINDER("Using dummy value symbol OnVolumePopupReq ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol OnVolumePopupReq -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForVolumePopupReqMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnVolumePopupReq, 0xBC4788F7);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForVolumePopupReqMsg(AppHmi_MasterStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::VolumePopupReqMsg const & message = static_cast< ::VolumePopupReqMsg const &>(aMessage);
#ifdef OnVolumePopupReq
    if (eventId == OnVolumePopupReq) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetU32RegionID()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_OnVolumePopupReq.U32RegionID = message.GetU32RegionID();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined OnMixSourceIndexConnectionStatusReq
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define OnMixSourceIndexConnectionStatusReq 0xffff
#pragma _REMINDER("Using dummy value symbol OnMixSourceIndexConnectionStatusReq ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol OnMixSourceIndexConnectionStatusReq -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForMixSourceIndexConnectionStatusReqMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnMixSourceIndexConnectionStatusReq, 0x55E20523);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForMixSourceIndexConnectionStatusReqMsg(AppHmi_MasterStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::MixSourceIndexConnectionStatusReqMsg const & message = static_cast< ::MixSourceIndexConnectionStatusReqMsg const &>(aMessage);
#ifdef OnMixSourceIndexConnectionStatusReq
    if (eventId == OnMixSourceIndexConnectionStatusReq) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetMixSourceIndex(), message.GetStatus()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_OnMixSourceIndexConnectionStatusReq.MixSourceIndex = message.GetMixSourceIndex();
        onClickParam.VSEPS_OnMixSourceIndexConnectionStatusReq.Status = message.GetStatus();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined OnKDSStatusUpd
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define OnKDSStatusUpd 0xffff
#pragma _REMINDER("Using dummy value symbol OnKDSStatusUpd ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol OnKDSStatusUpd -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForKDSStatusUpdMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnKDSStatusUpd, 0xCA8F2E43);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForKDSStatusUpdMsg(AppHmi_MasterStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::KDSStatusUpdMsg const & message = static_cast< ::KDSStatusUpdMsg const &>(aMessage);
#ifdef OnKDSStatusUpd
    if (eventId == OnKDSStatusUpd) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetStatus()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_OnKDSStatusUpd.Status = message.GetStatus();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForButtonReactionMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::ButtonReactionMsg const & message = static_cast< ::ButtonReactionMsg const &>(aMessage);

#ifdef Disclaimer_Confirm_touch
    if ((message.GetView() == ::Courier::ViewId("M1#Scenes#Disclaimer")) && (message.GetSender() == ::Courier::Identifier(0xfd3966dc /* Layer_Confirm/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(Disclaimer_Confirm_touch, 0x67BDA4C6); return true; }
#endif
#ifdef Activate_Home_CabinA
    if ((message.GetView() == ::Courier::ViewId("Popups#Scenes#HomeScreen_CabinAPopup_Expand")) && (message.GetSender() == ::Courier::Identifier(0x51374742 /* Icon_Home/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(Activate_Home_CabinA, 0xFE1BDED6); return true; }
#endif
#ifdef SetMute_UnMute_CabinA
    if ((message.GetView() == ::Courier::ViewId("Popups#Scenes#HomeScreen_CabinAPopup_Expand")) && (message.GetSender() == ::Courier::Identifier(0x9d4f2835 /* Layer_Mute/ButtonWidget2D_LayerMute */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(SetMute_UnMute_CabinA, 0x51B84F3E); return true; }
#endif
#ifdef Activate_TestMode_CabinA
    if ((message.GetView() == ::Courier::ViewId("Popups#Scenes#HomeScreen_CabinAPopup_Expand")) && (message.GetSender() == ::Courier::Identifier(0xfb2e5c17 /* Icon_Settings/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(Activate_TestMode_CabinA, 0x62869F5F); return true; }
#endif
#ifdef Activate_Settings_CabinA
    if ((message.GetView() == ::Courier::ViewId("Popups#Scenes#HomeScreen_CabinAPopup_Expand")) && (message.GetSender() == ::Courier::Identifier(0xfb2e5c17 /* Icon_Settings/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(Activate_Settings_CabinA, 0x81799F68); return true; }
#endif
#ifdef RepeatIncreaseMicVolumePlusButton
    if ((message.GetView() == ::Courier::ViewId("M1#Scenes#MIC1")) && (message.GetSender() == ::Courier::Identifier(0x7a6da4a1 /* Icon_Plus_Mic/ButtonWidget */)) && (message.GetEnReaction() == enRepeatPressSecondary)) { eventId = CIT_EVENT_ID(RepeatIncreaseMicVolumePlusButton, 0x2EF0C572); return true; }
#endif
#ifdef RepeatReduceMicVolumeMinusButton
    if ((message.GetView() == ::Courier::ViewId("M1#Scenes#MIC1")) && (message.GetSender() == ::Courier::Identifier(0x3e4117b7 /* Icon_Minus_Mic/ButtonWidget */)) && (message.GetEnReaction() == enRepeatPressSecondary)) { eventId = CIT_EVENT_ID(RepeatReduceMicVolumeMinusButton, 0x2D3F751C); return true; }
#endif
#ifdef Reduce_Volume_Minus_Botton_CabinA
    if ((message.GetView() == ::Courier::ViewId("Popups#Scenes#HomeScreen_CabinAPopup_Expand")) && (message.GetSender() == ::Courier::Identifier(0x9f9da9c5 /* Icon_Minus/ButtonWidget */)) && (message.GetEnReaction() == enPress)) { eventId = CIT_EVENT_ID(Reduce_Volume_Minus_Botton_CabinA, 0xD59939F6); return true; }
#endif
#ifdef IncreaseMicVolumePlusButton
    if ((message.GetView() == ::Courier::ViewId("M1#Scenes#MIC1")) && (message.GetSender() == ::Courier::Identifier(0x7a6da4a1 /* Icon_Plus_Mic/ButtonWidget */)) && (message.GetEnReaction() == enPress)) { eventId = CIT_EVENT_ID(IncreaseMicVolumePlusButton, 0x83C4744B); return true; }
#endif
#ifdef SetMicMuteUnMute
    if ((message.GetView() == ::Courier::ViewId("M1#Scenes#MIC1")) && (message.GetSender() == ::Courier::Identifier(0xe4715729 /* Layer_Mute_Mic/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(SetMicMuteUnMute, 0xA471323D); return true; }
#endif
#ifdef ActivateMicHomeCockpit
    if ((message.GetView() == ::Courier::ViewId("M1#Scenes#MIC1")) && (message.GetSender() == ::Courier::Identifier(0x626a7957 /* Icon_Home_Mic/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ActivateMicHomeCockpit, 0x8ED9771A); return true; }
#endif
#ifdef ActivateMICSettings
    if ((message.GetView() == ::Courier::ViewId("M1#Scenes#MIC1")) && (message.GetSender() == ::Courier::Identifier(0xaa0ed3d9 /* Icon_Settings_Mic/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ActivateMICSettings, 0xBE930143); return true; }
#endif
#ifdef Deactivate_Mic
    if ((message.GetView() == ::Courier::ViewId("M1#Scenes#MIC1")) && (message.GetSender() == ::Courier::Identifier(0xe7516b41 /* Icon_Mic_CP/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(Deactivate_Mic, 0x6289368C); return true; }
#endif
#ifdef Activate_Home_Cockpit
    if ((message.GetView() == ::Courier::ViewId("Popups#Scenes#HomeScreen_1_POPUPEXP_DEV")) && (message.GetSender() == ::Courier::Identifier(0x51374742 /* Icon_Home/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(Activate_Home_Cockpit, 0xCC09C306); return true; }
#endif
#ifdef Repeat_Increase_Volume_Plus_Botton
    if ((message.GetView() == ::Courier::ViewId("Popups#Scenes#HomeScreen_1_POPUPEXP_DEV")) && (message.GetSender() == ::Courier::Identifier(0x06ca3c82 /* Icon_Plus/ButtonWidget */)) && (message.GetEnReaction() == enRepeatPressSecondary)) { eventId = CIT_EVENT_ID(Repeat_Increase_Volume_Plus_Botton, 0xCE1EBF2F); return true; }
#endif
#ifdef ReduceMicVolumeMinusButton
    if ((message.GetView() == ::Courier::ViewId("M1#Scenes#MIC1")) && (message.GetSender() == ::Courier::Identifier(0x3e4117b7 /* Icon_Minus_Mic/ButtonWidget */)) && (message.GetEnReaction() == enPress)) { eventId = CIT_EVENT_ID(ReduceMicVolumeMinusButton, 0x379D8A0C); return true; }
#endif
#ifdef Repeat_Reduce_Volume_Minus_Botton
    if ((message.GetView() == ::Courier::ViewId("Popups#Scenes#HomeScreen_1_POPUPEXP_DEV")) && (message.GetSender() == ::Courier::Identifier(0x9f9da9c5 /* Icon_Minus/ButtonWidget */)) && (message.GetEnReaction() == enRepeatPressSecondary)) { eventId = CIT_EVENT_ID(Repeat_Reduce_Volume_Minus_Botton, 0x2B7A6C5C); return true; }
#endif
#ifdef Increase_Volume_Plus_Botton_CabinA
    if ((message.GetView() == ::Courier::ViewId("Popups#Scenes#HomeScreen_CabinAPopup_Expand")) && (message.GetSender() == ::Courier::Identifier(0x06ca3c82 /* Icon_Plus/ButtonWidget */)) && (message.GetEnReaction() == enPress)) { eventId = CIT_EVENT_ID(Increase_Volume_Plus_Botton_CabinA, 0x4E1EB8A8); return true; }
#endif
#ifdef Repeat_Increase_Volume_Plus_Button_CabinA
    if ((message.GetView() == ::Courier::ViewId("Popups#Scenes#HomeScreen_CabinAPopup_Expand")) && (message.GetSender() == ::Courier::Identifier(0x06ca3c82 /* Icon_Plus/ButtonWidget */)) && (message.GetEnReaction() == enRepeatPressSecondary)) { eventId = CIT_EVENT_ID(Repeat_Increase_Volume_Plus_Button_CabinA, 0x0D92ACA6); return true; }
#endif
#ifdef Activate_Cockpit_LongPress
    if ((message.GetView() == ::Courier::ViewId("M1#Scenes#HomeScreen_1_POPUP_DEV")) && (message.GetSender() == ::Courier::Identifier(0xe05634a0 /* Layer_Popup_Drawer_CabinB_Button */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(Activate_Cockpit_LongPress, 0xEDE36127); return true; }
#endif
#ifdef Activate_CabinB_LongPress
    if ((message.GetView() == ::Courier::ViewId("M1#Scenes#HomeScreen_1_POPUP_DEV")) && (message.GetSender() == ::Courier::Identifier(0xd124d7c2 /* Layer_Popup_Drawer_CabinA_Button */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(Activate_CabinB_LongPress, 0x38960CB8); return true; }
#endif
#ifdef Open_VolumePopup_CabinB
    if ((message.GetView() == ::Courier::ViewId("M1#Scenes#HomeScreen_1_POPUP_DEV")) && (message.GetSender() == ::Courier::Identifier(0xe05634a0 /* Layer_Popup_Drawer_CabinB_Button */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(Open_VolumePopup_CabinB, 0x5477484D); return true; }
#endif
#ifdef Open_VolumePopup_CabinA
    if ((message.GetView() == ::Courier::ViewId("M1#Scenes#HomeScreen_1_POPUP_DEV")) && (message.GetSender() == ::Courier::Identifier(0xd124d7c2 /* Layer_Popup_Drawer_CabinA_Button */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(Open_VolumePopup_CabinA, 0x6849EFF2); return true; }
#endif
#ifdef Activate_CabinA
    if ((message.GetView() == ::Courier::ViewId("M1#Scenes#HomeScreen_1_POPUP_DEV")) && (message.GetSender() == ::Courier::Identifier(0xfac77e1b /* Layer_Popup_Drawer_Cockpit_Button */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(Activate_CabinA, 0x67F7468D); return true; }
#endif
#ifdef Open_VolumePopup
    if ((message.GetView() == ::Courier::ViewId("M1#Scenes#HomeScreen_1_POPUP_DEV")) && (message.GetSender() == ::Courier::Identifier(0xfac77e1b /* Layer_Popup_Drawer_Cockpit_Button */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(Open_VolumePopup, 0x15C91912); return true; }
#endif
#ifdef Repeat_Reduce_Volume_Minus_Button_CabinA
    if ((message.GetView() == ::Courier::ViewId("Popups#Scenes#HomeScreen_CabinAPopup_Expand")) && (message.GetSender() == ::Courier::Identifier(0x9f9da9c5 /* Icon_Minus/ButtonWidget */)) && (message.GetEnReaction() == enRepeatPressSecondary)) { eventId = CIT_EVENT_ID(Repeat_Reduce_Volume_Minus_Button_CabinA, 0x0BCB3B05); return true; }
#endif
#ifdef Repeat_Increase_Volume_Plus_Button_CabinB
    if ((message.GetView() == ::Courier::ViewId("Popups#Scenes#HomeScreen_CabinBPopup_Expand")) && (message.GetSender() == ::Courier::Identifier(0x06ca3c82 /* Icon_Plus/ButtonWidget */)) && (message.GetEnReaction() == enRepeatPressSecondary)) { eventId = CIT_EVENT_ID(Repeat_Increase_Volume_Plus_Button_CabinB, 0x02DB9738); return true; }
#endif
#ifdef Increase_Volume_Plus_Botton_CabinB
    if ((message.GetView() == ::Courier::ViewId("Popups#Scenes#HomeScreen_CabinBPopup_Expand")) && (message.GetSender() == ::Courier::Identifier(0x06ca3c82 /* Icon_Plus/ButtonWidget */)) && (message.GetEnReaction() == enPress)) { eventId = CIT_EVENT_ID(Increase_Volume_Plus_Botton_CabinB, 0x256E6748); return true; }
#endif
#ifdef Reduce_Volume_Minus_Botton_CabinB
    if ((message.GetView() == ::Courier::ViewId("Popups#Scenes#HomeScreen_CabinBPopup_Expand")) && (message.GetSender() == ::Courier::Identifier(0x9f9da9c5 /* Icon_Minus/ButtonWidget */)) && (message.GetEnReaction() == enPress)) { eventId = CIT_EVENT_ID(Reduce_Volume_Minus_Botton_CabinB, 0xF9B28228); return true; }
#endif
#ifdef Activate_Home_CabinB
    if ((message.GetView() == ::Courier::ViewId("Popups#Scenes#HomeScreen_CabinBPopup_Expand")) && (message.GetSender() == ::Courier::Identifier(0x51374742 /* Icon_Home/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(Activate_Home_CabinB, 0xF36C49AB); return true; }
#endif
#ifdef SetMute_UnMute_CabinB
    if ((message.GetView() == ::Courier::ViewId("Popups#Scenes#HomeScreen_CabinBPopup_Expand")) && (message.GetSender() == ::Courier::Identifier(0xb728abce /* Layer_Mute/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(SetMute_UnMute_CabinB, 0x637272B2); return true; }
#endif
#ifdef Activate_TestMode_CabinB
    if ((message.GetView() == ::Courier::ViewId("Popups#Scenes#HomeScreen_CabinBPopup_Expand")) && (message.GetSender() == ::Courier::Identifier(0xfb2e5c17 /* Icon_Settings/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(Activate_TestMode_CabinB, 0x132900A5); return true; }
#endif
#ifdef Activate_Settings_CabinB
    if ((message.GetView() == ::Courier::ViewId("Popups#Scenes#HomeScreen_CabinBPopup_Expand")) && (message.GetSender() == ::Courier::Identifier(0xfb2e5c17 /* Icon_Settings/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(Activate_Settings_CabinB, 0x54B945E8); return true; }
#endif
#ifdef Repeat_Reduce_Volume_Minus_Button_CabinB
    if ((message.GetView() == ::Courier::ViewId("Popups#Scenes#HomeScreen_CabinBPopup_Expand")) && (message.GetSender() == ::Courier::Identifier(0x9f9da9c5 /* Icon_Minus/ButtonWidget */)) && (message.GetEnReaction() == enRepeatPressSecondary)) { eventId = CIT_EVENT_ID(Repeat_Reduce_Volume_Minus_Button_CabinB, 0xB98C9689); return true; }
#endif
#ifdef HourLogicMode_Continue
    if ((message.GetView() == ::Courier::ViewId("Popups#Scenes#Pfo_HourLogicMode")) && (message.GetSender() == ::Courier::Identifier(0x4b234336 /* Layer_Continue/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(HourLogicMode_Continue, 0x0808D9CF); return true; }
#endif
#ifdef Increase_Volume_Plus_Botton
    if ((message.GetView() == ::Courier::ViewId("Popups#Scenes#HomeScreen_1_POPUPEXP_DEV")) && (message.GetSender() == ::Courier::Identifier(0x06ca3c82 /* Icon_Plus/ButtonWidget */)) && (message.GetEnReaction() == enPress)) { eventId = CIT_EVENT_ID(Increase_Volume_Plus_Botton, 0x34673BD1); return true; }
#endif
#ifdef Activate_MapOut_CabinA_Icon
    if ((message.GetView() == ::Courier::ViewId("M1#Scenes#HomeScreen_CabinA")) && (message.GetSender() == ::Courier::Identifier(0x48c65c66 /* Icon_Mapout/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(Activate_MapOut_CabinA_Icon, 0xB5F09FC6); return true; }
#endif
#ifdef Activate_CabinB
    if ((message.GetView() == ::Courier::ViewId("M1#Scenes#HomeScreen_CabinA")) && (message.GetSender() == ::Courier::Identifier(0x2667e042 /* Clock/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(Activate_CabinB, 0xE613C2C4); return true; }
#endif
#ifdef Activate_Navigation
    if ((message.GetView() == ::Courier::ViewId("M1#Scenes#MasterHome")) && (message.GetSender() == ::Courier::Identifier(0xe66c1f99 /* TouchArea_NaviBtn/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(Activate_Navigation, 0x5A5C6538); return true; }
#endif
#ifdef Activate_SPI
    if ((message.GetView() == ::Courier::ViewId("M1#Scenes#MasterHome")) && (message.GetSender() == ::Courier::Identifier(0x1438113a /* TouchArea_SPIBtn/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(Activate_SPI, 0x4B68C684); return true; }
#endif
#ifdef Activate_BTPhone
    if ((message.GetView() == ::Courier::ViewId("M1#Scenes#MasterHome")) && (message.GetSender() == ::Courier::Identifier(0x5f5622dd /* TouchArea_PhoneBtn/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(Activate_BTPhone, 0x802D7A04); return true; }
#endif
#ifdef Activate_Media
    if ((message.GetView() == ::Courier::ViewId("M1#Scenes#MasterHome")) && (message.GetSender() == ::Courier::Identifier(0x3ecf4c0d /* TouchArea_MediaBtn/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(Activate_Media, 0x310E1189); return true; }
#endif
#ifdef Activate_Tuner
    if ((message.GetView() == ::Courier::ViewId("M1#Scenes#MasterHome")) && (message.GetSender() == ::Courier::Identifier(0x26df6cf0 /* TouchArea_TunerBtn/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(Activate_Tuner, 0x9E364C3D); return true; }
#endif
#ifdef Activate_MapOut_CabinA
    if ((message.GetView() == ::Courier::ViewId("M1#Scenes#HomeScreen_CabinA")) && (message.GetSender() == ::Courier::Identifier(0x0c5c0172 /* TouchArea_MapoutBtn/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(Activate_MapOut_CabinA, 0x07F7DB9E); return true; }
#endif
#ifdef Activate_Camera
    if ((message.GetView() == ::Courier::ViewId("M1#Scenes#MasterHome")) && (message.GetSender() == ::Courier::Identifier(0x09b79f8d /* TouchArea_CameraBtn/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(Activate_Camera, 0x46A0ACCC); return true; }
#endif
#ifdef Activate_Camera4
    if ((message.GetView() == ::Courier::ViewId("M1#Scenes#RVC_TESTMODE")) && (message.GetSender() == ::Courier::Identifier(0xf325e817 /* Btn_Cam4/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(Activate_Camera4, 0x728E7B49); return true; }
#endif
#ifdef Activate_Camera3
    if ((message.GetView() == ::Courier::ViewId("M1#Scenes#RVC_TESTMODE")) && (message.GetSender() == ::Courier::Identifier(0xb8b85f9b /* Btn_Cam3/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(Activate_Camera3, 0x00E797FD); return true; }
#endif
#ifdef Activate_Camera2
    if ((message.GetView() == ::Courier::ViewId("M1#Scenes#RVC_TESTMODE")) && (message.GetSender() == ::Courier::Identifier(0x797018ba /* Btn_Cam2/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(Activate_Camera2, 0x36318290); return true; }
#endif
#ifdef Activate_Camera1
    if ((message.GetView() == ::Courier::ViewId("M1#Scenes#RVC_TESTMODE")) && (message.GetSender() == ::Courier::Identifier(0xccf6e53a /* Btn_Cam1/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(Activate_Camera1, 0x6382DD32); return true; }
#endif
#ifdef Activate_MIC
    if ((message.GetView() == ::Courier::ViewId("Popups#Scenes#HomeScreen_1_POPUPEXP_DEV")) && (message.GetSender() == ::Courier::Identifier(0xfab88387 /* Icon_Mic/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(Activate_MIC, 0x9FFDA16E); return true; }
#endif
#ifdef Activate_BackFROMRVC
    if ((message.GetView() == ::Courier::ViewId("M1#Scenes#RVC_TESTMODE")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(Activate_BackFROMRVC, 0x4C065E5A); return true; }
#endif
#ifdef Activate_CameraOff
    if ((message.GetView() == ::Courier::ViewId("M1#Scenes#RVC_TESTMODE")) && (message.GetSender() == ::Courier::Identifier(0xb643f47a /* Btn_CamOff/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(Activate_CameraOff, 0x29832AC7); return true; }
#endif
#ifdef Reduce_Volume_Minus_Botton
    if ((message.GetView() == ::Courier::ViewId("Popups#Scenes#HomeScreen_1_POPUPEXP_DEV")) && (message.GetSender() == ::Courier::Identifier(0x9f9da9c5 /* Icon_Minus/ButtonWidget */)) && (message.GetEnReaction() == enPress)) { eventId = CIT_EVENT_ID(Reduce_Volume_Minus_Botton, 0x1565647B); return true; }
#endif
#ifdef HourLogicMode_Abort
    if ((message.GetView() == ::Courier::ViewId("Popups#Scenes#Pfo_HourLogicMode")) && (message.GetSender() == ::Courier::Identifier(0x9a3e3daf /* Layer_Abort/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(HourLogicMode_Abort, 0x4ECC3C16); return true; }
#endif
#ifdef Activate_Media_CabinA
    if ((message.GetView() == ::Courier::ViewId("M1#Scenes#HomeScreen_CabinA")) && (message.GetSender() == ::Courier::Identifier(0x148b8186 /* TouchArea_Media_Btn/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(Activate_Media_CabinA, 0xC1AF66AA); return true; }
#endif
#ifdef OnSettingsButtonShortRelease
    if ((message.GetView() == ::Courier::ViewId("Popups#Scenes#HomeScreen_1_POPUPEXP_DEV")) && (message.GetSender() == ::Courier::Identifier(0xfb2e5c17 /* Icon_Settings/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnSettingsButtonShortRelease, 0x55417052); return true; }
#endif
#ifdef OnSpeechButtonLongRelease
    if ((message.GetView() == ::Courier::ViewId("Popups#Scenes#HomeScreen_1_POPUPEXP_DEV")) && (message.GetSender() == ::Courier::Identifier(0x651ee50d /* Icon_Speech/ButtonWidget */)) && (message.GetEnReaction() == enLongPressRelease)) { eventId = CIT_EVENT_ID(OnSpeechButtonLongRelease, 0xAFC3F5BB); return true; }
#endif
#ifdef OnSpeechButtonLongPress
    if ((message.GetView() == ::Courier::ViewId("Popups#Scenes#HomeScreen_1_POPUPEXP_DEV")) && (message.GetSender() == ::Courier::Identifier(0x651ee50d /* Icon_Speech/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(OnSpeechButtonLongPress, 0xA1CFF4A5); return true; }
#endif
#ifdef OnSpeechButtonShortRelease
    if ((message.GetView() == ::Courier::ViewId("Popups#Scenes#HomeScreen_1_POPUPEXP_DEV")) && (message.GetSender() == ::Courier::Identifier(0x651ee50d /* Icon_Speech/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnSpeechButtonShortRelease, 0x62959CC0); return true; }
#endif
#ifdef Activate_Camera_CabinA
    if ((message.GetView() == ::Courier::ViewId("M1#Scenes#HomeScreen_CabinA")) && (message.GetSender() == ::Courier::Identifier(0x09b79f8d /* TouchArea_CameraBtn/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(Activate_Camera_CabinA, 0x5220A7C6); return true; }
#endif
#ifdef Activate_Tuner_CabinB
    if ((message.GetView() == ::Courier::ViewId("M1#Scenes#HomeScreen_CabinB")) && (message.GetSender() == ::Courier::Identifier(0x26df6cf0 /* TouchArea_TunerBtn/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(Activate_Tuner_CabinB, 0x92783F1D); return true; }
#endif
#ifdef OnSpeechButtonShortPress
    if ((message.GetView() == ::Courier::ViewId("Popups#Scenes#HomeScreen_1_POPUPEXP_DEV")) && (message.GetSender() == ::Courier::Identifier(0x651ee50d /* Icon_Speech/ButtonWidget */)) && (message.GetEnReaction() == enPress)) { eventId = CIT_EVENT_ID(OnSpeechButtonShortPress, 0x4D164416); return true; }
#endif
#ifdef Activate_Camera_CabinB
    if ((message.GetView() == ::Courier::ViewId("M1#Scenes#HomeScreen_CabinB")) && (message.GetSender() == ::Courier::Identifier(0x09b79f8d /* TouchArea_CameraBtn/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(Activate_Camera_CabinB, 0x051A0DBA); return true; }
#endif
#ifdef Activate_MapOut_CabinB_Icon
    if ((message.GetView() == ::Courier::ViewId("M1#Scenes#HomeScreen_CabinB")) && (message.GetSender() == ::Courier::Identifier(0x48c65c66 /* Icon_Mapout/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(Activate_MapOut_CabinB_Icon, 0x694BD271); return true; }
#endif
#ifdef Activate_MapOut_CabinB
    if ((message.GetView() == ::Courier::ViewId("M1#Scenes#HomeScreen_CabinB")) && (message.GetSender() == ::Courier::Identifier(0x0c5c0172 /* TouchArea_MapoutBtn/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(Activate_MapOut_CabinB, 0xB99CBEE9); return true; }
#endif
#ifdef Activate_Cockpit
    if ((message.GetView() == ::Courier::ViewId("M1#Scenes#HomeScreen_CabinB")) && (message.GetSender() == ::Courier::Identifier(0x2667e042 /* Clock/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(Activate_Cockpit, 0x8DA20221); return true; }
#endif
#ifdef Activate_Tuner_CabinA
    if ((message.GetView() == ::Courier::ViewId("M1#Scenes#HomeScreen_CabinA")) && (message.GetSender() == ::Courier::Identifier(0x26df6cf0 /* TouchArea_TunerBtn/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(Activate_Tuner_CabinA, 0xC9C6AD61); return true; }
#endif
#ifdef Activate_Media_CabinB
    if ((message.GetView() == ::Courier::ViewId("M1#Scenes#HomeScreen_CabinB")) && (message.GetSender() == ::Courier::Identifier(0x148b8186 /* TouchArea_Media_Btn/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(Activate_Media_CabinB, 0x9CF11D2E); return true; }
#endif
#ifdef Activate_TestMode
    if ((message.GetSender() == ::Courier::Identifier(0xfb2e5c17 /* Icon_Settings/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(Activate_TestMode, 0x0C67441E); return true; }
#endif
#ifdef SetMute_UnMute
    if ((message.GetSender() == ::Courier::Identifier(0xb728abce /* Layer_Mute/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(SetMute_UnMute, 0xB2E48221); return true; }
#endif
#ifdef Close_VolumePopup
    if ((message.GetSender() == ::Courier::Identifier(0x8f405398 /* icon_close/Button */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(Close_VolumePopup, 0xC5C44F28); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForButtonReactionMsg(AppHmi_MasterStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::ButtonReactionMsg const & message = static_cast< ::ButtonReactionMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForHMIAppsInitializedUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::HMIAppsInitializedUpdMsg const & message = static_cast< ::HMIAppsInitializedUpdMsg const &>(aMessage);

#ifdef onHMIAppsInitialized
    if ((message.GetState() == true)) { eventId = CIT_EVENT_ID(onHMIAppsInitialized, 0x48678D34); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForHMIAppsInitializedUpdMsg(AppHmi_MasterStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::HMIAppsInitializedUpdMsg const & message = static_cast< ::HMIAppsInitializedUpdMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForPlayBeepReqMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::PlayBeepReqMsg const & message = static_cast< ::PlayBeepReqMsg const &>(aMessage);

#ifdef onPlayBeep_ERROR
    if ((message.GetBeepType() == BEEPTYPE_ERROR)) { eventId = CIT_EVENT_ID(onPlayBeep_ERROR, 0xF5767F4A); return true; }
#endif
#ifdef onPlayBeep_ROGER
    if ((message.GetBeepType() == BEEPTYPE_ROGER)) { eventId = CIT_EVENT_ID(onPlayBeep_ROGER, 0x0AD24BE6); return true; }
#endif
#ifdef onPlayBeep_WARN
    if ((message.GetBeepType() == BEEPTYPE_WARN)) { eventId = CIT_EVENT_ID(onPlayBeep_WARN, 0xB948BDA5); return true; }
#endif
#ifdef onPlayBeep_SPEED_WARN
    if ((message.GetBeepType() == BEEPTYPE_SPEED_WARN)) { eventId = CIT_EVENT_ID(onPlayBeep_SPEED_WARN, 0xD374E5C8); return true; }
#endif
#ifdef onPlayBeep_CLICK
    if ((message.GetBeepType() == BEEPTYPE_CLICK)) { eventId = CIT_EVENT_ID(onPlayBeep_CLICK, 0xBA6DE6FA); return true; }
#endif
#ifdef onPlayBeep_POI
    if ((message.GetBeepType() == BEEPTYPE_POI)) { eventId = CIT_EVENT_ID(onPlayBeep_POI, 0xA7CB2497); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForPlayBeepReqMsg(AppHmi_MasterStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::PlayBeepReqMsg const & message = static_cast< ::PlayBeepReqMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForEvalSubSurfaceReqMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::EvalSubSurfaceReqMsg const & message = static_cast< ::EvalSubSurfaceReqMsg const &>(aMessage);

#ifdef OnEvalSubSurfaceReqMsg_STATUS_LINE_appHmi_Master
    if ((message.GetDisplayRegion() == STATUS_LINE) && (message.GetApplicationName() == appHmi_Master)) { eventId = CIT_EVENT_ID(OnEvalSubSurfaceReqMsg_STATUS_LINE_appHmi_Master, 0x267B4627); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForEvalSubSurfaceReqMsg(AppHmi_MasterStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::EvalSubSurfaceReqMsg const & message = static_cast< ::EvalSubSurfaceReqMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForShowFirstHMIAppRequestMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(onShowFirstHMIAppRequest, 0xC43F1CE1);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForShowFirstHMIAppRequestMsg(AppHmi_MasterStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForShowTempHMIAppRequestMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(onShowTempHMIAppRequestMsg, 0x051C2A90);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForShowTempHMIAppRequestMsg(AppHmi_MasterStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForExpiredDisclaimerTimerMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(onExpiredDisclaimerTimerMsg, 0x99196F0A);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForExpiredDisclaimerTimerMsg(AppHmi_MasterStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onHMIStateChange
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onHMIStateChange 0xffff
#pragma _REMINDER("Using dummy value symbol onHMIStateChange ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onHMIStateChange -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForupdateHMIStateChange(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(onHMIStateChange, 0x3358CB6E);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForupdateHMIStateChange(AppHmi_MasterStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::updateHMIStateChange const & message = static_cast< ::updateHMIStateChange const &>(aMessage);
#ifdef onHMIStateChange
    if (eventId == onHMIStateChange) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetHmiState()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onHMIStateChange.HmiState = message.GetHmiState();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onCenterPopupSurfaceInvisible
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onCenterPopupSurfaceInvisible 0xffff
#pragma _REMINDER("Using dummy value symbol onCenterPopupSurfaceInvisible ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onCenterPopupSurfaceInvisible -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onCenterPopupSurfaceVisible
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onCenterPopupSurfaceVisible 0xffff
#pragma _REMINDER("Using dummy value symbol onCenterPopupSurfaceVisible ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onCenterPopupSurfaceVisible -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onCenterPopupSurfaceUnqueued
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onCenterPopupSurfaceUnqueued 0xffff
#pragma _REMINDER("Using dummy value symbol onCenterPopupSurfaceUnqueued ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onCenterPopupSurfaceUnqueued -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onCenterPopupSurfaceQueued
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onCenterPopupSurfaceQueued 0xffff
#pragma _REMINDER("Using dummy value symbol onCenterPopupSurfaceQueued ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onCenterPopupSurfaceQueued -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onControlPanelPopupSurfaceInvisible
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onControlPanelPopupSurfaceInvisible 0xffff
#pragma _REMINDER("Using dummy value symbol onControlPanelPopupSurfaceInvisible ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onControlPanelPopupSurfaceInvisible -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onControlPanelPopupSurfaceVisible
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onControlPanelPopupSurfaceVisible 0xffff
#pragma _REMINDER("Using dummy value symbol onControlPanelPopupSurfaceVisible ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onControlPanelPopupSurfaceVisible -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onControlPanelPopupSurfaceUnqueued
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onControlPanelPopupSurfaceUnqueued 0xffff
#pragma _REMINDER("Using dummy value symbol onControlPanelPopupSurfaceUnqueued ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onControlPanelPopupSurfaceUnqueued -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onControlPanelPopupSurfaceQueued
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onControlPanelPopupSurfaceQueued 0xffff
#pragma _REMINDER("Using dummy value symbol onControlPanelPopupSurfaceQueued ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onControlPanelPopupSurfaceQueued -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onAppFlyinButtonInvisible
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onAppFlyinButtonInvisible 0xffff
#pragma _REMINDER("Using dummy value symbol onAppFlyinButtonInvisible ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onAppFlyinButtonInvisible -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onAppFlyinButtonVisible
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onAppFlyinButtonVisible 0xffff
#pragma _REMINDER("Using dummy value symbol onAppFlyinButtonVisible ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onAppFlyinButtonVisible -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onPopupVisible
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onPopupVisible 0xffff
#pragma _REMINDER("Using dummy value symbol onPopupVisible ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onPopupVisible -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onPopupUnqueued
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onPopupUnqueued 0xffff
#pragma _REMINDER("Using dummy value symbol onPopupUnqueued ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onPopupUnqueued -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onPopupQueued
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onPopupQueued 0xffff
#pragma _REMINDER("Using dummy value symbol onPopupQueued ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onPopupQueued -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForSurfaceStateChangedUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);

#ifdef onCenterPopupSurfaceInvisible
    if ((message.GetSurfaceId() == SURFACEID_CENTER_POPUP_SURFACE_MASTER) && (message.GetState() == SURFACESTATE_INVISIBLE)) { eventId = CIT_EVENT_ID(onCenterPopupSurfaceInvisible, 0x9BDB722F); return true; }
#endif
#ifdef onCommonButtonQueued
    if ((message.GetSurfaceId() == SUB_SURFACEID_COMMONBUTTON_SURFACE) && (message.GetState() == SURFACESTATE_QUEUED)) { eventId = CIT_EVENT_ID(onCommonButtonQueued, 0x6FA6513F); return true; }
#endif
#ifdef onCommonButtonUnqueued
    if ((message.GetSurfaceId() == SUB_SURFACEID_COMMONBUTTON_SURFACE) && (message.GetState() == SURFACESTATE_UNQUEUED)) { eventId = CIT_EVENT_ID(onCommonButtonUnqueued, 0xEB463F9F); return true; }
#endif
#ifdef onCommonButtonVisible
    if ((message.GetSurfaceId() == SUB_SURFACEID_COMMONBUTTON_SURFACE) && (message.GetState() == SURFACESTATE_VISIBLE)) { eventId = CIT_EVENT_ID(onCommonButtonVisible, 0xD8CF464D); return true; }
#endif
#ifdef onCommonButtonInvisible
    if ((message.GetSurfaceId() == SUB_SURFACEID_COMMONBUTTON_SURFACE) && (message.GetState() == SURFACESTATE_INVISIBLE)) { eventId = CIT_EVENT_ID(onCommonButtonInvisible, 0x9208B57C); return true; }
#endif
#ifdef onAppFlyinButtonVisible
    if ((message.GetSurfaceId() == SUB_SURFACEID_APPFLYIN_SURFACE) && (message.GetState() == SURFACESTATE_VISIBLE)) { eventId = CIT_EVENT_ID(onAppFlyinButtonVisible, 0x64813382); return true; }
#endif
#ifdef onControlPanelPopupSurfaceQueued
    if ((message.GetSurfaceId() == SURFACEID_CONTROLPANEL_POPUP_SURFACE) && (message.GetState() == SURFACESTATE_QUEUED)) { eventId = CIT_EVENT_ID(onControlPanelPopupSurfaceQueued, 0x4E3BB250); return true; }
#endif
#ifdef onAppFlyinButtonInvisible
    if ((message.GetSurfaceId() == SUB_SURFACEID_APPFLYIN_SURFACE) && (message.GetState() == SURFACESTATE_INVISIBLE)) { eventId = CIT_EVENT_ID(onAppFlyinButtonInvisible, 0x52B62830); return true; }
#endif
#ifdef onControlPanelPopupSurfaceVisible
    if ((message.GetSurfaceId() == SURFACEID_CONTROLPANEL_POPUP_SURFACE) && (message.GetState() == SURFACESTATE_VISIBLE)) { eventId = CIT_EVENT_ID(onControlPanelPopupSurfaceVisible, 0xC2EBA35E); return true; }
#endif
#ifdef onControlPanelPopupSurfaceInvisible
    if ((message.GetSurfaceId() == SURFACEID_CONTROLPANEL_POPUP_SURFACE) && (message.GetState() == SURFACESTATE_INVISIBLE)) { eventId = CIT_EVENT_ID(onControlPanelPopupSurfaceInvisible, 0xBD2A8102); return true; }
#endif
#ifdef onCenterPopupSurfaceQueued
    if ((message.GetSurfaceId() == SURFACEID_CENTER_POPUP_SURFACE_MASTER) && (message.GetState() == SURFACESTATE_QUEUED)) { eventId = CIT_EVENT_ID(onCenterPopupSurfaceQueued, 0xFC0D2293); return true; }
#endif
#ifdef onCenterPopupSurfaceUnqueued
    if ((message.GetSurfaceId() == SURFACEID_CENTER_POPUP_SURFACE_MASTER) && (message.GetState() == SURFACESTATE_UNQUEUED)) { eventId = CIT_EVENT_ID(onCenterPopupSurfaceUnqueued, 0xAA79C7DD); return true; }
#endif
#ifdef onCenterPopupSurfaceVisible
    if ((message.GetSurfaceId() == SURFACEID_CENTER_POPUP_SURFACE_MASTER) && (message.GetState() == SURFACESTATE_VISIBLE)) { eventId = CIT_EVENT_ID(onCenterPopupSurfaceVisible, 0x23B97E51); return true; }
#endif
#ifdef onControlPanelPopupSurfaceUnqueued
    if ((message.GetSurfaceId() == SURFACEID_CONTROLPANEL_POPUP_SURFACE) && (message.GetState() == SURFACESTATE_UNQUEUED)) { eventId = CIT_EVENT_ID(onControlPanelPopupSurfaceUnqueued, 0x258C5241); return true; }
#endif
#ifdef onPopupUnqueued
    if ((message.GetState() == SURFACESTATE_UNQUEUED)) { eventId = CIT_EVENT_ID(onPopupUnqueued, 0xDB0D29F4); return true; }
#endif
#ifdef onPopupVisible
    if ((message.GetState() == SURFACESTATE_VISIBLE)) { eventId = CIT_EVENT_ID(onPopupVisible, 0xB78D7AE0); return true; }
#endif
#ifdef onPopupQueued
    if ((message.GetState() == SURFACESTATE_QUEUED)) { eventId = CIT_EVENT_ID(onPopupQueued, 0xBBE6896C); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSurfaceStateChangedUpdMsg(AppHmi_MasterStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
#ifdef onCenterPopupSurfaceInvisible
    if (eventId == onCenterPopupSurfaceInvisible) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onCenterPopupSurfaceInvisible.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onCenterPopupSurfaceVisible
    if (eventId == onCenterPopupSurfaceVisible) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onCenterPopupSurfaceVisible.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onCenterPopupSurfaceUnqueued
    if (eventId == onCenterPopupSurfaceUnqueued) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onCenterPopupSurfaceUnqueued.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onCenterPopupSurfaceQueued
    if (eventId == onCenterPopupSurfaceQueued) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onCenterPopupSurfaceQueued.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onControlPanelPopupSurfaceInvisible
    if (eventId == onControlPanelPopupSurfaceInvisible) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onControlPanelPopupSurfaceInvisible.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onControlPanelPopupSurfaceVisible
    if (eventId == onControlPanelPopupSurfaceVisible) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onControlPanelPopupSurfaceVisible.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onControlPanelPopupSurfaceUnqueued
    if (eventId == onControlPanelPopupSurfaceUnqueued) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onControlPanelPopupSurfaceUnqueued.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onControlPanelPopupSurfaceQueued
    if (eventId == onControlPanelPopupSurfaceQueued) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onControlPanelPopupSurfaceQueued.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onAppFlyinButtonInvisible
    if (eventId == onAppFlyinButtonInvisible) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onAppFlyinButtonInvisible.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onAppFlyinButtonVisible
    if (eventId == onAppFlyinButtonVisible) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onAppFlyinButtonVisible.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onPopupVisible
    if (eventId == onPopupVisible) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onPopupVisible.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onPopupUnqueued
    if (eventId == onPopupUnqueued) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onPopupUnqueued.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onPopupQueued
    if (eventId == onPopupQueued) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onPopupQueued.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForCloseOnTouchReqMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::CloseOnTouchReqMsg const & message = static_cast< ::CloseOnTouchReqMsg const &>(aMessage);

#ifdef onCockpitControlPanelPopupCloseOnTouchReq
    if ((message.GetViewId() == ::Courier::ViewId("Popups#Scenes#HomeScreen_1_POPUPEXP_DEV")) && (message.GetTouchState() == ::Courier::TouchMsgState::Down)) { eventId = CIT_EVENT_ID(onCockpitControlPanelPopupCloseOnTouchReq, 0xE63C1E3C); return true; }
#endif
#ifdef onCabinAControlPanelPopupCloseOnTouchReq
    if ((message.GetViewId() == ::Courier::ViewId("Popups#Scenes#HomeScreen_CabinAPopup_Expand")) && (message.GetTouchState() == ::Courier::TouchMsgState::Down)) { eventId = CIT_EVENT_ID(onCabinAControlPanelPopupCloseOnTouchReq, 0x9FDF9FD5); return true; }
#endif
#ifdef onCabinBControlPanelPopupCloseOnTouchReq
    if ((message.GetViewId() == ::Courier::ViewId("Popups#Scenes#HomeScreen_CabinBPopup_Expand")) && (message.GetTouchState() == ::Courier::TouchMsgState::Down)) { eventId = CIT_EVENT_ID(onCabinBControlPanelPopupCloseOnTouchReq, 0x8BABC231); return true; }
#endif
#ifdef onSourcePopupCloseOnTouchReq
    if ((message.GetViewId() == ::Courier::ViewId("Popups#Scenes#SRC_Cockpit")) && (message.GetTouchState() == ::Courier::TouchMsgState::Down)) { eventId = CIT_EVENT_ID(onSourcePopupCloseOnTouchReq, 0x0F52F9D4); return true; }
#endif
#ifdef onSourceCabinPopupCloseOnTouchReq
    if ((message.GetViewId() == ::Courier::ViewId("Popups#Scenes#SRC_Cabin")) && (message.GetTouchState() == ::Courier::TouchMsgState::Down)) { eventId = CIT_EVENT_ID(onSourceCabinPopupCloseOnTouchReq, 0x72D23EFA); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForCloseOnTouchReqMsg(AppHmi_MasterStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::CloseOnTouchReqMsg const & message = static_cast< ::CloseOnTouchReqMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForEvalCommonButtonActivationRequestMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::EvalCommonButtonActivationRequestMsg const & message = static_cast< ::EvalCommonButtonActivationRequestMsg const &>(aMessage);

#ifdef onEvalCommonButtonActivationRequest
    if ((message.GetActiveStatus() == true)) { eventId = CIT_EVENT_ID(onEvalCommonButtonActivationRequest, 0x2CF4AC87); return true; }
#endif
#ifdef onEvalCommonButtonDeactivationRequest
    if ((message.GetActiveStatus() == false)) { eventId = CIT_EVENT_ID(onEvalCommonButtonDeactivationRequest, 0x75331251); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForEvalCommonButtonActivationRequestMsg(AppHmi_MasterStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::EvalCommonButtonActivationRequestMsg const & message = static_cast< ::EvalCommonButtonActivationRequestMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForMmiStateStatusUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::MmiStateStatusUpdMsg const & message = static_cast< ::MmiStateStatusUpdMsg const &>(aMessage);

#ifdef OnMmiStateStatusUpd_FULL_USER
    if ((message.GetMmiState() == MMISTATE_ON_FULL)) { eventId = CIT_EVENT_ID(OnMmiStateStatusUpd_FULL_USER, 0x8C79F875); return true; }
#endif
#ifdef OnMmiStateStatusUpd_FULL_STANDBY
    if ((message.GetMmiState() == MMISTATE_ON_FULL_STANDBY)) { eventId = CIT_EVENT_ID(OnMmiStateStatusUpd_FULL_STANDBY, 0xC651C60D); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForMmiStateStatusUpdMsg(AppHmi_MasterStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::MmiStateStatusUpdMsg const & message = static_cast< ::MmiStateStatusUpdMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined OnMICStatusUpdate
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define OnMICStatusUpdate 0xffff
#pragma _REMINDER("Using dummy value symbol OnMICStatusUpdate ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol OnMICStatusUpdate -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForMicStatus(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnMICStatusUpdate, 0xBAC42E68);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForMicStatus(AppHmi_MasterStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::MicStatus const & message = static_cast< ::MicStatus const &>(aMessage);
#ifdef OnMICStatusUpdate
    if (eventId == OnMICStatusUpdate) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetStatus()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_OnMICStatusUpdate.Status = message.GetStatus();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined OnCMCAVDECCDisconnected
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define OnCMCAVDECCDisconnected 0xffff
#pragma _REMINDER("Using dummy value symbol OnCMCAVDECCDisconnected ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol OnCMCAVDECCDisconnected -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined OnCMCNANOMsgDisconnected
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define OnCMCNANOMsgDisconnected 0xffff
#pragma _REMINDER("Using dummy value symbol OnCMCNANOMsgDisconnected ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol OnCMCNANOMsgDisconnected -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined OnCMAAVDECCDisconnected
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define OnCMAAVDECCDisconnected 0xffff
#pragma _REMINDER("Using dummy value symbol OnCMAAVDECCDisconnected ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol OnCMAAVDECCDisconnected -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined OnCMANANOMsgDisconnected
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define OnCMANANOMsgDisconnected 0xffff
#pragma _REMINDER("Using dummy value symbol OnCMANANOMsgDisconnected ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol OnCMANANOMsgDisconnected -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined OnCMPAVDECCDisconnected
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define OnCMPAVDECCDisconnected 0xffff
#pragma _REMINDER("Using dummy value symbol OnCMPAVDECCDisconnected ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol OnCMPAVDECCDisconnected -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined OnCMPNANOMsgDisconnected
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define OnCMPNANOMsgDisconnected 0xffff
#pragma _REMINDER("Using dummy value symbol OnCMPNANOMsgDisconnected ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol OnCMPNANOMsgDisconnected -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined OnCMGAVDECCError
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define OnCMGAVDECCError 0xffff
#pragma _REMINDER("Using dummy value symbol OnCMGAVDECCError ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol OnCMGAVDECCError -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined OnCMGNANOMsgError
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define OnCMGNANOMsgError 0xffff
#pragma _REMINDER("Using dummy value symbol OnCMGNANOMsgError ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol OnCMGNANOMsgError -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined OnCMCAVDECCConnected
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define OnCMCAVDECCConnected 0xffff
#pragma _REMINDER("Using dummy value symbol OnCMCAVDECCConnected ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol OnCMCAVDECCConnected -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined OnCMCNANOMsgConnected
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define OnCMCNANOMsgConnected 0xffff
#pragma _REMINDER("Using dummy value symbol OnCMCNANOMsgConnected ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol OnCMCNANOMsgConnected -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined OnCMAAVDECCConnected
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define OnCMAAVDECCConnected 0xffff
#pragma _REMINDER("Using dummy value symbol OnCMAAVDECCConnected ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol OnCMAAVDECCConnected -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined OnCMANANOMsgConnected
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define OnCMANANOMsgConnected 0xffff
#pragma _REMINDER("Using dummy value symbol OnCMANANOMsgConnected ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol OnCMANANOMsgConnected -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined OnCMPAVDECCConnected
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define OnCMPAVDECCConnected 0xffff
#pragma _REMINDER("Using dummy value symbol OnCMPAVDECCConnected ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol OnCMPAVDECCConnected -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined OnCMPNANOMsgConnected
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define OnCMPNANOMsgConnected 0xffff
#pragma _REMINDER("Using dummy value symbol OnCMPNANOMsgConnected ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol OnCMPNANOMsgConnected -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined OnCMCVoltageError
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define OnCMCVoltageError 0xffff
#pragma _REMINDER("Using dummy value symbol OnCMCVoltageError ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol OnCMCVoltageError -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined OnCMAVoltageError
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define OnCMAVoltageError 0xffff
#pragma _REMINDER("Using dummy value symbol OnCMAVoltageError ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol OnCMAVoltageError -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined OnCMPVoltageError
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define OnCMPVoltageError 0xffff
#pragma _REMINDER("Using dummy value symbol OnCMPVoltageError ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol OnCMPVoltageError -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined OnCMGVoltageError
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define OnCMGVoltageError 0xffff
#pragma _REMINDER("Using dummy value symbol OnCMGVoltageError ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol OnCMGVoltageError -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined OnCMCThermalError
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define OnCMCThermalError 0xffff
#pragma _REMINDER("Using dummy value symbol OnCMCThermalError ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol OnCMCThermalError -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined OnCMAThermalError
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define OnCMAThermalError 0xffff
#pragma _REMINDER("Using dummy value symbol OnCMAThermalError ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol OnCMAThermalError -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined OnCMPThermalError
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define OnCMPThermalError 0xffff
#pragma _REMINDER("Using dummy value symbol OnCMPThermalError ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol OnCMPThermalError -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined OnCMGThermalError
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define OnCMGThermalError 0xffff
#pragma _REMINDER("Using dummy value symbol OnCMGThermalError ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol OnCMGThermalError -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined OnCMASystemConnected
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define OnCMASystemConnected 0xffff
#pragma _REMINDER("Using dummy value symbol OnCMASystemConnected ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol OnCMASystemConnected -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined OnCMASystemDisConnected
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define OnCMASystemDisConnected 0xffff
#pragma _REMINDER("Using dummy value symbol OnCMASystemDisConnected ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol OnCMASystemDisConnected -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined OnCMRAVDECCDisconnected
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define OnCMRAVDECCDisconnected 0xffff
#pragma _REMINDER("Using dummy value symbol OnCMRAVDECCDisconnected ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol OnCMRAVDECCDisconnected -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined OnCMRNANOMsgDisconnected
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define OnCMRNANOMsgDisconnected 0xffff
#pragma _REMINDER("Using dummy value symbol OnCMRNANOMsgDisconnected ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol OnCMRNANOMsgDisconnected -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined OnCMRThermalError
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define OnCMRThermalError 0xffff
#pragma _REMINDER("Using dummy value symbol OnCMRThermalError ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol OnCMRThermalError -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined OnCMRVoltageError
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define OnCMRVoltageError 0xffff
#pragma _REMINDER("Using dummy value symbol OnCMRVoltageError ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol OnCMRVoltageError -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined OnHourLogiceError
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define OnHourLogiceError 0xffff
#pragma _REMINDER("Using dummy value symbol OnHourLogiceError ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol OnHourLogiceError -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForSystemFailureUpdate(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::SystemFailureUpdate const & message = static_cast< ::SystemFailureUpdate const &>(aMessage);

#ifdef OnCMCAVDECCDisconnected
    if ((message.GetSystemCategory() == SYSTEM_CATEGORY_CMC) && (message.GetStatusCategory() == STATUS_CATEGORY_AVDECC) && (message.GetSystemStatus() == SYSTEM_STATUS_DISCONNECTED)) { eventId = CIT_EVENT_ID(OnCMCAVDECCDisconnected, 0xA015B998); return true; }
#endif
#ifdef OnCMASystemDisConnected
    if ((message.GetSystemCategory() == SYSTEM_CATEGORY_CMA) && (message.GetStatusCategory() == STATUS_CATEGORY_SYSTEM) && (message.GetSystemStatus() == SYSTEM_STATUS_DISCONNECTED)) { eventId = CIT_EVENT_ID(OnCMASystemDisConnected, 0x8EF1A208); return true; }
#endif
#ifdef OnCMASystemConnected
    if ((message.GetSystemCategory() == SYSTEM_CATEGORY_CMA) && (message.GetStatusCategory() == STATUS_CATEGORY_SYSTEM) && (message.GetSystemStatus() == SYSTEM_STATUS_CONNECTED)) { eventId = CIT_EVENT_ID(OnCMASystemConnected, 0xE50E0F12); return true; }
#endif
#ifdef OnCMPNANOMsgConnected
    if ((message.GetSystemCategory() == SYSTEM_CATEGORY_CMP) && (message.GetStatusCategory() == STATUS_CATEGORY_NANOMSG) && (message.GetSystemStatus() == SYSTEM_STATUS_CONNECTED)) { eventId = CIT_EVENT_ID(OnCMPNANOMsgConnected, 0x2688699F); return true; }
#endif
#ifdef OnCMPAVDECCConnected
    if ((message.GetSystemCategory() == SYSTEM_CATEGORY_CMP) && (message.GetStatusCategory() == STATUS_CATEGORY_AVDECC) && (message.GetSystemStatus() == SYSTEM_STATUS_CONNECTED)) { eventId = CIT_EVENT_ID(OnCMPAVDECCConnected, 0xEACE8020); return true; }
#endif
#ifdef OnCMANANOMsgConnected
    if ((message.GetSystemCategory() == SYSTEM_CATEGORY_CMA) && (message.GetStatusCategory() == STATUS_CATEGORY_NANOMSG) && (message.GetSystemStatus() == SYSTEM_STATUS_CONNECTED)) { eventId = CIT_EVENT_ID(OnCMANANOMsgConnected, 0x21ACF27B); return true; }
#endif
#ifdef OnCMAAVDECCConnected
    if ((message.GetSystemCategory() == SYSTEM_CATEGORY_CMA) && (message.GetStatusCategory() == STATUS_CATEGORY_AVDECC) && (message.GetSystemStatus() == SYSTEM_STATUS_CONNECTED)) { eventId = CIT_EVENT_ID(OnCMAAVDECCConnected, 0xEEE32397); return true; }
#endif
#ifdef OnCMCNANOMsgConnected
    if ((message.GetSystemCategory() == SYSTEM_CATEGORY_CMC) && (message.GetStatusCategory() == STATUS_CATEGORY_NANOMSG) && (message.GetSystemStatus() == SYSTEM_STATUS_CONNECTED)) { eventId = CIT_EVENT_ID(OnCMCNANOMsgConnected, 0x7CD948CA); return true; }
#endif
#ifdef OnHourLogiceError
    if ((message.GetSystemCategory() == SYSTEM_CATEGORY_CMC) && (message.GetStatusCategory() == STATUS_CATEGORY_HOURLOGIC) && (message.GetRegionId() == REGION_COCKPIT)) { eventId = CIT_EVENT_ID(OnHourLogiceError, 0x9F38DBBE); return true; }
#endif
#ifdef OnCMPNANOMsgDisconnected
    if ((message.GetSystemCategory() == SYSTEM_CATEGORY_CMP) && (message.GetStatusCategory() == STATUS_CATEGORY_NANOMSG) && (message.GetSystemStatus() == SYSTEM_STATUS_DISCONNECTED)) { eventId = CIT_EVENT_ID(OnCMPNANOMsgDisconnected, 0x67584F32); return true; }
#endif
#ifdef OnCMPAVDECCDisconnected
    if ((message.GetSystemCategory() == SYSTEM_CATEGORY_CMP) && (message.GetStatusCategory() == STATUS_CATEGORY_AVDECC) && (message.GetSystemStatus() == SYSTEM_STATUS_DISCONNECTED)) { eventId = CIT_EVENT_ID(OnCMPAVDECCDisconnected, 0xE42A61C8); return true; }
#endif
#ifdef OnCMANANOMsgDisconnected
    if ((message.GetSystemCategory() == SYSTEM_CATEGORY_CMA) && (message.GetStatusCategory() == STATUS_CATEGORY_NANOMSG) && (message.GetSystemStatus() == SYSTEM_STATUS_DISCONNECTED)) { eventId = CIT_EVENT_ID(OnCMANANOMsgDisconnected, 0x26293098); return true; }
#endif
#ifdef OnCMCNANOMsgDisconnected
    if ((message.GetSystemCategory() == SYSTEM_CATEGORY_CMC) && (message.GetStatusCategory() == STATUS_CATEGORY_NANOMSG) && (message.GetSystemStatus() == SYSTEM_STATUS_DISCONNECTED)) { eventId = CIT_EVENT_ID(OnCMCNANOMsgDisconnected, 0x7068B963); return true; }
#endif
#ifdef OnCMAAVDECCDisconnected
    if ((message.GetSystemCategory() == SYSTEM_CATEGORY_CMA) && (message.GetStatusCategory() == STATUS_CATEGORY_AVDECC) && (message.GetSystemStatus() == SYSTEM_STATUS_DISCONNECTED)) { eventId = CIT_EVENT_ID(OnCMAAVDECCDisconnected, 0x581B2F63); return true; }
#endif
#ifdef OnCMCAVDECCConnected
    if ((message.GetSystemCategory() == SYSTEM_CATEGORY_CMC) && (message.GetStatusCategory() == STATUS_CATEGORY_AVDECC) && (message.GetSystemStatus() == SYSTEM_STATUS_CONNECTED)) { eventId = CIT_EVENT_ID(OnCMCAVDECCConnected, 0x2D00449C); return true; }
#endif
#ifdef OnCMGNANOMsgError
    if ((message.GetSystemCategory() == SYSTEM_CATEGORY_CMG) && (message.GetStatusCategory() == STATUS_CATEGORY_NANOMSG)) { eventId = CIT_EVENT_ID(OnCMGNANOMsgError, 0x1FE343F4); return true; }
#endif
#ifdef OnCMRThermalError
    if ((message.GetSystemCategory() == SYSTEM_CATEGORY_CMR) && (message.GetStatusCategory() == STATUS_CATEGORY_THERMAL)) { eventId = CIT_EVENT_ID(OnCMRThermalError, 0x00035D50); return true; }
#endif
#ifdef OnCMRNANOMsgDisconnected
    if ((message.GetSystemCategory() == SYSTEM_CATEGORY_CMR) && (message.GetStatusCategory() == STATUS_CATEGORY_NANOMSG)) { eventId = CIT_EVENT_ID(OnCMRNANOMsgDisconnected, 0xFA23AE67); return true; }
#endif
#ifdef OnCMRAVDECCDisconnected
    if ((message.GetSystemCategory() == SYSTEM_CATEGORY_CMR) && (message.GetStatusCategory() == STATUS_CATEGORY_AVDECC)) { eventId = CIT_EVENT_ID(OnCMRAVDECCDisconnected, 0x13BCD271); return true; }
#endif
#ifdef OnCMGThermalError
    if ((message.GetSystemCategory() == SYSTEM_CATEGORY_CMG) && (message.GetStatusCategory() == STATUS_CATEGORY_THERMAL)) { eventId = CIT_EVENT_ID(OnCMGThermalError, 0xAD035754); return true; }
#endif
#ifdef OnCMCThermalError
    if ((message.GetSystemCategory() == SYSTEM_CATEGORY_CMC) && (message.GetStatusCategory() == STATUS_CATEGORY_THERMAL)) { eventId = CIT_EVENT_ID(OnCMCThermalError, 0x14599D95); return true; }
#endif
#ifdef OnCMAThermalError
    if ((message.GetSystemCategory() == SYSTEM_CATEGORY_CMA) && (message.GetStatusCategory() == STATUS_CATEGORY_THERMAL)) { eventId = CIT_EVENT_ID(OnCMAThermalError, 0x4142D0A7); return true; }
#endif
#ifdef OnCMGVoltageError
    if ((message.GetSystemCategory() == SYSTEM_CATEGORY_CMG) && (message.GetStatusCategory() == STATUS_CATEGORY_VOLTAGE)) { eventId = CIT_EVENT_ID(OnCMGVoltageError, 0x346CC7BC); return true; }
#endif
#ifdef OnCMPVoltageError
    if ((message.GetSystemCategory() == SYSTEM_CATEGORY_CMP) && (message.GetStatusCategory() == STATUS_CATEGORY_VOLTAGE)) { eventId = CIT_EVENT_ID(OnCMPVoltageError, 0x9A948051); return true; }
#endif
#ifdef OnCMAVoltageError
    if ((message.GetSystemCategory() == SYSTEM_CATEGORY_CMA) && (message.GetStatusCategory() == STATUS_CATEGORY_VOLTAGE)) { eventId = CIT_EVENT_ID(OnCMAVoltageError, 0x6BC7DFC7); return true; }
#endif
#ifdef OnCMRVoltageError
    if ((message.GetSystemCategory() == SYSTEM_CATEGORY_CMR) && (message.GetStatusCategory() == STATUS_CATEGORY_VOLTAGE)) { eventId = CIT_EVENT_ID(OnCMRVoltageError, 0xCD3BD212); return true; }
#endif
#ifdef OnCMGAVDECCError
    if ((message.GetSystemCategory() == SYSTEM_CATEGORY_CMG) && (message.GetStatusCategory() == STATUS_CATEGORY_AVDECC)) { eventId = CIT_EVENT_ID(OnCMGAVDECCError, 0x5F6D231B); return true; }
#endif
#ifdef OnCMPThermalError
    if ((message.GetSystemCategory() == SYSTEM_CATEGORY_CMP) && (message.GetStatusCategory() == STATUS_CATEGORY_THERMAL)) { eventId = CIT_EVENT_ID(OnCMPThermalError, 0x7FDCF4B7); return true; }
#endif
#ifdef OnCMCVoltageError
    if ((message.GetSystemCategory() == SYSTEM_CATEGORY_CMC) && (message.GetStatusCategory() == STATUS_CATEGORY_VOLTAGE)) { eventId = CIT_EVENT_ID(OnCMCVoltageError, 0x96C708F4); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSystemFailureUpdate(AppHmi_MasterStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::SystemFailureUpdate const & message = static_cast< ::SystemFailureUpdate const &>(aMessage);
#ifdef OnCMCAVDECCDisconnected
    if (eventId == OnCMCAVDECCDisconnected) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetRegionId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_OnCMCAVDECCDisconnected.RegionId = message.GetRegionId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef OnCMCNANOMsgDisconnected
    if (eventId == OnCMCNANOMsgDisconnected) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetRegionId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_OnCMCNANOMsgDisconnected.RegionId = message.GetRegionId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef OnCMAAVDECCDisconnected
    if (eventId == OnCMAAVDECCDisconnected) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetRegionId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_OnCMAAVDECCDisconnected.RegionId = message.GetRegionId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef OnCMANANOMsgDisconnected
    if (eventId == OnCMANANOMsgDisconnected) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetRegionId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_OnCMANANOMsgDisconnected.RegionId = message.GetRegionId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef OnCMPAVDECCDisconnected
    if (eventId == OnCMPAVDECCDisconnected) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetRegionId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_OnCMPAVDECCDisconnected.RegionId = message.GetRegionId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef OnCMPNANOMsgDisconnected
    if (eventId == OnCMPNANOMsgDisconnected) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetRegionId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_OnCMPNANOMsgDisconnected.RegionId = message.GetRegionId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef OnCMGAVDECCError
    if (eventId == OnCMGAVDECCError) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetSystemStatus(), message.GetRegionId(), message.GetGroupCategory()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_OnCMGAVDECCError.SystemStatus = message.GetSystemStatus();
        onClickParam.VSEPS_OnCMGAVDECCError.RegionId = message.GetRegionId();
        onClickParam.VSEPS_OnCMGAVDECCError.GroupCategory = message.GetGroupCategory();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef OnCMGNANOMsgError
    if (eventId == OnCMGNANOMsgError) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetSystemStatus(), message.GetRegionId(), message.GetGroupCategory()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_OnCMGNANOMsgError.SystemStatus = message.GetSystemStatus();
        onClickParam.VSEPS_OnCMGNANOMsgError.RegionId = message.GetRegionId();
        onClickParam.VSEPS_OnCMGNANOMsgError.GroupCategory = message.GetGroupCategory();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef OnCMCAVDECCConnected
    if (eventId == OnCMCAVDECCConnected) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetRegionId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_OnCMCAVDECCConnected.RegionId = message.GetRegionId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef OnCMCNANOMsgConnected
    if (eventId == OnCMCNANOMsgConnected) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetRegionId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_OnCMCNANOMsgConnected.RegionId = message.GetRegionId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef OnCMAAVDECCConnected
    if (eventId == OnCMAAVDECCConnected) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetRegionId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_OnCMAAVDECCConnected.RegionId = message.GetRegionId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef OnCMANANOMsgConnected
    if (eventId == OnCMANANOMsgConnected) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetRegionId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_OnCMANANOMsgConnected.RegionId = message.GetRegionId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef OnCMPAVDECCConnected
    if (eventId == OnCMPAVDECCConnected) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetRegionId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_OnCMPAVDECCConnected.RegionId = message.GetRegionId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef OnCMPNANOMsgConnected
    if (eventId == OnCMPNANOMsgConnected) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetRegionId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_OnCMPNANOMsgConnected.RegionId = message.GetRegionId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef OnCMCVoltageError
    if (eventId == OnCMCVoltageError) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetSystemStatus(), message.GetRegionId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_OnCMCVoltageError.SystemStatus = message.GetSystemStatus();
        onClickParam.VSEPS_OnCMCVoltageError.RegionId = message.GetRegionId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef OnCMAVoltageError
    if (eventId == OnCMAVoltageError) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetSystemStatus(), message.GetRegionId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_OnCMAVoltageError.SystemStatus = message.GetSystemStatus();
        onClickParam.VSEPS_OnCMAVoltageError.RegionId = message.GetRegionId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef OnCMPVoltageError
    if (eventId == OnCMPVoltageError) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetSystemStatus(), message.GetRegionId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_OnCMPVoltageError.SystemStatus = message.GetSystemStatus();
        onClickParam.VSEPS_OnCMPVoltageError.RegionId = message.GetRegionId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef OnCMGVoltageError
    if (eventId == OnCMGVoltageError) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetSystemStatus(), message.GetRegionId(), message.GetGroupCategory()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_OnCMGVoltageError.SystemStatus = message.GetSystemStatus();
        onClickParam.VSEPS_OnCMGVoltageError.RegionId = message.GetRegionId();
        onClickParam.VSEPS_OnCMGVoltageError.GroupCategory = message.GetGroupCategory();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef OnCMCThermalError
    if (eventId == OnCMCThermalError) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetSystemStatus(), message.GetRegionId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_OnCMCThermalError.SystemStatus = message.GetSystemStatus();
        onClickParam.VSEPS_OnCMCThermalError.RegionId = message.GetRegionId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef OnCMAThermalError
    if (eventId == OnCMAThermalError) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetSystemStatus(), message.GetRegionId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_OnCMAThermalError.SystemStatus = message.GetSystemStatus();
        onClickParam.VSEPS_OnCMAThermalError.RegionId = message.GetRegionId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef OnCMPThermalError
    if (eventId == OnCMPThermalError) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetSystemStatus(), message.GetRegionId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_OnCMPThermalError.SystemStatus = message.GetSystemStatus();
        onClickParam.VSEPS_OnCMPThermalError.RegionId = message.GetRegionId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef OnCMGThermalError
    if (eventId == OnCMGThermalError) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetSystemStatus(), message.GetRegionId(), message.GetGroupCategory()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_OnCMGThermalError.SystemStatus = message.GetSystemStatus();
        onClickParam.VSEPS_OnCMGThermalError.RegionId = message.GetRegionId();
        onClickParam.VSEPS_OnCMGThermalError.GroupCategory = message.GetGroupCategory();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef OnCMASystemConnected
    if (eventId == OnCMASystemConnected) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetRegionId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_OnCMASystemConnected.RegionId = message.GetRegionId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef OnCMASystemDisConnected
    if (eventId == OnCMASystemDisConnected) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetRegionId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_OnCMASystemDisConnected.RegionId = message.GetRegionId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef OnCMRAVDECCDisconnected
    if (eventId == OnCMRAVDECCDisconnected) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetSystemStatus(), message.GetRegionId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_OnCMRAVDECCDisconnected.SystemStatus = message.GetSystemStatus();
        onClickParam.VSEPS_OnCMRAVDECCDisconnected.RegionId = message.GetRegionId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef OnCMRNANOMsgDisconnected
    if (eventId == OnCMRNANOMsgDisconnected) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetSystemStatus(), message.GetRegionId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_OnCMRNANOMsgDisconnected.SystemStatus = message.GetSystemStatus();
        onClickParam.VSEPS_OnCMRNANOMsgDisconnected.RegionId = message.GetRegionId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef OnCMRThermalError
    if (eventId == OnCMRThermalError) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetSystemStatus(), message.GetRegionId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_OnCMRThermalError.SystemStatus = message.GetSystemStatus();
        onClickParam.VSEPS_OnCMRThermalError.RegionId = message.GetRegionId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef OnCMRVoltageError
    if (eventId == OnCMRVoltageError) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetSystemStatus(), message.GetRegionId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_OnCMRVoltageError.SystemStatus = message.GetSystemStatus();
        onClickParam.VSEPS_OnCMRVoltageError.RegionId = message.GetRegionId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef OnHourLogiceError
    if (eventId == OnHourLogiceError) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetSystemStatus()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_OnHourLogiceError.SystemStatus = message.GetSystemStatus();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onSwipeGesture
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onSwipeGesture 0xffff
#pragma _REMINDER("Using dummy value symbol onSwipeGesture ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onSwipeGesture -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForSwipeGestureMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(onSwipeGesture, 0x64580AB9);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSwipeGestureMsg(AppHmi_MasterStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::hmibase::widget::gesture::SwipeGestureMsg const & message = static_cast< ::hmibase::widget::gesture::SwipeGestureMsg const &>(aMessage);
#ifdef onSwipeGesture
    if (eventId == onSwipeGesture) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetVelocity1X()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onSwipeGesture.Velocity1X = message.GetVelocity1X();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForSwipeMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(onSwipe, 0x8CA9EF75);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSwipeMsg(AppHmi_MasterStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onHomeState
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onHomeState 0xffff
#pragma _REMINDER("Using dummy value symbol onHomeState ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onHomeState -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForChangeHomeStateMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(onHomeState, 0xD9C7700B);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForChangeHomeStateMsg(AppHmi_MasterStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::ChangeHomeStateMsg const & message = static_cast< ::ChangeHomeStateMsg const &>(aMessage);
#ifdef onHomeState
    if (eventId == onHomeState) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetRegionId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onHomeState.RegionId = message.GetRegionId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForEmergencyShutDownReqMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::EmergencyShutDownReqMsg const & message = static_cast< ::EmergencyShutDownReqMsg const &>(aMessage);

#ifdef onShow_HeatPopup
    if ((message.GetShowhide() == true)) { eventId = CIT_EVENT_ID(onShow_HeatPopup, 0x8A316034); return true; }
#endif
#ifdef onHide_HeatPopup
    if ((message.GetShowhide() == false)) { eventId = CIT_EVENT_ID(onHide_HeatPopup, 0x200CDB2A); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForEmergencyShutDownReqMsg(AppHmi_MasterStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::EmergencyShutDownReqMsg const & message = static_cast< ::EmergencyShutDownReqMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onEvalContextSwitchRequest
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onEvalContextSwitchRequest 0xffff
#pragma _REMINDER("Using dummy value symbol onEvalContextSwitchRequest ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onEvalContextSwitchRequest -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForEvalContextSwitchRequestMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(onEvalContextSwitchRequest, 0x927E151E);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForEvalContextSwitchRequestMsg(AppHmi_MasterStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::EvalContextSwitchRequestMsg const & message = static_cast< ::EvalContextSwitchRequestMsg const &>(aMessage);
#ifdef onEvalContextSwitchRequest
    if (eventId == onEvalContextSwitchRequest) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetRegionId(), message.GetSourceAppId(), message.GetSourceActivityId(), message.GetTargetAppId(), message.GetTargetActivityId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onEvalContextSwitchRequest.RegionId = message.GetRegionId();
        onClickParam.VSEPS_onEvalContextSwitchRequest.SourceAppId = message.GetSourceAppId();
        onClickParam.VSEPS_onEvalContextSwitchRequest.SourceActivityId = message.GetSourceActivityId();
        onClickParam.VSEPS_onEvalContextSwitchRequest.TargetAppId = message.GetTargetAppId();
        onClickParam.VSEPS_onEvalContextSwitchRequest.TargetActivityId = message.GetTargetActivityId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onPopupTimerExpiry
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onPopupTimerExpiry 0xffff
#pragma _REMINDER("Using dummy value symbol onPopupTimerExpiry ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onPopupTimerExpiry -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForExpiredPopupTimerResMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(onPopupTimerExpiry, 0xF3C96D17);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForExpiredPopupTimerResMsg(AppHmi_MasterStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::ExpiredPopupTimerResMsg const & message = static_cast< ::ExpiredPopupTimerResMsg const &>(aMessage);
#ifdef onPopupTimerExpiry
    if (eventId == onPopupTimerExpiry) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetViewId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onPopupTimerExpiry.ViewId = message.GetViewId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onActivateImageProviderRequest
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onActivateImageProviderRequest 0xffff
#pragma _REMINDER("Using dummy value symbol onActivateImageProviderRequest ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onActivateImageProviderRequest -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onDeactivateImageProviderRequest
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onDeactivateImageProviderRequest 0xffff
#pragma _REMINDER("Using dummy value symbol onDeactivateImageProviderRequest ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onDeactivateImageProviderRequest -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForActivateImageProviderReqMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::hmibase::gadget::ActivateImageProviderReqMsg const & message = static_cast< ::hmibase::gadget::ActivateImageProviderReqMsg const &>(aMessage);

#ifdef onActivateImageProviderRequest
    if ((message.GetActivate() == 1)) { eventId = CIT_EVENT_ID(onActivateImageProviderRequest, 0xDD62EA5B); return true; }
#endif
#ifdef onDeactivateImageProviderRequest
    if ((message.GetActivate() == 0)) { eventId = CIT_EVENT_ID(onDeactivateImageProviderRequest, 0x9FE98C1E); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActivateImageProviderReqMsg(AppHmi_MasterStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::hmibase::gadget::ActivateImageProviderReqMsg const & message = static_cast< ::hmibase::gadget::ActivateImageProviderReqMsg const &>(aMessage);
#ifdef onActivateImageProviderRequest
    if (eventId == onActivateImageProviderRequest) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetInstanceId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onActivateImageProviderRequest.InstanceId = message.GetInstanceId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onDeactivateImageProviderRequest
    if (eventId == onDeactivateImageProviderRequest) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetInstanceId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onDeactivateImageProviderRequest.InstanceId = message.GetInstanceId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForHMISubStateChangedUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::HMISubStateChangedUpdMsg const & message = static_cast< ::HMISubStateChangedUpdMsg const &>(aMessage);

#ifdef onHMISubStateChanged_ON
    if ((message.GetSubState() == HMISTATE_SHOW_HMI)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_ON, 0x76CF2B88); return true; }
#endif
#ifdef onHMISubStateChanged_CLOCK
    if ((message.GetSubState() == HMISTATE_SHOW_CLOCK)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_CLOCK, 0xF96478DC); return true; }
#endif
#ifdef onHMISubStateChanged_OFF
    if ((message.GetSubState() == HMISTATE_SHOW_OFF)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_OFF, 0x776D7D8A); return true; }
#endif
#ifdef onHMISubStateChanged_STANDBY_RESTRICTED
    if ((message.GetSubState() == HMISTATE_STANDBY_RESTRICTED)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_STANDBY_RESTRICTED, 0xA15C3CEE); return true; }
#endif
#ifdef onHMISubStateChanged_STANDBY
    if ((message.GetSubState() == HMISTATE_STANDBY)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_STANDBY, 0x0D0F5602); return true; }
#endif
#ifdef onHMISubStateChanged_PHONE
    if ((message.GetSubState() == HMISTATE_PHONE)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_PHONE, 0xC8D83B8B); return true; }
#endif
#ifdef onHMISubStateChanged_NO_DISPLAY
    if ((message.GetSubState() == HMISTATE_SHOW_NO_DISPLAY)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_NO_DISPLAY, 0xE4658CFD); return true; }
#endif
#ifdef onHMISubStateChanged_SECURE
    if ((message.GetSubState() == HMISTATE_SECURE)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_SECURE, 0xAB89D7A8); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForHMISubStateChangedUpdMsg(AppHmi_MasterStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::HMISubStateChangedUpdMsg const & message = static_cast< ::HMISubStateChangedUpdMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForApplicationStateUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::ApplicationStateUpdMsg const & message = static_cast< ::ApplicationStateUpdMsg const &>(aMessage);

#ifdef onAppStatusChanged_FOREGROUND
    if ((message.GetState() == hmibase::IN_FOREGROUND)) { eventId = CIT_EVENT_ID(onAppStatusChanged_FOREGROUND, 0xDE9448E3); return true; }
#endif
#ifdef onAppStatusChanged_BACKGROUND
    if ((message.GetState() == hmibase::IN_BACKGROUND)) { eventId = CIT_EVENT_ID(onAppStatusChanged_BACKGROUND, 0x6D1B3A68); return true; }
#endif
#ifdef onAppStatusPrepare_BACKGROUND
    if ((message.GetState() == hmibase::TO_BACKGROUND)) { eventId = CIT_EVENT_ID(onAppStatusPrepare_BACKGROUND, 0x4C8518AE); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForApplicationStateUpdMsg(AppHmi_MasterStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::ApplicationStateUpdMsg const & message = static_cast< ::ApplicationStateUpdMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onSubSurfaceUpdMsgChanged_FOREGROUND
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onSubSurfaceUpdMsgChanged_FOREGROUND 0xffff
#pragma _REMINDER("Using dummy value symbol onSubSurfaceUpdMsgChanged_FOREGROUND ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onSubSurfaceUpdMsgChanged_FOREGROUND -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onSubSurfaceUpdMsgChanged_BACKGROUND
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onSubSurfaceUpdMsgChanged_BACKGROUND 0xffff
#pragma _REMINDER("Using dummy value symbol onSubSurfaceUpdMsgChanged_BACKGROUND ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onSubSurfaceUpdMsgChanged_BACKGROUND -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForSubSurfaceUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::SubSurfaceUpdMsg const & message = static_cast< ::SubSurfaceUpdMsg const &>(aMessage);

#ifdef onSubSurfaceUpdMsgChanged_FOREGROUND
    if ((message.GetState() == hmibase::IN_FOREGROUND)) { eventId = CIT_EVENT_ID(onSubSurfaceUpdMsgChanged_FOREGROUND, 0x9D4DF4FC); return true; }
#endif
#ifdef onSubSurfaceUpdMsgChanged_BACKGROUND
    if ((message.GetState() == hmibase::IN_BACKGROUND)) { eventId = CIT_EVENT_ID(onSubSurfaceUpdMsgChanged_BACKGROUND, 0x5790D8C1); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSubSurfaceUpdMsg(AppHmi_MasterStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::SubSurfaceUpdMsg const & message = static_cast< ::SubSurfaceUpdMsg const &>(aMessage);
#ifdef onSubSurfaceUpdMsgChanged_FOREGROUND
    if (eventId == onSubSurfaceUpdMsgChanged_FOREGROUND) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetDisplayRegion(), message.GetDisplayID()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onSubSurfaceUpdMsgChanged_FOREGROUND.DisplayRegion = message.GetDisplayRegion();
        onClickParam.VSEPS_onSubSurfaceUpdMsgChanged_FOREGROUND.DisplayID = message.GetDisplayID();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onSubSurfaceUpdMsgChanged_BACKGROUND
    if (eventId == onSubSurfaceUpdMsgChanged_BACKGROUND) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetDisplayRegion(), message.GetDisplayID()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onSubSurfaceUpdMsgChanged_BACKGROUND.DisplayRegion = message.GetDisplayRegion();
        onClickParam.VSEPS_onSubSurfaceUpdMsgChanged_BACKGROUND.DisplayID = message.GetDisplayID();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForTransitionIndMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::Courier::TransitionIndMsg const & message = static_cast< ::Courier::TransitionIndMsg const &>(aMessage);

#ifdef OnNextLevelTransitionFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("NextLevelTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnNextLevelTransitionFinished, 0xE7DCE080); return true; }
#endif
#ifdef OnPreviousLevelTransitionFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("PreviousLevelTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnPreviousLevelTransitionFinished, 0x26C30D04); return true; }
#endif
#ifdef OnPageFlipBackFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("PageFlipBackTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnPageFlipBackFinished, 0x74F534EE); return true; }
#endif
#ifdef OnPageFlipFrontFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("PageFlipFrontTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnPageFlipFrontFinished, 0x437D9EFE); return true; }
#endif
#ifdef OnZoomInFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("ZoomInTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnZoomInFinished, 0xFBEEA58F); return true; }
#endif
#ifdef OnZoomOutFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("ZoomOutTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnZoomOutFinished, 0xF84B3BD1); return true; }
#endif
#ifdef OnFadeAnimationFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("FadeTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnFadeAnimationFinished, 0xE9A6D56C); return true; }
#endif
#ifdef OnDualViewLeftTransitionFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("DualViewLeftTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnDualViewLeftTransitionFinished, 0x403A65A4); return true; }
#endif
#ifdef OnDualViewRightTransitionFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("DualViewRightTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnDualViewRightTransitionFinished, 0x50B4DCCA); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForTransitionIndMsg(AppHmi_MasterStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::Courier::TransitionIndMsg const & message = static_cast< ::Courier::TransitionIndMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_MasterStateMachineImpl::VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
struct EventMapping
{
    ::FeatStd::UInt32 mHashId;
    bool (*mEventCallHandler)(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId);
};

struct EventDeductionMapping
{
    ::FeatStd::UInt32 mHashId;
    ::Cit::DeductResult::Enum (*mEventCallHandler)(AppHmi_MasterStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId);
};

static ::FeatStd::Int EventMappingCmp(::FeatStd::UInt32 hash, const EventMapping& em)
{
    return (hash == em.mHashId) ? 0 : ((hash < em.mHashId) ? -1 : 1);
}

static ::FeatStd::Int EventDeductionMappingCmp(::FeatStd::UInt32 hash, const EventDeductionMapping& em)
{
    return (hash == em.mHashId) ? 0 : ((hash < em.mHashId) ? -1 : 1);
}

bool AppHmi_MasterStateMachineImpl::HandleEventMapping(::Courier::Message const & message, ::FeatStd::UInt32& eventId) const
{
    static EventMapping events[38] = {
        { 0x02BD8124, HandleEventMappingForSwitchApplicationMsg },
        { 0x03DDF00F, HandleEventMappingForSwipeMsg },
        { 0x04B8AFB9, HandleEventMappingForHKStatusChangedUpdMsg },
        { 0x05A9D564, HandleEventMappingForMmiStateStatusUpdMsg },
        { 0x05DA205F, HandleEventMappingForPlayBeepReqMsg },
        { 0x1069D09E, HandleEventMappingForMicStatus },
        { 0x2692050D, HandleEventMappingForEvalSubSurfaceReqMsg },
        { 0x28E14D4C, HandleEventMappingForShowHideWaitSceneMsg },
        { 0x358837AD, HandleEventMappingForKDSStatusUpdMsg },
        { 0x3824FE1D, HandleEventMappingForApplicationStateUpdMsg },
        { 0x3AE518D9, HandleEventMappingForClonedSurfaceStateChangedUpdMsg },
        { 0x4A69141E, HandleEventMappingForHMISubStateChangedUpdMsg },
        { 0x4FF79763, HandleEventMappingForEncoderStatusChangedUpdMsg },
        { 0x507ABE4B, HandleEventMappingForMixSourceIndexConnectionStatusReqMsg },
        { 0x69FAC6F1, HandleEventMappingForSubSurfaceUpdMsg },
        { 0x6AE0FD3C, HandleEventMappingForButtonReactionMsg },
        { 0x6BAA8440, HandleEventMappingForAppFlyInReqMsg },
        { 0x9EBDCEEC, HandleEventMappingForActivateRVCSceneMsg },
        { 0xA1A3B247, HandleEventMappingForEvalContextSwitchRequestMsg },
        { 0xA2B4B599, HandleEventMappingForSwipeGestureMsg },
        { 0xAE3CAAA7, HandleEventMappingForExpiredPopupTimerResMsg },
        { 0xBA2352FB, HandleEventMappingForUpdateVINStatusToHMI },
        { 0xBB653851, HandleEventMappingForCloseOnTouchReqMsg },
        { 0xBE1CA755, HandleEventMappingForExpiredDisclaimerTimerMsg },
        { 0xC203FD77, HandleEventMappingForVolumePopupReqMsg },
        { 0xC501DA0F, HandleEventMappingForSystemFailureUpdate },
        { 0xC613E40C, HandleEventMappingForActivateImageProviderReqMsg },
        { 0xC7B455FB, HandleEventMappingForTransitionIndMsg },
        { 0xCC97BED5, HandleEventMappingForClonedHKStatusChangedUpdMsg },
        { 0xDA213FAC, HandleEventMappingForEvalCommonButtonActivationRequestMsg },
        { 0xDC701C20, HandleEventMappingForUpdateAntiTheftStatus },
        { 0xE117DABE, HandleEventMappingForHMIAppsInitializedUpdMsg },
        { 0xE2F61D55, HandleEventMappingForSurfaceStateChangedUpdMsg },
        { 0xE8FA761A, HandleEventMappingForShowFirstHMIAppRequestMsg },
        { 0xF2C61F33, HandleEventMappingForupdateHMIStateChange },
        { 0xF631F05D, HandleEventMappingForShowTempHMIAppRequestMsg },
        { 0xFAC815CB, HandleEventMappingForChangeHomeStateMsg },
        { 0xFFCFF147, HandleEventMappingForEmergencyShutDownReqMsg },
    };
    ::FeatStd::UInt32 hashId = message.GetId();
    const EventMapping* eventEntry = ::Courier::BinarySearch(hashId, events, 38, &EventMappingCmp);
    if (eventEntry && (hashId == eventEntry->mHashId)) {
        return eventEntry->mEventCallHandler(message, eventId);
    }
    return false;
}

// ------------------------------------------------------------------------
::Cit::DeductResult::Enum AppHmi_MasterStateMachineImpl::DeductEvent(::Courier::Message const & aMessage, ::FeatStd::UInt32 eventId)
{
    ::Cit::DeductResult::Enum deductResult = Cit::DeductResult::DeductOk;
    static EventDeductionMapping events[38] = {
        { 0x02BD8124, HandleEventDeductionForSwitchApplicationMsg },
        { 0x03DDF00F, HandleEventDeductionForSwipeMsg },
        { 0x04B8AFB9, HandleEventDeductionForHKStatusChangedUpdMsg },
        { 0x05A9D564, HandleEventDeductionForMmiStateStatusUpdMsg },
        { 0x05DA205F, HandleEventDeductionForPlayBeepReqMsg },
        { 0x1069D09E, HandleEventDeductionForMicStatus },
        { 0x2692050D, HandleEventDeductionForEvalSubSurfaceReqMsg },
        { 0x28E14D4C, HandleEventDeductionForShowHideWaitSceneMsg },
        { 0x358837AD, HandleEventDeductionForKDSStatusUpdMsg },
        { 0x3824FE1D, HandleEventDeductionForApplicationStateUpdMsg },
        { 0x3AE518D9, HandleEventDeductionForClonedSurfaceStateChangedUpdMsg },
        { 0x4A69141E, HandleEventDeductionForHMISubStateChangedUpdMsg },
        { 0x4FF79763, HandleEventDeductionForEncoderStatusChangedUpdMsg },
        { 0x507ABE4B, HandleEventDeductionForMixSourceIndexConnectionStatusReqMsg },
        { 0x69FAC6F1, HandleEventDeductionForSubSurfaceUpdMsg },
        { 0x6AE0FD3C, HandleEventDeductionForButtonReactionMsg },
        { 0x6BAA8440, HandleEventDeductionForAppFlyInReqMsg },
        { 0x9EBDCEEC, HandleEventDeductionForActivateRVCSceneMsg },
        { 0xA1A3B247, HandleEventDeductionForEvalContextSwitchRequestMsg },
        { 0xA2B4B599, HandleEventDeductionForSwipeGestureMsg },
        { 0xAE3CAAA7, HandleEventDeductionForExpiredPopupTimerResMsg },
        { 0xBA2352FB, HandleEventDeductionForUpdateVINStatusToHMI },
        { 0xBB653851, HandleEventDeductionForCloseOnTouchReqMsg },
        { 0xBE1CA755, HandleEventDeductionForExpiredDisclaimerTimerMsg },
        { 0xC203FD77, HandleEventDeductionForVolumePopupReqMsg },
        { 0xC501DA0F, HandleEventDeductionForSystemFailureUpdate },
        { 0xC613E40C, HandleEventDeductionForActivateImageProviderReqMsg },
        { 0xC7B455FB, HandleEventDeductionForTransitionIndMsg },
        { 0xCC97BED5, HandleEventDeductionForClonedHKStatusChangedUpdMsg },
        { 0xDA213FAC, HandleEventDeductionForEvalCommonButtonActivationRequestMsg },
        { 0xDC701C20, HandleEventDeductionForUpdateAntiTheftStatus },
        { 0xE117DABE, HandleEventDeductionForHMIAppsInitializedUpdMsg },
        { 0xE2F61D55, HandleEventDeductionForSurfaceStateChangedUpdMsg },
        { 0xE8FA761A, HandleEventDeductionForShowFirstHMIAppRequestMsg },
        { 0xF2C61F33, HandleEventDeductionForupdateHMIStateChange },
        { 0xF631F05D, HandleEventDeductionForShowTempHMIAppRequestMsg },
        { 0xFAC815CB, HandleEventDeductionForChangeHomeStateMsg },
        { 0xFFCFF147, HandleEventDeductionForEmergencyShutDownReqMsg },
    };
    ::FeatStd::UInt32 hashId = aMessage.GetId();
    const EventDeductionMapping* eventEntry = ::Courier::BinarySearch(hashId, events, 38, &EventDeductionMappingCmp);
    if (eventEntry && (hashId == eventEntry->mHashId)) {
        deductResult = eventEntry->mEventCallHandler(this, aMessage, eventId);
    }
    else {
        typedef Cit::Internal::VSDeductHelper<VS_Ret_Ok, AppHmi_MasterStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
        return VSDeductHelper::ProcessOutput(*this, (*this.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
        return VSDeductHelper::ProcessOutput(*this, (*this.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
    }
    return deductResult;
}

// ------------------------------------------------------------------------
bool AppHmi_MasterStateMachineImpl::HandleDataBindingEventMapping(::Courier::AbstractDataItemMsg const & /* message */, ::FeatStd::UInt32 & /* eventId */) const
{
    return false;
}

#ifdef CIT_SIMULATION
struct EventNameMapping
{
    ::FeatStd::UInt32 mEventId;
    const ::FeatStd::Char* mEventName;
    void (*mGetEventArguments)(::Courier::Message const & message, Json::Value& eventArguments);
};

static ::FeatStd::Int EventNameMappingCmp(::FeatStd::UInt32 eventId, const EventNameMapping& em)
{
    return (eventId == em.mEventId) ? 0 : ((eventId < em.mEventId) ? -1 : 1);
}

static void GetEventArgumentsForOnCMRThermalError(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SystemFailureUpdate const & message = static_cast< ::SystemFailureUpdate const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetSystemStatus();
    eventArguments[(::Json::Value::UInt)1] = (::Json::Value::UInt)message.GetRegionId();
}

static void GetEventArgumentsForonEncoderStatusChangedUpdMsg(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::EncoderStatusChangedUpdMsg const & message = static_cast< ::EncoderStatusChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetEncCode();
    eventArguments[(::Json::Value::UInt)1] = (::Json::Value::Int)message.GetEncSteps();
}

static void GetEventArgumentsForonHKStatusChangedUpdMsg(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::HKStatusChangedUpdMsg const & message = static_cast< ::HKStatusChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetHKCode();
    eventArguments[(::Json::Value::UInt)1] = (::Json::Value::UInt)message.GetHKState();
    eventArguments[(::Json::Value::UInt)2] = (::Json::Value::UInt)message.GetDisplayID();
    eventArguments[(::Json::Value::UInt)3] = (::Json::Value::UInt)message.GetUserData();
}

static void GetEventArgumentsForOnCMRAVDECCDisconnected(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SystemFailureUpdate const & message = static_cast< ::SystemFailureUpdate const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetSystemStatus();
    eventArguments[(::Json::Value::UInt)1] = (::Json::Value::UInt)message.GetRegionId();
}

static void GetEventArgumentsForOnCMCThermalError(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SystemFailureUpdate const & message = static_cast< ::SystemFailureUpdate const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetSystemStatus();
    eventArguments[(::Json::Value::UInt)1] = (::Json::Value::UInt)message.GetRegionId();
}

static void GetEventArgumentsForOnCMGNANOMsgError(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SystemFailureUpdate const & message = static_cast< ::SystemFailureUpdate const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetSystemStatus();
    eventArguments[(::Json::Value::UInt)1] = (::Json::Value::UInt)message.GetRegionId();
    eventArguments[(::Json::Value::UInt)2] = (::Json::Value::UInt)message.GetGroupCategory();
}

static void GetEventArgumentsForOnCMANANOMsgConnected(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SystemFailureUpdate const & message = static_cast< ::SystemFailureUpdate const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetRegionId();
}

static void GetEventArgumentsForonCenterPopupSurfaceVisible(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonControlPanelPopupSurfaceUnqueued(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForOnCMANANOMsgDisconnected(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SystemFailureUpdate const & message = static_cast< ::SystemFailureUpdate const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetRegionId();
}

static void GetEventArgumentsForOnCMPNANOMsgConnected(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SystemFailureUpdate const & message = static_cast< ::SystemFailureUpdate const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetRegionId();
}

static void GetEventArgumentsForOnCMCAVDECCConnected(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SystemFailureUpdate const & message = static_cast< ::SystemFailureUpdate const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetRegionId();
}

static void GetEventArgumentsForonHMIStateChange(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::updateHMIStateChange const & message = static_cast< ::updateHMIStateChange const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetHmiState();
}

static void GetEventArgumentsForOnCMGVoltageError(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SystemFailureUpdate const & message = static_cast< ::SystemFailureUpdate const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetSystemStatus();
    eventArguments[(::Json::Value::UInt)1] = (::Json::Value::UInt)message.GetRegionId();
    eventArguments[(::Json::Value::UInt)2] = (::Json::Value::UInt)message.GetGroupCategory();
}

static void GetEventArgumentsForOnCMAThermalError(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SystemFailureUpdate const & message = static_cast< ::SystemFailureUpdate const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetSystemStatus();
    eventArguments[(::Json::Value::UInt)1] = (::Json::Value::UInt)message.GetRegionId();
}

static void GetEventArgumentsForonUpdateAntiTheftStatus(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::UpdateAntiTheftStatus const & message = static_cast< ::UpdateAntiTheftStatus const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetAntiTheftStatus();
}

static void GetEventArgumentsForonEncoder_HMI_BASE_1(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::EncoderStatusChangedUpdMsg const & message = static_cast< ::EncoderStatusChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::Int)message.GetEncSteps();
}

static void GetEventArgumentsForonControlPanelPopupSurfaceQueued(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonAppFlyinButtonInvisible(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForOnMixSourceIndexConnectionStatusReq(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::MixSourceIndexConnectionStatusReqMsg const & message = static_cast< ::MixSourceIndexConnectionStatusReqMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetMixSourceIndex();
    eventArguments[(::Json::Value::UInt)1] = (bool)message.GetStatus();
}

static void GetEventArgumentsForonSubSurfaceUpdMsgChanged_BACKGROUND(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SubSurfaceUpdMsg const & message = static_cast< ::SubSurfaceUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::Int)message.GetDisplayRegion();
    eventArguments[(::Json::Value::UInt)1] = (::Json::Value::UInt)message.GetDisplayID();
}

static void GetEventArgumentsForOnCMAAVDECCDisconnected(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SystemFailureUpdate const & message = static_cast< ::SystemFailureUpdate const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetRegionId();
}

static void GetEventArgumentsForOnClonedSurfaceStateChangedUpdMsg(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::ClonedSurfaceStateChangedUpdMsg const & message = static_cast< ::ClonedSurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetSurfaceID();
    eventArguments[(::Json::Value::UInt)1] = (::Json::Value::UInt)message.GetSurfaceState();
}

static void GetEventArgumentsForOnCMGAVDECCError(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SystemFailureUpdate const & message = static_cast< ::SystemFailureUpdate const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetSystemStatus();
    eventArguments[(::Json::Value::UInt)1] = (::Json::Value::UInt)message.GetRegionId();
    eventArguments[(::Json::Value::UInt)2] = (::Json::Value::UInt)message.GetGroupCategory();
}

static void GetEventArgumentsForonSwipeGesture(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::hmibase::widget::gesture::SwipeGestureMsg const & message = static_cast< ::hmibase::widget::gesture::SwipeGestureMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::Int)message.GetVelocity1X();
}

static void GetEventArgumentsForonAppFlyinButtonVisible(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForOnCMPNANOMsgDisconnected(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SystemFailureUpdate const & message = static_cast< ::SystemFailureUpdate const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetRegionId();
}

static void GetEventArgumentsForonEncoderStatusChanged_RIGHT_ENC(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::EncoderStatusChangedUpdMsg const & message = static_cast< ::EncoderStatusChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::Int)message.GetEncSteps();
}

static void GetEventArgumentsForOnCMAVoltageError(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SystemFailureUpdate const & message = static_cast< ::SystemFailureUpdate const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetSystemStatus();
    eventArguments[(::Json::Value::UInt)1] = (::Json::Value::UInt)message.GetRegionId();
}

static void GetEventArgumentsForOnCMCNANOMsgDisconnected(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SystemFailureUpdate const & message = static_cast< ::SystemFailureUpdate const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetRegionId();
}

static void GetEventArgumentsForOnCMCNANOMsgConnected(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SystemFailureUpdate const & message = static_cast< ::SystemFailureUpdate const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetRegionId();
}

static void GetEventArgumentsForOnCMPThermalError(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SystemFailureUpdate const & message = static_cast< ::SystemFailureUpdate const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetSystemStatus();
    eventArguments[(::Json::Value::UInt)1] = (::Json::Value::UInt)message.GetRegionId();
}

static void GetEventArgumentsForOnCMASystemDisConnected(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SystemFailureUpdate const & message = static_cast< ::SystemFailureUpdate const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetRegionId();
}

static void GetEventArgumentsForOnClonedHKStatusChangedUpdMsg(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::ClonedHKStatusChangedUpdMsg const & message = static_cast< ::ClonedHKStatusChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetHKCode();
    eventArguments[(::Json::Value::UInt)1] = (::Json::Value::UInt)message.GetHKState();
    eventArguments[(::Json::Value::UInt)2] = (::Json::Value::UInt)message.GetDisplayID();
    eventArguments[(::Json::Value::UInt)3] = (::Json::Value::UInt)message.GetUserData();
}

static void GetEventArgumentsForonEvalContextSwitchRequest(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::EvalContextSwitchRequestMsg const & message = static_cast< ::EvalContextSwitchRequestMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::Int)message.GetRegionId();
    eventArguments[(::Json::Value::UInt)1] = (::Json::Value::Int)message.GetSourceAppId();
    eventArguments[(::Json::Value::UInt)2] = (::Json::Value::Int)message.GetSourceActivityId();
    eventArguments[(::Json::Value::UInt)3] = (::Json::Value::Int)message.GetTargetAppId();
    eventArguments[(::Json::Value::UInt)4] = (::Json::Value::Int)message.GetTargetActivityId();
}

static void GetEventArgumentsForonSwitchApplicationRequest(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SwitchApplicationMsg const & message = static_cast< ::SwitchApplicationMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetAppID();
}

static void GetEventArgumentsForOnCMCVoltageError(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SystemFailureUpdate const & message = static_cast< ::SystemFailureUpdate const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetSystemStatus();
    eventArguments[(::Json::Value::UInt)1] = (::Json::Value::UInt)message.GetRegionId();
}

static void GetEventArgumentsForOnCMPVoltageError(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SystemFailureUpdate const & message = static_cast< ::SystemFailureUpdate const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetSystemStatus();
    eventArguments[(::Json::Value::UInt)1] = (::Json::Value::UInt)message.GetRegionId();
}

static void GetEventArgumentsForonCenterPopupSurfaceInvisible(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonSubSurfaceUpdMsgChanged_FOREGROUND(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SubSurfaceUpdMsg const & message = static_cast< ::SubSurfaceUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::Int)message.GetDisplayRegion();
    eventArguments[(::Json::Value::UInt)1] = (::Json::Value::UInt)message.GetDisplayID();
}

static void GetEventArgumentsForOnHourLogiceError(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SystemFailureUpdate const & message = static_cast< ::SystemFailureUpdate const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetSystemStatus();
}

static void GetEventArgumentsForonDeactivateImageProviderRequest(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::hmibase::gadget::ActivateImageProviderReqMsg const & message = static_cast< ::hmibase::gadget::ActivateImageProviderReqMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetInstanceId();
}

static void GetEventArgumentsForOnCMCAVDECCDisconnected(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SystemFailureUpdate const & message = static_cast< ::SystemFailureUpdate const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetRegionId();
}

static void GetEventArgumentsForonCenterPopupSurfaceUnqueued(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForOnCMGThermalError(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SystemFailureUpdate const & message = static_cast< ::SystemFailureUpdate const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetSystemStatus();
    eventArguments[(::Json::Value::UInt)1] = (::Json::Value::UInt)message.GetRegionId();
    eventArguments[(::Json::Value::UInt)2] = (::Json::Value::UInt)message.GetGroupCategory();
}

static void GetEventArgumentsForonPopupVisible(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForOnMICStatusUpdate(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::MicStatus const & message = static_cast< ::MicStatus const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (bool)message.GetStatus();
}

static void GetEventArgumentsForonPopupQueued(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForOnVolumePopupReq(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::VolumePopupReqMsg const & message = static_cast< ::VolumePopupReqMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetU32RegionID();
}

static void GetEventArgumentsForonControlPanelPopupSurfaceInvisible(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonControlPanelPopupSurfaceVisible(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForOnKDSStatusUpd(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::KDSStatusUpdMsg const & message = static_cast< ::KDSStatusUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetStatus();
}

static void GetEventArgumentsForOnCMRVoltageError(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SystemFailureUpdate const & message = static_cast< ::SystemFailureUpdate const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetSystemStatus();
    eventArguments[(::Json::Value::UInt)1] = (::Json::Value::UInt)message.GetRegionId();
}

static void GetEventArgumentsForonHomeState(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::ChangeHomeStateMsg const & message = static_cast< ::ChangeHomeStateMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetRegionId();
}

static void GetEventArgumentsForonPopupUnqueued(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonActivateImageProviderRequest(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::hmibase::gadget::ActivateImageProviderReqMsg const & message = static_cast< ::hmibase::gadget::ActivateImageProviderReqMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetInstanceId();
}

static void GetEventArgumentsForOnCMPAVDECCDisconnected(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SystemFailureUpdate const & message = static_cast< ::SystemFailureUpdate const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetRegionId();
}

static void GetEventArgumentsForOnCMASystemConnected(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SystemFailureUpdate const & message = static_cast< ::SystemFailureUpdate const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetRegionId();
}

static void GetEventArgumentsForOnCMPAVDECCConnected(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SystemFailureUpdate const & message = static_cast< ::SystemFailureUpdate const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetRegionId();
}

static void GetEventArgumentsForOnCMAAVDECCConnected(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SystemFailureUpdate const & message = static_cast< ::SystemFailureUpdate const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetRegionId();
}

static void GetEventArgumentsForonPopupTimerExpiry(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::ExpiredPopupTimerResMsg const & message = static_cast< ::ExpiredPopupTimerResMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId();
}

static void GetEventArgumentsForOnCMRNANOMsgDisconnected(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SystemFailureUpdate const & message = static_cast< ::SystemFailureUpdate const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetSystemStatus();
    eventArguments[(::Json::Value::UInt)1] = (::Json::Value::UInt)message.GetRegionId();
}

static void GetEventArgumentsForonCenterPopupSurfaceQueued(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

const ::FeatStd::Char* AppHmi_MasterStateMachineImpl::GetEventName(::FeatStd::UInt32 eventId, ::Courier::Message const & message, Json::Value& eventArguments)
{
    static EventNameMapping events[189] = {
        { 0x00035D50, "OnCMRThermalError", GetEventArgumentsForOnCMRThermalError },
        { 0x00E797FD, "Activate_Camera3", 0 },
        { 0x02DB9738, "Repeat_Increase_Volume_Plus_Button_CabinB", 0 },
        { 0x034DDF87, "onShowWaitScene", 0 },
        { 0x051A0DBA, "Activate_Camera_CabinB", 0 },
        { 0x051C2A90, "onShowTempHMIAppRequestMsg", 0 },
        { 0x0625A8CC, "onEncoderStatusChangedUpdMsg", GetEventArgumentsForonEncoderStatusChangedUpdMsg },
        { 0x07F7DB9E, "Activate_MapOut_CabinA", 0 },
        { 0x0808D9CF, "HourLogicMode_Continue", 0 },
        { 0x0AD24BE6, "onPlayBeep_ROGER", 0 },
        { 0x0AD32850, "onHKStatusChangedUpdMsg", GetEventArgumentsForonHKStatusChangedUpdMsg },
        { 0x0BCB3B05, "Repeat_Reduce_Volume_Minus_Button_CabinA", 0 },
        { 0x0C67441E, "Activate_TestMode", 0 },
        { 0x0D0F5602, "onHMISubStateChanged_STANDBY", 0 },
        { 0x0D92ACA6, "Repeat_Increase_Volume_Plus_Button_CabinA", 0 },
        { 0x0F52F9D4, "onSourcePopupCloseOnTouchReq", 0 },
        { 0x132900A5, "Activate_TestMode_CabinB", 0 },
        { 0x13BCD271, "OnCMRAVDECCDisconnected", GetEventArgumentsForOnCMRAVDECCDisconnected },
        { 0x14599D95, "OnCMCThermalError", GetEventArgumentsForOnCMCThermalError },
        { 0x1565647B, "Reduce_Volume_Minus_Botton", 0 },
        { 0x15C91912, "Open_VolumePopup", 0 },
        { 0x1F21354F, "onHideWaitScene", 0 },
        { 0x1FE343F4, "OnCMGNANOMsgError", GetEventArgumentsForOnCMGNANOMsgError },
        { 0x200CDB2A, "onHide_HeatPopup", 0 },
        { 0x21ACF27B, "OnCMANANOMsgConnected", GetEventArgumentsForOnCMANANOMsgConnected },
        { 0x23B97E51, "onCenterPopupSurfaceVisible", GetEventArgumentsForonCenterPopupSurfaceVisible },
        { 0x256E6748, "Increase_Volume_Plus_Botton_CabinB", 0 },
        { 0x258C5241, "onControlPanelPopupSurfaceUnqueued", GetEventArgumentsForonControlPanelPopupSurfaceUnqueued },
        { 0x26293098, "OnCMANANOMsgDisconnected", GetEventArgumentsForOnCMANANOMsgDisconnected },
        { 0x263EAF7F, "onHKStatusChanged_HK_SELECT_UP", 0 },
        { 0x267B4627, "OnEvalSubSurfaceReqMsg_STATUS_LINE_appHmi_Master", 0 },
        { 0x2688699F, "OnCMPNANOMsgConnected", GetEventArgumentsForOnCMPNANOMsgConnected },
        { 0x26C30D04, "OnPreviousLevelTransitionFinished", 0 },
        { 0x29832AC7, "Activate_CameraOff", 0 },
        { 0x2B7A6C5C, "Repeat_Reduce_Volume_Minus_Botton", 0 },
        { 0x2CF4AC87, "onEvalCommonButtonActivationRequest", 0 },
        { 0x2D00449C, "OnCMCAVDECCConnected", GetEventArgumentsForOnCMCAVDECCConnected },
        { 0x2D3F751C, "RepeatReduceMicVolumeMinusButton", 0 },
        { 0x2EF0C572, "RepeatIncreaseMicVolumePlusButton", 0 },
        { 0x310E1189, "Activate_Media", 0 },
        { 0x3358CB6E, "onHMIStateChange", GetEventArgumentsForonHMIStateChange },
        { 0x34673BD1, "Increase_Volume_Plus_Botton", 0 },
        { 0x346CC7BC, "OnCMGVoltageError", GetEventArgumentsForOnCMGVoltageError },
        { 0x36318290, "Activate_Camera2", 0 },
        { 0x379D8A0C, "ReduceMicVolumeMinusButton", 0 },
        { 0x38960CB8, "Activate_CabinB_LongPress", 0 },
        { 0x403A65A4, "OnDualViewLeftTransitionFinished", 0 },
        { 0x4142D0A7, "OnCMAThermalError", GetEventArgumentsForOnCMAThermalError },
        { 0x437D9EFE, "OnPageFlipFrontFinished", 0 },
        { 0x46281EA6, "onUpdateAntiTheftStatus", GetEventArgumentsForonUpdateAntiTheftStatus },
        { 0x46A0ACCC, "Activate_Camera", 0 },
        { 0x48678D34, "onHMIAppsInitialized", 0 },
        { 0x4B68C684, "Activate_SPI", 0 },
        { 0x4C065E5A, "Activate_BackFROMRVC", 0 },
        { 0x4C8518AE, "onAppStatusPrepare_BACKGROUND", 0 },
        { 0x4D164416, "OnSpeechButtonShortPress", 0 },
        { 0x4D9B3F88, "onEncoder_HMI_BASE_1", GetEventArgumentsForonEncoder_HMI_BASE_1 },
        { 0x4E1EB8A8, "Increase_Volume_Plus_Botton_CabinA", 0 },
        { 0x4E3BB250, "onControlPanelPopupSurfaceQueued", GetEventArgumentsForonControlPanelPopupSurfaceQueued },
        { 0x4ECC3C16, "HourLogicMode_Abort", 0 },
        { 0x50B4DCCA, "OnDualViewRightTransitionFinished", 0 },
        { 0x51B84F3E, "SetMute_UnMute_CabinA", 0 },
        { 0x5220A7C6, "Activate_Camera_CabinA", 0 },
        { 0x52B62830, "onAppFlyinButtonInvisible", GetEventArgumentsForonAppFlyinButtonInvisible },
        { 0x5477484D, "Open_VolumePopup_CabinB", 0 },
        { 0x54B945E8, "Activate_Settings_CabinB", 0 },
        { 0x55417052, "OnSettingsButtonShortRelease", 0 },
        { 0x55E20523, "OnMixSourceIndexConnectionStatusReq", GetEventArgumentsForOnMixSourceIndexConnectionStatusReq },
        { 0x5790D8C1, "onSubSurfaceUpdMsgChanged_BACKGROUND", GetEventArgumentsForonSubSurfaceUpdMsgChanged_BACKGROUND },
        { 0x581B2F63, "OnCMAAVDECCDisconnected", GetEventArgumentsForOnCMAAVDECCDisconnected },
        { 0x5A5C6538, "Activate_Navigation", 0 },
        { 0x5A9FADEA, "OnClonedSurfaceStateChangedUpdMsg", GetEventArgumentsForOnClonedSurfaceStateChangedUpdMsg },
        { 0x5F6D231B, "OnCMGAVDECCError", GetEventArgumentsForOnCMGAVDECCError },
        { 0x62869F5F, "Activate_TestMode_CabinA", 0 },
        { 0x6289368C, "Deactivate_Mic", 0 },
        { 0x62959CC0, "OnSpeechButtonShortRelease", 0 },
        { 0x637272B2, "SetMute_UnMute_CabinB", 0 },
        { 0x6382DD32, "Activate_Camera1", 0 },
        { 0x64580AB9, "onSwipeGesture", GetEventArgumentsForonSwipeGesture },
        { 0x64813382, "onAppFlyinButtonVisible", GetEventArgumentsForonAppFlyinButtonVisible },
        { 0x67584F32, "OnCMPNANOMsgDisconnected", GetEventArgumentsForOnCMPNANOMsgDisconnected },
        { 0x67BDA4C6, "Disclaimer_Confirm_touch", 0 },
        { 0x67E5D82B, "onEncoderStatusChanged_RIGHT_ENC", GetEventArgumentsForonEncoderStatusChanged_RIGHT_ENC },
        { 0x67F7468D, "Activate_CabinA", 0 },
        { 0x6849EFF2, "Open_VolumePopup_CabinA", 0 },
        { 0x694BD271, "Activate_MapOut_CabinB_Icon", 0 },
        { 0x6BC7DFC7, "OnCMAVoltageError", GetEventArgumentsForOnCMAVoltageError },
        { 0x6D1B3A68, "onAppStatusChanged_BACKGROUND", 0 },
        { 0x6FA6513F, "onCommonButtonQueued", 0 },
        { 0x7068B963, "OnCMCNANOMsgDisconnected", GetEventArgumentsForOnCMCNANOMsgDisconnected },
        { 0x728E7B49, "Activate_Camera4", 0 },
        { 0x72D23EFA, "onSourceCabinPopupCloseOnTouchReq", 0 },
        { 0x74F534EE, "OnPageFlipBackFinished", 0 },
        { 0x75331251, "onEvalCommonButtonDeactivationRequest", 0 },
        { 0x758D7839, "onAppFlyInReqVisibleMsg", 0 },
        { 0x76CF2B88, "onHMISubStateChanged_ON", 0 },
        { 0x776D7D8A, "onHMISubStateChanged_OFF", 0 },
        { 0x7CD948CA, "OnCMCNANOMsgConnected", GetEventArgumentsForOnCMCNANOMsgConnected },
        { 0x7FDCF4B7, "OnCMPThermalError", GetEventArgumentsForOnCMPThermalError },
        { 0x802D7A04, "Activate_BTPhone", 0 },
        { 0x81799F68, "Activate_Settings_CabinA", 0 },
        { 0x83C4744B, "IncreaseMicVolumePlusButton", 0 },
        { 0x8A316034, "onShow_HeatPopup", 0 },
        { 0x8BABC231, "onCabinBControlPanelPopupCloseOnTouchReq", 0 },
        { 0x8C79F875, "OnMmiStateStatusUpd_FULL_USER", 0 },
        { 0x8CA9EF75, "onSwipe", 0 },
        { 0x8DA20221, "Activate_Cockpit", 0 },
        { 0x8ED9771A, "ActivateMicHomeCockpit", 0 },
        { 0x8EF1A208, "OnCMASystemDisConnected", GetEventArgumentsForOnCMASystemDisConnected },
        { 0x90A5898B, "OnClonedHKStatusChangedUpdMsg", GetEventArgumentsForOnClonedHKStatusChangedUpdMsg },
        { 0x9208B57C, "onCommonButtonInvisible", 0 },
        { 0x92783F1D, "Activate_Tuner_CabinB", 0 },
        { 0x927E151E, "onEvalContextSwitchRequest", GetEventArgumentsForonEvalContextSwitchRequest },
        { 0x945D15BF, "onSwitchApplicationRequest", GetEventArgumentsForonSwitchApplicationRequest },
        { 0x949ABB48, "onHide_RVC", 0 },
        { 0x96C708F4, "OnCMCVoltageError", GetEventArgumentsForOnCMCVoltageError },
        { 0x99196F0A, "onExpiredDisclaimerTimerMsg", 0 },
        { 0x9A948051, "OnCMPVoltageError", GetEventArgumentsForOnCMPVoltageError },
        { 0x9BDB722F, "onCenterPopupSurfaceInvisible", GetEventArgumentsForonCenterPopupSurfaceInvisible },
        { 0x9CF11D2E, "Activate_Media_CabinB", 0 },
        { 0x9D4DF4FC, "onSubSurfaceUpdMsgChanged_FOREGROUND", GetEventArgumentsForonSubSurfaceUpdMsgChanged_FOREGROUND },
        { 0x9E364C3D, "Activate_Tuner", 0 },
        { 0x9F38DBBE, "OnHourLogiceError", GetEventArgumentsForOnHourLogiceError },
        { 0x9FDF9FD5, "onCabinAControlPanelPopupCloseOnTouchReq", 0 },
        { 0x9FE98C1E, "onDeactivateImageProviderRequest", GetEventArgumentsForonDeactivateImageProviderRequest },
        { 0x9FFDA16E, "Activate_MIC", 0 },
        { 0xA015B998, "OnCMCAVDECCDisconnected", GetEventArgumentsForOnCMCAVDECCDisconnected },
        { 0xA15C3CEE, "onHMISubStateChanged_STANDBY_RESTRICTED", 0 },
        { 0xA1CFF4A5, "OnSpeechButtonLongPress", 0 },
        { 0xA471323D, "SetMicMuteUnMute", 0 },
        { 0xA7CB2497, "onPlayBeep_POI", 0 },
        { 0xAA79C7DD, "onCenterPopupSurfaceUnqueued", GetEventArgumentsForonCenterPopupSurfaceUnqueued },
        { 0xAB89D7A8, "onHMISubStateChanged_SECURE", 0 },
        { 0xAD035754, "OnCMGThermalError", GetEventArgumentsForOnCMGThermalError },
        { 0xAE14DD45, "onShow_RVC", 0 },
        { 0xAFC3F5BB, "OnSpeechButtonLongRelease", 0 },
        { 0xB2E48221, "SetMute_UnMute", 0 },
        { 0xB3A0564E, "onAppFlyInReqInVisibleMsg", 0 },
        { 0xB5F09FC6, "Activate_MapOut_CabinA_Icon", 0 },
        { 0xB78D7AE0, "onPopupVisible", GetEventArgumentsForonPopupVisible },
        { 0xB948BDA5, "onPlayBeep_WARN", 0 },
        { 0xB98C9689, "Repeat_Reduce_Volume_Minus_Button_CabinB", 0 },
        { 0xB99CBEE9, "Activate_MapOut_CabinB", 0 },
        { 0xBA6DE6FA, "onPlayBeep_CLICK", 0 },
        { 0xBAC42E68, "OnMICStatusUpdate", GetEventArgumentsForOnMICStatusUpdate },
        { 0xBBE6896C, "onPopupQueued", GetEventArgumentsForonPopupQueued },
        { 0xBC4788F7, "OnVolumePopupReq", GetEventArgumentsForOnVolumePopupReq },
        { 0xBD2A8102, "onControlPanelPopupSurfaceInvisible", GetEventArgumentsForonControlPanelPopupSurfaceInvisible },
        { 0xBE930143, "ActivateMICSettings", 0 },
        { 0xC1AF66AA, "Activate_Media_CabinA", 0 },
        { 0xC2EBA35E, "onControlPanelPopupSurfaceVisible", GetEventArgumentsForonControlPanelPopupSurfaceVisible },
        { 0xC43F1CE1, "onShowFirstHMIAppRequest", 0 },
        { 0xC5C44F28, "Close_VolumePopup", 0 },
        { 0xC651C60D, "OnMmiStateStatusUpd_FULL_STANDBY", 0 },
        { 0xC8D83B8B, "onHMISubStateChanged_PHONE", 0 },
        { 0xC9C6AD61, "Activate_Tuner_CabinA", 0 },
        { 0xCA8F2E43, "OnKDSStatusUpd", GetEventArgumentsForOnKDSStatusUpd },
        { 0xCC09C306, "Activate_Home_Cockpit", 0 },
        { 0xCD3BD212, "OnCMRVoltageError", GetEventArgumentsForOnCMRVoltageError },
        { 0xCD981DE3, "onUpdateVINStatusToHMI", 0 },
        { 0xCE1EBF2F, "Repeat_Increase_Volume_Plus_Botton", 0 },
        { 0xD374E5C8, "onPlayBeep_SPEED_WARN", 0 },
        { 0xD59939F6, "Reduce_Volume_Minus_Botton_CabinA", 0 },
        { 0xD8CF464D, "onCommonButtonVisible", 0 },
        { 0xD9C7700B, "onHomeState", GetEventArgumentsForonHomeState },
        { 0xDB0D29F4, "onPopupUnqueued", GetEventArgumentsForonPopupUnqueued },
        { 0xDD62EA5B, "onActivateImageProviderRequest", GetEventArgumentsForonActivateImageProviderRequest },
        { 0xDE9448E3, "onAppStatusChanged_FOREGROUND", 0 },
        { 0xE42A61C8, "OnCMPAVDECCDisconnected", GetEventArgumentsForOnCMPAVDECCDisconnected },
        { 0xE4658CFD, "onHMISubStateChanged_NO_DISPLAY", 0 },
        { 0xE50E0F12, "OnCMASystemConnected", GetEventArgumentsForOnCMASystemConnected },
        { 0xE613C2C4, "Activate_CabinB", 0 },
        { 0xE63C1E3C, "onCockpitControlPanelPopupCloseOnTouchReq", 0 },
        { 0xE7DCE080, "OnNextLevelTransitionFinished", 0 },
        { 0xE9A6D56C, "OnFadeAnimationFinished", 0 },
        { 0xEACE8020, "OnCMPAVDECCConnected", GetEventArgumentsForOnCMPAVDECCConnected },
        { 0xEB463F9F, "onCommonButtonUnqueued", 0 },
        { 0xEDE36127, "Activate_Cockpit_LongPress", 0 },
        { 0xEEE32397, "OnCMAAVDECCConnected", GetEventArgumentsForOnCMAAVDECCConnected },
        { 0xF36C49AB, "Activate_Home_CabinB", 0 },
        { 0xF3C96D17, "onPopupTimerExpiry", GetEventArgumentsForonPopupTimerExpiry },
        { 0xF5767F4A, "onPlayBeep_ERROR", 0 },
        { 0xF84B3BD1, "OnZoomOutFinished", 0 },
        { 0xF96478DC, "onHMISubStateChanged_CLOCK", 0 },
        { 0xF9B28228, "Reduce_Volume_Minus_Botton_CabinB", 0 },
        { 0xFA23AE67, "OnCMRNANOMsgDisconnected", GetEventArgumentsForOnCMRNANOMsgDisconnected },
        { 0xFBEEA58F, "OnZoomInFinished", 0 },
        { 0xFC0D2293, "onCenterPopupSurfaceQueued", GetEventArgumentsForonCenterPopupSurfaceQueued },
        { 0xFE1BDED6, "Activate_Home_CabinA", 0 },
    };
    const EventNameMapping* eventEntry = ::Courier::BinarySearch(eventId, events, 189, &EventNameMappingCmp);
    if (eventEntry && (eventId == eventEntry->mEventId)) {
        if (0 != eventEntry->mGetEventArguments) {
            eventEntry->mGetEventArguments(message, eventArguments);
        }
        return eventEntry->mEventName;
    }
    return 0;
}
#endif
// ------------------------------------------------------------------------
struct IdToNameMapping
{
    ::FeatStd::UInt32 mId;
    const ::FeatStd::Char* mName;
};

static ::FeatStd::Int IdToNameMappingCmp(::FeatStd::UInt32 id, const IdToNameMapping& nm)
{
    return (id == nm.mId) ? 0 : ((id < nm.mId) ? -1 : 1);
}

const ::FeatStd::Char * AppHmi_MasterStateMachineImpl::GetNameFromId(::FeatStd::UInt32 id)
{
    static IdToNameMapping names[73] = {
        { 0x02ECAEE7, "M1#Scenes#HomeScreen_CabinB" },
        { 0x10989349, "M1#Scenes#M_Diag" },
        { 0x12074852, "Popups#Scenes#Pfo_CMPVoltageOverWarningError" },
        { 0x131E464F, "Popups#Scenes#HomeScreen_CabinBPopup_Expand" },
        { 0x16B6ED66, "Popups#Scenes#Pfo_MIC2CenterActivePopup" },
        { 0x21890698, "M1#Scenes#MainScene" },
        { 0x22B20209, "M1#Scenes#GoodBye" },
        { 0x24B1D04A, "M1#Scenes#MIC1" },
        { 0x2B80EB5A, "Popups#Scenes#VOLUME_CENTER_POPUP_CABINA" },
        { 0x2D45A398, "Popups#Scenes#Pfo_CMAThermalUnderWarningError" },
        { 0x2E317C22, "Popups#Scenes#HomeScreen_1_POPUPEXP_DEV" },
        { 0x307178B3, "Popups#Scenes#Pfo_CMGNANOMsgDisconnected" },
        { 0x36A927E9, "M1#Scenes#MasterHome" },
        { 0x3752CC34, "M1#Scenes#Device_Locked" },
        { 0x3F9E7CCD, "M1#Scenes#Disclaimer" },
        { 0x3FE9CEFA, "Popups#Scenes#Pfo_CMGVoltageUnderWarningError_Mix" },
        { 0x41B3D25E, "Popups#Scenes#Pfo_CMCAVDECCDisconnected" },
        { 0x4400C18D, "Popups#Scenes#Pfo_CMCVoltageOverWarningError" },
        { 0x462607DC, "Popups#Scenes#Pfo_CMCThermalUnderWarningError" },
        { 0x4658612B, "Popups#Scenes#VOLUME_CENTER_POPUP" },
        { 0x4B9ED8EA, "Popups#Scenes#Pfo_CMAAVDECCDisconnected" },
        { 0x4C669A4B, "Popups#Scenes#Pfo_CMASystemConnected" },
        { 0x50B06723, "Popups#Scenes#SRC_Cockpit" },
        { 0x53C6D426, "Popups#Scenes#Pfo_CMGThermalOverWarningError_Mix" },
        { 0x5AF5F2E7, "Popups#Scenes#Pfo_CMCNANOMsgDisconnected" },
        { 0x5E70DE5C, "Popups#Scenes#Wait_Scene" },
        { 0x6689677B, "Popups#Scenes#Pfo_MIC3CenterDeactivePopup" },
        { 0x67C6904D, "Popups#Scenes#Pfo_MIC3CenterActivePopup" },
        { 0x68D12F96, "Popups#Scenes#Pfo_CMCThermalOverWarningError" },
        { 0x6927F7FE, "Popups#Scenes#Pfo_CMRNANOMsgDisconnected" },
        { 0x7638C2B4, "Popups#Scenes#Pfo_CMPThermalOverWarningError" },
        { 0x76E9146E, "Popups#Scenes#Pfo_CMGThermalUnderWarningError_Mix" },
        { 0x7790AFCE, "Popups#Scenes#SystemHeat_PopUp" },
        { 0x796B04A3, "Popups#Scenes#Pfo_MIC2CenterDeactivePopup" },
        { 0x7B974622, "M1#Scenes#AVRoutingAdapter_Failure" },
        { 0x80742636, "Popups#Scenes#Pfo_SystemStartUpMode" },
        { 0x80B8B63E, "Popups#Scenes#Pfo_CMPAVDECCDisconnected" },
        { 0x80ECB7C9, "Popups#Scenes#Pfo_CMGAVDECCDisconnected" },
        { 0x824B983A, "M1#Scenes#Configuration_Required" },
        { 0x83176572, "Popups#Scenes#Pfo_HourLogicMode" },
        { 0x86436C20, "Popups#Scenes#Pfo_CMGNANOMsgDisconnected_Mix" },
        { 0x8A83FD37, "Popups#Scenes#Pfo_CMAVoltageOverWarningError" },
        { 0x8B087483, "Popups#Scenes#Pfo_CMCVoltageUnderWarningError" },
        { 0x8BE6A55F, "Popups#Scenes#Pfo_CMPThermalUnderWarningError" },
        { 0x8C9C1F21, "Popups#Scenes#Pfo_CMRThermalUnderWarningError" },
        { 0x914694BB, "Popups#Scenes#Pfo_CMGThermalUnderWarningError" },
        { 0x98AE38B1, "Popups#Scenes#Pfo_CMRVoltageOverWarningError" },
        { 0x9D43A9AA, "Popups#Scenes#Pfo_CMGThermalOverWarningError" },
        { 0x9E414C44, "Popups#Scenes#SRC_Cabin" },
        { 0xA0D1D48E, "Popups#Scenes#Pfo_CMPNANOMsgDisconnected" },
        { 0xA3445103, "Popups#Scenes#Pfo_CMGVoltageUnderWarningError" },
        { 0xA477EC1F, "Popups#Scenes#Pfo_CMGAVDECCDisconnected_Mix" },
        { 0xA5433AB9, "Popups#Scenes#Pfo_CMAThermalOverWarningError" },
        { 0xA9A53B76, "Popups#Scenes#HomeScreen_CabinAPopup_Expand" },
        { 0xB0CC4AD2, "Popups#Scenes#Pfo_CMRVoltageUnderWarningError" },
        { 0xB1B02A62, "Popups#Scenes#Pfo_CMGVoltageOverWarningError" },
        { 0xBA19E80F, "Popups#Scenes#Pfo_CMANANOMsgDisconnected" },
        { 0xC6AE7F43, "Popups#Scenes#Pfo_CMRAVDECCDisconnected" },
        { 0xC81C4C9B, "M1#Scenes#Infotainment_OFF" },
        { 0xCDF2E82D, "M1#Scenes#KDSUpdate_Inprogress" },
        { 0xCF7F41DD, "Popups#Scenes#Pfo_CMGVoltageOverWarningError_Mix" },
        { 0xD09765E7, "M1#Scenes#MasterHome_Smart" },
        { 0xD3210FFC, "M1#Scenes#HomeScreen_1_POPUP_DEV" },
        { 0xD8C0D5C3, "M1#Scenes#HMI_OFF" },
        { 0xDC31A9D4, "Popups#Scenes#Pfo_CMAVoltageUnderWarningError" },
        { 0xDE72CC82, "Popups#Scenes#Pfo_CMRThermalOverWarningError" },
        { 0xDE8E8DD7, "Popups#Scenes#Pfo_KDSCompletion_Status" },
        { 0xE07F7B93, "Popups#Scenes#Pfo_SystemStartUpCompletion" },
        { 0xE1FF88FC, "Popups#Scenes#Pfo_CMPVoltageUnderWarningError" },
        { 0xECD54951, "Popups#Scenes#VOLUME_MAIN" },
        { 0xF10F8B2D, "M1#Scenes#HomeScreen_CabinA" },
        { 0xF3500951, "M1#Scenes#RVC_TESTMODE" },
        { 0xFFCACAD5, "M1#Scenes#AppFlyIn" },
    };
    const IdToNameMapping *nameEntry = ::Courier::BinarySearch(id, names, 73, &IdToNameMappingCmp);
    if(nameEntry != 0 && id == nameEntry->mId) {
        return nameEntry->mName;
    }
    return "";
}

// ------------------------------------------------------------------------

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::Notify_Init_Finished()
{
    Action_Notify_Init_Finished();
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acNoAction()
{
    Action_acNoAction();
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acActivateMaster()
{
    Action_acActivateMaster();
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acActivateApplication(::FeatStd::Int32 aSurfaceId, ::FeatStd::Int8 aAppId)
{
    Action_acActivateApplication(Courier::UInt32(aSurfaceId), Courier::Int32(aAppId));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acDeactivateApplication(::FeatStd::Int8 aAppId)
{
    Action_acDeactivateApplication(Courier::Int32(aAppId));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acRequestSourceFM()
{
    Action_acRequestSourceFM();
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acRequestSourceAM()
{
    Action_acRequestSourceAM();
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acRequestSourceMedia()
{
    Action_acRequestSourceMedia();
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acVolumeReq(::FeatStd::Int32 aValue, ::FeatStd::UInt32 aU32RegionID)
{
    Action_acVolumeReq(Courier::Int32(aValue), Courier::UInt32(aU32RegionID));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acMicVolumeReq(::FeatStd::Int32 aValue)
{
    Action_acMicVolumeReq(Courier::Int32(aValue));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acSetCabinVolumeReq(::FeatStd::Int32 aValue)
{
    Action_acSetCabinVolumeReq(Courier::Int32(aValue));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acLastApplicationReq()
{
    Action_acLastApplicationReq();
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acStartBeep(::FeatStd::Int8 aBeepType)
{
    Action_acStartBeep(Courier::Int32(aBeepType));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acRequestHmiSubState()
{
    Action_acRequestHmiSubState();
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acSwitchBacklight(::FeatStd::Int32 aState)
{
    Action_acSwitchBacklight(Courier::Int32(aState));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acActivateExternalImageProviderReq(::FeatStd::Int32 aInstanceId, ::FeatStd::Int32 aActivate)
{
    Action_acActivateExternalImageProviderReq(Courier::Int32(aInstanceId), bool(aActivate));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acDeactivateExternalImageProviderReq(::FeatStd::Int32 aInstanceId, ::FeatStd::UInt32 aActivate)
{
    Action_acDeactivateExternalImageProviderReq(Courier::Int32(aInstanceId), bool(aActivate));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acMasterCommonButtonVisibleReq(::FeatStd::Int32 aStatus)
{
    Action_acMasterCommonButtonVisibleReq(Courier::UInt32(aStatus));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acMasterAppFlyInButtonVisibleReq(::FeatStd::Int32 aStatus)
{
    Action_acMasterAppFlyInButtonVisibleReq(Courier::UInt32(aStatus));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acReqSpeechSession()
{
    Action_acReqSpeechSession();
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acConnect_DisconnectCameraToPluginMsg()
{
    Action_acConnect_DisconnectCameraToPluginMsg();
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acConnectAnalogCameraToPluginMsg(::FeatStd::Int32 aCameraId)
{
    Action_acConnectAnalogCameraToPluginMsg(Courier::UInt32(aCameraId));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acToggleMapOutStatus(::FeatStd::UInt32 aRegionId)
{
    Action_acToggleMapOutStatus(Courier::Int32(aRegionId));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acAudio_Active_SourceReqMsg(::FeatStd::Int32 aActiveApp_Index)
{
    Action_acAudio_Active_SourceReqMsg(Courier::Int32(aActiveApp_Index));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acConnect_Disconnect_AudioToPluginMsg()
{
    Action_acConnect_Disconnect_AudioToPluginMsg();
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acActivateRVC()
{
    Action_acActivateRVC();
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acDeactivateRVC()
{
    Action_acDeactivateRVC();
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acChangeRegion(::FeatStd::Int32 aRegionId)
{
    Action_acChangeRegion(Courier::UInt32(aRegionId));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acContextSwitchFromHomeMsg(::FeatStd::Int32 aRegionId, ::FeatStd::Int32 aSourceAppId, ::FeatStd::Int32 aSourceActivityId, ::FeatStd::Int32 aTargetAppId, ::FeatStd::Int32 aTargetActivityId)
{
    Action_acContextSwitchFromHomeMsg(Courier::Int32(aRegionId), Courier::Int32(aSourceAppId), Courier::Int32(aSourceActivityId), Courier::Int32(aTargetAppId), Courier::Int32(aTargetActivityId));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acContextSwitchWithActiveRegion(::FeatStd::Int32 aSourceAppId, ::FeatStd::Int32 aSourceActivityId, ::FeatStd::Int32 aTargetAppId, ::FeatStd::Int32 aTargetActivityId)
{
    Action_acContextSwitchWithActiveRegion(Courier::Int32(aSourceAppId), Courier::Int32(aSourceActivityId), Courier::Int32(aTargetAppId), Courier::Int32(aTargetActivityId));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acContextSwitchWithLastActiveCabinRegion(::FeatStd::Int32 aSourceAppId, ::FeatStd::Int32 aSourceActivityId, ::FeatStd::Int32 aTargetAppId, ::FeatStd::Int32 aTargetActivityId)
{
    Action_acContextSwitchWithLastActiveCabinRegion(Courier::Int32(aSourceAppId), Courier::Int32(aSourceActivityId), Courier::Int32(aTargetAppId), Courier::Int32(aTargetActivityId));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acStoreContextSwitchFromHomeMsg(::FeatStd::Int32 aRegionId, ::FeatStd::Int32 aTargetAppId, ::FeatStd::Int32 aTargetActivityId)
{
    Action_acStoreContextSwitchFromHomeMsg(Courier::Int32(aRegionId), Courier::Int32(aTargetAppId), Courier::Int32(aTargetActivityId));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acHourLogicModeStateMsg(bool aStatus)
{
    Action_acHourLogicModeStateMsg(bool(aStatus));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acActivateMIC(::FeatStd::Int32 aValue, bool aStatus, ::FeatStd::UInt8 aKeyType)
{
    Action_acActivateMIC(Courier::Int32(aValue), bool(aStatus), Courier::UInt8(aKeyType));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acApplicationSwitchCompleteMsg()
{
    Action_acApplicationSwitchCompleteMsg();
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acActivate_Speech_Msg(::FeatStd::Int32 aValue)
{
    Action_acActivate_Speech_Msg(Courier::Int32(aValue));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acUpdateSPM_HMI_ON()
{
    Action_acUpdateSPM_HMI_ON();
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acStartDisclaimerTimerReqMsg()
{
    Action_acStartDisclaimerTimerReqMsg();
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acStopDisclaimerTimerReqMsg()
{
    Action_acStopDisclaimerTimerReqMsg();
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acReqHMIReadVIN()
{
    Action_acReqHMIReadVIN();
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acShowCommonButton()
{
    Action_acShowCommonButton();
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acHideCommonButton()
{
    Action_acHideCommonButton();
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acExecuteCommonButtonActivationRequest(bool aActiveStatus)
{
    Action_acExecuteCommonButtonActivationRequest(bool(aActiveStatus));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acEncoderStatusUpdateMsg(::FeatStd::UInt32 aU32EncoderKey, ::FeatStd::Int32 aEncoderSteps)
{
    Action_acEncoderStatusUpdateMsg(Courier::UInt32(aU32EncoderKey), Courier::Int32(aEncoderSteps));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acHKStatusUpdateMsg(::FeatStd::UInt32 aHkCode, ::FeatStd::UInt8 aHkState)
{
    Action_acHKStatusUpdateMsg(Courier::UInt32(aHkCode), Courier::UInt8(aHkState));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acToggleMuteState(::FeatStd::UInt32 aU32RegionID)
{
    Action_acToggleMuteState(Courier::UInt32(aU32RegionID));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acPerformSceneStatusUpd(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aActiveStatus)
{
    Action_acPerformSceneStatusUpd(Courier::UInt32(aViewId), Courier::UInt32(aActiveStatus));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acSetSystemMuteRequest(::FeatStd::UInt32 aRegionId, bool aMuteStatus)
{
    Action_acSetSystemMuteRequest(Courier::UInt32(aRegionId), bool(aMuteStatus));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acSetHmiStartupMuteRequest(bool aMuteStatus)
{
    Action_acSetHmiStartupMuteRequest(bool(aMuteStatus));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acControlPanelButtonPressUpdate(::FeatStd::UInt8 aControlPanelButton, ::FeatStd::UInt8 aButtonstate, ::FeatStd::UInt32 aReceiverAppID)
{
    Action_acControlPanelButtonPressUpdate(Courier::UInt8(aControlPanelButton), Courier::UInt8(aButtonstate), Courier::UInt32(aReceiverAppID));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acShowAppflyIn()
{
    Action_acShowAppflyIn();
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acHideAppFlyIn()
{
    Action_acHideAppFlyIn();
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acExecuteContextSwitchRequest(::FeatStd::Int32 aRegionId, ::FeatStd::Int32 aSourceAppId, ::FeatStd::Int32 aSourceActivityId, ::FeatStd::Int32 aTargetAppId, ::FeatStd::Int32 aTargetActivityId, ::FeatStd::UInt32 aExecuteCode)
{
    Action_acExecuteContextSwitchRequest(Courier::Int32(aRegionId), Courier::Int32(aSourceAppId), Courier::Int32(aSourceActivityId), Courier::Int32(aTargetAppId), Courier::Int32(aTargetActivityId), Courier::UInt32(aExecuteCode));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acClearLastApplication()
{
    Action_acClearLastApplication();
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acRequestReset()
{
    Action_acRequestReset();
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acToggleUserOFF_ON()
{
    Action_acToggleUserOFF_ON();
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acHandleSettingsMsg(::FeatStd::UInt32 aRegionId)
{
    Action_acHandleSettingsMsg(Courier::UInt32(aRegionId));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacChangeLanguageReq(::FeatStd::Int32 aLanguageId)
{
    Action_gacChangeLanguageReq(enLanguageId(aLanguageId));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacHideFocusInViewReq(::FeatStd::UInt32 aView)
{
    Action_gacHideFocusInViewReq(::Courier::ViewId(AppHmi_MasterStateMachineImpl::GetNameFromId(aView)));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::NextLevelTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_NextLevelTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::PreviousLevelTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_PreviousLevelTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::DualViewLeftTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_DualViewLeftTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::DualViewRightTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_DualViewRightTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::PageFlipBackTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_PageFlipBackTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::PageFlipFrontTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_PageFlipFrontTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::ZoomInTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView, ::FeatStd::Int8 aPos)
{
    Action_ZoomInTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView), Candera::UInt8(aPos));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::ZoomOutTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView, ::FeatStd::Int8 aPos)
{
    Action_ZoomOutTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView), Candera::UInt8(aPos));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::FadeTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_FadeTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacWaitAnimationStartReq()
{
    Action_gacWaitAnimationStartReq();
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acFocusOnRightEncoderReqUpd(bool aIsFocusUsed)
{
    Action_acFocusOnRightEncoderReqUpd(bool(aIsFocusUsed));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acSetGadgetSceenActiveStatus(bool aIsGadgetAtive)
{
    Action_acSetGadgetSceenActiveStatus(bool(aIsGadgetAtive));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acHKNotificationMsg(::FeatStd::Int8 aHKCode, ::FeatStd::Int8 aHKState)
{
    Action_acHKNotificationMsg(Courier::UInt8(aHKCode), Courier::UInt8(aHKState));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acPerform_CloseAllDropdowns()
{
    Action_acPerform_CloseAllDropdowns();
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acPerform_CloseDropdown(::FeatStd::UInt32 aListId)
{
    Action_acPerform_CloseDropdown(::Courier::UInt32(aListId));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acPerform_OpenDropdown(::FeatStd::UInt32 aListId)
{
    Action_acPerform_OpenDropdown(::Courier::UInt32(aListId));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acPerform_ToggleDropdown(::FeatStd::UInt32 aListId)
{
    Action_acPerform_ToggleDropdown(::Courier::UInt32(aListId));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acStartAppPopupTimer(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aTimeout)
{
    Action_acStartAppPopupTimer(Courier::UInt32(aViewId), Courier::UInt32(aTimeout));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acStopAppPopupTimer(::FeatStd::UInt32 aViewId)
{
    Action_acStopAppPopupTimer(Courier::UInt32(aViewId));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acPostBeep(::FeatStd::Int8 aBeepType)
{
    Action_acPostBeep(Courier::Int32(aBeepType));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacCheckToClosePopup(::FeatStd::UInt32 aPopupId)
{
    Action_gacCheckToClosePopup(Courier::UInt32(aPopupId));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::acRestartAppPopupTimer(::FeatStd::UInt32 aViewId)
{
    Action_acRestartAppPopupTimer(Courier::UInt32(aViewId));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacContextSwitchBackRes(::FeatStd::UInt32 aSwitchId)
{
    Action_gacContextSwitchBackRes(Courier::UInt32(aSwitchId));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacContextSwitchCompleteRes(::FeatStd::UInt32 aSwitchId)
{
    Action_gacContextSwitchCompleteRes(Courier::UInt32(aSwitchId));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacContextSwitchFailedRes(::FeatStd::UInt32 aSwitchId)
{
    Action_gacContextSwitchFailedRes(Courier::UInt32(aSwitchId));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacContextSwitchDoneRes(::FeatStd::UInt32 aSwitchId)
{
    Action_gacContextSwitchDoneRes(Courier::UInt32(aSwitchId));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacContextSwitchOutReq(::FeatStd::UInt32 aTargetContextId, ::FeatStd::UInt32 aSourceContextId, ::FeatStd::UInt32 aTargetAppId)
{
    Action_gacContextSwitchOutReq(Courier::UInt32(aTargetContextId), Courier::UInt32(aSourceContextId), Courier::UInt32(aTargetAppId));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacCurrentScreenDisplayReq()
{
    Action_gacCurrentScreenDisplayReq();
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacLaunchBarDisplayReq(bool aVisibility)
{
    Action_gacLaunchBarDisplayReq(bool(aVisibility));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacNavTBTSwipe()
{
    Action_gacNavTBTSwipe();
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacPerformListBtnRightEncoderChangeUpd(::FeatStd::Int8 aSteps, ::FeatStd::UInt32 aListId, ::FeatStd::UInt32 aRowId, ::FeatStd::UInt32 aColumnId)
{
    Action_gacPerformListBtnRightEncoderChangeUpd(Courier::Int8(aSteps), Courier::UInt32(aListId), Courier::UInt32(aRowId), Courier::UInt32(aColumnId));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacScrollListUp()
{
    Action_gacScrollListUp();
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacScrollListDown()
{
    Action_gacScrollListDown();
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacScrollPageUp()
{
    Action_gacScrollPageUp();
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacScrollPageDown()
{
    Action_gacScrollPageDown();
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacScrollListFocusUp(::FeatStd::UInt32 aListId)
{
    Action_gacScrollListFocusUp(Courier::UInt32(aListId));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacScrollListFocusDown(::FeatStd::UInt32 aListId)
{
    Action_gacScrollListFocusDown(Courier::UInt32(aListId));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacPerformListFocusLockDataResetUpd()
{
    Action_gacPerformListFocusLockDataResetUpd();
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacSetApplicationMode(::FeatStd::UInt32 aModeId)
{
    Action_gacSetApplicationMode(Courier::UInt32(aModeId));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacSpellerBbehaviorReq(bool aEnable)
{
    Action_gacSpellerBbehaviorReq(bool(aEnable));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacStatusBarDisplayReq(bool aVisibility, ::FeatStd::Int32 aHeaderType)
{
    Action_gacStatusBarDisplayReq(bool(aVisibility), Courier::Int32(aHeaderType));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacTBTRetriggerAcousticOutput()
{
    Action_gacTBTRetriggerAcousticOutput();
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacWaitAnimationStopReq()
{
    Action_gacWaitAnimationStopReq();
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacViewCreateReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewCreateReq(::Courier::ViewId(AppHmi_MasterStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacViewCreateAllReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewCreateAllReq(::Courier::ViewId(AppHmi_MasterStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacViewDestroyReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewDestroyReq(::Courier::ViewId(AppHmi_MasterStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacViewClearReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewClearReq(::Courier::ViewId(AppHmi_MasterStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacViewShowReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewShowReq(::Courier::ViewId(AppHmi_MasterStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacViewHideReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewHideReq(::Courier::ViewId(AppHmi_MasterStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacViewCreateWithoutLoadReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewCreateWithoutLoadReq(::Courier::ViewId(AppHmi_MasterStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacViewAsyncLoadReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewAsyncLoadReq(::Courier::ViewId(AppHmi_MasterStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacViewActivateWithoutRenderingReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewActivateWithoutRenderingReq(::Courier::ViewId(AppHmi_MasterStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacPopupCreateAndSBShowReq(::FeatStd::UInt32 aViewId)
{
    Action_gacPopupCreateAndSBShowReq(::Courier::ViewId(AppHmi_MasterStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacPopupCreateAndSBShowReqForMultiDisplay(::FeatStd::UInt32 aPopupDisplayID, ::FeatStd::UInt32 aViewId)
{
    Action_gacPopupCreateAndSBShowReqForMultiDisplay(Courier::UInt32(aPopupDisplayID), ::Courier::ViewId(AppHmi_MasterStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacPopupSBCloseReq(::FeatStd::UInt32 aViewId)
{
    Action_gacPopupSBCloseReq(::Courier::ViewId(AppHmi_MasterStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacPopupSBCloseReqForMultiDisplay(::FeatStd::UInt32 aPopupDisplayID, ::FeatStd::UInt32 aViewId)
{
    Action_gacPopupSBCloseReqForMultiDisplay(Courier::UInt32(aPopupDisplayID), ::Courier::ViewId(AppHmi_MasterStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacPopupRestartTimerReq(::FeatStd::UInt32 aViewId)
{
    Action_gacPopupRestartTimerReq(::Courier::ViewId(AppHmi_MasterStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacPopupRestartTimerReqForMultiDisplay(::FeatStd::UInt32 aPopupDisplayID, ::FeatStd::UInt32 aViewId)
{
    Action_gacPopupRestartTimerReqForMultiDisplay(Courier::UInt32(aPopupDisplayID), ::Courier::ViewId(AppHmi_MasterStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacViewCreateAndShowReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewCreateAndShowReq(::Courier::ViewId(AppHmi_MasterStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacViewHideAndDestroyReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewHideAndDestroyReq(::Courier::ViewId(AppHmi_MasterStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacSceneTransitionEnter(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aHint)
{
    Action_gacSceneTransitionEnter(::Courier::ViewId(AppHmi_MasterStateMachineImpl::GetNameFromId(aViewId)), Courier::UInt32(aHint));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacSceneTransitionLeave(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aHint)
{
    Action_gacSceneTransitionLeave(::Courier::ViewId(AppHmi_MasterStateMachineImpl::GetNameFromId(aViewId)), Courier::UInt32(aHint));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacDisplayStatusLineReq(::FeatStd::Int32 aDisplayRegionType)
{
    Action_gacDisplayStatusLineReq(Courier::Int32(aDisplayRegionType));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacHideStatusLineReq(::FeatStd::Int32 aDisplayRegionType)
{
    Action_gacHideStatusLineReq(Courier::Int32(aDisplayRegionType));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacDisplayFooterLineReq()
{
    Action_gacDisplayFooterLineReq();
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacHideFooterLineReq()
{
    Action_gacHideFooterLineReq();
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacDisplayStatusLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID)
{
    Action_gacDisplayStatusLineMultiDisplayReq(Courier::Int32(aDisplayRegionType), Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacHideStatusLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID)
{
    Action_gacHideStatusLineMultiDisplayReq(Courier::Int32(aDisplayRegionType), Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacDisplayFooterLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID)
{
    Action_gacDisplayFooterLineMultiDisplayReq(Courier::Int32(aDisplayRegionType), Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacHideFooterLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID)
{
    Action_gacHideFooterLineMultiDisplayReq(Courier::Int32(aDisplayRegionType), Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacRegisterForCloseOnTouchSession(::FeatStd::UInt32 aViewId)
{
    Action_gacRegisterForCloseOnTouchSession(::Courier::ViewId(AppHmi_MasterStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacDeregisterForCloseOnTouchSessionReq(::FeatStd::UInt32 aViewId)
{
    Action_gacDeregisterForCloseOnTouchSessionReq(::Courier::ViewId(AppHmi_MasterStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacPopupFilterPrioEnableReq(::FeatStd::UInt32 aPrio)
{
    Action_gacPopupFilterPrioEnableReq(Courier::UInt32(aPrio));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacPopupFilterAllEnableReq()
{
    Action_gacPopupFilterAllEnableReq();
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacPopupFilterDisableReq()
{
    Action_gacPopupFilterDisableReq();
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacProfileChange(::FeatStd::Int8 aProfile)
{
    Action_gacProfileChange(Courier::UInt32(aProfile));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacPopupFilterPrioEnableReqForDisplay(::FeatStd::UInt32 aPrio, ::FeatStd::UInt32 aDisplayID)
{
    Action_gacPopupFilterPrioEnableReqForDisplay(Courier::UInt32(aPrio), Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacPopupFilterAllEnableReqForDisplay(::FeatStd::UInt32 aDisplayID)
{
    Action_gacPopupFilterAllEnableReqForDisplay(Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacPopupFilterDisableReqForDisplay(::FeatStd::UInt32 aDisplayID)
{
    Action_gacPopupFilterDisableReqForDisplay(Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacStartSceneTransitionAnimation(::FeatStd::UInt32 aSourceView, ::FeatStd::UInt32 aDestinationView, ::FeatStd::UInt32 aUserData1, ::FeatStd::Int8 aUserData2)
{
    Action_gacStartSceneTransitionAnimation(::Courier::ViewId(AppHmi_MasterStateMachineImpl::GetNameFromId(aSourceView)), ::Courier::ViewId(AppHmi_MasterStateMachineImpl::GetNameFromId(aDestinationView)), Courier::UInt32(aUserData1), Courier::Int8(aUserData2));
}

// ------------------------------------------------------------------------
void AppHmi_MasterStateMachineImpl::gacDecrementActiveAnimationCount()
{
    Action_gacDecrementActiveAnimationCount();
}

// ------------------------------------------------------------------------

// ------------------------------------------------------------------------
static inline bool Action_fnIsInf4cvSmartVariant()
{
    return fnIsInf4cvSmartVariant();
}

bool AppHmi_MasterStateMachineImpl::fnIsInf4cvSmartVariant()
{
    return Action_fnIsInf4cvSmartVariant();
}

// ------------------------------------------------------------------------
static inline ::FeatStd::UInt32 Action_fnGetRegionId()
{
    return fnGetRegionId();
}

::FeatStd::UInt32 AppHmi_MasterStateMachineImpl::fnGetRegionId()
{
    return Action_fnGetRegionId();
}

// ------------------------------------------------------------------------
static inline ::FeatStd::UInt32 Action_fnGetLastActiveCabinRegionId()
{
    return fnGetLastActiveCabinRegionId();
}

::FeatStd::UInt32 AppHmi_MasterStateMachineImpl::fnGetLastActiveCabinRegionId()
{
    return Action_fnGetLastActiveCabinRegionId();
}

// ------------------------------------------------------------------------
static inline ::FeatStd::UInt32 Action_fnGetAudioSinkId()
{
    return fnGetAudioSinkId();
}

::FeatStd::UInt32 AppHmi_MasterStateMachineImpl::fnGetAudioSinkId()
{
    return Action_fnGetAudioSinkId();
}

// ------------------------------------------------------------------------
static inline ::FeatStd::UInt32 Action_fnGetRegionIdForAudioSink(::FeatStd::UInt32 aSinkId)
{
    return fnGetRegionIdForAudioSink(aSinkId);
}

::FeatStd::UInt32 AppHmi_MasterStateMachineImpl::fnGetRegionIdForAudioSink(::FeatStd::UInt32 aSinkId)
{
    return Action_fnGetRegionIdForAudioSink(aSinkId);
}

// ------------------------------------------------------------------------
static inline ::FeatStd::UInt32 Action_fnGetAudioSinkIdForRegion(::FeatStd::UInt32 aRegionId)
{
    return fnGetAudioSinkIdForRegion(aRegionId);
}

::FeatStd::UInt32 AppHmi_MasterStateMachineImpl::fnGetAudioSinkIdForRegion(::FeatStd::UInt32 aRegionId)
{
    return Action_fnGetAudioSinkIdForRegion(aRegionId);
}

// ------------------------------------------------------------------------
static inline bool Action_fnIsRegionSupported(::FeatStd::UInt32 aRegionId)
{
    return fnIsRegionSupported(aRegionId);
}

bool AppHmi_MasterStateMachineImpl::fnIsRegionSupported(::FeatStd::UInt32 aRegionId)
{
    return Action_fnIsRegionSupported(aRegionId);
}

// ------------------------------------------------------------------------
static inline ::FeatStd::UInt32 Action_fnGetApplicationId(::FeatStd::UInt32 aSurfaceId)
{
    return fnGetApplicationId(aSurfaceId);
}

::FeatStd::UInt32 AppHmi_MasterStateMachineImpl::fnGetApplicationId(::FeatStd::UInt32 aSurfaceId)
{
    return Action_fnGetApplicationId(aSurfaceId);
}

// ------------------------------------------------------------------------
static inline ::FeatStd::UInt16 Action_fnGetVariantId()
{
    return fnGetVariantId();
}

::FeatStd::UInt16 AppHmi_MasterStateMachineImpl::fnGetVariantId()
{
    return Action_fnGetVariantId();
}

// ------------------------------------------------------------------------
static inline ::FeatStd::UInt16 Action_fnGetVariantType()
{
    return fnGetVariantType();
}

::FeatStd::UInt16 AppHmi_MasterStateMachineImpl::fnGetVariantType()
{
    return Action_fnGetVariantType();
}

// ------------------------------------------------------------------------
static inline bool Action_fnIsAVRoutingAdaperXMLAvailable()
{
    return fnIsAVRoutingAdaperXMLAvailable();
}

bool AppHmi_MasterStateMachineImpl::fnIsAVRoutingAdaperXMLAvailable()
{
    return Action_fnIsAVRoutingAdaperXMLAvailable();
}
#ifdef CIT_SIMULATION
struct ActionMapping
{
    ::FeatStd::UInt32 mHashId;
    bool (*mActionCallHandler)(const ::Json::Value& parameters, ::Json::Value &response);
};

static ::FeatStd::Int ActionMappingCmp(::FeatStd::UInt32 hash, const ActionMapping& am)
{
    return (hash == am.mHashId) ? 0 : ((hash < am.mHashId) ? -1 : 1);
}

bool AppHmi_MasterStateMachineImpl::CallAction(const ::FeatStd::Char* actionName, const ::Json::Value& parameters, ::Json::Value &response)
{
    static ActionMapping actions[151] = {
        { 0x03FA701E, CallAction_acPerformSceneStatusUpd },
        { 0x06E75D2D, CallAction_acShowAppflyIn },
        { 0x0884F877, CallAction_gacScrollListUp },
        { 0x090A895B, CallAction_gacScrollListFocusDown },
        { 0x0A4C5DC9, CallAction_gacDisplayStatusLineMultiDisplayReq },
        { 0x0A7A80CF, CallAction_acActivateExternalImageProviderReq },
        { 0x0BF9B5E9, CallAction_acAudio_Active_SourceReqMsg },
        { 0x0C279721, CallAction_gacDecrementActiveAnimationCount },
        { 0x0DBACC25, CallAction_acActivateRVC },
        { 0x10215902, CallAction_acStoreContextSwitchFromHomeMsg },
        { 0x11915CFE, CallAction_acStopAppPopupTimer },
        { 0x1483139D, CallAction_acToggleUserOFF_ON },
        { 0x15061065, CallAction_gacViewShowReq },
        { 0x1632902C, CallAction_acToggleMapOutStatus },
        { 0x166AAFC9, CallAction_acSetHmiStartupMuteRequest },
        { 0x186A69F1, CallAction_gacWaitAnimationStopReq },
        { 0x187DA604, CallAction_acPerform_OpenDropdown },
        { 0x1BC6E0A9, CallAction_ZoomInTransition },
        { 0x1E1BA505, CallAction_acActivateMIC },
        { 0x21E3828E, CallAction_gacDisplayStatusLineReq },
        { 0x251DE22F, CallAction_gacContextSwitchCompleteRes },
        { 0x254E0D94, CallAction_gacViewHideReq },
        { 0x258104C2, CallAction_DualViewLeftTransition },
        { 0x264B8E81, CallAction_gacPopupRestartTimerReqForMultiDisplay },
        { 0x27CE647F, CallAction_gacScrollListFocusUp },
        { 0x2841E489, CallAction_acExecuteContextSwitchRequest },
        { 0x29D14586, CallAction_gacDisplayFooterLineMultiDisplayReq },
        { 0x2A1E6CB2, CallAction_gacDeregisterForCloseOnTouchSessionReq },
        { 0x2AE288D8, CallAction_gacViewDestroyReq },
        { 0x30C8D840, CallAction_gacStartSceneTransitionAnimation },
        { 0x325BE13A, CallAction_gacViewCreateReq },
        { 0x332B834C, CallAction_acDeactivateExternalImageProviderReq },
        { 0x334571BF, CallAction_acHKNotificationMsg },
        { 0x3BB18A69, CallAction_gacPopupFilterAllEnableReq },
        { 0x3D4C6E63, CallAction_acContextSwitchWithLastActiveCabinRegion },
        { 0x3E4CE5A1, CallAction_gacContextSwitchDoneRes },
        { 0x3E7F9726, CallAction_gacSceneTransitionEnter },
        { 0x3EC2DDD8, CallAction_fnIsAVRoutingAdaperXMLAvailable },
        { 0x41201119, CallAction_acStartAppPopupTimer },
        { 0x438D04D6, CallAction_acStartBeep },
        { 0x4454CED5, CallAction_acExecuteCommonButtonActivationRequest },
        { 0x47F22200, CallAction_acToggleMuteState },
        { 0x4B956393, CallAction_acHandleSettingsMsg },
        { 0x573EB339, CallAction_gacContextSwitchFailedRes },
        { 0x57AA275B, CallAction_gacViewCreateWithoutLoadReq },
        { 0x57B9D100, CallAction_fnGetRegionIdForAudioSink },
        { 0x5841264F, CallAction_fnIsInf4cvSmartVariant },
        { 0x59148CB0, CallAction_FadeTransition },
        { 0x59C82D8E, CallAction_NextLevelTransition },
        { 0x59F03621, CallAction_gacChangeLanguageReq },
        { 0x5D5C4591, CallAction_acClearLastApplication },
        { 0x5FE3FC87, CallAction_fnGetVariantType },
        { 0x60E513C0, CallAction_gacTBTRetriggerAcousticOutput },
        { 0x629132A7, CallAction_gacPopupFilterDisableReq },
        { 0x62D10352, CallAction_acMasterCommonButtonVisibleReq },
        { 0x63C15159, CallAction_acHideCommonButton },
        { 0x65250C54, CallAction_acHKStatusUpdateMsg },
        { 0x65C63A24, CallAction_acNoAction },
        { 0x67093A78, CallAction_acChangeRegion },
        { 0x67B7653B, CallAction_gacDisplayFooterLineReq },
        { 0x67F2215E, CallAction_fnGetVariantId },
        { 0x6EC320A4, CallAction_acStartDisclaimerTimerReqMsg },
        { 0x6EF64E90, CallAction_acRequestReset },
        { 0x6F318DAD, CallAction_acConnectAnalogCameraToPluginMsg },
        { 0x6F470CCC, CallAction_acApplicationSwitchCompleteMsg },
        { 0x752E48B6, CallAction_fnIsRegionSupported },
        { 0x7531D066, CallAction_Notify_Init_Finished },
        { 0x75E49D1D, CallAction_gacPerformListFocusLockDataResetUpd },
        { 0x76EE4CA4, CallAction_gacHideStatusLineMultiDisplayReq },
        { 0x791DF896, CallAction_acPerform_CloseAllDropdowns },
        { 0x7BD0E097, CallAction_acActivate_Speech_Msg },
        { 0x7D7B49B4, CallAction_acFocusOnRightEncoderReqUpd },
        { 0x7EE4AB88, CallAction_gacPopupRestartTimerReq },
        { 0x82D15005, CallAction_PageFlipBackTransition },
        { 0x87608B09, CallAction_acActivateMaster },
        { 0x881D2454, CallAction_gacPopupFilterAllEnableReqForDisplay },
        { 0x8A26A483, CallAction_acReqSpeechSession },
        { 0x8C1A93B3, CallAction_fnGetAudioSinkIdForRegion },
        { 0x8E319345, CallAction_fnGetApplicationId },
        { 0x8FC666C6, CallAction_acDeactivateRVC },
        { 0x91BB105A, CallAction_gacLaunchBarDisplayReq },
        { 0x92784902, CallAction_acMicVolumeReq },
        { 0x93218F8C, CallAction_gacContextSwitchOutReq },
        { 0x948F96CC, CallAction_gacScrollListDown },
        { 0x96350312, CallAction_acSetGadgetSceenActiveStatus },
        { 0x96D3C730, CallAction_gacPopupSBCloseReqForMultiDisplay },
        { 0x976644DB, CallAction_acVolumeReq },
        { 0x99258E0B, CallAction_gacStatusBarDisplayReq },
        { 0x9A3A2149, CallAction_acMasterAppFlyInButtonVisibleReq },
        { 0x9F87F08B, CallAction_acPostBeep },
        { 0x9FA26D73, CallAction_gacPopupFilterDisableReqForDisplay },
        { 0xA0A6F9FA, CallAction_gacViewHideAndDestroyReq },
        { 0xA7B62A65, CallAction_gacPopupFilterPrioEnableReqForDisplay },
        { 0xA84DC23C, CallAction_gacHideFocusInViewReq },
        { 0xA8C6021E, CallAction_acConnect_DisconnectCameraToPluginMsg },
        { 0xA8D07B4A, CallAction_acConnect_Disconnect_AudioToPluginMsg },
        { 0xA958C377, CallAction_acActivateApplication },
        { 0xA9C7F42F, CallAction_gacHideStatusLineReq },
        { 0xAB49461E, CallAction_gacViewCreateAndShowReq },
        { 0xAC9B4667, CallAction_fnGetLastActiveCabinRegionId },
        { 0xAD510A6A, CallAction_acStopDisclaimerTimerReqMsg },
        { 0xAD947FF9, CallAction_gacCurrentScreenDisplayReq },
        { 0xAE48BF55, CallAction_DualViewRightTransition },
        { 0xAF9EBC84, CallAction_acShowCommonButton },
        { 0xAFB14254, CallAction_gacWaitAnimationStartReq },
        { 0xB0AC506C, CallAction_fnGetAudioSinkId },
        { 0xB645346D, CallAction_acDeactivateApplication },
        { 0xB7C78AE5, CallAction_acUpdateSPM_HMI_ON },
        { 0xBAAB15C3, CallAction_acContextSwitchWithActiveRegion },
        { 0xBB441DAC, CallAction_gacRegisterForCloseOnTouchSession },
        { 0xBC73801C, CallAction_acControlPanelButtonPressUpdate },
        { 0xBDECE418, CallAction_gacSetApplicationMode },
        { 0xBEF6021E, CallAction_acPerform_ToggleDropdown },
        { 0xC0F3142E, CallAction_acSetSystemMuteRequest },
        { 0xC37EE8E9, CallAction_gacPopupFilterPrioEnableReq },
        { 0xC51CE603, CallAction_gacViewCreateAllReq },
        { 0xC5DD5738, CallAction_gacProfileChange },
        { 0xC65CAED0, CallAction_gacSpellerBbehaviorReq },
        { 0xC74555BC, CallAction_acContextSwitchFromHomeMsg },
        { 0xC8539D8B, CallAction_gacSceneTransitionLeave },
        { 0xC8EA8B79, CallAction_acRestartAppPopupTimer },
        { 0xC9EB88D6, CallAction_gacViewClearReq },
        { 0xCAF60914, CallAction_acRequestSourceFM },
        { 0xCB8DBDEF, CallAction_gacHideFooterLineReq },
        { 0xCCF1A98B, CallAction_PreviousLevelTransition },
        { 0xCE95AA60, CallAction_acSwitchBacklight },
        { 0xD1AA4F4D, CallAction_ZoomOutTransition },
        { 0xD5F685D5, CallAction_PageFlipFrontTransition },
        { 0xD63C2357, CallAction_gacViewAsyncLoadReq },
        { 0xD6B4DA1C, CallAction_acRequestHmiSubState },
        { 0xD7066A1D, CallAction_acHideAppFlyIn },
        { 0xD98C6419, CallAction_gacViewActivateWithoutRenderingReq },
        { 0xDB665FD5, CallAction_acPerform_CloseDropdown },
        { 0xDBC4E77F, CallAction_acHourLogicModeStateMsg },
        { 0xDD4D179D, CallAction_gacHideFooterLineMultiDisplayReq },
        { 0xDD71F921, CallAction_gacPerformListBtnRightEncoderChangeUpd },
        { 0xE0EF3086, CallAction_gacPopupCreateAndSBShowReqForMultiDisplay },
        { 0xE500B03C, CallAction_gacContextSwitchBackRes },
        { 0xE7796F62, CallAction_acRequestSourceAM },
        { 0xE9CA634A, CallAction_acSetCabinVolumeReq },
        { 0xEB51CB7E, CallAction_gacPopupSBCloseReq },
        { 0xEC64DB0F, CallAction_gacScrollPageDown },
        { 0xEE11F57F, CallAction_gacScrollPageUp },
        { 0xEE131A83, CallAction_gacNavTBTSwipe },
        { 0xEF3D06E3, CallAction_acLastApplicationReq },
        { 0xF0A1D4B5, CallAction_gacCheckToClosePopup },
        { 0xF17E085D, CallAction_gacPopupCreateAndSBShowReq },
        { 0xF68F53B0, CallAction_acRequestSourceMedia },
        { 0xF6C2385B, CallAction_fnGetRegionId },
        { 0xF793C7FB, CallAction_acReqHMIReadVIN },
        { 0xF849238D, CallAction_acEncoderStatusUpdateMsg },
    };
    ::FeatStd::UInt32 hashId = ::Courier::Identifier::CalcHash(actionName);
    const ActionMapping* action = ::Courier::BinarySearch(hashId, actions, 151, &ActionMappingCmp);
    if (action && (hashId == action->mHashId)) {
        return action->mActionCallHandler(parameters, response);
    }
    return false;
}
#endif
namespace Courier {
    COURIER_MESSAGE_CONFIGURATION( ::Courier::UpdateModelMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CameraGroupReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CameraGroupResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ActivationReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ActivationResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewRenderingReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewRenderingResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewMessagingReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewMessagingResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CameraGroupActivationReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CameraGroupActivationResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TryLoadReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::LoadReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DelayedUnloadMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::LoadResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TryAsyncLoadReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::AsyncLoadReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::AsyncLoadResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::AsyncLoadIndMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CameraGroupLoadReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CameraGroupLoadResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ThemeReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ThemeResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::AnimationReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::AnimationResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::AnimationIndMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::SetPropertyReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::SetPropertyResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::SetFocusReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::SetFocusResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::LostFocusIndMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TransitionReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TransitionResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TransitionIndMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::InvalidateReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::RenderReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::RenderResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::LayerReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::LayerResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ParentViewActivateEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ParentViewRenderingEnabledEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ParentViewInitContentEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ParentViewLoadEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::FocusEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::LostFocusEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TransitionStartedEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TransitionFinishedEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::SetCultureReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::SetCultureResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CultureChangeIndMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewPlaceholderReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewPlaceholderResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewMsgBase, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::WidgetMsgBase, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::Internal::DataBindingMsgBase, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::Internal::BindingSourceBaseMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::Internal::ReleaseDataItemMsgBase, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::Internal::DataItemMsgBase, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::Internal::ListEventMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::input::TouchAbort, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::input::TouchSessionStartEvent, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::input::TouchSessionStopEvent, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::IdUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::ConsumerMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::ProviderUpdateIndicationMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::TouchForwardReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::TouchAbortReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::ActivateImageProviderReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::ExternalImageProviderReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::ExternalImageProviderGroupReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::DrmAllocationStatusMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::DrmGarbageCollectorReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::DrmGCTimeoutMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::PositionBaseMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::SlaveSurfaceRepositionBaseMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::DirectTextureConsumerContentIndicationMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::PositionInfoReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::PositionInfoResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::SlaveSurfaceRepositionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::SlaveSurfaceRepositionResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::WidgetCheckReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::NotifierMessage, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TimerExpiredMsg, 15);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::GuiStartupFinishedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CreateNewDestroyOld, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EnterKeyStatusChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusControlReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusGroupReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::UpdateFocusSessionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RefreshFocusSessionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusSessionFinishedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RegisterFocusableWidgetsReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::JoystickStatusChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusChangedReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SurfaceStateChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::LayerStateChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SBPopupTimerExpiryUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::HMISubStateChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::QueryTraceInfoReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FollowUpActionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::WidgetPropertySetterReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SimTouchReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CloseOnTouchReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RegisterForCloseOnTouchSessionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SetClosePopupExternalTouchMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ClosePopupOnExternalTouchReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PlayBeepReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ChangeHmiSubStateReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EvalSubSurfaceReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ExecuteSubSurfaceReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ExecuteSubSurfaceResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ExtendedViewReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::LocalizationReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DecrementActiveAnimationCountMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PopupReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SetApplicationAsMandatoryReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ApplicationStateUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SubSurfaceUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ApplicationRenderedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ApplicationSwitchCompleteUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SubSurfaceSwitchCompleteUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SbAnimationStateChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SbCurrentStatusUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PopupDisplayStatusUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ShowHMISubSurfaceReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StartLayerAnimationReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PopupFilterPrioEnableReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PopupFilterAllEnableReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PopupFilterDisableReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::MultiDisplayPopupFilterReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RestartMenuTimeoutTimerReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RenderingCompleteMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CreateTextMetaDataCollectionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DumpScreenReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TraverseViewsReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropCheckSourceReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropCheckSourceResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropCheckDestinationReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropCheckDestinationResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropCompleteReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropCompleteResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropAbortReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropStatusUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ProfileSwitchMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TransitionMediatorOnDataCompleteMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ManualSceneActionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EglWaitNativeReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EglWaitNativeResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ResetGadgetCacheReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::AttachedAnimationReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::SenderMessage, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::TouchUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::AnimationWidgetReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::AnimationWidgetIndMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ButtonListItemUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ButtonReactionMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ButtonSlideMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ButtonGroupReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ColorBarDataUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::combobox::ComboBoxUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::combobox::ComboBoxReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DropdownCurrentValueChangedMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DropdownChangeMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::editfield::EditFieldUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::editfield::EditFieldHightlightReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gesture::GestureMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gesture::TapGestureMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gesture::DragGestureMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gesture::SwipeGestureMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gesture::PinchSpreadGestureMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gesture::RotateGestureMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gizmo::GizmoUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListDateProviderReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListDateProviderResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListDataProviderUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListChangeMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListAnimatedChangeReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListChangedUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListMovementFinishedUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListStatusUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListVisibiltyUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListFocusChangeReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SliderCurrentValueChangedMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::LockOutMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListItemExpandReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListItemExpandEndUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListCustomAnimationReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListCustomAnimationResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListCustomAnimationIndMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListMorphReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListContentUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListVisualContentUpdateMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListCacheReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::pageedit::PageEditUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PanelSlideReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PanelStateMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SpellerKeyPressed, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SpellerCtrlKeyPressed, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SpellerStatusChangedUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SubSpellerStatusUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TimerWidgetExpiryMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::HWR_CandidateUpdate, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::HWR_TextWidgetUpdate, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ScrollableTextUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActiveSurfaceViewUpdateMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ChangeLanguageReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StartPopupTimerReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StopPopupTimerReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RestartPopupTimerReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ExpiredPopupTimerResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListFocusResetReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EnableCameraRenderingReq, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SwitchApplicationStateReq, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DisableCameraRenderingReq, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DummyMess, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivityMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivateApplicationMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DeactivateApplicationMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::HardKeyPressNotificationMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusOnRightEncoderReqUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StoreActiveGadgetReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CheckToClosePopupMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ContextSwitchOutReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ContextSwitchInResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CurrentScreenDisplayReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::LaunchBarDisplayReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::NavTBTSwipeReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListItemRightEncoderChangeUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListFocusLockDataResetReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListFocusScrollReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SetApplicationModeReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SpellerBbehaviorReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StatusBarDisplayReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TBTRetriggerAcousticMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StartGadgetAnimationReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ControlPanelButtonPressInfo, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ContextSwitchFromHomeMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StoreContextSwitchFromHomeMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ApplicationSwitchCompleteMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SwipeMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ShowHideWaitSceneMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ReqSpeechSessionMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ShowHideRVCSceneMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivateRVCSceneMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SwitchApplicationMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivateMasterApplicationReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivateApplicationReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FirstApplicationActivatedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SetVolumeReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SetMicVolumeReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SetCabinVolumeReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StartBeepReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ToggleMuteStateReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SwitchBacklightReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EnableConnectionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Audio_Active_SourceReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ReqWaitAnimationPopup, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::MmiStateStandByToggleReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::MmiStateStatusReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::MmiStateStatusUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::MapOutStatusUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ToggleMapOutStatus, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Connect_DisconnectCameraToPluginMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ConnectAnalogCameraToPluginMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Connect_DisconnectAudioToPluginMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ChangeRegionMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ChangeHomeStateMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SubSurfaceVisibleMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::AppFlyInReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FaciaON_OFF_Btn_ResetReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FaciaON_OFF_Btn_ShutDownReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivateMIC, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::MicStatus, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::HourLogicModeStateMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CheckAppFlyInVisibilityMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Activate_Speech_Msg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ReqHMIReadVIN, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::UpdateVINStatus, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::UpdateVINStatusToHMI, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::UpdateAntiTheftStatus, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ReqHMIDisplayDisclaimerMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ShowFirstHMIAppRequestMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ShowTempHMIAppRequestMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::UpdateSPM_HMI_ON, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StartDisclaimerTimerReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StopDisclaimerTimerReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ExpiredDisclaimerTimerMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CommonButtonVisibleStatusUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EvalCommonButtonActivationRequestMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ExecuteCommonButtonActivationRequestMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EncoderStatusUpdateMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::HKStatusUpdateMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ExpiredStartupTimerMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SceneStatusInfoMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::VolumePopupReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::MixSourceIndexConnectionStatusReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::AppFlyInActivationReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ClonedHKStatusChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ClonedSurfaceStateChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SetSystemMuteReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SetHmiStartupMuteRequest, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ControlPanelButtonPressUpdate, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EmergencyShutDownReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::KDSStatusUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::HandleSettingsMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DumpContextSwitchStackInfo, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ClearLastApplication, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DumpSystemsInfo, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::updateHMIStateChange, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SimHmiStateChange, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SystemFailureUpdate, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SimSubSystemErrorStatus, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SimVideoMixIndexInfo, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EvalContextSwitchRequestMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ExecuteContextSwitchRequestMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DataModelHomeListUpdateReqMsg, 5);
} // namespace Courier

// ------------------------------------------------------------------------
VolumeInfoDataBindingSource::VolumeInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::VolumeInfoItem)
{
}

// ------------------------------------------------------------------------
VolumeBarInfoDataBindingSource::VolumeBarInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::VolumeBarInfoItem)
{
}

// ------------------------------------------------------------------------
AppFlyInListInfoDataBindingSource::AppFlyInListInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::AppFlyInListInfoItem)
{
}

// ------------------------------------------------------------------------
SystemMuteInfoDataBindingSource::SystemMuteInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SystemMuteInfoItem)
{
}

// ------------------------------------------------------------------------
MmiModeDataBindingSource::MmiModeDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::MmiModeItem)
{
}

// ------------------------------------------------------------------------
KDSStatusInfoDataBindingSource::KDSStatusInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::KDSStatusInfoItem)
{
}

// ------------------------------------------------------------------------
StartupMsgInfoDataBindingSource::StartupMsgInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::StartupMsgInfoItem)
{
}

// ------------------------------------------------------------------------
ControlPanelInfoDataBindingSource::ControlPanelInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::ControlPanelInfoItem)
{
}

// ------------------------------------------------------------------------
CockpitCabinContextDataBindingSource::CockpitCabinContextDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::CockpitCabinContextItem)
{
}

// ------------------------------------------------------------------------
WidgetControllersDataBindingSource::WidgetControllersDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::WidgetControllersItem)
{
}

// ------------------------------------------------------------------------
SourceListItemInfoDataBindingSource::SourceListItemInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SourceListItemInfoItem)
{
}

// ------------------------------------------------------------------------
MIC1VolumeInfoDataBindingSource::MIC1VolumeInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::MIC1VolumeInfoItem)
{
}

// ------------------------------------------------------------------------
Mic1KeyInfoDataBindingSource::Mic1KeyInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::Mic1KeyInfoItem)
{
}

// ------------------------------------------------------------------------
MicCabinStatusDataBindingSource::MicCabinStatusDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::MicCabinStatusItem)
{
}

// ------------------------------------------------------------------------
HomescreenGadgetInfoDataBindingSource::HomescreenGadgetInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::HomescreenGadgetInfoItem)
{
}

// ------------------------------------------------------------------------
ListScrollBarInfoDataBindingSource::ListScrollBarInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::ListScrollBarInfoItem)
{
}

typedef void InvalidData;
struct InvalidDataBindingSource {
    static const ::FeatStd::UInt32 cHierarchyNodeCount = 1;
};

// table of shared DataItemDescriptor
static const ::Courier::Internal::DataBinding::DataItemDescriptor gItemDesc[cDataItemDescriptorCount] = {
    {   // 0 - ::InvalidData
        COURIER_DATA_ITEM_TYPE_ID(::InvalidData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 1 - ::VolumeInfoData
        COURIER_DATA_ITEM_TYPE_ID(::VolumeInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 2 - ::VolumeInfoData::mVolumeValue
        COURIER_DATA_ITEM_TYPE_ID(int),
        COURIER_ITEM_MEMBER(::VolumeInfoData, mVolumeValue)
    },
    {   // 3 - ::VolumeInfoData::mVolumeValueString
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::VolumeInfoData, mVolumeValueString)
    },
    {   // 4 - ::VolumeInfoData::mCabinAVolumeValue
        COURIER_DATA_ITEM_TYPE_ID(int),
        COURIER_ITEM_MEMBER(::VolumeInfoData, mCabinAVolumeValue)
    },
    {   // 5 - ::VolumeInfoData::mCabinAVolumeValueString
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::VolumeInfoData, mCabinAVolumeValueString)
    },
    {   // 6 - ::VolumeInfoData::mVolumeSrc
        COURIER_DATA_ITEM_TYPE_ID(int),
        COURIER_ITEM_MEMBER(::VolumeInfoData, mVolumeSrc)
    },
    {   // 7 - ::VolumeInfoData::mVolumeBarRed
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::VolumeInfoData, mVolumeBarRed)
    },
    {   // 8 - ::VolumeInfoData::mVolumeBarGreen
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::VolumeInfoData, mVolumeBarGreen)
    },
    {   // 9 - ::VolumeInfoData::mCabinAControlPanel_Icon_Status
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::VolumeInfoData, mCabinAControlPanel_Icon_Status)
    },
    {   // 10 - ::VolumeBarInfoData
        COURIER_DATA_ITEM_TYPE_ID(::VolumeBarInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 11 - ::VolumeBarInfoData::mVolume_CurrentVal
        COURIER_DATA_ITEM_TYPE_ID(int),
        COURIER_ITEM_MEMBER(::VolumeBarInfoData, mVolume_CurrentVal)
    },
    {   // 12 - ::VolumeBarInfoData::mVolume_TotalVal
        COURIER_DATA_ITEM_TYPE_ID(int),
        COURIER_ITEM_MEMBER(::VolumeBarInfoData, mVolume_TotalVal)
    },
    {   // 13 - ::VolumeBarInfoData::mVolume_NoOfSteps
        COURIER_DATA_ITEM_TYPE_ID(int),
        COURIER_ITEM_MEMBER(::VolumeBarInfoData, mVolume_NoOfSteps)
    },
    {   // 14 - ::VolumeBarInfoData::mVolume_MaxValue
        COURIER_DATA_ITEM_TYPE_ID(int),
        COURIER_ITEM_MEMBER(::VolumeBarInfoData, mVolume_MaxValue)
    },
    {   // 15 - ::VolumeBarInfoData::mVolume_MinValue
        COURIER_DATA_ITEM_TYPE_ID(int),
        COURIER_ITEM_MEMBER(::VolumeBarInfoData, mVolume_MinValue)
    },
    {   // 16 - ::VolumeBarInfoData::mVolume_StepSize
        COURIER_DATA_ITEM_TYPE_ID(int),
        COURIER_ITEM_MEMBER(::VolumeBarInfoData, mVolume_StepSize)
    },
    {   // 17 - ::AppFlyInListInfoData
        COURIER_DATA_ITEM_TYPE_ID(::AppFlyInListInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 18 - ::AppFlyInListInfoData::mAppFlyInEnability
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::AppFlyInListInfoData, mAppFlyInEnability)
    },
    {   // 19 - ::AppFlyInListInfoData::mAppFlyInImageBg
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::AppFlyInListInfoData, mAppFlyInImageBg)
    },
    {   // 20 - ::AppFlyInListInfoData::mAppFlyInImageIcon
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::AppFlyInListInfoData, mAppFlyInImageIcon)
    },
    {   // 21 - ::AppFlyInListInfoData::mAppFlyInImageBorder
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::AppFlyInListInfoData, mAppFlyInImageBorder)
    },
    {   // 22 - ::SystemMuteInfoData
        COURIER_DATA_ITEM_TYPE_ID(::SystemMuteInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 23 - ::SystemMuteInfoData::mMute_UnMuteVal_Cockpit
        COURIER_DATA_ITEM_TYPE_ID(int),
        COURIER_ITEM_MEMBER(::SystemMuteInfoData, mMute_UnMuteVal_Cockpit)
    },
    {   // 24 - ::SystemMuteInfoData::mMute_UnMuteVal_CabinA
        COURIER_DATA_ITEM_TYPE_ID(int),
        COURIER_ITEM_MEMBER(::SystemMuteInfoData, mMute_UnMuteVal_CabinA)
    },
    {   // 25 - ::SystemMuteInfoData::mMute_UnMuteVal_CabinB
        COURIER_DATA_ITEM_TYPE_ID(int),
        COURIER_ITEM_MEMBER(::SystemMuteInfoData, mMute_UnMuteVal_CabinB)
    },
    {   // 26 - ::MmiModeData
        COURIER_DATA_ITEM_TYPE_ID(::MmiModeData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 27 - ::MmiModeData::mMode
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt32),
        COURIER_ITEM_MEMBER(::MmiModeData, mMode)
    },
    {   // 28 - ::KDSStatusInfoData
        COURIER_DATA_ITEM_TYPE_ID(::KDSStatusInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 29 - ::KDSStatusInfoData::mKDSStatus
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::KDSStatusInfoData, mKDSStatus)
    },
    {   // 30 - ::StartupMsgInfoData
        COURIER_DATA_ITEM_TYPE_ID(::StartupMsgInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 31 - ::StartupMsgInfoData::mPopupInitialVisibility
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::StartupMsgInfoData, mPopupInitialVisibility)
    },
    {   // 32 - ::StartupMsgInfoData::mPopupreadyVisibility
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::StartupMsgInfoData, mPopupreadyVisibility)
    },
    {   // 33 - ::ControlPanelInfoData
        COURIER_DATA_ITEM_TYPE_ID(::ControlPanelInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 34 - ::ControlPanelInfoData::mContext
        COURIER_DATA_ITEM_TYPE_ID(int),
        COURIER_ITEM_MEMBER(::ControlPanelInfoData, mContext)
    },
    {   // 35 - ::ControlPanelInfoData::mSpeechIconEnable
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::ControlPanelInfoData, mSpeechIconEnable)
    },
    {   // 36 - ::ControlPanelInfoData::mMicIconEnableStatus
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::ControlPanelInfoData, mMicIconEnableStatus)
    },
    {   // 37 - ::CockpitCabinContextData
        COURIER_DATA_ITEM_TYPE_ID(::CockpitCabinContextData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 38 - ::CockpitCabinContextData::mCameraStreamStatus_CabinA
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::CockpitCabinContextData, mCameraStreamStatus_CabinA)
    },
    {   // 39 - ::CockpitCabinContextData::mCameraStreamStatus_CabinB
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::CockpitCabinContextData, mCameraStreamStatus_CabinB)
    },
    {   // 40 - ::WidgetControllersData
        COURIER_DATA_ITEM_TYPE_ID(::WidgetControllersData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 41 - ::WidgetControllersData::mswipegesture_id
        COURIER_DATA_ITEM_TYPE_ID(Candera::Int32),
        COURIER_ITEM_MEMBER(::WidgetControllersData, mswipegesture_id)
    },
    {   // 42 - ::WidgetControllersData::mPagination_visibility
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::WidgetControllersData, mPagination_visibility)
    },
    {   // 43 - ::WidgetControllersData::mSwipe_enable_dis
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::WidgetControllersData, mSwipe_enable_dis)
    },
    {   // 44 - ::WidgetControllersData::mScroll_enable_dis
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::WidgetControllersData, mScroll_enable_dis)
    },
    {   // 45 - ::WidgetControllersData::mBG_scro_enable_dis
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::WidgetControllersData, mBG_scro_enable_dis)
    },
    {   // 46 - ::SourceListItemInfoData
        COURIER_DATA_ITEM_TYPE_ID(::SourceListItemInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 47 - ::SourceListItemInfoData::mItemText
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SourceListItemInfoData, mItemText)
    },
    {   // 48 - ::SourceListItemInfoData::mItemIsActive
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SourceListItemInfoData, mItemIsActive)
    },
    {   // 49 - ::SourceListItemInfoData::mItemNormalBitmap
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::SourceListItemInfoData, mItemNormalBitmap)
    },
    {   // 50 - ::SourceListItemInfoData::mItemActiveBitmap
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::SourceListItemInfoData, mItemActiveBitmap)
    },
    {   // 51 - ::SourceListItemInfoData::mItemPressedBitmap
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::SourceListItemInfoData, mItemPressedBitmap)
    },
    {   // 52 - ::MIC1VolumeInfoData
        COURIER_DATA_ITEM_TYPE_ID(::MIC1VolumeInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 53 - ::MIC1VolumeInfoData::mMic1MuteStatus
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::MIC1VolumeInfoData, mMic1MuteStatus)
    },
    {   // 54 - ::MIC1VolumeInfoData::mMic1ProgressBarVolumeValue
        COURIER_DATA_ITEM_TYPE_ID(int),
        COURIER_ITEM_MEMBER(::MIC1VolumeInfoData, mMic1ProgressBarVolumeValue)
    },
    {   // 55 - ::MIC1VolumeInfoData::mMic1VolumeValue
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::MIC1VolumeInfoData, mMic1VolumeValue)
    },
    {   // 56 - ::Mic1KeyInfoData
        COURIER_DATA_ITEM_TYPE_ID(::Mic1KeyInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 57 - ::Mic1KeyInfoData::mMic1TouchabilityStatus
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::Mic1KeyInfoData, mMic1TouchabilityStatus)
    },
    {   // 58 - ::MicCabinStatusData
        COURIER_DATA_ITEM_TYPE_ID(::MicCabinStatusData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 59 - ::MicCabinStatusData::mCabinMicSourceIndex
        COURIER_DATA_ITEM_TYPE_ID(int),
        COURIER_ITEM_MEMBER(::MicCabinStatusData, mCabinMicSourceIndex)
    },
    {   // 60 - ::HomescreenGadgetInfoData
        COURIER_DATA_ITEM_TYPE_ID(::HomescreenGadgetInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 61 - ::HomescreenGadgetInfoData::mGadgetInstanceId
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt32),
        COURIER_ITEM_MEMBER(::HomescreenGadgetInfoData, mGadgetInstanceId)
    },
    {   // 62 - ::HomescreenGadgetInfoData::mGadgetBg
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::HomescreenGadgetInfoData, mGadgetBg)
    },
    {   // 63 - ::HomescreenGadgetInfoData::mGadgetIconAreaBgNormal
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::HomescreenGadgetInfoData, mGadgetIconAreaBgNormal)
    },
    {   // 64 - ::HomescreenGadgetInfoData::mGadgetIconAreaBgPressed
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::HomescreenGadgetInfoData, mGadgetIconAreaBgPressed)
    },
    {   // 65 - ::HomescreenGadgetInfoData::mGadgetIcon
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::HomescreenGadgetInfoData, mGadgetIcon)
    },
    {   // 66 - ::HomescreenGadgetInfoData::mGadgetTouchAreaBgNormal
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::HomescreenGadgetInfoData, mGadgetTouchAreaBgNormal)
    },
    {   // 67 - ::HomescreenGadgetInfoData::mGadgetTouchAreaBgPressed
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::HomescreenGadgetInfoData, mGadgetTouchAreaBgPressed)
    },
    {   // 68 - ::HomescreenGadgetInfoData::mGadgetTouchAreaText
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::HomescreenGadgetInfoData, mGadgetTouchAreaText)
    },
    {   // 69 - ::HomescreenGadgetInfoData::mGadgetTouchAreaTextColour
        COURIER_DATA_ITEM_TYPE_ID(Candera::Color),
        COURIER_ITEM_MEMBER(::HomescreenGadgetInfoData, mGadgetTouchAreaTextColour)
    },
    {   // 70 - ::HomescreenGadgetInfoData::mGadgetMargin
        COURIER_DATA_ITEM_TYPE_ID(Candera::Margin),
        COURIER_ITEM_MEMBER(::HomescreenGadgetInfoData, mGadgetMargin)
    },
    {   // 71 - ::HomescreenGadgetInfoData::mGadgetSize
        COURIER_DATA_ITEM_TYPE_ID(Candera::Vector2),
        COURIER_ITEM_MEMBER(::HomescreenGadgetInfoData, mGadgetSize)
    },
    {   // 72 - ::HomescreenGadgetInfoData::mGadgetContentAvailable
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::HomescreenGadgetInfoData, mGadgetContentAvailable)
    },
    {   // 73 - ::HomescreenGadgetInfoData::mGadgetAnimationStatus
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::HomescreenGadgetInfoData, mGadgetAnimationStatus)
    },
    {   // 74 - ::HomescreenGadgetInfoData::mGadgetFunctionAvailable
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::HomescreenGadgetInfoData, mGadgetFunctionAvailable)
    },
    {   // 75 - ::HomescreenGadgetInfoData::mGadgetMapOutText
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::HomescreenGadgetInfoData, mGadgetMapOutText)
    },
    {   // 76 - ::HomescreenGadgetInfoData::mGadgetVideoMixIconEnableStatus
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::HomescreenGadgetInfoData, mGadgetVideoMixIconEnableStatus)
    },
    {   // 77 - ::HomescreenGadgetInfoData::mGadgetVideoMixIconVisibility
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::HomescreenGadgetInfoData, mGadgetVideoMixIconVisibility)
    },
    {   // 78 - ::HomescreenGadgetInfoData::mGadgetVideoMixText
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::HomescreenGadgetInfoData, mGadgetVideoMixText)
    },
    {   // 79 - ::HomescreenGadgetInfoData::mGadgetNATransparentBg
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::HomescreenGadgetInfoData, mGadgetNATransparentBg)
    },
    {   // 80 - ::HomescreenGadgetInfoData::mGadgetNAAnimationPosition
        COURIER_DATA_ITEM_TYPE_ID(Candera::Margin),
        COURIER_ITEM_MEMBER(::HomescreenGadgetInfoData, mGadgetNAAnimationPosition)
    },
    {   // 81 - ::HomescreenGadgetInfoData::mGadgetNATextPosition
        COURIER_DATA_ITEM_TYPE_ID(Candera::Margin),
        COURIER_ITEM_MEMBER(::HomescreenGadgetInfoData, mGadgetNATextPosition)
    },
    {   // 82 - ::ListScrollBarInfoData
        COURIER_DATA_ITEM_TYPE_ID(::ListScrollBarInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 83 - ::ListScrollBarInfoData::mEnabled
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::ListScrollBarInfoData, mEnabled)
    },
};

// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gInvalidHierarchyNodes[InvalidDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x00000000, /Invalid),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 0,
        /* mParentIndex        */ 0,    // ItemKey::InvalidItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 0,    // ::InvalidData
        /* mItemKey            */ 0
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gVolumeInfoHierarchyNodes[VolumeInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7FC9AA78, /VolumeInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::VolumeInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 1,    // ::VolumeInfoData
        /* mItemKey            */ 35
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7D99F059, /VolumeInfo/VolumeValue),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::VolumeInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 2,    // ::VolumeInfoData::mVolumeValue
        /* mItemKey            */ 34
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x22EEAA7D, /VolumeInfo/VolumeValueString),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::VolumeInfoItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 3,    // ::VolumeInfoData::mVolumeValueString
        /* mItemKey            */ 7
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x458E469A, /VolumeInfo/CabinAVolumeValue),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::VolumeInfoItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 4,    // ::VolumeInfoData::mCabinAVolumeValue
        /* mItemKey            */ 20
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7095F2B3, /VolumeInfo/CabinAVolumeValueString),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::VolumeInfoItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 5,    // ::VolumeInfoData::mCabinAVolumeValueString
        /* mItemKey            */ 30
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB9CAD27A, /VolumeInfo/VolumeSrc),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::VolumeInfoItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 6,    // ::VolumeInfoData::mVolumeSrc
        /* mItemKey            */ 56
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x91B98A6F, /VolumeInfo/VolumeBarRed),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::VolumeInfoItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 7,    // ::VolumeInfoData::mVolumeBarRed
        /* mItemKey            */ 40
    },
    { // 7
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x1F17BEF5, /VolumeInfo/VolumeBarGreen),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::VolumeInfoItem
        /* mLocalIndex         */ 7,
        /* mDescriptorIndex    */ 8,    // ::VolumeInfoData::mVolumeBarGreen
        /* mItemKey            */ 6
    },
    { // 8
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE0A15F92, /VolumeInfo/CabinAControlPanel_Icon_Status),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::VolumeInfoItem
        /* mLocalIndex         */ 8,
        /* mDescriptorIndex    */ 9,    // ::VolumeInfoData::mCabinAControlPanel_Icon_Status
        /* mItemKey            */ 71
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gVolumeBarInfoHierarchyNodes[VolumeBarInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE83B15A1, /VolumeBarInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 2,
        /* mParentIndex        */ 0,    // ItemKey::VolumeBarInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 10,    // ::VolumeBarInfoData
        /* mItemKey            */ 77
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x128D3D3F, /VolumeBarInfo/Volume_CurrentVal),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 2,
        /* mParentIndex        */ 0,    // ItemKey::VolumeBarInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 11,    // ::VolumeBarInfoData::mVolume_CurrentVal
        /* mItemKey            */ 3
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xBCF76A70, /VolumeBarInfo/Volume_TotalVal),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 2,
        /* mParentIndex        */ 0,    // ItemKey::VolumeBarInfoItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 12,    // ::VolumeBarInfoData::mVolume_TotalVal
        /* mItemKey            */ 57
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xDC048E66, /VolumeBarInfo/Volume_NoOfSteps),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 2,
        /* mParentIndex        */ 0,    // ItemKey::VolumeBarInfoItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 13,    // ::VolumeBarInfoData::mVolume_NoOfSteps
        /* mItemKey            */ 68
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF87E6AFE, /VolumeBarInfo/Volume_MaxValue),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 2,
        /* mParentIndex        */ 0,    // ItemKey::VolumeBarInfoItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 14,    // ::VolumeBarInfoData::mVolume_MaxValue
        /* mItemKey            */ 83
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x322DD17F, /VolumeBarInfo/Volume_MinValue),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 2,
        /* mParentIndex        */ 0,    // ItemKey::VolumeBarInfoItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 15,    // ::VolumeBarInfoData::mVolume_MinValue
        /* mItemKey            */ 12
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7700A850, /VolumeBarInfo/Volume_StepSize),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 2,
        /* mParentIndex        */ 0,    // ItemKey::VolumeBarInfoItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 16,    // ::VolumeBarInfoData::mVolume_StepSize
        /* mItemKey            */ 32
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gAppFlyInListInfoHierarchyNodes[AppFlyInListInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x1D8A0171, /AppFlyInListInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 3,
        /* mParentIndex        */ 0,    // ItemKey::AppFlyInListInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 17,    // ::AppFlyInListInfoData
        /* mItemKey            */ 5
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC27B5447, /AppFlyInListInfo/AppFlyInEnability),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 3,
        /* mParentIndex        */ 0,    // ItemKey::AppFlyInListInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 18,    // ::AppFlyInListInfoData::mAppFlyInEnability
        /* mItemKey            */ 58
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x412D2CA7, /AppFlyInListInfo/AppFlyInImageBg),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 3,
        /* mParentIndex        */ 0,    // ItemKey::AppFlyInListInfoItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 19,    // ::AppFlyInListInfoData::mAppFlyInImageBg
        /* mItemKey            */ 16
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x60144BD3, /AppFlyInListInfo/AppFlyInImageIcon),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 3,
        /* mParentIndex        */ 0,    // ItemKey::AppFlyInListInfoItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 20,    // ::AppFlyInListInfoData::mAppFlyInImageIcon
        /* mItemKey            */ 24
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC6120143, /AppFlyInListInfo/AppFlyInImageBorder),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 3,
        /* mParentIndex        */ 0,    // ItemKey::AppFlyInListInfoItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 21,    // ::AppFlyInListInfoData::mAppFlyInImageBorder
        /* mItemKey            */ 60
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSystemMuteInfoHierarchyNodes[SystemMuteInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3A78D6CD, /SystemMuteInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 4,
        /* mParentIndex        */ 0,    // ItemKey::SystemMuteInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 22,    // ::SystemMuteInfoData
        /* mItemKey            */ 13
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x26087A1E, /SystemMuteInfo/Mute_UnMuteVal_Cockpit),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 4,
        /* mParentIndex        */ 0,    // ItemKey::SystemMuteInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 23,    // ::SystemMuteInfoData::mMute_UnMuteVal_Cockpit
        /* mItemKey            */ 8
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA175434B, /SystemMuteInfo/Mute_UnMuteVal_CabinA),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 4,
        /* mParentIndex        */ 0,    // ItemKey::SystemMuteInfoItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 24,    // ::SystemMuteInfoData::mMute_UnMuteVal_CabinA
        /* mItemKey            */ 48
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x93CDA7FC, /SystemMuteInfo/Mute_UnMuteVal_CabinB),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 4,
        /* mParentIndex        */ 0,    // ItemKey::SystemMuteInfoItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 25,    // ::SystemMuteInfoData::mMute_UnMuteVal_CabinB
        /* mItemKey            */ 41
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gMmiModeHierarchyNodes[MmiModeDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x49D6A3AA, /MmiMode),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 5,
        /* mParentIndex        */ 0,    // ItemKey::MmiModeItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 26,    // ::MmiModeData
        /* mItemKey            */ 22
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA0EB0C25, /MmiMode/Mode),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 5,
        /* mParentIndex        */ 0,    // ItemKey::MmiModeItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 27,    // ::MmiModeData::mMode
        /* mItemKey            */ 46
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gKDSStatusInfoHierarchyNodes[KDSStatusInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA4F8485B, /KDSStatusInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 6,
        /* mParentIndex        */ 0,    // ItemKey::KDSStatusInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 28,    // ::KDSStatusInfoData
        /* mItemKey            */ 49
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xCF88C11D, /KDSStatusInfo/KDSStatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 6,
        /* mParentIndex        */ 0,    // ItemKey::KDSStatusInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 29,    // ::KDSStatusInfoData::mKDSStatus
        /* mItemKey            */ 65
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gStartupMsgInfoHierarchyNodes[StartupMsgInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x88640161, /StartupMsgInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 7,
        /* mParentIndex        */ 0,    // ItemKey::StartupMsgInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 30,    // ::StartupMsgInfoData
        /* mItemKey            */ 38
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x99BDB9A7, /StartupMsgInfo/PopupInitialVisibility),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 7,
        /* mParentIndex        */ 0,    // ItemKey::StartupMsgInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 31,    // ::StartupMsgInfoData::mPopupInitialVisibility
        /* mItemKey            */ 45
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x98FA6318, /StartupMsgInfo/PopupreadyVisibility),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 7,
        /* mParentIndex        */ 0,    // ItemKey::StartupMsgInfoItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 32,    // ::StartupMsgInfoData::mPopupreadyVisibility
        /* mItemKey            */ 44
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gControlPanelInfoHierarchyNodes[ControlPanelInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC74FD4F0, /ControlPanelInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 8,
        /* mParentIndex        */ 0,    // ItemKey::ControlPanelInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 33,    // ::ControlPanelInfoData
        /* mItemKey            */ 61
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x2EF9B4D0, /ControlPanelInfo/Context),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 8,
        /* mParentIndex        */ 0,    // ItemKey::ControlPanelInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 34,    // ::ControlPanelInfoData::mContext
        /* mItemKey            */ 11
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x2A6E359A, /ControlPanelInfo/SpeechIconEnable),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 8,
        /* mParentIndex        */ 0,    // ItemKey::ControlPanelInfoItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 35,    // ::ControlPanelInfoData::mSpeechIconEnable
        /* mItemKey            */ 10
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x1029015B, /ControlPanelInfo/MicIconEnableStatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 8,
        /* mParentIndex        */ 0,    // ItemKey::ControlPanelInfoItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 36,    // ::ControlPanelInfoData::mMicIconEnableStatus
        /* mItemKey            */ 1
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gCockpitCabinContextHierarchyNodes[CockpitCabinContextDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD79B4743, /CockpitCabinContext),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 9,
        /* mParentIndex        */ 0,    // ItemKey::CockpitCabinContextItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 37,    // ::CockpitCabinContextData
        /* mItemKey            */ 67
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3E9E8C43, /CockpitCabinContext/CameraStreamStatus_CabinA),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 9,
        /* mParentIndex        */ 0,    // ItemKey::CockpitCabinContextItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 38,    // ::CockpitCabinContextData::mCameraStreamStatus_CabinA
        /* mItemKey            */ 15
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB213732B, /CockpitCabinContext/CameraStreamStatus_CabinB),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 9,
        /* mParentIndex        */ 0,    // ItemKey::CockpitCabinContextItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 39,    // ::CockpitCabinContextData::mCameraStreamStatus_CabinB
        /* mItemKey            */ 51
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gWidgetControllersHierarchyNodes[WidgetControllersDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF635BB6F, /WidgetControllers),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::ReadOnly),
        /* mBindingSourceIndex */ 10,
        /* mParentIndex        */ 0,    // ItemKey::WidgetControllersItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 40,    // ::WidgetControllersData
        /* mItemKey            */ 81
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x11F29532, /WidgetControllers/swipegesture_id),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode) | ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::ReadOnly),
        /* mBindingSourceIndex */ 10,
        /* mParentIndex        */ 0,    // ItemKey::WidgetControllersItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 41,    // ::WidgetControllersData::mswipegesture_id
        /* mItemKey            */ 2
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC8239B4C, /WidgetControllers/Pagination_visibility),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode) | ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::ReadOnly),
        /* mBindingSourceIndex */ 10,
        /* mParentIndex        */ 0,    // ItemKey::WidgetControllersItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 42,    // ::WidgetControllersData::mPagination_visibility
        /* mItemKey            */ 62
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE3D50E33, /WidgetControllers/Swipe_enable_dis),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode) | ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::ReadOnly),
        /* mBindingSourceIndex */ 10,
        /* mParentIndex        */ 0,    // ItemKey::WidgetControllersItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 43,    // ::WidgetControllersData::mSwipe_enable_dis
        /* mItemKey            */ 75
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x8EA08D99, /WidgetControllers/Scroll_enable_dis),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode) | ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::ReadOnly),
        /* mBindingSourceIndex */ 10,
        /* mParentIndex        */ 0,    // ItemKey::WidgetControllersItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 44,    // ::WidgetControllersData::mScroll_enable_dis
        /* mItemKey            */ 39
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x94CE0853, /WidgetControllers/BG_scro_enable_dis),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode) | ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::ReadOnly),
        /* mBindingSourceIndex */ 10,
        /* mParentIndex        */ 0,    // ItemKey::WidgetControllersItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 45,    // ::WidgetControllersData::mBG_scro_enable_dis
        /* mItemKey            */ 42
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSourceListItemInfoHierarchyNodes[SourceListItemInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x977E9F18, /SourceListItemInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 11,
        /* mParentIndex        */ 0,    // ItemKey::SourceListItemInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 46,    // ::SourceListItemInfoData
        /* mItemKey            */ 43
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x729F1B20, /SourceListItemInfo/ItemText),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 11,
        /* mParentIndex        */ 0,    // ItemKey::SourceListItemInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 47,    // ::SourceListItemInfoData::mItemText
        /* mItemKey            */ 31
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x63D6CAFA, /SourceListItemInfo/ItemIsActive),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 11,
        /* mParentIndex        */ 0,    // ItemKey::SourceListItemInfoItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 48,    // ::SourceListItemInfoData::mItemIsActive
        /* mItemKey            */ 26
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x6A6B3280, /SourceListItemInfo/ItemNormalBitmap),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 11,
        /* mParentIndex        */ 0,    // ItemKey::SourceListItemInfoItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 49,    // ::SourceListItemInfoData::mItemNormalBitmap
        /* mItemKey            */ 29
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5A841FAA, /SourceListItemInfo/ItemActiveBitmap),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 11,
        /* mParentIndex        */ 0,    // ItemKey::SourceListItemInfoItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 50,    // ::SourceListItemInfoData::mItemActiveBitmap
        /* mItemKey            */ 23
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7B20E859, /SourceListItemInfo/ItemPressedBitmap),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 11,
        /* mParentIndex        */ 0,    // ItemKey::SourceListItemInfoItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 51,    // ::SourceListItemInfoData::mItemPressedBitmap
        /* mItemKey            */ 33
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gMIC1VolumeInfoHierarchyNodes[MIC1VolumeInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB74CC32A, /MIC1VolumeInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 12,
        /* mParentIndex        */ 0,    // ItemKey::MIC1VolumeInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 52,    // ::MIC1VolumeInfoData
        /* mItemKey            */ 55
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x27E70A5A, /MIC1VolumeInfo/Mic1MuteStatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 12,
        /* mParentIndex        */ 0,    // ItemKey::MIC1VolumeInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 53,    // ::MIC1VolumeInfoData::mMic1MuteStatus
        /* mItemKey            */ 9
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF0529CD2, /MIC1VolumeInfo/Mic1ProgressBarVolumeValue),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 12,
        /* mParentIndex        */ 0,    // ItemKey::MIC1VolumeInfoItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 54,    // ::MIC1VolumeInfoData::mMic1ProgressBarVolumeValue
        /* mItemKey            */ 80
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xDD6BE138, /MIC1VolumeInfo/Mic1VolumeValue),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 12,
        /* mParentIndex        */ 0,    // ItemKey::MIC1VolumeInfoItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 55,    // ::MIC1VolumeInfoData::mMic1VolumeValue
        /* mItemKey            */ 69
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gMic1KeyInfoHierarchyNodes[Mic1KeyInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC33C3EA7, /Mic1KeyInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 13,
        /* mParentIndex        */ 0,    // ItemKey::Mic1KeyInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 56,    // ::Mic1KeyInfoData
        /* mItemKey            */ 59
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB579D2A5, /Mic1KeyInfo/Mic1TouchabilityStatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 13,
        /* mParentIndex        */ 0,    // ItemKey::Mic1KeyInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 57,    // ::Mic1KeyInfoData::mMic1TouchabilityStatus
        /* mItemKey            */ 53
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gMicCabinStatusHierarchyNodes[MicCabinStatusDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE3B0ADC8, /MicCabinStatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 14,
        /* mParentIndex        */ 0,    // ItemKey::MicCabinStatusItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 58,    // ::MicCabinStatusData
        /* mItemKey            */ 74
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3B8C5D8C, /MicCabinStatus/CabinMicSourceIndex),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 14,
        /* mParentIndex        */ 0,    // ItemKey::MicCabinStatusItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 59,    // ::MicCabinStatusData::mCabinMicSourceIndex
        /* mItemKey            */ 14
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gHomescreenGadgetInfoHierarchyNodes[HomescreenGadgetInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB67E6688, /HomescreenGadgetInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 15,
        /* mParentIndex        */ 0,    // ItemKey::HomescreenGadgetInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 60,    // ::HomescreenGadgetInfoData
        /* mItemKey            */ 54
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA165CF6B, /HomescreenGadgetInfo/GadgetInstanceId),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 15,
        /* mParentIndex        */ 0,    // ItemKey::HomescreenGadgetInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 61,    // ::HomescreenGadgetInfoData::mGadgetInstanceId
        /* mItemKey            */ 47
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xCBC553F9, /HomescreenGadgetInfo/GadgetBg),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 15,
        /* mParentIndex        */ 0,    // ItemKey::HomescreenGadgetInfoItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 62,    // ::HomescreenGadgetInfoData::mGadgetBg
        /* mItemKey            */ 64
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x678FB92F, /HomescreenGadgetInfo/GadgetIconAreaBgNormal),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 15,
        /* mParentIndex        */ 0,    // ItemKey::HomescreenGadgetInfoItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 63,    // ::HomescreenGadgetInfoData::mGadgetIconAreaBgNormal
        /* mItemKey            */ 27
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x86CAD5ED, /HomescreenGadgetInfo/GadgetIconAreaBgPressed),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 15,
        /* mParentIndex        */ 0,    // ItemKey::HomescreenGadgetInfoItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 64,    // ::HomescreenGadgetInfoData::mGadgetIconAreaBgPressed
        /* mItemKey            */ 37
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x44418B49, /HomescreenGadgetInfo/GadgetIcon),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 15,
        /* mParentIndex        */ 0,    // ItemKey::HomescreenGadgetInfoItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 65,    // ::HomescreenGadgetInfoData::mGadgetIcon
        /* mItemKey            */ 17
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xCB0985D1, /HomescreenGadgetInfo/GadgetTouchAreaBgNormal),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 15,
        /* mParentIndex        */ 0,    // ItemKey::HomescreenGadgetInfoItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 66,    // ::HomescreenGadgetInfoData::mGadgetTouchAreaBgNormal
        /* mItemKey            */ 63
    },
    { // 7
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x68FC7465, /HomescreenGadgetInfo/GadgetTouchAreaBgPressed),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 15,
        /* mParentIndex        */ 0,    // ItemKey::HomescreenGadgetInfoItem
        /* mLocalIndex         */ 7,
        /* mDescriptorIndex    */ 67,    // ::HomescreenGadgetInfoData::mGadgetTouchAreaBgPressed
        /* mItemKey            */ 28
    },
    { // 8
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE9A480EF, /HomescreenGadgetInfo/GadgetTouchAreaText),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 15,
        /* mParentIndex        */ 0,    // ItemKey::HomescreenGadgetInfoItem
        /* mLocalIndex         */ 8,
        /* mDescriptorIndex    */ 68,    // ::HomescreenGadgetInfoData::mGadgetTouchAreaText
        /* mItemKey            */ 78
    },
    { // 9
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x84C636F5, /HomescreenGadgetInfo/GadgetTouchAreaTextColour),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 15,
        /* mParentIndex        */ 0,    // ItemKey::HomescreenGadgetInfoItem
        /* mLocalIndex         */ 9,
        /* mDescriptorIndex    */ 69,    // ::HomescreenGadgetInfoData::mGadgetTouchAreaTextColour
        /* mItemKey            */ 36
    },
    { // 10
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x60E65270, /HomescreenGadgetInfo/GadgetMargin),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 15,
        /* mParentIndex        */ 0,    // ItemKey::HomescreenGadgetInfoItem
        /* mLocalIndex         */ 10,
        /* mDescriptorIndex    */ 70,    // ::HomescreenGadgetInfoData::mGadgetMargin
        /* mItemKey            */ 25
    },
    { // 11
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB5597960, /HomescreenGadgetInfo/GadgetSize),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 15,
        /* mParentIndex        */ 0,    // ItemKey::HomescreenGadgetInfoItem
        /* mLocalIndex         */ 11,
        /* mDescriptorIndex    */ 71,    // ::HomescreenGadgetInfoData::mGadgetSize
        /* mItemKey            */ 52
    },
    { // 12
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xDE65E7DD, /HomescreenGadgetInfo/GadgetContentAvailable),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 15,
        /* mParentIndex        */ 0,    // ItemKey::HomescreenGadgetInfoItem
        /* mLocalIndex         */ 12,
        /* mDescriptorIndex    */ 72,    // ::HomescreenGadgetInfoData::mGadgetContentAvailable
        /* mItemKey            */ 70
    },
    { // 13
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD7905041, /HomescreenGadgetInfo/GadgetAnimationStatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 15,
        /* mParentIndex        */ 0,    // ItemKey::HomescreenGadgetInfoItem
        /* mLocalIndex         */ 13,
        /* mDescriptorIndex    */ 73,    // ::HomescreenGadgetInfoData::mGadgetAnimationStatus
        /* mItemKey            */ 66
    },
    { // 14
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF822600E, /HomescreenGadgetInfo/GadgetFunctionAvailable),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 15,
        /* mParentIndex        */ 0,    // ItemKey::HomescreenGadgetInfoItem
        /* mLocalIndex         */ 14,
        /* mDescriptorIndex    */ 74,    // ::HomescreenGadgetInfoData::mGadgetFunctionAvailable
        /* mItemKey            */ 82
    },
    { // 15
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x182C7118, /HomescreenGadgetInfo/GadgetMapOutText),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 15,
        /* mParentIndex        */ 0,    // ItemKey::HomescreenGadgetInfoItem
        /* mLocalIndex         */ 15,
        /* mDescriptorIndex    */ 75,    // ::HomescreenGadgetInfoData::mGadgetMapOutText
        /* mItemKey            */ 4
    },
    { // 16
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA788732B, /HomescreenGadgetInfo/GadgetVideoMixIconEnableStatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 15,
        /* mParentIndex        */ 0,    // ItemKey::HomescreenGadgetInfoItem
        /* mLocalIndex         */ 16,
        /* mDescriptorIndex    */ 76,    // ::HomescreenGadgetInfoData::mGadgetVideoMixIconEnableStatus
        /* mItemKey            */ 50
    },
    { // 17
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE540DEDA, /HomescreenGadgetInfo/GadgetVideoMixIconVisibility),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 15,
        /* mParentIndex        */ 0,    // ItemKey::HomescreenGadgetInfoItem
        /* mLocalIndex         */ 17,
        /* mDescriptorIndex    */ 77,    // ::HomescreenGadgetInfoData::mGadgetVideoMixIconVisibility
        /* mItemKey            */ 76
    },
    { // 18
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE14D363A, /HomescreenGadgetInfo/GadgetVideoMixText),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 15,
        /* mParentIndex        */ 0,    // ItemKey::HomescreenGadgetInfoItem
        /* mLocalIndex         */ 18,
        /* mDescriptorIndex    */ 78,    // ::HomescreenGadgetInfoData::mGadgetVideoMixText
        /* mItemKey            */ 72
    },
    { // 19
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x44931A55, /HomescreenGadgetInfo/GadgetNATransparentBg),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 15,
        /* mParentIndex        */ 0,    // ItemKey::HomescreenGadgetInfoItem
        /* mLocalIndex         */ 19,
        /* mDescriptorIndex    */ 79,    // ::HomescreenGadgetInfoData::mGadgetNATransparentBg
        /* mItemKey            */ 18
    },
    { // 20
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xEC5B3C52, /HomescreenGadgetInfo/GadgetNAAnimationPosition),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 15,
        /* mParentIndex        */ 0,    // ItemKey::HomescreenGadgetInfoItem
        /* mLocalIndex         */ 20,
        /* mDescriptorIndex    */ 80,    // ::HomescreenGadgetInfoData::mGadgetNAAnimationPosition
        /* mItemKey            */ 79
    },
    { // 21
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x47C2BADB, /HomescreenGadgetInfo/GadgetNATextPosition),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 15,
        /* mParentIndex        */ 0,    // ItemKey::HomescreenGadgetInfoItem
        /* mLocalIndex         */ 21,
        /* mDescriptorIndex    */ 81,    // ::HomescreenGadgetInfoData::mGadgetNATextPosition
        /* mItemKey            */ 21
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gListScrollBarInfoHierarchyNodes[ListScrollBarInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x44E9662C, /ListScrollBarInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 16,
        /* mParentIndex        */ 0,    // ItemKey::ListScrollBarInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 82,    // ::ListScrollBarInfoData
        /* mItemKey            */ 19
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE2697E96, /ListScrollBarInfo/Enabled),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 16,
        /* mParentIndex        */ 0,    // ItemKey::ListScrollBarInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 83,    // ::ListScrollBarInfoData::mEnabled
        /* mItemKey            */ 73
    },
};

// array of pointers to all hierarchy nodes - sorted by HashId
const ::Courier::Internal::DataBinding::DataItemHierarchyNode * const gGlobalHierachyNodeTable[cGlobalDataItemHierarchyNodeCount] = {
    &gInvalidHierarchyNodes[0],
    &gControlPanelInfoHierarchyNodes[3],
    &gWidgetControllersHierarchyNodes[1],
    &gVolumeBarInfoHierarchyNodes[1],
    &gHomescreenGadgetInfoHierarchyNodes[15],
    &gAppFlyInListInfoHierarchyNodes[0],
    &gVolumeInfoHierarchyNodes[7],
    &gVolumeInfoHierarchyNodes[2],
    &gSystemMuteInfoHierarchyNodes[1],
    &gMIC1VolumeInfoHierarchyNodes[1],
    &gControlPanelInfoHierarchyNodes[2],
    &gControlPanelInfoHierarchyNodes[1],
    &gVolumeBarInfoHierarchyNodes[5],
    &gSystemMuteInfoHierarchyNodes[0],
    &gMicCabinStatusHierarchyNodes[1],
    &gCockpitCabinContextHierarchyNodes[1],
    &gAppFlyInListInfoHierarchyNodes[2],
    &gHomescreenGadgetInfoHierarchyNodes[5],
    &gHomescreenGadgetInfoHierarchyNodes[19],
    &gListScrollBarInfoHierarchyNodes[0],
    &gVolumeInfoHierarchyNodes[3],
    &gHomescreenGadgetInfoHierarchyNodes[21],
    &gMmiModeHierarchyNodes[0],
    &gSourceListItemInfoHierarchyNodes[4],
    &gAppFlyInListInfoHierarchyNodes[3],
    &gHomescreenGadgetInfoHierarchyNodes[10],
    &gSourceListItemInfoHierarchyNodes[2],
    &gHomescreenGadgetInfoHierarchyNodes[3],
    &gHomescreenGadgetInfoHierarchyNodes[7],
    &gSourceListItemInfoHierarchyNodes[3],
    &gVolumeInfoHierarchyNodes[4],
    &gSourceListItemInfoHierarchyNodes[1],
    &gVolumeBarInfoHierarchyNodes[6],
    &gSourceListItemInfoHierarchyNodes[5],
    &gVolumeInfoHierarchyNodes[1],
    &gVolumeInfoHierarchyNodes[0],
    &gHomescreenGadgetInfoHierarchyNodes[9],
    &gHomescreenGadgetInfoHierarchyNodes[4],
    &gStartupMsgInfoHierarchyNodes[0],
    &gWidgetControllersHierarchyNodes[4],
    &gVolumeInfoHierarchyNodes[6],
    &gSystemMuteInfoHierarchyNodes[3],
    &gWidgetControllersHierarchyNodes[5],
    &gSourceListItemInfoHierarchyNodes[0],
    &gStartupMsgInfoHierarchyNodes[2],
    &gStartupMsgInfoHierarchyNodes[1],
    &gMmiModeHierarchyNodes[1],
    &gHomescreenGadgetInfoHierarchyNodes[1],
    &gSystemMuteInfoHierarchyNodes[2],
    &gKDSStatusInfoHierarchyNodes[0],
    &gHomescreenGadgetInfoHierarchyNodes[16],
    &gCockpitCabinContextHierarchyNodes[2],
    &gHomescreenGadgetInfoHierarchyNodes[11],
    &gMic1KeyInfoHierarchyNodes[1],
    &gHomescreenGadgetInfoHierarchyNodes[0],
    &gMIC1VolumeInfoHierarchyNodes[0],
    &gVolumeInfoHierarchyNodes[5],
    &gVolumeBarInfoHierarchyNodes[2],
    &gAppFlyInListInfoHierarchyNodes[1],
    &gMic1KeyInfoHierarchyNodes[0],
    &gAppFlyInListInfoHierarchyNodes[4],
    &gControlPanelInfoHierarchyNodes[0],
    &gWidgetControllersHierarchyNodes[2],
    &gHomescreenGadgetInfoHierarchyNodes[6],
    &gHomescreenGadgetInfoHierarchyNodes[2],
    &gKDSStatusInfoHierarchyNodes[1],
    &gHomescreenGadgetInfoHierarchyNodes[13],
    &gCockpitCabinContextHierarchyNodes[0],
    &gVolumeBarInfoHierarchyNodes[3],
    &gMIC1VolumeInfoHierarchyNodes[3],
    &gHomescreenGadgetInfoHierarchyNodes[12],
    &gVolumeInfoHierarchyNodes[8],
    &gHomescreenGadgetInfoHierarchyNodes[18],
    &gListScrollBarInfoHierarchyNodes[1],
    &gMicCabinStatusHierarchyNodes[0],
    &gWidgetControllersHierarchyNodes[3],
    &gHomescreenGadgetInfoHierarchyNodes[17],
    &gVolumeBarInfoHierarchyNodes[0],
    &gHomescreenGadgetInfoHierarchyNodes[8],
    &gHomescreenGadgetInfoHierarchyNodes[20],
    &gMIC1VolumeInfoHierarchyNodes[2],
    &gWidgetControllersHierarchyNodes[0],
    &gHomescreenGadgetInfoHierarchyNodes[14],
    &gVolumeBarInfoHierarchyNodes[4],
};

// binding source root table - indexed with BindingSourceIndex 
static const ::Courier::Internal::DataBinding::BindingSourceRootStorage gBindingSourceMap[cBindingSourceCount] = {
    { InvalidDataBindingSource::cHierarchyNodeCount, gInvalidHierarchyNodes },
    { VolumeInfoDataBindingSource::cHierarchyNodeCount, gVolumeInfoHierarchyNodes },
    { VolumeBarInfoDataBindingSource::cHierarchyNodeCount, gVolumeBarInfoHierarchyNodes },
    { AppFlyInListInfoDataBindingSource::cHierarchyNodeCount, gAppFlyInListInfoHierarchyNodes },
    { SystemMuteInfoDataBindingSource::cHierarchyNodeCount, gSystemMuteInfoHierarchyNodes },
    { MmiModeDataBindingSource::cHierarchyNodeCount, gMmiModeHierarchyNodes },
    { KDSStatusInfoDataBindingSource::cHierarchyNodeCount, gKDSStatusInfoHierarchyNodes },
    { StartupMsgInfoDataBindingSource::cHierarchyNodeCount, gStartupMsgInfoHierarchyNodes },
    { ControlPanelInfoDataBindingSource::cHierarchyNodeCount, gControlPanelInfoHierarchyNodes },
    { CockpitCabinContextDataBindingSource::cHierarchyNodeCount, gCockpitCabinContextHierarchyNodes },
    { WidgetControllersDataBindingSource::cHierarchyNodeCount, gWidgetControllersHierarchyNodes },
    { SourceListItemInfoDataBindingSource::cHierarchyNodeCount, gSourceListItemInfoHierarchyNodes },
    { MIC1VolumeInfoDataBindingSource::cHierarchyNodeCount, gMIC1VolumeInfoHierarchyNodes },
    { Mic1KeyInfoDataBindingSource::cHierarchyNodeCount, gMic1KeyInfoHierarchyNodes },
    { MicCabinStatusDataBindingSource::cHierarchyNodeCount, gMicCabinStatusHierarchyNodes },
    { HomescreenGadgetInfoDataBindingSource::cHierarchyNodeCount, gHomescreenGadgetInfoHierarchyNodes },
    { ListScrollBarInfoDataBindingSource::cHierarchyNodeCount, gListScrollBarInfoHierarchyNodes },
};

// Init function prototype
static bool InitDataBindingGenerated(void);

// Infrastructure defnition
static const ::Courier::Internal::DataBinding::DataBindingInfrastructure gInfrastructure = { 
    cGlobalDataItemHierarchyNodeCount, gGlobalHierachyNodeTable, 
    cBindingSourceCount, gBindingSourceMap,
    cDataItemDescriptorCount, gItemDesc,
    &InitDataBindingGenerated
};

// ------------------------------------------------------------------------
static bool InitDataBindingGenerated(void)
{
    /* if one of these assertion fails, increase the limits defined in Courier/DataBinding/Infrastructure.h */
    COURIER_COMPILETIME_ASSERT(cBindingSourceItemCountMax < ::Courier::cBindingSourceHierarchyNodeMax);
    COURIER_COMPILETIME_ASSERT(cDataItemDescriptorCount < ::Courier::cItemDescriptorMax);
    COURIER_COMPILETIME_ASSERT(cBindingSourceCount < ::Courier::cBindingSourceMax);

    static ::Courier::Internal::DataBinding::BindingSourceRevisionStoreImpl<cBindingSourceCount> theRevisionStore;

    bool ok = true;
    {
        FEATSTD_UNSYNCED_STATIC_OBJECT(VolumeInfoDataBindingSource, bsVolumeInfo);
        FEATSTD_UNSYNCED_STATIC_OBJECT(VolumeBarInfoDataBindingSource, bsVolumeBarInfo);
        FEATSTD_UNSYNCED_STATIC_OBJECT(AppFlyInListInfoDataBindingSource, bsAppFlyInListInfo);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SystemMuteInfoDataBindingSource, bsSystemMuteInfo);
        FEATSTD_UNSYNCED_STATIC_OBJECT(KDSStatusInfoDataBindingSource, bsKDSStatusInfo);
        FEATSTD_UNSYNCED_STATIC_OBJECT(StartupMsgInfoDataBindingSource, bsStartupMsgInfo);
        FEATSTD_UNSYNCED_STATIC_OBJECT(ControlPanelInfoDataBindingSource, bsControlPanelInfo);
        FEATSTD_UNSYNCED_STATIC_OBJECT(CockpitCabinContextDataBindingSource, bsCockpitCabinContext);
        FEATSTD_UNSYNCED_STATIC_OBJECT(WidgetControllersDataBindingSource, bsWidgetControllers);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SourceListItemInfoDataBindingSource, bsSourceListItemInfo);
        FEATSTD_UNSYNCED_STATIC_OBJECT(MIC1VolumeInfoDataBindingSource, bsMIC1VolumeInfo);
        FEATSTD_UNSYNCED_STATIC_OBJECT(Mic1KeyInfoDataBindingSource, bsMic1KeyInfo);
        FEATSTD_UNSYNCED_STATIC_OBJECT(MicCabinStatusDataBindingSource, bsMicCabinStatus);
        FEATSTD_UNSYNCED_STATIC_OBJECT(HomescreenGadgetInfoDataBindingSource, bsHomescreenGadgetInfo);
        FEATSTD_UNSYNCED_STATIC_OBJECT(ListScrollBarInfoDataBindingSource, bsListScrollBarInfo);
        static ::Courier::Internal::ModelBindingSource *bindingSources[cBindingSourceCount] = { 
            0,
            &bsVolumeInfo, 
            &bsVolumeBarInfo, 
            &bsAppFlyInListInfo, 
            &bsSystemMuteInfo, 
            0,
            &bsKDSStatusInfo, 
            &bsStartupMsgInfo, 
            &bsControlPanelInfo, 
            &bsCockpitCabinContext, 
            &bsWidgetControllers, 
            &bsSourceListItemInfo, 
            &bsMIC1VolumeInfo, 
            &bsMic1KeyInfo, 
            &bsMicCabinStatus, 
            &bsHomescreenGadgetInfo, 
            &bsListScrollBarInfo, 
        };
        ok = ok && ::Courier::Register(::Courier::ComponentId(::Courier::ComponentType::View), bindingSources, cBindingSourceCount);
    }
    {
        FEATSTD_UNSYNCED_STATIC_OBJECT(::Courier::Internal::AsyncGenericModelBindingSource, bsMmiMode, ItemKey::MmiModeItem);
        FEATSTD_UNSYNCED_STATIC_OBJECT(::Courier::Internal::AsyncGenericModelBindingSource, bsControlPanelInfo, ItemKey::ControlPanelInfoItem);
        static ::Courier::Internal::ModelBindingSource *bindingSources[cBindingSourceCount] = { 
            0,
            0,
            0,
            0,
            0,
            &bsMmiMode, 
            0,
            0,
            &bsControlPanelInfo, 
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
        };
        ok = ok && ::Courier::Register(::Courier::ComponentId(::Courier::ComponentType::Controller), bindingSources, cBindingSourceCount);
    }
    return ok;
}

namespace Courier {
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::VolumeInfoDataBindingSource>, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::VolumeBarInfoDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::AppFlyInListInfoDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SystemMuteInfoDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::MmiModeDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::KDSStatusInfoDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::StartupMsgInfoDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::ControlPanelInfoDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::CockpitCabinContextDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::WidgetControllersDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SourceListItemInfoDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::MIC1VolumeInfoDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::Mic1KeyInfoDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::MicCabinStatusDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::HomescreenGadgetInfoDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::ListScrollBarInfoDataBindingSource>, 5);
} // namespace Courier

#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
namespace FeatStd {
// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::VolumeInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::VolumeInfoDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::VolumeBarInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::VolumeBarInfoDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::AppFlyInListInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::AppFlyInListInfoDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SystemMuteInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SystemMuteInfoDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::MmiModeDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::MmiModeDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::KDSStatusInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::KDSStatusInfoDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::StartupMsgInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::StartupMsgInfoDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ControlPanelInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ControlPanelInfoDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::CockpitCabinContextDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::CockpitCabinContextDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::WidgetControllersDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::WidgetControllersDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SourceListItemInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SourceListItemInfoDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::MIC1VolumeInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::MIC1VolumeInfoDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Mic1KeyInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Mic1KeyInfoDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::MicCabinStatusDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::MicCabinStatusDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HomescreenGadgetInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HomescreenGadgetInfoDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ListScrollBarInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ListScrollBarInfoDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }
} // namespace FeatStd
#endif
COURIER_DATABINDING_INFRASTRUCTURE(::gInfrastructure);
