/************************************************************************
*FILE: AppHmi_MasterMessages.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(AppHmi_MasterMessages_h)
#define AppHmi_MasterMessages_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Courier/Messaging/Message.h>
#include <AppHmi_MasterTypes.h>
#include <ProjectBaseMsgs.h>
// ------------------------------------------------------------------------
class ContextSwitchFromHomeMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ContextSwitchFromHomeMsg, ::NotifierMessage, 0xF614EA49);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        ContextSwitchFromHomeMsg(Courier::Int32 const & aRegionId, Courier::Int32 const & aSourceAppId, Courier::Int32 const & aSourceActivityId, Courier::Int32 const & aTargetAppId, Courier::Int32 const & aTargetActivityId);
        virtual ~ContextSwitchFromHomeMsg();

        Courier::Int32 const & GetRegionId() const { return mRegionId; }
        void SetRegionId(Courier::Int32 const & value) { mRegionId = value; }
        Courier::Int32 const & GetSourceAppId() const { return mSourceAppId; }
        void SetSourceAppId(Courier::Int32 const & value) { mSourceAppId = value; }
        Courier::Int32 const & GetSourceActivityId() const { return mSourceActivityId; }
        void SetSourceActivityId(Courier::Int32 const & value) { mSourceActivityId = value; }
        Courier::Int32 const & GetTargetAppId() const { return mTargetAppId; }
        void SetTargetAppId(Courier::Int32 const & value) { mTargetAppId = value; }
        Courier::Int32 const & GetTargetActivityId() const { return mTargetActivityId; }
        void SetTargetActivityId(Courier::Int32 const & value) { mTargetActivityId = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ContextSwitchFromHomeMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mContextSwitchFromHomeMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mContextSwitchFromHomeMsgModifiableMetadata;
        static const ::Courier::ComponentId mContextSwitchFromHomeMsgSubscriberList[];

        Courier::Int32 mRegionId;
        Courier::Int32 mSourceAppId;
        Courier::Int32 mSourceActivityId;
        Courier::Int32 mTargetAppId;
        Courier::Int32 mTargetActivityId;
};

// ------------------------------------------------------------------------
class StoreContextSwitchFromHomeMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(StoreContextSwitchFromHomeMsg, ::NotifierMessage, 0x112DACFB);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        StoreContextSwitchFromHomeMsg(Courier::Int32 const & aRegionId, Courier::Int32 const & aTargetAppId, Courier::Int32 const & aTargetActivityId);
        virtual ~StoreContextSwitchFromHomeMsg();

        Courier::Int32 const & GetRegionId() const { return mRegionId; }
        void SetRegionId(Courier::Int32 const & value) { mRegionId = value; }
        Courier::Int32 const & GetTargetAppId() const { return mTargetAppId; }
        void SetTargetAppId(Courier::Int32 const & value) { mTargetAppId = value; }
        Courier::Int32 const & GetTargetActivityId() const { return mTargetActivityId; }
        void SetTargetActivityId(Courier::Int32 const & value) { mTargetActivityId = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(StoreContextSwitchFromHomeMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mStoreContextSwitchFromHomeMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mStoreContextSwitchFromHomeMsgModifiableMetadata;
        static const ::Courier::ComponentId mStoreContextSwitchFromHomeMsgSubscriberList[];

        Courier::Int32 mRegionId;
        Courier::Int32 mTargetAppId;
        Courier::Int32 mTargetActivityId;
};

// ------------------------------------------------------------------------
class ApplicationSwitchCompleteMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ApplicationSwitchCompleteMsg, ::NotifierMessage, 0x64E50DAE);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ApplicationSwitchCompleteMsg();
        virtual ~ApplicationSwitchCompleteMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mApplicationSwitchCompleteMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mApplicationSwitchCompleteMsgModifiableMetadata;
        static const ::Courier::ComponentId mApplicationSwitchCompleteMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class SwipeMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SwipeMsg, ::NotifierMessage, 0x03DDF00F);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        SwipeMsg();
        virtual ~SwipeMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSwipeMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mSwipeMsgModifiableMetadata;
        static const ::Courier::ComponentId mSwipeMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class ShowHideWaitSceneMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ShowHideWaitSceneMsg, ::NotifierMessage, 0x28E14D4C);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ShowHideWaitSceneMsg(bool const & aShowhide);
        virtual ~ShowHideWaitSceneMsg();

        bool const & GetShowhide() const { return mshowhide; }
        void SetShowhide(bool const & value) { mshowhide = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ShowHideWaitSceneMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mShowHideWaitSceneMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mShowHideWaitSceneMsgModifiableMetadata;
        static const ::Courier::ComponentId mShowHideWaitSceneMsgSubscriberList[];

        bool mshowhide;
};

// ------------------------------------------------------------------------
class ReqSpeechSessionMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ReqSpeechSessionMsg, ::NotifierMessage, 0xAAAECD83);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ReqSpeechSessionMsg();
        virtual ~ReqSpeechSessionMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mReqSpeechSessionMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mReqSpeechSessionMsgModifiableMetadata;
        static const ::Courier::ComponentId mReqSpeechSessionMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class ShowHideRVCSceneMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ShowHideRVCSceneMsg, ::NotifierMessage, 0x448B8AB8);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ShowHideRVCSceneMsg(bool const & aShowhide);
        virtual ~ShowHideRVCSceneMsg();

        bool const & GetShowhide() const { return mshowhide; }
        void SetShowhide(bool const & value) { mshowhide = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ShowHideRVCSceneMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mShowHideRVCSceneMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mShowHideRVCSceneMsgModifiableMetadata;
        static const ::Courier::ComponentId mShowHideRVCSceneMsgSubscriberList[];

        bool mshowhide;
};

// ------------------------------------------------------------------------
class ActivateRVCSceneMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ActivateRVCSceneMsg, ::NotifierMessage, 0x9EBDCEEC);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ActivateRVCSceneMsg(bool const & aShowhide);
        virtual ~ActivateRVCSceneMsg();

        bool const & GetShowhide() const { return mshowhide; }
        void SetShowhide(bool const & value) { mshowhide = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ActivateRVCSceneMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mActivateRVCSceneMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mActivateRVCSceneMsgModifiableMetadata;
        static const ::Courier::ComponentId mActivateRVCSceneMsgSubscriberList[];

        bool mshowhide;
};

// ------------------------------------------------------------------------
class SwitchApplicationMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SwitchApplicationMsg, ::NotifierMessage, 0x02BD8124);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        SwitchApplicationMsg(Courier::UInt32 const & aAppID);
        virtual ~SwitchApplicationMsg();

        Courier::UInt32 const & GetAppID() const { return mAppID; }
        void SetAppID(Courier::UInt32 const & value) { mAppID = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(SwitchApplicationMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSwitchApplicationMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mSwitchApplicationMsgModifiableMetadata;
        static const ::Courier::ComponentId mSwitchApplicationMsgSubscriberList[];

        Courier::UInt32 mAppID;
};

// ------------------------------------------------------------------------
class ActivateMasterApplicationReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ActivateMasterApplicationReqMsg, ::NotifierMessage, 0xBAE56CF8);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ActivateMasterApplicationReqMsg(Courier::UInt8 const & aDisplayStatus);
        virtual ~ActivateMasterApplicationReqMsg();

        Courier::UInt8 const & GetDisplayStatus() const { return mDisplayStatus; }
        void SetDisplayStatus(Courier::UInt8 const & value) { mDisplayStatus = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ActivateMasterApplicationReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mActivateMasterApplicationReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mActivateMasterApplicationReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mActivateMasterApplicationReqMsgSubscriberList[];

        Courier::UInt8 mDisplayStatus;
};

// ------------------------------------------------------------------------
class ActivateApplicationReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ActivateApplicationReqMsg, ::NotifierMessage, 0xFBB501C7);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ActivateApplicationReqMsg(Courier::Int32 const & aAppId, Courier::UInt32 const & aSurfaceId, Courier::UInt8 const & aDisplayStatus);
        virtual ~ActivateApplicationReqMsg();

        Courier::Int32 const & GetAppId() const { return mAppId; }
        void SetAppId(Courier::Int32 const & value) { mAppId = value; }
        Courier::UInt32 const & GetSurfaceId() const { return mSurfaceId; }
        void SetSurfaceId(Courier::UInt32 const & value) { mSurfaceId = value; }
        Courier::UInt8 const & GetDisplayStatus() const { return mDisplayStatus; }
        void SetDisplayStatus(Courier::UInt8 const & value) { mDisplayStatus = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ActivateApplicationReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mActivateApplicationReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mActivateApplicationReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mActivateApplicationReqMsgSubscriberList[];

        Courier::Int32 mAppId;
        Courier::UInt32 mSurfaceId;
        Courier::UInt8 mDisplayStatus;
};

// ------------------------------------------------------------------------
class FirstApplicationActivatedUpdMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(FirstApplicationActivatedUpdMsg, ::NotifierMessage, 0xEDDB9155);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        FirstApplicationActivatedUpdMsg();
        virtual ~FirstApplicationActivatedUpdMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mFirstApplicationActivatedUpdMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mFirstApplicationActivatedUpdMsgModifiableMetadata;
        static const ::Courier::ComponentId mFirstApplicationActivatedUpdMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class SetVolumeReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SetVolumeReqMsg, ::NotifierMessage, 0x3E240CA4);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        SetVolumeReqMsg(Courier::Int32 const & aValue, Courier::UInt32 const & aU32RegionID);
        virtual ~SetVolumeReqMsg();

        Courier::Int32 const & GetValue() const { return mValue; }
        void SetValue(Courier::Int32 const & value) { mValue = value; }
        Courier::UInt32 const & GetU32RegionID() const { return mU32RegionID; }
        void SetU32RegionID(Courier::UInt32 const & value) { mU32RegionID = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(SetVolumeReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSetVolumeReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mSetVolumeReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mSetVolumeReqMsgSubscriberList[];

        Courier::Int32 mValue;
        Courier::UInt32 mU32RegionID;
};

// ------------------------------------------------------------------------
class SetMicVolumeReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SetMicVolumeReqMsg, ::NotifierMessage, 0x010EF927);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        SetMicVolumeReqMsg(Courier::Int32 const & aValue);
        virtual ~SetMicVolumeReqMsg();

        Courier::Int32 const & GetValue() const { return mValue; }
        void SetValue(Courier::Int32 const & value) { mValue = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(SetMicVolumeReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSetMicVolumeReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mSetMicVolumeReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mSetMicVolumeReqMsgSubscriberList[];

        Courier::Int32 mValue;
};

// ------------------------------------------------------------------------
class SetCabinVolumeReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SetCabinVolumeReqMsg, ::NotifierMessage, 0xF0312EF2);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        SetCabinVolumeReqMsg(Courier::Int32 const & aValue);
        virtual ~SetCabinVolumeReqMsg();

        Courier::Int32 const & GetValue() const { return mValue; }
        void SetValue(Courier::Int32 const & value) { mValue = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(SetCabinVolumeReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSetCabinVolumeReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mSetCabinVolumeReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mSetCabinVolumeReqMsgSubscriberList[];

        Courier::Int32 mValue;
};

// ------------------------------------------------------------------------
class StartBeepReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(StartBeepReqMsg, ::NotifierMessage, 0xD7C389F0);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        StartBeepReqMsg(Courier::Int32 const & aBeepType);
        virtual ~StartBeepReqMsg();

        Courier::Int32 const & GetBeepType() const { return mBeepType; }
        void SetBeepType(Courier::Int32 const & value) { mBeepType = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(StartBeepReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mStartBeepReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mStartBeepReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mStartBeepReqMsgSubscriberList[];

        Courier::Int32 mBeepType;
};

// ------------------------------------------------------------------------
class ToggleMuteStateReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ToggleMuteStateReqMsg, ::NotifierMessage, 0x048CC818);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ToggleMuteStateReqMsg(Courier::UInt32 const & aU32RegionID);
        virtual ~ToggleMuteStateReqMsg();

        Courier::UInt32 const & GetU32RegionID() const { return mU32RegionID; }
        void SetU32RegionID(Courier::UInt32 const & value) { mU32RegionID = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ToggleMuteStateReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mToggleMuteStateReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mToggleMuteStateReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mToggleMuteStateReqMsgSubscriberList[];

        Courier::UInt32 mU32RegionID;
};

// ------------------------------------------------------------------------
class SwitchBacklightReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SwitchBacklightReqMsg, ::NotifierMessage, 0x9D77EA16);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        SwitchBacklightReqMsg(Courier::Int32 const & aState);
        virtual ~SwitchBacklightReqMsg();

        Courier::Int32 const & GetState() const { return mState; }
        void SetState(Courier::Int32 const & value) { mState = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(SwitchBacklightReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSwitchBacklightReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mSwitchBacklightReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mSwitchBacklightReqMsgSubscriberList[];

        Courier::Int32 mState;
};

// ------------------------------------------------------------------------
class EnableConnectionReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(EnableConnectionReqMsg, ::NotifierMessage, 0xE282C549);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        EnableConnectionReqMsg(AudioConnectionRequest::Enum const & aRequestId, Courier::Int32 const & aUserData1, Courier::Int32 const & aUserData2, Courier::Int32 const & aUserData3, Courier::Int32 const & aUserData4);
        virtual ~EnableConnectionReqMsg();

        AudioConnectionRequest::Enum const & GetRequestId() const { return mRequestId; }
        void SetRequestId(AudioConnectionRequest::Enum const & value) { mRequestId = value; }
        Courier::Int32 const & GetUserData1() const { return mUserData1; }
        void SetUserData1(Courier::Int32 const & value) { mUserData1 = value; }
        Courier::Int32 const & GetUserData2() const { return mUserData2; }
        void SetUserData2(Courier::Int32 const & value) { mUserData2 = value; }
        Courier::Int32 const & GetUserData3() const { return mUserData3; }
        void SetUserData3(Courier::Int32 const & value) { mUserData3 = value; }
        Courier::Int32 const & GetUserData4() const { return mUserData4; }
        void SetUserData4(Courier::Int32 const & value) { mUserData4 = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(EnableConnectionReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mEnableConnectionReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mEnableConnectionReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mEnableConnectionReqMsgSubscriberList[];

        AudioConnectionRequest::Enum mRequestId;
        Courier::Int32 mUserData1;
        Courier::Int32 mUserData2;
        Courier::Int32 mUserData3;
        Courier::Int32 mUserData4;
};

// ------------------------------------------------------------------------
class Audio_Active_SourceReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(Audio_Active_SourceReqMsg, ::NotifierMessage, 0xC776F39B);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        Audio_Active_SourceReqMsg(Courier::Int32 const & aActiveApp_Index);
        virtual ~Audio_Active_SourceReqMsg();

        Courier::Int32 const & GetActiveApp_Index() const { return mActiveApp_Index; }
        void SetActiveApp_Index(Courier::Int32 const & value) { mActiveApp_Index = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(Audio_Active_SourceReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mAudio_Active_SourceReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mAudio_Active_SourceReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mAudio_Active_SourceReqMsgSubscriberList[];

        Courier::Int32 mActiveApp_Index;
};

// ------------------------------------------------------------------------
class ReqWaitAnimationPopup : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ReqWaitAnimationPopup, ::NotifierMessage, 0x3C6C1C8E);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ReqWaitAnimationPopup();
        virtual ~ReqWaitAnimationPopup();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mReqWaitAnimationPopupMetaData;
        static ::Courier::Message::ModifiableMetadata mReqWaitAnimationPopupModifiableMetadata;
        static const ::Courier::ComponentId mReqWaitAnimationPopupSubscriberList[];
};

// ------------------------------------------------------------------------
class MmiStateStandByToggleReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(MmiStateStandByToggleReqMsg, ::NotifierMessage, 0x316EAFE2);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        MmiStateStandByToggleReqMsg(bool const & aStatus);
        virtual ~MmiStateStandByToggleReqMsg();

        bool const & GetStatus() const { return mStatus; }
        void SetStatus(bool const & value) { mStatus = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(MmiStateStandByToggleReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mMmiStateStandByToggleReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mMmiStateStandByToggleReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mMmiStateStandByToggleReqMsgSubscriberList[];

        bool mStatus;
};

// ------------------------------------------------------------------------
class MmiStateStatusReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(MmiStateStatusReqMsg, ::NotifierMessage, 0xEDAD3113);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        MmiStateStatusReqMsg();
        virtual ~MmiStateStatusReqMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mMmiStateStatusReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mMmiStateStatusReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mMmiStateStatusReqMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class MmiStateStatusUpdMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(MmiStateStatusUpdMsg, ::NotifierMessage, 0x05A9D564);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        MmiStateStatusUpdMsg(Courier::UInt32 const & aMmiState);
        virtual ~MmiStateStatusUpdMsg();

        Courier::UInt32 const & GetMmiState() const { return mMmiState; }
        void SetMmiState(Courier::UInt32 const & value) { mMmiState = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(MmiStateStatusUpdMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mMmiStateStatusUpdMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mMmiStateStatusUpdMsgModifiableMetadata;
        static const ::Courier::ComponentId mMmiStateStatusUpdMsgSubscriberList[];

        Courier::UInt32 mMmiState;
};

// ------------------------------------------------------------------------
class MapOutStatusUpdMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(MapOutStatusUpdMsg, ::NotifierMessage, 0x27DE5FE5);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        MapOutStatusUpdMsg(Courier::UInt32 const & aRegionId, bool const & aMapOutState);
        virtual ~MapOutStatusUpdMsg();

        Courier::UInt32 const & GetRegionId() const { return mRegionId; }
        void SetRegionId(Courier::UInt32 const & value) { mRegionId = value; }
        bool const & GetMapOutState() const { return mMapOutState; }
        void SetMapOutState(bool const & value) { mMapOutState = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(MapOutStatusUpdMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mMapOutStatusUpdMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mMapOutStatusUpdMsgModifiableMetadata;
        static const ::Courier::ComponentId mMapOutStatusUpdMsgSubscriberList[];

        Courier::UInt32 mRegionId;
        bool mMapOutState;
};

// ------------------------------------------------------------------------
class ToggleMapOutStatus : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ToggleMapOutStatus, ::NotifierMessage, 0xAECA61F1);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ToggleMapOutStatus(Courier::Int32 const & aRegionId);
        virtual ~ToggleMapOutStatus();

        Courier::Int32 const & GetRegionId() const { return mRegionId; }
        void SetRegionId(Courier::Int32 const & value) { mRegionId = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ToggleMapOutStatus);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mToggleMapOutStatusMetaData;
        static ::Courier::Message::ModifiableMetadata mToggleMapOutStatusModifiableMetadata;
        static const ::Courier::ComponentId mToggleMapOutStatusSubscriberList[];

        Courier::Int32 mRegionId;
};

// ------------------------------------------------------------------------
class Connect_DisconnectCameraToPluginMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(Connect_DisconnectCameraToPluginMsg, ::NotifierMessage, 0x5DF54E8D);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        Connect_DisconnectCameraToPluginMsg();
        virtual ~Connect_DisconnectCameraToPluginMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mConnect_DisconnectCameraToPluginMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mConnect_DisconnectCameraToPluginMsgModifiableMetadata;
        static const ::Courier::ComponentId mConnect_DisconnectCameraToPluginMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class ConnectAnalogCameraToPluginMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ConnectAnalogCameraToPluginMsg, ::NotifierMessage, 0xE447E38A);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ConnectAnalogCameraToPluginMsg(Courier::UInt32 const & aCameraId);
        virtual ~ConnectAnalogCameraToPluginMsg();

        Courier::UInt32 const & GetCameraId() const { return mCameraId; }
        void SetCameraId(Courier::UInt32 const & value) { mCameraId = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ConnectAnalogCameraToPluginMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mConnectAnalogCameraToPluginMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mConnectAnalogCameraToPluginMsgModifiableMetadata;
        static const ::Courier::ComponentId mConnectAnalogCameraToPluginMsgSubscriberList[];

        Courier::UInt32 mCameraId;
};

// ------------------------------------------------------------------------
class Connect_DisconnectAudioToPluginMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(Connect_DisconnectAudioToPluginMsg, ::NotifierMessage, 0xBD0AC02A);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        Connect_DisconnectAudioToPluginMsg();
        virtual ~Connect_DisconnectAudioToPluginMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mConnect_DisconnectAudioToPluginMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mConnect_DisconnectAudioToPluginMsgModifiableMetadata;
        static const ::Courier::ComponentId mConnect_DisconnectAudioToPluginMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class ChangeRegionMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ChangeRegionMsg, ::NotifierMessage, 0x79A1EC75);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ChangeRegionMsg(Courier::UInt32 const & aRegionId);
        virtual ~ChangeRegionMsg();

        Courier::UInt32 const & GetRegionId() const { return mRegionId; }
        void SetRegionId(Courier::UInt32 const & value) { mRegionId = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ChangeRegionMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mChangeRegionMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mChangeRegionMsgModifiableMetadata;
        static const ::Courier::ComponentId mChangeRegionMsgSubscriberList[];

        Courier::UInt32 mRegionId;
};

// ------------------------------------------------------------------------
class ChangeHomeStateMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ChangeHomeStateMsg, ::NotifierMessage, 0xFAC815CB);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ChangeHomeStateMsg(Courier::UInt32 const & aRegionId);
        virtual ~ChangeHomeStateMsg();

        Courier::UInt32 const & GetRegionId() const { return mRegionId; }
        void SetRegionId(Courier::UInt32 const & value) { mRegionId = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ChangeHomeStateMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mChangeHomeStateMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mChangeHomeStateMsgModifiableMetadata;
        static const ::Courier::ComponentId mChangeHomeStateMsgSubscriberList[];

        Courier::UInt32 mRegionId;
};

// ------------------------------------------------------------------------
class SubSurfaceVisibleMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SubSurfaceVisibleMsg, ::NotifierMessage, 0x698FB254);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        SubSurfaceVisibleMsg();
        SubSurfaceVisibleMsg(Candera::String const & aApplicationName, hmibase::displayRegion const & aDisplayRegion, Courier::UInt32 const & aDisplayID, Courier::UInt32 const & aStatus);
        virtual ~SubSurfaceVisibleMsg();

        Candera::String const & GetApplicationName() const { return mApplicationName; }
        void SetApplicationName(Candera::String const & value) { mApplicationName = value; }
        hmibase::displayRegion const & GetDisplayRegion() const { return mDisplayRegion; }
        void SetDisplayRegion(hmibase::displayRegion const & value) { mDisplayRegion = value; }
        Courier::UInt32 const & GetDisplayID() const { return mDisplayID; }
        void SetDisplayID(Courier::UInt32 const & value) { mDisplayID = value; }
        Courier::UInt32 const & GetStatus() const { return mStatus; }
        void SetStatus(Courier::UInt32 const & value) { mStatus = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSubSurfaceVisibleMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mSubSurfaceVisibleMsgModifiableMetadata;
        static const ::Courier::ComponentId mSubSurfaceVisibleMsgSubscriberList[];

        Candera::String mApplicationName;
        hmibase::displayRegion mDisplayRegion;
        Courier::UInt32 mDisplayID;
        Courier::UInt32 mStatus;
};

// ------------------------------------------------------------------------
class AppFlyInReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(AppFlyInReqMsg, ::NotifierMessage, 0x6BAA8440);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        AppFlyInReqMsg(bool const & aStatus);
        virtual ~AppFlyInReqMsg();

        bool const & GetStatus() const { return mstatus; }
        void SetStatus(bool const & value) { mstatus = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(AppFlyInReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mAppFlyInReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mAppFlyInReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mAppFlyInReqMsgSubscriberList[];

        bool mstatus;
};

// ------------------------------------------------------------------------
class FaciaON_OFF_Btn_ResetReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(FaciaON_OFF_Btn_ResetReqMsg, ::NotifierMessage, 0xCC779FB5);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        FaciaON_OFF_Btn_ResetReqMsg();
        virtual ~FaciaON_OFF_Btn_ResetReqMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mFaciaON_OFF_Btn_ResetReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mFaciaON_OFF_Btn_ResetReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mFaciaON_OFF_Btn_ResetReqMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class FaciaON_OFF_Btn_ShutDownReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(FaciaON_OFF_Btn_ShutDownReqMsg, ::NotifierMessage, 0x107DDA0F);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        FaciaON_OFF_Btn_ShutDownReqMsg();
        virtual ~FaciaON_OFF_Btn_ShutDownReqMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mFaciaON_OFF_Btn_ShutDownReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mFaciaON_OFF_Btn_ShutDownReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mFaciaON_OFF_Btn_ShutDownReqMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class ActivateMIC : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ActivateMIC, ::NotifierMessage, 0x63D4D1FB);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ActivateMIC();
        ActivateMIC(Courier::Int32 const & aValue, bool const & aStatus, Courier::UInt8 const & aKeyType);
        virtual ~ActivateMIC();

        Courier::Int32 const & GetValue() const { return mValue; }
        void SetValue(Courier::Int32 const & value) { mValue = value; }
        bool const & GetStatus() const { return mStatus; }
        void SetStatus(bool const & value) { mStatus = value; }
        Courier::UInt8 const & GetKeyType() const { return mKeyType; }
        void SetKeyType(Courier::UInt8 const & value) { mKeyType = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mActivateMICMetaData;
        static ::Courier::Message::ModifiableMetadata mActivateMICModifiableMetadata;
        static const ::Courier::ComponentId mActivateMICSubscriberList[];

        Courier::Int32 mValue;
        bool mStatus;
        Courier::UInt8 mKeyType;
};

// ------------------------------------------------------------------------
class MicStatus : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(MicStatus, ::NotifierMessage, 0x1069D09E);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        MicStatus();
        MicStatus(bool const & aStatus);
        virtual ~MicStatus();

        bool const & GetStatus() const { return mStatus; }
        void SetStatus(bool const & value) { mStatus = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mMicStatusMetaData;
        static ::Courier::Message::ModifiableMetadata mMicStatusModifiableMetadata;
        static const ::Courier::ComponentId mMicStatusSubscriberList[];

        bool mStatus;
};

// ------------------------------------------------------------------------
class HourLogicModeStateMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(HourLogicModeStateMsg, ::NotifierMessage, 0xE25C76A4);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        HourLogicModeStateMsg();
        HourLogicModeStateMsg(bool const & aStatus);
        virtual ~HourLogicModeStateMsg();

        bool const & GetStatus() const { return mStatus; }
        void SetStatus(bool const & value) { mStatus = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mHourLogicModeStateMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mHourLogicModeStateMsgModifiableMetadata;
        static const ::Courier::ComponentId mHourLogicModeStateMsgSubscriberList[];

        bool mStatus;
};

// ------------------------------------------------------------------------
class CheckAppFlyInVisibilityMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(CheckAppFlyInVisibilityMsg, ::NotifierMessage, 0xCC5C3320);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        CheckAppFlyInVisibilityMsg();
        CheckAppFlyInVisibilityMsg(Courier::Int32 const & aAppId);
        virtual ~CheckAppFlyInVisibilityMsg();

        Courier::Int32 const & GetAppId() const { return mAppId; }
        void SetAppId(Courier::Int32 const & value) { mAppId = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mCheckAppFlyInVisibilityMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mCheckAppFlyInVisibilityMsgModifiableMetadata;
        static const ::Courier::ComponentId mCheckAppFlyInVisibilityMsgSubscriberList[];

        Courier::Int32 mAppId;
};

// ------------------------------------------------------------------------
class Activate_Speech_Msg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(Activate_Speech_Msg, ::NotifierMessage, 0x2DFC9781);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        Activate_Speech_Msg();
        Activate_Speech_Msg(Courier::Int32 const & aValue);
        virtual ~Activate_Speech_Msg();

        Courier::Int32 const & GetValue() const { return mValue; }
        void SetValue(Courier::Int32 const & value) { mValue = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mActivate_Speech_MsgMetaData;
        static ::Courier::Message::ModifiableMetadata mActivate_Speech_MsgModifiableMetadata;
        static const ::Courier::ComponentId mActivate_Speech_MsgSubscriberList[];

        Courier::Int32 mValue;
};

// ------------------------------------------------------------------------
class ReqHMIReadVIN : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ReqHMIReadVIN, ::NotifierMessage, 0xDEE26FCB);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ReqHMIReadVIN();
        virtual ~ReqHMIReadVIN();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mReqHMIReadVINMetaData;
        static ::Courier::Message::ModifiableMetadata mReqHMIReadVINModifiableMetadata;
        static const ::Courier::ComponentId mReqHMIReadVINSubscriberList[];
};

// ------------------------------------------------------------------------
class UpdateVINStatus : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(UpdateVINStatus, ::NotifierMessage, 0x310C9CA9);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        UpdateVINStatus();
        virtual ~UpdateVINStatus();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mUpdateVINStatusMetaData;
        static ::Courier::Message::ModifiableMetadata mUpdateVINStatusModifiableMetadata;
        static const ::Courier::ComponentId mUpdateVINStatusSubscriberList[];
};

// ------------------------------------------------------------------------
class UpdateVINStatusToHMI : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(UpdateVINStatusToHMI, ::NotifierMessage, 0xBA2352FB);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        UpdateVINStatusToHMI();
        virtual ~UpdateVINStatusToHMI();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mUpdateVINStatusToHMIMetaData;
        static ::Courier::Message::ModifiableMetadata mUpdateVINStatusToHMIModifiableMetadata;
        static const ::Courier::ComponentId mUpdateVINStatusToHMISubscriberList[];
};

// ------------------------------------------------------------------------
class UpdateAntiTheftStatus : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(UpdateAntiTheftStatus, ::NotifierMessage, 0xDC701C20);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        UpdateAntiTheftStatus(Courier::UInt8 const & aAntiTheftStatus);
        virtual ~UpdateAntiTheftStatus();

        Courier::UInt8 const & GetAntiTheftStatus() const { return mAntiTheftStatus; }
        void SetAntiTheftStatus(Courier::UInt8 const & value) { mAntiTheftStatus = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(UpdateAntiTheftStatus);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mUpdateAntiTheftStatusMetaData;
        static ::Courier::Message::ModifiableMetadata mUpdateAntiTheftStatusModifiableMetadata;
        static const ::Courier::ComponentId mUpdateAntiTheftStatusSubscriberList[];

        Courier::UInt8 mAntiTheftStatus;
};

// ------------------------------------------------------------------------
class ReqHMIDisplayDisclaimerMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ReqHMIDisplayDisclaimerMsg, ::NotifierMessage, 0x6A45387A);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ReqHMIDisplayDisclaimerMsg();
        virtual ~ReqHMIDisplayDisclaimerMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mReqHMIDisplayDisclaimerMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mReqHMIDisplayDisclaimerMsgModifiableMetadata;
        static const ::Courier::ComponentId mReqHMIDisplayDisclaimerMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class ShowFirstHMIAppRequestMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ShowFirstHMIAppRequestMsg, ::NotifierMessage, 0xE8FA761A);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ShowFirstHMIAppRequestMsg();
        virtual ~ShowFirstHMIAppRequestMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mShowFirstHMIAppRequestMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mShowFirstHMIAppRequestMsgModifiableMetadata;
        static const ::Courier::ComponentId mShowFirstHMIAppRequestMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class ShowTempHMIAppRequestMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ShowTempHMIAppRequestMsg, ::NotifierMessage, 0xF631F05D);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ShowTempHMIAppRequestMsg();
        virtual ~ShowTempHMIAppRequestMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mShowTempHMIAppRequestMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mShowTempHMIAppRequestMsgModifiableMetadata;
        static const ::Courier::ComponentId mShowTempHMIAppRequestMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class UpdateSPM_HMI_ON : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(UpdateSPM_HMI_ON, ::NotifierMessage, 0xD1810A3B);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        UpdateSPM_HMI_ON();
        virtual ~UpdateSPM_HMI_ON();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mUpdateSPM_HMI_ONMetaData;
        static ::Courier::Message::ModifiableMetadata mUpdateSPM_HMI_ONModifiableMetadata;
        static const ::Courier::ComponentId mUpdateSPM_HMI_ONSubscriberList[];
};

// ------------------------------------------------------------------------
class StartDisclaimerTimerReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(StartDisclaimerTimerReqMsg, ::NotifierMessage, 0x93190E93);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        StartDisclaimerTimerReqMsg();
        virtual ~StartDisclaimerTimerReqMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mStartDisclaimerTimerReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mStartDisclaimerTimerReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mStartDisclaimerTimerReqMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class StopDisclaimerTimerReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(StopDisclaimerTimerReqMsg, ::NotifierMessage, 0x0FDF2CAC);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        StopDisclaimerTimerReqMsg();
        virtual ~StopDisclaimerTimerReqMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mStopDisclaimerTimerReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mStopDisclaimerTimerReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mStopDisclaimerTimerReqMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class ExpiredDisclaimerTimerMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ExpiredDisclaimerTimerMsg, ::NotifierMessage, 0xBE1CA755);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ExpiredDisclaimerTimerMsg();
        virtual ~ExpiredDisclaimerTimerMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mExpiredDisclaimerTimerMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mExpiredDisclaimerTimerMsgModifiableMetadata;
        static const ::Courier::ComponentId mExpiredDisclaimerTimerMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class CommonButtonVisibleStatusUpdMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(CommonButtonVisibleStatusUpdMsg, ::NotifierMessage, 0x12F87981);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        CommonButtonVisibleStatusUpdMsg(bool const & aVisibleStatus);
        virtual ~CommonButtonVisibleStatusUpdMsg();

        bool const & GetVisibleStatus() const { return mVisibleStatus; }
        void SetVisibleStatus(bool const & value) { mVisibleStatus = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(CommonButtonVisibleStatusUpdMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mCommonButtonVisibleStatusUpdMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mCommonButtonVisibleStatusUpdMsgModifiableMetadata;
        static const ::Courier::ComponentId mCommonButtonVisibleStatusUpdMsgSubscriberList[];

        bool mVisibleStatus;
};

// ------------------------------------------------------------------------
class EvalCommonButtonActivationRequestMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(EvalCommonButtonActivationRequestMsg, ::NotifierMessage, 0xDA213FAC);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        EvalCommonButtonActivationRequestMsg(bool const & aActiveStatus);
        virtual ~EvalCommonButtonActivationRequestMsg();

        bool const & GetActiveStatus() const { return mActiveStatus; }
        void SetActiveStatus(bool const & value) { mActiveStatus = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(EvalCommonButtonActivationRequestMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mEvalCommonButtonActivationRequestMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mEvalCommonButtonActivationRequestMsgModifiableMetadata;
        static const ::Courier::ComponentId mEvalCommonButtonActivationRequestMsgSubscriberList[];

        bool mActiveStatus;
};

// ------------------------------------------------------------------------
class ExecuteCommonButtonActivationRequestMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ExecuteCommonButtonActivationRequestMsg, ::NotifierMessage, 0x0741AABE);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ExecuteCommonButtonActivationRequestMsg(bool const & aActiveStatus);
        virtual ~ExecuteCommonButtonActivationRequestMsg();

        bool const & GetActiveStatus() const { return mActiveStatus; }
        void SetActiveStatus(bool const & value) { mActiveStatus = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ExecuteCommonButtonActivationRequestMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mExecuteCommonButtonActivationRequestMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mExecuteCommonButtonActivationRequestMsgModifiableMetadata;
        static const ::Courier::ComponentId mExecuteCommonButtonActivationRequestMsgSubscriberList[];

        bool mActiveStatus;
};

// ------------------------------------------------------------------------
class EncoderStatusUpdateMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(EncoderStatusUpdateMsg, ::NotifierMessage, 0x2D2F9977);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        EncoderStatusUpdateMsg(Courier::UInt32 const & aU32EncoderKey, Courier::Int32 const & aEncoderSteps);
        virtual ~EncoderStatusUpdateMsg();

        Courier::UInt32 const & GetU32EncoderKey() const { return mU32EncoderKey; }
        void SetU32EncoderKey(Courier::UInt32 const & value) { mU32EncoderKey = value; }
        Courier::Int32 const & GetEncoderSteps() const { return mEncoderSteps; }
        void SetEncoderSteps(Courier::Int32 const & value) { mEncoderSteps = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(EncoderStatusUpdateMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mEncoderStatusUpdateMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mEncoderStatusUpdateMsgModifiableMetadata;
        static const ::Courier::ComponentId mEncoderStatusUpdateMsgSubscriberList[];

        Courier::UInt32 mU32EncoderKey;
        Courier::Int32 mEncoderSteps;
};

// ------------------------------------------------------------------------
class HKStatusUpdateMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(HKStatusUpdateMsg, ::NotifierMessage, 0x670F9B63);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        HKStatusUpdateMsg(Courier::UInt32 const & aHkCode, Courier::UInt8 const & aHkState);
        virtual ~HKStatusUpdateMsg();

        Courier::UInt32 const & GetHkCode() const { return mHkCode; }
        void SetHkCode(Courier::UInt32 const & value) { mHkCode = value; }
        Courier::UInt8 const & GetHkState() const { return mHkState; }
        void SetHkState(Courier::UInt8 const & value) { mHkState = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(HKStatusUpdateMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mHKStatusUpdateMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mHKStatusUpdateMsgModifiableMetadata;
        static const ::Courier::ComponentId mHKStatusUpdateMsgSubscriberList[];

        Courier::UInt32 mHkCode;
        Courier::UInt8 mHkState;
};

// ------------------------------------------------------------------------
class ExpiredStartupTimerMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ExpiredStartupTimerMsg, ::NotifierMessage, 0x54FC9808);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ExpiredStartupTimerMsg();
        virtual ~ExpiredStartupTimerMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mExpiredStartupTimerMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mExpiredStartupTimerMsgModifiableMetadata;
        static const ::Courier::ComponentId mExpiredStartupTimerMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class SceneStatusInfoMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SceneStatusInfoMsg, ::NotifierMessage, 0x84A13011);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        SceneStatusInfoMsg(Courier::UInt32 const & aViewId, Courier::UInt32 const & aActiveStatus);
        virtual ~SceneStatusInfoMsg();

        Courier::UInt32 const & GetViewId() const { return mViewId; }
        void SetViewId(Courier::UInt32 const & value) { mViewId = value; }
        Courier::UInt32 const & GetActiveStatus() const { return mActiveStatus; }
        void SetActiveStatus(Courier::UInt32 const & value) { mActiveStatus = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(SceneStatusInfoMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSceneStatusInfoMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mSceneStatusInfoMsgModifiableMetadata;
        static const ::Courier::ComponentId mSceneStatusInfoMsgSubscriberList[];

        Courier::UInt32 mViewId;
        Courier::UInt32 mActiveStatus;
};

// ------------------------------------------------------------------------
class VolumePopupReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(VolumePopupReqMsg, ::NotifierMessage, 0xC203FD77);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        VolumePopupReqMsg(Courier::UInt32 const & aU32RegionID);
        virtual ~VolumePopupReqMsg();

        Courier::UInt32 const & GetU32RegionID() const { return mU32RegionID; }
        void SetU32RegionID(Courier::UInt32 const & value) { mU32RegionID = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(VolumePopupReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mVolumePopupReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mVolumePopupReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mVolumePopupReqMsgSubscriberList[];

        Courier::UInt32 mU32RegionID;
};

// ------------------------------------------------------------------------
class MixSourceIndexConnectionStatusReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(MixSourceIndexConnectionStatusReqMsg, ::NotifierMessage, 0x507ABE4B);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        MixSourceIndexConnectionStatusReqMsg(Courier::UInt8 const & aMixSourceIndex, bool const & aStatus);
        virtual ~MixSourceIndexConnectionStatusReqMsg();

        Courier::UInt8 const & GetMixSourceIndex() const { return mMixSourceIndex; }
        void SetMixSourceIndex(Courier::UInt8 const & value) { mMixSourceIndex = value; }
        bool const & GetStatus() const { return mStatus; }
        void SetStatus(bool const & value) { mStatus = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(MixSourceIndexConnectionStatusReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mMixSourceIndexConnectionStatusReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mMixSourceIndexConnectionStatusReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mMixSourceIndexConnectionStatusReqMsgSubscriberList[];

        Courier::UInt8 mMixSourceIndex;
        bool mStatus;
};

// ------------------------------------------------------------------------
class AppFlyInActivationReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(AppFlyInActivationReqMsg, ::NotifierMessage, 0x4C28CF17);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        AppFlyInActivationReqMsg(bool const & aActivationStatus);
        virtual ~AppFlyInActivationReqMsg();

        bool const & GetActivationStatus() const { return mActivationStatus; }
        void SetActivationStatus(bool const & value) { mActivationStatus = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(AppFlyInActivationReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mAppFlyInActivationReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mAppFlyInActivationReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mAppFlyInActivationReqMsgSubscriberList[];

        bool mActivationStatus;
};

// ------------------------------------------------------------------------
class ClonedHKStatusChangedUpdMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ClonedHKStatusChangedUpdMsg, ::NotifierMessage, 0xCC97BED5);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ClonedHKStatusChangedUpdMsg(Courier::UInt32 const & aHKCode, Courier::UInt8 const & aHKState, Courier::UInt32 const & aDisplayID, Courier::UInt32 const & aUserData);
        virtual ~ClonedHKStatusChangedUpdMsg();

        Courier::UInt32 const & GetHKCode() const { return mHKCode; }
        void SetHKCode(Courier::UInt32 const & value) { mHKCode = value; }
        Courier::UInt8 const & GetHKState() const { return mHKState; }
        void SetHKState(Courier::UInt8 const & value) { mHKState = value; }
        Courier::UInt32 const & GetDisplayID() const { return mDisplayID; }
        void SetDisplayID(Courier::UInt32 const & value) { mDisplayID = value; }
        Courier::UInt32 const & GetUserData() const { return mUserData; }
        void SetUserData(Courier::UInt32 const & value) { mUserData = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ClonedHKStatusChangedUpdMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mClonedHKStatusChangedUpdMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mClonedHKStatusChangedUpdMsgModifiableMetadata;
        static const ::Courier::ComponentId mClonedHKStatusChangedUpdMsgSubscriberList[];

        Courier::UInt32 mHKCode;
        Courier::UInt8 mHKState;
        Courier::UInt32 mDisplayID;
        Courier::UInt32 mUserData;
};

// ------------------------------------------------------------------------
class ClonedSurfaceStateChangedUpdMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ClonedSurfaceStateChangedUpdMsg, ::NotifierMessage, 0x3AE518D9);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ClonedSurfaceStateChangedUpdMsg(Courier::UInt32 const & aSurfaceID, Courier::UInt32 const & aSurfaceState);
        virtual ~ClonedSurfaceStateChangedUpdMsg();

        Courier::UInt32 const & GetSurfaceID() const { return mSurfaceID; }
        void SetSurfaceID(Courier::UInt32 const & value) { mSurfaceID = value; }
        Courier::UInt32 const & GetSurfaceState() const { return mSurfaceState; }
        void SetSurfaceState(Courier::UInt32 const & value) { mSurfaceState = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ClonedSurfaceStateChangedUpdMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mClonedSurfaceStateChangedUpdMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mClonedSurfaceStateChangedUpdMsgModifiableMetadata;
        static const ::Courier::ComponentId mClonedSurfaceStateChangedUpdMsgSubscriberList[];

        Courier::UInt32 mSurfaceID;
        Courier::UInt32 mSurfaceState;
};

// ------------------------------------------------------------------------
class SetSystemMuteReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SetSystemMuteReqMsg, ::NotifierMessage, 0x67B81892);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        SetSystemMuteReqMsg(Courier::UInt32 const & aRegionId, bool const & aMuteStatus);
        virtual ~SetSystemMuteReqMsg();

        Courier::UInt32 const & GetRegionId() const { return mRegionId; }
        void SetRegionId(Courier::UInt32 const & value) { mRegionId = value; }
        bool const & GetMuteStatus() const { return mMuteStatus; }
        void SetMuteStatus(bool const & value) { mMuteStatus = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(SetSystemMuteReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSetSystemMuteReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mSetSystemMuteReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mSetSystemMuteReqMsgSubscriberList[];

        Courier::UInt32 mRegionId;
        bool mMuteStatus;
};

// ------------------------------------------------------------------------
class SetHmiStartupMuteRequest : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SetHmiStartupMuteRequest, ::NotifierMessage, 0xFA0E39B2);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        SetHmiStartupMuteRequest(bool const & aMuteStatus);
        virtual ~SetHmiStartupMuteRequest();

        bool const & GetMuteStatus() const { return mMuteStatus; }
        void SetMuteStatus(bool const & value) { mMuteStatus = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(SetHmiStartupMuteRequest);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSetHmiStartupMuteRequestMetaData;
        static ::Courier::Message::ModifiableMetadata mSetHmiStartupMuteRequestModifiableMetadata;
        static const ::Courier::ComponentId mSetHmiStartupMuteRequestSubscriberList[];

        bool mMuteStatus;
};

// ------------------------------------------------------------------------
class ControlPanelButtonPressUpdate : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ControlPanelButtonPressUpdate, ::NotifierMessage, 0x7602DD61);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ControlPanelButtonPressUpdate(Courier::UInt8 const & aControlPanelButton, Courier::UInt8 const & aButtonstate, Courier::UInt32 const & aReceiverAppID);
        virtual ~ControlPanelButtonPressUpdate();

        Courier::UInt8 const & GetControlPanelButton() const { return mControlPanelButton; }
        void SetControlPanelButton(Courier::UInt8 const & value) { mControlPanelButton = value; }
        Courier::UInt8 const & GetButtonstate() const { return mButtonstate; }
        void SetButtonstate(Courier::UInt8 const & value) { mButtonstate = value; }
        Courier::UInt32 const & GetReceiverAppID() const { return mReceiverAppID; }
        void SetReceiverAppID(Courier::UInt32 const & value) { mReceiverAppID = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ControlPanelButtonPressUpdate);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mControlPanelButtonPressUpdateMetaData;
        static ::Courier::Message::ModifiableMetadata mControlPanelButtonPressUpdateModifiableMetadata;
        static const ::Courier::ComponentId mControlPanelButtonPressUpdateSubscriberList[];

        Courier::UInt8 mControlPanelButton;
        Courier::UInt8 mButtonstate;
        Courier::UInt32 mReceiverAppID;
};

// ------------------------------------------------------------------------
class EmergencyShutDownReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(EmergencyShutDownReqMsg, ::NotifierMessage, 0xFFCFF147);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        EmergencyShutDownReqMsg(bool const & aShowhide);
        virtual ~EmergencyShutDownReqMsg();

        bool const & GetShowhide() const { return mshowhide; }
        void SetShowhide(bool const & value) { mshowhide = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(EmergencyShutDownReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mEmergencyShutDownReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mEmergencyShutDownReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mEmergencyShutDownReqMsgSubscriberList[];

        bool mshowhide;
};

// ------------------------------------------------------------------------
class KDSStatusUpdMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(KDSStatusUpdMsg, ::NotifierMessage, 0x358837AD);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        KDSStatusUpdMsg(Courier::UInt8 const & aStatus);
        virtual ~KDSStatusUpdMsg();

        Courier::UInt8 const & GetStatus() const { return mStatus; }
        void SetStatus(Courier::UInt8 const & value) { mStatus = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(KDSStatusUpdMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mKDSStatusUpdMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mKDSStatusUpdMsgModifiableMetadata;
        static const ::Courier::ComponentId mKDSStatusUpdMsgSubscriberList[];

        Courier::UInt8 mStatus;
};

// ------------------------------------------------------------------------
class HandleSettingsMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(HandleSettingsMsg, ::NotifierMessage, 0xFB26AD99);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        HandleSettingsMsg(Courier::UInt32 const & aRegionId);
        virtual ~HandleSettingsMsg();

        Courier::UInt32 const & GetRegionId() const { return mRegionId; }
        void SetRegionId(Courier::UInt32 const & value) { mRegionId = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(HandleSettingsMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mHandleSettingsMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mHandleSettingsMsgModifiableMetadata;
        static const ::Courier::ComponentId mHandleSettingsMsgSubscriberList[];

        Courier::UInt32 mRegionId;
};

// ------------------------------------------------------------------------
class DumpContextSwitchStackInfo : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(DumpContextSwitchStackInfo, ::NotifierMessage, 0x8DA29817);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        DumpContextSwitchStackInfo();
        virtual ~DumpContextSwitchStackInfo();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mDumpContextSwitchStackInfoMetaData;
        static ::Courier::Message::ModifiableMetadata mDumpContextSwitchStackInfoModifiableMetadata;
        static const ::Courier::ComponentId mDumpContextSwitchStackInfoSubscriberList[];
};

// ------------------------------------------------------------------------
class ClearLastApplication : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ClearLastApplication, ::NotifierMessage, 0x1964E334);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ClearLastApplication();
        virtual ~ClearLastApplication();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mClearLastApplicationMetaData;
        static ::Courier::Message::ModifiableMetadata mClearLastApplicationModifiableMetadata;
        static const ::Courier::ComponentId mClearLastApplicationSubscriberList[];
};

// ------------------------------------------------------------------------
class DumpSystemsInfo : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(DumpSystemsInfo, ::NotifierMessage, 0x4127C292);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        DumpSystemsInfo();
        virtual ~DumpSystemsInfo();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mDumpSystemsInfoMetaData;
        static ::Courier::Message::ModifiableMetadata mDumpSystemsInfoModifiableMetadata;
        static const ::Courier::ComponentId mDumpSystemsInfoSubscriberList[];
};

// ------------------------------------------------------------------------
class updateHMIStateChange : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(updateHMIStateChange, ::NotifierMessage, 0xF2C61F33);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        updateHMIStateChange(enHmiState const & aHmiState);
        virtual ~updateHMIStateChange();

        enHmiState const & GetHmiState() const { return mHmiState; }
        void SetHmiState(enHmiState const & value) { mHmiState = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(updateHMIStateChange);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mupdateHMIStateChangeMetaData;
        static ::Courier::Message::ModifiableMetadata mupdateHMIStateChangeModifiableMetadata;
        static const ::Courier::ComponentId mupdateHMIStateChangeSubscriberList[];

        enHmiState mHmiState;
};

// ------------------------------------------------------------------------
class SimHmiStateChange : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SimHmiStateChange, ::NotifierMessage, 0x203FAD35);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        SimHmiStateChange(Courier::UInt8 const & aHmiState);
        virtual ~SimHmiStateChange();

        Courier::UInt8 const & GetHmiState() const { return mHmiState; }
        void SetHmiState(Courier::UInt8 const & value) { mHmiState = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(SimHmiStateChange);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSimHmiStateChangeMetaData;
        static ::Courier::Message::ModifiableMetadata mSimHmiStateChangeModifiableMetadata;
        static const ::Courier::ComponentId mSimHmiStateChangeSubscriberList[];

        Courier::UInt8 mHmiState;
};

// ------------------------------------------------------------------------
class SystemFailureUpdate : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SystemFailureUpdate, ::NotifierMessage, 0xC501DA0F);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        SystemFailureUpdate(enRegionID const & aRegionId, enSystemCategory const & aSystemCategory, enStatusCategory const & aStatusCategory, Courier::UInt8 const & aSystemStatus, Courier::UInt8 const & aGroupCategory);
        virtual ~SystemFailureUpdate();

        enRegionID const & GetRegionId() const { return mRegionId; }
        void SetRegionId(enRegionID const & value) { mRegionId = value; }
        enSystemCategory const & GetSystemCategory() const { return mSystemCategory; }
        void SetSystemCategory(enSystemCategory const & value) { mSystemCategory = value; }
        enStatusCategory const & GetStatusCategory() const { return mStatusCategory; }
        void SetStatusCategory(enStatusCategory const & value) { mStatusCategory = value; }
        Courier::UInt8 const & GetSystemStatus() const { return mSystemStatus; }
        void SetSystemStatus(Courier::UInt8 const & value) { mSystemStatus = value; }
        Courier::UInt8 const & GetGroupCategory() const { return mGroupCategory; }
        void SetGroupCategory(Courier::UInt8 const & value) { mGroupCategory = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(SystemFailureUpdate);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSystemFailureUpdateMetaData;
        static ::Courier::Message::ModifiableMetadata mSystemFailureUpdateModifiableMetadata;
        static const ::Courier::ComponentId mSystemFailureUpdateSubscriberList[];

        enRegionID mRegionId;
        enSystemCategory mSystemCategory;
        enStatusCategory mStatusCategory;
        Courier::UInt8 mSystemStatus;
        Courier::UInt8 mGroupCategory;
};

// ------------------------------------------------------------------------
class SimSubSystemErrorStatus : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SimSubSystemErrorStatus, ::NotifierMessage, 0xD3C5794C);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        SimSubSystemErrorStatus(Courier::UInt8 const & aCategory, Courier::UInt8 const & aSystemId, Courier::UInt16 const & aErrorInfo);
        virtual ~SimSubSystemErrorStatus();

        Courier::UInt8 const & GetCategory() const { return mCategory; }
        void SetCategory(Courier::UInt8 const & value) { mCategory = value; }
        Courier::UInt8 const & GetSystemId() const { return mSystemId; }
        void SetSystemId(Courier::UInt8 const & value) { mSystemId = value; }
        Courier::UInt16 const & GetErrorInfo() const { return mErrorInfo; }
        void SetErrorInfo(Courier::UInt16 const & value) { mErrorInfo = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(SimSubSystemErrorStatus);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSimSubSystemErrorStatusMetaData;
        static ::Courier::Message::ModifiableMetadata mSimSubSystemErrorStatusModifiableMetadata;
        static const ::Courier::ComponentId mSimSubSystemErrorStatusSubscriberList[];

        Courier::UInt8 mCategory;
        Courier::UInt8 mSystemId;
        Courier::UInt16 mErrorInfo;
};

// ------------------------------------------------------------------------
class SimVideoMixIndexInfo : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SimVideoMixIndexInfo, ::NotifierMessage, 0x6704BF14);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        SimVideoMixIndexInfo(Courier::UInt32 const & aRegionId, Courier::UInt8 const & aVideoMixIndex, Courier::UInt8 const & aReason);
        virtual ~SimVideoMixIndexInfo();

        Courier::UInt32 const & GetRegionId() const { return mRegionId; }
        void SetRegionId(Courier::UInt32 const & value) { mRegionId = value; }
        Courier::UInt8 const & GetVideoMixIndex() const { return mVideoMixIndex; }
        void SetVideoMixIndex(Courier::UInt8 const & value) { mVideoMixIndex = value; }
        Courier::UInt8 const & GetReason() const { return mReason; }
        void SetReason(Courier::UInt8 const & value) { mReason = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(SimVideoMixIndexInfo);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSimVideoMixIndexInfoMetaData;
        static ::Courier::Message::ModifiableMetadata mSimVideoMixIndexInfoModifiableMetadata;
        static const ::Courier::ComponentId mSimVideoMixIndexInfoSubscriberList[];

        Courier::UInt32 mRegionId;
        Courier::UInt8 mVideoMixIndex;
        Courier::UInt8 mReason;
};

// ------------------------------------------------------------------------
class EvalContextSwitchRequestMsg : public ::ContextSwitchFromHomeMsg
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(EvalContextSwitchRequestMsg, ::ContextSwitchFromHomeMsg, 0xA1A3B247);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        EvalContextSwitchRequestMsg(Courier::Int32 const & aRegionId, Courier::Int32 const & aSourceAppId, Courier::Int32 const & aSourceActivityId, Courier::Int32 const & aTargetAppId, Courier::Int32 const & aTargetActivityId);
        virtual ~EvalContextSwitchRequestMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(EvalContextSwitchRequestMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mEvalContextSwitchRequestMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mEvalContextSwitchRequestMsgModifiableMetadata;
        static const ::Courier::ComponentId mEvalContextSwitchRequestMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class ExecuteContextSwitchRequestMsg : public ::ContextSwitchFromHomeMsg
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ExecuteContextSwitchRequestMsg, ::ContextSwitchFromHomeMsg, 0x40D87D57);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ExecuteContextSwitchRequestMsg(Courier::Int32 const & aRegionId, Courier::Int32 const & aSourceAppId, Courier::Int32 const & aSourceActivityId, Courier::Int32 const & aTargetAppId, Courier::Int32 const & aTargetActivityId, Courier::UInt32 const & aExecuteCode);
        virtual ~ExecuteContextSwitchRequestMsg();

        Courier::UInt32 const & GetExecuteCode() const { return mExecuteCode; }
        void SetExecuteCode(Courier::UInt32 const & value) { mExecuteCode = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ExecuteContextSwitchRequestMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mExecuteContextSwitchRequestMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mExecuteContextSwitchRequestMsgModifiableMetadata;
        static const ::Courier::ComponentId mExecuteContextSwitchRequestMsgSubscriberList[];

        Courier::UInt32 mExecuteCode;
};

// ------------------------------------------------------------------------
          /**
           * - Usage                     : This message is used to indicate the Model for respective list update
           * - Component                 : DataModelHome
           * - Sender                    : Model
           * - Variant                   : All
           */
class DataModelHomeListUpdateReqMsg : public ::ListDateProviderReqMsg
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(DataModelHomeListUpdateReqMsg, ::ListDateProviderReqMsg, 0x8EBD220E);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        DataModelHomeListUpdateReqMsg(::Courier::UInt32 const & aListId, ::Courier::Int32 const & aStartIndex, ::Courier::UInt32 const & aWindowElementSize, bool const & aCircular, bool const & aCachedData);
        virtual ~DataModelHomeListUpdateReqMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(DataModelHomeListUpdateReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mDataModelHomeListUpdateReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mDataModelHomeListUpdateReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mDataModelHomeListUpdateReqMsgSubscriberList[];
};

#endif // AppHmi_MasterMessages_h
