/************************************************************************
*FILE: AppHmi_MasterDatabinding.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(AppHmi_MasterDatabinding_h)
#define AppHmi_MasterDatabinding_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <AppHmi_MasterConstants.h>
#include <CanderaWidget/String/String.h>
#include <Candera/Engine2D/Core/Image2D.h>

// =========================================================================
struct VolumeInfoData {
    int mVolumeValue;
    Candera::String mVolumeValueString;
    int mCabinAVolumeValue;
    Candera::String mCabinAVolumeValueString;
    int mVolumeSrc;
    bool mVolumeBarRed;
    bool mVolumeBarGreen;
    bool mCabinAControlPanel_Icon_Status;

    VolumeInfoData();
};

// =========================================================================
struct VolumeBarInfoData {
    int mVolume_CurrentVal;
    int mVolume_TotalVal;
    int mVolume_NoOfSteps;
    int mVolume_MaxValue;
    int mVolume_MinValue;
    int mVolume_StepSize;

    VolumeBarInfoData();
};

// =========================================================================
struct AppFlyInListInfoData {
    bool mAppFlyInEnability;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mAppFlyInImageBg;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mAppFlyInImageIcon;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mAppFlyInImageBorder;

    AppFlyInListInfoData();
};

// =========================================================================
struct SystemMuteInfoData {
    int mMute_UnMuteVal_Cockpit;
    int mMute_UnMuteVal_CabinA;
    int mMute_UnMuteVal_CabinB;

    SystemMuteInfoData();
};

// =========================================================================
struct MmiModeData {
    Candera::UInt32 mMode;

    MmiModeData();
};

// =========================================================================
struct KDSStatusInfoData {
    Candera::UInt8 mKDSStatus;

    KDSStatusInfoData();
};

// =========================================================================
struct StartupMsgInfoData {
    bool mPopupInitialVisibility;
    bool mPopupreadyVisibility;

    StartupMsgInfoData();
};

// =========================================================================
struct ControlPanelInfoData {
    int mContext;
    bool mSpeechIconEnable;
    bool mMicIconEnableStatus;

    ControlPanelInfoData();
};

// =========================================================================
struct CockpitCabinContextData {
    Candera::String mCameraStreamStatus_CabinA;
    Candera::String mCameraStreamStatus_CabinB;

    CockpitCabinContextData();
};

// =========================================================================
struct WidgetControllersData {
    Candera::Int32 mswipegesture_id;
    bool mPagination_visibility;
    bool mSwipe_enable_dis;
    bool mScroll_enable_dis;
    bool mBG_scro_enable_dis;

    WidgetControllersData();
};

// =========================================================================
struct SourceListItemInfoData {
    Candera::String mItemText;
    bool mItemIsActive;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mItemNormalBitmap;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mItemActiveBitmap;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mItemPressedBitmap;

    SourceListItemInfoData();
};

// =========================================================================
struct MIC1VolumeInfoData {
    bool mMic1MuteStatus;
    int mMic1ProgressBarVolumeValue;
    Candera::String mMic1VolumeValue;

    MIC1VolumeInfoData();
};

// =========================================================================
struct Mic1KeyInfoData {
    bool mMic1TouchabilityStatus;

    Mic1KeyInfoData();
};

// =========================================================================
struct MicCabinStatusData {
    int mCabinMicSourceIndex;

    MicCabinStatusData();
};

// =========================================================================
struct HomescreenGadgetInfoData {
    Candera::UInt32 mGadgetInstanceId;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mGadgetBg;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mGadgetIconAreaBgNormal;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mGadgetIconAreaBgPressed;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mGadgetIcon;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mGadgetTouchAreaBgNormal;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mGadgetTouchAreaBgPressed;
    Candera::String mGadgetTouchAreaText;
    Candera::Color mGadgetTouchAreaTextColour;
    Candera::Margin mGadgetMargin;
    Candera::Vector2 mGadgetSize;
    bool mGadgetContentAvailable;
    bool mGadgetAnimationStatus;
    bool mGadgetFunctionAvailable;
    Candera::String mGadgetMapOutText;
    bool mGadgetVideoMixIconEnableStatus;
    bool mGadgetVideoMixIconVisibility;
    Candera::String mGadgetVideoMixText;
    Candera::MemoryManagement::SharedPointer<Candera::Image2D> mGadgetNATransparentBg;
    Candera::Margin mGadgetNAAnimationPosition;
    Candera::Margin mGadgetNATextPosition;

    HomescreenGadgetInfoData();
};
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
namespace FeatStd {
template<> ::FeatStd::UInt32 StringBufferAppender< ::VolumeInfoData >::Append(::FeatStd::StringBuffer& stringBuffer, ::VolumeInfoData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::VolumeBarInfoData >::Append(::FeatStd::StringBuffer& stringBuffer, ::VolumeBarInfoData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::AppFlyInListInfoData >::Append(::FeatStd::StringBuffer& stringBuffer, ::AppFlyInListInfoData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::SystemMuteInfoData >::Append(::FeatStd::StringBuffer& stringBuffer, ::SystemMuteInfoData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::MmiModeData >::Append(::FeatStd::StringBuffer& stringBuffer, ::MmiModeData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::KDSStatusInfoData >::Append(::FeatStd::StringBuffer& stringBuffer, ::KDSStatusInfoData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::StartupMsgInfoData >::Append(::FeatStd::StringBuffer& stringBuffer, ::StartupMsgInfoData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::ControlPanelInfoData >::Append(::FeatStd::StringBuffer& stringBuffer, ::ControlPanelInfoData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::CockpitCabinContextData >::Append(::FeatStd::StringBuffer& stringBuffer, ::CockpitCabinContextData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::WidgetControllersData >::Append(::FeatStd::StringBuffer& stringBuffer, ::WidgetControllersData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::SourceListItemInfoData >::Append(::FeatStd::StringBuffer& stringBuffer, ::SourceListItemInfoData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::MIC1VolumeInfoData >::Append(::FeatStd::StringBuffer& stringBuffer, ::MIC1VolumeInfoData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::Mic1KeyInfoData >::Append(::FeatStd::StringBuffer& stringBuffer, ::Mic1KeyInfoData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::MicCabinStatusData >::Append(::FeatStd::StringBuffer& stringBuffer, ::MicCabinStatusData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::HomescreenGadgetInfoData >::Append(::FeatStd::StringBuffer& stringBuffer, ::HomescreenGadgetInfoData const & object);
} // namespace FeatStd
#endif
#endif // AppHmi_MasterDatabinding_h
