/************************************************************************
*FILE: AppHmi_CameraStateMachine.cpp 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#include "AppHmi_CameraStateMachine.h"
#include <FeatStd/Util/StaticObject.h>
#include <Cit/VisualStateGlueLayer/VisualStateGlueLayer.h>
#include <Courier/Util/Util.h>
using namespace ::hmibase;
using namespace ::hmi;

//====  defines and includes TTFis output - added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
#include "hmi_trace_if.h"
#include "View/CGI/CourierMsgTracing/CourierMessageMapTrace.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_SM
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/AppHmi_CameraStateMachine.cpp.trc.h"
#endif                            
//====  defines and includes TTFis output - end                        key: SM_TTFis_SBHFMSRF ====

// ------------------------------------------------------------------------

// ------------------------------------------------------------------------
bool SendSwitchApplicationReq(enApplicationId const & aApplicationID, enSurfaceId const & aSurfaceID)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SwitchApplicationReq)(aApplicationID, aSurfaceID);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendCameraBackButtonMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::CameraBackButtonMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendCabinSourceMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::CabinSourceMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendButtonMainSrcActivate(Courier::Int8 const & aSrcmode)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ButtonMainSrcActivate)(aSrcmode);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendButtonMainSrcCabinActivate(Courier::Int8 const & aSrcmode)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ButtonMainSrcCabinActivate)(aSrcmode);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendNextCameraActivate()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::NextCameraActivate)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPreviousCameraActivate()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::PreviousCameraActivate)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendButtonMixedSourceMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ButtonMixedSourceMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendCameraToggleButton()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::CameraToggleButton)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendCameraExitMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::CameraExitMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendCameraBlackScreenStartTimerMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::CameraBlackScreenStartTimerMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendCameraStreamStopMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::CameraStreamStopMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendCameraStreamStartMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::CameraStreamStartMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendCameraSplitStreamStartMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::CameraSplitStreamStartMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendCabinCameraExitMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::CabinCameraExitMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSplitViewLeftCamMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SplitViewLeftCamMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSplitViewRightCamMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SplitViewRightCamMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendContextToMaster(Courier::UInt16 const & aContextScene)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ContextToMaster)(aContextScene);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendGuiStartupFinishedUpdMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::GuiStartupFinishedUpdMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendChangeLanguageReqMsg(enLanguageId const & aLanguageId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ChangeLanguageReqMsg)(aLanguageId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendFocusReqMsg(FocusActionEnum const & aAction, FocusTimerActionEnum const & aTimerAction, ::Courier::ViewId const & aView, Candera::String const & aWidget)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::FocusReqMsg)(aAction, aTimerAction, aView, aWidget);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendDummyMess(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::DummyMess)(aFirstView, aSecondView, aPos);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendAnimationReqMsg(Courier::AnimationAction::Enum const & aAnimationAction, ::Courier::ViewId const & aViewId, Courier::CompositePath const & aCompositePath, ::Courier::ItemId const & aAnimationId, Courier::AnimationProperties const & aAnimationProperties)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::Courier::AnimationReqMsg)(aAnimationAction, aViewId, aCompositePath, aAnimationId, aAnimationProperties);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendFocusOnRightEncoderReqUpdMsg(bool const & aIsFocusUsed)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::FocusOnRightEncoderReqUpdMsg)(aIsFocusUsed);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendStoreActiveGadgetReqMsg(bool const & aIsGadgetAtive)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::StoreActiveGadgetReqMsg)(aIsGadgetAtive);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendHardKeyPressNotificationMsg(Courier::UInt8 const & aDummy, Courier::UInt8 const & aHKCode, Courier::UInt8 const & aHKState)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::HardKeyPressNotificationMsg)(aDummy, aHKCode, aHKState);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendDropdownChangeMsg(::Candera::DropdownChangeType const & aDropdownChangeType, ::Courier::UInt32 const & aListId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::DropdownChangeMsg)(aDropdownChangeType, aListId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendStartPopupTimerReqMsg(Courier::UInt32 const & aViewId, Courier::UInt32 const & aTimeout)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::StartPopupTimerReqMsg)(aViewId, aTimeout);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendStopPopupTimerReqMsg(Courier::UInt32 const & aViewId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::StopPopupTimerReqMsg)(aViewId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPlayBeepReqMsg(Courier::Int32 const & aBeepType)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::PlayBeepReqMsg)(aBeepType);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendCheckToClosePopupMsg(Courier::UInt32 const & aPopupId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::CheckToClosePopupMsg)(aPopupId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendRestartPopupTimerReqMsg(Courier::UInt32 const & aViewId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::RestartPopupTimerReqMsg)(aViewId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendContextSwitchInResMsg(Courier::UInt32 const & aSwitchId, Courier::UInt32 const & aResponseType)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ContextSwitchInResMsg)(aSwitchId, aResponseType);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendContextSwitchOutReqMsg(Courier::UInt32 const & aTargetContextId, Courier::UInt32 const & aSourceContextId, Courier::UInt32 const & aTargetAppId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ContextSwitchOutReqMsg)(aTargetContextId, aSourceContextId, aTargetAppId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendCurrentScreenDisplayReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::CurrentScreenDisplayReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendLaunchBarDisplayReqMsg(bool const & aVisibility)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::LaunchBarDisplayReqMsg)(aVisibility);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendNavTBTSwipeReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::NavTBTSwipeReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendListItemRightEncoderChangeUpdMsg(Courier::Int8 const & aSteps, Courier::UInt32 const & aListId, Courier::UInt32 const & aRowId, Courier::UInt32 const & aColumnId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ListItemRightEncoderChangeUpdMsg)(aSteps, aListId, aRowId, aColumnId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendListChangeMsg(::Courier::UInt32 const & aListId, ListChangeType const & aListChangeType, ::Courier::Int32 const & aValue, ListChangeMsgSourceType const & aListChangeMsgSource, bool const & aImmediatePositioning)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ListChangeMsg)(aListId, aListChangeType, aValue, aListChangeMsgSource, aImmediatePositioning);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendListFocusScrollReqMsg(Courier::UInt32 const & aListId, Courier::Int32 const & aSteps)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ListFocusScrollReqMsg)(aListId, aSteps);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendListFocusLockDataResetReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ListFocusLockDataResetReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSetApplicationModeReqMsg(Courier::UInt32 const & aModeId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SetApplicationModeReqMsg)(aModeId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSpellerBbehaviorReqMsg(bool const & aEnable)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SpellerBbehaviorReqMsg)(aEnable);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendStatusBarDisplayReqMsg(bool const & aVisibility, Courier::Int32 const & aHeaderType)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::StatusBarDisplayReqMsg)(aVisibility, aHeaderType);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendTBTRetriggerAcousticMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::TBTRetriggerAcousticMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendViewReqMsg(Courier::ViewAction::Enum const & aViewAction, ::Courier::ViewId const & aViewId, bool const & aShallInitScene, bool const & aShallLoadScene)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::Courier::ViewReqMsg)(aViewAction, aViewId, aShallInitScene, aShallLoadScene);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendActivationReqMsg(::Courier::ViewId const & aViewId, bool const & aActivation, bool const & aEnableRendering)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::Courier::ActivationReqMsg)(aViewId, aActivation, aEnableRendering);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendAsyncLoadReqMsg(::Courier::ViewId const & aViewId, bool const & aLoad)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::Courier::AsyncLoadReqMsg)(aViewId, aLoad);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPopupReqMsg(hmibase::popups::CommandEnum const & aCommand, ::Courier::ViewId const & aViewId, Courier::UInt32 const & aPopupDisplayID)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::PopupReqMsg)(aCommand, aViewId, aPopupDisplayID);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendExtendedViewReqMsg(hmibase::views::CommandEnum const & aCommand, ::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ExtendedViewReqMsg)(aCommand, aViewId, aHint);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendShowHMISubSurfaceReqMsg(hmibase::displayRegion const & aDisplayRegion, Courier::Int32 const & aDisplayRegionType, bool const & aShowSubSurface, Courier::UInt32 const & aDisplayID, bool const & aLockSubSurface)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ShowHMISubSurfaceReqMsg)(aDisplayRegion, aDisplayRegionType, aShowSubSurface, aDisplayID, aLockSubSurface);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendRegisterForCloseOnTouchSessionReqMsg(bool const & aRegister, ::Courier::ViewId const & aViewId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::RegisterForCloseOnTouchSessionReqMsg)(aRegister, aViewId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPopupFilterPrioEnableReqMsg(Courier::UInt32 const & aPrio)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::PopupFilterPrioEnableReqMsg)(aPrio);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPopupFilterAllEnableReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::PopupFilterAllEnableReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPopupFilterDisableReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::PopupFilterDisableReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendProfileSwitchMsg(Courier::UInt32 const & aProfile)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ProfileSwitchMsg)(aProfile);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendMultiDisplayPopupFilterReqMsg(hmibase::PopupFilterType const & aPopupFilterType, Courier::UInt32 const & aPrio, Courier::UInt32 const & aDisplayID)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::MultiDisplayPopupFilterReqMsg)(aPopupFilterType, aPrio, aDisplayID);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendCreateNewDestroyOld(::Courier::ViewId const & aSourceView, ::Courier::ViewId const & aDestinationView, Courier::UInt32 const & aUserData1, Courier::Int8 const & aUserData2)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::CreateNewDestroyOld)(aSourceView, aDestinationView, aUserData1, aUserData2);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendNotifierMessage()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::NotifierMessage)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Activate_Home_Source(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Activate_Home_Source();
    return true;
}
#endif
void Action_Perform_Activate_Home_Source()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action Perform_Activate_Home_Source()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSwitchApplicationReq(APPID_APPHMI_MASTER, SURFACEID_MAIN_SURFACE_MASTER);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_CameraBackButton(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_CameraBackButton();
    return true;
}
#endif
void Action_CameraBackButton()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action CameraBackButton()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendCameraBackButtonMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Cabin_Source_Button(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Cabin_Source_Button();
    return true;
}
#endif
void Action_Cabin_Source_Button()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action Cabin_Source_Button()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendCabinSourceMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Main_CamSrc_Select(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Main_CamSrc_Select();
    return true;
}
#endif
void Action_Perform_Main_CamSrc_Select()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action Perform_Main_CamSrc_Select()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendButtonMainSrcActivate(1);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Cockpit_Select(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Cockpit_Select();
    return true;
}
#endif
void Action_Perform_Cockpit_Select()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action Perform_Cockpit_Select()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendButtonMainSrcActivate(254);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Main_Cabin_CamSrc_Select(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Main_Cabin_CamSrc_Select();
    return true;
}
#endif
void Action_Perform_Main_Cabin_CamSrc_Select()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action Perform_Main_Cabin_CamSrc_Select()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendButtonMainSrcCabinActivate(2);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_cabin_from_home_Select(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_cabin_from_home_Select();
    return true;
}
#endif
void Action_Perform_cabin_from_home_Select()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action Perform_cabin_from_home_Select()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendButtonMainSrcCabinActivate(253);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Next_Camera(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Next_Camera();
    return true;
}
#endif
void Action_Perform_Next_Camera()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action Perform_Next_Camera()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendNextCameraActivate();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Previous_Camera(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Previous_Camera();
    return true;
}
#endif
void Action_Perform_Previous_Camera()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action Perform_Previous_Camera()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPreviousCameraActivate();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Mixed_Source(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Mixed_Source();
    return true;
}
#endif
void Action_Perform_Mixed_Source()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action Perform_Mixed_Source()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendButtonMixedSourceMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_VisiblityOfCameraButtons(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_VisiblityOfCameraButtons();
    return true;
}
#endif
void Action_VisiblityOfCameraButtons()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action VisiblityOfCameraButtons()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendCameraToggleButton();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_CameraExitmsgRequest(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_CameraExitmsgRequest();
    return true;
}
#endif
void Action_CameraExitmsgRequest()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action CameraExitmsgRequest()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendCameraExitMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_CameraBlackScreenStartTimerRequest(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_CameraBlackScreenStartTimerRequest();
    return true;
}
#endif
void Action_CameraBlackScreenStartTimerRequest()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action CameraBlackScreenStartTimerRequest()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendCameraBlackScreenStartTimerMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_CameraStopmsgRequest(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_CameraStopmsgRequest();
    return true;
}
#endif
void Action_CameraStopmsgRequest()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action CameraStopmsgRequest()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendCameraStreamStopMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_CameraStartmsgRequest(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_CameraStartmsgRequest();
    return true;
}
#endif
void Action_CameraStartmsgRequest()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action CameraStartmsgRequest()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendCameraStreamStartMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_CameraSplitStartmsgRequest(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_CameraSplitStartmsgRequest();
    return true;
}
#endif
void Action_CameraSplitStartmsgRequest()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action CameraSplitStartmsgRequest()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendCameraSplitStreamStartMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_CabinCameraExitmsgRequest(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_CabinCameraExitmsgRequest();
    return true;
}
#endif
void Action_CabinCameraExitmsgRequest()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action CabinCameraExitmsgRequest()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendCabinCameraExitMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_SplitViewLeftCamMsgRequest(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_SplitViewLeftCamMsgRequest();
    return true;
}
#endif
void Action_SplitViewLeftCamMsgRequest()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action SplitViewLeftCamMsgRequest()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSplitViewLeftCamMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_SplitViewRightCamMsgRequest(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_SplitViewRightCamMsgRequest();
    return true;
}
#endif
void Action_SplitViewRightCamMsgRequest()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action SplitViewRightCamMsgRequest()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSplitViewRightCamMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Send_Context(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_Perform_Send_Context(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_Perform_Send_Context(Courier::UInt16 const & aContextScene)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action Perform_Send_Context(aContextScene = %d)", aContextScene));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendContextToMaster(aContextScene);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Notify_Init_Finished(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Notify_Init_Finished();
    return true;
}
#endif
void Action_Notify_Init_Finished()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action Notify_Init_Finished()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendGuiStartupFinishedUpdMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacChangeLanguageReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_gacChangeLanguageReq(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_gacChangeLanguageReq(enLanguageId const & aLanguageId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacChangeLanguageReq(aLanguageId = ?enLanguageId?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendChangeLanguageReqMsg(aLanguageId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacHideFocusInViewReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacHideFocusInViewReq(::Courier::ViewId(AppHmi_CameraStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacHideFocusInViewReq(::Courier::ViewId const & aView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacHideFocusInViewReq(aView = %50s)", aView.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendFocusReqMsg(FOCUS_HIDE, FOCUS_TIMER_NO_ACTION, aView, Candera::String());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_NextLevelTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_NextLevelTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_NextLevelTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action NextLevelTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_PreviousLevelTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_PreviousLevelTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_PreviousLevelTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action PreviousLevelTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_DualViewLeftTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_DualViewLeftTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_DualViewLeftTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action DualViewLeftTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_DualViewRightTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_DualViewRightTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_DualViewRightTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action DualViewRightTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_PageFlipBackTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_PageFlipBackTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_PageFlipBackTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action PageFlipBackTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_PageFlipFrontTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_PageFlipFrontTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_PageFlipFrontTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action PageFlipFrontTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_ZoomInTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 3) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt() && parameters[(::Json::Value::UInt)2].isInt())) { return false; }
    Action_ZoomInTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt(), parameters[(::Json::Value::UInt)2].asInt());
    return true;
}
#endif
void Action_ZoomInTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action ZoomInTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?, aPos = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, aPos);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_ZoomOutTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 3) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt() && parameters[(::Json::Value::UInt)2].isInt())) { return false; }
    Action_ZoomOutTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt(), parameters[(::Json::Value::UInt)2].asInt());
    return true;
}
#endif
void Action_ZoomOutTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action ZoomOutTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?, aPos = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, aPos);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_FadeTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_FadeTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_FadeTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action FadeTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacWaitAnimationStartReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacWaitAnimationStartReq();
    return true;
}
#endif
void Action_gacWaitAnimationStartReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacWaitAnimationStartReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAnimationReqMsg(Courier::AnimationAction::Start, ::Courier::ViewId(), Courier::CompositePath(), ::Courier::ItemId("Global#Animations#WAIT_ANIMATION"), Courier::AnimationProperties());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acFocusOnRightEncoderReqUpd(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_acFocusOnRightEncoderReqUpd(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_acFocusOnRightEncoderReqUpd(bool const & aIsFocusUsed)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action acFocusOnRightEncoderReqUpd(aIsFocusUsed = %d)", aIsFocusUsed));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendFocusOnRightEncoderReqUpdMsg(aIsFocusUsed);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSetGadgetSceenActiveStatus(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_acSetGadgetSceenActiveStatus(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_acSetGadgetSceenActiveStatus(bool const & aIsGadgetAtive)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action acSetGadgetSceenActiveStatus(aIsGadgetAtive = %d)", aIsGadgetAtive));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendStoreActiveGadgetReqMsg(aIsGadgetAtive);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acHKNotificationMsg(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_acHKNotificationMsg(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_acHKNotificationMsg(Courier::UInt8 const & aHKCode, Courier::UInt8 const & aHKState)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action acHKNotificationMsg(aHKCode = %d, aHKState = %d)", aHKCode,aHKState));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendHardKeyPressNotificationMsg(1, aHKCode, aHKState);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acPerform_CloseAllDropdowns(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acPerform_CloseAllDropdowns();
    return true;
}
#endif
void Action_acPerform_CloseAllDropdowns()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action acPerform_CloseAllDropdowns()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDropdownChangeMsg(Candera::DropdownChangeClose, 0);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acPerform_CloseDropdown(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acPerform_CloseDropdown(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acPerform_CloseDropdown(::Courier::UInt32 const & aListId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action acPerform_CloseDropdown(aListId = ?::Courier::UInt32?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDropdownChangeMsg(Candera::DropdownChangeClose, aListId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acPerform_OpenDropdown(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acPerform_OpenDropdown(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acPerform_OpenDropdown(::Courier::UInt32 const & aListId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action acPerform_OpenDropdown(aListId = ?::Courier::UInt32?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDropdownChangeMsg(Candera::DropdownChangeOpen, aListId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acPerform_ToggleDropdown(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acPerform_ToggleDropdown(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acPerform_ToggleDropdown(::Courier::UInt32 const & aListId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action acPerform_ToggleDropdown(aListId = ?::Courier::UInt32?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDropdownChangeMsg(Candera::DropdownChangeToggle, aListId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acStartAppPopupTimer(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_acStartAppPopupTimer(parameters[(::Json::Value::UInt)0].asUInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_acStartAppPopupTimer(Courier::UInt32 const & aViewId, Courier::UInt32 const & aTimeout)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action acStartAppPopupTimer(aViewId = %d, aTimeout = %d)", aViewId,aTimeout));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendStartPopupTimerReqMsg(aViewId, aTimeout);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acStopAppPopupTimer(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acStopAppPopupTimer(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acStopAppPopupTimer(Courier::UInt32 const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action acStopAppPopupTimer(aViewId = %d)", aViewId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendStopPopupTimerReqMsg(aViewId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acPostBeep(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_acPostBeep(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_acPostBeep(Courier::Int32 const & aBeepType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action acPostBeep(aBeepType = %d)", aBeepType));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPlayBeepReqMsg(aBeepType);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacCheckToClosePopup(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacCheckToClosePopup(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacCheckToClosePopup(Courier::UInt32 const & aPopupId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacCheckToClosePopup(aPopupId = %d)", aPopupId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendCheckToClosePopupMsg(aPopupId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acRestartAppPopupTimer(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acRestartAppPopupTimer(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acRestartAppPopupTimer(Courier::UInt32 const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action acRestartAppPopupTimer(aViewId = %d)", aViewId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendRestartPopupTimerReqMsg(aViewId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchBackRes(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacContextSwitchBackRes(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacContextSwitchBackRes(Courier::UInt32 const & aSwitchId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacContextSwitchBackRes(aSwitchId = %d)", aSwitchId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendContextSwitchInResMsg(aSwitchId, CONTEXT_TRANSITION_BACK);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchCompleteRes(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacContextSwitchCompleteRes(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacContextSwitchCompleteRes(Courier::UInt32 const & aSwitchId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacContextSwitchCompleteRes(aSwitchId = %d)", aSwitchId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendContextSwitchInResMsg(aSwitchId, CONTEXT_TRANSITION_COMPLETE);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchFailedRes(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacContextSwitchFailedRes(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacContextSwitchFailedRes(Courier::UInt32 const & aSwitchId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacContextSwitchFailedRes(aSwitchId = %d)", aSwitchId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendContextSwitchInResMsg(aSwitchId, CONTEXT_TRANSITION_FAILED);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchDoneRes(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacContextSwitchDoneRes(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacContextSwitchDoneRes(Courier::UInt32 const & aSwitchId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacContextSwitchDoneRes(aSwitchId = %d)", aSwitchId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendContextSwitchInResMsg(aSwitchId, CONTEXT_TRANSITION_DONE);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchOutReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 3) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt() && parameters[(::Json::Value::UInt)2].isUInt())) { return false; }
    Action_gacContextSwitchOutReq(parameters[(::Json::Value::UInt)0].asUInt(), parameters[(::Json::Value::UInt)1].asUInt(), parameters[(::Json::Value::UInt)2].asUInt());
    return true;
}
#endif
void Action_gacContextSwitchOutReq(Courier::UInt32 const & aTargetContextId, Courier::UInt32 const & aSourceContextId, Courier::UInt32 const & aTargetAppId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacContextSwitchOutReq(aTargetContextId = %d, aSourceContextId = %d, aTargetAppId = %d)", aTargetContextId,aSourceContextId,aTargetAppId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendContextSwitchOutReqMsg(aTargetContextId, aSourceContextId, aTargetAppId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacCurrentScreenDisplayReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacCurrentScreenDisplayReq();
    return true;
}
#endif
void Action_gacCurrentScreenDisplayReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacCurrentScreenDisplayReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendCurrentScreenDisplayReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacLaunchBarDisplayReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_gacLaunchBarDisplayReq(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_gacLaunchBarDisplayReq(bool const & aVisibility)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacLaunchBarDisplayReq(aVisibility = %d)", aVisibility));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendLaunchBarDisplayReqMsg(aVisibility);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacNavTBTSwipe(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacNavTBTSwipe();
    return true;
}
#endif
void Action_gacNavTBTSwipe()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacNavTBTSwipe()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendNavTBTSwipeReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPerformListBtnRightEncoderChangeUpd(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 4) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isUInt() && parameters[(::Json::Value::UInt)2].isUInt() && parameters[(::Json::Value::UInt)3].isUInt())) { return false; }
    Action_gacPerformListBtnRightEncoderChangeUpd(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asUInt(), parameters[(::Json::Value::UInt)2].asUInt(), parameters[(::Json::Value::UInt)3].asUInt());
    return true;
}
#endif
void Action_gacPerformListBtnRightEncoderChangeUpd(Courier::Int8 const & aSteps, Courier::UInt32 const & aListId, Courier::UInt32 const & aRowId, Courier::UInt32 const & aColumnId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacPerformListBtnRightEncoderChangeUpd(aSteps = %d, aListId = %d, aRowId = %d, aColumnId = %d)", aSteps,aListId,aRowId,aColumnId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListItemRightEncoderChangeUpdMsg(aSteps, aListId, aRowId, aColumnId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListUp(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacScrollListUp();
    return true;
}
#endif
void Action_gacScrollListUp()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacScrollListUp()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListChangeMsg(::Courier::UInt32(), ListChangeUp, 1, ListChangeMsgSourceUnknown, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListDown(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacScrollListDown();
    return true;
}
#endif
void Action_gacScrollListDown()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacScrollListDown()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListChangeMsg(::Courier::UInt32(), ListChangeDown, 1, ListChangeMsgSourceUnknown, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacScrollPageUp(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacScrollPageUp();
    return true;
}
#endif
void Action_gacScrollPageUp()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacScrollPageUp()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListChangeMsg(::Courier::UInt32(), ListChangePageUp, 1, ListChangeMsgSourceUnknown, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacScrollPageDown(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacScrollPageDown();
    return true;
}
#endif
void Action_gacScrollPageDown()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacScrollPageDown()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListChangeMsg(::Courier::UInt32(), ListChangePageDown, 1, ListChangeMsgSourceUnknown, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListFocusUp(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacScrollListFocusUp(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacScrollListFocusUp(Courier::UInt32 const & aListId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacScrollListFocusUp(aListId = %d)", aListId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListFocusScrollReqMsg(aListId, -1);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListFocusDown(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacScrollListFocusDown(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacScrollListFocusDown(Courier::UInt32 const & aListId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacScrollListFocusDown(aListId = %d)", aListId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListFocusScrollReqMsg(aListId, 1);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPerformListFocusLockDataResetUpd(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacPerformListFocusLockDataResetUpd();
    return true;
}
#endif
void Action_gacPerformListFocusLockDataResetUpd()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacPerformListFocusLockDataResetUpd()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListFocusLockDataResetReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacSetApplicationMode(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacSetApplicationMode(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacSetApplicationMode(Courier::UInt32 const & aModeId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacSetApplicationMode(aModeId = %d)", aModeId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSetApplicationModeReqMsg(aModeId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacSpellerBbehaviorReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_gacSpellerBbehaviorReq(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_gacSpellerBbehaviorReq(bool const & aEnable)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacSpellerBbehaviorReq(aEnable = %d)", aEnable));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSpellerBbehaviorReqMsg(aEnable);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacStatusBarDisplayReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_gacStatusBarDisplayReq(parameters[(::Json::Value::UInt)0].asBool(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_gacStatusBarDisplayReq(bool const & aVisibility, Courier::Int32 const & aHeaderType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacStatusBarDisplayReq(aVisibility = %d, aHeaderType = %d)", aVisibility,aHeaderType));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendStatusBarDisplayReqMsg(aVisibility, aHeaderType);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacTBTRetriggerAcousticOutput(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacTBTRetriggerAcousticOutput();
    return true;
}
#endif
void Action_gacTBTRetriggerAcousticOutput()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacTBTRetriggerAcousticOutput()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTBTRetriggerAcousticMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacWaitAnimationStopReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacWaitAnimationStopReq();
    return true;
}
#endif
void Action_gacWaitAnimationStopReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacWaitAnimationStopReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAnimationReqMsg(Courier::AnimationAction::Stop, ::Courier::ViewId(), Courier::CompositePath(), ::Courier::ItemId("Global#Animations#WAIT_ANIMATION"), Courier::AnimationProperties());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewCreateReq(::Courier::ViewId(AppHmi_CameraStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewCreateReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacViewCreateReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendViewReqMsg(Courier::ViewAction::Create, aViewId, true, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateAllReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewCreateAllReq(::Courier::ViewId(AppHmi_CameraStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewCreateAllReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacViewCreateAllReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendViewReqMsg(Courier::ViewAction::CreateAll, aViewId, true, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewDestroyReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewDestroyReq(::Courier::ViewId(AppHmi_CameraStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewDestroyReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacViewDestroyReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendViewReqMsg(Courier::ViewAction::Destroy, aViewId, false, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewClearReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewClearReq(::Courier::ViewId(AppHmi_CameraStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewClearReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacViewClearReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendViewReqMsg(Courier::ViewAction::Clear, aViewId, true, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewShowReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewShowReq(::Courier::ViewId(AppHmi_CameraStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewShowReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacViewShowReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendActivationReqMsg(aViewId, true, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewHideReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewHideReq(::Courier::ViewId(AppHmi_CameraStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewHideReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacViewHideReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendActivationReqMsg(aViewId, false, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateWithoutLoadReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewCreateWithoutLoadReq(::Courier::ViewId(AppHmi_CameraStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewCreateWithoutLoadReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacViewCreateWithoutLoadReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendViewReqMsg(Courier::ViewAction::Create, aViewId, false, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewAsyncLoadReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewAsyncLoadReq(::Courier::ViewId(AppHmi_CameraStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewAsyncLoadReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacViewAsyncLoadReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAsyncLoadReqMsg(aViewId, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewActivateWithoutRenderingReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewActivateWithoutRenderingReq(::Courier::ViewId(AppHmi_CameraStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewActivateWithoutRenderingReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacViewActivateWithoutRenderingReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendActivationReqMsg(aViewId, true, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupCreateAndSBShowReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacPopupCreateAndSBShowReq(::Courier::ViewId(AppHmi_CameraStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacPopupCreateAndSBShowReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacPopupCreateAndSBShowReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupReqMsg(hmibase::popups::Show, aViewId, hmibase::DEFAULT_UNKNOWN_DISPLAY);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupCreateAndSBShowReqForMultiDisplay(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacPopupCreateAndSBShowReqForMultiDisplay(parameters[(::Json::Value::UInt)0].asUInt(), ::Courier::ViewId(AppHmi_CameraStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)1].asUInt())));
    return true;
}
#endif
void Action_gacPopupCreateAndSBShowReqForMultiDisplay(Courier::UInt32 const & aPopupDisplayID, ::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacPopupCreateAndSBShowReqForMultiDisplay(aPopupDisplayID = %d, aViewId = %50s)", aPopupDisplayID,aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupReqMsg(hmibase::popups::Show, aViewId, aPopupDisplayID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupSBCloseReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacPopupSBCloseReq(::Courier::ViewId(AppHmi_CameraStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacPopupSBCloseReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacPopupSBCloseReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupReqMsg(hmibase::popups::Hide, aViewId, hmibase::DEFAULT_UNKNOWN_DISPLAY);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupSBCloseReqForMultiDisplay(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacPopupSBCloseReqForMultiDisplay(parameters[(::Json::Value::UInt)0].asUInt(), ::Courier::ViewId(AppHmi_CameraStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)1].asUInt())));
    return true;
}
#endif
void Action_gacPopupSBCloseReqForMultiDisplay(Courier::UInt32 const & aPopupDisplayID, ::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacPopupSBCloseReqForMultiDisplay(aPopupDisplayID = %d, aViewId = %50s)", aPopupDisplayID,aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupReqMsg(hmibase::popups::Hide, aViewId, aPopupDisplayID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupRestartTimerReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacPopupRestartTimerReq(::Courier::ViewId(AppHmi_CameraStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacPopupRestartTimerReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacPopupRestartTimerReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupReqMsg(hmibase::popups::RestartTimer, aViewId, hmibase::DEFAULT_UNKNOWN_DISPLAY);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupRestartTimerReqForMultiDisplay(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacPopupRestartTimerReqForMultiDisplay(parameters[(::Json::Value::UInt)0].asUInt(), ::Courier::ViewId(AppHmi_CameraStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)1].asUInt())));
    return true;
}
#endif
void Action_gacPopupRestartTimerReqForMultiDisplay(Courier::UInt32 const & aPopupDisplayID, ::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacPopupRestartTimerReqForMultiDisplay(aPopupDisplayID = %d, aViewId = %50s)", aPopupDisplayID,aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupReqMsg(hmibase::popups::RestartTimer, aViewId, aPopupDisplayID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateAndShowReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewCreateAndShowReq(::Courier::ViewId(AppHmi_CameraStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewCreateAndShowReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacViewCreateAndShowReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendExtendedViewReqMsg(hmibase::views::CreateAndShow, aViewId, 0);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewHideAndDestroyReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewHideAndDestroyReq(::Courier::ViewId(AppHmi_CameraStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewHideAndDestroyReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacViewHideAndDestroyReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendExtendedViewReqMsg(hmibase::views::HideAndDestroy, aViewId, 0);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacSceneTransitionEnter(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacSceneTransitionEnter(::Courier::ViewId(AppHmi_CameraStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt(), ))parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacSceneTransitionEnter(::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacSceneTransitionEnter(aViewId = %50s, aHint = %d)", aViewId.CStr(),aHint));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendExtendedViewReqMsg(hmibase::views::TransitionEnter, aViewId, aHint);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacSceneTransitionLeave(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacSceneTransitionLeave(::Courier::ViewId(AppHmi_CameraStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt(), ))parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacSceneTransitionLeave(::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacSceneTransitionLeave(aViewId = %50s, aHint = %d)", aViewId.CStr(),aHint));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendExtendedViewReqMsg(hmibase::views::TransitionLeave, aViewId, aHint);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayStatusLineReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_gacDisplayStatusLineReq(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_gacDisplayStatusLineReq(Courier::Int32 const & aDisplayRegionType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacDisplayStatusLineReq(aDisplayRegionType = %d)", aDisplayRegionType));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::STATUS_LINE, aDisplayRegionType, true, hmibase::DEFAULT_UNKNOWN_DISPLAY, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacHideStatusLineReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_gacHideStatusLineReq(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_gacHideStatusLineReq(Courier::Int32 const & aDisplayRegionType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacHideStatusLineReq(aDisplayRegionType = %d)", aDisplayRegionType));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::STATUS_LINE, aDisplayRegionType, false, hmibase::DEFAULT_UNKNOWN_DISPLAY, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayFooterLineReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacDisplayFooterLineReq();
    return true;
}
#endif
void Action_gacDisplayFooterLineReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacDisplayFooterLineReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::FOOTER_LINE, Courier::Int32(), true, hmibase::DEFAULT_UNKNOWN_DISPLAY, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacHideFooterLineReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacHideFooterLineReq();
    return true;
}
#endif
void Action_gacHideFooterLineReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacHideFooterLineReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::FOOTER_LINE, Courier::Int32(), false, hmibase::DEFAULT_UNKNOWN_DISPLAY, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayStatusLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacDisplayStatusLineMultiDisplayReq(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacDisplayStatusLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacDisplayStatusLineMultiDisplayReq(aDisplayRegionType = %d, aDisplayID = %d)", aDisplayRegionType,aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::STATUS_LINE, aDisplayRegionType, true, aDisplayID, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacHideStatusLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacHideStatusLineMultiDisplayReq(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacHideStatusLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacHideStatusLineMultiDisplayReq(aDisplayRegionType = %d, aDisplayID = %d)", aDisplayRegionType,aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::STATUS_LINE, aDisplayRegionType, false, aDisplayID, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayFooterLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacDisplayFooterLineMultiDisplayReq(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacDisplayFooterLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacDisplayFooterLineMultiDisplayReq(aDisplayRegionType = %d, aDisplayID = %d)", aDisplayRegionType,aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::FOOTER_LINE, aDisplayRegionType, true, aDisplayID, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacHideFooterLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacHideFooterLineMultiDisplayReq(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacHideFooterLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacHideFooterLineMultiDisplayReq(aDisplayRegionType = %d, aDisplayID = %d)", aDisplayRegionType,aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::FOOTER_LINE, aDisplayRegionType, false, aDisplayID, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacRegisterForCloseOnTouchSession(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacRegisterForCloseOnTouchSession(::Courier::ViewId(AppHmi_CameraStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacRegisterForCloseOnTouchSession(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacRegisterForCloseOnTouchSession(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendRegisterForCloseOnTouchSessionReqMsg(true, aViewId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacDeregisterForCloseOnTouchSessionReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacDeregisterForCloseOnTouchSessionReq(::Courier::ViewId(AppHmi_CameraStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacDeregisterForCloseOnTouchSessionReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacDeregisterForCloseOnTouchSessionReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendRegisterForCloseOnTouchSessionReqMsg(false, aViewId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterPrioEnableReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacPopupFilterPrioEnableReq(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacPopupFilterPrioEnableReq(Courier::UInt32 const & aPrio)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacPopupFilterPrioEnableReq(aPrio = %d)", aPrio));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupFilterPrioEnableReqMsg(aPrio);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterAllEnableReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacPopupFilterAllEnableReq();
    return true;
}
#endif
void Action_gacPopupFilterAllEnableReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacPopupFilterAllEnableReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupFilterAllEnableReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterDisableReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacPopupFilterDisableReq();
    return true;
}
#endif
void Action_gacPopupFilterDisableReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacPopupFilterDisableReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupFilterDisableReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacProfileChange(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_gacProfileChange(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_gacProfileChange(Courier::UInt32 const & aProfile)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacProfileChange(aProfile = %d)", aProfile));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendProfileSwitchMsg(aProfile);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterPrioEnableReqForDisplay(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacPopupFilterPrioEnableReqForDisplay(parameters[(::Json::Value::UInt)0].asUInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacPopupFilterPrioEnableReqForDisplay(Courier::UInt32 const & aPrio, Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacPopupFilterPrioEnableReqForDisplay(aPrio = %d, aDisplayID = %d)", aPrio,aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendMultiDisplayPopupFilterReqMsg(hmibase::ENABLE_PRIO, aPrio, aDisplayID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterAllEnableReqForDisplay(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacPopupFilterAllEnableReqForDisplay(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacPopupFilterAllEnableReqForDisplay(Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacPopupFilterAllEnableReqForDisplay(aDisplayID = %d)", aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendMultiDisplayPopupFilterReqMsg(hmibase::ENABLE_ALL, 0, aDisplayID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterDisableReqForDisplay(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacPopupFilterDisableReqForDisplay(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacPopupFilterDisableReqForDisplay(Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacPopupFilterDisableReqForDisplay(aDisplayID = %d)", aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendMultiDisplayPopupFilterReqMsg(hmibase::DISABLE_ALL, 0, aDisplayID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacStartSceneTransitionAnimation(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 4) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt() && parameters[(::Json::Value::UInt)2].isUInt() && parameters[(::Json::Value::UInt)3].isInt())) { return false; }
    Action_gacStartSceneTransitionAnimation(::Courier::ViewId(AppHmi_CameraStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt(), ))::Courier::ViewId(AppHmi_CameraStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)1].asUInt(), ))parameters[(::Json::Value::UInt)2].asUInt(), parameters[(::Json::Value::UInt)3].asInt());
    return true;
}
#endif
void Action_gacStartSceneTransitionAnimation(::Courier::ViewId const & aSourceView, ::Courier::ViewId const & aDestinationView, Courier::UInt32 const & aUserData1, Courier::Int8 const & aUserData2)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacStartSceneTransitionAnimation(aSourceView = %50s, aDestinationView = %50s, aUserData1 = %d, aUserData2 = %d)", aSourceView.CStr(),aDestinationView.CStr(),aUserData1,aUserData2));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendCreateNewDestroyOld(aSourceView, aDestinationView, aUserData1, aUserData2);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacDecrementActiveAnimationCount(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacDecrementActiveAnimationCount();
    return true;
}
#endif
void Action_gacDecrementActiveAnimationCount()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_CAMERA_SM, "SM_ACTIONS:    Trigger action gacDecrementActiveAnimationCount()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendNotifierMessage();
    COURIER_UNUSED(ok);
}
//====  defines and includes TTFis output - added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====    

unsigned short AppHmi_CameraStateMachineImpl::GetTraceClass (){  
   return TR_CLASS_APPHMI_CAMERA_SM; 
}

//====  member function with TTFis output - end                        key: SM_TTFis_SBHFMSRF ==== 

#include "hmibase/util/Macros.h"

#ifdef CIT_SIMULATION
#define CIT_EVENT_ID(eventId, hashId) hashId
#else
#define CIT_EVENT_ID(eventId, hashId) eventId
#endif
// ------------------------------------------------------------------------

#if !defined onTopPopupSurfaceInvisible
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onTopPopupSurfaceInvisible 0xffff
#pragma _REMINDER("Using dummy value symbol onTopPopupSurfaceInvisible ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onTopPopupSurfaceInvisible -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onTopPopupSurfaceVisible
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onTopPopupSurfaceVisible 0xffff
#pragma _REMINDER("Using dummy value symbol onTopPopupSurfaceVisible ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onTopPopupSurfaceVisible -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onTopPopupSurfaceUnqueued
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onTopPopupSurfaceUnqueued 0xffff
#pragma _REMINDER("Using dummy value symbol onTopPopupSurfaceUnqueued ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onTopPopupSurfaceUnqueued -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onTopPopupSurfaceQueued
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onTopPopupSurfaceQueued 0xffff
#pragma _REMINDER("Using dummy value symbol onTopPopupSurfaceQueued ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onTopPopupSurfaceQueued -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onCenterPopupSurfaceInvisible
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onCenterPopupSurfaceInvisible 0xffff
#pragma _REMINDER("Using dummy value symbol onCenterPopupSurfaceInvisible ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onCenterPopupSurfaceInvisible -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onCenterPopupSurfaceVisible
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onCenterPopupSurfaceVisible 0xffff
#pragma _REMINDER("Using dummy value symbol onCenterPopupSurfaceVisible ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onCenterPopupSurfaceVisible -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onCenterPopupSurfaceUnqueued
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onCenterPopupSurfaceUnqueued 0xffff
#pragma _REMINDER("Using dummy value symbol onCenterPopupSurfaceUnqueued ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onCenterPopupSurfaceUnqueued -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onCenterPopupSurfaceQueued
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onCenterPopupSurfaceQueued 0xffff
#pragma _REMINDER("Using dummy value symbol onCenterPopupSurfaceQueued ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onCenterPopupSurfaceQueued -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onPopupInvisible
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onPopupInvisible 0xffff
#pragma _REMINDER("Using dummy value symbol onPopupInvisible ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onPopupInvisible -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onPopupVisible
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onPopupVisible 0xffff
#pragma _REMINDER("Using dummy value symbol onPopupVisible ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onPopupVisible -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onPopupUnqueued
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onPopupUnqueued 0xffff
#pragma _REMINDER("Using dummy value symbol onPopupUnqueued ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onPopupUnqueued -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onPopupQueued
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onPopupQueued 0xffff
#pragma _REMINDER("Using dummy value symbol onPopupQueued ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onPopupQueued -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForSurfaceStateChangedUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);

#ifdef onTopPopupSurfaceInvisible
    if ((message.GetSurfaceId() == SURFACEID_TOP_POPUP_SURFACE_CAMERA) && (message.GetState() == SURFACESTATE_INVISIBLE)) { eventId = CIT_EVENT_ID(onTopPopupSurfaceInvisible, 0x3598CF84); return true; }
#endif
#ifdef onTopPopupSurfaceVisible
    if ((message.GetSurfaceId() == SURFACEID_TOP_POPUP_SURFACE_CAMERA) && (message.GetState() == SURFACESTATE_VISIBLE)) { eventId = CIT_EVENT_ID(onTopPopupSurfaceVisible, 0x984F8ED8); return true; }
#endif
#ifdef onTopPopupSurfaceUnqueued
    if ((message.GetSurfaceId() == SURFACEID_TOP_POPUP_SURFACE_CAMERA) && (message.GetState() == SURFACESTATE_UNQUEUED)) { eventId = CIT_EVENT_ID(onTopPopupSurfaceUnqueued, 0x912024BE); return true; }
#endif
#ifdef onTopPopupSurfaceQueued
    if ((message.GetSurfaceId() == SURFACEID_TOP_POPUP_SURFACE_CAMERA) && (message.GetState() == SURFACESTATE_QUEUED)) { eventId = CIT_EVENT_ID(onTopPopupSurfaceQueued, 0xB630DDBD); return true; }
#endif
#ifdef onCenterPopupSurfaceInvisible
    if ((message.GetSurfaceId() == SURFACEID_CENTER_POPUP_SURFACE_CAMERA) && (message.GetState() == SURFACESTATE_INVISIBLE)) { eventId = CIT_EVENT_ID(onCenterPopupSurfaceInvisible, 0x9BDB722F); return true; }
#endif
#ifdef onCenterPopupSurfaceVisible
    if ((message.GetSurfaceId() == SURFACEID_CENTER_POPUP_SURFACE_CAMERA) && (message.GetState() == SURFACESTATE_VISIBLE)) { eventId = CIT_EVENT_ID(onCenterPopupSurfaceVisible, 0x23B97E51); return true; }
#endif
#ifdef onCenterPopupSurfaceUnqueued
    if ((message.GetSurfaceId() == SURFACEID_CENTER_POPUP_SURFACE_CAMERA) && (message.GetState() == SURFACESTATE_UNQUEUED)) { eventId = CIT_EVENT_ID(onCenterPopupSurfaceUnqueued, 0xAA79C7DD); return true; }
#endif
#ifdef onCenterPopupSurfaceQueued
    if ((message.GetSurfaceId() == SURFACEID_CENTER_POPUP_SURFACE_CAMERA) && (message.GetState() == SURFACESTATE_QUEUED)) { eventId = CIT_EVENT_ID(onCenterPopupSurfaceQueued, 0xFC0D2293); return true; }
#endif
#ifdef onPopupInvisible
    if ((message.GetState() == SURFACESTATE_INVISIBLE)) { eventId = CIT_EVENT_ID(onPopupInvisible, 0x6C1CD62F); return true; }
#endif
#ifdef onPopupVisible
    if ((message.GetState() == SURFACESTATE_VISIBLE)) { eventId = CIT_EVENT_ID(onPopupVisible, 0xB78D7AE0); return true; }
#endif
#ifdef onPopupUnqueued
    if ((message.GetState() == SURFACESTATE_UNQUEUED)) { eventId = CIT_EVENT_ID(onPopupUnqueued, 0xDB0D29F4); return true; }
#endif
#ifdef onPopupQueued
    if ((message.GetState() == SURFACESTATE_QUEUED)) { eventId = CIT_EVENT_ID(onPopupQueued, 0xBBE6896C); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSurfaceStateChangedUpdMsg(AppHmi_CameraStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
#ifdef onTopPopupSurfaceInvisible
    if (eventId == onTopPopupSurfaceInvisible) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_CameraStateMachineImpl::VS_Ret_Ok, AppHmi_CameraStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onTopPopupSurfaceInvisible.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onTopPopupSurfaceVisible
    if (eventId == onTopPopupSurfaceVisible) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_CameraStateMachineImpl::VS_Ret_Ok, AppHmi_CameraStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onTopPopupSurfaceVisible.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onTopPopupSurfaceUnqueued
    if (eventId == onTopPopupSurfaceUnqueued) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_CameraStateMachineImpl::VS_Ret_Ok, AppHmi_CameraStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onTopPopupSurfaceUnqueued.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onTopPopupSurfaceQueued
    if (eventId == onTopPopupSurfaceQueued) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_CameraStateMachineImpl::VS_Ret_Ok, AppHmi_CameraStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onTopPopupSurfaceQueued.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onCenterPopupSurfaceInvisible
    if (eventId == onCenterPopupSurfaceInvisible) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_CameraStateMachineImpl::VS_Ret_Ok, AppHmi_CameraStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onCenterPopupSurfaceInvisible.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onCenterPopupSurfaceVisible
    if (eventId == onCenterPopupSurfaceVisible) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_CameraStateMachineImpl::VS_Ret_Ok, AppHmi_CameraStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onCenterPopupSurfaceVisible.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onCenterPopupSurfaceUnqueued
    if (eventId == onCenterPopupSurfaceUnqueued) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_CameraStateMachineImpl::VS_Ret_Ok, AppHmi_CameraStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onCenterPopupSurfaceUnqueued.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onCenterPopupSurfaceQueued
    if (eventId == onCenterPopupSurfaceQueued) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_CameraStateMachineImpl::VS_Ret_Ok, AppHmi_CameraStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onCenterPopupSurfaceQueued.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onPopupInvisible
    if (eventId == onPopupInvisible) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_CameraStateMachineImpl::VS_Ret_Ok, AppHmi_CameraStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onPopupInvisible.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onPopupVisible
    if (eventId == onPopupVisible) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_CameraStateMachineImpl::VS_Ret_Ok, AppHmi_CameraStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onPopupVisible.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onPopupUnqueued
    if (eventId == onPopupUnqueued) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_CameraStateMachineImpl::VS_Ret_Ok, AppHmi_CameraStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onPopupUnqueued.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onPopupQueued
    if (eventId == onPopupQueued) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_CameraStateMachineImpl::VS_Ret_Ok, AppHmi_CameraStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onPopupQueued.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_CameraStateMachineImpl::VS_Ret_Ok, AppHmi_CameraStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForButtonReactionMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::ButtonReactionMsg const & message = static_cast< ::ButtonReactionMsg const &>(aMessage);

#ifdef OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraSourceSelection_Layer_TouchArea_Door_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_CameraApp#Scenes#C_CameraSourceSelection")) && (message.GetSender() == ::Courier::Identifier(0x39ac2037 /* Layer_TouchArea_Door/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraSourceSelection_Layer_TouchArea_Door_ButtonWidget_enRelease, 0x8CF43B73); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraCabinView_Layer_TouchArea_CAM1_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_CameraApp#Scenes#C_CameraCabinView")) && (message.GetSender() == ::Courier::Identifier(0x890a0f74 /* Layer_TouchArea_CAM1/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraCabinView_Layer_TouchArea_CAM1_ButtonWidget_enRelease, 0xAAA3A77F); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraCabinView_Layer_TouchArea_CAM2_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_CameraApp#Scenes#C_CameraCabinView")) && (message.GetSender() == ::Courier::Identifier(0xdf09561d /* Layer_TouchArea_CAM2/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraCabinView_Layer_TouchArea_CAM2_ButtonWidget_enRelease, 0xAC90E0D0); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraCabinView_Layer_TouchArea_CAM3_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_CameraApp#Scenes#C_CameraCabinView")) && (message.GetSender() == ::Courier::Identifier(0xd0131e21 /* Layer_TouchArea_CAM3/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraCabinView_Layer_TouchArea_CAM3_ButtonWidget_enRelease, 0x1E6644A7); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraCabinView_Layer_TouchArea_CAM4_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_CameraApp#Scenes#C_CameraCabinView")) && (message.GetSender() == ::Courier::Identifier(0x33406540 /* Layer_TouchArea_CAM4/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraCabinView_Layer_TouchArea_CAM4_ButtonWidget_enRelease, 0x00834BAD); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraRearView_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_CameraApp#Scenes#C_CameraRearView")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraRearView_Layer_TouchArea_Back_ButtonWidget_enRelease, 0xF7884CE5); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraRearView_Button_Text_Ignore_Button_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_CameraApp#Scenes#C_CameraRearView")) && (message.GetSender() == ::Courier::Identifier(0x9b66962d /* Button_Text_Ignore/Button */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraRearView_Button_Text_Ignore_Button_enRelease, 0xC497E808); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_CameraApp_Gadget_Cam_CAM_GADGET_Button_Text_Image_Icon_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_CameraApp#Gadget_Cam#CAM_GADGET")) && (message.GetSender() == ::Courier::Identifier(0x760862e9 /* Button_Text_Image_Icon/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_CameraApp_Gadget_Cam_CAM_GADGET_Button_Text_Image_Icon_ButtonWidget_enRelease, 0x25D2B9F4); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_CameraApp_Gadget_Cam_CAM_GADGET_Camera_SourceSelection_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_CameraApp#Gadget_Cam#CAM_GADGET")) && (message.GetSender() == ::Courier::Identifier(0xae6504d6 /* Camera_SourceSelection/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_CameraApp_Gadget_Cam_CAM_GADGET_Camera_SourceSelection_ButtonWidget_enRelease, 0x3FF91C29); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_CameraApp_Gadget_Cam_CAM_GADGET_Camera_Tile_Cockpit_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_CameraApp#Gadget_Cam#CAM_GADGET")) && (message.GetSender() == ::Courier::Identifier(0x9b8e3879 /* Camera_Tile_Cockpit/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_CameraApp_Gadget_Cam_CAM_GADGET_Camera_Tile_Cockpit_ButtonWidget_enRelease, 0xA9542014); return true; }
#endif
#ifdef Activate_ButtonTextImageIcon
    if ((message.GetView() == ::Courier::ViewId("AppHmi_CameraApp#Gadget_Cam_Non_Navi#CAM_GADGET_NON_NAVI")) && (message.GetSender() == ::Courier::Identifier(0x760862e9 /* Button_Text_Image_Icon/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(Activate_ButtonTextImageIcon, 0x325FCDC7); return true; }
#endif
#ifdef Activate_CameraSourceSelection
    if ((message.GetView() == ::Courier::ViewId("AppHmi_CameraApp#Gadget_Cam_Non_Navi#CAM_GADGET_NON_NAVI")) && (message.GetSender() == ::Courier::Identifier(0xae6504d6 /* Camera_SourceSelection/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(Activate_CameraSourceSelection, 0x8A3E4D54); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraCabinView_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_CameraApp#Scenes#C_CameraCabinView")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraCabinView_Layer_TouchArea_Back_ButtonWidget_enRelease, 0x5D807F69); return true; }
#endif
#ifdef Activate_CameraTileCockpit
    if ((message.GetView() == ::Courier::ViewId("AppHmi_CameraApp#Gadget_Cam_Non_Navi#CAM_GADGET_NON_NAVI")) && (message.GetSender() == ::Courier::Identifier(0x9b8e3879 /* Camera_Tile_Cockpit/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(Activate_CameraTileCockpit, 0xF4554DBA); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_CameraApp_Gadget_Cam_Cabin_CameraHomeScreen_Cabin_Layer_Previous_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_CameraApp#Gadget_Cam_Cabin#CameraHomeScreen_Cabin")) && (message.GetSender() == ::Courier::Identifier(0xf8a04344 /* Layer_Previous/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_CameraApp_Gadget_Cam_Cabin_CameraHomeScreen_Cabin_Layer_Previous_ButtonWidget_enRelease, 0xF682EB9B); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_CameraApp_Gadget_Cam_Cabin_CameraHomeScreen_Cabin_Layer_Next_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_CameraApp#Gadget_Cam_Cabin#CameraHomeScreen_Cabin")) && (message.GetSender() == ::Courier::Identifier(0xeb10ff43 /* Layer_Next/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_CameraApp_Gadget_Cam_Cabin_CameraHomeScreen_Cabin_Layer_Next_ButtonWidget_enRelease, 0x8EBADFFC); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_CameraApp_Gadget_Cam_Cabin_CameraHomeScreen_Cabin_Icon_Camera_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_CameraApp#Gadget_Cam_Cabin#CameraHomeScreen_Cabin")) && (message.GetSender() == ::Courier::Identifier(0x75fac239 /* Icon_Camera/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_CameraApp_Gadget_Cam_Cabin_CameraHomeScreen_Cabin_Icon_Camera_ButtonWidget_enRelease, 0xC38DEC37); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_CameraApp_Gadget_Cam_Cabin_CameraHomeScreen_Cabin_Text_Cabin_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_CameraApp#Gadget_Cam_Cabin#CameraHomeScreen_Cabin")) && (message.GetSender() == ::Courier::Identifier(0x03b41e9f /* Text_Cabin/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_CameraApp_Gadget_Cam_Cabin_CameraHomeScreen_Cabin_Text_Cabin_ButtonWidget_enRelease, 0x8BBC95F8); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_CameraApp_CameraSystemPopups_Camera_Warning_Popup_Button_Cancel_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_CameraApp#CameraSystemPopups#Camera_Warning_Popup")) && (message.GetSender() == ::Courier::Identifier(0xf092fcd3 /* Button_Cancel/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_CameraApp_CameraSystemPopups_Camera_Warning_Popup_Button_Cancel_ButtonWidget_enRelease, 0xEB3B7AE2); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_CameraApp_CameraSystemPopups_Camera_Not_configured_Button_Exit_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_CameraApp#CameraSystemPopups#Camera_Not_configured")) && (message.GetSender() == ::Courier::Identifier(0x816f90e2 /* Button_Exit/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_CameraApp_CameraSystemPopups_Camera_Not_configured_Button_Exit_ButtonWidget_enRelease, 0x0CB8E387); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_CameraApp_Gadget_Cam_Cabin_CameraHomeScreen_Cabin_TouchArea_Mixed_Source_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_CameraApp#Gadget_Cam_Cabin#CameraHomeScreen_Cabin")) && (message.GetSender() == ::Courier::Identifier(0x41c1db41 /* TouchArea_Mixed_Source/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_CameraApp_Gadget_Cam_Cabin_CameraHomeScreen_Cabin_TouchArea_Mixed_Source_ButtonWidget_enRelease, 0xC206C224); return true; }
#endif
#ifdef Activate_TouchAreaCameraBtn
    if ((message.GetView() == ::Courier::ViewId("AppHmi_CameraApp#Gadget_Cam_Cabin_Non_Navi#CameraHomeScreen_Cabin_Non_Navi")) && (message.GetSender() == ::Courier::Identifier(0x09b79f8d /* TouchArea_CameraBtn/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(Activate_TouchAreaCameraBtn, 0x42016C21); return true; }
#endif
#ifdef Activate_LayerPrevious
    if ((message.GetView() == ::Courier::ViewId("AppHmi_CameraApp#Gadget_Cam_Cabin_Non_Navi#CameraHomeScreen_Cabin_Non_Navi")) && (message.GetSender() == ::Courier::Identifier(0xf8a04344 /* Layer_Previous/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(Activate_LayerPrevious, 0xB4AB0707); return true; }
#endif
#ifdef Activate_LayerNext
    if ((message.GetView() == ::Courier::ViewId("AppHmi_CameraApp#Gadget_Cam_Cabin_Non_Navi#CameraHomeScreen_Cabin_Non_Navi")) && (message.GetSender() == ::Courier::Identifier(0xeb10ff43 /* Layer_Next/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(Activate_LayerNext, 0xDDC5E282); return true; }
#endif
#ifdef Activate_IconCamera
    if ((message.GetView() == ::Courier::ViewId("AppHmi_CameraApp#Gadget_Cam_Cabin_Non_Navi#CameraHomeScreen_Cabin_Non_Navi")) && (message.GetSender() == ::Courier::Identifier(0x75fac239 /* Icon_Camera/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(Activate_IconCamera, 0x80B830FC); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_CameraApp_Gadget_Cam_Cabin_CameraHomeScreen_Cabin_TouchArea_CameraBtn_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_CameraApp#Gadget_Cam_Cabin#CameraHomeScreen_Cabin")) && (message.GetSender() == ::Courier::Identifier(0x09b79f8d /* TouchArea_CameraBtn/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_CameraApp_Gadget_Cam_Cabin_CameraHomeScreen_Cabin_TouchArea_CameraBtn_ButtonWidget_enRelease, 0x4F2FC399); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraCabinSourceSelection_Layer_TouchArea_Source_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_CameraApp#Scenes#C_CameraCabinSourceSelection")) && (message.GetSender() == ::Courier::Identifier(0xccdf81cf /* Layer_TouchArea_Source/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraCabinSourceSelection_Layer_TouchArea_Source_ButtonWidget_enRelease, 0x1559AA4D); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraCabinSourceSelection_Layer_TouchArea_Split2_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_CameraApp#Scenes#C_CameraCabinSourceSelection")) && (message.GetSender() == ::Courier::Identifier(0x25644367 /* Layer_TouchArea_Split2/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraCabinSourceSelection_Layer_TouchArea_Split2_ButtonWidget_enRelease, 0xB73EAAFB); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraCabinSourceSelection_Layer_TouchArea_Split_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_CameraApp#Scenes#C_CameraCabinSourceSelection")) && (message.GetSender() == ::Courier::Identifier(0xaf6a7420 /* Layer_TouchArea_Split/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraCabinSourceSelection_Layer_TouchArea_Split_ButtonWidget_enRelease, 0xED0A1467); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_CameraApp_Scenes_CameraSelection_list_Layer_TouchArea_Source_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_CameraApp#Scenes#CameraSelection_list")) && (message.GetSender() == ::Courier::Identifier(0xccdf81cf /* Layer_TouchArea_Source/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_CameraApp_Scenes_CameraSelection_list_Layer_TouchArea_Source_ButtonWidget_enRelease, 0xF3EB9450); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_CameraApp_Scenes_CameraSelection_list_Button_Text_Image_Icon_List_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_CameraApp#Scenes#CameraSelection_list")) && (message.GetSender() == ::Courier::Identifier(0x54b00eb7 /* Button_Text_Image_Icon_List/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_CameraApp_Scenes_CameraSelection_list_Button_Text_Image_Icon_List_ButtonWidget_enRelease, 0x19E6DE6D); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraSourceSelection_Layer_TouchArea_List_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_CameraApp#Scenes#C_CameraSourceSelection")) && (message.GetSender() == ::Courier::Identifier(0x2378efe1 /* Layer_TouchArea_List/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraSourceSelection_Layer_TouchArea_List_ButtonWidget_enRelease, 0x57F8E6C7); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraCabinSourceSelection_Layer_TouchArea_List_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_CameraApp#Scenes#C_CameraCabinSourceSelection")) && (message.GetSender() == ::Courier::Identifier(0x2378efe1 /* Layer_TouchArea_List/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraCabinSourceSelection_Layer_TouchArea_List_ButtonWidget_enRelease, 0x04EBB5A2); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraSourceSelection_Layer_TouchArea_RVC_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_CameraApp#Scenes#C_CameraSourceSelection")) && (message.GetSender() == ::Courier::Identifier(0x1a7349e6 /* Layer_TouchArea_RVC/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraSourceSelection_Layer_TouchArea_RVC_ButtonWidget_enRelease, 0xECC0C684); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraSourceSelection_Layer_TouchArea_Split_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_CameraApp#Scenes#C_CameraSourceSelection")) && (message.GetSender() == ::Courier::Identifier(0xaf6a7420 /* Layer_TouchArea_Split/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraSourceSelection_Layer_TouchArea_Split_ButtonWidget_enRelease, 0x3CCD978A); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraSourceSelection_Layer_TouchArea_Surveillance_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_CameraApp#Scenes#C_CameraSourceSelection")) && (message.GetSender() == ::Courier::Identifier(0x3f159dce /* Layer_TouchArea_Surveillance/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraSourceSelection_Layer_TouchArea_Surveillance_ButtonWidget_enRelease, 0x1C29750B); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraSourceSelection_Layer_TouchArea_Surround_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_CameraApp#Scenes#C_CameraSourceSelection")) && (message.GetSender() == ::Courier::Identifier(0xc8b9c7ff /* Layer_TouchArea_Surround/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraSourceSelection_Layer_TouchArea_Surround_ButtonWidget_enRelease, 0x30B50D83); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraSourceSelection_Layer_TouchArea_Source_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_CameraApp#Scenes#C_CameraSourceSelection")) && (message.GetSender() == ::Courier::Identifier(0xccdf81cf /* Layer_TouchArea_Source/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraSourceSelection_Layer_TouchArea_Source_ButtonWidget_enRelease, 0x8434EA52); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraStream_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_CameraApp#Scenes#C_CameraStream")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraStream_Layer_TouchArea_Back_ButtonWidget_enRelease, 0xE30D0AA7); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_CameraApp_CameraSystemPopups_C_CameraStream_CAN_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_CameraApp#CameraSystemPopups#C_CameraStream_CAN")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_CameraApp_CameraSystemPopups_C_CameraStream_CAN_Layer_TouchArea_Back_ButtonWidget_enRelease, 0xBC28716A); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraStream_Layer_TouchArea_Camera_1_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_CameraApp#Scenes#C_CameraStream")) && (message.GetSender() == ::Courier::Identifier(0xbe390577 /* Layer_TouchArea_Camera_1/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraStream_Layer_TouchArea_Camera_1_ButtonWidget_enRelease, 0x74B62F56); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraStream_Layer_TouchArea_Camera_2_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_CameraApp#Scenes#C_CameraStream")) && (message.GetSender() == ::Courier::Identifier(0xf4535cfb /* Layer_TouchArea_Camera_2/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraStream_Layer_TouchArea_Camera_2_ButtonWidget_enRelease, 0x7BCD043A); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraStream_Layer_TouchArea_Camera_3_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_CameraApp#Scenes#C_CameraStream")) && (message.GetSender() == ::Courier::Identifier(0x534d4772 /* Layer_TouchArea_Camera_3/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraStream_Layer_TouchArea_Camera_3_ButtonWidget_enRelease, 0x1A683BDA); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraStream_Layer_TouchArea_Camera_4_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_CameraApp#Scenes#C_CameraStream")) && (message.GetSender() == ::Courier::Identifier(0xcf2c546d /* Layer_TouchArea_Camera_4/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraStream_Layer_TouchArea_Camera_4_ButtonWidget_enRelease, 0xFB134A97); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraSplitScene_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_CameraApp#Scenes#C_CameraSplitScene")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraSplitScene_Layer_TouchArea_Back_ButtonWidget_enRelease, 0xEF620889); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraSplitScene_SplitViewRight_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_CameraApp#Scenes#C_CameraSplitScene")) && (message.GetSender() == ::Courier::Identifier(0xc9394346 /* SplitViewRight/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraSplitScene_SplitViewRight_ButtonWidget_enRelease, 0xAFB15D6B); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraSplitScene_SplitViewLeft_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_CameraApp#Scenes#C_CameraSplitScene")) && (message.GetSender() == ::Courier::Identifier(0xade87124 /* SplitViewLeft/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraSplitScene_SplitViewLeft_ButtonWidget_enRelease, 0xCF87529D); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraFullSplit_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_CameraApp#Scenes#C_CameraFullSplit")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraFullSplit_Layer_TouchArea_Back_ButtonWidget_enRelease, 0xADD8A985); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraStream_Button_Toggle_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_CameraApp#Scenes#C_CameraStream")) && (message.GetSender() == ::Courier::Identifier(0x079aedb9 /* Button_Toggle/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraStream_Button_Toggle_ButtonWidget_enRelease, 0xFA907938); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraCabinSourceSelection_Layer_TouchArea_Door_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_CameraApp#Scenes#C_CameraCabinSourceSelection")) && (message.GetSender() == ::Courier::Identifier(0x39ac2037 /* Layer_TouchArea_Door/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraCabinSourceSelection_Layer_TouchArea_Door_ButtonWidget_enRelease, 0xB34332BD); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraCabinSourceSelection_Layer_TouchArea_Surveillance_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_CameraApp#Scenes#C_CameraCabinSourceSelection")) && (message.GetSender() == ::Courier::Identifier(0x3f159dce /* Layer_TouchArea_Surveillance/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraCabinSourceSelection_Layer_TouchArea_Surveillance_ButtonWidget_enRelease, 0xCAF7C4EB); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraCabinSourceSelection_Layer_TouchArea_Surroud_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_CameraApp#Scenes#C_CameraCabinSourceSelection")) && (message.GetSender() == ::Courier::Identifier(0xae386819 /* Layer_TouchArea_Surroud/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraCabinSourceSelection_Layer_TouchArea_Surroud_ButtonWidget_enRelease, 0x27979512); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraCabinSourceSelection_Layer_TouchArea_RVC_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_CameraApp#Scenes#C_CameraCabinSourceSelection")) && (message.GetSender() == ::Courier::Identifier(0x1a7349e6 /* Layer_TouchArea_RVC/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraCabinSourceSelection_Layer_TouchArea_RVC_ButtonWidget_enRelease, 0xED1EAB12); return true; }
#endif
#ifdef OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraCabinSourceSelection_Layer_TouchArea_Scenic_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("AppHmi_CameraApp#Scenes#C_CameraCabinSourceSelection")) && (message.GetSender() == ::Courier::Identifier(0x9271a940 /* Layer_TouchArea_Scenic/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraCabinSourceSelection_Layer_TouchArea_Scenic_ButtonWidget_enRelease, 0x85BAD1E0); return true; }
#endif
#ifdef Activate_TextCabin
    if ((message.GetView() == ::Courier::ViewId("AppHmi_CameraApp#Gadget_Cam_Cabin_Non_Navi#CameraHomeScreen_Cabin_Non_Navi")) && (message.GetSender() == ::Courier::Identifier(0x03b41e9f /* Text_Cabin/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(Activate_TextCabin, 0xE3C1BA53); return true; }
#endif
#ifdef Activate_TouchAreaMixedSource
    if ((message.GetView() == ::Courier::ViewId("AppHmi_CameraApp#Gadget_Cam_Cabin_Non_Navi#CameraHomeScreen_Cabin_Non_Navi")) && (message.GetSender() == ::Courier::Identifier(0x41c1db41 /* TouchArea_Mixed_Source/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(Activate_TouchAreaMixedSource, 0x42E553BD); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForButtonReactionMsg(AppHmi_CameraStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::ButtonReactionMsg const & message = static_cast< ::ButtonReactionMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_CameraStateMachineImpl::VS_Ret_Ok, AppHmi_CameraStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForShutdownMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnShutdownMsg, 0x756C0DF3);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForShutdownMsg(AppHmi_CameraStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_CameraStateMachineImpl::VS_Ret_Ok, AppHmi_CameraStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForCameraViewMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnCameraViewMsg, 0xE33FF080);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForCameraViewMsg(AppHmi_CameraStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_CameraStateMachineImpl::VS_Ret_Ok, AppHmi_CameraStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForCameraViewBlackScreenTransistionMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnCameraViewBlackScreenTransistionMsg, 0x9D17D366);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForCameraViewBlackScreenTransistionMsg(AppHmi_CameraStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_CameraStateMachineImpl::VS_Ret_Ok, AppHmi_CameraStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForCameraViewBlackScreenTileTransistionMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnCameraViewBlackScreenTileTransistionMsg, 0x3FFBD24E);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForCameraViewBlackScreenTileTransistionMsg(AppHmi_CameraStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_CameraStateMachineImpl::VS_Ret_Ok, AppHmi_CameraStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForCameraBlackScreenStopTriggerMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnCameraBlackScreenStopTriggerMsg, 0xF2387EA3);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForCameraBlackScreenStopTriggerMsg(AppHmi_CameraStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_CameraStateMachineImpl::VS_Ret_Ok, AppHmi_CameraStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForCameraSourceSelectionMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnCameraSourceSelectionMsg, 0x0C3EE628);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForCameraSourceSelectionMsg(AppHmi_CameraStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_CameraStateMachineImpl::VS_Ret_Ok, AppHmi_CameraStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForActivateCameraStreamMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnActivateCameraStreamMsg, 0x0DF3ED60);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActivateCameraStreamMsg(AppHmi_CameraStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_CameraStateMachineImpl::VS_Ret_Ok, AppHmi_CameraStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForCameraSourceSelectionCabinMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnCameraSourceSelectionCabinMsg, 0x561119F0);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForCameraSourceSelectionCabinMsg(AppHmi_CameraStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_CameraStateMachineImpl::VS_Ret_Ok, AppHmi_CameraStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForActivatePopupMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnActivatePopupMsg, 0x314025D5);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActivatePopupMsg(AppHmi_CameraStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_CameraStateMachineImpl::VS_Ret_Ok, AppHmi_CameraStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForActivatePopupNotConfigMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnActivatePopupNotConfigMsg, 0x22EDE715);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActivatePopupNotConfigMsg(AppHmi_CameraStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_CameraStateMachineImpl::VS_Ret_Ok, AppHmi_CameraStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForActivateCameraSplitStreamMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnActivateCameraSplitStreamMsg, 0x5DDB7D49);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActivateCameraSplitStreamMsg(AppHmi_CameraStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_CameraStateMachineImpl::VS_Ret_Ok, AppHmi_CameraStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForActivateCameraBlackScreenSplitStreamMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnActivateCameraBlackScreenSplitStreamMsg, 0x09DF28C0);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActivateCameraBlackScreenSplitStreamMsg(AppHmi_CameraStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_CameraStateMachineImpl::VS_Ret_Ok, AppHmi_CameraStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForActivateSplitFullScreenMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnActivateSplitFullScreenMsg, 0x6355876D);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActivateSplitFullScreenMsg(AppHmi_CameraStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_CameraStateMachineImpl::VS_Ret_Ok, AppHmi_CameraStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForActivateBlackScreenSplitScreenMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnActivateBlackScreenSplitScreenMsg, 0xECD7CF6D);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActivateBlackScreenSplitScreenMsg(AppHmi_CameraStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_CameraStateMachineImpl::VS_Ret_Ok, AppHmi_CameraStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForActivateSplitScreenMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnActivateSplitScreenMsg, 0xBBAC4F38);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActivateSplitScreenMsg(AppHmi_CameraStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_CameraStateMachineImpl::VS_Ret_Ok, AppHmi_CameraStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForCameraBackMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnCameraBackMsg, 0xA94E4B4E);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForCameraBackMsg(AppHmi_CameraStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_CameraStateMachineImpl::VS_Ret_Ok, AppHmi_CameraStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onEncoderStatusChanged_RIGHT_ENC
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onEncoderStatusChanged_RIGHT_ENC 0xffff
#pragma _REMINDER("Using dummy value symbol onEncoderStatusChanged_RIGHT_ENC ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onEncoderStatusChanged_RIGHT_ENC -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForEncoderStatusChangedUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::EncoderStatusChangedUpdMsg const & message = static_cast< ::EncoderStatusChangedUpdMsg const &>(aMessage);

#ifdef onEncoderStatusChanged_RIGHT_ENC
    if ((message.GetEncCode() == ENCCODE_RIGHT_ENCODER)) { eventId = CIT_EVENT_ID(onEncoderStatusChanged_RIGHT_ENC, 0x67E5D82B); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForEncoderStatusChangedUpdMsg(AppHmi_CameraStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::EncoderStatusChangedUpdMsg const & message = static_cast< ::EncoderStatusChangedUpdMsg const &>(aMessage);
#ifdef onEncoderStatusChanged_RIGHT_ENC
    if (eventId == onEncoderStatusChanged_RIGHT_ENC) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_CameraStateMachineImpl::VS_Ret_Ok, AppHmi_CameraStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetEncSteps()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onEncoderStatusChanged_RIGHT_ENC.EncSteps = message.GetEncSteps();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_CameraStateMachineImpl::VS_Ret_Ok, AppHmi_CameraStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForHKStatusChangedUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::HKStatusChangedUpdMsg const & message = static_cast< ::HKStatusChangedUpdMsg const &>(aMessage);

#ifdef onHKStatusChanged_HK_SELECT_UP
    if ((message.GetHKCode() == HARDKEYCODE_HK_SELECT) && (message.GetHKState() == HARDKEYSTATE_UP)) { eventId = CIT_EVENT_ID(onHKStatusChanged_HK_SELECT_UP, 0x263EAF7F); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForHKStatusChangedUpdMsg(AppHmi_CameraStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::HKStatusChangedUpdMsg const & message = static_cast< ::HKStatusChangedUpdMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_CameraStateMachineImpl::VS_Ret_Ok, AppHmi_CameraStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onPopupTimerExpiry
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onPopupTimerExpiry 0xffff
#pragma _REMINDER("Using dummy value symbol onPopupTimerExpiry ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onPopupTimerExpiry -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForExpiredPopupTimerResMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(onPopupTimerExpiry, 0xF3C96D17);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForExpiredPopupTimerResMsg(AppHmi_CameraStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::ExpiredPopupTimerResMsg const & message = static_cast< ::ExpiredPopupTimerResMsg const &>(aMessage);
#ifdef onPopupTimerExpiry
    if (eventId == onPopupTimerExpiry) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_CameraStateMachineImpl::VS_Ret_Ok, AppHmi_CameraStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetViewId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onPopupTimerExpiry.ViewId = message.GetViewId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_CameraStateMachineImpl::VS_Ret_Ok, AppHmi_CameraStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onActivateImageProviderRequest
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onActivateImageProviderRequest 0xffff
#pragma _REMINDER("Using dummy value symbol onActivateImageProviderRequest ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onActivateImageProviderRequest -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onDeactivateImageProviderRequest
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onDeactivateImageProviderRequest 0xffff
#pragma _REMINDER("Using dummy value symbol onDeactivateImageProviderRequest ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onDeactivateImageProviderRequest -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForActivateImageProviderReqMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::hmibase::gadget::ActivateImageProviderReqMsg const & message = static_cast< ::hmibase::gadget::ActivateImageProviderReqMsg const &>(aMessage);

#ifdef onActivateImageProviderRequest
    if ((message.GetActivate() == 1)) { eventId = CIT_EVENT_ID(onActivateImageProviderRequest, 0xDD62EA5B); return true; }
#endif
#ifdef onDeactivateImageProviderRequest
    if ((message.GetActivate() == 0)) { eventId = CIT_EVENT_ID(onDeactivateImageProviderRequest, 0x9FE98C1E); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActivateImageProviderReqMsg(AppHmi_CameraStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::hmibase::gadget::ActivateImageProviderReqMsg const & message = static_cast< ::hmibase::gadget::ActivateImageProviderReqMsg const &>(aMessage);
#ifdef onActivateImageProviderRequest
    if (eventId == onActivateImageProviderRequest) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_CameraStateMachineImpl::VS_Ret_Ok, AppHmi_CameraStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetInstanceId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onActivateImageProviderRequest.InstanceId = message.GetInstanceId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onDeactivateImageProviderRequest
    if (eventId == onDeactivateImageProviderRequest) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_CameraStateMachineImpl::VS_Ret_Ok, AppHmi_CameraStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetInstanceId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onDeactivateImageProviderRequest.InstanceId = message.GetInstanceId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_CameraStateMachineImpl::VS_Ret_Ok, AppHmi_CameraStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForHMISubStateChangedUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::HMISubStateChangedUpdMsg const & message = static_cast< ::HMISubStateChangedUpdMsg const &>(aMessage);

#ifdef onHMISubStateChanged_ON
    if ((message.GetSubState() == HMISTATE_SHOW_HMI)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_ON, 0x76CF2B88); return true; }
#endif
#ifdef onHMISubStateChanged_CLOCK
    if ((message.GetSubState() == HMISTATE_SHOW_CLOCK)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_CLOCK, 0xF96478DC); return true; }
#endif
#ifdef onHMISubStateChanged_OFF
    if ((message.GetSubState() == HMISTATE_SHOW_OFF)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_OFF, 0x776D7D8A); return true; }
#endif
#ifdef onHMISubStateChanged_STANDBY_RESTRICTED
    if ((message.GetSubState() == HMISTATE_STANDBY_RESTRICTED)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_STANDBY_RESTRICTED, 0xA15C3CEE); return true; }
#endif
#ifdef onHMISubStateChanged_STANDBY
    if ((message.GetSubState() == HMISTATE_STANDBY)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_STANDBY, 0x0D0F5602); return true; }
#endif
#ifdef onHMISubStateChanged_PHONE
    if ((message.GetSubState() == HMISTATE_PHONE)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_PHONE, 0xC8D83B8B); return true; }
#endif
#ifdef onHMISubStateChanged_NO_DISPLAY
    if ((message.GetSubState() == HMISTATE_SHOW_NO_DISPLAY)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_NO_DISPLAY, 0xE4658CFD); return true; }
#endif
#ifdef onHMISubStateChanged_SECURE
    if ((message.GetSubState() == HMISTATE_SECURE)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_SECURE, 0xAB89D7A8); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForHMISubStateChangedUpdMsg(AppHmi_CameraStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::HMISubStateChangedUpdMsg const & message = static_cast< ::HMISubStateChangedUpdMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_CameraStateMachineImpl::VS_Ret_Ok, AppHmi_CameraStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForApplicationStateUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::ApplicationStateUpdMsg const & message = static_cast< ::ApplicationStateUpdMsg const &>(aMessage);

#ifdef onAppStatusChanged_FOREGROUND
    if ((message.GetState() == hmibase::IN_FOREGROUND)) { eventId = CIT_EVENT_ID(onAppStatusChanged_FOREGROUND, 0xDE9448E3); return true; }
#endif
#ifdef onAppStatusChanged_BACKGROUND
    if ((message.GetState() == hmibase::IN_BACKGROUND)) { eventId = CIT_EVENT_ID(onAppStatusChanged_BACKGROUND, 0x6D1B3A68); return true; }
#endif
#ifdef onAppStatusPrepare_BACKGROUND
    if ((message.GetState() == hmibase::TO_BACKGROUND)) { eventId = CIT_EVENT_ID(onAppStatusPrepare_BACKGROUND, 0x4C8518AE); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForApplicationStateUpdMsg(AppHmi_CameraStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::ApplicationStateUpdMsg const & message = static_cast< ::ApplicationStateUpdMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_CameraStateMachineImpl::VS_Ret_Ok, AppHmi_CameraStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onSubSurfaceUpdMsgChanged_FOREGROUND
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onSubSurfaceUpdMsgChanged_FOREGROUND 0xffff
#pragma _REMINDER("Using dummy value symbol onSubSurfaceUpdMsgChanged_FOREGROUND ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onSubSurfaceUpdMsgChanged_FOREGROUND -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onSubSurfaceUpdMsgChanged_BACKGROUND
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onSubSurfaceUpdMsgChanged_BACKGROUND 0xffff
#pragma _REMINDER("Using dummy value symbol onSubSurfaceUpdMsgChanged_BACKGROUND ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onSubSurfaceUpdMsgChanged_BACKGROUND -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForSubSurfaceUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::SubSurfaceUpdMsg const & message = static_cast< ::SubSurfaceUpdMsg const &>(aMessage);

#ifdef onSubSurfaceUpdMsgChanged_FOREGROUND
    if ((message.GetState() == hmibase::IN_FOREGROUND)) { eventId = CIT_EVENT_ID(onSubSurfaceUpdMsgChanged_FOREGROUND, 0x9D4DF4FC); return true; }
#endif
#ifdef onSubSurfaceUpdMsgChanged_BACKGROUND
    if ((message.GetState() == hmibase::IN_BACKGROUND)) { eventId = CIT_EVENT_ID(onSubSurfaceUpdMsgChanged_BACKGROUND, 0x5790D8C1); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSubSurfaceUpdMsg(AppHmi_CameraStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::SubSurfaceUpdMsg const & message = static_cast< ::SubSurfaceUpdMsg const &>(aMessage);
#ifdef onSubSurfaceUpdMsgChanged_FOREGROUND
    if (eventId == onSubSurfaceUpdMsgChanged_FOREGROUND) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_CameraStateMachineImpl::VS_Ret_Ok, AppHmi_CameraStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetDisplayRegion(), message.GetDisplayID()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onSubSurfaceUpdMsgChanged_FOREGROUND.DisplayRegion = message.GetDisplayRegion();
        onClickParam.VSEPS_onSubSurfaceUpdMsgChanged_FOREGROUND.DisplayID = message.GetDisplayID();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onSubSurfaceUpdMsgChanged_BACKGROUND
    if (eventId == onSubSurfaceUpdMsgChanged_BACKGROUND) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_CameraStateMachineImpl::VS_Ret_Ok, AppHmi_CameraStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetDisplayRegion(), message.GetDisplayID()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onSubSurfaceUpdMsgChanged_BACKGROUND.DisplayRegion = message.GetDisplayRegion();
        onClickParam.VSEPS_onSubSurfaceUpdMsgChanged_BACKGROUND.DisplayID = message.GetDisplayID();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_CameraStateMachineImpl::VS_Ret_Ok, AppHmi_CameraStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForTransitionIndMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::Courier::TransitionIndMsg const & message = static_cast< ::Courier::TransitionIndMsg const &>(aMessage);

#ifdef OnNextLevelTransitionFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("NextLevelTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnNextLevelTransitionFinished, 0xE7DCE080); return true; }
#endif
#ifdef OnPreviousLevelTransitionFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("PreviousLevelTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnPreviousLevelTransitionFinished, 0x26C30D04); return true; }
#endif
#ifdef OnPageFlipBackFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("PageFlipBackTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnPageFlipBackFinished, 0x74F534EE); return true; }
#endif
#ifdef OnPageFlipFrontFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("PageFlipFrontTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnPageFlipFrontFinished, 0x437D9EFE); return true; }
#endif
#ifdef OnZoomInFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("ZoomInTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnZoomInFinished, 0xFBEEA58F); return true; }
#endif
#ifdef OnZoomOutFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("ZoomOutTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnZoomOutFinished, 0xF84B3BD1); return true; }
#endif
#ifdef OnFadeAnimationFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("FadeTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnFadeAnimationFinished, 0xE9A6D56C); return true; }
#endif
#ifdef OnDualViewLeftTransitionFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("DualViewLeftTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnDualViewLeftTransitionFinished, 0x403A65A4); return true; }
#endif
#ifdef OnDualViewRightTransitionFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("DualViewRightTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnDualViewRightTransitionFinished, 0x50B4DCCA); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForTransitionIndMsg(AppHmi_CameraStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::Courier::TransitionIndMsg const & message = static_cast< ::Courier::TransitionIndMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_CameraStateMachineImpl::VS_Ret_Ok, AppHmi_CameraStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
struct EventMapping
{
    ::FeatStd::UInt32 mHashId;
    bool (*mEventCallHandler)(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId);
};

struct EventDeductionMapping
{
    ::FeatStd::UInt32 mHashId;
    ::Cit::DeductResult::Enum (*mEventCallHandler)(AppHmi_CameraStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId);
};

static ::FeatStd::Int EventMappingCmp(::FeatStd::UInt32 hash, const EventMapping& em)
{
    return (hash == em.mHashId) ? 0 : ((hash < em.mHashId) ? -1 : 1);
}

static ::FeatStd::Int EventDeductionMappingCmp(::FeatStd::UInt32 hash, const EventDeductionMapping& em)
{
    return (hash == em.mHashId) ? 0 : ((hash < em.mHashId) ? -1 : 1);
}

bool AppHmi_CameraStateMachineImpl::HandleEventMapping(::Courier::Message const & message, ::FeatStd::UInt32& eventId) const
{
    static EventMapping events[26] = {
        { 0x04B8AFB9, HandleEventMappingForHKStatusChangedUpdMsg },
        { 0x10D474FD, HandleEventMappingForActivatePopupNotConfigMsg },
        { 0x16CC8B3F, HandleEventMappingForCameraBlackScreenStopTriggerMsg },
        { 0x1F2D50AA, HandleEventMappingForActivateSplitFullScreenMsg },
        { 0x2620CAB2, HandleEventMappingForActivateCameraBlackScreenSplitStreamMsg },
        { 0x27888B1E, HandleEventMappingForActivateCameraStreamMsg },
        { 0x3824FE1D, HandleEventMappingForApplicationStateUpdMsg },
        { 0x4202C8DD, HandleEventMappingForActivatePopupMsg },
        { 0x45DD8BFD, HandleEventMappingForCameraViewBlackScreenTransistionMsg },
        { 0x461D8FCC, HandleEventMappingForCameraSourceSelectionMsg },
        { 0x4A69141E, HandleEventMappingForHMISubStateChangedUpdMsg },
        { 0x4FF79763, HandleEventMappingForEncoderStatusChangedUpdMsg },
        { 0x66318734, HandleEventMappingForActivateBlackScreenSplitScreenMsg },
        { 0x69FAC6F1, HandleEventMappingForSubSurfaceUpdMsg },
        { 0x6AE0FD3C, HandleEventMappingForButtonReactionMsg },
        { 0x6AEFB684, HandleEventMappingForActivateCameraSplitStreamMsg },
        { 0x8AE765F1, HandleEventMappingForCameraViewMsg },
        { 0xA60CB9F4, HandleEventMappingForShutdownMsg },
        { 0xA8C64B72, HandleEventMappingForCameraViewBlackScreenTileTransistionMsg },
        { 0xAE3CAAA7, HandleEventMappingForExpiredPopupTimerResMsg },
        { 0xC613E40C, HandleEventMappingForActivateImageProviderReqMsg },
        { 0xC7327D7F, HandleEventMappingForCameraBackMsg },
        { 0xC7B455FB, HandleEventMappingForTransitionIndMsg },
        { 0xCFE51011, HandleEventMappingForActivateSplitScreenMsg },
        { 0xD9D9C6A2, HandleEventMappingForCameraSourceSelectionCabinMsg },
        { 0xE2F61D55, HandleEventMappingForSurfaceStateChangedUpdMsg },
    };
    ::FeatStd::UInt32 hashId = message.GetId();
    const EventMapping* eventEntry = ::Courier::BinarySearch(hashId, events, 26, &EventMappingCmp);
    if (eventEntry && (hashId == eventEntry->mHashId)) {
        return eventEntry->mEventCallHandler(message, eventId);
    }
    return false;
}

// ------------------------------------------------------------------------
::Cit::DeductResult::Enum AppHmi_CameraStateMachineImpl::DeductEvent(::Courier::Message const & aMessage, ::FeatStd::UInt32 eventId)
{
    ::Cit::DeductResult::Enum deductResult = Cit::DeductResult::DeductOk;
    static EventDeductionMapping events[26] = {
        { 0x04B8AFB9, HandleEventDeductionForHKStatusChangedUpdMsg },
        { 0x10D474FD, HandleEventDeductionForActivatePopupNotConfigMsg },
        { 0x16CC8B3F, HandleEventDeductionForCameraBlackScreenStopTriggerMsg },
        { 0x1F2D50AA, HandleEventDeductionForActivateSplitFullScreenMsg },
        { 0x2620CAB2, HandleEventDeductionForActivateCameraBlackScreenSplitStreamMsg },
        { 0x27888B1E, HandleEventDeductionForActivateCameraStreamMsg },
        { 0x3824FE1D, HandleEventDeductionForApplicationStateUpdMsg },
        { 0x4202C8DD, HandleEventDeductionForActivatePopupMsg },
        { 0x45DD8BFD, HandleEventDeductionForCameraViewBlackScreenTransistionMsg },
        { 0x461D8FCC, HandleEventDeductionForCameraSourceSelectionMsg },
        { 0x4A69141E, HandleEventDeductionForHMISubStateChangedUpdMsg },
        { 0x4FF79763, HandleEventDeductionForEncoderStatusChangedUpdMsg },
        { 0x66318734, HandleEventDeductionForActivateBlackScreenSplitScreenMsg },
        { 0x69FAC6F1, HandleEventDeductionForSubSurfaceUpdMsg },
        { 0x6AE0FD3C, HandleEventDeductionForButtonReactionMsg },
        { 0x6AEFB684, HandleEventDeductionForActivateCameraSplitStreamMsg },
        { 0x8AE765F1, HandleEventDeductionForCameraViewMsg },
        { 0xA60CB9F4, HandleEventDeductionForShutdownMsg },
        { 0xA8C64B72, HandleEventDeductionForCameraViewBlackScreenTileTransistionMsg },
        { 0xAE3CAAA7, HandleEventDeductionForExpiredPopupTimerResMsg },
        { 0xC613E40C, HandleEventDeductionForActivateImageProviderReqMsg },
        { 0xC7327D7F, HandleEventDeductionForCameraBackMsg },
        { 0xC7B455FB, HandleEventDeductionForTransitionIndMsg },
        { 0xCFE51011, HandleEventDeductionForActivateSplitScreenMsg },
        { 0xD9D9C6A2, HandleEventDeductionForCameraSourceSelectionCabinMsg },
        { 0xE2F61D55, HandleEventDeductionForSurfaceStateChangedUpdMsg },
    };
    ::FeatStd::UInt32 hashId = aMessage.GetId();
    const EventDeductionMapping* eventEntry = ::Courier::BinarySearch(hashId, events, 26, &EventDeductionMappingCmp);
    if (eventEntry && (hashId == eventEntry->mHashId)) {
        deductResult = eventEntry->mEventCallHandler(this, aMessage, eventId);
    }
    else {
        typedef Cit::Internal::VSDeductHelper<VS_Ret_Ok, AppHmi_CameraStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
        return VSDeductHelper::ProcessOutput(*this, (*this.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
        return VSDeductHelper::ProcessOutput(*this, (*this.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
    }
    return deductResult;
}

// ------------------------------------------------------------------------
bool AppHmi_CameraStateMachineImpl::HandleDataBindingEventMapping(::Courier::AbstractDataItemMsg const & /* message */, ::FeatStd::UInt32 & /* eventId */) const
{
    return false;
}

#ifdef CIT_SIMULATION
struct EventNameMapping
{
    ::FeatStd::UInt32 mEventId;
    const ::FeatStd::Char* mEventName;
    void (*mGetEventArguments)(::Courier::Message const & message, Json::Value& eventArguments);
};

static ::FeatStd::Int EventNameMappingCmp(::FeatStd::UInt32 eventId, const EventNameMapping& em)
{
    return (eventId == em.mEventId) ? 0 : ((eventId < em.mEventId) ? -1 : 1);
}

static void GetEventArgumentsForonCenterPopupSurfaceVisible(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonTopPopupSurfaceInvisible(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonSubSurfaceUpdMsgChanged_BACKGROUND(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SubSurfaceUpdMsg const & message = static_cast< ::SubSurfaceUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::Int)message.GetDisplayRegion();
    eventArguments[(::Json::Value::UInt)1] = (::Json::Value::UInt)message.GetDisplayID();
}

static void GetEventArgumentsForonEncoderStatusChanged_RIGHT_ENC(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::EncoderStatusChangedUpdMsg const & message = static_cast< ::EncoderStatusChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::Int)message.GetEncSteps();
}

static void GetEventArgumentsForonPopupInvisible(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonTopPopupSurfaceUnqueued(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonTopPopupSurfaceVisible(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonCenterPopupSurfaceInvisible(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonSubSurfaceUpdMsgChanged_FOREGROUND(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SubSurfaceUpdMsg const & message = static_cast< ::SubSurfaceUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::Int)message.GetDisplayRegion();
    eventArguments[(::Json::Value::UInt)1] = (::Json::Value::UInt)message.GetDisplayID();
}

static void GetEventArgumentsForonDeactivateImageProviderRequest(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::hmibase::gadget::ActivateImageProviderReqMsg const & message = static_cast< ::hmibase::gadget::ActivateImageProviderReqMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetInstanceId();
}

static void GetEventArgumentsForonCenterPopupSurfaceUnqueued(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonTopPopupSurfaceQueued(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonPopupVisible(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonPopupQueued(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonPopupUnqueued(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonActivateImageProviderRequest(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::hmibase::gadget::ActivateImageProviderReqMsg const & message = static_cast< ::hmibase::gadget::ActivateImageProviderReqMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetInstanceId();
}

static void GetEventArgumentsForonPopupTimerExpiry(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::ExpiredPopupTimerResMsg const & message = static_cast< ::ExpiredPopupTimerResMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId();
}

static void GetEventArgumentsForonCenterPopupSurfaceQueued(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

const ::FeatStd::Char* AppHmi_CameraStateMachineImpl::GetEventName(::FeatStd::UInt32 eventId, ::Courier::Message const & message, Json::Value& eventArguments)
{
    static EventNameMapping events[111] = {
        { 0x00834BAD, "OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraCabinView_Layer_TouchArea_CAM4_ButtonWidget_enRelease", 0 },
        { 0x04EBB5A2, "OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraCabinSourceSelection_Layer_TouchArea_List_ButtonWidget_enRelease", 0 },
        { 0x09DF28C0, "OnActivateCameraBlackScreenSplitStreamMsg", 0 },
        { 0x0C3EE628, "OnCameraSourceSelectionMsg", 0 },
        { 0x0CB8E387, "OnButtonReactionMsg_AppHmi_CameraApp_CameraSystemPopups_Camera_Not_configured_Button_Exit_ButtonWidget_enRelease", 0 },
        { 0x0D0F5602, "onHMISubStateChanged_STANDBY", 0 },
        { 0x0DF3ED60, "OnActivateCameraStreamMsg", 0 },
        { 0x1559AA4D, "OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraCabinSourceSelection_Layer_TouchArea_Source_ButtonWidget_enRelease", 0 },
        { 0x19E6DE6D, "OnButtonReactionMsg_AppHmi_CameraApp_Scenes_CameraSelection_list_Button_Text_Image_Icon_List_ButtonWidget_enRelease", 0 },
        { 0x1A683BDA, "OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraStream_Layer_TouchArea_Camera_3_ButtonWidget_enRelease", 0 },
        { 0x1C29750B, "OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraSourceSelection_Layer_TouchArea_Surveillance_ButtonWidget_enRelease", 0 },
        { 0x1E6644A7, "OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraCabinView_Layer_TouchArea_CAM3_ButtonWidget_enRelease", 0 },
        { 0x22EDE715, "OnActivatePopupNotConfigMsg", 0 },
        { 0x23B97E51, "onCenterPopupSurfaceVisible", GetEventArgumentsForonCenterPopupSurfaceVisible },
        { 0x25D2B9F4, "OnButtonReactionMsg_AppHmi_CameraApp_Gadget_Cam_CAM_GADGET_Button_Text_Image_Icon_ButtonWidget_enRelease", 0 },
        { 0x263EAF7F, "onHKStatusChanged_HK_SELECT_UP", 0 },
        { 0x26C30D04, "OnPreviousLevelTransitionFinished", 0 },
        { 0x27979512, "OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraCabinSourceSelection_Layer_TouchArea_Surroud_ButtonWidget_enRelease", 0 },
        { 0x30B50D83, "OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraSourceSelection_Layer_TouchArea_Surround_ButtonWidget_enRelease", 0 },
        { 0x314025D5, "OnActivatePopupMsg", 0 },
        { 0x325FCDC7, "Activate_ButtonTextImageIcon", 0 },
        { 0x3598CF84, "onTopPopupSurfaceInvisible", GetEventArgumentsForonTopPopupSurfaceInvisible },
        { 0x3CCD978A, "OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraSourceSelection_Layer_TouchArea_Split_ButtonWidget_enRelease", 0 },
        { 0x3FF91C29, "OnButtonReactionMsg_AppHmi_CameraApp_Gadget_Cam_CAM_GADGET_Camera_SourceSelection_ButtonWidget_enRelease", 0 },
        { 0x3FFBD24E, "OnCameraViewBlackScreenTileTransistionMsg", 0 },
        { 0x403A65A4, "OnDualViewLeftTransitionFinished", 0 },
        { 0x42016C21, "Activate_TouchAreaCameraBtn", 0 },
        { 0x42E553BD, "Activate_TouchAreaMixedSource", 0 },
        { 0x437D9EFE, "OnPageFlipFrontFinished", 0 },
        { 0x4C8518AE, "onAppStatusPrepare_BACKGROUND", 0 },
        { 0x4F2FC399, "OnButtonReactionMsg_AppHmi_CameraApp_Gadget_Cam_Cabin_CameraHomeScreen_Cabin_TouchArea_CameraBtn_ButtonWidget_enRelease", 0 },
        { 0x50B4DCCA, "OnDualViewRightTransitionFinished", 0 },
        { 0x561119F0, "OnCameraSourceSelectionCabinMsg", 0 },
        { 0x5790D8C1, "onSubSurfaceUpdMsgChanged_BACKGROUND", GetEventArgumentsForonSubSurfaceUpdMsgChanged_BACKGROUND },
        { 0x57F8E6C7, "OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraSourceSelection_Layer_TouchArea_List_ButtonWidget_enRelease", 0 },
        { 0x5D807F69, "OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraCabinView_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0x5DDB7D49, "OnActivateCameraSplitStreamMsg", 0 },
        { 0x6355876D, "OnActivateSplitFullScreenMsg", 0 },
        { 0x67E5D82B, "onEncoderStatusChanged_RIGHT_ENC", GetEventArgumentsForonEncoderStatusChanged_RIGHT_ENC },
        { 0x6C1CD62F, "onPopupInvisible", GetEventArgumentsForonPopupInvisible },
        { 0x6D1B3A68, "onAppStatusChanged_BACKGROUND", 0 },
        { 0x74B62F56, "OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraStream_Layer_TouchArea_Camera_1_ButtonWidget_enRelease", 0 },
        { 0x74F534EE, "OnPageFlipBackFinished", 0 },
        { 0x756C0DF3, "OnShutdownMsg", 0 },
        { 0x76CF2B88, "onHMISubStateChanged_ON", 0 },
        { 0x776D7D8A, "onHMISubStateChanged_OFF", 0 },
        { 0x7BCD043A, "OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraStream_Layer_TouchArea_Camera_2_ButtonWidget_enRelease", 0 },
        { 0x80B830FC, "Activate_IconCamera", 0 },
        { 0x8434EA52, "OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraSourceSelection_Layer_TouchArea_Source_ButtonWidget_enRelease", 0 },
        { 0x85BAD1E0, "OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraCabinSourceSelection_Layer_TouchArea_Scenic_ButtonWidget_enRelease", 0 },
        { 0x8A3E4D54, "Activate_CameraSourceSelection", 0 },
        { 0x8BBC95F8, "OnButtonReactionMsg_AppHmi_CameraApp_Gadget_Cam_Cabin_CameraHomeScreen_Cabin_Text_Cabin_ButtonWidget_enRelease", 0 },
        { 0x8CF43B73, "OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraSourceSelection_Layer_TouchArea_Door_ButtonWidget_enRelease", 0 },
        { 0x8EBADFFC, "OnButtonReactionMsg_AppHmi_CameraApp_Gadget_Cam_Cabin_CameraHomeScreen_Cabin_Layer_Next_ButtonWidget_enRelease", 0 },
        { 0x912024BE, "onTopPopupSurfaceUnqueued", GetEventArgumentsForonTopPopupSurfaceUnqueued },
        { 0x984F8ED8, "onTopPopupSurfaceVisible", GetEventArgumentsForonTopPopupSurfaceVisible },
        { 0x9BDB722F, "onCenterPopupSurfaceInvisible", GetEventArgumentsForonCenterPopupSurfaceInvisible },
        { 0x9D17D366, "OnCameraViewBlackScreenTransistionMsg", 0 },
        { 0x9D4DF4FC, "onSubSurfaceUpdMsgChanged_FOREGROUND", GetEventArgumentsForonSubSurfaceUpdMsgChanged_FOREGROUND },
        { 0x9FE98C1E, "onDeactivateImageProviderRequest", GetEventArgumentsForonDeactivateImageProviderRequest },
        { 0xA15C3CEE, "onHMISubStateChanged_STANDBY_RESTRICTED", 0 },
        { 0xA94E4B4E, "OnCameraBackMsg", 0 },
        { 0xA9542014, "OnButtonReactionMsg_AppHmi_CameraApp_Gadget_Cam_CAM_GADGET_Camera_Tile_Cockpit_ButtonWidget_enRelease", 0 },
        { 0xAA79C7DD, "onCenterPopupSurfaceUnqueued", GetEventArgumentsForonCenterPopupSurfaceUnqueued },
        { 0xAAA3A77F, "OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraCabinView_Layer_TouchArea_CAM1_ButtonWidget_enRelease", 0 },
        { 0xAB89D7A8, "onHMISubStateChanged_SECURE", 0 },
        { 0xAC90E0D0, "OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraCabinView_Layer_TouchArea_CAM2_ButtonWidget_enRelease", 0 },
        { 0xADD8A985, "OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraFullSplit_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0xAFB15D6B, "OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraSplitScene_SplitViewRight_ButtonWidget_enRelease", 0 },
        { 0xB34332BD, "OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraCabinSourceSelection_Layer_TouchArea_Door_ButtonWidget_enRelease", 0 },
        { 0xB4AB0707, "Activate_LayerPrevious", 0 },
        { 0xB630DDBD, "onTopPopupSurfaceQueued", GetEventArgumentsForonTopPopupSurfaceQueued },
        { 0xB73EAAFB, "OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraCabinSourceSelection_Layer_TouchArea_Split2_ButtonWidget_enRelease", 0 },
        { 0xB78D7AE0, "onPopupVisible", GetEventArgumentsForonPopupVisible },
        { 0xBBAC4F38, "OnActivateSplitScreenMsg", 0 },
        { 0xBBE6896C, "onPopupQueued", GetEventArgumentsForonPopupQueued },
        { 0xBC28716A, "OnButtonReactionMsg_AppHmi_CameraApp_CameraSystemPopups_C_CameraStream_CAN_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0xC206C224, "OnButtonReactionMsg_AppHmi_CameraApp_Gadget_Cam_Cabin_CameraHomeScreen_Cabin_TouchArea_Mixed_Source_ButtonWidget_enRelease", 0 },
        { 0xC38DEC37, "OnButtonReactionMsg_AppHmi_CameraApp_Gadget_Cam_Cabin_CameraHomeScreen_Cabin_Icon_Camera_ButtonWidget_enRelease", 0 },
        { 0xC497E808, "OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraRearView_Button_Text_Ignore_Button_enRelease", 0 },
        { 0xC8D83B8B, "onHMISubStateChanged_PHONE", 0 },
        { 0xCAF7C4EB, "OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraCabinSourceSelection_Layer_TouchArea_Surveillance_ButtonWidget_enRelease", 0 },
        { 0xCF87529D, "OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraSplitScene_SplitViewLeft_ButtonWidget_enRelease", 0 },
        { 0xDB0D29F4, "onPopupUnqueued", GetEventArgumentsForonPopupUnqueued },
        { 0xDD62EA5B, "onActivateImageProviderRequest", GetEventArgumentsForonActivateImageProviderRequest },
        { 0xDDC5E282, "Activate_LayerNext", 0 },
        { 0xDE9448E3, "onAppStatusChanged_FOREGROUND", 0 },
        { 0xE30D0AA7, "OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraStream_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0xE33FF080, "OnCameraViewMsg", 0 },
        { 0xE3C1BA53, "Activate_TextCabin", 0 },
        { 0xE4658CFD, "onHMISubStateChanged_NO_DISPLAY", 0 },
        { 0xE7DCE080, "OnNextLevelTransitionFinished", 0 },
        { 0xE9A6D56C, "OnFadeAnimationFinished", 0 },
        { 0xEB3B7AE2, "OnButtonReactionMsg_AppHmi_CameraApp_CameraSystemPopups_Camera_Warning_Popup_Button_Cancel_ButtonWidget_enRelease", 0 },
        { 0xECC0C684, "OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraSourceSelection_Layer_TouchArea_RVC_ButtonWidget_enRelease", 0 },
        { 0xECD7CF6D, "OnActivateBlackScreenSplitScreenMsg", 0 },
        { 0xED0A1467, "OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraCabinSourceSelection_Layer_TouchArea_Split_ButtonWidget_enRelease", 0 },
        { 0xED1EAB12, "OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraCabinSourceSelection_Layer_TouchArea_RVC_ButtonWidget_enRelease", 0 },
        { 0xEF620889, "OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraSplitScene_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0xF2387EA3, "OnCameraBlackScreenStopTriggerMsg", 0 },
        { 0xF3C96D17, "onPopupTimerExpiry", GetEventArgumentsForonPopupTimerExpiry },
        { 0xF3EB9450, "OnButtonReactionMsg_AppHmi_CameraApp_Scenes_CameraSelection_list_Layer_TouchArea_Source_ButtonWidget_enRelease", 0 },
        { 0xF4554DBA, "Activate_CameraTileCockpit", 0 },
        { 0xF682EB9B, "OnButtonReactionMsg_AppHmi_CameraApp_Gadget_Cam_Cabin_CameraHomeScreen_Cabin_Layer_Previous_ButtonWidget_enRelease", 0 },
        { 0xF7884CE5, "OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraRearView_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0xF84B3BD1, "OnZoomOutFinished", 0 },
        { 0xF96478DC, "onHMISubStateChanged_CLOCK", 0 },
        { 0xFA907938, "OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraStream_Button_Toggle_ButtonWidget_enRelease", 0 },
        { 0xFB134A97, "OnButtonReactionMsg_AppHmi_CameraApp_Scenes_C_CameraStream_Layer_TouchArea_Camera_4_ButtonWidget_enRelease", 0 },
        { 0xFBEEA58F, "OnZoomInFinished", 0 },
        { 0xFC0D2293, "onCenterPopupSurfaceQueued", GetEventArgumentsForonCenterPopupSurfaceQueued },
    };
    const EventNameMapping* eventEntry = ::Courier::BinarySearch(eventId, events, 111, &EventNameMappingCmp);
    if (eventEntry && (eventId == eventEntry->mEventId)) {
        if (0 != eventEntry->mGetEventArguments) {
            eventEntry->mGetEventArguments(message, eventArguments);
        }
        return eventEntry->mEventName;
    }
    return 0;
}
#endif
// ------------------------------------------------------------------------
struct IdToNameMapping
{
    ::FeatStd::UInt32 mId;
    const ::FeatStd::Char* mName;
};

static ::FeatStd::Int IdToNameMappingCmp(::FeatStd::UInt32 id, const IdToNameMapping& nm)
{
    return (id == nm.mId) ? 0 : ((id < nm.mId) ? -1 : 1);
}

const ::FeatStd::Char * AppHmi_CameraStateMachineImpl::GetNameFromId(::FeatStd::UInt32 id)
{
    static IdToNameMapping names[20] = {
        { 0x0C69BDB6, "AppHmi_CameraApp#CameraSystemPopups#C_CameraStream_CAN" },
        { 0x133B8815, "AppHmi_CameraApp#CameraSystemPopups#Camera_Not_configured" },
        { 0x233BD9E8, "AppHmi_CameraApp#Scenes#C_CameraCabinSourceSelection" },
        { 0x2C00BB1D, "AppHmi_CameraApp#Gadget_Cam#CAM_GADGET" },
        { 0x3AD57135, "AppHmi_CameraApp#Gadget_Cam_Cabin_Non_Navi#CameraHomeScreen_Cabin_Non_Navi" },
        { 0x4555B096, "AppHmi_CameraApp#Scenes#C_CameraBlackScreenStreamforSplit" },
        { 0x531ACF2A, "AppHmi_CameraApp#CameraSystemPopups#Camera_Warning_Popup" },
        { 0x58E56C31, "AppHmi_CameraApp#Gadget_Cam_Non_Navi#CAM_GADGET_NON_NAVI" },
        { 0x62B56606, "AppHmi_CameraApp#Scenes#CameraSelection_list" },
        { 0x69FCA04C, "AppHmi_CameraApp#Gadget_Cam_Cabin#CameraHomeScreen_Cabin" },
        { 0x7055FB5D, "AppHmi_CameraApp" },
        { 0x779A7939, "AppHmi_CameraApp#Scenes#C_CameraSplitScene" },
        { 0x925C45C8, "AppHmi_CameraApp#CameraSystemPopups" },
        { 0xAE808E14, "AppHmi_CameraApp#Scenes#C_CameraSourceSelection" },
        { 0xBBE48721, "AppHmi_CameraApp#CameraSystemPopups#Camera_LoadingAnimation" },
        { 0xC436EF12, "AppHmi_CameraApp#Scenes#C_CameraBlackScreenStream" },
        { 0xE35CBF22, "AppHmi_CameraApp#Scenes#C_CameraFullSplit" },
        { 0xE592CF25, "AppHmi_CameraApp#Scenes#C_CameraStream" },
        { 0xE6394A86, "AppHmi_CameraApp#Scenes#C_CameraRearView" },
        { 0xF699858D, "AppHmi_CameraApp#Scenes#C_CameraCabinView" },
    };
    const IdToNameMapping *nameEntry = ::Courier::BinarySearch(id, names, 20, &IdToNameMappingCmp);
    if(nameEntry != 0 && id == nameEntry->mId) {
        return nameEntry->mName;
    }
    return "";
}

// ------------------------------------------------------------------------

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::Perform_Activate_Home_Source()
{
    Action_Perform_Activate_Home_Source();
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::CameraBackButton()
{
    Action_CameraBackButton();
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::Cabin_Source_Button()
{
    Action_Cabin_Source_Button();
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::Perform_Main_CamSrc_Select()
{
    Action_Perform_Main_CamSrc_Select();
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::Perform_Cockpit_Select()
{
    Action_Perform_Cockpit_Select();
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::Perform_Main_Cabin_CamSrc_Select()
{
    Action_Perform_Main_Cabin_CamSrc_Select();
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::Perform_cabin_from_home_Select()
{
    Action_Perform_cabin_from_home_Select();
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::Perform_Next_Camera()
{
    Action_Perform_Next_Camera();
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::Perform_Previous_Camera()
{
    Action_Perform_Previous_Camera();
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::Perform_Mixed_Source()
{
    Action_Perform_Mixed_Source();
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::VisiblityOfCameraButtons()
{
    Action_VisiblityOfCameraButtons();
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::CameraExitmsgRequest()
{
    Action_CameraExitmsgRequest();
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::CameraBlackScreenStartTimerRequest()
{
    Action_CameraBlackScreenStartTimerRequest();
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::CameraStopmsgRequest()
{
    Action_CameraStopmsgRequest();
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::CameraStartmsgRequest()
{
    Action_CameraStartmsgRequest();
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::CameraSplitStartmsgRequest()
{
    Action_CameraSplitStartmsgRequest();
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::CabinCameraExitmsgRequest()
{
    Action_CabinCameraExitmsgRequest();
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::SplitViewLeftCamMsgRequest()
{
    Action_SplitViewLeftCamMsgRequest();
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::SplitViewRightCamMsgRequest()
{
    Action_SplitViewRightCamMsgRequest();
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::Perform_Send_Context(::FeatStd::UInt16 aContextScene)
{
    Action_Perform_Send_Context(Courier::UInt16(aContextScene));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::Notify_Init_Finished()
{
    Action_Notify_Init_Finished();
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacChangeLanguageReq(::FeatStd::Int32 aLanguageId)
{
    Action_gacChangeLanguageReq(enLanguageId(aLanguageId));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacHideFocusInViewReq(::FeatStd::UInt32 aView)
{
    Action_gacHideFocusInViewReq(::Courier::ViewId(AppHmi_CameraStateMachineImpl::GetNameFromId(aView)));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::NextLevelTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_NextLevelTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::PreviousLevelTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_PreviousLevelTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::DualViewLeftTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_DualViewLeftTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::DualViewRightTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_DualViewRightTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::PageFlipBackTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_PageFlipBackTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::PageFlipFrontTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_PageFlipFrontTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::ZoomInTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView, ::FeatStd::Int8 aPos)
{
    Action_ZoomInTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView), Candera::UInt8(aPos));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::ZoomOutTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView, ::FeatStd::Int8 aPos)
{
    Action_ZoomOutTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView), Candera::UInt8(aPos));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::FadeTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_FadeTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacWaitAnimationStartReq()
{
    Action_gacWaitAnimationStartReq();
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::acFocusOnRightEncoderReqUpd(bool aIsFocusUsed)
{
    Action_acFocusOnRightEncoderReqUpd(bool(aIsFocusUsed));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::acSetGadgetSceenActiveStatus(bool aIsGadgetAtive)
{
    Action_acSetGadgetSceenActiveStatus(bool(aIsGadgetAtive));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::acHKNotificationMsg(::FeatStd::Int8 aHKCode, ::FeatStd::Int8 aHKState)
{
    Action_acHKNotificationMsg(Courier::UInt8(aHKCode), Courier::UInt8(aHKState));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::acPerform_CloseAllDropdowns()
{
    Action_acPerform_CloseAllDropdowns();
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::acPerform_CloseDropdown(::FeatStd::UInt32 aListId)
{
    Action_acPerform_CloseDropdown(::Courier::UInt32(aListId));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::acPerform_OpenDropdown(::FeatStd::UInt32 aListId)
{
    Action_acPerform_OpenDropdown(::Courier::UInt32(aListId));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::acPerform_ToggleDropdown(::FeatStd::UInt32 aListId)
{
    Action_acPerform_ToggleDropdown(::Courier::UInt32(aListId));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::acStartAppPopupTimer(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aTimeout)
{
    Action_acStartAppPopupTimer(Courier::UInt32(aViewId), Courier::UInt32(aTimeout));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::acStopAppPopupTimer(::FeatStd::UInt32 aViewId)
{
    Action_acStopAppPopupTimer(Courier::UInt32(aViewId));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::acPostBeep(::FeatStd::Int8 aBeepType)
{
    Action_acPostBeep(Courier::Int32(aBeepType));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacCheckToClosePopup(::FeatStd::UInt32 aPopupId)
{
    Action_gacCheckToClosePopup(Courier::UInt32(aPopupId));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::acRestartAppPopupTimer(::FeatStd::UInt32 aViewId)
{
    Action_acRestartAppPopupTimer(Courier::UInt32(aViewId));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacContextSwitchBackRes(::FeatStd::UInt32 aSwitchId)
{
    Action_gacContextSwitchBackRes(Courier::UInt32(aSwitchId));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacContextSwitchCompleteRes(::FeatStd::UInt32 aSwitchId)
{
    Action_gacContextSwitchCompleteRes(Courier::UInt32(aSwitchId));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacContextSwitchFailedRes(::FeatStd::UInt32 aSwitchId)
{
    Action_gacContextSwitchFailedRes(Courier::UInt32(aSwitchId));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacContextSwitchDoneRes(::FeatStd::UInt32 aSwitchId)
{
    Action_gacContextSwitchDoneRes(Courier::UInt32(aSwitchId));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacContextSwitchOutReq(::FeatStd::UInt32 aTargetContextId, ::FeatStd::UInt32 aSourceContextId, ::FeatStd::UInt32 aTargetAppId)
{
    Action_gacContextSwitchOutReq(Courier::UInt32(aTargetContextId), Courier::UInt32(aSourceContextId), Courier::UInt32(aTargetAppId));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacCurrentScreenDisplayReq()
{
    Action_gacCurrentScreenDisplayReq();
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacLaunchBarDisplayReq(bool aVisibility)
{
    Action_gacLaunchBarDisplayReq(bool(aVisibility));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacNavTBTSwipe()
{
    Action_gacNavTBTSwipe();
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacPerformListBtnRightEncoderChangeUpd(::FeatStd::Int8 aSteps, ::FeatStd::UInt32 aListId, ::FeatStd::UInt32 aRowId, ::FeatStd::UInt32 aColumnId)
{
    Action_gacPerformListBtnRightEncoderChangeUpd(Courier::Int8(aSteps), Courier::UInt32(aListId), Courier::UInt32(aRowId), Courier::UInt32(aColumnId));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacScrollListUp()
{
    Action_gacScrollListUp();
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacScrollListDown()
{
    Action_gacScrollListDown();
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacScrollPageUp()
{
    Action_gacScrollPageUp();
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacScrollPageDown()
{
    Action_gacScrollPageDown();
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacScrollListFocusUp(::FeatStd::UInt32 aListId)
{
    Action_gacScrollListFocusUp(Courier::UInt32(aListId));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacScrollListFocusDown(::FeatStd::UInt32 aListId)
{
    Action_gacScrollListFocusDown(Courier::UInt32(aListId));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacPerformListFocusLockDataResetUpd()
{
    Action_gacPerformListFocusLockDataResetUpd();
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacSetApplicationMode(::FeatStd::UInt32 aModeId)
{
    Action_gacSetApplicationMode(Courier::UInt32(aModeId));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacSpellerBbehaviorReq(bool aEnable)
{
    Action_gacSpellerBbehaviorReq(bool(aEnable));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacStatusBarDisplayReq(bool aVisibility, ::FeatStd::Int32 aHeaderType)
{
    Action_gacStatusBarDisplayReq(bool(aVisibility), Courier::Int32(aHeaderType));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacTBTRetriggerAcousticOutput()
{
    Action_gacTBTRetriggerAcousticOutput();
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacWaitAnimationStopReq()
{
    Action_gacWaitAnimationStopReq();
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacViewCreateReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewCreateReq(::Courier::ViewId(AppHmi_CameraStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacViewCreateAllReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewCreateAllReq(::Courier::ViewId(AppHmi_CameraStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacViewDestroyReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewDestroyReq(::Courier::ViewId(AppHmi_CameraStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacViewClearReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewClearReq(::Courier::ViewId(AppHmi_CameraStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacViewShowReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewShowReq(::Courier::ViewId(AppHmi_CameraStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacViewHideReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewHideReq(::Courier::ViewId(AppHmi_CameraStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacViewCreateWithoutLoadReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewCreateWithoutLoadReq(::Courier::ViewId(AppHmi_CameraStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacViewAsyncLoadReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewAsyncLoadReq(::Courier::ViewId(AppHmi_CameraStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacViewActivateWithoutRenderingReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewActivateWithoutRenderingReq(::Courier::ViewId(AppHmi_CameraStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacPopupCreateAndSBShowReq(::FeatStd::UInt32 aViewId)
{
    Action_gacPopupCreateAndSBShowReq(::Courier::ViewId(AppHmi_CameraStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacPopupCreateAndSBShowReqForMultiDisplay(::FeatStd::UInt32 aPopupDisplayID, ::FeatStd::UInt32 aViewId)
{
    Action_gacPopupCreateAndSBShowReqForMultiDisplay(Courier::UInt32(aPopupDisplayID), ::Courier::ViewId(AppHmi_CameraStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacPopupSBCloseReq(::FeatStd::UInt32 aViewId)
{
    Action_gacPopupSBCloseReq(::Courier::ViewId(AppHmi_CameraStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacPopupSBCloseReqForMultiDisplay(::FeatStd::UInt32 aPopupDisplayID, ::FeatStd::UInt32 aViewId)
{
    Action_gacPopupSBCloseReqForMultiDisplay(Courier::UInt32(aPopupDisplayID), ::Courier::ViewId(AppHmi_CameraStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacPopupRestartTimerReq(::FeatStd::UInt32 aViewId)
{
    Action_gacPopupRestartTimerReq(::Courier::ViewId(AppHmi_CameraStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacPopupRestartTimerReqForMultiDisplay(::FeatStd::UInt32 aPopupDisplayID, ::FeatStd::UInt32 aViewId)
{
    Action_gacPopupRestartTimerReqForMultiDisplay(Courier::UInt32(aPopupDisplayID), ::Courier::ViewId(AppHmi_CameraStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacViewCreateAndShowReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewCreateAndShowReq(::Courier::ViewId(AppHmi_CameraStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacViewHideAndDestroyReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewHideAndDestroyReq(::Courier::ViewId(AppHmi_CameraStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacSceneTransitionEnter(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aHint)
{
    Action_gacSceneTransitionEnter(::Courier::ViewId(AppHmi_CameraStateMachineImpl::GetNameFromId(aViewId)), Courier::UInt32(aHint));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacSceneTransitionLeave(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aHint)
{
    Action_gacSceneTransitionLeave(::Courier::ViewId(AppHmi_CameraStateMachineImpl::GetNameFromId(aViewId)), Courier::UInt32(aHint));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacDisplayStatusLineReq(::FeatStd::Int32 aDisplayRegionType)
{
    Action_gacDisplayStatusLineReq(Courier::Int32(aDisplayRegionType));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacHideStatusLineReq(::FeatStd::Int32 aDisplayRegionType)
{
    Action_gacHideStatusLineReq(Courier::Int32(aDisplayRegionType));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacDisplayFooterLineReq()
{
    Action_gacDisplayFooterLineReq();
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacHideFooterLineReq()
{
    Action_gacHideFooterLineReq();
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacDisplayStatusLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID)
{
    Action_gacDisplayStatusLineMultiDisplayReq(Courier::Int32(aDisplayRegionType), Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacHideStatusLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID)
{
    Action_gacHideStatusLineMultiDisplayReq(Courier::Int32(aDisplayRegionType), Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacDisplayFooterLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID)
{
    Action_gacDisplayFooterLineMultiDisplayReq(Courier::Int32(aDisplayRegionType), Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacHideFooterLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID)
{
    Action_gacHideFooterLineMultiDisplayReq(Courier::Int32(aDisplayRegionType), Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacRegisterForCloseOnTouchSession(::FeatStd::UInt32 aViewId)
{
    Action_gacRegisterForCloseOnTouchSession(::Courier::ViewId(AppHmi_CameraStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacDeregisterForCloseOnTouchSessionReq(::FeatStd::UInt32 aViewId)
{
    Action_gacDeregisterForCloseOnTouchSessionReq(::Courier::ViewId(AppHmi_CameraStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacPopupFilterPrioEnableReq(::FeatStd::UInt32 aPrio)
{
    Action_gacPopupFilterPrioEnableReq(Courier::UInt32(aPrio));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacPopupFilterAllEnableReq()
{
    Action_gacPopupFilterAllEnableReq();
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacPopupFilterDisableReq()
{
    Action_gacPopupFilterDisableReq();
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacProfileChange(::FeatStd::Int8 aProfile)
{
    Action_gacProfileChange(Courier::UInt32(aProfile));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacPopupFilterPrioEnableReqForDisplay(::FeatStd::UInt32 aPrio, ::FeatStd::UInt32 aDisplayID)
{
    Action_gacPopupFilterPrioEnableReqForDisplay(Courier::UInt32(aPrio), Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacPopupFilterAllEnableReqForDisplay(::FeatStd::UInt32 aDisplayID)
{
    Action_gacPopupFilterAllEnableReqForDisplay(Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacPopupFilterDisableReqForDisplay(::FeatStd::UInt32 aDisplayID)
{
    Action_gacPopupFilterDisableReqForDisplay(Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacStartSceneTransitionAnimation(::FeatStd::UInt32 aSourceView, ::FeatStd::UInt32 aDestinationView, ::FeatStd::UInt32 aUserData1, ::FeatStd::Int8 aUserData2)
{
    Action_gacStartSceneTransitionAnimation(::Courier::ViewId(AppHmi_CameraStateMachineImpl::GetNameFromId(aSourceView)), ::Courier::ViewId(AppHmi_CameraStateMachineImpl::GetNameFromId(aDestinationView)), Courier::UInt32(aUserData1), Courier::Int8(aUserData2));
}

// ------------------------------------------------------------------------
void AppHmi_CameraStateMachineImpl::gacDecrementActiveAnimationCount()
{
    Action_gacDecrementActiveAnimationCount();
}
#ifdef CIT_SIMULATION
struct ActionMapping
{
    ::FeatStd::UInt32 mHashId;
    bool (*mActionCallHandler)(const ::Json::Value& parameters, ::Json::Value &response);
};

static ::FeatStd::Int ActionMappingCmp(::FeatStd::UInt32 hash, const ActionMapping& am)
{
    return (hash == am.mHashId) ? 0 : ((hash < am.mHashId) ? -1 : 1);
}

bool AppHmi_CameraStateMachineImpl::CallAction(const ::FeatStd::Char* actionName, const ::Json::Value& parameters, ::Json::Value &response)
{
    static ActionMapping actions[104] = {
        { 0x0884F877, CallAction_gacScrollListUp },
        { 0x090A895B, CallAction_gacScrollListFocusDown },
        { 0x0A4C5DC9, CallAction_gacDisplayStatusLineMultiDisplayReq },
        { 0x0C279721, CallAction_gacDecrementActiveAnimationCount },
        { 0x11915CFE, CallAction_acStopAppPopupTimer },
        { 0x11A810C3, CallAction_Perform_Send_Context },
        { 0x14C1E66B, CallAction_CameraStopmsgRequest },
        { 0x15061065, CallAction_gacViewShowReq },
        { 0x17B29439, CallAction_Perform_Next_Camera },
        { 0x186A69F1, CallAction_gacWaitAnimationStopReq },
        { 0x187DA604, CallAction_acPerform_OpenDropdown },
        { 0x1BC6E0A9, CallAction_ZoomInTransition },
        { 0x21E3828E, CallAction_gacDisplayStatusLineReq },
        { 0x251DE22F, CallAction_gacContextSwitchCompleteRes },
        { 0x254E0D94, CallAction_gacViewHideReq },
        { 0x258104C2, CallAction_DualViewLeftTransition },
        { 0x264B8E81, CallAction_gacPopupRestartTimerReqForMultiDisplay },
        { 0x27CE647F, CallAction_gacScrollListFocusUp },
        { 0x29D14586, CallAction_gacDisplayFooterLineMultiDisplayReq },
        { 0x2A1E6CB2, CallAction_gacDeregisterForCloseOnTouchSessionReq },
        { 0x2AE288D8, CallAction_gacViewDestroyReq },
        { 0x30C8D840, CallAction_gacStartSceneTransitionAnimation },
        { 0x325BE13A, CallAction_gacViewCreateReq },
        { 0x334571BF, CallAction_acHKNotificationMsg },
        { 0x361BF922, CallAction_CabinCameraExitmsgRequest },
        { 0x3B0709E4, CallAction_CameraExitmsgRequest },
        { 0x3BB18A69, CallAction_gacPopupFilterAllEnableReq },
        { 0x3E4CE5A1, CallAction_gacContextSwitchDoneRes },
        { 0x3E7F9726, CallAction_gacSceneTransitionEnter },
        { 0x41201119, CallAction_acStartAppPopupTimer },
        { 0x48066286, CallAction_CameraSplitStartmsgRequest },
        { 0x510F3B63, CallAction_Perform_Cockpit_Select },
        { 0x52A5EF7A, CallAction_VisiblityOfCameraButtons },
        { 0x573AC759, CallAction_CameraBackButton },
        { 0x573EB339, CallAction_gacContextSwitchFailedRes },
        { 0x57AA275B, CallAction_gacViewCreateWithoutLoadReq },
        { 0x59148CB0, CallAction_FadeTransition },
        { 0x59C82D8E, CallAction_NextLevelTransition },
        { 0x59F03621, CallAction_gacChangeLanguageReq },
        { 0x60E513C0, CallAction_gacTBTRetriggerAcousticOutput },
        { 0x629132A7, CallAction_gacPopupFilterDisableReq },
        { 0x67B7653B, CallAction_gacDisplayFooterLineReq },
        { 0x68996642, CallAction_Perform_Main_CamSrc_Select },
        { 0x72BF9600, CallAction_SplitViewLeftCamMsgRequest },
        { 0x7531D066, CallAction_Notify_Init_Finished },
        { 0x75E49D1D, CallAction_gacPerformListFocusLockDataResetUpd },
        { 0x76EE4CA4, CallAction_gacHideStatusLineMultiDisplayReq },
        { 0x791DF896, CallAction_acPerform_CloseAllDropdowns },
        { 0x7D7B49B4, CallAction_acFocusOnRightEncoderReqUpd },
        { 0x7EE4AB88, CallAction_gacPopupRestartTimerReq },
        { 0x82D15005, CallAction_PageFlipBackTransition },
        { 0x881D2454, CallAction_gacPopupFilterAllEnableReqForDisplay },
        { 0x91BB105A, CallAction_gacLaunchBarDisplayReq },
        { 0x93218F8C, CallAction_gacContextSwitchOutReq },
        { 0x948F96CC, CallAction_gacScrollListDown },
        { 0x94B34967, CallAction_CameraBlackScreenStartTimerRequest },
        { 0x96350312, CallAction_acSetGadgetSceenActiveStatus },
        { 0x96D3C730, CallAction_gacPopupSBCloseReqForMultiDisplay },
        { 0x99154091, CallAction_Perform_cabin_from_home_Select },
        { 0x99258E0B, CallAction_gacStatusBarDisplayReq },
        { 0x9F87F08B, CallAction_acPostBeep },
        { 0x9FA26D73, CallAction_gacPopupFilterDisableReqForDisplay },
        { 0xA0A6F9FA, CallAction_gacViewHideAndDestroyReq },
        { 0xA172CF4E, CallAction_Perform_Activate_Home_Source },
        { 0xA7B62A65, CallAction_gacPopupFilterPrioEnableReqForDisplay },
        { 0xA84DC23C, CallAction_gacHideFocusInViewReq },
        { 0xA9C7F42F, CallAction_gacHideStatusLineReq },
        { 0xAB49461E, CallAction_gacViewCreateAndShowReq },
        { 0xAD947FF9, CallAction_gacCurrentScreenDisplayReq },
        { 0xAE48BF55, CallAction_DualViewRightTransition },
        { 0xAFB14254, CallAction_gacWaitAnimationStartReq },
        { 0xAFBA5828, CallAction_Perform_Mixed_Source },
        { 0xBB441DAC, CallAction_gacRegisterForCloseOnTouchSession },
        { 0xBDECE418, CallAction_gacSetApplicationMode },
        { 0xBEF6021E, CallAction_acPerform_ToggleDropdown },
        { 0xBF998086, CallAction_CameraStartmsgRequest },
        { 0xC37EE8E9, CallAction_gacPopupFilterPrioEnableReq },
        { 0xC51CE603, CallAction_gacViewCreateAllReq },
        { 0xC5DD5738, CallAction_gacProfileChange },
        { 0xC65CAED0, CallAction_gacSpellerBbehaviorReq },
        { 0xC8539D8B, CallAction_gacSceneTransitionLeave },
        { 0xC8EA8B79, CallAction_acRestartAppPopupTimer },
        { 0xC9EB88D6, CallAction_gacViewClearReq },
        { 0xCB8DBDEF, CallAction_gacHideFooterLineReq },
        { 0xCCF1A98B, CallAction_PreviousLevelTransition },
        { 0xCE0E9D8C, CallAction_SplitViewRightCamMsgRequest },
        { 0xD1AA4F4D, CallAction_ZoomOutTransition },
        { 0xD5F685D5, CallAction_PageFlipFrontTransition },
        { 0xD63C2357, CallAction_gacViewAsyncLoadReq },
        { 0xD98C6419, CallAction_gacViewActivateWithoutRenderingReq },
        { 0xDB665FD5, CallAction_acPerform_CloseDropdown },
        { 0xDD4D179D, CallAction_gacHideFooterLineMultiDisplayReq },
        { 0xDD71F921, CallAction_gacPerformListBtnRightEncoderChangeUpd },
        { 0xDF4DAF6F, CallAction_Perform_Main_Cabin_CamSrc_Select },
        { 0xE0EF3086, CallAction_gacPopupCreateAndSBShowReqForMultiDisplay },
        { 0xE0F8A311, CallAction_Perform_Previous_Camera },
        { 0xE500B03C, CallAction_gacContextSwitchBackRes },
        { 0xEB51CB7E, CallAction_gacPopupSBCloseReq },
        { 0xEC64DB0F, CallAction_gacScrollPageDown },
        { 0xEE11F57F, CallAction_gacScrollPageUp },
        { 0xEE131A83, CallAction_gacNavTBTSwipe },
        { 0xF0A1D4B5, CallAction_gacCheckToClosePopup },
        { 0xF17E085D, CallAction_gacPopupCreateAndSBShowReq },
        { 0xF5C28C77, CallAction_Cabin_Source_Button },
    };
    ::FeatStd::UInt32 hashId = ::Courier::Identifier::CalcHash(actionName);
    const ActionMapping* action = ::Courier::BinarySearch(hashId, actions, 104, &ActionMappingCmp);
    if (action && (hashId == action->mHashId)) {
        return action->mActionCallHandler(parameters, response);
    }
    return false;
}
#endif
namespace Courier {
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CameraGroupReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CameraGroupResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ActivationReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ActivationResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewRenderingReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewRenderingResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewMessagingReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewMessagingResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CameraGroupActivationReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CameraGroupActivationResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TryLoadReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::LoadReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DelayedUnloadMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::LoadResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TryAsyncLoadReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::AsyncLoadReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::AsyncLoadResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::AsyncLoadIndMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CameraGroupLoadReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CameraGroupLoadResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ThemeReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ThemeResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::AnimationReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::AnimationResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::AnimationIndMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::SetPropertyReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::SetPropertyResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::SetFocusReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::SetFocusResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::LostFocusIndMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TransitionReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TransitionResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TransitionIndMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::InvalidateReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::RenderReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::RenderResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::LayerReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::LayerResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ParentViewActivateEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ParentViewRenderingEnabledEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ParentViewInitContentEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ParentViewLoadEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::FocusEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::LostFocusEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TransitionStartedEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TransitionFinishedEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::SetCultureReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::SetCultureResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CultureChangeIndMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewPlaceholderReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewPlaceholderResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewMsgBase, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::WidgetMsgBase, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::Internal::DataBindingMsgBase, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::Internal::BindingSourceBaseMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::Internal::ReleaseDataItemMsgBase, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::Internal::DataItemMsgBase, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::Internal::ListEventMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::input::TouchAbort, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::input::TouchSessionStartEvent, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::input::TouchSessionStopEvent, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::IdUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::ConsumerMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::ProviderUpdateIndicationMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::TouchForwardReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::TouchAbortReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::ActivateImageProviderReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::ExternalImageProviderReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::ExternalImageProviderGroupReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::DrmAllocationStatusMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::DrmGarbageCollectorReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::DrmGCTimeoutMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::PositionBaseMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::SlaveSurfaceRepositionBaseMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::DirectTextureConsumerContentIndicationMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::PositionInfoReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::PositionInfoResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::SlaveSurfaceRepositionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::SlaveSurfaceRepositionResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::WidgetCheckReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::NotifierMessage, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TimerExpiredMsg, 15);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::GuiStartupFinishedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CreateNewDestroyOld, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EnterKeyStatusChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusControlReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusGroupReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::UpdateFocusSessionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RefreshFocusSessionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusSessionFinishedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RegisterFocusableWidgetsReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::JoystickStatusChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusChangedReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SurfaceStateChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::LayerStateChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SBPopupTimerExpiryUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::HMISubStateChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::QueryTraceInfoReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FollowUpActionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::WidgetPropertySetterReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SimTouchReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CloseOnTouchReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RegisterForCloseOnTouchSessionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SetClosePopupExternalTouchMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ClosePopupOnExternalTouchReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PlayBeepReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ChangeHmiSubStateReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EvalSubSurfaceReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ExecuteSubSurfaceReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ExecuteSubSurfaceResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ExtendedViewReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::LocalizationReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DecrementActiveAnimationCountMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PopupReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SetApplicationAsMandatoryReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ApplicationStateUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SubSurfaceUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ApplicationRenderedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ApplicationSwitchCompleteUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SubSurfaceSwitchCompleteUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SbAnimationStateChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SbCurrentStatusUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PopupDisplayStatusUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ShowHMISubSurfaceReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StartLayerAnimationReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PopupFilterPrioEnableReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PopupFilterAllEnableReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PopupFilterDisableReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::MultiDisplayPopupFilterReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RestartMenuTimeoutTimerReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RenderingCompleteMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CreateTextMetaDataCollectionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DumpScreenReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TraverseViewsReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropCheckSourceReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropCheckSourceResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropCheckDestinationReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropCheckDestinationResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropCompleteReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropCompleteResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropAbortReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropStatusUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ProfileSwitchMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TransitionMediatorOnDataCompleteMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ManualSceneActionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EglWaitNativeReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EglWaitNativeResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ResetGadgetCacheReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::AttachedAnimationReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::SenderMessage, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::TouchUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::AnimationWidgetReqMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::AnimationWidgetIndMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ButtonListItemUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ButtonReactionMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ButtonSlideMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ButtonGroupReqMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ColorBarDataUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::combobox::ComboBoxUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::combobox::ComboBoxReqMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DropdownCurrentValueChangedMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DropdownChangeMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::editfield::EditFieldUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::editfield::EditFieldHightlightReqMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gesture::GestureMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gesture::TapGestureMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gesture::DragGestureMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gesture::SwipeGestureMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gesture::PinchSpreadGestureMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gesture::RotateGestureMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gizmo::GizmoUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListDateProviderReqMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListDateProviderResMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListDataProviderUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListChangeMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListAnimatedChangeReqMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListChangedUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListMovementFinishedUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListStatusUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListVisibiltyUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListFocusChangeReqMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SliderCurrentValueChangedMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::LockOutMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListItemExpandReqMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListItemExpandEndUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListCustomAnimationReqMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListCustomAnimationResMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListCustomAnimationIndMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListMorphReqMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListContentUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListVisualContentUpdateMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListCacheReqMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::pageedit::PageEditUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PanelSlideReqMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PanelStateMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SpellerKeyPressed, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SpellerCtrlKeyPressed, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SpellerStatusChangedUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SubSpellerStatusUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TimerWidgetExpiryMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::HWR_CandidateUpdate, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::HWR_TextWidgetUpdate, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ScrollableTextUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActiveSurfaceViewUpdateMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ChangeLanguageReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StartPopupTimerReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StopPopupTimerReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RestartPopupTimerReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ExpiredPopupTimerResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListFocusResetReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EnableCameraRenderingReq, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SwitchApplicationStateReq, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DisableCameraRenderingReq, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DummyMess, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivityMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivateApplicationMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DeactivateApplicationMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::HardKeyPressNotificationMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusOnRightEncoderReqUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StoreActiveGadgetReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CheckToClosePopupMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ContextSwitchOutReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ContextSwitchInResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CurrentScreenDisplayReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::LaunchBarDisplayReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::NavTBTSwipeReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListItemRightEncoderChangeUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListFocusLockDataResetReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListFocusScrollReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SetApplicationModeReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SpellerBbehaviorReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StatusBarDisplayReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TBTRetriggerAcousticMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StartGadgetAnimationReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ControlPanelButtonPressInfo, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SwitchApplicationReq, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CameraViewMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CameraViewBlackScreenTransistionMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CameraViewBlackScreenTileTransistionMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CameraBlackScreenStopTriggerMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CameraBackButtonMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CabinSourceMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CameraToggleButton, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CameraExitMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CabinCameraExitMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::NextCameraActivate, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PreviousCameraActivate, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ButtonMainSrcActivate, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ButtonMainSrcCabinActivate, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ContextToMaster, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CameraBlackScreenStartTimerMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CameraSourceSelectionMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivateCameraStreamMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivateCameraBlackScreenSplitStreamMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivateCameraSplitStreamMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivateSplitFullScreenMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivateSplitScreenMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivateBlackScreenSplitScreenMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CameraBackMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CameraSplitStreamStartMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CameraSourceSelectionCabinMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CameraStreamStopMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CameraStreamStartMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ButtonMixedSourceMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::onHardKeyPress, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActiveRenderedView, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivatePopupMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivatePopupNotConfigMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SplitViewLeftCamMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SplitViewRightCamMsg, 20);
} // namespace Courier

// ------------------------------------------------------------------------
CameraSelectSourceDataBindingSource::CameraSelectSourceDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::CameraSelectSourceItem)
{
}

// ------------------------------------------------------------------------
CameraSourceDataBindingSource::CameraSourceDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::CameraSourceItem)
{
}

// ------------------------------------------------------------------------
ToggleCameraSceneDataBindingSource::ToggleCameraSceneDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::ToggleCameraSceneItem)
{
}

// ------------------------------------------------------------------------
HighlightButtonDataBindingSource::HighlightButtonDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::HighlightButtonItem)
{
}

// ------------------------------------------------------------------------
UpdateIconDataBindingSource::UpdateIconDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::UpdateIconItem)
{
}

// ------------------------------------------------------------------------
HideButtonCabinDataBindingSource::HideButtonCabinDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::HideButtonCabinItem)
{
}

// ------------------------------------------------------------------------
ListScrollBarInfoDataBindingSource::ListScrollBarInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::ListScrollBarInfoItem)
{
}

typedef void InvalidData;
struct InvalidDataBindingSource {
    static const ::FeatStd::UInt32 cHierarchyNodeCount = 1;
};

// table of shared DataItemDescriptor
static const ::Courier::Internal::DataBinding::DataItemDescriptor gItemDesc[cDataItemDescriptorCount] = {
    {   // 0 - ::InvalidData
        COURIER_DATA_ITEM_TYPE_ID(::InvalidData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 1 - ::CameraSelectSourceData
        COURIER_DATA_ITEM_TYPE_ID(::CameraSelectSourceData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 2 - ::CameraSelectSourceData::mSource_Name
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::CameraSelectSourceData, mSource_Name)
    },
    {   // 3 - ::CameraSelectSourceData::mCamView_Name
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::CameraSelectSourceData, mCamView_Name)
    },
    {   // 4 - ::CameraSelectSourceData::mVisible_Txt
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::CameraSelectSourceData, mVisible_Txt)
    },
    {   // 5 - ::CameraSelectSourceData::mWarningText
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::CameraSelectSourceData, mWarningText)
    },
    {   // 6 - ::CameraSelectSourceData::mCamera_Num1
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::CameraSelectSourceData, mCamera_Num1)
    },
    {   // 7 - ::CameraSelectSourceData::mCamera_Num2
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::CameraSelectSourceData, mCamera_Num2)
    },
    {   // 8 - ::CameraSelectSourceData::mCamera_Num3
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::CameraSelectSourceData, mCamera_Num3)
    },
    {   // 9 - ::CameraSelectSourceData::mCamera_Num4
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::CameraSelectSourceData, mCamera_Num4)
    },
    {   // 10 - ::CameraSelectSourceData::mCamera_Tile
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::CameraSelectSourceData, mCamera_Tile)
    },
    {   // 11 - ::CameraSelectSourceData::mCamera_Cockpit
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::CameraSelectSourceData, mCamera_Cockpit)
    },
    {   // 12 - ::CameraSelectSourceData::mCamera_Availability
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::CameraSelectSourceData, mCamera_Availability)
    },
    {   // 13 - ::CameraSelectSourceData::mCamera_BG
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::CameraSelectSourceData, mCamera_BG)
    },
    {   // 14 - ::CameraSelectSourceData::mNotConfiguredText
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::CameraSelectSourceData, mNotConfiguredText)
    },
    {   // 15 - ::CameraSelectSourceData::mCamera_TileA2
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::CameraSelectSourceData, mCamera_TileA2)
    },
    {   // 16 - ::CameraSelectSourceData::mRVC_Warning_PosCordinates
        COURIER_DATA_ITEM_TYPE_ID(Candera::Vector2),
        COURIER_ITEM_MEMBER(::CameraSelectSourceData, mRVC_Warning_PosCordinates)
    },
    {   // 17 - ::CameraSelectSourceData::mRVC_Warning_Visiblity
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::CameraSelectSourceData, mRVC_Warning_Visiblity)
    },
    {   // 18 - ::CameraSelectSourceData::mRVC_Warning_Language
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::CameraSelectSourceData, mRVC_Warning_Language)
    },
    {   // 19 - ::CameraSourceData
        COURIER_DATA_ITEM_TYPE_ID(::CameraSourceData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 20 - ::CameraSourceData::mCamera_Name
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::CameraSourceData, mCamera_Name)
    },
    {   // 21 - ::ToggleCameraSceneData
        COURIER_DATA_ITEM_TYPE_ID(::ToggleCameraSceneData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 22 - ::ToggleCameraSceneData::mShowHideSceneButtons
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::ToggleCameraSceneData, mShowHideSceneButtons)
    },
    {   // 23 - ::ToggleCameraSceneData::mLoading_text_visibility
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::ToggleCameraSceneData, mLoading_text_visibility)
    },
    {   // 24 - ::ToggleCameraSceneData::mCam_text_visibility
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::ToggleCameraSceneData, mCam_text_visibility)
    },
    {   // 25 - ::HighlightButtonData
        COURIER_DATA_ITEM_TYPE_ID(::HighlightButtonData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 26 - ::HighlightButtonData::mHighlightList
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::HighlightButtonData, mHighlightList)
    },
    {   // 27 - ::UpdateIconData
        COURIER_DATA_ITEM_TYPE_ID(::UpdateIconData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 28 - ::UpdateIconData::mActiveIcon
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::UpdateIconData, mActiveIcon)
    },
    {   // 29 - ::UpdateIconData::mNormalPressedIcon
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::UpdateIconData, mNormalPressedIcon)
    },
    {   // 30 - ::UpdateIconData::mActivePressedIcon
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::UpdateIconData, mActivePressedIcon)
    },
    {   // 31 - ::HideButtonCabinData
        COURIER_DATA_ITEM_TYPE_ID(::HideButtonCabinData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 32 - ::HideButtonCabinData::mHidePrevious
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::HideButtonCabinData, mHidePrevious)
    },
    {   // 33 - ::HideButtonCabinData::mHideNext
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::HideButtonCabinData, mHideNext)
    },
    {   // 34 - ::HideButtonCabinData::mToggleIcon
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::HideButtonCabinData, mToggleIcon)
    },
    {   // 35 - ::HideButtonCabinData::mLoadingTextCabin
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::HideButtonCabinData, mLoadingTextCabin)
    },
    {   // 36 - ::HideButtonCabinData::mCamTextCabin
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::HideButtonCabinData, mCamTextCabin)
    },
    {   // 37 - ::HideButtonCabinData::mCam_BG_Cabin
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::HideButtonCabinData, mCam_BG_Cabin)
    },
    {   // 38 - ::HideButtonCabinData::mHideMixSource
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::HideButtonCabinData, mHideMixSource)
    },
    {   // 39 - ::HideButtonCabinData::mCabinGlassA2Available
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::HideButtonCabinData, mCabinGlassA2Available)
    },
    {   // 40 - ::ListScrollBarInfoData
        COURIER_DATA_ITEM_TYPE_ID(::ListScrollBarInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 41 - ::ListScrollBarInfoData::mEnabled
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::ListScrollBarInfoData, mEnabled)
    },
};

// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gInvalidHierarchyNodes[InvalidDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x00000000, /Invalid),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 0,
        /* mParentIndex        */ 0,    // ItemKey::InvalidItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 0,    // ::InvalidData
        /* mItemKey            */ 0
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gCameraSelectSourceHierarchyNodes[CameraSelectSourceDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD1CDA9C6, /CameraSelectSource),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::CameraSelectSourceItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 1,    // ::CameraSelectSourceData
        /* mItemKey            */ 33
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x90188063, /CameraSelectSource/Source_Name),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::CameraSelectSourceItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 2,    // ::CameraSelectSourceData::mSource_Name
        /* mItemKey            */ 20
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x994D64BA, /CameraSelectSource/CamView_Name),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::CameraSelectSourceItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 3,    // ::CameraSelectSourceData::mCamView_Name
        /* mItemKey            */ 22
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x758A209D, /CameraSelectSource/Visible_Txt),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::CameraSelectSourceItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 4,    // ::CameraSelectSourceData::mVisible_Txt
        /* mItemKey            */ 18
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE18719C6, /CameraSelectSource/WarningText),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::CameraSelectSourceItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 5,    // ::CameraSelectSourceData::mWarningText
        /* mItemKey            */ 35
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x55D4E8C0, /CameraSelectSource/Camera_Num1),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::CameraSelectSourceItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 6,    // ::CameraSelectSourceData::mCamera_Num1
        /* mItemKey            */ 16
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD19FE048, /CameraSelectSource/Camera_Num2),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::CameraSelectSourceItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 7,    // ::CameraSelectSourceData::mCamera_Num2
        /* mItemKey            */ 32
    },
    { // 7
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD055DDB4, /CameraSelectSource/Camera_Num3),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::CameraSelectSourceItem
        /* mLocalIndex         */ 7,
        /* mDescriptorIndex    */ 8,    // ::CameraSelectSourceData::mCamera_Num3
        /* mItemKey            */ 31
    },
    { // 8
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x00C4BEA1, /CameraSelectSource/Camera_Num4),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::CameraSelectSourceItem
        /* mLocalIndex         */ 8,
        /* mDescriptorIndex    */ 9,    // ::CameraSelectSourceData::mCamera_Num4
        /* mItemKey            */ 1
    },
    { // 9
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x0C2A480D, /CameraSelectSource/Camera_Tile),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::CameraSelectSourceItem
        /* mLocalIndex         */ 9,
        /* mDescriptorIndex    */ 10,    // ::CameraSelectSourceData::mCamera_Tile
        /* mItemKey            */ 2
    },
    { // 10
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x73F9D6E2, /CameraSelectSource/Camera_Cockpit),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::CameraSelectSourceItem
        /* mLocalIndex         */ 10,
        /* mDescriptorIndex    */ 11,    // ::CameraSelectSourceData::mCamera_Cockpit
        /* mItemKey            */ 17
    },
    { // 11
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF3D38B6D, /CameraSelectSource/Camera_Availability),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::CameraSelectSourceItem
        /* mLocalIndex         */ 11,
        /* mDescriptorIndex    */ 12,    // ::CameraSelectSourceData::mCamera_Availability
        /* mItemKey            */ 38
    },
    { // 12
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3F13E6CD, /CameraSelectSource/Camera_BG),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::CameraSelectSourceItem
        /* mLocalIndex         */ 12,
        /* mDescriptorIndex    */ 13,    // ::CameraSelectSourceData::mCamera_BG
        /* mItemKey            */ 13
    },
    { // 13
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x41DC90E7, /CameraSelectSource/NotConfiguredText),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::CameraSelectSourceItem
        /* mLocalIndex         */ 13,
        /* mDescriptorIndex    */ 14,    // ::CameraSelectSourceData::mNotConfiguredText
        /* mItemKey            */ 14
    },
    { // 14
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA45BC5AA, /CameraSelectSource/Camera_TileA2),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::CameraSelectSourceItem
        /* mLocalIndex         */ 14,
        /* mDescriptorIndex    */ 15,    // ::CameraSelectSourceData::mCamera_TileA2
        /* mItemKey            */ 23
    },
    { // 15
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE8D9F847, /CameraSelectSource/RVC_Warning_PosCordinates),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::CameraSelectSourceItem
        /* mLocalIndex         */ 15,
        /* mDescriptorIndex    */ 16,    // ::CameraSelectSourceData::mRVC_Warning_PosCordinates
        /* mItemKey            */ 37
    },
    { // 16
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x2A8B2D8A, /CameraSelectSource/RVC_Warning_Visiblity),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::CameraSelectSourceItem
        /* mLocalIndex         */ 16,
        /* mDescriptorIndex    */ 17,    // ::CameraSelectSourceData::mRVC_Warning_Visiblity
        /* mItemKey            */ 8
    },
    { // 17
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x23685A98, /CameraSelectSource/RVC_Warning_Language),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::CameraSelectSourceItem
        /* mLocalIndex         */ 17,
        /* mDescriptorIndex    */ 18,    // ::CameraSelectSourceData::mRVC_Warning_Language
        /* mItemKey            */ 6
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gCameraSourceHierarchyNodes[CameraSourceDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3552A821, /CameraSource),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 2,
        /* mParentIndex        */ 0,    // ItemKey::CameraSourceItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 19,    // ::CameraSourceData
        /* mItemKey            */ 11
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x1E5190B8, /CameraSource/Camera_Name),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 2,
        /* mParentIndex        */ 0,    // ItemKey::CameraSourceItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 20,    // ::CameraSourceData::mCamera_Name
        /* mItemKey            */ 5
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gToggleCameraSceneHierarchyNodes[ToggleCameraSceneDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xBAC8521E, /ToggleCameraScene),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 3,
        /* mParentIndex        */ 0,    // ItemKey::ToggleCameraSceneItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 21,    // ::ToggleCameraSceneData
        /* mItemKey            */ 27
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3A4C893B, /ToggleCameraScene/ShowHideSceneButtons),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 3,
        /* mParentIndex        */ 0,    // ItemKey::ToggleCameraSceneItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 22,    // ::ToggleCameraSceneData::mShowHideSceneButtons
        /* mItemKey            */ 12
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF90E59CB, /ToggleCameraScene/Loading_text_visibility),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 3,
        /* mParentIndex        */ 0,    // ItemKey::ToggleCameraSceneItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 23,    // ::ToggleCameraSceneData::mLoading_text_visibility
        /* mItemKey            */ 39
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC670EF70, /ToggleCameraScene/Cam_text_visibility),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 3,
        /* mParentIndex        */ 0,    // ItemKey::ToggleCameraSceneItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 24,    // ::ToggleCameraSceneData::mCam_text_visibility
        /* mItemKey            */ 30
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gHighlightButtonHierarchyNodes[HighlightButtonDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x130EDD65, /HighlightButton),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 4,
        /* mParentIndex        */ 0,    // ItemKey::HighlightButtonItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 25,    // ::HighlightButtonData
        /* mItemKey            */ 4
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x0EF53394, /HighlightButton/HighlightList),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 4,
        /* mParentIndex        */ 0,    // ItemKey::HighlightButtonItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 26,    // ::HighlightButtonData::mHighlightList
        /* mItemKey            */ 3
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gUpdateIconHierarchyNodes[UpdateIconDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA83E6C73, /UpdateIcon),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 5,
        /* mParentIndex        */ 0,    // ItemKey::UpdateIconItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 27,    // ::UpdateIconData
        /* mItemKey            */ 25
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xBA31B93D, /UpdateIcon/ActiveIcon),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 5,
        /* mParentIndex        */ 0,    // ItemKey::UpdateIconItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 28,    // ::UpdateIconData::mActiveIcon
        /* mItemKey            */ 26
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x298E3A42, /UpdateIcon/NormalPressedIcon),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 5,
        /* mParentIndex        */ 0,    // ItemKey::UpdateIconItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 29,    // ::UpdateIconData::mNormalPressedIcon
        /* mItemKey            */ 7
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xBF6C2F2F, /UpdateIcon/ActivePressedIcon),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 5,
        /* mParentIndex        */ 0,    // ItemKey::UpdateIconItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 30,    // ::UpdateIconData::mActivePressedIcon
        /* mItemKey            */ 29
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gHideButtonCabinHierarchyNodes[HideButtonCabinDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD4371B8F, /HideButtonCabin),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 6,
        /* mParentIndex        */ 0,    // ItemKey::HideButtonCabinItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 31,    // ::HideButtonCabinData
        /* mItemKey            */ 34
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA7D7518D, /HideButtonCabin/HidePrevious),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 6,
        /* mParentIndex        */ 0,    // ItemKey::HideButtonCabinItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 32,    // ::HideButtonCabinData::mHidePrevious
        /* mItemKey            */ 24
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x34B8F7E8, /HideButtonCabin/HideNext),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 6,
        /* mParentIndex        */ 0,    // ItemKey::HideButtonCabinItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 33,    // ::HideButtonCabinData::mHideNext
        /* mItemKey            */ 10
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xBC7BE2E5, /HideButtonCabin/ToggleIcon),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 6,
        /* mParentIndex        */ 0,    // ItemKey::HideButtonCabinItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 34,    // ::HideButtonCabinData::mToggleIcon
        /* mItemKey            */ 28
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x8EC7A6C5, /HideButtonCabin/LoadingTextCabin),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 6,
        /* mParentIndex        */ 0,    // ItemKey::HideButtonCabinItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 35,    // ::HideButtonCabinData::mLoadingTextCabin
        /* mItemKey            */ 19
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xFE8F16C4, /HideButtonCabin/CamTextCabin),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 6,
        /* mParentIndex        */ 0,    // ItemKey::HideButtonCabinItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 36,    // ::HideButtonCabinData::mCamTextCabin
        /* mItemKey            */ 41
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x339387C8, /HideButtonCabin/Cam_BG_Cabin),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 6,
        /* mParentIndex        */ 0,    // ItemKey::HideButtonCabinItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 37,    // ::HideButtonCabinData::mCam_BG_Cabin
        /* mItemKey            */ 9
    },
    { // 7
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF9A07F38, /HideButtonCabin/HideMixSource),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 6,
        /* mParentIndex        */ 0,    // ItemKey::HideButtonCabinItem
        /* mLocalIndex         */ 7,
        /* mDescriptorIndex    */ 38,    // ::HideButtonCabinData::mHideMixSource
        /* mItemKey            */ 40
    },
    { // 8
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x96E1775E, /HideButtonCabin/CabinGlassA2Available),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 6,
        /* mParentIndex        */ 0,    // ItemKey::HideButtonCabinItem
        /* mLocalIndex         */ 8,
        /* mDescriptorIndex    */ 39,    // ::HideButtonCabinData::mCabinGlassA2Available
        /* mItemKey            */ 21
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gListScrollBarInfoHierarchyNodes[ListScrollBarInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x44E9662C, /ListScrollBarInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 7,
        /* mParentIndex        */ 0,    // ItemKey::ListScrollBarInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 40,    // ::ListScrollBarInfoData
        /* mItemKey            */ 15
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE2697E96, /ListScrollBarInfo/Enabled),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 7,
        /* mParentIndex        */ 0,    // ItemKey::ListScrollBarInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 41,    // ::ListScrollBarInfoData::mEnabled
        /* mItemKey            */ 36
    },
};

// array of pointers to all hierarchy nodes - sorted by HashId
const ::Courier::Internal::DataBinding::DataItemHierarchyNode * const gGlobalHierachyNodeTable[cGlobalDataItemHierarchyNodeCount] = {
    &gInvalidHierarchyNodes[0],
    &gCameraSelectSourceHierarchyNodes[8],
    &gCameraSelectSourceHierarchyNodes[9],
    &gHighlightButtonHierarchyNodes[1],
    &gHighlightButtonHierarchyNodes[0],
    &gCameraSourceHierarchyNodes[1],
    &gCameraSelectSourceHierarchyNodes[17],
    &gUpdateIconHierarchyNodes[2],
    &gCameraSelectSourceHierarchyNodes[16],
    &gHideButtonCabinHierarchyNodes[6],
    &gHideButtonCabinHierarchyNodes[2],
    &gCameraSourceHierarchyNodes[0],
    &gToggleCameraSceneHierarchyNodes[1],
    &gCameraSelectSourceHierarchyNodes[12],
    &gCameraSelectSourceHierarchyNodes[13],
    &gListScrollBarInfoHierarchyNodes[0],
    &gCameraSelectSourceHierarchyNodes[5],
    &gCameraSelectSourceHierarchyNodes[10],
    &gCameraSelectSourceHierarchyNodes[3],
    &gHideButtonCabinHierarchyNodes[4],
    &gCameraSelectSourceHierarchyNodes[1],
    &gHideButtonCabinHierarchyNodes[8],
    &gCameraSelectSourceHierarchyNodes[2],
    &gCameraSelectSourceHierarchyNodes[14],
    &gHideButtonCabinHierarchyNodes[1],
    &gUpdateIconHierarchyNodes[0],
    &gUpdateIconHierarchyNodes[1],
    &gToggleCameraSceneHierarchyNodes[0],
    &gHideButtonCabinHierarchyNodes[3],
    &gUpdateIconHierarchyNodes[3],
    &gToggleCameraSceneHierarchyNodes[3],
    &gCameraSelectSourceHierarchyNodes[7],
    &gCameraSelectSourceHierarchyNodes[6],
    &gCameraSelectSourceHierarchyNodes[0],
    &gHideButtonCabinHierarchyNodes[0],
    &gCameraSelectSourceHierarchyNodes[4],
    &gListScrollBarInfoHierarchyNodes[1],
    &gCameraSelectSourceHierarchyNodes[15],
    &gCameraSelectSourceHierarchyNodes[11],
    &gToggleCameraSceneHierarchyNodes[2],
    &gHideButtonCabinHierarchyNodes[7],
    &gHideButtonCabinHierarchyNodes[5],
};

// binding source root table - indexed with BindingSourceIndex 
static const ::Courier::Internal::DataBinding::BindingSourceRootStorage gBindingSourceMap[cBindingSourceCount] = {
    { InvalidDataBindingSource::cHierarchyNodeCount, gInvalidHierarchyNodes },
    { CameraSelectSourceDataBindingSource::cHierarchyNodeCount, gCameraSelectSourceHierarchyNodes },
    { CameraSourceDataBindingSource::cHierarchyNodeCount, gCameraSourceHierarchyNodes },
    { ToggleCameraSceneDataBindingSource::cHierarchyNodeCount, gToggleCameraSceneHierarchyNodes },
    { HighlightButtonDataBindingSource::cHierarchyNodeCount, gHighlightButtonHierarchyNodes },
    { UpdateIconDataBindingSource::cHierarchyNodeCount, gUpdateIconHierarchyNodes },
    { HideButtonCabinDataBindingSource::cHierarchyNodeCount, gHideButtonCabinHierarchyNodes },
    { ListScrollBarInfoDataBindingSource::cHierarchyNodeCount, gListScrollBarInfoHierarchyNodes },
};

// Init function prototype
static bool InitDataBindingGenerated(void);

// Infrastructure defnition
static const ::Courier::Internal::DataBinding::DataBindingInfrastructure gInfrastructure = { 
    cGlobalDataItemHierarchyNodeCount, gGlobalHierachyNodeTable, 
    cBindingSourceCount, gBindingSourceMap,
    cDataItemDescriptorCount, gItemDesc,
    &InitDataBindingGenerated
};

// ------------------------------------------------------------------------
static bool InitDataBindingGenerated(void)
{
    /* if one of these assertion fails, increase the limits defined in Courier/DataBinding/Infrastructure.h */
    COURIER_COMPILETIME_ASSERT(cBindingSourceItemCountMax < ::Courier::cBindingSourceHierarchyNodeMax);
    COURIER_COMPILETIME_ASSERT(cDataItemDescriptorCount < ::Courier::cItemDescriptorMax);
    COURIER_COMPILETIME_ASSERT(cBindingSourceCount < ::Courier::cBindingSourceMax);

    static ::Courier::Internal::DataBinding::BindingSourceRevisionStoreImpl<cBindingSourceCount> theRevisionStore;

    bool ok = true;
    {
        FEATSTD_UNSYNCED_STATIC_OBJECT(CameraSelectSourceDataBindingSource, bsCameraSelectSource);
        FEATSTD_UNSYNCED_STATIC_OBJECT(CameraSourceDataBindingSource, bsCameraSource);
        FEATSTD_UNSYNCED_STATIC_OBJECT(ToggleCameraSceneDataBindingSource, bsToggleCameraScene);
        FEATSTD_UNSYNCED_STATIC_OBJECT(HighlightButtonDataBindingSource, bsHighlightButton);
        FEATSTD_UNSYNCED_STATIC_OBJECT(UpdateIconDataBindingSource, bsUpdateIcon);
        FEATSTD_UNSYNCED_STATIC_OBJECT(HideButtonCabinDataBindingSource, bsHideButtonCabin);
        FEATSTD_UNSYNCED_STATIC_OBJECT(ListScrollBarInfoDataBindingSource, bsListScrollBarInfo);
        static ::Courier::Internal::ModelBindingSource *bindingSources[cBindingSourceCount] = { 
            0,
            &bsCameraSelectSource, 
            &bsCameraSource, 
            &bsToggleCameraScene, 
            &bsHighlightButton, 
            &bsUpdateIcon, 
            &bsHideButtonCabin, 
            &bsListScrollBarInfo, 
        };
        ok = ok && ::Courier::Register(::Courier::ComponentId(::Courier::ComponentType::View), bindingSources, cBindingSourceCount);
    }
    return ok;
}

namespace Courier {
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::CameraSelectSourceDataBindingSource>, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::CameraSourceDataBindingSource>, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::ToggleCameraSceneDataBindingSource>, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::HighlightButtonDataBindingSource>, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::UpdateIconDataBindingSource>, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::HideButtonCabinDataBindingSource>, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::ListScrollBarInfoDataBindingSource>, 5);
} // namespace Courier

#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
namespace FeatStd {
// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::CameraSelectSourceDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::CameraSelectSourceDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::CameraSourceDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::CameraSourceDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ToggleCameraSceneDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ToggleCameraSceneDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HighlightButtonDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HighlightButtonDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::UpdateIconDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::UpdateIconDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HideButtonCabinDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HideButtonCabinDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ListScrollBarInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ListScrollBarInfoDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }
} // namespace FeatStd
#endif
COURIER_DATABINDING_INFRASTRUCTURE(::gInfrastructure);
