#ifndef HEATCTRL_FIVISITOR_HEADER
#define HEATCTRL_FIVISITOR_HEADER

// --Basisklasse fuer eine FI-Besucher-Klasse

class heatctrl_fi_tclOutput {
public:
   heatctrl_fi_tclOutput();
   virtual ~heatctrl_fi_tclOutput(){};

   virtual tVoid vPrintLine(tCString coszLine) = 0;
};

class heatctrl_fi_tclFileOutput : public heatctrl_fi_tclOutput 
{
public:
   heatctrl_fi_tclFileOutput(OSAL_tIODescriptor rIOD):fd(rIOD) {}
   virtual tVoid vPrintLine(tCString coszLine);
protected:
   OSAL_tIODescriptor fd;
private:
   heatctrl_fi_tclFileOutput(); //lint !e1704
   heatctrl_fi_tclFileOutput& operator=(const heatctrl_fi_tclFileOutput& coRef);
   heatctrl_fi_tclFileOutput(const heatctrl_fi_tclFileOutput& coRef); //lint !e1704
};

class heatctrl_fi_tclMemOutput : public heatctrl_fi_tclOutput
{
public:
   heatctrl_fi_tclMemOutput(tU32 u32MemSize);
   virtual ~heatctrl_fi_tclMemOutput();
   virtual tVoid vPrintLine(tCString coszLine);
   tString szGetBuffer();
protected:
   tChar* szBuf;
   tChar* szEndBuf;
   tChar* s8BufPos;
private:
   heatctrl_fi_tclMemOutput(); //lint !e1704
   heatctrl_fi_tclMemOutput(const heatctrl_fi_tclMemOutput& coRef); //lint !e1704
   heatctrl_fi_tclMemOutput& operator=(const heatctrl_fi_tclMemOutput& coRef); //lint !e1704
};

class MY_DECL heatctrl_fi_tclVisitorBase {
public:

   // --Konstruktor
   heatctrl_fi_tclVisitorBase():bBreakNow(FALSE),bIsVisitorValid(FALSE) {}
   virtual ~heatctrl_fi_tclVisitorBase() {}

   tBool bIsValid() const { return bIsVisitorValid; }
   tVoid vInvalidate() { bIsVisitorValid=FALSE; }
   tVoid vValidate() { bIsVisitorValid=TRUE; }
   tBool bBreak() const { return bBreakNow; }
   tVoid vReleaseBreak() { bBreakNow = FALSE; }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(heatctrl_fi_tclU8& oU8);
   virtual tVoid vVisitS8(heatctrl_fi_tclS8& oS8);
   virtual tVoid vVisitU16(heatctrl_fi_tclU16& oU16);
   virtual tVoid vVisitS16(heatctrl_fi_tclS16& oS16);
   virtual tVoid vVisitU24(heatctrl_fi_tclU24& oU24);
   virtual tVoid vVisitS24(heatctrl_fi_tclS24& oS24);
   virtual tVoid vVisitU32(heatctrl_fi_tclU32& oU32);
   virtual tVoid vVisitS32(heatctrl_fi_tclS32& oS32);
   virtual tVoid vVisitU64(heatctrl_fi_tclU64& oU64);
   virtual tVoid vVisitS64(heatctrl_fi_tclS64& oS64);
   virtual tVoid vVisitF32(heatctrl_fi_tclF32& oF32);
   virtual tVoid vVisitF64(heatctrl_fi_tclF64& oF64);
   virtual tVoid vVisitBool(heatctrl_fi_tclBool& oBool);
   virtual tVoid vVisitString(heatctrl_fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(heatctrl_fi_tclMultiLanguageString& oString);

   virtual tVoid vVisitList(heatctrl_fi_tclList& oList);
   virtual tVoid vVisit_BinContainer(heatctrl_fi_tcl_BinContainer& oBinContainer);

   virtual tVoid vVisit_Reserved(heatctrl_fi_tcl_Reserved& oReserved);

   virtual tVoid vVisit_u8_Percent(heatctrl_fi_tcl_u8_Percent& ou8_Percent);

   virtual tVoid vVisit_s16_PerThousand(heatctrl_fi_tcl_s16_PerThousand& os16_PerThousand);

   virtual tVoid vVisit_u16_IndexInReferenceList(heatctrl_fi_tcl_u16_IndexInReferenceList& ou16_IndexInReferenceList);

   virtual tVoid vVisit_u16_ErrorCode(heatctrl_fi_tcl_u16_ErrorCode& ou16_ErrorCode);

   virtual tVoid vVisit_u16_RPM(heatctrl_fi_tcl_u16_RPM& ou16_RPM);

   virtual tVoid vVisit_s32_Kilogram(heatctrl_fi_tcl_s32_Kilogram& os32_Kilogram);

   virtual tVoid vVisit_s32_Pound(heatctrl_fi_tcl_s32_Pound& os32_Pound);

   virtual tVoid vVisit_s16_Meter(heatctrl_fi_tcl_s16_Meter& os16_Meter);

   virtual tVoid vVisit_s32_Meter(heatctrl_fi_tcl_s32_Meter& os32_Meter);

   virtual tVoid vVisit_s32_Yards(heatctrl_fi_tcl_s32_Yards& os32_Yards);

   virtual tVoid vVisit_s32_Foot(heatctrl_fi_tcl_s32_Foot& os32_Foot);

   virtual tVoid vVisit_s32_Centimeter(heatctrl_fi_tcl_s32_Centimeter& os32_Centimeter);

   virtual tVoid vVisit_s32_Inch(heatctrl_fi_tcl_s32_Inch& os32_Inch);

   virtual tVoid vVisit_s32_Millimeter(heatctrl_fi_tcl_s32_Millimeter& os32_Millimeter);

   virtual tVoid vVisit_s32_Microliter(heatctrl_fi_tcl_s32_Microliter& os32_Microliter);

   virtual tVoid vVisit_s32_Second(heatctrl_fi_tcl_s32_Second& os32_Second);

   virtual tVoid vVisit_u16_MilliSecond(heatctrl_fi_tcl_u16_MilliSecond& ou16_MilliSecond);

   virtual tVoid vVisit_s32_MilliSecond(heatctrl_fi_tcl_s32_MilliSecond& os32_MilliSecond);

   virtual tVoid vVisit_POSIXTime(heatctrl_fi_tcl_POSIXTime& oPOSIXTime);

   virtual tVoid vVisit_e8_DST_State(heatctrl_fi_tcl_e8_DST_State& oe8_DST_State);

   virtual tVoid vVisit_TimeZoneElement(heatctrl_fi_tcl_TimeZoneElement& oTimeZoneElement);

   virtual tVoid vVisit_s16_KmPerHour(heatctrl_fi_tcl_s16_KmPerHour& os16_KmPerHour);

   virtual tVoid vVisit_s16_MilesPerHour(heatctrl_fi_tcl_s16_MilesPerHour& os16_MilesPerHour);

   virtual tVoid vVisit_s16_Knot(heatctrl_fi_tcl_s16_Knot& os16_Knot);

   virtual tVoid vVisit_s16_CentimeterSecond(heatctrl_fi_tcl_s16_CentimeterSecond& os16_CentimeterSecond);

   virtual tVoid vVisit_s16_Kelvin(heatctrl_fi_tcl_s16_Kelvin& os16_Kelvin);

   virtual tVoid vVisit_s16_Fahrenheit(heatctrl_fi_tcl_s16_Fahrenheit& os16_Fahrenheit);

   virtual tVoid vVisit_s32_Pascal(heatctrl_fi_tcl_s32_Pascal& os32_Pascal);

   virtual tVoid vVisit_s32_Watt(heatctrl_fi_tcl_s32_Watt& os32_Watt);

   virtual tVoid vVisit_FIVersion(heatctrl_fi_tcl_FIVersion& oFIVersion);

   virtual tVoid vVisit_s32_Longitude(heatctrl_fi_tcl_s32_Longitude& os32_Longitude);

   virtual tVoid vVisit_s32_Latitude(heatctrl_fi_tcl_s32_Latitude& os32_Latitude);

   virtual tVoid vVisit_PositionWGS84(heatctrl_fi_tcl_PositionWGS84& oPositionWGS84);

   virtual tVoid vVisit_RectangleWGS84(heatctrl_fi_tcl_RectangleWGS84& oRectangleWGS84);

   virtual tVoid vVisit_e16_ISOCountryCode(heatctrl_fi_tcl_e16_ISOCountryCode& oe16_ISOCountryCode);

   virtual tVoid vVisit_e16_ISOLanguageCode(heatctrl_fi_tcl_e16_ISOLanguageCode& oe16_ISOLanguageCode);

   virtual tVoid vVisit_LanguageID(heatctrl_fi_tcl_LanguageID& oLanguageID);

   virtual tVoid vVisit_u8_DirectionAbsolute(heatctrl_fi_tcl_u8_DirectionAbsolute& ou8_DirectionAbsolute);

   virtual tVoid vVisit_u8_DirectionRelative(heatctrl_fi_tcl_u8_DirectionRelative& ou8_DirectionRelative);

   virtual tVoid vVisit_s16_CentiDegree(heatctrl_fi_tcl_s16_CentiDegree& os16_CentiDegree);

   virtual tVoid vVisit_s16_Degree(heatctrl_fi_tcl_s16_Degree& os16_Degree);

   virtual tVoid vVisit_u16_DirectionAbsolute_CentiDegree(heatctrl_fi_tcl_u16_DirectionAbsolute_CentiDegree& ou16_DirectionAbsolute_CentiDegree);

   virtual tVoid vVisit_s16_DirectionRelative_CentiDegree(heatctrl_fi_tcl_s16_DirectionRelative_CentiDegree& os16_DirectionRelative_CentiDegree);

   virtual tVoid vVisit_e8_FuelType(heatctrl_fi_tcl_e8_FuelType& oe8_FuelType);

   virtual tVoid vVisit_DistTimeFuel(heatctrl_fi_tcl_DistTimeFuel& oDistTimeFuel);

   virtual tVoid vVisit_e8_SensorID(heatctrl_fi_tcl_e8_SensorID& oe8_SensorID);

   virtual tVoid vVisit_e8_TemperatureQualityType(heatctrl_fi_tcl_e8_TemperatureQualityType& oe8_TemperatureQualityType);

   virtual tVoid vVisit_s16_SensorTemperaturValue(heatctrl_fi_tcl_s16_SensorTemperaturValue& os16_SensorTemperaturValue);

   virtual tVoid vVisit_e8_SensorState(heatctrl_fi_tcl_e8_SensorState& oe8_SensorState);

   virtual tVoid vVisit_SensorTemperature(heatctrl_fi_tcl_SensorTemperature& oSensorTemperature);

   virtual tVoid vVisit_SensorTemperatureList(heatctrl_fi_tcl_SensorTemperatureList& oSensorTemperatureList);

   virtual tVoid vVisit_SensorState(heatctrl_fi_tcl_SensorState& oSensorState);

   virtual tVoid vVisit_SensorStateList(heatctrl_fi_tcl_SensorStateList& oSensorStateList);

   virtual tVoid vVisit_e8_EmergncyFunctionID(heatctrl_fi_tcl_e8_EmergncyFunctionID& oe8_EmergncyFunctionID);

   virtual tVoid vVisit_e8_EmergncyFunctionState(heatctrl_fi_tcl_e8_EmergncyFunctionState& oe8_EmergncyFunctionState);

   virtual tVoid vVisit_EmergencyFunction(heatctrl_fi_tcl_EmergencyFunction& oEmergencyFunction);

   virtual tVoid vVisit_EmergencyFunctionList(heatctrl_fi_tcl_EmergencyFunctionList& oEmergencyFunctionList);

   virtual tVoid vVisit_e8_FANPowerState(heatctrl_fi_tcl_e8_FANPowerState& oe8_FANPowerState);

   virtual tVoid vVisit_u8_FANSpeedValue(heatctrl_fi_tcl_u8_FANSpeedValue& ou8_FANSpeedValue);

   virtual tVoid vVisit_u16_FANCurrentValue(heatctrl_fi_tcl_u16_FANCurrentValue& ou16_FANCurrentValue);

   virtual tVoid vVisit_e8_FANCtrlMode(heatctrl_fi_tcl_e8_FANCtrlMode& oe8_FANCtrlMode);

   virtual tVoid vVisit_e8_FANCtrlEvent(heatctrl_fi_tcl_e8_FANCtrlEvent& oe8_FANCtrlEvent);

   virtual tVoid vVisit_FAN(heatctrl_fi_tcl_FAN& oFAN);

   virtual tVoid vVisit_FANReq(heatctrl_fi_tcl_FANReq& oFANReq);

   virtual tVoid vVisit_FANCtrl(heatctrl_fi_tcl_FANCtrl& oFANCtrl);

   virtual tVoid vVisit_FANCtrlReq(heatctrl_fi_tcl_FANCtrlReq& oFANCtrlReq);


 	fi_tclTraversePath<fi_tclKnot>::tclIterator oIterator;		
	
protected:
	tBool bBreakNow;
	tBool bIsVisitorValid;
private:

};

#endif
