/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef HEATCTRL_MAINFITYPES_HEADER
#define HEATCTRL_MAINFITYPES_HEADER


class heatctrl_mainfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for heatctrl_main_fi message types

fi_tclMessageBase* heatctrl_mainfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class heatctrl_mainfi_tclMsgBaseMessage : public heatctrl_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   heatctrl_mainfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class heatctrl_mainfi_tclMsgFI_FC_HEATCTRL_DEFAULTMethodStart : public heatctrl_mainfi_tclMsgBaseMessage
{
public:

   heatctrl_mainfi_tclMsgFI_FC_HEATCTRL_DEFAULTMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   heatctrl_mainfi_tclMsgFI_FC_HEATCTRL_DEFAULTMethodStart& operator=(const heatctrl_mainfi_tclMsgFI_FC_HEATCTRL_DEFAULTMethodStart& coRef);
   heatctrl_mainfi_tclMsgFI_FC_HEATCTRL_DEFAULTMethodStart(const heatctrl_mainfi_tclMsgFI_FC_HEATCTRL_DEFAULTMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 DefaultSettingsGroup;
   tU8 DefaultSettingsMode;
   virtual ~heatctrl_mainfi_tclMsgFI_FC_HEATCTRL_DEFAULTMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const heatctrl_mainfi_tclMsgFI_FC_HEATCTRL_DEFAULTMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class heatctrl_mainfi_tclMsgFI_FC_HEATCTRL_DEFAULTMethodResult : public heatctrl_mainfi_tclMsgBaseMessage
{
public:

   heatctrl_mainfi_tclMsgFI_FC_HEATCTRL_DEFAULTMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   heatctrl_mainfi_tclMsgFI_FC_HEATCTRL_DEFAULTMethodResult& operator=(const heatctrl_mainfi_tclMsgFI_FC_HEATCTRL_DEFAULTMethodResult& coRef);
   heatctrl_mainfi_tclMsgFI_FC_HEATCTRL_DEFAULTMethodResult(const heatctrl_mainfi_tclMsgFI_FC_HEATCTRL_DEFAULTMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 DefaultSettingsGroup;
   tU8 DefaultSettingsStatus;
   virtual ~heatctrl_mainfi_tclMsgFI_FC_HEATCTRL_DEFAULTMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const heatctrl_mainfi_tclMsgFI_FC_HEATCTRL_DEFAULTMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class heatctrl_mainfi_tclMsgRealSensorTemperaturesUpReg : public heatctrl_mainfi_tclMsgBaseMessage
{
public:

   heatctrl_mainfi_tclMsgRealSensorTemperaturesUpReg();

   virtual ~heatctrl_mainfi_tclMsgRealSensorTemperaturesUpReg();

   inline tBool operator==(const heatctrl_mainfi_tclMsgRealSensorTemperaturesUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class heatctrl_mainfi_tclMsgRealSensorTemperaturesRelUpReg : public heatctrl_mainfi_tclMsgBaseMessage
{
public:

   heatctrl_mainfi_tclMsgRealSensorTemperaturesRelUpReg();

   virtual ~heatctrl_mainfi_tclMsgRealSensorTemperaturesRelUpReg();

   inline tBool operator==(const heatctrl_mainfi_tclMsgRealSensorTemperaturesRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class heatctrl_mainfi_tclMsgRealSensorTemperaturesGet : public heatctrl_mainfi_tclMsgBaseMessage
{
public:

   heatctrl_mainfi_tclMsgRealSensorTemperaturesGet();

   virtual ~heatctrl_mainfi_tclMsgRealSensorTemperaturesGet();

   inline tBool operator==(const heatctrl_mainfi_tclMsgRealSensorTemperaturesGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class heatctrl_mainfi_tclMsgRealSensorTemperaturesStatus : public heatctrl_mainfi_tclMsgBaseMessage
{
public:

   heatctrl_mainfi_tclMsgRealSensorTemperaturesStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   heatctrl_mainfi_tclMsgRealSensorTemperaturesStatus& operator=(const heatctrl_mainfi_tclMsgRealSensorTemperaturesStatus& coRef);
   heatctrl_mainfi_tclMsgRealSensorTemperaturesStatus(const heatctrl_mainfi_tclMsgRealSensorTemperaturesStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   heatctrl_fi_tcl_SensorTemperatureList List;
   virtual ~heatctrl_mainfi_tclMsgRealSensorTemperaturesStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const heatctrl_mainfi_tclMsgRealSensorTemperaturesStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class heatctrl_mainfi_tclMsgRealSensorStatesUpReg : public heatctrl_mainfi_tclMsgBaseMessage
{
public:

   heatctrl_mainfi_tclMsgRealSensorStatesUpReg();

   virtual ~heatctrl_mainfi_tclMsgRealSensorStatesUpReg();

   inline tBool operator==(const heatctrl_mainfi_tclMsgRealSensorStatesUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class heatctrl_mainfi_tclMsgRealSensorStatesRelUpReg : public heatctrl_mainfi_tclMsgBaseMessage
{
public:

   heatctrl_mainfi_tclMsgRealSensorStatesRelUpReg();

   virtual ~heatctrl_mainfi_tclMsgRealSensorStatesRelUpReg();

   inline tBool operator==(const heatctrl_mainfi_tclMsgRealSensorStatesRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class heatctrl_mainfi_tclMsgRealSensorStatesGet : public heatctrl_mainfi_tclMsgBaseMessage
{
public:

   heatctrl_mainfi_tclMsgRealSensorStatesGet();

   virtual ~heatctrl_mainfi_tclMsgRealSensorStatesGet();

   inline tBool operator==(const heatctrl_mainfi_tclMsgRealSensorStatesGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class heatctrl_mainfi_tclMsgRealSensorStatesStatus : public heatctrl_mainfi_tclMsgBaseMessage
{
public:

   heatctrl_mainfi_tclMsgRealSensorStatesStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   heatctrl_mainfi_tclMsgRealSensorStatesStatus& operator=(const heatctrl_mainfi_tclMsgRealSensorStatesStatus& coRef);
   heatctrl_mainfi_tclMsgRealSensorStatesStatus(const heatctrl_mainfi_tclMsgRealSensorStatesStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   heatctrl_fi_tcl_SensorStateList List;
   virtual ~heatctrl_mainfi_tclMsgRealSensorStatesStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const heatctrl_mainfi_tclMsgRealSensorStatesStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class heatctrl_mainfi_tclMsgAbstractSensorTemperaturesUpReg : public heatctrl_mainfi_tclMsgBaseMessage
{
public:

   heatctrl_mainfi_tclMsgAbstractSensorTemperaturesUpReg();

   virtual ~heatctrl_mainfi_tclMsgAbstractSensorTemperaturesUpReg();

   inline tBool operator==(const heatctrl_mainfi_tclMsgAbstractSensorTemperaturesUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class heatctrl_mainfi_tclMsgAbstractSensorTemperaturesRelUpReg : public heatctrl_mainfi_tclMsgBaseMessage
{
public:

   heatctrl_mainfi_tclMsgAbstractSensorTemperaturesRelUpReg();

   virtual ~heatctrl_mainfi_tclMsgAbstractSensorTemperaturesRelUpReg();

   inline tBool operator==(const heatctrl_mainfi_tclMsgAbstractSensorTemperaturesRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class heatctrl_mainfi_tclMsgAbstractSensorTemperaturesGet : public heatctrl_mainfi_tclMsgBaseMessage
{
public:

   heatctrl_mainfi_tclMsgAbstractSensorTemperaturesGet();

   virtual ~heatctrl_mainfi_tclMsgAbstractSensorTemperaturesGet();

   inline tBool operator==(const heatctrl_mainfi_tclMsgAbstractSensorTemperaturesGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class heatctrl_mainfi_tclMsgAbstractSensorTemperaturesStatus : public heatctrl_mainfi_tclMsgBaseMessage
{
public:

   heatctrl_mainfi_tclMsgAbstractSensorTemperaturesStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   heatctrl_mainfi_tclMsgAbstractSensorTemperaturesStatus& operator=(const heatctrl_mainfi_tclMsgAbstractSensorTemperaturesStatus& coRef);
   heatctrl_mainfi_tclMsgAbstractSensorTemperaturesStatus(const heatctrl_mainfi_tclMsgAbstractSensorTemperaturesStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   heatctrl_fi_tcl_SensorTemperatureList List;
   virtual ~heatctrl_mainfi_tclMsgAbstractSensorTemperaturesStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const heatctrl_mainfi_tclMsgAbstractSensorTemperaturesStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class heatctrl_mainfi_tclMsgAbstractSensorStatesUpReg : public heatctrl_mainfi_tclMsgBaseMessage
{
public:

   heatctrl_mainfi_tclMsgAbstractSensorStatesUpReg();

   virtual ~heatctrl_mainfi_tclMsgAbstractSensorStatesUpReg();

   inline tBool operator==(const heatctrl_mainfi_tclMsgAbstractSensorStatesUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class heatctrl_mainfi_tclMsgAbstractSensorStatesRelUpReg : public heatctrl_mainfi_tclMsgBaseMessage
{
public:

   heatctrl_mainfi_tclMsgAbstractSensorStatesRelUpReg();

   virtual ~heatctrl_mainfi_tclMsgAbstractSensorStatesRelUpReg();

   inline tBool operator==(const heatctrl_mainfi_tclMsgAbstractSensorStatesRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class heatctrl_mainfi_tclMsgAbstractSensorStatesGet : public heatctrl_mainfi_tclMsgBaseMessage
{
public:

   heatctrl_mainfi_tclMsgAbstractSensorStatesGet();

   virtual ~heatctrl_mainfi_tclMsgAbstractSensorStatesGet();

   inline tBool operator==(const heatctrl_mainfi_tclMsgAbstractSensorStatesGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class heatctrl_mainfi_tclMsgAbstractSensorStatesStatus : public heatctrl_mainfi_tclMsgBaseMessage
{
public:

   heatctrl_mainfi_tclMsgAbstractSensorStatesStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   heatctrl_mainfi_tclMsgAbstractSensorStatesStatus& operator=(const heatctrl_mainfi_tclMsgAbstractSensorStatesStatus& coRef);
   heatctrl_mainfi_tclMsgAbstractSensorStatesStatus(const heatctrl_mainfi_tclMsgAbstractSensorStatesStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   heatctrl_fi_tcl_SensorStateList List;
   virtual ~heatctrl_mainfi_tclMsgAbstractSensorStatesStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const heatctrl_mainfi_tclMsgAbstractSensorStatesStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class heatctrl_mainfi_tclMsgEmergencyFunctionsUpReg : public heatctrl_mainfi_tclMsgBaseMessage
{
public:

   heatctrl_mainfi_tclMsgEmergencyFunctionsUpReg();

   virtual ~heatctrl_mainfi_tclMsgEmergencyFunctionsUpReg();

   inline tBool operator==(const heatctrl_mainfi_tclMsgEmergencyFunctionsUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class heatctrl_mainfi_tclMsgEmergencyFunctionsRelUpReg : public heatctrl_mainfi_tclMsgBaseMessage
{
public:

   heatctrl_mainfi_tclMsgEmergencyFunctionsRelUpReg();

   virtual ~heatctrl_mainfi_tclMsgEmergencyFunctionsRelUpReg();

   inline tBool operator==(const heatctrl_mainfi_tclMsgEmergencyFunctionsRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class heatctrl_mainfi_tclMsgEmergencyFunctionsGet : public heatctrl_mainfi_tclMsgBaseMessage
{
public:

   heatctrl_mainfi_tclMsgEmergencyFunctionsGet();

   virtual ~heatctrl_mainfi_tclMsgEmergencyFunctionsGet();

   inline tBool operator==(const heatctrl_mainfi_tclMsgEmergencyFunctionsGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class heatctrl_mainfi_tclMsgEmergencyFunctionsStatus : public heatctrl_mainfi_tclMsgBaseMessage
{
public:

   heatctrl_mainfi_tclMsgEmergencyFunctionsStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   heatctrl_mainfi_tclMsgEmergencyFunctionsStatus& operator=(const heatctrl_mainfi_tclMsgEmergencyFunctionsStatus& coRef);
   heatctrl_mainfi_tclMsgEmergencyFunctionsStatus(const heatctrl_mainfi_tclMsgEmergencyFunctionsStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   heatctrl_fi_tcl_EmergencyFunctionList List;
   virtual ~heatctrl_mainfi_tclMsgEmergencyFunctionsStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const heatctrl_mainfi_tclMsgEmergencyFunctionsStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class heatctrl_mainfi_tclMsgFANControlUpReg : public heatctrl_mainfi_tclMsgBaseMessage
{
public:

   heatctrl_mainfi_tclMsgFANControlUpReg();

   virtual ~heatctrl_mainfi_tclMsgFANControlUpReg();

   inline tBool operator==(const heatctrl_mainfi_tclMsgFANControlUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class heatctrl_mainfi_tclMsgFANControlRelUpReg : public heatctrl_mainfi_tclMsgBaseMessage
{
public:

   heatctrl_mainfi_tclMsgFANControlRelUpReg();

   virtual ~heatctrl_mainfi_tclMsgFANControlRelUpReg();

   inline tBool operator==(const heatctrl_mainfi_tclMsgFANControlRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class heatctrl_mainfi_tclMsgFANControlGet : public heatctrl_mainfi_tclMsgBaseMessage
{
public:

   heatctrl_mainfi_tclMsgFANControlGet();

   virtual ~heatctrl_mainfi_tclMsgFANControlGet();

   inline tBool operator==(const heatctrl_mainfi_tclMsgFANControlGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class heatctrl_mainfi_tclMsgFANControlSet : public heatctrl_mainfi_tclMsgBaseMessage
{
public:

   heatctrl_mainfi_tclMsgFANControlSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   heatctrl_mainfi_tclMsgFANControlSet& operator=(const heatctrl_mainfi_tclMsgFANControlSet& coRef);
   heatctrl_mainfi_tclMsgFANControlSet(const heatctrl_mainfi_tclMsgFANControlSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   heatctrl_fi_tcl_FANReq FAN;
   heatctrl_fi_tcl_FANCtrlReq FANCtrl;
   virtual ~heatctrl_mainfi_tclMsgFANControlSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const heatctrl_mainfi_tclMsgFANControlSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class heatctrl_mainfi_tclMsgFANControlStatus : public heatctrl_mainfi_tclMsgBaseMessage
{
public:

   heatctrl_mainfi_tclMsgFANControlStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   heatctrl_mainfi_tclMsgFANControlStatus& operator=(const heatctrl_mainfi_tclMsgFANControlStatus& coRef);
   heatctrl_mainfi_tclMsgFANControlStatus(const heatctrl_mainfi_tclMsgFANControlStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   heatctrl_fi_tcl_FAN FAN;
   heatctrl_fi_tcl_FANCtrl FANCtrl;
   virtual ~heatctrl_mainfi_tclMsgFANControlStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const heatctrl_mainfi_tclMsgFANControlStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
