#ifndef HEATCTRL_MAINFILANGUAGE_HEADER
#define HEATCTRL_MAINFILANGUAGE_HEADER

class heatctrl_mainfi_tclInContext;
class heatctrl_mainfi_tclOutContext;
class heatctrl_mainfi_tclVisitorBase;

class MY_DECL heatctrl_mainfi_tclDescription {
 public:
  enum tenType { EN_PARSING, EN_GENERATING };	
  
  heatctrl_mainfi_tclDescription(fi_tclInContext* poIn, heatctrl_mainfi_tclVisitorBase* poVisit);
  heatctrl_mainfi_tclDescription(fi_tclOutContext* poOut, heatctrl_mainfi_tclVisitorBase* poVisit);
  
  /* --Hier kommen nun die Methoden, die einzelne Nachrichten entspr. NaFI 
		erzeugen (EN_GENERATING) bzw. einlesen (EN_PARSING). */

  tBool bInitMessage(heatctrl_mainfi_tclToken::tenType enMsgToken);
  tBool bProcessMessage();

  // tBool bProcessElement(); 

  tBool bDoIt(heatctrl_fi_tclVisitableTypeBase& poBaseType);
#ifndef FI_S_EXTERNAL_FI
  void vEnableSpecialBinContainer() { bUseSpecialBinContainer = true; }
#endif

 private:
  /* default constructor */ heatctrl_mainfi_tclDescription();  //lint !e1704 // always use parameters
  tenType enType; //--read or write?

  union {
    fi_tclInContext* poInContext;
    fi_tclOutContext* poOutContext;
  };

  heatctrl_mainfi_tclVisitorBase* poVisitor;

  // typedef navifi_tclTraversePath::tclKnot tclKnot;

  tBool bUseSpecialBinContainer;  
  
 public:
  
  // --Traversierungspfad
  fi_tclTraversePath<heatctrl_mainfi_tclKnot> oPath;
  //   navifi_tclTraversePath oPath;
  fi_tclTraversePath<heatctrl_mainfi_tclKnot> oCallStack;
   //  navifi_tclTraversePath oCallStack;
  
};

// --Inline-Implementierungen
inline heatctrl_mainfi_tclDescription::heatctrl_mainfi_tclDescription(fi_tclInContext* poIn, heatctrl_mainfi_tclVisitorBase* poVisit):
  enType(EN_PARSING),poInContext(poIn),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

inline heatctrl_mainfi_tclDescription::heatctrl_mainfi_tclDescription(fi_tclOutContext* poOut, heatctrl_mainfi_tclVisitorBase* poVisit):
  enType(EN_GENERATING),poOutContext(poOut),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

#endif

