/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef DIMMING_MAINFITYPES_HEADER
#define DIMMING_MAINFITYPES_HEADER


class dimming_mainfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for dimming_main_fi message types

fi_tclMessageBase* dimming_mainfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class dimming_mainfi_tclMsgBaseMessage : public dimming_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   dimming_mainfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class dimming_mainfi_tclMsgFI_VD_DIMMING_DEFAULTMethodStart : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgFI_VD_DIMMING_DEFAULTMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgFI_VD_DIMMING_DEFAULTMethodStart& operator=(const dimming_mainfi_tclMsgFI_VD_DIMMING_DEFAULTMethodStart& coRef);
   dimming_mainfi_tclMsgFI_VD_DIMMING_DEFAULTMethodStart(const dimming_mainfi_tclMsgFI_VD_DIMMING_DEFAULTMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 DefaultSettingsGroup;
   tU8 DefaultSettingsMode;
   virtual ~dimming_mainfi_tclMsgFI_VD_DIMMING_DEFAULTMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgFI_VD_DIMMING_DEFAULTMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgFI_VD_DIMMING_DEFAULTMethodResult : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgFI_VD_DIMMING_DEFAULTMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgFI_VD_DIMMING_DEFAULTMethodResult& operator=(const dimming_mainfi_tclMsgFI_VD_DIMMING_DEFAULTMethodResult& coRef);
   dimming_mainfi_tclMsgFI_VD_DIMMING_DEFAULTMethodResult(const dimming_mainfi_tclMsgFI_VD_DIMMING_DEFAULTMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 DefaultSettingsGroup;
   tU8 DefaultSettingsStatus;
   virtual ~dimming_mainfi_tclMsgFI_VD_DIMMING_DEFAULTMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgFI_VD_DIMMING_DEFAULTMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_INFO_SetDimmingModeMethodStart : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_INFO_SetDimmingModeMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_INFO_SetDimmingModeMethodStart& operator=(const dimming_mainfi_tclMsgDIM_INFO_SetDimmingModeMethodStart& coRef);
   dimming_mainfi_tclMsgDIM_INFO_SetDimmingModeMethodStart(const dimming_mainfi_tclMsgDIM_INFO_SetDimmingModeMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   dimming_fi_tcl_e8_DIM_Mode DimmingMode;
   virtual ~dimming_mainfi_tclMsgDIM_INFO_SetDimmingModeMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_INFO_SetDimmingModeMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_INFO_SetDimmingModeMethodResult : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_INFO_SetDimmingModeMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_INFO_SetDimmingModeMethodResult& operator=(const dimming_mainfi_tclMsgDIM_INFO_SetDimmingModeMethodResult& coRef);
   dimming_mainfi_tclMsgDIM_INFO_SetDimmingModeMethodResult(const dimming_mainfi_tclMsgDIM_INFO_SetDimmingModeMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   dimming_fi_tcl_e8_DIM_Mode DimmingMode;
   virtual ~dimming_mainfi_tclMsgDIM_INFO_SetDimmingModeMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_INFO_SetDimmingModeMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_INFO_SetEmulationModeMethodStart : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_INFO_SetEmulationModeMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_INFO_SetEmulationModeMethodStart& operator=(const dimming_mainfi_tclMsgDIM_INFO_SetEmulationModeMethodStart& coRef);
   dimming_mainfi_tclMsgDIM_INFO_SetEmulationModeMethodStart(const dimming_mainfi_tclMsgDIM_INFO_SetEmulationModeMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   dimming_fi_tcl_e8_DIM_EmulationMode EmulationMode;
   virtual ~dimming_mainfi_tclMsgDIM_INFO_SetEmulationModeMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_INFO_SetEmulationModeMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_INFO_SetEmulationModeMethodResult : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_INFO_SetEmulationModeMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_INFO_SetEmulationModeMethodResult& operator=(const dimming_mainfi_tclMsgDIM_INFO_SetEmulationModeMethodResult& coRef);
   dimming_mainfi_tclMsgDIM_INFO_SetEmulationModeMethodResult(const dimming_mainfi_tclMsgDIM_INFO_SetEmulationModeMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   dimming_fi_tcl_e8_DIM_EmulationMode EmulationMode;
   virtual ~dimming_mainfi_tclMsgDIM_INFO_SetEmulationModeMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_INFO_SetEmulationModeMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_INFO_SetDimmingStateMethodStart : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_INFO_SetDimmingStateMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_INFO_SetDimmingStateMethodStart& operator=(const dimming_mainfi_tclMsgDIM_INFO_SetDimmingStateMethodStart& coRef);
   dimming_mainfi_tclMsgDIM_INFO_SetDimmingStateMethodStart(const dimming_mainfi_tclMsgDIM_INFO_SetDimmingStateMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 LUN;
   dimming_fi_tcl_e8_DIM_Status DimmingStatus;
   virtual ~dimming_mainfi_tclMsgDIM_INFO_SetDimmingStateMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_INFO_SetDimmingStateMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_INFO_SetDimmingStateMethodResult : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_INFO_SetDimmingStateMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_INFO_SetDimmingStateMethodResult& operator=(const dimming_mainfi_tclMsgDIM_INFO_SetDimmingStateMethodResult& coRef);
   dimming_mainfi_tclMsgDIM_INFO_SetDimmingStateMethodResult(const dimming_mainfi_tclMsgDIM_INFO_SetDimmingStateMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 LUN;
   dimming_fi_tcl_e8_DIM_Status DimmingStatus;
   virtual ~dimming_mainfi_tclMsgDIM_INFO_SetDimmingStateMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_INFO_SetDimmingStateMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_INFO_GetDimmingStateMethodStart : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_INFO_GetDimmingStateMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_INFO_GetDimmingStateMethodStart& operator=(const dimming_mainfi_tclMsgDIM_INFO_GetDimmingStateMethodStart& coRef);
   dimming_mainfi_tclMsgDIM_INFO_GetDimmingStateMethodStart(const dimming_mainfi_tclMsgDIM_INFO_GetDimmingStateMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 LUN;
   virtual ~dimming_mainfi_tclMsgDIM_INFO_GetDimmingStateMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_INFO_GetDimmingStateMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_INFO_GetDimmingStateMethodResult : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_INFO_GetDimmingStateMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_INFO_GetDimmingStateMethodResult& operator=(const dimming_mainfi_tclMsgDIM_INFO_GetDimmingStateMethodResult& coRef);
   dimming_mainfi_tclMsgDIM_INFO_GetDimmingStateMethodResult(const dimming_mainfi_tclMsgDIM_INFO_GetDimmingStateMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 LUN;
   dimming_fi_tcl_e8_DIM_Status DimmingState;
   virtual ~dimming_mainfi_tclMsgDIM_INFO_GetDimmingStateMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_INFO_GetDimmingStateMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodStart : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodStart& operator=(const dimming_mainfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodStart& coRef);
   dimming_mainfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodStart(const dimming_mainfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   dimming_fi_tcl_u8_DIM_LUN LUN;
   dimming_fi_tcl_u16_DIM_Permille Brightness;
   virtual ~dimming_mainfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodResult : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodResult& operator=(const dimming_mainfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodResult& coRef);
   dimming_mainfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodResult(const dimming_mainfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   dimming_fi_tcl_u8_DIM_LUN LUN;
   dimming_fi_tcl_u16_DIM_Permille Brightness;
   virtual ~dimming_mainfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodStart : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodStart& operator=(const dimming_mainfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodStart& coRef);
   dimming_mainfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodStart(const dimming_mainfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   dimming_fi_tcl_u8_DIM_LUN LUN;
   virtual ~dimming_mainfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodResult : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodResult& operator=(const dimming_mainfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodResult& coRef);
   dimming_mainfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodResult(const dimming_mainfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   dimming_fi_tcl_u8_DIM_LUN LUN;
   dimming_fi_tcl_u16_DIM_Permille Brightness;
   virtual ~dimming_mainfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_INFO_GetPWMBrightnessMethodStart : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_INFO_GetPWMBrightnessMethodStart();

   virtual ~dimming_mainfi_tclMsgDIM_INFO_GetPWMBrightnessMethodStart();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_INFO_GetPWMBrightnessMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_INFO_GetPWMBrightnessMethodResult : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_INFO_GetPWMBrightnessMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_INFO_GetPWMBrightnessMethodResult& operator=(const dimming_mainfi_tclMsgDIM_INFO_GetPWMBrightnessMethodResult& coRef);
   dimming_mainfi_tclMsgDIM_INFO_GetPWMBrightnessMethodResult(const dimming_mainfi_tclMsgDIM_INFO_GetPWMBrightnessMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   dimming_fi_tcl_u16_DIM_Permille Brightness;
   virtual ~dimming_mainfi_tclMsgDIM_INFO_GetPWMBrightnessMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_INFO_GetPWMBrightnessMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_KEYB_SetDimmingMethodStart : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_KEYB_SetDimmingMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_KEYB_SetDimmingMethodStart& operator=(const dimming_mainfi_tclMsgDIM_KEYB_SetDimmingMethodStart& coRef);
   dimming_mainfi_tclMsgDIM_KEYB_SetDimmingMethodStart(const dimming_mainfi_tclMsgDIM_KEYB_SetDimmingMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   dimming_fi_tcl_u16_DIM_Permille Brightness;
   virtual ~dimming_mainfi_tclMsgDIM_KEYB_SetDimmingMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_KEYB_SetDimmingMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_KEYB_SetDimmingMethodResult : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_KEYB_SetDimmingMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_KEYB_SetDimmingMethodResult& operator=(const dimming_mainfi_tclMsgDIM_KEYB_SetDimmingMethodResult& coRef);
   dimming_mainfi_tclMsgDIM_KEYB_SetDimmingMethodResult(const dimming_mainfi_tclMsgDIM_KEYB_SetDimmingMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   dimming_fi_tcl_u16_DIM_Permille Brightness;
   virtual ~dimming_mainfi_tclMsgDIM_KEYB_SetDimmingMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_KEYB_SetDimmingMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_KEYB_SetDimmingPWMMethodStart : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_KEYB_SetDimmingPWMMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_KEYB_SetDimmingPWMMethodStart& operator=(const dimming_mainfi_tclMsgDIM_KEYB_SetDimmingPWMMethodStart& coRef);
   dimming_mainfi_tclMsgDIM_KEYB_SetDimmingPWMMethodStart(const dimming_mainfi_tclMsgDIM_KEYB_SetDimmingPWMMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   dimming_fi_tcl_u16_DIM_Permille Brightness;
   virtual ~dimming_mainfi_tclMsgDIM_KEYB_SetDimmingPWMMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_KEYB_SetDimmingPWMMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_KEYB_SetDimmingPWMMethodResult : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_KEYB_SetDimmingPWMMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_KEYB_SetDimmingPWMMethodResult& operator=(const dimming_mainfi_tclMsgDIM_KEYB_SetDimmingPWMMethodResult& coRef);
   dimming_mainfi_tclMsgDIM_KEYB_SetDimmingPWMMethodResult(const dimming_mainfi_tclMsgDIM_KEYB_SetDimmingPWMMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   dimming_fi_tcl_u16_DIM_Permille Brightness;
   virtual ~dimming_mainfi_tclMsgDIM_KEYB_SetDimmingPWMMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_KEYB_SetDimmingPWMMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_SetDriverInitalizedMethodStart : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_SetDriverInitalizedMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DISP_SetDriverInitalizedMethodStart& operator=(const dimming_mainfi_tclMsgDIM_DISP_SetDriverInitalizedMethodStart& coRef);
   dimming_mainfi_tclMsgDIM_DISP_SetDriverInitalizedMethodStart(const dimming_mainfi_tclMsgDIM_DISP_SetDriverInitalizedMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   dimming_fi_tcl_e8_DIM_Status SetDriverInitialized;
   virtual ~dimming_mainfi_tclMsgDIM_DISP_SetDriverInitalizedMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_SetDriverInitalizedMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_SetDriverInitalizedMethodResult : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_SetDriverInitalizedMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DISP_SetDriverInitalizedMethodResult& operator=(const dimming_mainfi_tclMsgDIM_DISP_SetDriverInitalizedMethodResult& coRef);
   dimming_mainfi_tclMsgDIM_DISP_SetDriverInitalizedMethodResult(const dimming_mainfi_tclMsgDIM_DISP_SetDriverInitalizedMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   dimming_fi_tcl_e8_DIM_Status SetDriverInitialized;
   virtual ~dimming_mainfi_tclMsgDIM_DISP_SetDriverInitalizedMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_SetDriverInitalizedMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodStart : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodStart& operator=(const dimming_mainfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodStart& coRef);
   dimming_mainfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodStart(const dimming_mainfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   dimming_fi_tcl_e8_DIM_Status SetScreenContentAvailable;
   virtual ~dimming_mainfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodResult : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodResult& operator=(const dimming_mainfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodResult& coRef);
   dimming_mainfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodResult(const dimming_mainfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   dimming_fi_tcl_e8_DIM_Status SetScreenContentAvailable;
   virtual ~dimming_mainfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_SetDimmingMethodStart : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_SetDimmingMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DISP_SetDimmingMethodStart& operator=(const dimming_mainfi_tclMsgDIM_DISP_SetDimmingMethodStart& coRef);
   dimming_mainfi_tclMsgDIM_DISP_SetDimmingMethodStart(const dimming_mainfi_tclMsgDIM_DISP_SetDimmingMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   dimming_fi_tcl_u16_DIM_Permille Brightness;
   virtual ~dimming_mainfi_tclMsgDIM_DISP_SetDimmingMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_SetDimmingMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_SetDimmingMethodResult : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_SetDimmingMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DISP_SetDimmingMethodResult& operator=(const dimming_mainfi_tclMsgDIM_DISP_SetDimmingMethodResult& coRef);
   dimming_mainfi_tclMsgDIM_DISP_SetDimmingMethodResult(const dimming_mainfi_tclMsgDIM_DISP_SetDimmingMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   dimming_fi_tcl_u16_DIM_Permille Brightness;
   virtual ~dimming_mainfi_tclMsgDIM_DISP_SetDimmingMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_SetDimmingMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_SwitchBacklightMethodStart : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_SwitchBacklightMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DISP_SwitchBacklightMethodStart& operator=(const dimming_mainfi_tclMsgDIM_DISP_SwitchBacklightMethodStart& coRef);
   dimming_mainfi_tclMsgDIM_DISP_SwitchBacklightMethodStart(const dimming_mainfi_tclMsgDIM_DISP_SwitchBacklightMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   dimming_fi_tcl_e8_DIM_Status SwitchBacklight;
   virtual ~dimming_mainfi_tclMsgDIM_DISP_SwitchBacklightMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_SwitchBacklightMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_SwitchBacklightMethodResult : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_SwitchBacklightMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DISP_SwitchBacklightMethodResult& operator=(const dimming_mainfi_tclMsgDIM_DISP_SwitchBacklightMethodResult& coRef);
   dimming_mainfi_tclMsgDIM_DISP_SwitchBacklightMethodResult(const dimming_mainfi_tclMsgDIM_DISP_SwitchBacklightMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   dimming_fi_tcl_e8_DIM_Status SwitchBacklight;
   virtual ~dimming_mainfi_tclMsgDIM_DISP_SwitchBacklightMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_SwitchBacklightMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelMethodStart : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelMethodStart& operator=(const dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelMethodStart& coRef);
   dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelMethodStart(const dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   dimming_fi_tcl_e8_DIM_BrightnessLevel BrightnessLevel;
   virtual ~dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelMethodResult : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelMethodResult& operator=(const dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelMethodResult& coRef);
   dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelMethodResult(const dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   dimming_fi_tcl_e8_DIM_BrightnessLevel BrightnessLevel;
   virtual ~dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodStart : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodStart& operator=(const dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodStart& coRef);
   dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodStart(const dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 BrightnessLevelExtended;
   virtual ~dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodResult : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodResult& operator=(const dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodResult& coRef);
   dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodResult(const dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 BrightnessLevelExtended;
   virtual ~dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodStart : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodStart& operator=(const dimming_mainfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodStart& coRef);
   dimming_mainfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodStart(const dimming_mainfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 VideoBrightnessLevelDay;
   tU8 VideoBrightnessLevelNight;
   virtual ~dimming_mainfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodResult : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodResult& operator=(const dimming_mainfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodResult& coRef);
   dimming_mainfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodResult(const dimming_mainfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 VideoBrightnessLevelDay;
   tU8 VideoBrightnessLevelNight;
   virtual ~dimming_mainfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_SetContrastLevelMethodStart : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_SetContrastLevelMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DISP_SetContrastLevelMethodStart& operator=(const dimming_mainfi_tclMsgDIM_DISP_SetContrastLevelMethodStart& coRef);
   dimming_mainfi_tclMsgDIM_DISP_SetContrastLevelMethodStart(const dimming_mainfi_tclMsgDIM_DISP_SetContrastLevelMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Contrast;
   virtual ~dimming_mainfi_tclMsgDIM_DISP_SetContrastLevelMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_SetContrastLevelMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_SetContrastLevelMethodResult : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_SetContrastLevelMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DISP_SetContrastLevelMethodResult& operator=(const dimming_mainfi_tclMsgDIM_DISP_SetContrastLevelMethodResult& coRef);
   dimming_mainfi_tclMsgDIM_DISP_SetContrastLevelMethodResult(const dimming_mainfi_tclMsgDIM_DISP_SetContrastLevelMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 BrightnessLevelExtended;
   virtual ~dimming_mainfi_tclMsgDIM_DISP_SetContrastLevelMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_SetContrastLevelMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_SetBlackLevelMethodStart : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_SetBlackLevelMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DISP_SetBlackLevelMethodStart& operator=(const dimming_mainfi_tclMsgDIM_DISP_SetBlackLevelMethodStart& coRef);
   dimming_mainfi_tclMsgDIM_DISP_SetBlackLevelMethodStart(const dimming_mainfi_tclMsgDIM_DISP_SetBlackLevelMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 BlackLevel;
   virtual ~dimming_mainfi_tclMsgDIM_DISP_SetBlackLevelMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_SetBlackLevelMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_SetBlackLevelMethodResult : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_SetBlackLevelMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DISP_SetBlackLevelMethodResult& operator=(const dimming_mainfi_tclMsgDIM_DISP_SetBlackLevelMethodResult& coRef);
   dimming_mainfi_tclMsgDIM_DISP_SetBlackLevelMethodResult(const dimming_mainfi_tclMsgDIM_DISP_SetBlackLevelMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 BlackLevel;
   virtual ~dimming_mainfi_tclMsgDIM_DISP_SetBlackLevelMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_SetBlackLevelMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_SetYCurveLevelMethodStart : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_SetYCurveLevelMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DISP_SetYCurveLevelMethodStart& operator=(const dimming_mainfi_tclMsgDIM_DISP_SetYCurveLevelMethodStart& coRef);
   dimming_mainfi_tclMsgDIM_DISP_SetYCurveLevelMethodStart(const dimming_mainfi_tclMsgDIM_DISP_SetYCurveLevelMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 YCurveLevel;
   virtual ~dimming_mainfi_tclMsgDIM_DISP_SetYCurveLevelMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_SetYCurveLevelMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_SetYCurveLevelMethodResult : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_SetYCurveLevelMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DISP_SetYCurveLevelMethodResult& operator=(const dimming_mainfi_tclMsgDIM_DISP_SetYCurveLevelMethodResult& coRef);
   dimming_mainfi_tclMsgDIM_DISP_SetYCurveLevelMethodResult(const dimming_mainfi_tclMsgDIM_DISP_SetYCurveLevelMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 YCurveLevel;
   virtual ~dimming_mainfi_tclMsgDIM_DISP_SetYCurveLevelMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_SetYCurveLevelMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_SetTintLevelMethodStart : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_SetTintLevelMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DISP_SetTintLevelMethodStart& operator=(const dimming_mainfi_tclMsgDIM_DISP_SetTintLevelMethodStart& coRef);
   dimming_mainfi_tclMsgDIM_DISP_SetTintLevelMethodStart(const dimming_mainfi_tclMsgDIM_DISP_SetTintLevelMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 TintLevel;
   virtual ~dimming_mainfi_tclMsgDIM_DISP_SetTintLevelMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_SetTintLevelMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_SetTintLevelMethodResult : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_SetTintLevelMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DISP_SetTintLevelMethodResult& operator=(const dimming_mainfi_tclMsgDIM_DISP_SetTintLevelMethodResult& coRef);
   dimming_mainfi_tclMsgDIM_DISP_SetTintLevelMethodResult(const dimming_mainfi_tclMsgDIM_DISP_SetTintLevelMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 TintLevel;
   virtual ~dimming_mainfi_tclMsgDIM_DISP_SetTintLevelMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_SetTintLevelMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_SetColorLevelMethodStart : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_SetColorLevelMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DISP_SetColorLevelMethodStart& operator=(const dimming_mainfi_tclMsgDIM_DISP_SetColorLevelMethodStart& coRef);
   dimming_mainfi_tclMsgDIM_DISP_SetColorLevelMethodStart(const dimming_mainfi_tclMsgDIM_DISP_SetColorLevelMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 ColorLevel;
   virtual ~dimming_mainfi_tclMsgDIM_DISP_SetColorLevelMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_SetColorLevelMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_SetColorLevelMethodResult : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_SetColorLevelMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DISP_SetColorLevelMethodResult& operator=(const dimming_mainfi_tclMsgDIM_DISP_SetColorLevelMethodResult& coRef);
   dimming_mainfi_tclMsgDIM_DISP_SetColorLevelMethodResult(const dimming_mainfi_tclMsgDIM_DISP_SetColorLevelMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 ColorLevel;
   virtual ~dimming_mainfi_tclMsgDIM_DISP_SetColorLevelMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_SetColorLevelMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodStart : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodStart& operator=(const dimming_mainfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodStart& coRef);
   dimming_mainfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodStart(const dimming_mainfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   dimming_fi_tcl_e8_DIM_InputConfiguration SetBrightnessInputType;
   virtual ~dimming_mainfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodResult : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodResult& operator=(const dimming_mainfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodResult& coRef);
   dimming_mainfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodResult(const dimming_mainfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   dimming_fi_tcl_e8_DIM_InputConfiguration SetBrightnessInputType;
   virtual ~dimming_mainfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_SetCSCContrastLevelMethodStart : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_SetCSCContrastLevelMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DISP_SetCSCContrastLevelMethodStart& operator=(const dimming_mainfi_tclMsgDIM_DISP_SetCSCContrastLevelMethodStart& coRef);
   dimming_mainfi_tclMsgDIM_DISP_SetCSCContrastLevelMethodStart(const dimming_mainfi_tclMsgDIM_DISP_SetCSCContrastLevelMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 ContrastLevel;
   virtual ~dimming_mainfi_tclMsgDIM_DISP_SetCSCContrastLevelMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_SetCSCContrastLevelMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_SetCSCContrastLevelMethodResult : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_SetCSCContrastLevelMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DISP_SetCSCContrastLevelMethodResult& operator=(const dimming_mainfi_tclMsgDIM_DISP_SetCSCContrastLevelMethodResult& coRef);
   dimming_mainfi_tclMsgDIM_DISP_SetCSCContrastLevelMethodResult(const dimming_mainfi_tclMsgDIM_DISP_SetCSCContrastLevelMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 ContrastLevel;
   virtual ~dimming_mainfi_tclMsgDIM_DISP_SetCSCContrastLevelMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_SetCSCContrastLevelMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_SetCSCBlackLevelMethodStart : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_SetCSCBlackLevelMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DISP_SetCSCBlackLevelMethodStart& operator=(const dimming_mainfi_tclMsgDIM_DISP_SetCSCBlackLevelMethodStart& coRef);
   dimming_mainfi_tclMsgDIM_DISP_SetCSCBlackLevelMethodStart(const dimming_mainfi_tclMsgDIM_DISP_SetCSCBlackLevelMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 BlackLevel;
   virtual ~dimming_mainfi_tclMsgDIM_DISP_SetCSCBlackLevelMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_SetCSCBlackLevelMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_SetCSCBlackLevelMethodResult : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_SetCSCBlackLevelMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DISP_SetCSCBlackLevelMethodResult& operator=(const dimming_mainfi_tclMsgDIM_DISP_SetCSCBlackLevelMethodResult& coRef);
   dimming_mainfi_tclMsgDIM_DISP_SetCSCBlackLevelMethodResult(const dimming_mainfi_tclMsgDIM_DISP_SetCSCBlackLevelMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 BlackLevel;
   virtual ~dimming_mainfi_tclMsgDIM_DISP_SetCSCBlackLevelMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_SetCSCBlackLevelMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_SetCSCGammaLevelMethodStart : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_SetCSCGammaLevelMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DISP_SetCSCGammaLevelMethodStart& operator=(const dimming_mainfi_tclMsgDIM_DISP_SetCSCGammaLevelMethodStart& coRef);
   dimming_mainfi_tclMsgDIM_DISP_SetCSCGammaLevelMethodStart(const dimming_mainfi_tclMsgDIM_DISP_SetCSCGammaLevelMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 GammaLevel;
   virtual ~dimming_mainfi_tclMsgDIM_DISP_SetCSCGammaLevelMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_SetCSCGammaLevelMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_SetCSCGammaLevelMethodResult : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_SetCSCGammaLevelMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DISP_SetCSCGammaLevelMethodResult& operator=(const dimming_mainfi_tclMsgDIM_DISP_SetCSCGammaLevelMethodResult& coRef);
   dimming_mainfi_tclMsgDIM_DISP_SetCSCGammaLevelMethodResult(const dimming_mainfi_tclMsgDIM_DISP_SetCSCGammaLevelMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 GammaLevel;
   virtual ~dimming_mainfi_tclMsgDIM_DISP_SetCSCGammaLevelMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_SetCSCGammaLevelMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_SetCSCSaturationLevelMethodStart : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_SetCSCSaturationLevelMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DISP_SetCSCSaturationLevelMethodStart& operator=(const dimming_mainfi_tclMsgDIM_DISP_SetCSCSaturationLevelMethodStart& coRef);
   dimming_mainfi_tclMsgDIM_DISP_SetCSCSaturationLevelMethodStart(const dimming_mainfi_tclMsgDIM_DISP_SetCSCSaturationLevelMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 SaturationLevel;
   virtual ~dimming_mainfi_tclMsgDIM_DISP_SetCSCSaturationLevelMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_SetCSCSaturationLevelMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_SetCSCSaturationLevelMethodResult : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_SetCSCSaturationLevelMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DISP_SetCSCSaturationLevelMethodResult& operator=(const dimming_mainfi_tclMsgDIM_DISP_SetCSCSaturationLevelMethodResult& coRef);
   dimming_mainfi_tclMsgDIM_DISP_SetCSCSaturationLevelMethodResult(const dimming_mainfi_tclMsgDIM_DISP_SetCSCSaturationLevelMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 SaturationLevel;
   virtual ~dimming_mainfi_tclMsgDIM_DISP_SetCSCSaturationLevelMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_SetCSCSaturationLevelMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_SetCSCColorLevelMethodStart : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_SetCSCColorLevelMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DISP_SetCSCColorLevelMethodStart& operator=(const dimming_mainfi_tclMsgDIM_DISP_SetCSCColorLevelMethodStart& coRef);
   dimming_mainfi_tclMsgDIM_DISP_SetCSCColorLevelMethodStart(const dimming_mainfi_tclMsgDIM_DISP_SetCSCColorLevelMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 ColorLevel;
   virtual ~dimming_mainfi_tclMsgDIM_DISP_SetCSCColorLevelMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_SetCSCColorLevelMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_SetCSCColorLevelMethodResult : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_SetCSCColorLevelMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DISP_SetCSCColorLevelMethodResult& operator=(const dimming_mainfi_tclMsgDIM_DISP_SetCSCColorLevelMethodResult& coRef);
   dimming_mainfi_tclMsgDIM_DISP_SetCSCColorLevelMethodResult(const dimming_mainfi_tclMsgDIM_DISP_SetCSCColorLevelMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 ColorLevel;
   virtual ~dimming_mainfi_tclMsgDIM_DISP_SetCSCColorLevelMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_SetCSCColorLevelMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispParameterMethodStart : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispParameterMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispParameterMethodStart& operator=(const dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispParameterMethodStart& coRef);
   dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispParameterMethodStart(const dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispParameterMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   dimming_fi_tcl_SecondDispFunctionID e16FunctionId;
   tU16 u16ParameterValue;
   virtual ~dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispParameterMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispParameterMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispParameterMethodResult : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispParameterMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispParameterMethodResult& operator=(const dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispParameterMethodResult& coRef);
   dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispParameterMethodResult(const dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispParameterMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   dimming_fi_tcl_SecondDispFunctionID e16FunctionId;
   tU16 u16ParameterValue;
   virtual ~dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispParameterMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispParameterMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispOnOffMethodStart : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispOnOffMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispOnOffMethodStart& operator=(const dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispOnOffMethodStart& coRef);
   dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispOnOffMethodStart(const dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispOnOffMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DisplayState;
   virtual ~dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispOnOffMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispOnOffMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispOnOffMethodResult : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispOnOffMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispOnOffMethodResult& operator=(const dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispOnOffMethodResult& coRef);
   dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispOnOffMethodResult(const dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispOnOffMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DisplayState;
   virtual ~dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispOnOffMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispOnOffMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_SECOND_DISP_HardwareVersionMethodStart : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_SECOND_DISP_HardwareVersionMethodStart();

   virtual ~dimming_mainfi_tclMsgDIM_SECOND_DISP_HardwareVersionMethodStart();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_SECOND_DISP_HardwareVersionMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_SECOND_DISP_HardwareVersionMethodResult : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_SECOND_DISP_HardwareVersionMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_SECOND_DISP_HardwareVersionMethodResult& operator=(const dimming_mainfi_tclMsgDIM_SECOND_DISP_HardwareVersionMethodResult& coRef);
   dimming_mainfi_tclMsgDIM_SECOND_DISP_HardwareVersionMethodResult(const dimming_mainfi_tclMsgDIM_SECOND_DISP_HardwareVersionMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   dimming_fi_tcl_SecondDisp_VersionInfo HW_VersionInfo;
   virtual ~dimming_mainfi_tclMsgDIM_SECOND_DISP_HardwareVersionMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_SECOND_DISP_HardwareVersionMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_SECOND_DISP_SoftwareVersionMethodStart : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_SECOND_DISP_SoftwareVersionMethodStart();

   virtual ~dimming_mainfi_tclMsgDIM_SECOND_DISP_SoftwareVersionMethodStart();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_SECOND_DISP_SoftwareVersionMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_SECOND_DISP_SoftwareVersionMethodResult : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_SECOND_DISP_SoftwareVersionMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_SECOND_DISP_SoftwareVersionMethodResult& operator=(const dimming_mainfi_tclMsgDIM_SECOND_DISP_SoftwareVersionMethodResult& coRef);
   dimming_mainfi_tclMsgDIM_SECOND_DISP_SoftwareVersionMethodResult(const dimming_mainfi_tclMsgDIM_SECOND_DISP_SoftwareVersionMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   dimming_fi_tcl_SecondDisp_VersionInfo SW_VersionInfo;
   virtual ~dimming_mainfi_tclMsgDIM_SECOND_DISP_SoftwareVersionMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_SECOND_DISP_SoftwareVersionMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_SECOND_DISP_GetALLParamMethodResult : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_SECOND_DISP_GetALLParamMethodResult();

   virtual ~dimming_mainfi_tclMsgDIM_SECOND_DISP_GetALLParamMethodResult();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_SECOND_DISP_GetALLParamMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_SECOND_DISP_GetALLParamMethodStart : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_SECOND_DISP_GetALLParamMethodStart();

   virtual ~dimming_mainfi_tclMsgDIM_SECOND_DISP_GetALLParamMethodStart();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_SECOND_DISP_GetALLParamMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_INFO_CarIlluminationDataUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_INFO_CarIlluminationDataUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_INFO_CarIlluminationDataUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_INFO_CarIlluminationDataUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_INFO_CarIlluminationDataRelUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_INFO_CarIlluminationDataRelUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_INFO_CarIlluminationDataRelUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_INFO_CarIlluminationDataRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_INFO_CarIlluminationDataGet : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_INFO_CarIlluminationDataGet();

   virtual ~dimming_mainfi_tclMsgDIM_INFO_CarIlluminationDataGet();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_INFO_CarIlluminationDataGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_INFO_CarIlluminationDataStatus : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_INFO_CarIlluminationDataStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_INFO_CarIlluminationDataStatus& operator=(const dimming_mainfi_tclMsgDIM_INFO_CarIlluminationDataStatus& coRef);
   dimming_mainfi_tclMsgDIM_INFO_CarIlluminationDataStatus(const dimming_mainfi_tclMsgDIM_INFO_CarIlluminationDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   dimming_fi_tcl_e8_DIM_Status IlluminationSwitch;
   dimming_fi_tcl_u16_DIM_Permille IlluminationBrightness;
   virtual ~dimming_mainfi_tclMsgDIM_INFO_CarIlluminationDataStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_INFO_CarIlluminationDataStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_INFO_LightSensorBrightnessUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_INFO_LightSensorBrightnessUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_INFO_LightSensorBrightnessUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_INFO_LightSensorBrightnessUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_INFO_LightSensorBrightnessRelUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_INFO_LightSensorBrightnessRelUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_INFO_LightSensorBrightnessRelUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_INFO_LightSensorBrightnessRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_INFO_LightSensorBrightnessGet : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_INFO_LightSensorBrightnessGet();

   virtual ~dimming_mainfi_tclMsgDIM_INFO_LightSensorBrightnessGet();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_INFO_LightSensorBrightnessGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_INFO_LightSensorBrightnessStatus : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_INFO_LightSensorBrightnessStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_INFO_LightSensorBrightnessStatus& operator=(const dimming_mainfi_tclMsgDIM_INFO_LightSensorBrightnessStatus& coRef);
   dimming_mainfi_tclMsgDIM_INFO_LightSensorBrightnessStatus(const dimming_mainfi_tclMsgDIM_INFO_LightSensorBrightnessStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   dimming_fi_tcl_e8_DIM_Status SensorAvail;
   dimming_fi_tcl_u16_DIM_Permille SensorBrightness;
   virtual ~dimming_mainfi_tclMsgDIM_INFO_LightSensorBrightnessStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_INFO_LightSensorBrightnessStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_INFO_DimmingModeUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_INFO_DimmingModeUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_INFO_DimmingModeUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_INFO_DimmingModeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_INFO_DimmingModeRelUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_INFO_DimmingModeRelUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_INFO_DimmingModeRelUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_INFO_DimmingModeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_INFO_DimmingModeGet : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_INFO_DimmingModeGet();

   virtual ~dimming_mainfi_tclMsgDIM_INFO_DimmingModeGet();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_INFO_DimmingModeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_INFO_DimmingModeStatus : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_INFO_DimmingModeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_INFO_DimmingModeStatus& operator=(const dimming_mainfi_tclMsgDIM_INFO_DimmingModeStatus& coRef);
   dimming_mainfi_tclMsgDIM_INFO_DimmingModeStatus(const dimming_mainfi_tclMsgDIM_INFO_DimmingModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   dimming_fi_tcl_e8_DIM_Mode Config;
   dimming_fi_tcl_e8_DIM_Mode Car;
   dimming_fi_tcl_e8_DIM_Mode Status;
   virtual ~dimming_mainfi_tclMsgDIM_INFO_DimmingModeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_INFO_DimmingModeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_INFO_EmulationModeUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_INFO_EmulationModeUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_INFO_EmulationModeUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_INFO_EmulationModeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_INFO_EmulationModeRelUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_INFO_EmulationModeRelUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_INFO_EmulationModeRelUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_INFO_EmulationModeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_INFO_EmulationModeGet : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_INFO_EmulationModeGet();

   virtual ~dimming_mainfi_tclMsgDIM_INFO_EmulationModeGet();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_INFO_EmulationModeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_INFO_EmulationModeStatus : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_INFO_EmulationModeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_INFO_EmulationModeStatus& operator=(const dimming_mainfi_tclMsgDIM_INFO_EmulationModeStatus& coRef);
   dimming_mainfi_tclMsgDIM_INFO_EmulationModeStatus(const dimming_mainfi_tclMsgDIM_INFO_EmulationModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   dimming_fi_tcl_e8_DIM_EmulationMode EmulationMode;
   virtual ~dimming_mainfi_tclMsgDIM_INFO_EmulationModeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_INFO_EmulationModeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_INFO_ITCUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_INFO_ITCUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_INFO_ITCUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_INFO_ITCUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_INFO_ITCRelUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_INFO_ITCRelUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_INFO_ITCRelUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_INFO_ITCRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_INFO_ITCGet : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_INFO_ITCGet();

   virtual ~dimming_mainfi_tclMsgDIM_INFO_ITCGet();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_INFO_ITCGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_INFO_ITCStatus : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_INFO_ITCStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_INFO_ITCStatus& operator=(const dimming_mainfi_tclMsgDIM_INFO_ITCStatus& coRef);
   dimming_mainfi_tclMsgDIM_INFO_ITCStatus(const dimming_mainfi_tclMsgDIM_INFO_ITCStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 ITC;
   virtual ~dimming_mainfi_tclMsgDIM_INFO_ITCStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_INFO_ITCStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_INFO_PWMBrightnessUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_INFO_PWMBrightnessUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_INFO_PWMBrightnessUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_INFO_PWMBrightnessUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_INFO_PWMBrightnessRelUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_INFO_PWMBrightnessRelUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_INFO_PWMBrightnessRelUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_INFO_PWMBrightnessRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_INFO_PWMBrightnessGet : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_INFO_PWMBrightnessGet();

   virtual ~dimming_mainfi_tclMsgDIM_INFO_PWMBrightnessGet();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_INFO_PWMBrightnessGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_INFO_PWMBrightnessStatus : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_INFO_PWMBrightnessStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_INFO_PWMBrightnessStatus& operator=(const dimming_mainfi_tclMsgDIM_INFO_PWMBrightnessStatus& coRef);
   dimming_mainfi_tclMsgDIM_INFO_PWMBrightnessStatus(const dimming_mainfi_tclMsgDIM_INFO_PWMBrightnessStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   dimming_fi_tcl_u16_DIM_Permille PWMBrightness;
   virtual ~dimming_mainfi_tclMsgDIM_INFO_PWMBrightnessStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_INFO_PWMBrightnessStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_INFO_CANBrightnessUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_INFO_CANBrightnessUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_INFO_CANBrightnessUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_INFO_CANBrightnessUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_INFO_CANBrightnessRelUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_INFO_CANBrightnessRelUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_INFO_CANBrightnessRelUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_INFO_CANBrightnessRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_INFO_CANBrightnessGet : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_INFO_CANBrightnessGet();

   virtual ~dimming_mainfi_tclMsgDIM_INFO_CANBrightnessGet();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_INFO_CANBrightnessGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_INFO_CANBrightnessStatus : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_INFO_CANBrightnessStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_INFO_CANBrightnessStatus& operator=(const dimming_mainfi_tclMsgDIM_INFO_CANBrightnessStatus& coRef);
   dimming_mainfi_tclMsgDIM_INFO_CANBrightnessStatus(const dimming_mainfi_tclMsgDIM_INFO_CANBrightnessStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   dimming_fi_tcl_u16_DIM_Permille CANBrightness;
   virtual ~dimming_mainfi_tclMsgDIM_INFO_CANBrightnessStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_INFO_CANBrightnessStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_KEYB_BrightnessUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_KEYB_BrightnessUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_KEYB_BrightnessUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_KEYB_BrightnessUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_KEYB_BrightnessRelUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_KEYB_BrightnessRelUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_KEYB_BrightnessRelUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_KEYB_BrightnessRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_KEYB_BrightnessGet : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_KEYB_BrightnessGet();

   virtual ~dimming_mainfi_tclMsgDIM_KEYB_BrightnessGet();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_KEYB_BrightnessGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_KEYB_BrightnessStatus : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_KEYB_BrightnessStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_KEYB_BrightnessStatus& operator=(const dimming_mainfi_tclMsgDIM_KEYB_BrightnessStatus& coRef);
   dimming_mainfi_tclMsgDIM_KEYB_BrightnessStatus(const dimming_mainfi_tclMsgDIM_KEYB_BrightnessStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   dimming_fi_tcl_u16_DIM_Permille Brightness;
   virtual ~dimming_mainfi_tclMsgDIM_KEYB_BrightnessStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_KEYB_BrightnessStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_KEYB_HalfclassUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_KEYB_HalfclassUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_KEYB_HalfclassUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_KEYB_HalfclassUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_KEYB_HalfclassRelUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_KEYB_HalfclassRelUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_KEYB_HalfclassRelUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_KEYB_HalfclassRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_KEYB_HalfclassGet : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_KEYB_HalfclassGet();

   virtual ~dimming_mainfi_tclMsgDIM_KEYB_HalfclassGet();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_KEYB_HalfclassGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_KEYB_HalfclassStatus : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_KEYB_HalfclassStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_KEYB_HalfclassStatus& operator=(const dimming_mainfi_tclMsgDIM_KEYB_HalfclassStatus& coRef);
   dimming_mainfi_tclMsgDIM_KEYB_HalfclassStatus(const dimming_mainfi_tclMsgDIM_KEYB_HalfclassStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   dimming_fi_tcl_u8_DIM_Halfclasses Halfclass_A;
   dimming_fi_tcl_u8_DIM_Halfclasses Halfclass_B;
   tU8 ADC_CFG_A;
   tU8 ADC_CFG_B;
   tU16 ADC_A;
   tU16 ADC_B;
   tU16 PWM_HC_A;
   tU16 PWM_HC_B;
   virtual ~dimming_mainfi_tclMsgDIM_KEYB_HalfclassStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_KEYB_HalfclassStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_DriverInitalizedUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_DriverInitalizedUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_DriverInitalizedUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_DriverInitalizedUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_DriverInitalizedRelUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_DriverInitalizedRelUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_DriverInitalizedRelUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_DriverInitalizedRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_DriverInitalizedGet : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_DriverInitalizedGet();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_DriverInitalizedGet();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_DriverInitalizedGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_DriverInitalizedStatus : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_DriverInitalizedStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DISP_DriverInitalizedStatus& operator=(const dimming_mainfi_tclMsgDIM_DISP_DriverInitalizedStatus& coRef);
   dimming_mainfi_tclMsgDIM_DISP_DriverInitalizedStatus(const dimming_mainfi_tclMsgDIM_DISP_DriverInitalizedStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   dimming_fi_tcl_e8_DIM_Status DriverInitialized;
   virtual ~dimming_mainfi_tclMsgDIM_DISP_DriverInitalizedStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_DriverInitalizedStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_ScreenContentAvailableUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_ScreenContentAvailableUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_ScreenContentAvailableUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_ScreenContentAvailableUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_ScreenContentAvailableRelUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_ScreenContentAvailableRelUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_ScreenContentAvailableRelUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_ScreenContentAvailableRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_ScreenContentAvailableGet : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_ScreenContentAvailableGet();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_ScreenContentAvailableGet();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_ScreenContentAvailableGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_ScreenContentAvailableStatus : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_ScreenContentAvailableStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DISP_ScreenContentAvailableStatus& operator=(const dimming_mainfi_tclMsgDIM_DISP_ScreenContentAvailableStatus& coRef);
   dimming_mainfi_tclMsgDIM_DISP_ScreenContentAvailableStatus(const dimming_mainfi_tclMsgDIM_DISP_ScreenContentAvailableStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   dimming_fi_tcl_e8_DIM_Status ContentAvailable;
   virtual ~dimming_mainfi_tclMsgDIM_DISP_ScreenContentAvailableStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_ScreenContentAvailableStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_BrightnessUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_BrightnessUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_BrightnessUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_BrightnessUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_BrightnessRelUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_BrightnessRelUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_BrightnessRelUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_BrightnessRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_BrightnessGet : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_BrightnessGet();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_BrightnessGet();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_BrightnessGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_BrightnessStatus : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_BrightnessStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DISP_BrightnessStatus& operator=(const dimming_mainfi_tclMsgDIM_DISP_BrightnessStatus& coRef);
   dimming_mainfi_tclMsgDIM_DISP_BrightnessStatus(const dimming_mainfi_tclMsgDIM_DISP_BrightnessStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   dimming_fi_tcl_u16_DIM_Permille Brightness;
   virtual ~dimming_mainfi_tclMsgDIM_DISP_BrightnessStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_BrightnessStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_BacklightUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_BacklightUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_BacklightUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_BacklightUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_BacklightRelUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_BacklightRelUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_BacklightRelUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_BacklightRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_BacklightGet : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_BacklightGet();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_BacklightGet();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_BacklightGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_BacklightStatus : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_BacklightStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DISP_BacklightStatus& operator=(const dimming_mainfi_tclMsgDIM_DISP_BacklightStatus& coRef);
   dimming_mainfi_tclMsgDIM_DISP_BacklightStatus(const dimming_mainfi_tclMsgDIM_DISP_BacklightStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   dimming_fi_tcl_e8_DIM_Status BacklightStatus;
   virtual ~dimming_mainfi_tclMsgDIM_DISP_BacklightStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_BacklightStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_TemperatureInfoUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_TemperatureInfoUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_TemperatureInfoUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_TemperatureInfoUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_TemperatureInfoRelUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_TemperatureInfoRelUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_TemperatureInfoRelUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_TemperatureInfoRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_TemperatureInfoGet : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_TemperatureInfoGet();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_TemperatureInfoGet();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_TemperatureInfoGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_TemperatureInfoStatus : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_TemperatureInfoStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DISP_TemperatureInfoStatus& operator=(const dimming_mainfi_tclMsgDIM_DISP_TemperatureInfoStatus& coRef);
   dimming_mainfi_tclMsgDIM_DISP_TemperatureInfoStatus(const dimming_mainfi_tclMsgDIM_DISP_TemperatureInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   dimming_fi_tcl_s16_DIM_Temperature PanelTemp;
   dimming_fi_tcl_s16_DIM_Temperature AmbientTemp;
   dimming_fi_tcl_e8_DIM_WarningLevel WarningLevel;
   tU16 CriticalLevelTimeout;
   tU16 CriticalLevelElapsed;
   virtual ~dimming_mainfi_tclMsgDIM_DISP_TemperatureInfoStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_TemperatureInfoStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_SizeUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_SizeUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_SizeUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_SizeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_SizeRelUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_SizeRelUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_SizeRelUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_SizeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_SizeGet : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_SizeGet();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_SizeGet();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_SizeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_SizeStatus : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_SizeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DISP_SizeStatus& operator=(const dimming_mainfi_tclMsgDIM_DISP_SizeStatus& coRef);
   dimming_mainfi_tclMsgDIM_DISP_SizeStatus(const dimming_mainfi_tclMsgDIM_DISP_SizeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   dimming_fi_tcl_e8_DIM_DisplaySize Size;
   virtual ~dimming_mainfi_tclMsgDIM_DISP_SizeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_SizeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelRelUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelRelUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelRelUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelGet : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelGet();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelGet();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelStatus : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelStatus& operator=(const dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelStatus& coRef);
   dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelStatus(const dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   dimming_fi_tcl_e8_DIM_BrightnessLevel BrightnessLevel;
   virtual ~dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_PanelTemperatureUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_PanelTemperatureUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_PanelTemperatureUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_PanelTemperatureUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_PanelTemperatureRelUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_PanelTemperatureRelUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_PanelTemperatureRelUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_PanelTemperatureRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_PanelTemperatureGet : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_PanelTemperatureGet();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_PanelTemperatureGet();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_PanelTemperatureGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_PanelTemperatureStatus : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_PanelTemperatureStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DISP_PanelTemperatureStatus& operator=(const dimming_mainfi_tclMsgDIM_DISP_PanelTemperatureStatus& coRef);
   dimming_mainfi_tclMsgDIM_DISP_PanelTemperatureStatus(const dimming_mainfi_tclMsgDIM_DISP_PanelTemperatureStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   dimming_fi_tcl_s16_DIM_Temperature Temperature;
   virtual ~dimming_mainfi_tclMsgDIM_DISP_PanelTemperatureStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_PanelTemperatureStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelExtendedUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelExtendedUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelExtendedUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelExtendedUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelExtendedRelUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelExtendedRelUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelExtendedRelUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelExtendedRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelExtendedGet : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelExtendedGet();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelExtendedGet();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelExtendedGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelExtendedStatus : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelExtendedStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelExtendedStatus& operator=(const dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelExtendedStatus& coRef);
   dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelExtendedStatus(const dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelExtendedStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 BrightnessLevelExtended;
   virtual ~dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelExtendedStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelExtendedStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_VideoBrightnessLevelUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_VideoBrightnessLevelUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_VideoBrightnessLevelUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_VideoBrightnessLevelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_VideoBrightnessLevelRelUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_VideoBrightnessLevelRelUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_VideoBrightnessLevelRelUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_VideoBrightnessLevelRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_VideoBrightnessLevelGet : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_VideoBrightnessLevelGet();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_VideoBrightnessLevelGet();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_VideoBrightnessLevelGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_VideoBrightnessLevelStatus : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_VideoBrightnessLevelStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DISP_VideoBrightnessLevelStatus& operator=(const dimming_mainfi_tclMsgDIM_DISP_VideoBrightnessLevelStatus& coRef);
   dimming_mainfi_tclMsgDIM_DISP_VideoBrightnessLevelStatus(const dimming_mainfi_tclMsgDIM_DISP_VideoBrightnessLevelStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 VideoBrightnessLevel;
   virtual ~dimming_mainfi_tclMsgDIM_DISP_VideoBrightnessLevelStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_VideoBrightnessLevelStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_ContrastLevelUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_ContrastLevelUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_ContrastLevelUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_ContrastLevelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_ContrastLevelRelUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_ContrastLevelRelUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_ContrastLevelRelUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_ContrastLevelRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_ContrastLevelGet : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_ContrastLevelGet();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_ContrastLevelGet();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_ContrastLevelGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_ContrastLevelStatus : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_ContrastLevelStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DISP_ContrastLevelStatus& operator=(const dimming_mainfi_tclMsgDIM_DISP_ContrastLevelStatus& coRef);
   dimming_mainfi_tclMsgDIM_DISP_ContrastLevelStatus(const dimming_mainfi_tclMsgDIM_DISP_ContrastLevelStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Contrast;
   virtual ~dimming_mainfi_tclMsgDIM_DISP_ContrastLevelStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_ContrastLevelStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_BlackLevelUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_BlackLevelUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_BlackLevelUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_BlackLevelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_BlackLevelRelUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_BlackLevelRelUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_BlackLevelRelUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_BlackLevelRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_BlackLevelGet : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_BlackLevelGet();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_BlackLevelGet();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_BlackLevelGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_BlackLevelStatus : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_BlackLevelStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DISP_BlackLevelStatus& operator=(const dimming_mainfi_tclMsgDIM_DISP_BlackLevelStatus& coRef);
   dimming_mainfi_tclMsgDIM_DISP_BlackLevelStatus(const dimming_mainfi_tclMsgDIM_DISP_BlackLevelStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 BlackLevel;
   virtual ~dimming_mainfi_tclMsgDIM_DISP_BlackLevelStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_BlackLevelStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_YCurveLevelUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_YCurveLevelUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_YCurveLevelUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_YCurveLevelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_YCurveLevelRelUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_YCurveLevelRelUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_YCurveLevelRelUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_YCurveLevelRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_YCurveLevelGet : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_YCurveLevelGet();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_YCurveLevelGet();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_YCurveLevelGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_YCurveLevelStatus : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_YCurveLevelStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DISP_YCurveLevelStatus& operator=(const dimming_mainfi_tclMsgDIM_DISP_YCurveLevelStatus& coRef);
   dimming_mainfi_tclMsgDIM_DISP_YCurveLevelStatus(const dimming_mainfi_tclMsgDIM_DISP_YCurveLevelStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 YCurveLevel;
   virtual ~dimming_mainfi_tclMsgDIM_DISP_YCurveLevelStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_YCurveLevelStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_TintLevelUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_TintLevelUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_TintLevelUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_TintLevelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_TintLevelRelUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_TintLevelRelUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_TintLevelRelUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_TintLevelRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_TintLevelGet : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_TintLevelGet();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_TintLevelGet();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_TintLevelGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_TintLevelStatus : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_TintLevelStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DISP_TintLevelStatus& operator=(const dimming_mainfi_tclMsgDIM_DISP_TintLevelStatus& coRef);
   dimming_mainfi_tclMsgDIM_DISP_TintLevelStatus(const dimming_mainfi_tclMsgDIM_DISP_TintLevelStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 TintLevel;
   virtual ~dimming_mainfi_tclMsgDIM_DISP_TintLevelStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_TintLevelStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_ColorLevelUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_ColorLevelUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_ColorLevelUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_ColorLevelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_ColorLevelRelUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_ColorLevelRelUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_ColorLevelRelUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_ColorLevelRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_ColorLevelGet : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_ColorLevelGet();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_ColorLevelGet();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_ColorLevelGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_ColorLevelStatus : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_ColorLevelStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DISP_ColorLevelStatus& operator=(const dimming_mainfi_tclMsgDIM_DISP_ColorLevelStatus& coRef);
   dimming_mainfi_tclMsgDIM_DISP_ColorLevelStatus(const dimming_mainfi_tclMsgDIM_DISP_ColorLevelStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Color;
   virtual ~dimming_mainfi_tclMsgDIM_DISP_ColorLevelStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_ColorLevelStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETRelUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETRelUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETRelUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETGet : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETGet();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETGet();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETSet : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETSet& operator=(const dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETSet& coRef);
   dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETSet(const dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 DayLuminosityOffset;
   virtual ~dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETStatus : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETStatus& operator=(const dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETStatus& coRef);
   dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETStatus(const dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 DayLuminosityOffset;
   virtual ~dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETRelUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETRelUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETRelUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETGet : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETGet();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETGet();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETSet : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETSet& operator=(const dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETSet& coRef);
   dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETSet(const dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 NightLuminosityOffset;
   virtual ~dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETStatus : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETStatus& operator=(const dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETStatus& coRef);
   dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETStatus(const dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 NightLuminosityOffset;
   virtual ~dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETRelUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETRelUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETRelUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETGet : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETGet();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETGet();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETSet : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETSet& operator=(const dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETSet& coRef);
   dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETSet(const dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 CockpitDimmingSliderOffset;
   virtual ~dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETStatus : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETStatus& operator=(const dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETStatus& coRef);
   dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETStatus(const dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 CockpitDimmingSliderOffset;
   virtual ~dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DIAG_VariantUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DIAG_VariantUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_DIAG_VariantUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DIAG_VariantUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DIAG_VariantRelUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DIAG_VariantRelUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_DIAG_VariantRelUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DIAG_VariantRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DIAG_VariantGet : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DIAG_VariantGet();

   virtual ~dimming_mainfi_tclMsgDIM_DIAG_VariantGet();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DIAG_VariantGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DIAG_VariantStatus : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DIAG_VariantStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DIAG_VariantStatus& operator=(const dimming_mainfi_tclMsgDIM_DIAG_VariantStatus& coRef);
   dimming_mainfi_tclMsgDIM_DIAG_VariantStatus(const dimming_mainfi_tclMsgDIM_DIAG_VariantStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Variant;
   virtual ~dimming_mainfi_tclMsgDIM_DIAG_VariantStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DIAG_VariantStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DIAG_BrightnessInputTypeUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DIAG_BrightnessInputTypeUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_DIAG_BrightnessInputTypeUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DIAG_BrightnessInputTypeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DIAG_BrightnessInputTypeRelUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DIAG_BrightnessInputTypeRelUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_DIAG_BrightnessInputTypeRelUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DIAG_BrightnessInputTypeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DIAG_BrightnessInputTypeGet : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DIAG_BrightnessInputTypeGet();

   virtual ~dimming_mainfi_tclMsgDIM_DIAG_BrightnessInputTypeGet();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DIAG_BrightnessInputTypeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DIAG_BrightnessInputTypeStatus : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DIAG_BrightnessInputTypeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DIAG_BrightnessInputTypeStatus& operator=(const dimming_mainfi_tclMsgDIM_DIAG_BrightnessInputTypeStatus& coRef);
   dimming_mainfi_tclMsgDIM_DIAG_BrightnessInputTypeStatus(const dimming_mainfi_tclMsgDIM_DIAG_BrightnessInputTypeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   dimming_fi_tcl_e8_DIM_InputConfiguration InputConfiguration;
   virtual ~dimming_mainfi_tclMsgDIM_DIAG_BrightnessInputTypeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DIAG_BrightnessInputTypeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_CSCContrastLevelUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_CSCContrastLevelUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_CSCContrastLevelUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_CSCContrastLevelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_CSCContrastLevelRelUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_CSCContrastLevelRelUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_CSCContrastLevelRelUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_CSCContrastLevelRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_CSCContrastLevelGet : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_CSCContrastLevelGet();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_CSCContrastLevelGet();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_CSCContrastLevelGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_CSCContrastLevelStatus : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_CSCContrastLevelStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DISP_CSCContrastLevelStatus& operator=(const dimming_mainfi_tclMsgDIM_DISP_CSCContrastLevelStatus& coRef);
   dimming_mainfi_tclMsgDIM_DISP_CSCContrastLevelStatus(const dimming_mainfi_tclMsgDIM_DISP_CSCContrastLevelStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 ContrastLevel;
   virtual ~dimming_mainfi_tclMsgDIM_DISP_CSCContrastLevelStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_CSCContrastLevelStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_CSCBlackLevelUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_CSCBlackLevelUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_CSCBlackLevelUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_CSCBlackLevelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_CSCBlackLevelRelUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_CSCBlackLevelRelUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_CSCBlackLevelRelUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_CSCBlackLevelRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_CSCBlackLevelGet : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_CSCBlackLevelGet();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_CSCBlackLevelGet();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_CSCBlackLevelGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_CSCBlackLevelStatus : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_CSCBlackLevelStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DISP_CSCBlackLevelStatus& operator=(const dimming_mainfi_tclMsgDIM_DISP_CSCBlackLevelStatus& coRef);
   dimming_mainfi_tclMsgDIM_DISP_CSCBlackLevelStatus(const dimming_mainfi_tclMsgDIM_DISP_CSCBlackLevelStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 BlackLevel;
   virtual ~dimming_mainfi_tclMsgDIM_DISP_CSCBlackLevelStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_CSCBlackLevelStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_CSCGammaLevelUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_CSCGammaLevelUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_CSCGammaLevelUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_CSCGammaLevelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_CSCGammaLevelRelUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_CSCGammaLevelRelUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_CSCGammaLevelRelUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_CSCGammaLevelRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_CSCGammaLevelGet : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_CSCGammaLevelGet();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_CSCGammaLevelGet();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_CSCGammaLevelGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_CSCGammaLevelStatus : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_CSCGammaLevelStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DISP_CSCGammaLevelStatus& operator=(const dimming_mainfi_tclMsgDIM_DISP_CSCGammaLevelStatus& coRef);
   dimming_mainfi_tclMsgDIM_DISP_CSCGammaLevelStatus(const dimming_mainfi_tclMsgDIM_DISP_CSCGammaLevelStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 GammaLevel;
   virtual ~dimming_mainfi_tclMsgDIM_DISP_CSCGammaLevelStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_CSCGammaLevelStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_CSCSaturationLevelUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_CSCSaturationLevelUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_CSCSaturationLevelUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_CSCSaturationLevelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_CSCSaturationLevelRelUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_CSCSaturationLevelRelUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_CSCSaturationLevelRelUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_CSCSaturationLevelRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_CSCSaturationLevelGet : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_CSCSaturationLevelGet();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_CSCSaturationLevelGet();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_CSCSaturationLevelGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_CSCSaturationLevelStatus : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_CSCSaturationLevelStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DISP_CSCSaturationLevelStatus& operator=(const dimming_mainfi_tclMsgDIM_DISP_CSCSaturationLevelStatus& coRef);
   dimming_mainfi_tclMsgDIM_DISP_CSCSaturationLevelStatus(const dimming_mainfi_tclMsgDIM_DISP_CSCSaturationLevelStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 SaturationLevel;
   virtual ~dimming_mainfi_tclMsgDIM_DISP_CSCSaturationLevelStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_CSCSaturationLevelStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_CSCColorLevelUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_CSCColorLevelUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_CSCColorLevelUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_CSCColorLevelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_CSCColorLevelRelUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_CSCColorLevelRelUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_CSCColorLevelRelUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_CSCColorLevelRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_CSCColorLevelGet : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_CSCColorLevelGet();

   virtual ~dimming_mainfi_tclMsgDIM_DISP_CSCColorLevelGet();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_CSCColorLevelGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_DISP_CSCColorLevelStatus : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_DISP_CSCColorLevelStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_DISP_CSCColorLevelStatus& operator=(const dimming_mainfi_tclMsgDIM_DISP_CSCColorLevelStatus& coRef);
   dimming_mainfi_tclMsgDIM_DISP_CSCColorLevelStatus(const dimming_mainfi_tclMsgDIM_DISP_CSCColorLevelStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 ColorLevel;
   virtual ~dimming_mainfi_tclMsgDIM_DISP_CSCColorLevelStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_DISP_CSCColorLevelStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_SECOND_DISP_AllDisplayParamGet : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_SECOND_DISP_AllDisplayParamGet();

   virtual ~dimming_mainfi_tclMsgDIM_SECOND_DISP_AllDisplayParamGet();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_SECOND_DISP_AllDisplayParamGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_SECOND_DISP_AllDisplayParamUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_SECOND_DISP_AllDisplayParamUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_SECOND_DISP_AllDisplayParamUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_SECOND_DISP_AllDisplayParamUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_SECOND_DISP_AllDisplayParamRelUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_SECOND_DISP_AllDisplayParamRelUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_SECOND_DISP_AllDisplayParamRelUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_SECOND_DISP_AllDisplayParamRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_SECOND_DISP_AllDisplayParamStatus : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_SECOND_DISP_AllDisplayParamStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_SECOND_DISP_AllDisplayParamStatus& operator=(const dimming_mainfi_tclMsgDIM_SECOND_DISP_AllDisplayParamStatus& coRef);
   dimming_mainfi_tclMsgDIM_SECOND_DISP_AllDisplayParamStatus(const dimming_mainfi_tclMsgDIM_SECOND_DISP_AllDisplayParamStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8BlackLevel;
   tU8 u8Brightness;
   tU8 u8Color;
   tU8 u8Contrast;
   tU8 u8Tint;
   tU16 u8GammaLevel;
   virtual ~dimming_mainfi_tclMsgDIM_SECOND_DISP_AllDisplayParamStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_SECOND_DISP_AllDisplayParamStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_SECOND_DISP_SelfDiagnosisResultGet : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_SECOND_DISP_SelfDiagnosisResultGet();

   virtual ~dimming_mainfi_tclMsgDIM_SECOND_DISP_SelfDiagnosisResultGet();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_SECOND_DISP_SelfDiagnosisResultGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_SECOND_DISP_SelfDiagnosisResultUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_SECOND_DISP_SelfDiagnosisResultUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_SECOND_DISP_SelfDiagnosisResultUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_SECOND_DISP_SelfDiagnosisResultUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_SECOND_DISP_SelfDiagnosisResultRelUpReg : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_SECOND_DISP_SelfDiagnosisResultRelUpReg();

   virtual ~dimming_mainfi_tclMsgDIM_SECOND_DISP_SelfDiagnosisResultRelUpReg();

   inline tBool operator==(const dimming_mainfi_tclMsgDIM_SECOND_DISP_SelfDiagnosisResultRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class dimming_mainfi_tclMsgDIM_SECOND_DISP_SelfDiagnosisResultStatus : public dimming_mainfi_tclMsgBaseMessage
{
public:

   dimming_mainfi_tclMsgDIM_SECOND_DISP_SelfDiagnosisResultStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dimming_mainfi_tclMsgDIM_SECOND_DISP_SelfDiagnosisResultStatus& operator=(const dimming_mainfi_tclMsgDIM_SECOND_DISP_SelfDiagnosisResultStatus& coRef);
   dimming_mainfi_tclMsgDIM_SECOND_DISP_SelfDiagnosisResultStatus(const dimming_mainfi_tclMsgDIM_SECOND_DISP_SelfDiagnosisResultStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16SelfDiagResult ;
   virtual ~dimming_mainfi_tclMsgDIM_SECOND_DISP_SelfDiagnosisResultStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const dimming_mainfi_tclMsgDIM_SECOND_DISP_SelfDiagnosisResultStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
