/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define DIMMING_FI_S_IMPORT_INTERFACE_DIMMING_MAINFI_TYPES
#define DIMMING_FI_S_IMPORT_INTERFACE_DIMMING_MAINFI_FUNCTIONIDS
#define DIMMING_FI_S_IMPORT_INTERFACE_DIMMING_MAINFI_SERVICEINFO
#include "dimming_fi_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for dimming_main_fi message types

fi_tclMessageBase* dimming_mainfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case dimming_mainfi_tclToken::EN_MSG_FI_VD_DIMMING_DEFAULTMETHODSTART:
         return OSAL_NEW dimming_mainfi_tclMsgFI_VD_DIMMING_DEFAULTMethodStart;

      case dimming_mainfi_tclToken::EN_MSG_FI_VD_DIMMING_DEFAULTMETHODRESULT:
         return OSAL_NEW dimming_mainfi_tclMsgFI_VD_DIMMING_DEFAULTMethodResult;

      case dimming_mainfi_tclToken::EN_MSG_DIM_INFO_SETDIMMINGMODEMETHODSTART:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_INFO_SetDimmingModeMethodStart;

      case dimming_mainfi_tclToken::EN_MSG_DIM_INFO_SETDIMMINGMODEMETHODRESULT:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_INFO_SetDimmingModeMethodResult;

      case dimming_mainfi_tclToken::EN_MSG_DIM_INFO_SETEMULATIONMODEMETHODSTART:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_INFO_SetEmulationModeMethodStart;

      case dimming_mainfi_tclToken::EN_MSG_DIM_INFO_SETEMULATIONMODEMETHODRESULT:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_INFO_SetEmulationModeMethodResult;

      case dimming_mainfi_tclToken::EN_MSG_DIM_INFO_SETDIMMINGSTATEMETHODSTART:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_INFO_SetDimmingStateMethodStart;

      case dimming_mainfi_tclToken::EN_MSG_DIM_INFO_SETDIMMINGSTATEMETHODRESULT:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_INFO_SetDimmingStateMethodResult;

      case dimming_mainfi_tclToken::EN_MSG_DIM_INFO_GETDIMMINGSTATEMETHODSTART:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_INFO_GetDimmingStateMethodStart;

      case dimming_mainfi_tclToken::EN_MSG_DIM_INFO_GETDIMMINGSTATEMETHODRESULT:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_INFO_GetDimmingStateMethodResult;

      case dimming_mainfi_tclToken::EN_MSG_DIM_INFO_SETDIMMINGBRIGHTNESSMETHODSTART:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodStart;

      case dimming_mainfi_tclToken::EN_MSG_DIM_INFO_SETDIMMINGBRIGHTNESSMETHODRESULT:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodResult;

      case dimming_mainfi_tclToken::EN_MSG_DIM_INFO_GETDIMMINGBRIGHTNESSMETHODSTART:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodStart;

      case dimming_mainfi_tclToken::EN_MSG_DIM_INFO_GETDIMMINGBRIGHTNESSMETHODRESULT:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodResult;

      case dimming_mainfi_tclToken::EN_MSG_DIM_INFO_GETPWMBRIGHTNESSMETHODSTART:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_INFO_GetPWMBrightnessMethodStart;

      case dimming_mainfi_tclToken::EN_MSG_DIM_INFO_GETPWMBRIGHTNESSMETHODRESULT:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_INFO_GetPWMBrightnessMethodResult;

      case dimming_mainfi_tclToken::EN_MSG_DIM_KEYB_SETDIMMINGMETHODSTART:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_KEYB_SetDimmingMethodStart;

      case dimming_mainfi_tclToken::EN_MSG_DIM_KEYB_SETDIMMINGMETHODRESULT:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_KEYB_SetDimmingMethodResult;

      case dimming_mainfi_tclToken::EN_MSG_DIM_KEYB_SETDIMMINGPWMMETHODSTART:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_KEYB_SetDimmingPWMMethodStart;

      case dimming_mainfi_tclToken::EN_MSG_DIM_KEYB_SETDIMMINGPWMMETHODRESULT:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_KEYB_SetDimmingPWMMethodResult;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETDRIVERINITALIZEDMETHODSTART:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_SetDriverInitalizedMethodStart;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETDRIVERINITALIZEDMETHODRESULT:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_SetDriverInitalizedMethodResult;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETSCREENCONTENTAVAILABLEMETHODSTART:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodStart;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETSCREENCONTENTAVAILABLEMETHODRESULT:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodResult;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETDIMMINGMETHODSTART:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_SetDimmingMethodStart;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETDIMMINGMETHODRESULT:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_SetDimmingMethodResult;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SWITCHBACKLIGHTMETHODSTART:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_SwitchBacklightMethodStart;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SWITCHBACKLIGHTMETHODRESULT:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_SwitchBacklightMethodResult;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETBRIGHTNESSLEVELMETHODSTART:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelMethodStart;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETBRIGHTNESSLEVELMETHODRESULT:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelMethodResult;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETBRIGHTNESSLEVELEXTENDEDMETHODSTART:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodStart;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETBRIGHTNESSLEVELEXTENDEDMETHODRESULT:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodResult;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETVIDEOBRIGHTNESSLEVELMETHODSTART:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodStart;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETVIDEOBRIGHTNESSLEVELMETHODRESULT:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodResult;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETCONTRASTLEVELMETHODSTART:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_SetContrastLevelMethodStart;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETCONTRASTLEVELMETHODRESULT:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_SetContrastLevelMethodResult;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETBLACKLEVELMETHODSTART:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_SetBlackLevelMethodStart;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETBLACKLEVELMETHODRESULT:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_SetBlackLevelMethodResult;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETYCURVELEVELMETHODSTART:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_SetYCurveLevelMethodStart;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETYCURVELEVELMETHODRESULT:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_SetYCurveLevelMethodResult;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETTINTLEVELMETHODSTART:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_SetTintLevelMethodStart;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETTINTLEVELMETHODRESULT:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_SetTintLevelMethodResult;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETCOLORLEVELMETHODSTART:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_SetColorLevelMethodStart;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETCOLORLEVELMETHODRESULT:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_SetColorLevelMethodResult;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DIAG_SETBRIGHTNESSINPUTTYPEMETHODSTART:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodStart;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DIAG_SETBRIGHTNESSINPUTTYPEMETHODRESULT:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodResult;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETCSCCONTRASTLEVELMETHODSTART:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_SetCSCContrastLevelMethodStart;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETCSCCONTRASTLEVELMETHODRESULT:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_SetCSCContrastLevelMethodResult;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETCSCBLACKLEVELMETHODSTART:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_SetCSCBlackLevelMethodStart;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETCSCBLACKLEVELMETHODRESULT:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_SetCSCBlackLevelMethodResult;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETCSCGAMMALEVELMETHODSTART:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_SetCSCGammaLevelMethodStart;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETCSCGAMMALEVELMETHODRESULT:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_SetCSCGammaLevelMethodResult;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETCSCSATURATIONLEVELMETHODSTART:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_SetCSCSaturationLevelMethodStart;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETCSCSATURATIONLEVELMETHODRESULT:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_SetCSCSaturationLevelMethodResult;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETCSCCOLORLEVELMETHODSTART:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_SetCSCColorLevelMethodStart;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETCSCCOLORLEVELMETHODRESULT:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_SetCSCColorLevelMethodResult;

      case dimming_mainfi_tclToken::EN_MSG_DIM_SECOND_DISP_SETDISPPARAMETERMETHODSTART:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispParameterMethodStart;

      case dimming_mainfi_tclToken::EN_MSG_DIM_SECOND_DISP_SETDISPPARAMETERMETHODRESULT:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispParameterMethodResult;

      case dimming_mainfi_tclToken::EN_MSG_DIM_SECOND_DISP_SETDISPONOFFMETHODSTART:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispOnOffMethodStart;

      case dimming_mainfi_tclToken::EN_MSG_DIM_SECOND_DISP_SETDISPONOFFMETHODRESULT:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispOnOffMethodResult;

      case dimming_mainfi_tclToken::EN_MSG_DIM_SECOND_DISP_HARDWAREVERSIONMETHODSTART:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_SECOND_DISP_HardwareVersionMethodStart;

      case dimming_mainfi_tclToken::EN_MSG_DIM_SECOND_DISP_HARDWAREVERSIONMETHODRESULT:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_SECOND_DISP_HardwareVersionMethodResult;

      case dimming_mainfi_tclToken::EN_MSG_DIM_SECOND_DISP_SOFTWAREVERSIONMETHODSTART:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_SECOND_DISP_SoftwareVersionMethodStart;

      case dimming_mainfi_tclToken::EN_MSG_DIM_SECOND_DISP_SOFTWAREVERSIONMETHODRESULT:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_SECOND_DISP_SoftwareVersionMethodResult;

      case dimming_mainfi_tclToken::EN_MSG_DIM_SECOND_DISP_GETALLPARAMMETHODRESULT:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_SECOND_DISP_GetALLParamMethodResult;

      case dimming_mainfi_tclToken::EN_MSG_DIM_SECOND_DISP_GETALLPARAMMETHODSTART:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_SECOND_DISP_GetALLParamMethodStart;

      case dimming_mainfi_tclToken::EN_MSG_DIM_INFO_CARILLUMINATIONDATAUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_INFO_CarIlluminationDataUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_INFO_CARILLUMINATIONDATARELUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_INFO_CarIlluminationDataRelUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_INFO_CARILLUMINATIONDATAGET:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_INFO_CarIlluminationDataGet;

      case dimming_mainfi_tclToken::EN_MSG_DIM_INFO_CARILLUMINATIONDATASTATUS:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_INFO_CarIlluminationDataStatus;

      case dimming_mainfi_tclToken::EN_MSG_DIM_INFO_LIGHTSENSORBRIGHTNESSUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_INFO_LightSensorBrightnessUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_INFO_LIGHTSENSORBRIGHTNESSRELUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_INFO_LightSensorBrightnessRelUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_INFO_LIGHTSENSORBRIGHTNESSGET:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_INFO_LightSensorBrightnessGet;

      case dimming_mainfi_tclToken::EN_MSG_DIM_INFO_LIGHTSENSORBRIGHTNESSSTATUS:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_INFO_LightSensorBrightnessStatus;

      case dimming_mainfi_tclToken::EN_MSG_DIM_INFO_DIMMINGMODEUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_INFO_DimmingModeUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_INFO_DIMMINGMODERELUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_INFO_DimmingModeRelUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_INFO_DIMMINGMODEGET:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_INFO_DimmingModeGet;

      case dimming_mainfi_tclToken::EN_MSG_DIM_INFO_DIMMINGMODESTATUS:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_INFO_DimmingModeStatus;

      case dimming_mainfi_tclToken::EN_MSG_DIM_INFO_EMULATIONMODEUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_INFO_EmulationModeUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_INFO_EMULATIONMODERELUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_INFO_EmulationModeRelUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_INFO_EMULATIONMODEGET:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_INFO_EmulationModeGet;

      case dimming_mainfi_tclToken::EN_MSG_DIM_INFO_EMULATIONMODESTATUS:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_INFO_EmulationModeStatus;

      case dimming_mainfi_tclToken::EN_MSG_DIM_INFO_ITCUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_INFO_ITCUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_INFO_ITCRELUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_INFO_ITCRelUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_INFO_ITCGET:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_INFO_ITCGet;

      case dimming_mainfi_tclToken::EN_MSG_DIM_INFO_ITCSTATUS:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_INFO_ITCStatus;

      case dimming_mainfi_tclToken::EN_MSG_DIM_INFO_PWMBRIGHTNESSUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_INFO_PWMBrightnessUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_INFO_PWMBRIGHTNESSRELUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_INFO_PWMBrightnessRelUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_INFO_PWMBRIGHTNESSGET:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_INFO_PWMBrightnessGet;

      case dimming_mainfi_tclToken::EN_MSG_DIM_INFO_PWMBRIGHTNESSSTATUS:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_INFO_PWMBrightnessStatus;

      case dimming_mainfi_tclToken::EN_MSG_DIM_INFO_CANBRIGHTNESSUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_INFO_CANBrightnessUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_INFO_CANBRIGHTNESSRELUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_INFO_CANBrightnessRelUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_INFO_CANBRIGHTNESSGET:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_INFO_CANBrightnessGet;

      case dimming_mainfi_tclToken::EN_MSG_DIM_INFO_CANBRIGHTNESSSTATUS:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_INFO_CANBrightnessStatus;

      case dimming_mainfi_tclToken::EN_MSG_DIM_KEYB_BRIGHTNESSUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_KEYB_BrightnessUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_KEYB_BRIGHTNESSRELUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_KEYB_BrightnessRelUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_KEYB_BRIGHTNESSGET:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_KEYB_BrightnessGet;

      case dimming_mainfi_tclToken::EN_MSG_DIM_KEYB_BRIGHTNESSSTATUS:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_KEYB_BrightnessStatus;

      case dimming_mainfi_tclToken::EN_MSG_DIM_KEYB_HALFCLASSUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_KEYB_HalfclassUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_KEYB_HALFCLASSRELUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_KEYB_HalfclassRelUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_KEYB_HALFCLASSGET:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_KEYB_HalfclassGet;

      case dimming_mainfi_tclToken::EN_MSG_DIM_KEYB_HALFCLASSSTATUS:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_KEYB_HalfclassStatus;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_DRIVERINITALIZEDUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_DriverInitalizedUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_DRIVERINITALIZEDRELUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_DriverInitalizedRelUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_DRIVERINITALIZEDGET:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_DriverInitalizedGet;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_DRIVERINITALIZEDSTATUS:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_DriverInitalizedStatus;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SCREENCONTENTAVAILABLEUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_ScreenContentAvailableUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SCREENCONTENTAVAILABLERELUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_ScreenContentAvailableRelUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SCREENCONTENTAVAILABLEGET:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_ScreenContentAvailableGet;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SCREENCONTENTAVAILABLESTATUS:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_ScreenContentAvailableStatus;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_BRIGHTNESSUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_BrightnessUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_BRIGHTNESSRELUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_BrightnessRelUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_BRIGHTNESSGET:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_BrightnessGet;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_BRIGHTNESSSTATUS:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_BrightnessStatus;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_BACKLIGHTUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_BacklightUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_BACKLIGHTRELUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_BacklightRelUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_BACKLIGHTGET:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_BacklightGet;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_BACKLIGHTSTATUS:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_BacklightStatus;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_TEMPERATUREINFOUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_TemperatureInfoUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_TEMPERATUREINFORELUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_TemperatureInfoRelUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_TEMPERATUREINFOGET:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_TemperatureInfoGet;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_TEMPERATUREINFOSTATUS:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_TemperatureInfoStatus;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SIZEUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_SizeUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SIZERELUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_SizeRelUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SIZEGET:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_SizeGet;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SIZESTATUS:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_SizeStatus;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_BRIGHTNESSLEVELUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_BRIGHTNESSLEVELRELUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelRelUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_BRIGHTNESSLEVELGET:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelGet;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_BRIGHTNESSLEVELSTATUS:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelStatus;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_PANELTEMPERATUREUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_PanelTemperatureUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_PANELTEMPERATURERELUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_PanelTemperatureRelUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_PANELTEMPERATUREGET:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_PanelTemperatureGet;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_PANELTEMPERATURESTATUS:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_PanelTemperatureStatus;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_BRIGHTNESSLEVELEXTENDEDUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelExtendedUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_BRIGHTNESSLEVELEXTENDEDRELUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelExtendedRelUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_BRIGHTNESSLEVELEXTENDEDGET:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelExtendedGet;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_BRIGHTNESSLEVELEXTENDEDSTATUS:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelExtendedStatus;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_VIDEOBRIGHTNESSLEVELUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_VideoBrightnessLevelUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_VIDEOBRIGHTNESSLEVELRELUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_VideoBrightnessLevelRelUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_VIDEOBRIGHTNESSLEVELGET:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_VideoBrightnessLevelGet;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_VIDEOBRIGHTNESSLEVELSTATUS:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_VideoBrightnessLevelStatus;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_CONTRASTLEVELUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_ContrastLevelUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_CONTRASTLEVELRELUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_ContrastLevelRelUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_CONTRASTLEVELGET:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_ContrastLevelGet;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_CONTRASTLEVELSTATUS:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_ContrastLevelStatus;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_BLACKLEVELUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_BlackLevelUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_BLACKLEVELRELUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_BlackLevelRelUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_BLACKLEVELGET:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_BlackLevelGet;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_BLACKLEVELSTATUS:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_BlackLevelStatus;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_YCURVELEVELUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_YCurveLevelUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_YCURVELEVELRELUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_YCurveLevelRelUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_YCURVELEVELGET:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_YCurveLevelGet;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_YCURVELEVELSTATUS:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_YCurveLevelStatus;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_TINTLEVELUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_TintLevelUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_TINTLEVELRELUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_TintLevelRelUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_TINTLEVELGET:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_TintLevelGet;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_TINTLEVELSTATUS:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_TintLevelStatus;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_COLORLEVELUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_ColorLevelUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_COLORLEVELRELUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_ColorLevelRelUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_COLORLEVELGET:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_ColorLevelGet;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_COLORLEVELSTATUS:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_ColorLevelStatus;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_DAY_LUMINOSITY_OFFSETUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_DAY_LUMINOSITY_OFFSETRELUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETRelUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_DAY_LUMINOSITY_OFFSETGET:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETGet;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_DAY_LUMINOSITY_OFFSETSET:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETSet;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_DAY_LUMINOSITY_OFFSETSTATUS:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETStatus;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_NIGHT_LUMINOSITY_OFFSETUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_NIGHT_LUMINOSITY_OFFSETRELUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETRelUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_NIGHT_LUMINOSITY_OFFSETGET:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETGet;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_NIGHT_LUMINOSITY_OFFSETSET:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETSet;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_NIGHT_LUMINOSITY_OFFSETSTATUS:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETStatus;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_COCKPIT_SLIDER_OFFSETUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_COCKPIT_SLIDER_OFFSETRELUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETRelUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_COCKPIT_SLIDER_OFFSETGET:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETGet;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_COCKPIT_SLIDER_OFFSETSET:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETSet;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_COCKPIT_SLIDER_OFFSETSTATUS:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETStatus;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DIAG_VARIANTUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DIAG_VariantUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DIAG_VARIANTRELUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DIAG_VariantRelUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DIAG_VARIANTGET:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DIAG_VariantGet;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DIAG_VARIANTSTATUS:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DIAG_VariantStatus;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DIAG_BRIGHTNESSINPUTTYPEUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DIAG_BrightnessInputTypeUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DIAG_BRIGHTNESSINPUTTYPERELUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DIAG_BrightnessInputTypeRelUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DIAG_BRIGHTNESSINPUTTYPEGET:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DIAG_BrightnessInputTypeGet;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DIAG_BRIGHTNESSINPUTTYPESTATUS:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DIAG_BrightnessInputTypeStatus;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_CSCCONTRASTLEVELUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_CSCContrastLevelUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_CSCCONTRASTLEVELRELUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_CSCContrastLevelRelUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_CSCCONTRASTLEVELGET:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_CSCContrastLevelGet;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_CSCCONTRASTLEVELSTATUS:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_CSCContrastLevelStatus;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_CSCBLACKLEVELUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_CSCBlackLevelUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_CSCBLACKLEVELRELUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_CSCBlackLevelRelUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_CSCBLACKLEVELGET:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_CSCBlackLevelGet;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_CSCBLACKLEVELSTATUS:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_CSCBlackLevelStatus;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_CSCGAMMALEVELUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_CSCGammaLevelUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_CSCGAMMALEVELRELUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_CSCGammaLevelRelUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_CSCGAMMALEVELGET:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_CSCGammaLevelGet;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_CSCGAMMALEVELSTATUS:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_CSCGammaLevelStatus;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_CSCSATURATIONLEVELUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_CSCSaturationLevelUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_CSCSATURATIONLEVELRELUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_CSCSaturationLevelRelUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_CSCSATURATIONLEVELGET:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_CSCSaturationLevelGet;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_CSCSATURATIONLEVELSTATUS:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_CSCSaturationLevelStatus;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_CSCCOLORLEVELUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_CSCColorLevelUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_CSCCOLORLEVELRELUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_CSCColorLevelRelUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_CSCCOLORLEVELGET:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_CSCColorLevelGet;

      case dimming_mainfi_tclToken::EN_MSG_DIM_DISP_CSCCOLORLEVELSTATUS:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_DISP_CSCColorLevelStatus;

      case dimming_mainfi_tclToken::EN_MSG_DIM_SECOND_DISP_ALLDISPLAYPARAMGET:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_SECOND_DISP_AllDisplayParamGet;

      case dimming_mainfi_tclToken::EN_MSG_DIM_SECOND_DISP_ALLDISPLAYPARAMUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_SECOND_DISP_AllDisplayParamUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_SECOND_DISP_ALLDISPLAYPARAMRELUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_SECOND_DISP_AllDisplayParamRelUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_SECOND_DISP_ALLDISPLAYPARAMSTATUS:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_SECOND_DISP_AllDisplayParamStatus;

      case dimming_mainfi_tclToken::EN_MSG_DIM_SECOND_DISP_SELFDIAGNOSISRESULTGET:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_SECOND_DISP_SelfDiagnosisResultGet;

      case dimming_mainfi_tclToken::EN_MSG_DIM_SECOND_DISP_SELFDIAGNOSISRESULTUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_SECOND_DISP_SelfDiagnosisResultUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_SECOND_DISP_SELFDIAGNOSISRESULTRELUPREG:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_SECOND_DISP_SelfDiagnosisResultRelUpReg;

      case dimming_mainfi_tclToken::EN_MSG_DIM_SECOND_DISP_SELFDIAGNOSISRESULTSTATUS:
         return OSAL_NEW dimming_mainfi_tclMsgDIM_SECOND_DISP_SelfDiagnosisResultStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all dimming_mainfifi messages

// common functions

tU16 dimming_mainfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return DIMMING_MAINFI_C_U16_SERVICE_ID;
}

tU16 dimming_mainfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 dimming_mainfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& dimming_mainfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& dimming_mainfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 dimming_mainfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& dimming_mainfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& dimming_mainfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgFI_VD_DIMMING_DEFAULTMethodStart::dimming_mainfi_tclMsgFI_VD_DIMMING_DEFAULTMethodStart(const dimming_mainfi_tclMsgFI_VD_DIMMING_DEFAULTMethodStart& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   DefaultSettingsGroup = coRef.DefaultSettingsGroup;
   DefaultSettingsMode = coRef.DefaultSettingsMode;
}
dimming_mainfi_tclMsgFI_VD_DIMMING_DEFAULTMethodStart& dimming_mainfi_tclMsgFI_VD_DIMMING_DEFAULTMethodStart::operator=(const dimming_mainfi_tclMsgFI_VD_DIMMING_DEFAULTMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DefaultSettingsGroup = coRef.DefaultSettingsGroup;
   DefaultSettingsMode = coRef.DefaultSettingsMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgFI_VD_DIMMING_DEFAULTMethodStart::dimming_mainfi_tclMsgFI_VD_DIMMING_DEFAULTMethodStart()
:DefaultSettingsGroup(0)
,DefaultSettingsMode(0)
 {}

tS32 dimming_mainfi_tclMsgFI_VD_DIMMING_DEFAULTMethodStart::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_FI_VD_DIMMING_DEFAULTMETHODSTART;
}


dimming_mainfi_tclMsgFI_VD_DIMMING_DEFAULTMethodStart::~dimming_mainfi_tclMsgFI_VD_DIMMING_DEFAULTMethodStart()
{}

tU32 dimming_mainfi_tclMsgFI_VD_DIMMING_DEFAULTMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& dimming_mainfi_tclMsgFI_VD_DIMMING_DEFAULTMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DefaultSettingsGroup);
   (tVoid) (oIn >> DefaultSettingsMode);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgFI_VD_DIMMING_DEFAULTMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DefaultSettingsGroup);
   (tVoid) (oOut << DefaultSettingsMode);
   return oOut;
}

tBool dimming_mainfi_tclMsgFI_VD_DIMMING_DEFAULTMethodStart::operator==(const dimming_mainfi_tclMsgFI_VD_DIMMING_DEFAULTMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DefaultSettingsGroup == roRef.DefaultSettingsGroup);
   bResult = bResult && (DefaultSettingsMode == roRef.DefaultSettingsMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgFI_VD_DIMMING_DEFAULTMethodResult::dimming_mainfi_tclMsgFI_VD_DIMMING_DEFAULTMethodResult(const dimming_mainfi_tclMsgFI_VD_DIMMING_DEFAULTMethodResult& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   DefaultSettingsGroup = coRef.DefaultSettingsGroup;
   DefaultSettingsStatus = coRef.DefaultSettingsStatus;
}
dimming_mainfi_tclMsgFI_VD_DIMMING_DEFAULTMethodResult& dimming_mainfi_tclMsgFI_VD_DIMMING_DEFAULTMethodResult::operator=(const dimming_mainfi_tclMsgFI_VD_DIMMING_DEFAULTMethodResult& coRef)
{
   if (this == &coRef) return *this;
   DefaultSettingsGroup = coRef.DefaultSettingsGroup;
   DefaultSettingsStatus = coRef.DefaultSettingsStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgFI_VD_DIMMING_DEFAULTMethodResult::dimming_mainfi_tclMsgFI_VD_DIMMING_DEFAULTMethodResult()
:DefaultSettingsGroup(0)
,DefaultSettingsStatus(0)
 {}

tS32 dimming_mainfi_tclMsgFI_VD_DIMMING_DEFAULTMethodResult::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_FI_VD_DIMMING_DEFAULTMETHODRESULT;
}


dimming_mainfi_tclMsgFI_VD_DIMMING_DEFAULTMethodResult::~dimming_mainfi_tclMsgFI_VD_DIMMING_DEFAULTMethodResult()
{}

tU32 dimming_mainfi_tclMsgFI_VD_DIMMING_DEFAULTMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& dimming_mainfi_tclMsgFI_VD_DIMMING_DEFAULTMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DefaultSettingsGroup);
   (tVoid) (oIn >> DefaultSettingsStatus);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgFI_VD_DIMMING_DEFAULTMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DefaultSettingsGroup);
   (tVoid) (oOut << DefaultSettingsStatus);
   return oOut;
}

tBool dimming_mainfi_tclMsgFI_VD_DIMMING_DEFAULTMethodResult::operator==(const dimming_mainfi_tclMsgFI_VD_DIMMING_DEFAULTMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DefaultSettingsGroup == roRef.DefaultSettingsGroup);
   bResult = bResult && (DefaultSettingsStatus == roRef.DefaultSettingsStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_INFO_SetDimmingModeMethodStart::dimming_mainfi_tclMsgDIM_INFO_SetDimmingModeMethodStart(const dimming_mainfi_tclMsgDIM_INFO_SetDimmingModeMethodStart& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   DimmingMode = coRef.DimmingMode;
}
dimming_mainfi_tclMsgDIM_INFO_SetDimmingModeMethodStart& dimming_mainfi_tclMsgDIM_INFO_SetDimmingModeMethodStart::operator=(const dimming_mainfi_tclMsgDIM_INFO_SetDimmingModeMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DimmingMode = coRef.DimmingMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_INFO_SetDimmingModeMethodStart::dimming_mainfi_tclMsgDIM_INFO_SetDimmingModeMethodStart()
:DimmingMode()
 {}

tS32 dimming_mainfi_tclMsgDIM_INFO_SetDimmingModeMethodStart::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_INFO_SETDIMMINGMODEMETHODSTART;
}


dimming_mainfi_tclMsgDIM_INFO_SetDimmingModeMethodStart::~dimming_mainfi_tclMsgDIM_INFO_SetDimmingModeMethodStart()
{}

tU32 dimming_mainfi_tclMsgDIM_INFO_SetDimmingModeMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_INFO_SetDimmingModeMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DimmingMode);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_INFO_SetDimmingModeMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DimmingMode);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_INFO_SetDimmingModeMethodStart::operator==(const dimming_mainfi_tclMsgDIM_INFO_SetDimmingModeMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DimmingMode == roRef.DimmingMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_INFO_SetDimmingModeMethodResult::dimming_mainfi_tclMsgDIM_INFO_SetDimmingModeMethodResult(const dimming_mainfi_tclMsgDIM_INFO_SetDimmingModeMethodResult& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   DimmingMode = coRef.DimmingMode;
}
dimming_mainfi_tclMsgDIM_INFO_SetDimmingModeMethodResult& dimming_mainfi_tclMsgDIM_INFO_SetDimmingModeMethodResult::operator=(const dimming_mainfi_tclMsgDIM_INFO_SetDimmingModeMethodResult& coRef)
{
   if (this == &coRef) return *this;
   DimmingMode = coRef.DimmingMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_INFO_SetDimmingModeMethodResult::dimming_mainfi_tclMsgDIM_INFO_SetDimmingModeMethodResult()
:DimmingMode()
 {}

tS32 dimming_mainfi_tclMsgDIM_INFO_SetDimmingModeMethodResult::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_INFO_SETDIMMINGMODEMETHODRESULT;
}


dimming_mainfi_tclMsgDIM_INFO_SetDimmingModeMethodResult::~dimming_mainfi_tclMsgDIM_INFO_SetDimmingModeMethodResult()
{}

tU32 dimming_mainfi_tclMsgDIM_INFO_SetDimmingModeMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_INFO_SetDimmingModeMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DimmingMode);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_INFO_SetDimmingModeMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DimmingMode);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_INFO_SetDimmingModeMethodResult::operator==(const dimming_mainfi_tclMsgDIM_INFO_SetDimmingModeMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DimmingMode == roRef.DimmingMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_INFO_SetEmulationModeMethodStart::dimming_mainfi_tclMsgDIM_INFO_SetEmulationModeMethodStart(const dimming_mainfi_tclMsgDIM_INFO_SetEmulationModeMethodStart& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   EmulationMode = coRef.EmulationMode;
}
dimming_mainfi_tclMsgDIM_INFO_SetEmulationModeMethodStart& dimming_mainfi_tclMsgDIM_INFO_SetEmulationModeMethodStart::operator=(const dimming_mainfi_tclMsgDIM_INFO_SetEmulationModeMethodStart& coRef)
{
   if (this == &coRef) return *this;
   EmulationMode = coRef.EmulationMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_INFO_SetEmulationModeMethodStart::dimming_mainfi_tclMsgDIM_INFO_SetEmulationModeMethodStart()
:EmulationMode()
 {}

tS32 dimming_mainfi_tclMsgDIM_INFO_SetEmulationModeMethodStart::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_INFO_SETEMULATIONMODEMETHODSTART;
}


dimming_mainfi_tclMsgDIM_INFO_SetEmulationModeMethodStart::~dimming_mainfi_tclMsgDIM_INFO_SetEmulationModeMethodStart()
{}

tU32 dimming_mainfi_tclMsgDIM_INFO_SetEmulationModeMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_INFO_SetEmulationModeMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> EmulationMode);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_INFO_SetEmulationModeMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << EmulationMode);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_INFO_SetEmulationModeMethodStart::operator==(const dimming_mainfi_tclMsgDIM_INFO_SetEmulationModeMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (EmulationMode == roRef.EmulationMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_INFO_SetEmulationModeMethodResult::dimming_mainfi_tclMsgDIM_INFO_SetEmulationModeMethodResult(const dimming_mainfi_tclMsgDIM_INFO_SetEmulationModeMethodResult& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   EmulationMode = coRef.EmulationMode;
}
dimming_mainfi_tclMsgDIM_INFO_SetEmulationModeMethodResult& dimming_mainfi_tclMsgDIM_INFO_SetEmulationModeMethodResult::operator=(const dimming_mainfi_tclMsgDIM_INFO_SetEmulationModeMethodResult& coRef)
{
   if (this == &coRef) return *this;
   EmulationMode = coRef.EmulationMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_INFO_SetEmulationModeMethodResult::dimming_mainfi_tclMsgDIM_INFO_SetEmulationModeMethodResult()
:EmulationMode()
 {}

tS32 dimming_mainfi_tclMsgDIM_INFO_SetEmulationModeMethodResult::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_INFO_SETEMULATIONMODEMETHODRESULT;
}


dimming_mainfi_tclMsgDIM_INFO_SetEmulationModeMethodResult::~dimming_mainfi_tclMsgDIM_INFO_SetEmulationModeMethodResult()
{}

tU32 dimming_mainfi_tclMsgDIM_INFO_SetEmulationModeMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_INFO_SetEmulationModeMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> EmulationMode);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_INFO_SetEmulationModeMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << EmulationMode);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_INFO_SetEmulationModeMethodResult::operator==(const dimming_mainfi_tclMsgDIM_INFO_SetEmulationModeMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (EmulationMode == roRef.EmulationMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_INFO_SetDimmingStateMethodStart::dimming_mainfi_tclMsgDIM_INFO_SetDimmingStateMethodStart(const dimming_mainfi_tclMsgDIM_INFO_SetDimmingStateMethodStart& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   LUN = coRef.LUN;
   DimmingStatus = coRef.DimmingStatus;
}
dimming_mainfi_tclMsgDIM_INFO_SetDimmingStateMethodStart& dimming_mainfi_tclMsgDIM_INFO_SetDimmingStateMethodStart::operator=(const dimming_mainfi_tclMsgDIM_INFO_SetDimmingStateMethodStart& coRef)
{
   if (this == &coRef) return *this;
   LUN = coRef.LUN;
   DimmingStatus = coRef.DimmingStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_INFO_SetDimmingStateMethodStart::dimming_mainfi_tclMsgDIM_INFO_SetDimmingStateMethodStart()
:LUN(0)
,DimmingStatus()
 {}

tS32 dimming_mainfi_tclMsgDIM_INFO_SetDimmingStateMethodStart::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_INFO_SETDIMMINGSTATEMETHODSTART;
}


dimming_mainfi_tclMsgDIM_INFO_SetDimmingStateMethodStart::~dimming_mainfi_tclMsgDIM_INFO_SetDimmingStateMethodStart()
{}

tU32 dimming_mainfi_tclMsgDIM_INFO_SetDimmingStateMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_INFO_SetDimmingStateMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LUN);
   (tVoid) (oIn >> DimmingStatus);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_INFO_SetDimmingStateMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LUN);
   (tVoid) (oOut << DimmingStatus);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_INFO_SetDimmingStateMethodStart::operator==(const dimming_mainfi_tclMsgDIM_INFO_SetDimmingStateMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LUN == roRef.LUN);
   bResult = bResult && (DimmingStatus == roRef.DimmingStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_INFO_SetDimmingStateMethodResult::dimming_mainfi_tclMsgDIM_INFO_SetDimmingStateMethodResult(const dimming_mainfi_tclMsgDIM_INFO_SetDimmingStateMethodResult& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   LUN = coRef.LUN;
   DimmingStatus = coRef.DimmingStatus;
}
dimming_mainfi_tclMsgDIM_INFO_SetDimmingStateMethodResult& dimming_mainfi_tclMsgDIM_INFO_SetDimmingStateMethodResult::operator=(const dimming_mainfi_tclMsgDIM_INFO_SetDimmingStateMethodResult& coRef)
{
   if (this == &coRef) return *this;
   LUN = coRef.LUN;
   DimmingStatus = coRef.DimmingStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_INFO_SetDimmingStateMethodResult::dimming_mainfi_tclMsgDIM_INFO_SetDimmingStateMethodResult()
:LUN(0)
,DimmingStatus()
 {}

tS32 dimming_mainfi_tclMsgDIM_INFO_SetDimmingStateMethodResult::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_INFO_SETDIMMINGSTATEMETHODRESULT;
}


dimming_mainfi_tclMsgDIM_INFO_SetDimmingStateMethodResult::~dimming_mainfi_tclMsgDIM_INFO_SetDimmingStateMethodResult()
{}

tU32 dimming_mainfi_tclMsgDIM_INFO_SetDimmingStateMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_INFO_SetDimmingStateMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LUN);
   (tVoid) (oIn >> DimmingStatus);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_INFO_SetDimmingStateMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LUN);
   (tVoid) (oOut << DimmingStatus);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_INFO_SetDimmingStateMethodResult::operator==(const dimming_mainfi_tclMsgDIM_INFO_SetDimmingStateMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LUN == roRef.LUN);
   bResult = bResult && (DimmingStatus == roRef.DimmingStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_INFO_GetDimmingStateMethodStart::dimming_mainfi_tclMsgDIM_INFO_GetDimmingStateMethodStart(const dimming_mainfi_tclMsgDIM_INFO_GetDimmingStateMethodStart& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   LUN = coRef.LUN;
}
dimming_mainfi_tclMsgDIM_INFO_GetDimmingStateMethodStart& dimming_mainfi_tclMsgDIM_INFO_GetDimmingStateMethodStart::operator=(const dimming_mainfi_tclMsgDIM_INFO_GetDimmingStateMethodStart& coRef)
{
   if (this == &coRef) return *this;
   LUN = coRef.LUN;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_INFO_GetDimmingStateMethodStart::dimming_mainfi_tclMsgDIM_INFO_GetDimmingStateMethodStart()
:LUN(0)
 {}

tS32 dimming_mainfi_tclMsgDIM_INFO_GetDimmingStateMethodStart::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_INFO_GETDIMMINGSTATEMETHODSTART;
}


dimming_mainfi_tclMsgDIM_INFO_GetDimmingStateMethodStart::~dimming_mainfi_tclMsgDIM_INFO_GetDimmingStateMethodStart()
{}

tU32 dimming_mainfi_tclMsgDIM_INFO_GetDimmingStateMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_INFO_GetDimmingStateMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LUN);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_INFO_GetDimmingStateMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LUN);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_INFO_GetDimmingStateMethodStart::operator==(const dimming_mainfi_tclMsgDIM_INFO_GetDimmingStateMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LUN == roRef.LUN);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_INFO_GetDimmingStateMethodResult::dimming_mainfi_tclMsgDIM_INFO_GetDimmingStateMethodResult(const dimming_mainfi_tclMsgDIM_INFO_GetDimmingStateMethodResult& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   LUN = coRef.LUN;
   DimmingState = coRef.DimmingState;
}
dimming_mainfi_tclMsgDIM_INFO_GetDimmingStateMethodResult& dimming_mainfi_tclMsgDIM_INFO_GetDimmingStateMethodResult::operator=(const dimming_mainfi_tclMsgDIM_INFO_GetDimmingStateMethodResult& coRef)
{
   if (this == &coRef) return *this;
   LUN = coRef.LUN;
   DimmingState = coRef.DimmingState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_INFO_GetDimmingStateMethodResult::dimming_mainfi_tclMsgDIM_INFO_GetDimmingStateMethodResult()
:LUN(0)
,DimmingState()
 {}

tS32 dimming_mainfi_tclMsgDIM_INFO_GetDimmingStateMethodResult::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_INFO_GETDIMMINGSTATEMETHODRESULT;
}


dimming_mainfi_tclMsgDIM_INFO_GetDimmingStateMethodResult::~dimming_mainfi_tclMsgDIM_INFO_GetDimmingStateMethodResult()
{}

tU32 dimming_mainfi_tclMsgDIM_INFO_GetDimmingStateMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_INFO_GetDimmingStateMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LUN);
   (tVoid) (oIn >> DimmingState);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_INFO_GetDimmingStateMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LUN);
   (tVoid) (oOut << DimmingState);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_INFO_GetDimmingStateMethodResult::operator==(const dimming_mainfi_tclMsgDIM_INFO_GetDimmingStateMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LUN == roRef.LUN);
   bResult = bResult && (DimmingState == roRef.DimmingState);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodStart::dimming_mainfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodStart(const dimming_mainfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodStart& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   LUN = coRef.LUN;
   Brightness = coRef.Brightness;
}
dimming_mainfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodStart& dimming_mainfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodStart::operator=(const dimming_mainfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodStart& coRef)
{
   if (this == &coRef) return *this;
   LUN = coRef.LUN;
   Brightness = coRef.Brightness;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodStart::dimming_mainfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodStart()
:LUN()
,Brightness()
 {}

tS32 dimming_mainfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodStart::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_INFO_SETDIMMINGBRIGHTNESSMETHODSTART;
}


dimming_mainfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodStart::~dimming_mainfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodStart()
{}

tU32 dimming_mainfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LUN);
   (tVoid) (oIn >> Brightness);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LUN);
   (tVoid) (oOut << Brightness);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodStart::operator==(const dimming_mainfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LUN == roRef.LUN);
   bResult = bResult && (Brightness == roRef.Brightness);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodResult::dimming_mainfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodResult(const dimming_mainfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodResult& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   LUN = coRef.LUN;
   Brightness = coRef.Brightness;
}
dimming_mainfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodResult& dimming_mainfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodResult::operator=(const dimming_mainfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodResult& coRef)
{
   if (this == &coRef) return *this;
   LUN = coRef.LUN;
   Brightness = coRef.Brightness;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodResult::dimming_mainfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodResult()
:LUN()
,Brightness()
 {}

tS32 dimming_mainfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodResult::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_INFO_SETDIMMINGBRIGHTNESSMETHODRESULT;
}


dimming_mainfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodResult::~dimming_mainfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodResult()
{}

tU32 dimming_mainfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LUN);
   (tVoid) (oIn >> Brightness);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LUN);
   (tVoid) (oOut << Brightness);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodResult::operator==(const dimming_mainfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LUN == roRef.LUN);
   bResult = bResult && (Brightness == roRef.Brightness);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodStart::dimming_mainfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodStart(const dimming_mainfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodStart& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   LUN = coRef.LUN;
}
dimming_mainfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodStart& dimming_mainfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodStart::operator=(const dimming_mainfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodStart& coRef)
{
   if (this == &coRef) return *this;
   LUN = coRef.LUN;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodStart::dimming_mainfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodStart()
:LUN()
 {}

tS32 dimming_mainfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodStart::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_INFO_GETDIMMINGBRIGHTNESSMETHODSTART;
}


dimming_mainfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodStart::~dimming_mainfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodStart()
{}

tU32 dimming_mainfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LUN);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LUN);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodStart::operator==(const dimming_mainfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LUN == roRef.LUN);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodResult::dimming_mainfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodResult(const dimming_mainfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodResult& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   LUN = coRef.LUN;
   Brightness = coRef.Brightness;
}
dimming_mainfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodResult& dimming_mainfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodResult::operator=(const dimming_mainfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodResult& coRef)
{
   if (this == &coRef) return *this;
   LUN = coRef.LUN;
   Brightness = coRef.Brightness;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodResult::dimming_mainfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodResult()
:LUN()
,Brightness()
 {}

tS32 dimming_mainfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodResult::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_INFO_GETDIMMINGBRIGHTNESSMETHODRESULT;
}


dimming_mainfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodResult::~dimming_mainfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodResult()
{}

tU32 dimming_mainfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LUN);
   (tVoid) (oIn >> Brightness);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LUN);
   (tVoid) (oOut << Brightness);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodResult::operator==(const dimming_mainfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LUN == roRef.LUN);
   bResult = bResult && (Brightness == roRef.Brightness);
   return bResult;
}

//=============================================================================

dimming_mainfi_tclMsgDIM_INFO_GetPWMBrightnessMethodStart::dimming_mainfi_tclMsgDIM_INFO_GetPWMBrightnessMethodStart()
 {}

tS32 dimming_mainfi_tclMsgDIM_INFO_GetPWMBrightnessMethodStart::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_INFO_GETPWMBRIGHTNESSMETHODSTART;
}


dimming_mainfi_tclMsgDIM_INFO_GetPWMBrightnessMethodStart::~dimming_mainfi_tclMsgDIM_INFO_GetPWMBrightnessMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_INFO_GetPWMBrightnessMethodResult::dimming_mainfi_tclMsgDIM_INFO_GetPWMBrightnessMethodResult(const dimming_mainfi_tclMsgDIM_INFO_GetPWMBrightnessMethodResult& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   Brightness = coRef.Brightness;
}
dimming_mainfi_tclMsgDIM_INFO_GetPWMBrightnessMethodResult& dimming_mainfi_tclMsgDIM_INFO_GetPWMBrightnessMethodResult::operator=(const dimming_mainfi_tclMsgDIM_INFO_GetPWMBrightnessMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Brightness = coRef.Brightness;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_INFO_GetPWMBrightnessMethodResult::dimming_mainfi_tclMsgDIM_INFO_GetPWMBrightnessMethodResult()
:Brightness()
 {}

tS32 dimming_mainfi_tclMsgDIM_INFO_GetPWMBrightnessMethodResult::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_INFO_GETPWMBRIGHTNESSMETHODRESULT;
}


dimming_mainfi_tclMsgDIM_INFO_GetPWMBrightnessMethodResult::~dimming_mainfi_tclMsgDIM_INFO_GetPWMBrightnessMethodResult()
{}

tU32 dimming_mainfi_tclMsgDIM_INFO_GetPWMBrightnessMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_INFO_GetPWMBrightnessMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Brightness);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_INFO_GetPWMBrightnessMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Brightness);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_INFO_GetPWMBrightnessMethodResult::operator==(const dimming_mainfi_tclMsgDIM_INFO_GetPWMBrightnessMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Brightness == roRef.Brightness);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_KEYB_SetDimmingMethodStart::dimming_mainfi_tclMsgDIM_KEYB_SetDimmingMethodStart(const dimming_mainfi_tclMsgDIM_KEYB_SetDimmingMethodStart& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   Brightness = coRef.Brightness;
}
dimming_mainfi_tclMsgDIM_KEYB_SetDimmingMethodStart& dimming_mainfi_tclMsgDIM_KEYB_SetDimmingMethodStart::operator=(const dimming_mainfi_tclMsgDIM_KEYB_SetDimmingMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Brightness = coRef.Brightness;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_KEYB_SetDimmingMethodStart::dimming_mainfi_tclMsgDIM_KEYB_SetDimmingMethodStart()
:Brightness()
 {}

tS32 dimming_mainfi_tclMsgDIM_KEYB_SetDimmingMethodStart::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_KEYB_SETDIMMINGMETHODSTART;
}


dimming_mainfi_tclMsgDIM_KEYB_SetDimmingMethodStart::~dimming_mainfi_tclMsgDIM_KEYB_SetDimmingMethodStart()
{}

tU32 dimming_mainfi_tclMsgDIM_KEYB_SetDimmingMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_KEYB_SetDimmingMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Brightness);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_KEYB_SetDimmingMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Brightness);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_KEYB_SetDimmingMethodStart::operator==(const dimming_mainfi_tclMsgDIM_KEYB_SetDimmingMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Brightness == roRef.Brightness);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_KEYB_SetDimmingMethodResult::dimming_mainfi_tclMsgDIM_KEYB_SetDimmingMethodResult(const dimming_mainfi_tclMsgDIM_KEYB_SetDimmingMethodResult& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   Brightness = coRef.Brightness;
}
dimming_mainfi_tclMsgDIM_KEYB_SetDimmingMethodResult& dimming_mainfi_tclMsgDIM_KEYB_SetDimmingMethodResult::operator=(const dimming_mainfi_tclMsgDIM_KEYB_SetDimmingMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Brightness = coRef.Brightness;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_KEYB_SetDimmingMethodResult::dimming_mainfi_tclMsgDIM_KEYB_SetDimmingMethodResult()
:Brightness()
 {}

tS32 dimming_mainfi_tclMsgDIM_KEYB_SetDimmingMethodResult::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_KEYB_SETDIMMINGMETHODRESULT;
}


dimming_mainfi_tclMsgDIM_KEYB_SetDimmingMethodResult::~dimming_mainfi_tclMsgDIM_KEYB_SetDimmingMethodResult()
{}

tU32 dimming_mainfi_tclMsgDIM_KEYB_SetDimmingMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_KEYB_SetDimmingMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Brightness);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_KEYB_SetDimmingMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Brightness);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_KEYB_SetDimmingMethodResult::operator==(const dimming_mainfi_tclMsgDIM_KEYB_SetDimmingMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Brightness == roRef.Brightness);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_KEYB_SetDimmingPWMMethodStart::dimming_mainfi_tclMsgDIM_KEYB_SetDimmingPWMMethodStart(const dimming_mainfi_tclMsgDIM_KEYB_SetDimmingPWMMethodStart& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   Brightness = coRef.Brightness;
}
dimming_mainfi_tclMsgDIM_KEYB_SetDimmingPWMMethodStart& dimming_mainfi_tclMsgDIM_KEYB_SetDimmingPWMMethodStart::operator=(const dimming_mainfi_tclMsgDIM_KEYB_SetDimmingPWMMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Brightness = coRef.Brightness;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_KEYB_SetDimmingPWMMethodStart::dimming_mainfi_tclMsgDIM_KEYB_SetDimmingPWMMethodStart()
:Brightness()
 {}

tS32 dimming_mainfi_tclMsgDIM_KEYB_SetDimmingPWMMethodStart::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_KEYB_SETDIMMINGPWMMETHODSTART;
}


dimming_mainfi_tclMsgDIM_KEYB_SetDimmingPWMMethodStart::~dimming_mainfi_tclMsgDIM_KEYB_SetDimmingPWMMethodStart()
{}

tU32 dimming_mainfi_tclMsgDIM_KEYB_SetDimmingPWMMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_KEYB_SetDimmingPWMMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Brightness);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_KEYB_SetDimmingPWMMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Brightness);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_KEYB_SetDimmingPWMMethodStart::operator==(const dimming_mainfi_tclMsgDIM_KEYB_SetDimmingPWMMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Brightness == roRef.Brightness);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_KEYB_SetDimmingPWMMethodResult::dimming_mainfi_tclMsgDIM_KEYB_SetDimmingPWMMethodResult(const dimming_mainfi_tclMsgDIM_KEYB_SetDimmingPWMMethodResult& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   Brightness = coRef.Brightness;
}
dimming_mainfi_tclMsgDIM_KEYB_SetDimmingPWMMethodResult& dimming_mainfi_tclMsgDIM_KEYB_SetDimmingPWMMethodResult::operator=(const dimming_mainfi_tclMsgDIM_KEYB_SetDimmingPWMMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Brightness = coRef.Brightness;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_KEYB_SetDimmingPWMMethodResult::dimming_mainfi_tclMsgDIM_KEYB_SetDimmingPWMMethodResult()
:Brightness()
 {}

tS32 dimming_mainfi_tclMsgDIM_KEYB_SetDimmingPWMMethodResult::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_KEYB_SETDIMMINGPWMMETHODRESULT;
}


dimming_mainfi_tclMsgDIM_KEYB_SetDimmingPWMMethodResult::~dimming_mainfi_tclMsgDIM_KEYB_SetDimmingPWMMethodResult()
{}

tU32 dimming_mainfi_tclMsgDIM_KEYB_SetDimmingPWMMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_KEYB_SetDimmingPWMMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Brightness);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_KEYB_SetDimmingPWMMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Brightness);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_KEYB_SetDimmingPWMMethodResult::operator==(const dimming_mainfi_tclMsgDIM_KEYB_SetDimmingPWMMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Brightness == roRef.Brightness);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DISP_SetDriverInitalizedMethodStart::dimming_mainfi_tclMsgDIM_DISP_SetDriverInitalizedMethodStart(const dimming_mainfi_tclMsgDIM_DISP_SetDriverInitalizedMethodStart& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   SetDriverInitialized = coRef.SetDriverInitialized;
}
dimming_mainfi_tclMsgDIM_DISP_SetDriverInitalizedMethodStart& dimming_mainfi_tclMsgDIM_DISP_SetDriverInitalizedMethodStart::operator=(const dimming_mainfi_tclMsgDIM_DISP_SetDriverInitalizedMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SetDriverInitialized = coRef.SetDriverInitialized;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DISP_SetDriverInitalizedMethodStart::dimming_mainfi_tclMsgDIM_DISP_SetDriverInitalizedMethodStart()
:SetDriverInitialized()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_SetDriverInitalizedMethodStart::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETDRIVERINITALIZEDMETHODSTART;
}


dimming_mainfi_tclMsgDIM_DISP_SetDriverInitalizedMethodStart::~dimming_mainfi_tclMsgDIM_DISP_SetDriverInitalizedMethodStart()
{}

tU32 dimming_mainfi_tclMsgDIM_DISP_SetDriverInitalizedMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DISP_SetDriverInitalizedMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SetDriverInitialized);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DISP_SetDriverInitalizedMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SetDriverInitialized);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DISP_SetDriverInitalizedMethodStart::operator==(const dimming_mainfi_tclMsgDIM_DISP_SetDriverInitalizedMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SetDriverInitialized == roRef.SetDriverInitialized);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DISP_SetDriverInitalizedMethodResult::dimming_mainfi_tclMsgDIM_DISP_SetDriverInitalizedMethodResult(const dimming_mainfi_tclMsgDIM_DISP_SetDriverInitalizedMethodResult& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   SetDriverInitialized = coRef.SetDriverInitialized;
}
dimming_mainfi_tclMsgDIM_DISP_SetDriverInitalizedMethodResult& dimming_mainfi_tclMsgDIM_DISP_SetDriverInitalizedMethodResult::operator=(const dimming_mainfi_tclMsgDIM_DISP_SetDriverInitalizedMethodResult& coRef)
{
   if (this == &coRef) return *this;
   SetDriverInitialized = coRef.SetDriverInitialized;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DISP_SetDriverInitalizedMethodResult::dimming_mainfi_tclMsgDIM_DISP_SetDriverInitalizedMethodResult()
:SetDriverInitialized()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_SetDriverInitalizedMethodResult::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETDRIVERINITALIZEDMETHODRESULT;
}


dimming_mainfi_tclMsgDIM_DISP_SetDriverInitalizedMethodResult::~dimming_mainfi_tclMsgDIM_DISP_SetDriverInitalizedMethodResult()
{}

tU32 dimming_mainfi_tclMsgDIM_DISP_SetDriverInitalizedMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DISP_SetDriverInitalizedMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SetDriverInitialized);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DISP_SetDriverInitalizedMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SetDriverInitialized);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DISP_SetDriverInitalizedMethodResult::operator==(const dimming_mainfi_tclMsgDIM_DISP_SetDriverInitalizedMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SetDriverInitialized == roRef.SetDriverInitialized);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodStart::dimming_mainfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodStart(const dimming_mainfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodStart& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   SetScreenContentAvailable = coRef.SetScreenContentAvailable;
}
dimming_mainfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodStart& dimming_mainfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodStart::operator=(const dimming_mainfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SetScreenContentAvailable = coRef.SetScreenContentAvailable;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodStart::dimming_mainfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodStart()
:SetScreenContentAvailable()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodStart::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETSCREENCONTENTAVAILABLEMETHODSTART;
}


dimming_mainfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodStart::~dimming_mainfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodStart()
{}

tU32 dimming_mainfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SetScreenContentAvailable);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SetScreenContentAvailable);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodStart::operator==(const dimming_mainfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SetScreenContentAvailable == roRef.SetScreenContentAvailable);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodResult::dimming_mainfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodResult(const dimming_mainfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodResult& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   SetScreenContentAvailable = coRef.SetScreenContentAvailable;
}
dimming_mainfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodResult& dimming_mainfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodResult::operator=(const dimming_mainfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodResult& coRef)
{
   if (this == &coRef) return *this;
   SetScreenContentAvailable = coRef.SetScreenContentAvailable;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodResult::dimming_mainfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodResult()
:SetScreenContentAvailable()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodResult::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETSCREENCONTENTAVAILABLEMETHODRESULT;
}


dimming_mainfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodResult::~dimming_mainfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodResult()
{}

tU32 dimming_mainfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SetScreenContentAvailable);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SetScreenContentAvailable);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodResult::operator==(const dimming_mainfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SetScreenContentAvailable == roRef.SetScreenContentAvailable);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DISP_SetDimmingMethodStart::dimming_mainfi_tclMsgDIM_DISP_SetDimmingMethodStart(const dimming_mainfi_tclMsgDIM_DISP_SetDimmingMethodStart& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   Brightness = coRef.Brightness;
}
dimming_mainfi_tclMsgDIM_DISP_SetDimmingMethodStart& dimming_mainfi_tclMsgDIM_DISP_SetDimmingMethodStart::operator=(const dimming_mainfi_tclMsgDIM_DISP_SetDimmingMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Brightness = coRef.Brightness;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DISP_SetDimmingMethodStart::dimming_mainfi_tclMsgDIM_DISP_SetDimmingMethodStart()
:Brightness()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_SetDimmingMethodStart::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETDIMMINGMETHODSTART;
}


dimming_mainfi_tclMsgDIM_DISP_SetDimmingMethodStart::~dimming_mainfi_tclMsgDIM_DISP_SetDimmingMethodStart()
{}

tU32 dimming_mainfi_tclMsgDIM_DISP_SetDimmingMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DISP_SetDimmingMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Brightness);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DISP_SetDimmingMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Brightness);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DISP_SetDimmingMethodStart::operator==(const dimming_mainfi_tclMsgDIM_DISP_SetDimmingMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Brightness == roRef.Brightness);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DISP_SetDimmingMethodResult::dimming_mainfi_tclMsgDIM_DISP_SetDimmingMethodResult(const dimming_mainfi_tclMsgDIM_DISP_SetDimmingMethodResult& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   Brightness = coRef.Brightness;
}
dimming_mainfi_tclMsgDIM_DISP_SetDimmingMethodResult& dimming_mainfi_tclMsgDIM_DISP_SetDimmingMethodResult::operator=(const dimming_mainfi_tclMsgDIM_DISP_SetDimmingMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Brightness = coRef.Brightness;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DISP_SetDimmingMethodResult::dimming_mainfi_tclMsgDIM_DISP_SetDimmingMethodResult()
:Brightness()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_SetDimmingMethodResult::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETDIMMINGMETHODRESULT;
}


dimming_mainfi_tclMsgDIM_DISP_SetDimmingMethodResult::~dimming_mainfi_tclMsgDIM_DISP_SetDimmingMethodResult()
{}

tU32 dimming_mainfi_tclMsgDIM_DISP_SetDimmingMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DISP_SetDimmingMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Brightness);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DISP_SetDimmingMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Brightness);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DISP_SetDimmingMethodResult::operator==(const dimming_mainfi_tclMsgDIM_DISP_SetDimmingMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Brightness == roRef.Brightness);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DISP_SwitchBacklightMethodStart::dimming_mainfi_tclMsgDIM_DISP_SwitchBacklightMethodStart(const dimming_mainfi_tclMsgDIM_DISP_SwitchBacklightMethodStart& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   SwitchBacklight = coRef.SwitchBacklight;
}
dimming_mainfi_tclMsgDIM_DISP_SwitchBacklightMethodStart& dimming_mainfi_tclMsgDIM_DISP_SwitchBacklightMethodStart::operator=(const dimming_mainfi_tclMsgDIM_DISP_SwitchBacklightMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SwitchBacklight = coRef.SwitchBacklight;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DISP_SwitchBacklightMethodStart::dimming_mainfi_tclMsgDIM_DISP_SwitchBacklightMethodStart()
:SwitchBacklight()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_SwitchBacklightMethodStart::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SWITCHBACKLIGHTMETHODSTART;
}


dimming_mainfi_tclMsgDIM_DISP_SwitchBacklightMethodStart::~dimming_mainfi_tclMsgDIM_DISP_SwitchBacklightMethodStart()
{}

tU32 dimming_mainfi_tclMsgDIM_DISP_SwitchBacklightMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DISP_SwitchBacklightMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SwitchBacklight);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DISP_SwitchBacklightMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SwitchBacklight);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DISP_SwitchBacklightMethodStart::operator==(const dimming_mainfi_tclMsgDIM_DISP_SwitchBacklightMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SwitchBacklight == roRef.SwitchBacklight);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DISP_SwitchBacklightMethodResult::dimming_mainfi_tclMsgDIM_DISP_SwitchBacklightMethodResult(const dimming_mainfi_tclMsgDIM_DISP_SwitchBacklightMethodResult& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   SwitchBacklight = coRef.SwitchBacklight;
}
dimming_mainfi_tclMsgDIM_DISP_SwitchBacklightMethodResult& dimming_mainfi_tclMsgDIM_DISP_SwitchBacklightMethodResult::operator=(const dimming_mainfi_tclMsgDIM_DISP_SwitchBacklightMethodResult& coRef)
{
   if (this == &coRef) return *this;
   SwitchBacklight = coRef.SwitchBacklight;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DISP_SwitchBacklightMethodResult::dimming_mainfi_tclMsgDIM_DISP_SwitchBacklightMethodResult()
:SwitchBacklight()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_SwitchBacklightMethodResult::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SWITCHBACKLIGHTMETHODRESULT;
}


dimming_mainfi_tclMsgDIM_DISP_SwitchBacklightMethodResult::~dimming_mainfi_tclMsgDIM_DISP_SwitchBacklightMethodResult()
{}

tU32 dimming_mainfi_tclMsgDIM_DISP_SwitchBacklightMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DISP_SwitchBacklightMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SwitchBacklight);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DISP_SwitchBacklightMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SwitchBacklight);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DISP_SwitchBacklightMethodResult::operator==(const dimming_mainfi_tclMsgDIM_DISP_SwitchBacklightMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SwitchBacklight == roRef.SwitchBacklight);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelMethodStart::dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelMethodStart(const dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelMethodStart& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   BrightnessLevel = coRef.BrightnessLevel;
}
dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelMethodStart& dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelMethodStart::operator=(const dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelMethodStart& coRef)
{
   if (this == &coRef) return *this;
   BrightnessLevel = coRef.BrightnessLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelMethodStart::dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelMethodStart()
:BrightnessLevel()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelMethodStart::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETBRIGHTNESSLEVELMETHODSTART;
}


dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelMethodStart::~dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelMethodStart()
{}

tU32 dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BrightnessLevel);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BrightnessLevel);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelMethodStart::operator==(const dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BrightnessLevel == roRef.BrightnessLevel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelMethodResult::dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelMethodResult(const dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelMethodResult& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   BrightnessLevel = coRef.BrightnessLevel;
}
dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelMethodResult& dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelMethodResult::operator=(const dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelMethodResult& coRef)
{
   if (this == &coRef) return *this;
   BrightnessLevel = coRef.BrightnessLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelMethodResult::dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelMethodResult()
:BrightnessLevel()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelMethodResult::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETBRIGHTNESSLEVELMETHODRESULT;
}


dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelMethodResult::~dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelMethodResult()
{}

tU32 dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BrightnessLevel);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BrightnessLevel);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelMethodResult::operator==(const dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BrightnessLevel == roRef.BrightnessLevel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodStart::dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodStart(const dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodStart& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   BrightnessLevelExtended = coRef.BrightnessLevelExtended;
}
dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodStart& dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodStart::operator=(const dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodStart& coRef)
{
   if (this == &coRef) return *this;
   BrightnessLevelExtended = coRef.BrightnessLevelExtended;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodStart::dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodStart()
:BrightnessLevelExtended(0)
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodStart::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETBRIGHTNESSLEVELEXTENDEDMETHODSTART;
}


dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodStart::~dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodStart()
{}

tU32 dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BrightnessLevelExtended);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BrightnessLevelExtended);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodStart::operator==(const dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BrightnessLevelExtended == roRef.BrightnessLevelExtended);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodResult::dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodResult(const dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodResult& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   BrightnessLevelExtended = coRef.BrightnessLevelExtended;
}
dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodResult& dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodResult::operator=(const dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodResult& coRef)
{
   if (this == &coRef) return *this;
   BrightnessLevelExtended = coRef.BrightnessLevelExtended;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodResult::dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodResult()
:BrightnessLevelExtended(0)
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodResult::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETBRIGHTNESSLEVELEXTENDEDMETHODRESULT;
}


dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodResult::~dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodResult()
{}

tU32 dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BrightnessLevelExtended);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BrightnessLevelExtended);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodResult::operator==(const dimming_mainfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BrightnessLevelExtended == roRef.BrightnessLevelExtended);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodStart::dimming_mainfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodStart(const dimming_mainfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodStart& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   VideoBrightnessLevelDay = coRef.VideoBrightnessLevelDay;
   VideoBrightnessLevelNight = coRef.VideoBrightnessLevelNight;
}
dimming_mainfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodStart& dimming_mainfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodStart::operator=(const dimming_mainfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodStart& coRef)
{
   if (this == &coRef) return *this;
   VideoBrightnessLevelDay = coRef.VideoBrightnessLevelDay;
   VideoBrightnessLevelNight = coRef.VideoBrightnessLevelNight;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodStart::dimming_mainfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodStart()
:VideoBrightnessLevelDay(0)
,VideoBrightnessLevelNight(0)
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodStart::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETVIDEOBRIGHTNESSLEVELMETHODSTART;
}


dimming_mainfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodStart::~dimming_mainfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodStart()
{}

tU32 dimming_mainfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VideoBrightnessLevelDay);
   (tVoid) (oIn >> VideoBrightnessLevelNight);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VideoBrightnessLevelDay);
   (tVoid) (oOut << VideoBrightnessLevelNight);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodStart::operator==(const dimming_mainfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VideoBrightnessLevelDay == roRef.VideoBrightnessLevelDay);
   bResult = bResult && (VideoBrightnessLevelNight == roRef.VideoBrightnessLevelNight);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodResult::dimming_mainfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodResult(const dimming_mainfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodResult& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   VideoBrightnessLevelDay = coRef.VideoBrightnessLevelDay;
   VideoBrightnessLevelNight = coRef.VideoBrightnessLevelNight;
}
dimming_mainfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodResult& dimming_mainfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodResult::operator=(const dimming_mainfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodResult& coRef)
{
   if (this == &coRef) return *this;
   VideoBrightnessLevelDay = coRef.VideoBrightnessLevelDay;
   VideoBrightnessLevelNight = coRef.VideoBrightnessLevelNight;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodResult::dimming_mainfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodResult()
:VideoBrightnessLevelDay(0)
,VideoBrightnessLevelNight(0)
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodResult::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETVIDEOBRIGHTNESSLEVELMETHODRESULT;
}


dimming_mainfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodResult::~dimming_mainfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodResult()
{}

tU32 dimming_mainfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VideoBrightnessLevelDay);
   (tVoid) (oIn >> VideoBrightnessLevelNight);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VideoBrightnessLevelDay);
   (tVoid) (oOut << VideoBrightnessLevelNight);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodResult::operator==(const dimming_mainfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VideoBrightnessLevelDay == roRef.VideoBrightnessLevelDay);
   bResult = bResult && (VideoBrightnessLevelNight == roRef.VideoBrightnessLevelNight);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DISP_SetContrastLevelMethodStart::dimming_mainfi_tclMsgDIM_DISP_SetContrastLevelMethodStart(const dimming_mainfi_tclMsgDIM_DISP_SetContrastLevelMethodStart& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   Contrast = coRef.Contrast;
}
dimming_mainfi_tclMsgDIM_DISP_SetContrastLevelMethodStart& dimming_mainfi_tclMsgDIM_DISP_SetContrastLevelMethodStart::operator=(const dimming_mainfi_tclMsgDIM_DISP_SetContrastLevelMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Contrast = coRef.Contrast;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DISP_SetContrastLevelMethodStart::dimming_mainfi_tclMsgDIM_DISP_SetContrastLevelMethodStart()
:Contrast(0)
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_SetContrastLevelMethodStart::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETCONTRASTLEVELMETHODSTART;
}


dimming_mainfi_tclMsgDIM_DISP_SetContrastLevelMethodStart::~dimming_mainfi_tclMsgDIM_DISP_SetContrastLevelMethodStart()
{}

tU32 dimming_mainfi_tclMsgDIM_DISP_SetContrastLevelMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DISP_SetContrastLevelMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Contrast);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DISP_SetContrastLevelMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Contrast);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DISP_SetContrastLevelMethodStart::operator==(const dimming_mainfi_tclMsgDIM_DISP_SetContrastLevelMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Contrast == roRef.Contrast);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DISP_SetContrastLevelMethodResult::dimming_mainfi_tclMsgDIM_DISP_SetContrastLevelMethodResult(const dimming_mainfi_tclMsgDIM_DISP_SetContrastLevelMethodResult& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   BrightnessLevelExtended = coRef.BrightnessLevelExtended;
}
dimming_mainfi_tclMsgDIM_DISP_SetContrastLevelMethodResult& dimming_mainfi_tclMsgDIM_DISP_SetContrastLevelMethodResult::operator=(const dimming_mainfi_tclMsgDIM_DISP_SetContrastLevelMethodResult& coRef)
{
   if (this == &coRef) return *this;
   BrightnessLevelExtended = coRef.BrightnessLevelExtended;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DISP_SetContrastLevelMethodResult::dimming_mainfi_tclMsgDIM_DISP_SetContrastLevelMethodResult()
:BrightnessLevelExtended(0)
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_SetContrastLevelMethodResult::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETCONTRASTLEVELMETHODRESULT;
}


dimming_mainfi_tclMsgDIM_DISP_SetContrastLevelMethodResult::~dimming_mainfi_tclMsgDIM_DISP_SetContrastLevelMethodResult()
{}

tU32 dimming_mainfi_tclMsgDIM_DISP_SetContrastLevelMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DISP_SetContrastLevelMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BrightnessLevelExtended);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DISP_SetContrastLevelMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BrightnessLevelExtended);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DISP_SetContrastLevelMethodResult::operator==(const dimming_mainfi_tclMsgDIM_DISP_SetContrastLevelMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BrightnessLevelExtended == roRef.BrightnessLevelExtended);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DISP_SetBlackLevelMethodStart::dimming_mainfi_tclMsgDIM_DISP_SetBlackLevelMethodStart(const dimming_mainfi_tclMsgDIM_DISP_SetBlackLevelMethodStart& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   BlackLevel = coRef.BlackLevel;
}
dimming_mainfi_tclMsgDIM_DISP_SetBlackLevelMethodStart& dimming_mainfi_tclMsgDIM_DISP_SetBlackLevelMethodStart::operator=(const dimming_mainfi_tclMsgDIM_DISP_SetBlackLevelMethodStart& coRef)
{
   if (this == &coRef) return *this;
   BlackLevel = coRef.BlackLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DISP_SetBlackLevelMethodStart::dimming_mainfi_tclMsgDIM_DISP_SetBlackLevelMethodStart()
:BlackLevel(0)
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_SetBlackLevelMethodStart::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETBLACKLEVELMETHODSTART;
}


dimming_mainfi_tclMsgDIM_DISP_SetBlackLevelMethodStart::~dimming_mainfi_tclMsgDIM_DISP_SetBlackLevelMethodStart()
{}

tU32 dimming_mainfi_tclMsgDIM_DISP_SetBlackLevelMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DISP_SetBlackLevelMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BlackLevel);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DISP_SetBlackLevelMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BlackLevel);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DISP_SetBlackLevelMethodStart::operator==(const dimming_mainfi_tclMsgDIM_DISP_SetBlackLevelMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BlackLevel == roRef.BlackLevel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DISP_SetBlackLevelMethodResult::dimming_mainfi_tclMsgDIM_DISP_SetBlackLevelMethodResult(const dimming_mainfi_tclMsgDIM_DISP_SetBlackLevelMethodResult& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   BlackLevel = coRef.BlackLevel;
}
dimming_mainfi_tclMsgDIM_DISP_SetBlackLevelMethodResult& dimming_mainfi_tclMsgDIM_DISP_SetBlackLevelMethodResult::operator=(const dimming_mainfi_tclMsgDIM_DISP_SetBlackLevelMethodResult& coRef)
{
   if (this == &coRef) return *this;
   BlackLevel = coRef.BlackLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DISP_SetBlackLevelMethodResult::dimming_mainfi_tclMsgDIM_DISP_SetBlackLevelMethodResult()
:BlackLevel(0)
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_SetBlackLevelMethodResult::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETBLACKLEVELMETHODRESULT;
}


dimming_mainfi_tclMsgDIM_DISP_SetBlackLevelMethodResult::~dimming_mainfi_tclMsgDIM_DISP_SetBlackLevelMethodResult()
{}

tU32 dimming_mainfi_tclMsgDIM_DISP_SetBlackLevelMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DISP_SetBlackLevelMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BlackLevel);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DISP_SetBlackLevelMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BlackLevel);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DISP_SetBlackLevelMethodResult::operator==(const dimming_mainfi_tclMsgDIM_DISP_SetBlackLevelMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BlackLevel == roRef.BlackLevel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DISP_SetYCurveLevelMethodStart::dimming_mainfi_tclMsgDIM_DISP_SetYCurveLevelMethodStart(const dimming_mainfi_tclMsgDIM_DISP_SetYCurveLevelMethodStart& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   YCurveLevel = coRef.YCurveLevel;
}
dimming_mainfi_tclMsgDIM_DISP_SetYCurveLevelMethodStart& dimming_mainfi_tclMsgDIM_DISP_SetYCurveLevelMethodStart::operator=(const dimming_mainfi_tclMsgDIM_DISP_SetYCurveLevelMethodStart& coRef)
{
   if (this == &coRef) return *this;
   YCurveLevel = coRef.YCurveLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DISP_SetYCurveLevelMethodStart::dimming_mainfi_tclMsgDIM_DISP_SetYCurveLevelMethodStart()
:YCurveLevel(0)
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_SetYCurveLevelMethodStart::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETYCURVELEVELMETHODSTART;
}


dimming_mainfi_tclMsgDIM_DISP_SetYCurveLevelMethodStart::~dimming_mainfi_tclMsgDIM_DISP_SetYCurveLevelMethodStart()
{}

tU32 dimming_mainfi_tclMsgDIM_DISP_SetYCurveLevelMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DISP_SetYCurveLevelMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> YCurveLevel);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DISP_SetYCurveLevelMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << YCurveLevel);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DISP_SetYCurveLevelMethodStart::operator==(const dimming_mainfi_tclMsgDIM_DISP_SetYCurveLevelMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (YCurveLevel == roRef.YCurveLevel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DISP_SetYCurveLevelMethodResult::dimming_mainfi_tclMsgDIM_DISP_SetYCurveLevelMethodResult(const dimming_mainfi_tclMsgDIM_DISP_SetYCurveLevelMethodResult& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   YCurveLevel = coRef.YCurveLevel;
}
dimming_mainfi_tclMsgDIM_DISP_SetYCurveLevelMethodResult& dimming_mainfi_tclMsgDIM_DISP_SetYCurveLevelMethodResult::operator=(const dimming_mainfi_tclMsgDIM_DISP_SetYCurveLevelMethodResult& coRef)
{
   if (this == &coRef) return *this;
   YCurveLevel = coRef.YCurveLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DISP_SetYCurveLevelMethodResult::dimming_mainfi_tclMsgDIM_DISP_SetYCurveLevelMethodResult()
:YCurveLevel(0)
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_SetYCurveLevelMethodResult::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETYCURVELEVELMETHODRESULT;
}


dimming_mainfi_tclMsgDIM_DISP_SetYCurveLevelMethodResult::~dimming_mainfi_tclMsgDIM_DISP_SetYCurveLevelMethodResult()
{}

tU32 dimming_mainfi_tclMsgDIM_DISP_SetYCurveLevelMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DISP_SetYCurveLevelMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> YCurveLevel);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DISP_SetYCurveLevelMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << YCurveLevel);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DISP_SetYCurveLevelMethodResult::operator==(const dimming_mainfi_tclMsgDIM_DISP_SetYCurveLevelMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (YCurveLevel == roRef.YCurveLevel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DISP_SetTintLevelMethodStart::dimming_mainfi_tclMsgDIM_DISP_SetTintLevelMethodStart(const dimming_mainfi_tclMsgDIM_DISP_SetTintLevelMethodStart& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   TintLevel = coRef.TintLevel;
}
dimming_mainfi_tclMsgDIM_DISP_SetTintLevelMethodStart& dimming_mainfi_tclMsgDIM_DISP_SetTintLevelMethodStart::operator=(const dimming_mainfi_tclMsgDIM_DISP_SetTintLevelMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TintLevel = coRef.TintLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DISP_SetTintLevelMethodStart::dimming_mainfi_tclMsgDIM_DISP_SetTintLevelMethodStart()
:TintLevel(0)
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_SetTintLevelMethodStart::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETTINTLEVELMETHODSTART;
}


dimming_mainfi_tclMsgDIM_DISP_SetTintLevelMethodStart::~dimming_mainfi_tclMsgDIM_DISP_SetTintLevelMethodStart()
{}

tU32 dimming_mainfi_tclMsgDIM_DISP_SetTintLevelMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DISP_SetTintLevelMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TintLevel);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DISP_SetTintLevelMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TintLevel);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DISP_SetTintLevelMethodStart::operator==(const dimming_mainfi_tclMsgDIM_DISP_SetTintLevelMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TintLevel == roRef.TintLevel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DISP_SetTintLevelMethodResult::dimming_mainfi_tclMsgDIM_DISP_SetTintLevelMethodResult(const dimming_mainfi_tclMsgDIM_DISP_SetTintLevelMethodResult& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   TintLevel = coRef.TintLevel;
}
dimming_mainfi_tclMsgDIM_DISP_SetTintLevelMethodResult& dimming_mainfi_tclMsgDIM_DISP_SetTintLevelMethodResult::operator=(const dimming_mainfi_tclMsgDIM_DISP_SetTintLevelMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TintLevel = coRef.TintLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DISP_SetTintLevelMethodResult::dimming_mainfi_tclMsgDIM_DISP_SetTintLevelMethodResult()
:TintLevel(0)
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_SetTintLevelMethodResult::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETTINTLEVELMETHODRESULT;
}


dimming_mainfi_tclMsgDIM_DISP_SetTintLevelMethodResult::~dimming_mainfi_tclMsgDIM_DISP_SetTintLevelMethodResult()
{}

tU32 dimming_mainfi_tclMsgDIM_DISP_SetTintLevelMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DISP_SetTintLevelMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TintLevel);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DISP_SetTintLevelMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TintLevel);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DISP_SetTintLevelMethodResult::operator==(const dimming_mainfi_tclMsgDIM_DISP_SetTintLevelMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TintLevel == roRef.TintLevel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DISP_SetColorLevelMethodStart::dimming_mainfi_tclMsgDIM_DISP_SetColorLevelMethodStart(const dimming_mainfi_tclMsgDIM_DISP_SetColorLevelMethodStart& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   ColorLevel = coRef.ColorLevel;
}
dimming_mainfi_tclMsgDIM_DISP_SetColorLevelMethodStart& dimming_mainfi_tclMsgDIM_DISP_SetColorLevelMethodStart::operator=(const dimming_mainfi_tclMsgDIM_DISP_SetColorLevelMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ColorLevel = coRef.ColorLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DISP_SetColorLevelMethodStart::dimming_mainfi_tclMsgDIM_DISP_SetColorLevelMethodStart()
:ColorLevel(0)
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_SetColorLevelMethodStart::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETCOLORLEVELMETHODSTART;
}


dimming_mainfi_tclMsgDIM_DISP_SetColorLevelMethodStart::~dimming_mainfi_tclMsgDIM_DISP_SetColorLevelMethodStart()
{}

tU32 dimming_mainfi_tclMsgDIM_DISP_SetColorLevelMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DISP_SetColorLevelMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ColorLevel);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DISP_SetColorLevelMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ColorLevel);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DISP_SetColorLevelMethodStart::operator==(const dimming_mainfi_tclMsgDIM_DISP_SetColorLevelMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ColorLevel == roRef.ColorLevel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DISP_SetColorLevelMethodResult::dimming_mainfi_tclMsgDIM_DISP_SetColorLevelMethodResult(const dimming_mainfi_tclMsgDIM_DISP_SetColorLevelMethodResult& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   ColorLevel = coRef.ColorLevel;
}
dimming_mainfi_tclMsgDIM_DISP_SetColorLevelMethodResult& dimming_mainfi_tclMsgDIM_DISP_SetColorLevelMethodResult::operator=(const dimming_mainfi_tclMsgDIM_DISP_SetColorLevelMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ColorLevel = coRef.ColorLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DISP_SetColorLevelMethodResult::dimming_mainfi_tclMsgDIM_DISP_SetColorLevelMethodResult()
:ColorLevel(0)
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_SetColorLevelMethodResult::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETCOLORLEVELMETHODRESULT;
}


dimming_mainfi_tclMsgDIM_DISP_SetColorLevelMethodResult::~dimming_mainfi_tclMsgDIM_DISP_SetColorLevelMethodResult()
{}

tU32 dimming_mainfi_tclMsgDIM_DISP_SetColorLevelMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DISP_SetColorLevelMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ColorLevel);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DISP_SetColorLevelMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ColorLevel);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DISP_SetColorLevelMethodResult::operator==(const dimming_mainfi_tclMsgDIM_DISP_SetColorLevelMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ColorLevel == roRef.ColorLevel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodStart::dimming_mainfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodStart(const dimming_mainfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodStart& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   SetBrightnessInputType = coRef.SetBrightnessInputType;
}
dimming_mainfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodStart& dimming_mainfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodStart::operator=(const dimming_mainfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SetBrightnessInputType = coRef.SetBrightnessInputType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodStart::dimming_mainfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodStart()
:SetBrightnessInputType()
 {}

tS32 dimming_mainfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodStart::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DIAG_SETBRIGHTNESSINPUTTYPEMETHODSTART;
}


dimming_mainfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodStart::~dimming_mainfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodStart()
{}

tU32 dimming_mainfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SetBrightnessInputType);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SetBrightnessInputType);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodStart::operator==(const dimming_mainfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SetBrightnessInputType == roRef.SetBrightnessInputType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodResult::dimming_mainfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodResult(const dimming_mainfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodResult& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   SetBrightnessInputType = coRef.SetBrightnessInputType;
}
dimming_mainfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodResult& dimming_mainfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodResult::operator=(const dimming_mainfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodResult& coRef)
{
   if (this == &coRef) return *this;
   SetBrightnessInputType = coRef.SetBrightnessInputType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodResult::dimming_mainfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodResult()
:SetBrightnessInputType()
 {}

tS32 dimming_mainfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodResult::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DIAG_SETBRIGHTNESSINPUTTYPEMETHODRESULT;
}


dimming_mainfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodResult::~dimming_mainfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodResult()
{}

tU32 dimming_mainfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SetBrightnessInputType);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SetBrightnessInputType);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodResult::operator==(const dimming_mainfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SetBrightnessInputType == roRef.SetBrightnessInputType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DISP_SetCSCContrastLevelMethodStart::dimming_mainfi_tclMsgDIM_DISP_SetCSCContrastLevelMethodStart(const dimming_mainfi_tclMsgDIM_DISP_SetCSCContrastLevelMethodStart& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   ContrastLevel = coRef.ContrastLevel;
}
dimming_mainfi_tclMsgDIM_DISP_SetCSCContrastLevelMethodStart& dimming_mainfi_tclMsgDIM_DISP_SetCSCContrastLevelMethodStart::operator=(const dimming_mainfi_tclMsgDIM_DISP_SetCSCContrastLevelMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ContrastLevel = coRef.ContrastLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DISP_SetCSCContrastLevelMethodStart::dimming_mainfi_tclMsgDIM_DISP_SetCSCContrastLevelMethodStart()
:ContrastLevel(0)
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_SetCSCContrastLevelMethodStart::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETCSCCONTRASTLEVELMETHODSTART;
}


dimming_mainfi_tclMsgDIM_DISP_SetCSCContrastLevelMethodStart::~dimming_mainfi_tclMsgDIM_DISP_SetCSCContrastLevelMethodStart()
{}

tU32 dimming_mainfi_tclMsgDIM_DISP_SetCSCContrastLevelMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DISP_SetCSCContrastLevelMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ContrastLevel);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DISP_SetCSCContrastLevelMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ContrastLevel);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DISP_SetCSCContrastLevelMethodStart::operator==(const dimming_mainfi_tclMsgDIM_DISP_SetCSCContrastLevelMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ContrastLevel == roRef.ContrastLevel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DISP_SetCSCContrastLevelMethodResult::dimming_mainfi_tclMsgDIM_DISP_SetCSCContrastLevelMethodResult(const dimming_mainfi_tclMsgDIM_DISP_SetCSCContrastLevelMethodResult& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   ContrastLevel = coRef.ContrastLevel;
}
dimming_mainfi_tclMsgDIM_DISP_SetCSCContrastLevelMethodResult& dimming_mainfi_tclMsgDIM_DISP_SetCSCContrastLevelMethodResult::operator=(const dimming_mainfi_tclMsgDIM_DISP_SetCSCContrastLevelMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ContrastLevel = coRef.ContrastLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DISP_SetCSCContrastLevelMethodResult::dimming_mainfi_tclMsgDIM_DISP_SetCSCContrastLevelMethodResult()
:ContrastLevel(0)
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_SetCSCContrastLevelMethodResult::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETCSCCONTRASTLEVELMETHODRESULT;
}


dimming_mainfi_tclMsgDIM_DISP_SetCSCContrastLevelMethodResult::~dimming_mainfi_tclMsgDIM_DISP_SetCSCContrastLevelMethodResult()
{}

tU32 dimming_mainfi_tclMsgDIM_DISP_SetCSCContrastLevelMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DISP_SetCSCContrastLevelMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ContrastLevel);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DISP_SetCSCContrastLevelMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ContrastLevel);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DISP_SetCSCContrastLevelMethodResult::operator==(const dimming_mainfi_tclMsgDIM_DISP_SetCSCContrastLevelMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ContrastLevel == roRef.ContrastLevel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DISP_SetCSCBlackLevelMethodStart::dimming_mainfi_tclMsgDIM_DISP_SetCSCBlackLevelMethodStart(const dimming_mainfi_tclMsgDIM_DISP_SetCSCBlackLevelMethodStart& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   BlackLevel = coRef.BlackLevel;
}
dimming_mainfi_tclMsgDIM_DISP_SetCSCBlackLevelMethodStart& dimming_mainfi_tclMsgDIM_DISP_SetCSCBlackLevelMethodStart::operator=(const dimming_mainfi_tclMsgDIM_DISP_SetCSCBlackLevelMethodStart& coRef)
{
   if (this == &coRef) return *this;
   BlackLevel = coRef.BlackLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DISP_SetCSCBlackLevelMethodStart::dimming_mainfi_tclMsgDIM_DISP_SetCSCBlackLevelMethodStart()
:BlackLevel(0)
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_SetCSCBlackLevelMethodStart::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETCSCBLACKLEVELMETHODSTART;
}


dimming_mainfi_tclMsgDIM_DISP_SetCSCBlackLevelMethodStart::~dimming_mainfi_tclMsgDIM_DISP_SetCSCBlackLevelMethodStart()
{}

tU32 dimming_mainfi_tclMsgDIM_DISP_SetCSCBlackLevelMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DISP_SetCSCBlackLevelMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BlackLevel);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DISP_SetCSCBlackLevelMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BlackLevel);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DISP_SetCSCBlackLevelMethodStart::operator==(const dimming_mainfi_tclMsgDIM_DISP_SetCSCBlackLevelMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BlackLevel == roRef.BlackLevel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DISP_SetCSCBlackLevelMethodResult::dimming_mainfi_tclMsgDIM_DISP_SetCSCBlackLevelMethodResult(const dimming_mainfi_tclMsgDIM_DISP_SetCSCBlackLevelMethodResult& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   BlackLevel = coRef.BlackLevel;
}
dimming_mainfi_tclMsgDIM_DISP_SetCSCBlackLevelMethodResult& dimming_mainfi_tclMsgDIM_DISP_SetCSCBlackLevelMethodResult::operator=(const dimming_mainfi_tclMsgDIM_DISP_SetCSCBlackLevelMethodResult& coRef)
{
   if (this == &coRef) return *this;
   BlackLevel = coRef.BlackLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DISP_SetCSCBlackLevelMethodResult::dimming_mainfi_tclMsgDIM_DISP_SetCSCBlackLevelMethodResult()
:BlackLevel(0)
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_SetCSCBlackLevelMethodResult::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETCSCBLACKLEVELMETHODRESULT;
}


dimming_mainfi_tclMsgDIM_DISP_SetCSCBlackLevelMethodResult::~dimming_mainfi_tclMsgDIM_DISP_SetCSCBlackLevelMethodResult()
{}

tU32 dimming_mainfi_tclMsgDIM_DISP_SetCSCBlackLevelMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DISP_SetCSCBlackLevelMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BlackLevel);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DISP_SetCSCBlackLevelMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BlackLevel);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DISP_SetCSCBlackLevelMethodResult::operator==(const dimming_mainfi_tclMsgDIM_DISP_SetCSCBlackLevelMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BlackLevel == roRef.BlackLevel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DISP_SetCSCGammaLevelMethodStart::dimming_mainfi_tclMsgDIM_DISP_SetCSCGammaLevelMethodStart(const dimming_mainfi_tclMsgDIM_DISP_SetCSCGammaLevelMethodStart& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   GammaLevel = coRef.GammaLevel;
}
dimming_mainfi_tclMsgDIM_DISP_SetCSCGammaLevelMethodStart& dimming_mainfi_tclMsgDIM_DISP_SetCSCGammaLevelMethodStart::operator=(const dimming_mainfi_tclMsgDIM_DISP_SetCSCGammaLevelMethodStart& coRef)
{
   if (this == &coRef) return *this;
   GammaLevel = coRef.GammaLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DISP_SetCSCGammaLevelMethodStart::dimming_mainfi_tclMsgDIM_DISP_SetCSCGammaLevelMethodStart()
:GammaLevel(0)
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_SetCSCGammaLevelMethodStart::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETCSCGAMMALEVELMETHODSTART;
}


dimming_mainfi_tclMsgDIM_DISP_SetCSCGammaLevelMethodStart::~dimming_mainfi_tclMsgDIM_DISP_SetCSCGammaLevelMethodStart()
{}

tU32 dimming_mainfi_tclMsgDIM_DISP_SetCSCGammaLevelMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DISP_SetCSCGammaLevelMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> GammaLevel);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DISP_SetCSCGammaLevelMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << GammaLevel);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DISP_SetCSCGammaLevelMethodStart::operator==(const dimming_mainfi_tclMsgDIM_DISP_SetCSCGammaLevelMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (GammaLevel == roRef.GammaLevel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DISP_SetCSCGammaLevelMethodResult::dimming_mainfi_tclMsgDIM_DISP_SetCSCGammaLevelMethodResult(const dimming_mainfi_tclMsgDIM_DISP_SetCSCGammaLevelMethodResult& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   GammaLevel = coRef.GammaLevel;
}
dimming_mainfi_tclMsgDIM_DISP_SetCSCGammaLevelMethodResult& dimming_mainfi_tclMsgDIM_DISP_SetCSCGammaLevelMethodResult::operator=(const dimming_mainfi_tclMsgDIM_DISP_SetCSCGammaLevelMethodResult& coRef)
{
   if (this == &coRef) return *this;
   GammaLevel = coRef.GammaLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DISP_SetCSCGammaLevelMethodResult::dimming_mainfi_tclMsgDIM_DISP_SetCSCGammaLevelMethodResult()
:GammaLevel(0)
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_SetCSCGammaLevelMethodResult::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETCSCGAMMALEVELMETHODRESULT;
}


dimming_mainfi_tclMsgDIM_DISP_SetCSCGammaLevelMethodResult::~dimming_mainfi_tclMsgDIM_DISP_SetCSCGammaLevelMethodResult()
{}

tU32 dimming_mainfi_tclMsgDIM_DISP_SetCSCGammaLevelMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DISP_SetCSCGammaLevelMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> GammaLevel);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DISP_SetCSCGammaLevelMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << GammaLevel);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DISP_SetCSCGammaLevelMethodResult::operator==(const dimming_mainfi_tclMsgDIM_DISP_SetCSCGammaLevelMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (GammaLevel == roRef.GammaLevel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DISP_SetCSCSaturationLevelMethodStart::dimming_mainfi_tclMsgDIM_DISP_SetCSCSaturationLevelMethodStart(const dimming_mainfi_tclMsgDIM_DISP_SetCSCSaturationLevelMethodStart& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   SaturationLevel = coRef.SaturationLevel;
}
dimming_mainfi_tclMsgDIM_DISP_SetCSCSaturationLevelMethodStart& dimming_mainfi_tclMsgDIM_DISP_SetCSCSaturationLevelMethodStart::operator=(const dimming_mainfi_tclMsgDIM_DISP_SetCSCSaturationLevelMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SaturationLevel = coRef.SaturationLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DISP_SetCSCSaturationLevelMethodStart::dimming_mainfi_tclMsgDIM_DISP_SetCSCSaturationLevelMethodStart()
:SaturationLevel(0)
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_SetCSCSaturationLevelMethodStart::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETCSCSATURATIONLEVELMETHODSTART;
}


dimming_mainfi_tclMsgDIM_DISP_SetCSCSaturationLevelMethodStart::~dimming_mainfi_tclMsgDIM_DISP_SetCSCSaturationLevelMethodStart()
{}

tU32 dimming_mainfi_tclMsgDIM_DISP_SetCSCSaturationLevelMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DISP_SetCSCSaturationLevelMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SaturationLevel);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DISP_SetCSCSaturationLevelMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SaturationLevel);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DISP_SetCSCSaturationLevelMethodStart::operator==(const dimming_mainfi_tclMsgDIM_DISP_SetCSCSaturationLevelMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SaturationLevel == roRef.SaturationLevel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DISP_SetCSCSaturationLevelMethodResult::dimming_mainfi_tclMsgDIM_DISP_SetCSCSaturationLevelMethodResult(const dimming_mainfi_tclMsgDIM_DISP_SetCSCSaturationLevelMethodResult& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   SaturationLevel = coRef.SaturationLevel;
}
dimming_mainfi_tclMsgDIM_DISP_SetCSCSaturationLevelMethodResult& dimming_mainfi_tclMsgDIM_DISP_SetCSCSaturationLevelMethodResult::operator=(const dimming_mainfi_tclMsgDIM_DISP_SetCSCSaturationLevelMethodResult& coRef)
{
   if (this == &coRef) return *this;
   SaturationLevel = coRef.SaturationLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DISP_SetCSCSaturationLevelMethodResult::dimming_mainfi_tclMsgDIM_DISP_SetCSCSaturationLevelMethodResult()
:SaturationLevel(0)
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_SetCSCSaturationLevelMethodResult::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETCSCSATURATIONLEVELMETHODRESULT;
}


dimming_mainfi_tclMsgDIM_DISP_SetCSCSaturationLevelMethodResult::~dimming_mainfi_tclMsgDIM_DISP_SetCSCSaturationLevelMethodResult()
{}

tU32 dimming_mainfi_tclMsgDIM_DISP_SetCSCSaturationLevelMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DISP_SetCSCSaturationLevelMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SaturationLevel);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DISP_SetCSCSaturationLevelMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SaturationLevel);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DISP_SetCSCSaturationLevelMethodResult::operator==(const dimming_mainfi_tclMsgDIM_DISP_SetCSCSaturationLevelMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SaturationLevel == roRef.SaturationLevel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DISP_SetCSCColorLevelMethodStart::dimming_mainfi_tclMsgDIM_DISP_SetCSCColorLevelMethodStart(const dimming_mainfi_tclMsgDIM_DISP_SetCSCColorLevelMethodStart& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   ColorLevel = coRef.ColorLevel;
}
dimming_mainfi_tclMsgDIM_DISP_SetCSCColorLevelMethodStart& dimming_mainfi_tclMsgDIM_DISP_SetCSCColorLevelMethodStart::operator=(const dimming_mainfi_tclMsgDIM_DISP_SetCSCColorLevelMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ColorLevel = coRef.ColorLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DISP_SetCSCColorLevelMethodStart::dimming_mainfi_tclMsgDIM_DISP_SetCSCColorLevelMethodStart()
:ColorLevel(0)
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_SetCSCColorLevelMethodStart::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETCSCCOLORLEVELMETHODSTART;
}


dimming_mainfi_tclMsgDIM_DISP_SetCSCColorLevelMethodStart::~dimming_mainfi_tclMsgDIM_DISP_SetCSCColorLevelMethodStart()
{}

tU32 dimming_mainfi_tclMsgDIM_DISP_SetCSCColorLevelMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DISP_SetCSCColorLevelMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ColorLevel);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DISP_SetCSCColorLevelMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ColorLevel);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DISP_SetCSCColorLevelMethodStart::operator==(const dimming_mainfi_tclMsgDIM_DISP_SetCSCColorLevelMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ColorLevel == roRef.ColorLevel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DISP_SetCSCColorLevelMethodResult::dimming_mainfi_tclMsgDIM_DISP_SetCSCColorLevelMethodResult(const dimming_mainfi_tclMsgDIM_DISP_SetCSCColorLevelMethodResult& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   ColorLevel = coRef.ColorLevel;
}
dimming_mainfi_tclMsgDIM_DISP_SetCSCColorLevelMethodResult& dimming_mainfi_tclMsgDIM_DISP_SetCSCColorLevelMethodResult::operator=(const dimming_mainfi_tclMsgDIM_DISP_SetCSCColorLevelMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ColorLevel = coRef.ColorLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DISP_SetCSCColorLevelMethodResult::dimming_mainfi_tclMsgDIM_DISP_SetCSCColorLevelMethodResult()
:ColorLevel(0)
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_SetCSCColorLevelMethodResult::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SETCSCCOLORLEVELMETHODRESULT;
}


dimming_mainfi_tclMsgDIM_DISP_SetCSCColorLevelMethodResult::~dimming_mainfi_tclMsgDIM_DISP_SetCSCColorLevelMethodResult()
{}

tU32 dimming_mainfi_tclMsgDIM_DISP_SetCSCColorLevelMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DISP_SetCSCColorLevelMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ColorLevel);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DISP_SetCSCColorLevelMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ColorLevel);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DISP_SetCSCColorLevelMethodResult::operator==(const dimming_mainfi_tclMsgDIM_DISP_SetCSCColorLevelMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ColorLevel == roRef.ColorLevel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispParameterMethodStart::dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispParameterMethodStart(const dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispParameterMethodStart& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   e16FunctionId = coRef.e16FunctionId;
   u16ParameterValue = coRef.u16ParameterValue;
}
dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispParameterMethodStart& dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispParameterMethodStart::operator=(const dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispParameterMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e16FunctionId = coRef.e16FunctionId;
   u16ParameterValue = coRef.u16ParameterValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispParameterMethodStart::dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispParameterMethodStart()
:e16FunctionId()
,u16ParameterValue(0)
 {}

tS32 dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispParameterMethodStart::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_SECOND_DISP_SETDISPPARAMETERMETHODSTART;
}


dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispParameterMethodStart::~dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispParameterMethodStart()
{}

tU32 dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispParameterMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispParameterMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e16FunctionId);
   (tVoid) (oIn >> u16ParameterValue);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispParameterMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e16FunctionId);
   (tVoid) (oOut << u16ParameterValue);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispParameterMethodStart::operator==(const dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispParameterMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e16FunctionId == roRef.e16FunctionId);
   bResult = bResult && (u16ParameterValue == roRef.u16ParameterValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispParameterMethodResult::dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispParameterMethodResult(const dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispParameterMethodResult& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   e16FunctionId = coRef.e16FunctionId;
   u16ParameterValue = coRef.u16ParameterValue;
}
dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispParameterMethodResult& dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispParameterMethodResult::operator=(const dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispParameterMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e16FunctionId = coRef.e16FunctionId;
   u16ParameterValue = coRef.u16ParameterValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispParameterMethodResult::dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispParameterMethodResult()
:e16FunctionId()
,u16ParameterValue(0)
 {}

tS32 dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispParameterMethodResult::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_SECOND_DISP_SETDISPPARAMETERMETHODRESULT;
}


dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispParameterMethodResult::~dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispParameterMethodResult()
{}

tU32 dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispParameterMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispParameterMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e16FunctionId);
   (tVoid) (oIn >> u16ParameterValue);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispParameterMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e16FunctionId);
   (tVoid) (oOut << u16ParameterValue);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispParameterMethodResult::operator==(const dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispParameterMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e16FunctionId == roRef.e16FunctionId);
   bResult = bResult && (u16ParameterValue == roRef.u16ParameterValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispOnOffMethodStart::dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispOnOffMethodStart(const dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispOnOffMethodStart& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   u8DisplayState = coRef.u8DisplayState;
}
dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispOnOffMethodStart& dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispOnOffMethodStart::operator=(const dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispOnOffMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8DisplayState = coRef.u8DisplayState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispOnOffMethodStart::dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispOnOffMethodStart()
:u8DisplayState(0)
 {}

tS32 dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispOnOffMethodStart::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_SECOND_DISP_SETDISPONOFFMETHODSTART;
}


dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispOnOffMethodStart::~dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispOnOffMethodStart()
{}

tU32 dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispOnOffMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispOnOffMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DisplayState);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispOnOffMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DisplayState);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispOnOffMethodStart::operator==(const dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispOnOffMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DisplayState == roRef.u8DisplayState);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispOnOffMethodResult::dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispOnOffMethodResult(const dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispOnOffMethodResult& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   u8DisplayState = coRef.u8DisplayState;
}
dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispOnOffMethodResult& dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispOnOffMethodResult::operator=(const dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispOnOffMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u8DisplayState = coRef.u8DisplayState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispOnOffMethodResult::dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispOnOffMethodResult()
:u8DisplayState(0)
 {}

tS32 dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispOnOffMethodResult::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_SECOND_DISP_SETDISPONOFFMETHODRESULT;
}


dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispOnOffMethodResult::~dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispOnOffMethodResult()
{}

tU32 dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispOnOffMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispOnOffMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DisplayState);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispOnOffMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DisplayState);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispOnOffMethodResult::operator==(const dimming_mainfi_tclMsgDIM_SECOND_DISP_SetDispOnOffMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DisplayState == roRef.u8DisplayState);
   return bResult;
}

//=============================================================================

dimming_mainfi_tclMsgDIM_SECOND_DISP_HardwareVersionMethodStart::dimming_mainfi_tclMsgDIM_SECOND_DISP_HardwareVersionMethodStart()
 {}

tS32 dimming_mainfi_tclMsgDIM_SECOND_DISP_HardwareVersionMethodStart::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_SECOND_DISP_HARDWAREVERSIONMETHODSTART;
}


dimming_mainfi_tclMsgDIM_SECOND_DISP_HardwareVersionMethodStart::~dimming_mainfi_tclMsgDIM_SECOND_DISP_HardwareVersionMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_SECOND_DISP_HardwareVersionMethodResult::dimming_mainfi_tclMsgDIM_SECOND_DISP_HardwareVersionMethodResult(const dimming_mainfi_tclMsgDIM_SECOND_DISP_HardwareVersionMethodResult& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   HW_VersionInfo = coRef.HW_VersionInfo;
}
dimming_mainfi_tclMsgDIM_SECOND_DISP_HardwareVersionMethodResult& dimming_mainfi_tclMsgDIM_SECOND_DISP_HardwareVersionMethodResult::operator=(const dimming_mainfi_tclMsgDIM_SECOND_DISP_HardwareVersionMethodResult& coRef)
{
   if (this == &coRef) return *this;
   HW_VersionInfo = coRef.HW_VersionInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_SECOND_DISP_HardwareVersionMethodResult::dimming_mainfi_tclMsgDIM_SECOND_DISP_HardwareVersionMethodResult()
:HW_VersionInfo()
 {}

tS32 dimming_mainfi_tclMsgDIM_SECOND_DISP_HardwareVersionMethodResult::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_SECOND_DISP_HARDWAREVERSIONMETHODRESULT;
}


dimming_mainfi_tclMsgDIM_SECOND_DISP_HardwareVersionMethodResult::~dimming_mainfi_tclMsgDIM_SECOND_DISP_HardwareVersionMethodResult()
{}

tU32 dimming_mainfi_tclMsgDIM_SECOND_DISP_HardwareVersionMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_SECOND_DISP_HardwareVersionMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> HW_VersionInfo);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_SECOND_DISP_HardwareVersionMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << HW_VersionInfo);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_SECOND_DISP_HardwareVersionMethodResult::operator==(const dimming_mainfi_tclMsgDIM_SECOND_DISP_HardwareVersionMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (HW_VersionInfo == roRef.HW_VersionInfo);
   return bResult;
}

//=============================================================================

dimming_mainfi_tclMsgDIM_SECOND_DISP_SoftwareVersionMethodStart::dimming_mainfi_tclMsgDIM_SECOND_DISP_SoftwareVersionMethodStart()
 {}

tS32 dimming_mainfi_tclMsgDIM_SECOND_DISP_SoftwareVersionMethodStart::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_SECOND_DISP_SOFTWAREVERSIONMETHODSTART;
}


dimming_mainfi_tclMsgDIM_SECOND_DISP_SoftwareVersionMethodStart::~dimming_mainfi_tclMsgDIM_SECOND_DISP_SoftwareVersionMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_SECOND_DISP_SoftwareVersionMethodResult::dimming_mainfi_tclMsgDIM_SECOND_DISP_SoftwareVersionMethodResult(const dimming_mainfi_tclMsgDIM_SECOND_DISP_SoftwareVersionMethodResult& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   SW_VersionInfo = coRef.SW_VersionInfo;
}
dimming_mainfi_tclMsgDIM_SECOND_DISP_SoftwareVersionMethodResult& dimming_mainfi_tclMsgDIM_SECOND_DISP_SoftwareVersionMethodResult::operator=(const dimming_mainfi_tclMsgDIM_SECOND_DISP_SoftwareVersionMethodResult& coRef)
{
   if (this == &coRef) return *this;
   SW_VersionInfo = coRef.SW_VersionInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_SECOND_DISP_SoftwareVersionMethodResult::dimming_mainfi_tclMsgDIM_SECOND_DISP_SoftwareVersionMethodResult()
:SW_VersionInfo()
 {}

tS32 dimming_mainfi_tclMsgDIM_SECOND_DISP_SoftwareVersionMethodResult::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_SECOND_DISP_SOFTWAREVERSIONMETHODRESULT;
}


dimming_mainfi_tclMsgDIM_SECOND_DISP_SoftwareVersionMethodResult::~dimming_mainfi_tclMsgDIM_SECOND_DISP_SoftwareVersionMethodResult()
{}

tU32 dimming_mainfi_tclMsgDIM_SECOND_DISP_SoftwareVersionMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_SECOND_DISP_SoftwareVersionMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SW_VersionInfo);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_SECOND_DISP_SoftwareVersionMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SW_VersionInfo);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_SECOND_DISP_SoftwareVersionMethodResult::operator==(const dimming_mainfi_tclMsgDIM_SECOND_DISP_SoftwareVersionMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SW_VersionInfo == roRef.SW_VersionInfo);
   return bResult;
}

//=============================================================================

dimming_mainfi_tclMsgDIM_SECOND_DISP_GetALLParamMethodResult::dimming_mainfi_tclMsgDIM_SECOND_DISP_GetALLParamMethodResult()
 {}

tS32 dimming_mainfi_tclMsgDIM_SECOND_DISP_GetALLParamMethodResult::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_SECOND_DISP_GETALLPARAMMETHODRESULT;
}


dimming_mainfi_tclMsgDIM_SECOND_DISP_GetALLParamMethodResult::~dimming_mainfi_tclMsgDIM_SECOND_DISP_GetALLParamMethodResult()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_SECOND_DISP_GetALLParamMethodStart::dimming_mainfi_tclMsgDIM_SECOND_DISP_GetALLParamMethodStart()
 {}

tS32 dimming_mainfi_tclMsgDIM_SECOND_DISP_GetALLParamMethodStart::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_SECOND_DISP_GETALLPARAMMETHODSTART;
}


dimming_mainfi_tclMsgDIM_SECOND_DISP_GetALLParamMethodStart::~dimming_mainfi_tclMsgDIM_SECOND_DISP_GetALLParamMethodStart()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_INFO_CarIlluminationDataUpReg::dimming_mainfi_tclMsgDIM_INFO_CarIlluminationDataUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_INFO_CarIlluminationDataUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_INFO_CARILLUMINATIONDATAUPREG;
}


dimming_mainfi_tclMsgDIM_INFO_CarIlluminationDataUpReg::~dimming_mainfi_tclMsgDIM_INFO_CarIlluminationDataUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_INFO_CarIlluminationDataRelUpReg::dimming_mainfi_tclMsgDIM_INFO_CarIlluminationDataRelUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_INFO_CarIlluminationDataRelUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_INFO_CARILLUMINATIONDATARELUPREG;
}


dimming_mainfi_tclMsgDIM_INFO_CarIlluminationDataRelUpReg::~dimming_mainfi_tclMsgDIM_INFO_CarIlluminationDataRelUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_INFO_CarIlluminationDataGet::dimming_mainfi_tclMsgDIM_INFO_CarIlluminationDataGet()
 {}

tS32 dimming_mainfi_tclMsgDIM_INFO_CarIlluminationDataGet::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_INFO_CARILLUMINATIONDATAGET;
}


dimming_mainfi_tclMsgDIM_INFO_CarIlluminationDataGet::~dimming_mainfi_tclMsgDIM_INFO_CarIlluminationDataGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_INFO_CarIlluminationDataStatus::dimming_mainfi_tclMsgDIM_INFO_CarIlluminationDataStatus(const dimming_mainfi_tclMsgDIM_INFO_CarIlluminationDataStatus& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   IlluminationSwitch = coRef.IlluminationSwitch;
   IlluminationBrightness = coRef.IlluminationBrightness;
}
dimming_mainfi_tclMsgDIM_INFO_CarIlluminationDataStatus& dimming_mainfi_tclMsgDIM_INFO_CarIlluminationDataStatus::operator=(const dimming_mainfi_tclMsgDIM_INFO_CarIlluminationDataStatus& coRef)
{
   if (this == &coRef) return *this;
   IlluminationSwitch = coRef.IlluminationSwitch;
   IlluminationBrightness = coRef.IlluminationBrightness;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_INFO_CarIlluminationDataStatus::dimming_mainfi_tclMsgDIM_INFO_CarIlluminationDataStatus()
:IlluminationSwitch()
,IlluminationBrightness()
 {}

tS32 dimming_mainfi_tclMsgDIM_INFO_CarIlluminationDataStatus::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_INFO_CARILLUMINATIONDATASTATUS;
}


dimming_mainfi_tclMsgDIM_INFO_CarIlluminationDataStatus::~dimming_mainfi_tclMsgDIM_INFO_CarIlluminationDataStatus()
{}

tU32 dimming_mainfi_tclMsgDIM_INFO_CarIlluminationDataStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_INFO_CarIlluminationDataStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> IlluminationSwitch);
   (tVoid) (oIn >> IlluminationBrightness);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_INFO_CarIlluminationDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << IlluminationSwitch);
   (tVoid) (oOut << IlluminationBrightness);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_INFO_CarIlluminationDataStatus::operator==(const dimming_mainfi_tclMsgDIM_INFO_CarIlluminationDataStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (IlluminationSwitch == roRef.IlluminationSwitch);
   bResult = bResult && (IlluminationBrightness == roRef.IlluminationBrightness);
   return bResult;
}

//=============================================================================

dimming_mainfi_tclMsgDIM_INFO_LightSensorBrightnessUpReg::dimming_mainfi_tclMsgDIM_INFO_LightSensorBrightnessUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_INFO_LightSensorBrightnessUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_INFO_LIGHTSENSORBRIGHTNESSUPREG;
}


dimming_mainfi_tclMsgDIM_INFO_LightSensorBrightnessUpReg::~dimming_mainfi_tclMsgDIM_INFO_LightSensorBrightnessUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_INFO_LightSensorBrightnessRelUpReg::dimming_mainfi_tclMsgDIM_INFO_LightSensorBrightnessRelUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_INFO_LightSensorBrightnessRelUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_INFO_LIGHTSENSORBRIGHTNESSRELUPREG;
}


dimming_mainfi_tclMsgDIM_INFO_LightSensorBrightnessRelUpReg::~dimming_mainfi_tclMsgDIM_INFO_LightSensorBrightnessRelUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_INFO_LightSensorBrightnessGet::dimming_mainfi_tclMsgDIM_INFO_LightSensorBrightnessGet()
 {}

tS32 dimming_mainfi_tclMsgDIM_INFO_LightSensorBrightnessGet::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_INFO_LIGHTSENSORBRIGHTNESSGET;
}


dimming_mainfi_tclMsgDIM_INFO_LightSensorBrightnessGet::~dimming_mainfi_tclMsgDIM_INFO_LightSensorBrightnessGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_INFO_LightSensorBrightnessStatus::dimming_mainfi_tclMsgDIM_INFO_LightSensorBrightnessStatus(const dimming_mainfi_tclMsgDIM_INFO_LightSensorBrightnessStatus& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   SensorAvail = coRef.SensorAvail;
   SensorBrightness = coRef.SensorBrightness;
}
dimming_mainfi_tclMsgDIM_INFO_LightSensorBrightnessStatus& dimming_mainfi_tclMsgDIM_INFO_LightSensorBrightnessStatus::operator=(const dimming_mainfi_tclMsgDIM_INFO_LightSensorBrightnessStatus& coRef)
{
   if (this == &coRef) return *this;
   SensorAvail = coRef.SensorAvail;
   SensorBrightness = coRef.SensorBrightness;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_INFO_LightSensorBrightnessStatus::dimming_mainfi_tclMsgDIM_INFO_LightSensorBrightnessStatus()
:SensorAvail()
,SensorBrightness()
 {}

tS32 dimming_mainfi_tclMsgDIM_INFO_LightSensorBrightnessStatus::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_INFO_LIGHTSENSORBRIGHTNESSSTATUS;
}


dimming_mainfi_tclMsgDIM_INFO_LightSensorBrightnessStatus::~dimming_mainfi_tclMsgDIM_INFO_LightSensorBrightnessStatus()
{}

tU32 dimming_mainfi_tclMsgDIM_INFO_LightSensorBrightnessStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_INFO_LightSensorBrightnessStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SensorAvail);
   (tVoid) (oIn >> SensorBrightness);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_INFO_LightSensorBrightnessStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SensorAvail);
   (tVoid) (oOut << SensorBrightness);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_INFO_LightSensorBrightnessStatus::operator==(const dimming_mainfi_tclMsgDIM_INFO_LightSensorBrightnessStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SensorAvail == roRef.SensorAvail);
   bResult = bResult && (SensorBrightness == roRef.SensorBrightness);
   return bResult;
}

//=============================================================================

dimming_mainfi_tclMsgDIM_INFO_DimmingModeUpReg::dimming_mainfi_tclMsgDIM_INFO_DimmingModeUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_INFO_DimmingModeUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_INFO_DIMMINGMODEUPREG;
}


dimming_mainfi_tclMsgDIM_INFO_DimmingModeUpReg::~dimming_mainfi_tclMsgDIM_INFO_DimmingModeUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_INFO_DimmingModeRelUpReg::dimming_mainfi_tclMsgDIM_INFO_DimmingModeRelUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_INFO_DimmingModeRelUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_INFO_DIMMINGMODERELUPREG;
}


dimming_mainfi_tclMsgDIM_INFO_DimmingModeRelUpReg::~dimming_mainfi_tclMsgDIM_INFO_DimmingModeRelUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_INFO_DimmingModeGet::dimming_mainfi_tclMsgDIM_INFO_DimmingModeGet()
 {}

tS32 dimming_mainfi_tclMsgDIM_INFO_DimmingModeGet::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_INFO_DIMMINGMODEGET;
}


dimming_mainfi_tclMsgDIM_INFO_DimmingModeGet::~dimming_mainfi_tclMsgDIM_INFO_DimmingModeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_INFO_DimmingModeStatus::dimming_mainfi_tclMsgDIM_INFO_DimmingModeStatus(const dimming_mainfi_tclMsgDIM_INFO_DimmingModeStatus& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   Config = coRef.Config;
   Car = coRef.Car;
   Status = coRef.Status;
}
dimming_mainfi_tclMsgDIM_INFO_DimmingModeStatus& dimming_mainfi_tclMsgDIM_INFO_DimmingModeStatus::operator=(const dimming_mainfi_tclMsgDIM_INFO_DimmingModeStatus& coRef)
{
   if (this == &coRef) return *this;
   Config = coRef.Config;
   Car = coRef.Car;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_INFO_DimmingModeStatus::dimming_mainfi_tclMsgDIM_INFO_DimmingModeStatus()
:Config()
,Car()
,Status()
 {}

tS32 dimming_mainfi_tclMsgDIM_INFO_DimmingModeStatus::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_INFO_DIMMINGMODESTATUS;
}


dimming_mainfi_tclMsgDIM_INFO_DimmingModeStatus::~dimming_mainfi_tclMsgDIM_INFO_DimmingModeStatus()
{}

tU32 dimming_mainfi_tclMsgDIM_INFO_DimmingModeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_INFO_DimmingModeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Config);
   (tVoid) (oIn >> Car);
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_INFO_DimmingModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Config);
   (tVoid) (oOut << Car);
   (tVoid) (oOut << Status);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_INFO_DimmingModeStatus::operator==(const dimming_mainfi_tclMsgDIM_INFO_DimmingModeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Config == roRef.Config);
   bResult = bResult && (Car == roRef.Car);
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

dimming_mainfi_tclMsgDIM_INFO_EmulationModeUpReg::dimming_mainfi_tclMsgDIM_INFO_EmulationModeUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_INFO_EmulationModeUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_INFO_EMULATIONMODEUPREG;
}


dimming_mainfi_tclMsgDIM_INFO_EmulationModeUpReg::~dimming_mainfi_tclMsgDIM_INFO_EmulationModeUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_INFO_EmulationModeRelUpReg::dimming_mainfi_tclMsgDIM_INFO_EmulationModeRelUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_INFO_EmulationModeRelUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_INFO_EMULATIONMODERELUPREG;
}


dimming_mainfi_tclMsgDIM_INFO_EmulationModeRelUpReg::~dimming_mainfi_tclMsgDIM_INFO_EmulationModeRelUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_INFO_EmulationModeGet::dimming_mainfi_tclMsgDIM_INFO_EmulationModeGet()
 {}

tS32 dimming_mainfi_tclMsgDIM_INFO_EmulationModeGet::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_INFO_EMULATIONMODEGET;
}


dimming_mainfi_tclMsgDIM_INFO_EmulationModeGet::~dimming_mainfi_tclMsgDIM_INFO_EmulationModeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_INFO_EmulationModeStatus::dimming_mainfi_tclMsgDIM_INFO_EmulationModeStatus(const dimming_mainfi_tclMsgDIM_INFO_EmulationModeStatus& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   EmulationMode = coRef.EmulationMode;
}
dimming_mainfi_tclMsgDIM_INFO_EmulationModeStatus& dimming_mainfi_tclMsgDIM_INFO_EmulationModeStatus::operator=(const dimming_mainfi_tclMsgDIM_INFO_EmulationModeStatus& coRef)
{
   if (this == &coRef) return *this;
   EmulationMode = coRef.EmulationMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_INFO_EmulationModeStatus::dimming_mainfi_tclMsgDIM_INFO_EmulationModeStatus()
:EmulationMode()
 {}

tS32 dimming_mainfi_tclMsgDIM_INFO_EmulationModeStatus::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_INFO_EMULATIONMODESTATUS;
}


dimming_mainfi_tclMsgDIM_INFO_EmulationModeStatus::~dimming_mainfi_tclMsgDIM_INFO_EmulationModeStatus()
{}

tU32 dimming_mainfi_tclMsgDIM_INFO_EmulationModeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_INFO_EmulationModeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> EmulationMode);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_INFO_EmulationModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << EmulationMode);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_INFO_EmulationModeStatus::operator==(const dimming_mainfi_tclMsgDIM_INFO_EmulationModeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (EmulationMode == roRef.EmulationMode);
   return bResult;
}

//=============================================================================

dimming_mainfi_tclMsgDIM_INFO_ITCUpReg::dimming_mainfi_tclMsgDIM_INFO_ITCUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_INFO_ITCUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_INFO_ITCUPREG;
}


dimming_mainfi_tclMsgDIM_INFO_ITCUpReg::~dimming_mainfi_tclMsgDIM_INFO_ITCUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_INFO_ITCRelUpReg::dimming_mainfi_tclMsgDIM_INFO_ITCRelUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_INFO_ITCRelUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_INFO_ITCRELUPREG;
}


dimming_mainfi_tclMsgDIM_INFO_ITCRelUpReg::~dimming_mainfi_tclMsgDIM_INFO_ITCRelUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_INFO_ITCGet::dimming_mainfi_tclMsgDIM_INFO_ITCGet()
 {}

tS32 dimming_mainfi_tclMsgDIM_INFO_ITCGet::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_INFO_ITCGET;
}


dimming_mainfi_tclMsgDIM_INFO_ITCGet::~dimming_mainfi_tclMsgDIM_INFO_ITCGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_INFO_ITCStatus::dimming_mainfi_tclMsgDIM_INFO_ITCStatus(const dimming_mainfi_tclMsgDIM_INFO_ITCStatus& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   ITC = coRef.ITC;
}
dimming_mainfi_tclMsgDIM_INFO_ITCStatus& dimming_mainfi_tclMsgDIM_INFO_ITCStatus::operator=(const dimming_mainfi_tclMsgDIM_INFO_ITCStatus& coRef)
{
   if (this == &coRef) return *this;
   ITC = coRef.ITC;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_INFO_ITCStatus::dimming_mainfi_tclMsgDIM_INFO_ITCStatus()
:ITC(0)
 {}

tS32 dimming_mainfi_tclMsgDIM_INFO_ITCStatus::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_INFO_ITCSTATUS;
}


dimming_mainfi_tclMsgDIM_INFO_ITCStatus::~dimming_mainfi_tclMsgDIM_INFO_ITCStatus()
{}

tU32 dimming_mainfi_tclMsgDIM_INFO_ITCStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_INFO_ITCStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ITC);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_INFO_ITCStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ITC);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_INFO_ITCStatus::operator==(const dimming_mainfi_tclMsgDIM_INFO_ITCStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ITC == roRef.ITC);
   return bResult;
}

//=============================================================================

dimming_mainfi_tclMsgDIM_INFO_PWMBrightnessUpReg::dimming_mainfi_tclMsgDIM_INFO_PWMBrightnessUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_INFO_PWMBrightnessUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_INFO_PWMBRIGHTNESSUPREG;
}


dimming_mainfi_tclMsgDIM_INFO_PWMBrightnessUpReg::~dimming_mainfi_tclMsgDIM_INFO_PWMBrightnessUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_INFO_PWMBrightnessRelUpReg::dimming_mainfi_tclMsgDIM_INFO_PWMBrightnessRelUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_INFO_PWMBrightnessRelUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_INFO_PWMBRIGHTNESSRELUPREG;
}


dimming_mainfi_tclMsgDIM_INFO_PWMBrightnessRelUpReg::~dimming_mainfi_tclMsgDIM_INFO_PWMBrightnessRelUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_INFO_PWMBrightnessGet::dimming_mainfi_tclMsgDIM_INFO_PWMBrightnessGet()
 {}

tS32 dimming_mainfi_tclMsgDIM_INFO_PWMBrightnessGet::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_INFO_PWMBRIGHTNESSGET;
}


dimming_mainfi_tclMsgDIM_INFO_PWMBrightnessGet::~dimming_mainfi_tclMsgDIM_INFO_PWMBrightnessGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_INFO_PWMBrightnessStatus::dimming_mainfi_tclMsgDIM_INFO_PWMBrightnessStatus(const dimming_mainfi_tclMsgDIM_INFO_PWMBrightnessStatus& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   PWMBrightness = coRef.PWMBrightness;
}
dimming_mainfi_tclMsgDIM_INFO_PWMBrightnessStatus& dimming_mainfi_tclMsgDIM_INFO_PWMBrightnessStatus::operator=(const dimming_mainfi_tclMsgDIM_INFO_PWMBrightnessStatus& coRef)
{
   if (this == &coRef) return *this;
   PWMBrightness = coRef.PWMBrightness;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_INFO_PWMBrightnessStatus::dimming_mainfi_tclMsgDIM_INFO_PWMBrightnessStatus()
:PWMBrightness()
 {}

tS32 dimming_mainfi_tclMsgDIM_INFO_PWMBrightnessStatus::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_INFO_PWMBRIGHTNESSSTATUS;
}


dimming_mainfi_tclMsgDIM_INFO_PWMBrightnessStatus::~dimming_mainfi_tclMsgDIM_INFO_PWMBrightnessStatus()
{}

tU32 dimming_mainfi_tclMsgDIM_INFO_PWMBrightnessStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_INFO_PWMBrightnessStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PWMBrightness);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_INFO_PWMBrightnessStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PWMBrightness);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_INFO_PWMBrightnessStatus::operator==(const dimming_mainfi_tclMsgDIM_INFO_PWMBrightnessStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PWMBrightness == roRef.PWMBrightness);
   return bResult;
}

//=============================================================================

dimming_mainfi_tclMsgDIM_INFO_CANBrightnessUpReg::dimming_mainfi_tclMsgDIM_INFO_CANBrightnessUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_INFO_CANBrightnessUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_INFO_CANBRIGHTNESSUPREG;
}


dimming_mainfi_tclMsgDIM_INFO_CANBrightnessUpReg::~dimming_mainfi_tclMsgDIM_INFO_CANBrightnessUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_INFO_CANBrightnessRelUpReg::dimming_mainfi_tclMsgDIM_INFO_CANBrightnessRelUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_INFO_CANBrightnessRelUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_INFO_CANBRIGHTNESSRELUPREG;
}


dimming_mainfi_tclMsgDIM_INFO_CANBrightnessRelUpReg::~dimming_mainfi_tclMsgDIM_INFO_CANBrightnessRelUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_INFO_CANBrightnessGet::dimming_mainfi_tclMsgDIM_INFO_CANBrightnessGet()
 {}

tS32 dimming_mainfi_tclMsgDIM_INFO_CANBrightnessGet::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_INFO_CANBRIGHTNESSGET;
}


dimming_mainfi_tclMsgDIM_INFO_CANBrightnessGet::~dimming_mainfi_tclMsgDIM_INFO_CANBrightnessGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_INFO_CANBrightnessStatus::dimming_mainfi_tclMsgDIM_INFO_CANBrightnessStatus(const dimming_mainfi_tclMsgDIM_INFO_CANBrightnessStatus& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   CANBrightness = coRef.CANBrightness;
}
dimming_mainfi_tclMsgDIM_INFO_CANBrightnessStatus& dimming_mainfi_tclMsgDIM_INFO_CANBrightnessStatus::operator=(const dimming_mainfi_tclMsgDIM_INFO_CANBrightnessStatus& coRef)
{
   if (this == &coRef) return *this;
   CANBrightness = coRef.CANBrightness;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_INFO_CANBrightnessStatus::dimming_mainfi_tclMsgDIM_INFO_CANBrightnessStatus()
:CANBrightness()
 {}

tS32 dimming_mainfi_tclMsgDIM_INFO_CANBrightnessStatus::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_INFO_CANBRIGHTNESSSTATUS;
}


dimming_mainfi_tclMsgDIM_INFO_CANBrightnessStatus::~dimming_mainfi_tclMsgDIM_INFO_CANBrightnessStatus()
{}

tU32 dimming_mainfi_tclMsgDIM_INFO_CANBrightnessStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_INFO_CANBrightnessStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CANBrightness);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_INFO_CANBrightnessStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CANBrightness);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_INFO_CANBrightnessStatus::operator==(const dimming_mainfi_tclMsgDIM_INFO_CANBrightnessStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CANBrightness == roRef.CANBrightness);
   return bResult;
}

//=============================================================================

dimming_mainfi_tclMsgDIM_KEYB_BrightnessUpReg::dimming_mainfi_tclMsgDIM_KEYB_BrightnessUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_KEYB_BrightnessUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_KEYB_BRIGHTNESSUPREG;
}


dimming_mainfi_tclMsgDIM_KEYB_BrightnessUpReg::~dimming_mainfi_tclMsgDIM_KEYB_BrightnessUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_KEYB_BrightnessRelUpReg::dimming_mainfi_tclMsgDIM_KEYB_BrightnessRelUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_KEYB_BrightnessRelUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_KEYB_BRIGHTNESSRELUPREG;
}


dimming_mainfi_tclMsgDIM_KEYB_BrightnessRelUpReg::~dimming_mainfi_tclMsgDIM_KEYB_BrightnessRelUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_KEYB_BrightnessGet::dimming_mainfi_tclMsgDIM_KEYB_BrightnessGet()
 {}

tS32 dimming_mainfi_tclMsgDIM_KEYB_BrightnessGet::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_KEYB_BRIGHTNESSGET;
}


dimming_mainfi_tclMsgDIM_KEYB_BrightnessGet::~dimming_mainfi_tclMsgDIM_KEYB_BrightnessGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_KEYB_BrightnessStatus::dimming_mainfi_tclMsgDIM_KEYB_BrightnessStatus(const dimming_mainfi_tclMsgDIM_KEYB_BrightnessStatus& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   Brightness = coRef.Brightness;
}
dimming_mainfi_tclMsgDIM_KEYB_BrightnessStatus& dimming_mainfi_tclMsgDIM_KEYB_BrightnessStatus::operator=(const dimming_mainfi_tclMsgDIM_KEYB_BrightnessStatus& coRef)
{
   if (this == &coRef) return *this;
   Brightness = coRef.Brightness;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_KEYB_BrightnessStatus::dimming_mainfi_tclMsgDIM_KEYB_BrightnessStatus()
:Brightness()
 {}

tS32 dimming_mainfi_tclMsgDIM_KEYB_BrightnessStatus::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_KEYB_BRIGHTNESSSTATUS;
}


dimming_mainfi_tclMsgDIM_KEYB_BrightnessStatus::~dimming_mainfi_tclMsgDIM_KEYB_BrightnessStatus()
{}

tU32 dimming_mainfi_tclMsgDIM_KEYB_BrightnessStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_KEYB_BrightnessStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Brightness);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_KEYB_BrightnessStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Brightness);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_KEYB_BrightnessStatus::operator==(const dimming_mainfi_tclMsgDIM_KEYB_BrightnessStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Brightness == roRef.Brightness);
   return bResult;
}

//=============================================================================

dimming_mainfi_tclMsgDIM_KEYB_HalfclassUpReg::dimming_mainfi_tclMsgDIM_KEYB_HalfclassUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_KEYB_HalfclassUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_KEYB_HALFCLASSUPREG;
}


dimming_mainfi_tclMsgDIM_KEYB_HalfclassUpReg::~dimming_mainfi_tclMsgDIM_KEYB_HalfclassUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_KEYB_HalfclassRelUpReg::dimming_mainfi_tclMsgDIM_KEYB_HalfclassRelUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_KEYB_HalfclassRelUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_KEYB_HALFCLASSRELUPREG;
}


dimming_mainfi_tclMsgDIM_KEYB_HalfclassRelUpReg::~dimming_mainfi_tclMsgDIM_KEYB_HalfclassRelUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_KEYB_HalfclassGet::dimming_mainfi_tclMsgDIM_KEYB_HalfclassGet()
 {}

tS32 dimming_mainfi_tclMsgDIM_KEYB_HalfclassGet::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_KEYB_HALFCLASSGET;
}


dimming_mainfi_tclMsgDIM_KEYB_HalfclassGet::~dimming_mainfi_tclMsgDIM_KEYB_HalfclassGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_KEYB_HalfclassStatus::dimming_mainfi_tclMsgDIM_KEYB_HalfclassStatus(const dimming_mainfi_tclMsgDIM_KEYB_HalfclassStatus& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   Halfclass_A = coRef.Halfclass_A;
   Halfclass_B = coRef.Halfclass_B;
   ADC_CFG_A = coRef.ADC_CFG_A;
   ADC_CFG_B = coRef.ADC_CFG_B;
   ADC_A = coRef.ADC_A;
   ADC_B = coRef.ADC_B;
   PWM_HC_A = coRef.PWM_HC_A;
   PWM_HC_B = coRef.PWM_HC_B;
}
dimming_mainfi_tclMsgDIM_KEYB_HalfclassStatus& dimming_mainfi_tclMsgDIM_KEYB_HalfclassStatus::operator=(const dimming_mainfi_tclMsgDIM_KEYB_HalfclassStatus& coRef)
{
   if (this == &coRef) return *this;
   Halfclass_A = coRef.Halfclass_A;
   Halfclass_B = coRef.Halfclass_B;
   ADC_CFG_A = coRef.ADC_CFG_A;
   ADC_CFG_B = coRef.ADC_CFG_B;
   ADC_A = coRef.ADC_A;
   ADC_B = coRef.ADC_B;
   PWM_HC_A = coRef.PWM_HC_A;
   PWM_HC_B = coRef.PWM_HC_B;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_KEYB_HalfclassStatus::dimming_mainfi_tclMsgDIM_KEYB_HalfclassStatus()
:Halfclass_A()
,Halfclass_B()
,ADC_CFG_A(0)
,ADC_CFG_B(0)
,ADC_A(0)
,ADC_B(0)
,PWM_HC_A(0)
,PWM_HC_B(0)
 {}

tS32 dimming_mainfi_tclMsgDIM_KEYB_HalfclassStatus::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_KEYB_HALFCLASSSTATUS;
}


dimming_mainfi_tclMsgDIM_KEYB_HalfclassStatus::~dimming_mainfi_tclMsgDIM_KEYB_HalfclassStatus()
{}

tU32 dimming_mainfi_tclMsgDIM_KEYB_HalfclassStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_KEYB_HalfclassStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Halfclass_A);
   (tVoid) (oIn >> Halfclass_B);
   (tVoid) (oIn >> ADC_CFG_A);
   (tVoid) (oIn >> ADC_CFG_B);
   (tVoid) (oIn >> ADC_A);
   (tVoid) (oIn >> ADC_B);
   (tVoid) (oIn >> PWM_HC_A);
   (tVoid) (oIn >> PWM_HC_B);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_KEYB_HalfclassStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Halfclass_A);
   (tVoid) (oOut << Halfclass_B);
   (tVoid) (oOut << ADC_CFG_A);
   (tVoid) (oOut << ADC_CFG_B);
   (tVoid) (oOut << ADC_A);
   (tVoid) (oOut << ADC_B);
   (tVoid) (oOut << PWM_HC_A);
   (tVoid) (oOut << PWM_HC_B);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_KEYB_HalfclassStatus::operator==(const dimming_mainfi_tclMsgDIM_KEYB_HalfclassStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Halfclass_A == roRef.Halfclass_A);
   bResult = bResult && (Halfclass_B == roRef.Halfclass_B);
   bResult = bResult && (ADC_CFG_A == roRef.ADC_CFG_A);
   bResult = bResult && (ADC_CFG_B == roRef.ADC_CFG_B);
   bResult = bResult && (ADC_A == roRef.ADC_A);
   bResult = bResult && (ADC_B == roRef.ADC_B);
   bResult = bResult && (PWM_HC_A == roRef.PWM_HC_A);
   bResult = bResult && (PWM_HC_B == roRef.PWM_HC_B);
   return bResult;
}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_DriverInitalizedUpReg::dimming_mainfi_tclMsgDIM_DISP_DriverInitalizedUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_DriverInitalizedUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_DRIVERINITALIZEDUPREG;
}


dimming_mainfi_tclMsgDIM_DISP_DriverInitalizedUpReg::~dimming_mainfi_tclMsgDIM_DISP_DriverInitalizedUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_DriverInitalizedRelUpReg::dimming_mainfi_tclMsgDIM_DISP_DriverInitalizedRelUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_DriverInitalizedRelUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_DRIVERINITALIZEDRELUPREG;
}


dimming_mainfi_tclMsgDIM_DISP_DriverInitalizedRelUpReg::~dimming_mainfi_tclMsgDIM_DISP_DriverInitalizedRelUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_DriverInitalizedGet::dimming_mainfi_tclMsgDIM_DISP_DriverInitalizedGet()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_DriverInitalizedGet::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_DRIVERINITALIZEDGET;
}


dimming_mainfi_tclMsgDIM_DISP_DriverInitalizedGet::~dimming_mainfi_tclMsgDIM_DISP_DriverInitalizedGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DISP_DriverInitalizedStatus::dimming_mainfi_tclMsgDIM_DISP_DriverInitalizedStatus(const dimming_mainfi_tclMsgDIM_DISP_DriverInitalizedStatus& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   DriverInitialized = coRef.DriverInitialized;
}
dimming_mainfi_tclMsgDIM_DISP_DriverInitalizedStatus& dimming_mainfi_tclMsgDIM_DISP_DriverInitalizedStatus::operator=(const dimming_mainfi_tclMsgDIM_DISP_DriverInitalizedStatus& coRef)
{
   if (this == &coRef) return *this;
   DriverInitialized = coRef.DriverInitialized;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DISP_DriverInitalizedStatus::dimming_mainfi_tclMsgDIM_DISP_DriverInitalizedStatus()
:DriverInitialized()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_DriverInitalizedStatus::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_DRIVERINITALIZEDSTATUS;
}


dimming_mainfi_tclMsgDIM_DISP_DriverInitalizedStatus::~dimming_mainfi_tclMsgDIM_DISP_DriverInitalizedStatus()
{}

tU32 dimming_mainfi_tclMsgDIM_DISP_DriverInitalizedStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DISP_DriverInitalizedStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DriverInitialized);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DISP_DriverInitalizedStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DriverInitialized);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DISP_DriverInitalizedStatus::operator==(const dimming_mainfi_tclMsgDIM_DISP_DriverInitalizedStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DriverInitialized == roRef.DriverInitialized);
   return bResult;
}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_ScreenContentAvailableUpReg::dimming_mainfi_tclMsgDIM_DISP_ScreenContentAvailableUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_ScreenContentAvailableUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SCREENCONTENTAVAILABLEUPREG;
}


dimming_mainfi_tclMsgDIM_DISP_ScreenContentAvailableUpReg::~dimming_mainfi_tclMsgDIM_DISP_ScreenContentAvailableUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_ScreenContentAvailableRelUpReg::dimming_mainfi_tclMsgDIM_DISP_ScreenContentAvailableRelUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_ScreenContentAvailableRelUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SCREENCONTENTAVAILABLERELUPREG;
}


dimming_mainfi_tclMsgDIM_DISP_ScreenContentAvailableRelUpReg::~dimming_mainfi_tclMsgDIM_DISP_ScreenContentAvailableRelUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_ScreenContentAvailableGet::dimming_mainfi_tclMsgDIM_DISP_ScreenContentAvailableGet()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_ScreenContentAvailableGet::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SCREENCONTENTAVAILABLEGET;
}


dimming_mainfi_tclMsgDIM_DISP_ScreenContentAvailableGet::~dimming_mainfi_tclMsgDIM_DISP_ScreenContentAvailableGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DISP_ScreenContentAvailableStatus::dimming_mainfi_tclMsgDIM_DISP_ScreenContentAvailableStatus(const dimming_mainfi_tclMsgDIM_DISP_ScreenContentAvailableStatus& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   ContentAvailable = coRef.ContentAvailable;
}
dimming_mainfi_tclMsgDIM_DISP_ScreenContentAvailableStatus& dimming_mainfi_tclMsgDIM_DISP_ScreenContentAvailableStatus::operator=(const dimming_mainfi_tclMsgDIM_DISP_ScreenContentAvailableStatus& coRef)
{
   if (this == &coRef) return *this;
   ContentAvailable = coRef.ContentAvailable;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DISP_ScreenContentAvailableStatus::dimming_mainfi_tclMsgDIM_DISP_ScreenContentAvailableStatus()
:ContentAvailable()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_ScreenContentAvailableStatus::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SCREENCONTENTAVAILABLESTATUS;
}


dimming_mainfi_tclMsgDIM_DISP_ScreenContentAvailableStatus::~dimming_mainfi_tclMsgDIM_DISP_ScreenContentAvailableStatus()
{}

tU32 dimming_mainfi_tclMsgDIM_DISP_ScreenContentAvailableStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DISP_ScreenContentAvailableStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ContentAvailable);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DISP_ScreenContentAvailableStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ContentAvailable);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DISP_ScreenContentAvailableStatus::operator==(const dimming_mainfi_tclMsgDIM_DISP_ScreenContentAvailableStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ContentAvailable == roRef.ContentAvailable);
   return bResult;
}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_BrightnessUpReg::dimming_mainfi_tclMsgDIM_DISP_BrightnessUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_BrightnessUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_BRIGHTNESSUPREG;
}


dimming_mainfi_tclMsgDIM_DISP_BrightnessUpReg::~dimming_mainfi_tclMsgDIM_DISP_BrightnessUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_BrightnessRelUpReg::dimming_mainfi_tclMsgDIM_DISP_BrightnessRelUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_BrightnessRelUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_BRIGHTNESSRELUPREG;
}


dimming_mainfi_tclMsgDIM_DISP_BrightnessRelUpReg::~dimming_mainfi_tclMsgDIM_DISP_BrightnessRelUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_BrightnessGet::dimming_mainfi_tclMsgDIM_DISP_BrightnessGet()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_BrightnessGet::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_BRIGHTNESSGET;
}


dimming_mainfi_tclMsgDIM_DISP_BrightnessGet::~dimming_mainfi_tclMsgDIM_DISP_BrightnessGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DISP_BrightnessStatus::dimming_mainfi_tclMsgDIM_DISP_BrightnessStatus(const dimming_mainfi_tclMsgDIM_DISP_BrightnessStatus& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   Brightness = coRef.Brightness;
}
dimming_mainfi_tclMsgDIM_DISP_BrightnessStatus& dimming_mainfi_tclMsgDIM_DISP_BrightnessStatus::operator=(const dimming_mainfi_tclMsgDIM_DISP_BrightnessStatus& coRef)
{
   if (this == &coRef) return *this;
   Brightness = coRef.Brightness;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DISP_BrightnessStatus::dimming_mainfi_tclMsgDIM_DISP_BrightnessStatus()
:Brightness()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_BrightnessStatus::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_BRIGHTNESSSTATUS;
}


dimming_mainfi_tclMsgDIM_DISP_BrightnessStatus::~dimming_mainfi_tclMsgDIM_DISP_BrightnessStatus()
{}

tU32 dimming_mainfi_tclMsgDIM_DISP_BrightnessStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DISP_BrightnessStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Brightness);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DISP_BrightnessStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Brightness);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DISP_BrightnessStatus::operator==(const dimming_mainfi_tclMsgDIM_DISP_BrightnessStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Brightness == roRef.Brightness);
   return bResult;
}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_BacklightUpReg::dimming_mainfi_tclMsgDIM_DISP_BacklightUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_BacklightUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_BACKLIGHTUPREG;
}


dimming_mainfi_tclMsgDIM_DISP_BacklightUpReg::~dimming_mainfi_tclMsgDIM_DISP_BacklightUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_BacklightRelUpReg::dimming_mainfi_tclMsgDIM_DISP_BacklightRelUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_BacklightRelUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_BACKLIGHTRELUPREG;
}


dimming_mainfi_tclMsgDIM_DISP_BacklightRelUpReg::~dimming_mainfi_tclMsgDIM_DISP_BacklightRelUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_BacklightGet::dimming_mainfi_tclMsgDIM_DISP_BacklightGet()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_BacklightGet::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_BACKLIGHTGET;
}


dimming_mainfi_tclMsgDIM_DISP_BacklightGet::~dimming_mainfi_tclMsgDIM_DISP_BacklightGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DISP_BacklightStatus::dimming_mainfi_tclMsgDIM_DISP_BacklightStatus(const dimming_mainfi_tclMsgDIM_DISP_BacklightStatus& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   BacklightStatus = coRef.BacklightStatus;
}
dimming_mainfi_tclMsgDIM_DISP_BacklightStatus& dimming_mainfi_tclMsgDIM_DISP_BacklightStatus::operator=(const dimming_mainfi_tclMsgDIM_DISP_BacklightStatus& coRef)
{
   if (this == &coRef) return *this;
   BacklightStatus = coRef.BacklightStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DISP_BacklightStatus::dimming_mainfi_tclMsgDIM_DISP_BacklightStatus()
:BacklightStatus()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_BacklightStatus::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_BACKLIGHTSTATUS;
}


dimming_mainfi_tclMsgDIM_DISP_BacklightStatus::~dimming_mainfi_tclMsgDIM_DISP_BacklightStatus()
{}

tU32 dimming_mainfi_tclMsgDIM_DISP_BacklightStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DISP_BacklightStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BacklightStatus);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DISP_BacklightStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BacklightStatus);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DISP_BacklightStatus::operator==(const dimming_mainfi_tclMsgDIM_DISP_BacklightStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BacklightStatus == roRef.BacklightStatus);
   return bResult;
}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_TemperatureInfoUpReg::dimming_mainfi_tclMsgDIM_DISP_TemperatureInfoUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_TemperatureInfoUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_TEMPERATUREINFOUPREG;
}


dimming_mainfi_tclMsgDIM_DISP_TemperatureInfoUpReg::~dimming_mainfi_tclMsgDIM_DISP_TemperatureInfoUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_TemperatureInfoRelUpReg::dimming_mainfi_tclMsgDIM_DISP_TemperatureInfoRelUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_TemperatureInfoRelUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_TEMPERATUREINFORELUPREG;
}


dimming_mainfi_tclMsgDIM_DISP_TemperatureInfoRelUpReg::~dimming_mainfi_tclMsgDIM_DISP_TemperatureInfoRelUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_TemperatureInfoGet::dimming_mainfi_tclMsgDIM_DISP_TemperatureInfoGet()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_TemperatureInfoGet::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_TEMPERATUREINFOGET;
}


dimming_mainfi_tclMsgDIM_DISP_TemperatureInfoGet::~dimming_mainfi_tclMsgDIM_DISP_TemperatureInfoGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DISP_TemperatureInfoStatus::dimming_mainfi_tclMsgDIM_DISP_TemperatureInfoStatus(const dimming_mainfi_tclMsgDIM_DISP_TemperatureInfoStatus& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   PanelTemp = coRef.PanelTemp;
   AmbientTemp = coRef.AmbientTemp;
   WarningLevel = coRef.WarningLevel;
   CriticalLevelTimeout = coRef.CriticalLevelTimeout;
   CriticalLevelElapsed = coRef.CriticalLevelElapsed;
}
dimming_mainfi_tclMsgDIM_DISP_TemperatureInfoStatus& dimming_mainfi_tclMsgDIM_DISP_TemperatureInfoStatus::operator=(const dimming_mainfi_tclMsgDIM_DISP_TemperatureInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   PanelTemp = coRef.PanelTemp;
   AmbientTemp = coRef.AmbientTemp;
   WarningLevel = coRef.WarningLevel;
   CriticalLevelTimeout = coRef.CriticalLevelTimeout;
   CriticalLevelElapsed = coRef.CriticalLevelElapsed;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DISP_TemperatureInfoStatus::dimming_mainfi_tclMsgDIM_DISP_TemperatureInfoStatus()
:PanelTemp()
,AmbientTemp()
,WarningLevel()
,CriticalLevelTimeout(0)
,CriticalLevelElapsed(0)
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_TemperatureInfoStatus::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_TEMPERATUREINFOSTATUS;
}


dimming_mainfi_tclMsgDIM_DISP_TemperatureInfoStatus::~dimming_mainfi_tclMsgDIM_DISP_TemperatureInfoStatus()
{}

tU32 dimming_mainfi_tclMsgDIM_DISP_TemperatureInfoStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DISP_TemperatureInfoStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PanelTemp);
   (tVoid) (oIn >> AmbientTemp);
   (tVoid) (oIn >> WarningLevel);
   (tVoid) (oIn >> CriticalLevelTimeout);
   (tVoid) (oIn >> CriticalLevelElapsed);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DISP_TemperatureInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PanelTemp);
   (tVoid) (oOut << AmbientTemp);
   (tVoid) (oOut << WarningLevel);
   (tVoid) (oOut << CriticalLevelTimeout);
   (tVoid) (oOut << CriticalLevelElapsed);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DISP_TemperatureInfoStatus::operator==(const dimming_mainfi_tclMsgDIM_DISP_TemperatureInfoStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PanelTemp == roRef.PanelTemp);
   bResult = bResult && (AmbientTemp == roRef.AmbientTemp);
   bResult = bResult && (WarningLevel == roRef.WarningLevel);
   bResult = bResult && (CriticalLevelTimeout == roRef.CriticalLevelTimeout);
   bResult = bResult && (CriticalLevelElapsed == roRef.CriticalLevelElapsed);
   return bResult;
}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_SizeUpReg::dimming_mainfi_tclMsgDIM_DISP_SizeUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_SizeUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SIZEUPREG;
}


dimming_mainfi_tclMsgDIM_DISP_SizeUpReg::~dimming_mainfi_tclMsgDIM_DISP_SizeUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_SizeRelUpReg::dimming_mainfi_tclMsgDIM_DISP_SizeRelUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_SizeRelUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SIZERELUPREG;
}


dimming_mainfi_tclMsgDIM_DISP_SizeRelUpReg::~dimming_mainfi_tclMsgDIM_DISP_SizeRelUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_SizeGet::dimming_mainfi_tclMsgDIM_DISP_SizeGet()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_SizeGet::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SIZEGET;
}


dimming_mainfi_tclMsgDIM_DISP_SizeGet::~dimming_mainfi_tclMsgDIM_DISP_SizeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DISP_SizeStatus::dimming_mainfi_tclMsgDIM_DISP_SizeStatus(const dimming_mainfi_tclMsgDIM_DISP_SizeStatus& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   Size = coRef.Size;
}
dimming_mainfi_tclMsgDIM_DISP_SizeStatus& dimming_mainfi_tclMsgDIM_DISP_SizeStatus::operator=(const dimming_mainfi_tclMsgDIM_DISP_SizeStatus& coRef)
{
   if (this == &coRef) return *this;
   Size = coRef.Size;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DISP_SizeStatus::dimming_mainfi_tclMsgDIM_DISP_SizeStatus()
:Size()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_SizeStatus::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_SIZESTATUS;
}


dimming_mainfi_tclMsgDIM_DISP_SizeStatus::~dimming_mainfi_tclMsgDIM_DISP_SizeStatus()
{}

tU32 dimming_mainfi_tclMsgDIM_DISP_SizeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DISP_SizeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Size);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DISP_SizeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Size);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DISP_SizeStatus::operator==(const dimming_mainfi_tclMsgDIM_DISP_SizeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Size == roRef.Size);
   return bResult;
}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelUpReg::dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_BRIGHTNESSLEVELUPREG;
}


dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelUpReg::~dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelRelUpReg::dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelRelUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelRelUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_BRIGHTNESSLEVELRELUPREG;
}


dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelRelUpReg::~dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelRelUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelGet::dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelGet()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelGet::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_BRIGHTNESSLEVELGET;
}


dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelGet::~dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelStatus::dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelStatus(const dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelStatus& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   BrightnessLevel = coRef.BrightnessLevel;
}
dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelStatus& dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelStatus::operator=(const dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelStatus& coRef)
{
   if (this == &coRef) return *this;
   BrightnessLevel = coRef.BrightnessLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelStatus::dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelStatus()
:BrightnessLevel()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelStatus::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_BRIGHTNESSLEVELSTATUS;
}


dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelStatus::~dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelStatus()
{}

tU32 dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BrightnessLevel);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BrightnessLevel);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelStatus::operator==(const dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BrightnessLevel == roRef.BrightnessLevel);
   return bResult;
}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_PanelTemperatureUpReg::dimming_mainfi_tclMsgDIM_DISP_PanelTemperatureUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_PanelTemperatureUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_PANELTEMPERATUREUPREG;
}


dimming_mainfi_tclMsgDIM_DISP_PanelTemperatureUpReg::~dimming_mainfi_tclMsgDIM_DISP_PanelTemperatureUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_PanelTemperatureRelUpReg::dimming_mainfi_tclMsgDIM_DISP_PanelTemperatureRelUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_PanelTemperatureRelUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_PANELTEMPERATURERELUPREG;
}


dimming_mainfi_tclMsgDIM_DISP_PanelTemperatureRelUpReg::~dimming_mainfi_tclMsgDIM_DISP_PanelTemperatureRelUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_PanelTemperatureGet::dimming_mainfi_tclMsgDIM_DISP_PanelTemperatureGet()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_PanelTemperatureGet::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_PANELTEMPERATUREGET;
}


dimming_mainfi_tclMsgDIM_DISP_PanelTemperatureGet::~dimming_mainfi_tclMsgDIM_DISP_PanelTemperatureGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DISP_PanelTemperatureStatus::dimming_mainfi_tclMsgDIM_DISP_PanelTemperatureStatus(const dimming_mainfi_tclMsgDIM_DISP_PanelTemperatureStatus& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   Temperature = coRef.Temperature;
}
dimming_mainfi_tclMsgDIM_DISP_PanelTemperatureStatus& dimming_mainfi_tclMsgDIM_DISP_PanelTemperatureStatus::operator=(const dimming_mainfi_tclMsgDIM_DISP_PanelTemperatureStatus& coRef)
{
   if (this == &coRef) return *this;
   Temperature = coRef.Temperature;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DISP_PanelTemperatureStatus::dimming_mainfi_tclMsgDIM_DISP_PanelTemperatureStatus()
:Temperature()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_PanelTemperatureStatus::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_PANELTEMPERATURESTATUS;
}


dimming_mainfi_tclMsgDIM_DISP_PanelTemperatureStatus::~dimming_mainfi_tclMsgDIM_DISP_PanelTemperatureStatus()
{}

tU32 dimming_mainfi_tclMsgDIM_DISP_PanelTemperatureStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DISP_PanelTemperatureStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Temperature);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DISP_PanelTemperatureStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Temperature);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DISP_PanelTemperatureStatus::operator==(const dimming_mainfi_tclMsgDIM_DISP_PanelTemperatureStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Temperature == roRef.Temperature);
   return bResult;
}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelExtendedUpReg::dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelExtendedUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelExtendedUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_BRIGHTNESSLEVELEXTENDEDUPREG;
}


dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelExtendedUpReg::~dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelExtendedUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelExtendedRelUpReg::dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelExtendedRelUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelExtendedRelUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_BRIGHTNESSLEVELEXTENDEDRELUPREG;
}


dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelExtendedRelUpReg::~dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelExtendedRelUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelExtendedGet::dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelExtendedGet()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelExtendedGet::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_BRIGHTNESSLEVELEXTENDEDGET;
}


dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelExtendedGet::~dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelExtendedGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelExtendedStatus::dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelExtendedStatus(const dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelExtendedStatus& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   BrightnessLevelExtended = coRef.BrightnessLevelExtended;
}
dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelExtendedStatus& dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelExtendedStatus::operator=(const dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelExtendedStatus& coRef)
{
   if (this == &coRef) return *this;
   BrightnessLevelExtended = coRef.BrightnessLevelExtended;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelExtendedStatus::dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelExtendedStatus()
:BrightnessLevelExtended(0)
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelExtendedStatus::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_BRIGHTNESSLEVELEXTENDEDSTATUS;
}


dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelExtendedStatus::~dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelExtendedStatus()
{}

tU32 dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelExtendedStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelExtendedStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BrightnessLevelExtended);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelExtendedStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BrightnessLevelExtended);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelExtendedStatus::operator==(const dimming_mainfi_tclMsgDIM_DISP_BrightnessLevelExtendedStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BrightnessLevelExtended == roRef.BrightnessLevelExtended);
   return bResult;
}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_VideoBrightnessLevelUpReg::dimming_mainfi_tclMsgDIM_DISP_VideoBrightnessLevelUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_VideoBrightnessLevelUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_VIDEOBRIGHTNESSLEVELUPREG;
}


dimming_mainfi_tclMsgDIM_DISP_VideoBrightnessLevelUpReg::~dimming_mainfi_tclMsgDIM_DISP_VideoBrightnessLevelUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_VideoBrightnessLevelRelUpReg::dimming_mainfi_tclMsgDIM_DISP_VideoBrightnessLevelRelUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_VideoBrightnessLevelRelUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_VIDEOBRIGHTNESSLEVELRELUPREG;
}


dimming_mainfi_tclMsgDIM_DISP_VideoBrightnessLevelRelUpReg::~dimming_mainfi_tclMsgDIM_DISP_VideoBrightnessLevelRelUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_VideoBrightnessLevelGet::dimming_mainfi_tclMsgDIM_DISP_VideoBrightnessLevelGet()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_VideoBrightnessLevelGet::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_VIDEOBRIGHTNESSLEVELGET;
}


dimming_mainfi_tclMsgDIM_DISP_VideoBrightnessLevelGet::~dimming_mainfi_tclMsgDIM_DISP_VideoBrightnessLevelGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DISP_VideoBrightnessLevelStatus::dimming_mainfi_tclMsgDIM_DISP_VideoBrightnessLevelStatus(const dimming_mainfi_tclMsgDIM_DISP_VideoBrightnessLevelStatus& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   VideoBrightnessLevel = coRef.VideoBrightnessLevel;
}
dimming_mainfi_tclMsgDIM_DISP_VideoBrightnessLevelStatus& dimming_mainfi_tclMsgDIM_DISP_VideoBrightnessLevelStatus::operator=(const dimming_mainfi_tclMsgDIM_DISP_VideoBrightnessLevelStatus& coRef)
{
   if (this == &coRef) return *this;
   VideoBrightnessLevel = coRef.VideoBrightnessLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DISP_VideoBrightnessLevelStatus::dimming_mainfi_tclMsgDIM_DISP_VideoBrightnessLevelStatus()
:VideoBrightnessLevel(0)
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_VideoBrightnessLevelStatus::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_VIDEOBRIGHTNESSLEVELSTATUS;
}


dimming_mainfi_tclMsgDIM_DISP_VideoBrightnessLevelStatus::~dimming_mainfi_tclMsgDIM_DISP_VideoBrightnessLevelStatus()
{}

tU32 dimming_mainfi_tclMsgDIM_DISP_VideoBrightnessLevelStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DISP_VideoBrightnessLevelStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VideoBrightnessLevel);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DISP_VideoBrightnessLevelStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VideoBrightnessLevel);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DISP_VideoBrightnessLevelStatus::operator==(const dimming_mainfi_tclMsgDIM_DISP_VideoBrightnessLevelStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VideoBrightnessLevel == roRef.VideoBrightnessLevel);
   return bResult;
}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_ContrastLevelUpReg::dimming_mainfi_tclMsgDIM_DISP_ContrastLevelUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_ContrastLevelUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_CONTRASTLEVELUPREG;
}


dimming_mainfi_tclMsgDIM_DISP_ContrastLevelUpReg::~dimming_mainfi_tclMsgDIM_DISP_ContrastLevelUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_ContrastLevelRelUpReg::dimming_mainfi_tclMsgDIM_DISP_ContrastLevelRelUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_ContrastLevelRelUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_CONTRASTLEVELRELUPREG;
}


dimming_mainfi_tclMsgDIM_DISP_ContrastLevelRelUpReg::~dimming_mainfi_tclMsgDIM_DISP_ContrastLevelRelUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_ContrastLevelGet::dimming_mainfi_tclMsgDIM_DISP_ContrastLevelGet()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_ContrastLevelGet::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_CONTRASTLEVELGET;
}


dimming_mainfi_tclMsgDIM_DISP_ContrastLevelGet::~dimming_mainfi_tclMsgDIM_DISP_ContrastLevelGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DISP_ContrastLevelStatus::dimming_mainfi_tclMsgDIM_DISP_ContrastLevelStatus(const dimming_mainfi_tclMsgDIM_DISP_ContrastLevelStatus& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   Contrast = coRef.Contrast;
}
dimming_mainfi_tclMsgDIM_DISP_ContrastLevelStatus& dimming_mainfi_tclMsgDIM_DISP_ContrastLevelStatus::operator=(const dimming_mainfi_tclMsgDIM_DISP_ContrastLevelStatus& coRef)
{
   if (this == &coRef) return *this;
   Contrast = coRef.Contrast;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DISP_ContrastLevelStatus::dimming_mainfi_tclMsgDIM_DISP_ContrastLevelStatus()
:Contrast(0)
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_ContrastLevelStatus::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_CONTRASTLEVELSTATUS;
}


dimming_mainfi_tclMsgDIM_DISP_ContrastLevelStatus::~dimming_mainfi_tclMsgDIM_DISP_ContrastLevelStatus()
{}

tU32 dimming_mainfi_tclMsgDIM_DISP_ContrastLevelStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DISP_ContrastLevelStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Contrast);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DISP_ContrastLevelStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Contrast);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DISP_ContrastLevelStatus::operator==(const dimming_mainfi_tclMsgDIM_DISP_ContrastLevelStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Contrast == roRef.Contrast);
   return bResult;
}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_BlackLevelUpReg::dimming_mainfi_tclMsgDIM_DISP_BlackLevelUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_BlackLevelUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_BLACKLEVELUPREG;
}


dimming_mainfi_tclMsgDIM_DISP_BlackLevelUpReg::~dimming_mainfi_tclMsgDIM_DISP_BlackLevelUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_BlackLevelRelUpReg::dimming_mainfi_tclMsgDIM_DISP_BlackLevelRelUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_BlackLevelRelUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_BLACKLEVELRELUPREG;
}


dimming_mainfi_tclMsgDIM_DISP_BlackLevelRelUpReg::~dimming_mainfi_tclMsgDIM_DISP_BlackLevelRelUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_BlackLevelGet::dimming_mainfi_tclMsgDIM_DISP_BlackLevelGet()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_BlackLevelGet::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_BLACKLEVELGET;
}


dimming_mainfi_tclMsgDIM_DISP_BlackLevelGet::~dimming_mainfi_tclMsgDIM_DISP_BlackLevelGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DISP_BlackLevelStatus::dimming_mainfi_tclMsgDIM_DISP_BlackLevelStatus(const dimming_mainfi_tclMsgDIM_DISP_BlackLevelStatus& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   BlackLevel = coRef.BlackLevel;
}
dimming_mainfi_tclMsgDIM_DISP_BlackLevelStatus& dimming_mainfi_tclMsgDIM_DISP_BlackLevelStatus::operator=(const dimming_mainfi_tclMsgDIM_DISP_BlackLevelStatus& coRef)
{
   if (this == &coRef) return *this;
   BlackLevel = coRef.BlackLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DISP_BlackLevelStatus::dimming_mainfi_tclMsgDIM_DISP_BlackLevelStatus()
:BlackLevel(0)
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_BlackLevelStatus::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_BLACKLEVELSTATUS;
}


dimming_mainfi_tclMsgDIM_DISP_BlackLevelStatus::~dimming_mainfi_tclMsgDIM_DISP_BlackLevelStatus()
{}

tU32 dimming_mainfi_tclMsgDIM_DISP_BlackLevelStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DISP_BlackLevelStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BlackLevel);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DISP_BlackLevelStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BlackLevel);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DISP_BlackLevelStatus::operator==(const dimming_mainfi_tclMsgDIM_DISP_BlackLevelStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BlackLevel == roRef.BlackLevel);
   return bResult;
}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_YCurveLevelUpReg::dimming_mainfi_tclMsgDIM_DISP_YCurveLevelUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_YCurveLevelUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_YCURVELEVELUPREG;
}


dimming_mainfi_tclMsgDIM_DISP_YCurveLevelUpReg::~dimming_mainfi_tclMsgDIM_DISP_YCurveLevelUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_YCurveLevelRelUpReg::dimming_mainfi_tclMsgDIM_DISP_YCurveLevelRelUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_YCurveLevelRelUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_YCURVELEVELRELUPREG;
}


dimming_mainfi_tclMsgDIM_DISP_YCurveLevelRelUpReg::~dimming_mainfi_tclMsgDIM_DISP_YCurveLevelRelUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_YCurveLevelGet::dimming_mainfi_tclMsgDIM_DISP_YCurveLevelGet()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_YCurveLevelGet::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_YCURVELEVELGET;
}


dimming_mainfi_tclMsgDIM_DISP_YCurveLevelGet::~dimming_mainfi_tclMsgDIM_DISP_YCurveLevelGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DISP_YCurveLevelStatus::dimming_mainfi_tclMsgDIM_DISP_YCurveLevelStatus(const dimming_mainfi_tclMsgDIM_DISP_YCurveLevelStatus& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   YCurveLevel = coRef.YCurveLevel;
}
dimming_mainfi_tclMsgDIM_DISP_YCurveLevelStatus& dimming_mainfi_tclMsgDIM_DISP_YCurveLevelStatus::operator=(const dimming_mainfi_tclMsgDIM_DISP_YCurveLevelStatus& coRef)
{
   if (this == &coRef) return *this;
   YCurveLevel = coRef.YCurveLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DISP_YCurveLevelStatus::dimming_mainfi_tclMsgDIM_DISP_YCurveLevelStatus()
:YCurveLevel(0)
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_YCurveLevelStatus::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_YCURVELEVELSTATUS;
}


dimming_mainfi_tclMsgDIM_DISP_YCurveLevelStatus::~dimming_mainfi_tclMsgDIM_DISP_YCurveLevelStatus()
{}

tU32 dimming_mainfi_tclMsgDIM_DISP_YCurveLevelStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DISP_YCurveLevelStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> YCurveLevel);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DISP_YCurveLevelStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << YCurveLevel);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DISP_YCurveLevelStatus::operator==(const dimming_mainfi_tclMsgDIM_DISP_YCurveLevelStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (YCurveLevel == roRef.YCurveLevel);
   return bResult;
}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_TintLevelUpReg::dimming_mainfi_tclMsgDIM_DISP_TintLevelUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_TintLevelUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_TINTLEVELUPREG;
}


dimming_mainfi_tclMsgDIM_DISP_TintLevelUpReg::~dimming_mainfi_tclMsgDIM_DISP_TintLevelUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_TintLevelRelUpReg::dimming_mainfi_tclMsgDIM_DISP_TintLevelRelUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_TintLevelRelUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_TINTLEVELRELUPREG;
}


dimming_mainfi_tclMsgDIM_DISP_TintLevelRelUpReg::~dimming_mainfi_tclMsgDIM_DISP_TintLevelRelUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_TintLevelGet::dimming_mainfi_tclMsgDIM_DISP_TintLevelGet()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_TintLevelGet::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_TINTLEVELGET;
}


dimming_mainfi_tclMsgDIM_DISP_TintLevelGet::~dimming_mainfi_tclMsgDIM_DISP_TintLevelGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DISP_TintLevelStatus::dimming_mainfi_tclMsgDIM_DISP_TintLevelStatus(const dimming_mainfi_tclMsgDIM_DISP_TintLevelStatus& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   TintLevel = coRef.TintLevel;
}
dimming_mainfi_tclMsgDIM_DISP_TintLevelStatus& dimming_mainfi_tclMsgDIM_DISP_TintLevelStatus::operator=(const dimming_mainfi_tclMsgDIM_DISP_TintLevelStatus& coRef)
{
   if (this == &coRef) return *this;
   TintLevel = coRef.TintLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DISP_TintLevelStatus::dimming_mainfi_tclMsgDIM_DISP_TintLevelStatus()
:TintLevel(0)
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_TintLevelStatus::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_TINTLEVELSTATUS;
}


dimming_mainfi_tclMsgDIM_DISP_TintLevelStatus::~dimming_mainfi_tclMsgDIM_DISP_TintLevelStatus()
{}

tU32 dimming_mainfi_tclMsgDIM_DISP_TintLevelStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DISP_TintLevelStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TintLevel);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DISP_TintLevelStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TintLevel);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DISP_TintLevelStatus::operator==(const dimming_mainfi_tclMsgDIM_DISP_TintLevelStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TintLevel == roRef.TintLevel);
   return bResult;
}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_ColorLevelUpReg::dimming_mainfi_tclMsgDIM_DISP_ColorLevelUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_ColorLevelUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_COLORLEVELUPREG;
}


dimming_mainfi_tclMsgDIM_DISP_ColorLevelUpReg::~dimming_mainfi_tclMsgDIM_DISP_ColorLevelUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_ColorLevelRelUpReg::dimming_mainfi_tclMsgDIM_DISP_ColorLevelRelUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_ColorLevelRelUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_COLORLEVELRELUPREG;
}


dimming_mainfi_tclMsgDIM_DISP_ColorLevelRelUpReg::~dimming_mainfi_tclMsgDIM_DISP_ColorLevelRelUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_ColorLevelGet::dimming_mainfi_tclMsgDIM_DISP_ColorLevelGet()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_ColorLevelGet::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_COLORLEVELGET;
}


dimming_mainfi_tclMsgDIM_DISP_ColorLevelGet::~dimming_mainfi_tclMsgDIM_DISP_ColorLevelGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DISP_ColorLevelStatus::dimming_mainfi_tclMsgDIM_DISP_ColorLevelStatus(const dimming_mainfi_tclMsgDIM_DISP_ColorLevelStatus& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   Color = coRef.Color;
}
dimming_mainfi_tclMsgDIM_DISP_ColorLevelStatus& dimming_mainfi_tclMsgDIM_DISP_ColorLevelStatus::operator=(const dimming_mainfi_tclMsgDIM_DISP_ColorLevelStatus& coRef)
{
   if (this == &coRef) return *this;
   Color = coRef.Color;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DISP_ColorLevelStatus::dimming_mainfi_tclMsgDIM_DISP_ColorLevelStatus()
:Color(0)
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_ColorLevelStatus::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_COLORLEVELSTATUS;
}


dimming_mainfi_tclMsgDIM_DISP_ColorLevelStatus::~dimming_mainfi_tclMsgDIM_DISP_ColorLevelStatus()
{}

tU32 dimming_mainfi_tclMsgDIM_DISP_ColorLevelStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DISP_ColorLevelStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Color);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DISP_ColorLevelStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Color);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DISP_ColorLevelStatus::operator==(const dimming_mainfi_tclMsgDIM_DISP_ColorLevelStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Color == roRef.Color);
   return bResult;
}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETUpReg::dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_DAY_LUMINOSITY_OFFSETUPREG;
}


dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETUpReg::~dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETRelUpReg::dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETRelUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETRelUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_DAY_LUMINOSITY_OFFSETRELUPREG;
}


dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETRelUpReg::~dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETRelUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETGet::dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETGet()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETGet::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_DAY_LUMINOSITY_OFFSETGET;
}


dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETGet::~dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETSet::dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETSet(const dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETSet& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   DayLuminosityOffset = coRef.DayLuminosityOffset;
}
dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETSet& dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETSet::operator=(const dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETSet& coRef)
{
   if (this == &coRef) return *this;
   DayLuminosityOffset = coRef.DayLuminosityOffset;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETSet::dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETSet()
:DayLuminosityOffset(0)
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETSet::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_DAY_LUMINOSITY_OFFSETSET;
}


dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETSet::~dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETSet()
{}

tU32 dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DayLuminosityOffset);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DayLuminosityOffset);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETSet::operator==(const dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DayLuminosityOffset == roRef.DayLuminosityOffset);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETStatus::dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETStatus(const dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETStatus& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   DayLuminosityOffset = coRef.DayLuminosityOffset;
}
dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETStatus& dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETStatus::operator=(const dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETStatus& coRef)
{
   if (this == &coRef) return *this;
   DayLuminosityOffset = coRef.DayLuminosityOffset;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETStatus::dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETStatus()
:DayLuminosityOffset(0)
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETStatus::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_DAY_LUMINOSITY_OFFSETSTATUS;
}


dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETStatus::~dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETStatus()
{}

tU32 dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DayLuminosityOffset);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DayLuminosityOffset);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETStatus::operator==(const dimming_mainfi_tclMsgDIM_DISP_DAY_LUMINOSITY_OFFSETStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DayLuminosityOffset == roRef.DayLuminosityOffset);
   return bResult;
}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETUpReg::dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_NIGHT_LUMINOSITY_OFFSETUPREG;
}


dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETUpReg::~dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETRelUpReg::dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETRelUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETRelUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_NIGHT_LUMINOSITY_OFFSETRELUPREG;
}


dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETRelUpReg::~dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETRelUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETGet::dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETGet()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETGet::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_NIGHT_LUMINOSITY_OFFSETGET;
}


dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETGet::~dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETSet::dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETSet(const dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETSet& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   NightLuminosityOffset = coRef.NightLuminosityOffset;
}
dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETSet& dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETSet::operator=(const dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETSet& coRef)
{
   if (this == &coRef) return *this;
   NightLuminosityOffset = coRef.NightLuminosityOffset;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETSet::dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETSet()
:NightLuminosityOffset(0)
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETSet::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_NIGHT_LUMINOSITY_OFFSETSET;
}


dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETSet::~dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETSet()
{}

tU32 dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> NightLuminosityOffset);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << NightLuminosityOffset);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETSet::operator==(const dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (NightLuminosityOffset == roRef.NightLuminosityOffset);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETStatus::dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETStatus(const dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETStatus& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   NightLuminosityOffset = coRef.NightLuminosityOffset;
}
dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETStatus& dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETStatus::operator=(const dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETStatus& coRef)
{
   if (this == &coRef) return *this;
   NightLuminosityOffset = coRef.NightLuminosityOffset;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETStatus::dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETStatus()
:NightLuminosityOffset(0)
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETStatus::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_NIGHT_LUMINOSITY_OFFSETSTATUS;
}


dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETStatus::~dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETStatus()
{}

tU32 dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> NightLuminosityOffset);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << NightLuminosityOffset);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETStatus::operator==(const dimming_mainfi_tclMsgDIM_DISP_NIGHT_LUMINOSITY_OFFSETStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (NightLuminosityOffset == roRef.NightLuminosityOffset);
   return bResult;
}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETUpReg::dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_COCKPIT_SLIDER_OFFSETUPREG;
}


dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETUpReg::~dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETRelUpReg::dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETRelUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETRelUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_COCKPIT_SLIDER_OFFSETRELUPREG;
}


dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETRelUpReg::~dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETRelUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETGet::dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETGet()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETGet::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_COCKPIT_SLIDER_OFFSETGET;
}


dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETGet::~dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETSet::dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETSet(const dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETSet& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   CockpitDimmingSliderOffset = coRef.CockpitDimmingSliderOffset;
}
dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETSet& dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETSet::operator=(const dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETSet& coRef)
{
   if (this == &coRef) return *this;
   CockpitDimmingSliderOffset = coRef.CockpitDimmingSliderOffset;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETSet::dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETSet()
:CockpitDimmingSliderOffset(0)
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETSet::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_COCKPIT_SLIDER_OFFSETSET;
}


dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETSet::~dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETSet()
{}

tU32 dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CockpitDimmingSliderOffset);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CockpitDimmingSliderOffset);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETSet::operator==(const dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CockpitDimmingSliderOffset == roRef.CockpitDimmingSliderOffset);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETStatus::dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETStatus(const dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETStatus& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   CockpitDimmingSliderOffset = coRef.CockpitDimmingSliderOffset;
}
dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETStatus& dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETStatus::operator=(const dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETStatus& coRef)
{
   if (this == &coRef) return *this;
   CockpitDimmingSliderOffset = coRef.CockpitDimmingSliderOffset;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETStatus::dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETStatus()
:CockpitDimmingSliderOffset(0)
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETStatus::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_COCKPIT_SLIDER_OFFSETSTATUS;
}


dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETStatus::~dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETStatus()
{}

tU32 dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CockpitDimmingSliderOffset);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CockpitDimmingSliderOffset);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETStatus::operator==(const dimming_mainfi_tclMsgDIM_DISP_COCKPIT_SLIDER_OFFSETStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CockpitDimmingSliderOffset == roRef.CockpitDimmingSliderOffset);
   return bResult;
}

//=============================================================================

dimming_mainfi_tclMsgDIM_DIAG_VariantUpReg::dimming_mainfi_tclMsgDIM_DIAG_VariantUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_DIAG_VariantUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DIAG_VARIANTUPREG;
}


dimming_mainfi_tclMsgDIM_DIAG_VariantUpReg::~dimming_mainfi_tclMsgDIM_DIAG_VariantUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_DIAG_VariantRelUpReg::dimming_mainfi_tclMsgDIM_DIAG_VariantRelUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_DIAG_VariantRelUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DIAG_VARIANTRELUPREG;
}


dimming_mainfi_tclMsgDIM_DIAG_VariantRelUpReg::~dimming_mainfi_tclMsgDIM_DIAG_VariantRelUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_DIAG_VariantGet::dimming_mainfi_tclMsgDIM_DIAG_VariantGet()
 {}

tS32 dimming_mainfi_tclMsgDIM_DIAG_VariantGet::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DIAG_VARIANTGET;
}


dimming_mainfi_tclMsgDIM_DIAG_VariantGet::~dimming_mainfi_tclMsgDIM_DIAG_VariantGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DIAG_VariantStatus::dimming_mainfi_tclMsgDIM_DIAG_VariantStatus(const dimming_mainfi_tclMsgDIM_DIAG_VariantStatus& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   Variant = coRef.Variant;
}
dimming_mainfi_tclMsgDIM_DIAG_VariantStatus& dimming_mainfi_tclMsgDIM_DIAG_VariantStatus::operator=(const dimming_mainfi_tclMsgDIM_DIAG_VariantStatus& coRef)
{
   if (this == &coRef) return *this;
   Variant = coRef.Variant;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DIAG_VariantStatus::dimming_mainfi_tclMsgDIM_DIAG_VariantStatus()
:Variant(0)
 {}

tS32 dimming_mainfi_tclMsgDIM_DIAG_VariantStatus::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DIAG_VARIANTSTATUS;
}


dimming_mainfi_tclMsgDIM_DIAG_VariantStatus::~dimming_mainfi_tclMsgDIM_DIAG_VariantStatus()
{}

tU32 dimming_mainfi_tclMsgDIM_DIAG_VariantStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DIAG_VariantStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Variant);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DIAG_VariantStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Variant);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DIAG_VariantStatus::operator==(const dimming_mainfi_tclMsgDIM_DIAG_VariantStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Variant == roRef.Variant);
   return bResult;
}

//=============================================================================

dimming_mainfi_tclMsgDIM_DIAG_BrightnessInputTypeUpReg::dimming_mainfi_tclMsgDIM_DIAG_BrightnessInputTypeUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_DIAG_BrightnessInputTypeUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DIAG_BRIGHTNESSINPUTTYPEUPREG;
}


dimming_mainfi_tclMsgDIM_DIAG_BrightnessInputTypeUpReg::~dimming_mainfi_tclMsgDIM_DIAG_BrightnessInputTypeUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_DIAG_BrightnessInputTypeRelUpReg::dimming_mainfi_tclMsgDIM_DIAG_BrightnessInputTypeRelUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_DIAG_BrightnessInputTypeRelUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DIAG_BRIGHTNESSINPUTTYPERELUPREG;
}


dimming_mainfi_tclMsgDIM_DIAG_BrightnessInputTypeRelUpReg::~dimming_mainfi_tclMsgDIM_DIAG_BrightnessInputTypeRelUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_DIAG_BrightnessInputTypeGet::dimming_mainfi_tclMsgDIM_DIAG_BrightnessInputTypeGet()
 {}

tS32 dimming_mainfi_tclMsgDIM_DIAG_BrightnessInputTypeGet::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DIAG_BRIGHTNESSINPUTTYPEGET;
}


dimming_mainfi_tclMsgDIM_DIAG_BrightnessInputTypeGet::~dimming_mainfi_tclMsgDIM_DIAG_BrightnessInputTypeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DIAG_BrightnessInputTypeStatus::dimming_mainfi_tclMsgDIM_DIAG_BrightnessInputTypeStatus(const dimming_mainfi_tclMsgDIM_DIAG_BrightnessInputTypeStatus& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   InputConfiguration = coRef.InputConfiguration;
}
dimming_mainfi_tclMsgDIM_DIAG_BrightnessInputTypeStatus& dimming_mainfi_tclMsgDIM_DIAG_BrightnessInputTypeStatus::operator=(const dimming_mainfi_tclMsgDIM_DIAG_BrightnessInputTypeStatus& coRef)
{
   if (this == &coRef) return *this;
   InputConfiguration = coRef.InputConfiguration;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DIAG_BrightnessInputTypeStatus::dimming_mainfi_tclMsgDIM_DIAG_BrightnessInputTypeStatus()
:InputConfiguration()
 {}

tS32 dimming_mainfi_tclMsgDIM_DIAG_BrightnessInputTypeStatus::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DIAG_BRIGHTNESSINPUTTYPESTATUS;
}


dimming_mainfi_tclMsgDIM_DIAG_BrightnessInputTypeStatus::~dimming_mainfi_tclMsgDIM_DIAG_BrightnessInputTypeStatus()
{}

tU32 dimming_mainfi_tclMsgDIM_DIAG_BrightnessInputTypeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DIAG_BrightnessInputTypeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> InputConfiguration);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DIAG_BrightnessInputTypeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << InputConfiguration);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DIAG_BrightnessInputTypeStatus::operator==(const dimming_mainfi_tclMsgDIM_DIAG_BrightnessInputTypeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (InputConfiguration == roRef.InputConfiguration);
   return bResult;
}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_CSCContrastLevelUpReg::dimming_mainfi_tclMsgDIM_DISP_CSCContrastLevelUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_CSCContrastLevelUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_CSCCONTRASTLEVELUPREG;
}


dimming_mainfi_tclMsgDIM_DISP_CSCContrastLevelUpReg::~dimming_mainfi_tclMsgDIM_DISP_CSCContrastLevelUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_CSCContrastLevelRelUpReg::dimming_mainfi_tclMsgDIM_DISP_CSCContrastLevelRelUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_CSCContrastLevelRelUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_CSCCONTRASTLEVELRELUPREG;
}


dimming_mainfi_tclMsgDIM_DISP_CSCContrastLevelRelUpReg::~dimming_mainfi_tclMsgDIM_DISP_CSCContrastLevelRelUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_CSCContrastLevelGet::dimming_mainfi_tclMsgDIM_DISP_CSCContrastLevelGet()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_CSCContrastLevelGet::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_CSCCONTRASTLEVELGET;
}


dimming_mainfi_tclMsgDIM_DISP_CSCContrastLevelGet::~dimming_mainfi_tclMsgDIM_DISP_CSCContrastLevelGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DISP_CSCContrastLevelStatus::dimming_mainfi_tclMsgDIM_DISP_CSCContrastLevelStatus(const dimming_mainfi_tclMsgDIM_DISP_CSCContrastLevelStatus& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   ContrastLevel = coRef.ContrastLevel;
}
dimming_mainfi_tclMsgDIM_DISP_CSCContrastLevelStatus& dimming_mainfi_tclMsgDIM_DISP_CSCContrastLevelStatus::operator=(const dimming_mainfi_tclMsgDIM_DISP_CSCContrastLevelStatus& coRef)
{
   if (this == &coRef) return *this;
   ContrastLevel = coRef.ContrastLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DISP_CSCContrastLevelStatus::dimming_mainfi_tclMsgDIM_DISP_CSCContrastLevelStatus()
:ContrastLevel(0)
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_CSCContrastLevelStatus::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_CSCCONTRASTLEVELSTATUS;
}


dimming_mainfi_tclMsgDIM_DISP_CSCContrastLevelStatus::~dimming_mainfi_tclMsgDIM_DISP_CSCContrastLevelStatus()
{}

tU32 dimming_mainfi_tclMsgDIM_DISP_CSCContrastLevelStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DISP_CSCContrastLevelStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ContrastLevel);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DISP_CSCContrastLevelStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ContrastLevel);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DISP_CSCContrastLevelStatus::operator==(const dimming_mainfi_tclMsgDIM_DISP_CSCContrastLevelStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ContrastLevel == roRef.ContrastLevel);
   return bResult;
}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_CSCBlackLevelUpReg::dimming_mainfi_tclMsgDIM_DISP_CSCBlackLevelUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_CSCBlackLevelUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_CSCBLACKLEVELUPREG;
}


dimming_mainfi_tclMsgDIM_DISP_CSCBlackLevelUpReg::~dimming_mainfi_tclMsgDIM_DISP_CSCBlackLevelUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_CSCBlackLevelRelUpReg::dimming_mainfi_tclMsgDIM_DISP_CSCBlackLevelRelUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_CSCBlackLevelRelUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_CSCBLACKLEVELRELUPREG;
}


dimming_mainfi_tclMsgDIM_DISP_CSCBlackLevelRelUpReg::~dimming_mainfi_tclMsgDIM_DISP_CSCBlackLevelRelUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_CSCBlackLevelGet::dimming_mainfi_tclMsgDIM_DISP_CSCBlackLevelGet()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_CSCBlackLevelGet::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_CSCBLACKLEVELGET;
}


dimming_mainfi_tclMsgDIM_DISP_CSCBlackLevelGet::~dimming_mainfi_tclMsgDIM_DISP_CSCBlackLevelGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DISP_CSCBlackLevelStatus::dimming_mainfi_tclMsgDIM_DISP_CSCBlackLevelStatus(const dimming_mainfi_tclMsgDIM_DISP_CSCBlackLevelStatus& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   BlackLevel = coRef.BlackLevel;
}
dimming_mainfi_tclMsgDIM_DISP_CSCBlackLevelStatus& dimming_mainfi_tclMsgDIM_DISP_CSCBlackLevelStatus::operator=(const dimming_mainfi_tclMsgDIM_DISP_CSCBlackLevelStatus& coRef)
{
   if (this == &coRef) return *this;
   BlackLevel = coRef.BlackLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DISP_CSCBlackLevelStatus::dimming_mainfi_tclMsgDIM_DISP_CSCBlackLevelStatus()
:BlackLevel(0)
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_CSCBlackLevelStatus::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_CSCBLACKLEVELSTATUS;
}


dimming_mainfi_tclMsgDIM_DISP_CSCBlackLevelStatus::~dimming_mainfi_tclMsgDIM_DISP_CSCBlackLevelStatus()
{}

tU32 dimming_mainfi_tclMsgDIM_DISP_CSCBlackLevelStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DISP_CSCBlackLevelStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BlackLevel);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DISP_CSCBlackLevelStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BlackLevel);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DISP_CSCBlackLevelStatus::operator==(const dimming_mainfi_tclMsgDIM_DISP_CSCBlackLevelStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BlackLevel == roRef.BlackLevel);
   return bResult;
}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_CSCGammaLevelUpReg::dimming_mainfi_tclMsgDIM_DISP_CSCGammaLevelUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_CSCGammaLevelUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_CSCGAMMALEVELUPREG;
}


dimming_mainfi_tclMsgDIM_DISP_CSCGammaLevelUpReg::~dimming_mainfi_tclMsgDIM_DISP_CSCGammaLevelUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_CSCGammaLevelRelUpReg::dimming_mainfi_tclMsgDIM_DISP_CSCGammaLevelRelUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_CSCGammaLevelRelUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_CSCGAMMALEVELRELUPREG;
}


dimming_mainfi_tclMsgDIM_DISP_CSCGammaLevelRelUpReg::~dimming_mainfi_tclMsgDIM_DISP_CSCGammaLevelRelUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_CSCGammaLevelGet::dimming_mainfi_tclMsgDIM_DISP_CSCGammaLevelGet()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_CSCGammaLevelGet::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_CSCGAMMALEVELGET;
}


dimming_mainfi_tclMsgDIM_DISP_CSCGammaLevelGet::~dimming_mainfi_tclMsgDIM_DISP_CSCGammaLevelGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DISP_CSCGammaLevelStatus::dimming_mainfi_tclMsgDIM_DISP_CSCGammaLevelStatus(const dimming_mainfi_tclMsgDIM_DISP_CSCGammaLevelStatus& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   GammaLevel = coRef.GammaLevel;
}
dimming_mainfi_tclMsgDIM_DISP_CSCGammaLevelStatus& dimming_mainfi_tclMsgDIM_DISP_CSCGammaLevelStatus::operator=(const dimming_mainfi_tclMsgDIM_DISP_CSCGammaLevelStatus& coRef)
{
   if (this == &coRef) return *this;
   GammaLevel = coRef.GammaLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DISP_CSCGammaLevelStatus::dimming_mainfi_tclMsgDIM_DISP_CSCGammaLevelStatus()
:GammaLevel(0)
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_CSCGammaLevelStatus::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_CSCGAMMALEVELSTATUS;
}


dimming_mainfi_tclMsgDIM_DISP_CSCGammaLevelStatus::~dimming_mainfi_tclMsgDIM_DISP_CSCGammaLevelStatus()
{}

tU32 dimming_mainfi_tclMsgDIM_DISP_CSCGammaLevelStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DISP_CSCGammaLevelStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> GammaLevel);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DISP_CSCGammaLevelStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << GammaLevel);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DISP_CSCGammaLevelStatus::operator==(const dimming_mainfi_tclMsgDIM_DISP_CSCGammaLevelStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (GammaLevel == roRef.GammaLevel);
   return bResult;
}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_CSCSaturationLevelUpReg::dimming_mainfi_tclMsgDIM_DISP_CSCSaturationLevelUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_CSCSaturationLevelUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_CSCSATURATIONLEVELUPREG;
}


dimming_mainfi_tclMsgDIM_DISP_CSCSaturationLevelUpReg::~dimming_mainfi_tclMsgDIM_DISP_CSCSaturationLevelUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_CSCSaturationLevelRelUpReg::dimming_mainfi_tclMsgDIM_DISP_CSCSaturationLevelRelUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_CSCSaturationLevelRelUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_CSCSATURATIONLEVELRELUPREG;
}


dimming_mainfi_tclMsgDIM_DISP_CSCSaturationLevelRelUpReg::~dimming_mainfi_tclMsgDIM_DISP_CSCSaturationLevelRelUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_CSCSaturationLevelGet::dimming_mainfi_tclMsgDIM_DISP_CSCSaturationLevelGet()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_CSCSaturationLevelGet::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_CSCSATURATIONLEVELGET;
}


dimming_mainfi_tclMsgDIM_DISP_CSCSaturationLevelGet::~dimming_mainfi_tclMsgDIM_DISP_CSCSaturationLevelGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DISP_CSCSaturationLevelStatus::dimming_mainfi_tclMsgDIM_DISP_CSCSaturationLevelStatus(const dimming_mainfi_tclMsgDIM_DISP_CSCSaturationLevelStatus& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   SaturationLevel = coRef.SaturationLevel;
}
dimming_mainfi_tclMsgDIM_DISP_CSCSaturationLevelStatus& dimming_mainfi_tclMsgDIM_DISP_CSCSaturationLevelStatus::operator=(const dimming_mainfi_tclMsgDIM_DISP_CSCSaturationLevelStatus& coRef)
{
   if (this == &coRef) return *this;
   SaturationLevel = coRef.SaturationLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DISP_CSCSaturationLevelStatus::dimming_mainfi_tclMsgDIM_DISP_CSCSaturationLevelStatus()
:SaturationLevel(0)
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_CSCSaturationLevelStatus::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_CSCSATURATIONLEVELSTATUS;
}


dimming_mainfi_tclMsgDIM_DISP_CSCSaturationLevelStatus::~dimming_mainfi_tclMsgDIM_DISP_CSCSaturationLevelStatus()
{}

tU32 dimming_mainfi_tclMsgDIM_DISP_CSCSaturationLevelStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DISP_CSCSaturationLevelStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SaturationLevel);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DISP_CSCSaturationLevelStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SaturationLevel);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DISP_CSCSaturationLevelStatus::operator==(const dimming_mainfi_tclMsgDIM_DISP_CSCSaturationLevelStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SaturationLevel == roRef.SaturationLevel);
   return bResult;
}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_CSCColorLevelUpReg::dimming_mainfi_tclMsgDIM_DISP_CSCColorLevelUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_CSCColorLevelUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_CSCCOLORLEVELUPREG;
}


dimming_mainfi_tclMsgDIM_DISP_CSCColorLevelUpReg::~dimming_mainfi_tclMsgDIM_DISP_CSCColorLevelUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_CSCColorLevelRelUpReg::dimming_mainfi_tclMsgDIM_DISP_CSCColorLevelRelUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_CSCColorLevelRelUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_CSCCOLORLEVELRELUPREG;
}


dimming_mainfi_tclMsgDIM_DISP_CSCColorLevelRelUpReg::~dimming_mainfi_tclMsgDIM_DISP_CSCColorLevelRelUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_DISP_CSCColorLevelGet::dimming_mainfi_tclMsgDIM_DISP_CSCColorLevelGet()
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_CSCColorLevelGet::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_CSCCOLORLEVELGET;
}


dimming_mainfi_tclMsgDIM_DISP_CSCColorLevelGet::~dimming_mainfi_tclMsgDIM_DISP_CSCColorLevelGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_DISP_CSCColorLevelStatus::dimming_mainfi_tclMsgDIM_DISP_CSCColorLevelStatus(const dimming_mainfi_tclMsgDIM_DISP_CSCColorLevelStatus& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   ColorLevel = coRef.ColorLevel;
}
dimming_mainfi_tclMsgDIM_DISP_CSCColorLevelStatus& dimming_mainfi_tclMsgDIM_DISP_CSCColorLevelStatus::operator=(const dimming_mainfi_tclMsgDIM_DISP_CSCColorLevelStatus& coRef)
{
   if (this == &coRef) return *this;
   ColorLevel = coRef.ColorLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_DISP_CSCColorLevelStatus::dimming_mainfi_tclMsgDIM_DISP_CSCColorLevelStatus()
:ColorLevel(0)
 {}

tS32 dimming_mainfi_tclMsgDIM_DISP_CSCColorLevelStatus::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_DISP_CSCCOLORLEVELSTATUS;
}


dimming_mainfi_tclMsgDIM_DISP_CSCColorLevelStatus::~dimming_mainfi_tclMsgDIM_DISP_CSCColorLevelStatus()
{}

tU32 dimming_mainfi_tclMsgDIM_DISP_CSCColorLevelStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_DISP_CSCColorLevelStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ColorLevel);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_DISP_CSCColorLevelStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ColorLevel);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_DISP_CSCColorLevelStatus::operator==(const dimming_mainfi_tclMsgDIM_DISP_CSCColorLevelStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ColorLevel == roRef.ColorLevel);
   return bResult;
}

//=============================================================================

dimming_mainfi_tclMsgDIM_SECOND_DISP_AllDisplayParamGet::dimming_mainfi_tclMsgDIM_SECOND_DISP_AllDisplayParamGet()
 {}

tS32 dimming_mainfi_tclMsgDIM_SECOND_DISP_AllDisplayParamGet::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_SECOND_DISP_ALLDISPLAYPARAMGET;
}


dimming_mainfi_tclMsgDIM_SECOND_DISP_AllDisplayParamGet::~dimming_mainfi_tclMsgDIM_SECOND_DISP_AllDisplayParamGet()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_SECOND_DISP_AllDisplayParamUpReg::dimming_mainfi_tclMsgDIM_SECOND_DISP_AllDisplayParamUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_SECOND_DISP_AllDisplayParamUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_SECOND_DISP_ALLDISPLAYPARAMUPREG;
}


dimming_mainfi_tclMsgDIM_SECOND_DISP_AllDisplayParamUpReg::~dimming_mainfi_tclMsgDIM_SECOND_DISP_AllDisplayParamUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_SECOND_DISP_AllDisplayParamRelUpReg::dimming_mainfi_tclMsgDIM_SECOND_DISP_AllDisplayParamRelUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_SECOND_DISP_AllDisplayParamRelUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_SECOND_DISP_ALLDISPLAYPARAMRELUPREG;
}


dimming_mainfi_tclMsgDIM_SECOND_DISP_AllDisplayParamRelUpReg::~dimming_mainfi_tclMsgDIM_SECOND_DISP_AllDisplayParamRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_SECOND_DISP_AllDisplayParamStatus::dimming_mainfi_tclMsgDIM_SECOND_DISP_AllDisplayParamStatus(const dimming_mainfi_tclMsgDIM_SECOND_DISP_AllDisplayParamStatus& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   u8BlackLevel = coRef.u8BlackLevel;
   u8Brightness = coRef.u8Brightness;
   u8Color = coRef.u8Color;
   u8Contrast = coRef.u8Contrast;
   u8Tint = coRef.u8Tint;
   u8GammaLevel = coRef.u8GammaLevel;
}
dimming_mainfi_tclMsgDIM_SECOND_DISP_AllDisplayParamStatus& dimming_mainfi_tclMsgDIM_SECOND_DISP_AllDisplayParamStatus::operator=(const dimming_mainfi_tclMsgDIM_SECOND_DISP_AllDisplayParamStatus& coRef)
{
   if (this == &coRef) return *this;
   u8BlackLevel = coRef.u8BlackLevel;
   u8Brightness = coRef.u8Brightness;
   u8Color = coRef.u8Color;
   u8Contrast = coRef.u8Contrast;
   u8Tint = coRef.u8Tint;
   u8GammaLevel = coRef.u8GammaLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_SECOND_DISP_AllDisplayParamStatus::dimming_mainfi_tclMsgDIM_SECOND_DISP_AllDisplayParamStatus()
:u8BlackLevel(0)
,u8Brightness(0)
,u8Color(0)
,u8Contrast(0)
,u8Tint(0)
,u8GammaLevel(0)
 {}

tS32 dimming_mainfi_tclMsgDIM_SECOND_DISP_AllDisplayParamStatus::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_SECOND_DISP_ALLDISPLAYPARAMSTATUS;
}


dimming_mainfi_tclMsgDIM_SECOND_DISP_AllDisplayParamStatus::~dimming_mainfi_tclMsgDIM_SECOND_DISP_AllDisplayParamStatus()
{}

tU32 dimming_mainfi_tclMsgDIM_SECOND_DISP_AllDisplayParamStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 7;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_SECOND_DISP_AllDisplayParamStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8BlackLevel);
   (tVoid) (oIn >> u8Brightness);
   (tVoid) (oIn >> u8Color);
   (tVoid) (oIn >> u8Contrast);
   (tVoid) (oIn >> u8Tint);
   (tVoid) (oIn >> u8GammaLevel);
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_SECOND_DISP_AllDisplayParamStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8BlackLevel);
   (tVoid) (oOut << u8Brightness);
   (tVoid) (oOut << u8Color);
   (tVoid) (oOut << u8Contrast);
   (tVoid) (oOut << u8Tint);
   (tVoid) (oOut << u8GammaLevel);
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_SECOND_DISP_AllDisplayParamStatus::operator==(const dimming_mainfi_tclMsgDIM_SECOND_DISP_AllDisplayParamStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8BlackLevel == roRef.u8BlackLevel);
   bResult = bResult && (u8Brightness == roRef.u8Brightness);
   bResult = bResult && (u8Color == roRef.u8Color);
   bResult = bResult && (u8Contrast == roRef.u8Contrast);
   bResult = bResult && (u8Tint == roRef.u8Tint);
   bResult = bResult && (u8GammaLevel == roRef.u8GammaLevel);
   return bResult;
}

//=============================================================================

dimming_mainfi_tclMsgDIM_SECOND_DISP_SelfDiagnosisResultGet::dimming_mainfi_tclMsgDIM_SECOND_DISP_SelfDiagnosisResultGet()
 {}

tS32 dimming_mainfi_tclMsgDIM_SECOND_DISP_SelfDiagnosisResultGet::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_SECOND_DISP_SELFDIAGNOSISRESULTGET;
}


dimming_mainfi_tclMsgDIM_SECOND_DISP_SelfDiagnosisResultGet::~dimming_mainfi_tclMsgDIM_SECOND_DISP_SelfDiagnosisResultGet()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_SECOND_DISP_SelfDiagnosisResultUpReg::dimming_mainfi_tclMsgDIM_SECOND_DISP_SelfDiagnosisResultUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_SECOND_DISP_SelfDiagnosisResultUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_SECOND_DISP_SELFDIAGNOSISRESULTUPREG;
}


dimming_mainfi_tclMsgDIM_SECOND_DISP_SelfDiagnosisResultUpReg::~dimming_mainfi_tclMsgDIM_SECOND_DISP_SelfDiagnosisResultUpReg()
{}

//=============================================================================

dimming_mainfi_tclMsgDIM_SECOND_DISP_SelfDiagnosisResultRelUpReg::dimming_mainfi_tclMsgDIM_SECOND_DISP_SelfDiagnosisResultRelUpReg()
 {}

tS32 dimming_mainfi_tclMsgDIM_SECOND_DISP_SelfDiagnosisResultRelUpReg::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_SECOND_DISP_SELFDIAGNOSISRESULTRELUPREG;
}


dimming_mainfi_tclMsgDIM_SECOND_DISP_SelfDiagnosisResultRelUpReg::~dimming_mainfi_tclMsgDIM_SECOND_DISP_SelfDiagnosisResultRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dimming_mainfi_tclMsgDIM_SECOND_DISP_SelfDiagnosisResultStatus::dimming_mainfi_tclMsgDIM_SECOND_DISP_SelfDiagnosisResultStatus(const dimming_mainfi_tclMsgDIM_SECOND_DISP_SelfDiagnosisResultStatus& coRef)
   : dimming_mainfi_tclMsgBaseMessage(coRef)
{
   u16SelfDiagResult  = coRef.u16SelfDiagResult ;
}
dimming_mainfi_tclMsgDIM_SECOND_DISP_SelfDiagnosisResultStatus& dimming_mainfi_tclMsgDIM_SECOND_DISP_SelfDiagnosisResultStatus::operator=(const dimming_mainfi_tclMsgDIM_SECOND_DISP_SelfDiagnosisResultStatus& coRef)
{
   if (this == &coRef) return *this;
   u16SelfDiagResult  = coRef.u16SelfDiagResult ;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

dimming_mainfi_tclMsgDIM_SECOND_DISP_SelfDiagnosisResultStatus::dimming_mainfi_tclMsgDIM_SECOND_DISP_SelfDiagnosisResultStatus()
:u16SelfDiagResult (0)
 {}

tS32 dimming_mainfi_tclMsgDIM_SECOND_DISP_SelfDiagnosisResultStatus::s32GetTypeId() const
{
   return (tS32) dimming_mainfi_tclToken::EN_MSG_DIM_SECOND_DISP_SELFDIAGNOSISRESULTSTATUS;
}


dimming_mainfi_tclMsgDIM_SECOND_DISP_SelfDiagnosisResultStatus::~dimming_mainfi_tclMsgDIM_SECOND_DISP_SelfDiagnosisResultStatus()
{}

tU32 dimming_mainfi_tclMsgDIM_SECOND_DISP_SelfDiagnosisResultStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& dimming_mainfi_tclMsgDIM_SECOND_DISP_SelfDiagnosisResultStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16SelfDiagResult );
   return oIn;
}

fi_tclOutContext& dimming_mainfi_tclMsgDIM_SECOND_DISP_SelfDiagnosisResultStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16SelfDiagResult );
   return oOut;
}

tBool dimming_mainfi_tclMsgDIM_SECOND_DISP_SelfDiagnosisResultStatus::operator==(const dimming_mainfi_tclMsgDIM_SECOND_DISP_SelfDiagnosisResultStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16SelfDiagResult  == roRef.u16SelfDiagResult );
   return bResult;
}

