#ifndef DIAGLOG_FIVISITOR_HEADER
#define DIAGLOG_FIVISITOR_HEADER

// --Basisklasse fuer eine FI-Besucher-Klasse

class diaglog_fi_tclOutput {
public:
   diaglog_fi_tclOutput();
   virtual ~diaglog_fi_tclOutput(){};

   virtual tVoid vPrintLine(tCString coszLine) = 0;
};

class diaglog_fi_tclFileOutput : public diaglog_fi_tclOutput 
{
public:
   diaglog_fi_tclFileOutput(OSAL_tIODescriptor rIOD):fd(rIOD) {}
   virtual tVoid vPrintLine(tCString coszLine);
protected:
   OSAL_tIODescriptor fd;
private:
   diaglog_fi_tclFileOutput(); //lint !e1704
   diaglog_fi_tclFileOutput& operator=(const diaglog_fi_tclFileOutput& coRef);
   diaglog_fi_tclFileOutput(const diaglog_fi_tclFileOutput& coRef); //lint !e1704
};

class diaglog_fi_tclMemOutput : public diaglog_fi_tclOutput
{
public:
   diaglog_fi_tclMemOutput(tU32 u32MemSize);
   virtual ~diaglog_fi_tclMemOutput();
   virtual tVoid vPrintLine(tCString coszLine);
   tString szGetBuffer();
protected:
   tChar* szBuf;
   tChar* szEndBuf;
   tChar* s8BufPos;
private:
   diaglog_fi_tclMemOutput(); //lint !e1704
   diaglog_fi_tclMemOutput(const diaglog_fi_tclMemOutput& coRef); //lint !e1704
   diaglog_fi_tclMemOutput& operator=(const diaglog_fi_tclMemOutput& coRef); //lint !e1704
};

class MY_DECL diaglog_fi_tclVisitorBase {
public:

   // --Konstruktor
   diaglog_fi_tclVisitorBase():bBreakNow(FALSE),bIsVisitorValid(FALSE) {}
   virtual ~diaglog_fi_tclVisitorBase() {}

   tBool bIsValid() const { return bIsVisitorValid; }
   tVoid vInvalidate() { bIsVisitorValid=FALSE; }
   tVoid vValidate() { bIsVisitorValid=TRUE; }
   tBool bBreak() const { return bBreakNow; }
   tVoid vReleaseBreak() { bBreakNow = FALSE; }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(diaglog_fi_tclU8& oU8);
   virtual tVoid vVisitS8(diaglog_fi_tclS8& oS8);
   virtual tVoid vVisitU16(diaglog_fi_tclU16& oU16);
   virtual tVoid vVisitS16(diaglog_fi_tclS16& oS16);
   virtual tVoid vVisitU24(diaglog_fi_tclU24& oU24);
   virtual tVoid vVisitS24(diaglog_fi_tclS24& oS24);
   virtual tVoid vVisitU32(diaglog_fi_tclU32& oU32);
   virtual tVoid vVisitS32(diaglog_fi_tclS32& oS32);
   virtual tVoid vVisitU64(diaglog_fi_tclU64& oU64);
   virtual tVoid vVisitS64(diaglog_fi_tclS64& oS64);
   virtual tVoid vVisitF32(diaglog_fi_tclF32& oF32);
   virtual tVoid vVisitF64(diaglog_fi_tclF64& oF64);
   virtual tVoid vVisitBool(diaglog_fi_tclBool& oBool);
   virtual tVoid vVisitString(diaglog_fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(diaglog_fi_tclMultiLanguageString& oString);

   virtual tVoid vVisitList(diaglog_fi_tclList& oList);
   virtual tVoid vVisit_BinContainer(diaglog_fi_tcl_BinContainer& oBinContainer);

   virtual tVoid vVisit_Reserved(diaglog_fi_tcl_Reserved& oReserved);

   virtual tVoid vVisit_u8_Percent(diaglog_fi_tcl_u8_Percent& ou8_Percent);

   virtual tVoid vVisit_s16_PerThousand(diaglog_fi_tcl_s16_PerThousand& os16_PerThousand);

   virtual tVoid vVisit_u16_IndexInReferenceList(diaglog_fi_tcl_u16_IndexInReferenceList& ou16_IndexInReferenceList);

   virtual tVoid vVisit_u16_ErrorCode(diaglog_fi_tcl_u16_ErrorCode& ou16_ErrorCode);

   virtual tVoid vVisit_u16_RPM(diaglog_fi_tcl_u16_RPM& ou16_RPM);

   virtual tVoid vVisit_s32_Kilogram(diaglog_fi_tcl_s32_Kilogram& os32_Kilogram);

   virtual tVoid vVisit_s32_Pound(diaglog_fi_tcl_s32_Pound& os32_Pound);

   virtual tVoid vVisit_s16_Meter(diaglog_fi_tcl_s16_Meter& os16_Meter);

   virtual tVoid vVisit_s32_Meter(diaglog_fi_tcl_s32_Meter& os32_Meter);

   virtual tVoid vVisit_s32_Yards(diaglog_fi_tcl_s32_Yards& os32_Yards);

   virtual tVoid vVisit_s32_Foot(diaglog_fi_tcl_s32_Foot& os32_Foot);

   virtual tVoid vVisit_s32_Centimeter(diaglog_fi_tcl_s32_Centimeter& os32_Centimeter);

   virtual tVoid vVisit_s32_Inch(diaglog_fi_tcl_s32_Inch& os32_Inch);

   virtual tVoid vVisit_s32_Millimeter(diaglog_fi_tcl_s32_Millimeter& os32_Millimeter);

   virtual tVoid vVisit_s32_Microliter(diaglog_fi_tcl_s32_Microliter& os32_Microliter);

   virtual tVoid vVisit_s32_Second(diaglog_fi_tcl_s32_Second& os32_Second);

   virtual tVoid vVisit_u16_MilliSecond(diaglog_fi_tcl_u16_MilliSecond& ou16_MilliSecond);

   virtual tVoid vVisit_s32_MilliSecond(diaglog_fi_tcl_s32_MilliSecond& os32_MilliSecond);

   virtual tVoid vVisit_POSIXTime(diaglog_fi_tcl_POSIXTime& oPOSIXTime);

   virtual tVoid vVisit_e8_DST_State(diaglog_fi_tcl_e8_DST_State& oe8_DST_State);

   virtual tVoid vVisit_TimeZoneElement(diaglog_fi_tcl_TimeZoneElement& oTimeZoneElement);

   virtual tVoid vVisit_s16_KmPerHour(diaglog_fi_tcl_s16_KmPerHour& os16_KmPerHour);

   virtual tVoid vVisit_s16_MilesPerHour(diaglog_fi_tcl_s16_MilesPerHour& os16_MilesPerHour);

   virtual tVoid vVisit_s16_Knot(diaglog_fi_tcl_s16_Knot& os16_Knot);

   virtual tVoid vVisit_s16_CentimeterSecond(diaglog_fi_tcl_s16_CentimeterSecond& os16_CentimeterSecond);

   virtual tVoid vVisit_s16_Kelvin(diaglog_fi_tcl_s16_Kelvin& os16_Kelvin);

   virtual tVoid vVisit_s16_Fahrenheit(diaglog_fi_tcl_s16_Fahrenheit& os16_Fahrenheit);

   virtual tVoid vVisit_s32_Pascal(diaglog_fi_tcl_s32_Pascal& os32_Pascal);

   virtual tVoid vVisit_s32_Watt(diaglog_fi_tcl_s32_Watt& os32_Watt);

   virtual tVoid vVisit_FIVersion(diaglog_fi_tcl_FIVersion& oFIVersion);

   virtual tVoid vVisit_s32_Longitude(diaglog_fi_tcl_s32_Longitude& os32_Longitude);

   virtual tVoid vVisit_s32_Latitude(diaglog_fi_tcl_s32_Latitude& os32_Latitude);

   virtual tVoid vVisit_PositionWGS84(diaglog_fi_tcl_PositionWGS84& oPositionWGS84);

   virtual tVoid vVisit_RectangleWGS84(diaglog_fi_tcl_RectangleWGS84& oRectangleWGS84);

   virtual tVoid vVisit_e16_ISOCountryCode(diaglog_fi_tcl_e16_ISOCountryCode& oe16_ISOCountryCode);

   virtual tVoid vVisit_e16_ISOLanguageCode(diaglog_fi_tcl_e16_ISOLanguageCode& oe16_ISOLanguageCode);

   virtual tVoid vVisit_LanguageID(diaglog_fi_tcl_LanguageID& oLanguageID);

   virtual tVoid vVisit_u8_DirectionAbsolute(diaglog_fi_tcl_u8_DirectionAbsolute& ou8_DirectionAbsolute);

   virtual tVoid vVisit_u8_DirectionRelative(diaglog_fi_tcl_u8_DirectionRelative& ou8_DirectionRelative);

   virtual tVoid vVisit_s16_CentiDegree(diaglog_fi_tcl_s16_CentiDegree& os16_CentiDegree);

   virtual tVoid vVisit_s16_Degree(diaglog_fi_tcl_s16_Degree& os16_Degree);

   virtual tVoid vVisit_u16_DirectionAbsolute_CentiDegree(diaglog_fi_tcl_u16_DirectionAbsolute_CentiDegree& ou16_DirectionAbsolute_CentiDegree);

   virtual tVoid vVisit_s16_DirectionRelative_CentiDegree(diaglog_fi_tcl_s16_DirectionRelative_CentiDegree& os16_DirectionRelative_CentiDegree);

   virtual tVoid vVisit_e8_FuelType(diaglog_fi_tcl_e8_FuelType& oe8_FuelType);

   virtual tVoid vVisit_DistTimeFuel(diaglog_fi_tcl_DistTimeFuel& oDistTimeFuel);

   virtual tVoid vVisit_e8_MethodResultReply(diaglog_fi_tcl_e8_MethodResultReply& oe8_MethodResultReply);

   virtual tVoid vVisit_e8_TestResult(diaglog_fi_tcl_e8_TestResult& oe8_TestResult);

   virtual tVoid vVisit_FreezeFrameData(diaglog_fi_tcl_FreezeFrameData& oFreezeFrameData);

   virtual tVoid vVisit_FreezeFrameList(diaglog_fi_tcl_FreezeFrameList& oFreezeFrameList);

   virtual tVoid vVisit_ReadRequestBuffer(diaglog_fi_tcl_ReadRequestBuffer& oReadRequestBuffer);

   virtual tVoid vVisit_ReadResultBuffer(diaglog_fi_tcl_ReadResultBuffer& oReadResultBuffer);

   virtual tVoid vVisit_ReadResultStructure(diaglog_fi_tcl_ReadResultStructure& oReadResultStructure);

   virtual tVoid vVisit_ReadResultList(diaglog_fi_tcl_ReadResultList& oReadResultList);

   virtual tVoid vVisit_ITC_Information(diaglog_fi_tcl_ITC_Information& oITC_Information);

   virtual tVoid vVisit_ProductionReadResultStructure(diaglog_fi_tcl_ProductionReadResultStructure& oProductionReadResultStructure);

   virtual tVoid vVisit_ProductionReadResultList(diaglog_fi_tcl_ProductionReadResultList& oProductionReadResultList);

   virtual tVoid vVisit_CustomerReadResultStructure(diaglog_fi_tcl_CustomerReadResultStructure& oCustomerReadResultStructure);

   virtual tVoid vVisit_CustomerReadResultList(diaglog_fi_tcl_CustomerReadResultList& oCustomerReadResultList);

   virtual tVoid vVisit_e8_Protocol(diaglog_fi_tcl_e8_Protocol& oe8_Protocol);

   virtual tVoid vVisit_TestResult(diaglog_fi_tcl_TestResult& oTestResult);

   virtual tVoid vVisit_TestResultList(diaglog_fi_tcl_TestResultList& oTestResultList);

   virtual tVoid vVisit_SnapshotData(diaglog_fi_tcl_SnapshotData& oSnapshotData);

   virtual tVoid vVisit_SnapshotDataList(diaglog_fi_tcl_SnapshotDataList& oSnapshotDataList);

   virtual tVoid vVisit_SnapshotIdentification(diaglog_fi_tcl_SnapshotIdentification& oSnapshotIdentification);

   virtual tVoid vVisit_SnapshotIdentificationList(diaglog_fi_tcl_SnapshotIdentificationList& oSnapshotIdentificationList);

   virtual tVoid vVisit_ClearRequestBuffer(diaglog_fi_tcl_ClearRequestBuffer& oClearRequestBuffer);

   virtual tVoid vVisit_ClearResultBuffer(diaglog_fi_tcl_ClearResultBuffer& oClearResultBuffer);

   virtual tVoid vVisit_e8_ControlParameter(diaglog_fi_tcl_e8_ControlParameter& oe8_ControlParameter);

   virtual tVoid vVisit_ControlList(diaglog_fi_tcl_ControlList& oControlList);

   virtual tVoid vVisit_e8_ReadValue(diaglog_fi_tcl_e8_ReadValue& oe8_ReadValue);

   virtual tVoid vVisit_e8_VDLMediaType(diaglog_fi_tcl_e8_VDLMediaType& oe8_VDLMediaType);

   virtual tVoid vVisit_e8_DiaglogDefsetType(diaglog_fi_tcl_e8_DiaglogDefsetType& oe8_DiaglogDefsetType);

   virtual tVoid vVisit_e8_SendNextTestResReason(diaglog_fi_tcl_e8_SendNextTestResReason& oe8_SendNextTestResReason);

   virtual tVoid vVisit_SendNextTestResultStructure(diaglog_fi_tcl_SendNextTestResultStructure& oSendNextTestResultStructure);

   virtual tVoid vVisit_e8_ErrorCode(diaglog_fi_tcl_e8_ErrorCode& oe8_ErrorCode);

   virtual tVoid vVisit_e8_GMLnGWDTCFaultType(diaglog_fi_tcl_e8_GMLnGWDTCFaultType& oe8_GMLnGWDTCFaultType);

   virtual tVoid vVisit_ActiveDTCList(diaglog_fi_tcl_ActiveDTCList& oActiveDTCList);

   virtual tVoid vVisit_DiagProtocol(diaglog_fi_tcl_DiagProtocol& oDiagProtocol);

   virtual tVoid vVisit_e8_Store(diaglog_fi_tcl_e8_Store& oe8_Store);

   virtual tVoid vVisit_e8_RouteCalculationCommand(diaglog_fi_tcl_e8_RouteCalculationCommand& oe8_RouteCalculationCommand);

   virtual tVoid vVisit_e8_RouteCalculationStatus(diaglog_fi_tcl_e8_RouteCalculationStatus& oe8_RouteCalculationStatus);

   virtual tVoid vVisit_e8_Language(diaglog_fi_tcl_e8_Language& oe8_Language);

   virtual tVoid vVisit_e8_Country(diaglog_fi_tcl_e8_Country& oe8_Country);

   virtual tVoid vVisit_e8_LanguageSubsystem(diaglog_fi_tcl_e8_LanguageSubsystem& oe8_LanguageSubsystem);

   virtual tVoid vVisit_e8_TestScreens(diaglog_fi_tcl_e8_TestScreens& oe8_TestScreens);

   virtual tVoid vVisit_DisplayStringsList(diaglog_fi_tcl_DisplayStringsList& oDisplayStringsList);

   virtual tVoid vVisit_DisplayData(diaglog_fi_tcl_DisplayData& oDisplayData);

   virtual tVoid vVisit_e8_TroubleCodeType(diaglog_fi_tcl_e8_TroubleCodeType& oe8_TroubleCodeType);

   virtual tVoid vVisit_e8_TestRoutines(diaglog_fi_tcl_e8_TestRoutines& oe8_TestRoutines);

   virtual tVoid vVisit_e8_DefaultSettingsCategories(diaglog_fi_tcl_e8_DefaultSettingsCategories& oe8_DefaultSettingsCategories);

   virtual tVoid vVisit_CountryLanguage(diaglog_fi_tcl_CountryLanguage& oCountryLanguage);

   virtual tVoid vVisit_CountryLanguageResult(diaglog_fi_tcl_CountryLanguageResult& oCountryLanguageResult);

   virtual tVoid vVisit_e8_TroubleCodeStatus(diaglog_fi_tcl_e8_TroubleCodeStatus& oe8_TroubleCodeStatus);

   virtual tVoid vVisit_TroubleCode(diaglog_fi_tcl_TroubleCode& oTroubleCode);

   virtual tVoid vVisit_TroubleCodeList(diaglog_fi_tcl_TroubleCodeList& oTroubleCodeList);

   virtual tVoid vVisit_RouteCalculationStartParameter(diaglog_fi_tcl_RouteCalculationStartParameter& oRouteCalculationStartParameter);

   virtual tVoid vVisit_RouteCalculationResultParameter(diaglog_fi_tcl_RouteCalculationResultParameter& oRouteCalculationResultParameter);

   virtual tVoid vVisit_e16_Language(diaglog_fi_tcl_e16_Language& oe16_Language);

   virtual tVoid vVisit_e16_SpeedLock(diaglog_fi_tcl_e16_SpeedLock& oe16_SpeedLock);

   virtual tVoid vVisit_MessageBuffer(diaglog_fi_tcl_MessageBuffer& oMessageBuffer);

   virtual tVoid vVisit_e8_DefSetMode(diaglog_fi_tcl_e8_DefSetMode& oe8_DefSetMode);

   virtual tVoid vVisit_e8_DefSetServiceStatus(diaglog_fi_tcl_e8_DefSetServiceStatus& oe8_DefSetServiceStatus);

   virtual tVoid vVisit_e8_DefSetGroups(diaglog_fi_tcl_e8_DefSetGroups& oe8_DefSetGroups);

   virtual tVoid vVisit_e8_DiagMausSetup(diaglog_fi_tcl_e8_DiagMausSetup& oe8_DiagMausSetup);

   virtual tVoid vVisit_e8_SimulatedKeys(diaglog_fi_tcl_e8_SimulatedKeys& oe8_SimulatedKeys);

   virtual tVoid vVisit_KDSItemList(diaglog_fi_tcl_KDSItemList& oKDSItemList);

   virtual tVoid vVisit_ConfigItemList(diaglog_fi_tcl_ConfigItemList& oConfigItemList);

   virtual tVoid vVisit_RequestDataUDS(diaglog_fi_tcl_RequestDataUDS& oRequestDataUDS);

   virtual tVoid vVisit_ResponseDataUDS(diaglog_fi_tcl_ResponseDataUDS& oResponseDataUDS);

   virtual tVoid vVisit_DiagData(diaglog_fi_tcl_DiagData& oDiagData);

   virtual tVoid vVisit_e8_RCtrlSource(diaglog_fi_tcl_e8_RCtrlSource& oe8_RCtrlSource);

   virtual tVoid vVisit_e8_RCtrlCommand(diaglog_fi_tcl_e8_RCtrlCommand& oe8_RCtrlCommand);

   virtual tVoid vVisit_e8_RCtrlSignal(diaglog_fi_tcl_e8_RCtrlSignal& oe8_RCtrlSignal);

   virtual tVoid vVisit_e8_DiagRVCSignal(diaglog_fi_tcl_e8_DiagRVCSignal& oe8_DiagRVCSignal);

   virtual tVoid vVisit_e8_CalibrationTable(diaglog_fi_tcl_e8_CalibrationTable& oe8_CalibrationTable);

   virtual tVoid vVisit_CalibrationValue(diaglog_fi_tcl_CalibrationValue& oCalibrationValue);

   virtual tVoid vVisit_e8_CalibrationTimeStampMonth(diaglog_fi_tcl_e8_CalibrationTimeStampMonth& oe8_CalibrationTimeStampMonth);

   virtual tVoid vVisit_CalibrationTimeStamp(diaglog_fi_tcl_CalibrationTimeStamp& oCalibrationTimeStamp);

   virtual tVoid vVisit_AlphaCode(diaglog_fi_tcl_AlphaCode& oAlphaCode);

   virtual tVoid vVisit_e8_CalibrationParameterSize(diaglog_fi_tcl_e8_CalibrationParameterSize& oe8_CalibrationParameterSize);

   virtual tVoid vVisit_e8_KdsViaUsbUpdateStatus(diaglog_fi_tcl_e8_KdsViaUsbUpdateStatus& oe8_KdsViaUsbUpdateStatus);

   virtual tVoid vVisit_AntiTheftStatus(diaglog_fi_tcl_AntiTheftStatus& oAntiTheftStatus);


 	fi_tclTraversePath<fi_tclKnot>::tclIterator oIterator;		
	
protected:
	tBool bBreakNow;
	tBool bIsVisitorValid;
private:

};

#endif
