/************************************************************************
 
 *FILE:           alltypes.h
 
 *SW-COMPONENT:   FI, framework for Functional Interface
 
 *DESCRIPTION:    Interface for all types defined in the different FIs
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           $ Log $
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef DIAGLOG_ALLFITYPES_HEADER
#define DIAGLOG_ALLFITYPES_HEADER

#include <vector>

class diaglog_fi_tclVisitorBase;

const tU16 DIAGLOG_FI_C_U16_ERROR_INTERNALFAILURE = 1;
const tU16 DIAGLOG_FI_C_U16_ERROR_INVALIDBINCONTAINERWRONGVERSION = 2;
const tU16 DIAGLOG_FI_C_U16_ERROR_INVALIDBINCONTAINERUNEXPECTEDDATA = 3;

class diaglog_fi_tclTypeBase : public fi_tclTypeBase
{
public:
  diaglog_fi_tclTypeBase() {}
  virtual ~diaglog_fi_tclTypeBase() {}
   
  virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& /*oVisitor*/) {}
};

class diaglog_fi_tclVisitableTypeBase :public diaglog_fi_tclTypeBase
{
public:
   virtual void vTakeVisitor(diaglog_fi_tclVisitorBase& /*oVisitor*/) {}
};

class diaglog_fi_tclU8 : public diaglog_fi_tclVisitableTypeBase
{
public:
   diaglog_fi_tclU8():u8Value(0) {}
   tU8 u8Value;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const diaglog_fi_tclU8& roRef) const
      { return (u8Value == roRef.u8Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(diaglog_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return diaglog_typesfi_tclToken::EN_U8;}
};

class diaglog_fi_tclS8 : public diaglog_fi_tclVisitableTypeBase
{
public:
   diaglog_fi_tclS8():s8Value(0) {}
   tS8 s8Value;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const diaglog_fi_tclS8& roRef) const
      { return (s8Value == roRef.s8Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(diaglog_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return diaglog_typesfi_tclToken::EN_S8;}
};

class diaglog_fi_tclU16 : public diaglog_fi_tclVisitableTypeBase
{
public:
   diaglog_fi_tclU16():u16Value(0) {}
   tU16 u16Value;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const diaglog_fi_tclU16& roRef) const
      { return (u16Value == roRef.u16Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(diaglog_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return diaglog_typesfi_tclToken::EN_U16;}
};

class diaglog_fi_tclS16 : public diaglog_fi_tclVisitableTypeBase
{
public:
   diaglog_fi_tclS16():s16Value(0) {}
   tS16 s16Value;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const diaglog_fi_tclS16& roRef) const
      { return (s16Value == roRef.s16Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(diaglog_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return diaglog_typesfi_tclToken::EN_S16;}
};

class diaglog_fi_tclU24 : public diaglog_fi_tclVisitableTypeBase
{
public:
   diaglog_fi_tclU24():u24Value(0) {}
   tU24 u24Value;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const diaglog_fi_tclU24& roRef) const
      { return (u24Value == roRef.u24Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(diaglog_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return diaglog_typesfi_tclToken::EN_U24;}
};

class diaglog_fi_tclS24 : public diaglog_fi_tclVisitableTypeBase
{
public:
   diaglog_fi_tclS24():s24Value(0) {}
   tS24 s24Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const diaglog_fi_tclS24& roRef) const
      { return (s24Value == roRef.s24Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(diaglog_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return diaglog_typesfi_tclToken::EN_S24;}
};

class diaglog_fi_tclU32 : public diaglog_fi_tclVisitableTypeBase
{
public:
   diaglog_fi_tclU32():u32Value(0) {}
   tU32 u32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const diaglog_fi_tclU32& roRef) const
      { return (u32Value == roRef.u32Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(diaglog_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return diaglog_typesfi_tclToken::EN_U32;}
};

class diaglog_fi_tclS32 : public diaglog_fi_tclVisitableTypeBase
{
public:
   diaglog_fi_tclS32():s32Value(0) {}
   tS32 s32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const diaglog_fi_tclS32& roRef) const
      { return (s32Value == roRef.s32Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(diaglog_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return diaglog_typesfi_tclToken::EN_S32;}
};

class diaglog_fi_tclU64 : public diaglog_fi_tclVisitableTypeBase
{
public:
   diaglog_fi_tclU64():u64Value(0) {}
   tU64 u64Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const diaglog_fi_tclU64& roRef) const
      { return (u64Value == roRef.u64Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(diaglog_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return diaglog_typesfi_tclToken::EN_U64;}
};

class diaglog_fi_tclS64 : public diaglog_fi_tclVisitableTypeBase
{
public:
   diaglog_fi_tclS64():s64Value(0) {}
   tS64 s64Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const diaglog_fi_tclS64& roRef) const
      { return (s64Value == roRef.s64Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(diaglog_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return diaglog_typesfi_tclToken::EN_S64;}
};

class diaglog_fi_tclF32 : public diaglog_fi_tclVisitableTypeBase
{
public:
   diaglog_fi_tclF32():f32Value(0) {}
   tFloat f32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const diaglog_fi_tclF32& roRef) const
      { return (f32Value == roRef.f32Value);  } //lint !e777
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(diaglog_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return diaglog_typesfi_tclToken::EN_F32;}
};

class diaglog_fi_tclF64 : public diaglog_fi_tclVisitableTypeBase
{
public:
   diaglog_fi_tclF64():f64Value(0) {}
   tDouble f64Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const diaglog_fi_tclF64& roRef) const
      { return (f64Value == roRef.f64Value); } //lint !e777
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(diaglog_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return diaglog_typesfi_tclToken::EN_F64;}
};

class diaglog_fi_tclBool : public diaglog_fi_tclVisitableTypeBase
{
public:
   diaglog_fi_tclBool():bValue(0) {}
   tBool bValue;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const diaglog_fi_tclBool& roRef) const
      { return (bValue == roRef.bValue); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(diaglog_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return diaglog_typesfi_tclToken::EN_BOOL;}
};

class diaglog_fi_tclString : public diaglog_fi_tclVisitableTypeBase
{
public:
   diaglog_fi_tclString():szValue(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_fi_tclString(const diaglog_fi_tclString& coRef);
   diaglog_fi_tclString& operator=(const diaglog_fi_tclString& coRef);
   virtual ~diaglog_fi_tclString();
#endif

   tString szValue;

   virtual void vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   tBool operator==(const diaglog_fi_tclString& roRef) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(diaglog_fi_tclVisitorBase& oVisitor);
#ifndef FI_DO_NOT_USE_TSTRING
   diaglog_fi_tclString& operator=(tCString coszString); // ADDED
   diaglog_fi_tclString(tCString coszInit); //ADDED
   tBool operator==(tCString coszString) const; // ADDED
   operator const tChar* () const; // ADDED
   operator tString&(); // ADDED
   tBool operator!=(intptr_t iNULL) const; // ADDED
   tChar* operator+(int iOffset); // ADDED
   tChar* operator+(tU8  u8Offset); // ADDED
   tChar* operator+(tU32 u32Offset); // ADDED
   tChar& operator[](tU16 u16Index); //ADDED
   tChar& operator[](tU32 u32Index); //ADDED
   tChar& operator[](tS32 s32Index); //ADDED
#endif
   enum tenCharSet {
      FI_EN_UNDEFINED = 0,
      FI_EN_ISO8859_15M,
      FI_EN_UTF8,
      FI_EN_ISO8859_1M
   };
   virtual tS32 s32GetTypeId() const { return diaglog_typesfi_tclToken::EN_STRING;}
   /* The following functions are used to import string values into FI-objects
    * and to export strings from FI-Objects.
    * The character encoding (ISO-Modified or UTF8) is provided as parameter
    * Attention: string values are copied by these functions, thus incoming and/or
    * outgoing strings have to be deleted externally.
    */
   tBool bSet(const diaglog_fi_tclString& corfoInit, tenCharSet enCharSet);
   tBool bSet(tCString coszInit, tenCharSet enCharSet);
   tString szGet(tenCharSet enCharSet) const;
};

class diaglog_fi_tclList : public diaglog_fi_tclVisitableTypeBase
{
public:
   diaglog_fi_tclList():u32ListSize(0) {}
   tU32 u32ListSize;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   tBool operator==(const diaglog_fi_tclList& roRef) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oIn);
   virtual void vTakeVisitor(diaglog_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return diaglog_typesfi_tclToken::EN_LIST;}
};

class diaglog_fi_tclMultiLanguageString : public diaglog_fi_tclVisitableTypeBase
{
public:
   diaglog_fi_tclMultiLanguageString():szValue(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_fi_tclMultiLanguageString(const diaglog_fi_tclMultiLanguageString& coRef);
   diaglog_fi_tclMultiLanguageString& operator=(const diaglog_fi_tclMultiLanguageString& coRef);
   virtual ~diaglog_fi_tclMultiLanguageString();
#endif

   tString szValue;

   virtual void vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   tBool operator==(const diaglog_fi_tclMultiLanguageString& roRef) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(diaglog_fi_tclVisitorBase& oVisitor);
#ifndef FI_DO_NOT_USE_TSTRING
   diaglog_fi_tclMultiLanguageString& operator=(tCString coszString); // ADDED
   diaglog_fi_tclMultiLanguageString(tCString coszInit); //ADDED
   tBool operator==(tCString coszString) const; // ADDED
   operator const tChar* () const; // ADDED
   operator tString&(); // ADDED
   tBool operator!=(intptr_t iNULL) const; // ADDED
   tChar* operator+(int iOffset); // ADDED
   tChar* operator+(tU8  u8Offset); // ADDED
   tChar* operator+(tU32 u32Offset); // ADDED
   tChar& operator[](tU16 u16Index); //ADDED
   tChar& operator[](tU32 u32Index); //ADDED
   tChar& operator[](tS32 s32Index); //ADDED
#endif
   enum tenCharSet {
      FI_EN_UNDEFINED = 0,
      FI_EN_ISO8859_15M,
      FI_EN_UTF8
   };
   virtual tS32 s32GetTypeId() const { return diaglog_typesfi_tclToken::EN_STRING;}
   /* The following functions are used to import string values into FI-objects
    * and to export strings from FI-Objects.
    * The character encoding (ISO-Modified or UTF8) is provided as parameter
    * Attention: string values are copied by these functions, thus incoming and/or
    * outgoing strings have to be deleted externally.
    */
   tBool bSet(const diaglog_fi_tclMultiLanguageString& corfoInit, tenCharSet enCharSet);
   tBool bSet(tCString coszInit, tenCharSet enCharSet);
   tString szGet(tenCharSet enCharSet) const;
};
class diaglog_fi_tcl_BinContainer;
class diaglog_fi_tcl_Reserved;
class diaglog_fi_tcl_u8_Percent;
class diaglog_fi_tcl_s16_PerThousand;
class diaglog_fi_tcl_u16_IndexInReferenceList;
class diaglog_fi_tcl_u16_ErrorCode;
class diaglog_fi_tcl_u16_RPM;
class diaglog_fi_tcl_s32_Kilogram;
class diaglog_fi_tcl_s32_Pound;
class diaglog_fi_tcl_s16_Meter;
class diaglog_fi_tcl_s32_Meter;
class diaglog_fi_tcl_s32_Yards;
class diaglog_fi_tcl_s32_Foot;
class diaglog_fi_tcl_s32_Centimeter;
class diaglog_fi_tcl_s32_Inch;
class diaglog_fi_tcl_s32_Millimeter;
class diaglog_fi_tcl_s32_Microliter;
class diaglog_fi_tcl_s32_Second;
class diaglog_fi_tcl_u16_MilliSecond;
class diaglog_fi_tcl_s32_MilliSecond;
class diaglog_fi_tcl_POSIXTime;
class diaglog_fi_tcl_e8_DST_State;
class diaglog_fi_tcl_TimeZoneElement;
class diaglog_fi_tcl_s16_KmPerHour;
class diaglog_fi_tcl_s16_MilesPerHour;
class diaglog_fi_tcl_s16_Knot;
class diaglog_fi_tcl_s16_CentimeterSecond;
class diaglog_fi_tcl_s16_Kelvin;
class diaglog_fi_tcl_s16_Fahrenheit;
class diaglog_fi_tcl_s32_Pascal;
class diaglog_fi_tcl_s32_Watt;
class diaglog_fi_tcl_FIVersion;
class diaglog_fi_tcl_s32_Longitude;
class diaglog_fi_tcl_s32_Latitude;
class diaglog_fi_tcl_PositionWGS84;
class diaglog_fi_tcl_RectangleWGS84;
class diaglog_fi_tcl_e16_ISOCountryCode;
class diaglog_fi_tcl_e16_ISOLanguageCode;
class diaglog_fi_tcl_LanguageID;
class diaglog_fi_tcl_u8_DirectionAbsolute;
class diaglog_fi_tcl_u8_DirectionRelative;
class diaglog_fi_tcl_s16_CentiDegree;
class diaglog_fi_tcl_s16_Degree;
class diaglog_fi_tcl_u16_DirectionAbsolute_CentiDegree;
class diaglog_fi_tcl_s16_DirectionRelative_CentiDegree;
class diaglog_fi_tcl_e8_FuelType;
class diaglog_fi_tcl_DistTimeFuel;
class diaglog_fi_tcl_e8_MethodResultReply;
class diaglog_fi_tcl_e8_TestResult;
class diaglog_fi_tcl_FreezeFrameData;
class diaglog_fi_tcl_FreezeFrameList;
class diaglog_fi_tcl_ReadRequestBuffer;
class diaglog_fi_tcl_ReadResultBuffer;
class diaglog_fi_tcl_ReadResultStructure;
class diaglog_fi_tcl_ReadResultList;
class diaglog_fi_tcl_ITC_Information;
class diaglog_fi_tcl_ProductionReadResultStructure;
class diaglog_fi_tcl_ProductionReadResultList;
class diaglog_fi_tcl_CustomerReadResultStructure;
class diaglog_fi_tcl_CustomerReadResultList;
class diaglog_fi_tcl_e8_Protocol;
class diaglog_fi_tcl_TestResult;
class diaglog_fi_tcl_TestResultList;
class diaglog_fi_tcl_SnapshotData;
class diaglog_fi_tcl_SnapshotDataList;
class diaglog_fi_tcl_SnapshotIdentification;
class diaglog_fi_tcl_SnapshotIdentificationList;
class diaglog_fi_tcl_ClearRequestBuffer;
class diaglog_fi_tcl_ClearResultBuffer;
class diaglog_fi_tcl_e8_ControlParameter;
class diaglog_fi_tcl_ControlList;
class diaglog_fi_tcl_e8_ReadValue;
class diaglog_fi_tcl_e8_VDLMediaType;
class diaglog_fi_tcl_e8_DiaglogDefsetType;
class diaglog_fi_tcl_e8_SendNextTestResReason;
class diaglog_fi_tcl_SendNextTestResultStructure;
class diaglog_fi_tcl_e8_ErrorCode;
class diaglog_fi_tcl_e8_GMLnGWDTCFaultType;
class diaglog_fi_tcl_ActiveDTCList;
class diaglog_fi_tcl_DiagProtocol;
class diaglog_fi_tcl_e8_Store;
class diaglog_fi_tcl_e8_RouteCalculationCommand;
class diaglog_fi_tcl_e8_RouteCalculationStatus;
class diaglog_fi_tcl_e8_Language;
class diaglog_fi_tcl_e8_Country;
class diaglog_fi_tcl_e8_LanguageSubsystem;
class diaglog_fi_tcl_e8_TestScreens;
class diaglog_fi_tcl_DisplayStringsList;
class diaglog_fi_tcl_DisplayData;
class diaglog_fi_tcl_e8_TroubleCodeType;
class diaglog_fi_tcl_e8_TestRoutines;
class diaglog_fi_tcl_e8_DefaultSettingsCategories;
class diaglog_fi_tcl_CountryLanguage;
class diaglog_fi_tcl_CountryLanguageResult;
class diaglog_fi_tcl_e8_TroubleCodeStatus;
class diaglog_fi_tcl_TroubleCode;
class diaglog_fi_tcl_TroubleCodeList;
class diaglog_fi_tcl_RouteCalculationStartParameter;
class diaglog_fi_tcl_RouteCalculationResultParameter;
class diaglog_fi_tcl_e16_Language;
class diaglog_fi_tcl_e16_SpeedLock;
class diaglog_fi_tcl_MessageBuffer;
class diaglog_fi_tcl_e8_DefSetMode;
class diaglog_fi_tcl_e8_DefSetServiceStatus;
class diaglog_fi_tcl_e8_DefSetGroups;
class diaglog_fi_tcl_e8_DiagMausSetup;
class diaglog_fi_tcl_e8_SimulatedKeys;
class diaglog_fi_tcl_KDSItemList;
class diaglog_fi_tcl_ConfigItemList;
class diaglog_fi_tcl_RequestDataUDS;
class diaglog_fi_tcl_ResponseDataUDS;
class diaglog_fi_tcl_DiagData;
class diaglog_fi_tcl_e8_RCtrlSource;
class diaglog_fi_tcl_e8_RCtrlCommand;
class diaglog_fi_tcl_e8_RCtrlSignal;
class diaglog_fi_tcl_e8_DiagRVCSignal;
class diaglog_fi_tcl_e8_CalibrationTable;
class diaglog_fi_tcl_CalibrationValue;
class diaglog_fi_tcl_e8_CalibrationTimeStampMonth;
class diaglog_fi_tcl_CalibrationTimeStamp;
class diaglog_fi_tcl_AlphaCode;
class diaglog_fi_tcl_e8_CalibrationParameterSize;
class diaglog_fi_tcl_e8_KdsViaUsbUpdateStatus;
class diaglog_fi_tcl_AntiTheftStatus;
class diaglog_fi_tcl_BinContainer : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_BinContainer();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_fi_tcl_BinContainer& operator=(const diaglog_fi_tcl_BinContainer& coRef);
   diaglog_fi_tcl_BinContainer(const diaglog_fi_tcl_BinContainer& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU8, std::allocator<tU8> > ContainerDataList;
   virtual ~diaglog_fi_tcl_BinContainer();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_fi_tcl_BinContainer& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_Reserved : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_Reserved();

   virtual ~diaglog_fi_tcl_Reserved();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_Reserved& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_u8_Percent : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_u8_Percent(tU8 _u8Value = 0);

   tU8 u8Value;
   virtual ~diaglog_fi_tcl_u8_Percent();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_u8_Percent& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_s16_PerThousand : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_s16_PerThousand(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~diaglog_fi_tcl_s16_PerThousand();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_s16_PerThousand& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_u16_IndexInReferenceList : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_u16_IndexInReferenceList(tU16 _u16Value = 0);

   tU16 u16Value;
   virtual ~diaglog_fi_tcl_u16_IndexInReferenceList();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_u16_IndexInReferenceList& roRef) const
      {  return (u16Value == roRef.u16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_u16_ErrorCode : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_u16_ErrorCode(tU16 _u16Value = 0);

   tU16 u16Value;
   virtual ~diaglog_fi_tcl_u16_ErrorCode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_u16_ErrorCode& roRef) const
      {  return (u16Value == roRef.u16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_u16_RPM : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_u16_RPM(tU16 _u16Value = 0);

   tU16 u16Value;
   virtual ~diaglog_fi_tcl_u16_RPM();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_u16_RPM& roRef) const
      {  return (u16Value == roRef.u16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_s32_Kilogram : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_s32_Kilogram(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~diaglog_fi_tcl_s32_Kilogram();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_s32_Kilogram& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_s32_Pound : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_s32_Pound(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~diaglog_fi_tcl_s32_Pound();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_s32_Pound& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_s16_Meter : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_s16_Meter(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~diaglog_fi_tcl_s16_Meter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_s16_Meter& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_s32_Meter : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_s32_Meter(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~diaglog_fi_tcl_s32_Meter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_s32_Meter& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_s32_Yards : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_s32_Yards(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~diaglog_fi_tcl_s32_Yards();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_s32_Yards& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_s32_Foot : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_s32_Foot(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~diaglog_fi_tcl_s32_Foot();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_s32_Foot& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_s32_Centimeter : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_s32_Centimeter(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~diaglog_fi_tcl_s32_Centimeter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_s32_Centimeter& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_s32_Inch : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_s32_Inch(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~diaglog_fi_tcl_s32_Inch();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_s32_Inch& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_s32_Millimeter : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_s32_Millimeter(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~diaglog_fi_tcl_s32_Millimeter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_s32_Millimeter& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_s32_Microliter : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_s32_Microliter(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~diaglog_fi_tcl_s32_Microliter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_s32_Microliter& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_s32_Second : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_s32_Second(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~diaglog_fi_tcl_s32_Second();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_s32_Second& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_u16_MilliSecond : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_u16_MilliSecond(tU16 _u16Value = 0);

   tU16 u16Value;
   virtual ~diaglog_fi_tcl_u16_MilliSecond();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_u16_MilliSecond& roRef) const
      {  return (u16Value == roRef.u16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_s32_MilliSecond : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_s32_MilliSecond(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~diaglog_fi_tcl_s32_MilliSecond();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_s32_MilliSecond& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_POSIXTime : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_POSIXTime();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_fi_tcl_POSIXTime& operator=(const diaglog_fi_tcl_POSIXTime& coRef);
   diaglog_fi_tcl_POSIXTime(const diaglog_fi_tcl_POSIXTime& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS32 Time;
   virtual ~diaglog_fi_tcl_POSIXTime();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_fi_tcl_POSIXTime& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_e8_DST_State : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_e8_DST_State();
   enum tenType {
      FI_EN_T_STANDARDTIME = 0UL,
      FI_EN_T_DAYLIGHTSAVINGTIME = 1UL,
      FI_EN_T_EVALUATIONNECESSARY = 2UL
   };
   tenType enType;

   diaglog_fi_tcl_e8_DST_State(diaglog_fi_tcl_e8_DST_State::tenType newValue)
      :enType(newValue)
   {}

   virtual ~diaglog_fi_tcl_e8_DST_State();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_e8_DST_State& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_TimeZoneElement : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_TimeZoneElement();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_fi_tcl_TimeZoneElement& operator=(const diaglog_fi_tcl_TimeZoneElement& coRef);
   diaglog_fi_tcl_TimeZoneElement(const diaglog_fi_tcl_TimeZoneElement& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   diaglog_fi_tclMultiLanguageString Abbreviation_StandardTime;
   diaglog_fi_tclMultiLanguageString Abbreviation_DST_in_effect;
   diaglog_fi_tcl_s32_Second TimeZoneDifference;
   diaglog_fi_tcl_e8_DST_State DST_State;
   diaglog_fi_tcl_s32_Second DSTDifference;
   std::vector<tU8, std::allocator<tU8> > DST_TimeDomain;
   virtual ~diaglog_fi_tcl_TimeZoneElement();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_fi_tcl_TimeZoneElement& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_s16_KmPerHour : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_s16_KmPerHour(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~diaglog_fi_tcl_s16_KmPerHour();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_s16_KmPerHour& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_s16_MilesPerHour : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_s16_MilesPerHour(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~diaglog_fi_tcl_s16_MilesPerHour();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_s16_MilesPerHour& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_s16_Knot : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_s16_Knot(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~diaglog_fi_tcl_s16_Knot();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_s16_Knot& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_s16_CentimeterSecond : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_s16_CentimeterSecond(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~diaglog_fi_tcl_s16_CentimeterSecond();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_s16_CentimeterSecond& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_s16_Kelvin : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_s16_Kelvin(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~diaglog_fi_tcl_s16_Kelvin();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_s16_Kelvin& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_s16_Fahrenheit : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_s16_Fahrenheit(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~diaglog_fi_tcl_s16_Fahrenheit();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_s16_Fahrenheit& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_s32_Pascal : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_s32_Pascal(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~diaglog_fi_tcl_s32_Pascal();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_s32_Pascal& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_s32_Watt : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_s32_Watt(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~diaglog_fi_tcl_s32_Watt();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_s32_Watt& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_FIVersion : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_FIVersion();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_fi_tcl_FIVersion& operator=(const diaglog_fi_tcl_FIVersion& coRef);
   diaglog_fi_tcl_FIVersion(const diaglog_fi_tcl_FIVersion& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 MajorVersion;
   tU8 MinorVersion;
   tU8 PatchVersion;
   virtual ~diaglog_fi_tcl_FIVersion();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_fi_tcl_FIVersion& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_s32_Longitude : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_s32_Longitude(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~diaglog_fi_tcl_s32_Longitude();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_s32_Longitude& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_s32_Latitude : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_s32_Latitude(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~diaglog_fi_tcl_s32_Latitude();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_s32_Latitude& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_PositionWGS84 : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_PositionWGS84();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_fi_tcl_PositionWGS84& operator=(const diaglog_fi_tcl_PositionWGS84& coRef);
   diaglog_fi_tcl_PositionWGS84(const diaglog_fi_tcl_PositionWGS84& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   diaglog_fi_tcl_s32_Longitude Longitude;
   diaglog_fi_tcl_s32_Latitude Latitude;
   virtual ~diaglog_fi_tcl_PositionWGS84();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_fi_tcl_PositionWGS84& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_RectangleWGS84 : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_RectangleWGS84();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_fi_tcl_RectangleWGS84& operator=(const diaglog_fi_tcl_RectangleWGS84& coRef);
   diaglog_fi_tcl_RectangleWGS84(const diaglog_fi_tcl_RectangleWGS84& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   diaglog_fi_tcl_s32_Longitude LongitudeMin;
   diaglog_fi_tcl_s32_Latitude LatitudeMin;
   diaglog_fi_tcl_s32_Longitude LongitudeMax;
   diaglog_fi_tcl_s32_Latitude LatitudeMax;
   virtual ~diaglog_fi_tcl_RectangleWGS84();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_fi_tcl_RectangleWGS84& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_e16_ISOCountryCode : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_e16_ISOCountryCode();
   enum tenType {
      FI_EN_ISO_ALPHA_3_UNDEFINED = 0UL,
      FI_EN_ISO_ALPHA_3_AFG = 1223UL,
      FI_EN_ISO_ALPHA_3_ALB = 1410UL,
      FI_EN_ISO_ALPHA_3_DZA = 4929UL,
      FI_EN_ISO_ALPHA_3_ASM = 1645UL,
      FI_EN_ISO_ALPHA_3_AND = 1476UL,
      FI_EN_ISO_ALPHA_3_AGO = 1263UL,
      FI_EN_ISO_ALPHA_3_AIA = 1313UL,
      FI_EN_ISO_ALPHA_3_ATG = 1671UL,
      FI_EN_ISO_ALPHA_3_ARG = 1607UL,
      FI_EN_ISO_ALPHA_3_ARM = 1613UL,
      FI_EN_ISO_ALPHA_3_ABW = 1111UL,
      FI_EN_ISO_ALPHA_3_AUS = 1715UL,
      FI_EN_ISO_ALPHA_3_AUT = 1716UL,
      FI_EN_ISO_ALPHA_3_AZE = 1861UL,
      FI_EN_ISO_ALPHA_3_BHS = 2323UL,
      FI_EN_ISO_ALPHA_3_BHR = 2322UL,
      FI_EN_ISO_ALPHA_3_BGD = 2276UL,
      FI_EN_ISO_ALPHA_3_BRB = 2626UL,
      FI_EN_ISO_ALPHA_3_BLR = 2450UL,
      FI_EN_ISO_ALPHA_3_BEL = 2220UL,
      FI_EN_ISO_ALPHA_3_BLZ = 2458UL,
      FI_EN_ISO_ALPHA_3_BEN = 2222UL,
      FI_EN_ISO_ALPHA_3_BMU = 2485UL,
      FI_EN_ISO_ALPHA_3_BTN = 2702UL,
      FI_EN_ISO_ALPHA_3_BOL = 2540UL,
      FI_EN_ISO_ALPHA_3_BIH = 2344UL,
      FI_EN_ISO_ALPHA_3_BWA = 2785UL,
      FI_EN_ISO_ALPHA_3_BRA = 2625UL,
      FI_EN_ISO_ALPHA_3_BRN = 2638UL,
      FI_EN_ISO_ALPHA_3_BGR = 2290UL,
      FI_EN_ISO_ALPHA_3_BFA = 2241UL,
      FI_EN_ISO_ALPHA_3_BDI = 2185UL,
      FI_EN_ISO_ALPHA_3_KHM = 11533UL,
      FI_EN_ISO_ALPHA_3_CMR = 3506UL,
      FI_EN_ISO_ALPHA_3_CAN = 3118UL,
      FI_EN_ISO_ALPHA_3_CPV = 3606UL,
      FI_EN_ISO_ALPHA_3_CYM = 3885UL,
      FI_EN_ISO_ALPHA_3_CAF = 3110UL,
      FI_EN_ISO_ALPHA_3_TCD = 20580UL,
      FI_EN_ISO_ALPHA_3_CHL = 3340UL,
      FI_EN_ISO_ALPHA_3_CHN = 3342UL,
      FI_EN_ISO_ALPHA_3_COL = 3564UL,
      FI_EN_ISO_ALPHA_3_COM = 3565UL,
      FI_EN_ISO_ALPHA_3_COG = 3559UL,
      FI_EN_ISO_ALPHA_3_COD = 3556UL,
      FI_EN_ISO_ALPHA_3_COK = 3563UL,
      FI_EN_ISO_ALPHA_3_CRI = 3657UL,
      FI_EN_ISO_ALPHA_3_CIV = 3382UL,
      FI_EN_ISO_ALPHA_3_HRV = 8790UL,
      FI_EN_ISO_ALPHA_3_CUB = 3746UL,
      FI_EN_ISO_ALPHA_3_CYP = 3888UL,
      FI_EN_ISO_ALPHA_3_CZE = 3909UL,
      FI_EN_ISO_ALPHA_3_DNK = 4555UL,
      FI_EN_ISO_ALPHA_3_DJI = 4425UL,
      FI_EN_ISO_ALPHA_3_DMA = 4513UL,
      FI_EN_ISO_ALPHA_3_DOM = 4589UL,
      FI_EN_ISO_ALPHA_3_ECU = 5237UL,
      FI_EN_ISO_ALPHA_3_EGY = 5369UL,
      FI_EN_ISO_ALPHA_3_SLV = 19862UL,
      FI_EN_ISO_ALPHA_3_GNQ = 7633UL,
      FI_EN_ISO_ALPHA_3_ERI = 5705UL,
      FI_EN_ISO_ALPHA_3_EST = 5748UL,
      FI_EN_ISO_ALPHA_3_ETH = 5768UL,
      FI_EN_ISO_ALPHA_3_FLK = 6539UL,
      FI_EN_ISO_ALPHA_3_FRO = 6735UL,
      FI_EN_ISO_ALPHA_3_FJI = 6473UL,
      FI_EN_ISO_ALPHA_3_FIN = 6446UL,
      FI_EN_ISO_ALPHA_3_FRA = 6721UL,
      FI_EN_ISO_ALPHA_3_GUF = 7846UL,
      FI_EN_ISO_ALPHA_3_PYF = 17190UL,
      FI_EN_ISO_ALPHA_3_GAB = 7202UL,
      FI_EN_ISO_ALPHA_3_GMB = 7586UL,
      FI_EN_ISO_ALPHA_3_GEO = 7343UL,
      FI_EN_ISO_ALPHA_3_DEU = 4277UL,
      FI_EN_ISO_ALPHA_3_GHA = 7425UL,
      FI_EN_ISO_ALPHA_3_GIB = 7458UL,
      FI_EN_ISO_ALPHA_3_GRC = 7747UL,
      FI_EN_ISO_ALPHA_3_GRL = 7756UL,
      FI_EN_ISO_ALPHA_3_GRD = 7748UL,
      FI_EN_ISO_ALPHA_3_GLP = 7568UL,
      FI_EN_ISO_ALPHA_3_GUM = 7853UL,
      FI_EN_ISO_ALPHA_3_GTM = 7821UL,
      FI_EN_ISO_ALPHA_3_GIN = 7470UL,
      FI_EN_ISO_ALPHA_3_GNB = 7618UL,
      FI_EN_ISO_ALPHA_3_GUY = 7865UL,
      FI_EN_ISO_ALPHA_3_HTI = 8841UL,
      FI_EN_ISO_ALPHA_3_VAT = 22580UL,
      FI_EN_ISO_ALPHA_3_HND = 8644UL,
      FI_EN_ISO_ALPHA_3_HKG = 8551UL,
      FI_EN_ISO_ALPHA_3_HUN = 8878UL,
      FI_EN_ISO_ALPHA_3_ISL = 9836UL,
      FI_EN_ISO_ALPHA_3_IND = 9668UL,
      FI_EN_ISO_ALPHA_3_IDN = 9358UL,
      FI_EN_ISO_ALPHA_3_INT = 9684UL,
      FI_EN_ISO_ALPHA_3_IRN = 9806UL,
      FI_EN_ISO_ALPHA_3_IRQ = 9809UL,
      FI_EN_ISO_ALPHA_3_IRL = 9804UL,
      FI_EN_ISO_ALPHA_3_ISR = 9842UL,
      FI_EN_ISO_ALPHA_3_ITA = 9857UL,
      FI_EN_ISO_ALPHA_3_JAM = 10285UL,
      FI_EN_ISO_ALPHA_3_JPN = 10766UL,
      FI_EN_ISO_ALPHA_3_JOR = 10738UL,
      FI_EN_ISO_ALPHA_3_KAZ = 11322UL,
      FI_EN_ISO_ALPHA_3_KEN = 11438UL,
      FI_EN_ISO_ALPHA_3_KIR = 11570UL,
      FI_EN_ISO_ALPHA_3_PRK = 16971UL,
      FI_EN_ISO_ALPHA_3_KOR = 11762UL,
      FI_EN_ISO_ALPHA_3_KWT = 12020UL,
      FI_EN_ISO_ALPHA_3_KGZ = 11514UL,
      FI_EN_ISO_ALPHA_3_LAO = 12335UL,
      FI_EN_ISO_ALPHA_3_LVA = 12993UL,
      FI_EN_ISO_ALPHA_3_LBN = 12366UL,
      FI_EN_ISO_ALPHA_3_LSO = 12911UL,
      FI_EN_ISO_ALPHA_3_LBR = 12370UL,
      FI_EN_ISO_ALPHA_3_LBY = 12377UL,
      FI_EN_ISO_ALPHA_3_LIE = 12581UL,
      FI_EN_ISO_ALPHA_3_LTU = 12949UL,
      FI_EN_ISO_ALPHA_3_LUX = 12984UL,
      FI_EN_ISO_ALPHA_3_MAC = 13347UL,
      FI_EN_ISO_ALPHA_3_MKD = 13668UL,
      FI_EN_ISO_ALPHA_3_MDG = 13447UL,
      FI_EN_ISO_ALPHA_3_MWI = 14057UL,
      FI_EN_ISO_ALPHA_3_MYS = 14131UL,
      FI_EN_ISO_ALPHA_3_MDV = 13462UL,
      FI_EN_ISO_ALPHA_3_MLI = 13705UL,
      FI_EN_ISO_ALPHA_3_MLT = 13716UL,
      FI_EN_ISO_ALPHA_3_MHL = 13580UL,
      FI_EN_ISO_ALPHA_3_MTQ = 13969UL,
      FI_EN_ISO_ALPHA_3_MRT = 13908UL,
      FI_EN_ISO_ALPHA_3_MUS = 14003UL,
      FI_EN_ISO_ALPHA_3_MYT = 14132UL,
      FI_EN_ISO_ALPHA_3_MEX = 13496UL,
      FI_EN_ISO_ALPHA_3_FSM = 6765UL,
      FI_EN_ISO_ALPHA_3_MDA = 13441UL,
      FI_EN_ISO_ALPHA_3_MCO = 13423UL,
      FI_EN_ISO_ALPHA_3_MNG = 13767UL,
      FI_EN_ISO_ALPHA_3_MNE = 13765UL,
      FI_EN_ISO_ALPHA_3_MSR = 13938UL,
      FI_EN_ISO_ALPHA_3_MAR = 13362UL,
      FI_EN_ISO_ALPHA_3_MOZ = 13818UL,
      FI_EN_ISO_ALPHA_3_MMR = 13746UL,
      FI_EN_ISO_ALPHA_3_NAM = 14381UL,
      FI_EN_ISO_ALPHA_3_NRU = 14933UL,
      FI_EN_ISO_ALPHA_3_NPL = 14860UL,
      FI_EN_ISO_ALPHA_3_NLD = 14724UL,
      FI_EN_ISO_ALPHA_3_ANT = 1492UL,
      FI_EN_ISO_ALPHA_3_NCL = 14444UL,
      FI_EN_ISO_ALPHA_3_NZL = 15180UL,
      FI_EN_ISO_ALPHA_3_NIC = 14627UL,
      FI_EN_ISO_ALPHA_3_NER = 14514UL,
      FI_EN_ISO_ALPHA_3_NGA = 14561UL,
      FI_EN_ISO_ALPHA_3_NIU = 14645UL,
      FI_EN_ISO_ALPHA_3_NFK = 14539UL,
      FI_EN_ISO_ALPHA_3_MNP = 13776UL,
      FI_EN_ISO_ALPHA_3_NOR = 14834UL,
      FI_EN_ISO_ALPHA_3_PSE = 16997UL,
      FI_EN_ISO_ALPHA_3_OMN = 15790UL,
      FI_EN_ISO_ALPHA_3_PAK = 16427UL,
      FI_EN_ISO_ALPHA_3_PLW = 16791UL,
      FI_EN_ISO_ALPHA_3_PAN = 16430UL,
      FI_EN_ISO_ALPHA_3_PNG = 16839UL,
      FI_EN_ISO_ALPHA_3_PRY = 16985UL,
      FI_EN_ISO_ALPHA_3_PER = 16562UL,
      FI_EN_ISO_ALPHA_3_PHL = 16652UL,
      FI_EN_ISO_ALPHA_3_PCN = 16494UL,
      FI_EN_ISO_ALPHA_3_POL = 16876UL,
      FI_EN_ISO_ALPHA_3_PRT = 16980UL,
      FI_EN_ISO_ALPHA_3_PRI = 16969UL,
      FI_EN_ISO_ALPHA_3_QAT = 17460UL,
      FI_EN_ISO_ALPHA_3_REU = 18613UL,
      FI_EN_ISO_ALPHA_3_ROU = 18933UL,
      FI_EN_ISO_ALPHA_3_RUS = 19123UL,
      FI_EN_ISO_ALPHA_3_RWA = 19169UL,
      FI_EN_ISO_ALPHA_3_KNA = 11713UL,
      FI_EN_ISO_ALPHA_3_LCA = 12385UL,
      FI_EN_ISO_ALPHA_3_VCT = 22644UL,
      FI_EN_ISO_ALPHA_3_WSM = 24173UL,
      FI_EN_ISO_ALPHA_3_SMR = 19890UL,
      FI_EN_ISO_ALPHA_3_STP = 20112UL,
      FI_EN_ISO_ALPHA_3_SAU = 19509UL,
      FI_EN_ISO_ALPHA_3_SEN = 19630UL,
      FI_EN_ISO_ALPHA_3_SRB = 20034UL,
      FI_EN_ISO_ALPHA_3_SYC = 20259UL,
      FI_EN_ISO_ALPHA_3_SLE = 19845UL,
      FI_EN_ISO_ALPHA_3_SGP = 19696UL,
      FI_EN_ISO_ALPHA_3_SVK = 20171UL,
      FI_EN_ISO_ALPHA_3_SVN = 20174UL,
      FI_EN_ISO_ALPHA_3_SLB = 19842UL,
      FI_EN_ISO_ALPHA_3_SOM = 19949UL,
      FI_EN_ISO_ALPHA_3_ZAF = 26662UL,
      FI_EN_ISO_ALPHA_3_ESP = 5744UL,
      FI_EN_ISO_ALPHA_3_LKA = 12641UL,
      FI_EN_ISO_ALPHA_3_SHN = 19726UL,
      FI_EN_ISO_ALPHA_3_SPM = 19981UL,
      FI_EN_ISO_ALPHA_3_SDN = 19598UL,
      FI_EN_ISO_ALPHA_3_SUR = 20146UL,
      FI_EN_ISO_ALPHA_3_SJM = 19789UL,
      FI_EN_ISO_ALPHA_3_SWZ = 20218UL,
      FI_EN_ISO_ALPHA_3_SWE = 20197UL,
      FI_EN_ISO_ALPHA_3_CHE = 3333UL,
      FI_EN_ISO_ALPHA_3_SYR = 20274UL,
      FI_EN_ISO_ALPHA_3_TWN = 21230UL,
      FI_EN_ISO_ALPHA_3_TJK = 20811UL,
      FI_EN_ISO_ALPHA_3_TZA = 21313UL,
      FI_EN_ISO_ALPHA_3_THA = 20737UL,
      FI_EN_ISO_ALPHA_3_TLS = 20883UL,
      FI_EN_ISO_ALPHA_3_TGO = 20719UL,
      FI_EN_ISO_ALPHA_3_TKL = 20844UL,
      FI_EN_ISO_ALPHA_3_TON = 20974UL,
      FI_EN_ISO_ALPHA_3_TTO = 21135UL,
      FI_EN_ISO_ALPHA_3_TUN = 21166UL,
      FI_EN_ISO_ALPHA_3_TUR = 21170UL,
      FI_EN_ISO_ALPHA_3_TKM = 20845UL,
      FI_EN_ISO_ALPHA_3_TCA = 20577UL,
      FI_EN_ISO_ALPHA_3_TUV = 21174UL,
      FI_EN_ISO_ALPHA_3_UGA = 21729UL,
      FI_EN_ISO_ALPHA_3_UKR = 21874UL,
      FI_EN_ISO_ALPHA_3_ARE = 1605UL,
      FI_EN_ISO_ALPHA_3_GBR = 7250UL,
      FI_EN_ISO_ALPHA_3_USA = 22113UL,
      FI_EN_ISO_ALPHA_3_URY = 22105UL,
      FI_EN_ISO_ALPHA_3_UZB = 22338UL,
      FI_EN_ISO_ALPHA_3_VUT = 23220UL,
      FI_EN_ISO_ALPHA_3_VEN = 22702UL,
      FI_EN_ISO_ALPHA_3_VNM = 22989UL,
      FI_EN_ISO_ALPHA_3_VGB = 22754UL,
      FI_EN_ISO_ALPHA_3_VIR = 22834UL,
      FI_EN_ISO_ALPHA_3_WLF = 23942UL,
      FI_EN_ISO_ALPHA_3_ESH = 5736UL,
      FI_EN_ISO_ALPHA_3_YEM = 25773UL,
      FI_EN_ISO_ALPHA_3_YUG = 26279UL,
      FI_EN_ISO_ALPHA_3_ZMB = 27042UL,
      FI_EN_ISO_ALPHA_3_ZWE = 27365UL
   };
   tenType enType;

   diaglog_fi_tcl_e16_ISOCountryCode(diaglog_fi_tcl_e16_ISOCountryCode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~diaglog_fi_tcl_e16_ISOCountryCode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_e16_ISOCountryCode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_e16_ISOLanguageCode : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_e16_ISOLanguageCode();
   enum tenType {
      FI_EN_ISO_639_1_UNDEFINED = 0UL,
      FI_EN_ISO_639_1_AA = 24929UL,
      FI_EN_ISO_639_1_AB = 24930UL,
      FI_EN_ISO_639_1_AE = 24933UL,
      FI_EN_ISO_639_1_AF = 24934UL,
      FI_EN_ISO_639_1_AK = 24939UL,
      FI_EN_ISO_639_1_AM = 24941UL,
      FI_EN_ISO_639_1_AN = 24942UL,
      FI_EN_ISO_639_1_AR = 24946UL,
      FI_EN_ISO_639_1_AS = 24947UL,
      FI_EN_ISO_639_1_AV = 24950UL,
      FI_EN_ISO_639_1_AY = 24953UL,
      FI_EN_ISO_639_1_AZ = 24954UL,
      FI_EN_ISO_639_1_BA = 25185UL,
      FI_EN_ISO_639_1_BE = 25189UL,
      FI_EN_ISO_639_1_BG = 25191UL,
      FI_EN_ISO_639_1_BH = 25192UL,
      FI_EN_ISO_639_1_BI = 25193UL,
      FI_EN_ISO_639_1_BL = 25196UL,
      FI_EN_ISO_639_1_BM = 25197UL,
      FI_EN_ISO_639_1_BN = 25198UL,
      FI_EN_ISO_639_1_BO = 25199UL,
      FI_EN_ISO_639_1_BR = 25202UL,
      FI_EN_ISO_639_1_BS = 25203UL,
      FI_EN_ISO_639_1_BT = 25204UL,
      FI_EN_ISO_639_1_CA = 25441UL,
      FI_EN_ISO_639_1_CE = 25445UL,
      FI_EN_ISO_639_1_CF = 25446UL,
      FI_EN_ISO_639_1_CH = 25448UL,
      FI_EN_ISO_639_1_CL = 25452UL,
      FI_EN_ISO_639_1_CN = 25454UL,
      FI_EN_ISO_639_1_CO = 25455UL,
      FI_EN_ISO_639_1_CR = 25458UL,
      FI_EN_ISO_639_1_CS = 25459UL,
      FI_EN_ISO_639_1_CT = 25460UL,
      FI_EN_ISO_639_1_CU = 25461UL,
      FI_EN_ISO_639_1_CV = 25462UL,
      FI_EN_ISO_639_1_CY = 25465UL,
      FI_EN_ISO_639_1_DA = 25697UL,
      FI_EN_ISO_639_1_DE = 25701UL,
      FI_EN_ISO_639_1_DV = 25718UL,
      FI_EN_ISO_639_1_DZ = 25722UL,
      FI_EN_ISO_639_1_EE = 25957UL,
      FI_EN_ISO_639_1_EG = 25959UL,
      FI_EN_ISO_639_1_EL = 25964UL,
      FI_EN_ISO_639_1_EN = 25966UL,
      FI_EN_ISO_639_1_EO = 25967UL,
      FI_EN_ISO_639_1_ES = 25971UL,
      FI_EN_ISO_639_1_ET = 25972UL,
      FI_EN_ISO_639_1_EU = 25973UL,
      FI_EN_ISO_639_1_FA = 26209UL,
      FI_EN_ISO_639_1_FF = 26214UL,
      FI_EN_ISO_639_1_FI = 26217UL,
      FI_EN_ISO_639_1_FJ = 26218UL,
      FI_EN_ISO_639_1_FO = 26223UL,
      FI_EN_ISO_639_1_FR = 26226UL,
      FI_EN_ISO_639_1_FY = 26233UL,
      FI_EN_ISO_639_1_GA = 26465UL,
      FI_EN_ISO_639_1_GD = 26468UL,
      FI_EN_ISO_639_1_GL = 26476UL,
      FI_EN_ISO_639_1_GN = 26478UL,
      FI_EN_ISO_639_1_GU = 26485UL,
      FI_EN_ISO_639_1_GV = 26486UL,
      FI_EN_ISO_639_1_HA = 26721UL,
      FI_EN_ISO_639_1_HE = 26725UL,
      FI_EN_ISO_639_1_HI = 26729UL,
      FI_EN_ISO_639_1_HO = 26735UL,
      FI_EN_ISO_639_1_HR = 26738UL,
      FI_EN_ISO_639_1_HU = 26741UL,
      FI_EN_ISO_639_1_HY = 26745UL,
      FI_EN_ISO_639_1_HZ = 26746UL,
      FI_EN_ISO_639_1_IA = 26977UL,
      FI_EN_ISO_639_1_ID = 26980UL,
      FI_EN_ISO_639_1_IE = 26981UL,
      FI_EN_ISO_639_1_IG = 26983UL,
      FI_EN_ISO_639_1_II = 26985UL,
      FI_EN_ISO_639_1_IK = 26987UL,
      FI_EN_ISO_639_1_IO = 26991UL,
      FI_EN_ISO_639_1_IS = 26995UL,
      FI_EN_ISO_639_1_IT = 26996UL,
      FI_EN_ISO_639_1_IU = 26997UL,
      FI_EN_ISO_639_1_JA = 27233UL,
      FI_EN_ISO_639_1_JV = 27254UL,
      FI_EN_ISO_639_1_KA = 27489UL,
      FI_EN_ISO_639_1_KG = 27495UL,
      FI_EN_ISO_639_1_KI = 27497UL,
      FI_EN_ISO_639_1_KJ = 27498UL,
      FI_EN_ISO_639_1_KK = 27499UL,
      FI_EN_ISO_639_1_KL = 27500UL,
      FI_EN_ISO_639_1_KM = 27501UL,
      FI_EN_ISO_639_1_KN = 27502UL,
      FI_EN_ISO_639_1_KO = 27503UL,
      FI_EN_ISO_639_1_KR = 27506UL,
      FI_EN_ISO_639_1_KS = 27507UL,
      FI_EN_ISO_639_1_KU = 27509UL,
      FI_EN_ISO_639_1_KV = 27510UL,
      FI_EN_ISO_639_1_KW = 27511UL,
      FI_EN_ISO_639_1_KY = 27513UL,
      FI_EN_ISO_639_1_LA = 27745UL,
      FI_EN_ISO_639_1_LB = 27746UL,
      FI_EN_ISO_639_1_LG = 27751UL,
      FI_EN_ISO_639_1_LI = 27753UL,
      FI_EN_ISO_639_1_LN = 27758UL,
      FI_EN_ISO_639_1_LO = 27759UL,
      FI_EN_ISO_639_1_LT = 27764UL,
      FI_EN_ISO_639_1_LU = 27765UL,
      FI_EN_ISO_639_1_LV = 27766UL,
      FI_EN_ISO_639_1_MC = 28003UL,
      FI_EN_ISO_639_1_MG = 28007UL,
      FI_EN_ISO_639_1_MH = 28008UL,
      FI_EN_ISO_639_1_MI = 28009UL,
      FI_EN_ISO_639_1_MK = 28011UL,
      FI_EN_ISO_639_1_ML = 28012UL,
      FI_EN_ISO_639_1_MN = 28014UL,
      FI_EN_ISO_639_1_MO = 28015UL,
      FI_EN_ISO_639_1_MR = 28018UL,
      FI_EN_ISO_639_1_MS = 28019UL,
      FI_EN_ISO_639_1_MT = 28020UL,
      FI_EN_ISO_639_1_MY = 28025UL,
      FI_EN_ISO_639_1_NA = 28257UL,
      FI_EN_ISO_639_1_NB = 28258UL,
      FI_EN_ISO_639_1_ND = 28260UL,
      FI_EN_ISO_639_1_NE = 28261UL,
      FI_EN_ISO_639_1_NG = 28263UL,
      FI_EN_ISO_639_1_NL = 28268UL,
      FI_EN_ISO_639_1_NN = 28270UL,
      FI_EN_ISO_639_1_NO = 28271UL,
      FI_EN_ISO_639_1_NR = 28274UL,
      FI_EN_ISO_639_1_NV = 28278UL,
      FI_EN_ISO_639_1_NY = 28281UL,
      FI_EN_ISO_639_1_OC = 28515UL,
      FI_EN_ISO_639_1_OJ = 28522UL,
      FI_EN_ISO_639_1_OM = 28525UL,
      FI_EN_ISO_639_1_OR = 28530UL,
      FI_EN_ISO_639_1_OS = 28531UL,
      FI_EN_ISO_639_1_PA = 28769UL,
      FI_EN_ISO_639_1_PI = 28777UL,
      FI_EN_ISO_639_1_PL = 28780UL,
      FI_EN_ISO_639_1_PS = 28787UL,
      FI_EN_ISO_639_1_PT = 28788UL,
      FI_EN_ISO_639_1_QU = 29045UL,
      FI_EN_ISO_639_1_RM = 29293UL,
      FI_EN_ISO_639_1_RN = 29294UL,
      FI_EN_ISO_639_1_RO = 29295UL,
      FI_EN_ISO_639_1_RT = 29300UL,
      FI_EN_ISO_639_1_RU = 29301UL,
      FI_EN_ISO_639_1_RW = 29303UL,
      FI_EN_ISO_639_1_SA = 29537UL,
      FI_EN_ISO_639_1_SB = 29538UL,
      FI_EN_ISO_639_1_SC = 29539UL,
      FI_EN_ISO_639_1_SD = 29540UL,
      FI_EN_ISO_639_1_SE = 29541UL,
      FI_EN_ISO_639_1_SG = 29543UL,
      FI_EN_ISO_639_1_SH = 29544UL,
      FI_EN_ISO_639_1_SI = 29545UL,
      FI_EN_ISO_639_1_SK = 29547UL,
      FI_EN_ISO_639_1_SL = 29548UL,
      FI_EN_ISO_639_1_SM = 29549UL,
      FI_EN_ISO_639_1_SN = 29550UL,
      FI_EN_ISO_639_1_SO = 29551UL,
      FI_EN_ISO_639_1_SQ = 29553UL,
      FI_EN_ISO_639_1_SR = 29554UL,
      FI_EN_ISO_639_1_SS = 29555UL,
      FI_EN_ISO_639_1_ST = 29556UL,
      FI_EN_ISO_639_1_SU = 29557UL,
      FI_EN_ISO_639_1_SV = 29558UL,
      FI_EN_ISO_639_1_SW = 29559UL,
      FI_EN_ISO_639_1_SX = 29560UL,
      FI_EN_ISO_639_1_TA = 29793UL,
      FI_EN_ISO_639_1_TE = 29797UL,
      FI_EN_ISO_639_1_TG = 29799UL,
      FI_EN_ISO_639_1_TH = 29800UL,
      FI_EN_ISO_639_1_TI = 29801UL,
      FI_EN_ISO_639_1_TK = 29803UL,
      FI_EN_ISO_639_1_TL = 29804UL,
      FI_EN_ISO_639_1_TN = 29806UL,
      FI_EN_ISO_639_1_TO = 29807UL,
      FI_EN_ISO_639_1_TR = 29810UL,
      FI_EN_ISO_639_1_TS = 29811UL,
      FI_EN_ISO_639_1_TT = 29812UL,
      FI_EN_ISO_639_1_TW = 29815UL,
      FI_EN_ISO_639_1_TY = 29817UL,
      FI_EN_ISO_639_1_UE = 30053UL,
      FI_EN_ISO_639_1_UG = 30055UL,
      FI_EN_ISO_639_1_UK = 30059UL,
      FI_EN_ISO_639_1_UL = 30060UL,
      FI_EN_ISO_639_1_UR = 30066UL,
      FI_EN_ISO_639_1_UZ = 30074UL,
      FI_EN_ISO_639_1_VA = 30305UL,
      FI_EN_ISO_639_1_VE = 30309UL,
      FI_EN_ISO_639_1_VI = 30313UL,
      FI_EN_ISO_639_1_VO = 30319UL,
      FI_EN_ISO_639_1_WA = 30561UL,
      FI_EN_ISO_639_1_WO = 30575UL,
      FI_EN_ISO_639_1_XH = 30824UL,
      FI_EN_ISO_639_1_YI = 31081UL,
      FI_EN_ISO_639_1_YO = 31087UL,
      FI_EN_ISO_639_1_ZA = 31329UL,
      FI_EN_ISO_639_1_ZH = 31336UL,
      FI_EN_ISO_639_1_ZL = 31340UL,
      FI_EN_ISO_639_1_ZU = 31349UL
   };
   tenType enType;

   diaglog_fi_tcl_e16_ISOLanguageCode(diaglog_fi_tcl_e16_ISOLanguageCode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~diaglog_fi_tcl_e16_ISOLanguageCode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_e16_ISOLanguageCode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_LanguageID : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_LanguageID();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_fi_tcl_LanguageID& operator=(const diaglog_fi_tcl_LanguageID& coRef);
   diaglog_fi_tcl_LanguageID(const diaglog_fi_tcl_LanguageID& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   diaglog_fi_tcl_e16_ISOLanguageCode ISO639_LanguageCode;
   diaglog_fi_tcl_e16_ISOCountryCode ISO3166_CountryCode;
   virtual ~diaglog_fi_tcl_LanguageID();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_fi_tcl_LanguageID& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_u8_DirectionAbsolute : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_u8_DirectionAbsolute(tU8 _u8Value = 0);

   tU8 u8Value;
   virtual ~diaglog_fi_tcl_u8_DirectionAbsolute();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_u8_DirectionAbsolute& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_u8_DirectionRelative : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_u8_DirectionRelative(tU8 _u8Value = 0);

   tU8 u8Value;
   virtual ~diaglog_fi_tcl_u8_DirectionRelative();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_u8_DirectionRelative& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_s16_CentiDegree : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_s16_CentiDegree(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~diaglog_fi_tcl_s16_CentiDegree();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_s16_CentiDegree& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_s16_Degree : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_s16_Degree(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~diaglog_fi_tcl_s16_Degree();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_s16_Degree& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_u16_DirectionAbsolute_CentiDegree : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_u16_DirectionAbsolute_CentiDegree(tU16 _u16Value = 0);

   tU16 u16Value;
   virtual ~diaglog_fi_tcl_u16_DirectionAbsolute_CentiDegree();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_u16_DirectionAbsolute_CentiDegree& roRef) const
      {  return (u16Value == roRef.u16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_s16_DirectionRelative_CentiDegree : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_s16_DirectionRelative_CentiDegree(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~diaglog_fi_tcl_s16_DirectionRelative_CentiDegree();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_s16_DirectionRelative_CentiDegree& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_e8_FuelType : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_e8_FuelType();
   enum tenType {
      FI_EN_RESERVED = 0UL,
      FI_EN_PETROL = 1UL,
      FI_EN_DIESEL = 2UL,
      FI_EN_HYDROGEN = 3UL,
      FI_EN_COMPRESSEDNATURALGAS = 4UL,
      FI_EN_LIQUIFIEDPETROLEUMGAS = 5UL
   };
   tenType enType;

   diaglog_fi_tcl_e8_FuelType(diaglog_fi_tcl_e8_FuelType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~diaglog_fi_tcl_e8_FuelType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_e8_FuelType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_DistTimeFuel : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_DistTimeFuel();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_fi_tcl_DistTimeFuel& operator=(const diaglog_fi_tcl_DistTimeFuel& coRef);
   diaglog_fi_tcl_DistTimeFuel(const diaglog_fi_tcl_DistTimeFuel& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   diaglog_fi_tcl_s32_Meter Distance;
   diaglog_fi_tcl_s32_Second Time;
   diaglog_fi_tcl_s32_Microliter Fuel;
   virtual ~diaglog_fi_tcl_DistTimeFuel();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_fi_tcl_DistTimeFuel& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_e8_MethodResultReply : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_e8_MethodResultReply();
   enum tenType {
      FI_EN_ACCEPTED = 0UL,
      FI_EN_REJECTED = 1UL
   };
   tenType enType;

   diaglog_fi_tcl_e8_MethodResultReply(diaglog_fi_tcl_e8_MethodResultReply::tenType newValue)
      :enType(newValue)
   {}

   virtual ~diaglog_fi_tcl_e8_MethodResultReply();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_e8_MethodResultReply& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_e8_TestResult : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_e8_TestResult();
   enum tenType {
      FI_EN_PASSED = 0UL,
      FI_EN_FAILED = 1UL,
      FI_EN_NORESULT = 2UL,
      FI_EN_PASSEDDIAGNOSTIC = 3UL,
      FI_EN_FAILEDDIAGNOSTIC = 4UL,
      FI_EN_NORESULTDIAGNOSTIC = 5UL,
      FI_EN_DISABLE = 6UL,
      FI_EN_ENABLE = 7UL
   };
   tenType enType;

   diaglog_fi_tcl_e8_TestResult(diaglog_fi_tcl_e8_TestResult::tenType newValue)
      :enType(newValue)
   {}

   virtual ~diaglog_fi_tcl_e8_TestResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_e8_TestResult& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_FreezeFrameData : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_FreezeFrameData();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_fi_tcl_FreezeFrameData& operator=(const diaglog_fi_tcl_FreezeFrameData& coRef);
   diaglog_fi_tcl_FreezeFrameData(const diaglog_fi_tcl_FreezeFrameData& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 ID;
   std::vector<tU8, std::allocator<tU8> > Data;
   virtual ~diaglog_fi_tcl_FreezeFrameData();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_fi_tcl_FreezeFrameData& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_FreezeFrameList : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_FreezeFrameList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_fi_tcl_FreezeFrameList& operator=(const diaglog_fi_tcl_FreezeFrameList& coRef);
   diaglog_fi_tcl_FreezeFrameList(const diaglog_fi_tcl_FreezeFrameList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<diaglog_fi_tcl_FreezeFrameData, std::allocator<diaglog_fi_tcl_FreezeFrameData> > FreezeFrameDataList;
   virtual ~diaglog_fi_tcl_FreezeFrameList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_fi_tcl_FreezeFrameList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_ReadRequestBuffer : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_ReadRequestBuffer();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_fi_tcl_ReadRequestBuffer& operator=(const diaglog_fi_tcl_ReadRequestBuffer& coRef);
   diaglog_fi_tcl_ReadRequestBuffer(const diaglog_fi_tcl_ReadRequestBuffer& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU8, std::allocator<tU8> > ReadRequestBuffer;
   virtual ~diaglog_fi_tcl_ReadRequestBuffer();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_fi_tcl_ReadRequestBuffer& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_ReadResultBuffer : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_ReadResultBuffer();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_fi_tcl_ReadResultBuffer& operator=(const diaglog_fi_tcl_ReadResultBuffer& coRef);
   diaglog_fi_tcl_ReadResultBuffer(const diaglog_fi_tcl_ReadResultBuffer& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU8, std::allocator<tU8> > ReadResultBuffer;
   virtual ~diaglog_fi_tcl_ReadResultBuffer();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_fi_tcl_ReadResultBuffer& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_ReadResultStructure : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_ReadResultStructure();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_fi_tcl_ReadResultStructure& operator=(const diaglog_fi_tcl_ReadResultStructure& coRef);
   diaglog_fi_tcl_ReadResultStructure(const diaglog_fi_tcl_ReadResultStructure& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DTC;
   tU8 StatusOfDtc;
   virtual ~diaglog_fi_tcl_ReadResultStructure();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_fi_tcl_ReadResultStructure& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_ReadResultList : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_ReadResultList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_fi_tcl_ReadResultList& operator=(const diaglog_fi_tcl_ReadResultList& coRef);
   diaglog_fi_tcl_ReadResultList(const diaglog_fi_tcl_ReadResultList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<diaglog_fi_tcl_ReadResultStructure, std::allocator<diaglog_fi_tcl_ReadResultStructure> > DTCList;
   virtual ~diaglog_fi_tcl_ReadResultList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_fi_tcl_ReadResultList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_ITC_Information : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_ITC_Information();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_fi_tcl_ITC_Information& operator=(const diaglog_fi_tcl_ITC_Information& coRef);
   diaglog_fi_tcl_ITC_Information(const diaglog_fi_tcl_ITC_Information& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 ITC;
   tU32 DTC;
   tU8 StatusOfItc;
   tU32 AgeingCounter;
   tU32 OccurenceCounter;
   virtual ~diaglog_fi_tcl_ITC_Information();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_fi_tcl_ITC_Information& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_ProductionReadResultStructure : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_ProductionReadResultStructure();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_fi_tcl_ProductionReadResultStructure& operator=(const diaglog_fi_tcl_ProductionReadResultStructure& coRef);
   diaglog_fi_tcl_ProductionReadResultStructure(const diaglog_fi_tcl_ProductionReadResultStructure& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 ITC;
   tU8 Status;
   virtual ~diaglog_fi_tcl_ProductionReadResultStructure();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_fi_tcl_ProductionReadResultStructure& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_ProductionReadResultList : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_ProductionReadResultList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_fi_tcl_ProductionReadResultList& operator=(const diaglog_fi_tcl_ProductionReadResultList& coRef);
   diaglog_fi_tcl_ProductionReadResultList(const diaglog_fi_tcl_ProductionReadResultList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<diaglog_fi_tcl_ProductionReadResultStructure, std::allocator<diaglog_fi_tcl_ProductionReadResultStructure> > ITCList;
   virtual ~diaglog_fi_tcl_ProductionReadResultList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_fi_tcl_ProductionReadResultList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_CustomerReadResultStructure : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_CustomerReadResultStructure();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_fi_tcl_CustomerReadResultStructure& operator=(const diaglog_fi_tcl_CustomerReadResultStructure& coRef);
   diaglog_fi_tcl_CustomerReadResultStructure(const diaglog_fi_tcl_CustomerReadResultStructure& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DTC;
   tU8 Status;
   virtual ~diaglog_fi_tcl_CustomerReadResultStructure();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_fi_tcl_CustomerReadResultStructure& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_CustomerReadResultList : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_CustomerReadResultList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_fi_tcl_CustomerReadResultList& operator=(const diaglog_fi_tcl_CustomerReadResultList& coRef);
   diaglog_fi_tcl_CustomerReadResultList(const diaglog_fi_tcl_CustomerReadResultList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<diaglog_fi_tcl_CustomerReadResultStructure, std::allocator<diaglog_fi_tcl_CustomerReadResultStructure> > DTCList;
   virtual ~diaglog_fi_tcl_CustomerReadResultList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_fi_tcl_CustomerReadResultList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_e8_Protocol : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_e8_Protocol();
   enum tenType {
      FI_EN_UDS = 1UL,
      FI_EN_GMLAN = 2UL
   };
   tenType enType;

   diaglog_fi_tcl_e8_Protocol(diaglog_fi_tcl_e8_Protocol::tenType newValue)
      :enType(newValue)
   {}

   virtual ~diaglog_fi_tcl_e8_Protocol();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_e8_Protocol& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_TestResult : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_TestResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_fi_tcl_TestResult& operator=(const diaglog_fi_tcl_TestResult& coRef);
   diaglog_fi_tcl_TestResult(const diaglog_fi_tcl_TestResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 TroubleCode;
   diaglog_fi_tcl_e8_TestResult Result;
   diaglog_fi_tcl_FreezeFrameList FreezeFrameList;
   virtual ~diaglog_fi_tcl_TestResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_fi_tcl_TestResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_TestResultList : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_TestResultList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_fi_tcl_TestResultList& operator=(const diaglog_fi_tcl_TestResultList& coRef);
   diaglog_fi_tcl_TestResultList(const diaglog_fi_tcl_TestResultList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<diaglog_fi_tcl_TestResult, std::allocator<diaglog_fi_tcl_TestResult> > TestResultList;
   virtual ~diaglog_fi_tcl_TestResultList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_fi_tcl_TestResultList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_SnapshotData : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_SnapshotData();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_fi_tcl_SnapshotData& operator=(const diaglog_fi_tcl_SnapshotData& coRef);
   diaglog_fi_tcl_SnapshotData(const diaglog_fi_tcl_SnapshotData& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 RecordNumber;
   tU8 NumberOfData;
   std::vector<tU8, std::allocator<tU8> > Data;
   virtual ~diaglog_fi_tcl_SnapshotData();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_fi_tcl_SnapshotData& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_SnapshotDataList : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_SnapshotDataList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_fi_tcl_SnapshotDataList& operator=(const diaglog_fi_tcl_SnapshotDataList& coRef);
   diaglog_fi_tcl_SnapshotDataList(const diaglog_fi_tcl_SnapshotDataList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<diaglog_fi_tcl_SnapshotData, std::allocator<diaglog_fi_tcl_SnapshotData> > SnapshotData;
   virtual ~diaglog_fi_tcl_SnapshotDataList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_fi_tcl_SnapshotDataList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_SnapshotIdentification : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_SnapshotIdentification();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_fi_tcl_SnapshotIdentification& operator=(const diaglog_fi_tcl_SnapshotIdentification& coRef);
   diaglog_fi_tcl_SnapshotIdentification(const diaglog_fi_tcl_SnapshotIdentification& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DTC;
   tU8 RecordNumber;
   virtual ~diaglog_fi_tcl_SnapshotIdentification();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_fi_tcl_SnapshotIdentification& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_SnapshotIdentificationList : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_SnapshotIdentificationList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_fi_tcl_SnapshotIdentificationList& operator=(const diaglog_fi_tcl_SnapshotIdentificationList& coRef);
   diaglog_fi_tcl_SnapshotIdentificationList(const diaglog_fi_tcl_SnapshotIdentificationList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<diaglog_fi_tcl_SnapshotIdentification, std::allocator<diaglog_fi_tcl_SnapshotIdentification> > SnapshotIdentification;
   virtual ~diaglog_fi_tcl_SnapshotIdentificationList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_fi_tcl_SnapshotIdentificationList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_ClearRequestBuffer : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_ClearRequestBuffer();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_fi_tcl_ClearRequestBuffer& operator=(const diaglog_fi_tcl_ClearRequestBuffer& coRef);
   diaglog_fi_tcl_ClearRequestBuffer(const diaglog_fi_tcl_ClearRequestBuffer& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU8, std::allocator<tU8> > ClearRequestBuffer;
   virtual ~diaglog_fi_tcl_ClearRequestBuffer();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_fi_tcl_ClearRequestBuffer& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_ClearResultBuffer : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_ClearResultBuffer();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_fi_tcl_ClearResultBuffer& operator=(const diaglog_fi_tcl_ClearResultBuffer& coRef);
   diaglog_fi_tcl_ClearResultBuffer(const diaglog_fi_tcl_ClearResultBuffer& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU8, std::allocator<tU8> > ClearResultBuffer;
   virtual ~diaglog_fi_tcl_ClearResultBuffer();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_fi_tcl_ClearResultBuffer& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_e8_ControlParameter : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_e8_ControlParameter();
   enum tenType {
      FI_EN_DISABLELOGGING = 0UL,
      FI_EN_ENABLELOGGING = 1UL,
      FI_EN_ENABLELOGGINGPERSISTENT = 2UL,
      FI_EN_DISABLELOGGINPERSISTENT = 3UL,
      FI_EN_ENABLECALIBRATIONBLOCKING = 4UL,
      FI_EN_DISABLECALIBRATIONBLOCKING = 5UL
   };
   tenType enType;

   diaglog_fi_tcl_e8_ControlParameter(diaglog_fi_tcl_e8_ControlParameter::tenType newValue)
      :enType(newValue)
   {}

   virtual ~diaglog_fi_tcl_e8_ControlParameter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_e8_ControlParameter& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_ControlList : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_ControlList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_fi_tcl_ControlList& operator=(const diaglog_fi_tcl_ControlList& coRef);
   diaglog_fi_tcl_ControlList(const diaglog_fi_tcl_ControlList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU32, std::allocator<tU32> > DTCList;
   virtual ~diaglog_fi_tcl_ControlList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_fi_tcl_ControlList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_e8_ReadValue : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_e8_ReadValue();
   enum tenType {
      FI_EN_DTCSSETBYDIAGNOSTICTEST = 0UL,
      FI_EN_CONTINUOUSDTCSSET = 1UL
   };
   tenType enType;

   diaglog_fi_tcl_e8_ReadValue(diaglog_fi_tcl_e8_ReadValue::tenType newValue)
      :enType(newValue)
   {}

   virtual ~diaglog_fi_tcl_e8_ReadValue();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_e8_ReadValue& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_e8_VDLMediaType : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_e8_VDLMediaType();
   enum tenType {
      FI_EN_FFS = 0UL,
      FI_EN_SDCARD = 1UL
   };
   tenType enType;

   diaglog_fi_tcl_e8_VDLMediaType(diaglog_fi_tcl_e8_VDLMediaType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~diaglog_fi_tcl_e8_VDLMediaType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_e8_VDLMediaType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_e8_DiaglogDefsetType : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_e8_DiaglogDefsetType();
   enum tenType {
      FI_EN_CLEAR_ERRMEM = 1UL,
      FI_EN_ACTIVATE_DEACTIVATE_DTC = 2UL
   };
   tenType enType;

   diaglog_fi_tcl_e8_DiaglogDefsetType(diaglog_fi_tcl_e8_DiaglogDefsetType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~diaglog_fi_tcl_e8_DiaglogDefsetType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_e8_DiaglogDefsetType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_e8_SendNextTestResReason : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_e8_SendNextTestResReason();
   enum tenType {
      FI_EN_CLEAR_CODE = 1UL,
      FI_EN_BLOCKING_MODE_RESET = 2UL
   };
   tenType enType;

   diaglog_fi_tcl_e8_SendNextTestResReason(diaglog_fi_tcl_e8_SendNextTestResReason::tenType newValue)
      :enType(newValue)
   {}

   virtual ~diaglog_fi_tcl_e8_SendNextTestResReason();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_e8_SendNextTestResReason& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_SendNextTestResultStructure : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_SendNextTestResultStructure();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_fi_tcl_SendNextTestResultStructure& operator=(const diaglog_fi_tcl_SendNextTestResultStructure& coRef);
   diaglog_fi_tcl_SendNextTestResultStructure(const diaglog_fi_tcl_SendNextTestResultStructure& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   diaglog_fi_tcl_e8_SendNextTestResReason SendNextTestResReason;
   std::vector<tU16, std::allocator<tU16> > ITCList;
   virtual ~diaglog_fi_tcl_SendNextTestResultStructure();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_fi_tcl_SendNextTestResultStructure& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_e8_ErrorCode : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_e8_ErrorCode();
   enum tenType {
      FI_EN_FBLOCKIDNOTAVAILABLE = 1UL,
      FI_EN_INSTIDNOTAVAILABLE = 2UL,
      FI_EN_FKTIDNOTAVAILABLE = 3UL,
      FI_EN_OPTYPENOTAVAILABLE = 4UL,
      FI_EN_INVALIDLENGTH = 5UL,
      FI_EN_PARAMETERWRONG_OUTOFRANGE = 6UL,
      FI_EN_PARAMETERNOTAVAILABLE = 7UL,
      FI_EN_PARAMETERMISSING = 8UL,
      FI_EN_TOOMANYPARAMETERS = 9UL,
      FI_EN_FUNCTIONSPECIFIC = 32UL,
      FI_EN_BUSY = 64UL,
      FI_EN_NOTAVAILABLE = 65UL
   };
   tenType enType;

   diaglog_fi_tcl_e8_ErrorCode(diaglog_fi_tcl_e8_ErrorCode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~diaglog_fi_tcl_e8_ErrorCode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_e8_ErrorCode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_e8_GMLnGWDTCFaultType : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_e8_GMLnGWDTCFaultType();
   enum tenType {
      FI_EN_E8NOT_SUPPORTED = 0UL,
      FI_EN_E8TYPE_A = 1UL,
      FI_EN_E8TYPE_B = 2UL,
      FI_EN_E8TYPE_C = 3UL
   };
   tenType enType;

   diaglog_fi_tcl_e8_GMLnGWDTCFaultType(diaglog_fi_tcl_e8_GMLnGWDTCFaultType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~diaglog_fi_tcl_e8_GMLnGWDTCFaultType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_e8_GMLnGWDTCFaultType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_ActiveDTCList : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_ActiveDTCList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_fi_tcl_ActiveDTCList& operator=(const diaglog_fi_tcl_ActiveDTCList& coRef);
   diaglog_fi_tcl_ActiveDTCList(const diaglog_fi_tcl_ActiveDTCList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU32, std::allocator<tU32> > DTCList;
   virtual ~diaglog_fi_tcl_ActiveDTCList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_fi_tcl_ActiveDTCList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_DiagProtocol : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_DiagProtocol();
   enum tenType {
      FI_EN_UNKNOWN = 255UL,
      FI_EN_UDS = 0UL,
      FI_EN_GMLAN = 1UL
   };
   tenType enType;

   diaglog_fi_tcl_DiagProtocol(diaglog_fi_tcl_DiagProtocol::tenType newValue)
      :enType(newValue)
   {}

   virtual ~diaglog_fi_tcl_DiagProtocol();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_DiagProtocol& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_e8_Store : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_e8_Store();
   enum tenType {
      FI_EN_UNDEFINED = 255UL,
      FI_EN_VOLATILE = 0UL,
      FI_EN_PERSISTENT = 1UL
   };
   tenType enType;

   diaglog_fi_tcl_e8_Store(diaglog_fi_tcl_e8_Store::tenType newValue)
      :enType(newValue)
   {}

   virtual ~diaglog_fi_tcl_e8_Store();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_e8_Store& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_e8_RouteCalculationCommand : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_e8_RouteCalculationCommand();
   enum tenType {
      FI_EN_UNDEFINED = 255UL,
      FI_EN_SETPOSITIONSANDCALCULATE = 0UL,
      FI_EN_CALCULATEONLY = 1UL,
      FI_EN_SETCURRENTPOSITION = 2UL,
      FI_EN_SETDESTINATION = 3UL,
      FI_EN_ABORTCALCULATION = 127UL
   };
   tenType enType;

   diaglog_fi_tcl_e8_RouteCalculationCommand(diaglog_fi_tcl_e8_RouteCalculationCommand::tenType newValue)
      :enType(newValue)
   {}

   virtual ~diaglog_fi_tcl_e8_RouteCalculationCommand();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_e8_RouteCalculationCommand& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_e8_RouteCalculationStatus : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_e8_RouteCalculationStatus();
   enum tenType {
      FI_EN_UNDEFINED = 255UL,
      FI_EN_CALCULATIONCOMPLETE = 0UL,
      FI_EN_CALCULATIONFAILED = 1UL,
      FI_EN_CURRENTPOSITIONNOTSET = 2UL,
      FI_EN_DESTINATIONNOTSET = 3UL
   };
   tenType enType;

   diaglog_fi_tcl_e8_RouteCalculationStatus(diaglog_fi_tcl_e8_RouteCalculationStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~diaglog_fi_tcl_e8_RouteCalculationStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_e8_RouteCalculationStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_e8_Language : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_e8_Language();
   enum tenType {
      FI_EN_UNDEFINED = 255UL,
      FI_EN_GERMAN = 1UL,
      FI_EN_DUTCH = 2UL,
      FI_EN_ENGLISHMETRIC = 3UL,
      FI_EN_FRENCH = 4UL,
      FI_EN_SPANISH = 5UL,
      FI_EN_JAPANESE = 6UL,
      FI_EN_ITALIAN = 7UL,
      FI_EN_ENGLISHMETRICUSA = 8UL,
      FI_EN_SWEDISH = 9UL,
      FI_EN_DANISH = 10UL,
      FI_EN_PORTUGESE = 11UL,
      FI_EN_ENGLISHIMPERIAL = 12UL,
      FI_EN_ENGLISHIMPERIALUSA = 13UL,
      FI_EN_FINNISH = 14UL,
      FI_EN_NORWEGIAN = 15UL,
      FI_EN_GREEK = 16UL,
      FI_EN_TURKISH = 17UL,
      FI_EN_POLISH = 18UL,
      FI_EN_CZECH = 19UL,
      FI_EN_CHINESE = 20UL
   };
   tenType enType;

   diaglog_fi_tcl_e8_Language(diaglog_fi_tcl_e8_Language::tenType newValue)
      :enType(newValue)
   {}

   virtual ~diaglog_fi_tcl_e8_Language();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_e8_Language& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_e8_Country : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_e8_Country();
   enum tenType {
      FI_EN_UNDEFINED = 255UL,
      FI_EN_USA = 1UL,
      FI_EN_NETHERLANDS = 31UL,
      FI_EN_BELGIUM = 32UL,
      FI_EN_FRANCE = 33UL,
      FI_EN_SPAIN = 34UL,
      FI_EN_ITALY = 39UL,
      FI_EN_SWITZERLAND = 41UL,
      FI_EN_GREATBRITAIN = 44UL,
      FI_EN_DENMARK = 45UL,
      FI_EN_SWEDEN = 46UL,
      FI_EN_GERMANY = 49UL,
      FI_EN_PORTUGAL = 51UL,
      FI_EN_LUXEMBOURG = 52UL,
      FI_EN_JAPAN = 81UL
   };
   tenType enType;

   diaglog_fi_tcl_e8_Country(diaglog_fi_tcl_e8_Country::tenType newValue)
      :enType(newValue)
   {}

   virtual ~diaglog_fi_tcl_e8_Country();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_e8_Country& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_e8_LanguageSubsystem : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_e8_LanguageSubsystem();
   enum tenType {
      FI_EN_UNDEFINED = 255UL,
      FI_EN_HMI = 0UL,
      FI_EN_SDS = 1UL
   };
   tenType enType;

   diaglog_fi_tcl_e8_LanguageSubsystem(diaglog_fi_tcl_e8_LanguageSubsystem::tenType newValue)
      :enType(newValue)
   {}

   virtual ~diaglog_fi_tcl_e8_LanguageSubsystem();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_e8_LanguageSubsystem& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_e8_TestScreens : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_e8_TestScreens();
   enum tenType {
      FI_EN_UNDEFINED = 255UL,
      FI_EN_NOTESTSCREEN = 0UL,
      FI_EN_PLAINWHITE = 1UL,
      FI_EN_PLAINBLACK = 2UL,
      FI_EN_PLAINRED = 3UL,
      FI_EN_PLAINGREEN = 4UL,
      FI_EN_PLAINBLUE = 5UL,
      FI_EN_COLOURED = 6UL,
      FI_EN_SCREEN_7 = 7UL,
      FI_EN_SCREEN_8 = 8UL,
      FI_EN_SCREEN_9 = 9UL,
      FI_EN_DIAGNOSISMASK = 10UL,
      FI_EN_COLOURGRADIATION = 80UL,
      FI_EN_LATTICE = 81UL,
      FI_EN_LEFTWHITERIGHTBLACK = 96UL,
      FI_EN_LEFTBLACKRIGHTWHITE = 97UL,
      FI_EN_PIXELWISECHESSBOARD = 98UL,
      FI_EN_TEFSPECIAL1 = 146UL,
      FI_EN_TEFSPECIAL2 = 147UL,
      FI_EN_RGB_NOK = 16UL,
      FI_EN_RGB_OK = 17UL,
      FI_EN_RGB_REPDARK = 18UL
   };
   tenType enType;

   diaglog_fi_tcl_e8_TestScreens(diaglog_fi_tcl_e8_TestScreens::tenType newValue)
      :enType(newValue)
   {}

   virtual ~diaglog_fi_tcl_e8_TestScreens();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_e8_TestScreens& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_DisplayStringsList : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_DisplayStringsList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_fi_tcl_DisplayStringsList& operator=(const diaglog_fi_tcl_DisplayStringsList& coRef);
   diaglog_fi_tcl_DisplayStringsList(const diaglog_fi_tcl_DisplayStringsList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<diaglog_fi_tclString, std::allocator<diaglog_fi_tclString> > StringList;
   virtual ~diaglog_fi_tcl_DisplayStringsList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_fi_tcl_DisplayStringsList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_DisplayData : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_DisplayData();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_fi_tcl_DisplayData& operator=(const diaglog_fi_tcl_DisplayData& coRef);
   diaglog_fi_tcl_DisplayData(const diaglog_fi_tcl_DisplayData& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   diaglog_fi_tcl_e8_TestScreens TestScreen;
   diaglog_fi_tcl_DisplayStringsList DisplayStrings;
   virtual ~diaglog_fi_tcl_DisplayData();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_fi_tcl_DisplayData& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_e8_TroubleCodeType : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_e8_TroubleCodeType();
   enum tenType {
      FI_EN_UNDEFINED = 255UL,
      FI_EN_DTC = 0UL,
      FI_EN_ITC = 1UL
   };
   tenType enType;

   diaglog_fi_tcl_e8_TroubleCodeType(diaglog_fi_tcl_e8_TroubleCodeType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~diaglog_fi_tcl_e8_TroubleCodeType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_e8_TroubleCodeType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_e8_TestRoutines : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_e8_TestRoutines();
   enum tenType {
      FI_EN_UNDEFINED = 255UL,
      FI_EN_CDIFTEST = 0UL,
      FI_EN_DVDIFTEST = 1UL,
      FI_EN_CDREADTESTSHORT = 2UL,
      FI_EN_DVDREADTESTSHORT = 3UL,
      FI_EN_CDREADTESTINTENSIVE = 4UL,
      FI_EN_DVDREADTESTINTENSIVE = 5UL,
      FI_EN_FMSEEKTEST = 6UL,
      FI_EN_GYROTEST = 7UL,
      FI_EN_GPSANTENNATEST = 8UL,
      FI_EN_TWEETERTEST = 9UL,
      FI_EN_SPEAKERTEST = 10UL,
      FI_EN_ONDEMANDSELFTEST = 11UL
   };
   tenType enType;

   diaglog_fi_tcl_e8_TestRoutines(diaglog_fi_tcl_e8_TestRoutines::tenType newValue)
      :enType(newValue)
   {}

   virtual ~diaglog_fi_tcl_e8_TestRoutines();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_e8_TestRoutines& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_e8_DefaultSettingsCategories : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_e8_DefaultSettingsCategories();
   enum tenType {
      FI_EN_UNDEFINED = 255UL,
      FI_EN_AMFM = 0UL,
      FI_EN_CDAUX = 1UL,
      FI_EN_NAVMAP = 2UL,
      FI_EN_DESTINATIONMEMORY = 3UL,
      FI_EN_VOLUMEDISPLAY = 4UL,
      FI_EN_RESTORE_VEHICLE_SETTING = 5UL,
      FI_EN_CLEAR_ALL_PRIVATE_DATA = 6UL,
      FI_EN_RESTORE_RADIO_SETTING = 7UL
   };
   tenType enType;

   diaglog_fi_tcl_e8_DefaultSettingsCategories(diaglog_fi_tcl_e8_DefaultSettingsCategories::tenType newValue)
      :enType(newValue)
   {}

   virtual ~diaglog_fi_tcl_e8_DefaultSettingsCategories();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_e8_DefaultSettingsCategories& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_CountryLanguage : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_CountryLanguage();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_fi_tcl_CountryLanguage& operator=(const diaglog_fi_tcl_CountryLanguage& coRef);
   diaglog_fi_tcl_CountryLanguage(const diaglog_fi_tcl_CountryLanguage& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   diaglog_fi_tcl_e8_Country Country;
   diaglog_fi_tcl_e8_Language Language;
   diaglog_fi_tcl_e8_LanguageSubsystem Subsystem;
   virtual ~diaglog_fi_tcl_CountryLanguage();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_fi_tcl_CountryLanguage& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_CountryLanguageResult : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_CountryLanguageResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_fi_tcl_CountryLanguageResult& operator=(const diaglog_fi_tcl_CountryLanguageResult& coRef);
   diaglog_fi_tcl_CountryLanguageResult(const diaglog_fi_tcl_CountryLanguageResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Success;
   std::vector<diaglog_fi_tcl_CountryLanguage, std::allocator<diaglog_fi_tcl_CountryLanguage> > CountryLanguageList;
   virtual ~diaglog_fi_tcl_CountryLanguageResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_fi_tcl_CountryLanguageResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_e8_TroubleCodeStatus : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_e8_TroubleCodeStatus();
   enum tenType {
      FI_EN_UNDEFINED = 255UL,
      FI_EN_INACTIVE = 0UL,
      FI_EN_ACTIVE = 1UL,
      FI_EN_NOTCOMPLETE = 2UL,
      FI_EN_ACTIVENOTCOMPLETE = 3UL,
      FI_EN_WASACTIVE = 4UL
   };
   tenType enType;

   diaglog_fi_tcl_e8_TroubleCodeStatus(diaglog_fi_tcl_e8_TroubleCodeStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~diaglog_fi_tcl_e8_TroubleCodeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_e8_TroubleCodeStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_TroubleCode : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_TroubleCode();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_fi_tcl_TroubleCode& operator=(const diaglog_fi_tcl_TroubleCode& coRef);
   diaglog_fi_tcl_TroubleCode(const diaglog_fi_tcl_TroubleCode& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 TroubleCode;
   diaglog_fi_tcl_e8_TroubleCodeStatus Status;
   virtual ~diaglog_fi_tcl_TroubleCode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_fi_tcl_TroubleCode& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_TroubleCodeList : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_TroubleCodeList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_fi_tcl_TroubleCodeList& operator=(const diaglog_fi_tcl_TroubleCodeList& coRef);
   diaglog_fi_tcl_TroubleCodeList(const diaglog_fi_tcl_TroubleCodeList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<diaglog_fi_tcl_TroubleCode, std::allocator<diaglog_fi_tcl_TroubleCode> > TroubleCodeList;
   virtual ~diaglog_fi_tcl_TroubleCodeList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_fi_tcl_TroubleCodeList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_RouteCalculationStartParameter : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_RouteCalculationStartParameter();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_fi_tcl_RouteCalculationStartParameter& operator=(const diaglog_fi_tcl_RouteCalculationStartParameter& coRef);
   diaglog_fi_tcl_RouteCalculationStartParameter(const diaglog_fi_tcl_RouteCalculationStartParameter& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS32 CurrentPositionLongitude;
   tS32 CurrentPositionLatitude;
   tS32 DestinationLongitude;
   tS32 DestinationLatitude;
   tU8 RouteIndex;
   tU8 RouteOptimisation;
   diaglog_fi_tcl_e8_RouteCalculationCommand Command;
   virtual ~diaglog_fi_tcl_RouteCalculationStartParameter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_fi_tcl_RouteCalculationStartParameter& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_RouteCalculationResultParameter : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_RouteCalculationResultParameter();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_fi_tcl_RouteCalculationResultParameter& operator=(const diaglog_fi_tcl_RouteCalculationResultParameter& coRef);
   diaglog_fi_tcl_RouteCalculationResultParameter(const diaglog_fi_tcl_RouteCalculationResultParameter& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS32 CurrentPositionLongitude;
   tS32 CurrentPositionLatitude;
   tS32 DestinationLongitude;
   tS32 DestinationLatitude;
   tU8 RouteIndex;
   tU8 RouteOptimisation;
   diaglog_fi_tcl_e8_RouteCalculationCommand Command;
   diaglog_fi_tcl_e8_RouteCalculationStatus RouteCalculationStatus;
   tU32 RouteLength;
   tU32 RouteDuration;
   virtual ~diaglog_fi_tcl_RouteCalculationResultParameter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_fi_tcl_RouteCalculationResultParameter& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_e16_Language : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_e16_Language();
   enum tenType {
      FI_EN_UNDEFINED = 65535UL,
      FI_EN_SWEDISH = 1UL,
      FI_EN_DANISH = 2UL,
      FI_EN_FINNISH = 3UL,
      FI_EN_ENGLISH = 4UL,
      FI_EN_GERMAN = 5UL,
      FI_EN_DUTCH = 6UL,
      FI_EN_FRENCH = 7UL,
      FI_EN_ITALIAN = 8UL,
      FI_EN_SPANISH = 9UL,
      FI_EN_PORTUGUESE = 10UL,
      FI_EN_USENGLISH = 11UL,
      FI_EN_CANADIANFRENCH = 12UL,
      FI_EN_PORTUGUESEBRAZIL = 13UL,
      FI_EN_JAPANESE = 14UL,
      FI_EN_ENGLISHWITHNUMBERCODES = 15UL,
      FI_EN_HUNGARIAN = 16UL,
      FI_EN_TURKISH = 17UL,
      FI_EN_RUSSIAN = 18UL,
      FI_EN_POLISH = 19UL,
      FI_EN_CZECH = 20UL,
      FI_EN_NORWEGIAN = 21UL,
      FI_EN_LATINSPANISH = 22UL,
      FI_EN_AUSTRALIANENGLISH = 23UL,
      FI_EN_THAI = 24UL,
      FI_EN_ASIAPACIFICENGLISH = 25UL,
      FI_EN_CHINESE = 26UL,
      FI_EN_TAIWANESE = 27UL
   };
   tenType enType;

   diaglog_fi_tcl_e16_Language(diaglog_fi_tcl_e16_Language::tenType newValue)
      :enType(newValue)
   {}

   virtual ~diaglog_fi_tcl_e16_Language();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_e16_Language& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_e16_SpeedLock : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_e16_SpeedLock();
   enum tenType {
      FI_EN_UNDEFINED = 65535UL,
      FI_EN_INACTIVE = 1UL,
      FI_EN_ACTIVE = 2UL
   };
   tenType enType;

   diaglog_fi_tcl_e16_SpeedLock(diaglog_fi_tcl_e16_SpeedLock::tenType newValue)
      :enType(newValue)
   {}

   virtual ~diaglog_fi_tcl_e16_SpeedLock();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_e16_SpeedLock& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_MessageBuffer : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_MessageBuffer();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_fi_tcl_MessageBuffer& operator=(const diaglog_fi_tcl_MessageBuffer& coRef);
   diaglog_fi_tcl_MessageBuffer(const diaglog_fi_tcl_MessageBuffer& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU8, std::allocator<tU8> > MessageBuffer;
   virtual ~diaglog_fi_tcl_MessageBuffer();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_fi_tcl_MessageBuffer& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_e8_DefSetMode : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_e8_DefSetMode();
   enum tenType {
      FI_EN_DEFSET_SRC_NOT_DEF = 255UL,
      FI_EN_DEFSET_SRC_SET_USER = 0UL,
      FI_EN_DEFSET_SRC_SET_TEF = 1UL,
      FI_EN_DEFSET_SRC_UPREG = 2UL,
      FI_EN_DEFSET_SRC_RELUPREG = 3UL,
      FI_EN_DEFSET_SRC_GET = 4UL,
      FI_EN_DEFSET_SRC_CODING = 5UL,
      FI_EN_DEFSET_SRC_CALIBRATION = 6UL,
      FI_EN_DEFSET_START = 7UL,
      FI_EN_DEFSET_COMPLETE = 8UL,
      FI_EN_DEFSET_SRC_SET_OEM = 9UL
   };
   tenType enType;

   diaglog_fi_tcl_e8_DefSetMode(diaglog_fi_tcl_e8_DefSetMode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~diaglog_fi_tcl_e8_DefSetMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_e8_DefSetMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_e8_DefSetServiceStatus : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_e8_DefSetServiceStatus();
   enum tenType {
      FI_EN_DEFSET_STATE_UNDEFINED = 255UL,
      FI_EN_DEFSET_STATE_CONFIRMED = 0UL,
      FI_EN_DEFSET_STATE_FAILED = 1UL
   };
   tenType enType;

   diaglog_fi_tcl_e8_DefSetServiceStatus(diaglog_fi_tcl_e8_DefSetServiceStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~diaglog_fi_tcl_e8_DefSetServiceStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_e8_DefSetServiceStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_e8_DefSetGroups : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_e8_DefSetGroups();
   enum tenType {
      FI_EN_DEFSET_GROUP_UNDEFIEND = 255UL,
      FI_EN_DEFSET_GROUP__NAVIGATION__DESTINATION_MEMORY = 0UL,
      FI_EN_DEFSET_GROUP__NAVIGATION__ROUTE_CALCULATION = 1UL,
      FI_EN_DEFSET_GROUP__NAVIGATION__ROUTE_AND_TRAFFIC_MESSAGE_INFORMATION = 2UL,
      FI_EN_DEFSET_GROUP__NAVIGATION__ROUTE_GUIDANCE = 3UL,
      FI_EN_DEFSET_GROUP__NAVIGATION__MAP_DISPLAY = 4UL,
      FI_EN_DEFSET_GROUP__NAVIGATION__PRESENTATION_FUNCTION = 5UL,
      FI_EN_DEFSET_GROUP__RADIO = 6UL,
      FI_EN_DEFSET_GROUP__INFOTAINMENT__SOURCE_HANDLING__LAST_SOURCE = 7UL,
      FI_EN_DEFSET_GROUP__INFOTAINMENT__SOURCE_HANDLING__AUX = 8UL,
      FI_EN_DEFSET_GROUP__INFOTAINMENT__AUDIO = 9UL,
      FI_EN_DEFSET_GROUP__INFOTAINMENT__AUDIO_CD = 10UL,
      FI_EN_DEFSET_GROUP__INFOTAINMENT__MP3 = 11UL,
      FI_EN_DEFSET_GROUP__INFOTAINMENT__CDC = 12UL,
      FI_EN_DEFSET_GROUP__MAINTENANCE = 13UL,
      FI_EN_DEFSET_GROUP__OFFICE__CLOCK = 14UL,
      FI_EN_DEFSET_GROUP__HMI_OUTLINE__USER_OPERATION_SERVICE = 15UL,
      FI_EN_DEFSET_GROUP__HMI_OUTLINE__LANGUAGE = 16UL,
      FI_EN_DEFSET_GROUP__HMI_OUTLINE__TTS = 17UL,
      FI_EN_DEFSET_GROUP__HMI_OUTLINE__VOICE_RECOGNITION = 18UL,
      FI_EN_DEFSET_GROUP__HMI_OUTLINE__DISPLAY_ADJUSTMENT = 19UL,
      FI_EN_DEFSET_GROUP__HMI_OUTLINE__DIMMING = 20UL,
      FI_EN_DEFSET_GROUP__SYSTEM_AND_POWER_MANAGEMENT = 21UL,
      FI_EN_DEFSET_GROUP__DEVELOPMENT_AND_TEST_MODE__MAUS = 22UL,
      FI_EN_DEFSET_GROUP__NAVIGATION__ROUTE_CALUCULATION__ROUTE_CRITRERIA = 23UL,
      FI_EN_DEFSET_GROUP__NAVIGATION__ROUTE_CALUCULATION__ROUTE_OPTIONS = 24UL,
      FI_EN_DEFSET_GROUP__NAVIGATION__TURN_BY_TURN_GUIDANCE = 25UL,
      FI_EN_DEFSET_GROUP__NAVIGATION__TURN_BY_TURN_GUIDANCE__GRAPHIC_DRIVING_REC = 26UL,
      FI_EN_DEFSET_GROUP__NAVIGATION__MAP_DISPLAY__ORIENTATION_AND_CLIPPING = 27UL,
      FI_EN_DEFSET_GROUP__NAVIGATION__MAP_DISPLAY__MAP_DISPLAY_MANIPULATION = 28UL,
      FI_EN_DEFSET_GROUP__NAVIGATION__MAP_DISPLAY__MAP_INFORMATION = 29UL,
      FI_EN_DEFSET_GROUP__HMI_OUTLINE__COLOR = 30UL,
      FI_EN_DEFSET_GROUP_ALL = 31UL
   };
   tenType enType;

   diaglog_fi_tcl_e8_DefSetGroups(diaglog_fi_tcl_e8_DefSetGroups::tenType newValue)
      :enType(newValue)
   {}

   virtual ~diaglog_fi_tcl_e8_DefSetGroups();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_e8_DefSetGroups& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_e8_DiagMausSetup : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_e8_DiagMausSetup();
   enum tenType {
      FI_EN_MAUS_STATE_UNDEFINED = 255UL,
      FI_EN_MAUS_STATE_RESERVED = 0UL,
      FI_EN_MAUS_STATE_ENABLE_TIME_SLOT = 1UL
   };
   tenType enType;

   diaglog_fi_tcl_e8_DiagMausSetup(diaglog_fi_tcl_e8_DiagMausSetup::tenType newValue)
      :enType(newValue)
   {}

   virtual ~diaglog_fi_tcl_e8_DiagMausSetup();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_e8_DiagMausSetup& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_e8_SimulatedKeys : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_e8_SimulatedKeys();
   enum tenType {
      FI_EN_KEY_CODE_SOFTKEY_UNDEFINED = 255UL,
      FI_EN_KEY_CODE_SOFTKEY_1 = 1UL,
      FI_EN_KEY_CODE_SOFTKEY_2 = 2UL,
      FI_EN_KEY_CODE_SOFTKEY_3 = 3UL,
      FI_EN_KEY_CODE_SOFTKEY_4 = 4UL,
      FI_EN_KEY_CODE_SOFTKEY_5 = 5UL,
      FI_EN_KEY_CODE_SOFTKEY_6 = 6UL,
      FI_EN_KEY_CODE_NAVKEY = 7UL,
      FI_EN_KEY_CODE_ROTARY_RIGHT = 8UL
   };
   tenType enType;

   diaglog_fi_tcl_e8_SimulatedKeys(diaglog_fi_tcl_e8_SimulatedKeys::tenType newValue)
      :enType(newValue)
   {}

   virtual ~diaglog_fi_tcl_e8_SimulatedKeys();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_e8_SimulatedKeys& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_KDSItemList : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_KDSItemList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_fi_tcl_KDSItemList& operator=(const diaglog_fi_tcl_KDSItemList& coRef);
   diaglog_fi_tcl_KDSItemList(const diaglog_fi_tcl_KDSItemList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU8, std::allocator<tU8> > itemList;
   virtual ~diaglog_fi_tcl_KDSItemList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_fi_tcl_KDSItemList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_ConfigItemList : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_ConfigItemList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_fi_tcl_ConfigItemList& operator=(const diaglog_fi_tcl_ConfigItemList& coRef);
   diaglog_fi_tcl_ConfigItemList(const diaglog_fi_tcl_ConfigItemList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU8, std::allocator<tU8> > itemList;
   virtual ~diaglog_fi_tcl_ConfigItemList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_fi_tcl_ConfigItemList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_RequestDataUDS : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_RequestDataUDS();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_fi_tcl_RequestDataUDS& operator=(const diaglog_fi_tcl_RequestDataUDS& coRef);
   diaglog_fi_tcl_RequestDataUDS(const diaglog_fi_tcl_RequestDataUDS& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU8, std::allocator<tU8> > itemList;
   virtual ~diaglog_fi_tcl_RequestDataUDS();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_fi_tcl_RequestDataUDS& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_ResponseDataUDS : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_ResponseDataUDS();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_fi_tcl_ResponseDataUDS& operator=(const diaglog_fi_tcl_ResponseDataUDS& coRef);
   diaglog_fi_tcl_ResponseDataUDS(const diaglog_fi_tcl_ResponseDataUDS& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU8, std::allocator<tU8> > itemList;
   virtual ~diaglog_fi_tcl_ResponseDataUDS();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_fi_tcl_ResponseDataUDS& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_DiagData : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_DiagData();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_fi_tcl_DiagData& operator=(const diaglog_fi_tcl_DiagData& coRef);
   diaglog_fi_tcl_DiagData(const diaglog_fi_tcl_DiagData& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU8, std::allocator<tU8> > itemList;
   virtual ~diaglog_fi_tcl_DiagData();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_fi_tcl_DiagData& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_e8_RCtrlSource : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_e8_RCtrlSource();
   enum tenType {
      FI_EN_RCTRL_SRC_UNKNOWN = 255UL,
      FI_EN_RCTRL_SRC_HMI = 0UL,
      FI_EN_RCTRL_SRC_TEF = 1UL,
      FI_EN_RCTRL_SRC_CUSTOMER = 2UL
   };
   tenType enType;

   diaglog_fi_tcl_e8_RCtrlSource(diaglog_fi_tcl_e8_RCtrlSource::tenType newValue)
      :enType(newValue)
   {}

   virtual ~diaglog_fi_tcl_e8_RCtrlSource();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_e8_RCtrlSource& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_e8_RCtrlCommand : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_e8_RCtrlCommand();
   enum tenType {
      FI_EN_RCTRL_CMD_DEACTIVATE = 0UL,
      FI_EN_RCTRL_CMD_ACTIVATE = 1UL
   };
   tenType enType;

   diaglog_fi_tcl_e8_RCtrlCommand(diaglog_fi_tcl_e8_RCtrlCommand::tenType newValue)
      :enType(newValue)
   {}

   virtual ~diaglog_fi_tcl_e8_RCtrlCommand();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_e8_RCtrlCommand& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_e8_RCtrlSignal : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_e8_RCtrlSignal();
   enum tenType {
      FI_EN_RCTRL_SIG_ALL = 255UL,
      FI_EN_RCTRL_SIG_FM_FREQUENCY = 0UL,
      FI_EN_RCTRL_SIG_AM_FREQUENCY = 1UL,
      FI_EN_RCTRL_SIG_AUDIO_SOURCE = 2UL,
      FI_EN_RCTRL_SIG_AUDIO_VOLUME = 3UL,
      FI_EN_RCTRL_SIG_AUDIO_FADER_AND_BALANCE = 4UL
   };
   tenType enType;

   diaglog_fi_tcl_e8_RCtrlSignal(diaglog_fi_tcl_e8_RCtrlSignal::tenType newValue)
      :enType(newValue)
   {}

   virtual ~diaglog_fi_tcl_e8_RCtrlSignal();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_e8_RCtrlSignal& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_e8_DiagRVCSignal : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_e8_DiagRVCSignal();
   enum tenType {
      FI_EN_EXT_VIDEO_SIGNAL_ON = 0UL,
      FI_EN_EXT_VIDEO_SIGNAL_OFF = 1UL
   };
   tenType enType;

   diaglog_fi_tcl_e8_DiagRVCSignal(diaglog_fi_tcl_e8_DiagRVCSignal::tenType newValue)
      :enType(newValue)
   {}

   virtual ~diaglog_fi_tcl_e8_DiagRVCSignal();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_e8_DiagRVCSignal& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_e8_CalibrationTable : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_e8_CalibrationTable();
   enum tenType {
      FI_EN_CALIBRATION_TABLE_ID_SYSTEM = 2UL,
      FI_EN_CALIBRATION_TABLE_ID_DISPLAY_INTERFACE = 3UL,
      FI_EN_CALIBRATION_TABLE_ID_BLUETOOTH = 4UL,
      FI_EN_CALIBRATION_TABLE_ID_NAVIGATION_SYSTEM = 5UL,
      FI_EN_CALIBRATION_TABLE_ID_NAVIGATION_ICON = 6UL,
      FI_EN_CALIBRATION_TABLE_ID_BRAND = 7UL,
      FI_EN_CALIBRATION_TABLE_ID_COUNTRY = 8UL,
      FI_EN_CALIBRATION_TABLE_ID_SPEECH_RECOGNITION = 9UL,
      FI_EN_CALIBRATION_TABLE_ID_HAND_FREE_TUNING = 10UL,
      FI_EN_CALIBRATION_TABLE_ID_REAR_VISION_CAMERA = 11UL
   };
   tenType enType;

   diaglog_fi_tcl_e8_CalibrationTable(diaglog_fi_tcl_e8_CalibrationTable::tenType newValue)
      :enType(newValue)
   {}

   virtual ~diaglog_fi_tcl_e8_CalibrationTable();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_e8_CalibrationTable& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_CalibrationValue : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_CalibrationValue();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_fi_tcl_CalibrationValue& operator=(const diaglog_fi_tcl_CalibrationValue& coRef);
   diaglog_fi_tcl_CalibrationValue(const diaglog_fi_tcl_CalibrationValue& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU8, std::allocator<tU8> > ByteValue;
   virtual ~diaglog_fi_tcl_CalibrationValue();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_fi_tcl_CalibrationValue& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_e8_CalibrationTimeStampMonth : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_e8_CalibrationTimeStampMonth();
   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_JANUARY = 1UL,
      FI_EN_FEBRUARY = 2UL,
      FI_EN_MARCH = 3UL,
      FI_EN_APRIL = 4UL,
      FI_EN_MAY = 5UL,
      FI_EN_JUNE = 6UL,
      FI_EN_JULY = 7UL,
      FI_EN_AUGUST = 8UL,
      FI_EN_SEPTEMBER = 9UL,
      FI_EN_OCTOBER = 10UL,
      FI_EN_NOVEMBER = 11UL,
      FI_EN_DECEMBER = 12UL
   };
   tenType enType;

   diaglog_fi_tcl_e8_CalibrationTimeStampMonth(diaglog_fi_tcl_e8_CalibrationTimeStampMonth::tenType newValue)
      :enType(newValue)
   {}

   virtual ~diaglog_fi_tcl_e8_CalibrationTimeStampMonth();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_e8_CalibrationTimeStampMonth& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_CalibrationTimeStamp : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_CalibrationTimeStamp();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_fi_tcl_CalibrationTimeStamp& operator=(const diaglog_fi_tcl_CalibrationTimeStamp& coRef);
   diaglog_fi_tcl_CalibrationTimeStamp(const diaglog_fi_tcl_CalibrationTimeStamp& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Hours;
   tU8 Minutes;
   tU8 Seconds;
   tU8 Day;
   tU8 Month;
   tU8 Year;
   virtual ~diaglog_fi_tcl_CalibrationTimeStamp();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_fi_tcl_CalibrationTimeStamp& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_AlphaCode : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_AlphaCode();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_fi_tcl_AlphaCode& operator=(const diaglog_fi_tcl_AlphaCode& coRef);
   diaglog_fi_tcl_AlphaCode(const diaglog_fi_tcl_AlphaCode& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU8, std::allocator<tU8> > Letter;
   virtual ~diaglog_fi_tcl_AlphaCode();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_fi_tcl_AlphaCode& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_e8_CalibrationParameterSize : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_e8_CalibrationParameterSize();
   enum tenType {
      FI_EN_CALIBRATION_SIZE_BIT = 0UL,
      FI_EN_CALIBRATION_SIZE_BYTE = 1UL,
      FI_EN_CALIBRATION_SIZE_WORD = 2UL,
      FI_EN_CALIBRATION_SIZE_DWORD = 4UL
   };
   tenType enType;

   diaglog_fi_tcl_e8_CalibrationParameterSize(diaglog_fi_tcl_e8_CalibrationParameterSize::tenType newValue)
      :enType(newValue)
   {}

   virtual ~diaglog_fi_tcl_e8_CalibrationParameterSize();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_e8_CalibrationParameterSize& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_e8_KdsViaUsbUpdateStatus : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_e8_KdsViaUsbUpdateStatus();
   enum tenType {
      FI_EN_UNDEFINED = 255UL,
      FI_EN_CONFIGUPDATEINPROGRESS = 0UL,
      FI_EN_CONFIGUPDATESUCCESS = 1UL,
      FI_EN_CONFIGUPDATEFAILED = 2UL
   };
   tenType enType;

   diaglog_fi_tcl_e8_KdsViaUsbUpdateStatus(diaglog_fi_tcl_e8_KdsViaUsbUpdateStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~diaglog_fi_tcl_e8_KdsViaUsbUpdateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_e8_KdsViaUsbUpdateStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

class diaglog_fi_tcl_AntiTheftStatus : public diaglog_fi_tclVisitableTypeBase
{
public:

   diaglog_fi_tcl_AntiTheftStatus();
   enum tenType {
      FI_EN_HU_UNLOCKED = 0UL,
      FI_EN_HU_LOCKED = 1UL,
      FI_EN_VID_MISSING = 2UL,
      FI_EN_INVALID = 255UL
   };
   tenType enType;

   diaglog_fi_tcl_AntiTheftStatus(diaglog_fi_tcl_AntiTheftStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~diaglog_fi_tcl_AntiTheftStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const diaglog_fi_tcl_AntiTheftStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(diaglog_fi_tclVisitorBase& rfoVisitor);
};

#endif
